/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.models.utils;

import com.intel.analytics.bigdl.dllib.feature.dataset.segmentation.COCODataset;
import com.intel.analytics.bigdl.dllib.feature.dataset.segmentation.COCODataset$;
import com.intel.analytics.bigdl.dllib.feature.dataset.segmentation.COCOImage;
import com.intel.analytics.bigdl.dllib.feature.dataset.segmentation.COCOSerializeContext;
import com.intel.analytics.bigdl.dllib.models.utils.COCOSeqFileGenerator;
import com.intel.analytics.bigdl.dllib.models.utils.COCOSeqFileGenerator$$anonfun$main$1$;
import com.intel.analytics.bigdl.dllib.models.utils.COCOSeqFileGenerator$COCOSeqFileGeneratorParams$;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class COCOSeqFileGenerator$ {
    public static final COCOSeqFileGenerator$ MODULE$;
    private final OptionParser<COCOSeqFileGenerator.COCOSeqFileGeneratorParams> parser;

    static {
        new COCOSeqFileGenerator$();
    }

    private OptionParser<COCOSeqFileGenerator.COCOSeqFileGeneratorParams> parser() {
        return this.parser;
    }

    public void main(String[] args) {
        this.parser().parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), new COCOSeqFileGenerator.COCOSeqFileGeneratorParams(COCOSeqFileGenerator$COCOSeqFileGeneratorParams$.MODULE$.apply$default$1(), COCOSeqFileGenerator$COCOSeqFileGeneratorParams$.MODULE$.apply$default$2(), COCOSeqFileGenerator$COCOSeqFileGeneratorParams$.MODULE$.apply$default$3(), COCOSeqFileGenerator$COCOSeqFileGeneratorParams$.MODULE$.apply$default$4(), COCOSeqFileGenerator$COCOSeqFileGeneratorParams$.MODULE$.apply$default$5())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(COCOSeqFileGenerator.COCOSeqFileGeneratorParams param) {
                Predef$.MODULE$.println((Object)"Loading COCO metadata");
                COCODataset meta = COCODataset$.MODULE$.load(param.metaPath(), param.folder());
                Predef$.MODULE$.println((Object)"Metadata loaded");
                Configuration conf = new Configuration();
                AtomicInteger doneCount = new AtomicInteger(0);
                ParArray tasks = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])meta.images()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean apply(COCOImage img) {
                        void var3_3;
                        boolean valid;
                        java.nio.file.Path path = img.path();
                        boolean bl = valid = Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
                        if (!valid) {
                            System.err.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Warning] The image file ", " does not exist.\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getFileName()})));
                        }
                        return (boolean)var3_3;
                    }
                })).grouped(param.blockSize()).zipWithIndex().toArray(ClassTag$.MODULE$.apply(Tuple2.class))).par();
                tasks.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(param.parallel())));
                tasks.foreach((Function1)new Serializable(this, meta, conf, doneCount, param){
                    public static final long serialVersionUID = 0L;
                    public final COCODataset meta$1;
                    private final Configuration conf$1;
                    public final AtomicInteger doneCount$1;
                    private final COCOSeqFileGenerator.COCOSeqFileGeneratorParams param$1;

                    public final void apply(Tuple2<COCOImage[], Object> x0$1) {
                        Tuple2<COCOImage[], Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            COCOImage[] imgs = (COCOImage[])tuple2._1();
                            int blkId = tuple2._2$mcI$sp();
                            Path outFile = new Path(this.param$1.output(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coco-seq-", ".seq"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blkId)})));
                            BytesWritable key = new BytesWritable();
                            BytesWritable value2 = new BytesWritable();
                            SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)this.conf$1, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outFile), SequenceFile.Writer.keyClass(key.getClass()), SequenceFile.Writer.valueClass(value2.getClass()), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new BZip2Codec())});
                            COCOSerializeContext context = new COCOSerializeContext();
                            Predef$.MODULE$.refArrayOps((Object[])imgs).foreach((Function1)new Serializable(this, key, value2, writer, context){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$main$1$$anonfun$apply$1 $outer;
                                private final BytesWritable key$1;
                                private final BytesWritable value$1;
                                private final SequenceFile.Writer writer$1;
                                private final COCOSerializeContext context$1;

                                public final void apply(COCOImage img) {
                                    this.context$1.clear();
                                    this.context$1.dump(img.fileName());
                                    img.dumpTo(this.context$1);
                                    this.context$1.dump(COCODataset$.MODULE$.MAGIC_NUM());
                                    byte[] keyBytes = this.context$1.toByteArray();
                                    this.key$1.set(keyBytes, 0, keyBytes.length);
                                    byte[] bytes = img.data();
                                    this.value$1.set(bytes, 0, bytes.length);
                                    this.writer$1.append((Writable)this.key$1, (Writable)this.value$1);
                                    int cnt = this.$outer.doneCount$1.incrementAndGet();
                                    if (cnt % 500 == 0) {
                                        System.err.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\r", " / ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cnt), BoxesRunTime.boxToInteger((int)this.$outer.meta$1.images().length), BoxesRunTime.boxToFloat((float)((float)cnt / (float)this.$outer.meta$1.images().length))})));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.key$1 = key$1;
                                    this.value$1 = value$1;
                                    this.writer$1 = writer$1;
                                    this.context$1 = context$1;
                                }
                            });
                            writer.close();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.meta$1 = meta$1;
                        this.conf$1 = conf$1;
                        this.doneCount$1 = doneCount$1;
                        this.param$1 = param$1;
                    }
                });
                System.err.print("\n");
            }
        });
    }

    private COCOSeqFileGenerator$() {
        MODULE$ = this;
        this.parser = new OptionParser<COCOSeqFileGenerator.COCOSeqFileGeneratorParams>(){
            {
                this.head((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BigDL COCO Sequence File Generator"}));
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the COCO image files").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final COCOSeqFileGenerator.COCOSeqFileGeneratorParams apply(String x, COCOSeqFileGenerator.COCOSeqFileGeneratorParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5());
                    }
                });
                this.opt('o', "output folder", Read$.MODULE$.stringRead()).text("where you put the generated seq files").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final COCOSeqFileGenerator.COCOSeqFileGeneratorParams apply(String x, COCOSeqFileGenerator.COCOSeqFileGeneratorParams c) {
                        String x$1 = x;
                        String x$2 = c.copy$default$1();
                        String x$3 = c.copy$default$2();
                        int x$4 = c.copy$default$4();
                        int x$5 = c.copy$default$5();
                        return c.copy(x$2, x$3, x$1, x$4, x$5);
                    }
                });
                this.opt('p', "parallel", Read$.MODULE$.intRead()).text("parallel num").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final COCOSeqFileGenerator.COCOSeqFileGeneratorParams apply(int x, COCOSeqFileGenerator.COCOSeqFileGeneratorParams c) {
                        int x$6 = x;
                        String x$7 = c.copy$default$1();
                        String x$8 = c.copy$default$2();
                        String x$9 = c.copy$default$3();
                        int x$10 = c.copy$default$5();
                        return c.copy(x$7, x$8, x$9, x$6, x$10);
                    }
                });
                this.opt('b', "blockSize", Read$.MODULE$.intRead()).text("block size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final COCOSeqFileGenerator.COCOSeqFileGeneratorParams apply(int x, COCOSeqFileGenerator.COCOSeqFileGeneratorParams c) {
                        int x$11 = x;
                        String x$12 = c.copy$default$1();
                        String x$13 = c.copy$default$2();
                        String x$14 = c.copy$default$3();
                        int x$15 = c.copy$default$4();
                        return c.copy(x$12, x$13, x$14, x$15, x$11);
                    }
                });
                this.opt('m', "metaPath", Read$.MODULE$.stringRead()).text("metadata json file path").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final COCOSeqFileGenerator.COCOSeqFileGeneratorParams apply(String x, COCOSeqFileGenerator.COCOSeqFileGeneratorParams c) {
                        String x$16 = x;
                        String x$17 = c.copy$default$1();
                        String x$18 = c.copy$default$3();
                        int x$19 = c.copy$default$4();
                        int x$20 = c.copy$default$5();
                        return c.copy(x$17, x$16, x$18, x$19, x$20);
                    }
                });
            }
        };
    }
}

