/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.models.resnet;

import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.models.resnet.Utils;
import com.intel.analytics.bigdl.dllib.utils.File$;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scopt.OptionParser;
import scopt.Read$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final OptionParser<Utils.TrainParams> trainParser;
    private final OptionParser<Utils.TestParams> testParser;

    static {
        new Utils$();
    }

    public OptionParser<Utils.TrainParams> trainParser() {
        return this.trainParser;
    }

    public OptionParser<Utils.TestParams> testParser() {
        return this.testParser;
    }

    public ByteRecord[] loadTrain(String dataFile) {
        String[] allFiles = (String[])((Object[])new String[]{new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_1.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_2.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_3.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_4.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_5.bin").toString()});
        ArrayBuffer result2 = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])allFiles).foreach((Function1)new Serializable(result2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer result$1;

            public final void apply(String x$1) {
                Utils$.MODULE$.load(x$1, (ArrayBuffer<ByteRecord>)this.result$1);
            }
            {
                this.result$1 = result$1;
            }
        });
        return (ByteRecord[])result2.toArray(ClassTag$.MODULE$.apply(ByteRecord.class));
    }

    public ByteRecord[] loadTest(String dataFile) {
        ArrayBuffer result2 = new ArrayBuffer();
        String testFile = new StringBuilder().append((Object)dataFile).append((Object)"/test_batch.bin").toString();
        this.load(testFile, (ArrayBuffer<ByteRecord>)result2);
        return (ByteRecord[])result2.toArray(ClassTag$.MODULE$.apply(ByteRecord.class));
    }

    public void load(String featureFile, ArrayBuffer<ByteRecord> result2) {
        int rowNum = 32;
        int colNum = 32;
        int imageOffset = rowNum * colNum * 3 + 1;
        int channelOffset = rowNum * colNum;
        int bufferOffset = 8;
        ByteBuffer featureBuffer = featureFile.startsWith(File$.MODULE$.hdfsPrefix()) ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(featureFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(featureFile, new String[0])));
        byte[] featureArray = featureBuffer.array();
        int featureCount = featureArray.length / (rowNum * colNum * 3 + 1);
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum * 3 + bufferOffset];
            ByteBuffer byteBuffer = ByteBuffer.wrap(img);
            byteBuffer.putInt(rowNum);
            byteBuffer.putInt(colNum);
            float label = featureArray[i * imageOffset];
            int start2 = i * imageOffset + 1;
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[(x + y * colNum) * 3 + 2 + bufferOffset] = featureArray[start2 + x + y * colNum];
                    img[(x + y * colNum) * 3 + 1 + bufferOffset] = featureArray[start2 + x + y * colNum + channelOffset];
                    img[(x + y * colNum) * 3 + bufferOffset] = featureArray[start2 + x + y * colNum + 2 * channelOffset];
                }
            }
            result2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ByteRecord[]{new ByteRecord(img, label + 1.0f)}));
        }
    }

    private Utils$() {
        MODULE$ = this;
        this.trainParser = new OptionParser<Utils.TrainParams>(){
            {
                this.head((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train ResNet model on single node"}));
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put your training files").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18(), c.copy$default$19());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$8 = new Some((Object)x);
                        String x$9 = c.copy$default$1();
                        Option<String> x$10 = c.copy$default$2();
                        Option<String> x$11 = c.copy$default$4();
                        boolean x$12 = c.copy$default$5();
                        int x$13 = c.copy$default$6();
                        int x$14 = c.copy$default$7();
                        String x$15 = c.copy$default$8();
                        int x$16 = c.copy$default$9();
                        int x$17 = c.copy$default$10();
                        double x$18 = c.copy$default$11();
                        double x$19 = c.copy$default$12();
                        double x$20 = c.copy$default$13();
                        double x$21 = c.copy$default$14();
                        boolean x$22 = c.copy$default$15();
                        boolean x$23 = c.copy$default$16();
                        int x$24 = c.copy$default$17();
                        double x$25 = c.copy$default$18();
                        Option<String> x$26 = c.copy$default$19();
                        return c.copy(x$9, x$10, (Option<String>)x$8, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
                    }
                });
                this.opt("state", Read$.MODULE$.stringRead()).text("state snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$27 = new Some((Object)x);
                        String x$28 = c.copy$default$1();
                        Option<String> x$29 = c.copy$default$2();
                        Option<String> x$30 = c.copy$default$3();
                        boolean x$31 = c.copy$default$5();
                        int x$32 = c.copy$default$6();
                        int x$33 = c.copy$default$7();
                        String x$34 = c.copy$default$8();
                        int x$35 = c.copy$default$9();
                        int x$36 = c.copy$default$10();
                        double x$37 = c.copy$default$11();
                        double x$38 = c.copy$default$12();
                        double x$39 = c.copy$default$13();
                        double x$40 = c.copy$default$14();
                        boolean x$41 = c.copy$default$15();
                        boolean x$42 = c.copy$default$16();
                        int x$43 = c.copy$default$17();
                        double x$44 = c.copy$default$18();
                        Option<String> x$45 = c.copy$default$19();
                        return c.copy(x$28, x$29, x$30, (Option<String>)x$27, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
                    }
                });
                this.opt("cache", Read$.MODULE$.stringRead()).text("where to cache the model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$46 = new Some((Object)x);
                        String x$47 = c.copy$default$1();
                        Option<String> x$48 = c.copy$default$3();
                        Option<String> x$49 = c.copy$default$4();
                        boolean x$50 = c.copy$default$5();
                        int x$51 = c.copy$default$6();
                        int x$52 = c.copy$default$7();
                        String x$53 = c.copy$default$8();
                        int x$54 = c.copy$default$9();
                        int x$55 = c.copy$default$10();
                        double x$56 = c.copy$default$11();
                        double x$57 = c.copy$default$12();
                        double x$58 = c.copy$default$13();
                        double x$59 = c.copy$default$14();
                        boolean x$60 = c.copy$default$15();
                        boolean x$61 = c.copy$default$16();
                        int x$62 = c.copy$default$17();
                        double x$63 = c.copy$default$18();
                        Option<String> x$64 = c.copy$default$19();
                        return c.copy(x$47, (Option<String>)x$46, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64);
                    }
                });
                this.opt("optnet", Read$.MODULE$.booleanRead()).text("shared gradients and caches to reduce memory usage").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(boolean x, Utils.TrainParams c) {
                        boolean x$65 = x;
                        String x$66 = c.copy$default$1();
                        Option<String> x$67 = c.copy$default$2();
                        Option<String> x$68 = c.copy$default$3();
                        Option<String> x$69 = c.copy$default$4();
                        int x$70 = c.copy$default$6();
                        int x$71 = c.copy$default$7();
                        String x$72 = c.copy$default$8();
                        int x$73 = c.copy$default$9();
                        int x$74 = c.copy$default$10();
                        double x$75 = c.copy$default$11();
                        double x$76 = c.copy$default$12();
                        double x$77 = c.copy$default$13();
                        double x$78 = c.copy$default$14();
                        boolean x$79 = c.copy$default$15();
                        boolean x$80 = c.copy$default$16();
                        int x$81 = c.copy$default$17();
                        double x$82 = c.copy$default$18();
                        Option<String> x$83 = c.copy$default$19();
                        return c.copy(x$66, x$67, x$68, x$69, x$65, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83);
                    }
                });
                this.opt("depth", Read$.MODULE$.intRead()).text("depth of ResNet, 18 | 20 | 34 | 50 | 101 | 152 | 200").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$84 = x;
                        String x$85 = c.copy$default$1();
                        Option<String> x$86 = c.copy$default$2();
                        Option<String> x$87 = c.copy$default$3();
                        Option<String> x$88 = c.copy$default$4();
                        boolean x$89 = c.copy$default$5();
                        int x$90 = c.copy$default$7();
                        String x$91 = c.copy$default$8();
                        int x$92 = c.copy$default$9();
                        int x$93 = c.copy$default$10();
                        double x$94 = c.copy$default$11();
                        double x$95 = c.copy$default$12();
                        double x$96 = c.copy$default$13();
                        double x$97 = c.copy$default$14();
                        boolean x$98 = c.copy$default$15();
                        boolean x$99 = c.copy$default$16();
                        int x$100 = c.copy$default$17();
                        double x$101 = c.copy$default$18();
                        Option<String> x$102 = c.copy$default$19();
                        return c.copy(x$85, x$86, x$87, x$88, x$89, x$84, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102);
                    }
                });
                this.opt("classes", Read$.MODULE$.intRead()).text("classes of ResNet").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$103 = x;
                        String x$104 = c.copy$default$1();
                        Option<String> x$105 = c.copy$default$2();
                        Option<String> x$106 = c.copy$default$3();
                        Option<String> x$107 = c.copy$default$4();
                        boolean x$108 = c.copy$default$5();
                        int x$109 = c.copy$default$6();
                        String x$110 = c.copy$default$8();
                        int x$111 = c.copy$default$9();
                        int x$112 = c.copy$default$10();
                        double x$113 = c.copy$default$11();
                        double x$114 = c.copy$default$12();
                        double x$115 = c.copy$default$13();
                        double x$116 = c.copy$default$14();
                        boolean x$117 = c.copy$default$15();
                        boolean x$118 = c.copy$default$16();
                        int x$119 = c.copy$default$17();
                        double x$120 = c.copy$default$18();
                        Option<String> x$121 = c.copy$default$19();
                        return c.copy(x$104, x$105, x$106, x$107, x$108, x$109, x$103, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121);
                    }
                });
                this.opt("shortcutType", Read$.MODULE$.stringRead()).text("shortcutType of ResNet, A | B | C").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        String x$122 = x;
                        String x$123 = c.copy$default$1();
                        Option<String> x$124 = c.copy$default$2();
                        Option<String> x$125 = c.copy$default$3();
                        Option<String> x$126 = c.copy$default$4();
                        boolean x$127 = c.copy$default$5();
                        int x$128 = c.copy$default$6();
                        int x$129 = c.copy$default$7();
                        int x$130 = c.copy$default$9();
                        int x$131 = c.copy$default$10();
                        double x$132 = c.copy$default$11();
                        double x$133 = c.copy$default$12();
                        double x$134 = c.copy$default$13();
                        double x$135 = c.copy$default$14();
                        boolean x$136 = c.copy$default$15();
                        boolean x$137 = c.copy$default$16();
                        int x$138 = c.copy$default$17();
                        double x$139 = c.copy$default$18();
                        Option<String> x$140 = c.copy$default$19();
                        return c.copy(x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$122, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
                    }
                });
                this.opt("batchSize", Read$.MODULE$.intRead()).text("batchSize of ResNet, 64 | 128 | 256 | ..").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$141 = x;
                        String x$142 = c.copy$default$1();
                        Option<String> x$143 = c.copy$default$2();
                        Option<String> x$144 = c.copy$default$3();
                        Option<String> x$145 = c.copy$default$4();
                        boolean x$146 = c.copy$default$5();
                        int x$147 = c.copy$default$6();
                        int x$148 = c.copy$default$7();
                        String x$149 = c.copy$default$8();
                        int x$150 = c.copy$default$10();
                        double x$151 = c.copy$default$11();
                        double x$152 = c.copy$default$12();
                        double x$153 = c.copy$default$13();
                        double x$154 = c.copy$default$14();
                        boolean x$155 = c.copy$default$15();
                        boolean x$156 = c.copy$default$16();
                        int x$157 = c.copy$default$17();
                        double x$158 = c.copy$default$18();
                        Option<String> x$159 = c.copy$default$19();
                        return c.copy(x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$141, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159);
                    }
                });
                this.opt("nEpochs", Read$.MODULE$.intRead()).text("number of epochs of ResNet; default is 165").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$160 = x;
                        String x$161 = c.copy$default$1();
                        Option<String> x$162 = c.copy$default$2();
                        Option<String> x$163 = c.copy$default$3();
                        Option<String> x$164 = c.copy$default$4();
                        boolean x$165 = c.copy$default$5();
                        int x$166 = c.copy$default$6();
                        int x$167 = c.copy$default$7();
                        String x$168 = c.copy$default$8();
                        int x$169 = c.copy$default$9();
                        double x$170 = c.copy$default$11();
                        double x$171 = c.copy$default$12();
                        double x$172 = c.copy$default$13();
                        double x$173 = c.copy$default$14();
                        boolean x$174 = c.copy$default$15();
                        boolean x$175 = c.copy$default$16();
                        int x$176 = c.copy$default$17();
                        double x$177 = c.copy$default$18();
                        Option<String> x$178 = c.copy$default$19();
                        return c.copy(x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$160, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178);
                    }
                });
                this.opt("learningRate", Read$.MODULE$.doubleRead()).text("initial learning rate of ResNet; default is 0.1").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$179 = x;
                        String x$180 = c.copy$default$1();
                        Option<String> x$181 = c.copy$default$2();
                        Option<String> x$182 = c.copy$default$3();
                        Option<String> x$183 = c.copy$default$4();
                        boolean x$184 = c.copy$default$5();
                        int x$185 = c.copy$default$6();
                        int x$186 = c.copy$default$7();
                        String x$187 = c.copy$default$8();
                        int x$188 = c.copy$default$9();
                        int x$189 = c.copy$default$10();
                        double x$190 = c.copy$default$12();
                        double x$191 = c.copy$default$13();
                        double x$192 = c.copy$default$14();
                        boolean x$193 = c.copy$default$15();
                        boolean x$194 = c.copy$default$16();
                        int x$195 = c.copy$default$17();
                        double x$196 = c.copy$default$18();
                        Option<String> x$197 = c.copy$default$19();
                        return c.copy(x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$179, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197);
                    }
                });
                this.opt("momentum", Read$.MODULE$.doubleRead()).text("momentum of ResNet; default is 0.9").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$198 = x;
                        String x$199 = c.copy$default$1();
                        Option<String> x$200 = c.copy$default$2();
                        Option<String> x$201 = c.copy$default$3();
                        Option<String> x$202 = c.copy$default$4();
                        boolean x$203 = c.copy$default$5();
                        int x$204 = c.copy$default$6();
                        int x$205 = c.copy$default$7();
                        String x$206 = c.copy$default$8();
                        int x$207 = c.copy$default$9();
                        int x$208 = c.copy$default$10();
                        double x$209 = c.copy$default$11();
                        double x$210 = c.copy$default$12();
                        double x$211 = c.copy$default$14();
                        boolean x$212 = c.copy$default$15();
                        boolean x$213 = c.copy$default$16();
                        int x$214 = c.copy$default$17();
                        double x$215 = c.copy$default$18();
                        Option<String> x$216 = c.copy$default$19();
                        return c.copy(x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$198, x$211, x$212, x$213, x$214, x$215, x$216);
                    }
                });
                this.opt("weightDecay", Read$.MODULE$.doubleRead()).text("weightDecay of ResNet; default is 1e-4").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$217 = x;
                        String x$218 = c.copy$default$1();
                        Option<String> x$219 = c.copy$default$2();
                        Option<String> x$220 = c.copy$default$3();
                        Option<String> x$221 = c.copy$default$4();
                        boolean x$222 = c.copy$default$5();
                        int x$223 = c.copy$default$6();
                        int x$224 = c.copy$default$7();
                        String x$225 = c.copy$default$8();
                        int x$226 = c.copy$default$9();
                        int x$227 = c.copy$default$10();
                        double x$228 = c.copy$default$11();
                        double x$229 = c.copy$default$13();
                        double x$230 = c.copy$default$14();
                        boolean x$231 = c.copy$default$15();
                        boolean x$232 = c.copy$default$16();
                        int x$233 = c.copy$default$17();
                        double x$234 = c.copy$default$18();
                        Option<String> x$235 = c.copy$default$19();
                        return c.copy(x$218, x$219, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$217, x$229, x$230, x$231, x$232, x$233, x$234, x$235);
                    }
                });
                this.opt("dampening", Read$.MODULE$.doubleRead()).text("dampening of ResNet; default is 0.0").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$236 = x;
                        String x$237 = c.copy$default$1();
                        Option<String> x$238 = c.copy$default$2();
                        Option<String> x$239 = c.copy$default$3();
                        Option<String> x$240 = c.copy$default$4();
                        boolean x$241 = c.copy$default$5();
                        int x$242 = c.copy$default$6();
                        int x$243 = c.copy$default$7();
                        String x$244 = c.copy$default$8();
                        int x$245 = c.copy$default$9();
                        int x$246 = c.copy$default$10();
                        double x$247 = c.copy$default$11();
                        double x$248 = c.copy$default$12();
                        double x$249 = c.copy$default$13();
                        boolean x$250 = c.copy$default$15();
                        boolean x$251 = c.copy$default$16();
                        int x$252 = c.copy$default$17();
                        double x$253 = c.copy$default$18();
                        Option<String> x$254 = c.copy$default$19();
                        return c.copy(x$237, x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$236, x$250, x$251, x$252, x$253, x$254);
                    }
                });
                this.opt("nesterov", Read$.MODULE$.booleanRead()).text("nesterov of ResNet; default is trye").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(boolean x, Utils.TrainParams c) {
                        boolean x$255 = x;
                        String x$256 = c.copy$default$1();
                        Option<String> x$257 = c.copy$default$2();
                        Option<String> x$258 = c.copy$default$3();
                        Option<String> x$259 = c.copy$default$4();
                        boolean x$260 = c.copy$default$5();
                        int x$261 = c.copy$default$6();
                        int x$262 = c.copy$default$7();
                        String x$263 = c.copy$default$8();
                        int x$264 = c.copy$default$9();
                        int x$265 = c.copy$default$10();
                        double x$266 = c.copy$default$11();
                        double x$267 = c.copy$default$12();
                        double x$268 = c.copy$default$13();
                        double x$269 = c.copy$default$14();
                        boolean x$270 = c.copy$default$16();
                        int x$271 = c.copy$default$17();
                        double x$272 = c.copy$default$18();
                        Option<String> x$273 = c.copy$default$19();
                        return c.copy(x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$255, x$270, x$271, x$272, x$273);
                    }
                });
                this.opt('g', "graphModel", Read$.MODULE$.unitRead()).text("use graph model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x, Utils.TrainParams c) {
                        boolean x$274 = true;
                        String x$275 = c.copy$default$1();
                        Option<String> x$276 = c.copy$default$2();
                        Option<String> x$277 = c.copy$default$3();
                        Option<String> x$278 = c.copy$default$4();
                        boolean x$279 = c.copy$default$5();
                        int x$280 = c.copy$default$6();
                        int x$281 = c.copy$default$7();
                        String x$282 = c.copy$default$8();
                        int x$283 = c.copy$default$9();
                        int x$284 = c.copy$default$10();
                        double x$285 = c.copy$default$11();
                        double x$286 = c.copy$default$12();
                        double x$287 = c.copy$default$13();
                        double x$288 = c.copy$default$14();
                        boolean x$289 = c.copy$default$15();
                        int x$290 = c.copy$default$17();
                        double x$291 = c.copy$default$18();
                        Option<String> x$292 = c.copy$default$19();
                        return c.copy(x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$274, x$290, x$291, x$292);
                    }
                });
                this.opt("warmupEpoch", Read$.MODULE$.intRead()).text("warmup epoch").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$293 = x;
                        String x$294 = c.copy$default$1();
                        Option<String> x$295 = c.copy$default$2();
                        Option<String> x$296 = c.copy$default$3();
                        Option<String> x$297 = c.copy$default$4();
                        boolean x$298 = c.copy$default$5();
                        int x$299 = c.copy$default$6();
                        int x$300 = c.copy$default$7();
                        String x$301 = c.copy$default$8();
                        int x$302 = c.copy$default$9();
                        int x$303 = c.copy$default$10();
                        double x$304 = c.copy$default$11();
                        double x$305 = c.copy$default$12();
                        double x$306 = c.copy$default$13();
                        double x$307 = c.copy$default$14();
                        boolean x$308 = c.copy$default$15();
                        boolean x$309 = c.copy$default$16();
                        double x$310 = c.copy$default$18();
                        Option<String> x$311 = c.copy$default$19();
                        return c.copy(x$294, x$295, x$296, x$297, x$298, x$299, x$300, x$301, x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$293, x$310, x$311);
                    }
                });
                this.opt("maxLr", Read$.MODULE$.doubleRead()).text("maxLr").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$312 = x;
                        String x$313 = c.copy$default$1();
                        Option<String> x$314 = c.copy$default$2();
                        Option<String> x$315 = c.copy$default$3();
                        Option<String> x$316 = c.copy$default$4();
                        boolean x$317 = c.copy$default$5();
                        int x$318 = c.copy$default$6();
                        int x$319 = c.copy$default$7();
                        String x$320 = c.copy$default$8();
                        int x$321 = c.copy$default$9();
                        int x$322 = c.copy$default$10();
                        double x$323 = c.copy$default$11();
                        double x$324 = c.copy$default$12();
                        double x$325 = c.copy$default$13();
                        double x$326 = c.copy$default$14();
                        boolean x$327 = c.copy$default$15();
                        boolean x$328 = c.copy$default$16();
                        int x$329 = c.copy$default$17();
                        Option<String> x$330 = c.copy$default$19();
                        return c.copy(x$313, x$314, x$315, x$316, x$317, x$318, x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$312, x$330);
                    }
                });
                this.opt("optimizerVersion", Read$.MODULE$.stringRead()).text("state optimizer version").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$331 = new Some((Object)x);
                        String x$332 = c.copy$default$1();
                        Option<String> x$333 = c.copy$default$2();
                        Option<String> x$334 = c.copy$default$3();
                        Option<String> x$335 = c.copy$default$4();
                        boolean x$336 = c.copy$default$5();
                        int x$337 = c.copy$default$6();
                        int x$338 = c.copy$default$7();
                        String x$339 = c.copy$default$8();
                        int x$340 = c.copy$default$9();
                        int x$341 = c.copy$default$10();
                        double x$342 = c.copy$default$11();
                        double x$343 = c.copy$default$12();
                        double x$344 = c.copy$default$13();
                        double x$345 = c.copy$default$14();
                        boolean x$346 = c.copy$default$15();
                        boolean x$347 = c.copy$default$16();
                        int x$348 = c.copy$default$17();
                        double x$349 = c.copy$default$18();
                        return c.copy(x$332, x$333, x$334, x$335, x$336, x$337, x$338, x$339, x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, (Option<String>)x$331);
                    }
                });
            }
        };
        this.testParser = new OptionParser<Utils.TestParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("the location of Cifar10 dataset").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3());
                    }
                });
                this.opt('m', "model", Read$.MODULE$.stringRead()).text("the location of model snapshot").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        String x$2 = x;
                        String x$3 = c.copy$default$1();
                        int x$4 = c.copy$default$3();
                        return c.copy(x$3, x$2, x$4);
                    }
                }).required().required();
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(int x, Utils.TestParams c) {
                        int x$5 = x;
                        String x$6 = c.copy$default$1();
                        String x$7 = c.copy$default$2();
                        return c.copy(x$6, x$7, x$5);
                    }
                });
            }
        };
    }
}

