/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.models.maskrcnn;

import com.intel.analytics.bigdl.dllib.models.maskrcnn.Utils$;
import com.intel.analytics.bigdl.dllib.models.maskrcnn.Utils$$anonfun$bilinear$1$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public void expandBoxes(Tensor<Object> bbox, Tensor<Object> bboxExpand, float scale) {
        Log4Error$.MODULE$.invalidInputError(bbox.nElement() == 4 && bboxExpand.nElement() == 4 && bbox.dim() == 1 && bboxExpand.dim() == 1, "Box and expanded box should have 4 elements with one dim", Log4Error$.MODULE$.invalidInputError$default$3());
        float box0 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(1));
        float box1 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(2));
        float box2 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(3));
        float box3 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(4));
        float wHalf = (box2 - box0) * 0.5f;
        float hHalf = (box3 - box1) * 0.5f;
        float x_c = (box2 + box0) * 0.5f;
        float y_c = (box3 + box1) * 0.5f;
        bboxExpand.setValue(1, BoxesRunTime.boxToFloat((float)(x_c - (wHalf *= scale))));
        bboxExpand.setValue(3, BoxesRunTime.boxToFloat((float)(x_c + wHalf)));
        bboxExpand.setValue(2, BoxesRunTime.boxToFloat((float)(y_c - (hHalf *= scale))));
        bboxExpand.setValue(4, BoxesRunTime.boxToFloat((float)(y_c + hHalf)));
    }

    public Tuple2<Tensor<Object>, Object> expandMasks(Tensor<Object> mask, int padding) {
        Log4Error$.MODULE$.invalidInputError(mask.isContiguous(), "Only support contiguous mask", Log4Error$.MODULE$.invalidInputError$default$3());
        int channel = mask.size(1);
        int width = mask.size(mask.dim() - 1);
        int expandPadding = 2 * padding;
        float scale = (float)(width + expandPadding) / (float)width;
        Tensor<Object> paddedMask = Tensor$.MODULE$.apply(channel, width + expandPadding, width + expandPadding, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        int maskHeight = mask.size(2);
        int maskWidth = mask.size(3);
        int padHeight = paddedMask.size(2);
        int padWidth = paddedMask.size(3);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), channel).foreach$mVc$sp((Function1)new Serializable(mask, padding, paddedMask, maskHeight, maskWidth, padWidth){
            public static final long serialVersionUID = 0L;
            private final Tensor mask$1;
            public final int padding$1;
            private final Tensor paddedMask$1;
            public final int maskHeight$1;
            public final int maskWidth$1;
            public final int padWidth$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Tensor<T> maskPart = this.mask$1.select(1, i);
                float[] maskArray = (float[])maskPart.storage().array();
                int maskOffset = maskPart.storageOffset() - 1;
                Tensor<T> padPart = this.paddedMask$1.select(1, i);
                float[] padArray = (float[])padPart.storage().array();
                int padOffset = padPart.storageOffset() - 1;
                int nElement = padPart.nElement();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nElement).foreach$mVc$sp((Function1)new Serializable(this, maskArray, maskOffset, padArray, padOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.expandMasks.1 $outer;
                    private final float[] maskArray$1;
                    private final int maskOffset$1;
                    private final float[] padArray$1;
                    private final int padOffset$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        int tempMaskWidth;
                        int tempHeight = j / this.$outer.padWidth$1 + 1;
                        int tempWidth = j % this.$outer.padWidth$1 + 1;
                        int tempMaskHeight = tempHeight > this.$outer.padding$1 + this.$outer.maskHeight$1 || tempHeight < this.$outer.padding$1 ? -1 : tempHeight - this.$outer.padding$1;
                        int n = tempMaskWidth = tempWidth > this.$outer.padding$1 + this.$outer.maskWidth$1 || tempWidth < this.$outer.padding$1 ? -1 : tempWidth - this.$outer.padding$1;
                        if (tempMaskHeight > 0 && tempMaskWidth > 0) {
                            int offset = (tempMaskHeight - 1) * this.$outer.maskWidth$1 + tempMaskWidth - 1;
                            this.padArray$1[j + this.padOffset$1] = this.maskArray$1[offset + this.maskOffset$1];
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.maskArray$1 = maskArray$1;
                        this.maskOffset$1 = maskOffset$1;
                        this.padArray$1 = padArray$1;
                        this.padOffset$1 = padOffset$1;
                    }
                });
            }
            {
                this.mask$1 = mask$1;
                this.padding$1 = padding$1;
                this.paddedMask$1 = paddedMask$1;
                this.maskHeight$1 = maskHeight$1;
                this.maskWidth$1 = maskWidth$1;
                this.padWidth$1 = padWidth$1;
            }
        });
        return new Tuple2(paddedMask, (Object)BoxesRunTime.boxToFloat((float)scale));
    }

    public void decodeMaskInImage(Tensor<Object> mask, Tensor<Object> box, Tensor<Object> binaryMask, float thresh, int padding) {
        Tuple2<Tensor<Object>, Object> tuple2 = this.expandMasks(mask, padding);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Tensor paddedMask = (Tensor)tuple2._1();
            float scale = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)paddedMask, (Object)BoxesRunTime.boxToFloat((float)scale));
            Tensor paddedMask2 = (Tensor)tuple23._1();
            float scale2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
            Tensor<Object> boxExpand = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(box);
            this.expandBoxes(box, boxExpand, scale2);
            int TO_REMOVE = 1;
            int w = package$.MODULE$.max((int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(3)) - (int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(1)) + TO_REMOVE, 1);
            int h2 = package$.MODULE$.max((int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(4)) - (int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(2)) + TO_REMOVE, 1);
            paddedMask2.resize(1, paddedMask2.size(2), paddedMask2.size(3));
            Tensor<Object> interpMask = Tensor$.MODULE$.apply(1, h2, w, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
            this.bilinear(paddedMask2, interpMask, this.bilinear$default$3());
            Tensor<Object> tensor = thresh >= 0.0f ? interpMask.apply1((Function1<Object, Object>)new Serializable(thresh){
                public static final long serialVersionUID = 0L;
                private final float thresh$1;

                public final float apply(float m3) {
                    return this.apply$mcFF$sp(m3);
                }

                public float apply$mcFF$sp(float m3) {
                    return m3 > this.thresh$1 ? 1.0f : 0.0f;
                }
                {
                    this.thresh$1 = thresh$1;
                }
            }) : interpMask.mul(BoxesRunTime.boxToFloat((float)255.0f));
            int imgHeight = binaryMask.size(1);
            int imgWide = binaryMask.size(2);
            int x_0 = package$.MODULE$.max((int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(1)), 0);
            int x_1 = package$.MODULE$.min((int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(3)) + 1, imgWide);
            int y_0 = package$.MODULE$.max((int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(2)), 0);
            int y_1 = package$.MODULE$.min((int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(4)) + 1, imgHeight);
            int maskX0 = y_0 - (int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(2));
            int maskX1 = y_1 - (int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(2));
            int maskY0 = x_0 - (int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(1));
            int maskY1 = x_1 - (int)BoxesRunTime.unboxToFloat((Object)boxExpand.valueAt(1));
            binaryMask.narrow(1, y_0 + 1, y_1 - y_0).narrow(2, x_0 + 1, x_1 - x_0).copy(interpMask.narrow(2, maskX0 + 1, maskX1 - maskX0).narrow(3, maskY0 + 1, maskY1 - maskY0));
            return;
        }
        throw new MatchError(tuple2);
    }

    public float decodeMaskInImage$default$4() {
        return 0.5f;
    }

    public int decodeMaskInImage$default$5() {
        return 1;
    }

    public void bilinear(Tensor<Object> input, Tensor<Object> output, boolean alignCorners) {
        Log4Error$.MODULE$.invalidInputError(input.dim() == 3 && output.dim() == 3, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support 3 dims bilinear,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but get ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.dim()), BoxesRunTime.boxToInteger((int)output.dim())}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        int input_height = input.size(2);
        int input_width = input.size(3);
        int output_height = output.size(2);
        int output_width = output.size(3);
        if (input_height == output_height && input_width == output_width) {
            output.copy(input);
            return;
        }
        Log4Error$.MODULE$.invalidInputError(input.isContiguous() && output.isContiguous(), "Only support contiguous tensor for bilinear", Log4Error$.MODULE$.invalidInputError$default$3());
        int channels = input.size(1);
        float[] inputData = (float[])input.storage().array();
        float[] outputData = (float[])output.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int outputOffset = output.storageOffset() - 1;
        float realHeight = this.areaPixelComputeScale(input_height, output_height, alignCorners);
        float realWidth = this.areaPixelComputeScale(input_width, output_width, alignCorners);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), output_height).foreach$mVc$sp((Function1)new Serializable(alignCorners, input_height, input_width, output_width, channels, inputData, outputData, inputOffset, outputOffset, realHeight, realWidth){
            public static final long serialVersionUID = 0L;
            public final boolean alignCorners$1;
            private final int input_height$1;
            public final int input_width$1;
            public final int output_width$1;
            public final int channels$1;
            public final float[] inputData$1;
            public final float[] outputData$1;
            public final int inputOffset$1;
            public final int outputOffset$1;
            private final float realHeight$1;
            public final float realWidth$1;

            public final void apply(int h2) {
                this.apply$mcVI$sp(h2);
            }

            public void apply$mcVI$sp(int h2) {
                float h1r = Utils$.MODULE$.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$areaPixelComputeSourceIndex(this.realHeight$1, h2, this.alignCorners$1);
                int h1 = (int)h1r;
                int h1p = h1 < this.input_height$1 - 1 ? 1 : 0;
                float h1lambda = h1r - (float)h1;
                float h0lambda = 1.0f - h1lambda;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.output_width$1).foreach$mVc$sp((Function1)new Serializable(this, h1, h1p, h1lambda, h0lambda, h2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.bilinear.1 $outer;
                    private final int h1$1;
                    public final int h1p$1;
                    public final float h1lambda$1;
                    public final float h0lambda$1;
                    private final int h2$1;

                    public final void apply(int w2) {
                        this.apply$mcVI$sp(w2);
                    }

                    public void apply$mcVI$sp(int w2) {
                        float w1r = Utils$.MODULE$.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$areaPixelComputeSourceIndex(this.$outer.realWidth$1, w2, this.$outer.alignCorners$1);
                        int w1 = (int)w1r;
                        int w1p = w1 < this.$outer.input_width$1 - 1 ? 1 : 0;
                        float w1lambda = w1r - (float)w1;
                        float w0lambda = 1.0f - w1lambda;
                        int pos1 = this.h1$1 * this.$outer.input_width$1 + w1 + this.$outer.inputOffset$1;
                        int pos2 = this.h2$1 * this.$outer.output_width$1 + w2 + this.$outer.outputOffset$1;
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.channels$1 - 1).foreach$mVc$sp((Function1)new Serializable(this, w1p, w1lambda, w0lambda, pos1, pos2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$bilinear$1$$anonfun$apply$mcVI$sp$2 $outer;
                            private final int w1p$1;
                            private final float w1lambda$1;
                            private final float w0lambda$1;
                            private final int pos1$1;
                            private final int pos2$1;

                            public final void apply(int c) {
                                this.apply$mcVI$sp(c);
                            }

                            public void apply$mcVI$sp(int c) {
                                this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().outputData$1[this.pos2$1] = this.$outer.h0lambda$1 * (this.w0lambda$1 * this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().inputData$1[this.pos1$1] + this.w1lambda$1 * this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().inputData$1[this.pos1$1 + this.w1p$1]) + this.$outer.h1lambda$1 * (this.w0lambda$1 * this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().inputData$1[this.pos1$1 + this.$outer.h1p$1 * this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().input_width$1] + this.w1lambda$1 * this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().inputData$1[this.pos1$1 + this.$outer.h1p$1 * this.$outer.com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer().input_width$1 + this.w1p$1]);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.w1p$1 = w1p$1;
                                this.w1lambda$1 = w1lambda$1;
                                this.w0lambda$1 = w0lambda$1;
                                this.pos1$1 = pos1$1;
                                this.pos2$1 = pos2$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.bilinear.1 com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.h1$1 = h1$1;
                        this.h1p$1 = h1p$1;
                        this.h1lambda$1 = h1lambda$1;
                        this.h0lambda$1 = h0lambda$1;
                        this.h2$1 = h2$1;
                    }
                });
            }
            {
                this.alignCorners$1 = alignCorners$1;
                this.input_height$1 = input_height$1;
                this.input_width$1 = input_width$1;
                this.output_width$1 = output_width$1;
                this.channels$1 = channels$1;
                this.inputData$1 = inputData$1;
                this.outputData$1 = outputData$1;
                this.inputOffset$1 = inputOffset$1;
                this.outputOffset$1 = outputOffset$1;
                this.realHeight$1 = realHeight$1;
                this.realWidth$1 = realWidth$1;
            }
        });
    }

    public boolean bilinear$default$3() {
        return false;
    }

    private float areaPixelComputeScale(int inputSize, int outputSize, boolean alignCorners) {
        return alignCorners ? (float)(inputSize - 1) / (float)(outputSize - 1) : (float)inputSize / (float)outputSize;
    }

    public float com$intel$analytics$bigdl$dllib$models$maskrcnn$Utils$$areaPixelComputeSourceIndex(float scale, int dstIndex, boolean alignCorners) {
        float srcIdx;
        return alignCorners ? scale * (float)dstIndex : ((srcIdx = scale * ((float)dstIndex + 0.5f) - 0.5f) < 0.0f ? 0.0f : srcIdx);
    }

    private Utils$() {
        MODULE$ = this;
    }
}

