/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.models.lenet;

import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.models.lenet.Utils;
import com.intel.analytics.bigdl.dllib.utils.File$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final double trainMean;
    private final double trainStd;
    private final double testMean;
    private final double testStd;
    private final OptionParser<Utils.TrainParams> trainParser;
    private final OptionParser<Utils.TestParams> testParser;

    static {
        new Utils$();
    }

    public double trainMean() {
        return this.trainMean;
    }

    public double trainStd() {
        return this.trainStd;
    }

    public double testMean() {
        return this.testMean;
    }

    public double testStd() {
        return this.testStd;
    }

    public OptionParser<Utils.TrainParams> trainParser() {
        return this.trainParser;
    }

    public OptionParser<Utils.TestParams> testParser() {
        return this.testParser;
    }

    public ByteRecord[] load(String featureFile, String labelFile) {
        ByteBuffer featureBuffer = featureFile.startsWith(File$.MODULE$.hdfsPrefix()) ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(featureFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(featureFile, new String[0])));
        ByteBuffer labelBuffer = featureFile.startsWith(File$.MODULE$.hdfsPrefix()) ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(labelFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(labelFile, new String[0])));
        int labelMagicNumber = labelBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelMagicNumber == 2049, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect labelMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelMagicNumber)})), "The data should be wrong,labelMagicNumber for data should be 2049");
        int featureMagicNumber = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(featureMagicNumber == 2051, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect featureMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureMagicNumber)})), "The data should be wrong,featureMagicNumber for data should be 2051");
        int labelCount = labelBuffer.getInt();
        int featureCount = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelCount == featureCount, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label numbers ", " doesn't match feature numbers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelCount), BoxesRunTime.boxToInteger((int)featureCount)})), "The data should be wrong, label numbers should be the same with feature numbers");
        int rowNum = featureBuffer.getInt();
        int colNum = featureBuffer.getInt();
        ByteRecord[] result2 = new ByteRecord[featureCount];
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum];
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[x + y * colNum] = featureBuffer.get();
                }
            }
            result2[i] = new ByteRecord(img, (float)labelBuffer.get() + 1.0f);
        }
        return result2;
    }

    private Utils$() {
        MODULE$ = this;
        this.trainMean = 0.13066047740239506;
        this.trainStd = 0.3081078;
        this.testMean = 0.13251460696903547;
        this.testStd = 0.31048024;
        this.trainParser = new OptionParser<Utils.TrainParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the MNIST data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
                    }
                });
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$2 = x;
                        String x$3 = c.copy$default$1();
                        Option<String> x$4 = c.copy$default$2();
                        Option<String> x$5 = c.copy$default$3();
                        Option<String> x$6 = c.copy$default$4();
                        double x$7 = c.copy$default$6();
                        double x$8 = c.copy$default$7();
                        int x$9 = c.copy$default$8();
                        int x$10 = c.copy$default$9();
                        int x$11 = c.copy$default$10();
                        boolean x$12 = c.copy$default$11();
                        boolean x$13 = c.copy$default$12();
                        Option<String> x$14 = c.copy$default$13();
                        return c.copy(x$3, x$4, x$5, x$6, x$2, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$15 = new Some((Object)x);
                        String x$16 = c.copy$default$1();
                        Option<String> x$17 = c.copy$default$2();
                        Option<String> x$18 = c.copy$default$4();
                        int x$19 = c.copy$default$5();
                        double x$20 = c.copy$default$6();
                        double x$21 = c.copy$default$7();
                        int x$22 = c.copy$default$8();
                        int x$23 = c.copy$default$9();
                        int x$24 = c.copy$default$10();
                        boolean x$25 = c.copy$default$11();
                        boolean x$26 = c.copy$default$12();
                        Option<String> x$27 = c.copy$default$13();
                        return c.copy(x$16, x$17, (Option<String>)x$15, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27);
                    }
                });
                this.opt("state", Read$.MODULE$.stringRead()).text("state snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$28 = new Some((Object)x);
                        String x$29 = c.copy$default$1();
                        Option<String> x$30 = c.copy$default$2();
                        Option<String> x$31 = c.copy$default$3();
                        int x$32 = c.copy$default$5();
                        double x$33 = c.copy$default$6();
                        double x$34 = c.copy$default$7();
                        int x$35 = c.copy$default$8();
                        int x$36 = c.copy$default$9();
                        int x$37 = c.copy$default$10();
                        boolean x$38 = c.copy$default$11();
                        boolean x$39 = c.copy$default$12();
                        Option<String> x$40 = c.copy$default$13();
                        return c.copy(x$29, x$30, x$31, (Option<String>)x$28, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
                    }
                });
                this.opt("checkpoint", Read$.MODULE$.stringRead()).text("where to cache the model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$41 = new Some((Object)x);
                        String x$42 = c.copy$default$1();
                        Option<String> x$43 = c.copy$default$3();
                        Option<String> x$44 = c.copy$default$4();
                        int x$45 = c.copy$default$5();
                        double x$46 = c.copy$default$6();
                        double x$47 = c.copy$default$7();
                        int x$48 = c.copy$default$8();
                        int x$49 = c.copy$default$9();
                        int x$50 = c.copy$default$10();
                        boolean x$51 = c.copy$default$11();
                        boolean x$52 = c.copy$default$12();
                        Option<String> x$53 = c.copy$default$13();
                        return c.copy(x$42, (Option<String>)x$41, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53);
                    }
                });
                this.opt('r', "learningRate", Read$.MODULE$.doubleRead()).text("learning rate").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$54 = x;
                        String x$55 = c.copy$default$1();
                        Option<String> x$56 = c.copy$default$2();
                        Option<String> x$57 = c.copy$default$3();
                        Option<String> x$58 = c.copy$default$4();
                        int x$59 = c.copy$default$5();
                        double x$60 = c.copy$default$7();
                        int x$61 = c.copy$default$8();
                        int x$62 = c.copy$default$9();
                        int x$63 = c.copy$default$10();
                        boolean x$64 = c.copy$default$11();
                        boolean x$65 = c.copy$default$12();
                        Option<String> x$66 = c.copy$default$13();
                        return c.copy(x$55, x$56, x$57, x$58, x$59, x$54, x$60, x$61, x$62, x$63, x$64, x$65, x$66);
                    }
                });
                this.opt('d', "learningRateDecay", Read$.MODULE$.doubleRead()).text("learning rate decay").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$67 = x;
                        String x$68 = c.copy$default$1();
                        Option<String> x$69 = c.copy$default$2();
                        Option<String> x$70 = c.copy$default$3();
                        Option<String> x$71 = c.copy$default$4();
                        int x$72 = c.copy$default$5();
                        double x$73 = c.copy$default$6();
                        int x$74 = c.copy$default$8();
                        int x$75 = c.copy$default$9();
                        int x$76 = c.copy$default$10();
                        boolean x$77 = c.copy$default$11();
                        boolean x$78 = c.copy$default$12();
                        Option<String> x$79 = c.copy$default$13();
                        return c.copy(x$68, x$69, x$70, x$71, x$72, x$73, x$67, x$74, x$75, x$76, x$77, x$78, x$79);
                    }
                });
                this.opt('e', "maxEpoch", Read$.MODULE$.intRead()).text("epoch numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$80 = x;
                        String x$81 = c.copy$default$1();
                        Option<String> x$82 = c.copy$default$2();
                        Option<String> x$83 = c.copy$default$3();
                        Option<String> x$84 = c.copy$default$4();
                        int x$85 = c.copy$default$5();
                        double x$86 = c.copy$default$6();
                        double x$87 = c.copy$default$7();
                        int x$88 = c.copy$default$9();
                        int x$89 = c.copy$default$10();
                        boolean x$90 = c.copy$default$11();
                        boolean x$91 = c.copy$default$12();
                        Option<String> x$92 = c.copy$default$13();
                        return c.copy(x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$80, x$88, x$89, x$90, x$91, x$92);
                    }
                });
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$93 = x;
                        String x$94 = c.copy$default$1();
                        Option<String> x$95 = c.copy$default$2();
                        Option<String> x$96 = c.copy$default$3();
                        Option<String> x$97 = c.copy$default$4();
                        double x$98 = c.copy$default$6();
                        double x$99 = c.copy$default$7();
                        int x$100 = c.copy$default$8();
                        int x$101 = c.copy$default$9();
                        int x$102 = c.copy$default$10();
                        boolean x$103 = c.copy$default$11();
                        boolean x$104 = c.copy$default$12();
                        Option<String> x$105 = c.copy$default$13();
                        return c.copy(x$94, x$95, x$96, x$97, x$93, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105);
                    }
                });
                this.opt("overWrite", Read$.MODULE$.unitRead()).text("overwrite checkpoint files").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x$1, Utils.TrainParams c) {
                        boolean x$106 = true;
                        String x$107 = c.copy$default$1();
                        Option<String> x$108 = c.copy$default$2();
                        Option<String> x$109 = c.copy$default$3();
                        Option<String> x$110 = c.copy$default$4();
                        int x$111 = c.copy$default$5();
                        double x$112 = c.copy$default$6();
                        double x$113 = c.copy$default$7();
                        int x$114 = c.copy$default$8();
                        int x$115 = c.copy$default$9();
                        int x$116 = c.copy$default$10();
                        boolean x$117 = c.copy$default$12();
                        Option<String> x$118 = c.copy$default$13();
                        return c.copy(x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$106, x$117, x$118);
                    }
                });
                this.opt('g', "graphModel", Read$.MODULE$.unitRead()).text("use graph model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x, Utils.TrainParams c) {
                        boolean x$119 = true;
                        String x$120 = c.copy$default$1();
                        Option<String> x$121 = c.copy$default$2();
                        Option<String> x$122 = c.copy$default$3();
                        Option<String> x$123 = c.copy$default$4();
                        int x$124 = c.copy$default$5();
                        double x$125 = c.copy$default$6();
                        double x$126 = c.copy$default$7();
                        int x$127 = c.copy$default$8();
                        int x$128 = c.copy$default$9();
                        int x$129 = c.copy$default$10();
                        boolean x$130 = c.copy$default$11();
                        Option<String> x$131 = c.copy$default$13();
                        return c.copy(x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$119, x$131);
                    }
                });
                this.opt("optimizerVersion", Read$.MODULE$.stringRead()).text("state optimizer version").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$132 = new Some((Object)x);
                        String x$133 = c.copy$default$1();
                        Option<String> x$134 = c.copy$default$2();
                        Option<String> x$135 = c.copy$default$3();
                        Option<String> x$136 = c.copy$default$4();
                        int x$137 = c.copy$default$5();
                        double x$138 = c.copy$default$6();
                        double x$139 = c.copy$default$7();
                        int x$140 = c.copy$default$8();
                        int x$141 = c.copy$default$9();
                        int x$142 = c.copy$default$10();
                        boolean x$143 = c.copy$default$11();
                        boolean x$144 = c.copy$default$12();
                        return c.copy(x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, (Option<String>)x$132);
                    }
                });
            }
        };
        this.testParser = new OptionParser<Utils.TestParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the MNIST data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        String x$145 = x;
                        String x$146 = c.copy$default$1();
                        int x$147 = c.copy$default$3();
                        return c.copy(x$146, x$145, x$147);
                    }
                }).required().required();
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(int x, Utils.TestParams c) {
                        int x$148 = x;
                        String x$149 = c.copy$default$1();
                        String x$150 = c.copy$default$2();
                        return c.copy(x$149, x$150, x$148);
                    }
                });
            }
        };
    }
}

