/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.models.autoencoder;

import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.models.autoencoder.Utils;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final double trainMean;
    private final double trainStd;
    private final OptionParser<Utils.TrainParams> trainParser;

    static {
        new Utils$();
    }

    public double trainMean() {
        return this.trainMean;
    }

    public double trainStd() {
        return this.trainStd;
    }

    public OptionParser<Utils.TrainParams> trainParser() {
        return this.trainParser;
    }

    public ByteRecord[] load(Path featureFile, Path labelFile) {
        ByteBuffer labelBuffer = ByteBuffer.wrap(Files.readAllBytes(labelFile));
        ByteBuffer featureBuffer = ByteBuffer.wrap(Files.readAllBytes(featureFile));
        int labelMagicNumber = labelBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelMagicNumber == 2049, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect labelMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelMagicNumber)})), "The data should be wrong,labelMagicNumber for data should be 2049");
        int featureMagicNumber = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(featureMagicNumber == 2051, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect featureMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureMagicNumber)})), "The data should be wrong,featureMagicNumber for data should be 2051");
        int labelCount = labelBuffer.getInt();
        int featureCount = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelCount == featureCount, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label numbers ", " doesn't match feature numbers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelCount), BoxesRunTime.boxToInteger((int)featureCount)})), "The data should be wrong, label numbers should be the same with feature numbers");
        int rowNum = featureBuffer.getInt();
        int colNum = featureBuffer.getInt();
        ByteRecord[] result2 = new ByteRecord[featureCount];
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum];
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[x + y * colNum] = featureBuffer.get();
                }
            }
            result2[i] = new ByteRecord(img, (float)labelBuffer.get() + 1.0f);
        }
        return result2;
    }

    private Utils$() {
        MODULE$ = this;
        this.trainMean = 0.13066047740239436;
        this.trainStd = 0.3081078f;
        this.trainParser = new OptionParser<Utils.TrainParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the MNIST data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$1 = new Some((Object)x);
                        String x$2 = c.copy$default$1();
                        Option<String> x$3 = c.copy$default$2();
                        Option<String> x$4 = c.copy$default$4();
                        int x$5 = c.copy$default$5();
                        int x$6 = c.copy$default$6();
                        boolean x$7 = c.copy$default$7();
                        Option<String> x$8 = c.copy$default$8();
                        return c.copy(x$2, x$3, (Option<String>)x$1, x$4, x$5, x$6, x$7, x$8);
                    }
                });
                this.opt("state", Read$.MODULE$.stringRead()).text("state snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$9 = new Some((Object)x);
                        String x$10 = c.copy$default$1();
                        Option<String> x$11 = c.copy$default$2();
                        Option<String> x$12 = c.copy$default$3();
                        int x$13 = c.copy$default$5();
                        int x$14 = c.copy$default$6();
                        boolean x$15 = c.copy$default$7();
                        Option<String> x$16 = c.copy$default$8();
                        return c.copy(x$10, x$11, x$12, (Option<String>)x$9, x$13, x$14, x$15, x$16);
                    }
                });
                this.opt("checkpoint", Read$.MODULE$.stringRead()).text("where to cache the model and state").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$17 = new Some((Object)x);
                        String x$18 = c.copy$default$1();
                        Option<String> x$19 = c.copy$default$3();
                        Option<String> x$20 = c.copy$default$4();
                        int x$21 = c.copy$default$5();
                        int x$22 = c.copy$default$6();
                        boolean x$23 = c.copy$default$7();
                        Option<String> x$24 = c.copy$default$8();
                        return c.copy(x$18, (Option<String>)x$17, x$19, x$20, x$21, x$22, x$23, x$24);
                    }
                });
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$25 = x;
                        String x$26 = c.copy$default$1();
                        Option<String> x$27 = c.copy$default$2();
                        Option<String> x$28 = c.copy$default$3();
                        Option<String> x$29 = c.copy$default$4();
                        int x$30 = c.copy$default$6();
                        boolean x$31 = c.copy$default$7();
                        Option<String> x$32 = c.copy$default$8();
                        return c.copy(x$26, x$27, x$28, x$29, x$25, x$30, x$31, x$32);
                    }
                });
                this.opt('e', "maxEpoch", Read$.MODULE$.intRead()).text("max epoch").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$33 = x;
                        String x$34 = c.copy$default$1();
                        Option<String> x$35 = c.copy$default$2();
                        Option<String> x$36 = c.copy$default$3();
                        Option<String> x$37 = c.copy$default$4();
                        int x$38 = c.copy$default$5();
                        boolean x$39 = c.copy$default$7();
                        Option<String> x$40 = c.copy$default$8();
                        return c.copy(x$34, x$35, x$36, x$37, x$38, x$33, x$39, x$40);
                    }
                });
                this.opt('g', "graphModel", Read$.MODULE$.unitRead()).text("use graph model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x, Utils.TrainParams c) {
                        boolean x$41 = true;
                        String x$42 = c.copy$default$1();
                        Option<String> x$43 = c.copy$default$2();
                        Option<String> x$44 = c.copy$default$3();
                        Option<String> x$45 = c.copy$default$4();
                        int x$46 = c.copy$default$5();
                        int x$47 = c.copy$default$6();
                        Option<String> x$48 = c.copy$default$8();
                        return c.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$41, x$48);
                    }
                });
                this.opt("optimizerVersion", Read$.MODULE$.stringRead()).text("state optimizer version").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$49 = new Some((Object)x);
                        String x$50 = c.copy$default$1();
                        Option<String> x$51 = c.copy$default$2();
                        Option<String> x$52 = c.copy$default$3();
                        Option<String> x$53 = c.copy$default$4();
                        int x$54 = c.copy$default$5();
                        int x$55 = c.copy$default$6();
                        boolean x$56 = c.copy$default$7();
                        return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, (Option<String>)x$49);
                    }
                });
            }
        };
    }
}

