/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.transform.vision.image.util;

import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.label.roi.RoiLabel;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.label.roi.RoiLabel$;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BboxUtil$ {
    public static final BboxUtil$ MODULE$;
    private final Logger logger;

    static {
        new BboxUtil$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Tensor<Object> decodeRois(Tensor<Object> output) {
        if (output.nElement() < 6 || output.dim() == 2) {
            return output;
        }
        int num = (int)BoxesRunTime.unboxToFloat((Object)output.valueAt(1));
        Log4Error$.MODULE$.invalidOperationError(num >= 0, "output size cannot be negative", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        return num == 0 ? Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$) : output.narrow(1, 2, num * 6).view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{num, 6}));
    }

    public void scaleBBox(Tensor<Object> bboxes, float height, float width) {
        if (bboxes.nElement() == 0) {
            return;
        }
        bboxes.select(2, 1).mul(BoxesRunTime.boxToFloat((float)width));
        bboxes.select(2, 2).mul(BoxesRunTime.boxToFloat((float)height));
        bboxes.select(2, 3).mul(BoxesRunTime.boxToFloat((float)width));
        bboxes.select(2, 4).mul(BoxesRunTime.boxToFloat((float)height));
    }

    public Tensor<Object> bboxTransformInv(Tensor<Object> boxes, Tensor<Object> deltas, boolean normalized) {
        if (boxes.size(1) == 0) {
            return boxes;
        }
        Tensor<Object> output = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(deltas).copy(deltas);
        Log4Error$.MODULE$.invalidOperationError(boxes.size(2) == 4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"boxes size ", " do not satisfy N*4 size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(boxes.size()).mkString(",")})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(output.size(2) % 4 == 0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and deltas size ", " do not satisfy N*4a size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(output.size()).mkString(",")})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        float[] boxesArr = (float[])boxes.storage().array();
        int offset = boxes.storageOffset() - 1;
        int rowLength = boxes.stride(1);
        float[] deltasArr = (float[])output.storage().array();
        int repeat = output.size(2) / boxes.size(2);
        int deltasoffset = output.storageOffset() - 1;
        for (int i = 0; i < boxes.size(1); ++i) {
            float x1 = boxesArr[offset];
            float y1 = boxesArr[offset + 1];
            float width = normalized ? boxesArr[offset + 2] - x1 : boxesArr[offset + 2] - x1 + 1.0f;
            float height = normalized ? boxesArr[offset + 3] - y1 : boxesArr[offset + 3] - y1 + 1.0f;
            int j = 0;
            while (j < repeat) {
                ++j;
                float predCtrX = deltasArr[deltasoffset] * width + x1 + width / (float)2;
                float predCtrY = deltasArr[deltasoffset + 1] * height + y1 + height / (float)2;
                float predW = (float)Math.exp(deltasArr[deltasoffset + 2]) * width / (float)2;
                float predH = (float)Math.exp(deltasArr[deltasoffset + 3]) * height / (float)2;
                deltasArr[deltasoffset] = predCtrX - predW;
                deltasArr[deltasoffset + 1] = predCtrY - predH;
                deltasArr[deltasoffset + 2] = predCtrX + predW;
                deltasArr[deltasoffset + 3] = predCtrY + predH;
                deltasoffset += rowLength;
            }
            offset += rowLength;
        }
        return output;
    }

    public boolean bboxTransformInv$default$3() {
        return false;
    }

    public int clipBoxes(Tensor<Object> boxes, float height, float width, float minH, float minW, Tensor<Object> scores) {
        Log4Error$.MODULE$.invalidOperationError(boxes.size(2) % 4 == 0, "boxes should have the shape N*4a", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        float[] boxesArr = (float[])boxes.storage().array();
        int offset = boxes.storageOffset() - 1;
        float[] scoresArr = scores == null ? null : (float[])scores.storage().array();
        int scoreOffset = scores == null ? -1 : scores.storageOffset() - 1;
        int count2 = 0;
        float h2 = height - 1.0f;
        float w = width - 1.0f;
        int repeat = boxes.size(2) / 4;
        for (int i = 0; i < boxes.size(1); ++i) {
            int r = 0;
            while (r < repeat) {
                boxesArr[offset] = Math.max(Math.min(boxesArr[offset], w), 0.0f);
                boxesArr[offset + 1] = Math.max(Math.min(boxesArr[offset + 1], h2), 0.0f);
                boxesArr[offset + 2] = Math.max(Math.min(boxesArr[offset + 2], w), 0.0f);
                boxesArr[offset + 3] = Math.max(Math.min(boxesArr[offset + 3], h2), 0.0f);
                if (scores != null) {
                    float width2 = boxesArr[offset + 2] - boxesArr[offset] + 1.0f;
                    if (width2 < minW) {
                        scoresArr[scoreOffset] = 0.0f;
                    } else {
                        float height2 = boxesArr[offset + 3] - boxesArr[offset + 1] + 1.0f;
                        if (height2 < minH) {
                            scoresArr[scoreOffset] = 0.0f;
                        } else {
                            ++count2;
                        }
                    }
                    ++scoreOffset;
                }
                ++r;
                offset += 4;
            }
        }
        return count2;
    }

    public Tensor<Object>[][] getLocPredictions(Tensor<Object> loc, int numPredsPerClass, int numClasses, boolean shareLocation, Tensor<Object>[][] locPredsBuf) {
        Tensor<Object>[][] tensorArray;
        if (locPredsBuf == null) {
            Tensor[][] out = new Tensor[loc.size(1)][];
            for (int i = 0; i < loc.size(1); ++i) {
                out[i] = new Tensor[numClasses];
                for (int c = 0; c < numClasses; ++c) {
                    out[i][c] = Tensor$.MODULE$.apply(numPredsPerClass, 4, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                }
            }
            tensorArray = out;
        } else {
            tensorArray = locPredsBuf;
        }
        Tensor<Object>[][] locPreds = tensorArray;
        float[] locData = (float[])loc.storage().array();
        int locDataOffset = loc.storageOffset() - 1;
        for (int i = 0; i < loc.size(1); ++i) {
            Tensor<Object>[] labelBbox = locPreds[i];
            for (int p = 0; p < numPredsPerClass; ++p) {
                int startInd = p * numClasses * 4 + locDataOffset;
                for (int c = 0; c < numClasses; ++c) {
                    int label = shareLocation ? labelBbox.length - 1 : c;
                    float[] boxData = (float[])labelBbox[label].storage().array();
                    int boxOffset = p * 4 + labelBbox[label].storageOffset() - 1;
                    int offset = startInd + c * 4;
                    boxData[boxOffset] = locData[offset];
                    boxData[boxOffset + 1] = locData[offset + 1];
                    boxData[boxOffset + 2] = locData[offset + 2];
                    boxData[boxOffset + 3] = locData[offset + 3];
                }
            }
            locDataOffset += numPredsPerClass * numClasses * 4;
        }
        return locPreds;
    }

    public Tensor<Object>[][] getLocPredictions$default$5() {
        return null;
    }

    public Tensor<Object>[][] getConfidenceScores(Tensor<Object> conf, int numPredsPerClass, int numClasses, Tensor<Object>[][] confBuf) {
        Tensor<Object>[][] tensorArray;
        if (confBuf == null) {
            Tensor[][] out = new Tensor[conf.size(1)][];
            for (int i = 0; i < conf.size(1); ++i) {
                out[i] = new Tensor[numClasses];
                for (int c = 0; c < numClasses; ++c) {
                    out[i][c] = Tensor$.MODULE$.apply(numPredsPerClass, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                }
            }
            tensorArray = out;
        } else {
            tensorArray = confBuf;
        }
        Tensor<Object>[][] confPreds = tensorArray;
        float[] confData = (float[])conf.storage().array();
        int confDataOffset = conf.storageOffset() - 1;
        for (int i = 0; i < conf.size(1); ++i) {
            Tensor<Object>[] labelScores = confPreds[i];
            for (int p = 0; p < numPredsPerClass; ++p) {
                int startInd = p * numClasses + confDataOffset;
                for (int c = 0; c < numClasses; ++c) {
                    labelScores[c].setValue(p + 1, BoxesRunTime.boxToFloat((float)confData[startInd + c]));
                }
            }
            confDataOffset += numPredsPerClass * numClasses;
        }
        return confPreds;
    }

    public Tensor<Object>[][] getConfidenceScores$default$4() {
        return null;
    }

    public Tuple2<Tensor<Object>, Tensor<Object>> getPriorBboxes(Tensor<Object> prior, int nPriors) {
        Storage<Object> array = prior.storage();
        int aOffset = prior.storageOffset();
        Tensor<Object> priorBoxes = Tensor$.MODULE$.apply$mFc$sp(array, aOffset, new int[]{nPriors, 4}, Tensor$.MODULE$.apply$default$4(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        Tensor<Object> priorVariances = Tensor$.MODULE$.apply$mFc$sp(array, aOffset + nPriors * 4, new int[]{nPriors, 4}, Tensor$.MODULE$.apply$default$4(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        return new Tuple2(priorBoxes, priorVariances);
    }

    public Tensor<Object>[][] decodeBboxesAll(Tensor<Object>[][] allLocPreds, Tensor<Object> priorBoxes, Tensor<Object> priorVariances, int nClasses, int bgLabel, boolean clipBoxes2, boolean varianceEncodedInTarget, boolean shareLocation, Tensor<Object>[][] output) {
        Tensor[][] tensorArrayArray;
        int batch = allLocPreds.length;
        if (output == null) {
            Tensor[][] all = new Tensor[batch][];
            for (int i = 0; i < batch; ++i) {
                all[i] = new Tensor[nClasses];
            }
            tensorArrayArray = all;
        } else {
            Log4Error$.MODULE$.invalidOperationError(output.length == batch, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"output length(", ") doesn't match batch(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)output.length), BoxesRunTime.boxToInteger((int)batch)})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            tensorArrayArray = output;
        }
        Tensor[][] allDecodeBboxes = tensorArrayArray;
        for (int i = 0; i < batch; ++i) {
            Tensor[] decodedBoxes = allDecodeBboxes[i];
            for (int c = 0; c < nClasses; ++c) {
                if (!shareLocation && c == bgLabel) continue;
                if (allLocPreds[i][c].nElement() == 0) {
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find location predictions for label ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                }
                Tensor<Object> labelLocPreds = allLocPreds[i][c];
                decodedBoxes[c] = this.decodeBoxes(priorBoxes, priorVariances, clipBoxes2, labelLocPreds, varianceEncodedInTarget, labelLocPreds);
            }
            allDecodeBboxes[i] = decodedBoxes;
        }
        return allDecodeBboxes;
    }

    public Tensor<Object>[][] decodeBboxesAll$default$9() {
        return null;
    }

    public Tensor<Object> decodeBoxes(Tensor<Object> priorBoxes, Tensor<Object> priorVariances, boolean isClipBoxes, Tensor<Object> bboxes, boolean varianceEncodedInTarget, Tensor<Object> output) {
        Log4Error$.MODULE$.invalidOperationError(priorBoxes.size(1) == priorVariances.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"priorBoxes.size(1) ", " should"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)priorBoxes.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" match priorVariances.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)priorVariances.size(1))}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(priorBoxes.size(1) == bboxes.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"priorBoxes.size(1) ", " should"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)priorBoxes.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" match bboxes.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bboxes.size(1))}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        int numBboxes = priorBoxes.size(1);
        if (numBboxes > 0) {
            Log4Error$.MODULE$.invalidOperationError(priorBoxes.size(2) == 4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"priorBoxes.size(2) ", " should be 4"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)priorBoxes.size(2))})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
        Tensor<Object> decodedBboxes = output == null ? Tensor$.MODULE$.apply(numBboxes, 4, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$) : output.resizeAs(priorBoxes);
        for (int i = 1; i <= numBboxes; ++i) {
            this.decodeSingleBbox(i, priorBoxes, priorVariances, isClipBoxes, bboxes, varianceEncodedInTarget, decodedBboxes);
        }
        return decodedBboxes;
    }

    public Tensor<Object> decodeBoxes$default$6() {
        return null;
    }

    private void decodeSingleBbox(int i, Tensor<Object> priorBox, Tensor<Object> priorVariance, boolean isClipBoxes, Tensor<Object> bbox, boolean varianceEncodedInTarget, Tensor<Object> decodedBoxes) {
        float x1 = BoxesRunTime.unboxToFloat((Object)priorBox.valueAt(i, 1));
        float y1 = BoxesRunTime.unboxToFloat((Object)priorBox.valueAt(i, 2));
        float x2 = BoxesRunTime.unboxToFloat((Object)priorBox.valueAt(i, 3));
        float y2 = BoxesRunTime.unboxToFloat((Object)priorBox.valueAt(i, 4));
        float priorWidth = x2 - x1;
        Log4Error$.MODULE$.invalidOperationError(priorWidth > 0.0f, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"right x ", " should be great than left x ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{priorBox.valueAt(i, 3), priorBox.valueAt(i, 1)})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        float priorHeight = y2 - y1;
        Log4Error$.MODULE$.invalidOperationError(priorHeight > 0.0f, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"downside y ", " should be great than"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{priorBox.valueAt(i, 4)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upside y ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{priorBox.valueAt(i, 2)}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        float pCenterX = (x1 + x2) / (float)2;
        float pCenterY = (y1 + y2) / (float)2;
        float decodeCenterX = 0.0f;
        float decodeCenterY = 0.0f;
        float decodeWidth = 0.0f;
        float decodedHeight = 0.0f;
        if (varianceEncodedInTarget) {
            decodeCenterX = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 1)) * priorWidth + pCenterX;
            decodeCenterY = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 2)) * priorHeight + pCenterY;
            decodeWidth = (float)Math.exp(BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 3))) * priorWidth;
            decodedHeight = (float)Math.exp(BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 4))) * priorHeight;
        } else {
            decodeCenterX = BoxesRunTime.unboxToFloat((Object)priorVariance.valueAt(i, 1)) * BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 1)) * priorWidth + pCenterX;
            decodeCenterY = BoxesRunTime.unboxToFloat((Object)priorVariance.valueAt(i, 2)) * BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 2)) * priorHeight + pCenterY;
            decodeWidth = (float)Math.exp(BoxesRunTime.unboxToFloat((Object)priorVariance.valueAt(i, 3)) * BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 3))) * priorWidth;
            decodedHeight = (float)Math.exp(BoxesRunTime.unboxToFloat((Object)priorVariance.valueAt(i, 4)) * BoxesRunTime.unboxToFloat((Object)bbox.valueAt(i, 4))) * priorHeight;
        }
        decodedBoxes.setValue(i, 1, BoxesRunTime.boxToFloat((float)(decodeCenterX - decodeWidth / (float)2)));
        decodedBoxes.setValue(i, 2, BoxesRunTime.boxToFloat((float)(decodeCenterY - decodedHeight / (float)2)));
        decodedBoxes.setValue(i, 3, BoxesRunTime.boxToFloat((float)(decodeCenterX + decodeWidth / (float)2)));
        decodedBoxes.setValue(i, 4, BoxesRunTime.boxToFloat((float)(decodeCenterY + decodedHeight / (float)2)));
        if (isClipBoxes) {
            this.clipBoxes(decodedBoxes);
        }
    }

    public Tensor<Object> clipBoxes(Tensor<Object> bboxes) {
        return bboxes.cmax(BoxesRunTime.boxToFloat((float)0.0f)).apply1((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(float x) {
                return this.apply$mcFF$sp(x);
            }

            public float apply$mcFF$sp(float x) {
                return Math.min(1.0f, x);
            }
        });
    }

    public float clipBoxes$default$4() {
        return 0.0f;
    }

    public float clipBoxes$default$5() {
        return 0.0f;
    }

    public Tensor<Object> clipBoxes$default$6() {
        return null;
    }

    public RoiLabel bboxVote(Tensor<Object> scoresNms, Tensor<Object> bboxNms, Tensor<Object> scoresAll, Tensor<Object> bboxAll, Tensor<Object> areasBuf) {
        Tensor<Object> accBox = null;
        float accScore = 0.0f;
        Tensor<Object> box = null;
        Tensor<Object> areasAll = areasBuf == null ? Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$) : areasBuf;
        this.getAreas(bboxAll, areasAll, this.getAreas$default$3(), this.getAreas$default$4());
        for (int i = 1; i <= scoresNms.size(1); ++i) {
            BoxedUnit boxedUnit;
            box = bboxNms.apply(i);
            if (accBox == null) {
                accBox = Tensor$.MODULE$.apply(4, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = accBox.fill(BoxesRunTime.boxToFloat((float)0.0f));
            }
            accScore = 0.0f;
            for (int m3 = 1; m3 <= scoresAll.size(1); ++m3) {
                float ua;
                float ov;
                Tensor<Object> boxA = bboxAll.apply(m3);
                float iw = Math.min(BoxesRunTime.unboxToFloat((Object)box.valueAt(3)), BoxesRunTime.unboxToFloat((Object)boxA.valueAt(3))) - Math.max(BoxesRunTime.unboxToFloat((Object)box.valueAt(1)), BoxesRunTime.unboxToFloat((Object)boxA.valueAt(1))) + 1.0f;
                float ih = Math.min(BoxesRunTime.unboxToFloat((Object)box.valueAt(4)), BoxesRunTime.unboxToFloat((Object)boxA.valueAt(4))) - Math.max(BoxesRunTime.unboxToFloat((Object)box.valueAt(2)), BoxesRunTime.unboxToFloat((Object)boxA.valueAt(2))) + 1.0f;
                if (!(iw > 0.0f) || !(ih > 0.0f) || !((double)(ov = iw * ih / (ua = this.getArea(box) + BoxesRunTime.unboxToFloat((Object)areasAll.valueAt(m3)) - iw * ih)) >= 0.5)) continue;
                accBox.add(scoresAll.valueAt(m3), boxA);
                accScore += BoxesRunTime.unboxToFloat((Object)scoresAll.valueAt(m3));
            }
            for (int x = 1; x <= 4; ++x) {
                bboxNms.setValue(i, x, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)accBox.valueAt(x)) / accScore)));
            }
        }
        return new RoiLabel(scoresNms, bboxNms, RoiLabel$.MODULE$.apply$default$3());
    }

    public Tensor<Object> bboxVote$default$5() {
        return null;
    }

    private float getArea(Tensor<Object> box) {
        Log4Error$.MODULE$.invalidOperationError(box.dim() == 1 && box.nElement() >= 4, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"box dim ", " should be 1 and it should has"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)box.dim())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"more than 4 elements which are actual ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)box.nElement())}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        return (BoxesRunTime.unboxToFloat((Object)box.valueAt(3)) - BoxesRunTime.unboxToFloat((Object)box.valueAt(1)) + 1.0f) * (BoxesRunTime.unboxToFloat((Object)box.valueAt(4)) - BoxesRunTime.unboxToFloat((Object)box.valueAt(2)) + 1.0f);
    }

    public Tensor<Object> getAreas(Tensor<Object> boxes, Tensor<Object> areas, int startInd, boolean normalized) {
        if (boxes.nElement() == 0) {
            return areas;
        }
        Log4Error$.MODULE$.invalidOperationError(boxes.size(2) >= 4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"boxes.size(2) ", " should be greater than 4"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)boxes.size(2))})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        areas.resize(boxes.size(1));
        float[] boxesArr = (float[])boxes.storage().array();
        int offset = boxes.storageOffset() - 1;
        int rowLength = boxes.stride(1);
        int boffset = offset + startInd - 1;
        for (int i = 0; i < boxes.size(1); ++i) {
            float x1 = boxesArr[boffset];
            float y1 = boxesArr[boffset + 1];
            float x2 = boxesArr[boffset + 2];
            float y2 = boxesArr[boffset + 3];
            Tensor<Object> tensor = normalized ? areas.setValue(i + 1, BoxesRunTime.boxToFloat((float)((x2 - x1) * (y2 - y1)))) : areas.setValue(i + 1, BoxesRunTime.boxToFloat((float)((x2 - x1 + 1.0f) * (y2 - y1 + 1.0f))));
            boffset += rowLength;
        }
        return areas;
    }

    public int getAreas$default$3() {
        return 1;
    }

    public boolean getAreas$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, Tensor<Object>> getGroundTruths(Tensor<Object> result2) {
        void var3_3;
        Tuple2[] indices = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.getGroundTruthIndices(result2).toArray(ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Tuple2<Object, Object>> x$1) {
                return x$1._1$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Map gtMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        int ind = 0;
        for (Tuple2 x : Predef$.MODULE$.refArrayOps((Object[])indices)) {
            Tensor<Object> gt = result2.narrow(1, ((Tuple2)x._2())._1$mcI$sp(), ((Tuple2)x._2())._2$mcI$sp());
            if (gt.size(1) > 1 || BoxesRunTime.unboxToFloat((Object)gt.valueAt(1, 2)) != (float)-1) {
                gtMap = gtMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)ind)), gt));
            }
            ++ind;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, Tuple2<Object, Object>> getGroundTruthIndices(Tensor<Object> result2) {
        void var2_2;
        int i;
        Map indices = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        if (result2.nElement() == 0) {
            return indices;
        }
        float prev = -1.0f;
        int start2 = 1;
        if (result2.size(1) == 1) {
            indices = indices.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat((Object)result2.valueAt(i, 1))))), (Object)new Tuple2.mcII.sp(1, 1)));
            return indices;
        }
        for (i = 1; i <= result2.size(1); ++i) {
            if (prev != BoxesRunTime.unboxToFloat((Object)result2.valueAt(i, 1))) {
                if (prev >= 0.0f) {
                    indices = indices.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((int)prev))), (Object)new Tuple2.mcII.sp(start2, i - start2)));
                }
                start2 = i;
            }
            prev = BoxesRunTime.unboxToFloat((Object)result2.valueAt(i, 1));
            if (i != result2.size(1)) continue;
            indices = indices.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((int)prev))), (Object)new Tuple2.mcII.sp(start2, i - start2 + 1)));
        }
        return var2_2;
    }

    private void decodeSignalBoxWithWeight(Tensor<Object> encodeBox, Tensor<Object> bbox, float[] weight, Tensor<Object> decodeBox) {
        Log4Error$.MODULE$.invalidOperationError(bbox.nDimension() == 1 && encodeBox.nDimension() == 1 && decodeBox.dim() == 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support decode single bbox, but "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bbox.nDimension()), BoxesRunTime.boxToInteger((int)encodeBox.nDimension()), BoxesRunTime.boxToInteger((int)decodeBox.dim())}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(encodeBox.nElement() == decodeBox.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number of encode tensor"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" and decode tensor should be same, but get ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)encodeBox.nElement()), BoxesRunTime.boxToInteger((int)decodeBox.nElement())}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        boolean TO_REMOVE = true;
        float x1 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(1));
        float y1 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(2));
        float x2 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(3));
        float y2 = BoxesRunTime.unboxToFloat((Object)bbox.valueAt(4));
        float priorWidth = x2 - x1 + (float)TO_REMOVE;
        float priorHight = y2 - y1 + (float)TO_REMOVE;
        float pCenterX = x1 + priorWidth / (float)2;
        float pCenterY = y1 + priorHight / (float)2;
        float wx = weight[0];
        float wy = weight[1];
        float ww = weight[2];
        float wh = weight[3];
        encodeBox.resize(new int[]{encodeBox.nElement() / 4, 4}, encodeBox.resize$default$2());
        Tensor<Object> dx = encodeBox.select(2, 1).contiguous().div(BoxesRunTime.boxToFloat((float)wx));
        Tensor<Object> dy = encodeBox.select(2, 2).contiguous().div(BoxesRunTime.boxToFloat((float)wy));
        Tensor<Object> dw = encodeBox.select(2, 3).contiguous().div(BoxesRunTime.boxToFloat((float)ww));
        Tensor<Object> dh = encodeBox.select(2, 4).contiguous().div(BoxesRunTime.boxToFloat((float)wh));
        encodeBox.resize(encodeBox.nElement());
        float bboxClip = 62.5f;
        this.clamp(dw, 0.0f, bboxClip);
        this.clamp(dh, 0.0f, bboxClip);
        Tensor<Object> pred_ctr_x = dx.$times(BoxesRunTime.boxToFloat((float)priorWidth)).$plus(BoxesRunTime.boxToFloat((float)pCenterX));
        Tensor<Object> pred_ctr_y = dy.$times(BoxesRunTime.boxToFloat((float)priorHight)).$plus(BoxesRunTime.boxToFloat((float)pCenterY));
        Tensor<Float> pred_w = dw.exp().mul(BoxesRunTime.boxToFloat((float)priorWidth)).mul(BoxesRunTime.boxToFloat((float)0.5f));
        Tensor<Float> pred_h = dh.exp().mul(BoxesRunTime.boxToFloat((float)priorHight)).mul(BoxesRunTime.boxToFloat((float)0.5f));
        Tensor<Tensor<Float>> buffer1 = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(pred_ctr_x).copy(pred_ctr_x).sub(pred_w);
        Tensor<Tensor<Float>> buffer2 = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(pred_ctr_y).copy(pred_ctr_y).sub(pred_h);
        Tensor<Tensor<Float>> buffer3 = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(pred_ctr_x).copy(pred_ctr_x).add(pred_w).add((Tensor<Float>)((Object)BoxesRunTime.boxToFloat((float)-1.0f)));
        Tensor<Tensor<Float>> buffer4 = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(pred_ctr_y).copy(pred_ctr_y).add(pred_h).add((Tensor<Float>)((Object)BoxesRunTime.boxToFloat((float)-1.0f)));
        float[] arrBuffer1 = (float[])buffer1.storage().array();
        float[] arrBuffer2 = (float[])buffer2.storage().array();
        float[] arrBuffer3 = (float[])buffer3.storage().array();
        float[] arrBuffer4 = (float[])buffer4.storage().array();
        float[] arrBox = (float[])decodeBox.storage().array();
        int offset = decodeBox.storageOffset() - 1;
        int i = 0;
        int j = 0;
        while (i < arrBuffer1.length) {
            arrBox[j + offset] = arrBuffer1[i];
            arrBox[j + 1 + offset] = arrBuffer2[i];
            arrBox[j + 2 + offset] = arrBuffer3[i];
            arrBox[j + 3 + offset] = arrBuffer4[i];
            ++i;
            j += 4;
        }
    }

    public void decodeWithWeight(Tensor<Object> encodeBox, Tensor<Object> bbox, float[] weight, Tensor<Object> decodeBox) {
        Log4Error$.MODULE$.invalidOperationError(encodeBox.size(1) == bbox.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"encodeBox.size(1) ", " should"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)encodeBox.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" match bbox.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bbox.size(1))}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(encodeBox.size(1) == decodeBox.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"encodeBox.size(1) ", " should"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)encodeBox.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" match decodeBox.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decodeBox.size(1))}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        int numBboxes = bbox.size(1);
        if (numBboxes > 0) {
            Log4Error$.MODULE$.invalidOperationError(bbox.size(2) == 4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bbox.size(2) should be 4, but actually is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bbox.size(2))})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
        for (int i = 1; i <= numBboxes; ++i) {
            this.decodeSignalBoxWithWeight(encodeBox.select(1, i), bbox.select(1, i), weight, decodeBox.select(1, i));
        }
    }

    private void clamp(Tensor<Object> input, float min2, float max2) {
        Log4Error$.MODULE$.invalidInputError(input.isContiguous(), "input for clamp should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        float[] arr = (float[])input.storage().array();
        int offset = input.storageOffset() - 1;
        for (int i = 0; i < arr.length; ++i) {
            float value2 = arr[i];
            if (value2 < min2) {
                arr[i] = value2;
            }
            if (!(value2 > max2)) continue;
            arr[i] = max2;
        }
    }

    private BboxUtil$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

