/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.transform.vision.image.opencv;

import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.opencv.OpenCVMat;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.opencv.OpenCV;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.imgcodecs.Imgcodecs;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class OpenCVMat$
implements Serializable {
    public static final OpenCVMat$ MODULE$;

    static {
        new OpenCVMat$();
    }

    public OpenCVMat read(String path) {
        byte[] bytes = FileUtils.readFileToByteArray(new File(path));
        return this.fromImageBytes(bytes);
    }

    public OpenCVMat fromImageBytes(byte[] fileContent) {
        Mat mat = null;
        MatOfByte matOfByte = null;
        OpenCVMat result2 = null;
        try {
            try {
                matOfByte = new MatOfByte(fileContent);
                mat = Imgcodecs.imdecode((Mat)matOfByte, (int)-1);
                result2 = new OpenCVMat(mat);
            }
            catch (Exception exception) {
                if (result2 != null) {
                    result2.release();
                }
                boolean x$1 = false;
                String x$2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed in imdecode mat"})).s((Seq)Nil$.MODULE$);
                Exception x$3 = exception;
                String x$4 = Log4Error$.MODULE$.unKnowExceptionError$default$3();
                Log4Error$.MODULE$.unKnowExceptionError(x$1, x$2, x$4, x$3);
            }
        }
        finally {
            if (mat != null) {
                mat.release();
            }
            if (matOfByte != null) {
                matOfByte.release();
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] imencode(OpenCVMat mat, String encoding) {
        byte[] byArray;
        MatOfByte buf = new MatOfByte();
        try {
            Imgcodecs.imencode((String)new StringBuilder().append((Object)".").append((Object)encoding).toString(), (Mat)mat, (MatOfByte)buf);
            byArray = buf.toArray();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.release();
            throw throwable;
        }
        buf.release();
        return byArray;
    }

    public String imencode$default$2() {
        return "png";
    }

    public OpenCVMat fromFloats(float[] floats, int height, int width, int channel) {
        Log4Error$.MODULE$.invalidInputError(channel >= 1 && channel <= 4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"channel ", " is out of range [1,4]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)channel)})), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(floats.length >= height * width * channel, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pixels array length ", " is less than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)floats.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"height*width*channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(height * width * channel))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        OpenCVMat mat = new OpenCVMat();
        mat.create(height, width, CvType.CV_32FC((int)channel));
        mat.put(0, 0, floats);
        return mat;
    }

    public int fromFloats$default$4() {
        return 3;
    }

    public Tuple4<byte[], Object, Object, Object> toBytePixels(Mat input, byte[] buffer) {
        int channel = input.channels();
        if (input.type() != CvType.CV_8UC((int)channel)) {
            input.convertTo(input, CvType.CV_8UC((int)channel));
        }
        byte[] bytes = buffer;
        int length = input.channels() * input.height() * input.width();
        if (buffer == null || buffer.length < length) {
            bytes = new byte[length];
        }
        input.get(0, 0, bytes);
        return new Tuple4((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)input.height()), (Object)BoxesRunTime.boxToInteger((int)input.width()), (Object)BoxesRunTime.boxToInteger((int)channel));
    }

    public byte[] toBytePixels$default$2() {
        return null;
    }

    public Tuple4<float[], Object, Object, Object> toFloatPixels(Mat input, float[] buffer) {
        float[] floats = buffer;
        int length = input.channels() * input.height() * input.width();
        if (buffer == null || buffer.length < length) {
            floats = new float[length];
        }
        int channel = input.channels();
        if (input.type() != CvType.CV_32FC((int)channel)) {
            input.convertTo(input, CvType.CV_32FC((int)channel));
        }
        input.get(0, 0, floats);
        return new Tuple4((Object)floats, (Object)BoxesRunTime.boxToInteger((int)input.height()), (Object)BoxesRunTime.boxToInteger((int)input.width()), (Object)BoxesRunTime.boxToInteger((int)channel));
    }

    public float[] toFloatPixels$default$2() {
        return null;
    }

    public OpenCVMat fromPixelsBytes(byte[] pixels, int height, int width, int channel) {
        Log4Error$.MODULE$.invalidInputError(channel >= 1 && channel <= 4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"channel ", " is out of range [1,4]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)channel)})), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(pixels.length >= height * width * channel, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pixels array length ", " is less than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pixels.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"height*width*channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(height * width * channel))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        OpenCVMat mat = new OpenCVMat();
        mat.create(height, width, CvType.CV_8UC((int)channel));
        mat.put(0, 0, pixels);
        return mat;
    }

    public int fromPixelsBytes$default$4() {
        return 3;
    }

    /*
     * Unable to fully structure code
     */
    public OpenCVMat fromTensor(Tensor<Object> tensor, String format) {
        v0 = format;
        var3_3 = "HWC";
        if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
        v1 = format;
        var4_4 = "CHW";
        if (!(v1 != null ? v1.equals(var4_4) == false : var4_4 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Log4Error$.MODULE$.invalidInputError(v2, "the format should be HWC or CHW", Log4Error$.MODULE$.invalidInputError$default$3());
        v3 = format;
        var6_5 = "CHW";
        image = !(v3 != null ? v3.equals(var6_5) == false : var6_5 != null) ? tensor.transpose(1, 2).transpose(2, 3) : tensor;
        image = image.contiguous();
        offset = tensor.storageOffset() - 1;
        floatArr = (float[])image.storage().array();
        if (offset > 0) {
            floatArr = (float[])Predef$.MODULE$.floatArrayOps(floatArr).slice(offset, tensor.nElement() + offset);
        }
        return this.fromFloats(floatArr, image.size(1), image.size(2), image.size(3));
    }

    public String fromTensor$default$2() {
        return "HWC";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OpenCVMat$() {
        MODULE$ = this;
        OpenCV.isOpenCVLoaded();
    }
}

