/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.transform.vision.image.label.roi;

import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.label.roi.BatchSampler$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.label.roi.RoiLabel;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.util.BoundingBox;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.util.BoundingBox$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.RandomGenerator$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001e\u0011ABQ1uG\"\u001c\u0016-\u001c9mKJT!a\u0001\u0003\u0002\u0007I|\u0017N\u0003\u0002\u0006\r\u0005)A.\u00192fY*\u0011q\u0001C\u0001\u0006S6\fw-\u001a\u0006\u0003\u0013)\taA^5tS>t'BA\u0006\r\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\u000e\u001d\u00059a-Z1ukJ,'BA\b\u0011\u0003\u0015!G\u000e\\5c\u0015\t\t\"#A\u0003cS\u001e$GN\u0003\u0002\u0014)\u0005I\u0011M\\1msRL7m\u001d\u0006\u0003+Y\tQ!\u001b8uK2T\u0011aF\u0001\u0004G>l7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005IQ.\u0019=TC6\u0004H.\u001a\t\u00037\u0019J!a\n\u000f\u0003\u0007%sG\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003&\u0003%i\u0017\r\u001f+sS\u0006d7\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003!i\u0017N\\*dC2,\u0007CA\u000e.\u0013\tqCD\u0001\u0004E_V\u0014G.\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005Y\u0005AQ.\u0019=TG\u0006dW\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003-\u00039i\u0017N\\!ta\u0016\u001cGOU1uS>D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000f[\u0006D\u0018i\u001d9fGR\u0014\u0016\r^5p\u0011!1\u0004A!A!\u0002\u00139\u0014AC7j]>3XM\u001d7baB\u00191\u0004\u000f\u0017\n\u0005eb\"AB(qi&|g\u000e\u0003\u0005<\u0001\t\u0005\t\u0015!\u00038\u0003)i\u0017\r_(wKJd\u0017\r\u001d\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013}\n%i\u0011#F\r\u001eC\u0005C\u0001!\u0001\u001b\u0005\u0011\u0001b\u0002\u0013=!\u0003\u0005\r!\n\u0005\bSq\u0002\n\u00111\u0001&\u0011\u001dYC\b%AA\u00021Bq\u0001\r\u001f\u0011\u0002\u0003\u0007A\u0006C\u00043yA\u0005\t\u0019\u0001\u0017\t\u000fQb\u0004\u0013!a\u0001Y!9a\u0007\u0010I\u0001\u0002\u00049\u0004bB\u001e=!\u0003\u0005\ra\u000e\u0005\u0006\u0015\u0002!\taS\u0001\u0018g\u0006$\u0018n\u001d4z'\u0006l\u0007\u000f\\3D_:\u001cHO]1j]R$2\u0001T(X!\tYR*\u0003\u0002O9\t9!i\\8mK\u0006t\u0007\"\u0002)J\u0001\u0004\t\u0016AC:b[BdW\r\u001a\"pqB\u0011!+V\u0007\u0002'*\u0011AKB\u0001\u0005kRLG.\u0003\u0002W'\nY!i\\;oI&twMQ8y\u0011\u0015A\u0016\n1\u0001Z\u0003\u0019!\u0018M]4fiB\u0011\u0001IW\u0005\u00037\n\u0011\u0001BU8j\u0019\u0006\u0014W\r\u001c\u0005\u0006;\u0002!\tAX\u0001\u0007g\u0006l\u0007\u000f\\3\u0015\t}\u0013G-\u001a\t\u00037\u0001L!!\u0019\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006Gr\u0003\r!U\u0001\ng>,(oY3C_bDQ\u0001\u0017/A\u0002eCQA\u001a/A\u0002\u001d\fAb]1na2,GMQ8yKN\u00042\u0001[7R\u001b\u0005I'B\u00016l\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001c\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002oS\nY\u0011I\u001d:bs\n+hMZ3s\u0011\u0015\u0001\b\u0001\"\u0003r\u0003%\u0019\u0018-\u001c9mK\n{\u0007\u0010F\u0001R\u0011\u0015\u0019\b\u0001\"\u0003u\u00039Q\u0017mY2be\u0012|e/\u001a:mCB$R!\u001e={\u0003\u000b\u0001\"a\u0007<\n\u0005]d\"!\u0002$m_\u0006$\b\"B=s\u0001\u0004\t\u0016\u0001\u00022c_bDQa\u001f:A\u0002q\fqa\u001a;C_b,7\u000f\u0005\u0003~\u0003\u0003)X\"\u0001@\u000b\u0005}t\u0011A\u0002;f]N|'/C\u0002\u0002\u0004y\u0014a\u0001V3og>\u0014\bBBA\u0004e\u0002\u0007Q%A\u0001j\u000f\u001d\tYA\u0001E\u0001\u0003\u001b\tABQ1uG\"\u001c\u0016-\u001c9mKJ\u00042\u0001QA\b\r\u0019\t!\u0001#\u0001\u0002\u0012M!\u0011q\u0002\u000e!\u0011\u001di\u0014q\u0002C\u0001\u0003+!\"!!\u0004\t\u0011\u0005e\u0011q\u0002C\u0001\u00037\tAcZ3oKJ\fG/\u001a\"bi\u000eD7+Y7qY\u0016\u001cHcB0\u0002\u001e\u0005}\u0011\u0011\u0006\u0005\u0007\u000b\u0005]\u0001\u0019A-\t\u0011\u0005\u0005\u0012q\u0003a\u0001\u0003G\tQBY1uG\"\u001c\u0016-\u001c9mKJ\u001c\b\u0003B\u000e\u0002&}J1!a\n\u001d\u0005\u0015\t%O]1z\u0011\u00191\u0017q\u0003a\u0001O\"Q\u0011QFA\b#\u0003%\t!a\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tDK\u0002&\u0003gY#!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007fa\u0012AC1o]>$\u0018\r^5p]&!\u00111IA\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003\u000f\ny!%A\u0005\u0002\u0005=\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0002L\u0005=\u0011\u0013!C\u0001\u0003\u001b\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA(U\ra\u00131\u0007\u0005\u000b\u0003'\ny!%A\u0005\u0002\u00055\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0002X\u0005=\u0011\u0013!C\u0001\u0003\u001b\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004BCA.\u0003\u001f\t\n\u0011\"\u0001\u0002N\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIYB!\"a\u0018\u0002\u0010E\u0005I\u0011AA1\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011\u00111\r\u0016\u0004o\u0005M\u0002BCA4\u0003\u001f\t\n\u0011\"\u0001\u0002b\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIaB!\"a\u001b\u0002\u0010\u0005\u0005I\u0011BA7\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0005Y\u0006twM\u0003\u0002\u0002z\u0005!!.\u0019<b\u0013\u0011\ti(a\u001d\u0003\r=\u0013'.Z2u\u0001")
public class BatchSampler
implements Serializable {
    private final int maxSample;
    private final int maxTrials;
    private final double minScale;
    private final double maxScale;
    private final double minAspectRatio;
    private final double maxAspectRatio;
    private final Option<Object> minOverlap;
    private final Option<Object> maxOverlap;

    public static Option<Object> $lessinit$greater$default$8() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Object> $lessinit$greater$default$7() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$7();
    }

    public static double $lessinit$greater$default$6() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$5() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$5();
    }

    public static double $lessinit$greater$default$4() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$4();
    }

    public static double $lessinit$greater$default$3() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$1() {
        return BatchSampler$.MODULE$.$lessinit$greater$default$1();
    }

    public static void generateBatchSamples(RoiLabel roiLabel, BatchSampler[] batchSamplerArray, ArrayBuffer<BoundingBox> arrayBuffer) {
        BatchSampler$.MODULE$.generateBatchSamples(roiLabel, batchSamplerArray, arrayBuffer);
    }

    public boolean satisfySampleConstraint(BoundingBox sampledBox, RoiLabel target) {
        if (this.minOverlap.isEmpty() && this.maxOverlap.isEmpty()) {
            return true;
        }
        for (int i = 1; i <= target.size(); ++i) {
            float overlap = this.jaccardOverlap(sampledBox, target.bboxes(), i);
            if (!this.minOverlap.isEmpty() && !((double)overlap >= BoxesRunTime.unboxToDouble((Object)this.minOverlap.get())) || !this.maxOverlap.isEmpty() && !((double)overlap <= BoxesRunTime.unboxToDouble((Object)this.maxOverlap.get()))) continue;
            return true;
        }
        return false;
    }

    public void sample(BoundingBox sourceBox, RoiLabel target, ArrayBuffer<BoundingBox> sampledBoxes) {
        int found = 0;
        for (int trial = 0; trial < this.maxTrials; ++trial) {
            if (found >= this.maxSample) {
                return;
            }
            BoundingBox sampledBox = this.sampleBox();
            sourceBox.locateBBox(sampledBox, sampledBox);
            if (!this.satisfySampleConstraint(sampledBox, target)) continue;
            ++found;
            sampledBoxes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BoundingBox[]{sampledBox}));
        }
    }

    private BoundingBox sampleBox() {
        double scale = RandomGenerator$.MODULE$.RNG().uniform(this.minScale, this.maxScale);
        double ratio = RandomGenerator$.MODULE$.RNG().uniform(this.minAspectRatio, this.maxAspectRatio);
        ratio = Math.max(ratio, scale * scale);
        ratio = Math.min(ratio, 1.0 / scale / scale);
        double width = scale * Math.sqrt(ratio);
        double height = scale / Math.sqrt(ratio);
        float x1 = (float)RandomGenerator$.MODULE$.RNG().uniform(0.0, 1.0 - width);
        float y1 = (float)RandomGenerator$.MODULE$.RNG().uniform(0.0, 1.0 - height);
        float x2 = x1 + (float)width;
        float y2 = y1 + (float)height;
        return BoundingBox$.MODULE$.apply(x1, y1, x2, y2, BoundingBox$.MODULE$.apply$default$5());
    }

    private float jaccardOverlap(BoundingBox bbox, Tensor<Object> gtBoxes, int i) {
        BoundingBox gtBox = BoundingBox$.MODULE$.apply(BoxesRunTime.unboxToFloat((Object)gtBoxes.valueAt(i, 1)), BoxesRunTime.unboxToFloat((Object)gtBoxes.valueAt(i, 2)), BoxesRunTime.unboxToFloat((Object)gtBoxes.valueAt(i, 3)), BoxesRunTime.unboxToFloat((Object)gtBoxes.valueAt(i, 4)), BoundingBox$.MODULE$.apply$default$5());
        return bbox.jaccardOverlap(gtBox);
    }

    public BatchSampler(int maxSample, int maxTrials, double minScale, double maxScale, double minAspectRatio, double maxAspectRatio, Option<Object> minOverlap, Option<Object> maxOverlap) {
        this.maxSample = maxSample;
        this.maxTrials = maxTrials;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.minAspectRatio = minAspectRatio;
        this.maxAspectRatio = maxAspectRatio;
        this.minOverlap = minOverlap;
        this.maxOverlap = maxOverlap;
        Log4Error$.MODULE$.invalidInputError(minScale <= maxScale, "minScale must <= maxScale", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(minScale > 0.0 && minScale <= 1.0, "minScale must in (0, 1]", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(maxScale > 0.0 && maxScale <= 1.0, "maxScale must in (0, 1]", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(minAspectRatio > 0.0 && minAspectRatio <= 1.0, "minAspectRatio must in (0, 1]", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(maxAspectRatio >= 1.0, "minAspectRatio must >= 1", Log4Error$.MODULE$.invalidInputError$default$3());
        if (minOverlap.isDefined()) {
            Log4Error$.MODULE$.invalidInputError(BoxesRunTime.unboxToDouble((Object)minOverlap.get()) >= 0.0 && BoxesRunTime.unboxToDouble((Object)minOverlap.get()) <= 1.0, "minOverlap must in [0, 1]", Log4Error$.MODULE$.invalidInputError$default$3());
        }
    }
}

