/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.text;

import com.intel.analytics.bigdl.dllib.feature.common.Relation;
import com.intel.analytics.bigdl.dllib.feature.common.RelationPair;
import com.intel.analytics.bigdl.dllib.feature.common.Relations$;
import com.intel.analytics.bigdl.dllib.feature.dataset.Sample$;
import com.intel.analytics.bigdl.dllib.feature.text.DistributedTextSet;
import com.intel.analytics.bigdl.dllib.feature.text.LocalTextSet;
import com.intel.analytics.bigdl.dllib.feature.text.TextFeature;
import com.intel.analytics.bigdl.dllib.feature.text.TextFeature$;
import com.intel.analytics.bigdl.dllib.feature.text.TextSet;
import com.intel.analytics.bigdl.dllib.feature.text.TextSet$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class TextSet$ {
    public static final TextSet$ MODULE$;
    private final Logger logger;

    static {
        new TextSet$();
    }

    public Logger logger() {
        return this.logger;
    }

    public LocalTextSet array(TextFeature[] data2) {
        return new LocalTextSet(data2);
    }

    public DistributedTextSet rdd(RDD<TextFeature> data2) {
        return new DistributedTextSet(data2);
    }

    public TextSet read(String path, SparkContext sc, int minPartitions) {
        TextSet textSet;
        if (sc == null) {
            ArrayBuffer features2 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            HashMap categoryToLabel = new HashMap();
            File categoryPath = new File(path);
            Log4Error$.MODULE$.invalidInputError(categoryPath.exists(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't exist. Please check your input path"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), Log4Error$.MODULE$.invalidInputError$default$3());
            List categoryPathList = (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])categoryPath.listFiles()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$2) {
                    return x$2.isDirectory();
                }
            })).toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            categoryPathList.foreach((Function1)new Serializable(features2, categoryToLabel){
                public static final long serialVersionUID = 0L;
                public final ArrayBuffer features$1;
                private final HashMap categoryToLabel$2;

                public final void apply(File categoryPath) {
                    int label = this.categoryToLabel$2.size();
                    this.categoryToLabel$2.put(categoryPath.getName(), BoxesRunTime.boxToInteger((int)label));
                    File[] textFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])categoryPath.listFiles()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$3) {
                            return x$3.isFile();
                        }
                    })).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$4) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$4.getName())).forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(char x$5) {
                                    return Character.isDigit(x$5);
                                }
                            });
                        }
                    })).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    Predef$.MODULE$.refArrayOps((Object[])textFiles).foreach((Function1)new Serializable(this, label){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.5 $outer;
                        private final int label$1;

                        /*
                         * WARNING - void declaration
                         */
                        public final void apply(File file) {
                            String string;
                            BufferedSource source = Source$.MODULE$.fromFile(file, "ISO-8859-1");
                            try {
                                string = source.getLines().toList().mkString("\n");
                            }
                            catch (Throwable throwable) {
                                void var2_2;
                                var2_2.close();
                                throw throwable;
                            }
                            source.close();
                            String text = string;
                            this.$outer.features$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TextFeature[]{TextFeature$.MODULE$.apply(text, this.label$1, file.getAbsolutePath())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.label$1 = label$1;
                        }
                    });
                }
                {
                    this.features$1 = features$1;
                    this.categoryToLabel$2 = categoryToLabel$2;
                }
            });
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " classes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)categoryToLabel.size())})));
            textSet = this.array((TextFeature[])features2.toArray(ClassTag$.MODULE$.apply(TextFeature.class)));
        } else {
            URI uri = StringUtils.stringToURI((String[])((String[])((Object[])new String[]{path})))[0];
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)new Configuration());
            String[] categories = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(path))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$1) {
                    return x$1.getPath().getName();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$);
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " classes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)categories.length)})));
            Range indices = Predef$.MODULE$.refArrayOps((Object[])categories).indices();
            Map categoryToLabel = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])categories).zip((GenIterable)indices, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
            RDD textRDD = sc.wholeTextFiles(new StringBuilder().append((Object)path).append((Object)"/*").toString(), minPartitions).map((Function1)new Serializable(categoryToLabel){
                public static final long serialVersionUID = 0L;
                private final Map categoryToLabel$1;

                public final TextFeature apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String p = (String)tuple2._1();
                        String text = (String)tuple2._2();
                        String[] parts = p.split("/");
                        String category = parts[parts.length - 2];
                        TextFeature textFeature = TextFeature$.MODULE$.apply(text, BoxesRunTime.unboxToInt((Object)this.categoryToLabel$1.apply((Object)category)), p);
                        return textFeature;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.categoryToLabel$1 = categoryToLabel$1;
                }
            }, ClassTag$.MODULE$.apply(TextFeature.class));
            textSet = this.rdd((RDD<TextFeature>)textRDD);
        }
        LocalTextSet textSet2 = textSet;
        return textSet2;
    }

    public SparkContext read$default$2() {
        return null;
    }

    public int read$default$3() {
        return 1;
    }

    public TextSet readCSV(String path, SparkContext sc, int minPartitions) {
        TextSet textSet;
        if (sc == null) {
            BufferedSource src = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());
            TextFeature[] textArray = (TextFeature[])Predef$.MODULE$.refArrayOps((Object[])src.getLines().toArray(ClassTag$.MODULE$.apply(String.class))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TextFeature apply(String line) {
                    String[] subs = line.split(",", 2);
                    return TextFeature$.MODULE$.apply(subs[1], subs[0]);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TextFeature.class)));
            textSet = this.array(textArray);
        } else {
            RDD textRDD = sc.textFile(path, minPartitions).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TextFeature apply(String line) {
                    String[] subs = line.split(",", 2);
                    return TextFeature$.MODULE$.apply(subs[1], subs[0]);
                }
            }, ClassTag$.MODULE$.apply(TextFeature.class));
            textSet = this.rdd((RDD<TextFeature>)textRDD);
        }
        return textSet;
    }

    public SparkContext readCSV$default$2() {
        return null;
    }

    public int readCSV$default$3() {
        return 1;
    }

    public DistributedTextSet readParquet(String path, SQLContext sqlContext) {
        RDD textRDD = sqlContext.read().parquet(path).rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TextFeature apply(Row row) {
                String uri = (String)row.getAs("id");
                String text = (String)row.getAs(TextFeature$.MODULE$.text());
                return TextFeature$.MODULE$.apply(text, uri);
            }
        }, ClassTag$.MODULE$.apply(TextFeature.class));
        return this.rdd((RDD<TextFeature>)textRDD);
    }

    public DistributedTextSet fromRelationPairs(RDD<Relation> relations, TextSet corpus1, TextSet corpus2) {
        RDD<RelationPair> pairsRDD = Relations$.MODULE$.generateRelationPairs(relations);
        Log4Error$.MODULE$.invalidOperationError(corpus1.isDistributed(), "corpus1 must be a DistributedTextSet", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(corpus2.isDistributed(), "corpus2 must be a DistributedTextSet", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        RDD joinedText1 = RDD$.MODULE$.rddToPairRDDFunctions(corpus1.toDistributed(corpus1.toDistributed$default$1(), corpus1.toDistributed$default$2()).rdd().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TextFeature x$6) {
                return x$6.getURI();
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(TextFeature.class), (Ordering)Ordering.String$.MODULE$).join(pairsRDD.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RelationPair x$7) {
                return x$7.id1();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TextFeature, RelationPair> apply(Tuple2<String, Tuple2<TextFeature, RelationPair>> x$8) {
                return (Tuple2)x$8._2();
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD joinedText2Pos = RDD$.MODULE$.rddToPairRDDFunctions(corpus2.toDistributed(corpus2.toDistributed$default$1(), corpus2.toDistributed$default$2()).rdd().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TextFeature x$9) {
                return x$9.getURI();
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(TextFeature.class), (Ordering)Ordering.String$.MODULE$).join(joinedText1.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TextFeature, RelationPair> x$10) {
                return ((RelationPair)x$10._2()).id2Positive();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<TextFeature, TextFeature, RelationPair> apply(Tuple2<String, Tuple2<TextFeature, Tuple2<TextFeature, RelationPair>>> x) {
                return new Tuple3(((Tuple2)((Tuple2)x._2())._2())._1(), ((Tuple2)x._2())._1(), ((Tuple2)((Tuple2)x._2())._2())._2());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD joinedText2Neg = RDD$.MODULE$.rddToPairRDDFunctions(corpus2.toDistributed(corpus2.toDistributed$default$1(), corpus2.toDistributed$default$2()).rdd().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TextFeature x$11) {
                return x$11.getURI();
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(TextFeature.class), (Ordering)Ordering.String$.MODULE$).join(joinedText2Pos.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<TextFeature, TextFeature, RelationPair> x$12) {
                return ((RelationPair)x$12._3()).id2Negative();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<TextFeature, TextFeature, TextFeature> apply(Tuple2<String, Tuple2<TextFeature, Tuple3<TextFeature, TextFeature, RelationPair>>> x) {
                return new Tuple3(((Tuple3)((Tuple2)x._2())._2())._1(), ((Tuple3)((Tuple2)x._2())._2())._2(), ((Tuple2)x._2())._1());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD res = joinedText2Neg.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final TextFeature apply(Tuple3<TextFeature, TextFeature, TextFeature> x) {
                void var2_2;
                TextFeature textFeature = TextFeature$.MODULE$.apply(null, new StringBuilder().append((Object)((TextFeature)x._1()).getURI()).append((Object)((TextFeature)x._2()).getURI()).append((Object)((TextFeature)x._3()).getURI()).toString());
                float[] text1 = ((TextFeature)x._1()).getIndices();
                float[] text2Pos = ((TextFeature)x._2()).getIndices();
                float[] text2Neg = ((TextFeature)x._3()).getIndices();
                Log4Error$.MODULE$.invalidOperationError(text1 != null, "corpus1 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                Log4Error$.MODULE$.invalidOperationError(text2Pos != null && text2Neg != null, "corpus2 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                Log4Error$.MODULE$.invalidOperationError(text2Pos.length == text2Neg.length, "corpus2 contains texts with different lengths, please shapeSequence first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                float[] pairedIndices = (float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(text1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(text2Pos), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(text1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(text2Neg), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                Tensor<Object> feature = Tensor$.MODULE$.apply$mFc$sp(pairedIndices, new int[]{2, text1.length + text2Pos.length}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                Tensor<Object> label = Tensor$.MODULE$.apply$mFc$sp(new float[]{1.0f, 0.0f}, new int[]{2, 1}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                textFeature.update(TextFeature$.MODULE$.sample(), Sample$.MODULE$.apply(feature, label, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
                return var2_2;
            }
        }, ClassTag$.MODULE$.apply(TextFeature.class)).setName("Pairwise Training Set");
        return this.rdd((RDD<TextFeature>)res);
    }

    public LocalTextSet fromRelationPairs(Relation[] relations, TextSet corpus1, TextSet corpus2) {
        RelationPair[] pairsArray = Relations$.MODULE$.generateRelationPairs(relations);
        Log4Error$.MODULE$.invalidInputError(corpus1.isLocal(), "corpus1 must be a LocalTextSet", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(corpus2.isLocal(), "corpus2 must be a LocalTextSet", Log4Error$.MODULE$.invalidInputError$default$3());
        scala.collection.mutable.Map mapText1 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map mapText2 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        TextFeature[] arrayText1 = corpus1.toLocal().array();
        TextFeature[] arrayText2 = corpus2.toLocal().array();
        Predef$.MODULE$.refArrayOps((Object[])arrayText1).foreach((Function1)new Serializable(mapText1){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mapText1$1;

            public final void apply(TextFeature text) {
                float[] indices = text.getIndices();
                Log4Error$.MODULE$.invalidOperationError(indices != null, "corpus1 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                this.mapText1$1.update((Object)text.getURI(), (Object)indices);
            }
            {
                this.mapText1$1 = mapText1$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])arrayText2).foreach((Function1)new Serializable(mapText2){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mapText2$1;

            public final void apply(TextFeature text) {
                float[] indices = text.getIndices();
                Log4Error$.MODULE$.invalidOperationError(indices != null, "corpus2 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                this.mapText2$1.update((Object)text.getURI(), (Object)indices);
            }
            {
                this.mapText2$1 = mapText2$1;
            }
        });
        TextFeature[] res = (TextFeature[])Predef$.MODULE$.refArrayOps((Object[])pairsArray).map((Function1)new Serializable(mapText1, mapText2){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mapText1$1;
            private final scala.collection.mutable.Map mapText2$1;

            public final TextFeature apply(RelationPair x) {
                float[] indices1 = (float[])this.mapText1$1.apply((Object)x.id1());
                float[] indices2Pos = (float[])this.mapText2$1.apply((Object)x.id2Positive());
                float[] indices2Neg = (float[])this.mapText2$1.apply((Object)x.id2Negative());
                Log4Error$.MODULE$.invalidOperationError(indices2Neg.length == indices2Pos.length, "corpus2 contains texts with different lengths, please shapeSequence first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                TextFeature textFeature = TextFeature$.MODULE$.apply(null, new StringBuilder().append((Object)x.id1()).append((Object)x.id2Positive()).append((Object)x.id2Negative()).toString());
                float[] pairedIndices = (float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(indices1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(indices2Pos), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(indices1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(indices2Neg), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                Tensor<Object> feature = Tensor$.MODULE$.apply$mFc$sp(pairedIndices, new int[]{2, indices1.length + indices2Pos.length}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                Tensor<Object> label = Tensor$.MODULE$.apply$mFc$sp(new float[]{1.0f, 0.0f}, new int[]{2, 1}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                textFeature.update(TextFeature$.MODULE$.sample(), Sample$.MODULE$.apply(feature, label, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
                return textFeature;
            }
            {
                this.mapText1$1 = mapText1$1;
                this.mapText2$1 = mapText2$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TextFeature.class)));
        return this.array(res);
    }

    public DistributedTextSet fromRelationLists(RDD<Relation> relations, TextSet corpus1, TextSet corpus2) {
        Log4Error$.MODULE$.invalidOperationError(corpus1.isDistributed(), "corpus1 must be a DistributedTextSet", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(corpus2.isDistributed(), "corpus2 must be a DistributedTextSet", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        RDD joinedText1 = RDD$.MODULE$.rddToPairRDDFunctions(corpus1.toDistributed(corpus1.toDistributed$default$1(), corpus1.toDistributed$default$2()).rdd().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TextFeature x$13) {
                return x$13.getURI();
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(TextFeature.class), (Ordering)Ordering.String$.MODULE$).join(relations.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Relation x$14) {
                return x$14.id1();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TextFeature, Relation> apply(Tuple2<String, Tuple2<TextFeature, Relation>> x$15) {
                return (Tuple2)x$15._2();
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD joinedText2 = RDD$.MODULE$.rddToPairRDDFunctions(corpus2.toDistributed(corpus2.toDistributed$default$1(), corpus2.toDistributed$default$2()).rdd().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TextFeature x$16) {
                return x$16.getURI();
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(TextFeature.class), (Ordering)Ordering.String$.MODULE$).join(joinedText1.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TextFeature, Relation> x$17) {
                return ((Relation)x$17._2()).id2();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<TextFeature, TextFeature, Object> apply(Tuple2<String, Tuple2<TextFeature, Tuple2<TextFeature, Relation>>> x) {
                return new Tuple3(((Tuple2)((Tuple2)x._2())._2())._1(), ((Tuple2)x._2())._1(), (Object)BoxesRunTime.boxToInteger((int)((Relation)((Tuple2)((Tuple2)x._2())._2())._2()).label()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD joinedLists = joinedText2.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<TextFeature, TextFeature, Object> x$18) {
                return ((TextFeature)x$18._1()).getURI();
            }
        }, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<TextFeature, TextFeature, Object>[] apply(Tuple2<String, Iterable<Tuple3<TextFeature, TextFeature, Object>>> x$19) {
                return (Tuple3[])((TraversableOnce)x$19._2()).toArray(ClassTag$.MODULE$.apply(Tuple3.class));
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple3.class)));
        RDD res = joinedLists.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TextFeature apply(Tuple3<TextFeature, TextFeature, Object>[] x) {
                TextFeature text1 = (TextFeature)((Tuple3)Predef$.MODULE$.refArrayOps((Object[])x).head())._1();
                TextFeature[] text2Array = (TextFeature[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TextFeature apply(Tuple3<TextFeature, TextFeature, Object> x$20) {
                        return (TextFeature)x$20._2();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TextFeature.class)));
                TextFeature textFeature = TextFeature$.MODULE$.apply(null, (String)new StringOps(Predef$.MODULE$.augmentString(text1.getURI())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])text2Array).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TextFeature x$21) {
                        return x$21.getURI();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(""))), Predef$.MODULE$.StringCanBuildFrom()));
                float[] text1Indices = text1.getIndices();
                Log4Error$.MODULE$.invalidOperationError(text1Indices != null, "corpus1 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                float[][] text2IndicesArray = (float[][])Predef$.MODULE$.refArrayOps((Object[])text2Array).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final float[] apply(TextFeature x$22) {
                        return x$22.getIndices();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
                Predef$.MODULE$.refArrayOps((Object[])text2IndicesArray).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(float[] x) {
                        Log4Error$.MODULE$.invalidOperationError(x != null, "corpus2 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                    }
                });
                float[] data2 = (float[])Predef$.MODULE$.refArrayOps((Object[])text2IndicesArray).flatMap((Function1)new Serializable(this, text1Indices){
                    public static final long serialVersionUID = 0L;
                    private final float[] text1Indices$1;

                    public final ArrayOps<Object> apply(float[] x$23) {
                        return Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(this.text1Indices$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(x$23), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())));
                    }
                    {
                        this.text1Indices$1 = text1Indices$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                Tensor<Object> feature = Tensor$.MODULE$.apply$mFc$sp(data2, new int[]{text2Array.length, text1Indices.length + ((float[])Predef$.MODULE$.refArrayOps((Object[])text2IndicesArray).head()).length}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                Tensor<Object> label = Tensor$.MODULE$.apply$mFc$sp((float[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final float apply(Tuple3<TextFeature, TextFeature, Object> x$24) {
                        return BoxesRunTime.unboxToInt((Object)x$24._3());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())), new int[]{text2Array.length, 1}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                textFeature.update(TextFeature$.MODULE$.sample(), Sample$.MODULE$.apply(feature, label, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
                return textFeature;
            }
        }, ClassTag$.MODULE$.apply(TextFeature.class)).setName("Listwise Evaluation Set");
        return this.rdd((RDD<TextFeature>)res);
    }

    public LocalTextSet fromRelationLists(Relation[] relations, TextSet corpus1, TextSet corpus2) {
        Log4Error$.MODULE$.invalidOperationError(corpus1.isLocal(), "corpus1 must be a LocalTextSet", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        Log4Error$.MODULE$.invalidOperationError(corpus2.isLocal(), "corpus2 must be a LocalTextSet", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        scala.collection.mutable.Map mapText1 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map mapText2 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        TextFeature[] arrayText1 = corpus1.toLocal().array();
        TextFeature[] arrayText2 = corpus2.toLocal().array();
        Predef$.MODULE$.refArrayOps((Object[])arrayText1).foreach((Function1)new Serializable(mapText1){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mapText1$2;

            public final void apply(TextFeature text) {
                float[] indices = text.getIndices();
                Log4Error$.MODULE$.invalidOperationError(indices != null, "corpus1 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                this.mapText1$2.update((Object)text.getURI(), (Object)indices);
            }
            {
                this.mapText1$2 = mapText1$2;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])arrayText2).foreach((Function1)new Serializable(mapText2){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mapText2$2;

            public final void apply(TextFeature text) {
                float[] indices = text.getIndices();
                Log4Error$.MODULE$.invalidOperationError(indices != null, "corpus2 haven't been transformed from word to index yet, please word2idx first", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                this.mapText2$2.update((Object)text.getURI(), (Object)indices);
            }
            {
                this.mapText2$2 = mapText2$2;
            }
        });
        scala.collection.mutable.Map text1Map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])relations).foreach((Function1)new Serializable(text1Map){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map text1Map$1;

            public final void apply(Relation rel) {
                if (this.text1Map$1.contains((Object)rel.id1())) {
                    ArrayBuffer id2Array = (ArrayBuffer)this.text1Map$1.apply((Object)rel.id1());
                    id2Array.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)rel.id2(), (Object)BoxesRunTime.boxToInteger((int)rel.label()))}));
                } else {
                    ArrayBuffer id2Array = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    id2Array.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)rel.id2(), (Object)BoxesRunTime.boxToInteger((int)rel.label()))}));
                    this.text1Map$1.update((Object)rel.id1(), (Object)id2Array);
                }
            }
            {
                this.text1Map$1 = text1Map$1;
            }
        });
        ArrayBuffer features2 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        text1Map.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, ArrayBuffer<Tuple2<String, Object>>> check$ifrefutable$1) {
                Tuple2<String, ArrayBuffer<Tuple2<String, Object>>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(mapText1, mapText2, features2){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mapText1$2;
            public final scala.collection.mutable.Map mapText2$2;
            private final ArrayBuffer features$2;

            public final void apply(Tuple2<String, ArrayBuffer<Tuple2<String, Object>>> x$28) {
                Tuple2<String, ArrayBuffer<Tuple2<String, Object>>> tuple2 = x$28;
                if (tuple2 != null) {
                    String id1 = (String)tuple2._1();
                    ArrayBuffer id2LabelArray = (ArrayBuffer)tuple2._2();
                    int id2ArrayLength = id2LabelArray.length();
                    TextFeature textFeature = TextFeature$.MODULE$.apply(null, (String)new StringOps(Predef$.MODULE$.augmentString(id1)).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)id2LabelArray.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, Object> x$25) {
                            return (String)x$25._1();
                        }
                    }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(""))), Predef$.MODULE$.StringCanBuildFrom()));
                    ArrayBuffer indices2Array = (ArrayBuffer)id2LabelArray.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fromRelationLists.5 $outer;

                        public final float[] apply(Tuple2<String, Object> x) {
                            return (float[])this.$outer.mapText2$2.apply((Object)((String)x._1()).toString());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ArrayBuffer$.MODULE$.canBuildFrom());
                    float[] indices1 = (float[])this.mapText1$2.apply((Object)id1);
                    float[] data2 = (float[])((TraversableOnce)indices2Array.flatMap((Function1)new Serializable(this, indices1){
                        public static final long serialVersionUID = 0L;
                        private final float[] indices1$1;

                        public final ArrayOps<Object> apply(float[] x$26) {
                            return Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(this.indices1$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(x$26), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())));
                        }
                        {
                            this.indices1$1 = indices1$1;
                        }
                    }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
                    Tensor<Object> feature = Tensor$.MODULE$.apply$mFc$sp(data2, new int[]{id2ArrayLength, indices1.length + ((float[])indices2Array.head()).length}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                    Tensor<Object> label = Tensor$.MODULE$.apply$mFc$sp((float[])Predef$.MODULE$.refArrayOps((Object[])id2LabelArray.toArray(ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply(Tuple2<String, Object> x$27) {
                            return x$27._2$mcI$sp();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())), new int[]{id2ArrayLength, 1}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                    textFeature.update(TextFeature$.MODULE$.sample(), Sample$.MODULE$.apply(feature, label, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
                    this.features$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TextFeature[]{textFeature}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.mapText1$2 = mapText1$2;
                this.mapText2$2 = mapText2$2;
                this.features$2 = features$2;
            }
        });
        return this.array((TextFeature[])features2.toArray(ClassTag$.MODULE$.apply(TextFeature.class)));
    }

    public Map<String, Object> wordsToMap(String[] words, Map<String, Object> existingMap) {
        Map map;
        if (existingMap == null) {
            Range indexes = package$.MODULE$.Range().apply(1, words.length + 1);
            map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])words).zip((GenIterable)indexes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(Tuple2<String, Object> item) {
                    return new Tuple2(item._1(), (Object)BoxesRunTime.boxToInteger((int)item._2$mcI$sp()));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        } else {
            scala.collection.mutable.Map resMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(existingMap.toSeq());
            IntRef i = IntRef.create((int)(BoxesRunTime.unboxToInt((Object)existingMap.values().max((Ordering)Ordering.Int$.MODULE$)) + 1));
            Predef$.MODULE$.refArrayOps((Object[])words).foreach((Function1)new Serializable(existingMap, resMap, i){
                public static final long serialVersionUID = 0L;
                private final Map existingMap$1;
                private final scala.collection.mutable.Map resMap$1;
                private final IntRef i$1;

                public final void apply(String word) {
                    if (!this.existingMap$1.contains((Object)word)) {
                        this.resMap$1.update((Object)word, (Object)BoxesRunTime.boxToInteger((int)this.i$1.elem));
                        ++this.i$1.elem;
                    }
                }
                {
                    this.existingMap$1 = existingMap$1;
                    this.resMap$1 = resMap$1;
                    this.i$1 = i$1;
                }
            });
            map = resMap.toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public Map<String, Object> wordsToMap$default$2() {
        return null;
    }

    private TextSet$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

