/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.dataset.image;

import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class Visualizer$ {
    public static final Visualizer$ MODULE$;
    private final Color bgColor;
    private final Font font;
    private final BasicStroke stroke;

    static {
        new Visualizer$();
    }

    private Color bgColor() {
        return this.bgColor;
    }

    private Font font() {
        return this.font;
    }

    private BasicStroke stroke() {
        return this.stroke;
    }

    private void vis(String imgPath, String className, Tensor<Object> scores, Tensor<Object> bboxes, String savePath, float thresh) {
        ObjectRef img = ObjectRef.create(null);
        ObjectRef g2d = ObjectRef.create(null);
        for (int i = 1; i <= scores.size(1); ++i) {
            float score = BoxesRunTime.unboxToFloat((Object)scores.valueAt(i));
            if (!(score > thresh)) continue;
            if ((Graphics2D)g2d.elem == null) {
                this.loadImage$1(imgPath, img, g2d);
            }
            Tensor<Object> bbox = bboxes.apply(i);
            this.draw((Graphics2D)g2d.elem, (int)BoxesRunTime.unboxToFloat((Object)bbox.valueAt(1)), (int)BoxesRunTime.unboxToFloat((Object)bbox.valueAt(2)), (int)BoxesRunTime.unboxToFloat((Object)bbox.valueAt(3)) - (int)BoxesRunTime.unboxToFloat((Object)bbox.valueAt(1)), (int)BoxesRunTime.unboxToFloat((Object)bbox.valueAt(4)) - (int)BoxesRunTime.unboxToFloat((Object)bbox.valueAt(2)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className, new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)score)}))})));
        }
        if ((Graphics2D)g2d.elem != null) {
            ImageIO.write((RenderedImage)((BufferedImage)img.elem), savePath.substring(savePath.lastIndexOf(".") + 1), new File(savePath));
            ((Graphics2D)g2d.elem).dispose();
        }
    }

    private float vis$default$6() {
        return 0.3f;
    }

    private void draw(Graphics2D img, int x1, int y1, int width, int height, String title) {
        img.setColor(Color.RED);
        img.drawRect(x1, y1, width, height);
        FontMetrics fm = img.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(title, img);
        img.setColor(this.bgColor());
        img.fillRect(x1, y1 - 2 - fm.getAscent(), (int)rect.getWidth(), (int)rect.getHeight());
        img.setColor(Color.WHITE);
        img.drawString(title, x1, y1 - 2);
    }

    public void visDetection(String imagePath, String clsname, Tensor<Object> scores, Tensor<Object> bboxes, float thresh, String outPath) {
        File f = new File(outPath);
        Object object = f.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)f.mkdirs());
        String path = ((Object)Paths.get(outPath, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clsname, imagePath.substring(imagePath.lastIndexOf("/") + 1)})))).toString();
        this.vis(imagePath, clsname, scores, bboxes, path, thresh);
    }

    public float visDetection$default$5() {
        return 0.3f;
    }

    public String visDetection$default$6() {
        return "data/demo";
    }

    private final void loadImage$1(String imgPath$1, ObjectRef img$1, ObjectRef g2d$1) {
        img$1.elem = ImageIO.read(new File(imgPath$1));
        g2d$1.elem = ((BufferedImage)img$1.elem).createGraphics();
        ((Graphics2D)g2d$1.elem).setFont(this.font());
        ((Graphics2D)g2d$1.elem).setStroke(this.stroke());
    }

    private Visualizer$() {
        MODULE$ = this;
        this.bgColor = new Color(0, 0, 1, 127);
        this.font = new Font("Helvetica", 0, 14);
        this.stroke = new BasicStroke(3.0f);
    }
}

