/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.dataset.image;

import com.intel.analytics.bigdl.dllib.feature.dataset.LocalDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.BGRImage;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.BGRImgNormalizer;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledBGRImage;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class BGRImgNormalizer$
implements Serializable {
    public static final BGRImgNormalizer$ MODULE$;
    private final Logger logger;

    static {
        new BGRImgNormalizer$();
    }

    public Logger logger() {
        return this.logger;
    }

    public BGRImgNormalizer apply(double meanR, double meanG, double meanB, double stdR, double stdG, double stdB) {
        return new BGRImgNormalizer(meanR, meanG, meanB, stdR, stdG, stdB);
    }

    public BGRImgNormalizer apply(Tuple3<Object, Object, Object> mean2, Tuple3<Object, Object, Object> std) {
        return new BGRImgNormalizer(BoxesRunTime.unboxToDouble((Object)mean2._1()), BoxesRunTime.unboxToDouble((Object)mean2._2()), BoxesRunTime.unboxToDouble((Object)mean2._3()), BoxesRunTime.unboxToDouble((Object)std._1()), BoxesRunTime.unboxToDouble((Object)std._2()), BoxesRunTime.unboxToDouble((Object)std._3()));
    }

    public BGRImgNormalizer apply(LocalDataSet<LabeledBGRImage> dataSet) {
        return this.apply(dataSet, -1);
    }

    public BGRImgNormalizer apply(LocalDataSet<LabeledBGRImage> dataSet, int samples) {
        double sumR = 0.0;
        double sumG = 0.0;
        double sumB = 0.0;
        long total = 0L;
        dataSet.shuffle();
        Iterator iter = (Iterator)dataSet.data(false);
        long totalCount = samples < 0 ? dataSet.size() : (long)samples;
        int i = 1;
        while ((long)i <= totalCount) {
            float[] content = ((BGRImage)iter.next()).content();
            Log4Error$.MODULE$.invalidInputError(content.length % 3 == 0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"content length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)content.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" cannot be divide by 3"})).s((Seq)Nil$.MODULE$)).toString(), "expect an image with RGB channel");
            for (int j = 0; j < content.length; j += 3) {
                sumR += (double)content[j + 2];
                sumG += (double)content[j + 1];
                sumB += (double)content[j + 0];
                ++total;
            }
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean: ", " / ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(++i)), BoxesRunTime.boxToLong((long)totalCount)})));
        }
        Log4Error$.MODULE$.invalidInputError(total > 0L, "empty image here, the data size is 0", "please use a RGB image as input");
        double meanR = sumR / (double)total;
        double meanG = sumG / (double)total;
        double meanB = sumB / (double)total;
        sumR = 0.0;
        sumG = 0.0;
        sumB = 0.0;
        i = 1;
        iter = (Iterator)dataSet.data(false);
        while ((long)i <= totalCount) {
            float[] content = ((BGRImage)iter.next()).content();
            for (int j = 0; j < content.length; j += 3) {
                double diffR = (double)content[j + 2] - meanR;
                double diffG = (double)content[j + 1] - meanG;
                double diffB = (double)content[j + 0] - meanB;
                sumR += diffR * diffR;
                sumG += diffG * diffG;
                sumB += diffB * diffB;
            }
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Std: ", " / ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToLong((long)totalCount)})));
            ++i;
        }
        double stdR = package$.MODULE$.sqrt(sumR / (double)total);
        double stdG = package$.MODULE$.sqrt(sumG / (double)total);
        double stdB = package$.MODULE$.sqrt(sumB / (double)total);
        return new BGRImgNormalizer(meanR, meanG, meanB, stdR, stdG, stdB);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BGRImgNormalizer$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

