/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.dataset.image;

import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class BGRImage$
implements Serializable {
    public static final BGRImage$ MODULE$;
    private final int NO_SCALE;

    static {
        new BGRImage$();
    }

    public void hflip(float[] data2, int height, int width) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width / 2; ++x) {
                float swap = 0.0f;
                swap = data2[(y * width + x) * 3];
                data2[(y * width + x) * 3] = data2[(y * width + width - x - 1) * 3];
                data2[(y * width + width - x - 1) * 3] = swap;
                swap = data2[(y * width + x) * 3 + 1];
                data2[(y * width + x) * 3 + 1] = data2[(y * width + width - x - 1) * 3 + 1];
                data2[(y * width + width - x - 1) * 3 + 1] = swap;
                swap = data2[(y * width + x) * 3 + 2];
                data2[(y * width + x) * 3 + 2] = data2[(y * width + width - x - 1) * 3 + 2];
                data2[(y * width + width - x - 1) * 3 + 2] = swap;
            }
        }
    }

    private Tuple2<Object, Object> getWidthHeightAfterRatioScale(int oriHeight, int oriWidth, int scaleTo) {
        return this.NO_SCALE() == scaleTo ? new Tuple2.mcII.sp(oriHeight, oriWidth) : (oriWidth < oriHeight ? new Tuple2.mcII.sp(scaleTo * oriHeight / oriWidth, scaleTo) : new Tuple2.mcII.sp(scaleTo, scaleTo * oriWidth / oriHeight));
    }

    private BufferedImage readRawImage(Path path) {
        BufferedImage bufferedImage;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(((Object)path).toString());
                FileChannel channel = fis.getChannel();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                channel.transferTo(0L, channel.size(), Channels.newChannel(byteArrayOutputStream));
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                Log4Error$.MODULE$.invalidInputError(image != null, new StringBuilder().append((Object)"Can't read file ").append((Object)path).append((Object)", ImageIO.read is null").toString(), Log4Error$.MODULE$.invalidInputError$default$3());
                bufferedImage = image;
            }
            catch (Exception exception) {
                boolean x$2 = false;
                String x$3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't read file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
                Exception x$4 = exception;
                String x$5 = Log4Error$.MODULE$.unKnowExceptionError$default$3();
                Log4Error$.MODULE$.unKnowExceptionError(x$2, x$3, x$5, x$4);
                bufferedImage = null;
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return bufferedImage;
    }

    public int NO_SCALE() {
        return this.NO_SCALE;
    }

    public byte[] resizeImage(BufferedImage img, int resizeWidth, int resizeHeight) {
        Image scaledImage = null;
        scaledImage = resizeHeight == img.getHeight() && resizeWidth == img.getWidth() ? img : img.getScaledInstance(resizeWidth, resizeHeight, 4);
        BufferedImage imageBuff = new BufferedImage(resizeWidth, resizeHeight, 5);
        imageBuff.getGraphics().drawImage(scaledImage, 0, 0, new Color(0, 0, 0), null);
        byte[] pixels = ((DataBufferByte)imageBuff.getRaster().getDataBuffer()).getData();
        Log4Error$.MODULE$.unKnowExceptionError(pixels.length % 3 == 0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pixels.length(", ") cannot divide by 3"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pixels.length)})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        byte[] bytes = new byte[8 + pixels.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        Log4Error$.MODULE$.unKnowExceptionError(imageBuff.getWidth() * imageBuff.getHeight() * 3 == pixels.length, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"imageBuff.getWidth(", ") * imageBuff.getHeight(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)imageBuff.getWidth()), BoxesRunTime.boxToInteger((int)imageBuff.getHeight())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" * 3 doesn't match pixels.length(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pixels.length)}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        byteBuffer.putInt(imageBuff.getWidth());
        byteBuffer.putInt(imageBuff.getHeight());
        System.arraycopy(pixels, 0, bytes, 8, pixels.length);
        return bytes;
    }

    public byte[] readImage(Path path, int scaleTo) {
        BufferedImage img = this.readRawImage(path);
        Tuple2<Object, Object> tuple2 = this.getWidthHeightAfterRatioScale(img.getHeight(), img.getWidth(), scaleTo);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int heightAfterScale = tuple2._1$mcI$sp();
            int widthAfterScale = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(heightAfterScale, widthAfterScale);
            int heightAfterScale2 = sp3._1$mcI$sp();
            int widthAfterScale2 = sp3._2$mcI$sp();
            return this.resizeImage(img, widthAfterScale2, heightAfterScale2);
        }
        throw new MatchError(tuple2);
    }

    public byte[] readImage(Path path, int resizeWidth, int resizeHeight) {
        BufferedImage img = this.readRawImage(path);
        return this.resizeImage(img, resizeWidth, resizeHeight);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BGRImage$() {
        MODULE$ = this;
        this.NO_SCALE = -1;
    }
}

