/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.dataset;

import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.SparseMiniBatch;
import com.intel.analytics.bigdl.dllib.tensor.DenseType$;
import com.intel.analytics.bigdl.dllib.tensor.SparseType$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorType;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparseMiniBatch$
implements Serializable {
    public static final SparseMiniBatch$ MODULE$;

    static {
        new SparseMiniBatch$();
    }

    public <T> MiniBatch<T> apply(int nInputs, int nTargets, ClassTag<T> evidence$16, TensorNumericMath.TensorNumeric<T> ev) {
        return new SparseMiniBatch<T>(new Tensor[nInputs], new Tensor[nTargets], evidence$16, ev);
    }

    public <T> void batch(int dim, Seq<Tensor<T>> tensors, Tensor<T> res, ClassTag<T> evidence$17, TensorNumericMath.TensorNumeric<T> ev) {
        TensorType tensorType = res.getTensorType();
        SparseType$ sparseType$ = SparseType$.MODULE$;
        if (!(tensorType != null ? !tensorType.equals(sparseType$) : sparseType$ != null)) {
            Tensor$.MODULE$.sparseConcat(dim, tensors, res, evidence$17, ev);
        } else {
            TensorType tensorType2 = res.getTensorType();
            DenseType$ denseType$ = DenseType$.MODULE$;
            if (!(tensorType2 != null ? !tensorType2.equals(denseType$) : denseType$ != null)) {
                this.denseBatch(dim, tensors, res, evidence$17, ev);
            } else {
                Log4Error$.MODULE$.invalidInputError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MiniBatchWithSparse: unsupported tensor type "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.getTensorType()}))).toString(), "only support SparseType and DenseType");
            }
        }
    }

    private <T> Tensor<T> denseBatch(int dim, Seq<Tensor<T>> tensors, Tensor<T> result2, ClassTag<T> evidence$18, TensorNumericMath.TensorNumeric<T> ev) {
        int[] tensorSize = ((Tensor)tensors.head()).size();
        Tuple2 tuple2 = Predef$.MODULE$.intArrayOps(tensorSize).splitAt(dim - 1);
        if (tuple2 != null) {
            Tuple2 tuple22;
            int[] pre = (int[])tuple2._1();
            int[] next2 = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)pre, (Object)next2);
            int[] pre2 = (int[])tuple23._1();
            int[] next3 = (int[])tuple23._2();
            ArrayBuffer size = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            size.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(pre2));
            size.$plus$eq((Object)BoxesRunTime.boxToInteger((int)tensors.length()));
            size.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(next3));
            result2.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), result2.resize$default$2());
            for (int i = 0; i < tensors.length(); ++i) {
                Tensor current = (Tensor)tensors.apply(i);
                Tensor<T> target = result2.select(dim, i + 1);
                target.copy(current);
            }
            return result2;
        }
        throw new MatchError((Object)tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparseMiniBatch$() {
        MODULE$ = this;
    }
}

