/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.dataset;

import com.intel.analytics.bigdl.dllib.feature.dataset.ArrayTensorMiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.ArrayTensorMiniBatch$;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.PaddingParam;
import com.intel.analytics.bigdl.dllib.feature.dataset.PaddingStrategy;
import com.intel.analytics.bigdl.dllib.feature.dataset.Sample;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class MiniBatch$
implements Serializable {
    public static final MiniBatch$ MODULE$;

    static {
        new MiniBatch$();
    }

    public <T> MiniBatch<T> apply(int nInputs, int nTargets, Option<PaddingParam<T>> featurePaddingParam, Option<PaddingParam<T>> labelPaddingParam, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        return new ArrayTensorMiniBatch<T>((Tensor[])Array$.MODULE$.tabulate(nInputs, (Function1)new Serializable(evidence$2, ev){
            public static final long serialVersionUID = 0L;
            private final ClassTag evidence$2$1;
            private final TensorNumericMath.TensorNumeric ev$2;

            public final Tensor<T> apply(int x$5) {
                return Tensor$.MODULE$.apply(this.evidence$2$1, this.ev$2);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.ev$2 = ev$2;
            }
        }, ClassTag$.MODULE$.apply(Tensor.class)), (Tensor[])Array$.MODULE$.tabulate(nTargets, (Function1)new Serializable(evidence$2, ev){
            public static final long serialVersionUID = 0L;
            private final ClassTag evidence$2$1;
            private final TensorNumericMath.TensorNumeric ev$2;

            public final Tensor<T> apply(int x$6) {
                return Tensor$.MODULE$.apply(this.evidence$2$1, this.ev$2);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.ev$2 = ev$2;
            }
        }, ClassTag$.MODULE$.apply(Tensor.class)), featurePaddingParam, labelPaddingParam, evidence$2);
    }

    public <T> MiniBatch<T> apply(Tensor<T> input, Tensor<T> target, ClassTag<T> evidence$3) {
        return this.apply((Tensor[])((Object[])new Tensor[]{input}), (Tensor[])((Object[])new Tensor[]{target}), evidence$3);
    }

    public <T> MiniBatch<T> apply(Tensor<T>[] input, Tensor<T> target, ClassTag<T> evidence$4) {
        return this.apply(input, (Tensor[])((Object[])new Tensor[]{target}), evidence$4);
    }

    public <T> MiniBatch<T> apply(Tensor<T>[] input, Tensor<T>[] target, ClassTag<T> evidence$5) {
        return new ArrayTensorMiniBatch<T>(input, target, ArrayTensorMiniBatch$.MODULE$.$lessinit$greater$default$3(), ArrayTensorMiniBatch$.MODULE$.$lessinit$greater$default$4(), evidence$5);
    }

    public <T> MiniBatch<T> apply(Tensor<T> input, ClassTag<T> evidence$6) {
        return this.apply((Tensor[])((Object[])new Tensor[]{input}), new Tensor[0], evidence$6);
    }

    public <T> MiniBatch<T> apply(Tensor<T>[] input, ClassTag<T> evidence$7) {
        return this.apply(input, new Tensor[0], evidence$7);
    }

    public <T> None$ apply$default$3() {
        return None$.MODULE$;
    }

    public <T> None$ apply$default$4() {
        return None$.MODULE$;
    }

    private <T> void resizeData(Tensor<T>[] data2, Seq<int[][]> sampleSize, Option<int[]> longestData, PaddingStrategy paddingStrategy, Option<Tensor<T>[]> paddingTensor, ClassTag<T> evidence$8) {
        Seq<int[]> seq;
        int[][] sizes = new int[((int[][])sampleSize.head()).length][];
        if (longestData.isDefined()) {
            int[] longest = (int[])longestData.get();
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = (int[])Predef$.MODULE$.intArrayOps(new int[]{sampleSize.length()}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(((int[][])sampleSize.apply(longest[i]))[i]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            }
            seq = paddingStrategy.paddingSize((Seq<int[]>)Predef$.MODULE$.wrapRefArray((Object[])sizes));
        } else {
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = (int[])Predef$.MODULE$.intArrayOps(new int[]{sampleSize.length()}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(((int[][])sampleSize.head())[i]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            }
            seq = BoxedUnit.UNIT;
        }
        for (int i = 0; i < sizes.length; ++i) {
            Tensor<T> qual$1 = data2[i];
            int[] x$19 = sizes[i];
            int[] x$20 = qual$1.resize$default$2();
            qual$1.resize(x$19, x$20);
            Object object = paddingTensor.isEmpty() ? data2[i].zero() : BoxedUnit.UNIT;
        }
    }

    public <T> MiniBatch<T> resize(Seq<Sample<T>> samples, ArrayTensorMiniBatch<T> miniBatch, PaddingStrategy featurePaddingStrategy, PaddingStrategy labelPaddingStrategy, Option<Tensor<T>[]> featurePaddingTensor, Option<Tensor<T>[]> labelPaddingTensor, Option<int[]> longestFeature, Option<int[]> longestLabel, ClassTag<T> evidence$9, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T>[] inputs2 = miniBatch.inputData();
        Tensor<T>[] targets = miniBatch.targetData();
        Seq featureSizes = (Seq)samples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[][] apply(Sample<T> x$7) {
                return x$7.getFeatureSize();
            }
        }, Seq$.MODULE$.canBuildFrom());
        boolean unlabeled = ((Sample)samples.head()).numLabel() == 0;
        this.resizeData(inputs2, (Seq<int[][]>)featureSizes, longestFeature, featurePaddingStrategy, featurePaddingTensor, evidence$9);
        if (!unlabeled) {
            Seq labelSizes = (Seq)samples.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int[][] apply(Sample<T> x$8) {
                    return x$8.getLabelSize();
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.resizeData(targets, (Seq<int[][]>)labelSizes, longestLabel, labelPaddingStrategy, labelPaddingTensor, evidence$9);
        }
        return miniBatch;
    }

    public <T> None$ resize$default$5() {
        return None$.MODULE$;
    }

    public <T> None$ resize$default$6() {
        return None$.MODULE$;
    }

    public <T> Option<int[]> resize$default$7() {
        return None$.MODULE$;
    }

    public <T> Option<int[]> resize$default$8() {
        return None$.MODULE$;
    }

    public <T> MiniBatch<T> copyWithPadding(Seq<Sample<T>> samples, ArrayTensorMiniBatch<T> miniBatch, boolean unlabeled, Option<Tensor<T>[]> featurePadding, Option<Tensor<T>[]> labelPadding, ClassTag<T> evidence$10, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T>[] inputs2 = miniBatch.inputData();
        Tensor<T>[] targets = miniBatch.targetData();
        if (featurePadding.isDefined()) {
            for (int i = 0; i < inputs2.length; ++i) {
                Log4Error$.MODULE$.unKnowExceptionError(((Tensor[])featurePadding.get()).length == inputs2.length, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of tensor padding should "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"equals to Number of feature tensor in Sample. Excepted ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inputs2.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Tensor[])featurePadding.get()).length)}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
                if (inputs2[i].dim() == 2) {
                    Log4Error$.MODULE$.unKnowExceptionError(((Tensor[])featurePadding.get())[i].nElement() == 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "thFeature is 1D, featurePadding "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"should have only one element, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Tensor[])featurePadding.get())[i]}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
                } else {
                    Log4Error$.MODULE$.unKnowExceptionError(((Tensor[])featurePadding.get())[i].dim() == inputs2[i].dim() - 2, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "thFeature's featurePadding should have the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"same dimension with the feature in sample. Excepted: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(inputs2[i].dim() - 2))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Tensor[])featurePadding.get())[i].dim())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
                }
                Log4Error$.MODULE$.invalidInputError(((Tensor[])featurePadding.get())[i].isContiguous(), "featurePadding should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
            }
        }
        for (int s2 = 0; s2 < samples.length(); ++s2) {
            int f = 0;
            int offset = 0;
            Sample sample = (Sample)samples.apply(s2);
            Object sampleData = sample.getData();
            while (f < inputs2.length) {
                int length = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(sample.getFeatureSize()[f]).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (featurePadding.isDefined()) {
                    this.copy(sampleData, offset, length, inputs2[f].apply(s2 + 1), ((Tensor[])featurePadding.get())[f], evidence$10, ev);
                } else {
                    Tensor<T> tensor = inputs2[f].apply(s2 + 1);
                    this.copy$default$5();
                    this.copy(sampleData, offset, length, tensor, null, evidence$10, ev);
                }
                ++f;
                offset += length;
            }
            if (unlabeled) continue;
            int l = 0;
            while (l < targets.length) {
                int length = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(sample.getLabelSize()[l]).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (labelPadding.isDefined()) {
                    this.copy(sampleData, offset, length, targets[l].apply(s2 + 1), ((Tensor[])labelPadding.get())[l], evidence$10, ev);
                } else {
                    Tensor<T> tensor = targets[l].apply(s2 + 1);
                    this.copy$default$5();
                    this.copy(sampleData, offset, length, tensor, null, evidence$10, ev);
                }
                ++l;
                offset += length;
            }
        }
        return miniBatch;
    }

    public <T> int[] findLongestFeatures(Seq<Sample<T>> samples, ClassTag<T> evidence$11, TensorNumericMath.TensorNumeric<T> ev) {
        int[] featureIndices = new int[((Sample)samples.head()).numFeature()];
        for (int i = 1; i < samples.length(); ++i) {
            for (int j = 0; j < featureIndices.length; ++j) {
                if (((Sample)samples.apply(i)).featureLength(j) <= ((Sample)samples.apply(featureIndices[j])).featureLength(j)) continue;
                featureIndices[j] = i;
            }
        }
        return featureIndices;
    }

    public <T> int[] findLongestLabels(Seq<Sample<T>> samples, ClassTag<T> evidence$12, TensorNumericMath.TensorNumeric<T> ev) {
        int[] labelIndices = new int[((Sample)samples.head()).numLabel()];
        for (int i = 1; i < samples.length(); ++i) {
            for (int j = 0; j < labelIndices.length; ++j) {
                if (((Sample)samples.apply(i)).labelLength(j) <= ((Sample)samples.apply(labelIndices[j])).labelLength(j)) continue;
                labelIndices[j] = i;
            }
        }
        return labelIndices;
    }

    private <T> void copy(Object src, int offset, int length, Tensor<T> dest, Tensor<T> paddingTensor, ClassTag<T> evidence$13, TensorNumericMath.TensorNumeric<T> ev) {
        ev.arraycopy(src, offset, dest.storage().array(), dest.storageOffset() - 1, length);
        if (paddingTensor != null) {
            for (int j = length; j < dest.nElement(); j += paddingTensor.nElement()) {
                ev.arraycopy(paddingTensor.storage().array(), paddingTensor.storageOffset() - 1, dest.storage().array(), dest.storageOffset() - 1 + j, paddingTensor.nElement());
            }
        }
    }

    public <T> None$ copyWithPadding$default$4() {
        return None$.MODULE$;
    }

    public <T> None$ copyWithPadding$default$5() {
        return None$.MODULE$;
    }

    private <T> Null$ copy$default$5() {
        return null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MiniBatch$() {
        MODULE$ = this;
    }
}

