/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.feature.dataset;

import com.intel.analytics.bigdl.dllib.feature.dataset.ArraySample;
import com.intel.analytics.bigdl.dllib.feature.dataset.Sample;
import com.intel.analytics.bigdl.dllib.tensor.DenseType$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorType;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ArraySample$
implements Serializable {
    public static final ArraySample$ MODULE$;

    static {
        new ArraySample$();
    }

    public <T> void com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(Tensor<T> tensor, ClassTag<T> evidence$3) {
        TensorType tensorType = tensor.getTensorType();
        if (DenseType$.MODULE$.equals(tensorType)) {
            Log4Error$.MODULE$.invalidInputError(tensor.isContiguous(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tensor in ArraySample should be contiguous,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Please check your input."})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ArraySample doesn't support ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensor.getTensorType()})), "only support DenseType");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private <T> void typeCheck(Tensor<T>[] tensors, ClassTag<T> evidence$4) {
        Predef$.MODULE$.refArrayOps((Object[])tensors).foreach((Function1)new Serializable(evidence$4){
            public static final long serialVersionUID = 0L;
            private final ClassTag evidence$4$1;

            public final void apply(Tensor<T> tensor) {
                ArraySample$.MODULE$.com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(tensor, this.evidence$4$1);
            }
            {
                this.evidence$4$1 = evidence$4$1;
            }
        });
    }

    public <T> Sample<T> apply(Object data2, int[][] featureSize, int[][] labelSize, ClassTag<T> evidence$5) {
        return new ArraySample<T>(data2, featureSize, labelSize, evidence$5);
    }

    public <T> Sample<T> apply(Tensor<T> featureTensor, Tensor<T> labelTensor, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        this.com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(featureTensor, evidence$6);
        this.com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(labelTensor, evidence$6);
        Object data2 = evidence$6.newArray(featureTensor.nElement() + labelTensor.nElement());
        ev.arraycopy(featureTensor.storage().array(), featureTensor.storageOffset() - 1, data2, 0, featureTensor.nElement());
        ev.arraycopy(labelTensor.storage().array(), labelTensor.storageOffset() - 1, data2, featureTensor.nElement(), labelTensor.nElement());
        return new ArraySample<T>(data2, this.getSize(featureTensor, evidence$6), this.getSize(labelTensor, evidence$6), evidence$6);
    }

    public <T> Sample<T> apply(Tensor<T> featureTensor, T label, ClassTag<T> evidence$7, TensorNumericMath.TensorNumeric<T> ev) {
        this.com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(featureTensor, evidence$7);
        Object data2 = evidence$7.newArray(featureTensor.nElement() + 1);
        ev.arraycopy(featureTensor.storage().array(), featureTensor.storageOffset() - 1, data2, 0, featureTensor.nElement());
        ScalaRunTime$.MODULE$.array_update(data2, featureTensor.nElement(), label);
        return new ArraySample<T>(data2, this.getSize(featureTensor, evidence$7), (int[][])((Object[])new int[][]{{1}}), evidence$7);
    }

    public <T> Sample<T> apply(Tensor<T>[] featureTensors, Tensor<T> labelTensor, ClassTag<T> evidence$8, TensorNumericMath.TensorNumeric<T> ev) {
        this.typeCheck(featureTensors, evidence$8);
        this.com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(labelTensor, evidence$8);
        Tensor[] tensors = (Tensor[])Predef$.MODULE$.refArrayOps((Object[])featureTensors).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new Tensor[]{labelTensor}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tensor.class)));
        Object data2 = evidence$8.newArray(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])tensors).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tensor<T> x$7) {
                return x$7.nElement();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.copy(data2, tensors, evidence$8, ev);
        return new ArraySample<T>(data2, this.getSize(featureTensors, evidence$8), this.getSize(labelTensor, evidence$8), evidence$8);
    }

    public <T> Sample<T> apply(Tensor<T>[] featureTensors, Tensor<T>[] labelTensors, ClassTag<T> evidence$9, TensorNumericMath.TensorNumeric<T> ev) {
        this.typeCheck(featureTensors, evidence$9);
        this.typeCheck(labelTensors, evidence$9);
        Tensor[] tensors = (Tensor[])Predef$.MODULE$.refArrayOps((Object[])featureTensors).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])labelTensors), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tensor.class)));
        Object data2 = evidence$9.newArray(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])tensors).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tensor<T> x$8) {
                return x$8.nElement();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.copy(data2, tensors, evidence$9, ev);
        return new ArraySample<T>(data2, this.getSize(featureTensors, evidence$9), this.getSize(labelTensors, evidence$9), evidence$9);
    }

    public <T> Sample<T> apply(Tensor<T> featureTensor, ClassTag<T> evidence$10, TensorNumericMath.TensorNumeric<T> ev) {
        this.com$intel$analytics$bigdl$dllib$feature$dataset$ArraySample$$typeCheck(featureTensor, evidence$10);
        Object data2 = evidence$10.newArray(featureTensor.nElement());
        ev.arraycopy(featureTensor.storage().array(), featureTensor.storageOffset() - 1, data2, 0, featureTensor.nElement());
        return new ArraySample<T>(data2, this.getSize(featureTensor, evidence$10), null, evidence$10);
    }

    public <T> Sample<T> apply(Tensor<T>[] featureTensors, ClassTag<T> evidence$11, TensorNumericMath.TensorNumeric<T> ev) {
        this.typeCheck(featureTensors, evidence$11);
        Object data2 = evidence$11.newArray(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])featureTensors).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tensor<T> x$9) {
                return x$9.nElement();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.copy(data2, featureTensors, evidence$11, ev);
        return new ArraySample<T>(data2, this.getSize(featureTensors, evidence$11), null, evidence$11);
    }

    private <T> Object copy(Object data2, Tensor<T>[] tensors, ClassTag<T> evidence$12, TensorNumericMath.TensorNumeric<T> ev) {
        int offset = 0;
        for (int i = 0; i < tensors.length; ++i) {
            Tensor<T> tensor = tensors[i];
            Log4Error$.MODULE$.invalidInputError(tensor.isContiguous(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-th tensor is not contiguous"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), Log4Error$.MODULE$.invalidInputError$default$3());
            ev.arraycopy(tensor.storage().array(), tensor.storageOffset() - 1, data2, offset, tensor.nElement());
            offset += tensor.nElement();
        }
        return data2;
    }

    public <T> int[][] getSize(Tensor<T>[] tensors, ClassTag<T> evidence$13) {
        return (int[][])Predef$.MODULE$.refArrayOps((Object[])tensors).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[] apply(Tensor<T> x$10) {
                return x$10.size();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
    }

    public <T> int[][] getSize(Tensor<T> tensor, ClassTag<T> evidence$14) {
        return (int[][])((Object[])new int[][]{tensor.size()});
    }

    public boolean sameSize(int[][] a, int[][] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == b[i].length) continue;
            return false;
        }
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ArraySample$() {
        MODULE$ = this;
    }
}

