/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.example.utils;

import com.intel.analytics.bigdl.dllib.example.utils.AbstractTextClassificationParams;
import com.intel.analytics.bigdl.dllib.example.utils.SimpleTokenizer$;
import com.intel.analytics.bigdl.dllib.example.utils.TextClassifier$;
import com.intel.analytics.bigdl.dllib.example.utils.WordMeta;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.Sample;
import com.intel.analytics.bigdl.dllib.feature.dataset.Sample$;
import com.intel.analytics.bigdl.dllib.nn.ClassNLLCriterion$;
import com.intel.analytics.bigdl.dllib.nn.ClassNLLCriterion$mcF$sp;
import com.intel.analytics.bigdl.dllib.nn.Dropout$;
import com.intel.analytics.bigdl.dllib.nn.DynamicContainer;
import com.intel.analytics.bigdl.dllib.nn.Linear$;
import com.intel.analytics.bigdl.dllib.nn.LogSoftMax$;
import com.intel.analytics.bigdl.dllib.nn.ReLU$;
import com.intel.analytics.bigdl.dllib.nn.Sequential;
import com.intel.analytics.bigdl.dllib.nn.Sequential$;
import com.intel.analytics.bigdl.dllib.nn.Squeeze$;
import com.intel.analytics.bigdl.dllib.nn.TemporalConvolution$;
import com.intel.analytics.bigdl.dllib.nn.TemporalMaxPooling$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractCriterion;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.optim.Adagrad$;
import com.intel.analytics.bigdl.dllib.optim.Adagrad$mcF$sp;
import com.intel.analytics.bigdl.dllib.optim.Optimizer;
import com.intel.analytics.bigdl.dllib.optim.Optimizer$;
import com.intel.analytics.bigdl.dllib.optim.Top1Accuracy;
import com.intel.analytics.bigdl.dllib.optim.Trigger$;
import com.intel.analytics.bigdl.dllib.optim.ValidationMethod;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Engine$;
import com.intel.analytics.bigdl.package$;
import java.io.File;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001E\u0011a\u0002V3yi\u000ec\u0017m]:jM&,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\u0011QAB\u0001\bKb\fW\u000e\u001d7f\u0015\t9\u0001\"A\u0003eY2L'M\u0003\u0002\n\u0015\u0005)!-[4eY*\u00111\u0002D\u0001\nC:\fG.\u001f;jGNT!!\u0004\b\u0002\u000b%tG/\u001a7\u000b\u0003=\t1aY8n\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0006a\u0006\u0014\u0018-\u001c\t\u0003=}i\u0011AA\u0005\u0003A\t\u0011\u0001%\u00112tiJ\f7\r\u001e+fqR\u001cE.Y:tS\u001aL7-\u0019;j_:\u0004\u0016M]1ng\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005y\u0001\u0001\"\u0002\u000f\"\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%\t\u0001K\u0001\u0004Y><W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013!B:mMRR'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021W\t1Aj\\4hKJDaA\r\u0001!\u0002\u0013I\u0013\u0001\u00027pO\u0002Bq\u0001\u000e\u0001C\u0002\u0013\u0005Q'\u0001\u0005hY>4X\rR5s+\u00051\u0004CA\u001c;\u001d\t\u0019\u0002(\u0003\u0002:)\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tID\u0003\u0003\u0004?\u0001\u0001\u0006IAN\u0001\nO2|g/\u001a#je\u0002Bq\u0001\u0011\u0001C\u0002\u0013\u0005Q'A\u0006uKb$H)\u0019;b\t&\u0014\bB\u0002\"\u0001A\u0003%a'\u0001\u0007uKb$H)\u0019;b\t&\u0014\b\u0005C\u0004E\u0001\u0001\u0007I\u0011A#\u0002\u0011\rd\u0017m]:Ok6,\u0012A\u0012\t\u0003'\u001dK!\u0001\u0013\u000b\u0003\u0007%sG\u000fC\u0004K\u0001\u0001\u0007I\u0011A&\u0002\u0019\rd\u0017m]:Ok6|F%Z9\u0015\u00051{\u0005CA\nN\u0013\tqEC\u0001\u0003V]&$\bb\u0002)J\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0004B\u0002*\u0001A\u0003&a)A\u0005dY\u0006\u001c8OT;nA!)A\u000b\u0001C\u0001+\u0006i!-^5mI^{'\u000f\u001a\u001aWK\u000e$\"AV0\u0011\t]:\u0016\fX\u0005\u00031r\u00121!T1q!\t\u0019\",\u0003\u0002\\)\t)a\t\\8biB\u00191#X-\n\u0005y#\"!B!se\u0006L\b\"\u00021T\u0001\u0004\t\u0017!C<pe\u0012\u0014T*\u001a;b!\u00119tK\u000e2\u0011\u0005y\u0019\u0017B\u00013\u0003\u0005!9vN\u001d3NKR\f\u0007\"\u00024\u0001\t\u00039\u0017A\u00062vS2$wk\u001c:eeY+7mV5uQ&sG-\u001a=\u0015\u0005YC\u0007\"\u00021f\u0001\u0004I\u0007\u0003B\u001cXm\u0019CQa\u001b\u0001\u0005\n1\f1\u0002\\8bIJ\u000bw\u000fR1uCR\tQ\u000eE\u0002ogVl\u0011a\u001c\u0006\u0003aF\fq!\\;uC\ndWM\u0003\u0002s)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q|'aC!se\u0006L()\u001e4gKJ\u0004Ba\u0005<73&\u0011q\u000f\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000be\u0004A\u0011\u0001>\u0002\u0019\u0005t\u0017\r\\={KR+\u0007\u0010^:\u0015\u0005md\b\u0003B\nwCZCQ! =A\u0002y\fq\u0001Z1uCJ#G\r\u0005\u0003\u0000\u0003\u001b)XBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0007I$GM\u0003\u0003\u0002\b\u0005%\u0011!B:qCJ\\'bAA\u0006[\u00051\u0011\r]1dQ\u0016LA!a\u0004\u0002\u0002\t\u0019!\u000b\u0012#\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u00059q-\u001a;ECR\fG\u0003BA\f\u0003K\u0001raEA\r\u0003;\tg+C\u0002\u0002\u001cQ\u0011a\u0001V;qY\u0016\u001c\u0004\u0003B\n^\u0003?\u0001Ra`A\u0007\u0003C\u0001Ra\u0005<\u0002$e\u00032aE/]\u0011!\t9#!\u0005A\u0002\u0005%\u0012AA:d!\u0011\tY#!\f\u000e\u0005\u0005\u0015\u0011\u0002BA\u0018\u0003\u000b\u0011Ab\u00159be.\u001cuN\u001c;fqRDq!a\r\u0001\t\u0003\t)$\u0001\u0006ck&dG-T8eK2$B!a\u000e\u0002DA)\u0011\u0011HA 36\u0011\u00111\b\u0006\u0004\u0003{1\u0011A\u00018o\u0013\u0011\t\t%a\u000f\u0003\u0015M+\u0017/^3oi&\fG\u000e\u0003\u0004E\u0003c\u0001\rA\u0012\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003\u0015!(/Y5o)\u0005a\u0005bBA'\u0001\u0011\u0005\u0011qJ\u0001\u000eiJ\f\u0017N\u001c$s_6$\u0015\r^1\u0015\r\u0005E\u0013QOA<!\u0015\t\u0019&a\u001cZ\u001d\u0011\t)&a\u001b\u000f\t\u0005]\u0013\u0011\u000e\b\u0005\u00033\n9G\u0004\u0003\u0002\\\u0005\u0015d\u0002BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005\u0004#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0007\u00055\u0004\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00141\u000f\u0002\u0007\u001b>$W\u000f\\3\u000b\u0007\u00055\u0004\u0002\u0003\u0005\u0002(\u0005-\u0003\u0019AA\u0015\u0011!\tI(a\u0013A\u0002\u0005u\u0011\u0001\u0002:eIN\u0004")
public class TextClassifier
implements Serializable {
    public final AbstractTextClassificationParams com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param;
    private final Logger log;
    private final String gloveDir;
    private final String textDataDir;
    private int classNum;

    public Logger log() {
        return this.log;
    }

    public String gloveDir() {
        return this.gloveDir;
    }

    public String textDataDir() {
        return this.textDataDir;
    }

    public int classNum() {
        return this.classNum;
    }

    public void classNum_$eq(int x$1) {
        this.classNum = x$1;
    }

    public Map<Object, float[]> buildWord2Vec(Map<String, WordMeta> word2Meta) {
        this.log().info("Indexing word vectors.");
        scala.collection.mutable.Map preWord2Vec = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        String filename = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/glove.6B.200d.txt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.gloveDir()}));
        Source$.MODULE$.fromFile(filename, "ISO-8859-1").getLines().foreach((Function1)new Serializable(this, word2Meta, preWord2Vec){
            public static final long serialVersionUID = 0L;
            private final Map word2Meta$1;
            private final scala.collection.mutable.Map preWord2Vec$1;

            public final Object apply(String line) {
                BoxedUnit boxedUnit;
                String[] values2 = line.split(" ");
                String word = values2[0];
                if (this.word2Meta$1.contains((Object)word)) {
                    float[] coefs = (float[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])values2).slice(1, values2.length)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply(String x$1) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$1)).toFloat();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                    boxedUnit = this.preWord2Vec$1.put((Object)BoxesRunTime.boxToFloat((float)((WordMeta)this.word2Meta$1.apply((Object)word)).index()), (Object)coefs);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.word2Meta$1 = word2Meta$1;
                this.preWord2Vec$1 = preWord2Vec$1;
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " word vectors."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)preWord2Vec.size())})));
        return preWord2Vec.toMap(Predef$.MODULE$.$conforms());
    }

    public Map<Object, float[]> buildWord2VecWithIndex(Map<String, Object> word2Meta) {
        this.log().info("Indexing word vectors.");
        scala.collection.mutable.Map preWord2Vec = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        String filename = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/glove.6B.200d.txt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.gloveDir()}));
        Source$.MODULE$.fromFile(filename, "ISO-8859-1").getLines().foreach((Function1)new Serializable(this, word2Meta, preWord2Vec){
            public static final long serialVersionUID = 0L;
            private final Map word2Meta$2;
            private final scala.collection.mutable.Map preWord2Vec$2;

            public final Object apply(String line) {
                BoxedUnit boxedUnit;
                String[] values2 = line.split(" ");
                String word = values2[0];
                if (this.word2Meta$2.contains((Object)word)) {
                    float[] coefs = (float[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])values2).slice(1, values2.length)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply(String x$2) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$2)).toFloat();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                    boxedUnit = this.preWord2Vec$2.put((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToInt((Object)this.word2Meta$2.apply((Object)word))), (Object)coefs);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.word2Meta$2 = word2Meta$2;
                this.preWord2Vec$2 = preWord2Vec$2;
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " word vectors."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)preWord2Vec.size())})));
        return preWord2Vec.toMap(Predef$.MODULE$.$conforms());
    }

    private ArrayBuffer<Tuple2<String, Object>> loadRawData() {
        ArrayBuffer texts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer labels = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap categoryToLabel = new HashMap();
        List categoryPathList = (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(this.textDataDir()).listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$3) {
                return x$3.isDirectory();
            }
        })).toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        categoryPathList.foreach((Function1)new Serializable(this, texts, labels, categoryToLabel){
            public static final long serialVersionUID = 0L;
            public final ArrayBuffer texts$1;
            public final ArrayBuffer labels$1;
            private final HashMap categoryToLabel$1;

            public final void apply(File categoryPath) {
                int label_id = this.categoryToLabel$1.size() + 1;
                this.categoryToLabel$1.put(categoryPath.getName(), BoxesRunTime.boxToInteger((int)label_id));
                File[] textFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])categoryPath.listFiles()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$4) {
                        return x$4.isFile();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$5) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$5.getName())).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(char x$6) {
                                return Character.isDigit(x$6);
                            }
                        });
                    }
                })).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                Predef$.MODULE$.refArrayOps((Object[])textFiles).foreach((Function1)new Serializable(this, label_id){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$loadRawData$1 $outer;
                    private final int label_id$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final void apply(File file) {
                        String string;
                        BufferedSource source = Source$.MODULE$.fromFile(file, "ISO-8859-1");
                        try {
                            string = source.getLines().toList().mkString("\n");
                        }
                        catch (Throwable throwable) {
                            void var2_2;
                            var2_2.close();
                            throw throwable;
                        }
                        source.close();
                        String text = string;
                        this.$outer.texts$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{text}));
                        this.$outer.labels$1.append((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{this.label_id$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.label_id$1 = label_id$1;
                    }
                });
            }
            {
                this.texts$1 = texts$1;
                this.labels$1 = labels$1;
                this.categoryToLabel$1 = categoryToLabel$1;
            }
        });
        this.classNum_$eq(labels.toSet().size());
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " texts."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)texts.length())})));
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " classes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.classNum())})));
        return (ArrayBuffer)texts.zip((GenIterable)labels, ArrayBuffer$.MODULE$.canBuildFrom());
    }

    public Tuple2<Map<String, WordMeta>, Map<Object, float[]>> analyzeTexts(RDD<Tuple2<String, Object>> dataRdd) {
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(dataRdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(Tuple2<String, Object> x0$1) {
                String text;
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null && (text = (String)tuple2._1()) != null) {
                    String string = text;
                    ArrayOps arrayOps = Predef$.MODULE$.refArrayOps((Object[])SimpleTokenizer$.MODULE$.toTokens(string, SimpleTokenizer$.MODULE$.toTokens$default$2()));
                    return arrayOps;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String word) {
                return new Tuple2((Object)word, (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$7, int x$8) {
                return this.apply$mcIII$sp(x$7, x$8);
            }

            public int apply$mcIII$sp(int x$7, int x$8) {
                return x$7 + x$8;
            }
        });
        Serializable x$13 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$9) {
                return -x$9._2$mcI$sp();
            }
        };
        boolean x$14 = qual$1.sortBy$default$2();
        int x$15 = qual$1.sortBy$default$3();
        Tuple2[] frequencies = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])qual$1.sortBy((Function1)x$13, x$14, x$15, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int()).persist().collect()).slice(10, this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.maxWordsNum());
        Range indexes = scala.package$.MODULE$.Range().apply(1, frequencies.length);
        Map word2Meta = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])frequencies).zip((GenIterable)indexes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, WordMeta> apply(Tuple2<Tuple2<String, Object>, Object> item) {
                return new Tuple2(((Tuple2)item._1())._1(), (Object)new WordMeta(((Tuple2)item._1())._2$mcI$sp(), item._2$mcI$sp()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)word2Meta, this.buildWord2Vec((Map<String, WordMeta>)word2Meta));
    }

    public Tuple3<RDD<Tuple2<float[][], Object>>[], Map<String, WordMeta>, Map<Object, float[]>> getData(SparkContext sc) {
        int sequenceLen = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.maxSequenceLength();
        int embeddingDim = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.embeddingDim();
        double trainingSplit = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.trainingSplit();
        RDD dataRdd = sc.parallelize(this.loadRawData(), this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.partitionNum(), ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2<Map<String, WordMeta>, Map<Object, float[]>> tuple2 = this.analyzeTexts((RDD<Tuple2<String, Object>>)dataRdd);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map word2Meta = (Map)tuple2._1();
            Map word2Vec = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)word2Meta, (Object)word2Vec);
            Map word2Meta2 = (Map)tuple23._1();
            Map word2Vec2 = (Map)tuple23._2();
            Broadcast word2MetaBC = sc.broadcast((Object)word2Meta2, ClassTag$.MODULE$.apply(Map.class));
            Broadcast word2VecBC = sc.broadcast((Object)word2Vec2, ClassTag$.MODULE$.apply(Map.class));
            RDD vectorizedRdd = dataRdd.map((Function1)new Serializable(this, word2MetaBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast word2MetaBC$1;

                public final Tuple2<float[], Object> apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String text = (String)tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple22 = new Tuple2((Object)SimpleTokenizer$.MODULE$.toTokens(text, (Map<String, WordMeta>)((Map)this.word2MetaBC$1.value())), (Object)BoxesRunTime.boxToFloat((float)label));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.word2MetaBC$1 = word2MetaBC$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, sequenceLen){
                public static final long serialVersionUID = 0L;
                private final int sequenceLen$1;

                public final Tuple2<float[], Object> apply(Tuple2<float[], Object> x0$3) {
                    Tuple2<float[], Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        float[] tokens = (float[])tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple22 = new Tuple2((Object)SimpleTokenizer$.MODULE$.shaping(tokens, this.sequenceLen$1, SimpleTokenizer$.MODULE$.shaping$default$3()), (Object)BoxesRunTime.boxToFloat((float)label));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sequenceLen$1 = sequenceLen$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, embeddingDim, word2VecBC){
                public static final long serialVersionUID = 0L;
                private final int embeddingDim$1;
                private final Broadcast word2VecBC$1;

                public final Tuple2<float[][], Object> apply(Tuple2<float[], Object> x0$4) {
                    Tuple2<float[], Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        float[] tokens = (float[])tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple22 = new Tuple2((Object)SimpleTokenizer$.MODULE$.vectorization(tokens, this.embeddingDim$1, (Map<Object, float[]>)((Map)this.word2VecBC$1.value())), (Object)BoxesRunTime.boxToFloat((float)label));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.embeddingDim$1 = embeddingDim$1;
                    this.word2VecBC$1 = word2VecBC$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            return new Tuple3((Object)vectorizedRdd.randomSplit(new double[]{trainingSplit, 1.0 - trainingSplit}, vectorizedRdd.randomSplit$default$2()), (Object)word2Meta2, (Object)word2Vec2);
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public Sequential<Object> buildModel(int classNum) {
        void var2_2;
        Sequential<Object> model = Sequential$.MODULE$.apply$mFc$sp((ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        int n = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.embeddingDim();
        int n2 = TemporalConvolution$.MODULE$.apply$default$4();
        boolean bl = TemporalConvolution$.MODULE$.apply$default$5();
        TemporalConvolution$.MODULE$.apply$default$6();
        TemporalConvolution$.MODULE$.apply$default$7();
        TemporalConvolution$.MODULE$.apply$default$8();
        TemporalConvolution$.MODULE$.apply$default$9();
        TemporalConvolution$.MODULE$.apply$default$10();
        TemporalConvolution$.MODULE$.apply$default$11();
        DynamicContainer dynamicContainer = model.add(TemporalConvolution$.MODULE$.apply$mFc$sp(n, 256, 5, n2, bl, null, null, null, null, null, null, (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).add(ReLU$.MODULE$.apply$mFc$sp(ReLU$.MODULE$.apply$default$1(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).add(TemporalMaxPooling$.MODULE$.apply$mFc$sp(this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.maxSequenceLength() - 5 + 1, TemporalMaxPooling$.MODULE$.apply$default$2(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).add(Squeeze$.MODULE$.apply(2, Squeeze$.MODULE$.apply$default$2(), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
        boolean bl2 = Linear$.MODULE$.apply$default$3();
        Linear$.MODULE$.apply$default$4();
        Linear$.MODULE$.apply$default$5();
        Linear$.MODULE$.apply$default$6();
        Linear$.MODULE$.apply$default$7();
        Linear$.MODULE$.apply$default$8();
        Linear$.MODULE$.apply$default$9();
        DynamicContainer dynamicContainer2 = dynamicContainer.add(Linear$.MODULE$.apply$mFc$sp(256, 128, bl2, null, null, null, null, null, null, (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).add(Dropout$.MODULE$.apply(0.2, Dropout$.MODULE$.apply$default$2(), Dropout$.MODULE$.apply$default$3(), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).add(ReLU$.MODULE$.apply$mFc$sp(ReLU$.MODULE$.apply$default$1(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
        boolean bl3 = Linear$.MODULE$.apply$default$3();
        Linear$.MODULE$.apply$default$4();
        Linear$.MODULE$.apply$default$5();
        Linear$.MODULE$.apply$default$6();
        Linear$.MODULE$.apply$default$7();
        Linear$.MODULE$.apply$default$8();
        Linear$.MODULE$.apply$default$9();
        dynamicContainer2.add(Linear$.MODULE$.apply$mFc$sp(128, classNum, bl3, null, null, null, null, null, null, (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).add(LogSoftMax$.MODULE$.apply$mFc$sp((ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
        return var2_2;
    }

    public void train() {
        SparkConf conf = Engine$.MODULE$.createSparkConf(Engine$.MODULE$.createSparkConf$default$1()).setAppName("Text classification").set("spark.task.maxFailures", "1");
        SparkContext sc = new SparkContext(conf);
        Engine$.MODULE$.init();
        int sequenceLen = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.maxSequenceLength();
        int embeddingDim = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.embeddingDim();
        double trainingSplit = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.trainingSplit();
        RDD dataRdd = sc.parallelize(this.loadRawData(), this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.partitionNum(), ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        Tuple2<Map<String, WordMeta>, Map<Object, float[]>> tuple2 = this.analyzeTexts((RDD<Tuple2<String, Object>>)dataRdd);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map word2Meta = (Map)tuple2._1();
            Map word2Vec = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)word2Meta, (Object)word2Vec);
            Map word2Meta2 = (Map)tuple23._1();
            Map word2Vec2 = (Map)tuple23._2();
            Broadcast word2MetaBC = sc.broadcast((Object)word2Meta2, ClassTag$.MODULE$.apply(Map.class));
            Broadcast word2VecBC = sc.broadcast((Object)word2Vec2, ClassTag$.MODULE$.apply(Map.class));
            RDD vectorizedRdd = dataRdd.map((Function1)new Serializable(this, word2MetaBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast word2MetaBC$2;

                public final Tuple2<float[], Object> apply(Tuple2<String, Object> x0$5) {
                    Tuple2<String, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        String text = (String)tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple22 = new Tuple2((Object)SimpleTokenizer$.MODULE$.toTokens(text, (Map<String, WordMeta>)((Map)this.word2MetaBC$2.value())), (Object)BoxesRunTime.boxToFloat((float)label));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.word2MetaBC$2 = word2MetaBC$2;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, sequenceLen){
                public static final long serialVersionUID = 0L;
                private final int sequenceLen$2;

                public final Tuple2<float[], Object> apply(Tuple2<float[], Object> x0$6) {
                    Tuple2<float[], Object> tuple2 = x0$6;
                    if (tuple2 != null) {
                        float[] tokens = (float[])tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple22 = new Tuple2((Object)SimpleTokenizer$.MODULE$.shaping(tokens, this.sequenceLen$2, SimpleTokenizer$.MODULE$.shaping$default$3()), (Object)BoxesRunTime.boxToFloat((float)label));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sequenceLen$2 = sequenceLen$2;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, embeddingDim, word2VecBC){
                public static final long serialVersionUID = 0L;
                private final int embeddingDim$2;
                private final Broadcast word2VecBC$2;

                public final Tuple2<float[][], Object> apply(Tuple2<float[], Object> x0$7) {
                    Tuple2<float[], Object> tuple2 = x0$7;
                    if (tuple2 != null) {
                        float[] tokens = (float[])tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple22 = new Tuple2((Object)SimpleTokenizer$.MODULE$.vectorization(tokens, this.embeddingDim$2, (Map<Object, float[]>)((Map)this.word2VecBC$2.value())), (Object)BoxesRunTime.boxToFloat((float)label));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.embeddingDim$2 = embeddingDim$2;
                    this.word2VecBC$2 = word2VecBC$2;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD sampleRDD = vectorizedRdd.map((Function1)new Serializable(this, sequenceLen, embeddingDim){
                public static final long serialVersionUID = 0L;
                private final int sequenceLen$2;
                private final int embeddingDim$2;

                public final Sample<Object> apply(Tuple2<float[][], Object> x0$8) {
                    Tuple2<float[][], Object> tuple2 = x0$8;
                    if (tuple2 != null) {
                        float[][] input = (float[][])tuple2._1();
                        float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        if (input != null) {
                            float[][] fArray = input;
                            float f = label;
                            Sample<Object> sample = Sample$.MODULE$.apply(Tensor$.MODULE$.apply$mFc$sp((float[])Predef$.MODULE$.refArrayOps((Object[])fArray).flatten((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final WrappedArray<Object> apply(float[] xs) {
                                    return Predef$.MODULE$.wrapFloatArray(xs);
                                }
                            }, ClassTag$.MODULE$.Float()), new int[]{this.sequenceLen$2, this.embeddingDim$2}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$), BoxesRunTime.boxToFloat((float)f), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                            return sample;
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sequenceLen$2 = sequenceLen$2;
                    this.embeddingDim$2 = embeddingDim$2;
                }
            }, ClassTag$.MODULE$.apply(Sample.class)).persist();
            RDD[] rDDArray = sampleRDD.randomSplit(new double[]{trainingSplit, 1.0 - trainingSplit}, sampleRDD.randomSplit$default$2());
            Option option = Array$.MODULE$.unapplySeq((Object)rDDArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                Tuple2 tuple24;
                RDD trainingRDD = (RDD)((SeqLike)option.get()).apply(0);
                RDD valRDD = (RDD)((SeqLike)option.get()).apply(1);
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)trainingRDD, (Object)valRDD);
                RDD trainingRDD2 = (RDD)tuple25._1();
                RDD valRDD2 = (RDD)tuple25._2();
                Sequential<Object> sequential = this.buildModel(this.classNum());
                ClassNLLCriterion$.MODULE$.$lessinit$greater$default$1();
                AbstractCriterion<Activity, Activity, Object> abstractCriterion = package$.MODULE$.convCriterion(new ClassNLLCriterion$mcF$sp(null, ClassNLLCriterion$.MODULE$.$lessinit$greater$default$2(), ClassNLLCriterion$.MODULE$.$lessinit$greater$default$3(), ClassNLLCriterion$.MODULE$.$lessinit$greater$default$4(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
                int n = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.batchSize();
                Optimizer$.MODULE$.apply$default$5();
                Optimizer$.MODULE$.apply$default$6();
                Optimizer<Object, MiniBatch<Object>> optimizer = Optimizer$.MODULE$.apply(sequential, trainingRDD2, abstractCriterion, n, null, null, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                optimizer.setOptimMethod(new Adagrad$mcF$sp(this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.learningRate(), 0.001, Adagrad$.MODULE$.$lessinit$greater$default$3(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).setValidation(Trigger$.MODULE$.everyEpoch(), (RDD<Sample<Object>>)valRDD2, (ValidationMethod[])((Object[])new ValidationMethod[]{new Top1Accuracy<Object>(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)}), this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.batchSize()).setEndWhen(Trigger$.MODULE$.maxEpoch(20)).optimize();
                sc.stop();
                return;
            }
            throw new MatchError((Object)rDDArray);
        }
        throw new MatchError(tuple2);
    }

    public AbstractModule<Activity, Activity, Object> trainFromData(SparkContext sc, RDD<Tuple2<float[][], Object>>[] rdds) {
        RDD trainingRDD = rdds[0].map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TextClassifier $outer;

            public final Sample<Object> apply(Tuple2<float[][], Object> x0$9) {
                Tuple2<float[][], Object> tuple2 = x0$9;
                if (tuple2 != null) {
                    float[][] input = (float[][])tuple2._1();
                    float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    if (input != null) {
                        float[][] fArray = input;
                        float f = label;
                        Sample<Object> sample = Sample$.MODULE$.apply(Tensor$.MODULE$.apply$mFc$sp((float[])Predef$.MODULE$.refArrayOps((Object[])fArray).flatten((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final WrappedArray<Object> apply(float[] xs) {
                                return Predef$.MODULE$.wrapFloatArray(xs);
                            }
                        }, ClassTag$.MODULE$.Float()), new int[]{this.$outer.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.maxSequenceLength(), this.$outer.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.embeddingDim()}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).transpose(1, 2).contiguous(), BoxesRunTime.boxToFloat((float)f), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                        return sample;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Sample.class));
        RDD valRDD = rdds[1].map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TextClassifier $outer;

            public final Sample<Object> apply(Tuple2<float[][], Object> x0$10) {
                Tuple2<float[][], Object> tuple2 = x0$10;
                if (tuple2 != null) {
                    float[][] input = (float[][])tuple2._1();
                    float label = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    if (input != null) {
                        float[][] fArray = input;
                        float f = label;
                        Sample<Object> sample = Sample$.MODULE$.apply(Tensor$.MODULE$.apply$mFc$sp((float[])Predef$.MODULE$.refArrayOps((Object[])fArray).flatten((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final WrappedArray<Object> apply(float[] xs) {
                                return Predef$.MODULE$.wrapFloatArray(xs);
                            }
                        }, ClassTag$.MODULE$.Float()), new int[]{this.$outer.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.maxSequenceLength(), this.$outer.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.embeddingDim()}, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).transpose(1, 2).contiguous(), BoxesRunTime.boxToFloat((float)f), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                        return sample;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Sample.class));
        Sequential<Object> sequential = this.buildModel(this.classNum());
        ClassNLLCriterion$.MODULE$.$lessinit$greater$default$1();
        AbstractCriterion<Activity, Activity, Object> abstractCriterion = package$.MODULE$.convCriterion(new ClassNLLCriterion$mcF$sp(null, ClassNLLCriterion$.MODULE$.$lessinit$greater$default$2(), ClassNLLCriterion$.MODULE$.$lessinit$greater$default$3(), ClassNLLCriterion$.MODULE$.$lessinit$greater$default$4(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
        int n = this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.batchSize();
        Optimizer$.MODULE$.apply$default$5();
        Optimizer$.MODULE$.apply$default$6();
        Optimizer<Object, MiniBatch<Object>> optimizer = Optimizer$.MODULE$.apply(sequential, trainingRDD, abstractCriterion, n, null, null, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        return optimizer.setOptimMethod(new Adagrad$mcF$sp(this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.learningRate(), 2.0E-4, Adagrad$.MODULE$.$lessinit$greater$default$3(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)).setValidation(Trigger$.MODULE$.everyEpoch(), (RDD<Sample<Object>>)valRDD, (ValidationMethod[])((Object[])new ValidationMethod[]{new Top1Accuracy<Object>(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)}), this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param.batchSize()).setEndWhen(Trigger$.MODULE$.maxEpoch(1)).optimize();
    }

    public TextClassifier(AbstractTextClassificationParams param) {
        this.com$intel$analytics$bigdl$dllib$example$utils$TextClassifier$$param = param;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.gloveDir = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/glove.6B/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{param.baseDir()}));
        this.textDataDir = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/20news-18828/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{param.baseDir()}));
        this.classNum = -1;
    }
}

