/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.example.localEstimator;

import com.intel.analytics.bigdl.dllib.estimator.EstimateSupportive$class;
import com.intel.analytics.bigdl.dllib.example.localEstimator.ImageProcessing;
import com.intel.analytics.bigdl.dllib.example.localEstimator.ImageProcessing$class;
import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledBGRImage;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledGreyImage;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MnistDataLoader$
implements ImageProcessing {
    public static final MnistDataLoader$ MODULE$;
    private final Logger logger;
    private final double trainMean;
    private final double trainStd;
    private final double testMean;
    private final double testStd;
    private final float normalize;

    static {
        new MnistDataLoader$();
    }

    @Override
    public float normalize() {
        return this.normalize;
    }

    @Override
    public void com$intel$analytics$bigdl$dllib$example$localEstimator$ImageProcessing$_setter_$normalize_$eq(float x$1) {
        this.normalize = x$1;
    }

    @Override
    public LabeledGreyImage bytesToGreyImage(ByteRecord record, int row, int col) {
        return ImageProcessing$class.bytesToGreyImage(this, record, row, col);
    }

    @Override
    public LabeledGreyImage greyImgNormalize(LabeledGreyImage labeledGreyImage, double mean2, double std) {
        return ImageProcessing$class.greyImgNormalize(this, labeledGreyImage, mean2, std);
    }

    @Override
    public LabeledBGRImage bytesToLabeledBGRImage(ByteRecord record, int resizeW, int resizeH) {
        return ImageProcessing$class.bytesToLabeledBGRImage(this, record, resizeW, resizeH);
    }

    @Override
    public LabeledBGRImage bgrImgNormalize(LabeledBGRImage labeledBGRImage, Tuple3<Object, Object, Object> mean2, Tuple3<Object, Object, Object> std) {
        return ImageProcessing$class.bgrImgNormalize(this, labeledBGRImage, mean2, std);
    }

    @Override
    public LabeledBGRImage hFlip(LabeledBGRImage labeledBGRImage, double threshold) {
        return ImageProcessing$class.hFlip(this, labeledBGRImage, threshold);
    }

    @Override
    public LabeledBGRImage bgrImageRandomCrop(LabeledBGRImage labeledBGRImage, int cropWidth, int cropHeight, int padding) {
        return ImageProcessing$class.bgrImageRandomCrop(this, labeledBGRImage, cropWidth, cropHeight, padding);
    }

    @Override
    public MiniBatch<Object> labeledGreyImageToMiniBatch(LabeledGreyImage[] images) {
        return ImageProcessing$class.labeledGreyImageToMiniBatch(this, images);
    }

    @Override
    public MiniBatch<Object> labeledBGRImageToMiniBatch(LabeledBGRImage[] images) {
        return ImageProcessing$class.labeledBGRImageToMiniBatch(this, images);
    }

    @Override
    public <T> T timing(String name, Function0<T> f) {
        return (T)EstimateSupportive$class.timing(this, name, f);
    }

    @Override
    public <T> T throughputing(String name, int batch, Function0<T> f) {
        return (T)EstimateSupportive$class.throughputing(this, name, batch, f);
    }

    @Override
    public <T> T throughputingWithLoss(String name, int batch, Function0<T> f) {
        return (T)EstimateSupportive$class.throughputingWithLoss(this, name, batch, f);
    }

    @Override
    public void clearWeightBias(AbstractModule<Activity, Activity, Object> model) {
        EstimateSupportive$class.clearWeightBias(this, model);
    }

    @Override
    public AbstractModule<Activity, Activity, Object> makeMetaModel(AbstractModule<Activity, Activity, Object> original) {
        return EstimateSupportive$class.makeMetaModel(this, original);
    }

    @Override
    public void releaseWeightBias(AbstractModule<Activity, Activity, Object> model) {
        EstimateSupportive$class.releaseWeightBias(this, model);
    }

    @Override
    public AbstractModule<Activity, Activity, Object> makeUpModel(AbstractModule<Activity, Activity, Object> clonedModel, Tensor<Object>[] weightBias) {
        return EstimateSupportive$class.makeUpModel(this, clonedModel, weightBias);
    }

    public Logger logger() {
        return this.logger;
    }

    public double trainMean() {
        return this.trainMean;
    }

    public double trainStd() {
        return this.trainStd;
    }

    public double testMean() {
        return this.testMean;
    }

    public double testStd() {
        return this.testStd;
    }

    public LabeledGreyImage[] loadTrainData(String imageDirPath) {
        ByteRecord[] records = (ByteRecord[])this.timing("load bytes from bin", (Function0)new Serializable(imageDirPath){
            public static final long serialVersionUID = 0L;
            private final String imageDirPath$1;

            public final ByteRecord[] apply() {
                String trainDataPath = new StringBuilder().append((Object)this.imageDirPath$1).append((Object)"/train-images-idx3-ubyte").toString();
                String trainLabelPath = new StringBuilder().append((Object)this.imageDirPath$1).append((Object)"/train-labels-idx1-ubyte").toString();
                return MnistDataLoader$.MODULE$.loadData(trainDataPath, trainLabelPath);
            }
            {
                this.imageDirPath$1 = imageDirPath$1;
            }
        });
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " train data loaded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.length)})));
        LabeledGreyImage[] labeledGreyImages = (LabeledGreyImage[])this.timing("transfer bytes to labeledGreyImages", (Function0)new Serializable(records){
            public static final long serialVersionUID = 0L;
            private final ByteRecord[] records$1;

            public final LabeledGreyImage[] apply() {
                return (LabeledGreyImage[])Predef$.MODULE$.refArrayOps((Object[])this.records$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledGreyImage apply(ByteRecord record) {
                        return MnistDataLoader$.MODULE$.bytesToGreyImage(record, 28, 28);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledGreyImage.class)));
            }
            {
                this.records$1 = records$1;
            }
        });
        LabeledGreyImage[] normalized = (LabeledGreyImage[])this.timing("normalize labeledGreyImages", (Function0)new Serializable(labeledGreyImages){
            public static final long serialVersionUID = 0L;
            private final LabeledGreyImage[] labeledGreyImages$1;

            public final LabeledGreyImage[] apply() {
                return (LabeledGreyImage[])Predef$.MODULE$.refArrayOps((Object[])this.labeledGreyImages$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledGreyImage apply(LabeledGreyImage record) {
                        return MnistDataLoader$.MODULE$.greyImgNormalize(record, MnistDataLoader$.MODULE$.trainMean(), MnistDataLoader$.MODULE$.trainStd());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledGreyImage.class)));
            }
            {
                this.labeledGreyImages$1 = labeledGreyImages$1;
            }
        });
        return normalized;
    }

    public LabeledGreyImage[] loadTestData(String imageDirPath) {
        ByteRecord[] records = (ByteRecord[])this.timing("load bytes from bin", (Function0)new Serializable(imageDirPath){
            public static final long serialVersionUID = 0L;
            private final String imageDirPath$2;

            public final ByteRecord[] apply() {
                String validationDataPath = new StringBuilder().append((Object)this.imageDirPath$2).append((Object)"/t10k-images-idx3-ubyte").toString();
                String validationLabelPath = new StringBuilder().append((Object)this.imageDirPath$2).append((Object)"/t10k-labels-idx1-ubyte").toString();
                return MnistDataLoader$.MODULE$.loadData(validationDataPath, validationLabelPath);
            }
            {
                this.imageDirPath$2 = imageDirPath$2;
            }
        });
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " train data loaded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.length)})));
        LabeledGreyImage[] labeledGreyImages = (LabeledGreyImage[])this.timing("transfer bytes to labeledGreyImages", (Function0)new Serializable(records){
            public static final long serialVersionUID = 0L;
            private final ByteRecord[] records$2;

            public final LabeledGreyImage[] apply() {
                return (LabeledGreyImage[])Predef$.MODULE$.refArrayOps((Object[])this.records$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledGreyImage apply(ByteRecord record) {
                        return MnistDataLoader$.MODULE$.bytesToGreyImage(record, 28, 28);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledGreyImage.class)));
            }
            {
                this.records$2 = records$2;
            }
        });
        LabeledGreyImage[] normalized = (LabeledGreyImage[])this.timing("normalize labeledGreyImages", (Function0)new Serializable(labeledGreyImages){
            public static final long serialVersionUID = 0L;
            private final LabeledGreyImage[] labeledGreyImages$2;

            public final LabeledGreyImage[] apply() {
                return (LabeledGreyImage[])Predef$.MODULE$.refArrayOps((Object[])this.labeledGreyImages$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledGreyImage apply(LabeledGreyImage record) {
                        return MnistDataLoader$.MODULE$.greyImgNormalize(record, MnistDataLoader$.MODULE$.testMean(), MnistDataLoader$.MODULE$.testStd());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledGreyImage.class)));
            }
            {
                this.labeledGreyImages$2 = labeledGreyImages$2;
            }
        });
        return normalized;
    }

    public ByteRecord[] loadData(String featureFile, String labelFile) {
        ByteBuffer featureBuffer = featureFile.startsWith("hdfs:") ? ByteBuffer.wrap(this.readHdfsByte(featureFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(featureFile, new String[0])));
        ByteBuffer labelBuffer = featureFile.startsWith("hdfs:") ? ByteBuffer.wrap(this.readHdfsByte(labelFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(labelFile, new String[0])));
        int labelMagicNumber = labelBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelMagicNumber == 2049, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect labelMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelMagicNumber)})), "The data should be wrong,labelMagicNumber for data should be 2049");
        int featureMagicNumber = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(featureMagicNumber == 2051, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect featureMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureMagicNumber)})), "The data should be wrong,featureMagicNumber for data should be 2051");
        int labelCount = labelBuffer.getInt();
        int featureCount = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelCount == featureCount, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label numbers ", " doesn't match feature numbers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelCount), BoxesRunTime.boxToInteger((int)featureCount)})), "The data should be wrong, label numbers should be the same with feature numbers");
        int rowNum = featureBuffer.getInt();
        int colNum = featureBuffer.getInt();
        ByteRecord[] result2 = new ByteRecord[featureCount];
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum];
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[x + y * colNum] = featureBuffer.get();
                }
            }
            result2[i] = new ByteRecord(img, (float)labelBuffer.get() + 1.0f);
        }
        return result2;
    }

    private byte[] readHdfsByte(String fileName) {
        Path src = new Path(fileName);
        FileSystem fs = null;
        FSDataInputStream in = null;
        try {
            fs = FileSystem.newInstance((URI)new URI(fileName), (Configuration)new Configuration());
            in = fs.open(src);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)byteArrayOut, (int)1024, (boolean)true);
            return byteArrayOut.toByteArray();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
    }

    private MnistDataLoader$() {
        MODULE$ = this;
        EstimateSupportive$class.$init$(this);
        ImageProcessing$class.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.trainMean = 0.13066047740239506;
        this.trainStd = 0.3081078;
        this.testMean = 0.13251460696903547;
        this.testStd = 0.31048024;
    }
}

