/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.example.localEstimator;

import com.intel.analytics.bigdl.dllib.example.localEstimator.ImageProcessing;
import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch$;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.BGRImage$;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.GreyImage;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledBGRImage;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledGreyImage;
import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.RandomGenerator$;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class ImageProcessing$class {
    public static LabeledGreyImage bytesToGreyImage(ImageProcessing $this, ByteRecord record, int row, int col) {
        LabeledGreyImage buffer = new LabeledGreyImage(row, col);
        Log4Error$.MODULE$.invalidInputError(row * col == record.data().length, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"row*col(row:", ", col:", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)row), BoxesRunTime.boxToInteger((int)col)}))).append((Object)" should be the same with length of record").toString(), "please correct row and col");
        LabeledGreyImage qual$1 = buffer.setLabel(record.label());
        byte[] x$3 = record.data();
        float x$4 = 255.0f;
        int x$5 = qual$1.copy$default$3();
        return (LabeledGreyImage)qual$1.copy(x$3, x$4, x$5);
    }

    public static LabeledGreyImage greyImgNormalize(ImageProcessing $this, LabeledGreyImage labeledGreyImage, double mean2, double std) {
        float[] content = labeledGreyImage.content();
        for (int i = 0; i < content.length; ++i) {
            content[i] = (float)(((double)content[i] - mean2) / std);
        }
        return labeledGreyImage;
    }

    public static LabeledBGRImage bytesToLabeledBGRImage(ImageProcessing $this, ByteRecord record, int resizeW, int resizeH) {
        byte[] byArray;
        LabeledBGRImage buffer = new LabeledBGRImage();
        if (resizeW == -1) {
            byArray = record.data();
        } else {
            byte[] rawData = record.data();
            ByteBuffer imgBuffer = ByteBuffer.wrap(rawData);
            int width = imgBuffer.getInt();
            int height = imgBuffer.getInt();
            BufferedImage bufferedImage = new BufferedImage(width, height, 5);
            byte[] outputImagePixelData = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            System.arraycopy(imgBuffer.array(), 8, outputImagePixelData, 0, outputImagePixelData.length);
            byArray = BGRImage$.MODULE$.resizeImage(bufferedImage, resizeW, resizeH);
        }
        byte[] imgData = byArray;
        return ((LabeledBGRImage)buffer.copy(imgData, $this.normalize())).setLabel(record.label());
    }

    public static LabeledBGRImage bgrImgNormalize(ImageProcessing $this, LabeledBGRImage labeledBGRImage, Tuple3 mean2, Tuple3 std) {
        Tuple3 tuple3 = mean2;
        if (tuple3 != null) {
            Tuple3 tuple32;
            double meanR = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double meanG = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double meanB = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)meanR), (Object)BoxesRunTime.boxToDouble((double)meanG), (Object)BoxesRunTime.boxToDouble((double)meanB));
            double meanR2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double meanG2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            double meanB2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
            Tuple3 tuple34 = std;
            if (tuple34 != null) {
                Tuple3 tuple35;
                double stdR = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                double stdG = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                double stdB = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)stdR), (Object)BoxesRunTime.boxToDouble((double)stdG), (Object)BoxesRunTime.boxToDouble((double)stdB));
                double stdR2 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
                double stdG2 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
                double stdB2 = BoxesRunTime.unboxToDouble((Object)tuple36._3());
                float[] content = labeledBGRImage.content();
                Log4Error$.MODULE$.invalidInputError(content.length % 3 == 0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect content length"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)content.length)}))).toString(), "expect an image with BGR channel");
                for (int i = 0; i < content.length; i += 3) {
                    content[i + 2] = (float)(((double)content[i + 2] - meanR2) / stdR2);
                    content[i + 1] = (float)(((double)content[i + 1] - meanG2) / stdG2);
                    content[i + 0] = (float)(((double)content[i + 0] - meanB2) / stdB2);
                }
                return labeledBGRImage;
            }
            throw new MatchError((Object)tuple34);
        }
        throw new MatchError((Object)tuple3);
    }

    public static LabeledBGRImage hFlip(ImageProcessing $this, LabeledBGRImage labeledBGRImage, double threshold) {
        return RandomGenerator$.MODULE$.RNG().uniform(0.0, 1.0) >= threshold ? labeledBGRImage.hflip() : labeledBGRImage;
    }

    public static LabeledBGRImage bgrImageRandomCrop(ImageProcessing $this, LabeledBGRImage labeledBGRImage, int cropWidth, int cropHeight, int padding) {
        LabeledBGRImage labeledBGRImage2;
        boolean bl;
        boolean bl2 = bl = padding > 0;
        if (bl) {
            int widthTmp = labeledBGRImage.width();
            int heightTmp = labeledBGRImage.height();
            float[] sourceTmp = labeledBGRImage.content();
            int padWidth = widthTmp + 2 * padding;
            int padHeight = heightTmp + 2 * padding;
            LabeledBGRImage temp = new LabeledBGRImage(padWidth, padHeight);
            float[] tempBuffer = temp.content();
            int startIndex = (padding + padding * padWidth) * 3;
            int frameLength = widthTmp * heightTmp;
            for (int i = 0; i < frameLength; ++i) {
                tempBuffer[startIndex + (i / widthTmp * padWidth + i % widthTmp) * 3 + 2] = sourceTmp[i * 3 + 2];
                tempBuffer[startIndex + (i / widthTmp * padWidth + i % widthTmp) * 3 + 1] = sourceTmp[i * 3 + 1];
                tempBuffer[startIndex + (i / widthTmp * padWidth + i % widthTmp) * 3] = sourceTmp[i * 3];
            }
            temp.setLabel(labeledBGRImage.label());
            labeledBGRImage2 = temp;
        } else {
            labeledBGRImage2 = labeledBGRImage;
        }
        LabeledBGRImage curImg = labeledBGRImage2;
        LabeledBGRImage buffer = new LabeledBGRImage(cropWidth, cropHeight);
        int width = curImg.width();
        int height = curImg.height();
        float[] source = curImg.content();
        int startW = (int)RandomGenerator$.MODULE$.RNG().uniform(0.0, width - cropWidth);
        int startH = (int)RandomGenerator$.MODULE$.RNG().uniform(0.0, height - cropHeight);
        int startIndex = (startW + startH * width) * 3;
        int frameLength = cropWidth * cropHeight;
        float[] target = buffer.content();
        for (int i = 0; i < frameLength; ++i) {
            target[i * 3 + 2] = source[startIndex + (i / cropWidth * width + i % cropWidth) * 3 + 2];
            target[i * 3 + 1] = source[startIndex + (i / cropWidth * width + i % cropWidth) * 3 + 1];
            target[i * 3] = source[startIndex + (i / cropWidth * width + i % cropWidth) * 3];
        }
        buffer.setLabel(curImg.label());
        return buffer;
    }

    public static MiniBatch labeledGreyImageToMiniBatch(ImageProcessing $this, LabeledGreyImage[] images) {
        int height = images[0].height();
        int width = images[0].width();
        int n = images.length;
        float[] featureData = new float[n * height * width];
        float[] labelData = new float[n];
        Tensor<Object> featureTensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        Tensor<Object> labelTensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        int i = 0;
        while (i < images.length) {
            Object object;
            LabeledGreyImage img = images[i];
            ImageProcessing$class.copyImage($this, img, featureData, i * width * height);
            labelData[i] = img.label();
            if (labelTensor.nElement() != ++i) {
                featureTensor.set(Storage$.MODULE$.apply(featureData, ClassTag$.MODULE$.Float()), 1, new int[]{i, height, width}, featureTensor.set$default$4());
                object = labelTensor.set(Storage$.MODULE$.apply(labelData, ClassTag$.MODULE$.Float()), 1, new int[]{i}, labelTensor.set$default$4());
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return MiniBatch$.MODULE$.apply(featureTensor, labelTensor, ClassTag$.MODULE$.Float());
    }

    public static MiniBatch labeledBGRImageToMiniBatch(ImageProcessing $this, LabeledBGRImage[] images) {
        int height = images[0].height();
        int width = images[0].width();
        boolean toRGB = true;
        int n = images.length;
        float[] featureData = new float[n * 3 * height * width];
        float[] labelData = new float[n];
        Tensor<Object> featureTensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        Tensor<Object> labelTensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        int i = 0;
        while (i < images.length) {
            Object object;
            LabeledBGRImage img = images[i];
            img.copyTo(featureData, i * width * height * 3, toRGB);
            labelData[i] = img.label();
            if (labelTensor.nElement() != ++i) {
                featureTensor.set(Storage$.MODULE$.apply(featureData, ClassTag$.MODULE$.Float()), 1, new int[]{i, 3, height, width}, featureTensor.set$default$4());
                object = labelTensor.set(Storage$.MODULE$.apply(labelData, ClassTag$.MODULE$.Float()), 1, new int[]{i}, labelTensor.set$default$4());
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return MiniBatch$.MODULE$.apply(featureTensor, labelTensor, ClassTag$.MODULE$.Float());
    }

    private static void copyImage(ImageProcessing $this, GreyImage img, float[] storage, int offset) {
        float[] content = img.content();
        int frameLength = img.width() * img.height();
        for (int j = 0; j < frameLength; ++j) {
            storage[offset + j] = content[j];
        }
    }

    public static void $init$(ImageProcessing $this) {
        $this.com$intel$analytics$bigdl$dllib$example$localEstimator$ImageProcessing$_setter_$normalize_$eq(255.0f);
    }
}

