/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.example.localEstimator;

import com.intel.analytics.bigdl.dllib.estimator.EstimateSupportive$class;
import com.intel.analytics.bigdl.dllib.example.localEstimator.ImageProcessing;
import com.intel.analytics.bigdl.dllib.example.localEstimator.ImageProcessing$class;
import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledBGRImage;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.LabeledGreyImage;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.File$;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Cifar10DataLoader$
implements ImageProcessing {
    public static final Cifar10DataLoader$ MODULE$;
    private final Logger logger;
    private final Tuple3<Object, Object, Object> trainMean;
    private final Tuple3<Object, Object, Object> trainStd;
    private final Tuple3<Object, Object, Object> testMean;
    private final Tuple3<Object, Object, Object> testStd;
    private final int resizeW;
    private final int resizeH;
    private final float normalize;

    static {
        new Cifar10DataLoader$();
    }

    @Override
    public float normalize() {
        return this.normalize;
    }

    @Override
    public void com$intel$analytics$bigdl$dllib$example$localEstimator$ImageProcessing$_setter_$normalize_$eq(float x$1) {
        this.normalize = x$1;
    }

    @Override
    public LabeledGreyImage bytesToGreyImage(ByteRecord record, int row, int col) {
        return ImageProcessing$class.bytesToGreyImage(this, record, row, col);
    }

    @Override
    public LabeledGreyImage greyImgNormalize(LabeledGreyImage labeledGreyImage, double mean2, double std) {
        return ImageProcessing$class.greyImgNormalize(this, labeledGreyImage, mean2, std);
    }

    @Override
    public LabeledBGRImage bytesToLabeledBGRImage(ByteRecord record, int resizeW, int resizeH) {
        return ImageProcessing$class.bytesToLabeledBGRImage(this, record, resizeW, resizeH);
    }

    @Override
    public LabeledBGRImage bgrImgNormalize(LabeledBGRImage labeledBGRImage, Tuple3<Object, Object, Object> mean2, Tuple3<Object, Object, Object> std) {
        return ImageProcessing$class.bgrImgNormalize(this, labeledBGRImage, mean2, std);
    }

    @Override
    public LabeledBGRImage hFlip(LabeledBGRImage labeledBGRImage, double threshold) {
        return ImageProcessing$class.hFlip(this, labeledBGRImage, threshold);
    }

    @Override
    public LabeledBGRImage bgrImageRandomCrop(LabeledBGRImage labeledBGRImage, int cropWidth, int cropHeight, int padding) {
        return ImageProcessing$class.bgrImageRandomCrop(this, labeledBGRImage, cropWidth, cropHeight, padding);
    }

    @Override
    public MiniBatch<Object> labeledGreyImageToMiniBatch(LabeledGreyImage[] images) {
        return ImageProcessing$class.labeledGreyImageToMiniBatch(this, images);
    }

    @Override
    public MiniBatch<Object> labeledBGRImageToMiniBatch(LabeledBGRImage[] images) {
        return ImageProcessing$class.labeledBGRImageToMiniBatch(this, images);
    }

    @Override
    public <T> T timing(String name, Function0<T> f) {
        return (T)EstimateSupportive$class.timing(this, name, f);
    }

    @Override
    public <T> T throughputing(String name, int batch, Function0<T> f) {
        return (T)EstimateSupportive$class.throughputing(this, name, batch, f);
    }

    @Override
    public <T> T throughputingWithLoss(String name, int batch, Function0<T> f) {
        return (T)EstimateSupportive$class.throughputingWithLoss(this, name, batch, f);
    }

    @Override
    public void clearWeightBias(AbstractModule<Activity, Activity, Object> model) {
        EstimateSupportive$class.clearWeightBias(this, model);
    }

    @Override
    public AbstractModule<Activity, Activity, Object> makeMetaModel(AbstractModule<Activity, Activity, Object> original) {
        return EstimateSupportive$class.makeMetaModel(this, original);
    }

    @Override
    public void releaseWeightBias(AbstractModule<Activity, Activity, Object> model) {
        EstimateSupportive$class.releaseWeightBias(this, model);
    }

    @Override
    public AbstractModule<Activity, Activity, Object> makeUpModel(AbstractModule<Activity, Activity, Object> clonedModel, Tensor<Object>[] weightBias) {
        return EstimateSupportive$class.makeUpModel(this, clonedModel, weightBias);
    }

    public Logger logger() {
        return this.logger;
    }

    public Tuple3<Object, Object, Object> trainMean() {
        return this.trainMean;
    }

    public Tuple3<Object, Object, Object> trainStd() {
        return this.trainStd;
    }

    public Tuple3<Object, Object, Object> testMean() {
        return this.testMean;
    }

    public Tuple3<Object, Object, Object> testStd() {
        return this.testStd;
    }

    public int resizeW() {
        return this.resizeW;
    }

    public int resizeH() {
        return this.resizeH;
    }

    public LabeledBGRImage[] loadTrainData(String imageDirPath) {
        ByteRecord[] records = (ByteRecord[])this.timing("load bytes from bin", (Function0)new Serializable(imageDirPath){
            public static final long serialVersionUID = 0L;
            private final String imageDirPath$1;

            public final ByteRecord[] apply() {
                return Cifar10DataLoader$.MODULE$.loadTrain(this.imageDirPath$1);
            }
            {
                this.imageDirPath$1 = imageDirPath$1;
            }
        });
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " train data loaded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.length)})));
        LabeledBGRImage[] labeledBGRImages = (LabeledBGRImage[])this.timing("transfer bytes to bgrImages", (Function0)new Serializable(records){
            public static final long serialVersionUID = 0L;
            private final ByteRecord[] records$1;

            public final LabeledBGRImage[] apply() {
                return (LabeledBGRImage[])Predef$.MODULE$.refArrayOps((Object[])this.records$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledBGRImage apply(ByteRecord record) {
                        return Cifar10DataLoader$.MODULE$.bytesToLabeledBGRImage(record, Cifar10DataLoader$.MODULE$.resizeW(), Cifar10DataLoader$.MODULE$.resizeH());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledBGRImage.class)));
            }
            {
                this.records$1 = records$1;
            }
        });
        LabeledBGRImage[] normalized = (LabeledBGRImage[])this.timing("normalize the images", (Function0)new Serializable(labeledBGRImages){
            public static final long serialVersionUID = 0L;
            private final LabeledBGRImage[] labeledBGRImages$1;

            public final LabeledBGRImage[] apply() {
                return (LabeledBGRImage[])Predef$.MODULE$.refArrayOps((Object[])this.labeledBGRImages$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledBGRImage apply(LabeledBGRImage image) {
                        return Cifar10DataLoader$.MODULE$.bgrImgNormalize(image, Cifar10DataLoader$.MODULE$.trainMean(), Cifar10DataLoader$.MODULE$.trainStd());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledBGRImage.class)));
            }
            {
                this.labeledBGRImages$1 = labeledBGRImages$1;
            }
        });
        LabeledBGRImage[] hFliped = (LabeledBGRImage[])this.timing("hflip the images", (Function0)new Serializable(normalized){
            public static final long serialVersionUID = 0L;
            private final LabeledBGRImage[] normalized$1;

            public final LabeledBGRImage[] apply() {
                return (LabeledBGRImage[])Predef$.MODULE$.refArrayOps((Object[])this.normalized$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledBGRImage apply(LabeledBGRImage image) {
                        return Cifar10DataLoader$.MODULE$.hFlip(image, 0.5);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledBGRImage.class)));
            }
            {
                this.normalized$1 = normalized$1;
            }
        });
        LabeledBGRImage[] randomCropped = (LabeledBGRImage[])this.timing("randomCrop the images", (Function0)new Serializable(hFliped){
            public static final long serialVersionUID = 0L;
            private final LabeledBGRImage[] hFliped$1;

            public final LabeledBGRImage[] apply() {
                return (LabeledBGRImage[])Predef$.MODULE$.refArrayOps((Object[])this.hFliped$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledBGRImage apply(LabeledBGRImage image) {
                        return Cifar10DataLoader$.MODULE$.bgrImageRandomCrop(image, 32, 32, 4);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledBGRImage.class)));
            }
            {
                this.hFliped$1 = hFliped$1;
            }
        });
        return randomCropped;
    }

    public LabeledBGRImage[] loadTestData(String imageDirPath) {
        ByteRecord[] records = (ByteRecord[])this.timing("load bytes from bin", (Function0)new Serializable(imageDirPath){
            public static final long serialVersionUID = 0L;
            private final String imageDirPath$2;

            public final ByteRecord[] apply() {
                return Cifar10DataLoader$.MODULE$.loadTest(this.imageDirPath$2);
            }
            {
                this.imageDirPath$2 = imageDirPath$2;
            }
        });
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " test data loaded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.length)})));
        LabeledBGRImage[] labeledBGRImages = (LabeledBGRImage[])this.timing("transfer bytes to bgrImages", (Function0)new Serializable(records){
            public static final long serialVersionUID = 0L;
            private final ByteRecord[] records$2;

            public final LabeledBGRImage[] apply() {
                return (LabeledBGRImage[])Predef$.MODULE$.refArrayOps((Object[])this.records$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledBGRImage apply(ByteRecord record) {
                        return Cifar10DataLoader$.MODULE$.bytesToLabeledBGRImage(record, Cifar10DataLoader$.MODULE$.resizeW(), Cifar10DataLoader$.MODULE$.resizeH());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledBGRImage.class)));
            }
            {
                this.records$2 = records$2;
            }
        });
        LabeledBGRImage[] normalized = (LabeledBGRImage[])this.timing("normalize the images", (Function0)new Serializable(labeledBGRImages){
            public static final long serialVersionUID = 0L;
            private final LabeledBGRImage[] labeledBGRImages$2;

            public final LabeledBGRImage[] apply() {
                return (LabeledBGRImage[])Predef$.MODULE$.refArrayOps((Object[])this.labeledBGRImages$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledBGRImage apply(LabeledBGRImage image) {
                        return Cifar10DataLoader$.MODULE$.bgrImgNormalize(image, Cifar10DataLoader$.MODULE$.testMean(), Cifar10DataLoader$.MODULE$.testStd());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledBGRImage.class)));
            }
            {
                this.labeledBGRImages$2 = labeledBGRImages$2;
            }
        });
        return normalized;
    }

    public ByteRecord[] loadTrain(String dataFile) {
        String[] allFiles = (String[])((Object[])new String[]{new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_1.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_2.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_3.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_4.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_5.bin").toString()});
        ArrayBuffer result2 = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])allFiles).foreach((Function1)new Serializable(result2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer result$1;

            public final void apply(String x$1) {
                Cifar10DataLoader$.MODULE$.com$intel$analytics$bigdl$dllib$example$localEstimator$Cifar10DataLoader$$load(x$1, (ArrayBuffer<ByteRecord>)this.result$1);
            }
            {
                this.result$1 = result$1;
            }
        });
        return (ByteRecord[])result2.toArray(ClassTag$.MODULE$.apply(ByteRecord.class));
    }

    public ByteRecord[] loadTest(String dataFile) {
        ArrayBuffer result2 = new ArrayBuffer();
        String testFile = new StringBuilder().append((Object)dataFile).append((Object)"/test_batch.bin").toString();
        this.com$intel$analytics$bigdl$dllib$example$localEstimator$Cifar10DataLoader$$load(testFile, (ArrayBuffer<ByteRecord>)result2);
        return (ByteRecord[])result2.toArray(ClassTag$.MODULE$.apply(ByteRecord.class));
    }

    public void com$intel$analytics$bigdl$dllib$example$localEstimator$Cifar10DataLoader$$load(String featureFile, ArrayBuffer<ByteRecord> result2) {
        int rowNum = 32;
        int colNum = 32;
        int imageOffset = rowNum * colNum * 3 + 1;
        int channelOffset = rowNum * colNum;
        int bufferOffset = 8;
        ByteBuffer featureBuffer = featureFile.startsWith("hdfs:") ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(featureFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(featureFile, new String[0])));
        byte[] featureArray = featureBuffer.array();
        int featureCount = featureArray.length / (rowNum * colNum * 3 + 1);
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum * 3 + bufferOffset];
            ByteBuffer byteBuffer = ByteBuffer.wrap(img);
            byteBuffer.putInt(rowNum);
            byteBuffer.putInt(colNum);
            float label = featureArray[i * imageOffset];
            int start2 = i * imageOffset + 1;
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[(x + y * colNum) * 3 + 2 + bufferOffset] = featureArray[start2 + x + y * colNum];
                    img[(x + y * colNum) * 3 + 1 + bufferOffset] = featureArray[start2 + x + y * colNum + channelOffset];
                    img[(x + y * colNum) * 3 + bufferOffset] = featureArray[start2 + x + y * colNum + 2 * channelOffset];
                }
            }
            result2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ByteRecord[]{new ByteRecord(img, label + 1.0f)}));
        }
    }

    private Cifar10DataLoader$() {
        MODULE$ = this;
        EstimateSupportive$class.$init$(this);
        ImageProcessing$class.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.trainMean = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.4913996898739353), (Object)BoxesRunTime.boxToDouble((double)0.4821584196221302), (Object)BoxesRunTime.boxToDouble((double)0.44653092422369434));
        this.trainStd = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.24703223517429462), (Object)BoxesRunTime.boxToDouble((double)0.2434851308749409), (Object)BoxesRunTime.boxToDouble((double)0.26158784442034005));
        this.testMean = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.4942142913295297), (Object)BoxesRunTime.boxToDouble((double)0.4851314002725445), (Object)BoxesRunTime.boxToDouble((double)0.45040910258647154));
        this.testStd = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.2466525177466614), (Object)BoxesRunTime.boxToDouble((double)0.2428922662655766), (Object)BoxesRunTime.boxToDouble((double)0.26159238066790275));
        this.resizeW = 32;
        this.resizeH = 32;
    }
}

