/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.example.lenetLocal;

import com.intel.analytics.bigdl.dllib.example.lenetLocal.Utils;
import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.utils.File$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final double trainMean;
    private final double trainStd;
    private final double testMean;
    private final double testStd;
    private final OptionParser<Utils.TrainParams> trainParser;
    private final OptionParser<Utils.TestParams> testParser;
    private final OptionParser<Utils.PredictParams> predictParser;

    static {
        new Utils$();
    }

    public double trainMean() {
        return this.trainMean;
    }

    public double trainStd() {
        return this.trainStd;
    }

    public double testMean() {
        return this.testMean;
    }

    public double testStd() {
        return this.testStd;
    }

    public OptionParser<Utils.TrainParams> trainParser() {
        return this.trainParser;
    }

    public OptionParser<Utils.TestParams> testParser() {
        return this.testParser;
    }

    public OptionParser<Utils.PredictParams> predictParser() {
        return this.predictParser;
    }

    public ByteRecord[] load(String featureFile, String labelFile) {
        ByteBuffer featureBuffer = featureFile.startsWith(File$.MODULE$.hdfsPrefix()) ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(featureFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(featureFile, new String[0])));
        ByteBuffer labelBuffer = featureFile.startsWith(File$.MODULE$.hdfsPrefix()) ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(labelFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(labelFile, new String[0])));
        int labelMagicNumber = labelBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelMagicNumber == 2049, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect labelMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelMagicNumber)})), "The data should be wrong,labelMagicNumber for data should be 2049");
        int featureMagicNumber = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(featureMagicNumber == 2051, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpect featureMagicNumber ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureMagicNumber)})), "The data should be wrong,featureMagicNumber for data should be 2051");
        int labelCount = labelBuffer.getInt();
        int featureCount = featureBuffer.getInt();
        Log4Error$.MODULE$.invalidInputError(labelCount == featureCount, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label numbers ", " doesn't match feature numbers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)labelCount), BoxesRunTime.boxToInteger((int)featureCount)})), "The data should be wrong, label numbers should be the same with feature numbers");
        int rowNum = featureBuffer.getInt();
        int colNum = featureBuffer.getInt();
        ByteRecord[] result2 = new ByteRecord[featureCount];
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum];
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[x + y * colNum] = featureBuffer.get();
                }
            }
            result2[i] = new ByteRecord(img, (float)labelBuffer.get() + 1.0f);
        }
        return result2;
    }

    private Utils$() {
        MODULE$ = this;
        this.trainMean = 0.13066047740239506;
        this.trainStd = 0.3081078;
        this.testMean = 0.13251460696903547;
        this.testStd = 0.31048024;
        this.trainParser = new OptionParser<Utils.TrainParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the MNIST data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10());
                    }
                });
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$20 = x;
                        String x$21 = c.copy$default$1();
                        Option<String> x$22 = c.copy$default$2();
                        Option<String> x$23 = c.copy$default$3();
                        Option<String> x$24 = c.copy$default$4();
                        double x$25 = c.copy$default$6();
                        double x$26 = c.copy$default$7();
                        int x$27 = c.copy$default$8();
                        int x$28 = c.copy$default$9();
                        boolean x$29 = c.copy$default$10();
                        return c.copy(x$21, x$22, x$23, x$24, x$20, x$25, x$26, x$27, x$28, x$29);
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$30 = new Some((Object)x);
                        String x$31 = c.copy$default$1();
                        Option<String> x$32 = c.copy$default$2();
                        Option<String> x$33 = c.copy$default$4();
                        int x$34 = c.copy$default$5();
                        double x$35 = c.copy$default$6();
                        double x$36 = c.copy$default$7();
                        int x$37 = c.copy$default$8();
                        int x$38 = c.copy$default$9();
                        boolean x$39 = c.copy$default$10();
                        return c.copy(x$31, x$32, (Option<String>)x$30, x$33, x$34, x$35, x$36, x$37, x$38, x$39);
                    }
                });
                this.opt("state", Read$.MODULE$.stringRead()).text("state snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$40 = new Some((Object)x);
                        String x$41 = c.copy$default$1();
                        Option<String> x$42 = c.copy$default$2();
                        Option<String> x$43 = c.copy$default$3();
                        int x$44 = c.copy$default$5();
                        double x$45 = c.copy$default$6();
                        double x$46 = c.copy$default$7();
                        int x$47 = c.copy$default$8();
                        int x$48 = c.copy$default$9();
                        boolean x$49 = c.copy$default$10();
                        return c.copy(x$41, x$42, x$43, (Option<String>)x$40, x$44, x$45, x$46, x$47, x$48, x$49);
                    }
                });
                this.opt("checkpoint", Read$.MODULE$.stringRead()).text("where to cache the model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$50 = new Some((Object)x);
                        String x$51 = c.copy$default$1();
                        Option<String> x$52 = c.copy$default$3();
                        Option<String> x$53 = c.copy$default$4();
                        int x$54 = c.copy$default$5();
                        double x$55 = c.copy$default$6();
                        double x$56 = c.copy$default$7();
                        int x$57 = c.copy$default$8();
                        int x$58 = c.copy$default$9();
                        boolean x$59 = c.copy$default$10();
                        return c.copy(x$51, (Option<String>)x$50, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59);
                    }
                });
                this.opt('r', "learningRate", Read$.MODULE$.doubleRead()).text("learning rate").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$60 = x;
                        String x$61 = c.copy$default$1();
                        Option<String> x$62 = c.copy$default$2();
                        Option<String> x$63 = c.copy$default$3();
                        Option<String> x$64 = c.copy$default$4();
                        int x$65 = c.copy$default$5();
                        double x$66 = c.copy$default$7();
                        int x$67 = c.copy$default$8();
                        int x$68 = c.copy$default$9();
                        boolean x$69 = c.copy$default$10();
                        return c.copy(x$61, x$62, x$63, x$64, x$65, x$60, x$66, x$67, x$68, x$69);
                    }
                });
                this.opt('d', "learningRateDecay", Read$.MODULE$.doubleRead()).text("learning rate decay").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$70 = x;
                        String x$71 = c.copy$default$1();
                        Option<String> x$72 = c.copy$default$2();
                        Option<String> x$73 = c.copy$default$3();
                        Option<String> x$74 = c.copy$default$4();
                        int x$75 = c.copy$default$5();
                        double x$76 = c.copy$default$6();
                        int x$77 = c.copy$default$8();
                        int x$78 = c.copy$default$9();
                        boolean x$79 = c.copy$default$10();
                        return c.copy(x$71, x$72, x$73, x$74, x$75, x$76, x$70, x$77, x$78, x$79);
                    }
                });
                this.opt('e', "maxEpoch", Read$.MODULE$.intRead()).text("epoch numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$80 = x;
                        String x$81 = c.copy$default$1();
                        Option<String> x$82 = c.copy$default$2();
                        Option<String> x$83 = c.copy$default$3();
                        Option<String> x$84 = c.copy$default$4();
                        int x$85 = c.copy$default$5();
                        double x$86 = c.copy$default$6();
                        double x$87 = c.copy$default$7();
                        int x$88 = c.copy$default$9();
                        boolean x$89 = c.copy$default$10();
                        return c.copy(x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$80, x$88, x$89);
                    }
                });
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$90 = x;
                        String x$91 = c.copy$default$1();
                        Option<String> x$92 = c.copy$default$2();
                        Option<String> x$93 = c.copy$default$3();
                        Option<String> x$94 = c.copy$default$4();
                        double x$95 = c.copy$default$6();
                        double x$96 = c.copy$default$7();
                        int x$97 = c.copy$default$8();
                        int x$98 = c.copy$default$9();
                        boolean x$99 = c.copy$default$10();
                        return c.copy(x$91, x$92, x$93, x$94, x$90, x$95, x$96, x$97, x$98, x$99);
                    }
                });
                this.opt("overWrite", Read$.MODULE$.unitRead()).text("overwrite checkpoint files").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x$1, Utils.TrainParams c) {
                        boolean x$100 = true;
                        String x$101 = c.copy$default$1();
                        Option<String> x$102 = c.copy$default$2();
                        Option<String> x$103 = c.copy$default$3();
                        Option<String> x$104 = c.copy$default$4();
                        int x$105 = c.copy$default$5();
                        double x$106 = c.copy$default$6();
                        double x$107 = c.copy$default$7();
                        int x$108 = c.copy$default$8();
                        int x$109 = c.copy$default$9();
                        return c.copy(x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$100);
                    }
                });
                this.opt('c', "coreNumber", Read$.MODULE$.intRead()).text("core numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$110 = x;
                        String x$111 = c.copy$default$1();
                        Option<String> x$112 = c.copy$default$2();
                        Option<String> x$113 = c.copy$default$3();
                        Option<String> x$114 = c.copy$default$4();
                        int x$115 = c.copy$default$5();
                        double x$116 = c.copy$default$6();
                        double x$117 = c.copy$default$7();
                        int x$118 = c.copy$default$8();
                        boolean x$119 = c.copy$default$10();
                        return c.copy(x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$110, x$119);
                    }
                });
            }
        };
        this.testParser = new OptionParser<Utils.TestParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the MNIST data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        String x$8 = x;
                        String x$9 = c.copy$default$1();
                        int x$10 = c.copy$default$3();
                        int x$11 = c.copy$default$4();
                        return c.copy(x$9, x$8, x$10, x$11);
                    }
                }).required();
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(int x, Utils.TestParams c) {
                        int x$12 = x;
                        String x$13 = c.copy$default$1();
                        String x$14 = c.copy$default$2();
                        int x$15 = c.copy$default$4();
                        return c.copy(x$13, x$14, x$12, x$15);
                    }
                });
                this.opt('c', "coreNumber", Read$.MODULE$.intRead()).text("core numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(int x, Utils.TestParams c) {
                        int x$16 = x;
                        String x$17 = c.copy$default$1();
                        String x$18 = c.copy$default$2();
                        int x$19 = c.copy$default$3();
                        return c.copy(x$17, x$18, x$19, x$16);
                    }
                });
            }
        };
        this.predictParser = new OptionParser<Utils.PredictParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the MNIST data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.PredictParams apply(String x, Utils.PredictParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.PredictParams apply(String x, Utils.PredictParams c) {
                        String x$2 = x;
                        String x$3 = c.copy$default$1();
                        int x$4 = c.copy$default$3();
                        return c.copy(x$3, x$2, x$4);
                    }
                }).required();
                this.opt('c', "coreNumber", Read$.MODULE$.intRead()).text("core numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.PredictParams apply(int x, Utils.PredictParams c) {
                        int x$5 = x;
                        String x$6 = c.copy$default$1();
                        String x$7 = c.copy$default$2();
                        return c.copy(x$6, x$7, x$5);
                    }
                });
            }
        };
    }
}

