/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.common;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class zooUtils$ {
    public static final zooUtils$ MODULE$;
    private final Logger com$intel$analytics$bigdl$dllib$common$zooUtils$$logger;

    static {
        new zooUtils$();
    }

    public Logger com$intel$analytics$bigdl$dllib$common$zooUtils$$logger() {
        return this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger;
    }

    public <T> T timeIt(String name, Function0<T> f) {
        long begin = System.nanoTime();
        Object result2 = f.apply();
        long end = System.nanoTime();
        long cost = end - begin;
        this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " time [", " s]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToDouble((double)((double)cost / 1.0E9))})));
        return (T)result2;
    }

    /*
     * WARNING - void declaration
     */
    public Builder<Tensor<?>, Vector<Tensor<?>>> activity2VectorBuilder(Activity data2) {
        void var2_2;
        Builder builder;
        Builder vec = package$.MODULE$.Vector().newBuilder();
        if (data2.isTensor()) {
            builder = vec.$plus$eq((Object)((Tensor)data2));
        } else {
            for (int i = 0; i < data2.toTable().length(); ++i) {
                vec.$plus$eq(data2.toTable().apply(BoxesRunTime.boxToInteger((int)(i + 1))));
            }
            builder = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public File[] listLocalFiles(String path) {
        ArrayBuffer files = new ArrayBuffer();
        this.listFiles(path, (ArrayBuffer<File>)files);
        return (File[])files.toArray(ClassTag$.MODULE$.apply(File.class));
    }

    public void listFiles(String path, ArrayBuffer<File> files) {
        File file = new File(path);
        if (file.isDirectory()) {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(files){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer files$1;

                public final void apply(File x) {
                    zooUtils$.MODULE$.listFiles(x.getAbsolutePath(), (ArrayBuffer<File>)this.files$1);
                }
                {
                    this.files$1 = files$1;
                }
            });
        } else if (file.isFile()) {
            files.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file}));
        } else {
            WildcardFileFilter filter = new WildcardFileFilter(file.getName());
            Predef$.MODULE$.refArrayOps((Object[])file.getParentFile().listFiles(new FilenameFilter(filter){
                private final WildcardFileFilter filter$1;

                public boolean accept(File dir, String name) {
                    return this.filter$1.accept(dir, name);
                }
                {
                    this.filter$1 = filter$1;
                }
            })).foreach((Function1)new Serializable(files){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer files$1;

                public final void apply(File x) {
                    zooUtils$.MODULE$.listFiles(x.getAbsolutePath(), (ArrayBuffer<File>)this.files$1);
                }
                {
                    this.files$1 = files$1;
                }
            });
        }
    }

    public String[] listPaths(String path, boolean recursive) {
        FileSystem fs = this.getFileSystem(path, this.getFileSystem$default$2());
        ArrayBuffer res = new ArrayBuffer();
        try {
            RemoteIterator files = fs.listFiles(new Path(path), recursive);
            while (files.hasNext()) {
                LocatedFileStatus file = (LocatedFileStatus)files.next();
                if (file.isDirectory()) continue;
                res.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.getPath().toString()}));
            }
        }
        catch (IOException iOException) {
            this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"List paths of ", " error!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        fs.close();
        return (String[])res.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean listPaths$default$2() {
        return false;
    }

    public byte[] readBytes(String path) {
        FileSystem fs = null;
        FSDataInputStream in = null;
        try {
            fs = this.getFileSystem(path, this.getFileSystem$default$2());
            in = fs.open(new Path(path));
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)byteArrayOut, (int)1024, (boolean)true);
            return byteArrayOut.toByteArray();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
    }

    public byte[][] readBytes(String[] paths) {
        return (byte[][])Predef$.MODULE$.refArrayOps((Object[])paths).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String path) {
                return zooUtils$.MODULE$.readBytes(path);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
    }

    /*
     * WARNING - void declaration
     */
    public void writeLines(String path, String lines) {
        FileSystem fs = this.getFileSystem(path, this.getFileSystem$default$2());
        FSDataOutputStream outStream = fs.create(new Path(path), true);
        try {
            outStream.writeBytes(lines);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        outStream.close();
        fs.close();
    }

    public FileSystem getFileSystem(String fileName, boolean newInstance) {
        return newInstance ? FileSystem.newInstance((URI)new Path(fileName).toUri(), (Configuration)new Configuration()) : FileSystem.get((URI)new Path(fileName).toUri(), (Configuration)new Configuration());
    }

    public FileSystem getFileSystem(Path fileName, boolean newInstance) {
        return newInstance ? FileSystem.newInstance((URI)fileName.toUri(), (Configuration)new Configuration()) : FileSystem.get((URI)fileName.toUri(), (Configuration)new Configuration());
    }

    public boolean getFileSystem$default$2() {
        return true;
    }

    public DataOutputStream create(String path, boolean overwrite) {
        return this.getFileSystem(path, this.getFileSystem$default$2()).create(new Path(path), overwrite);
    }

    public boolean create$default$2() {
        return false;
    }

    public DataInputStream open(String path) {
        return this.getFileSystem(path, this.getFileSystem$default$2()).open(new Path(path));
    }

    public String appendPrefix(String localPath) {
        String string;
        if (localPath.startsWith("file://")) {
            string = localPath;
        } else if (localPath.startsWith("/")) {
            string = new StringBuilder().append((Object)"file://").append((Object)localPath).toString();
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"local path must be a absolute path"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidInputError$default$3());
            string = null;
        }
        return string;
    }

    public void putLocalFileToRemote(String localPath, String remotePath, boolean isOverwrite) {
        String path = this.appendPrefix(localPath);
        FSDataInputStream inputStream = this.getFileSystem(path, this.getFileSystem$default$2()).open(new Path(path));
        this.saveStream((InputStream)inputStream, remotePath, isOverwrite);
    }

    public boolean putLocalFileToRemote$default$3() {
        return false;
    }

    public void getRemoteFileToLocal(String remotePath, String localPath, boolean isOverwrite) {
        String path = this.appendPrefix(localPath);
        FSDataInputStream inputStream = this.getFileSystem(remotePath, this.getFileSystem$default$2()).open(new Path(remotePath));
        this.saveStream((InputStream)inputStream, path, isOverwrite);
    }

    public boolean getRemoteFileToLocal$default$3() {
        return false;
    }

    public boolean exists(String path) {
        String updatedPath = path.startsWith("/") ? new StringBuilder().append((Object)"file://").append((Object)path).toString() : path;
        FileSystem fs = this.getFileSystem(updatedPath, this.getFileSystem$default$2());
        boolean result2 = false;
        try {
            try {
                result2 = fs.exists(new Path(updatedPath));
            }
            catch (IOException iOException) {
                this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check existence of ", " error!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            }
        }
        finally {
            fs.close();
        }
        return result2;
    }

    public void mkdirs(String path) {
        String updatedPath = path.startsWith("/") ? new StringBuilder().append((Object)"file://").append((Object)path).toString() : path;
        FileSystem fs = this.getFileSystem(updatedPath, this.getFileSystem$default$2());
        try {
            try {
                fs.mkdirs(new Path(updatedPath));
            }
            catch (IOException iOException) {
                this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make directory of ", " error!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            }
        }
        finally {
            fs.close();
        }
    }

    public void saveBytes(byte[] bytes, String fileName, boolean isOverwrite) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        this.saveStream(stream, fileName, isOverwrite);
    }

    public boolean saveBytes$default$3() {
        return false;
    }

    private void saveStream(InputStream stream, String fileName, boolean isOverwrite) {
        FileSystem fs = null;
        FSDataOutputStream out = null;
        try {
            fs = this.getFileSystem(fileName, this.getFileSystem$default$2());
            out = fs.create(new Path(fileName), isOverwrite);
            IOUtils.copyBytes((InputStream)stream, (OutputStream)out, (int)1024, (boolean)true);
            return;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
    }

    private boolean saveStream$default$3() {
        return false;
    }

    public java.nio.file.Path createTmpDir(String prefix, String permissions) {
        return Files.createTempDirectory(prefix, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(permissions)));
    }

    public String createTmpDir$default$1() {
        return "Zoo";
    }

    public String createTmpDir$default$2() {
        return "rwx------";
    }

    private zooUtils$() {
        MODULE$ = this;
        this.com$intel$analytics$bigdl$dllib$common$zooUtils$$logger = LogManager.getLogger(this.getClass());
    }
}

