/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.common;

import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TensorOperation$ {
    public static final TensorOperation$ MODULE$;

    static {
        new TensorOperation$();
    }

    public <T> int[] expandSize(Tensor<T> tensor, Tensor<T> other, ClassTag<T> evidence$1) {
        int i;
        String errorMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tensor size not match ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(tensor.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(other.size()).mkString("x")}))).toString();
        Tensor<T> longTensor = tensor.dim() > other.dim() ? tensor : other;
        Tensor<T> shortTensor = tensor.dim() > other.dim() ? other : tensor;
        int ndim = longTensor.nDimension();
        int delta = longTensor.nDimension() - shortTensor.nDimension();
        int[] size = new int[ndim];
        for (i = ndim - 1; i >= delta; --i) {
            Log4Error$.MODULE$.unKnowExceptionError(longTensor.size(i + 1) == shortTensor.size(i + 1 - delta) || longTensor.size(i + 1) == 1 || shortTensor.size(i + 1 - delta) == 1, errorMsg, Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            size[i] = package$.MODULE$.max(longTensor.size(i + 1), shortTensor.size(i + 1 - delta));
        }
        while (i >= 0) {
            size[i] = longTensor.size(i + 1);
            --i;
        }
        return size;
    }

    public <T> Tensor<T> expandTensor(Tensor<T> tensor, Tensor<T> tensor2, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        Object object;
        int i;
        int[] targetSize = this.expandSize(tensor, tensor2, evidence$2);
        int[] expandStrides = new int[targetSize.length];
        int[] expandStridesX = new int[targetSize.length];
        int delta2 = targetSize.length - tensor2.nDimension();
        for (i = targetSize.length - 1; i >= delta2; --i) {
            if (tensor2.size(i + 1 - delta2) == 1) continue;
            expandStridesX[i] = tensor2.stride(i + 1 - delta2);
        }
        Tensor<T> expandX = Tensor$.MODULE$.apply(tensor2.storage(), tensor2.storageOffset(), targetSize, expandStridesX, evidence$2, ev);
        if (BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(targetSize).product((Numeric)Numeric.IntIsIntegral$.MODULE$)) != tensor.nElement()) {
            int delta1 = targetSize.length - tensor.nDimension();
            for (i = targetSize.length - 1; i >= delta1; --i) {
                if (tensor.size(i + 1 - delta1) == 1) continue;
                expandStrides[i] = tensor.stride(i + 1 - delta1);
            }
            Tensor<T> tensor1 = Tensor$.MODULE$.apply(tensor.storage(), tensor.storageOffset(), targetSize, expandStrides, evidence$2, ev);
            Tensor<T> qual$1 = Tensor$.MODULE$.apply(evidence$2, ev);
            int[] x$1 = targetSize;
            int[] x$2 = qual$1.resize$default$2();
            Tensor<Tensor<T>> newTensor = qual$1.resize(x$1, x$2).add(tensor1);
            object = tensor.set(newTensor);
        } else {
            object = BoxedUnit.UNIT;
        }
        return expandX;
    }

    public <T> Tensor<T> subTensor(Tensor<T> tensor, Tensor<T> tensor2, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T> expandedTensor = this.expandTensor(tensor, tensor2, evidence$3, ev).contiguous();
        tensor.sub(expandedTensor);
        return tensor;
    }

    public <T> Tensor<T> divTensor(Tensor<T> tensor, Tensor<T> tensor2, ClassTag<T> evidence$4, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T> expandedTensor = this.expandTensor(tensor, tensor2, evidence$4, ev).contiguous();
        tensor.div(expandedTensor);
        return tensor;
    }

    private TensorOperation$() {
        MODULE$ = this;
    }
}

