/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib;

import com.intel.analytics.bigdl.dllib.NNContext$ZooBuildInfo$;
import com.intel.analytics.bigdl.dllib.utils.Engine$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerV1$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerV2$;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Properties$;

public final class NNContext$ {
    public static final NNContext$ MODULE$;
    private final Logger logger;

    static {
        new NNContext$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void checkSparkVersion(boolean reportWarning) {
        this.checkVersion(org.apache.spark.package$.MODULE$.SPARK_VERSION(), NNContext$ZooBuildInfo$.MODULE$.spark_version(), "Spark", reportWarning, this.checkVersion$default$5());
    }

    public boolean checkSparkVersion$default$1() {
        return false;
    }

    public void checkScalaVersion(boolean reportWarning) {
        this.checkVersion(Properties$.MODULE$.versionNumberString(), NNContext$ZooBuildInfo$.MODULE$.scala_version(), "Scala", reportWarning, 2);
    }

    public boolean checkScalaVersion$default$1() {
        return false;
    }

    private void checkVersion(String runtimeVersion, String compileTimeVersion, String project, boolean reportWarning, int level) {
        int[] nArray = (int[])Predef$.MODULE$.refArrayOps((Object[])runtimeVersion.split("\\.")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Option option = Array$.MODULE$.unapplySeq((Object)nArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
            Tuple3 tuple3;
            int runtimeMajor = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
            int runtimeFeature = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
            int runtimeMaintenance = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(2));
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)runtimeMajor), (Object)BoxesRunTime.boxToInteger((int)runtimeFeature), (Object)BoxesRunTime.boxToInteger((int)runtimeMaintenance));
            int runtimeMajor2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int runtimeFeature2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int runtimeMaintenance2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            int[] nArray2 = (int[])Predef$.MODULE$.refArrayOps((Object[])compileTimeVersion.split("\\.")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$3) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Option option2 = Array$.MODULE$.unapplySeq((Object)nArray2);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(3) == 0) {
                Tuple3 tuple33;
                int compileMajor = BoxesRunTime.unboxToInt((Object)((SeqLike)option2.get()).apply(0));
                int compileFeature = BoxesRunTime.unboxToInt((Object)((SeqLike)option2.get()).apply(1));
                int compileMaintenance = BoxesRunTime.unboxToInt((Object)((SeqLike)option2.get()).apply(2));
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)compileMajor), (Object)BoxesRunTime.boxToInteger((int)compileFeature), (Object)BoxesRunTime.boxToInteger((int)compileMaintenance));
                int compileMajor2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
                int compileFeature2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
                int compileMaintenance2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
                String string = runtimeVersion;
                String string2 = compileTimeVersion;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " version check pass"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project})));
                } else {
                    int diffLevel;
                    String warnMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The compile time ", " version is not compatible with"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" the runtime ", " version. Compile time version is ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, compileTimeVersion}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" runtime version is ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{runtimeVersion}))).toString();
                    String errorMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nIf you want to bypass this check, please set"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.analytics.zoo.versionCheck to false, and if you want to only"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"report a warning message, please set spark.analytics.zoo"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".versionCheck.warning to true."})).s((Seq)Nil$.MODULE$)).toString();
                    int n = runtimeMajor2 != compileMajor2 ? 1 : (diffLevel = runtimeFeature2 != compileFeature2 ? 2 : 3);
                    if (diffLevel <= level && !reportWarning) {
                        Log4Error$.MODULE$.unKnowExceptionError(false, new StringBuilder().append((Object)warnMessage).append((Object)errorMessage).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
                    }
                    this.logger().warn(warnMessage);
                }
                return;
            }
            throw new MatchError((Object)nArray2);
        }
        throw new MatchError((Object)nArray);
    }

    private boolean checkVersion$default$4() {
        return false;
    }

    private int checkVersion$default$5() {
        return 1;
    }

    public SparkContext initNNContext(SparkConf conf, String appName) {
        SparkConf zooConf = this.createSparkConf(conf);
        this.initConf(zooConf);
        Object object = appName == null ? BoxedUnit.UNIT : zooConf.setAppName(appName);
        if (zooConf.getBoolean("spark.analytics.zoo.versionCheck", false)) {
            boolean reportWarning = zooConf.getBoolean("spark.analytics.zoo.versionCheck.warning", false);
            this.checkSparkVersion(reportWarning);
            this.checkScalaVersion(reportWarning);
        }
        SparkContext sc = SparkContext$.MODULE$.getOrCreate(zooConf);
        Engine$.MODULE$.init();
        return sc;
    }

    public SparkContext initNNContext(SparkConf conf) {
        return this.initNNContext(conf, null);
    }

    public SparkContext initNNContext(String appName) {
        return this.initNNContext(null, appName);
    }

    public SparkContext initNNContext() {
        return this.initNNContext(null, null);
    }

    public Seq<Tuple2<String, String>> readConf() {
        InputStream stream = this.getClass().getResourceAsStream("/spark-bigdl.conf");
        String[] lines = (String[])Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return x$6.startsWith("spark");
            }
        }).toArray(ClassTag$.MODULE$.apply(String.class));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])lines).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$7) {
                return x$7.split("\\s+");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String[] d) {
                return new Tuple2((Object)d[0], (Object)d[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$8) {
                Object object = x$8._1();
                String string = "spark.shuffle.blockTransferService";
                return (object != null ? !object.equals(string) : string != null) || new StringOps(Predef$.MODULE$.augmentString(System.getProperty("bigdl.network.nio", "true"))).toBoolean();
            }
        });
    }

    public void initConf(SparkConf zooConf) {
        String string = System.getProperty("bigdl.engineType", "mklblas").toLowerCase();
        String string2 = "mklblas";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String kmpAffinity = (String)package$.MODULE$.env().getOrElse((Object)"KMP_AFFINITY", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "granularity=fine,compact,1,0";
                }
            });
            String kmpBlockTime = (String)package$.MODULE$.env().getOrElse((Object)"KMP_BLOCKTIME", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "0";
                }
            });
            String kmpSettings = (String)package$.MODULE$.env().getOrElse((Object)"KMP_SETTINGS", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "1";
                }
            });
            String ompNumThreads = package$.MODULE$.env().contains((Object)"ZOO_NUM_MKLTHREADS") ? (((String)package$.MODULE$.env().apply((Object)"ZOO_NUM_MKLTHREADS")).equalsIgnoreCase("all") ? zooConf.get("spark.executor.cores", ((Object)BoxesRunTime.boxToInteger((int)Runtime.getRuntime().availableProcessors())).toString()) : (String)package$.MODULE$.env().apply((Object)"ZOO_NUM_MKLTHREADS")) : (package$.MODULE$.env().contains((Object)"OMP_NUM_THREADS") ? (String)package$.MODULE$.env().apply((Object)"OMP_NUM_THREADS") : "1");
            zooConf.setExecutorEnv("KMP_AFFINITY", kmpAffinity);
            zooConf.setExecutorEnv("KMP_BLOCKTIME", kmpBlockTime);
            zooConf.setExecutorEnv("KMP_SETTINGS", kmpSettings);
            zooConf.setExecutorEnv("OMP_NUM_THREADS", ompNumThreads);
        }
    }

    public SparkConf createSparkConf(SparkConf existingConf) {
        ObjectRef _conf = ObjectRef.create((Object)existingConf);
        if ((SparkConf)_conf.elem == null) {
            _conf.elem = new SparkConf();
        }
        this.readConf().foreach((Function1)new Serializable(_conf){
            public static final long serialVersionUID = 0L;
            private final ObjectRef _conf$1;

            public final SparkConf apply(Tuple2<String, String> c) {
                return ((SparkConf)this._conf$1.elem).set((String)c._1(), (String)c._2());
            }
            {
                this._conf$1 = _conf$1;
            }
        });
        return (SparkConf)_conf.elem;
    }

    public SparkConf createSparkConf$default$1() {
        return null;
    }

    public String getOptimizerVersion() {
        return Engine$.MODULE$.getOptimizerVersion().toString();
    }

    public void setOptimizerVersion(String optimizerVersion) {
        String string = optimizerVersion.toLowerCase();
        if ("optimizerv1".equals(string)) {
            Engine$.MODULE$.setOptimizerVersion(OptimizerV1$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("optimizerv2".equals(string)) {
            Engine$.MODULE$.setOptimizerVersion(OptimizerV2$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn("supported DistriOptimizerVersion is optimizerV1 or optimizerV2");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private NNContext$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

