/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class MoreObjects {
    public static <T> T firstNonNull(@CheckForNull T first, T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;
        private boolean omitEmptyValues;

        private ToStringHelper(String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.omitEmptyValues = false;
            this.className = Preconditions.checkNotNull(className);
        }

        @CanIgnoreReturnValue
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, @CheckForNull Object value2) {
            return this.addHolder(name, value2);
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, boolean value2) {
            return this.addUnconditionalHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, char value2) {
            return this.addUnconditionalHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, double value2) {
            return this.addUnconditionalHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, float value2) {
            return this.addUnconditionalHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, int value2) {
            return this.addUnconditionalHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, long value2) {
            return this.addUnconditionalHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(@CheckForNull Object value2) {
            return this.addHolder(value2);
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(boolean value2) {
            return this.addUnconditionalHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(char value2) {
            return this.addUnconditionalHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(double value2) {
            return this.addUnconditionalHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(float value2) {
            return this.addUnconditionalHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(int value2) {
            return this.addUnconditionalHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(long value2) {
            return this.addUnconditionalHolder(String.valueOf(value2));
        }

        private static boolean isEmpty(Object value2) {
            if (value2 instanceof CharSequence) {
                return ((CharSequence)value2).length() == 0;
            }
            if (value2 instanceof Collection) {
                return ((Collection)value2).isEmpty();
            }
            if (value2 instanceof Map) {
                return ((Map)value2).isEmpty();
            }
            if (value2 instanceof java.util.Optional) {
                return !((java.util.Optional)value2).isPresent();
            }
            if (value2 instanceof OptionalInt) {
                return !((OptionalInt)value2).isPresent();
            }
            if (value2 instanceof OptionalLong) {
                return !((OptionalLong)value2).isPresent();
            }
            if (value2 instanceof OptionalDouble) {
                return !((OptionalDouble)value2).isPresent();
            }
            if (value2 instanceof Optional) {
                return !((Optional)value2).isPresent();
            }
            if (value2.getClass().isArray()) {
                return Array.getLength(value2) == 0;
            }
            return false;
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            boolean omitEmptyValuesSnapshot = this.omitEmptyValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object value2 = valueHolder.value;
                if (valueHolder instanceof UnconditionalValueHolder || (value2 == null ? !omitNullValuesSnapshot : !omitEmptyValuesSnapshot || !ToStringHelper.isEmpty(value2))) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value2 != null && value2.getClass().isArray()) {
                        Object[] objectArray = new Object[]{value2};
                        String arrayString = Arrays.deepToString(objectArray);
                        builder.append(arrayString, 1, arrayString.length() - 1);
                    } else {
                        builder.append(value2);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(@CheckForNull Object value2) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value2;
            return this;
        }

        private ToStringHelper addHolder(String name, @CheckForNull Object value2) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value2;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private UnconditionalValueHolder addUnconditionalHolder() {
            UnconditionalValueHolder valueHolder = new UnconditionalValueHolder();
            this.holderTail = this.holderTail.next = valueHolder;
            return valueHolder;
        }

        private ToStringHelper addUnconditionalHolder(Object value2) {
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            valueHolder.value = value2;
            return this;
        }

        private ToStringHelper addUnconditionalHolder(String name, Object value2) {
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            valueHolder.value = value2;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private static final class UnconditionalValueHolder
        extends ValueHolder {
            private UnconditionalValueHolder() {
            }
        }

        private static class ValueHolder {
            @CheckForNull
            String name;
            @CheckForNull
            Object value;
            @CheckForNull
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

