/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.Actor$class;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorLogging$class;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.package$CachePolicyIsOrdered$;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r\u0005a!B\u0001\u0003\u0005\u0019Q!\u0001E!ts:\u001cGI\\:SKN|GN^3s\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002e]NT!a\u0002\u0005\u0002\u0005%|'\"A\u0005\u0002\t\u0005\\7.Y\n\u0005\u0001-\tr\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tQ!Y2u_JL!AF\n\u0003\u000b\u0005\u001bGo\u001c:\u0011\u0005IA\u0012BA\r\u0014\u00051\t5\r^8s\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013i\u0012\u0001C:fiRLgnZ:\u0004\u0001A\u0011adH\u0007\u0002\t%\u0011\u0001\u0005\u0002\u0002\f\t:\u001c8+\u001a;uS:<7\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u0015\u0019\u0017m\u00195f!\t!S%D\u0001\u0003\u0013\t1#AA\u0007Bgft7\r\u00128t\u0007\u0006\u001c\u0007.\u001a\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005i1\r\\5f]R4\u0015m\u0019;pef\u0004R\u0001\u0004\u0016-_\rK!aK\u0007\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\n.\u0013\tq3CA\bBGR|'OU3g\r\u0006\u001cGo\u001c:z!\r\u0001\u0004h\u000f\b\u0003cYr!AM\u001b\u000e\u0003MR!\u0001\u000e\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011BA\u001c\u000e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\t1K7\u000f\u001e\u0006\u0003o5\u0001\"\u0001P!\u000e\u0003uR!AP \u0002\u00079,GOC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$!E%oKR\u001cvnY6fi\u0006#GM]3tgB\u0019\u0001\u0007\u000f#\u0011\u0005I)\u0015B\u0001$\u0014\u0005!\t5\r^8s%\u00164\u0007\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005C\u0001\u0013\u0001\u0011\u0015Yr\t1\u0001\u001e\u0011\u0015\u0011s\t1\u0001$\u0011\u0015As\t1\u0001*\u0011\u001dy\u0005A1A\u0005\u0004A\u000b!!Z2\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002W'\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\t\ra\u0003\u0001\u0015!\u0003R\u0003\r)7\r\t\u0005\b5\u0002\u0011\r\u0011b\u0001\\\u0003\u001d!\u0018.\\3pkR,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\"\tA!\u001e;jY&\u0011\u0011M\u0018\u0002\b)&lWm\\;u\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006AA/[7f_V$\b\u0005C\u0004f\u0001\t\u0007I\u0011\u00014\u0002\u00179\fW.Z*feZ,'o]\u000b\u0002_!1\u0001\u000e\u0001Q\u0001\n=\nAB\\1nKN+'O^3sg\u0002BqA\u001b\u0001C\u0002\u0013\u00051.A\nq_NLG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u00170F\u0001m!\tigO\u0004\u0002oi:\u0011qn\u001d\b\u0003aJt!AM9\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA;\u0005\u0003-\u0019\u0015m\u00195f!>d\u0017nY=\n\u0005]D(aC\"bG\",\u0007k\u001c7jGfT!!\u001e\u0003\t\ri\u0004\u0001\u0015!\u0003m\u0003Q\u0001xn]5uSZ,7)Y2iKB{G.[2zA!9A\u0010\u0001b\u0001\n\u0003Y\u0017a\u00058fO\u0006$\u0018N^3DC\u000eDW\rU8mS\u000eL\bB\u0002@\u0001A\u0003%A.\u0001\u000boK\u001e\fG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u0017\u0010\t\u0005\n\u0003\u0003\u0001\u0001\u0019!C\u0005\u0003\u0007\t\u0011B]3rk\u0016\u001cH/\u00133\u0016\u0005\u0005\u0015\u0001c\u0001\u0007\u0002\b%\u0019\u0011\u0011B\u0007\u0003\u000bMCwN\u001d;\t\u0013\u00055\u0001\u00011A\u0005\n\u0005=\u0011!\u0004:fcV,7\u000f^%e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0005]\u0001c\u0001\u0007\u0002\u0014%\u0019\u0011QC\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u00033\tY!!AA\u0002\u0005\u0015\u0011a\u0001=%c!A\u0011Q\u0004\u0001!B\u0013\t)!\u0001\u0006sKF,Xm\u001d;JI\u0002Bq!!\t\u0001\t\u0013\t\u0019#\u0001\u0004oKb$\u0018\n\u001a\u000b\u0003\u0003\u000bA\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\u0002\u0013I,7o\u001c7wKJ\u001cX#A\"\t\u000f\u00055\u0002\u0001)A\u0005\u0007\u0006Q!/Z:pYZ,'o\u001d\u0011\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u00059!/Z2fSZ,WCAA\u001b!\u0011\t9$!\u000f\u000e\u0003\u0001I1!a\u000f\u0016\u0005\u001d\u0011VmY3jm\u0016Dq!a\u0010\u0001\t\u0013\t\t%\u0001\u000bsKN|GN^3XSRD'+Z:pYZ,'o\u001d\u000b\t\u0003\u0007\n9&!\u001b\u0002vA)!+!\u0012\u0002J%\u0019\u0011qI*\u0003\r\u0019+H/\u001e:f!\u0011\tY%!\u0015\u000f\u0007y\ti%C\u0002\u0002P\u0011\t1\u0002\u00128t!J|Go\\2pY&!\u00111KA+\u0005!\u0011Vm]8mm\u0016$'bAA(\t!A\u0011\u0011LA\u001f\u0001\u0004\tY&\u0001\u0003oC6,\u0007\u0003BA/\u0003Gr1\u0001DA0\u0013\r\t\t'D\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0014q\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005T\u0002\u0003\u0005\u0002l\u0005u\u0002\u0019AA7\u0003-\u0011X-];fgR$\u0016\u0010]3\u0011\t\u0005=\u0014\u0011\u000f\b\u0004]\u00065\u0013\u0002BA:\u0003+\u00121BU3rk\u0016\u001cH\u000fV=qK\"9\u0011qEA\u001f\u0001\u0004\u0019\u0005bBA=\u0001\u0011%\u00111P\u0001\rg\u0016tG-U;fgRLwN\u001c\u000b\u0007\u0003{\n\t*!&\u0011\u000bI\u000b)%a \u0011\t\u0005\u0005\u00151\u0012\b\u0005\u0003\u0007\u000b9ID\u0002o\u0003\u000bK!a\u0001\u0003\n\u0007\u0005%%!A\u0005E]N\u001cE.[3oi&!\u0011QRAH\u0005\u0019\ten]<fe*\u0019\u0011\u0011\u0012\u0002\t\u000f\u0005M\u0015q\u000fa\u0001\t\u0006A!/Z:pYZ,'\u000f\u0003\u0005\u0002\u0018\u0006]\u0004\u0019AAM\u0003\u001diWm]:bO\u0016\u0004B!!!\u0002\u001c&!\u0011QTAH\u0005-!en])vKN$\u0018n\u001c8\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\u0006\t\"/Z:pYZ,w+\u001b;i'\u0016\f'o\u00195\u0015\u0011\u0005\r\u0013QUAT\u0003SC\u0001\"!\u0017\u0002 \u0002\u0007\u00111\f\u0005\t\u0003W\ny\n1\u0001\u0002n!9\u00111SAP\u0001\u0004!\u0005bBAW\u0001\u0011%\u0011qV\u0001\re\u0016\u001cx\u000e\u001c<f\r&\u00148\u000f\u001e\u000b\t\u0003\u0007\n\t,a.\u0002:\"A\u00111WAV\u0001\u0004\t),A\u0006tK\u0006\u00148\r\u001b(b[\u0016\u001c\b\u0003\u0002\u00199\u00037B\u0001\"a\u001b\u0002,\u0002\u0007\u0011Q\u000e\u0005\b\u0003'\u000bY\u000b1\u0001E\u0011\u001d\ti\f\u0001C\u0005\u0003\u007f\u000bqA]3t_24X\r\u0006\u0005\u0002D\u0005\u0005\u00171YAc\u0011!\tI&a/A\u0002\u0005m\u0003\u0002CA6\u0003w\u0003\r!!\u001c\t\u000f\u0005M\u00151\u0018a\u0001\t\"\u001a\u0001!!3\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4\t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\fiMA\u0006J]R,'O\\1m\u0003BLw\u0001CAl\u0005!\u0005a!!7\u0002!\u0005\u001b\u0018P\\2E]N\u0014Vm]8mm\u0016\u0014\bc\u0001\u0013\u0002\\\u001a9\u0011A\u0001E\u0001\r\u0005u7cAAn\u0017!9\u0001*a7\u0005\u0002\u0005\u0005HCAAm\u0011)\t)/a7C\u0002\u0013%\u0011q]\u0001\fSB4H'\u00113ee\u0016\u001c8/\u0006\u0002\u0002jB!\u00111^Az\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018\u0001C7bi\u000eD\u0017N\\4\u000b\u0005}k\u0011\u0002BA{\u0003[\u0014QAU3hKbD\u0011\"!?\u0002\\\u0002\u0006I!!;\u0002\u0019%\u0004h\u000fN!eIJ,7o\u001d\u0011\t\u0015\u0005u\u00181\u001cb\u0001\n\u0013\t9/A\u0006jaZ4\u0014\t\u001a3sKN\u001c\b\"\u0003B\u0001\u00037\u0004\u000b\u0011BAu\u00031I\u0007O\u001e\u001cBI\u0012\u0014Xm]:!\u0011!\u0011)!a7\u0005\n\t\u001d\u0011!D5t\u0013:,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0003\n\t=\u0001c\u0001\u0007\u0003\f%\u0019!QB\u0007\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\fB\u0002\u0001\u0004\tY\u0006\u0003\u0006\u0003\u0014\u0005m'\u0019!C\u0005\u0005+\tQ!R7qif,\"!! \t\u0013\te\u00111\u001cQ\u0001\n\u0005u\u0014AB#naRL\bEB\u0004\u0003\u001e\u0005m\u0007Ia\b\u0003-I+7o\u001c7wK\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u001c\u0002Ba\u0007\u0003\"\t\u001d\"Q\u0006\t\u0004a\t\r\u0012b\u0001B\u0013u\tIQ\t_2faRLwN\u001c\t\u0004\u0019\t%\u0012b\u0001B\u0016\u001b\t9\u0001K]8ek\u000e$\bc\u0001\u0007\u00030%\u0019!\u0011G\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0017\tU\"1\u0004BK\u0002\u0013\u0005!qG\u0001\u0004[N<WCAA.\u0011-\u0011YDa\u0007\u0003\u0012\u0003\u0006I!a\u0017\u0002\t5\u001cx\r\t\u0005\b\u0011\nmA\u0011\u0001B )\u0011\u0011\tE!\u0012\u0011\t\t\r#1D\u0007\u0003\u00037D\u0001B!\u000e\u0003>\u0001\u0007\u00111\f\u0005\u000b\u0005\u0013\u0012Y\"!A\u0005\u0002\t-\u0013\u0001B2paf$BA!\u0011\u0003N!Q!Q\u0007B$!\u0003\u0005\r!a\u0017\t\u0015\tE#1DI\u0001\n\u0003\u0011\u0019&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU#\u0006BA.\u0005/Z#A!\u0017\u0011\t\tm#1M\u0007\u0003\u0005;RAAa\u0018\u0003b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001fl\u0011\u0002\u0002B3\u0005;\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011IGa\u0007\u0002\u0002\u0013\u0005#1N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0004\u0003\u0002B8\u0005kj!A!\u001d\u000b\u0007\tMt(\u0001\u0003mC:<\u0017\u0002BA3\u0005cB!B!\u001f\u0003\u001c\u0005\u0005I\u0011\u0001B>\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011i\bE\u0002\r\u0005\u007fJ1A!!\u000e\u0005\rIe\u000e\u001e\u0005\u000b\u0005\u000b\u0013Y\"!A\u0005\u0002\t\u001d\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0013\u0013y\tE\u0002\r\u0005\u0017K1A!$\u000e\u0005\r\te.\u001f\u0005\u000b\u00033\u0011\u0019)!AA\u0002\tu\u0004B\u0003BJ\u00057\t\t\u0011\"\u0011\u0003\u0016\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0018B1!\u0011\u0014BP\u0005\u0013k!Aa'\u000b\u0007\tuU\"\u0001\u0006d_2dWm\u0019;j_:LAA!)\u0003\u001c\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003&\nm\u0011\u0011!C\u0001\u0005O\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0013\u0011I\u000b\u0003\u0006\u0002\u001a\t\r\u0016\u0011!a\u0001\u0005\u0013C!B!,\u0003\u001c\u0005\u0005I\u0011\tBX\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B?\u0011)\u0011\u0019La\u0007\u0002\u0002\u0013\u0005#QW\u0001\u0007KF,\u0018\r\\:\u0015\t\t%!q\u0017\u0005\u000b\u00033\u0011\t,!AA\u0002\t%uA\u0003B^\u00037\f\t\u0011#\u0001\u0003>\u00061\"+Z:pYZ,g)Y5mK\u0012,\u0005pY3qi&|g\u000e\u0005\u0003\u0003D\t}fA\u0003B\u000f\u00037\f\t\u0011#\u0001\u0003BN1!q\u0018Bb\u0005[\u0001\u0002B!2\u0003L\u0006m#\u0011I\u0007\u0003\u0005\u000fT1A!3\u000e\u0003\u001d\u0011XO\u001c;j[\u0016LAA!4\u0003H\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000f!\u0013y\f\"\u0001\u0003RR\u0011!Q\u0018\u0005\u000b\u0005+\u0014y,!A\u0005F\t]\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0004B\u0003Bn\u0005\u007f\u000b\t\u0011\"!\u0003^\u0006)\u0011\r\u001d9msR!!\u0011\tBp\u0011!\u0011)D!7A\u0002\u0005m\u0003B\u0003Br\u0005\u007f\u000b\t\u0011\"!\u0003f\u00069QO\\1qa2LH\u0003\u0002Bt\u0005[\u0004R\u0001\u0004Bu\u00037J1Aa;\u000e\u0005\u0019y\u0005\u000f^5p]\"Q!q\u001eBq\u0003\u0003\u0005\rA!\u0011\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003t\n}\u0016\u0011!C\u0005\u0005k\f1B]3bIJ+7o\u001c7wKR\u0011!q\u001f\t\u0005\u0005_\u0012I0\u0003\u0003\u0003|\nE$AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\\\u0006%\u0007\u0006BAk\u0003\u0013\u0004")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final AsyncDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    @TraitSetter
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging$class.log(this);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    @Override
    public final ActorRef sender() {
        return Actor$class.sender(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor$class.aroundReceive(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor$class.aroundPreStart(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor$class.aroundPostStop(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor$class.aroundPreRestart(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor$class.aroundPostRestart(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor$class.supervisorStrategy(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor$class.preStart(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor$class.postStop(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor$class.preRestart(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor$class.postRestart(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor$class.unhandled(this, message);
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve2 = (DnsProtocol.Resolve)A1;
                    String name = resolve2.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)(mode = resolve2.requestType())));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)some.x();
                        this.$outer.log().debug("{} cached {}", mode, resolved);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(resolved, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1)new Serializable(this, name, mode){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$receive$1 $outer;
                            private final String name$1;
                            private final DnsProtocol.RequestType mode$1;

                            public final DnsProtocol.Resolved apply(DnsProtocol.Resolved resolved) {
                                if (resolved.records().nonEmpty()) {
                                    CachePolicy.CachePolicy cachePolicy = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().positiveCachePolicy();
                                    CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((TraversableOnce)((SeqLike)resolved.records().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final CachePolicy.Ttl apply(ResourceRecord x$1) {
                                            return x$1.ttl();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)cachePolicy, Seq$.MODULE$.canBuildFrom())).min((Ordering)package$CachePolicyIsOrdered$.MODULE$);
                                    this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)this.name$1, (Object)this.mode$1), resolved, minTtl);
                                } else {
                                    CachePolicy.CachePolicy cachePolicy = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().negativeCachePolicy();
                                    CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                    if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                        this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)this.name$1, (Object)this.mode$1), resolved, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().negativeCachePolicy());
                                    }
                                }
                                this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{} resolved {}"})).s((Seq)Nil$.MODULE$), this.mode$1, resolved);
                                return resolved;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.name$1 = name$1;
                                this.mode$1 = mode$1;
                            }
                        }, (ExecutionContext)this.$outer.ec()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }

            public /* synthetic */ AsyncDnsResolver akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        List<ActorRef> list2;
        block6: {
            Future future2;
            block3: {
                Future future3;
                block5: {
                    block4: {
                        block2: {
                            if (!AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) break block2;
                            future2 = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)new Serializable(this, name){
                                public static final long serialVersionUID = 0L;
                                private final String name$2;

                                public final DnsProtocol.Resolved apply() {
                                    InetAddress inetAddress;
                                    block4: {
                                        ARecord record;
                                        ResourceRecord resourceRecord;
                                        block3: {
                                            block2: {
                                                InetAddress address = InetAddress.getByName(this.name$2);
                                                inetAddress = address;
                                                if (!(inetAddress instanceof Inet4Address)) break block2;
                                                resourceRecord = new ARecord(this.name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                                                break block3;
                                            }
                                            if (!(inetAddress instanceof Inet6Address)) break block4;
                                            Inet6Address inet6Address = (Inet6Address)inetAddress;
                                            resourceRecord = new AAAARecord(this.name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                                        }
                                        ARecord aRecord = record = resourceRecord;
                                        return DnsProtocol$Resolved$.MODULE$.apply(this.name$2, (scala.collection.immutable.Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
                                    }
                                    throw new MatchError((Object)inetAddress);
                                }
                                {
                                    this.name$2 = name$2;
                                }
                            }));
                            break block3;
                        }
                        list2 = resolvers;
                        if (!Nil$.MODULE$.equals(list2)) break block4;
                        future3 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to resolve ", " with nameservers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.nameServers()}))));
                        break block5;
                    }
                    if (!(list2 instanceof .colon.colon)) break block6;
                    .colon.colon colon2 = (.colon.colon)list2;
                    ActorRef head = (ActorRef)colon2.head();
                    List tail = colon2.tl$1();
                    future3 = this.resolveWithSearch(name, requestType, head).recoverWith((PartialFunction)new Serializable(this, name, requestType, tail){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        private final String name$2;
                        private final DnsProtocol.RequestType requestType$1;
                        private final List tail$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Future<DnsProtocol.Resolved> future2;
                            A1 A1 = x2;
                            Option option = NonFatal$.MODULE$.unapply(A1);
                            if (option.isEmpty()) {
                                future2 = function1.apply(x2);
                            } else {
                                Throwable t2 = (Throwable)option.get();
                                this.$outer.log().error(t2, "Resolve failed. Trying next name server");
                                future2 = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                            }
                            return (B1)future2;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            Option option = NonFatal$.MODULE$.unapply(throwable);
                            boolean bl = !option.isEmpty();
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$2 = name$2;
                            this.requestType$1 = requestType$1;
                            this.tail$1 = tail$1;
                        }
                    }, (ExecutionContext)this.ec());
                }
                future2 = future3;
            }
            return future2;
        }
        throw new MatchError(list2);
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result2 = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result2.failed().foreach((Function1)new Serializable(this, resolver, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;
            private final ActorRef resolver$1;
            private final DnsClient.DnsQuestion message$1;

            public final void apply(Throwable x$4) {
                package$.MODULE$.actorRef2Scala(this.resolver$1).$bang(new DnsClient.DropRequest(this.message$1.id()), this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
                this.message$1 = message$1;
            }
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future2;
        if (this.settings.SearchDomains().nonEmpty()) {
            List list2;
            List nameWithSearch = (List)this.settings.SearchDomains().map((Function1)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$3;

                public final String apply(String sd) {
                    return new StringBuilder().append((Object)this.name$3).append((Object)".").append((Object)sd).toString();
                }
                {
                    this.name$3 = name$3;
                }
            }, List$.MODULE$.canBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$5) {
                    return x$5 == '.';
                }
            }) >= this.settings.NDots()) {
                String string = name;
                list2 = nameWithSearch.$colon$colon((Object)string);
            } else {
                list2 = (List)nameWithSearch.$colon$plus((Object)name, List$.MODULE$.canBuildFrom());
            }
            List toResolve = list2;
            future2 = this.akka$io$dns$internal$AsyncDnsResolver$$resolveFirst((List<String>)toResolve, requestType, resolver);
        } else {
            future2 = this.resolve(name, requestType, resolver);
        }
        return future2;
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        List<String> list2;
        block5: {
            Future future2;
            block3: {
                block4: {
                    .colon.colon colon2;
                    boolean bl;
                    block2: {
                        bl = false;
                        colon2 = null;
                        list2 = searchNames;
                        if (!(list2 instanceof .colon.colon)) break block2;
                        bl = true;
                        colon2 = (.colon.colon)list2;
                        String searchName = (String)colon2.head();
                        List list3 = colon2.tl$1();
                        if (!Nil$.MODULE$.equals(list3)) break block2;
                        future2 = this.resolve(searchName, requestType, resolver);
                        break block3;
                    }
                    if (!bl) break block4;
                    String searchName = (String)colon2.head();
                    List remaining = colon2.tl$1();
                    future2 = this.resolve(searchName, requestType, resolver).flatMap((Function1)new Serializable(this, requestType, resolver, remaining){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        private final DnsProtocol.RequestType requestType$2;
                        private final ActorRef resolver$2;
                        private final List remaining$1;

                        public final Future<DnsProtocol.Resolved> apply(DnsProtocol.Resolved resolved) {
                            return resolved.records().isEmpty() ? this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveFirst((List<String>)this.remaining$1, this.requestType$2, this.resolver$2) : Future$.MODULE$.successful((Object)resolved);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.requestType$2 = requestType$2;
                            this.resolver$2 = resolver$2;
                            this.remaining$1 = remaining$1;
                        }
                    }, (ExecutionContext)this.ec());
                    break block3;
                }
                if (!Nil$.MODULE$.equals(list2)) break block5;
                future2 = Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
            }
            return future2;
        }
        throw new MatchError(list2);
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        DnsProtocol.RequestType requestType2;
        block4: {
            Future future2;
            block3: {
                String caseFoldedName;
                block2: {
                    this.log().debug("Attempting to resolve {} with {}", name, resolver);
                    caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
                    requestType2 = requestType;
                    if (!(requestType2 instanceof DnsProtocol.Ip)) break block2;
                    DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
                    boolean ipv4 = ip.ipv4();
                    boolean ipv6 = ip.ipv6();
                    Future<DnsClient.Answer> ipv4Recs = ipv4 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
                    Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
                    future2 = ipv4Recs.flatMap((Function1)new Serializable(this, name, ipv6Recs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        public final String name$4;
                        private final Future ipv6Recs$1;

                        public final Future<DnsProtocol.Resolved> apply(DnsClient.Answer ipv4) {
                            return this.ipv6Recs$1.map((Function1)new Serializable(this, ipv4){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$resolve$1 $outer;
                                private final DnsClient.Answer ipv4$1;

                                public final DnsProtocol.Resolved apply(DnsClient.Answer ipv6) {
                                    return new DnsProtocol.Resolved(this.$outer.name$4, (scala.collection.immutable.Seq<ResourceRecord>)((scala.collection.immutable.Seq)this.ipv4$1.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<ResourceRecord>)((scala.collection.immutable.Seq)this.ipv4$1.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.ipv4$1 = ipv4$1;
                                }
                            }, (ExecutionContext)this.$outer.ec());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$4 = name$4;
                            this.ipv6Recs$1 = ipv6Recs$1;
                        }
                    }, (ExecutionContext)this.ec());
                    break block3;
                }
                if (!DnsProtocol$Srv$.MODULE$.equals(requestType2)) break block4;
                future2 = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$4;

                    public final DnsProtocol.Resolved apply(DnsClient.Answer answer) {
                        return new DnsProtocol.Resolved(this.name$4, answer.rrs(), answer.additionalRecs());
                    }
                    {
                        this.name$4 = name$4;
                    }
                }, (ExecutionContext)this.ec());
            }
            return future2;
        }
        throw new MatchError((Object)requestType2);
    }

    public AsyncDnsResolver(DnsSettings settings, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor$class.$init$(this);
        ActorLogging$class.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger((int)settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.msg();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.class.$init$((Product)this);
        }
    }
}

