/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch.forkjoin;

import akka.dispatch.forkjoin.ForkJoinTask;
import sun.misc.Unsafe;

abstract class CountedCompleter<T>
extends ForkJoinTask<T> {
    private static final long serialVersionUID = 5232453752276485070L;
    final CountedCompleter<?> completer;
    volatile int pending;
    private static final Unsafe U;
    private static final long PENDING;

    protected CountedCompleter(CountedCompleter<?> countedCompleter, int n) {
        this.completer = countedCompleter;
        this.pending = n;
    }

    protected CountedCompleter(CountedCompleter<?> countedCompleter) {
        this.completer = countedCompleter;
    }

    protected CountedCompleter() {
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter<?> countedCompleter) {
    }

    public boolean onExceptionalCompletion(Throwable throwable, CountedCompleter<?> countedCompleter) {
        return true;
    }

    public final CountedCompleter<?> getCompleter() {
        return this.completer;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int n) {
        this.pending = n;
    }

    public final void addToPendingCount(int n) {
        int n2;
        while (!U.compareAndSwapInt(this, PENDING, n2 = this.pending, n2 + n)) {
        }
    }

    public final boolean compareAndSetPendingCount(int n, int n2) {
        return U.compareAndSwapInt(this, PENDING, n, n2);
    }

    public final int decrementPendingCountUnlessZero() {
        int n;
        while ((n = this.pending) != 0 && !U.compareAndSwapInt(this, PENDING, n, n - 1)) {
        }
        return n;
    }

    public final CountedCompleter<?> getRoot() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = this;
        while ((countedCompleter = countedCompleter2.completer) != null) {
            countedCompleter2 = countedCompleter;
        }
        return countedCompleter2;
    }

    public final void tryComplete() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (true) {
            int n;
            if ((n = countedCompleter.pending) == 0) {
                countedCompleter.onCompletion(countedCompleter2);
                countedCompleter2 = countedCompleter;
                countedCompleter = countedCompleter2.completer;
                if (countedCompleter != null) continue;
                countedCompleter2.quietlyComplete();
                return;
            }
            if (U.compareAndSwapInt(countedCompleter, PENDING, n, n - 1)) break;
        }
    }

    public final void propagateCompletion() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (true) {
            int n;
            if ((n = countedCompleter.pending) == 0) {
                countedCompleter2 = countedCompleter;
                countedCompleter = countedCompleter2.completer;
                if (countedCompleter != null) continue;
                countedCompleter2.quietlyComplete();
                return;
            }
            if (U.compareAndSwapInt(countedCompleter, PENDING, n, n - 1)) break;
        }
    }

    @Override
    public void complete(T t2) {
        this.setRawResult(t2);
        this.onCompletion(this);
        this.quietlyComplete();
        CountedCompleter<?> countedCompleter = this.completer;
        if (countedCompleter != null) {
            countedCompleter.tryComplete();
        }
    }

    public final CountedCompleter<?> firstComplete() {
        int n;
        do {
            if ((n = this.pending) != 0) continue;
            return this;
        } while (!U.compareAndSwapInt(this, PENDING, n, n - 1));
        return null;
    }

    public final CountedCompleter<?> nextComplete() {
        CountedCompleter<?> countedCompleter = this.completer;
        if (countedCompleter != null) {
            return countedCompleter.firstComplete();
        }
        this.quietlyComplete();
        return null;
    }

    public final void quietlyCompleteRoot() {
        CountedCompleter<?> countedCompleter = this;
        while (true) {
            CountedCompleter<?> countedCompleter2;
            if ((countedCompleter2 = countedCompleter.completer) == null) {
                countedCompleter.quietlyComplete();
                return;
            }
            countedCompleter = countedCompleter2;
        }
    }

    @Override
    void internalPropagateException(Throwable throwable) {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (countedCompleter.onExceptionalCompletion(throwable, countedCompleter2)) {
            countedCompleter2 = countedCompleter;
            countedCompleter = countedCompleter2.completer;
            if (countedCompleter == null || countedCompleter.status < 0) break;
            countedCompleter.recordExceptionalCompletion(throwable);
        }
    }

    @Override
    protected final boolean exec() {
        this.compute();
        return false;
    }

    @Override
    public T getRawResult() {
        return null;
    }

    @Override
    protected void setRawResult(T t2) {
    }

    private static Unsafe getUnsafe() {
        return akka.util.Unsafe.instance;
    }

    static {
        try {
            U = CountedCompleter.getUnsafe();
            PENDING = U.objectFieldOffset(CountedCompleter.class.getDeclaredField("pending"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

