/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.Version$;
import akka.actor.ActorSystem;
import akka.actor.ActorSystemImpl;
import akka.actor.BootstrapSetup;
import akka.actor.BootstrapSetup$;
import akka.actor.Props;
import akka.actor.setup.ActorSystemSetup;
import akka.actor.setup.ActorSystemSetup$;
import akka.actor.setup.Setup;
import akka.util.Reflect$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;

public final class ActorSystem$ {
    public static final ActorSystem$ MODULE$;
    private final String Version;
    private final Option<String> EnvHome;
    private final Option<String> SystemHome;
    private final Option<String> GlobalHome;

    static {
        new ActorSystem$();
    }

    public String Version() {
        return this.Version;
    }

    public Option<String> EnvHome() {
        return this.EnvHome;
    }

    public Option<String> SystemHome() {
        return this.SystemHome;
    }

    public Option<String> GlobalHome() {
        return this.GlobalHome;
    }

    public ActorSystem create() {
        return this.apply();
    }

    public ActorSystem create(String name) {
        return this.apply(name);
    }

    public ActorSystem create(String name, ActorSystemSetup setups) {
        return this.apply(name, setups);
    }

    public ActorSystem create(String name, BootstrapSetup bootstrapSetup) {
        return this.create(name, ActorSystemSetup$.MODULE$.create((Seq<Setup>)Predef$.MODULE$.wrapRefArray((Object[])new Setup[]{bootstrapSetup})));
    }

    public ActorSystem create(String name, Config config) {
        return this.apply(name, config);
    }

    public ActorSystem create(String name, Config config, ClassLoader classLoader) {
        return this.apply(name, config, classLoader);
    }

    public ActorSystem create(String name, Config config, ClassLoader classLoader, ExecutionContext defaultExecutionContext) {
        return this.apply(name, (Option<Config>)Option$.MODULE$.apply((Object)config), (Option<ClassLoader>)Option$.MODULE$.apply((Object)classLoader), (Option<ExecutionContext>)Option$.MODULE$.apply((Object)defaultExecutionContext));
    }

    public ActorSystem apply() {
        return this.apply("default");
    }

    public ActorSystem apply(String name) {
        return this.apply(name, (Option<Config>)None$.MODULE$, (Option<ClassLoader>)None$.MODULE$, (Option<ExecutionContext>)None$.MODULE$);
    }

    public ActorSystem apply(String name, ActorSystemSetup setup) {
        Option bootstrapSettings = setup.get(ClassTag$.MODULE$.apply(BootstrapSetup.class));
        ClassLoader cl = (ClassLoader)bootstrapSettings.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ClassLoader> apply(BootstrapSetup x$1) {
                return x$1.classLoader();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ClassLoader apply() {
                return ActorSystem$.MODULE$.findClassLoader();
            }
        });
        Config appConfig = (Config)bootstrapSettings.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Config> apply(BootstrapSetup x$2) {
                return x$2.config();
            }
        }).getOrElse((Function0)new Serializable(cl){
            public static final long serialVersionUID = 0L;
            private final ClassLoader cl$1;

            public final Config apply() {
                return ConfigFactory.load(this.cl$1);
            }
            {
                this.cl$1 = cl$1;
            }
        });
        Option defaultEC = bootstrapSettings.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ExecutionContext> apply(BootstrapSetup x$3) {
                return x$3.defaultExecutionContext();
            }
        });
        return new ActorSystemImpl(name, appConfig, cl, (Option<ExecutionContext>)defaultEC, (Option<Props>)None$.MODULE$, setup).start();
    }

    public ActorSystem apply(String name, BootstrapSetup bootstrapSetup) {
        return this.create(name, ActorSystemSetup$.MODULE$.create((Seq<Setup>)Predef$.MODULE$.wrapRefArray((Object[])new Setup[]{bootstrapSetup})));
    }

    public ActorSystem apply(String name, Config config) {
        return this.apply(name, (Option<Config>)Option$.MODULE$.apply((Object)config), (Option<ClassLoader>)None$.MODULE$, (Option<ExecutionContext>)None$.MODULE$);
    }

    public ActorSystem apply(String name, Config config, ClassLoader classLoader) {
        return this.apply(name, (Option<Config>)Option$.MODULE$.apply((Object)config), (Option<ClassLoader>)Option$.MODULE$.apply((Object)classLoader), (Option<ExecutionContext>)None$.MODULE$);
    }

    public ActorSystem apply(String name, Option<Config> config, Option<ClassLoader> classLoader, Option<ExecutionContext> defaultExecutionContext) {
        return this.apply(name, ActorSystemSetup$.MODULE$.apply((Seq<Setup>)Predef$.MODULE$.wrapRefArray((Object[])new Setup[]{BootstrapSetup$.MODULE$.apply(classLoader, config, defaultExecutionContext)})));
    }

    public Option<Config> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<ClassLoader> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<ExecutionContext> apply$default$4() {
        return None$.MODULE$;
    }

    public ClassLoader findClassLoader() {
        return Reflect$.MODULE$.findClassLoader();
    }

    private ActorSystem$() {
        MODULE$ = this;
        this.Version = Version$.MODULE$.current();
        String string = System.getenv("AKKA_HOME");
        boolean bl = string == null ? true : ("".equals(string) ? true : ".".equals(string));
        Object object = bl ? None$.MODULE$ : new Some((Object)string);
        this.EnvHome = object;
        String string2 = System.getProperty("akka.home");
        boolean bl2 = string2 == null ? true : "".equals(string2);
        Object object2 = bl2 ? None$.MODULE$ : new Some((Object)string2);
        this.SystemHome = object2;
        this.GlobalHome = this.SystemHome().orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return ActorSystem$.MODULE$.EnvHome();
            }
        });
    }
}

