# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/08b_trainer.ipynb.

# %% auto 0
__all__ = ['PPOTrainer']

# %% ../nbs/08b_trainer.ipynb 3
import pytorch_lightning as pl 

# %% ../nbs/08b_trainer.ipynb 4
from typing import Callable

import torch
from torchtyping import TensorType

# %% ../nbs/08b_trainer.ipynb 6
class PPOTrainer:
    def __init__(
        self, model: Callable, ref_model: Callable,
        epsilon: float, ent_coef: float, vf_coef: float
    ):
        self.model = model
        self.ref_model = ref_model
        self.epsilon = epsilon
        self.ent_coef = ent_coef
        self.vf_coef = vf_coef
        
    def loss(
        self,
        action_logprobs, entropy, value,
        prev_logprobs
    ) -> TensorType["batch_size", 1]:
       
        # ref_probs = F.softmax(ref_logits, dim=-1)
        
        ratio = (action_logprobs - prev_logprobs).exp()
        clipped_ratio = torch.clamp(ratio, min=1-self.epsilon, max=1+self.epsilon)
        
        # TODO: Implement the advantages
        advantages = None
        
        unclipped_pg_loss = ratio * advantages
        clipped_pg_loss = clipped_ratio * advantages
        
        pg_loss = torch.min(unclipped_pg_loss, clipped_pg_loss).mean()
        
        entropy_loss = entropy.mean()
        value_loss = value.mean()
        
        loss = pg_loss - self.ent_coef * entropy_loss + self.vf_coef * value_loss
        
        return loss
    
    def forward(
        self,
        input_ids: TensorType["batch", "seq_len", "n_dim"],
        attention_mask: TensorType["batch", "seq_len"]
    ) -> TensorType["batch", "log_probs"]:
        
        with torch.no_grad():
            # action_logits, action_logprobs, entropy, value
            _, logprobs, entropy, value = self.model(input_ids, attention_mask)
            _, ref_logprob, _, _ = self.ref_model(input_ids, attention_mask)
        
        loss = self.loss(logprobs, entropy, value, ref_logprob)
        
