# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03b_dataset.ipynb.

# %% auto 0
__all__ = ['PairDataset', 'PromptDataset']

# %% ../nbs/03b_dataset.ipynb 3
from typing import Callable

from torch.utils.data import Dataset
from transformers import AutoTokenizer
from datasets import load_dataset
from tqdm import tqdm

# %% ../nbs/03b_dataset.ipynb 5
class PairDataset(Dataset):
    def __init__(self, dataset, tokenizer: Callable, max_length: int):
        
        self.chosen = []
        self.rejected = []
        
        for data in tqdm(dataset):
            chosen, rejected = data["chosen"], data["rejected"]
            chosen_encoding = tokenizer(
                chosen,
                max_length=max_length, padding="max_length", truncation=True,
                return_tensors="pt"
            )
            rejected_encoding = tokenizer(
                rejected,
                max_length=max_length, padding="max_length", truncation=True,
                return_tensors="pt"
            )
            
            self.chosen.append({
                "input_ids": chosen_encoding["input_ids"],
                "attention_mask": chosen_encoding["attention_mask"]
            })
            self.rejected.append({
                "input_ids": rejected_encoding["input_ids"],
                "attention_mask": rejected_encoding["attention_mask"]
            })
            
    
    def __len__(self):
        return len(self.chosen)

    def __getitem__(self, idx: int):
        return self.chosen[idx]["input_ids"],\
               self.chosen[idx]["attention_mask"],\
               self.rejected[idx]["input_ids"],\
               self.rejected[idx]["attention_mask"]

# %% ../nbs/03b_dataset.ipynb 7
class PromptDataset(Dataset):
    def __init__(self, dataset, tokenizer: Callable, max_length: int):
        
        self.prompts = []
        
        for data in tqdm(dataset):
            prompt = data["prompt"]
            prompt_encoding = tokenizer(
                prompt,
                max_length=max_length, padding="max_length", truncation=True,
                return_tensors="pt"
            )
            
            self.prompts.append({
                "input_ids": prompt_encoding["input_ids"],
                "attention_mask": prompt_encoding["attention_mask"]
            })
            
    
    def __len__(self):
        return len(self.prompts)

    def __getitem__(self, idx: int):
        return self.prompts[idx]["input_ids"],\
               self.prompts[idx]["attention_mask"]
