
import numpy as np

from optproblems.base import Individual, TestProblem, BoundConstraintsChecker
from optproblems.continuous import RastriginFunction, WeierstrassFunction, griewank
from optproblems.continuous import EllipsoidFunction, ackley
from optproblems.cec2005.expanded_multimodal import f8f2
from optproblems.cec2005.helper import noisy_sphere, generalized_schaffer6
from optproblems.cec2005.helper import HybridCompositionFunction, my_x_round


def non_continuous_generalized_schaffer6(phenome):
    return generalized_schaffer6([my_x_round(phene) for phene in phenome])



class NonContinuousRastriginFunction(RastriginFunction):

    def __call__(self, phenome):
        return RastriginFunction.__call__(self, [my_x_round(phene) for phene in phenome])



class F24(TestProblem):
    """Rotated hybrid composition function F24."""

    bias = 260.0

    offsets = [[-2.933, -3.034, -4.3583, -4.2851, -3.505, -1.4618, -3.7277, -2.1445, -3.1317, -2.5637, -3.8989, -2.3876, -0.034, -4.4552, -3.714, -3.3126, -1.4816, -2.5411, -4.3659, -2.6029, -0.6167, -0.8081, -2.5529, -1.8479, -1.781, -2.662, -2.1495, -4.0685, -4.1758, -3.2756, -1.2325, -3.5495, -2.158, -1.827, -2.5433, -3.0389, -1.678, -3.9879, -3.7967, -3.6223, -4.0642, -4.1645, -0.3199, -1.5927, -0.9291, -2.8047, -4.1719, -0.4562, -2.1835, -1.5339, -1.6676, -3.0171, -0.2154, -2.9428, -0.4588, -0.707, -2.3426, -3.3727, -1.4639, -0.646, -3.0398, -2.7052, -3.8196, -1.2731, -1.4208, -3.9144, -2.7982, -3.0091, -2.5076, -0.3318, -3.4024, -3.8147, -0.7385, -2.671, -3.2416, -1.3296, -0.8569, -1.792, -3.9521, -0.315, -1.0059, -3.0979, -0.7889, -0.128, -3.0797, -2.7957, -1.2655, -1.7426, -3.2235, -2.6257, -2.5572, -1.5122, -0.1987, -0.314, -2.6271, -2.3302, -0.8416, -2.9056, -0.8504, -0.8612],
               [2.7566, 2.6439, -0.6789, -3.9688, 3.5752, -0.0705, -2.5273, -0.066, -4.435, -0.2208, -0.2615, -4.3198, -2.7086, 2.9678, 0.339, 1.0002, 0.6759, 1.4385, 0.0121, -3.3403, 3.1084, -1.2595, -2.7635, 3.6721, 2.5054, -3.8254, -2.5166, -2.1009, 1.0456, -1.9206, -2.3493, -3.4447, 0.9033, -4.0976, 0.4519, -2.3336, 4.0482, 0.953, 4.2211, 3.0097, 3.9466, -1.2748, -3.2425, 3.2313, 2.02, 2.0356, 0.0379, -1.8788, 3.804, -2.8143, -2.3712, -3.4876, 1.4872, 2.2103, -0.7775, -1.2106, 1.4618, -0.4597, 1.1499, 2.5736, 1.5158, -0.9994, -4.2581, -3.1969, -2.4424, -3.3489, 4.0306, -0.1358, -4.4811, 0.5991, -1.2929, 4.1093, -0.7877, -1.7473, 0.0288, 3.5245, -4.2395, 0.8044, 2.8784, 0.9225, 1.8663, -1.8725, 0.7687, 2.3732, 1.9038, 3.0535, -0.6815, -1.5059, -3.7842, 2.1223, 4.3559, 1.8619, -4.1257, 3.4151, 3.764, -3.0814, 0.4363, -0.8499, 1.9972, -0.6923],
               [0.7973, -2.6471, 4.2808, -3.1835, 1.7367, -2.3262, -0.8345, -2.9156, 3.6308, 3.8112, 3.2618, 2.3853, -4.1136, -1.1119, 2.48, 2.6428, -2.2341, 1.3272, -1.768, 4.0422, 0.885, -2.1732, -4.1174, -3.2763, -2.8187, -0.874, 3.4733, -2.8356, -0.3071, 0.1658, -3.9629, -3.7938, 2.1525, -3.0851, 3.1003, 0.6272, 3.5834, -0.3282, -2.1239, -0.0214, 3.0071, -4.0847, 1.0475, 2.8038, -3.3926, -1.8714, 3.4679, -0.1683, -3.8574, -3.5661, 0.4881, -4.1553, -1.368, -2.2304, 1.2577, -3.1613, 2.9643, 3.1659, -1.6646, 1.5515, 4.1618, -4.0768, 1.4291, -0.0866, 0.7164, -2.254, -3.9443, 1.4134, -3.625, 0.8318, -3.8635, 0.9134, -2.1728, -3.6316, 1.1847, -0.2642, -3.606, -1.7773, 3.8268, -3.2652, -3.9121, -2.644, 2.3913, 0.3505, -2.5459, -0.7189, 0.4546, 0.5971, 3.5506, 4.3163, -1.0449, 1.1792, 1.0047, -2.4204, 0.5554, -1.9113, -3.4721, 3.0789, 2.307, 4.1932],
               [-3.358, 1.2959, -0.6553, -1.2692, -0.0769, -0.641, -1.4244, 0.4667, 4.4519, 0.1002, -1.5615, -0.6526, 0.5629, 0.2538, -4.0498, -2.5856, -2.2311, 2.7212, 0.7093, 3.6952, -2.024, -1.0924, -1.2046, 0.1116, 0.2421, 2.0329, 4.3276, -1.1483, 0.9655, 1.9187, 1.7556, 4.0651, 2.228, 3.9803, 3.6896, -3.065, -1.4649, -1.037, 4.4055, 3.8614, -3.85, 1.1167, 3.0452, 2.4971, -4.0461, 0.1429, -3.3403, 3.5525, -2.5443, -2.72, 4.1718, -2.03, -2.9823, 3.7979, 2.1696, -1.9857, -3.9546, -1.2405, -3.449, 2.4951, -1.5612, -2.849, -3.5493, 2.1796, -0.9441, 0.8015, 4.4328, -3.6146, 0.5695, 4.4698, 0.8576, -0.6552, 3.4949, 0.6096, -1.5317, 1.3373, 0.8383, 3.4971, -2.7204, 1.6802, 1.9906, -3.4974, -2.8669, -0.1033, -3.6258, 0.3054, -0.5209, 0.7757, -0.563, 2.3146, 3.4539, -1.5875, 0.8865, 2.6134, 2.2988, 3.4078, -0.152, -2.0708, 3.5682, -4.0028],
               [-2.128, -2.5922, 2.3095, 2.9635, -1.9277, 0.7746, 0.6163, 2.1095, 1.5214, -1.2784, 0.5726, -2.2119, -1.4116, -4.282, 2.7367, -3.276, -2.1747, 0.8965, 2.012, 2.5031, -2.9224, 1.556, -1.0189, -1.2237, 0.1384, -1.6047, 3.2154, 1.6069, 3.9406, -3.7499, 0.9262, -3.8512, 3.9896, -1.3844, 1.9031, 0.7505, 3.0212, -2.479, -3.5276, -0.8305, 1.4544, 0.8384, -2.7138, 2.1181, 0.7162, 0.6161, -3.6746, 1.3893, 4.1533, -1.8085, -0.6443, 2.0227, 4.3601, 2.061, -1.1309, 1.1459, 1.2092, -0.0434, -4.2059, 1.4125, -4.056, 0.8885, -4.0279, 2.3469, 3.143, 0.2499, 1.859, -0.2614, 4.1173, 1.5549, 0.5506, -4.0462, -2.0177, 0.8036, -0.0824, -3.716, -0.5162, 4.4032, 2.8457, -1.9523, 2.7676, -1.979, 2.488, -4.4877, -0.1034, 2.203, -0.1845, -0.8877, 0.4824, -1.2079, 4.2159, 0.1369, -2.4968, 3.2776, -2.12, 3.4257, 4.4165, -1.0034, -1.7077, -2.8233],
               [1.2224, 4.1029, -4.0255, 0.6018, 1.0075, -1.6413, 1.5123, -3.6486, -1.8582, -2.0668, -1.6173, 0.7485, -4.1157, -0.9765, 3.8474, 0.6453, 2.0221, 3.8976, 3.0367, 2.3322, 3.2811, -2.8397, 3.8729, -0.4036, -3.9194, -0.6533, -4.1767, -0.7957, -3.7512, -0.8126, -4.4196, -3.7956, -2.0244, 3.3661, -0.0443, -3.4459, 4.1883, 2.1915, -3.103, -1.2922, 4.365, -1.1117, 3.205, -4.0065, -1.5098, 2.5295, -1.4771, 0.4508, -0.9985, 3.2862, -0.6113, -2.1287, 3.4847, -3.6248, 0.7918, 4.4497, 4.2444, 2.7207, 0.0198, -1.2832, -2.5132, -3.3443, 2.4171, 4.1623, -0.8437, -2.7966, -1.5855, -1.5833, -1.0282, 0.296, -1.324, 3.7631, 2.0189, 1.7592, 1.3643, 4.4946, -3.0707, 4.3051, -4.4533, 2.7021, -2.2835, 1.6424, -0.5716, 3.4787, 2.8399, -3.1462, 1.4805, -1.5361, -1.753, 1.33, 0.0742, 3.0745, -2.0496, 1.1006, -1.857, -0.6718, -3.2809, 1.9222, 3.7582, 2.5658],
               [-4.3712, 1.7946, 3.2026, 0.2847, -0.2412, -0.7086, -0.3219, 0.6316, 0.2803, -1.6537, -1.3435, 0.5724, 4.3733, 3.1823, 3.1505, -1.9987, 1.2611, 2.2553, -1.395, 3.8934, -2.307, 1.5333, -2.7443, -0.449, 1.5113, -0.2433, -4.249, 4.0256, 3.3922, -2.5678, -3.5738, -3.7076, -1.0551, 3.1326, -0.3609, 4.3632, -3.3821, -1.2225, 0.1231, 2.8397, -3.142, 2.9603, -4.1404, 3.0673, -4.1608, -3.7817, 0.9934, 4.0616, 1.922, 3.9222, -3.5899, -1.44, -4.1604, -0.9288, -0.369, -2.7274, 3.7889, -3.3479, 0.8056, -1.8297, -3.4149, 2.4764, -2.5994, -0.8007, 3.9596, 0.7318, -2.0331, 4.2945, -4.4793, 2.4007, 3.7743, -3.5683, 1.8268, -3.211, -2.7969, 2.8166, -3.4289, 3.7668, 0.1985, -2.9719, -2.4519, -0.9539, -2.2616, 1.5301, 3.6319, -3.1614, -3.3202, -4.1063, -1.1302, 0.4019, -1.8216, -2.2647, -3.1187, 2.7008, -0.5987, 2.4281, 0.5717, -3.746, 3.9734, 2.1571],
               [1.2632, 2.2135, -1.257, -0.6689, 1.4409, -0.196, -3.353, -3.2434, -3.6894, -0.961, -4.1986, 3.3371, 1.9744, 3.85, 2.0967, 3.2178, 2.5961, 1.0703, -1.4722, -3.5784, 0.6505, -0.7708, 0.3999, 2.4353, -2.0579, 2.9733, -1.1434, 2.0497, 2.8007, -0.1383, 3.4505, 2.6291, 0.057, -3.5032, -1.1874, -0.5915, 1.401, 2.4006, -4.0271, 3.037, -2.7984, -2.8638, -3.1617, -0.0212, 3.1318, 3.7452, 1.1864, 0.3354, -3.9829, -0.0381, 3.3726, -4.4449, 0.9337, -2.8067, -2.7431, 4.4885, 2.3118, 3.2176, -3.0769, -4.342, -4.4442, 3.9384, -3.0529, 4.047, 3.7186, -1.4733, -0.0377, 0.6873, -3.9776, -2.9155, 0.8623, 4.1455, 1.4008, 2.3806, -0.9948, -1.4551, -1.4456, -0.476, 0.0229, 3.6254, 3.3074, -1.0792, 2.0159, 3.7015, 0.7945, 0.5595, -1.8985, -1.4766, 3.7289, -0.9762, -2.8409, 3.1363, 0.957, 0.0569, 2.631, -1.2425, 0.7195, -0.5023, 2.2889, 1.2799],
               [-0.9932, 4.2521, 2.0679, 3.6188, -1.0643, -0.7975, 0.8036, -3.7737, 3.0495, -0.5898, -0.9806, -2.8092, -1.9856, 3.7251, -0.5975, 2.6815, 1.8315, 4.3534, -2.3328, 2.0092, -3.767, 3.6393, -2.1809, 3.5192, -0.0221, -0.1659, -0.6157, 2.0536, 1.0157, -2.616, -2.4138, 2.9204, 2.9049, -0.2416, 2.1169, -0.8913, -1.715, 0.8743, 2.218, -2.254, 3.6385, 1.5777, -3.8437, 2.0135, 1.423, -3.5809, -2.3014, 2.7912, -4.2032, 0.6392, -3.6856, 0.8609, -3.4677, 3.0436, -0.6078, -1.1022, 2.8349, 0.3003, -1.4658, -1.3328, 1.4804, -1.6344, -3.7183, 0.3461, -0.259, 2.8373, 3.678, -2.1282, -3.5349, 1.7222, 0.8286, -4.227, 2.3142, -0.3465, 0.1348, 3.1614, -3.2523, -0.8104, 1.5001, 1.5352, 1.2486, 1.7121, 1.3063, 1.5714, 4.4643, -3.2647, -2.1723, -2.5281, 2.2508, -3.457, 2.3774, 2.7587, -2.9973, 2.2316, 3.7265, 3.733, 1.688, -1.2433, -2.2837, -2.8789],
               [2.2338, -1.5576, 0.5676, -3.7613, 0.7158, 3.8908, 3.9828, -4.3631, 2.5773, 2.2984, 3.0914, -0.8948, -2.8821, -3.1186, 1.3632, -0.3217, -4.3819, 1.2439, -0.8405, -1.4166, 3.7572, 4.1132, -1.2762, -2.0259, 1.774, -3.3218, -1.0285, -4.4784, 3.5801, 2.3292, -4.1144, 1.9698, 0.2125, 0.7362, -3.2355, -0.5632, 3.2907, -3.1096, 1.6457, 1.2577, 3.6718, 3.6243, -0.0565, -2.3219, -1.3113, 0.1176, 3.6424, -1.5936, -3.7333, 2.4013, -0.2359, -0.3807, -2.5281, 2.617, 2.2814, 2.2583, 3.1559, 0.0479, -2.7942, 1.0215, 2.6928, -2.8059, 2.8084, -3.3379, 3.0739, -0.4574, 2.6444, -3.1264, 3.2172, -3.5807, -2.731, -0.9978, 0.8758, -3.9394, 1.7537, -2.4411, 3.6922, -3.5676, -0.9369, -0.9483, 3.9858, -1.5177, -2.2266, -0.0228, -0.2721, 2.3782, 2.2165, -3.3228, -1.229, -0.9029, -1.7354, -1.2438, -1.6287, -0.9565, 1.0308, 4.4342, 1.4077, -0.3571, -2.8314, -4.3078]]

    matrices2D = np.array([[[-20.92217293549062, 12.37850648192346],
                            [-85.50706067396771, 45.81023719467963]],
                           [[13.41416548645878, 7.867480844457048],
                            [-42.53195364962208, -21.217818648730102]],
                           [[-1.0388696549462169, -1.6044232609479447],
                            [0.6929502908856753, 29.947727722385256]],
                           [[0.20117457113580223, -1.0865372183068356],
                            [-9.668350618310882, 2.5103708862576317]],
                           [[-1.987079738440388, 2.006530642139547],
                            [-1.4572009960053325, 3.9877204205505423]],
                           [[2.0374876241365714, 4.369651091436266],
                            [1.4875407203552244, 0.7362174447031388]],
                           [[-0.9015931278989314, 2.9723189062577897],
                            [-1.9250072310266209, 1.9096589516777986]],
                           [[0.8601573776574131, 0.803150369112515],
                            [-0.6764254669729128, 2.856138539687183]],
                           [[-0.6434347169532721, -0.8041895752923905],
                            [1.7725779482060497, -0.8928820244264846]],
                           [[1.8691899753089167, 0.35096002092728873],
                            [0.32328512728123104, 1.1306823720188286]]])

    matrices10D = np.array([[[14.268707566342465, 12.161153513447072, 5.7786800334748669, 7.5845305060943558, 0.6231127038688673, 19.807620398997997, 10.628692466911332, -19.74451370026603, 12.70438694218973, -6.6585847135317957],
                             [2.4118861586080294, 16.551289204939415, 24.054233453445935, 2.4447597826297778, -2.7805292508739603, 3.7808065310824475, 11.486086354824755, -1.2171210227630056, 19.606381250795089, -5.9520311030388093],
                             [1.8100644335995906, 12.588130795592225, 3.4254760896000667, 10.895844601387989, 7.0635927491950552, 16.423202143164417, -0.86404121328268391, -17.437650188919985, 20.922215345140643, 12.03271337913997],
                             [-0.14055228825853316, 6.0682953547608296, -1.9870795674607031, -31.081664701497452, -11.656887983599731, -15.399542242937985, -19.401554711054345, 37.565540519869515, -44.688270655318782, 22.068457402260002],
                             [-3.3773367921288098, 17.477725322962325, 13.874848343690406, 4.1726920930657752, -1.943071722633108, -10.377994917214897, 8.3502058037745055, 10.502082704000989, 14.67773365761267, -2.602643093982826],
                             [-14.034748398093322, -10.985979795507351, 5.648252378163777, 2.1043967998228039, 9.8982782765915651, -20.62155054227852, -7.0540145171098017, 8.7252282913592953, -1.2591994425709538, 7.0960781348055519],
                             [13.332198606424338, 5.1137948052544058, 11.265873715445174, -14.741816234771816, -23.707940760035985, 23.140046482658949, 21.889975874651501, -21.786032028650393, 0.70716536136102015, 7.8062472319659175],
                             [14.850643513015626, 19.331372873753033, 3.1014602257476183, -3.1090647254745014, -8.7289977747088727, 30.222239932027879, 12.745219038337277, -14.311780215944417, 8.0095769999834445, 0.040759866834169767],
                             [18.195488984288623, 4.1013236927738586, 8.9879935862340563, 5.247210916005292, 6.3150893106345087, 11.05779650861767, -3.1465181153451955, -0.20814178908390091, 1.303108194072641, 9.1558924922241491],
                             [-6.0429822413103143, 6.2393321285917915, -8.6038829942404025, -15.862554207294687, -17.359032322673379, 18.550045934855273, 15.248891338454039, -7.3819076909160417, -10.123604617992308, 5.7831545719841753]],
                            [[6.558398549616534, 8.2653163566928907, -6.4683816105836414, -2.7220986910103244, -12.087099911699761, -2.0934280578730657, 11.980800659929917, -1.3841918762088181, 7.1308741705350931, -3.2750904566129941],
                             [6.1748974661674714, -1.6710087288252529, -2.6784501194134829, 1.4978667290135521, 10.648359776909015, -1.3678319315686427, -7.3309520160143951, 3.1672982809646397, -6.4114608276024336, 2.4349097785017579],
                             [-16.570432790620668, 7.2434830788113791, -12.324225190857224, -0.62258232206832254, 3.7646118197179987, -17.390492465615278, -8.274989183555153, -5.9854962029117988, -3.1333678324976653, 7.9925194985856267],
                             [-12.886781871344599, 1.1719852425014698, -6.7815396797732816, -0.87447374939002398, -19.063081002400743, 2.1887931633766979, 4.3187230138872881, 3.0269590770414596, 15.580462874280297, -2.4297736401437051],
                             [2.2554712670828692, 0.9881590273956411, 6.9201580332169401, 1.2282580590381587, 9.7478550321450346, 2.993651256096729, -2.4042851226224484, -1.3986234718457595, -2.1426212430191445, -2.0844936458053978],
                             [19.661901383270635, 7.0430535024504586, 4.6063670449662855, -4.2307136637850098, -5.002490688553614, 1.3089278335793997, 13.75613044985414, -1.6729596920947318, 0.51817038060778753, -5.5343946618522892],
                             [-8.0731577403568853, 0.43418644835320075, 1.2106906346665274, 2.4704037092586604, -1.5387134679238441, -2.9995296704773162, 0.0836472175363452, 1.1412450072687137, 3.326979709133548, -1.3810696228512109],
                             [11.950548123353052, 7.7137148630423793, 9.2465748372062286, 4.891814734035278, 19.227812563252595, -10.260538221637496, 5.4177942451593575, -10.590369547106937, -15.989255966142931, 6.8702146233145127],
                             [-14.511622277891231, -3.8573331907090282, -12.426459128078266, -2.9470165871441152, -0.13237315187221926, 0.12142977357788208, -18.074982264421141, -0.72308055046277819, 0.90963741134404485, 3.6943282904487202],
                             [-11.087678642046958, 1.6277777315574971, 0.37044242179427234, 4.2586714638854213, 7.3026205251488845, -6.565643493039075, -3.4770411942643893, -3.4111781576460483, -5.4377389632947262, 6.3051534103224327]],
                            [[6.7807363795870268, -2.9141521764231824, -1.7968190726671553, -0.34654795530435317, 3.0250897357549391, 1.1653905771711419, -1.7072791142200667, -7.4667112421822459, -1.7073711141485419, -1.4880526161633711],
                             [2.5256479769359119, -1.7096492161909762, -0.67164191381406568, -2.1648503016649228, -3.172171555937036, -3.9150712223335802, 4.0475174036775083, 5.9053935238742925, -4.7496389610733267, 6.315818869090517],
                             [-5.8347947935290554, -5.2350979647633906, 7.2993393616285491, 5.0951251812062344, -6.9697333893445315, 2.1377389449288859, 9.464240106930438, 5.5595409155775162, 2.845609976836597, 7.4932035638167438],
                             [0.23926327276243531, -4.592487102596186, 2.5834214342518385, -0.88235421492428023, -5.9834462509761188, -2.6857965810146212, 4.7901313667586516, 7.358384940575152, -3.7880553489626121, 5.4922290301961469],
                             [2.6006164566739982, -0.064103719308146845, -1.0914115617209752, -2.0728373340080903, -3.4883039509964098, -0.4501517789918969, 0.9208128032189129, -2.0898830606254215, -2.5844817885108644, 1.3455303327383825],
                             [-0.56901742861101201, 4.2600562643584805, -2.2412190844112363, 0.26363818715338239, 3.1027338324441205, -0.56736320343889646, 1.1635227288112855, 3.5860411122273406, -7.6902122212575001, 0.71246511678724278],
                             [2.5667544110413525, -5.1725989998974056, -6.0997550618746157, 0.12424522015181244, -1.8085963442531097, 1.5050052773629372, 1.9883177550875641, 2.2193538389640461, -6.8701701360407892, 1.9186947403256851],
                             [3.285979535068003, -5.6471801116979812, -3.4852705016706511, -0.74928935047019407, -5.8128916509266348, 1.0317494641969691, 5.3667297777988265, 4.5487251786009164, -3.6584666079488617, 4.9573276574794889],
                             [-3.4542664960282941, 4.2578192544194255, 1.0165910018590958, 2.0585705890865329, 8.2694296053701262, 1.3270692705410767, -1.2221366461009175, -1.9731708820872043, 4.5334895253537066, -7.5146637950631483],
                             [9.6022635978755613, -3.9227369396560166, -7.0356550747479858, -2.3061637253476097, -7.4254854822146541, -1.028849632837515, 1.4757549634808029, -5.5189070905583799, -7.0906116755751274, -0.059435545104540202]],
                            [[0.81878394993525938, -1.9851320827562491, 0.60952830013421178, 0.4254819187394282, -0.86727720492732319, -1.9004790130799043, 2.2202614306692068, 2.3246311536818096, -0.19511904183401174, 0.42532708819945547],
                             [1.8585327894702413, -0.91888293043786529, -1.5217432051023914, -0.48847374051903603, 0.97923932374363365, -0.1436373043728319, -0.9887408600375549, 1.9331665034985934, -0.19105702303476108, 2.5770301619925298],
                             [2.2993285521708384, 0.98130482103543071, -1.3382721299426246, 0.7443595667617835, 1.407036458873772, -0.39869789163205871, -2.6275588006655517, 0.85416683545467775, -0.67046061795337797, 0.25420706426089024],
                             [-1.3945137987667051, -1.6386346758595207, 1.8739880371396074, 0.21934949753946636, -2.0697023187613408, -1.793224961300087, 0.89567298033268195, 1.2047877076084279, -0.23280471328764743, -0.86907280316520075],
                             [2.8201433044144277, 3.9240859353521866, -0.66463104691321573, 0.5078702269995462, -0.35237404940510914, 1.4425210379908107, -0.83796526130110127, 1.6602489935959506, 0.15949866778074517, 2.9318990739950119],
                             [-0.8558699735061629, -3.9889818518499593, 2.2008248281570344, 0.25657863038649487, -0.16829583584295515, -0.7601712550817965, 0.86424012503531222, -1.0809636137993299, -0.58703702047487982, -0.50980344866286686],
                             [0.37279592544562384, 0.54291397170269307, 0.053970458075696573, -1.6840194270146285, -0.25265771041343782, -0.61250529375380625, 2.2135336968151313, -0.0074636968328674891, 1.3902981979691273, -0.89104741635987283],
                             [3.4074444957061818, 1.9162312406240749, -1.1002775100716768, -0.45307759782824986, -1.4667965819610544, -1.6307045669328442, 0.28042662235136306, 1.9556152320114506, -1.018528405023575, 0.65594360222127834],
                             [0.35043474259321805, -0.8755319633390295, -0.33324196624841951, 1.8355034428001848, 0.80343534638670244, 2.0707969804459294, -1.0207795469952359, -1.9639225731975845, 1.6423272739535009, -0.74189408038699411],
                             [-1.1711817757090111, -2.7492370420980285, 0.37665769847565567, -0.3343391233842038, 1.1668348839787863, -1.5833916099796177, 0.019633033838414166, -1.3236984047465779, -0.38712939649004519, 0.76208521298549214]],
                            [[-1.0239413339200454, 2.6922828046291523, 0.87666516361414593, -1.2183729567546417, -0.065290174959027836, 0.59971165564285667, -0.45754054670261579, -0.28754131163790442, 0.65342219884045072, 0.83186804885535015],
                             [0.68190988604878289, 0.5374305888594062, -1.8897227193047437, -0.90597040518829042, 0.42397732815366296, 0.071489829629309415, -0.63163670305657016, -0.039545264536693631, 0.52658537743714284, -0.9695606979687591],
                             [-0.29923887859215242, 0.95039819771874245, 0.1884953594108707, -0.82253419926676752, 0.71562429558021767, -2.1365997193662274, -1.7810258732923754, -0.33071213614081679, 0.72645260085567076, 0.21713049738013901],
                             [-0.44742250032316594, -1.1320312838061501, -0.26193105248033016, -1.9777611196795775, 1.1071443734163302, -0.46442282464263485, -0.82645075234102827, 1.1844692200647615, 1.0908306214265897, 0.55187966080532047],
                             [-1.9250287135855944, 0.2951164786331395, -0.53561805620584146, -1.9116943721385762, -0.15263182011846671, 0.36990525732359431, -0.51671943925879105, -1.1485021686083337, 0.51385808441933478, 0.62903410769468493],
                             [0.55087894630760181, -0.75155247832971139, 0.12734259830489125, 0.93383574513338807, 0.88935799880860933, 0.50871296592023096, -1.4891495689430911, -0.49955359725792214, 2.1049243045497064, -0.60533602050423529],
                             [2.0933458728219603, 0.22555446298032156, 1.4812687498491655, -0.38859336582720511, -1.3613051777150611, -0.089639831853639121, -0.27586873340891027, -0.85085419194088918, -0.2282229079690051, -0.20833914734917466],
                             [-1.1476709529300142, -2.1454684359922283, -0.23938097824727975, 1.7246556382812694, -1.2158966344584028, 0.19075483992641296, -1.6713710259957599, -0.53886421581949784, 0.33638969662283402, 0.59879772662385011],
                             [1.1476205384794302, -0.14354859085772254, -1.1972067291679316, -0.17850707324902532, 2.0019321445012608, 0.022856387641848372, -0.55104784331942613, -0.39906685411404341, -0.47390005825204029, 1.1961431345956341],
                             [-0.2064022045757461, 1.5041957295715473, -1.6128319884658024, 0.76740068063772549, -1.0757569223771526, -0.12784162228078522, 1.1523253768917976, -0.429001420687115, 0.58185709103328787, 0.27855636509809567]],
                            [[-0.6044325930537704, -0.5045142248940756, 1.419548072354611, -0.77206589083893173, -0.6427968317002144, 1.194739282954129, 0.73194323273042228, 1.1297782875141047, 0.32356617229362056, -0.9818962470100876],
                             [0.51782043355160001, -0.9463850429330305, 0.60962441098575693, -1.3501374654557134, -0.10874175057481297, -1.0286878035923068, -0.46586223929858567, 0.97647053257103988, 1.3707251028929917, -0.66912191171290658],
                             [0.56592169674424209, -0.12984789745281905, -0.78051616213619157, 0.72899290924994276, -0.69794886448248028, 2.4770339950264302, -0.4469722103885827, -0.58935124886374513, -0.70650394214939205, 0.82055448838088829],
                             [0.8793799530249049, -2.2082914142589289, 0.28286552468490572, 0.35425538790633948, 0.54315231538810704, -1.0084955551617898, -0.47107211147866662, -2.4674292324073068, -0.58944616843992681, -1.7646518137236469],
                             [0.34715981828492726, -1.2318379855869146, -1.3498493967940284, -0.14974133610447271, 0.068247046415457036, -1.2951661948061362, 0.018677827028072851, 1.5758690631968666, -0.12868689626272811, 2.1055690190176692],
                             [-0.40901518262292014, -0.73469236178243547, -0.076474944623211139, -0.67978820904376058, -0.27851781536272879, 1.0035640449858509, -0.63456859407010702, 1.4135231754460422, -0.12510403178749763, -1.0624546710204748],
                             [-1.4506350807750972, -0.39933920654813693, -1.1567079022770423, -0.10400327298855687, -0.33080714565159308, -0.57069570792884095, -0.22456963803227697, -0.070140142381779236, 0.80452692667419368, 0.94437507949620692],
                             [-0.45116613692231228, 0.052469227341757393, -0.24932416338042984, 1.4071276433519753, -0.20897726638468875, 0.89858450977400139, -0.77290509122630546, 1.0967436007116547, 0.90141217492000814, 1.420217413860283],
                             [1.0603804566690573, 0.074434464525055727, 0.18640612670109255, -0.1937376640160739, -0.3934331906470061, -0.012011581666804882, 1.1959618563067389, 0.97459279509400987, 0.24538995182211842, -0.87426283084972756],
                             [-0.041834497002008642, -0.157222694221896, 0.23772674106007785, 0.34827857928921879, -1.1188124195237439, -0.68657983366292197, -0.83525221169279962, 0.74112625785767117, 0.3897185569218326, 0.56838687095492202]],
                            [[0.087344598387828959, -0.995964581987548, -0.67269377923711993, 0.14346457219622633, -0.4725344066742948, 0.89221284821258895, 0.12007208644475575, 0.53253075285033591, -0.75205728057237398, -0.6035810375011732],
                             [0.024071745807759282, -0.32685163611056745, -0.66785311851327256, 1.2575538494742311, 1.4383731041123862, -1.3191272403338397, 0.011701016403785625, 1.5888759901097202, 0.13219075954501458, -0.36000686818517652],
                             [-0.77874588876179951, 0.51644828636282214, 0.44938235574257046, -0.44035060258788705, 0.88597458889633063, -0.9932841754040751, -1.2223315837051922, -1.1072641942011594, 0.48548549531617968, -0.064650150403535028],
                             [0.82639871949899368, 0.66803886130810541, 0.94681441850466896, -0.26556279256357374, 0.53152724825060671, 0.46240769440517854, -1.3024237640762164, 0.84463368425938157, 0.94791149518685658, 0.19274758003294046],
                             [-0.05935701171422969, 0.90099547021464199, -0.35221130310157467, 1.4152042780038891, 0.90512323972353537, -0.22394820956150932, 0.067293940302345673, 0.16319216527171945, -1.5510191416087762, 0.015519860086838446],
                             [1.227816173546306, -0.63165430994457239, -0.49360390112265967, 1.3485603731166638, 1.1012962804932465, 0.83141444941367448, 0.39947643313659198, 0.60051232867618032, 1.366852213199488, 0.60459512396919413],
                             [0.76900346018214205, 0.93119189764138488, 0.059035140133785802, 0.27363069055743, -0.41821111238316822, -0.14420131861713112, 0.3074416378021772, -0.95797996330111057, -0.064385530892532072, -1.4024240902833587],
                             [-1.4475945322156178, 1.2975784759815867, -0.10875621258687904, 1.1496298450816802, 0.77489687100337112, 0.12462886975987232, 0.5678105302621792, -0.14149996507224499, -0.65498051346247621, -0.75275421073348359],
                             [-0.88539930411969769, -0.21536676506295799, 0.80889521454964008, 0.23665034895839604, 1.5676583291097923, 0.87627646754832822, 1.6054407156618571, -0.94170999516842169, -0.53063152899067068, 0.60345702741129137],
                             [-0.56054684548575895, -0.1015381575819172, -1.0117920769562458, -0.95537837771738254, 0.77629038555994434, -0.20737616372733148, -0.16932794092131151, 1.0316716719680186, 0.081513884110397866, 0.27473740152761661]],
                            [[0.31149888953362342, -1.1522771317485481, -0.19722140859218548, 1.2034974465481214, 0.65737598001914876, -0.2379241576897427, -0.61822105100630698, -0.088414905432966401, 0.88313439354081802, -0.13934940470573282],
                             [-0.033183490718938474, 0.047179457314868611, -0.47127553427552249, -0.67524893972640221, -0.81166064961606743, -0.93588266203244908, -0.66748146414838871, -0.26588281813514059, -0.49446328807821288, 1.0304916648520979],
                             [-0.90708115277562729, -0.49721516053328413, -0.27172974556887591, -0.64226098806392973, 0.40138925647025808, -0.27847084892731444, -1.4815990716357081, -0.30407202652497256, 1.3217726720227934, 0.024431645167620336],
                             [-0.18902360654718664, -0.24871086621044913, -0.94657371400624901, 0.70223801783967876, -0.36467535528119943, 1.2207170783503132, 0.14342077060873981, 1.2282878019781327, -0.68907998884133337, 0.54427942258357842],
                             [0.6001169396803222, -0.18375426961278285, -0.95379457146511093, -0.88161844937171208, -0.58361847423117497, 0.49724057158483531, 0.60146148708330371, 0.23437464071302921, 1.1363932856120382, -0.40172970701997535],
                             [0.29656777294374081, 0.51835138079665299, -0.13839055563348746, -0.39993553821417005, 0.039251554900250854, -0.2216736687814776, 0.50235342962623764, 1.0713938447242082, 0.44768859251849696, 0.066299234884618335],
                             [-0.48557355624574089, 0.5576998252147306, 0.99362293470191621, 0.2524118054424706, -0.50146598652647167, -0.69762983235978437, 0.65775732081228311, -0.54773889452534152, 0.74802304362339067, 0.77246845369975214],
                             [0.30296588899244697, 0.677896418353932, -0.42318247096071748, -0.27438618978111451, 0.86441307302547088, 0.94073445898507602, -0.36853631710605816, -0.52437752729458953, 0.5149403130993061, 0.35130663813797397],
                             [-0.28249881168498808, -1.1566485562490065, 0.22207470884080427, 0.094368251021294952, 0.4939699985393689, -0.76066409489991305, 0.80382283132214438, 0.095706515865475447, 0.16967325985640305, 0.52765851810116504],
                             [0.64047153368111231, 0.062185156414672038, 0.59831858268715199, -0.56913784989888794, -0.18589534923874249, 1.1485845458676529, -1.0784520589120989, 0.11594123460240456, 0.3674005118561508, 0.5689117274085389]],
                            [[0.36878991353711543, 0.040455553722016813, 0.095481767930630942, 0.17646055546630129, 0.46172191983891869, 0.51103522400375079, 0.53497284901911935, 0.20261268708803468, -0.99099289985627959, 0.24574809482602594],
                             [0.15497181259545489, 0.15895202997042343, 1.220948294534699, 0.08521124726837917, -0.01188889789208533, 0.4156251691978049, 0.38487789824584201, -0.61686027223132878, 0.11819402683526828, -0.061068311667572081],
                             [-0.70553082344194329, 0.72797264464623646, 0.028350430749995881, 0.69006956212565806, 0.041921485473769809, -0.33413427102477611, -0.30792672202809046, -0.12054316501224255, -0.46508365487226744, -0.14608478563728669],
                             [-0.95925177099769665, -0.54553039337992626, -0.40556872319745285, 0.089969304699383759, 0.43705131792072893, 0.50677013428821616, 0.071289654035754671, -0.067327447130137552, -0.30694011224139617, -0.72174130614678056],
                             [-0.92868672252323747, -0.032281212168666529, 0.28324542362370791, -0.66040747928184773, -0.47002670465144136, -0.25531812257260411, 0.78394308212002795, 0.22026968966433116, -0.14440792010666345, 0.0085950486895060019],
                             [0.011908671394410993, 0.048953554822365145, 0.27030212326899788, 0.25044273787990728, -0.74438281367110182, 0.58215636756120615, -0.36478169658316462, 0.04822901582931953, -0.19481730542950668, 0.25770032828802425],
                             [0.47350870005958756, -1.0730508808349453, 0.067096002496290191, 0.72107678356261906, -0.3495804875136429, -0.61458648235131064, 0.19055180486270398, 0.030443972755080928, -0.029902586696480049, 0.45769378051349463],
                             [-0.40726617048560121, -0.084418318466475739, 0.088998128011218258, -0.19069096224290194, 0.43334401412714108, -0.22811439889792851, -0.63381155097947162, -0.47723423891806649, -0.54383222839442258, 0.90527115547267867],
                             [-0.32004043883541688, 0.15512622310996776, 0.65932096249053951, 0.36507996300449264, 0.16563466083557798, 0.0068464445137369906, -0.24380400579977118, 1.3698564509723636, 0.48127800786158137, -0.15523657325254447],
                             [0.37893778302516629, 0.050696143708411204, 0.67590262527780087, -0.60254291420017192, -0.40917675621170968, -0.43159115739191556, -0.64835252940961052, 0.14922645929329054, -0.87034059132608532, -0.92075958066303543]],
                            [[-0.23413971348655205, -0.89339823220965198, 0.47120007203553183, -0.34838308349323527, 0.011854429763079785, 0.015001862487775828, -0.0030935370229516895, 0.1061379150724272, -0.087593494873833583, 0.83647687802850867],
                             [-0.53442734935540881, 0.012384206166026944, 0.081224077760503027, -0.069124986647627507, -0.012764933293626296, 0.85068947941224349, 1.0821247869082635, -0.083278713789558617, -0.18242906576681234, -0.48681746644694485],
                             [-0.1298742332228692, -0.31610551940280684, 0.3071027905216866, -0.0505586317882094, -0.18076286890949986, -0.72074405031826316, 0.29186632381785471, -0.81421188427740421, -0.28403602942907974, -0.40423131634623055],
                             [-0.63665361344332005, 0.77909488692558615, 0.27515184504918577, 0.53153414173072844, 0.18095495843575116, -0.11575520990957451, 0.093383050341770163, -0.1563329553534617, -0.23574287111470377, 0.92243643875323078],
                             [-0.56189191457189847, -0.10854733315215492, -1.1473203556849412, -0.0061946482848579121, 0.42813373049329895, -0.52837796799115067, 0.57840392360361137, 0.54782969701969986, -0.32808803164823652, 0.32787896561655894],
                             [-0.51917434223526893, 0.0020687186007388517, -0.32991931370727151, -0.30652758209498948, -0.12259099751614497, 0.40137817744894255, -0.40323992009725235, -0.35132813282490832, -0.88216502577701705, -0.23630989290333501],
                             [0.15871647780853998, -0.31855414495587187, -0.29754409351360345, 0.32723550187346961, 0.9158205101070378, 0.5686422184356007, -0.51644689838698565, -0.89818962869336327, 0.4589746781097282, -0.031789907687317626],
                             [0.23335451526458145, 0.41042880230202383, 0.40322457567798081, -0.93749086482305433, 0.45432154113815854, -0.14439008701955264, 0.16948581709604002, -0.28262147757453315, 0.26967848907179487, -0.10769345511073837],
                             [-0.35290100045844308, -0.01260901697151446, -0.72382000803931845, -0.020411765715578276, -0.79305655048262003, 0.028052677343053743, -0.04380809905315905, -0.42795156084246799, 0.60823559580681641, 0.16954939955085399],
                             [-0.95994638861989401, 0.15977994822106617, 0.12812742994228726, 0.16089493588030368, 0.25192132597506217, -0.14878907299909722, -0.61066477731208058, 0.49088181978165929, 0.061034207285156211, -0.54029069688833775]]])

    matrices30D = np.array([[[8.8830466010379894, -10.085100966925914, 1.6836986468730037, 10.866838640666804, -7.6219058272978799, 4.7439142669286829, -6.7413495853934622, 6.362909252198464, 7.7249800157493471, 3.9963420491053454, 14.840744598161805, 7.0456519043931225, 14.671639018301136, 13.398508373793883, 20.318918089834398, -5.6807241597986167, 3.9688407362252089, -6.2762923284501628, -0.077619772329011183, 13.889486608032174, -10.430195376351943, 16.252788543193777, 5.207907519518101, -6.9410573542688727, 2.1696996473401642, -5.4337860340067428, -3.3226577711845047, -10.251016548320923, -2.9602538252502386, -0.55823161366103313],
                             [3.2061500430373453, 7.0394180463546245, 6.5689987725112537, 1.7495782759780021, -6.5072787114592776, -1.6502428381403447, -2.549706544305455, -1.6819267527157273, 6.6790416051714425, 0.35558934313444485, -2.2506002801807297, -2.9294150589334995, 7.9052753518821284, 3.2838062651777822, 0.8397572995082272, 8.2599237666758363, 9.0506597489080143, -3.2985074881524588, -5.3643819855548944, 3.986261085095792, 6.9466562528457301, 4.2440781180966951, -1.4407761263717471, 0.46088071659919616, -0.83353425697971328, 6.7565168827691977, -10.605705843560074, -1.4860317227271642, 4.0564365652724712, 2.1451831010350917],
                             [-0.37418284672644658, 4.8672772291954001, 14.908140342279983, -9.6897170412784668, -6.6413109251441185, -3.1020272275966034, -5.0325185519986055, -11.67250155891292, -3.8627044832606146, 9.2164285421943504, 13.04677495864285, 2.6575980359114881, -7.1775767864700803, -0.8903959827999951, 3.3480832042010271, -0.50682022293413209, 7.6878108760671333, 11.633429957101837, -7.5806112047074965, 0.74803073389945274, -10.691053544205973, 5.4132512558236581, -3.7996588442172894, 12.093766248772145, -13.099837709250961, -10.377892309226565, -6.2668483367604182, -3.2508551379450905, -1.3449643847475958, 5.3806559535995611],
                             [-5.4349596312378932, -1.8345638190273963, 4.5298484868732887, 6.086495217356501, -1.7683855484390003, -3.8657676964986898, -8.0216780822104532, 7.6408840022291766, -3.0523672920432658, -3.1005667674198598, -12.562441254239333, -15.125833420092773, 10.09177560253957, -14.221021408614202, 4.9927159181721787, -13.14826962531756, 8.8359861271742002, 2.3898940828610726, -5.6172204171411284, -2.8968343356742152, 0.79466381795353636, -1.8909541626368256, 2.2944853268285512, 15.069409515977187, 3.6919372942216406, -5.1866487529159331, -5.5104042802200928, -6.9148794132357256, -14.605246905629874, -2.9805148635213685],
                             [-1.978294786778716, -2.3991135455764065, -6.7755894250784756, 10.691572372952107, 3.0140046583632185, -3.5776710659660691, 9.7873329487277569, -1.8943127391154677, -1.626342491739373, -0.90939545309460568, -2.1592663056951751, 4.7506935230687741, -10.360722935901649, -15.175787353418066, 2.6899341832379866, -2.7294612519252706, -10.290936920939451, 4.5786115246426169, 3.7138781924723046, -11.241714960501055, -1.7235351971676465, -6.2360263667085594, 8.7341386162213173, -2.6226945705911171, 7.2560983522622831, 2.5693687276487522, -8.6485043206820365, -4.0507260898526551, 3.1739216497706493, 3.3596789633585602],
                             [-1.2622924350194453, 9.9785004595375657, -2.1285677088138524, -0.039935696518725243, 3.0838962964546095, 4.4374687059421545, 0.087908241484912414, 1.2005556929117835, 5.3011702189719072, 0.32857263832986805, -1.2006988710176139, -3.6993090824191874, 8.7786979899145923, 8.8954622403876726, -0.89803044231177109, 2.7550074067893338, 4.4628950908086269, -4.6000892039762453, 3.0948183559918192, 2.535526712864987, 8.142317102344478, -0.33106612213250475, 2.9232418487458642, -0.78870461129597569, 2.7161385255778705, 4.9237119063520369, -5.2668660355141936, 2.4716123568887114, -0.81920850827007552, -6.3476339603070491],
                             [1.574093833341633, 5.5810357172601259, -6.3291371448174303, 4.2830441594822259, 1.5877651687057182, 1.9399860104821098, -1.0748647226959287, -7.116808077120198, 14.676992278033257, -1.7644659769743907, -4.0715545832184983, 11.973144961816013, 6.1222853434104136, 4.9038612697809558, 3.8835005991477445, 7.220748284331945, 1.8016404689232013, -2.6661760825710035, 1.5256511394079055, 1.8829137890858343, 9.4563729282770499, 1.6236167963073485, 8.4518139199908049, -10.182455805485636, 0.52205199201150121, -4.8734065101852506, -6.7714856318994014, 1.3989992320701858, 3.4655650046619653, -5.7192167636978706],
                             [12.931598080295986, -0.058000533889135841, 7.5583589705327316, 6.0578901261617801, -7.0390602046710979, -3.2847494810099427, -0.66383122237031955, 3.94287693187455, 5.3949157515056854, -1.3588533614920106, -5.1101776666425076, -2.5195160106200358, 1.7066918841997722, 10.674819548286262, -2.8075842392405232, -0.4900755720610781, 9.7405422628355982, -9.9273566958603165, 7.7985052722520907, -9.1859400398081004, 6.4378121777141342, 2.8160079773033115, 0.38993433669030431, -3.8202570421782038, 11.669342226490748, 6.7213001668869605, -4.8179644021729029, 2.3222114471736388, -10.822568970075555, 1.6202582511578254],
                             [6.6770802692639144, 0.3496002925555981, 7.2803846514412678, -7.9911376897909667, 9.3195607433976395, -4.536290167223842, -13.579113101778589, 14.13496686565249, -14.979117008506259, 2.5784685654250841, -11.061162105671693, 9.340693610244541, -4.9610133829635075, 5.2684582742170072, 1.875626756434349, -3.7661251981802062, 15.564864913011482, -4.0646409553241991, -0.98061755829936881, -12.482600117947124, -11.28146477813489, 0.31982622546299233, 5.0187405334764605, -1.3669232622606295, 1.4377281678887361, -9.4786047743391464, 3.5699197256144037, 1.2777925391089302, 7.8793094498757519, -7.3842280044568813],
                             [16.793412007531593, -8.9880256384012593, -0.45383659276756649, 0.72537489986425852, -5.837994558971765, 2.8247082230201048, 5.892451488864622, 1.2194632806442236, 7.6344227551007799, 8.4274919843336509, 15.592692530504747, 7.1415754180241118, 12.726613462476589, 11.650086577036255, 9.5476656629362893, -9.9323313844888972, -2.7340490031586362, -7.4584890356643125, 12.83557282129018, 5.4132755337903458, -14.140940078430534, 7.0319975218090764, -2.2600254690912274, 8.9978737784971798, 9.7817115164080839, 6.3598594889755482, -3.4209727122997746, 2.3735624184060136, -2.7728615361353479, 1.9525362347138548],
                             [-5.7342835130181724, -0.71667367989218655, 15.837446813606306, -13.758960687496145, 8.6091249118606505, -11.287537749948292, -3.539931431276651, -2.7028758188928648, -13.043823311170465, 7.5620441333615807, -3.3306235320134783, -1.451440001180123, -13.358581723135091, -21.847383080889578, -1.5838033443625101, -4.6360831976864416, -4.7855876305505891, 1.4772460560906486, -14.639257391775454, -12.758513350292434, -23.959992376170725, 7.5169517307212343, 2.3638857727089344, -3.894345918925743, -28.333896811275359, -14.133134034235026, 3.8222061124311035, 0.45885508304319361, 8.8037818098402543, 9.1358101121862223],
                             [12.221701123054261, -1.6426831248627287, 9.3161681992530205, -14.770935075542784, -0.65723713247665128, -1.1572966554036463, -1.0226215022600362, -4.3175310586789246, 13.54925312786523, 2.6815967205784639, 0.31814435090512139, -1.8480548185430816, 5.8354482868957644, 13.190246090938286, 5.8851231255638492, -3.5575246146842576, 6.3694527972786403, -12.506737513640115, 0.43349907663228698, 6.6040301130732164, 2.9931230052853182, 15.4911511850511, -9.2311048841914598, 3.3123838398248311, -14.419506426811825, -0.071091761338738096, -1.9209313539114756, 15.773505658755411, 6.591113670053085, -0.24984362550170136],
                             [8.8860994843129255, -10.923175072873207, -2.0979602794932783, -0.61173308444660601, -3.2084753662822454, -3.6193742194102354, 1.9677943748777538, 4.6437826229035535, 1.9323272385537704, -0.50868203541409351, -0.94166032297716395, 13.431352292566704, -8.5635866811749661, 2.2695414843470028, -1.4375181934414103, -3.1941582906728261, -0.20707107688578352, -2.390914709967487, 11.608021406197022, -6.5114752018210087, -5.9769688843872419, -0.94808728170455403, -3.1341069111484838, -6.6659452625143398, 14.10454581816731, -7.3817730963052997, 2.5999244706449618, 11.654949888557903, -7.6995454672377051, -2.274915837929925],
                             [-0.71672592072810248, -5.9281823421202162, -8.7333138580584446, 6.1709886569190093, 14.557598221696459, 2.371961168068065, 5.5770979279696293, -2.6025288104559601, -8.9416892225667013, -4.9592595715863981, 2.9385200013115407, 3.8681331825930112, -13.372355562544566, -0.28404874665721558, -2.6117542653887411, 7.760806727844523, -13.190720719893399, 10.43588793984993, -2.9368245220177114, 1.6202688831888803, 4.888867026287377, -5.8062552604178181, 0.94052119145637569, -10.518664062875573, -7.755669992569139, -3.6676467880891219, 15.094072213883445, -11.007446079911304, 8.3557167749514729, 2.9620947523379497],
                             [5.3343488419027194, -8.4024042166682058, -2.649183618710675, -5.3817386298167653, 7.5229217110424038, -6.8911230275087521, 2.5963277464125341, -9.6481220103721537, -4.5924046807044006, -0.25318230982075068, 1.2703254856472552, 0.28271132997061166, -10.945643765785427, 2.3684793741133587, 10.600950504553106, -3.1905528422630396, -3.0990910943839394, 2.8113737669841923, -1.7590891149173302, -0.82030049743993771, 9.9105256662538981, 5.5590042927886785, 4.6157310486052046, 2.3376103447504777, -11.142774466445616, -12.824158507410637, 2.3797804926358737, 10.401366104276761, 3.8689925781733026, -4.7302326541229807],
                             [12.676087905010757, 7.7762126169260517, 5.5589400301279337, -2.4402959546349026, -20.141216119231753, 8.5355084420514746, 6.9166782115048511, -5.1840858373594241, 6.1618899844349606, 5.3427312151680493, 22.56263644384661, 0.25294855663472549, -0.4070846503667741, 21.975317741003629, 12.674479590530966, -1.9257415152328128, 17.056169983595034, 1.2844029109699764, -3.0681903895184179, 5.462463757536514, 15.303370968045968, 5.4043845274990687, -3.9247351206233119, 10.960662164230634, 0.25561454063613809, 12.14990387855501, -20.005225016509527, -3.7264281264290555, 11.02704256344172, 6.6074135937170384],
                             [-6.0038030595949197, -9.9858689947416828, -4.4349811415547586, -1.8138824855381461, -8.1422254271375483, 3.8354988820688289, -10.552911779223255, 2.0725473624583879, 3.321351641578671, -5.8111814819915928, 6.8270835961774319, 7.6893324692775309, 0.37608266059226003, -9.7909298382992294, 3.5561161994996962, 0.88818105862653296, 0.47516487074418567, 1.5334935930834253, -9.1287938493012106, 18.103757726454017, -18.254323065748288, 9.4101746123516268, -10.462453535579556, -3.5505813048652004, -12.934501205908649, -17.708602293215861, 5.0636997325436575, 2.5905942036227536, -7.2032839804475275, -5.7074963954630071],
                             [0.28967628454892325, -3.7347737988290564, 14.126987709716175, -6.6025698571118019, -10.904306347103805, -4.3689381434585881, -1.8656747444762547, -0.54370020498618499, 2.933598056024437, 5.3543416363934702, 13.834407858316322, 0.83092712984836292, 0.48214848765372453, 3.2737814913745336, 1.5978555339473257, -0.11120095060864976, 0.071021696628078335, 4.8364854909082835, 3.7147902750277022, 6.5112979107106055, 0.3656603862285267, 7.2845308490125156, -5.7405921317879498, 1.3016474818839767, 7.108338715434769, -4.4523699832542984, -2.3688282655241766, 3.7304629998017083, -14.947640339619477, 10.843238542829667],
                             [-5.7010380151925428, -2.0827177841586182, -8.6072343774778997, 5.1746539732039416, -1.6576440023509313, 3.6863094147245481, 11.467299158164272, -12.463096813895906, -6.1720297906868726, 3.1061391283276012, 11.47082686978713, 1.345396896866915, -6.7864094268186843, 1.0636357360489934, 0.4636745725303939, 0.35274207136371416, -3.568702455629928, 7.1648478706253087, 3.4232788502964282, 2.1163187419821772, 1.0547221904419808, -1.25689437839415, 9.7735829035393849, -1.9685532635558807, -0.58067708158585951, 0.37705057049951318, -2.8043255464094416, 0.82317043030517756, 1.8485675618716524, -5.5286388748615725],
                             [0.15632310761234464, 7.6394958710935112, 0.28211466478709568, -0.064230409356358084, 13.088245087685666, -0.77477717417233027, 2.40564711478621, 4.3227104194019201, -10.134869986231097, 0.49990482269761188, 4.7299245031481876, 1.9857758122271933, -8.1078993857909811, 4.4304357151363885, 13.272737674758586, 6.4616854944055593, 5.0987840798569364, 2.4571959198591209, 3.6729404620343558, 1.4662052583875205, 1.4386069493808364, 6.2438418942096874, 12.913286949377694, -2.240827268975913, -2.827598441443107, -7.9017507667994877, -5.5921477364826018, -0.020910891177732135, 8.8331989473591772, -0.30619539268441348],
                             [-0.2266123323614192, 5.1749823931193051, 9.4886197464637121, -20.866878538307081, 8.2004111896374052, -5.8541439998338491, -2.7116939165286822, 0.73883825602400144, -5.3954743170010477, 11.887884643779628, 0.082103819962573737, 9.1534110418372432, -4.0333252353259041, -0.32805130767055124, -0.035147406375210438, -1.2177582537263025, -2.3758349280407414, -4.2100509490229392, 1.2530389035112059, -8.9671857948942915, -19.282880725123114, 4.9482484362040147, 5.2850740452322125, -7.7080560917354903, -11.22819356232108, -5.3590502634065276, 3.1317207191652341, 11.33219290098455, 15.886819513418828, 2.3689347731115],
                             [-7.998834552204503, -4.6244957500386832, 18.777649534782569, -1.3969662387397817, -2.0795745437786599, -3.2105636168472058, -3.7081853461339978, 9.3468359297703465, -7.0834676241643466, 5.7999122240558449, -7.718839895423641, -11.817964675635077, 7.5355273027792951, 5.0049583579686789, -12.626017884835875, -14.96890109894289, 7.3542635767948923, 1.7312452022710152, 6.9424736852131872, -10.655881429398841, -10.775447791996919, -0.52951552437327254, 19.009704680003367, -5.2158617792334736, 1.1194782060322512, -5.350897916093758, -9.7547364783998951, 0.62999954225217825, -8.6463744568373606, -6.8043581197455616],
                             [7.4819089147952722, -13.96515347060329, -5.064553517046579, -10.149276077732242, -4.4325306646149398, -1.9771781186027488, 5.6087767516376807, 1.6053817178137264, -1.2381559417557786, 8.1695912487488478, 0.87146091319091123, 4.882607812722993, -2.3297832920796742, 3.3627236225654848, -3.6439089120819959, -12.176780069503289, -10.118922644259031, -4.3964266096811446, 8.3470139486327533, -9.1008540916543534, -3.8751740264701828, -4.4358771259439331, 0.27129705152990624, -1.6467620999875128, 12.304280706902839, 7.0009799423288444, 6.7812152755449961, 11.462327429110482, 4.7110163285622999, -3.9251795720026417],
                             [1.1640472860184414, 0.59824217866987883, -18.124547543985454, 18.924110158919319, -6.2769058461332694, 7.2980411969512158, 3.1707218749820627, -0.91169319066191701, -0.37961734468743391, -8.5857012197876657, -1.7092356503291437, 0.33276730440726121, -1.485049903130202, -2.0168353982486167, -6.7803463515204356, 6.4918242533699075, 4.3633264946706003, -3.3259728937502286, 7.461062186481664, -2.7600033072429055, -3.0635271478813415, -5.6629107924249809, 0.15087232880112778, -6.2763207237314553, 6.1248085631816549, 0.80800940696469536, 3.3469527237869534, -1.0600919263697717, -11.392147346147723, -10.378922560324018],
                             [8.5592754264150983, -12.951411513473479, -5.5202453871638912, 7.0780636070795442, 13.287623091155252, 1.0089484158802788, 4.7119122330436927, 8.8793384483245834, 0.7654304751689549, -13.084872742131957, -18.542297787267703, -3.8518105477370037, -1.905414662505025, 10.151335724817356, -14.999724104457911, -4.2948783702303395, 5.1148941534583408, 0.24376431191222059, 13.820666634722995, -6.0591809773535594, 6.7508909628352232, -2.584794311954699, 10.400886939000976, -3.5285140353488265, 5.5051981861701176, 2.5719109639122375, 0.73208834471022288, 6.3540738791181681, 5.1545241041779288, -22.685819416334819],
                             [-2.542886447427096, -10.972830117325072, 3.9706956326162488, 1.2564929705785723, -9.6634193916474924, -3.1590817866040757, 1.5805935414193648, 6.3083412286361913, -15.277950865696555, -3.9856156823171336, 8.5145581692961425, -7.4565257527269608, -9.0674669198464795, -0.38056338185387634, -1.840869806117039, -0.21055264718057209, 3.3390184456542595, 5.0904823867681657, 0.4876887470042422, -2.5167841226233687, -5.6782830937566686, 5.0798430895195779, -1.2661195420155618, -0.46416263215680892, 1.9392178595673091, -1.5676039259457137, 2.7821848819360535, 1.6073046989579305, -11.259279271774123, 1.2312235454360416],
                             [4.123244156692806, -0.81248486864190972, 0.23596919635996111, 5.9036123247755592, -2.2553379911683438, 0.10210056927537009, -2.1991128366177044, 9.1911870188393152, -2.0806667765977873, -2.7855602745264072, -8.1312932810800991, -7.9897378999711215, -0.77256992692283344, 7.2635247537427885, -1.1488296962327791, -3.2300172796560482, 3.9356148866573295, -7.9824865256888291, -6.5572489601099493, -7.9970728761654719, 13.408479209942108, -1.0719372535900622, 0.34762355129835698, -10.969363561674674, 1.929296064661248, 8.1720947654623934, -0.31137081860861282, -3.1410493237409209, 5.5353646655131703, 2.7550540410827873],
                             [-4.6465954371388998, 5.0963447050787796, 5.8039421818574555, -4.2377340623598618, -14.446360609638637, -1.1036772773418617, 4.2750462967139109, 2.1315386329545136, -9.9642859370854922, 1.2863764763827616, 2.7715158507454229, -3.2761370592516612, -8.3004642756896221, 0.56350160877171884, -0.73318257930445285, 0.77454246628543055, 10.188098136569945, 0.54209583012286888, -0.35923638119571877, -4.8708025324626778, 7.761071235036697, -0.10193198833722694, 7.2377915254510459, -3.1228962949820751, 7.0131767243040457, 3.4543984009624058, -14.046170699500463, 5.108109974320767, 2.6683262683624593, -0.79935136337935031],
                             [-16.132741458304327, -0.38146834594811785, 8.646308714835655, -9.7421834316047899, -4.1092616426811848, 0.48679959628519054, -4.0913293994165603, 13.164957738843601, -15.199921511291894, 5.6969684572260944, 4.379629360179484, -1.9800654071044665, -6.9048327445899709, -8.6573377665878493, 3.7608182770132306, -6.7912528664326226, -1.284648776061327, 3.5413888223564545, -4.1079450273792206, 2.3803587289263164, -11.690170727323979, 1.2150071919035743, 8.7528321342882922, -8.6915335613213927, 1.3775231663060841, -9.1828515845292245, -5.4735879495768485, 7.3226749224747021, 6.8684384285407774, -0.078144277865437983],
                             [0.72082821856051238, -8.9425147956020581, -4.3440301956507543, 8.6180781183335888, 15.819173428270613, -13.885164796219652, -5.0984228941537548, 4.5521790924751429, -5.296799693599417, -8.5423123516885013, -22.069201742211028, 0.95240128040276595, 2.952300827376884, -7.2829142490897247, -6.2906204311150731, 9.7204046337440371, 5.3825743762288223, -0.52516629026108896, 7.3651325827012393, -9.3709000922383598, 2.3403099689516682, -3.0090330199994182, 8.3290025287912126, -1.8523699544125347, 21.588812448512176, -2.6844880086760496, 7.1954265681151846, 2.5768284010159714, -8.3148093754172798, -11.995375287129672]],
                            [[-2.0978780651415643, 6.545823509759412, -3.7103267234321393, 2.1028992450742408, 3.5291597574294169, -3.0595518851893453, 6.1270746226790855, -1.069941268310312, 4.1968147902811017, 5.5630954681943265, 1.3265374921390818, 0.6861224902420141, -6.3050070190578866, 5.4445023010250004, 7.8334113928968758, 5.0149146285586692, 2.0420032163566271, -3.1870662647590171, 7.4980362507927403, -11.722598128899916, -2.8300668427313567, -6.4425208347505709, 6.6232624631397767, -1.2588808208493816, 2.278285067621332, -1.8659039330823552, 11.614071557421788, 0.26739278125589971, 4.0967406169031273, 2.0820219229187855],
                             [-1.6092239842097802, 0.14695459927331989, -3.3789339966899012, -4.6463972765164367, 1.2883640698457293, -2.6543697607378149, -1.6589966512850058, 2.12114249395034, 2.467622362160379, 3.7990970621685687, 1.1735638280940721, 3.2587750356080507, 3.2964849402337082, 3.3173772274663649, 0.45495864435323696, -1.5393554513000565, -3.2421369133300764, -2.0381100298876986, 4.1917085653509343, 5.1799380925423471, 1.1660110328172824, -0.8082675243040951, 1.551909483235691, -0.84160948147652115, 3.2628118662889714, 0.39355262028055432, -3.4885558766133324, -3.0692856348663149, 0.18642937396815151, 1.4419069646245002],
                             [-5.4168076199047723, -1.577997172338633, 3.2489875281011344, 2.6700448721081163, -2.288877343824975, -5.1549034113601282, 2.8097474111418599, -3.2240385607947926, -3.2693990250791254, 5.955214807689325, 2.4560657815660996, -4.6147991567033584, -3.666632495440989, 0.99739707457807358, -2.6304400665941658, 1.4764718592487842, 1.1836458150623188, 1.2177604436714604, 4.6584590792863301, 3.7897159529340887, -2.0840957019264725, -5.6528941866065621, -2.0859893705147448, -3.0461889309217014, 1.0409680605639995, -5.8808624694977878, 5.4359731441237127, 2.0347784210447455, 0.62571809292898473, 2.0403705110139985],
                             [-6.3285960976883784, -9.1697777927208435, -3.8294877284554643, 3.3353195477373903, -4.3596532785525497, -1.7679120706904332, -3.9211306501516616, 0.72795709920195328, -7.8295585740788862, 4.3955441403249749, -6.7380192809941608, -0.59367598819197132, 4.5306756145654807, -7.2905531046262491, -1.1138642111095827, 0.23434676377141128, -5.6816493973188402, -3.5011438019037899, -3.3281201031224548, 6.0385286910755083, -1.6721502469626006, -6.2833953357485326, -1.2592913926422264, -0.99841754780417891, -3.3191560811722924, -2.4120506652689904, -6.6209460574418681, 3.5196632620796966, 1.1242303109279805, 3.9011336089061492],
                             [-0.45329515699405937, 0.8967257159312465, -4.1882846219403653, -5.5006452607649319, -1.0480259323879646, -0.58491972285772853, -4.6715434213832889, 0.93030703831951211, 0.85965575694000329, 0.84788656215231128, 6.0224818269860183, 0.013390468042895065, -0.82362324983186519, -3.1322540686194245, 8.3717254366871465, -3.6755958245442475, 6.341181640070122, 4.2599610926629783, 2.5307935417246608, -3.9992922049685045, -6.3971830591292607, 4.665627650250598, -2.4237072836808586, 2.1861443309551665, -3.3353245452040672, 3.3365641729662778, -2.0246288612197341, -3.5931273190041364, 4.7080387582646583, -1.2158487991637523],
                             [1.4755397961278129, 0.45232858963288997, 3.926748014434569, -4.4365465318961546, -1.5389082864650179, 3.6596265462057853, 5.6361989279007014, 1.3453357745995471, 3.5134118350134216, -2.0815725377195693, 3.8212778461243619, -1.2769985299409139, 6.8551757143119456, -0.50021534897712439, 6.9928482519533821, -2.1512699422153894, 3.297848303223212, 3.6782335371769346, 1.013875576588313, -2.0163731757277921, 4.1088348851320173, 2.3284607989787838, 0.94357253181068867, 4.8243917581501474, 6.2372280571893564, 2.9894452395324258, 7.3506968205784879, 2.2578090562887625, 1.7394297358371411, -0.24412551456621867],
                             [-0.80343592802863517, 0.57928445792788008, 0.45105338408447837, -0.59636926114535593, -5.1641516585217619, 1.302091154728453, -0.40667062437637913, 2.4757403598337868, -2.2448548427656783, -0.63659656102956585, 1.626250971949506, 0.51753473492870217, -0.10075853740391572, 0.12629600229485863, -3.0685101454590233, -7.5626955496818002, 2.4241691930094911, 2.4079320927201069, -1.9113974449036308, -2.2725252659706179, 1.615652607020027, -3.3679193368925224, -1.5838981009331006, 1.5860490807906125, -0.17673482549631947, -4.6580644203133472, 0.5815928374747259, -2.2924437967371358, 2.5858160631086853, -0.9401674015962973],
                             [-4.0600943836181127, 2.2403801393853975, 2.6373277909579684, 2.1833304179007342, 0.17819695554008103, 0.32082389256190541, 0.46768946703085829, 0.4369486413440884, 3.6762996456381614, 1.1744216498976245, -0.37739228367605182, 1.117386090830196, 2.7724222172258193, -0.74787248703059794, 3.2038391426683193, 3.2418725581406473, 5.1472334235265924, -3.5475181501367512, 4.5250017953121215, 1.8975584188748023, -1.3992190304644287, -4.6100838591445763, -6.1653949211561123, -0.92760220645050984, -6.2543934665173788, -1.3018904411111789, 1.1028415503466813, 9.3673022791167, 0.17679054723552104, 2.1183493911846294],
                             [-0.93537972047356455, 4.8289476239618585, 0.21299578413497566, -0.87542494984769548, 3.6184048528475223, 2.8048008150210446, -3.7582089470589404, 1.8383816021601742, 1.055369769278653, 2.919275980769183, -4.6807619137290484, 1.4204914968988291, 1.7168377536398156, -3.5670466642795668, 1.2795444704322212, 4.2954894570872231, 1.7289352872232937, 2.4258631136837172, 6.7277122947755537, 2.3393146365814617, 0.18316409551623997, -3.8263244262421479, 2.4788647437842659, -0.22704360520632294, 1.2315629075136576, -0.37468864295343762, -6.9920226818168754, -2.5177060373400755, 3.9913920431548653, -0.25811512689578747],
                             [0.39258001974349499, -2.1205357580955067, 4.319259054959856, 2.202896598089882, 7.1153059976700881, 3.6951286936619212, 6.0225447908991097, -2.2147677221574984, 2.9504656677463772, -3.1454326096279988, -4.3633226901260578, -2.3267429121437533, -4.4815461150809943, -1.0456962264807581, -1.6056888031653811, 9.6121322849884603, -0.069363745879888361, -0.61479279498856942, -0.85379628596368384, 2.4247603262768829, -2.2463045931161716, 5.2093268592959854, 4.2158788536013079, -3.1767178259639195, -12.764279165235752, -1.8131503330921213, 1.8359697421287082, 0.068247169081336878, -1.3736117717621914, 0.57836140895519161],
                             [1.4996099264806062, 6.7377649358852665, -3.3489823166935859, -2.1135045096087679, -1.2189204574720174, 3.5075228687601094, -1.8819802888045318, 4.7409724880740836, -0.74080347203493524, 0.22957722853767626, 0.36379985028387285, -0.571950590450649, 1.6893324578622146, -4.4963955489579952, -2.7208139172468973, 4.9576148962148689, -4.4820884288269243, -2.5576159490496573, -1.4473967121688012, 4.3101616880355307, 8.219185943226675, -4.9584862331473207, 4.2562775364358787, -0.76901769846234336, 5.136245443152526, -0.81264036842806364, 2.91668199228608, -0.32802109483700048, 1.176973600319742, -0.25122718744333861],
                             [-2.4883295222740505, 0.70028724946760079, 1.3875592695247483, -1.6448750351871853, 1.4921742623352492, -1.1590153950712403, 1.9892895815502838, -5.2424558181206828, 7.7355551609490174, 6.5456285714528626, 7.9521306979870285, 3.7232825561966889, -1.2816517421445663, 2.6290389831242775, -2.4231365089575827, -0.23620101914572372, -0.28617744579085508, -1.3385190495641583, -1.2501052505514008, 0.12794264885597062, 0.91844078102469817, -2.6189668749602957, -2.8415898166136317, -1.1264797215005644, -4.4759524919995277, 2.3218723827783943, -2.3945686787165661, -0.93566117891663825, -2.128425246499134, -1.970514727011321],
                             [4.0477430667270662, -0.39442572139834514, -2.2570852579557705, 4.6423649398909284, 2.8782318700705893, -3.799501388309924, 1.4022000211657508, -8.4117433033696845, 0.76048284760621032, 4.8049519186337415, 3.7206862239492997, -0.036185452123722039, -5.8349751764465809, -0.46641799931962874, 2.3529756866877602, -2.181608905941339, 1.4861177410415294, 3.4288265068439143, -0.87438360868788279, -0.12060798132719333, -2.7308696994728079, 2.6023026274190011, -7.34371936064609, 3.0536954952392334, -4.4629234336218495, 3.2050565218726983, -5.4696136207591239, -5.1507787742286029, -4.6595213848750268, -2.1165882225677497],
                             [-4.3413803822887909, -1.6532594557329532, 4.0274894150569001, -3.9368200784063294, 1.3746732107331681, -3.6020370908356103, 1.039814175915007, 1.9375209039219103, -0.061412339714139008, -6.6645646329937582, 2.1243365340272593, 2.0236145866902411, 2.8876701054246268, 0.08678863020396646, -4.5508200443239373, -0.15289525448205854, -1.0581971743735719, -2.9774848866320514, -0.84979092221027552, -6.2656357452861444, -2.5156417609545634, -0.1259666365817862, -0.12691359569069133, -2.2068308111559025, 3.9629893690089131, -3.8415351570356013, 2.992212998930627, -0.95585131888778596, -2.2277937688580423, 1.4898965988716482],
                             [-4.2940516608163284, -5.0455294647118913, 0.82154520838910794, -4.3056977621094363, -5.3185459720053396, 1.187335283969186, 0.55756082382411232, -7.5290670992577491, -5.078864640164765, -2.4999079896125647, 3.8431880008551995, -1.805864055999711, 3.1031061749174396, -2.099823622524656, 4.4793615948050753, -2.5052052083872911, -4.3246306962893755, 3.8493044977675792, -3.6615476438837424, 3.3382394271345253, 0.043827295731600102, -2.4411744436655671, -0.20343169696631527, -2.2346081857111249, 0.77842921208238891, 0.46441040780922715, 1.0304307696398263, -2.8976130995241509, -4.474761607028829, -0.67272128713691104],
                             [-1.4945928667671946, 6.7448920150790599, -7.6202156986536798, -4.0495105061346424, -1.9842858215860031, -2.5082716648798629, -4.7418485458192858, 5.7075502322466898, -4.5714853782318725, -1.227459906194825, -2.2997845110657424, -0.61815634719819368, 0.43275604983440341, -0.41964918693028325, 3.1883043323241065, -0.86793099519816286, -3.149641979800974, -1.5511478527193598, 2.9893276648434197, 3.1549694392000802, 7.4466892809094727, -3.8644560007352986, -1.9554476334839137, -3.5667016432291168, -1.542419098112298, -4.1951438464745072, -3.5277176302958213, 3.7512574905786944, 1.3482570237254214, -2.4218988674817865],
                             [-3.6105641928543872, -1.0262613515866983, -7.4252514450140659, -0.24302452821905129, -1.4389596602450387, -2.4466069979541958, -2.9013919353559516, 4.5453604167446908, -0.33770016146934295, 8.2517281757119658, 1.6375719257210206, 2.3987312627638921, 1.1268629449863645, -1.972623567425952, 3.2162679710854669, 8.3348252304468691, -1.0714169195963945, -2.9968884516662246, 0.30014723352134931, 1.1282162531305018, -1.1936138673678403, -9.3637772914722603, 1.1373616452234665, -2.5712043322503879, -2.3295773024586155, -1.4426789871997183, 0.6054013382358524, 3.9667889035980588, 6.6600469714476311, 0.52407360921726442],
                             [-6.4915078533034904, -8.0045856614640947, 0.6317436081617871, -3.8503188229046774, 3.5852149136693798, -4.767722503974551, -4.0004067422033067, -6.7552581111524717, -1.2340823211448, 5.2769631772652321, -1.225948982857509, -1.0535417940542593, 1.9673227965067981, 0.16401206284616546, 2.6064114099500912, -5.9615477616073624, -5.4362626637661977, -2.8356470965834188, 1.007032632059716, 8.5956599365624999, -0.87293253883090638, 3.4585397863847271, -3.9710924197037771, 3.4506941379711233, -1.2345227858685219, -0.38550052656542305, -10.301415126575378, -2.4938314392466596, 1.4335666477857327, 0.77038240031658411],
                             [0.14258042310805735, -2.0900632472848559, -0.26182403961563505, 3.0317640919704365, -1.3888981035273271, -0.60666287441617639, 7.3121463109165763, -3.0196595125445165, 1.4372425798446553, 2.7768087688084373, 3.4072833582965281, -1.8164328308705713, -4.0686961096677576, -1.1032240996025262, -1.8901475105428827, -1.2494522907394237, 0.6478552710282578, 0.15040342081150038, 2.1964971996752016, 2.54544235982388, -5.4542162710318429, -9.8708911429898389, -6.3460249391683439, 6.0027248890472826, 0.67688456643488759, 4.6397913658159329, 4.9687297559331798, -0.24163524053448321, -3.927340091684107, -4.1243984612352342],
                             [-0.024082697783857021, 1.8905598177231711, 0.88657987975818031, -0.12660969222573026, 1.5894515890240437, -2.1032904048785022, -0.17455663047139491, 1.3104623188583269, 5.0635349469194235, -2.9921197252506788, 0.40207043375040818, -1.3975754993105403, -2.7285463497814479, 0.39737666284643458, -1.9068573015775641, -0.24745631237648835, 1.7792153737161207, 3.2773505589888621, 1.0416322616948153, -4.1951763432505071, -0.36173092742260277, 8.3294799637773611, -1.8614520574177336, -2.6627170121297778, -3.1278319072817773, -0.96873764297496645, -4.1359311286583269, 2.3588642100722348, -1.99178534170441, 0.099702448885046424],
                             [6.6763805957612208, -2.0912516500523646, -1.8034817870426174, -2.5468269937254533, 2.8051931706947189, -0.48406765905923932, 3.392460112207853, -1.8667394507486894, 4.9434959447809037, 3.5177173092230807, 9.4353842485936763, -3.930443411837734, 3.0439209540081942, 1.816010789207156, -2.2656174947619969, -7.6062028898073777, 3.1492880699406376, -0.68082297661687186, -2.3700937111117937, -0.052863429186765676, 1.3435439626920824, 0.58308410444209002, -2.2146343057554656, 10.136620996228537, 4.4523837915230171, 8.5590223508236214, -3.73057325136506, 1.0884945612960406, 1.1854677245237215, -4.3347801735680518],
                             [3.9855660072468702, 4.022270952123038, -0.35763458373595314, 1.0877865784929484, -1.0742140045660382, 0.48692052560704202, -1.8121428204425403, 2.4590158004270544, -0.98783238756372005, -0.036397010468977919, 0.23582813031006444, -1.4812563656676456, -0.074920480791964783, -2.8857789824158084, -6.4899346486968987, 5.1474729973059352, 1.6860169537418057, -3.8614485678138424, 0.55123421550947804, -5.9329629600802312, 7.8490346272138467, 0.24604968037668606, -0.080645179304331183, -1.3470456488192037, 1.3932578679311696, -5.5026277342157099, -3.9366939330829802, 4.0892970813898257, -1.1668397568088447, 0.59836429456053597],
                             [1.2056184887912524, -1.2169631841681512, 1.7986798943241387, 1.4928141365416605, -6.8074887464003986, 2.1747791157333314, 1.7071116382008429, 2.8950825344736373, -5.1077919911320677, -2.961395876217273, -1.0847377189379859, -0.11480061561452901, 0.57827283088580728, 1.0712315524682881, -1.5020552729375745, 4.7767901527848595, 1.7007682311991403, -1.4553456533159563, -2.6471135511554067, -1.1792842296145889, -4.1610378281013869, -6.0725647638059135, 5.9639122791784409, -0.071399424710332809, -0.41460639656600246, 1.0854777213947253, 8.6660574219887554, 2.2480144781413971, 0.95539272810890374, -1.2686365884698536],
                             [1.2338564806757035, 4.7498873845851914, 3.0121355483547956, -1.5299047489920397, 5.0888786636332917, 1.4684692601121416, -0.94883809847551603, -0.53821521126716854, 4.1020892855079722, -5.3136978661409069, 2.0486645124985157, 4.7027133856092469, 0.24381130262869294, 2.4124651563877304, 0.90397396395667318, 3.4773603380008224, 0.37378958418996694, -2.3206888851498984, 0.56772088207126592, -1.3899552200889986, 1.3935763114605169, -0.70284263332834807, -0.90545316080775529, 0.63805005253739666, 1.1294131379058161, 2.4702488649193293, -4.6731984991768103, 2.9305321975328669, 0.11504989368065299, -3.2434756957859672],
                             [-6.1138709733718279, 6.3496033971515811, -2.46359765272677, -0.73239942142877124, 4.3446065862939198, -3.0683054283693583, 0.99256557950141011, 2.5378053587802456, 8.7625438059330367, 3.8544704651583679, -5.1110123037994324, 7.4831213929603848, -0.88941287354577037, 4.8592546458701396, 0.18504875345306249, 8.3164018451698176, 0.26993735049920176, -2.9971482886548158, 13.358027248160694, -1.6596110951431859, 1.5177039369810261, -4.2526095231963383, 0.53488607095054586, -5.0641228485730432, 3.5871198787505429, -2.7089253044107737, -0.19568618163302054, 2.3084329626122244, 0.16206288293533677, 4.7211927074528788],
                             [11.824816498912387, -1.3865037186236022, 4.6170018694355326, -1.0866554093556893, 0.023598741294223347, 2.0439424439481932, 1.8169033694613128, 3.3483252185970196, 0.33253403866612491, -2.0497629370509758, 0.58850903954967948, -1.4358851201589375, 6.134564757460983, 2.2424328010968391, -3.2854138736628418, -7.0978472477549106, 6.3268852925927526, 3.2615298539752522, -5.0114285291153058, 4.3922843102696492, 2.7945840661134338, 6.9414026586305635, 0.52705805244856141, 2.7342931346813284, 5.0622045541910579, 2.2893540530639704, -4.2030963045634477, 5.2189318501978628, 2.2499796465584572, -5.2471516157631335],
                             [3.5328730345300454, 3.4751826942907065, -3.10317856146172, -3.8593925951258767, -6.9666054550270111, 8.7833670598031723, 5.2168429347193603, 5.9911267501695482, -4.1359757427781947, -1.9163848156046197, -0.63190054070089241, 0.040506182849248062, 2.9116085054216043, 7.3018247222427091, 1.5917874408166879, 0.36732385590783134, 1.7192897545959966, 6.7603357598732998, -2.3764180322893154, -0.19860594827203482, 3.5948350153568529, -3.975965806960998, 4.4652588906810964, 0.63248454976901125, 0.74637617390723077, 0.35753844794719569, 3.0703015875627573, 2.4581285172141127, 7.8669810425897531, -6.1500259505987644],
                             [-8.600088707010169, 2.9003887633312639, -2.9248664492675989, 4.0422832550820615, 3.9486697098192449, -1.9698074012652593, -1.4044341141908507, 4.8687724285930214, 2.0588953360353845, 2.4942840151959871, -9.2002421220340409, 2.7869694001185321, -3.4409679337205192, 1.4384330277257804, -3.2971785816985757, 7.3278749229752433, -4.3595512849876998, -5.3625949877302546, 6.5526188581434965, -2.1118184060701024, -2.1968211630681997, -3.5059516920407181, 2.8503684017931175, -1.703073523636724, -4.1944830836570324, -1.2843835186435171, 3.0161055953695866, 1.0569196958402203, -0.82968930490639525, 7.4015771186421526],
                             [-1.4008709056702346, 5.8912160464883083, -2.5287658455368001, -2.663269087292861, 11.195060646179479, -3.8200995097274424, 3.2485763207596139, -1.2190572108500051, 9.6662602593418114, 5.2556483263303155, 2.8565969501613679, 1.3456427652734062, 0.82587541776390594, -0.96130127775243568, 1.8117066908231139, -0.82749422299497022, -2.1019978257757521, 2.6915238834900013, 7.9026373508007204, -4.9801779723082857, -1.2488610772914157, 3.5791325264712537, -1.1635014613408206, 0.62920468466716328, 3.0226222707206674, 0.63671393896746642, 1.0733255945008595, -0.42459924659001258, 0.63569805825066106, -0.14337961199252824],
                             [0.4779666505535225, 0.70883750999389394, 0.80608113018003391, -4.5375571209771639, -0.53519013559585416, -3.9517315057997058, -0.54122791789078795, -5.5819535390316535, -1.734272546351419, 6.4794239714008235, -5.0901599304807705, 2.3360006918382394, -0.95581390118832688, -3.7708325182623073, 4.3905818643512422, 0.12443062068524768, -2.210165304321007, 1.2751975955288755, 7.5975810971219859, 1.6896608687127417, -4.5867934967442947, -3.2006170184165224, -3.5329636730366891, 1.3549008534649687, -1.2708035537859073, -2.8229836992521733, 2.3073140805397618, -6.2363664608068357, -1.1686523768129193, -0.017489850769776716]],
                            [[1.6689222783957374, -0.71235279078800395, -2.647482510981507, -3.9535499448314475, -1.8644102907256133, 0.78101548849880231, 0.83950869161676112, 0.0097735335369970588, 1.9235155509540796, 0.12753956680336481, 1.1963832301900748, -1.0739756729916405, -1.1847901488904959, 0.44506912930666565, -2.5323578286705506, -0.63406679679855071, 3.4868011567933301, -0.45460089913885238, -3.2651346033859441, -1.9899016229179665, -2.8204626800429282, 2.7938292939980367, -0.39219831743751699, -1.0006789684000319, -4.1378573772592429, 0.34795323513320109, -2.9530401425430135, -0.53783349949840875, -0.13722371588861215, -0.56056751363811941],
                             [-3.6586619037096391, -0.84815194435883634, 3.6131765237183835, -3.1949196149508161, 3.3156395250950892, -2.9540259012871317, -2.1918084806144158, 2.4713527239793684, -1.8928394014023229, 0.71873037448239652, 0.44773039477630894, 0.97978973702542349, 3.8556011837762592, -0.89263981483460131, 3.8169894923244039, 3.1258380991025789, -2.6182130241644979, 3.20585679940532, -2.5561483191496048, -0.39217762326712935, -1.9688506626870366, 0.13695080542284607, -0.63850941180766041, -0.97486519621195811, -4.1020701209891293, 2.9366009987541934, 0.69638171309605812, 0.73049408246250924, 1.4042189337254694, -0.08365521504710427],
                             [-0.44570145533157707, 2.2272017058411979, 1.9545995157188065, -1.7774257487062914, 4.762775342156953, -1.9524667551056001, -3.8900231210907354, -0.63854470750764225, 1.5433907814202619, -5.2861658574501718, -2.7216603647432946, 2.1749856742680023, 0.52007397079662643, 0.44543535600988959, 1.2769861060846193, -1.6561333555009374, 2.1101944507517114, -6.3945223694736884, 0.075236726956035116, 0.55766459464964291, -7.1793404746295932, -4.3422984087389365, 3.326297863319482, 0.18676702698788231, 2.8154471633087859, 0.42265066892140679, -3.6319119853608446, 2.0674054754108795, 3.3099211934999881, 2.8083958318636855],
                             [-0.41049406035046754, 0.95238778926100209, -0.3857560917550919, -0.96918709174356921, 3.4077203305464985, 1.8363483580989877, -0.80066492694915981, 4.7005631771598848, 0.21790906549170314, -1.2253959353915029, -2.4053036223966222, 0.71557888973372508, -0.89780304954291512, -0.87192222734030467, 3.3236341281559567, 8.5816839625046146, -0.96342749992554289, 4.7321140032401567, 1.6043806532663354, -3.0334085609530161, -1.2910223393707183, 1.578589108871912, -4.2588763917085766, -2.6064767048421968, -5.0034315609072584, 1.3496907483844933, 0.69932259667210572, -2.2996470717406972, -4.5750606777585681, -7.6396513623334625],
                             [-0.35344368519235431, 2.2541162767313927, 0.18773257286072201, -0.57721768103667959, 0.27578296729515833, 2.9514719196853001, -1.3157826898182967, 2.0040474935544501, 1.211356297837761, 1.6856860368778916, 0.90731632343437696, -1.1124509586524565, -0.3162738329781658, -3.9636484442454329, 0.73152331046518404, 0.78723661528440814, -1.1525295703279428, -0.44607955139051236, -0.34910324444177648, -2.8750947344738234, -2.4271482556609616, -0.62281368481352406, -1.290090181051621, -2.6005102869241572, -3.4156388262553863, -0.095718769223051781, 0.71471168137021968, 0.79262993277459326, -2.9751478438098542, -2.5786344468599913],
                             [1.6197712829253419, 0.24570602991486939, -0.66104946117806873, 0.4956117537014752, 1.0356160526744076, -1.6457022798161023, 1.8887412537033947, -1.7208006609714164, 1.7384639891396765, -0.75442487179852857, -0.75040904802871633, -0.22286374295367467, 1.8059868126252039, 1.9392799664288791, 1.0926357398351678, -0.035618486690661214, -0.95554866894363055, -0.72359873042644063, 1.6433747867354913, 0.51637915058413408, -3.1911867346087459, 1.2252665550833466, -0.30914221529628561, -0.71260876067842638, 1.2372366178767871, 0.15123671653376186, -1.3997153277806209, 1.5661382402096116, 2.685836896410327, -0.12796376941531351],
                             [-2.1079074184430837, -2.2421913651060819, 1.5311806910053143, 2.842530023375573, -2.0154453053830457, -1.6113509283962313, -2.6993329055462949, -0.023338257756958525, 2.0810766331601291, 1.3613599239473135, -7.5857536902606837, 1.4562695268292591, -0.19565341546630988, -0.084596670044742445, 2.1897907720896841, 4.0234948167891034, -3.8209190840234064, 3.8520095795223743, -1.8282603710112735, -0.97718767697350417, -4.1076766850666493, -1.2721484648706296, -0.81450586144851367, 2.0245799195082128, 3.9238551485837427, -1.990073713600975, -2.7482922852695753, 2.1520163460205182, 4.4399242306817461, 4.9880375677150184],
                             [-0.034506793933388513, 1.2851869829851061, -1.0465018371908625, 2.2359651779440406, 1.5199563699260497, 0.11047197942094489, 2.8484107812145605, -0.33278634115021899, 0.60356431973452151, 1.1532988123047934, -3.7316743414785019, 1.0474500783548302, 0.52186692741524787, 2.4424914018143165, 3.0034558784598655, 2.6275945261200659, -0.46260161774881525, 5.7796114034217982, -0.71337309021775464, -1.025839473713154, -0.3646873746717304, 2.0456352185851205, -4.0119260484553347, -0.42823229606114771, -0.63896502188326321, 1.3539810631796134, -1.138791892225935, -2.7549454179451907, 0.76573462690823257, 1.8281935970932741],
                             [-3.3378932262696344, -7.0948477576783642, 3.034673305551721, -2.1701935967225574, -2.1089627638206796, -0.53841829017101817, 0.20146699979628133, 0.46363346215313994, -1.1972729613587347, -0.32024117630385096, 0.0095375405575738453, 0.4395376844047601, 0.97366516827680205, 0.53418139123461528, 3.0088113798500253, 2.0728021545591022, -4.6591607106468897, 3.5013387036813883, -2.7827020572682288, 0.92940390088906344, -0.94622618943436332, -1.0089080874495422, 0.83965362401727284, -0.23158606471196891, 1.93841936017881, 0.68507417731591014, 4.3795749860424831, -1.3547540679901007, 3.572556213883177, 2.4372529780491501],
                             [-1.996494379545698, -4.441270675039946, 1.5152455018306734, -2.2143223529413967, 0.29817893123967276, -0.34908884686583902, 0.61846920835746921, 1.9830784597164943, -2.1818305293516453, 0.5159730353465809, 2.1669988323375016, -0.66633823396904479, 1.3806731835536372, 0.36611417660704887, 1.1158436124425879, -2.2328336875416439, -1.8491007368339472, 5.1052944874377246, -1.0064318220792283, 0.65043642979339311, 4.4610390848803672, 0.11811887376305863, -1.8347370441874726, -0.9043724288432553, -1.0082086466918927, 2.397083346046939, 3.096604066552763, 0.61947336763587524, 2.5130054444003393, -0.57968311503271064],
                             [0.6659382182520388, 1.3836858875423947, -3.0816357273289534, 0.64226278562213424, -0.37410229258541633, 2.6213228014985939, 0.58860495032742699, 2.8667901313066229, 2.4700478525407048, -1.8614898003783944, -1.5146148186974331, 0.47737046382951071, 1.1276789727018646, -1.9611583391719039, 2.3330100370810527, 6.1816902441519925, 0.48478746204058543, 0.6261695300888529, 2.8104168857082708, -1.2027265062372636, -3.8042111015513163, 0.74411990930663452, 1.3088813710062848, -0.68405605953080162, -0.62217314091115961, 1.1051066758587098, 2.3216720297290303, -1.6506328110349178, 0.064472821602537839, -4.4223046057026121],
                             [4.1073857119640262, 2.8023922409163253, -2.9514106717209052, 5.1273006627885511, -4.5366549030213115, 2.157583087352307, 2.2809141592873621, -0.6600077333186587, 1.5981842282602075, -1.1146270074065265, -2.7897432528442665, -0.74780429115808555, 0.57127908580756914, -0.19559227374600108, 0.094359389483670744, 0.36837986213464802, 0.92560880245402011, 0.53450568072837623, 5.8560097401079529, 1.8797037771908482, -1.7613533094146312, 2.0466282299129848, 0.58468506888695393, 2.7739750651709594, 0.9028432128708922, -0.42717464198471777, -1.4757629370214975, 0.34680702644600092, -2.3178830300116009, -1.5158233967443013],
                             [-0.4727475502534968, 1.5800613156091508, -1.8833371803513737, -2.1569840764133241, 2.2503417681313733, 0.71511873607796583, -0.99231571807717844, 3.2492611460076719, -0.34758982974886954, -1.5615307673576186, -1.0936526270185265, 0.39902834752313315, 0.12593144393020078, 0.61169946495415106, -0.53612043223780248, 2.2607601497240228, 1.9102476289928898, 0.8862650661580751, -0.61905433084680395, -3.3675356034667523, 0.87940693536561887, 0.78374193930355629, 0.94942959414018413, -1.5863671111627351, -3.1167585821511512, 3.4137538698493426, -0.092193142975881381, -1.5421383419768022, -4.0556500207803392, -3.4045433812788826],
                             [0.8507653813208762, -2.3800286256981642, -2.1862830631078842, -0.6196536056035421, -2.0238972104893902, 1.1421918836243714, 3.8428409861853474, 0.7464302802058822, 1.4856051587488313, 2.1680353558430241, 3.933918734667456, -1.0342555099407069, -1.5931664731026589, 0.77379918131522529, -1.6596903957594418, -3.5896309543618381, 2.2994019004903863, -2.0744167690676818, 0.27796387518612375, -3.9006820841466183, 2.6098336848205586, 3.0046332357124141, 2.1113786171546871, 0.49624446565566721, 0.73408005634176954, -2.5048137953706853, -1.1403226733625402, -1.5002588954802369, -0.6334944668000384, -1.5370590933408441],
                             [1.3675373373495887, -2.5090151961562532, 1.6699028461382825, 2.769916538050361, 0.072728368061874354, -0.69874187737459659, 2.7247213682220335, -0.24075617326623819, -0.66204451243750162, -0.26918821580473223, -0.18208513553303618, -1.5923782010790208, 0.82698094559611024, 0.26362280369584767, 1.6324738726628865, -1.2780717210719783, -3.1093565822983527, 4.8911444268073794, 0.41290219489009383, 1.0975811012684469, 4.4578609633732409, -0.94910310271094023, -1.4453752107558904, 4.1014114738753866, 2.5816402738039339, 1.1491373247411698, 3.8778023546982823, -0.65789222791946278, 1.9203740888350191, 2.8140728390101555],
                             [-5.4172863922034775, 3.6936661857802475, 0.1315249010383808, -0.3291190024258997, 0.81838116686115647, -3.725990600949042, -2.1987625513870794, 0.16263121053800111, -0.023047769903242504, 1.1876373891557164, -5.1989965098292883, 4.9915232022843261, -0.43793957581661486, 4.0715002606686852, 2.5759692844395476, 3.2119415614872864, 1.416791967264887, -1.2975328876567178, 1.5724130873550508, -0.30608354500155277, -3.9059014658253206, 0.97848911368249059, -1.3116538312514092, 0.20088768239068508, 0.016069991623866797, -1.473191419189547, -2.240906443889513, 1.3709024504145551, 3.3070633915411278, 0.18992705425155171],
                             [2.3180456524814965, -0.59618159461921705, -3.8015213730649986, -2.1561970058413662, -9.2836292125593953, -1.6778118174998298, 1.5231020356734328, 0.093391631881335896, 2.9910200660380801, 0.86848889378516747, 1.4703016874761214, -0.69965438088813947, 1.422145976770208, 1.1221215047378377, 0.86680565857625769, 2.0413595679313778, 3.9896373353365804, -6.5639323149158413, 3.1583719499447112, 2.3421839549825627, -3.1235025052622447, 1.9971489264343343, 5.8242534653414912, 1.8552085278755763, -1.1920947062921647, -0.60233646381857131, 0.20891802750183766, 0.83730728644439356, 2.6590656446547363, -1.4377275883755694],
                             [2.2411488278234826, -1.6765172258184728, -2.2249816119938797, 2.5302742512745047, -3.6800618797840743, 0.37700869814457905, 5.0950525792649017, 0.81663591074676389, 0.84149712575290103, 1.3562384649055781, -1.7267174888544941, -2.6269704403103971, 0.98731573636683767, 2.0706944881045688, 3.1941983891862149, 5.0721263385995181, -2.8203638139752245, 2.8084045047801145, 4.1890103032034185, 1.1840283797378075, 0.32782230866553652, 3.1091516624451709, -0.98158523095320493, 1.4833976835358347, -0.071258245059967473, 0.42127400276099469, 2.3144048384145415, -2.8523713151609282, -1.5765250868051217, 1.1096874501648526],
                             [1.6111837076357434, -0.26805827958706929, 0.089210821501156473, -1.1350383744705115, -1.3395634433268098, 1.2756538721538897, -0.10310733102482246, -1.3703043818885809, 0.2172693859184803, -0.16744062691238557, 1.435060616245222, -1.7617553123187575, -2.2670495410024345, -1.579858866111592, -0.92181787911772539, -4.3077037120847956, 0.26613087046270956, -0.11676593211703726, -1.7679174947577248, -2.5271165504086781, -0.044455892626126453, -0.18524649335627863, -1.5707269004026381, 0.85504748753035753, 1.0899416664448229, -1.0657502351753221, -2.9673901196477188, 1.0063080739406534, -1.0642796618708041, 0.062963288992754912],
                             [1.5483648734377824, 0.90018129122718271, 2.3309229587818949, 1.9917853903469505, -1.514721948446518, -1.0016081026893209, -0.21652940735198692, -1.1354965615865065, 0.74973267818799028, -1.8578869122415107, -2.6739201072815937, -1.3807331243575569, -0.036703506126678054, -0.94200676345522272, -0.45805377878194353, -1.5461496512621484, -1.6726026491479375, 1.9026216474614124, -2.1542062607587074, 1.5920321061596592, -2.1545178594306589, -0.57659719804643861, -2.011636360506845, 2.2741884142466335, 0.37085138084441183, -0.41497384591530184, -2.1583779749221392, 0.83827095335945545, 1.7558396214000505, 3.3498903818798591],
                             [2.2008533897228881, 0.39814962921282759, -0.046720746681917669, 0.13207630908710205, -0.44258204026763659, 3.6069605434491359, 4.30572401862739, -0.27947075433854979, 5.3063412224377622, -1.4298539282650946, -1.6166628901373179, -1.0968772855570066, -0.7369106756526862, -2.426669535232008, -1.2588138128053024, 0.61985553711147867, 0.82172169776920656, 1.4448724373048023, 2.2216607635920429, -0.52446918568870726, -0.45922269965383461, 1.6466294119689175, -3.2816555883700178, -2.6188183594725492, -0.19358046097605519, -3.075581466279079, -0.85071077042646892, -0.18400120443345525, -2.2251165048515698, 0.23533311206252661],
                             [-1.7945022651475071, 5.4259156893317746, 0.42060319412431046, 1.6980986161406877, 4.0928097097239053, -0.39187192453362407, -0.9771974384425931, 1.4803607467007309, 1.1155334072245877, -2.0752509498681002, -2.3037265028492468, 2.0583572957126122, -2.7463428986282574, -1.008278934746663, 0.83111414394849881, -1.7702358819888881, 0.57314631058165644, 1.9006134366878484, 0.15821539777115456, -2.7564644832994074, 0.49022243279990119, -1.4948731014681553, -1.3582932014109774, 0.54352576935661268, -1.8691735422808811, -0.85916235009932396, -3.8675236364938548, 1.9693466917556051, -0.37453410770007245, -0.82512194603139499],
                             [-1.648108686711024, 3.0551916993300408, 3.4119225510568238, 2.0337577412643641, -1.0819214047220551, 0.26392268241630112, 0.49145113055353301, -4.1497387964459058, 0.967018718284957, 0.24558200727227655, 2.867049131681735, 1.6396692555819923, -0.21416143793615355, 0.30713295096981974, -1.8768342682030001, -1.2012741710710995, -3.0758001113061719, 0.85861681879946683, 1.0071100522679386, -0.12527414577882773, 2.3272915966840126, -0.81422619405460694, -4.039917355964743, -4.316206969821617, -3.4408671413140559, -0.41084447369605004, -0.54469653601915657, 0.81129218699869865, -0.19283676192189869, 3.6763582681342122],
                             [-0.26838520380631792, -3.4064199251762073, 0.9125883201479007, -2.0726953113176152, 2.6957189667541357, 2.1750332896519979, 3.6461560099269485, 2.9212425381077685, -0.19392781945282223, -1.9701064741826104, 0.46145586186020954, 0.7894625404462503, 0.85648338644105448, 0.30055434741843623, 0.70121664776232651, -0.89439143159460399, -0.24434313577157923, 3.9262441085390227, 1.9002943815801179, -1.2670885643108307, 3.3564723579723723, 6.1753397430036499, -2.2290635643871313, -2.4643473031805136, -0.69890889436491088, -1.2055837872036745, 3.1702926465459438, -1.8732149750374973, -1.2467931859181118, -3.9092152552055355],
                             [-1.4795647638733584, 0.75980039680442879, 2.4008743895285174, -0.013624127476892156, 2.7886328899906543, -3.9401739322787575, -3.546415960087951, -1.0185918537342702, -1.3863018203981039, -2.6662169770540713, 1.0620978243529227, 0.070503156493556873, 0.2256243564591138, -3.3444886119546, -1.3674831541111647, -4.4521150904990145, -0.90015633431656761, -3.8390693626494214, -3.0309167631585949, 1.4649644850070664, -1.6795484837581651, -2.03759158475048, 1.1732822299091039, 3.2710550342001716, -0.24413851116373214, -0.13005599373699669, -2.362056433680559, 2.7296476210124525, 1.1553660946860169, 0.80616852563314412],
                             [-3.7293136459330603, -4.1950409414445229, 2.0330449270222357, -3.7470788830064166, -5.5456614657140815, -1.6328153045732905, -3.1560280962487828, 2.3616823645181082, -0.50882177207420465, 4.5444351265258929, 3.8454577988099299, -1.1011817235555996, -1.2789617736099357, -4.6784013068580395, 0.95273297483824249, 0.46277085073117985, -1.8890912597717511, 1.317158670790755, -5.1139638826730334, -1.7580013849753897, -2.8045762739135593, 2.9162996760227866, -0.68868991376285382, -0.8681186612744296, -4.7147291449366877, -3.6239277487758352, -0.39933598371227513, 1.6571114225768875, -1.0875581808951782, -2.0187326744545291],
                             [-1.808925885292135, 2.7835744286443527, -0.093295923819506604, 2.457958359326486, 1.7226296948927897, -0.77114807606060443, -3.1906505766908291, 0.78951802902785106, -0.6881201166208335, 0.35644254188011448, -1.8406305861616132, 1.1956488615664029, 1.0834021457590823, -1.302142052578394, 0.71577130341853812, 1.2270107710688878, -3.7882362776142076, 1.8017804314812405, 1.5947473097154461, -1.1973630296274116, -0.2550801507016317, -2.1745545233138248, -2.1428545388074451, 1.3776021756728662, 0.10178102391985117, 0.16852105278940255, -0.072259832253000644, 0.77612817703740089, -1.8133245615427451, -0.84926650239970136],
                             [-1.2302222640246741, -2.0201320500404467, -0.10122243247142426, 1.2261288182523791, 0.79749398013619432, -3.357709114185679, -0.32793536017236097, -3.1572166246821163, -2.042645818383106, 1.7409217022726744, -0.086196635000387767, -0.39914334885885444, 0.80657477334000172, 2.1278766806398095, -0.25257566930374942, 1.2197644611808407, -1.7641918188962105, -3.4834901057087611, 1.8115088954929051, 0.6399662103032514, 0.19266785550675142, -1.687037016192465, 3.6536615057683428, -1.7506366546736418, 2.8346925268730225, -0.49671834094534906, 0.43443448277106889, -0.54540234117373909, 2.8067511425967266, 0.95296757206315197],
                             [-0.53512588154575469, 2.0511402237156733, -0.74689166682044095, -3.5021591675863881, -0.37207865577697091, -2.3916320908839523, 2.3117593408975488, -2.4677362534053557, 2.8619749187608634, 1.5737274213445283, 1.6078439305494863, 2.9600986980944861, -0.17121537168655943, 0.00047202188522181728, -3.3869219004507185, -1.1639285724649069, 1.2308777703823692, -2.862742512097852, -0.0086629782023730402, -0.75290906148162362, -2.3841801626089167, 3.4222313577957322, -3.2504304129276669, -1.0781429580040802, -1.7421484560631595, -2.4529975677894305, -3.3352041812351598, 1.1360374009896652, 1.1533412532855816, 1.0574817690319029],
                             [3.8400447353867895, 1.0257389232718361, -2.1963387074431582, 2.3984930000228539, 4.0034679943747271, 3.6195886477350943, 2.2378259334120774, 1.5378230888991227, -1.6714209226377454, -3.2853655654327709, -0.15249012162468573, -1.9209246735554928, 0.90882141570187547, 1.3419472283504641, -0.94827804075684397, 1.6135595244998677, 1.9873207790673542, 1.7941751947982825, -0.50248546418022855, -2.6084968393186245, 1.2481449397595494, 0.81176061202597594, 0.03643051014537442, -1.5742917860934753, -0.54252039400972274, 1.6558132564139461, 1.5306009327001735, -3.4107060263682385, -3.6240888536854374, -1.0017772957630016]],
                            [[-0.69218874057469904, -0.91052460771915344, -1.7569029899953676, 1.6265217177832196, -2.4858075120219021, 0.024477772525869773, -0.25134343347500659, 0.70747530898477318, 1.8177201946852641, 2.3842243634499369, -0.035105425605469538, -0.36449879471648927, 0.038968743317932118, -1.5662235913911922, -0.52097376781471416, -0.34110159263933854, -0.26834870104277775, 1.4366446068512868, 1.4829488070254577, -1.9027557658732446, 1.6754451342064665, 1.0152176629689191, 0.46165777046059114, -1.5296463503578166, -0.060758441533311579, 1.0684066634826568, 0.41632101822166956, -0.14371919432557514, -0.55273821835474601, -0.77705579587477824],
                             [-0.81925777881189743, 1.9680823201487136, 0.33888045846746889, 0.93540903876692449, -0.50924895496125755, -1.01149834663925, -0.66117746321684367, -1.5082763717255245, -0.43303796077938383, -0.24495372776747831, 0.31425217762386792, 0.67426437718175791, 0.87691461419779415, -0.60487003399211758, 0.20190937628517933, -0.70349096377688092, 0.45607871518259302, 1.1167618400314157, 0.17805599253744417, 0.6990236016053295, -0.2650576651375296, 0.58202703297690961, 0.623600469054849, 0.34499017580578384, -0.76529039683675382, 1.4772981444989783, 0.12072847242799492, 1.8558256231101278, -0.30072209842800424, -0.0096799507096098358],
                             [0.29135846924897407, 1.3210756806078172, -0.67853817718908205, 2.4471861485729001, -1.0328776300796794, -0.55380508041840804, 0.25393582299045364, 1.1813168942032368, 1.9107496468021044, 1.4737134328940302, -0.1066665834202675, 1.1364272108539819, 0.57884334404448001, 1.0564486204347667, 1.4980115228569018, -0.89388165221820126, -1.3311131026103984, -1.2177452104892432, -1.0670281042789955, -0.77821016569638635, 0.62150592034820962, 1.4350129922802985, 2.8267095957583988, -0.12122537227621139, -1.06421315292809, 0.69199402013075106, -0.2237255489357543, -1.5989416618371937, 0.28560573913624016, -1.1631514553013531],
                             [0.48964358812594394, -0.60280209694409104, 1.598571253370983, -1.7889341838511614, -0.62863043197277313, -1.0280426052072047, -1.4950388385174302, -0.92478863847137716, 0.73787885104158735, -0.047957046526956468, -0.12980991160697428, -0.28874493734525863, -0.0051967796464437183, 0.55141851624920957, -1.8220361636186475, -1.2731671786083523, 0.22106593207865635, 0.72967188519924697, 0.80900291490910814, -0.2673265137433346, 1.49172920955594, 2.3808210679613935, -1.6850339121718632, 0.2389000101197303, 0.22491439649736736, 1.7484125902510879, 0.50420432812521476, 2.4402765817286438, 0.13196819974940302, 0.24660119444207454],
                             [1.2470113356592958, -0.064130935352096324, 0.56498396051476085, 0.73193240864932874, -1.5052737434366159, -0.21350915277574503, 0.11760346145634784, 0.71782791551381298, -1.058613830193847, 0.3409361937336946, 1.9788050286231278, -0.12329902558243284, 1.3973144900911851, 1.6198002060355057, 0.17670879139162565, 0.17462525139830631, -0.73388008119619419, 0.39290804415816194, 3.0541258939991955, 0.41623234545066656, 0.60350413712409989, -1.5298610923413096, 2.0718631861037218, 1.6332799078951925, 0.8147923129545972, 0.094584790090978851, -0.68461798451653866, -0.17088077610859714, -0.72195290270983603, -1.221526057681644],
                             [0.054934725095543632, 0.94586175443342724, -0.38134231189773526, 0.20003536150162762, -1.3285832823502528, -0.91351421380141862, -1.0448449811924083, 0.22502009819622459, 1.7053551668753448, 3.1718619645537567, 0.33382433553528734, 1.4113205659419459, 1.1558659099659299, 0.12205293317289016, 0.78918393307483337, 1.2101886593969053, -0.02202860726668604, -2.0043253981370333, -0.021892036321456552, 0.78774059072538372, 0.33956564307446874, 0.94558157350811123, -0.76749275994093624, -0.14510746599611091, 0.26018311288934143, 0.3351853858873341, -1.0845289609790552, 0.28492403186840143, -0.36280096844698945, -0.64407494667138354],
                             [0.70183678769415125, -0.60274847131873432, 0.98669486497719661, 1.3373448794745539, -0.30007183316686686, -1.7126271877194454, 0.031467117563565357, 0.58616406636367679, -0.9232190247920925, 0.39855438004300903, 1.1505609674938537, -0.93167663436084336, 1.3312105102112832, 0.58982576332383385, -1.7409793527618649, -1.2657031627669328, 0.98682053300870143, 0.71888502456972803, 1.4617499238199889, -0.64903658685313381, -0.19243228817449071, -0.1987084804588708, 0.10924310916521213, -0.27188774910014685, 1.0611651633041395, 0.52676827903613277, -0.80933547006019813, -0.28184636398092172, -1.717302992553301, -1.764155119150709],
                             [-1.7013615074715207, -0.27861228347128281, 0.41620637097698915, 1.268979293616608, 0.096441180619071545, -1.0970032194706854, -0.46727407519951308, 0.99682601134330739, 0.83407682886887802, 0.30311274449957221, -0.28914818833252914, 0.96069923896346621, 0.92928179270846667, 0.35653996573816621, -1.0976069940815782, -0.90767121081188729, -0.4863698271944259, -0.50143897306239482, 1.7958449885230927, -0.31807270076960353, -0.19820528812238181, 0.84071370546877655, -1.0098545642085472, 1.0614088600602261, 1.3046270571574363, 1.7406683217551113, 0.39710928579027116, 0.4224582470847808, -0.62417114125399242, 0.86613536190840967],
                             [-0.78362305829956513, 0.40438378649037715, 0.95291944184108268, 0.58152978415760714, -1.2091407623189108, 1.2173788635750784, -0.082442889888556123, 0.33266861549082422, -0.37525467375004529, 0.78362674225720319, -0.84035681351489988, 0.96203807002790498, 0.94809707528304032, 0.2357300562427638, 1.1513567464880889, -2.1017141946301328, -1.1415800312753976, 1.5230932246496809, -1.8458227729738208, -1.0258754315667691, -1.4825437908146595, -0.20928537263768651, 0.88334962295541153, 1.2656066202570975, 0.0090678448906635345, 0.77564670832969307, -0.36289667490718025, -0.94796522154520091, -0.096907912602508028, 1.6421050744481129],
                             [-1.1023201728712659, 1.1741147217939327, 1.6022482488633465, 1.0545693284869697, -0.22851486579327257, -0.55257825964181562, -0.49117646431808898, -0.31034401405521089, -1.6337383343494258, 0.71327771174151122, -0.92773305462536537, -0.21462694987559336, -0.25727033611310701, -1.3021635356687682, 0.73610021311282914, -0.10137067102710806, -1.3925936607640088, -1.2798242104898687, 1.089557165322145, -0.28223392471624376, -0.24075141431565403, -0.60759722783336034, -0.69682525913813786, 0.10870977568770619, -0.99140809406400332, -0.46471857680505002, -0.3089521213066822, -0.44732648491270999, 0.71612589633853374, 1.3207870967133122],
                             [1.0333966509306476, -0.66885139973937235, -0.81170353442017429, 0.33668402228674721, -0.52390256837730598, 1.066352762752379, 0.15532695631753993, 0.75673871844115503, -0.54371364127062571, -0.55056830191226913, 0.62321277238103578, 1.0456818027254171, -0.21713632272564273, 1.0520684962829299, 0.51512715768311912, 0.16495863949171946, -0.30201300114748719, 0.1166095850291763, -0.3796783325315109, -0.32752306996263975, 0.7431973396724898, -0.20052913043374956, -0.37940293896979188, 1.1028368180814856, -0.61714072436442979, 0.97847264015644175, -2.1046406756577101, 0.16398075679742127, -0.19755901121158462, 0.81680255759975939],
                             [-0.53603187786684714, 1.133737272089262, 2.0864169913007591, 0.79731247735266553, -2.1170639488817713, -1.2500732031353898, -2.3682992933569529, -1.0132435733842782, -1.7258022663151655, -0.68706114039702404, -0.7066294781561413, 0.99296172073081523, 0.35517078349976811, 0.29151950463991921, -0.36889739069263427, -0.4565841296531844, 0.042782733701850539, -1.9170827578083005, -0.90489488475045154, -1.3200019419233064, -1.2671856843498837, 0.68356898830178836, -0.33847748896096447, 0.63345443218696373, 1.6841483119187934, -0.34930213555327499, -0.43497338785140321, 1.0129169426112481, 1.5388998998643912, 1.4388116991416493],
                             [2.2037830221039028, -1.2371007441983477, -1.0705099568911136, 1.0561931580754476, -0.21461152107297587, -0.17078968883268345, 0.84463404340916703, -0.27654971423379016, 0.24430993611240232, -1.0359755721829735, -0.9900083048925804, 1.1506011714404294, 0.62673319624158952, 0.10097034693944558, 2.828543573871801, -0.5173805200117545, 1.7097609726942271, 0.22080955176267708, -0.84707770707734042, -0.66175859402491066, 0.7303305879967491, -0.025490509395344252, 0.38760780052463195, 0.50564878600524921, -2.0551722603429696, -0.16116497820320747, -1.8162811506329284, -0.73174990163572784, -0.62327729726372083, 0.49198433686164789],
                             [-1.3590099215963924, 0.92534798697008458, -0.37789430439476412, 0.57433476983213105, -0.48871939958265392, 0.68873290473450177, -0.96073415405107998, -0.47684532723448314, -1.0144761276405201, 0.61556511840474493, -0.69169000725141838, 0.33276237001956127, -0.29838768327940723, -0.35491175652558643, 0.67078060702586595, -0.51732404173406055, 0.095735840197624489, 0.39374292064365046, 1.6854792985685367, -1.3863494568733707, -0.51033158763400988, 2.2507937773972198, -0.081853797452926563, 1.3559213673765311, 0.0048850374162042465, 1.2180185952676037, -1.070245693681438, -0.59134783797391965, 0.83349453520524519, 1.3672616418877868],
                             [1.3636949816335842, 0.33183782537553391, 0.26732655724266235, -0.62167950984474052, 0.14610959342662858, 0.55704499754668635, 0.33997460638815413, 0.54276073468356101, -0.77897536674969736, 1.8981925325360944, 0.68415899475634145, 0.23663115075352675, -0.81996324869700665, 0.74351409498259491, -0.96158735044307342, 0.14204229270442503, 0.46463994402352027, 0.29325068170416624, -1.3251775117952431, 0.69083577800271434, -0.813783088406142, -2.458483655971234, -1.0507089999450903, -0.81337886304079621, -0.41620002936092049, 0.4805579856111023, -1.0770396268582603, -1.7948471935011061, 0.058873119275916617, -0.69474566759518808],
                             [0.98330395949141347, -1.4449299433316183, -0.77189147487044996, -0.57791013414914172, -0.97270780581518224, 0.51981470060577695, 0.057491369630001336, -0.98296178573054904, -0.034203776206190868, 1.1271965695491371, -0.31130321501546049, -0.49334926446370936, -0.0036291025879590611, 1.5811961758699742, 0.90261543242781672, -0.24321963365580418, 0.052717950392442745, 1.2804410654414686, -0.31990088620127671, -0.16445680601349544, 1.734514807284941, 1.2383626650064035, 0.02791983912682857, 1.5670355896944823, -0.34119743566974359, 1.2291565645702767, 0.13301775203073365, 0.39589501508922464, -1.3796558708931548, 0.077992020191471098],
                             [1.3187421266610055, 0.2590538754325471, 0.15414023350725947, 0.040638778182997153, -0.8320646316251995, -0.25169810295367989, 0.018252152282801869, -1.079721723314105, -1.1732807043588112, -1.1924880014211063, -0.24897073637327297, 1.172637316171768, -0.10025378229223023, 0.11547000520505396, -0.46566400500279292, 0.92226383537720857, -1.1034971361700958, -0.52554186280926007, 0.83806042909172551, 0.32151175740343541, 1.5485371017997223, 0.92271080745227441, 0.048083012436846331, 0.98839587889310376, -0.84780880808191361, -1.0331324250093685, -0.22512815451662613, 0.61669926632306316, -0.23840268411565679, 0.98234090751359204],
                             [1.3960038256170799, -1.0886220609256276, 1.3076567329410309, 0.045028001577851716, -0.89825601381645581, 0.35941969506402682, -0.57538946989502771, 0.62903108556027554, 0.68711945035471489, 0.63025181508089834, 1.2467889889642594, 1.0765540252352206, -1.646022645603999, -0.68768230017052168, 0.00083098667577023505, -0.06977421564353127, -0.47117270514389853, 0.20971533775844306, 0.42694935748291346, -0.38309762396665903, 1.3882122078629484, 0.73841679503833202, 2.3358853716590877, -0.47377593997062367, 0.21628880519680013, -1.2873350328533448, 0.18575641855102498, -1.5473215084135319, -1.16571399693538, 0.26694381257388455],
                             [1.2602979946388586, -0.83320930752564426, 1.7712956086789917, -0.48108042713896865, -0.34039778499912487, 0.22487915867126868, 1.1908926293852711, 0.0036111274996866905, -0.28481911487625494, -1.3421180594348887, 0.23431410497152402, -0.36914203278758989, 0.38417482572490336, -1.1004037359259113, -0.77856971607697123, -0.3215044287447279, 1.256526914068566, 0.48737821900611566, -2.2465922708370365, -0.014274508731708803, 0.79538039393691529, -0.55623350190753673, 0.1416639209526791, 0.81267199860857853, -0.92770440126595488, 0.12297100370851405, 0.62149971090498668, 0.10162869291148571, -0.65023825677253444, 0.35804660457405463],
                             [0.39410062124365519, -1.5693731909526201, 1.2810805648714174, 2.0596475742625788, -0.012003120511640661, 0.52735419582615917, -0.043435642394360388, 2.6933756970277258, -0.21921102563081177, 1.3266531187912982, -0.74778534392177565, -1.5854125939693267, -0.40006264297672722, -0.18446262714195333, -2.9392170906177459, -0.85844041593401832, 0.88242063745621724, -1.3735564591651548, 0.097717251381820913, -0.50114747370528723, -2.0782353331253584e-05, -0.86030988766597805, -1.1304801299692206, 0.83237304283197933, 1.117758243816525, -0.98913816429753953, -0.34670768494295023, 0.22590949028068399, -0.37587310105115623, -0.58088517224942793],
                             [-0.32849075969118796, 0.36545251817024393, -1.8066652518826083, -0.0044402505722556194, 0.86014472695112276, 0.14831426027223188, 1.3333220599290847, 0.75735616399807182, 0.4421535008984589, 1.1899978389816313, -1.3379431669527206, -1.3940883106075423, -0.85851874871675693, -1.5869806351975326, 0.8490327348011677, -0.41415840609349147, 0.53329166291937469, -1.3104956387273032, 0.27738881751675343, -0.19637531785281284, -1.0701461553258904, 0.26273677302342696, -0.16794486806389552, -1.6208327572212213, 1.8215266787857112, -1.577609131767497, -0.92362231187925281, -0.23817402667325058, 0.71348170757044915, -2.2208586761967131],
                             [-1.2320545581192641, 0.55995045754351824, 0.72459957483632309, -0.18893892219399439, -0.04439705420415431, -0.46293155378777617, -0.63944086327275984, 0.53228372855303252, -1.0019671082402091, -0.066562125424717372, -0.063839239000577683, 0.35881356113668261, 0.38058493188873221, 1.1872671524784566, -0.93960441082332713, -0.32633637626912965, 0.30962035868804827, -1.039122599909815, -0.12634522370580348, 0.70129354782253572, 0.15674610664712915, 0.8547880146400032, -1.7350864538275454, -2.336029246692342, 0.1698138966361282, 1.1218750745702333, 0.93065592177662659, 0.35145593355362098, -0.30445558574401049, -0.77235862703579783],
                             [1.691402787479551, -0.075637259496302414, 0.75205128425166545, 1.9097726906748993, -0.31091081618830224, -0.52639675903967598, 1.0985021824081433, -0.43584616803590143, -0.85057707393065562, 1.2857264776012129, 1.4250285050056759, 0.74192698705291305, -0.1075647725027694, 0.46169184033578953, -0.56916544918898004, 1.0764437752383462, -0.12490228543239554, 0.82739712771502272, -1.3981939543623021, 0.68712238238411172, -1.4867427619160465, -1.621859140389281, 0.53767008407431216, 1.2404942552485438, 1.1928564843673846, 0.87095910077240934, -0.55397128442829102, 0.17699816102779561, 2.1544044212387456, 0.5398643320982196],
                             [0.79176732027306418, 0.01833206753035365, -1.6750164435171813, -0.59454615470199035, 2.5415510937934331, 1.1101120458717, -2.5224591287695168, 1.0860370907279979, -1.504868874293819, -1.3423759840099603, -0.27286847040671791, -0.20765864349000293, -0.31222309154237127, -1.3681080116521305, 0.76905675825330488, 0.64159933536078639, 0.28116641202199155, -0.17654839180324933, 1.3633676744954353, -0.080790352829791384, 0.060156415926701165, 0.62366897558634182, 0.60095740981718926, -0.85726521733406114, 0.13134131285550743, 0.44033909542604144, -0.9931653033888751, -0.67522778957474627, -0.78586253505194792, -0.40801295678986671],
                             [-0.25343676423587708, 1.6366265692640651, -1.0760595545216813, 3.0256622863914298, 1.8009899591252754, -0.15576431542965222, 2.0754756869696873, -1.4424107268384554, 1.7391377492326037, 1.2778515955526795, -1.071229025669358, -0.53751735004902257, 1.3749540155075941, -0.44636454049712571, -1.2035993924654855, 0.032460522551342741, 0.35212134103302684, -1.79110375512911, 0.69602370800501967, 2.1494097484439667, -1.5498499887397974, 0.19712373048818613, 0.7287414680389509, 1.1206731438414597, -1.387902402365164, -0.51350225472717292, -0.15846778421422719, 2.0159264147691234, -0.42762288001594373, 1.4203835378724974],
                             [-0.11354497196125653, -1.3305775265089248, -0.2729431011809158, -0.46824275085591999, -0.83967440848749675, 0.48837988632285179, -1.2821198703306336, 1.3689046501630606, -0.28074335638903419, -0.017757036266253051, 1.2968002571379891, 0.17378163735518226, -1.8990100761180311, -0.32197708708203898, -1.4010854898869416, -0.57368373358325275, -0.93967484269471691, 0.43693765425241382, -1.1375122080755138, 0.16872441189313106, -1.4839703349410327, 1.0536398919212426, -0.36786930311034977, -0.2205391770745202, 0.059274982926986075, 1.2051199364430343, 2.1254627359691809, -0.89259845454305609, 0.28626949098404048, 0.99658564278689565],
                             [-0.78136730950167865, -0.44471381226476026, -2.1457827475719164, 0.80334045769927775, -0.29275874502267812, 1.2924197928349537, 1.5565049644597231, -0.78778325062363475, 1.9157479664629129, -0.19212529579850496, 0.038294200363503249, -1.4196809995728261, 0.90395155319993215, 0.043356762668849538, 0.21727753126978919, -0.9014474436884472, -0.26342005193031826, -0.78912444856156305, -0.6022328204463272, -0.075672192533028149, -0.23207838226738686, -1.1417958791098157, -0.63921922551874066, 0.82139286796843825, 0.82725332268198726, -0.78753683889306569, -0.76831572755309008, 1.6446165931643992, 2.6207878678555185, -1.0350554818824587],
                             [0.76860482316314083, -0.84732085688132108, -1.4392804353259976, 1.1833352290434089, -0.36875443750504272, -1.0763800329862299, -1.6399964030981695, 0.48678809673719425, 0.51403350794154956, -1.6830730461802843, 0.29922776180150834, 1.0485952147929347, 1.3081776633455875, -1.0706181785240088, -1.1307947880601432, 0.45232062195349998, -0.29147774639150853, -0.025292639933971371, -1.1219312362855876, 1.4984472903129764, 0.36536497176125471, 0.3927893765656853, 2.156694178204563, 0.79074369147358969, 0.37715928133147475, 0.014354439142076146, -0.84822856506663968, 2.162402142048379, 0.63560378716215449, 1.0135687691963404],
                             [1.6000384919749417, 0.91805695963252576, -0.26216211292056718, -0.50998807666403856, 0.67240126747240281, -0.58323533155987672, 0.31396788748007709, -0.0082953803406174541, -1.1247738465153134, 0.50682027886979231, 1.4211960384783671, -0.5732642909825818, -1.4171464065873118, 0.49935933098744711, -0.51776050268261398, -0.70486777533521727, 0.94277923604590952, 1.2267580988685296, 0.43313779194145197, -0.38844107995226473, 0.72508040052973832, 0.4994413344867274, 1.0674272832139546, 1.3441700909054219, 0.7686815620936388, -1.0245054828449174, 0.37060344774597132, -0.256601529471298, 0.86288033008597487, 0.42780796285313183],
                             [0.68576609671031596, 0.72930438837323197, 0.79428659040617389, 1.1843666095636833, -0.48294606867612033, 1.5961795590144379, -0.15987388652704462, 1.4453967314775369, -0.083925316098647701, -0.15888182022152336, 0.63953005277412833, -1.7704870207321164, -0.41887894070165127, 3.077495195493912, -0.79414372603733485, -0.95178633501643117, -0.50186925522011805, -0.45838023331813532, -0.67796419958177945, 1.9792518565797819, -0.12111056418675679, -0.8309307706914375, -0.30096997944130749, 2.1428149867831476, 1.5389277753683757, -0.10766167813369001, -0.26381451562178565, 0.31800528391930305, 0.20368340273516847, 0.81449542774417605]],
                            [[-0.31903205303558702, -0.13366492731610402, -0.82277140862837539, 0.59903752792361087, 0.19392787974726275, -0.15282590028358145, -0.08443889651213457, -0.25935070119775033, 0.32237650852001776, -0.10065582995608904, -0.51656823798340323, -0.50919161664577495, -0.028022138749889323, 0.08524196909409687, 0.18368145768996261, -0.33301602547291936, -0.6811938051983446, 0.23717111280150507, -0.40473686111424295, 0.062887603431818859, -0.27625011758974105, 0.59917834539379899, 0.27220165944732311, 0.75069983646440286, -0.082801441213678745, -0.41171653754209214, -0.24502689338042377, -0.1382540874929431, 0.67090967669625901, 0.43929229709950968],
                             [-0.086341800431239735, -0.12377012183957858, 0.330607212629007, -0.97382308462566047, -1.4652903245330204, -1.4818916324083851, 0.36497721611413098, 0.1332886141209651, -0.60998142329303662, 0.55863968311274848, 0.32709524444310567, 0.45734080294412244, 0.071330731762810115, 0.087413977236988669, -0.97179081670711154, 0.8121202776015265, -0.31233058834275573, 0.14998534499557006, 0.18853794629251122, 0.74550740356750833, -0.095616710688929824, -0.56782951306553398, 0.28175804477882188, 0.17615774373646226, -0.0262266515287366, 0.55569983892678199, -0.1605714294312876, -0.51431728599437188, -0.18125252957445626, 0.15491905207854814],
                             [-0.3125696093090356, 0.57131241748372485, 0.041693326504126632, 0.84534871403271594, 0.68025625481021579, 0.22425871341765555, -0.47910333465546656, -0.26715753086398836, 0.95607982698690763, 0.13725692974769815, -0.10268672328235169, 0.29361192619255067, 0.24519993153348116, 0.32958877640711309, -0.85433910799219537, 0.37775024834866699, -0.027737922636226629, -0.41312139989414665, 0.39976951967311269, -0.095461246919341491, -0.76142531214313891, -0.36142373569328123, 0.40383830182634572, -0.1942692048593381, 0.29255108504880367, -0.069148097521140178, 0.27379568233114948, -0.32253590651499314, -0.0052608592219061754, -0.26064520888397397],
                             [0.049569623485588313, -0.44725214260801655, -0.39781609056454009, -0.30839879657193875, 0.023080088132892224, -0.11656214896118339, 0.97112555642981857, -0.0082367355446298883, 0.74425625801716866, 0.24827114614436616, 0.086681709560666328, -0.40626377440761963, -0.65334628263842043, -0.1576717400758493, -0.21469063220512974, -0.49505455569718221, -0.18016922761115403, 0.67647388345725679, 0.17938836594220378, 0.54128012490641686, -0.42845610891970776, 0.24812168790013203, -0.27459531084793987, -1.3067119625948234, -0.18201498670329749, -0.4466089711564375, 0.35936139413847817, -0.26457839753606471, -0.59874343146264342, 0.20276007672321483],
                             [0.08296087411251174, -0.84125857724767517, -1.0891553529842386, -0.82718065133969287, -0.51824250893012891, -0.24351374297998812, -0.024089867612305131, 1.1785609016569973, -0.17069528348538265, -0.42455425607477409, 0.29910401507836176, 0.15736763748656052, -0.83084218441696256, -0.19720672692757191, 0.34163659642616789, 0.77003325525736621, -1.2376856659130431, 0.62376200097184409, 0.28151837531717322, 0.13728288263115268, -0.037524210177232974, 0.75329821568462874, 0.29088420357124362, -0.11699108396456033, 0.79019500283811073, -0.031428524245607228, 0.41843017058332915, -0.21125226047972964, -0.15442837479484633, -0.79413203325272841],
                             [0.56954097840176143, 0.9070161511580056, -0.63301145095747691, 0.27648502146456105, 0.031465451783020251, 0.70913659645588956, -0.48041440896123422, -0.59829868884745863, -1.1025939839481971, -0.86482116255087271, -0.21216850661070571, 0.049490927179563729, -0.16008641720041, 0.13388646289998049, -0.62557566482140103, -0.38847589398227927, 0.55856688249026254, -0.11616951327230823, 0.11081624756877639, 0.41196811843089909, -0.37087735376073172, -0.056313880113615988, -0.059865644018585892, -0.33870644235343533, 1.0234351117639144, 0.44181290045389882, 0.10113311356645717, -0.11648348752630391, -0.52148677295090617, -0.061902515398873682],
                             [0.47770834618272134, 0.30514249040063912, 1.0976044266889105, 0.53279263479864047, -0.88828018736312864, 0.55743819974445996, -0.24145240556422148, 0.86103922462558924, 0.44342214880257391, 0.82464206155397235, -0.1298301892173287, -0.048423869111351867, 0.57003185588999949, -0.14459519535698195, 0.087807113853310914, -0.12826310559044449, 0.18484097891693316, 0.88464434036592188, -0.87220424313850031, -0.32892214037470263, 0.90040289964810905, 0.73639616777616912, -0.81825667859253992, 0.55621617856880923, -0.08533661143914828, 0.027558686146039808, -0.13460266294754009, -0.33662454919349877, -0.76808886587485914, 0.42477250384142634],
                             [1.2088922123026167, -0.47063001332250265, 0.8328389901429315, -0.57097110232005244, -0.14243359460046531, 0.065817964506944104, -0.049459553436579567, 0.0049082774392324238, 0.41084124553991314, -0.83387562882194488, 0.70966687456095279, -0.092536994710968129, 0.36061861071586682, -0.042739374202181823, 0.18642028076990277, -0.27226178398837164, -1.0662600665971143, -0.15574181793732716, -0.062634849026061326, -0.23577926015403194, -0.91864801663038831, -0.12047080461895421, -0.20956279540630399, 0.63728518018210389, -0.69202049743336325, -0.58088855268791162, -0.43238393934402802, -0.75324053067207575, -0.48207142526753827, 0.38896648351691965],
                             [-0.61074656842064046, 0.81859617214707558, 0.43632079413084157, -0.923684388575579, 0.29535427045928109, 0.25508065805665048, 0.24002425872443492, -0.34242162340844495, -0.49549576184393185, -0.41645760823722988, -0.22518547384950849, 0.25194253729770444, -0.82848187162314002, 0.25457173035695707, -0.13815432227099553, 0.079114515983226968, 0.39058827532792439, 1.0128277230789602, -0.45299586983798401, 0.62563986594131338, -0.58376253696217906, -0.74430059006043869, 0.079194548305581522, 0.35148712342600463, -0.010552285882485218, -1.535792115844512, -0.90540348310010021, 0.081832690581582573, 0.41232840628526912, -0.095611106509012195],
                             [-0.25531886436438267, 0.48411983631115613, 0.35554454894466425, 0.51718129529882428, -0.33647192914376362, 0.17451556774417554, 0.75883122179987994, 0.19197623293868912, -0.41531924924564451, 0.29730694266042046, -0.40953338364838698, 0.43366740605824666, 0.28878437944593066, -0.052620877486573778, -0.13054125122272847, -0.28677165148917538, -0.45003071100544828, -0.46677491853331099, 0.71982649953569589, 0.37528474434651937, 0.27572467050487537, 0.44876093020496916, -0.12953780496696846, -0.047335127831131266, -0.66405416240540671, -0.25636899482875597, 0.20899869121516468, 0.67386329194234551, 0.46348654221034113, -0.34704704679253057],
                             [1.1716545073828766, -0.88842100218354558, 0.097529074878932392, 0.29906587240881027, 0.18512605264686818, -0.082624184689734259, -0.22450992841834708, 1.0811300972174152, -0.19483322836512024, 0.10224590216011874, -0.22937589301108954, -0.33967594323072947, 0.7405257060200281, -0.40756096957997678, -0.61524615349282652, -0.8924461456438797, -0.55916753313799528, 0.039128206558969897, 0.32469742891890557, -0.17765911390999933, -0.53539151950864605, -0.37362270930747787, 0.32569136544742194, -0.0073906763929034551, -0.16204864433607369, 0.25670437899917753, -0.3641595518556805, -0.10861946474861871, -0.025041084044059067, -0.022892108934024713],
                             [0.4360101418584364, 0.60321972906475552, 0.19377376317668402, -0.51483299997295906, 0.357090548180238, -0.8589439235800348, 0.15302102650533347, -0.49534178412976093, -0.16432337377003262, 1.0805758690967315, -0.65611730442935301, 0.12884207561248306, 0.27909005954503258, 1.8000430496027939, 0.78631547146074532, 0.31887902740061763, 0.059762482699365189, 0.44663103979576685, -0.10270560511751532, -0.55910409820918128, 0.51018147264932234, 0.48107102376963345, -1.2121164457014293, 0.3312387324872208, 0.016341875973937492, -0.10031799600356027, -0.53253093228453796, 0.026054101367602604, 0.17340015642484632, -0.1084518083271076],
                             [-0.58632365832809663, -0.10176971065992771, 0.22941784263704251, -0.4864442881881883, -1.261489498063141, 0.15319026215025699, 0.20234324790493213, -0.31977034364593587, 0.40111586079084177, -0.32062954841424168, -0.35492085183551714, 0.50565661777703608, 0.97214797500444872, -0.34586860139109332, -0.68679714199474073, 0.38219766447642028, 0.72442043098817288, -0.2541993155593183, 0.21391738691351908, -0.35414137415331598, -1.2932116289576101, -0.91802552050489705, -0.51299326762631514, -0.31477604081933397, -0.28664473308462524, -0.84370506963522673, -0.078841377117773892, -0.36501792122441412, -0.24745946434198263, -0.6897717605980721],
                             [0.29053456839441338, -0.91995112823702607, 0.69566432129520883, -0.34141654693544049, 0.098476202607270635, 0.45684185616880141, -0.11579176701558205, -0.6017681325501093, -0.47923960558574308, -0.15809056942071581, 0.59205117989902245, -0.26258318248499846, 0.071618736766539709, 0.049581372829059431, -0.27810462533612534, -0.028776309213033278, -0.0311096232641268, 0.43594118864139347, 0.35679767274600449, 0.058137180300827034, 0.7123151701729713, -0.26481163395390972, -0.90011853020578469, -0.54225659569056106, 0.40385994505849521, 0.10576996529704219, -0.60689165857161098, -0.64283615194122323, -0.17185106903015387, 1.1371306169373678],
                             [-0.13199403147708244, 0.086806742633741676, 0.58997166347333774, 0.29913774478318172, -0.28934526108845576, -0.24898858128517559, -0.093415608544756973, -0.087173690989816713, -0.55971525026498503, -0.54392975227221541, -0.88710081396415075, -0.096919055004205695, -0.34559144452976015, 0.53680420403773565, -0.31485459870334503, 0.49028630498072695, -0.31420071883356449, -0.47445171715748052, -0.52289901762864666, -0.37981380160909867, 0.49454518601486752, 0.1597528584042836, -0.41873402880068239, -0.74245474179198434, 0.40070334893214488, -0.50881603201248382, -0.2788545128373725, 0.57014374472947427, -0.39923763790510453, -0.070130535106325734],
                             [-0.69476515947333439, -0.45702684822718098, 0.3236465148826837, -0.22337694070273123, -0.020414218055930525, -0.19100473052842287, 1.0001200825051233, 0.85296040841051701, -0.98189324293519764, 0.1504559621047859, 0.18011253122827184, 0.12415864556126004, 0.88849626647636226, -0.43384068391413755, 0.42564805001817446, 0.048946563052422669, 0.017618951504238096, 0.26259805786463292, 0.018466968207142189, -0.25832686905083402, -0.60813513593584312, 0.38354020498628993, -0.26834858759633967, -0.54082643973855793, -0.12460068663868076, 0.69114990037358348, 0.079391890911426122, -0.73680897984579763, -0.18002305227715937, 0.5558175984495608],
                             [-0.5462416243536784, -0.80324336839426624, -0.0091211642407484639, 0.019577097637953539, -0.74966118128145864, -0.027142233567810641, 0.80485668332946114, 0.094052390045442677, -0.35196665099779845, -0.51172773437787167, -0.031027146269457056, 0.82269077477287555, -1.6441956550178713, 0.38257271675818577, -0.22041094135906056, -0.53444025935842954, 0.087060068701226373, -0.064703852411756607, 0.42940094916608712, 0.13283979683289412, -0.32441032093335376, 0.30933937374266363, 0.090336348888360854, 0.40640445137995829, -0.44145022588525507, 0.047963841072843079, -0.46097623466425047, -0.39075209395771615, -0.25391899208868446, -0.12871064047441272],
                             [-0.55301695126652761, 0.76864120464395247, 0.56369206585074327, -0.3612715323606322, 0.12033729558862091, -0.37581669186518096, 0.10486976859537578, 0.24715779121397469, 0.64960177315282797, -0.65028912947475104, 0.55461969208329465, -0.79390375964045468, 0.0032594357850731035, -0.44453504484849693, 0.0023133721203952469, -0.45814716127790345, 0.057607182459331455, 0.045932167209125782, 0.54823958138050688, 0.46624736041467374, -0.56169689210104712, -1.0319033305774981, -0.43143955458885624, -0.27129081415657968, 0.8906538571699445, -0.40154519458655691, 0.16706351371869618, 0.40757391069964194, 0.78477301486558648, -0.34229762437757466],
                             [0.55806807483663157, -0.5183683780062488, -1.2151520281455102, 0.67869966330926923, 0.070508087222303617, -0.73521062315900221, -0.68839675000247624, -0.55316480938131729, -0.58257127574130829, 0.057911349600723729, 0.28724821500114189, 0.89397327953529471, 0.096984513996499072, -0.36400425957310417, 0.96098643072997647, -1.2068117682662642, 0.2877528095071713, 0.40957205660688234, -0.34776278773310987, 0.73027116026196914, 0.62858627075752493, 0.47142655038451597, -0.8614996059697192, -0.29592996279219502, 0.19367976908435219, 0.10394558039535359, -0.53140481941544637, -0.46394027836458274, -0.089089657127925798, -0.03041859667077644],
                             [0.21113027888022984, -0.32417578153851118, 0.36693927705965973, -0.66432014502946035, 0.25629469088963946, 0.21472325808944737, -0.40451637544455188, 0.050960627234810874, 0.44783125626557951, -0.0050214487078850947, 0.29661983972826306, 0.43063407701933437, 0.42927086129652159, 0.89475902652870554, -0.31136098654479133, -0.27978439143950068, -0.49284561499718293, -0.15642464005298518, -0.20356093453214999, 0.70111080479656751, 0.47460499541337081, 0.55010272089476908, -0.26021067956201893, 0.02144749046521947, -0.42988127396662112, 0.54669594470422245, 0.68101181691142509, 0.44148385322656386, -0.025760317371257106, 0.9877663891098708],
                             [0.16236938727784253, 0.9921792765634645, -0.040869948956697703, -0.61239654904944152, 0.59205341025586355, 0.035056836077939885, 0.72141145700136633, 0.45282830249173728, 0.86812862755870124, -0.32004731044911444, 0.46798476329230759, -0.16013292456703515, 1.3783569049457445, -0.55732223160940708, -0.42038387897546264, 0.31085596491132483, -0.6005223740144674, -0.74619990485216803, -0.97623963406922099, 0.62881240590059539, -0.87560538830377999, -0.12365470088739058, 0.074740770027534431, 0.13127801357800822, 0.54333147343917676, 0.40999782780269994, -0.70223741510823201, 0.47488126700020172, -0.1048772286836296, 0.056401613193260258],
                             [-0.26325995087605703, -0.21850279616226953, -0.048474689905738937, 0.45503555683263675, 0.6353407708526343, 0.46610413890173413, -0.64212252815843551, -0.40735613260406223, -0.61528013866597264, 0.30572120493346816, 0.52973080282454033, -0.7099473178905864, -0.33889165218216444, -0.29538730771481597, -1.0190408650491769, -0.24353372064922441, 0.50950655480688567, -0.59374733353086628, 0.18890712221538453, 0.1588651034025344, -0.10550776148217328, 0.17463167655150136, 0.25166636319533103, 0.35525279862417325, -0.20100233173051268, -0.74279123726674068, -0.21498231400522813, 0.69571845183536585, -0.3512773418058448, 0.1210910967334968],
                             [-0.052706672089361424, -0.37735358763623844, 0.21520091636149874, -0.18493213164968875, -0.97764536544264957, 0.41501157328904753, 0.064981373752334065, 0.25365074281370703, -0.23807085681215204, 1.131791942211595, -0.063139843474282795, 0.74099457449342121, -0.20648494040714224, -0.049918047220996714, 0.097133250940296359, -0.38362383093599517, -0.13873444920560352, -0.095539327140905683, -0.66903874761001225, -0.3840292865376212, -0.34976372268870687, -0.097592934394464925, 0.20254823765775182, -0.97519022657709842, 1.0111319119800257, 0.052739480455888513, 0.59742156423699744, 0.31677705089770591, 0.73356216205143188, 0.30026349807830793],
                             [-0.57412985252739401, 0.53157211575547536, -0.57608176216898599, -0.76998212720452597, -0.25069172828874847, 1.0744725056483748, -0.57218531410023399, 0.2074672376827868, -0.73510313016275264, -0.7293754782057148, 0.5909553979315435, -0.1964697918793413, 1.0909835296514274, -0.16420667013888762, 0.085780273192829548, -1.0602245903496113, -0.41986838517568059, -0.92783115547452399, -0.80682295114174618, -0.1540699921790909, 0.72875132255305741, -0.46102327555999056, -0.094566522777261131, -0.30002368485698555, -0.74159710466358908, 0.24998993921863402, -0.076719424595476565, -0.24119762679765658, 0.82028272070503316, -0.11140742225476251],
                             [-0.47313815667993203, -0.047202193027453786, 0.54359766867961601, -0.50831668152739129, 0.55282665063794667, 0.19165391194055109, 0.36901163368522721, -0.57315203992806685, 0.1611484399072412, -0.14406909182395772, 0.048674127644052635, 0.062278274459965352, 0.49391809104753343, -0.43597819644463442, -0.2637456370968691, -0.87526973738962899, -0.079002334960264417, -0.1864571018727478, 0.19090696129549184, 0.4421057273786167, 0.89719240150968149, -0.74734205197231329, -0.26474061651225922, -0.41133111697909081, 0.94224205401317251, -1.2332913727730408, 0.61561402547286848, 0.4009857099637878, -0.16781980610895036, 0.25577177993573608],
                             [-0.66814736852079426, -0.6236128515532664, 0.30399601252073072, 0.78765596010456351, -0.41792507366357556, -0.20587428748250899, -0.051297338915481008, -0.24273314208356717, -0.070935875593138367, -0.11459149050521604, 0.029523941878597044, -0.0093749295656440357, -0.26975004251683721, 0.64043906475607404, -0.57202799228051615, 0.22232129941857304, -1.1976815675318249, 0.42326152480592549, -0.031632708141428392, -1.0177050729824715, 0.75233124136841967, -0.66622332208236323, -0.1603037321996591, 0.17751163824938276, -0.34218539712523466, 0.77999389788837503, 0.6759677213831744, 1.4686957146686566, -0.32568855089258925, 0.8872603585569574],
                             [0.8900724817028558, 0.26899680265331993, -0.069986278792962459, 1.215515338071409, 0.44998540284428923, -0.4833328128773911, 0.8965305591646896, 0.48167425195872526, -0.73843854692864852, -0.17413327787304911, 1.0604310173102778, 0.30240979301211812, -0.097817392835697986, 0.6231643185475263, -0.2608263098189515, 0.72637873525260743, 0.83914591303937502, -0.89499837961335738, -0.1995563796326594, 0.78763150875529875, 0.088692801122061016, 0.016251001468433723, -0.10105720216108281, 0.18702072984887294, -0.095443999773989097, -0.0035699456925472571, 0.044099816218848148, -0.72151866851839053, 0.5113101652290819, 0.48087861829367595],
                             [-0.65489652031267886, -0.27633919035061488, 0.55211740617217198, 0.11238547860426405, -0.92022700719949091, 0.32837548580847298, 0.11994687156587076, 0.031632204810907637, 0.54230802574027637, -0.041993498673747173, 0.16685597235078925, 0.045289753296852552, 0.43412074915990384, 0.20634745493073967, 0.5204900393386156, 0.10911493816896758, -0.0010700619096878014, -0.42180364677455784, -0.10006503181426371, -0.50765683405633766, 0.22638037292208182, -0.4290874253371762, 0.81464196711035985, -0.45905889872092365, 0.092124939412345147, -0.29928861421092678, -0.41780267900348317, 0.29544521078086639, -0.27211435252754951, 0.18015205506129389],
                             [-0.28582998311147811, 0.15971433921906678, -0.12070493562630343, 0.097681230384120979, 0.11315700002162708, 0.90808771204436778, -0.08828390629708173, 0.97200065559608195, 0.32000207533170238, 0.53671539289022674, -0.15037371835688612, -0.6903666590329216, -0.0076821332092887936, 0.44605410852586463, 0.53800200149650323, 0.42965096556725529, -1.0727252940541363, -0.90184729601918456, -0.0086334384640452989, 1.1171491053961653, 0.18510759365785598, -0.79039019183093473, -0.38960562107189955, 0.59915762413173035, 0.098974482550366977, 0.21162213000725349, -0.53678339602540626, -0.071075172374056889, -0.23948324963693748, -0.048794585245103703],
                             [0.0040046401260571407, -0.67275331447722875, 0.74012253109783188, 0.82612347989343704, 0.00028780587542185266, -0.040648469458192088, 0.66512181055454089, -0.28376599715781081, 0.38984371850555999, 0.48776425191857015, 0.38228361493243013, -0.95213178644059093, 0.10266137404768848, 0.34361390023994898, -0.84599753404205014, -0.012361434635405701, 0.65408180205141875, 0.40494781752754433, -0.50496708703438431, 0.51795665847686367, -0.034880595344972343, 0.18788267527836222, 0.066606591345668917, -0.39417110422244278, 0.28286481687011916, -0.36510401725765745, 0.95343821615306334, 0.013453186777797575, 0.029857303169347822, -1.4402988553375236]],
                            [[-0.72688254810979946, 0.58776233140182865, -0.00037980023123923567, 0.60636305877086805, 0.2572365612059816, 0.4068130815835192, -0.72983657068984176, -0.57428323914018664, -0.44614211705480578, -0.22834149906168846, -0.20189494859706186, -0.43118577405230085, 0.21410624748823098, -0.75571828658624418, -0.51829617586036114, -0.69505062022657405, 0.67134374334084079, -0.50887238137657687, -0.23819425242149134, -0.58563887988553742, 0.11479024510432939, 0.35611303317951404, -0.23560816732980558, 0.12213120340106592, -0.028027286600256218, -0.66292255660486621, 0.82629111525712062, 0.9507874766548956, -0.77133566289322886, 0.68563730484803398],
                             [-0.31824388099103956, -0.24717897434459188, 0.54805456157425847, -0.10122478914659677, -1.0402817600704204, 0.39133322244885727, 0.12598523121374483, -0.37264700584265154, 0.52295392118055184, 0.48545039587381517, -0.87041815796547528, -0.12380684536658104, 0.12817700100690793, 0.54766671299036618, 0.42452030548574471, -0.23978724292130019, -0.0067317159884567879, 0.26171813136791111, 0.19619853366513751, 0.61267634024065454, 0.87020276017678211, -0.59833750623635451, 0.74573550577246295, 0.38969920751307874, -0.32508686679387849, -0.44891735229253726, 0.8165612679943528, 0.37823369778667221, -0.39753695306958392, 0.88460099321251695],
                             [-1.2323984656201072, -0.47734270539634893, -0.33804208363569288, -0.28918991919259263, 0.055714457510097209, 0.36550015717357742, 0.066353617710741178, 0.13200262741693111, -0.2923752598039131, -0.22366365454364076, -0.26634935370666396, 0.044064365821297545, 0.14059179509688688, -0.096934415923362202, 0.40810615521048288, -0.47315707471330953, -0.34113800084595197, 0.17862729822048048, 0.42039390570784996, 0.52017142533825211, -0.19792043728556383, 0.63256048134737941, -0.43687730732007385, 0.24220696841227871, -0.010294007960570818, 0.68116958691231433, -0.41783152919585947, 0.0073832725922233881, -0.91772765583397786, -0.43042983052691591],
                             [-0.35413438190507374, 0.86472971188831116, -0.23040352872230516, 0.15847030799868647, -0.33159705324393512, 0.14547578127133581, 0.21662638188378935, -0.18779797574296681, 1.1959689575060166, 0.41934320887971305, -0.0013880558075042154, -0.5513491767321651, -0.053520506019877942, -1.0408937796103921, 0.1181419841034244, -0.36028649277071495, -0.59284744299467951, 0.94497384829140252, -0.40126558758413278, 0.2735888136706599, -0.67978080381256645, 0.51104413836256879, 0.74036099533868016, 0.42862613018987167, -0.28005554516654491, -0.38552474741796233, 0.0016694321704830914, -0.73803198335569009, 0.53004838956638045, -0.88308141048513855],
                             [-0.174943396626352, 0.69621579036992021, 0.1485577410211204, -0.18581237631741959, -0.14194183298798285, -0.10964366388527301, -0.29504441561779188, -0.67262541579963186, -0.46155497010473051, -0.16627619076096969, 0.6994043934270191, -0.15385408031531692, -0.38611003436183378, 0.37075276781301369, 0.15485443130326301, -0.6979562925027214, 0.49815255097095595, -0.52830103176370535, 0.26713076650363221, 0.072817411733837017, 1.3166046155787654, 0.062015553938120978, -0.063819887373364734, -0.16871399254664787, -0.58741266522914815, -0.50085865579630262, 0.50479432329286344, -0.14726381234817937, -0.26049060625878573, -0.24729967258180277],
                             [-0.37927007835357901, 0.69567250158755423, -0.53727819059691106, 0.33548867303671698, -0.28373128733734043, 0.066624172727042463, 0.69567736392732138, -0.34596361827956662, -0.84419241963976543, -0.0060893609668936531, -0.11190859357950561, -0.43187590214933846, 0.063665858174953904, -0.42923898586633902, 0.24472681260486989, -0.3783266937093408, -0.38054337113404491, 0.991420434347835, -0.06160570891138871, 0.30796329548974244, 0.95294311104523899, -0.45933949023163478, 0.26304649606343145, 0.72456504946875355, -0.5044782722851654, -0.16863773210944452, -0.014247936719990861, 0.67004822909357442, 0.6523647835985561, 0.68211653737119482],
                             [0.79584926387954924, 0.19029956068856951, 1.0356170955230219, 0.052668524099719602, 0.34437139181948762, -0.22799293078788724, -0.31777745436337401, 0.58968159179613044, 0.65265404430330665, -0.096364616090463123, 0.21557124530092148, 0.75543246651375462, 0.68425332503093617, -1.0382428931863656, 0.16105058829939542, 0.050687839901894842, -0.74660349704424001, 0.63657611414296345, 0.22101060130912512, 0.48739438908767196, -0.20466033859719179, 0.67651259399497621, -0.60415845620005271, -0.42646796010724947, -0.57410526447197496, 0.20680503176633902, -0.39833998251115998, 0.31710212537121257, 0.04445975254063228, -0.24129247903597714],
                             [0.53446932264584912, 0.52372611266130631, 0.51341291149804469, 0.014288679913195552, 0.40982046630594871, -0.2496084109873753, 0.0936401392313332, 0.44553850164433723, 0.20959643018013102, -0.36134686077054023, -1.1860556064502139, 0.59698823998580353, 0.52696626478996889, -0.37197691358973251, 0.092027638024429786, -0.57584309231331043, -0.3490406104372023, -0.10918643939347306, -0.25632252700874614, 0.49730351189334521, 0.25982714183250033, 0.79047932293353662, 0.64807435731877183, -0.45021828801322089, -0.026665474042976936, -0.099144088903248745, 0.47297987962253268, 0.48641626308451141, 0.2466166916956731, 0.32436306369235163],
                             [0.49123072269393642, -0.78444200334212599, -0.13218368241414147, -0.36357196729770569, 0.49027057646252142, -0.59287384906024787, -0.39261920056898131, -1.007220177135747, 0.56417881173602069, 0.080392763458068311, 0.20557434237309055, 1.3285009895557276, 0.024304434391997587, 0.21745479266359496, -0.5978461969392368, -0.21479575568762582, -0.47434354219374864, -0.47734810573004588, 0.31869743954427859, -0.3613403024486268, -0.38149211687528101, -0.57433781545343698, -0.42367952139063214, 0.092470896663022092, -0.30355255189347363, 0.19342092967842681, -0.68822605669772974, -0.36474272316437795, 0.058497920710809073, -0.48504679778753851],
                             [-0.35897776866205738, -0.77481833154490265, 0.046155115032002703, -0.71065588643338395, 0.065616604772561371, -0.63255694489592218, -0.016759324329348804, 0.72375484970883497, 0.602570285371262, -0.12089460567051838, -0.24276339614137166, -0.69166492112687183, 0.76821776067144243, -0.31382635352623134, -0.49610784313075096, 0.35689355268306677, 0.22112939317016139, 0.28050535156341627, 1.320067873767788, 0.082144386210681486, 0.6894203881001213, 0.0032871177860776604, 0.17451322389125612, 0.20636668513622147, -0.42033246151142251, 0.071145547298670675, -0.11427029979331295, 0.72574937639040571, 0.42448786715990316, -0.052572358742609626],
                             [0.19984106181200928, 0.23462172457230185, -0.046119367537488562, 1.0086132962870573, -0.50766743373273804, -0.30134183697580386, 0.43692523946972617, 0.75101834531820544, -0.33546052819828498, 0.47801944479324798, 0.87313728691112735, 0.43026798331810673, 0.061164864254134067, -1.2385747079681455, 0.36550651995977984, 0.63335835432070531, 0.1410007855244155, -0.30217778776231385, 0.41379699104615469, -0.14855731762688218, -1.1379638004097254, 0.036496660629613834, 0.54917451695849495, 1.2758153715680964, -0.4597100904502337, -0.066468131837382455, 0.4155908582180633, -0.96828216802078182, 0.68421391460369829, -0.41250517184756985],
                             [0.26626904693773429, 0.28084646141391933, 0.39680530257247909, -0.95449354854980761, 0.057035321585910334, -0.22883260704254593, 0.27501874321960862, -0.7598376758762464, 0.35712287128458525, 0.29033946244331965, -0.30982051171847885, -0.075753250897984001, 0.46740062876146937, -0.32599953532785408, 0.34680355314601208, 0.44187636341570607, 0.48334518760772027, -0.66447602622273361, -0.77494805176039827, 0.29742727093147786, -0.29774908283821083, 0.043085063370910587, -0.6446284834389211, -0.22959434791639463, 0.015908172627673758, 0.064949346880632627, -0.18717631961061459, -0.26786356768970221, 0.57061605704003382, -0.35084942897076571],
                             [-0.079118800959107949, 0.035429317031275109, 0.28194127156453352, -0.38113633907366656, 0.76093364087594151, -0.040738808700972184, -0.39151249791174447, 0.13209343447814978, -0.18167557465999157, 0.18444621630589217, 0.20067455543208615, -0.31588576380756245, -0.19670493884099552, -0.87080525134234144, -0.97984597077353053, -0.28929293073486056, 0.84559911531464382, 0.58781253624872876, -0.67369660681189836, 0.64356008300580392, -0.90887218824256322, -0.65909266326876936, 0.0013048052088111967, -0.22242382748740269, 0.1531202974503412, -0.17975546054640651, 0.67905014999867364, 0.17501435902717566, -0.12338607916475713, -0.29799946392226445],
                             [-0.14206638763643056, -0.70599370529480887, 0.39821915545143527, -0.47891892946892095, -0.48449290023454872, -1.0672220728668351, -0.21383463914252024, -0.43193976220796376, -0.28447433658398014, 0.68442155876735877, 0.0083186765746981473, 0.50586194255092676, 0.28641334716131778, -0.34331721843142005, -0.39086430824256474, 0.66840474088691804, -0.36567057395739572, 1.050675870426564, -0.071433757802398426, -0.34886543017660626, 0.34580567626859493, 0.38498040644641596, 0.52866258355984441, 0.40419760569781338, 0.24318243923865374, -0.92424856631830532, 0.84054963316215514, -0.46033969550541021, 0.21213034428019645, -0.56935211353057491],
                             [-0.39008174497470549, -0.52679684393864867, 0.40006581737189878, -0.29618499611226234, 0.57453674083430395, -0.72065364534855125, 0.53031148916077986, 0.063452945272286301, 0.25853936628044244, -1.0549574966470181, 0.3206896369929193, 0.32603594852529022, -0.17938763625191811, -0.70865545801969465, -0.096156485232194736, 0.42014141223476087, -0.88278258053745229, -0.15186495559076107, 0.54568066863947007, -0.0085345664956060878, 0.43958205513219245, -0.16489980112477037, -0.96956091336914996, 0.35655788555540358, 0.54664824126504041, 0.13750435166871264, 0.43316996562837107, -0.30985135990527263, -1.0893641225957269, 0.18070687534135998],
                             [0.54824730849368442, 0.85143332592866972, 0.030233745206890782, 0.36375953713400072, 0.023676209180137651, 0.34509789759985454, -0.21441256953396401, 0.65954465598405476, 0.063832686501833186, -0.60613457335352272, -0.052232477871974381, 0.29346362763457928, 0.71668554652181493, 1.0350953905401856, 0.24889553581012688, -0.66914374857529269, -0.16298478181390227, -0.29617213628430927, -0.67286708367907566, -0.92942698908460997, -0.0049045320015239022, -0.56511079935498998, -0.069525664148843994, -0.93261390094884655, 0.069041777330927673, -0.24082012343026027, 0.39763722353098557, 1.3044131842750568, -0.064060984473152324, 0.048131078266592714],
                             [-0.51070778266223193, 0.31089204700161499, -0.26162089522985094, 0.18011798289163033, -0.11107404454330666, 0.72599696219783794, 0.51190377762339334, -0.52964431441635917, -0.76970614586710806, -0.39781882068715091, -1.4126055300998637, 0.81566520501369655, -0.075868475023159451, 0.17716423062567305, -0.68472308974074814, 0.57873405499868136, -0.43494038554199316, -0.46805344192436243, 0.30711337182519699, 0.78448021088253472, -0.42256507588350228, -0.1730896517594534, -0.44400788808442915, 0.16528782695248928, 0.51517873649114643, -0.78091621791917742, 0.77419673324812266, -0.26145696368245541, 0.3283280195001349, 0.043440128105970442],
                             [-0.55477419346322687, -0.71745849035636133, 0.28910121163514729, 0.27161733516152076, -0.90348336724212941, -0.59504457877975692, 0.69942284470654292, -1.088598438491204, -0.0098832851586656001, 0.067430355784102891, -1.0548378400786398, -0.35316907125341679, -0.76076065818009231, -0.022704256355944197, -0.2219669739271346, 0.81436648378152343, 1.0497561870293548, 0.83830472968722114, 0.3345009802062977, 0.63599687405066274, 0.63059866925198826, -0.27372274164755261, 0.16183191773247807, -0.24446847370672156, -0.70797179345091032, -0.1693038088093376, -0.14032884294884357, -0.56394405348814214, 0.013865397527870089, 0.25476781598281334],
                             [0.30141300727004283, -0.29492687120881644, -0.062658524078425037, 0.31772299340609461, 1.2348319457555574, 0.47418073780257508, 0.99836629352018902, 0.12160312444600599, -0.80653919512451355, -0.16282971514311223, -0.54633499422104337, -0.45306990123446306, -0.82865769153601487, 0.42127653656447084, 0.11162005963159635, 0.51293311853062795, 0.58311583868391814, 0.16182819319004971, 0.50693447238272116, -0.35598392791610622, -0.12140387697362459, -0.26155407353847215, -0.18265600437488294, 0.66526800042725187, -0.83887380675628109, 0.024215602413015659, -0.21442056461374825, -0.34167182363375542, -0.44013820294993283, -0.22256447799393547],
                             [-0.36538377878580242, -0.52547924433032245, 0.17369976111975122, -0.032716621772186011, 0.34005839407457217, 0.4850354942163525, 0.05687477743722797, -0.26473406947224626, 0.12030481150312376, -0.3298820887172611, -0.21806925085967022, 0.12861457639848059, 0.2680897596505275, -1.1603660844274166, 0.49614945576190722, 0.3426996384669484, -1.0009508676301619, -0.07873130820130006, 0.47435611258110538, 0.032134640193800537, -0.14686698450039737, -1.0833127650656715, -0.22699133645420219, -1.6770003707679935, 0.038944307500151806, 0.84276120558278012, -0.4563315007335122, -0.11836471079295754, -0.2105286174994308, 0.36076099845752363],
                             [-0.40942108668258537, -0.96472895120671454, -0.34279962709572309, 0.47705999099150731, 0.56542252951776495, -0.059593141910113098, -0.060894208578563473, -0.04867607642396099, -0.10166340421854987, -0.11407776184320975, 0.87686656557027043, -0.20888077797673721, -0.19395997071236581, 0.027993013294503322, -0.3091944649332598, 0.27732202840500242, 0.28300597710971781, -0.076065016424575721, -0.40919917679865675, 0.80004078180614135, -0.19281027556629893, 0.59099234638034648, 0.14371528416030696, 0.23808682727814834, 0.0055481410468080916, 0.7260386272334366, 0.63658060142333284, 0.0075062489970697532, 0.62651283068743657, -0.97802477753410755],
                             [0.036587933748680815, 0.0028694242513078172, -0.47784859076581704, 0.12351939553452003, 0.14839147464650437, -0.73276204686399582, -0.35665631412399268, 0.31108043314328632, 0.57674220861073788, 1.123657113161288, 0.27139241570951295, 0.049728359508546108, -0.38591373474240143, 0.88646355885784311, 0.4317828485786141, -0.15762529901691297, 0.36880972603703083, 0.37140886557211955, 0.2601322122832338, -0.01292928083393876, -0.81340622155562947, -0.15669447754008953, 0.38191767395119708, -0.067800933289927728, 0.27550711658189575, -0.28901350343709087, 0.37762159615879054, 1.1628700159315275, 0.2583613726470031, -0.36659391516933448],
                             [-0.41556019106831638, 1.1415143342968155, 0.62419059993603943, 0.1360946383725597, 0.64185881226557417, 0.25501785338227906, -0.45979446017380238, -0.52492267261166203, -0.056618462605908693, -0.40507907733670634, 0.62302480371508784, 0.22279275930926196, 0.33458016710942684, 0.069688415022553185, 0.48187847968633329, 0.062429029439798417, 0.38613867221728465, -0.14378480733599225, 0.99400750614669331, -0.18903463364749989, -1.2556418589877782, -0.051540283736490902, 1.113839694787095, -0.30130712315021013, -0.30435966020097915, 0.12992653427877343, 0.25844264753305285, -0.32158186422743135, -0.19881319220953239, 0.33853291453993434],
                             [1.0444473945001398, -0.72624126440942693, -0.64051851662118342, -0.7494225464336659, 0.088759616496756427, 0.15116871524239328, 0.10769567804694621, -0.03866305825996412, 0.49712812373762361, -0.36213924605054548, 0.102723924819281, 0.34068249199972761, -0.36489229151793928, -0.12623586621736349, 0.68136518350656128, 0.056249765962735884, 0.094117802034890896, 0.55687947661044745, 0.4983817841177271, 0.13483143952589441, -0.034170300688566912, 0.46431921113075802, -0.49158520813610534, -0.16481814545958948, -0.67964374374171943, 0.48591842728572587, 0.35349143955350298, -0.076519118629631344, -0.061539340010370765, -0.20267741266790842],
                             [-0.079277582717543205, 0.2690770852128031, 0.68161562857373215, 0.13707608572480368, -0.073704549575102751, 0.061863278805968008, 0.07330774973338236, -0.50440485208115571, 0.023801555726482848, -0.42737970801467851, 0.70531141974308076, -0.2578679144144671, -0.54950576681915042, -1.1888170784275529, 0.087896910940540085, -0.1226754748588391, 1.0360924228895303, 0.020769898166802803, 0.65264038179522366, 0.025657456636490467, 0.27286372089634653, -0.1428017085340598, 0.81424118568684889, 0.79122234782981393, 0.84043697672249396, 0.25449149753513545, -0.027605904797478709, 0.45245344243811647, -0.10963935040537598, -0.77173014986436728],
                             [0.65195811875106846, 0.3967702813168838, 0.027434846637483391, -0.67061962653806095, 0.61179780056912114, -0.35797237868617737, 0.57611169641018711, -0.1118207053945517, -0.097404849424662182, 0.34096643117035447, 1.1199130373915971, 1.0219841428434024, 0.7326493256789357, -0.55944164907825844, -0.7236855397646107, 0.70117436095652363, 0.17734397133406773, -0.31858385102903275, -0.15559194762517725, -0.25047175735306948, 0.4077332067390928, -0.04215446451238683, -0.35736823367255277, -0.82278819462397579, -0.52334114598934478, 0.02054383898636716, -0.068463446394758418, -0.43607627397765697, -0.30323783440032931, 0.51424169505134709],
                             [-0.039362350919517369, 0.40335894637050368, 0.41928411378149877, -0.014840989969890694, 0.25955995423990835, 0.57548651635173442, -0.20018879614250895, 0.78317020952086158, 0.049908689896238312, -0.02285848788229948, -0.060973221099799857, 0.68294832040988107, -0.59878051245974473, -0.5662649123320016, -0.40221757170413558, 0.16366789602515233, 0.64922188237794898, 0.31582438122652368, 0.071045419755679406, -0.6141037762079834, 0.4129988681284561, 0.73394069539493856, 0.24586028844351851, 0.44614549779145463, -0.88123557911432593, 1.2926476865609202, 0.4740438132808924, 0.10405720554430138, 0.20264027540517679, 0.013692511545067745],
                             [-0.80818222353435254, -0.22915852067910425, -0.3950324571618466, 1.0719397204255618, 0.88037337950552152, -0.28879977074491758, -0.3124050451853862, -0.28293527198965757, -0.63341074807077624, 0.34316915859853114, -0.31129083213670505, 0.22568042474854244, 0.40424783056586022, -0.36087111236214792, 0.48483057815579572, 0.48535675646325716, 0.17879384013954458, 0.16843069458205867, 0.93794541841609069, 0.33072460560558142, 0.79876927744679116, -1.1667417119880104, -0.14517714616591704, -0.084752063505279446, 1.7337981716299362, -0.42356060178600308, -0.39125575447027872, -1.3815400629851236, -0.42133309315720219, 0.24025256787610771],
                             [-0.81479857312703741, -0.42648749857566892, 0.41395703927087535, -0.13208486372150141, 0.069432137154567863, 0.67959102798686033, 0.71687601028053394, 0.087980780554178128, -0.50036215468885836, -0.83929843986299268, 0.37353644107941419, 0.88482448590313967, -0.010931074168314157, -0.44407321361337582, 0.35909675435066757, -0.8228962367993895, -0.021709659419588245, -0.14878338511286082, -0.16552006521158638, -0.90380348871243954, 0.058843459317913682, 0.7076811996427077, -0.97873230934602995, -0.08711541598371933, 0.93160194619867864, -0.44476710747884318, 0.045827379401338131, -0.42756257362438915, 0.3453895827455965, 0.23474652233622131],
                             [-0.8864970278095099, 0.33952153680741937, 0.8009376554610339, -0.38687394258136537, 0.1860457945918926, 0.008711136719896144, -0.41307359120724924, -0.22781861326436795, 0.20134137003324482, -1.003909919821028, -0.5030376652158064, 0.14206682654264152, -0.27893422496306963, -0.55764692445351149, -0.14748155793580001, 0.72230583697209516, 0.19696795786550214, -0.023331199779499066, -0.98841471463983488, 0.76031723200927559, 0.091686801173894439, -0.072189576613958112, 0.75551658620631734, -0.45393417244429779, 0.034572114216001829, -0.48539021078990485, -0.63804419339718166, 0.4659569285208528, -0.63089715112514955, 0.47793025568973219]],
                            [[0.29120181179266974, -0.58776564029721512, -0.15079581634960446, -0.4076207681787371, -0.078160159984163508, 0.018780682200833787, -0.52731109485338479, 0.060585324422169518, 0.0082314021976636481, -0.20243817894024532, -0.20991272715482423, -0.83454398991730905, -0.31791942232277703, -0.72332116242716515, 0.10654441373135337, -0.014682477392161511, 0.57797054720774266, -0.29030534667053737, 0.11300248283231969, -0.32215202378534818, 0.69710572056249176, 0.075435421305101558, 0.073172382989360338, -0.14246752449544572, -0.12768558792688994, -0.84284375487614815, -0.088386168889836011, -0.47901483468806444, 0.012603087680673662, -0.021839143366703312],
                             [0.63033265554446571, 0.035298697662704367, 0.013417361410334266, 0.092304655541836186, 0.29169964488671757, -0.21464567026772133, -0.24535586011757349, -0.028471352532838317, 0.10378350789437332, 0.50123355176693318, 0.8084412410041687, 0.20252736802070626, -0.58422076792761135, 0.55457166214803688, -0.82366996653330493, 0.51826726728163441, 0.31930881424890389, 0.022751919250539092, 0.62080937588630369, 0.7104820404735811, 0.78283366854481429, -0.00060805369644316215, 0.55164694512347556, -0.39161597747055038, 0.33219322687497904, 0.33882737774164728, -1.3409540257362824, 0.24330320934614336, -0.0086473910676857797, 0.27078468868793715],
                             [-0.35885616125886094, -0.1426007621523589, 0.5003774569172369, 0.20139526599031352, -0.6315640034373462, 0.97509547522406448, 0.070526132875535788, 0.60904013261638201, -0.23740766452325249, 0.018386183198499974, 0.020082858536573371, -0.31844414582422748, 0.17413682158304766, -0.08505658762624449, -0.074435842901606972, 0.14384340495644307, -0.88974201543767661, -0.61683107336436016, 0.34349086304831733, -0.27344994990214533, -0.28476669483628453, -0.3697519585651392, 0.43563078006134875, 0.1400075130759916, 0.24351603477757425, 0.40150948225932748, -0.20348432558219787, -0.433460679832739, -0.32171881393862845, 1.1397742379938145],
                             [0.67404205247930737, 0.070225758150434414, -0.31338191460505199, -0.35533339501210526, -0.23838775516499103, -0.8628752885281209, -0.10024037325219361, 0.40969821090465447, -0.2851152316327476, 0.031608075517846473, 0.21394218539526094, -0.33054383632568107, 0.076963225561588994, -0.67493067957424224, -0.33001653326103497, -0.38995287638703019, -0.047156876372616521, 0.21537899591157472, -0.60345069630783754, -0.2827950218983607, -0.80093048487550955, -0.15878047288465275, 0.037746721167763522, -0.28374466803249493, -0.36042069462287679, 0.89427705894724796, -0.043481652938961612, 0.038052509109214483, 0.34933953278889185, 0.30260899888073678],
                             [0.60390702540300811, -0.21322400399726849, 0.29908452300568078, -0.78222773932729006, -0.25566385044883116, -0.12910998326768108, -0.1653557335810058, 0.019712467783641746, -0.30499542575157923, -0.51119981836480299, 0.16167315045193315, 1.1926951372108829, -0.42804751155344356, -0.38718247573768649, 0.45063020598347159, -0.015470574290679856, 0.13603335198788075, -0.14957758806243854, -0.041771079745458184, 0.33336584899521321, -0.0040936451551203401, 0.79635332437765749, 0.058480718791115216, 0.028962935945888502, -0.22152886689047832, 0.024914102267183574, 0.39455708164902681, -0.86963123187765079, 0.81807296950429909, -0.12611249425196958],
                             [0.28872967934521843, 0.37683183535585796, -0.19193145670108497, 0.30211262377190029, 0.76162313138127535, 0.31656391519429589, -0.37344066595616671, -0.038135048061467905, -0.55556313846766925, 0.37834121925900382, -0.5261471064858283, -0.043584101811200884, 0.22350675809483117, -0.061089771147534465, 0.60075551454223319, 0.38913468939655471, 0.40839729386777185, 0.31846561609200436, 0.034854686932531839, -0.027056302882182869, -0.1234821468497853, 0.17580770218148456, 0.36002857715866932, -0.62093844835311984, 0.2992306325391339, -0.52366581330413597, -0.73836034451654131, -0.58348932560135902, 0.029497425947393685, -0.13746847799998124],
                             [-0.51348157528839311, -0.40417580957515137, 0.38851886460766832, -0.20687922946569517, -0.087788723243494626, -0.11157527761356273, 0.5643911230256643, 0.60293183123014571, -0.73110705152719113, 0.95183539624222335, 0.70582538639281256, -1.1842478870937507, -0.071061499705974501, 0.12511118793197692, 0.20035115251111493, -0.76134516097445992, -0.21010757026877316, 0.95228529715010524, -0.095757705121644943, 0.38384062896600696, -0.099472778510021925, -0.30554344718778914, -1.1247091450435538, -0.19289970134319148, 0.15734273063777274, -0.23619341154921009, -0.19672202614838891, 0.37027340731158059, 0.22221460960626802, 0.53770014970232671],
                             [0.065439413144778538, 0.045755428882124138, 0.1276226979172021, 0.44002182938622669, 0.72781181764058234, 0.63962093003848564, -0.010888569793188037, -0.14248313772920004, 0.50237779987536768, 0.021585733894535348, 0.27886764008005938, 0.19543916306623949, -0.37446663863964574, -1.1671570447889705, 0.33922682787718261, 0.088015995794284263, 0.76185608122050663, 0.17818576135831579, -0.27184683973171397, -0.42247454270130846, -0.053097478119263387, 0.57540796955159912, 0.49306141805606413, -0.39264971958962647, 0.74465659871476886, 0.15674951980508464, 0.13205108413891498, 0.21266569138138425, -0.3402774807887391, 0.68033141602935132],
                             [0.32341833120443753, 0.59406224622468806, -0.85171066684497165, -0.24598754336462872, -0.48342991053123746, -0.7221609015481194, 0.38053870761805564, -0.33897410794288863, -0.73834620835847709, 0.13880511221444589, -0.18515520472831554, -0.12175570984899188, 0.78449896410792985, -0.51236175518543803, 0.30850121735709302, 0.21815087806682112, 0.147487387244992, -0.20073734030842658, -0.27495777580784297, 0.69910066073437149, 0.28551502167213183, 0.476682414412883, -0.5843671075536605, 0.25508365743575184, 0.43649514695642, -0.89002050052007653, -0.1680247264983325, -0.10832237387315365, 0.16529089181088999, 0.89561770729864687],
                             [-0.67646429082656823, 0.29941175172682033, -0.29644738504440576, 0.5172332594193233, -0.65242126839627712, -0.36083428063879591, 0.2436262492952832, 0.70087624599412257, -0.93122246506568063, -0.14273695658279192, 0.15263219061135641, -0.32009353213565517, -0.36772830854626282, -0.065810472835885037, 0.12819945198454055, 0.46313823684064631, -0.20705568105416716, -0.036695038695509843, 0.048066599161685923, -0.7547227012518376, 0.085123164361928572, 0.6112815109737566, 0.25995862390803864, 0.098436871865418996, 0.70125129306088885, 0.3011678064460232, -0.37152442363749044, 0.14489756102897969, 0.66573918147713507, -0.047715462626518976],
                             [-0.35754415944391438, 0.40362617960686864, 0.57298567202484851, -0.53783000876265774, -0.10195800420221762, -0.57572921747568484, 0.15711559082065957, -0.37549296408930072, 0.63716969921208655, -0.10248269309898211, -0.2316373409789477, 0.37591455634683263, -0.35272944194497063, -0.85426791659800039, 0.28380007118349443, 0.44497337330785752, 0.2984266169298892, -0.28161312187013787, 0.62154925471720446, -0.62629774517458126, 0.17355519021197907, 0.22468454572222707, 0.048719281816964118, -0.90803522680745885, 0.25656449698608486, 0.15523300439485538, -0.50775126152174177, -0.26226693779629462, -1.0252267509204906, -0.38591673838210616],
                             [-0.12191259583134206, -0.42973776209888964, -0.036432971357404094, -0.0068634182016946224, 0.50315785760912402, 0.12359480303179279, -0.2035391473711764, -0.70631597738800234, 0.056086377709342883, -0.32765657429032385, 1.1477722735245439, -0.60760754452543619, -0.20521690217099714, 0.51130807726535199, -0.34011882255822967, -0.55463510275946337, -0.53280893411466845, -0.11622193054137775, -0.056921446396488246, -0.3229542741784287, 0.52323806761841107, 0.30464912009872175, 0.29073577073398643, -0.59929384184363355, 0.15108485388766441, 0.17840707045052651, -0.40211088630836755, -0.55485940731887973, -0.45513419257792809, 0.065503284477159848],
                             [-0.21593515843125002, -1.0460619455391245, -0.12586349270529529, 0.16140340586653329, -0.1986167225358349, -0.54195993181370361, -0.4889105103505646, 0.87757174418769657, 0.52146296160468208, -0.22269519963506648, 0.16714760201329668, -0.22017206283876706, 0.19910830776771099, -0.1042216843791262, 0.1784226537702078, -0.54920702513694386, 0.15969137145326462, 0.26249195121192559, 0.96392344936843921, 0.49658705260282948, 0.3236631270854986, 0.25220183969364041, -0.34037272694863613, -0.28174857133791442, 0.1806729572134651, 0.26335967552507566, -0.17896451459157534, -0.31961762577427966, -0.48096064072527484, 0.69723496594828938],
                             [-0.3695049257899195, -0.64761338962633663, -0.51745450853745223, -0.25129106146107072, 0.22578341223618695, -0.14428766540777274, -0.75948302342324336, -0.076094585965919836, 0.10397058760040483, 0.36127437192005024, 0.31573691662558634, -0.97706199752515233, 0.076928621969071895, -0.36555241946882888, 0.61344371040759982, 0.88154875786325193, 0.34775453953322061, -0.14932654666623571, 0.90167051053279501, 0.45638106739713019, -0.36000010372336999, 0.26667410464938224, 0.34310766977913104, -0.5725749861119227, 0.076456958286389293, -0.32114448339429713, 0.38424903740646188, 0.44527520049707364, -0.067156836718317653, -0.49166690216587261],
                             [-0.402724503187119, 0.081837851585631477, 0.35003026000829124, 0.27814877959634549, 0.26913518390008007, -0.1970164335283407, -0.39090765339427647, -0.50870744435084614, 0.27261083334128633, 0.32608338515487045, -0.37283875438594921, -0.320095126881557, 0.38796041953935745, 0.050999033064411753, -0.11951357548927166, -0.40681275061367889, -0.1091461530357842, -0.56803675652400953, -0.17919053932015258, -0.054208378633242994, 1.0154234467268288, -0.77034608480573075, 0.33439730337906715, 0.29992764473955547, 0.43088792669311354, 0.93494650051505135, -0.24809116990805324, 0.092152125304020366, 0.40671738846552097, 0.1638115052898988],
                             [0.40130509529120995, -0.56345717575376786, -0.21776204827619186, 0.097393394880891701, 0.73627564241204879, -0.53774963039966184, 0.58190072752295996, 0.2442559240468683, 0.28887928398102519, 0.4273696125409624, -0.50998816691334359, -0.015110645132646417, -0.38444020905079962, 0.15763163119861243, 0.59792139822211188, 0.48145547390657456, -1.1233137041998664, -0.2479874244152441, 0.35511567656548748, -0.42344358567445345, -0.2234946346694959, 0.060086129188968058, 0.41928064815035632, -0.052166338762040722, -0.25550402976818237, -0.44354628293635251, 0.29297722738497695, -0.15608906096522174, 0.16398585361381218, -0.40665347629838633],
                             [0.045488748964442362, 0.15772910003317925, 0.091868835327668139, -0.10633963158589205, 0.31082612174171781, 0.51344184819670369, -0.11991991298536867, 0.51348476983126612, -0.71145586333668853, 0.8101707670835806, -0.20810838682835014, -0.172622197189118, -0.11791656635198029, 0.25103417695762559, 0.37066648006787295, -0.19406762746859371, -1.0276048743757487, 0.53551661239869397, -1.0435655298984199, -0.11021361927020684, 0.31688841443516891, 0.25961898933084948, 0.40000337331140912, 0.12966352036002637, 0.42588117538205822, 0.11956257312369153, 0.27383398776367457, 0.19768811823909277, -0.7626855682435163, -0.40287713365336736],
                             [-0.43494000808461153, -0.52355852795520208, -0.26515633754805368, 0.23811507723452963, -0.3418798557829264, 0.064827659487274619, 0.099560432032469268, 0.22125931848106384, 0.56729181500282999, 0.82098586863386425, -0.58184469568687003, 0.015576547684365082, -0.44162830694138028, -0.23746024031499752, 0.11528606788567772, -0.052389996333233199, 0.054256599339809877, -0.69903171264418085, -0.56174345711576412, -0.18182942881447511, -0.73132384236211356, 0.26760634039013015, -0.41702840744956543, -0.37869978851409791, -0.039161316672804772, 0.60258983202281602, 0.13652591855877858, -0.5143278947379194, 0.18476914886724724, 0.53304288360530072],
                             [-0.0015450052730592301, -0.1817086797422226, 0.31294795045879797, -0.1641719107313693, -0.20621954867087031, 0.22487497807696422, 0.22657888135133292, 0.2076708525660764, 0.49514767006955895, -0.25156071743701303, -0.19619540568608917, -0.2783859672879343, -0.16972216031655765, -0.28044633259901708, 0.33523453630607708, -0.26296241635104134, -0.27723831953840411, -0.49226216754115881, -0.0096933623139634495, 0.8496581438564802, 0.24404443458857406, -0.20121293770635507, 0.35263492244175459, -0.27279579055520886, 0.67630813201138007, -0.34080437274468406, -0.59843088786687471, 0.39731622219831508, -0.18580829403324745, -1.1346136298591127],
                             [0.19654274285473283, 0.34326725558142235, -0.060524698109154521, -0.31152262330229008, 0.027244026957304272, 0.211778271083569, -0.60633607306907455, 0.27740943022440351, -0.073215203980481744, -0.23346961890428572, 0.62634671614786464, 0.14013552157742892, 0.43267662157494718, 0.032360917408147928, -0.02931636642498113, 0.02815355496691457, -0.2390630521197894, -0.27237178348561153, 0.8246053305532568, -0.56946606316278481, 0.11201241390922642, -0.26584950432813281, -0.92990924920218354, 0.12918521833826616, 0.41040253482253075, -0.57415318253715797, -0.31254210552577777, 0.514552463428402, 0.40639674395268816, -0.18076877892176627],
                             [0.33984190600650266, 0.50623233552726477, -0.36457662789198891, -0.028524217161264621, 0.89510920116677795, 0.18551487592390198, 0.360187111445467, -0.15270135135530088, -1.0333396270919988, -0.02543326846670995, 0.81854617791615081, 0.023472997340097876, -0.59866713131369909, -0.33692140752948418, 0.57209958069661515, -0.430596035120698, 0.80380336241523076, -0.43944799338468243, -0.1364359245202604, 0.27026459875647191, 0.6597657630448408, -0.48032971620400733, 0.42115006029110746, -0.39069006174051357, -0.085358770515124138, 0.081797100588231003, -0.23116698874980818, -0.085914051132003399, -0.58136576585630539, 0.055455669736132598],
                             [0.81680043133216729, -0.83329008225439505, 0.013650603883977118, 0.48998479875200257, -0.89782856236291209, -0.12344191134061602, 0.059109857152454578, -0.5127460228706322, 0.50753542758211567, 0.60353670204018117, -0.054529558599351491, -0.20872751359828493, 0.64412750423260046, -0.46596035234771754, 0.15136698017260014, -0.216123250491674, 0.051243938482615513, 0.22998336826936491, 0.10412895271101688, -0.14271640661045171, 0.61869571371188925, -0.34704271633388345, -0.55508126869255558, -0.66231237715933555, -0.16726376789142086, 0.16303764823791883, 0.53618912888238779, -0.040873978527572352, -0.53236045658670006, -0.68601735289595855],
                             [0.65318651020675722, 0.2844596386676651, -0.093488150532136299, 0.25458785777798271, -0.34046220489683632, 0.37998207713460486, -0.68364823451365953, -0.59492291987580126, 0.45747835282652621, -0.38754181744550836, 0.58741095198538962, -0.21976774089209855, -0.0472553845006905, 0.25599451963752839, 1.3917243073707721, 0.6100808581538657, 0.39728939448561928, 0.081049499934341282, 0.018808559604585162, -0.38920511869660185, -0.30808414339711832, -0.46847082748925373, -0.17735686151078878, -0.11992064429772675, -0.97508449340837811, -0.086174587836160596, -0.52007015080300001, 0.56113780921112921, -0.34576162211918232, 1.0157308325616952],
                             [0.28867203787235396, -0.72378650303779923, 0.44060865463986987, -0.032069719246783507, -0.036000163056116558, -0.51457805475801188, 0.39465146374858073, -0.37743705133724592, -0.45863329968702793, 0.56907794795851141, 0.042603025092253818, 0.30215567792745218, 0.22812913590401002, -0.14535286967994585, -0.07224290543661116, -0.18938937943917186, 0.72402247917025864, 0.24844003543593796, -0.59105457039026121, -0.10464454581065114, 0.13346241395027517, 0.59571027412946143, 0.010184242527178356, 0.13739680971046545, -0.31463893042810437, 0.15508079568262922, -0.22455431472111925, 1.0438575718443077, -0.46704150021860186, 0.12704882436204964],
                             [0.35980964053380682, 0.3493605524795444, -0.073199681431592112, -0.073795850525652698, -0.0679674470361257, -0.0094769502203369549, 0.23492218500536016, 0.23674681404798192, 0.51656760948343361, 0.5689822154500751, 0.61857928967977927, -0.47750106041785129, 0.00084060931070810418, 0.30110999926403353, 0.66549563097274189, -0.87695331522842079, 0.23249983022556917, -0.18448108156839804, 0.86566450775860138, -0.6348958141304456, -0.32092262567332364, 0.81936906641882168, 0.2219967487925161, 0.76313961311529854, -0.030398465478211845, 0.23173062976719433, 0.15622902962120805, 0.011273563371660272, 0.066494237419919763, -0.40156581286241499],
                             [0.13976143834675961, 0.5902479400597429, 1.0730179063967391, 1.2223353151143956, 0.71511998968339374, -0.55509411407142228, -1.2127657217443488, 0.17510783707861152, -0.29099463639802259, 0.083038189265324691, 0.13741335569204247, -0.49760269473033253, 0.11783232959173216, 0.29661131855883882, -0.36103769263741969, 0.27301930856677847, -0.39185173500498949, -0.3512399519890117, -0.108262538860999, -0.28392174030939743, -0.21374245924612448, 0.5287914860251075, -0.44992044283537347, 0.17553714251222804, -0.56420980843472468, 0.17208025392689452, 0.47596989959987834, -0.073990315812596047, -0.052074811991418633, 0.17885302713999673],
                             [-0.3737204052167824, -0.26788873321279139, -0.18373984229307633, 0.31282111980022081, -0.91672033481654236, -0.4181852853262934, -0.28374615449891671, -0.87835088287457053, -0.5566367186821044, -0.11491401101011163, -0.20329517817596771, -0.16015869515507311, -0.10737708425085268, -0.59342684133548473, 0.26904679563360501, -0.43087272699088364, 0.069182212370886509, 0.15038213645039381, -0.14635134370703057, -0.10934478400910426, -0.88962716262760866, -0.62843022939828186, -0.055640346313437776, 0.81456515526411044, 0.27778731124877043, -0.35210306901591643, -0.14380733340414265, 0.34286116485960982, -0.23881073048020421, 0.25250911831498812],
                             [-0.28186712113090095, 0.43379637383012321, -0.010175904552340027, -0.19577487640358152, -0.42347987611622362, -0.092369075263777162, -0.060072620790587644, -0.3345804043352435, -0.14498362888299499, -0.010372823678362831, -0.26825650779675148, -0.40317987619462431, -0.099138377225413216, -0.096913153276824218, 0.021579100797221286, -1.318542350406761, -0.35784920627824135, -0.14311387917957799, 0.79208476601233546, 0.16637812665110402, 0.43964652862296594, 0.22798912280973352, -0.2728272001975498, -0.31191317070151392, -0.20759780540108907, 0.29005549275974779, 0.10631086396117603, 0.51790308567917331, 0.38334405132371657, 0.22930469027217881],
                             [-0.44142579547869309, -0.031185026393160897, 0.20972216237426633, 0.3124221722855251, -0.36017305863368865, -0.11920827332463585, -0.25327139849421731, 0.27911976604323069, -0.0061414599220926402, 0.13956780221652165, 0.54995248433008315, 0.34406266870711494, 0.8534560090293164, -0.30674498962407182, 0.43876692066824396, -0.069791673921355324, -0.58485352572477467, -0.17717889660624758, -0.37674958752488985, -0.48710647038832927, 0.40686079287127075, -0.68170790407936677, 0.84304704290620158, -0.79737663950204751, -0.35512134089741831, -1.2676990669355102, 0.21810782914943053, -0.46267882859922438, -0.17936804012718682, -0.080769837803379929],
                             [0.08252665787447741, -0.16912698548720989, -0.68863852463982989, 0.54052430499421888, 0.2224386832126358, 0.58258397701532427, 0.28543605980654851, 0.44861720362183211, 0.4509047347814697, 0.5762336660734122, 0.21778741037361943, 0.40358426156013449, 0.25568459123000242, 0.18150127586850062, -0.61079640198215501, 0.59551138442593921, -0.71590338317017721, 0.23211910401504937, 0.31777072979745546, 0.32475570571831713, 0.246786539842652, 0.26830784456702511, -0.24482993314899665, 0.37000060741751833, -0.98364392411582946, -0.10182508481799701, -0.93113119169779646, -0.095668700905402762, 0.2378536791650076, -0.18814333001362313]],
                            [[-0.35334681159499626, 0.061365992080488402, 0.87521552844718797, 0.3356196487226133, 0.40869996077331777, -0.45381405414532433, -0.13044917017655416, 0.53406598094966573, 0.33014461125157035, -0.36418018564265825, -0.22265266061848368, 0.63135753250716364, 0.11183149542572637, 0.19633965757906319, -0.43887544889732027, 0.2032701631819199, 0.49497149841030053, -0.33940706191456954, -0.18320825428925863, 0.35588043999801094, 0.24575284212596116, -0.37315133990140259, -0.70314644479131649, 0.32605839430421035, -0.13432355837913118, -0.042310182617186748, -0.3110173909828059, -0.10089811164947574, -0.62179396860739122, 0.37463653320136575],
                             [-0.49662207761699861, -0.7083742391468526, 1.0481566353461069, 0.049780425251990543, 0.56571684586238646, 0.1012299368976132, -0.054264358407612123, -0.055069186353715743, -0.28597881225115118, -0.062683667143350497, 0.089322617016635686, -0.79393237010306517, -0.12894413775058755, -0.1006284481139619, 0.59358525860615752, -0.37145062558411246, -0.36698947085458672, 0.38186385155275154, 0.057995162692881824, -0.26008331724641726, 0.21158499748840195, 0.32059094659523912, -0.12632551565593966, -0.27181475222654561, 0.3426678922419476, -0.48596458213120758, 0.52621352203544569, -0.079147513834993202, 0.50216832874737316, 0.20002616941894363],
                             [0.59926478936814465, 0.45328846943118772, 0.39283555283810184, -0.66641870974152972, -0.088189265005597053, 0.43597012406590624, -0.24666096776747104, -0.090588322061249629, 0.34901162389422485, -0.25288579810613254, 0.065743540034532796, 0.093505268327617047, -0.18667422745918788, 0.46436024486580441, -0.30309606506504194, 0.55234599793606587, 0.15626718673978035, 0.58984039259744392, 0.16019031805701545, 0.058191023474774228, 0.38145685313309091, -0.69928600137194985, -0.21639271042283983, -0.58238259462304798, 0.26350749879576824, 0.77294531314243919, 0.11884341924011119, 0.096969282121213932, 0.0047900542014951281, 0.73661963403571151],
                             [0.53065381614632168, -0.42401354203211361, 0.04372391527965578, 0.11151501190092762, -0.66144186854770692, -0.39756634281775782, -0.15572174971527999, -0.51655878080575834, -0.1836364682567663, 0.32718561855002126, 0.21977344355449238, -0.30104055706615312, 0.14203033572692, 0.24185455149111051, -0.60556174318712974, 0.3170398897923084, 0.44441636937701501, 0.092245769555644494, 0.75000010972773246, 0.19849012425116017, -0.43124124996032176, -0.012029101775185109, -0.24920435436733893, 0.029930133348219229, -0.10020164516954118, -0.11641082332995684, 0.68099064214482763, 0.26877240645013101, -0.17430365367781173, -0.5754130239415175],
                             [-0.51988180157690966, -0.29122551669215402, -0.33767370378166006, -0.11297760287571404, -0.047271464470375654, 0.83252086469072872, 0.14814299540154319, -0.33540901341422885, 0.14144790886996522, 0.0099191124776207007, -0.51367201632737303, 0.30019719613213836, -0.44663667908206289, -0.065995531485135719, 0.30637760920194773, 0.29903830647457535, 0.75848576487051111, -0.26141234681629572, -0.26670113614747132, -0.31064367886830263, 0.12306513053940031, -0.28569063239530534, 0.41537342390991938, -0.062579234954952517, -0.10473268539219865, -0.4295955864711572, 0.12501101470250375, 0.098364368158738127, 0.61532122012070067, 0.2734884173504139],
                             [0.094651715699620539, 0.15678407807717654, -0.36563263262768475, 0.52919426832003991, -0.041778318253843552, -0.15068181684606252, -0.10399896819910932, -0.33922569955945159, -0.57458895208312188, -0.97863658608855453, -0.65067464582149892, -0.18418547554042444, -0.30983655475354388, 0.24288843245728975, -0.25957010665753077, 0.1669298559789443, 0.11970479421312163, 0.39461524935845455, -0.67560883958790385, 0.23350508715106236, -0.5950437378417871, -0.64989190472791025, 0.059830330697654845, 0.21367561205571062, -0.28220381431365921, 0.061169535449913839, 0.10245485050945027, 0.37088484578272896, 0.24485265845342793, 0.17403378067270928],
                             [-0.44365187020302438, 0.52772011898531657, -0.31752298068646756, 0.0690695333399549, -0.81084065430373142, 0.26596422839827338, -0.48440336820560359, 0.15307234648572926, -0.023935906360740236, -0.11587128028607015, 0.055759263704257253, -0.15766425012847088, 0.32778276431160991, -0.5639689233278139, 0.26646111581569454, 0.53799204370019915, 0.18836858829026523, 0.49218182050350245, -0.19113659356584597, -0.2136573961492802, -0.47658205871094528, 0.42454472755371297, -0.23815182793907502, 0.20110837277260776, -0.45329293779456298, 0.0013019692096543391, -0.31606810140951141, -0.5262568059258661, -0.018078290504183053, 0.10972575880047376],
                             [-0.054321399475032048, 0.54518536363706183, -0.39012010059699742, 0.22516943676952911, 0.24198513460707916, -0.17725696822707859, -0.15581828696170896, 0.39041633598170733, 0.58301788146703504, -0.76567449399570731, 0.50786497074733816, -0.25057448021856504, -0.56949056143246557, -0.23355014116972148, -0.77540749331786119, -0.052369519814639193, 0.093120705562121889, 0.10703207134038982, 0.58378287746538304, -0.055644477311728544, 0.10172106346992719, 0.068777888562812889, 0.68953496031082562, -0.23237640124450154, 0.32268847022274927, 0.098044514529315535, 0.51442558412819173, 0.12574131210777714, 0.13921861009508196, 0.12468300459420129],
                             [0.55992881049988363, -0.75665916347959217, 0.40807664952763223, 0.10704711667512441, -0.39969826337303849, 0.10431337015718337, -0.023275207268676643, 0.57676261894679526, -0.36112847952122029, -0.24926671944938064, -0.24567868545303659, -0.058905222480954117, 0.32703501257137518, -0.11229211417141112, 0.39590767048028846, -0.082583826174665434, -0.24126271437642133, 0.27531536492215947, -0.046201744295367858, 0.95311613126527917, 0.32462243419053716, 0.69399538362419544, 0.13627353915459958, 0.056201615493411038, -0.089858770523911335, 0.012327769835002153, 0.06869445110992993, 0.18135855006228327, -0.41574031324348498, 0.087891313190694445],
                             [0.48814485643050037, 0.41701390228390012, -0.047493740492339197, 0.64803788289205411, -0.060406328811960036, 0.36043631290676187, -0.0018980298185834049, -0.56682783748434917, -0.4973049243750422, -0.21145794539607735, 0.46590722744287028, 0.026501584713869493, -0.50617600790434447, -0.1031293655905185, -0.069029606940038526, 0.14801504065615592, -0.23262966725154041, 0.33258857244579332, -0.095347668698947091, -0.090988461604584861, 0.55038126109580321, -0.078982846855621056, -0.078849747426697342, -0.11642001244665681, 0.5788033977485042, -0.25868069078292116, -0.15411548473550271, -0.24693684126541501, 0.068958737251034075, 0.22688538261972452],
                             [0.54541053613298907, 0.48607633986713406, 0.61286522637381047, -0.0054471594731018702, -0.33434729478892344, 0.062357071918630873, 0.10623751969206241, -0.53889294919980324, -0.39907693769210562, 0.046351292364875743, -0.17149606459281219, 0.20114689705124625, 0.02498715121195802, 0.043506166610892266, -0.62083172236876483, -0.81228430899573156, -0.012702503760349329, 0.57613535380998604, -0.61728887339883731, 0.39938577381936458, -0.21606253899123284, 0.28432891635182306, 0.39356883100744877, -0.63735077822834907, 0.62817873820598225, 0.32750206083558436, 0.091339801350619046, -0.26533094142755148, -0.33079482692110795, -0.48006811668964616],
                             [0.15418357600420823, -0.56552626661383798, 0.15616536112652979, 0.53858702478213649, 0.44258010503114087, 0.0010374697246777406, -0.55167233847872021, 0.014100316078398331, 0.1665058100964954, 0.26544491828216593, -0.22895569172417224, 0.51520243314767566, -0.16580724826493087, -0.29804798413034678, -0.55729788864820151, 0.15763542329750402, -0.23186397890829399, -0.1727301886508894, 0.83629297773863254, 0.007073386845532912, -0.37473311578113383, 0.26903887941728183, 0.22256314786645778, -0.31802189749810555, 0.35068746489110197, -0.015301692220993054, -0.73900261062471873, 0.40028130141151114, 0.38998820897668862, -0.030589150332797261],
                             [0.88014170588367058, -0.2182696808426545, 0.18622453875590145, -0.077749778189237784, -0.34837001070184942, 0.273448959119164, -0.42321961022343679, 0.42740898294141727, -0.065376023451640286, -0.53874749261648547, 0.014435526875170489, 0.047608906740155707, 0.41072064639686751, 0.13975860532375106, -0.46320130682105876, -0.64580411139492222, 0.012763257972682261, -0.047078748897819808, -0.33632017280018656, -0.80672645433167944, 0.18828585702220496, 0.30907041514546579, -0.36891931500559144, 0.051287770545497387, 0.032199155220661912, 0.18492152580194784, -0.25863987291406842, -0.14020791575122371, 0.33182334676887465, -0.39069523989507837],
                             [-0.48155975663566625, 0.14263332618975233, -0.021150428815340204, 0.049090031472403386, -0.078052563573683273, -0.45970224761591849, 0.6350692601653839, 0.16404306962844231, -0.58637988611610103, 0.30930210476038916, 0.18780782472956364, 0.95503497061227016, -0.2579952990207392, 0.39318053651482165, -0.1598902379849875, 0.27602100534423624, -0.016791732543756044, 0.86456849720236972, -0.023274438563439553, -0.11579281813068046, 0.14926198898944273, 0.057090127196335022, -0.54080060931990337, 0.061324100573968449, -0.48002397944922415, -0.03078076223095846, -0.56973836434425362, 0.063770613260069053, 0.037044775100286406, -0.1164332332606829],
                             [0.23918146931013745, 0.35488527579281648, -0.077783684608988463, 0.36480277667761629, 0.20401154455665302, 0.28221426660904575, 0.27299671398534586, -0.20222068820106076, -0.12989215427241407, -0.43290063243158949, -0.023310400436477523, -0.63605107081257173, -0.1931984864131939, 0.49414008385666663, 0.36787869606534185, -0.29977463319473346, 0.68133960450816633, 0.27928751639169569, 0.39691753477870351, -0.24728263128277023, 0.075489755352178986, -0.036460183435218584, 0.59940638516186695, 0.68853185961839269, -0.0073381237052626766, -0.018236817071071467, -0.3421295480599072, -0.38457749281706316, -0.30940650187034058, -0.12970681766252035],
                             [0.060951151087204281, 0.45702731400987839, -0.22275900084402556, -0.27843251075245734, 0.017836111400937368, 0.090689739255146132, 0.15355417154005119, 0.42600612866197435, -0.17256447213598969, 0.053151608700990421, -0.14796139813391004, 0.35182832423537702, -0.25360104205158074, -0.21092467279297639, 0.055895998796207824, 0.052746948300159219, 0.051808074781618557, -0.53652262359851299, 0.35232323330095833, 0.39431652484778984, -0.30784978581147093, 0.0057281806700174211, -0.46132242893319142, -0.10619247727911961, -0.15390308493411145, 0.28932551646940752, 0.35575262096231186, -0.73510296647481665, 0.51731023686153144, -0.48765945823472212],
                             [-0.19639673038613775, -0.45778545203059529, 0.043817300229693101, -0.2293815941316697, 0.45087996875472258, 0.51145322191703668, 0.50971524739168439, -0.45065526461482885, -0.49062581297727836, -0.32229686426042992, 0.43852432695671789, 0.25789187133886116, 0.90960446330655309, 0.31892008008858486, -0.20645920946786456, 0.64271879136869381, 0.00099663392545359247, -0.26581888429272937, 0.19215207265484063, 0.058428702455842182, 0.25183832543608814, 0.46272158499565119, 0.64692200303080527, -0.2739686675827121, 0.42494124909500819, -0.2571019572938576, 0.1470257135007656, -0.81041962935517642, -0.14979106943409926, 0.094289849090299693],
                             [0.40119516976871927, -0.34836350097987312, -0.38459660615613284, 0.37426370553319033, 0.39280849545859353, 0.54924080480058168, 0.1005550018595073, 0.14549971083133262, 0.10250736849019154, 0.31140023052985905, 0.95788341062168969, 0.2197867138923621, -0.0074700222478429334, -0.10900912223453281, 0.14458608434804948, -0.052289192333278119, 0.04035071205121659, -0.36306745189902506, -0.38823337531550539, -0.13583300653324309, -0.42573460900397192, -0.30239785624672416, 0.40493330611829692, -0.56730906283477545, -0.29716539248889429, 0.32896119055795592, 0.035005493719461302, 0.29002946344731273, -0.38770818268706786, -0.58323378496569589],
                             [-0.14409164839701932, -0.062004760485312761, -0.16539557560306856, -0.55596890489559636, -0.056372929697410312, 0.62014908333228291, -0.59504190850432415, 0.024061569457388098, -0.15345468132140228, -0.64002156183093506, 0.26713725034253638, 0.11646852393923315, -0.26798342098264299, 0.29199556827673834, 0.41226905051873175, -0.19568556425253963, 0.1456410188207477, -0.070411581426244554, -0.19123950737028048, -0.16470957700519692, -0.19194485146978763, 0.01109836890942836, 0.031377023019825367, 0.26587293353107888, 0.62802058196919808, 0.0548877646390699, 0.030071155449665047, 0.16825449714634186, -0.6574775901785056, 0.13301347532066554],
                             [-0.28456950506164175, 0.63504131837514655, 0.13274934933853233, -0.13109592890638586, 0.024248720063023865, 0.5528661335299887, 0.34816070046942971, -0.069191846390841277, -0.10871345518826392, -0.40395939806290115, -0.061444302109154775, -0.57045439893590788, -0.37028815429341433, 0.34125952756930605, -0.10805495853113914, -0.058964154048143688, -0.17489751917846058, -0.26608280958859187, -0.011954756207009379, 0.41213537415469154, 0.16047130011306879, 0.34455060122153741, -0.52228487785200917, -0.33231049273680185, -0.44741825862950219, -0.16134568885041539, -0.43311679606539244, 0.25932642114396193, -0.035860924677811518, -0.73700873782951648],
                             [-0.0075934931345806589, -0.30416928597871562, -0.41202054799727017, 0.097306724084348609, 0.44109041553304978, -0.14353221848919648, -0.88133548848084875, -0.44166196779718081, -0.23326056038740586, -0.03609436847420279, -0.33350225244723247, 0.20177353426642738, -0.14926747099367615, -0.034608085355393614, 0.24185805317790243, 0.15510095096593046, -0.39666416927115916, 0.24459303514119529, 0.4881797330167153, 0.33840579440254603, 0.61002476210566359, -0.23707895267419554, 0.13713758687602881, -0.42746668850411684, -0.66598415912077535, -0.30779030846785904, 0.023204679957765317, -0.40516526886245902, -0.31779402985240163, -0.042857887668853678],
                             [0.37925439833543306, 0.48374402867819877, 0.18120476881545711, -0.38512354187443709, 0.32806190676675023, -0.017810172326931557, -0.019637014905242556, -0.1800999245519436, -0.082750525328091115, -0.30991133283861672, 0.26490029511286062, 0.35961206214570018, -0.036850242542181458, -0.51201815033199349, 0.43546740918520493, -0.27838142634690122, 0.46765062569789129, -0.22552007890030445, 0.34643457188721971, -0.39374097943209174, -0.074955121774830921, -0.33172944552231931, 0.20394400265569579, -0.23005034030084567, 0.21523637512404631, -0.83084336304630613, -0.56792683032902302, 0.45774879354001091, 0.051168629669000959, 0.49770477229138249],
                             [0.32149041988048854, -0.7077496521983947, 0.25066643271185574, -0.4774436092996539, -0.33394958974096867, -0.17790656805348581, -0.43041043767290899, 0.21271223197725142, 0.34373090980257437, -0.21286045476314194, -0.28273116488086669, -0.16272408581893588, -0.27324052069622357, 0.046722431817439618, -0.10534343777592861, 0.58922744400679106, -0.43808461732530807, 0.020285339623614774, -0.37781842976225344, 0.19405628532784747, 0.17895774667022879, -0.44065049115431765, 0.21510781176941748, 0.27185147014057431, 0.069062136505017871, -0.10914254226379831, -0.27354762913558234, -0.53193335352796545, 0.67459547248315621, -0.52323731879838853],
                             [-0.23557278567768741, -0.34848766883255328, 0.19865776407667488, -0.18088462346333756, -0.55226908774530425, 0.094641256039074709, 0.22319116101129557, 0.1730785267238289, -0.36377471937471012, 0.28839396039536958, 0.56209993947346748, 0.12011198790521185, -0.3288837368457837, 0.51860532739740917, -0.32838312472924469, -0.62540260629273559, -0.25295434377976111, -0.75624182161608733, -0.086356418664900902, 0.028475119124235462, 0.095873766991236842, -0.19075486588699925, 0.58279123384040832, -0.039494357591260326, -0.35212561356727906, -0.096704158287257647, -0.32486574807185975, -0.11163428384148623, 0.7890836066472966, 0.5453316688408355],
                             [0.62475751566057625, -0.0058427416829499312, -0.068815247624940332, -0.57319157929702647, 0.32084154382837687, -0.031729444758063136, -0.065624866310633384, -0.6834966346046687, 0.046667331552424779, 0.034674151789498564, -0.21443804681405268, 0.58662094069781734, -0.61575075711572413, 0.44097648522013488, -0.29429919175375069, -0.13207546562138756, -0.073347726690013743, -0.048897574068508837, -0.31832862344661222, 0.1974173498528502, -0.55174879438184821, 0.18116132577174254, -0.14199073307790677, 0.00066735970857376148, -0.45624138505310152, -0.61823396911006934, 0.092102604242296646, -0.4069139634019433, -0.13275281620920817, 0.7810544584841943],
                             [0.4828009385792722, 0.4469467504470449, 0.66930036109055002, -0.17165969906633574, 0.020213692830186147, -0.28517952405176783, -0.26577426630464057, -0.12256314783994145, -0.52692968253061145, 0.0061935891012053906, -0.10392906594761771, 0.50495625803837907, -0.23051817457083951, -0.16586721436862634, -0.08736255110069488, 0.18585778344272877, -0.014359054021030021, -0.37785370854758316, 0.14239019918768964, -0.54825499836371738, 0.13621447283945792, 0.43906064506159753, 0.36958901482513268, 0.4301535265141217, -0.43517739303085068, 0.13052531738094716, 0.072542928168924492, -0.036245675421915126, -0.039126103103080651, 0.15541597442825153],
                             [-0.055792602110116579, 0.038353223603921849, 0.730188972689788, -0.059607588408396972, -0.23209606844465447, 0.81987916294945828, 0.3333169829863511, -0.40233816277569662, 0.18678747564640072, -0.22930964871988446, 0.039615629231881139, 0.38423482396803932, 0.50515694301886926, 0.067555026282573233, 0.15501321807261942, -0.12009285187130503, -0.23342015766833363, -0.094578548334120285, 0.76441177467165033, -0.20885114555207893, 0.039624578632590224, -0.26288067485175565, -0.39573984469671791, 0.76606420682821219, -0.25582079627642385, 0.014490438785594813, 0.023928648005289266, 0.15982254816969652, 0.77870213171928404, -0.44000146277064667],
                             [0.10598331283164089, 0.64477120795402898, -0.023360798073499146, -0.28381785656270109, 0.56033398892622566, 0.39296353875962992, -0.27760172696526036, 0.62582314266988204, -0.4007699602392083, 0.43827694974239506, 0.10553744666165635, -0.12979253681183694, 0.080039088391221327, 0.24428588009056407, -0.28811180787152707, -0.22765968519922136, -0.11024188346606367, 0.56708799512382613, -0.37455867560573697, 0.0078899611105439048, 0.14254597982470485, -0.26937732501869754, 0.063294286049679419, 0.37713805008939899, -0.1216328147297422, -0.43077394312485678, -0.013054680181659332, -0.37413594995954591, 0.30042624220363057, -0.30317963178284257],
                             [0.18595263964327749, -0.32672766306137274, -0.234987962476573, -0.20860909630794039, 0.28319772652777625, -0.0061599800929616486, -0.13439566402544081, -0.37866666372804736, -0.80351073243088877, 0.11905002352046878, 0.096309841349266914, -0.4485963629000283, -0.2026339209557281, -0.90373178854471681, -0.37855200222384677, -0.41314569373843335, 0.060412137839064503, 0.54646118270878274, 0.021058095756461521, 0.15586395365851644, 0.46917085064752007, 0.11844284531777652, 0.2161164631877579, 0.46451800133477872, -0.53397798569104482, 0.44562631615612458, -0.35150496408557053, -0.15070519078980232, -0.41103582974616476, 0.10171992030676576],
                             [-0.24255409625360974, -0.033391374682629538, 0.069922457320942405, 0.025960195775562328, -0.16913031154275066, 0.40268178924833131, -0.023957224471599259, 0.84321657659902494, 0.019737641370812187, -0.44426930210127991, -0.38296615075988227, -0.22789653625376877, -0.67694575548507951, -0.27256184106255188, -0.3116147567220614, 0.29175994162848728, -0.54534890754624921, 0.09003512894080469, 0.50745002397163852, -0.43577819532935791, 0.2025057440906991, -0.16806296836566692, -0.27115032383132265, -0.35781795165000552, 0.31551050899934302, -0.34005995655089699, 0.04502011757472768, -0.446593726491813, -0.54655263320064373, 0.15081301394634677]],
                            [[-0.17610501676929768, 0.053615270580645441, 0.24617439760083196, 0.23338370824977717, 0.27179607545114676, 0.093569035321874786, 0.28784919359561223, -0.37466289379628948, -0.49028983422559347, -0.35694888370179845, 0.19975237378636576, 0.27063733471136436, 0.15025109981623763, 0.065174907180615735, 0.4627018394391868, -0.22740651697996223, 0.090766315115723764, -0.28915973149619423, -0.30265565617963641, 0.055105401456553627, -0.50568358526185075, -0.28515553625041196, 0.060857921027445444, 0.28689219184255293, 0.028266162334259628, -0.77670779193443418, -0.33815735375110012, -0.11863540854988332, -0.17471240171177382, 0.12762145813306519],
                             [0.10191120409506595, 0.26662568479910931, -0.5824379289621302, 0.17700219544083989, -0.22300212499424021, -0.35020772255750487, -0.34106989725578618, -0.1117951650645761, -0.41841418809666037, 0.18584105294009665, 0.25594961106267239, 0.20984165695716411, 0.19658567195169432, -0.044119337769471793, 0.18482686705493356, -0.083703974129067604, -0.097849252376460277, -0.22068413153743946, 0.059867824984640161, 0.19933677436716274, -0.0048623606541304057, 0.19371220674325706, 0.43601485444127197, -0.67838030659790594, 0.18502090890072817, 0.11044015767798224, -0.095328917714799621, 0.18224711520890644, -0.013183917561039038, 0.47796180451023507],
                             [0.29294522226270009, 0.32662592158560955, -0.033735590791050957, -0.11400487859180408, 0.21299592968048542, -0.061330197201413243, 0.4395815520932892, 0.2279040830817067, 0.20779620824228193, 0.09178004605300101, 0.24250396972442373, 0.41782114281968036, -0.11759775134281575, -0.21208375629240175, -0.41059247574163438, 0.30960852670247685, 0.24492961643239702, -0.18885896280369929, -0.40878953413770341, 0.31089445031116481, -0.18638808191125961, 0.31029825963251439, -0.12084101720202944, -0.093187079741558349, 0.39726027850110268, -0.25586115941219567, 0.17589934501845275, -0.5038729516651006, 0.29918178703010428, 0.1406797152631403],
                             [0.27788787464794135, -0.59711729044822082, -0.22847635617895956, -0.085019475991431975, -0.50330258277389228, 0.15252042953857375, -0.0048948413780865105, -0.17535476378157272, -0.13698586786739284, -0.078239724562762777, 0.26907355607027117, 0.068981752040887023, 0.054603213468948059, 0.1825181531457461, 0.33340990308274793, 0.5729202201388216, -0.04288251048381788, 0.34193757094109761, -0.055718638073548363, -0.20917434731912665, -0.53631941648398296, 0.62749065753282707, 0.15528757869216453, 0.4561861193103679, 0.18384000977235254, -0.01552813982014881, 0.2380208161012442, -0.50765852251769972, -0.035738263069867778, -0.02673081128149743],
                             [-0.11555299817622973, 0.21342653521645386, 0.054921928845582245, 0.036677325510095678, 0.58270156689170016, 0.020339939607357017, 0.3309917365443798, -0.26142705245125958, 0.080179640026753748, 0.27612844198003572, 0.24056021039462133, -0.35372661803599381, -0.31575383468419888, 0.25849737287066304, -0.109631311027895, -0.086029934818117465, -0.34896172106455531, 0.27556422706343414, 0.34758401297758562, 0.19648063845825656, 0.27611931226004599, 0.0076566879780642638, 0.50376945191677613, 0.18526575066575793, 0.18588499347864645, -0.079175487767761954, 0.18891491808335753, 0.097044626435972808, -0.31198431765798773, 0.15044116864380006],
                             [0.10857888457801033, 0.1994449848139698, -0.26416352761335593, -0.21584636063314069, -0.14889957500366885, 0.053327047438894555, -0.090553125981782417, -0.42529715339279067, 0.3681672100117469, 0.36929102785001927, -0.14185284559794059, 0.032297956115470206, 0.30631487003130464, -0.19743404761354436, -0.41726441201920256, 0.3479878297545107, 0.48972849543942165, 0.13444735785752837, 0.10352282957859954, -0.19902360045769946, -0.33068149269613256, -0.11716620802444708, 0.47878776668204515, 0.30334422440350495, -0.45016348356850122, -0.19251840470553616, -0.11894234263078222, 0.16160476383572994, -0.21279761401347438, 0.43888651325010802],
                             [-0.14492870235508504, 0.17739493139554818, 0.2162003344252757, 0.012176776728218906, 0.074724899770247183, -0.09068466014605453, -0.0078685637755735796, -0.33347189949140449, 0.021942470661981003, -0.37148089943307472, -0.014207266192660955, 0.14934173210745666, 0.048673415512618771, -0.047881335890744697, 0.33509882154495524, -0.014191335563585608, 0.19224839736624652, 0.39059745170760279, -0.13279612694489107, 0.070754797664091651, 0.28201420420852685, 0.059986348797894322, 0.056195624709678024, 0.30602287314318849, -0.32303889759409193, 0.68885036234498009, 0.19115190355094347, -0.06652627771931495, 0.41594939056873581, 0.59351489008582825],
                             [-0.13157223288739914, 0.23221430340156474, -0.42986295134661268, -0.39274103085750856, 0.1152815862854297, -0.25511872129747598, 0.5601386913278269, -0.0018582103721110649, 0.060071371153793796, -0.1932040001914761, -0.33612505203214083, 0.026379974720127181, -0.097297593003801294, -0.20444707048539437, 0.69670374359178355, 0.056071929771562695, 0.16308956055491391, -0.080033650411192175, -0.0944024999774246, -0.033649326627383479, 0.20431095617191436, 0.24795889867496124, 0.1077299681847049, -0.35480669351299898, -0.28488760730196705, 0.0035600847792757878, 0.24702611961588411, 0.090702662301733544, -0.66582657859643035, -0.23213345995592155],
                             [0.53209717106822751, -0.22452631554756514, 0.12820980406249735, 0.13211389493943029, -0.15558884808180906, 0.10152183691367084, 0.31017414755197886, -0.19296189603779815, 0.097808133248011533, -0.044660605054525536, -0.63388376583571937, -0.025655815494954416, 0.360204720003579, 0.11651040306638918, 0.24500694073561821, 0.32377888368614377, 0.051074085839752002, -0.69473818858054714, 0.60991574708710494, 0.1036462712614081, 0.078679971136523155, -0.37740677480544049, 0.38688427072591314, -0.1304426363642455, 0.22654339760426401, 0.041699554267659117, 0.17254710356750699, 0.1000978721463627, 0.056931540215492224, 0.10888662284250954],
                             [0.33786891672762581, -0.19129091449911667, -0.41372388790851866, 0.57263346587533304, 0.29626761566682708, 0.048674955398648453, -0.073690931262109474, -0.40946231878065925, 0.21771998161185976, -0.2800675737434335, -0.21735900778960041, 0.22391294249968152, -0.0098334202098494042, -0.2861167629110471, -0.45445693523789299, -0.093807364122847112, -0.77860025752358319, -0.022875629700028322, -0.27018157803650072, -0.063017675526153838, -0.21758635453467584, 0.011250632268001732, 0.04442137281701776, -0.22898615379420861, -0.30141160587964738, 0.02849635839601446, 0.45106420343236892, -0.14056869510049314, -0.073138777450276748, -0.16547896155877104],
                             [0.12293159533110294, -0.19828026011425653, 0.59199033918882404, 0.18731888850181816, -0.3364332763822625, -0.26415818498724114, -0.1838808975016325, -0.37705038848299832, -0.081619409705145363, 0.17125367177071119, 0.071576399419403122, -0.10950737364287354, 0.2208945469700837, 0.0069349617934499203, -0.046093043073024656, -0.27465844562798958, 0.43298270064988226, -0.015393613148241347, -0.20049164862397206, -0.010357763558260444, 0.35603686181193489, 0.40000013419539232, -0.10370693955773271, -0.24074204715395092, -0.064463579249677841, -0.4176685529253169, 0.54747702074917526, -0.16546615718351793, -0.50212846242700504, 0.19928770843477805],
                             [-0.11375358967063948, 0.6580406866265216, -0.078346275171304727, -0.025292458571080256, -0.3356791505765151, 0.14466127460214542, -0.032716566542955051, -0.083194442993530779, -0.20198423084085626, -0.46015377517199502, -0.11356079739501794, -0.49539969774141984, -0.23606105814756134, 0.26621177352239001, -0.071557300288107931, 0.23802494516922282, -0.003374245125002691, 0.23317001446940261, 0.062928194859535838, -0.2884882962521631, 0.46921096450915628, 0.13909090360966775, 0.52405619134704973, -0.30939766839987404, -0.010945397196448039, -0.48402813724829258, -0.052089319504164837, -0.36475316315005574, 0.396014803875337, 0.17049534972117486],
                             [0.67410762607549557, 0.11651528274305857, 0.30497118253924566, 0.25034332519922564, 0.07341773957498747, -0.20886007764410866, -0.27525973080025018, -0.022216626110579601, 0.030308319008708867, -0.13738075186267518, 0.6539888461268788, -0.04402429636283485, -0.084130026533484142, -0.25384426093630724, 0.18914869561035991, 0.74058716605360708, -0.065195108688863149, 0.051184245467189311, -0.011451388220457819, 0.060289558653402651, 0.22114755319820845, -0.27144551416686347, -0.13153209613947081, -0.027688412677640807, -0.14999561384859678, -0.070012444138477459, -0.41333235787335976, 0.076036655623742316, -0.36783899765016986, -0.23338534944099878],
                             [-0.015489169102871989, -0.12068587217990087, 0.19636541096486998, -0.15075903164879231, -0.35397121780184887, -0.93899027568315296, 0.0061083162286343501, 0.055526250166416491, 0.13048088783010839, -0.29771613145869119, -0.066873146568205172, 0.64907522334856593, -0.21519656736194412, 0.4670055558463691, -0.29476458854005461, 0.19979665244245023, -0.1217613400535158, 0.088629289332561867, 0.21113917276560584, 0.055731908928322589, -0.19545919609342052, -0.31715927054075199, 0.19466180118140408, 0.018759475844590427, -0.05167791428187498, -0.066217857719636355, 0.29608860190623743, 0.11778488943229655, -0.17540935812836245, 0.17357008293185311],
                             [0.30086158004622832, 0.15265151299254967, -0.14300888292700292, -0.00080653878970587956, -0.068111659022890014, -0.13728211411937583, -0.054179717846888242, 0.15570000917628773, -0.080360693813142162, -0.34280864372939757, 0.40270617765921263, -0.44704196601422808, -0.42826575386077492, -0.21597201716572728, -0.11744617818004363, -0.34858777553960135, 0.42217485038717018, -0.24009287147186142, -0.0016034515692880807, -0.30342882981679259, -0.218377653925486, -0.70656346335896647, 0.070564251899520966, 0.031222010020496817, -0.043071100423094574, 0.33112378542711962, 0.40765776488997679, -0.26485810987415426, -0.078819996144301768, -0.025029459425762457],
                             [-0.30903835015421438, -0.4668271946054714, -0.13229191270674936, -0.088684123546698482, 0.13882910572904825, -0.10596145664384009, -0.23671745416692513, -0.32683810140755148, -0.40693094864092, -0.28172390915838352, -0.23126901044924439, -0.38620663791904186, -0.62669919937309049, -0.16178726336558205, -0.16462516363529561, 0.34205934369529117, 0.42515657228869441, -0.048466056726663022, -0.20459113948663177, 0.56492312893618146, -0.0015166516543005815, -0.21732103822670287, -0.11781813019530103, -0.13747821916767825, 0.20186625684648157, -0.089397297875246029, -0.11969427745359092, -0.20738161329824928, 0.062441532405077022, 0.1100613678559159],
                             [0.021099154070035084, 0.0041551257472672506, 0.045835339778303973, 0.52424526837565166, 0.093023984197632067, -0.54524648206075255, 0.13481978898182106, 0.42346836536275773, 0.28925253987436672, 0.089156905666975428, -0.20511708506481979, -0.40803333396573388, 0.6269506105624495, 0.051041510056171427, -0.053130584180402271, -0.15892918421004146, -0.069401492371351764, 0.25743379210599882, -0.065879529002487391, 0.05859358104941214, -0.23779559321161706, 0.039845785573811715, 0.34413861208915497, -0.21677461627586891, 0.20628859720048476, 0.12661669948347365, -0.39407469046650451, -0.69283697938061595, 0.012107659911628333, -0.44135113431785772],
                             [0.075316767712338945, -0.091333519259667789, -0.40293705341144859, -0.013538246435859026, 0.26281677088934086, 0.19272847583987388, -0.47048557509215438, 0.4894139559310613, -0.34911904887628314, -0.16058332525187538, -0.2223781824586179, 0.23704256403437685, 0.11176428748145856, 0.048064893617126826, 0.15745258168764947, -0.30545055709235425, 0.10407945755431465, 0.44428790718802941, 0.53545715448866016, 0.59255271008828314, 0.15987714516701823, -0.15011807921680126, -0.19655721019271299, 0.044439608454605713, -0.19199069021053755, -0.17409416130986063, 0.27800457566020198, -0.51778697146682406, -0.28565242508082261, -0.13844950310468362],
                             [0.18961796070552395, 0.16539470037035395, -0.42602452092607607, 0.44111752494630296, -0.25331039844420805, -0.20510987168744804, 0.4690836732323862, -0.11928711622020122, -0.24513779766839547, 0.0722399280533121, -0.024690475781419655, -0.12185446452237773, -0.29191940288226803, 0.36746443148243813, -0.17236740555319841, -0.064442289586007881, 0.042760936629318416, -0.45691606833319764, -0.041847092115094006, 0.16033523637861463, 0.24324857377287881, 0.19379510733515398, -0.27704275948518026, 0.37258892334850424, -0.57598994299476913, 0.067345480589099865, -0.18144779450947193, 0.065039054874805019, -0.078266093585919877, -0.14920204371021234],
                             [0.83462493173992236, -0.26462893803432241, -0.1780419603181933, -0.37713467040631798, -0.095153095346402997, -0.28894045085321413, 0.17208030166522145, -0.055208788268101189, -0.19240158425638787, 0.30574197724570817, -0.23190250747570734, -0.036497744364693475, -0.030967868774675777, -0.36431218538981663, 0.098349472471227231, -0.5396185760362483, -0.40900411584869595, 0.31127136090888674, -0.30980658556869245, -0.30332102137344902, 0.29617819274671786, -0.039388213499583075, 0.10926221454193075, 0.055844697652615065, -0.072163163188582097, -0.28340029479086165, -0.26561157103279481, 0.16962423237660029, 0.16099465505025798, 0.43169347545490683],
                             [-0.18119762754833124, -0.24028636164853612, -0.10298177353463979, -0.30577508370743506, 0.58187071598317364, -0.19244634330637223, -0.41734220883488438, -0.027056075179738463, 0.15132106281907326, 0.044195580908608638, 0.23268038599079921, -0.10431965509114272, 0.19220816385741193, 0.55554517224104494, 0.058066066542422488, 0.1606618282008862, -0.15796216692596365, -0.57894736108648581, -0.31147355014133021, -0.56364485243042761, 0.21761048256300247, -0.070632095789961435, 0.2096322709113789, 0.17128835349975136, -0.27538579774353839, -0.18995643747340474, -0.23402341692180825, -0.39886241790509425, 0.20217608815359298, 0.25400024220921369],
                             [-0.0061516994997928912, 0.096104409578593536, 0.25661206653790114, 0.33790633974132572, -0.090609920862732993, -0.057004380063272589, -0.41629544263393375, 0.12326455514954635, -0.058467731540416304, 0.34450785195493777, -0.3669644694096954, 0.13328111375293245, -0.59159196805753123, -0.64269819453881072, 0.1660362787319736, 0.10153095669075693, -0.16347165141979886, -0.071621831850166393, 0.13192570770448109, -0.56497071292173873, 0.04993699236541782, 0.013843629751354627, -0.054644664661432682, 0.45123998166185042, 0.17240432061009037, 0.10430744108241671, 0.051259752521589347, -0.30883863223605373, -0.13965654925523452, -0.023921865332352549],
                             [0.42583762900177141, 0.40874553678179276, 0.32801020945130233, -0.67911260917996141, 0.15376661493320565, 0.093233935529835138, -0.13882915166648788, 0.039604279920614445, -0.91220761608795908, -0.022570121013729589, -0.23158849919467323, -0.036148366640931892, 0.0086865580114191786, -0.1275323943486755, -0.33653195533382618, -0.10134386901759375, -0.023845502308614111, -0.1729221727388103, -0.032084117299080964, 0.013545456722262973, -0.36664197022090717, 0.52395044313437411, 0.17536818105391588, -0.16013817324244572, -0.035871010341327642, 0.53791648315636154, -0.10026144331871938, -0.038778818215314606, -0.075566568383022253, -0.14523959587467766],
                             [0.013569086548376012, 0.39783944115288078, 0.16396325767826275, -0.060290748664271088, -0.12612220444400885, -0.21462896642383877, -0.19944091178538131, -0.56438246808182557, -0.098833410912913283, 0.59446596999455092, -0.3798103174668504, -0.031998272336174041, 0.21178647964793471, 0.18022481007428523, 0.30945359393787869, 0.27090023675768338, -0.12149933072040528, -0.085656155928666933, -0.21526453506398097, 0.45146805783124488, -0.20994263142567804, -0.18962338246555616, -0.0016131429526367869, 0.18324844372888294, -0.012104007079263946, -0.025532148964107507, 0.48161038253327115, -0.067734192282253344, 0.56029479811212057, -0.56365820266298128],
                             [-0.25852836865825835, 0.033493395544001409, -0.16008927195659473, -0.26485027973100267, -0.40515044128188282, -0.060878968546541672, -0.2511007433983134, -0.50832340498228268, 0.12446295937559784, -0.28279993162350786, 0.22697592024644517, 0.1258059553079667, 0.17121379393915262, -0.26193168604931871, -0.12494405141520894, -0.49152685527000112, -0.1829410512845065, -0.11647780862239987, -0.13036468776870261, 0.15935114615380935, 0.36305435129873131, -0.14653727227324306, 0.2399198752147107, 0.6460460493720499, 0.35657396268136277, 0.013804342377091062, -0.010540472357976229, -0.29637939261261942, -0.1187492636641503, -0.48562550463995946],
                             [-0.20852480243125032, -0.17698007239451111, -0.15020397188082324, 0.25751580126197693, -0.1843241298604652, 0.012180838338437555, 0.14457992523244342, 0.64863874180484338, -0.15763702554251072, -0.10471607624420042, 0.1996547094700333, -0.13634741314007029, 0.069130430145388166, -0.5091178131980405, 0.011589182624781449, 0.27889976771999409, -0.22961270555821311, -0.31033869676213571, -0.58735555333584122, 0.27619693005325391, 0.10191163316829728, 0.17340380974395661, 0.54540784674095055, 0.38297331990871997, -0.22870975753781114, -0.045906042241467999, 0.49424942400443217, 0.32955443835115372, 0.054837936938037651, 0.096795592529326416],
                             [0.12378024792399961, -0.2139937102114346, 0.47153644968108693, 0.097987342744466993, 0.042183739315185563, 0.37512450395757313, 0.042848491967322218, 0.11885778162679091, 0.11248796663408338, 0.38977510327784959, 0.16633675202989129, 0.55867228412212211, -0.24323878575411478, 0.35274592133122273, 0.39321465660416222, -0.18510532012187084, 0.22673100333468341, 0.12462415521572281, -0.034766608053893887, -0.0048325920698603485, 0.037664133017644603, -0.094120798021685922, 0.68351637305642954, -0.14773192520219708, -0.38104917192581805, 0.20643681474747491, -0.13159556767107952, -0.0190390154856474, -0.072419745061042137, -0.3645681290356767],
                             [-0.12308629056176984, 0.010614420935994462, -0.23629537750675861, 0.17424943890178146, 0.080435181320963445, 0.31254902499603382, 0.55137801927324315, -0.060619279564366205, -0.48088661930226712, 0.19688319947385119, -0.16247468878870419, 0.1988477176567256, 0.25271116233650714, 0.069738045067197107, -0.36491330012481671, 0.4530517526786571, 0.3774271652173305, 0.34058378005716616, -0.033261093791970078, -0.59560838253867998, 0.52225077318379454, -0.33429135494717721, 0.043033064684198756, 0.036036357101667207, 0.28458111897313815, 0.19838771676338882, 0.19309268422798087, -0.039146345449635335, -0.070105575345973226, -0.20760799955370141],
                             [-0.13662225781666576, -0.38174834788788836, 0.10626814934054578, -0.12664647647614885, 0.30370314151971539, -0.36141056956515383, 0.13196163486159895, -0.14490050343720767, -0.15240307227488595, -0.047809102392043799, 0.2520207948081869, 0.16944205674109913, -0.045575043193637414, -0.37970834046343871, 0.10250520144169338, 0.13290787096459628, 0.25630373960691605, 0.026015238413252754, 0.63003766962283692, -0.18506750886927181, -0.24889597763849758, 0.34269247502475897, 0.30371151328238777, -0.13221499689057981, -0.42135811310367333, -0.092182930532377805, 0.18309778548514699, -0.052612319681850983, 0.68582368577496178, -0.36973428074179421],
                             [-0.46045078232613634, -0.11334298392638199, 0.11249605164015385, -0.21930189000370773, -0.54916431168452218, -0.050428246750569283, 0.51191337557060368, -0.14913078112077061, -0.01225447982338217, 0.34398591013951985, 0.37908119935832346, -0.011659774650450948, 0.15217320136216922, -0.12116373332149405, -0.13754091562978604, -0.01621937868646256, -0.48108383603730137, 0.043741238689814832, 0.13615241024824104, -0.021217806487957912, -0.099966338641318458, -0.36374151882025141, -0.30567320068982207, -0.41436062907920806, -0.38887077579083829, 0.22987937635857383, -0.018013207827012042, -0.59826482554039806, -0.28477048199245319, 0.15276102945385278]],
                            [[-0.24961089156823815, 0.15384658364197598, -0.84689462152746764, 0.30255688582907236, 0.22288077997334388, 0.057043093930029813, 0.31285433547928132, -0.090535791996654638, 0.12534651884698977, 0.29406187288151209, 0.079259690329663166, 0.050073054161974037, -0.26670399098360764, 0.044728397150063208, 0.15666531999223784, 0.30266624616123788, 0.42503444012151287, 0.046981216040537933, -0.043347249680781928, 0.23842304568934253, -0.3188989826166938, 0.43131936219143885, 0.13510065992511172, -0.069453031067306423, -0.042312553040822029, 0.25097538070385772, -0.65884590357926132, -0.2215097685251462, 0.095442845674951399, -0.068199119509381109],
                             [0.061002574738399609, -0.0014562330669573766, -0.19148938046307945, 0.5804775717892855, -0.29014265623721824, 0.14056301131679416, 0.012935484019082375, 0.19221223132329485, -0.047821900298008847, -0.63121570177978292, 0.076282162027643444, 0.064966137433254162, 0.049328239335300124, 0.1638342472910318, -0.34324019457074018, 0.10631642463239177, -0.57458445157724203, -0.30215652773834228, -0.35758929507195625, 0.0051647774475154437, -0.082231729660807745, -0.03172245939701588, 0.19963392263844262, 0.15567056805739179, -0.39835884579168351, 0.12438453619690824, -0.1073020516325781, -0.28449690011909812, -0.17547171900106792, 0.13297074031708508],
                             [-0.3495895760411904, -0.1158386492879639, -0.10657281510765935, -0.22556078366893592, 0.056522190530256831, 0.15403996247550752, -0.11183806562377732, 0.22415748557313725, 0.10173049644154485, -0.032341824411703059, 0.10067391386847131, -0.045885918263677009, -0.20957181658189414, 0.20932033762316413, -0.023216012026128725, -0.27380807359012649, -0.31758393273289615, 0.5120142217809952, 0.043708351443374815, 0.11067244522209152, -0.23873524775730456, 0.41531529387127702, -0.57116324072352376, 0.50097932361036057, -0.13771171378277111, 0.36398872557676881, 0.14817395471239431, 0.49601735777777783, -0.19894434873703407, 0.10951895541206177],
                             [0.41266515771133888, -0.024739402595060536, 0.068731472613582603, -0.21858223753359537, -0.18044881181614783, -0.2926065875159447, 0.13986592806098175, 0.58906142768762104, 0.11776602227185785, -0.4232803481024196, -0.25889066010480122, 0.16778069036231211, -0.073841227089998643, -0.039748453720211192, 0.41679369362342927, 0.52145779937285341, -0.067643042054606264, 0.0028959461237473005, 0.28214331101148743, -0.024214514350982874, -0.054042378065495035, -0.044875859734727755, 0.036862946357997486, 0.36079740934949522, -0.042965773717151864, -0.19603353515403357, -0.25164412420372939, 0.38892985925571139, 0.35651408389801725, 0.4313924573045449],
                             [0.27579013254195694, -0.39732320174687902, -0.31907786423396456, -0.13343956471879836, 0.43474126566827531, 0.038395081896856774, 0.18095119885047703, 0.31711529867301469, -0.81122590928622906, 0.062834885613155519, -0.018310922912611383, -0.17170172874539111, -0.56119411558274168, -0.17329799652265829, -0.1161572797071517, -0.28986547555360503, -0.13674105646286017, -0.16891643182757063, 0.2171335879356372, -0.14650610864521998, 0.34473941243186335, 0.11756391890730096, -0.23935099648793001, 0.073038490489634664, -0.041213099819888271, 0.20452570934283468, 0.037252527526871915, -0.13095887984737842, 0.15747322259666999, 0.050822381570462261],
                             [-0.028517673744964774, -0.1848954931483166, -0.007601409031103127, 0.34355610198802222, 0.33256229987114039, 0.53076404498794805, -0.12148033329775934, 0.14364987682074468, 0.012106398790107907, -0.36867073316158083, 0.087885044187217098, 0.55362549214671708, -0.17958840148996602, -0.074046743288071204, 0.038926446840963844, -0.071774614878256385, 0.54452357341991187, 0.53454600289307008, 0.16025576923970913, 0.070018662543576485, 0.045166665934225643, -0.39365127406423472, -0.13721851808146035, -0.1685393001871123, -0.11686666723477869, -0.045683097581521406, -0.212964640357893, -0.22225621083149485, 0.19346217555861808, 0.34835562354356292],
                             [0.23291869758605044, -0.14570221424098309, 0.055562248451088814, -0.048634217519922911, -0.0020415634102775681, 0.13942985235269426, 0.35046921641131856, -0.36192515607851544, -0.055769281814570915, 0.21000034809730697, -0.16547823452583105, -0.11500417199625319, -0.09018546007639458, -0.36824030845171135, -0.11403494378837334, 0.164546441625366, -0.34205121846853093, -0.059194227549121459, -0.32453960709650115, 0.13954446054795433, -0.25727248011792864, -0.12283924040829422, 0.27266411235411631, 0.23009044554847938, 0.20112042961603901, -0.0078573975805074931, -0.055074631226827556, -0.0097131464100450524, 0.90470838308627244, 0.30296905495022997],
                             [0.13674471312490327, -0.3846968374105964, -0.34045795131982537, -0.18122178137358805, 0.049280329254640327, 0.12525738314628429, 0.26203326593025866, -0.32381980102870872, 0.21757138400662251, 0.16798154923528597, -0.34909528930726286, -0.032192675643425019, 0.0092453303075597463, 0.43179447530530718, -0.14897547104179792, 0.10162447963277634, -0.16339651722736973, -0.26238871113048867, 0.14818026973901327, -0.30543505243660996, -0.021276845665901659, -0.6335904116496035, -0.27151782221330345, 0.24017264848150474, -0.038623133248027165, -0.069956945649226485, -0.53948357297372718, 0.14620507077006403, -0.4756412467248759, -0.17507060154816373],
                             [-0.33499912898405904, -0.036089343941173649, 0.11441747441077786, -0.24381917903569861, -0.080894718021753048, 0.39500187461952246, 0.15616730525200115, -0.11217940828551837, 0.45090363320333277, -0.29856051438126902, -0.39194220435441862, -0.19055853970021644, -0.35702449249976675, -0.39864366673640667, 0.0019250812187587181, 0.1528810390166124, 0.13731122421908445, -0.011924035893313582, -0.070664444578252092, -0.03051327507172449, 0.42021130600715884, 0.10860982302285471, 0.27565936551351794, 0.029246611041583992, -0.097783505134126369, 0.049900987864575683, 0.16851005552924092, -0.39794243913787791, -0.48841932123829451, 0.29704083874747955],
                             [0.054861997621236121, 0.24093805090973766, 0.033031453892953713, 0.53578334681168371, -0.14670584684960419, 0.56261246249238828, -0.28377580818429982, -0.018275238688745858, -0.17466805402888613, 0.58778482650770025, -0.17886201533206825, 0.14061389027220678, -0.42742073496477123, -0.19509410260121279, 0.12187990694244728, 0.30691801496077653, -0.20336869961693788, -0.16663264248943138, 0.42155378747219435, 0.36900500792615709, 0.21847761490759923, 0.29286016128309589, 0.19181604578687875, 0.20097199768618243, 0.17694782886451474, -0.038862614157441369, -0.1024893512559988, 0.089934053456629512, -0.07536844548500321, -0.41909607326299453],
                             [-0.12256369675574175, -0.14041545207880299, 0.37218932967907681, 0.0019254906703872515, -0.47981899379316667, 0.19505433530113639, 0.4431721510942227, -0.21456300276224774, -0.062128848519063362, -0.34516771969300414, -0.41200781555557886, 0.37631171529017637, -0.16311331088484857, 0.40458465660354359, 0.33907853275907923, -0.15868543936856383, 0.32013756988869835, -0.28441093375635951, 0.16303401656598243, 0.18441907790441395, -0.34441061277510832, 0.18588218463597184, -0.17820613825860906, -0.23797007418484623, -0.06195198515131399, -0.11332665369219161, 0.22268263357370138, -0.15891261711575649, 0.1167453808164991, -0.24464318094499451],
                             [0.25729827104378783, -0.13135078570590969, 0.13479612873563651, 0.10890738612634228, -0.54826153052080329, 0.044213029567425503, 0.36049179007873683, 0.24890885068867932, 0.063766491201984146, 0.10969950394013392, -0.1093162527587124, -0.11139231249914941, 0.50221886991362696, -0.24032275892756172, -0.19721736355625616, 0.06098739257762377, -0.16800209001176833, 0.62435111651379094, 0.36801598501164084, -0.4580853680864711, -0.11276608885491492, 0.12783538080979642, -0.031866541308312631, 0.26905794572248404, 0.024148660418880259, 0.092260570065862815, -0.27359453492025032, -0.25140502838511303, -0.02790070074729472, -0.091758588544990805],
                             [-0.0048166328874917445, 0.054296528456523274, -0.046896873733482919, -0.62623897667909301, -0.027329119953076735, 0.046951292776507107, -0.3203066485314936, 0.098575905907120218, -0.45418870392980204, -0.0010267712416877316, -0.38819684429462148, 0.085200288111209208, 0.068130931396835862, 0.21390974228839657, 0.16870201175655591, -0.28305701314301285, -0.04058047542851391, 0.41507248358290078, -0.20180430845159517, -0.020476207425412611, -0.54194481663605898, 0.16914459454316061, 0.5320410298219922, 0.11339431474449504, -0.2964274751695074, 0.13111692205220654, 0.068906928618699306, -0.26487409309329246, -0.14074036697502687, -0.01502806915286207],
                             [0.35325963075390621, -0.0044082114190542449, -0.027102849032886338, -0.13033449477685202, 0.003718333419435357, 0.069393781284656272, 0.4496068723553367, 0.19470775525166634, 0.26729875821898774, 0.45971431373126687, 0.48383094962986406, -0.093229762835216612, -0.38299001416923412, 0.13947942000869565, 0.47975419444194917, -0.1759275985315388, -0.35766213732932911, 0.11385051008464196, 0.060248500033745489, 0.049386516680871961, -0.15528728601535804, -0.28996243967395618, 0.38728651146758408, -0.50286611185490615, -0.15961249617600529, -0.032493520767872167, 0.19001124646035494, 0.23318945321933471, -0.084251242382370112, -0.03188649052653416],
                             [-0.12112813978721143, 0.14630131390560372, 0.22994052147393326, -0.26426592753473815, -0.36570746784880537, -0.29009462007982695, 0.11572400618485004, -0.36998681633314878, -0.14235401757123059, -0.19259349490959021, -0.084342071147566033, 0.3920040066188098, -0.31563079620830481, 0.01622236011652578, -0.42819066553682888, 0.26928880767113383, -0.4399014113161262, 0.21046129741070588, 0.32570975388429846, 0.27847949166863789, 0.36153514564224642, -0.13621796792592811, 0.114735355210724, -0.42587265612802394, -0.031659319527125064, 0.42407385200640019, -0.13077171747384797, 0.044925688653707066, 0.087623684340283142, 0.15791414490086148],
                             [0.016712388188682231, 0.23607481846367404, -0.28881417688936845, -0.046307970849233993, -0.17956096736448618, 0.095261847312553771, -0.201000236525362, -0.27717034160603449, -0.087594308482128333, 0.16800737429217161, 0.32601335573827039, 0.15063512941807883, -0.19439559012126159, 0.054818550115311837, 0.034849434126694001, 0.40872435051715622, -0.059537439156777672, 0.017021857673163637, 0.3206039314468222, -0.32438705999203254, -0.25071847086073928, 0.22669380615898505, -0.26740212749964065, -0.28813251396996792, -0.36396767572795685, -0.30354377972729496, 0.29312420190490401, -0.12102978874360669, -0.038152015475060905, 0.86001510730974529],
                             [-0.044218652105511784, -0.29282360021301201, 0.24828968216831943, 0.1438011326102383, 0.57117044265359007, -0.1807593145493531, -0.14668434866284252, -0.10235981342915895, 0.29321702912715059, -0.064364412705074828, -0.23643514274810737, -0.057167405132454892, -0.11009412020662396, -0.22770581210924923, 0.033719528980321489, 0.014307468134363068, -0.42133232739913717, -0.23619996007962324, 0.19262146348209894, 0.13778459595644918, -0.52106664254996349, 0.26736534032102682, -0.39139265808231916, -0.40464920278505068, 0.027426153690619067, -0.140819482450041, -0.30846957780376105, -0.17636885744187403, -0.064581905935322551, -0.13726980201396013],
                             [-0.07492112507393589, 0.0077551140085590229, -0.063941696245690086, 0.21380747999914954, 0.50870604260439012, -0.17431732101502445, 0.46647071030996301, 0.32741861897841151, -0.015167486999357709, 0.20328235824334825, -0.4845152412972546, 0.12227935258049723, 0.2592587279326547, 0.061712090748084245, -0.15797567076343152, 0.10313421460326992, -0.013608741174948175, 0.10454411481457943, -0.044087423500414051, 0.52744302029603496, -0.0034683046444500248, -0.11116968732135089, -0.1664176505239417, 0.23715795685110883, -0.18885000200865526, -0.37702206787721254, 0.28663894701315273, -0.22386751336821437, -0.12256145937558288, 0.17418574671725467],
                             [0.54422665798986725, 0.17631629488090853, -0.17322793098163949, -0.09971281303309798, -0.18454345823199131, 0.25894830063495011, 0.0029946426080348877, 0.27707927687218364, -0.014448473678010394, 0.21396831380441014, -0.1959978165975762, 0.23344525813233619, 0.18817146172011601, -0.26362160547483815, -0.30887875348719235, 0.030873604412086298, 0.28963084390066435, -0.31772126394957811, -0.16476687426157793, 0.12020242167029191, -0.37656511995225522, 0.094127022037222799, -0.26769268352045861, -0.3884536870959493, 0.53651144390569006, 0.44629653720538826, 0.24582066435432523, 0.05292754850457411, -0.27566174141594268, 0.50288647479859905],
                             [0.097966175133515618, -0.082244999543655994, 0.13418900674621306, 0.16311741402942792, -0.36722649275695501, -0.28736069141154619, -0.26643541134168436, -0.021061082017357527, -0.058312272250686442, 0.40424112180861888, 0.16291402346344147, -0.12021351223529676, 0.13498621436567065, 0.093405843511104786, 0.44115566150940083, -0.25926836647558366, 0.011052145361739971, -0.098004805199281175, 0.0083732798234428876, 0.56983630911707372, -0.011482591698544105, -0.23159658360959998, -0.36476955078351031, 0.24640825754975693, 0.067827539550312163, 0.037619672951908739, -0.39776053230516895, -0.59314844332063843, -0.19047248194182637, 0.3981313957894595],
                             [0.35607439611299241, -0.0540217682846931, 0.085115635748105614, -0.044865260955999645, 0.27759148990290849, 0.14832565658419855, 0.072732125449380777, -0.31987528982430197, -0.037381361374818879, -0.086655634749599475, 0.015508015539554221, 0.018377047435324687, 0.46823739374112766, 0.0064740768010936034, 0.43195231427397202, 0.63436910901933685, 0.059462520317982819, -0.10087882816224716, -0.24950274779249751, 0.34427194947628925, 0.34120280018827975, 0.13460406364277061, -0.32494124392393209, 0.056195138055267824, -0.61099000294786032, 0.23778715602898931, 0.16119952401302307, 0.17665677235170696, -0.060483176887781404, 1.7446854152496083e-05],
                             [-0.17716131240538655, -0.023768432832780677, -0.17610349345526782, 0.3410918662141843, -0.1938498172067791, -0.023208211698351546, 0.085111610129914889, -0.019204548606872995, -0.4900649381822284, 0.061863376921428063, -0.30834050973238752, -0.17287654986369885, -0.38514404923853479, -0.6443669525110457, 0.18674109393927119, -0.066804072100898546, 0.10400312854054883, 0.3039153098211041, -0.35469762357561413, -0.14540619712468875, -0.068171379634472451, -0.091390266048815047, -0.20895373402108361, -0.39726201756666452, -0.38970113913545379, -0.42147039146250798, -0.23216637794188122, 0.40546759976723734, -0.26357411690474664, -0.14840977331569477],
                             [-0.11948022434424198, -0.026308488702181644, 0.32680743090516723, -0.15639913211425863, -0.029226695105056974, -0.27868961256058816, -0.12486887403987199, 0.13935098305886431, 0.19519732403659185, 0.30567569314859827, 0.032971579930557798, 0.25559002860402447, -0.18489705404648829, -0.46536859699692718, -0.11184948967083672, 0.0099587315664563334, 0.32942861435799076, -0.31930223767420429, 0.075729121379984526, 0.046782919451466703, 0.004792283308923919, -0.34559491770318135, 0.13950717406656016, 0.35118994720986146, -0.59285224068810805, 0.22243495949924566, 0.19372081496521687, 0.03506803564242441, 0.18460530085926904, -0.19377348704194772],
                             [0.49252178116118489, -0.23866800995862572, -0.34877802960429671, -0.21305925802542716, -0.058144432672822433, -0.14858388134277956, -0.14464201514246644, -0.093219621390639565, 0.25660143788266426, -0.21924029461566841, 0.23248136843838657, 0.37136680161462787, -0.44349759664634603, -0.26525299235017596, -0.18107257600886495, 0.1303769263598743, -0.014828220362111847, 0.11421819777771564, -0.23229640616528585, 0.11628830493594358, 0.02605084927997366, -0.030447967210981246, -0.35035981525245635, 0.12942139187768562, 0.3200059902507405, -0.47408535788904521, 0.27492949846036752, -0.36716740316714164, 0.14754739918503623, -0.58656052766366384],
                             [0.34147020485628232, -0.32944634375176302, -0.36657018671280306, -0.036776741431776637, -0.13296216627008964, 0.12355492464952769, -0.32091722585367166, -0.18890925560093871, 0.21491662787720667, -0.032301205357453205, -0.076110728769030939, -0.31575180202650877, 0.28969517233938807, 0.07455483263963314, -0.23700842225427488, -0.41334278170238686, 0.24409752424092951, -0.12954781638110618, 0.36417155691969183, 0.49027567552952228, 0.32002387954709222, 0.36796692145935767, -0.011518191260465719, -0.25525334857105292, -0.22212847471526678, -0.40437292519566226, -0.07698031768881862, 0.073162399626365074, 0.18105936429643243, -0.017413970715823561],
                             [0.18438069874698171, 0.47828595918780348, -0.41790026414657611, 0.23340338918391779, -0.0087899078798430313, -0.21609259515368578, -0.13442787362899608, -0.37404476259667713, 0.22135324196669087, -0.15684466282926154, -0.36818881064014597, -0.013777630323229192, -0.017657836367521627, 0.039388590003676963, 0.31657334858742425, -0.18866859241378184, -0.15454063713481409, 0.048456346369545371, 0.23097575905137405, -0.062974801789384971, 0.034463036377940549, -0.11350445207976453, 0.039233721640060476, 0.058797606275657721, -0.097993995452767449, 0.41868987725993839, 0.58907821239215763, -0.0015708617689269835, 0.036797996122494819, -0.15531571764442881],
                             [0.098976584831781012, 0.38928956148660343, 0.035738168853528686, -0.075846066100847612, 0.024255814550721736, 0.0011807849099093786, 0.14881652768472789, -0.038178100459493484, -0.26409895104932946, -0.70981728437688085, 0.27918008013945927, -0.56432332403010832, -0.01080682634995608, -0.27632695664996743, -0.41806788562260999, 0.16500765742207407, 0.053421341886212344, 0.091654612355416276, 0.47156387259494087, 0.29293520847192867, -0.49421540531567526, -0.4081415680165803, -0.041879502833493704, 0.17203727605432367, -0.0030576350759574135, 0.10710097615949921, 0.19932945034229263, -0.037833316575087456, -0.34185587088027758, -0.10787284126019869],
                             [0.35553583101857361, 0.92069505339309143, 0.21680204215665944, -0.17638035428547247, 0.34928182053676476, -0.088194897957561483, 0.35504091417479217, -0.18696130537902644, 0.090075518358299939, -0.070083125969391508, 0.048199788155178461, 0.24809783748211092, -0.0045175641440210433, -0.11617676283017658, -0.12288883465137052, -0.62849654322691795, -0.0104312853390245, -0.17578118079408656, 0.054135310705930084, -0.03603905548680926, 0.35068171060235931, 0.16046337254126147, -0.14425907575191527, 0.098784049228453422, -0.32566712316947161, -0.1749912677276072, -0.54096023896027523, 0.23363524160949639, -0.12133172841164339, 0.098518445735556265],
                             [-0.30086142961748896, 0.28596288010562654, -0.41102952760129191, -0.46258670349937503, -0.14619709515664367, 0.39255454207452739, 0.26356876810303526, 0.22950965913362995, -0.0040833677395734069, -0.07789457181199233, -0.030415940550928125, 0.14331657813015378, 0.41289538688183741, -0.14193159563267835, 0.28605163946586176, -0.11398679225160867, -0.2763132894354185, -0.017262644990668263, -0.12454015823799389, 0.14423724652235526, 0.072612154963735354, -0.45980727903588353, -0.33047266403405018, -0.40735497111215752, -0.15181207014977455, -0.084071109618116036, -0.014820533272943474, -0.27646365375621057, 0.30294191778550827, -0.22552386310761566],
                             [0.32563466436216071, 0.49445574129901315, 0.25479784854059179, -0.12000609032902246, -0.0040872789498966836, 0.18154470063704073, -0.13521129829948519, 0.37335644700972737, 0.14376426407526452, 0.018552821133418808, -0.14654267162824855, -0.82327601031870834, -0.3687379591357316, 0.37434879960713074, -0.29209752727474564, 0.32134280612704924, 0.22680670640003189, 0.090230247598869801, -0.41150820184030484, 0.027715701159293789, 0.018746979681356978, -0.048520564697714333, -0.22586019010465033, -0.15583802537775029, -0.24167921825209099, 0.24546191324968369, -0.1135492644240058, -0.19057652285102653, 0.24768750628250366, -0.1485009312726811]]])

    matrices50D = np.array([[[1.8678003655919158, -3.5383312120724368, -0.50996507726435869, -11.564845339850887, 5.1045297650950001, -3.5787361701421698, 6.3587736446676191, -0.25854593910129908, -3.3775244946351379, -3.2342794086427618, -4.4231130960479099, 7.3119153496915343, -0.40305385176113706, -7.4570809319548221, 1.1579314311749469, 6.4081093329884613, -5.6313304341329715, 4.2578168154446798, -6.4550134414321834, 2.3801196984142163, 6.2371285191269372, 2.6582756846917333, 1.169436844995295, -8.8604345947170451, -3.8380952806871886, -0.14123085363151056, -8.1025069189623746, 3.8116226458286486, 10.253997922436923, 12.473769810047436, -3.4558699231151597, 2.9321369154763688, 5.4350508000487823, 0.53590903801355294, -3.7082686300497278, 4.9174766472500568, -4.561197342206019, -8.6663719680431974, 0.23784588197580536, -6.6261723777569612, 9.906673201650575, -6.1864591952470862, 10.53229266627234, -6.8879520731619817, 2.372933134696646, 4.2419597328282883, -2.787723886062734, 1.6867369921384006, 3.3222291778431208, -3.5193412507864124],
                             [-2.101460409026382, 0.15734937916588043, -3.0791198715529089, 2.5996540006596294, -4.9678425576493712, -2.2107324959757477, -3.7736408743227088, -0.62785586098436585, -3.7118769799085154, 3.2670086307734056, 4.786375640439668, 1.2817757759696384, 9.8413686589306533, 0.14558601191680176, 8.5442225439313351, 5.718863259230675, -6.0259208698036888, 5.6175463139788864, -1.3477968393136932, -0.59661437193241484, 0.45745153979639297, -6.1600281547340998, 5.0024425036555273, -4.7186462355123622, 3.606617678248889, -1.5548670259456903, -0.2156915254838776, 3.8319174523865933, 2.2594553307250034, -0.13676224634828582, 0.56560002494312211, -3.4609401350468643, -1.9905168170055212, -6.7064841851730979, -2.949169352607643, -0.65067902510516795, -1.4925427939095588, -3.8150762311922675, -0.44625482453314125, -0.66632076270600171, -4.4004535521799868, 3.4248333736961678, -0.12108461703875117, 5.9525325726061791, -0.83091365977097409, -0.10996240114487299, -5.7697878858421872, -7.7896384195433948, 1.6625492703920151, -1.6944762922061543],
                             [8.8843001030153577, 13.583551557835822, 7.335931237955684, 6.5171280176261011, 5.3858738678566498, -5.7945529600512593, -8.908206658319779, 3.6242703190848111, 0.044155689651625529, -1.2269166757538184, 5.9018126332028675, 3.3240585811505512, 3.5240415295785614, 3.9183207147023316, 2.931360497830342, 3.6256019745905621, -6.1785153838420364, 0.66622152010840985, -0.9496684351953899, -0.94314038393616018, 3.3036263768523551, -2.1052546028342092, 1.024948114210658, -6.1023565109750084, 1.5455401856428732, -6.5342184021836172, -6.7717647989997873, -3.4395143041574596, 2.2927593250045311, -8.9111860638232834, -5.6020137341183265, -4.6092382408435695, -6.8334434712164107, -13.583150269649792, -2.0214847496045576, -4.7802903674497159, 0.49398257041666804, 2.0319504999731888, 5.3239512545639212, 4.1296249338570892, -5.462948660604992, 4.6647859139345229, 5.7566232060763562, 6.0330545190407321, -1.1156422888902731, -2.4039517416430249, -5.1765602559455592, -1.6888380754823467, 4.9668693664954802, -2.9106372935585956],
                             [4.8421166411612404, -5.0044588397398311, -13.699744489158288, -6.8525143575433747, -3.1372766048771932, -3.9048861830055146, 14.914417363936373, -5.0750649062153919, -3.0708649433378215, -1.5287832151077545, -10.126308016715562, 1.9884387964093484, -9.4887191368887578, -13.054909993939727, 2.902371640574525, 5.1402852244181947, -6.6992538992150052, 17.306517491864842, -5.6659381056166431, 0.60849290299499914, -2.0540365865994343, 1.3189136806552926, -1.096649196582715, 0.027964660595062529, -1.6982712877555346, 6.2747857537825817, -4.872059249690964, 3.2162774244514867, -4.13764494300049, 0.93667496164813802, 7.2867721848257778, 5.2682336787428596, 4.6814370143278348, 6.6448802291123128, -3.6198194818009681, 4.2098821836757931, -0.95604003120364656, 0.62080167849300549, -11.246287242631739, -7.2778082686944181, 6.6710891321778796, -2.2104249971006862, -5.5579900659219899, -7.2473186523478237, -0.19599586397863789, 7.6303304293116803, 6.9081919508557847, 4.6713352500558534, -4.7725780802806756, -4.1316497391246747],
                             [6.5508585295314576, 12.850158059595467, -3.7839726645962983, 6.7576164576826194, -6.6172331090970431, 0.50845274810148511, -0.75164943373023529, -2.8982445176032607, -7.4169468842550552, 4.6374727763807453, 4.536442970944603, -3.0737619686037068, 3.3640959259237455, 1.0319574505855913, 4.5072999596171552, 2.9726073844599474, -5.8308438634367379, 4.0245541714567405, 4.3194104199070553, 0.49728833924786642, 0.86982040166323005, -5.9018187100618675, -3.7333250575427961, 2.7494434668722905, 3.4425901448111085, -3.2856042335991584, -0.85361250555907553, 0.4838656684677527, -5.3206853801325353, -11.103024365836038, 10.063744581361259, -7.4173084789681738, -5.6921460431371713, -4.4650765655115627, 2.377151929940315, -2.4547048378449583, 3.1715793555073266, 11.42031374542422, -0.024770111781333704, 2.5536269924318549, -2.5906622654304523, 6.3761211686729879, -2.8190515018365163, 8.1326865816003533, 2.3881783725051013, -1.8512764071347647, 1.0955053807568316, -2.3266886003300113, 0.43006060640621691, -4.7171417791592427],
                             [-10.52887576332934, -3.5239527693634805, -0.19992088728954571, -4.6184698417290484, -2.604916890781408, -3.8431287084773222, 1.9000676875910221, -1.6916515408511623, -2.3065354275908665, 4.171013028172541, 1.4139826350216698, -5.5587585241743351, 4.9396969217918754, -1.793281976778774, 2.163169177858697, 5.6157312676918991, 2.2960926168822557, 2.2847590130952962, -1.2649069010814677, -5.2503124482948955, -1.9106334358862767, 4.0799186663857894, -0.97223842761291079, -4.0053895252471019, 2.2505272591590688, -3.6977320323924268, 3.4517570196760672, -1.012235314419808, -1.288718079987027, -1.8301430048629692, -1.9628889940158456, 1.5885526432643067, 0.94849912937829495, 3.6599893097833895, 1.8240115038590012, 0.16363235182529046, -1.7170448989557485, 0.45166942409128008, -2.9022277110672423, -0.79078016021442121, -5.088619902427749, 5.973232628066695, -3.4873191142383018, 3.2505660184763068, 4.9146245409948062, -5.9361278407810669, -1.3778848006716728, -3.1940654349210478, -1.0918590634905732, -1.7314634392849322],
                             [-1.7882347635828617, 2.9230620611090727, 1.5138896255387166, -5.6017193661782914, 3.698223685253117, -1.308067726293674, 3.7593889152473312, -2.6030384875651427, -2.369890584758692, -1.4062011361924922, 0.2865123419469926, 0.33120932767543954, 0.30754593928880869, 3.7864579232861901, -2.7318290301149988, 7.2532125524619318, 8.1312703983542853, -5.5051715042150011, -4.375243784316714, -3.4443141260186798, 8.6355702428927472, 5.1854898326683658, -5.4845269278514346, -7.6672129858200124, -3.5870895841362755, 0.16162504980581049, -11.199332128255037, -2.7125383515326877, 9.3770687336079916, 0.38524179397530989, -1.3677243547515729, 4.5639588431193063, 7.497026528527674, 4.5091012299140214, 1.653718907273426, 3.4353572820920921, -2.008539978666553, -0.90014045098641571, 4.248685943990635, 3.5088702370147371, 7.3609303664935242, -9.6335672885507329, 8.7755751727512799, -4.3732285411852327, 4.2419210918843913, 1.4614490757275818, 2.8977569768676132, -2.1292678482857719, 0.39832749685825153, -7.9470268316182739],
                             [-2.6889872929488585, -1.1216093735115724, -0.15171943849492697, -10.228410670642511, 2.7264050629884702, 1.5218813414256631, 4.9578592691506325, -3.130765826134164, 3.3123440323567248, -0.76143280069639585, -5.6018432970711372, 4.6187013237931787, -2.8815213501870671, -5.1580788398385788, -8.6378737697391497, -4.9008695558102184, 0.95342574096303423, -1.0023692921061029, 4.8157382015561385, 1.7797272674595159, -4.2064328721871842, 6.8374521139923283, -2.8914659981692274, 4.9710531606916835, -7.0910793707393562, 0.25347824563746713, 6.4329107300460366, 1.1052353133514845, -7.8935447398996068, -1.0562738513968464, -1.2965166784503259, 3.8513378660395627, 0.82596047518627058, 7.8083305811159311, 0.82384941485869245, -5.6929314767665424, -5.6979163193823918, -1.5289906262771629, -4.5220072691454014, -1.7566966608927146, 8.0196979862971212, -2.3611939958394634, -5.6296452877336511, -3.9797103287333817, 1.0661229486292496, 0.017927714570032283, 4.2284945000430554, 4.4785310668928631, -2.8871290585153253, 2.1998968687939162],
                             [-0.22584046346044953, -9.058422187415152, 0.42580659377727237, -6.9845870662383502, 8.6542216470840287, 2.4383209383273572, 0.7274084256552904, -5.1207708165474664, 4.2655255320321492, -7.2796895501964345, -0.70690211287547089, 0.24666482113477639, 0.4717481814700869, -0.8409262554202428, 4.6301360184042819, -7.1381438982825536, 1.9820097339387952, 3.1982975696479596, -7.7373237949387335, 3.4989249044778394, -0.40021673313292971, -3.7210546613696249, -5.557540389244056, 0.066958827940771737, 4.8231393232916862, 3.6536684173883591, 3.6946480108986295, -1.3983494843469291, -3.9978299593429139, 5.4118139273801127, 0.83109001415420614, 5.9086729820099357, 5.7036582151985815, -4.1009699773829329, -3.1887227075099145, 1.1951355627223808, 7.7182060481016661, 1.4443190465040736, 1.7884157967144139, 1.9960623625174378, -0.88819761595083868, -4.2111838560712016, 5.8076433319955045, -8.6533973606253429, 2.8920403520786846, -0.17671147521799568, -4.661577553840961, 11.943387500172227, -3.0767975645977943, -2.2978943784424692],
                             [1.0426046299329839, 0.1966897625133569, 2.3882283775352633, 0.42467904752242447, 8.1879985811119962, 6.8086117613140553, 0.95872905083764071, 1.6917477358552502, 11.470356114612015, -1.1458311301359647, -7.4247716451794554, 9.822826526150287, 0.075314823677724796, 5.689698853132712, -5.1674779397946358, -9.2217917228909432, 0.41973212300313439, -3.3332917163740077, 1.4910193748503695, 5.8870856262307694, 1.4345202395469348, 3.6742245966623779, 4.7919920176562698, 6.7816669517622632, 2.4150102482844429, 8.6783765869649372, 8.856162196636868, 0.28118584301317873, -5.7758996088349956, 0.52619711198509056, 1.6423103546247162, 3.340558021392475, 8.3691544641340769, 1.1447693131152796, -3.1537008409689271, 3.9584463285971219, 6.4446622719962319, 0.10396967871639606, -7.3899434034320324, -1.8257457723752011, -1.9923505537165205, 0.29296245592047754, -2.9709146855086797, -8.6174585921577549, -4.169502458276388, 2.8680220087276234, 0.31550539341997719, 6.5713886679262545, -3.1805714274148196, 6.5421162394812447],
                             [-11.643379943544268, -3.0259910576350375, 3.587043981002878, 4.3830865409769206, -2.9254471075664843, 3.128331410594599, -8.5232105322114879, -3.302280191902204, -0.66276052728856516, 5.9995280075186024, -0.7922989989198248, -4.4373626982182008, 7.6129216033700606, 2.2775723843011857, 5.4943328632225228, -1.098891216889756, 2.2157031001973646, 3.5655565727891183, 2.3229286824543007, -1.6057949112985967, -3.9596688561600821, -0.65121859939154803, 0.25559257264258561, 0.43207757868032692, 6.3194777074492388, -2.7763590385878345, 9.8569534689527334, -2.5625114363462043, 0.80501896557284702, -2.505991222422316, 1.6885191431412165, -1.3932269811735716, -2.0233921951468599, -4.9979840248209628, -0.55593873131295435, -1.1904181265547704, 7.0293136547211299, 4.4972649430792497, 0.53475897354381408, 1.2073793440679885, -13.770575320187701, 7.5235438080706203, -7.7268470374198728, 2.2976456262539053, 4.8306491957843036, -4.0336396354395427, -12.080765404569387, 1.5321713551263514, 3.456368784816934, 2.1247440230737205],
                             [-3.9325687941287484, -1.3711276620613639, -13.661035665233619, -5.7850583898874222, -1.5990288226252454, -6.7080212250028808, 11.114812292290761, -4.6985082605056068, 0.63370636552054582, -1.0004034618200188, -2.7842406919835194, -4.8233339786142526, -9.6952567662088374, -8.7800091382652337, -3.3481030223619461, 8.0263898267081721, 7.6214534539353576, 5.3561766585420738, -9.0722172522634672, -8.0175531145966126, -1.2841353842257788, 1.5113030341001223, 1.6482815319071968, -2.4878282252248995, -5.7706900063843536, 9.0603562500802468, -4.0061421163483226, 2.197409753357392, 5.7871694161023903, -2.8675004225321512, 2.182104397963557, 4.701170840643532, 8.4999411585635052, 5.1805007872321047, 7.0819874911287837, 6.0585202651252237, -2.0283683446404943, 3.3030085365876451, -4.9725142564687195, 1.1547610435747886, 5.2340535033032323, 0.7643466195000892, -6.6720450818209001, -1.8034981467694369, -3.5821220154340532, 4.3808991830038746, 9.4626918788685668, -4.3246858874888598, -0.58647442107496106, -3.8748557342446932],
                             [11.652673816120501, 10.21431748395403, 6.1120488403529478, 4.8211571293401239, 5.0806709616818519, 5.9846456957979921, 1.9940189248293996, 4.0660930260478727, 12.253253302050569, -4.7675606631380498, -4.0078508680264937, 6.04374620937792, -1.6675682681137558, 7.175709290043633, -6.5369862142234219, -8.5049122500515129, 1.5693125636341168, -2.8951337601026643, -0.34222229199636006, 5.9892995192172886, 8.199114097803621, 7.1632772117684187, -0.54550539947100452, 3.089286825207938, -2.3195508816431327, 6.6676042104748765, -2.6616213679393681, 1.6776539572456606, -0.25418825946025697, -2.9976497618196922, 2.7490148403781403, 4.3398808812445049, 10.250180029184175, -2.8802265556598883, 1.7445684295004518, -1.7615086024742268, 4.6164544683595601, -1.5587276526164748, -3.4932172971309838, 3.5357515287637913, -0.4130639398117304, -0.6347706883498756, -3.8621153415005627, -8.9538940448118947, -6.3287360647891768, 1.908661029826904, 3.8795944726884182, 4.9126921620936264, -0.78884137692427703, -0.10442898294107308],
                             [-3.1908912883637508, 6.1655164252301811, -6.4616087065133279, 4.7796320398298171, -1.1764306487740863, -0.29454509536304335, 0.18602357698851801, 2.6449869611559227, 6.6006990879792493, 1.7443703615128179, 1.9167865609978201, 1.2198717643893531, 5.1961796700259439, 2.7935391625793562, -10.110022400378808, -4.5652073365721622, 3.6303131250671195, -12.017263642537882, 3.6125900206229846, -5.0461612215973268, 0.91107063402973232, -3.4903059190832146, 3.9170116955702761, 7.9814895091536524, -0.45058862729896554, 5.4994494690186517, 5.5813153668455575, -0.045170936792762184, -7.8047095828144428, -11.098664969436719, 0.42030641411857894, 3.237450318089699, 3.7297721276378093, -0.11889672927485856, 5.771770616821116, 3.075048228892916, -2.0772612653541538, 5.138560467801792, -7.6873043264531153, 8.5235227685452237, 2.4142081045461921, 1.4673815909239374, -0.71082290335652565, 6.1607875360321973, -9.3186554945783584, -3.3884747391219965, 11.070444846780896, -2.8921349959635547, -6.7974577038265425, 6.8653029823720795],
                             [-2.5656247277385091, 4.6476161006381282, -0.43399411232843638, 1.150593027426535, -6.198772485823671, 5.7815281679306079, 2.4666365251693598, 0.80033045397258151, -7.3657067266223955, 5.33997693368888, 3.1220293900049749, -0.75390222383061911, 3.6737781691969795, -0.3751542704678188, -4.3539239351654553, 3.4313242836615783, 2.6792114944202408, -11.183980975830769, 8.6971617893553734, 0.45993429010660508, 4.8328873128746705, -0.81767405270481552, -0.90220817813849341, 3.0873529486061924, -4.2526434401858442, -1.9994802061713512, -0.45591615999549484, 2.8725439572560427, 2.0914812007902279, 2.566334594437754, 1.7539457353550556, -6.0493444273332022, -2.8313658856485531, 3.7496389655247873, 5.0731475015284895, 1.5335530421557297, -3.0432286113229066, -2.5181822519174335, 3.019328514792559, -0.46259763722720271, 5.0578599067339614, 0.60077782330960838, -1.0615281055429167, 6.2798893469856392, -1.9986667372011651, 0.94111240814217056, 2.8563929040251153, -7.4426040350102394, 0.98889980871952232, -0.80662741557381556],
                             [4.1782976975200858, -0.11485868504005239, 2.9918228427510249, -4.0913560910096241, -3.1303799166386406, -1.5470719509950861, 5.9157950807300681, -0.37795004218879935, -2.3936649733120428, 0.74459247398661388, 0.62217577252765721, -4.1917969177448073, -3.8046530771593452, -5.1135372136009867, 0.66817270032545606, 0.60634638998852886, 0.43810547484083084, 6.3375595978686556, 1.7327607388506943, -2.7709291600069701, -4.7849213311010788, 2.9547821180992937, -4.3478508207340081, -2.1600534179572923, -4.8649806329593215, -5.2188328953283847, -1.8845959010033069, -2.141717952349024, -2.2819555350898924, 0.89490660085219975, -0.59025714170743759, -0.63001772442601367, -3.1366792201564744, 1.6728262621890952, 1.0524275223052217, -4.1437533753350841, -2.1174708320455897, 0.10213727451902836, 0.31873404888201357, -0.14988859031721727, 3.4619146043002669, 4.9137810738217418, -3.4325288560020657, 1.4732210175148002, 3.4934182254807604, -2.3726422945654506, 0.44658004425074049, 2.0224736049670144, 0.49211246183289142, -0.46144512129286969],
                             [6.8005367065504334, 1.0045885200855014, -8.1556777825808275, 1.3371182084268725, -1.2072670325378048, -2.4707834167941551, 3.2680993640027554, 5.769832393408409, -3.6149934951956779, 3.4748237310079326, -1.0489881703644339, 9.3429409117040443, 2.5902445224968984, -0.58593621856129419, -2.7588355339517636, -0.038145378455251233, -9.4830418165900348, -11.19041378556423, 3.4284487856378525, 4.8541977590270431, 2.9288786900485166, -8.6047278924174631, 7.7927094417370046, 1.5968396668448261, -8.0376651254877007, -2.9213261095614911, -5.6606983193203364, 6.5140791185166069, -4.0570251535328872, 6.5216496431992468, -3.028766290031971, -6.3009392541079077, -5.6707784627318789, -0.29616535559929291, -1.7395832434508256, 8.3995708292279936, -14.702036104073706, -6.9607636758302318, -1.0297649945644003, -5.991537480788403, 19.886448719666937, -7.7156043385065338, 10.82477065262583, 6.4292348810502347, -4.890178668208506, 10.123103220336732, 11.071740350008472, -8.3090700546151446, -3.5225590624340972, 2.0424571530018323],
                             [2.881484538237542, -1.9890867779274268, -10.952083579981059, 7.3354497952841786, -3.1559623351979007, -5.1668090204188601, 1.7533576633251857, 2.5097396651887127, -8.598585884204347, 6.2632243570607855, 1.6966492191306175, -1.6242659607254537, -4.2697623351632963, -0.015632897124671752, 9.7538931533533404, 4.7126349075712808, -6.9451585658344772, 1.4892521057221335, -1.8942155178609286, -0.32171783806344001, -0.96790156524271265, -11.515871426767475, 7.50333445864604, -2.9535059472850897, 1.4053786476704455, -1.7425860098563051, -5.0183813994838227, -1.5131580347287725, 4.4272962387391601, 0.99170903508568331, -2.0829545528460911, -2.9995240167715282, -3.0366112066667803, -1.4364751520690524, -1.0547518356471417, 11.113435271436783, -4.9807694130712594, -0.28864292714335116, 1.2248614951143193, -4.6188097188312556, 4.4736254595727294, 1.630596686476719, 6.9151755404767732, 3.1408907818693041, -0.45181354249417893, 6.4871551342737721, 4.751434282385361, -7.844960582268846, -2.2801757259707847, -1.6585806459717372],
                             [-12.652695240168518, -10.065426822782261, -1.7149581909529021, -7.3552629514324668, 2.2355846785637508, -8.8489979323256733, -3.9562439747792144, -1.5073281920993202, -2.5174952214642232, -4.1349537590487326, 5.7702494660065291, 2.9741113317207102, -0.84353592016830081, -6.3983866895378503, -5.1045108066964495, 7.3379046194286071, 3.6969621475784953, -5.5627203609846054, -0.34548632348707775, -4.4094812251659627, 2.685567858455193, 4.220587279434393, 0.42564461266795151, -6.2603379890471293, -9.6073532707787486, -0.11324779961546394, -5.0036266285307081, 3.3393869501887057, 8.0503594115713, 1.7624110458468705, -7.9571498221513677, 1.1624531930222457, 0.76111788312181972, 4.7290386573131578, -3.9355861307113154, -2.9709507819169216, -9.1231355656984974, -11.976993435985781, 3.4153915016781649, 3.838217004868119, 5.7872130283986793, -10.689115315098261, 6.5832878277867719, 1.2875574011260893, -2.609086512037365, 2.3131866917918611, -2.0987664829378678, -6.5489478282467219, 1.5599027287312839, -1.4393941112698332],
                             [-3.2181233368517916, 2.6354836373386403, -2.1790206974825512, -1.1895104236372058, 0.033068402340249492, -5.7593500999501668, -1.3137166118676509, -0.55346883085226817, -1.0908618769016298, 1.0970569621929576, 2.3080565652049598, 1.7766368237660854, 0.07445688953434737, -0.58832664257805245, -1.6795914814133233, 5.1431059297551158, 0.085990242316058868, -2.2836562242381482, 1.4482774491399815, -3.1646645596211034, 0.79876278617768981, 4.8150287845553459, -1.095500330537782, -3.4776225517061246, -5.4579770947102322, -1.6718049967409692, -3.3378626611389359, 0.42413142667524667, 4.7703707225751524, -6.6389572821291418, 0.68963677980236637, 2.9123082830282621, 0.92491561043722981, 1.9058303203662974, -1.9693911496784382, -2.2585811162567611, -3.6947785958066364, 1.4832073271357007, 0.91704711789122828, 3.2691335746059957, 1.6427041206596713, 2.0260549441035263, 1.6860928606334031, 0.47522922934331158, 0.75577295894420127, 1.6098927786495536, 2.6282922196498366, -1.2848225898575762, 0.47089835385380774, -3.4409796103430952],
                             [5.5188636287423201, 2.4798401724341632, -3.3878269583871816, 2.1429440334970726, -0.36742882807958299, -1.2818507953009963, 2.9631033226461674, -0.47105321582815518, 0.6016161265425618, 1.5506536747031983, -0.01752914557928642, 3.1055774263264606, 1.0747340074295668, 0.17040266082103428, 7.3339567479515164, 3.3570857212137764, -6.8644633752502466, 3.0845376401142834, -1.0521730888754071, 5.6544243674999537, 6.8923325847282912, -1.4987760971707402, 1.8347041800552106, -4.8972154483060564, -0.84301632816052396, 0.81809457298893407, -2.7524938068889546, 3.9129953745892578, 8.4690902753743327, 3.687117670348357, 5.3110486001557309, 1.5352412940624796, 5.6269248364924964, -5.4925418914331212, -6.8040476412138897, 3.450139875394894, -0.59582558393009477, -1.3746540419593645, 2.5396698924267804, -0.19826524028151979, 2.6974948234675411, 1.2134500995331143, 1.3675599458133747, -5.1830157605901022, -0.081556574150479677, 9.269240839114115, 0.28920008904032968, 1.5806278758517474, 1.7742556115852834, -4.7070442173913163],
                             [-0.31380231296908923, -2.1170387539806099, 0.99387654593630004, -1.6961006888592967, -6.1846983633580983, 11.351368742486244, 1.0719949545022671, 1.5928876928738249, -2.6460254554814266, 3.6371555884432842, -4.5652526398427371, -0.49305977674527623, 4.0908405636147904, 1.5503547577161507, -2.3449779389494028, -5.6859451476575957, -2.387425791087963, -3.0916827610359361, 7.7576839472216852, 5.9879792249865575, 1.14052340905474, 1.3229780111612377, 0.14178472902598585, 4.1753282674253311, 2.3915914312431981, -0.085802001653557669, 6.5030312464840083, 2.3615055252175043, -4.1361024320207198, 8.7942854921304594, 4.6277584310948594, -2.091117076587488, -0.86887914688194823, 6.2478090987465587, 2.7909138005445024, 0.00053900267372641864, 3.587105046358372, -2.5498188283096352, -1.6071344119569271, -4.7560063825259355, 0.80641183677183959, 2.3692561805295864, -3.628653313589675, -2.410504317642709, 2.1278710653468575, 0.63016330975538637, -2.2081059910683898, 2.3289280489243156, -2.2150081435288183, 5.4029300930818982],
                             [-0.33100018655573338, -3.3004404738831381, -10.939142166939654, -1.2240137788995717, 1.3489780821212598, -6.293914107549937, 7.3153146566877414, 0.073805937216151252, 7.5623579182218892, -4.6974202219658139, 4.0406607566335762, -0.36889235195311976, -5.3275163804079959, -5.7779646873684047, -3.0304492867116739, -1.0301891932157465, 8.1710168999911836, -0.45803507095976398, -7.070981670416721, -2.7053322189528228, 0.53783431080308675, -7.1910697290236776, -0.87460141446629713, 0.67498173552725105, 1.1171310017670897, 7.9156313327469245, -0.19857445174784649, -2.338680122910878, -4.8172659454481925, -6.5422813373897242, 2.7969126324458444, 8.6552515748082488, 8.9382471450151328, -1.4537656457704871, 3.671108522588947, 6.4265611692552698, 0.6449362766502218, 4.6206939060374532, -8.5287280493000974, 5.1091791202617438, 3.7292891027934174, -2.3955241529095392, 2.8702215355158649, 0.37974078535612765, -6.4305806992955024, -2.9618687653751388, 10.55357731349045, 3.4539035358871075, -7.2666375511032841, 0.286804300348946],
                             [-5.9465170238786662, 0.32302468693535125, 1.736930698654062, 3.6603609780023767, 3.2858291898796073, -4.5886308558653477, -3.8590183814389718, -1.2753549815384098, 2.1382166287871787, 2.1838643447803689, 0.87369185428517437, 3.2232160308202706, 9.4639714332353524, 0.35553091596241782, 7.25517381143466, 2.738085926314227, 0.47671012160727727, -0.0043038541540007247, -3.7316513312710473, -3.2557292214025129, 1.7056242660099319, -1.1398100098914192, 1.4971004356713884, -7.5457341434678895, 4.440645128080015, -2.8708821767243671, 1.4011258942280584, -2.2530619834389776, 1.9720425130525268, -0.92940457659860465, -4.3070709394923492, 4.1813841419149052, 2.2033810845858395, -10.67011046990887, -1.5798662010452662, 2.1891954888519507, 2.0906998436993849, -3.3477748914862739, -1.9703288496768756, 1.7786392771053696, -8.5718078922065892, 2.5106186585726653, 0.34157067957333664, 0.62626672144081785, -1.4883502824562438, -1.269935304236512, -8.3262385246929931, 2.2285240904879329, 2.1014894052262107, 0.6276141238417835],
                             [7.8147531296446306, 7.6751104863849493, 2.1667515374460571, 2.5788663643362919, -9.3169140990240091, 3.0903454648231454, 3.8663366673487363, 1.6502109555595867, -12.926778351687229, 8.6868215411699818, 1.5452697249119089, -0.30067839055799039, 3.6682812767991342, 1.1567140008123369, 6.1192841531541298, 7.2053976812148743, -9.7502662752486362, -0.78827870842098857, 7.5331448505991752, 2.451678443449139, 1.4197323099889076, -8.0012891397916555, -1.2894388690057306, -0.8170855980481263, 1.3129676362369676, -9.6360277684375646, -3.966936574333003, -0.69831970454679893, 0.8316315785083469, 3.5446856012333869, 4.0780975995450248, -9.6563070892439598, -8.9239755383777108, -1.7299680950872081, 1.3253800876468913, 3.3180773462844768, -3.0084156541564973, 1.3711205412018888, 4.1423151408740644, -8.5336142803459651, 3.726036219198642, 5.3346779149648968, 1.6482962557377459, 7.0725172367316107, 6.6858304100932306, 0.15237251631561843, -3.5777773557266186, -5.8160890873646505, 4.6480985423962498, -1.9576175171331496],
                             [2.4745060707531512, 6.3140474608113877, 5.6770060180162059, 4.0324215098691782, -3.5425381995580567, 5.8047012816703676, 0.11675221992290652, 0.99642832482332278, 2.1154085518047228, 3.3440635062793875, -5.6038767176757585, -0.48673711092529692, -1.9578942586689017, 7.0046858891942261, -2.5626182083555622, -3.6192684558819317, -3.0866167309656154, -1.6112415417276584, 6.863811512944225, 7.7643948263360283, 0.57377862405563373, 2.3753139838087969, -0.043525908275912017, 4.5952619853399526, 3.8939026778992085, -0.25726960990936165, 4.4630158118650707, 0.67451452313091553, -1.7805260119134116, -2.0022054058965488, 6.0516383092195802, -1.0853166062743727, 2.8287264820199072, 2.9626664343641318, -2.2232354233825191, -1.0550418360269227, 3.506781376426571, 3.4584080611645849, -0.28472289243513993, -2.1911218968792205, -4.1495589181637325, 0.65851227280726521, -6.4093560112369774, -2.8231252869427346, 2.0720307406641596, 2.4042140182489371, -0.92814296901341153, 3.4813200019362975, 0.71428454525156015, 2.7878729777884592],
                             [4.6945471563940036, 6.2792129051175722, 9.5769759067723577, 0.26056225675609923, 3.0561753211751697, 1.6277473722494515, -4.1308392008403354, 3.9648683406575307, -3.06495658505365, 1.4087595969380011, -9.3002205661850645, 8.7273730648691874, -1.5139519102390921, 4.0453778007031165, -2.2329315875829696, 0.50578224169190489, -4.9746478682400959, 10.150243341097932, 5.4183921468965153, 4.8823246759020584, -3.4036981249817178, 10.42965333535223, -0.29399471138698496, -0.46224711763613191, -1.0200041505828905, -9.05160663541883, -6.3396646306700193, -3.9410887350387016, -2.5011034123847393, -1.5815323275081681, -2.984839362728442, -5.7606859415652654, -9.5657886504720153, 6.7042820384016508, -6.1862989863984952, -8.9226296903626885, -1.7384254540447488, -3.0434832663691296, -1.0667602835985135, -9.4504990550285157, -0.99257696913356419, -4.4650373132511518, 0.59506158180194646, -1.8788560954386968, 8.2235270352114398, 0.95694480257832004, -5.5253868659585645, -3.0687983273734316, 5.6677731542036218, -0.45829270851184212],
                             [8.1326302295473276, 4.4736856886916225, 5.3757679228416073, 3.2283575005234377, 2.7305956066044872, -0.1568141602900972, -5.3383724205122398, 0.15650100979687193, -3.8079155648257004, 1.0193933319818844, -3.1459877271690826, 8.6437889043944853, 2.8517157792222916, 1.9680173428227277, 4.7972571042955954, 0.24618617459987657, -6.4540793203994511, 5.7298123290780438, 2.5089624361264948, 4.196276862222188, 0.57189127848922605, 1.9126131149635672, -2.2403930923868218, -1.1360350912029538, -1.314259358087134, -5.820270654660451, -4.2545935156260937, 0.2343566886546502, -1.0847214812027646, 2.1513001922733368, 2.7996730561136709, -3.7870552262174768, -7.7622872965698537, -3.4985895272018102, -3.7725825941938456, -6.198277503709857, 1.2656194791126492, -0.26503706244862202, 1.4371131072023764, -3.7855360234045978, -0.98557100972330725, -2.8479184805306312, 0.50861377897556714, 0.23397133436393935, 3.9478439608723961, 2.8683768722037475, -5.0636136985084423, 1.0195778052418762, 5.0796172353724138, -2.9944177268545542],
                             [-3.7314681261440477, -2.4967769795776134, -0.16000472591045001, 0.71898778840152433, 1.3531453102651216, 3.1774567523166315, -2.3061327731005594, -1.2922081198422626, 0.97260130062278116, -4.0471603948572996, 6.4721609138833118, -3.5106778180957376, 3.0170051201560697, 0.034077492395772735, -0.32713486815071069, -3.6908266753455985, 2.9822689717205924, -10.564809827017926, 1.0633382909793807, -0.20162923998709045, 0.74104885725039071, -7.5302883148301083, -0.36242416832288904, 4.4521702453438206, 1.3837001386342138, 1.6147793914923296, 6.8632665539405586, 2.37287110823898, 2.5620915735681562, 1.152934714252833, -3.0302692895280545, -1.3469924293484263, -0.95248094719497978, -3.4992642091091288, 7.1849226278383016, 2.2253860509980572, 2.7644380532126798, -2.8958530520889809, 5.7419465785019623, 7.0708521897820527, -1.3774688377176572, 2.1957585373360677, 0.83253711730591273, 3.0733445567350781, -3.1034944263004358, -7.0603304961469613, 0.7365067746919467, -0.49372983363683443, -1.5749608174506458, 2.2087886500471203],
                             [5.2873736598657546, -2.4649286604414455, 0.77169855176034263, 3.4959505709334717, 0.19621507167943408, 2.3819006363533619, -3.6858145116775738, 4.8748737492909715, -2.9184179633931562, 2.4481471250977158, -0.043567209811426255, -1.9711167822406614, -0.99953750032929589, 3.0429903268363474, 3.382946141971189, -3.3824382482199447, -7.4650138186574369, -1.8699732217409883, 1.355641395316499, 5.5076790355182279, -3.5870863898430669, -7.7559483248572905, 3.1906468400205292, 0.71493896702878823, 1.2081936548887242, -5.3966809608141508, -0.5491730968979327, 0.96547356413040886, -1.4840749447440842, 6.5252857269528475, -2.8473274340054315, -8.4768954656151116, -8.7850547731890511, -2.913093729696572, -1.8323337754300049, 2.7430920855360892, -2.7456069620498451, -2.2126948253272971, 8.0596484455874684, -6.8268320936714186, 1.157081084511054, -0.7895248593031936, 5.3701808696680766, 0.75393337656809933, 1.0957176110169908, 3.0261811408895882, -2.5855056981990998, -0.27653406346335652, -1.2985473126423237, 2.0869534046446541],
                             [0.50893552428210187, 1.2173709543085538, 1.3809039566398695, 5.0478073068297427, -2.2579522737535571, 2.1129969921155016, -4.3555081350534275, -4.6074420690048408, 0.28637974976431363, -0.17231842086702098, 0.63546592079331354, -2.8042998132410144, 0.57603421689170453, 6.7616995446767687, 4.5110382790038557, 0.99818895545352848, -1.5011056906984104, 3.6488379752620932, 3.3336986346450068, 0.52552122832502146, -1.6890328726096908, -0.44088503072364893, -7.2671333239562665, 2.0655283751902416, 4.1029663536410288, -5.3344823520223201, 2.0269229387501517, -3.182758830281883, 0.55639744817342063, -5.130265340168541, 3.9796595212058552, 1.1481212609263913, -4.1754655396057174, -1.9240308633208092, -3.8738521728608784, -6.229674584198853, 0.77937052407786234, 6.0384203271576045, 4.1906084190726514, 2.1048868426895861, -5.4455226637146819, 3.0466138967580085, -5.0587171649901759, -0.91905608681156492, 4.225552019403839, 1.2700072257035395, -2.1575142266963332, 3.5285877808803527, 0.70480848377458694, -2.1358887672107114],
                             [10.755009933634183, 9.0100107446918631, 3.9721705315160465, 7.7998754850020466, -4.9585585828225751, 11.71560020654249, 6.2634107653416251, 4.6487904631107151, 3.2211606064800544, 5.8931480948728607, -8.4160766538058063, 4.1183990385742693, -4.2699090028924367, 3.0413740501516475, -2.0283784134426384, -6.5713910489686711, -3.1829397562004615, 3.2502289683036403, 5.9678273899845724, 10.16156966888078, 3.9535963356488777, 4.7178395187108393, 3.0437346531401115, 7.9694917476466394, 0.62601479949553163, 4.4147143163154112, 2.6439306389228339, 2.6691768820246091, -1.5556372282833131, 6.2903434942306404, 10.927127276675945, -3.1314015049000057, 1.7930753584797334, 2.4305148447787883, 1.9976698820862391, 1.3438466315875628, 7.4821893864973221, 0.3803812076463009, -5.7638903990868657, -8.5437483711375251, -2.0018707328570295, 8.1743533387927751, -13.278928704300636, -2.6276449231336194, -2.8315507265379747, 4.8136690744687787, 1.0652109758748649, -0.40004961400304639, 4.3796150827649205, 2.8663190298112515],
                             [-2.2612657934429961, -4.9803531815398943, -0.91035242177479425, 1.889139241899997, -8.5297881364450951, -2.7236814991640479, -0.72161380349565274, -0.83531711507735495, 1.9943728345236069, 2.0260491813109298, 2.4965439276878749, -8.41086249462181, -0.57672926771259547, -4.8897950814669748, 4.7642111164926462, -4.2324167645181126, 0.036224126215362251, 8.8471937210395399, -0.92548809179767888, -1.8027482630370664, -8.3754791005933207, -0.31507671477737759, -0.01636334752996349, 2.5991539627784173, 5.0789295978848852, 0.15450138583572448, 7.9100567241245336, -1.0865526531228811, -7.3933602445452973, -3.1697145831719764, 5.174341422618002, -1.0543619358977083, -4.2138807118863113, -1.3848478740152006, -0.02393300087100772, -3.2105659400258726, 3.9570310840174465, 5.3265153075843665, -4.3387814751305838, 0.449364776586757, -9.7825808956623153, 10.442511288552545, -11.655963443246296, 4.992291183479808, -2.0571929967500022, -5.6366858260691384, -2.2892624444878429, 2.4281461558871715, -0.052246363181110311, 2.6954330965783111],
                             [21.361969210248041, 8.6193191653865711, 12.660684864871724, 2.7304522876385549, 3.6123064921446066, 1.0861636803786867, 8.2076409962471395, 6.6245245116336093, 6.8783910860161672, -8.1039192213563496, -7.3121594216268297, 0.35483685511054408, -11.687385412279255, -1.4270014535482012, -0.93650049846055494, -4.0347771706492175, -4.1659276393403726, 11.806678869379917, -4.3450194994484788, 4.4907166999477548, -3.3488496035883424, 7.45782163387873, -0.97425722010477567, -1.3278742639260357, -1.1179152422805165, -0.023623843779565945, -7.1504326543705732, -2.7106788781225699, -3.1340604908388165, 2.6885793983216955, -1.5230151748560803, -2.2181431842329249, 1.2502486922649629, -5.4462979591849336, -0.79689305993392079, -2.6548452327125922, 4.615622871529621, -1.0937087591966663, 0.77441957293808272, -4.0921062109552615, -4.487501840815213, 2.7142604061069107, -6.3727556475508385, -5.2316725384669818, -3.2083796430777927, -2.467866564371564, -0.93615437545162461, 9.1796750654377366, 6.1081513739652653, 0.065456877168078423],
                             [-4.7880823245491015, -13.32756654327126, -1.1251133436688852, -14.376153824611229, 10.645799453864266, 5.6620805492609758, 7.5512404582171442, -5.3235145547409131, 6.8162691807940998, -9.0180711618268568, -3.2260084102007127, 0.82530947507020724, -7.2131160048636467, -7.9824267428009996, -3.4195110472880144, -8.621763992103828, 4.3611732545527842, 4.775208546119786, -6.4193535071715591, 1.793852224658238, 0.67329098627005379, 7.24991429263389, -2.2607485253567368, 0.74118409433405374, 0.90756179419473115, 11.242372070396637, 4.1536968886730961, 0.83339760520676531, 2.3138627563477732, 9.0788414963097246, -0.061034809098467632, 9.2363975095315958, 11.967991476477568, 5.7295715303553525, -0.68155576965374187, 1.2702438146775061, 6.7922417864608384, -3.9594258267333249, -3.8031823647507332, -2.0144843676485067, 0.44908961110385626, 0.53942436556173057, 0.15808298327217418, -17.337495935763876, -2.4512507555263232, 0.46590810381874181, -3.245976480486541, 11.062706723801975, -0.94498789296140795, 1.5251399114734432],
                             [6.9943759222006463, 4.9649794813918646, -3.6930437344324387, -4.9950649201970938, 1.6933383481995166, -5.3771858236664194, 7.0995855960717265, -0.89212334921592196, -1.6356705374614418, -3.3005968502279428, -3.4662791526049204, 7.0674820798689622, -4.8800697833313995, -4.1425628317634073, -4.0938515545115362, -0.60074528020327689, -2.5349691506861172, 3.4269043532000443, -2.3384385724570977, 4.009732938962876, 6.7760038811154111, -0.79664738840057703, -2.6651322570407538, -1.4467180722553914, -5.1537040260544016, 1.1454952604917827, -10.651827099325796, 2.737977111074188, -1.2509991150171673, -1.4654452512112792, -0.10127600145685228, 2.880720173039748, 1.7900360787752909, -0.73606850466887108, -1.1728028402209569, -1.5968838551408284, -6.6694789695177583, -2.2211253460861955, -0.76793651817256769, 1.0321581509369935, 13.406073110556063, -11.604685454020192, 6.0401757088626242, -2.251477624217741, 0.10746600813967122, 4.7573517186703596, 7.4327250829094602, 1.5744315067562527, -1.5246340005474301, -5.0782242995981779],
                             [8.3230044592979997, 10.964959055370063, 13.094107524496344, -0.81358366392229819, 0.62191815228346092, -1.2609605124803769, -1.5939098041542139, 3.6624867088105399, 5.8973350385916206, -2.4293082179118959, -5.5593305716506745, 8.6697701009311672, -5.3767748485451996, 3.3643480306198219, -10.541626378229635, -0.019725318891562094, 1.5221646822115604, 4.1950576609357464, 5.8189273488016182, 0.87089679346384385, -3.7505100862818068, 15.578991283430659, -4.3954786329042115, -0.088653658120711742, -8.5468332074526767, -3.8124851011988015, -4.1596258023060306, -1.5606939347336373, -8.1202383962441793, -5.337405901231711, -2.7490859501698948, -1.9312022012085279, -5.1504749397304384, 2.9868690064151107, -2.3393477024773044, -16.173651276603611, -2.5696766605425658, -1.9883980661930045, -4.0278956493773972, -5.764949555263204, 0.39523044289556708, -1.8390934210562646, -12.273488856574694, 0.2713147535758984, 0.84806564205788382, -1.6529467499881685, 0.81076187724780624, -2.8895584430877692, 5.8045633113282236, 1.1504519555109309],
                             [1.2094169994974178, 0.89695351727781825, 4.97671968060871, -0.15755738710256617, 5.3376640283934318, -4.9570649747263973, -3.4762837378005056, 1.6464177149631383, 5.2014148307970025, -2.0076458986461647, -1.4404205054593202, 5.4904240838498586, 3.220250573245437, -1.107073015480855, 2.3953599834115633, -1.6095927481771646, -0.67326031785060148, 8.311620213504769, -5.7376037487023606, -1.4730193519724828, -2.9259639735486971, 4.5189955418962713, -0.16958200328419593, -6.0025430887141953, 4.4829480188053292, -3.8313791639025272, -3.1270176077834799, -4.4445153757150822, -7.7609035501974866, -2.7087766933511261, -6.8039147148398564, -0.060500364663618411, -3.9728236867254165, -9.1929821963517639, -2.6446753107555327, -5.9617444655925702, 1.5355658073673046, -1.9728601605350635, -3.604404809395259, -2.6907372646430123, -7.4535233491593651, -3.2828725191155432, -0.022091237538708119, 1.7400996397027613, -0.77159149489446388, -4.847150950035644, -8.2623906204513791, 0.062919881605149275, 3.8265397642577081, 0.49424280542374399],
                             [-2.8142571906959892, -0.69292856600890573, -0.040078766438488955, -0.31657851546581539, 5.0888937267206789, -1.7301635032348468, 1.2842987997168784, -0.56940810734521841, 2.7740258258464481, -4.7657184422579864, -0.25086147597378383, -4.1070641577019824, -6.2123462607245274, 0.5714564415045893, -1.9576857288982779, 1.1544256308551406, 1.2506270514251638, -5.5266262747396215, -0.2715660154763635, -0.27910669725590181, 1.8689402352512055, 4.0371463052083953, 0.70584900012551721, -0.10476931809481543, -3.6769296446279442, 0.81442308251460582, -1.8021167644038458, 0.34737854483654196, 8.090020671454532, -0.82362630970904149, -2.9215718098836052, 1.2129146159486122, 2.7503913531122111, 3.5010838372891326, -2.3312705855841824, 2.4835451216038593, -1.8698577139042922, 1.0765405808574176, 5.8782411595326529, 3.7789353157730488, -0.1599576676201151, -0.48354114450810792, 4.0084115529754083, -3.8481901742107891, -1.9386166873566819, 1.2599487704611541, 4.8927801440267782, 1.5997020262281048, -0.012022865496487345, -2.6304479870078135],
                             [5.1777591237403007, 4.8497308510822075, -0.43818705921537604, 2.2851192638270401, -0.19324555142012678, -4.02653969012355, -1.9124274527769582, 2.0177793299810323, -2.9089050445372693, 1.0145048287547382, 0.55059144802380033, 6.2570813497018172, 1.4187327030546804, 0.77780628148420705, 1.9793714615679923, 6.1932576352906779, -1.9594920567599659, 0.7010274765530502, -4.1568675833168358, -2.3149752781890749, 1.124615904281596, -8.703805086074615, -2.4279731073933637, -5.698624529637943, 1.3755435830554381, -1.0002465465306456, -8.6923556620914155, -2.7332934282906063, -0.19087629172764289, -1.2309969284445419, -3.9357248100484341, -1.0397710113776939, -2.4232728229664531, -7.6376159952992211, -1.2628140497996616, 1.2588831396234357, -0.82296748005118836, -1.0387837492294174, 0.085177250869838211, -1.4794039419574774, 2.4072960425356134, -7.242472474018065, 8.3924204572142962, 3.8521267536748325, 0.95003484611335165, 0.36716204491564797, -2.4920432712362173, -1.2804530936572709, -0.36530139342393886, -2.4099226980040327],
                             [0.89212011905826327, -0.44094176508695915, 10.614870250650828, -3.2949358183400435, 7.6693550185625075, 1.2062909033887683, -4.6836142343975515, -1.6045695672088254, 4.349117046125901, -2.6893058906527445, -4.6800350903006587, 4.3704582502640008, -0.94683478959750444, 2.3612039215298615, 3.753616839733156, 0.04478907800827292, 4.6177286592064828, 14.494397500934397, -6.5046645922751223, 1.5023190794658223, -4.9540335757111276, 8.2125403107289578, -5.1268815468215765, -5.679990954050842, 2.9263745164466872, -0.85450511564305254, 0.051595591448359457, -5.801443765979446, -0.17148461713646579, 3.3314297254816543, -4.6370276149769332, 3.7039399235108954, 0.011830247377447201, -6.2758099596910819, -4.719491397415351, -10.498606576392302, 7.7786248466370118, -2.4406119502824213, 0.17200853866901178, -2.4659095329875744, -8.7121125011831673, -0.47202890521884822, -4.3669245259581952, -7.0921830684385068, 5.4765829606383649, 0.25654142129572932, -14.292765583994399, 7.8444232202178039, 6.6862350661694157, -1.4056842808730319],
                             [7.3461849140099176, 1.713674164716535, -6.0311439630268993, 2.0098924723924538, -3.2763173511728865, 6.8552191971204666, 8.8124738993569824, -3.1812084592498873, 3.1560602355434755, 2.0038247800779647, -14.770821746781515, 9.0379032337390335, -3.7413694149342742, -0.89080566205964362, -2.5356109843162926, -7.5577513421475615, -10.602630928841997, 8.3612001432694374, 5.299433786485146, 11.931855389767669, 1.6037273616598595, 4.4322030093244678, 3.9759318296959227, 11.327107634531735, 0.10741220423481312, 9.2989370941521869, 3.386111262303837, 7.049093955427348, -4.8055393376212727, 1.3602318599485175, 15.520707269615801, -0.30357398859546381, 3.5216304360109216, 10.093347782770032, -6.627798198911357, 1.7769772195976956, 1.7006177036302881, 3.7333858166629712, -10.606253236819978, -8.4410451775107411, 6.3924065210720258, -0.7119857325402017, -10.407842571716984, -9.050586106262843, -0.82172005618874522, 11.825544998152097, 6.8472164499285135, 2.789207600996126, -3.0393652858081848, 1.7021422253216854],
                             [0.81631576689528296, -3.4519651832996479, -15.28100825726284, 7.8863047326874058, -17.949544478972342, -0.82272815985968606, 6.3640243737829429, -3.812927441457953, -9.4011022128456023, 6.8459936314049843, 1.7584469039025388, -18.071425124479781, -12.123176983793538, -2.2324661264149777, 2.4464932355803866, 2.5179992080143836, 0.49462565974886663, 6.7524440063110216, 5.024352035669434, -4.8802634063545494, -10.094071857290386, -12.997823242139555, -0.13161565661019839, 12.433190907503896, 2.9976671925631857, 1.1882728733498882, 3.2900734221037613, -1.5098229243263899, -2.8959538494737105, -9.5396399714054247, 9.1288385968811578, -6.085671247704795, -7.1084993804170189, 10.021008158507009, 5.718942696424909, 2.7601364870949165, -1.8665680927967281, 11.017615792913647, 0.48576415453431343, 0.99554471843612669, -3.133509302882393, 8.7277462730526896, -9.4884273367490408, 9.1012846066578383, 1.5260843978486012, -3.1513516415418117, 12.150946556904167, -8.4066060599574968, -6.472257749217877, -0.12707174855782299],
                             [-10.864649544113446, -3.6022227226632215, -7.2589485839244681, -7.715138834139923, -9.8783528309399582, -6.4450067425856297, 0.64509454175114744, -1.9148201743665938, -7.5016739156100929, 3.2949451653786137, 1.9710912937253273, -4.0174973429468182, 2.6260430029755408, -10.281275226797574, -2.7984491514778815, 5.8089305425684765, 1.8849813367048718, 4.9246280447973332, 2.2826417422373941, -5.7439803019639868, -2.6153844912224069, 4.7248191790179854, 0.50747463764493739, -1.3148032416104589, -5.3239415910471797, -2.6239713467839687, 2.329496291232938, 5.2110596067356019, -5.5291891605116694, -5.567623205533037, 2.9138276728104495, 1.0686324882677525, -1.0957345286344107, 9.3782980726699119, 3.3142427797341099, -8.4064511022977904, -5.2518803670907834, -2.6368466099777956, -7.7412395513254122, 1.9479830133583715, 3.0357315381045495, 0.46706050023791312, -8.4259706740603981, 8.9067547726268828, 1.6138368862654286, -3.3637312576754459, 1.6407106141484915, -7.7184335100075074, 0.18583517312628794, -0.69357389719651763],
                             [-9.8580291602080052, -0.28529576303980653, 14.764327948826239, -3.694043795671532, 3.6502383968234628, 9.8809317732330371, -6.0765926537974622, -0.98088421000300841, 2.1440052388866144, -1.2457237553573592, 0.039368042830343342, -0.19813283012484284, 2.136482905602362, 3.7503188124931421, -8.2241579365199051, -4.7029223175227814, 7.5473939349994597, -7.0202372980236296, 7.4088105087738629, -1.7129799277981999, -4.1994576987897299, 11.681523100574518, -4.7462978597780392, 2.1854509022555928, -2.7068204877599897, -2.2274575900693931, 6.0502721769529764, -4.5380135313044132, -2.1936706818971037, -0.79394611367259738, -7.5501604680100387, -3.1913055873560214, -4.5858951371532619, 3.1848209772039486, 1.3649804442501667, -10.122123748792655, 2.7318190008945371, -3.0979632849171357, 5.387260721532356, -0.18179427760986361, -4.5657195465050116, 1.7138756869762726, -5.1654853363541235, -2.6181196762563355, 0.27393013307923231, -3.641418751314673, -9.0259429389610464, 0.42161347439055585, 6.7777926998376046, 5.4293996140213334],
                             [-4.0857248550239671, -9.2234547652306862, 5.8683310961535753, -8.8652701834934451, -1.4194611849927474, 7.4797776656725423, 1.8950761772029772, 0.25562966142268334, -1.9886668043011304, 1.0647497279515814, 0.15675681409264261, 0.87144112337760737, 4.6597133260524828, 1.7707470991090226, -2.4075938323230623, -5.2247882948725177, 1.8094363034630216, -4.3264012101254092, 3.4032620073577329, 4.2295809946497211, -2.3642942203346475, 0.13537406071460914, -0.39733124278266718, 0.85606454041926683, 0.96536976890947868, -4.8787565374346951, 6.2303437699508919, -1.8369619279511693, -5.2688927054765626, 10.437101346425225, -2.7036497998010467, -2.9970252067278955, -0.91789184689507819, 4.970192911523049, -0.099113693307289016, 0.33980560702828827, -1.3374597006363773, -6.3335248013691894, 0.43771089638726379, -4.6098069838569122, 3.5754455276212518, -5.1534735022919262, 3.9671871056348684, -2.1357894021079846, 5.252824376829853, -4.1039354227732021, -6.1127526845694877, 1.6285238319406496, -0.29301555788376377, 4.6164929305709101],
                             [7.3198298119060095, 7.0586342496150634, 0.6656727733749197, -0.60603417951089211, 5.9728809075336988, -7.8585104871032359, -5.2665449501203057, 0.33353158599995386, -3.1998643306681216, -2.9636633851795735, 1.5102742416183488, 11.078870521174581, 5.0891591242120473, -2.0983353863899379, 5.8358652525196524, 3.2813767647012848, -6.5195880811146836, 6.6439986758019787, -4.9868688666992327, 1.5114356458624481, 5.1706604593922476, -2.6006871141533257, -1.6290073756060715, -5.921204660284257, 1.6986144663529839, -1.317119060949385, -5.7980528306950019, 3.0145041533295855, -5.0358120171200289, -5.1672481084319442, -1.6848201587791356, 0.051126234568799833, -3.1452838716194345, -9.6181205633463716, -4.3206620866435772, -6.1831477219519169, 0.24074215703303722, -2.2210900507571663, 0.16736485843035748, 3.501152746555686, -2.6067141190749337, -8.0290547150511227, 5.6012753245014544, 1.5492910074067092, 1.6226069238906009, -3.4311677554855455, -2.5868440076141712, -1.4534425027239006, -1.0378657162398104, -6.9561596074566392],
                             [-3.2704397028152221, -3.690084953500556, 5.0140335202152402, -1.3192959688220538, 9.0380987231411698, -3.5323259112054215, -5.9723812430513084, 0.1141927274554542, 7.9122294878810475, -5.7281201168615929, -4.8611600145359413, 0.19631358140766136, -2.2855789631491965, 5.036537410376801, -2.2076412229947087, -3.5436983479781241, 2.0093186586184535, -1.0745629506038898, -4.5438951919452775, -3.4107599989397195, -6.1252867698357187, 4.396507429524406, -3.0619249362642509, -2.8612713574850628, 2.1913841110573054, -4.2229373434651754, 1.3082752222738299, -7.8252812943153547, -3.1759742265073525, -1.8486170853742647, -10.703669087310647, 3.9749793801686066, -4.6474929107523009, -4.3483759569739675, -4.2019283721074796, -3.2978826446091905, -2.3621870508490108, 1.1964520918121799, 1.8990882087221248, -0.78253393298778007, -2.5908211806361567, -4.769772573879683, 2.7285512392661477, -3.7086284895185058, 1.4793354392298288, -0.057046858321010419, -2.4510147574558889, 6.2520957012148592, -0.67422824655433833, 1.4478674758537551],
                             [-4.4710308189196981, 3.9450374178327827, -0.61585625718771331, 1.9074341577090217, -4.5794112850999085, 9.0188824828693317, 1.3330332810738259, -0.56713981743835173, 5.3454515280852712, -1.7524584858335235, -0.95061088294231855, -5.9352723822225713, -0.16740712063404684, 4.9265113889356726, -12.034095814518652, -4.4053187545883477, 9.964109458735626, -9.7672180090862657, 5.6319170577938609, -2.5779728273870846, 0.029359589040424516, 6.8415689007062506, -0.54240841995294442, 13.370542078042897, -1.7974487469451272, 7.0869956986094635, 8.3607047518150956, 0.14355826559994667, -3.552262937191994, -5.569336883001391, 7.8655013353797427, -0.79139109045764333, 3.6476478000498882, 9.2573734060463053, 9.2726076520273697, -1.8403939992732381, 3.1951714341299766, 7.3354920963709231, -3.2617148498357778, 6.5109400632154442, 0.60112948396433263, 5.7810049426421735, -12.121598827748162, 3.2600311183026371, -4.3468973481340285, -2.6403053928340174, 10.134438474223423, -1.5463501146602414, -1.5559979710222689, 5.5565908817647713],
                             [-7.4322967040104491, -3.9853318381267928, 1.9428862192250977, 6.6258564085811802, -2.8164175374202602, 3.5430982194742962, -7.5530726200758389, -3.8060867079211729, 1.0507164768423167, 1.137749127713046, 0.99116302631175657, -7.4158917439774594, -1.7945842142902788, 3.760273724200164, 4.8562023766904927, -2.4340222819039918, -1.0452761200508518, -0.41124365403889601, 5.1297219831972409, 1.8526916539270948, -2.7076295609921623, 0.89863948068715305, -2.0322331321282601, 5.1455785104068523, 3.3100295294470565, -1.3822901054686256, 8.0126057739256922, 0.7181693675752272, 4.076483027376117, -1.7838904127199449, 6.032108018732286, -0.19851081260080905, -2.566586327566406, -0.39116800243258965, -1.811803020597748, -2.6643914229586159, 5.9997345388011727, 5.0404093262901197, 5.4477645926633205, 0.81196638381582298, -10.711071678135859, 11.32846699305707, -9.2297570168530765, -2.8034404545494831, 1.2043844585253853, 1.5392645668094231, -4.7582964251389299, 2.7730290790302976, 2.7318714772748507, -1.6179892845149564]],
                            [[1.6325840791155981, -5.3428732064750326, 3.6043684902283495, -2.1295531462451747, -2.5912036657940134, 4.1507083490674646, -0.52449011217338148, 0.44578148915532834, -1.6035253326099288, -3.2751946294277761, 2.5502878564529978, 0.57423321837536234, 0.59262547832622026, 0.04258269313177003, 2.4407789459228328, -1.3823677782828694, -4.5992931862847142, 0.056612538684301682, 0.35798891653624321, 3.1151605594602092, -3.2264599632700111, -1.4806686060716494, 1.3040104223065545, 1.8642533578185412, 2.2326674791734407, 0.37217405814462962, 3.7762691029464124, 2.0833499247311691, -4.5985146058931674, -0.11987071622296316, -5.1723658910757706, 0.63528941926044336, 2.4697829061806069, -6.9281461542110909, -5.8859886750721264, -5.980762208344645, -4.8502397075219017, -0.98323424775661372, 2.6245824413378127, -3.549217498849258, 1.5428403687834455, 3.2555917702135089, 0.61166738318554292, 4.3811899092049726, 0.18826809949006135, 1.7175750127931118, 0.81598864791621284, 1.080049787820778, -1.902075392830183, -1.5115083157599005],
                             [0.018447866890640551, -1.4587426266073491, 3.5768150600079527, 1.1175848553445282, 0.51987285878940159, -2.5687558193641093, 2.0990270062327259, -1.5439701014383842, 1.9286386220825742, -0.85891227473278453, 0.12727850132951657, -1.6193361937021451, 2.1625257392709805, 0.56752071549449434, -2.9276643234801765, -2.1236654049375083, 5.9749197181449381, -0.85189473192126675, -0.80203969399532449, 1.3103318233197556, -3.3047883975444665, 4.061274773790184, 3.8172052057493584, 0.086848300621799254, 3.21014945156355, -5.106141570384584, -2.012955725981497, 0.33834725919769576, 2.2210696389560014, -2.0179199249453053, -2.0966169418145992, 1.3377196701340688, 1.7313055141448517, -0.60821003662231499, -0.17952927155522219, 0.10278118202167683, -1.3876040129651974, -1.3832515702573254, 0.073039408713855059, -2.4823563513860036, -4.7401640177679827, -0.15645301787226759, -0.9301366433931102, 0.42776175880864992, 1.8752684253369798, 1.7408524688603957, -3.437438449159711, -0.205395611512555, 3.6996590477598743, -0.0068635078905220394],
                             [1.1441337918873471, -9.9837384878085285, 3.7918886872792354, 3.3426924462456773, -5.8616534798082354, -3.7732196224967209, 4.2240436339133556, 3.237088462612935, -0.23876293160081302, -2.1830179890043153, -0.92280388915663591, 0.83601319707647659, -1.9980460821357624, -3.11733996033424, 6.0777950555265798, -1.7993465931009185, -2.2439322913194322, -0.038182321389235961, -0.90666873887700583, -0.34572199020028516, -0.10443590231949329, 1.744879399357874, 3.3412830869502335, -0.015545032336765432, 4.065638782779506, -6.3040188639500414, -3.478830806461465, -0.91522788751460737, 7.4187521529151752, 1.1312202118051484, -1.8568762819555666, 0.87149590788602405, -1.5596790306015083, 4.3166791480924616, -4.5918688967346757, -1.0030947507504266, -5.5056197972976975, -2.0013274416549254, -4.5499276749677708, -3.6685110253790554, 4.7243409314778555, 1.3828116158520209, -3.5028672993618435, 3.8447091291238515, -4.8298462276217276, 1.8557146029831459, -3.1119157423797681, 1.2364333263036751, 0.21036015988805198, 0.12271307538868124],
                             [-4.22076618725381, 1.0616073176959848, 7.3077581409755048, -6.489178803256908, 0.13730524910351008, 2.7559840876626809, -1.986228230101182, 1.0859788722731041, 3.1612842697518109, -6.5167094419789882, 3.6680882425419483, 4.8451264073403815, -0.6645920624822147, -0.73460961186592266, -2.0119458977176654, 3.2236007120913253, -1.1215933689301056, 4.759406478743232, -0.59754411256894535, -1.0363749870970762, 1.3046027986168469, -2.2753481279385843, 2.328982723856563, -3.885392814005332, -0.390817814607886, 3.5166596011159146, 0.21558035872490849, -1.8079425828486566, -5.5227945595792782, 7.2212595042537151, -0.4661519002263334, -3.1667397828489818, -1.0977899753959679, -2.5325575575892754, 1.9887675467486077, -0.83248334132731128, 1.4069094371368938, -2.2709334077757153, 2.5236774980562866, 2.7466569115661534, -3.3433998915042569, 9.980208336844532, 2.0464079357345697, 3.4983020626718404, 4.0829173971370611, 5.105555134762592, 8.1048937701301682, -3.9228197528665896, -1.1718928837889495, -2.977999105804682],
                             [0.43660648183716361, -4.3530277517293916, -1.9811501839928316, 1.3177238019707513, 0.60805481443507892, 0.3260171075403695, 0.038938504107940176, 2.495741263764331, 0.72392113051449214, 2.9230169963823185, 2.0568300510537187, -5.2930798753221469, 0.5678230187502824, -4.9190618691112284, 3.8553724731034391, -0.044414243529012166, 0.37519430322933872, -0.6112039648103178, -0.86210850062261535, 4.7017776933294257, -1.5575328624339742, 0.68705547126574684, 5.1147014242496152, 0.51671376028858207, 3.0782013089443905, -1.3170792708398349, 0.50778331847991665, 0.011034625684594086, -0.55990749697152775, -6.1862303938954231, -3.5120452224753236, 3.4699509015856513, -1.8908856550523383, -1.2254519192289064, -1.931198240448998, 1.4057651734983072, -3.2115306755126478, -1.0031297379922857, -0.096051923046830689, -0.59747167217901342, 0.54055798144481726, -5.928564816278822, -3.3781978461774318, 4.8178631556670117, -1.9482294049032109, -0.52971417138121601, -1.7574399923878379, 1.8131219865051704, 0.1010093072341217, -1.5226761125035573],
                             [2.2352315566532974, -3.8265337787006009, -5.8051052763004671, 1.2559498878278725, -0.93746860799455534, 0.9903053698169948, -4.2389018832378023, 8.1675289964012876, -3.09615098532415, -0.5661437535775119, 1.0008656229715822, -3.391174168369425, -2.5952480149269661, -5.6936319085732343, 9.5972300159998269, 4.0000479878572133, -3.9905810654580884, -4.1806981944835959, -3.3854184993140355, -1.1778147096459715, 5.5385139316592396, -2.083330114195888, -1.159059020617812, 0.55928926084701425, -0.32912827280711288, 1.0791925245805691, 0.34981089136625393, -0.19870653301900179, -5.0582904942157425, -2.1941749948896305, 0.24901653651265557, 0.34942074347418434, -2.2496800905324519, -2.6843325318225952, -4.828920341181405, -5.0403650851784976, -1.2913536461518287, 5.3587459131201136, 0.44655062924850036, 3.1424322859656755, 4.0453453899156075, 3.2424907578818774, 0.27361629817839062, 3.125837905365076, -7.4962203847807798, -0.12340814264474194, -0.94835404469324325, -0.28502360747410899, -4.0296091206746176, 1.4477312232259643],
                             [1.5801808082729523, 0.99723115636298298, -9.2542213558928754, 2.0351911446876638, -2.8177422487398509, 0.89733150286103502, -0.41645106214377559, 0.35449917549142695, -0.60890916681897822, 5.0263038473576058, -2.07236204394207, -0.97374982051436287, -3.0691102128124657, -1.2739753006983792, 3.0591977470958045, -0.91192368088357367, -1.4102568183986026, -0.68463260912102897, -0.57498657263303432, -0.54595755792070733, -0.06608178800325365, 1.6741089632880382, -5.0068869543283272, 3.525952058996336, -2.4552336199288094, 4.3441671619519475, -2.880211796385912, 0.32492214055305407, -2.0514368391104361, -3.1653338395047035, 2.8266830330230293, 1.8782425376073564, 0.70321678205371452, -1.464505150932192, 2.0950724807314249, 6.8897303604297999, 3.014706159716769, 3.3243143499862744, -0.40699593034832265, 3.7812712864837681, 2.8484361430881893, -1.2631363057510838, -1.8688031664738032, -1.314271471800406, -0.033408616348059021, -0.61686583887610136, -1.0474334308595652, 1.6616265580484293, -2.9308186023018572, -0.24142506799917057],
                             [0.28245171830910687, 1.1400055886273228, -3.1637410582205421, -2.5035703770817315, 4.0351066371600393, -2.5330715199368594, 4.2583305018768733, -0.0069290593382459534, 3.7523159170165385, -3.4885800348252993, -3.7566996622643742, 1.6261870429010121, 0.18445708571567268, -0.76483756365889277, -3.652992534919322, -3.5185725413941835, 2.9822017011003941, 1.3473808035069617, -0.5768304492334676, -0.75071449505675025, 0.61721175803340866, 1.9458276175692415, 1.9181711092427627, -3.1656049514805287, 5.9616394688890368, -4.1207205668528308, -1.5509063884761063, -1.0686409974804443, 5.8872805083582511, -3.1514946498638294, -1.3875642840331712, 0.12080674641417236, -0.78869038239458689, 2.7248217954643565, 1.011680174114477, -1.6739863984721468, 0.65787977020515531, -1.2317356249620179, -0.76266576633598504, -0.36217795245068185, 1.0702288263302424, -5.3046291358057216, -5.025108342426436, -0.74502949449858602, 0.86065570825773663, -2.3424252283032372, -1.5905093621930393, 2.900833084499157, 1.0973339299244669, -0.87580607725770476],
                             [0.74955270911992811, 0.0058824759254614747, 3.5358373935445289, 0.15881509761470022, 4.4246869133581015, -1.121599898678757, -1.2682359799549734, 2.7335977283798081, 0.061417140155988301, -6.7526361363177809, -1.5644563934770737, -3.8545638510804441, -0.90591732610621434, -1.7837068060234786, -1.9583542223457362, 0.85850116012133637, 2.0139965723311684, -1.4435306317779508, 1.3293059747813267, -0.96221255559780083, -4.5769860887825322, 1.4097770441835265, 2.5019315555405388, -1.9137307808348585, 3.4566781245597697, -0.4530916975299713, -0.98866370914682922, -5.154573568492645, 1.007860243318655, 5.7035838298259662, -4.0094863557121441, -1.5140336983722662, 0.15714935608947547, 1.9433322101338508, -0.93765205260874285, -2.9639056695702806, -0.095075757225289881, 1.2460771814272003, 1.6344171583434473, -0.7049398068401187, 0.74431859101225917, 2.581937621966881, 0.85518571704027635, -1.456828926470922, -3.3009744362683113, -4.6229831861849879, 2.5425150095917384, -1.063838788067301, -0.85406309007221881, -0.3974581676413107],
                             [2.4119946641712326, -1.4101324658588485, -3.39092429745171, -0.48993911623475678, -0.88054133709571181, -0.64775740908103219, 1.1887476004606845, -1.8294086107102492, 0.60147202995644089, 1.3104373270198475, 0.56274568089815868, -1.9548916674887897, -0.038313352590853458, -2.773359776055234, -4.0796499338906482, -0.092159039919418859, 3.8034336580135526, -3.9628074730079379, 4.8778595514875942, 0.74841499261350564, 3.94335624696406, 0.1330074939913295, 0.58737186247932593, -0.16486612939921397, 1.0668352186097132, -1.6668046449956817, 1.6729748179960811, 2.1523626805245564, 3.1755948489872008, 0.22922758907300619, -0.09951995298918756, 1.1648391778942826, 0.79226243395811469, 2.79293993736297, 1.7700639323184815, -1.9928599453019684, 1.6288582926295545, -4.1094822380204867, -0.099064949834120342, -1.1715595465649498, 2.7200517322799542, 0.20551290387852922, 1.9866113440763629, -0.83090568511984308, 2.3340034883961778, 1.2855951918048025, -3.8378909155112235, 1.1106038021114153, -1.7536116400180601, -3.3609897975021426],
                             [0.16764408531662695, 1.8791062332666493, -0.63288815767966933, -2.8870661033608873, 2.5745537810802084, -6.1516438347045392, 1.9580704831285507, 4.496798992232347, 1.5172025967297953, -9.9216519447355225, 2.2634280806971052, -4.253573002405294, -2.9372928015250759, 1.3685027494403967, 3.6749102129030389, 0.1271488425039955, 3.6437648938768232, 2.7904906874190432, -10.308023103858311, -0.90561787943797367, 2.9910662205938698, 0.17700502179815863, 0.54015764049730941, -0.018499180034403935, -2.3734581598170137, 5.1625063065675505, 3.5242929079643055, -3.3439416390997931, 1.3733436448249683, 4.7418299842879641, -1.6562561973911087, -0.89028508509273907, -0.036538434918503421, -3.4132793725420392, 5.0481621332317657, 3.2634748064085923, 2.1034794694410439, 6.6575088983136625, 1.1782632862122524, 6.572486071447341, 1.5787592358047799, 4.0931033543227908, 1.5843852424799745, 0.41355178163235912, 0.85362787847117649, -1.081344591386052, 1.1057416718706388, -4.6092730554062911, -3.4815086012928798, -0.65248617342924309],
                             [1.1054705260050637, -2.1869751284729815, 3.6178456106781827, -0.75690374478424216, -0.45577485511940363, -3.4920563860235521, 1.1400679900360879, -3.1981267349240956, 0.37272445905224427, -0.52192935865405699, 2.8552926915654977, 0.08170056667092164, -1.9038398137966321, -3.1945803419048513, 0.60637011144049058, -0.02052942764402868, 2.2118611825949555, -1.3607277320571951, 2.3129265533723706, -2.2436567638798781, 2.7900058331067279, 0.83425094941995503, 1.3231317175810169, -2.1253478054707222, -1.5451769189058036, -0.11837226806823725, 1.0001342484614504, -0.558127582643556, -1.3804700740402123, 3.0973855457827022, 2.198902587042594, -0.56276879099319987, 0.74561934585462764, 3.6490831222816587, 1.6006197862291509, 0.81948347899133855, 4.7877135375795632, -3.3142436683484093, 2.1759722948672628, -5.05786586761882, 0.31829927188307716, 4.7710367197170997, 2.4789981646785519, 0.63665706410633982, 3.484226658224709, 5.248524326804624, -2.3285405058558499, -1.3484838700044213, 0.025944041078732764, -3.323668078797509],
                             [-0.91721200727649177, -0.70239650536397269, 3.7708390236592941, 2.2728679520692401, -1.5118412708234295, 3.7417204041851884, -5.8217525252440616, -2.1982639979921652, -0.12556012157379523, 2.0900737052222511, 0.37935626094735903, 4.7356290883483245, 3.8454267147272305, 0.98701935508798577, -3.6247208858941291, 3.9904971133378684, 1.0106516709743036, -0.68265459682700125, 2.7191829665566747, -1.5854499922401193, -1.4332701442021909, -2.7495237606424849, 1.9103070705215741, 2.4850486406528263, -0.33792873176328336, -1.2742953793994189, -2.0128645388236324, 0.01346136078637885, -3.9624079772923544, 2.9010296414018888, -1.3764550501983666, 0.77086818717624161, 0.18112823511380172, -2.3069121538333763, -2.6420396660009384, 0.64493132405299458, -1.7991028056880445, -3.1494878578674732, 0.70331660043748212, 0.003607183974140428, -4.2526343080130555, 6.5662914535645909, 2.792579580462236, -1.1219107350580468, 0.029086722239794176, -3.901363293401523, -0.27227110833470863, 0.65295932906311516, 0.56085319211001761, 1.038331746743711],
                             [-0.097102932306818851, 0.36496429574951578, -2.70630359629466, -3.0425064474621513, 6.4527192705844802, -1.3102663962555918, 2.6858797487466579, 1.9809392525149108, 0.56952323236120772, -5.1655745440146754, -1.371919245616108, 1.1691477191799504, -2.2311732065132444, 1.0327866916182435, -3.2311875499998979, -3.8634912824614758, 0.22167275046276558, -0.96061784587282706, -1.5413662597134019, -2.8768329296645638, 3.5172986018692107, 0.95585765991871219, 0.55230209435148336, -0.17603300839270086, 1.5464262701166163, 2.985151775360265, -2.0953548196107965, -2.1115916512971418, 1.7523385357535999, 0.7005288760623869, 0.9675468899363302, -1.6954915132259381, 0.067400815552967286, 0.017250725520084002, -0.9814494768295785, -3.0905726456484115, -0.13977831445956981, 2.4438146013034792, -2.9561117485223773, 0.22394414790953154, 2.3453404044035908, -1.3433050268522453, 0.56913229376240404, 0.93180258207222844, 0.54394453728047742, -1.094500071574128, 1.7187053247522037, -2.1182346245622568, 0.28842532985447533, -0.49332595101893778],
                             [0.9638844433811351, 3.2806997918606373, -6.5868236018377688, -0.91301814195767905, 0.84296315441845648, 3.2639107169308659, 0.86047892639144496, -1.9161172810611613, -0.75792921909645383, 0.80507890477418642, -0.14725295385602283, 3.3914753461017821, 1.0571611837670538, 2.2721068075901671, 0.29748935439915691, -1.5163712552396085, -4.8664875301705219, -0.71716023600591616, 3.1561749888383135, -1.088413816633963, 4.5628313516729193, 0.23839762828464101, -4.2993674089719818, 1.8293378853475246, -2.3480309717709753, 3.8613879705390781, -2.207328200851622, 1.6332484354112202, -1.013405920682259, -4.5703207954011651, 2.5365208708611351, -0.22792123653311192, -0.52694265342833979, 2.981357819272934, 2.4076434699228546, 0.29578737420195145, 1.9862764350420803, -0.86699439733723849, -0.7855947813149412, 0.17856499271204243, 0.23769825964131611, -5.9747517008757152, 1.1544524569704977, -1.3513378224796893, 1.615727184580088, 2.9861656506379637, -0.72301155494551261, 0.65066511499264545, 1.3908024139945769, -1.1497779184940964],
                             [-0.37938043540054034, 1.2002186458516022, 0.35679991981982362, -0.32911090500367857, -3.7277115257092328, -2.3268525692426509, -0.36692054765501164, 0.79001626036982087, 0.22777578081390762, -0.41758237728229758, 0.63881541575542855, 0.49189163537207048, 1.5985704359637021, -3.0079258356651892, -0.045710385250052089, -3.4687816609453583, 2.6001192461989904, 1.9101682743992157, -3.657234008967452, -2.2615926506255724, 3.9038139677664807, 1.8675548807405256, 1.0267390100842657, -2.4133321437280482, -0.17609454020574755, -2.3183804620194834, -0.24906903948448311, 2.0042649180163545, 3.7921848358280714, -0.93952724152728717, -5.0660986367510699, -1.9488378280189687, -2.6443819151952956, -4.708999157925553, 4.3127634841242966, -0.12528499759116926, -2.6702687651827048, -0.21378702824007964, -2.3566779123173101, -0.083766603851623156, -1.3947318041538443, 4.6776818161977465, -1.7290280818711679, -0.65302986253026674, -2.0167996770148546, -3.0511758082129163, 1.1541463211611376, 0.25538090756556281, -0.45090207289280088, 4.5691201450185455],
                             [-1.6294679992059602, -0.0091111383122767405, -2.0453304906030541, 2.2922725867090374, -2.1899567082229034, 4.4731390233516661, 1.0958346297430379, -4.1393130946130974, -3.3862366863668623, 4.741354507181665, 1.061256522338194, 2.7593862296131979, -0.47795746595448785, 5.2343662014191121, 2.8301093292884105, 3.6198422021485857, -13.476144104370432, 3.0231205628806399, -0.69794290632237022, 1.0680029649867344, 0.78853742043297315, -3.5459982573574442, -9.4274936691173004, -2.5779909510448693, 0.74074697035821346, 0.050396586069716018, -2.6574278780463003, 1.531861900587014, -1.9467922610045698, 2.0032269234668623, -0.0092694435319595342, 0.96412970777674067, 0.61758702358029449, -0.98796272643641148, -2.7182282142131973, -5.2323102179481031, 1.1392293185442317, -0.24012380677070333, 0.077917531325244843, -0.66773965391735413, 0.79299620876026156, -2.3133617666605386, 0.83751915089362883, -1.0405586386067824, -0.448963028158613, -0.5070788754565756, 1.3576469493691505, 1.1478969560768488, -0.33821617347152261, 2.3511844479807622],
                             [-1.9059991267162211, 1.4981453669793312, -1.1205244554119904, 0.13075492873982844, -0.41958913414619597, 2.3521060853703704, 1.0027231014429261, 1.2423990979160007, 0.12058652927207214, 3.3172588308539908, -4.0210981586826726, 7.1555414241690958, 1.7845272655743116, 4.8148077955462174, 0.019839196708908539, -0.034853263626363359, -6.712782162491771, 3.1123001775634185, 2.7624155576134601, -0.051101581113321387, 0.13873452996429003, -3.9445865590921154, -4.6096784159964326, -2.0622396220699248, 1.2136708448468319, -2.3494958716650878, -0.61140287483981626, 1.6084827445377636, 2.3760725610013198, -3.8780704265324468, 2.3239720670449073, 0.37015634363027083, -0.12901656820671151, 3.5112969827295863, 1.2294363023251753, -3.9288883072704834, -2.4445375206487241, -1.7714094603003963, -3.2493412590689332, -2.544047143347155, 0.10701041726593194, -3.0029256264136763, 0.2364032981237984, 1.0770202450192499, 1.5018971542494119, -4.1130536167993101, 1.362401116716794, 1.1491930831724761, 1.4301189819498785, 4.6199687314793181],
                             [-0.53332149507661708, 3.2476437685702391, -0.7116097202475038, -1.3804024113266096, -3.2087913529794849, -1.2866033151638709, -0.61842295330097297, -1.956967933727342, 0.12538506693524892, 3.4281533593429723, 0.99820329143364128, -0.026475994453038741, 0.17268314603026205, 1.1494961924922333, 1.1169961443974377, -0.95545030081371995, 1.9445692535842305, 0.24020424135585708, 1.026146298135393, 1.8393428254331887, 0.19358961761904669, -0.15080998695699122, -0.47159891020048222, 2.4149113868574226, -4.5637592274868393, 0.85748458104688474, 0.59749921784274296, 1.5204486261134014, 0.39632790604480433, -0.058535179359465526, 3.2620093611061276, -0.27451395323251082, 1.4904264667104836, -2.7322070489340335, 4.1484832298601892, 2.949956914431807, 0.60331455907472076, -2.72573712536422, -2.1829561621253881, -3.6550394753793722, -0.91236967224580789, 1.9393731343870653, 3.4099008256147094, -0.2885192409504988, 5.300019583423718, 3.0046167007793807, -2.2882068082751981, -0.30501000492711733, 0.81134607909763123, -0.63313096795256152],
                             [0.062611491112548767, 3.203222686408945, -1.6494746299290806, -0.51226338200494825, 0.65726779265789803, 1.5540807559214178, -0.57941362950293351, -0.696604441931993, 0.86888413558064459, -2.9400541859780791, 1.7284811611472102, -0.56831119174527334, -1.4197990898975013, 0.74783646806587523, -1.4114862569518065, 0.071076596996513974, -1.0111846464808623, 2.6193415406780995, -3.7417684910582825, 0.57046836766089748, 4.8731990168490338, -1.5490096998606333, 0.25246031354461557, 0.13222124344071051, -0.41813793561709978, 1.6795692916097786, 1.839574554494898, 1.1966758071902783, -2.9200086380175176, 3.0005841683652146, -3.3531689652439334, 0.88445833817603625, -3.2170361619241152, -0.66022980134160891, 2.7891363154350124, -1.8537062656626511, -1.0376334977318094, -2.0318869369667216, -0.46390101095816677, 1.4979153064460955, -0.067844193657517288, -0.11752802745876503, 0.56749431752254753, -0.12928623528069838, -1.1708441960233555, -4.3254917848868244, 2.9994207069323409, -1.449466509172177, -0.18897337428287206, 3.1832651244130306],
                             [1.5685084475731961, -4.5040707039111938, 0.31026049109037945, 0.69113581424813253, -3.4469047015768384, 0.10987054462403825, -2.8584250248991609, -1.7724707482928945, -3.0542552748186114, 5.984847167812319, 3.4662843763911435, -7.3008223204937099, -2.6625429090379442, -4.7729725115032755, 2.5370731601438781, 0.62361572702650625, 1.9998800495092544, -2.6436846325315382, 0.67471732205643609, -0.0056351554251034205, -2.6471183470821131, 1.5586960869310247, 3.4279133823369698, 0.37189815079169564, -1.232033663822709, 3.4901135785728243, 3.3204141090335195, -2.9044053876737546, -0.41387049814896054, -0.78999202162709581, 3.9870907511989291, 2.1365771313144579, -0.081649129226430625, 0.36340864387605232, -0.59499187010021926, 3.4957796334715345, 0.64400339119046024, 2.0432453602295921, 2.6706179222064619, -0.70077264139411577, 3.4837502893342123, 2.0004267905666717, 2.7128484456255282, 1.7381582591206619, 1.5960982627457609, 1.1062263861456521, -4.40708717156601, -1.2633654639758196, -0.42629053937052874, -2.6664154224019074],
                             [-0.70162436566093855, -4.3798628325992883, 0.9821409074071884, -0.091116935171551811, -4.9811240250772864, 2.5771109415589173, 0.36572564379165506, -0.3937847674750754, 1.4081300399854957, 3.9956689290528864, 2.3962121923412503, 2.6693244459537828, 0.82743191903809465, -2.6403945245707132, 0.31758697986714762, -2.5920821890155401, 3.9867750990613176, 4.6277671755989687, -0.10856677145393913, 0.89024300809880841, 1.7078255027051878, 0.23099623316368165, 3.222091570518701, 2.1046166910207331, -0.68851987490293998, -1.4492306216246054, -0.1642912689026827, 0.55479281728280216, -2.5395968266566888, -4.0403432619253454, -3.1554234128564, 1.1284790368982742, -1.8312442629103867, -2.4518511212122198, -3.0993804286359738, 3.1400386508900193, -1.2921732698084873, -2.0060908688531129, -0.16553195472913163, 2.5379950724542897, -3.9097103006113705, 1.0734677827447625, 1.7352068894926309, 1.0250177948339987, 0.48624456639083158, 3.3017480924625437, -3.3249291711971023, 0.78968683464107192, -1.4747436354835266, -1.8147501145379796],
                             [-0.21765573657555384, -0.044509742876801588, -2.2215747294279091, -2.5228354182777375, 1.0354045232682347, -3.0729129740613539, 0.696877481104896, 1.8591677756661833, -1.9857596361291487, -3.5874831388751671, -3.6974438012803152, 5.481399126699757, 0.45017553351045292, -3.0675740438062702, -1.9795108036808897, -4.8475867828282997, 3.2137692729659038, -1.0709837335894277, 1.0968134700065157, -3.431907006840333, 1.9766332320448412, 1.8091617013693686, -0.85402187060546209, -1.3650490750364985, 4.0345494833799771, 1.7841286298419681, -1.8452068535953976, -1.1882616867912692, 2.1456530245953456, -2.3623466649363394, 3.4283493726364815, -3.9125048386441801, 3.3809967424441889, -1.2445375472031599, 1.1012326233255059, 3.1287293536049017, 1.2772428977257884, 3.2877848420404567, -1.5771178179217247, -3.1997016553426518, 1.7515434969691919, 2.1631091574323706, -0.6014872389740421, 0.17316541271294517, 1.6304138727657103, 0.90514860702353372, 0.51270283683104489, 3.1640108924795736, 2.4014547516499092, -2.5704396258106064],
                             [-1.6343110543044752, 4.0921565642216908, 0.66855458186168748, 4.2281717327810009, -1.5715479571840851, 0.98332909976044092, -3.5642770157190991, -0.41439507090607247, -1.9125973054322929, 1.3146518396374802, 2.2967094008543851, -0.77930580605811983, -1.340299332683726, 3.2205915268982928, 0.2594403246555213, 3.4630745512129968, -3.6063293165309047, -0.01341024063599636, -3.400564384228737, -1.603440812023615, -0.043620327654512875, -2.5928810076387419, -3.5435602511848567, 2.395476386345309, -7.3771423620447312, 2.3138394781994918, 0.31687157880175465, -0.24454403339951639, -4.6945261732539363, 3.27270053224062, 2.8569256577753475, -1.1716488825143703, 2.9224540710288385, -0.87367617691551602, 3.6645644164192972, -0.90171912104018459, 2.2670126916451259, 2.9570206690664422, 1.5201829007460164, 2.6857571250154009, -1.2829993367203649, 2.0973874924077984, 3.3317845585174677, 0.43726169859373015, -1.2577994045800174, -1.1062943734934998, -0.36073244514003805, -4.5311798093848763, -2.4761296619523083, 0.84378775113429494],
                             [-2.925161514714647, 0.57818361003483965, -3.0333421529257278, 0.98544586512954291, -4.4789454050264093, 4.6103579190624906, -1.4850169039578411, -2.3257667325298064, 1.0028638730227992, 4.5107612249396212, -1.0397570583931075, 0.098095604106533396, -0.15830443767281141, 1.8417204494794559, -0.52264131933159308, 2.3477507494913898, -5.0618535082587979, 2.1091093966186181, 1.232253283334048, -0.057682397347892989, 0.27532414624962254, -0.9978456457910907, -5.2931664182741409, 0.6175039375621143, -0.71082429669609382, 0.78888577138615812, -3.1522651072849746, 1.4529911165960365, -3.1694119781012353, -0.98023970268860317, -0.84306862055787901, -0.2533895619607785, 1.1578116870662145, -0.17716861653708463, -2.0190490715176566, -0.41820805950561452, -0.60416949303632894, -0.72195555207159656, 0.2354578496374766, 0.6104019583940361, -4.7405895764483779, -0.66380368745179175, -1.1813562085396472, -1.0657338927049387, -1.0172560343109456, 2.036463597632558, -1.3372100516410641, 2.1578534988468157, -2.1852589566769378, -0.17994139355399183],
                             [-0.75515321283750581, 1.7627750358994541, -2.0408420269745595, 2.0807065907319418, 1.2613337967843747, -3.3960336901434593, 2.7830346370735479, 2.822498541168788, -1.4987722383655484, 1.4252916199911754, 0.8014673687593441, -2.646372676802399, 0.64985926642483627, 4.3470937970307579, -1.0851520443352178, -1.9448526556321486, 0.05506799382292548, 0.60702761789922088, -1.6585571038894034, -2.5629068695809822, 0.21781815325708442, 1.4826666692927135, -1.4336741624204152, 1.3587532068490917, -3.4618116108021892, 0.66749385573219133, -1.0527599490622825, -2.2611453315298058, 4.6356900969179842, -1.2718525222793253, 2.2540740449344847, -0.55831442683104504, 1.4583526565432963, 2.0943705013456979, 1.4211464601592032, 3.5824121446858013, 0.06366402064133872, 2.9327233064588594, -1.1224739004992521, 2.7846256311178785, -1.0233898569316922, 0.74165021933422703, 2.6803488286223449, -0.98572138217926064, 2.2390840249106883, -4.1954922447301399, -0.96067992941998059, -0.83487733858224988, -0.014380951676236185, 0.58243912953869414],
                             [-0.89611802908442972, -0.76737681624673904, 0.23418220561236319, -1.3333566490321971, -1.0477385427825743, 3.6799281495527554, -1.769707053914547, -0.90487106900772285, 2.2505433501993091, 1.9550645611286679, 3.5639485812639147, 0.46941617425618659, -2.6401772457656949, -4.0244407284206511, 4.0683500136180077, 2.1660342083980222, -3.0453176516312368, 2.5982030751739602, 1.9711314893543648, 0.25237166281324086, -0.4224748325095885, -1.4206343744234204, 0.15138316635024399, -1.8092052928177236, 1.7905376444002299, 3.208151528718536, -0.1606012058198221, -0.53078881130712197, -4.985704040539102, 1.1927870451119931, -0.49160709548629933, -0.078483233766482738, -1.8929523345643062, 3.4039069253339505, 0.92668459480116527, -2.1150842659995357, 2.5344184824558846, -0.91707561885707378, 0.88401256466306832, 0.18889067131565179, 0.81239060350651005, 2.1520672284326405, 1.2909291658172073, -0.37557603188226407, 1.9382938127773375, 5.4862892363060132, 0.35967994148916643, 2.173440063744708, -2.4241494355597863, -1.1765085308468783],
                             [2.6069624472251367, -1.3271764933115517, -2.4470877162621347, 0.33236130870179109, -3.6670403301910159, 0.64917271795921516, -2.0084168943479721, -3.5281418815481107, 0.31083919484881245, 6.4816702192173166, 2.7814189927037485, -4.0037263524152733, -0.21291429346138332, -4.0958804901984198, -1.1140359879971737, -0.97986588684216103, 5.3415919372837051, -3.1364254262234801, 4.9576411861560024, 2.2730697283233878, 0.71872312369580837, 3.4902844726224753, 3.3751764881412742, 2.4098033242430299, -2.2666545585056492, 1.8622489069955344, 2.984854696773076, -2.1815880833535717, 1.6866850965124156, -5.3593418480345374, 1.6900627360141327, 3.6104163263505558, -0.19876218343536359, 4.0468181291262484, 1.0514449542633195, 6.5751477368384723, 3.2005911761697674, -1.6628496453877633, 4.0614341896275841, -0.99937035739067825, -1.602761796398857, -0.64439617887665368, 1.4310890992509879, -0.16144230031324219, 4.229852367011282, 2.4435325911520978, -5.1552423803833571, 0.41508472082082148, 0.087865952067914102, -3.8095678304300944],
                             [-5.0550081811246885, -3.0784237042594316, 2.6066143765130705, -1.8190776167734497, -1.7817940120824329, -0.41525412949751167, -2.048930725226084, -0.19406778380472886, -1.1540527600890278, 2.9373202615352301, 0.63223449780076457, 0.49936638119770704, -1.6015504553364195, 2.059337178839542, 3.3395513071486937, 0.85647920156941304, -2.0010802725711585, 0.92540779222380654, -3.8343301450115375, 0.34615050374868128, 4.8760653812585355, 1.8125049921778986, -2.2502630422255101, 0.41005215951192653, -3.1895894101728981, 0.36726616171462695, -2.6513990831146352, -1.9138171009946467, -0.49276463504164608, -0.2463958780344781, -0.35213957624144732, -0.30255511487099201, -3.2970615689219369, -0.62872110248678725, 2.42132436322128, 5.948288145103076, 2.204094741486891, 2.0782588504056019, -1.0676712987164578, 1.6846958565952266, -4.4485704244076691, 4.6100664093227621, -1.7639110085885759, 0.18461655320627748, -1.9517143451535368, 7.1449715022286275, 1.5592779335921809, -3.4967308368983816, -0.34604556935693037, -0.17002059470549505],
                             [-0.41085533993158169, -4.7545784766508907, 7.2484486231192689, 0.15522205934699118, -1.4378605861885994, 2.768163144978232, -0.81196844616225017, -1.4798120608800507, -0.44535706332669184, -2.6974066203408116, 1.9656092197097565, 1.2652919064741288, -1.2245483619295257, -2.0510099407086928, -4.854148261859847, 2.7128532105352723, 3.716392295902148, -3.6987263926490912, 6.2348243630242344, -0.73860409782074277, -3.298752841726059, 0.72450175455291155, 2.9364424757554022, 0.19254070615534519, 1.8324805715520285, -0.972620474438459, -0.045395290002040914, -0.16188863525229125, 0.85038746997054859, 5.0876262275936401, -1.3967914996318049, -0.42253608411277122, -0.31950342144815913, 4.2076656672379817, -5.5108270419315177, -3.1145388212234066, -0.44114796331752193, -0.79304086150647801, 2.6246134976705964, -3.2051996963140446, 2.0905458391821674, 4.1825471431610985, 0.76202637454352118, -0.9494186252893787, -0.56831183475854952, 0.39439377217824345, -0.27826971745254236, -1.5071064699855095, -1.4687093675119571, -0.7911682715909294],
                             [-2.5238178342769588, 6.2507757315148007, 0.83708264885276129, 0.18495566705904509, 6.5384711459903491, 1.4528001411681579, -0.18244413100184925, -0.38613247804884759, 0.27258950691840389, -3.7405366801313087, -3.1033099729298099, 4.7528515371849966, 3.1372733347470501, 5.2758046051273224, -6.7369725381512371, 2.7289902653578895, -0.33971996415752331, -0.5427767350673961, 2.6105402364580854, -4.7290435347778512, -0.17330286039377377, -2.2317287794158767, -3.7289506427905867, -2.396627299688074, -1.2009811662541832, -0.41765070509226371, -0.92437421726020175, 1.4393740295124373, 1.6841494231597316, -0.60468627762078542, 0.4591382134822477, -4.0321661929978072, -0.48015211472299307, 4.3446603149696585, 3.9955876175166356, -3.9322816576458748, 1.8898098343381444, -1.3174725673381507, 0.53399552237402703, -2.3239643940827586, -4.4249896871838841, -2.0750704730024254, 1.7679177326140587, -2.2916661461955274, 0.36274602497998526, -3.9450150791360103, 3.5829868890632706, -0.46239403446870536, 5.3387357513652365, 1.1056579364342554],
                             [0.58990876324553077, 0.18942185939882211, -7.470081496515915, -2.4490118274971628, -1.8327190476000859, -0.70000019831356142, 0.022970870019108448, 0.13829750344793329, 0.26353761106820256, 0.45120266324493397, -2.6685304904240215, 0.057046655401520999, -1.7404944741460135, -2.5575187589458173, -1.6445874914408523, -3.5681216370099413, 0.24511228926953477, -1.4789152663053784, -0.28168932260229002, -1.4470389780762012, 5.0431808917924652, -0.68100299232954764, -1.0242093299499948, -2.1354018627734441, 2.7075828096892867, 0.88884863059500585, 1.117461422702839, -0.39662342958475738, 0.39138769980729465, -5.6158725624643084, 3.5274106571942503, 0.84560274465939722, 0.86035142570040068, 1.2949444148687763, 2.3565983074399144, 0.55756759229159836, 0.0089626012141561743, 2.5484055759169313, -0.52811716196892711, -1.7970109745584848, 0.84660587253084163, -2.8840223048124374, -0.18025012361193285, 0.70474772247303774, 0.33309869093044275, 3.5341235819352796, -1.3556189574023811, 3.7355514423889047, 3.8384634683160361, -1.7835334236879361],
                             [-1.6982858793256319, -0.61872212327285714, 4.6407419460003689, -3.5379608179069346, -2.2860015477895064, 5.6577283948309276, -1.1987192397251691, -2.2412385358850528, 1.3131867957799648, -2.0451972501438362, 3.9112212058529834, 1.7960234904922694, 4.1088588400350465, 0.0054163876210178812, -7.7684254104098018, 2.5896704638082153, 1.814135436005482, 1.3455740611819829, 1.0854706075604086, 2.9259978673422187, 3.2948956374034752, -0.90118198534553362, 5.9256616184967843, -2.8171990374781495, 3.5256586579470297, -2.4447526402739932, 5.2740146207890524, 3.2102276124295637, 0.67201721265920988, -0.6155167444546692, -4.1375002041008413, 1.3951088571630046, -0.49210080325251382, -3.4126442047278296, -1.1389366692402012, -1.031003996613286, -1.1503656156594471, -3.661140555733629, 5.3522163221783394, 0.32349259691093346, -6.3168987249182944, 2.978295804378003, -1.2874969352306158, 2.2434124070581851, 2.820301150620327, 5.1059248105480188, 1.744354121760231, -2.719691608711253, 1.3498021842363745, -3.5388865467639481],
                             [1.1465293064018427, 1.2609708132238286, -2.2234115620751216, 1.4086670911973893, 4.7431877070340791, -3.6075283489758738, 5.6192769237495801, 6.4485055270965859, 2.9336810762542096, -6.0512907833164951, -3.2864403050500157, 1.8027760688752774, 0.30057569752186203, 1.7536005734490052, 7.2204547827386758, -0.38483511517254981, -4.792811229658839, -2.3876490324923121, -2.7934532073028997, 0.1764212497759538, -2.8488102154554356, -1.4971215047814566, -1.6239281751756887, -1.4900708932720734, 2.7857444361208303, -2.3839073079165596, 0.036725648755019838, -2.4914955349085921, 3.1956474619733601, 0.97691596305551387, 0.2601656542307943, 0.47454542941638733, 0.17274305013972502, 2.9453903725203463, 0.20618334431805663, -4.4874466661554298, 0.87574175832727341, 4.0960855518350456, 0.14081662430895822, 0.067114524181120905, 1.6217540816234426, -0.49719565926563147, -0.84020843634852982, 2.7885257641488765, -0.91548909777340859, -0.72711010098564755, -1.9835446473447249, -0.1274858477474726, 2.2794058028425939, 0.17136554945056584],
                             [-1.147905469991231, 2.1134424113374495, -1.9397037569185458, -0.42590479037733947, 3.009708086709213, -0.83594383628680125, 1.2904077886805112, 2.3687120261209751, -2.0907180434698565, -2.1842567637472423, 1.8407310852479422, -2.9514062228252667, 2.4190005124585543, 1.8517335247055287, 0.8818278323012626, 3.6933137177786906, -0.62671250714949789, 0.37196298979330417, -2.2838750382590556, 2.1718723954035988, 0.42571276127859775, -0.62145557829902698, 0.11726574623147577, -0.1202397384199768, 1.1988524684408801, 1.4502660837355315, 2.4176529419113457, 0.0016687830933002129, 0.88024069926868498, -0.60161362225073833, -0.40491587768468651, 0.97119596572772338, 0.62332113432833436, -4.9751432627322805, -1.4246720729533338, -0.31438837042096324, -3.5608999012138995, 2.0611030450562811, 0.61666118694069316, 2.3407799554037014, -1.4978978723820924, -4.9521311948339948, 0.48487898650983419, 0.31270971361627276, 0.14953547759985505, -1.1414148946268272, 0.45758576439594983, -0.60559009313369128, -0.32761191287651947, -2.6313580652463142],
                             [0.72590161661843566, -5.5008125506568248, -0.68423243409106138, 0.72773511379236, -3.5501397761728981, 3.3048252397907794, -0.31714883428675361, -3.9181684932927396, 0.94926234267410647, 6.2954609863621984, 1.1224820718464661, 0.36906141623446559, 0.74075231544332287, -1.8237990711254186, 0.34135643830737578, -1.9742299812507087, 0.06411426084726142, 0.7969340023560938, 3.4807241192467697, 4.4590519495455823, -3.3075105583953626, 2.9997470094015974, 0.68638327111039876, 1.9768829436972959, -1.1652396333998645, -0.32889697530608986, -0.85375020828913739, 2.0646823339368168, -2.9683989093564596, -3.4340025922409545, -1.1552568397423448, 2.7144745308889613, 2.5084850562161551, -0.65849007153654171, -3.7589593029390378, 2.0273739965746929, 0.42596665179711879, -3.9531661603661927, -4.0551073180893145, -1.3136702148007517, 0.81422842121805883, -3.0072997503086389, -2.9260043596268739, -1.1873826706002666, 0.60392192401098155, 4.3028083424116739, -2.9779197839897074, 2.5859152080450181, -1.148375246997607, -2.9903984543820252],
                             [-2.0443049730064846, -0.22995285190179382, 3.1031171151999426, 2.8479746557535135, 2.1579759205997315, -1.8463247036100898, -1.5447804607007738, 1.2360313106530829, 1.5238096328318886, -0.81044544313301792, 0.0067954513617825528, 2.7947109792862297, 5.3792136245902586, -0.96941442989669768, 4.6579904686032085, 0.38997692678629381, 2.8571759727651362, 0.79222970180723451, 0.38246420427550609, -3.437916963831527, 0.017146447510332431, 1.2298133218692215, 0.05788257886776086, -1.10638203629875, 1.737613259499432, 0.090349076482622373, -5.0420275214458803, -0.77041720923478241, -2.0539274592266521, 1.3122596394925987, -0.083843852770791594, -1.3142106267282834, 0.44312500457917503, -0.515087499680698, -1.1673743081194934, -2.0309035837107059, 2.2074996464909176, -1.5332124861995848, 1.0380701123459344, -0.079568958251805058, -5.4284582177767042, 3.0402967316941267, 2.2567651693297197, -2.0252845207539778, 2.6433607193379416, -0.4682180724726972, -1.8188529660553494, 0.58633985604712868, 0.16116772088284798, -3.9110719830050171],
                             [-1.6170113997510345, 4.0861645959475474, 1.8405509771525554, -2.9511609606499145, 1.9088072282995092, -0.86132411787956509, -0.6073909449991538, -2.6475102929442378, 1.2748640057743224, -6.0003553159087879, 2.2411376789316648, 0.55185304267525992, 2.432616659992143, 2.9190827291931774, -7.5206920422289967, -1.7475276440663623, 4.5156617867067963, -0.71323867102804295, 1.4243016632470682, 3.1526693502267258, -0.68327841781317677, 0.71859902394653641, 4.1299671844744692, -0.27011867818439234, 2.1202733655660104, 1.3257719077612911, 1.6659521698891846, 2.0523044630077631, 1.9548529614760253, 1.8178438313975398, -0.4262873680615894, -0.75703698583278378, -0.064071572957747486, -5.0656534646082436, 0.82877951104371794, 1.8129773238962774, -0.59895624304618289, -3.0374152141421518, 1.7472142657660412, 2.3374297527087542, -3.4053780257871007, -0.51191556263561644, 2.5101997676267298, 0.13425531591834433, 3.2526278736452725, 2.8701206587906212, 3.4716275245268595, -2.6736548159177955, 3.6564742659418461, -1.8552612842669187],
                             [3.6236756838235529, -6.2978895644840023, 4.7628980657465219, 3.6740161663113602, 3.7167458367345181, -2.3552046854587441, 2.1568680760254968, 1.2511163979597391, 4.2244465622164631, -5.0784602448735354, 1.1709720190881168, -4.1698886183822399, 0.72311933242655546, -5.9302609214565338, 5.5816363696615463, 2.6570916807081035, 3.3786914413171587, 1.0346794785427047, -1.9970682063744976, 3.337915359949974, 2.223257533568928, 1.4615292273441909, 6.3038597435335006, -1.4739124812628868, 3.4553438845838595, -3.8468033864342313, 0.12309004265698241, -4.2181653168339892, 0.53091361417253402, -0.62338770989063697, -7.5419229371282768, 1.5041259727724448, -2.1731288413747252, 0.38252969117661406, -3.7900729606041308, -0.52307019364907392, -0.048839529294243636, -2.7217759241390791, 0.52450351024169217, -3.2723363481362928, -0.30054802319311158, 0.19065791424036077, -4.7724393635189717, 3.5566765154840616, -2.7577619560829576, -1.134886588132459, -3.4676144830944069, -0.39845685642499007, 0.56621019395526451, -5.0905273131711963],
                             [1.0722069181870526, -0.3252708195491662, 0.54364586228811396, 7.4204088171283891, 1.5485722689430603, 0.5901186390593316, -0.0025304299536437411, -0.79799499343518365, 2.6204984228871595, 0.11867981772180929, -1.2944351260158193, -7.559841046601397, 0.54079073131081801, -1.4716532231264614, 4.7919204185277922, 6.2916443186136837, -7.4121717191399306, -2.1191771659188232, -0.24349481137330228, 1.6650315610450577, 1.8842011189573811, 0.026076191336695573, -1.8791736280778979, -2.4913577512212726, 1.9219110450070622, -5.320218622392666, -1.0329583564797906, -2.3806913286896467, 8.2372292676310952, 3.0852338682701568, -4.4199509848389802, 3.6882401186491003, 1.4257996474546215, 4.9006778168759206, 0.29895148566663887, -9.6666929361360872, -3.1695690607638918, -3.9100801546163848, 0.54895328578722025, -8.8355276162673579, 0.40184256931909562, 3.3965946512939191, -1.3203194424546867, 1.0716854062899179, -4.1148660896817164, -5.8344316399533458, -2.6749679721294837, 2.0065352603058813, -0.089890813503650829, 1.9034609731078884],
                             [3.5023345000296784, 4.3781981335786693, -8.0867443821627507, 0.85584463373362807, 2.8516323437308908, 0.28674548716558268, -1.933934952645572, 2.0996519789401713, -0.14945406964424093, 0.046411916355009769, -3.6542567660345009, 3.6713111311343987, -3.6698460977562726, -1.7414349098939543, -3.2860812010056319, -6.1159072892959445, 2.1826842251205933, -5.5446409144922564, 1.7614215634802697, -3.6208566351677325, 3.8156017798195516, -1.4237185046744592, -4.7246592196952877, 0.85137372637515196, 0.23582668544961319, 0.63606765896694117, -0.90279511510377819, -0.072110031836234781, -0.43664305534995873, -0.51444402663736299, 4.7267436098204163, -0.59924849349306719, -0.45724565883774787, 5.6667895357338303, 2.6876750029275303, -2.7212188158453348, 2.4063268928946187, 0.14401790024986411, -2.7153049700029523, -3.0373236533216961, 5.4168823372450357, 0.95341660917659876, 0.82684648612345157, 0.57877434765917946, -3.5781328262358105, -1.4150999176784074, -0.7959854127207131, 2.6646456187392324, 0.7388344819899888, 1.7690452580364742],
                             [0.43263878443265991, 2.0045925360418391, -0.26130573771761034, -4.1218964005016305, 3.1124600549787242, -1.9058728624967103, 1.3555862958955416, 2.0496201791267752, 4.5938800919150493, -6.5141858601156031, 1.0821133878299363, -1.0415339638477865, 1.6460174602411415, 1.7617229125611347, -1.51625899755058, -3.4799817063822709, 3.7332206715165159, 1.7456705504829444, -4.329688208292044, -2.8737716488652985, 5.2884584163695534, -0.29192009763000165, 1.7170437683664168, 1.0363955205896345, -1.0762460134293617, 1.0385917126780924, 3.1425684148169015, -3.3273503331940359, -2.479147150026292, 3.2118352182502594, -4.4723279141879715, -3.0827959337486361, -0.84096788208331186, -3.2068928858387191, 2.8843448745975202, -1.3827787284409971, 2.0517727348143704, 0.11573789662271806, 0.8136644987731203, 0.43591046795211946, -6.0467975014905111, 6.0796348377429723, 0.86398377848534813, 1.3130060537421471, 0.11262111770172413, 0.017750423827048008, 2.0158079110140457, -1.2780241753986255, 1.4255391446624712, -1.8596027522640832],
                             [1.1523298957527883, -1.3413821605616909, -2.8010058944738803, -0.34306374356496588, -3.5791325177774134, -1.4028132815137637, 0.90588254973264393, 0.2010946496354124, -1.2465500515904235, 4.370452106503719, 1.4094293451475448, 0.22427808064001048, -2.3066817414554963, -0.55863117419199126, 5.574811788411413, -1.0004274265258126, -1.1430972632632928, 0.26108290736587086, 0.42384644144838507, 1.3882814961841377, -3.39946622182917, 2.1707193288443722, -0.77555778928698071, 3.2628872697506739, -2.2042160911026079, 2.6704121871852178, -1.5441627755285305, 0.66190509934319985, -3.2347828740210534, -1.0305026626433491, 2.7640430185575684, 1.5615132446217721, 1.0152405993751854, -2.9331424384268256, -0.237218258237336, 4.932422984192903, 0.6531678832236576, 0.7981216253520298, -1.0947687365157213, -0.29222776223119962, 1.5937281785100434, -1.7177581358843865, 0.1988299453725598, -2.0363479568051646, -0.40859022640929221, 3.0642637679488685, -1.0573701087563609, 1.9832984510693683, -0.36528157219418206, -1.5424826264000449],
                             [-1.389032119637917, -0.42210834237381611, 2.497078880790232, -1.9271936994566718, -0.36423176709669858, 0.39690203559394782, -1.4737130284386004, -1.3492257700974326, 1.3742846193230602, -0.88558406192153294, 0.41071108134862694, -1.2464183123190991, -5.1656879466036028, -0.23014790896045897, 1.4369755681007133, 3.8708485555265111, 4.5572002853473847, -1.0722314266870985, -1.7533334377385028, -2.7797519668703168, 0.79148066180542731, 0.81461148985256315, 0.75730224857078243, -0.96749511874904381, -0.0084964501717093473, 1.6200286178698122, 4.6496390936242333, -2.370221057734379, -1.3330365969920097, 3.4727740669020761, 1.0081912756410187, -1.516883807589799, 1.3754820597103634, 0.32158225183859329, -1.8128687370205587, 2.2056868819698927, 4.2469729908237372, 2.4125120499913284, 3.4362717755079886, 1.7034851466238501, 2.1693944180325229, 4.8202601754032992, -0.22169722539475911, -2.9401921952234482, 0.56234036169517887, 2.7342811778379907, -1.7827112889363126, -1.2629602565487112, 0.32890038958303891, 0.96331324467846413],
                             [-2.306544732016925, 0.36868738609905832, 0.097100704303860419, 2.3035732053080249, -2.5545015352842473, 1.478663775525408, 1.8276553998824745, -4.0527612677545086, 4.1123123969124897, 1.8693818677235137, -3.9740558433117568, 0.27537664723483818, -0.94618164781049785, 0.50649042115820642, -0.25937089474266828, 1.9707281268734442, -3.5670726897367131, -0.29082291971955415, 3.5407222110846019, -0.13409443661081524, -0.48171287820065617, 0.88514582447957746, -0.21592780769970277, -0.18389440029824622, 2.9768640489115339, -1.816456865676485, -2.3967278823558886, -0.94797521689081388, 7.2077272034602347, -0.32223490041893604, 1.25634482647458, 5.4172552040240625, -0.57931565284712361, 7.3451426669452893, -0.68713156014469201, -0.82995925398673798, -0.69816713333812763, -5.2553877096113899, -0.47371185981013214, -5.1526055137731994, -0.5558044807077972, 1.9246179334226257, -1.0924932562229261, 1.4683401190737435, 0.89230601537192578, 2.6793095111277103, -2.1735218330311774, 3.1181199719247235, 5.2812607956248163, -2.0701754858564607],
                             [0.38327196663017732, 0.13931448573251767, 0.046133624560080702, -3.0855814725014774, 3.7112422306785491, 0.85303342715557784, 0.3514731590460336, -2.8455296996937562, 2.7322697469942905, -1.6134427357050098, -2.8142262592527216, 4.392939243972366, 2.5253366547559266, 1.3150180826403122, -9.7487371829500997, -1.7555729011553018, 6.7548366130976989, -2.3686131080038262, 4.0587086662564769, -0.27472239033636209, 0.5383657944969874, 2.6377253333016273, 2.3178383104829234, -0.15576771801777736, 3.049827438315635, -4.0371715826174404, -1.8736978410148692, -0.080569278208928063, 2.325566241483616, -1.9504186285524461, -3.4111458078230714, -0.064059543088556631, -1.8737152669343311, 0.48821255441183986, -3.3383931359669159, 0.76022050242226513, -1.7061317718368763, -6.1845435032874292, -1.5554883643260482, -1.5876289911565167, -0.93603669377600962, -0.032708376757307908, -2.1908642608095623, -2.8049095074991865, -0.36052812734129142, -2.6237717361473054, 2.5840520035066739, 2.7950546030844836, 2.2331332777752766, -2.296482488079703],
                             [-0.62158141919095333, 0.38413756517848335, 2.7181844883162696, 4.2240823601440001, -3.9946942559945886, -3.4491619153835993, -2.0934355073512108, 3.3422222095079603, -3.3683311137591532, 1.0744541335236317, -1.1948296862883974, 1.8995376859068982, 0.39903642698891745, -5.116047009525289, -0.86340755259090374, 1.8771799245188467, 4.5110639709215725, -0.57496638223291863, -0.029318201282201646, -2.282841863720602, 0.25651102691591676, -1.0114713937134698, 2.7813145215634787, -0.24952268748444464, -4.1071889944151998, 3.4952372358735659, 0.35704566839879598, 0.95905210707723243, -1.5853684988494472, 0.53908316969953229, 5.5186571803037392, -2.4057295521776072, 3.4079297303362561, -3.7864127673068255, 3.5554221967284945, 3.8266701658788453, 1.3739682927126449, 4.4361910180617379, 0.60259109230536512, -0.44271839204265101, 1.2615942444345793, 3.0317807292192471, 2.1760461622373337, 0.20135075285143153, 2.1114339305354624, 0.28317051177947844, -2.8402631132628797, -1.2844001325956158, -2.763389439290274, -2.0710922605117799],
                             [-2.6847164172992888, -3.9402471422209735, 3.0704327537179115, 1.7431992425849883, -1.9322667280127326, -1.397021982478909, 2.2678074133770632, -4.4374123278018747, 1.5518544942326498, 0.96695792965904659, 1.0835868139735576, 0.61485314611655673, -1.7438895271102692, 3.4966830945144562, 3.20942240557447, -3.125804618708496, -5.3390972425476191, 4.3911498149953436, -2.3827825595834025, 0.69186717727986202, 0.22727885747715998, 1.3470067635284317, -1.4688858852358573, -0.8698561539591283, 1.4005881052587998, -1.3173632422514741, -0.47079933580595951, -0.14141286293610475, -0.21055835810284293, 1.2874819032295777, -4.8979432201911033, 0.34137450226948313, 3.3618008098130163, -3.2491094309164175, -3.1527220361376984, -2.5587547841422182, -2.9748725732580392, -2.5983979096386536, -4.5405379796487733, -3.4566409646863083, 0.38109492261725997, -3.1183945008694183, 1.2913027814180016, 0.0023129539768633601, 0.62767618319457619, -1.4977859394126269, -2.2617019872173141, 2.4714249132203929, -1.2499279691080778, 1.6285612337239772],
                             [1.3445247389113921, 1.9359316174766177, -1.8574543121434677, -0.25747094478473792, -5.1276904342857419, 1.1837881906843677, -1.5895144397863168, -0.83260570013243096, -3.0285078224428026, 0.76316880669705922, 4.0317111105407175, -0.88621158448106796, -0.95430916010110611, -1.8619829385277413, 3.081374607341536, 0.54342997238043056, -5.1310153021401135, -0.86162573448057977, -3.2278960132271006, 0.27609678783226965, -2.3889700674810834, -2.3798016282775323, -1.4314452696435949, 1.7584991481915497, -3.3622044260855848, 4.3668825549151293, 3.0056283473168151, 0.67699895028564216, -4.4929430835956419, 0.435584896214399, 2.1209797225266969, 0.35984786061881457, -0.71979260540525281, -4.8099697282888361, 1.1295106076842949, 3.8555075508943939, 0.24894872505921001, 3.1495860754710407, 2.4884932647348288, 1.227008734280723, -0.39626434147683559, 0.20291705742941149, 1.1246067264863948, 0.26183567826190579, -2.3626984363257968, 0.41997639663944941, -0.47019221973471714, -0.16266190683808959, 0.66751925656486788, 2.4940482572002676],
                             [-0.74541551091073854, 3.999178731172182, -1.3809594005932904, -1.0304655784266186, -3.8087812426150549, -0.40604591526131911, 0.22322898638418329, -4.8847362340787797, -1.2142421706920274, 1.4302887045188084, 0.42877944040029781, 2.9893803979540552, 0.32135022975548166, 2.2055425541071596, -6.1965201214259826, 0.34574663646396608, 7.2446560964290434, -1.6999160053633544, 4.5928586619709453, -2.0074203091992118, 1.1793154579228242, -0.021553004749814454, 1.9260915980903044, 0.66891980798261441, -0.58791195101553384, 1.845484218323697, 0.060001516856414541, 2.6056107980121515, 1.8450166029954955, -0.49330153095564083, 5.0526510519656052, 0.86045745092540649, 0.17793504775822022, -0.35193077513908949, 2.5763339846761686, 2.7532054558241312, 3.4483803100559114, -0.61305377119503301, 1.0637241242928936, 2.4069507332662399, -0.52904488976767872, 1.6722880288283142, 1.1641181165263148, -2.7562524811484383, 3.6992120202850223, 1.9450419199813085, -0.28255608877653282, 2.0692556242871714, 0.9868761764185997, -1.2436200497856391]],
                            [[1.3903395442838955, 2.1823093918501679, 1.4682907771316378, -1.8100343859726613, -7.3873759640314223, -0.20563205156589742, -3.9398133350831048, 1.0435032192431197, -1.9229145601666122, -1.6359075241312204, 1.3953440243199955, -4.8461535835609251, 1.0786842868245234, 0.12883545549054501, 0.23901094815379151, 0.90378145488735528, -1.4765593041903671, -0.47915910893140257, -0.26129622188249974, 0.76383697727714106, 2.4526086911467258, 3.7395789011406695, 2.8053282373095558, 1.4950061320987771, -3.2269522744549497, -2.7374586557391973, 0.87036438809063521, 1.1707966933933656, 2.2935197311341424, -0.10611907386742762, -2.9746483805277264, 0.079867282079704713, 1.1778636567770315, -3.0205149587816389, 1.3242620079994165, -6.1390346293773259, -2.287543062700867, 1.1869638320367668, 0.72052690993162671, 2.1537436678278756, 2.9410061682506248, -2.860985780111502, -1.4730116054864746, -3.2552762726452644, -3.2541443437136124, -2.1061465330227254, -2.9849389409015528, 1.2828581289394814, -0.42585529658136939, -1.6846520889977896],
                             [-1.4535191775901846, -0.83099341191199438, -0.37897689410594665, -1.8459506462731761, -1.1684782151357778, 0.022276419901647769, 1.9918178120561609, 3.7813898038104661, 1.0094952228655085, 0.96902521915521267, -1.8558783741974583, 2.302953323698727, -1.3188872453371965, 0.29310333839751329, -1.4902516616791166, 1.1863863046773209, 1.5670036773401423, 1.4652506813439119, 0.52163463077945449, -3.3050372492659323, 0.18463465179551425, -2.6036566333608704, -1.0267440721247039, 1.2147552351800726, 2.1451302809467063, -2.143471684918556, 2.3827668340089523, -6.1947848866143715, 0.50787337973038171, -3.1247661891650318, -0.968482471469859, -1.3763740548578969, 3.1398145406161402, -3.2276019421430546, 0.73409268714219256, -1.8207524346930282, -0.81373733699545703, -1.9110709533854568, 2.8653987255681721, 0.32331926720220378, -1.6199664863041805, -1.0293912637985594, -1.2742268286968392, 2.2424870544204976, -0.30693230971613361, 1.7383701458493501, 2.8274662661328582, -1.0449099437412963, -0.92910013773142752, -1.5215049757107053],
                             [1.7531869503418005, 0.73284682702102522, -1.4538105271100663, 1.7953356367747138, 2.082533105688384, 0.2335230161413287, -0.01036873097296153, -1.3471244595577403, -2.1512720323562666, 3.3581666213817174, -1.65597666116252, 2.636823408633266, -0.58272861781473484, 0.74376354574712333, 3.5286584022035532, 2.7194030657489252, 0.75713788045677732, 2.2121850371523806, -2.5157276005859632, -0.59429521772084493, -0.90740364436280785, 1.3512197424474315, -2.6289229084205146, -2.9593722261394335, 2.0238410229696231, -1.3905246777646607, 1.9706540529792917, -0.44920645546741417, 0.28187304783007938, 0.97991915365634474, 0.095954667758091444, -0.46142341307045986, -1.3324284988773603, 1.7969784179143466, 1.0566897511330735, -3.7692277680342476, -1.528973042921709, 1.3646854402386099, -0.19758222391818103, 3.2702313686485276, 1.9768322394613769, 1.9609238640881945, -0.94154314378578685, 1.9791479613356249, 2.5016752508317617, -1.5782216813190693, 0.53954055837459636, 0.80854234038275041, -1.0137961053497113, 3.4730919284181292],
                             [-2.1290762899072755, 2.4243410086108619, 1.0007453531957331, -4.3291060834921895, 0.065624960617976458, 1.6882344577618251, -0.13369208841631727, 2.3329218629292336, -1.539724554191898, -0.37411092311552852, -0.63503086166589562, -0.25713330926120076, 0.055432751131156033, 2.2522045629707232, 0.99990827660558546, 0.52137283064818729, 0.014282953597800399, -0.38000671299761585, -1.3822783587976883, -0.23978837529374455, 1.3239883264126382, 0.82751206612749106, -2.726942002556406, 1.2391215526898756, 1.3072258029546477, -1.2149456656741309, 2.3740720921928102, -1.8322940911936618, -0.73009928003420776, -2.8507141166319929, 0.96352445343640636, -1.458438034455755, -0.69414836657577672, -2.7455086257949595, -2.615860397416288, 1.3935634663077694, 0.9978366162503296, -2.458194868169707, 3.7113387873838768, -1.640276006730387, 1.0366349421375871, -4.5401064309207824, 0.21527903563886491, 3.3889877533520512, -2.5821196452872286, 1.2004019427250519, 1.101555494397745, 0.67889164643225963, -3.4838506121802131, -0.45383161066613908],
                             [-1.9056519762140891, 1.8975261299888087, -1.4065034692206584, -3.0211023180508927, 0.78083841137557686, 2.9776118355585517, -1.9215955017399897, 2.5394739054746851, -0.49513175077188365, -0.61741780667004564, 0.4918406687827529, -0.686228549306098, 0.58972478764127612, -0.64809483754687813, 2.0089328346080428, -0.13925968582609358, -0.11709699988479864, -0.30322926358645708, -1.8555261110203118, -0.15946397856698047, -0.58575072809592954, 1.4299399972407081, -1.6491806952443508, -0.35747062943607183, 0.21598582472333119, -0.42642140506331888, 2.9019351045807769, 0.20720030864088657, 0.11443997344157403, -0.39287534875018154, -0.51884938795630375, -1.505730535355664, -2.7946996559700077, -0.94752031287970084, -0.47559545759213662, 0.2033020262689825, -1.4563602074815527, -3.9247956453487411, 0.05668711538524554, 0.49833176327885609, 1.6337354902192176, -2.0755766047035786, 0.057075694170549612, 1.291064609705312, -1.3370241980821611, 1.3195268778778397, 0.31033084756537244, -0.43910034624179062, -3.9945745423000236, -0.42363768854284917],
                             [2.1742847737603781, 1.8351535117045397, -0.56773532859396292, -0.36087046264939343, 1.9783682921363281, 2.3249097807391292, -1.471370567510305, -1.5040206015941038, -0.94517740121855687, 2.0193464359484024, -1.3657613564943685, 2.3343914795553102, -0.62693631487891477, -0.30300071548107593, 1.7994485649864944, 3.6581861364219881, -2.5248406297986685, 2.8687290374466028, -0.16529819946146032, -1.3981231953307338, -1.2905738116735019, 1.2687957880237255, -1.7685597040263097, -1.179768014934278, 3.1560961754717947, -0.39459970272128625, -1.6481853432722544, -1.4552555555699669, 1.2071347320564352, 1.9821999287333416, -0.5864186525877032, 0.53329546838848407, -1.2514105001797304, 1.0872849090538319, 0.25209082064779759, -2.6826393852542267, -2.0942515817123497, 3.380639566006689, 1.0463052280329928, 3.2632218469518897, 1.2540440279437859, -1.0945955855376084, -0.20612973449174898, 0.51753626990881374, -1.5377266410990644, -1.4633616613621081, 1.1168448226696261, 3.0748794657661054, -0.13598817599568513, 2.1295986000121387],
                             [0.089624708791795293, 1.3066714579691661, -1.8730999764275496, -2.8477946446333449, -0.27398295212094476, 0.17992058748566028, 2.2995932652679003, -0.84246955281293401, 0.43316294392562038, -0.25229940413160951, -2.643446476533251, 3.806024640180945, -2.3404151391023706, -1.0538271588447017, -0.65438670881624594, 2.0286959496286339, 0.092932242659944111, -0.66720911836501196, 2.0914989864524922, -0.68341410528094837, 3.1395155433711763, 0.089806297319304187, -1.4153966343630595, 2.0411950238107335, -2.2346468917546369, -1.1817129769978998, 0.27444273920797374, -3.1732397655630926, 0.51144485277120266, -0.87649557594478045, -0.031216513886077286, -0.12853379068682011, 0.075894135549409394, 1.6980431241369516, -1.3202521300762533, -1.1941166099536558, -2.323588512491745, -1.3931974549300552, 2.6190902882128424, 1.7059274717624349, -2.4967912057902129, -2.6926017687637023, 0.42346969823726405, 3.5349443435609871, -1.1750663539507298, 1.1292681371953825, 0.063560569718894733, 1.5591631551524416, -0.12288079625082232, 1.7000440108545281],
                             [4.1257365309428069, 0.020349889637919411, 0.26311586398987163, 0.17094212807703552, 3.5601626058072005, 1.0584155694070403, -0.42402742097961693, 0.51264216954791086, -0.7018103818651128, -0.1469922281727446, -0.16088610776099987, 2.9064272672082767, -3.266384075540036, -1.33165571910731, 2.2981900981149508, 4.4191138276111728, 0.25379589778320405, 1.1736322286670058, -0.5179941489954738, -0.85406116697167167, -1.2087990103612563, 0.35212916125867377, -0.87436318600827778, 0.85969555141976939, -0.089050390503646493, 2.0376165699957953, 0.055980963992568578, -0.90718530474244286, 1.9638396187041092, -1.2296495134781842, 1.1419680799824745, 1.8712386631312177, 1.1045795567686281, -0.4867405584736868, 1.9848358532248342, 0.96392266145026617, -1.4627758701781257, 2.5304365223706604, -2.139846064473224, 0.00091966243708812082, -1.7841919097450292, 1.1219925366465864, -0.62303910569947707, -0.36636670435558938, 4.150581976311118, -0.46030352664647528, 3.3018264071283911, 1.3552549169131183, 1.0440154468530563, -1.3040101996278175],
                             [-2.1144103794024294, 1.6372254715214829, -2.2641098840154918, 1.6630351639604359, -1.58598570278712, 0.39444913068116044, 0.43467428518325874, 1.0676932879323469, 1.0007701263926085, 0.83661517475744507, -0.11395799451254929, 0.16610338255807272, -1.0935350297270123, -2.5630286557811108, 2.417044216785099, 0.63027378402299339, -1.5396713997859754, 1.2883561529441401, -1.575102290099228, 2.6960387290483507, -1.8217112824316344, 1.8663093750290902, 2.6641830974671707, 0.4291775914748579, -0.29815314154064237, -2.3070253481720244, 0.60896580300768366, -0.95536576625564773, -0.51603051018592916, -1.5837646217507451, -0.031436960962894368, -1.5304402668865627, -0.48733502348969904, -1.9873926173543797, 2.9297543287364496, -0.51363385432622211, -1.1318718850470413, 0.22169736573361526, -1.7033669221953758, 2.6309944021785854, 2.4594878919588412, -0.015255434356066522, -0.82360657482939981, -1.5501633673966715, 0.36298281405457583, -0.39476606619086346, 2.1550986607398079, -1.2263679526592577, 0.48050355177600196, 1.1532179177061799],
                             [-1.3947029890817375, 1.5058696972529846, 2.9779533655018868, -3.301285353836386, 1.139163942289859, 2.2565513549595613, 1.7992220972578969, 2.1438189264210021, -3.2862311602077714, -2.1718210128771394, 0.99554926351950479, -0.09395545927477543, -0.35501932193344321, 1.9860516917322033, 0.9515066581789845, 0.99754878690830517, -0.057205895815783593, -1.6112817497426706, -3.2202679148501341, -2.6922899693487565, -1.6535372436111215, 0.10233902122585108, -1.6604640155602155, 0.41219568807407403, 0.80184685902681474, -1.3895401675221699, 3.1091419683864721, 1.5234717178219521, -1.3836117166359805, -4.8499941613416739, -0.77811192764849779, -2.8665805910024278, 0.54524942747488281, -0.93313605604383465, -1.9395683897872638, 0.052166241954461436, 1.0327745792341769, -2.4760523441315105, -0.32509168240351716, 2.0082337546754658, -1.1067946459949884, 1.2085729521100546, -0.8172155488141466, 2.1733579483039422, 2.4926332765505741, 1.0159814003359784, 1.7627472668660567, 0.19088868172432893, -2.1056946500772638, -1.1911088817561273],
                             [1.4867001241029452, -4.1329179733459656, -1.2059538522134186, 2.6041428978149499, -2.4655621634401323, 3.0815965201548057, -4.4023770957829971, -0.45922349825227649, -0.61108323530622632, -0.094110157421428919, 0.44960363708540124, -3.8879204106684848, 0.56153424914740557, -1.3937243677543176, 1.8896705923507633, -1.5104875455704467, 1.0692468367550925, -2.8097609188504671, -0.15821805156946486, 1.2175389710029947, 0.053893581562894255, 2.5906100561609744, 4.4302063465026142, -1.9496446219905748, 0.15342379694373726, -0.76842348883825573, 0.94289086666254107, 2.7714542095449217, 1.3577438175556895, 2.7835157834656425, -2.732371328013127, 0.68703990280454341, -0.40323055370825051, -0.74882703020262797, -2.6026706635139791, -1.3417773681577294, -2.0721219943405473, -2.0594124295229426, 0.74128983961099504, -0.63707233263354934, 1.6935000677186789, 0.28843638476554373, 1.3605074083769948, -3.4780706181660848, -0.84443629082729099, -2.2273237052049244, -2.7875180260118233, -0.089836283588543092, 0.057234198212318801, -1.2438019912949938],
                             [-0.29827572555247983, 0.74783993111737546, 0.39083173704964991, 0.053298100424774994, -3.1348944642283234, -0.65106429914231412, -1.1621206556672863, 0.69637208223711622, -0.082083428297781216, -0.94738084669671052, 0.68968281379607999, -2.6396953952636792, 0.94384147464970447, -0.66833664393194159, -1.72311250932213, -2.7615265782952827, -0.28720149241506637, 2.0200715471150708, 2.0361184376328225, -0.4517751534665212, 0.46957942186117724, 2.5929407249808234, -1.2976718635590079, 2.3221953447603618, -0.92334533666964669, -0.3354315505072602, -0.039161567756063498, 1.4098610062190255, -1.3315533203332486, -0.99656275591804888, 4.5567602158752045, 0.2115434419178398, -0.14712575579569337, -2.9753504701224847, 2.2214001402940191, 1.187977346175543, 1.0767752365912788, -1.4019457811016929, 1.7511838388720491, 0.10600863667143723, 0.63779734654454845, -0.44138611685366186, 0.67560298759334048, -2.043169710959281, -0.73176949009309489, -1.1389476762544002, 3.011917934134881, -1.5276634151478325, -0.83235109776308813, -1.0778774643978046],
                             [0.16701835379288454, -2.12621266106125, 1.8769494551048211, 0.16341892033974492, 0.2988241402781997, 3.0586351243676142, 4.4067163677979035, 2.4944747695819065, -0.61951929279954832, 0.30652497954452124, 0.60756718288059919, 0.69066717226575947, -1.0718783540087917, 2.35597722050953, -3.3627340760055531, 0.39371800784748695, -1.6975835381978153, -0.32938884331676704, 2.3580858126687492, -0.59049782381960769, 0.9124710589863182, 2.5368280659433466, -0.26673659193069243, 0.64457354079936824, 1.3739759104201568, 0.0092801279775112915, 2.7358403676477567, 1.2124016921974521, 0.64364299783803125, -2.4438442073013529, -2.8053011623454314, -0.33139366484137617, -2.4063401815580812, -0.37443745498632314, 0.22045711394096129, 1.0416088321330685, -2.4419083480320367, -1.4097941566447296, 0.98558108718211834, 0.55408295865970536, -2.5516007576156094, -0.90425749872066807, 0.174372731058134, -2.1156275412823407, 3.3497963418378376, -0.041885235753780337, -2.0453398179612332, -1.2088259118254068, -1.4960421122954835, -2.2163305108488456],
                             [-0.54183975189612654, -2.6383917693225314, 0.56851812238076382, 2.7539563673068304, -0.74690916575205624, -1.5976563852437078, 1.8267245907907279, 0.34865370071016533, 2.819885954587944, -1.5187507281166588, -0.79868221009291396, -2.6115079552902132, -0.015521742829563617, 5.1274808589956766, 0.19931713014599967, 2.2886318491567859, -0.72776104778370176, -1.2532481430557039, -3.7783159277062417, -2.8677566387255489, 1.2342709527394713, -0.76855845793027711, 1.9057130041694983, -0.28215184750849753, 1.9161787900894891, 0.97779618666233581, -3.5273478674597731, 1.7475240970252592, -2.4386799790203746, -2.675030504084805, -3.0351520202697473, -0.13745348836020449, 4.4558982566047574, -0.96862715592016069, -3.67886391072367, -3.6382744162854816, 0.15957770937868576, 0.44809543216098963, -0.29941654146423025, 0.77927861181689351, 0.86916299876899827, 2.2464868814539307, -1.7233689784864574, -1.0156336160963375, 3.766556335789693, 1.177451109629198, -0.4896591246216434, 0.92547557367548094, 2.8971247300424467, -1.1568316185598038],
                             [2.9284867941992596, -1.7742396879576432, -3.4414254753378777, 2.8628617127959899, -2.2533587805187096, -2.1589494888280534, -0.73228852271926947, -1.7567159788959561, 2.0894284530485296, 0.37954100888863385, -0.32491130501033916, -2.3318641607652921, -0.59368533597091899, -1.4750171791469706, -1.0974735595208256, -1.6287565871603493, 2.495904139599455, 0.087779584478708636, 0.39934430835701207, -0.84469741298212586, 3.6305296900767661, 0.31108597614690198, -0.90747281408114289, -0.12323220580674454, -0.67192484768806238, 0.45824493010722311, -3.6434025590821926, 0.13047256625575557, -0.41649970155261584, -0.58627399008380032, 1.1837684998861473, 1.3662798094791375, 3.1707567756546111, -2.4813338531338784, 1.5504456846622994, -3.0551478672660966, -1.0848832707969602, 2.9882406711461735, 2.0322993129836795, 2.167631566242521, -0.086706946563505999, 0.96967660175628212, -2.1075458807209468, -1.3673578460187612, 1.7965360067725491, 0.90479208440794168, 1.796830919640229, -0.51366476545040773, 2.6434391548364062, 0.19291507029077695],
                             [-2.3021734417218416, 4.0089957548711848, -0.97935884179593369, 0.059943292536775189, -2.7989855925904932, -0.96414316701860359, 2.8289249076084313, 0.57300016086037597, 3.4172212423776229, 1.9237381885514593, -3.1300993470787333, -3.6705743547512206, -0.5247612008678374, 0.94289798577115658, -3.5616896311782766, -0.085634714510976206, 1.2003386014378215, -0.2872818284406547, 0.39990972030711303, -0.42346879784333796, 2.211037917931316, -0.60665567032250234, -1.0218807039955107, -0.16750495987822173, 2.3218908344292819, -2.9315086546747429, 0.85419578537034035, -0.5271007170844868, 0.88316966091483795, -0.29243930724723499, 1.6694774316850722, -0.54260182199432672, 0.66090894368102937, 1.6670888744604806, 1.5655458196905372, -3.2080768369088117, -1.0647349715167296, 0.018024195896257499, 1.6166550360920353, -0.072226699527449964, -0.18241781783525637, 0.45681058675441988, 0.6957698901861652, -1.3683053451223355, -4.4073833758964289, 1.0089971214020623, 0.015467276967578747, 0.90994931415621771, 1.7374545776937409, 2.2301804421083311],
                             [0.73369059682889792, -2.3930720471342077, -3.9937476877570792, -0.48027335649805186, -0.93784278505227814, -1.8725143873177486, 0.052729020460115038, -0.78881767627886912, 1.3175964913823819, 2.2263797400849223, -0.53696845659646741, -0.74092842817632809, 0.41788622490086902, -2.2781319899404324, -2.0964508582378167, -1.5403318470167007, 1.4810519692477919, 1.0957084838411719, 1.2282994003753003, 1.2941113029389364, 2.9729480101483499, 0.65889915258567877, 0.26892191869244358, 0.33492188305486248, -1.1885830930592396, -0.10918383554119447, -0.36996547674849817, -1.0851537533588291, -0.046353528276394843, -1.3609763709890654, -0.17729700587201841, 1.9873380615389866, 1.4018178167391597, -2.8193641027895935, -0.40576844511451543, 1.7983326683300116, -1.6818639259485031, -0.068313957040912421, -0.43721084659149145, -0.058285315168805009, -0.012838861246511672, -0.67552268313190411, -1.1925436479778828, -1.3246852595869361, 2.5702835353290543, 2.4312641231135514, 2.0971655279588832, -3.2693143849881894, 1.0680782031525597, -2.1579642386012834],
                             [-3.1047726752675437, 0.22434771161792955, 5.9219843169398558, -1.9838494109621714, 1.2312432087842782, 2.3886282474506317, 5.1736396686286197, 1.276624790216933, 0.5204748720836071, -0.47353909488140722, -1.0629365337605483, -1.2648460728638689, 1.3165077227970434, 3.3236167913006969, -2.7586015390774508, -1.0051701875523644, -0.61192868925196986, -0.85819869762622414, -0.19079742566533484, -1.2792179240415393, -1.5182199455713765, -0.56384500087506984, 1.3231855961754706, -1.364496918744927, 4.8977451628484268, -1.3247642471734629, 3.6521060597272825, 1.3002485378894482, -0.43057717405128054, -1.9424223797424125, -0.87825213060173846, -0.46390596017328178, -0.51807889611191993, -2.4617683496220297, 0.14670080524393644, 0.40356244160329896, -1.5202854788253339, 1.4802122619245777, 3.1354775686606162, -0.32530088182530043, -0.25128023949493355, -0.11190821534452913, 2.6581807021661317, -2.8368709814935107, -0.48908470748749044, 0.40717882089445323, -1.1921703158630073, -2.0598950125283144, 0.3664740354206506, -0.65531483199666096],
                             [3.2252398595747152, 0.14806657273207602, 4.4997633985175911, -1.8416545030980733, -1.0341290364615163, 0.92547284832560939, -2.2167328702149414, -2.8269279039028126, -2.3559735586679742, -2.102075469006663, 1.7457399022380935, -1.3541355306257588, -0.7138912138924155, -4.3816628977347589, -0.26315645481867594, -2.0302818631693622, 1.2224945351175813, -0.80973769685757202, 0.91802690985989033, 1.9977062903895577, 0.68629050664083835, 1.3776862330579756, -1.3755461140186551, -2.1038562508809799, 1.5751582547077601, -0.66084523879492174, 0.55490199511392646, 0.094216229343579413, 1.3234583075037087, -1.2483607454769461, 1.7651378837855956, 2.7566143832684946, -0.084755619484424533, -1.7513035469400982, 2.0976103469661167, 0.97263176246551819, 1.0581946207946524, 0.2645706900864559, -2.3599501107620169, 0.75875768878996219, 1.4681791170296734, -2.094033246894548, 1.518013057612168, -1.4247286817696576, -0.19635794764146502, -1.2317826147584601, 1.1829827778211151, -0.17596400385466227, -1.8227744360239011, -2.886162667637072],
                             [-2.2314060308625931, 0.62586556712557762, -4.6827370514480489, -0.55478271186124239, -1.3944268780881399, 2.1025585343433999, -0.40199791991795192, 1.2982827853461398, 1.0492676700915622, -0.046002104369015424, -1.5053438144405638, -0.81150094834881437, 2.6562473169084422, 0.77917644918409246, -1.0408800126323556, 1.0641536036192327, -1.0297018034254115, 0.56086334001980342, 0.72477974587452076, -0.80277783360653343, 1.5591730376614648, 0.27963517456908132, -1.175870420971149, -0.12576752947958583, 1.4857526097178853, -1.4219439187757519, 0.072228814610985376, -0.94657269756009055, -0.88188389906579445, 1.9027124161661844, -1.1718703315318617, 1.7555472315074625, -0.19904204415905771, -2.176815023189723, 1.0249732986117452, -0.28084003227596982, 1.2922068676897291, -0.31218779002998864, 2.6234640854634228, -2.4468442051799317, 1.3008970408778668, -2.4208347887927744, 1.5031398640454561, 0.6842563498763542, -6.1421755582846513, -1.8256064879981471, -2.6230022468038015, 0.32659349829746437, 0.062776285545223562, -0.13082735452911334],
                             [-4.0022896386386959, 1.8889058983041827, 0.51253254317280805, 0.15414036724229294, 2.0421981792402217, -2.2372613631602469, 2.0735422333017222, -0.29295563965981863, -1.3609663151679476, 1.3769640434465045, -0.58601183772694354, -2.1228768546581631, -0.046981349188455812, -0.75627972229613971, 1.1335904583364309, 0.66625630261157365, -1.6840286710538228, -3.3850733473455588, -3.4365195909360136, -1.5826766347579118, -1.7202690436700576, -1.9935708751139585, 2.9427012534945649, 0.5320455205562884, 3.2222649618974377, 0.17746214588989845, -1.3778702805525123, 0.89374132585745047, -3.0260191340032341, -0.33362371558384474, 0.43954320129206798, -2.4077073444346944, 1.8676061619809585, -2.4182976096721833, -0.59561962546847624, -0.99017543220451443, -1.1601273922717723, 1.0471322391460129, 0.41979152150897875, 0.29877822740876553, -0.17009698382428928, 1.7423622478146945, 0.46014244688695122, -0.59722871845961434, 1.6840766821413218, 2.1249874555283061, -2.2415891397856331, -3.1939546687199236, 3.0802569019744941, -1.4877980483860533],
                             [3.3802355005365698, -0.39373473333559289, 4.7493322554170261, -3.9867769694285236, 1.0232791737737335, 2.4276833071207, -1.545566265980024, -2.9823563007747329, -1.1160181554355351, -3.8148077544867074, 4.0657480565280091, -3.6312144187295958, 0.67177125758186529, -1.9471821824001243, -2.0182838869671946, 4.2322920362987917, -1.751883054363778, -0.19138515983315008, 1.6660567193680695, -0.54005937336228882, -2.9064894233286434, 1.5659650817813378, -1.0334531338502391, -1.4444273707937845, -0.30003559112669814, 3.225878719040089, -2.6293715791094461, 1.2793716900440666, 0.70847494216896045, -1.7319546988515158, 2.9021547646342691, 2.856318224067556, 0.27658576031238002, -0.9729713667119646, 0.41360486002298552, 1.907858407895862, 3.4328678684559439, 2.5578630165641276, -0.47732270367783869, -4.0872181989182028, 1.0028232808464632, -0.71141457047712853, 1.3988918933978958, 0.85116998411906652, -2.4207894325538004, -1.1860078116044821, 2.5721809094876407, -0.4957700550776008, -0.94407939271746955, -2.7891880572844179],
                             [1.6586476186199621, 0.82282164717687034, 0.37856428632547756, -1.4191317789297848, 0.57804671954447084, 2.5699896564185312, 1.7215154245927509, -1.8678185382204355, 1.1524231730566588, -2.2643606397734977, -0.075445440882357523, 0.71962264868740899, -1.8680947300701753, -4.1021413310268677, -2.8335212851999327, -1.1488486606320738, -3.239847967314355, 4.4454536361369543, 2.1648902099885481, -0.39193498974783481, 1.0979228097472331, -3.3042728950817191, -1.233303306195364, -0.20694177444542489, -1.7960276104245334, 0.1365585703665381, -3.9175477221623307, -2.091582537750202, 0.65450059495443058, -4.6660486891571118, 0.57093620050036309, 1.211612841211406, 1.261118667872186, 0.21804931708933162, 2.7635771846207313, 2.5464785683643263, 0.77484407583804049, 1.5316429244848311, 1.4904608466563305, 1.2494320177411573, -1.9238919935635754, 0.39770082772775561, 1.200922085451386, -0.34922185549228829, -0.51310613791759674, 1.4589072275609203, 3.9153066792517075, -2.456529561288475, -2.4034266300547937, 0.75232042178265846],
                             [-1.008215643659611, -1.3953272071722234, -0.49701205091063361, 0.86953836224052972, -3.7107027497330587, 1.6882313144566223, -2.371392915405687, 1.1171712428852012, -2.0149746129044588, 0.42946806309783186, -1.2735368660292097, 2.1237503545084273, -2.5955025003364387, 1.0013717658482371, -0.47291431115298416, 0.84954236138707495, -0.77176755652731832, 1.092118539917577, 1.3152465974222785, 1.9702631041251506, 1.4582737902766805, -2.0718629149800392, 2.7492157360079648, 0.14075605595163579, -3.5666721466518942, 0.36564097285143154, -2.0539138588870616, -2.3889979002262822, -0.45926254435979413, -2.370005426065986, 0.4684213600992585, 1.1167089655821141, -2.4983080097979684, -0.40185175011458601, -3.6597380167039533, 0.090817631113980363, -0.25238340945804166, -1.6453921812059062, -1.1679722629306144, 1.6123688729769698, 1.2596593750043332, -2.8261018660250095, 0.55441664186970452, 0.19332353450135886, -1.8755684536371424, 1.6273743232109943, -2.8103571428720087, 2.3165349514308544, -0.067723795597241079, -4.1067210876698486],
                             [-1.1275316258157182, -2.6376639806014839, -2.748169636881721, 1.4819785828339096, 0.78723388396507654, -1.6294321031226486, 1.0606994873029978, 0.22108778075377455, 1.8657540794459027, -0.20791531864094023, -0.9206229492998298, 1.4791285946563857, 1.4794160320889849, 0.49943329914102796, -0.55504762803738827, 0.085848779016721763, -1.0551319099229963, -0.55198103073268323, 1.6124153164748913, 0.84779200258420706, 1.2322032475324123, 0.71365838840341367, 0.3496283722258432, 2.5382723834091432, 0.59672421079759441, -0.40689843304267875, 0.16245898157772024, -0.24943964280601383, -1.2832956883413911, 0.055956885158749567, -3.2080268453734249, 1.2889755269517915, -2.559634226723785, -1.4145868674107989, 1.6590384540221834, 0.43346161758438057, -0.56634324104013634, 1.5924696200987065, -0.77561972337542551, -1.2093318219478972, -0.82853771630177442, -0.067449854411212207, -1.8274644417722379, -0.36897069507287084, 0.53329552551767234, -0.18717146029481824, -2.5004354835497202, -0.66025845153781393, 1.8862526057792663, 0.92856532730283781],
                             [-4.3994559450295085, -0.12680738878084355, -2.6552314716108243, -0.74567053694035268, 1.9002964747572983, 0.5157897881603154, 2.360602740752586, -0.68475086997023915, 0.04537067345166438, -0.02897008579433364, -0.43450081170393262, 3.4316080995682681, -0.92110438197777544, 0.13696316832250094, 1.3445768635948345, 0.56611686996701993, -2.7031702173077576, -1.8202642479040871, 0.8381556000247129, 2.3565663487832951, -2.3836920973997695, 1.8492453212433413, -0.79658753342888466, 2.8101240753477903, -3.4654249139827407, -3.3952428883333634, 2.1690639944535866, -0.94648198273539796, 0.40704111967370626, 1.0676585792924589, -2.0237798125012612, 1.7113189732248151, -3.3397086741922042, 1.3978750881199875, 0.41234521727922541, 2.5750364228558627, 0.98185437763199668, 1.1379129938072454, -2.4532240278773436, -0.57144844041309995, -0.19437790891830892, -2.2891301491739395, 1.4169120910137187, -1.7529803359246268, -0.58272455160813574, -0.49811345771117777, -1.4529545550841292, 1.6181858082936103, -0.42447233826375913, 2.1073813965915216],
                             [0.83031454091616297, -3.5673732758438197, -0.90758391697862717, 0.29246807937708474, -1.3156289209632392, -1.2159815524543314, 0.65267714282443356, 1.5136172722390993, 1.3298417410852028, 1.4154806874009174, 0.70546765599783012, 1.1827364319160965, 1.2360068763540923, -1.9855007603045929, -2.2151022509453964, -1.7518341498091747, -0.064414212892225126, 1.1939660179894001, 2.0452291322494336, 0.96132146773020954, 0.74530248254589626, 0.53782884390501839, 1.6443992422185323, 1.8731815940367658, -1.7112902613374765, 1.2222572169736394, 1.6050734541631706, -1.0746797033527442, 0.052277460115689789, -0.54522442863675491, -0.74285256771294828, -2.2093403561678966, -0.973685296146372, -1.7498226067736609, -1.8644943926281494, 2.1431298602969817, -2.0456563776231098, -1.1737018337800627, -0.8651259973161205, -0.7127346268849436, 0.62306529964994262, -0.47072029275808674, 0.32960964099912876, -0.36969849459785653, 1.3006447011927349, 1.7688601483887481, 0.52932208535213521, -1.4844796700004015, 0.40935991090685608, 0.73060319970850096],
                             [-1.5031037050069409, 4.9015055248689947, -3.090755583011271, 0.5379884916377764, -0.91121287329506684, -1.6834143971237661, -3.5228893149036145, 1.4414503764947144, 0.59850423595979152, 0.73435283790461303, 0.36570643895231364, -1.6997464735222441, 1.1600210701789999, 1.3322842915996973, 0.0094098992250721616, -1.4116291377180683, 2.8664867277577546, 3.029162807923679, -0.40736181855522113, -0.5052013169178986, -1.8934871648918137, -1.2012744737500149, -2.959971267245491, -1.4116824380778406, 0.92931394814235857, 0.8129781378203329, 1.1865694134248634, 0.060157796900955948, 3.1375518338989736, 2.2341686017386544, 2.026354245803303, -0.29842165248294178, 0.49801934133366754, 6.5652319255030793, 1.6948626599099197, -0.089625602854828845, 2.9871563709330928, 0.25870265494213118, 2.6903586468574527, 0.56026624840947103, -0.6649869959759096, 0.83923529174992861, 0.60188436347137986, -0.94932462410935459, -2.5274195681031668, -1.6737847544796347, -0.82256365710108892, 1.216924977760848, -0.49317279825575699, 3.1511418940677842],
                             [3.1255095033039804, 1.2722065290536329, 0.32996784296764575, 1.1408691484218256, 3.5371667926519494, -1.4178114419036689, 0.32963870153311747, -3.846988526319103, 0.13471459002388619, 0.3709729199336621, 1.7669234710242583, -0.90377519787420924, -0.037368437918941316, 0.28860606489616142, 0.94382781287261208, 3.7654712601006914, 1.3166136452710633, 0.65269528123111886, -0.70193373497238887, 0.37536301318973986, -3.4086688868208004, 0.20142663791775453, -2.7545523402360184, -2.8611158521354665, 1.128190745336503, 1.927597055591344, -2.3202528221470997, -1.5741808842715483, 2.9068391024982159, 2.5098536691231161, 0.10247255820500485, 0.013666877164157001, -1.5009651375951927, 4.3208789463725221, 2.562476755950879, 0.68414906661927499, 1.6668509394248019, 1.8038907235576302, -2.1649650122925381, -0.68311509995926423, 0.36494824418818395, -0.78103079573329204, 1.9408814573874835, 1.1216772288180357, 1.3125372421205481, -0.35759961725229017, -0.43322741679445681, 3.0025906728458276, -1.0079305104565544, -0.83777650550374072],
                             [-6.3159184221826372, 1.7288415387728104, 0.98478730346279342, -1.0963335921975663, 2.2972277639055609, 1.7001256304855907, 0.98807889530417015, 1.2452624697051438, -0.60145052207583505, -0.11952111367003959, 2.89580764808293, 2.1030320096997719, -2.2187782555352435, 0.32222792849495818, 1.8962087412145492, -2.0537733324242371, 1.7399570912626006, -0.67478812885923256, -2.0396462461887559, -1.4153524211851503, -1.6487497649253231, -1.2291613964491237, 2.7595531293813913, 1.0245236845137997, -0.81516001496337198, -1.3967132871504113, -2.4564579130295865, -3.9387009617591549, 0.25677947848318533, 3.1385834270317416, 0.083040032641099021, 0.60335336278939034, 2.5722891339008451, -0.38954501497592769, 0.66297876476133588, 1.3211602554494566, 2.4203460964264321, -4.2316501815883605, -3.2146859700188428, 0.13043465685797145, -0.46991860944937158, -1.1657547049455412, 0.46710533643702251, 1.9863134702573082, 1.490205725788992, 1.4552318822842212, 3.7625520679253408, 3.2456143590775293, 0.14195281148284047, -3.9180473421512447],
                             [-1.3372275353990175, 1.0734151409546484, -3.7752346338803053, -0.55498024848325933, -2.9444801875974855, -0.46462631591350623, 0.35923446113483826, 4.697291107326337, 1.3979620610317358, -1.6352846519069317, -2.6826751391728831, 4.0146141477440676, -0.48018690030470079, -2.1397288346485892, 1.5227248765872909, 3.1710177603028669, 0.89889614440674337, -2.2886004815188357, 1.702012978121096, 4.501966617756743, 2.7604717182075729, 1.464197678775975, 3.2423975333432735, 2.4456140462445228, -2.6194096508747915, -0.48522225813949987, -0.81480133741353988, -2.437915635187661, -0.38070160976738948, -0.37437069612781404, -3.457970322215743, 2.8601827228585246, -2.1531638139011613, 0.69793695546658585, -5.4538733571294955, 2.1283300515514125, -2.1952092780404264, -1.6864938109760228, -3.1592414118010841, 2.1594655997466594, -0.85655183347563735, -3.4240038763651772, -0.96219167479079315, 1.243945040781179, -1.3246259751700729, 4.2001710057916917, -4.4191142612977643, 2.7158328790974045, 1.9002093649851834, 0.82679502198390009],
                             [-3.9794993109625461, -0.90480559615860467, 1.2591386233535604, -1.267392697053064, -3.720470547197539, 1.7355145917553654, 0.045794982506720233, 0.85972459015126945, -1.5600040595836595, -1.8360291846322196, -0.07664779445530634, -0.78725405550633942, -2.5279162951903067, 1.722365112227477, 0.051286969883236652, -0.18630405938478867, -2.415385391900251, -1.9532844971745495, -1.8998631178560641, 3.1414198820001373, 0.89351218700642532, -0.65819721911358775, 2.1270553821247078, 0.19710100220495169, 0.97166130205677981, -3.2858367776577682, 2.5404439757950525, 1.3365289340730375, -1.8383346254168822, -1.5684177813415487, -0.25807648046559772, 1.694277599654151, -2.4515932041727138, -2.9027645998923179, -2.0615008095540435, -1.9153638650416744, 1.1790338458337382, -0.27147525913525883, -2.0979160014532936, -0.80682422985298297, 2.875469630397065, -1.6206516338640204, 1.5444088978850641, -1.0429407378613496, -0.80652118223002267, 1.0633707692732874, -0.27037466745407707, 1.0862153056600423, 0.78075270352638471, -3.6396846276601225],
                             [-1.882141159038677, -0.13774866833950974, -2.1367458445923257, 2.3807961207930775, 0.48534969528293803, -3.1066542134066415, -1.9515757922222621, -2.2637288090707881, 2.0663613757335018, 1.3261297097985727, 1.6414155773397421, -1.0695044439361281, -1.5189453018233074, -4.078361436841571, 1.1859004623609368, -2.4015562511124284, -0.30528118662445464, 2.6059839468521875, 1.302251199411977, 1.6403419474849179, -0.81242967128734167, -1.5257124500981296, 2.5432437622053858, -1.9956420303165971, -2.8602908327840892, 0.42297366424311483, -0.54106999269297085, 1.1178855146901958, -0.63016657366336304, 2.0605036888011452, 2.0198491202187303, 0.18405721727829955, 0.9304798476163445, 1.9272199319653875, 0.90029050429849578, 0.64604254216471979, 1.22318430669266, 0.78377944091370777, 0.13013157366339689, -1.3892892946536204, -0.33115349954082857, 1.6104994967661059, 1.5637525649013864, 0.43250027397725754, 2.186614630647711, -1.0556426166935802, 2.3165258420595327, 0.20982884391928233, 0.29829456040440205, 2.0404795428916218],
                             [-1.5182838705468582, 0.31280941446102661, -0.99405510607729497, -2.6254709763684962, -0.14324999974845012, 2.5011453592209714, 1.4393311503374338, 1.3526935222829526, 0.82927584935645737, -1.3544258793488402, -1.2489557764378907, -4.5601961359448717, 0.24672132269561114, -0.24245854557477875, -0.68037098623106029, -1.0697206538990016, -2.9366046839127469, 0.32920960801091143, -0.98318073299394071, 0.22482131750241069, -1.6653752228122198, -0.72506387866462929, -0.22774903097727328, -1.8134957879244928, 1.4115455596524993, -1.9760397545769672, 0.8914398265137663, 0.97026360969814807, -0.57374591665627483, -1.9079902805244282, -0.85948845312609101, 1.2816803932673202, -1.0895039489889884, 0.92981511232350922, -0.91208648154292637, -0.58941956649769289, 2.4750276829888156, -0.87991318664684504, 0.96766658594315569, -3.7178601435800083, 2.4429696537639756, -0.43882567904086134, 2.2991179433099305, -1.8049342233528545, -2.5794078916410976, 0.21995738670578735, -1.6917488081391281, 0.13006567617785481, -1.0853014615230225, 0.066124623884292452],
                             [-1.0585431664188785, -2.0458641477151529, -0.42913981904502235, -1.8352714793292151, 2.5061033920337339, 1.9043664233411319, 1.5532565092081894, -0.72649939909872185, 2.0921182490166017, -2.2418630984521175, 0.57779912152270296, 1.9305684822358709, -0.60610008206351185, 1.5571779498251301, -0.50599184376566131, 3.1838107793199097, -0.77040448267793649, -2.2899935661455544, -0.056022727782019749, -3.8267182092661325, 0.62978876992299182, -1.5269220974235993, -1.0288857342910012, 3.2598021600622968, 0.22099524178473343, 1.8249223985997844, -2.9607255461683519, -4.942532580775608, -4.7457648747080912, -0.10473858947320125, -0.68249907037548196, -1.3703005119090621, 0.099471282889459833, -2.1049641221847768, -1.433234401788412, 1.7521926509239203, 1.7196403658032153, -1.3425278505564304, 1.0740358581014091, -0.25033744804046532, -0.54797728153573488, -0.34552246631261341, -1.204758475438156, -0.30334588333400214, -3.3041127621276245, 2.2473781228884162, 1.5070578419745999, 1.0564386878585068, 0.039593364433688362, -0.20882391526773167],
                             [-1.5503702577956906, -0.50310011003551358, 2.7661229477017164, 1.8738602855339965, -0.51096332407673406, -2.8188821965267503, 3.8029561209624125, 0.048440800098452141, 0.8228332731562088, -2.2363787123021717, 1.031178099101808, -0.28790464053230214, 1.2091408289730383, 1.2018783638703108, -4.3735939396437598, -1.1026801479413104, -2.0164592184148962, 3.3095231568883561, 1.5875217868762743, -1.2047531758630834, -0.51702745466638078, -0.36682280702771886, 0.70907956953549933, 0.50795414039833531, 1.225281099189262, 2.5393256994529705, -2.0997741762222919, 1.2781701623537089, -0.30469418700987394, -1.5890045042237759, 0.77115475105879683, 0.51776907605238609, 1.4446450101155588, -0.26649814822079965, -0.834724280560323, 1.1614314103841101, 0.19546502824546055, 2.7081516109683701, -0.4538419149514637, 0.32647604568729244, -0.59230707942802419, 3.5927527663748466, -1.3961435356165928, -0.3870012838777358, 1.8981469873723269, -1.244321547759434, 0.35148332157499645, -2.3400478020133884, 3.1437501137956381, -0.61303890014998086],
                             [-0.62302493808717407, 0.91139659018621788, -0.37712290163523432, -1.5151202561648607, 0.80027537716508057, 2.4055172596955194, -0.4673526808297892, 0.46106297059924639, -0.56390044346398838, -1.5089213848723873, -0.86159582491942777, 0.71183070453983865, -0.67821286926648072, -0.95474176373367303, 1.8285743613045342, 1.6686882709674846, -0.82392490621767822, -3.0992466479661709, -0.82679969473264614, -1.8213723105110833, -0.48720027515225162, 1.1038015202775264, -1.4436747281436855, -0.83351082152012912, 1.146697791417832, -2.2771841179561445, 3.3114867897873377, 0.54774578973077148, -0.76908944568903237, -0.58830343573459065, 1.2351705082260389, 0.78197924527576879, -0.51587279687196608, -0.67728102257816003, 2.4231755266148207, 2.0641333007717582, 0.81250463498714298, 0.45444792036739368, 1.7485342897884595, -2.214419729174931, -1.4151787982912867, 0.6142359230281389, -0.05813308345130079, 2.8693591176653697, 0.58641520036032246, 0.54486390774594229, 0.56623227693922484, 0.42355435664673541, -0.6302836812934246, -1.0801867514756014],
                             [1.712283871747603, -0.25608502923610382, 0.91823210296612234, -2.1998251740222092, -2.3703163527104665, -0.45339857527182192, 1.8151443425908269, 0.32577827234382178, -2.6919237428209688, 0.62290904563654037, -2.0179298032299484, 1.1739642480429804, -3.3144115875052322, -0.028449075006791811, 1.1247033289144994, 1.8722979835668958, -0.14528410784893084, 2.5948955662891016, 1.2666783149942042, 4.5192433322152041, 2.0614735906853658, 0.74950374149053722, -0.52011467997517014, 0.045438979359108587, -0.45097980089871753, -0.75418364798149118, 4.8533648955031978, -3.1011389315975464, 3.0749240045545161, -3.0356136675483927, 1.3611924055147355, 0.36841897743880009, -1.5144635870824699, 0.28682029214193866, 1.2805378841992245, -2.7022466048072076, -0.44382796028242449, 2.6335823336723814, -1.3305529391607533, 3.0754679342792266, 2.1170679946714919, -2.8924529862957682, 0.40244908000189195, -0.35590299730263403, -0.86810293307452457, 3.7573720826396664, 2.3850904476042061, 1.41400968849773, -2.6361238573504311, -2.2916775675779291],
                             [-4.4337163766983876, 0.44966623478188766, -2.3092162214571461, 1.6105201542661609, 0.084845019943047009, 1.4472816690855403, -0.028131312479351342, -0.14051018249628319, 0.18503872037033986, 1.289817307547886, -0.34851269801066181, -0.95778757153469785, -1.0271519905991711, 2.441853061469677, 2.1380307487061869, -1.1801713822832849, -0.11861287868579636, -0.095261751843567263, -0.42295350579774921, -0.2456093926987033, -1.7384849906833253, 1.8635091427140102, 1.4158391337844338, -1.3708437519561343, 2.587837952510029, 0.28431256591556642, 3.6543663490388929, 0.8692338119943217, -2.2648809801794942, 0.21905941290044892, 1.2831913564988955, -2.8598863834458736, -0.11826960282772489, -0.2621613347880089, 2.077066805610063, 1.1253685066290684, 1.6277596022921679, -0.023828609186005, 2.6039200221779883, -1.5069149710869116, 0.58158300111869665, 1.2582526261643343, 2.1687331651468043, -1.5764906685613735, 1.0233822909837651, -1.4840947515342156, 3.128004173726024, -1.4211073447622582, -2.4538192465907662, 1.0792468105783235],
                             [-1.3991053003355647, 1.4828842823837305, -1.2827659745842943, -0.82286945298538361, 0.21387874210280322, -0.55117952009661686, -1.9711881409290897, 0.45683218239914442, 1.4658884940849257, -1.5152435453335011, -0.71669702327100016, 0.55588666174774515, -2.6233423006044734, 0.59669393820198602, -3.1041908753615206, 1.1202551908768583, -0.42465666882747233, 0.51874560425972061, 0.50028952030486162, 1.1776418128638493, 0.53912495277320371, -1.8420774512675608, -1.4517991798019723, -0.6021757680531834, -0.21515063275026111, 0.72913931539505927, -3.1066755131425654, -2.577561059290197, -0.82764203351440813, -0.80773132555631943, -0.72676728041909189, -1.5257927322619211, 0.014272944823606273, 3.3442162687632266, 0.62464667770427473, -0.70277707890762897, 0.29853370003509183, -1.4607866473467424, 0.44884967374692697, 0.44921746595827056, -1.2462080286896176, 1.2349733124199624, -0.25400308221511098, -2.4621801083984352, -2.9820913631491961, 2.1097740393132658, 1.7016541417059983, 1.6093805662584661, -1.5099192480314945, 0.99355192872422549],
                             [-2.8419113929678117, 0.052697114465723005, 1.055096375015488, -1.3638615714303248, -0.41252031472039175, 0.6133611350472945, 2.3517179378930524, 1.1479450168111338, -0.10460166122617356, 0.53981543662532416, -0.91794982212178, 4.0196155319971076, -3.1449186470549026, -1.514670736736508, 0.92090629565780957, 1.8488330731402107, -0.58719265640817031, 1.6766374195290352, 1.0288493565889636, -0.6040008570924349, -2.2817161104058981, -0.42453113459148895, -0.255788490434053, -0.13063204157896538, 2.2791727630022613, -0.87607587066213566, -0.88465184985145684, -2.6765251904603362, 0.49681941652760642, -0.634336976870568, 2.5476129955269564, -0.86929175155797267, -3.0119881815663758, -0.015509543202621386, 1.2865805219668158, -0.2574173681569078, 0.54715512778568642, 2.258346225436374, -1.161149118599571, 1.4873577703592415, 0.26745230943491022, -0.41672327662923525, 3.2789810833125705, -0.16543336761028321, -2.3350902527350477, 0.86485093349277831, -0.57032476530516829, -1.9223721149807345, 1.2596016142195314, 0.35705218580549075],
                             [1.3916904183441516, 1.3586722801076581, 0.59044542993810589, -0.27733243428397203, -2.1324531469582615, 1.3684708843595188, -2.673828585754173, -1.4063793370780038, -1.2726428891127641, -0.15878537296896036, -0.57721171985404918, -2.9952015030110406, -2.0873177078989023, -2.938968987872113, -0.21521298110349726, -0.97682547343073356, 0.61455500419774778, 0.60839296701947509, 0.64565901608874754, 2.4726499412449434, 0.34695160141034681, 0.041716614818362821, -1.002271377621526, -1.2711063291839233, -0.9911507720733691, -1.2235268242391957, -1.0895706772090306, 0.29835268785484337, 0.24161129359787381, -1.0495766883198723, 0.86855918049962377, 3.2137380081259534, 1.4718584974750939, -0.45402436698786336, 1.3489009188918948, -0.86771637645865907, 0.79496932993231795, 0.66525063030130849, -1.7236649440245322, 0.39905955201202448, 1.1939835104702379, -2.1000152651708497, 1.082396357987832, -1.5986430899055821, -1.5129841005933551, 0.11228719734005124, -0.97306907172512025, -0.18541926607575232, 0.12317253792676428, 0.042604983006221453],
                             [-0.85755148505919221, -3.0554853238707835, -0.72742715708450822, 2.877995429990269, -0.14208712290791892, -0.65557859166773547, 2.1146021090714853, -1.8310182237466586, 2.3031295611521618, 4.5661363044427778, -0.11558967366687375, 1.8588464778011964, -0.52673452200285797, -0.43713139079045144, 0.74323989464676998, -0.90520766621980708, 2.230595584901188, 1.9820449488236214, -0.41093180313433436, 1.2514197448581261, -0.53975873899718707, 2.1632713448842806, 1.5141754703464554, -0.18144542268537436, -2.1420037582739644, -1.1764538720136155, 4.2868538041067614, 1.8300341159661284, -2.0018058688753255, 1.5213126044139822, -1.7600489588933703, -2.890190419676411, 0.95584846815009628, 0.53832227634346919, -0.82811304965876686, -0.43109201397032576, -1.8828744042536021, 1.4129402844543022, -0.66035119732821013, 1.5352324145029281, 0.88109860630708692, 3.7478413423957826, 1.5025532442145626, -1.6440221444336671, 6.5441454357170441, 0.9607225971458514, 2.7483616753516436, -2.8123396632954192, -0.54855316619294503, 1.5586328263926723],
                             [1.8444112891138351, -3.1719508299274475, 1.768094650990649, -0.83351256630300152, 1.3302926813237741, 1.9632980892881771, -0.017073395204352072, 1.3134770292889895, -0.44153561483042247, -1.7591982558969483, 2.4696333842146134, 0.56562264302610687, 1.7170615278514838, -1.1167133001945846, -1.1780389406001901, -4.1474930579657547, 1.8680067515960577, -1.2222073341868838, 0.40533482214755784, 0.83726499099294771, 0.44408637786770122, 0.095087888824206393, 0.87165938483410443, -0.70281530313144791, -1.1488068908448474, 1.0032666718097201, -1.5797273938520215, 0.74884919776782399, -0.76891431798739962, -0.23510349456789054, 0.75314647623120523, -0.80025733922042208, -0.52507971162701805, 1.3936184829573286, 0.023773197820607564, 3.1016052383991735, 1.6489667543925708, -2.2381779484152799, 0.087376233815350687, -0.65203573053375585, -1.7151165952327996, 2.8544140703697418, -0.46912178925679526, 1.2177050010563946, 0.042226227587212187, -1.6320264034390015, 1.5826607280293261, -2.6460239890827575, -1.7532988397278724, 0.16768406726851334],
                             [3.8579580480246438, -2.4107061938010346, 0.62195392053944176, -0.41493247096936781, 1.3066300208311785, 1.0084118594589568, 0.40025502147561748, 0.47715743999050686, 1.0660750053213832, 0.20206929965715736, -1.5739026946000902, -1.6280085862765694, 2.8095500259608555, 0.10075635356370855, -3.2285784993815891, 0.56921890217686677, 2.248172301497708, -1.6055305569933687, 0.68951833656815931, -0.87316603652406222, 0.25943503225183623, 0.10740282817895699, -4.7048717510161495, 1.0455723132570078, 0.068179863076722372, 2.0174110373214091, 3.9431612331296289, 0.99581053783159801, -0.7388552799594732, -0.66794492500011993, -0.24116183377812916, -1.9432338344820204, -3.6490554445685821, 0.032039510618323497, -1.1175917617168012, 2.4261132985638367, -2.3022141907978195, -2.3934480764609454, 1.7339274803860572, -3.1025118406814882, -0.41017110940851653, 2.3444806472488251, -0.75824969079426996, -1.2959709894236999, -2.3017381781622106, -0.36287924103696451, 1.6916848825129827, -2.1563989852069771, -1.3311674571974501, 2.3448738827208357],
                             [2.0123475523782108, -1.9011790545776419, -2.9986626020435763, -1.5938910709327665, 2.7030726443637176, 3.5515057580703537, -4.6043553475690375, 2.2138261519757063, 0.66957261762550124, -0.67513016678276627, 0.31446321244520575, 2.2321117647900475, 2.4553351201770681, -1.955501339356406, 3.7533489499918593, -2.7020552325633322, -0.40567349738454056, -4.2715758823364762, -0.92181623881041586, -1.3363327468786232, 2.2069048346850568, 1.5207600582626439, 1.3861709911048625, 1.0966711210953144, -3.8242582069312618, -0.47625808214630938, -0.44344326955481067, 1.6216616552239502, 0.88409282832237746, 2.6711269402184881, -0.49564988567813106, -1.4877848934377602, -2.5169616223181817, -0.74653900645832516, -3.4727189885358323, 1.2049646196799404, -1.2031679697675579, -5.4066501640521887, 1.7843469645146179, -2.2982489651121942, -3.6816582586122388, 0.33386670993630702, -0.76873277854060718, 2.2743270973328173, 0.8575482706223172, 0.5219739793681053, 0.659551770090264, 0.80561840325273171, -0.31819025015191366, 0.42746978397857321],
                             [4.3522813941044882, -0.40347643224328295, 3.2500073811058958, 0.55349988115993443, -1.229059954506599, 1.7277491339170949, -2.0671375209826914, -0.098431616710661238, -1.291686588907188, -1.421582048205742, 4.5643936700803245, -2.8188685081986735, 2.2246409792703408, 2.8518652757498182, 2.109474982397388, -0.40007882609952816, 2.2954058476211752, -1.9460728009805568, -2.3792005360371395, 0.39522052147174558, -1.0126208947736097, 4.0144518462336016, -1.4867176742113246, -2.187979463919711, 0.012494718161233714, 2.6240960906825466, 0.58022257120558618, 2.3979088782366018, 1.2468240926501974, -0.24635113176201048, -0.32087920778783691, -1.3429569761966127, -3.0468685093670644, 1.9745022280846698, -1.8075248555284305, -0.41234713137635426, 0.75129492415582722, -3.677532640336274, -0.99855000271773275, -0.40889564822596125, 2.5122822850243232, -0.056511773938435733, 1.3660161162022872, 0.32140811057346097, -1.075064988812042, -2.7838800696135086, 0.047612638807872851, 4.1279992970138819, -4.3926426742871785, 0.91547435522826892],
                             [1.846966942065539, -1.523296856598638, 1.4992259328808546, 0.31379940027530734, 0.38808388622914824, -0.71364998298855253, -1.1576312790185961, -0.22173789332802499, 0.071538537812580627, 1.0258444040546255, 3.1960044125588025, -1.8939694391056612, 1.2695969022601974, 2.7084312904534884, -2.844898468793609, 0.3720001448438226, 0.62755918842176683, -1.6237132232171474, 2.0799385085619693, 0.30061653558527607, -0.83003601566267649, -0.57791961816008386, -1.2121199719616995, -1.9289307223674979, 0.9350817215302194, -0.88276854111482073, -1.76284580031258, 2.3039911236234802, 0.8571806521820704, -0.70987362659911335, -1.3453465409672285, -0.32768598468373222, -0.51364025842536531, 0.55988599631178393, 0.27558141620938115, 0.55179928004598056, -1.3592680215313753, 2.0348934873019333, -0.075669102694729748, 0.46472221739760394, 0.43060425588867596, 1.2718515786021076, -1.8898167623201247, 0.019218106457967187, 1.6883587465134371, -1.4574615607729207, 1.1987383527651272, -0.6844096438238253, 2.0401441097477684, -0.022516817075068443],
                             [1.3940792266783435, -0.056968210042455079, 0.91730867593362575, -2.3201646217874816, 0.092737005609965145, 0.51386531311152139, 1.058769598083432, -0.53440817577218458, 1.3912584730851463, -0.34983927601081172, -1.3219702499196162, -1.2545116630405262, 0.20591638619257557, 0.66710325672441861, -2.2758233718676202, 1.5311831090195711, 0.3103562479319924, 0.3116552995889797, 0.37359051357611367, -0.45410335708120697, 0.16075493341003191, -1.3151266918807161, -1.8997772231620396, 1.4350480466529207, 0.88383951624239154, 2.4676192462401398, -2.7598923080501661, 0.52970095021791952, 1.1189395172553591, -0.30863783980665177, 0.097091800412503787, 2.1586627695308858, 1.040908026113073, 0.60583350030429794, -0.16626663715853895, -0.16025175285092491, -1.3638492438619672, -0.50435821596765495, -3.513953758966331, -1.0077339955903095, 0.14686234314100705, 0.82746125201316589, -0.024766686909650133, -3.2874380400621068, -1.1048051839341495, 0.80387272253936704, -0.065564164767016403, 1.3802215224542969, 1.1810148975647849, -0.093321904383420126],
                             [3.3124272336764937, 1.0175246418241506, -2.2281990622270542, 0.61289781989973013, 0.95510874924203781, -0.52793799727437096, -2.3287974342291493, 0.94019349802763719, 0.67156510860695307, 1.8612798848975247, -1.3322404924320299, 1.1152696132056499, 0.48888762124828444, 1.168306124201739, 0.24082805310545896, 1.2392793579365542, -0.7080740476823737, 0.85325086145582518, 1.9438476727822256, -0.52971570210569829, 0.36052794382428976, 1.4200886280971587, -2.3157225306556768, -1.0269233867704375, 1.4396607491658644, 1.1748524834225154, 2.604677284296621, -1.1758634866228765, 3.6222579876261976, 2.6412527584594363, -2.5378195701685637, 0.26472531617616468, -3.9298077850735158, 2.6753452578540249, -3.1474342853372472, -0.82145994465895389, -1.4278289817419647, -0.68248147915723434, 2.0949105770800078, 2.1128738527110711, 1.1467308773587579, -1.8691427247975607, 0.74122001988356023, 2.4615769302748052, 0.12877226044385215, -0.40183603569329085, -1.1858515049781426, 3.175709539401772, -0.55383822834956054, 2.412703967620184]],
                            [[-0.038978415058708207, -0.24029050981902, 0.072433710674202345, -1.0448725773811398, -1.1573728663834706, -0.026315581545303533, 0.39249651460429347, -0.28430352375871909, -0.095706650017923847, -0.61772417326062767, 0.11892956677320561, -0.38327194704622197, 0.23746235826140683, 1.215799578900479, -1.8481191440423088, 0.22241234486047282, 0.87245811283737229, 0.72924321998494801, -0.4842883412041063, 1.2867612525461347, -0.65000344496203588, 0.48933290635978816, 2.0389522647268268, -0.00053668837944343545, -0.42949160019478649, 1.1434943919147122, 0.56461864224193892, -0.0013108500293037874, 1.0381751038684568, -0.012242311828116897, 0.56159368653230235, 0.27250485388592788, 0.79405664686463606, 0.61654321774699528, -0.16193784710699721, -1.3387593378315756, -0.78035270944886936, 0.82995068355658752, 0.49352864665654167, -0.36147400548789954, -0.97707284754172774, 0.51992410000913591, -0.44748588807839934, 0.36744243217746686, 0.13644405609186985, -1.4878172462758457, 0.53196708121088965, -0.8597211508603555, -0.15266093048398952, -0.96747653340533213],
                             [-0.85295975907523847, -1.7842109386916003, -0.87089365365482374, -0.17979117320996246, -0.3174762272074857, 1.1803367229412807, -0.23579316448587392, -0.62194619895856418, -0.69894159256184984, -0.65147567110242366, -0.55728271390515083, 0.089201217921308154, 0.029157705337035607, -1.8367681455144478, -1.5026576429590637, -0.2304973139624181, 0.060138998512909894, -1.1122642200679362, -1.0536555436450377, 1.303148788393856, -2.1394579427896252, -0.13732364411069026, -1.0554868749891337, 0.45677188756933484, -0.18189983762799286, 0.48744410873413302, 0.26211363178431291, 0.70291738604715537, -1.231199791690913, -0.6936671319983494, -1.0539517577291821, -0.91686413389713373, 0.3791617078690705, -0.54896684642563798, 0.7565809440306468, -0.38143921374784751, -0.12791723211152883, -0.40706636159019349, -0.51810754873221021, 0.8185169048781179, 0.46960876339388175, 0.18966208130050966, -0.65689858074206686, -0.060830504383187378, 0.532696550792222, -0.34353201299417502, -0.051637051628302545, -0.70954156587459305, -0.013301839739023106, -0.30894409276077434],
                             [0.17434936350859398, -0.76718370576155737, 0.066076571722182287, -1.1441411989006365, 0.64475183580065121, -1.8117367382723417, 0.8826126279467793, -1.4058966626156486, -1.1375415898782124, 0.62743874192688365, 0.91990578498564601, 1.1813503561137877, 0.54809453460227875, 0.033431721807844511, -0.27739930613305719, 0.66298652241522738, 0.94909442500486718, 1.2122057362905059, 0.011500433926646764, -1.5140809071201093, 0.38263653889793431, 0.94360053500942731, 0.99441481101193419, -0.055503027145121342, 0.43822508086408218, -0.21174375175413512, -0.96636678673331167, -0.38217477261925548, 0.96981643227100478, 0.80681915730153442, 1.3341575295798225, 0.9582679975324514, -0.19971303998035153, 0.087720032798002973, 0.59300436908789123, 0.48608797005527549, -0.88337105445647401, 0.016061002147651566, -0.35416742744982388, -0.64536721080478865, 1.804770816581158, 0.26078049245061463, 0.31966288455140657, 0.84499576995538184, 0.64440878209481145, -0.77398099014978516, 0.91159698161415403, -0.20868601900005615, -0.074584879406485019, 1.0613113247236914],
                             [1.890594902959492, -0.20457726726337835, -1.8455429100131615, -0.37775737794893816, -0.21159306553179813, 0.16415112664860862, 0.48657737376061283, 0.00062938324111201475, 0.33576557534509449, -0.69853770666545589, -0.69597234256141571, 1.2079762133243415, -0.73014894699815558, 0.079207957105121116, 1.3710436150280993, -0.087199235337087788, -1.1293552190096212, 0.75038205136300962, -0.47654385006820998, -0.71506135937744963, 0.77333233961079928, -0.66288006184142911, 1.5602937832559496, -0.37936716031164658, -0.30178206335358776, -0.11596042213635331, 0.85933745463630351, 0.56804569503912661, -1.4065228777868546, 0.8230327078217925, -1.2100484409476406, 0.80926050695411877, -0.67619903818909699, 0.32705548268819573, -0.02261544791843012, -0.45452139631287525, 1.3232893417983171, -0.67700560271056598, 0.34665208877425707, -0.37376070225055502, 0.90564422396695232, -0.75184977570986844, -0.51500747214846643, 0.66763029455851086, 0.6714580865892319, 0.58251335047850583, 1.2114210057952193, 0.50681531090471488, -1.3470694846531381, -0.83051866033901622],
                             [-0.035889537556222983, 0.22014130394704037, 1.3447396501453381, -0.087647305816058174, 0.88413279193803773, -0.23974479544516678, 0.18590969796689089, 0.21549320132165406, 0.37762607803848103, 0.39930989246784204, -0.057786586021474934, -0.47306364094250974, -0.18835810807775935, -0.9518387248359903, 0.51719487434119649, 0.13686397922188756, 0.087179010478635521, -0.1409387534530549, -0.032274573655064177, -0.33194102313827101, 1.0369257057196433, 1.0976262683549256, 0.52531602349294515, 0.21793425161897889, -1.1109127590520038, -0.16242476598166872, 0.48185476168824271, -0.75369730989701467, -0.72148489059596954, 0.18972333254673479, -0.7700824417580503, 0.17495181577482238, 0.23224343942431186, 1.1385614749418556, 0.38152680947652107, 0.084829890213121928, -1.1063181994114151, -0.64705361595157151, -0.68157531401807603, 0.55318008017653619, 0.57550750061957323, 0.59221421491381243, 1.3417805906966347, 0.78246331834673255, 0.38537913321717893, 0.010128408781609335, -0.31016120060627717, -0.2371132412241273, 0.29998196327764853, -0.25310052321341475],
                             [-0.788376294904927, -0.75487254661486625, -0.33879394614949804, -0.57364482495404423, 0.27559525366833371, -0.9479400481142195, 0.84249771278257013, -0.048052335474978836, 1.0882612805652498, -1.193258781056963, -0.025714331770442668, -1.0280601905890645, 0.31553215488964176, -0.15623918353476607, 0.54768567515056288, 0.49961361610118299, 0.086545138777571418, 0.29364432433995141, 0.55715287262836011, 0.86323597008085828, 0.28509813355065966, -0.44422332646047608, 0.0090970910240272158, -1.0437780393223834, 0.26752182047873252, 0.93808290975323416, 0.075001696985069172, -0.49037435332997992, 0.16502912910350065, 0.73467109479869352, -0.71607934252560324, -0.31114721761618253, -0.84727652234667961, -0.48994009804448901, -0.51489017875457721, 0.93673399658839607, 0.2671268806640188, 0.35979958536154755, -0.023883119664449861, -1.5229930492755566, 0.97238149355243197, -0.11879309972347538, 0.73939769275499401, 1.2624245134265446, 0.76813565734711653, 0.37156847156665213, -0.32923579435696954, 0.59247463873276007, 0.58949529368302434, 0.45236609483539519],
                             [0.29135175715866274, 0.63783517568441783, -1.2802421211063135, 0.23179116941696223, 0.92549892555146751, 1.0718057328410742, -0.9083275233432393, 0.092393340629031664, 0.24339589510887569, 0.0071519937123957107, -0.25992860480565388, 0.64579403679359282, 0.24326813514155507, -0.36659669276970513, 0.8951012381670137, 0.65073785288846453, 0.56114376667174959, -0.73358158721339295, -1.0869749638838353, -0.83461652114328955, 0.58588892053007002, -0.27073390571611733, 0.6241730733494375, -0.39413250236763014, 0.70333758734804952, 1.4272627039534598, 0.434549249591002, -0.60065257596821087, -0.26619476629942318, -0.012271615808335693, -0.29349505409273696, 0.74297605380477472, -0.50573601244381072, -0.33754933499250156, 0.31987176894005998, 0.015255151784400987, -0.32938610325358469, -1.0938945596490932, 0.039116796491010714, -1.5634746230143599, 0.13002808083091943, -1.3342443224319169, 0.27029959075786303, 0.92736687714898569, 0.29671927152993882, -1.786593421785309, 0.32564819447343302, 0.37468780181303996, -0.39679626922242134, -0.41295702367620246],
                             [-0.8453163148448064, -0.96360936983753298, -0.12681185666055797, 1.2577448905318256, 0.75547532046817478, 1.0392334165701935, -0.92597765444875491, -0.075334150906102543, 0.45059618510308419, -0.53109894020524973, 0.28584264481448918, -1.4371601709174779, 0.70585212798615049, -0.26955244347875967, -0.2674755773573943, -0.78823563148740527, -0.69688932911542145, -1.3681560080167849, -0.27716919497584758, 0.056730021051785554, -0.14989974574368456, -0.87914529134779784, 0.50291740045054245, 1.1411857280582989, 0.45831753711545253, -0.45876502268069319, 0.45897464774006086, -0.080780668348367238, 1.9031314588875223, -0.28123810732148791, 0.97575922701613282, -0.09540271246502921, -0.17923940157672094, 0.55525290128450999, 0.95794310808428118, 0.42334829494183407, 0.10677512515311403, 1.1838957682327029, -0.26886161319932661, 0.39043844617612322, 0.79332355751218953, 0.17181972472384877, -0.64198105611562628, 0.20090145958253205, 0.81525305551576732, 0.14539501484694836, 0.0014248731179771126, 0.011853665191593222, -0.88590322763206852, -0.84982957631863931],
                             [-0.95157308848403155, 0.83864583540358006, -0.51228761876049078, 1.0246585705882638, -0.45467859167050811, 1.4198472108593059, 0.34005632948470876, -0.25333663600564627, 0.60862358281325113, -0.48506786717942452, 0.83671748142791047, -0.37037140831057441, 0.44588218885885622, -1.563391398244421, 0.49293412221607985, 0.53717652842340169, -1.0343134657679793, -0.4280878397108519, 0.12443193468273574, 0.5585337827168988, -0.025665217172441829, 1.3041403135514913, -1.0035115098276004, -0.07117286046770091, 0.024271404018179427, -0.62043481466000139, 0.44702414538885343, 0.23411445272719886, -0.097582366164623735, -1.6314167856467952, 0.45521466166500579, -0.13505724700123675, -0.58751839902975467, 0.58370387372112986, 0.0047071762448709868, -1.3424139656305305, -0.033617094374005715, -1.1521348840193404, -0.006652894756653995, -0.51793396676315817, -0.37980644408388309, -0.18513511064663421, -0.04940148613930636, -0.19841398088353634, 0.058244152709156727, -0.15699633052549264, -0.14739330283407823, -0.87226284062205772, 1.2318620625500776, -0.75489531087541661],
                             [-0.29090462350167556, 1.4736195536006764, -0.50685009858762309, 0.5349230135662727, -0.54493032831336119, 0.57423291556324152, -0.31213521690442031, -0.96674833443462393, -0.79224247803687164, 0.091165701561451581, -0.92917739432847901, -0.054227426767505402, -0.22076053344527877, -0.054108393746223962, -0.25941064836929595, 0.69119743423523894, 1.5383921138556538, 0.43945777627921584, 1.2614805474080255, 0.035407113947375946, 0.49882638826241371, -1.3088669888916953, -0.81536947509399449, -1.131784434009834, -0.28502527530549304, -0.63319006718007909, 0.48770945307404712, -0.063694571923215162, 0.43633815109727986, 1.5287708041993442, 0.45332952627391704, 0.74484340319056963, -0.11123014593785731, -1.1613932969136094, 0.17301721842111106, 0.0089199716813802947, -0.69123490279675781, 1.0755170044863103, 0.35350994612529085, 1.0974140560442918, -1.1729382762499276, -0.46940465590026825, 0.10730872341983926, -0.16072443286698265, -1.0269645567560073, -0.5426786306760949, 0.27363533825069547, -0.046462023939792742, 1.6637547221829982, -0.77395454584911283],
                             [0.11605768406896784, -0.30066184830089177, -0.51424196227307883, 0.023994532998274767, -0.37405353062605479, 0.71730032232195451, -0.53909654897064685, 0.096864955847753731, -0.61925149007108204, 0.81901571312825916, -0.053139146555939515, -0.67441606499785789, -0.7437709058969646, -0.053860644507725194, -0.53808096847188769, -0.40258675438720298, 1.2085761215020479, -0.49674285376697497, -1.0850115388551445, -0.56710732829968136, -0.33605661097895362, 2.2821973868870429, 0.69661063720824024, 0.75836102848491027, -0.66585598660120637, -0.65356641902761026, 0.60096221464311861, -0.85792205822703205, -0.31644595538109327, 0.88624302498146013, 0.38692445169348205, 0.49490255019887847, 0.088374312098006863, -0.41873427710537547, 0.61226577073983046, 0.55839059412932635, 0.70044346013166536, 0.44497545296450702, -0.5652995506469991, 0.33602998122551825, -0.5233957759316511, -1.0834444596591504, 0.58963303324879279, -0.30989489366044665, -0.19166653313182591, -1.2473016957317884, 0.075019114657447386, -0.96781407227706273, -0.3893870000819683, -0.40809330446224668],
                             [0.49012932822436106, 0.47415427971208013, -0.26692138951980143, -0.45999545273490133, 0.3994265803342601, -1.0759187903509648, 0.013571708355293078, 1.1455532953117868, 0.34595686706101364, 0.065703644142956888, -0.68435540485117941, -0.092628679794702157, -0.60928414382731044, -0.34965978519005414, 0.18236311922558904, 1.6967205655941477, -1.6511693305505497, 1.2267143081505574, 0.34199910818415186, 0.24079546793395729, 0.26126630710403004, -0.11086565051413057, 1.1429448366149721, -0.44487071685501178, -1.1902205704682391, -0.44513424688639003, -0.63058743604035028, -0.56281386768475272, 0.55959394079174674, 0.2672685993387115, 0.17662661997427745, 1.0914761152086636, 0.89537621342053364, -0.2290259948388268, -0.15274923369642354, -0.18499981376582417, -0.22139348610717485, 0.76717653508037265, -1.1703919033120893, -0.67603889661775207, -0.99889469537411535, -0.59313120574057598, -0.057937725161223065, -0.39686400628008106, -0.4497904234317488, -0.73706766586559991, -0.25838356744619284, 0.56117042603731737, -0.20175216422260078, -0.8226628734521152],
                             [0.41400781466421166, -0.67460345976030889, 1.0604464855431484, 0.30796790779118877, 1.389533702901375, 0.70564800791552396, -0.1701394893120414, 0.42650886709318769, -0.23063226524386252, 0.94119254353983539, 0.54484782085243466, -0.17843441769108126, 0.21693332549095423, 0.0037777750374118546, 0.4974940668427264, -1.1462267367739229, -0.80396352294913598, -1.0749228274582947, -0.4925445040278118, 0.55816218816704177, 0.84686225968930839, -1.0039943423222375, -0.55788343427236409, 0.23721265026133953, 0.29358862015837967, -0.098521675517700455, -0.089994817839902361, -0.61142432864298701, 0.5036959143947809, -0.93216410589211451, -0.24990090021269759, -0.46629966825491409, 0.25947809700617014, -0.37735848087699769, 0.5944890272490766, -0.459478440433782, -0.17435278554861502, -0.14760893681808096, -0.95750787957802019, 0.75136408543243793, 0.24996662309571505, -0.76572951161448599, -0.0089073803697392959, -1.2654515097882053, -0.56595624491653096, 0.17645341417403715, 0.9096119312931582, 0.63138643898201885, -0.42999949272751187, 0.51355743031337531],
                             [-0.97260741390627803, -0.69046822342160785, -1.5173596617305134, -1.0732878934771903, -0.17249012294721142, 0.39105225642397595, 0.30425586240245711, -0.31944432796270122, -1.4611969694936526, -1.3467015011365586, 0.058923838475929323, -1.5041695409970643, 0.24444429914292135, 0.21276725291124776, 0.10953240226227627, -0.35326561000873946, -1.4270232892504575, 0.83065991291936059, -0.041070068510294794, 0.34707243626797546, -0.2352878753408717, -0.98846936396606344, 0.77460214316361276, 0.52826345750124171, -0.32931167220136454, -0.39466018180504858, -0.82393949196455085, -0.63072552451296449, 0.24922714311853447, 0.173954012221918, 0.80632015491711317, 1.1189940208336981, 0.60491408289478488, -0.87235443788480138, -0.44995088733047695, -0.4261092763622919, 0.10587652968118867, 0.6868050641817377, -0.82998413583210762, 0.77887975162160594, 0.10475004056303917, -0.94007690504030816, -1.1063585157728659, -0.59973395121469841, -0.14208980600665341, 0.55131370390270584, -0.24508864474072889, 0.21562079809754409, -0.98690846942956434, 0.058030220888128682],
                             [0.13041148954830781, -0.17354178045353905, -0.14790231630876863, 0.595047914826485, -0.32335633264885555, 1.0286405047212652, -0.69716292647030242, 0.13364757980817971, 0.6576763515682541, -0.98455430554058132, 0.57914141054603574, 0.15349335802385941, -0.41231856161414832, -0.72204092193004332, 0.89469964174006433, -1.4215156814121654, 0.041907239863491763, 0.072203673531797491, -0.22684339954791291, -1.0883591062615232, 0.0029480348271716528, -0.52395690511755366, -0.78985998068434338, 0.30654434485229454, 0.87425090261862026, -0.26326563901487404, 0.59416602458618306, 1.2317820197872806, 0.032251363799667331, -0.47964818350038768, 0.61233540241724826, 0.34388304956375021, 0.11958290549351662, -0.60005182417224945, -0.28824667844827812, -0.69278485227338238, -0.32255632673792395, -1.2772026259706664, -0.12046300364663157, 0.24743179544544563, -0.19977997423921431, 0.64225323659581812, -1.2134252239126611, 0.47966328867474056, 0.99111994656345714, 0.22044085138648398, 0.24697107817969299, 0.32551417516692555, 1.1958146059951813, -0.28604783689284524],
                             [-1.150096649653773, 0.29110399775321161, 0.9237219431044783, 0.06365668696991568, -0.53623596069773671, -1.1413039583505176, 0.21822759078156184, -1.3410827398777008, 1.0046315416676797, 0.65495027212484103, -0.55805626966878619, 0.28783634603566588, 0.080600607352364045, 0.66927386428702218, -0.67127709962139503, 1.1032467372738437, -0.066397227615572096, 0.44241460352909712, 0.28268494231929636, 1.7799196117741232, -0.49765330664746305, -0.80523590017312319, -1.0002975972427639, 0.90201764717875699, -1.0476007715189868, 0.34799492934368875, -0.21031969274196116, -0.19184871898003925, -0.27514384899800293, 1.0089954807021211, 0.59632587467992704, 0.55210113170059105, 1.0713665568451205, -0.90803674838550341, 0.15190152069826113, -0.46121249242406931, 0.39163242846034529, -0.48576120159170089, -0.27125730645652857, 0.24515988128652474, -1.3494828397826861, 1.056442164753655, 0.7973747754998689, 0.3269689619184204, 0.79641145283966808, 0.61974276357901059, -1.011063733733925, 0.70091068524556499, -0.45358819957982011, -0.30020355645589025],
                             [0.35896786221654836, 0.99782088885551701, -0.22260218898994097, 0.18680416603116115, 0.39145041521375418, 0.24355494790689333, -0.24527221845420527, 0.66927546754639644, -0.3055853017033901, -0.52732546577412076, -0.76721247285760574, -0.055316729565349582, -0.9528180886619696, 0.34550836345215619, 0.79431739658238132, -1.01625317451561, 0.35898257689126223, -1.1693402767747734, -0.5513745797756967, 0.96406825174145061, -0.51592754578664901, -0.53487493709801892, 0.67713189580191591, -0.42296879277992766, -0.25260450816719843, 1.3089354135932971, 0.11087282983855359, -0.55275968286583155, 0.20857070555636367, 0.10022089123810417, 0.29928972806568571, -0.7458795130450544, -0.27601758502635643, -0.088628389370196306, 0.49418751885369966, 0.58774932260876056, -1.0847320879790514, -0.52760264256445499, -0.32209104088311719, 1.4033047768015949, 0.46869295235127945, -0.21871599525301777, -0.90142462037374549, -0.46087123294772447, 0.31396804624643998, -0.22948606675349062, 1.0077535100713213, -0.34942736389990869, -1.0674712212688202, 0.31564088885413316],
                             [0.20885279021597658, 0.98872087257125763, -0.22697183256945069, 0.31479238829862943, 0.016522964561598741, -0.90490459305134296, -0.52144477226175567, 0.01503794060886489, 0.53190521874260965, -0.041608084790118474, -0.66860734024167623, -0.12848913421875871, 0.5355735763884939, 0.25657609719240637, 0.73188627458587063, 0.44386499492219611, -1.0648151625007702, -0.80824974167993979, 0.60656081027650266, -1.4308684136490697, 0.18818600334661781, 0.53829278313554574, -0.47803768682981046, -0.58930020665685012, 0.5394801885771322, 0.10545067820328377, 1.1063320202824394, -0.28604148518981737, -0.247584320414168, -0.76623812105020017, 0.43077146639661562, -0.55263532288172268, -0.34151934406844214, 0.7775825613491506, 0.77271159243487708, -0.34092971067888678, -1.0633000233497241, 0.45970406230715283, 0.18758895790294325, -0.12891138602557206, -1.3922117974741557, 0.61778795059429381, -1.0534053229869571, 1.1101347159641564, 0.98203484948466391, 1.4055586532708726, 0.22447039126814319, 0.54830890467116122, 1.099624002482545, -0.83967269819710766],
                             [-0.29453209462808938, -0.50721310618441773, 0.44347149676700531, 0.55551256275056082, -0.099530611082259746, -0.11801471060213375, -0.89546025912265836, 0.37692622658895425, -0.35574357557353864, 0.22853355935454178, -0.33829011909161028, -1.5125934785038211, -1.5959858307342567, -0.45840763624820507, -1.0539757517779711, -1.3186928054597806, 0.073015497704794763, 0.84944610168144097, -0.77242366748622893, 0.86838248758633008, 1.2246497975541393, -0.83877831938656011, 0.9824318442802682, -0.00021700613208489733, -1.3251122946639362, 0.69828175906879475, 0.13433590147071664, 0.036832691868022689, 1.5669850094193249, 0.19629727095613828, -0.68734602341980167, 0.35977712916354987, -0.99339120215143017, 0.1223632849873038, 0.46276270105227163, 0.56588066169123341, 0.58994610165958494, -0.31880758780103702, 0.10238293805784565, -0.94727454983518711, -1.1730250462142295, 0.58061882749077864, 0.55587873330181425, 0.49095523628301846, 0.28369140560143163, 0.41560810340854704, -0.87741444779511568, 0.016498645614975424, -0.20115667589454925, -0.87793457973206901],
                             [-2.2885679395877556, -0.76821782257437643, 0.51544019311841549, 0.030241489098111946, -0.70128791211747932, -0.45890409606210786, 0.32133087001225613, 1.2954505011899276, 0.88757851388785436, 0.05313855628968521, -0.016667189093526904, -0.38303338010835286, -1.3530049917034999, -0.34795736157074225, -0.92374562424815709, 0.11688260715996851, 0.62681941915389772, 0.27419416463469015, 0.61398270604219052, 0.90661286243055317, -0.53386236413492072, 0.17034482669779955, 0.92570140445818905, 0.48371992242590178, -0.74347064155172238, 2.9343035090348257, -0.20054510359227026, 0.1314802014894757, -0.30096669025067185, -0.25924361819137509, 0.42141812016891383, 0.433170411759496, -0.031950637196792066, 0.039087883540774665, 0.3411426822629654, 0.56611791483315521, -0.083714276238854329, -0.041208911472832142, 0.048082372134854813, -1.3353159307117377, -2.0112297438599209, 0.13026812926324258, -1.0197789069668968, 0.60988134735885047, 0.44220096993615565, 0.26394031201801432, 2.5076008664182714, 0.11402903354930177, -0.23131724803046139, -0.068371067111271541],
                             [1.0711391281479985, -0.19175005999922401, -0.12263953915287995, -1.2942029970795308, 0.71356632222607863, -0.17485221284829125, -1.2062589580509804, 0.046364979023345146, -1.0128578107092625, -1.39902584371973, 1.0501899910551544, 0.05549551753310665, 0.023979337980413795, 0.15847307669217975, 0.47921200113258089, -1.5277318371874551, 0.82209951650553514, 0.70375892113278971, -0.57445720250043175, 0.08320928973080273, 0.83912530199799384, -1.1188470045168954, 0.46586926166411102, 1.5749198345591888, 1.5353451511505696, -0.37086145765666634, -1.4399430844824594, -0.20539067541265299, 0.8986049428393057, -0.12355628401626123, -1.2317108141222195, -0.3289262993444666, -0.25508274312671958, 0.44105877911292929, 0.51083797747793969, -0.13112731140874551, 0.7091492534739493, 0.98835282352179676, 1.2711077530726642, -0.86921804085361132, 0.4101429952666989, 1.0961865050947399, 0.3894052024786433, 0.64209692703326293, -0.31330316327835328, -0.24726632725454206, 0.26520018148922475, 0.032067306007466538, -0.1007978050254643, -1.0884925853025942],
                             [0.937240587180867, 0.8962638127833229, -0.77035407979217319, 0.55498196296227864, 0.04032744164737391, 0.39336642172659164, 0.41211562529618151, -0.57609139102290619, -0.26231402113583568, -0.70874111214164937, -0.069278166478036113, 0.28255691988175807, 0.11544370094925607, 0.38032680034749849, 1.3902632752414248, -0.27663393875454823, 0.64222266953157892, -0.044005197819601952, 0.56931800357909479, 0.0050150481165056517, -0.16438134470179583, -0.32354050992952144, -0.14192259256700102, 0.036706553049484433, 0.15311665031705216, -0.19513582020283435, 0.43458493550332605, 0.14313965256949232, -0.0022844656609737855, 0.01661994343161876, -0.16344084337847864, 1.2004676893935713, 0.8922481209482942, 1.0441521070876449, -0.52003243945734845, -1.5331770178506108, 0.16648604518536542, 0.75157210056257184, -0.95508474003081867, 0.011282453494085812, -0.89517967915325303, 1.1612761376027803, -1.3438831942367309, 0.60224308443639685, 0.66815234068936047, -0.38197526101762674, -0.25655812050589227, 0.38287968539061318, -1.5603822025380654, -0.41868266327577008],
                             [-0.98394405803525087, -1.7013054778334915, -1.5416937179889294, -1.45550988902029, 1.0719698592883298, 0.9630072266202101, -0.31286145761669787, 0.072542996255524517, -0.17839980930360105, 0.43978772722980969, 1.4661396741590125, 0.099800555827677676, 0.7430077639746242, -0.24289051730125855, 0.39855519684331847, 0.3811481724963226, 0.34408695668439965, 0.094591677311504488, 0.56205167074599149, -0.72705700617100155, 0.10028338661022884, 1.0041277574914507, -0.1620127722427476, -0.10846327260330366, 1.2905269680645128, 1.0735927134416605, 0.87450919962616402, 1.2029862734676404, -0.46578806128708705, -0.16050852787446984, 1.2698658260097777, 0.34059044837622754, -0.27784474437007989, 0.74531295183365609, 0.50362115638989646, -0.14040307770278293, 0.90265728769219833, -0.23528155391797412, -0.30488955045363697, 0.52726941307626241, 0.56123477255194154, 1.0047760541615101, 0.96258475416962497, 0.081675904501752189, -0.40025867341078109, 0.53547874820444785, 0.17946934114482099, -1.1748082446254593, 0.62403724524609361, -0.028380218045367625],
                             [0.071983388791019579, -0.99150432273979594, 0.86310512911956594, -0.66435770053134902, -1.208468212104221, -0.36505072996802795, 1.2780355734425113, 0.80944148444580599, 0.18754793398617275, -1.0303600388888641, 0.0799412868812997, -1.1415153814093157, -0.40532247616166228, 0.20176981749222872, 1.2139575989113045, 0.24491283511766029, -0.099803440379722538, 0.30277994219095317, 0.8288002992809369, 0.10905299691827015, -1.0964304196336359, 0.011427438057170936, -0.35407639950212366, -0.26842388367552239, -1.4823635849028267, -0.18965049278877918, 0.82578769483752223, 0.40842214553556527, 0.092903421090309468, 0.39478645109348903, 1.2153452354549241, -0.29363808114544682, 0.58137067644154883, 0.31964617384892552, -0.45096608820288342, -0.33080567018185153, -0.54588516715119095, 0.1598035127528156, 1.0032090103988305, 1.0373231873438109, -1.0445314032090214, 1.0003787493366811, -0.28499052726753982, 1.8396097950561983, -0.78209469029569367, 0.61004729509519762, -0.25981172638515754, -1.2009337581742574, 0.41501660080762143, 0.52563023121478247],
                             [-0.35426217965791945, -0.45042086226127193, 0.1217003796760657, -0.13716966008373138, 0.046484838849139856, -1.0272447223882708, 0.87568940838850884, 1.0972401367496667, 1.5500931667098041, 1.0777780879001992, 0.2261846013642706, -0.86866100613239239, 0.64556278674510892, 1.3578448279300002, 0.09308274276887972, 0.32395923526462417, -0.043154050439594485, -0.84722354286517743, -0.54264112694871203, -1.3664704907968341, 1.3195887796838468, 0.079399498454036488, 0.21646796793310097, -0.67091829958591853, -0.34439372290311665, 0.58578913494686136, -0.49767016527451957, -0.041269064271854075, -1.1996311202984711, 1.3697410217816368, 0.17078961290534383, -0.56557363013564543, 0.73640064255430682, -0.17230183595588094, 0.95861508724410593, -0.23849002077030815, 0.47490656974311019, -0.018869547867872507, -0.37816725978795407, -0.78988091905914837, 0.46198260689990506, -0.88331652970756802, -0.72635926667653938, -0.66166314126754899, 0.48895948425658553, 0.41756620509951914, 1.2928997252736958, -0.35020960816328794, 0.87517118435208252, 1.7016926586426009],
                             [0.34442769297800152, 0.59888844099908767, -1.1761066374825451, -0.60644248604604922, 0.92421844961084387, 0.28960953204496059, -1.0540057363450304, 0.60148527833669396, 0.45564556075969398, 0.26516973681695577, -0.39620559091001206, 0.58779176229737418, 0.21877368955776005, -0.20901760765187666, 1.2945606264041494, 0.71303408255305134, -0.3229711278244547, 0.85094656281160808, 0.028260340111702524, -0.64058319679359899, -0.11897032193369858, 0.71939439175764042, -0.17227743826690006, 1.0122862029318578, -1.1897281412146528, 0.26893170738614303, 1.0071774635233672, 0.52726335449116646, -0.027693494802828695, 0.25556017711825746, 1.2015003069007557, 0.44809841894523367, 0.26119583953450487, -0.93958647504463211, -0.88261836134049521, 0.15765768334386088, -0.67691043867871148, -0.36299312636545328, 0.65862127453031305, 0.33318459657592714, -0.34963895617027207, 0.030474170863162148, -0.22482745869725709, -0.59076545306218053, 0.490511924964813, -0.12874115785962417, -0.62276215115001476, -0.64886664319775111, 0.73399181050813567, -0.023327912635972146],
                             [-0.93314046364547443, 0.66876790230111127, -1.0477005790773719, -0.12603957623660852, -0.49664950457043994, 0.20124300933423891, 0.029098751007985434, 0.95429180537153491, -0.087936786999306057, -0.74572529813049793, -0.38209947767881203, -0.50442171070826625, 1.258656608494503, 0.54642838264423199, 0.96764481890571863, -0.4995645416425103, -0.84875621743219476, -1.1881089199167758, 1.4193197226700627, -0.60591005067940562, 1.105503221866764, 1.1746948722375667, 1.3851090767277998, -0.59266129801583722, 0.9635412912108704, 1.1598459022417185, 0.34481143614427984, 0.63147201847431134, 1.226748187775254, -0.14585106806034148, 0.75931827212417857, -0.91970028764385781, -0.20229963978995541, 0.12899322988615203, -0.93467220587234334, -0.59562007821608509, 0.1679499078352141, 1.3940009008177354, 0.27880768576956344, 0.0050988162712720022, 0.6362539792559363, -1.0342274623409033, -0.05161516399394081, 0.69473382964753028, 1.1531506277790378, -0.11451499993581672, 0.39718659609615103, -0.38949328972641151, 0.0094044763831879485, 0.40152738030241214],
                             [0.06155554837868104, 0.04911502303736183, 1.0574908033915345, 0.23657545224717455, -0.6848483471200999, 0.51750896160247528, 0.55016773415685805, 0.78145138554025817, -1.0082941423575795, -0.90734889216829284, 0.98452740197815547, -0.37236497706626559, -0.92533780951021471, 0.59765206764712964, 0.42072315658821596, 0.0071019428887147788, 0.38292106141459681, -1.5118030035696044, -0.89583164757503886, 0.062301703823689873, 1.0385932812873, -1.521437047702106, -0.16915209530239306, -0.96294272175100015, 0.87692450414488088, 0.28434346722724635, 0.033372888957208476, 0.16637852625074823, 0.19046944914342456, -0.11875256059471997, -0.29293875560439692, 0.43375244483017644, -0.19053147696872802, -0.61651203741386584, 0.40082745209486059, -1.2700040745243477, 0.02827574172411455, 1.0769824029047579, -0.49500394612220683, -0.099927980021686152, 0.58691657844444833, 0.34829512470611762, -0.29986427597907694, -0.39928095194604546, 0.61508039058748687, 0.83575922843157802, 0.8578547664062417, -0.39105188603758545, 1.0466912874460232, 0.10219347084346365],
                             [0.50393968425857283, 0.62950624861314508, -0.20132725568168003, 1.0177212984675046, 0.39408870455304668, -0.89615233803611327, 0.82669871008586648, -0.62223250348515657, 0.78555731980601695, 1.2303583021288507, 0.05487765380051484, 0.41883285049751101, -1.3544843253110068, 1.5421875117864585, 0.35403338421746622, 0.67411339095419898, 0.73878095292511625, -0.2274557241844905, 0.76223269059785903, 0.91236456777483355, 0.28366269609314881, -0.20931653032226971, -1.3937443576687665, -1.7433690201957008, 0.50533046397196479, -0.18924146747777806, 1.0420345657536392, -0.35829214185602798, -1.1660830367106139, 0.89177297725691418, -0.30430367524429108, -0.41669157513828575, 1.5855963225690703, -0.096304095230908077, -0.059951090568539207, -0.24647311456533519, 0.13466946516612452, -0.16657416990926366, 0.12449754759908367, -1.1651541146405346, 0.070056522825082165, 1.4744768619798778, 0.45853797366685684, -0.25854134644687238, -0.38594812445642174, -0.47914537517623057, 0.54248420901674688, -0.34214440415132497, 1.1394013885293879, 0.54206989778450965],
                             [-1.7797510552807465, -0.46799571391240946, 0.86614578301110212, -1.8005872885543621, 0.19523691008064273, 0.25752984435549453, -0.0223330982236432, 0.18503229447685332, -0.24984772624732962, 0.16758367458778384, -0.19283956847099371, 0.26503562409956616, 0.88876750358118051, -0.3570477092997289, 0.26260960458552685, 0.38563366806471983, 1.4066336479545332, -0.77278999964113437, -0.84373768894871015, 1.3709808451564531, 1.4368449513727726, -0.10728862792697029, 0.82428425164897579, 0.54497240838434113, -1.0171960872624499, 0.51123369197014457, 0.65377672516194996, -1.0184644235278635, 0.59131634245963749, -0.89865493452747569, 0.19662838886519415, -0.032437119079287507, -0.056992873651333403, 1.2325251745232115, 0.69862929242208049, 0.87188979793028742, 0.69093501838046723, 2.1716179638720683, -0.15447991212163334, 0.22837726191170504, -0.4064852665012989, 0.3096147635817918, -0.058668771708651715, 0.67753734172892233, 0.19726672248199476, -1.4037304178241106, -0.64714200756002005, 0.43816721477982534, -0.91870872318362529, 0.13643434153370698],
                             [-0.25174336742380693, 0.26523490782728282, 0.93967797339432257, 0.68856120882307192, 1.0236006212702184, -0.10333332345023248, 0.044717623443906063, -0.13341043815159168, -1.209459206078332, -0.87047228623617789, -1.6138338214351031, 0.9267017089890397, -0.5388194067613854, -1.4787178395057246, 0.88470714626211344, -0.73883110019614606, 2.5450360427873848, 0.35504036225339786, 0.61224076881264478, -0.078082890699398347, 0.058222441690209542, 0.84581526703462129, -0.81015132825172198, -1.6859035963613218, -1.9574805803681583, -0.92135806952870036, -0.42926974112472061, 0.69730795156021086, -0.36642289575553771, -0.33129832002707649, -0.6978239110596911, 0.1835110228929418, -0.078871727817078324, -1.541444478419286, 0.59480186737388996, -0.2388941461293185, -0.59845096160022926, -1.7393233470109659, 0.37498807163257747, 0.034143695651572145, 0.62528273822871439, -0.18303973819272795, 1.1286378658287266, 0.12496493568425382, 0.31033370298599994, -0.46588245439540343, 0.74201673297819826, -1.9654161800684906, 1.9350096701923669, -2.0611438743224992],
                             [-0.77336728035218971, -0.92945895598532624, -0.89847991579276432, 0.46080099965966498, -0.53864798136283942, 0.13718331910870263, 0.13005076442596544, 0.59453324034859911, 0.83503362191448238, -0.40650152190360028, 1.2751577665712714, -0.84073267393599893, -0.70883448041861663, -0.45261600499296417, -0.78931115587939871, 0.14770591058093893, -1.0081042728733711, -0.58707629939879136, -0.28596106718898778, 0.74801217778081464, -0.59058020036264225, -0.4608900036370544, -0.25868259533353394, 0.43782333545417329, 0.79305606251666438, -0.1498105133630038, 0.40509857645056652, -0.069302928909459979, -0.8738274745269442, 0.72649878215933295, 0.77900413126620838, 0.7679127405947882, -0.64975246011052612, 0.23658498261136285, -1.0536823897829581, -0.87994875026833819, -1.4448381366092962, -0.02533059540055493, 0.91514584183800773, 0.25519473396938619, -0.42778581403178667, -0.27782833537509521, -0.386634952000382, -0.17465899326504369, -0.029777470634322459, 0.59894313639041707, -1.0806006767417244, 0.28777387891061418, -0.75779383243365073, 1.067557346854856],
                             [0.27561257022029656, 0.9475711483797109, -1.4110967063594171, -0.32982222463615235, 0.0017326179757002416, -1.152068925367004, 0.59095985412357199, -0.92658796790831799, -0.014006440874186987, 0.5241640547164873, -0.18194630170237086, 0.17473865497252647, 1.3635376611472987, -0.099007362788573361, -0.63466266808719973, 1.3884736819268344, -0.42098243010291519, 0.85641436852682495, 0.54308854336874801, 0.0029043328440303074, 0.92977324811161755, -0.17207261153717518, -0.13034603063153155, -0.99102784425574564, 0.35890367687485625, 0.80279975048345409, 0.21675617242970957, 1.064070462573653, 0.14641009537384547, -0.037521050533070643, 1.6645142140763554, 0.20590265501778934, -0.6062864860714241, 0.39395863471302583, -1.3927039361759053, 1.7246133186179629, -1.1811591470135328, 0.58680701194123652, 0.7979454686918962, -0.17092590681730493, -1.2130169525261314, -0.23096315182386112, 0.75582455913124424, 0.37071527464279352, 0.62199702974057847, -0.34877101617555434, -0.76859663218929042, 0.3822778571642288, 1.7260569765940874, -0.49601614042488407],
                             [-0.043825687663074091, -0.50154054028538719, -0.2979488763181381, -0.96171484023885034, -0.14295584438789566, 0.79981555069523769, 0.46480051104691961, -0.58781236447772023, -0.15106534235975907, 0.92802696514192928, -0.26128156796890195, 0.052694608818825109, 1.5331822037623901, -0.50275387981871278, -0.51780899777687728, 0.51037675585892306, 2.1572923962638857, -1.240339722748024, 0.55024974093068491, 0.45341820373791042, 0.27180899478421222, 0.20371423371432357, -1.1963366010188836, -0.23819947715797096, -0.11036773349423555, -0.2440792544926946, 0.18613723613859534, 0.22754787853468272, 0.61195268336260633, 0.41074995218061661, -0.39603440698958908, 0.41265132772486224, 0.40913947653281968, 0.078053971966547897, -0.36915330706010258, 0.86963910427636526, 0.2140551609917643, -0.27841069687237752, 0.041175239170054043, -0.09173238752192299, 0.76419963742535846, 0.029632101111361796, 0.50865948283998674, 0.32421292516504685, 0.36029784787919084, 0.05803181963576038, -0.54209999678640597, -0.40228208934434412, 0.25684667934349303, 1.3972252340156366],
                             [0.26950873114482138, 0.12967848030600135, 1.0138788066193041, 0.59315166045744205, -0.26745986956795575, -1.8120835394384323, 0.50275975335790068, 0.28183664576182288, -0.43719506420067067, 0.20636812029073731, -0.12158425063680943, -0.56932284320811499, -1.7902627799583652, 0.18798448585740093, 0.55125325255105684, 0.48719228262489639, 0.43049531235224059, 0.52104980637672227, 0.33900943928429705, 0.7168667399326597, 1.218607650719485, -0.10547840483685129, -0.4767559285925953, -0.30547962393539962, -0.91725115102381261, 0.68451748176878657, -0.015578944431638139, -0.94384377544620712, 0.54614180914756172, 0.6844279369774543, 0.53995441877071304, 0.022547777237959622, 0.10232985207024871, -0.6356160876970578, -0.46589178543440463, -0.012051568329936278, 0.067662282426647014, 0.54832649730734229, -1.0564867079913032, 0.99321850927002941, 0.54534000339216615, -1.5673420066915018, 0.86643244312759948, 0.94453242412888894, -0.47705591546488757, 0.98493143621577739, -0.25346574129709221, 0.74610606622092612, -0.54212306078129557, 0.052284953732791267],
                             [0.57201372427145625, -0.72638678252806077, -1.9294775138827152, 1.0769892641785044, -0.28001564259133865, 0.24070190965840832, -0.67359104563293215, 0.18169897102223134, -0.55605749350327494, -1.3523316698272241, -0.75354203804914932, -1.1280348206549837, -0.029295026882706958, 0.12685693395285971, -0.015825182757047741, 0.73752121597625953, 0.20996046505390165, -0.24567622749760346, 0.77861343130432525, -0.81284282489898096, 0.37578054572925879, 1.0755042199665605, 1.3127421852407195, -0.82491654442128315, -0.26926607807565045, -1.211248537166681, 1.575348934777794, 0.021748780653167633, 1.0383549856310399, -0.49874750510092003, 0.20551462312086458, -0.6993894052353945, -0.97125284339943596, 0.21037698240064115, -1.0234227453155635, 0.54326991972048533, 0.39224992827533939, 0.041975463719190399, -0.87779668215632067, 0.20391671924378144, -1.4618543303839273, 0.64722280234242191, -0.0005783319617749692, 0.17561846922099203, -1.6897672314995014, 1.0801933634243857, -1.3143218518745927, 0.0060988356916619841, 1.2175036663925027, -0.60615988339649429],
                             [0.36518312740240316, 0.082702649845374246, -0.26330154985556531, 0.53437245822012902, -1.4591503689316943, -1.4183966900856362, -0.70440270743566635, -0.10057045213063401, -0.83585092808252348, 0.049064416969633692, -0.4929854325698842, -0.13052584593101441, -0.10223327035584817, 0.57785271379741066, -0.23609150764277195, -0.061566569644063922, 0.027299069222390733, 0.23673188786251181, 0.037429239652056683, 0.74694307096991319, -0.72346154908727844, 0.52564065686337125, 0.24504147878587534, -0.38204032659551401, -0.58358386974239795, -0.45412877565509002, -0.20643256007344712, -1.3578793888967384, -0.81781923372604226, 0.66703279533220472, -0.70146458334399542, -0.84809554168442858, -0.98633991481466898, -0.01342180179875499, -0.54187988420177691, -0.15955314382591518, -0.087270512537921618, 0.19893917830141267, -0.03094124058142516, 0.55187050988928354, 0.42487658340751067, -2.0390757551866519, 0.10991133135400513, 0.4632968231121572, -0.003967913083130551, -0.61185334162076055, -0.98032542561458602, -0.028852769303858571, -0.070695634582448708, 1.1044781002553679],
                             [-0.24644784302477243, 0.48172430810985106, -0.38590089749422674, -0.10215803256434847, -0.01305737842889718, -0.1393636118258117, -0.62504219256602522, 0.18268205237437685, 0.0029449659688698436, 0.61538920297514377, -1.0644195172921509, 0.033780860100249853, 0.11039155171982394, 1.5285542419997908, 0.6477980321760255, -0.01666533214528396, -0.58214551683669657, 0.84761582848633177, 0.57983563371154678, -1.1724973365484077, 0.14902333424998188, -0.9205328558876309, -0.69555616061055092, 0.65513961036851343, 0.37896774894276652, -0.058776035081153297, -1.9674364092410896, 0.17281742971893724, 0.5353110968120165, -0.05057347301460393, 0.28389534232896912, -1.1290736269443569, 1.0105261681926725, -0.87987890185910866, -1.4741482097550056, -1.0303397574272948, -0.46404948036329585, -0.39317701376473579, -0.73929135712628924, 0.04134845547702895, -0.37157174054398356, -0.20749333799990907, -0.051389319984362219, 0.18837490853581113, 0.82992817855275369, -0.48995059087365617, 0.39375860082700759, -1.0228877617473289, -1.2058384492431045, -0.075651586248865407],
                             [0.86633507393980946, 0.20565795273032703, 0.017469374660348251, -0.67214647916003889, 0.79184447732469299, -1.363373723243847, -0.77436096598170379, -0.37307749196189866, 0.4880833024222444, 0.86532796391780264, 1.535202812035515, 0.47078928524145752, -0.09386735163704224, 0.045179544471051721, -0.26807456702114069, -0.54776189585513235, 0.052048974985573093, -0.86768940889674162, -0.037559433445525266, -0.81232468557648196, -1.579570608579185, -0.69615790907676633, -1.2227965364483373, 0.42742791342543945, 0.47648820664256991, -0.62274131990218706, 0.65345802971464939, -0.24026747416945649, -0.070350689854266013, 1.0228635219603399, 0.3811045505679066, 0.011946678347664226, -0.19015203760619837, 0.51073224240915172, -0.43574767065868936, 0.77887246087209994, -0.33607094035784885, -0.45425584854712991, 0.58810131507419194, -0.13738439366391836, -0.02601237000275055, 0.56927385401480501, -1.4338642327671516, -0.76731523743545171, -0.65105384963739155, -1.085774138557559, 1.4245348036832355, 1.1856043236917551, -1.4847401955519448, 0.99924855954797775],
                             [-0.42648479415206697, -0.41637907914309441, -0.97415653819268144, 0.49345148957567558, 0.64712917633629186, -0.59606953766007564, -0.54986907034044585, 0.77207902100907277, -0.26341165805484679, -1.0850155502716408, -1.1450367542762641, -0.47929029415917007, 0.18579230454336787, -0.60282815624209241, 0.60263939162230329, 0.30115500325730493, -0.12259062113282951, -0.0068079690538981781, -0.22352593746334268, -0.15961206447602558, -0.75804837551214499, -1.4444481562895133, -0.37607584307559411, 0.97833315501200502, -0.90598134150571796, -0.59229296333060855, -0.18238452484843265, -1.2316840158964717, 1.0804720730499655, -0.31281878777640826, -0.23133982341675668, -0.23344526787462638, 0.51987938234572928, 0.55379775738031678, 0.47932888962460402, -0.36234520716787555, -0.33962188387503234, 0.53129886940356863, -0.071628950532444807, 0.6837404125463441, -0.30210719301659877, 0.7339951524526529, -0.00024835595015646264, -0.30287912575906389, 0.76199766734309959, 0.71097566411119395, -0.030695927227198404, 0.63873987145448607, -0.078742052054789277, -0.24654856662307745],
                             [-0.17924849287366532, 0.238751018001846, 0.11868223248614959, 1.5177191423638412, 0.96730377089945929, -0.82945846558301806, -1.0725829809393868, -0.091702921409340499, 0.8449507096052904, 1.1533883923070813, 1.838869922712516, 0.40771409169145845, -0.38905957882963677, -0.63881296179888114, 1.0095561069485985, 0.93719896906080002, 0.63499436457448954, -0.39833789978126743, 0.13488772134266661, -0.808014302565634, -2.1517442549764922, 2.1704799675055915, -0.019570275002458021, -0.17279321422635283, -0.13275688909932548, 0.31426221290063466, 0.51009264213326044, 0.62732507331757292, -0.93799939881414884, -2.2614326323901035, -0.27795259389215426, -0.73694946690730423, 0.94337589881339379, 0.20492350854980884, -0.042006009808621049, -0.05161881995078859, -0.18454774702775525, -0.21561585334115174, -1.7737793464132097, 0.25518903148571082, -0.62925831076314831, 0.21800520415949859, -1.2198891149465974, 0.20988837762289644, -0.072257082537297609, 1.1846997127117671, -0.8292055969980624, 1.8116926437616054, 0.70622117671826135, 0.64600239867371823],
                             [-0.13539542671654364, 0.5999576027553033, -0.41624826011809024, 0.79393947068673476, 1.2048474493784662, 0.61214811990969575, -0.13961189513170236, 0.39845366361878293, 0.029183315845247089, -0.75044296507479724, 0.43045923587981416, 0.93668078095585539, 0.93152575647079072, 0.24764211329507299, -0.3568557284550084, -0.91476554722272396, -0.23716697849971913, 1.1643539057203303, 0.10738653165984494, 0.24573518782270404, 1.1714947978154688, 0.8284771669762927, -0.25707201651665074, -0.37812106322938838, 0.36888982211312676, -0.71066918278864111, 0.43149430935583361, 0.58747682068880114, 1.3206936899755897, 0.93360104292806623, 0.22628903493239655, 0.60340215345370118, 0.42014184180510983, 0.5733753557546768, -0.6413114403193646, 0.19893081818514913, 0.53323788345217282, 0.27395008454943148, -0.34145878050252187, -1.3036767213485538, 0.50526868034859784, 1.6002688843440358, 1.6819623724003292, 1.1798857117371395, 1.4108147628826684, -0.65727125957960875, 0.50344625770494222, 0.67284552138193221, -0.61932710707493122, -1.5185582318188926],
                             [-0.75397303924959358, 0.27764029523376799, 0.59152924483441371, -0.16284222702185153, 0.46105815905479186, 0.95125725349915591, 0.29536907096992032, 0.40568405154055331, -1.2536342119892783, 0.15953938938128939, 0.07021004529934681, -0.12825012488922979, 0.37835549262715479, -0.55540761218782664, -0.70102008867241705, 0.076676848041637297, 0.27439633299845789, 0.42860553107687061, -0.18602674563233143, -0.26514888455497515, -0.14454638107198162, 0.10022111216698429, 0.48729434590592058, 1.1224836781849181, 0.44964290371679405, -0.67996789200323382, -0.39216250748334519, -0.025354982211148794, 0.19157217350566305, 0.37621536144946954, -0.071534556753535289, 0.5549250946911507, 0.046720188212482611, 0.75109937199325139, 1.3611159470998346, -0.81474735083891214, -0.94042409095176394, -0.93124588680115594, 0.77356410845047352, 0.019732465834552276, -0.42638930600543257, -0.0079614800460314911, -0.2392703903873061, -0.067646879224103465, 2.2696889907880524, -0.81531644877723053, -0.76644062606031782, -0.1373632752000572, -0.30353764867811273, -1.0380791241763478],
                             [-2.789915458067088, -0.7193396621485213, 0.39274955851542431, 0.18324419575307099, -0.25143627442342809, -0.038679309061185024, -0.24356850602001048, -1.1229696512161089, 1.6049998292303767, -0.23582462539776849, -0.080438295767765969, 0.80020187830507628, 0.57794988573468398, -0.69452946330910148, 0.55778965568251149, -0.091126927810294162, -0.78828266800996916, -0.42428808663249301, 0.18620102437264391, -0.42840800818970881, -1.1698943511898263, -0.94970863648660486, -0.14232364685593471, 0.045081248381519425, -0.80028607117913308, 1.2082421744203422, -1.2079472631455825, -1.2002251938126964, -0.70122867533008171, 1.0221686408813733, -1.3856753948731568, -0.32915494202748097, 1.1513268210450966, 0.34735857616534038, -0.08100001797634801, 0.335829795295637, -0.4822539399241027, -0.73731900568553488, -0.23828851310436955, -1.0928092789634407, -0.20203904464756245, -0.15968971917510233, 0.21244737552570314, -0.33703351327236825, 0.029256908011093465, 1.3825735799234538, -0.02917279831071971, -0.66294561221703008, 0.6113482542858556, -0.30119900414911183],
                             [0.85788899244051164, -0.24884555480753889, -0.40022002224242359, 0.87399053593126874, -0.646318735774154, -0.068542718867452501, 0.049320094670061369, 0.33810593986376503, -0.087102434261916717, -0.077869789881907348, -0.47721453906349154, -0.1488470520949933, 0.55351865405470524, 0.44368388437286066, 0.45735878472565894, -0.4360989044410673, -0.4884028418542285, 0.21688420938972483, 0.41469740282789164, -0.71764166736450319, -1.1602287403345424, -0.27444813207387819, 0.71036357668430605, -1.0226965905857892, -0.22573722823305514, -1.3110672395200194, 0.55898851471074629, 0.18664118611973257, -0.087240940311388432, 1.4058493713524274, -0.22530110523606367, -0.21110648594057707, 0.040201773346793687, -0.4891184534571083, 0.041533713656217608, 0.16867578034972236, -0.75225036151023161, -0.17046631174092297, -0.2473487726363553, -1.120391354430857, 0.60837000959228826, -0.32064016875997098, -0.073099302035610741, -0.65477495119932527, -1.4668877229445199, -1.2186355099703616, 0.60631755184525082, 0.56304831508294284, -1.0515229443756373, -1.4589638759070318],
                             [-0.02863968744868927, -0.34236612317861437, -0.76188873015662029, -0.52156880765532998, -0.36457429683023473, -0.31532034171663526, 0.46821581557957181, 0.41809787303447443, -0.2461469795601903, -1.2882730266239075, 1.1418412958120365, -0.10939505500466878, -0.28055353456601151, -0.063381153943429511, 0.39953349382640818, -0.55102954138134252, -0.14946944266841239, -0.74718033202636103, 1.7904626725182189, -0.29690827761812311, -0.024609048768997902, -0.53252968714204996, -1.6827507692982655, -0.41901237307826461, -0.38265480986331468, 0.66013870971291522, -0.45001200778572076, -0.54918478198139031, -0.6143005199613325, -0.31534878841056568, 1.1710066273094539, -0.51824369365683387, -0.24452527796050283, -0.75033587379172006, -0.49662115076133273, 0.35398945221596034, 0.60136505855278655, 0.15117489147041743, 0.6871854144355517, 0.60225692685982712, 0.22665739100098969, -0.48813389161715326, -0.29968099438397283, 0.039948867491923466, -0.23498658738576003, 0.9329053819356411, 0.75724249338858995, -0.046426499359635685, -0.77880188562937502, 0.96766213596882322],
                             [-1.7418370685623084, -0.81859677132789399, -0.31072778016711827, 0.38540139223036429, -0.25118801665697321, 0.67418533141606374, 1.1202511240726316, -0.38860547181724558, -0.39731772173069141, 1.3664262184205864, 1.7133511513115158, -0.057402919214339647, 0.6449200960779744, -0.70623408232021312, -0.74088547755914502, 0.83887652070991514, 0.98895363025112359, -1.1813460507633482, -0.49958607931334353, 0.46433239834677104, 0.93981530329615792, 1.0449113441347118, -0.059782147426502202, -0.54043335307991991, 0.84989826373358202, 1.0393381074798094, -0.20959504939146789, -1.3268544716147066, 0.7956204241665924, 0.18351819390156038, -1.5080044933493824, 1.3061348400204551, -0.48194640344693418, 0.84133467306720078, 0.43572268163169153, 0.060974505629089376, -0.1524914341444582, -0.24472641691373725, -0.9342828496845329, 0.35760721409203522, 0.76701657703407244, -0.068611734302213095, -0.040506160747418612, 0.012308431780423262, 0.40617679635292508, -0.81083646682622879, 0.64286118444925855, 0.38839707738064977, 1.3424359005706539, 0.53914389224561721],
                             [0.4345240678262498, -0.030828543014279484, -1.0521283684612286, 0.86003528486624559, -0.84870835043401394, 0.21566100325126947, 0.64661920186940758, -0.045515807931611557, -0.74248169461981428, -1.3185948373203185, 0.2284549057817476, 0.70274443662087027, 0.15989298304878674, -0.51250390677633684, -0.49953539115823609, -0.046505028695932461, -0.035528741427452153, 0.24029571331447427, 0.29768359528728694, -0.18131840576490613, -0.88925923252389283, 0.082634964711647843, -0.34952261322633671, -0.56506221550486524, -0.24348105584103918, -0.34296013449008839, 1.0201321255269464, 1.6542421384170027, 0.0104780726925696, -0.98771503310597053, -0.70863618310669363, 0.82689684717619227, -0.26548151505892159, 0.014768744042315528, 0.2690999856461902, 1.2457083503728505, -0.83044599622946103, -0.9547053783642685, 0.62856928195866213, 0.35506992898800072, -0.96656073769131634, -0.55805472577577719, -0.55441929261413536, -0.56740702752519701, 0.20409391833432422, -0.45684271572378854, 0.48051752948703236, 0.60226969884778847, -0.46566454054935202, -0.63869813509043916],
                             [-0.37033380334073573, -0.81225086544614233, -0.54166517522946322, -0.12605529505002289, -0.21701734755538696, 0.90735915148561341, 0.36155865200250742, 0.033420176127446959, 0.57372509682985162, -0.31578236719461056, -0.23646502503115224, 0.40435292990238597, -0.67575225634724989, 0.514276243456115, 0.37926689003496067, 0.24246653961093428, -0.28454956612504706, 0.66155543412064166, 0.85581618317026353, 0.3779918097199837, 0.16906583581541576, 0.57507115906759265, 1.0147983751400809, -0.069001622627740844, -1.0916660134069869, 1.5696189516201533, 0.11276186101935501, 2.2247359730191651, 1.1430815621967507, -1.4221527178794062, 0.72718696330467492, 0.97955613691112153, -0.096349992466161077, 1.3281912776707496, -0.33063057651702565, 0.3440488973028315, 0.46108503787561811, -0.41903854907813681, -0.59732518634651299, 0.14941176552423285, -0.092924116905918647, 0.53123192054407231, 0.74012786604026726, 0.63138475993653564, -0.7029968731652253, 0.94289895103839583, -0.50046442173981442, 1.7934691956650777, 0.8214268556679063, 0.43793317731008158],
                             [0.5268978138899354, 0.014495860154144322, 0.37505202829919565, -0.5421058289591375, -0.44538538776146902, 0.81309225490833648, -0.51159648770840982, -0.43032043092481026, 0.9856436150986021, -0.26831038703188803, 0.37707856509119103, -0.4665875568134033, 1.0530082231704294, 0.019705224545590389, 0.73844100865383944, 0.017191661233480319, -1.0146922256293596, -0.24422667106284104, 0.43631553509647381, 0.41289730330432373, 0.30628734453679946, 0.43636989207735749, 0.42903995053341765, -1.5223123904608882, 0.70623895640275469, 0.43644949378559805, 0.46872046132949075, -0.47960715648915664, -0.1547144191200798, 0.37660157450888776, 0.49353235369043535, 0.10607789504804011, 0.40284668896727188, 0.15324705022337706, -0.4148241363350767, -0.013069732109096968, -0.014393418283358432, 0.04488649568076819, 1.1565611983945259, -1.3488304886719291, 0.75426629766896547, -0.67142783892663149, -0.6614117171306968, -1.4293393989012146, -1.278043939098364, -1.0222272782180264, 1.5873703105241865, 1.3914243514349349, -1.089808059597053, 0.66848965851307995]],
                            [[0.48875478056474225, -0.1708005777135852, 0.97933931450660927, 0.34935927318593968, 0.30967076085659412, 0.09518617042638397, 0.91840530778903506, 0.33153840994752715, 0.2009467095707109, -0.151428621635989, -0.26313736304886337, 0.16047715701836698, -0.036517118796345907, 0.78788915144016425, -0.0955329228130673, -0.47700230509100977, -0.54129490349077214, -0.16422974424201051, 0.37623641181287298, 0.2350921434280365, 0.13649772786504066, 0.17047962199877589, -0.28170832616154945, 0.35854169037624423, 0.058592420866489539, 0.67931327503738459, 0.14394935946584045, 0.38094311548440546, 0.15070684078480753, 0.32254764696983806, -0.62937745077485174, 0.44682986642003558, 0.19978389935409607, 0.53194048325884247, -0.2594508252378685, 0.20337414327522213, 0.14418595174795507, 0.16851780229911512, 0.041464492322858051, 0.64077308592631044, -0.26786730170464107, -0.86485632875877205, 0.35207249158986109, 0.0023457555466779613, 0.49806257392123643, -0.43589463957952346, -0.42513835286560792, -0.24129193138116325, -0.53313384328588564, 0.072246374846253347],
                             [0.19350738719852542, 0.56188696054207721, -0.61428400382146942, 0.14021728303662206, 0.29708077472000416, 0.41090463697542073, -0.11778884894816134, 0.086605815497071664, 0.6120594717166904, -0.23404967910740165, -0.1545125052343071, 0.29437673887659727, -0.53132648601783061, -0.087637286618662713, 0.098988028217638538, 0.79377558348282595, -0.034576195084591643, -0.56224988170368928, 0.58241359193490172, 0.6637595999941327, -0.25878047722145275, -0.48613120725286224, 0.040777860970743852, 0.041637576532377478, -0.076528258402200525, -0.0050748683315658709, -0.068710307869203555, -0.015016718028424903, 0.010486886423604869, 0.30882189692113582, 0.18690715889267739, 0.19962380691512843, -0.68855520475672227, 0.7419738244393822, 0.0096571848527988082, -0.15851164158955189, 0.12491658810164631, 0.049000928459459546, 0.015605282247414354, 0.0056651473834770667, 0.79667764009308639, 0.69073827080364469, -0.35283885913192681, 0.36454800305629537, -0.10807562122417934, -0.010283372620492686, -0.97140618692674707, 0.3883465197057317, -0.13964318437492357, -0.18639894921393119],
                             [-0.50765526053114818, 0.2448275111662693, -0.46332836656945203, 0.31212668350084233, 0.45293080172876082, -0.34131125175990223, 0.17974340298441871, -0.24969562091005643, 0.21322433794954399, 0.56044004937571168, -0.15263507184760428, 0.19253987976346523, 0.17716964805752836, -0.13047507886128742, -0.10630741596571387, -0.53600967398131327, 0.083054922152625013, -0.79715810518602093, 0.39387646846577151, 0.56233388712921561, 0.55527145848329507, -0.1586126348242255, -0.91049166819345928, -0.65355052156507409, 0.094727821601771275, -0.017965779874881346, -0.03544608752866784, -0.2840870807319455, -0.34477586115806813, -0.21698766574143968, 0.90010206288928774, 0.880142536916805, -0.65672475403579778, 0.68946012894572783, 0.13306703717616292, -0.11907349514113613, -0.80645286458638743, 0.51953034178696234, 0.68435846704633174, -0.030671273756746498, -0.25067432804476492, -0.56810189644960152, -0.44480295366323902, 0.29168361635581275, 0.25543497747799454, -0.28200120315697963, -0.046422881947136133, 0.15309699373227309, 0.14499384695047368, 0.35907595607520665],
                             [-0.014462107689775325, 0.42282310737400924, -0.043793039318603719, 0.18045604352298319, 0.96442930995974308, -0.4562339948757721, -0.29009643713493549, 0.15802232851537013, 0.71410833491452907, 0.13804459817103942, 0.66312190221974299, -0.096577595420384063, -0.18094672557252928, 0.04022379352028646, -0.28996311475329356, 0.45375238869640011, -0.051721242663189525, 0.18155834568656246, 0.38922330076650863, -0.83349839438614082, -0.24389425512084928, 0.40786974122760616, 0.82570532349891368, 0.57991539421472005, 0.24781418373922107, -0.26645487793035971, 0.44760918082530782, 0.69963013559042853, 0.41188468530524963, 0.17661404961020039, 0.41320665460936851, -0.047197931535888207, -0.4208826277399465, -0.17196700284107475, -0.32301044089431841, 0.032697238331457448, -0.36124138710233539, -0.86105368170888341, -0.62594827687266841, 0.29778871039772753, 0.08632925651818478, -0.21353190695396612, 0.33929186564131569, -0.19432137322593024, -0.067738989755410428, -0.19793590973953987, 0.18705189182049101, 0.30211662940731382, 0.40718212513958807, 0.22061586357506557],
                             [-0.43332659669153484, -0.29222586495318531, -0.19015561212572618, -0.11660049236752013, -0.42602718874502626, 0.29118852553903546, -0.22702161629129286, -0.29293110484596152, -0.076082452892708555, 0.26458478384714701, -0.30117696928247029, 0.27556816442622706, -0.86354515505230534, -0.48897433822853964, 0.27157140279229514, 0.77263586704392428, 0.38609023762805134, -0.050184822247257635, -0.30874595028184393, -0.25781577623623514, 0.43774587594005088, 0.66672748750955158, 0.50474957100363926, -0.34562127554819017, 0.43623993794472588, 0.058647378100289249, -0.29779454071293249, 0.17115309894676473, 0.26688011660958399, -0.80748093979859059, 0.3524346928413864, 0.040333199797463991, 0.076426723495060953, 0.6130675966282314, 0.39499361316061132, 0.087329948785671768, -0.075232379567597471, 0.018469059362017246, 1.0005670822102881, -0.43064449512823916, -0.19481409068922598, -0.44702594053073363, 0.13360116138684763, -0.24662319161987856, 0.65507120931878104, 0.34318576163078129, -0.3596349327945762, -0.084776963025242721, -0.58430695221275564, -0.23789817322712531],
                             [0.06198721473212572, 0.3881598419860619, -0.052478948478019101, 0.061875281352785368, 0.32188660906489852, 0.030565138914340775, -0.52067783998014294, 0.54563642491762332, -0.039889113504985821, -0.42425154598418091, -0.32366941781488945, 0.47066624102291776, 0.11527889373522501, -0.86906684786882482, -0.20808371408306225, -0.32797313180290455, 0.27316995704236141, -0.18330299253703577, -0.28531288320575465, 0.5245312961988049, -0.18225084448024212, -0.18270027509748371, -0.5000600649704855, -0.22647764031338016, -0.51741556104260533, 0.22072254181753348, -0.39123057410361578, -0.2366790579686151, -0.83474736570881403, 0.47313772842975249, 0.38160584345953297, -0.34442970366395043, 0.09313655079781602, 0.29439164450575928, -0.33131679405444187, 0.12582020931133595, -0.040560455829442829, -0.12283069682548789, 0.42491889435307939, 0.045209360864817569, 0.0048678803064518359, 0.31535958458825358, -0.1616610349022605, 0.0019731710089518906, -0.57420141616494402, 0.28406704444237624, 0.72326593914235682, 0.13105000501393038, 0.11866738938506566, -0.94243035582811241],
                             [0.14466857433652908, -0.12851179059283238, -0.21450672855055833, 0.41364981993173644, -0.092225871519380415, -0.37368300267301535, -0.6943806277587341, -0.46022790294479704, 0.60746250632789123, 0.45244621498406967, 0.082258581936166641, 0.81719601819849719, 0.59185928257421672, -0.78801891979098759, -0.43727329045318969, 0.077985200583554071, 0.12706113735890498, 0.2410451497565109, 0.30914040848685082, 0.088894062076702349, -0.034549017504556856, 0.14686574348908743, -0.40555433460726614, 0.45571194495912987, -0.18273928665478401, -0.065396588130550937, -0.0040648716730649175, -0.27143045393991, -0.10075615350236108, -0.48453144261715919, -0.36027105079127314, 0.15568174696316442, 0.0313440689555246, 0.22774465872131897, -0.23542193368207534, 0.060054888276062368, -0.396077045287063, -0.33822775112501596, -0.019132066760451538, -0.23698007922584868, -0.40884515406869504, 0.58975931522061276, 0.75220484786217179, -0.23994686480953178, -0.10854489963134942, -0.22958709098921654, -0.25343854549173134, 0.40064848698560607, -0.31073111333923203, 0.53559812505653215],
                             [-0.02035854286691148, -0.20341929361475394, -0.03044291466979783, 0.36647941932390188, 0.38459145787640708, 0.54030319231973378, -0.17880909054168093, 0.093351782500448094, -0.26749096282193585, -0.290388455324737, 0.61653408972504342, -0.22832703299177509, -0.56758609227060075, 0.10505792520785251, 0.29755527461776565, 0.099931238941138117, 0.23045902615776795, -0.15078165149686787, 0.18463419940818529, -0.33370442403060879, -0.33296559505609008, -0.16777093919347985, -0.41326086177214105, -0.40883356433900397, 0.1933859344048568, -0.050949260817962534, -0.32936328086726691, 0.21073164239050873, 0.21483968860057762, 0.010186734101633108, -0.9994108075342415, 0.077823675658444225, -0.11454798601623913, -0.36147717678287133, -1.3263269379315423, 0.033086530308230916, -0.18827650159169099, -0.091750620389374177, 0.30550474080315954, 0.54110548661204927, -0.1410809985701221, -0.38513794830212328, 0.51143567368350384, 0.01752865768617623, 0.36421812571923973, 0.16525383113168518, 0.18133760442202654, 0.042232174463915959, -0.28091381085499972, 0.038047029259005959],
                             [0.28608919281773121, -1.2416654940246514, 0.067565957495502468, -0.022977313270890011, 0.28412598202400463, 0.095413340785872339, -0.29152193764060647, -0.71707644619552946, 0.67977767218948548, 0.53195147932856623, 0.24756729307659581, 0.12883669090074731, -0.40239290996874438, 0.5077932907804622, -0.090566019467499981, 0.034697286290339302, -0.084298418452472504, 0.3479603632157966, 0.31974517268786679, 0.038522941757491824, -1.2179057484654405, 0.13213313944477001, -0.28876020499170768, 0.2239809240371487, 1.0159413861516444, -0.24928349003940514, 0.14978267624320638, -0.26495886881255393, 0.29255374638792792, -0.78158870213709941, -0.15649476481065547, 0.76088632357043728, 0.61122647649680528, -0.35422732759163339, -0.80385840984144874, 0.23307851974995206, -0.26433168430474557, -0.3186450536153641, -0.2576346961058934, 0.59482167101665573, 0.31960950930440291, -0.41022410488846778, -0.23025800375166122, -0.56676933800448814, -0.19444379539326367, -0.25752101762775992, -0.48317874231392755, 0.2275674773095468, 0.45592328985609204, -0.24592863284761804],
                             [-0.088259154205004783, -0.20224419552518363, -0.81064708817773956, 0.019659069254627105, -0.13392407201442766, 0.10038871815510675, 0.94623445257164129, 0.39020498920220192, 0.1901605438594558, 0.15253297800884075, 0.24928828580249277, 0.97086574383279944, 0.069765106312482686, 0.18726050881204959, -0.025415031117381828, 0.49562625004412431, 0.27894926709117474, -0.042943323769384228, -0.59800585985425314, -0.2486533510973061, -0.5502440366898379, -0.60070867729350208, 0.47065365027208417, -0.12710582562369979, 0.18484278986725533, 0.17837441563759032, -0.72761830012950612, 0.051782505862931677, 0.53771945235786833, -0.46247550167677903, -0.54855537497745566, -0.62373345782604606, 0.045120586748233264, -0.78414466028637453, 0.010106796019788634, 0.85859795411345741, -0.033894942392377801, -0.3102374018906548, 0.73661149379777768, -0.15278427754231022, -0.058119457503706354, 0.19341502187346063, 0.42579584838671025, 0.3104380651603531, -0.19804894572351023, -0.40297695096626374, -0.26110610344491414, -0.75259082459934445, -0.029743298679335613, -0.089225335138695835],
                             [0.090485183524409554, 0.30930447117894638, -0.16175518280645601, 1.0555877028466292, 0.78032834544773821, -0.12074875223402774, 0.062773946700552904, -0.63784487730598161, -0.5126668280881258, -0.020068267649619349, 0.33105907666521606, -0.37371946896625463, 0.055071263169514294, 0.93805253785281018, 0.026780295187487303, 0.14700237293986373, -0.61137429731007253, 0.0028481303199647643, -0.44743501657458823, 0.3527510522837401, -0.41385347131918027, 0.51882260144897907, -0.2483027495138832, -0.31490390258255274, 0.19758992524551555, -0.36791831068431952, -0.37568872143072901, 0.63269955541309586, -0.14228447936294047, 0.3386448353902245, 0.27463857856388585, -0.17537366904366569, 0.45583165139348464, 0.98366662849718267, -0.61629716309764615, -0.44630666752052583, 0.093990962538885892, -0.34460425818964169, -0.42801042909442655, 0.27544745277340105, -0.26980607364687959, -0.057963582380970748, 0.19713754736327624, 0.38766155906552136, -0.72545225953919878, 0.73559176485612121, -0.36341568172573008, 0.0027832415812236726, -0.50509887532183606, -0.40154236844898528],
                             [-0.082068152716388523, -0.7935919880589869, -1.0759803630075984, 0.079419561773349606, 0.12954574872653898, -0.36689183516007995, -0.5711471604199756, -0.30857465105984333, 0.22793355861717371, -0.055193029588648149, 0.54979071897276921, 0.0085421255557495811, -0.47976535251537572, -0.26259401101306989, -0.0010927010235720035, 0.32255657191018877, 0.45568587848248177, 0.14706809112725786, 0.13271160978893726, 0.47011626824423197, 0.049026684161291884, 0.47322205375701121, 0.6718800609042993, -0.30944880905893851, 0.011525850732490947, -1.0996679965135869, -0.014542183589784333, 0.085898595552440518, 0.034333562153288116, 0.31874897447028766, -0.58419317690921169, 0.40090778077481509, 0.64426903730115659, -0.36931932662189693, 0.59293891547208588, -0.02409415428056692, -0.12711773453788075, -0.1048105087092045, -0.078208210305508133, 0.20131564708565974, 0.14787209739161683, -0.044388384708808779, 0.27587400586728922, 0.81046102567658795, 0.21859760628551869, -0.56804402662487874, 0.22553725154197568, -0.055605603935633158, 0.17047247624669146, -0.86904825419068454],
                             [-0.23508615895371299, -0.16159811376397354, 0.080169713751238325, -0.57706809011026261, 0.18060860317224414, 0.37078595053255858, 0.31287599115662562, 0.21735971108857585, -0.42148162934867928, 0.32674496715170515, 0.34440545436401054, -0.12530416157883317, -0.76910321441633278, -0.17802594463073645, -0.41474164513921913, 0.17591258855078923, -0.078703406008143656, -0.71647231917067999, -0.22490351514479642, -0.027014888095312287, -0.12942538483783211, 0.21251111876203382, 0.31891897828977911, 0.083205382410345238, -0.23010309154758257, -0.033531266595070622, -0.079673403860894082, 0.35020725685718501, -0.87584259259365704, -0.008435621363652791, 0.72771845407958069, -0.097630309456172321, 0.56662409023874349, -0.39380953489530879, 0.50834133052808561, -0.32276388170435966, -0.17671913407714648, 0.38265251350979412, -0.24735739306599247, -0.1937699739042314, 0.21201643534577186, -0.068910285824126366, 0.058435752963088457, 1.3366933912702426, 0.011162207818284321, -0.12821181264851467, 0.61169304599284979, -0.337606628630371, -0.23969475219358996, 0.4506115250847661],
                             [-0.796121740784553, -0.72741955995798513, -0.47859085971740511, 0.095362139017850123, 0.44169407124969823, 0.76850031682440101, 0.2418745639550961, 0.68964665322850938, -0.72504277970998932, -0.21561347764504171, -0.36184104161329994, 0.26033532863652459, 0.45186799774455938, 0.11745854038957326, 0.14287953260363292, 0.72165676306096826, -0.47943658695363911, -0.3560611063481296, -0.48417350716408941, 0.17750160181734836, 0.22476467339151018, -0.046228344906704161, -0.19595968360506477, 0.70649372095086471, 0.49076949254695668, -0.64005246569501495, 0.41282618561520495, -0.67112596303366157, -0.21117400193698249, 0.85489920019079324, 0.1367398015240347, -0.57342159448430807, 0.44504797393404993, -0.22371923659610193, -0.23828367710134329, 0.442637843474954, -0.054640114423523151, -0.058957221260070448, -0.1815366697370519, 0.16841215307434848, -0.45107952836216114, -0.1554675413217525, 0.26935941042399336, 0.41474081570159543, 0.48037490162470442, 0.23007144384634132, -0.26279784398278289, -0.12591641450843552, 0.48098506178959116, -0.040507087257685266],
                             [-0.18619959302174988, 0.30616803284840682, -0.012348303052371647, -0.62415398780385678, 0.17576919213221676, 0.21498903198129438, 0.11282374689413448, 0.38374464030959504, -0.75646094907376904, -1.2130859930976121, 0.38641532130741513, -0.05575368598967638, -0.10711420915240749, 0.65478589069890791, -0.66061240595950921, 0.61913951167951153, 0.84899312230351653, -0.38325363717597294, 0.19967309958171098, 0.0091660387559850919, 0.092667869049051235, 0.39204148826989471, 0.36037377346406591, 0.015043510189210269, -0.47316708266924545, 0.72415948103421313, -0.19605952128805978, -0.51481537248635911, -0.047924620216796665, -0.083523216058571687, 0.5065246283441005, 0.39900493946017696, -0.063299611364804206, -0.04860054867147226, -0.27073289171373655, 0.17398327543185402, -0.72564217436385781, 0.275433432804503, -0.21774951705810325, 0.57159122084359337, 0.14687347837954395, 0.47910674807440595, 0.32290131720069398, -0.050130414291948575, 0.14445951029968812, -0.34658671739343927, 0.6836753513044076, -0.35919196843996876, 0.18277955108049182, 0.31477961455020759],
                             [-0.4127241526548725, 0.46988277183908433, -0.5642704251600007, 0.010626885965049411, -1.2091108488903151, 0.13051190458005343, 0.28189043800786268, -0.036433673056751159, 0.035923492462780704, -0.70420482687991182, -0.28876431100917677, 0.60367693564600977, 0.015032023242887639, -0.059410606319722808, -0.479895251288187, -0.069088454711330211, 0.66868797819126691, -1.0383459644009683, -0.43714224099043153, 0.058449029821368785, -0.39139684384060613, 0.26671228442052874, 0.1463831289956562, 0.060875554176929955, -0.64949696661922651, 0.47519529096938751, -0.0023435314927420133, 0.25378265226043506, 0.41833677717416307, -0.15699060672351561, -0.3109561355642167, 0.49564591510758427, -0.75261608577730665, 0.012645112526471757, -0.61412953707112983, -0.61312306883338041, 0.16514590690631881, 0.13851668775957995, -0.30293139700796018, -0.010547808104445769, -0.096916503579858274, 0.31891623665190644, 0.59153739547837292, 0.3008806287245811, 0.31025436600738571, 0.2585276541561875, -0.53865745054450631, -0.23379445604202143, 0.4654409178308539, -0.36014833155274822],
                             [-0.36999691014591946, 0.27643444354863006, -0.96301365603312772, -0.012939956538385946, 0.83906804361270482, -0.380074632376939, -0.12392071845960032, -0.36571257244570254, 0.89824258858049111, 0.10496949548720513, -0.37494494047161725, -0.2119814354780121, 0.053729854219793323, -0.090527778709885709, -0.47934211189200843, -0.0022639081398393678, -0.34100238327551224, 0.8591224909623576, -0.35091800752360253, 0.63464628472491602, 1.0030312600382842, 0.01696018076914442, -0.14338104991794301, -0.45596251814217564, 0.28226547042754319, -0.37166481607166874, -0.48734412360127205, 0.54449693148098521, 0.41077809057042558, -0.23548235488590297, 0.088639406305224988, -0.31094202405477539, 0.13149593295794842, -0.2894656759312827, 0.42189404414030468, -0.23052322421078308, -0.45884556294962198, 0.13986396511056026, -0.77672457654475224, 0.063019787476831624, 0.44633185181500701, 0.47240687164429923, -0.38071804229494721, -0.33855379688661741, 0.45921287530358224, 0.14143078331695538, -0.046844098787958061, -0.50665079069180252, 0.10369046423629411, 0.31430224128130019],
                             [-0.53219169033810321, -0.26511122715062835, 0.90488480496134127, 0.10796280132621904, 0.48160336788033548, -0.18339406637950173, 0.00016537622878914915, -0.039755001718386709, 0.23044198873392793, 0.26912711531552469, -0.32926159308096425, -0.6658399524481925, -0.96611942675431961, -0.20220572346892693, -0.073065426357451155, -0.19484343955980227, -0.17870079678935868, 0.59326777310379253, -0.53865365230821949, -0.0030349381207411298, 0.27463857635341477, -0.44433487877252148, 0.88327689646400331, -0.47525482074612452, 0.063914050239224252, -0.41168331891848248, 0.10388296364365765, -0.54308182018726869, 0.094285575374437297, 0.49994937296834308, -0.14923190972375819, 0.048797116728112801, 0.4079908230522164, 0.24620767203666913, -0.3461436138526392, -0.31152099481827283, 0.64224877108654721, -0.4098691586980352, 0.55162489833782735, -0.17358279413318523, -0.54989196579590316, 0.45300752054242416, 0.42522968930652333, 0.46389185147067846, 0.11661387098279977, 0.10102665179716802, 0.42283553652718558, 0.28733598864035631, 0.098777281747770312, 0.10479295824214103],
                             [-0.051122450255603989, -0.0053023642524803027, 0.14984549147305951, 0.22072673329608788, 0.53506606137151558, 0.2372729988673761, 0.18588517229210813, 0.35388988052137671, 0.10136643959706557, -0.4082952468293195, 0.22079588427045443, 0.12257251972152203, 0.79587444275291042, 0.31350462894699804, -0.2530030801997008, 0.44624020854436353, 0.60464448175934171, -0.32444532102586054, -0.30890049170137118, 0.029703504990186827, 0.53371707921301037, -0.10788021026796779, 0.10769670968381315, -0.55392402321535272, 0.39917395653608262, 0.24619782110389896, 0.21841781216248421, -0.12036366834173107, 0.11136104105721194, 0.18856990753555006, -0.10014808640255238, -0.189670448301552, -0.017145613525921061, -0.30591237929388265, -0.017510543697531716, -0.46016441691989635, -0.18501707095259123, 0.072064989960903394, -0.54056985197331642, 0.035208805931946308, -0.50606947588035378, -0.2110602446702062, 0.027022165155617998, -0.23884025676526327, -0.35521737823742461, 0.51625930123957386, -0.5846724220235423, 0.3320624210715753, 0.10328533075673292, -0.48617371288898925],
                             [-0.33912529137754427, 0.21726453902273976, -0.20414708187953132, 0.43170273364487211, 0.40478532889809449, 0.071465768790714826, -0.64766359082526481, 0.22664827700433629, -0.097966165411395453, -0.057388158717347572, 0.58280337266819759, -0.32939575163585316, 0.31021640110049936, -0.4003573191016499, 0.13230348561595062, 0.40220983751464329, -0.57228861696051225, -0.52340561590611145, 0.050390038062245505, 0.17091451808751335, 0.056375880940412369, 0.18884459261990005, -0.68385509597069627, -0.41347563618193284, -0.28207667159903288, -0.48032364094080721, 0.50847743024105541, 0.23961640347476112, 0.12887375789732994, -0.33132262974823284, -0.011796072754212742, -0.543078070160666, 0.82776757045898219, 0.48057308048808034, -1.1356512886547276, -0.19330272095718051, 0.3605335187994928, -0.36485066042640524, -0.039497641677576759, -0.37516233010026667, 0.19460085671812324, -0.12159955896835875, -0.32542884224441743, -1.0025636820441617, -0.55334545298796567, -0.75399386161418602, -0.24593691673267304, 0.13590474663348134, -0.45778908074887015, -0.077323405469723813],
                             [-0.20515940321545512, 0.10672033104606847, -0.71577915120853008, 1.0165085581561244, 0.1369445819363492, -0.065138050765955233, 0.0129540657888912, 0.83323949752498727, 0.067895560789026282, 0.23491205729459405, 0.17876118150107534, 0.056349196911031109, -0.26055057026544487, 0.89156532388310605, -0.39542588153455743, -0.93891631297051414, 0.49984411125493167, -0.39253754755273085, 0.6735022236790521, -0.41169429247145201, 0.66636998669392411, 0.45555889717602999, 0.65007940056446289, 0.236502783926856, -0.60831137245206035, -0.0037057904913888945, 0.43252699006459622, 0.15351622777658008, 0.11221866691717866, -0.033542844618331111, 0.39466900348113892, -0.812243182966635, -0.345438643541228, 0.24876008908592304, 0.23236677940359968, 0.12748357666640561, 0.38166770693128493, -0.42718968811066454, 0.48462234702931256, -0.21157486222889502, 0.30618646330940291, -0.476363442051145, 0.18611705494704964, 0.37944262870934031, 0.16634768917345094, -0.025144888282059234, 0.01607411250943605, -0.13831228681908436, -0.37445006513829299, 0.3526758676018284],
                             [-0.1442692379982414, 0.090865625343939244, -0.16083726104699059, 0.22227301359833909, 0.54942309753133922, 0.12812563764220708, 0.090151774972355353, -0.82057117854134998, 0.71479519187554619, 0.031104391080665809, 0.088972625439367278, 0.065915126308479802, -0.28864925463726349, -0.092647783951832041, 0.083548779572818616, 0.77446719550249532, -0.064941873221649779, -0.45477575654351932, -0.48985208939619668, 0.67060963640444471, -0.69505567733143825, -0.10727918389783375, 0.5432198541110943, -0.45912563349860863, -0.60712589538174611, 0.01527291208377018, -0.071437408554626047, -0.19273956476748896, -0.013160568627540278, -0.48605421107814617, -0.1464154993070767, 0.20644234764178876, -0.19102260532637005, -0.1046095207738295, 0.0078362392311837267, 0.31503805891618558, -0.36119893367151384, -0.10381475872036831, -0.17638054312681112, -0.21355328493791031, 0.014208700069395827, -0.82644040130470731, 0.12948291057370223, -0.17635666504614708, -0.17200939794536482, 0.33339895004212533, -0.89998107846488618, -0.24502277784500853, 0.02815975393125681, 0.70821302591027113],
                             [-0.23970228130947049, -0.047297853737047056, 0.5901315424783784, 0.77755087334792505, 0.24693226073902119, 0.48492288580832382, -0.54120187512867279, 0.54266728198231762, -0.16902493110797401, 0.35583093415457445, 0.18517786389628804, -0.76076233937894422, -0.24794938593351384, -0.024295156353253036, -1.0852814164789284, 0.30240607572820416, -0.44135246383843391, -0.34151917938651749, -0.36766010411431266, -0.023776422025848249, -0.56064233269090724, -0.86055783158859533, 0.27067727359354204, 0.044416870542222216, -0.13569486936640093, -0.88307631135333042, 0.62658860931149041, 0.14350970003113284, -0.2538532980741609, 0.16788821130685813, -0.10309563170484366, -0.42792520232353709, 0.0350435395002009, 0.18458476058357401, 0.51625998252604477, -0.25935264923991336, -0.44200457111900399, 0.10990875533533687, 0.53409602851966309, -0.49500355602701862, -1.1758097122864406, -0.37786340553233261, 0.43259280282797319, 0.077283638626722356, -0.32466188521774381, -0.56517101245590351, 0.80171629074655504, -0.68139800442307252, -0.32008790649187363, 0.20206765380413616],
                             [-0.15139333147712963, 0.69543361855519725, 0.33099435524486226, 0.10400138331753397, 0.50313823452404227, 0.35959516445787831, -0.41791068753094507, 0.060722938155176584, -0.68582906438719515, -0.61793471871409267, -0.031803407902013629, 0.082204710830078659, -0.31657631123160573, 0.15246278423069273, -0.10614790216468507, -0.050658958011491839, 0.30938989403636913, 0.42827101120857924, -0.71576266134383604, 0.55327856772101003, -0.27314480666699659, 0.33435961714199319, -0.31632769784915049, -0.38212025649149206, 0.13047884910140517, -0.0084988176135570095, 0.50488216283896759, -0.056417908414125945, 0.12597083097000006, -0.66723428539676644, -0.026986708727968298, 0.27201885965741052, -0.34361593688700987, -1.1436437890815605, 0.21092437293011135, 0.17722988138808454, -1.2257212632423888, 0.15459726193169657, 0.0075602564990349605, -0.17856061739569784, -0.10696874661443836, -0.34568678584072798, -0.31391206140913147, -0.16169763401047413, -0.0043877145140652427, -0.82514276361246564, -0.11753883767894439, 0.49474479567959856, -0.14396396232389466, 0.41667377455494714],
                             [0.045089705306631041, 0.097268099697679425, -0.55204081163413377, -0.45712234778713384, 0.024859173312339698, -0.34376297202815037, -0.16198862887224738, -0.0019962814048301233, -0.8124252344217997, -0.60601443864956395, 0.021859011370022802, 0.21447449714469702, -0.14952223904518047, 0.09490453013214524, 0.34642490903969969, 0.0083745020019192814, -0.48788380111877333, -0.15355968317026328, 0.29408277915133435, -0.14569139713334261, 0.29608256637971042, 0.47371724434033108, -0.3333123875147096, -0.15977949032769118, -0.087328561397152754, 0.041036279024299786, 0.20788199827034348, -0.13203079126203698, 0.086212988693756487, -0.69696196389977838, 0.91733698236159134, -0.68108546415233762, 0.11726434097518458, -0.28826269960092227, 0.16361487255974658, -0.58864760392860793, -0.23656871565837098, -0.6518157956045435, 0.51637791844062597, 0.035983348206093155, -0.51249969564713183, -0.18642912677549345, 0.13823011814114194, -0.33760654893664899, 0.16731525761311264, 0.5294148560130475, -0.46762017705645365, -0.18248750314499101, -0.14043896326047586, 0.633953459496016],
                             [-0.087098496342639817, -0.17255791405994583, -0.029336865613044518, -0.71138101526112851, 0.34198966686797838, -0.31601666226962721, -1.0936056364748266, 0.34934886990612202, -0.1064493985069658, 0.29236171315886567, 0.065598860901147985, -0.358559287296491, 0.14750237973173796, 0.25688579378848009, -1.1211354805862821, 0.070054930053450232, -0.43893444642908036, -0.40342276190966253, -0.62836375686251933, -0.18884803095070607, -0.36464955664563903, 0.088391918061332037, 0.12485689817562914, -0.040423659378077709, -0.177001533238164, -0.12429243608769297, -0.29834556473248647, -0.38049776890310394, 0.03562462098837945, 0.97835997410500619, -0.30168073893152303, -0.020748995281931835, 0.43055848421905318, -0.29604147209553999, 0.15064008018409261, 0.55106897018315004, 1.1388880934149206, -0.34657506017794176, -0.3839328225714686, -0.27724428314439709, -0.29427755280219675, -0.74409875751981969, 0.051188620271376425, -0.029254262691532008, 0.02381888438594177, 0.51986235416991688, -0.42927654904808299, 0.4115687300040301, -0.42667336270402129, -0.74584710712414881],
                             [0.68942355632915109, -0.27719716885609369, 0.037137855475494738, 0.145401506646052, -0.28626895828032162, -0.024587131317259849, 0.17768020799166268, 0.49894569391284721, 1.1248446999594202, 0.32004078513137357, 0.033273204713273948, -0.048081047054217653, 0.24244970006764582, -0.3431132637479834, -0.1270103621961228, 0.51234525353316762, -0.65309990004676455, 0.72949152375577553, 0.072912134760246466, -0.20538717683682312, -0.14846113893260143, -0.12471506515505695, -0.0078748093907827672, 0.30541405048176923, -0.13582064966689819, 0.53383523634836105, -0.14302939100836876, -0.061399496714082721, -0.66622172445323113, 0.14744680480053879, -0.25597015517218968, -0.00037689544776194073, -0.30148090821364854, 0.50848504927974592, 0.27292829833584215, -0.10013215289237805, 0.92181230332731789, -0.6327334657722341, -0.49386719000296952, -0.23921310772613605, -0.20648577576910745, 0.12128820597648685, -0.27932785375290697, 0.61156648597934971, 0.13190403494400796, -0.28071790351390336, 0.97428447618142899, -0.13023767814772821, 0.46201875012171989, 0.012609982861462331],
                             [-0.26964803386948472, 0.26625682257232863, 0.095049506037429732, 0.23063812618797744, -0.035072247257593267, 0.57115269381231071, 0.22800894534179966, 0.023768433871409544, 0.10914180401836611, -0.47652270243492928, -0.84794939815270165, 0.59564716561157693, -1.1183946730255867, 0.0077011048748418381, -0.76243435547487282, 0.93788055421015404, 0.30399691122599098, 0.5935869436812844, 0.51885684341052152, 0.29362877962854272, 0.23628730328709588, -0.098552240347835149, -0.20166773069207605, -0.25306641369602073, 0.080525697233571128, -0.68454756198316125, -0.39613370631844069, -0.32413868863173578, 0.12471817298082226, 0.20931254489962853, -0.65263851359999481, -0.32242208169640285, -0.13726924780067351, 0.061007602247889758, -0.037259667138255445, -0.45206861043327323, -0.21441814894916264, 0.19645385810752472, -0.61639811089215202, -0.54598804280507385, -0.054880392085000895, -0.63588378164963899, 0.2250041964397349, 0.055532845812806778, -0.24157983451619716, -0.13173784135019256, -0.89595041616978921, 0.44182433388620335, -0.33932559882979652, -0.61506607747453201],
                             [0.50817087421798268, -0.16539528740849546, -0.44680943693190356, -0.58895787137613476, 0.2134268599249444, -0.5771334584712724, 0.80193504061972687, 0.088494296923058852, 0.27736095427416518, -0.8207797768755678, -0.18780773199862383, -0.97233191135297881, 0.023661928999753334, -0.088486370694544361, -0.2420774819483614, 0.6857242640574408, -0.5844448157970602, 0.34090322359689629, 0.49430699767117459, 0.11725864851333169, -0.082460092305014887, -0.25383645864011667, -0.62650396653632023, -0.23015684071165279, 0.2080089686387418, 0.43727638643782862, 0.78819820116245742, 0.072586890211800426, -0.34445558890423289, 0.050434918425275976, 0.14502326462839563, 0.45200308118395027, 0.20223947685561072, 0.66246996488828536, 0.075743897319493214, 0.12895260554993682, 0.11010762080605248, -0.17689782447885311, -0.91569028766022642, -0.41705489774241089, 0.41010816769639852, -1.0015576693405785, 0.53749523783449515, -0.20770779209648166, 0.6171563377253857, 0.48075120943835287, 0.12459425599599094, 0.88351505094541372, -0.67341107370584996, 1.0847112721665735],
                             [-0.23577508942184833, 0.77032415238593277, -0.23400889261438659, -0.079647654979958876, -1.0855600426317522, 0.22021165032224971, -0.31524894883845267, -0.38246863823869653, 0.72417891987628635, -0.48673690696281874, 0.25033123114432371, -0.014687412265628974, -0.67507701124775132, 0.20465033510299294, -0.35311463016561079, -0.085458062929575779, -0.14453682419299926, 0.23041077513424491, 0.56495946114846307, -0.199869458077676, -0.99686694403596376, 0.42403867218872843, 0.14999907315956965, -0.050565739518436029, 0.28923279152642922, -0.55742786441782177, -0.052886538154399691, -0.16157066923715127, -0.29208834809066514, 0.089131696401502078, -0.58192826744020021, -0.12012422688324964, -0.055964771652817477, 0.35779698290311379, -0.45994134003393344, -0.053720825802882857, -0.0033639309122257331, 0.38014707388925517, 0.32922456616156059, 0.01771208567753714, 0.39954805770741331, 0.27145716440502776, -0.52359230675539037, 0.63535792662146839, -0.13939772551195256, 0.57847810538457523, -0.77466257906705271, 0.018757899292034697, 0.20944963806423211, 0.59461624268171032],
                             [-0.25010071438467457, -0.11193738451111396, -0.34134700910996213, -0.074849768630414523, 0.19225610099096288, 0.63150470427719252, -0.24206383316055824, 0.26703536333212241, -0.23520765974425095, -0.058486190920840397, -0.15927793346291008, -0.58608464939577665, 0.013890173609062698, -0.55970657694707104, -0.28968453762226876, -0.58761682722641873, -0.37182137610365679, -0.94962501071430105, -0.15875740407118291, -0.023213583273585914, 0.29500339319296343, -0.15589961134428326, 0.313837267150748, -0.033579188591267711, -0.19066132533259514, -0.22384373112850139, -0.42142755492032391, -0.004563493320752704, -0.28972208792758275, -0.33234899566361992, 0.1212440472485237, 0.2993307028142852, -0.32143741033532319, 0.20144436224499887, -0.63217381320825994, 0.7267695143165096, -0.75734657369828517, 0.32704511440397066, -0.39917522897665214, 0.12555579398603295, -0.45207901818033452, 0.30491715123598118, -0.90593306104343019, -0.2631131254291183, -0.17381649371459357, -0.51601358395493069, -0.16044720893744924, 0.68470981547802134, -0.036431645453457499, 0.27758873597597744],
                             [-0.095853543379723419, -0.90802685985707632, 0.63055143986599083, -0.22024512235433921, -0.5786312123846129, 0.033391818693869001, -0.13745799703230793, 0.36687339373340155, -0.74669050981940255, -0.12604272899343219, 0.70161994444785691, 0.12678989425265585, 0.29215361781878924, -0.60852512836261441, 0.051130718137684349, -0.55169612156036918, 0.027016765036978991, 0.3290093864900866, -0.79611852806589556, 0.50620744957331154, 0.47291431363212599, 0.16708110914153435, -0.34980030310945726, -0.080731244868122415, 0.058002141968451937, -0.25559583214513804, 0.063582141529554673, 0.31351933266593013, 0.012666576425147933, -0.12340098033811045, 0.046691491481378973, 0.25469251958963374, 0.071540820119451523, -0.28981735157050331, -0.20997231398807664, -0.041979781093247182, 0.4154643587804876, 0.19001910297892743, 0.50875906662744275, 0.71344759066562713, 0.15900936076314873, -0.076283301659236927, 0.43012137796271666, -0.36983571350281752, 0.35061685018461858, 0.42566770699611495, -0.51587105434172598, 0.055177611651453184, 0.26979228340051803, -0.19352868472907889],
                             [0.31006278149153732, -0.58409802469583416, 0.16790884359174146, -0.28370559594191891, 0.14886817955166282, 0.93663110742264888, -0.030355236505273536, -0.37830339322549522, 0.24711817391428997, -0.14916304444419443, -0.16558123188058385, -0.3538303328484218, 0.0052928028838899622, 0.36226613892772563, 0.31923339108704146, -0.42556404825095162, -0.54730748108038241, 0.26951397576912522, -0.29416344970747643, -0.41205714089851964, 0.20207568696004505, -0.74099353777241761, -0.42763980840345578, -0.47762905578302572, -0.30004768935024917, -0.03474790709114739, 0.56907210606318925, 0.14550477581941285, 0.78223249286223207, 0.14104988401545043, -0.10938933776065682, 0.02951611062609881, -0.37867011067813938, -0.34426061415346509, -0.4940624121372611, 0.63804180286651802, -0.30676844965650629, 1.0582579054789294, 0.6087403268712972, 0.19405224251652212, -0.34214011858819554, -0.06784441814070194, 0.082973824588297024, -0.1833151150262643, -0.16681004765247198, -0.12423297331232266, -0.29792451925941588, 0.075275275963516949, 0.20129887963488177, 0.14697460236408683],
                             [-0.29967576939287827, -0.33155265904812364, -0.27164782545421751, -0.40615985189645687, -0.52995707153201443, 0.17683173553593254, -0.028151644190189843, -0.033739345333155576, 0.077267924903473145, -0.72015604132993483, 0.92247466088549046, 0.20314429881487742, 0.13868762522521147, -0.5305149049726644, 0.37873458568434426, -0.26218490476898176, 0.28319307009069217, 0.27115831601354307, -0.16100526632074671, 0.2318788395581704, -0.084739166462651491, -0.71824927956440354, 0.20511614817194676, 0.27996395189321899, -0.21765553256434192, 0.63827372697893892, 0.19550945805726583, 0.1042018574108837, 0.49362764852272595, -0.11272607185252084, 0.01340483296069701, 0.56483736136316298, -0.036941193019067578, 0.51040766490417699, -0.89983564273939598, -0.19869324471842359, -0.44804754734857805, -0.27932636783773229, -0.057275701056777109, 0.084240144852669424, -0.68507485952212765, -0.25914751396055147, 0.58765818113910706, 0.5185813752167866, -0.28858561382196757, 0.57183144647213158, 0.096833971558485207, -1.023088541935075, -0.55328803461452203, 0.19637949937446422],
                             [0.31134039747306225, 0.1849054086870684, 0.0072346851727926355, -0.053769310380836211, -0.0047749735990807677, -0.017676370178829566, -0.029203093059148196, 0.19763753534798101, -0.17127562674214877, 0.67352201535821932, -0.30977966640644006, 0.095260353433681166, 0.33702621613256128, -0.61233539653137226, 0.49264726097106065, -0.38131071748490319, -0.63625868226349991, 0.033906896640689771, -0.25030817974107838, 0.024764225092821397, -0.26841068070153551, 0.68587302946017237, 0.85997077874604577, 0.17891946038307074, 0.86586908403974994, 0.045639773374185878, -0.35753618277042842, 0.040785000627066394, 0.17363563321146661, -0.27746231176380659, 0.48979658758443639, -0.2970692616345898, 0.48447874332840957, 0.76396132159209673, -0.77389079731803567, -0.52346331589396589, 0.10825425382168762, 0.54320871857332265, 0.31889726775945171, 0.24806456861116488, 0.44905330972265983, -0.37562278549717487, 0.36845705498733483, -0.56703739684145016, 0.13324146734260642, -0.57956726066186914, -0.30120523536648303, -0.10971311911805065, -0.1669894907253042, -0.10034688935944798],
                             [-0.11517483940137382, 0.072357293742525905, 0.36591365015360022, 0.020575262023376478, -0.12105816866726739, -0.0083463729375144527, -0.0058940429169676567, 0.039757343362221476, -0.72036919869117944, -0.082515130263665817, -0.45597800338308769, 0.15679670298068069, 0.28130492151962111, 0.25124269998135684, -0.5039813615212847, 0.60389953256641937, -0.41769654985898963, -0.22992122373414048, 0.67928753735390546, -0.018066032358673587, 0.33662071788549891, 0.1819914129978738, 0.14069482500615138, 0.89291653707440144, 0.11527956646683331, -0.21215186542630443, 0.1812540702156589, -0.17402447070154406, -0.80880811180359258, -0.29682649654285603, -0.10437984479538123, -0.021581922572901945, -0.22854948714405418, -1.056866278924915, -0.78240524167169512, -0.29718542982206758, -0.22617243715828175, 0.07165743213184339, 0.96451734651365484, -0.10776321116099176, 0.56181753027906589, 0.42426799679888078, 0.021824365240598633, 0.0046800613022480106, -0.66782067470024609, -0.5886022849583642, -0.38490179531439722, 0.17900972145087393, 0.30187124758336309, -0.0015296497421354379],
                             [-0.5712288996492102, 0.1733532211305106, -0.43424612049231914, -0.47520528827475345, -0.50386276903108695, 0.82509237277646408, 0.48566524921405407, -0.17266884625007212, 0.30772178627902691, -0.23733171586255716, -0.94932789120000871, -0.56002713089905387, 0.35185783346460003, 0.15656564334342762, 0.58984274391285318, 0.085022102592550275, 0.26985737698084511, -0.1689319785895913, -0.43618136527166068, 0.52839462910460733, -0.83975643765437424, 0.010610949967330779, 0.75543129157667954, 0.24394677395525594, 0.50866803283960338, 0.21521510425034671, -0.34506507593993951, 0.3742669753768374, -0.30215811576206453, 0.21438454768757467, 0.10789842081209461, 0.60105021063063713, -0.11902432887566662, -0.18603413288778164, 0.30088298523238743, -0.28038594159719227, 0.43926362707484951, 0.46488294911681127, -0.33497654212039779, -0.41078817521611893, -0.64365842987905642, 0.46784521381223487, 0.039216026782441266, -0.19275549813444656, -0.45898140269633092, -0.62159248404652334, 0.34865676870226198, 0.22650473186991643, -0.16621500835438649, 0.39731043135149358],
                             [0.19445987281049493, 0.68918510927968379, 0.39359469686608184, -0.3282153505629084, 0.006157686282385685, 0.5254241242603972, 0.61345305282600349, -0.040642643450398981, -0.14419967378319098, -0.47060932502696201, 0.26112517047792699, 0.55989469172257567, 0.047197723124668425, 0.24347655167233237, 0.074509420695271902, -0.46942804597633059, -1.0888355877182334, 0.2415675426725872, 0.31740475708398758, 0.17346782199564517, -0.13843026053589183, 0.30679030489700199, 0.16952047856374586, 0.48140173849457518, 0.26038531498052703, -0.33496545641089093, -0.21669320226793848, 0.10586073018403327, -0.20997693844299814, -0.045266911327364823, 0.15954581833777332, -0.37483573231313599, 0.11045600540820055, -0.12850719023137835, 0.059849091384765019, -0.38165884133862782, -0.33710950614110091, -0.4026172867240646, 0.266683070000513, -0.3677508971583931, 0.7401346506436447, 0.010241267854664202, -0.13436608399846617, -0.55901041912472293, 0.23577964411232141, -0.22202753376292861, 0.28355039969028123, 0.63525215218392483, -0.95167080517890468, -0.071102297588087712],
                             [-0.7254996225766801, 0.036744237769397822, 0.042740352518218436, 0.065452702630774184, 0.069775484914340644, -0.48909470460558346, -0.38651976167347302, 0.28184621060146525, 0.12695498833761246, -0.97112133340666562, 0.78616415698505238, 0.55997693196770559, 0.37156954136134307, -0.28928320154948517, -0.05142964905043082, -0.017581912623206592, -0.29345985567700339, 0.51532540245793768, -0.14245589348726254, -0.44261933603106396, -0.73711687916172808, -0.586657031741604, -0.17395400667392633, -0.1347232452702663, 0.020057712011012731, -0.12360623775849654, -0.20490676232303501, 0.0081753839998051272, -1.2278048883428987, -0.032427867100302189, -0.21474456470801823, -0.16423362026006816, 0.045849814704368073, 0.052349075457816092, -0.24758015655595489, -0.81385795049529119, -0.23778227810233959, 0.42457484907068666, 0.21727149934805226, -0.15466314460060809, 0.57733296911241871, 0.26840640395768184, 0.19808373156677919, -0.46689692977881608, 0.3473785320744382, 0.15771274611247024, 0.059662545682377117, 0.75615612234369567, -0.80413620205339398, -0.20776486254323132],
                             [0.36954287907816114, 0.10480814658115654, 0.52295161825540071, -0.42017468052885665, 0.53564380913044007, 0.32147500243209493, -0.4898775786899654, 0.010557433000629141, -0.16843004128764832, -1.0318804779111428, 0.3011546864819637, 0.12813081600857518, 0.90423367248712205, -0.045752216450596725, 0.48092243358437869, 0.35381742361855456, 0.40833749098577238, 0.48133883247081694, 0.44787649213622355, -0.15703916613390051, -0.28577435313158928, -0.59880378442688098, 0.12425201231172624, 0.046050273923170473, 0.2712920632744199, 0.27834116710897233, -0.61844957125029909, 0.35873728954190665, -0.21185417003670459, 0.078284558584816824, 0.67553198547338011, -0.084946609641806892, 0.085728104574864655, 0.1018916282301999, -0.33971822382490341, 0.32997709972390932, -0.060158276845226066, -0.14571897021541183, 0.47773864785123848, -0.49844620828532443, -0.33665587512138334, 0.22968796000519509, -0.00694653169808007, 0.66056066959102222, 0.52036492758913, 0.38901796019907486, -0.16023180520299007, 0.16104358572143182, 0.44517535483643633, -0.40636445228101409],
                             [0.16561207161821934, -0.19866702632574665, -0.65711112280087336, -0.10745159949677918, 0.017294670981934719, 0.62404779608859695, 0.079667302235972293, -0.25856378761704168, -0.60695451836611658, 0.24420088018959679, -0.10083581011914053, 0.18012980518752861, 0.26853002103986123, -0.37198121638969228, 0.12700693260658064, -0.60467911171565925, -0.1371700375364408, 0.5785341376499582, -0.1853773781839303, -0.29279241810568946, 0.024495021897551476, 0.29734126272680239, 0.10482422293673119, -0.57044706481882212, -0.29784070842149585, 0.34209962468854549, 0.016063959392585415, 0.29317298284874876, -0.13160494466596306, 0.40102396924997619, -0.69549230357517, 0.36456174037064015, 0.66505828026644886, 0.43743098992068946, 0.24738268124672752, 0.54283491215604873, -0.095298804524365399, -0.19991451309194863, -0.28952070397278895, 0.42607436345949151, 1.0406263924333421, 0.041510316143806188, -0.14802673001244698, -0.26763999392124593, 0.039689184430529573, 0.052910609753062693, -0.5026236867974414, -0.18720763557288325, 0.058095479356914684, 0.49558654314374456],
                             [-0.15362158259159539, 0.27378057995599897, -0.019100525762941922, -0.013787354612888846, 0.33935765653967387, -0.15338974458177762, 0.17998185178059825, -0.27595649220234769, -0.31941884455997227, 0.55609422678291642, 0.38727270277070414, 0.034874783398774603, -0.45227206178776636, -0.36889884725606209, 0.13518282368459061, -0.53498675886971214, 0.66706260624327796, 0.14730897515200411, -0.050548766922103722, 0.099083671851372249, -0.6186261050208377, 0.722631728462648, 0.1611688946156089, -0.17339749374005631, -0.25994993910464598, -0.25759178026382495, 0.46563583892528176, -0.46910155216004829, -0.090123656593433313, -0.21525190160243599, 0.51785567092634188, 0.64235941747114134, -0.073474013676067984, 0.0060467077099225566, 0.21919519951579747, -0.30747512715386977, 0.26657373967773168, 0.2480767158714714, 0.17837879595127684, -0.56691720473213147, -0.62438405273982045, -0.1412115984656431, -0.31216968277933577, -0.056026322122315037, 0.11707613920793519, 0.099029011619207047, -0.17575146014594856, -0.5163931096670874, -0.50790978982027701, -1.0015335150865974],
                             [0.22269369769575145, 0.086913191359785591, -0.3719498457616312, -0.2886841855788706, -0.55778393342691535, 0.059410468937545438, -0.41915879861860172, 0.54501361302470674, 0.29535920964040463, -0.0023952595728505659, -0.188410566237774, 0.68026841448799935, 0.18369864770205513, -0.43286882456944981, -0.086557414824215223, 0.18025608524435077, 0.33826263942114981, -0.35559149997765549, 0.10808481910221342, 0.11113315467622739, -0.049880959473856651, -0.14132177735565099, 0.085941710655270079, -0.41027811098497446, -0.30645764128809494, -0.42185909828978557, 0.73887488555457348, -0.19498225956336576, -0.32633671173720119, -0.10178896282967712, 0.13964192834058622, 0.45077780797991573, -0.13717924383768132, 0.1258762750068643, -0.98920417048775611, 0.12880474214147739, 0.05572298055046699, -0.31653661261045446, -0.84518405757749182, 0.60415761430521364, 0.25756236761982637, 0.018371063524745462, 0.19878245307134068, -0.25725303936497623, 0.013202732482790011, -0.23317538531649967, 0.23143988538471957, -0.058232644005694695, -0.36849432687416722, -0.012292845669636645],
                             [0.36702979486745507, -0.36721524677211465, 0.086239914173451324, 0.23547107737500042, -0.26096938365017064, 0.44471451884730134, 0.5180350986431278, -0.16961142720391892, -0.066253590156366921, -0.73932938625789302, -0.15013061253580756, -0.25153793947749398, -0.70107416215317497, -0.41751074829381918, -0.071274286895480432, 0.70741959796707043, -0.092814381181817285, -0.28735118183815239, -0.3555658951137996, 0.30678163783436785, -0.18549423165523765, -0.40897937672759971, -0.033520868794719098, -1.1601299695854232, 0.49087908727031038, 0.55211831818836399, -0.35467893937277756, 0.5722949364303066, -0.57628052729709123, 0.30739725052061506, 0.27670925799858431, -1.0117759885310282, -0.11179633472657793, -0.29319488236480928, -0.50393737029752261, 0.29840815298269807, -0.6588433178564419, -0.012185773964034332, 0.045637412924430416, 0.10549794585036261, 0.95185636474549662, -0.13316903265655086, 0.1743477895528675, 0.0075566933063657554, 0.17234555383075273, -1.1681572056693659, 0.31965761177591867, -0.74233931148974119, -0.64939704553704092, 0.18314476641016833],
                             [1.0249040431465608, 0.010283601654761524, 0.40997402992883475, -0.20369444893217056, 0.058318316548253035, 0.0099982173765148924, 0.041424927087405444, -0.1955861766814655, 0.38774217398378674, 0.36726374858242722, 0.58510616895136025, 0.47569700422076483, -0.45889049276043503, 0.51844131062567078, -0.15639221206080312, -0.026077930072054965, -0.24571576659980948, -0.81147032682624842, -0.17540996640628936, -0.51880002129519553, -0.076260878946676533, -0.30534889092789042, -0.44704195809250419, 0.82663478006694446, 0.30147958082137738, 0.435927749823175, -0.87306617002792597, 0.06497070106855371, -1.0085236223462402, -0.35409026588208614, 0.39176295178557546, 1.0320565017190235, 0.25112485178312166, -0.1121762219809907, -0.0025673239845937423, 0.75253280421996482, -0.43893977149688601, -0.07294522841313178, -0.52029498558774623, 0.20562248398978977, 0.033127088298564748, -0.41516736148708133, 0.48785881613374971, -0.31599499118537672, -0.075997718490045191, 0.13287956201870255, -0.31372262084414382, 0.11848674464037134, -0.093471712344018978, -0.079497650846078724],
                             [0.37275023178080297, 0.42878845384600994, 0.22211873155239695, -0.16289991712746313, -0.58008711758063547, 0.27909204061187409, 0.36984578690474185, -0.45584464174573358, -0.50272043652405407, 0.30790331719847958, -0.51713705258831377, -0.82036139898301152, -0.3332051579908395, 0.26502286315804285, 0.057030706668835821, -0.053741511795630525, 0.18536809988339184, 0.52116179266710772, -0.23022767856168247, 0.32076083060499133, 0.019629442049531175, -0.45919979060778326, 0.29077977900568597, -0.033848298164247427, -0.83453993698507001, 0.75529309041378234, 0.37652239033990237, -0.0021544604229498908, 0.27827249774890583, 0.75514537148778516, 0.92097868568921137, -0.12053983537798119, 0.99931471208471889, 0.1186700935192542, -0.31581900280565844, -0.13405418013452233, -0.25231529824127491, -0.18876399955501635, 0.41638869979967408, 0.52675290082189941, -0.36377177544691225, -0.58227913315889734, -0.052885147726097037, -0.1726382785655271, -0.25919810793397285, 0.017298162371228096, -0.20829979466295687, 0.048503609793447561, -0.27238235124610222, 0.11582536633030684],
                             [0.24899775761346524, -0.40647358728299315, -0.019076942834520348, 0.440044822500818, -0.38005447973357137, 0.44384783459831595, -0.17288146138494304, 1.2165441636463408, 0.37623687105501508, 0.10729715229404839, -0.60892812371223681, 0.38696020864213965, -0.37313745393552716, -0.32767653903223187, 0.14355767466738495, 0.10064184188698168, -0.50204648027004617, -0.012728514890064276, 0.66820868249774312, 0.034728162884671218, 0.24177902252752029, -0.14029341906247728, 0.78542840479927023, 0.17184375056253592, -0.24178789804949974, -0.29042609727134466, -0.26229195712797881, 0.065365219660434334, 0.57854247728665287, 0.8103954436305667, 0.60484916786520271, 0.68831098644990374, 0.18839517408482598, -0.48898196093931251, -0.55375021958099457, 0.63664013215479187, -0.8812557965397233, -0.37846216947721412, 0.43176082532537552, -0.29582159704575012, 0.35549509868373541, 0.94480660809576256, 0.1129283908231859, -0.36317298785264696, 0.064277521890107076, -0.44340564303822866, -0.20768527121457328, 0.19012966155551622, 0.42082067160844266, 0.50335816087484964],
                             [-0.31559893732577532, 0.41034944158879799, -0.39092711500444333, 0.68677372157696071, 0.34290604238242173, 0.071917867729767909, 0.20003473028748281, -0.0042182718817882839, -0.18235258221895942, 0.41846498515760677, 0.43864227250861743, 0.57729128217226766, -0.110234565394286, 0.2049761372957008, 0.43315306443275597, 0.52563577279039397, -0.690725621159054, -0.79381004564093804, 0.70234216463837995, -0.039106432032352464, -0.41366543013821788, -0.16673091642974217, -0.13389609076257936, -0.36835696173033355, 0.58856694964782774, 0.81536524801879351, 0.21723640726525337, 0.1133251100860278, 0.11379544410122806, -0.63362628199663573, 0.52951212279046311, -0.46672954850466064, -0.14626970569438205, 0.22731601462746173, -0.15969343814975281, 0.56979307919128819, 0.48424282562629856, 0.32088817768435357, -0.23128406481921968, 0.39845199499367379, -0.14721577489707063, -0.22584710500585747, 0.64014258721409667, 0.080388757402703265, 0.065758397889158549, -0.15628203945861088, 0.75051882128412961, -0.38508152628412068, 0.18430573564205746, -0.66529331781574352],
                             [-0.12372475984113815, 0.0704427660748108, -0.44049837133573799, -0.957851765928733, -0.22654071606332649, -0.31494067271334308, 0.20563614048240364, -0.093380180731995222, 0.06785243481018266, 0.99150151697397215, -0.35197698920771253, -0.50582208802586393, 0.13119931153245604, 0.23850211935993862, 0.17104412344154477, 0.22014365356572133, -0.25089059908113365, -0.27826388288326265, 0.43993722426359549, 0.40160354892590167, 0.11360827893229718, 0.51509164998952284, -0.34172156223373318, 0.037328653807770645, -0.29988907662860947, 0.063277150930283327, 0.41245441095728419, -0.077842034798928775, -0.34621680966086743, -0.22740418362197584, -0.086465705423455275, -0.22893589348734761, 0.14583424533716294, -0.072488096496628476, -0.098798783646678601, -0.12609769442867491, -0.36583997081956349, -0.50003578255588643, -0.48208198958713427, -0.18802015115962747, 0.31251228072882808, -0.033952905917425093, 0.52361095157520832, 0.0085082264106513261, -0.56733438080729626, -0.31550373812254751, -0.16437595258898199, 0.27091513364862441, 0.080570018316237058, -0.093654809829176441],
                             [-0.3618557115317495, 0.077871491689172539, 0.17088068992825048, 0.67256865076076811, 0.23034303512246609, 0.36432823150729987, 0.44518002597218864, 0.34009339900408597, 0.038613605388740799, -0.21318196853153301, -0.22750165395737229, 0.061503231508723923, 0.72378481587109622, -0.36860261012431284, 0.47147619096920435, 0.37758520338264812, -0.14846156473932887, -0.032704652489182896, -0.032552768111789809, 0.0522235430546261, 0.24800643217187732, 0.17185323016739573, -0.30548622422675625, 0.54351506324975452, -0.034661632798326542, -0.1434313021396848, -0.76973354428041996, -0.32114066347376213, -0.14274716594929804, -0.36657404491544104, 0.26407165111580189, 0.082709252825939231, 0.49363324320026603, -0.014657722212680501, 0.38995367348571708, -0.3443218153025811, 0.14378020183012669, -0.0041212488871587346, -0.059608320130577763, 0.44394086605479771, 0.67831810150754912, 0.76664305727671334, 0.61918972688757656, 0.11456135634754933, -0.60630267489919931, 0.054116378561427793, -0.24039489019631169, -0.11503342453730939, -0.16314071547798387, -0.74984503672572655]],
                            [[-0.71450478746441115, -0.18610207195126052, -0.3256162391100445, -0.46479472742796724, -0.56446366259955061, -0.4484172780072313, 0.30153984256335103, -0.44292587146796852, -0.65029514367780739, -0.79473668298676492, 0.41891755722461266, 0.26427169389338218, 0.28121581697559916, -0.20974702038526272, 0.50413595068854578, 0.28671833054066365, 0.65389972350893888, -0.82492673704529917, 0.06233670999258685, -0.051759282396444249, -0.095662941550922129, 0.34447487518373032, -0.26707569642428985, 0.21453769278522458, 0.18636155474757807, -0.34922609592876142, -0.05440213985801895, 0.32877255211607076, -0.71509330402197691, -0.06744853655721833, 0.20991568171565672, -0.1190595265994342, 0.57601501018260881, 0.06320124304915066, 0.29862209995375816, 0.19210337595262353, 0.37725060502078256, -0.18686499733517684, -0.092995903584704512, -0.099487413102724798, 0.20490203729990489, -0.24506526073037752, 0.47262490925422784, 0.39126792900651136, 0.42699351034903271, 0.18669436450364155, 0.078402197783905128, -0.55246277104477304, 0.051627395385719234, 0.16801711220108181],
                             [0.25818165785948471, 0.50842763817890468, -0.97848170222546427, -0.34259140284204492, -0.15188952923349622, -0.23335320461606707, 0.054010248539599903, 0.21142201404042404, 0.15982661920450236, -0.68147435133540335, -0.13188351543898522, 0.35330061491360015, 0.072374565634795718, -0.43923787720870877, 0.015384014243319288, 0.50306344634619793, 0.14994208606263837, 0.24607059508843865, -0.069213539336969415, -0.074454073702670376, 0.12852487130610205, 0.090091219946526843, 0.19615627190437329, -0.68952574964629709, -0.19167354229123304, -0.082336476626274302, 0.18338992060826048, -0.011206727984011792, -0.56200614352266165, 0.62561741417813921, -0.47734333012749558, -0.38053785629554865, -0.34559717438901755, 0.35955226008624613, -0.17184543762215407, -0.29121461869244569, -0.18396097655222032, -0.119168976982009, -0.2428214575636127, 0.30485829467077863, -0.063947103571556696, 0.48686022562566367, -0.10190881115049423, 0.13568670695735607, 0.45176029004774126, 0.20023573015198554, -0.47893416671561656, 0.13910984682390148, 0.11396182989976616, 0.32049438451030421],
                             [-0.49220460685750256, 0.13701179027037366, 0.21627891495276144, -0.073994701118675982, -0.12573121802445425, -0.82817482465558145, 0.20117098708808029, 0.074228136884650561, 0.71983624856054862, 0.82612058885137674, 0.48886181317177707, 0.37730110743027317, 0.28362707042459351, 0.49438755374675558, -0.080287847961968681, 0.21128615948823182, 0.20815486087344751, 0.18136665228235688, -0.45025329307092327, 0.36891269832841916, 0.10580424450525243, 0.57589185196825887, 0.30698790653073066, -0.18734971491753774, -0.27378569960375004, -0.41788750817367581, 0.96758937346380081, -0.57832687487490886, 0.14240646513427857, -0.15756414016872058, -0.66737739036518828, -0.48406407694840459, -0.38775842977509067, 0.093795920277995437, -0.36338412877105697, 0.31317404781331593, -0.18965675371824861, -0.93845648310746432, -0.078077489752920934, -0.83269242362587592, 0.49176628916333881, 0.087357986678267274, 0.16224949035277814, 0.10573648869896156, 0.19749262035602702, 0.033493976150580883, -0.52594692998330239, -0.25951729648015964, -0.079245854344548491, 0.58926451182987649],
                             [-0.012001138937622485, -0.7507962659153451, -0.18416914767642553, 0.46168220701744123, -0.0074798168405850549, -0.29758465926937649, 0.61304219543303307, 0.69731000802406462, -0.12481786073241492, 0.15294870295602628, -0.51739222705558929, -0.028463721281683653, -0.89919154615159658, 0.46449355997800207, -0.30312944279917131, 0.44074091539363253, 0.063763664963128699, 0.47346483304589515, 0.1010955652326381, 0.0064351402323611223, -0.45296651370275243, -0.14481816024792496, 0.6926998384389077, -0.55426505493668898, 0.21531509385844794, 0.19966999773709376, -0.15805844517306314, 0.55924750912853249, -0.43920002259418545, -0.10149475384060386, -0.075697024704995813, 0.37975189535445036, -0.046473625443637659, -0.010852324163752706, -0.18160981710270291, -0.34821815741414991, -0.37158517880342273, 0.0066422246062879647, 0.0064287706533800908, -0.42974650446949514, 0.45284666189406425, 0.20732653787229496, 0.54830298133370425, -0.60944591562009265, -0.69548671141546892, -0.12949064420233458, 0.44568767626679234, 0.3435801590495714, -0.25517219785425127, 0.56458800266947329],
                             [0.13601846530515954, 0.081566989826169278, -0.47782250774210494, 0.072376782290410585, -0.49772044372660507, -0.66683291351621554, -0.14107827624745195, 0.24145129649443653, 0.35947108195171928, 0.15654131400782348, -0.61987846636920785, -0.25841832831413319, -0.26731203633695133, -0.24414637405785597, 0.43750109423733952, 0.25070577228274382, 0.056459301872525659, -0.43079416924927494, -0.37906155856239815, 0.32717097426566977, 0.34557480573306781, 0.092157578708956869, 0.33381399603706058, -0.16681422453703459, 0.3334603680318533, 0.61553478022602981, -0.049039875919117813, -0.1246872286720901, -0.15630420953342716, 0.2856167428825192, 0.041413789748224752, -0.11730021058153706, 0.81502534421964068, -0.39097221258679488, -0.13106350880893225, -0.28495513143495943, 0.084117885315271534, 0.054332471464014584, 0.42802173966154844, 0.062303016334326347, -0.14121500498285353, -0.01315667761192682, 0.093932657756770982, 0.36556610679799056, 0.40041323747501012, 0.29837299875768053, -0.22574083716351515, 0.047816844161221318, 0.041093839305371707, -0.37367234044462905],
                             [0.57302087273329994, -0.10839193404409612, 0.054478267858516921, 0.15184345792800308, -0.033209381913011607, 0.43976259627312358, 0.51833905938910418, 0.029944983750158, -0.085661188795616058, 0.057528348123736014, -0.2706985251485246, -0.27342917256828403, 0.2307730002754988, 0.091236133742538222, 0.10100030450456648, -0.0032421003830885621, -0.44770650811720031, -0.69055394314813145, -0.69724445566842808, -0.1257425799727501, 0.04402179651404825, 0.15095606449506691, 0.67470842531983455, -0.94238578858085775, 0.19177862243701577, -0.44172296193145222, -0.75253723328087041, 0.10580496312100535, -0.28269951954861622, -0.31223475414852569, -0.24135641106737149, -0.014032102268054255, 0.26409947027455627, 0.27406670634568747, -0.29870608259251541, 0.14948495036396767, 0.70015402784227943, 0.28800760475221587, -0.39790059891820484, -0.14268776537972139, 0.022887960728191735, 0.2492535213581526, 0.29490832452720461, 0.054711954219078408, 0.013528864490343386, 0.57898671068887053, -0.098325070159576422, -0.074088821849406419, -0.49033859494669962, 0.19219882291088336],
                             [-0.27254659237923878, 0.14519206001054463, -0.70889403589087951, -0.21505239731106965, -0.33724832125439491, -0.21553119354633266, 0.55924921204692524, 0.0079002280384815708, 0.48027910244193822, 0.026980862050685006, 0.39496481488231966, 0.12315596427276619, -0.15274208287045549, 0.18782288707067255, 0.47032697813794216, 0.71849150521050587, 0.28891567224458903, 0.11290856935579481, -0.6623119822641369, -0.52111888156973585, -0.59412051114161901, 0.50007162862934629, 0.25797287229537175, 0.21611400867153935, 0.58757402953024462, 0.74630221470653213, -0.48313574200311393, 0.25241926125970215, 0.13934784532002203, -0.49451030029759852, 0.18288356114910759, -0.40461801121077567, -0.065090676269331516, 0.2476352084944527, 0.20737509514269417, 0.27629748786889236, -0.047513663649531371, 0.329702753112532, 0.47005695230184252, -0.78989627548353125, 0.27030231103490593, 0.29727400788090719, -0.2456723706571588, 0.4590229599664114, 0.17985633308480928, 1.1205606915801538, 0.3732724896326422, -0.0040846300082373957, -0.70614050356196723, 0.1813545002406175],
                             [0.015410745253924805, 0.26996559145044607, -0.0073914920313925964, -0.22098384981884206, 0.54013253184808441, 0.30109412432118166, 0.88757668848085736, 0.19533650927760701, -0.31831375041697935, -0.3234453758885299, 0.30203083463895491, -0.13685451018321981, 0.063596057996668981, -0.087360916105469352, -0.23527530918062847, 0.17855504120466109, -0.51107070657913456, -0.12239479885248793, -0.18207947515958106, -0.029928106458841267, 0.20085653318023686, -0.099030194630513629, -0.23673601256982607, -0.27585779618517281, 0.14490586075284367, 0.46098406063032543, 0.18039306654471082, -0.38994717368481824, 0.67962221276672963, 0.14361576044745958, -0.13058530113999761, 0.080682409308984418, -0.46382473925924494, -0.57581979137250117, 0.5229688848050229, 0.26715723166128436, -0.11718762425499532, 0.10485406896750263, -0.007225381360552177, -0.55032007297647634, -0.11553602276816552, -0.30912214299327895, -0.49621892890451486, -0.36743210810284316, 0.1811875230515658, -0.22212334092939026, -0.31052611419397957, 0.21058553132195693, -0.10241258945864827, 0.2078608750976112],
                             [0.24296652368627872, -0.60080003073588406, 0.17686654462342732, -0.88955577084260862, -0.30507602154780278, -0.062389196957046249, 0.10433410629466261, -0.49818805015374312, -0.053394730242177252, 0.45734529205524332, -0.30330856628633096, -0.33916615536447697, -0.023786405313052032, -0.64571955005366699, -0.22701365909989529, 0.25590757863610808, -0.21054816559256048, 0.04551439705217207, -0.73368738544825385, 0.58734104189619607, -0.093123394678899366, 0.27604726600046275, -0.58592710993248476, 0.7975513308192399, 0.25466369773254582, 0.34788941764219694, -0.63117942629407597, -0.065423097994536578, -0.24885310157522866, -0.10523604155162944, 0.20637764860568153, 0.3586366536454545, -0.09906988050726459, 0.031397015203876527, 0.019412696946775915, 0.46975451721715283, 0.29084099369847122, -0.17940746785305167, -0.53210843860845136, -0.19754815207897292, 0.80722488657823088, -0.16762567411936549, -0.092521148769908398, 0.079034081644605542, 0.29478793815513121, 0.27887654922553973, -0.11301250899596038, 0.27223807268867634, -0.066263146400633494, -0.25013138788286471],
                             [0.23885226344824559, 0.19577549495066687, -0.88371661088728737, -0.083272247379577391, 0.1327460464791439, -0.16257734636289317, -0.36489252895108093, 0.53670733455035657, 0.20024892376764267, -0.35537922560420987, -0.47742499726641641, -0.24759555392922855, -0.79788307508260969, 0.077771872349946064, 0.13650441166162608, 0.82588494787281008, -0.056786868429420385, -0.23219674284454683, 0.36052909474637712, -0.16891017786636736, 0.19355624158139631, 0.14535015799865539, -0.53062180056619546, -0.34144698412097602, 0.057696293890542857, -0.10855689047394171, 0.010094827557518492, 0.22805237215277027, 0.11368680479099916, -0.14087074782822348, -0.057137358624504635, -0.50820107972659512, -0.28728247080200747, 0.5383606499698147, -0.16872437962995379, 0.12748118998865279, 0.010903862374918659, -0.30120332698607344, 0.27437171035499119, -0.062538569019091439, 0.45155781233525139, -0.32317647612328926, 0.42142502118849395, 0.6040121877043827, -0.04160799990187386, -0.35412283743883372, 0.59165784170695535, -0.32145389188040197, -0.01672651576516556, -0.45346115080546251],
                             [0.14259851811341667, -0.070434152392500407, -0.26128454813974072, -0.071337841062320148, 0.24306124391941089, -0.1807556326614273, -0.18000237189107696, 0.006483132259301895, 0.0038257204904822116, -0.4066971344354981, -0.14921719312009635, 0.35392880701125728, 0.3517073327591233, -0.71419383750654919, 0.6069380109314344, 0.23375422823541256, -0.62820558233218016, 0.22895868436462102, 0.42126610726836627, 0.069244869520147856, -0.36683377022333341, 0.37609059283062596, -0.24806354941771697, -0.232679992498937, 0.38130753246294535, 0.73438093273051508, -0.029209682084737378, 0.03808264515629322, 0.25233043765934887, -0.057631994761067402, -0.089322316994743661, 0.25357796916045627, 0.49210245179970002, 0.298693480393807, 0.37815528899117817, 0.42565711502957465, -0.53476785731851173, -0.031349766204696775, 0.38350036280339478, -0.012551944691301824, -0.13141344528017587, -0.077809335062342971, -0.24339801073589962, -0.36623536400296014, 0.53137185817673305, -0.10100439249704932, -0.83328293393713715, -0.5114701450343051, 0.066289709298224142, 0.28111709824013115],
                             [-0.22190042140584113, 0.20215074404573488, 0.00076340057756948271, 0.4042434470499191, -0.022387377818842286, -0.22220169176653284, 0.15045705599388159, 0.53020933026040939, 0.78500093443457053, -0.1086291589348345, -0.10898882791618633, -0.19593576551324662, -0.0004354664440863092, -0.97495310868759755, 0.21007864584466071, -0.068574360095420631, 0.057079795110605978, -0.16171015670214603, 0.027023721036078956, -0.30833372585392682, -0.16263174771563704, 0.17984985946206264, 0.20604492245963113, 0.2155732432393587, 0.0882055022864527, 0.2223723549951841, -0.39160282759358767, 0.34093430211419423, 0.42956953990424235, -0.42116228322093929, 0.083845796599613734, -0.25894666390394855, -0.53110431996718277, -0.80779087397023319, 0.01361991287493087, 0.43246237994223308, -0.53504499670303207, -0.0071638811622087807, -0.55221497431529953, -0.69187531768356592, 0.058704605815887247, -0.076087847873933329, 0.12864838386805016, -0.48257441522625422, 0.20463423224492391, -0.24354723933643108, 0.44873013280670637, 0.16695131325979626, 0.283621479582226, 0.57494959489839215],
                             [0.63721160035760127, -0.10646543690869256, 0.5857739805316704, -0.21106567392690792, -0.77522108161703396, 0.21025392964651665, 0.3524750957191336, 0.11719516979327953, -0.59882783820903773, 0.6441380809309416, 0.22060592603220672, 0.29738925945440969, 0.037577072630059681, -0.16912174469638142, 0.097445106670231194, 0.12319520560377557, -0.054160706026772421, -0.2831184924047036, -0.69322880226293859, 0.048503320547237147, -0.28195548534129494, -0.53137485187401712, 0.23465081606949215, 0.0413661024143206, -0.41857546067948465, -0.26108222105533491, -0.68254444949359472, -0.32038247316899821, 0.82988078436429558, 0.056473835786534553, -0.58731418618330922, -0.10405223775212147, 0.63420065264453529, -0.52124679948015717, 0.83583945650842373, -0.024234261226814262, -0.10408479654990022, -1.1690652331905249, -0.21540000200555284, 0.34552460857043982, -0.92403036878481593, 0.49473899005004174, 0.098745675826704848, -0.15517400629019495, -0.4759053281022359, 0.10725976149867085, 0.12924804828206563, -0.32860219185841283, -0.19975943108076105, -0.69966315708168103],
                             [0.44922528004438206, -0.22929970661360724, -0.30212259650222734, -0.29493803177129502, 0.59154477247001136, 0.62166866643286189, -1.0844086606535612, -0.21994988696618425, 0.40218417552346236, -0.2078238540878965, 0.49663988277239435, -0.58095839254179005, -0.158134794958218, 0.39209990795095134, -0.15297700902671035, -0.49322362197468006, 0.45702965783850091, 0.031613270431449216, 0.50442978685192064, -0.11341507741129092, 0.0047075110764787723, 0.90662923493536396, 0.8277901719979085, -0.32673871489295264, -0.45291058235902915, 0.27086471562020437, 0.01879297955127044, -0.03968248545290326, -0.25879903784295172, -0.30382685236957147, -0.29540387666816503, 0.29852748129469958, -0.67858163947682526, -0.23752263630821846, 0.10453533527068602, 0.20511679655850223, -0.087010162699217533, -0.63536134443777392, 0.24016040844750031, 0.15706784323569067, 0.36902795039819242, -0.44076819436037662, 0.09343850461723284, -0.085187851680147531, 0.36000631301851027, -0.21035219338648331, 0.13900206096133375, 0.089093885449716539, 1.0151867493863449, 0.29817454707408531],
                             [0.26077946276263819, 0.6948141220874019, -0.36610093125433218, 0.51861968194732322, -0.0026545604005849639, -0.096664632444296461, -0.43549176189706612, 0.22183209289243447, -0.36048723118987097, -0.049218065649401184, 0.0015714556406064553, 0.21666790045934406, -0.36540299229285611, 0.71743749093153453, -0.12509889443810709, -0.61165196903863095, -0.86862335345446329, 0.40201700749477565, 0.10032248465565725, 0.2148279806241222, -0.068545719315112247, -0.43633263990822219, -0.13961351121431548, -0.85386518134891221, 0.68812240992599638, 0.3642052638684552, -0.42651396137583009, -0.078178094078775184, -0.50747408712651076, -0.5107417261881797, -0.32133977941652409, 0.11647811344625034, 0.42333013064767405, -0.2317522990988487, -0.16522102746280001, -0.70310624597329008, 0.32829847562009162, -0.15381013158996368, -0.73178450306826248, 0.79075023496485919, 0.34323516812710186, 0.15707315824177537, -0.79877376343670847, -0.071705466153662037, -0.54506282725515653, -0.14683583338199202, 0.35853911704734881, -0.28082508690978025, -0.5811352774348616, 0.13501877349395602],
                             [-0.10834672474644087, -0.086843180260403705, -0.017024137117560047, 0.1534704316439989, 0.1170655254503737, -0.42961934991514378, -0.099562991666846484, -0.43339293467339646, -0.56810559461384691, 0.15725557577578009, 0.45874805680069924, -0.40816994146738206, -0.34205850475370592, 0.28031957680782632, 0.15629562428299382, 0.44606792519772903, 0.15164224896812839, 0.06571747832566327, -0.45828669509773867, 0.18345638049979704, -0.22060864652301729, -0.1318711282128493, -0.18004792212613616, 0.03357994622678967, 0.13039722376757379, 0.30510619245191006, -0.4169397469271639, -0.60757016446219891, -0.051667937388652413, -0.72727745835995528, 0.29858408943155657, -0.32166816833256595, -0.36553246094130276, 0.10217445169496116, -0.5380925443668203, 0.49516383041474954, 0.23370979030121622, 0.054940614941692709, 0.54036958233136101, -0.34423840305606385, 0.033237172256967429, -0.097087929235199572, -0.33183669704529584, -0.93075842542865062, -0.028338922050500707, 0.055801991022831926, 0.46702338098436069, -0.17629040177622307, 0.38599547043521204, -0.30431065132197038],
                             [-0.5676346687180498, 0.055457700940019811, 0.43130455610846541, 0.34938822259145152, 0.46598315635399618, -1.0143934830181507, -0.6052025059708438, 0.12093781001938117, -0.31049435525421704, -0.34563713204633789, -0.093764880980329757, 0.05056679802058385, -0.45623425823639024, -0.23085186822568482, 0.057910539909252219, 0.046106474866148481, 0.28509704299771571, -0.0014996906753747333, 0.35265991044045708, 0.27375216008244529, -0.076434493880013527, 0.6585075671919598, -0.25062270793088209, -0.20189776220916872, 0.075657606326113097, -0.25398508189254232, 0.32356987528017395, -0.12979906269195221, 0.43567863216821268, 0.27134595558796909, 0.57347726512357033, 0.088421743466203809, 0.28628196232736686, 0.83972523926017006, 0.29152658072395882, -0.11866817242790691, 0.67719628570238255, -0.10318905757476345, -0.71841856299884832, -0.11297850327787548, -0.034476459263513649, 0.18109925012016498, -0.46075332739134506, -0.70599285703182268, -0.22134665543175686, -0.12323895792674236, 0.44307164137626626, -0.056802260944257436, -0.21344335980299289, -0.27297596481577613],
                             [0.089177616073763399, 0.038016001119454038, 0.023797443029819003, -0.38029803966417669, 0.13462444340235274, 0.036807768607335541, 0.10375126325929157, 0.041938807464769717, 0.33648135095975545, 0.50672118942154931, -0.48852427948245553, -0.33366918674254054, 0.52323424095591209, -0.12302960485980602, 0.32715792880441952, -0.35075671282162918, 0.51911098774054931, -0.13241473295913478, -0.12113251082935977, -0.17336419216090776, 0.63619952968399296, -0.026672963044626071, -0.24352861168043324, 0.068114446926488034, 0.40170470396668106, -0.27684276717057055, 0.025743020673647289, -0.44722475307745302, 0.21464279036727582, 0.55035269658362895, -0.19093299876115241, 0.19621530163946754, -0.018913937116679332, 0.1411154329874276, -0.11781549972259271, 0.57422810314718864, -0.071549592778377233, -0.36937290332256911, -0.40982987481457661, -0.17346203619749379, -0.43275252582495949, -0.55748979006731769, -0.12689369973285966, -0.11805610436099655, 0.20695317357049423, -0.036328573410033788, 0.75236708577430877, 0.33074071689908074, 0.16028567371551009, 0.32404739615096528],
                             [-0.084061184182134444, -0.32874754651797938, -0.67361900278899312, -0.45032118535240273, 0.43395962141452504, 0.3548824867632942, -0.18825757025892673, 0.15747982320368653, 0.17551953608316159, -0.68545755319005697, 0.67658756592343028, -0.5719104929447012, -0.035550527615990431, -0.15564128328132329, 1.0583269224099461, 0.38814166793207744, -0.14084518218578032, -0.13234694436302891, 0.56735764025402868, -0.25356941140874628, -0.10769142256971578, -0.22916540378611353, 0.55222836390994223, 0.70473999782591401, -0.21789345793876033, 0.29041610349596902, 0.56697191600596242, 0.26584234912880433, -0.31999571065406623, -0.34841176084172509, 0.33084114487355148, -0.27051500470333928, -0.49920323415919499, -0.54402926165704635, 0.32139275602420775, -0.13397136063321113, 0.37253078127011258, -0.0074773893845857219, -0.43790789642148908, 0.22409876186861677, -0.070719803970842376, -0.078084055726612436, 0.15890626048231887, -0.003388949472008477, -0.24219994241498738, -0.42208010602139839, -0.63495491823880812, 0.43738503285548574, 0.20566217566593314, 0.052340034695334652],
                             [1.0850089639641023, 0.61097018517595791, -0.012045697143991002, 0.16318874993054958, -0.34982961455615019, 0.0073158939771520619, 0.41834728626742473, -0.79882623653661056, 0.35490207954148373, 0.18610544078272026, 0.31110041288704549, 0.31356577926389878, 0.06241733263190162, 0.36034372501617651, 0.31381306370993739, 0.058724016185672266, 0.57837866545336203, -0.42889922894704735, -0.20709368730174307, -0.071966830957286454, -0.24014340240177134, -0.41780094813792301, 0.22677252745563478, 0.026478974784604273, -0.67725311479104411, -0.14743524077994555, 0.1191833677399539, -0.32712757165921497, 0.20535292997234175, 0.23751587598544929, -0.018415818665829156, 0.24217425611559484, 0.40518547393053744, 0.33743947970149807, 0.096048470608876335, 0.25511093774790361, -0.24615077359175067, 0.10078216364136842, -0.45446519948241815, -0.10392455436950584, 0.077156748235263084, -0.24378347400699166, 0.5213744993591275, 0.67063367357381776, 0.47517669622500858, -0.057801904290193648, 0.035748544833968603, 0.016325005969916522, 0.15256743129656558, 0.052806129764057734],
                             [-0.89812187345684202, -0.12090402129023317, -0.61274979938739504, 0.24346112983988058, 0.51211111519656405, 0.36856937156094594, 0.71029148925551966, -0.38072867733568327, -0.13446342990491952, -0.057427774755618846, -0.12837426158220622, -0.31233181777279001, -0.52377224984282222, -0.24898155230906477, -0.22366708524511733, -0.28163197600932605, -0.83480122150746006, 0.67894234693012745, 0.63000922847839413, 0.062290627248622762, 0.28856610138140587, -0.20111302397166195, 0.15046228626565367, -0.005886584714093368, -0.18023106012522799, 0.52650611964839034, -0.15927701910333597, 0.42558991445503402, -0.47401578631601254, -0.18336608754916014, -0.33038352094228723, -0.77747588116574484, 0.20685830706160505, -0.33092330239339462, -0.31442748395366649, -0.10079620537361753, -0.16659640253856373, -1.4056613253748664, 0.49810093011627243, -0.12665460866719033, -0.17948455334302962, 0.32766306148437097, -0.039026009942746659, -0.30582261179651832, 0.20805485038772734, -0.43152163200044785, -0.43174886129963957, 0.55644710220053661, 0.064026044695226519, 0.0099762129527327728],
                             [-0.17003875094924395, 0.12832700908018538, 0.040158030500093464, -0.043410264412962363, -0.2787217374934039, 0.00054542167362327948, -0.28341138446061276, -0.12612969334697519, 0.048528476070803434, 0.81657265303220861, 0.43064074630829169, 0.19681559235011367, 0.15153241367929368, -0.070195982926666012, 0.0027681452167869127, 0.17141392607573902, -0.42635441951862446, 0.046168359937743625, 0.56788337655072108, -0.24860246500961378, -0.20773351350081881, 0.059185357450577139, 0.015770259942491427, 0.12794559051428014, 0.080895021915843301, -0.041650894453517703, -0.80808287026689396, 0.43963591083898718, -0.27903493892819836, 0.84104995016364814, 0.69719642904520907, -0.15425459813097456, -0.11479964189330102, -0.11593543784202945, -0.4667631445112167, -0.22002879064042613, 0.067188218663904217, -0.25096426414017914, 0.32575696355255401, -0.12824601433104921, 0.36856313355502646, -0.50069699557056624, 0.62851749787122246, -0.18299485394479945, 0.72886266810697431, -0.048559788469117841, -0.18741654252235945, -0.17289519710343487, -0.051030093264746036, 0.32244175858101398],
                             [-0.39498318744004735, 0.22494527891895688, 0.051768274216032376, 0.26297624239212086, -0.21950289905103987, -0.58023009622502897, -0.22371586768101223, -0.4130409434858332, -0.27185742026138732, 0.53756520294167331, -0.29611118045193874, -0.12081279303718442, -0.50519098832500453, -0.10135234353492314, 0.051634839458042384, -0.3807502243045795, -0.40775382796281301, 0.012511370199279656, -0.26197321477425894, 0.6464011409971272, 0.21295683525816719, -0.28420708071426315, -0.64431972235699297, -0.38278973674229477, -0.67592697718561157, -0.17857507927908059, 0.18090734460117316, 0.28294621482486382, 0.21494785316325779, 0.78352571936214011, -0.39704491563019151, -0.14702767433580977, 0.30119036082116751, 0.22484559491782918, -0.27544554353828649, -0.60241854497327729, -0.1797298942233998, 0.24772010190810212, -0.36858477844451726, -0.063459161776875481, -0.99852766417077099, -0.057197546225593685, -0.36912942120713077, 0.15355245806589279, 0.096475467350083596, -0.18395588095998922, -0.072560855934852828, -0.18932471197172038, 0.3408041331978649, -0.020888012863554094],
                             [-0.23636162387491133, 0.21058000761260287, 0.52866526921704127, -0.24840369839121668, -0.56110357023685287, 0.84783694577900048, 0.071213823645370544, -0.09906077641196688, 0.61133643457452136, -0.35805947715248121, 0.58751448798799399, -0.17105625324728124, 0.17372964739963345, 0.18791422848014086, -0.22173998402714126, 0.86270487208513869, -0.50716390400150668, 0.060991756637531883, -0.51370861199026041, 0.10400005152776359, -0.35783875105742741, -0.1308169977913492, 0.10265339581461008, -0.020078027674112126, -0.29078334061755512, -0.41255186332379412, 0.022282579636164163, 0.045528020248442359, -0.36475620706570533, -0.19226607346549771, 0.0022981655516479925, 0.45836955720014411, 0.18037326727244912, 0.30174839629990502, -0.027479174346250104, -0.25664821669175697, -0.47436270705835271, 0.57225507715525514, 0.18245786064877495, 0.63891693524779702, 0.20072265170160891, -0.6949054738444953, 0.057687023275420669, 0.12624894277032123, 0.38889445890476337, 0.19841095363857111, 0.064865652474883781, -0.074250193926126501, -0.0057931978563790197, 0.21745322531830469],
                             [0.45882796196296055, 0.42940927912956922, 0.23997726733045785, 0.61601044897289414, -0.32638174388444557, -0.57587343185284934, -0.57688849681911891, -0.078044965584426224, -0.10227191882630195, 0.28893472561066313, -0.26774580091704014, -0.10622670844240625, 0.01712509930574363, -0.2373399683116606, -0.13520958176646086, -0.15635639599593909, -0.32609351237996437, 0.0076408616771861167, 0.47053255282564888, 0.14641884578374853, -0.40992962891429535, 0.037353721027671309, 0.21689065228416746, 0.39771328646244342, -0.053541015471696811, 0.29439469152749442, 1.2098068199433822, 0.2826248082300496, -0.15902614194330078, -0.1670138069410893, -0.27221472814045572, -0.062831002201830868, -0.24329625474797972, -0.067787748084842211, 1.1509093871906906, -0.21030306264832246, 0.29727372058844004, 0.16872862722858575, 0.33607017152898921, 0.15019251508682485, -0.41095696467663134, -0.25452153421368223, -0.65546801027904511, -0.36300022917943076, 0.92789646701493966, 0.080602788235463921, 0.37969540837747517, -0.17090329641382651, 0.095230882337757963, 0.46965393430023794],
                             [0.55862705776737642, -0.65632893194754027, -0.05837083361358722, 0.5755826619450809, 0.017762452898375188, 0.033259647046346368, 0.22071505361687019, -0.41454851003532689, 0.037707505020559057, 0.11696508490645603, 0.65237057261339393, -0.4500478289095986, 0.53696297575503327, -0.39152957129877108, 0.42142886990657635, -0.21001691177205128, -0.19449646251252192, -0.22047516896844052, -0.070263713357195653, 0.31033195811910774, -0.25964675077639343, -0.45467678278201951, 0.043876117191697338, -0.093905444211487679, -0.26056671472290538, 0.25763338746522768, -0.05031849218666485, -0.28041962266391063, -0.28445819827625846, -0.25194515867669731, -0.14472786108998839, 0.28180922314148565, -0.35888740171042954, -0.19388779459254391, -0.23335874963161451, -0.3709148797906715, 0.33737018016929288, -0.32380219438839425, -0.055409782464885267, -0.25394929273439759, 0.44152098156149444, 0.019501822081713662, 0.33073589002384463, -0.22286284919104116, 0.035041532686136502, 0.28133722104865982, 0.54280220479587393, -0.42593984115333539, 0.51645202451902683, -0.12351158300813822],
                             [0.012472928509877594, 0.069564303638745134, -0.41860654636714983, 0.0087253647056037015, 0.11024293145038047, 0.015400307536329394, -0.97870957802008041, 0.54600717586034786, -0.12476075849712362, 0.14330329615454163, 0.69573970462894597, -0.02322779780965626, -0.14863428109391133, -0.44238252757379171, 0.0060880012005745335, 0.24050998403469753, 0.29202035831643769, -0.36710399426011442, -0.010726748435625919, -0.63053212431855954, -0.079114608573784787, -0.078975855914266119, 0.37159552219371011, -0.28883831327590892, 0.26513475118644753, -0.3793788094792841, -0.3844033903412874, 0.18633412004488856, -0.34542540115127951, 0.15395430885129116, -0.18057520437899166, 0.5030228019022801, 0.22108158821547996, -0.22243792864569931, 0.7145825126805887, 0.27864555144729286, -0.28807868809409093, 0.32547194157520798, 0.28927787875169092, 0.18614978190038134, 0.46133296894036402, -0.24250984091990452, 0.30494106787207159, 0.5565735518945466, -0.069195067507322572, 0.15512454823244567, -0.27569212410936866, 0.85079464719342279, -0.6965066005875844, 0.28116978991702046],
                             [-0.49084572552337341, -0.26613766235813752, 0.085903789095820152, -1.0118730608420807, -0.62733435448514341, -0.41388483191128833, 0.63593394447254847, -0.016468899448902521, -0.073939980195413091, -0.18521864946740646, 0.068995009602356813, 0.30709026253918681, -0.63889654935884166, -0.26080657236740357, 0.59501823498131901, -0.51334781104800686, -0.32962543394341709, 0.5199113177178567, 0.082793206207871672, -0.26477338162876224, -0.027596823591450232, -0.1666825234592309, 0.069394153188189478, -0.39760129047004678, -0.15426358354910844, -0.4678972114751796, 0.053082298664698158, -0.15191287491972963, 0.2824194137779531, 0.14901002442423991, -0.41368188854565624, -0.30537613931482593, 0.54357186023463455, -0.11630426284411835, -0.070778683505811055, -0.15409781334236014, 0.45937696680384443, -0.080503359075617564, -0.062225319424721502, -0.061845235239018088, 0.2079857288082203, 0.065028908713490194, 0.51638132968954598, -0.030312213971806626, 0.50403637055912642, -0.60548883729817449, -0.36103778174767648, -0.061158129565878142, 0.09976124174260155, -0.45686943202292601],
                             [0.4690273303227257, -0.31050802949949668, 0.006629779964777747, 0.061918542910510958, -0.11599478831823294, -0.24012711349535718, -0.099741870973250671, 0.34312662318083109, 0.1102524742861256, 0.077888228046049487, 0.21219299706096406, 0.23240389996224151, 0.088007828258295784, 0.14753198905420645, -0.223769042473908, 0.01750617504759187, 0.23714955380817734, 0.53490479635012833, 0.18150190776894914, 0.74139011813544686, 0.54949887329492475, -0.1448178036350416, -0.037653010952191382, -0.62106997392657337, -0.14697195268405383, -0.12970875408116869, -0.38034480539287963, 0.80916846293848721, 0.039013919201550451, -0.28857088477413206, 0.20108293617729431, -0.075475509411333019, -0.20690909431036347, -0.078283076374793828, -0.085546083249645952, 0.060250546907853267, -0.3807299089943692, 0.15485154292022094, -0.61728270608687719, 0.18999135908186746, 0.17823682355631748, -0.35407613337963073, -0.28820013578669745, -0.072124020110703194, 0.17314270861265382, 0.7481382378841861, 0.30209377920202812, 0.3850885304681963, 0.10478285324044534, 0.17317092433003778],
                             [-0.25836924617136481, 0.46208729405447962, -0.64905623195445583, 0.16829651282031971, -0.0081002135868357816, 1.071420383773005, -0.038101464371903031, 0.55744620054584781, -0.31820212605043957, -0.15053999775636834, -0.26913061589803655, 0.033713728768801493, -0.024027077454631455, 0.23852499172823757, 0.47011846269207674, -0.088121137516761372, -0.14818420983117653, -0.14575091416264174, 0.22136688140975339, 0.42656125403155976, 0.08150407908130558, 0.32313235034692595, 0.40644856435285137, 0.18648868537568236, -0.26898276566911183, -0.12909360324074551, -0.099447235270070419, 0.13389321109476704, -0.45691606776376881, 0.17285908061869262, -0.70404265273801081, 0.28038076984306531, 0.62449826482221193, -0.34473677454615792, 0.055397369487816359, -0.30021057155229713, -0.57164975084758551, 0.39873904997732973, -0.12545373202853949, -0.21846815397315336, 0.50107102414891058, -0.12010288494266051, 0.16823409001338918, 0.096652256192669816, 0.28678470147514323, -0.24851061643205821, -0.22702679360756214, 0.49454229904345931, -0.28988313507988495, -0.18082821486708722],
                             [-0.051326197463519262, 0.35299064556425147, 0.14915565954255061, -0.19939735101264691, 0.42837397806887106, -0.3174241672014253, 0.20706029082348509, -0.080387737118914976, -0.1151246252925273, -0.085066386459920734, -0.55386707857544482, -0.090113527861552939, 0.08633521096718709, -1.0146862684251237, 0.88833771081829305, 0.22512173421958537, -0.21994656301173521, 0.40006545739784422, 0.23287200133531877, -0.23205580211283691, 0.21632925552784651, 0.45199776848899836, -0.25117991039240084, 0.012226361058751557, -0.73924696363664189, 0.18197459823326373, -0.12626224715156853, 0.086142577740607656, -0.49005863273648209, 0.32886396354159825, -0.0070721037492304985, -0.29532708206051261, -0.052581955609070009, -0.35613165860447704, 0.35530955118488777, 0.23205449206626055, 0.12398119201555975, 0.87195486281599832, 0.40624249900712411, 0.25078580920884247, 0.3103975758834765, -0.61751872673794628, -0.026701428236239125, 0.17209701204953812, 0.24793113633130837, 0.44622722263155673, -0.22935912265445887, -0.062765368291542681, 0.056337983866960956, 0.41434573879973369],
                             [0.025854822430000632, 0.037671785215270426, 0.43524516172768785, -0.18166271266289682, -0.028950724895295845, 0.15504951774695183, -0.00083768248450300734, 0.59400813178919798, -0.23051849767782015, 0.087306415236729717, 0.18520151946616933, 0.35040992751085237, 0.23555869613301217, 0.093677188809205503, -0.30633022205691046, -0.33742203874007731, -0.93143168952772726, 0.45171266228701157, -0.34794887307673211, 0.18823663839134724, 0.14822615668800598, -0.1157962344169821, -0.19117199315811179, 0.19872514373685657, -0.62854623391238262, -0.048103519549894114, 0.90701709519917106, -0.11953872297043695, -0.74951929216147528, 0.093563590652108078, 0.45212006025089641, -0.37209447458897421, 0.14388731947669298, -0.043557064150192913, -0.069901172431885525, -0.13534534165217449, -0.045542117508559146, -0.13088645653673014, -0.18609181175028255, -0.52511046716804688, 0.084990639300948106, 0.50622670443906748, -0.41123689457104357, -0.53687690518052888, -0.044933272953135019, -0.15917977460624941, -0.281859050201476, 0.2213872065883335, 0.81495132045362373, -0.14283659740339807],
                             [0.0005068364435682586, -0.19032239977794105, 0.35348078180496845, 0.22849727004533404, -0.25684374730361026, 0.11606518976186855, -0.30241963697131879, 0.62821387450817501, 0.44491863011104404, 0.11099902955747233, 0.55842455885521802, -0.24202323026839045, 0.55294695796134341, 0.31208904830842438, -0.39450423036348881, 0.11142783491870223, 0.10627338707854861, 0.47046525680624274, -0.032749229516196007, -0.22242805883487685, -0.58476978604320518, -0.054288730760543746, -0.61149773820637243, -0.042642470705077123, -0.56601415866792038, 0.15776822722899644, 0.15912827430468168, 0.11942890585682539, -0.3573500566085881, -0.38220238493317304, -0.11255604473215236, -0.16874049651507242, 0.17227304431551188, 0.19254826969313232, -0.5971391857789643, -0.64173536259980379, 0.85114864951431346, -0.60333451055882825, 0.13192525139207192, 0.24898836826924062, -0.45059707421666273, 0.023520673756079427, 0.08609195736034278, -0.16605377635746754, 0.1391660427546291, -0.067076416404201145, -0.32215911563946181, 0.021185266053052907, -0.24201210070353052, -0.17725494894781132],
                             [-0.44135601282616693, 0.55273479926586988, 0.063333582250904727, -0.27367267519681199, -0.091229539131786969, 0.22250891848589807, 0.023422688756121343, 0.68758733467172728, 0.10085363357661126, 0.081837759707478322, -0.25133180265895005, -0.79320318145474167, -0.00029623016886319228, -0.60500831883100947, -0.22612794551604851, -0.2956387452798574, -0.18796057458380763, 0.12575099074716645, 0.2018373224280843, 0.56603726419027078, -0.25996479161185715, -0.051634585081990189, -0.25829306293210785, -0.013099059102713861, -0.27198818159830968, 0.041919462675531052, 0.080836331508884626, -0.19109856075109308, 0.1241115904876517, 0.14178833555522208, -0.17263550206198405, -0.18819666805912003, 0.21242339877268909, 0.6373917123558992, 0.37296415570824448, 0.073515891814791276, -0.13425833954852917, 0.11328655250768276, -0.16406176518120213, 0.18047455198805246, -0.008733660776771679, -0.4158949036989103, -0.018361012003449476, 0.26590318799891788, -0.247108065658945, 0.52508848010802522, -0.55171552623548759, -0.11369706530122378, 0.26644234271146988, 0.31138837568592143],
                             [0.64252944914848698, 0.11144964166049462, 0.28822280421741375, 0.56185661704021317, -0.59629895497117225, 0.50738566539526464, -0.39319648833962084, -0.30820240638481616, -0.028698439111784622, 0.062804176518144281, 0.62118512199804155, 0.26258938788516545, -0.026179719415177657, -0.59433245939332768, -0.0031309787675689827, 0.3403730626800322, 0.44043342962508769, -0.23681974234225225, 0.83985745483675012, 0.078935185185726675, 0.042110844717971704, 0.17075212312422586, 0.44156902889039129, 0.0040838224053488187, 0.10051994347669969, 0.33393942062431348, -0.063382243906444785, -0.62289939350732493, 0.2702657425861047, -0.28717820270576827, -0.42364905845873829, -0.24954114621218884, -0.095003188790826892, 0.092231187730844891, 0.16553523713761839, 0.1079022213964065, 0.12147447979530274, -0.25826055860863634, 0.11634492181678974, -0.37312081683580112, -0.58450966808476446, -0.50208889396347378, -0.69926129728422137, -0.19546425288304042, -0.54845173490500221, -0.21299401648219737, 0.51983029635749056, -0.18908693372221391, -0.80856603024972584, -0.12095546155085861],
                             [0.66175126982679189, -0.023424260009315571, -0.14766732270204211, -0.20500147186835502, 0.81613668081670498, -0.35224838456848467, -0.19049467699891398, 0.04397197708901391, 0.0085566637438662194, -0.130423952984452, 0.3450029398050462, 0.10130346347605718, -0.54022552644746269, -0.2737300305564247, -0.16093047467015043, -0.57302718329372049, -0.62654362346643033, 0.66201444815932731, -0.22726171042814347, 0.41679026988627954, -0.13806724146039639, -0.18026010737876608, 0.34465321143732197, 0.66668464460300825, 0.3352938342209153, 0.43039411555245216, -0.38037519604611086, -0.31972081591304469, 0.36710512715670601, 0.049222904194841433, -0.022228811600803918, 0.097526441419619886, 0.31124636815819801, 0.045243628163527748, 0.30856743287583227, 0.44863149194789909, 0.24853495384208316, 0.12731338768340947, 0.15941044374167504, -0.038675603857232156, -0.73374569076388385, -0.37502682581677577, 0.22602030277092428, -0.17696499945130292, -0.086652986384945271, 0.32191603416563774, 0.016226125950500311, -0.0708115178310528, -0.40777778689123684, -0.095136035585915907],
                             [-0.42202756408283137, -0.66907255090727258, -0.14383621759212739, 1.1650187030835855, 0.42310753321074401, 0.13699715629820478, -0.39765179077314855, 0.48224273510271687, 0.12393364312619766, 0.45857362057739048, -0.23827686555512048, -0.10881283046330999, -0.51136468985093608, 0.48620257889336793, -0.42440773120703801, 0.55628665753270468, -0.30579425337786476, 1.0586647767574888, 0.18852704020201833, -0.1688086404426673, -0.017406394226837089, -0.021325665093319936, 0.64120629202858348, 0.38028001806688627, 0.074695093415888481, 0.41941352685632527, 0.10151117672378597, -0.26184219667319436, 0.0020429153997328989, 0.11449372014602432, -0.10146562609022622, -0.22990923710017305, -0.077584958318626343, -0.34640423708360785, 0.13478696957592723, -0.0013544697337730983, -0.21755545279531943, 0.16514258624129383, -0.36092053431423154, -0.22251823973675661, 0.14142913902023579, -0.33868548219914496, 0.049774451189977365, 0.13623612863630197, -0.32263094594762515, 0.015726646904029407, -0.18942108391402152, -0.26261848123831144, 0.59891287045119845, -0.038448304782800036],
                             [0.44795986744312954, -0.11808897263283101, 0.61933008186062266, 0.29677260991277177, 0.9358434042426621, 0.036268989889921943, -0.32321297047320413, 0.35264965208872134, -0.33169043549752331, 0.15888556216705607, 0.26764894039534598, -0.33095721244731502, -0.41768145530486867, -0.18743152351739012, 0.14861981113663983, -0.049868058416769535, 0.43532418982131099, -0.21661591520827189, 0.38578435674322642, 0.31432667586525648, 0.084266049017725553, 0.061860716181439748, -0.17508817797363144, 0.22235379750795084, 0.86054032939214475, 0.51547016334295259, 0.030144907505439494, 0.180773364799972, -0.17674792034820858, 0.12987209957939111, 0.24053251929736866, -0.3228224543483062, 0.034540277368564298, 0.89662819900280943, -0.010437579683794735, -0.49524937291568039, -0.28064520962331441, 0.27682143685823063, -0.02157482574392823, 0.27839864864097963, 0.13825081963950778, 0.25849304166956866, 0.23918451293203929, 0.57531321798305879, 0.020366758502364305, -0.40643244288826685, -0.098254919694578766, -0.31861216331691505, -0.076998191078258393, 0.50051286817989782],
                             [-0.15166782655415367, -0.01889827408628067, -0.17002465825282162, -0.084928984098862903, 0.10231875353944321, 0.27907818401149176, 0.044235721574887622, -0.49555937655805016, 0.1518042919183917, 0.58197406144599684, -0.20112434551324618, -0.44093553481896081, 0.6577986253337712, -0.28058665192380172, -0.43442177960839501, 0.28420355514994655, -0.47206691486089225, 0.56807325015766297, 0.35763326808671425, 0.40639899807372298, -0.43526982721035856, 0.64039524077316989, -0.52740817992631506, -0.34812197503070802, -0.50965398834462627, 0.0055622581726212025, -0.24659781797028682, -0.69063043342969022, -0.076033889432819163, -0.45497309556084609, -0.13852427892239294, -0.16660881604734698, -0.052877767575360946, -0.12947108111537928, 0.12946471153386527, -0.061737016568435055, -0.41822525919475173, 0.29242953392466703, -0.24177617842160942, -0.14514429819733873, -0.7343929552210291, 0.1677405804845348, 0.15895813025453015, 0.13901788585767183, 0.3041452048399686, -0.10258715769028279, 0.45172578760673615, 0.44025062739306614, 0.44459439771210579, 0.43535276404166712],
                             [0.44596139265133089, 0.18673086820613685, -0.563340389617767, -0.47939222013813604, 0.4767453745770816, 0.51892710511448414, -0.48246770329941402, -0.35909840469439219, 0.52694277236297982, 0.26199562950355793, -0.57115472054616967, 0.3255116565117131, 0.057974294924305926, -0.0984748123322602, -0.048182006560641324, 0.26708206831242209, 0.38028172140503674, 0.18757185327496681, -0.46560640321140012, 0.26802825856902907, -0.66551922393534357, -0.4752822310172346, 0.24879405236896551, -0.73812114335254508, 0.31103693384506792, 0.002540727341221528, 0.505430856973206, 0.19068479633483701, -0.54389948962506118, 0.1202513235769401, -0.098547326906023053, -0.30076552145990681, 0.032494648242603043, -0.36372669966321247, 0.68858462518988794, -0.095774662701096788, -0.099189354380921385, -0.070578131712385292, 0.0077870705528581708, -0.13061034163293433, -0.33772268058261307, 0.05405629244521442, -0.024672482439243172, 0.012379097302436826, 0.011204432382042169, 0.3794092333521375, 0.11601546863376444, -0.26343257542202125, -0.16225093733613696, -0.070092616033495453],
                             [-0.20531871351932296, 0.1866403504611589, 0.52378233397809271, -0.28676963068920008, 0.032537530302396714, -0.53434821900184015, -0.78818035484377447, 0.21079663886327737, 0.254562276316535, -0.065288766880107207, -0.20881132225121227, -0.55086791895220433, -0.17845705930675645, 0.26982194294334461, -0.24603948446971557, 0.15763835563450926, -0.033875070505563556, 0.31209175496477481, 0.43896776866274384, -0.072773252197187721, 0.34588704858831609, -0.47267419551137596, -0.07340620711808668, 0.23934282016798444, -0.21052699893415328, 0.69986285335392817, 0.21275957237230697, -0.10519775978889601, -0.35605097890982484, 0.085417051276047845, -0.36788287455954222, -0.12550055968111851, 0.019212544671632418, -0.077526353080525814, 0.21174376803568681, -0.21726357321342921, -0.29104529366276344, 0.056978830846747257, 0.06592886576875516, -0.27721515967187338, 0.10583160769805411, 0.31398832786430181, 0.067088326309925575, -0.33156714182739494, 0.37993191154012157, 0.30425565919579028, 0.16941839869249273, -0.93014980297478067, -0.52890273825210532, 0.066971687650864115],
                             [-0.59716564279427942, -0.54250777326765298, -0.48530681509460416, 0.70511371029418968, -0.12598432930715806, 0.28513035368292078, 0.63493160167469587, 0.3976701291257595, -0.3145616688727535, 0.13745231137949893, -0.37697842029688794, 0.32351895828436578, -0.49510802481987054, -0.064943539062703032, 0.63653322560603753, -0.48004137339536229, 0.017330516010090974, -0.56140084367384957, -0.25336281663880833, 0.28167123394324445, 0.090926937807947555, 0.0057965687693835284, 0.37454176865332234, -0.06378871929556959, -0.32099187525291123, -0.21673440214662837, -0.21683700517506557, -0.39234522506714009, 0.25573435135476025, 0.25541108366341686, 0.51546098002873508, 0.58747680060478824, 0.52565011086288616, -0.82285761328575302, 0.18154612848844393, 0.39827890943395755, 0.037821031726601034, 0.14598602309243319, -0.043054619046635136, 0.020283939961722067, -0.031518620337161879, 0.50856570050406724, -0.082988397347021001, 0.092595261442289023, 0.49636847677048224, -0.35618561332320381, 0.47478167427752876, -0.44105704277851471, -0.61493211296758521, 0.27804523357239169],
                             [-0.2701751710159524, 0.12045383212114888, -0.52952449777125488, -0.32720706593733795, 0.66034214747400011, -0.17846721440494392, 0.42102730213869471, 0.32470488959060151, 0.80179641807227076, 0.37668683048476226, -0.13559647852271844, 0.53585289900752231, -0.38307985233280956, 0.41895268054381524, -0.5400840116847847, 0.39963551040911, -0.34738047064556965, 0.39659754746433223, 0.6995533499048654, -0.074008357667193922, 0.23530418253166527, -0.32538077369748647, 0.55964072900379558, -0.070141915575611044, -0.22797292306788136, -0.36950132376051215, 0.40410619386418256, 0.39440502721670301, -0.24342880527431826, -0.21380672747651924, -0.91407008901383757, 0.065089826354820371, 0.30643719435641997, -0.014371463537208511, -0.43852349105039756, -0.17932399966825369, 0.09933403487031478, 0.30371298855725765, 0.33638663019010384, -0.056652876734492465, -0.054560236451996688, 0.52197051585633214, -0.30947920477038954, 0.38607013249173905, -0.093724081083960631, 0.043204915973924292, -0.25191828698289104, -0.26132640696893594, 0.41796685431959196, -0.039674559157554579],
                             [-0.03278393177507171, -0.42865138406704323, -0.46086162112824852, 0.49166953062159918, 0.61865584740493984, -0.28911434930850805, 0.1416813542282318, 0.15388131111226702, 0.5812421534044081, -0.30622841676904355, -0.79855816088287013, -0.19374061116423108, -0.17665219161584325, -0.074553341677566054, 0.70177703200130526, -0.039946652208903206, 0.28458297679429095, -0.28024946264452844, 0.01278519770222095, 0.17327770605856438, 0.59251555124596078, -0.36473139375139707, -0.47014386191563773, 0.72187648830658158, -0.31966411051128585, -0.55826072914298686, -0.84664269447877649, -0.63260123569891247, -0.29478106371867219, 0.58176033201714539, 0.027080640472835052, -0.17215486667912905, 0.18378287921714548, -0.17056612246633704, 0.77944606339655231, -0.44333106506106851, 0.0677579310260224, 0.69816874782871186, -0.3458810009833756, 0.13594709013716993, 0.068496052333496774, 0.23219220350233696, -0.62732168844266756, 0.15683793367797205, -0.43933782798327109, 0.22539949017089775, -0.43958749521140977, 0.15617681652375104, -0.18753959120569977, 0.41819398875153985],
                             [-0.085393197955310557, -0.52094081098798961, 0.29712983406116922, -0.26987630562272386, -0.13157431714082632, -0.33168038894634388, 0.42726657056968659, 0.4557693783845353, 0.14793445359368229, 0.11534678920095257, 0.42029852862000505, 0.15173024869814997, 0.4172130699580705, 0.10634716365285649, -0.070867390220889614, -0.15215618077614282, 0.22476401684924227, -0.42562239685273379, 0.094154082617909196, -0.58356443460050955, -0.63954617844714867, 0.33712839710454223, 0.03159002932501561, -0.21467131843537671, -0.21156955192903276, -0.1108901354780565, 0.17334229353443217, 0.05495615138424377, -0.11977713551901731, 0.30572599700774122, -0.44019272470908527, -0.47503982460572908, -0.39156556969481859, -0.046328821510768406, -0.25109996821969516, 0.30487122259958915, -0.35454207496482781, 0.10666141528206997, -0.055253183722387064, 0.20588163598331685, 0.24437976802625494, -0.36291385211787752, -0.39372327027194748, -0.38214387403016781, -0.050031101729603719, 0.028268413494215976, -0.28275785924362767, 0.18853743867094547, -0.36607572982744219, -0.68062351219576478],
                             [-0.94273492913054036, -0.18919430199952136, -0.69242166060268229, -0.15163062080391937, 0.18300402665919399, 0.17635998361843652, -0.029359492754849892, -0.077862603181200002, 0.2140754753101419, 0.14778507287587309, -0.54180449227091165, 0.59269547022398827, -0.38122659670288078, -0.14145246321003818, 0.25405871897474236, 0.093021267614829123, -0.14722454841945415, -0.55981916574534074, -0.10469113745233929, -0.31202734811944161, 0.67731582159125692, -0.39781928123681404, 0.019138728565412655, -0.19291803666800861, -0.6045212865903502, 0.92399367868088444, -0.028059083886267263, -0.087468475024843145, 0.21418288025176796, -0.66424550628628753, -0.13078292107493336, 0.21428842529436107, -0.59615092852546014, 0.10437443485482427, 0.25801761328383349, 0.20982724393878716, -0.4759455996962153, -0.055831622098148466, 0.27496437585380484, 0.17138802176187501, -0.13358441389664164, -0.26378068338224636, 0.96901863879999384, -0.42028108862252606, 0.1452932566618888, -0.48755223256009605, 0.71794487364991844, 0.35450583984045869, 0.61115581335030145, -0.11868480627606581],
                             [-0.16215855113909222, 0.36161621324798515, -0.37202419614130927, -0.49622471190160422, -0.26837067416658528, -0.32158928570129158, 0.068952367173028967, -0.29340732598619995, 0.062055974583162844, -0.22169476287378986, 0.25239941588743131, -0.20782164479433482, 1.0270141462447639, -0.10140182660356151, -0.074653100567754122, 0.47830126564452147, 0.019461879291891145, 0.16163737645045559, -0.43963666754239183, 0.31018389761614484, -0.26865802186226562, 0.16100471852902476, 0.052041430524888382, -0.3439321369666129, 0.17758426887237427, 0.48791814953827234, -0.38588471953466763, 0.28257738733402177, -0.054874044077045256, 0.34826660325774456, -0.19994283296044729, -0.23274395581008028, -0.47687970878177138, 0.097226541322659829, 0.49175931168377596, 0.84793236774098879, 0.53583236794843092, 0.029148976501435182, -0.0093337412525580001, -0.35905858758423631, 0.27960201777348037, -0.25388920579284352, -0.050721642246719684, 0.40518509746517939, -0.293348274525918, -0.3370857383336055, 0.20032052099537551, 0.17490848919789606, 0.032945126786056649, -0.23885147063859277],
                             [-0.25298200328274484, 0.48225613536838846, -0.36091002526059712, -0.83121951260333204, -0.32228168366754301, -0.72402808531095886, -0.2102415856507113, 0.1576436813334742, -0.2258348980536915, -0.060355937449151707, -0.14482355868251964, -0.069192367788817599, 0.83381847545885013, -0.49723273570799237, 0.35982300983290438, 0.31712611716291966, 0.25501641931742303, -0.20719312874564583, -0.2805055789056029, 0.099359733372120645, -0.11039145573806315, -0.41753208174366929, 0.72933169679206877, 0.087003623694930032, -0.62138035346609022, -0.35167660813846663, 0.017267209669332206, 0.41977530236390453, -0.35942300790124687, -0.16889216602445167, 0.42211845261063163, -0.17859015767795502, -0.040834659736528417, 0.16201564359135226, 0.39139749631650728, -0.67523004097917183, -0.1199879854827399, 0.012688199731368976, 0.18848112064691613, -0.36646464831659592, 0.56320397630079755, -0.4856399040180871, -0.30571665475194321, 1.0525949911999495, 0.29022779723345521, -0.12105600314017312, -0.28649281070152838, 0.073825107266480144, -0.35054478142206846, 0.10133236020484394],
                             [0.12541451089359607, -0.025069404599524329, 0.64861752820659757, 0.54789014675359904, 0.3614690462805667, 0.60562439582090877, -0.23311906190108267, 0.40419476181073949, 0.073093811619996993, -0.89711320181610277, -0.29251413805374782, 0.27639515128294095, -0.1359544935290532, 0.25991878769582483, 0.39847947184075255, -0.034869939927027013, 0.20989710848136633, -0.56038112483962688, 0.36243934295055302, 0.0942845992939505, -0.22540740602444823, -0.11018153042983866, 0.62954269130513751, -0.062441258151047389, -0.35667824935635395, -0.77135870468031664, 0.063429908352430966, -0.29943965951713591, -0.20666138217004257, 0.1284895437226084, -0.40499587813623328, 0.09502549700292684, -0.037908387471665993, -0.72202461391368222, -0.050043852854865255, 0.38517553434493784, 0.049479872602207653, -0.49759263019816991, 0.19385420781167512, 0.28683958812641558, -0.44831126048839676, 0.045577612749167495, -0.40108667683214483, 0.60435252280650231, 0.17780790277350128, 0.56729450809808801, -0.53787357971132876, 0.46291942711468576, 0.11687135119681849, 0.23533577776688491],
                             [0.49991716126728519, 0.37530600065099989, 0.33629616706813059, 0.8900065779047881, -0.58456349205010261, 0.27014493065199818, 0.48477422423766131, -0.15051571880425052, 0.12865360634517853, 0.44266419334854129, 0.28791459397616975, 0.10758708245806919, 0.27798716565367476, 0.26406089662936283, 0.21367827427130309, -0.012466212511770684, 0.11236947663432001, 0.15386447281378091, -0.23681661087386241, -0.10862604734707018, 0.18161500409091735, 0.035674332767643334, -0.13353110086236747, -0.43006628621025889, 0.39038161192592713, -0.41631692599687531, -0.34465800741496516, -0.19132623797741155, -0.019510256163288893, -0.40475049544978103, 0.039810888256169706, 0.73788428683362794, -0.42740761180700632, 0.21562078787903818, 0.22478568492891687, -0.38483231405365892, 0.062491520465331851, -0.4343165384077462, -0.056559297831239967, -0.29932818740549066, -0.80352715754852033, 0.26445083354927229, 0.19150539291435945, 0.5301112399083141, -0.41480009192897638, 0.31902946909375529, -0.25427712933426627, -0.36682037530325129, -0.14716164891468994, -0.65759482740719177]],
                            [[-0.62370381609807146, -0.54736741994878169, 0.34514742055987363, 0.20223465281955802, 0.32471872675948343, -0.22835995884677227, 1.070115219353569, 0.24084161480860075, -0.14337682417918055, 0.1320966366805805, -0.027927094169288326, 0.55074363919381153, 0.31983081005330166, 0.014404405572217654, -0.088358699724567044, -0.24464184517153675, -0.10145176038696335, -0.11572348436924533, -0.17075176357782473, -0.019392753623511554, 0.094554156606182035, -0.17493183787946662, 0.66139264487981253, -0.3465433178936394, -0.22924209678664217, -0.48982102466660726, 0.1179001482059448, 0.20176450922326075, 0.56010716243623737, 0.20641993777935891, -0.22800050208395101, -0.71032483331910357, 0.3589687711995394, 0.61573591861193733, -0.33150750769588144, 0.21292599536437135, -0.19156226524445336, -0.0070730718677473933, -0.034572064597543445, 0.39847066728627045, -0.094563807952023599, -0.097207270846372956, 0.23244399813841751, -0.059816693293569152, 0.79429436352901894, -0.075680622485223781, 0.13948822882860951, 0.86643456999509394, 0.098674673538042643, -0.095201457603300441],
                             [-0.021993216624688831, 0.085935334513627643, 0.32459509765281269, -0.25168760488344166, 0.015055856302399077, -0.44001615221261026, -0.18051461816712996, 0.49329499764227847, 0.44777959227623398, 0.064198987714753325, 0.1304315409269016, 0.10518821732711299, -0.12714011594141239, -0.083517140071907067, 0.035819554249646265, 0.40761532959169566, 0.054277791388123484, -0.48707674683440766, 0.28411692911905767, 0.62426792083637939, -0.16131093214106998, -0.20326277376666302, -0.264514595383253, 0.17489379342669278, -0.20762385504423048, 0.27386356171131337, -0.12560036504878908, -0.22306750231338779, -0.14983726291164259, -0.47065079210294203, -0.42432751725370627, 0.096535204634413979, 0.069293064669562768, 0.54890531207558435, -0.72518505845486358, 0.09300483430348655, 0.44249731805090542, 0.21493262557842047, -0.31951547708910982, -0.34138539473794544, 0.39812367324620657, 0.34663456270196502, -0.099732220962231902, -0.42194343241701077, 0.20102694300310428, -0.19227629806201213, 0.11391958211582409, -0.78146686520316544, 0.65877963983133248, -0.90675214782807045],
                             [-0.33645050609401189, 0.17345040547423826, 0.027375337967652139, -0.55844184852039847, 0.22087086064703118, -0.10981499328722095, -0.059566862340627753, -0.50777096869039839, -0.03742030168461797, -0.028683811427684069, -0.33343060815054953, -0.28647553577230284, -0.050339692281770272, -0.6610411774427386, -0.067197177344204939, 0.22903354026974013, -0.20848178054065544, 0.15650539433028288, 0.063671914568771748, 0.21755938016759802, -0.31081967052511517, -0.27193552128104909, 0.075993171279244418, -0.72884833170944396, 0.2312724023371393, -0.038358613480202239, 0.29571180868505809, -0.2836347643908475, -0.029588962644211597, 0.0072484379513426209, -0.1018849183894709, -0.039190211093958302, -0.46484713008286782, -0.11154859517866444, 0.1239722354460491, -0.2232176687199324, 0.16793487207070559, 0.32221958251023958, -0.13466889940512083, -0.39415844964213775, 0.59916172343127938, -0.055245188938442789, -0.31510967618405061, -0.52612183677212276, 0.14298006286328377, 0.24751186776287401, -0.79420912611045347, -0.22440157415597684, -0.21046109517873526, 0.13699681002964179],
                             [0.54258378233307425, -0.032955202106831227, 0.15639916552032873, 0.71187291599311542, -0.18115321727029887, -0.2284634030424727, -0.092802953248421735, 0.27452878996979324, -0.32324385232744929, -0.040655665765802408, -0.46934114042353164, -0.21569886935675173, -0.1042520365948577, -0.034477418696813728, 0.27151799918281139, 0.11781058534108707, -0.60795028224839198, -0.60308758029558041, 0.47432687008821689, -0.15480060760028258, 0.14523321252282392, -0.32491095736958686, 0.19724730872413715, -0.19466471101171803, -0.37791721719674171, 0.75776576981451338, -0.43771917879372518, -0.048943259915043065, -0.3675997813041485, 0.58154530973683149, -0.29393699590832695, -0.62019755066364513, -0.44482396723519824, 0.16528531732366367, -0.11408664633017362, -0.24417879776620427, -0.33708694711385706, 0.03283507819292257, 0.020599619545960089, 0.50156552060109283, -0.62936425595770518, 0.013918588685651861, -0.02723968752893078, 0.12011789499992058, -0.51692226728279278, -0.34584212139378689, 0.50745288657420173, -0.090548876513406276, -0.3167700978214929, 0.23359096577264654],
                             [0.015341898916885888, 0.040296870923471409, 0.15176885148532299, 0.47698742569818536, 0.072926890392820798, -0.36439338555043471, 0.39919145512326754, 0.62829794658636129, 0.25179953263237981, 0.2271359797509406, 0.41393759878980396, -0.5972512000739949, -0.62430349288791009, -0.65386855774902453, 0.042000709109297721, -0.19857545278989816, -0.035155973634822549, 0.45926080766188487, -0.14657736582509601, 0.13176275029237022, -0.54869042846904315, 0.90667805602508222, 0.12214780489325258, -0.1006229904409302, -0.56343960468530652, -0.47085480617541897, -0.11059535684800637, 0.029775026763000454, -0.20121602018741411, -0.35781947035002876, -0.01273850039817459, -0.54892735875428456, 0.38226463453496723, -0.23306736820529694, 0.10863686054008137, 0.40164452417429924, 0.14818979945986707, -0.031351643353369624, 0.22525350526866661, -0.1668855783243389, 0.41331931359202589, 0.44450194356696215, -0.21310628579209576, -0.01394421854595182, -0.098799439989478488, 0.30947195755783868, 0.54052638759967286, -0.063196227593356302, 0.28343595016952172, 0.0028025515701214157],
                             [0.26708963587029771, 0.65576255094955471, 0.15180434938532425, 0.19121572660216432, 0.6218230697234427, -0.60147024274066174, -0.30131251473326282, 0.55064922031001817, 0.14337906443029189, -0.17575014189773006, -0.2138318438244512, 0.18462251998359333, 0.026615054321486011, -0.11586392457587787, -0.83560625324853832, -0.057855445987175368, 0.41498943704918939, -0.55201029633387289, -0.30858110617611118, 0.48145076267136633, 0.34299050167863543, 0.070045298606917702, 0.15235563594416493, 0.31061987940125985, -0.097000608798609694, -0.57461636301832042, 0.41392592639380543, 0.050709482204512366, -0.056440891336412717, 0.022198873907581101, -0.37653366846136382, -0.81185821166510297, -0.47956140443418455, -0.13621094906079417, -0.00044771738474843996, -0.054749333826788663, -0.05207635761113507, -0.51245227282739325, 0.26103028105494475, -0.075745279219472661, 0.28259016041788598, 0.32759638228916338, -0.19501319482467225, 0.17161421381814579, 0.1184572971840426, 0.014217459322194433, -0.36317191697360907, 0.096572721638330986, 0.17274265372263622, -0.26267954515099318],
                             [-0.27492448241228873, 0.62415176997329924, -0.086800969981223247, 0.040720108450071471, -0.32323671017319489, -0.47602872499933158, 0.16607576537437804, 0.43852029831741662, 0.36743743718631894, -0.37282476494253219, -0.20684585443870965, -0.18201329361384433, 0.48726444365325028, 0.29806355337204926, -0.36915677960304782, 0.27394444257070738, -0.26441046320661826, -0.53182339791776467, 0.43848999705725128, 0.0085173986511078124, -0.88123263334766633, -0.097792114942098801, 0.52295684037552859, 0.1874819217450365, 0.017808250186834323, 0.38838282173230371, 0.090161126393838262, 0.038745191682861439, -0.3209465122819527, -0.13022777822841819, -0.22926809918112023, 0.30989262433847897, 0.10497376832418075, -0.014890226823251258, -0.070845804748822822, 0.12668651020683383, 0.34662635948991427, -0.10660690021559448, 0.082796133999399418, -0.81310270792839756, 0.036050347100505545, -0.052622601615646428, -0.17295414335311285, -0.046968150449684012, -0.025213167846708073, 0.62566894234388515, 0.22273163867774076, 0.6974335388031051, 0.069392780291709366, -0.48526737646510432],
                             [0.10462678556235752, -0.71550667151333136, 0.26030495400524623, 0.11478591745987965, -0.32475346107222097, 0.21783407481948458, 0.45560763400987625, -0.24868824529325251, 0.76476416919925161, 0.51112071242047463, -0.40885405465318109, -0.068593928301145191, 0.12717332192954706, -0.35784655784764247, -0.14311584715635003, 0.14674435571624186, -0.17593158901067035, 0.0074377006351479518, -0.36582833621647587, 0.49239228134397894, 0.22971293561463277, -0.7432485696553276, -0.039235651204617743, 0.26091819115174036, -0.24245793185760736, 0.16677885978954726, 0.22670916688228004, 0.25602939533677438, -0.12547398450408753, 0.54683798409100881, -0.26123021941129282, 0.3631882093105252, 0.35564088064169003, 0.014952965920409183, -0.040910109074610138, 0.51011135384398409, 0.15219866455133002, -0.32114309335495861, -0.12570172783367928, -0.19637122378227537, -0.45556909564914727, 0.5109303485278025, -0.44737992396463838, -0.20426454433138111, -0.014307844417801759, 0.26132242529852256, 0.20476896098096575, -0.065428234136306634, -0.29295836202379921, -0.43454448544386615],
                             [-0.32898568475050416, 0.49739436795854203, -0.021295965114783384, -0.16052559821169818, 0.59756962829284666, 0.43736940575068495, -0.74231156707744317, -0.31857871171433905, 0.39172469171320196, 0.78046969506239117, -0.27528509684060382, -0.24952461404863546, 0.18439824825230688, 0.32754423949778061, -0.37551577507046113, 0.23407609682394492, 0.11368776488922447, -0.0086192231600261699, 0.45824489200082347, 0.091178691961787336, 0.4326783111071979, -0.076567239949034679, 0.41366166395245246, 0.20310122310902107, 0.07036577317480118, 0.18805544021707213, -0.026886268057889622, -0.093192350741893956, 0.31363733470958843, 0.14900263823876891, -0.47159351327202759, 0.73497528686171987, 0.05335818114888425, -0.14490916153173547, 0.28565542190122839, -0.35814755893357403, 0.57596101496780483, 0.43657568253930212, -0.3145129563188358, 0.68549586526172956, 0.38609290151321918, 0.095411162517389833, 0.028981886887886606, 0.11712356778169203, 0.42557128818040751, -0.28152316428572072, 0.44356133627308963, -0.1974794997850417, -0.0097571330320955236, -0.29796626762367134],
                             [0.21656729432376992, -0.063717781579321259, 0.3671065017886217, -0.036964594215029678, -0.43861949032983794, 0.55279983900886276, 0.10986971854949766, -0.25040188636898719, 0.48186268409339605, 0.41852289065229925, 0.23552598174315365, 0.35259150431936592, 0.065233787452178477, -0.12221619596278349, -0.45264399942412742, 0.33293003156020212, 0.20504264481891002, 0.14839377751172192, -0.081211375929567314, -0.29857205455511276, -0.87667593398911359, 0.19904228735090509, -0.2136691234088976, -0.16526080312152916, 0.55857106529283762, -0.15176702073105131, -0.20432856598711624, 0.41213933407788739, 0.10970292400487122, -0.54965204463761208, -0.092660756244435163, -0.31402343175060421, 0.42036038565796996, 0.44611256851734421, -0.40997871041421008, 0.15943197554392238, 0.15752766896431711, 0.32531185729513334, -0.040423534328878928, 0.14164129081344842, 0.0011427448283286138, 0.43355969818017831, -0.14038603380200035, 0.036636404906571898, -0.43945892265166009, -0.070867238791893356, 0.0093308589394246379, -0.83115453171541898, 0.13514991306312502, -0.33685545994546345],
                             [-0.29957730371587604, -0.30266949963963502, 0.36518498179040509, 0.16862227590099194, 0.080330488706642916, -0.91988760137792092, -0.1662959272619231, -0.30176803965677601, 0.1742322231290544, 0.12252930010242695, 0.2237901255637329, 0.20991388023645846, 0.42945563982847018, 0.0089775709219794553, -0.38660053225939728, 0.27905198767053835, -0.021610471120890803, -0.39195108989413224, -0.48862575815616516, -0.34277826302327102, -0.1675507729641203, -0.13096345901986559, -0.35445766516831301, 0.15540567116754153, -0.1073591176124033, -0.21587258108601934, -0.23834070865200607, -0.094761228474044154, 0.29784626336512238, 0.11728027900149079, -0.06022566916926976, 0.48129036539973291, -0.29052958371039944, 0.14622051473209427, 0.008215447675312449, -0.45034141241502962, 0.31667052438898063, 0.21510574744276062, 0.15183899061294381, -0.22501050905352155, 0.55823558594317257, -0.18070896180884019, 0.12648110652706379, 0.039021798503166998, -0.11182015685296784, -0.42386366282936044, 0.32953988732648143, -0.0012801789133751245, -0.6471359502485492, -0.062714931066013557],
                             [0.10334151021785885, -0.43909953222643017, 0.39125868842994183, 0.56042523691883295, 0.25955628195656411, 0.15691345248652264, -0.55375520813980961, -0.27807097014577858, 0.16101724798745484, 0.015396338174218618, -0.20200602922421956, -0.012345864402025964, 0.11062125448631516, 0.38374399507560414, 0.044649114640088285, 0.24194321183574138, -0.34873418997149364, 0.2837809038224946, 0.53660099273765061, -0.0032755426302983458, 0.10555146845727889, 0.058264223614386677, 0.16818803784101, -0.32633143387791547, 0.027732992214939793, -0.12615551527984586, -0.47545120564329646, -0.43268884730287566, 0.2802241732707022, -0.36320859387558285, -0.16234724029953132, 0.12219455816435916, 0.4839876079584603, 0.040271939443030161, 0.27055923281719668, 0.0097210509153189406, -0.49787724544989048, 0.41937961247622901, 0.68892562080539799, -0.50712267381768872, 0.35391042128998934, 0.22620319504643399, 0.35251398609016882, 0.080260609435555297, 0.3919499682466781, -0.029519546724987758, 0.21809441434432691, -0.027238316600369256, 0.050578113657087892, 0.27031450481282898],
                             [-0.27493283097269577, -0.22661391073378978, -0.40596213742062903, 0.018180523558035788, 0.11126231754792637, -0.23624461156477278, 0.073057242736714031, 0.22165984597327326, 0.6006927555787992, -0.45457743731763012, 0.16362648336289401, 0.28305739709791028, -0.50075184543816109, -0.22930959035280093, -0.37043286630469768, -0.041181735312229129, -0.034796179209478847, -0.53499119884492019, 0.019423890054996007, -0.089782123515844095, 0.01417590014682784, -0.47004080763751382, 0.2402673824578575, -0.22333585439996864, -0.82900762383725779, -0.31872268010865656, -0.02574572986051045, -0.31106009275610585, 0.39444860762350964, -0.90582115302613375, -0.44333233422283036, 0.16188764760511543, -0.11316677195931585, 0.37813426424504831, 0.2634548199334994, -0.97511304930163234, 0.45796973544174013, -0.46368659686733782, -0.14307677884494605, 0.75098673509954839, -0.026657253320256168, -0.08463780059343165, -0.10197951506651637, -0.0029738718972768113, 0.030492746657406811, 0.77860820671902187, -0.28003033278342709, -0.10866664650388348, -0.089709535445270383, 0.27873158745292953],
                             [-0.090179196295903194, 0.062235280814095843, -0.25280202667425944, 0.60579748859578242, -0.35763343097810635, 0.53925046222199202, 0.36580956666085646, 0.31670158373395696, 0.13667692611917015, 0.54376218402515375, -0.1220164575661017, 0.57854282011360947, -0.12779014565239347, -0.13876558797991614, -0.07457720346434081, -0.42128690094299964, 0.3757674584151609, 0.39410808445788231, 0.26279956823259298, -0.37938818400699031, 0.36100556958448476, -1.1257699625419917, -0.86860511911537186, 0.14373971081485784, -0.16224706326401711, 0.50998564772331745, 0.49429751693703905, -0.030911352831329564, -0.47686674007160379, 0.1409156110748816, 0.11882865996547505, -0.34286534559770554, 0.47017601761528571, -0.36242975969930774, -0.27328903518954328, -0.41861588750905282, 0.67813035761773499, -0.21273295253551722, 0.53460268797340782, -0.070713924737863781, -0.052698286067237601, -0.67824652365740679, 0.40972044190890988, 0.0816718475841023, 0.13676526593590979, 0.060601908792318443, -0.059495175739800746, 0.11281229785038623, 0.12696854685801504, 0.096105201846953855],
                             [-0.06778811229103128, -0.48830579856755973, -0.59861880303075332, 0.26715724163821963, -0.13479205982272746, -0.070912342493595584, 0.21744646126041611, 0.16210415559872471, 0.44928162730227572, 0.27502182721162716, -0.46913260036788368, -0.065834875408524798, 0.14278543939996882, -0.10552229372053923, -0.37746061941827769, 0.43830503256266051, 0.16380592402671074, -0.26321412124900984, -0.12360132460255517, 0.46669494155486146, 0.37348111363754799, 0.92870481343139699, 0.1049368595915368, -0.2610919091716028, 0.27509023765597945, -0.28125010651806648, -0.29159553897364049, -0.33623245375874028, 0.023926679533456514, -0.35608051545793379, -0.031620689798782901, 0.31590621395000235, 0.14668162013845892, 0.093364633175500034, 0.0031427151548579779, 0.14380300883630559, -0.046824293594543487, 0.12204108671587767, -0.31878297020168006, -0.3623490713680444, 0.2741964682141983, 0.024541043464917395, 1.1923536560059931, -0.10544199443420182, -0.2592534123345161, 0.036326043796308605, -0.32140189530910002, -0.23108951702947594, 0.46613954836910743, 0.13863112338702296],
                             [0.16982461585573622, 0.29031164147164901, 0.30304109894040798, -0.10267475612887328, -0.27481525944066088, 0.46602633373854047, 0.6113672498014685, 0.15020443550571361, -0.12624352811764245, -0.057649865748711594, -0.2212961230608578, 0.14468841716878267, 0.49598950777334239, -0.35282380505903826, 0.39382102481860976, -0.26486864480406985, 0.42303818829981465, -0.16400224454503495, 0.091755647450932731, 0.11715922767993633, 0.45929953959985687, -0.33330159456558572, -0.01716092623190834, 0.28585305141960216, -0.69506629902989792, 0.13102522039736461, 0.19820060545629181, -0.10906449066781844, 0.098190650381354702, -0.4796338502844209, -0.26435511223223962, 0.16393712320523973, -0.1629291429288508, -0.63204041298714031, 0.61985725548750936, -0.38400092258315016, 0.092796599960238174, 0.19671692386259096, 0.30871462699705149, -0.61048384760916241, -0.17265786825341384, -0.037531048054630013, -0.052102726039584171, -0.13218875002351366, 0.22119503025168197, -0.036096548469339775, -0.042483712071709881, -0.12415919237967385, -0.82185473948661858, 0.33108704755003793],
                             [-0.00796335730919151, -0.013119254667607549, 0.2908185190261881, -0.58504700782832197, -0.19089542017360989, -0.16841323762300836, 0.1418015784659209, -0.4001628823092237, -0.31866726037827425, -0.92945289470069747, 0.13857891259314922, -0.41290929678259164, -0.037572697511534865, 0.21656053620088131, -0.33334140581323091, 0.39109000018582923, 0.32134075789836114, 0.57305452595502004, -0.11374437088962944, 0.04527143507992433, 0.94507176358241463, 0.09095273176738547, -0.20361772810917303, -0.016440049919935938, 0.046462635151988667, 0.19757120168451728, 0.059645476074454876, -0.29656103943921891, 0.44922043631099334, -0.15249378397567603, 0.42297488562072949, 0.24277388168270311, 0.023591169786406761, 0.28986411451129346, 0.1230266102493362, -0.32702800852239233, -0.036532583364863876, 0.43283095052859816, 0.030598330687324975, 0.027971787422825297, -0.093242716551042854, 0.23124473672465712, -0.0883560471344636, -0.34087392616891565, 0.030791904792020888, -0.1720067835651661, 1.0782922615162027, -0.28069787987136074, -0.22682438952682257, 0.5189553588258391],
                             [-0.15503169477030898, -0.096367114407441154, -0.48066817238456333, 0.032022340928241744, 0.50671021799512528, 0.22156761681739162, -0.15301046105291904, -0.21772847507531784, -0.20665774149759195, 0.039107022741049276, 0.25245973870961302, 0.008973521188774803, 0.40017817044705084, 0.055593921153961709, 0.11231524052013017, 0.71442591909990605, -0.17263293832889573, 0.47011660607663291, -0.63541759956797328, 0.14630632463063942, -0.42438141760695819, 0.29340066500458589, 0.051474939017754316, -0.2148087646596229, -0.0835937826665894, 0.44721222693531332, 0.43678281666851382, 0.30485773116535703, 0.21018863426124842, 0.64109477463771836, -0.10335216468875845, 0.28269062782411664, -0.61794844192322129, 0.14479167465669912, 0.33654868046682457, -0.28469397571869609, 0.24778549227893981, 0.18933724950895692, -0.28188935975381146, -0.5989838923130838, -0.14094968356692864, 0.42855541265566194, 0.10026302893705319, 0.1101487545466027, 0.52076683888221598, -0.17167153076968095, -0.10617988888332301, 0.28753289320604009, -0.025292848580444796, 0.51903576419897279],
                             [1.0153079302254568, 0.38589211236963283, -0.27168280193388245, 0.20831288640561713, 0.86840935237270844, 0.47912494693921776, 0.73591055702937691, -0.49933217667042118, -0.2369822238506008, -0.22585457072969298, -0.015970161351851773, 0.27502229630308317, -0.024070488295182435, -0.54604076579481675, 0.48029346072755791, -0.55863590472347502, -0.5342481898801148, 0.24092619552923886, 0.025618340103484682, 0.18377360278193611, 0.15774384654759618, 0.61895312388180379, -0.46316284596547341, -0.087618688314897261, -0.053220981595735219, -0.39314216585724021, -0.24363698465692407, -0.16707741547868332, 0.055801639179631352, -0.20653231136471176, 0.15499413746031732, 0.11750907959573585, -0.040566715655188434, 0.30617726863628081, -0.20877233096663228, -0.047073575295755496, 0.3018485094195385, 0.061709231802794619, -0.29712231483809781, 0.063856842585750473, -0.38995373556230334, 0.49960108814423387, -0.1242322094135625, -0.086203436910552961, 0.19264895654338962, -0.21360786951773472, -0.17375538465811369, 0.30141601797264178, 0.088619812221634564, 0.093040480519927554],
                             [0.6889091804912274, 0.29862271052993206, -0.16180991201361766, -0.0010520632746762668, 0.60795547998215549, -0.42042081379582674, 0.13011430839765395, 0.36728127453215587, 0.35645839899803439, -0.036282158582396987, -0.566650130183314, -0.37631418884407386, 0.15497436710844603, 0.20388333246665025, 0.61642455041454214, 0.16435157013728216, 0.13027007241096983, 0.28996721263125036, 0.31061762045448399, 0.35650344222178781, -0.05396884889832413, -0.34351073925031039, -0.028211876541241993, -0.32417834923247446, 0.79098202141963225, 0.24267674764653324, -0.023277136339581197, 0.46216962162131259, 0.42825087503286735, -0.25487947816784728, 0.054308069407279322, 0.11102086868139682, 0.024645501316412202, -0.36070545991222253, -0.084218173612547326, -0.13092070461722041, -0.11402748823792087, -0.4606599659539935, 0.42954122931859312, -0.35090423350699429, -0.23548344761170048, -0.093833144258722509, 0.16006897480518406, 0.73829593693180551, 0.045989798767728657, 0.25175031655582031, -0.55753721559551672, -0.28761130255529799, -0.091997231639727201, -0.31170452780516694],
                             [-0.34591340930462783, 0.66939709906266676, 0.15503001891805016, 0.11231586643595834, 0.37732947508464965, -0.45546061734727727, 0.14805407764880313, -0.23380826760970302, -0.66309761712423054, 0.28371637961556828, 0.03905972735267059, 0.030363088377635118, -0.39810628446794988, 0.4416236473281735, -0.93081017752386508, -0.27142389386623311, 0.19868408486209116, 0.086621741724398793, 0.3992080686709234, 0.0087527711346516782, -0.25942373530549456, -0.41610260304611801, 0.38929853356855204, 0.46031283371431553, -0.38836557357215323, 0.26082659029419775, -0.19346569712822204, -0.10298397554282795, -0.1681500474617047, 0.18452076901521852, -0.37233987511615707, -0.21231437090042632, -0.23640648377442114, -0.55445495883276052, -0.13527249745291198, -0.020213720956235276, -0.16711959837496398, -0.076141686906154388, -0.12681305890659839, -0.57159392941261888, -0.72092824632904873, -0.18013734375487986, 0.72915860949547184, -0.46930100251261125, -0.076210628330236285, 0.37446094422649967, -0.026666020684359928, -0.36534216685963522, -0.080122942528752739, -0.19623941511501491],
                             [-0.61829910484984751, 0.095177822769428613, 0.21518407816236942, -0.12328167280540972, 0.2531697376891871, -0.14698418460130735, 0.27666320072999018, 0.25300231632271986, 0.090071230399219382, -0.088996155653347786, -0.12443330089771222, 0.63840423682275305, 0.35909857292380348, 0.11316567820076695, 0.29853072287240934, -0.05290805087897419, -0.093738760666081236, 0.18753965468021938, 0.11151314001246895, 0.0031723338179750265, -0.32587180581198244, 0.20609025547204601, 0.371352105930775, -0.13365856860379591, 0.089818284259134434, -0.12558605296240205, 0.014474435701390138, -0.24044514840697395, -0.51535386994234023, 0.46348543010924964, -0.2057451302936677, 0.51888147558338282, -0.30576001106985046, -0.31386290233011882, -0.25663537368608902, -0.75642730991048168, 0.088812338925565115, -0.55052774255917947, 0.090299404234705491, 0.31736495622350053, 0.029344848724008648, 0.68193688684573284, -0.35429759897596064, -0.0090418171294778943, -0.85989038098333725, -0.31581611996474412, 0.34296472365108066, 0.31343709858704255, -0.35187169292878634, 0.14074022207454212],
                             [0.18780394811656537, -0.18067638277080175, -0.58433270423384742, -0.099039460591019923, 0.15554095604756013, -0.26990631751769911, 0.070464577975605291, -0.13794714534995364, 0.68312979964316978, -0.033595036769454356, 0.10990979105293185, 0.48681206784117426, 0.36438370567577938, -0.12157533366165754, 0.25059702482519941, -0.1373330349136315, -0.3326212780562835, -0.54665206513491249, 0.61690168865997308, -0.12989864112452659, 0.13064189887099414, -0.33974087000933673, 0.017650844291659883, 0.68351304652534761, -0.15584373105398355, 0.2121162638962526, 0.2378761325593905, 0.93036629435659501, -0.39455623151053726, 0.20064287273235742, 0.6821805468272103, -0.58108597206183144, -0.1260196396260001, -0.49450951814369842, -0.29704311156103591, -0.2574078319578707, -0.013535413794952626, 0.062341802199629787, -0.27650984113680782, -0.23035450468257637, -0.16495063602756516, -0.020034893268744441, 0.010084223261635541, -0.16075067191146389, -0.36570712658760218, 0.27660622037107035, 0.16675230564983196, -0.14424702576452614, 0.16223092228710922, 0.32634747854017471],
                             [-0.24026181802350802, 0.43159414255610684, 0.50686317031763672, 0.0045450769778298469, 0.05990889239409633, -0.19155943866318065, 0.3876952700679801, 0.042573714992640614, 0.17632870189638458, 0.3335469662598099, 0.11625900725027651, 0.11799526379912814, -0.65400155340922606, 0.12236515071458115, 0.021699168305274918, -0.17262938415730741, 0.34453646419479816, -0.71987186728393326, 0.16361394692995446, 0.091566488138940999, -0.32945311042909825, 0.074307189461797374, -0.010917111856178861, -0.095435806796010506, 0.45795146810373139, -0.95800499281051243, -0.42104843022854194, -0.11623303100641719, -0.76107468281785562, 0.39195892557020628, -0.24343154508490283, 0.36874482266342135, 0.1040865097004534, 0.02022402736244449, 0.27732656147093337, -0.25272773965123296, -0.4270092606250166, 0.15049827679814448, -0.27240465920451512, -0.13970468168448194, -0.11716700187164632, -0.34381593201950644, -0.49182918242704349, 0.23366069780396592, 0.48562658864210861, -0.47158704577221267, -0.17257305472882492, 0.23118541181782482, -0.0303589288164147, 0.65035401071829713],
                             [0.10507373327346931, 0.0078952237496785899, -0.12134821810716045, 0.16268857954748295, 0.25722247186854375, 0.51375675298065493, -0.30721329711582296, -0.39729168431144024, 0.17172019858134829, -0.28797745234224992, 0.28426942093484248, -0.50845240077961595, -0.084467869038104465, -0.61238917508510238, -0.15489603678288932, 0.11844624973917459, -0.20203409401567557, -0.28585779262359873, -0.77564523777609784, -0.021426581848357544, -0.44629676170023636, -0.60683618844074294, 0.080787876840285128, -0.24834895832669129, 0.20612180814721803, -0.12009781307507818, -0.4819081179381427, -0.15027527426957291, -0.21684989022072781, 0.22533867584101616, -0.3939325457936842, 0.060545120720048584, -0.38247098260275147, 0.0052363608329036304, 0.27563588754612989, 0.34385484215756995, -0.094687777611068141, 0.17499005378986435, -0.24169496168568708, 0.58802344702755271, 0.0027968830067618897, -0.12660955780152444, 0.69001182175348308, 0.68056206562786747, -0.4650348514864851, 0.23639727074457345, 0.32036380485751381, 0.62444148136562361, 0.55083474791416864, -0.3133686596168373],
                             [0.62854357761068558, -0.2997872992474801, 0.48092573848061726, -0.10986138572358631, -0.11868173593704923, -0.0086026941960248154, 0.1896152590370872, 0.2661724027049357, 0.23581975042978121, 0.26183842918354805, 0.26045727743598512, 0.44793486508815888, 0.18609887410088205, -0.07683844109412924, -0.52613699093864597, 0.36055844234807755, -0.23631212979211516, 0.058201620707221083, -0.36448937056818531, -0.0359696892631629, 0.28749703786992975, -0.39442703932558887, -0.28625237392658964, 0.023125608194725776, 0.3150408575307147, 0.045015831568874141, 0.087424284297979882, 0.13999645569285959, 0.24539432095216698, -0.47716757323125758, 0.32109381334218723, 0.65866839082466655, -0.082081703710359027, -0.94184939813244117, 0.029812379955632989, 0.060426420112764306, 0.06154391034737007, 0.49876394823342785, 0.019711969451452434, 0.14220020410881234, -0.25044615332033893, 0.11409463939084999, 0.13813515727945339, -0.10940045975342624, 0.323817119369878, -0.036962694330911365, -0.31343744010414587, 0.22923217301711341, -0.11697614391778716, 0.076339561242311921],
                             [-0.093999425569057118, -0.34305967753280714, 0.17344243703957613, -0.41281227381686636, -0.012782608131079638, -0.071248360568150801, 0.25651886573698918, -0.45363196477899687, -0.33385709425855487, 0.26792032987299519, 0.51862781836053207, -0.25638972939227117, -0.5640866786001032, -0.37098916198065002, -0.52552647802290253, -0.31153697056798446, -0.1974194985352368, -0.44128542423373762, 0.17435951197528324, 0.41115143195348902, -0.38943203507789692, -0.10826443048241922, 0.18653140901401627, 0.2128335083617891, 0.26400684171923633, 0.038258072914075125, 0.54126509143629786, -0.31150448666805769, -0.0099933548946258711, -0.4224890800445274, 0.65019694080113766, 0.28781054002350487, 0.19435938268771033, -0.13286012692334714, 0.33637787883947895, -0.090558269386418186, 0.57369920288132137, -0.49603163136211176, 0.49770219827539208, -0.36524116470261686, 0.46680322765754589, 0.16395795214786213, -0.34339131562089537, 0.14628818263821203, -0.037700579178347064, 0.17393577330975182, -0.29949365303972103, -0.095710206877824805, 0.17511643795655227, 0.33976194807190357],
                             [0.62051950264323108, 0.12945766734792083, -0.0071658370841134814, 0.20377770529414094, -0.30659460472113931, -0.092192841735255743, 0.33533482689608146, 0.11133632704742084, -0.12528628692642524, -0.25879243302790195, 0.029994523983483068, -0.057335929666058917, -0.59274199459398069, 0.047011550620569317, -0.024727318228112062, -0.62045772518864972, 0.16090091571354653, -0.45038063159645009, -0.12384121013537271, 0.42397415433109681, 0.12849746279967858, 0.16839064488152924, -0.41228352796503442, 0.54396014895249545, 0.45461482768491179, 0.52509689444334817, 0.3163280170687448, 0.3947737700472036, -0.27227715839873573, 0.050513654041977739, -0.62561370940026118, 0.085479592643972785, -0.24940473769169785, 0.10251831982842705, 0.40683753341886397, 0.32756041240251571, 0.1863584678178391, 0.25688381531923993, 0.15072036880601611, 0.37119713037025504, 0.14446495425388708, -0.55094931522388024, -0.17185876023497931, -0.66810238957112289, 0.16436594786688657, 0.035623432891648626, -0.016598319024424487, -0.2056318899575863, 0.25404018501180936, -0.13069251571593929],
                             [0.23252915028689469, -0.097238198210357701, 0.27351396009519935, 0.10634478334315559, 0.59094876864954171, -0.25938088543041249, -1.0473001192228415, -1.0182097413477531e-05, 0.018428732519905469, 0.15701020941685156, -0.34686844923392318, 0.47906665826461575, 0.084067050029481491, -0.046950828932191761, 0.15445432824788824, 0.2017061763515855, 0.13637579937071009, 0.42655479045977152, 0.48828195254844869, -0.18905897782454656, 0.12311539247323884, -0.19009756437964598, 0.11867424948587385, 0.033109028473142621, 0.24438459231454318, 0.26708847899916582, -0.11877974487300083, 0.43152831777430223, 0.15280722108505357, 0.10420629080521975, 0.0013345988658162652, -0.092447085940204121, -0.75176453522376763, -0.035491971964611291, 0.31911182036777291, 0.36414434631085596, 0.56787302068003953, -0.44451378412447523, -0.42874141866791748, -0.33088914117647744, 0.19930227896315031, -0.32209129255784402, -0.15742833368948458, -0.3128547222780928, 0.31797288835166704, 0.066084467331717911, 0.81416387634860254, 0.40366621346146508, 0.2893439966443338, 0.39960047804347093],
                             [-0.40271581811597201, 0.71882538550875341, 0.28860468350245444, -0.439062480674908, 0.25004137778971691, 0.12984714979444328, -0.32456191276068758, 0.18508393805483608, 0.24157739787499335, 0.048801867643301383, -0.035796353928564353, 0.50387485033396906, 0.32823641272884585, -0.04073771478740712, -0.32543598862893575, 0.060819206609994056, -0.048584785907037534, -0.18115280742601325, 0.10491962247089112, -0.28688831394987285, 0.19203454415359161, 0.24345736278435937, -0.33007831520714626, -0.15108493324389255, 0.2613946433689171, -0.18133582885622146, 0.88427808929749963, -0.6934232025732987, -0.48644950379540397, 0.12008888541936411, 0.57219770551974458, -0.20749023436993896, -0.18779155710909187, -0.2814236451405282, 0.34314613053109644, 0.71885661742422413, -0.2714604856809848, 0.43951271755597271, 0.56817252272503993, 0.086964263487329135, -0.4105406261481121, -0.10973454932971544, 0.47960577530851634, -0.070750132798706816, 0.14452131900210086, -0.21183010025293142, 0.4457581860093105, -0.9202420770552564, -0.32815714349896441, 0.042832530824488811],
                             [-0.36105032896400929, 0.66007348667019938, -0.50799168999360256, 0.090438185037538449, -0.12731613189452054, -0.39471021765406, -0.42902985261659676, -0.55446627977246421, -0.36738765764406817, 0.55760906818446299, 0.12341982882807218, 0.50167538407617918, 0.10106561322970697, -0.22582669879166689, 0.39171682832010302, 0.20719315439972524, 0.093269005988032311, -0.66137191580552435, -0.077689603741326843, 0.28221314326824809, 0.17564197239258156, -0.14597369376099478, -0.3481924113172466, -0.20794120700680052, -0.44996132257680693, 0.0099634962492499424, -0.29797119010348572, 0.49503452110495899, 0.05622100413432627, -0.25002200325070761, -0.031982214075378379, 0.16139239311823378, 0.27127612659018374, 0.20693949127517958, -0.37286165222295742, 0.13178795832043547, -0.5055226407785165, -0.54809168952922238, 0.23331441368336198, 0.33104828423034194, 0.18637994577680916, -0.019346575031023661, -0.30737326691416805, -0.21238643572487262, -0.08746314761816093, 0.15840785114852907, 0.41145755506498488, 0.14385932076140134, 0.40638288034088038, 0.14271120882318297],
                             [-0.021761192223009724, 0.3774934257446747, 0.46418970998282444, -0.28972960002324544, -0.35306820410525869, 0.33822589240338852, -0.039187548934992045, -0.11960068618219349, -0.44987015654147822, -0.12718226840113209, 0.0084969702574631874, 0.21507338549788244, -0.36714500370768438, -0.10083792183682333, 0.40408264688998219, 0.42931030427013372, -0.66950810707781827, -0.32877982839951536, -0.1009532627778621, 0.25471534000809598, -0.17049493969276852, 0.18895857878482364, -0.31704051701675512, 0.73813819457172958, 0.24534623242414508, -0.18473731800845949, 0.14961913828956441, 0.19161714862568099, 0.67139631095603858, 0.39180505337839472, -0.23519540501449604, -0.3778634928926326, 0.3116984967147674, 0.33185955313147519, 0.19054569588540829, -0.031416934905692563, -0.24107620364998214, -0.57525972949622162, -0.048594782330176597, 0.048533398966898803, 0.00092399142822144841, 0.19879247467162339, 0.42257527258331345, -0.045796727899553115, 0.33266607827853645, 0.30735374231184287, 0.15770954313454794, -0.21479559580882424, 0.17509707553188067, -0.43002048852826025],
                             [-0.63926231979627246, 0.18222032860187853, -0.50314972955479997, 0.10420506657206161, -0.1681863620720947, -0.37526435555542287, 0.13246785964109206, -0.065706836454002132, -0.19835551642034746, -0.69340786069180949, 0.11166945223225745, 0.81859705395877869, -0.49803892197927352, 0.15182053942338283, -0.34499695880633652, 0.23112555294476136, -0.03651046339271629, 0.12439407027053767, 0.52989488682609276, 0.3596146087342052, 0.26702250349202172, -0.25093473487460316, 0.095463891670131015, 0.47865384362841307, 0.38996792404861746, -0.1654258079194971, 0.052520151514996491, -0.24516410251074988, 0.074123286379574688, -0.11678945474582408, 0.21516975134933924, -0.20779387096984359, 0.039186192558634071, -0.47821567151629352, -0.01508042031162591, 0.35566894209271477, 0.6689010568152729, 0.41913020192253125, -0.070389907435000065, -0.46883746113539226, -0.099073125406393625, -0.73675601500512711, -0.29226918049303169, -0.0081148406874246726, -0.33912484777630508, -0.26779353578678655, -0.10088057738047763, 0.13526904958414726, -0.24983671464893892, -0.45359743625847793],
                             [-0.47375712432316103, -0.19220785711930613, -0.18273805687315112, -0.37220822305015738, 0.53640193551751825, -0.1140484115264903, -0.16905397902525154, 0.094395850356912517, -0.030138008586773814, 0.6299708063818239, -0.24682576022725791, 0.069836315614019526, -0.06579014670230747, 0.091364530739899197, 0.091465189953084419, 0.3035711577328899, -0.63801695006053083, 0.52325428508348715, 0.079453283375516284, -0.12789905576296318, 0.4436110417692351, 0.23315710777855309, -0.20710251379157868, 0.66151006338943807, 0.14500951923359698, 0.30676631178677943, -0.5320835562575944, 0.39497274673946975, -0.53085074130938992, -0.45649260141111031, 0.48886471021999595, 0.026346492397178026, 0.013063355527320498, 0.73875634898374021, 0.58538666747777113, 0.54952205739849658, 0.063924474497816852, 0.31436235950299729, 0.48091648965159317, 0.36934678008125138, 0.20356258164869601, -0.01231131244296749, 0.11338297115237007, -0.26677086741172129, 0.061200443024512996, 0.12984731632439087, -0.49640689168842045, 0.23413911348492622, -0.1642182637715289, 0.25448504760943719],
                             [0.16073192607318967, -0.069317153908143692, 0.22652127694957078, -0.64674397669001205, -0.027109751523675327, 0.12347792372332564, 0.070422225988961584, 0.39186015806716457, -0.064782084540373847, -0.21814002744246649, -0.78097179260496974, -0.10442941273015804, 0.14120333153267939, -0.048832071650470155, 0.15365932418657868, -0.28492220186771178, -0.20281134101624759, 0.076587081548356833, -0.60079041968818903, 0.63912513383575742, 0.044833662525535764, 0.029738003577882838, 0.013641459491063039, 0.50506195149065136, -0.3259437069851881, 0.39881887005496958, -0.99819399951559895, -0.036420108940963057, -0.23564982705967966, 0.18947432833838682, -0.29379405321954272, -0.26399163061234537, -0.22865385896910959, -0.23581740676893487, -0.50765742309908612, 0.1911739546954056, 0.013631663244184397, 0.15699081598215459, 0.066300920383276243, 0.037040517510312058, 0.65898760661900224, -0.54836328026766612, -0.13910049588549378, 0.20677606954584146, 0.05800265395102213, 0.50301739847960503, 0.62495782476235384, -0.42181485699016807, 0.16843981830959781, 0.15958144735819493],
                             [-0.043998998984589491, 0.053323383034158817, 1.0326945579328961, 0.80242397847929281, 0.31623890319203962, 0.099616906376826991, -0.13827420236492871, 0.096414599876962451, -0.082244050346313408, -0.26355298489895651, -0.45229053394570745, -0.061361597822809436, -0.28131672216608633, 0.13421965312392461, -0.33494912418515038, 0.1653511794870661, 0.19905628173729512, -0.18254262656472534, -0.07180087727387692, 0.16435804074835494, -0.46418017219560792, -0.18502429600757719, 0.1685297443344769, -0.19709254581275371, -0.4884964189545028, -0.018580041922141251, -0.14039082789119486, 0.46600213463430751, 0.0085565793441527496, -0.26325884298947105, 0.29584633228740748, 0.78906052911094227, 0.32134849473786659, 0.30806777750648001, -0.43943826478151121, -0.29756993957168448, 0.29710892250733534, 0.46842396834849659, -0.059290155760623908, -0.012867727185808878, -0.20052311382536936, -0.10291166808681279, 0.14431369441328937, -0.18360769457582707, -0.38925120575773026, 0.20289723531758086, 0.0609915254539556, 0.049106410793127858, -0.055614532393510774, 0.066860100469911352],
                             [0.17779891870839015, 0.37763697842639909, 0.36763469892834522, -0.10142240012334049, -0.3433079177574298, -0.38165477529630765, -0.21490752839674768, 0.13931378464643604, 0.45380015083374325, -0.17656093929530961, -0.25296699059729716, 0.61187352934018302, -0.29913858380233466, -0.2042704084870291, -0.25859438992127387, -0.040854133240282246, -0.2190909047837436, 0.42744184807553232, 0.51958489170704814, 0.15861978211100872, 0.18513167149257567, -0.57842435068204068, 0.4575030688415278, 0.057078838752495066, -0.28574731812966003, 0.062369381172614521, -0.053199842644678363, 0.44227616460710667, -0.013666343705861237, 0.12988713332794438, 0.19823340290863112, 0.63382546950406038, -0.12946022596998019, 0.18629456950183526, 0.50845965724702491, 0.29937980888060284, -0.19953852918341686, -0.12064270029116797, 0.096831401351164859, 0.10616763181321903, 0.633356358974557, 0.36446852153284559, 0.31707906154089988, 0.76280288269988239, -0.088844924885288806, 0.019837524538278382, 0.005608722631936262, -0.30654807722613081, 0.24329273318904335, -0.25282256850328222],
                             [-0.40784554911265958, 0.23990461496797078, 0.31896413545633145, -0.17637173833631853, 0.0024745000653273869, 0.26283300781502689, -0.5785993641260615, -0.090255695316925483, -0.43195352698968881, 0.014974292721005009, -0.13695120286264972, 0.61253963796290478, -0.088397991265270814, -0.75730618736926936, -0.20951468220449948, 0.11558597875823885, -0.76427453068216022, 0.42120811543442849, -0.26104939159755786, 0.099786237145170348, 0.23670990069415396, 0.6831798836279791, -0.24273442199550524, 0.025409960528907385, -0.099659066477595593, 0.23647050032736455, -0.19491524827862791, 0.28429928882591515, -0.32252762359448789, -0.12011643884706201, -0.57284048598591986, 0.093032638685427368, -0.18583462253162442, 0.19580992297271255, 0.46403684351493052, -0.43715872039839915, -0.087320279313262972, 0.13982667812923949, -0.07824327282936798, -0.2304859332986762, -0.66357726516150173, -0.62981841905822988, 0.13365047069269223, 0.25198797582188881, -0.24952622892661305, 0.1952633310746657, 0.39763549630666251, -0.3965675368017712, 0.46812416786088884, -0.38909073713415321],
                             [0.63770216286248615, -0.24123832745669904, -0.17079687380660641, 1.0171401601704591, -0.07433548503821831, -0.046239993757118146, 0.54209990256699747, 0.10033128464702418, -0.43993920152112242, -0.079377285249821058, -0.48618161900720336, 0.15349099357643062, 0.66788166100575086, 0.33040254911777028, 0.57070091088111252, -0.073962750737204833, -0.43248481851280224, 0.27438600030337978, 0.025908151705897539, -0.24814169279317835, -0.17977913772741239, -1.0855894147027731, 0.1765012553519604, 0.024150894534057166, 0.13786364223869269, -0.59753564528035641, 0.27071665215782381, 0.41670378615035808, -0.25100449862637891, -0.38319102290224155, 0.23338889597084128, 0.47359131758851503, -0.27415162340866145, 0.44442387482107143, 0.26713179733270953, -0.048688768212947403, -0.19324053440675365, -0.0095316138459832674, -0.43140173496117262, -0.33584808434704044, 0.29202332441803713, 0.2217634672248921, 0.16275556756104875, 0.00043599636422143873, -0.32756635261283507, 0.41546269943924163, 0.41730223101112318, -0.19491679630980463, -0.013270889597697087, -0.042326391954679202],
                             [-0.068308250140571361, -0.26693775149634852, -0.37356411171676851, -0.54910809459246646, 0.74375383518801275, -0.39173144242441943, 0.46884346512771413, -0.11026625109202712, -0.11658147996274844, -0.15872743097098546, -0.37765553651768857, 0.31531690331346174, -0.20392107760398506, -0.084361982233814664, 0.0079899725508329744, 0.14781919057675602, 0.40849024004480511, -0.35433240634189395, 0.43513764508228581, -0.59969407836399002, -0.11689926197532449, 0.41679804551726779, -0.25006696193347822, -0.44129783276427459, -0.085109185928243, -0.37823616379174491, -0.062188982066195775, 0.056495899725534281, 0.17864511360739424, -0.047525392326636148, -0.44340902289833284, 0.42150061387449372, -0.37660061500693581, -0.2924427185985789, -0.0075235185909458199, -0.27079951429477395, 0.61140396897580795, 0.32469102177034553, 0.084202655535763116, -0.16296590611065248, 0.24063049982399548, 0.42909611718751933, -0.43256387255606532, 0.10203914208105636, -0.23895289416945137, 0.54309650481742766, 0.13516819070558758, 0.1089756371543205, -0.091366062062376435, -0.23594229632536101],
                             [0.22704779220841911, 0.052288602147128924, 0.098077361931257101, 0.044496935240702362, -0.15018245929077462, 0.3354532270515736, 0.50455709227988499, 0.15937155354417587, 0.32743248934824831, 0.15036421100549777, 0.20711552809649963, 0.41850351605971575, -0.20483044552352045, 0.032682541242236025, 0.27918144157830299, 0.65320385174992934, -0.0906327681478169, 0.15822504492005265, 0.019912270693525191, -0.01241937404718009, 0.44177078919053958, -0.46182545008838061, 1.1914145676994017, 0.19242339557410723, -0.36731361261709961, -0.63395231323819934, 0.028461848947062815, -0.68500137748455092, -0.25644703125848128, 0.56930082237345936, -0.059542354467060014, 0.092117422967249507, 0.2699409221626754, 0.45040522387550241, -0.67600511316444845, 0.22011119636540166, 0.031719221568073358, -0.1336250649791316, 0.41383510035070947, 0.39536512333505219, 0.12823313453113699, -0.78964323524303137, 0.01592393743295515, -0.46516116546108288, -0.099415702381246238, -0.15754260005952836, 0.093057535311879783, -0.01634198707102729, 0.39594719334360451, -0.078934700275491543],
                             [0.045698767528781201, 0.47450792560039634, -0.10942811379054378, -0.04100131872270292, -0.17742359404393632, -0.15278651845531394, -0.1311790774824507, -0.43956002702191072, -0.35500269680677504, -0.49634455733595284, -0.028785007734355446, 0.044728249082299595, 0.040541266782749365, 0.12423013477849586, 0.57446149863663354, -0.41351936203463502, -0.390534264530081, -0.050826628343393368, -0.31207105762362491, -0.53851163806692481, 0.21121955985366619, 0.077326054168034342, 0.23123921642187389, 0.29620562029074121, 0.35810690052089711, 0.036341796831215613, 0.3654153460242075, 0.076512642822255519, -0.22064800794628389, -0.039347900257946433, -0.37588772666180859, -0.20298567130980721, 0.31662321543500732, 0.085984964489610474, 0.27311604729412281, 0.11556469129047686, 0.70257583491145492, 0.32562111183893355, -0.23827381248603358, -0.42053110534055888, 0.20280513140247883, 0.089954243975258891, 0.081824775839179492, -0.10863065874755656, 0.0049451864604028936, -0.43492659425798919, 0.11529828901551359, -0.11962480171936893, 0.18665602963467381, 0.60696069825769583],
                             [-0.072892957287145413, -0.26348862904763837, -0.18082402392433186, 0.1043849398499774, -0.55377069578439886, 0.13245556776543649, 0.057829590446879756, -0.38693015431987826, -0.080895043039956191, -0.12506276637257213, -0.49466105215197054, 0.16872739014421947, 0.17700748482450904, -0.31348284799837967, -0.32034685003118041, -0.045108252908137664, 0.81404249945111207, -0.23863699650341935, -0.18430743972845789, -0.075754988392151168, -0.38877476672956979, 0.29132107766071352, 0.46114790069579747, 0.01329447037126478, -0.27294466377198379, -0.1704559405902886, -0.03058097268757368, -0.20549212293941921, -0.91235872682026897, 0.051508421555946954, 0.13050022675989029, -0.022953664151450795, -0.010134541825889489, -0.54591972103783226, -0.080640036877842228, -0.40537768333893276, 0.31903150221677667, -0.25484035902601665, 0.48522894108750891, 0.54920592726128514, 0.014130524744706364, 0.029494483654406819, 0.013452020752947857, -0.0035159249590661183, 0.59257850913202481, 0.072512574688959136, -0.12654477976163561, -0.49936080185137527, -0.46235466394684488, -0.21691073547705134],
                             [0.37095481603769642, 0.20564724882301882, -0.36985047911483215, 0.19130635495730597, 0.34150458329110195, -0.35098936492604316, -0.025052516422793998, 0.71328794646699656, -0.12500775313459739, 0.067950559782764375, -0.30995344691008508, 0.33219161828722621, -0.14931903183183337, -0.28357872286497338, 0.27559464547893131, -0.41731888018133367, 0.34523263328261017, -0.37180118497803633, -0.44271977672924284, -0.041781670251048453, -0.19801867834606635, -0.16531322162285769, 0.2678237459141487, 0.05748761382391427, 0.041446001018943385, 0.47367022566493577, -0.06482366165313902, -0.037422618587471965, 0.19357452144787268, 0.46559479779277957, 0.35809825346903235, -0.25658872016208795, 0.3808622085538978, 0.2300860889152451, 0.047160566491796306, -0.20375045560336452, -0.42158871965619665, 0.6058052500251121, 0.023450817739213696, 0.17801958358946077, 0.030573509217389425, 0.06638910818823425, 0.096659719615373257, -0.24077086151891774, 0.098050596369211512, 0.33930782134129123, 0.52726287496077562, 0.55825559336181962, 0.14274623645240356, 0.061922925544355169],
                             [0.35238746067880439, 0.30122961189528363, -0.15470311181705323, 0.11261399047256039, 0.55819052240842393, 0.29796581680288348, 0.020663602502249571, -0.16115312752834091, 0.12174109214157701, 0.071610102172497164, 0.041078615408204129, -0.26740847360428499, -0.51078640025979549, 0.71242770935902278, 0.26641680201361639, -0.08448040938565532, 0.22563796231411612, 0.34935957871838025, -0.40833461502007906, 0.12762219637637845, -0.00051023994361134618, 0.093052436277958284, -0.21922078058147484, -0.71103034673249776, -0.14470470099851004, 0.74047793358876357, 0.56787422729689863, -0.14423517904424527, 0.049333441102934875, -0.24812726556096137, 0.43923419612228343, -0.60599546956799732, 0.30042428441121655, -0.17214532524198375, 0.39681225355479732, 0.28933919936816066, 0.052791365121726212, -0.65413507459451659, -0.33428386588523079, -0.14519068344587108, 0.36426733649974014, 0.11809037317192968, -0.27188110077813826, -0.0085503228656996499, -0.17932707158051181, -0.13608056091427145, 0.23499073115223493, 0.59082593593793964, -0.043370797151693036, -0.637511021951082],
                             [-0.15614541718651265, 0.096295715477586474, 0.048775382260836407, -0.037729822719272436, -0.56573990877893543, -0.20710724622805707, 0.12560549483037836, -0.0018249216315419461, 0.48402003812962285, 0.45725755511505017, 0.17912066380968625, -0.21158963036909378, 0.32066438298958777, 0.29889280377062483, 0.22334132813112514, -0.52093698542005851, 0.25780393957177261, -0.14309702319815049, -0.20038118389445711, 0.28820437738884547, 0.20201286061282206, -0.19735001235209496, 0.17766122211590527, -0.021230170698188635, -0.20944283483340406, -0.74899856571528445, -0.01684305916791274, -0.13100256331314633, 0.12008899093692868, -0.073728394955640764, 0.37017527946063089, 0.012410188031671864, -0.84927373691622932, -0.064874142550584088, 0.54725206702158768, -0.22528130586153117, 0.53437243642985865, 0.37934818176151031, -0.1428562849568355, -0.14751134859610324, -0.2807264370336689, 0.29456145359260505, -0.19585908590366952, 0.074589873944465507, 0.31730057624452629, 0.32857946517357711, -0.096798374553241903, 0.38348672812779988, 0.86702628049722996, 0.26900228512729335],
                             [0.0041950546776989388, -0.22918337712121289, -0.038224818715667054, -0.17235666581468007, 0.27252109446401096, -0.38333425532216814, -0.11634861132244856, 0.16325904817335554, -0.52702486399652282, -0.12639058793933158, -0.5824045920009705, -0.65893217115364378, 0.73926700972907067, 0.52181468697474676, -0.38586085201276238, 0.21502534290555222, 0.31223255198076627, 0.16866374812526994, 0.48133326406894478, -0.07404350815987143, -0.25321436654732815, -0.4135961889287581, -0.26063398306813168, 0.12411329500425498, -0.73808432268055835, -0.043049546279280072, -0.1267557061205303, 0.18090853576275551, 0.14570260209997393, 0.10381526983115508, -0.34776722479795807, -0.040572554906919314, 0.087074704502234757, -0.15579766194451422, 0.72852701772090012, 0.14572058775783525, 0.62325511490068097, -0.55278766512835831, -0.0689524943899852, -0.064554493410338143, -0.56590297941159684, -0.0068623979886989848, -0.30053771983311672, -0.74993836028962468, -0.2982349978894856, -0.092544285714936003, -0.23918270146146881, -0.087291789128613226, 0.84007519030432187, 0.20622318236109799],
                             [0.019878565583331405, 0.17422712501711848, 0.18334976607486936, 0.34233928116483314, -0.012523675397028554, 0.078030404523551977, -0.15614434081992223, 0.088330584384599897, -0.45035459397438904, 0.25121058856133716, 0.52358199095896696, 0.049257432274117732, 0.77909313633963206, -0.039928963066642981, 0.18133559794764093, 0.23750712004904531, 0.21992864655809247, -0.24572510574472839, 0.13324535879654748, 0.1933110867704004, 0.011698388742172983, 0.038595000731850113, 0.15981396616775537, -0.32572713471733256, -0.1495790499701142, -0.2411931712060639, -0.71204547430738419, 0.15240033696446292, -0.083626265991924395, 0.8232544447305743, -0.21350277024894515, 0.13403950549810104, 0.64340035097991988, 0.063817426839547109, 0.45158187849331621, 0.0089823673936464191, 0.52106339781384392, 0.39537366890088327, 0.3827820005702941, -0.17873155787440276, 0.52310553277911054, 0.15446925768478537, -0.01304740275091824, 0.19193576233423792, 0.18265818336157641, 0.56220782834172778, -0.10246227469182415, -0.092760436052307854, -0.38212885665759133, -0.053272336249185745],
                             [-0.51540020674950549, 0.20736854307028399, 0.41417813294602451, 0.95371808677074255, 0.40800639562462088, 0.03709863684745305, 0.254531921720279, -0.079965413493307491, -0.16722100505534135, -0.46132924057447339, -0.27820343529424985, 0.46260328636911968, 0.57319669926490946, 0.20200218841472345, -0.052318989575976735, 0.59592803488537638, 0.38548474325434501, 0.24913975798466684, 0.15369961718559605, -0.67753007679970201, 0.28648569936289042, -0.14837085475294384, 0.027168660943653174, -0.17403399370981451, 0.016695235383380396, 0.6969000140951348, 0.014276576111621144, -0.82549559529121419, 0.11224973985869263, 0.11167956542253081, 0.36024906539472573, 0.11808853674485269, 0.24085923722839933, 0.062340491454916741, -0.18704032827982453, 0.089137989167569681, -0.18096055307763351, 0.47040178202872895, -0.16730683985125738, -0.1749636061824659, 0.13184835141644077, 0.06773793067611554, -0.1216244840661862, 0.058901144959239239, 0.56085044365514503, 0.049652045433715236, -0.20090009915822671, -0.12708550693938819, 0.20974940644419349, 0.3059769043905291],
                             [0.42026431737627767, -0.0026027766137048727, -0.022282637436190085, 0.23934513130889121, 0.20787568032286788, -0.86531278187583771, -0.25662430212351672, -0.5470522991974045, -0.1414965117274502, -0.03283873403886188, -0.21337812563862332, -0.019644975240392975, 0.017881154437738217, 0.0095497055940718494, 0.33626740412174705, 0.1234344037379842, 0.42942786617748491, -0.00047269408766768741, 0.25238179455441007, 0.4746472067379402, 0.27617515216396571, 0.18613062651474122, -0.42994960584278141, 0.57180690750795671, -0.46440524912884018, -0.07138361530062004, 0.36849002427364347, -0.1756619425248786, -0.07683420206670015, 0.31135074790004941, -0.60571764929634153, -0.43151677237920655, 0.68044874175616377, 0.053932993393236511, -0.16896455972901847, 0.20488473364750878, 0.099563220615262391, 0.32067169535517548, -0.18080585710057825, 0.19992488466773903, -0.33319726421786738, -0.2094184103696754, 0.18425369269101768, 0.78683151900832249, 0.007141927418503325, 0.32260420276433838, 0.2789684140079246, 0.51771683675778535, -0.43655941921232466, -0.0060558593746927198]],
                            [[0.25486676503751671, -0.28415669010262928, -0.044489750092941177, 0.10989428327269465, -0.42423062467747619, -0.06733765272358333, -0.03445777842248543, -0.27495496598199948, 0.17234644314270939, -0.11706418323554751, 0.47835141927988672, -0.11698686023450897, 0.53522234322347351, 0.16450412468111927, -0.64723078320296368, -0.43519845690083003, -0.56381325530337079, 0.26607904918358777, 0.17368552598445763, -0.098709547009349849, 0.10359366920503747, -0.24495639535622998, -0.078008048386131817, -0.063278251686563924, -0.14046764456921998, -0.35594528482545279, 0.16326442572600153, -0.31118359837822485, 0.0029456357627334687, -0.26521109799717418, 0.011621830150470618, -0.074593004946975142, 0.00028156571162367069, 0.17221151082125533, 0.31720438152517993, 0.31550374490114402, -0.52522335798089126, 0.28561186735682043, 0.30779439525673852, 0.24484542714723667, 0.19991698298037464, -0.037012567801987979, 0.12623124701954044, -0.058066330749472803, -0.089872971364665627, 0.060958013275745529, 0.13804335544271634, -0.1243552888545605, 0.078382035635689129, -0.26315468546209148],
                             [0.2489791803130034, 0.6198377831984202, 0.50842730094063848, -0.43074654978433602, 0.35396093057003897, 0.23619760444240395, 0.43452948847828249, 0.20927774377556405, -0.053574623782452452, -0.11446765671849211, -0.10458383720106086, 0.71190443747804988, -0.073066695483014782, 0.24624864780582834, -0.047177392951529305, 0.18735943609261649, -0.13794207705912276, 0.18491309165837594, -0.11692016504784516, 0.14944932840522637, -0.18147767622340327, -0.40272961448924655, 0.12485486445506866, -0.0016086313327837512, 0.24487795451261687, -0.029884167050076245, -0.0048103078910441688, -0.10916230918020189, -0.13042965114298372, 0.25885402041546479, 0.19188276955748018, 0.27977549887284042, 0.29888065569639899, 0.17545636448095639, 0.10229857156718029, 0.26323382933169354, -0.057152130625225603, 0.13437328855149203, 0.12360394484114386, -0.17001286986937333, -0.21856300370380866, 0.073178976048220462, -0.07735963641355971, -0.22467949782604096, -0.093440468510392158, 0.099409116936334543, 0.35614569171274379, -0.30313820913339162, 0.41230203937619891, 0.14293136047852117],
                             [-0.24985964730728569, 0.058838993668069633, 0.10931492784794664, 0.32901380486563669, 0.18398087873786154, 0.60967065416162203, -0.021940082316229237, -0.73602737252427841, -0.43663293704858946, -0.23637915305573276, 0.23023889307299172, 0.22132053935339716, -0.48530790885335429, -0.20211930941926631, -0.18012656953724088, -0.14216771003950601, -0.22642341507662608, -0.014027341235559408, 0.18870206746456286, 0.029113958988325781, -0.32060584681923721, -0.14920478146346988, -0.14331869245326265, 0.11124617387420349, -0.30492256959956893, 0.1269562865734061, 0.0031564350494329169, 0.28393234353112051, 0.11201761759330076, -0.09051357878731138, 0.13504260356991521, -0.20110573259669823, -0.15221363417966377, -0.33346961501228572, -0.11009703721669017, 0.39298771546246569, -0.29786267035182057, -0.48571797801554106, 0.077723348662609021, -0.24604904215198833, 0.11813065440712535, -0.11667859981805657, 0.10769855218534176, -0.13061896006656093, 0.11217197643787163, 0.49907857709302061, 0.026496190013186052, 0.11433788535476529, -0.28308042440369607, -0.10642279650155526],
                             [0.38564354970221515, 0.55334782424157747, 0.50918602172120553, 0.4178741884314725, -0.11648436416641572, 0.039283667683963512, -0.073033983918450701, -0.16779637241382164, 0.27543584674479049, -0.043901911919302504, -0.15091867679620558, 0.0034327085684887977, 0.34534087414263753, 0.16794368460198536, 0.5022273614558842, -0.1794423758153279, -0.080608085194934481, 0.36614442679029657, -0.12823923728231679, -0.14679384023280151, 0.016344583856532317, 0.16527865414335141, -0.14806338533072733, -0.41648398006170823, 0.16283381052205667, -0.38001129279499435, -0.31611850158677707, -0.13716744508821557, -0.082202384350081842, 0.28406290680564306, -0.072699099102376194, -0.021052248469327094, 0.1510966186413755, -0.33352602196031317, 0.14011438401406501, 0.49915531956170628, -0.025716542130355974, -0.47937413857994138, -0.22517171723009369, -0.069835726285838728, -0.46436920352657191, -0.10744250576631852, -0.43374301916207963, 0.25040430921694257, 0.19242741897252588, -0.061231693810043106, 0.050365781755726889, 0.35823839087228809, -0.38160341735802766, 0.062422876159847152],
                             [-0.070958575757409562, 0.27902191159971934, 0.10598515844353606, -0.19807750872693872, 0.34010781460472023, -0.19787589128859745, -0.15445448932599271, -0.16217520527309759, -0.24541118476392804, -0.23444080928961936, 0.46389423817975678, -0.30100530444736878, 0.56998513304255349, -0.25739096880770673, 0.17964011562207058, -0.20812052288366178, -0.50912087152512031, 0.48678726881054069, -0.18207315810983582, 0.41662566824233915, 0.10149413161630143, 0.20762839877891137, 0.04365095487392219, 0.41258943248616398, -0.096855292510392293, 0.27988305529205582, 0.014008980140060724, -0.0165778953516964, -0.11485825468073725, -0.27452192748734044, 0.60624928407233969, -0.24867327559890476, -0.062493607627658043, -0.0016159425201245914, -0.18436088653754923, 0.10999075213905515, 0.20431084930986759, 0.14824569166180279, 0.83167481306952995, 0.45688038210450532, -0.1076331354451457, 0.36625387383596597, 0.074888773646714632, 0.10492981292572437, 0.015370494722691121, -0.016753090197867217, -0.56855798341160924, -0.23067068388289036, -0.26829944478729073, -0.26369412061637038],
                             [-0.069556686239325261, -0.090722407345787223, -0.050275424932782954, 0.41465313695439798, 0.19418276217689198, -0.53552893675951052, 0.21415466315998696, 0.25445594977434799, -0.28107289199978824, 0.2195625106201963, -0.26833061205994257, -0.091616340606790164, 0.074994991515240306, 0.21877022137284727, 0.0052037867305593025, -0.30541016974219232, -0.25240236695938628, -0.42164881043366204, -0.35528129308306611, -0.2667041540045767, 0.23512594860936845, -0.11912727675031233, 0.48049767655066683, -0.27438934317895392, -0.54915675338663072, -0.39956973973454563, 0.21459152985105145, 0.19293284958499113, -0.51339063733857881, -0.49867163247026774, -0.054242737901162776, 0.033793190749168159, -0.23572015999883497, -0.032548385602546463, -0.41882877443836192, 0.25205249033600291, 0.033292306497704767, 0.23439322967333567, -0.21995553800620501, -0.22661906814387631, -0.035426746964526572, 0.20458034217200022, 0.25052786871051047, -0.35476081006774179, 0.60369291762473287, 0.22339531734230642, 0.16849817796340261, -0.45146454800867658, 0.13652523563389277, -0.060734113105085502],
                             [0.049775000346872399, 0.28515548959260695, -0.024500874648115671, 0.17112757475200988, 0.24975521079411606, 0.10206818207712108, 0.23742297951909797, 0.055998172206061146, -0.096843612641663357, -0.09663652000779735, -0.0016739455749524481, 0.031918173731975127, 0.1540200771398221, -0.43576227129943845, -0.3656307024858097, 0.031401581574653226, 0.19174760335638663, 0.30669504613627929, -0.0093008362594770265, -0.27653286637017155, 0.10168743470412216, 0.22973962388708219, 0.18957414399105529, -0.25942258619066616, 0.031322665868735236, 0.090228961435062149, 0.11632599186608207, -0.51114892494701869, -0.34854656722755567, -0.54764291085084016, 0.28139268019230357, -0.051996066986491916, -0.26161375874549708, 0.21974575353619055, -0.1799615747384844, 0.23027552366279153, -0.067971096571546957, -0.31279886740268997, 0.0078054203591558079, -0.17558377051037294, 0.44459587682875862, 0.083076759973125802, -0.12371814500191311, 0.25128368484086705, -0.39756598635203272, -0.10375099726341085, 0.099549055081020521, -0.41852584252654695, 0.43739262565493398, 0.18209696941487277],
                             [-0.32593036691477201, -0.13455867591261977, -0.43230679896636542, -0.10708377330713005, -0.22826704004194512, 0.14398628436001742, -0.33587607265693797, 0.30870706428219485, -0.22823029767357703, -0.13175586720069074, -0.16835596362270905, -0.10779155248618752, -0.0013948702202076727, 0.0033133767254016032, -0.046532902059439267, 0.17105993683958401, 0.15379718408222656, 0.11721711877968155, -0.20426363888080201, 0.17072912342252611, -0.14163593901963886, -0.14780977762859945, -0.073658880491215231, -0.0072420157713725276, -0.20168453792141314, -0.11654363505984652, -0.29682582372897071, -0.1865547839849184, -0.16345170814642396, -0.00072350807734739443, 0.19405113084187642, 0.041916609453710174, 0.54088047263308936, 0.32927231340668001, 0.0047305400541458121, 0.55038637092765119, 0.3977701179792717, -0.22503641525997339, 0.34377717086252663, -0.4716180759871772, 0.21947702634660496, 0.12772265011129874, 0.17040635344573707, -0.22871353874481651, 0.28602752282644861, -0.27311742226816638, -0.11356316128572902, 0.11046452966903023, 0.29781422749439951, -0.28232213321942168],
                             [-0.29928557663859851, 0.063255109502114354, -0.0096858809676293213, -0.15671141115056139, 0.25061269221950927, 0.30287523499358776, -0.17786732533793798, -0.3191570388219736, -0.043858835793634032, -0.45405482038073208, 0.42109221445534289, -0.25575095119740904, -0.17715064775094877, 0.31026968442854208, -0.43848177090269885, -0.42626050105717245, 0.30146710139141614, -0.11463238385172198, -0.14863183492229043, 0.14347107858227964, 0.18065452545926175, 0.26082210607310558, -0.028534180788021224, 0.39364426675219555, -0.18471193019445503, 0.20161991450875849, 0.42271988819983769, -0.053431646743808354, -0.22005882474485935, 0.30928093213013941, -0.47543330609359968, -0.024909236317889053, 0.10119932486322808, -0.20767761262212875, 0.050124718558643366, 0.077142185968492719, 0.21961497910905925, 0.12839818539594358, 0.098142849256334833, -0.033146839934128064, 0.13934789793607422, 0.40840048872856011, -0.55826438733944417, 0.58895244643172728, 0.2169557122922216, 0.00085352531061898274, -0.10312918913431023, 0.050174278451684567, -0.15989807474389456, -0.43775789446046975],
                             [-0.29223999370408044, 0.063001353731736279, -0.24679510220891721, -0.06380611682211465, 0.077720920415340039, -0.048678487675426207, 0.0221601104078347, -0.78399780236269212, 0.020538055941471463, 0.20859995813937016, -0.054073374496556713, -0.30330517735636875, -0.20465006570678107, -0.094998755456641298, -0.063388513945895425, 0.30311210568516761, 0.14921449878028362, 0.2366147924931129, -0.013831430487164405, 0.19081199761589693, 0.35968917192747141, -0.19790140649029483, 0.08278042930936004, -0.24218963471875229, 0.0090959910931557534, -0.908157888448623, -0.30013609033859456, 0.049363957746311055, 0.20526045533629655, 0.4495196773831287, 0.09127706011401604, 0.15313160028811945, 0.38152063710655743, -0.0013274990596506093, -0.49557336809016195, 0.1769617720144353, -0.41194146865188347, -0.016756731234021771, 0.20977949947016267, -0.068440088639145705, -0.23608985135628455, -0.094711335477118075, -0.3894836098705487, -0.6104208319946185, -0.071856260012246126, 0.21396606580330302, -0.18442851399650018, -0.44787711532139218, 0.41824668247983882, -0.31993031526615745],
                             [-0.040916295879704495, -0.10406535396158079, -0.063618222479564154, -0.24485043187037961, 0.029805162889638342, 0.31796315956024218, -0.12708285698341867, -0.31795295857662298, 0.18660813439118595, 0.3172334415143635, -0.053055241282554337, -0.051148855236092798, -0.31083271293789771, -0.18222085972860158, 0.54736733705952745, -0.40868451726952532, 0.2973059354960948, -0.17371289311390239, -0.17101258357452914, -0.062457120256987547, 0.035074698061117821, -0.063132275208357777, 0.52335243635293682, 0.19018682012241295, -0.20971247089076867, -0.16335322616093612, -0.38798610327252769, -0.087709428101477346, -0.30372907894141199, -0.064524514989821813, 0.22579625427116867, -0.087564801026985037, -0.16580436116209732, 0.062642737661132514, 0.25323206179402813, -0.027014790714085735, -0.30281152423498686, 0.43171627946171087, 0.48883669311140204, -0.44154615362891458, -0.17804315256792108, -0.18486083696111705, 0.125284817008851, 0.02971420857987285, -0.10401825789225758, -0.2947910410359712, 0.36623893406991792, 0.43292670721514298, -0.10419933670408592, 0.062781243278587931],
                             [-0.32605404389624743, -0.2299385401119601, -0.44733247676609111, -0.30707781145875845, 0.27838561333344136, -0.01694671817747264, 0.30665304686591704, 0.27105048714550939, 0.15089633535517483, 0.065221412935279457, -0.3748496428945069, 0.085141701838194361, -0.45496042291825517, 0.29111926096736851, 0.035559373171918061, -0.10864097648498097, -0.19426681783444202, -0.094911594304687971, 0.16613604099676615, -0.3951472777808967, -0.06876289152201745, -0.27513371360330513, 0.16687457346270748, -0.55168634608513289, 0.098747151843610076, 0.41319119944851773, -0.22937431667158176, -0.24311330872692907, 0.80153278524550486, 0.36318718717104798, 0.65925131670133408, -0.079898065725165862, 0.4247395561671809, -0.29759814776671534, -0.13848154859569198, -0.15321788853432283, 0.056451869329749799, -0.42823893569902799, -0.10410269402261553, -0.14777682166833078, 0.22097247890174643, 0.19013683186074604, 0.089101451365404927, 0.1586903557904133, 0.076588563133052595, 0.1002467194495076, 0.22090209956236073, 0.10088335909330129, -0.19981203608020009, -0.11247352700994645],
                             [0.42109023348546876, -0.00011274223056744956, 0.081415445282796151, 0.19823505205714487, 0.51840975628732267, 0.1761254813586928, -0.4074827137170261, -0.01399075931068672, -0.18822182549554908, 0.19076433000072096, -0.21946340709162493, -0.67845840685624081, -0.18525105674102813, -0.18001640823389561, -0.11525445541646839, -0.020514362664154618, 0.32978139373868026, 0.092208499450178186, -0.1328488430602893, 0.32171388601447715, -0.13715860477248551, -0.23941403303679942, 0.25581670158036407, -0.1940443114601223, -0.22227744560118667, 0.16876306408870018, 0.640158076152331, -0.15643620638930283, 0.5571172082122422, 0.047809706080254297, -0.0069497185258399746, 0.17632403615142586, 0.15173445296170018, 0.29807547171272647, 0.017757261877025778, 0.18523603359082771, -0.10885336559455297, 0.10292968051472852, -0.56238077327483005, -0.38776491677735742, 0.01590260508050647, -0.21260126321445186, 0.15223082087776513, -0.43331694423079975, 0.29148515534009317, 0.20819717148133912, -0.31808152205076506, 0.31917062938536284, 0.084608000094989061, 0.10799337340060261],
                             [-0.10821766618575707, 0.51737842817107527, -0.19828474849567501, -0.22968854790541432, -0.25529101099960583, -0.29886447352456297, -0.23447854297195836, 0.1089280391308718, -0.031623395534946044, -0.53562599233922215, 0.050103980933784584, 0.03900187831680782, 0.38460708685075889, -0.49727201215997585, -0.085136605513733588, 0.11118882868354141, 0.46348076305003844, 0.12282613453066221, 0.29493656724268708, -0.038096419738110031, -0.21345905760314854, -0.033506259284343802, 0.027785942610500922, 0.11992883370035624, 0.367068530825228, -0.004929199746578199, -0.34521666110879679, -0.12716748127322419, 0.12592760875958711, 0.016371310792638677, -0.39212763406228685, 0.022540036284183992, 0.28884404276819142, -0.55773565255598789, -0.010830820584802661, 0.18438846122815092, -0.11019384638113405, 0.079786552699566429, -0.21956839382304438, -0.11457072417556195, -0.085853398354474447, -0.15269173095415844, 0.019999371570613447, -0.34257532275531594, 0.15903926791200843, 0.59086828093258814, -0.15184918718729187, 0.16986295028754395, -0.1712586674605068, -0.18703981159175817],
                             [-0.1007983639902973, -0.093587764445651062, 0.13153667274091507, 0.16027150898350068, -0.15132726906514465, -0.070987240457504902, -0.11924549948666643, -0.17524755170431955, -0.029041588751303072, 0.061120691906134228, -0.25490177253383894, -0.30839179746761447, 0.061764894859180533, 0.32536690972688936, -0.26287098941719234, -0.44041566763240814, 0.36451490294180672, 0.42366264694408345, -0.27261408615451854, 0.1627348826744269, -0.86525223497889336, -0.13661870626314049, 0.095818490973577627, -0.51241839130838318, 0.30848529113265921, 0.13359742209356845, 0.2483483972366804, 0.12930619377368996, -0.27263217720451316, 0.053844306634983394, 0.39050128470413425, 0.13919980308398147, -0.23725395583147585, -0.25514014430882359, -0.26706475827187287, -0.035580148819265779, 0.24819274911895547, 0.34998775593307585, -0.13856193131664146, 0.27065647440073604, 0.36731930662560158, -0.19483202374971773, 0.12518844434993384, -0.098297314964594984, -0.075725225332193044, 0.0016595751515448565, -0.12216867832392353, -0.35582731112575122, -0.30133460227505943, 0.29471810956034195],
                             [0.081534133805362952, 0.69886197498552449, -0.34072871149729717, 0.34982165697483519, -0.061856970590160078, 0.43667368547459717, -0.18168314509506933, 0.2557020930059446, -0.18591368019080337, 0.34250178004037707, 0.001355507554750258, -0.098243831441278337, -0.35381869837909269, 0.16367921389794188, -0.3057802926483123, 0.064122150865335431, -0.072307821903853348, -0.09801919200321825, -0.24992232266539016, -0.29057353973090172, 0.16202297387269843, -0.087873866907685852, 0.80081624603053636, 0.032215341971605325, 0.14336183949467599, 0.33706613362924587, -0.26023246792032384, 0.099491270286119288, 0.27953751630424861, -0.049121266060280916, 0.053840178519379167, -0.39135268586169414, 0.20816436509560657, 0.0057762039868365436, 0.18077964075934225, 0.28406522506703202, 0.027907998861535763, 0.24369261256448524, 0.018082382386611182, 0.63526361200629111, -0.19507399503061545, -0.057152910776383938, -0.10215786245421095, 0.24410063149496586, 0.053964994112295141, 0.045531938131306557, -0.24562778787067441, -0.077153296172885341, 0.081098645397744529, 0.21117026210834883],
                             [0.45844723400204451, -0.080686709386101299, 0.22276074396006657, -0.31786241207034405, -0.070395194766932512, 0.073861901752345263, 0.16333293498286305, 0.1377449064667623, -0.0061565958502809836, -0.028539830000179719, -0.073287402183035991, 0.24544586921895248, 0.20016844940551043, -0.081294742272567722, -0.17536584781239647, -0.045334264078633141, 0.14499975616444966, 0.0066829380182923965, -0.033222340953094752, -0.41263072849869425, 0.48520276265384532, -0.097334640861306526, 0.15110497203366383, -0.13529918690220635, -0.069723038128194248, 0.096570326611222376, 0.19514691649177601, 0.41244901101971054, 0.099469054805511714, 0.23641194346116001, 0.11251972117486889, -0.17222910493174662, -0.038399919525593788, 0.02246577931469259, -0.4017707973130385, 0.40999474070338976, 0.26053243251699049, 0.28898367556167615, 0.70214253015567551, -0.30774348555550834, 0.053518346080638914, -0.18641796526298016, 0.14184830823944208, 0.031556999289165798, -0.025546573154563264, -0.10484953823092499, -0.09504476013423549, 0.33610497260609395, -0.31682947306986875, -0.025243509614146519],
                             [0.70591501135881651, -0.38539890319709219, -0.48217965366621701, 0.21687786833966965, -0.068295977449629758, 0.07261711138750529, 0.05236387086724334, 0.079729506869464242, -0.23266517190528785, 0.28338313330729398, 0.35237917485682868, 0.37377433323714021, 0.35027428975105845, 0.11879537692825284, 0.063086284037029094, 0.15766682370772955, 0.24965517725920355, -0.15296372629255475, 0.4355348436018967, 0.37312784668417487, 0.33822414485401792, -0.17360477428189158, 0.20900456456370142, -0.20918876751068524, -0.56058106906801297, 0.26799577545001907, -0.083226984592210743, -0.067742087958902089, 0.13960591119369664, -0.059725983114666967, -0.21961098790973566, 0.10758750148217641, 0.14570567321619846, -0.16723052852963199, -0.32701111406025379, -0.61608421170365468, -0.22344477274749466, 0.17405966938663969, -0.29694653605445048, 0.031273245988823861, 0.14537569190366792, -0.20754215354662103, -0.37122107359956219, 0.064552144942316786, 0.4436979525213261, -0.18291360878238125, 0.068892275523915567, 0.045798283233239021, -0.14007529951588232, 0.17158307627690825],
                             [-0.093450627412408976, 0.09067493660649642, -0.041780009611688845, -0.15660029598197614, -0.095868256357321546, 0.40997941648656372, -0.33383734036407936, -0.17839686458128778, -0.015207834264980444, 0.03951065815659266, 0.1612503677631533, 0.15410324760027455, 0.10609445808911115, -0.11899232428488181, 0.01716159529374708, 0.13944147568656839, 0.17036763702939198, 0.63789569579222583, 0.24129352018686176, -0.40970677609332928, -0.01382161175501258, -0.15235948334379087, 0.3899802185577515, 0.18862090797870104, 0.23156508037294596, -0.61533480712732846, 0.38796060502676782, 0.10423290165189024, -0.29491405854788538, -0.24193442478166474, -0.0017820350106141272, 0.50820946351290597, -0.26655128785271143, 0.10123874784655128, -0.024069122222235971, -0.5643198559330993, 0.033254604590234695, -0.081827244477029909, 0.19381717872303997, 0.22044050957524244, -0.16111252397213571, -0.17345514895250974, -0.22188673932117675, -0.14589359390979317, 0.14959649091852684, -0.19428582890078047, 0.21496951952478413, 0.23392979281124052, -0.33999871159287198, -0.084143497520768898],
                             [-0.044045650214389942, -0.53630304136700369, 0.041823995648406158, -0.021988659390650193, -0.036947181299665413, 0.40191128470421683, -0.058641159732555778, 0.47937048749380123, -0.34791853405634016, 0.011765967629861988, -0.32225664483015343, 0.46029707170486134, 0.14787098041971411, -0.31666887634512492, 0.12311921220774122, 0.087783022231548963, -0.19836827108204444, -0.30010726377628721, -0.30457763232596813, 0.18006557354564734, -0.15212752177437913, 0.25357107486894559, 0.14436824160327721, 0.098576385192052043, 0.19858531458261094, 0.0019590481914881757, 0.2309438127793072, -0.059907896555672108, 0.087500832191690178, -0.18893776455758093, 0.098466998444227877, 0.18400070511653993, 0.3086837886221746, -0.65464992110424403, 0.31052776543564231, 0.11415266682828903, -0.3124229854642725, 0.18146920394586422, 0.037641843908917075, 0.17034594609782586, 0.053734301510184698, -0.043919671775735615, -0.26403887921060676, -0.25590264658209227, 0.11801494617435497, -0.027964408967009843, -0.077151380264897929, -0.078234986716742311, -0.16850660815729457, -0.21609580587799709],
                             [-0.24049002854243845, 0.31968464641331568, -0.36264308564845132, 0.19245370794700983, -0.46449533551253475, -0.04341271952474101, 0.023878609674606265, 0.3937657649670806, -0.49935776347251465, 0.089090732724993391, -0.081318311853316172, 0.12107740201617392, 0.75954456651021929, 0.35464161793671323, -0.23474223919048273, -0.40115894192518903, 0.35449252895685446, 0.16677542069486612, 0.23457818170844044, 0.27255548748682745, -0.3272106261388803, 0.23903523639448007, 0.019545833978803318, 0.40145896677215615, -0.015161598365947626, -0.22297895797860331, 0.025746734679360731, -0.28417786435816905, 0.046807135640853856, 0.58089048327310722, 0.27865526055585066, -0.1341411727662894, -0.12245155013879529, 0.026975597462512099, -0.41298261846365392, -0.30894570420923673, -0.33034794407021634, -0.11323569809894224, -0.10569327793290315, -0.26963536345636896, -0.1023990640124358, 0.16161850092044097, -0.084097923626530666, 0.27782607774912704, -0.37811986540513121, -0.28913795310759877, -0.20571324273133637, -0.026894655006933894, 0.53627028595268544, 0.035952819970226535],
                             [0.09385808504389212, -0.55430514472730508, -0.47797534663848218, 0.26007815229974696, -0.078070202632886027, -0.10058504356650612, -0.029972805237290796, 0.40817244034569805, -0.079741066412244016, 0.11037000740318428, 0.22064096414877057, -0.05206755838873247, -0.64660490314564789, -0.13463613388203088, 0.67310011388868307, -0.0054112704594480275, -0.072028939982425363, 0.093621600509168373, -0.0078714978169284345, 0.029206526983150002, 0.1595612325255385, -0.44436281708433956, -0.18601287847659348, -0.096244110359001295, 0.40700411892231575, 0.21408541543024678, -0.1049871630506905, -0.1540971541526848, 0.28124635381537638, 0.59237085796311539, -0.11939844383238132, -0.085001671290098044, -0.6830775263685559, 0.13799955437360023, 0.10136160474797144, 0.22862012278385804, -0.15999928777949277, 0.11838404567735811, 0.084315311986034702, -0.0416108440661438, -0.039673567728295035, -0.1961953947662225, -0.32786096962924771, 0.17731183334982017, 0.10837079189152221, 0.6539464771140453, -0.057280085824696236, -0.51541431862661202, 0.083651254272208125, -0.10674879544031517],
                             [-0.39262734685676326, 0.026688522390008899, -0.21030981574631039, 0.19407411031934305, 0.070225649899676057, -0.098025556903397815, 0.569926299596755, 0.050867247946484923, 0.24272733355115222, 0.32720636581062607, 0.3567195616783852, -0.17887111412644116, 0.091733585686526925, 0.074341810092683175, -0.41837933325742577, 0.022557152958572503, 0.4709664236303977, 0.0017363341944386973, 0.084344096701541207, 0.061117142299742584, 0.14157343101176711, -0.02184386198540799, 0.12336029911396858, -0.021087962365150825, -0.43625071761701817, -0.24671701192886936, -0.13743499303171633, 0.026551279109751674, 0.26619687523243263, -0.16836743218742362, -0.082308415051971826, -0.18233493967058098, 0.093463348228672555, -0.071941438988470108, 0.63934875017604553, 0.081314714512378442, -0.056556322064656883, -0.47570701097593865, 0.22941807061490052, -0.1594068946059887, -0.53107214375528267, -0.12576042770408638, -0.42194092032460367, -0.099167309515158827, -0.094611593135207589, -0.25160575383724404, -0.01138558739579933, 0.085263465997581486, -0.47194063640484735, 0.27116468494310764],
                             [-0.32336616198946183, 0.29997995933085714, 0.21639882831701465, -0.093413463023132443, 0.19050030502650372, 0.10199502733415987, -0.42607088780382307, -0.11847640592906476, 0.018222086119696609, 0.52520635850255126, 0.7229129901526048, 0.28187987478018967, 0.51500022815599134, -0.087403675616783014, 0.58992273921220495, 0.0037156190641250628, -0.096990245346495904, -0.080094578766203711, -0.27203619204676149, 0.051489574242415369, -0.16696884458974667, 0.15604560387164595, -0.0066441617458914467, -0.19914421297749332, -0.44057869827513929, -0.43627106364313478, 0.2355470296521141, 0.36877532180064815, 0.34367101603725325, -0.0094139698465082276, 0.044902514810107493, 0.021495567380519588, -0.082750339999401082, -0.54195131833532784, 0.17181016292688522, 0.11421618337494879, 0.26046700551701074, 0.28604823614227204, -0.39862339110233308, -0.13240024138401679, 0.39822041144230363, 0.33785249703169751, 0.10416433696201875, 0.029550765398003154, -0.14547691551200748, -0.30469168393526191, 0.40748488305520059, 0.29205979128012227, 0.32510561649253344, -0.23332411046919263],
                             [0.042469600820071618, 0.3024828298170858, -0.15960696658462581, -0.26687330221486255, 0.16744677969980376, 0.2646465365442961, 0.34791858984368118, 0.37425270662338744, 0.06322294219509518, 0.019178765719151378, 0.22793880473864897, 0.16537913932671525, 0.45096636643121457, -0.10217709431820698, 0.32657461966991747, 0.061951408230023181, 0.68404780758825201, 0.03202422664483192, -0.39912433503626166, -0.012533659208401627, -0.20563569331611464, 0.24280627172589284, -0.51642164005230418, 0.50814666014437626, -0.18634049729280705, 0.010511848121995361, -0.35440616229808353, 0.33509171240319896, 0.22361578404151922, 0.18366124919576099, 0.084376490758207218, 0.14882231273673943, -0.11498725515810362, 0.56493257104160521, -0.10887471677600385, 0.088758009891270584, -0.34459340284463796, -0.43725341820633956, -0.038573749597075803, -0.059826643926495608, 0.3689160390714028, -0.34167640833542284, -0.053300458712529468, 0.15205339455057632, 0.13469522264861533, 0.28301192191442492, 0.22632718929684764, -0.049581268375043834, -0.074216892646005478, -0.63809801577984104],
                             [-0.48123232975309488, -0.13102937734151848, 0.39616897926487099, 0.17563415653570658, -0.58081640880387442, -0.0073412011707246622, -0.064893545631908398, 0.53199044538018958, 0.36160028543968276, 0.39351949353159971, -0.098130729700777325, 0.34350566375902608, -0.29288384457700412, -0.10201612792767631, 0.2409970222775174, -0.19589850828361768, -0.072052976849506262, 0.47877453939982384, -0.16570077104250405, -0.086429884249148117, -0.03968862336685481, 0.097735400104895009, -0.14937156480436581, 0.18027570730559422, -0.058869659677490027, 0.2598147935409903, 0.13569307414139206, 0.19848936998278457, -0.081880406068623832, -0.013721040815147844, 0.0641103031064061, -0.53366534650314457, 0.63761310470406296, 0.26458980865695636, -0.31066707205000482, -0.51581755368380799, -0.10813494539820805, -0.11462962092530431, 0.1801449509677536, 0.15385800598874216, -0.14936206909137661, 0.2153208089762286, -0.21131811946914092, -0.2692894243719452, 0.12204385627565742, 0.2453747808063538, -0.074719023303328871, -0.45788570952520041, 0.0085688927363585469, -0.22849193046763727],
                             [-0.31844241786746003, 0.34756534273478673, 0.016907474900342962, 0.062167700770301641, 0.17930452698437269, 0.18529764333398685, -0.055464537909145954, -0.0074705813008280322, 0.63470443252154929, -0.34284329889849324, -0.29718711801940673, 0.055605696014329263, 0.38703507287213101, 0.2769045398171332, 0.16611274413150462, 0.047425582236343522, 0.035575878139301798, 0.41866906533019138, 0.25065908175113233, 0.26390993606702912, 0.31613598477778754, 0.17956342393543795, 0.17452751899076338, 0.23441248318979024, -0.58058513989715865, 0.23551962626456061, 0.14857005805056317, -0.21446185108470778, -0.20130094675410182, 0.27864894437129406, 0.22506090684052416, 0.44922056662201237, -0.27912331308340449, 0.281121157472351, -0.33714682515766148, 0.41974624819230621, 0.28546472953134749, 0.062817375160141825, -0.14990117720180221, -0.1980906509774002, 0.037146944494805073, -0.55831125009252935, -0.18289469488807122, 0.022782277097951754, -0.18040620079055517, 0.38529945999262738, 0.23033026287087532, 0.30657293182875683, 0.014208910497827534, -0.18182479282721734],
                             [-0.17285397198978322, -0.49382211468453491, 0.41837250826236322, -0.029927138822090554, -0.17158359910390461, 0.060362656275056152, -0.19475597257831975, -0.11988297328492883, -0.44133347258602834, 0.31223909984757886, 0.34334402533646163, 0.35152986089283939, 0.19801425606563705, 0.61049729105012029, 0.036887890790407565, -0.21455257223003471, 0.32466549519551557, -0.26742852447727028, -0.5348486266226411, -0.26352589017674372, 0.26917246289991259, -0.13747290554983282, -0.55440997183319096, -0.056538616766139693, 0.13595585227472573, -0.10591410395912026, -0.029247058165636455, -0.39462289976368703, 0.13893164763329177, -0.012199564258511732, -0.32849370361657776, -0.25284767842642181, -0.4093770454682974, 0.090272028735613657, -0.0018151651030041192, 0.052049634548791947, 0.11199191219866998, -0.067069827063392137, -0.13605903440681091, 0.4216893541345485, 0.19134859008526967, 0.064660704283479656, -0.052774522575200961, -0.63536338596887765, -0.18586763104687176, 0.30344479078658454, -0.11620383725452894, 0.32542363941151392, 0.14614737612875059, -0.10729178748678876],
                             [-0.032771077058197672, -0.32976753957109534, -0.090315752054709833, 0.040286092702695557, 0.11159130735063336, -0.28204559374911992, 0.16612239934414497, 0.24784076056067622, -0.37632185165077991, -0.0069880263566856615, 0.65424025433120792, -0.31484282028693372, 0.0051574858948605518, 0.095142997583706798, -0.026908457947004839, -0.31171126482067318, 0.074138483269674232, 0.21915045732920471, 0.077155796670664079, -0.0041960071813332452, -0.18011675911310207, 0.69712279594467552, 0.4509867219452055, 0.24293996524262426, 0.027370842030929515, 0.021530572524584544, 0.086734252720001251, 0.13223097825713551, -0.19270571377080317, 0.23145137083439365, -0.17898089948898244, -0.061487050238520836, 0.42094586168701326, 0.40321495131478363, -0.092102198076911043, 0.12869965180151968, 0.12838396375442501, 0.3271022706378679, -0.29932487028116006, 0.14062453026907024, 0.16297595228357795, 0.15229147334619386, 0.038065135986390018, 0.090008562503434059, -0.46092323796021278, 0.23255636020353998, 0.29634458535001801, 0.054580162352566464, -0.052395132881611475, 0.18675943163370667],
                             [0.044649296259414967, -0.083638950545526017, 0.018224760779189587, 0.13104891122872048, 0.11980971257504074, -0.30457686937719941, -0.61584498640138574, 0.10131349043237366, 0.14150613587352814, 0.021675430311857861, 0.11583116816089024, -0.030603774971325964, -0.19519850037462597, 0.17733623987310823, -0.26435849851331811, -0.18452222779142402, 0.095606950794408493, -0.41876456762943909, -0.016938859298046512, -0.38524236514896715, 0.24679929411488782, -0.39986677627506279, -0.19744236918556321, -0.088573984128322653, -0.34522022882266301, 0.097281360023010063, -0.10189027540251908, 0.39433767844920542, -0.33948236017295741, 0.09033496919413031, 0.24252849712085703, 0.44424784548052348, -0.035177071736649232, -0.23027558426551625, 0.013728246476684138, -0.011106485907885549, -0.063709238690676906, -0.1870157368335145, 0.039783828501368523, 0.13500714790495472, -0.07601973774055254, 0.067010433390091176, -0.46491999438055964, -0.22599030694698749, -0.41944374493092262, -0.12959472577575099, 0.017001013738488776, 0.0080452076514166242, -0.38537189282536682, 0.075978607247273858],
                             [0.3824579935227162, -0.22030789547125482, 0.3708045861839161, -0.62943391977335472, -0.24932296678859636, -0.4289397757940312, 0.00064271052689644, 0.015088275107696414, -0.38086068432257225, -0.21514944674451028, -0.025441194848135763, -0.21578673150575661, -0.16485463600959344, 0.26515391888015449, 0.019607846383010281, 0.15005491613906768, 0.20829756139823363, 0.047908323402888246, 0.02869668271880519, -0.07547821039649677, -0.085975387317971469, -0.82724834453885288, 0.1557246964302049, 0.23532040251503475, -0.69779833341248776, 0.17620003950928947, 0.11162833233920008, 0.65118823030454187, -0.06300606356712482, -0.48172894890525919, -0.20158640866116601, -0.31437287676820697, -0.11730919034916248, -0.039137013691118917, -0.30631908232972582, -0.078407462818391657, 0.045482337697445197, -0.3945107400803417, -0.23530712464376052, 0.57454396332572144, 0.20257311668195938, -0.0837304791022557, -0.41652081112033118, 0.22587841692855631, -0.62393223582768431, -0.25962791871365082, -0.1533610048104232, 0.17350306041490016, 0.28240986315567473, -0.1810211906210244],
                             [-0.24470029612745545, 0.25439458957255406, -0.40033277552445151, 0.24667551120346337, 0.12104724436154288, -0.21841973383494787, 0.53087081508168177, -0.17426900408371374, -0.35802213825737061, -0.1289222932608784, -0.35329003710812373, 0.10765014072970808, -0.0291004567864241, -0.22230117276200911, 0.49239470631477927, 0.35021118563671305, 0.15387818696224312, 0.41857465518432352, -0.26056825804314188, -0.358015995694278, -0.12631375691656033, 0.19333993871826527, -0.30922958075825507, -0.47161644280828913, -0.34927627677063022, -0.056530311979112249, 0.40644627879019529, 0.13050046220030131, -0.23293195721277418, 0.19956610541662786, 0.21137024482624667, -0.038995761197528442, 0.25716237893687249, 0.13006843957090358, 0.33915418025675392, -0.45328533721311609, -0.20449374587159028, 0.1522563735819234, -0.024637507017640271, 0.17987436679007521, -0.13748323994907569, 0.044363577221415595, -0.18636778770203311, -0.2100272717250162, -0.1246624513211, -0.030393047361922568, 0.13194039008689706, 0.13203981077830762, 0.043700223477015965, -0.0053758649608855735],
                             [0.34229704034980785, 0.027894644925715098, -0.095287011956076445, 0.20828929962972317, -0.077390790502756726, -0.27816390074870623, 0.20844541064132327, 0.032378731694021556, 0.026429963050485047, -0.2541825025385212, 0.021931349528564594, -0.011005711694546753, -0.071883899431181258, -0.57712758560949973, -0.43015812608359932, -0.16624440533341325, 0.12971661630040371, 0.11069171445144016, -0.0063739878459214069, 0.19972109840703353, -0.20608394629943555, -0.083209919816936956, 0.41063162351202315, -0.28870717966338677, 0.23356123081152774, 0.086417892474869307, -0.35880952916680248, 0.35156778763471774, 0.13889555993622504, 0.06295636929480887, 0.38768950103788996, -0.14289748549143577, -0.35509767241194123, 0.20155688734659441, 0.38609276708045392, -0.12513932488473578, 0.19903070363073691, -0.3334389307425446, 0.085069344509169739, -0.076833100200891097, 0.2137082499406282, 0.18788388435744502, -0.16637668343778061, 0.051174385139038277, 0.32495135085974391, -0.16119500435591291, 0.19213829185314299, 0.29555782751019177, 0.17172969132979898, -0.59310338284194553],
                             [-0.16082976085514963, -0.2088446819637029, 0.44129950061280843, 0.25593332559407628, -0.18581175934680333, 0.036286337357456781, -0.047350788631421267, -0.10309579045976119, 0.10397820592819733, -0.46730731375584283, 0.29787910292299113, -0.022770974383837832, 0.27131871495151139, -0.3863934487229686, 0.16816855559422952, 0.10512406245758209, 0.2932696988995061, -0.30757259389497116, -0.23518890810454912, -0.075606004015906725, 0.26097460372046977, -0.36333030854695447, 0.26030620588824083, 0.12567191243666598, -0.16276228375034255, 0.055752322872412809, 0.3358500008067557, -0.1138229465287782, 0.1484025157913304, 0.15028661759137857, 0.27574448177051791, 0.077088713987183935, -0.093971947312670168, 0.088233088564103446, 0.10013708393224539, -0.020379990493826668, 0.1928624531226496, -0.30070157707512302, -0.42045400024972046, 0.43425176444817037, 0.20665573726512426, -0.16270375727266939, 0.27029838548493013, -0.028534035042640446, 0.33668431945489047, -0.25554284912806963, 0.30880631115373236, -0.18825160512322806, -0.34204881583949981, 0.20423219025895151],
                             [0.016642572870111141, 0.14155351897948837, 0.0248734796631284, -0.14291373255036938, -0.16077281723476944, -0.027560482834089465, -0.34999015947473822, -0.70764300008658154, -0.22668593905837833, 0.49237415212384161, -0.65329876302342571, -0.18340669008302951, 0.0790454833406255, -0.19900195199361131, -0.18858080777360681, -0.28821372177950466, -0.45600328471865142, 0.11478466605761531, 0.28561754083399082, 0.020123246607120244, 0.22027014436744571, -0.031236763823895973, -0.12020035094304878, -0.20178102974702741, -0.050690230418679039, 0.051488035223360748, -0.011736678260267887, -0.25198238185730393, 0.46333822591086321, 0.024322954743526831, -0.16417003491501153, -0.24154092268703567, -0.029935686996804399, 0.30076960669670261, -0.143010966490697, -0.025434626639787641, 0.39800173509747927, 0.11019499947939536, -0.13483532145126967, -0.37971287005019883, 0.24637021183600713, -0.03778170807992888, -0.37135484891422144, -0.19965158759784707, -0.19551052840738428, -0.35189406078962787, 0.30731904052513981, -0.44943302987477701, -0.49730876518058104, 0.14934595148760524],
                             [-0.16519254094540822, -0.027115059203765442, 0.19225261777502214, -0.26825472104483861, 0.01912461054465299, -0.25687611333609367, 0.014841094343906687, -0.037125394461622378, 0.20475668937723093, 0.24696621250489162, 0.32090916312077628, -0.072289246756165604, -0.038330040031333744, 0.24669136542262085, -0.38639021916590266, 0.29336978252838913, -0.038830588366592735, 0.12491806948707358, -0.017435316628631327, -0.39305688867117267, -0.33066803723851196, 0.5169731551453286, 0.58478204699806269, 0.12606690211042318, -0.090138079367969831, 0.67166017527280608, 0.16950506097643261, -0.20228188408086306, -0.32169957273791921, 0.48549843545008914, 0.0055551620941230381, -0.28721721404187239, -0.26195898510476207, 0.013562388492998468, 0.17179885109888848, 0.41371997237100772, -0.11922703682776649, -0.37713504579449986, -0.21812704510346428, -0.047407821299916011, -0.22377882682439629, 0.28674370076974776, -0.060050391003160702, -0.042045228767985283, 0.42864708323262851, -0.20375287698523892, -0.085013968597713568, -0.24301847934880777, 0.15172757490415639, -0.0044128956886913123],
                             [-0.14744228100188997, -0.21499422597793122, -0.044318026111932397, -0.0017059980313225698, -0.10546368493103117, -0.087626986144965252, -0.048316632591658026, 0.16957837787666072, 0.22174625663596745, -0.21009936398090184, 0.22144687678603103, -0.089657394778039218, 0.026651726925444444, -0.14247130753585241, -0.47349342674290468, -0.031085502099415584, 0.15973153076862462, -0.37565594217107479, -0.15082524169459988, -0.18995914923232507, -0.50061225516633756, 0.2596180838512071, 0.0022668679086299583, -0.12092945882407535, 0.11622460244329068, 0.1975178708826964, -0.070998535438831056, -0.31214653921542901, -0.010303332656787866, -0.16909734833503018, -0.16775920853788112, -0.1566398515464624, 0.061072314616359043, 0.35244095909209716, -0.51563140328228263, 0.47042456800138865, 0.14399765079479457, 0.21025195246496714, 0.037688938290335608, 0.061037672983175716, -0.74109714881490707, -0.091673991673968808, -0.33161547308020733, 0.1672326528167892, -0.19087601049321948, 0.12671407097785822, 0.27432600703922416, 0.32611443556683273, 0.00036488216137425117, 0.27355676702737219],
                             [-0.10290822698753158, 0.054227358188500205, 0.1102682081832739, -0.29728105361382068, -0.12191028274591348, 0.3988950879637902, -0.146182665023634, 0.098172897767387218, -0.036274918627365378, 0.10675367332730062, 0.016189439206759637, 0.013060823586067654, 0.024262183885512264, -0.2729149018030001, -0.45178137098242149, 0.075323230256344298, -0.21213733455764108, -0.014051955673684266, -0.098465602803751731, 0.22609880290454037, -0.079293441143702584, 0.096981223028869523, -0.025315238701357459, -0.14358546583228329, -0.27215805768972062, 0.015797801710972705, 0.24835946321267444, -0.19026124258485244, -0.57184118332881528, -0.046383531507634246, 0.58776159325164745, 0.16444845721206797, 0.29448424347423641, 0.097242356504336089, 0.48979687433602093, -0.27213075088872818, -0.050833425635256668, -0.42866447027530541, -0.10598518979435034, -0.12040436744852899, -0.40342445387079229, -0.6541266562061866, 0.00087151817350364022, 0.47395905071026467, 0.2596417070353903, 0.59898506362170445, -0.20521093366019288, -0.20946311813025187, 0.086444701546141131, 0.22994759992388308],
                             [-0.032789617812638047, -0.084468789022666121, 0.49790129606128175, -0.23082597182669642, -0.41643205912732578, 0.13619598275823669, 0.52623384006288165, 0.068454728698139511, 0.14097175146124338, -0.74725958283358773, -0.21136933208102407, -0.023440030488695016, -0.14524426034705404, 0.12626279434801199, 0.7012324415828759, 0.023083526768997616, -0.0039856068377344548, -0.39285145023207446, 0.44313070188494741, -0.12857847633870367, -0.21039733468960534, -0.069236160718265494, 0.059818986944112827, -0.19037019876765715, 0.065130977669013129, 0.24189167445967857, 0.052143169522948681, -0.050671564964898344, -0.10510955001079059, -0.20748424458487916, 0.55844600958013202, 0.50856664094668402, -0.023160981483378744, 0.37320407643114251, 0.083621357466611021, 0.35479131934084734, 0.096582530780780135, 0.56410541354380828, -0.35581063977594862, 0.09315298953120428, -0.040254804542575136, 0.53593737099983363, -0.56238716287253521, -0.25029074944155155, 0.11056278608654327, 0.14881467384978106, -0.60436416892153821, -0.10618499730996962, -0.29811835176298235, -0.13591891613220253],
                             [-0.3307688367219061, -0.20005204512628205, 0.30595303047703681, 0.099672193559653857, 0.28918186371915505, 0.027178536056233119, -0.21829985559550866, -0.081586974610405094, 0.076303727449921019, 0.23010025683383886, -0.71803618088018695, 0.33440177259959591, -0.05636558240715786, 0.11296066096908983, -0.016087435679735883, -0.21893599188258028, 0.39262541596203032, 0.31549827788653922, 0.41976938967213029, 0.11026515453538206, -0.033890276751480611, 0.0070998101340862783, 0.18363554771268334, -0.50071812860978127, -0.1804618376689254, 0.0564865764432851, -0.29815847747231167, 0.24900759147003279, 0.15875284383813548, -0.1402226971193197, -0.34580436032100353, 0.31156776910520134, 0.10799830373827109, 0.26135628909183201, 0.25516995413671972, 0.12004687797632659, -0.26014375675428258, -0.077748856838019131, -0.18157524277024689, -0.0038334809487546358, -0.38623117161274761, 0.44479137831519527, 0.21262344491677401, 0.36293977338570477, 0.16250026698794065, 0.10907534041594087, 0.22175237925080066, -0.21774733579181782, 0.1969362303644836, 0.29709712935913191],
                             [-0.16420207465342176, -0.27150212470143542, 0.011052284538538062, 0.044283143574575801, 0.5565549969235829, -0.046546132907280109, -0.1181603851834581, -0.56070482335860672, 0.40034601489557942, 0.31369892035865354, 0.13593438398435934, 0.41901797290292991, 0.066552624651048234, -0.14920843124926159, 0.023351350034119138, -0.7027385386264231, -0.046348500962512224, 0.28125607143392817, 0.27974447923866308, -0.48040623875835825, 0.023924261601559266, 0.070859430264931231, -0.043109152509266779, 0.27064936707023468, 0.18504986103169058, 0.065076170629513055, -0.10993106510366507, 0.18393194745028724, -0.035136082574041522, -0.31535353461566845, -0.045025214074455561, 0.0098136702226430308, 0.13343339600665025, 0.52118580114412583, 0.13777850276432774, 0.079440336404930478, 0.073507772929817194, -0.10100460538264663, -0.48415810680934346, -0.10706551976813566, -0.13117753282705419, -0.43479807692598132, -0.29939700486497983, 0.09418974498330257, 0.29901622342465234, -0.43772667222898781, -0.38525539768170414, -0.1437951217966271, 0.5802584524443456, 0.072369539458969637],
                             [-0.50169126134239672, 0.13934334270167328, 0.11018898493986351, -0.13081085617701121, 0.069630660291055302, 0.394385005687648, -0.16053567925915085, 0.36719200183134326, -0.072912093537613507, -0.49669309801988115, -0.18381957005500194, -0.5779588496910314, 0.23812578923675037, 0.23904833129375971, -0.18538224783559654, 0.15983969679519597, -0.35798117905794219, -0.040285002983765118, 0.10972643105684114, -0.34195778117664211, 0.22431097756695137, 0.1633311285582143, -0.014952044646016637, -0.13022032978035902, 0.64319059083066032, 0.22469527222221247, -0.22925968190719184, 0.29107881720099288, -0.15773884759017787, -0.17939950527786097, 0.10333152104843971, -0.64192022325359976, -0.12802479466575295, -0.0032670525004528869, 0.15431195690409502, -0.025061040459112813, -0.12239911549635006, 0.13599875703208919, -0.18722206140970288, 0.027385981607556183, 0.2043110235455009, 0.092013405851003247, -0.45532531019174438, -0.016113670323741842, 0.39414366857355654, 0.30888541436124267, 0.43422879671714609, -0.42541254223141139, 0.075084030525846085, 0.34095328176174644],
                             [-0.034503106759995579, -0.46907313792195066, 0.068809257008767458, 0.068723997691497535, -0.19669557139494614, 0.25387903594666567, 0.6132186098521718, -0.05652697192212558, -0.0020624377598245599, 0.53258939303678221, 0.14832561057670429, -0.37614001481146048, -0.025853253352570753, -0.47367804846365269, -0.36170765662125387, 0.026694419520958763, -0.34365741406585321, 0.14177584439867297, -0.24593952616796846, -0.50037518589537178, 0.19406864139565047, -0.060664437820317288, -0.050138908697933193, 0.70839658787972748, -0.24126969885732213, 0.027103136457987901, -0.36811279149105658, -0.22540834441242083, 0.14364218916699648, 0.086486077236373152, 0.089753757581973667, 0.34142685621709429, 0.27287484238048365, -0.33330855878185972, -0.18289924756292777, -0.15401346187147594, 0.019417761780459439, 0.55588161077467013, -0.062151164171671477, 0.11192502391010635, 0.10580658255383535, 0.00053083348500648081, -0.055821751392965628, 0.082484733332532534, 0.22790867840502169, 0.025548743369667431, 0.11461056570061214, 0.31000404736015086, 0.062539294916564681, 0.39171392771632535],
                             [0.018637521470101098, 0.049561940932440228, 0.059977177131667794, 0.36197275524354738, -0.0014179322371177128, -0.50667196658414493, 0.016627678903220589, 0.090550764904931469, -0.0038515725072104574, 0.23980578691199106, -0.027999476990900735, 0.25475109190286743, -0.22149928270751285, 0.23651598331703072, -0.53608388060585532, 0.14766403036858847, 0.36587767926244419, 0.46379333920781324, 0.014871177579770484, 0.050543098236823528, 0.086010328902339367, 0.1368932307585885, -0.29763070279517717, 0.19723332246449821, 0.019165331866471864, -0.30271134142441458, -0.060241409569909206, -0.11031731305165336, 0.22499895726288102, -0.20474832225092793, 0.60839359683631511, -0.21640736636288913, 0.34028083585503988, -0.079049217737446012, 0.021573145351175837, 0.19228782660967658, -0.11834919381591628, 0.33709292563553889, -0.26481808838679705, 0.15884951138481548, 0.0068323688162566613, -0.0022377696770527148, 0.1491196336391947, 0.11302276353803138, 0.23251453715257231, -0.013363546136958511, 0.12765622711666388, -0.15113519522634697, -0.16015473831279464, -0.22669261551018799],
                             [-0.15607824535197817, 0.1681772312225159, 0.24862296707852163, 0.31815338514418562, 0.40308572018675098, -0.12322671996679568, 0.1173379272297099, -0.42413344241053341, 0.062558769405008943, 0.35299063291288546, -0.25459392807450099, 0.17427983865014091, 0.089684154197268412, 0.11368667200461718, 0.2545269348216499, 0.035252763557427125, 0.33447445774611573, -0.32502429577036074, 0.32950970263151369, 0.010225670923918597, -0.44813246073409074, -0.38692042149749284, 0.19021792259396436, 0.06887945042656124, 0.28684773375843192, -0.03906125332337531, 0.20184359949823394, 0.14361509079156465, -0.43053642477990084, 0.034840435525952285, 0.44058765992313326, -0.042363785903182634, 0.11878451667901439, 0.046068450042747525, 0.095573669826834171, 0.13158900603085757, 0.02628829592277665, 0.037351174196739841, 0.28621274084926002, 0.36391856193991179, 0.21647947228472789, 0.17787585149348786, -0.2835355715673013, 0.4171513255858883, -0.096441654082501271, 0.16825750062525568, 0.045497642624462514, 0.36483393425445393, -0.30482225275024361, 0.043131583541336671],
                             [0.262723996035436, -0.11029027888026312, 0.12390146660484565, -0.040798498429914461, 0.34957640918801747, -0.43028047855671681, 0.054950042460355043, 0.028156203471788911, 0.052237653986623021, -0.47720738897129505, 0.089278834703281768, 0.32420833401288218, 0.11292244682955235, 0.44100677227647939, -0.12558775257712951, 0.40322870737465094, -0.10131527094773109, 0.1345674708884966, -0.64952086514743446, -0.17994133856267522, -0.54366809430851248, 0.28843688684115892, 0.086242039874278253, 0.24738716192852223, -0.38261453293554032, -0.29637456182332028, -0.37712669760030521, 0.033631974038390258, 0.26560234204168193, -0.15709252664261666, -0.23730541726304519, -0.15941754265373967, -0.16934683643150797, 0.28629324472230416, 0.028719975031283804, 0.048111366415266012, 0.031042599951050565, -0.00093762338344817843, 0.045067817023708365, -0.16873143450976127, 0.3993969881762221, 0.31741152252227656, -0.50016175578635225, 0.095072843777914584, -0.10402179187190187, 0.22054731858964383, -0.60491652346790803, -0.26256891160088153, -0.25306197768380345, 0.55921015096233684],
                             [-0.020085038730416716, 0.38258819310814929, 0.056857877605109866, -0.38187986277305991, 0.41789968185156612, 0.085093363189205212, -0.16614822229155901, 0.47330751463445758, 0.19468139111135221, -0.014172482150617574, 0.14404132609541606, 0.30209447751683249, -0.31489870275564386, -0.3932723817774611, -0.20366015775989857, -0.086323877344107791, -0.084325399132188644, -0.042231002835659052, 0.61444043462813347, 0.33907113438209807, -0.25786937214869204, 0.048685436530095404, 0.1728571142695185, -0.20574119230534066, -0.50669119371714066, -0.40679370681607163, -0.23985199133374085, -0.33443171107660702, 0.081900177496899082, 0.18700992218236634, -0.30852984080822055, -0.40110256892495671, -0.40313739119466352, 0.16392931602256502, -0.02887909059100174, 0.22019746573036239, -0.18503222349777884, 0.28967313794880878, 0.011320544284184775, 0.71611874002829734, 0.31999515124752853, -0.21148237495526545, 0.0039317221562838369, -0.071884304046784225, 0.23403356168117043, -0.05842965563816678, 0.074594941761380942, 0.084009711133809589, -0.44392820423014329, 0.23832819399984542],
                             [-0.049302157915703797, 0.035269691118124266, -0.17615632367283285, -0.096894974920697638, 0.37371248532279322, 0.56620113556529805, 0.34935432293804447, 0.052019237708050864, 0.44146361114698962, -0.0088092942767527826, 0.24671573786856638, 0.2815063729726941, 0.14392019295462841, 0.026741360853095579, -0.33789124847392971, 0.066735246103919052, 0.015059010166858317, 0.24184670890922411, -0.57835165119580834, 0.18526511662965631, 0.18251165393692512, -0.22594749004149356, -0.084202780454535664, 0.004083000915147194, 0.30256162037498407, -0.057779542881033846, 0.18343185969184164, 0.11455675318357311, -0.44436842506266333, 0.36866937375054926, -0.013212464629438276, -0.23479848807467513, 0.20434352295927055, 0.40889311024146952, -0.025709627855301658, -0.089241477604537656, 0.0029118273284641435, 0.21958878094631293, -0.61370903154298728, 0.025161288520066633, -0.18184834177175349, 0.40455349532235074, 0.12556640951291098, 0.20049396173416714, -0.077964945885087816, 0.095142031055151094, -0.18463693973393575, 0.40174132281842917, -0.59933996463935868, -0.11577507609183903],
                             [-0.14345678817855395, -0.035537943054903577, 0.38059758385644982, 0.32803277889888022, 0.32474803211447112, 0.22094180042588016, -0.14388627417685726, 0.2460264034280755, -0.29604940831680177, -0.19800529257630267, -0.060835659212168006, -0.26540490935672961, 0.47219343217801135, 0.36652926803401775, -0.10104721874468253, 0.27858977248627492, -0.0020673474369411002, -0.21196807550709137, 0.23402305660359382, -0.34879928465940491, -0.1440506886401815, -0.094053048381445889, 0.16591706711398121, -0.27547482452251598, -0.018700282282570247, -0.01076872076817427, -0.36413550248969517, -0.45829543037057485, -0.030738559104662319, -0.15257712810701038, 0.13819210639236654, -0.20425496996924361, 0.23555324737549563, -0.046175448308124492, 0.36675547573015715, 0.063244629626910034, 0.1867594421199795, 0.25418076780923299, 0.033336094201402371, -0.090827132365985525, -0.24090574143613153, -0.38190870004517447, 0.37989068218627836, 0.1390053809895011, -0.27315903988257639, -0.070092892619296757, -0.1966472292752322, -0.25734970677718944, 0.33568196336288258, -0.4609285221355176],
                             [-0.75062521773318114, 0.48074219330918561, 0.42438968037575492, 0.041696078170683888, -0.10327792033625874, -0.32034734217136118, 0.22127763624995361, -0.16320144172554821, -0.41775650475864473, 0.27819801407072003, -0.042720372318675967, 0.30940441344347952, -0.12620094127717882, 0.2561327577046203, -0.066703827531943871, 0.24730963263119668, -0.26737523116955453, -0.10597611840321361, -0.21340321187555186, 0.31955967476246849, -0.037375357209172358, -0.28814112649631313, -0.12091163637634006, -0.43953626290001507, 0.34277748222316046, 0.20299985541721075, 0.031557856482213979, -0.11700606075722109, -0.08572425865889477, -0.085674684863004544, 0.12909405337760843, 0.44605420908770371, -0.17975203369437198, 0.31658475135672098, -0.095229812868244959, -0.016049318289704639, -0.73442314811032861, 0.20916031398907314, 0.1441148091711035, -0.35176494268044861, 0.31658638908975689, -0.42784761673033167, -0.20508564044096983, 0.16470186018003657, -0.25101466363416314, -0.1772606421866762, -0.11638084940602829, 0.35965235344571861, -0.065710202970166706, -0.15476604118373224]],
                            [[0.060757486975191316, -0.57769596338164275, 0.068569780449835388, -0.28125347737127193, 0.033431529264937664, 0.081054099123638979, -0.18347729781912131, 0.14517446395490205, -0.26323329472220885, -0.27213119164380645, -0.021123618793743845, -0.15278873021508904, 0.3342525254225443, 0.19492102403645542, 0.077721514013838741, -0.19949654256071908, -0.039636041915367716, -0.16218496260132947, 0.0090900092630888541, -0.10905683900406739, -0.26708180234307588, -0.13127330208921689, -0.33489378977495071, 0.082599587026599572, 0.078283984191950179, -0.52134549924456797, 0.2185369549085438, 0.29440780733288396, -0.13149043001365923, 0.1589514514424995, 0.34848190380922722, -0.05780098008599846, -0.019454149956362292, 0.08357303441545022, 0.2106282401793155, 0.18940049771777118, 0.02714667381651608, -0.041034111520509092, -0.1888183863107657, 0.46594458234635799, 0.19689739100177941, 0.16470460472976145, 0.50512472200166003, 0.0047484115773968648, -0.2998835426074542, -0.05795570468201644, -0.18634178271360874, 0.026188049952950997, -0.05049762042957897, 0.12967859371487467],
                             [0.16852017377715184, 0.052586191429658313, 0.10781212969300795, -0.028645877683686476, 0.069589503223609198, 0.16719255659481028, 0.14140960777879175, -0.020508756657662389, 0.37872863729799955, 0.062993963647135193, 0.37675984430783316, 0.6331452748251486, -0.09413024184405952, 0.1958281280700252, 0.5045392552912501, -0.012432276660858962, -0.3051584541382637, -0.19622360077856896, -0.14108931673268421, -0.10600201757585827, -0.030780901645661139, -0.28544057586557642, -0.1583415834119101, -0.18160220353745712, 0.036008553282455537, -0.045972242024648266, -0.23512885910158635, -0.09252210633843172, 0.30728957917643041, -0.10911078540324838, 0.043622780622631994, 0.25391227590405818, 0.18384947075963914, -0.06592512452039255, 0.088567618343081689, -0.12160290106468714, -0.083222036503737259, 0.15746768673806216, 0.015386289947021559, 0.067008438386925412, -0.28652492680129155, -0.19708764811645149, 0.23782261867904866, 0.027719490642990601, -0.21118288307929531, -0.29421657908883009, -0.088508065733088573, 0.059984596171903715, -0.317591692754225, -0.16829670811944653],
                             [0.33393877971028696, 0.032541241718101625, 0.016924247415504128, -0.17306776707212762, 0.04723355032456357, -0.17309722142645598, -0.15013825163373493, -0.06178347165644002, 0.11283139769367376, -0.028852275832881642, -0.22857515610145723, -0.088302765952465043, -0.038464528852448852, 0.24705391201782989, 0.017015846207868567, -0.052980270481035804, -0.11532186691691873, -0.19798659465775303, 0.08867729139373029, -0.31603143458819477, -0.17082741305822713, -0.12907515505163145, -0.11346846343425739, 0.33119211788032743, -0.079972635538873932, -0.38073831982688244, 0.0045206865802239968, 0.19629303146985055, 0.49445520846848456, 0.14428095566458388, -0.36843610263541671, -0.39344865875433815, -0.63012955984371932, -0.15615024994925408, -0.012976658583863862, -0.20176888061003709, 0.2881480611510997, -0.19966426653829888, 0.09612731767006813, -0.071620556714333983, -0.3439482538112551, 0.092132667304400562, -0.10954193294158784, 0.12646078061343816, 0.38827369883207835, -0.33541441222139073, 0.13799163255578392, -0.22279452753026269, 0.014198093244675787, 0.14779027786603774],
                             [-0.56276396899598136, 0.093616249389257486, 0.12152579500063866, 0.089735257887499115, 0.23510766377165182, -0.17665418116266549, -0.17296914954658341, 0.0597158226436314, 0.21677803027120229, 0.11953230615476423, -0.096445496101149053, -0.036223831914523996, 0.1947114635114901, -0.068385507997318379, -0.12376839997205887, -0.07918650340029032, -0.026129409566828039, 0.070095349577065522, 0.10987000896298797, 0.12030973774831523, -0.022747705836775024, -0.27615313777943079, -0.058872451102242068, 0.18323170892683499, 0.48673541688522537, 0.091281341505433641, 0.12570312579184345, -0.20303619173470977, 0.075286830181133413, -0.20716264251747235, -0.095093979021715097, -0.0043412400316444055, -0.0010791357019311332, 0.090347492674804339, 0.23565587163091922, -0.089042083546206255, 0.31648837773427391, -0.22056516673931512, -0.10185218410995261, 0.27601901831549375, -0.014659794820480989, 0.057399418539459415, 0.29262023972290246, -0.51771633008883022, 0.37649062951691076, 0.21775167930154066, 0.13282244971670662, 0.12001124607931218, -0.14806722998475014, 0.39552610720072079],
                             [-0.44506378797982282, 0.027362933029584306, -0.20888147471708701, 0.15447400517046767, 0.23430368765859974, -0.26474258883892743, 0.19677198892159045, -0.049405791553876949, -0.013700278123517706, -0.22746859551711748, 0.028246159694792952, 0.032495782647154622, -0.008646998507414896, 0.077010981719689189, -0.12613652065084377, 0.23020873708427247, 0.076772882433884637, -0.13620710899796648, -0.19730338970569819, -0.0048324613272052331, -0.052785146137703888, 0.13183445131878577, 0.18769960452158091, 0.017490427670240283, 0.11911185689335348, -0.50726455223345057, 0.13701009097266503, -0.15062654622736282, -0.014348728827788038, 0.15700818214465673, 0.094937331994111862, 0.0028574431464247693, -0.24800382442380625, -0.16741264740306616, 0.49501027153826804, 0.15630451555736313, 0.28815103185057311, 0.22798963497867233, -0.0018897982402069444, -0.13963604088941564, 0.09492125584426063, -0.31384807610083243, -0.0030913800619050934, 0.212461780212025, 0.10576892930380997, -0.13847202554418428, 0.14583227297450144, -0.18951148841668802, -0.42043996882737827, -0.59889250986985887],
                             [-0.08950019826747016, -0.22646145389609515, -0.16955887069866654, 0.11940436856486164, -0.20635984051491124, -0.15557429127569072, -0.03506326849488671, 0.2639213042889792, -0.37699887762439449, -0.050744205334685377, -0.086246025243526259, 0.10484612983021432, 0.097200418826933158, -0.31316953838403294, 0.092379375473741518, 0.11712283027438862, -0.14570555304474372, -0.074744987210876482, 0.031998136985182911, -0.1316499887863809, 0.035397571859757712, 0.12601954463225359, -0.36548788793245435, -0.13264199977795119, 0.086343550364665581, 0.57906087661052452, -0.27109180573597613, -0.047392778076368929, 0.073143830785618341, 0.24841754958437232, 0.16791822310743931, -0.31922354880159776, -0.134313867090183, -0.082831818760357417, 0.26678910509289661, -0.14444280432937784, 0.13815439612465599, 0.084569325989099303, 0.091295711013085548, 0.32020795736953922, -0.067713849667414158, -0.3505513460094874, -0.17113400826635844, -0.12110753648104995, -0.1475011557667904, 0.02614991061012889, 0.44529282882942339, -0.28584819469012601, -0.0035037566575363832, -0.071466417638912288],
                             [-0.15585757865966307, -0.28063426638502575, -0.11555343211353231, 0.1350277126999275, 0.21744105563878913, -0.15698780588475825, 0.22594854609482268, 0.04608595497513264, 0.3652883074930216, -0.083486273470047279, -0.0059710916740590217, -0.17921553986259553, -0.15543399562970744, 0.14073972945699928, 0.00828735339731939, 0.17498732727993438, 0.011730623517631983, -0.20644107298551606, 0.3203787720555018, 0.27468830899023433, 0.12238801372037111, -0.036148146781763792, 0.20058099057185186, 0.643767001157736, -0.18179123261313371, 0.085484736610099213, -0.19681040268073879, 0.047945486944556193, -0.20081415477635606, 0.015308102431341453, 0.32817268773563385, 0.19926901834817032, -0.04039871834049847, -0.25116976409189917, -0.45870337893420077, -0.015747282556202863, 0.2625568401060015, -0.36634362194937597, 0.068732444393499278, 0.25197514330382531, -0.064218799507244115, 0.092848004103659149, -0.34673550325289482, -0.12081817179389562, 0.14625331915621911, -0.22048572439213537, -0.11861730625781508, 0.098861446338514111, 0.13180584006432935, -0.36569697274197088],
                             [0.25107907487982495, 0.19026191984694696, 0.0037537107558701724, -0.02264027019586029, 0.23121139086339451, 0.018971667240940598, -0.079195962885227136, -0.09201689578839331, 0.2146680772558171, -0.0089473167287994777, 0.030023062588268448, -0.37580082036259188, 0.31661404441488239, 0.15199802883986213, 0.15226479108023216, 0.27440781959555588, 0.22028717692981076, 0.20972648605235611, -0.097692399156269441, 0.039080311844253889, -0.083495826428630987, 0.24465948684974534, 0.22535762990838096, -0.17315863401738746, -0.12509463729155185, 0.096441806637630217, 0.040044564120264414, 0.34579991628506179, 0.058127141307160381, 0.2932568483895277, 0.41105933669581712, 0.085711745561646596, 0.07233427917537695, 0.032574092455635008, -0.10343442760252498, 0.26932828247620388, 0.2409727416532329, -0.26084645662072503, -0.6076191307721206, -0.18930120952595603, -0.24469925289785666, -0.26766361512340037, 0.1175478443787413, -0.16729854300377694, -0.0088786981572658262, 0.017542791751477001, -0.17657119654576803, -0.29626824818213116, -0.15104541944058886, 0.067923051402782875],
                             [-0.072032180664522286, 0.32320318727681602, -0.36088356858655968, -0.068509377419365566, -0.31191644156659587, -0.026220095992035019, 0.089220429972629217, 0.38792641299783814, -0.036618125296154935, 0.26879651930138898, -0.10941150165971411, 0.11503575966241622, 0.4710149313413407, -0.14981964532886352, -0.12047637864035324, -0.04547787930894736, 0.045736110170310498, -0.064832909166809324, 0.16479648268274333, -0.11822446326071305, -0.076593822280715082, 0.16371480845584796, -0.10431855505378446, -0.0041203294592538284, -0.28241043251917275, -0.017119408136911117, -0.15001551077715786, 0.072481145831940777, -0.016558154854327184, -0.20532818149888318, -0.1102838255781023, -0.045275862807988579, 0.24359599068716867, -0.42245224209270094, 0.055256172199563587, 0.42676108475180297, -0.09444292740083278, -0.23834254022369236, 0.22034673199946711, 0.18159205431922593, -0.16913163232218162, 0.047048305976718448, 0.16813303423958714, 0.18766827673269826, 0.21452630798625646, -0.36024948331623113, -0.18879631800372229, 0.032480696374005275, -0.042875255253999711, 0.23982584658232886],
                             [0.14111264769000567, 0.26021104859208793, -0.18429615838732646, -0.079335723051396162, -0.26334497208803653, -0.068600506806393, 0.20183973595231722, 0.1751729756395097, -0.1516377754852053, 0.05829174510315735, 0.23091724762915461, -0.07948634528245456, 0.25454822720024939, 0.02287375904245445, 0.1629477871900821, 0.10863322257268408, 0.094264028235634637, -0.20047971221417418, -0.61381738150102916, 0.31045795912299073, -0.28303733853283086, -0.10575122547159879, -0.13974654590433011, 0.14029026443093381, 0.055800991105337969, -0.082813194183956898, -0.21742792185673693, -0.28103560092280144, -0.3468571647424632, -0.058434961343619939, 0.041053630372525782, -0.11600129977600152, -0.22060619314205823, 0.39036692703276393, 0.063199206223871221, 0.14293155919056474, 0.32491028463254806, -0.30626638557571506, 0.015226650779414748, 0.073445173064337052, -0.2515755979976998, 0.33535703717251547, -0.12342597526961747, 0.020895322595322716, -0.10171703837289851, 0.30768055311687836, 0.082577948919511812, 0.034307714984387672, 0.31615407191558181, -0.23131541181078843],
                             [0.10697325006077463, -0.069200671920093479, 0.036026825215507194, 0.29192987811089205, 0.19059300835414522, -0.68334321537498011, 0.15167574312367343, 0.057250243384205105, 0.06939359909674428, -0.052048829995581324, -0.058363758073358737, -0.25500867787347242, -0.0080718943482594851, 0.031326559484562408, -0.064581644654202033, -0.43307420693670151, -0.20650205205381611, -0.064384327619247353, 0.18770937149267966, -0.30743849748509777, -0.33498763900810941, 0.090360376495086187, -0.11524213876036306, -0.2529627535425486, 0.035790219548736249, 0.43372866741134564, -0.080851882753487259, -0.086219804409040215, -0.19441691715270532, 0.25260096249238639, -0.10027172200510844, 0.53828879782449546, -0.09733727831213819, 0.38919641087355011, -0.088744491366952838, 0.23480649674545803, 0.094813671414277753, -0.040037567099450264, 0.28425688614430228, -0.17742854836156619, 0.25782174188478557, 0.14288082933277066, 0.22236170049083759, 0.081587364280798921, 0.13885297429634311, -0.17041183217127986, -0.027486420178916848, 0.03177147561486935, 0.14030932773253468, 0.0072271532668266884],
                             [0.047871893641543581, -0.30744504197543887, -0.10286233675635126, -0.19783157898569009, 0.044581724107867537, -0.4019594006131329, -0.033575810964610486, -0.19713314993198455, 0.22345101657865574, 0.23044849961918651, -0.0097004114014153896, 0.19757414857726621, 0.035790930019264748, -0.48413029857532625, 0.10508785289741394, 0.043889706606346918, 0.28112109143233377, -0.53884350622673072, -0.32381960782752384, 0.033270941307231967, -0.22370901411587402, -0.019805122951824294, -0.17398661039616894, 0.24836799684584643, 0.036042908781757324, -0.010749135901802039, 0.048681694331501102, 0.47230894516085187, -0.17864060653277758, 0.15910534790233952, -0.43361435411004773, 0.10040870665209886, 0.089952917457430115, 0.099119376183604793, 0.002101446095078216, 0.092017084632164001, -0.24087969546426335, -0.21421750228536815, 0.028429439278574352, 0.026855965002149821, 0.30834896832568764, -0.11948682122181747, -0.26505400273352797, -0.024685857466374552, -0.10099555541387399, -0.070252504497882048, 0.2051132974982644, -0.14790931788182324, -0.27855724150844691, 0.14117514096139647],
                             [0.060256028810393575, 0.13376868161442318, 0.096241823104841751, -0.38639257562918294, -0.032596040158973993, -0.029786043797156367, 0.19027402006330593, 0.11157057302046693, -0.10634629245727682, -0.086084096904770674, 0.12380395738706501, -0.10210429929368661, 0.22846415463837, 0.40705729655294731, -0.075519757959826003, -0.27704648657153841, 0.14350187197914407, -0.38514859489780506, -0.078854060192010661, 0.3551518902311791, 0.20903908001354543, -0.33444548898946574, 0.24259999867707557, 0.013466199468482577, 0.034512413459644509, 0.22198869409465324, 0.079417389036224473, 0.11330180807163251, -0.088116671418360576, -0.17006610072543205, 0.28970372144551693, -0.21849063670453062, 0.19966052429005315, 0.35260413011388347, -0.0064646232804505405, -0.19141460014569356, -0.061865233540484177, 0.064495823798482899, -0.1124351131703783, -0.10931903316462568, -0.038874736868801746, -0.32597143060090922, -0.023285815457047748, 0.021818457200039641, 0.29891122075893695, -0.59281651960699544, 0.19866302667438837, -0.089105073738722784, 0.18534138033515418, 0.11938563981513148],
                             [-0.11426569207128522, 0.057198065217490393, -0.092503034800458961, -0.04210094095090746, -0.089798722682279911, -0.35058325299142756, -0.12730508948881558, 0.07406757255732685, -0.097226795579208436, -0.179911294543315, -0.053972340393207488, -0.25996158776965428, 0.15083645609448457, -0.15348408667520161, -0.06349038717995073, -0.24734993429740021, -0.10800423452127846, 0.13130857090577211, -0.20201127815342498, -0.19627381491805682, 0.5728574085596787, -0.12363146582692225, -0.0035627308833422978, -0.08122155014051699, 0.27536105060621618, -0.35686339277272733, -0.13825661255711924, -0.036915400615867171, 0.31692864113331259, 0.10448248572139963, 0.45007293296803674, 0.050086425884211777, 0.17446267981162755, -0.023868102841691521, -0.1122539651476349, -0.31387559480952981, 0.039605306513872993, -0.46098724457818313, 0.37122314430944259, -0.35541418361164512, -0.22352765610022909, 0.14701690922877436, -0.2449176782470234, -0.028410892466816627, -0.16094324590055248, -0.13485462770600878, -0.16346589277982626, 0.144330934733372, -0.12695275449958313, 0.031623924218505489],
                             [-0.03103078951250763, 0.20751039421642783, -0.33626939120792432, -0.16315326632294325, -0.10777501349466131, -0.01732082513844415, -0.11769029455858479, 0.022362982336336948, 0.12463202198073883, 0.16761633452118524, 0.10951715571818353, 0.015530735609933732, 0.099959301665761516, 0.093376697531222103, 0.36472064849602531, -0.45161101365256523, -0.0038336279713144855, 0.025789956916646591, 0.032364780233217295, -0.074261885267538741, 0.2115650939379308, -0.0052963082391214358, -0.28033453864695179, 0.056265712105482965, -0.20881666132372706, -0.1294447670306178, -0.12488667134349671, -0.017445580799113909, -0.26538932089060108, 0.51715361033008955, -0.15305407633712453, -0.043152994616015621, 0.1426916261471145, -0.22967390748118738, -0.16602689872382345, 0.10234657884610629, 0.28934551354365817, 0.33752940688266464, 0.10862818357314563, -0.043622366378015573, -0.10116870001936731, -0.096947817083439719, 0.13223974183541157, -0.1823660550820182, 0.39464998979232835, 0.35823320641667539, -0.013771392958480316, -0.023598235386158822, -0.070265590028807293, -0.23297769457938214],
                             [0.15550663017335825, -0.036788914468502534, 0.197516547522535, 0.22711928705869711, -0.26887529710445129, 0.18701957461578139, 0.13695988639666809, -0.23690766161215387, -0.22079169557371603, -0.089995047599281702, -0.098001889107843021, -0.054683776745394166, -0.079086308897106425, 0.26018781478492287, -0.072787419416197124, 0.13795855951463759, 0.29336274950063213, -0.38756280471476273, 0.20700564661359194, 0.36572433392083475, 0.14564276147405525, -0.11119057517507955, -0.25728264686253782, -0.30222421492376539, -0.032474467203974233, -0.087934519707690548, -0.37142197627859552, 0.47550910136464825, 0.081062242867443485, 0.14878529803946752, -0.17474266211005657, 0.20930776928368006, 0.13198343011848737, 0.14232296791540944, 0.39381357031582187, -0.037561443703980249, 0.45243158967634639, -0.066102598413157451, 0.022329373417386417, -0.054539169298786425, 0.20139828966524792, -0.094115874420785228, 0.017196141092195742, -0.23042985160499621, -0.096615086706555164, 0.0052102784384593023, 0.03449873741407275, 0.38616826644037749, -0.048910268147117332, 0.12380832069573459],
                             [0.22421161322543692, 0.16168698305418691, -0.01373721409947532, 0.45843707688417795, 0.17740076423625584, -0.015483093106074517, -0.61143861529125243, 0.35074667833968554, -0.13778931808183334, 0.15536932231433864, 0.091614578522554294, -0.12202479006508603, -0.15280384456350246, 0.17023989465683489, 0.2251709136403027, 0.18992025023009027, -0.31513812164436783, -0.5792030785716028, -0.15172978971678538, -0.14291845911941353, -0.18501968010390091, -0.088596957001798732, -0.1436417595902548, 0.2226519933920206, -0.049508107888085788, 0.21038268705824081, 0.22858783160935298, 0.15703306596179686, 0.37279046950000572, -0.049755536937627673, 0.013810591629880103, 0.17624583961277321, 0.44863136038876517, -0.21263844181636007, -0.046141049456438821, 0.14426018335897492, 0.04786112759764128, 0.23131077547618656, -0.16892933447983643, -0.26246738863512864, 0.11945239126889667, 0.040951211989157042, -0.19401834379984587, 0.1320829461867655, -0.1008190453032462, 0.039053140603679537, -0.06642837770279944, 0.083827747494397128, 0.14424438497702258, 0.0014471242244662892],
                             [-0.17898596234263009, 0.0052684493619775726, 0.31251650504046957, 0.26938606545210114, -0.10869575379820313, 0.14226826992957592, 0.44315934854067879, -0.29733958347260236, 0.41778460384746791, -0.15170138208317346, -0.35210978998764958, -0.25288319652339764, -0.069967530349771281, -0.023790222080625822, -0.28965861553171651, -0.019175355146251807, -0.055668369032094586, -0.11453273701424904, -0.43628063449072851, -0.29890731864306141, -0.057602850149535249, 0.065622338803148036, -0.18394410561526464, 0.10027427395114469, 0.33720402272946814, 0.14771265777740103, -0.0016787487150020583, 0.069210557795122502, -0.41342933001701859, -0.095359942074697862, -0.13325590618351202, -0.04002006525711161, 0.26152769916780899, -0.21621857264604732, -0.12257639268137191, 0.18277136997318344, 0.1236371985185666, 0.26306403694685121, 0.16367282928588889, 0.048771323844918113, -0.40451432961923167, -0.18002281370633472, 0.021422527444428088, 0.19783350987703219, -0.10387453655830112, 0.18066270840799231, 0.14274876279147128, -0.089401441807747922, -0.098829285759477095, 0.15426963883436121],
                             [-0.17612234954512429, -0.15939538867633524, 0.10230477952777685, -0.16903633094078011, -0.078223715435614405, -0.082732330377401908, -0.24820274480098084, 0.04001555229053054, -0.21001065247198883, -0.069521014761459027, -0.1329322603361951, 0.26616515612518171, 0.3814858239004269, 0.71651846431708033, 0.081340368731098206, -0.0042403988850053618, 0.18420179381033255, -0.045295649230454274, 0.093458432559311494, -0.045304823501593712, 0.0044493520385491727, -0.10042813789460332, 0.20069551472084129, -0.12387192299849734, 0.2990326775892494, 0.24073263581135732, 0.14413602339952025, 0.026663198410067375, 0.1619147620074545, 0.27641039168823339, 0.0086823549416039612, 0.49736196479752498, -0.10590782132790552, 0.053622186881967307, -0.080576225794418754, 0.26163257690511466, -0.24045465223714341, 0.30774647474567374, 0.31814437134128898, 0.26967905063916703, 0.05490448201631852, 0.0029122099941455981, -0.3131629910370381, -0.091978853907853861, -0.066033382642169319, 0.17119935463019004, -0.12312669069270507, -0.11868298276746929, 0.016957838910549503, 0.16330153095785663],
                             [0.075112886531750828, -0.0048476139514673413, 0.00017757608401522407, 0.14204661729275872, 0.030949459982467432, 0.081734535718185508, -0.32150738332801326, -0.19215690373433542, 0.044900338168057399, -0.11608555883236299, -0.00279210736585404, 0.2758869660858479, 0.047440731076995819, 0.12924839392345494, -0.00056395583880233108, -0.3749161594322849, -0.22299544081962003, -0.2615903543001159, 0.16284480017587596, 0.16347465398144811, 0.14001469737074265, 0.25649991346048223, 0.34502637912284201, 0.079600747747471223, 0.0051153780970546112, 0.059112176655296333, 0.009719911131686243, -0.18318240273447273, -0.41741459873155001, -0.013915933731159095, -0.017504567101739796, -0.43735858334350752, -0.094884107958908726, -0.22918826743735166, 0.28032058173430074, 0.13110552470939743, 0.02414866945877521, -0.52063521347674002, -0.096458880798966598, -0.19896953646531038, -0.067167449865220802, -0.17749987153957203, 0.09948939499007417, -0.13803848951950665, -0.42995567257857947, 0.027759004190990477, -0.33203055841028606, -0.14085418725553356, 0.2837123889713003, -0.091885905534931672],
                             [-0.036071479301936743, 0.40588605209004575, -0.022405612330151828, 0.0098415719566608689, 0.050479384311310486, 0.037415295667869386, -0.36807234354360896, -0.33871546591591029, 0.16478098031162289, -0.2343173754991616, 0.024011494686685217, -0.24796311685258896, -0.35593956462344306, -0.20162929049179618, 0.19026099217817638, -0.22414854349859537, 0.16415632998084365, 0.09111308158782698, -0.18474408681589488, 0.37551955043995455, -0.051151897433942634, 0.41327760665711688, 0.09794710013477953, 0.097918981715547318, 0.24579571643754655, -0.0078405553151112018, -0.59192428849681522, 0.11266937365931434, 0.15347556087978065, -0.29325878327747901, 0.37164108773822641, -0.082479380363768381, -0.19752395508264387, -0.059143199477002834, 0.053401808476073599, 0.37300687906516006, -0.3868563261025123, 0.34795021335873533, 0.1951214051753819, 0.13118320774258846, 0.064071865826485871, 0.086954514047457257, 0.026053947840706478, 0.024969397898868421, 0.0065382004265441256, -0.17166581724970961, 0.078290449284589531, -0.053674193177552704, -0.0020870157423635554, 0.14067046597265592],
                             [0.29967975756094511, 0.030278122581060846, -0.015930975708591921, -0.17912541024699025, 0.099517831913308041, 0.45533397476859994, -0.016317734000378534, 0.032938429599134199, 0.30744881363744631, -0.11142414677549758, -0.050794559936879292, -0.32998073531507771, 0.43566044948808602, -0.20325300914121153, 0.06785705299594616, 0.028508851914937253, -0.3777324235567488, -0.29946376952545417, 0.094227480597060612, 0.20569949936023904, 0.10274908675921914, -0.11353080498415091, 0.26062573330305755, -0.20388475401724754, -0.081970452271812613, 0.058187336770827637, 0.14288141670321172, -0.18233742319500112, -0.017399324824746942, 0.048883215012939359, -0.18938244457044601, -0.067977143151320807, 0.043299047291966562, 0.13878510788272569, 0.23056170958960434, 0.16885226552402957, 0.16606843575879204, -0.0083175158391000648, 0.23621872019825915, 0.31122765188072204, 0.25307614827619657, 0.17005680895433634, -0.28397245436967994, 0.15905771321506335, -0.047244209180611021, 0.050749339726374423, -0.0062273104188296808, -0.018013424164254603, -0.28784347326512399, -0.24185155255643176],
                             [0.0080116724934785853, 0.20539713439247254, 0.44963098640082694, -0.12608876086987206, 0.16674358406114306, -0.30257644326120231, -0.13035666858946124, -0.078686489113874714, 0.060611869567385443, -0.29906692602982576, -0.14923365504228117, -0.10516313732685756, 0.54019083051964434, -0.17071479041972223, 0.19201795663383747, -0.065436657213961927, 0.46824035393166813, -0.050388441606341969, 0.45790636115511996, 0.10358201995533566, -0.19877925689766318, -0.25608577414805617, -0.053378259482223744, 0.060446534538903647, -0.086635867183955606, 0.060015857294315189, 0.16494928075084589, -0.28453239311245682, 0.047254846654948876, 0.22606727493504122, 0.30466698468222275, -0.025203383282788049, -0.20726992818427592, -0.39576215893070116, 0.3266676004093616, -0.078949377299926571, -0.12809909706749634, 0.33483728034051496, -0.010151682160734015, -0.28862323166115383, -0.22128093580053174, 0.0027337312380990852, -0.10667633981537876, 0.038908644350897366, 0.013916795303350295, 0.044693261269878007, -0.019212224201725952, 0.38676790269005712, -0.021204006671109173, -0.15115783997171317],
                             [-0.0012985507169256255, 0.15620009345714217, 0.44450896120143263, -0.25654706275419753, 0.050928761834872369, -0.23092508492297764, -0.09492081805866949, -0.40079010755272604, -0.53047018903979226, 0.16801993997716133, -0.081590312717215868, -0.10198443908496559, -0.009229795717399087, 0.036262183906541033, 0.077906242986196528, 0.34146981411022359, -0.3315468342969633, -0.15583548246686396, -0.24894298251156641, 0.0079015073856172277, 0.11396204807723417, 0.068527057033143435, 0.13561234104178271, 0.10208349418430314, -0.038663473563206194, 0.18900464654419774, -0.15671178884911074, -0.19145248784767482, -0.041206860726475524, 0.34459987947482607, -0.14173607764535387, 0.064477688694437901, 0.043988517019345877, -0.041190530614007695, -0.1047964548605807, 0.12267948376615651, 0.044136843070811033, 0.02683835984890455, -0.23122147800551121, 0.30295324872131629, -0.078515562474010259, 0.36699482664761646, 0.084824709046404476, -0.1767357383683637, 0.0026635844426413213, -0.42890824763933744, -0.18179847594474505, 0.2788187480868875, -0.067591955709430399, -0.1041212418308997],
                             [0.36650122974977245, -0.12726484745642463, -0.09111301645968943, -0.027884546672018638, -0.24806598364086282, -0.42702552942371907, -0.48477899886622844, -0.10027223539942942, 0.1424783911437412, 0.023243318715444106, 0.18179823263343528, 0.23234495118883389, -0.063790394143655199, 0.19191108508072979, -0.55882478269493485, 0.12774068864041804, 0.07559883319921859, 0.46408671826465298, 0.19441350532830057, 0.18249596853879277, -0.0035004524700629905, -0.19240867631947611, -0.049290707873864088, -0.057372402904574946, 0.21960258053451434, -0.054063321545470687, -0.23966714517405827, -0.034906001151021979, -0.19174989500320921, -0.0035401769663831978, 0.023587218628088526, -0.13821977512425776, 0.57214448203666757, -0.083325846863876979, -0.040687030726646825, 0.12819801150940868, 0.052922530868160171, -0.021991513674419219, 0.028020617256681851, 0.077334403558353484, 0.054605153927042203, 0.10831404434751254, 0.053635261563137249, 0.40597597364451904, -0.0039817172724256004, 0.090224718737577633, 0.26702468291412718, -0.11523995890861691, 0.067595940292354231, -0.16255830382109898],
                             [-0.23585480199356335, 0.41558068509535268, 0.22453488089407309, 0.059297970400222846, 0.065957659804897553, 0.06673267910236505, 0.16557455433799131, -0.13146236412778642, 0.060435291430489271, -0.052983718361738721, 0.090124772952987445, 0.42645901226539384, 0.45576026280708926, -0.091240905742508829, 0.11908949606630599, 0.019744090061135033, -0.28432457387620147, 0.31238492807440271, 0.010199901461700295, -0.24427704301400707, 0.18349768961814705, 0.11997654471529767, 0.060442430466294321, 0.2099909765435167, 0.0071559597967054828, -0.091397714276175782, 0.030263704740091952, 0.70410674829186148, 0.0083248492572633309, -0.011804987664067483, 0.12329976098555667, -0.16515766169994928, 0.047150732609809551, 0.088214035910164038, -0.069906730147684351, 0.15974422941033559, 0.094422521368086029, -0.15213513578727011, -0.077558242844872366, -0.060064769970764459, 0.54786798115417068, 0.24166382065147812, -0.10950558733252719, -0.069499609428429365, -0.031470275184254021, -0.07358655104372569, 0.50573820760223842, -0.074444255659945238, 0.43342232631692429, -0.045960047824443358],
                             [-0.2872300921612978, -0.18082888511760381, 0.3847846100229787, -0.035511441806400992, -0.15398423337964967, 0.0046012361807949223, 0.080019428531445475, 0.22972367586965312, -0.023763478158019644, -0.78170000435391218, 0.20260453441949164, 0.25106199572004334, 0.066741154189048246, -0.15846793659034966, 0.12254370709048321, -0.032464563618888706, -0.075347815781677902, -0.04577194681818228, -0.10661477017644767, 0.25934841677182036, -0.086698087369770749, -0.033331617506980965, 0.098271284087567273, 0.046287049487083926, -0.096498263961403499, -0.12850722997992695, -0.2846628413563167, -0.25076323127380279, 0.013636117008178659, 0.021699683952199653, -0.32112265038346693, 0.1231686051498735, 0.20652459852297669, -0.12618811519591933, -0.21641684105462444, 0.23480392178953943, -0.014531627941466459, -0.038879886228068879, -0.27346176517261883, -0.32594096288801799, 0.097341833389397267, 0.18455142971993688, -0.15750159078244869, -0.27082371500310992, 0.23657490002800138, -0.029907031356910006, 0.17552517966788739, -0.31195981069599554, -0.061735075066769916, 0.27571721557812551],
                             [0.3730519279115932, -0.21999399469172506, -0.060561339271900577, 0.30106870230088795, -0.10075710023987772, -0.28958778105314759, -0.064952626638269395, -0.18966029696387826, -0.05030951264013938, 0.15686825903090462, -0.28811763874729279, 0.066940758495575334, 0.14295053170863298, -0.043604645305743872, -0.22251915715212156, 0.051462999955435296, -0.21934291327841457, 0.080283942502116873, 0.049824987349847555, 0.34920878514869103, 0.004105741403621784, 0.22077743426349061, -0.36869524652023622, -0.044099897975273472, -0.097326299635139821, -0.27875967484667818, 0.13274095976904121, -0.11971208296307294, -0.18520414402442281, -0.50657027910876806, 0.32554252887657692, 0.22038410579315648, -0.016291499423528123, -0.021542731359756005, -0.15199856462859804, 0.033865096524568344, 0.0095899938181808145, 0.35037965159648354, 0.015735286792345364, -0.039030320320566581, -0.19548570413711652, -0.04185145887802702, -0.11582406889761671, -0.61328736030159225, 0.067530280446780139, -0.077259750670575694, 0.097565692516307145, -0.23471755618311224, -0.2460610045192822, -0.058180996074435928],
                             [-0.31377281467601859, -0.17836984298098962, -0.030167472826059992, -0.13080976435631927, 0.23794343444403715, 0.064091836161253773, -0.28946175795874102, -0.2665759334798059, 0.16884751723589592, -0.10076700748464008, 0.050053826365185225, -0.40414233984435699, 0.16112494116449666, 0.28908918791625549, -0.091249562455523167, 0.30797511494635837, -0.23667135104304071, 0.35271307513905975, -0.097266326087611155, 0.1115732353759792, -0.14940002766765267, -0.13905146620074293, -0.17853468410849402, -0.0070134465926312613, -0.52167525884396948, -0.1336877658636364, -0.14574379564051315, -0.02387290254253728, -0.19180390905384254, -0.016911262701596368, -0.18403951452081857, 0.32451651336243731, 0.1113327217821688, -0.16425187583518458, 0.20772904190064109, -0.28409570168653187, -0.25189385173905127, 0.0034757915034332879, 0.30115074848312146, -0.10827222437995809, 0.051790781800987659, -0.29198978403285258, 0.036985803685968627, -0.10659440938684019, -0.022789180644734907, -0.10541480860933147, 0.14918874189991113, -0.039783159611519632, 0.23793181211872, 0.1421248604802566],
                             [-0.14098032509544806, -0.53765559244407901, -0.060634853903529747, -0.2495377387302882, -0.010104223919528553, -0.21921048812012331, -0.19536117212237505, 0.040188440478202365, 0.35298109202586636, 0.17063925131266691, -0.50268664190612311, 0.14186098376188039, -0.10658916501703661, 0.1398348568590006, 0.090854856826846866, -0.054954229238656463, -0.026439657155383246, -0.13061273595461795, -0.13201194291600168, -0.1395612192605914, 0.35557886602055516, 0.106002369019951, 0.028601800660403368, -0.3385109453746547, -0.18337041071678606, 0.18684160512409573, -0.076671031249672575, -0.088373540286157765, -0.008997559143457047, -0.43893044972264578, 0.27980944215495057, -0.060726844516810881, -0.075270090316956431, 0.054924658595739008, 0.1870526963962828, 0.3134113185920166, 0.22751260343981211, 0.056294066828532302, -0.16728816964487817, -0.25211487204613597, -0.15635173325874513, 0.38518049522194886, 0.07919591719238267, 0.21142335348860516, 0.084853087964331692, 0.061149954668817001, -0.0010913550571401542, 0.33546201099362599, 0.3120944290252618, 0.0725013546343765],
                             [-0.33252224079693599, 0.056229244689103501, -0.14622145664954633, -0.28646854986059678, 0.10317650006196515, 0.37375916461436209, -0.01054155600297485, -0.39490252188812258, -0.14463397727422397, 0.039505553833542997, -0.0043971371905059189, 0.17435533622030963, 0.019160529441544265, 0.027665910928458038, -0.022816121851592663, 0.064600200161775076, -0.028626483709442849, -0.013110671957952166, 0.32670245951905658, -0.10170446322168855, -0.41954073490587895, 0.29371737160491479, -0.12144548260809081, 0.21894755589567866, 0.071971823660104184, -0.027865401508887572, 0.046064098230732091, -0.17259035518864613, 0.021013510877449675, 0.10160753416413057, 0.1944459103033839, -0.20348436490019325, 0.28742208042110917, 0.5389814622339606, 0.013559513295395863, -0.014658999510453137, 0.12448356893610044, 0.13965835658361475, -0.0096409012090337958, -0.24401993225539084, -0.19216050410490576, -0.0076069492123330903, -0.39017619781440604, 0.099730401439737021, -0.15326293655355758, -0.06896541689175173, 0.034330299759083291, 0.14124728621516969, -0.29637430859327729, 0.26634099707306269],
                             [-0.37291488031100051, 0.21925726065720991, -0.28689475124626668, 0.057060176386563397, -0.34925705547279756, -0.15960940451224562, -0.14815478198016249, -0.24644158700566093, 0.37348138984956575, -0.3519262254714991, -0.07562951035058077, -0.038683701806604263, 0.21750834084387538, 0.15458594705437073, 0.098852547245657021, 0.25655862023856285, 0.24315008131273438, -0.032959496520855038, 0.093769673188566466, 0.10370736247773199, 0.13311551205639865, -0.15788609690550917, -0.1755794576749376, -0.065490017794725061, -0.083729684605042737, 0.096364310420994165, 0.3670816272527791, -0.29869718305966197, 0.075090390946081345, 0.029348733327656806, -0.1930927883359573, -0.014041767158140124, -0.17541248922935745, -0.11697969307924874, -0.52506922180794036, -0.19853535214094042, 0.3209179325274592, 0.099464109136311943, 0.071280870883867739, -0.20008466158507307, 0.32920620882045393, 0.14682889151819353, 0.29684287412649846, 0.081437638082169708, -0.51733467094586227, -0.45870887029290386, -0.040679494668345639, -0.20968414367132585, 0.15359558418243593, -0.08703693018898212],
                             [0.088809051323255617, 0.17384084320449189, 0.21845359706928369, -0.28197111162012944, -0.022335798735723941, -0.0072371662401371243, -0.040813589929907891, -0.26828086389351857, 0.10721886770123004, -0.10271971563087046, 0.37763570522068463, -0.025063532659345428, -0.23366218320279061, 0.042894994992107624, -0.30603036149462282, -0.097956617039689844, 0.25729102849481111, -0.083474295277204416, -0.08587504340214655, -0.39377398222809062, 0.099171402721105154, -0.031200495003911002, -0.22298576237775375, -0.28075298563164164, -0.18238709008261569, -0.25380197575812763, 0.26579523039762937, -0.50962104695271482, 0.13555568932265219, -0.01890232133971537, 0.28661361953906794, 0.0016245983558345282, 0.10163104053862498, 0.064783838187452619, -0.017065069370264436, 0.25376728234006374, 0.04611470212787229, -0.23791331623417775, -0.047005409682649463, 0.36079735118133976, 0.099617981959269186, -0.41637054972706428, -0.14770609000970927, -0.18776486724254707, -0.049536062657643265, 0.23803280925159034, 0.10607838452874831, -0.0084335666138767879, 0.26712685839883249, 0.074700759217779814],
                             [0.019244085124571476, -0.0076948600667574342, -0.049740002715888867, 0.63086225601944834, -0.1394014402698181, 0.0018161546735919638, -0.13238379957579841, -0.10988133229860991, -0.074994867976834592, 0.028745741127116496, -0.032323978705666973, 0.023223405212268105, 0.11714456763436283, 0.092109847373954848, 0.090190795982491967, 0.23438994804436156, 0.064213518451633825, -0.054872528654554262, -0.052395002959808597, -0.26525400051868053, 0.19658928438322806, -0.17778545748889499, 0.16630952965635556, 0.0020995173570366303, -0.21553704584387723, 0.071631685489449662, -0.19854580312427447, -0.30773155874458591, -0.086866566016017208, 0.053945847296601963, 0.22371701894232779, -0.22214312091744756, -0.3212626592633594, 0.44095523256079833, -0.24293935142983536, 0.099474961624637315, -0.26671016505264666, -0.1419344224425711, 0.053535970599153652, 0.0062116715754659026, 0.16310713058923307, -0.17632045496747628, 0.022710448044918802, 0.21210430556133625, 0.40711596382937293, 0.036373911229767367, 0.23343980729051775, 0.54336150229360936, -0.34820178626449111, 0.33282003986145386],
                             [0.022958000041474289, 0.12558992769893815, -0.035601864857434447, -0.23845350734469831, 0.032523720950221276, -0.17646230972005228, 0.012799405164858974, 0.38747909488675242, 0.32975403733962394, 0.24851441780803579, 0.17834348094994865, -0.18413994318334306, 0.033712705552731946, 0.33976071178319667, -0.25099908390552061, -0.22709892164775686, -0.07434067795046613, 0.084779315366474553, 0.045740052797434212, -0.16607119399457593, 0.18182069832504799, 0.17220000690203238, -0.057847143094792094, 0.13439772709416609, -0.0056677177954230079, 0.15601626213175523, -0.52949382231318809, -0.071922251061271952, -0.13286894412062672, -0.26877852200780961, -0.041203864055846515, -0.090462364419253372, -0.34796149419512595, 0.035772138802211972, 0.044414576174105748, -0.2398467064170057, -0.034859161555773024, 0.069687725479116447, -0.45392760886733929, -0.051022041618789607, 0.26069607957248375, 0.040863574705030048, -0.35758262538184071, -0.19252992667768379, -0.3702224586493334, 0.0064696595489794617, -0.14402285434495712, 0.13453926927035786, -0.29634907673588373, -0.00405712630020982],
                             [0.16476855266377521, 0.002789934178534543, 0.10886818527458306, 0.065110367158566676, -0.32333490519729674, 0.0064012724119646433, -0.17771882548201512, 0.12366824122117516, 0.041368617211299648, -0.14373789735943357, 0.23642417791408246, 0.037027747497556336, -0.1219343365011752, -0.10393474150777865, -0.19680442303174289, 0.0057035605017100501, 0.0071039026067620621, -0.056671689917824994, -0.019862438820441197, -0.33518700892812153, 0.26815840411860298, -0.060103360819551532, 0.35991503423210841, 0.46196225156338061, -0.28363443065689453, 0.23406082032314426, 0.20594632918371727, 0.2391078583599662, -0.060224885850823674, 0.10627542339808684, 0.32142110590376161, 0.49180332699631157, -0.036947707459516574, 0.20605144365944089, 0.44500176893913712, -0.0082016843019935923, 0.17137336494429756, 0.34032601511364646, 0.17914573819285623, -0.0076731022727436352, -0.2942545646652282, 0.35340218714983551, 0.06060134983878996, -0.18908263342524981, -0.05737422975204659, -0.009135817534254834, -0.012358311796163469, -0.26874120560829023, -0.1374996177911669, 0.22734520379729559],
                             [-0.11715790356866652, -0.0066913263640828108, 0.25674223808774349, 0.17302971905373266, -0.27149230847153588, 0.077249613905788606, -0.29392599679504855, 0.13281517725573222, 0.15528804950890701, 0.024491792980880493, -0.32971691038105555, -0.070155823028826794, -0.29981242780843315, -0.11938148439141037, 0.001735097043967241, 0.25790833658584794, 0.10890178014746321, 0.29317141715971223, -0.14839341219430285, -0.29569054888400836, -0.35017636979503813, -0.36222847516354029, 0.12112196692721108, -0.13399364832844848, 0.10092820991732834, -0.088985803281672826, -0.1173066363403404, 0.094834302610803778, -0.24566404965304506, 0.10707540908344634, 0.073693129990096862, -0.21205615831100258, -0.085410732305620074, 0.19105142389919288, 0.050610989269969889, 0.095458674622574541, 0.24841951063563941, 0.059930657691801489, 0.21531290801953223, 0.069153263823423461, 0.034470723936198586, -0.21361221621786847, -0.22996303683804148, -0.31439515331074297, 0.22926775774041286, -0.58291211166193402, -0.40008659128151292, 0.06641944934216984, 0.20334378929498642, -0.20470488381669721],
                             [-0.18828591631939851, -0.16039129586503245, -0.074027752077553258, -0.0036143699187436498, -0.29189407553618879, 0.092459971764420251, 0.010953236879152339, -0.45390179104523382, -0.074060059915750792, -0.16473036187975199, 0.030228709720199472, -0.17797881129030865, -0.21697761675465241, 0.11503890428108932, -0.41114069992635255, -0.34567008759679424, -0.1393624109921186, 0.10880935660280683, -0.010513158847180678, 0.19174320898077366, -0.22669466693908064, -0.38205958465196022, -0.03198260747400708, 0.12202582745373433, -0.16403215857270143, 0.33259653085534369, 0.071942774856076974, 0.24517128581318398, 0.2460434438820393, 0.030821163074473464, 0.19061189142688642, 0.12875205081653651, -0.20102191831768873, -0.029371716844324103, 0.04764477996510455, 0.3933669014739698, -0.21956066919312503, -0.27503378999239264, -0.27818411402763921, -0.18472532364574903, -0.17663830143236051, 0.034776390041682176, -0.029810324430443444, -0.24643491923972538, -0.078994358415336696, 0.02527171250588385, 0.10665008955942266, 0.048900858541792151, -0.21151089049251454, -0.53591572741960847],
                             [0.33383041724183848, 0.10879354908400032, -0.40789351302255822, 0.05406989160692658, -0.092906309163854423, -0.047587727285401629, 0.38938976205425824, -0.077455240245968976, 0.210473599542809, -0.042967828068287382, -0.57412876554880321, 0.19706091220187411, -0.088030390575128625, -0.084749248384147269, -0.21794201626103157, 0.027332818984486449, -0.25733920407570243, -0.024117953843288797, -0.38333277078496691, 0.11947032105920243, -0.22525627069521076, -0.33506159282416453, 0.22889788935629013, 0.34108392333728826, -0.082958012685414376, -0.19291450179264283, -0.1449855157212166, -0.22911971122469382, 0.2074363234924515, 0.38368519969985748, 0.29122069186603539, 0.055251465615872533, 0.11095834588065936, -0.050559721259365829, 0.23438762247075637, -0.08617130238109072, -0.080999219844044734, 0.1961490964495968, -0.17683057884960302, 0.17432420583707542, 0.24437466028706192, -0.10458918043581983, 0.032963414846894218, -0.1042821583082839, -0.015161580343682765, 0.14333263469993432, -0.33125992597130477, -0.15210827099561208, 0.2026532406942978, 0.15398017543878256],
                             [0.010297500493552096, 0.23211679470650773, 0.090046350151404136, -0.046509302362884308, 0.010751480729207657, -0.32814512795577372, 0.024220891301370645, -0.10262139908908752, -0.067453209153789551, -0.52191560495155032, -0.28019564901424421, -0.097498218030246678, 0.0050568591046725436, -0.051146904692084022, 0.17323261927856576, 0.075146585918771353, -0.020394881652639082, -0.069068954776459607, 0.24431293502473539, -0.3277633348770817, 0.27766990707116979, -0.12284221324705265, -0.24396312729204694, 0.18016687449028609, -0.10096115833836553, -0.024866203613927822, -0.098828692020040215, 0.062394547393404429, 0.064790294658688768, -0.48906116500216956, -0.18830878089428529, -0.16114288406741573, 0.12743407694252754, 0.54205727112551194, 0.25331069983858578, -0.19274037324443402, -0.20152378487291051, -0.18787287317160023, -0.15097890757272156, 0.20796996176644741, -0.11039064963054819, -0.24183014549577209, -0.038343353445895088, 0.049366513321125773, 0.10782580841908498, 0.21250508451233024, -0.31816234900876539, -0.18655417066206312, -0.18926221154712725, -0.23427908481142712],
                             [0.19036545031823376, -0.12299016020213029, -0.050732753855536647, 0.097415803147569327, -0.4063575012495918, -0.14386605790476262, 0.2080680066724877, -0.40095725218571249, -0.22932393645821819, 0.18806069642808584, 0.0055258347580650017, -0.17293818063980751, -0.089418138439741446, 0.020698282307167849, 0.41757895705489206, -0.42719109203849981, 0.058947525967499304, 0.27660905334894231, -0.067642695226968946, -0.18040500490574429, -0.14765920728384296, -0.099113283781831596, 0.3507137295721679, 0.081680016512143711, 0.054029832361443882, -0.0099393770835897906, 0.11239136252961623, -0.15043089843491958, -0.23864812135348312, -0.52251986853212917, 0.054559692594918781, 0.097747333824885624, 0.13746684258011949, -0.35679536726605593, 0.24580800930856, -0.11596028302537911, 0.34109478001349997, -0.03168791332055125, -0.0604674100598247, 0.16745735209608309, 0.20068949523276458, -0.046900649576610429, -0.29527354516457033, 0.078336740869312707, -0.18297353239963701, -0.018581124616542551, 0.094952537257083525, 0.097050465559672144, -0.084428806196159736, 0.2116649883107885],
                             [-0.10843477880596619, 0.063618786201526431, -0.34556368557394129, 0.20195388779233439, 0.081012498925945434, 0.014193055479815309, 0.085574203150529812, -0.37371572467273362, 0.088527363171333806, -0.074909506732604159, 0.22570515079320022, 0.11232481497720785, 0.017223402862858124, -0.11608684012732902, -0.12798599539549244, 0.30752527760079151, -0.029146477356715585, -0.41169749768542951, 0.20440073003041734, -0.46776514431269733, -0.27049395448311819, -0.27517694979423712, 0.17686048644821822, -0.4790003298973346, -0.0066395276803725856, -0.010323182962694242, -0.07694017298923686, 0.018746564052438096, -0.29317194396239676, 0.068984536287980763, 0.27284368875553255, -0.17248939276746944, -0.031813117748141176, -0.14802227485336036, -0.044996348709463674, -0.24473459160852989, -0.16703574774362162, 0.13324905953751703, -0.1628306140025286, 0.013425398858974291, -0.064698023948197847, 0.36453983488834957, -0.24255195779966407, -0.20572379616191319, 0.30183324405251244, 0.27464181984002983, -0.25212034966541574, -0.1889271644794544, 0.13265164054365136, 0.049401049201840727],
                             [-0.021731919789869013, -0.33172567966205796, 0.16766019094277512, 0.2140473686753305, -0.43540045680001599, 0.1424800358259953, 0.075645918476288487, -0.27830074848256836, 0.18823233680626819, 0.36457667449204773, 0.34857694589672683, -0.4358080974439783, 0.027331095460545376, 0.10152656911053985, 0.16429157909120107, 0.23700442439543951, -0.045794689762416643, -0.0075751938052803329, 0.12940295200545424, 0.040652401476756736, 0.28754306239957944, 0.089746551036784916, -0.36716815558552218, 0.091755615897833903, 0.3281295544109265, -0.060133178115588, 0.020552826225952517, -0.29954507758222182, -0.067658539069720247, 0.25088925463287293, 0.00012145827752507894, -0.051083587452461006, -0.023428483861060875, -0.12602105652625567, 0.38980961336343511, 0.14626878049960235, -0.39275750994431119, -0.040280501353126788, -0.098453682610427112, -0.20518828829471081, 0.13076195559546142, 0.21087721328206943, 0.005095282057625914, -0.01997225654184611, 0.22060730531344053, -0.12492861927785537, -0.14801415287095504, -0.32870089476132935, 0.21451589766102466, 0.05126695929492768],
                             [-0.15316898635994505, 0.14281176476710092, 0.15043749287876892, 0.088407601787754211, 0.17759056858495248, -0.13916256466011814, 0.35179585804626912, 0.2069075590638807, -0.23491953584778485, 0.18913962656923219, -0.44236881988791621, -0.23946876385180046, -0.32543575287560184, 0.025766000839069287, 0.278874423863742, 0.21371260527505073, -0.14272419604809158, -0.084473323365165762, 0.19190828533129461, -0.13908102153352567, 0.10699510142573485, -0.37530611224421806, 0.25051312055073921, -0.045901220696901696, 0.15332836894407353, -0.37172909731109222, -0.28888679109994508, -0.10624532459804413, -0.020500096213864449, -0.035410858410316187, -0.050256153970444924, -0.11961549715486317, -0.012421811687615233, 0.11152461606041641, -0.072165340173946199, 0.39706530493623482, -0.16826807547570263, 0.045322538608068855, -0.019028348861924792, -0.1903942785259897, -0.15974234446717092, -0.076745424180975297, 0.23256367839359654, -0.12239406786056137, -0.66475086216407853, -0.088388404474058643, 0.5051810461448718, -0.21923618110088008, 0.011624001759032058, 0.07079871129695843],
                             [0.084676866496997696, 0.23567475768984963, -0.076491830566899982, -0.15324467615397713, -0.41398049600513853, -0.12525719180369158, 0.047006323412437531, 0.2430531436293607, 0.30521308724755525, -0.1924651717407139, -0.05787345300580328, 0.032661643213374544, -0.21054884549784691, 0.41324770283420004, 0.078699793927473033, 0.15134931129013088, 0.0011310161645247396, 0.02433540122292438, -0.044735959471005587, -0.13418032361532425, -0.35028835559191662, 0.47089086883076325, 0.185181929486469, -0.19064693857771753, 0.13585193889192351, -0.16139877899018432, 0.34971754672417255, 0.095272775954614669, 0.013725799280377871, 0.25875255939946679, 0.14008058801550871, -0.11780244331925849, 0.27053890082319776, -0.086657563486831707, 0.077932059187791919, -0.31034263242982474, -0.30992136031064993, -0.37900528702144987, 0.08078508898722904, 0.12434658480307478, -0.047540525380675686, 0.13485245272182078, 0.086157774907264076, -0.27523573462060197, 0.031333330624490986, 0.12319029126035666, 0.18969765934162044, 0.34060793713043525, -0.20170097900627615, -0.049134106051006543],
                             [0.10200666101223106, -0.20010545203460856, 0.21795153136729539, -0.20126526293963865, -0.15850904143289796, -0.073308893035741632, 0.14049637980236984, -0.097997318938977243, -0.18847175551767131, 0.043139073834715824, 0.1994758594716716, -0.032944754097774781, 0.3219829212142245, 0.082663381323705043, -0.10474070088326073, 0.27771969249427092, 0.11069278631602249, 0.00063442356357745061, -0.047740258293209353, -0.17163387344658676, -0.098963193485791995, 0.10896127013841569, 0.086007226009507706, 0.21439954341169978, 0.0533901176613545, 0.15547363364284864, -0.22824775338122105, 0.060849299816300523, 0.37059685929498803, -0.36652511119410647, 0.0028736972720962949, -0.49962395000452675, 0.25629123261690934, -0.013416849353769779, -0.11828661694778626, 0.023320961545698647, 0.16794982739856887, 0.11880613264629591, 0.4852416688008776, -0.3743140311582368, 0.35512949004930527, -0.12480581491945372, 0.55745775334696657, -0.37730036751302826, 0.050830255699631302, 0.23922117072582563, 0.019597801664507114, 0.065098594475887381, -0.047928980511383605, -0.15261876636324034],
                             [-0.015871294337301986, -0.094513619199732848, 0.14989405824201704, 0.37473597882265625, 0.26649123543242553, 0.12780562280351163, -0.10400016134524992, 5.0668158572166055e-05, -0.14050469931219017, 0.20175861127064226, -0.20051885792205623, 0.016713263267977955, 0.0094128062566476017, 0.21690513007619783, -0.073870760484712, -0.46524018495422947, 0.48533011542156629, -0.059488472722909268, -0.31671806960757776, -0.054661166750603063, 0.086047180299586273, -0.010258566588880885, -0.093449582059038042, -0.034994085935179706, -0.34749434134459267, 0.0055617570360368563, -0.23739574317657228, -0.21088278789495032, 0.10225127946040771, 0.11336858272007186, -0.026825485195417685, -0.24385738281072114, 0.35205991613501486, 0.070315720003462465, 0.1686170923599713, -0.31526499751178072, -0.019552514887753857, -0.12714328369734998, 0.12931386730383199, 0.30687198300850393, 0.12854553772667229, 0.46999365736858811, -0.19248688529805516, -0.13918820172840668, -0.054091451752172726, -0.13049253684984805, 0.22608152521276237, -0.19907859850540693, 0.0075211865425011213, -0.28546848576919387],
                             [-0.1977844956201727, 0.0073314167203158316, 0.05927118054006103, 0.07777106779574397, 0.16774689249055552, -0.53179347740288074, 0.23425343960220155, 0.098788214235369085, 0.083446617065633263, 0.024206053887325382, 0.24669057998799976, -0.090506638560497843, -0.3907739867592856, 0.13287949463405757, -0.086417118585924116, 0.082339738156198689, -0.16123292391182395, 0.30234059999340501, -0.15338207380283045, 0.32481230691636159, -0.16696837569399459, -0.15158079910696229, -0.1012124264917755, -0.18465778922765749, -0.24013433413210863, 0.068144017120280717, 0.42181947526501185, 0.26031470732708412, 0.16617691160919462, 0.16462577497619432, 0.16038909328084508, -0.65623984192487228, 0.0050100117988723658, -0.058790846879720415, 0.078323638023314129, 0.2222127423496438, -0.052231698908950908, 0.094972279155042971, 0.31787820731397298, 0.11611184488024549, 0.092093191301909974, 0.26331180034076229, -0.22376057246185097, 0.011798065127303282, -0.098831229354009772, 0.059172179172534117, -0.28592226915178692, 0.070667867866291423, -0.1952556286878839, 0.55387937314051183],
                             [-0.5074267165292734, -0.10045609015224481, 0.30230230533635599, 0.2916239965395967, -0.45114293817434015, -0.26704179083067298, -0.090249487336686446, 0.021780733461585849, 0.20656320999312866, 0.279522513110535, 0.17454353708958167, -0.097984359912673055, 0.10416701415491282, -0.071521261647101847, -0.045773206893005673, -0.060330428018440373, -0.16960930525141615, -0.23548866937416152, 0.11872427645847043, 0.27936293849695676, -0.21284321266486422, 0.26035155851487318, 0.39993708267566463, 0.021372244555672319, -0.30404113819976653, -0.34286478350376909, -0.062380181484598576, -0.00385114600036153, 0.37878856736022448, 0.045296869750100874, -0.027274083044020379, 0.0029081163958814028, 0.093300779276443438, 0.15683832119760782, -0.21170118668117471, -0.25502941216001679, 0.10998769721456339, 0.24889646691564354, -0.056252333567963553, 0.10704377865863526, -0.21867570352869206, -0.20422969665772467, 0.10672887196849817, 0.15800629874302313, -0.14707181800778377, 0.094710010364344288, -0.14411319767134789, -0.12027226381351297, 0.15503397475887071, -0.14737737646113672],
                             [0.091516538289830918, -0.30207522964288808, -0.35373453780540898, 0.23904127844573159, 0.16819484870497797, -0.17344628908911419, 0.085528012196729786, -0.1016173500555176, 0.086250219635059022, -0.43279964253282582, 0.20345443252397244, -0.083165837327437597, 0.11691994858578833, -0.14264865702215751, 0.030057380136476838, -0.091735310412489834, 0.21777744671594185, 0.13315521611907649, -0.11928933638790265, -0.030480247216502394, 0.24248328588765339, 0.031531321417954117, 0.11612345546271778, 0.15035569320949888, 0.13864574526406689, -0.017096542160509477, -0.013958748202563591, 0.11812645768890342, 0.25964863503471558, 0.030945160798085573, -0.44327942106731422, -0.13037093409953504, 0.09262365317575269, 0.30086099568250407, 0.031111766843342582, 0.21362627309667179, -0.0089074648669402352, 0.2663150743337675, -0.15914866145043263, 0.17053799817293841, -0.41216104046573521, -0.010565146071925911, 0.031148917826933492, -0.53505882566138019, -0.065049433663210018, -0.2782444244695082, 0.096424819439405188, 0.454220764452062, 0.30299099791446321, -0.05293519003418936]],
                            [[-0.2685142059990151, -0.010559072903103695, -0.17998654317456977, 0.1024601494193773, 0.015541063534422857, -0.16854359347956002, 0.24187399101617138, 0.29614667132772277, 0.22766323760654988, 0.4804545998355767, 0.050633621744700735, 0.094767260258114508, -0.10935002325599884, -0.099632954826548561, -0.1606336528630877, 0.02668790133202464, 0.30273385845149342, 0.072057905363251171, 0.1933660003947846, -0.126550739639233, -0.049928606918460211, 0.12510425579833401, -0.036342767689756778, 0.16276066836227618, 0.13229662853837565, -0.32596127843391165, 0.020295533604951115, 0.050568580361478099, -0.24169187827598468, 0.1434235332810023, -0.58126405157905037, -0.24975632099005621, 0.31856157568055271, -0.41900991038234031, 0.10768890132364421, -0.13585829238728434, 0.099870959078303734, 0.15887915927615964, -0.075586440898729443, -0.24623070410979087, 0.048513939519819117, -0.072296688887450708, -0.22044800150608235, 0.057382245752950152, 0.38052732536072292, 0.086183434743267853, -0.1444445885411261, 0.040418874557292567, -0.058851281748381924, -0.045579249555412225],
                             [-0.10164114656257703, 0.41171669997896443, -0.03819292700672948, 0.34961016873310741, 0.086313001969702874, -0.1717796324056306, 0.064098206708662675, -0.047240048829586628, -0.049997943523337959, -0.22327569758158847, -0.11973501771015566, -0.0064506385534849747, 0.14555944561644318, 0.050177422193394383, -0.013989150701821204, -0.16452902261699751, -0.24000966023441619, 0.1998415437640855, -0.42914218629507511, 0.27707643336062554, 0.07866729336131327, -0.050484296132940851, -0.22041432488455479, -0.10899355206856327, 0.38189617499156148, 0.4383021106919035, -0.075226000890714351, -0.099593953449664943, -0.15967889258446369, 0.17721373939518589, -0.3220751107133068, 0.27847712486272885, -0.13769315237388757, -0.13316561075127259, 0.086587223259894736, -0.14901669662250633, 0.26032844035273323, -0.22683593758096229, 0.055858237450733365, -0.3175000520158956, -0.15198429632062471, -0.50469143951216666, -0.072383203775009661, 0.055954665755317205, 0.15165250771244487, 0.21578197765883167, 0.055582245283221879, 0.083694952169803105, 0.14060885564619097, -0.27393571641645592],
                             [-0.12669150262693016, -0.28874707373557207, -0.2494363522737596, 0.51097864062831455, 0.0080933317296496901, -0.03647494151554681, -0.025344223608506848, -0.039483026626952925, -0.10300959238676016, 0.29827818875611956, 0.20719014495584609, -0.23360561108856021, -0.00019939232470961993, -0.026364640071157405, 0.14424968607386043, 0.10917280432102637, 0.16594099145929894, 0.28979749006696143, 0.04394801374191197, 0.2049299650173475, 0.12587947012103012, -0.08234461865140541, 0.081682884782298862, -0.01351954653164875, 0.077558198882384632, 0.17257766668557034, 0.23091854936131914, -0.079027923857695012, 0.071515565823366628, -0.59914542057480979, 0.25813174807655248, -0.20518423279826989, -0.062123211333738673, -0.01581945043320044, 0.18081995806859638, 0.19965905137279705, -0.12644207526076864, 0.21248874292972736, -0.28928281909673709, -0.30490032846397497, 0.072688815382878275, -0.030110703898209721, -0.027139977907654312, -0.31447877625844328, -0.022776672803011586, -0.30170728949958381, -0.19086489188521805, 0.030808138744316902, 0.11874352118255162, -0.029385092146160842],
                             [0.041272213407582345, -0.28579194094742782, -0.066145425900352245, 0.049567871047408889, -0.197872633647308, 0.21971511835222052, 0.14005547700969323, -0.26878360095161824, 0.48526378840985596, -0.16767718748716387, 0.15624262718177176, -0.13319724367966199, -0.097274606193581942, 0.11407716070903572, -0.24187707100522282, 0.092143592398348947, 0.010423793199556441, 0.22000597207308645, -0.2765847571838479, -0.31411334384838641, -0.011988540090224431, 0.19071401782332095, -0.17929411895334704, -0.23885203587506981, 0.036241831647168335, -0.16782719532018883, -0.28464533388181257, 0.13956224409391171, -0.012832580523229027, -0.066619041451299613, 0.05361513712568565, -0.2481693672632837, -0.095143168953859381, -0.12410598749896715, -0.21190337954864499, -0.26578569382970763, -0.034644866548701962, 0.071214582638860019, -0.33423673128067583, 0.19280058044934653, -0.21631157640531801, -0.087000936087956116, -0.27747018497376946, -0.37604883249898219, -0.10765717062101623, 0.092005821734674101, -0.063219415393450967, 0.062386006086381021, -0.12999660096007246, -0.062916933596878888],
                             [0.16030692798198204, -0.19540270879726104, 0.18275027216943415, -0.11372519832294434, 0.17442072782381401, 0.13315121005285202, 0.0094232653314971371, -0.090807102823239796, 0.41921650881286265, 0.44016468694102118, -0.14081974180429324, 0.28121881446445091, -0.16716851020719797, -0.47714117242973181, 0.11922605230571499, -0.23138371765317531, -0.030533958723440655, -0.12555330655602032, 0.12572566613697236, 0.089504994843716837, 0.2680080375433575, -0.10392293882975438, 0.15943581353500955, 0.035491130249705474, 0.12155576196148508, 0.27803109243504731, 0.11553238421864474, 0.48584522017304832, 0.12819403724636846, 0.05538825337432763, -0.080405586600606815, 0.35697521535599486, -0.027908062779019617, 0.35308560385878474, -0.24898685188612646, -0.085028531782027891, -0.16280343621301754, -0.21265462204648003, -0.3001605170988827, -0.012100221855173047, -0.12204520086256662, -0.022685694488779572, -0.016740978962893886, 0.18070633927363899, -0.10010500788612525, -0.040575903976561224, 0.23588564887068666, -0.074647321944267583, -0.20481693085597708, -0.29959129630365605],
                             [-0.34125997327817981, 0.040546579207100683, -0.16020964104734819, -0.12735964765772645, 0.22276616019295606, -0.39983808411805694, 0.052861854026842611, -0.090314309033275919, -0.054576138657671275, -0.20427263454242722, -0.063526545134576673, 0.13584164014377678, 0.043045838688905116, 0.1884171555133855, -0.13967358833263915, 0.034347037568001948, -0.085066571322257964, -0.13289617656804636, 0.080686404205176643, 0.16078819312035589, 0.078710007612501257, -0.24366659680333827, 0.26104518616263395, 0.030447608934934048, -0.14480506959325753, 0.37868554720997871, -0.2776671391169192, 0.30853954937619288, 0.16688837364818837, 0.052522778627947853, 0.37119133646440999, -0.1283779428943089, 0.11634387384067277, 0.17374660681269805, -0.36414288099745173, 0.02337290372516973, 0.093559810448168593, 0.17790282389751094, -0.2033993121023886, 0.06936573765498176, -0.21217892935283178, 0.0299265618173854, -0.19089386287956556, 0.1585630470051051, 0.3188549706004099, -0.14535453573666923, -0.53683596965964242, 0.15504960636876502, -0.18882206310323044, -0.21074422140539964],
                             [-0.10690501142114367, -0.13920966549305014, 0.1641448108326212, -0.13714376726871771, 0.39460909503098396, 0.083449034360243202, -0.3855928263747736, -0.54027272678989047, -0.029537264837580426, 0.21246364884598301, 0.14271100916947421, -0.19925826174863837, 0.15479212275280527, 0.41517503624551966, -0.11090770900248523, 0.22873898496892447, -0.12097237158242363, -0.16542041816132139, -0.083711864146659404, 0.043812875871899824, -0.1384098460680338, 0.20405047244864391, 0.30488453343564015, 0.066533485634615974, 0.010117500082148928, -0.26272355643934581, -0.0044991609697485821, -0.25749973201673748, -0.067863192064467975, 0.2821382970337255, -0.17980383260629559, 0.27194222454453781, 0.1821268244457476, 0.13459859639350305, -0.032520934260072139, 0.13977399386707759, 0.2985155389330475, 0.083912383509374355, -0.28594659991807436, 0.12122662151096004, 0.071004635890323714, -0.23526477695594886, 0.24426051131463164, -0.055362870803271638, 0.088884546922005966, -0.15577359891056999, -0.25198086965259914, -0.010885810205105526, 0.22451525151029564, -0.23740419395912241],
                             [0.44701948945915126, -0.10950622523702369, 0.099867275551505846, -0.051811348108720082, -0.094996872820248948, -0.111367730160744, 0.072222784110843596, 0.043280241803498064, -0.13869269192379072, 0.090932333483847952, -0.37930534175965325, -0.32524579713369584, 0.2864261314049269, 0.51404695315195659, 0.073052815647145414, -0.059816314582308253, 0.31543572630833827, -0.045049618618852441, 0.024434257085073317, 0.0022515264603644794, -0.095534748077591894, -0.36303122804561327, 0.098777759716531785, 0.012904511630334389, 0.10536638533822099, -0.10745867713314755, -0.20146940757669773, -0.045393758529887807, -0.17484259565565979, -0.13718834494394624, -0.20157493933929718, 0.30218208739044927, 0.1490239675562689, 0.11335941885730735, -0.048049394612149854, -0.10085824671874602, 0.046018778140460952, 0.18584128147635617, 0.032242678324974128, -0.1092648998236892, -0.13078521383300806, 0.02791226934933435, 0.082924237510916571, -0.23196485746880538, -0.13172364624386357, -0.25218133586890712, -0.24850868499702408, -0.19165846092635827, -0.44680103123723347, 0.2546932920375054],
                             [0.24942568337537493, -0.06345432765961713, 0.13864782170586207, -0.33297616042665729, 0.4128917629223991, 0.13064446109592728, 0.17429125107824381, 0.12190787199886696, -0.28412160878334158, -0.20631831638641304, -0.34343785339598198, -0.0904889295703383, -0.18798546259392371, 0.18208195899434826, 0.17420071812221838, 0.034330329403404997, 0.10634110473076658, 0.067630168052755776, -0.17158296350033803, -0.1071461821548183, -0.13392748497036328, 0.2867939772750932, -0.12473555888164659, -0.020326865828188982, 0.14454710877722549, -0.20717505247048607, 0.34789902767777675, 0.034207454549181074, -0.062732359698324414, -0.14608111415156277, 0.0802248680010407, -0.33545937668459502, 0.13015412483223629, -0.1682886387663492, -0.37747444458866092, -0.11659686637196989, 0.18788571223060152, -0.043417516946751035, -0.34297941582998565, -0.42215520920097421, 0.11579794162340656, 0.011043040254335633, 0.047451511807285532, 0.13589396737969686, -0.05490174136604524, -0.1178033224167294, -0.1031796097676083, -0.37551300941579124, 0.30803114548928051, -0.1552259866876943],
                             [0.33300147977834205, 0.37593922668294671, 0.20176938909159012, -0.087490095355837183, 0.025034977142081884, 0.18567989286688491, 0.25900896919855926, -0.44220091611366558, -0.31918559582595651, 0.18451557783554259, 0.17202375863686384, 0.018997906631087517, 0.12264106274808856, 0.17321584923161887, 0.0071500436481540513, -0.042032971976031154, -0.11321910843504067, -0.23614037698602611, 0.24410652463886928, 0.39088995948933491, -0.041709617763531007, 0.27945075497822547, -0.15309390076355323, 0.3072089193992707, -0.085233464662288899, 0.12376583186632953, -0.072956198627632446, 0.12033888074174595, -0.025706322249376221, -0.25805951693016171, -0.12587765456517599, -0.036666902399869764, -0.21318858663710896, -0.18656435127253632, 0.026240551483111666, 0.19820992079942987, 0.055768925789259384, 0.30040801389107813, 0.1604854482573872, 0.021185142960489716, -0.30097076187565003, 0.15526927041891359, -0.18722658972657041, 0.099223543243189702, 0.044873153106913928, 0.13546214334085793, 0.059740994983795613, 0.098226577919682367, -0.17430465690545718, -0.3799611647210635],
                             [-0.0056182672637979762, 0.045546657562088817, 0.19554847609638867, -0.094707840534775295, 0.0083016160285955716, 0.2332970713986903, 0.20024516965880873, -0.12229238606146389, -0.031387746980549767, 0.079424719854784581, 0.020090145730427587, 0.098156238840903465, -0.11998269305997833, 0.02264537126677043, 0.18096285773497117, 0.17868211518582111, -0.28942471771249567, 0.41823184373792371, 0.016384662789991112, 0.068454487435620395, -0.19399613338682409, -0.24005419671099629, 0.056770886619483436, 0.041968295093413238, -0.38879186951039546, 0.3518870863398646, 0.3374717567412564, 0.07741687909437539, -0.28004663679132769, 0.12584929055490066, 0.21069640637727199, -0.15624774461273722, 0.31872394513474767, -0.091705248129365771, 0.041791867211079678, -0.47308464021114377, 0.07654443068066899, 0.37479386154874017, 0.093229950995112595, 0.056882562160557218, 0.13373702147787864, -0.17868795396978648, 0.081468213410917423, 0.17755728136915541, 0.13060265674530647, -0.2961391613305816, 0.4339311497250018, 0.063233860280395765, -0.31072243268254351, -0.1309902871181754],
                             [0.018551356835682178, -0.040613852253301178, 0.30723702173247797, -0.13053331699535586, -0.10384741145854075, -0.082127448903333455, 0.26000093627743132, -0.14545840729603385, -0.1081567281123491, -0.41846567596991119, 0.23165873256857211, 0.082978852917602375, -0.444947550514671, -0.16492866870653683, -0.18910108473324494, -0.15057271907123579, 0.36174637083924277, 0.23248899199327355, -0.26787755700173366, 0.15706725706589283, 0.30565867457388746, -0.13808786906096152, -0.29273136831873448, 0.27103139715241598, -0.11452390721551774, -0.071205162986504908, 0.24668051831284821, 0.069534255549413282, -0.057941879785615394, 0.013949731841833672, -0.26588381959154123, 0.14327856706433656, 0.16563372590172135, 0.25472057000795223, 0.24348319973557569, 0.16406792371621012, 0.030478517065617435, 0.030506157939485447, -0.15413163751961237, 0.18826533015034924, 0.023627205515282881, 0.15764777788165146, -0.23946265235094741, -0.023146842356613039, -0.19037235587764906, -0.28048448562499823, -0.31290748107884858, 0.037629382184185038, 0.065470716492386796, -0.089832723049419361],
                             [0.14435593666965926, -0.10523715782989015, -0.092113543743378504, 0.042569311599789786, 0.33285099459516004, -0.1700931913273532, -0.14848687362991339, 0.32017946991244589, 0.084289394129024836, -0.021181829534266616, 0.26002896963314182, -0.048028570042784761, 0.46192723500990435, -0.00015433814954131722, -0.098670787657723177, -0.36000293074684936, -0.20328592903131146, 0.23107124209126584, 0.090951551031247219, 0.18876521524642897, 0.16464160138670803, 0.15497267914953025, 0.26547447205446667, 0.00057791786574316537, -0.034003709804646613, -0.013045522306728331, 0.083116605069213118, 0.21458416753988949, 0.28572533147844498, -0.099369458914942199, -0.090521937458338447, -0.085115198046918653, 0.041449678350976939, -0.11240972101884425, 0.1729398518006186, -0.16653926499394794, 0.56626354941827672, 0.21930394305252071, -0.24201225290243267, 0.29391465363399083, -0.12520029913012687, 0.2759326139871624, 0.056613156611648334, 0.11113283674519472, 0.022919703436380737, -0.07983419786513124, 0.083134698835639495, -0.072431938268272961, 0.059038507668403885, 0.15171808387068764],
                             [-0.067477845543004455, 0.13778902344440722, 0.19452480762182583, -0.091377707144701392, 0.20934945805538591, -0.29986885008290903, -0.29650776695812753, 0.0090733548492344038, 0.12814483163712895, 0.20688261161816551, 0.054648879730890679, -0.52105200127910356, -0.04223971190653393, -0.22389419264810151, -0.24025700313288414, 0.16258289412331883, -0.29697631163886307, 0.057396982418581904, -0.36333414964618888, -0.11826263625464434, 0.11095206819810167, -0.17907959760399672, -0.42336267106703546, 0.26564872879149404, -0.014187810235285698, 0.096075968205292503, -0.014127877053681605, -0.017412363780706, 0.13452798309865321, -0.083620226030623634, -0.21582883950403328, -0.26286881492159658, -0.10556785445768607, 0.082552322692970512, 0.0096403808685208044, 0.06715641465882341, -0.17402972696177568, -0.028835974846711666, 0.12497324633296739, 0.11423469841538052, -0.34947484682037566, -0.089732405566992801, 0.17974358371785251, -0.011287735393004979, -0.0012050119998615015, -0.17159982720827827, 0.0047656085228016849, -0.41282317687423031, -0.0093214837727468251, 0.1466363009928377],
                             [-0.11615677765988475, 0.072268604895407956, 0.28591218613178604, 0.18677442760910329, -0.060434937782006592, -0.054501908362542567, 0.22978873969187547, 0.076099485327604618, -0.0037264786359081856, 0.25612780104784888, 0.21653514745222485, -0.021749052552006522, -0.063670080687224753, -0.22729783708170137, 0.25069848912859649, -0.07270384208354394, 0.16530060934553989, -0.087127720578088777, -0.28253493831368459, 0.073192735423194918, 0.084838320758266236, -0.40310715485784027, 0.15912800910230987, 0.2187338729137534, -0.29791809809803094, -0.025146204500669525, -0.43871320208780018, 0.076624923879585277, 0.19848139617750932, 0.20494273963469378, -0.10643824107131354, 0.3657186153599245, -0.35406262881126732, -0.40106703297798635, -0.32340707735482244, -0.14841564454021819, 0.055308825162722154, 0.18029971854636548, 0.26249973966775059, -0.065286964372997872, 0.15237870302217035, -0.13314792761551189, -0.048395811064222923, 0.086044138984082807, -0.20991508612190962, -0.37396983230453085, -0.062465299648102941, 0.063954090381174347, 0.48825662527474872, -0.090412464466143108],
                             [0.15867842576758998, 0.083218648176611953, -0.076994650480421201, -0.32970650604135004, 0.19692571250041074, 0.22945817860304452, 0.12575309473797869, 0.019283859977436348, 0.15808086534316032, -0.027624057745327731, -0.30856472956774605, -0.098754348703026559, 0.1415907203710314, -0.18266402766619014, -0.092306963624740196, -0.31101736471736363, -0.32285787520229753, 0.28830506725070593, 0.098855401158944714, 0.25397486921934181, -0.30518332768684014, -0.50409375513815158, -0.062963213409311242, -0.25967241512400469, -0.035733514967573377, -0.1423026684557939, 0.092927973992988189, -0.21830079301845934, 0.051942407801431806, 0.07857122997769686, -0.20188950882691639, 0.034719439255903102, -0.12141812292299588, -0.12283613019358022, -0.10522998529123109, 0.35440746304628795, -0.067694333966369966, -0.044209075868362202, 0.18644773592731151, 0.18917216081202831, 0.078538257803015737, 0.086962193825882314, -0.40487787321307223, -0.19759936825137192, 0.28356231418925787, -0.15989023156872012, -0.17967227367616487, 0.39710452857378697, 0.25437343809450746, -0.24577140666857225],
                             [0.2434359339716432, -0.030142837783104719, -0.48350288461112423, 0.34848507644751442, 0.12780195498476304, 0.042905025492788955, 0.10785032556178095, -0.2665927794327827, -0.57351567550117777, -0.16887386178262567, 0.020399752497918849, -0.010926474887071108, -0.10828103046395876, -0.051552433314212484, 0.12960446918685251, 0.062661259532689764, -0.10713837424035361, 0.13044217299910435, 0.16891039864221569, 0.014881805820431086, 0.14107207845715122, -0.073512444911804045, 0.24633931689785929, 0.1799421894038499, 0.019034141654979384, -0.29823551256421749, -0.33547045908631862, -0.034118054487464106, 0.096493192569202732, 0.093519925483456556, -0.13225906160937995, -0.22332035476099002, 0.34577402611515651, 0.10756609664272783, -0.1882045705274647, 0.29327140147409292, 0.041835314752092838, -0.1244060770585325, 0.088715559546723666, 0.19439186460671365, 0.092250923650315259, -0.20701326471875742, -0.31887547924357074, 0.032406107478217032, -0.052166526236557598, 0.024063522244317063, 0.1283957932065049, -0.14881366136446411, -0.013087188153280541, 0.19712130499609698],
                             [0.56052791432155802, -0.128520486927507, -0.4229113767196313, 0.0050089327402357171, -0.19240504933185615, -0.22914621182895559, 0.28754263781434236, 0.089171922114556545, -0.16964966701956546, 0.25646030241179335, 0.051778483385912719, 0.099729256323053517, 0.30380266346944806, -0.32419647654439343, -0.098727558212392846, 0.29681797528269493, 0.11286606867072123, -0.022863316181925879, -0.36922575980733308, -0.24142513778406571, -0.21838468481598261, -0.12404735196792298, -0.16867588147058318, -0.12996237338594024, -0.14615741152890813, 0.11936218229153904, 0.085267409250188025, 0.028535609254701638, -0.46708211945839911, 0.18028004978762202, 0.043223064920764061, 0.1412095129010896, -0.10194545674385669, 0.36432830392176846, -0.084340802067781634, 0.21706381126578797, 0.11731825139810398, 0.33479268165835879, -0.25396141713717779, -0.10978335979681943, 0.03792132149438681, 0.23433779025589024, -0.087027600984227654, 0.11470387904637086, 0.17539504143231249, 0.28200763150257269, 0.034041854105868061, 0.053844864397458822, 0.10168637494122622, -0.20988496442978133],
                             [-0.24323267208876809, 0.013568185500803182, 0.028068869770110676, 0.28108220640488646, -0.31197009648644969, 0.042900018846478045, 0.026442601068190384, -0.27268977569146918, 0.18668700250285777, -0.26632618909340033, -0.25685805402821377, -0.34145612828840943, 0.38366620958466441, 0.23122254249547236, 0.21905904403311005, 0.18873804701942085, 0.3039408888810019, -0.12975203464176127, -0.030903431627945233, 0.092292061329968339, 0.085506843063592949, -0.12863481633516277, 0.20690025139443366, -0.28346792159640066, 0.1716453007803016, -0.18717028628465943, 0.29443424879666663, 0.2847499842110735, 0.14337741660515868, 0.2415593188304114, 0.0052913196413146958, -0.078206974966785872, -0.072825647610180205, -0.039408479887330164, 0.19610807126679244, 0.10578936212814541, -0.27084820927793141, -0.056686399826265624, 0.17144324140988432, 0.23374047373366011, 0.15882935693216979, 0.16381640021090171, -0.29150757260051741, 0.25121252020166862, 0.22594352353775007, -0.13221467121286612, 0.16366002681972447, -0.34953157846203875, 0.15832985298688051, -0.16415957401728379],
                             [0.266429062800144, -0.1353679640244618, -0.007402628193984971, 0.014461947563596802, 0.16501295746526329, 0.21289113703474538, 0.36093369977690315, 0.015967912019622624, 0.25134629867844016, 0.1356799335813621, -0.18411358861317514, 0.15628689111003383, -0.29842124891631783, -0.020512723794162847, 0.14944086216452171, 0.27872302802380061, -0.171635029998148, -0.074715951986477624, -0.2235891530764639, 0.22039377827084028, 0.18203986410798953, 0.30613455528146138, -0.14830096170798701, -0.13154156184437479, -0.089958385013666847, 0.20224103203921831, -0.1730408064802714, -0.050903303456459999, 0.34354706234249616, 0.20023148584774939, 0.0078897819153105689, 0.24229433246574272, -0.12038862584021852, 0.036629384305942821, 0.15394832566301048, 0.1045549709081528, 0.19465973287404986, 0.14879843481644367, 0.29920186786826186, -0.055921384765513935, 0.15326715692895948, 0.2691346701561726, -0.064053764870367721, -0.17544342801134377, 0.25946368881015441, -0.1751700186926051, -0.049994277785006383, -0.40121181369101416, -0.030965397407444147, 0.43352521931820959],
                             [-0.14448442323096994, 0.12132815798307466, -0.28147293453927069, -0.33908376889200065, -0.084197132491228011, -0.11795100656767103, -0.007123546771192384, -0.11000624008624274, -0.22603577568177144, -0.064008227305638599, 0.21629160203484965, 0.41674357673400947, 0.18507559527629572, 0.1134473566704078, -0.061921366931769521, 0.072113501571945918, 0.3169997780997254, -0.24557140870648617, -0.28061662215062133, -0.10071122578650311, -0.1625749899917136, 0.022860443751362598, -0.076821271839722705, -0.086156187234777221, -0.17189983172783049, 0.082146786962953647, 0.083564388568252393, 0.16861743512409655, 0.2450879577853747, -0.18543765298103299, -0.34595975991071259, -0.053716504799633795, 0.27037603235605068, 0.18403293435779722, -0.19357218129998588, -0.29907391495362273, 0.0011151577150114765, -0.14017856981868926, 0.22485452501071182, 0.21368931251170722, 0.033730019173880625, -0.36416517142574134, -0.061279433935290915, -0.52664703641068866, -0.11267651241104318, 0.050340733779933602, 0.081206237577709811, -0.37291911728571331, 0.080195492434254376, -0.45852027587687438],
                             [-0.051407245534566347, -0.086892597448705422, 0.10768355969728775, 0.065937611305108626, 0.30885784501596925, 0.20896582926848001, -0.37544578286622893, -0.14324095862118802, -0.22202537288623356, -0.096548399061377618, -0.22323324442298614, -0.070916608762790129, 0.11708545193587896, -0.083129061908119362, 0.041650011807132903, -0.041483376082569301, 0.23301070347556632, -0.22672443939195164, -0.31718698645241511, -0.1708545698932904, 0.48200039775132275, -0.040847113054565294, 0.16760506818741674, -0.080813757230842859, 0.023905310514188018, 0.31674697912868105, -0.0099688903277614285, -0.064787403445559583, -0.17221012843846925, -0.15894927470310546, -0.018540673770452789, -0.057543845450281933, 0.20168724221181281, -0.25937729284693023, -0.10854903908140139, 0.053052179401521286, 0.27570967185807449, 0.26645047863407828, 0.38478087498328228, 0.006962715231115444, -0.053638250554348121, 0.2077238428745749, -0.3341204081625665, -0.23946039264737734, -0.0025257299454537769, -0.020550944670460387, 0.23719251267877076, 0.23284179153805173, -0.16925003573353217, 0.10887752494045431],
                             [-0.058369899244610106, 0.22850055113999085, 0.16997644870476694, 0.09454401332085785, 0.21153552398980324, 0.034988263491282139, -0.13261898676956888, 0.2587131867390578, 0.16415359605125732, -0.065660552836396213, -0.13586767930479973, 0.24072643474007993, 0.12920951019505231, 0.12040054562325286, 0.10877584033698398, 0.19888480058695721, -0.27946421828910661, -0.31239484565132458, -0.21623188723481535, 0.20623725409896432, -0.061078118581465078, -0.035142248844845958, -0.32571692094156823, 0.28239961211295173, 0.29042810024602755, -0.21573820172205319, -0.028501762963793351, 0.41340758695497171, 0.011807152329060398, 0.11007043723775692, -0.049778047723556276, -0.12254659224270274, -0.032368444398738601, 0.17036121182284009, 0.13663265154445525, 0.059116539399922265, -0.06675709305177549, 0.31183425360220463, -0.051143050988795263, -0.039127658895687291, 0.3941491791228951, -0.28190194199123308, 0.0077064516747458994, -0.10896893013309659, -0.41641279337255177, 0.051465057585677453, 0.03656591740071654, 0.35369137691677999, 0.034786124739217238, 0.049685424192277131],
                             [-0.034905725981768748, -0.223074427769098, 0.11505030448687367, -0.20239757248824519, -0.079234818418092406, 0.11616500923757429, -0.26972496500532323, -0.098033438965185737, -0.086294692840235623, -0.17836350916525381, 0.32444814145367173, 0.14918947706607694, -0.013319438885621607, 0.24624666994890759, 0.55963990043503797, -0.13560330359714731, -0.1290043428478419, -0.012894815201145649, -0.28933726184335251, -0.10457522766974575, -0.042225289170571806, -0.43339599624344916, -0.10549464396985017, -0.10222713360433766, -0.1285913525419243, 0.0061982426642991553, -0.36266724288638452, 0.40373429853661452, -0.0475041011335888, -0.36831571280571196, -0.15312462875113955, -0.02979424968476338, -0.17447124565326799, 0.13399270216619047, 0.36184191259240117, -0.086076883567495655, 0.18202173616307854, -0.2302840541421165, -0.074137997460307137, -0.1063759368366646, 0.14993448403713805, 0.14418595865645442, 0.11108445241515218, 0.13926548871657363, 0.47079408321147226, 0.26338580874109985, -0.074455458291646071, -0.058420514298445581, -0.092098097702094539, 0.02908740530381641],
                             [0.12016577453134504, 0.027269577281282861, 0.23935388221350076, 0.17508939411937313, -0.39008501179730581, 0.11456668862157389, -0.27457966614802676, 0.055125309510381332, -0.002536575598309455, 0.24338923386517866, -0.22635672588692846, 0.1854847928752428, 0.041779179107446621, 0.052282179965446346, 0.11619409247084142, -0.14862232783125343, 0.21161908310225575, 0.48652208761633881, -0.19776496056172807, 0.0031162332615732972, 0.37295018725863799, 0.044529032867937031, 0.073743913063379643, 0.034301110185807282, -0.010833382860401634, -0.26160108299270801, 0.0034986261180815579, -0.18914622093701569, 0.18433319092023012, 0.071029964943604085, 0.13017654461754927, -0.32025629718896781, 0.12570834291334837, 0.36655381559153477, -0.11197527081356656, 0.075878032282711186, 0.20403635702943823, 0.28315905284182741, 0.23302771143246415, 0.038222537326164076, -0.25055693574670213, -0.031823603573676876, 0.21829149627763694, -0.16773045579187229, 0.25795520380128728, 0.26037553698258242, -0.033976440721917855, 0.0074324773126774185, 0.40600297611448155, -0.19000357813435581],
                             [0.019515722854339765, 0.43529810911453004, -0.52732358812707425, -0.24136376745680829, 0.097691685889198784, 0.31615771318999153, -0.019985062867887669, -0.064525546973342104, 0.18086701652242115, 0.27282693514205592, 0.29592000268653107, -0.15179607384197427, 0.30947313138313259, 0.1174104583667073, 0.044144879483645559, 0.1421440207956402, -0.020002765229767138, 0.12004070969737168, -0.048683921804010655, -0.040263518387316739, 0.18033665386825554, -0.034730275959041629, -0.18499407765219847, 0.11470480587698718, 0.076800565297661647, -0.059691844358258042, -0.088828534896184724, 0.20106825884379712, -0.037286481501968741, -0.13699739349646081, 0.21324835560131425, 0.088915765262274751, 0.39632857264757099, 0.090071645497556835, -0.012841820993362136, -0.098721054135314124, 0.16484956436833656, -0.1516079840580796, 0.30942345124612286, -0.21431630166926208, 0.11292446165130314, 0.077966950597968696, -0.26048947434536718, 0.32851880609459622, -0.30340762488251838, -0.13424186198716498, -0.23989317104729291, -0.082555179624779998, 0.2726273931721348, 0.17375770598414969],
                             [-0.22371491420395084, 0.099815089537780427, 0.27740494606129024, -0.010454794494819068, -0.41736409939324093, -0.085542691588975928, 0.079277142066559364, 0.021444874843011524, -0.023325528419244602, 0.1370414254578301, -0.3003693685183777, 0.39940324562997859, 0.31016445005891413, 0.15171412211017332, 0.11065027689967995, 0.35753043445131649, -0.2637608993891653, 0.31362029355772258, 0.1012084634217613, 0.024110079515787655, 0.12839036764175099, 0.064479752332058382, 0.00042497727222321098, -0.17574807908193005, -0.083071510939395077, 0.042981321342363758, 0.032544498858860592, -0.18406672291107323, -0.1959820663652912, -0.36026851021667877, -0.23444101815033311, 0.0075261833676911784, 0.046607298759045235, -0.178184517619214, -0.34284301711012272, 0.4850329497228239, 0.085037095500671192, -0.20422941020141933, -0.26462042620344411, 0.087078140833554293, 0.015185117905113385, 0.23674250561975946, 0.093393594855915307, -0.010776399377023467, -0.42406208772203768, 0.15692638158187242, -0.10905935209471142, 0.003110784122590915, 0.10782589494910569, 0.24448393591779616],
                             [-0.1328904207540082, 0.51598629582933486, -0.15350074884796044, -0.16541179561101457, -0.080735250657741425, -0.25005859305480227, -0.1341303916306967, -0.067057381098901664, -0.3200233219834156, 0.31575559504227874, 0.099258714147263227, -0.039224963423071024, -0.27562775505779435, 0.2321714461476943, 0.11011822555610054, -0.42646677573226893, -0.05878937681912963, 0.16477897933728353, -0.13448807528235049, -0.10393747044251184, 0.17469258551330186, 0.3728756126925093, -0.064967297553315054, -0.35415128209396096, 0.12290655505850027, 0.0062862617542202596, 0.010321832475453034, 0.039116392644814424, -0.11277190393534837, 0.11251084659818919, -0.076379373975215464, -0.12537166152352378, -0.60252815616625333, 0.076838769553789155, -0.014591637863170009, 0.034024321223575474, -0.33209413135738103, 0.15194646995501876, -0.076379965961981086, 0.078048393715718686, 0.32208671633643104, -0.12344697593275863, -0.18569953811072623, -0.029829940200080188, 0.051742680979639022, -0.38142658249876349, 0.091821218841253341, -0.05136889010451872, -0.13978703679913868, 0.13992850251232747],
                             [0.32728991060398527, -0.17327052601506468, -0.036603159732321061, -0.13991275790330882, -0.028034225962812975, -0.10002838756822202, -0.098593107775554509, -0.1023905846190476, 0.17784702276765829, -0.14996670825398672, 0.053223664841660315, 0.33476863965590237, 0.10160096394338325, -0.022730856594423296, 0.024498806124221152, 0.25079823533033491, 0.23076373012815671, -0.016834592418798047, -0.0078103182628411622, -0.18015629206890879, 0.087371765849556526, -0.2805533782775067, -0.092926231262091347, 0.11938515890518236, 0.26399439257994506, 0.47388100990020637, -0.11776445233769114, -0.50804918946479272, 0.25022697049107057, 0.43366555111552824, -0.1808823779257632, -0.47345764023032932, 0.055794614811904536, -0.35896963959785139, -0.028977763069754862, -0.35811667197807751, -0.34955426722862498, -0.25094305531698857, -0.10857833658693264, -0.0046887757501167006, 0.20653231304337044, 0.2498755477765118, -0.10039222878784175, -0.065739752483363112, -0.093332483770132521, 0.013001374388158612, -0.23643499681292426, 0.13752195118198665, 0.10758170437059569, 0.05273361817854829],
                             [-0.22960450192146539, -0.16340318512128335, -0.0048243921843883035, 0.37154049650910403, 0.070517028640031898, -0.10329935795360115, -0.0087293463196436924, -0.17946537523392816, 0.30679857395154264, -0.010811127790520229, 0.18246580715079297, 0.26243006648793521, 0.082495651180630569, -0.1132004472097301, 0.048321053838327674, -0.33849397212507193, -0.089690379287685057, -0.099098294514516419, -0.070523529204613022, 0.11629416496070069, -0.33326112011710884, 0.044979428682376081, -0.25174975834661295, -0.15171174554871278, 0.0062986564350044159, 0.010437699451002203, -0.3344013703077654, -0.24531227203084, -0.3843165942031665, 0.036415123747448069, 0.019740301110075457, -0.40599431971956529, 0.073333472426172483, 0.029371008056988401, -0.11966957650467486, 0.19433820352094253, 0.11580860223924964, 0.10302558022011468, 0.25045129336251715, -0.20595425162799247, 0.22379802600911899, 0.045399137477113771, 0.050190956710477068, 0.2916903121258706, -0.33475448774065286, -0.087482198162870575, -0.14518269793064495, -0.2433961013020588, -0.14689109757795282, -0.18364332786798279],
                             [-0.01291158262130305, -0.43944309040368956, -0.20594131753274025, 0.045271167943292348, -0.08412003507709348, 0.036392299585212617, -0.23717119237393927, -0.17039595284365383, -0.33042835224305644, 0.059368946676828627, -0.059960151397382935, 0.039504726787928358, 0.027414529248766032, 0.081116541808140971, -0.17235644397923919, -0.011456003538046213, -0.067340174581334039, -0.10393393854637913, -0.032578460658538574, 0.35390159471015675, -0.2336049808767314, -0.050298935636171611, -0.28046913014294184, -0.40261815334207679, -0.043956382926177734, -0.032300711677703486, -0.1450020786064698, 0.27970400378760396, 0.017243342660864299, 0.23215798422075568, -0.066535495040723397, 0.16444861360537472, 0.29633369338246063, -0.10264362460363347, -0.083083220365178234, -0.1318803304502468, -0.46248627214974741, -0.025868591017607679, 0.092210004349644145, -0.1696086847529101, -0.46210624207549539, 0.25494550875452582, 0.02974794782570166, -0.017430479576491173, 0.032218572082025256, -0.14868994739684741, 0.12716974546706067, 0.17070246756129265, 0.29339565919258176, 0.043881140394697801],
                             [0.01783707536671976, 0.34740171891462707, 0.0020537307553397284, 0.03483180346247676, -0.027555947531922111, 0.33658242364493174, -0.043303035770210871, 0.40867132571949416, -0.11335848975772565, -0.18976159796634448, 0.26789346575119022, 0.023837779200621793, 0.24897235903933984, -0.3035435645362079, 0.47543036171473985, -0.20177535355902271, 0.075859465116620867, -0.25168125645897754, -0.28507958409183271, 0.29196008689526104, -0.0015239927082892658, 0.2271354240360208, -0.000188922506508136, -0.030032056577420849, -0.15372016742512579, -0.085506711867864099, -0.08383652454946898, -0.28941376953823184, -0.21813192290679431, -0.067093079441964215, 0.056171920871338536, 0.14171569842394144, 0.29013166898946452, -0.074253798831775866, -0.27899226237753538, 0.036682912138556942, -0.46562225392511247, 0.06723788990177032, -0.23068226185115298, 0.29006512471115148, -0.049777763520017657, 0.0034433830818949053, -0.050721978229903666, -0.20953894148518246, 0.089411856421508326, 0.097573564216276276, -0.22403804393244831, -0.11795472068296584, -0.12219744869666377, 0.09041622446891745],
                             [-0.3459910259025229, -0.069773263343705191, -0.3690969854770334, -0.1494296787069444, -0.0044312186131333087, 0.10670686281160623, 0.16291693720071607, -0.053070768931002155, 0.00060879112045240935, -0.24155958794221555, 0.022620738331079235, -0.077335186153418806, 0.10599789661915757, -0.12998388294179064, -0.012453542184670412, 0.027678276375316578, -0.1376711326276146, 0.066999809431800714, 0.34948793153601887, -0.24613811364188853, 0.33477493228010141, 0.032134682224397582, -0.16695840007720247, 0.2036802110041043, 0.25408688887291925, 0.015218870626082263, -0.31117019798852597, -0.18016951198659409, 0.10765086787680708, -0.04359328256526742, -0.22127517126294174, 0.20196754881768533, -0.027612623694759662, 0.10678760225018892, -0.17956685201139125, -0.051294527815209962, 0.045408029865573143, 0.44730587298986035, -0.098588317231381992, -0.037285158465485177, 0.028846202303975464, 0.15724679847418299, 0.42202366557760757, -0.087452832189431118, 0.2740671227508778, -0.42883988368361747, 0.30414527896558968, -0.058815114610557703, -0.080632347921966913, -0.11248859658807958],
                             [-0.26083213770417824, 0.1682035321410327, 0.071438196871673257, 0.088011033670337122, 0.32880528545795124, 0.36908036133888272, 0.14913179256287168, -0.218281575484015, -0.069354445121258088, 0.0071699055479799373, -0.32478752309337106, 0.27514506873060235, 0.24383277573406165, -0.24572918776908723, -0.27206132062656241, 0.036162658590244229, 0.29423996102172867, -0.089973001886700238, 0.17816933516264041, 0.15904569583696709, -0.082029768002929548, -0.23542862270654169, 0.090874448755011328, -0.13287611557048457, -0.1561671075044988, -0.18380300527120624, -0.19357881952767772, -0.079817264067066712, -0.3817740692659079, -0.16929550123883674, -0.050038860732216771, -0.14501121206974676, -0.3490507427644356, 0.31842636807311148, 0.2134756009913934, -0.49007715010348613, -0.071361814594551848, -0.15648020015006153, -0.11780143660501301, 0.1855776290435264, -0.2724071015572696, -0.11031054904710355, -0.043762750255225143, 0.2247854633663845, 0.048391942328999633, -0.27533712087827905, 0.060754314238812772, -0.017619119487611079, 0.14230446392357646, 0.35337875993834955],
                             [-0.16233015755365698, 0.073228866588595426, 0.045276812301095412, 0.04701888545693015, -0.18612257664381573, -0.049018299113936251, -0.24097385809174104, -0.14671166299552016, -0.11702794801945762, -0.083875595544425322, 0.27722462470842146, 0.21308023717480176, -0.12091955659391185, -0.18548020212616789, 0.058100492423795898, 0.080243662477939695, -0.21577120417818191, 0.14689282430657977, 0.32406766199102899, -0.17673884838764861, -0.295220693109013, -0.26715984094869338, 0.1649523523421968, 0.08166598902703999, 0.23945311933763566, 0.017704757569069834, 0.36374507412713025, -0.071817346900017981, 0.039145041659802961, 0.27209152159471595, -0.076559698333131698, 0.038909723908705098, -0.19539291639452586, 0.05703234807700204, -0.15983550176690511, 0.022224074288618514, -0.0042719938023205841, 0.41383536193230164, 0.013696140634430976, -0.27532518561142622, -0.45206847932849675, 0.12635240033874423, -0.25522666521289317, -0.27993162226094997, -0.13760417330847816, 0.089121125394408279, 0.0095087669992791352, -0.33103240105225396, -0.088473419060738037, 0.080211558800965865],
                             [-0.2031956277364533, -0.1485585997613961, -0.38131416934663459, -0.14469230593848223, 0.11481022480420991, -0.27642180584665299, -0.16336773815177336, -0.24833185421705523, -0.025151978127114481, 0.11983042372254993, -0.19073292953921744, 0.12959819931817879, -0.26263224894442716, -0.099578111687624496, 0.38295146464294483, -0.18110008132268401, 0.15043107695352531, -0.19149350358438602, -0.066974708709761036, 0.23118125463924488, 0.08532178672191075, -0.26524552848688143, -0.41986842578303912, -0.22863933166320832, 0.12281022236155624, -0.11237855239453315, 0.048452982636994421, -0.14534720139757915, 0.15111272725780608, 0.058940485916974969, 0.45472498448291493, -0.12165639282872048, -0.057954739012955933, -0.5059124560655337, 0.094225209719211167, -0.15470574097939893, 0.27537624793433307, 0.24153727308007836, -0.079793669193889027, 0.49148494429365491, -0.005865886357733361, -0.18716637172973499, 0.048144348725748201, 0.13505112624282425, -0.088095593227126359, 0.25596414119094574, -0.28078917852858931, -0.0060127082319396674, -0.049011346252126144, 0.078368955739877677],
                             [-0.11011395249608262, 0.11454432560448292, -0.086021759006570317, 0.02081989824478378, -0.087305373540576658, -0.13174723244939981, -0.046596000569697489, 0.15121219503461694, -0.016902003357041076, 0.22715954692055312, -0.1337908658661722, 0.0054955354031144014, -0.16779410015559942, 0.22784270102417839, -0.15812074553711691, 0.10675314083548332, -0.36948652584521174, -0.27773107024215349, -0.24513364251768802, 0.07320593092804438, 0.095615999168344012, -0.14761167065920136, 0.22722237513430243, -0.0697316041784211, 0.11505477669970468, -0.098794280648965477, -0.20770119794458872, -0.43338423280954214, 0.057125107633049628, -0.32051202305662785, 0.083420896575483128, -0.010366657530792927, 0.084849514157359848, -0.085214640915015613, 0.27653937612208573, -0.29505512864414318, 0.0086755463039710212, -0.01513009370940565, -0.14811302475862115, -0.07037267738539793, 0.047900507296892804, 0.37637921964551979, -0.41055601387241719, 0.12753392289446183, 0.085331389771550387, 0.026815513852085762, 0.072048221396364048, -0.22759265484773405, -0.12225828297595333, -0.37259109621126685],
                             [-0.029723246895967503, 0.062851844975151339, -0.4824092730941682, 0.078281383457144693, -0.11880615301509084, 0.43151475833753394, -0.29955803872427139, 0.16673888778152901, 0.16558054193463054, -0.1482465147891501, -0.31013492855375124, -0.14034681049909761, -0.2229658571357952, 0.28675601092216452, -0.083978353578389772, -0.21519810533198458, 0.096990356484944584, -0.075617988870205835, -0.043619803750204897, 0.22095018767190505, 0.0010579668317985819, 0.014271964653236626, -0.054468954861906664, 0.20889161537249329, -0.59377224598313494, 0.0573108076566472, -0.047461050311440357, 0.16327831809893223, 0.038148969683397302, 0.13707598571089211, -0.18768259367126694, -0.13176564135212043, -0.2453102417012164, -0.0084573250628197649, 0.014731840361357502, 0.12622013364079335, 0.14220046177347062, 0.14686908229690177, -0.28747355217361314, -0.033188331896551085, 0.14964027122634832, 0.10188815479221262, 0.033608579706276981, 0.045747648128904347, -0.23304388610542034, 0.36129793511269154, -0.072099013109438878, -0.36360430450915526, -0.15521682348403892, 0.045322934542575292],
                             [-0.0085612878782582238, -0.25015243355515415, 0.16899374694755509, -0.17731710283082505, -0.13491773330079007, 0.026914898235841124, 0.31389183954691929, 0.15803637267129889, 0.052950809153913717, -0.01401917985014711, 0.3655310297945466, -0.1735757138113671, -0.18597400447157642, 0.48768815934550414, -0.064850663102515943, -0.24753492373408456, -0.030312625849410343, -0.463021587918797, 0.15672428781892675, 0.10513780641124373, 0.17033935470508915, -0.24608355237561005, -0.200473144684578, -0.01961317179074612, 0.11073561112221497, 0.28087187420276111, 0.23671800142507551, -0.10993160345013184, -0.23186529556521296, 0.23279753249986732, 0.011151761864405738, -0.023121971394362829, -0.048232542565133506, 0.33037871329410129, -0.46057551062055352, -0.036617736571025294, 0.22344300020807176, -0.15752379484768469, -0.23353135813537998, 0.017375285110499964, 0.11807929830212363, -0.070764733768761356, -0.26734945611532657, -0.16155298655166714, 0.17994533177296335, 0.0052226968542982838, 0.35591391965405555, -0.078650425067221363, 0.21179768731136592, 0.41874795833144418],
                             [0.098733377297046093, 0.37383575312870199, -0.19823236171649564, 0.26643978615439784, 0.33723913239750841, -0.11580401188173972, -0.072387467812970022, 0.012746820152153393, 0.32139234314790049, 0.084591095514292086, 0.016549873096145779, 0.14472614413803089, -0.044089979132345331, 0.32952714155540352, -0.060013419699665949, -0.025586183645270797, 0.19111064745184458, 0.25638751420207595, -0.18547521994927851, -0.0012523165824640525, -0.086903417595422944, -0.23579830895283091, 0.087351741768879443, 0.081460394533287198, 0.0074234866727418587, -0.072626850010648489, 0.12236944687202217, 0.20248545578717003, -0.27324188632661256, 0.035296118609453808, 0.16435065929052123, 0.00025230322729674539, 0.072012902960120487, -0.14149943520172148, 0.048654386731133231, 0.097300034285125181, -0.11129734139188384, -0.29815178308182466, -0.1108896138852013, 0.24526587055100696, -0.40720075097352071, 0.50435836556101943, 0.31517961526561616, -0.25472240705185389, 0.076440842063999453, -0.017284584537169773, 0.30848446132876961, -0.20638728820527152, 0.11505534098859051, -0.092656185588783635],
                             [-0.11430729423000441, 0.0071330124597343758, -0.1466565625406604, -0.29425053776573606, -0.48236408751641607, 0.083544156553496896, 0.10114112008892708, 0.16171096202722876, -0.09311075570487759, 0.029136032281009069, 0.040429915724360103, -0.31821580253979215, -0.13183148478944956, -0.36895103016922604, 0.34274581916144403, 0.12302714211026899, -0.076504154252352533, -0.022643238917455556, -0.077015272193624501, 0.23093782005691643, -0.11533826919647977, 0.054799883802071958, 0.25123519792655497, -0.13582823652456288, 0.20236489267264532, 0.22604894751140139, -0.21805470654654077, 0.10496254981146386, -0.2138680500196837, 0.29622296799823206, 0.12888030546310006, -0.25520200459555981, -0.13509976624648726, 0.058608073354169517, 0.20807353059437411, 0.086991306169202837, 0.39807308698190313, -0.26001651591862374, -0.073330794926400683, 0.056689727058471931, -0.33087923645346368, 0.18605406082188775, 0.17468381133506275, -0.37443821113276859, -0.17492281972674587, -0.20934064436952096, 0.026428945933457883, 0.054655323223802246, 0.0095446121917735528, -0.10296094839080328],
                             [-0.16879879716864085, -0.40617927233368495, 0.084943720786957957, -0.16326546614696727, 0.11164127116343626, -0.27713618433500886, -0.36512851390544188, -0.11284321535703612, -0.11265167683200611, 0.012006509807517003, -0.016795698451585461, -0.20541286414603144, -0.053672490794787947, -0.24296671618572868, -0.060290936787772052, 0.11756524823599339, 0.053590382809481779, 0.48633329789255303, 0.18428536729690681, 0.48401369347568013, 0.085154020029726857, 0.43418148506215953, 0.12817605246565503, 0.3684108320632582, 0.013786723520267313, -0.19039000681041401, -0.22475854914830984, 0.036009502513843078, -0.28085794694808491, -0.04866051372470441, 0.027939702620613564, 0.056786932623935887, -0.29133358181938274, 0.027544923731736337, -0.39140027744391531, -0.3466558153362016, -0.071090612688912355, -0.085906325767309014, 0.2150449563219696, 0.053621038316718626, 0.17925916386627089, 0.074366811180287096, -0.050453165805576766, -0.31487733642085491, 0.022388621704201007, 0.36141367999381235, 0.056459900403290873, -0.097852021075853696, 0.15022102928148781, -0.13348989967005631],
                             [-0.14627283271070424, 0.0070598455846686689, -0.011048513000397338, -0.0043357882507087117, -0.019663572212258298, -0.27482296674907064, 0.025305298630247927, -0.11323697294911009, 0.26795725487443284, -0.020258053052011765, -0.4808293749677568, 0.041074791921783038, -0.1596333410317001, -0.032956104060936534, 0.36106795556218679, -0.07868108084581206, 0.26243378143348339, 0.029049973966746512, -0.0812222464051158, -0.050912328135717513, -0.5439905287406569, 0.23360605942178, 0.13537074540677799, 0.37414572365507331, -0.039715175353579546, 0.34936983576156505, -0.1914483290745424, -0.12820646794072146, 0.056819975456624525, -0.22322482997903423, 0.03047586931557204, 0.07290085455999866, 0.25725485847635743, 0.07995245034741269, 0.36298061048012281, 0.072915421352781479, -0.035144268191657523, 0.069916724250937104, -0.25501038510869362, -0.090807122263621406, -0.1498133426114448, -0.050344269428222267, -0.34556062291098166, 0.16799511709230916, -0.09512698568938098, -0.053115097725483715, 0.38091202195395896, 0.15707396461829312, 0.2699741020170231, 0.17740749477202411],
                             [-0.19196557674084799, 0.22289325158928353, 0.21822484984887347, 0.17121335272475965, 0.37551611698753978, -0.1348958561780336, 0.29618794023909323, 0.22385100363924937, -0.071878786749644527, 0.13797152992918715, -0.10745909369181704, -0.36700085105956715, 0.0095643126277636849, -0.081907614013574478, 0.38466013079870609, -0.073279841934817583, 0.013173115091089094, 0.10106745448243104, 0.21073338155048132, -0.37651537675290148, 0.057209433867184432, -0.10357245974795017, -0.32478630530726232, -0.25272542948954713, -0.061153153191508727, 0.19227686198204882, 0.016594254991933122, 0.067070647424079463, 0.25244268187881386, 0.13346193276558019, -0.089455942855501167, 0.094827777800975177, 0.17494942064586527, 0.25785145281395444, 0.12039022579443417, -0.24212056019522102, 0.081723878068166139, 0.077596210979689731, -0.11758685413231411, 0.13353051875290173, 0.13069737502462028, 0.42259612272353875, 0.11348795726664609, -0.12947430403114787, -0.21227789296160085, 0.29247989611012692, -0.14005208496174346, 0.32841615944761454, 0.027012484212414253, -0.16395824698554937],
                             [0.16210260767474782, -0.028374774790003457, -0.07693459526814328, 0.30803976045184767, 0.052499041861794646, -0.13001533199911672, -0.15296342795401796, 0.17346411594469763, 0.2019335421582692, -0.21698991000563084, 0.17451464189509994, -0.07180798097065981, -0.3531981621095735, 0.031800980560286601, 0.13852957287086112, 0.43216413816928212, 0.2368338082040089, -0.0075823940578703996, -0.15998703929259739, 0.26426554898210775, -0.19293306426504014, 0.062513430357766311, -0.20256404904915989, -0.11985680051282344, -0.07044103359847266, -0.052325467073073138, 0.10771956234926966, -0.36889436706946732, 0.20010120761192959, -0.1639830302333786, -0.23741332531066359, -0.00042663465891254904, -0.24524579712587993, 0.28279966123785621, -0.33723525792559655, -0.063537210371752903, 0.2117221524747622, 0.056317963910321046, 0.12291222564721484, 0.079260768784359989, -0.21349152842160718, 0.065075276787976283, 0.023945332189441549, 0.29658235847173775, -0.0038828570172671981, -0.24669291015544031, -0.040643774932458313, 0.35443228350257666, -0.36369020934893864, -0.12763023685843036],
                             [-0.20122686835909229, -0.33130970308015106, 0.028361941327405028, -0.34800783578450389, 0.44218083647659973, -0.142902058861854, 0.22748546760600893, -0.058049179550049512, 0.044928166694962697, 0.030244540976053842, 0.2743322970308652, -0.034518528049077457, 0.2176250401398836, 0.29375209295691723, 0.11991741287299887, 0.097423429345649931, 0.045880913127340037, -0.0091024324390457725, -0.10197063167908423, 0.13062471823303803, 0.40696900197325403, 0.11742671745716254, 0.13403165513055179, -0.061978204132947988, -0.29669965621534683, -0.39575371299011597, 0.11310607042676701, -0.38128163591356784, 0.0091495232833962853, 0.30253373510602444, 0.051400174718853164, -0.19879361465228473, -0.12578375524063884, -0.013198449347767004, 0.24181819366603949, 0.16888466926905693, -0.18951690745571179, -0.17374273784805494, 0.15511493612535382, -0.40060921645323538, -0.40294550220716047, -0.11471061558994519, -0.11425478470995518, 0.030212988212972351, -0.21605742751275675, 0.11900566168603308, 0.24041927674555247, 0.038542070347999453, -0.22709022563964212, -0.16531935224178038],
                             [-0.10438169715318944, 0.33872712693250401, 0.16468082081641772, -0.23554841783121452, -0.071538495642278793, -0.14408064326661349, -0.061063817337675838, -0.34470133097193933, 0.032163451478560458, 0.079022991431466211, 0.14176258797314983, -0.2603020235396995, 0.089333490531487092, -0.12800606963388059, -0.28796128616698125, -0.038515384014801972, 0.36915999972946978, 0.14857933981470808, -0.26269064549928683, 0.21878084628695471, -0.10049817404834029, -0.19279997020344472, 0.15753232437906742, -0.19975892496963921, -0.042791392147245262, -0.31026093369070357, -0.10248106014624567, 0.16277842993903932, 0.33897265197361126, 0.17316104064802199, 0.14033630454051746, -0.15753567419453995, 0.10185741614162763, 0.061770992619442723, 0.063053068557481384, 0.090353179693571914, 0.27576771253458809, 0.021777802720559042, -0.36552740410634615, -0.38626079511924311, 0.18744305415332294, 0.0058774076192059481, 0.25711292677233721, -0.17618202688245321, 0.040676239122162186, 0.23984508002356272, 0.2228306661341394, -0.071008800002699241, -0.1934014050990483, 0.19656527418970632],
                             [0.26467621610371289, 0.21192576953203021, -0.14384511723131962, 0.1457822680486747, 0.0072936907587870248, -0.41439805664986473, -0.32145982745285295, -0.029506306296070713, -0.11683047208688069, -0.078068982689911512, -0.064970517160725633, 0.020208022225773184, 0.054766056116479653, -0.11190674248423496, 0.19425482962778612, 0.14254256823732661, -0.1546694571412473, -0.13948439441311541, 0.43415758237759161, -0.06007313478170126, 0.16441937737346252, 0.084049868515437609, -0.33821852119189272, 0.064553124882216262, -0.50433259721902113, -0.24913510480752388, -0.071838654717673839, -0.12850531246686353, -0.031525506036065937, 0.18117953360062458, 0.1961070990436731, 0.046861829981083014, -0.077428107090583245, -0.17085771188508178, 0.050778433147287305, -0.16893612811631353, 0.29372692522808708, -0.24054298797578311, -0.33985106525884612, -0.12917210971566026, 0.026274636874022213, -0.014163076665384619, -0.17032483870067244, -0.37552913271987465, 0.16902079943200871, -0.46366073067187785, 0.075998152118164825, 0.076619770487452443, 0.046307379539797786, -0.079877155749180473],
                             [-0.025116348499108765, -0.076674903938011602, 0.24354816217380257, -0.12108233934456578, 0.13535956927059289, 0.24288367610329098, -0.25477482754504233, 0.36121164214603885, -0.10031537813405217, -0.064142374183227588, 0.0091436491240680651, 0.103073005654852, 0.051614683635566386, 0.25233970810865042, -0.12310774196515174, 0.26763495384255226, 0.32567521328333265, 0.25007913236774526, 0.38179403866075812, 0.0329334613094239, -0.061038362102540183, -0.13698141251888021, -0.31573408156338173, -0.31235490432429858, 0.15417303834986432, 0.21909868954619419, -0.5398328683496566, -0.052564928130561038, 0.027483227831351049, 0.13306027824398564, 0.036419623086953873, 0.20062576283257236, -0.024403516402066457, 0.015382007911977084, 0.068142419696795034, 0.40437053922491784, 0.00083406795980497418, 0.0069902783316192554, -0.11143299271829443, 0.18884438764580527, -0.014570024242957631, -0.22553160733140165, -0.23677569828678832, 0.097293226043267456, -0.029516279014141597, 0.032868031110704923, 0.24302975072823627, -0.31499653981377745, 0.020980380209362024, -0.27665428043791529],
                             [0.34288329547901647, 0.23663728772305154, -0.12015534148752846, -0.14975030938546963, 0.095941296984532687, -0.27536051060610922, -0.13758183103142413, -0.074045980913527307, 0.28945322409240981, -0.13986848261202484, 0.10384849045002875, -0.21724622397338486, -0.52079586439581615, -0.14217268400216659, 0.14793614577391712, 0.1494589157968082, -0.030929968188929458, -0.11950146502107448, 0.2880965994985546, 0.10005617124942212, 0.23138766502683467, -0.15120172650495931, 0.31371693507751691, -0.6041154227687372, -0.049528894950260707, 0.098128307796821079, -0.085021252932055327, -0.0012320318347678466, -0.15787841092550878, -0.19687176799483042, -0.13959047534995236, -0.015054892151625679, 0.22433919698457719, 0.025015121670367679, 0.14687802140167289, -0.036010383108088059, -0.11043854816471418, 0.33932915174588635, 0.23097687188444127, -0.031055447240213599, -0.065772277866075382, -0.19367401685498606, 0.14190479933535347, 0.0548023713732428, -0.098585475610993942, 0.041159418107495946, 0.049353991191234362, -0.22643318046721203, 0.44674497535986518, -0.030985068643430806]]])

    sigmas = [2.0,	2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0]

    lambdas = [10.0, 5.0 / 20.0, 1.0, 5.0 / 32.0, 1.0, 5.0 / 100.0,
               5.0 / 50.0, 1.0, 5.0 / 100.0, 5.0 / 100.0]

    biases = [0.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0]

    def __init__(self, num_variables,
                 matrices=None,
                 offsets=None,
                 phenome_preprocessor=None,
                 **kwargs):
        rastrigin = RastriginFunction()
        weierstrass = WeierstrassFunction()
        ellipsoid = EllipsoidFunction()
        non_continuous_rastrigin = NonContinuousRastriginFunction()
        basic_functions = [weierstrass, generalized_schaffer6, f8f2, ackley,
                           rastrigin, griewank,
                           non_continuous_generalized_schaffer6,
                           non_continuous_rastrigin, ellipsoid, noisy_sphere]
        if matrices is None:
            self.matrices = {2: self.matrices2D, 10: self.matrices10D, 30: self.matrices30D, 50: self.matrices50D}
            matrices = self.matrices[num_variables]
        if offsets is None:
            offsets = self.offsets
        self.hybrid_composition_function = HybridCompositionFunction(num_variables,
                                                                     basic_functions,
                                                                     matrices,
                                                                     self.sigmas,
                                                                     self.lambdas,
                                                                     self.biases,
                                                                     offsets,
                                                                     2000.0,
                                                                     name="Hybrid Composition Function 4")
        self.num_variables = num_variables
        self.is_deterministic = True
        self.do_maximize = False
        self.min_bounds = [-5.0] * num_variables
        self.max_bounds = [5.0] * num_variables
        bounds = (self.min_bounds, self.max_bounds)
        preprocessor = BoundConstraintsChecker(bounds, phenome_preprocessor)
        TestProblem.__init__(self, self.objective_function,
                             phenome_preprocessor=preprocessor,
                             **kwargs)


    def get_optimal_solutions(self, max_number=None):
        return [Individual(self.offsets[0][:self.num_variables])]


    def objective_function(self, phenome):
        obj_value = self.hybrid_composition_function(phenome) + self.bias
        return obj_value

