
import numpy as np

from optproblems.cec2005.f21 import F21



class F22(F21):
    """Rotated hybrid composition function F21 with high condition number matrix."""

    matrices2D = np.array([[[0.5039408974861557, 5.783530116964769],
                            [-2.4122450377986344, -7.840784197745668]],
                           [[19.59089043010601, 0.5362916781782245],
                            [-4.009897194601028, 0.911113538604415]],
                           [[-20.368133637360355, 43.55179431310829],
                            [-6.75524067936401, 11.989456518258153]],
                           [[-1.9334224335937562, 0.22738086204625507],
                            [-91.1947110013384, -40.99676647028668]],
                           [[-45.76221832831943, 173.05414088128953],
                            [-21.725626033874256, 86.52791960371087]],
                           [[-657.7994818064127, 551.0666048539448],
                            [-394.3324110050035, 328.8288131854362]],
                           [[1969.6248600074907, -238.18837263258857],
                            [250.72549448776428, -31.335864388565295]],
                           [[-2004.7566646805185, 153.10231180937748],
                            [2219.968163693489, -171.0343524705698]],
                           [[414.6395045197829, 1229.7648975693273],
                            [1211.776891668672, 3584.320039117001]],
                           [[298.2279263486516, 4932.583805137509],
                            [-44.97848206522227, -760.6937921345643]]])


    matrices10D = np.array([[[0.49144806626908444, 2.28451745491, -2.8310759305101088, -1.605024264955154, -2.3570481008527242, 0.7550774061374208, 1.275719477354559, -1.9953097153826875, 2.1261483691843415, -1.2210841005434765],
                             [-2.4664502547462956, -0.20106114695191721, -0.80013319521550241, 0.3248210282422514, 0.51922378787511114, 1.7909798457487238, -0.18319489820423807, -1.3139286746963477, 0.024857930739794143, -0.56765169968412343],
                             [-0.87031171170397059, -1.4966377769243524, 2.0453499431132807, -1.3837448708265065, 1.8035029871899166, -0.81364940126571239, -1.4966769312207573, 0.66458822248186833, -1.6352898926838171, -1.0559029327362497],
                             [-0.72896542978994161, -0.24137581022878246, -1.3244265782841507, 0.45764958188243693, -0.86534057625061012, -1.6955337950164819, -1.5316059472863133, 1.9265381547641731, -1.8336893764755264, 2.3114216671298884],
                             [0.60486336516690575, 1.130518260381532, -0.87341944036140506, -0.36722641211885937, 1.0548910654216628, 0.13464581522421193, -1.6276966989604074, 0.15857951885340221, 1.7105181368245643, -1.8428230257800531],
                             [0.12668518957096878, 1.7364254650072848, 1.9140527123363849, 0.70555037489892602, 3.1229567389715918, 0.45132501401352693, 1.9258735352144856, 0.59908018228273496, -2.3101589711172243, -1.4053235494873402],
                             [-0.059752742674155646, -0.13250102454932478, 2.3595604343336611, 2.5609002758228576, 2.60496402302915, 0.13851913409981303, -0.80242523533013876, -1.878317835856073, -2.8367880349117276, -0.32988311344952342],
                             [2.2393190712191928, 3.9960881825404622, -0.49598817766118281, -1.3574145266755402, 1.8025702723820762, 1.3956264832850271, 0.23640491327597279, -1.6719407737635996, 3.1561628989457033, -1.3731189239818982],
                             [1.0182110012718975, -2.300698546026775, -1.4700522419233006, 0.91305533878160805, 1.8751232301753549, -1.7389417666717781, 0.65021542326760606, 1.7500721180657084, -2.8206107263262514, -1.9933723901834834],
                             [-4.0662291638726522, 1.9953643493452398, 2.4692410188296638, 1.7265065901631378, 1.393606496115315, -2.8583271625469981, 0.89393788944470554, -2.8940505367766645, 2.5259705971204633, 1.4354392285821513]],
                            [[-2.1984824122707023, -0.55737149009921005, 0.96597462098164844, -0.0059009240312430933, 0.17938956974205622, -8.3790189435703226, 0.97359969947708835, 2.1265609514540134, -0.95337936415497282, -4.2786370410996861],
                             [-2.4783274246798945, 1.6777800313497477, 4.1926500663196489, -0.52833208249047048, -4.9186999971331522, 3.9967536731651903, -1.1099430301727469, 4.7757554458549363, 2.0189288509176397, 4.7062916392410896],
                             [1.3713644885783631, -6.3599863735801918, -4.5837185323735472, 3.1190350279403836, -3.6646118112774042, -5.3157622607642079, 0.28974766104303357, -0.57878330457066296, -6.1453500687382263, -3.234547480410674],
                             [2.2272585112835288, 4.2942068782713907, -1.7879193450737927, -2.3061281018897626, 6.3171446296028622, -2.1282415982935481, -0.53882785393851285, 0.037263637812820272, -0.99924393793584843, 1.5231499729712366],
                             [5.5050652053931461, 1.9392974451457192, -2.2338337275569131, 5.2597743076084802, 4.8748297823124842, 1.704040583154995, 1.3572373247226186, -6.8540566382306061, 2.6712839412998699, 0.1533806041331528],
                             [0.69797659188765759, 5.3206090031231801, 2.0353717462395102, 3.3296307292135392, 8.482692821192714, -1.5829948628957156, -0.51405989718247347, -1.5084213010672491, -1.6674618443109166, 2.6810353245980028],
                             [1.6447506880136695, -3.0179979419078555, -0.12865966430592179, 0.68927991693474244, -1.3239449868851205, -1.8885030381956611, 0.74219056854512266, 1.2631385892170663, -3.7821803723477596, -0.82399123959560705],
                             [0.36958336895986638, -1.8336541869483822, 0.17754326073338084, 4.8799508224536092, -4.256935490303718, 4.0508910128004398, 2.4189263853818881, -0.47512827320716322, -2.3507188505543466, 1.5994017066464687],
                             [1.1459622949272306, 3.0540949520093017, -1.5168184380035843, 2.0378017358010205, 0.67443097987460754, -5.9558102818815852, -1.4291986442985958, 1.3952587426724168, -6.0078381998775958, -0.32437969060044719],
                             [-1.749626354738731, 4.8694003319616748, 6.6119903242749842, 4.0355238562534606, -6.168949284372987, 2.8027060241361261, -2.0832564540780534, 0.59944433437570066, -9.5792764814620082, 7.1844547061834296]],
                            [[21.330241425628671, -2.1823165161603955, -6.8601451341333908, 12.386318284256506, -2.6709715331404773, -10.186946865675484, -0.58858513739089757, 3.1345791954402338, 13.270591994474808, -2.6601716972782832],
                             [3.7625050005690874, 5.3138432505367819, 0.10636518354750385, -0.31103295641356254, -4.0280480441663737, -3.6340271363980547, 0.92861713708985016, -0.49990111294916284, 1.0191610863191782, -0.12663584382342691],
                             [6.1210521488988494, -5.5209312170853408, -1.5570301325544282, 4.3184158253237817, -4.036170986574148, -4.026943748441048, 0.97809007498900924, -1.2421083206403913, 7.34261852447779, -0.1780529072317513],
                             [3.3068572174353901, 5.215308415604154, 2.3285180344778365, -1.2078643380068677, 2.9444526788367615, -2.8711834056787242, -0.27998352592999814, 1.0226741226871681, -4.6136401903553876, 0.98898950140323105],
                             [-19.44412452264125, 3.9602865764005322, 5.2148415595366888, -13.721883383091988, 8.7637269790002215, 8.8038713716614065, 3.0809793120528668, -2.8077218219804103, -13.402274280182572, 4.1008310050023598],
                             [9.4549607678154537, -2.8012866680602442, -3.6984719606136585, 7.9475679355895359, -3.2878899156861516, -4.5738076123038525, -2.7847272146828068, 3.3779224269791128, 5.4404798579003568, -4.5957485350198652],
                             [-0.42437379501990014, -3.7292274483645214, -3.7437739606424754, 2.989056376830221, -2.776797768976035, -2.9129880252465359, -2.2645844642001354, 1.2038671830088588, 6.6966795788485038, 0.026289197427251533],
                             [8.0821030955047206, 0.32506507240017557, -0.3878173597404867, 6.4718327993706604, -2.5017566160558666, -2.0170536176696392, -1.1087718983441013, -1.2966998741110569, 2.8111199945921177, 0.31735579515051976],
                             [4.3477722031652561, 0.05620448940546522, 0.41025385925104807, 0.058017971868936952, 0.78793740404899637, -2.8295063536920293, 0.26635501266357969, -1.0693604153790637, 2.6242896330179435, -3.340825154865279],
                             [-3.097295804169089, -1.3559147962668396, 1.3121581314961415, 0.26321745754539799, -0.60280392830994933, 0.88154182026557648, -0.82267289515853925, -1.0548468102051598, 2.0564564019686751, -3.316846419688781]],
                            [[10.721611144573767, 9.0052635965359631, 28.550804283827983, -17.595522444993136, 17.427027978945652, -13.744504970717639, -20.940990287562407, -28.366758778222259, -14.223134939387252, 26.541105219794225],
                             [-0.040340658466244239, -4.6602632173485148, -3.5345353916759472, -1.1429309989414991, -1.5892137262761696, 5.5027896808912082, 7.0107960567105181, 0.5881889593443157, 10.026711700226851, -0.89562467839695326],
                             [-3.098986958443843, -0.78549378541468151, 21.858682062702407, -17.340290073560674, -5.2081350534788822, -10.656140111242424, 5.9168756570886476, 24.365162064954745, 4.9984227978002602, -3.2370886513877073],
                             [-6.4902990777633711, -16.052937403336486, 3.4054228867288892, -9.4465252952863814, -47.586344185788811, -9.383607504003562, -34.055550192440137, -12.158720352581851, -26.630481533487917, -6.3781198299749997],
                             [-0.79804737225497613, -4.1234498097552752, -39.84060985922126, 32.932126366291051, 11.891414364863111, 18.355522410651496, 9.2163506871136658, -13.405530754307259, 20.894238322840266, 11.727491421865681],
                             [-0.5040247160491127, -9.9947597788080991, -4.1305619135589975, 5.4060977645828636, -10.91861019078303, 2.5000449247429852, 1.1968210759010416, -6.9847590521557574, -11.233247555128735, -20.692731706574293],
                             [-0.27549877103335141, 11.674492943336572, -4.027167002045708, 35.880348566990349, 26.968081269891663, 17.963451317111076, 20.124812229239819, 7.505399567828519, 2.5071490439870701, 4.6584116430751283],
                             [-1.9106033923462187, -4.0327254371564925, 15.622572989420192, 8.5036147912195279, 17.520692264539761, 3.0196252250402966, 17.019730226008569, 12.700986351764131, 9.7457859542118186, 3.6500115836850449],
                             [0.77078036971743913, 3.3797087265678449, 22.995101281154195, -5.7271856033856565, 5.2609763596275503, -6.3485524384632903, -3.52187556855371, 11.992734952522053, 3.0190744807137664, 21.376255572492397],
                             [6.8170863241478994, 26.947110641357817, 12.864361868917298, 0.49764831865426995, 21.880738241853368, -0.35082195716385733, -2.0695954991483836, -6.2355052934477548, -12.751477388918603, 16.823674047896951]],
                            [[0.76509591518764575, 11.134248488723527, 3.9815895211352847, -2.2438827170666169, -6.768669824237894, -1.8886663061058939, -18.641540401581725, 4.2819172888348014, 0.25775738010278004, -1.5892116364062643],
                             [0.43949003121082697, 38.584849492608498, 40.362410180307606, 21.524419644237916, -20.933535261903508, -4.0180737273098153, -52.463383442768581, 40.368106777414411, -9.1710005610088654, -30.827851941421674],
                             [-3.096369470509317, 18.001750566273383, -7.1018409136553258, 28.090923070114332, 22.878807633786529, -11.97063938488998, 74.986730201289788, -25.929294113149762, 15.481547933322823, 7.9431024353085125],
                             [-0.23456688943391657, -1.1545013677788105, 4.5094332765039722, 8.3331306492870407, 8.3986084176237128, -4.9961102612826149, 14.278304272659243, -0.98085852507937088, 3.0264659219121244, -6.6823604621906778],
                             [5.2123229714483319, 39.011061788531556, 32.90314789682872, 37.240941177196184, -4.5923011415526593, -12.1829116447351, -5.6569338885709088, 21.349192993200582, -1.8097968628850052, -23.228443031325707],
                             [3.2692832231099556, 26.367450993036847, 20.297020786065929, 28.491864521687457, 0.71309951335456956, -10.215481820538482, 4.0576479383183113, 7.7312031356324367, 1.4876364370549331, -11.784541519220015],
                             [-1.4764749368167918, 9.3390077901233557, 4.2387566443417555, 8.7432560223585156, -2.9452795854070022, 0.82753621168728986, -8.9887237039369356, 4.278717062418985, -0.013579097531782131, -3.5379415659362392],
                             [-4.8549349484346429, -72.412302987406093, -46.898799253966615, -68.029856091459479, -2.6143039017971827, 29.475993682695893, -9.4915583103064503, -21.369079973505436, -11.527112345588117, 34.162878360901942],
                             [2.2404073491618175, -2.3920183320953923, 5.1849019911443675, -2.4571509504691589, -8.4157427008581731, 6.2956789254749648, -31.50378968129171, 11.250627204392368, -7.0546865007206447, -2.4396555057181408],
                             [1.0814929782591782, 59.685704113723325, 51.48720381659227, 46.260877378423451, -11.477690170105744, -15.638138178525656, -37.992140131763378, 35.976001650658723, -6.210348630226413, -33.506388611302107]],
                            [[-1.8880048004869563, 7.7668632649904792, -52.720122518758991, -19.980431960452322, 33.380848633933198, -72.491401747873383, 23.054822507719219, 16.836559086860376, -40.28663377990857, 42.541981308363241],
                             [127.99174937154409, 119.41281664547543, -69.038108646270842, 40.975966392151825, 8.3573408484870306, 53.290614068246235, -191.51355136752699, 21.84073880347184, -118.93188216464443, -100.93889124071823],
                             [-148.88340411433401, -96.575146289093794, -89.326158185493512, -122.05723392063555, 141.11688727328513, -252.5524090172924, 318.26654111260154, -24.678338595946208, 5.7499369157821398, 250.59073988946727],
                             [79.245873836375338, 93.990313819127209, -170.7040364283036, -4.8372197905976515, 126.62974031040163, -69.011423240927002, -78.082619407725417, 7.1944162813281993, -159.87932243826418, 1.2063725603868096],
                             [17.235481479562512, -12.812576075982026, 72.741659259515671, 22.876015748186695, -68.448075258656488, 88.968917322361165, -54.391866897940609, -21.149881118566736, 46.191420740371093, -79.299229447812863],
                             [-85.289843228548051, -47.052656782771564, -80.234315283403006, -80.174124680951195, 106.20573588859502, -177.2524159233692, 197.73447294948622, -52.540821420602818, -7.6974761891567738, 175.09178781313406],
                             [131.74597818669315, 105.36400020215588, 83.555332097526161, 123.54466864984495, -107.44088236925731, 208.63462476210913, -305.11203292087367, 31.892218823833897, -30.988383732513341, -226.9743985180902],
                             [-4.3569664357428328, 10.227160543810813, -54.033107869456771, -21.914853893224706, 35.423626167470161, -52.205983650927294, 35.503474275545031, 2.008722729798126, -15.761470601730396, 51.830311734226768],
                             [-50.225059538260943, -24.558787670769242, -1.7720114124226338, -33.525824229104948, 40.136186772102519, -88.956545720563312, 112.73610318755706, 14.576191859197372, -3.7487103087680751, 84.44886882082109],
                             [120.80099302490893, 98.48850829254323, 67.586089917204859, 94.473559808214404, -83.904589510377491, 201.41395457665729, -250.25545534918453, 37.108470729304045, -26.221318404283696, -194.62160813302248]],
                            [[321.80039188189028, -127.96743321041126, 146.20615858510811, 161.22951603670239, -445.39749425932621, -109.6196808739295, 101.6285060898557, 128.49606982878623, 549.98094667189878, 235.64225791078658],
                             [277.66386911108731, 89.037364757422196, -167.19211773811986, 66.296105438052095, 4.1005553571306512, 26.10643809547248, 20.610946867009186, 237.52812636103067, 8.1992808199483864, -104.92141416110925],
                             [518.5111366057223, 235.49674849400776, -377.41206207552091, 149.1893084099471, 184.44680533823455, -41.023047725311812, -56.951553132465783, 553.64129857144428, -82.663183295710468, -231.00406442782426],
                             [-372.26019351614707, 107.98564692770985, -32.526150124282658, -124.15349458256694, 254.72391015377025, 182.67251708784417, -16.558537057105923, -137.5288704669735, -340.81308298733279, -191.56894638578839],
                             [314.42327514037999, -217.62954929063076, 159.71087563602163, 186.51864184584855, -524.2748877066889, -118.73013563977942, 171.31805957472176, 160.25126217314141, 620.69303407880977, 218.88530341437203],
                             [-520.05196474936292, -142.5682577917903, 304.45785716751533, -74.282173006938208, -125.18610048986312, 75.888832748187454, 72.386900004269705, -348.29130290808155, 101.84567822993759, 107.2156906090474],
                             [-525.1900239626608, 150.33727545130537, 15.49953930638528, -189.93052883117019, 308.50298925635042, 252.77491726831346, -44.720232850510882, -278.11771051044354, -431.05057237584595, -188.39345157224619],
                             [108.57373072896448, 135.41662038213641, -150.40312627976647, -7.2805008984201072, 51.842076125887324, 140.16222242150869, 26.884244187733213, 84.461095675379539, -93.890032376613121, -140.6898465571779],
                             [316.83261245616893, 54.215189613328221, -101.31604568614283, 118.34477688471081, -34.439201156357129, -101.83884605214199, -27.164207980139466, 277.74267892686333, 131.21527420427853, 3.1549994113414614],
                             [664.30507713989596, 74.025761883992729, -186.19464444783156, 220.06409956271264, -326.64251040358192, 18.923244628971037, 137.19112245007523, 473.72920370997252, 411.99635003526714, -39.669836955904259]],
                            [[-50.789445725495938, -236.34514895451218, 161.2881630971261, -9.809180273393368, 316.12753280101833, -79.926541726260808, -397.67929896426932, 4.6857395090704088, -29.026559500241472, 251.73265914862827],
                             [20.769561698380866, -4.9949984268476753, -18.820714907982733, 26.882613120153806, 28.948330115277521, 15.26498821397832, -23.651149518390067, -3.605468035158784, -46.737255398540405, 0.1711224058976103],
                             [188.84010667003682, 391.93012985808872, -335.9422381695033, 30.923877441925814, -460.09382373856414, 148.20218140114747, 616.66088413483192, 13.523039203816341, 74.887833240856438, -444.97219291959891],
                             [37.487682412046759, 95.730117931945585, -53.725952934020661, 1.3736196037813859, -96.734954120864685, 26.427140318594425, 150.47589130943103, 27.077548818903356, 32.135453612039264, -74.609618300553322],
                             [-118.5971644630949, -308.15272914776904, 261.05562208727417, -55.775239680455748, 342.39693724506117, -155.38312053462067, -492.53839050257761, -48.999416531655214, 23.419845101997151, 316.01526037481301],
                             [1.0174579949490379, -118.50196873134689, 43.377272771063716, -5.5479872220181612, 117.55640460986699, -72.408023581509454, -206.96251414910174, -99.145766031549996, 18.795256271527613, 55.514598053097586],
                             [-0.73307594143600974, -56.65497047913675, 39.123601733371061, -0.50242849635293996, 90.256466115139574, -9.2365387001490404, -96.895274790181531, 11.060604489700049, -33.539325222460185, 56.921778393119311],
                             [272.6354696879248, 582.2763040164732, -438.89213345087757, 37.560383537828777, -605.96213999199063, 193.34442168741336, 909.86728089085148, 96.04464179510839, 146.3591838236938, -560.47211917548043],
                             [111.53176534379465, 136.43856771869315, -141.39920516204182, -13.905727873880437, -157.99940319237879, 23.768044535846879, 221.73838381315215, 21.011789171758355, 88.687636290911072, -190.59346105510738],
                             [446.82873195493067, 793.35245459629175, -674.83974363945049, 74.891427662235586, -838.44323602810209, 257.56452696782054, 1239.6674023293044, 86.418246753834609, 152.82189827794818, -843.61167961466708]],
                            [[-24.910894444281521, 763.67961251784538, 1019.2727531439236, -167.46596921386572, -445.99254951153137, -116.77724337224572, 393.15369954705056, -395.92931771675302, -183.50594083998612, 249.154707158576],
                             [-149.21445053184874, 180.31940405970931, 142.67381978675266, -143.47097593021303, -77.184844789869388, -30.635964547075577, -21.711425570655411, -121.02273001289352, 7.840106335261293, 81.845992418747088],
                             [-313.25619478939001, 1146.7357389572262, 1588.4765463729045, -272.04339614915284, -590.54807348792554, -213.15802721754054, 604.78335358660547, -600.43708707905671, -296.59189372728349, 301.65288009679881],
                             [186.27293558197289, -535.6789556045718, -877.79755506971185, 155.00400920213829, 349.20383252669575, 126.2167301767055, -232.71681284273342, 162.51174481198089, 188.63214238255463, -95.467272573766337],
                             [128.83621298105149, -261.54225166757777, -145.53454767654119, -39.231632158714746, 71.166725276162722, -133.62840056146095, -2.7969987637257994, 8.663306886626529, -228.74476109789993, -113.68839510477471],
                             [-276.93065089657176, 925.97031469832973, 1123.9463328031404, -45.308646593575816, -465.3315739585384, 67.580989611317889, 435.11840302625933, -414.25225267628957, 59.977166731755396, 419.85104476453506],
                             [-208.85419814293851, 413.58684793418541, 798.69607744520761, -294.2094971233991, -309.17729924732015, -245.26858993856891, 7.4341846927443846, -75.187064082898061, -283.20112171320574, -14.357935785147687],
                             [206.51347365857825, 301.11217812107913, 352.04540256312953, 78.59418433429893, -84.448021041855114, 16.185259176138004, 221.2344710222151, -115.30781970954773, -19.214746195983036, 104.79694673214993],
                             [151.25135790471441, -483.06792070807961, -562.53267780971225, 63.958238370881148, 262.11431060727301, -14.695712955831244, -188.42123199792121, 146.35310698467856, -36.838486156763523, -122.79159761679711],
                             [189.83767559411254, -653.61857753308993, -1102.5762044395237, 182.66825788780034, 428.01048616634631, 172.27962972025625, -365.77045010995255, 363.38320195541195, 301.4166451946187, -239.70099519015355]],
                            [[963.67076185577741, -1326.8421282605102, -397.37304765505314, 108.50383758216482, 566.15169515495359, 43.542140816861348, 1737.0643425487215, -67.566315598780619, 999.07108420229883, 505.35089338039126],
                             [-849.80689532623421, 1454.1201945555372, -33.562875395454398, -65.83634556387365, -437.49979788563348, 3.2485100134816509, -1293.1019233169109, -54.107597430006535, -348.59814271537601, -982.62448143787606],
                             [389.25061104164149, -725.48882013254843, -6.7007425478508793, -22.593398101926788, 115.59488544007671, -114.92151284665518, 453.20815780364239, -60.201244022709787, 54.870787756003125, 366.62936090237758],
                             [-603.82730880819395, 694.12216256483748, 221.14191583706986, -69.807550959319883, -353.52531452820369, 6.7947827598378741, -1021.014653880037, 35.075402440923767, -487.54380576993981, -293.88181672972775],
                             [-976.84287499906213, 1171.1986429312888, 397.49791233718321, -123.96584406658849, -628.21058573299285, -58.653076252430651, -1780.5927972784814, 32.670636235390042, -980.86034706166288, -473.92943150877932],
                             [250.4265220144614, -486.94648841434605, -428.58490024476885, -121.2778719291383, -78.088853207150066, -221.04036277505747, 463.20025918998385, -315.75999399819165, 497.85924514311489, -401.99760110712975],
                             [-254.90509712717105, 77.552998068184536, 347.48122606137804, -44.100082865998459, -142.72926293225589, -4.1755782877859531, -486.15849715813545, 124.94393823077954, -469.36544957845069, 264.52786301876301],
                             [114.24429381718464, 145.36210928748048, 36.555807432338291, 211.47368271620596, 351.59602897771771, 327.25591827658877, 443.39763879877114, 247.85973192375764, 306.54322158676138, 303.0074426832204],
                             [-250.53561485887138, 832.2801566474584, 15.450546694145689, 204.14411219867631, 331.08760638274629, 484.46573721844635, 195.54609137550415, 333.63019263277641, 429.29628524287966, -91.688984255871631],
                             [411.57527584547358, -291.14686203264864, 52.416250439900367, 127.3574428964196, 373.87687097865455, 110.09418590983071, 606.45949023527305, 130.8140506599286, 99.788181249429101, 448.45060255324165]]])

    matrices30D = np.array([[[-1.5033843602497823, -1.4851368425641187, -0.37194311334831615, -0.98546903426416776, 0.62426742056705531, -1.1578073961717728, 0.65206216429078245, -1.0439205545628121, 0.44602092143831285, 0.58341535646088283, 1.2930957963960099, 0.18517932206910517, -0.10672710467322863, 0.47814819187659025, -0.76989952256817817, -0.4799243949311584, -1.2447188029247036, -0.40810835875413848, 0.28929783271489512, 0.10066665004194125, 1.1064439743932037, 0.22352928023179675, -0.60877440653949877, 0.41561387721692106, 0.59621476977707921, 0.7482366320206103, 0.19090977694311342, -0.29761816608467295, 0.69598305612423061, 0.0055969300264300612],
                             [0.12364115562088066, 0.62829751696136449, 0.28566382616918412, -0.34540121219862641, -0.11926090625041014, 0.005545213808651573, -0.01152504085074214, -0.3244426945754797, 0.70993294490277603, -0.18760726510502046, 0.52662923659453131, -1.370633099755785, 1.5820530199005678, -0.7864885379015879, -0.77059679593150376, -1.0229641887585357, -0.056671310132415935, -0.34371876295422643, -0.54963400743831048, -0.75741979994118158, 0.0094994903955315929, -0.87029298941636979, -0.51037377245060334, 0.034620314159728632, -0.24227316411154612, -1.1246468733920065, -0.17615109928218253, 0.10213786006469808, -1.753420121228318, -0.11980360633157514],
                             [-1.2336319305981196, -0.58357814257920726, -0.87393539698710376, 0.97507949663160476, -1.3288602180181055, 1.576929193913672, 1.4700916869560081, 0.42228893552543423, -1.5797310632076333, -0.48008776967611183, 1.1186684395289637, 0.52374646862431073, -1.3034009588882776, -0.12674846213866317, -0.0087265550828670418, -1.6472754668345571, -0.32553485306792546, -0.57974143366869513, -1.5412384080972794, -1.1513503372425344, -0.52281762120102104, -1.6796109970520543, -0.019815460414923658, 1.5318088780249473, -1.4750741284170679, 0.63219567273694655, 1.9079379657625646, -0.94783034262347565, 0.23852115031292451, 0.67046190738924216],
                             [0.1837626902227647, -0.55115992748753939, 0.73388535357397955, 0.66294870132854955, 0.7659775650092624, 0.91474272198630424, -0.62740562010674594, -0.37736282946790367, 0.62771947475411194, 1.2095302828763788, -0.35859372664305988, -1.2560636700734047, 1.0866151691402541, 0.23778254641764771, -0.201864231392685, -0.23569572158423194, 0.22261358308555182, 1.1607637747064865, 0.9686129192420061, 1.0368800331535923, -0.37816297076916855, -1.2501034915540463, 1.074708449858899, -0.83244872263355352, 0.22411832360369538, -0.39189176476900756, 1.1080235862439758, -1.3793090408308732, 0.12873946129584729, -0.086324226514807464],
                             [1.8380789761866505, -0.088295486856703992, 1.7073660724959581, -0.37549357087038293, 0.31816520319824498, -0.97266415715524435, 0.4445175912522662, 1.6115152090006284, 2.3735079111120476, 0.75260158874695116, -0.10421889225302862, 0.066399341085255068, 0.87566153980840522, 0.84668827492338317, -0.65039567237626894, 1.1105761864623669, 0.10367081675304585, -0.44945124877843023, -0.18423864089229003, 0.98247189987538297, -0.60028391707218276, 1.4455705368755691, 1.6005810381380241, -0.65389692225380813, 0.75912804155260882, 0.0905983897242571, 0.25499576211169611, 0.7642754441551457, -0.98441666503503367, -1.2008478258598476],
                             [0.19854769193354577, -0.55963223052237232, 0.58819956750580893, 0.38730628734631856, -1.5061120725770702, 0.30374892427956562, 0.42161720573445033, -1.558263843783998, -0.66615641194392394, -0.25012169134855444, -1.4670221020924741, -0.65000298557484537, -0.43413583830767832, -0.50490762432308567, -0.16591459865091204, 0.26445415946459472, 0.25947588808024219, -1.1937814523467389, 1.6601260028473495, -0.9274464305544301, 0.033912904083051851, 1.5167909992110544, -1.054563480023051, -0.80875413652672301, -1.6369758861229411, -1.5127197735850326, 0.37777332118327445, 1.5656899440440897, -0.7059519372303219, -0.2858339039251277],
                             [-0.44778686385482275, 0.38170052011369043, -0.90930500167982931, -0.32046985566153996, 1.3459232516076718, -0.19054812278432581, -0.045362448908691871, 0.49155353664292567, -0.62334125656040318, -0.39404626163127454, 0.91668410659614452, -1.8313047095341237, 0.34553382394433413, 0.95128675984589972, -0.048267497701935912, -2.6585880022352759, 1.1158153038290557, -0.77455308687772051, 0.50773621735671792, 0.53680868881029442, -0.57128655333533951, -0.57708359009222221, -0.20225435183976245, -1.1918951152827997, 1.1611108542662125, -0.65536112333767638, -0.7838108665667064, -0.47271356961692179, -1.3627762778613461, -0.61459749551600273],
                             [-1.0206398315510765, 0.14176314279665883, 0.64158791050173225, 0.7672741976885542, 0.74964621157642397, 1.5668156729920681, 1.1180158662109247, 1.1759381477302446, -0.90492228393347729, 0.30881582193129464, 0.31847639849101017, 0.61893564908723131, 1.5007716600604657, 1.3879847486554535, -0.28817328883470944, -0.077841821840246309, 0.45062976322488285, 0.40066042019163856, -0.16755969977905674, -0.28982529722981437, 0.017182460451776457, -1.1180045455715166, 2.1886365747897027, -0.46013627044393629, -0.018648024967894455, 0.92682405611548402, 0.52135729146272602, 0.92519651615763498, -0.2315557213548447, 0.89847349137786525],
                             [0.092563059473493955, 0.11374077293222212, -0.39690450457575188, 1.4942627671899664, 0.98020699014795942, -0.77342885092470492, -0.58594598164215594, -0.18539540241927371, 0.30812262254589146, -1.4705079694591463, -0.035780621001429869, -1.5088431283344284, -0.24676420797618284, 0.81560360267257337, 1.7075916838689138, -0.29254530689269831, 1.3231349829150492, -1.3317149400807187, -0.92382751307307964, 1.0976618285309618, -0.67626869730044004, -2.124088384534276, 0.7693868687200498, -0.46985488622803001, 0.70389383980635445, -1.0159211845923799, -0.8554575298524586, -1.5139126991433716, 0.52277688647908416, -1.033143284128107],
                             [-1.1417386156104281, -1.505400865735689, -0.53298709869533756, -0.17244111589132682, 0.77672979053491698, 0.10613726140855419, -0.77574016833539905, -3.6043551154204754, 2.2322588132341532, 1.2139167201286707, 1.5491215364046436, -0.39843223634811414, -0.16451155752398322, 0.2697570054094493, -0.11304127991491732, -1.5363725422447339, -0.13009003118705648, 0.083191261458809895, 0.98866722251386252, 1.3434853656323653, 2.7288428152185706, -0.22265601853662867, 0.77573978658069409, 1.1366953644074134, 0.12841344771115953, -0.073180169739790094, -1.2067265522527018, 0.74788534762567149, 1.0157574782385546, -0.21300298282587302],
                             [-0.44260448598885027, -1.0564830187899226, 0.068820159208346735, 1.0365027769468547, -1.8228425073373691, 0.37138063120836046, -1.8412495285735571, 1.0551139515740044, -0.37581066451005279, -0.76883841184968083, -0.29807034926356801, 0.28519747643955184, -1.9215015124360331, 0.23826282090078274, 1.0364315286403605, 1.6724225250931484, 1.0950668730728732, -0.20399485947819751, 0.68866518178072822, 0.81817185516720448, -0.0027614653363793491, 0.29597616866247128, -0.9797290816103611, 1.1781491483678543, -1.3768772175509587, -0.76706168901831639, 0.22718472931126382, -0.1336349917337534, -0.074057549119822499, -1.8647333176269543],
                             [-1.2577275192028505, 0.74049983890847493, -0.60491006913956569, -0.3293501351969888, -1.8108397387353687, 1.8825380702004009, 0.74062748437819925, -0.13151342159397994, -1.3514033835095189, -0.56346850383232105, 0.59122443607770536, 1.7412832478001894, -0.23522190938270929, -1.3106662783442913, 0.22914393078476464, 0.42964427097504709, -0.31202338087247017, -0.33208109524445917, 0.022653791299477258, -0.87354841250413306, 0.33586369995941256, -1.1447453554630229, 0.15081376254637344, -0.45615164329852637, -1.0756147226743304, -0.48767452150408885, 0.48979214166658069, 0.051553858481122233, -1.3689046483135572, 0.11333768073145283],
                             [0.52875573371042228, -0.11018383488243799, -0.14995994531354939, 0.54872577819249757, 0.73068182748535981, -0.92836053026539445, -2.3581146684046548, 0.10597408586941198, 1.1213180333640316, -0.69776329926922165, -0.42211462332108951, -0.4762883310300442, -1.5538313335714946, -0.12785013763758143, -0.26680278245601236, 1.0897529717444701, 0.23344540233966624, -0.80881746222626072, 0.045190278152527345, 1.0010001730889355, 0.18544307835480758, -0.026978807741565296, 0.017316005715045886, 1.5544586780446727, -0.38371816152110622, 1.0863860667229914, -1.6397400685946073, -1.8907371179392194, 0.087402206587366471, 0.064671331084669839],
                             [-1.1692032998410258, -0.57932486089554758, 0.83272791926628809, -0.36999890803071639, 0.63934850395347542, 2.0592587850895083, 1.0370023676547377, -1.1331703084770965, 0.31425646564464949, 0.85386772166480851, -0.28429112082558244, 1.7475822198963678, -0.82951959554877974, 0.01305070007963117, -0.26766055484421064, -0.97418771777988933, 0.17958776211529126, -0.43655968207259138, 0.33480252980500708, -0.86942628001850697, -1.3541412840679277, -0.15128158625317584, 0.97924647122731057, -2.1789261959101749, 0.9938321924504242, 0.41763800454262073, 0.16255480691013288, 1.4071287616015364, -0.22757719120927294, 0.10816119940331891],
                             [-0.19321984838032336, 0.15732258355339357, -1.7299135940943879, 0.65578391976213124, 0.8336252886616653, -1.0638889053366281, -0.30259957683669014, -1.0721157456991428, 0.60213602080650308, -0.23637957677820373, 0.010349947062951548, -0.0049796744634588129, 0.41503456776626357, 0.29632758190481245, -0.77431536463507056, -0.82149966416251474, -0.29466133200976397, -1.1334158881850267, 1.0371318280403101, 0.2222353032435293, -0.63551999518898161, -1.6235105845697049, -0.054021909767973476, 2.4638551767620505, 0.041368638029640983, -1.00424490704295, 0.10351894602278815, 0.14894440029089043, -2.3035111845098806, -0.34752556546225305],
                             [-0.33186696898257823, -1.4379377202950732, -0.76294723192974434, 1.2705513212815192, -0.10969089052577065, 0.87225593969925019, 0.54082712189749649, 0.94661669681950011, 0.20675694774444583, -0.057062404845590171, -0.58382769591280104, -1.0243726273018023, 1.2711663641939752, 0.85831310601090605, 1.2586722137478601, 0.46965941067576256, 0.14523758777627976, -0.25614149793509539, 0.3248228856779154, 0.062092150062727371, 0.43719753521640337, -0.64169184505161725, -1.0530032658006963, -0.13664036115600281, -1.2562998982332403, -0.40040835034003941, 2.584443451343533, -0.66008766409685959, 0.058317737226552258, -0.4597549003971716],
                             [-0.54059104642372546, -0.50856046922611475, -0.75887329050699004, 0.51508355236680092, 0.85129219617661755, -1.5201934446173861, 0.91752400647761978, 2.691289854151472, -0.41697261725134971, 0.53920210532525281, 1.0791251213084891, -0.57940269258407451, 1.1576273753309763, 0.53274002754566308, -1.0211712122744694, -1.9057303535282051, 1.2945351195165418, -0.34160560591455852, 0.33633147570731114, -0.25835591231416283, -1.4672244625010369, 1.5166141630162846, 0.24167843932692165, 0.14574693465666802, 0.85838308725943224, 0.18190016892883185, 0.47646290753691384, -0.86849762964094979, 2.309150313641378, 1.1717041907492076],
                             [-0.059127345178084073, 0.78081897255098087, -1.0242888279096933, 2.6262754257790197, -0.69219023407278413, 1.186930911909436, -0.54658240247251588, -1.3382872824314853, 0.53963225218454602, -0.67690335664301093, 0.72449397813527527, 0.083922115469037009, -0.015544615034082079, 0.89348541049614028, 1.4738708039870678, -0.33920657496891032, 0.1362828702922057, -1.8247521873930068, 1.2229420933385722, 0.12426229273002946, -0.53059288586594489, -0.33363764503557536, 0.87409263103944324, -0.34909862817071424, -0.12467368820912111, -0.83052215929431628, -3.2400430593124878, 0.22699164707494479, -0.82038736775718302, -1.0196408088166471],
                             [-0.23594571329492231, -0.63211706310567206, 0.087010266461942293, 0.62851251641715167, 1.0513062293630369, -1.234254139277809, -0.63025038032540714, -0.12381875137002918, -0.34534312252701843, -3.9295618770941299, -1.8625106986077131, 1.3389771058711821, 0.093958475134411246, 0.040460365972689712, -0.75638976629833843, 1.6527047637198953, -1.1429955327272823, 1.7370676783238008, -1.3982488317362141, 0.68291908097081278, 1.1676509043786831, 0.32457893279768341, 0.82112313150955207, -0.27573700080989516, 0.44131581265262243, 0.99197112730022552, 1.4276097100820275, 1.5412419282938448, -0.11986918596760929, 0.75865911863573698],
                             [-0.61876921899078463, 1.0420455839002867, 0.17561025278687017, -0.84396135440270625, -2.0536719692761638, 0.040966283360305, -0.35847239615393173, -1.292240653313693, 0.14834825031702936, -0.66134402783895729, -0.39881540566267087, -0.46493166763265642, -0.16442164904119902, 0.57379988244460567, 0.19420721635508553, 0.51196585849641063, 0.73066041627547351, 0.060456513195725585, 2.0381002454651789, -0.31837629961732272, -0.40616834389468981, -1.0107459183859822, -0.59560312998954068, -1.2982364202901933, -0.24970219387080456, -0.43138628902580534, 0.17105986406627566, -0.13293352401289571, -0.8373243490865826, 1.6810714161824103],
                             [-1.3814378933489753, -1.2402600882407608, 0.34859004954535677, 1.2568513269684787, 0.19378117679217433, 1.8389647958819255, -0.81570587981057785, -0.45865434932584154, -0.15905639293147111, 0.5496831741101309, -0.30984194453315367, 0.46824913718698619, 0.12570916471517182, 0.27339797516886649, 1.2896455658315809, 2.393797705250909, 0.68198589235678497, 0.13882907967587754, 1.296306251950381, 1.4968949398126781, 1.4721549824043765, 0.00076251268697879321, 0.52139682110171248, -0.78574717899258162, 1.3451035253425725, 0.9000594714106348, 0.6552194586388187, -0.63494762012523864, 0.81526787965898928, -0.68112395430396189],
                             [-0.67542588326404485, 0.98835684347811803, -0.64543554305853623, -0.66174915367258424, 0.78411864562187239, 1.3361306178953087, 0.4368915846782116, -1.3020222079437338, 0.86347799370407829, 1.5474472267666171, 1.2348112081670755, -1.1444068233446658, -0.070559910631381839, -2.1847811198829232, -0.36978318882825501, 0.35088245650778949, -1.8506090403016326, 0.2897118386657016, 1.67243074105709, -1.5509653495243754, 2.7266658505597166, 0.85737597176506841, -1.3394959926660905, 0.02227485603053363, -0.77118282664345406, -0.83976873174274069, 0.15340093892074574, -0.1550307357440025, 0.031887201732543419, -1.2945698500444753],
                             [0.83001998165594648, -0.54211964580676408, -1.8233657504318155, 1.0203743936963727, -1.2424360255700173, -0.22729695484475748, 0.092785072043989586, 0.069663385929937399, 0.18799723026769932, 2.6882074099240487, 1.6664149051333663, -0.50883144770651023, 0.28227913817252487, 0.51185602006297315, 0.096075500828062099, -0.020948929704877571, 1.2674457352243209, -0.010233281787092024, -1.6379819099686765, -0.50796607471745236, -0.40598696869130219, 1.187530984587249, 0.8145594255220111, 1.3861356633953519, -1.8632521874054373, 0.61656617482525211, 0.00043151877702359009, -0.90192104490527591, 1.8954115473737878, 0.66256757190652849],
                             [1.0675925078304496, 0.5504945931879105, -0.07381318267321843, -0.21453421870910952, 0.15645478567212343, 0.26705801383350219, 0.58096173954174113, 0.1129596296833283, 1.0193540102133938, 0.5255749844244354, -0.047622151017025563, -1.8041804028409847, 1.621409245623602, -0.56317214346445432, 1.9743471241311672, 2.6906910390728314, -1.8909912067632617, -0.33699425846110664, -0.0562232964814013, -0.70504421899594039, 1.3397005569481839, -2.643615499125711, 2.1565491562694548, 0.67713022008304102, 0.33965218346440373, 0.78392033493467839, 0.66468132215973275, -1.6377208568915531, -0.57342577055391575, -1.577504001219316],
                             [-0.34888717088563675, -0.904644937816518, -1.0538592424163244, 0.69737316694217311, -0.63516415930300185, 0.896554190709139, 0.41737397391190201, -0.19416980790102911, 0.35149997270863204, -0.034099714206295678, 0.2012242561397718, -0.46139226380457454, 0.15248962667690169, 0.74643438657151662, -0.53041596955008741, -0.81785027985674641, 0.11543204793388134, 0.084305696978960981, -2.3874817150537333, -0.16150456683532008, -0.25683947124116591, -1.7102502345957931, 1.5588385863872385, -0.93538364464353851, 0.10438585861693103, 0.82316166467352025, 0.48542184352834467, 1.3282815449953742, 1.0245174199668587, 2.1161598613499741],
                             [-1.3702382053876063, -1.5684024152259102, -0.11897792713576134, 0.81627171691995093, 0.57140408156588463, -0.1730761832772551, 1.3851517692767013, 1.3063291791560567, -0.79157792130207305, 0.11780278898062213, 0.0090478279123896912, -2.0342981483946065, 0.52417804281788938, 0.63606037619326883, 2.054988802608289, 0.59343056366280911, 0.6141157656956332, -0.35637285276056813, 0.74475719402149454, 0.67702849615534377, -0.85418562823130251, 2.0593126178138998, 0.4592663868401104, -1.5398387007506489, 1.4742519901400832, 0.40118404673577074, -0.65575458035903467, -0.77860724366409406, 1.743080217045184, 0.68762459710091506],
                             [0.38469920339656072, 1.6460239924219415, -1.1574827729696398, -0.75557110436017738, 0.27963388299221487, -1.0782793240651765, 2.1573851919809988, 0.23107193750996846, -0.077288098111473733, 1.1818192075517076, -0.96437427025528155, -0.97364941034227592, 0.78953768002845404, -0.64567217259051546, -0.55153989568257444, -0.14130498536830824, -0.52937696381603394, -0.27190897960163329, 0.33269801781016634, -0.6573949224952419, -0.22065576072676149, 1.1475188701889645, -0.66340022426368939, 0.5405828503942246, 0.39846213128639196, -0.066231589898115867, -1.1705396475124124, -0.80862459985780488, 0.61004822252568225, -0.98469904508973105],
                             [-1.6546722621662955, -0.83523837505796739, -0.91340080675968649, 0.32326487654632097, 1.0467682391017972, -0.1051969420385751, 1.5194097462598486, -0.92785387314328405, 0.38241082051696695, -0.015959720825526505, 1.7499203179368501, -0.1705986894635721, -0.30998246589490774, -0.39550806354632423, 0.72001077319824414, -0.64897096333512749, 0.058260594864163129, 0.19066629126823376, -0.85143169470150148, -0.26105686778024428, 1.1742465366299388, -2.0491421686597411, 0.58268118743006403, -1.033109995859252, 0.69901692167796792, 0.69050348548545182, -0.68645304980211219, 0.49946784191169546, -0.47316963394778283, -0.47764857453637338],
                             [0.48168567660264483, -1.5154127276319835, -0.49175340752322616, 1.4185812638548254, -0.19599413166363119, 0.85935106979672726, -1.4010325311892349, -0.85730836513038122, -0.78273285105861501, -1.1861346101458128, -0.4873977846121848, 0.068177903569993065, -0.3976747122587308, 0.52084666806698321, -0.46892598325974105, 0.0075803845182534149, 1.5466042130262876, -0.062130071588465237, 1.3070258202585483, 1.0534788536287578, -1.5579473469800369, 0.17915479599312448, -1.6041099385926609, 0.73733364765138221, -1.4187742940589472, -0.85641986708509765, -0.006662960246774971, -0.031339614495851889, 0.83781039462409657, -0.35404699917193644],
                             [0.28508702813436521, -0.39725698935550086, 0.030799684187972874, 0.037696255952448028, -1.3923417900326656, 1.8662851214886651, 1.1111087443628616, 0.053300148780113125, -0.93612622732708839, 0.71310680508923818, -0.26953423995943582, 0.36452464247778688, 1.4536774256555156, 1.4378513246324152, -0.65594360068690216, 1.7426593043018392, 0.046434458910808898, 0.25700795404453119, 2.3502327628245392, -1.6552253427669303, 0.49575237956658447, -0.11308782674461317, 0.84898399402344715, -0.53479896448255959, 0.56369255695515941, -0.74378324012815189, 0.0015564488670770024, 0.30993093956710988, -1.9251668513237339, 1.6985648163519576]],
                            [[-0.98959297683882674, -0.27760064966080089, -2.4612450433355604, -0.63971514138082619, 0.99843816368333538, 2.4538864331174994, 0.24189623919644071, 2.7916294931071577, 1.4419143108278472, -1.3175990403749787, -2.6384682942201234, -0.48843216413103507, 3.124269670523474, -1.0687351620718726, -0.75940686899878052, 1.2896297217894184, 0.098397055525195898, 3.173916714674645, -0.50657632979418465, -2.1548041502999808, -2.911716285199677, -0.67895644475071171, 1.8797961823775509, -2.4514769483209706, 0.6125576810838691, 3.1540571534753972, -0.97905394367328813, -1.5122015594977201, 1.3289228032911318, 1.4647618774818916],
                             [-0.23551059162777688, 1.5277928762562865, 1.607129119859749, 1.193465702966334, -0.61954372797680435, 2.4195731675460861, -0.50440304115324819, 2.1996231487813125, 0.93427141697586491, -1.3272085912895388, 0.99303862123959996, -1.2729397314129867, -0.26715734387398826, 0.6125674168031261, 0.088936389889770401, 0.31542636126616458, -1.3836050495091241, -1.2619432446725432, 0.43025546158835165, 0.10931955059452043, 0.53652121368408989, 0.25149862209651624, 0.66825758257374446, 0.21978711384483871, 1.2579423859329646, 1.8932505783256204, 1.1029638155660375, 0.28351158460402104, 0.3368461600570844, -2.0775358214189694],
                             [-1.3841927892040287, -0.6049942018327088, -0.67855024267407504, -1.2582066568373527, 0.54481856037309417, 1.1094929620212786, 2.6099755672771003, -1.3824920314099729, 2.1836840061508358, -0.48576010116319407, -2.249587710554001, 0.94883867796277932, 1.526382920129288, -0.82813564726294275, -1.1154128232822815, 2.1128923158584847, -2.8622210353610367, 4.3662604316448501, -1.1083952255612128, -0.25684311257092635, 0.71267570880191489, -0.24806973979202518, 1.0583337780106183, -2.1090267308048962, -3.1505952228032266, 0.62631036787459626, -0.91544068012443158, -1.0731633884507534, 0.29028486323398517, 2.5884022581921897],
                             [-3.2472334375670262, 1.9946683852094751, 0.43586844657600282, -0.034840745600816805, 3.3440755779314788, -2.2700106523374384, -1.355584596628324, 0.67637486259339941, 3.3902620476028091, 0.94916569834663855, 0.69543495053689819, 1.0975118695667569, -0.34203249474130276, 0.7218769155332182, -0.96395645203677871, -0.13049670617431447, 2.4986727466297696, -0.73663815071075245, 0.50921605419584159, 1.4960585016803418, 0.065445494128789777, 1.8207387498007279, 1.7141988104267343, 1.0498878635910738, 2.0588550423892498, 1.9118044550872848, 2.3512159833747233, 0.44041891050031279, -1.2347135245923155, -0.97801615892856841],
                             [1.3203507748643533, 1.2270489229807908, -1.1807414323968104, 0.19040025731075477, -1.1238285688360483, -1.0634953113522803, -0.89103488681784593, 2.1548530216898145, 0.32955090851937741, -1.2343557511501297, -1.4360395177665768, -2.1561329523267974, 0.40453975695514843, 0.95901332391966032, -0.5342054301637692, -1.0410492802769891, -3.6699024316190001, -1.2886270753757747, -0.25283436770106804, -0.79044777179200365, -1.5539152002817125, -2.3400903787892342, -0.086993717664318737, -2.388318430244166, -0.23784271896970782, 2.958441853475152, -3.3442278211187997, 0.37017263747236212, 3.660851226654696, 0.29630792059730288],
                             [-3.7710672212309317, -0.6940062014779238, -1.2863856061613061, -0.62381003479594799, 0.35914058301590202, 1.1156197509798358, 0.78068445763843997, 4.0561709724399391, 3.7329346614850709, -2.2614097850452075, -2.199495499525951, 0.85978687752538474, 3.4999054167954391, -0.79036189096723453, -1.7417559434405627, 2.1881940345654987, -0.086675267698052894, 2.7022010105008274, 1.3838930773793341, -0.65931206056491343, 0.15242731504681295, -1.8718746483919024, 1.407814178594184, 0.8547987968884323, -0.47128599905106228, -1.9324798184197962, 1.3715919235505609, -0.097643602265960361, 1.3765552313309324, 0.48999270204986706],
                             [0.95610027094356698, -1.5148650771561842, -2.8417737804894969, -2.9281111265783761, 1.3737503368556732, -0.16898533909231964, 3.0258964908453185, 3.6649718552124781, -2.4683342401496362, 0.16477404052963829, 0.011952368070390684, -1.7078418476249226, -1.4995362947795012, 2.5111489657165595, 1.4807304817696192, 0.32722601396453987, -1.6115199230019674, -1.9377068480485915, -0.32226970395935484, 3.0196018836970158, -0.59050594224567754, 1.1045537027362262, -1.860035333536461, 0.87794535803128926, 1.300284315339121, 0.36747722789874615, 0.96638493654462387, -0.02679546250202014, -2.2279759458768531, -1.3607299172416041],
                             [-1.1643868285692607, -2.7153851422809612, 0.53131229283005932, 0.11258900693703022, 0.12425362666538692, 2.5912383526717617, -1.1226717729387221, 1.6192327423214596, -1.1385261524682235, -0.24369928981019967, 0.69321531665074432, -0.61093715717246289, 2.2753555591933954, -1.98668571883496, 1.715146184635314, -0.72418607761788523, -1.8823786982956592, 1.5548071799149334, -4.3285528422565873, 0.65222188925469837, 0.45811531421640828, 0.29816579709847563, 2.0381758347459478, 0.94188717129746768, -1.459950625287477, -2.0450041770896719, -2.4492011396779989, 1.3239079150164683, -2.6359271711341008, 0.81636534285813422],
                             [1.0407450116013095, -0.27013855090397043, -1.9715736363359306, 0.29453267224530022, 1.3101594643468499, -0.48766375647891641, 2.0923662428137511, -2.7925229500970978, 0.72081503994372387, 0.88138906084151025, -2.1025268510114445, 0.20373515386199387, 0.38171113919221178, 2.2362780165637486, -1.2516973185288978, 0.20138897191630453, 2.3909398979871659, 0.1127943431046781, 0.28687869849300551, 2.0503250834961584, 1.1881675990165383, 2.6591206779668717, -0.83143777393015184, 0.70508492597855899, -2.7603030943895273, -1.0546265091964873, -2.0284123577106854, -1.5150414347232679, -2.8797215721446783, 0.89326185182434203],
                             [3.4327927004642911, -1.284422286196655, -2.2539892599680664, -2.4254382538931543, -0.46960904366756867, -1.3391873349740691, -2.15322577337805, -2.6062639652642932, 0.94161818428958199, 1.1207622597231763, -1.1513920118914804, -0.34712079343742736, -0.62862775374114044, 0.99348999947044436, 2.1339583358296697, 0.36372656549528792, 4.0736998925648944, 1.6550642642893743, -0.36850375380016104, 0.020588876108250862, -3.0111745197554916, -0.49741041139888637, 2.1823385518227392, -0.0016806857609042525, 3.1739336109317051, -1.0554113640276226, -2.0610953066129261, -2.6534077951789166, 0.26041889563098136, 2.1992794502518347],
                             [0.041453331143539773, 0.453119601606496, -0.49313783493981223, 0.94374987714030867, 1.0640393909972363, -1.2857594466800994, -0.6332593520147547, -0.79223828586639933, 2.4401790608650211, 0.63870755649807887, 0.19235553828729912, 0.51467030170350037, 0.0063783867332390942, 2.1737877075451415, -0.078451247863359219, 0.96295859093152858, 1.2915490868962543, 3.5755312860361586, 0.68171028143060342, -0.024197513705124046, -2.5377882681454218, -1.8627299171681266, -1.1757965896974854, 3.5055546413111389, -0.62031016007531181, -3.5800066326476419, -0.74369779517935197, 1.5774086967670518, 0.098931293452147046, -1.4466148084909438],
                             [-0.60412199798361044, -0.091546249704393956, 0.43840417218442185, -0.82107767390794273, 0.27028369881113234, -1.0496523813470149, -0.431806863479539, -0.52475611847986148, -0.8258235647754204, -0.83229952041372746, -0.068902810952895743, 1.6350836036052505, -1.6605327742014728, 1.3077403386325226, -0.60528229270601608, -0.041161767646618219, 2.5820077952142251, -0.28847757518848133, 1.0828944102495279, 1.1275514686275412, 1.2872416296690321, 0.83403144839298005, -0.37808057711850751, 1.5652449996925211, -0.096991286614627081, -2.3410010202374356, -1.4072747135972801, 1.3993577216859614, -2.0997619654241517, -0.82193377938628975],
                             [1.9001668207400741, 3.0167027207598851, -1.2587919837896278, 0.096108601389619602, -1.7128496756291018, -2.2933554018994049, 1.5858410498975848, 2.2266963302654599, -1.540837051155783, -0.98248047762000867, -1.5658279551728955, -1.1278844383265865, -0.024408521242676479, 2.2385548366479648, -1.7226101068613422, 1.384916217210107, -0.81898045790888274, -0.081837850031814485, 1.0734301631444787, -0.043175498521157832, 1.5768098751530171, -1.4710974051125016, -1.5166689753283142, -0.81568568851707046, 0.85155562869227486, 0.45952673047238124, -0.8443417748527744, -2.0386996329043576, -0.66079941773568229, -1.6155171027024813],
                             [3.7054972938134543, -2.499655344866988, 0.32362664568497546, -2.640895550785777, -1.4832578367568916, -1.0777649630808144, 1.4696658053712817, -0.079562846292974276, -2.5681570538690419, -2.2931164847806529, 5.1505688758832786, -2.1166795117704935, -1.673214164818162, -1.2102278834665947, 3.7114575673833623, -2.4596599605612388, -2.7671581147371689, -2.4520812635262375, -1.9244781096651336, -0.13513331708676729, -2.0179512684919212, -2.9375740045414362, -1.0413565312422333, -0.39094784825194573, 0.3051339121798986, -2.1203440190842637, 1.3440625577826495, 0.44771383855311048, 1.0451518599369014, -0.055557265443225035],
                             [1.9006762985331052, 0.90259651748007974, 0.48904103047052988, 0.40817438594757549, -1.440008880969998, -0.9784836935845459, -3.0544732711497051, -2.0426974849397603, -0.41795880408306424, -0.38523784655986676, -0.23294251702718149, -2.5046053986300052, -0.97698186244092211, -0.29754553619784363, 1.7181477447126519, 1.2628120169106034, 1.5197321493143334, -0.022036689996274172, 0.017861421159132869, -2.332216500626159, -0.18819897903404098, -1.9564383416614137, 0.6298114493871203, -0.023706753582141415, 1.2310361418615627, -1.2892693866616769, 1.8436145590674169, -0.096741460589594985, -0.58632775929759173, 0.98709543258013621],
                             [-3.9274498878212913, -1.0154645601536079, -2.3391229293375728, -0.92284716072426154, -0.25498734372902188, -2.6575260174182671, -1.5054014246153367, 1.2021159814925584, 4.8278221353933022, -0.029955754336581021, -1.608579545163153, -0.010027455125121709, -0.34221957888548493, -0.43029147159720593, -1.4337556822655793, 3.9062603328513505, 1.2096784715659019, 3.3597669793859373, 1.5712409623208594, -1.036522758537237, -0.94910743491751859, -3.1212960105784613, 1.0745367602058216, 1.6271112370072247, 0.64758786630832743, 0.80239361720224234, -0.93703375588842275, 0.60445336691447582, 0.094129720899061908, 0.48016912195979161],
                             [1.1145649448743358, -1.0122181045243086, 2.5699147617237426, 3.0420273698209024, -3.8393720800627684, -3.3230167764155683, -2.1101834066336576, -1.2316779398551629, -0.82666349824360452, -1.4956368924337025, 1.2392489737558989, -0.59494641360281308, -2.991762127120313, -0.6684782205105505, -1.1286977476214748, -0.70694335289091204, 1.6123660158758979, 1.4683227432642554, 2.5225028128021281, -1.4660402825747851, 0.97833477043507844, -2.6859906323303502, -0.97444988167924684, 0.20374814542225878, -0.97709367155924332, -1.6135442562616569, 0.5835430663333131, -1.4646671226811205, 3.193162348957892, -0.91806933505130117],
                             [0.58180935353272967, -1.4798408191699655, -2.2655350568554917, -3.0145822694914193, 1.7797035463462563, 0.030809334617912354, 0.79433443476031951, -0.66687674713998346, -0.35974649119142077, 0.69186738759406063, 1.5425097967695636, -3.0997085842258616, 0.31712184766264118, 0.73112006795567108, 3.2386057253606455, -1.3207977484626516, -0.61398119824108743, -2.8094521906375514, 0.9333203011030119, 0.90079702746156598, -0.39964847661827452, 0.80049392848434064, -0.76383634868735317, -1.6247927295489855, 1.0945867995856431, 3.8245417118383078, -0.48590214781365171, -2.0128586553762595, 1.6430630658641046, 1.0728532024473247],
                             [1.3787771947260283, -0.0041226172109373113, -0.27732594384881509, -0.57462871753581957, -2.2068287568774796, -0.42441337537631868, 0.86286708637621912, -0.37324741492761482, 0.51382109283062338, 0.77630781978605612, -2.8098054966686461, 0.68852489662205907, -0.49476134733560545, -0.89173429609338684, -2.9938982080924919, -0.87844792966969509, 1.6935195297438383, -0.4011718091222829, 2.8218544457709847, -0.029267836764752496, 2.068671836681339, 1.1356999885564563, -2.476568097920163, -0.99394757597313399, -0.19422621409218488, -0.024414168885487288, -0.62115144266088573, -2.0646097232193061, 2.6580214477600128, 0.04161957668185292],
                             [1.5633549922904326, -0.35243074474303182, 2.2590869373531373, -1.7733499449254113, 0.64008032478076138, 0.75735680286792173, -0.87959201535902209, -2.5612697875066801, 0.84680534171785293, 1.4680726583481201, -0.82812074645053324, 0.91109988471491876, -0.10415568235725225, 0.68982426138965991, -0.17925020189516239, -1.0715135148738921, 0.92922862222910796, -1.7458509848484911, 2.3154767273959802, -0.32806516421196918, 1.1569177273462032, 3.280467014954676, 0.45616076608208306, -2.820404480212388, 1.1776004024667279, 2.8861286155468786, 0.4027565557772162, -2.4750336212660264, -1.1312178530010548, 3.3250639248621914],
                             [-1.8365063746158607, -3.5289283252381209, 1.4017327921172829, -1.5512907167240853, 0.62837414256586654, -2.201739606131079, 0.39971826565444035, -4.2023371287275131, 1.3923449531738901, -1.4586533712117047, 0.84775757973974997, -1.6273363521914064, -2.6641109431199128, 1.0883878019176603, 1.171832270029842, -1.1400918198220411, 1.3195361046293088, -0.85988429944450506, -0.4684364963398257, -1.5521294083383936, 1.9435876982478022, 0.049192730436321164, -0.63718096241685207, 0.8480103456308461, -3.3150325051859904, -1.4463495314722823, 1.3426949147284712, -1.9218885021744527, -2.014802934177367, 1.2413039971870579],
                             [-1.2534896837021416, -3.590064306459869, -1.5054602842521485, -1.6231607183991665, 1.4302870474228919, 2.7111578430038046, 2.1530147624225253, 1.3391672822695702, -1.1712585399979272, 1.2408324687000618, 3.2707392856323949, 0.30518258629059231, 0.23507082673706181, -2.0136495973611144, 0.18391423033371201, -0.51620432623693668, -3.6042855390240374, -2.4435711933003894, -1.0647913369511677, 1.9325608543860653, 3.0502312033767627, 1.9776545222261284, 1.2984524010916474, -2.922996890788943, -1.5769533726357778, 5.5797511126898938, 1.4885523721823388, -0.44020371923480783, -1.3067323314526731, -0.46311222728088619],
                             [0.1912241273629201, 2.4581961943861068, -1.7853796103097781, 0.37906974421117684, -1.0927271318719896, -1.0473803044101293, 2.6612717620475865, 1.5845166397286441, -0.74859197445541614, 1.5439299038164691, 0.82090930920959204, -0.98797353334961979, 0.52206480129663269, 2.2638235398433513, 1.0044277930966199, -0.26887489984613783, 0.66878393075724973, 0.34083881227035323, 1.564279871780627, 3.123346770545393, 0.11267913893909666, -0.59351926227773044, -1.3846147110187355, 3.6638422403004034, -0.092206617817742365, -0.68575212639316585, -1.1602209201517117, 2.3090323806155437, -1.5686161154002878, -1.201394336273826],
                             [1.1799108269213794, 2.0703453198954076, 2.0775226946295997, 0.019349323682534725, -1.4588184032130462, 1.5240975090485609, 0.55458884339900383, 1.2072270470177686, 1.8500517027643579, -2.6353205279386414, -1.7158919530670866, -0.21596267968820931, -1.9090737976800998, -0.35316277322978734, 0.10048466321508509, -0.59252556129979417, 1.9730128036585759, -5.6641969942452128, 1.6786680197795085, -1.2107316575516425, 3.7147852448086072, 0.1373520583797711, -1.3354676747540215, -0.82735253324381508, -0.18434493593283627, -0.56379279352804335, 3.5947264208057867, -0.43194156142994056, -0.4868613284132306, 0.57805673338658559],
                             [-1.0853432806478502, -3.0698445246470465, 0.16357502330261475, -3.5080005754260943, 1.3908708122769331, 1.4307037966945038, 0.357555922462437, -1.2198048723553161, -0.11802386683069604, 0.83416324313856982, -0.11274742772848728, 1.3173955386920788, -0.81865584261378566, -0.81588293674225787, 1.0972329745757106, 1.3679205872825195, 3.6777770010079438, -0.089248559862700777, 0.082093811965896796, 1.9611497350065523, 0.11046737802001588, -1.1565097577465595, 3.1905163669044829, -0.028097746202170832, 2.4944390171280038, 3.0714021601025858, -2.0175228559548732, -0.88576396641161426, 1.4112423181296476, 1.063525059119131],
                             [1.3245718340204902, -1.0045012117948653, -1.0054158817432506, -2.4706303423617744, -1.7504042688980557, 0.91575770320099514, 2.2466138344936777, 2.8769545273541119, -1.1822277113647779, -0.024815796116181517, -0.064441111690148989, -0.38688727579227, 0.36825272730814329, 0.92873132401226177, -1.7939176029696986, 1.038427758785984, -1.3383837167381185, -0.805770555790017, 1.6398554409612949, 1.431104674565012, 1.7092809180034279, -1.5747859922126399, -1.0158488481729566, 0.61015855368802607, -1.3437122567843747, 0.39467335500972328, -1.5116197903011401, -2.3275690121774235, 2.7160415021654756, 0.44301315518815576],
                             [-0.15348355944314107, 1.0165152690000261, -0.47543659427381857, 1.1622873898109538, -0.19665948744184608, 1.0018828851948491, 3.619784897768116, 3.0060290983641753, -1.0467994816003068, -1.122512684852802, -0.61829714506909339, -0.80654675919324215, 2.0073089225755942, -0.51565427217366944, -1.1264905316345373, -1.3964567065776488, -5.7551038677789048, 1.7302066249289805, -1.2183158886133763, 0.71607095397560538, -0.28202366678026103, 0.73669556017469406, 0.15224308624236177, -3.3559375014971486, -3.380291478039811, 0.49014323564733964, -2.9925945553161721, 0.090334994757037809, 0.14736450159006415, -0.1806253042378006],
                             [-0.65276861033759581, -2.7503650324050426, 0.18862969531269883, -2.5139975006313171, -0.61617198687452135, -0.88930934284352459, -0.35732625875263191, -2.0887133588313773, 1.54279944858976, 0.049232291103421172, 0.19852028896923002, 0.92389420902523867, -1.2597360298560074, 0.033432488852963946, -0.67320594137141232, 0.79516880180241878, 2.1373902054706249, -0.12865174931702023, 2.2619857192401769, 0.47822539994052193, 0.8843935124089477, 0.11271098960444136, 0.080889131732469796, -3.1305332937794064, -0.30173047292527877, 2.1780266230204353, -0.83290614487005243, -2.5217545165634481, 1.7084094701349313, 1.494647279024466],
                             [-1.5076090931214789, -2.9041781968087692, 2.3730950485754061, -0.23624274311125085, -0.88641755587239779, 0.055512105544635232, -1.1326332265423074, -1.4208551348230678, -1.9148078185583399, -0.77162394685049018, -0.33728751423204772, 0.59488463914667988, 0.11973820751262476, -2.869793358427148, 1.5721535987074358, -0.67097080990202107, 2.1558710419738043, 0.26907542736792633, -0.37789450605401331, -0.036189114511525511, 1.4954039778115682, 0.66489887931484859, 0.72911002677802117, 0.61901619282891285, -1.9698965765450349, -2.3641659240167181, 1.2340128860563142, -0.10641584379721671, -1.8775158193567496, 0.61311964866620339],
                             [0.30909503058612764, -1.586439391490635, 1.0878054560143489, -0.42223041762194125, -1.8143072964032347, 1.5900368751528893, 0.56811290739671416, -0.51656312091706114, -0.97292599687831038, -1.2648485966866592, 0.73678459447250633, 0.97100370491057031, -1.2497836472275474, -0.58888194346040856, -0.056652309174399396, -0.99807691080571026, -2.0022043604853312, -0.22815678064911848, 0.55708049928558978, 1.493711663710465, 1.2358276260065169, -0.99014716913509027, -0.23146033386072767, -0.41702963148520644, -1.0647629629316073, -1.6274671737831403, -0.37207181644177073, -0.21022770008204072, 0.95970302675912544, 0.29441745302850159]],
                            [[1.6423721792453985, 2.7263666764100698, -4.1081497676548695, -4.2521912338497616, -2.3316896643789966, -0.12618047186972248, -4.6386788771090819, 2.1658983324258974, -1.1090794231069994, 3.3977482782605066, -0.004127487086063801, -4.9033938218469997, 2.5086278395879908, -2.3307150324323125, 0.046762142663824613, -2.5458571350364689, 2.391621580972306, -1.1482085446981158, 0.61849803129324932, -0.35867979310369796, 3.8914603520837883, -3.8977303101207843, -3.8504171161108101, 1.8380772577733853, -4.8458208488487786, 2.482577475409053, 3.4505395395700043, -0.91683315688845313, -2.2653615754945005, -2.5890892221774031],
                             [0.20597745735234496, 4.5930874215595026, -0.88808023194932151, -0.24812439930709029, 3.9838994791760465, -5.1726671685171866, -0.82543723812693193, -2.1810604809269103, -2.0785300352780429, 0.19155233173480313, 0.27830986245915434, -0.64242845500114654, -5.1773527126693235, -4.4845291086477639, 1.3431850738014259, 2.0757236524839944, 4.3813314741960898, -3.0630338967200093, -2.9606969234879665, 0.67843225780582195, -2.7394576940491762, -0.9894832310936601, -6.0834877401817522, 2.0180515744312588, 2.6928156740561668, -0.065108861047228794, 2.3654210121549939, 0.16033197887876494, 2.289599358086547, 2.2306695522886422],
                             [-2.1898436410140487, -1.430020177472765, -1.9048614121062002, 2.6347945682108467, -4.8607626907162675, 2.6016693545282119, 4.9122151398766727, -3.7719648798197873, -2.4408642645327512, 2.3601996928160447, -2.7222263279294814, 0.72458989646495764, 0.082824552093236692, 3.3543431357586679, 2.6768427580446672, 1.8133049418501777, -3.6563350758464419, 4.5962536191727033, -1.642743580495075, 0.75360415207309206, -0.41781023895278468, -0.36525073477144321, 0.39203600589850351, -0.2950719733532069, -0.97074331427319471, -0.23012963662005426, -3.1643859387565394, -6.6430263362521575, -0.35481875250802697, -6.0010492600798084],
                             [-3.8157823188457956, -9.9975411865716026, -0.0086921545975346959, 6.5282953619339459, -0.23242385761408579, -4.3215915958308226, 2.6968598796309413, -5.1260754976855605, -3.4679143716909704, 2.1786010434913812, -3.2385721201915278, -4.9836032101736354, 1.0120646344794397, -1.4504473734340249, 1.7228253684132353, 0.30275308885082292, -1.2695120128578417, 1.4336741386635188, 3.1049351104567933, 5.3981782251409163, -8.3330262505093931, -0.37862423860069516, -0.7432081979159213, -0.52243441108145294, 4.7993259079350326, -5.0227384057653763, -3.7959446290946226, -5.8833309053775498, 0.33876931406129029, -3.4274432827114643],
                             [2.0501279820370928, 3.4618819782755477, 2.0285999018076541, -9.0760737820048032, 2.2696123735462264, 0.9841273748722803, -2.171800107375359, 6.7625580923766364, 1.6672306683029543, -0.19925568978259348, 3.2827740675437154, 1.9479398455719539, 1.7462192801517185, -1.9575014977580185, -1.4466396573340836, -0.38199039092889353, 6.0322466170887861, 0.60703405990336656, -1.3786897169319017, -4.8096982226302796, 4.0493008873408991, -3.0809669076247141, -3.0441989921620021, 3.8577539751400809, -0.1595731049039712, 0.89709737232602527, -0.52607292691550855, 1.3884195323697495, -3.6086302701147566, 3.9081736816959416],
                             [0.29260411887418314, 1.7117032740886211, 4.5399472229766769, 0.98479426628128586, -4.8620148746720471, 3.3015214125939809, -0.20015817218304771, -1.3539013160949116, -0.52287168372334669, 0.42022706402410359, 2.4172161442026567, 3.8026157310247308, 1.8855957500546126, -1.6023630265004161, 2.8328765754425524, 2.2214982068079521, -3.8251435653115484, 4.9019894810715421, -1.5785114236718853, -5.5450888840359269, 4.6350838565429662, -1.8341043399672508, 2.9975928320935696, -0.79156268278627029, 0.98676415393136363, -2.8625761005765957, 0.44608176543946459, -2.468886633636906, 0.23573648431755512, -5.569371818363452],
                             [1.8234693818447925, 1.0792388972801208, 0.10054719248820598, -1.9483895729394196, 3.7524596227594302, -5.810910622038425, -1.8367615276660711, 0.93740027764372624, 0.43033240423134389, -2.1646082011698642, -2.1841347304867118, -0.55482545829658558, 1.8723061179424685, -5.107794494995316, -6.0220273183575799, 0.044813540750161994, 2.5040725208703973, -3.669907346230354, -3.5424863320466087, 1.2338968054556141, -2.6369878537556772, -3.396469857172006, -4.3992435352734338, 3.8634840559308214, -0.27241531936053576, 1.1981444105781449, 0.61677065381256646, -0.91276231682503539, -0.1323100516038358, 6.1816133470390406],
                             [1.2913012652642077, -0.31523678237153413, 1.7384362549611638, -1.919300792459141, 1.5329282777025082, 2.030753842093858, -1.7460899412746387, 4.4989429895287518, 3.3383183005623671, 3.0745919070298728, 1.7489523812466297, -0.32012582466394746, -1.5092551436758634, 4.8448379977406333, -1.2785581289921599, -0.10564525456335405, -3.1528872336460632, 0.65114995072866666, 2.0321677110818319, -2.398151163886876, -0.031653584409256696, -0.949279699995071, 2.7634757783041373, -1.7961198231879474, 2.2971252079724711, 1.2926490545652358, 2.9352692417174016, 4.6973922108096353, -1.8561660251892353, -2.3093242839230461],
                             [0.46397892214445036, -0.92471266878802816, 0.074065044705152516, 5.1562322093124342, 1.6850491515034505, 4.1917627303555154, -1.3219786558404023, -2.6610720002991473, 1.838838318632914, 4.36127612927939, -1.9325571856927302, -1.5112110700409151, -4.1738363768396987, 6.3233619165302848, 3.3887236735198574, -2.4051453216474172, -3.1553912250435898, -1.3981282670626023, 2.8154713127026074, 2.5541636736557538, -0.21509112751175619, -0.8304024794430499, -0.39792435740950616, 1.116853513743669, 0.15486007791537104, 0.010571474420105587, 0.67062081781184524, 0.11090615814099525, -1.2502115459027117, 5.995937646566655],
                             [0.45669702265462708, -1.8787525359550026, 4.62906923399236, -4.2056787690904409, -3.9886526931553248, 5.5432892966477976, 2.0169687393561353, 2.3959602572296435, -1.3253755903360129, -0.10847459920470914, -0.70645298493444286, 0.73444520718004758, 3.1043955994854184, 5.6870206748563277, 2.8257480505028942, -0.017991539713731547, -2.443686022689469, 6.4039134527776724, 0.35116579487352473, -2.7623030298621352, 1.3643899506356267, 1.1776420639392446, 3.5194314424473574, -2.073573343602674, -1.2571741719487171, -1.6046648895079008, -0.77161870698770085, -0.62568298802984001, -3.0953583775357298, -6.5551087143024871],
                             [1.3246231696574171, 1.8790311505799941, -2.1761742377598807, -9.0895499205879471, 1.6664529282067491, -2.2518944463462289, 2.6496469580527884, 4.7102148930160759, 2.6599204778842425, -2.4161520527121771, -1.6866957137091041, 1.7045425548653024, 2.4030094307263852, -3.8630887429515934, -0.59780925278798736, -2.10597156740516, 4.591688645742372, 0.78279596837868581, -1.8260505291995144, -0.70654284713497062, -1.0610380852186447, 0.85797897431239256, -1.6909501929190132, 0.89213567420398854, -2.191236625178504, 1.0781619026706737, 0.62858746276565414, 2.5174232122888802, 1.4881634977969243, 4.8040723692912337],
                             [-4.9869781931765926, -5.0877852452697043, -3.3910358947020991, 8.5305230699390187, 3.2343490143290623, -1.8225189544606137, -0.16793567053400771, -6.15625399498487, 2.9711672552609487, 2.4902462893056687, -0.77940358339194193, -4.5635394065556225, -3.1264710564264067, -6.288140841606296, 3.4631440569283005, 1.8643219158556812, 5.000033907860022, -1.5271728702787346, 0.27093273758175851, 4.0846969665628414, -5.8799983549331234, 3.1444291806770677, -6.1631668360508476, 1.5570000823143848, 0.42366480478247248, -3.0343319835655764, -5.3136709281941554, 3.4683114093512488, -1.7021434938093449, 2.8043785440596798],
                             [1.1424963970447279, 0.60544307857766932, 7.644920541875595, -4.2079466279285072, -4.4756466329026647, 3.8566863405642193, -2.39475107379057, -0.30284411996460658, -1.6437042324503408, -0.22219546801486439, 1.0950143631613889, 2.8500617201940659, 4.5381221740529547, -0.61027217747306883, 5.0438615965192346, -3.7117796232946625, 1.5424931539734459, 4.4754374607200678, -1.9185283441995724, -6.6180960177978188, 11.683133423015127, -2.7073691078962034, 2.8341560273899038, -1.3464019160938205, -4.6969665575255197, 1.429792845907615, -1.7550603165126857, -0.9016766578630917, -3.0976268183072762, 1.1273810219274685],
                             [3.5506561942076607, 4.194591709311327, 1.9846875630535816, -4.0425239374113797, -0.69010527420869627, -3.860445007486208, -1.4165351947310696, 5.249067284214739, -2.3997690424227422, 0.64311012855980654, -3.7333644796453442, -6.7023825271457467, 3.5872932341659589, -8.3665757707422728, -1.9674246303580962, 0.78286969661342698, 4.8520101611951434, 4.692423869751428, -7.5855069440489942, 0.73298331992205612, -0.78722288966912934, -5.0886679350861455, -0.48669158180953909, 2.835391323449401, -3.0955187533408068, -0.35382997370329566, 3.8195457619330071, -0.2314894895689994, -4.0805220068157757, -0.785045587038393],
                             [-0.89057057327977918, -3.2900023356946111, 2.5914878280550662, -2.0231060838343735, -1.3636393397989302, 4.2852375657900943, 2.0873461785606078, 0.14825952344854998, 3.3747627242179528, 1.8476322415451816, 2.29105292348537, 2.0545503830204637, 5.1339578256550071, 8.4412647713250504, 0.094681928009949567, -3.6040944877290273, -2.8039778408764677, 2.7666024285103337, 5.8761854297511071, -2.9361862422672464, 5.8265688479487361, 2.2630838627744088, 3.3134995716061475, -2.7541459814602911, 3.2408981727889903, 2.0501882983258657, 0.17170511581808018, 1.2901628003320424, 0.28153764297763861, -1.3308108127183349],
                             [-0.95330795060259721, 0.58774345252764282, 1.1263470117063645, 2.1122558644298115, -1.9578423782276158, 3.2351317368271104, 2.0404624904653463, -2.1515571154191151, -3.9141854998571, 0.31765171845017237, -0.84145399467420634, 0.72551340219672067, -1.0078576568400719, 0.58219642386129178, 0.95522587716312768, 4.2890170297645138, -4.4061006305092638, 2.1467161243761832, -2.7548292776847796, 0.42099897637261763, 1.9591851528402489, -0.73883556588571786, -2.8488256934907139, -2.1314233714596491, -2.1218596402877097, -0.54383967354378004, -4.1606147608779525, 1.3520816165855143, -1.8286738171198627, -5.1640901646229977],
                             [0.21420901915944179, 1.3216508458294116, -0.067150212649786156, -0.81164929330045832, -1.9222383995827401, 0.36774509508398778, 0.60257306100056407, 0.0077199646576808223, -2.1037753113331275, 1.9272555098899005, 0.33893649432953177, -2.9651681871217774, 2.3373085484836253, -5.1585632899033653, -1.6810210829768191, -0.84485633110365388, 5.6715486373218686, 7.6807344548532184, -2.1289621111642361, -1.3440364207104916, -2.1393603524147031, -1.8888266017440265, -0.35986151459470683, 6.4123930723321347, 0.21412339144740217, -3.0364075138973656, 1.9282233079598274, -0.30256557033867038, -1.5687699865338771, -3.6407751847133509],
                             [-0.43545178023098452, -5.3060480403160106, -1.0640178841821897, 1.0822675608599557, 0.82689621193845864, 4.8764297788085234, 1.8096227086019319, 0.24849462814804182, 0.995556726446715, 0.0079016594999497709, -0.31841890619869317, 2.8216776675495683, -2.9882565909308654, 1.9830887684056662, 3.0876776480572232, 3.5048695660436571, -3.7993770099605353, -2.7987554809988309, 1.3566222364428469, 1.4412789602676883, -3.9841844551092169, 5.8489648589900138, 5.3247553953142877, -3.0465850142831026, 0.37580753917274873, -1.271403000958337, -4.1687044660935184, -1.4310585707864873, -0.54145963712304523, -4.1613403792355159],
                             [2.1395298402074605, 1.9105862622030962, 2.1049117273316256, 2.1174308409235763, -3.8149460318753015, 3.0607315945136331, 1.2336558889582578, 0.43196820231287503, -1.3762694787368503, -1.1731938781946603, -0.11477866501624963, 0.33854563048606168, 1.8766093136675872, 1.0031214028540676, -1.2586134141132161, 0.63539794113417414, 0.21570554038541689, 6.675771429950883, -3.0196333512735909, -3.88327152968583, 3.3651364194631763, 0.44803848750641928, 2.8738085046084514, -2.1769783942946312, -0.84440625910165323, 1.6949843860474374, 1.9464921574785292, 0.37192877069467989, 1.5954954205620038, -1.5372669001087991],
                             [-0.88703847219317478, 1.1127086644209532, -2.7600845642969687, -2.450334907938875, -1.4724968294942138, 2.2606146774949538, 3.2468471407137938, 1.6105820612228969, -2.67438974496004, -0.79168017190325424, -4.9614438316849787, -2.3691266666234743, 0.073204140459276368, 2.4399876901260806, -2.2310399204438558, 2.9332411688056306, 1.7055475894893088, 1.5471174106782075, -3.6695404302862662, -0.41902212748514744, -2.2594365454614649, -1.2558727151060269, -1.3761728531902582, 0.24110782582346116, -3.2261445607623322, 3.2676540021113771, -5.3121608628133448, -0.35155723309291792, -2.4869185443670441, -2.409625347986128],
                             [-1.3878964017354103, -2.3928152147061845, -1.0823444187962159, 2.391595250126235, -0.27338300233498758, 8.959352236340882, 1.7979492249207356, 2.1104556186252803, -0.078718221610849515, -1.1720414290206838, 1.5559200224903205, 2.2225353593939436, -1.7753522282948966, 3.7787102676910358, 2.7051563551150717, -0.94894450529353336, -5.6276378346158786, -4.5780129186397511, 2.909915502045866, -1.0457492534394039, 0.31176802022426031, 5.5075754978118381, 6.2787938483794292, -2.8445966207872329, 0.3571570280844934, 3.4834155817936754, -4.4259950912693835, 0.43786119771347504, -1.7857145929384735, -1.9896043255923894],
                             [-5.6229564082589718, -5.6960954805592614, 0.87656129830178031, 4.2976902732317992, -5.9316018312498926, 4.0811299932278846, 0.61774274529849471, -2.6426184164337219, -10.81973448274853, 2.2728621499288924, 1.7682339453444595, -3.7450109212503619, 3.4711215240955862, 7.7776997748761492, 8.7503758817295498, 2.1912329739173559, -6.2121616279043685, 9.1588041657717074, 5.1030671375151782, 2.3725067456062217, 1.2130775369900957, 0.41407938856040305, -0.59289481792542498, -4.7310768850255709, -3.8848086748448369, -3.9394757360164276, -5.8431116120187552, -1.3790738956620834, 0.9479679225184332, -9.0233267967437154],
                             [2.84256390167304, 3.9193094548834502, -2.6020582202705138, -3.4430714748416991, 0.89426786829273586, -7.8141918825459591, -4.4578004077925533, -2.2070690907512849, 0.46197954762575244, 2.9232951825220299, -2.6057253791517714, -3.8996754450066633, -1.3377868114541487, -4.1968156944316908, 2.8645849473534275, 2.1220788195706817, 8.7628900490745956, 0.81850941369901831, -2.087836756873068, 0.11168336065132523, -0.84437050016137993, -4.385454220848521, -6.5811077804119424, 2.8883668695469553, -0.35104664039555689, -0.35888048553354435, 2.6292140770961785, -1.6116555947430697, -1.1895434995283085, -1.6878333700908954],
                             [-0.16278768835972968, -3.1535062398673004, 7.754266558238859, -5.3904123437964522, 0.08553823433822938, 3.3814312389929766, 2.0403130407818284, 3.6280691876357807, -2.6683030916777613, -4.1169313109049046, -1.5431076300176747, 2.0533461302287792, 1.382234163382696, -1.6156773962771136, -2.7420594003509811, -1.8579657106111882, -1.1767224562690859, 2.3342076728145607, -2.8527677035762782, -4.1449922177716578, 0.37265647097755927, 1.3075490737511695, 8.5841040648477414, -3.0864675634199328, 3.4300978876491426, 5.7303100763965, -0.36709440730679477, -0.69969287377050948, -3.7369251367957785, 3.468423202015817],
                             [2.9013038461890828, -1.3168721939003223, 3.4627110875310549, -1.8951478052347643, -1.4116041141503048, 0.13502067902131165, -0.64337346953571672, 1.2868293752878008, -0.84774146022380026, -0.77828956922139625, 1.9958423717870202, -0.16274983783752295, 3.0991671076814544, -0.71637771844395015, -0.1187974162300566, -1.4708378425263753, 2.1622685503607393, -2.7441862164222082, -1.9483170819611948, -0.079086591643812931, 0.30560539960340277, 0.62493349731658787, 1.5044467286198031, 1.6144956917616264, -2.1419887562677054, -0.41266500656442473, 1.4847807707911822, 0.33702254676106025, -0.69311690592672015, 0.38447328484854915],
                             [2.5155501524045181, 0.068445468906676243, -2.6052326949091307, -4.2272892138836102, 0.39089464345922326, -3.9945495802093149, 2.5428821855864254, 4.8167430401174709, 5.9967627332196143, -1.2694816540363687, -4.1078460310558613, -0.24158724033626913, 3.0480576961092987, -2.0272505735566733, -3.6761637920297683, -0.22803113316369708, 5.6872461238691843, 1.2756843711818955, 1.1106787439156152, -2.0211944223274654, 0.29827841939370897, -1.2105971142939855, 0.080011684754508164, -1.2977369460170913, -3.5424145603570945, 4.6397547831972954, -0.84384879529810919, -1.0953048124506606, -0.3644490285183295, 0.57406175692454464],
                             [-3.2593408908871311, -1.1898768977255101, -7.9077836394554879, 6.7756395123506969, 6.804604264774385, 0.96995766693011465, 2.2984450405131853, -2.0456491540254489, 8.961334791101347, 0.71973169413243165, 3.8374584958269078, -0.69626493688245406, -4.771218337817329, 0.77309118692137435, -0.86767548927720206, -2.3786488044330043, -1.0333586549276434, -7.1382517376727925, 2.8921356280808004, 6.4113517918249885, -5.9374487569085446, 7.8631863225617415, -1.4361656912554395, 0.044961089417467459, 0.90449845071197177, -0.46948758604954888, -0.69840446186804395, 6.3959354565623823, 4.001480203607664, 9.1974381020233658],
                             [1.9037411901504337, -0.73740050757660258, 2.4777983565902599, 1.7555590493685425, -0.37329912005566535, -3.7276716493896895, 2.3628792738000546, -0.0072804862117722413, -0.46249120650758102, 0.69221079436627475, -0.91639254978762985, -0.99341882823779393, 4.3568239392948191, 6.0684893417140433, -0.35664601079640418, 4.7066424815082968, -1.901847212779443, 2.6605969146614288, -0.77099457866442411, 1.0187465392527275, -0.787981802842454, -4.1037690057271812, -2.0256998575080032, -0.93895930761810609, 1.8456691285593196, -5.7137734242153391, -0.12670621295547635, -0.49071955462419758, 0.59688987895404733, -3.6393387975149656],
                             [-3.6737116717546088, 0.11301262968525294, -3.7622466988735517, 0.2531127907173466, -1.2254075060166136, -1.2717454348939408, -0.83508293241849407, -3.2266423822548855, -5.7764894783407534, 2.4489372297474716, -0.81086931017067598, -3.0153851444811131, -0.95458282951058049, -4.0558449413796946, 0.20824792578167925, -1.4354563892209087, 2.9728146982425532, 0.2018970234025832, 1.6322552127253194, 0.96925839826153382, -0.066880131565399958, 0.53699106020477472, -4.7751200935342695, -3.5431673091313329, 1.7101489685317559, 2.7220256671905796, -1.2099442189278782, 1.786256712028448, 1.1549997790263773, -1.8801272717415418],
                             [-3.9750208656761181, -2.7086302544700276, -6.537350163362035, 9.4701457608943258, 1.0173048032960677, 1.7785345577962457, -1.113889508834462, -3.109194076834406, 5.0335228724604431, 2.0829307873548304, 1.5964473352396638, -3.0570091926416696, -1.8827381598104203, 3.7664883609160427, 4.5466898454432538, 0.66336716829064635, -3.1615511919552945, -5.3452525817445853, 4.3228598492340424, 6.549381978455413, -1.173377133689415, 5.2122803026417186, -0.39115720179367486, -9.291991910927921, 1.2635214664860535, -1.0473565268521141, -0.26995483045145519, 4.6630275734164242, 4.0977404869609479, -0.47261916794305447]],
                            [[2.9460349651862203, -10.621380461456345, -7.0225860478766213, 0.54089549864235431, -11.687054918941135, -15.151874404343014, 4.4578508635254934, 0.5130981121214272, -2.6732467486614819, 7.3883597277518849, 10.688902572721968, 10.43492785481584, 8.6049276981609086, 5.6889863878313864, 4.239908326517452, -6.0550764462342785, 4.2285932868833225, -6.1838201814330205, -6.4345482540916086, 3.673701971646858, 17.470913826992465, -1.07228614714726, -2.5156164642916417, 0.83847017645425981, 14.397019884193094, 0.064178108477362883, -8.8532438608034134, -1.1185812275013234, -10.439145674873886, -1.2216142884760113],
                             [-9.1280897844904025, 7.5136881200055896, 0.61410369335854376, 3.232172359495618, 7.2011846029601809, -1.9059093516169709, 1.7134274590653324, 0.40982789588632457, -3.6591917382866805, -10.221973116843108, -5.2344081779212326, -5.4565697564181317, -0.56535854945163444, -4.9280560307729413, -2.4546257785071508, 6.676229036073809, -7.8271427389538859, 0.43029231345145719, -1.5622832504932198, -4.8240257445655139, -19.39052314028994, -2.7111441199695574, 1.1333192176357709, -4.3566137840011363, -10.059199746834844, 4.5547386637511353, 6.7353831808092588, -2.9461693481844575, 3.0110391933601584, 3.7993312751191404],
                             [6.9827749258642378, -5.1857223232283927, -6.1380924773013357, -1.2263303767626901, -0.22498963831728022, 3.4831148648133943, -1.8721395990190086, 3.7442738179817097, -0.88326406855429185, 1.4831154208219652, 0.30936699212901642, -2.62766599860996, 6.4015818034649445, 4.2437268003369635, -3.8925240209316834, -4.505566197348096, -7.4806846261773234, -1.7833823253837142, -1.659860701818709, 7.5222574184218836, 0.91767987423520658, -7.9904894802331112, 2.7185991700677565, 7.2808656586993745, 1.735733679824579, 1.185473297340929, 1.5695500066271986, -2.9203888053342033, -0.085093195685998171, 0.22120859636203458],
                             [-8.2173013477040033, 5.1500364051869054, 0.71267835215758502, 6.7696322304375247, 1.0542282206461326, 3.5478881214299158, 0.81697831093546225, 1.8977104853664746, -4.2311882143345771, -6.7762183171754753, -1.0171812349986344, -1.2365645862763281, 6.8208228782788893, 6.5755353777257772, 1.939767768446782, 5.3613413190942705, -1.7317206495591195, 2.1587492031267836, -0.20971793523499938, -14.967147768627015, -6.4110482309149894, 4.7571679104139211, -7.0698334284707611, 1.7817988134081726, -9.4056208116258357, 1.0059010673264186, -1.712210612589693, 0.53054891807447102, 6.189257947081539, 2.1810194444873803],
                             [2.0951916385591312, 9.093369427336885, 2.7867914511505552, 3.9486591049451993, -3.2922724923118483, 3.1726363090248237, -1.9464484660623922, -7.0917845255792979, -1.4557472508519855, 7.0015638911504805, 3.6676334851781092, 2.6117177216013308, 1.2013457338622506, -1.2640595713130989, -2.8773403982226475, 3.9404079226797428, 4.8987308122431319, 3.4943558985973486, 2.6144363295357635, -5.4437673389772181, -0.57978668031289193, -4.5887472832912533, -5.2621720482703198, -2.9704369831527346, -0.70956066704669796, -3.0854632383154743, 8.8515000683689102, 3.7394251084342751, 4.8898744024313512, 2.0186146210763218],
                             [-1.2387631231255825, 1.537076248417923, -1.1827400008013091, 5.499686935346924, 1.0450373941062567, -0.66166604594208001, -0.61900898416425265, -1.841498225116645, 2.9359902517683953, 3.1574272050099927, 2.6561621826228867, 2.5955806517328179, 1.8919688504742842, 0.89774162984906702, 0.2313395544806357, -0.58254158577110371, 2.1689708432407295, 1.2722865724848549, -3.8478997701928277, -8.420668134951887, 5.3964770119921477, 1.7602977816594689, -4.6594098804884929, -4.6983052272801515, -0.38249786677726672, 1.2555484794110396, 1.6840371147312159, 2.1468049961073543, -0.63841362764247001, -1.6363464769137641],
                             [-3.1140724993307165, 1.575808941906119, -0.83109672475720575, 1.2099155423677017, -0.010064286882401602, -7.719730715095511, 0.95393693148509795, 2.7262455006497381, 0.22791387562199944, -8.1021265664223971, -1.5856880960815796, -2.2552651235181616, -0.67324349919099491, 0.075120716547566135, -1.0877170627954094, 3.4353894576742636, -5.5789259058298342, -3.1375119986030482, -5.2976015079711241, -1.3843713846241079, -9.3763546768629524, -0.30523884692891579, 5.5746497997694187, -2.8171314001402528, -4.3449570584950399, 4.6755752023811228, 0.48420474709159295, -4.446294239094204, -3.4725041311892313, -3.7882022404751678],
                             [7.1118651458908557, -3.5839722107955301, 1.4518690358057427, -1.2638443901310077, -0.24422135369798975, 15.781982432919721, -13.571439144012652, 6.9820842515787511, 4.9589328312252867, 0.95196256015617664, -0.29443616513790161, -5.3014772992256107, 0.32088810376658383, 1.5607691298811155, -1.4673701914979469, -7.9079838470770403, -2.1657983391194033, -3.020075954977278, 4.3487010457852344, 1.1647664011108874, -0.79364951948044027, -1.3389541091656558, -7.0741850799538692, 18.282659824516877, -3.3907386364677654, -2.7967506045148385, -0.12991167684609156, -3.1334604748648665, 4.99558204416339, 1.7300550064640718],
                             [0.73111420396482418, -1.4865412089077195, -4.0196058779007711, 2.0858847600067429, -10.097437652685711, 1.0954427726344722, -2.1138746643160684, 5.2691477120509962, -2.8611220389391319, -3.4828729980626356, 0.49910651312646825, -0.089997286494055084, -0.11661084698431767, 0.65911303886925277, 3.4309689115127733, -4.0259085213605594, 1.1096486419326457, -2.777656731026243, -5.0576623772916749, 0.052700241202640719, 2.531930384489538, 1.9563511728968543, 1.6536653589300783, 8.5893194078331465, 2.7887857054117577, -0.3204290170576557, -5.5093957070124855, -1.4358891945440064, -2.1821935820884932, -1.790978790714246],
                             [-3.8743879862181974, -2.3830168892696286, 1.6062627488027035, -7.9604138879492821, 11.440015380325086, 4.9593979785481537, 2.2603695553617378, 0.97342903833490502, 1.6692296475309261, -7.5495133459437707, -3.5675420255224028, -3.3083964808314712, -4.3315083363117237, -2.7594955265639314, 0.61960468689321346, -4.9050161743689893, 0.052830910272105625, 6.3022377910699419, 5.081086885006024, 5.2154837863190515, -11.81036174209202, 1.2258568593503127, 4.2303486284475724, -2.5858310088335252, -3.7306454029925424, -0.24990830476405579, -4.6925316294536925, 1.0081404182893103, 4.9234334459027602, 3.7749194341072299],
                             [1.8840855128068572, 0.34890704542119755, -5.135851927284441, 2.7653456199574236, -10.65036089973276, 3.1782362994309983, 3.065920820181363, -1.4112272387822575, -6.3810995104062576, 4.9948892450894791, 12.257635930874526, -0.79388192750777098, 11.651680294075492, 4.1264001461752491, 1.4442225291682309, -3.1081317785285445, -1.6694697900024122, 0.35135642245928023, -5.4950923921418875, -3.0663868171821007, 5.0026977905202852, -4.7430145371085723, -7.5051691079603469, 8.2227524686918407, -1.4363141840553879, -2.1377173662725264, 0.91007674096951086, -1.7296946354620721, 3.0627247725094744, 1.9688557490563112],
                             [8.113253179915688, -4.0645479777756028, 2.4459213312703678, -4.5596900241909193, 4.0012452661968618, -1.0667417096442495, -9.270938711780822, -2.9676203250218194, 11.696489043317653, 17.168441398690966, 6.0162066050475502, 7.8170171715601917, -5.4716979421676815, -1.0936406459379255, -4.7563308565596323, -7.3719246673349197, 6.9783907211738718, -0.04710535408941053, 3.816777043137451, 7.6457360412311486, 20.662683651638556, -1.2742351801959058, -4.2143242187104688, -2.2873924044906579, 13.73968257673209, -6.1486625888858759, 8.6584191750844823, 9.0120653790205782, -4.9597987295955521, -2.6605595405687232],
                             [-3.9199148257266385, 6.2711629376133189, -2.2928910789472345, 4.2487800713120034, -0.38726377459965677, 0.80997942408873769, 1.1143107346115089, -4.3345852754795988, -4.8432382017204461, 1.9022106741477418, -5.3561367967279061, 2.1704789691224078, 4.2331321724920761, 3.0322073773236933, 2.2741771595149514, 4.1514497976179099, -0.85050455339537134, -7.3645693932743352, 3.0993091353098796, -9.5043348753112991, -5.049061540451234, 1.9092690259236829, 3.2608618571570815, -8.7580933534630265, -2.976909997233967, 3.6183333833940314, 3.8292888418881637, 0.74475241408775217, -2.3660385999867946, 3.1567813403503564],
                             [5.5293346913829886, -6.8219273722587657, -1.9621011552289003, -5.0627611316080072, 1.1894921205257087, 0.46301233825228227, -6.582117331586713, -1.7448017296909382, 8.0374324471207803, 11.246664077560977, 4.4437504045542449, 5.511095083884614, -4.3235726726827428, -7.8554004894369038, 3.88760222372645, -17.695213567694196, 3.5823701849925493, 0.853837089930368, -0.78337860984488394, 13.838742970975026, 11.722994542641771, 2.0035786101494795, -7.1778881609451002, 4.0093536659959748, 14.463232891344827, -11.90973694894234, -0.28384065586852969, 7.3978250357606807, -5.1468407925199013, 3.5770324771398037],
                             [0.18456786991572083, -3.1308952276064104, -1.5042120205678859, -6.1325800344889192, 0.71568051889342266, -11.954215637351222, 17.380436294368582, -3.6356351190013858, 1.7337679982589169, 5.2466113861265153, 2.7824622244088544, 1.6087217113869277, 2.1129881179512346, -0.41669145513381667, 1.4815495988628999, -0.5292388522147079, 3.1514973850166283, 3.0669254780790443, -6.0697939135006083, 10.77378394790837, 7.1547994988849446, -0.49859516379909852, 7.3380015126237996, -2.3064146896167999, 7.9179668074830305, -6.0439786301904688, -1.345428841754559, -3.5276288963747962, -2.3246986491078916, -2.5418137951157909],
                             [1.2100330952748899, -6.207848393015051, 0.23664341840283432, -3.7428933011596657, -0.89551857396969969, -0.70270086705284163, -4.0316730469872342, 3.296389234037115, 4.1032954560593389, 0.89012161307173643, 2.3768903564583419, 3.5943423059487487, -3.2500201240143087, -2.6505900617879634, 3.2510469000631508, -7.3212843976456137, 3.2518533080907188, -1.8039538822642571, 2.3042141406020358, 4.138587639718617, 3.7124083718590284, 4.5550469740496622, -2.5001929957588036, 2.3460266546099429, 4.3415886850241412, -0.40721201356875719, -6.2079118070971617, 1.7764844933923682, -3.4105968694324007, 0.61885082471275277],
                             [-2.2079790466742613, -3.3840667128529578, -5.4748848536832924, 2.4551173002036375, -4.8414316459687594, -1.6553511486890768, 0.09418218565358033, -1.5344058144586086, -1.891806214759854, 1.314151160882103, 5.4846967275892879, 5.8904704747926955, 6.4884182211878061, 7.3991828804511295, 3.1945327944263227, -3.6056834187715081, 2.4873900580144466, -9.5800999224931509, 3.5340436850771111, -1.9417304697955746, 1.4262768379136617, -0.57411232591501415, -4.9509173692397379, -0.039612625454949452, -1.0670645882975855, 1.5968102266018231, -8.6938499267094915, -2.0351341033719006, -4.3799830418405685, 2.6102791429718328],
                             [-1.2370061559839418, 0.4650711730671489, -1.3120885192919793, -1.9971630751315013, -1.8463558174837948, 3.414702225640379, 2.1796584121205105, 0.92841286661266798, -3.4330064404906921, 0.14429503245227554, -3.797396416001046, -5.3260829908544327, 4.3944223647338641, 1.0322807507161831, 0.12485270867902379, 3.8831389565351833, -3.6371316692636437, -2.3692510369691386, 0.39292999285453367, 0.60366807842561798, -4.5715947444825078, -3.0257229071545555, 1.3036377046380183, 1.9272617946207009, -1.4634119281222209, 0.81798795970077809, 3.7526724367217055, -0.84803389221488001, -0.010638362471719981, 1.4968335842295235],
                             [8.4407356621640073, -3.5131577895743029, -8.342430485851164, -1.1624270295861023, -7.5333584702426348, -5.1672502399685403, 0.44108805134433843, 4.6314153152189821, 4.6670427514813415, 14.039756997850628, 3.5828708621963354, 2.7470452987148866, 9.8035166639445919, 7.1077225997433855, -0.97710761106880817, -9.0333549788439722, -0.056406114358331538, -4.8614557962866352, -10.759150932393256, 6.3613423585963371, 22.911086006407469, -1.6359859770216119, -7.3923207778206876, 7.835662024905429, 18.181989398619322, -7.5728134653142476, 6.0309362373338411, 2.2586835094295612, -3.5070074609837265, -5.3262019646555885],
                             [5.730074581487365, 2.3391131803485923, -4.5715801108502685, 5.8873015980010255, -4.2847553504410989, 0.026767981814427189, 0.75539044280195755, -2.2341004341768111, 0.3525775621240298, 6.4062594700698048, 2.5587070922483379, 1.0129626140779797, 12.458018393048096, 10.537741956619682, -7.9144339778891295, 9.6360353903985771, -1.992491431841761, -3.5852171999927043, -2.8756074229525557, -9.8165440093385179, 11.436198515271508, -5.8179974511794503, -0.41070542946031563, -0.75243566156363173, -2.6399997847833068, 6.0757856813854847, 8.9536295233188703, -0.29385782757085571, -0.82387778633513387, -1.3821145642891595],
                             [-6.208437178102332, 4.3379905227355406, -0.23859891865658073, 2.8446039623878581, 6.7541688557278086, 15.130738739820963, -4.9108481855350794, 3.5866462989694985, -6.2536689301860777, -11.733756858882053, -8.8228798053990758, -2.8136046718326382, -5.1271142124397731, -4.2484506567162823, 4.7569632205893964, -3.8913909714438644, -8.5535718965680978, -4.3563880517111571, 7.7405782650761337, -1.545103457428874, -28.766581806643664, -3.1339250980760243, 0.65164951561537476, -1.345924216715485, -11.379211328655186, 2.2094809879307293, -1.0171004198327949, -0.0083207132848654997, 2.0991461859334488, 9.1397444743752363],
                             [-0.40730833201130545, 1.677447854789107, 1.9099570634812135, -1.4475089516402924, 1.1086304006283716, 0.64934240985772973, 3.0123022680163607, -0.31127402275453953, -1.1922148040417679, -2.5720158960289159, -1.8174463929783031, -0.40340946376093534, -3.8759174578049609, -4.4095605723191076, 0.73684971533192534, 0.17240442636019299, -3.7906222591215011, 2.5513222649393263, -2.3392680509212731, 2.799987061303455, -6.5185798242814483, -1.0531667588232345, 5.5267394570488992, -5.5151773759565579, -1.6693125826620854, 2.2479866231404992, -1.8017878541300518, -0.91989711089464876, -0.043611737421835883, 1.9252426628708244],
                             [-0.44365930520257796, 3.157366871889292, -3.613979214975048, 1.6613663841818085, 3.463480914076281, 6.1165519564532671, 8.6820764974852569, -2.0644951577813027, -1.0857529362056579, -2.171902336356625, 2.5347140818647143, -5.4397974798892132, 3.0812604427298664, 0.95666272866793345, 1.6750784833778909, -0.34470877844998304, -2.4470885528278119, 7.6741197459639618, 1.6945546804611591, 1.6706816388347725, -7.8518756473750848, -3.6478763807938046, 5.0858608932178377, -1.442638536252294, -7.9015119172408355, 3.1385970357788926, 4.4346189907723037, -2.9363438135986977, 5.4088805984013772, 2.8873132570488713],
                             [0.24212641742882601, 9.3339049112343329, 1.6276721096440041, -4.0035511990862034, -4.0298822668866014, 9.8582904300449563, -3.2549379332015711, -3.3888940973604273, -2.2335727139838895, 11.193038319434727, -4.0585740271467792, -0.67030780163823578, 0.11223975662036934, -0.83480428625786107, 4.2411260791364516, 0.55135903335848446, 5.2557750059869459, -0.74210828712629562, 7.2149567491034432, 2.9025482459013827, 0.18768239087734068, 0.54585786334333997, -1.6766996073750853, -1.6431442290610336, 2.4186445957654952, -5.7811316190217195, 9.1898645346322461, 5.0508187820675134, 5.6259237474105719, 6.2896323888760426],
                             [-3.0330800805736358, 0.58368620331822008, 3.5850657380077013, -6.0853975422008055, 7.168030472537156, -2.9149337588061663, 0.0063672925300618174, 6.9838981286030952, 3.62724169885397, 0.62584851155025745, -4.8470596481696546, -4.022223852522516, -3.5099792508153036, -3.6742205219614577, -1.7982783015472048, -3.6809714611589954, 0.82433304259657847, 3.2869126678004625, -0.69396393101416787, 9.0525883509078895, -0.14278850808692389, 0.21208251170078229, -6.982054374695009, 2.4731062045298491, 11.669259800972705, -10.496919465077388, -0.34537517371727522, 1.3153482952621434, -0.64690354364076441, 1.8358237154792851],
                             [-0.084673389136145222, 2.1825820925283681, 3.4178834495854407, -0.98757517127489536, 5.7346018600642967, -7.4502143521862303, -2.8191019415194072, -4.7763467615915971, 4.2546952354722727, 6.2987096683557144, -0.36684700030096484, 2.5326762669324645, -4.6872004377693788, -2.6078499112744407, -2.421593756040386, 0.75865217886122127, 1.3247865837912531, 0.47429235192762631, -2.4364944070450099, -1.3072080288524548, 2.0162606693518956, -1.4819234196073756, -4.9479250514344351, -6.8285049986357613, 4.7685899791500486, -2.9801863007032066, 4.2610936779316626, 5.2330126109924535, -2.0398740659700687, 1.4876100732731572],
                             [1.0977735331500558, -1.2953138365067003, -2.41749987660415, 0.82836297931051972, -2.2735200873365482, -1.0566311749071036, 8.9798458421620566, -0.15841038651510453, -7.1345408748175325, -8.0253613820830534, 0.56200989794658818, -1.7807247977510938, 5.3662275278110716, 3.6688783583623517, 2.5283380002451588, 0.76100963406346367, -5.0943271595991728, -6.3721874427995351, 0.68803591040498868, 5.3262816089098353, -10.238531011072242, -8.1655227565131554, 9.9287874977083739, 1.9996998604156451, -8.5338458905540957, 4.7507041212264483, -1.2985781206808618, -4.1017906826467119, -0.16440484002667083, 0.81415054975056123],
                             [1.8436464528183807, -0.98567784587542862, 0.10478985975914701, 1.2311733626819841, -5.2432911288270443, 1.7274368593808382, -0.45988435645005965, -0.63615676978093594, -4.3663072701649757, 0.79565143986346842, 6.863090147770321, -2.2744794936344843, 7.4196556179096493, 1.4626399068151523, -0.5344296425012236, -1.9969647482415116, -2.4273178373267066, 2.7383980148264868, -1.6525556583669165, -2.3629593831143261, 1.6937680053124153, -5.3669405680671698, -5.7413725866166256, 5.7408093950326524, -2.1574793785707289, -3.009408286202139, -1.3491302602815827, -0.91055687821255593, 1.3963543309944555, 2.6776336941796304],
                             [-4.9037574039403422, 1.4718957862195645, -0.091173615048670845, 4.1649747030691291, 3.7105746143894649, -0.74613234004413775, -2.9895872233409166, 1.8146605303186998, -0.47280961144078454, -2.0615970074018386, -2.4328088758993847, 1.4160691730273691, -1.453292516775895, 3.7447582364336709, 1.4574390535296431, 3.4928193453133756, -0.4671879695265852, -6.8931566390227301, 4.8074505700353649, -4.2998307618456417, -2.4529642066425601, 0.4629495289304531, -1.0392608415891122, 0.94153020200965443, -1.0905853938288621, 0.071318053467850084, 2.5655080547421845, 1.7024570967376766, -2.1807345781928764, -0.027640776788986913],
                             [-3.1566370166667359, -0.80278031049639542, -3.5155650189553462, -0.10249716214691329, 5.876822807884869, 8.1203892581753472, 6.6651177628685616, 1.2080948110805605, 0.52757515164724311, -10.035806682407086, -5.1855276178383951, -4.6855393909663006, -3.3563230987977475, -7.5565339031485461, 8.0569458106573784, -4.8310429197109874, -7.1906294973119751, 11.440278999592659, -4.3656035108673379, 0.61542850401051319, -14.420199725354106, 5.7610336855351019, 6.6238399786866982, 3.0230487795541978, -7.8980725339024573, 0.91161622516536278, -0.90088329963354896, -0.61158073683399583, 1.7277401717072687, 1.3622735274796207]],
                            [[7.9270058260874423, -1.3228232753961835, 19.160214812487339, -7.065237636722677, -5.2309112734242911, 14.373694461318921, 0.64916795895848156, 5.7886061375637583, 8.8352544229765488, -1.2041206935425313, -29.563630893349398, -10.136163876514146, 8.8876018696997097, 11.352988764999859, 9.9409835586349509, -10.820353643572009, 14.144267102385626, -6.9840687929217449, -14.119621430878592, 0.8184981103418415, 3.3340466888256124, 2.8365191816212421, -7.9738859674029783, 0.81607791646303407, 35.880321607822836, 7.9616854497819078, 4.780385393760608, -7.2890180316085846, 8.2143640102213151, -7.6455564183273257],
                             [-15.608006719297217, -7.7953724277759937, -7.2049796631155445, 0.15143767636066319, 14.280181632950807, -27.052199155732048, -21.829342589667625, -18.681216562150219, -36.524490345816659, 15.268657383517208, 9.8731935213315651, 21.009761893122171, -6.694474200560296, 37.860538986965025, 3.1995232892475034, -1.8998310974704495, 37.846597768926564, -11.110830705266732, -33.437862630236694, 10.476785553387508, -35.346949985033085, 5.7000003601300158, -13.933454336047093, 15.119727566898321, 8.5986418043066344, -7.4672535522053334, 29.972991702642645, -24.841121652060536, 30.071566187282937, -9.099975807250102],
                             [6.7069208907813014, 0.79046155724136991, -12.66647701773193, 2.1988031936906363, -5.6724349923183999, -12.068716836347354, 2.6336251109603226, 10.772125467791446, 9.4078830143311976, -9.3915462417357958, 3.3757052597308039, 3.9184149208718884, -2.5180694823848602, 7.7122382417414546, 7.5288818655144549, -4.1120755063332934, 0.066609993619421159, -4.8132221943329307, 12.28599951932698, 5.0551728440253179, 10.105019971814183, 2.9931199085782887, 6.1858719575091659, 7.851149686133212, -9.0619368634701125, -13.630335050322961, -8.1679551578401313, -7.3903655248238094, -7.9337766632641706, 19.749099233144609],
                             [-18.235131970148931, -3.9885875120797816, -23.792725457874084, -9.8880155052185774, -10.669443745923044, -5.4397685815726957, 13.13502889427599, 4.4206780441220408, -1.9177752375477655, 11.211962208236304, 25.417568250269635, 14.285078456841594, -19.447683201428809, 5.4461783325170492, 31.714704888916021, 5.0738663280690863, 8.6448725704376432, -1.9946137563407664, -3.5467928040579135, 7.9858123468557238, -22.514473154213739, -14.83125566829264, 7.0864738809421377, 6.9758975132742513, -20.861784290609574, -3.2103768663251153, -11.898589185791105, 2.6233939815552176, 20.272943521471735, -4.5920760222220522],
                             [2.9755542009773133, 4.1721685135285087, -7.0095570484973955, 32.487156809673728, 10.428340299003093, 0.12607863125170399, -3.3533418021440347, -15.868565409572957, -17.814915972367995, -6.381742572085515, 23.190300472373522, -1.8166244856603599, -2.6043900849283346, -4.3200269166653094, -24.769513005950234, 17.577673362203143, -17.314526180215644, -5.7725265986961904, 7.6419929265923638, -24.243237596168271, 27.82422054204801, 7.6153751329522343, 3.43909666792938, -16.703201864501157, -9.6384690171851926, -17.743492489473386, 7.1565011784203882, -0.6841582639214393, -37.9784405155754, -5.2648908900154261],
                             [-8.4761869300511385, 14.507358218111456, 12.150261301085749, 7.3624029341828319, -0.67899562787165968, -0.42118412156916663, 2.4195132266523371, 11.452087352395949, 16.78989384573314, -22.54691378893725, -2.8098081477982024, -2.1231417796084555, -3.8759619130431084, 6.168381720249565, -9.0691610736132073, -6.9233247235763189, -18.679621921180441, -3.216758583843685, 24.394416991356746, -9.4147671478347288, 25.8337773943739, 8.7221513399524877, -16.040483219753739, 5.4133773177713653, -5.4140441756049302, -15.733914753631588, -26.593597757964762, 9.2505601089944847, -11.969203012465661, 8.1493765132723706],
                             [10.380843477510815, 12.620133097771536, -16.391859255843823, 6.6877093425156007, 11.675946758322853, 10.91914910739461, 11.453019143296833, -30.729922212990804, -8.6268064451584952, 3.4456502056729543, 3.8550687987583334, 7.4189579179614329, 15.539875542647119, -20.163837287576747, -43.524431966628271, -2.5402548902101207, -15.749622937466885, -1.1675485480528627, 5.3000636629154938, 19.505988193255209, 5.5398359398582944, -8.4519587469170343, -10.57614128761767, -4.4115202099967812, -27.303098404340716, 4.1817142931563502, 22.838896159556757, 13.092870940149009, -29.224966307839708, 5.3570605369080999],
                             [-2.5628000769351784, 10.432227846984654, -4.7296441723275997, 22.91104674641884, 9.5107242644562113, -8.7896973247190537, 5.3980317553675574, 10.398250263329384, 5.3883641598860237, -6.9809299919186918, 42.424163305704198, 12.390515093843469, -6.3650642857575326, -17.032253717969002, -30.009747899836718, 22.0744675439311, -35.028783089312242, -1.5242142001178749, 7.46977276676225, -12.246417529816672, 5.4930870370223897, 14.60549291781042, -9.9716031693769107, -16.102046721254499, -13.183013996304634, -25.409471428070336, -4.1558582491001896, 22.84542843414658, -6.13686278536193, -1.7644036492142221],
                             [-0.42132975103616294, 3.9297109928265663, -24.259668008148932, 20.582072859576762, 1.5618060562728988, 24.776639741691117, 11.363159147108123, -8.7200796088080708, 3.8395055736777222, -7.5922684838656131, 22.1912136097983, -14.040734472883852, 0.74254210049916236, -9.1328022688976613, -24.80945136094175, 1.8982957099418285, -5.0069263981760441, -4.0230582454218418, -5.8259138849798076, -18.225222692645012, 2.2066194288086152, -14.030820944622587, 17.675618173431808, -12.719719130549308, -26.825123698838034, 0.44828359385686223, 14.859738982436202, 17.522192592393154, -19.18995681031841, -15.030083406577248],
                             [28.721861364656974, -10.399672290776499, -23.912795742742613, 17.396719468089312, 1.6779529014406629, 14.31056098569376, 13.484553514103577, -22.514970052676585, 0.60032271216809585, 16.654440880982978, -4.641526140331802, -3.1468622355741633, 2.9813037781693721, -12.711779980158846, -27.956401945410214, -4.0596221997115878, -1.1982637169478689, -13.943358789852406, 12.809825931885998, -10.656260086991553, 21.34305482448578, -2.4640462786987856, 26.02544529360927, -11.991514826014788, -14.618366523270957, 7.9274590869896606, 28.090549852948421, -13.436490302416006, -34.008824609421239, 1.7678428916105962],
                             [35.827199853015891, 33.887878415044902, -16.553941508652962, 23.113857491531199, 8.7748221652166318, -8.5396604046580045, 39.041294625860786, -1.4407098182014397, -1.7524315380318352, -18.075762406310421, -30.88973164977568, -5.3769281907111495, -9.1744497983150239, 18.249821526842467, -8.2577714373731617, 5.8845497485980589, 21.845946321979607, -45.384976885362775, 12.988023667844587, 30.09811195845187, 28.256438276221708, 27.329672351793391, -4.5679061816937292, -2.3393369235585939, 7.9031719101684246, -16.426825240870826, 3.6412376295572617, -21.499434668438521, -41.365533357537068, 19.483275808228694],
                             [3.29339817893805, 19.154149987027548, 7.6893917013006758, 23.800888179881539, 16.316426801807374, 23.995119647768824, -0.41238088599318468, -12.502972487433194, -5.3388230319376992, -5.8873427743277276, 9.6613293471128152, -21.631678589906524, 8.02493144661962, -18.423760929082942, -35.392290464035447, 16.869494498741638, 5.5497131864494413, -5.5883899050065207, -25.078402512109541, 2.91165854036071, -12.885051036354117, 3.4897643156265019, -2.7860935303244863, -17.912518362659338, 6.8446028412225237, 5.8643579729780067, 32.876352217594963, 45.465208583077221, 4.5612546426400211, -29.210653681845724],
                             [17.759890770423656, -8.1626046784072894, 16.451029452252985, -11.420986473438838, -14.331967187365443, 3.1940501481532784, 12.416814120492925, 18.463494423780055, 17.752921547380019, 1.7872459079560119, 3.1625369011114994, -1.6369121514228031, 10.681450651398212, -4.6954135396509029, 4.6978270085534009, -2.6546337242322826, -25.266706772948634, 9.5750880718776425, 7.2835704702121014, 3.2737812794085599, 20.941311288601192, 6.2303672950185858, -2.3150740676647841, -11.3413174054054, 8.8892002507561507, -3.9609595871673751, -23.576866252285345, 3.4650470423458231, -13.210230218713331, 16.928748560265273],
                             [-38.869554578531542, 11.3332657046527, 16.119362952620875, 16.547887595117629, 8.7761234216357238, 17.316133658793142, -13.393481212984012, 5.7548664232402578, -7.2433909823063418, -12.147982759835603, 0.75324696006686054, -7.2119774527065861, -6.0427396096431529, -9.2184585438736466, 9.3767148996137593, 9.6373926105951444, -8.3122594280186224, 13.154182011799916, -6.6571282845196187, -12.092161747622095, -0.49229042315461202, 1.8268353951900058, -14.20131393796489, -6.329041499706122, 8.0411345156911622, -2.0732768595930686, -14.584880140307643, 47.513936533324703, 9.4619963150340833, -23.238086007343401],
                             [-24.496292662321679, 4.2992920288445822, 12.525057339643419, -2.0445732065362119, 8.3554024404310834, -8.1631305089319355, -0.64517972325048234, 3.567066264201407, -11.695605813301995, -0.27521227210075427, 2.3252567841924416, 7.5107131125225504, -11.819575343296355, 21.424586677378226, 21.537578990495344, 4.519320279331156, 2.4484339957299532, -5.5589596111578468, 8.7541403080845086, -4.1977676460103197, 4.6482685200913281, 3.0803488557411369, -18.742543762095067, 4.8595752041633222, 9.3435703985651788, -18.637734630107829, -26.869302291960462, 1.7904444541197591, 8.3576495360587923, 1.488759354277251],
                             [6.9491785849535983, -5.0841499720465047, -9.6060212534189162, 1.0058448805983473, 8.2203137635850432, -10.351843666488111, -19.855818298418608, -15.891710142092895, -17.910620062820978, 11.174562052014981, -21.46605908655377, 7.2492239454482643, -4.1856362749749092, 24.462068000458473, -3.2192074432753919, -15.572039356097735, 28.059398234196948, -8.9791832920843326, -1.6720317191747318, -5.8277361409521502, 4.7746473391304125, 14.125891084778594, 4.0802263941296024, 14.764001015888905, 6.6269887521995683, 6.9533100444423486, 24.736617826815603, -25.833844024367917, -1.2657792380521509, 5.9471893990003695],
                             [-10.007620283594864, -29.467647408365849, 16.248511560094663, -24.893481510682058, -23.872652477403367, -0.22646477773196858, 9.6541994678641672, 3.4819141136212495, -0.1354721156185236, 20.494932612729738, 16.619069303182226, 6.6957216641091657, -10.871072970301876, 3.2089020669957944, 42.838669901133983, 1.9763402868086692, -3.5109996980546052, 10.530836795619146, 3.0288485235522877, 6.581259664896665, -10.02779663808456, -4.1303318031987981, 2.9986339308110495, -3.8055531821473676, -1.7164418498713907, 9.9099106528995122, -33.232174316586935, -9.5335188375627862, 11.066032002482254, -6.5166828462189024],
                             [-7.8579225447491075, 6.5018918223651951, -6.113459765758317, 1.910059148026785, 3.1008775136578617, -15.480755562273442, -4.1338816572964738, 9.4867967661293058, -27.517033150440426, -10.251728955961383, -3.4290408186490504, -1.8866020829159607, -9.0764037166405434, 9.8430410052553636, 34.638155547344972, 13.60499616022015, 27.407515562658855, -0.12301639535384723, 0.8262489337208434, 5.8008001521046202, 15.515668492314031, 7.7956157239176544, 9.7894155409357282, -5.687782444868513, -5.3615127926871242, -15.859349219675428, -17.673509643940875, -7.8216601776613617, -19.193363771830779, 27.484027152006835],
                             [9.1430101426271086, -4.3206652803309957, -14.664551999159993, -10.202879613297265, 5.5851549508258325, -1.882213991864006, -7.846672527321223, -0.61290563174859114, 5.0163420120237969, 9.3268384982688364, -29.522353524586165, 7.583101551007517, 2.7106656713110282, 14.184486481486227, -4.7753119750837536, -25.02653152032682, 9.5479379291137612, -1.532576948496337, 6.9515664402940427, 3.1957557001264698, 2.5334913630402163, -4.2900689095411968, 7.0777174558461189, 12.224460708196148, 0.46824948633278379, 3.3292802160087556, -0.28141392621581207, -10.377307767501858, 1.1204240555252014, 7.0666405629909788],
                             [2.7829670737038565, 20.325742484535219, 0.026467971990700251, -5.954680510467603, -2.403016106062593, 2.8428555720287978, 21.67280064983867, 17.325941178479162, 24.568645336939671, -23.833919292181847, 1.2367524797634104, -9.1166820784671962, 2.9975917520688333, -13.271115879819684, -5.2914343780771409, -3.5523215916794531, -12.38281476497362, -1.5194384858574104, 10.20454718728012, 13.202109473323011, -2.8323987791582588, -6.0049598686351082, -8.1226257122322671, 2.9779419394163149, -6.416369492156738, -6.5227065567379983, -19.64267272116858, 10.961173490773666, -0.29246979452411437, 8.96669329198307],
                             [26.657887668914203, 19.435797235506605, -5.0160280085670834, -6.7810460081205912, 16.291908452069087, -17.041845356797889, 3.1493293629004735, -11.418887167111768, -4.3086236752001197, 3.7975468909596168, -16.920668197145119, 11.052986899277844, 11.245345443991855, -9.2593570378501369, -28.237146640639892, -2.2790924006449487, -11.965516485563723, -7.8600981410875441, 15.48286137940247, 28.272946056772341, -1.5058497912755757, 6.5684796788007409, -3.6858246107113173, 17.761078125232363, -9.5338749001531937, 1.5798565481608722, 18.121294398769599, -1.3704434524371139, -3.0024991246913211, 14.758889079853359],
                             [11.499630900210226, 10.155018085421702, -1.7454425171240178, 0.81855671771939498, 8.0567009958499707, -17.566111322381939, 12.964731211140199, -11.118370735401069, -10.851916967299159, 11.763821282772852, 17.589788434257017, 15.234375886248785, -7.3099838910894173, 5.0185692910214206, -12.242271846169537, 12.934268641374066, -7.4549758236823411, -11.786338313527395, 1.2058885810975828, 24.453330548479254, -7.9634056728972711, 12.015009616682343, -9.966860746050914, -4.0190092554192249, -5.7007976703549161, -6.8560178535984004, -0.9920836051342643, -0.14838166465567049, 1.9505026713461613, -3.4198903290436902],
                             [-3.6664418089042843, -10.968271852133029, 6.0775271546048524, -9.841769435479705, -0.91637402156495218, 0.71706396828203023, -3.0122891401439711, -1.9663724380843648, -4.0214002791251851, 3.9229325599850657, -15.446036834982452, -1.2484006501576852, 1.4379228965007309, -10.638576682261087, 17.845093990727811, -3.8776385383205509, -13.670730155242767, 14.294348031194215, 25.450075623378893, -5.7526514574985725, 16.441342642029149, -8.5706877218418658, 8.3242119734486124, -0.9913045897058681, -5.0408387441353213, 6.1201271136287954, -28.239195396709889, -6.71709143737238, -19.592893797756179, 6.788330896833263],
                             [-11.523995394357355, -13.139222634533551, 1.6356342683694558, 2.8836312394458767, 0.17673155629638865, 25.312483435510398, -29.412998644978, 5.0520703916689893, 16.226631989474402, 0.52335783379272871, -27.581327494875453, -8.7501690665304999, 5.4265430034499635, -1.1509002043834522, -6.1822810454187884, -26.562791679565724, 2.7244961558291951, 10.860286847823863, -5.2020162697456547, -24.791370244874805, -6.9089368940958122, -13.171473762327393, 11.991679414216117, 13.958992378505924, 7.1215376371503751, 21.789624163772721, 10.480018777755104, 12.426134293861981, 14.252733383362479, -17.648504478192901],
                             [-11.865134195300451, 5.5001068343888804, -3.7402956866243047, 14.509285590445453, 5.2749261550128104, 1.248541872032749, -10.503742412569807, -0.0040084973696759042, -7.3362086641045199, -7.4297327975390894, 5.6422336835860767, -3.6636193425341212, -2.2895927932835427, 9.9045752017505748, -2.021937915727388, 2.9387831614363549, 10.484084257787647, -4.3344410730040162, -17.116232370387493, -15.357564580871349, -5.8514236416084824, -1.120895937210334, -3.9304981590999044, 1.5139799492700201, 4.2989899287109905, -7.4173668783029925, 15.53663325100295, -0.27103019306072185, 5.4576505877634238, -10.196064609765989],
                             [-3.9239228029810995, 8.2489609440660558, 7.4445994510446081, 11.303143972962172, -6.3697488404893381, 29.169961410795445, 8.4546062390119943, 14.333186068539431, 28.340155514415621, -16.45917578214074, 4.8029555305465745, -25.587427370277279, 12.694109202024844, -17.523032856314178, -19.058645442795349, -2.6850002940703028, -1.1207947329261547, -0.99696254082545344, -16.442256905106579, -16.619420003560759, -6.5941810509871965, -10.330678470842408, -2.8188107414722019, -12.585894487996578, 11.680258094408078, 4.0608792818126327, 19.388337338902485, 27.239679369249387, 8.5241751742464569, -14.389432928389585],
                             [-10.982853171103635, 11.027964848586727, 0.94924162564646819, 15.113992176599115, 12.278989052298433, 14.797956160451417, -24.344000460797325, -10.396048792826724, -10.270132705720112, -4.7111639847149345, 11.233611929025381, -13.73631376823047, 9.1847481503761532, 4.5058391918422229, -29.276401569470895, -4.9504759497195652, -8.9639643239183009, -3.4467001778508335, -13.259961638563265, -34.824070338574877, 3.5913340251775199, -9.5670914749805327, -7.3373228157934838, -1.2644325001219034, 1.2829965330595716, -5.2015605827705418, 20.73977453525541, 26.441179386815548, 2.2435339348271568, -17.183107067434289],
                             [-19.038577713777755, -9.2227491870821794, -0.54033057049507582, 18.506768935869804, -0.26409333738361274, -20.927187622456653, -16.935194627995067, 13.708132342677153, -6.0196104094661962, -4.0773604722279329, 38.888759945386212, 13.513609424120585, -11.970795996298563, 5.0670056274675161, 3.5740322882912277, 20.832641938620576, -35.632529268132885, 10.153989446644113, 13.400634787177733, -40.971490773526661, 12.562359127756928, 5.7567279284742661, -3.2981858982060133, -9.5734746490375588, -6.8858550178655165, -25.604903307519329, -25.063729990549763, -9.0187545711994446, -6.1481898851772661, -5.6830288764125712],
                             [14.248655437978263, 18.445780568750195, 7.6341723496366436, -8.9302297845746921, 3.0175661759969157, -9.392051682853559, 8.9668846943292433, 16.098593089484684, 4.1122381770875567, -24.853703637658377, -11.557872816138939, -7.9836274603537607, 12.378197289805474, -3.2867450136504437, 2.1973245406513029, 3.9488627886816756, -9.0408412828230418, -0.89136581593009157, -2.7126304320082539, 24.044752155572642, 6.5007085515816732, 7.4125089878541273, -17.192378830854889, -1.2666718785941322, 7.0336474094992836, -10.022933644781933, -15.092443188612869, -3.9894034872181132, -14.03427315545264, 12.161012789895915],
                             [12.215868647278459, 14.302201729286285, -0.17310484521559688, -6.9927714146711377, 9.7192452786875219, -21.56162447794858, -24.124869079201638, 0.1509394501318701, 13.630104055224493, -1.2989375238776546, -26.60011968920162, 18.456975999854887, 7.212043895726298, 18.836069364305171, -31.02422171474787, -27.794940947415661, -9.3711967385403199, -4.8494181678576371, 5.94358349525604, 11.49957788483138, -7.1870095977778661, 16.092489416446906, -16.81786499664355, 45.221050984845867, 1.8233503191364862, -1.0094856840783248, 11.741963858547463, -1.997429589881617, 22.825557936123921, 9.7139392621432155]],
                            [[-22.713732811415632, -78.417372147893644, -91.322175747108034, 33.168736277229179, -54.7604177858016, 30.744353664333403, 46.289441884755135, 61.504835176148966, -30.711055747281655, 60.942728437369659, -20.581348630130933, -44.157000003534435, -57.512842823428876, -127.53953760502195, 5.5812041377961954, -29.688109259045127, 69.122783039875131, 11.137141212090521, -39.362514490433149, -64.262180892240906, -2.9119011123399714, -21.833285497806632, -53.962345130732245, 18.712828250433727, -36.748643844492015, 81.150773681399357, -67.878001984101587, 0.51088169762360069, -82.312216872763415, 77.451093822515247],
                             [60.782707125440709, -171.95227462127937, 52.758907185503062, -95.893669987496992, -56.748801715795189, 55.609411352899762, -23.718756891655762, -75.460117603511947, -27.12088399642483, -183.19480441466919, -65.927720583968437, -33.812581557756083, 101.44598375935483, -29.450270559884324, -31.195237348876283, -77.713479818178996, 35.678085904418801, 90.033888118928644, -61.212366346573056, 65.880067442577428, 6.5278745070875761, -30.957672392618424, 15.585370356564859, -53.080171776500762, 13.049701584035288, 108.92437465593585, 51.942024046798394, 2.8889466999558073, -66.253784825725972, 81.02571303456493],
                             [25.431771616160471, -38.207741594029706, 101.57903078793575, 112.1300943577496, 10.231336232641505, -26.205947131956684, 7.3006902185215976, -67.749823065022937, -3.7365972207293838, 50.126203617983947, 73.180068679743627, 48.551011572286356, -52.855864847931713, -150.12553396253236, 77.961191157075248, -11.978219312887346, -4.0132310641356161, 45.685968606492438, -52.008386745510187, -40.488437870765388, -67.973148757880836, -76.53827942337962, -60.837256576878886, 65.182472057012859, -33.000364226005502, -7.7648254505286216, -33.539197114166647, -40.553533884317204, -33.499774129701891, 98.77790452906504],
                             [41.037021290129239, 42.310824704215008, 87.24852400890542, 76.002202575756741, 130.43585267080979, -77.695183542444198, 15.543911338756416, -65.556406023613405, 183.38528822721838, -76.44066902617719, 53.61125775542736, 30.790011552294985, 34.213067245402932, 49.824145463890694, 75.687610882581865, 20.595506377264407, 49.42036003450233, -1.7337415882612683, -17.053526284942471, -2.9572889595008762, 74.20237601146556, 31.26637611381809, 25.175460096337186, -44.434937376663953, -3.9537623091979079, 101.67747809971357, 63.577818899551936, -9.3248087217608937, -39.148466116833191, -60.709790450991882],
                             [-105.00683972301039, 192.81564333031923, -88.638886376691644, 117.78306661045492, -11.033566236980311, 35.640394809289901, 66.281830399489792, 74.423687207252314, -30.22568206128825, 195.43553193628324, 60.809793368988579, 91.617957476563106, -113.97619974330451, -43.861209034680286, 24.232590295063599, 90.967617549352923, 24.370445995906699, -107.25310211988753, -37.632557035598182, -71.859043979977287, -50.403147376711892, 7.7776967915507242, 58.383591846086347, 107.04147700706308, 34.503237637720375, -70.718661503087461, -39.220343552775006, -3.3897552101168444, 33.678645230812627, -68.255680303124095],
                             [116.06690857224821, -18.372097182771871, 31.544410555613059, -100.68050520163983, -39.819576815627983, -14.059099609363376, -40.991939483059689, -69.956044345450579, 28.484588553759874, -19.017010486018094, -66.687868180989014, -69.750493373842218, 43.086572971685712, 50.231745854850985, -37.255130707358319, -74.217193246033176, 21.997265210531367, -21.472452761445354, 27.221305517219843, 102.65753158409589, 13.531858443680131, 18.517946659019358, 34.398631404557769, -67.180362669775477, -17.753288250834171, -75.17995832538216, 9.7183968767021867, -30.664523728601097, 77.384002223033463, -53.396712007594274],
                             [0.94850041800613527, 54.776777689412398, -85.963237526882295, 83.478500408428218, -18.200888907792894, -72.265731539937562, 60.315722639534556, 23.846780302818388, 13.038005883924653, 27.452340576544835, -22.384877144969071, -10.227304918199161, -11.016216597079971, -49.385083152466812, -4.7171645835407929, 36.131438215860015, 81.704502585239638, -7.3343475450505577, 57.845125623170937, 65.940625223750757, -39.732350404115195, 21.705812998529289, -35.699160893341073, 101.05975944995241, 21.457078330890852, 12.754996362193229, -40.856324252287244, 69.90181866424092, -12.949549805060165, -63.012807634379271],
                             [21.272667572155775, 135.23946328642106, 22.622320144721048, 160.48675904170864, 74.456245485504823, -47.982471805538047, 31.343286195604577, -19.63163729823334, 112.86790583471139, 78.57330283145096, 73.697291694054044, 12.770160279732998, -88.808066254979977, -57.617688890673882, 88.493549268392826, 64.930935382105901, 31.585243961842213, -61.577789921684008, -20.92340830413983, -25.34963691793229, -44.507559011467023, -15.622223028658253, -20.516621309974802, 8.7463865573824773, -25.574438792882297, -2.5666431187888348, -22.325463438053784, -67.200209887742119, 24.298739270870342, -10.213801653787446],
                             [39.065821279958278, 4.3734077791166284, -34.176904905936688, -45.264078548611195, 91.321957587518128, -68.851218146140852, -6.6117274955185046, 14.449465513366389, 138.71969745818885, -77.330070002605197, -42.988033712824318, -48.810613747789795, 26.468390477004075, 122.5792670234267, -1.5071461666037922, 15.686889454578331, 36.419749988118539, 21.214972977820658, 67.770800759014747, 37.759712442337481, 122.2202292607257, 83.271295014073189, 32.272920326924769, -122.04096827063418, -16.257877827609693, 61.15655082995405, 60.013452933475264, 0.96639145249540415, -45.858811684476301, -91.564877557027629],
                             [-98.452482113803811, -33.190305990160276, 16.341477423519695, -38.464381413390626, -59.788903282132566, 28.182699606453195, -33.59515338397285, 6.7794619772781095, -50.889397853874684, 83.51138401583863, 42.372810446565403, 59.004021451954721, -5.1411179334029358, 44.151368685220234, 22.968343930458747, -12.61085169365845, -4.9822283420355795, 11.447105145390831, -52.06903535316188, -101.80457824274281, 18.646696020565333, -15.512851358475318, 69.159969745180362, 20.019832185309085, -3.554537921977849, 44.398607273917627, -32.332619440108935, -1.9080603280965691, 6.1885565914763569, 23.103229447300432],
                             [-22.538757160192748, 60.168733373185319, 112.58093377898868, -76.962668581191451, -63.942619532616071, 60.439407541719028, -52.996628558784288, -80.010017273231981, -11.26732534373029, 47.91220281751341, 50.203516448624306, 114.4965226887058, -9.2814378142991778, 60.389168000759426, 23.348107056403158, -25.128003360827989, 30.854904402963584, -82.101609109961615, -97.991376959344493, -26.695744389474058, 18.133003945545134, -32.980681255366775, 177.91101716670337, -4.2107471403634236, 27.256222169280854, -63.63452579316062, 67.255855206554941, -51.564502524260085, 45.309845691262176, -48.977694799936536],
                             [6.607896602892219, 17.91378100839167, 53.521708866846701, -12.711604595115237, -50.691771302316987, 34.551393438268043, 67.769387664749686, -42.963370256582003, 14.053685104025302, 17.015747018012945, 27.343402431324719, 58.935130271921146, -68.824414799159911, -39.981981780576341, 13.211754190943326, -3.6563740891477647, 35.429744657770776, -55.069288506560078, -70.173445309536163, -3.130366211917901, -27.247302750912084, -22.481595977663815, 69.113728337369082, 6.7520191015896271, 2.7829471243283384, -44.985762003262174, 24.922433499365393, -69.563229060559138, 15.425748037680453, -19.783831134122437],
                             [-72.438947345130074, -21.171596973506027, 64.886961473698918, -83.074708176529583, -73.477891368544434, 82.861311432119706, -21.722529808128812, -9.5831198593157261, -98.697697468999905, 61.435577467305862, 51.291997677280797, 71.413552104033158, -57.701931108941181, 4.0216832789208032, -4.0224943657014611, -11.295199587250833, -60.293305486555262, -55.570488038466543, -95.818400387680526, -66.019723291490266, -6.6716053504698793, -29.64167250120563, 90.87136304875429, -8.5906659130471663, 1.0540497581970361, -78.53348247636039, 24.809615378718235, -54.204439497957267, 32.980529400827336, 22.684794720373539],
                             [103.27425164900043, -3.6761774570429631, 13.204587013600502, 116.45020740448959, 41.364373775726236, -67.696323049846157, 1.8858677217197055, -57.833310823756221, 49.010334733087632, -3.4467113941413996, 8.3881703634470242, -29.086161871461382, -13.814747117755379, -83.344088458424068, 34.752754067299158, 4.1478877325922943, 5.5907778003733135, 49.016179288724423, 38.821874598464277, 61.781247668257343, -35.607702862924199, -35.019081622632342, -88.748235376021668, 11.468376818226579, -23.126876210724706, -10.699429424048839, -39.421809030305774, -17.108163394193486, -50.048768395036625, 38.475218262433273],
                             [-64.666328254744684, -53.477683529213991, -37.44478814463848, -18.15609194687044, 49.692456916191816, -15.003417482928127, -75.23610172080798, 87.762853051966687, -36.425508721486651, 69.137725804915149, 19.066461825987155, -18.734077116719025, 28.524117541327907, 115.55978592584673, -13.470846928663327, -16.4050024198981, -79.952296390475979, 89.304629529102272, 101.37887429922274, -115.49760784550404, 115.0002823904603, -8.1935852963868818, -50.303708905340528, -10.196123719901831, -34.265762981065215, 41.083050525802804, -57.415469220133879, 55.389777269019334, -59.524265705324687, 29.63613929210376],
                             [22.98800459010948, 191.79646532705942, -33.540072010516838, 111.49283908847526, 42.621948670624889, -26.416053916067796, 94.229017792543004, 12.158424009740736, 93.957991342758689, 105.27546434540295, -0.80664397856955006, -9.439748932465104, -93.949154532217406, -52.91525959786928, 42.341285090459856, 81.038759210384583, 52.205878609516368, -136.30962336200813, -40.172603189764196, 31.201678758199705, -94.802240437970084, 81.045186578697951, 33.675658950631529, 22.595105621532735, 16.604210857568468, -71.336927188447092, 11.843326142305939, -29.163498261771998, 77.382560197940975, -82.353377046756819],
                             [-95.851622935552243, 122.95058269472311, -9.1575851573075084, 107.92637158858572, 57.35172898154002, -3.6983736344658018, 35.555042916409214, 68.763895814078552, 7.113518614921972, 54.80433052683496, 46.073364628190035, 50.618338496825963, -18.727890458569483, 14.679351775588056, 22.4181461823765, 52.986309221255844, -21.467104183521002, -28.748443153349822, 57.924066031805239, -73.406534117336818, 1.8168661955931711, -44.61059268686553, -42.569220428140198, 118.68495776368121, -4.5625162432065975, 31.239267503427008, -59.505617664195832, 25.97417536707005, 54.216957997678612, 5.8611412184340015],
                             [31.58182042926531, -70.230555670611253, -48.433351632653874, -31.188416578751379, -32.729118293749636, -15.646083676501519, 17.782010761207069, 20.237730308089493, -24.361425644546188, -20.635537214323563, -46.157035987977878, -79.081433577395003, -8.8076908490666987, -59.055232022875309, -28.357481236557039, -36.395298606815224, 37.285043906486486, -0.0021747096327754886, 20.112937328774493, 32.200621947351316, 22.9617722774919, 2.8988484712717417, -61.358567831780036, -18.089354251122515, -38.059292965582948, 23.210040480938222, -16.067207817492324, 15.182160062272036, -7.3600566203919167, -6.0413571290084604],
                             [-39.618963713636312, -12.577137257130975, -81.96510332014995, -74.457049546110781, 29.859865013987207, -16.798207751045314, 21.782063428125234, 98.349326621239598, 11.374282371625284, -14.747095815485478, -42.706736173586719, -5.7746495665900994, -3.3012233645520892, 70.938677218811975, -38.039308072955876, 22.795790299056925, -17.266785207864746, 9.7790730739247937, 44.269282311878754, -12.296272485581895, 83.924204017327142, 97.096906573678453, 21.211272379549616, -35.080227124506635, 18.343269688232525, 2.8458800829434603, 41.943250185427132, 55.286242815561721, -86.056131482977747, -53.495728096363074],
                             [-22.240053451724634, -85.450382414194777, 57.798063656379533, -236.25869776031655, -57.381484759618502, 97.729736788230767, -29.319732417462095, 6.7146834213685347, -29.183741100362663, -132.57667557694117, -54.511945096604435, 12.894903298067566, 47.949924334638176, 113.64593465018147, -75.683761917105514, -73.132997124457177, -64.832023990125577, -34.972347363640871, -30.818007606012564, -8.0310539383796229, 86.837658011168273, 1.0382586261682469, 96.678292745782599, -90.845275797848316, 3.6799370838590786, -10.581507819486895, 74.123934099335131, -29.218673457640769, 14.577236919972302, 0.018107722143200226],
                             [-9.2077407922235359, 101.62318376181447, -97.926363295074424, 48.254527409546519, -62.745408533182548, -11.52644267568186, 3.4037357746945482, 32.910183374276521, -43.335447963503825, 50.991950161200222, -36.054944890975229, -15.221457989561934, -18.7647744328752, -37.125661365434098, -31.758148404319034, 62.432471307537945, 84.098963386691807, -44.70985805224803, 37.534561900929837, 64.779871896722725, -63.116692346827598, 15.108608384875682, -11.584346859990687, 70.688691145180371, 32.018936343277488, -32.96847654356543, -9.2262641681118911, 49.568748459327544, 32.597168349429609, -69.346578623745955],
                             [-40.114743081431421, 13.642059037451089, 9.6324091017835656, -63.857493452617547, -53.489060503053651, 0.98825607025819451, -3.7800979784160544, 20.769591135446028, -20.242393613743893, 18.278867349078244, -19.257829172303779, 58.290700569893588, 27.989114060378714, 58.610452488843997, -7.1409960944867734, -31.984417545860026, 27.463981558598025, 14.954788795725962, 24.80327678617385, -4.7330189638023432, 32.445328405997508, -13.593937943061864, 53.894185003179423, 57.388777765554885, 25.066219273019559, -8.6138944552467258, -16.73866348473835, 39.21406486593721, 15.762931385868168, -45.452657673908824],
                             [-85.348255063020076, -23.405089629340196, -1.3028279061161654, -44.851048668217729, -43.126003507184478, 64.370530812992982, 47.063127906754232, 37.843677817926796, -74.222310898553729, 9.9190211012434908, -14.677541618059598, 17.094202182125375, 1.04627234629542, -30.726506428158221, -11.541720537803169, -20.972542198461582, -45.692463526827105, -26.142257929368295, -38.33432396549663, -51.884554499909356, -45.235812927824107, -26.656965493123344, 0.22105297292802903, 57.151601622602101, -3.9007607150724302, 9.5889288964862907, -41.515646820662617, 1.7182020159614342, 52.070917742313469, 70.109954271034212],
                             [-25.430149669199071, -47.936862313080205, 33.322469904114541, -83.271070876922835, 6.8587920100395454, 16.295884200656367, 13.360775311633457, 27.084719972939823, 18.389760559587828, 5.9856304367677158, 0.49285325906483679, -0.23736059235318696, -6.9956043876053613, 21.977125180205928, 9.4880461925596684, -55.234116624292845, -39.752269960382343, -3.2511409756633918, -33.649841135906215, -66.619346098919451, 59.00859340506252, 13.988356973413032, 24.392266728088842, -37.281204365506554, -31.127420301027009, 20.957080783779073, -3.4543230593116174, -21.574094020225498, -11.711354370951385, 34.983130704917237],
                             [48.160962817491942, -157.96307694155493, 77.799857593353408, 31.296216759874525, 12.141289506008771, 20.430590942666541, 59.978288487852595, -41.809629956255847, -10.749813404789684, -77.107091801353533, 25.080560976795578, -1.3299252095691556, 15.587100400352371, -117.29535293182823, 9.80937761159187, -65.711617162757364, 25.101733081946204, 118.12737963709208, -27.413046529542946, -8.8312390406779322, 0.17604395883358365, -51.969915552553203, -49.4459442362174, 38.404441046909639, -9.805958025891778, 68.895984034848169, 6.6889299826510271, -10.593095897886887, -82.632621145624455, 89.997922908275385],
                             [16.86741859861004, 140.6915952117532, -29.532528039129435, 60.660351967732581, 32.128803165220504, 37.693350223426037, 34.904133565883342, 44.949954214713777, -12.391736076988362, -0.84459714055033241, -10.473213279699381, 3.7710673319802712, -39.43169078101262, -35.146265509057756, -39.891162260470473, 75.961328049570142, 19.674427165336461, -64.958715126822099, 49.221117745887831, 58.99949046558897, -55.107514872528348, 7.1093778697564769, -6.4638728173272817, 57.483397367763729, 36.546346970362627, -100.15620029193714, 41.03011193023206, -5.5986909518440919, 71.462078282520793, -79.672628856800543],
                             [-49.7509711762238, -99.387743797000866, -36.161168904394465, -136.93082705662465, -88.294491074868418, 78.092132604631828, 2.7076503268675545, 35.764147358542267, -124.41484977909057, -42.786424685732797, -63.593889810396895, -19.841679291720894, 42.369222413168828, 2.5275843325728284, -63.683004765967247, -45.647068539045527, -62.950474036555974, -0.32495268721822107, -39.142044353741369, -12.370120852501334, -22.483297279273419, 35.04928511386457, 13.46340353376536, -0.87958200089708938, 29.522407797326601, -11.510084690216631, 2.0917575675782887, 33.295593734147644, 1.3486869465803228, 66.415091575174301],
                             [-56.799165690343663, 75.19820095065262, 1.4684516778576759, 45.737791918009798, 43.839799656208157, 15.789032475047728, -18.271969525145199, 24.446287138382534, -4.6619495850122501, 10.759943255281678, 38.311826642142705, 48.558908649762706, -1.3642568274423521, 36.29622694793494, 1.9023945994606211, 28.09846568341144, 22.995969503866746, -3.6413417097641543, 36.438030630426269, -28.694479952522268, 57.518768103546599, -33.90641845005608, 22.487229144339498, 42.895442388575837, 18.560506923095815, 17.987070963389151, 11.62406979172267, 13.242202952834365, 11.529616870566615, -55.993866679178893],
                             [65.764557060498788, 170.30983955968037, -116.26159068262993, 112.85054674463818, 33.496472659274986, 29.762840291227537, 132.93382144717148, 33.078503785559803, 41.904580988913978, -43.828987976986859, -63.346040780034244, -52.979796511709914, -56.827389958551706, -100.65157679678107, -30.972863798437515, 87.790408131669707, 51.56777324434016, -98.560405394494282, 14.413847338027129, 130.72871882952623, -135.26612032464908, 56.18269809113049, -17.722646302425382, 32.63807063241115, 66.625033902862853, -71.185983509519801, 22.290191498438745, -29.350905518806968, 54.726835179567942, -67.390408788678812],
                             [40.141433200107556, 152.6735054481266, -22.995327959721134, -8.9239502160838597, 46.888354279878897, -11.132452416646835, 110.22812429922213, 38.46056419822515, 63.10462621957668, -25.572443348859146, -54.334171455475285, 28.044646951081084, -33.88395042883117, 35.512822544175336, -32.407130064605248, 55.379837541407355, -39.177578653839952, -91.74550595699823, 53.078070225852251, 90.773705815568377, -58.718095906728266, 80.952326402660972, 37.177318592475061, 38.658218662844099, 58.29843815137761, -148.92469574176397, 40.601185371917751, -0.49144999381002547, 85.14603872221933, -114.74437132630365]],
                            [[2.3243507579970029, 16.783253968801269, 14.648575431019843, 40.494296935982277, 82.262577174905061, 24.252349620378364, -21.738998086908236, 140.32711019073449, -58.244982855353875, -58.665666382018536, -179.31261365001166, 43.126917300411513, 13.075644625147312, -35.230572821323328, -9.594387099577343, -121.98348930283086, -30.612332848167252, 46.783713765231433, 39.583540568866511, -35.014737652031059, 20.514685617126634, 73.758721052248518, 150.09698325920414, 41.380987542208373, -101.46147909084047, 44.780928985886248, -100.2665871983088, -70.363544897666458, 9.7202389677321914, 14.50429420118645],
                             [151.65798930588778, -13.419082517870827, -123.90524254725736, -230.71192325510546, -136.69056575752805, 75.249640829195528, 18.195785727525781, -69.697215697491629, 50.265897271880725, 38.485615242714374, -199.71296520463602, -22.296197180939053, 121.09620139222505, -76.875579506145115, 76.533393537935666, 134.75664440268417, 46.920498791170033, 118.08466055640149, 43.789600317131914, -36.95601791715243, -54.068064158371655, -50.869356117850771, -275.73634821529737, 88.479975272709396, 105.93543623221692, -170.96312641677048, 118.14785624321468, 54.78384513530127, -86.631125029355829, -140.44199879048779],
                             [-41.862688934541708, -214.731211126228, 126.30729614675047, 95.488073794770742, 17.223206870726401, -28.382229956175383, -237.69052914654458, 151.19260275867632, -229.4559200296103, 13.604866427129235, 61.136271565556569, -65.024024489111085, -117.69405321128676, 75.758765719987963, -101.38605179129189, -185.98388621123419, 8.2492105687273583, -108.69974996783191, 88.28564429225132, 80.814310330374056, 40.014390028783282, 11.671695075167062, 134.86810549451567, 97.67215561667598, -112.80389761476289, 103.38785368905585, -121.39970523632492, -88.90877482360753, -22.260863095293765, 150.29765715867575],
                             [10.520609536548003, -113.59864760319118, -17.655184265110293, 30.842105739099026, -74.877434258561408, -24.843482460951453, -142.51645631896855, 25.191021796459172, -96.402950785209157, -0.26277092106800359, 101.42658618282591, -133.6991374207104, -59.324794999729278, 115.43549884132867, 0.41450763423910963, -2.7247789906303979, 2.8277405666933051, -6.0275163607867759, -72.266866244481989, 13.575326541276111, 31.098652349310008, -46.08114440399271, -20.25552642665307, 74.356611036807664, 7.7131859784798378, 26.84226068078447, 35.169664993995909, 2.9626818628431892, -7.7946708435946181, 127.34787082681633],
                             [-41.811919835614944, 93.089411476063077, -22.267765844335688, 7.7985046431453071, -13.871918678491856, 17.611680820022016, -3.8551593821354446, -168.57036748312373, 3.9408437616191936, -51.589394188080632, 317.22918283488849, -34.136049428507299, -151.13580117467308, 6.839186960555951, -112.88681998612245, 19.978925013235035, 62.189600530145391, -82.305053352042947, -191.3547124601499, 34.377768122438745, 8.2166064669223893, -160.19450033404624, 58.939953474328867, -45.943956515486747, -148.58858205855012, 9.7808283171968302, 77.556696718347098, 142.61793106625157, -187.07728997938835, -83.057620991239872],
                             [-57.130831721959346, 97.207350734390516, 58.342613697721085, 95.800384989474253, 43.596689155158678, -47.400092050369494, 21.994433042054936, 37.15498105264794, -54.806686385920628, -29.632404697993994, 24.62462365730098, 1.0538830585823007, -42.880116677420617, 27.536491328920537, -3.6546759817675252, -83.751199107412788, 3.7579843742996064, 5.2035833096524939, -72.081209883973841, -17.795466203327926, -36.054214332654958, -62.557358779982536, 151.20595762492835, -58.731601439106669, -50.763892260441978, 54.809603719101801, -113.48598406366017, 37.645226848813749, 14.020970421734186, 6.4924052098384308],
                             [-109.73477721547161, 41.466676152170358, 7.5653003100812519, 10.953335389101866, 113.75550259877107, 29.484040872787247, 111.66099227406967, -70.78911023393583, 119.31367482840862, -16.964187164536305, 162.75034124038669, 153.38534248979875, -88.877742178298888, -88.114011218412799, -124.80920704328602, -24.41987755003818, 80.874438629379469, -75.297014037066091, 26.616152000966256, 69.46168707051784, -35.696312272134499, -3.6460779608237033, 107.11692484632036, -7.0614890587546029, -151.51469327638057, 43.522811777161003, -24.238309559959028, -11.163147407166942, -124.41343673769259, -112.77395609133963],
                             [-3.2047768150368299, 189.6226862608755, 49.32281906070304, -18.718664584726532, -72.206182411984969, 136.0432179949423, -61.417046359178229, -111.40659247829829, -248.40013124973669, -159.4315042957501, -189.8230835632163, 19.771999127721696, 103.29590201413566, -126.8457856441951, -45.336534097832185, -81.282789696999004, 97.36298670299405, -121.48967953859355, -61.058355392424168, -45.661715145054721, 41.648235718164351, -78.000649017801052, 146.41974935825544, -106.06012974921835, -139.3761415056633, -97.060527578193231, -158.95902775046301, 235.57050803738755, -109.1527582321461, -225.13176351028127],
                             [-18.525292529503815, -25.66193023418203, -2.9459096934689506, 17.71068795341624, -36.412040048845803, -63.621075467771433, -12.878713062407703, -21.362078503441108, 12.472940377043521, 54.067866439715601, 116.62330301417819, -61.699635353487942, -61.035145796644755, 79.017858007064802, 24.438700689398544, 25.732422080570725, -17.013051276115299, 5.4429721128189277, -34.368121349068538, 9.6728874880788638, -18.988456126217219, -24.627776082458958, -33.35828210699686, -20.402075634765964, 62.996035565439378, 29.42532344472863, 16.767595071497801, 2.950763731901529, 31.884042076188742, 96.03561991770475],
                             [-35.011005078314248, -231.76435747188657, -11.121336729385977, 105.64464317099829, 87.763199725682796, -28.155115280864024, -98.423830554583233, 95.533258309330535, 80.506804938656586, 53.75240183078877, 347.90803879283828, -77.635308690117455, -217.46918938804038, 132.57640077616503, -125.22673571412463, -6.9537954785122054, -87.184044198609172, -64.051348546631246, -52.927187276490478, 77.253361691335144, 73.199671439330601, 46.153221935737591, 41.728159131349393, 83.677145497037216, -84.178075345264887, 124.80248364134303, 130.14332235258502, -171.43421722464774, -13.202153831284553, 213.23964854717016],
                             [38.541036177075028, -221.72778418410792, -55.577994710243161, -81.202570180917647, -197.37243958274021, -120.94625338196873, -137.872172959875, -139.26835955856311, 101.79830293881673, 142.37560084166887, 368.00759489440009, -248.19475699272203, 2.0621019390285653, 255.49746635886228, 60.139623401673909, 307.12389639129918, -70.101703045529419, -32.613253231435678, -44.695651486841903, 52.342138405708184, 38.70933849627167, -29.819120125994989, -421.1344789088572, 6.0103311275013951, 312.69932169929893, 14.998522942405231, 373.02066634896528, 22.216994812150823, 105.8403429563563, 202.94706503772724],
                             [117.05703195940117, 149.66325741950067, -108.3576274185815, -158.77034939497335, -79.352199799527696, 50.842076961983203, 213.97074957284693, -194.19363070918877, 199.56050219339826, -7.6340200650409713, -105.23657659590285, 117.04600681873241, 112.65570024578449, -146.87945551096212, 58.599007201364827, 194.47608696144937, 42.567288880150471, 106.20668565252802, -21.257843582963122, -64.687340359801624, -71.832497549597221, -88.035284595157648, -218.49993765199432, -17.054368164663522, 112.98105789899097, -179.49598820949274, 153.34538224166187, 124.9160438848304, -54.010061343911268, -227.45141230057789],
                             [16.369771150065795, 96.638569584542296, -41.71309793545646, -52.824525547812208, -142.21503729012576, -22.316543522579956, -4.1967498504150527, -187.9693305591241, -19.523777989990656, 0.90161509379461435, 82.700221737039612, -119.80810908870933, 101.97618137554284, 58.41146460526933, 103.6255862632008, 145.28680407318598, 23.063839656225998, -26.880392256096677, -96.300261357250449, -33.044542424193196, 4.0191580766935457, -70.964611872861767, -153.70847231887322, -110.8023737192982, 175.02654783360828, -102.1149557838929, 107.83480385526668, 163.65320395242861, 34.128486247421961, -34.817500030182345],
                             [12.114143908783991, -235.87508817994561, 67.876806234197559, 35.193998088770734, 17.07397485888016, 39.914497576472542, -173.70921177275807, 203.38582225216049, -136.00085498548819, 8.449052073122207, -191.7761555057408, -45.335842026962411, 97.094481715771593, 2.5075407626222641, -4.9468717824770287, -107.29548326622421, 1.1208873772003889, -32.275369532405016, 185.52084048621049, 47.411415269508154, 35.005646518660804, 135.20770377755804, 32.367277467072824, 97.575319258378784, 3.9926858209060327, 5.1960691090593194, -89.19110199902461, -144.04070874923829, 67.065222937053051, 116.42740310107983],
                             [1.1500519834970362, -160.5142109454919, -71.876084230285599, 46.207028660371783, 96.075263257225629, -97.839123324895709, 26.498584142377585, 51.787107673576472, 233.62628800292904, 137.88575026798054, 405.40980927226724, -32.947484643239413, -291.0440256626124, 116.01811606027833, -87.90524044245312, 42.646238945149861, -101.70350352612145, 51.530781908404926, -64.594370414384201, 68.011788098419629, 8.5670667592146348, -1.2421522756036252, -34.59790814052225, 93.11530449941823, -43.670063338970323, 121.02209901711538, 178.16706191214081, -184.63821385831275, -25.186221451602719, 218.76729821985839],
                             [-15.74962185346314, 32.49494758456877, -21.529899024880706, 42.959424614208871, 102.06420272143401, -14.269715089678819, 52.557700656922506, 65.48753628596657, 59.954214124455191, 20.309951694528941, 97.638514740866412, 12.441844464497059, -134.89284833725341, -3.0728150864260404, -46.781198874132386, -57.696486042377899, -41.052764179957521, 29.826963014516885, -66.592801080036153, -1.5816810842364912, -29.506586400140936, -15.4258096955577, 120.31821235104492, -15.499998409604808, -110.543610972029, 79.750504493328975, -48.864156607201807, -36.011939584588248, -26.635953607847757, 49.354856144843723],
                             [-34.151671743756104, -145.01550311737927, -38.181918986777937, 23.818978924552148, -17.261008729205503, -145.36598810978333, -39.715644177044751, -94.056892527039352, 142.77613429372687, 159.02999508423531, 562.91730255812956, -139.45483382993157, -265.54143102308342, 234.27203710626841, -42.85976394224312, 151.91874197919378, -56.171538116680338, -63.169502316231231, -127.30619019427533, 65.20870536392168, 20.893401425734535, -107.44280418978462, -180.60200823840512, 59.863646857909494, 98.976807180047132, 90.520760875244846, 237.84450749888654, -72.364067276403176, -13.653318712378219, 164.45401336681564],
                             [39.638070539613913, -83.605810623950276, -51.281936068726829, -63.55684150932079, -52.269275054054546, 75.272143521201087, -24.303287728515269, -57.688911673127585, 72.386286410195623, 2.6917981197156458, 43.087303083875348, -10.253189475287666, 30.747971573097651, -8.0756734080195169, -50.997554110696335, 109.90665598080301, -15.048234949417436, -36.800351618432842, 9.5209398018457421, 24.353579455729726, 69.913208869621911, 46.461701912833654, -127.1319122783118, 18.709991601828218, 20.254578613161314, -62.779932351424037, 143.79397487745501, -22.088623499672082, -28.599070923388702, -24.070393628807821],
                             [138.14226330271237, 57.210595956021834, -81.915524864202311, -81.206214063181221, -17.416498654385354, 139.58747777150762, 50.373200813314114, -1.5108850624518695, 24.070831633392014, -134.94523593994478, -272.38979983392176, 71.392251396515519, 131.99735920260449, -146.37325759100798, 17.16241995152409, 20.492104770922325, 2.9725730522034586, 76.227255186036032, -9.0393901230153055, -95.961448846792777, 43.526212486871387, 38.455391689608945, -15.335944206935196, 55.853107096227944, -54.388726045125217, -131.47346640388102, 61.462867292601047, 30.013224624894981, -100.04704924767842, -168.19186004480878],
                             [40.420604097611715, -31.681919861436146, -21.985513862351336, -42.878968120497731, -35.147877495369748, 28.686266847058594, -96.577055342858358, 59.917380318288956, -117.94278313825387, -28.876579996030014, -140.27228185414958, -58.096917861213207, 23.345788663748028, 13.214739859757715, 25.242268534594903, -49.957430056063345, -5.2296342931187336, 27.770698265165226, 13.781100952253547, -30.527311714680913, 9.5567848346642759, 11.914725338219299, 11.165433738633599, 72.105563218817011, -33.556204243511999, 15.467316364743006, -34.690293033966491, 5.9069817298470877, -16.062593948289727, 1.4877259944409236],
                             [-145.61187881860826, 206.62296259163935, 85.219201757009031, 167.19119718581049, 234.65967030577679, -57.215148876530961, 198.96051677686245, 85.765496223503177, 40.129614294718905, -18.709201561147271, -47.255972402764215, 195.99068612702379, -66.019326405963554, -63.942624219317182, -16.187945895971566, -178.14741038401101, -23.549975178015064, 4.48544399057036, 44.426091676290568, -28.352969300164549, -39.130404473501734, 60.672876052102232, 317.41434228398089, -78.675975070527841, -102.60129852140828, 108.34455918183835, -250.88158604213248, -85.377387972167639, 87.049708626117919, -22.326697807174455],
                             [67.649709944734497, 388.42111678548463, -11.408992187807442, -46.727905662571466, -122.99529745076973, 197.0542114477864, 52.25159198737903, -253.35961633979872, -179.414436753839, -294.50318348115923, -292.35242468193331, 46.679053643182542, 281.50219231897768, -217.71791823634692, 33.673706775534924, 24.013860279118369, 118.78822569923011, -61.31240820312982, -177.6769350811939, -132.43621559329068, 90.698569250630541, -96.994055410916019, 104.70416140869226, -202.27411324192514, -74.968403506280993, -262.70871461255842, -53.599118285484394, 356.44470831240693, -141.19202611926659, -373.76634487631998],
                             [72.61886630032933, 58.615588809268566, -83.744142915374084, -108.91027215521834, -109.44721214242011, 39.820788735666859, -3.5797403001250032, -145.11354584396531, 4.8207068529055661, -22.81052124865543, 69.027143064541363, -45.722385080687431, -0.42033324069401345, -30.514382923528419, 9.5373671354396237, 105.38358663038127, 58.942733893838138, 9.5121093430315717, -99.291538902348222, -23.409914464454999, -9.6849532481209231, -109.08297951792314, -122.28025022863523, -0.26492182963162136, 9.3401495866782938, -87.514116808674245, 104.34168904621345, 149.99176241940523, -125.34525566331796, -85.102070383881724],
                             [54.830324115346265, 35.825199628529404, -84.104647291418928, -68.717184163792965, -5.6803996057158628, 40.06929295842248, 62.15175031181392, -52.397551935837313, 87.32719664928922, -19.189963217573371, -36.597455462499425, 15.212093640440685, 21.685821111819745, -25.557437262515698, 30.681901312718821, 66.889254937626205, -11.651002448568384, 52.08124390462261, -35.821440205098931, -35.44164682068245, 18.189955671263693, 16.973903139122726, -72.583214854713773, 30.719995341326076, 13.970988857214103, -75.75370305549697, 70.107960279449614, -20.748376410178903, -31.46688438147385, -65.168114286135534],
                             [33.700873117348017, -207.06762824334413, -12.331352046273237, -64.105008373530353, -46.774682260959672, -29.119752189045723, -106.71412067604314, 133.97906354465013, -18.351038977429752, 112.91162099255999, -92.010870877544917, -49.66180347946699, -3.1669091173034225, 32.979639118816714, 21.181507296140829, -18.3919492983702, 14.042625508440803, 81.421458944107641, 140.59101319257573, 60.994269858001971, -32.755520786979915, 55.715183828157919, -105.97361891116839, 134.80834752065687, 55.816149556436883, -5.0442381802754888, -15.418795300337081, -149.01615098155128, 19.578680695868094, 142.14784531590595],
                             [-123.74836822971551, 69.483905992854901, 27.139301056340472, 52.612543385950673, 96.987994940031925, -103.53509035280794, 167.34225653694159, -31.153263989264374, 169.97388761908877, 97.948531369723469, 164.21524761681775, 87.311960626709961, -55.822877039588214, 47.527868940302731, 13.356640511189443, 35.198663520752447, -12.600824008619792, -11.881100344165489, 33.818484587521127, 29.518241841171346, -66.513355331346659, 1.3576437486734108, 7.125998977122542, -65.038607000977692, 77.121021390333823, 91.941273151149829, -9.9215836062365739, -52.902102525388329, 90.168414794200643, 4.1972508443094574],
                             [90.499207268013663, -109.70327135482579, -98.355411317835177, -149.81006669266569, -95.061839275330641, 23.800684477808062, 21.008901553947961, -51.701191293913062, 87.976569375462688, 61.77131472070397, -99.056377235150364, -23.06082989657687, 101.28975857341308, -25.019887848472155, 82.911955532192508, 130.25823488651932, 22.381329029913413, 78.102601172986752, 99.350244003084526, -16.984726038341851, -48.094253534504951, 31.130442167843661, -235.50207623034859, 79.93038669946759, 158.0954190720955, -117.7083553980965, 124.2500173737685, -20.058825937507912, -11.432217591455641, -25.492141157130963],
                             [-78.574291519901635, 285.06435380813218, 66.296126504163567, 51.744863685924287, 25.306264081298366, -43.760166959629039, 172.20430692890247, -121.08509119053912, 32.145594222295195, -29.988439364002293, 10.597606289425233, 101.40186465971701, 17.927798048266673, -52.464248101765776, 31.106327400457726, 9.5271201676146688, 33.213574538421533, -23.513303735322886, -94.61381236434552, -28.017411975561298, -52.483968298810616, -97.328740232769746, 85.621937420221855, -185.81249887488866, 18.280905066478184, -16.545676769541632, -110.54548187967082, 134.97647899611269, 45.215469092616644, -135.41231368316039],
                             [-37.177830592037488, -19.807778941588488, -20.357521852573189, -49.845005319016572, -5.6546523770815398, -160.82058983048148, 128.82534782382933, -16.453395580369197, 173.55321596831297, 207.11079353319627, 111.76036961476788, -13.293261404028101, -64.692129297951539, 122.12579924282535, 115.42420625055344, 140.8291860552651, -50.903344342975387, 88.795738507785316, 40.660811501730628, 15.830956475273604, -131.54114653781079, -23.413762252766368, -213.88539495618377, -5.7696958589508114, 239.42103390355274, 64.834613062444845, 33.037699743253398, -74.421758443304455, 174.34839823364268, 92.871281575354246],
                             [-229.23856480767211, 176.34321403444142, 88.508427501786542, 257.87342210864233, 211.57234761042005, -48.136296120456443, 106.30113123982132, -32.390873923325444, 12.215617498737117, -15.149949007671836, 412.33230607778222, 87.004255144317895, -305.45021848586202, 44.306344616094599, -177.29385029605601, -159.16988557697525, 2.2675875207207765, -162.51085786644984, -196.49150085949546, 57.760934426969584, 20.264170410279281, -86.880012547044899, 399.43396514025846, -143.43571993608239, -259.72296372056223, 184.88992931770724, -192.60612930038116, 8.7381667294897483, -26.970606913891842, 23.211634981844078]],
                            [[247.05749054015544, 325.01652068893065, 56.374944535170798, 345.5253970675866, -55.742413524299742, -94.408555702671165, -78.817464133935729, 195.27627961056604, 384.58190545636916, 271.10803415056751, 198.81533161104039, -94.068755667172482, 93.660171950401548, 109.99976863173514, -287.38398420390286, -392.20704232246419, 22.899867353377878, -80.735872726364121, -313.04420570074996, -246.30424905302584, 100.6807532639276, 336.23316255896731, 257.6374384563137, 148.99099000386008, -46.482444053765377, -125.04294036956308, 44.197781220462886, -206.94698913122321, -79.204659150950377, -56.649099752822799],
                             [-64.331137294250638, -229.30291310439574, 67.39843394103454, -279.12714986455046, 40.12656379511688, -149.76567623257822, 30.224304505090902, 16.351080097218365, 186.25564014282051, -26.033849161093727, 229.65940049792732, 75.888282130664948, -44.140542891330583, -210.54636827958325, 29.54495228035163, 197.39041478010384, -292.60910665480668, -391.46275936474609, -16.822899383306847, -22.572990928235818, 42.140923061770344, -21.733364265929875, -198.65623084391905, -34.297636753755832, -57.430862945438228, 316.37634830081032, -104.22250463973336, -117.90968716844012, -43.381938091529996, -85.822917455491009],
                             [-128.84495456862584, -175.38371049578052, -19.074601931971536, -66.261669052511422, -160.50814321493857, 203.07156133065206, -29.000476216422822, -61.953053177886893, -218.00808217079157, -1.0613908238502523, -157.06119669121537, 37.939192889240587, -162.0241606815959, -4.30535471492533, 134.38835741746627, 55.430995424645154, -185.2487758012285, 64.442292394127506, 207.23736960923171, 10.774968178023961, -76.544667843095866, -29.506745771974465, 71.308523506304951, -190.86484502687017, -37.67996380495142, -65.381033023389307, -14.493563632679487, 66.611167744368146, 193.41282241185044, 285.24920318738151],
                             [137.62177289946098, 346.90575299970112, -79.110262044767964, 265.7749793136278, 79.513947387862103, -73.788950735521425, -94.534883024927979, -44.297952791711005, -94.659333748007171, -248.57347805265292, -148.71683416584375, -111.16087116738109, 63.67592927465018, 59.107602545714975, 143.63558441058402, 34.498620625380347, 142.40360943464913, 410.66165665709059, -26.667871919079577, 80.799465418804104, 42.145942178215833, 11.664717869823729, 286.76581473961022, -116.67252879495234, 46.136055261404806, -308.78487954058454, -51.928668336377392, 159.81941476670542, -205.18716991324825, -68.773920490974518],
                             [-17.955696502545234, 20.076608508623249, 145.35902463529908, -59.857392402691097, -68.097707345565311, -142.77924727964583, -75.530608113468361, 67.327249553084258, 339.14408302662446, 64.002250031683545, 260.09158702842444, -5.8607397921290962, -13.450354862604451, -124.83035725214857, -66.3925299069369, 58.025705010529144, -343.91220417758723, -326.61448046895845, -144.32003847283693, -140.4841203753501, 80.387539708041501, 229.05088788594608, 41.341267695884298, -109.21476444698774, -49.416149578269689, 288.43998396994175, -46.555286230357481, -188.42437954598012, -146.92236015705339, -78.839078718634525],
                             [-49.438378691851177, 254.6389744285126, 182.07589817149014, 231.2929717973939, -238.59107861705795, -114.27595938786278, -123.64101533421315, 45.529851412714571, 276.64769696288636, 122.2955115541189, -81.470729645929524, -56.049180893630542, -47.002328678784487, 104.66664382106106, -208.79982100870635, -271.38999423278136, -247.68417966055546, 79.054060162076368, -133.68664192501734, -203.72854254327257, 152.52023318053435, 150.34489575522377, 312.42409570750414, -88.416207706077131, 165.81764893220921, -260.48524390802595, 58.146408260596658, -68.431137089215113, -50.991035181282463, 121.0598630044894],
                             [-27.677134806780714, 162.16636639970781, -68.5263421201753, 159.60946667165257, -87.15199085276484, 275.86223209572876, -62.745490534083288, -57.526542806668296, -492.11361368625683, -61.815004166779303, -514.45231120689925, -29.54752142415364, -137.39998819122431, 337.61526414905825, 131.48439450880264, -181.75102035678859, 242.45765819903002, 610.38427509636892, 181.09759657999132, 45.171984894602183, -65.784256547972774, -166.89680245051863, 134.45690723649309, -27.035740046104571, 229.73646028626763, -433.62005420141554, 134.21456601883577, 263.7809163493946, 280.74881637864183, 447.62066028050043],
                             [220.94955135050847, 289.56510871756058, -188.98753668465477, 185.99776541426738, 45.536965027968215, 111.6276192198831, -194.9321845919157, 57.372091911284144, 55.366505899155051, -122.44388265665684, 86.123442156787831, -131.17581781186817, -4.9500036214731304, -77.594929513566527, 85.972433580548397, 20.757304036762065, -28.580261022297812, 55.751637480293589, 13.142166094154073, -91.405464123092571, -37.826675263953554, 219.58816954253595, 337.50254108186869, -112.39722849151187, -206.78860440330075, -78.789405031702742, -121.61854683068995, 12.585568392533396, -97.809471528249688, -10.206403690124185],
                             [87.797809788076336, -0.50422238325827651, -73.425219304819748, -57.799087925223354, 56.629521363024068, -2.255592708210163, -73.103257891632197, 32.241773805469144, 18.78313972591739, -38.218934675267143, 139.14034483397896, 33.188879787388977, 40.334675146362443, -53.626261466135972, 103.12348176004025, 20.12057902990227, -40.343659129027287, -102.40399726700237, 5.5047113146670723, -30.481636906068701, -81.561693125610873, 21.715088048864452, 7.7666380391441576, 57.896372751729785, -138.00215888279124, -9.9180227821982676, -20.011378516272995, -68.872613783754346, 56.55987161675391, -68.136503818786565],
                             [295.90806829876948, 220.15040300498686, -137.39662471608801, -3.84691187164574, 127.09850811263986, 204.92919591415756, -156.74885076952538, 175.42482729794008, 1.8103765586455289, 131.13385674669237, 156.46730032080089, -66.975091919403937, -27.690185561185814, 131.15157851035039, -79.94490008395907, -171.25862307900115, 79.005593836761989, 3.7479637122909901, -39.360156242586562, -138.29218126934884, -57.036785470183062, 212.77773706442287, -14.723091242605093, 219.30725888390421, -102.68286630236693, 39.241844359912434, 23.92486682489448, -18.682239564138836, 146.52600098851954, 93.50704898644571],
                             [586.26600292011062, 181.82399215871553, -209.72496577824614, -55.979619177396884, 205.19391158914408, 377.02338772845098, -216.19481064309466, 406.49851285911097, 99.518329958583834, 249.37044073048241, 521.28882844904558, -20.648396426510235, -31.917034963877143, 217.00018474039695, -73.560200223693712, -220.04900355720278, 13.085940558889154, -263.76918627019887, -17.573339892398959, -297.24873919083637, -117.85820145134598, 472.33707624717613, -11.701185364222816, 344.67777113109116, -363.18315720228765, 227.97556993488919, 14.697082175621199, -109.47463102812124, 295.52227892661125, 179.43986938765951],
                             [137.55714310949446, 109.44408896276734, -180.84417740098502, 19.518382847736188, -11.735827462646935, 176.93460647625517, -324.63739588067358, 11.216601477120099, 184.47157938315351, -182.28356472508736, 301.06489897367783, -126.0646240451446, -63.924040695316243, -373.78557241915075, 215.45584583884943, 204.67903700987668, -522.39689214355872, -226.06802483450988, 79.530746152205168, -91.745010839450032, -38.951102835467353, 449.77768354490081, 458.54573478676269, -350.25519480286948, -423.08062859711021, 151.996700586006, -330.8965768347968, -127.79927584576187, -145.51533058761797, -66.251918026976881],
                             [-10.823705572019259, -435.5205637931586, -104.1897365098292, -443.12619072100426, 95.839009108901024, 53.914362309427027, 107.7987115934696, 24.298228947381659, -110.72155811778472, -159.98913175310889, 168.14247568495489, 118.72666560159608, -103.10069406182375, -370.79936489637674, 356.30257287757871, 475.68986557164243, -264.17939090653232, -405.33399237048201, 267.49374503684282, 101.60106755203343, -159.62951913567684, -98.868389176607366, -256.7970298032252, -124.73144419283803, -240.49785809359818, 336.12187209011159, -222.06203505218696, -2.853747169430835, 171.46088125435219, -20.858146142631995],
                             [518.41805290493642, 203.49888353308694, -133.52327624669132, -52.09271726980721, -24.789382499290305, 249.26447232024975, -278.84427828833111, 349.95434198959862, 139.85929347637128, 216.85446296201076, 386.52429100124999, -15.227017270066277, -137.60211595098224, 25.231091068949418, 116.60183762809356, -151.45939333864681, -317.2256523144481, -277.14034251600918, -24.23886725826496, -406.17301321017288, -162.41996790460604, 490.19691409138551, 191.69255653344399, 100.09511694794169, -388.52686367088268, 28.487066034871223, -66.469826412521172, -154.08265114528308, 403.27121464645779, 289.07277737419537],
                             [115.43688257289791, 35.417421395066953, -9.4928724830452662, -93.107944148502256, -42.799575592603965, 118.8204154848558, -124.37613261964533, 106.73267378170149, -47.295280231113061, 80.510995375157535, 34.50440817765341, 49.108458321759656, -116.12030400952629, 90.688726560165506, 53.448007058019982, -60.572880466980713, -185.95659567124977, 34.821317033167276, 104.00826011760878, -132.09949913029189, -76.329541939497304, 95.777729235562603, 13.845444671557612, 46.07256218495548, -33.839722909002475, -83.882069877773716, 34.842013602789116, 10.187823473836785, 269.87661378123698, 229.42109011749724],
                             [470.1573446687957, 247.40240785752161, -289.65699018333942, 39.855003235580313, 190.81591066527986, 464.53691358527954, -225.45324338262961, 233.06307949729447, -214.06109209812359, 162.76458085206082, 187.38624890603859, -95.021604235658387, -113.25532163682891, 338.83425425150693, -26.041787741645681, -192.28297844382519, 245.55363382205812, 139.17049605317126, 43.163904391227391, -164.91207935887894, -105.41151248665993, 268.41077668380183, -6.0538327157924918, 258.90372066964841, -254.51625329917002, 61.132114561058025, 64.854446196868139, 115.42736390258112, 271.01235335653604, 310.65122707567963],
                             [151.16421383719569, 228.34130576100284, -99.476037856053964, 206.43815902827222, -95.546239623740604, 124.37691942688259, -278.44698698113075, 5.5157232744494538, 160.69059125478304, 49.778885775427767, 129.83968574122724, -109.86243278218159, -28.200408703264401, -74.816096369022986, -0.95101060339964005, -109.35055106696996, -239.62703728145945, 10.286523536433977, -68.240014581631598, -226.31319593477534, 13.987087014182523, 278.49165653454304, 330.48102799660757, -173.29917130764278, -234.40942811209945, -91.167000320843925, -90.481634038131176, -70.117797103619068, 2.5336478260499335, 28.679895667792511],
                             [-7.1695228710636147, 235.65169467953868, -116.62476263423561, 175.49232999309041, -40.801705746657269, -13.948035542011667, -183.75507906659629, -137.5307865338707, -51.741871447748117, -280.90164331682126, -142.54921084103907, -126.73269099441553, 44.079280604214425, -196.51634382515692, 210.33906295351906, 109.43244257650834, -195.13755708672136, 231.57414290271541, 57.827205377553483, 118.24540903700459, 7.8156795847048528, 90.596541874748652, 479.02218959381725, -283.7254416938876, -67.52451072115511, -304.63785896419142, -210.11405682114153, 79.313051259501876, -222.10651783782623, -114.82444164741085],
                             [-351.16835311156979, -262.42828356968175, 285.19496622926721, -25.300184603272868, -250.60668508021504, -242.75146485465206, 186.73808672915607, -99.435100734315839, 272.29457388028339, 181.40172947455019, -54.920969294706708, 109.04903090817461, -4.1859433409095956, -92.33350575808403, -247.49040907104921, -29.406094511521829, -196.70328444192964, -193.96148759993523, -29.119479511008574, -56.49477714640711, 95.619088647815616, -116.10272274992921, -121.6877588225038, -74.548924718377776, 147.59367259525234, -0.64668152311098992, 66.199053699865814, -115.57750181876004, -10.137688963316073, -61.851290132517313],
                             [140.37332028940585, -66.09891154855741, -77.586883828279582, -46.821171242096369, 156.32059397287401, 141.88776661256796, 16.403714753897955, 112.73952466205145, -97.488125909426117, 139.77999403040135, 112.97431738521423, 44.133684897219965, -30.363586854894979, 206.30313227137711, -140.96822325358943, -133.87276766743537, 261.12025193301827, 42.712145732454552, 15.473583621848309, 13.252495717513257, -38.475276809251042, -31.810362276652107, -208.42128856241544, 291.41108933380673, -37.60761673708879, 72.761786526654518, 116.27872428466404, 4.9567107508223947, 96.541190744932692, 59.518897709043941],
                             [-64.784256651900336, -85.961326413689193, -65.694257480280299, -127.74423125311073, 23.218633189405651, -14.964913885059758, -34.970813018995479, -86.746217635077372, 61.129198407328886, -180.23576397829106, 143.57143032139865, 19.346473720107674, 12.038784697156593, -191.06354257801326, 105.29190576044674, 228.06936899499621, -240.63826498385043, -201.49553774838751, 78.610108127701906, 21.784153752187926, 10.877042380113481, 43.927016666650111, 59.028098854297035, -202.15450913632483, -115.43552179858547, 156.21468507290808, -134.90072907681352, 11.40872917481034, -125.73844666480635, -93.640834808643874],
                             [-167.99658368704598, -46.391481980380014, 2.29623249137265, -126.25579519597997, -40.777014563425951, -95.994155523777252, -88.213572030107045, -91.949248240354819, 94.137109085989835, -217.39908796952284, 25.216627531423139, 2.8253609095442243, -15.262377883326581, -285.53824928494276, 193.4047779631486, 238.08538694310298, -371.19365890701948, -154.03059562825661, 83.72034928108863, 20.069086727325232, -8.9925426701862445, 4.3605477700091013, 123.19118963690219, -269.30276378322253, -20.491826135383597, 57.111176944923578, -162.46490733064141, -64.554593072594059, -83.570741443821774, -97.71925982672758],
                             [8.6306241029081665, 160.05996013397996, 155.83855957111558, 180.08968126740652, -126.4300853137247, -110.61401272395611, 26.152310301957847, 102.39236797767853, 204.60060640434915, 267.38453578371082, -40.550470774339082, 26.575320569409921, 18.143207057219893, 248.96190987931428, -333.20213844962257, -354.60933860728136, 166.51422861474697, 58.622691499182977, -156.74753379997355, -213.81457760368045, 46.260132764441174, -33.269665513913566, -31.757094837197727, 215.76144251447059, 135.01358598445404, -241.61394408000555, 218.52290436222486, -91.915096346588072, 81.757084730356397, 33.198201728128019],
                             [562.92875321159408, 117.29935331146838, -509.00246387358868, -81.045847422890745, 384.19347289221639, 442.12065240881395, -303.00780963889929, 98.625056194385451, -338.3474784897723, -260.2548522002939, 324.47698463590484, -112.90008035118127, -52.08005779784704, -55.276373268530037, 445.82419484480801, 244.36243594471975, 78.323426495152717, 12.455841431608603, 153.3855994791715, 1.5114769443688179, -177.08015467486072, 202.25063397007142, 90.285334356608459, -27.451967700155514, -552.21322403126157, 201.91423875015332, -243.37560278851333, 135.1064422484867, 98.202774696260178, 62.507753901017999],
                             [-149.93713350327062, 135.46439066750639, 34.426019399142938, 143.37211385030216, -183.53435353623925, -23.442624258333254, -123.6071028822019, -63.816667316214222, 29.15600768357735, -125.47053648643424, -184.54968520131658, -1.9203784417216725, -46.734633160304291, -123.67367924726067, 118.61294790197965, 12.374685179666153, -292.81755648509176, 176.49973731527678, 100.86039353477356, -51.45932789497131, -27.392429857097497, 61.684522706747252, 345.52432254763767, -269.42625801840592, 52.049371182911059, -328.57299059221003, -56.755820817909665, -5.9212954364482195, -1.4753343047394694, 92.556722750439803],
                             [-218.03539141591102, -215.43562069984671, 225.41177047566649, -51.692078658461725, -143.84451229522065, -107.42383438095061, 201.32841115789512, -7.8447410580338559, 49.831010124101063, 232.012929997263, -75.427615979146125, 146.43961049671213, -24.717352381351464, 115.18616229683919, -190.21267982642991, -106.86576924774809, 15.825101447352724, -5.3729267192163839, -21.68921775875539, -46.316559486800159, 27.56994098809588, -111.38837053913689, -278.77641264741555, 90.19489289947596, 227.76274311330448, 13.310042807052605, 200.47252130288223, -47.090111789752406, 172.29129971365259, 104.5997147271582],
                             [45.280853087125955, -253.95795472120821, -172.56685906969253, -232.93644086096532, 278.70706744406596, 69.90081278364076, 157.48980669980295, -35.229755759894907, -290.61106406530502, -78.77378646945364, 9.7147698519409378, 59.842875258615884, 28.274712272071586, 2.6988296131443095, 85.703146435438384, 176.96945376026437, 340.09477332393971, -20.621373008921317, 117.9621447933873, 232.7063573881511, -83.555074594956707, -289.1356478979306, -395.69014368881591, 208.98806362307079, -31.374449470127054, 187.13210945650292, -10.245452199765442, 125.75421913880433, 41.678724340495052, -80.166399920590138],
                             [-273.84742268943592, -294.48670274598152, 295.02551295723055, -184.70796550813108, -66.79539753980481, -389.84455079295725, 261.45390357970581, -37.314430956689549, 211.18993105280336, 121.30198076389259, 0.62103743388005284, 151.21166265120038, 34.228097899184299, -73.642739703697984, -140.34810832125132, 54.296469246488201, -41.093856678584203, -210.15151236791826, -107.87895648285183, 34.52353613082294, 89.701198320118294, -267.13311980343707, -377.31716550755084, 99.432160806683129, 252.7030599154572, 128.04928867377242, 103.22587096570756, -120.82067514972032, -16.749174191141453, -164.93045779752941],
                             [-48.728434243159846, -180.30334211302704, -20.914537291624946, -137.60990903400071, 67.742612881191064, 47.207002073534049, 38.750351248619843, -44.511006476087459, -151.25059119549528, -104.05700084658702, -18.110977995028126, 51.24291096326813, -24.233463216042239, -5.0943813793982891, 108.69316414915377, 127.46309226108839, -8.7902027792034119, -11.375654942500798, 101.77557036981958, 126.70736050405, -2.3302194604176467, -109.25885078298052, -99.443334234893015, -20.227463999719813, -8.151151006392892, 85.551684356750698, -43.774848858094842, 60.979513158737532, -15.154523444317574, 18.184067647826836],
                             [108.6391927009539, -104.19744157066158, -83.268067559171811, -296.88060510215286, 122.39120084843216, 32.587299028136584, -121.05329577599311, 59.711761780657255, 81.010481296804144, -90.090537113004871, 332.24215921679252, 26.880851433732108, -32.747851801014853, -177.64456737325605, 176.25308273733137, 268.42701394729772, -240.79590555727583, -377.15490260436457, 35.802613321926948, -26.265441348507892, -75.170080830551143, 128.78015067053087, -75.24412744149528, -29.275684399349004, -258.19506411110967, 403.38045416386757, -128.81601887995691, -91.43676442628788, -36.414593137396231, -76.080356583447966]],
                            [[-43.033007310896807, 123.49567723522374, 59.457891752961302, 131.69125281984071, -91.370591025057919, 16.539919197031871, 3.0426295428705035, 213.45625065302377, -49.345868335175304, 149.85432662120886, -13.122887159514239, -29.826342260879322, -184.96629651271363, 212.36096759968225, -30.722634531713606, 60.2079194047583, 71.958475237639348, 256.83759856261349, -60.97033201091697, -67.006775385205572, 128.04092163986417, -233.73369733651333, -30.111260129928809, 14.007448300731253, -186.91210303326108, -94.877629861886859, 94.438501237933608, -144.72633713684004, 8.6783147642138569, 74.305398498440994],
                             [-22.247451802588607, -172.28196523363607, 5.0664576664739895, 112.20660835373295, 119.31398800695516, -74.265092459847281, -191.40682818969202, -44.454954092509176, 155.59946023978767, 94.088501402015439, 60.089702935053879, 58.743064217439553, 240.51347415941362, -136.48096548833524, -78.319684374687185, -99.051692265900044, -320.07262022356224, -175.42229698785852, 333.16965756272629, 11.208062084852989, -126.72619063764495, 144.99126835086446, -4.1453611905846843, -28.340095784285626, 77.148149363261624, 208.16315363408575, -120.8319098721575, 284.6741459192915, -230.02863706494668, -39.999858347897522],
                             [-43.798363112831481, 35.643452943637506, 21.70231617580923, 71.264249888110655, 9.3954103853838919, 30.820538167365161, -44.283114499774435, -103.90981173408308, -9.354113000382295, 60.368698512132873, 79.780989408818485, 63.878683774200233, 83.003048835125313, -51.460456895681659, 26.661284252050869, -65.581770561931293, 31.867482414451697, -3.04918363687066, 52.21065596133829, 77.218351925878579, -13.888621936487963, 25.204062922359409, 49.055919935216508, -24.808712050248694, 12.683011664303288, 71.636190777496452, 77.579560029272315, 0.23723914687797329, -46.908388686659791, -57.738107178951743],
                             [-17.297999475699402, -83.575918653820679, 44.762071918290395, 61.815355303559613, 51.290774567060609, 16.105929355339807, -79.376363059293752, 304.06616958612443, 58.850939069955281, 95.775925033934087, -58.025979190453924, -19.281336202050927, -146.3974541515984, 135.75217996762936, -80.789103144415932, 146.94588315994056, -147.12434678315861, 122.13531306580661, 72.171578435537626, -59.257344862123617, -16.668395666082713, -44.178419252724623, -67.449688704770452, 7.6048294274953525, -22.621292436100511, -26.203742595875323, -50.09499571526019, 68.138237887667202, -105.25576139366319, 82.712409697618313],
                             [-9.9856308282734645, -36.789202300660754, -92.12539515832772, 47.842415466786576, 6.3290927146041609, 22.345728883534516, -143.06272534722314, -23.775212108615179, 87.129290875902669, 74.212137956441467, 4.9634512094254415, 51.080651594408216, 95.369722098818741, -101.48920843790762, -68.142358443433665, -41.349166323474329, -155.2493250062995, -84.72228248840868, 134.2359935444062, 15.518959214172918, -50.132423156164371, 90.230004777557127, -5.5986833061721901, -24.374550026472349, -37.712267079616993, 176.75257516407535, -63.088221330438174, 140.75714019724995, -73.424773063345199, -83.636657271149204],
                             [9.4946648612562932, -170.71364926843103, -98.500437569900143, 105.40457079976996, 38.045633464427866, -28.933353160577877, -255.02322108485097, 114.2509779612373, 104.13773733382006, 151.64426620479247, -32.90321460668396, 112.36930078174477, 136.33023803338301, -44.7680155256514, -98.008152673704103, 22.739947696866832, -361.22896121957314, -70.360574713784573, 303.39639607512925, 49.198548966811842, -136.82638723230841, 145.23209421850197, -83.635205840245519, -63.308862034173409, 6.9551928101808604, 163.01125899691448, -147.97042749139288, 288.48599857924597, -240.19824927041279, -28.847550520774242],
                             [74.115706853196755, 151.23668553020411, 55.34221945281864, -209.00718667446029, -31.054675924117944, 10.022992463892047, 331.36509245264006, -404.57929550555275, -179.70171507936416, -288.18938812051158, 46.545236844204936, -74.901945751365275, 32.710266414677449, -124.82291439602926, 214.14061971396524, -143.15534930512126, 430.3202595647636, -137.4614558959166, -342.10879690018021, 48.921627160553768, 79.276274277491126, 12.817182793401381, 99.682072323868553, 44.045820538301982, 141.97761103573248, -186.67661906615101, 134.36925228435686, -282.52591471609975, 270.63428668852322, -39.148428124465063],
                             [16.056699828687879, -65.848262964562863, 40.961968323535373, 147.78306848165431, 38.996249788220247, -75.202009575213197, -157.98700055021641, -111.70890527398785, 130.05542200619288, 119.54548550840586, 101.41673319153115, 143.32724408836512, 274.8228409424097, -74.738680638720624, -65.012859474597676, -162.34199368615478, -327.41123258661128, -242.70664758360954, 305.01320893661529, -39.812253458666063, -81.280820832903956, 32.841407102399288, 11.020486271664694, -40.214783812983711, 50.644924019897132, 62.076447563724592, -123.54114404763858, 253.4220144696128, -269.54075724975121, -52.640830745611183],
                             [-14.596939877658928, -204.2553807141386, -63.988165170930586, 128.19641577211036, 89.193788470399028, -41.794005433143639, -416.47223114061984, 163.5564285139759, 256.31615603124288, 151.29316741571233, 33.938394984070243, 176.54119689990949, 179.33321900554023, -97.559820844260159, -208.99663797394879, 47.435559884003666, -606.42690726501826, -250.60502664899312, 500.33617890056121, -37.347292761864139, -234.15980289035261, 108.85179854437372, -92.80845093129993, -70.22140202932016, 46.001015973757468, 178.42756505022865, -305.22987411473775, 467.48528862093912, -406.52348051396029, 1.5138597996684098],
                             [-5.5903269834467366, -12.637652965760031, -85.599694032887911, 83.541126435348801, -17.584277974854999, -21.269077522464055, -44.057940339330038, 37.392601261565517, 18.74183426459825, 141.96532744148493, -49.49148747616087, -9.6120256069469896, 49.612338947857715, 15.728542413496044, 0.21582114522653115, -33.976343411662043, -31.696660644594523, 56.566879689396217, 7.2455417934524444, 19.99853978766301, 41.767436659147613, 26.780592490900478, -44.884921619345846, -38.24735034908182, -70.097995549666322, 108.02317402294274, 4.0467118194856022, 31.097269635159435, -31.880667688263525, -51.06299576317339],
                             [20.775646672686641, -101.2508286586479, 43.820124516826311, 44.236770870748074, 75.107016874552897, -52.302950902007922, -80.527524613557318, 61.498542113867998, 71.302484942592272, 38.698076608208083, 22.989181072864149, 28.391511645926229, 43.353952327118051, -16.837055175420286, -22.886848414647943, 1.7137944669293741, -163.04098613396397, -98.817479174978743, 122.70685809167072, -3.066937094166827, -72.468212244961961, 23.196576116475793, -16.91447658145103, -36.795523123760795, 86.232740960670583, 5.8901755393937902, -80.988856932169611, 122.93354674666189, -163.36293551531949, 31.071649856081681],
                             [-21.35762019040477, 240.70303993102084, 27.54390039139383, -132.72706910090488, -104.43749125260889, 74.629288030930084, 367.01317323172725, -62.581698716137176, -237.57804578076318, -112.58792850039487, -65.857366063262987, -166.70522955636309, -263.97296831746559, 130.34655114365168, 173.0196857763581, 48.47327100665629, 591.07629463589717, 296.87447298958364, -511.95003765110414, 9.5500033868714951, 239.03677010599853, -138.90694081978455, 52.531480369342468, 63.870073459672241, -79.204433990202247, -168.54163713412683, 274.83824742734737, -467.07354958065741, 402.90537050681888, 21.976099038323905],
                             [-22.317122857488222, 2.9579551921255831, -67.173280743170807, -38.336526666231521, -15.320367217857662, 64.999013527873473, -33.650185123839663, 83.404015746964916, -42.025097758571846, -26.018487303126854, -84.76287312255846, -54.642164431316836, -122.69068301932188, 2.0882937090215656, -18.518941622978073, 94.808473980757938, 63.690799162356633, 117.6744549061506, -83.405477171842406, 9.9796625646484767, 22.640125572505433, 33.601829221390588, -21.252049155620927, -1.4932830465484079, -51.878681899844537, 48.136256257510688, 21.938382517000218, -42.921406282521644, 107.4765458123845, -0.6595629004233029],
                             [117.83075983957241, -44.297174632956924, 60.946387488694768, -91.915677570912763, 44.691830578082957, -88.978431670636397, 38.712962725013867, -296.28589599897066, 79.006102444090089, -171.51999274124125, 132.10435027806531, 113.39418760652698, 264.08070069012734, -154.11440058188751, 17.728940604847356, -178.16467791409542, -184.85112222483599, -441.18694852968957, 161.42553524758776, -29.461555764591026, -132.89196254463667, 79.150776652750451, 44.776772255153972, 4.9274133170507559, 204.78081816662836, -112.95000858395345, -148.37895402591917, 159.13365108432811, -146.43423508759932, -29.591483919899296],
                             [-110.64648051196549, -30.614330715619303, -2.8666784883232599, 172.47019467167843, -16.751093160223402, 40.401990480089495, -187.9272484850656, 348.94876037774566, 74.089973479640349, 235.55309902105188, -53.689271167353702, 16.611299482685403, -137.4641520556564, 167.72259924726754, -146.03131707022811, 161.20617338927681, -173.89407365616015, 257.23774945151666, 155.44855232934719, -62.743923666776105, 18.779665933830234, -103.81283880961867, -74.51212510264223, 6.2514496107944826, -176.20814267766679, 87.398584764388374, -24.199102801440013, 79.573035634238792, -107.08539482158858, 67.307764248625034],
                             [-108.88311412330246, 75.720677792178236, -63.865424204342617, 133.84072874836946, -80.402595937376148, 121.20320565486769, -237.44433373003554, 342.99205077339087, 72.211415133576779, 216.22339068541908, -42.14796353181562, 31.819987851009078, -218.53444514604362, 132.97010143173546, -193.21626763867462, 177.59461682784902, -156.42765428931759, 267.63850107408467, 139.24695919879429, -88.478407102729818, 30.210212739388936, -129.79152717950848, -60.565137501929009, 34.367962833211031, -281.17354301304772, 143.00536472800059, -5.8994975688850468, 40.735662698263297, -24.450940720085597, 24.69613089769582],
                             [-29.501631140716565, -148.49961488247919, -78.165779101150122, 158.69818128717461, 31.112292277878495, -51.295023734585882, -314.11904049439499, 264.82240159659295, 174.81261727272911, 192.71261426151526, -29.168115824716342, 77.465354113177028, 61.331885711479394, 48.108699583277975, -179.29343919235527, 74.042389908329255, -444.07079268893619, -17.343366839132823, 351.7971689632181, -49.935548843723957, -107.69886819560355, 16.412048615808398, -107.89953809897348, -60.194569249312764, -80.943676709705841, 137.52505532083313, -183.31437128406188, 310.7543952333109, -279.72979366002534, 27.528393823349319],
                             [6.1522766963270517, -45.709274513083123, -15.042804241357826, 35.798530878348778, 18.759139533433338, -29.338616894232427, -40.065898811270486, -47.24264918287242, 21.498328488706406, 33.644187309330611, -1.6189880112206267, 5.885456974904657, 84.425581695102082, -48.959649515272361, -5.6747820787658672, -53.41914852156205, -54.700730392533934, -57.074665813064449, 36.554786829172372, 23.573916396130816, -14.293892213828155, 45.646624164999423, 0.68304144497196506, -34.948354604732828, 26.926246726855304, 44.706852860380408, -17.821031037153343, 63.806520994246732, -46.087257408465589, -32.830124318977994],
                             [7.6294339709851497, 25.427608615467932, -56.890694225069957, -119.50626476420049, -8.872030086164262, 61.140005920678398, 81.906534517583012, 123.50568978915096, -84.803720464617641, -126.94483509630842, -100.304219212512, -112.62184618081459, -213.02355091407844, 71.39081243054558, 33.142116875911533, 147.11784838269358, 169.79290579346781, 149.00343466069486, -197.56474200168876, 6.2422159994697708, 39.95179997441133, 5.2196106635441426, -42.712217783651504, 13.98489050253832, -22.736859509044184, -75.268919540071238, 59.965113913356852, -135.30318797780603, 169.46114732075114, 46.884012420418749],
                             [8.1096728208541684, 145.94031127674938, 111.80362335389177, -155.79110717245084, -0.80788045752004312, 44.780233086775738, 290.95023767361687, -4.371839732266567, -147.19733516919604, -215.80402715152215, -6.9785092410504079, -153.74655042570996, -259.21605990392453, 106.60188930410153, 135.71056245578737, 75.941596214203528, 422.43546299784731, 158.07148203566248, -371.48829141824996, -34.069739832409155, 122.74439787180806, -132.62099900121711, 42.438074097296003, 69.087024905959353, 27.098028145856073, -228.48619477202666, 164.79304370945781, -345.46405666854849, 276.8527567116214, 91.972795234438919],
                             [-22.519331994978131, 179.84169501051147, 44.890913569642457, -58.736585985985975, -95.958476763667946, 89.333878610165442, 199.94214976571922, 116.1666831355321, -144.51200504132885, -47.642465350456803, -51.171177721170011, -150.09733732006322, -310.37327295207518, 166.82395240550559, 46.572837491076733, 93.7972614637427, 355.53104617580243, 278.71149889425078, -327.1489263941109, -37.359464828770186, 178.96256638126201, -195.46347675445219, 14.740303108346307, 58.974256319818863, -141.10749684419812, -162.93163283093551, 206.69716081106978, -331.88431749314407, 253.61692983902452, 52.390536833869739],
                             [10.752288674616469, -53.940511794966319, -79.932753372645152, 50.69739060553853, -60.228577388636708, 27.043860758835393, -197.23399281750764, 68.108247576707328, 39.249539067711595, 94.774498964212597, -12.496275159921698, 105.53145806324775, 34.379347039625614, -28.985774422448145, -101.67055879235085, 27.113193819075562, -201.02689606036338, -30.479760424734501, 146.55454727516641, 74.155034408735702, -91.485087417979088, 31.57630722488571, -29.621077944930843, -43.959724577430151, -55.296785664898074, 71.266743511889345, -73.857525431139621, 135.65626281764096, -116.6624943790134, -42.815084661389456],
                             [0.45429337565902628, -17.106940281847645, -32.9762744238067, 83.384129989361071, -23.864681122429193, -29.025724253361158, 22.831883922104439, 72.353137783348458, -23.364812501756262, 118.35303288850838, -62.268122526639559, -46.354543034227049, 6.7871676505393772, 71.789041492195778, 16.333207014693031, -18.713142315638077, 13.359500753783424, 89.741347282831512, -31.014900563259083, -3.1085184644019828, 69.99477449172123, -20.260636151797733, -46.213119626340955, -27.100917354834024, -57.452962911820734, 8.6655291289248382, 41.727266078945412, -13.301099712573306, -20.092090759090024, -7.7525774225495381],
                             [-5.8223663073624916, -11.474797576720393, 24.012932583818596, -37.644760662251834, -9.2924536204883097, 52.258472533881864, -28.348718162125351, -15.772662990371364, -27.746527267665339, -52.614206965601468, 0.53742401450355659, 8.2813886882831671, -48.187679590141023, -41.710879419694059, 3.2366523647814711, 31.160382795048054, 31.716957869598421, -12.183690246816836, -26.478050074227912, 38.423515622870973, -42.44109843435912, -9.9884203403718175, 0.9483495497833675, 24.275260282515529, 12.482285344210041, -52.028114077358168, -20.672217180191424, -23.992586769039043, 26.344446368014452, 13.083558193801972],
                             [2.4521407546328127, -31.542427926397266, 23.557121190873296, 30.08430875863543, -2.9670319795685187, -14.235027983215529, -94.026615759058132, -9.2098774658433431, 41.166457342873557, 5.5518754120897764, 26.422843309234352, 62.366715570615185, 51.517169750191762, -26.933832900243853, -46.476919855188619, -11.090107710250528, -138.82906048625054, -91.492120458439729, 119.21667669473035, -12.608789706116339, -60.635454919980297, -15.988111066071326, -18.2255686842758, -7.8576027790884275, 16.07903236805798, -33.725725979065913, -88.931829953206915, 93.40164218990418, -96.48515838908024, 19.713847532497631],
                             [-22.001579124813578, -91.782716642999915, -5.0668876656060009, 95.438635621315512, 65.823210832901964, -46.2701715300717, -159.93411264833455, 76.685000615531578, 134.16489769311588, 82.699610206838372, 27.734206051777463, 78.242507033674073, 95.144383618445218, 16.517171282950756, -88.264460207910346, 8.2835901836409835, -264.21278007530123, -61.626005450406169, 210.84587456530954, -41.443913966173184, -76.041823439893818, 34.726367139334016, -31.083186985648311, -38.836474691248313, 14.581164100613318, 79.80905792014228, -120.72339270732292, 196.86941185540675, -173.80177721937295, 4.3791916633826862],
                             [20.69167536019749, -172.50732900945127, -50.707657223957156, 142.75995083314606, 65.487151716416648, -90.925306091806576, -179.64042493776236, -18.26535183659756, 123.06921260785553, 163.6627922659043, -1.0125414095482745, 78.270145961989314, 258.23132742574131, -85.974621501483441, -60.985551464778482, -108.10257280898786, -332.69859861895554, -161.73293528972934, 276.41991770332419, 19.99050914148955, -87.209203101811227, 133.12575985434165, -36.332121474520441, -76.201887042373784, 51.691904926703678, 163.79146029881642, -130.16670666084931, 288.63938849830021, -250.87835766452491, -66.089242705295703],
                             [-66.075847007183327, -204.85177188463561, -54.463371831959563, 284.31347965831088, 82.419888396004851, -82.52840487691924, -361.24293259996858, 123.05391909259562, 257.39764055728909, 328.10639102949239, 28.021297446669166, 160.51558399337395, 301.96174044891535, -20.360461373563819, -192.86689313706037, -72.07464476685125, -564.82391996075626, -114.99877110019227, 480.79492594828764, -37.116601661060244, -116.64707423422246, 98.410683324953254, -57.39726835709844, -78.818194549400062, -39.100589695708884, 269.45146876330762, -207.66907027700248, 449.04648205505458, -395.96480804414779, -67.979741510440931],
                             [49.976733875750384, 246.82726107003219, 131.45413038451369, -184.95715095107269, -80.634210285255904, 21.43001093944055, 654.783938019728, -189.76991684460745, -387.95952406733397, -215.29567576851366, -85.277742211131851, -271.23026759701912, -251.29935868105375, 192.14175224802767, 356.09937205451843, -41.130847883168222, 875.24192368663762, 308.1941479886782, -783.94996539710712, 61.771800362989829, 337.19931124024959, -152.884847812451, 94.33363708672546, 46.585118966116291, 66.091579439955069, -382.08927802720706, 430.14512156751266, -658.32881665430591, 493.4352915195081, 32.900811144832744],
                             [37.921239215457852, -14.350438348391632, -11.328710058433375, -96.283523803785357, 51.436544228392009, -11.973455841788521, 103.52177306926984, -204.13850177043673, -28.779901820490995, -155.47497215993641, 4.8830460612471391, -49.628737180224434, 91.765893211708331, -118.4671488217202, 91.11563933665029, -82.034683376789076, 114.19859360476978, -144.6359664402666, -105.71172968134044, 29.487075203092861, -4.7665304459445546, 101.20062488553491, 32.444147510877627, -16.922479591381872, 130.31605103686033, -26.781539654418754, 12.127995132998413, -26.825422821913627, 74.042310544544733, -45.844310827477052]],
                            [[142.99447341473802, -541.60493876564419, 669.7615716117848, -7.4388185063320451, 223.26795385091285, 256.53206331504839, -98.411214248545761, -519.71076887062691, -223.48052988264268, -196.1436485594227, 424.72779993116052, 103.31913368404936, -670.52327726248598, 125.59046363120002, 313.50614017684165, 295.95457343526209, -308.46835512509551, -213.0709841906297, -211.92770380920462, -38.041574516005767, 577.83056673149406, 94.821796060102898, -506.45601132077428, -73.708574619885724, 33.300903058052683, -140.42301451245385, -359.53873155200586, -235.96734084607198, -649.06319594172578, 152.26627730576951],
                             [-288.40775626518359, 411.98939481414186, 64.2533427910613, -99.37460200166359, -156.24010703240876, 35.960488305732916, -257.59144560628187, 46.585096353866241, -131.96418457376586, -112.81992501474258, 90.975931414555276, 415.43086406302484, 5.760272559246534, 3.4798416250003799, 91.24297262927935, 215.22347679719465, 62.242417347695643, -165.30702434235124, 123.11655288873165, -273.91147569797306, -11.581690160892697, -89.808779514712342, -36.492046344624924, 128.02015534924723, -218.9259849152771, 85.994386997931073, -315.85245318237156, 279.95557967336413, 360.07931468333311, 397.67205255553063],
                             [551.12513184989598, 249.07476805900961, -78.188957144434966, -256.01876074419226, -681.92954925317861, -195.27098818132549, 38.998087610595704, -222.60098965877373, -44.30056466123105, 433.41738283335798, 148.6301303586196, 340.53503900739059, -458.8418575680293, -125.7506625386729, 63.836524829292259, 5.4056655791731822, 85.001686258904272, -67.353323287940285, -172.74345700092221, 188.22315849306929, -344.81016350472942, 268.19146904193087, -133.15361818426655, 17.321963344049138, -35.07938086364409, -25.402024509007241, -193.61805231658857, 17.594765355477559, -232.49900647264556, -94.329394453459045],
                             [919.45593807853288, 18.682422175221873, -74.653252157076651, -19.589305276316583, -583.48987745906049, -215.34899624084343, -108.04890321858296, -219.41863211375843, -245.31204681544199, 845.90266451465959, 178.29100112819785, 64.433276043365012, -662.87292978223945, 102.05842676171908, -9.0104314622347239, 166.02656255057289, 102.83117086950467, -6.2629800165160763, -372.98188573462784, 537.3422350428034, -290.50632300380391, 424.82113941018991, 9.4666273643443279, -258.58104632555842, 13.807462074556573, -142.12631197020227, -124.76563822554289, -431.9093993989045, -583.56202479826368, -487.25490641888393],
                             [-350.11348886246759, -248.04235199628533, -119.01676940845766, 141.5115829959301, 746.7510268533897, 33.188531516829748, 511.80700220917788, 207.93354448874044, 251.55354917797183, -328.26772034624753, -171.9681459161813, -709.5159673430976, 707.47342272428671, -25.612964335534496, -208.02825967168295, -414.64358170758021, -203.22335494331148, 182.61478930812143, 114.66617135656915, -144.85168208988608, 168.29707255574417, -189.23417499174889, 217.74867122052092, -187.69764135169751, 279.03165648290263, -25.776805719003036, 474.4471443730306, 41.509895281562017, 201.7798042254318, -131.36112183938002],
                             [696.52589788048999, -309.65945728761329, -165.5556416867334, 43.198888730850811, -348.16995857790937, -244.39387185955675, 203.51265259408075, -116.35415369510463, -105.0326235445324, 551.80301930323981, -12.143334339305412, -219.72095201293729, -425.01200758225781, -17.103677531851421, -93.726235626643899, -205.14539330592282, 70.949401533617689, 69.531520956143893, -393.65948648906857, 461.1161361866196, -91.845053313139715, 332.85361054969644, -1.5138695946100518, -94.403321185865437, 232.9927563462816, -187.29177694925872, -18.33625319019756, -431.39718296240113, -472.15422917655832, -451.02637322720568],
                             [-608.57507300042653, 110.13174484167997, -129.00327273205676, -42.434743648220575, 273.77618083318282, 111.48883408775873, 209.02006486115854, 133.5555127320273, 172.94818532620911, -570.64697422178335, -31.487329342015837, 124.06093271247001, 421.97575846941299, -14.395219234355011, -20.258318302065248, -294.32848300432727, -27.993312160303461, -95.11027351529448, 138.31388649473109, -420.68500369582773, 97.473271185949983, -240.56383055781811, 9.9289415031213704, 366.63753732075145, -99.115765666263897, 58.46690988131261, 54.865980325928049, 447.34161094942095, 668.5396712177984, 474.41823640809599],
                             [168.30248166975935, -90.294999437912679, -215.51546722214187, 25.354088331986908, -11.475092203943216, -84.493561937068279, 190.65840677211466, 45.28566811896976, 92.326105145095468, 162.06317780655536, -137.3437491523346, -197.83593460434059, 58.459979586994905, -89.357419278519771, -93.645855003202769, -200.33711184793259, 63.508490617574587, 100.84342759560023, -52.158859044854644, 187.60822149416191, -136.54889555397224, 47.646315056778356, 138.2945436696908, -65.207910308574512, 98.442910888593076, -63.312294448475953, 188.92583527234166, -101.72271511350579, -73.036257601154588, -215.36889042669773],
                             [-213.76973895548565, -230.79460264777228, 567.7806006077883, 193.50004917965853, 228.90897801886121, 341.91679355260459, -557.10396177692542, -105.72628971225815, -190.80021832759118, -221.12253950653056, 269.64906400698732, 152.66960410543996, -82.43920621758636, 351.12106658125543, 186.38110291737726, 698.35764409572948, -51.681371567445311, -92.216354744899135, 157.52037678356672, -101.50256407283764, 472.41378527937218, -164.3600847743617, -208.15029331536104, -52.516366385836648, 9.9063979594769904, 55.078487121377556, -296.53256648290625, -136.46498917963277, -355.52589148759427, 206.74059534154273],
                             [-782.09752785158378, -189.95845502916896, -66.237970605392974, 464.43622471989806, 722.2695923872169, 181.53457088140976, -256.07813227363084, 536.93659495485599, 103.95017176665377, -453.64336384362593, -436.56092209557619, -373.24059253966135, 751.47980360552742, 44.630608205100785, -100.82494741557544, 12.98363592957819, 191.33462079119815, 247.04057354156197, 229.34656158168121, -88.297555414065826, 192.91919650091, -392.92850493724387, 323.23767683007782, 71.560388744883596, 117.84022513123816, 87.808153442618732, 397.25352832075578, -33.840709669598546, 412.8520330260306, 54.088658531212381],
                             [799.74145233042657, -645.89897020415629, 264.14394766121507, -232.75850611076058, 298.74797925373548, -57.527088202895719, 702.56936320568718, -567.7006245866595, 22.921695285172824, 135.46249910183138, 161.31021868032795, -574.83861444236913, -584.32387967656348, -213.64749655735514, 41.861666683309764, -432.21678065600298, -520.15767644465097, 81.90992143631523, -337.67118082896212, 313.57474227281347, 171.86437362889384, 345.2421052442084, -326.73360072883293, -436.18162599552767, 205.87861408409918, -295.37546299477418, 222.60297393809066, -399.95592231574426, -822.60056591863065, -564.51980834770927],
                             [-98.618336124732991, 362.94884801489019, -185.26030861279895, -179.81736885788521, -364.8889327393818, -130.36554120813511, 7.7722450144556179, 92.318427864702656, 166.29262141252187, -100.07352933520995, -72.538463330096064, 343.39955348862452, 125.6751772164032, -131.98852621300296, -12.225473441174678, -120.22497533325088, 71.674200622620006, -17.723792708367363, 123.75635252123783, -177.89059775521449, -333.83796929264241, -27.756922217783877, -118.24717099101692, 282.61387555727327, -168.81823062954632, 217.51713667647888, -34.048172357039583, 358.87630646381081, 348.05407019739067, 155.49527576027685],
                             [41.560348545303874, -242.96643501218836, 300.27175844722382, 258.52293966605396, 63.966529655454742, 124.66410780306582, -453.29170995577607, 43.1903947810357, -162.51026975447817, 79.21979437064536, 52.685223755021674, -11.218432844062793, -96.0770140380653, 213.79026748403572, 63.282919837589013, 467.98683524486108, 83.352441674057744, 61.34578129955726, -14.799399751271698, 143.97615980991148, 201.66795847041917, -29.068806321779501, -114.00965747515387, -75.188298938327222, 109.17132885944575, 52.068186220957855, -119.41393445799896, -299.93859769979457, -407.0331082904853, -114.69101406797914],
                             [348.81326088580295, -223.68914226322937, -129.91734507284465, -30.164788323877371, 254.2840938439914, -68.919918572796277, 477.77339815262371, -63.52690219219636, 106.49970089011208, 120.14762635357766, -10.229527970795546, -562.51956895024102, 72.481189238237661, 12.543353493148356, -166.6907321638617, -343.02110282907631, -205.66108827886737, 156.00261756387889, -107.59395815495024, 171.5247868781635, 10.479726468257212, 104.36405950491205, 126.46817191804027, -267.10452488748848, 157.93572024004203, -115.3934054825754, 411.13483611724257, -215.38846910427361, -184.86943225975597, -418.71217891296033],
                             [274.49138603833433, 317.49475791553698, -529.34881005480293, -142.66723301403314, -420.17857060838179, -369.03057170204761, 398.00802780044154, 118.56604049555744, 185.53954796764452, 324.78627032092703, -219.98399600343751, 28.109003777941449, 32.271185328162261, -275.62242321412862, -162.71973764811298, -559.49940373761183, 120.61934730969709, 92.267552688437519, -208.88051530012987, 134.19600943672452, -580.07670516882695, 206.56465172377958, 137.30944977971981, 121.42504174776109, -27.401128023563302, -0.15760356521070129, 211.46099774881023, 163.59041882492158, 334.1340246758981, -213.39076851012032],
                             [-123.56950167178989, 199.77477911915406, -289.26280419341072, 120.30241631816997, -112.70600119568888, -150.04250885520196, -107.58266679225895, 275.89493043694961, 35.375516290431484, 157.09977261724907, -277.95467200218178, 54.344236005214377, 159.41659825325547, -93.580638565556882, -89.098259476893759, -91.295659068507263, 211.06489442117484, 76.579721608456481, -11.32417918264137, 74.63940694668527, -297.58403124431885, -2.9345752333484287, 172.18189091538656, 83.070288842764711, -82.698047023806922, 85.372835754032096, 77.030733038912572, 45.900877319745661, 274.85236355879783, -79.728311423061328],
                             [-700.59273489162672, 60.86414042782485, -354.27738689931249, 228.96895820609561, 206.90683989270457, -43.601143215714266, 52.468818901638883, 447.67621560771579, 208.34441429633969, -328.89388029028066, -382.05925475873323, -80.74055223397383, 704.31327846173303, -90.052824589241709, -122.82533915435049, -303.04168068568373, 244.18945737219872, 69.962032529299393, 139.93902744387668, -208.66231885381768, -65.025364897845918, -280.44933708696533, 276.48438438096332, 332.36273355237415, 93.827486220969405, 95.200812824454957, 189.19005153293426, 273.49017514592026, 678.84905968735541, 262.57250911133656],
                             [512.55190584680031, 76.153457425147749, 308.10244213495338, -386.5073786114184, -246.37100922042501, 49.974022763982759, 38.466886857976078, -444.11063088049963, -67.892262491867967, 87.636890893819412, 351.98329794621742, 215.35867072179857, -599.93518490647648, 7.0697078894929692, 150.47005804868394, 144.45912913401438, -286.42233346283683, -91.160838761826099, -25.374644594788528, 27.012198463180098, 3.9736069016501485, 169.39534942008447, -311.79508536881121, -168.10006151657674, -191.568240403244, -11.824768574367191, -156.30541852694859, -10.739782062031622, -413.99431179347494, -50.63114988200082],
                             [24.188961026830555, 15.660911378535555, 534.05320062327178, 58.415368334112735, 58.101343781293878, 268.53979646768965, -668.84361359332536, -203.30238467050492, -384.87131535893991, 46.735523117111974, 311.13732638909778, 287.7242365668148, -444.95650658658002, 247.73261832935941, 255.1172062679538, 777.9657615445592, -19.384104942839731, -145.06771680296819, 91.288921672923522, 21.654714500458891, 325.73471693754789, -45.94410266155495, -156.70971494018158, -221.66654911372413, -197.67956838776902, 14.184039507685512, -367.07734611066695, -233.26598166301977, -404.00898371644251, 152.31249555484371],
                             [-219.06553283345377, 319.70065653197429, -14.448555653743927, -61.423985486132949, -259.59952511828283, -23.472353178858782, -265.61437644575449, 62.185293951997835, -80.812345975187313, -45.600996771408802, -34.703597045667571, 430.59658692228646, -84.27470952874512, -73.001177350656434, 96.120515230601583, 143.88965721303683, 126.73896545140087, -140.49550255484183, 47.205512167870047, -151.84107142138237, -97.131233624687027, -42.727892029247009, -40.863752032520537, 195.80318609555073, -200.66165385196993, 88.476546895582047, -294.07394674139641, 217.18072980776535, 316.83978855302547, 301.96268242245867],
                             [74.324943008670218, -105.00633738464137, 87.50335890357762, -114.45615835752263, 336.93128720775707, 81.944942344359092, 261.44184694579616, -158.31485825670143, 44.145053439418028, -153.88060506988342, 97.79890349988105, -217.43444863536567, -5.6213926499542808, 1.0089059910559437, 9.9219681268691229, -170.05494576140083, -251.4882139158627, 27.686092372870686, 20.666886223184836, -38.248440006706261, 67.168462905818288, -4.9826267024176643, -53.544419160746521, -152.10745407717914, -51.254756313547851, -68.984564506009946, 227.5144362303848, 10.052205660999634, -68.399953368099958, -81.844349283202334],
                             [33.319571831389318, 412.93068098640572, 67.58126296851853, -307.26529433920774, -182.63729402885815, 35.502974385274392, -86.853226938015922, -130.78523290289749, -30.649080748367371, -88.624741737511883, 133.22658703217607, 349.25809405390663, -212.44770020608294, -49.104034282554743, 97.269118333639526, 85.193681206203863, -109.85584322139954, -90.549565303202101, 120.67899041289728, -182.87530804531971, -137.68392354793642, -3.3385297109767613, -85.512197635610335, 18.656722564464669, -360.87283131136064, 95.608485272699653, -87.405597087061395, 239.66363491551013, 196.77785911929837, 175.05387051383744],
                             [-353.66597738991169, 230.90946630270562, -357.77549162050207, 128.71052121503791, 71.328031697452502, -99.163474399331733, 109.17069438678243, 319.60783411887991, 149.43306999121944, -22.639165492019885, -243.81217534419059, -61.97838501880868, 474.64119969041741, -78.077478925023883, -137.36228200634056, -229.10550835845066, 169.5966488959277, 48.22494763413863, 65.502714580563307, -79.160396889104518, -209.37888879126962, -91.46320386855902, 288.66457502689599, 109.14675383501095, 39.971065365538671, 34.095599257380137, 154.43932974743848, 209.69759264364828, 498.05811418190081, 64.158715238808355],
                             [-549.96064454539442, -363.37076121406147, 5.6269025774691528, 406.84559191062908, 425.1771524482462, 86.008848723456637, -66.86718571082406, 268.66449892139178, 57.841173713801766, -271.53468889746148, -214.5760348911393, -253.29427151141351, 430.68174453604018, 6.6248722681706935, -23.033320775123343, -13.968882818294317, 160.09870114123061, 53.226635668933362, 13.571604948164417, -52.941973596655252, 299.02800645570221, -198.63186938887978, 101.18351747014175, 123.8345395217591, 303.05216763844714, -16.0338645635955, 33.469779565667864, -80.320115188611339, 121.03877025631401, 138.02338923499437],
                             [699.68289521775864, -212.83989243022683, 22.556879694989593, -198.3556276587052, -179.56602831502471, -114.08000282253292, 433.00473655199613, -311.90342776757188, -19.74998369995637, 284.43326279013951, 220.79575998523799, -186.32590022057107, -405.74030044692307, 4.5126433805658062, -64.092316970446859, -272.96273675451619, -212.5808913502097, 29.444460455794708, -310.38403926197901, 214.90360283873397, -36.959055949052789, 301.31365132710522, -171.7386686604369, -140.39687162100708, 141.61913214862258, -172.82573356837995, 61.340135233667503, -192.331605258796, -420.61960489480532, -333.06273153979225],
                             [-411.62327867394379, -115.04410702708527, 408.20541292990742, 58.558234391435427, 310.53970289227908, 298.36842333948516, -277.94622857291739, -94.916905621618056, -116.36522962467814, -463.10198701089558, 201.91064372879291, 244.28994032735454, -11.798579555057437, 160.05622495756919, 183.6866463510469, 327.407765509608, -99.339039633705923, -163.22048149660392, 117.14646572898712, -278.95314413451717, 395.61554078420204, -200.42563759328311, -263.91186909889331, 145.74074337985778, -87.339818309189369, 39.471425989345093, -271.49177973488918, 142.95305090703903, 46.403632196628159, 423.62950042152301],
                             [11.250711996938652, 289.40314702587773, 62.353073823714212, -105.89713216784806, -160.13119293955165, 51.585457303248802, -217.68332861029029, -12.223975644852926, -86.150446928485906, -54.099838196470557, 79.464414388734824, 368.3340031089445, -166.44237450669075, 92.803925249343521, 46.150484973662813, 151.85957961554709, -40.543441874601768, -85.50634965026164, -4.2481679196412028, -152.36860033843615, -95.473652115309633, -19.701727369502294, -138.96766484355371, 127.08364631540458, -326.9597246066578, 133.74532155853626, -139.73362333442506, 168.11344852641383, 205.36101997875062, 134.25691530507603],
                             [201.47622511449512, 268.41514748890313, -296.70893051480567, 209.79641773498116, -520.96227449679066, -236.58219654582001, -415.64863172451095, 318.78113652602525, -106.89229924795559, 409.02083900196686, -150.47193636992429, 274.08930757165695, -15.370254398520569, 127.38495240481924, -76.549398565580788, 107.12618395563986, 398.85932892262451, 91.872796155047311, -172.50095617981953, 239.10823643665125, -467.37142868480151, 88.862300304418895, 50.623424009744575, 256.46300949304583, -97.248363921668897, 181.0431826227111, -13.772290922076305, -62.344113259461587, 191.28338984725647, -164.74532865056977],
                             [20.144960779100927, 16.241792938049734, 408.17584916469445, -64.341513674600492, -194.40965939731007, 228.17301312560821, -457.90301192887455, -200.35552933946971, -170.4178681510659, -77.314008743337325, 285.89589103669783, 431.10655593226164, -360.1667719275672, 203.09994702193836, 198.6574609426404, 543.00819658659077, 4.7078021122565534, -144.10143973639123, 110.10174070058849, -78.646050077407892, 225.68774129989683, -35.923601588093803, -242.48632525833506, 69.283342010598332, -135.84096813092287, 41.862492306048438, -378.67695236103185, -7.2448920864245281, -278.68785071305615, 259.28499484442034],
                             [-176.18194750150084, -471.76214595790776, -96.917770036836899, 255.63268505235635, 444.86417141062691, -30.282964969924926, 417.44668753474826, 142.37133865845627, 174.47643123247346, -164.24545677582338, -114.10465725236539, -551.18273686720067, 489.02063618038841, 4.879330330290566, -143.83360091036329, -376.97910804527709, -38.059719617960248, 121.0476302065878, -80.945393383063987, 40.130859376064684, 188.74434462078983, -77.828761934411858, 66.331248686719178, -1.105525132845103, 451.36526726189487, -110.48598503416217, 251.5395157463509, -82.145496763093945, -20.740457958374179, -106.7294613507941]]])

    matrices50D = np.array([[[-1.0815322538150385, 0.2405766451070725, 0.10843734255265705, 0.014604004564099691, 0.15255955080029848, 0.71852639497344728, -0.15925272710060318, -0.13324935316205461, -0.19269993726992315, -0.45381121878147324, -0.014983753991294563, 0.93219671240259772, -0.56126946867246785, 0.45217604173905285, 0.75143686855642555, 0.19529802413115316, -0.64586162827184601, 1.1294652983413125, 0.63661431189652662, -0.56102305524637686, -0.1809701739351284, 1.8054346913448753, 0.072649226288260232, -0.4514809058042234, 1.7884313785901138, 0.79087245899627823, -0.16546075242157707, 0.77940995480292163, -0.23082019398004586, -0.28856466473273695, -0.87354407602262496, -0.18779595062676266, 1.2556576034896132, -0.6461301416348767, 0.12953011476480075, 0.76445606454779069, -0.599963507192949, 0.48562332865417146, 1.2784545723658551, -0.6883789663711628, -1.0004096338806912, 0.32037121461874285, -0.91793076327547019, 0.97729128151240918, -0.17256916610033771, -0.23137151217133659, 0.77569546819884272, 0.40274010322536352, -1.0481510950627553, -0.27725285082828138],
                             [-0.47166585779250386, -1.495339566855951, 0.86639564028111149, 0.30266697568297596, -0.57885265942056685, -0.51390231937244402, 0.21278536141018373, -0.35556641662574873, -0.2182296122085168, 1.0519199079442687, -0.10880635115243474, -0.41175812319129557, -0.53489263767896222, -0.61580492317399593, -0.4258581184228335, -0.11059566231153278, 0.87868120640722347, 0.15121914977849343, -0.53806374409302582, -0.5036542909364472, -0.10197528946139903, -0.44943011813056732, 0.94876338925099146, -1.0661047721503996, -0.90620198578556954, 0.12711660998330529, 0.83275990557288682, 0.22248047765276607, -0.027185605483603974, 0.39931000732535948, -0.50112235598803856, -1.3206582543921079, -0.82930077099503818, -0.34269095327558097, 0.79859507787250117, -0.6760637785941741, 0.11585433168852385, -0.80360763675725666, 0.51842075912756269, 0.37425301074692691, 1.0589785592921965, -0.49089485462290494, 0.24728513878715441, -1.3922080896827094, 0.2889610496112463, 0.81725016136219575, -0.27614378540916762, 0.55144613241259943, -0.82883308819056212, 0.099358928473992469],
                             [-0.62807129410625784, -0.56111946750194652, 0.076487941969780537, -0.80812224293799961, 0.51959358928083621, -0.60980504463248397, 0.95014746208414114, 0.49999797783685118, -0.30238731136736602, -0.4076880911398692, 0.40583007447160435, 0.65354464480126406, 0.042744367349646789, 0.28149843536213048, -0.40062090987717586, -0.017373406542642331, 0.20466513735147834, -0.48365797137247335, -0.21905896030641939, -1.5897045454425798, 0.54239910887928167, -0.22763987945282585, 0.63626003880905568, -0.14632610992571035, -0.53917757758996654, -0.36655274676627503, 0.29816007942326933, 0.75715058820434211, 1.5561313387320563, 0.23003843681879468, 0.5877279685396839, 0.33032097427017765, -0.19364364763118963, -1.0811646198689213, 1.2907188816931194, -0.32787874850508153, -0.65229346192149085, -0.072111087162330639, 0.23724633981259097, 1.1919794343723389, 0.24834391015032811, 0.9832017453670745, -1.2988215154585945, -0.70811950353225916, 1.8288228496841894, 0.3682190042827998, 0.41027815498266978, -0.27010803703444208, 0.4051805731689252, -0.040507427187895281],
                             [0.28568138872795251, 1.7998390086036569, -0.4293332871717554, -0.56798567965450442, 0.9961721838505655, -0.93380869090812868, -1.321058686182689, -0.84532004923114157, 0.44635761214465491, 0.038723224944081112, -0.027746614608106748, 0.54659410526621899, 0.27792789499263987, -0.62229789438751171, 0.29808641844964823, -1.3530660920158319, -0.11181666807700918, 0.65613444008085076, 1.091661902285046, -0.97701160405384302, -0.27716333371288965, 0.30402350743809198, 0.42182061962196155, -0.061814918510953679, -1.1659661894056714, 0.48762802398828503, -0.65579059789447725, 0.44010370261981424, 0.11045630742590293, 0.51501952965637554, -1.1042328322054831, -0.2079089987735217, 0.14520311868217983, -0.25888816139277065, -0.039460260948212887, -1.195022020430452, -0.57403903764818032, 0.56893515266954786, 0.8793280136892685, -1.1247350989182716, -0.31841391584972972, -0.5813972421739132, 0.80188733915394572, 0.16714824550535404, -0.049429464924898879, 1.1466776180011304, 0.80852919522839917, 0.034307251857574016, 0.20419000958526484, 1.1741098707265532],
                             [-0.62978504801520374, 0.50933467973044444, 0.2082081814745646, -0.087188330671511743, 0.75927190868291983, 0.39126801737111072, 0.62753152274601054, -0.19924465617838441, -0.18516529549225169, -0.40051070119584153, 0.3940114347628032, -0.031481524982172118, -0.10092191361937351, 0.45698761570792779, -0.44348123374671711, -0.0064817025111667398, -0.53760704833357231, 0.25458958836476031, -0.13425272596103446, 0.24189180320235457, -0.79069832768671044, -0.7297393925750334, 0.82637263537873273, 0.93164348655763618, 0.27439497919749339, -0.37126225467796997, -0.052165289104172702, -0.048225757282057274, 0.75379137080249736, -0.84713994039054052, -0.88909711088162113, -0.20389946391869429, -0.46510093508875844, -0.87127320954962661, -0.17764825233140377, 0.43619782053841277, -0.99456367553525316, 0.50206695179364558, 1.3369795296827447, 0.162482261658597, -0.37916983811922178, 0.1321358308662724, 0.17805957876290479, 0.1920360986468776, 0.1385893203817043, -0.50433236078974664, -0.64050386038961438, 0.79286320439640523, 0.58902189015326734, -0.52901754517255295],
                             [-0.47280419402692841, 0.48621044689272502, 0.55057147839183918, 0.61140962643498187, 0.3234105636782677, -0.67459429510258095, 0.43226831074866306, -0.34281983772239188, -0.13517905425947851, -0.54179170917562436, 0.19506667165245262, -0.38156275915178789, -0.5163715172775285, -0.39167241244696183, -0.10713268062629649, -1.5453725407934205, 0.11384726419009393, 0.25719131795918948, 0.094461700329220438, -0.64186473429075042, 0.12570816519924236, -0.33887596356024502, 0.2051236970681056, 0.21987308776564288, -0.48231586234881652, -1.4285794053958383, -0.16126812239659913, -1.2788275378892691, -0.35381154803222109, 0.52934306046252266, 0.84146263830752432, -1.1433191427522933, 0.7322984956054357, -0.26561833066882024, 0.20887008834153928, -0.2248816012125433, 1.6507999106214513, -0.30869000566962235, 0.002803446969165381, 0.84151005156634173, 1.1681304066326379, -0.89179253931807401, -0.58254185063837094, -0.62954107011381799, 0.20346994570166682, 0.10377179401434201, -0.16347949972356118, 0.17404355962702672, 0.67911787217321218, 0.062091845311660579],
                             [0.01296957689424477, -0.17537601333402353, -0.10967940695340866, 1.4605660462639374, 0.14058118717511392, -1.2816869800755661, -0.01293253366432829, 0.52290288237306037, -0.31289761843477631, -0.26975683318938248, 0.87830471588093328, -0.29009145263517039, 0.41309421194550261, 0.16245696270115306, -0.36731482501640783, -1.1692839678589728, 0.18616016921509457, 0.36168404186013015, 0.035719512613480359, 0.065283192422351158, 0.6957146557580639, 0.62446842300033589, 0.14987088047913319, 0.3755113456576511, -0.21045570941807296, 1.0564203574724491, -0.40246462442633463, 0.17643669194015327, -0.47142635824662799, -0.64544193306272435, -0.48857782053211163, -0.47576972284275437, 0.5619327779503599, 0.92572400504102692, -0.38160263909525932, 1.0257472953816902, 0.91995896535043264, 0.6781605788740771, -0.6152081603941747, -0.10994273707780311, 0.33478352515401549, 0.72491486175548381, 0.90317119433707804, 1.3669827671588184, -0.24843378547364212, -0.28137645177453374, 0.68683487217980743, -0.052715710248048539, -0.19056214361808932, 1.4552245114368811],
                             [0.88076723729646811, -0.6464925697852415, -0.44572025843420748, 0.96474862920099924, -0.12545773427647955, -0.098634414159905981, 0.34405697907727117, 0.68078763786552576, 0.77192322333872532, -0.61689021798959232, 0.69656707929549155, 0.95931824086888828, -0.057924904929007724, 0.65700145823219314, -0.41503890497366158, 1.3548315885305791, 0.31238581105187774, -0.14775028017829286, 0.49630168196900115, 0.37896403628868275, 0.15097946124788336, 0.0090107549606427174, -0.70708605455921791, 0.14256568792083285, -0.37121979807369221, -0.35383519799281843, -1.1010330242188997, 0.89166334367141709, 1.4101860315021226, -0.31425994851818512, 0.30555817178484229, -0.11066736059687356, -0.19497536598243989, -1.0948729600303766, -0.36140786208772602, -0.060320699862394495, -0.17969287948866644, -0.24007070312094125, -1.3107707038214018, 0.21538296232499238, 0.87284403770498953, 0.73442490942157768, -0.4005815746288508, -1.0923394677349314, -0.89631894083716945, -0.64462526602712056, 0.23999193435032834, -0.56808978521177766, -0.043048843540099468, 0.13045743488840858],
                             [-0.77294039680909454, 0.31093907400294346, 0.5759830255415026, -0.57099201585824222, -0.14417746107387405, -1.1978026920312526, 1.1053946992081267, -0.27928102654142767, 1.3223681832782299, 0.71409571429930696, -1.2774534609391255, -0.36103915708729489, -0.46335030903774865, -1.2228318776653222, 0.36517170042568703, 0.097938643204494899, -0.088663701753137883, 0.86012855368098995, 1.1281902503517141, -0.066298416186507184, -0.37535013905932091, -0.40359326605787971, 0.68118873081679754, 0.42115308908998861, -2.0793659912661981, 0.6674130830962528, -0.20131242852971312, -0.42307747380503852, 0.055784233363670055, -1.0537410456769634, -0.34884386566588405, 0.1949645144740545, 0.18878444974236547, 1.3338879903315528, 0.25895432592557704, 0.55391715754971615, 1.0880053972383084, 0.93037151911007709, 0.49422087434214346, -0.55774358380726052, -0.4714822244582339, 0.87178243678051148, -0.44959786628184129, 0.75270858356045578, 1.0983960503682326, 0.82856918841022331, -0.25955543620138943, 0.24169360116377028, 0.18008864458707247, 0.25099101711879107],
                             [0.68574866015202407, 1.1413611823154106, 0.35082745069695265, -0.56615616653500422, -1.3074826125179082, -1.3597353510899655, -0.010427569208081234, 1.0091237653370007, 0.072101570412141283, -0.32587362678755638, 0.37357377204677855, 0.24893695587856768, -0.0019875227725064575, -0.70253224197890307, 0.71385272826533919, 0.023071173850753524, 0.23399549900011138, 0.4106693775516943, 1.2032811968411765, 0.53483963063894668, -0.38044887121245263, -0.42124053609446438, -0.35144672833777213, 0.12912309759139906, -0.92093395648366283, 1.2427557629918462, -0.9220942219201318, 0.21725869303513251, -0.20289547280320239, 0.97912425528102998, -0.11274881543358517, -0.2242354487347169, 0.9182757184767274, -0.34011913372167857, -0.2749481348686833, -0.88590312141038152, -0.12726651957391122, 0.29540474137397182, -0.65234595386500593, 0.017140820518698502, -0.76811639871565174, 0.22124970761799653, 0.26117328565013104, -0.31170520077883962, -1.3917052677535751, 0.032511408404555894, 0.044398106627961509, 0.052832887254119637, 0.27242263629103375, 0.58709376809227376],
                             [0.6800411738893456, -0.13922406131015666, 0.85913027984269641, -0.0094206922508416856, 1.4275745177729926, -0.48436721447963399, -0.89734256447715077, 0.21690904729728014, -0.87985379110809359, 0.17603008018959987, -0.48835724862255847, 0.18884428338262726, -1.2522170917017097, -0.91919057974305873, 0.97304201496064679, -0.083358458221498191, -0.4051374737267846, 0.67134530935387604, 0.3236589324498067, 0.69194802913335318, 0.88011800186622169, 1.294589912488348, 0.34694196103656177, -1.2581160282446346, -0.074729205143765701, 0.17357883400482801, 0.7259473477165338, 1.4272015401393432, -0.016686517342959256, 1.213620193121377, -0.51736252250558745, 0.42217953518131196, 1.4913926285044699, 0.52076847968566065, 0.84623778912452385, 0.81240432612891034, -0.8101956657041548, -0.028655588514734272, -0.10865610952910121, -0.55464904472174492, -1.4537457451937976, -0.42066100657736621, 0.78632831910240775, -0.45821339144401591, -0.22209921666549609, 0.17132697034679467, 1.4826593719192303, -0.38801746496465855, 1.8262049592219838, 0.15250190780871176],
                             [-0.20399265947392556, -0.073452272895003196, -0.65027805014787854, -0.44055366951429381, -0.48858737026505761, -1.4056675137862895, -0.25352771955129905, -1.0600343949812314, -0.24429489473969018, 0.2714515726725496, 0.74127444398829201, -0.50298576261235284, 0.73372217531908468, 0.25733940767247238, 0.36170564204653777, -0.4991702836664052, -0.098963409339792516, 0.14148093713697801, -0.51682914570905092, 0.47589255685575127, -0.72854393018951025, -0.40551883715257214, -0.96720381327862082, 0.43667597380188017, 0.042654235874435224, 0.0091927019712803367, -1.2069837286277711, -1.1196049754085264, -0.70176610889015223, 0.38363940714195754, 0.53209850795230351, -0.26621827798931297, -0.27193951067271233, -0.23874213349893117, -0.12917571898063485, 0.58411054387608885, 0.052264843315801279, 1.1691749040613841, -0.56756665866473022, 0.49933391854877213, -0.20228675275866945, -0.54006850656330252, -0.7779900266312707, -0.6071701748875411, -0.83637672854863043, -0.16455311602288847, -0.22937854276831113, 0.53546723879230984, -0.76797812055769199, 0.36270139240399107],
                             [1.7039937799859983, 0.40260450231491746, 1.5132226727132398, 0.90378538604441838, 0.19431084298015358, 0.5032595581872521, 0.8767832635221896, 0.11686687201928996, -0.56019165167139828, 0.73736491687875827, 0.54678259919581795, 0.24331928979017639, -0.36235915693384102, 0.40652876551751793, 0.26389725103683054, -0.35983063446385971, 0.74694627399540436, 1.1056714465650335, 0.025745203076105349, -0.70511910969198843, 0.6330963326416601, 0.56187516740375121, 0.91380349961407492, 0.047493362061936474, 0.86017147903474722, -0.90925484584219496, 0.71815334828147859, -0.92521052682997962, 0.29366394341595281, -0.084928754097105805, 0.48661264125101916, -0.47436719784337505, -0.21171529877486478, 0.48387989129260733, -0.25725883197056881, 0.33965692634342032, 0.12141539132305719, -0.1027315445937776, -0.11848651219876659, 1.0189601925294975, 0.64669679057635787, 0.011451344793772716, 0.36330308370472525, -0.90306183664405726, 0.11370400257778297, -0.34622157945086401, -0.54968176542802638, 0.90852452860099131, -0.21936668142728391, 0.41166208703441443],
                             [1.6953806555134541, 0.49143893491135859, 0.52091682534916706, -0.79077010294796246, -0.23871835335500172, 0.41816506961752242, -0.24484255685758874, 0.47133512486469509, 0.46363679299382238, 0.18292090801609817, 0.37621231546469069, 0.23630325166345811, -1.4518500337806564, 0.64897034498881712, -0.36032556484496181, 0.14611238037198723, -0.47496329055495973, 0.17902828645200172, -0.60067908147259341, -0.21973734627583219, -0.17137471804076096, 1.0366461318566094, 0.31600458130798925, -0.60433724094546226, 1.1694804507079701, -0.88325722544492213, 0.34520581752079532, 0.90525854930865113, -0.28956912182275801, 1.1361282482908706, -0.7266442887336223, -0.15007362803396868, -0.098130298404221827, 0.074043363747180596, -0.63464302395396033, 0.43416981169431784, -0.34507495062463261, 0.66732564729959654, -0.48749570124618236, 0.12161635859979979, 0.18934862653866041, 0.5777707547251405, -0.15168209880587649, -1.2294937116228626, 0.052478711096064688, -0.12963920919074806, 0.38904380954440859, -0.47062827700832588, 0.63928287870415934, -0.038356191947807802],
                             [0.78668576959341274, 0.093444688852913099, 0.013696624480200925, -0.14424664471472984, -0.7261970177218332, -1.5761859320628375, -0.071511612448211831, 0.20012288868994052, 0.61904032467980219, 0.6356937219734784, -0.57790728025149007, 0.87178188014481628, 0.59200843408837245, -0.8702899331878643, 0.034410993306802737, -0.53192037575814044, -0.30819775591501891, -0.24858175299581625, 0.090462563496963216, 0.62671325641807696, -0.44750273823187287, -0.3350151513596511, -0.36060771956391968, -0.75951005331444543, -0.0022452689836762567, -0.47128170392677954, -0.34687065149239676, -0.62580518116909856, 0.18487289722578318, 0.2011806194837274, 0.54020772362347624, -0.048630411774476828, -0.15981160232110025, -0.35726690589699706, -0.43127027340139734, -0.37854808965292619, 0.24957975583380484, -1.4181683814823431, 0.90354453476613128, 0.48437643998801433, 0.43870407257226945, 0.73073447045174933, 0.76933310651078135, 0.13093513828172509, -1.1164233576215428, 0.057572106232315949, 1.045321339821222, 0.39072312502606565, -0.34826332670622684, 0.19308029033427149],
                             [-0.67437041285989319, 0.024199475776123216, 0.29999509153361098, -0.29386587018227756, 0.47128923809533529, -0.39805241021143012, 0.58973284278442584, 0.14832065979625286, -1.0631384968057989, 0.13680295079493596, -1.3354832770503464, -0.97646534011869746, -0.14073599345986329, 0.620432221627231, 0.42952337288477144, -0.062603673427510789, -0.59045730226644821, -0.40763519845264601, 0.80928962104009117, -0.94431923724205902, 0.54430175272361447, 0.35988076539344938, 0.36633362037859674, -0.97978357654622739, 0.36109616977112446, 0.54863046474794541, -1.1969483578334814, -0.95675833501609941, 0.74925275013271808, -0.77016523817104021, -0.27515711054757702, -1.0380049037285315, 0.20682118063934421, -0.34279026543316954, -0.74902997936293569, -0.83609102956019887, 0.85969549329815143, -0.54613310270588289, 0.61272076664817476, -0.28559042723643718, -0.74822401203008271, 0.33049340032507479, -1.1296941080119893, -0.21355869910119449, 0.57323612724253548, 1.3809829605372475, 0.52152439749591717, 0.74447250660074116, -0.44000908496419239, -0.96655245905989984],
                             [0.0072209112030086689, -0.30025336354691973, -0.16100476899633046, -0.75670468001464031, 0.49958788167445806, 0.19976680302412531, -0.57325732954561792, 1.4042129655566908, -0.23538116524157562, 0.064483471738947043, -0.71917261978963942, 0.2863801321148266, 0.96529540052578555, 0.057661064690807569, -0.24667368181927193, 0.73309620431955147, 0.34334508635943278, -0.40481571902474456, -2.1312963714374944, 0.63680242631657713, 0.77142696233919916, -0.65316190329299484, -0.93412713098577194, -0.71159081334455898, 2.3232488481550879, -0.92238358568357903, -0.16154892227164372, -1.0575342980651454, 1.1942852866515004, 0.05887980502176364, -1.0287339106095101, 0.025376359962009518, 0.3261519508428059, -1.2687632185644517, -0.16533882853359078, 0.65915808652205554, -0.11068499896988397, -1.2492365975840998, 0.132624580999468, -0.70791790287348344, -0.54932086013328951, -0.040407403458506068, -0.61636785927212845, 0.19143899932147407, 0.63906200533112034, -0.8546474005900494, 1.1583229228939373, 0.34684110602603874, 0.28340573385978202, -0.360927582631551],
                             [0.5522194667201793, 0.90933085323099705, 0.45812323791037141, -0.33195706864976932, 0.76920742593354385, 0.69286800121376102, -0.37696379609043745, -0.45024887088747578, 0.56558982326085017, 0.022248273777649492, -0.2126754334964463, -0.63630283126251241, -0.35114054424309921, 0.13146288356817518, -0.041513347619072528, 0.62347575679807221, -0.25374176823587058, -0.56886565847064741, -0.011220806597430334, -0.98542159824255049, 0.22919640570528507, 0.029179170258381643, -0.093228888109916488, -0.11544683772748823, 0.19556453251583009, -0.40165735724577423, -0.51866093866981677, -1.3002976397832895, 0.038601148714918335, 0.18087026992215335, 1.6629504536095665, -0.23456750471012572, 0.73076407043259595, 0.18863568533549027, -0.90727930340635465, -0.12997313800599214, 0.41636345369700783, 0.41501682894340325, 1.2709732275456862, 0.251580132025226, -0.070436591541604032, -0.5510359287155514, -0.82980624648886725, 1.2631360350695819, 0.10292478058939698, 0.21331182572302146, -0.10775125957174558, 0.21295618610340006, 0.072582223235058294, -0.59909448404863475],
                             [0.65855425905015397, 0.35376009907865802, -0.39514205986596346, -0.59500494580045626, -0.68563553355711027, -0.84627226904583486, -1.0074897736970727, 0.58045817743460271, -0.7668846577895172, -0.021227213884117892, -0.35633734965321107, -0.59802973889242061, 0.19105828961746685, 0.014198807064915449, -0.18548203857885384, -0.047022097207226159, 0.40954172226452423, -0.55124410348817032, -0.74630019039430906, 0.61700991273157413, -0.61995936674319574, -0.98667739944867039, 0.0370472184373076, 0.4989707167934197, -0.42629751523904214, -0.46925267569915385, -0.77355301899154283, 0.45102186980588704, 0.79058227823674043, -0.63105809226492449, 1.201664897261012, -0.71293279205948945, 0.54539634785472602, 0.42321889959447706, -0.24788698437343468, -0.85782843157265876, 0.64994068500576385, 0.95219846482203285, -0.35713772374630359, -0.83723495387855773, 0.54854943087051755, 0.16931166503429301, -0.49888171751414301, -0.79331904914255758, -0.51309916089661534, -0.12081178548126653, 1.2987405370650325, 1.0027040558841165, -0.23786601155736595, -0.48627107072087888],
                             [0.59887753313656211, -0.01022149439296997, 0.70813852163756097, 0.46221510920718495, -0.34383695831092592, 1.0354829242290402, 0.04505784814164613, -0.59337129532349908, -0.71857114301667857, -0.14007326033179757, 0.44894432059048117, -0.060882218341301086, 0.27649335848719653, -0.43665590901740126, 0.93619726934600056, 0.14769892757141517, -0.095227342310298765, -0.38656467245528331, -0.26625778404889372, -0.21313570975549467, -0.8231807491049643, -1.520804701752059, -1.0774783815163751, -1.0555527121522168, -0.10373141655073931, -0.42841735340141707, -0.99222044885350347, 0.22619412912692358, 0.67634857934095127, 0.21255932949226197, 1.3335337874168049, 1.7052024864689381, 0.033768538605376708, -0.96907380291289191, -0.35962247466166875, 0.61971576917810212, -0.077155071723721977, 0.67939591908907404, -0.1821136457638983, -1.1338679881224447, 1.0306749430798074, 0.98272053569182949, -0.95965325380053679, -0.64638721954854983, -0.88128977129085895, -0.51564219179284543, -0.61246913171746387, -0.097518090439431285, -0.2383806057774413, -0.2469054791311121],
                             [-0.047228544391039295, -0.18493984506969569, -0.91609706596201002, 0.12710488569939965, 0.56339996788235791, -0.50012570415452984, -0.32886958602995664, -0.45752770278229954, -0.73772885690331902, -0.21548678359611062, 0.79222954583493876, -0.11605698487617233, -0.14382686719447663, -0.41866553543843088, 0.6163285059329624, 0.66007719007288712, 0.63307061990000824, 0.77881664017599217, 0.0097421569701512944, -0.8647919214423494, -1.1568088128768639, -0.88693758624003527, -0.89377513506222783, 0.36196211745358547, -0.74479518049174354, 0.51201013066927037, -0.60614795909321739, 1.1610674071604263, 0.76902859443826621, 0.29230808067915548, -0.65448926380883854, 0.60913789853881661, 0.20548823184790332, 0.12898087799904898, 0.11758157351271342, -0.81703313488253093, 0.64412206033434327, 1.0449600282788551, -0.89396760164535438, 0.5132898799497646, 0.0026927832406416987, -0.23495664192972573, 1.4877795014495501, -0.19516355734305305, 1.035691080019068, 0.53975744706856743, 0.15306021656564542, 0.15962514516715268, -0.74656124831421888, -0.059157213454860358],
                             [-0.2662750573942459, -0.16398787315934846, 0.3309003085715313, 0.19384783460263905, 0.10810722526751997, -1.1046968171242553, 0.2622101229801328, 1.5361691759441449, 1.2743365362368211, 0.1453947937917438, -0.8949757010762619, -0.58028885898006266, -0.53894515968089352, 0.36766602957063033, 0.47532464566085414, -0.082995909378765761, 1.2830529846617669, 1.6132446429784024, 0.22098195732098094, -0.18990254436146264, -0.14373872187274619, 0.060154678018047726, 0.60323858878773406, -0.83815585687872318, -0.74133856215490801, -0.28688763832839365, 0.41970117626378012, 0.0073992761214039839, -0.041269166741650334, 1.5545485308856051, -0.64889212167270849, 0.59677270499019974, -0.9726583029970326, -0.18254008358793691, 0.022945061368580738, -0.52963964305250133, 0.37434779634179716, -0.40995438607699364, 0.43761276052234821, -0.51842424986098457, 0.028589225446212545, 0.35135519954147038, 1.3269640174934199, -0.24844592296890167, 0.42294010977819158, -0.096616114821042778, 0.67888499665680824, 0.16468071762924177, 0.4406133799096269, 0.88754450039258692],
                             [-0.91319567578245575, 0.44723176319683394, -1.4451073331066784, 0.48467076172657308, 0.46122560372898197, -0.40197178267263683, 0.39305475087819214, 0.28478760278395909, 1.2130310468197489, 0.27221065489039847, -0.79829788620805586, -1.0076786016359183, -0.41943918630411303, 0.43978465130172234, -0.29624720298013663, -0.59843723676274518, 0.99366673969121388, -0.69253113770539187, -0.63803117738662829, -0.52431635085085204, -0.67391423796675431, 0.68695197709908118, -1.3161768671777887, 0.37101520612173927, -0.30553055409022079, -0.50776649337154156, -0.4710991363261583, -0.6253404609988471, 0.44625722179568694, -0.90612464203264476, 0.20945134260956633, -0.68258228401151577, -0.48416947379431097, 0.70085387918479791, 0.11494883601126545, 0.19046768936552846, 0.47966358556061317, -0.58186363948603237, -0.3092727385029414, -0.23928778996634903, 0.20678920596756814, 0.69825432217893846, -0.34882304098971118, 2.1779906587263445, 0.10936658818104962, -0.58369958309302472, -0.11176308218067317, -0.85880411180984284, 0.023075402214455493, -0.29660329263384527],
                             [1.3859913068241023, -0.51938473839515376, -0.88045157759769233, 0.5675148754370215, -0.7294777371531298, 0.39138416414044236, -0.12296706309132749, 0.32345101204281679, -0.96313245445331075, -0.034886138418896769, -0.68683204066948722, 1.1040293801239571, 0.62192288891277547, 0.17625941865710484, -0.11284195660210267, -0.74055802419683792, 0.50597060447210551, -1.5248233451493978, -0.323004461091772, 0.46784571029367661, -0.33486492992799721, 0.32042968246309406, 0.57193381968677204, -0.15968605022726173, -0.083791105482726141, -1.4674701863900468, -0.64596338236061046, 0.10714263646295347, 0.46436023436678553, 0.43985282012747268, 0.036349491082221429, -1.7444729015607781, 0.44611962108419406, 0.11092676976948668, 0.3167243792409743, -0.042106040203646139, 0.61967380123596094, -0.85984858801420128, 0.012912199247506178, 1.1803266143362201, -0.055262936454644161, 0.27812974441640687, -0.29114603228922054, 0.55900464766575586, -0.81194786126320606, -1.291154554517713, -0.25483165762299204, 0.068618922884374448, -0.29211828507867843, -0.70202533857006189],
                             [-0.27067773460457967, -0.69931853892140217, -0.068147582342702684, 0.31876609790752369, 0.21904091223508579, -0.034181289743115913, -0.14957925935041846, -0.68811828462260094, 0.26278432452036637, 0.26795011686966136, -0.26616766203032061, 0.34582407762676348, -1.0439254063255203, 1.4210658008001913, 0.95304555051695283, -0.078891588176744326, 0.66973691331632978, -0.12230699669967182, -1.1334119062452805, -0.63344442609337936, 0.18070570489458468, 0.034093123874203657, -1.2981899358022502, -0.49237144433807967, 0.23796855850357673, -0.84595312918331944, 0.39762465837913724, -0.032919888055412266, 1.613227730314551, 0.8930101295552787, 0.12905571217269413, 0.71074096642032458, -0.029029837151099636, -1.0405945431843082, 0.93561016641725903, 1.4413436207047163, 0.51868255588756085, -0.57134080293134892, 1.3141758987553589, 0.30996718272483392, -0.18670445796482552, 0.11941831511952752, -0.75329951697748365, -1.4619324443670656, 1.8243940134710113, 0.3658492520201902, 0.60336559138509338, -0.76518876984994533, -0.36744254808680521, -0.11603249552612893],
                             [-1.9997761179102786, -0.085980627056908385, 0.75520589267068738, -0.42844150681158805, -0.74490642098674908, 0.038019793785835768, -0.19209874601896906, -0.36329277050196607, 0.50266934460720414, 1.670202352562226, 0.024703835340643888, -1.098101491303618, -0.64683897011788516, -0.050126440248866339, 0.0047579333730427102, -0.41693750724165735, 0.6402763996879568, 0.5211652039881417, -0.33422459512255825, -0.26123222542357655, 0.77763376433333797, -0.4669453694353336, 0.080887875577499171, 1.281696863702535, 0.88956674316407824, -0.88021820344779056, 0.70733742224666607, 0.04212189175033236, -1.0914856216500211, 1.138454411907174, -0.77558662094219177, 0.29822552263304131, -0.96237580255705835, 0.61702239493710065, -0.25673357286103354, -0.11173744446237141, 0.12844421961649155, -0.057844727390106647, 0.9218393275666098, 0.0060089089600408692, 0.034598381841094393, 0.29086751796821175, 0.43926949314802904, 0.020632901409363358, 0.26263671835841995, -1.6203767284660668, -1.0926141317805591, -0.76696643178823476, 0.3847949713994091, -0.55684632748264307],
                             [-0.45020938774321406, 0.05486469300067591, -0.30542963281385654, 0.18252004806609676, 0.50903397909498449, 1.3748737985463602, -0.38675273584316483, -0.49522501785419415, -0.38315208826114178, -0.33015801662198996, 0.78593789329560404, -0.019071121485998863, 0.22009374660842335, 0.58416550559311675, 0.42285997779378437, 0.36743696913581708, 0.15447103937187548, -0.36309130671802337, -0.42257532409370074, -0.53034915754851897, 0.26979230049664948, 0.53427253983774137, -0.45292854231344515, 0.57481384207673036, 1.0259732766986327, -0.74550449057644008, -0.35821648289034869, -0.32233100934463199, -0.5771180485107017, -0.69342425516186457, -1.2305452206950056, -0.71314686263577209, 0.13399876528462373, 0.050939374176783028, 0.19791019872419033, -0.30953575211158152, -0.23219219029228702, -0.48143241262998343, 0.10077844528885166, 0.33604650499849698, 0.52956005909656267, -0.3422750442450308, -0.51394307667003802, 0.58055795306801805, 1.2909595149998612, 0.40970600067766738, -0.056650880556389394, -0.25237940751614335, 0.01041072789987826, 0.17203343458933154],
                             [-0.34708030265064771, 1.9700153925345969, 1.4641307685076301, -1.0708285655417698, 0.22190584557367252, -1.2223630079589096, 0.52144431827275839, 0.16710811758019858, 0.23358270010595869, 0.47880172213448369, -0.17896081126156282, -0.54058733652201074, -0.3465745906842595, 1.1259445138480462, -0.43433992973269075, -0.060596173719536101, -0.18941762790162173, -0.7725347697654481, 0.27572181230560627, -1.1090751732119788, 0.22109152087713763, -0.48361425591614521, -0.41021062738184588, -0.024463405919764925, -1.0721859942791507, 1.0898863463776538, -0.34446296006770533, 0.1753336988148535, 0.22043560032197049, 0.77794392010302504, 0.5017025157248296, 0.43458560864521373, 0.046722953224375405, 0.0039733314275122982, 0.23914805125441591, -0.94365441101902447, 0.67465742048418775, -0.7805567729471441, -0.50794996048124164, -1.0619768801323082, 0.0090670314995809128, -0.72650624544615861, 0.89863045782028639, -0.13087219792415261, 0.73960381649703744, 1.1789117958963258, 0.7510575917807969, 1.0023798099614274, -0.20911677350460611, 0.76604700737887543],
                             [-0.66062142405121183, -0.87075043186038725, -0.56512945862369046, -0.066790403357883013, -1.5100013847599274, 0.30358013029828718, 1.384501477753497, -0.50889897801706885, -0.38828415618529699, -0.62135503611034337, 0.17762879462678766, -0.75513017260074466, -0.61908850867398912, 0.84432124466842462, -0.18534535068077967, 0.40910241717437573, -0.054090666253108967, -0.5811755387838704, -0.10609277540001642, 0.10571495858205322, 0.11311188619049527, 1.528312008394823, -0.42884947431874304, 0.36951389094536918, 0.38278127440989873, -0.46002913479094726, -0.070138374059592279, -0.49214277091951925, 0.93359929730877489, 1.2618393533561281, -0.26445579006112063, -0.10822356107078898, -0.22380676165379168, 0.75565747324117472, -0.11510387487927784, -0.16795583974408276, 0.52898670125542957, 0.065619418812359401, -0.42050337367082574, 0.35747013487519702, 0.6689815174325846, -0.40279012408072867, -0.94602793558561482, 1.1164574051435765, -0.18369850725355083, 0.14046605495846845, -0.51611027782390528, 0.046484503891590395, -0.63608050908049896, -0.83736597545578362],
                             [-0.50674557828285882, -0.10853771708529597, 0.2876068837150153, -1.6766714290618578, 0.45783881598242482, -0.10379746221633201, 0.27654055532417887, 0.49799903658216665, -0.62241219848856866, 1.3698756227480617, 0.77272904918889906, -0.6381134053439721, -0.66595720849313922, 0.26296109464837714, -1.384051513959345, 1.0375585064807122, -0.51953918906145247, -0.50334668771587376, 0.43877599272087597, 0.57892562519322532, 0.27931203751174544, -2.5092992073665661, 1.1370409589163206, 0.97659954931931725, -0.49151827783105823, -0.8782968048671288, -0.3560199675976769, -0.93036195487614859, 0.44269976886099649, 0.18874983335397727, -0.71435411838974394, -0.9368286382457115, -0.34415930625593438, 0.049398865569752586, 0.40475763405828846, -0.84434261752734263, -0.51034048851826941, -0.96899487239278836, -0.65605102633601764, 0.35252452225116676, -0.15393570317126107, -0.24488543591290204, -0.49190829377942058, -0.83927563491053647, 0.0053741862442598974, 0.85408415729822296, 0.72936084077778862, -0.024517082210059101, 0.67016438008168555, -0.26183076942681721],
                             [-1.1272776261650304, 0.9492858934483448, -0.45537947464568279, 0.16679737294828428, 0.32807383294119624, -0.29735824137331296, -0.11833143407270361, 0.71829237470691099, -1.1525437605346647, -0.2012835138171612, -0.64753145656436006, -1.2393762587520369, 0.29747190913635579, 0.35452588353558834, 0.035233520176495198, 0.81507694732370306, -0.24059876085870205, 0.37734765919346042, 0.29895485879917372, 0.54974913646587964, -0.54041287413560113, 0.095351914952235939, -0.14926459129121397, -0.73478080773422283, 0.24656845920414205, -0.49523370859585125, -0.14638276002252348, -0.25050653791407568, -0.41550867571909816, 0.37980203866555629, 0.21779746879499054, -1.1570926526834431, -0.19465759712672878, 0.54881336750738752, -0.2200072672020916, 0.55242599237732959, 0.039792060706499321, 0.15292461653545553, 0.070072945325772032, -0.46641504569012393, 0.097000262315262015, -0.54949595853280864, -0.61024305301552484, 0.56814752630440257, 0.61097450250163199, 0.70930911943523389, -1.2652016110115945, -0.44714300136342522, -1.0760924127582228, -0.13270437776269911],
                             [-1.2542195014763997, 0.93169066659549171, 1.0372774753112304, -0.79443782139254426, -0.37494860955667109, -0.39404267720305464, 0.44606655977811244, 0.42482840711208136, -0.0045157616354437229, 0.21842250052202189, -0.12067876975115856, 0.21931511081077271, 0.3273253895703479, -0.30514962635791953, 0.65715253258838346, 0.23344417704437556, -0.041148293068255522, 0.10797194138070922, -0.31182635317310825, -0.31978334291513566, 0.53220090346268256, -0.38974052900453326, -0.065006585629298341, -0.60958991451323974, -1.4200571277993415, -0.46351872745776174, -1.1666776108782744, -0.46087493638014199, 0.27828139005966501, -0.13935375272854023, 0.66669380167295667, 0.74094127435657686, -0.025131078589789906, 0.65946462926007321, -0.26484179465412166, 0.78071716768717947, 1.5891561445597424, 1.3411847881930783, 0.60270777976292123, -0.3942973232120871, -1.0109728716713466, 1.105069922166904, 0.32836842832445068, 1.1082627116737727, 0.24129900784687605, -0.01990965906446043, -0.24717275629342503, -0.96400401966663352, -0.39651232827962701, 0.10872825885061088],
                             [-0.24084605820920155, -0.29898049873718852, -0.24580036273362385, -0.51126887299270474, -0.24819507759830459, -0.72810283641148643, 0.31325529257497364, 0.34022873710731977, -0.6748460425043622, -0.61382661101645852, -0.16920512704921806, -0.39477954876993571, -0.66482890666915939, -0.36275967255782193, 1.3895372743965502, 0.19307297358951295, 0.033149247239395295, -0.54636889636548669, -0.36899493039844267, -0.20607821518650274, -0.88977063323197647, -0.067605345952669593, -0.21877292711729315, -0.9265953916441978, 0.40409075750644741, -1.0289618987663471, -0.066134660777404153, -1.0805157547608144, 0.84260057879062511, -0.070428186308186702, 0.37391738124128465, -0.79468085141173228, 0.40265288085039674, -0.32925344044930432, -0.61912271437639055, 0.74663958748802484, -0.64761611946793118, -0.22026145039297257, 0.41758650649470086, 0.016255244391255433, 0.26363416015748997, -0.79527290361751368, -0.2071161044962814, 0.071295080899934457, 1.5463579421885432, 0.64806999908679763, 0.94481832230565554, -0.43499739644876828, -1.749279539452556, 0.97028925057589033],
                             [0.12301513191321671, 1.3222558734742165, 0.16644529473255076, -0.48236248029242135, -0.43041078310108039, -0.227095855016135, -0.56860226623371457, -0.037468647042017938, 0.11666011810301495, 0.66695970587408937, -0.31561968668661655, -1.4409711511067549, -1.0010625638416906, -0.34872362301925941, -1.048975815240389, -0.23453925096725506, 0.51842192486581951, -0.13261705544098484, 0.2049100155925106, 0.65344748658171614, -0.28882800990930574, -0.57456790875374664, -0.11994709358733686, -0.29595838821835119, 0.13862695173714701, -1.0437804938997881, 0.52598401205636336, -0.26268544582253806, -1.1020825813843917, 0.48340155553303732, 0.12142947622414249, 0.16660040237231127, -0.62885282272985432, -0.28903272370187166, -0.063944816571622445, -0.49066379873126392, -0.33745347424873245, -0.13993602089761806, -0.144321017076598, 0.010333680879943697, -0.61956724556830034, 0.078559422834322407, -0.3236176083080779, 0.08575460095372453, 0.0040370297856800593, -0.68286293331335646, -1.1416076324411053, -0.045158376178800079, -0.11550406535406829, 0.74839443211876089],
                             [1.5669899365342681, 1.7487571835393525, -1.0653057295144657, -0.62786236296139231, 0.71283618037588214, -0.50121506115637104, 0.50581477444956502, 0.97544395944068751, 0.13799869576558521, 0.19159490103552373, -0.88931731118267154, -0.41241130859099556, -0.91545689656305373, 1.0578371316800388, 1.3556125504675807, -0.54359396415778904, 0.14191584387310308, -0.011203834892572023, 0.379932999957936, -0.94530528163855065, 1.5309301109957942, 0.086213402400087735, 0.61648815097645793, -0.28266750830152421, 1.2169027237057914, -0.060992202664374717, -0.16980983150429893, 0.35822234015505289, 0.86047636088596646, -1.3513982903671384, -0.84802425033464268, -1.0909294592126237, 0.2710022608787222, -0.10910773773099063, -0.18016582863343303, 1.5816418539059049, 1.4821955457637892, -0.069956588029811639, 1.3138418667035021, -0.80455673199031397, 0.54012499001656999, 0.034685041654398112, 0.55922431730383726, -0.18456322562242514, 0.75152882083956307, -0.014747545770317026, 0.96807098036264361, 0.68340021868460321, -0.74818883284212201, 1.2939463125444581],
                             [0.99344227816697472, -0.59946428743874114, -0.13155933579852691, -0.54526905472285148, 0.2643063658545764, 0.44017620905389715, 0.0091355831232029297, 0.73126412037362587, -0.0056900418893256095, 0.59026465577896658, 0.38389450388192281, -0.007729412119651953, -0.032673989613523954, 0.94262841361422012, 0.72239586480301021, 0.21214266441095192, 1.5241055605217635, 0.062459363375039156, 0.086245900781318538, 0.1527986815776296, 0.62595455511371145, 0.012993344566632795, -0.57644031633159776, -0.11787206731574854, 0.34287498564876562, -0.86240200519882571, 0.2705701841981506, 0.61879450102598432, -0.10640544066442797, -0.098026876841778743, 0.33890986666809131, 1.5211135903633426, -0.3293323578427606, -1.2770614809513934, -0.77926555040008938, 0.063415516966738777, 0.76709517387106807, -0.15417435295758708, 0.13104415232044739, -0.15578576739028294, 0.090265257155903778, -1.0219522276785533, -0.60288101457314258, -0.053467191200495985, 0.13900555123602787, 0.091739111481201133, 0.30184565584457534, -1.0466573685748146, 1.0215647500266891, 0.59602589555768037],
                             [1.1644776415120821, 0.54863395432574735, -1.052641130492701, 0.97140979136409955, -0.15250723137462904, -0.91052469677287651, -0.70911675502622451, 0.21003976119444301, -0.67129496888822349, 0.25542889115041956, 0.14224343378258633, -0.087045799312281763, -0.57946690661013811, -0.48158416682810001, -0.54038863867780995, 0.061880515279424654, -0.90128434965256832, -0.20405004872678295, -0.24419895945398795, 0.68315909352654802, 0.37160775865147538, 1.1350291139908113, -0.4544986093973768, -0.16090520065334094, -1.2626739561674531, 0.067247551249462578, -1.3136677724839196, -1.143191408113557, -0.22104930766819483, 0.11192684832934455, 1.728606295462678, -0.9154677978328406, 0.23417353147781864, -0.3374671188684466, -0.15153944248901868, 0.61794499160124683, -0.011208341624479026, 0.31461204977787016, -0.32770005976254779, -0.39409979428205122, 0.21749770597683882, 0.033762524152052137, -0.20173700807844194, 1.4424758481841018, -0.17813723999493583, -0.72505580813978432, -0.55428668009021176, -0.75515336907833075, -0.012722068278846175, -0.71538698719052918],
                             [0.2995463807524727, -0.078621557078710796, 0.8602574589050126, -0.13400872293134256, -0.25976130205785025, -0.5968660215690994, 0.6928260027202755, 0.41820605938938427, 0.55452696471196294, -0.95993126755843983, -0.73967236073248677, -0.42976165489909773, 0.72099318064696349, -0.12949822404473696, 0.01645071672045495, 0.081764198236621913, -0.25629030169858841, -0.32964801743592886, 0.36610875239957341, 0.57200569749649743, 0.055841517837475117, -0.23574784113340688, 0.64678157801648839, 0.28748077675459627, -0.0934113890940097, 1.2180402233541003, -0.57597508329789893, 0.48526588821405237, 0.10635225385566938, 0.13899751157872811, 1.6244091940191352, 2.3361852295591725, 0.89027462537401869, -0.029888517029608361, -0.12142002284849439, 0.58143051998779649, -0.20834737927212341, -0.16227703752383779, -0.35340845141965355, 1.0794742333398182, 0.72092130499330398, -0.22485422795400556, -0.48984574016815402, -1.1914397906076681, -0.78209926972397792, 0.053840729302405646, -0.9730281456127412, -0.030384284804340887, -0.19361712204442313, 0.94215919536533932],
                             [-0.29425452655388129, 0.49321334529856115, 0.60545366370574505, 0.37972067382860597, 0.93491766729981729, -1.0597496064386347, -0.13541820776147409, -0.24828988522218035, 0.66379218445968102, 1.4562212844947278, -0.41676863024323296, -0.66763380186722798, 0.086698776067527406, 0.024808277881720672, -0.79191618878170744, 0.42139481174783955, 0.15615582606708955, 0.44841506741373977, 0.64839649468887528, -0.87055880649594641, 0.077242571990718129, -0.019406194472020237, 0.30743377872194688, 0.8287895972056174, -0.56559828697011183, -0.51742684185666055, 1.5105337296840839, -0.46998063306528792, -0.067225751123844935, -0.062689687098911734, -0.46663012766243578, 0.68825852974575774, 0.28855517341163678, -0.94073041575144256, -0.021145447682453473, -0.11021822802494566, -0.26661003804687633, -0.018730289355487845, 0.94845548139079794, -0.51177231185698591, -0.42733006511331467, 0.60111191462698721, 1.2400826173703374, -0.41200028239266767, 0.22158123118104703, 0.18331379724042313, 0.9798572612968196, 0.7924460429378134, 0.041133344090594666, 0.0844621676227921],
                             [-0.36968111809348142, -0.78741569968072989, 0.44310489468332437, 0.99390935965890859, 0.91827468515431765, -0.1274020424785913, 0.95727176150514204, 0.53653648323087355, -0.065980167732788503, 0.040642964631460866, -0.024276086067585446, -0.56075896307101658, -0.25293066413343979, -1.118222672740125, 0.084649906594237379, 0.056175807035063106, -0.019194710105311132, 0.09375123723275558, 0.85321019483252547, 0.58785948883785266, -0.73997987066544479, -0.047287616449488437, -0.040700429168989097, 0.59646830378302285, 0.14873598599925425, -0.54838031595503933, 0.624009929279424, -0.016065346914771964, -0.6145662687144291, -0.94149491593593027, 0.2871078690250819, -0.56076609106621611, -0.80142419922939434, 0.74580599306842321, 0.32229299240620884, -0.27007724577290687, 0.15320821469594995, 0.37812230812474446, 0.98837982054239693, -0.08374800024045681, -0.11357479864687299, 0.41614206486785044, 0.030953805038276459, 0.4178746852691857, -0.21691025345398415, 0.41409545406446879, 0.87717294869412887, -0.036807371398031571, -1.5382964098883929, 0.55344630213819324],
                             [0.9605348361002608, -0.72183180421523108, -0.18380130675813139, 0.14371447244688371, 0.8225761442212528, 1.2361920810615408, -1.1461845108042141, -0.82211986654444258, -1.2187474251022627, 1.0062805668425518, 2.0904529907314586, 0.41017299001696339, -0.66565170079754166, -0.23261203477570339, -0.21353751460370268, 0.85292238242775098, -0.1950367745909109, -0.078138608555479355, 0.75017650855711571, 0.33328806228449936, -0.039472203011021438, -0.50658606711060006, -1.2412051679807081, -0.25459583111448586, -0.91174082871129969, 0.27793081137674297, 0.66604493285704169, 0.17433941783450663, -1.5767649785685405, -0.47260714943464971, 0.23230987005577494, 0.93419757192013075, 0.84049829091472461, -0.23271876349065154, 0.19696020033522732, 1.2032323983017861, -0.92343931136545032, 0.10141390106839863, 0.01908383991132153, -0.86253237362840807, -0.8042922448773866, -0.92050737078414857, -1.1873458995057435, -0.60093747353909821, -1.0263668805106232, -0.3869898374875132, -0.38373554934216425, -0.19809693772150613, 0.22501513518326599, -0.32830459515852972],
                             [-0.46837688492320234, 0.11303150852249538, 0.34826211933478946, -0.17642311473848682, 0.14824430610093375, 1.2006650627359128, 0.47552385667180025, 1.0318354049905978, 0.13882080291243806, 0.97723478196041547, -0.81018717204850965, -1.0186200740460039, -2.3755672759238742, 0.70686684657232801, 0.14146111207383383, 0.52305182686125617, 0.10235810913855141, 0.37751391258383804, 1.020085532914661, 0.50474896263884295, 0.088416588539662194, -0.27869361329543274, -0.58914207876002456, 0.50080544436353092, 0.45653615896518179, -1.3590383317691257, 0.60630119023801121, -0.23665864082144539, 0.42554803424365917, 0.1293361839115138, -1.5623266576071058, -0.44338549803173205, -0.24756283501608833, -0.18380926251315352, -0.15613963185138802, 1.0298660283273986, 0.88525257800612123, -0.94335952009592194, 0.18180588308675516, 0.58728159686478276, -0.16543921934816158, -1.5555055873996373, -0.32892851166744114, -0.083710565191756153, 0.63174821235605605, 0.9888186443867869, 0.088893958237987153, 0.69620891226216919, 0.71441823911711266, 0.38703931022874977],
                             [0.28959641688343712, 0.18648375607662157, -0.9318598791421846, -0.24864612514150289, -0.14995598581578956, -0.13567494302600558, 0.53011211296967597, 0.78090595481590119, 0.87588982686128602, -0.80211535988899973, -0.47992377428743299, 1.9510974902501703, -0.44398108442861972, 0.75789893376376904, 1.1154048344433369, -0.84301318302636885, 1.1700037970714503, -0.55567731248042818, 0.064491668924149897, 0.085827975371307957, 0.49299799391839588, 1.0194855354880947, -0.34340700159276999, -0.66521663081670446, 0.091743427490585477, 0.50204705440282749, -0.42335921717010233, -0.23254625219282879, 0.91043398758650795, -0.35234653667194643, 0.32855254542803702, 0.32259100913928535, 0.061746269570392982, -0.25232675990688197, 0.14435268212361879, 1.2588808296674687, 1.0994191401044642, 0.57656998602824439, 0.4256975498059028, -0.17673736155957942, 1.379593298105694, 0.35733589398507232, 0.080721659628157347, 1.2068699624273045, 0.89146504477378907, -0.24474592261894076, -0.9425726133874669, 0.17838714258799188, -0.10639456603992638, 0.19849241919812644],
                             [1.0434504640942215, 0.65888217392093706, -0.14527885064033233, 0.78870980774206978, 1.3034618195770356, 0.36407943730862968, -0.3344024574893012, -0.37579329217377577, 0.47459492421239791, 0.11620886575667595, 0.2948722761013513, -0.15025027809877278, 0.61728521480676457, 0.44061328407630973, 0.48289721647002176, 0.11899738055743644, -1.1672484723407544, 0.0022725146042377265, -0.74472077088244115, -0.021634680184662591, 0.65016275560110426, 1.164851327205344, -0.25125197613217071, 0.38558184010190022, -0.75020117511668127, 1.2242280895484714, 1.063987088328195, 0.62829261723110497, -0.49750064510442732, -0.80781704403653909, 0.16899333761593488, 1.5931669461801381, 0.092143842042457874, 0.24383144483436398, -0.34848595305339408, 0.90554974139269717, -0.12905308603835913, 0.38431436837936506, -0.42978917668608985, 1.0502833552086048, 0.31356536839199151, 0.156906008536778, -1.0320648367342873, 0.88317255006856576, 0.27640710795509776, -0.29585598173875366, 1.1107706566388025, 0.22373409288408419, -0.23730708004175105, 0.16612725324248667],
                             [-1.1091883685484047, 0.4884087891913193, 0.91929900590629343, -0.25630005015623231, -1.4239127423506426, 0.32497034955944781, 1.7009213129903056, -0.024867247577691189, 0.75333574068677189, -0.20158635874324801, -0.29928504688280139, 0.93433048368298277, 0.11385297361766297, -0.077492086172459479, -1.0524223047413999, -0.22245003431726657, 0.27279758214734584, -0.63927037595045066, 0.024793242016772462, 0.072327186927528569, 0.15879694627519064, -0.7407924171701824, -0.11054269447298254, -0.53208834343353406, -1.0837492685377181, -0.52147003256907498, -0.55736795297817809, 0.50928043743874929, -0.25901250400223436, -0.73402020680948654, 0.91234810744573436, 0.37550791122674143, 0.48618725695263865, -0.18322870830946938, -0.47175871507281869, -0.45969128070136966, -0.13419489091644846, 1.1782054281936436, -0.21082203549564149, 0.16431465659541269, 0.90798746707590261, -0.089162491056038198, -0.47141301253977591, 0.19105856614486261, -0.034301710296678466, 0.35371478017430685, -0.8861742412564273, 0.033442102285666006, 0.61015099511188375, -0.51081462722964355],
                             [1.1623093300791707, -0.16928660524318637, 0.52971101923305108, -0.68631372379848021, -0.44383391077496737, -0.13320261242785741, -0.49369353758878531, 0.6977677472596624, 0.18160585325535014, 0.99597636212590024, -0.63442873935520572, -1.037383953932933, 0.45883196929013159, 0.087207737017345674, -0.044393932664162861, -0.10377030939741289, -1.6115563677046725, -1.0240435431303663, -0.5498021452994255, 0.88879901253959048, -0.81654715913961318, -0.84527088754759905, -0.87095047542088344, -0.63875218283334456, 0.71774645379340973, -0.32899794340820659, 0.33576864152404645, -0.33988596065172438, 0.37250744410554254, 0.28254461927654911, 1.3790763785707332, 0.92483429132144335, 0.59137572824057361, 0.0379418567138015, -0.99015686935769054, -1.4829527297923693, -0.015404657532605549, 0.08418662686161997, -0.57855521089451678, 0.73482672845842212, 0.63556091174642282, -0.30197382583703597, 0.007049235970944809, -0.74080775257070208, -0.22110390042628589, -0.3395553363774389, -0.39813738869045923, 0.97447740784934522, -0.27357296970026784, 0.59700677532717683],
                             [-0.0580179717012844, -0.47658331354271427, -0.55181139364879672, -0.027007169989930038, 0.2122506393831021, -0.48789378341725043, -0.077794825519571176, 0.86256472288212682, 0.17508717123304571, 1.3497899573823005, 1.573522229161523, 0.30447418434321472, -0.11926905998273986, -0.55733268145605608, 0.62978832998924783, -1.4071116148896212, -0.019130235629526742, -0.046177727083636023, -0.20271559330625752, 1.0486806335977878, 0.81967445439222597, 0.61814729791798506, 0.71874334351961566, -0.17565438921968726, 0.29831462070907999, -1.5422060610074566, -0.20978981937858573, 1.5841289463106387, 0.99526743066450296, 0.13055403327650775, -0.032850902722177083, 0.92458359429597925, -0.22328245592808146, -0.54326461012885319, 0.59991922785632612, 0.77903350193129872, 0.6118699613876174, -0.51271530753918482, -0.12628011324605981, 0.30384671482746162, -0.2893876228053619, 0.39662231588239, 0.37459364459767835, -0.28291553738986303, 0.43129276944213935, 0.0052612351775775234, 0.11478830712222898, -0.20662111103567407, 0.095645535084584996, -0.071962521371295829],
                             [-1.2792703163658383, -0.75901412095187581, -0.58533033301905746, -0.15025507149181205, 0.35174395531108765, -0.13413564721897536, -0.72074138269346477, -0.26547683910962888, -0.93467944701977457, 0.5888714678620518, -0.059762501982331823, -0.51221882895591397, -0.2501834610088543, 0.83875223080598527, -0.064016748854460251, 0.72783775124819594, -0.8052463082002641, 0.040996130189577748, -1.2081522862911522, 0.28224081116969368, 0.67551335437209348, 0.052068640696839273, -1.2227624630844045, 0.38298661411964757, 0.41997179162801934, 0.43400463107863418, 0.56325997025142305, 1.2266357832060057, -0.17916785878782565, -0.15104896027267231, -0.034563012441770222, 1.1913866817327612, 0.62485700369660624, 0.48645107494819495, -0.31380462770062867, -0.7517963199243678, -0.14987052049688016, 0.46163857297729965, -0.41912715142126966, -1.3221531421979935, -0.39437931260279263, 0.53699291572723662, -0.22720357267330249, 0.83866801184471718, 0.071743599723354534, 1.0391623770870038, 0.84542944030942113, 1.1772863084664278, -0.63535780457096269, -0.2146931099539981],
                             [1.0232765171483507, 0.56678066576301434, 1.0977167477717629, 0.43883424669266058, -0.28191949247660664, -1.0384387366526364, -1.0687390204781548, 0.45992356607294288, -0.092679016544389065, 0.043974966778438346, -0.2657455377077495, 0.021232165966768184, 0.38157010915134598, -0.66472852523877068, -0.00047267663540186133, -0.98281112953512095, -0.65939187606927796, 0.27783271141638194, 0.23495939680406741, 0.23694601837125936, -0.28251412574195506, -0.13904228220475282, 0.3581136875511699, 0.12367499949086992, -0.06345000768074778, -0.22915058637275984, 0.26733831514090511, 0.45611942193546434, -0.51584182023553693, -1.04719994224895, 0.23892531502080802, -0.20170664287279122, -0.45277389604882423, 0.84354289031249996, 0.51944801655328543, -0.8645413076305033, -0.50437797041606369, 0.38906112360012024, -0.12694195136194222, -0.65111676123680784, -0.36256988639154525, -0.86559230306268098, 0.080456690219225857, 1.5371655826484412, -0.95653998758808401, -0.46225810330946071, -0.47578450984896031, -0.42926032711483308, -0.05223770953941128, -0.60721613176448841],
                             [0.63550635291192736, -0.57290729383785644, 0.59422245142056951, -0.88914284624814299, 0.91454982770768345, 0.99739561991301207, 1.1892130002700385, -0.052522856623511083, 0.028206991683447837, -1.4408430256759039, 0.11110990266624662, 0.04799084729312178, 0.21483832183514531, 2.0096576609001455, -0.08798065792685017, -0.34331813014971962, -0.15294812743462924, -0.88555912436869944, 0.55999934264340012, -0.50339981108660747, 1.0683036261633514, 0.88600022855999605, -0.5905669064786061, -0.62265795070101315, -1.0590346760986791, 0.18200508727096515, -0.0255077050918774, 0.21254240218191756, 0.51521599968217291, 0.45284615328153366, 1.2948799020271673, 0.90611259553131407, 0.36085713330588137, -1.6107580990819104, -0.39754631895923265, 0.51829995300184217, 0.34966251013888461, -0.36954722813513324, -0.035217229145348833, 0.72417424652144824, 0.60797496137429952, -0.57609681026888027, -0.49704629111198312, -0.39638730041325054, 0.0088750580023631599, 0.362726784077192, 0.28783260704294977, 0.14313731811088629, -0.68642703948799932, -0.17044620143897499]],
                            [[-2.0946455509549873, -0.6077906228159754, -1.5772117016854994, 0.93286324769328255, -0.71358964721594031, 0.80702509885282625, 1.3173575175960703, -0.29410541903617993, -0.60022006360238644, -0.95936719618008615, 0.56588956170515581, -1.3646332456784918, 2.6732830585183511, -1.0003836980588074, 1.6476770213490004, 2.1572361077768876, -1.6591371264844028, 0.68406108401416499, -3.8671571134927394, 1.6020248194707423, 0.22682023137571569, 1.3286413988213024, 1.2091400910621948, 1.272903633783343, -0.94722396492407612, -0.93487101797852712, 0.23095315949405062, -0.72910342375677306, -2.1845473990681725, -1.3000084943180261, 2.9473134407478363, -0.59507009703802205, 0.52531138363431173, 1.2258657067143488, -0.32879631561750089, 0.1469895576164631, 0.25264259487944335, -0.33052208635692515, -0.75862539627133541, -1.9529584448970558, -0.95670028812786401, -0.3490367648079028, 2.0320726550565742, 0.56797520682279601, -0.90901690717996853, 0.8640588494415794, -0.01381901640826369, 2.1539251591583812, -2.103558670271874, 0.82660275144423756],
                             [1.8079818305679143, -0.66278915394752191, 0.19623546839722233, -0.67203923669348553, 1.439619096353675, -1.6806957733981123, -0.87224682592151237, 1.4849705816356509, -0.10612774112236556, 0.14658533625207865, 0.091776446534168055, -0.41161994963776172, -1.4170952445127107, -0.38454514682095342, -1.0749010138043789, 0.47069671738434238, 0.46890184955091802, -0.41770834042002553, 0.53572188906819784, -2.2044728623852561, 1.404623598604481, -0.77549597169125828, -1.3019791354254799, -0.59678350577183881, -0.21512410382573721, 1.3345740502280676, -1.0629488480888047, 1.5427081977241024, 0.54322910453341477, 1.6387272853418009, 1.4573834879057423, -1.045234819574707, -1.2377700645412599, 0.063976817267002217, -1.7181497350179558, -0.98972211969710344, 0.12280079964778703, 0.10629989425983936, 2.2461390891946116, 1.2591726288077536, -0.75955012401762623, 1.0370930592324277, 1.1699930666744105, 0.7749444476382702, -1.9986077205355639, 0.23798085087289622, 1.3233921993325424, -0.24456692314921327, 2.5241936068379665, -0.61072120276486463],
                             [-0.74620405910490772, -0.26402677001553088, 0.022514056875705318, 1.8604484651174671, -0.72732089970528668, 0.62842610959678491, -0.029249801358177147, -1.4839543439682421, 1.1806313440456564, -0.25761341113959263, -0.58623919019641135, 0.068277540839733211, -0.51470345345954893, -0.067146533970378147, -0.37504177928412386, 0.50385341183961507, -1.2363465479483269, 0.35178278221533488, -1.2216168634400038, 0.66022765598222699, -0.39076860769021238, -0.23736542078339681, -0.22201601753765646, 1.3150153620897858, -0.20435433738784053, 1.464321576957988, 0.14941267210159065, -0.72474701929970098, -0.56934139580041876, 0.19256169382388422, -0.2313853207028666, -1.612489731759579, 1.338703138018668, 1.2967113881273913, -0.14941624113030277, -0.88872421977669203, 0.70271749263537309, 0.13182488724018654, -0.088736718261565845, -0.36763825306398207, 0.019677115291243941, -0.36648861114856296, -0.18416577116366489, -2.0419868583795999, 0.75275270130262473, -1.4236610312151723, 1.4300621940696987, -0.66231107646967091, -3.4817910706869228, 1.1574051180251368],
                             [-0.16949138505770547, -0.56163759693954796, 0.61540219301946386, 0.074809794750703262, -0.052283726785788173, -1.2116427800788581, -0.11237531821775013, -0.51028051144695685, -1.3549830739989326, 0.99262171161276935, -1.4513928239475478, -1.4961556394456454, -0.15491766055784517, 1.5297991904289718, 1.106063495222094, -1.1578247101658308, 2.1351477393065519, -0.71634101915820259, -1.2048364731454653, -1.6412273830307131, -0.99508093764146877, 1.6084205450032736, -0.14987701165270717, 0.4649572087400447, 0.60560884473028409, 0.91462045688603877, -0.43466817456795714, 1.5596230352285478, -0.47461739279418513, 0.74833458808473041, 0.134369020032823, -1.9128209775053304, 0.58189621491165577, 0.722351015293899, -0.59609824174726767, 1.8779471730984656, -0.70985636464214197, -0.99762422740585877, 1.9187808799609591, -0.91228242371232604, -1.5067211054935048, 0.10353713725205316, 0.56586979284169503, 1.1123363805539941, 2.2986024753091732, -0.56608540286332121, 0.90816156581621432, 0.43185531216314643, -0.47888485817266702, -0.68398202293126897],
                             [-0.25154497027770584, -0.069016405719932034, -0.6229554474507929, 1.8770707544221841, -0.68365792794188285, -2.771298773188474, 0.44677687419092216, 1.279710520913778, -1.5741856268586409, -2.4916791428642351, 0.2275332866698288, -0.99859663358519757, 0.22387438813309757, 0.041993078040439169, 0.25938862411247227, 1.2896884511468119, -0.9939627273612035, -0.67836362824382657, 1.0195066071837413, -0.27089363092578739, -0.26993853334428985, 1.3686607515050841, -0.05495692749214931, -0.15460872841136306, 0.75337069416959568, -0.80952680519251641, -0.53106136503363, 0.58191850505183185, -0.26695247408587269, -1.5992094134145529, -0.68942793945779757, -1.0265811555528879, -0.25620358926637143, -0.56775773150382502, -0.88239088661705911, 0.72372965059071859, 0.50348360549125692, 0.39814073071500472, -0.57045081878532045, 1.2360000233987363, -1.7106952632052992, -0.90901078079580699, 1.1462638214342817, 1.6488110233250437, 1.2284876974544354, 0.25133696727171179, -0.88198706252993553, 1.3758640854736581, -0.84458483738608647, -1.6352848009428855],
                             [0.095156832804304314, -1.3503068629707424, -0.861204134245244, 0.58020076053041691, 0.56094960467322463, -1.0971204269664927, -0.95393817910619261, 0.71720747149484865, 0.2519188416616609, 1.2371606675040607, -0.012067251038290899, 0.8610052821451929, -0.90559057863306391, 0.13665041629173719, -0.2376507127105997, -2.9901753825203405, 1.1965565182221107, 0.39087460199080343, -0.96137330674744081, -0.15226006904700243, 2.9573541558640644, 0.23320820363272665, -0.28795355952058366, -0.23967391983399641, 1.2278347289761025, 0.74185495215336328, -0.76046197576907726, -0.18848844465739237, 0.57128526674068558, 1.3473092737490104, 1.4294652282996536, -1.2404261585892362, 0.95739686495537757, 1.2839413011574794, 1.3752009247751473, -0.67937317202175795, -0.38314781439813578, 1.317714959022293, 3.2730910816765357, -0.36085041976620169, -1.6347544978188118, 0.43312448526448322, 1.1586610524894327, 0.51332205209773374, 0.1185146392587671, 2.1600226630691894, -0.93600932167131634, -0.47238418388185233, 0.47385924808444613, 0.47128570267368591],
                             [-1.0241109222043896, 0.9615780158456102, -1.2357904826368411, -1.5389374393458282, 0.91262641549425616, 0.3297761767853179, -0.44016889519262442, -1.07181806073264, 1.5498164822076448, 1.9017819194495429, 0.80712928834024866, 2.5462994416339875, -0.75078285525954769, -0.43983454395098676, 0.47417984320269135, -0.9860208627392818, -1.112073652395501, -0.056286830298487953, 0.014773916665816518, -2.3427364333578162, -0.4972942694303869, -1.5825072314340853, 0.87068438987893049, 0.94937830531689238, -0.89850932973158926, -1.9415134835495256, -0.43738651749401303, 0.12068991486650524, -0.34168447803078611, 0.64950634034304877, 0.24644955675948407, -0.061957443488082742, 1.1760508044109894, 2.2047769431231097, -0.91963867418343082, -0.58779442558251283, -0.95427112264734282, -0.49973832849178612, 0.26266297029210339, 0.1181918273586767, -0.83197220429149521, -0.14387889300393544, -0.17019001481310397, -0.18642729362878893, 2.04155661343838, 0.5413145367413007, 0.37492752691601922, 0.88854528243562336, -0.31383783310048824, -0.55483171342662874],
                             [-0.61536628715176656, 1.6827308966964745, 0.26189634240335757, -0.39106050209205145, -0.15362384681199737, 1.5108051161713947, -0.89199381966367686, 1.3156496264569844, -0.037568171537073605, 0.6430248127074486, -0.20378878038930037, 1.8588251539777307, 0.78289988641605512, -1.4166837246073378, -1.1114776479337816, -0.88891144996958649, -0.11002241263859708, -1.4501408278094827, -0.35496732282535032, -2.9422672512762125, -1.1196631298405311, 0.25403215405213775, 1.3642872555884062, 0.81015414864699775, -1.1106149565311116, -1.3566287175388108, 0.24828091347686568, -3.0158540252988364, -1.2945906904854607, 0.56611920078952438, 0.40567032698345634, 0.35856321856561379, 0.21506376557049364, 2.6876778888919262, 1.4550557107659836, 1.3083455234972126, 0.94929400925610308, -2.3052238447075646, 0.98458021380940708, -0.83475452947564588, 0.53704640734317377, 1.3641801579013559, -1.2724893844877654, -0.76844622223053249, -0.047036263140652124, -1.575939649305967, -1.9240306934620666, 1.2436887323373089, 0.043498338279448101, 2.2278421933315986],
                             [-0.0026263797948953282, 0.87322275835277741, -0.39849061998483037, -0.63666093474231822, 1.9477805052952544, -1.9823702738489777, -0.37997183143252611, 1.2495028743522023, 0.27994226742153316, -2.3959216016392757, 0.61570336358126787, -0.11674771965355041, 0.8654851654339204, 0.12293867541607528, -0.51854360820802947, -2.0215335667661547, 1.1183784193745525, -1.598818149751573, 0.47682179350238985, -1.6365136771477911, 1.2275018544514817, -0.097887284913723782, 0.89581874745285339, 0.024077335059541599, 0.0034270272790341005, -1.7463033963027208, 1.2686684005135431, 1.8722166512697482, 1.3190254935669765, -1.3771538546909166, 2.6790704329283415, 1.1357528861359463, 0.57391588795623261, -0.55120598577478408, 0.51795958490191052, 1.1172949103284153, 0.064498201208905537, -0.8189831532856392, 0.67533983871078074, 0.98076456676710122, -1.0066024370762343, 0.061155033000411113, 1.5320374810098074, 1.7499670066844009, 0.55307069812408394, 2.1840015312841019, -0.96844970598225988, 1.2231638904586601, 1.7990927225958329, -1.7768808266647895],
                             [-1.8204942874660783, 1.4868216184932626, -1.8000211536725621, 1.000288285077831, -1.0883625415323079, 0.15394500883011922, 1.0228438299055547, -0.059302915390833537, 1.1563641771018969, 2.2759323375638996, -1.4471176008169828, 0.16280412784142229, -0.076130230921341718, -0.13378127579991891, 0.45532032920979709, -0.74246368360434278, 0.36017709501660455, 1.4422978894990821, -0.82330562136285035, 1.0679882075432849, 1.3436144151182303, -0.95032336564711994, -0.6911038246131983, 0.25894926821890962, -0.44423036757871492, 0.28676662826775268, 0.44266639755438947, -1.5539683406240024, -1.9135069210284261, -1.24067734853494, -0.23580663437710356, 1.3359627312019347, -0.42757827153869987, -0.36319269780662322, 0.67427459705750359, -2.0094827733035774, 1.9980483634547508, 2.0262473334040454, -1.3560611084945358, 0.320826572100746, 0.10571223251570312, -0.43667492551630893, -0.60991455727066379, 1.7864295493600912, 2.1190973745839607, -0.43857145278760723, -1.3142303488817013, 1.0996603278204995, 0.0026617858977898657, 0.20475043313797586],
                             [1.188561897728615, -0.37377953868939562, 1.1224410236693294, -0.72041681379976252, 1.0178735690478637, 0.23303099028851956, 0.10826529611727277, 2.0354418318658132, -0.30530667156111518, -2.0390762524030981, 0.62167188209194191, 0.33405847457428495, 0.89425188052739968, -0.45121652553802116, 1.4519661775669976, 2.0016985417371504, 0.083164436654149965, -0.29866952587605217, -0.072951403820096919, -0.27096579636808615, 0.1850213620167398, 0.3200002379524623, -0.86037557456560776, 0.33761010024139954, 0.35746270585982043, -1.5955815522224457, 1.0006566175276652, 0.65926895379667316, -0.30969510092718061, -1.4819154653442235, 1.3829395993771161, 0.22237451953577175, 0.46914919089114399, 0.61052888782308601, -1.2196779130216997, -0.46005981553308573, 0.66488041972414191, -2.2040582687694803, -0.62560550890894817, -0.1591783228659201, -0.043937181254821392, -0.47814898813883355, -0.78515653408727659, 1.7487377610588173, -2.8336920628282543, 0.66980402183942123, -1.0704537555338858, 1.3918709362883519, -0.60190311199738589, -0.24781273128373324],
                             [-0.96510050137365933, -2.0100109653431932, 0.26440380680950515, 0.69716072157249609, -1.1424424605827133, 0.27545993671608648, 1.3139038737552919, -1.2689388337280778, 0.0018070297985022937, 0.30840075589896343, 0.51699563962585582, 0.80888437653937895, -1.1524046999622621, -1.8941462463055265, 0.60993979254056541, 1.9737750385596027, -1.175816373743062, -1.3561512021423099, 0.96765645482069629, -0.54477079876971102, -0.57830441830086721, 0.63577332270018982, 1.2094767495694925, 0.53128302885709111, -1.3835408234609397, 1.6126488670455641, 2.8050689238100186, -2.3272269236657568, -0.91157370405518146, -1.0689279088015651, 2.9650975373716575, -0.56124950254553763, -1.2456063133512492, -2.0253407775450354, 0.45192500564880295, 2.0428346347321291, -0.59780171979809116, -1.1251576360461686, -1.673965239373999, 1.0511307149813702, 1.5369465683806525, -0.28798386433340911, 0.36550883507673648, -0.22286865642178871, -0.73903540711000282, -3.433306750707485, 0.82213537111024826, -1.5034213118909503, 0.89165943269602466, -0.73602571638513081],
                             [-0.12793818939697255, 3.0737203658023358, 1.232579674097938, -1.0231546326091367, 0.86183216937647722, 1.6432851837628841, -0.75173688645275072, -1.7442669034918907, -0.23387440575129947, -0.13236863515470743, 0.73798513630646534, 1.8900846864855614, 0.37890866746873186, -1.1481803278565683, -0.13510442282854238, -1.0107166024682266, 0.6265747315819703, -0.53336808204725272, -1.18372844936613, 0.056280360555611142, -2.0633304309985161, -1.3020810887611929, 0.651169176232683, 0.28061685002280989, 0.023284296760197165, -0.63453955447563959, 1.2094537327101407, -1.690084447620505, -1.2714467166081174, 0.19291837863974107, 1.2295957190175748, -0.036815800881954283, 0.13182332393489701, 1.6544510127425813, -1.6751036714233192, -1.8197927660002271, -0.26763881082678864, -3.6304206338723342, -1.519562821582124, 1.9681751439717654, -1.0100948741040088, 0.95224806206668478, 0.14781806587325302, -0.14985249393927921, 0.13127793547000055, -1.2575144381991048, -0.057022861754036397, -0.84950231770093321, 1.1889423388476312, 1.3733711134567272],
                             [1.6067262260674986, -0.64119859012688207, 0.58172125466610169, 0.72094123597056936, 0.70597108965333855, 3.3162187382447446, -0.22822123460193172, -1.5949631253848537, 0.99635362084034806, 0.33803542227188715, 0.17944164320207584, 2.0066778663030487, -1.0716969328839043, -1.2625026854472063, -0.0036170736032428152, -0.08194956846213873, 0.010260244843296629, -1.7333852673426058, -2.1107130659004794, -1.2915652624856693, 1.5924357037719694, 0.17548593559178993, 2.4833417086592213, 2.376235180102686, 0.17539785523807994, 1.4464632502890296, -0.46999052773560002, -1.1831966766467297, -0.98058897580574511, 0.44832105693110852, -0.01477666091580343, -1.9192551129278763, -0.929909864463209, -1.3998520939699273, 0.52745997438702918, 1.0478871504081946, 0.81758039629585422, 0.11433135232526512, 1.2754983418471035, 2.5469282328128973, 2.0901756365540578, 1.1770980928361703, 0.75269361657450129, -0.97213818547824271, -2.965999043826792, -0.90316562238625386, 1.0552936424493486, 0.2717748399235127, 0.87867653639757703, -1.4122316269311481],
                             [-0.52385485289558165, -0.40242786497767241, -0.73740964987760604, -1.7307992359053939, 0.25258578566466006, 1.1261053213492858, 0.4100833162677846, 0.13572670431240588, -1.0233947195442439, -0.80303706196269986, -0.47428766964587998, -1.0854996312120746, 1.0048448800773844, 0.30456188782925109, 0.66030550814180033, 0.57180236214506464, -0.42291110385288427, -0.57545998562568967, -0.4015210559060633, -0.36461155953195612, -0.79343470319378551, 1.4122434696348904, 1.1735391357385168, 1.2200583416226831, 0.27886064678105005, 0.69737381186328085, -1.0582167514869865, 1.062123071584919, -1.6007315935619801, -0.96146559480760108, -1.4156532559434278, 1.0160603248323112, 0.021627647539461087, -1.1400143085313377, 1.7906740564410992, 0.35770212218746278, 2.1368775801248474, 1.5709664206074263, -1.0968476448446272, 1.6667045270420937, -0.40124574263273849, 1.4138027010120973, -0.23924494197224336, -1.6931206866361062, 0.0093481376434884078, -2.5261735027115497, 0.0062875104854805963, 1.6187193776055668, -1.1151512083981701, 1.1754158137028481],
                             [-0.33076227275411418, 0.79922411652182856, 1.6374297593059852, -0.24750626028171321, -2.118557476167048, 0.012321016862859718, 0.54817673359660501, -1.1397820645021874, 1.0395997633141272, -1.4549655122113041, 0.20017437441933328, 0.73549020592072079, 1.0368001616641682, -1.2020638292480597, 0.66475769132560547, -0.50512034836995634, -1.3114004171813443, -0.99462869649868457, 0.89744029018769544, 0.18871361295606709, 0.86619990236711319, -0.82307654090340776, 0.98248836490772984, -0.26404789130724809, 1.3586808105159589, -0.60292526637821997, -0.026774857294190997, -0.35097805698122619, -0.44140660913610202, -0.84108208147476526, 1.5613419926690093, 1.4331513668687661, 0.54700700724877593, -1.5622876678989339, -0.1207691638477344, -0.27387350745168026, 2.3635578323803097, -0.36483837279062198, -1.1073837581723101, -0.6816784503478297, 1.145525050021736, 0.38835180728611546, -1.2258340412979241, 0.30643116789430885, -0.094694726904700488, 0.68824699507752873, 0.41568113159682102, -0.4909051129672044, 1.2765314201571916, 1.0033865443036563],
                             [0.68396992275164403, 0.37382677151406812, 0.079477514170699037, 0.93204957115755604, -0.45202303776341801, -3.0531226694361817, -1.3085904479428949, 0.58379821879811689, -0.98793385206424944, 0.23460105579243939, -2.070714747701127, -0.642470680001205, 1.6666059338996859, -0.89369466104205508, 0.05512792976991579, -0.64327596506783435, 1.8065271288846694, 1.0566291475712406, 2.0589142164998346, 0.068238610697617053, -2.7121906001213145, -0.57719618056621347, -1.202625408766117, -2.3242192752974757, 0.094885090163116526, 0.38510734076284936, 0.085306687548218296, 0.90867359550861648, -0.55567057071481085, -0.66299836025447456, 1.5956542908683318, -0.11953112847430278, -0.090548264297727096, 0.020109482082674573, -1.8777029331528616, 0.71436910925376118, -3.2652341494031041, 0.95406575515571679, -0.60023263959233186, -0.076480542454414491, -0.90501157807809474, 2.2822192154023866, 1.5035065243655317, 1.2959980017023061, -0.0019017901822657168, 0.88062977380736318, 1.60712385506745, -1.0897508729281342, -0.91439512435364168, -1.3068723768186454],
                             [-1.1866836513762029, -2.4566941055769247, 0.40040075518157425, -1.3543535053125821, 1.5904390094803451, -1.2845979466434829, -0.91151383907558092, -0.99385438813278726, -1.4140144281821216, 0.26894217255757907, 0.17705607057709713, 0.72959726396302027, 1.5843500546272766, 0.51798991989662269, -1.1155669090346512, -1.1996026746275839, -1.3662316517844606, 3.7255559848791502, 0.088588389352123528, 1.4659576336917448, -0.83271818362659467, -0.78378536848113833, -0.39757570871976067, 0.51787569528263244, -1.1398041139004589, 1.2913653577218336, 2.0673792214728093, 0.8418294492192957, 0.75468729794166978, -0.33723598831136042, 1.3000484563552459, -1.9245520893679395, -0.23954125944492444, -2.3392120001851877, 0.47348993375038595, -3.3992786372472104, 0.5291627843906429, 3.4897088698876386, 0.40262873538336097, -0.88606272909964168, 0.71380971462318643, -1.0344727740194102, -0.2506741479017538, 1.9050247646292275, -0.20257404655950839, -0.15716098634954895, -0.31539186399012975, 0.39528678536459955, 0.32238090562837568, -0.80499486054004354],
                             [-1.7384401721129232, 0.79808241482196063, -0.93131976739452882, -0.54234444638627477, 1.6012422081125848, 0.82477505123569628, -0.31414823385386231, 0.083494568018758847, 0.81476861731815697, 0.77795555653901249, 0.67189219998890781, 1.7192807647331936, -0.30396892363315037, -1.7426355078596729, -0.74352093231475924, 0.75387639081234536, -0.28094697387253748, 2.1794385497932671, 2.5461790126425745, -0.58070890254641383, -1.1874799835977532, 1.2352396204622036, 1.368064783669277, 0.13491186717648751, 0.91270692680742505, 1.0544765192908319, -0.84846930406299581, 0.015607328231424022, 0.14037495558790009, 1.3417944745928339, -0.93040126259855382, 1.6306693122726963, -0.13378700120171261, -0.28345135236741392, -1.9928840491924626, -0.1590196085391653, -1.5118850606630345, 0.27048921923626768, 1.0015265029599725, 1.2111270493101824, 0.23494460048177404, 1.822424911452216, -0.06516485099942898, 0.69649989094951703, 0.62403657741674712, 0.37105416695274557, 0.16969429191043636, -0.10374810505911664, 1.3333396907626425, 0.17202626203308075],
                             [1.5221307040781207, -0.20214460914322041, 0.11669240831341135, -0.12716751758357336, -0.68563396132592602, 1.3462858437717324, -1.3855525063302752, 0.17363249205897524, 0.42248918605767982, -2.1498694499410722, 0.62375551693444076, -1.560901614552318, -0.036286783761843189, 1.1052264603725068, -0.32164005202952151, -0.21551827191992928, -0.36926661069384897, -0.64642051226729635, -0.3592231057391489, 1.5863997322619865, 0.17601892660557267, 0.50293504900741204, 0.57212386978587115, -0.088408555578758818, -0.73108787423788879, -0.78811329946627984, -1.3277804010049035, 1.6669533461071184, 0.96130889789385654, -0.99378752381724567, -1.389182475400583, 0.87047249083755784, 1.0354046479762822, 0.13522130625204823, 0.59502755141894514, 0.2346372418314375, -0.40522605831188041, -0.2562037378673328, -0.46710298373297504, -0.77118025442384186, 1.7495196722899879, -0.23212795125001695, -0.73416376222686908, -0.12294636062712996, -0.39786109916330759, -0.070490522368389041, -0.0065769159014225538, -1.6547350296521637, -1.7988139800335412, -0.13300902582344598],
                             [-1.5470731000785136, -2.9615725291699286, 0.39640071652640657, -0.030121121090024461, 0.75164171197282104, 1.3737991065895956, 0.53850344334461464, -0.94160952654682928, -1.2964660754718424, -0.097917165264001002, 0.45090218127072934, -0.14986306798611188, 0.94951049094941697, -0.67867629165188215, -0.086849260854556201, 0.1909705630177089, -0.37237764551659291, 0.22467591089883376, -0.41396642914496745, 0.73473738052789017, 0.55727023968824807, 1.4280415842548371, 0.39661280553224748, 1.1516361057233226, -1.0092765951983755, -0.75285024989245941, 1.2391914699206805, 0.40889598267693794, 1.1383162900821036, 0.096386277607622181, 1.9630614519432763, -0.50010528094232365, -0.004271781889892301, 0.2619824105277741, 1.8589125724471325, -1.1297257572710393, 1.377800136645724, -0.45971159743200207, 0.33228304529015573, -2.0026085642142353, 1.3430931652883737, 0.6863754054359581, -1.4408014829014457, 0.09836243032649529, -0.35296083476751339, -1.5938016795345298, 1.2883380767799488, -1.2358857091403619, 0.47430149289436024, 1.0528469303797361],
                             [0.51413293430749052, 0.4801822901231102, 0.12712577377803838, 1.6938363752063588, 0.021113164294134526, -0.75184842531877438, 1.0083659026482534, 1.1373658986939172, -1.8977694401011518, 0.91853063114090205, 0.71500119118577776, -2.2305826761483498, 1.4396044315146932, 0.33021354417345922, -0.012911322707973655, -0.19786604482292169, 0.47289812481818755, 1.6531535517792253, -1.5815056769447864, 0.3845520484389085, 0.52905802404312152, 0.26905917108454303, -0.4599684870177585, -1.2552542821891939, -0.19016865388470117, -0.15400341061205497, 0.49102936082903997, -0.048269423692876803, 1.761353557531909, -0.97217293197514154, -0.54826606146340073, 0.57001385556257456, -0.15471023343749071, -0.57880685131508225, -1.6432628996323995, -0.46950775505994363, -0.53615088429010216, -0.69496010308874234, -0.58802134392705341, -2.2990665216219366, 0.48285837258883835, -1.8822720770468875, 0.32450356075971548, 0.74545466792674853, 1.5833654315437253, 1.9904382320673748, -1.4693451399266246, -0.55811862315199323, -0.46253578390734473, -1.718367358831264],
                             [1.6185261470798749, 2.1000291358119965, 2.1853838613303975, 4.788796466491533, 1.6293041657079284, -1.5667137288749933, -1.0452055977064854, 1.7099747323749659, -0.55274034340271749, -1.4513595922142308, -0.94967727733735285, 0.5496827928613921, -1.2707175733874279, -0.90983766593756876, -1.173877922521783, 0.71569165705556115, -2.7029916838190107, -1.295260875038583, 0.096230490688484452, -0.56744183897871447, -0.34206992322117979, -1.772794007623784, 0.04241932203708515, -0.023255730155814391, 0.96443040850944151, 0.85818888863209486, 0.36427768755398204, 1.1598191065872332, -0.6724323617521073, -1.7999008907476284, -1.0203767472588101, -2.142523040026437, 1.6659951717869081, 0.84758391348363638, -1.6301062882908985, 2.1185560537930663, -0.43373761015529311, -0.10936368145245917, 2.1816349640387269, 0.50030546440933232, -2.1230201953738788, 0.59548748502348459, -0.40832384201684269, -0.84877196484371353, 1.1234707549440008, 0.60195576721597366, -1.5507468354928868, 2.4694347104072985, 0.21622587246312719, 0.35601596454523943],
                             [0.30704574918671745, -1.272556218962118, -3.5901753386997637, 0.32293695373892245, 1.742996491426654, -0.41535040332034889, -0.3390344792035051, -0.19943548109475495, -0.76651160873783419, 1.3272993583936081, -1.5709494225990388, -0.56317304138719904, 0.65494137001068886, 0.76711429082516869, 0.54247096912041259, -0.3805872585804736, 1.5113020068833694, 2.0239543858835289, -2.7010095644253824, 0.26737568294382613, 0.27958668004353793, 0.76667818372597618, -0.12954001473553678, 0.24590700201513896, 0.47731479791280618, 0.17723264386466592, 0.050732785629189737, 0.25042266347129588, -1.6855296544309759, -1.1091628782057055, -0.65206326661747349, -0.12327276894334181, 1.3991561300965989, -0.099475506244798048, 0.53355632919718365, -0.9918341847096136, -1.0831443712032542, 1.9675842224500699, -1.2108300638178804, 2.7975856647470669, -0.89942375920899875, -1.4178952250601724, 1.4189145720836769, -0.56303849095249736, 0.41404960873037122, 0.93564787123989979, -0.24592931289907805, 1.0453471971201382, 0.60810246152012171, -0.87267420810179874],
                             [0.36017693260416245, -1.3652450569986967, 1.8013835268861507, 0.80697954130476768, 0.11270359809814168, -1.6126389061427124, 0.53517602454564983, 1.2194795925430804, 0.014894800985213952, -0.23843868293765258, -1.1625574792392654, -0.81823840852231788, 0.58202278948356634, -0.66106144565758707, 1.1001133584524765, 1.665487414019325, 0.92757353680007393, 0.36753298749918806, 1.020004399978534, 2.2787140635977821, 0.27046584787079103, 0.040397616680806075, 0.33245505519464436, -0.11111464389775048, 1.1390830268728762, 0.76875916172728198, 0.73575728630432402, 0.14295673585919255, -0.86161248642768884, -0.2034178940805762, 0.35462094857786397, -1.3572663828550338, 1.1091998793797611, -0.96387314498531174, -0.7010156775560189, -1.2818318136805822, -0.60714859599578797, -1.6406275485147666, -0.25361461339546104, -1.6115626203231155, -1.1757238609635743, 1.2884015629161372, -0.87736952392123257, 0.038460726818652959, 0.47086528027764113, -0.83698102645344918, 0.16169668015979793, -0.4238869128610645, -0.32420659103208932, -0.14684182362405568],
                             [0.32336370050507868, -0.60450818740137413, 0.52338671693797756, 0.82961478590143023, 0.19278176942073116, -2.3246271968150944, -1.3052106576575224, 0.15140955434145431, 0.11011233989191083, -0.2038606292096648, 0.2035173859327111, -1.0878468432055211, -1.6355771340167617, 0.8491739273496659, 0.26585463354376793, 1.1021390919070275, 1.9512542883190152, 0.32861006041080615, 0.14969858578621081, 1.1128758580145059, -0.37283777323458578, -1.2206896069049316, -2.1978847709821911, -1.4658386281885891, 0.96233608815216609, 0.75972372379763387, 0.097102764140138104, 1.8594000504131545, 1.1012047377196372, 0.033168635430892962, -0.55335248847226193, -0.96798723078470217, 1.0788755651147151, 1.0155206104107011, -1.0752016363639665, -0.37521193459394508, -1.5347674221818384, 2.010379895890158, 0.91653199247904993, 0.57107029648927943, -1.0144202489911205, -0.55865374928892542, 1.3207689998490493, -0.016621132355522889, -0.33441803022507055, 0.13355256652413963, 0.05899139966852332, -2.2566891462383927, 1.8602235898268387, -1.2630372481348402],
                             [-1.783265789638196, -0.86083840533407108, 1.7765440149120497, 1.2276551918631615, 0.24669380753812359, -0.23951051306765583, 1.9117677343770294, -0.47122155759365475, -2.129830940706599, -1.2030453815046722, -0.90009701470444492, 1.2080419678575425, -1.6120720602042575, 1.5740584587456898, -0.58951173246284017, -0.83631477526054732, 1.0852650192883393, -1.6900420414291872, -0.2071048603911691, -1.3728706094575098, -0.81206436749387745, 3.1900512834717949, -0.11709337291869742, 0.020518080363294812, 1.299174291265039, 0.044233498964302564, -0.89811455405554197, 1.454660594646878, 0.57412463730411345, 0.74830179954560094, 1.7995354546712889, -2.3020995810203968, -0.77386019584440513, 1.7555928231601445, -0.89719796122865936, 1.589497974654146, 0.042663636575438299, 0.53523040994996185, 1.6554171995150979, 0.63388120686295468, -0.62005436194895491, 2.7366361833360839, 2.7813183562233794, 2.5766201892901295, -0.61167666692440714, -1.2520803905453985, 1.3659092475355936, 1.0645201481312427, 0.1486862021105973, -1.5228478707122282],
                             [0.3652727634851427, -0.29634788581420735, -0.19454608735337189, -0.78506787691011426, -0.84112911896021147, 1.6278064249417483, 0.54494901955544683, -0.66751896357839302, -0.42345252232985114, -0.10404290744666189, 1.2644947432457339, -0.045618118531968857, 0.38534176121108665, 0.62686293198237153, 0.57297121174461541, 0.74784588403755092, -0.38195320874431937, 0.42611883051129301, 0.3732946199210937, 0.85157269995683815, -0.35022427019145813, 0.6962175239189391, 1.3087150028459575, -0.1287179453962124, -0.23877203163555, 1.3944440301492003, -1.981096547649996, -0.031458866304259647, -0.91451201325608567, -0.99870830757886542, 0.11896185103975158, 1.4798179135913214, -2.6096251078248884, -2.2604026309894878, 1.3035034697864629, 1.6262443580286836, -1.2085364291467866, 1.2340312169571905, 1.0591797026325356, -0.88984608729873882, 2.2876374541112856, 1.0947607388462408, 0.80685563797531024, -2.2018439815671447, 1.651351714318706, 0.55139958269886968, -1.5419858627033209, 0.19491673378735253, 1.4026324280794151, 0.89814073927397409],
                             [-0.31229065070494533, -0.87713977985367619, -0.10620943542444466, 1.6133207922716808, 1.259951236871391, 0.16927712715766655, -0.38097167349948224, 2.5603640138143557, 0.31056154532078917, 1.1369946361098409, -0.20013491552575519, -0.43728835142141192, 1.8939582229812606, -0.58400160934822687, 0.21602887428646414, 0.63846709652901867, 0.39137028177896133, -0.42448692670017052, -1.2430828760856367, 0.46613673374788633, 0.38109928370075885, -1.5323654070790631, 0.56861947431568827, 0.27585547134358412, 0.11792454018883435, -0.74046099621916206, 1.4005774264925748, 1.219509996833356, -1.0615949502882993, 0.58813769178517861, 0.85023315881639594, -0.29964176741427229, -0.24352158944838767, -0.3859913985294009, -1.2524019387424534, -0.39530653821303741, 0.39943617802340026, 0.51980010429477663, 0.66100274836039075, -0.20984459437329459, -0.70880460794236355, 1.099256762729613, 1.6771296472615076, 0.24111167280554688, 0.11233670810134362, 0.58530399688111234, -1.1751071724521114, 1.9260207742974762, 0.56057367748281151, -1.0663990275674609],
                             [-0.93767219200089702, -0.16139762478337144, 0.10970212012638245, -1.237642663067902, -0.72583002319166723, -0.32328110749908806, 0.25018546767792249, -0.026336157058096697, 0.4335311415403249, 0.87025470670668881, -0.86982443384836849, 1.9921155844743661, -0.87274125073283615, 1.0532430033649427, 0.010748575869562099, -1.8291918288632254, -1.0472292258177933, -0.63805073679598079, -0.51335621784049346, -2.1670789635068703, 0.52066964926985948, 0.14697023365518347, 1.1763301281957048, -1.6381948398755473, 0.94430467771747395, 0.043478602539701032, 0.44028620836730648, -0.68317616340246579, 0.18466512610808772, 1.7641166683481211, -0.034374990120862425, -1.210977017035477, -1.2791055867256125, 1.1108648479204213, -0.81754267219460408, -0.28153572702163704, 0.39587406637834605, 0.86414640253289976, 1.7803554866511198, 0.48912695694926883, -0.10392223957507637, 1.2679926738161775, 0.42762905244031046, 0.10237574840563236, 2.0340374909673198, 0.35021482005996496, 0.21489824653591572, -1.7787104435392618, 1.111287793355801, -0.2066523889352089],
                             [-0.048758997185400887, 0.34330806044604001, -2.0176033144568501, -0.99525376169446678, 0.027290337318947477, 4.0030617376719722, 0.65824414231855388, -1.8701133701110086, -0.75609442288437556, -0.23405123619768908, 1.3605497464553915, 0.065873475831990852, -1.5645969798765771, -0.55129854995074845, -0.71487181181659643, -1.4490703455645413, -0.70718712492379376, 0.64884968883697525, -0.99422190799353549, 2.3679198046635892, 1.2234065646895917, 1.022333505968879, 2.1815165543425254, 0.57752262066616633, 1.9952238447791006, 0.12994243531527946, 1.9259680003250219, 0.87249203089643856, 1.6505552846696339, 1.482843598404745, -0.59182310252766546, 1.746455187997189, -0.27933325930774033, -0.32856575172980834, 1.33803785700469, -1.5239316951033635, 1.3114954607909992, 0.97401653774427377, -1.1038383654672592, 0.50540308916031396, 2.2057112989781142, 0.012060053466178458, -1.5520593615052749, -0.35707369804747968, -0.1629351618229441, -0.90315755101803008, 0.6443523466610529, -0.25103072201178045, 0.16435982822700052, -0.81779040967600058],
                             [-3.0780651129221779, -1.4596819645275418, -0.33200114631593214, -1.132085303539208, -1.6739233796424933, 0.67526709922299799, 1.999045125381911, 1.1841272727721888, -0.50123179308463994, 2.0260021520648621, -2.4159323212587185, -0.7950730305122865, 3.8899932772703782, -1.6356146076492586, -1.0787370196260972, -1.4675070163818331, 1.7445349688447038, 1.8032809876918432, -2.2895655394578203, -3.9004739607599426, 0.26598480935419588, 1.7226027654002398, 0.26560747259981216, 1.8016516656976023, -0.9988912056556577, 0.83209168856127325, -0.5507526242898888, -2.0089645661162838, -1.8848980608795372, -1.0604376656669916, 0.74750051053284261, -0.25334466076359213, 2.0200011493395711, 0.55715774233544291, 1.1010285328695557, 1.5170237801069395, -0.97054581831883091, -1.040433370648147, 0.62539885708846421, -0.067333098668387908, 2.2829816922526147, 0.1029583351292879, -0.96436561014573896, 0.37898648282598235, -0.44724555734962346, 1.6943552953028045, -0.75678235903586233, -0.37297604152274999, -1.1595482071233254, 0.92779408341140446],
                             [0.5432422645257371, -0.87870309085186526, -2.5012683111566818, 1.0692980526777471, -1.8402171644186784, -0.79580791188929423, 0.69385852520898839, -0.36531206953482137, 0.22429314490779673, 1.9275501996316475, 2.0383527961935761, -0.71703820180383115, 0.48240963433935979, 0.91197008207485231, 1.9230402538751723, 0.077234063690602525, -0.093211081902335013, 0.028684806850745752, -0.40202286670350584, 0.20104601401370986, 1.2918021212101036, -2.0226571539240452, 0.21264230480530955, -0.83085875648305585, -2.1942223353518249, -0.91881591624918724, -0.56644707311498299, -1.2045955367992882, 1.707211789408446, 0.99644076870995335, 1.4034901782656417, 0.87406661036191802, -0.47647803785512333, -1.4336244445526583, 2.2924467781421334, 1.7625246798216212, 0.051236442545617433, -0.13663882806115774, -0.22976978117905059, -2.2626389672606657, 0.84624922021654725, -1.3054959377871471, 0.042566910613721198, 0.46915764707356927, 0.22935531021945599, 0.48007602314611003, -0.91055225811097085, 1.2968202645043543, 0.55906842799191681, 0.61929476503539704],
                             [-0.59378210294853884, 0.019212704180582935, -1.7672898220289055, 0.36971993019537175, 0.98773667459400061, -0.27086898670652204, -0.3828485782581601, 2.3299522903136753, 1.2415897979098736, -1.8013311153206519, -0.5535184042769179, 1.661458182219254, -2.6471552744622415, -2.5581645464628253, -0.61430838471373206, 4.4395726096473718, -0.13794908077697976, 1.9344106723344108, 0.62575135215015043, -0.42833772823527239, 1.4237394591771566, 0.8629902330595558, -2.0438062810815238, 0.62048543349397045, 0.43316081029679054, 1.6718040908056526, -1.7207030947813837, 0.52329749295492778, -2.0598046701384871, -1.8112045559739687, 2.1714500338238047, 0.65420849265190584, -0.37361670076500597, 0.63354945927959205, 2.1135608054768866, 3.1531065245037162, -1.6524715096253115, -0.63167310374261265, 0.57339292816555676, 2.2614326964433777, -0.55563367227476479, 1.327335338371888, -0.64063102211162104, -0.76459403999781828, 0.11355990634403335, -0.60196594131635595, 1.2156482728056708, -0.71904435275718415, 0.12350751281591126, 3.715075366369827],
                             [0.61719117588824934, -0.91812442019282448, 0.050415915744266578, 0.66236512959719829, -1.1849990718881223, 2.4899392642619134, -0.64361815046009851, -0.56909521721221967, 0.45958695820134854, -2.1219901139688746, 0.84676701186673831, -1.9819382758200057, -1.0027340687464243, -0.085073690832116883, -0.17763415840891053, -1.3814003724924224, 0.1696829029461758, 0.74939731210941751, -2.2725005804042691, 1.0708008278723906, 0.78112449001515494, 2.0951134888251226, 0.049781281476777448, 0.87223592488179869, -0.21461376265551604, -0.525170065216222, 1.8360139195669742, 0.48027090073820772, 2.402858912203981, 1.249389925049869, -0.51277589939217239, 0.20789202349379893, 0.42756537012529583, 1.4988589998427615, -1.2940700542474894, -0.34117154167032443, -0.3624802223234323, -1.1050902778482214, -0.8924047757772342, -0.51837267006357579, 1.3875078173861422, -0.87626351497670951, -0.23975144105403293, -0.24138824086419677, 0.17076855743796085, 0.79750376761299802, 0.75987254175419106, -2.2542761117019596, -0.8817586454448938, -0.72998488468142098],
                             [2.5053874866995907, 0.34277878983852195, -1.216878953080758, 1.0837984103827185, 0.16660423521062456, 0.7022496514401505, -0.81467945244979811, -1.2541069886030172, -0.50301775272694338, -2.1374767585744925, 0.90661055777983113, -1.2570124613327618, -1.284419090281137, 0.92641340902773017, 0.89821161598761379, 1.1575930153357388, -0.56545121794906006, -0.11215350496996261, 0.77995669726586125, 1.2545375243184993, 1.514823146177116, -0.1626409000214124, -0.56064945483932227, -0.44970369969817486, -0.07405443764150399, 0.031204001280146554, 0.95852664544413058, 1.9297780842227441, 0.64363643426698947, -0.20835904630316876, 1.0141874246604545, -0.79198442557678539, 1.7454353513226717, -0.87182315245533126, 0.074079692933158511, 0.84607370711740371, -0.57610163963032468, -1.130548952740341, -1.0397033510165952, 0.18788347696968716, 1.5722665949369292, -0.72315526438311872, 0.48798459265472072, -1.4147954558940616, 0.56208488817493718, -0.28911070330014532, 1.8801690832089284, -1.7329845280826541, -0.52879289213350977, 0.64340598273870508],
                             [1.4381052710278102, -0.23433562225439386, 0.16462192063067999, 0.85664042553997533, 1.8681145773956185, -1.1366378284026579, -2.7426245383402361, 0.06740867371827805, 0.22342382804882932, 0.29316999165933222, -0.33675798182323008, 0.22148137532095902, 0.025410055910703042, -0.090249900075935585, 0.34876893352084226, -0.73905232931428799, 2.8028894340308872, 1.341336047878215, -0.31931545863476951, -1.1629231946185057, -1.1013109482222074, -1.4465016062576073, -1.3553059287406568, 0.96413820799141248, -1.4294076627539323, -0.70879511450502009, -0.42923932520520924, 1.0294669180026295, 0.41665211759559007, -0.58130389170066743, -0.85194728455651325, -0.091006672010447542, -0.24836667290059494, -1.1519080765972107, -0.40645527915819052, -0.41946611833876268, 0.11742161854172581, -1.4026852080943391, -0.10696192937021259, 0.30841303736373638, -0.73149029808851718, 1.3766997778446104, 0.67196072633496862, 0.81673277827276514, -2.2656074859017257, 0.94181596770605214, 0.0071317726920168134, 0.45707161651557826, 0.54225993330183442, -0.47007509506415079],
                             [0.028157527129458515, -0.52605450440527723, 1.9541643883484194, -2.7632403854967604, 0.74205325986947868, -0.2763037159995026, 0.17542924960715314, 0.21893598212786911, 0.66501793983445168, -1.8991306835946951, 0.76167187736127095, -0.068233846429341827, -0.046880189380023668, -0.87056985279817267, -1.2639598289868017, -1.1691095367534814, -1.8731498694240807, 0.78658234442017827, 1.1915958586642486, -0.64278015887392392, -3.2477161839280972, -0.21359017755850529, -0.23835754533150844, 0.88584940226718412, -0.68728573064427989, -1.5749058940180154, 0.9280979689754465, 1.0720060649665428, 0.31037610313773933, 0.22331321766857792, -1.3079120826317567, 0.10182012868147809, 0.59546979465977445, 0.40557043586920039, 0.20418265570980904, 0.6460248313569954, -0.29428342054249307, 1.4196261287269953, -0.68092390255330104, 1.0268619117237698, 0.30739323182361178, -0.064014086992854768, -1.8945683174695331, -0.15619474177759865, -0.43565397894853075, 1.1877072360603567, 0.40944512405780015, 1.0095972553742241, -2.2987859130941297, 1.5317648358156777],
                             [-0.094740938543411896, -0.94880623864229363, 1.7219202216913136, -0.25810084445748155, 0.8585037975763592, 0.71786129749061167, -0.32578631355569465, -0.20879450748478265, 0.12726017368071396, -0.89045434627818576, 0.91457798142737889, 0.65819580367602037, 0.32416060249243261, 1.4430504983577233, -1.0505730499003028, 0.86309321513208759, 0.89975831233658488, 0.50521845129044818, -0.24682309174111156, 0.89692454870311711, 0.30747920496431719, -1.3801761729078446, -1.0881099097978169, 0.44928772239280196, 0.24803438925922999, -0.63217090822358257, 0.41056490080530156, -1.7130691756467051, 0.5354642358418592, -0.70335823181119705, -0.42043309456536582, 1.4114058670224685, 0.80184982398935278, 0.53994181832265664, 0.97619925598125079, -1.6559702639555707, -0.96281291536693814, -1.60081705681107, 0.71131362709181101, 2.0934751364707886, 0.012011064609912435, -0.57919802392024866, 1.597531523596599, -2.9177916232200238, -0.6011542008628854, 0.085946271874140917, -0.56666526474535761, -1.2896655034748665, 1.8684231002838483, 1.5313543933726179],
                             [-0.49860384454329121, 3.1815707039787591, 0.60129435402575671, 0.097024310476866854, -1.7817180766027003, -2.0520437033742072, 1.1766270478915828, 0.15447056242840587, -3.2382989292190594, -0.72039035774850479, -1.4517356529886918, 0.71379234506404232, 0.34594919324244688, 0.51098626037061601, 3.6283915663051149, 0.18743062235693031, 1.4684234703846861, -0.20608224827405502, -0.42068333103989108, 2.4695070657660021, 0.07877603655790931, -0.70032075263258042, -2.0628986697353953, 0.64238470685087334, 1.7504106213395239, -0.52252450065333156, -2.8928467042614714, 0.90040427755982999, -1.5528676125306289, -0.78039573211398738, 1.6998181900361333, 1.4012313814393935, -0.77535854122035186, 0.17594445874680134, -1.0982456949023034, -1.3431246853864607, 0.50069587289276996, 0.75943946416646002, 0.13948452776662362, -1.5808960112363228, 0.26729902097157299, 0.54293370708933941, 1.0919839044890951, 2.2662957933615306, -0.50561802263071387, -0.039007277928542021, 0.29722388232754421, 1.5018898131475027, -0.67859134234234419, 0.98126229543447285],
                             [-1.6973802147627084, -2.3267383380988482, 0.90532968296465743, -2.0674723798152397, -0.83811273910647599, -0.012259551155976281, -0.013710321079592247, 0.18450807258504984, -1.2516741504027971, -0.33303304519769422, 2.4583828582710838, 0.31922162044097635, 0.70033427514273017, 1.7562527544874711, -2.1671361631245238, -0.16309335182497756, -1.1562158676039811, -0.62681962443070138, 0.028922640193372998, -0.76459406856085987, 1.0239409167725007, 0.19390084608827995, -0.62829635379467696, 1.3451575906924991, -0.060535489511091223, 0.57111465250648474, -0.78503816414751548, -1.5931913786402727, 0.18621990569214847, 1.4960521796989397, 0.13754745017052103, -0.43886703253614034, -0.83153420374011311, 0.64044213601204691, 1.423415043988842, -2.7797187069600295, -1.8914679485568904, 0.42155872438960951, 1.04774281396508, 0.91134553314299271, 0.80546763891943884, -0.73900040679928081, 0.45313174582236088, -1.4080828659488622, -0.25132812290427875, -0.53853587103341605, -0.10907990997021554, 0.19404902172866176, 0.055224578972469837, 1.5514318791005886],
                             [0.16967634126691206, -0.78068773900545163, 0.081815693611454243, -0.25632487977603557, -1.5035055339625074, 1.235546739808046, -0.43205716026616514, 2.8453005835270777, 2.4954699519991013, 0.67393038300394947, -0.018699406437355237, 0.36618743512789265, -0.33630103205865236, -1.534128478164682, -1.5880122007718553, -0.85979347646620197, -0.303496653447896, 0.3028697734300495, 0.60691544014738485, -2.0762579218033825, 1.1066584137656033, 0.38767321123697596, 0.093269608821358069, -1.7492391994160763, 0.42155571681407544, -1.0092471409267785, -1.3684327970062835, -1.1698979310957796, -0.13962199822019769, -0.95956912773606351, -0.3586394389505847, 0.53073395485327746, -2.1614007273206113, -0.0083367883036512547, 1.9627259685554732, 0.3962182002626024, 0.43933589313161625, 1.5773345086504986, 1.3044498669395392, 0.6399902243344413, -0.74470296381409584, -0.55876994679832404, -2.2309575964329165, 0.64667880541208744, -3.1431458732134852, 0.76581035487147875, -1.0973455730770829, -1.7513922941049405, 1.0661793372066815, -0.4026168492569846],
                             [0.89535976851569044, 1.2167028087111742, -2.0606967245296124, 0.93320669496842523, -1.0978983562384346, 0.38973949682158593, -1.0216986725188806, 1.9135960421812845, -1.9637421439072289, -0.19903387802571704, -0.36461151562898164, -1.6379122060481444, -1.2648355450724167, -2.0110154326058831, 1.2688699424350214, 0.43406127714914505, 0.079290278008746606, -1.0797747613303814, -0.754492428092289, -1.3911137374096887, -1.6078511812308018, 1.7196261006626024, -1.1131395332134657, 0.82831844762042051, 0.31971358669647093, -0.65928813716934476, -0.54410640097613383, -1.9401595228098858, -0.077343178940685847, -2.4002775257023972, 0.65960038231856077, 1.3083556215439183, -1.0153629557016564, 1.4330030696432809, -0.39241788205850126, 2.0035515433184177, -0.015723182965691349, -2.078359480924584, -0.9840746164819264, -0.75276556928939442, -0.29265928167540745, -0.033479830290936763, -0.34467920019163695, -0.17647061833846564, -0.30764757431378442, -0.86600491063130303, -0.17570636390964839, -1.3979013885775113, 0.26324850042880732, 0.70974468525651735],
                             [-0.0029998155682114114, 0.12963077980817439, 1.2295593482282181, 0.92937201534994884, 1.5135400367365945, 0.5180526859525576, 0.95658908483014771, 0.56923207643371887, -0.84939845744003883, -0.99349354658475542, -1.676440607395052, 0.2403104656427098, -1.8264341393019663, 1.6278920468542188, -0.044581255309816326, 1.1305957082106886, 1.5201395461592895, 0.65431940469257321, 0.62941568422331062, 0.99594555638434379, 0.51966156424905252, 0.54534284497706553, -1.2625952396135607, 0.97931429554816918, 0.64441132099064413, 0.59554916240753686, -0.25064210350177102, 0.88304178537064515, 0.58543093466568585, 0.50624789266978587, -2.9622338925805214, -0.42196110413336319, 1.6435997157824116, 1.5503924848265764, -0.057114215398949474, -1.6883318748090395, 1.4558051765654951, -0.25362690403142152, 0.14913403746912696, -0.46199424295437708, -1.0184780308872605, -0.49549047827732229, -0.34737867771942987, 0.161287272313203, -0.60423120392394714, -0.55937741270170693, 0.78754132067949933, -0.74074969526222723, -0.56793019805409517, 0.5253469320292079],
                             [2.2534048565091918, -0.18268946130003957, -0.071232391730642913, -3.3259078664988788, 1.5676869253380263, 0.4063736975300396, -0.33629803845102646, 0.52830170130565579, -2.44204691127895, 0.36971122140819085, -0.4904131038885029, 0.14452503388501398, -0.91644913384958748, -0.63951946369604062, 1.8261647315996026, 0.046543336892300315, 0.48712090428135219, -0.40523333951736978, 1.1927394424267905, 0.21304661747218662, -0.94791940695797028, -1.2474021281382255, -0.92523439799512963, 0.069878276686032109, 0.34881006211726057, 0.79384272088482466, -1.1300568297981866, 2.2579268979166369, -0.65013682016817742, 0.53127241666581682, -1.2016539258333681, 1.4210001975074074, 0.2379242059668597, -2.8556111353806934, -0.13198264775784896, -1.1965374748738948, 1.3733547697183355, 2.1428715920090058, 0.39579337413230214, -0.42174692231777, 0.078418944070915403, 1.6672406393282333, -2.2409115423514416, -0.85424457989107616, -1.0115732510261133, -0.79730887136407502, 1.5200573535419579, 1.0118854519177019, -0.27604605515391173, 0.17217264075012004],
                             [1.0641920661629334, 0.10130084754990616, 0.69667595651943293, 7.1427696659479012e-05, 1.3347542310388125, 0.77499190832174769, -0.31662809877402737, -0.86186059380965596, 0.26787880728835678, -1.0593784395465227, 0.95705177262368657, 1.1282341523162727, 0.65899563797838456, -1.7930214311479886, -1.9370305464068645, -0.96618138954374166, -1.8795889267530015, -0.88452454780214296, -0.31983817563977773, -1.0864029929925894, 0.7294082160675327, -0.64663359756934935, 0.30521995834054916, 2.2686328667610107, -0.48509204643722481, 0.024476333721802121, 0.24805173963389257, 0.1218069186718491, 0.26833414480132206, -1.3562497157718458, 0.23808454680967045, 0.9735053367302271, -1.8990230290467744, -2.1320726845481359, -1.4116029699878923, 0.29421841527939518, -1.1795870067654335, 1.7897412262006791, 0.72842168908309624, -0.94644428050880025, 0.4550996161075852, -0.39821179548378677, -1.5711436420573504, 0.93610697666984688, -1.6807534728804292, -0.63604876149452838, -1.1863567143363056, 0.35448354003775129, 1.7028187541576227, -1.5898194143173923],
                             [-1.3084071314649974, 2.0584084995501923, -0.64263787322320243, -0.57208450715431636, -0.70205133852234847, -2.2364389729619192, 2.4657128877170567, 0.30599976306420423, -1.160441767448072, 0.84590112633958892, -0.1346556476929241, -0.12199802009578244, 0.29895920457893993, -0.26333205853354297, -1.4051655426536442, 1.3957655082717133, 2.0444414171538963, 1.6562777579176782, 1.3982349304132442, 0.48492240311646911, 1.1023943193334416, 1.0978359236480755, -0.35644914140105977, -0.24651314126599225, 1.9255358191109953, 0.51686100724683604, -0.07350484757155186, 1.0596474830146754, -1.0105691568756183, -0.12860185182790554, 0.27406001874368019, -0.49511892641005983, 0.86850927279923074, 0.011615877117009787, -3.5505653863632771, -0.20006279566495402, 0.1011205723805306, 0.29938413964674426, -0.65224095709633778, 0.83261884924300844, -0.14068620852789923, -0.95106259578806673, -1.4783421331968052, 2.4382424921742105, 1.0658981292319596, 1.0458055112348583, 0.41307257083145132, -1.0419052544590708, 0.43952537960184312, -2.8294862025086567],
                             [-2.6879920154137098, 0.28263890986719525, -0.72063811226610963, -2.1872548649418668, 0.047829177570595516, 1.4183089041309895, -0.38372499231570867, -0.8297042782861781, 0.18754995541834427, -1.4772061557368217, 0.89469834115123303, 0.36752163676761906, 0.12733589242337068, -0.42566727793450687, -0.22154291161194176, -2.2102363037710293, -0.31524454152151793, 0.66512073403810168, -0.95556043710555016, -0.46144920822029178, 1.655866225473499, -0.037977373063726838, 2.1490005492337638, -0.48646736184903266, 0.71683540009362368, -0.54829205108713441, -0.17367792299833415, -2.1650815605390186, 0.99419257854723431, 0.31926037455738632, 1.0534715568665196, 0.79435975415103011, 0.51994025559635459, 1.6607624611841181, 1.220968273378447, 0.44491773028382142, 0.17469170424934882, -1.7752083588554117, 0.11446380882675444, 0.12634751761273488, -0.15167633701407435, -0.53874198633038151, 0.070720955972889521, -1.372840332797673, 0.80565639149011781, 1.2870902385221428, -0.57834532659813387, -0.85564530424348673, -0.3807038389512018, 2.4476265651439904],
                             [0.13768237542268996, 0.33812481316255827, -0.31335586500858953, -1.1918747575031381, -0.97978876124475267, 1.0938326166006709, -0.26020043392922421, 0.45782965593782798, 0.11725477961448152, -0.018518215621225603, -1.1155941765381456, -0.92690538225550567, 0.040083067215595437, -0.62147224684953839, 0.97029684794044435, -0.028208264748336792, 1.0987996499265937, -0.044810046549810197, -0.31883298521288572, 0.76052552967738274, 0.7438875756921931, 0.133930772937319, 1.8817629208274427, -1.2867650683006731, 0.88096154785945013, -0.052211324610504511, 2.3451583481468012, -0.90635365397205037, 0.088468754812200151, 0.78973304781816522, 1.9334880976573494, 0.42132020090250272, 2.0104005515799517, -0.1273481721770065, -1.2163486252390174, -2.0443757033589853, 0.92443681061733274, -1.8866771041271246, -0.9377732753352872, -0.63981218672059892, -1.2804060892258733, -0.33589454107318245, 0.45575989197038996, -1.6274955006370493, 1.4064361228421156, 1.1382327414097242, -0.59730859112778767, -1.0144112235359233, 1.2870795367450745, 2.4266058404140218],
                             [-0.94378858756645845, -1.5249101234872582, -0.069427527307399178, 1.0268244542872829, -1.7536061532623712, 1.8245964792069571, 1.5781714236020108, -0.049158308861408866, 2.6264228308169262, 2.3607051615438435, 1.1393316831331315, 1.2818259611603584, 1.8829408720448808, -0.018657884513205242, -0.37433643649178727, -1.6185863191869563, -0.78295393932212165, -0.24576146080646266, -2.8423096470702673, -0.1970074116894357, 0.97974974378626545, 0.98389244710581247, 0.6750550477661178, -0.034422211072195376, 1.4239669432088335, -2.0178841925264996, 0.6197981536022843, -1.4392689410007737, 0.18374677075085605, 1.5232145731943467, -0.51242923330148693, -1.4283942933697904, 0.5767398480789091, 3.309895239168807, 0.69054941077141163, -0.93855799621726266, 1.763499984917791, -0.26016635712457425, 0.99773706065981005, -1.535633581554902, -0.71294837882286621, -1.1980458546689992, -0.60922682219221902, 0.47739313902766439, -2.0971789069225149, -0.011346808877201103, 0.7620495121640154, 2.1438284104537435, -0.25058120643851256, 0.64319364810048096]],
                            [[1.0896493222294317, 0.19939201767872128, 1.54088778657269, -0.7381692066436798, 2.5489133226697236, -1.5244564017347981, 0.45412579052122992, 2.90113725219754, -1.7725521048627744, 5.025204460447136, 1.4811834084674176, 2.0800685163473323, -1.6257210488637581, -2.647578388657994, 1.6585715529864204, -5.3333451416496809, -0.59160872474918491, 3.4316134978120991, -4.8697965078189123, 4.0628844872659666, -0.48595537299689351, 1.520541412031128, 1.018309401563088, 5.0492201009325051, -1.3453295078832084, 2.44769966641468, -5.1701655230666201, -3.7398924190818605, 1.8386558018574866, -0.64583603718770144, -2.5049787214998549, 2.0646933883717162, 0.10685291848294838, -0.26799208446996403, 0.87427654128029708, 0.55081986661974658, 3.2357437444548292, 1.7772089880272683, 0.78031345846594702, 1.6489953814139766, 3.0617626070439821, 2.3229602991838791, 5.2191429587789111, -0.69968970978066425, -2.0565459755698763, 2.2831525337621263, -0.76672641238244887, -1.4677627075306654, -6.8313444513629173, 3.2979649360412675],
                             [0.36933668683223542, -5.0277902526162705, -3.1220284930053124, -1.2801995041395196, 2.7678707445049886, 0.62130058151713019, 0.97461915538541566, 2.518368323590376, 1.0265689176268895, 0.86122851451326543, 5.0405761673835849, 0.31205688404284232, 5.4186161290476269, 2.3484596511632825, -3.8879320778499529, -3.1397200267429199, 1.0108118079407604, -0.75898223009117705, -2.081188256880325, 1.2636580602479954, 4.2490411049334771, 2.3661567538946362, 0.66922435930024204, 0.58128212693143444, -2.0518144179557134, -0.7613985914800564, -2.900484727037528, 2.9697476489360359, 0.99847124029014167, 1.8574882232191652, -0.78763550696231566, -1.9009536781810541, -0.83288453087541681, -1.717238766570554, 0.0055417570271348929, -1.7055178883079203, 5.3644085561984065, 0.15819350387752662, -2.2756481446461132, 3.2163892819444184, 0.40026840547660525, 4.2935115951114176, 2.69416906988257, -1.0965945617606152, 3.9309200405972766, -3.6582301569052449, -4.9725297200005061, 2.522811764489898, -0.3089079508783375, 3.9920615257918204],
                             [1.3769510232488207, -2.0993975617927689, -4.2732092915526358, 0.8945340473823008, -2.4278791008685316, 3.4450594954955518, 2.2930014462579518, 0.88133003245544295, 0.5368443118604509, -3.9089210857529366, 3.5524455496839669, 1.0108114288296972, 1.6060132911103593, 1.9263571045591994, 3.8329163743993928, 2.4824839074568921, -0.24801469738832246, -4.6481362771175823, 1.5215121028508338, 0.47692395038354568, -1.1064151483236619, 0.45136698485719506, -0.20148399823662089, 2.4940399336179411, -0.14497734628303144, 4.9462363858930374, 1.7389458747925601, 1.6465198309258635, 1.2240170256760197, -0.69486588519525316, 1.5717896256438462, 1.2877796358819393, 0.059215042814240476, -1.198332552032852, 0.2626275870076249, 1.8047028509978842, 2.3450146869483435, -0.93614090016924745, -3.2959500952174632, -3.554536037748425, -2.3787851622279521, -0.18964909972582719, -1.4921084523662358, -3.7450354410807893, 1.2722008153813589, -1.8594025470940816, 1.7240026099724086, 0.29659621099674005, 4.0453480868424005, -2.3218840017144831],
                             [-0.062198424577150531, -4.2799904371034518, -1.7099585463356493, 2.8800756492476034, -4.1556823707133255, 3.3339858601164378, -2.3011941357453356, 0.88749426358416705, 2.3941367462129932, 2.3395961022153866, 3.1331217882975273, -0.87691157929074037, 1.8854476957813047, -0.94538794723064856, -0.77752772219521959, -2.0050951610739904, 0.50925162405735325, -5.4662314290078058, 5.2750000624967086, 2.7730613800005468, 1.2853417486853687, -4.0350938850195348, 0.052147721190776278, 3.5695525957202339, -0.060066029666411544, 0.74431428741201111, 2.0809218627137382, 1.8728341856098876, -0.73342924005800247, -1.3354572519825241, 3.6249926129280778, -0.21756045315145706, -0.2439913550691418, 0.10984292159618052, 0.22820043083726738, -6.7582108320996026, 3.1003645101790065, 3.2179054021946256, -3.2927928731619307, 0.18924700986817841, 0.78024377294934921, -0.65900011152272031, 2.8175138353305136, -0.49075295782158168, -0.75910441016094121, 0.17207488056413245, -3.7381639878955895, -1.5034501631397037, 0.94944941990315201, 3.3337690703146077],
                             [-0.52846585242979116, -0.97980449549902615, -1.0920010715038457, -4.3453722937144299, 1.584758755694085, -0.50620989600525323, 3.7697343837598032, 1.953191008921022, -3.1561627061757558, -3.4148093889639251, -3.2184923170195865, -1.1111479228650354, 5.1904279173694912, 2.1387562034536787, -0.5608791888765432, 3.4459905211145894, -1.360653128449844, 2.8223001856285164, -2.1005836738109616, 1.9490356263862854, -1.1779326949630557, 5.0465677648566558, 4.0084296393237135, -1.6068728394084673, 3.7776816493339562, 4.797481887760954, -1.0929744808053885, -0.081047676141442981, 2.5755260105648801, 1.155128889422544, 1.1168153363566982, -1.7442089071958644, 1.4699388725736457, -0.61341065263049621, -0.75804831215444435, 5.8004762423026337, -3.1132049301453053, -2.8082222669432815, 0.16190981600515147, -1.4780247070975687, 4.4002768733395685, 2.8910517189913336, -1.3448660999857365, 0.62694927140517442, 3.0051587490809704, -1.149385254004071, 0.81010265777610269, -1.6850292036369023, 0.59655273897377592, -1.5135241651763538],
                             [1.8338127462311711, 4.8762426322780463, 0.079603061597731783, -3.1007778194045619, -2.3015965316152087, -1.3004830394833218, -1.335031880612733, -0.41293719149440183, -1.6224103532280101, -1.7151748393359467, -2.8958796743916522, -3.7966267542900161, -1.7604278130706117, -4.3144626863059603, -1.9080892189629088, 4.2421823248804138, 3.2259660778507304, -0.94501893779377888, 0.51533202782405163, 1.8890099085189205, -0.54729054365477636, 2.0082940209953897, -1.201724668336033, -0.19068997179664987, 1.1211184552379008, -1.1088122035668846, -2.0972264208355904, -5.1547828696226201, 2.3773181615024424, 2.7092216538421616, -2.8168029623253661, 2.4168768501286007, 1.5630776817959413, 0.50009124966305807, -1.1841650190573498, 0.06191617531347117, -0.78073029330834354, 1.6908274864649064, -6.2402909501131667, -0.85364609545307424, -0.50372842429004172, -0.3305531034109685, -4.388258391482621, -2.5933510829237991, 0.1394765335791476, 1.6278585824933278, -0.57664114380777842, -3.0680663133694561, -1.7409735568815474, -0.71705587769065482],
                             [1.014969046852338, -0.9065597105909009, -0.27651515438718588, 3.8352311860394468, 1.5901416806221116, -2.7002219005013135, 0.53872802157358279, -0.30601542499890416, 1.5706251132840667, -1.3189943287438657, 1.8688576286000116, -0.18049581241754697, 3.4617652548728493, 1.1147100168472874, -1.8772809140569786, -0.63937664605041955, 1.8082240116651782, 2.6494705178914324, -0.055768848507981909, 1.8677074886892795, 0.46277940239531357, 0.7182293605462492, 0.49467639339564179, -1.7163835559685763, 0.20285638902606901, 0.20012167435276745, 1.4511885903644788, 3.6904540397983765, -1.3225154367651946, 2.3359774232152311, -2.287986751107288, -0.78489523573088393, -0.31364303171493957, -0.77185778439663455, -0.13072220935799053, 3.85502778728425, 0.67471306909270079, -2.0198204180752493, 0.51983397410861321, -1.0816715505114631, -1.6016238593398382, -0.44341104635783246, 0.49600431916096205, -0.29431294448753853, 1.3548686218086199, 0.29074098742541893, 3.5587857549395876, 1.3547475283681694, 3.2317407926097923, -3.6875850227490883],
                             [1.9304884870810926, 0.10612624333635384, 1.613752095895518, 3.2861526051778376, 1.7908037097543061, -0.31058099206803252, 2.1294288675062529, 0.31309968471496075, -0.97859601794509354, 4.9536065428818556, 2.5424991530376979, 0.087015537061569115, -0.4070359634445303, -1.0642282089080426, 0.76534150130518874, 0.82563728758417054, 0.93520919583480711, 2.0774376427920984, 0.15458249566805096, 1.1118263623354203, 1.1465390763293895, -1.0889701654865813, 1.7674619473745425, 2.4978174492325169, 0.055298060386363208, 4.9924257633596554, -1.1913223890189837, 1.4170148766297124, -0.9208466375171559, -1.2226836288075265, -2.7995165555873065, -0.69931431179162318, -0.64789391840650246, 0.41713017896692056, 2.7507611789828457, -0.31666737859316585, 1.7859698283137264, -0.43548033645497314, 0.33292261110451699, -1.0003313287729247, 0.43359883159168028, -1.8699202419378198, 1.9036154647718533, 0.83062148710999228, -2.4716695184621931, 0.044084771062457381, -0.71831099737386994, -2.9932918276354146, -1.8456434888488606, -1.4487984562716414],
                             [0.71253685834936431, 0.13371167531092959, 2.8996666650711913, 0.30179880197225267, -4.4521454378123462, -1.203729070987636, 0.60496067834988121, 0.32214377218784335, -0.90300803058075463, -0.80176588385889358, -3.5532578317659178, -0.42901705177902405, 0.72321253012377873, 0.26081664710450103, -0.57041716446532997, 1.413256235042889, 1.6646247640113878, -2.9134820329723512, 1.057180186304485, 0.51734532733042216, 1.1977031604643713, 3.3742391880280707, 4.1908661892339252, -3.0054052675514953, -0.4798538830798641, -1.9616853213896082, 1.4806136164933281, -0.88020229639077963, -1.5981378821475594, 0.91568591715335446, 1.6237414923678211, 0.99880797449347891, -1.6913094467402734, 0.73612134646941918, 2.1930396484253434, 3.7343658874536767, -3.0075869472833374, 0.51158628764753034, 0.95925449210064939, -0.44716292438369742, 4.2329365406582973, 0.98585394565732887, -0.77843245909701309, 1.537087108475462, 2.6165973066885648, -0.77321081842961403, 2.3709413554679073, -2.0510741042629559, -0.39422443263736168, -6.7240397391313911],
                             [-0.85282059253197373, -0.28936634616754825, 0.41030999353191777, -1.9412922444590319, -2.1350670900791711, -2.7126551876977025, -1.5408690224673083, -3.0232140063748685, -0.22670170560152342, -0.34399372800813705, -2.0271048369919278, -1.3689829618963987, -4.0751042771670871, 0.25434989674033109, -4.3373521707314868, -4.426994863890509, 2.2594632693266554, 0.67245030075616563, 0.99516840431973352, -2.648626324814277, 0.42676825858753376, -7.5886785903558911, -1.9259523644574896, -2.5184450265879796, -0.13497755082847157, -8.6100367833029026, -0.97071155693225863, -2.4603899216149312, -1.6346368626071253, 1.3638565683791695, -0.68711116825790397, 0.82405294848482868, -0.12054001436449938, -3.5400274873046604, -0.56241924253140851, -1.5888640887009997, -0.30150274958833834, -3.1160923345219049, -1.2814514193957915, 0.62283331156591371, -4.7131269623678369, 1.2782092898892663, -0.2228443670892839, 0.84094659912505842, 2.108117922992629, 2.3709888220163116, -3.3039924071503011, 1.4716630451201056, 0.5946971575349641, -1.9847691990652949],
                             [5.2529412283725598, -0.65500413127843826, -3.8787475765436361, -1.8565053411972718, 3.0112512910099851, -0.4063408455444284, 2.1398199509415754, 2.2181708873367403, 2.2731115015854559, 2.761375336629996, 2.5650942162860915, 2.2302925963396105, -0.92882189047486041, -0.99179128499180602, -2.6223036680567056, 3.3409742872065404, 3.0641910697689316, 3.70457285586496, 0.57970538698119722, 6.5213202941714767, -0.54595766737813245, 1.7092288623589276, -0.79520027912646596, 2.4924371161375274, 1.0666458052808592, 8.3426417818762282, -4.1136176592247216, 2.3046382717095226, 0.0039076358016239907, 2.5367786797044252, -5.0585445361975232, 1.3587595205754259, -0.52763137134166793, -0.97397104456120043, -0.71504580694870268, -0.084879982384575281, -0.013922083837579254, -6.2891298064848371, -0.42515731946532553, -6.9655842294284511, -3.4590320061658639, -0.12253673588935894, -0.89946917240459612, -0.47068816236278616, 1.094379291714644, 0.76019402605375264, 1.2243166620569783, -0.0044819664385709656, 0.44546518206892416, -1.9219925034393408],
                             [-2.4188723189001982, -0.022029466620163765, 0.20203695789747037, 2.3958925849013371, 0.91959241397494496, 4.6218043416491952, -1.4281478282940996, 0.14943961984300486, 1.1594123070630822, -4.5437569105717088, -0.22824414158500864, -0.078606368077123304, -0.19796857275299573, -0.94236053539264186, 7.342985333842317, 2.06643738920866, -2.5217002970358671, -0.18602588315086083, 0.25775107584116247, -2.6117942882950023, 1.6794111921001353, -0.77940002394783481, -3.7629068395009106, -0.76915141796386666, 3.348383135313528, -0.81475667661458118, 4.0405604950227181, -0.7588934272093838, 0.31380047877909167, -0.062157405833796031, -2.2804778438188857, 0.86466140103869349, -3.1090776819451706, -0.13185370354205422, 1.7849477319397442, 0.51474328375789768, -0.59213286402938103, 0.01945115062645511, -2.1688246005616056, 1.0401047160729413, -0.71079469532426598, -2.2503476727579947, -3.7799422071764806, -1.5608274445434012, -4.5019425144125211, 0.29874572526351251, -0.74702986188984588, 3.037031901208787, 4.4257970845133219, 0.1480872034099463],
                             [0.11912295033238711, 1.9857557741834864, 3.3819124484244192, 2.4506115499973826, 9.2905253532657621, 3.8341996631008186, 3.3650279740316482, -0.86993700676045382, -0.86816168940987926, -0.42566922318026934, 1.1000089742854031, 2.2862076556436213, -0.62445478055767778, 4.1025809775135071, 4.8948083034655063, 1.9971555489351991, -3.3423403279686346, 4.3960850652595722, -6.0446132034527009, -4.3308404894295629, 0.0055045231278371132, 2.1247002570997071, -1.3819440209249449, 0.080150629962610548, -0.11796991245831957, -1.0107724482165934, -3.2724039113418875, 2.4450904534271167, -0.39678517562906873, 2.3304589953141046, -1.5765593143928334, -1.5896765452387125, -0.42325925795815073, 3.4032788004327927, -3.3589807401138221, 2.5679751447315957, 1.7209532214293364, -2.9345869609877462, 2.7053773049003129, -1.0824343860743557, -5.5893052024732892, -1.3323862228616556, -1.8521478905917743, -0.72569736933981477, -2.6969084283049551, -1.124804892434204, 3.7455123938054915, 5.9797740179722698, -1.332285782720569, 4.8743644586679995],
                             [-0.70808085148658462, 3.7668053300989262, 2.8796670867294698, 1.9937927044793893, -2.258780063520387, -1.9908932561517458, 2.9108355085720881, -0.16641345352830669, -1.9013885588352719, 2.5386584431972978, -0.64712813463297547, 0.69510393190472886, 0.43436078566626807, 0.29567586553753222, 2.7777571842966222, -2.7649720923640047, -0.39044567951355313, 0.18788203119118996, -2.6901201416960911, 3.4121111694812409, 0.4474143601560549, 2.6673080939443667, 5.707061686049423, -2.3709540254997394, -0.94307406515957393, 4.1698339122940418, -0.35224137726877153, -1.2512932963740373, -0.23959394115292493, -0.36361445782876772, 0.46563375852342909, -1.4787229732924627, -1.1119576479927606, 3.2996377405943798, 0.91014765433474498, 4.960885974880707, -0.22060500394647581, -0.88404791885979195, 2.7251317090470808, 0.25698828276750152, 3.7192778192840663, 0.0026891884274040413, 1.978926015139324, 0.415630766962583, -0.59477398503621903, 0.67721579351470473, 2.1488815098067748, -1.151834567001204, -1.9157796797629842, -5.7652007312482834],
                             [-1.1429766009616589, 0.88089836142150302, -0.19684410711117981, -2.0591784935550241, 1.5996247637905847, 0.87102048127941611, 1.1514208899054514, 1.706588241314656, -2.8738304678832001, -1.7842788627185207, -0.38564333816703528, 5.1326752419993866, -3.049575278651643, 1.2825582558843596, -3.5531533215199222, -0.91088268807641393, -1.2824176876285935, 8.4052444781281128, -6.3050385381519503, 1.7461868528747306, -0.078171855595807346, 5.7585178071717467, -0.51979688225706067, -2.4999808675874187, 0.30817913267022573, -2.3912096647355976, -5.7529284193214094, -2.3708068741058086, -3.473181257983124, 2.7503095463805227, 2.6299105473677526, 3.3477491630682459, -1.3551649724092925, -0.084311398474106666, 0.81035207588566327, 1.645781429815669, -2.4858582718876905, -6.6131826756454064, 2.1384042742365343, 2.1245507036398878, 3.01515148269679, 1.9038645296527932, 1.2965302416585325, 0.94202826145183072, 0.40845098654130546, -0.27672484697694655, 1.5935437548230529, 2.8645484149453111, -7.6163115945230855, 2.6617466099890148],
                             [4.3742226185563817, 0.21251565111048829, 0.1309997235747952, 1.0255289598531709, -2.4014486537497075, 3.1695302685943645, 0.94103994466804153, 2.2800139702394717, 2.3096921447224812, -1.2401047293356335, 4.5031828362655855, 4.0588301060606629, -4.3725154959673702, -3.4982725319889627, -0.16563124128630879, 1.9576221848110156, -0.51431574187380469, 1.1560759914671905, -3.5567313634766888, 3.989754730025171, 2.9301478108196259, 4.6864088777104378, 0.81598406886855479, 0.54145200328073551, 1.7254180911531911, 1.2470341543631964, -3.4372237066948834, -2.5744186622237524, -2.0316740013643786, -1.0713667646317129, -0.45037223990708991, 1.8925141483629058, -2.6869488548363547, -1.446756536418206, 1.3873853386209323, 0.051029398366052671, -1.1708054458404946, -4.6773898968343914, -0.92783045013146892, 0.571567596807113, 0.18302799226891528, -0.85713808814975923, -0.079038671689596246, 0.60668153952195036, 0.43473539912066489, -0.48950564471833113, 0.0065351374630556458, -2.1941328387233074, -0.097951188081871823, -3.2066348485478624],
                             [1.6690301049587861, -4.8741008096031919, -0.25845851608916998, -0.983121769418282, -4.9562534100156279, -1.5523238081327047, 2.0469451909085752, 2.1029441995414517, 2.0005941334716737, -2.1368492139854118, -0.29263546402006246, 0.96204435834157975, 6.2428935336206184, -0.42896622533824824, 3.0724941547171936, -3.8727927368773893, 3.8329705126108635, -3.5069443770383382, -0.47969291712255097, 5.8601741886853844, 3.4754209532428924, 0.038252455770907363, 4.5403924144184522, 2.1122927293437148, -1.0641705225923457, 6.7170079971089649, 2.5040351928607323, -1.9453671756964921, 2.5174572016140107, -0.18184320148340655, 0.0080883370691373219, -1.1211716358836064, -2.2835199885181638, -0.86343114278759914, -1.3377616224375826, 1.1742069442594125, -0.67211719620815569, 1.5611411129962744, -2.025173287924797, 0.82550307892209729, 3.0293844748425358, 2.4504565875190001, 3.5841186116835195, -1.1780212449354739, 0.24665967487483437, -1.8427115377020002, -2.4551716650604707, -4.8456755618383891, 2.3676954023656784, -2.3885746559221426],
                             [-2.5230221457714315, 1.055104380385596, -3.8159666371981174, -1.2711911900500388, 0.56973137690530573, 2.8444926476680559, 0.68148228115417986, -3.4679358507992042, -2.256575986765283, -4.1652593418274453, 2.3979509943667678, -0.29203051300901545, -2.1960167928888583, 4.1082296255576551, -0.057211428990903791, 3.2829802751344661, -4.130090109998183, 1.3394109089967812, 1.7091292238897084, -5.7924618991057759, -3.3788016375142842, -3.333058065840695, -3.9817709073998175, -3.4728507531087596, -0.025544284090362916, -1.6172781671776162, 1.010672253426542, 1.1862043562373841, -4.9899481125526064, -1.9593597950009527, 2.4366367435515048, -1.725719006838053, 3.5111515750162474, -1.7040869407861849, 0.81794873266877088, -2.2842239922466665, -1.4018763026157071, -4.7564624932148556, 0.90522818851826281, -2.3065806881474034, -5.6881692186405122, -1.6648944645734736, -1.5169660350528751, 0.84595366022626672, -2.956407278463586, -0.24517006649308079, 1.0668330437977727, 2.5469219124584526, 2.3245839647397424, 4.607720456648952],
                             [-0.26407926666680559, 1.0495731400001092, 1.8505958684766322, 0.093809084626812589, -2.3579463913588441, 0.1104072121047802, -3.4563230713867652, 3.3999174971637545, 2.2791959607129879, 3.7793419678190241, -3.6540869221356709, 1.1600648211821694, -3.3116847925628581, -3.1287819564983352, 1.3832826030357532, 0.73592717009691067, -1.1453169219235126, 0.9986089113133767, 1.4261071631976963, 0.68051064026555053, 3.78238395302205, 1.5645687573110807, -4.2654447508506763, 1.2838359008745488, -1.3684937565000017, -5.6222370488812361, 0.47261085064008324, -0.6085960082635673, 0.65586871662196677, -0.8506101483136469, 1.2650704440873712, 1.2943599687598892, -4.4137922095810129, 0.79830368212376146, 4.8113110344207275, -0.29802719144716572, 1.2408816862477614, 0.57986456296374833, 2.7491287845868806, 4.511113573245451, 3.4055217374016902, -5.989155635628534, 1.7133964691577532, 1.0981969369413491, 1.3040775049389957, 2.4793104037531202, 1.8764176273011759, -1.7454270093403732, -1.2489060546684865, -1.0021523654458653],
                             [-1.7214286591656589, -2.0253313215234083, -1.0324643040920889, 1.6095773152584798, 1.3476777211811257, 4.3900392449519989, 1.8385538385013884, 2.4958209175466783, -2.2381482414317531, -1.5953345867119468, 1.0342826694480678, 0.16006514344668757, 1.8458137978525972, 2.7004684648807231, 2.5309508851661811, -1.4310029481418072, -2.5711773459479526, -0.93109558283480498, -3.63492196181876, -3.9031474500637278, 1.1911763114838525, 1.6859653646191359, 1.4240498282480447, 0.81748944664048429, -0.31616828147904602, 2.5496602044486552, 0.88817987541016608, -0.92576708805337293, -1.890705796816833, 1.031834186418064, -2.1533227438506519, 0.9414675478375325, -0.093040455227618779, -2.8612699268389639, -0.20175411542603738, 1.8344335836714263, -0.30353376375719249, -0.54360647511577165, -0.18954590601476576, 1.3771963488997405, -0.98676405629711383, 0.8035623455166313, -0.68554539782822277, 1.0982506115057016, -5.4415340316888292, -3.1500141481208828, -0.031078047713585973, -0.14593837688582623, -1.0597195329523257, 0.21059150310722394],
                             [-0.65133513160353851, -5.9039325763111528, -2.619549615664285, 6.0468943804081796, 1.6750315044044772, 1.697919590766938, 1.2177113017548531, 1.0747048955581038, 6.2734280352197773, 1.7948139546411264, 5.5638750016917475, 0.38861455315914756, 4.5376466237441893, 2.120864738909638, 1.1250953729776005, -3.6476180007489263, 2.103592670602207, -0.88223811050575152, 0.012880526457009309, 2.3209389824548947, 1.5994111436118545, -1.7676962831291789, -2.351828569753021, 4.1591192353117412, -0.9704198195704834, 3.4216619088833853, 2.4548887314523453, 4.958634888713668, 1.56335645057104, -1.498475141691797, 2.5313210983184811, -2.708572595381582, 0.40078798311461805, -2.7685481835204682, -1.8201269837024632, -2.6367494839862462, 8.4698231643436834, -0.55076479854641636, 2.4932554160389433, 4.5677064228360855, -3.2615355252212312, -2.2960365976727735, 5.8337811799689039, 2.7963774942132482, -1.3470130517443715, 1.1840112880585874, -1.7270963475512615, 2.3446997664767824, 0.14502439262568081, 2.344615354080843],
                             [4.6898436669629939, 2.4086889694176907, 7.3482858688225248, -0.70680297246604451, 2.9562219267890324, -5.3644181377956262, -1.2417227286088555, 3.1365001155814531, 1.8933050017654034, -1.5604045718373687, 6.4358667491794286, 1.0606018831624386, -3.6131395888894984, -7.3628903043255276, 5.1595230809607537, -2.2826730085241098, 3.304598938107115, 6.355977917563771, -6.6597988365992471, -0.81740521687191403, 6.582328819882818, 3.5621282178406077, 4.1279228441595146, 1.5908569380308115, 2.8710085328841917, -4.2177818230216682, -5.2598931391488239, -5.4308503226567622, 2.1415910400614342, 0.78474822849712644, -9.4664693349214151, 3.2549274534545378, -0.16651912585870232, 0.27508259579501199, -0.82488562698173062, 4.4604476317367627, -3.5616972672614851, 2.2764844329717766, -1.7443268933803719, 6.6708862932439921, -0.44874752315823463, 2.5869813393837653, 0.78427111274989347, -2.8737011127810979, -2.2726805405245285, -0.17763390051697303, -3.3804579356346389, -2.6084750049934478, 0.93493066804217806, -2.8543631171382002],
                             [0.22954270199276872, -0.1599227738689375, -0.51993606532034276, 0.16268574506989189, -4.3318234143770997, 0.77053760688479911, -1.100493831261709, -0.63787765119265527, -0.0036138171672790848, 0.87794980741988193, -0.5828175583281745, -2.0073130906031089, -0.80861657157830258, -3.1717989432191369, -2.2853108640753619, -3.1362490999540684, 0.91170577304312972, -2.9765589646926616, 2.6787377401793648, 1.6877891708942092, 2.7546161708790859, -4.2433091217492969, -0.11417836557674475, -3.8347077981116953, 3.2987992196209848, -6.0145750584824311, 2.8383246643325992, 0.1750812786001355, -0.2935780097889566, -0.11866940615813942, -0.56999040391521583, -2.6937369484684441, 1.4593401928720244, -1.682438576536426, 4.9775928179187838, -3.5753400968244877, -1.9184152058729953, 0.60236668302115992, -3.0021268265060113, 0.59823485302040869, 0.26967776249200859, -1.1862841472586438, -0.87797949270711895, 0.79636953081940742, 1.3620529765129767, 0.018245350534932793, -4.0525797015804521, -1.2410918741955188, 0.44004166468928596, -4.0832131600618897],
                             [-1.9540881049084866, 4.1432493065652363, 1.6114842042917163, 1.7442785632333835, -0.73607427689687788, 0.6727725149521363, 1.3843660078898405, 0.84868841934466044, -4.8500882890353294, 0.56636644486882248, -0.057354719129608316, 0.55864214556146041, -3.0337961565741773, 0.89347456332290198, -1.2072392264284706, 1.9367836019342055, -5.378051712206366, 1.2993053493345053, -2.4399972159797985, -2.6106242133516981, -0.96568971455536168, 0.73293396347881123, 1.5352103049422767, 2.6862903034644097, -0.61139794469537467, 0.44746354116389325, -1.0197112764492773, -2.4324032578000239, -1.2740531778018027, -1.5348285245905318, 1.8616368605724838, -0.43589530748444072, 0.29658714520643209, -0.8908521814985696, 5.8110588259034497, -0.88404731886500076, -1.9972412274825722, 0.010660008121568032, 0.82109188213434137, 0.28675632325363276, 4.8800021116084666, -2.524900198523568, -0.13793186198132013, -2.022282359332753, -2.5484321197586075, 1.2468817259305098, -1.3054031008428879, -4.5216318236850084, -6.4177667240546681, 1.8281376784986541],
                             [-0.84798254745759138, -3.6864814564967521, -4.1739650240604993, -5.918425503011715, -5.1717677791409313, -2.0335159449318727, -0.84492994574505642, -0.16553536198416638, -1.4870351761319909, -6.8737310923685619, -3.3321048296620761, -3.0187480812722329, 4.4925661173005702, 3.7755435182948531, -1.6722863297535835, -1.2253743731781905, -0.79519843774949128, -5.4103193153590974, 1.1199015438869793, -2.3516733706447974, -0.52639106616810394, -0.94792309687668086, -1.1686496722912607, 0.25499572752033817, -0.65806880915089805, -0.72958046694123579, 4.4714393999201754, -1.6213907719003973, 3.2060950745879033, 3.4848313157612174, 0.28152661904753518, 1.692937172493558, 0.56638843942516526, -4.3591042415548724, 1.0356125511136431, 1.3339866404258409, -0.59344824220103365, 4.1615352310191112, -3.6287819635157073, -0.13485864866701974, 1.2135606366671059, 4.41774553932422, -1.3134853549957339, -2.8212606461517225, 3.5755065875694303, -2.0104546518531188, -1.376126973163637, 0.29667669534767882, 0.2154696360039044, 1.1783084195971121],
                             [-2.4656440660571453, -1.0805395294562314, 3.8893601582365469, -0.68085736308950584, -2.0134774494343701, 2.0625080706108379, -0.41429065398873155, -0.055271500831248641, -2.1892266718596964, -4.9195836751960851, -1.8443167044881297, -0.048683440819584221, -1.1802329295238274, 4.0805839817360612, -0.45621061438063681, 1.0921070834548057, -5.0473611436144052, -1.0613710782529746, -1.0353729809127061, -2.9396270436455136, -0.18602400190428697, 1.9661513169173015, 1.262041886562886, -4.0654357318215828, 1.0948020810708787, -5.775897342027223, 1.2137625467025206, -2.184034721837202, -1.4840272396016114, -0.72635772218919525, 5.0168247154404222, -0.34261550937244933, -2.5275617746057804, -0.31317204463916526, 0.37162992580132115, -0.90165021295228687, -0.43896020903103117, 0.84613456983926849, -0.48967444531135601, 5.4794289344290776, 1.0852417631773013, 0.47164172908221419, 0.33888021251641581, -0.20250924014649488, 0.73174924920258366, -2.2625370917638459, -1.6151706236249606, 0.76767225002164596, -1.2355761960629059, 1.5676752116332888],
                             [1.5817198773861487, -2.374792520571452, -3.2401649161191592, -1.2776536175234443, -2.7400836968960567, 0.8714354027532768, 4.9507877422848336, -1.6501565148644868, 1.1265597146025403, 0.79282606162565861, 0.82119368078876043, -0.55170866171993782, -0.61863571523527772, 1.8718092797235448, 0.97121453717605188, -6.458061710710723, 1.1882474029273518, -2.9965374225913135, 0.84097942367709844, -2.7298755888741781, -0.38379910212725504, -3.6899837779551037, 0.097537670404543753, -1.5096309914251156, -7.236373056333397, 1.48090268136345, 2.4106505943954546, -1.9722687927855456, -0.94637447571686373, -1.2279626227076033, 0.54145213654719304, 1.285857395410495, 1.3748826676259476, 0.66758850389844415, -1.5857457687923791, -0.30692745407984723, 3.188910759957897, 0.64563799576764869, 1.5819105957446797, 0.98832259375412612, -1.6612883236189491, 4.7322730877903432, 0.43994512667699676, -2.697052882248391, -1.8122406804853166, -0.86578139294676237, -0.079263944542231429, 0.81865557941957312, -0.07216836491033278, 1.0757122901092608],
                             [-3.1747544077172356, -0.083338122403079112, -1.464314878173459, 1.2624039155159714, 0.9873790943266999, -1.6885820891243288, 0.14510829463915581, 0.043082842291779215, 0.21098833768309244, 1.9229608974085961, 1.8611265785933755, 0.9083828897213384, -1.5142727016025712, -1.2018986392534075, -4.4768739433846019, -0.6543251754023609, -1.6597610310602819, 2.4205572351063007, -0.24426242625032155, -0.3425445770935589, -2.4305396001753974, -1.9360239757254167, -1.4556712343037395, 4.2542439297070906, -0.39301662735207021, -2.7552704322412129, -1.4744440638899721, 3.0947913521916988, -4.0716352594680814, -0.39520157355340585, -0.32203991727288123, -0.35616021407056958, 3.6054150604339728, -3.3171142175138981, 2.6262764346813769, -3.1104009071079171, 0.90014523726690043, -0.50025410517518876, -0.01887472916814651, 0.35884257116963553, 0.16728299125229437, 1.5907229439010988, 3.6894704082087273, -0.57553301343620544, 1.4131610355605981, 0.57299828675182019, -0.057303816839538071, -0.006527867325958666, -2.048382602776377, 0.05429732079562203],
                             [-1.0306293244407558, 0.0171951346260985, -0.38141019400997633, 1.6696801842234035, 0.030910268310348661, 2.0682053431901939, 1.3793924880019042, 0.18875366586738035, -2.9638970341023563, -1.2221400278570693, 0.79484370026236961, 4.5189538591847684, -2.7072470497161096, -1.6616527172399416, 0.26783896677390634, -1.8876255926227272, -1.4081006964271063, -0.43226368127604164, -4.7873489492261827, 0.85213672366190873, 2.8486663213366379, 0.96548322017773525, 0.75596951592019468, -0.54907565344420917, 1.1648304087855563, 0.70703957013187391, -3.4755543732420442, -2.7202351358358752, -2.62421869856168, 2.2678922681786529, -1.6950950218559855, 1.3195629083872675, -1.5212423617000588, -0.28521884816317211, 1.9236422104708633, 0.73146345849693972, -0.1278448464104841, -1.5069858112384527, -2.720346098742378, 2.0890736364676465, 0.12895138020184174, 2.2304740856948326, -0.95259638660503054, 1.274900380566734, -0.34671639333637877, 0.34261635808554491, -1.3966852391966009, -0.0039016634164887182, -4.2764147769991752, -1.4464479047043541],
                             [0.021446325874280768, -2.7327664705926167, 1.247669119086896, -3.8973938732699622, 0.43184246628298328, -4.8787756231636141, -2.3367699338087862, 2.759077851817981, 4.4076303025006363, 3.0772136145820301, -3.5924190208460254, -1.9481761743505692, 1.5121181786561075, 0.48380636731550758, 1.4816239591676685, -2.3501268187544113, -1.1823513951122904, -2.1733552906227143, 1.7281727223381653, -2.9584639280359717, -2.8267005886481065, 0.39776588770825005, -1.875646245020044, 4.3961797234263909, -1.1936757820065098, -0.25501477837270775, 4.0618690031227453, 1.1778199580122362, 0.056251114159842804, -1.2895186735652304, 3.2146666032551305, 2.5084708306820622, 0.021066811992772522, -1.099569069007382, 1.0823193596758029, 1.2928337181888876, -1.621936826717373, 5.4978464632201742, 3.9649746141394315, 0.12087282310590929, 3.1655915104983143, -2.1303314435813596, 4.1340819226438805, -1.3873886590165501, 1.5726845677483894, 1.0098579930564167, -0.046484202435625961, -2.12417523361685, 3.1215573038696496, 2.7237122791260235],
                             [1.3997516638067027, 1.9433277982529475, -3.1790489992943782, -1.2006868046572952, -2.1556658808063962, -0.33579789114199066, 5.3830118761026062, -4.0942238758574137, -1.221511226431339, 0.51668824961724291, -2.3949981978096191, 0.0025309068976966803, 1.911197822954199, 1.3922721380468688, -3.1168930775512114, -0.55006941329956349, 1.1070387949802436, -0.41451503674496798, 1.7440514136895078, -1.5853763810960861, -0.52331343498652905, -3.4664927334960356, -0.35834034928522152, -6.1426827987127464, -3.3214432478663225, 3.1712593506219586, 1.0151540875185514, 2.0306017724497427, 0.16260323615581154, -0.71288421201067154, 0.91373369281418104, -0.82913402131202085, 1.1835376617964728, 1.6543562651969483, -1.9035217992062601, 0.70578353087772561, 1.0147063318576963, -2.867481883107057, 0.74931202121258045, -2.9297169035436008, -3.6907471746394922, 4.4049297301614017, -2.1540886627784057, -0.54912885654823973, 1.4682797588171028, -0.32936226986934808, -2.1719330335803186, 3.6069834978029709, -1.3862717192358167, -0.56698710752571146],
                             [4.6534319058352311, 1.2130054638513188, -0.91802209939257851, -1.3674263890470493, -1.6935425182792543, -6.5644023202085915, 4.0687595392907632, 3.1226405572214193, -3.5277058304743365, 5.2242104024082376, -2.3858642727570949, -1.2386615239991345, 0.70000096856718919, -3.9844585876536982, -3.1113879735792178, -3.3652856427737454, 2.5930661721957287, -1.9618063214625678, -0.87408948194875347, 4.6323874989204157, 2.6547054738484448, -1.6142452296176373, 5.3178377558261598, 0.61388550802444741, -1.235840085699403, 2.5790806453679469, -2.2149117945531982, -5.661861838680009, 3.8988282894629673, -0.52226620616380792, 1.1492549097194482, -0.7382808510754939, 0.5264290001044909, -0.39815390436449788, 0.71387597025040717, 1.2342197510529229, 1.6341717141499155, -2.6226396698599754, -1.410845134127833, 1.0659800240391535, 5.5439588186328725, 1.3908952935870995, 2.9064940426614143, 0.13634277870454659, 2.7874092758545275, 3.5457425757120262, -2.9575996774994651, -6.6589404641801826, 1.1175646374110113, -4.1196744809275252],
                             [0.94349142995528701, 1.6883397985605417, -0.25907699961725805, 0.17456963389441926, -1.4853098705611372, 0.60520027000384846, 1.004948112151707, -0.29203134144043236, 1.6405149528334857, -3.6146845315869411, -0.19656369263041384, -1.5982440511093814, -0.3699964515014208, -0.60566109223744857, 0.80489423156274953, 8.3335736116654147, -1.3906281907142481, 0.35669619235655808, 1.3283623406883596, -3.958090044811966, 2.7646183002364486, 1.0241141780707241, 0.14421952448664913, -0.026712147047296669, 0.71764277993924674, -0.028241252256330226, 3.4373133414029531, 1.0938054598096005, -2.0068110332066249, -0.89859596398838315, -0.089412405991851754, -1.750725418649747, 1.6926697932919477, -2.0568572831534722, 3.8591414434646301, -0.95167247952301326, -2.1405241408006588, 1.6359637601882056, -1.8134683332057353, -0.5638568347224806, -1.9720610197455271, -1.0831800232730153, -2.0253381883904034, -3.0952678820561279, 1.0229772209870003, -1.6917942790383742, 0.11410116028137421, -2.1978911590066561, 1.4134859806790034, -3.6533652679118798],
                             [2.3501169346335486, 2.7279504628081588, -4.0017525901134769, -0.92945006087753579, -2.1728685050879886, -5.4274668442324554, -1.1274713730351218, 0.80137107797373908, 1.060438909054682, 0.19818766707377755, -1.3794452818537895, -1.9235025620599864, -0.0019964022217776184, -4.5548350653949257, -1.8495577547431048, 0.37073874838181053, 4.1623613081914721, 0.77035641680817124, 1.7902479630925683, 4.9087669657436033, 3.2839550809888931, -0.50100735010643471, 1.9434008258575377, -1.0894648679809698, -0.93125570593122009, 1.3039151710570127, -1.7333507851259289, -1.6276693639516191, 2.6363621493286953, 1.4755361375074432, -2.5918390525815105, 0.62787245078454079, 1.9048065962571665, -0.57653647496512672, 0.7283168888973971, 3.1134635691716479, 2.2108501148653117, -2.8595186648103623, -2.7354852874730362, -0.30447484411110309, -1.0062161175414459, 1.166905970511867, 1.5630094824599468, -0.35269204567123963, 4.0949921733519199, 1.9750694719668089, 0.7724945982139062, -0.29642746267429626, 0.60521150048618566, -6.9790299522903672],
                             [-3.1866751821939796, -1.5453844716616645, 3.3168258635645729, 3.2923604921443257, 2.4688591790879837, -1.4977675952496046, -0.89687252600090861, 2.132237810864857, -1.114991602507192, -0.7062498367275174, 3.4979856547195398, 2.1192228336051158, 1.0983746574773514, -0.1052001228948506, -0.70625425944130049, 1.9072716552339484, -3.9472775620642282, 3.9305251282829623, -1.2305070645266816, 2.7069262451708909, -0.47374280926174228, 4.8677939993336556, 0.52950202581925188, -1.6110466293231371, 0.61637798607021188, 0.92807388559754422, -3.3162391472386461, 1.8870813951315875, 1.7643754296926233, 0.71225950296486529, 4.1539749181887737, -1.3387590565346039, -1.5622813846636276, -0.0032278434636938691, -2.1220138501940125, 2.4070738793178186, -0.79263242894305308, 1.3361569835227765, 2.9836889525676877, -1.2790250932902802, 2.6038581965766006, -1.7570018661985258, 2.6243056392449899, -1.0966403543378274, 0.0036311315007506208, -3.8397339692960921, 5.0117065087511756, 1.736870585956092, -0.77680783725353209, 0.98429710455453068],
                             [1.7088830271771209, 1.2855906233048102, -2.9075623846049483, 0.7297242356013921, 2.385914522294208, -0.23421454445042028, -0.55368003620040052, 2.6977424670363779, 4.594327095245303, 4.4427669797724265, 1.0093394640629016, 2.862952408254626, 0.39565102616527936, -0.72162144788415294, -3.1113644013311239, -1.8746027219390113, -0.5872186630720585, 4.003446826286587, -1.0251341953676116, 6.2272029849518233, -0.59017371393628493, 3.0662851922010126, 0.86761155642547749, 1.0261404093187037, 1.2128130217811046, -0.33175564175949057, -1.6535945748466145, 3.8596311992092422, -1.5786993285235684, 1.6507636329537796, -0.61874088664099658, -1.3139384367367373, -1.7445814925554413, 0.83879985059076634, 1.5488180116702239, 2.4253487477405025, 3.253232755251859, -4.6192512831999561, 1.5977258139244341, -1.9131973615909101, -1.0728093059706605, -1.9160787893649767, 2.8451926663149796, 2.365568055861718, 5.7336123563278187, 2.2720088972600272, 4.0097374210097216, 1.0847891522526463, -2.2386186051863541, -5.7196884266674086],
                             [1.8132062365313668, 0.41633104364292317, -2.0141714548755005, -4.8042537307066722, -2.2832942926663486, -1.3956415706134488, -4.1699828828429952, 1.8399116683848855, 0.85204244584770272, 2.4018386669497085, -1.5178604636712618, -0.31698751168615846, -1.9692282943915149, -5.0197540010264294, -0.64282481710989958, 0.18144515190321331, 1.0966057362852173, 0.38542411517713249, 2.1114522792137191, 7.8449331870847159, 1.2955438375005697, 0.49313237377020563, -4.3790075961282522, -0.37007563260245024, 2.0611821645441468, -6.1873601384970556, -1.5811188698675052, -1.7051121211068123, -0.22307889712199028, -0.57281298146461346, 1.4611091217915573, 0.69157881017413048, -0.15735569992267351, 0.95415570485720669, 1.9123027993632449, -3.532722931904547, -3.6371505242708544, -3.9172586655627155, 1.3055136151780942, 1.1944841936327804, 2.8448927411215461, -1.9043364497474229, 3.5022191891699386, -1.1033017491767561, 1.8766140830133, 1.3338582773194017, 0.031512559284829822, -3.94787785114652, -0.36267920636565465, 1.6232977404955209],
                             [5.1174223437843818, -1.4046023596719033, -3.0558831111513856, -4.5660672885867708, -1.1450820153926113, -2.5286021928682549, 0.090356254477181097, 1.5415178524121163, 1.3922608788496942, 5.7254373609938467, -0.29719705514909506, -2.7254460738734783, 0.34438612782975125, -0.91739057190690165, 0.41178912062859435, 0.75769172258415385, -0.32710329621530487, -2.5733096237187927, 3.6725306196909182, 1.4813007980690187, -0.86861727891627027, 0.52677177835986189, 0.10152352403082844, 0.087192131200704737, -4.5846124556999577, 5.732005889215074, 1.4608759946402778, 1.6994126144844788, -0.53295416831367459, 0.41431814777851539, -1.4230800009731583, 0.57984417921908937, 2.6263539788752746, 0.12898337363749873, 3.8703067573013481, 2.3071496033872942, -2.6433707071105292, 2.1004948421925773, 1.8861255110744892, -3.2375969107956273, 4.4898268189644286, 1.7991217541757984, 2.9549027502564424, -4.9596302951970506, 0.018550305616560937, -0.19947347957918155, 2.0290220501502376, -3.8266339166632508, 1.1480160659756979, -1.9773831599775762],
                             [-3.8160356372336763, 4.4971396869455322, 0.030123063177022128, -2.2719041576873433, -1.873658476757011, -0.90660591992886064, -0.12564772656583731, -1.8471902035236099, -2.0097909183879796, -6.6636040079785142, -4.715174726543232, 2.2517239506447635, -1.1003775028590237, 1.2809055217353322, -4.0481002440121996, 2.705965182482351, -3.2834305098965815, 3.9324362607837524, -2.0158641928601546, 3.7091390726704616, -3.0015434862912178, 4.9001371973686476, 0.71883131217848462, -1.5820204775111106, 5.7194691591798739, -0.50864291475432721, -2.8729752006796829, -1.9369687205792028, 0.47151069390527717, 1.7156017327660604, 3.6970125690182054, 2.4755004952938511, -1.7205648509164038, -0.47160582545100543, -0.33053766646983374, 3.0610320041210897, -1.1093405064685185, -3.8424204533959108, -1.6068077985133222, -3.3044087933706452, 2.3630439118518489, 0.90979345492635122, -2.1796508660071479, 3.1648430240179848, 2.3633354944707712, 0.86328667287360017, 2.2120434659932529, 1.6670356321464126, -4.4799790355872169, -1.9576014485918991],
                             [3.7326737914184211, 3.6130759012208227, -0.46215369088847952, -2.6904373265216188, -6.2030243626131796, -4.2124942038138409, 4.3569907750719716, -1.4083786662574216, -1.3743809148106527, 9.6345785223816254, -4.7409669717591907, -1.1085123702528816, -1.7573719968419357, -3.2832550693904108, -4.8692294692129376, -3.3566214600954436, 4.9598141715850579, -1.2392905604694633, 5.2557401514098219, 1.9584096607793189, -0.64367007539525523, -3.2046938652011616, 0.72182261907194534, 0.38385007775202429, -6.3162559323498542, -0.76543442976529452, 0.081233190527823421, -0.69044505994797301, -0.98344917216820993, -1.70368031890835, 5.1511023934495457, -2.2186313708420733, 1.4168939215613452, 2.0152560000584212, 4.7108429768809907, -1.7553740741216859, 0.063493804151159877, 0.37056162233831497, 2.895271726205757, 0.73210097344281189, 2.9684210834837002, -1.6388237492620228, 3.8257196325155189, 0.30783886531837118, 4.188309433689863, 5.7544277358455398, -1.7407705199924683, -7.9074259200773245, -5.4852031118663653, 1.5312486217427008],
                             [-2.1355644327910097, -2.9631914551169283, -0.03579349911030319, -3.020639453908279, -1.6728915037206871, -0.94741200601968723, -5.3262793897253511, 0.85589080098670278, -0.23196604822484335, -0.63144651816575659, -1.1528635758389163, -2.3538332200749688, -0.75335045099251796, -1.9166830184940844, -2.1932670719826564, -1.9865854723309653, -0.44670309764868665, -3.7178774893269266, 1.0997588273687213, 0.17789710081904753, -1.5525350848212975, 0.64191971632954459, -1.3895502605608947, 1.8977678790604939, 2.4534079690210056, -7.7583337775611634, -1.4410288652245538, -2.870748548085384, -2.3808007389276735, 1.1386765495557585, 1.0177734475267481, -0.1579320889023044, 0.68290667650733705, -2.1647499921608571, 1.714048920033383, -6.2334464861553478, -0.228332593603254, 0.94410171907511664, -3.9407456537960166, 2.229013841848412, -0.17526165635454297, -0.93909176047139975, 0.63683884239184529, 0.77642426566122502, 1.9796998000902977, 0.39254730495959717, -2.3061402812332714, -1.9838879154184499, -0.86975887538600771, 1.1694671560779655],
                             [-0.061303395755089835, 0.51564868820700493, 0.40202954620027254, -1.1155880058006049, 4.7528363895863581, 1.6876998356152197, 0.86061112656939265, 2.802066519890114, -3.0038373098904527, 1.8358084774069097, -0.73861769651767384, 2.335697757341479, 0.75798929834718098, -0.5883280326634106, -3.3067403704048335, 5.062248722966233, -0.2794501887294224, 5.8797224216780597, -3.4722213861694913, -1.7692179190889175, 0.54889206710314664, 5.2708756218290533, -0.14196402615379866, 2.7643713102216667, 2.6875466115593523, -0.4737587179208903, -4.4419556562813955, -1.0273134779697632, -1.2865960815766897, 5.6375532082079447, -4.8491746904193889, 1.5607771918850315, 1.6439055587371882, -1.8318966589235657, -0.2330580644699547, 1.1155882630294438, -2.1663206196376432, -1.434939530700958, 0.71843260581928137, -3.5127317483798848, -0.89074106406808251, 3.0532864625109157, -5.0864819133547776, -1.906829426081583, 1.3081029545196556, -4.5900678722968244, 1.6323326484037006, -2.0616204475669786, -5.6602395892783788, 3.6638457836380738],
                             [1.3547540327186915, 0.38157044478950852, -1.4344518939029409, -1.0851245670666667, 1.3472591004218026, 0.84778592540118514, 1.3482342908473426, 3.6734896331321369, -2.5250686177131172, -0.85426330326231836, 5.6787648602768037, 1.8761496301845555, 0.66288600769762807, -0.1333775899095869, 3.0160555503188253, 0.64985311796914258, -0.50713081412178163, 2.7370901310511475, -3.1640016750673761, 3.3544031951571553, -1.0218882940798069, 3.7422606274792489, 2.3451732191670192, 2.2613737119122286, 2.2263262434247966, 6.5983579323588337, -3.8960332843834093, 0.14125585737193591, -0.7972014179664072, 2.708181067033014, -4.5913757768425549, -1.0452701051540318, -0.104666992120929, 1.5378024692535968, 1.0091470206863413, 0.19330598811273544, -0.43005422512218255, -1.0097356830637252, -3.6386338765103625, -2.8993103512344978, 0.27580752085300608, 5.1210510536151475, 0.83148063250501325, -3.2354252492733724, -1.0074825033441035, -1.3498100554251664, -1.8650515233745926, 0.044330580175525006, 1.6892838540739952, -1.2289165366934152],
                             [-2.3991073940741794, 1.7360522118514543, -1.0376729703270544, 1.7647889227895892, -3.0868576144400679, 3.83449123007229, -1.5798120698878306, -1.0665802037010077, 1.3179530880811878, -5.0036042085958252, -5.771669055911242, 0.30247526770345662, 2.9368205359824144, 1.3148932482972975, 0.14260016375072354, 4.128786110898071, 1.4530929174061626, -2.3115299307081969, -0.015811196582827543, -2.4980797777580115, 0.7434774671880976, 0.038673439374493759, -2.8566600119534016, -0.40090477447097489, 3.9174091724205518, -0.82119056916348643, 3.6776684315862807, 0.179474161339397, -3.435920406736257, -0.56883631006152102, 2.4958369026220626, 0.46025989856966576, -2.7319450597101969, 1.3682487377531587, 0.11130744311620569, -1.0786437755869647, -0.86674674824722775, 1.4100975407837049, -2.1825338616165855, -0.28829701879954067, 2.0108710464032034, 0.72205396645479136, -2.3692023559962738, 1.8732887797699593, 0.7700788467876285, 1.4206813227444461, 2.1324126504055521, -0.0092042065213927965, 1.4984151142911519, -0.31641085746951281],
                             [-1.5977504802975599, 0.48363520427888751, 2.2866581492455125, 1.1261669405018817, 3.0986210468233577, 0.034347362392913638, -2.7438971989048295, 1.9509964116195599, -4.7719473912689923, 1.6743637483641254, -2.020756486291643, 1.4841271820262723, -0.93497498632137876, -3.8709588625978939, -1.621903787232005, 0.14723810547677613, 0.493935330019312, 4.0240563663140696, -1.9095725035734534, -1.7100798586836934, 0.0035213524171290589, 4.3077636722829764, -3.8413850521846395, 3.1654495676241052, 4.0310809031902606, -2.4946271680661201, -3.0835963012558603, -4.6893324625983723, 0.30145054821260436, 2.3469406913741437, -2.8727531629450827, 1.9893056759024328, -1.1346029789834704, 2.1194051301479777, 1.8505900437548992, 0.047854661979016944, -1.369646015571411, 2.0327911667023204, 0.65775883084382381, 0.24945644551567359, 5.2389485935039346, -2.7226522079820241, -0.70961951166666615, -0.86744616075094716, -3.7382673562925888, 0.45483785518183589, 1.2546999142786361, -5.3345501020595805, -4.9856204533196289, 2.8534964691755831],
                             [0.65777792250808287, 1.8639498758199242, 1.7669101587293194, -1.1431451216721855, 3.015588327593556, -3.3706081679634665, 1.1464738665914143, 4.0275087025201541, 1.0743138951322837, 3.8827868254740827, -3.5686725425206953, 0.23252094641242982, -0.85594699758450898, -0.48635947340835856, -1.383092166120516, -2.0377947044376303, -4.1718392951602494, 3.0148974029178337, -2.0214283588130524, 3.5622325427007806, -3.3370354617886933, 5.9903883566074914, 1.3337188781078564, 1.9807347977059664, 1.2864025843704532, 0.063346909224556783, -2.9095863224558913, -1.2139746566237186, 1.6418880867839958, 2.6463442158492718, 1.8856019239182438, -0.60791217951424914, -0.41147424620544187, 1.6621778973148367, -2.4090909529515914, 3.5501983227118781, 0.16073879555667431, 1.2068719258481875, 4.7321076649799299, -2.1108560843186055, 4.0716231627788471, -0.37558462546109289, 1.959715986484768, 0.79024664309767556, 2.2003900646225092, -0.1699618122743648, 4.5776035587851576, -0.38305591582050036, -1.8301001363413767, -3.4094536910770694],
                             [4.4852538945159157, -0.031281234514690108, -1.9868556702101872, -1.2565165457697633, 0.06390187801762312, -2.7991584837059391, 6.0621372910119193, 0.30045988631608112, 0.21379249775072898, 1.0147797805822354, 5.0672528735956162, 1.0507790801778525, 0.62854772764724598, -0.47456056327717921, -2.1238902676103666, 0.99836517755493825, 1.7689344129723221, 3.6989908240464162, -1.0358031709991118, 3.4750722069659288, -0.0066572084352951814, 5.0436410490670438, 4.7477239364735642, -4.8077121130554525, 1.0299417147989929, 6.5875101661495394, -3.2987541625691512, 0.51538015884132538, -3.2019729234438619, 1.1652521294138445, 0.82802074616738119, -2.9051733036301766, 3.4860657136021223, 0.88134999215767018, -2.2486478408762713, 3.1420546762382946, -0.1049926428971087, -4.4949235558758165, -0.89174516256247771, -4.3307406725278756, -1.7637955174513935, 5.0395269755851793, 0.44481962819800891, 0.061836457916667961, 2.8871758261113896, -0.83235074760065852, 1.2121891586619342, -1.0731348776024114, -0.50194753165331085, -4.3226710544381559],
                             [-2.0462837021777487, -0.3543029623092685, -1.2084614701992435, -1.2500011559216364, -2.6402403040204128, -5.8761786886196283, 0.24695156999962231, -2.2929239352448003, 0.12685574621054546, -2.6010605717309008, -0.89455248063137205, -0.45989005823022583, 3.5337463980191308, 2.5012080225143762, -7.376132927862951, 1.667827939869772, 2.0338412377829633, 1.6797736225273461, 1.4958958315894064, 0.86092159456117878, 1.0894987635145768, 0.047290082579024111, 0.454112111954591, -3.2364595238363156, 0.5787179568987102, -0.78480272151477393, -0.77701016550408442, 1.820457654991616, 1.1383972278482088, -1.1875893113561522, 3.0767315594122664, -0.39193824307980357, 0.97218128033557316, -3.7488470352092547, 3.6710568913743069, 0.8122782302144812, -3.3201174377422009, -2.5948287247037132, -0.35901505421605084, -0.27393351873983274, 1.6512421640776445, 1.9244244149220699, 2.8071678678784342, 0.9327161871191223, 5.1998785914263337, 0.16602638116818624, 0.10257472592990341, 1.0574217030514468, -0.91187303628456284, -0.89077482892733995],
                             [-0.041728575541221766, -2.7873596310900077, -0.065268488840185893, -0.31519261539540899, 0.074815628478645396, 4.0363765051623108, 0.49271606386771183, 0.78163538208843564, -1.3050887437452821, -5.3226320809340173, -0.94012983425086949, -0.64779020480682969, 1.0850648887431202, 1.2903578949037473, 0.19768892429631066, -0.30304939955825777, 0.57099074883914769, -1.7549258391325455, -3.8327095855066924, -1.9053424378099391, 1.6191821482543096, 0.39302112380839382, -0.4985732929879515, -1.5086558658189493, 3.9936572966585722, -1.9861461582653115, 0.56353972659031526, -1.6051292114364026, 0.61805214412860199, 2.0370257100057256, -0.98498857932123729, -0.76383105150817943, -0.13646535691068934, -1.2198185159786481, -1.8440222789436094, 1.9870542908453419, -0.67557096012684459, 2.1073675835739225, -3.5634827576373365, 2.6581322848819084, -0.93326139256721963, 1.5920508893584195, -3.9480875085559006, -0.14619845197596418, -2.1354228731575504, -0.95268944506642073, -2.335263581841811, 0.69701159530412038, -0.45638618882222459, 1.5439945941919819],
                             [-0.073660776078418477, 0.36941330186210042, -0.014955759309850901, 3.2988048020816856, -1.305683386614936, 1.1070493000521615, -2.0939861218205675, 2.234104497223973, -2.1661160212994113, -1.7392103291747683, 2.2083579450040105, 1.0140581146774921, -0.31594049421141573, -1.5031883577693204, 1.6011326455482717, 1.3338710530230413, -1.6799944929420541, 1.4132476331604402, -2.692634112987045, -1.54202870675502, 0.50603525143171579, 5.244380760108398, -0.64756806009119983, -3.2987679832191703, 1.5025651380619511, -2.5877674055491573, 0.35140196885796032, -2.0569131774924609, 0.22393619571942475, 1.6562884974274068, -1.4177258399301407, -0.83029148142894182, -0.76838017676779802, 0.19379146348476395, 0.96582232684079428, 0.98955746142806955, 1.3651966867285625, 3.0346208261046215, -1.6731410929265662, 0.60959971687539405, 1.0271925197144578, -2.7194174095724115, -1.3366420780637385, -1.8164301841266843, -2.9427807310462075, -1.6102312659042015, 2.2302584116276392, -2.8089086414860156, -1.284953641507308, -1.3370030199736382]],
                            [[-0.19626094082270906, 2.7269898182872216, -1.8471841019084703, 0.16407339128395654, -3.3437222873596699, -0.090574032016304692, 0.12276713415114118, 6.4639276757507957, 1.4275297961001752, 1.049001173477319, -0.84278397430779572, -3.3448917994294973, -3.172299793063885, 1.6208995502901948, 1.5121552682542638, 4.2553048797777322, -5.7482051946877721, -4.2907796671493985, 5.3925898960619767, -3.7093297876554709, 2.5850336736446251, 1.5222671253504234, 0.66502501101820144, -0.947395644246109, -5.4181221183976804, 4.2925779188072761, 0.12636929081922477, -1.3203221005108365, -4.0308658968437303, 6.4463868675497018, 5.0734990890145371, 4.7234722173442538, -4.3917065673712345, -0.25057347472488972, 3.0100164377474741, -7.2746364684622042, -0.4292371602311118, -3.3861484210223569, 1.4051466000097113, 4.1186427103475065, 1.3646744040420418, -2.2673313334653002, -4.8571332658007949, -3.3343720118374938, 2.4696332590086048, 8.369985498542917, 2.6516249330789026, 1.9154644550109134, 0.55067238428521026, 3.1122005670917692],
                             [1.3374794133537964, -4.0731059473596654, 5.6140714068348165, 2.7926951378153024, 1.4887507227936296, -2.399491221206977, 0.73614799320946411, 10.39617476099002, 8.244733688081034, 1.6297053741662462, 2.8432815144702936, 4.9034769401721929, -3.9647771628203565, -0.40869125448478127, -5.0243283831453018, 7.1510728485535946, 3.4078376870681075, 3.3058902335783529, 7.0200489489145896, 8.6314629060705954, 3.6099819531240644, 3.9135432926686358, 4.224060587312386, 0.88218355713265817, -5.3490189564540502, 0.82452101346190765, -9.6714648502185838, -1.4666244063772995, -9.1972676572542138, 0.26243526500171888, -2.5253656307881505, 4.2035739274710799, 6.8247618293445118, -5.0655493797423423, -3.4995713363437835, -0.64718569093817524, 4.6582972585488349, 3.5002110528395796, -0.30418111378956109, 2.9953164228838678, 8.3290160582348243, -7.9401798148278449, -0.09288896536694688, 6.6520977201227227, 3.6314100493229153, -4.6975218021838536, 3.8627219178483236, 3.3012324844904652, 3.666865299767053, 3.5540471221172987],
                             [0.8013885036328533, -2.1682586714594159, 7.000131241970335, 1.0838213595579842, -4.9551529282640407, -0.48133314307466246, -2.5960443786310385, 3.8915813080013946, 10.364934148080456, 3.0524275035271504, 5.1193980797136307, -4.3540016505082866, 4.2634616386251656, -9.5375712942252466, -9.2874713930144424, -2.013753445377934, -3.792685940174819, -2.7498500575605194, 3.766346443459446, 4.3576471822103171, 2.3589961399629784, -2.3952749417415902, 7.5645270080167437, 7.8482820104739126, -5.4588161995100855, 3.7437207703259858, -5.5881147660037724, 5.9353431813508966, 2.050033350098754, 2.9945789903914997, 0.20126735196215836, 6.0389089536654295, -3.0716283425450293, -1.6998096345493952, -3.1341721659012087, 0.3227492195974605, 3.3448372533017179, 4.1925588599141435, -0.1794066334586184, 6.627346865610046, -0.27775521117769647, -3.6286287672141841, -2.0355541562908908, -3.0052770368911457, 2.0922748034017489, 4.3425323927087787, 7.7489600683047657, -1.6773346106787783, 1.287819145360722, -10.961938104957303],
                             [-0.086731167322425876, 3.7598753622269108, 1.7696189667429121, 1.363936940622507, -5.9866880470628514, -1.65349041028902, 0.32434133147851685, -1.6150515330178761, 6.6954976032302307, 0.093225082233239318, 3.8192490017918863, 5.501866000940888, 4.0592965696339052, -3.6818568427808498, 0.82130007808309358, 0.26457583337208285, 0.45322215279505046, -4.9855527460079001, 2.7505849305658785, 3.3907653544573475, -6.8073647156628105, 4.5269654425708259, -2.2229316345081451, -7.4007142129046031, -2.084948805225971, 4.5847714310062404, 5.0110949863082679, -3.204515370423354, 6.9619492097052653, 5.0539457421626688, 0.65504175739281278, 3.0234671470338195, 2.2609942584517304, -6.7600977383363334, -1.8020658888690282, -4.0419376584598057, 5.768921007055412, 1.3582120259587518, 4.6475885236971566, 2.6123930549364709, 2.3318649848211428, -4.0105534661433282, -2.0330843276259283, 2.4619455148867719, 4.1346107436818045, -2.030098163653379, -0.66724057622667543, -3.1648990058815789, -1.5135897812165646, -2.1785408354421154],
                             [-9.6623139910260676, 1.7050154453794515, -4.2909594151779435, 7.1823434237724566, 0.13134031329485538, 0.94550784548705835, 0.020384365286023332, 3.202084665985176, 4.6108375046750707, 4.9982067085010877, -7.911550744386906, 0.23875468336126049, -4.119696371502795, 0.86836275070885116, 2.1012757909061763, 4.6878540147433414, 0.82596414033409649, 5.1842199034511633, -9.2541096957363234, -1.0461195435964792, 0.43094456510177492, -3.6280403238317094, -4.2487020469988348, -6.6521989088468123, 0.22416645451887746, 4.0327609921671606, -4.7482259135208951, -10.913997736680582, -0.05390464888364959, -2.6832451921499878, -0.939848554218218, -2.4628990664962012, 0.05225214152405544, -2.9362593247782689, -0.59058322986512701, 0.94690431316822032, 0.48320434551069841, 3.4066568563051414, -5.6186302822482981, 1.4301174683028848, -4.1605102740991144, -5.8323107448112754, 3.8548469716878309, 13.598754456637451, 7.9685146379093164, -2.5177130399874015, -2.2165152797999257, 11.872429714981676, -5.560933078241229, 12.304031567026097],
                             [3.7933873836437768, -2.1732866055004649, 5.1388809577021304, 8.7694478424531273, -5.4976883261801097, -7.9840980017446759, 1.4777113372763635, -0.34893313949296212, -1.2021965681602078, 2.5615077034911606, 1.9947728988382607, 4.1012082602265618, -4.2851367597571652, 5.3247804407480048, -1.0032200731595236, 1.7900121354225744, 6.5714453865870626, 11.128328744934981, 5.2729640427676792, 0.082786186711089671, 2.9068882174380959, 3.8212686043438739, 1.1926700793205542, -8.2260539434465407, 2.2110905832753849, -5.1660148421316965, 9.9270398998884168, 5.159457765687355, -7.3346751600877189, -0.2501381229205325, -4.9800648423044649, -0.10154990904003268, 10.253731588007673, 2.1212168812141803, 2.9525404534484272, -6.7060032664717584, 5.2286993394900669, -3.1674261206539271, 3.5007143004160541, -2.0758871296975356, 6.4324656843563188, -1.2960268120632426, -3.1343471527684197, -0.10591124254525544, 6.195022548098426, -6.8496720296109919, -9.615061029010727, -2.1049775735832301, 7.5703501692263808, 6.2559489347319417],
                             [1.8455941160945619, 4.1024745579937054, -1.5979620304683961, 2.1199122560896626, 2.7620136260381436, 0.15114848468097111, -1.9380791286354664, 4.9498726806373456, -0.32531195655337997, 3.3920018622569699, 3.9046792649870308, -7.5886972316085712, -5.6744605986032619, 1.498752956143764, -0.48835220963303932, -1.0204699779395583, -6.381940474869312, -0.049160271807835873, 4.5554650228615818, -0.11771070849356315, 7.0476506182686434, -4.6877358440248837, 3.6299928034298419, 1.4743519455181879, -8.1445256011561042, -0.88813217355700791, -3.8574478089749529, -4.5356009291419941, -4.9205837079134573, -5.9422391608221234, 0.64311339030597747, -7.59800357575324, -6.4893373170708912, 2.004808485969825, 3.2025430390158358, 2.9458066603736892, 0.62045650225362847, 4.5340736137295146, -3.7572995915911491, 4.2151198383739699, -8.9542607795533353, -1.8433265687101803, 1.1588247622554024, 3.5857454414762309, 0.27046957637958735, -1.8540745173557169, -0.56662204570515173, 4.5280172168883004, -1.1952327887118117, 3.8428242711883094],
                             [-4.345244513253288, 2.0910866131355506, -0.28694954683638663, 1.4693563314404363, 1.3631907232223395, 2.0339717365939554, -0.39489243953762604, 1.0095063990938409, 2.3441174520851473, 2.9097285286996368, 0.19491785300632875, 1.7561258524111911, -1.8233432741677607, -2.2813898976217053, 2.8574618832447372, 4.0047659108635356, -0.42510241844446783, -6.032586882504221, 2.1315919345664511, -2.5706935509578943, -7.3977309508446041, 1.9655894713927962, -5.9953760813982457, 2.0813817325489863, -0.90966090383569254, 4.7207161609308423, 1.3884792006820041, -5.748310003518041, 10.417471098518423, -0.0058223888182968205, 1.7329749707480289, 4.9469078148884016, -1.750567889938105, -6.4738199308084701, -4.0191191287662642, 0.85108428063162589, -4.9170569311807419, 6.021117992844137, -1.2592143491384529, 1.0227892369533806, -4.6343622700925167, -3.1603893750484806, -1.3170997320060489, -2.3789402198881162, -3.2984176597498376, -0.66289579999616344, 0.24662109294716741, 5.7943324940273806, -3.2655048833095877, 0.24034074635762934],
                             [-3.6993010004826523, 2.4710480809695152, -0.14926821775231194, 0.075146120888564677, 3.7815004733123798, 0.8291649606746917, 2.678573019679158, 6.1206896420144119, 11.978630386627481, 4.6013419221984329, -7.249235177690653, 7.2811380015829803, -2.4750922699838305, -4.9612797328029146, -7.1639850823989253, 3.3035215832563756, 4.6475227108397128, 7.9706053932185865, -7.1313498289464583, 10.740551825937272, -3.3317027708358795, -5.2326728438795875, -1.3344798733693828, -0.89560682846243833, 3.9060185614747618, 2.8812637485093497, -3.4472943781493179, -7.9984600539894055, 2.8114029374603726, 0.2434913573628372, -5.0085284945343869, -1.5227770431418031, 9.3559504378280369, -1.5003810000481015, -2.3776637458916876, 4.616557529455501, 7.3988836669426021, 0.78225092915857353, -3.5987767883353805, 3.8295534302445291, 2.096103057876177, -3.2298027953854942, 6.8052792959708643, 19.411953277192467, 7.3600609201821126, -11.65716737670857, -5.1391483955596957, 11.130341267462532, 0.50325979037947721, 9.3835627911094832],
                             [6.4187047623813704, -0.70208353835309489, -4.2144041685601845, -4.0887571294171705, 0.73165142109837777, -3.8762910927090086, -3.1133300584724348, 4.787693105343009, -2.6328102957792496, -2.1653852636618645, -1.3063213992692653, -7.3152306594990151, -0.080498245550803343, 6.3835716849821527, 5.764202217365554, -2.3056333768618598, -2.642360867198883, 4.1627284628231767, -1.1130813157632757, -0.10408465014338689, 7.8170139007551205, -0.14996947893688278, -11.893966003563857, 3.8608495077641307, -1.3833163975869502, -10.615579044742159, -9.7409911704876002, 1.4476812711003304, -5.7519316028933787, -7.3453985463966811, 6.9445484144361656, -5.5652821453741126, -5.8738993538929662, -2.4690377117870268, -1.3027887467992822, -4.881858283965304, -5.7118653390573648, 4.2699138996650996, -0.95938433725466665, -4.6255931559071612, -7.5431442168888978, -1.9964504349507153, -1.5607343382370127, -1.7006594672279238, -5.2021875083062712, 4.3933787246876426, 4.3444856324360472, 2.8658243446687157, -5.7671508291662876, -5.1059441366620577],
                             [-1.7403596708375533, 0.1017937098971899, -6.8860064637354359, -12.376501526036254, 2.7191631583411926, 0.48381369935728979, 5.6511186799429307, 1.8565645713407828, 0.47865381352200925, -1.6826213252495765, -6.0578030619300396, 3.8760794749025886, -0.79442143178114222, -6.494387750070743, -4.0640245846933913, 5.2852654945344213, 8.2407379797149005, 6.5113476993549675, -9.8797918041572999, 3.7833006326880119, 2.357147565637848, -1.6189199220790118, 5.9140247476818146, -0.67220101075843419, 7.4271206133736714, 3.8266691722608619, -3.2319255615610967, 2.2957414475915678, 6.5791023976674303, 3.5102198478102782, 5.8733066667040479, 6.4000526094491326, -2.5429393670903089, 2.148026222096318, -3.3591325878894485, 7.5987558966139384, -0.69841585314869281, 0.56448703337261208, -3.7807717826336495, 0.13590667433041639, 1.0011834024955149, 2.6640171953844627, 1.7849231108024639, -6.6920667283207385, -1.927423692609336, 1.7867879063069319, -0.41425755686733595, 1.4322499437535745, 2.2395552985383289, 1.4370715102513074],
                             [9.6409039344587377, -4.7070786652680949, -2.6580426847143266, -4.9767284184545177, -1.4293872721771719, -1.5998699984112315, -1.587151795684655, 6.1451582367708131, -4.9424753538610782, 2.408732725142265, 2.2802557996676023, -10.857781027987889, -0.49315992088810295, 6.0377226364843724, 3.4463786307257376, 0.82248213970003425, -1.7548879560576489, 1.9715640152877381, 4.0333984226582791, 0.61987245022212634, 4.839679490097101, 1.7186907338387749, -3.8826596747220941, -2.2752484989255781, 1.0555568535486919, -1.4823501925154485, -1.7620251603312, -5.3679250060170602, 3.3949524989893094, -2.4063824685473016, 8.9871480922459455, -1.1818455413335112, 0.80993303463453903, 8.3858064559454544, -2.1443627953772664, -2.8736041523097691, -7.3336154056604919, 1.7870459949278916, 3.771843287240086, -1.0569434049487556, -4.3932882889394493, 6.6870226058064182, 7.0503894620750795, -1.4941284995419182, -2.8084182207041035, -1.0474462136833382, -1.4010782107880031, 3.267232601068081, -7.9268014490176943, -3.0794865612641749],
                             [5.7908272367110047, -0.70992382401239817, -2.6421086899283708, -6.6415888172352702, -2.9023187855846437, 0.22261001957623422, 2.8639916420568841, -1.1196102168754489, -1.6284372495281341, -2.7082861146566959, -2.2480971550333391, -5.155517842701097, -1.5777756996767496, -1.8983146075572392, -0.96489107324312862, -2.9525181904760007, 2.1921511385971573, 0.91053135263985741, -1.2837624563696826, 0.64485788027470548, 3.4593004644615299, 1.7877530426476507, 2.5666309001640917, -4.451049019625084, 3.9989986115413525, 2.5488972005188879, 4.0378277170206207, 0.6187171041357411, 2.0411211538355558, 2.2977614932733137, 6.3633935826702066, 2.7609912786406734, 0.281254896541896, 4.3756550033440194, 1.6534284113216269, -2.2199055215668357, 0.77820144738955865, -3.0935247722397055, 1.2972950079709273, 1.5129739095693935, 1.5358905966591296, 0.11645946642589823, 3.1992798066331978, -5.2970786818053837, -1.0323762239654388, -0.64442270630216181, -2.4047930240894089, -4.2489304374424091, 0.63287196820172387, -0.31151760643569959],
                             [-0.14821555839750175, 7.1323014560264344, -5.2875456751915531, -9.2949264071805935, 2.1722560395290929, -1.8330077440793104, 5.6827912365615072, -2.5856960714288513, 5.5489571915494551, 4.8513251943859848, -3.1170024037002331, 1.8910574450591122, -1.0844197702996261, -4.207171400080024, -6.1551496258229044, 4.5584967975592727, 7.2089274425004328, -1.5710867230379124, -6.4000545274970273, 1.6924944416151784, -0.22081798569160926, -4.7632172780782769, 9.1733015691920503, -3.8001651258815174, -1.1186928627958614, 3.9940824444176668, -4.2745754513472223, -1.2464692815844982, 7.7511756920892436, 2.1747258462593826, 2.4241280050846234, 4.2993305913088378, -9.5006806480596122, 0.96683570144010034, -0.07957043476376445, 7.8250956276134955, 8.5914107473334429, 1.3166500214265795, -8.7072121259165485, 2.7754723233731031, -2.0849107060917715, 0.48789770370176172, 1.5035235102610676, -4.4534488478175174, 1.8952420182773404, 2.3051728667566738, 2.3153054013780281, 1.4512618863345266, 6.5552174972619142, 3.5033532400632867],
                             [-1.9872491040754363, 2.0610229083694369, 0.046440789867259677, 1.5240605749626697, 2.4042096189581641, -0.64154004517392937, -1.4995788990781931, -6.6852359759936286, -1.6086709927593743, -5.2157472634210222, -1.9803363147950415, -0.82879163730533922, 1.7530119462159783, -4.2530078420273734, -0.50975865210529658, -3.9691534414942122, -4.0856129027210217, -1.01350860335723, -6.5244092240574378, 1.3143939833187104, 1.2132380056231125, -0.87294457338275655, -3.532992812290102, -4.3443034748050406, 0.54310585504493114, -3.2186677964146786, 0.67834183421201277, -0.96024510001582641, 2.6439250791966327, -0.22358397720291789, 0.63471171426321038, -4.0401880825561838, 0.16283578688525974, -0.010173827505083943, 1.6910573781384679, 1.9557858750905428, -2.5283705032686257, 3.3246698792838885, -0.82828204893119295, 0.69196208050468289, -4.3216635893721103, -1.8661477591566595, 6.3121575888490176, -0.14721482840529651, 2.8765613752037225, -3.4744185332510433, -2.6957758007168122, 2.4036615852636176, -0.18551443703919357, -3.0338674280336],
                             [-2.4563181070721822, 6.4277074826970955, -4.8283776460002255, -2.8381000831588383, -3.4204337037987864, -3.1766109192995922, 1.1765138978745047, -1.9863014574132243, 2.9628903134998534, 1.2231169853978336, -5.2891705630817922, 8.8084176644367815, -3.9740720864882619, 0.38637765841948013, 3.876949767841904, 3.0418973541204419, 4.6291651269785126, 5.8618727000178446, -5.8235091226854028, -6.6569728072524486, -3.6941369482888375, 3.0627608392901089, -6.9631587844582628, -6.8259056233580733, 1.2472206966013533, 4.0963874719697779, 5.4491186076513944, -0.92561923811369573, 3.9096976310140481, 2.5597287166695515, -1.1053482547723967, 3.0920363582052977, -0.13947201149110802, -11.280281893899495, 2.7926724109890575, 1.7666296137402449, 1.7800923619959264, 2.9715553950908555, -4.113579288122847, -2.2504446801570186, 1.4485808912561653, -5.8350407529120734, -3.1722061078845392, 4.6355433154607653, 1.1593714897468292, -1.7640016154768627, -3.6518719578087451, -2.8693675147952895, -1.3535476443953929, 3.6685115678152296],
                             [-0.14969261945216131, 2.5793816023503022, 5.9108047928420193, 3.5933918432809535, -0.18312789796531936, 0.6278801459798854, -3.2923632187203529, 3.0752108584733389, 0.26604611849799942, 16.854108518217998, -2.932019863164339, 7.1489311792793631, -7.4230633499550409, 1.2113244846053972, 0.57119391321515345, 4.1258103678668183, 1.7885814661039972, 9.4410216827227593, -1.0616255412439333, -10.497174811045431, 1.9345136390906725, 3.4808571126003662, -1.3301539327308605, 3.6723213084859716, 4.2094939081872829, 1.6441049488451205, 2.3709350777042575, 3.978582492819946, -10.925683337654727, -9.8960822723758035, -1.2705686640146179, 7.102886695118988, 1.4375760719120816, -6.9298894336348944, 3.5220612215544529, 2.8444630772644519, 2.7175358644212708, 7.6316443391492363, -6.1241995581757012, -2.0735834822447581, -8.7214763866178266, -0.96493933009619415, -12.575817786092681, 7.4453137759001962, 2.0791935323875612, 1.9020041382123964, -4.362909170074917, 7.2081831146447213, -3.1382839428848821, -0.93591548595731811],
                             [0.42415189968835032, -6.5326511022621352, 2.8852900553375354, -0.54322293834359547, 3.1459335154113495, 3.2365354186472173, 0.80349884573296848, -2.1104410074682742, 0.77538303465234337, 3.1403837218841852, -1.1174918410888193, 9.7443340974714356, -2.5625972009066142, 6.391363070566948, -2.4496271023575753, 5.4718833110202763, 3.4568382455233184, 2.9000754604231296, -2.7578049940609342, -2.1486579179992438, 2.6100981561116159, 2.0445837125787851, 1.1711982207087659, 1.6496399294031077, 1.0561955224033999, 1.8372550035452611, -2.7476810264355254, 0.12046378858157823, -1.2811138015601606, -2.4432485600633762, -1.9648807529665768, 3.2490788223093734, 1.6069144631183219, -1.1275342202464975, -1.0569068236037971, 4.3383909641403564, -1.9202810653918359, 0.59517171176801154, -3.8796920847122633, -1.9917684021570243, 4.5277883649136861, 3.0915257677237102, 1.3268192535270413, 8.067593376847217, 1.0075271621164141, -1.0568333489688939, -0.6228036854888811, 1.4515793680615354, 0.72705114663282466, -0.21393248803099385],
                             [-1.316079460082282, -1.7736997078903438, 0.82522876372866893, -1.0189657635267908, 0.084321367610737052, 1.5128165590098384, 1.4122534759578869, 1.3400298525894874, 4.9310815463077384, -1.590702916631576, -1.5186732805942313, 3.9680586939537581, -0.3081436032522209, 0.68133048133665075, -7.1833846962668657, 0.51848343692817411, 4.2094404403338723, 4.1265406390209529, -2.7805585044775976, 2.5680006226055987, 0.56606693271137876, -4.182869506754149, 3.3251694837106318, -2.2598795269420262, 0.86217162245576429, -2.6520340386071455, -7.0615889191165335, 4.3376719910348198, 0.92398949948319264, -2.6954907710081915, -3.5328635758983791, -0.27318750938701492, -3.1090395360481935, 0.66303152637071061, -1.0702669894275412, 2.3551453362747612, 5.5802568245558604, 2.0441974907081968, -4.0737293004808759, -0.56034808985213025, 0.23444749378860835, -1.7723154653674964, 2.2123278987519774, 3.0944027076713696, 4.3765869232806001, -1.6665367466905061, 1.2960178968708511, -2.7020172854361859, 2.9645968075307634, 2.8410770918836543],
                             [1.7466934320232723, 2.7589720765898562, -11.544751458609175, -6.4558730785070901, -3.0664493443704597, -3.3766894040988604, 0.90859679297685636, 8.1887487761187483, -2.8338120575766141, -2.6186340012415785, -6.107583370999782, -4.4776655922015758, -8.9545276798980478, 4.9889890551851561, 0.80678334364605131, 1.5370745462196138, 0.69710727930746386, 9.710903832632237, -5.1500601722896588, -1.8593893100703991, 2.7996462556804866, 2.6128181961277059, -11.358575936864867, -2.8292131575874029, 6.4376014088625011, 0.81987902552478342, -1.2460200916934832, -4.3267483824078967, -2.8257778042490065, 0.34760989704056972, 8.7269062046583503, -2.4886400965528885, 4.0512701273966689, 2.8163062662740286, 0.95702649401788065, -11.090965569622538, -1.3428954779645541, -3.4228192442182697, 1.7875255619119923, 4.4284557933119517, 0.049465065862264054, -3.8495834408515051, 3.531817380416705, 2.3655540109760023, 4.2784948768001989, -1.3005142300000863, -3.2653402095642869, 3.0459020500599205, -4.7211729523276107, 11.138690970878624],
                             [-1.8203648209604493, -1.0157495000458174, 2.7423558098293408, 0.077379456859508478, 5.8890263252705717, -1.2205315537208374, 7.2325206757735678, 5.9865723051323005, 6.6746073521793168, -1.6843875396946779, -1.1480011352798523, 1.6290173654007354, -1.5900953092350862, -4.2020832445150367, -4.6284839490526695, 2.837001209529014, 3.5580028161142843, 11.79001251766257, 1.7025203309969856, 1.0370866731076345, 4.1483587349530868, -0.77507096285515797, -1.1530762001779074, 2.5366014410434254, -0.55006257486418264, -1.8588729046711248, -6.7750762764557244, -1.0221800692340917, -3.4280160296444633, -0.53811110377267624, -3.4408562666791509, 0.71640137327425957, 7.4761882883578492, -1.5641146244280717, -3.3994893071609074, 2.7871151065454405, 4.3500210294321562, 1.5801365413518855, 0.9698501074675866, 1.1152400232214994, 1.7506122577062497, -5.4010792087778725, 3.0675561602818777, 3.2695494251092407, -0.35013809895377901, -8.516868943574563, -0.91351101437149218, 6.7983337395746641, 5.4464000169795979, 7.0807942594433788],
                             [3.8943779870402562, 3.6413707850674246, -1.9832908208818081, -4.7401925892896513, -0.086080161656415494, -6.0502723400133469, -5.4791945592762081, 1.596508632322214, -6.9067595401153641, 0.85700341061148544, -1.6531202412276065, -5.0338870390159931, -3.7214341862026146, 2.1202751385954861, 1.3402244498094562, -8.8368384528435602, -5.7090983248666847, 9.350130020660476, -1.8744065821834563, -7.5516386941928815, 8.79136775231167, 1.5387098599127698, -3.8709311554136381, 5.2493655924482336, -1.1872128425255264, -3.1776860181958537, 5.4908354799418317, 4.4528633952086922, -11.613433056807548, -4.702694759846219, 1.104623719392769, -10.170250192897679, -3.7371694790665435, -3.0468569586214111, 5.5132175628216702, -3.969010365558951, -6.6542990889193439, 1.4030030188006704, -1.2667708279825849, 3.0692121495508835, -5.3004849485014374, -4.5844490855830724, -11.38224474358354, -2.9346519981889134, -3.2557315884602605, 3.0993952533436246, -2.900389129851797, -3.8763377420540728, -8.2577964351994471, -5.1066113495941217],
                             [-1.6504480866659894, -0.38479442979828093, 6.3784141056749366, 5.021453768113739, 8.8540832505705591, 10.780439412137447, -3.9288762685594789, -5.5911490823753152, 3.1115847529463001, 2.1778743142461603, 2.2241226051158534, -2.8541458337916241, -1.2826090177000389, 4.7567621008325371, -6.5242022685293133, -3.361671085502262, -8.5623869473999044, -4.5120541664167195, -5.5674841286626817, -2.8353961928635081, -1.403540026124436, -3.6901521601519822, -2.924686966425265, 10.372837305584651, 0.74650471985319988, -5.7952492563530607, -6.3559748831888516, 2.7713368283339257, -2.4136277938211386, -7.8164711196346035, -8.2979982379338963, -6.793870580002543, 1.4558056844012457, -2.3884286167933451, 1.1572806241211564, 4.2530667756985832, -2.3615679941323675, 1.4930501105891429, -1.4240686822151964, -2.6702701696506361, -3.4422424803768199, -2.5910972173817983, 4.1281033395990825, 11.104075189143561, 4.7743867727476061, -1.9507899587707653, 1.3972702838824125, 8.3657402636995482, -2.4347922759817928, -1.8923429781336578],
                             [-3.5284393559804288, 0.69294838673502746, -5.3139630930105337, 4.1607771973267402, 1.852836786964507, -4.1916989296033416, 2.9422987349486323, -3.1723679660404249, 0.32778252615606679, 0.15450573153025929, 5.3374494923505367, -9.4489426495634454, 3.2401093560827423, -7.5450598183631179, -9.225429054026165, 1.7782025118970124, 1.899457929258622, -7.8360735901598861, -1.9373225880916258, 7.6885592332060089, -4.7021995337733919, -7.5294401716316433, 11.121819988503669, -2.1272904373346964, 2.2984301435044507, -2.4787851237620373, 4.8507383867015967, -3.5035602159081032, 13.400171619541441, 7.0059400338381703, -5.7649410877220602, -0.28965598419123229, 6.9271330428817857, 12.035049296818078, -2.8997724103448932, 7.4174756569974667, -0.68584330063079524, -1.8532919907818932, 3.2115266534142148, 6.1913555879894719, 4.7943739336649482, 3.9278970573946621, 13.884286345901877, -4.996493399744784, 3.3953564501291762, -5.003881931252927, -2.40057262586775, 6.7306258677621011, 13.127357785446803, 3.5896212596194657],
                             [-2.1204959274548214, -4.1792101486556703, -1.8095045297910617, -0.29846072374133481, 0.23988034250219176, 0.83475376527289979, 2.087614570806307, 3.5305107016213917, 6.4174465131886782, 2.7759882771932869, 1.7855644582714452, 1.8458800350549665, -2.5418774246511973, -1.7337200484091151, -6.4143733100792861, 2.8841548802645565, 2.4063130441089249, 2.1393926981983089, 2.005978920298241, 0.11928492857378759, -1.260924510456551, 0.84595261699710256, 3.661267005901315, 3.0135324204481839, 0.38617639906032475, 5.8511462903608651, -0.74656794083488986, -0.72559874723000184, 2.2821899416377258, 4.045268780660388, -1.8367032330410666, 6.3286447334224505, 5.6980474278716065, 0.57817485813605907, -1.9481626999629857, 1.909657639718735, 0.54748025614657037, -0.5240523938767504, 2.2183436736591986, 2.3512308965217175, 6.066272700188744, -2.9304056701598271, 3.7888586317019906, 5.0399319829991365, 1.4964087144012874, -1.0942037139224259, 2.1650143386314524, 1.2834068843557385, -0.23335747942180243, 2.5470073497181129],
                             [9.2767239400765362, -8.9652511214151556, 1.8849449125411168, -3.5734683374771596, -6.5726812397819216, 3.0089347577021957, -1.324306338186831, 6.4787186859157195, -0.99376189473173082, 4.0327817688477605, 2.9500795803453022, -2.9900239613545248, -2.773901447511637, 3.2880828247002718, -4.5905698129630945, 1.8713798198287017, 2.8724066120448355, 3.7063598263687534, 2.0371206058415976, -1.5498446195870841, 8.4725626952289357, -0.49657694239703276, 2.6334032186812304, 6.7581435355784265, 0.55535848541497224, 1.0177627273914884, -4.2510278886947859, 4.9763989891101392, -9.4469202883355514, -3.414914631591484, 2.789164253769528, 1.0869541252122175, 1.4602337538664159, 5.1216673837673605, -1.7898322329445899, -1.8762783018176656, 3.6495827547084483, -3.8200898289404561, -0.64062710386049848, 0.77056363434487163, 0.83450100938067862, 4.5465029502450909, -1.8054196088795351, 2.4064255972027935, 1.581679647874626, 6.7939435103086758, 3.6633004652220116, -9.2227222987747499, -0.64440345294500556, -3.5818413477599402],
                             [7.0439412550506031, 0.88508719521995627, -5.8694649358772377, -11.967446287853425, 2.9298062702166665, -1.3632872886576468, -2.4158042685889076, 0.74924093422688309, -1.0423599763462665, -1.1359700706060851, 4.2883422349658513, 7.9018242795929226, -10.02238339911241, 9.7733867788374589, -6.9743673936974382, -0.080257277492005868, 13.717808974447623, 4.034055249748425, -4.7279037705776039, 4.459455371924018, -6.7890741907524434, 2.3747925710894333, -2.7911887978294123, -2.2971865494828383, 0.33775856699542778, -4.3871624249228747, 0.21698956531824989, -0.14166023726887922, -2.9709826349706887, -5.3366184705874664, -2.3913877263918817, 1.1726878727672063, 4.4302243268602615, -2.7075511805768184, 3.5626388646792062, 0.88843779466855388, 6.113655510733607, 1.477806560384868, -2.1633218940828645, -0.34459830514665152, 9.0554444915306931, -1.3500622811404965, -1.1642124135808161, 4.5912417379767971, 2.1564117769908941, -2.1481113657018445, 1.5764973367545918, -12.436931450649974, 2.2642389702996564, 2.313673032288952],
                             [2.5864280634120345, 5.2008670700848736, -2.7439129873339234, -1.7915953728672676, -0.36528517780371461, 10.076730593821033, -1.1703564801671469, -3.3649899983313967, -1.1438940890295526, -2.6765691681961448, -0.09956685773520739, -11.531090733180768, -3.7605153149101627, -4.0376675004540052, -4.1177108479498754, -12.660795128414771, -7.0192974400059143, -3.5242373438083221, -8.2980083909800477, -5.6811659775248655, 1.4655467546236092, -3.6802368645096046, -2.4935297044865048, 4.8267436941543727, -0.79217179512945135, -2.9427550828813902, -1.3523286319763919, 3.3077537875423952, -3.8980607186880283, -8.3468979392175697, 0.90519556800148027, -13.071738387933381, -8.4125451482706488, 2.6517311470753167, -0.38425395805024259, 1.5340106990562268, 5.8631055320044894, 0.21597646830493133, -1.7653400781675603, 3.0645084260254123, -8.5533945974108736, -3.221560888396271, 6.8317391430374812, 0.78928077029313282, -4.6129365100729389, -2.0233761075280401, 3.522635507036342, -0.70807308238523481, -4.6399573596595802, 1.4448473901607826],
                             [0.65995717675754939, -4.8469617318987037, 8.021053139810439, 8.1222632208742134, -0.92271738236634204, 0.27384055884423736, 2.3797807051159534, -0.66963462844696875, 5.0989497830472903, -0.3354736616929902, 0.72846537336111672, 8.922052157474976, 6.5022700864819782, 0.58926219802380875, -1.8066401804547858, 2.6842332207916519, 3.9131390499084646, -2.7737381552587088, 5.8728482757825642, 12.061305602490865, -3.559441929542047, 1.8832583743557982, 1.975054876835421, -0.43212289474892313, -4.1257092127474628, -0.89812017626655749, -2.0867502955905963, 2.1092430444006638, -1.2187294788609233, 5.0641236725650209, -8.7394439444700076, -0.73802894544707975, 6.351988181869566, -5.577358676880813, 0.17493215091177042, -4.5083006763300153, 4.9545737949922408, -9.2877593302777246, 3.0594554302719397, -1.303276882330634, 11.246807027526007, 0.022136764250560634, -4.7521082591089261, 5.2690455964447915, 7.6018438660759742, -1.9253064625878993, 1.1041419758937903, -4.5010838238221362, 8.2131392453125702, 0.90136087450439928],
                             [-9.2138574522962173, -7.0272494630896309, 0.57942448933207236, 1.1592877711705682, 0.1321914841777295, -0.23316564397443634, -0.31955675160343444, 1.0805029587315822, 2.3389474513589641, -3.7208257831652265, -6.1766117890884171, 9.4672660831329907, 4.6416312489353553, 3.3838438596011708, 1.1435825929978753, 1.8618971963775737, -4.3536997911541997, -0.83108434779839058, 2.1840274664476076, -1.8876819050813471, -8.6566993084443329, 1.1740506757693074, -0.97236331656646136, -1.2723929437215431, 2.2253148828126106, 11.617527688686835, 0.86136655543233664, -2.5019800100614229, 7.7955614942101619, 10.786056326416555, -2.9762280638720275, 7.8987337026057212, 5.7400755667938155, -1.3413253847796716, -3.2117613849953086, -1.8842741979066746, -10.711044442225687, 0.52692489450394819, 3.690170128452174, 0.57876197362318615, 5.5824819139493922, -0.94518783019686403, 0.31053770399127834, 6.5122065431186336, 1.2404313711061616, 3.325601613352315, 2.4403887525077517, 0.22701766122539974, -2.1248028577928375, 5.1373298087927575],
                             [-0.90722144764837975, -2.6584386200101067, 2.3626579661745639, -7.393540362839615, -2.5211040836780079, 2.5696468687779683, -1.8837149261526822, 1.2015483580526403, 1.8796455017064466, -5.2895988663695555, 0.75130910325758093, 6.7663221773757272, 0.37737314674451555, -0.74998447286389969, -4.3654536138213382, -5.547761812632686, 2.863014072183403, 7.4898472098522051, -0.34319793601153392, 4.0416792800101655, -3.749004448248213, -0.65500057294794867, -1.086518402675497, -0.4549605557218408, 0.52423059409575723, 3.4438121351684896, -0.12087145149378964, 7.3874252318105524, -2.4702296615827954, 1.9878840490373328, -2.8764807998846567, -1.1509223045417107, 3.8188920575262095, -1.3746652149640821, -0.2643223522519817, -4.7603927428905441, 8.0793418176084142, -2.1526021777277347, 1.0663140474666715, 2.8650303107707535, 3.6895443566643613, -4.2942434505572988, -4.2706650867892506, 3.5790833564338174, -0.065104898894177948, -4.3916548773032087, 0.34566227672322969, -12.525092596793277, 0.84389690890620028, 0.31196196846178553],
                             [2.6030394066294913, -4.034990396898178, 4.0594523664086246, -0.84954866347651059, -0.34151302079591722, 3.1512703543146947, 0.14117299060226762, 0.15294788961880584, -2.6798026242974413, -1.2975282553777181, 1.3659445171314095, -3.5577559336944429, 0.21089047597749083, 0.81531903682584572, -3.6554210727981373, -3.8121223997049865, -3.3232252830543416, 4.6471984636745045, -2.8629586737586457, 1.2283633006923673, 4.1237363217498348, -0.40721095287663978, 0.57483442222839587, 4.946967720947538, -3.3723168503492111, 0.3200154870158915, -6.4273449147109725, 3.7863605438857175, -9.5293909580988565, -4.3269475737265459, -1.7930685533504789, -5.4457075259350542, 0.2629880645238642, 3.0768411342630633, 0.039702533833909183, 0.34765924453522723, 1.5766880561923999, 1.3631286185781497, 1.5104269534393928, 1.6929702169020295, 0.25382883770980885, -1.0436069920909903, 1.3643385027014479, 2.4966262871017211, 3.9505393271669642, 1.1550722096855208, 3.0682139565659936, -1.744955135528703, -2.5557786604874329, -1.2283637921808186],
                             [3.7704424992756969, 1.0274757732184745, -1.6773858149638898, -3.9374029550028911, 0.70325593479173765, -0.9178593521986893, -4.2868351343256945, 0.15554793997055885, -5.2524105377797738, 4.9714399484505867, 2.4788558973144914, -4.4308919894318128, -7.4555427392372247, 8.538059603131483, 2.3436499089314724, 0.65977976443371134, -0.77564891880918341, -2.2259817718760115, 2.7566892736161934, -10.873801407695929, -0.26190155718603514, 1.0397345395731947, 1.6096804314951905, 5.1035313181516901, 1.6591868012386157, 0.71828131104732407, 4.3850738149954624, -1.4677351931067397, -0.98706496893315598, -1.5450482930341318, -2.3037422851320963, 2.5988242465169509, -5.4810413551224375, -2.3194368452640513, 5.5320195839337041, -1.0688521793749555, -6.3456184701761842, -2.188626701937296, -4.05803697690222, 3.1323230813650085, 1.6867065995960222, 3.5966528830679043, -10.649449262458248, -1.2204241065361534, -0.80130743784649905, 6.0394617776469266, 0.45877940993605987, -3.3737500185778968, -3.5300006014528278, -0.17881494792914487],
                             [-3.8740166258554756, -1.3136511659971541, -5.8310402154339602, -2.5509665178408105, -0.71746764721329492, 1.2075309224180828, -2.5215291899878065, -1.905196497659509, 0.48531268906101632, -5.0254714356316912, 0.48276738787531354, 2.9852652379405384, 2.1041145213634866, -1.15683453841668, -1.7446138144275156, 3.5514134162056905, 2.0347950395875776, -5.613186796464336, -7.3251517769067283, 7.5640081342474419, -8.1110028215130541, -0.91300564622866798, 0.02177719555646173, -3.1340509040593272, -0.49297698407628321, 0.099938985541926928, -1.2134464814385189, -1.5944989945730452, 7.7240301910451956, 5.0455889680927148, -1.0236746764172342, -2.6689355102797538, 4.5210983797396631, -4.303047927809545, -3.8392800048523816, 0.15758666083997969, -0.1305786315225613, 0.79798354083251333, -2.9172059911605479, -0.099165983038094319, 2.6300576046620696, -1.0955056558171121, 4.8271759525703208, -0.32420880466690838, 1.218693062445708, -4.130468236467574, 1.6688286492896243, -4.0443296053458928, 3.2400223641307964, -0.071119977259329961],
                             [-4.9780795988860778, 6.6635753298209304, 4.2025741378150885, 6.0480235464085554, -2.1269246054230808, -0.53651218054887606, 3.3668868736766369, -4.5107860410436782, -0.79526250210579363, 1.3952537699045831, -4.3230301157840909, 4.3962596514814249, 2.0260505672108664, -3.6118090740300697, 5.6981675105450815, -0.21018906367475371, -0.064706370616900794, 4.1607919583235313, -0.96981240979154926, -4.303129707329763, 1.8232421514279711, 2.7072346077926999, -7.4261342646306536, -6.0825530891488357, 1.0115687493063086, -2.1634263167276471, -0.64334775473211503, 1.056919954746691, -3.2784244554438282, -4.9159869453849732, -0.40245399904450874, -3.6773589427185911, 0.47099115160529337, -1.9030579358915556, 0.05762409656803523, 3.9231003310706121, 6.3631145239225306, 4.6398636134910953, 0.44680256872845892, -5.9847757012523957, -4.161078341118249, 0.14141157332086818, 2.0949707334788421, -0.7919197222024108, -3.0971092081208789, -6.3963303032518271, -4.9904711181809018, 3.3786446010085522, 1.76578975754266, 4.2052333802738238],
                             [-9.8744107493220223, -9.4684790270926662, -0.26363044167074223, 4.3227657744678893, -2.9953731245932911, 0.039881598990947037, 0.93159968233062884, 2.205548792061208, -2.6628224932837607, -3.4988942852857292, -2.6160827003417118, 9.018884750957664, -1.5651819750636971, 3.3745638740363972, 1.923455605104083, 3.9691152915172685, 4.2650531232896469, -0.30542293577191898, 1.4975460617903693, -2.5318244616181311, -6.1811320367546827, 2.5989978898429933, 0.92784734974675143, -6.2212112708849965, -0.72169380529944116, 9.6605312031819537, 3.2884657760847888, -5.3564174682879298, 1.1951512454957558, 5.8591286241008618, -3.4681288519295226, 7.0761412131800521, 5.0314553872858774, -0.44306999725229235, -0.69325707499726175, -0.34427440198235504, -7.7771485036795243, -2.1361373895669873, 4.6693165006812434, -1.0855538009605725, 12.546593755772239, -0.99395567076523983, -1.0136872539533641, 6.0749086768981169, 4.1676406531116008, 3.0441983678152646, 1.0535184044064463, -3.7426765065638876, 1.2100899066152215, 8.110003942859862],
                             [0.64160976359077082, 2.6067413269651585, -6.3298710142942989, -8.1860836123831824, -0.29609089547904288, 1.186452244014345, 4.0732067778412251, 6.4651840551502522, 3.2510738409817987, -1.5510994162451355, 2.3554911784783852, 1.2410455115521184, -0.66305335069970861, -8.6268027580298625, 0.4831753724098744, -0.80153969203279707, -2.2829475405618336, -7.1843597771214363, 2.9942122072158459, 6.4200053939302562, -2.9883896230940521, -0.32931855770988888, 8.5519482378910681, -2.5804262469609291, -5.416559114458539, 4.850085780230275, -0.0084726808181751177, -6.3769769170656616, 5.2572271624356359, 8.73216269289723, 5.2192304709185979, 5.8245713948618256, -3.3206997210607128, 4.6347116577714296, -1.7940411873827049, -0.69774574182853333, 3.1060148957656, -2.2322524012761744, 4.1248413601233969, 8.7967265458395527, 1.6340926220480625, -1.4249603654235334, 3.8298331415405742, -0.49875520946077073, -5.001180051945413, -0.078826301383439962, 3.5404162415506546, 0.74620044567179022, -2.9543664714185605, 0.44919713805215522],
                             [6.429156221105548, 1.9752214374854955, -3.9934071844716406, -6.3538340333544001, -2.7876928128259748, -1.8509794919956237, -5.9250158758110612, 5.4705126006887408, -11.75593381771303, 7.7461892682082789, -1.0399952994906518, -6.8460067952815882, -8.4201676556095766, 2.0587076932079911, 7.899688100577908, -3.7970205896284064, -3.0910857938598442, 6.7776940553112119, -3.2146872328914733, -10.76237132125086, 3.8194485020531803, 3.2998582308816014, -6.2510724753670921, 2.7045596624674144, -1.5849042713428729, -2.430127977107241, 5.2719549420725853, -3.6863760765174827, -13.0206089153024, -8.4865426217390727, 5.2937506139565693, -1.0302080227472052, -5.8429808539108459, 1.2530613460078779, 5.1264034633905515, -7.3257798189550964, -5.0639245256872849, -0.40047947905899728, -0.56637413632254896, 4.5492768550204339, -7.5786137520662846, -0.38734481751274991, -12.565991121837646, -1.0100985755120944, -2.6316729334498432, 7.5333279341823971, -0.39866968346331871, 1.1492985625468675, -9.5992266232784313, -3.5324536592016127],
                             [-4.5909070657841387, 0.16642534459022015, 2.5011987123483408, -4.3591863915871487, -0.21639124905586113, -0.45078328890180819, -4.9924358990071678, -4.8505799171425572, 0.77910041080505688, 1.1942076105790407, 1.5843924172402044, 12.900498061379166, 0.69710525007965241, -1.2636615584600732, -4.9506349067703992, 2.264012831954449, 3.7629601577824556, -1.5140408590152095, -6.8131274442526797, 4.5621869750128647, -5.0837494477211722, -2.5872924657503589, 2.024312427294285, -3.1887138110191611, -5.93958915609511, 1.8810831268349901, -3.677270111254539, 2.107907149263275, 4.3482260414431568, -4.8677330030410166, -2.1204707641860288, 1.2751701436990508, -5.7805813433795334, -7.9937907553328058, -2.0784303283708927, 8.8345808218296042, 0.62392405128455275, 12.743674982197664, -7.1259711225736151, -1.8032593564091901, -2.1259476940603697, -2.67015703180182, -0.92184603891394157, 0.65158587302441151, 0.14643386834107608, 0.11086374391718498, 3.74696072266075, -6.7970262417892551, -2.9505131787786327, -8.8394359596753276],
                             [5.9153981700172213, 5.9024561072298258, -11.193085614772507, -16.930176905527123, -4.2727845205168178, -1.2199004599235541, -0.016856371152735652, 1.966001048710343, -7.9778382746519823, -1.4021245590339841, -7.6178034538284063, -8.4337810185225681, -1.9358583132029368, -1.0375916841298329, 0.80918143723226721, -4.3003385637674443, 4.9564647945088822, 1.0292815296930653, -6.2444213187587607, -6.0149977894303222, -3.432666755325533, 1.0134819562267501, -7.5699197344313793, -3.7710368239146774, 8.3729423491639086, 1.3658314591320315, 3.477591984488527, 0.43686561093849841, 7.4171621455374872, -0.65695572907687505, 9.7744761533226985, 3.194208977069386, -6.3974588170701709, 2.507673434093415, 1.0858235793356159, -2.8033573448898794, -0.35464159486307517, -2.7613966868429625, -0.27176832540467627, -0.12929545407272014, -5.6178186568422275, 1.7712110136231372, -5.2188725865422816, -10.493509362996491, -4.9430510226402777, 7.6006478109284688, 1.7280048738742904, -10.722372012959083, -2.0196741031469316, -1.6805134471549728],
                             [-3.7682670188295475, -0.063980995334734406, -4.0812219262226543, 1.1310454336157236, -2.746072405905974, 0.8416846146074124, 6.1819281232244156, -6.8835803264183788, -5.7514624305320687, -6.0059870051519262, 5.4998081999506612, 2.1269873814360527, 0.96235682684036372, -9.374744289964946, -6.3850115906273217, -0.97113670881006187, 5.7705164895383456, -6.7214586726698755, -1.8169231119548925, -3.6620574940786459, -3.8021126422560094, 0.95557227862434058, 5.6097933723173714, -5.9260233539355402, -1.8705596292812343, 0.35210339238109101, 12.133692263173067, 5.6900840368185914, 7.3688997780261811, 2.1671978480077687, -6.4619059112259745, 1.2754527983003732, 1.017514853226958, 1.8876828660178826, -4.9781829746009816, 10.694976151481557, -2.7706301781867699, -3.8866827214131541, 4.7228875395897925, -2.2228031999878342, 6.6843226884883817, -2.0076528573149273, 4.3655701716437285, -9.9986681078953907, -3.4947378292479678, -4.6549040767872905, -1.08547795620681, -11.872023971980358, 11.020138637860086, 0.26239697631361353],
                             [-0.55059176022688461, 0.43942345579582809, 1.7235540082426073, 4.8307522703651014, -5.8990726458948526, 1.000205394685955, -1.5644923759776301, -1.8125346071866979, 2.4286021575916901, 2.0770594964462354, 1.5784576405819584, 1.7640418942560705, 1.6428303713387873, -2.6910762031754678, 0.90263356328633326, 2.2345356552153031, -0.17387521194504565, -5.8801942295149008, 2.8857583028996423, -2.8741842818963628, 2.215023672574381, -0.25384146682644576, 2.2114653619787719, -5.7633741967673338, -4.3985307178674944, 0.89280479497066145, 4.4370957929047998, 2.1341337224785533, 1.784900532027017, 0.66802368050435768, -1.8582874917962091, -2.4114821196049379, -6.9412340542749602, -6.6517267241192588, -4.0018967749682366, 1.3969917973534181, 1.9005929711307614, 1.3040173911243669, -0.10619267223237326, -1.5764023780528829, -2.0039785351533776, -1.4343305168020539, -2.1330039762112203, -4.6603019032394775, -2.6720003920293189, -0.93963212937685781, -0.910805264641664, -8.1090015565495204, -0.2117261466904776, -5.0640128267148699],
                             [1.2042412725511362, 2.9184477687802741, -6.1184910930595731, -0.59564680655080049, 4.3247855636394474, -2.5063635244697755, -2.1693858953090319, -2.3145195694464231, 0.71988385399228694, 0.67684730237400259, 5.6404421394758977, 0.74316842449586462, -6.493951239873887, 5.927555254576232, -2.957628165191057, 2.9477654467331247, -0.68062414428533635, -0.61232187487435619, -5.226659922746494, -4.4233861929763698, -0.32406674441529204, 1.1343645865153087, -5.988051192129535, 2.0882921220994781, -0.49040832000425111, -5.0637498540210171, 4.3120481889459201, -0.87417258369393336, 0.021843294034170659, -1.8050663151329964, -2.9270781236644692, -5.4281123093366155, 3.8124518683705704, -4.1579144383599109, 1.1476248853011641, 4.6816455875195988, -5.909137961557354, 3.6581979223177878, -2.041669112570756, -1.713239631749601, 2.454247971914802, -0.7082820311357737, 6.2415451448710124, 1.8170341668882177, -0.51007162742850543, -4.107522558584253, -1.2224635664326027, 2.4115990367302147, -0.62493410358744761, -2.1508040424342134],
                             [-2.2802482262233315, 1.13369325418337, 0.93153524544498989, -3.2217743417838673, -2.0713476738755037, -3.2448775219731782, 4.4101062405713938, 3.3561519846890189, 2.5763853986862046, -9.5321210665100722, -3.7055883581689724, 0.53379474571811603, 2.9734580270203894, -6.5409727452728896, 3.059070975040441, -0.53819535782132599, 1.0271333707246761, 0.80933387556850489, 6.0000497799627048, 6.1197526197436058, 1.3077348274661567, 3.2052618663019308, 4.3786972393805161, -8.7707371828141802, -1.0768918654834272, 5.150181333260698, 0.4590812338428697, 0.4341879818309734, -1.866553566388822, 6.1056103081853905, 1.5880906295863351, 0.17700948952296972, 0.86568252490032849, 0.71179272267319427, -3.7190043207762584, -2.6510634099483439, 4.1041792244317046, -2.7924327612144619, 7.5174184286335706, 2.8816928538280151, 3.115957231252406, -3.4395678847463174, 0.80147749419351078, -2.1990243080039118, -4.6026618800612624, -6.7036184137676686, -1.0470795477471073, -1.2301846769770886, 4.7329360870224875, 7.2199369209166306],
                             [2.6217792122212291, -10.95330453249586, 0.64351517722907159, 0.49562107612460082, -2.9023803226350076, -1.0809975887618024, -5.4908043098497599, 6.576987459694065, -1.2063275470066697, -6.0600115159156509, 1.024158233028845, 0.30661147940020395, -1.3626906959791376, 7.7959775089116494, -0.93732910838385708, -2.6745079256692206, -0.87226677409689779, 9.271393280959467, -5.4294704140712291, 2.4940419629095323, 1.7552771031640004, 0.37743445591409114, -8.3586568010426312, 2.7123880967598812, -3.342268249610421, -4.0570975162669543, -5.8568377747879472, 2.5083380828964099, -6.9220279898614123, -4.6513057851016573, 1.40955384492414, -5.2865738516700604, 5.0000319094756573, -2.4392196040432932, -2.7691478015751692, -8.7491129132259697, -5.3279631113108108, 7.7871120915694512, 0.99678481609994396, 0.081657451723591387, 1.0578998203077434, -3.7839588560109991, 1.5298336536478039, 4.2352859622483843, 7.2567659165465557, 0.16670916846097786, 7.0201736858221446, -4.9813509767366817, -7.3052607045635023, -3.4621305543522065],
                             [-9.4384803535472237, 0.62463902895020784, -2.8632946342639789, -0.31059263641566021, 1.6357240113073779, -4.4370972935068762, 3.1697616581705028, 2.0009638200296123, 1.4766228230714487, -6.242530510671676, -6.3208340358898205, 8.6704438794253473, -2.6003788330870292, 0.56871150681050464, 2.8026855680944625, 5.7282085422741096, 2.503952114798746, 3.4336892998292496, -1.0911261128022716, 4.995910125075933, -9.8938463575406281, 1.9737716059445867, -5.9791929754966811, -1.6603734341780594, 2.0854881495553137, 6.5795819238817161, -3.0050791102891106, -8.1528820822312067, 7.2203006898662547, 8.2261784420288429, 1.7387930929585049, 9.7541727006455243, 9.9195152775289976, -1.5632095619836917, 3.6410976652696165, 1.6334173874007487, -0.040082750148959415, 1.5102718391371579, -1.5896423537150186, 0.8568982314664374, 9.3768504393823395, -5.988051239556456, 4.7883789800618652, 2.0902495871442617, 6.1919608150343306, -3.8015656256675046, -0.95751053303377864, 4.4646700115620828, 4.8468285199356842, 13.560250241847582],
                             [-1.6886301762299034, -0.14769436327411567, 5.4098068297579847, 7.2421004963292281, 8.7319170210650086, 0.088882918122773408, -2.8524231408846115, 1.7142207026396401, -0.43374946460298391, 6.3490309073626756, 6.759585968728886, -4.1234289348599154, -2.9911118506242276, 1.503117588873164, -1.6057549128999331, 4.3120123141750408, -4.0778223249963244, 0.29121852902673584, 4.8934742593313798, 5.7093016522850633, 4.148027775695847, -2.6410836443476526, 5.8613590741772343, 3.1775595343006122, -3.695399849531102, -4.9653798616906197, -5.8561101180578081, -8.3298548910372912, -2.8180164344462701, -6.3640567332130447, -1.9887170710440873, -1.6701099726756019, 2.5617274394828606, 2.8062308308247261, 2.3049121023547237, 8.3497017586091982, -3.9709447588414957, 10.60465429092614, -3.0303470062203308, 1.0881416002909867, -6.6803207046879063, -1.532805439933246, 5.0376764098713558, 6.2883530762548059, 2.7792116067660886, -7.3527799610198779, -2.8633791167626992, 14.907680267377051, 0.13606770447840782, -0.2084906233881425],
                             [3.6120716806600499, 7.1207143286487362, 1.604659719959024, -5.6634042406464733, -0.1283195235286812, 0.84385890186671686, 0.4920999940726557, 0.22694600733273415, 4.8953227647542983, 1.7025822547252905, -3.5067728298569505, -5.5461447851517338, 1.8848635807764225, -6.3710231128302537, -2.2546347140657224, -8.5624552663914084, -0.038736233743660517, 1.5334452314150335, -0.4043852336697133, 7.0702704236534162, 0.040154671783991049, -2.0760066873252216, 2.4703674315769968, 2.0536030119963704, -2.1338493001313599, -0.012660234821268435, 0.12730064043473655, 2.9263970457952695, 1.3212391599459157, -1.1131266308682497, -0.24878500852432109, -4.8926025707489682, -4.1483274875821463, -2.2528133894338351, 1.6137810406023787, 0.22559122962832348, 9.7061551245966928, -0.85894920856406742, -1.7448127297359632, 4.9317280508855461, -5.7894565085165475, -3.6492069507957279, -2.7766162230161209, 1.2757874590273084, -1.105147474053334, -2.2871351465952254, -0.26399883065768026, -0.75167289632596701, -0.41429454421508316, -1.5669368843901774],
                             [-2.3717671508014693, -9.6138461381891354, 3.7680487127616704, 3.7921700536190586, 4.1537251893100704, 6.9315376100488022, 1.6324028048783521, -5.1244267015312515, 2.720475803999852, -3.5165023956872803, -1.4640145041068542, 4.4669042301789901, 0.36618828721508356, 6.6910856503330587, -8.7727923281238382, 3.3920404242880617, 0.29201952128572517, -1.3377527185473159, -4.64321311595456, -3.8689877475843821, -2.6045401717954419, -0.78081713484510196, 0.621172744876478, 6.5360566328062895, 4.4619978705343204, 0.61539442058879734, -2.8669260763117124, 6.8146821050894184, 0.26529927021263827, 0.37518768757639648, -6.8599960610833461, 0.59434016778672738, 4.4619598272536924, -1.524526257793684, -2.1889902779053272, 2.4704925410717093, -5.5357844783749259, -2.1819574512498101, -2.0971540581256041, -5.1133199838869556, 8.8329215895865865, 1.4075899031822192, 3.4087376138585839, 3.1393204058922208, 4.3303337181947166, 2.7155824900978263, 1.9593064739849828, -4.5627721662200438, 3.2221187242411378, 2.713844171025662],
                             [2.6412485110564821, -1.6051121623762901, -1.4060347664572685, 5.5933794304064568, -1.5954289387563569, -1.2061013309253403, -0.71105013917053694, 5.7408578535200476, 5.4494658347939229, 11.109860301276848, -1.3022418528788788, 4.0306099416683221, -9.8261561671814768, 5.0273142834066977, -6.7709485143836927, 6.3516430331744029, 6.3758801199175945, 8.5330588796890616, -4.3187538004460704, -0.92026164903790042, -0.91775032217809183, -1.3359825018628326, -5.5527510052991653, -0.27171791810243862, 5.4223924398428185, -2.6653348062282709, 1.0247164706026737, -4.83772862031726, -4.4569522339564571, -5.9679733149544614, -3.693921477367315, -0.90914255558706003, 11.365793110053175, 0.016476733810619537, -1.6746525643461803, 0.63647264724519426, 3.9523549723371656, -1.4077273017999348, -2.5129992456042616, 2.3478118265417685, 5.3132474884586198, -1.5035163132005089, 3.1016250240945338, 16.514551991397699, 8.2940237924180931, -7.5116185114085452, -5.3848622286185801, 7.3247150038358244, -2.8481995181744209, 6.2968283056982246]],
                            [[-2.4736757939192167, 9.1379915580676077, -9.2449980093081354, 0.99548109612455926, -9.5480306435328934, 13.012668330550971, -8.2613652533959065, 3.0592345339220546, -3.9891374299722466, 7.3991117697556259, -13.196650083873699, 3.1890026685029507, -6.3566914527366682, -11.867659452874356, 1.6242448155717244, 8.4280988038350397, 12.744794742136907, -17.422530156150806, -6.2778862389759782, -3.2400104393907379, -0.52523207752638379, 10.899458601385701, 10.140115802848221, -6.895525011651146, -11.678741362877238, 3.0496517557335885, -1.7078936878805302, -2.1400082525703601, -8.7718240744527272, -2.2848358397419517, -10.558886518983444, -5.9805505608918024, 21.774675902380007, 7.7692744660735213, 12.618820772626753, -16.57734711402555, -0.93739900005223398, 8.9844155123485212, -4.1267111430102261, 6.3643011066595108, 2.2416985087087107, -23.596694992968459, -26.084902728646441, -5.4119440221236612, -6.5873796810969454, 11.751301968111505, -8.0851266424415567, 12.990644604471886, -8.2033096910052805, -14.014204027850091],
                             [2.3783465343090597, -8.6776950652315747, 13.483362806152742, -3.6774660756101878, -9.8770843107848147, -9.8174175240653128, 5.0343514219742076, -16.518492550450841, 17.109510678641968, -2.3741354621978807, 17.56794249476674, -21.143825672807505, -14.387943099268464, -0.58661895878323111, -15.381435320772848, -1.7397619447973374, 2.0318298051327557, -26.356822795618058, -13.113538728931236, -6.7619305394915648, 16.603210244180506, -13.067043789185302, -17.997137717624323, -9.3326160507596274, -4.0519227740967194, -3.2970354700667577, -7.4188689213230106, 18.473014436883041, 16.379933199131369, -16.399180141950481, 20.948463236001576, 7.4948152756012876, -5.386915950108655, -2.8724498019627651, -11.295714301529308, 24.073860892474347, 0.79964084980900862, 5.4400079734028601, 31.592392806163815, -18.773110032378209, -24.627769632032788, 6.9729745803289465, 23.004515415606832, 6.0746568433826944, -30.41589811432042, -4.0334318065457166, -5.0426252353250653, -22.426444708720016, 14.702178679841534, 7.4066461101972898],
                             [3.3873682247907801, 4.5543427605212159, 5.0108899674634699, -3.4744368488983768, -6.4203391771853546, 8.3355914951142598, 5.5515749701649852, 9.3977237603723793, -11.077502788193094, -9.3044352792134006, 3.3907243251978856, 2.1902407229723657, 11.584013767881084, 11.301280778718732, 12.065574010772522, -15.439604387385778, -1.2436693951629607, 23.111893458806311, 9.1250186712664316, -12.724467142467798, -6.2681320994864631, -8.0035554041593517, 16.730194020530387, -4.0552711988394226, 0.52902876475384641, 6.9103489158281972, -9.1806855355829295, -23.447279026816958, -9.7191681242358516, 8.946931142202013, -28.299977320020002, 17.320811303306836, -21.158075172076824, -3.1354545083479803, 8.3535245164160532, -2.649922478644251, 7.4474540626368322, -19.911199356176212, -11.668625729909149, 8.1940881263511685, 14.643352439287259, 20.113671185759181, -12.098341050213063, -7.8156807416068519, 12.89468715708772, 8.5356756649309116, 2.5110246952147577, 13.880962994291787, -3.5738176122741292, -9.5669633131743179],
                             [-26.679114696674237, 17.656183069296642, 7.3842104794558834, 25.223600344022074, -1.7293395286672599, -0.73647301091110262, 6.2326575309385932, 4.5251934834318925, 16.432490821470353, -16.653233839641029, -12.903287403659345, 9.8658957101247875, -8.7230115019469299, -12.793672029863785, 1.4513706658175449, 3.8601339028973389, 4.7674739567505533, 9.4068938732040106, 2.5554670686517933, 1.8935075926352705, -7.883487797500667, -18.764228308896207, 6.0686387186783923, -5.6519112751926874, 19.774880324889029, 4.8831747128983487, 15.134210130920664, 19.072979585136732, 14.541642768890654, -6.7519691332294851, -6.5987096963454137, 12.34556406052805, -30.317289421136181, -9.6157574515362931, 14.666132692263396, 10.277805592254506, 0.32280520892481834, -15.138217844605478, -28.327922224659591, -12.633556445336151, -18.563621780713547, 0.61640380707228615, 13.555118243380821, -12.927853482698145, -0.20658018872748762, 3.8154067634372031, 5.1821683977925996, 15.608233256987582, 8.1432708001079916, -5.9681345367671863],
                             [-15.319283391412151, 8.0228715317341752, 5.661381971446148, -6.1326752915691642, -3.8265312083567009, -7.3256261707751413, 3.7296248474981701, -3.3550537509590717, -7.5841610393439902, 1.9768197074022866, -1.2062812168019226, -6.6672645659151843, 10.012041500123361, 1.0165157063937742, -3.6853454574022004, 34.904314183660574, -3.0189358509896582, -42.725027933496371, -2.7841379563501403, 26.429234002198228, 12.207406462460286, 7.9611537793643201, -7.6152496157508702, -2.6305509855444198, -0.82385818565975433, -3.5044421362009732, -9.8750310828782162, 12.551292937706217, -10.977838127394868, 12.385651019429719, 16.88846258203256, 1.5426875124690642, -10.800024695191485, 5.1785995594015022, -0.92989834683073824, 4.9223541328994118, -8.7057022479286399, 17.760440799481636, 17.787533071324635, -8.1769852252068489, -7.443610161232364, 3.422793078291595, 2.8973149573361447, 2.5062863679550946, -13.842970406261704, 10.43908252088681, -13.66808584621683, -16.782161048866346, -2.5596649370727707, -0.11744470307530414],
                             [6.2437500341716072, -8.6827407279256317, 19.94185071668295, 7.5677069406412114, -28.984170879129021, 2.3718097396060376, 9.7239581946945446, 4.6569530266175594, 14.336147925012186, -6.7052343020367191, 13.669729201853277, -24.358540320507736, -20.889974840956356, 14.667095184536759, -13.092389332387311, -23.467538946169142, 7.4181968649988166, -11.516960824802027, 5.0116824595914551, -23.47458059082841, 16.223758941035506, -4.5789672623238289, 2.52495698658764, -13.382926011674559, -1.9847720664126391, -3.8108979338872313, -11.033593016729766, -13.445653122930183, 8.7320385031027286, -19.782332439681273, -10.932121628812121, 14.990025438672312, -11.210094086135191, 2.9830035071054608, -2.4103842070068398, 5.5813593237671366, 15.125961267527233, -20.6996263357529, -5.7997589435383556, -20.827174482212339, -4.7172795427222267, 8.037546232819297, -6.4303979518647925, -11.559219017488802, -12.066459237725162, 20.906008849697233, -22.993585792381953, -1.9197386594704686, -2.8592363971769315, -10.773557918933669],
                             [-4.2436057109975174, 7.9249522790157911, -5.2971591204035189, 1.8112564524364259, 3.6136857235342568, -3.8271328020538466, 0.89106587815862048, -21.669638998760718, 5.0142024529141098, 8.4770701026361515, 11.767233735289127, -1.782470200128591, -14.82609939008408, -2.6229035656631585, -6.3236036724823004, -7.0243187856040805, -8.5867372799001487, -9.3226462339842353, -7.5545548988826319, 2.5766357381856895, 7.9100873527315292, -10.677551355702766, -0.99340117175607956, -4.8900050528512109, -0.78500006931864785, -14.799952281688055, -9.7858286157311056, 9.6640400639847677, -3.0125441252533607, 6.4716220440850929, 14.922154964680374, 5.3257045005059727, -3.2569970274348359, -18.220084686044906, 2.1506135302063076, 11.54667039434775, 0.79661728247757457, 2.2690690543550032, 36.693206834625343, 5.3964197177256787, -15.46777441803424, 2.2843579192307191, 0.8167093806178034, 1.5542106286229918, -1.8794889292606627, -5.6808954904639428, 1.8699136255645374, -12.887866293407122, 15.175742391745938, -0.45723224603468637],
                             [2.077337541975055, -13.102985964931696, 5.7226715756010647, 7.6794802976238596, 14.092548328022417, -12.252053657536337, 8.0665494471242916, 7.4447206434906699, -11.867464308773448, 4.6950010695371498, -3.5816307676070966, 13.247309005074749, 12.296499262399042, -2.8295866266544101, -0.071419425467687092, -1.8851346447514277, -5.5291996686473839, 3.9005932800014333, 12.961575351421141, 4.8880226811231804, 16.676964496752369, 22.385157177130452, 5.213213121320492, 9.1047470130666159, 7.8526619264352471, -1.2082971438655976, -18.498062863391674, -9.717267223603498, -10.371020305451964, 16.008661949246914, 7.9222334161616663, -5.449552857051688, -0.45259921010800386, 14.891198351872289, -17.34870296402562, -1.3892270633043147, -0.31640211004814267, 19.734657606505191, 11.646379044984901, 3.1328864417392399, 1.8348130596556476, 9.4474645277178357, 3.1957383178004641, 1.5414756002151506, 12.969904996707839, -10.468951237783152, -6.187758469173021, -10.302866356263456, -4.1953779670961104, 21.297551957309075],
                             [9.7079064678373541, 8.7845598870205777, 19.599736559255589, 3.0746256285668023, -19.867725643697721, 7.2056764171384149, 5.1663132249885306, 2.1350854247988367, 2.4654309299839823, 1.3036014885239275, 2.6402540336507507, 8.1032312544810541, -17.196900975066107, -9.7342386424979157, -1.2437630462321549, 3.4770083002356316, 9.1376554129831735, -10.740607680100462, -3.3767774662783849, -25.283264831011188, -0.18768684821780945, -1.1313615277816507, 15.044243001430722, -6.0478655937783881, -3.3913084045565198, -3.4075826450729871, -10.890430599610308, -2.9983757072273036, 9.4584594745201525, -11.208097672697001, -0.9813179526393363, 11.483574403795933, -10.74063558655671, 4.4378578974026546, -0.936616929844857, 0.36194985652931605, -4.2287356266951264, -7.2562535242220738, -2.0153638129200981, -3.3039512279075329, -5.5657326416857869, 5.8866163431057306, -19.493411408171433, 0.67484169259668259, -21.558784906932395, 12.531861077562057, -12.766183180474025, 13.56207545277265, 7.8122384084884988, -2.2021541323986029],
                             [10.094110411219441, 5.3053093426858773, -1.5861690911816213, 1.5471553958465476, -10.748664440094274, -1.1216074461909977, -7.4936501087860865, -1.3752549265959246, -1.3345036886333823, -3.6466522846479688, 19.541973073728016, -6.74260046138102, -18.006003213528345, -3.3920678747531863, 4.299060716918591, -4.6225576421885162, 0.87541527306022315, -1.204540857563609, -0.21552456801585682, -7.3063970817379822, 4.5855041227695219, -9.3735871732665075, 8.3155428140380092, -5.6347013208908967, 1.126592880415461, -0.72595234890907445, -12.498081572644997, 2.8608636425368754, -2.8628430976537556, 0.41162406955907738, -3.2428019630173712, 14.155708865881852, -0.32650276287545321, 6.4308467962944382, 3.0522955877352191, 3.0460881011354983, 5.2296152250896561, 8.4415638288277215, -0.57248533647051369, -1.4618261729855813, -6.0683757989597211, 2.2470918836358087, -1.0395461874143863, 8.5134252156256913, 5.2756953150199113, 2.1496119283503612, -0.92270103966454176, -12.651382261341315, -0.8445628347266354, 1.8683434909176693],
                             [4.0611639493077227, -10.780839497137807, 1.570610638272693, 5.6036377906788628, -0.81600912407095483, -7.3688699628037337, 1.17912300547713, 8.5299666724558758, -11.24942665878606, 1.0120841193410024, 5.3253072343929793, 8.1633721659766625, 1.6112664254424907, 6.0781425772411914, 3.3997384302981919, 5.8681449239222454, -10.816676374644047, 9.7982223694554378, 29.46186381127271, 3.5911529340714856, -4.0910985193786455, 19.577634810068481, 12.125223613162623, -2.4029416361436535, 3.0692719327745523, -9.81918173173624, 13.849368901932948, 0.27049939876921414, -5.6303825359401189, 4.3377496803872484, 4.1424456780402004, -5.2201031779386993, 6.8370402075281955, 0.56952542728538635, -16.424091482748505, -6.2817732193571585, -0.33113746015444934, 16.587290246563537, 2.3102853539406838, -7.0581596167992009, -1.0736912749704495, -2.4082419295796651, 8.0009192535646658, 4.0694206330919611, 12.038009707690867, 6.4457146666775031, -2.2861920867932048, -9.0706212795303038, -13.954828567766961, 3.8415769499821928],
                             [4.2663914788938904, -11.155504082962475, 15.096162280954658, 3.21935839194908, 15.335608113483723, -4.7286668781478784, 1.3481739370966173, -18.487470540834046, 1.2316921625336745, -1.6081827666090223, -3.1765401561256574, 4.5082695040361047, -4.0004186925993572, 3.574556398027859, -3.8971972141330808, 8.319005938541757, 1.4489538332310383, -15.15945105631884, 2.3909363477493608, 10.94172427993637, -8.8630067559659675, 14.717775784860807, 7.7227421657561335, 9.0873132834378154, -3.0280166785359701, -10.471840052517498, 14.384041152327359, 4.2869017244899323, 0.98586388758960875, -1.7649560467359624, 10.655178411946457, -17.020624505342216, 4.6753209176187589, 14.551453726355055, -32.953976709712869, -0.31991502055261312, -2.6007661764711649, -0.74745746842615912, 9.7678505084189293, -11.048864834284966, -12.654656584980062, -15.104771139216187, -0.47330134853306327, 6.5316042496528217, -6.6672452713767525, 9.9899517897471206, -5.3572916862370299, 3.8443529064629693, 0.63219738179850005, 10.257218023067058],
                             [0.6586414081932257, 2.4225344804073563, 7.4640088785331189, -4.2998006401383275, 0.36641136364169058, -4.9658095219936786, 12.648036318123276, 15.299353825733526, -7.2370587127776576, -2.0152088779878374, -6.4908759012152633, -9.5789995070990894, -6.5950943431345612, 3.8197373607168887, 0.10904214815719743, -0.24539118957364625, -0.25086875163669631, -7.4424565390014497, -2.7548690622074927, -4.9979081170107111, 15.062489618184078, 22.341791705514368, -7.154917774405444, 4.7123518986278352, 2.1747188302322873, 1.8439890180923293, -17.106085049377864, -3.1450919165641666, -0.12289403836092583, 13.999117276869002, 14.353366729719928, -7.0818474384496293, 4.7519274152197264, -4.382293258856838, -2.3933832871903102, -0.12783782842208147, 2.6684247377696506, 14.975108563085843, -1.7623197489357307, -2.4469986153243544, 8.2773701803080169, 13.110172829796946, -13.258139602686406, 8.6091597599038323, -8.5731869574465911, -15.272609777216166, -7.6914768099538016, 5.8551456734721423, -10.826810458398061, 9.8593016430935521],
                             [4.3987947297958829, 13.141066462539403, -16.003801252223511, 2.312516153238473, 15.9679378438233, 8.1736128196663049, -0.87181772094556287, -13.259668925404535, -9.6377370012955801, -0.74194155460956757, 17.18254979004611, -6.6067664832658055, -10.946884268246244, -1.5996979645151317, 1.796388572727829, -18.68908206298839, -6.9210080071943345, 21.538591262148067, -4.1652126675505015, -20.523939429904967, 11.081500163199973, -6.4456508520908091, 9.3014252336899794, -5.7695157382788187, -0.29843048671687505, -17.886776016675256, -7.9103177944356551, -9.252017835433243, -9.9001437391632976, 14.131892735845984, 8.1614171656849575, 5.8426389516182926, 17.823783033408741, -11.16053269384806, -2.6611982274160964, 9.7705291298568024, 4.448752968119738, 4.603026119028093, 25.590080352463961, 18.926648853816577, 13.491199989973339, 5.866768716257269, -12.586100111265198, 8.5654636249075384, 16.999315618894354, -15.727771930520985, 0.2263279442726005, 0.88291343727299676, -1.1890132405709677, -1.3682066931907308],
                             [-17.551245788670244, 1.4423221138105582, 15.246950717833547, -6.5562386958100225, -15.801311376611913, 4.7623426186883755, 3.9457920540958824, 4.7906410772607932, 22.021395565628666, -10.773877736493954, -16.554825426329387, 2.6605506260799743, 15.393213896606801, 3.1252484983550186, 7.4711139262527073, -0.48900665199232285, 9.718285882236918, 2.5421695166574647, -2.6967906984089156, 12.419116455705201, 0.6049471882730274, -22.21058352151665, -1.1948665628402151, 3.6115226910734579, 14.916389910306606, 16.432771165816334, -10.801596129698821, -11.388802189170347, -9.8863039772657242, -9.3008967720623446, -26.8712906494316, 1.8084444317331958, -31.573192341355671, 30.197930739482416, -12.881152320223269, 2.8693181252090119, 6.7236519996331303, -17.934010867423972, -24.836877979058237, -9.3074378934700626, 1.3578866892336587, -5.7385653118828879, 7.6152433738743426, -11.38711168934395, 2.3923743179220613, 17.202494134304981, -10.470622933468711, 4.9187455673330414, -5.6978909082155464, -1.1585394245982392],
                             [8.4497455173574707, -15.610480710425392, 1.0961753137867314, -14.710028798488004, -25.163113042823497, 4.3043382850294316, -9.2399264906134011, 10.107579283616833, -13.786762209489671, 2.326892742843143, -5.9341151173471856, 2.6676742599003789, -24.530081127257166, -13.176510003985774, -7.4103591693534909, -14.46341795561176, 9.3496882773894576, -0.33305880489481454, 10.967871936574452, -26.131176982431413, 24.443809309691339, 3.769191013043196, -5.6110359133368766, -33.572972314504284, -8.3850892626750326, -14.531668498391682, -26.120899158103697, -4.2720253872224001, 3.4931250368103708, -1.3414806564392472, -10.040621636735239, -4.9454179155804203, 4.5989561781788231, -14.331242595119903, 3.5383578333273222, -11.463829529366793, 0.92790376110868644, 21.859047007523763, 9.9602322911944121, 9.6079251091790177, -0.41659725945330311, 13.971695600556842, -3.4232244885779011, 4.9863759761070865, -4.9758688085572285, 34.844542243762326, -19.637641214621336, -5.5731200719219585, 3.8626687691220729, 3.2288129857358845],
                             [-10.395064850378466, -0.66322512251766674, -4.5957517967666961, 31.88268958523653, 23.51983879012937, -6.0665042095381914, 7.7329413719602069, -1.9006323442786357, 0.76750322611292598, 5.9417205613339217, -10.043155979113276, 4.998965021103924, 5.8088598372166027, -5.6519854717256575, 0.86369632120616668, -5.0021725034652311, -12.488376600259754, 3.7374069827745853, 0.49640793336890132, 20.345798798800406, 1.2575209855027303, 8.3262750070661777, -11.877655009456994, 12.768899627043567, 11.268940806998144, -13.564960003623542, 19.950429847817787, 3.2072235313519633, -1.3604213229415016, 5.2540450255947944, 14.642733867619421, -10.885926803661327, 4.9607571222987348, -1.2611529670691632, 4.3414486109598354, 8.9423077272370364, -1.5764116246365223, 8.2181060631494702, 8.2581507778542438, 8.2224637099040745, -1.2139418391780494, -7.5963846510669102, 11.798616784026599, -18.067023819177358, 18.685908080894972, -18.592287404084122, 11.529236951836475, 1.047841057248013, -0.37397764063251399, -4.5374788203799081],
                             [15.794179126888082, -12.99909574682793, -0.16622391082363663, -22.084856144762615, -8.0269341374961432, 4.1429615233037014, -10.632842445170175, -7.200741349029089, -13.116804836438147, 2.5336469847730703, 2.3857498675219162, 0.62541456105347226, 9.6582488651383258, 9.1439299556457314, 3.9456096319648339, 16.616917751884035, 9.584697635805723, -18.907273067801967, 13.703077176805868, 11.126117839039599, 3.8424741740217137, 19.145936534523166, 12.467515883016212, -12.261136778423575, -19.472125486837232, -11.455601345360236, -8.1354528565596365, -5.5108937854444626, -13.203499372284075, 1.3705580078995176, 4.0959034366957709, -15.575762042218312, 8.6643377274609943, 19.943489122170988, -27.06512711723704, -17.872250146814778, -5.662696371303559, 7.0214163446749733, 11.481707374706405, -0.95598025071928217, 4.1937748869495213, -1.6683215226812582, -1.9306666310694882, 12.423430250190076, -7.8913915154998113, 34.331316564346913, -20.146636782892148, -2.9707349269535426, 4.8853971752941385, 7.4419439508481373],
                             [-18.170318385506569, 3.9228994595496558, 3.3428550510063411, -13.242983247490248, -8.4792515181236592, -3.3431766424409206, 2.5980466205589794, 4.1717778171082731, 1.0415868352428717, -6.1819040464639929, -12.819079361084565, -3.4539513318084403, -5.3443740313957102, 1.5639834785626889, -3.3646993272540966, 11.695915850424347, 4.3934254576128939, -8.0853669519805713, 10.814792321803164, 4.0062052625091082, 16.892120883885436, -5.602206594400192, -0.40783230019963046, -24.366888289385063, -2.8929609751881125, 1.1308266865112806, -14.290456961319185, 5.8544442246982982, -11.654489228978845, 8.5347798425880796, -16.489593809910385, -2.0905989937945471, -14.215933620961543, 5.9459378483388452, -13.061985941873722, -5.3797417486923145, -1.9013857892484625, 9.2203356696031928, 2.1966300834098251, -9.9872958662929623, -6.8969520724259334, -3.2525865203138382, -1.3450638628368874, 1.5536240759673736, 2.5015195481097314, 33.658729160479986, -23.35584411462197, -4.5872699652745297, -8.742101351433309, 3.3559002672442975],
                             [-17.580720714438776, -2.4902169368947158, 20.4091719828299, -4.7299216123220589, -4.2767083091659908, -3.0202882860694658, -7.3703886908288574, -3.6327610241234956, -6.8857696161284387, -22.330004658284423, 14.114705462222462, -6.9396006125803966, -8.4517222932054761, 1.842917261692421, -0.51134036586232767, -18.719019709749805, -3.7350205559284779, 1.0292168887197022, -3.0012404148675804, -7.1554158839849116, -3.4444598347482378, -19.914501521354801, 1.6552391152508417, 5.3921980674294634, 15.292135975369114, 5.2253469772397008, 2.0146519956761968, 1.1647988107734428, 2.0954782143959592, 8.7247577005127059, -20.024999175714079, 35.1812395394305, -10.52294155873877, -11.087106517583544, 9.8724145038713189, 23.914456425332627, -2.079603192366986, 1.8209010203325944, 7.2952400602479548, -1.6336100908089444, -12.719147769648977, 6.6182055866969227, 12.11776716180276, -12.501576207502982, 7.8114040802813651, -1.6997666189499225, 15.487629657941371, -4.8699825323424353, -4.0290773971170415, 6.8082671354357434],
                             [2.0991564091914752, -12.649440958011066, 7.4401149978132146, 3.987750957096571, 9.6720818940903168, -0.048172276396167391, -4.1310101697966246, 10.89655751388548, 5.5549558153657266, -10.632956375028881, -13.753202234577408, 0.24780259982806663, 11.287398472587039, 19.794890379776589, 2.3276649614451888, -6.9466425026865712, -4.3142650723151865, -6.8035247011857312, 4.3557171488525537, 15.551987830499042, -27.19428844603242, 7.5177663537508561, 8.5760457242812507, 20.690190797170629, -3.352860000819387, -10.458270748204098, 21.137244389563229, -7.2718438194082795, -6.8946887741472125, 5.9386338565073427, -3.8864485608237169, -6.3422410686428794, -4.9676649448857031, 12.065408167851432, -20.587372790652871, 2.1401344463090468, 1.5539464874349362, -13.203922247959962, -13.033273955436391, -4.9048186949635468, 9.5628651276908343, -9.8218716407531588, -6.4297774116443414, 12.710269702054525, 0.66849986972878739, -4.3676919331454069, 10.703062354663455, 15.242573602652342, -15.598025489170297, 4.2946794573779865],
                             [-19.548760612188019, 7.1656577571581348, -7.6103117561615541, 2.5560916071798934, -1.319500921192861, 10.097493784369279, 6.3980904221347146, 21.293511419904586, -3.0623478189670923, -11.516706626088835, -24.913346089754562, 6.7744918539739558, 6.3300987600282417, 9.270897909609932, 5.3827423415933593, -26.817371509562488, -7.7053014552333483, 35.256584922702878, 8.5558924069909761, 16.999565216455196, -9.8140065979020985, -7.0953305655475942, -14.696026578813335, 9.2353025683834709, 15.252976342770156, -1.1856638691139365, 7.1988669358499155, -20.200994120126943, -4.3442068600976418, 14.334213700703945, -17.997681206601218, -2.4244860058132267, -17.740958174706854, -36.865029982908844, 25.074225124617904, 1.7967413104509566, 0.71254798865133739, -13.485033690280906, -20.499044016531098, 16.457485478805612, 13.76578833957357, 15.64466128870732, 2.3911095480228299, -19.264881401710714, 15.789259416291831, -1.4461856079118105, 18.689108044453775, 22.564257819566073, -1.4385737529822555, -2.2026753956170912],
                             [21.301867439868531, 13.663553977402831, -6.0888551005079474, 28.732042471597318, 4.4119827036177091, 4.1652454853885397, 18.015109867327975, -10.169249854885765, -15.123529315179525, 6.2239798906229451, 16.743521113515591, -5.0983718006873762, 1.3304657110136695, 0.86933242490273144, -10.897418166519618, 7.2506105652603727, -3.1611050269871308, 6.0374776388715974, 2.3908090118291989, -21.477402089614408, 11.499301413506464, 22.587799754444006, 6.9070512004582127, 1.8964997215565296, -0.67313851275473313, -15.574139662166166, 7.5264423651179957, -14.588427220930035, -2.127281567678784, -5.9797566692863811, 16.060042114745233, -1.1898581678036295, 19.908532501081218, 20.58511469940774, -15.4034698470499, 5.032244017110564, 1.1044639382293462, 4.4161914899085337, -4.975307389508969, 2.9283100639786834, 21.60901112213504, 0.44947073844637481, -11.20638888140196, -10.327085693479177, 6.532303534201672, -10.462868441189501, -11.435690913009257, 9.0407748560222707, 0.61565396972993236, -11.468702503518463],
                             [-13.3469225646807, 31.654489933800395, -3.6128312464947467, 15.846637420933162, -11.22951144000846, 2.5761246470846819, 18.512260049226214, -6.625327717409303, 7.1967926495552454, 7.6260710621941428, -18.496515709690154, 3.9163126466368512, 2.1735784179645159, -26.740162228301859, 10.427823866941734, 39.634083797237373, 11.732205378048583, -16.220214081322265, -8.2497729850623962, 6.7776666172100768, 19.096050254493893, -15.828912517619433, -12.989981182259086, -23.854566750077034, -2.0256962319568177, 4.2487359989125997, -13.614378855373612, 22.819977887833961, -1.0347032104868032, -4.9416604775206086, 19.358564234463493, -12.570542223372399, -28.353405043831145, 4.1181531643784819, 14.128480676858453, 0.24089029230404591, -0.3344084497283708, 6.3474748770598861, -1.8531777207965767, -1.3474560096999597, -10.990026581277595, 11.298009482886572, 6.1431447715873571, -6.7545297528859898, -23.548011311918483, 13.140525355731027, -13.135009022336426, -1.3716869689996274, 18.841945205075284, -17.319146721153267],
                             [2.8644561878355868, 5.6352757781735008, 5.8013263271129354, 11.478189469017389, -2.8108460357166498, -6.6067888355426563, 3.5334145033619717, -2.8773535539844501, 9.9800150875100524, 1.0585863369831681, 9.5893223478198841, -3.9668770950035266, -2.4236444294891566, -8.3115396841085705, -0.36662919234371594, 20.099050266780321, -4.0473659321796784, -9.1970758280212355, -1.2938075627156589, 5.579196121056782, -6.5089258960993881, -4.4216974311282149, -4.4511059577269565, 2.4488506431861889, 8.6042217299174322, 7.0154983699376467, 13.266093459913952, 21.240506611924413, 6.5581878181046482, -11.710942889346743, 18.673268427051529, -1.3763001243337276, -1.8707753030457916, 12.909663580685304, -9.7739657858981452, 12.731029839256342, 0.2469672747775209, 10.524259090251126, -8.7386485101565778, -16.462110770991298, -10.03776900684503, -9.3795755500045814, 15.183376982941411, 9.4531008170799584, -15.448410668790693, -15.761065859788479, 4.9670861983780386, -13.425828940393618, -4.409724109078442, 1.3119825288413451],
                             [9.2764108538608578, -1.0356459610995852, 15.152433686587319, 3.2860932034725741, -2.8717933680866929, -4.91458175840721, 7.2299193397779851, 3.5949653260465904, 11.092123956953591, -16.55876826402358, 17.242019199437962, -5.767638275695119, -3.915463085684955, 10.024432734462495, 4.0050753298370161, 4.4266298093424092, -5.2827443811606116, 19.247488464888619, 12.353206721879257, -7.5258728268847666, -4.1957318930638365, -10.707373527077051, 17.339325384624196, -3.2256122316463141, 4.7548596254161879, -2.9745962831920827, 6.2566795080360116, 0.62713462033299472, -7.2238373964892908, -7.5435888731722658, 3.4395744793209224, 1.7325514156585653, -16.468352926212983, 22.464716284190764, -34.695150055254651, 10.843329612459353, 3.2896026190833947, -7.7028789595928115, -4.4407148124141456, -15.621971106312534, -3.9407102129840479, 5.1089289534818958, 12.549141226197762, 8.0579827461266156, 6.5215603781431462, 7.5759974240637495, -15.433817019924625, -5.0657280889960994, -12.481701971260396, 8.8388993123467614],
                             [-5.1347768693807394, -0.76920573430774952, -0.16937091456499673, 11.585992649104377, -10.43996824077062, -1.9867640240035933, 1.0342624948701349, -1.1762511472156583, -19.645069998914472, 11.610711483503168, 1.6698684334614757, 16.411124472670441, -0.92112228620272329, -12.635166529715056, -1.6962646341529837, -1.5436423635006016, 4.6588965126513262, -20.720811079667055, 2.2142313247147625, 5.1560681375859003, 20.494574454521636, 20.897153078520077, 1.3053046108937911, 1.8973209892453289, 1.8531322490494722, 1.1077806419682046, -29.65540612294981, -8.7671334933945158, -4.1164264026446808, 5.469384833148494, -3.192601125502716, 7.4116729315561178, 1.9996960840063658, -8.4705433932184331, 25.316304421781116, -5.0376077834009374, -2.3656466736182939, 19.966858221846262, 14.236576712591019, 8.9038700954598582, -6.9714432353355003, 1.551295658752359, -9.0571330203135787, -23.872574140270043, -2.1902585677520099, 1.677663394537644, -9.0809503821381838, -0.73244419192897992, 9.6290421886386728, -10.716349479793793],
                             [-14.653940455661589, -10.557461488165728, 8.9168006632202133, -14.261717457312495, 3.8632649921964011, -3.475091169735347, -4.2230143596112333, 10.610427329516249, 9.1609566421462247, -3.5590963801549069, -27.18297690417948, 7.0776988659492872, 2.6739007011813598, -4.0425300715980272, 6.7057183440910366, 14.676317827496581, 16.636176510873877, -28.918827000110863, 1.9282333883437992, 12.83222244838079, -7.5764040163498541, 19.169775668909995, 9.0207913757754739, 6.7229148588563996, 0.25967671347549059, 2.6714570200361014, 5.2705713769326348, 13.496764355882487, 3.3820356117596493, 4.1766410023619471, -1.4262634935614871, -7.2911331736992011, -1.2544306757968799, 5.6740165815107551, -4.4823066663942788, -23.148399760722707, -0.26541132095555597, 1.758541490555787, -6.7783940340354309, -11.436235085129878, -12.030077938491331, -11.885285025656023, -10.874117472919881, 15.217560898373556, -7.1200146391569952, 18.173259701447545, -1.2853150559390403, 13.297039299796298, -9.0627418987991621, 5.7667301692689641],
                             [-3.7193585485435179, -9.0753142299797833, 1.1251338081497257, -10.45702179159221, -9.4741046267936557, 1.1345207905692485, -8.6168334189938758, -2.7905569653807309, -1.8819229288130701, -5.4062957315835307, -0.29567155969810821, -2.5366611050869632, -4.1531954935337101, 1.6950913006523241, -3.7308459147854576, -6.8429966779187081, 1.8564631189023137, 3.7199406825937444, 8.1613698691937948, 0.29601816501588607, -10.3058531868198, -4.7183747594626535, -0.69497518117912482, -10.348391855181864, -5.5853584149880788, -2.8023785701876061, 10.752047078982972, 4.7872159940182755, 12.37200067507221, -7.0057064452454929, -13.540971692757759, 3.3291025133794614, 11.561970799716072, -7.4520325140509938, -7.2699545675795205, 5.2656113242814353, -11.133889896148958, 7.4675509524410817, -2.896187958607273, -0.021785072727244337, -11.047768206379885, -6.159682708993647, 12.127941668414239, -2.991086564933402, 1.3313719984068784, 12.288048148850534, 11.996069761058459, 3.116331476183813, 3.5675385528750159, 6.2418266056654952],
                             [-12.493731313482023, 14.536226151760706, -15.400188662901742, 2.1866690005711789, 9.0198685030916224, 11.443821240151117, -6.7721228567922438, -11.397388229074801, -5.9990155271755397, 1.0788235261014545, -25.729538735717963, 3.2870052383441539, -10.88367882313937, -1.5203171993478002, -3.6449819777811978, -5.5041440618988648, 1.0435230957862336, -13.329457126306171, -7.9785475293505943, 5.5532922776347098, -9.5064113800771519, -8.4470302414831977, -9.0303716760629698, -0.40691101315111355, -0.36641097173002346, -20.414303302508056, 20.541460892794959, 4.4849348111295457, 0.61975996109416331, 12.015220527160494, -5.9606442228743042, 6.1918340088159569, -3.461710517051662, -33.51732053993296, 27.309576782305196, -4.0314287508389528, 2.6261653421699789, -5.2385520982841696, 9.0651267737721, 14.606325126577836, 4.0276137427462295, -5.2992103605182326, -12.926443508349116, -2.461798442095835, -2.5898794194628754, 15.340797501655731, 24.908515388384302, 17.509798578016284, 7.6526246734293677, -20.801111494065776],
                             [-3.7951748183925016, 7.1925923438343302, -17.166288344748182, 3.3949382091629081, 10.124071259318145, 0.046196455340963616, -2.4658306262083052, -19.815572280714935, -4.9314251963429685, -7.9418507185761049, 19.342154037015217, -18.806133167694806, 3.2927218572694619, 8.8663445361261122, -5.3486383306893872, -9.6760669720098278, -11.408655479888548, 9.5191201568086647, 3.4783801242415677, 11.589487259467322, 19.220529187299537, -19.753951400193699, -14.240519731651464, -13.246048227007728, 1.9471033744999489, -0.90934774347485203, -18.314215622732132, -2.9640377164976335, -13.395165960442409, 9.2411909143314297, -13.557772693991655, 3.2308241711140009, 1.3916893096047551, 5.8197414656975912, -10.591092647014186, 18.794555054123084, -4.7220144481284292, 13.815731006452539, 16.623196395102134, 4.2329826452994874, 0.27726752746851602, 2.8708904567189184, 10.302719863442409, -9.671814413542613, 14.892532525350752, -6.3608431486880423, -2.2578574053688749, -23.844652302388894, 3.1976365222211554, 4.1525970042055187],
                             [-18.069606484326311, -7.1867610266964252, 2.2026028884167457, 0.59430760643549774, 6.0031676547592401, 4.3208568214256111, -4.6335695548019302, -22.389839154537732, -20.629568576874025, -0.28664141108225571, 4.6453276083327033, 0.596382423129179, 8.5681523366556291, -8.9618990380128611, 0.97801318036503915, -10.942282388462077, 2.0453751550840407, -5.2578069103967238, 4.3477396823733887, 10.913134844365397, 10.531174835291653, -1.5802525925047146, -11.154383364527996, -7.6467196836328402, 14.049318666342526, 1.1964754671916136, -1.2198336508793148, -4.0494858771465019, 13.315015371659761, 4.3973252887363845, -17.252690903163515, -2.2524301011310164, 23.949810850827397, -6.903118964899245, 4.0802339711434685, 7.2516359799165118, -15.736011011097315, 11.337476986768161, 8.3168760892629425, 13.493537404417975, -10.444415553106213, -6.6826112735874315, 14.932880197681037, -30.354519188487963, 16.2669444047505, -8.389100719954758, 19.549879659036268, -3.1222303902324091, 14.727298699819325, 4.7018771984498962],
                             [-2.0947947121140604, 6.8503104762853075, 15.325242420153268, 15.490062211824892, 0.41122263151716892, 9.7487174241652532, -1.327035654978546, 9.4474889792096661, -0.49491397242160173, -4.3888347147483397, -5.7623792649761825, 5.3834211904966391, 16.665414965442523, 3.1791899058095572, 14.631872953725049, 19.949009327263703, -4.7845863194894589, 10.169109702761942, 21.900902345490039, 21.630208335357626, -6.7824076093988825, -5.2859840131767593, 9.9877724901844438, -19.728435341682022, -2.3113153569515719, -3.8755743355231469, 10.80999656950504, -13.361151917234418, -11.938175443957068, -0.21263905230434132, -8.1009381018256175, -16.062819898826515, -26.099918687817308, 16.338804662525991, -9.0749984069917335, -6.2928265862135131, -6.3902584722841436, -22.07794943082904, -24.437439982434483, -2.261716662754425, 14.411720734813683, 11.001575672371368, 1.8033476690474302, -9.9324607483503371, 8.531114426471758, 30.886425804751504, -17.408091946854384, 6.482181143958381, -0.6392056465449385, -6.119015560597135],
                             [9.9286064143673851, 27.740522478639758, -12.769540879426359, 5.949319780159894, -15.790245632230587, 14.457727315618182, 5.0890872366414808, -5.7931973535261578, -8.5757872831418585, -6.5963085271429573, 26.225834175013766, -8.0644812990216721, -10.25282340862651, 1.5219195539285226, -4.3383695404814615, -5.4516729408653344, -5.936501753307037, 21.456870921144816, 2.0004206134028366, -35.222289015431926, 6.7120708388870716, -23.068138530785834, 4.2574146980963867, -16.142480516187803, 4.5093915513465763, 0.98468043998674248, 4.6486863340797013, -3.733123974770078, -1.7760384792164787, -2.8121511155743271, -2.3711005836156138, 29.463269136390736, -4.6048084886559142, -12.310312133436305, 16.950932646908285, 15.704037332246237, 12.482490551241712, -1.0566736953719551, -3.7121467950796561, 2.1769826948313145, 19.147047771746099, 9.4253284674611155, -1.2585294019827025, 11.037181073451666, -3.9820381708068266, -2.4814656457563733, 6.8251983601774535, -3.5580781620086985, -3.4958332356654469, -18.681144413419407],
                             [0.79087662065484365, 4.8685026183757634, 7.0311603970796179, 2.1370888529184993, -7.1397628771921964, -7.6826236862846784, 1.9228950965526366, 1.5012413333316856, 20.825284015537452, -3.8396823390690775, 10.311901445902732, 7.4991782248863768, -10.100370416428627, 6.1052366826762263, -4.4848979755875886, -3.9172236349550107, -9.5584570257987043, 9.657912979486948, 0.55088898231703654, -6.5020750819376358, -3.0658982884434778, -15.354891847871286, 13.078414701951377, -6.6641270448432106, -2.9877083645477294, -4.9598503172260884, -10.098751153158652, 0.87057774295090418, -9.3152376549583433, -1.107554777458541, 3.8398828535649434, 4.5870272583802896, -39.510433753032153, -6.5371608188401646, -7.9864885155115086, 4.6400098941926062, 0.82532481632171628, -20.924150131827936, 16.921008516213394, -11.198053482826989, -11.925149971575797, 15.125411458835446, 1.7247627003251154, 2.6113119019585369, -2.1444527808335887, 10.947071284161362, -20.000294680953189, -3.5754869288828557, 10.644444069213744, -0.97615783872987227],
                             [-16.873545253225217, -5.2256793205836329, -14.966970600795097, -18.044351951374118, 13.095334521795948, -8.3111940640167621, -4.9237574399123565, -4.6735230689411171, 5.5388731816289685, 2.9832880569597888, 0.64117402888468256, -4.5609054828086002, 11.058429938668795, 11.17615743903562, 4.6381146338865342, 7.1170725472570817, -4.5280435200232647, -6.2627295206000673, -3.8068627915860604, 34.111884216463864, 4.9284745317171197, -8.2252164784991759, -14.694351230100763, -4.2506435984927737, -12.538906921933687, 7.4596757523974322, -4.2936488578689325, 8.8193686656574499, -11.362334976454729, 9.040436472834477, 5.0553632853960941, -14.278364828491272, -6.8676542940338461, -16.827411428624096, 20.067187947244015, -6.1195733127979945, 0.49497139596907735, -4.2298882309242387, 22.84815803001311, -0.70723093788938141, -11.442596576097571, 0.13330335724763703, 10.581569241458219, 3.6389211855406938, 2.5680778326933416, 4.1083750711581652, -5.6962712046683315, -16.673924677467795, 6.0435821103428111, -0.18274794698747787],
                             [-3.5650916704020474, 4.1412022230813195, -12.628673973032111, -23.176023162057941, -21.736681084585829, 13.407548541869307, -11.774593528921171, -3.9330425060779146, 10.673199820878629, 6.3389171483923246, 5.6821080727492745, -4.8096026800390828, 4.977408363575667, 12.318801256836165, 11.072997112321293, 0.032191147932004949, 16.566154511004612, -25.400447280383865, -11.448919895856257, 5.0500373000223657, -16.936080622931247, -12.891241852553092, 8.7377493048411328, -11.110058960842192, -28.308912343307352, 9.1288898390539845, -6.1995356511024484, 5.5011949773958211, -0.66221881446623199, -7.6510107601585462, 2.2516918180256487, -0.017724307914280174, -2.0619055831549042, -26.467887162806775, 34.387422807166189, -18.083625872546961, -1.6210584484448196, -26.322879604541324, 11.124653732680585, 3.1375565522583351, -14.155925311207795, 4.6313307836242599, -11.206881413057108, -2.0951671247595933, -14.791972754930736, 15.850374839285832, -1.8887630020325008, 7.5306992815515628, 16.168040902812187, -21.544432070270478],
                             [-16.611223237203397, 12.129262627434141, -2.9393564573833411, 0.017344062543048322, 12.356133171445428, -4.6678529130021218, 1.5004734669079987, -9.9398130434288436, 23.932295529102216, -1.9968396149797023, -1.7130212067503674, -8.9066144599547226, -8.9420336990826677, 1.712897766677419, -6.7280185910622814, 1.8143460274667684, 0.17709594451809318, 0.90053936304243298, -34.333823280394803, 14.079131246914319, -6.3739109309676101, -23.199494093428793, -19.849773392061138, 8.3626222748189463, -2.0737893913202448, 4.9680716473258446, 10.687210067666594, 12.033394916663319, 11.924203878048322, -11.851931560624184, 14.328141236139409, -9.4516655147368258, -12.346971370671088, -8.0013528315863507, 13.513232854303897, 13.258153354234699, -5.2814323800553185, -22.504040178001649, 0.62147997103693453, 0.6521618242269609, -5.5914826797894293, -2.3570131352062798, 4.0346805095727749, -5.2119749759434688, -4.6082348665627535, -10.473855520995848, 3.4221485321593192, 9.3861594876233649, 15.663006581486361, 1.4890275213062385],
                             [6.3073753158465653, -1.4699598901228459, -15.345297532545956, -17.665862180448379, 5.5186918675567167, 7.7492860607290224, -14.542227050330737, -13.396325561134296, -12.633271258515101, 7.7830282191921798, 11.819733100536739, -6.0489492637835554, -0.98128753420241654, 9.341097572492048, 2.0713476350885824, -3.3423230499197558, -0.025820394421685572, -6.679478001901022, -7.6633555968179037, 5.881782553783828, -1.3152005107553728, 1.2565015186857065, -2.2597245468050779, -4.8999207217935199, -17.491938019993555, 1.9638034361170382, -0.86906211610720152, -1.8416586218618032, -5.5215126094121567, 7.4126619814338479, 18.176864831595477, -11.793041356822096, 23.5578916106573, -18.821751979561672, 10.358730437408248, -5.5897849127336201, 2.527310866303806, 5.7275635508514542, 26.718776098309629, 10.902542984654032, 11.455755150031683, -6.1550798190953984, -10.067482201558972, 17.31588182932261, -12.160347243366029, -2.3995067684092248, 2.0270867467819107, -8.0376418434375179, 1.8042212627850915, -4.6115651274915015],
                             [-10.520196553711283, -3.4426058738705776, -5.0598734618321934, -3.4912443374368749, 0.96660034583841115, 5.454415450048951, -17.348817535154716, 0.90314179900376179, -20.052794434858697, 3.7188787195746422, -12.74065621447815, 10.935895593497209, 11.532787847920652, -15.130980141223603, 18.78656336962522, 3.4204237098144583, 1.1368087353511018, -2.8638477446831136, 16.732318863280469, 29.09834475241232, 13.708462998945386, -2.1796485676783592, -3.447036151733756, -18.881075639269127, 6.9511610148923841, 11.630545718470627, -28.334325228189062, -5.3716816646596914, -16.306570862921362, 22.365321878742193, -23.562451531163127, -6.7860141683061803, -5.9661450753167902, -2.5660094342005419, 16.094457388644877, -14.489676026415957, -6.372002682233199, 21.920362004808833, 0.93320674765479306, 14.335272178413868, -4.0165775866983662, 4.1521883234864063, 0.83208723764329506, -7.8629469000926839, 18.812261774466517, 16.28310382618433, 2.4589595141549161, -17.667225623043869, 5.0134714285299191, 9.312390972660026],
                             [-7.9364753617960506, 9.0754645038030759, -15.968794793960809, -7.2212040922870147, 10.266705620936881, 7.514973462735921, 5.1529437039372228, -4.812632319467876, -10.506267854536759, 11.169648377410343, -30.241995889703816, 1.969478714309381, 6.0059800023877052, -8.8847032061521887, 1.5531578351013511, 10.493195351806529, 9.4193412458384831, -3.4017883590323983, 0.51572716417139852, 12.96644187803758, 23.352686125983329, 3.3957887977378007, -9.1020844370117242, -19.214836137886724, -4.4335014327667306, -4.9247848011566271, -12.223125551352481, -5.7020378482055358, -3.9763995220509116, 15.828310648277311, -5.5957562052992946, -19.540358999009154, 7.8979170151509699, 1.08953818272714, 5.6935610761104369, -13.133618744512216, -5.90184049074049, 4.6545235668668301, -0.071809385285044783, 14.551352978459898, 12.094611702039865, -1.8675951006934155, -12.199246977442822, 1.4414192316731675, -0.029581060559930289, 15.113483153251515, -4.4040935237011531, 5.1557808016050171, 11.226703734360843, 9.0895335959601091],
                             [-13.063876853055312, 16.627778347208203, 1.3775178737548419, -8.8362920746231524, 13.45335499072333, -3.3460877277871379, 8.1516269564861705, -11.564419069280957, 14.982576124782744, -10.167741580704963, 2.0663884887419579, -5.8371183938009175, -1.9532827557116121, 1.5931234498171465, -6.4641238020643943, 7.1288668865793987, 4.435810118022423, 2.3549068967575044, -19.023222779074779, -8.2424238951660271, 2.6088905628293189, -16.966074596316371, 4.2240594838667169, 0.36937323462668603, -1.8309529050428397, -2.0823814106169634, 4.8553469413647443, 11.235998209114559, 2.895867676116298, -1.0531741595033928, 11.158196564662116, 5.306277130626027, -12.158041995527146, 3.4511111543358686, -10.54142639794107, 13.614302913524762, -2.9660766867934889, -18.050979559354062, 2.0046361636590104, -3.7397202877708819, -1.6750949115575189, 3.5048292549448474, 1.4308044818392589, 6.8728801821946242, -1.7574554166731118, -3.033317644383335, -8.4514645542383597, 11.142920058905528, 7.6189977167861755, 5.4849777463432892],
                             [15.141716151773455, -6.4675894456346397, 11.137371644568525, -12.04160483933744, 14.868023429245563, 5.2651981818481479, 3.5343219925485347, -12.291528559034534, -18.531902443465246, -8.6023424910606607, 13.298498058252033, -1.4188952456801163, 21.691383582868262, 5.9606317685704902, -3.8583699583026858, -1.1874406827541391, -4.0490845916346858, 10.104304674400545, 0.68940342690683154, -14.219955274205141, 2.5084376275590627, 1.7283478900981484, 1.0967154979515321, 5.7370355213777939, 0.87088699515177082, 7.5799916796062616, -4.5517927186383353, -9.4518521416280343, 3.9193092433424974, 8.4093362438466599, 7.7951352963682101, 6.1035546410230399, 6.4590558357677077, 1.2199270546797656, -18.160189603345106, 16.069708567929556, -7.756301011699068, 1.8353381381313207, 10.037470931661975, 1.4759919920032485, 11.35747390523113, 18.755027006957622, 11.080421708127849, 9.7132225342475973, -11.407530000848945, -19.932038573881851, 8.9023015705011748, -3.7068490210690936, 6.2662326243923747, 21.063730894904701],
                             [-0.091319717744417606, -6.0824570747869604, 2.1105143917479419, 1.2670869449993236, 8.0936372020549712, -10.236266625126305, 5.2313250951550803, 1.4442181390025062, 8.1310291051508621, 7.6050777897168835, 12.566264583544466, -14.676878074536555, 1.0407997839863845, 4.5539322014352708, -12.732319277931502, -1.0282032139396979, -6.7055504389639218, -1.7919202416057574, -17.490984882570437, 5.0383117122330887, 7.2705787802972779, 2.8609378693338763, -17.139782576096039, 8.430462392905147, -0.94412558534451474, 7.3910128146132532, -2.093567964436057, 7.6033546221752299, 13.350846110227646, -5.0693866029466461, 29.4319180661881, -5.8283886564636518, 8.0024794480457366, -3.3319747228115442, 2.2519662110708074, 15.793602228444332, -4.565377825592619, 1.2542423044321094, 5.4993780460520121, -3.412080324907643, 0.11327671201245637, 7.8595084687556502, 11.756945864086301, 2.8187697031478014, -7.5663186552305213, -29.164312449014684, -4.7092924750564205, -15.063113202558291, 4.5044986289038871, 12.299446131791312],
                             [13.806887431213989, 2.3677264191402103, -13.058421832734615, 3.4021545885534379, -11.180784675161162, 14.20839465765912, -17.421340633142925, 3.9640560362950623, -2.3778138131274642, 8.221462987250538, 9.1442114392939615, 5.522304605198519, -8.4935825702063301, -11.135389270357082, 3.4014388817674055, -12.503470680081035, 15.921108297182727, -13.95059963880184, -13.635532034410609, -19.190321679661992, -0.74317297211267264, 3.2397599664509977, 13.605144948855457, -4.5576139635937709, -8.5588836607248524, -1.3190904551246987, -11.288354209959804, -5.5554388908911365, -3.0227858947442461, -4.4735161241143286, -1.7808929194412622, 5.4909962300785047, 15.666869355218941, -2.0998514824813439, 32.215985063134433, -15.567946701469264, 6.704629529671954, -3.3250955382616461, 3.1706875855030123, 12.519861889909789, 1.3214688626116373, -3.9003513694682077, -18.602172323915354, 4.3821140032955501, -1.3039584198209395, 3.1016571393353853, -1.3104733746512203, 3.6182197641939813, 5.6022186084892773, -13.595839750334992],
                             [10.389614533652484, -7.0816116436249121, -8.9301321208939193, -15.31015104708699, 12.016931952439279, 2.8854157870110981, -13.91954328057092, 0.7199078659312087, -4.8773375997431989, 8.2678170210502699, -19.109815479652866, 18.503073065714936, -2.1466859749821983, -7.5083772539838529, 0.16981299672109323, -13.956869048538289, 7.2907086846478508, -2.2627028843537205, -14.333295341070938, -2.8081240962478762, -11.191541835731392, 9.5942686810935012, 5.4993890246617099, 16.475148615989209, -7.8534877818750815, -8.5830342310337286, -4.9738753975186123, -8.9542921321205942, 2.7699389038144409, 6.2999272340356338, -11.850737276706374, -10.566827062985295, 14.262852486782876, -5.5868580741846312, 10.481954321014824, -17.279525038185533, -10.296659782714022, -5.6666230661473023, 6.3590777672695786, 21.725452799294786, 1.0981453579922251, -5.0672971172878789, -18.969127431508372, 0.78345114675491367, 2.482665027399797, -8.3844118290865115, 16.447854424474063, 22.69638101866515, 12.792038314729703, 10.054789085778992],
                             [19.357006008504648, -23.895201193480315, -10.986260153819249, -14.324018702482403, -10.347043590004667, -1.8418623352334351, -13.386686722233266, 13.242997245200861, 29.072211337008383, 1.3509145000140894, -15.259339510054536, -0.88355587767381216, -15.035683308608796, -3.0671319718296011, -1.8027943959636403, -8.978175551813111, 21.817876950609044, -15.641369749135928, -5.4937122982554341, -11.841805305021367, -20.215981086524124, 18.981862504380086, 10.781723154067933, 19.576715971330728, -8.4749829372288836, -7.7808131402204559, 14.781884736448031, 13.261821526712568, 6.9326682157961548, -22.9356246944965, 7.6218758764543333, -9.6119386056521634, 23.440751518247446, 21.820679060764043, -14.926781997264033, -22.96806483320233, 11.211991311416302, 2.2728253637179749, -18.426238775084244, -15.076653948334261, -9.6140253632132815, -28.466939501708378, -4.4401987149923565, 25.230370326271462, -7.1139008689780745, 4.4087150740795424, -1.8979031504211892, 9.2493728393255807, -12.338478338469464, 3.3599574898544136],
                             [3.0849033778506567, 17.645975664129104, -13.346111553965562, 1.6091961196290541, -6.0612308050427615, -0.50993917408559708, 10.985096826614313, -13.027747047020775, -18.929580283535877, 10.427495500980347, 19.141259066462116, -19.869157901597074, 9.796734803439664, 20.48169689380871, -3.7787326628698903, 17.481036959836953, -14.910009247777277, -10.104851683497902, 8.7084564088092176, 21.557371590446774, 14.871134970739044, -3.5307342758653313, -20.106313846351579, -6.1347189397859143, -10.430945095641169, 14.315228908023037, -2.9234753981333266, -4.808379509563423, -8.1161952196424796, 9.3037052953723904, 3.421626643964891, 6.8783261566902993, 1.8778530490674346, -6.5624297398102911, 18.243934921284421, 9.1659172990690987, 2.1729034873444704, 15.893079721619799, 1.7209758359446956, -4.9282598823699102, 14.455932122416435, 0.80416343309666416, 1.6502544086715329, -6.5890122539838432, -11.236577440435118, -6.0580002569549674, 3.5355850331795255, -24.282816998858159, -3.2154188156696768, -14.426782920212348],
                             [-7.0797811993577398, 7.161670192871175, -1.3276544086592024, -10.985040500694826, -6.9332170935670243, 4.7035175842490879, -8.8094218382346536, -4.3428071915055542, 6.083626103325054, 4.31468382085475, -5.6550684681797874, 6.6063265991517124, -4.3539702566572451, -16.381723619803271, -6.1165062606846927, -6.7190522935957295, 2.8110817606179523, -11.32403399747194, -12.061878750276989, -3.824209202747423, 2.6757732003382442, -11.68967003654082, -0.022619230859356021, -1.9866189536875742, 2.9244315557368084, -3.2582503017242139, -11.343408407195541, 0.18075199859075819, 2.4889812481050813, 2.8597100261453545, -13.249041991636735, 8.4824715287571468, -4.6632100609866924, -6.7489573818543072, 6.0928964874927338, 4.1463059299544893, -10.212411647784169, -2.3724688774018015, 10.797512057927616, 7.396920205313541, -9.5728063566364234, -2.1104529303542789, -4.5250670329275477, -5.1439007891573549, 0.49398365952420953, -1.5897708514048519, 5.644390902933349, 3.3870331766423742, 13.33515334425903, 4.3140008058445698],
                             [12.065799005812041, 2.2344304252422487, 4.3752897549179863, -3.9381661024473313, -16.635179709027586, 9.0991322235683043, 9.4251090376130016, -4.6448876693046817, -12.198055157874284, -4.1322642093981123, 0.041416887736814623, -1.0512047411325975, -25.611621601085169, -7.0677177209795952, -20.788628361001965, -23.053878215702731, 7.1528849979122118, 12.874001690341448, 13.707315075010909, -46.763456221566486, 32.405537821037875, 3.2294874466305834, 8.4710255616110928, -26.919383228404424, 13.626049375392656, -26.481659284447058, -21.12016786312844, -16.881989158895607, 9.3108195953966906, 3.4148911085627254, -13.95825819877782, 12.45665337471941, 10.207033379601112, 5.344425284739577, -29.088176559017391, 6.6967680211813079, 1.5472345505089113, 11.696342981597022, -3.5878992353707111, 3.6189943451173816, 12.451274866483336, 9.6301297508339996, -11.024753719806991, 11.348795325049792, 1.1524159174216857, 16.003583547487178, -7.6137014386271211, 4.2302085970083079, 1.158944706690471, 14.493449225610542]],
                            [[-17.26772002931866, -15.979306035457443, 42.843366229056556, -20.613253621400965, 31.921129792359729, -33.789374897378238, -59.371627037261426, -35.992194456408804, 59.371798648017503, 16.404466441223704, -27.778206234681381, 5.4826036811554548, -19.480494361123419, -7.8771600224666329, 42.998058915743272, -31.108164669532652, -14.475427076748666, -2.4347966555573004, -40.391719365530541, -41.047083249388436, -11.15050192470633, -50.043374320519732, -9.5184619173468157, 20.956860562112126, -20.721667734794892, 24.891398619161919, -25.802137874497138, 41.883373503733296, -63.130069185958014, -2.6316807306116123, -6.6017641021161735, 26.685632627269896, -7.1429478031698563, 28.78329323211312, -70.613217118884535, -36.000741481236048, -19.618417014812206, -35.289087602865564, -27.094847005094593, 3.0893252721490554, 49.407818991848302, 46.100863513599336, 35.230145833304555, 21.720085734276974, 9.4428646040878998, 31.377053322300846, 6.0164806891623721, 24.146235644724264, -6.8752350969201883, 11.572477208653444],
                             [34.723365855082591, -28.040263030401672, 21.419810435172934, -91.519332728394559, 37.986895336986734, -13.906718780456583, 40.756566493483625, 26.399419571469871, 14.637896077885014, 124.10706344516231, -11.113574198932421, -27.81426710902528, 93.377572409249538, -49.898052763462907, 30.389171460007386, -72.163512832331136, 80.263023043086946, 34.1522302902966, -58.088926316252774, -34.491822532462642, -15.822587717558717, -38.008095662608746, -20.051582911858514, -11.318576202330847, -65.817282007020836, 14.334884491195602, -39.854923202644699, 66.102932760718602, -90.398557118083815, 30.332368753363145, -35.137331920639255, 18.918282063840905, -29.721779290522914, 144.59938127035733, 30.909932325510344, 3.5908269443908947, -17.580182727593638, 63.469343493624123, 34.812316080622679, -30.309900295505134, 52.81584731909529, 49.014080592585323, -45.437139257374184, 26.553998171023949, -50.106251167309225, 67.157377593283115, -27.778322902797068, -9.1655690118513267, -60.024561919620353, 12.868647259720344],
                             [-16.106990871997425, -35.470350314229272, -14.909960567288728, 17.366456699799635, 14.946521148302187, 31.340209060274756, 6.2278591890647945, -20.596450748223063, 24.619506255137569, -46.087550436282655, 5.7988300206402119, -10.855839003491255, 9.0950292961862544, 21.989989286061675, -13.604750458787947, 24.35559461445137, -24.510357633622153, 10.866159138763594, 18.007648419633302, 26.389669758058922, -1.3734820467992004, 70.44690405164495, 0.25017999601148727, 33.114683644484572, 35.221137700899298, -24.226486425899775, -38.194772071460314, -20.864925623434438, 75.838657987655466, -53.907407294427387, 10.30951493520781, -12.679105213052141, -43.749330990939022, -100.85450023564977, -6.6087740484766737, -27.221806538762653, -0.061434564709521133, 28.707669256570362, -6.2184598955935195, -0.58634295365458611, -18.271794206960355, 12.325600732303243, 20.557533201444272, -22.993064849273466, 10.497146744745773, -67.406737603747047, 32.609622417545211, -6.7130040277528051, 0.43609682652272697, 30.877524232467493],
                             [32.800298351736991, 45.302086682750826, -6.2954326572739854, -25.817184531337155, -26.8859483649561, 36.960443448879253, 36.123083426053888, 15.366683102039396, -56.458053560562327, -34.030070783394663, 4.0162808939937751, -13.37120434181441, -25.014536311516864, 15.699916687125329, -40.09401003334213, 18.621265822284634, -2.7866041414171212, 4.1280623974190798, 39.350361091506493, 39.594895619859699, 29.767365757023004, 12.813474641210622, 18.685239064622216, -45.449168456359295, 2.8028528238295407, 10.691614767604323, 43.245063515610688, -32.993260680901237, 55.374668278638332, 21.822129401643558, -2.0052044437460919, -5.4614307822440358, 49.958089065453002, -11.335966781602581, 31.509404102951979, 30.8305691326903, 3.8747440041157875, 4.5367134027396379, 45.369008659322766, -24.324717563953254, -48.818896711230323, -40.919058741094346, -15.59125755866317, 33.749956993997458, 21.860884891430263, -14.053600427838914, -10.885087965156345, 27.640527202536507, -11.401330219479867, -1.7811007283989351],
                             [46.271660647465133, -18.65284147602679, -9.7195916087784688, -12.288096906839286, 1.8757165720527278, 39.162823652645237, 59.672395606977808, 19.273194519700986, -41.828619386626741, 38.377574365526364, -8.1311070583923719, -34.033339764026024, 40.368722733653271, 25.092595352502741, -56.463592895170457, -30.722976960274018, 30.050315867554705, -1.5506332308712212, 13.490927027417607, 28.432119186086545, -11.711447276204703, 44.891237196825422, 0.67347040707269556, 18.369910048137225, -13.132183820862972, 9.0981393236920454, -11.202067084843121, -13.061052712286138, -6.3239908258916842, -9.9996829701001548, 36.13469704681426, 22.558168620968996, 8.2342317752388343, -0.21653720593631576, 29.273010450504913, 7.7991270029470376, -29.718776765451803, 49.20150273886329, 8.4729748844014097, -50.516788965778943, 25.93962549383339, 36.096206489263722, -39.950778965350175, 8.321751413898248, 12.207452166650885, -60.322610995978629, -25.680480423626246, -4.4352446108497707, 4.9989632585242987, 13.7158280490056],
                             [-37.606386627777226, -89.283875784043218, -12.022680703635645, 40.6876727039797, -1.2537745324197889, 8.4309822380661856, 25.763912129156282, 3.9642717891077188, 69.599573671113944, 29.101215716268836, 22.422121533230236, -3.3394958750511718, 44.534639914398554, -14.252871250089788, 41.27047694018799, -11.977013300214566, 6.8164700675890897, -0.67061940923054197, 3.4828598610035422, 4.4090731866584862, -27.607346743254599, 12.328126127862369, -17.017128557625956, 57.353664003199782, 2.1388838501342442, -41.899189258025388, -42.666519327752482, 32.788537818127914, -7.4121246251742345, -15.580368442814018, 19.169102710876391, -19.738922391500363, -66.595620595150606, -15.469597728994145, 12.230185752120843, -19.675951728796839, 3.0295352069982551, 34.376701400596247, -33.173477722952171, 39.895299467866636, 24.444378740992349, 9.407915151868238, 18.096762860040069, -86.011607799296996, -30.739198060817188, -11.82495858949305, -3.9198620221315053, -86.418755018397363, 18.767698750631499, 14.374187483387615],
                             [6.9820427582192828, 25.978549200995239, -28.645007867274735, 35.830710626564631, -96.212390953007912, -23.749835173542742, 4.1584392953179963, 19.918001128150273, -48.304671363576546, -26.214867669196526, 16.929614334285976, 31.101536351947374, -107.33511777172927, -3.6526983257972332, -49.00529867681157, -18.564661973820822, -7.5595606530523272, -32.614703661145647, 64.55791222566495, -32.869048345286295, 3.7475971800528898, -30.073146615227021, 35.598217299499161, -6.2554882221461225, -34.681984957523035, -29.843493640894845, 48.61490596568278, -16.739906583859067, -1.3639032176013874, 43.890264530757108, -21.006743563946383, -34.000817982136169, 49.150900180987072, -20.954211353486723, 53.931400877876335, -3.4317318170564084, -13.211513276319417, -63.941086281814215, 17.587669609018143, 10.037281673695642, -22.149127681965819, 7.9496721910810759, 22.143528040243964, 9.7354053598409056, 41.405654926636004, 15.736706793969649, -26.774682826325282, -25.579408505919019, 60.423291428167317, -20.172411200992745],
                             [-41.431088865917516, -48.027494616375897, -39.380610656837653, 51.726019065182072, -19.550014957386168, -45.095987683844299, -7.242660163492272, -14.539384629853886, 92.376420449182078, -8.1229981680162524, 36.199304326629381, 56.469594005486229, -28.311191664179255, -58.619803009795952, 68.695678462619554, 3.9538022084503184, -34.807675615909616, -34.427151531805713, 60.625136078891316, -2.247159819125327, -26.651542942865003, -28.080298250223859, 33.249658818027129, 11.108592456379771, -8.9201397340049269, -79.625247221667564, -20.329212278086359, 44.52607040918663, 6.6791814206705116, -7.4933701515084401, -29.10093867685795, -65.043892079196084, -59.856396233104078, -35.426928984910262, -7.7992166718973808, -37.391464964834093, 37.99634702086982, -20.2768570277781, -50.950578180989737, 86.323029774723395, 0.7481165642056069, -28.587025881421575, 44.199737026970659, -59.054757267869149, -12.86749138119856, -1.8714790752590575, -27.909774514627639, -82.578508402711904, 48.480869559078918, 3.6750115544898225],
                             [11.035081314484444, 36.193161952979239, 30.968579822181304, 4.4664925114626577, -6.1538582161703843, 13.608364102505018, -12.668259160921778, -19.344671723217608, -49.968737990498404, -57.832434466415748, -23.520227983716346, 26.704495743704115, -74.237612320798206, 38.289779082966788, -60.296874716393866, -21.471051434574466, 8.942684046907182, -12.989866331092374, -1.1767845806101058, -18.153473766368375, -3.9758631291364237, -14.525018117048651, -2.7409955224578395, 15.849883697504479, 9.6947890967169297, -12.255966107817573, 22.760763013931911, -62.709865391377612, -0.81814752642326749, -22.722252960146012, 57.267313614866985, 3.6166591345171581, 67.984889455784156, -45.05511371888138, -11.853785823873199, -11.875183697947394, -45.60487971254647, -63.140827345857097, -2.9790694030794489, -37.388085060081565, -12.060772655225128, 51.15156917092235, 1.0925422395766622, 69.520855385077525, 54.025082561285636, -57.351252290927789, -18.395796383042359, 43.175519558302518, 29.041691286768195, -13.360299934704329],
                             [-47.702671099755023, -31.934403567519514, -14.414728734706982, -22.007161582377922, 42.364930111933219, -10.275950502537681, -0.30356767555812514, -42.166041835990164, 50.81534880292093, -41.692231138721993, 26.344266862754207, 0.41627000043449497, 7.3267548414848349, -14.682803139882486, 20.988914341791059, 15.406404798330186, 16.031659956834609, 9.4332148173390618, -33.282994540004026, -62.290040026432855, -25.913448603326724, 41.229040832191977, -28.732398463255812, 10.655837503466055, 14.181299617672796, -30.56570926011015, -87.059941826260356, -20.982394026128329, 49.936179767791494, -18.981790295711203, -26.182231083081888, -24.60156433282993, -61.375013309663871, -53.892967160671397, -10.586515631608048, -71.167587805201862, -19.852846258471217, -8.1873251334201278, 16.626663151014071, -6.0499909568896522, -28.805395644456866, 52.383731939326502, 48.318545042189591, 18.573235289886291, 15.143200595061366, -45.57311762942421, 26.723537673823223, -10.373614031896935, -59.462590815148737, 13.644044577442209],
                             [-11.533789961335538, -15.697732446666871, -19.682695913694232, 70.28908092363551, -72.820697568642359, -41.39151252914877, -40.992128059497922, 31.189647394239476, 54.777961865680211, 16.936486755634874, 7.9588844628249014, 26.200653446941043, -58.140854523249573, -15.102776245065602, 52.342157107564468, 19.87497299016157, -84.18829798900002, -39.586983769662737, 62.559167989864847, 45.101248319587782, 43.587006895954453, -58.734451320804432, 47.953323888307033, -4.4912694850208492, -0.35986257445795228, -3.0038021718364498, 80.389522604064311, 66.759045201894523, -35.365121219772014, 51.785687490974546, -22.759982680140816, -9.8247538035964652, -1.1751218120547522, 24.005226572500298, -21.463424164342253, 48.807703651843177, 73.386141533884668, -33.39629176648701, -41.110507963340488, 106.84475376443153, 17.389027627984241, -94.486173478501627, 24.891814725835278, -116.09577672160589, -23.60675744365787, 76.960200070771563, -10.796993800971945, -63.807783963203711, 75.856895978466468, -7.9782566916377995],
                             [-39.627456487219312, 60.098557552291169, 25.078964101447802, 12.199714866412187, -18.3195140049835, -12.39669726127506, -61.838346706995452, -33.148709646399361, 24.943921071580611, -121.02140233028851, -5.7190453509253576, 43.110070552790198, -116.90669862555139, 14.384059956263897, 16.908931536892805, 55.419213404266976, -67.995508888517833, -21.930563665374905, 9.4660054711737533, -1.011055762986361, 42.723123739511948, -30.013520479335153, 17.28350133344086, -39.702310156314269, 60.229463748170488, 1.8738364717017593, 40.590448711148746, -41.181358393185143, 55.866654457360831, 9.6932137439802677, 5.5625322918222428, -7.4160113280177056, 38.893722476487412, -63.082786619393794, -68.370799094127236, 6.2876801109713218, 35.565984908462255, -98.512613542443233, 5.4214552710432802, 45.600015227736968, -61.990572718059376, -46.278551524345446, 56.602093437965401, 10.412480088752133, 47.788433298432807, -9.3035570836691317, 10.416274836735241, 31.810638680947186, 6.7395147734935206, -24.96242808050863],
                             [1.5813587511773088, 55.256823133248709, -40.867000090778149, -13.508221321520248, -21.939417106186479, 16.0130861194198, 29.885570416071094, 24.647522164955035, -72.040086811632634, 11.409785852443237, 22.286260820135212, -11.716059941202152, -3.8710323213502518, 18.854424330618713, -71.049664163580843, 13.205305177400058, 24.872634189029171, 11.514187135288241, -8.50138963252199, -36.386984706779749, 2.2805940575969625, 56.49414833786507, -2.9205991234045254, -10.941447935837928, -26.91017436084325, -0.62000413507077734, 19.586177817460097, -60.307537468181636, 19.840273163705081, 15.446054096323939, -3.9017844796680268, 8.4136884081362293, 6.628565924326038, -0.91430994586267911, 48.001591324350251, 32.018219436471746, -5.1889224917624608, 6.5470151625712694, 40.677250794299859, -40.548848548788754, -17.464337994471407, 21.060837973370425, -16.287110841754629, 5.6325994411498481, 15.472462560226859, -12.13278267444143, 5.8856607087852284, 10.638857098984426, -2.006774710703791, 0.010973832177179066],
                             [-12.664451379828014, -5.4940159505292261, -30.807412744419345, 7.0521956904891834, 25.142194520192952, 12.679961055338074, 39.134221090881944, -1.0381456113445626, -9.5408882731476279, 11.079382168207346, 26.287511481637512, -19.44854738431761, 58.298917020476765, -2.1063271011315523, -9.4151779378704372, 42.475770865313997, 27.020042516841198, 22.620568424782775, -2.2141648394396984, -5.0755795680158506, -18.242366190806184, 77.476415183775032, -18.855016740788923, 5.9546164775473542, 10.084181596073375, -10.601988705524844, -42.388756993989766, -24.689606418445731, 50.223160643575206, -28.079135230448159, -4.9714236837970391, -8.1040864274690687, -49.377224951762678, -32.18554569973977, 36.29196847364728, -14.507977143902144, 9.4382418878242635, 46.894887861019619, 32.302232807783739, -19.368437321202698, -27.647829475166027, 12.369142378736264, -2.8987668762077456, -23.368922339842037, -19.020505408955632, -20.016852570689437, 19.091648718196573, -16.485490328219246, -29.598102569542434, 7.0024045323761488],
                             [36.630525368077528, -16.930172868232642, 25.537246028702409, 23.269657915961417, 12.812025168966301, -23.457230474381326, -56.232201028247502, 3.1158150805482947, 16.013308579717727, 25.777552727683926, -39.125595847954848, -25.949973305629797, 4.0837595825273025, 17.331793661153, 14.97424265368193, -19.871525271551977, -38.64708575281346, -19.763776897243531, -14.923570971562636, 51.239862528636962, 35.163028179419243, -48.19618408660741, -4.7827250202917257, 21.585604967277721, 28.556056254584234, 57.491698823575909, 32.863072199378159, 61.729177955574222, -71.478425948929569, -0.13109577637382447, -4.7314100014932068, 47.757043260587352, 17.975017815538038, 60.012924481044827, -46.862574653653951, 27.77929633373089, 4.4079072330273323, -2.5348190064911464, -47.200886212986319, 22.16577207306652, 45.417607569524215, -25.517536673673938, -26.067219350016568, -27.797235414071022, -34.562501269727363, 39.921397400207688, 26.724742988723559, 41.4327678243246, 5.7462430663750679, 5.5073712258865788],
                             [-17.441047034629015, 0.9398571245649382, -33.320312476941709, 63.753907013320578, -40.260439916984275, -22.023914377825669, -6.5344565119594353, 17.102187832776153, -4.3875121849112713, -3.2762399264331603, 24.148841608293328, 27.266740149306234, -36.279834256771991, -17.614401555568264, -14.698191485867214, 3.0960087125919316, -15.049694774363212, -19.920908445545727, 33.853163229512148, -22.383504847908469, -46.36555386305389, -16.308320147166238, 4.5933387257824227, 30.538128207301035, -23.295964686267943, -49.489869795213671, -1.5949277030605633, 8.2329271536397197, -26.542358579932127, 16.538968448388932, 19.827745948893156, -13.124673041122747, -7.8134762846563586, -29.95587303117977, 20.219665451316214, -28.045741383383145, 0.30734584711480906, -41.667617755282357, -33.564799903552995, 26.720200104373962, 17.09868007254348, 11.496175936119986, 30.094986859088955, -24.540866775884165, 18.847661398401144, 0.69147985922131505, -26.474893011041249, -63.600434216055469, 55.741931116193449, -25.916596285805525],
                             [-18.635707010395343, -17.945777742316331, 3.3473508994463526, 25.356800957336578, -20.004207748988978, 2.5739516882822873, 0.54372260631555047, -8.3418950042900839, 15.246266538951817, 10.303608100039508, 12.233085015563992, -12.079001397118617, -7.5270881002798795, 16.249299847495646, -7.1165615763578849, -11.279562693632819, 2.1149926607990097, -15.245218971253591, -6.8956046842006291, -21.901462577498137, -17.328315766387952, 4.1899303575671745, -16.36962097561165, 31.48418283239188, -28.286382645564139, -0.11552465216241825, 0.028611648974994297, -9.1236484695123465, -23.004609068949673, 20.592091446706199, 33.887455224442753, 14.734080923598215, -0.57060657230716272, -5.0046103166473248, -21.741323298331551, -1.5365731881670071, -17.509080539077242, -16.956436947331881, -9.7763420965330461, -5.1778878953252656, 15.987931934901141, 24.05193552098596, 19.07620410547279, -33.735746544023321, 16.485138415536671, 3.2457487964151279, -12.135531265988043, -25.368062726730734, 19.464159334929167, 1.6151634333575418],
                             [-56.566944987422282, -47.91660835305575, 43.168364147910189, -13.549458348078945, 53.870933424109872, -57.142762454967965, -65.846735657368228, -42.058746963682751, 131.09449629835456, -47.384683465122684, -2.0161004900655168, 26.575315055335729, -21.822452279961649, -41.586107167620185, 96.935261067979042, -8.9634297806178509, -21.495211486201477, 0.9076875506480947, -53.564036253630483, -60.886899099523326, 5.5322661970517935, -58.320482700378477, -14.81584773539041, -3.8589302317935426, 69.164408580702514, 3.3066797211970571, -72.669762218837576, 30.391379333139998, -21.214160873090648, -13.500227344851977, -32.39238816942251, -1.5687170392898511, -44.357671569241646, -5.7866085677825598, -88.599443512873279, -57.092310578616654, 9.8656095688577743, -63.76738200084921, -15.229776616613274, 69.815500841060597, -17.900929472735868, 19.935855422760739, 51.821776177478775, 5.1177047602446812, 1.72221167815063, 6.0808158403705628, 23.416366025778977, -14.240380593911347, -59.176467126569818, -1.3007351007162493],
                             [-15.883599794117467, -38.924840955469932, 63.690431900946066, -64.07382729043313, 67.15478782542759, -7.6517406012879103, -49.699393115108798, -52.390761211823964, 70.249691895353834, -12.763250964611981, -43.540311891371289, -1.9421966259990397, 3.7589117393390188, 5.6213049074025871, 74.984424368603982, -21.538820930739583, -10.894299596707837, 9.459311090064995, -44.294302744402181, -14.07464740639527, -3.7697185298311471, -38.755457209088583, -9.8756518932601978, 10.021130202407958, -6.7861731870646844, 28.268877243555302, -51.567318701367419, 14.711428919273333, -30.667237356071666, -9.3555128917416379, 16.274953597937611, 26.457348625431251, -18.086239649050615, 0.74074785391333164, -103.53651578555508, -61.347715973182133, -29.447666865061109, -16.968973775970788, -24.295115420064651, -5.2850452438200453, 32.139436739906813, 36.880254779575992, 27.021836825470508, 55.986511472494357, 31.680605844803623, -10.775007664723081, 24.457008381216529, 26.636747336718248, -49.264174995155138, 17.512444145408445],
                             [43.378818419848471, 88.238033766619296, -7.4890357469256505, -4.818130242322912, -25.212096820934434, 32.29716043077628, 18.833623913007557, 26.035201752912393, -79.202286675235257, -25.691460272635698, 0.5066556631788508, -12.078954429706451, 3.8866855371593352, 32.381842983404489, -43.582599919956621, 48.933489652251716, -14.655971766661748, 5.1314149411019248, 36.340645509274466, 76.088526302833117, 61.129178993210786, 16.888864663624719, 21.231963183779126, -58.9511836935906, 14.500819711858197, 25.92875560966554, 91.078503485886188, -56.107024852290913, 56.424237594913976, 31.94384041148966, 14.486862165945091, 17.920466081835443, 57.541448558592563, 21.199982208788896, 12.799659599535239, 100.27129493149128, 43.85249808097457, 11.746945479749142, 44.374543258613137, -8.0831742325760558, -71.932983798033661, -94.293224158909922, -61.317208721613326, 0.33228147363314542, -3.933702626959652, 22.251048345932002, 6.2705976641484273, 46.726237478987798, -12.631290861638636, -22.0892107501965],
                             [41.196266022084203, 88.157906111335066, -90.067350914998428, 27.623065340948791, -65.512072001699309, 19.240207973505353, 65.616440179495996, 54.629173050065795, -110.76939277268684, 11.414162236771633, 61.33850575771234, -8.0727132207115186, -14.532937738996441, -1.7637180812174043, -107.6691326992068, 33.436841735825674, 12.012169843254803, 2.2865797001969654, 80.706714337804073, 10.665065399321614, -12.029408734624736, 65.280590178972361, 25.650402878983712, -41.734272533902015, -30.071115846568546, -34.660649649531088, 55.859796426121036, -50.037036491972565, 54.076473703245824, 21.824808888615525, -16.21260868550144, -20.280623074743445, 28.452125691895183, -25.060021656846082, 110.50443657442719, 35.610146326153149, 24.30008976870996, 16.244810345470668, 56.77239272941933, -33.163436083711503, -46.193514759336395, -31.618327982594515, -27.703157123113382, 3.6568978883014243, 24.153785316588898, -10.962767572744584, -34.778323735624731, -10.508687199431089, 34.676050511581089, -14.511309466365825],
                             [25.48969615723168, 63.353340664292752, -11.873482259873743, -30.961845808574939, 20.735537935859341, 17.425853243442813, 37.299099955523538, 9.907901051460934, -89.824000718364658, 20.203585363563946, 6.9648935106389311, 2.7356492332859319, 35.92242579801821, 7.3355836584535314, -54.034608467607612, 9.518103061257813, 44.335167437450103, 27.09007066973022, 0.10068130947301435, -12.862302076446953, -45.685862618458195, 43.227056414013475, 7.6416825838869737, -41.649157569526459, -37.873676537097182, -6.945134655937534, -5.2164831006736545, -60.431546409524742, 11.875272064139402, -8.0732679655455701, 34.04982418127819, 5.7900489353277926, 29.077497287727912, -22.934349450634631, 29.670774916222094, -13.234277805454511, -9.9951123063896379, 17.080655270335669, 21.341439844526068, -64.236229632071101, 4.885136787939631, 28.207126678899339, -31.801931083979543, 82.780705297297459, 40.112719410227143, -34.400555031754962, -32.400288067138298, 22.211447925635007, 4.9220962994137407, -19.849357399579137],
                             [-9.3699824122506428, 15.710159954594543, -28.595219103447665, -7.9275473515417492, 27.410761608934372, 35.361783977976195, 53.986099959020152, 0.7265901978097894, -48.028387068062791, 1.4885567594520572, 16.201918564617174, 1.1011550245588593, 45.812619772519582, 18.202202815640664, -42.412996689657142, 22.503068639551337, 41.262036465580465, 19.318096486151013, -7.1667755129831345, -4.5137097433430329, -26.764383454654617, 79.485411890546203, -13.568811738461559, 0.30155836009810333, 1.0668225406537566, -33.735821939561902, -25.124686726167926, -65.747390194255942, 45.480607544492308, -45.142703180177008, 42.989033512494146, -9.4376078695176968, -16.688897950437795, -50.11249713513962, 42.707825456052603, -1.9956403205409536, -7.3794473374509311, 39.508056419813357, 16.612656493708446, -43.10421358736923, -11.746924199740134, 34.598302340159968, -18.325654778529664, 15.732786969635765, 6.3723447770350585, -69.569191021538387, -6.2235962642579947, -8.2478298048848995, 3.0606351749660976, 2.4981345511365816],
                             [51.891785209830566, 0.88363176861230341, 14.342843162726005, 66.191872844195558, -84.199737027142561, -31.704271250760417, -25.60088056715686, 6.7745286542350005, -29.953177272169778, 28.67322197121943, -23.535374455837204, 35.465422265530208, -96.545039457270306, 3.8801817868419182, -30.211795752878736, -68.105812780354469, -29.872116658888608, -65.826181083601512, 85.299166778998895, 18.793495081628848, -32.832828648736218, -105.38544980966545, 45.24007257017643, 33.2564235895832, -75.42603304820598, -6.4467678369514658, 68.839384082170923, 40.745583600275445, -108.50897813421032, 51.290883838490949, 50.012277572430506, 9.1546916030573886, 95.71967117582291, 24.296831564772816, -16.27198685176981, -14.512343017396443, -44.212702660227635, -78.520091461448075, -68.329097524248681, 7.3119786405900458, 62.73105818119835, 14.021005605992846, 5.3282788845435745, 28.31041620562554, 51.754484299507368, 21.933638823091812, -73.439255676924432, -21.640300762812739, 114.09301197127768, -17.918258666651905],
                             [6.5510853259900905, 15.946223927645718, -22.807449034070764, -24.054249822199889, 14.063141277412445, -0.7039954045770398, 5.0953312679359239, 9.2261000102289579, -41.919191257071716, 7.2109760162159731, 0.65069460919979849, -8.3710547141048472, 15.959214821919145, -8.5174695121627675, -20.780696915485411, 14.615372429790588, 19.709042413651211, 31.104935537414015, -9.4075134167475412, -24.087996195398048, -8.503140341216314, 35.159635267670929, -0.32225362065530455, -12.438389431899878, -9.3969262760135805, -6.0693801102946701, -22.15444132593564, 0.45755688598075123, 23.929273581708934, -18.077667697312414, -45.460923449116031, -12.623354025556036, -19.642326392426316, -12.398666935408091, 48.32011446716399, -28.047904701434128, -4.6675966044063406, 29.559994408507716, 25.070989840019699, -32.135058068299529, 4.0950058093943538, 24.489575841433393, -0.93085429237332173, 34.107666312703266, -4.8232155036191857, 2.7365349888030899, 27.260169271588079, 21.955006893214346, -19.589638194676976, 6.0556183781078765],
                             [19.29586084346753, 5.3320329337752002, 20.906333866507779, -34.605655511438613, 2.2180327612661106, 22.043451377229587, 15.622599124175579, 11.073474890203945, -21.399845081864392, -1.6475923883532029, -10.581013420822423, -29.516784594290453, 24.005941994068127, 17.58376508803482, 8.3887870806968685, 8.8926997661120364, 8.5986296952727663, -5.662888140978052, -17.92943922148649, 38.376357769230964, 29.310051748465252, -17.819562276499965, -13.061671370567655, -35.056906285010953, 4.5769522060483157, 35.324104081212802, 27.730039240810438, -0.77107092381010423, 1.0245892962731205, 44.526051160097488, 13.918032638885403, 16.531374838012269, 25.122341670472299, 51.232350014550406, -9.7245210026019624, 40.514918321094321, 12.726213384579502, 18.681136677023076, 19.509887497923117, -9.5746304494795211, -7.5102126180596258, -43.728926772990718, -25.651110520470397, -0.48468389164114356, -11.904470195878487, 23.414567737125715, -11.62043078280055, 16.29257362280984, -29.59226869436533, -27.279443125650527],
                             [48.404768756502747, -0.60056415791495699, 14.668624145290817, -15.350399441009385, -24.609987118124131, 46.602923657188335, 45.026353257112198, 5.3631902109653478, -85.874338198064592, 40.036147050039062, -20.093706796406504, -48.976417186299479, 19.240226837539787, 53.348100568858591, -57.574887705635049, -17.618534773189953, 36.095893959003575, -3.2568485010407864, 13.945344358587857, 13.743764670471611, -13.300424350530061, 27.567797057664905, -5.8091176086788261, 4.9994197457681357, -57.620049749055127, 54.736897728719597, 22.39612959625893, -19.912825315448771, -11.778567227759078, 24.572766946002023, 40.656001960652205, 26.697888133493073, 60.151704207598833, 4.5381645079664317, 27.737313350321884, -7.1896437626049368, -60.516273515091882, 35.597531819443716, 27.038633177037777, -92.547643543935891, 31.694428331749492, 33.149302143817906, -19.323948886682931, 47.03924020464234, 39.026646817310436, -13.766113361171881, -21.215420801097501, 24.354329745441746, 11.32634623436971, 5.1683458881257636],
                             [-47.973209307405995, -16.27073082819107, 31.055482425535693, -18.560163770467614, -6.9762740197554427, 16.633591493414006, 8.976799036556578, -13.350384417523903, 34.268633698640294, -26.539845503922852, 5.5560638133086817, 1.0939968318984008, 2.071780400347877, 5.081904386279426, 47.447322987987874, 18.164732793369861, 9.3828111969487082, 4.8591795560067972, -29.65106243654348, -15.499038112484863, 22.4289640542498, -1.5824621384003628, -13.722898012113534, -22.368987962140849, 17.816003710089781, 12.002542540174305, -0.91537392903256087, -19.485267583708136, 32.71738774785274, 17.226513909261389, 8.426717864384722, -15.987707144196973, -4.2508121210361152, -4.3494762798662876, -18.905592870181842, 17.13106367325889, 13.562333514039846, 2.3384185185809954, 28.222780571743762, 14.636506054692823, -31.271776592468999, -27.843593042983017, 21.726248328589289, -27.24545945515888, -4.2659226838821613, 17.579572325203458, 5.2404049601811504, -22.106824075624296, -22.423111100034056, -8.4311932679118815],
                             [46.385739977715708, 14.408267917964729, -65.946535112103334, -35.642083248164724, 4.5625192377841364, 67.529568535960209, 116.21024868897024, 76.08813754696115, -87.756572134416956, 97.965301681212793, 37.798784781957032, -90.077687777564989, 142.05150188658874, 29.104765356957333, -86.650929986386089, 28.479870715709676, 62.9875266124929, 43.914892965636767, -18.836737233385577, 40.998131761362622, 18.883486234606636, 130.48436806858965, -37.286125913906808, 1.9625801218734193, -23.936666396403822, 15.876863203272316, 3.7236154137721824, -32.612774189565258, 36.016154015332354, 22.457820586726456, 9.0436557506118973, 37.804525863984004, -54.535305075294495, 64.063294408830245, 102.00871061493532, 93.98531302196082, 32.420157192880964, 139.16767280564619, 85.734609071469549, -59.250540625835157, -16.360805824368054, -3.4751190597944257, -88.99053885816808, -78.754302355106901, -62.164676180673538, -0.16274163782393969, 10.895299775231413, -23.371627106609662, -57.623967340535891, 6.099271444203322],
                             [68.094218524549362, 25.174272772020931, -3.5955316839432152, 13.051606402755723, -51.655686633258171, 37.297309479568483, 55.624207931855047, 53.603051804895806, -92.502057874529939, 68.187715525896436, 5.224446243633472, -24.870470029331784, 24.413522830978984, 25.320897047428275, -65.377788486223793, -30.350084644086248, 18.74905148214263, -3.6390738824024957, 59.388770511586671, 49.521628854787224, -33.053391261219701, -15.938324411605205, 11.304019802412796, 15.565504909388919, -86.415609731395776, 5.9147445273599297, 53.323702217811153, -17.87901173807618, -58.098982115831284, 62.050375518550659, 80.559487865853981, 35.999571245534355, 58.313539308620712, 41.838011151694062, 27.450138396348589, 32.036412055437765, -21.963231494605317, 15.919394946774776, -2.4586180373595425, -41.095407475700412, 26.353808071963968, -7.9341106115046189, -58.587431556514872, 14.774816273449945, 25.549479141176171, 14.216915644691632, -55.271911566752898, -31.17395014607013, 34.693318894148184, -28.601804715475534],
                             [12.322234133969356, -55.126967292977902, 1.1246691672655651, 2.4186630915293588, -27.859081425631366, 20.798688671954508, 32.864208845131557, 12.363290637485902, -16.42893503760682, 92.980085762069436, -3.7503484697879741, -44.980189401167983, 35.096222436606972, 15.993490897336407, -33.483337580283582, -64.266008185910323, 47.57835930580903, -4.8503024374442996, -31.910405367688419, -34.35287947916683, -29.01161201496911, 2.2450870657856137, -31.516396139840186, 63.776758497066879, -80.07572170479861, 19.617240342587877, -8.9506500647700111, 50.676275029489148, -67.487915407803442, 21.789271861854406, 2.0043139944052863, 14.207724521118092, 0.88969807461691142, 61.797382521863611, 47.931421214892573, -2.5970388942281657, -69.342608978386394, 46.576612626074173, -0.63416289001677029, -63.599826377433601, 76.679746657633601, 70.626122398802636, 2.7460035306371466, -25.211659118901494, -25.067826291439104, 29.202511574907302, -17.303831355484665, -11.345996311332547, 21.870166086768215, 29.495109886034331],
                             [5.6119958572439508, -32.598043773354711, 0.38643271279942371, -34.212189567826343, 32.710939291728018, 0.10973037435088778, 0.84824721777728329, -9.2585117889161257, 17.912932132286549, 21.168753810802304, -9.8355743941863878, -24.121608527408643, 37.613969908355458, -10.120536535080809, 11.451249740105215, -20.4889577624857, 15.580558713412017, 16.291661386680097, -25.276363207377123, -5.2512265330632504, -8.4179026493098501, 10.886954264072685, -12.458722324404514, 12.72337351497556, -13.728926635326655, 9.8118376219327761, -38.505521659914301, 30.431466295113353, -3.6996163091045875, -14.835834829588052, -33.062065934532619, 3.0128935349295007, -34.765846356453793, 14.973991934647811, 1.1232187541373579, -26.967573059869196, -22.530980177376954, 36.36238835792507, -2.0090485411934069, -19.996802420747876, 23.239379630557757, 25.64978412634434, 0.94291672597280907, 16.237987835788886, -17.811300364652617, 0.48397607795596909, 15.918190888143132, 14.088126263843813, -32.479227390297069, 25.954202369037663],
                             [-50.082802815239809, -54.269458899509409, 18.101778131270663, -30.296908425490425, 84.155503947570367, -20.28925337871026, -11.749411131257141, -21.781713204090885, 105.2201430146542, -5.5466395323880926, 2.0336693169032034, 13.567126863590484, 74.788929043585668, -52.004533690866573, 114.85162765880982, 38.158446239305093, -11.588517074981464, 29.13614857148211, -29.663803542316312, 2.1791862398165405, -27.466717068338276, 16.263483792984367, -2.9231356246512528, -17.069704541539931, 43.371101766528341, -18.834397952229171, -97.143517344700072, 27.644913475055422, 15.837673144237622, -36.355532273837476, -3.4720331420188044, -10.286241716393915, -101.78669484328245, -38.529241022329032, -66.742539519384238, -61.433774684446178, 46.274783454810972, 31.918242959507211, -21.985048444590689, 60.285513201590362, 1.0364515000109547, -13.415009682670073, 23.644042624967746, -16.192161071405486, -19.660489123368272, -13.005996867154607, 21.636463804966869, -55.551009171692279, -58.840882556077126, -0.8987258000200018],
                             [-35.358018959402173, -77.73241555386933, 17.530018534842512, -13.302028873798541, 8.9435973776058919, -29.932478782263548, 0.1384343928590884, -7.9930729179873641, 90.339342880648445, 50.83511758722873, 17.211255579276447, -8.3224119476768852, 29.490684828582062, -23.494031302876152, 92.550402711533451, -21.306428366529182, 13.22017100364622, -1.1453732106209671, -7.8513889058513762, -29.790711156168822, -20.431264333001131, -55.895792881810941, -17.112505441103504, 19.362054681170715, -49.115327990504966, -19.708328673414076, -42.825499652518154, 43.120388688171936, -49.941055169385592, 48.808681555130924, 7.6173380155266521, 0.28171289925644155, -56.973395079707231, 43.636362845760203, -38.813800108017006, -42.468751795145913, 5.8910476586685432, -6.9037152679766081, -1.0520648367436249, 40.302725999929294, 25.813551963138689, 18.736986127259417, 31.384594327208973, -45.266458179985271, -3.8020274793953028, 49.956897483836862, -11.242875592579402, -78.5577977664027, -23.973454470627171, -14.399769378937787],
                             [36.559546450269949, -18.128002568478543, -11.660601724056757, 1.4979079131291342, -14.193734445727808, 9.1291764796531645, 44.310585146566176, 27.783758156033041, -44.28611982675406, 59.569228380258728, 12.935532076378081, -32.031017808076349, 59.912387442793488, 0.57301970009311154, -13.878508474088823, -23.130844574485515, 40.090416095668132, 1.2509604659519804, 14.781356329465465, 13.803005948356741, -23.943666230765569, -11.463986675890878, -12.477359823897451, -4.0772485711974866, -43.592203221764912, 8.614901514511665, -0.41920210850059736, 17.268077028394039, -35.363211246173194, 44.206150201495795, 12.577006362044447, 10.891101815322491, 15.283726664226828, 54.806643453715509, 44.573267417656815, 3.3158577526514534, -21.402054789646449, 37.987485793949709, 11.178941435978537, -30.742003784580671, 16.706569155180709, -4.2410696658432148, -39.216501683447618, 8.6135547121572031, -11.828557348150854, 25.035326871154805, -23.186243550291405, -29.827323892731155, -11.23306502674215, -24.287754795723735],
                             [4.6840151472098448, 25.380644552766292, 47.500983928346578, 45.713263619451517, -0.68042627565945957, -16.585583040108965, -42.622615839335893, -11.53506247018, 15.632767972428278, -63.613014439606367, -11.596323332195769, 42.826072944276426, -64.523160055289495, 6.4018941756375654, 17.330860445988215, -3.4470552923255973, -38.853454691425718, -27.446738568189517, 31.283167935333957, 20.6721248364119, -20.935631057995614, -85.241348950966227, 12.510066190815179, -7.389467821708827, 42.330334798791355, 3.5171177882404727, 18.208179464644264, -20.380683375798029, -35.061722110079579, 9.4517862656368585, 72.830885573558376, 19.221556231569853, 72.518559429602959, -33.691755315318531, -71.661073203299267, -21.512916849236397, -6.5309251620497495, -99.345743459446226, -45.060083113871293, 36.116374126562249, -18.299817548659025, -26.249004518427938, 10.625137502010302, 51.200989896887677, 55.060011163189039, -26.973809571496059, -35.102229944232292, -5.4073469481280476, 26.000138648698847, -49.538844128282562],
                             [-11.466589430625664, -18.120973322847828, 6.3147264570267589, 16.907656493055164, 17.457438634567506, -1.6841853899378094, 8.2126856264572385, 19.367712183044397, 15.962415447438488, 49.718833920669013, -2.6180478162778082, 0.5903693321868253, 86.230153502365539, -17.798246657900762, 47.50101640184311, 9.4432231222242713, -0.38768516110866197, 15.378307063742566, -14.882131415010216, 26.267594864577497, -21.791423771877533, 2.088461124248929, 2.3325857674088062, 8.1251648804067731, -7.0693167941516926, 7.0222940743304099, -16.788814790581075, 22.490752553603173, -34.888168529721256, -0.69229285506784155, 33.160329756496331, 17.314231844641423, -33.8705991865653, 14.786307204878835, -27.90207168853695, 22.525060788452503, 23.822787871806497, 41.53572257472603, -40.767939396982037, 33.075944721153007, 21.857652278373127, -32.702520902658115, -33.491829642487183, -38.387210316023655, -38.399344705912263, 25.599430043493026, 6.0565705490450918, -53.589883388218759, -1.0368875293478825, -3.0199367411769242],
                             [-14.274822371937789, 8.4012185862435622, -14.93846377640137, -6.4587408569637343, 33.678459170262329, -7.4645640518118368, 17.599400740525898, 12.183986019828804, 27.415736261010817, 6.9802638363844824, 27.506306115161717, -13.933725769729771, 56.563171115600255, -24.877289311272165, 31.286564201424031, 50.579663194757686, 4.418563957714535, 20.954244893002699, -18.183629155950694, 4.6713352659611687, 11.003438587998184, 24.566250336855802, -17.714942661510893, -29.302766606438258, 50.503254716759507, 8.0869696029950315, -27.826073400651406, 1.1121541580092575, 25.601577779423096, 0.059335632173366959, -17.550762406576403, 7.5993853177769868, -48.615931473016346, 26.14943896394314, 1.6493846254882418, 18.931063547017658, 55.262892402497229, 24.424878795012752, 29.820357882777962, 31.331400065978425, -43.129137344039812, -35.399740338502937, -14.847396373558702, -42.684232582395261, -38.529831953666708, 14.935185591206299, 13.112446988655483, -20.295947024835279, -60.884995892864453, -14.503638158838097],
                             [-42.505860046406553, -53.035479717077408, 21.841941540204942, 20.274927617102225, 20.857871392176875, 2.9498820690973266, -6.371153108975828, -18.488631617185874, 36.179748263743228, -14.49041536682504, -9.6970753194830532, 6.3746603486539852, 29.60121723622764, -4.3395923131349718, 24.701429039667502, -0.71541747526306709, 14.545569683543777, -3.6269699806507707, -59.432433099717606, -28.232141376345034, -23.044930345827556, 21.167785428917341, -32.460642814226432, 37.525780786218206, 39.349222284937255, -0.8694690206203437, -51.657579850116278, 20.48802861818562, 1.1100419069888421, -36.566154891421675, 12.554486954838243, -10.824954273071995, -30.300419047066736, -32.342648573422508, -4.8541032727429068, -28.962673227796358, -16.847827150756167, 8.5976827692305307, -21.410616738403924, 4.177765640589076, 20.559480042513851, 35.731643850535249, 30.586627865606605, -21.314242638282376, -24.185940241723991, -10.944371957548391, 11.207401154025678, -23.337567026541436, -1.655068926139436, 1.7770129636914263],
                             [-6.9415268540693393, -72.237222021280616, 6.7826598667283804, -19.05318695790492, 8.9406923505698863, -50.805293242079031, -29.731970287600749, -35.34824760166682, 105.03218664775692, 2.9030736830280732, -5.1491202380383738, 10.33971130911655, -19.510876989800924, -52.527914522798753, 89.171888716506629, -44.400190148292019, -9.0490395193091135, -23.88162302144131, 13.26667252895661, -21.730530269952169, 13.393922795080851, -61.361824306726341, 20.159766204383118, -5.6633113730911555, -5.7291038714139786, -0.53298015256494347, -39.642491778476789, 71.753630562450908, -15.235073705745553, 9.5764922520551199, -87.62596786650407, -34.194956674577966, -28.904878625060984, 30.49146725486144, -31.701575323334136, -45.309789470633412, -8.3542390967619706, -10.126286669296025, -16.796882907591986, 44.918426318023904, 4.5692545057537588, -2.6297390117033084, 31.774514255394319, 3.229350731795225, -14.497453386543294, 29.017646259765463, 8.6984825629917744, -6.1738258404909052, -21.085113526150945, 32.859455052350128],
                             [19.601789589742612, -27.396415982583918, 6.8474189630372067, 14.307083687662654, -9.5185384879509343, 17.729776805913509, 33.274653265214035, -2.4389201361953026, -33.111625729887436, 24.023975874574685, -19.434809343725977, 20.073136762794473, 13.580991764600613, -9.2686611647491475, -33.342877647179428, -54.864811835794526, 50.041034699093871, -12.482463536040171, -5.4112286301522072, -9.7588531032979073, -32.837389309545657, 1.2339943205871531, -3.2832914380084657, 32.568081860984051, -13.803671713520131, -23.928634010221071, -8.9274218271127364, 11.445172169687131, -21.011620976717129, -40.5084210779657, 19.169934176698217, -29.784081402922084, 30.79208896725002, 1.1380473390896177, 56.476806843125921, -9.2142185241746066, -52.722268981057283, 26.397342028270607, -25.071568704069936, -42.180977234999901, 38.167848159517121, 51.312645886944658, -19.258294236333917, 32.286132856423947, -14.336038541642143, -35.648602791442229, -34.750203824014513, 5.8815156707271878, 51.907408184962271, 19.450929026186614],
                             [-10.269210409537996, -8.4189086797975872, -42.669296003590802, 73.461053485563752, -63.088772300859226, 14.18409518843124, 18.399681161274213, 8.4474760027173197, -44.063034089118297, -4.5299671356458795, 24.896718609724257, 9.376363880958051, -41.396818069882066, 23.739883454270025, -53.0560357026989, 9.315175084338092, -2.340054204203418, -30.407010963305119, 45.87055946566813, -2.1854978869903214, -18.891966046945623, 28.431020137553876, 3.0446100658722859, 37.475285850545575, -28.135779474349722, -40.188539015612037, 34.65460087101831, -20.712141008238927, 21.50760032309876, 2.6079873375531966, 25.460474467880218, -30.673848290695965, 19.011091858950554, -47.483310932689264, 60.459848592485571, 1.0769141870609946, -15.300615855652378, -9.0706548679542554, -15.446503353853704, -14.134783898091701, 13.873240174184005, 12.729033559706364, 22.28994195001858, -45.756669120102053, 10.149209804011862, -21.375909303530971, -16.920803530511613, -24.468646026426452, 84.397243004601748, -4.6904325430397718],
                             [-23.902728808330981, 44.380744947998707, -1.7921943802897515, -1.0483972253814697, 7.6302114053095167, 27.725042547728957, 17.915688702277532, -4.3107210311021076, -17.453603743047573, -74.48961606064654, 14.42873143057262, 16.518710181794301, -12.944059022139715, 8.9093464430748774, -13.001200015263715, 54.911698885649542, -4.1233362813125316, 13.861907268617175, 3.2995630655929498, 5.1791826629544335, 20.254951207450969, 47.289447212771123, 2.579582746425042, -31.123812990004101, 53.409679207694538, -15.987739220797534, -1.3634897761754357, -72.438865999599969, 84.743585816673658, -20.198180243082586, 17.294165495013765, -13.067502023538022, 4.1620407133655659, -68.556469874995443, 0.40308758505205389, 17.506064297609264, 21.616105919496388, -10.004941482183433, 37.415394105820063, 0.45858224744046255, -76.641342543400924, -29.353975421378532, 1.0962798683658135, 11.096587245466903, 16.480267967897529, -49.386672415040479, 15.370798594377348, 5.2642657659593004, -27.372419864436022, -13.513312471390039],
                             [80.639088077951911, 71.26446652989577, 27.896538580497193, -81.118956913100959, -5.6518655607004336, 36.147184837989776, 15.525666806709847, 3.0804377376979737, -134.80486949642483, -1.0332084580551772, -36.789808576012241, -50.318828552554919, -16.101578139533846, 48.685843694760457, -97.883907928753047, -35.597338296684732, 56.535854814518999, 27.868875616384642, -19.04011617156317, -17.876422274008284, 13.652857751292022, -5.1216882636195882, -12.229990811201564, -34.523006925766779, -41.608113038790236, 72.126217335590496, 30.085879232786461, -39.456378746433209, 3.6917689053647615, 28.653305436270223, -21.874693790861524, 35.003255571525585, 99.475863083185644, 44.85434741051327, 48.249188279034513, -3.7397487746028055, -81.877852125615902, 3.4606583122093375, 78.167801255577928, -132.15216427635545, -12.569972059438019, 49.853392653390358, -38.106216820694158, 149.79274618059029, 50.463931177596599, 3.622321785212046, 2.6727542532407145, 117.4826283505345, -50.82544276954517, -0.91358121514114909],
                             [-37.496117818302928, -30.693044027715285, 18.031791272878547, 65.588801926454749, 3.049072107027893, -17.311091865437508, -62.69852554573103, -17.00565896038745, 40.741399623671242, -19.050193334191629, -17.265208010297762, 13.480015707796978, -11.275277475170189, 22.288545856982765, 73.665567128661692, 44.279469131366021, -71.727595417739849, -32.298618755751363, 15.791972355709154, 59.250357862614379, 4.6998065862925857, -38.861468038428079, 5.7254176262565837, 15.733763009387385, 6.2932086824845701, 4.0267376459538866, 31.160486999405418, 26.815654305605225, -26.592969514854492, 11.359273825862834, 54.369059612877706, 11.011862091231784, -3.9813768541443495, -27.156265455202952, -83.974740301978599, 2.9978329268813555, 34.009904772746296, -25.050125578981941, -90.357856915021358, 65.457306882878854, 40.489849576983126, -73.019459545945921, 27.318928408485615, -71.182622000646489, -11.92705607292455, 24.255318024860482, 20.298149373332084, -30.049670669590604, 56.428843801469128, -23.499216738742469],
                             [-12.656423971914037, -59.970817339433353, 18.347923955769737, -49.077351534078979, 13.156970711492578, 1.0985962895300687, 8.6555629384207027, -38.194277125512464, 55.132784812628188, -21.79756219447836, -7.3421324519037094, 1.3896856740126595, -12.903780673413131, -20.851262806901985, 32.072431122111247, -45.985477430009013, 24.28692564714515, 0.032757926997344401, -10.76774248145877, -40.26487687721599, -3.6787910354831226, -9.2542058188562848, -8.6430329500955381, 20.107556841563962, -17.806039578239901, -21.50920365866877, -62.905741727104811, 13.875686308257354, 15.386621450895317, 2.0447597749957502, -35.058569945997505, -27.638183602517781, -28.92528384957734, -5.3099314475540655, -10.632597207046606, -55.166608266411828, -43.914197779451015, 0.43473751632034313, 12.542846221458362, -9.7103907368164961, -8.3116051425884887, 49.375145978461099, 27.810892457509201, 37.074941567694246, 14.631069906250699, -23.985118153780714, 9.3520478164019192, -10.245774167207124, -47.225752996831282, 32.102850897116994],
                             [11.730628868076437, 7.7704339194247281, 7.3643238373023658, -17.394493744073454, 6.9344302574004573, -17.698464692412269, 3.3876242477800669, 14.232412142856372, 14.992411078257103, 16.107829820775244, 6.5070070562560502, -7.1536031724952753, 16.596115996760453, -17.917442402601722, 28.795679356358853, -1.8471304436145224, 4.4906279571773018, 0.17495202058844339, 0.83348489866282116, 7.5887610390069167, 9.0599077752859429, -32.20381310954857, 7.4022934218350311, -40.296129955493747, 9.7149320759781954, 16.770566451250883, 5.3766941596338551, 9.6581129992414727, -21.739308863316275, 25.603739755863728, -8.6514389956115298, 12.541312381169028, 5.885416318676933, 43.05678616216516, -14.402216089629038, 13.399665012738813, 23.205760258447082, -4.3468546242373209, 14.363118384346629, 19.973245631530478, -9.9459491624501162, -30.393685190100257, -17.957718956166733, 3.8514448401956085, -3.4187389930885472, 28.629044881458732, -15.118536262549165, -8.3329660503125638, -22.000018777146522, -21.404257014916912],
                             [10.881479544329718, -29.963140284692123, -12.783513293078299, -19.148897263120769, 41.817733263085749, -17.347697437259075, 27.351352549356829, -3.4440115371842834, -6.2058170202924945, 34.241504422652909, 6.6968317952319616, 4.8047218089519745, 46.320111147806116, -27.377780903223812, -10.974282903395048, -38.751220450357195, 56.328710850795133, 18.791306491822677, -10.646374907663516, -43.986219791256225, -61.749050842220754, 13.435528682527329, -12.618488291562937, 16.103234228356943, -23.276538643984072, -42.776747720379063, -78.532088113621654, -2.7676482663639805, -27.994949791711459, -29.302169298750755, 4.5137217206102349, -8.1774313546036481, -36.394945095769529, -6.8562568672583541, 27.893574077049717, -68.917896566229629, -34.4641462869251, 19.732191282212305, -4.5814265612056984, -27.771019855282336, 26.535853380761562, 81.15824752814612, -15.079577250909029, 54.372608096773867, 11.159473355468785, -42.515436821242872, -19.640597051541814, -28.384456984763492, -15.57896128963092, -0.71023168123276825],
                             [17.805808832695455, 24.846493499688844, 25.886810816461804, -104.74079722614822, 31.445971647157805, 29.733572136889897, 62.324746584352276, -24.65452179201716, -20.303390059973484, -37.237209080361644, 19.931768970711214, -23.996616456675312, 5.2335689031956178, 7.2045045472379048, -40.099129328989569, -34.782339112193227, 82.053108610586875, 30.456908008004046, -33.808180798397231, -55.143092564870777, 18.085494620139336, 19.633118465693677, -29.588070090963619, -61.44917345048426, 20.388312264078351, 11.866901987524397, -40.918243547096225, -78.485247730262031, 62.56725387827823, 2.5307244841262988, -19.425894077524898, -9.5433931952600943, 32.538130041928227, 19.544326554933313, 28.359624653801959, -2.949138631588454, -34.702546056900573, 5.1908096323678778, 110.83325652408146, -71.846611712133623, -83.360115049696944, 49.853018178060751, -23.604319108101443, 102.59187640161694, 38.887120476096818, -48.140603328820916, -22.415325301311288, 50.632063668787389, -100.49213580763329, -2.4673470642595881],
                             [-0.66195263096319334, -14.552095118130309, -63.798840665170417, 79.531329140058276, -36.977947279353216, -12.187701395158813, 38.620814667504661, 27.213145313273532, -4.256162160510983, 3.8915190835906626, 50.020166863305633, 40.832153619572047, -6.6869156156294887, -42.377817578235899, -25.084910945608257, -3.7062372982669314, 6.4328598961348638, -20.365479802754308, 70.535804915291379, 8.3078469255467216, -44.011053268489249, 11.530775110209833, 18.109026779469914, 17.127384247892483, 8.2575173739925134, -92.54618627216513, -1.3917408728925882, 3.0263236426206603, 15.935994399779698, -27.629794250555381, 5.8973855984535515, -58.020487252226467, -19.089214854439366, -42.066830100676604, 78.857078190385209, -9.5684537508498551, 19.218870763633404, 3.1170231813395337, -29.869492504209905, 37.591672383624861, -6.5070299107706493, -15.777237377803699, -5.7936066897939176, -43.193201275323659, -14.874037843890367, -39.650434748922336, -43.780716379226114, -68.900962856516131, 73.863269927949517, -12.86902140178195]],
                            [[26.384223379870967, 54.084052183021434, -115.99922636704281, -97.121537301554753, -24.751717771844465, 18.898460147574191, -3.6376458623699479, -41.259250043135452, -174.77557648913913, -11.970651207631631, -29.731968045128237, -26.734553592017978, 81.039795583452175, 38.089835510514298, 22.158491496388951, 29.490117595946913, -54.174263434702738, -58.920213840927886, 39.348697974832689, -160.00724520216735, 43.142256104950398, 59.289679613582713, -29.176452036746021, 20.252605868152809, -47.513639696321952, 35.122407048477086, 129.72949453407233, -61.310252524935734, 79.489177336700394, -62.155417235067162, -43.843685552094918, 0.031545797163649816, -73.898435316274529, -9.9204019481295855, 94.688578977556659, 144.08350915893973, 26.412473768838932, -63.047796199615604, -23.199605311843332, -12.096752988887532, -130.88594480460884, 23.452318903045704, 62.448725727059973, -25.62341331614406, -34.265381291783271, 61.742407804108382, 67.013515348434211, -77.005585646911342, -25.717581057522068, -20.284645897860205],
                             [-13.02956784896654, 5.5072323910413425, 5.9524032449953097, -28.944640119791075, 29.305606504954909, 16.035733389818795, 3.4098890313908168, 43.025327733549261, -105.47265253794247, 3.4550404864416939, -20.320991826448118, -36.598062221127229, 91.420315071035887, 11.224871933585982, 19.610258415485447, 31.760519866433544, 4.8563307880567255, 40.177630027945156, -10.187217826174688, -29.07477989410188, 52.333464750501733, -3.8325491332245081, 3.2724943934238637, -41.094134109315419, -12.159318350581913, 30.489183686718846, 31.995182701571032, -41.021180367927151, -4.0157877569553335, -85.461215697933227, 32.298563902382995, -49.753401617232512, -9.9216127264941285, -71.6407826330299, 65.979006102469, 73.301723269615991, 95.628634140261923, -17.632505361167585, 15.981661131365666, 8.8759155556219085, -28.780547166429873, -16.532288745934043, -7.5033288824016182, -98.515631066839433, -60.566846018039357, 34.834467858127702, -6.9101712032290061, -28.867052845877872, 24.737629962933649, -60.404259061159181],
                             [5.5375479843067454, -90.538075923897864, 9.927789346713114, 29.56830496524783, 36.567602271149809, -21.755507562049253, 13.266464656949658, 31.464999829630273, 75.236022718823506, 39.524007880145497, -37.071241514521631, 56.998477950092173, -59.357133284929191, 7.9287722492177197, 21.868258835217407, -84.518016929730095, 20.658840964189402, -15.223799950778286, -58.983780392806118, 27.797754500051955, -34.920106341495796, -33.987302426531606, 38.269625228251734, -3.2944919675648578, 39.219080297582209, -49.950375546734548, 6.1132554137542154, 15.091708609888864, -83.745011591037084, 54.129533194665349, -53.300456218168748, 44.266382442788014, 37.789743639598996, 1.650059202542232, -26.141558596895219, -70.595820119661155, -97.174791766067017, 2.2752149931497514, -11.108926550173134, 9.0843124564781785, 56.909164389306682, -37.946135606230342, 15.724839254050552, 94.11937504801395, 97.885797184060834, -34.832327230732091, -42.267251046382533, 123.10975211645533, -71.895008291986329, 18.547335052351492],
                             [31.222652315771551, 40.856295832824522, 4.4555119750631871, 35.137509240940467, 52.974819215445009, 26.678632028443459, -1.6101237749363593, -19.577706454075205, 144.75942679134022, -3.9632510918549553, 2.1733472628844224, 68.017051834626884, -69.06613300192484, 11.084851974950286, -90.372916422069622, 0.085436965969558645, -5.8001119903476281, -30.980786680094777, -5.6258160037156077, 91.472679899534384, 8.4935167082844831, -9.6553227803375297, -27.596516524295385, 5.3451316139573226, 25.77897503140403, -16.045450062735746, -73.794083093435972, -11.449274597511268, -64.302757156140274, 18.020980157699086, -0.9577903666941292, -3.9804222435603553, 75.687093605507457, 34.953355030009661, -129.92483366983598, -135.07901387814846, -209.82696701788566, -6.4334105311846308, 48.044113976113621, -13.365388844010184, -10.027106945571006, 42.222354184293756, -40.152816091009377, 103.72009990426197, 101.45801951093328, -105.73359688329025, 5.1082107317947845, -0.92630645269083167, -44.71962344794764, 28.999877013295869],
                             [0.66409387566834055, 18.077716963296325, 32.559165823127692, -10.90626173091038, 10.805510949501942, 12.100017918786186, 0.83188274866057021, 19.722271138108802, 38.582677555302617, 6.8093556967025917, 34.463334328255783, -11.825464146441348, 32.305541607586257, -9.7493340365185546, -28.97205584417263, 25.171842742948517, -23.606902026212239, 0.85083223309759093, -31.372579338143737, 9.3592230376345249, 48.174755215403195, 12.124768983006442, -55.026637206103693, -30.000000664716154, 24.332041163872621, 6.9465688594051072, 24.827907897055383, -36.410835670317432, -30.975256011450341, -16.630504773985333, 4.5916377569365103, -44.994409000969874, 36.35532643716126, -26.814500479341508, 7.1621681077609072, 45.328928015288795, 13.844004139789078, -18.367614178516408, 42.940417670955895, -20.37282221993696, -37.517316066577813, 9.9309487990826675, -37.676754289982327, -2.3150719458925253, 18.555385501922224, 10.322159113037383, -42.075895136283719, -16.168604915556458, 24.440111690198346, -67.714786765813159],
                             [12.644219225709966, 34.575425658252939, -8.7783363676109154, -69.172607227241102, 28.975039424476687, -6.3387562117561593, -35.16302070137985, 63.709655274285623, -124.66231879439628, -19.963479786190124, -49.119925465598691, -35.413221912337391, 98.953429926790562, 3.8719719870649461, 0.8733177075258336, 13.390711916515629, -4.7494925508149368, 40.305581381874248, -60.388134954438968, 1.8384693606062827, 24.93939181620172, -9.2989767085839041, 4.744123722286643, -60.771111451164408, 23.859540149833542, 47.736308476724055, 4.5822564542976405, -33.03100815039636, -3.5631947086439815, -79.329253984872878, 39.833988861451147, -51.573728341099113, 25.417955906183735, -23.967839242756177, 8.2749930330127608, 55.260409509210852, 69.627619620091934, -22.097289365575151, -14.933199242612902, 47.250564816507669, -39.825808200784024, -47.571929203443197, -23.188010414954547, -96.349237310111477, -33.771516826296285, 28.487066111313943, -45.684745720792442, 29.370673370624736, 19.551631714645836, -38.84406552560413],
                             [68.914844564360607, 51.161713924036128, -81.646343192293742, -24.27368557112333, 17.643414099104135, 34.492582943177183, 15.619539372686093, -5.6116270058896953, -33.440139078081806, 36.218092874481471, -35.808356625980863, 6.2046349085308812, 70.836294462314484, 62.544352549210124, -95.538896258569622, -19.668567832543246, -9.0874021998152088, -6.693127264363695, 23.277786306107476, -7.2747973584519201, 2.6500794793803073, 41.290852934407766, -2.561479310014636, -3.419415671363931, -19.626814090924899, 40.271631289197508, 11.421581784117446, -18.707164675225911, 35.714440766894072, -67.509186603186052, -59.075001079942837, -21.905005263767215, -17.805699971235512, -0.020634851926736218, -34.392732268525904, -1.8109126669432787, -120.65191252363037, -37.578226058851122, -13.134115881076061, 15.270361889232564, -42.892421904024602, 49.819123256674658, 71.551994462824965, 64.16629475724308, -2.8895409039078639, -98.051505310899316, 23.11235395397761, 6.5914397881150535, -31.563670353083257, 8.6551976772124064],
                             [23.651784008834337, 32.935994879996237, -92.409700608428011, -40.007797387407493, -7.6019237174991199, 13.813454348294963, -53.518246132356815, 1.4107254823090623, -148.35593425937341, 23.891539793379074, -18.808063798479928, -75.229239709209608, 139.22776920735217, 8.9003155834210794, -35.264081638356224, -41.81168217363917, -76.942800892941051, 23.583829798534119, 18.146643871181702, -152.68793929674189, 60.185254286145344, 75.280274793044484, -42.867054542348463, -56.897297082575299, -16.463767986483866, 35.17788433594626, 115.9374270776748, -64.658116144760783, 30.515939370123007, -60.6720064048898, 32.462061597017922, -86.939671811267289, -58.266971301610852, 3.2078158117889832, 92.712915552793788, 163.03657302058102, 95.674837139836569, -7.2578160366813833, 50.618613928738384, 11.916479835856057, -79.725611755396102, 35.888625626398415, 31.923247618121245, -16.473020949964681, -120.35164545848846, 79.626635775710795, 26.491293060193328, -42.966943832632083, 51.835909380326775, -67.541333085443043],
                             [-19.540672256428728, -49.225384296448865, 75.131943229254105, 80.419590272610648, 48.099834190996553, -18.845484295514037, -4.7438323564533302, 63.565004580991001, 138.90544494650968, 42.278063259484917, -9.9362732266882521, 65.046830668734458, -88.723976628668737, 5.8355893414605111, 15.724490804362796, -67.466324052268732, 43.587310965704795, -14.904612230585673, -60.759964534858696, 122.89302561849635, -66.932920272511879, -77.792433840356594, 56.665007103086516, -12.185379136959986, 44.014411381567506, -46.370655394558185, -122.58159543238742, 43.178240126792069, -112.38599998147507, 91.573626316502086, -47.55477745090554, 58.941406426604601, 61.00298213736319, 24.813583680996121, -124.86614096065436, -148.37942985815974, -122.63251073761582, 17.783234147134927, -16.000722929758776, 25.495639044707616, 88.256659122465621, -59.87088989202261, -72.82326763912387, 70.737694686053928, 142.94825858685698, -83.905704132266877, -84.238298432877471, 135.47944813605218, -38.639641636317108, 46.552123078079575],
                             [21.704724334669653, -36.785223418235383, 4.0623223568695428, -69.759382380141105, -12.764764096177533, -29.46896791514887, -119.62999717482661, 113.08752706646636, -173.34135752659361, -2.2076623602563079, 1.1980198505568427, -142.06020822812926, 142.36422313670158, -74.494785884725246, 71.426755095260162, -63.658083245710863, -115.27296055722006, 72.102154465519405, -109.48110863272602, -147.35028948285299, 144.82633727801223, 52.005411926504635, -62.890766634697748, -118.1690539346106, 67.206610608408667, 29.50135031293182, 176.01119894019655, -82.796837594013965, -69.452372939691514, -33.816876670492825, 128.23532756572936, -147.13400354769121, -15.591249608294611, -35.56251823231937, 172.29059897191175, 258.48103210786525, 307.70107459568061, 12.308237214081878, 82.444418713931327, 36.403064721292388, -38.043129874974369, -62.470151560904526, -35.335422073640352, -114.03688495535732, -137.16336050300583, 270.47173449283423, -133.86219063735945, 51.837423328332314, 130.21134917090757, -175.13900939954956],
                             [-26.469542854652872, -55.356711799066794, -28.404582093919867, 9.167676723823579, -53.429805781322536, -0.67079138856837395, 60.379703877768044, -67.391954066745967, -35.662449450632835, 15.77693213257008, -25.999536799328872, 18.752306310354257, -14.529513292735734, 37.042329378183609, 45.039829841706329, 6.9596284286976378, 73.403346615924363, 8.4706852328401148, 50.34369211714305, 2.0475540170743369, -63.286507150468623, -19.212704218325364, 53.274441564043556, 67.705529225610505, -36.813170294399569, -14.306229522871671, 21.189950052667129, 70.841122592717184, 103.13077293756848, 28.149802659994041, -33.197433897616456, 88.935208381368128, -70.284165317621131, -24.029991188144173, 66.362104023524438, -13.778160518236794, 25.166661978342368, 23.776697275630454, -85.287964297589639, -15.525283995693147, 75.793237796480426, -8.0915516352239898, 63.171366966822973, -36.941211040410124, -54.381335984049244, -25.186220300414398, 94.993125181890946, -14.674854911845982, -47.394923584871485, 63.209442513077484],
                             [15.285121094527995, 23.245871619719452, -98.123748078335026, -65.989612517520257, -39.363821053510819, 21.508109725045273, 68.524525749062903, -83.678607652729397, -103.21356079667068, 8.2037077968691712, -29.771959540037102, 28.00811760156159, 20.173398809965835, 89.17253372874481, 12.170791042593608, 80.714584907647009, 54.14542289372455, -65.31731513408026, 92.744666738836258, -19.400462685119724, -55.283179671919953, -4.8886375178109125, 67.110901095802319, 92.486174646068818, -83.781260760452298, 44.837884181896293, -6.6994206795629898, 20.853232795083091, 159.64969033515038, -48.993263372951887, -92.659880303367814, 118.77616605706115, -98.703084586563762, -14.065665378675142, -1.8446241552173568, 0.83212259009084566, -96.037442046139361, -35.882989768684517, -113.34473838950109, -10.419502931973637, -51.866139736080704, 25.886077410308008, 80.745733534380491, -32.760148694139112, -14.643921605727916, -83.102626736994623, 127.20338068246105, -68.297900269572708, -97.124168717295007, 78.573052523967476],
                             [5.5548916430656465, 11.637468573045233, -102.56595214098853, -43.154367130871279, -10.792429136596752, 19.05625680388135, 34.629185390767304, -54.277301567944662, -117.61750790703506, 10.556782721219259, -66.89686192412691, 34.448289668360736, 48.002823917671115, 70.051894529991714, 51.082519500288086, 1.4062693846678642, 36.288338289905504, -41.715969469411959, 82.310150908019665, -82.569558614359906, -145.78693149427272, -40.391842114961385, 79.489190830408575, 60.86099467111125, -54.456977617983426, 48.231261782788692, 13.085556471498327, 11.950224304334006, 122.22829810229896, 7.5248390137901504, -66.117838190630138, 97.884476456751983, -41.959758648198033, 36.142325622133924, 15.862852397399534, -0.85096336415761464, 32.491844765221899, 5.8453215196946005, -116.65840238511703, 23.714032278109194, -29.042027188271543, -18.231399537981169, 77.387997687555909, -26.85829473453969, -25.139504744840551, -41.759381278285758, 91.325583355073093, -15.659851382379921, -59.30600951746451, 138.89343276107269],
                             [-27.075182830752894, -32.272171462619298, 49.464509869935384, 35.077693412763644, 34.239113122191277, -15.49176120001674, -60.497784482644477, 96.360816663655442, -109.78249542181918, -0.88303016362967857, -44.122951405407285, -59.83561948587797, 104.45832538922313, -56.366394241086105, 70.879275583249168, -73.378914525601559, -32.864560482098788, 61.281345629320292, -38.8958386020985, -96.513504927266496, -11.609547713018502, -22.35593337951217, 15.060744385197875, -95.315959589921704, 69.239868112849933, 4.4729150606227028, 77.344928889570923, -31.310428184709156, -78.257360635196591, 22.062936653159305, 81.938119555203784, -91.155518157405297, 25.877800682936986, -6.9665202554573504, 114.489904928062, 103.63104956456696, 296.00664291967479, 42.653791166067755, 26.244000187690055, 76.139254009900412, 50.392185676156835, -75.20555940772843, -51.977336258986355, -85.832528988441211, -75.934941977222337, 141.72517169258069, -112.10509646044179, 101.89710351349069, 101.16594952716926, -32.185370288311795],
                             [13.656287883366536, 73.017018094855175, -50.127552871842667, -16.033246681478129, -26.9908904111591, 35.8674305503258, 31.221624413982468, -46.060363582223559, -42.887893674607618, -13.985192007671465, 15.466173958244635, -6.7519680477413964, 20.252973555620127, 30.355488842719367, -16.31918745087183, 33.908046540919131, 10.196905120750504, -32.80825629755568, 84.756163867117934, -41.860039778621307, -18.79589761018428, 9.3323742998821384, 6.9375538635695726, 46.368394976584099, -80.412263727967229, 48.232250035423903, -11.099807529532683, -3.2014571949577708, 95.077533608478646, -31.638995456302116, -26.252531976344461, 5.4861197521821774, -39.353921244060402, 12.488845830486886, -2.8115683079831322, 6.6654875400883604, -1.573167436887662, -14.918109670611038, -16.87532875085089, -4.7111683585925386, -53.787629229185228, 57.95324331661773, 45.567072893667991, 4.1945994588252242, -34.281765872926599, -11.063361395428238, 45.18502617869526, -78.895800704776605, 16.907045649052108, 46.303992053681753],
                             [2.3062196902182568, -66.054210062141834, 139.87456249432134, 28.07582063926187, 111.78867068659697, -4.720542640668727, 23.98233653701562, 124.06470847200841, 147.4534555487227, 4.9264041933514822, -32.920612067267136, 83.422402076384742, -72.481593623262199, 1.0066708288760851, -60.572454879878265, 73.921619396005383, 49.835233763857943, 55.174065783707796, -114.37881365668258, 214.48323000392998, 64.341546473337715, -46.744682457717374, 18.029283907265409, -61.562207621430652, 75.058428581678541, -20.6097274342305, -95.069558335144421, -22.580300290035741, -131.55885336936296, -67.08978260089205, 42.902400253791619, -14.321282627773671, 108.5187629385219, -102.06505979452005, -67.957072575381176, -144.45862588151044, -142.23555386658549, -6.1339975301591192, 17.358380680833342, -3.4987453208476262, 42.78301426925276, -42.276941962050245, -41.237396720415639, -26.328340160017234, 107.75537364380402, -123.46939146723565, -96.718056959152293, 69.169866962876014, -67.020941870216276, -71.706040292744547],
                             [14.504666463859332, -60.842779402719572, 8.7129581854753244, -29.31689878020169, 0.63900363489088097, -33.248756166345267, -13.327989981509653, 25.658423344148979, 17.16828892988292, 12.618042997707235, 11.81814297532066, -2.4756705263624084, -49.491625207297929, -17.000636437537711, -6.6331767216625765, 0.94473550992938748, -42.979338014411631, 7.4530880995181397, -71.185183181642998, 1.1320388007365021, 130.08732456331367, 44.767529703125049, -36.999478787656194, -6.6508514815134507, 22.858553962535339, -47.20823351521495, 48.923735241016907, -25.556649612024636, -54.298251278241089, -39.89491044750114, 9.7955144342016442, -2.5613801014269599, -47.733405179842798, -55.62072309302642, 40.336212622984547, 49.449035961912251, -94.647849993955916, -20.881810969106972, 48.509929151189588, -13.94635191606287, -25.252798038542963, 7.7220242753090558, 23.955166202677553, 45.83118181319977, 29.893101432995902, 37.786630806789162, -21.977996481974042, -0.83166133454549451, -14.660546582730541, -119.22536499365054],
                             [-3.5171120071443012, -106.79396915839399, 97.398183597636262, 79.790261620878937, 37.817013332727718, -63.151179873013405, -93.895140684363326, 131.61609286317639, 149.28468094994406, 13.469076032536393, 22.86885601100645, -12.317376592411609, -85.616283650177181, -101.90467358804108, 44.244734792473849, -147.29385331122666, -72.932026389758121, 53.616433111092675, -162.01012610958585, 18.915425602989007, 31.763176019453379, -26.550376535008386, -38.475219445769916, -101.30740608759189, 131.03489459229655, -72.001353024125677, -8.0008214643603637, -11.17776895223407, -239.48500570863547, 126.87172778562787, 62.680333830181503, -60.940741232801784, 114.11339917233529, 37.170967978701036, -24.346004365199633, -22.92934209173313, 71.559703311602988, 48.83044351154625, 104.34490852040197, 8.4219145015749355, 68.199408796736265, -80.380965782940379, -79.327067259481183, 97.680490721205231, 92.31505059254556, 114.70620694187021, -188.99948634449672, 156.24044576934116, 69.693298415099648, -76.641926500631811],
                             [10.577976836621215, 79.713927773913539, -145.08892730003518, -34.638173661681442, -100.3532163430354, -0.52501533443020132, -66.583611856878207, -109.95046574483472, -173.67037456788404, 6.406315459566577, 39.337261963610615, -115.15571146027411, 103.52984842533027, -29.447817327611613, 18.325727179431141, -56.252223089650009, -103.11550120705384, -50.983581804163656, 92.629546094344889, -245.85742125934698, -21.773232117240617, 110.7322971719304, -63.125122871059105, 17.024125293706717, -56.82158729349829, 26.38703059968568, 137.29882426565976, -7.7226283699458795, 102.665064307958, 31.508902259801044, -25.399484571181617, -17.856139924807742, -135.54660923988411, 93.193886835064561, 96.341818300952809, 220.58497387384253, 132.54581727565574, -6.9742125899527254, 24.410963034243302, -22.806625170884516, -77.458161876543244, 69.903272458915112, 46.069775907167809, 13.983549462125996, -118.63659669948051, 138.48485976862335, 86.141383074220386, -75.46644635471047, 67.934469281875593, 12.900274528165243],
                             [-9.5221739142394703, -60.765748811977971, 24.239446490940892, 11.964040626769956, 61.463576772182243, -6.7664303490185072, 40.523858598709019, 66.217544701056113, -41.602164170007697, -3.6919394126403837, -87.782653493806293, 67.285509794839015, 8.6379417157494665, 25.311262993629999, 40.609369200814399, 4.5096612119092603, 44.278877274487556, 31.878624610886828, -30.596243752995797, 7.1999519711128031, -28.879074358085642, -75.768058879003632, 82.775404128868871, -13.379329236321563, 29.49304858007471, -12.336518827308049, -17.479316228630111, -42.950250940227278, -41.396802565123743, -58.28496118521462, 13.555583660953564, 24.295342062220772, 40.815188469697183, -75.75842719707758, 16.244151897484024, -65.47913192481829, 30.336790185850585, 20.740994575523043, -35.971114923313564, 74.460287150458967, 4.8511418240656798, -69.681410670522865, 10.03899468776779, -33.898158980265009, 9.3291626039872071, -24.99440101260598, -37.978118899158702, 71.03336556548787, -37.465221847434862, 14.215486036834369],
                             [-1.007880861304054, 53.747935243739384, -58.813804335854016, -25.725291286529863, -58.505388607458279, 13.235049002920931, -28.036699073191343, -81.269937989368557, -76.442260591434078, -31.940534396929184, 39.978018113271737, -51.548343754492699, 27.520814533705607, -35.329621504523615, 54.993093009457183, 22.563213443929211, -49.144607195553206, -54.55499582101978, 78.141489804686287, -125.94720195573845, -27.226473876961109, 28.5229055375287, -37.38753836986789, 45.544500401644427, -37.025007675702241, 30.540121933130749, 68.447621589779644, 0.024271986603512444, 75.474494544621834, 42.839912587878082, 8.012472689377665, 5.6050320306902108, -63.853255606868537, 62.949719762347698, 50.791057100335593, 113.91773293589907, 113.20272176334807, 8.9406074781700422, 2.9566018731863495, -15.931847260130938, -35.827000794070855, 34.699851193563369, 8.998929685447342, -31.900394157827268, -40.893487533071045, 94.798097632494844, 31.773390569837503, -73.104039049684076, 44.889638788521005, 40.428676389124341],
                             [15.974218592377362, 72.10814943096905, -64.870344906475239, 10.58957651203961, -37.22155174623024, 40.023978468123495, 56.996784169097353, -126.79201184905537, 55.41815152205217, 19.960959954213205, 26.831207135824791, 46.169505715877712, -50.366911548201415, 52.630955338482167, -76.883787298383155, 54.034763283133088, 61.670972101896702, -52.901002115290694, 110.3075727024688, 94.874117068903999, -92.745309366812862, 10.08858806913466, 12.400987989304827, 115.644058422927, -81.355062099572365, -7.7149722361454529, -87.995757470685021, 75.522667436392609, 100.84962051736186, 28.132568792412478, -106.65578984069084, 79.709211441888272, -36.455571105733412, 62.174770228111399, -94.903590060126021, -106.97150599465871, -205.74930832220971, -13.37271781618535, -47.122161713522694, -43.47000366548167, 25.70857112489746, 105.23344766355018, 38.450767230692129, 80.478065377166232, 42.510776386431644, -159.80638802847676, 143.45261744975681, -94.336912923251091, -88.433998595117288, 127.46459675132597],
                             [-21.785401358860195, 43.84737711266029, 27.702028439636909, -8.8306943473345854, -56.266998303565977, 23.214416296220378, 32.730029036762559, -64.525076825270759, -37.656015967535325, -28.360212557848129, 49.688696178642765, -44.019476928713949, 39.495158826578667, 9.1110872161589089, -25.316936163628665, 108.25690668526916, 57.083609552864075, 23.968998044381333, 76.367621958799873, 73.404712972918489, -12.787379515913846, 7.0191176347797732, 6.8910105198604237, 23.52730083749767, -44.689921959801993, 29.6144292016752, -37.612293243185974, 41.177504227196913, 84.282259776177185, -48.200907663656892, -5.563796249705395, 20.794961530048074, -15.439777118983667, -24.111812321900238, -9.3209356104850354, 5.3599401156558537, 55.149270834100903, -10.461684899173971, -42.963718679009069, -36.802043806180748, 44.863732078139812, 36.450499226425698, -9.9004656343846538, -94.248887608688889, -75.672990993980974, -49.986700114708746, 73.868608769700543, -82.001338894628688, -0.64989855718314171, 32.651455242570769],
                             [-29.271829347543708, -91.057712246581943, 45.040995458210709, 26.162132335907891, 81.303433872533276, -43.519720309342752, -60.295318488835143, 99.220754273487984, 14.691207050211428, 15.82726393942065, -43.095633162889818, 10.281335819725141, -43.912109776326453, -50.313268974366778, 91.057205014635855, -105.74825156956422, -47.635433049164973, 5.839710616455152, -100.25796320638294, -54.210081878370808, -1.6702182416113434, -26.529315677136967, 42.189750556522021, -73.141696217200902, 74.153759730355247, -49.167433696113449, 51.606342532698363, -33.667916254758957, -136.37429339560202, 42.228818155053681, 42.33343137788561, -0.92075151745406125, 37.003522425777597, 7.0144482016457514, 45.665737437064884, -19.435880615771538, 75.056040608381451, 34.232905057029726, 18.773607769756612, 49.698779131874829, 52.879658824548173, -109.20641164726221, -16.704666207271053, 2.5563232850201567, 60.960446077552376, 93.076622539378462, -102.83683004518991, 151.64127272269477, 11.271953484651592, -28.061585386081937],
                             [39.463457385321533, 16.277230612034728, -25.22544260288532, 9.8745459193618181, 30.70731888499013, 19.596251293004919, 15.627808467370167, -25.735657593347209, 140.81235757360167, 22.429070325312967, 8.2175631229553954, 79.504243343773183, -93.963328821909101, 56.195641488974481, -76.623178777086594, 7.7940621497047422, 33.322627182719671, -23.346446199513689, -2.197035285418627, 142.69582693560235, -63.546496256316615, -23.943605703791022, 28.008140885370143, 41.418517873878351, -2.8969048025984923, -12.43513590455078, -150.22639981210457, 23.466583410323441, -20.948018949312761, 22.114943337525883, -61.219746780990214, 77.395176285225304, 45.673438157871544, 25.325616385767752, -186.03113980508323, -200.6513235738295, -299.24700119978473, -18.290997471316725, -22.302706704543461, -8.0029119060202643, 22.350807488296113, 12.900173631068775, 1.9490711704574717, 107.03072833506455, 118.8567690329553, -192.10195063610433, 54.154193686286739, 15.818555955979727, -76.4432515070108, 88.467254907150817],
                             [7.2746966503068133, -66.689434240035055, 9.0707115995599814, -12.868515601409717, 10.170186537159159, -51.453932551361632, -87.811961905910792, 88.770186728219215, -30.437815465657245, 12.404748450734775, -15.68865387382988, -43.250038588125676, 13.344965409879304, -56.155862059442342, 52.529128668778725, -69.409034077973843, -93.359286198871118, 2.2780681776291085, -115.81474399422866, -78.065166028241251, 43.743703797451062, 15.974535521237728, -14.302314954214655, -75.936517329764342, 98.120596591855929, -17.507643190490093, 73.244930414165722, -33.381577258693603, -111.11306592252664, 35.916580912745196, 42.353442230104044, -11.431173705982101, -5.2418775939266808, 9.899499506622913, 52.636272197999034, 94.708884906562417, 90.011045239295612, 14.271185593062167, 31.393739960544259, 33.650160862415376, -15.894746629082199, -79.955662831200812, -27.398258210923004, -2.197461022498207, 14.532925181113617, 124.0285286274366, -107.41159876623315, 111.08568636394459, 33.116663016300642, -85.236851475900821],
                             [-9.9377461532642375, -32.865483555371448, -29.850976192871176, 26.883489185995852, 13.657699706657613, -12.079450345766771, -19.151933049873808, 21.283389462939507, -52.089381075774227, -0.12421365855915022, -37.320943696451934, 16.027503330174461, -10.996672914721207, -28.419539482489956, 56.085983816077388, -45.385731407309571, -40.817661573059695, -21.216359105556695, 16.631698549638127, -125.63945257634661, -39.306891434221797, -15.205115074163613, 23.460345877813694, -3.5693105621644956, 7.1702932133614024, -4.4266978198929667, 64.265115220979695, -25.036655506509145, -22.646290829329608, 41.665436393178396, 16.461565950294759, 23.210481074092581, -37.210927934655579, 28.863065499222099, 76.244545894408745, 44.917279016292603, 103.3220401383979, 31.434786904047709, 10.294341906514303, 30.505761401527931, -19.995130682967726, 0.44111617965113897, 33.883158420325067, 25.931210186125519, -3.1240041145745616, 89.370817740432514, -25.763865629656056, 20.012046619609581, 14.524257984526892, 24.606090271779802],
                             [-4.04565121562496, 21.959863348430567, -27.554948246648578, -24.323148127676625, -13.146183565843966, 0.57066250330603596, 30.184647273810938, -42.381980436699251, -68.520564144801781, -13.893235433500875, -27.288748249585577, 5.6866882831609145, 10.791576249883509, 37.335506029462486, 11.501875832323696, 28.992617956803972, 39.567293992353349, -26.864833082458336, 57.653218374848386, -31.219615676753932, -1.5647239104485995, 18.929318532314223, 23.333109487344757, 28.051678487794923, -62.892050926581391, 10.638345477056308, 7.2844789990309087, 14.732901908886747, 89.035509940193919, -46.430640940446011, -14.954879113450891, 1.9865882646652151, -56.344794828935562, -22.258289664877445, 8.0812528447822718, -0.0033843781134553497, -49.640451619352461, -21.64508987952102, -39.160863707300038, 15.859706569334127, -17.741907331661917, -2.693304561015013, 40.363569680220643, -38.021518293658588, -33.211883670261109, -36.629770720289564, 40.904466212884472, -12.61698289390138, -23.95322457743125, 34.998302705141988],
                             [-28.401956531476877, -23.480647884684974, 53.132183206383694, 57.33912498780343, 28.915529963410304, -3.6643654311429184, -55.801133881074961, 44.004536168752225, 82.760136504412941, -1.0446750169231624, 32.10263949673876, 2.3336923330768826, -77.363980965370061, -59.167732990826011, 60.91606838708352, -76.94356043901854, -63.448421672666846, -31.568287704058687, -35.430772666358514, -15.508513526836161, -13.190795096897151, -42.828348555121785, -3.6945162283725543, -21.152587412017848, 35.474034752370322, -34.82833249204139, -17.335602580073513, -14.55776080766003, -144.30020661681056, 105.72390003216671, 18.599823124941249, 12.580916212621922, 56.476939922129183, 56.523788001122995, -44.929524872831053, -35.410307380206888, 16.113693852507453, 17.646946466737973, 58.883434618657638, 7.5552948271649463, 48.53794741396203, -26.457833956784317, -80.7420991317382, 70.394363532104506, 107.35070280349848, 72.534707865683515, -87.15619130973819, 76.342284922796608, 35.355947775341036, 9.3166175156673905],
                             [-3.8715159258521452, 38.112120618219279, -44.040813465258267, 37.061172763305734, -14.020025788819519, 37.542375809901699, 12.740863434568139, -82.260727721750513, 9.9112168320656249, -9.3074652510480185, -32.365960073670401, 48.586271974964404, -19.183541622883101, 49.081493018344965, 16.19048367148859, -15.137788081641006, 35.666753426617575, -59.759426556639291, 130.28611499221932, -27.219322370986582, -151.75402637943594, -31.187288875146095, 42.629744670336457, 58.521973595111639, -56.337844038060737, 13.349745619675394, -24.099549086082884, 46.766296638603841, 86.756584444230199, 101.01131241539123, -30.550074083915248, 46.064033719292937, 7.9206261219281453, 102.08218747951373, -43.629214654105617, -81.54817581580005, -17.162677462065648, 32.346764594849105, -64.452030131105786, 1.7493016254074536, 35.683449890674275, 20.500029719225093, 20.886980399031913, 30.884056102830076, 3.5911511331097299, -62.711756384816411, 66.05484771856851, -15.895717046340589, -43.123855582418194, 181.24511182919088],
                             [-18.227313701118945, 44.188637803040216, 58.496680815491622, -19.526664867985559, 27.968161102898254, 37.36311077091851, 97.225973697527465, 2.5703019370515823, -35.05665436517139, -11.273246876840505, -39.759027012784344, 43.774024743782768, 67.381153357648031, 67.575400111073549, -67.565271508308015, 137.27357454847134, 109.41112241829605, 44.243503464183732, 41.876441171309239, 138.10575760927867, 13.270841667044889, -44.697130511234185, 46.522713193950715, 17.985245324277329, -42.219736787089097, 43.357684559131897, -70.263256721915994, 4.2958315624089609, 101.31151283790054, -131.60874683849337, 13.882601645423353, -11.547985252424946, 12.869910546832923, -103.93367847661243, -6.3971469920869266, -52.947572505533948, -12.6507496589255, -15.178610157098685, -58.422912183482147, 20.7808734715029, -0.59156641432792656, 29.43795890801681, -10.754030337399341, -115.50152013833838, -57.934001939223258, -115.84905089532188, 39.089265404505888, -65.452800107436687, -34.438281630601438, -2.0451772171233391],
                             [-15.928520344847808, 80.965984070659744, -41.403105932636073, 32.835809676494122, -58.084891249322354, 63.735864614776531, 84.436656865561091, -146.71463645129509, -19.685659636371096, -36.203554148864171, 33.788728383962336, 4.2870451708402122, -3.2226176975799445, 15.92398410955829, -17.840470258896012, 89.533237562052548, 96.422344423965782, -12.371967022382465, 167.52632583843967, 51.174968294311121, -107.81355262239656, -18.814381350102995, 23.454226065800068, 115.359810197182, -72.199523178527514, 27.482402319606717, -52.757792269448942, 89.860652037656038, 155.51631716109682, 25.42964904946275, -58.219388197998526, 67.471212834805883, -42.86776587682737, 30.432155682194296, -8.5885831613109769, -59.1094252293613, 28.476542781095858, 5.5365141532704589, -73.394910760675117, -45.448459795267809, 75.2281849512663, 92.205006132916779, 41.720569669986546, -42.02907979754066, -49.847145033685955, -99.334347026086078, 146.89004045834739, -125.52806393486672, -19.496007067810371, 146.4023066236544],
                             [-25.438112609156157, -7.5943448109654286, 42.612200921610906, -8.9174808967689696, -19.25921100975911, -2.2043751604988304, 70.690079544807645, -29.306196690766903, -9.5556514926079874, 0.74326189631680439, -40.942836573103087, 39.757791902660436, 10.438183578865871, 43.45721673000692, 10.506571064672359, 76.241080109568173, 100.79232002548858, 10.029859354711572, 19.052842176673309, 91.465965682965447, -62.311630374507409, -45.043226870165796, 63.79813782463674, 38.31655900645022, -40.301459552885355, 10.947402228304661, -47.406381878798271, 61.471876835934005, 78.343929724407758, -46.725114685578504, -20.493369877840987, 59.782067066678067, 4.2651187635906922, -51.810764596537226, -10.412509345647967, -67.312420413811054, -24.202217732522396, 2.3483945767385515, -96.596547437136906, 14.357745583561037, 47.807218646941223, -27.776261309022587, 16.215633613191901, -87.842511386344142, -17.953602231620312, -89.398901305673789, 39.55516517361923, 18.59429062757135, -70.094971153270365, 59.243183829142978],
                             [-39.373419710475751, 4.066031026686824, 104.06085187658707, 26.939412303199205, 82.533168064166304, -15.988075247426988, -75.167466869200638, 126.89006688272057, -18.504023710234762, -26.364232148714635, -38.380939766593876, -17.881725325539144, 8.8090739819242181, -47.23609413977514, 35.377966980813675, -28.85146724216137, 5.0493350119195259, 99.316573089594243, -80.29395227528039, 67.066731246903615, -1.6420649727890424, -37.698225220935093, 13.692082810352725, -117.80313676305971, 53.194164645378443, -6.8748737839074536, -41.183359795504636, -7.2776029127741211, -109.80696521250221, 12.697270883280995, 113.26907670234503, -87.155510641645407, 100.16570786271754, 6.6719225154672817, 11.265851804358132, -56.585468787267864, 152.45565362565333, 32.459334460569515, 18.575095516145581, 36.827452567446841, 79.860396481849065, -90.924854241897009, -74.003994487779124, -108.91385965155816, -0.78016209311773566, 51.777866135701096, -101.61626432406838, 75.395950151079873, 73.250007198035917, -9.6466460508947627],
                             [9.8563425789814971, 3.2797800850997891, 12.664108333569223, -14.213591271832067, 39.882763505066279, 17.083022241851985, 61.72847733913467, -20.860141112289906, 54.355095264268087, 13.749357447289452, -3.708949063122688, 63.549869474941673, -6.267929143084122, 45.086214724375964, -57.35487303001257, 60.990765111287949, 81.158035201398746, -4.7809471539837611, 1.3884001399121253, 108.46016537401751, -15.100888443537318, -22.815580822486417, 32.193907661732332, 21.540143765065036, -24.842953567176366, 1.0301488311710609, -71.977116722484766, -15.79393025671833, 19.263715069067068, -66.063294417217037, -47.696749583332611, 32.445307651872248, 40.11677275766278, -63.245006798970685, -77.508336991206136, -84.12429564010715, -152.53074939840803, -22.607317243838523, -13.506050277317774, -23.282441636617591, -24.259482363837414, 27.659771884052159, -11.790509392451009, 11.692599567334506, 45.354001362800162, -121.40130813171734, 45.965587750382433, -12.343357053536421, -85.538659463791248, 23.657971072313053],
                             [-5.4901790189829844, 18.307196176069354, 19.013683929085634, -11.852418887892069, 9.3151044622093906, 4.9857468267110949, -58.33048830082506, 11.486492971881296, -21.723467023740913, -5.736199432933569, 3.9900997426452536, -18.939212209113542, 24.302086231825982, -12.620148616700618, 6.9496619028450608, 17.100967250112632, -9.8397300255632878, 22.444452954076848, -7.4356219969336736, 27.522078475863811, -22.77362924969874, 8.3759630656256938, -10.681670257091696, -34.789006501216072, 21.105481381440782, 21.289469234886873, 1.7433663061195432, -3.1844704103565937, 9.3665676510049156, 38.772850791072003, 59.493455080388799, -18.453487653750024, 15.310759852671858, 26.57321876539692, 13.4934608044444, 30.212302154449883, 87.558747717620761, 33.234299689240338, 1.1944067260927556, -18.486684504006128, 16.511555429948153, -17.089576824518588, -54.494568909675706, -74.980883572274635, -31.24959940722287, 41.923588384877959, -3.6147057835326373, -17.316933427874602, 18.233425805584766, 16.71711494674442],
                             [-19.130442789493024, 27.141005335605509, 149.92029702492326, 78.620913739716826, 35.836333832901069, -9.960891901668564, -7.1505352423768365, 68.720592110021201, 192.58566209560496, -35.699930438370075, 48.555478857479883, 16.670416208392552, -58.396103307167003, -59.433585956228967, -84.668548632584162, 41.242988012721575, 40.397618098019635, 74.512182286399934, -73.196575252006568, 227.08464494402722, 13.622234834246278, -50.966731751838118, -36.326970933457083, -51.339360254634052, 74.272228388390715, -23.00285520650035, -183.62789082142544, 43.847496728630297, -120.03917579505131, 13.437995047632871, 63.927441996534846, -63.02337486111135, 138.64344728177443, 2.7255198423269129, -146.37634812597324, -149.49155195618238, -50.697711420061118, 22.852005565864189, 57.340025795383738, -2.42778326397146, 76.086357757971186, 2.0145673912915583, -115.27867688263629, 4.1365072507915244, 65.509343566420839, -91.621223868458301, -91.14303605608356, 13.395802416546822, 52.000548388558116, -27.21592537896737],
                             [50.240649283998096, -15.896871472101411, -100.76528291161337, -45.281977869323924, -60.216777404575403, 6.4825173622911034, 14.91057736202435, -51.325494811986047, -77.685283495366861, 34.659192403229305, -28.328500398026758, -28.713260422138493, 67.271391690304668, 35.041128895427484, 1.8665496533596713, -62.130657868432714, -59.575776584676206, -26.849201741692202, 18.513005460119164, -157.76675791516519, 23.383907059942228, 58.895280755541251, -48.152273708713622, 34.071216276937584, -18.817359602214609, -3.514896852667611, 156.06161926336765, -14.960839255942528, 50.585468944918595, -3.6281121944605945, -61.166622021240521, -21.176859687645802, -67.869758407663937, 5.2567087594386734, 94.814547872065077, 137.54333716657166, -1.5196047015213574, -33.532746150841049, 0.3911111616299387, 9.8226647986735873, -49.353867841432049, 32.974368742450302, 107.75450499757508, 88.835215266961015, -42.337612305489635, 48.873101023481453, 9.5525409490755084, 6.1448211406305333, -7.9885768647382145, -36.573469389957943],
                             [6.9418986256930317, 47.871017314516052, -102.24546568454491, -31.306481182597864, 7.4413056032216387, 40.976373674962353, 44.224637674545725, -84.495600594464733, -73.045332646971971, 11.264608743711273, -42.829325701833014, 75.834244000474271, -6.732277466284434, 109.3155455217797, 4.2256698705427729, 41.849709776692535, 67.843708210162632, -67.519325444136001, 124.6411968300083, -15.651909450808148, -135.25564271535791, -18.798137619467344, 92.931023620843476, 66.976712643092597, -90.557742346340547, 31.946993538062973, -47.866846774912979, -1.4873288094276955, 140.25527399145952, -7.0137585588270666, -92.813353418504988, 128.05101087039725, -45.610037215543485, 24.751270169110025, -62.345433862319581, -101.1250771214229, -131.96492082841445, -14.307539038423608, -110.70169963812246, 3.0593574862618484, -35.620964574209594, 11.402315890216586, 57.063263261250853, -5.2034628419032698, 16.499898495745619, -132.79738662445197, 137.7911386927436, -41.18055667843241, -104.46978875204445, 167.15282231819322],
                             [33.50758514677905, -23.061378807401347, -140.51268503003411, -102.04421403689348, -95.53666950841621, -14.187215302015595, 8.4398016163823133, -45.057691874100328, -232.74173282841886, 45.825275458573486, -28.276446196877362, -102.18789811219138, 129.35858181839629, 49.037310615452185, 58.468576589496955, -44.883810388731128, -75.744331188405866, -20.834358340010848, 43.115851277647721, -256.25630048954815, 46.72540839007992, 92.770556374577367, -7.5802451284262142, 30.743928784512054, -64.211328865869007, 27.203580472176576, 203.60114082958583, -32.464616513476976, 132.20365137349208, -92.823494882262366, -40.619198304922953, -12.69312938168361, -173.75342967699953, -41.645254675962349, 183.0203068132225, 225.72589341745163, 104.01460471337322, -40.606348196251695, -35.381865859827933, 53.545079814438516, -75.313827823962853, -4.6094615021866261, 158.33803790254046, -11.269498005760521, -154.70675417427265, 120.09780742418906, 44.213904398154973, -8.1579375028516328, 39.965543346320899, -67.337606924546947],
                             [10.329499815875925, 37.231913085716535, -29.685188997323909, -8.2725510291474933, -30.196161848862644, 0.7784679190339211, -3.4563388712163299, -61.959493743908993, 17.382347101098791, -8.1003473185797237, 43.636312684716238, -21.802643405615452, -12.16020878979675, -18.422477912205924, -41.135351876376802, 13.555097064819053, -27.036159426102774, 1.7935719830472474, 28.361621410227187, -17.529142715566344, 15.368755667037766, 42.463591921932185, -47.60946219123953, 29.731097539230976, -23.204008564524095, -2.5952058979017112, -6.6127683053329314, -0.89853643581790299, 33.655581945807185, -14.980020812715694, 10.394427568917738, -15.675448167441074, -36.726834838538508, 19.838235102769662, -18.553781363422299, 24.701111370442625, -46.273703226324784, 0.19505356594599665, 45.269207511333484, -20.516382413794688, -23.714873849973852, 63.865042418035451, 11.207890442269681, 38.830501217719082, -27.197557349880949, 3.1508674966100445, 49.300499833639435, -70.159494838509403, 34.075707379663392, -16.874489942790404],
                             [12.1141248930334, 56.997427373200402, -83.572065668034739, -11.155868114754071, -60.255087792189869, 26.820114862354586, -2.9543785193042331, -108.6924665588752, -39.371211717905844, -27.684471339920623, 59.377697933987868, -25.606165763786791, -10.197952705617636, -0.46301151984835953, 0.58918569327400072, 13.846713872526257, -25.989570965830115, -37.59749288003993, 112.39625165438393, -100.17774643640134, -39.855439646497715, 49.988092074917326, -35.961192593805968, 58.335239209781371, -64.478729863143855, 31.534112451572359, 18.643780637675942, -2.0204781855700977, 99.950431075365387, 29.977879878332324, -15.659852397983752, 33.633681429541078, -72.911506289593945, 44.278615165249036, 4.0361234973694069, 50.4937046531522, 5.0363352108014876, -1.4776459699631814, 12.579863379217391, -51.048699811137354, -43.993147713514141, 69.047970723879345, 38.533329650336675, 27.895615776193175, -47.752638297435574, 17.75874067989535, 103.84890620725687, -111.96869210734512, 38.57926365730944, 61.514825083677898],
                             [-4.4628076636018541, 29.12287375616771, 0.96970956490020188, 29.150633495100241, -89.282768387057786, 11.280251488219431, 45.848287031103197, -118.70380527276657, 120.91824210254384, -33.817121492003949, 69.749276840615252, 25.401135923856422, -100.02610201433451, 5.0211908925950368, -48.763318451262833, 72.348336565980745, 8.4843211346588987, -48.505720119393168, 86.250527471852891, 33.970670980118157, -8.9503294701070164, 22.360047068845045, -40.099315646286207, 93.908631027429692, -58.194484647816139, -8.3518932052753545, -43.370441768741159, 55.147209056331896, 78.955996086663859, 48.033647360650967, -10.514940694536129, 57.357994251918143, -27.672130487540965, 38.838939850955306, -44.717536887184409, -49.994439368626722, -109.77950669783134, 4.3164662872533262, 1.0638455881425022, -68.844701151261376, -12.013813807288196, 90.242096620857339, 14.772252656661097, 72.536003495441065, -0.83102546169109337, -46.303721398664052, 99.431555569960381, -121.50322127483557, -18.311663802208692, 46.288835405459203],
                             [35.194483011323939, 135.77411947671868, -44.759566308286153, 0.42840085516317872, -14.638953665417057, 62.5431149375705, 5.6693627028001714, -84.068883622620561, 39.435029267993116, -43.077293483698675, 64.833977636897998, -4.2268963031474254, -0.89770189062525618, -3.6893014347196593, -107.11381051284971, 90.255436967497786, 0.81130559121431089, -28.543453666395518, 84.800003994924779, 67.920550577776623, -12.184948596310837, 29.52498841449038, -65.064739097521723, 41.294247086011744, -30.856775802688137, 42.051747251678727, -80.403368208389182, 8.1110694741129272, 42.141601183783386, -2.0477076584290335, -27.113415605434582, -14.23724942062853, 20.726624450888711, 51.93130621409464, -103.72455435498561, -39.054072374757297, -108.1023819213332, -35.351778286549369, 31.856256300489449, -64.473077218770783, -42.156047620140015, 116.19462612362872, -27.983917224842827, 27.870505442083989, 25.491480254675, -102.58226259484827, 84.308545779210377, -137.25160330961756, -0.99773210370595322, 59.297359491358918],
                             [19.476438646794403, 25.586915210894563, -153.01424331735186, -94.537987902453878, -50.815069461952646, 36.722423716185766, 44.969743478013548, -128.81726987440709, -215.50851468882891, 21.845705248531363, -28.544423034258248, -48.104860444295163, 132.26543978636386, 79.805560449814436, -8.8059577619513476, 56.622619602624624, -7.643083860423836, -43.142887182368142, 142.50056285069923, -158.98449778262204, 21.846184368461891, 85.431398390591298, 26.10125908936736, 65.579220065574262, -78.999022147586516, 43.082206072422892, 163.75921613089847, -24.922204811712735, 212.54675463107682, -108.8913015175419, -45.63874599654509, 28.510902384893093, -157.35202107379214, -27.805433721588777, 139.58136888695489, 149.59589948970631, 51.175674015514062, -27.256524719545666, -78.82256901048062, -6.3243397437297748, -60.22260453769406, 49.519251655033891, 122.93581262105531, -78.714838889342133, -170.65799829818576, -1.2726792450091526, 186.05935302228485, -113.13186033312192, -55.660601365647864, 15.195539868800768],
                             [-11.400299802129911, -80.006268169634538, 71.635118694687733, 3.6771893164161042, 56.443173857992662, -37.163786289329977, -33.500185970809198, 116.81652046854097, -6.8747112240021719, 0.34099746602327274, -71.028877988709539, 12.520295166339645, -0.078340511216837258, -7.6428233717893219, 53.764862452212355, -59.557393822765555, -23.007422616755285, 37.997856463523334, -87.069150126671502, -18.210215460358711, 44.747948365160823, -23.007781237798408, 24.005289908432484, -82.373818903683443, 67.238184500240806, -24.512431940570305, 51.021451770648866, -36.925013372681761, -83.604086029100799, -11.171900412400223, 76.70542956167867, -60.430605963668107, 51.84445238727276, -34.461333822654751, 53.232240699842301, -4.9111278273064451, 88.458881904472648, 21.962282082023435, 1.3631923900036689, 67.533814751838349, 27.784526435670472, -106.47730300657815, -13.569274241925237, -38.903533185945847, -4.8946470808322049, 65.493360353679037, -123.00556498402796, 124.58724117364959, 19.025090001790893, -63.552878423855553],
                             [0.37965385528392626, -47.139931320780057, -15.517157680720842, -23.930698484684523, -6.9437040424460266, -29.486862042281711, -30.951473195745272, 7.8700830422386314, -17.850932836496654, 48.165779876464562, -9.2222229275465732, -21.245409895338593, 6.0934353581965732, 20.006694753875372, 12.720527932235163, -11.99544223451573, -9.6597080499471701, 1.7716627620440943, -34.428548940128081, -17.008037556503513, 32.036991130574989, 55.873122740579873, 7.341764557615071, -29.83033306030773, -8.0337574872093054, -33.915674598701642, 48.64904132490495, -6.218626671602884, 1.3186602403723027, -29.940316559221522, -4.8730432894629638, 1.220673481183316, -24.709032446609484, -19.881302670145715, 34.344328045956679, 13.335040626712635, -47.248087094078379, 3.1090057371176654, -18.436467209004775, -15.946132512201274, 2.0966917697579768, -53.796126010484663, 39.152895259381609, -31.512584465279016, -21.673307994327146, -4.1341998231854191, 16.913849155825108, 37.241378013073827, -49.599053392437938, -34.348586756756475],
                             [-22.528909670347197, 58.061922901802241, -46.968126439632094, 15.075592659304176, -44.082463441635916, -7.1531881985101791, -104.44030738005137, -29.871607988876232, -39.826839423421426, -20.622238108191173, 78.880037065747899, -107.77345014232469, 33.141079889912831, -92.223828766944237, 14.673918815499718, -45.853491966840203, -115.5300220367487, -1.6516988079755819, 6.0326335191470593, -145.36559934565256, 48.441497228422797, 74.167204308307021, -106.64980914350552, -45.044467542921296, 0.23009719043679167, 3.8792437151606483, 69.340390216567158, -21.080338177724073, -35.025348602884776, 65.406100179036144, 54.530965711326239, -76.19308801058348, -28.933230645769815, 91.073663727493681, 55.889848862769391, 152.50213168374887, 152.68150673324942, 18.576319207827126, 101.8779434380383, -60.773445205959632, -51.394571056460201, 36.185088296539, -42.04682327881455, -8.7659471950102237, -55.411815708599711, 147.60578053966802, 14.98060852176193, -91.473543411892337, 108.8329652306335, -51.874422765945759],
                             [-34.305502738762961, -52.958386859540511, -22.526223010566262, -20.12623324881039, -35.592816232663978, -31.92583628735829, 36.864625820694414, -25.268034477618745, -83.865816843981662, 50.935718636909712, -30.347101293229318, -0.29515611354951238, 37.131378838646278, 49.915587287106284, 64.728643107966164, -41.395873224687158, 37.710129510122371, -16.426346102107043, 27.588122347157508, -69.699907334523871, -66.131795648467801, -8.6021666898794429, 73.031074096217168, 31.879753146604902, -46.012167943913617, -12.772077583081877, 36.637799805613852, 18.457959273698588, 76.934880240766546, -7.3352211532173897, -58.611292337324393, 66.601042254277644, -69.26825437282568, -22.678524462826594, 52.21078708543876, 45.470322498260728, 45.647426733093504, 8.1558481081842409, -78.489191081007789, 35.451992171529675, 3.3031169761255685, -47.502596800887261, 26.882039566940705, -15.02637019683085, -46.437696294044301, 16.530875935503563, 50.64270239375363, 42.759113276772311, -30.351510948592509, 32.095850692148396],
                             [0.24506178052605859, -37.478985458836299, 110.93374611108908, 40.484651375249804, 88.155459519880111, -22.091741495446819, -69.919658527545138, 112.40041659585776, 179.68003841629817, 4.1093141012987857, 22.628224235422994, 11.281915971643253, -66.835809695263166, -51.948603776950115, -53.495859614022343, -43.627983245014661, -45.318766769060502, 31.954194037494201, -140.45958201325459, 142.67748594610944, 65.187656950004879, 7.101981633275285, -45.932711715913257, -110.16240798651799, 131.20262922485961, -37.053375200881014, -43.453973917508947, -3.2116502307236319, -192.90951570503054, 61.253396042765395, 38.312612135821382, -47.69148748357113, 130.9850681228763, 30.05108796340873, -80.791983072203493, -75.994812683530597, -67.156071922798489, -8.3862090442488419, 56.001695061223238, -38.920322782037196, 53.837804987493925, -46.440450043812611, -98.220682327757558, 44.129147097415235, 134.09255525535136, -25.853156553296877, -106.11151256088827, 91.579898667080826, -7.0794465319742619, -78.071314284811137]],
                            [[-36.552789997454795, 91.787793872951426, -15.487804450690936, -28.903040418457643, -43.591546129640463, -206.41751734342489, 42.472035763693469, -221.50503810592647, 184.80300502319449, 323.55901741701001, -132.71609014511839, -351.60761865224771, 27.861992158330324, -72.29438765050358, 125.35515868518748, -44.130793724311388, -207.3994047666545, 278.37790428074709, -195.36455736078318, -30.321150331532785, -193.18795991698309, 203.13043880883461, -39.539760788723228, 119.60051369123573, -200.69136257174517, 25.197960034950835, 165.70939051363689, 77.768823004914836, 88.015316782209069, -28.275601675242218, -19.239354838764832, 170.06433790754639, 156.12857852575945, -239.76744146620302, 53.77710611607295, 69.96784181745106, -140.02786254275952, 12.704464056123939, 9.0907519416855003, -18.93716172565766, -48.392807387611128, -76.78888293995827, -17.347434521254193, -59.392816408440751, -97.947446987353942, 40.741968875383797, 235.85496426648081, -19.029311719640607, -16.94914448771096, -75.104203501835187],
                             [56.372540012408038, -97.194446357633652, 97.289380587819977, 39.497399161525671, 72.666339347204783, 37.885602142738847, -61.461443953787835, 171.73248704421968, 55.441175618867305, 73.947752433794363, 198.20119013406398, 57.369822923796775, 76.713473402505272, -3.521824572054105, -31.356203762344606, 47.097515326530036, -109.40232171823064, 218.20286004005999, -96.504930912520848, -80.70780832587252, 242.57981672241471, -86.925597480915997, -95.245867659282695, 51.571392273207131, 58.644692348626222, -89.022051985391641, -91.22105968672156, -90.777491721272838, 78.034523310391606, -117.27668308281108, 102.33943774673598, 86.23729830620826, 32.157498196746133, -33.246810054605135, 153.29637459677889, 162.5650306485928, 72.852423567061862, -64.102419337044282, -105.74281969554366, 341.29695759163229, 147.19794275944645, -70.229050208174897, -7.9608981232926403, -66.042951623613035, -42.036283316001885, 53.316288310357244, -20.286071229164993, 68.454009797885107, 9.4483962968121045, -138.00295447811857],
                             [-66.938636897731712, 33.856747144806178, 70.931488506062323, 68.095973132918687, 112.87749767713687, 170.71824476111655, 121.25809143841188, 90.282199852525494, -153.16331161457205, -324.11039744690459, 231.39660996406218, 266.24297505380576, -128.83526193457871, -24.351282640639447, 1.7749892957192657, -58.422210318372315, 137.66111648296067, -142.64903374921857, 80.634513898867596, 124.17653835043009, 276.96451417332008, -94.804111302888487, 30.752021893273042, -90.592019883072453, 22.414635861591766, -152.34358235116122, -186.10119252034289, -62.935795209717348, 18.988911289579704, 42.748461686716198, -47.027636146940743, -196.63417268588324, -17.223020728843839, 52.828162351727407, -60.880727039927351, -192.86059275478581, 61.177815519711082, 96.934282052727823, 20.841527369131633, -137.51342138996151, -5.3671461950541133, 46.120703570883848, -0.64704254320585708, 272.81802729437345, 20.651715160051737, 30.775882317626085, -188.97294766784597, 114.22236121414727, -79.19917823781941, -87.10490796572202],
                             [-6.4240248827494852, -103.20865854155241, -39.042768784858971, 40.420112737789829, 25.460747807515268, 156.74733090450889, -139.72611552587551, 72.611389253510282, -48.308141702369468, 1.1666804985685255, 151.78942976428823, 201.0038179419418, 32.444157624253407, 36.846704508735527, -46.608431182210936, -34.902487520536781, 37.200003005843513, 105.2635246153765, 57.374460799355944, 48.594609614741472, 170.43002762858862, -134.82619879393488, -114.12449811930186, -10.655280229292455, 154.47943438721188, 25.165734907754377, -60.825217469146317, -190.85279033189755, 112.730594103355, 19.995351401494077, 87.323044632858057, 11.412572556894096, 24.929853665583735, 134.5210352077514, 55.19720954485139, -6.5095559418591975, 102.15505415099392, 131.71167963831016, -65.693235238617646, 194.51031621522912, 0.84270951715451137, 93.023726723224215, 86.061407232051209, -203.3122054751351, 47.881503354091464, -2.4496205768274963, -135.31630585374575, 104.12429251985415, 64.000614080213936, -45.35070544706312],
                             [-41.280339019988176, -12.871765490025364, -26.957521940883815, 65.038234934903286, -24.490761431995544, 34.155258306771145, -19.867916600280292, 7.6603945433886818, -21.190161329677167, 4.2140998643880891, -34.359023617981052, -98.516252304251225, 1.2257579912731869, 41.709066612693448, -19.314780261711974, -44.231584873965829, -44.415605474280333, -45.70560452789573, 10.482510019418433, 36.519570026484857, 4.2149034630303053, -41.089570182633544, -60.840438514540104, -41.73242503336656, -34.930303161436001, -14.180493841880697, 136.42981227644339, 57.707819017590559, -43.339101113399188, 42.563828994552225, -47.630689712514972, 98.862904584904328, 13.157754479657999, -39.20693737302841, -17.379396859197634, -5.118702161757172, 66.184864370774804, 52.010640869092505, -36.863289353884909, -14.382528679812653, 51.144961973347421, 81.37628817447235, -13.578812123713712, -44.258275321780417, 45.890733753607194, -8.0303404056676815, -26.928918094714877, 55.196972176657496, 22.15837482907844, 89.137618947802551],
                             [5.9801744350970907, -19.332370534923271, 139.90609766288571, -110.58454874487956, 27.279044935499453, 54.253613539160824, 26.077363722318996, 90.388421373808455, 106.61628106197165, -62.469660246236188, 117.01513810816888, 14.217110885285372, 70.797791061514445, 136.21209220184664, -57.096938019058669, 24.698454555835525, 69.611262264762075, -10.926018911612912, 14.253092723513834, -72.903063974481285, 57.875220494007735, 3.6981774390484219, -5.7012540664138953, 21.687623574103384, -48.912123017963438, -45.067586719112583, 76.197454501696612, 7.1623823686452219, -116.32471973874661, -16.379941167532035, 9.1071982572018548, 3.9170687963613311, -176.91312235243311, 27.369136612435092, -30.243472817188426, 116.82338097379886, -86.258751093312597, -38.981319352303601, -63.245084621614922, 240.11830924495075, 31.779407518370594, -45.853155964952094, 53.1254129536687, -20.785284337658133, 57.661749132135895, 5.9963032078069993, 120.8560638568201, -84.008246818107139, 28.713940371216829, -17.512752003512791],
                             [163.95847828648934, 100.46739523520685, -85.329742829917691, -146.15302973233906, -35.286405650765722, -53.119419169098663, -150.62527227312393, -193.43858766596574, -103.57749939892328, 165.02968899412318, -2.1862016246795726, 3.9442965714160327, 142.4444646065364, 136.96847752613465, 54.457288276467715, -30.361328001447308, -76.265291968723346, 108.49479022107283, 22.3123249690405, -47.139472755511989, -90.120804352560896, 71.52342814118316, -50.084042768424986, 80.009708898334452, -91.521810273097572, 176.00711894107329, 139.51672426749897, -123.17177065790527, -5.0419297601853525, 5.3691132841024629, 10.284924976807021, 38.455712915915811, -4.3271575444366768, -16.773335849506729, 131.01736887913512, -3.7490493996113461, 12.232354307928187, 70.124094130642575, -73.704264747894968, -6.7656555754166927, -55.736412815189844, -15.243833577009648, 64.846333579782666, -265.31025345685475, 3.3333892003643002, -2.5550343440791012, 131.85391687751212, -240.97658579614557, 36.797850114141532, 97.69396099972839],
                             [-168.20415981514191, 154.99584323864022, 139.99428317360079, 4.5460739335014999, -63.702484867461081, -204.76773317421603, 230.3867451847706, -184.51991894924788, 316.69326985852257, 230.24441010023492, -191.8711436594362, -269.41868033525486, -100.23436692325406, -170.93823904214992, 164.24753764643475, -71.800281952044841, -148.47587757539802, 197.69635358127562, -204.04592573872989, 7.6325698092893033, -50.229829624625161, 257.65654368207362, -63.914054048200192, 18.93285934375422, -227.77980252503485, -97.617380180965142, 106.22650798965833, 195.5314486809369, 139.44957756666653, 9.4737799363881816, -166.0166420951536, 114.59793480249273, 69.532131440351137, -218.86709393751806, -69.468512386584706, 6.0661198441064599, -125.20310331780976, 45.874853930067239, 126.53902834607547, -175.55425577282818, -108.72546615097254, -44.440296949680764, -20.593991511962582, 294.92919860860047, -97.842311955308361, -18.123231444459009, 210.65296653272028, 50.801689952669953, -125.33283670311403, -71.219580651439657],
                             [-40.508203387997398, 124.76743104851565, -68.459374285108765, 65.268012861988467, 40.34408976673911, -144.87553770949737, 106.19394498495626, -207.19048431822679, -54.023133542882881, 32.23098502758188, -73.10364158483543, 32.515442045306742, -146.16512731465787, -176.9851156120161, 157.29837244900878, -16.78082244622081, -54.94517078522901, 82.419579441496765, -25.531262518313937, 78.902775061729784, 3.8879570320540084, 174.10142548779575, 117.03965612604107, 12.396307469598325, -168.02851762981754, -84.634966708017885, 6.2419663369275371, 17.163439757008099, 72.025204279854748, 51.463035676745548, -141.69061227855926, -27.141956769690506, 74.343613180341379, -85.667831993408242, 28.017267542851972, -225.2609049875862, -1.8732435226722173, 83.726208389761027, 115.94585309120816, -291.97428841249911, -79.79114863846425, 26.566286207329536, -52.114555542282787, 109.40791679486814, -107.02263550072311, 13.297959039451717, -31.553255025742082, -99.146235230674279, -45.048688765784135, -39.145973887500766],
                             [-163.97082979705144, -526.46009906151482, -188.32970580711574, 178.18415891769038, 21.937592168643441, -86.933037562479214, -115.00726849690821, -108.52211784247314, -13.347773964727622, 193.12543190010203, -41.756969389688216, -36.931295920062723, -144.16988511806582, -286.33357172331495, -28.877538901593134, 163.21451000096147, -132.37212216542656, 132.06786820766021, 21.143199393604206, 173.51027059732741, 2.8986037920718424, 22.578720479068622, -92.59670936319435, 43.172370866203103, 278.40962740887062, 113.57465587875856, -130.2498231832995, -177.61912038790894, 96.537366625212272, 3.1512633226461908, -13.514771018831688, 156.04084029048568, 179.91133225469972, -163.88908902431578, 127.24058080877509, 68.019629604423102, 70.313149478547373, -41.698755865204227, -72.672791595156852, -111.44314270771051, 280.09490909038493, 167.94575659550344, -130.38739755516872, -255.54403634188634, -155.33314205486599, 66.506470376832425, -246.26663907069641, 112.68870424094257, 78.89124259790718, 51.611634783533248],
                             [-154.97018177480803, 135.0240087277657, 81.701628745088826, 92.884681015482542, 78.972571665580674, -102.65653490191075, 169.50327356566976, -81.733551316591019, 109.5625015865085, 79.164417955729817, -67.17489813665081, -35.244125187581538, -114.77157184446273, 68.839557047480326, 136.61290745924794, -128.99581082322393, -133.97325994228365, 141.49563261190556, -84.116362521281943, 63.156880218338358, 136.03134854928064, 146.07679434925214, -181.56956530106817, -0.46523520225917459, -33.783059531560504, -23.890437352923261, -0.84276855162620379, -66.857089867397278, 257.18423528020281, -28.927029777001334, -123.11120858968488, 59.716101160262909, 96.28784637737958, -166.75695862354186, 113.06051157674658, -78.264766096431941, 37.326093343559279, 127.91350460001297, -16.202324852696798, -69.746202486831777, 18.402794580430829, 1.6542411602046279, 38.387459654119176, 145.40808470148301, -97.63828710455951, -47.532261847549414, 15.405432373312546, 100.57310181059609, -52.602000048637542, -96.7383947540158],
                             [116.00109322863779, 51.607926393877534, 46.938675893770053, -175.61169787221624, 7.6520272256934945, 210.40796105269584, -186.55589348328226, 109.04929839849329, -171.62582748885029, -198.32411472318552, 362.15823406808624, 347.1454868710403, 127.03854105747142, 25.219419092714794, -45.754617205814569, 110.90121277967486, 219.42443738093621, 27.278598486050669, 93.331705662033897, -23.916548076783585, 55.593511359531732, -123.65509206712483, 149.69782294194334, -54.414626062138737, -23.818609159332354, -57.204179903140044, -119.75268583985761, -116.32031314691888, -286.37997127068689, 96.706773550156683, 141.0498599198265, -228.33108061427112, -183.98525376628697, 173.69083789322184, -40.663089293212892, -126.93488529516034, -7.3668953413367859, 62.613285061898743, -57.190581947620544, 219.41780428435294, -72.092268769261679, 35.107441991882318, 6.5074461973924169, -26.098916354376563, 136.99814928496983, 57.846062631511842, -29.362449140892124, -184.09228684640277, 60.899218070821064, -76.874335009994255],
                             [49.029127454717546, -297.62448359379886, -114.62839861725594, 155.32992586110134, 42.905304332153932, 117.66156381251379, -145.83879515883103, 28.672525614385993, -136.72290626757962, 123.2400561318463, 138.22594749812291, 190.4711528817387, 83.969839846566742, -188.75648259795574, -64.483711445988675, 163.44910317513759, -131.74291683346021, 177.14608947006676, -20.680753482038217, 93.498610522862677, 223.19366115432396, -129.03404474596834, -84.662300694078638, 88.146102759978788, 176.68650904178494, 90.506537227940541, -102.03151007970331, -224.3738574120174, 98.479121248719835, -38.331662283961236, 73.875121782773689, 93.349315741475777, 144.26571765515743, 36.678882930750362, 110.51185980465073, 84.841600847378785, 177.12555670427338, -47.090587978532845, -12.33395208133302, 75.252537826064412, 117.46959317278653, 78.32930579912103, 21.089171548522145, -272.67167468512628, -89.378294722895305, 85.968786428444929, -216.94017999162162, 30.615851005355609, 52.418797116518533, -4.080334975374325],
                             [72.303374659125311, 190.20480953611417, 168.55994961303344, -190.2027894228855, 20.502246560186613, -0.31266546565246323, 124.15560451904875, 61.623237857196514, 109.17537652858189, -127.03762285104133, 26.628462342758418, -167.36332472959626, 87.022844022637969, 150.7772671547265, -7.7772335054919193, 21.751317177548223, 90.913249218518587, -113.47224513724136, -113.63442249247829, -103.50849314920758, -105.12447656205902, 90.243980811890552, 22.510456021359033, 36.142166351098595, -229.8284071078298, -51.83537302406345, 68.760474167794811, 92.034718005369854, -193.60941840736211, -38.099837102025063, 86.850677392481501, -87.198521386728856, -132.92749560154815, -76.523237953810337, -77.705378241421585, -11.122494936642491, -254.83722188545795, -75.451483550399274, -21.624712621834036, 125.05450496760042, -147.94264937263918, -179.19943350401019, 67.073041923180313, 73.804524967669835, 93.860415434958213, 49.868289286734154, 357.86797826275978, -154.34673582655134, 3.2326284785665607, -91.672493496467339],
                             [-104.11141860596351, 39.076490103875528, 119.35783378817708, 114.65068594291738, -18.99818238517306, -114.58445524189831, 168.31871759538993, -54.6722389826624, 146.72730496425146, -17.869817098192303, -179.64907231745707, -174.18429356110693, -131.63746139807537, -207.95924797831046, 58.569411883702458, -12.147917657461131, -74.612407206075233, -20.473084846259763, -97.017187798374067, 11.234207254991476, -10.78025148815699, 121.50006684172553, 130.81039458137792, 42.015384316719029, -77.629263806312068, -94.09745440144404, 36.740783156947003, 177.4789965751649, 27.170168122030915, 30.642964163664754, -180.92852078366772, 34.253242277175673, 125.01147248743186, -189.55909457651106, -124.84761976892776, 26.714116425358199, -122.13167899134049, -47.668156609358654, 129.06976884561334, -224.57411209348246, -17.485278108924561, -52.852323981478264, -26.756340993516652, 350.63984454280444, -95.74231016402986, -2.9145202232734051, -11.88811248378952, 116.21139861862827, -45.690044534475454, -57.359166750899824],
                             [-90.908800816070453, -122.8097603753753, 5.2009166181754098, 107.75592817117986, 0.47136694028126946, -40.442310318035176, 61.533071601836753, -75.393042194001367, 66.745942367894799, 149.87830257825698, -22.080228593482129, -86.557261875478389, -18.67420969590848, -130.60041976154258, 40.755515531080782, 65.464298895973585, -135.99915744348843, 167.95869901647137, -63.511072816024665, 70.027166828000489, 37.281524227732831, 24.954783336662409, -74.311133675872057, 69.303938661616428, 28.054535833867625, -31.980086376474539, -48.867973054782162, -9.9060128546847857, 101.6920256601456, 4.8706178690572495, 3.0643771813474308, 103.49069180665964, 132.96342393836608, -86.033400941072941, 79.025677777385724, 94.669624189709495, 1.2899671001264323, 10.980416118506305, 17.403316498108175, -74.617859908254175, 36.059125665526807, 1.2475241948332114, -9.3769458042520295, -20.800221891688345, -128.23525061304335, 79.604680370280192, -34.623327787609881, 141.96735418953591, -65.038326523926671, -28.08050728086096],
                             [-125.92612526466377, 53.967354381782911, 89.247034587959675, 128.98561583231023, 30.698826877270577, 11.077586476122153, 242.12949051621948, 0.30846392803958289, 25.489163490602095, -154.97164083762272, -110.98831498964222, -79.862129942770537, -171.52310091167854, 21.397624240420001, 8.8785679068471044, -85.436544310930643, -14.213883698735357, -78.294455133858108, 45.584906712944097, 42.61904678694232, 98.92918656077957, 28.499412695482604, -49.826045775901925, -60.259299439455901, 11.127798507454656, -112.25766831196074, -35.184996856581684, 49.43049533500745, 40.689178438734039, -12.211675430196829, -113.46314285788762, -17.335588045436495, 39.56883848619308, -17.855691580528067, -127.21391128556036, 5.0083064556132708, 15.339435047316837, 101.07584725373202, 138.98617671692921, -217.2816287891616, 8.6736472017520327, 2.3124440533073249, -56.399580353695043, 383.77277472102861, -49.191486984600516, -27.199764570474976, -82.250079969499566, 233.24214170618765, -169.99397443609399, -56.819374726845588],
                             [95.289326287936859, 81.304868335747301, 27.564199105920416, -135.13962004685186, 31.076436533963566, 113.19624244182646, -55.291204800921811, 146.00899598535506, -34.871664329786576, -178.07338763745443, 264.81585479020282, -8.4940904044647212, 40.461239237125852, 78.309398498323588, -35.463364294132241, -14.355201476760577, 153.7130521038444, 47.241922030662309, -77.688116520928574, -86.562408362186773, 66.764240408081818, -70.539448886415016, 87.51054281187254, -82.318534258756827, -113.03342037824169, -214.86337479983635, -22.594188699100712, -34.135892631347502, -191.13362303122182, -79.246139721207683, 161.01703020316498, -81.416480938157761, -94.673622666127272, -0.28543551501072884, -131.108751630287, -80.233520144029001, -60.935247244804245, -58.866245637058718, 35.65213800486621, 153.56900976544355, -35.946073212558346, -18.663754011016763, -125.58482135099581, 97.031888940837533, 149.11790715077808, 54.923050841107511, 94.747138210641097, -124.72464971238338, -55.375759024939931, -54.811708781027008],
                             [64.830654046098289, -107.58975965323512, 122.47100793032467, -68.685360773429892, -19.093021191650056, 13.862068243404174, -34.218707182182264, 173.03706889274807, 97.291333939235244, 156.11647375913051, -35.335857400399014, -141.09792412631879, 188.34371693907212, 232.70726312468605, -67.136912217679324, 47.710059308454298, -95.332404339860119, 87.03877851961893, -148.46490077890519, -129.93947597792931, -39.407575902160971, -87.139826110487675, -182.64861113687863, 18.48281861119797, -58.511077465314997, 30.842467150801756, 99.395703980501978, 66.445152607902827, -115.76937469840107, -195.40114759355819, 186.64491035032421, 175.74027719703648, -61.183452947522824, -20.454796738755824, 6.9114694280675479, 185.23890004858896, -64.729676356701574, -8.741365445107002, -87.34180548249978, 310.81884371751414, 130.44555084375315, -54.527953511836721, -32.132975802892638, -182.19910243840371, 114.09708692760276, 76.107560637569122, 225.09849210344535, 45.562247764620786, -8.8191056620367068, 56.442072951808605],
                             [-157.22898326955089, -184.15438146176922, -133.35277778833273, 111.732169053413, 4.2139435210634399, -210.71502724408447, 72.395867031521433, -183.55213823183126, 65.901198091470562, 157.82287963989464, -219.76562707969987, -63.873330783239361, -176.09848263460802, -279.10147036003917, 64.614240678676452, 77.68159514322015, -110.16526228593722, -0.44530415990899197, 34.579160026427488, 124.6925225376682, -127.86993924055685, 198.62114105941757, 136.83849492644234, 36.493918218900603, 152.05733258221503, 134.25008682977059, -37.46883923671313, 18.098463181159552, 86.352185998788855, 30.819855870424533, -213.51792095460277, 53.587741783447349, 116.9383780820271, -95.60649931944819, 8.8562100442891776, 15.215714596809553, 25.074318025281432, -91.587050417513765, 107.29513389431163, -390.69171513519518, 62.090770213130384, 72.005480024715396, -4.1149112429791632, 42.675133405531689, -186.79573479325092, -14.256242994739933, -128.72056787457836, -17.818314609880805, 44.567660514384819, 54.739566630434467],
                             [78.756809774763241, -86.497027382936835, 105.24200863722653, -14.355640572689154, -12.183091125235094, 2.3129616920416751, -59.386728161074856, 71.52211706398387, 76.337852474115977, 207.21626924794407, -37.423179801696982, -122.20755342795937, 89.425976955732153, -75.39777134897362, 5.012754791770849, 10.192399010599097, -147.19754725006541, 27.242757446680436, -171.30488641525082, -50.102330009488128, 57.043031301701532, 33.208370097371862, 132.87374752385134, 43.998056594029286, 69.09179779687851, 32.058205272688006, 46.249544572094052, 16.952047608251974, 63.620668113740834, -55.400774855244592, 88.978152967368572, 79.327838916688876, 104.34017097515031, -108.96216828594788, 20.121725116438753, 184.16362572706726, -24.625345626220799, -133.36373063598987, 50.685092405375059, 130.53808974151764, -59.580754551734969, -74.117669875504077, 63.306680292929698, -103.42913425810332, -83.134026944076652, 63.267523784709475, 96.256918369933402, 64.262787405859029, -19.679593779847572, -85.62939609196917],
                             [-40.566037020204334, 241.33132457139223, 187.80868157636195, -48.778936561685164, 24.085585877232898, -48.388990023777829, 272.92088612606847, 112.46631954048469, 181.00736457724494, -174.69207266705871, 8.8128396700431963, -173.80707636838011, -62.031684145396802, -101.63313102338134, 57.885317779417235, -68.358329085960776, 80.315679000326909, -138.10998471449702, -105.90687688311561, -77.48533172514982, -13.680795865588877, 72.742511698041142, 72.956077777778546, -13.080710888293163, -205.52618291458472, -209.1087005670831, 20.67091393952666, 250.83450508684717, -67.834579102321214, -51.414663914632598, -66.345494359799972, -104.41583137864092, -58.879082697168286, -43.604501417516964, -139.3422732274469, 0.65031948919393168, -175.93739587683757, -45.304851564696961, 55.108485809477145, -125.31157136187619, -119.49834299697005, -174.78942505433554, 1.334243276151196, 410.58554627573511, 57.146541426493833, 32.705752547561602, 222.23051473565417, 58.012794020334958, -80.248588155460368, -110.02692752265065],
                             [-58.763242050488024, 99.807720374932671, -82.793198373885147, -73.494656652018222, -87.043849563277163, -93.689514915546411, 70.879573610800392, -163.93799793448642, 55.324544424763701, 55.008348121131377, -30.202930824787479, -236.41731489308577, -58.704778291561595, 12.908611307449377, 62.287451294166118, -25.554829691188733, -22.269209086193577, 74.09265116713037, -44.874842457230855, -4.6843100026730067, -123.81132492152989, 42.745663502185089, -4.6735939111012739, -6.7802625886881005, -173.27331834873965, -38.727500765734163, 55.93384180437819, 96.590148135256158, -44.963722273879064, 61.495635882231355, -34.45801191348199, 66.672459347711865, 20.276093874111751, -114.77335878007592, 26.159899087518461, -24.659268482102323, -65.729989620727082, -34.266182211779189, 40.218961984177668, -143.23811098733444, -54.144405408292464, 17.053416206554129, -23.333223039529791, 25.773573017855757, -99.949243924149243, 47.204396929343439, 119.86219269797128, -112.37501443192865, -24.61120333339543, 71.931354720637543],
                             [-22.350023874361199, 118.4072502051566, -22.815861257218632, -12.534481318209838, -177.02123999663741, -299.58919446012482, 62.49465482728904, -92.512239419700506, 166.39738584447963, 165.48869931489415, -411.90765586995951, -505.56277206319197, -86.11932499911093, 139.35234491145496, 11.158072930508098, -75.435002206788411, -85.809787528898013, -44.979607509445493, -46.244538075852851, -133.1379718514842, -413.02128002016605, 115.48954641971434, -155.67579229032404, 7.1489520101715485, -186.79758065542953, 29.255779414432734, 233.38295527113766, 247.84487571082417, -58.085402530523552, -34.181819140206478, -44.826434983839398, 179.49695447585825, -38.396599927464081, -73.345579252003233, -30.209909861298556, 159.48379582247966, -139.09900028968704, -53.721434183149512, 12.410199065909637, 24.683971531460216, 34.862143568671257, -73.061292758606697, -66.590616547679687, -57.967226590166206, 91.00168164195054, -37.878431410099353, 263.67445244000692, -6.311876246203914, 2.8120518572637945, 110.31055430934637],
                             [266.52621146942568, 395.0218279217442, -18.381859491608349, -213.73142570277423, -76.110741203693678, 225.30108372097646, -160.32904071316759, -67.067350004822956, -278.23956051582218, -331.99483948441792, 218.64685440389982, 361.34964916105656, 101.77623660206029, 219.3102673204607, -31.256238218792895, -176.20174018976272, 215.44150059377483, -48.336380649171971, 167.02501401904206, -61.584745339190363, 114.94494038438917, -90.080512788059139, 82.246061114843741, -132.18358420145773, -213.99997775297797, -67.839176016151256, 122.5321084131073, -120.23201716162231, -83.86741437773658, 122.15787923442137, -9.522168522250233, -273.45587058135555, -126.66693046669087, 196.70462782610315, -191.73350924862052, -294.96775899924768, 74.961294571361236, 216.87101214968683, 120.66657935146822, 39.787503858165039, -283.67157071936077, 39.173976189288283, 22.311992780909247, 151.04480051874938, 169.01778890288637, -85.488049182182777, -31.547917715007227, -264.0260758249546, -52.105174219039135, 11.500828576379067],
                             [35.249200807803291, 131.17985559552349, 116.33483719863563, -32.739185232937388, 26.152018334597241, -92.630732042852131, 144.54635642062382, 74.098826189726296, 188.60683574853832, -21.394604449081807, -121.40585794456358, -220.59352111161488, -32.644792610644686, 75.313744262184599, -1.1994669276149454, -64.316039780118871, -19.796473295071063, -42.748589790190152, -137.05194097498338, -84.203539055854193, -60.029028554423455, 164.80336513483849, 96.578126976513133, 25.604593366223568, -84.822481210954891, -187.06753662193177, -13.35151906624926, 157.94093706337964, -59.900283226199804, -126.75223057542074, 9.5545849232527758, 68.175883230946155, 33.231988166578873, -121.67399070196004, -7.0278259680731576, -16.89181055776081, -153.44568553527228, -54.869336391804907, 24.971699908083174, -82.197542396354294, -41.464003316197157, -89.084484802616075, -24.92843655323615, 140.0848813974246, 69.397310169448645, 7.6208752378582743, 142.06709786961767, 65.591737143484494, -92.24580828341648, -9.8056776272973245],
                             [235.40390481157056, 28.352990871471505, -58.377432723704935, -174.10833231594154, -46.088069040782017, 226.90547943984478, -364.22061874454886, 108.87688599032333, -252.37953388827623, -220.2290455757981, 208.93167943800404, 340.2492207812092, 231.36591258312791, 123.66646194284277, -139.49280682367464, 49.457463574939233, 117.97062489049119, 40.524615317999505, 129.82757299980614, -77.317023520505572, 115.69837292172814, -244.53151535620964, 2.7769885901164129, -24.663545621242726, -9.2654626346359326, 20.406067975734214, -0.15931761022618995, -204.56474994408822, -142.67754023819708, 76.446340682348094, 149.5734132358657, -126.18105450035888, -125.12508557723389, 96.66101060840677, 70.300533793549661, -134.12192837017656, 22.941886276463805, 16.256282556137027, -94.15921893603246, 162.15118882049975, -62.510131066417927, 88.099462250699432, 63.451254298935218, -294.02670080835009, 150.15553559688078, 118.17630431387688, -10.56531875056843, -246.61291088990012, 118.99189642339304, 102.56260408179264],
                             [-87.496829996487861, -51.25359390700369, -89.383824327177038, 149.81623382076052, 13.993991978386434, -65.901193533338471, 55.195820080730336, -21.81313229698031, -93.817922066039131, -53.678166247061647, -93.023192487430464, 222.73619531798471, -187.8040413014669, -12.906744186623467, 85.971472537573021, -149.57715755576612, -32.918142343341337, -141.17770437268308, 130.4945856543429, 92.245688155251756, 141.7139995318426, -47.301806455629531, -74.218118621817567, -153.84802117035974, 110.07184149231541, 38.754233847599274, -55.218244275583906, -80.872214809313519, 300.88189229411466, -8.5974511211700833, -161.2519543104705, -59.285745902974085, 16.709144238162249, -5.1844455725105094, 9.4226486441612405, -163.56860538505984, 147.60708276513307, 68.336266618041307, 63.83886358093806, -176.77571291620896, 13.168929988740107, 57.527484239845947, 8.4254921995206917, 68.329665902391866, -132.95381086594881, -135.11387548814128, -205.21597538526314, 77.831708121640744, 29.932442010900147, 57.811516271292149],
                             [-116.41633054312776, -230.13912991065467, -84.259184203086619, 81.605785453264616, 17.837100953702635, -26.573771199703863, -0.51809366408478397, 31.431394695243696, 87.372056939690594, 228.81481491530329, -23.747298518752636, -133.39793980534324, 73.052457169868987, -62.615395529040832, -42.178517563399545, 164.2935558002591, -182.17459244714937, 214.11593279461258, -96.318256696246834, 65.233064090943373, -50.464191012825921, 4.5451135070468887, -91.421004972359995, 117.34484008189105, 125.40412051473533, 102.89901612961989, -29.436863614590475, -17.899046846128449, -6.3093204021694191, -68.474689709854403, 46.77567375061119, 179.22321173418047, 78.191169949300161, -49.646091873929201, 110.93070798169421, 191.58447543210585, 31.445526485263954, -140.93060750524322, -53.514258627581853, 14.97139932536184, 159.90697728634461, 41.835057908709501, 27.592664403355059, -201.29597900733503, -91.806832636854494, 168.18891000311356, 0.40222100382784376, -6.6738933675375467, 15.725639343932091, 45.907956274532012],
                             [139.84122386388694, 236.43563873000932, -32.128645929814986, -200.85129565893698, -160.35445954905902, -57.784150228411242, -45.516099291321282, -58.665824222138724, 115.27070690856291, 22.162132045827001, -172.76441921887303, -84.804132530677947, 79.023669880443492, 135.69739166659227, -50.625586457431481, -4.9712202630622944, 95.686989693601063, 60.683095809913389, -4.8815385930863524, -130.94072172361302, -226.70420351067236, 132.02467260513862, -12.852965045265274, 29.902818190914022, -102.43316761219782, 11.486430160080689, 119.59188601718238, 103.86697692427535, -110.39179888080376, 23.296687125417133, 22.22162066591968, -105.52723167297621, -140.53102224023067, 99.926039920769867, -59.663960186918104, -24.101814397963672, -111.72341745330046, 35.398662883675378, 56.013255032951662, -1.5448800808960101, -235.31437602804979, -14.070488301712832, 92.414319228759069, -126.59748043698251, 122.26201447278261, 46.536297500074525, 271.73496317154076, -213.61529158721331, 21.386547272149244, 63.871199361572621],
                             [-183.43860754918683, 59.428432855364846, 74.001276083399944, 63.187940716943402, 100.90888948247483, -214.26426005026465, 284.00548014211222, -117.98222876522773, 132.47054983269064, 86.356980492489981, -192.31137255203927, -179.98711052725477, -149.53074068416271, -130.8922426147254, 115.18781795388684, -19.566674613249809, -88.620654868092814, 35.440183689263954, -20.482087428456907, 65.16091865956659, -115.99147971595353, 256.67548643661701, -5.8613631365666805, 37.489737450324199, -152.89686023421075, -72.17393762979242, 7.9777988138015949, 74.741325089035172, 6.167439198764292, -42.091869185143139, -151.62881978682924, 67.429167623367164, 21.087755709235196, -130.99555718516882, 4.3711252775546612, -61.245860623245328, -121.57362260319603, 83.244971747056539, 75.892258156493455, -231.10697384717548, 25.268508391760342, -30.424598894122269, -76.408960299252584, 193.63186231586539, -0.2350646150523783, -11.282079148668547, 97.247980111815679, 127.81453941575701, -57.787633604207571, -102.80188289942458],
                             [28.902136003758123, -204.94620915720725, -239.48642766441802, -3.5607925957528077, 14.815812535971462, -116.51524409067655, -120.77701000873044, -218.07928439105081, -45.547800171660022, 228.29936092726618, -17.843642040993135, -30.016301922583033, 93.094118390652596, -109.95742257958639, 33.522780752011506, 122.00505694854166, -89.724108398430673, 215.23180208338849, 43.869173838701187, 92.770349819315115, -141.90023359718654, 90.695515765841279, 17.396239886137547, 100.03791875285916, 41.86038242230542, 150.64298388428963, 79.50046853496552, -151.05203277976301, 32.023485535537368, 66.54808049700739, -25.675411185802666, 34.090748862524414, 88.025982046158362, -117.64589930980169, 89.894750180554723, -15.09699370465972, -31.403983317575804, -8.8150979925854074, -4.5995082960568769, 21.50401164898728, 7.489862578995754, 67.037707841673466, -12.959319338688811, -287.75393300855688, -159.74821280923481, -14.600341047816354, -7.1357394653591353, -116.65765443099535, 141.52512919786943, 45.11168690749286],
                             [-73.058440847211514, -113.30340550151558, 88.451657602645085, 98.20115952100339, 97.82331908288991, 143.64450549620148, 73.942767592205314, 212.48101138123118, 68.899816335129756, 4.0728894518401555, 103.10573716645457, -116.56503476242966, 19.808439508913924, 79.247668496476223, -57.513544212306044, -16.187813671799624, -47.202412030570059, -36.055751255942504, -63.501648034547451, -18.775707560461996, 120.00319944169239, -105.96039303981448, 5.2898229946846662, 29.444042655879318, 112.87657443079968, -60.141349812404833, -71.054698215398702, -3.1325293851802298, -34.355246537327211, -90.408764649742395, 122.78114458316044, 119.237636119539, 11.762082693687857, -51.802682613790687, 22.783954436423031, 137.86751352005697, -24.289555735537629, -37.59856240449998, -104.1207544655604, 200.538143764067, 123.04826743227819, -58.982407947810358, -17.61001903339627, 32.624460773202408, 21.180022504951332, 20.005376488438646, -42.486191268542029, 238.7240600919115, -32.758818216748935, -112.44139456258414],
                             [-192.82484932633577, -300.90734008088845, 53.327957475968546, 164.23786904176936, 201.15707228513807, -63.117993910860633, 96.381294117388251, 61.948162178057224, 33.143311050315816, 105.07272241648354, 80.866699097243455, 41.864974353604232, -111.8512222944378, -267.70704504826926, 57.631526951703009, 39.542073821459113, -158.32031403400603, 82.666847563118978, -32.156849786200773, 118.4346271901529, 204.27057284340239, -3.1173472649031453, -8.6642977642286834, 5.4281376969422892, 191.16604289772604, 46.992733627339796, -217.82911372506831, -109.95630446720057, 166.20995527422755, -63.146759934854437, -54.150021118868636, 86.914890317879085, 184.32642864502228, -103.73681910329331, 112.01342621856905, 91.091817001470204, 58.522705636931228, -79.134676374964243, 20.924210791682988, -56.648469855435756, 204.61543304727459, 4.1809832621726883, 0.84094869951370033, 79.079276796507173, -204.91004773769572, 23.679374425904925, -146.3420504962495, 265.19816450144089, 30.171025536709536, -159.24587466347316],
                             [14.450131748305687, 19.57859900982373, -43.720760008501202, -96.720200930309659, -13.908550289066209, 78.794270996955333, -149.76465318420358, -145.74133895028635, -187.54484759105719, -131.651069228849, 81.703756268446739, 331.96659557954564, 14.736281803233727, -30.936425999400456, -19.242625134205994, 18.497294199944218, 102.92581848296285, 55.23426457294223, 139.56051190405054, 85.828709554257728, 80.050618040430152, -8.945117870727362, -14.583395074671305, -70.675393763934437, -54.373051003367927, 49.295842185573406, 41.896916277813936, -210.74240100833188, -31.332094056939258, 150.95783458640645, -97.660234262002092, -150.98545373806471, -61.67831632249657, 98.137087152276592, -66.833123513524157, -225.70725979557636, 30.220658306066966, 136.18325942541244, 104.92776280629703, -74.099754398802745, -113.27650191583849, 171.10463663022543, 53.65299640688788, -71.429431762357225, 46.773631016225096, -19.163648758453828, -58.775577155478928, -189.98823681375842, 50.280623627753798, 74.203102815152675],
                             [-38.919370967658388, -126.63934940863932, 9.4605757686820819, 48.042752570908029, 147.6289552735243, 6.8291259135849369, -15.725719204824452, 81.217770159113911, -22.06276295429339, 146.04988637569264, 103.24417369374046, 30.650835713623248, 39.222311321999385, -192.78813507788621, 12.963052380861223, 39.551235423478289, -140.49468822780605, 90.875913373655123, -32.058901037749919, 19.600386534270719, 114.81780684287079, -31.719465396985534, 88.690161093387573, 96.292692749010797, 121.48380831559228, 143.59972136849362, -100.52735711234097, -49.545962475170626, 28.098428652582722, -17.74062462680503, -14.651525584903858, 70.769196314932771, 125.74634255861584, 20.051729466571981, 150.77133626902491, 136.59444776108992, 57.097594944715595, -83.93746481198562, -46.395838687417353, 46.731614050198687, 121.72333601115311, -14.602084698415547, 127.87869444638787, -101.55734331297354, -106.9261406323984, 81.930964212415574, -37.854838535347767, 110.84445817110026, 118.32895563301535, -140.05127036104435],
                             [69.710335147506356, 149.86633252774371, -321.04469876089399, -61.458713529049831, -171.57994532109703, -240.828066414837, -269.58833985729933, -355.22907322160171, -90.61929297584112, 124.33821364039429, -255.02896391374122, 12.883210635373125, 53.436097255474358, -38.459804904122642, 113.49951591441929, 26.741460821454197, -8.2418649376120801, 35.752800748665585, 101.62896301863492, 25.609448647113485, -425.29229582271449, 113.15450268240157, 62.374367816280049, 54.778357979990304, -12.483094539817522, 327.21334265911543, 237.7945071879455, 17.195644042478033, 27.849485684962922, 176.37126925358271, -183.25861144202838, -13.429107164399499, 49.907563483593385, 37.443644362197304, 15.35716281770863, -128.32385412958388, 41.725952368595152, 9.916297532695495, -6.7254954901389947, -261.18591892940361, -110.85847992243964, 68.950384081132086, 81.099523360304588, -172.292074629398, -61.178396189469936, -127.98247851151949, -14.258159435469066, -428.13306187930641, 194.10458000147074, 275.76551725573421],
                             [169.43334061462201, -28.444622356654769, -12.630525568143169, -90.86844657910386, -38.807411348914101, 184.07654306066431, -163.97562988127999, 207.42852636528551, -50.356335563020949, 2.4384794412233037, 87.348676540423725, 13.909845385637942, 193.99999416546154, 181.1722220615633, -137.80426334821294, -6.3111618751199359, 36.212088272861038, -31.017477929959185, -17.068382011941473, -83.141899222934015, 50.330917578711279, -152.51653314094003, -12.024224168597389, -28.236058930205843, 7.0278794779483924, 19.529780059972992, 52.430199647480976, -54.391190033320939, -127.9511850314133, -41.275446517742736, 204.57206519287658, 69.186998139917051, -85.804417241067512, 54.25959736941909, 12.011414898423958, 35.637450890602942, 20.767466463645327, -29.602465676442336, -68.178961797144424, 330.02852447886386, -17.563881560355203, 29.346755739521331, 53.06899271394736, -268.41771679682893, 183.13403067673261, 38.958460042419034, 67.394263206823425, -9.5793307019795026, 86.384465921016826, 1.1773636532997021],
                             [13.025293466100717, -116.87043410863146, -135.22272651055255, -28.724601445661818, 79.474978644112966, 32.031479375836348, -67.178845702691845, -115.43465812981269, -40.391576605257718, 39.732631173107634, 109.47328330966525, 190.21212368609059, 86.828586330940539, -177.54199511798043, 32.917210949986078, 77.869507043639885, -3.7310386849107706, 122.45391590177698, 52.351557453012525, 74.357931897401485, 42.426168466487567, 8.0995457373819981, 79.90979956580037, 59.837466383407033, 75.097950208072817, 53.785078204681597, 1.5677973623574173, -53.335000505288406, 36.991960637176632, 64.99381043711216, -61.4001090854347, -88.523974840136177, 22.911442860402801, 66.746722616657706, -10.13088976624933, -92.977675009143198, 11.229331068981587, 58.028405765011883, 23.169925052246132, -87.204116001101482, -44.264078861191038, 72.443440817221926, 10.101486538563769, -29.690637407860333, -138.36079438925745, -22.889932293283856, -57.984049868987675, -66.975466370579156, 33.300916419252097, 52.848792354784955],
                             [-100.06197229382464, 14.86953118773803, 94.21464706962837, 65.499879345793616, -16.092533320349901, 12.901824344417191, 138.29619638814813, 129.33404579755117, 101.30444310735945, 121.04518109655184, -28.815471322494815, -104.23643447071564, -5.9333164239208358, -8.995668236731948, -7.9053809495686007, 36.119267781126922, -129.80020042767791, -73.011638903076076, -112.4074422946629, 5.9086014401840581, -69.018503935186416, 63.807450199607239, -39.250633748854469, -44.143384415664997, 12.65089020187726, 39.422696033985169, -6.8522476071241076, 50.954382984699656, 4.7996066535025115, -80.027102989575923, 76.955731818825768, 80.139486793839197, 31.790293357623028, 11.731022082848886, 16.339055543988025, 106.6044238022393, 52.124334773390551, -52.936590670217029, -19.752238523144598, 153.55189493661211, 7.0998354836997866, -96.055923439236423, 33.975842123316561, -29.167642136379158, -5.2573391066303738, 7.1343175873469757, 37.976253028594442, 85.131367427288112, -12.277861311809724, -142.92345355889387],
                             [-7.0709242984682277, -266.9516697494206, -245.85621425325206, 134.32590197985144, -5.6789040830700195, -35.849522815494666, -174.36499172393997, -40.480914754358231, -165.73393355300905, 133.54465534737304, -113.13132993700631, 81.137292557355039, 40.75043216160342, 76.228329425940458, -90.176989080917153, 102.8326377236469, -147.28690684781881, 36.872635588621172, 182.8596073670987, 36.816502923869315, -67.919715837103666, -125.77160402174523, -130.86140579148326, 49.382789312956156, 229.64503191512046, 234.58724686046745, 31.401702974362614, -130.10500802760208, 42.506594006900379, 12.315340979372982, -19.673416498679508, 109.39885878302346, 18.434149921628755, 85.012297429600295, 187.70341960749559, 109.73728509396774, 170.16281251119415, -52.702152663683286, -82.234007632026604, 19.709173268428909, 200.85969370660817, 108.93002996318471, 61.137606954313156, -463.18064517601192, -122.13385289884083, 48.705301675966673, -154.47472387667736, -14.407072283664316, 168.02438376073937, 186.02987520460596],
                             [20.769304598269088, 86.672965416383391, -302.53677117890209, -71.207063396127253, -230.66114206623649, -131.84424447381778, -65.469751832173884, -257.8586089450348, 24.758019134023346, 27.967392224643469, -252.23872239259924, -248.2224190397871, -5.0063694607820324, 8.3140102287553823, -39.053754965664986, 59.986049276631412, 137.58786276617133, -32.113782210657433, 106.33248334573585, 4.4465681208655816, -397.11700684959465, 68.874450095522405, 9.7499268856312895, 37.738950241218184, -134.52767004907628, 77.505886612883202, 222.1033166709399, 98.793097426451354, -97.58809959101707, 165.05886787611368, -64.541309680840982, -3.1898995608986267, -88.399355922989429, -15.529101298144834, -97.462637389072938, -60.455333936727392, -84.01322724939331, -77.877118725668836, 77.801490851661185, -222.77437150116833, -184.61791129173602, 72.183858170699835, 5.5864843158045652, -220.0520781269789, 53.3742619604729, 19.443166471462199, 108.45468511978747, -299.5148593808014, 115.00309785532056, 228.80932054705531],
                             [-101.73720495011676, -80.946659502574789, -12.402077429245242, 79.06827341733262, 51.186458435396062, -15.688304830981052, 92.857265160555087, 44.484726347387543, 20.510597834616711, 24.825705650902961, 44.690522392887473, -33.31636851890125, -49.439734580336307, 14.504798182296746, -1.3431381269351377, -14.093369671578458, -59.945160923223575, -41.846104788382064, -8.8544987910818271, -8.1325456481909484, 73.731946555944944, -30.688708288870366, -144.90477540832768, -15.459631843202647, 30.972812204688275, 40.335144417341951, -17.677877379393323, -68.480628719098462, 76.750009357783128, -108.52802753729055, -7.5919826690603323, 93.882803780146645, -31.040042200397622, -8.8214465007957656, 48.693969358173405, 89.096233968922718, 91.348035211517967, -52.230317246047946, -58.916384062018729, 4.1633738207443045, 123.19766292918852, -39.225655568501949, -18.62279858491485, -64.171468963867838, -2.6980138611228393, -8.2199248392285238, -22.543045540057246, 30.170452694748612, -1.0189490428373027, -5.1935400100574647],
                             [27.424107658850868, -181.63781390295566, 16.430937618993855, 51.802689606366741, 27.545125845744973, -12.213525598053073, -31.200719971955515, 112.07268398183457, 25.636617705616228, 146.48714451399221, 8.0212296138231345, -31.545195221226976, 58.959313215676708, 35.47390989842161, -28.097874354736071, 72.521074558692916, -64.407815653513666, 74.541544620610736, -49.94877732647447, -23.55776817906747, 51.945546221501026, -52.252405499075124, -51.5689924765407, 35.480305039777214, 65.792427977436347, -33.21528511455638, 9.3274604477857821, 3.9050918791724372, -14.437244275924407, -76.281307441265042, 60.640451792390316, 68.756530075356139, -13.519756928658246, -21.058094463445215, 56.519592909037407, 115.96881454197894, 22.721141477454076, -43.718636321471841, -57.540334155973483, 227.93116537069594, 129.01080432167049, 15.537635145097234, -49.250016794268269, -137.5949607821062, -0.4870921612821022, 25.146516168053076, -0.84405756953284516, 83.919426784520596, 37.775387828993857, 15.088364027101502],
                             [100.50180427691781, 96.717586327939784, -38.887203045193175, -106.98724852360873, 50.795511458942016, 145.46515700927282, -112.19679878741402, -10.938513127240046, -134.57540971644227, -181.57912919733545, 122.40057857011267, 299.93801709316449, 68.787319124961144, 38.651652927527095, -22.382832841141543, -68.409243909930979, 101.44372525863895, -115.70120243867231, 141.17102517246599, 37.836572173220802, 74.752862634071846, -58.223201904115072, 71.677011886321907, 3.1344502444345297, 124.30630941707284, 137.40302324274612, -121.3973848803879, -121.28333021357331, 16.41644852205588, 109.51947440086424, -60.752971670211828, -205.38704549780607, -43.316908620697916, 157.92241695118381, 18.270700120865751, -146.12546786911992, 6.2346168432305067, 43.847798130671713, -36.158539256842843, -50.614815361013257, -126.19543563325034, 42.679086951472158, 167.89334621097956, 56.285953229383828, 5.9624181853100602, -107.83030106454564, -82.674175468559582, -78.408664017488519, 54.809137867908568, 36.141464852461667],
                             [25.035510973026369, -62.687439741475664, -3.3930981664482989, 8.6102080514884776, -50.030998963673426, -92.921829203438378, -22.452490378925734, 102.69990777890615, 20.149424847049239, -36.12721382023134, -56.709682512752465, -168.2890126082531, -61.629221506940468, -46.271025087723004, -6.9196527397632961, -16.783835614230981, 33.891063366900646, -25.778886736339992, -59.274129405930765, -59.348182002767814, -76.855620907345468, -97.901519972182896, 94.720491671003913, -33.351660418184238, -30.87899786768827, -37.312179339122835, -40.31320359797315, 155.60037805173999, -67.309576223082104, -42.047226537813771, 28.275384810321601, 0.98119706827325714, 65.94238478420182, -77.261480127421066, -70.291664447550673, 68.800882743631362, -80.527629988850009, -138.56258707949337, 53.130111145258105, -0.80871818136974305, 62.505099805595634, -29.784075670449244, -41.504106749518428, 85.633101517696119, 4.6975032330864064, 90.151666081587123, 43.443417877434896, 68.974911195385133, 76.095892579154622, -25.670794247403336],
                             [-84.784257913860174, -373.42794686951953, -253.1186493394888, 178.50988349586518, 94.522334547043044, 38.393884725918618, -92.556130161254188, -57.315814704789808, -13.206757925246736, 133.13518773871277, -41.535659070544568, 19.280377178610728, -0.51524625778681798, -218.46743204679862, -67.632092894690231, 77.669093872014415, -86.096030302146389, 197.42170648349929, 80.827997760033298, 173.44138787853433, 118.35689065946445, -30.654406855103087, -2.2616012572272375, 111.81493574401405, 371.03952330091772, 80.8322102234212, -68.080514227359927, -133.74792583839704, 151.29099969063003, 48.941427413774228, -103.54151577834988, 65.608871034963258, 186.46002749474241, -6.1659458969192222, 87.678767782079362, 65.86395888762965, 117.61152450293562, -3.9027630333629189, 12.098291020482772, -173.07954257900371, 129.83615130266418, 222.45485416076571, -1.5454189450407423, -134.18706747549882, -142.40476066011769, 25.473985960831673, -268.2335935098132, 204.5114864131298, 39.13345560431754, 111.80756190442642],
                             [34.816440738715642, 46.565182345350074, -0.12733647045712004, -29.124988033095956, -31.563507896679305, 26.624275762193246, -24.97752496987728, -19.99960738244544, -88.155808054275809, -143.64210871692478, 95.645894861348708, 221.14168037496717, -96.289947153808797, -59.715584239263542, 69.305657460812654, -23.751226150982262, 173.44932738400757, -61.359659690501019, 79.564844789850255, 7.5422074835327191, 55.373891182819918, -65.120037944659515, 112.62765262623873, -76.076774218585356, 40.163835429231575, -105.54230187641747, -133.54390041861581, 51.372348821800266, 17.699271245186122, 86.329732650049735, -6.6563810411073847, -205.37123994989267, -57.490098265159475, 127.77298472714548, -49.188084828516381, -134.62390605314286, 22.116382084694401, 106.24053535986577, 22.630957052971695, -95.441187676073056, -70.942636233975151, 20.627332870656865, -52.367699637161714, 186.2630652994672, -28.654908877191204, -39.567739248538928, -129.56603186983233, -0.71244863525298019, -71.25032832376327, 10.488551563964219],
                             [13.540307856291694, -82.744657568914846, -144.18688220114765, 75.818692442578168, 57.337558883555715, -1.3782927700418033, -65.12660171543439, -190.24672939982298, -216.74009888942794, 14.541092371745744, 58.537528026321269, 311.30060485442903, -63.543121319320974, -108.49630532888929, 19.363401395695778, -51.341548474539614, 17.101293220263777, -2.0628939327255189, 284.07181223738576, 112.31399430461417, 136.1781034679978, 2.0298503549492972, -2.7369558692241647, -30.578062494256105, 147.06428830238957, 96.642658770807842, -49.274027457045598, -228.41364980356261, 201.42528417103961, 108.94090554859216, -173.72483981096732, -81.306472618918662, 37.640647211693981, 104.22362554100181, 130.35876288603527, -81.842776588252477, 213.42954202193141, 150.69681821683571, 14.539199211225185, -191.72108524307387, 29.30407548622469, 110.23736564345356, 4.5096824454038043, -120.21259972078882, -92.421520717054875, -137.76476412136597, -287.0363971274416, 52.215174564632292, 31.781395968514317, 54.449348300753769],
                             [166.55293805533481, 107.62195358336966, -24.659883541492395, -164.22843073482184, -50.166184860975839, -46.608283751064697, -39.864381869952467, -125.45676638021777, -88.644753291893181, -59.251829145939148, 118.88914054019635, 106.96436055587586, 51.034692819779714, 162.59586669557427, 39.096458600424839, -48.810256094579586, 72.839205960361426, -113.27708888132545, 13.806608909229528, -55.353605478696657, -112.40189043809494, 37.204544129203455, 111.11361622767279, -75.091640694897336, -127.31543570809805, 64.577895328796174, 33.954175660450183, 27.767878121411378, 39.504974648413295, -42.996097488939874, 55.390765995880209, -138.58252282254051, -26.619653794017871, 17.491052930988573, -101.16817032628093, -51.792988632810861, 28.317197860763379, -79.795020514895853, 33.309923949244507, 41.406649220364635, -84.119788748142227, -126.88836366334944, -58.719877593789874, 33.192394078107029, -71.257390319186214, -99.990282501167485, 14.545552864165945, -253.8018556226591, -41.753928713291437, -2.8548599297166595]],
                            [[257.85418171590408, 10.098641871249466, -42.633906743027588, -3.4795023734266679, -280.91034317599684, 16.316052114441316, -108.10224235308998, 76.152145932742698, -14.448741409509324, 218.44267393549097, -137.75743439570618, 55.802464303197887, 53.156186402821703, 120.89131554175063, -203.41944988220877, 103.56642137132934, -192.01273780086328, -15.015519349964309, -53.121825326021025, -4.6790255617022316, 77.920770700532159, 113.84354964452962, 81.041897044624562, -11.967940629297381, 108.46826647299187, -122.68769951388828, -174.0881012810332, -215.60962170124191, 56.756392082751972, 42.572987651567026, 20.228275424606743, 68.773929438616832, -99.382899813668942, -25.748545234691928, -67.267613376724228, -174.58049593257314, -205.50482559832815, -28.810375266767334, 131.89208639844134, -179.04763145699368, -130.89815040697573, 136.58320161291587, -58.81219338621964, -185.97980457418458, 129.90639277379401, -45.198572919550585, -169.32459384863563, 247.06504615507058, -253.56416524897384, 35.671902940642845],
                             [-143.89832971048006, -63.370271462580561, -178.86372008168476, -187.17400576075403, 180.29172618417283, 21.681048888787565, -279.26107464872712, -143.14463946976409, -207.35068395360835, -174.17589716935146, -82.861877972526685, 148.80564969976322, -94.962732685153583, -329.40487735878685, -62.791315158480003, 276.7653424661741, -114.91284668352573, 298.99876323668855, -65.02044412131454, 188.14718900201368, -161.64722278758981, 59.406603612143208, -0.84984707143631599, -292.77529658895912, 445.17621603633353, -11.483295253372878, 6.6590844062513499, -126.19730672992557, 784.09522283409478, -138.85847107167623, 229.27097507607931, 75.649704102817722, -219.76354977718387, 197.35861492289837, 9.7036438641738272, -103.92003930701874, 60.958028192457839, -74.22105864237507, -567.85683941830746, 193.98714486577649, -225.05781692903705, 193.83504218582041, -369.92127173102989, 12.104531118076475, 284.47291509753268, 118.82353468878335, 432.48190685164826, 90.933350063210995, -189.20990135286087, 210.31229861488211],
                             [-116.96881312408247, 46.122432439135352, 66.670495593851115, -65.930417766052543, 142.08793394952585, 1.1472338249475091, -38.602510836656208, -85.400634299427523, -115.19063597788777, -201.10327895963383, -155.10636334182337, -20.680761030989153, 61.118949020826626, -130.97049373885037, 78.465704423523306, -64.116757866328911, 129.92172722733307, 70.872507364694897, -20.249016055330806, -23.304466610249861, -97.277591796000664, 31.152111797792998, 6.6205264248128097, -149.89189372681875, 165.98322072135983, 110.2430365589168, 89.096820912458298, -72.801775817453091, 153.4428882571026, -59.122933420046344, 86.422071714400332, -85.000227610129883, 10.700606035939531, 13.368239546266917, -4.4136067215740598, -118.65156996815071, -8.0065821796575829, 24.429751988398625, -52.801842417302638, 30.751737860226424, 37.33963499958778, 70.99659390214741, -70.998534966603984, 82.172341663412013, 43.566763992230605, 104.78555798252185, 84.475536724061627, -79.874607263257644, 34.01292273342159, 104.14250925575341],
                             [-288.32479984297822, 49.854058640350793, -29.878079784215657, 53.653781210689992, 161.40274408421431, 10.653010738919081, 81.641149699504396, -146.89689417248775, -102.22340385081128, -177.99363110371351, 246.42406943206666, 58.974968286077811, -92.224311043670454, -87.761906346784428, 387.70930691217524, -289.39305813918475, 103.99434964784272, -3.9821164525125226, 76.627070135007457, 71.362196934163165, -20.945200166009666, 44.686070393816998, -74.292781924425796, 118.25242184872805, -102.04698161535055, 170.6594015011141, 195.9759860625592, 118.31431609061664, -1.6555312887335953, 13.151021190429489, 199.39747527440738, -10.410971815954648, -58.642513720900212, -34.348153465658605, 4.2624755131511147, 187.73434359993274, -30.98997444262621, -132.32921613315111, -301.13741405880603, 328.84878090306353, -5.6179238366648789, -343.9975563025202, 212.41957811230705, 115.40205428107642, -58.293782429194806, 153.72102591505512, 128.61468278527269, -246.70360145091877, 83.907576780855365, 46.744037747273168],
                             [-251.33408981474213, 82.485763552663784, -32.664563227589795, -77.776596582460527, 225.04713953479816, 132.99271545503686, 74.14959478999458, -215.44568585627454, -306.31218145708601, -374.61234280974026, -107.5974962039229, 165.06686591521972, 108.19608151134599, -317.97997057099792, 176.65797809298778, -402.65010887473306, 124.43084848718357, 1.1874687719062114, -73.116079070767128, 81.522532928284193, -118.84080319879187, 336.26390665704645, 34.20801443134539, -36.420778423928496, 226.19424335087479, 214.3398165794377, 113.0898628481814, -156.16439530595781, 196.60645118778393, -70.022610981493628, 437.30973280327356, 85.596048536344171, -25.508078120513222, 199.54655317720943, -4.0242180432244892, -134.81565292528853, -278.29682222948958, 30.608662585222483, -499.7226426137247, -86.763795951590623, -65.747896543326192, -34.40181093547011, -38.347355417492281, 2.4584615111880832, 166.70353217655659, 385.38371182020842, 113.47702394876084, -32.981785436024929, -78.140206351170249, 360.93667006024481],
                             [160.73848164340046, 48.961607458470695, 210.61458296704131, -30.58082994002935, -9.3801048477265052, 84.022143255372285, 153.04822486698771, 59.585064466273465, 39.815304245819277, 66.826089477422059, -278.05971019943399, -193.94557934297438, 121.02403214587531, 157.66376841307294, -90.775106673752418, -50.436186380696149, 213.03421182283404, -21.303621268434188, -83.304139309595385, -20.046710059768767, 71.529025753939251, -94.931559902335835, 135.76382762357468, 1.2416027094092701, -77.630279672426951, 26.276888221306148, -52.847640586531178, -96.403533724682362, -268.30285461341333, -12.927911031446303, -216.57002814907, -162.71869876609892, 130.94862936300146, 4.9341997527677419, -60.573479351660922, -173.08075066787708, 26.147658351825584, 10.943368795801566, 507.88462942830853, -103.60772406500804, 48.573406038317842, 242.7084248255232, -51.396255892484355, 40.87455080364964, -13.976733009547475, 68.567556260708358, -232.38959026497153, -123.06452166137848, 68.517460682705007, -87.158711596638753],
                             [-22.838639760205634, 10.623297784606276, 121.93279873304442, 49.756417697702034, 112.39775452120364, -91.837923552365581, 0.061484420953624955, -172.11034085254639, 62.712963906754602, -149.87924072552161, 131.88909752749655, 16.581098963255734, 74.093068951099198, -96.403252365458528, 66.227847148037711, -26.493184568091237, 16.250129324006533, 64.034249185540389, -1.9476147959183367, -49.487773291295213, 80.297414523359336, -175.0502316788984, -36.310609241330489, -12.87200462359446, 20.885269263588199, 42.538859806760108, 119.25843973314284, 121.38176461066247, 64.549123192600206, -66.592454313631237, 141.93122411451336, -51.277104069337582, -41.540306726580631, -80.024413656193019, 103.19027147332557, 28.196971025355623, 129.83496675995355, 4.4369965209225422, -125.58286883222181, 160.47203146765625, 21.226984438994229, -162.94363302805917, 52.329960049251454, 135.19130769580721, 52.179167455816753, 78.118501756091518, 166.73167839250263, -80.989214725176538, 99.403208552010113, 16.5574774167298],
                             [-128.40900260542392, 137.98561022050097, 167.80066390107478, -67.764328634120318, 208.31676484796085, 77.091396950678231, 204.07389732255839, -282.96041764508232, -350.44280901689473, -244.28594838865959, -151.8034656895417, 20.358408389445131, -35.900488785370328, -200.38550304317397, 153.7944043257946, -249.55513904423702, 30.210427893946779, 101.56766564336449, -43.704381568676325, 283.30447265922334, -230.59358932790084, 239.89842394076041, 192.39961904957997, -17.345101012536993, 95.959487588159718, 229.08729758494769, 132.5381392002401, -371.61940365264059, 371.01568500294667, -59.163200271171689, 255.3282281004044, 122.2651179498796, -15.397995091003397, 158.15562206421234, -123.45030022900238, -108.47675451793681, -225.46274156567296, -53.507524848584573, -337.54184217677283, 103.39117545028937, -204.84566064367527, 228.95388221697405, -50.411986356980698, 13.421972373165534, 213.187503368026, 365.4335943280675, 133.71197974095847, -173.91644322808824, 30.904042080054481, 236.02993656967359],
                             [27.874994225325548, 67.745875057007211, -199.19931058274148, -149.90776484529692, 41.576027634619535, 30.531813275363398, -83.598203616067309, 21.959213844190941, -168.96298331128929, -43.393320634055286, -203.37442626928669, 26.048230102942711, 77.643225477003028, -102.90945461408704, -71.268387543604703, -46.577213979835292, -82.868416063151926, 100.66461876156953, -37.780751335305816, 14.937090975216275, -98.155681516017211, 200.75273490451028, 20.781796934008799, -118.65943974882096, 148.03600366826569, 19.702366618696203, -2.6062893822734399, -36.314731657526188, 158.67138327007561, -98.440887399157759, 70.12712226914222, 66.56931348609578, -4.7297767698441806, 78.84144745331912, -57.323771719840991, -180.10977423944689, -287.28395955027452, 131.28266149099238, -110.93699329781541, -283.98207932122585, 47.015703628335231, 182.54425733704039, -46.690000069724547, -74.96477632705728, 102.37792385280773, -25.056823836348958, -120.42784877371908, 211.23341836364244, -154.84609944631785, 47.10656329753489],
                             [37.351651837783578, 69.365226601429768, 405.18415837386425, 172.32211933085949, -24.698664369603449, -11.532626851107057, 285.04925753892462, -142.01355647278601, -8.4258451321314265, -86.657770389681374, 68.26549721283331, -108.57345019193539, 69.01275910678946, 0.081457287976514303, 314.07687334915215, -275.56696206051862, 82.611873536207995, -234.44619702904379, 22.189811114377981, 54.634658087694341, -116.31172788152111, -42.124805076024451, -11.039373518512887, 206.0988806174345, -230.65556468786676, 67.579193519255227, 82.128706312303294, -15.04448710321495, -251.95183019908134, 92.908639029552461, 187.3087628689168, 209.88338168156213, 253.75203517103782, -64.414891648736713, 39.61601918035516, 215.92879712735274, -96.278852679590784, -62.437222005883584, 83.186872405086859, 105.80153144389533, 71.795464313832539, -226.94777202555349, 185.46011200881472, -110.15837857136617, -150.0050957347238, 173.31784323563411, 39.422519472544181, -145.88223026092319, 81.938449947452483, -43.15741963091569],
                             [35.04647655415085, 44.464681989566422, 425.82717638944973, 108.55620916463654, -135.06339231889947, 125.85823669330499, 322.67034706530984, 31.045034078872455, 93.157621678787535, -7.9511875856355942, -13.166065284309971, -76.999057203520195, 38.613003779734292, 163.39017304981681, -63.088532856977501, -9.7590327607378686, 71.175018023990432, -92.771943085399798, 52.431376989208836, 16.847170838150504, 9.2666413956400593, -63.461325609167353, 107.09997639670196, 163.26193431733356, -252.66064641002967, -12.820095623828466, 60.662587060742773, -141.48116570843297, -209.6298268090398, -0.37802114099386991, -28.375702104416487, -26.505724633032049, 140.98225979911587, -39.640203439375547, 25.234643372204097, 55.704044472869192, 27.05516936706195, -107.8253092072289, 352.1882022239385, -5.4447771148981827, 168.31923741290362, 121.61806893645256, 22.897672922944999, -77.468583742636611, -74.065639039959819, 121.8424487660311, -154.52253188332529, -193.39107418996721, 173.40984241701042, -39.485932537687702],
                             [54.098069037950602, 50.170684706526231, 184.54505605122222, 12.336037015484209, 84.955838206823373, 19.754514986881873, 179.81366071441627, -66.563919016578595, 38.159995312009521, -53.181463157516163, 6.0397057937725309, -18.920779652747985, -30.201495162280164, 55.422643290729553, -7.3713102493510583, -91.408308409072575, 61.403181100663204, 70.862428689981613, -26.313612985171694, 91.03467393633008, -23.474914945779165, -47.068729533499514, 159.53646697911756, 14.985676137096307, -71.300214365257077, 39.777292751815622, 63.543044375701307, -58.42584317077349, -72.667772153762115, -44.886326961824835, -34.801220757745376, -49.933639171930885, 84.586348739216405, 56.059943860457061, -31.4733066061779, 15.307467761749299, 33.978409015097284, 52.783306662118733, 93.582213794326378, 39.597442064279342, -10.062628075886023, 125.51065473190432, -25.781209914542799, 67.00036803265516, 30.941417210606048, 85.26125394030916, 20.32478777128361, -181.08600259386182, 155.64062535620417, -77.450516521086655],
                             [-33.037662635843326, 39.722437554928447, 150.29931993643777, 62.198812132133597, -60.125623140958311, -33.74956550898176, 124.82836184505454, 51.826666497141069, 59.109286171076441, 21.610561730534855, 41.447604372304951, -57.078705468426925, -146.7397001030169, 152.22864734180496, 150.21786682244772, -56.800007212870185, 112.65713217253034, -4.4053134743135898, 95.968026306407012, 12.128586092535068, -21.063031595692944, -4.4655213455497886, 50.171788465238798, 82.718961484602829, -223.93770099734806, 30.081063105327615, 28.953808556016046, 31.345575888370124, -225.1396564673062, 41.361424919649536, -30.031396582443371, -87.246713278933385, 103.9751720159973, -92.155778137073625, -17.489359817115723, 163.62811589538197, 13.99549988897097, -10.539253063978675, 167.20571495065192, -14.69785929679264, 171.48602448184928, -95.652843138903293, 225.65434861530329, -1.685496687993006, -148.71667599555749, -35.307058433663812, -85.274269601008086, -150.33597121766292, 138.10933427839242, -96.484786469428443],
                             [-21.812945964791162, 113.99717028287564, 237.68890831882658, 10.847820595955088, 12.423570530592849, 126.13870833161499, 271.36396846629395, -76.169130700276114, -49.158400947831012, -124.59396923313122, -51.958192390507129, -42.812633589566282, 14.552207684784083, 15.994223540994438, 53.754973824174726, -232.08805012323205, 24.753360964685751, -7.370361338411044, 81.417842448374643, 40.555055389583096, 1.4737343459359358, 0.44096413536513246, 74.651256834805849, 168.94104624973272, -194.96562088452578, 98.847393974976868, 146.58187602174368, -140.71821831142918, -126.97097939825846, 29.440848189805443, 36.433970414037546, -66.57695002806129, 36.066831138887608, -79.091639398715955, 16.783620898538029, -15.490432082478048, -88.790894497920192, -69.353734280345691, 210.51757240686089, 73.241255203347862, 43.674352617715719, 22.608329951186434, -4.7820156393929167, 27.523843434751715, -28.616968933823415, 149.76116505647011, -178.70649761082453, -227.63263745129058, 218.57860994586733, 16.97662742629219],
                             [-17.906739283514266, 25.639683115137252, 319.40822950392715, 200.07027346511819, 3.2124475950768709, -92.329550206217078, 198.61932087394251, 39.297936816501839, 305.24485493487992, -124.78873265589544, 134.59390881428715, -170.06197447682425, 66.442958978671783, 188.33314605861491, 208.79983404811463, -186.1104961707297, 306.239987476127, -147.68388095820887, 25.575788746182003, -119.61710380121437, 28.850520209550595, -141.49229573917026, 7.8268371924412294, -11.515053357262433, -215.13460002385082, 89.050239656095883, 158.69035647291773, 91.781300936172741, -549.14954948836385, 38.338032382727697, 55.506185825444874, -74.777697813377316, 316.14298578325776, -95.636929178788876, 50.434814701103441, 298.4767657691213, 223.02254277686947, -64.654698899988205, 304.30218792093206, 53.697792927102164, 175.43650647995369, -250.05567137771246, 208.99127698958958, -23.017882088482331, -202.19563286615872, 68.997478158900648, -23.467109981425587, -239.66519440688518, 266.39143550834604, -209.88171485193499],
                             [-246.93290959348019, -30.037707537451361, -200.6321187076982, -120.56152461650295, 140.47105611353672, 59.021994142961567, -36.22760613276072, -41.634398461500624, -244.68265587880623, -49.672798073653489, -50.373219067886787, 132.91278532333979, -140.13444439492977, -116.13002134073626, 134.23110439766856, -19.270259408534095, -54.337661201575216, -4.7343361462131854, -14.232003693526105, 71.841804874110593, -99.141626824773539, 259.99632918479847, -30.532233504126054, 16.369489774773474, 114.50134807356801, 30.964995158139086, -39.399265766771094, -64.897654330689051, 305.80553664717371, -70.176583942052204, 54.428379439386035, 69.76402294203919, -104.46008547718249, 128.61418387670841, -34.045434615605622, -120.73533315206933, -161.84915598811182, 39.412350229288251, -406.97394793146327, 37.74396422060402, -38.690727160867979, 90.622168707722693, -109.72671703055543, 16.738208358851008, 54.860674717477913, 66.285376220376122, 112.67914255093386, -2.9277973572449487, -119.69559747095515, 188.78270022991691],
                             [20.073671618507756, -18.923882886587716, 81.842408676650308, -18.570716613514509, 139.44407641849986, 6.4740457866310148, -9.5202736659294178, -134.01788420248502, -84.552028149150473, -12.631693498117393, 9.8172043510156755, -1.4224324357713485, -94.784767238115407, -93.982826579726606, 46.330036097899658, 21.109714404264086, 8.5284741674533073, 98.556890570380091, 17.784312755731484, 89.974875075169393, -79.704523436288014, -20.079995075415123, 55.378411780161763, -63.287227096802333, 57.047465416565522, 46.99087511557174, 14.072237620749535, -41.576709036022152, 206.04432976193971, -85.003462536100216, 84.779661854388038, 0.22174275378763367, 40.371537240975464, -10.165999999963498, -16.799062399252996, -7.9032712939627707, 89.496559676251479, -31.765491203838508, -168.39249943438313, 137.41804089561955, -46.713626834888629, 57.136353772948119, -76.43948671806244, 69.95965533445171, 155.93864067016642, 91.667089883279971, 187.0142535074026, -68.943541632365893, 41.422454789354553, 30.672334676556563],
                             [87.361708713257798, -25.009877235789602, -185.76660149965127, 86.792754238620176, -22.707908226764783, -92.787469606857371, -189.71595047108045, -88.936618911412225, 217.89198266147659, -94.752676277605985, 119.20447030218904, -3.246192473953641, 275.55854570135511, -96.080285327056927, 141.5959674651273, -123.71676000493646, -37.208288668579577, -108.93917835116068, -75.422323202018106, -87.040074718770768, 84.824083504366214, -134.90151703742941, -194.09026697471882, -57.565392559367808, 95.0162200915765, -41.366078368251031, -24.196232336804748, 256.81461243228517, -180.07316274526255, 63.857409322790318, 178.43291825608, 168.65590565190908, -15.201092401919798, -78.105605385843447, 139.46073063538478, 158.69840492945187, 8.2223588470448306, 30.011413186388289, -157.80200105558373, -62.112864036806641, -37.110160856847855, -351.19810242479286, 71.197729920564086, -8.0371380367544862, -41.44815504094985, -15.325440994841443, 39.93276336452908, 210.94500989587704, -70.076553651899545, -64.651852302632832],
                             [-111.69057899510533, 64.404771161985579, -240.46813961210225, -89.847875841116576, 381.6180796974532, 8.650887539726213, -179.19835966854384, -143.82827679466641, 30.49902421039474, -550.02136476103306, 18.464520885052181, -4.2139753367231183, 293.28763480438175, -377.25286819991101, 37.121814881093464, -291.11842604757641, 89.184808342200569, 192.97670766043274, -0.85186805202461813, -110.15512770950873, -149.80799670874129, -86.043997420887507, -223.05684269817573, -375.65855775563574, 253.97444101658917, 136.18833885613833, 291.97299568697707, 126.32434901165323, 44.116979685665065, -56.140591976530352, 216.70755367550044, -14.684104387907416, 28.642215383855238, 47.724605933603272, 136.21659173861775, 136.66416908676803, 55.379681882201083, 167.79002871109716, -294.78316742493797, -144.71841114242713, 0.64929344534495792, -128.44152074320246, -201.98886000011623, 242.84669803425655, 61.300619084899779, -37.647173512027194, 170.59177497629386, 85.961249535397755, 192.27781435827046, -39.897296809597044],
                             [146.92500143409944, 35.201479856869945, 424.06872574317464, 136.99790684642275, -141.3466346395121, -53.004108322495334, 307.15295121438101, 134.872166731048, 182.22025206215216, 42.679058816906867, 94.44145595745978, -200.9603583293989, 19.030135466308955, 234.21170060672773, 60.036694793759537, -13.95771333067362, 143.08048876535454, -154.89672838328363, 44.926529099181188, -74.657669739566245, 87.124862493657503, -173.95265671783812, 85.97151148631832, 189.40614761699334, -303.73031593472803, -21.851170511654949, 61.833788325191911, -25.232609042891056, -405.84801377923185, 66.134715091433634, -86.011013513543816, -10.27010362069309, 229.42634436188376, -211.26137863749253, 9.1051178591428421, 147.72899475598342, 81.729740280732358, -88.275894124810435, 468.59456825435637, 25.093607054563194, 150.7445147544523, -101.85637971812066, 214.70468125892876, -79.288246027534655, -133.07216575984856, 41.621191273593766, -147.64552866810681, -113.29553782339433, 205.07819234540017, -227.94022216744747],
                             [17.615759004294656, 80.625397288131765, 163.5772534000464, 85.958375800513579, -8.7336174420215738, -21.452358201556095, 130.64012882224097, -6.665581048717633, 154.10095657567808, 17.488700800958419, 113.17608838176862, -83.26649993126648, 4.2041787365706043, 98.573620907870932, 51.640781366074535, -29.835569933562088, 32.833097694580736, -74.625319909588399, 54.173354619049519, -20.180820418604949, -11.141078323280512, -209.57810171541297, 0.45502915416395728, 88.411093008270157, -132.92164213786501, -26.024911433282323, 99.402934184133827, 34.979837453967576, -159.41271867687576, 50.484700912601326, -106.95353499738268, -14.855225022220669, 0.24203934506889535, -82.234065760449582, -4.8029557275627335, 126.91188939225053, 59.92618296907451, -18.121345848215622, 218.7029200792897, 99.161320405154498, 63.737520390482793, -85.791865359068339, 41.809344572748273, 14.975645724506471, -103.73338213222858, -93.10456215953667, 31.370145701224615, -130.22192318141595, 208.37610637252163, -140.08670190663761],
                             [-188.7634318886835, -21.624883674510365, 9.7496822459753645, 121.50538342197584, -261.59248561637406, 32.914376224723995, 134.98127856349512, 55.378702829006784, 76.60953499178774, 195.82504686176921, 207.45161666631088, 62.563455208509417, -173.52366142241624, 157.99990521698686, 207.74551527334251, -73.922130087314216, -61.651521489953772, -210.22490634880458, 225.47438973528168, -29.496755686777863, 150.89940336380815, 86.17377201155594, -75.945440617265191, 377.97422678146677, -306.70696379091345, -12.470722896834992, -9.5228936214538944, 127.84626165022327, -168.05069060091651, 102.29643781069947, 86.833603374528636, 58.669975814233098, -96.966339383645703, -177.57053464607239, 19.415311450804019, 93.872975878269287, -191.40240521832274, -208.13732835554879, -57.422392490140872, 112.96770004039649, 159.69671730648867, -303.21977708033899, 322.30543651457094, -202.72171387459102, -166.25781481860614, 67.664918089246001, -123.63917910106269, -108.7327558105615, -8.4552455984439678, 91.231628595114827],
                             [71.278835823303496, -77.038004711178601, -47.943496451196388, -3.7336039882349707, 111.78077545407562, -131.20120202509349, -154.99118965687046, -72.973289143569005, 58.585335683463086, -94.052790905237316, 162.83643185995317, 8.8569067832853712, -92.638218617183469, -82.67709047525932, 56.515091190594596, 107.01268295122924, -14.174323967190059, 106.75393671082071, -37.198830866112516, 86.690109030308093, -5.6228656588290056, -73.95765074975391, 17.902783653874412, -142.616999952047, 144.51228479412109, -19.381233599796506, -50.018848916097966, 8.119744190794032, 203.60405354723977, -31.431070354483204, 68.889671572907943, 62.797581587718312, 37.594525495451485, -57.093124202960212, 33.946293910200524, 195.00860295379354, 279.07020360637074, -85.774628299141426, -233.67190892084025, 186.9848224320275, -170.91580815269123, -80.529171108474713, -52.018323377987727, 83.750945834671086, 96.919484089879788, 32.525577060163236, 269.07193414221018, 11.528307365467397, 34.539667869746914, -55.248404721293753],
                             [-242.37912288511222, -49.079139808428685, 16.949734674027518, 50.936532289223997, -28.968386462534628, 60.888169996862587, 129.32298518718787, 78.319461260889824, -118.72616986519033, 148.10298776035773, 2.271588616151814, 119.94274467551683, -254.94675656552965, 144.59655979777082, -2.3737642293839434, 59.568304449788563, -93.351283144937653, -12.909266658468043, 94.265158320204975, -0.46939110819369739, 77.300095241207742, 103.43149374032711, 44.756264090665859, 213.87328575114176, -193.24340792564797, 37.445305381866028, -63.910406091868275, 24.073307306911179, 48.872671959024238, -14.536200606136616, -152.49064955154961, -186.51752018451467, -104.53291023197308, -15.060074759629005, -94.591461581591631, -42.939423550598882, -3.8283645291644675, -19.595696462484188, 11.054229247071056, 106.55900840032776, 105.91840169226379, 41.550736494180633, 54.714523357049735, 20.523004807782424, -78.014758732565056, -68.261409015016497, -45.881549103592938, -232.77898076538239, 20.63128661773003, 78.497651808837688],
                             [-264.18069014686938, 59.933350461630596, 284.35560676161646, 24.509682161722459, 265.56312921916185, 213.70880738296287, 299.1948740213731, -95.363448035562058, -168.78248331028186, -252.77529596403627, -36.153859127252723, -16.783768257511245, 16.670592895948296, -127.75942885992775, 137.22686922647327, -244.84718919614139, 267.55670384400526, 23.876814480739558, -23.425850169866965, 131.47825455764806, -67.093701792885156, -5.2557887389668965, 127.32922814279632, 59.224807234003372, 22.096166862401109, 227.72746805497997, 198.16796978870624, -116.24400941585267, 70.998903424787215, -84.968024471661636, 112.6322337373129, -100.35135475472741, 73.691122550347259, 144.97571668610496, -88.958670757584969, -17.464103948074172, 61.644644602430937, -192.99040740518049, -5.8023865512133206, 295.55676873414041, -43.396183131191393, 45.319589667303795, -99.670941140138737, 75.958380810298792, 50.54383483050178, 320.75018513488072, 168.76176428607724, -422.50372337433748, 131.42751286280586, 95.187136808314804],
                             [-470.51967608397854, 31.895218853209119, 248.69312264492279, 89.908498306273074, 110.01820542039428, 173.32386897351697, 382.69216066607282, -74.104631934154597, -198.01065723178323, -223.74723841271043, 69.384890717942923, 24.619841978058119, -74.465335711825219, -63.561317260505213, 336.85237224480954, -478.67502067402177, 346.21420341013516, -159.07330168326399, 77.198895348449213, 36.822622752126755, -11.488056733539493, 295.57377158655396, 60.58746879567444, 232.89516654969711, -197.02578930468394, 305.85930314303039, 257.9823448579167, -110.55196175187621, -185.69691414651314, 19.621055478462615, 293.89529950647847, -36.858410290017801, 118.24620293978073, 93.347429297555507, -25.865397305314886, 46.586951040924589, -177.96699970788865, -207.11247873144833, -212.64262047759109, 236.22507726702159, 95.191273233249987, -192.32857733184917, 206.93093969662885, -115.61261650647249, -25.656002106782736, 519.94288532482847, 47.909752812571142, -436.34965384135285, 104.52852953920477, 289.05672531932396],
                             [357.73469974052557, -47.277154323632864, -188.61200735288753, -62.797676289694294, -9.4496453789668031, -207.92453819012439, -356.41487870794612, 151.28850859845724, 160.77724188040403, 165.90729182163963, -65.539002938173596, -95.974536998520676, 20.629600324403526, 50.253295666938932, -331.56204167621422, 341.24220477324309, -123.63963665856134, 236.48767518742454, -56.207263350402677, -94.704332645878026, 149.64429684135982, -332.3497436259662, 66.014550303528409, -261.50386550374481, 166.48468170025541, -125.34086718778738, -114.97074828271617, 151.18443428653222, 56.489609680966502, -5.0507206676784735, -302.08164617113147, -219.80606684682871, -35.073385052833196, -185.65463474886005, -34.665468166600846, -22.444552044254962, 344.15953799309415, 102.69901875967253, 346.26085850606728, -64.708923190603912, -70.611074964182421, 109.69587082155238, -142.81572766969938, 109.30869395213709, 35.246613266570492, -337.49460942250352, -4.8904577786003758, 180.51229719579163, 57.035005510595681, -293.87156551810904],
                             [37.537844385920444, 66.765678768408009, 287.51157856555216, 87.512406894251981, 151.09900996339638, -22.062716869263571, 133.56654476925934, -148.53246764643484, -90.71738353680793, -137.68137968602579, 89.087125124510692, -24.511254128866817, -7.1908772321152519, -64.647156701062329, 174.62303927780621, -185.74809746589602, 157.87134863913781, 7.8730952887762129, -36.763047184132695, 82.557971718918807, -59.140767350061019, -105.62469701964852, 98.168839257599046, 7.0290495013309551, -13.889685566627985, 105.45813152354803, 109.85975271966306, -38.499092638639752, -62.486797104936976, 17.673655078938825, 180.52062101090829, -15.115364871301074, 135.06600672074808, -12.91900971163791, -14.16234587897508, 96.569478122448174, 96.677348275416279, -15.420621492092394, -22.710178628744401, 173.47133774362862, -57.858701194105635, -118.31712021297297, 112.65228540971079, 54.408509700324601, 47.121019301151577, 198.78128178909739, 225.85289511341458, -150.87610600392324, 73.127795156702874, -22.114275698129788],
                             [-58.769233695931248, 6.3150258911636037, 163.19819881675548, 133.02626242147207, -255.07744230596364, -139.7881121943546, 60.331977087711152, 88.508196176943926, 113.44908088260536, 138.69563084401531, 433.24093064556212, 32.073627727455488, -259.22753802642541, 217.08536931179862, 196.3912209031572, 158.75157390149994, -11.056911706771372, -146.24146820665987, 173.43095197003072, -2.4511905971874919, 29.789969593647999, -84.936374328850917, 13.494736002399895, 248.09075460580158, -271.18479908241733, -128.42081516603389, 119.45618606812283, 84.071398614751487, -156.22132796510439, 104.09137993002386, 138.36824215955755, 54.15109394258149, -0.9684376986088612, -179.49423234982385, 47.700365094728888, 255.15610892016497, 83.004708413841826, -181.96466341262837, -9.8711214957190663, 248.12022604466964, 180.77418001749371, -306.9183175768888, 288.20992290194562, -159.50581149748348, -174.13203661908457, 40.269574602967921, 4.1072245907772533, -97.406833294500814, 117.38529366754287, -117.97198917025233],
                             [-78.688468194869486, 67.051056824355186, 474.87123250162591, 212.52397700969735, -70.939756000741568, 90.522317177788068, 432.0958087105617, 0.19269235534360685, 27.1285923281911, -2.7385604472479037, 66.445536013210486, -89.404401961536507, 15.12839685265695, 212.662848418105, 102.67381432759102, -167.47968020057124, 63.685822733690607, -274.49804986001038, 40.224228040840693, 106.60987923674143, -111.87077094997048, -32.646006376994023, 125.75923561424932, 286.08270678233947, -304.38833345035488, 33.643658613609077, 52.947427400384719, -143.28881893788468, -276.8880029988569, 84.369476598733783, -41.577302862475761, 138.303217275099, 185.90309398259606, -32.08484943295047, -62.753995636922397, 157.51218081441357, -49.480010746301637, -77.170896806811143, 283.70229539807065, 117.99801101218381, 62.169936128155115, -18.530753460264116, 128.14965266949434, -102.03219733604131, -134.54987506920392, 117.4132022242033, -40.030761520585969, -259.25317915883699, 195.40724754805413, -75.941463410968552],
                             [130.81779873063627, -71.220610081234668, -252.84987075302908, -121.21921742675001, -227.83059285634923, -111.46936685614641, -262.11238711049845, 91.770449319277233, -61.393605384941417, 277.89794585439415, -25.677536594881627, 120.44036252700934, -230.4206693267846, -25.88914359044616, -211.77890092556621, 446.53594895513743, -303.56181197435035, 96.160241913918199, -19.525173251499226, 28.765832165926859, -23.483736336640746, 79.030615812745737, 24.595174612672469, -25.966054653941974, 150.24571307153343, -234.09036362536077, -140.07315218233924, -98.453795855530316, 384.93298218798776, 28.164322841172414, -66.973881940695065, 71.904839494385456, -183.34458888181595, 33.777235303307187, -7.3953496963843302, -120.22396928804693, 2.5375153209370702, -15.534221231012861, -138.44895032808392, -16.151744274182828, -106.69221602446621, 182.44768605190083, -222.55945131815554, -173.28465833434032, 32.977023112821243, -167.12361653239796, 21.040672569507024, 224.27761538069186, -174.14493786893223, 60.269194463849864],
                             [-4.2190876612041555, -45.575540408334533, -167.57085601457734, -27.730550627327943, -108.0102738977948, 69.157907335943591, -76.446146826239001, 166.46133714296198, 79.733603275483276, 202.96935159621125, -148.9617358636844, -51.058512649046044, 47.219788252893096, 94.27762088525914, -184.21858507046969, 58.294491201446135, 18.250673604671658, -56.836066741786532, 14.016467868913182, -104.97231738825634, 119.05414638822219, -43.054941941675153, -56.383534259799994, 4.366778661438028, 13.629777610489066, -41.895309532563004, -107.18108403153883, 96.136176112178703, -131.58688831245573, 55.560717961502242, -240.69350330806006, -127.28139075621299, -100.94077789251055, 36.026810474832594, -60.393875092587031, -121.57318228406734, -51.983207117481086, 3.341231660425938, 280.42275795188141, -79.305059653717876, 24.102908708850617, 68.496499325986974, -119.30964956548509, -68.724195683203249, -30.302477005212328, -154.41248857727271, -168.57439987919369, 12.005706606638839, -67.761738474241767, -15.640208674237838],
                             [117.27731326994132, -163.08007341635729, -486.93189645746617, -20.011921769274423, -178.68796199828742, -90.157499751922714, -318.09827672186975, 237.12954794467063, 159.11104557915755, 336.65802664420875, 67.101348586117822, 91.371594714272774, 2.5761257159286366, 63.100290937678565, -164.92711775614558, 272.51983243517947, -186.99667229209609, -65.480798444592466, -60.41379120821076, -207.54531074366884, 189.63312383538292, -13.083988008846092, -183.29216910527865, 13.706414924839427, 115.82761609669504, -232.13395533973878, -262.56631470609642, 238.32634758228042, -77.213735079400436, 75.820418934346222, -290.93991348808777, 17.137419154275658, -173.71060684835322, -36.142249110196161, 18.529553373546985, -58.386117188136559, -4.9190971537356205, 85.804870603080005, -26.51350274158132, -154.02051864788862, -75.045177341513408, -119.76571060231242, -17.940743203728669, 24.050855102780339, -62.720276094463571, -367.74839654452956, -80.792223169228308, 325.79108493091326, -268.15252132393874, -63.850212550730092],
                             [-44.739863399756963, 102.37234410314717, 304.78580312920752, 62.745047424902872, -136.50697864124541, 6.9822354725973943, 368.99772849478825, -112.4878402812065, -221.45061423417641, 114.3608162561606, 44.357465746148584, 11.278767869242657, -251.52780848907284, 23.425832154202308, 336.28010371762849, -144.17009629425124, 1.23469184251213, -181.90759070649341, 44.320513450922377, 189.77011505949022, -165.90387685118972, 289.65078233632181, 183.18580657560958, 329.10913360809155, -185.12297048334818, 96.059036593013147, 73.024305340911098, -303.07877166923862, 29.990006920166234, 67.594007126677084, 261.13047501420641, 242.96691199568446, 71.641767368385914, -5.7849111479533857, -95.275873800778029, -73.967898125289551, -329.91242457410033, -111.59023857965808, -193.68120179482401, 98.951400198235717, -19.476021732215326, 20.57694837119983, 224.69888274329716, -221.41678134709966, 46.166742842661002, 344.03680154033844, -66.952570216660135, -136.20402799902234, 0.46861799781450619, 171.69474215800116],
                             [-178.00834688413167, 85.516318713572943, 253.50422334246974, 40.904057226066712, 4.4562809312498084, 90.536236732912812, 242.77720382344128, -17.51664890588814, -147.20022169320902, 88.940437307835921, -70.145397406977082, 53.615467702046779, -232.82666130085272, 72.618604891148678, 136.25952501234684, -51.374309702262956, 140.77924500370847, -25.947621189534132, 54.30388927667893, 87.88868221848017, -10.662905973227321, 101.87139337535112, 133.00499039913061, 180.03847201482785, -128.18023794405153, 105.16677864412374, 19.127522500986309, -130.96667256309928, 47.199127110087474, -25.30898331278372, -11.188900914134988, -130.64497829903755, -53.582751971802395, 47.636069438148468, -121.07670805457468, -45.812373315671316, -54.619513527565104, -107.64373170762471, 83.902885257059737, 82.426158862705776, 91.511373351418356, 68.727793153339761, 165.6420028395286, -43.608559504559977, -55.962338155772521, 109.34926598868654, 35.554225825333049, -273.08657786416347, 30.236844661907536, 173.97107306254136],
                             [-135.87988421573965, -43.254769071549987, -149.0803021893374, -37.786421422255714, -45.642973311953185, 86.024518528641238, -43.233274403202167, 38.658268535392814, -78.480517915827321, -107.11403183873746, -27.765636498435626, -16.647533093359929, 230.87331652512682, -98.763460337941268, -7.0186468640730126, -66.312668518708477, -24.884722111356364, -146.11541811582151, -28.923339370206623, -72.647083530861423, -45.664679216624926, 68.107288204986347, -184.9776261826766, 13.762689617581358, 9.4623293889241715, -29.828336788450191, 33.579557738620046, 76.730573847036851, -55.399081646718813, 73.433156117403115, 85.811722849268875, 161.42741316458131, -22.087772303322296, 73.811985199364258, 105.42538198533023, -55.656424588154465, -183.7376845833148, 62.540629979145415, -141.47078312399859, -97.358785994573353, 49.835304898201478, -71.279891561643026, -74.5167173239292, -94.092694429682041, -23.490192431723997, 59.660804897672165, -96.75788967745639, 204.92001672321501, -129.63506988764101, 71.527592301145887],
                             [272.99590170834404, -15.418235981317428, -7.1445452809845076, -20.500681979000618, -304.55901858023685, -123.34325130094346, -79.918086442258314, 88.257311087664363, 98.768595419981722, 170.26851322991445, -89.783289484242403, -136.9666740848987, 81.402523927021846, 127.0535138784453, -83.619392753377682, 166.11564657851727, -137.60707198157968, -84.408385148225378, -5.7130019048497429, -0.52510534630319894, 50.954542101772056, -33.610771214422137, 14.481506051259608, 24.425930477596125, -29.694902796714185, -160.78444453434227, -148.86160338103767, -80.240849737046616, -48.68256175560893, 133.66512558065952, -28.56288300700092, 185.947607150317, -23.906551139755926, -154.14257772110156, 25.19965702532345, -65.728122400568381, -168.88533649305577, -7.6571311051939173, 154.21367856198449, -151.15949028330357, -54.43207267542207, 36.027473869559834, 27.40515717534505, -191.80775061357252, 26.685152767991347, -41.152625544139973, -207.53419644882598, 285.08812315800674, -93.834647778573597, -104.31626943772582],
                             [-51.169845612005815, 139.166115941241, 302.19313836584035, -1.1885379495355362, 206.12971656140735, 68.808758822107535, 192.12858951069424, -209.96996419827857, -109.97111519626422, -303.60060705723998, 43.428664748086938, -41.194551161912685, 70.309093648984131, -146.72640499599044, 176.12098973897386, -204.79446043440916, 258.66381300545805, 58.905708725493085, -33.63740649959427, 127.84066798244838, -95.477224036759907, -89.129980730898851, 126.36197851293936, -37.266554166206255, 57.98306422514267, 128.79132338538673, 202.43372873543453, -145.59642581794543, 77.909074790056877, -65.275959309283266, 241.77656817868416, -10.222067809713947, 77.608459317057793, 89.185491992788855, -20.886322078130824, 65.807763951219513, 49.730913218643273, -102.21688786336422, -95.021476005680782, 83.938381771622247, -7.9803594048881594, 33.270126801894584, -16.260737297267607, 80.909617574830108, 57.48000575759815, 314.08790531192187, 201.16493396975599, -200.28950207468785, 170.67436315884669, 51.953606567630359],
                             [-58.289847687929509, 1.007398210878109, 149.01716350984009, 22.841190068570441, 10.460382870439483, -51.863090303041126, -20.336802631632651, -94.97709672862446, -26.176428489571308, -65.014523691926598, 195.03763672365605, 44.834901162697669, -180.51483713096334, -46.224778391229982, 193.82738707105256, 88.334690003422452, 75.475574286076579, 66.031866556129287, 64.576759612196227, 155.3284033893338, 6.2460286008353938, -104.68122685472922, 98.557174565141963, 16.267362371594494, 55.848410999619297, -2.40330340012336, 41.787111136846079, -23.214291911184155, 232.62140129572944, 15.555593053128122, 223.43464090833157, 26.354576039764471, -49.294423907885573, -45.739599982590072, -4.5491701509404052, 160.48638494825332, 130.85222181003911, -220.76807067199908, -233.31995570295612, 295.30661396723139, -57.726510103544413, -123.82510075865574, 33.286608639162395, -45.525351872635866, 32.722047803246724, 222.40757692934952, 317.1838890578843, -140.98433272783862, 41.601535795345796, 27.972975768769501],
                             [42.221612045374336, -55.630138943482855, 116.90815456626025, 7.3848423734181292, -113.30000643918177, 21.764002202734389, 38.867310732812129, 157.45083799613735, 36.018299308505156, 171.2028628559317, 33.016501339385727, 20.198602459195381, -100.32599054823227, 183.04237131183021, -199.70240967995008, 240.92237267707645, 29.531537813266581, 15.959118049519244, 33.878927572363025, -64.437417347111648, 79.843585556802793, -67.163835471330984, 76.108967539380146, 71.79373639586268, -126.34309158548362, -99.599580723825511, -88.423558952355961, 13.254097520225013, -121.1810706113674, -5.3450291722378473, -244.9743582934772, -166.74366177733523, 36.776327520229771, 14.192345662204474, -4.493343950506679, -20.935429431323506, 137.07005194331398, 22.19462916611371, 271.9602045735835, -9.2106546316435409, 113.40656825792699, 110.06067506610019, 59.528111178179991, 68.747889653081586, -90.297872746779291, -111.53555096963717, -77.20321304552813, -46.022542921003328, -18.866171607638051, -37.32030129333539],
                             [-131.86213679336925, 130.07480503116972, 110.07566056387491, -136.72726840798168, 170.40121100801224, 116.24048516795605, 25.895842160651728, -239.02582589040384, -295.16809638817881, -196.90596620651334, -324.86168777451599, -13.491415962921501, 15.063699281075341, -142.58147622716052, 44.650326532262547, -149.77365223006535, 59.78606231831909, 181.35941474653163, -35.455650236282864, 234.06975732532874, -168.02813012300433, 94.327590719467779, 125.57190091169335, -159.30134379341686, 187.37230564596928, 170.07902689009182, 38.397533293722859, -260.66171686521011, 421.2089970077908, -60.672210167291595, 118.40255707586036, -71.457929864853398, -153.09618586020071, 146.77041656736611, -95.153929614269799, -226.87425465545877, -176.51689301212954, 5.5032703426284346, -109.84391697197157, 72.313109429624703, -128.1138145472394, 288.19527139484575, -158.48490660127587, 60.406017461230384, 206.66469316990779, 195.33731120585242, 62.225823195288569, -134.70398579797919, -14.982095891664336, 218.64198453856807],
                             [-236.50792310047041, -75.862218063020862, -139.00982931189478, 106.63512480553521, -107.17470788140699, -59.701919995166811, 9.3035904221412018, 83.605443042531746, 92.193064152858142, 14.52043468676205, 206.31950138443094, 60.580731329518407, 46.153310629892822, 72.526509789932291, 168.07549463702966, -6.7996866062271666, -65.472525096188221, -293.16020314674466, 3.0617636719249579, -77.900421197411177, 72.495358081488874, 18.49528999092945, -160.82389565871577, 250.99554648388241, -147.62552055922711, -105.00294492676102, -29.590703283849905, 240.53199302701239, -169.38075423893986, 74.695035785345183, 16.292394947765061, 191.47240738648904, -58.558037492459405, -37.353593948996199, 73.18973078935781, 134.87307863954959, -42.216199579889199, -65.056130422697393, -187.43450072780675, 49.697561387209518, 86.515138744259289, -322.54564941205103, 171.4048361999989, -81.672215772796491, -239.23078311561164, -47.465190001259899, -17.06810500956006, 38.540376744179561, -45.742796602767029, 18.48707272029538],
                             [270.76588408942939, -59.528186422824987, 148.90331097860707, 96.62930909283746, -46.517630847599257, -48.471489860054426, 34.574260969181445, 148.17516987112796, 230.8025478229514, 245.57697241923543, -23.562319709626724, -155.60293519514613, -3.7778141815485271, 264.43866373798693, -146.41827667609036, 89.033722047008624, 115.1805786779218, -25.014621850446659, -34.462939160752462, -87.141076941816621, 217.87651605557508, -302.87133672657228, 111.54962967046193, 29.668566141280774, -171.59587375711703, -42.889744976291105, -146.38605172296215, 130.00829401971254, -397.2607730966925, 43.906774930040449, -344.17752503830889, -260.88782669587101, 111.60991581495193, -168.9770034423523, -62.869145884161931, 29.293644067840312, 319.47194713716254, 7.7867248169336705, 575.85246461899953, 38.839305055460073, 35.091919564419236, 17.909258434794555, 47.315125035980401, 85.238493043834765, -48.705165287555147, -141.04257471249784, -141.13976677423236, -126.35212174857895, 159.14894123649123, -277.7151838531679],
                             [110.93274575156921, 9.2802681155854998, 109.4094778283683, 65.771930160770879, -116.79997080440917, -92.232780083694905, 12.04845516840502, -38.879216023721369, -17.519420902587274, 18.249803784774997, 96.163634091424981, 67.50250096017173, -33.208601330163312, 7.1604889726007572, 84.115314283719115, 40.950188056973658, -29.369839363327298, -75.126816897010073, -56.968374811158604, -4.3610370648323, -84.42610519981767, 127.96546250991877, 31.196738272146792, 20.577454672652156, 41.212156983394088, -64.729467391941313, -21.232623205710969, -101.36769975235326, -3.8507745492602545, -23.908136894521988, 235.37900251350663, 163.25207774311451, 111.84935789036129, 48.325860626924886, -3.3290996390189544, 62.710411115635907, -58.834140237869136, -25.733230528479886, -155.81018306556601, -81.989661100352365, 10.545458584506262, -80.268547691582981, 103.91176684787276, -118.51343912965324, 16.422725899070407, 54.687522329105818, 42.091914032888255, 109.56819004587997, -141.3440977659331, 40.853068550799215],
                             [166.731339584143, -15.45295718650393, -88.060253667517912, -39.709942519166525, -20.703653201979478, -3.6011200592193928, -144.9755661728781, 42.005035005159066, 132.42441571534843, -41.937809744737109, -128.96095722524325, -20.781325826405464, 235.75138084308514, 28.144212434327677, -192.44996057475026, 61.485825902013971, -87.941881661417767, 48.219788566363135, -91.389895456280968, -118.24258555467142, 27.056363341776233, -122.49363419667034, -89.360156746334013, -187.16599370793307, 113.23388074884431, -129.06976419037579, -46.949515989264228, 30.504013748849943, -68.725284578868241, 8.083266510178083, -108.2661111609995, -19.438381491907258, -39.926507751126465, 18.283746956431521, 94.869761995122445, -88.286941655576186, -6.0266236889066178, 191.43529564428857, 159.56592499758523, -181.92255577824375, -21.531692745631037, 81.845813446083767, -203.5621804551744, 74.402737161822927, 20.71769731036586, -189.79291570298327, -78.063493131097275, 205.39534784777589, -53.463759720793, -124.93050491559181],
                             [274.05980369834526, -26.957127318647331, 206.04762666241396, -7.8120753325803092, -154.90605499083335, -84.422506332020205, 0.84416568769461875, 8.0917910300564646, 43.242421170256186, 146.35325702996343, -110.1113052908775, -118.70469581623388, -23.310491387934647, 90.056275984861159, -169.37847429265054, 230.5559786132736, -48.628901665449035, 43.759477120458456, -52.489872957047702, 98.949228190712972, -84.87472144667359, -23.298505791128548, 136.59111745673783, -78.299412440083117, 33.337158987344431, -107.60529962894408, -119.96327967262447, -224.14480486472337, 109.65195683205287, 11.78017352210178, -60.99327773305999, 122.70557896916938, 82.055114948639485, 2.7692356198421479, -29.314670760871408, -43.837804742764078, -3.9777395584849664, 9.5861989279971915, 137.71811137103359, -61.516270034249011, -96.843741368592134, 241.67390593492971, -57.817376661307129, -96.359522214145301, 137.57418080900499, 2.6602296891591721, -0.78407272303593278, 118.08983197489702, -59.116673473041125, -57.291405002589627],
                             [-282.39382377366974, -47.223988145191221, -346.20430026553981, -69.296615777573749, -104.36272824480892, 88.682241060278017, -71.517064331963411, 117.94663793886717, -65.978713798253864, 178.7168273312366, 3.061108118907975, 187.2482173786168, -235.16549431726307, 75.763224504342432, 31.488049484555003, 98.530475844920389, -71.158865089220996, -26.782875791831795, 115.65294399742513, -41.12452323775122, 1.9194584762205917, 335.76791595273062, -77.400589468366846, 106.46283919281582, -20.036684049479359, -20.545250044570402, -67.181325093699712, 34.30328992372597, 90.437381845891281, -46.108922197703329, -62.988337885146464, -65.970308424805097, -180.60594740879782, 131.54202172534718, -60.360256084358767, -100.56234532191301, -184.7341205754559, -45.427528214309241, -213.21198452320283, -51.369894795393307, 117.88502344264876, 35.955436227132566, 31.956924837086877, -54.933571932539643, -101.02952914279076, -104.03257409457304, -121.66577477863838, -43.303747347822785, -151.14595443672863, 183.14293591288384],
                             [-258.45628844324256, -61.228676902024283, -545.48159370653389, -146.48061648678646, 278.4884219417433, 57.195135843239214, -310.36556199746855, -49.37131975829157, -69.753698970894305, -150.14186225262745, -95.594960525732262, 95.442666787234216, 159.00498386005737, -260.26437954004109, 5.6921209151795678, -83.179275232838904, 41.213490930283832, 96.372127449906017, -78.119394511469082, -119.34483887523074, -45.861142138561334, 131.42952200939231, -316.59137457117293, -237.89380329095013, 286.98215218710538, 95.423495163596201, -10.329444644849048, 250.58771487914677, 144.24515322784001, -96.347648844266132, -46.433966467276022, -48.307348397238215, -153.17070748265621, 205.61947609109558, 59.48240396182004, -126.43900281962243, -25.192684157129708, 175.48065937284204, -366.0256550149204, -84.316958674994368, -61.723157508889614, -94.011847437518327, -74.125241890000936, 252.74869937255659, 37.717763311149263, -173.81768687453524, 74.410245899697671, 161.09134276324306, -219.54500392050477, 162.13258459247487],
                             [-177.95741993245611, 70.71940508311549, 43.66119491420713, -35.334619005148419, 341.3081984092895, 191.46657136617526, 122.07331681545047, -100.0201136427395, -151.38205142933182, -175.61959553053393, -181.80478076649842, -9.7928413580674381, 13.067509598399484, -68.73990146987002, 112.02490083203334, -250.45070958132155, 216.61393042405075, 130.13235183452534, 55.847346473999039, 19.97059696024612, -27.161232811835607, -6.7059193689525172, 19.35514231917174, -90.071809222008184, 56.369347134837049, 227.42406396269598, 110.64836565071501, 9.5231350898192222, 13.191193145298604, -123.26206899874809, 2.476591143068124, -268.30696609572993, -5.8406508677648237, 56.592464825192025, -107.88184469006406, -181.8665556047782, 44.35083531882249, 2.6266318913712694, 17.231492383936384, 1.1890377520151654, 1.9236883142743033, 115.90486340548719, -41.894201842166922, 295.57663984420594, 75.265855561982022, 79.243314379922509, 41.534746267747543, -260.98399606793998, 96.406348431308743, 44.843946910386855],
                             [179.08579581870427, 16.569360106649814, -62.288982745106125, -59.433695443234484, -303.64575668830457, -75.215502714420452, -143.26038628568833, 101.15183767567748, 85.020668990249405, 252.53205409719791, -25.841933867205743, 36.370017645402164, -89.138541519059984, 128.1367484007516, -219.84104370294349, 242.5162071138208, -164.55408669587968, -12.086485574062909, 104.6338592564418, -66.880593551011856, 105.74976152716785, -12.788970648453791, 36.441002066459205, 29.018071108924289, 38.259899621384648, -185.59207824482982, -119.61819151036984, -63.46417897537647, 89.002605196257846, 79.383492862831517, -74.071846581621827, -0.46952723743866404, -183.00002729102579, -124.21292196842329, -2.5556705586073973, -159.06790129719772, -97.113482032805237, -35.600949137578247, 153.9072891596357, -95.57551819775631, -5.3896942803248571, 73.160021988432348, -17.613606927934136, -159.24763812778519, 20.193705913798624, -130.26512257690925, -124.54959011280681, 188.82457091865416, -62.731550657774747, 35.181587831973431]],
                            [[-2.7357680211542297, -249.6564280966553, -93.946276315067593, -218.38915715483745, -299.74592832118321, 156.99171466621016, 330.5608185288678, -72.416679370677173, 308.67161162115019, -237.65741012155013, -228.97424221754389, 5.0282529004687095, 100.42213014228773, 372.56858503642377, 20.196677427355084, 381.77174003620456, -113.70343492387853, -289.63172972035142, 156.31958155283155, 182.7847448250038, -66.757102419597246, 183.47700405889492, 13.200788198630399, -87.578715443829878, -92.134457884575596, 241.84731424978079, -269.22039094077724, -74.374926822627458, 270.13081757759153, -68.901365259557906, 20.631540349549308, -166.09261716041092, -61.881147878511108, -56.714296649398705, -98.587903247243048, 381.26943389304137, -82.404389814727665, -489.05472218383369, -130.8552970013132, -121.32889151560542, 67.465730748645854, 385.8600219682059, -185.44786857660225, -207.88814498432669, -43.611247270984151, 216.29990291265685, -177.42392927750987, 96.938689550737976, 95.234938872228284, 96.495859182691433],
                             [-355.18722613501848, 340.26275451177617, 230.65950302745597, 283.14167839318156, 230.90244506133206, -13.863164292597048, -185.52834585782679, -413.69250259287048, -403.99809708588469, 194.71636383180376, 789.56664376089702, 28.255259674851526, -346.55530037359568, -201.94670418532488, 70.252478459299738, 102.49981474038898, 384.76839689332661, -85.357480677075728, -202.06214291594674, -398.93420318669445, -141.25394359903072, -187.82504783606467, -30.843037407896865, 403.23463734691097, 225.5108104764204, -365.66296091359055, 306.96580463285898, 109.09459889695495, -100.63837472278682, 312.11366599324242, 272.1747367375221, 516.41079969315149, 169.27049659272029, 178.91921684499854, -291.07989822431819, -62.509701404212109, -389.61236963203925, 390.41933427215793, 335.76037326312462, 420.44818006387317, -432.515636916711, 14.792548865983044, -439.56793154222032, 223.83534004318017, 180.32375903414649, -130.86019060772588, 512.52598616654018, -108.02201906226701, -494.13580728594985, -342.21913257845978],
                             [-145.52053053422424, -7.385822020105504, -75.396095944780114, 14.910395956011619, -195.51614274986864, 48.339942534314559, -7.1677634958646728, -219.82769897054118, -162.11474870833166, -321.98688880352842, 246.4498083047099, -25.829672130808003, 71.465976357879342, 144.86997092727955, 63.250845709878433, 153.59991291396068, 272.06638538956855, 214.64680974241733, -195.98994051245026, -85.110689533815076, 153.85710203744304, 250.52998241421426, -4.8882062239495392, 303.27919104637891, 86.627927169623248, -28.426469022517907, 34.467862378518518, -69.690148528010113, -10.911762369546041, 42.069407769605959, 152.64863855034267, 279.79222694851023, 76.083588003684596, -59.265032328570392, -233.80779590213996, 330.04841272640482, 37.950437667374771, -316.00587997870002, -247.87812623124978, 403.53266208316546, -162.60329579560891, 319.20616656457167, -524.33768045775082, 55.283739350584746, 81.182650064717095, -44.881085277791271, 130.85840649834154, 43.327797606318533, -133.05261881360238, -511.97719686314861],
                             [156.16330677919407, -44.246955299000376, 109.01458469910639, 85.71105535314318, 140.79846971079579, 175.89421070815263, -30.89125032925655, 11.17404629446871, -20.85046979706199, 152.45156819591867, -261.85443179535753, -27.10362368234675, 101.64966336681613, -230.81260201221275, 21.394338361734846, -181.09580478576626, -44.592825409858015, -26.165776801447784, -3.7980620953814475, 57.718922210375531, 49.7667921418875, -151.67517186491264, -148.33863737781385, -1.3441405756014095, -180.28328589626662, 64.83424476098206, 6.4652214044926382, 79.873908226559138, -223.66685183103564, -72.878520208567323, -32.63925397875812, -129.60098249933657, -59.373480830165171, 14.522403123319211, 88.328220535451436, -175.85082565132262, 250.1003594518821, -48.922421964135012, 129.56754835885599, -92.619734683861466, 89.745431691043407, -70.330436820639079, 59.252133495049335, 93.162090754387975, -2.7345516793836726, 76.242787266349623, -53.297058984308237, 2.9040237293854343, -17.837071905525107, 139.53574223814434],
                             [29.204836057943542, -315.05268740377284, -157.08540748560242, -63.269877119845852, -214.59721424301793, -97.492334697166882, 299.86903089539328, 109.83228695049256, 150.66111684339043, -263.56544401437043, -292.99867173588672, -233.08254817891674, -39.527472999855554, -59.105231307580759, -172.62296748543039, -24.756251217449861, -101.83484749387947, 139.91738779374606, 227.38528416301577, 315.06369347968877, 171.70000554702341, 39.558399750498786, 76.345896426122536, -166.3870413477122, 121.7212204344536, 314.75014441588041, -33.647584091255311, -74.355760567628749, 361.86982616838782, -102.7545739496704, -234.13397839470386, -120.28558947352431, -140.84337241603814, -221.15066956080665, 238.4176388818691, 575.04615770257749, 114.40325267175648, -184.32960319453744, -494.87550531689436, -92.094571160665268, 47.905782076641742, -110.24699800225676, 148.95902255845081, 53.35257111814132, -46.511732534060023, 224.80319151498861, -5.3699990278795493, 28.650455570261215, 51.01318817011191, -255.08719647938534],
                             [-22.561194657492877, -83.088518764140275, -48.605052397087121, -202.73348553408988, -122.12453902749751, -24.680120306334299, 239.39119281008644, -149.60876050646144, 158.46881873373354, 134.49550879319651, -159.06505754314804, -199.81522858025252, -226.33942256680689, 83.133393885102421, -205.37666423491811, 389.9507150731485, 71.529294788652948, -124.46109653868814, -85.754187904554129, 239.62594328603009, -186.80758405106064, -6.3907526168473874, -33.933019364375617, -196.27160545846061, -32.898367778932361, 249.31504614755576, -18.818660354517778, 189.23859333551468, 248.87554442753347, 166.2864964057537, 66.110433340001862, -153.8148943844906, 99.986662216121417, -50.152624296467799, -68.043707208554409, 316.28230247753686, -251.22892967623895, -65.722116236998659, -17.558166168682156, 103.307180824162, -302.32085735987289, 248.23735044331059, -293.80570866910261, 6.0868158794099561, 184.91697362058838, 188.4566011776169, -97.639842058325087, -222.20149374985436, -70.771501931538026, -217.84498891619009],
                             [-71.583225186970367, -275.60886853776998, -18.228744780807581, 12.783642891961772, -31.658082415675587, 76.855332797352162, -225.6396312730358, 7.452327324949132, 97.142466324996946, -11.430939317551767, -174.2072701419508, -217.77004054122375, -141.04862403860878, 113.25674830837532, -64.83140158375096, 20.405960324484127, -17.679420526615516, 43.259276486501975, -214.71717680931275, 157.00675294720276, -115.32496932366416, 135.50892413124777, -98.833444499064356, 289.91816993659569, -106.38346153032872, -133.56044146593715, 78.907932146225377, 187.62397677631353, -226.67897202231856, 109.75089582827864, 234.42578826621531, 70.811299818480677, 112.07750408004456, -78.958571278166005, -67.453028925788303, -2.8160481598850073, 198.07145317728836, -258.28870110764763, -7.9685720785324889, 211.72117502397526, -125.23103378761532, 164.18076344284572, -252.65646900885122, 127.37068729980194, 311.70134975964726, 40.406566165160363, 101.05807389514437, 87.927970160179569, 4.619778967885753, -127.33515091615102],
                             [57.362567560119302, 34.04824526398702, 74.047148904862865, -21.040030159810886, 0.84287759259065442, -65.671592452245605, -127.15977700078749, 142.03260249424713, -62.051352747836461, 116.74740682354127, 88.619379368235968, 89.547290674112858, 56.956094246209076, 26.528117891959539, 31.094626053883324, -70.794727758186767, -30.611575441372842, 42.06384269321164, 138.99492845977576, -123.781838353666, 58.055596556667538, -12.96691511922379, 130.92907231742282, -35.954913047861972, 86.622158806784398, -86.714386844173646, -60.988110714996481, 42.851767446802555, -101.69721517903734, -52.870376764287514, -37.893191007928074, -24.692779642980653, -102.38348294180149, 84.74066684116336, 15.923429921414611, -202.03172319084246, 60.695863216640838, 143.26565868097083, 123.63192887480314, -84.204382980632914, 47.953980252472782, -119.78006561810973, 154.97853768278191, -61.359209669249999, -33.525808343681916, -110.13535671828168, -33.854437243525965, 39.909529867581981, 48.784013900419012, 161.9196823700978],
                             [221.28822645531875, -53.129341679447663, 70.995294870204759, 218.5189827809354, 268.6613332509973, 325.39878682781836, 92.31581282155004, 374.86062931379212, 3.8797072033973383, -55.312126631413769, -248.88952500827892, 96.135532731772329, 226.04360089870607, -142.41529827994782, 145.58899904486151, -430.14742106419726, -273.04739891389318, -47.626686273580219, -237.46460151866808, -31.763203191408358, 227.61098417347853, -555.35564024893699, -498.40856941274791, -156.75200207837236, -332.92590760588433, 284.65688229136856, -45.576121391188281, -2.6140572671827584, -232.3334747764134, 12.508748077815749, -126.56075040329151, -77.401016652156358, 65.201475707347569, 76.404382159888385, 36.401477224597265, -248.08838038625657, 428.54665062566113, 193.84762209161275, 245.90171050003232, -124.0492929549293, 496.18829904397063, -453.95617602723104, 535.77549763671777, 118.39234182325835, -343.6229567573929, 127.70226143810326, -70.036418356439256, 220.09379647367257, 3.377548547618149, 526.49123875517682],
                             [88.562532766255671, -47.58223243003448, -70.971252689110457, -36.94121340904011, -25.433722584533069, -54.720418149318647, 17.353200653710132, 20.143650608400023, 98.217368997531352, -22.028484418602535, -235.88913951711879, 167.06007752848987, -68.740389568948231, 187.42731977004559, 76.800669147473116, 95.991801592206073, 57.303883973531612, 25.938299540882245, 12.168548200397094, 93.273017497250962, -58.745979428609708, 48.393801219399577, 132.53945109438075, -147.71272906851468, 40.22521868111081, 32.90082496890755, -110.49090553617567, 107.8416883363154, 87.220858153479384, 18.354919003717775, 3.8147728360183253, -72.008441251869883, 34.984593512263714, 27.627270022695807, -264.21407807348959, 85.51908786909658, -15.70486902108901, -68.223054352960659, 12.959470513092981, 49.279085901242368, 45.85990799421154, 105.00088146474879, 55.874473376900163, -154.78234371785794, -11.343657043251097, 41.301152635478992, -294.44918287233833, -84.131392050712464, 126.69714338523768, 96.934158653704486],
                             [70.93978153622848, 49.048513346418041, 122.77542753605111, 117.56735926267206, -145.45532204877642, 79.059594113307952, 13.82226064212956, 250.14794258811966, 3.2988505340077197, -147.62525075160565, 250.21566564253635, -62.039688875745348, 235.41215916778884, -17.170803149990792, -29.08894117522653, -310.43245166967756, -52.048507914999945, 109.60694691826161, -51.428871839519736, -199.389226202158, 241.04258394159862, -13.789369544836822, -118.394448290733, 45.069568633974974, -68.85268217116338, -4.5821992789001111, 88.23725391530941, -104.32749696802991, -126.04805788439674, -156.71075403286989, -118.93523435530815, 141.91929642702485, -120.49773336692277, 104.57354772918819, 81.991191094702046, -116.35705119754878, 217.06628388820593, 27.629220087068212, -91.837459486562508, 14.287755131659253, 276.64949712165964, -162.10044271011952, 65.084640924724326, -57.958085130637635, -158.40689587752416, -64.515247104220208, 169.24362896584918, 210.40764021980766, -164.50770334693519, -12.293180960865413],
                             [-48.618075603322701, 176.84323093488831, 36.35528043958066, 75.247520511160616, 97.835829895298033, 69.198697141483549, 185.29682870240447, 8.7315144284927868, 189.86585175243866, 499.10100881534891, -70.565222252135101, -67.04831718439803, -395.88645874094158, -205.49483198884946, -46.045374753382028, -130.13102214450331, -127.39327053534424, -328.78486690074448, -221.56319317275896, 270.48974490917539, -245.86471269227528, -230.26826168170365, -194.52884776110199, 67.686152386880863, -86.504376018314929, -23.696058342974851, 354.22385562925211, 225.85288236175239, -47.730751365627057, 268.74810122238966, 109.69922959384913, -44.544717597914584, -270.23583086465129, 4.5426646869393696, 51.19101018033512, -315.513274102558, -145.28939966188383, 524.63813515033655, 107.47241156397115, 33.736891368020181, -284.78285023273304, -499.13278014857298, -23.029324601985135, 138.93031333985775, -2.4447534815034175, 153.1864964414105, 113.99210422074937, -84.153912220788868, -41.291060880335358, 1.8679569653119454],
                             [85.358619154801772, 39.677511245385816, -11.662807382104454, -5.8518370845138374, -16.298532335314352, -41.520175359022261, 181.19264950925066, 85.621362158153133, -18.10890120347457, -124.42054638678898, 28.033965662679467, -22.240988193345729, 275.09324379261909, -29.744482781190456, 183.88378818569763, 6.010930376565776, -228.8587456254582, -155.3886212861855, 154.88830895019709, -191.99732722755292, 145.63703638802497, 75.057540943777241, 12.959189864279955, 15.941960441210371, 12.715248250189095, 113.30631155437719, 9.5227209683921448, -226.19807187117493, -48.711988799451447, -283.58728159464494, -182.67027305885236, -94.281359803457022, -15.387865217130184, 67.475716587631183, 131.01402030721658, 5.6502199748047151, 27.161095988021785, -109.61075244058615, -13.914978941997358, -161.98535050262879, 57.348185706323179, -49.699354600778143, -60.960166433911965, -24.068070685342555, -92.092648754405872, -102.83782746163291, -72.305143605847604, 167.87220127935782, 96.275666266277497, 97.32885141763154],
                             [99.155266956905791, -366.45503345242844, -116.9858117707205, -155.25315269199473, -151.00341090605096, 22.6399992616414, 92.406596577680403, 11.950129490832801, 168.9320575923405, -238.54010573912768, -357.17925966086165, -194.78031951390037, 52.476597704989942, 13.839244876981212, -126.82657146920972, 102.88281871493601, -86.425148217362505, -118.04982758890644, 102.0825555609174, 335.1886492403994, -19.811241585490066, 179.38029172359967, -22.150012575709184, 38.55549956517941, -183.62587790705831, 126.86982844055645, -58.094080730204958, -117.39343792762141, 120.40143483473668, -95.236726598312828, 136.36829200205281, -339.36038143776489, 3.5371923567721755, -293.94938223497462, 159.27073554767861, 324.72969894766732, 53.269558108441629, -455.34795857236634, -318.10668314912397, -96.88111140031819, -17.403691264313082, 347.54037413215536, -96.345108427521424, 76.666738866181831, 9.0613950092527489, 147.87349948966283, -89.293838764636618, 83.870754585827925, 100.57850825571734, -39.905316093681229],
                             [-73.697282615110311, -245.57347814057954, -77.091138457253678, -78.599152250112439, -256.78266919502033, -168.03488666083206, 248.10346944476174, 47.225367001129435, 148.09535701476182, -343.4548406569408, 27.048954625750419, -194.57692997971677, -232.63768426522418, 59.503597814728977, -179.04633464873746, 5.8834248533013671, -12.203944602594255, 113.40295571111093, 1.688864958818953, 183.02479469170325, 14.984932459612018, 145.25354139809812, 98.210448722361036, -46.260690559098492, 167.64143792842339, 68.521796340779076, 39.627338431847399, 11.746498832825724, 391.16463701260886, 58.206637816935462, -25.331082180250316, -12.249472266125633, 51.499824337591448, -149.86290108814424, -33.83609457942422, 530.41035905703791, -186.02537508615728, -127.40967771990515, -409.37894828278212, 89.54586563599787, -21.671643401245838, 85.109707673289051, -57.382003121624074, 56.247419961370873, -50.965985595201595, 165.79902997413393, 20.932573612566845, -36.24206038983165, -116.05116924596156, -282.44940925636314],
                             [244.74959242422784, 243.40347060417392, 16.466925588818938, 235.44079792128264, -141.09189030963097, -98.613922467039401, 115.18469060772298, 69.580008589821702, -124.15158349928197, -15.684830907132062, 145.75576562119741, 107.96091710286001, 286.33508250938303, -54.095962255675921, 20.16811086416158, -62.239718808085811, 100.68471294881334, 237.74421793544593, 13.31187243025315, -153.0480977604814, 400.86656790939162, -141.2225285882225, -82.138508525939358, -165.5928748849106, 110.69336664609789, 277.06132427264419, -46.750030639476918, -206.8110753747616, 109.31224465026696, -243.53685024187581, -109.39764006058455, -20.65242845661631, 129.65450620092963, 68.655437973996044, 39.683305305176198, 149.71894410932103, 152.33758775304665, 137.51331482338685, -163.76059929007729, -84.34926527333397, 123.74261338940271, -153.00906849790388, 240.77196697485695, -62.559668930794551, -213.53364191629635, -147.02361967344544, -48.693009701389734, 176.7391571074302, -98.949174882816024, -36.842320765466091],
                             [37.810375451499873, -29.133711134949902, -116.88071359979688, -179.56099152050095, -121.49321324433249, -154.50614950219432, 5.5383289460844018, -12.770376099350031, -179.29945225874101, -223.87177410005719, 33.358416989269706, 78.170191600755885, 227.07704503114985, 147.79874094375191, -134.73529170266525, 184.0574708304753, 161.26368295901335, 222.48866132912414, 173.93190541084243, -44.097686439774222, 172.31547194636025, 165.80263763507133, 169.9705592094962, -211.9365152551587, 48.944649910984239, 103.71712066738583, -234.35960077508125, -161.08341514359, 132.22253461832105, -115.75084932943824, 34.144321257450862, -10.459615978130859, 150.98810984967844, -149.50103651700402, 52.3351635083256, 201.13950811227565, -40.300732798752904, -268.00540467259202, -141.48352285655795, -48.404074899617157, 112.07150410649068, 364.39319801251077, 37.851213936835649, -138.90252382223036, -18.247978867716977, -59.545813351747555, -104.63043780240531, -33.487585752758349, 114.57108773442424, 2.8847851704910408],
                             [-428.32429813935096, -28.047192463439551, 181.90464756118752, -3.2702740962191785, 339.78456254373071, 324.5901080730934, 101.12168177587633, -418.9912056255759, -171.51415523152525, 169.23334815203265, 220.11689982729877, -237.32692654154044, -444.09599289686025, -524.68349145257423, -40.853304064797243, -32.15426355832161, 4.7464325128668587, -281.94916761555862, -192.95065657743655, 42.328463125357587, -354.77150448434406, -234.17388377009465, -235.67827326665255, 349.36254325967042, -174.17381379332201, -321.4571483456595, 241.57424193972133, 195.78447548742898, -53.626869690916045, 397.39022422306817, 242.7612414838031, 233.65719802706252, -58.034828811812289, 51.301259443020143, 38.991611861836596, -188.65158094303334, -330.68334971524899, 226.82695173406952, 373.54689163706956, 115.24603027347948, -207.01708233582818, -64.031131780760191, -325.56778392691922, 365.86503848595612, 125.54089018955035, 271.20661659639296, 442.97701113830061, -207.434004704872, -361.87591889986402, -36.813001726734726],
                             [-126.40672814545954, -212.46943710815654, -2.7531038413480409, -153.99552486203626, 4.5806749682496086, 145.62044539072181, 277.78403952793042, -134.83676078439285, 82.842875334779677, -38.234821659883934, -154.66723113445744, -125.81501082736632, -109.64172156539804, 26.458190207863336, -20.555684369970415, 109.43124664834818, -172.60607472175431, -345.86924666818976, 31.892245763639618, 87.002817023694391, -204.02547628550155, 166.60889277421026, -67.275007799471496, 83.31153216447963, -180.69904895338502, -99.620974236030719, 64.115273393658413, -3.9856093881980317, -13.092926461474704, 35.775720019808084, 181.12821447266606, 44.515807313414612, -86.306254459980025, -73.978694354148146, -19.669802555484434, -43.640162693954196, -142.48698108041441, -183.91921238387584, 73.056662476694655, -34.969329790239748, -28.415290984111255, 125.06632798387125, -213.95532114774861, -55.389019868420931, 72.085394207140439, 274.57404812059053, 49.103512744262282, 40.947989927691893, -68.965043254598271, 102.01028624679687],
                             [-10.899550768582827, 95.238265726142401, 41.573790991849314, -91.450582145394293, 10.342368979672163, -66.609188342829555, -220.03855776561227, -152.09895882915632, -273.38779283871736, 34.991553959653963, 328.99934572170736, -5.7506522680830683, 40.239836536095225, 160.10246259989222, 160.5268750742467, 289.47537949047472, 155.95914658750823, 44.629226832444743, -242.91344745760057, -228.08017465973438, -98.48365504233557, 117.46930094308688, -63.834994968383697, 246.84380749042967, 57.800022658667629, -160.1541081106956, 34.428784517800345, -17.504177211176106, -178.25838239036651, 63.541340679788377, 329.85635896190138, 69.820101820892148, 176.21889538926138, -11.426495553123738, -244.91056440923262, -54.908901017877021, -34.217485659220202, -104.62483639515479, 199.39978166044085, 196.42522443414984, -334.10787760086322, 240.93014696139926, -366.42433250073969, 100.67406659704034, 228.66119559327487, -173.25053126591291, 37.421744781150252, 36.362852698440967, -143.97039889451531, -270.33849444588549],
                             [-315.92954024806983, -42.806159611240723, -101.33676711536032, -209.67789244667145, -181.47872175933975, 27.371486459609233, 136.87249306985342, -116.27280772217354, 277.50401325532454, 9.5070547859623886, 55.329298106432546, -50.13867313342277, -266.49464979993212, 162.16040896092767, -4.5989227597072233, 224.46483774363867, 48.57070100256945, -170.93882379314246, -71.88741968306978, 145.34033296047861, -200.19702440829124, 260.41691213377607, 151.84873728732271, 124.08170718494284, 116.0335598962272, -117.77962257426063, -4.4966589797554786, 91.788086941716671, 220.96745864130719, 101.7485931338733, 27.992053443001019, 128.74785068250495, -150.93769958820147, 69.152946940036415, -112.16952730265623, 101.90896606451437, -328.17092272921053, -10.554387718793109, -112.76272231987738, 111.0212341203475, -277.53819016642058, 12.072313460269813, -459.59713901141629, -102.35668734875587, 146.82821289813813, 145.11551369994015, 104.92456087058946, -35.310387024553975, 19.021298439092735, -247.7659601562238],
                             [227.33577067553568, 195.03978774426963, 43.50838372284138, 32.17565347791934, -54.029838124088421, -147.2404665906204, -126.29804322570722, 108.57160527653174, -167.52954248429106, -110.70214116523994, 94.721534115078697, 341.44930709208541, 221.7143098410221, 160.59381749685548, 202.01280298555571, -48.022593201904115, 203.1945674189698, 427.07688218768169, 52.335015127124905, -153.83418516974422, 108.70379326725543, 3.1454910693119356, 143.930681425329, -171.80216665803127, 201.71741403799044, -35.901053071882416, -230.42231357846822, -19.703236046900244, 37.229553403502706, -141.74916436201215, -191.02599950834156, 58.54431209495867, 26.86768156503188, 122.07502626719121, -193.18625762058187, 36.786074077219375, 193.56767015483152, -37.53335727547352, 12.232638930386635, -45.096680384955398, 325.02740055833902, 20.057802581190632, 276.8879258899201, -147.61517246207811, -51.87674490148806, -148.78234041046079, -276.31188079091339, -128.21145314320719, 46.350959198099261, 12.490521848642825],
                             [322.72645587887206, 35.997545143526082, -0.70817749022926801, 219.87754503907888, 107.08677763141687, -279.47970654449892, -434.50424536947929, 145.02460011487929, -201.91341868741264, 88.713510202238766, -46.194869977454957, -87.638673929684288, 165.08274842183306, -96.161103701995387, 37.342799509023408, -143.39095526404881, -16.271508442372372, 307.74909317911272, 223.00222969284869, -169.94583804598605, 138.03981174348698, 47.200900074192766, 153.22837335757623, 1.423130406763174, 124.44555302963376, -9.2785366112261904, 173.08080368199825, -7.4524016954085184, -207.99230975387556, -126.10447577635627, -115.57651919318884, -39.62417026615536, 151.41760117556893, -3.2618433938673737, -20.600251063110981, -50.578953435236883, 245.13273386239428, 63.306666451946413, 45.882956741295352, 90.670402753659914, 5.3910056600939527, 40.94618790318588, 332.05096051758954, 51.673649428934993, 68.897750845911929, -319.47869559211563, -175.37774509696254, -19.641806782355026, 72.103328972549349, -24.938748688072334],
                             [454.38915166145983, 195.26466630062941, -188.54538648911102, 260.09242419780452, -403.28938710565893, -32.18854758595387, 228.29946881667365, 87.885524163528189, -106.85724545739873, -191.16406177217613, 60.673218810807576, -42.977310344885211, 552.03346895050731, 181.11168741136342, 1.0290186421418757, 169.58074683223583, -6.2109817968215104, 392.94230409021327, 18.186672033269168, -176.70592825405211, 566.26341277339679, -82.319219264723401, -192.06953961388371, -278.87284429485982, -1.5843828918464322, 563.76968783791096, -162.03675173996672, -206.04319948218193, 235.06719526841485, -286.25565320702384, -346.67181371532382, 1.1392443098162175, 249.85851892504661, 93.760728110200773, 2.6973720122790028, 544.67056254343754, 236.44835389422116, -70.367331884155846, -215.00824076823852, -18.715367222646449, 252.77585034982755, 99.618899693913647, 148.90349990684996, -26.774282103888265, -102.22224480907462, -271.83683686976343, -252.58652884853859, 164.29038777210374, -88.617345499863262, -192.13677922696485],
                             [252.7480619445561, 112.58117995804153, -14.233572158058573, -261.47056519264061, -19.617510581847036, -196.44455345723844, -352.73082370594932, 117.11189719277262, 8.4867831316861491, 85.411588344380647, -10.105427915215888, 183.23114002318363, 263.61146460988635, 88.399575034134628, 181.9884749858455, 59.399927083481579, 207.30084272736303, 269.77495965203036, 32.938121152105758, 85.034172914226346, -77.233993337246531, 279.14295151508742, 146.028251867216, -150.90465150574929, 51.645456929575673, -9.0523806346817572, -165.42336328396632, -31.549153263909194, -105.03912188343706, -104.83895165618542, -131.4737885332429, -212.68433560562079, -20.734459293256847, -66.531376055387497, -56.909708741405389, -92.840932777909657, 161.0087572286844, -159.09171728917772, -125.34492447386344, -21.861901918084421, 103.41835861146301, 175.60521077021136, 35.077290875981056, -69.482793059466204, -40.966093500400198, -198.47607130806173, -338.44654120138722, -182.89077131822225, 213.36955928869708, -1.9295137928463961],
                             [100.71930884368392, 82.10304512927199, -131.61323656139857, -35.973391991218925, 159.24970404263644, 159.79510026666438, -359.54800368546904, 127.46386627271697, 8.0734273482840671, 10.316778208442395, -222.87094833368661, 142.61493715481777, 144.38062606865029, -23.270582509466319, 54.957959180218154, -79.128742009261927, 57.033296138836711, 39.181178824824464, -62.814268260213254, 240.68703925068917, 12.579273608808577, -194.62087098994027, -104.84220336875063, -45.169929472165407, -276.87470692685355, 91.834007977019439, -140.46978344483438, -78.21668054407715, -124.91866081769238, 76.954359966268768, 30.826388793484039, -225.17492529727465, -71.83382400119477, -129.71865479458012, 141.36092491380762, -269.52852550873462, 211.64450577912544, -84.211806512770323, 55.302217838875677, -129.07984087930728, 239.84124276177096, 145.48694073442428, 239.48067431895575, 41.750892211690861, -138.2469012476123, -221.2361438521252, -173.40651978609318, 7.231992330062754, 368.99686114921201, 248.00507325227233],
                             [-348.72131109766366, 235.93644312438502, -69.133540125725162, -87.894524688436547, -182.82383067691364, -172.87319123541607, 395.89551548959486, -429.75534032275897, 153.84369857610417, 127.16383870571021, 209.88246597783956, -23.238589524287981, -315.32822844941114, -151.77320996210122, -75.386074775711592, 354.71405647931215, 140.4504972591192, -101.40258578189986, 292.26060161949522, 78.731802759613259, -151.93600381813749, 182.54606492315156, 369.77334383845385, -21.857489815544817, 388.1870101076525, 22.535667317353006, 152.92216569273944, 10.34840343266964, 492.82144676380108, 52.667343042790208, -144.19688783253784, 88.324077983725672, -99.742403751635422, 212.22015960233006, 30.655413075844514, 335.3969286883372, -632.33722052167388, 287.6257569622835, -194.17480854362162, 50.330220751606817, -448.09366075436924, 10.800149106532908, -366.33889555802483, -144.81857699256111, -10.010844145957877, 110.68316314873572, 65.674270052686069, -276.64546828720842, -3.5447691813271014, -308.9998496118705],
                             [-120.60816236989965, -141.53312473273644, 263.70057030375949, 64.090860710529441, 217.59346349511966, 219.90645082617652, 162.11486599405015, 9.8883376202527504, -17.562774374166256, 438.25505189259201, 125.65600314878432, -522.59679739196747, -641.86684399736612, -499.591724269346, -241.58377370504761, -508.68889041158326, -173.67199485895429, -188.65326985159049, -579.71764876552868, 138.06176705783832, -409.82148614525812, -229.84818304529188, -518.47725061419919, 231.14173221827969, -300.54998037171686, -354.68872136997214, 628.28753636102726, 394.49074332185603, -237.19791091307886, 333.238313235877, 290.53351092595148, 171.12964616366921, -193.09259589709072, -103.53155311481683, 117.32887822977773, -383.48905880000734, -18.412883556365614, 451.16448648243431, 212.42057390738375, 92.926566633910028, -103.31747373602005, -573.22243349686562, -161.82579298199624, 423.2916977112431, 263.47451063557236, 254.35500029389726, 467.72890546764677, -68.197375164081222, -690.29879964245617, -236.48967490517225],
                             [-202.27914262084755, -98.973181155488817, 136.41886145588481, -121.58951423875112, 247.16470551866573, 57.058758442599888, 207.86149967622865, -209.22327843869806, -14.426443294816089, 74.463221673312617, 35.976221405543797, -111.47453928192095, -312.2815398165007, -179.90151733431028, -2.788613990195818, -57.224857976009289, -80.370565598751952, -419.71116860161175, -179.52544263060298, 53.806337367974095, -353.95351997557913, 38.129839603524239, -172.54421492991571, 127.83932435388287, -186.74434576566833, -194.854971908262, 206.63951441219839, 27.193023134029353, -111.26182549407967, 248.96761509521932, 279.15965695258296, 99.4214315583244, -70.675516669410669, -173.10837323629113, -122.44340258665386, -197.92091338225194, -252.51845770698546, -18.64389484113439, 140.82597880302228, 107.62145691435214, -159.86861102281162, -62.037023257808087, -175.70695069503816, 82.458091198380103, 26.519867020351228, 359.16001687956134, 231.53729295199815, -102.54006646463314, -244.34614469134786, 17.335167190938723],
                             [-95.196429534690068, 77.173054665340217, 218.64070300758215, 61.289286250982705, 74.230835943813474, -167.95822705697256, 122.44926558333151, -87.871654100039464, 15.400779562068587, 125.98996096848293, 168.18497817375913, -113.90393758866843, -329.33986406892257, 29.812096988078238, -5.7979292425371129, 247.221965866414, 46.417086178555238, -209.31732494896625, 102.88395957041533, -92.711986657299207, -54.187298334206268, -86.272570773955181, 123.743042428575, -32.369235454498309, 152.99494956919708, 109.92339783231635, 60.905652100874349, 60.704644494610513, 133.43438056339511, 79.26299058437246, -2.6580951594896067, 115.07098432714849, -22.586316213169418, 181.44919933316791, -148.36998187591024, 88.821989522710865, -199.36956993594907, 109.61200213711994, 155.3262037523269, 104.11677224067859, -197.11219601070664, 18.441745945439884, -67.590691423195949, -128.7102294013167, 179.06527188010585, 75.284316252289074, 118.88919226726986, 3.2753263184087835, -173.82301553920234, -83.157940429425039],
                             [-38.171839445842721, -45.57602576795805, -118.62103904881054, 45.277298651328088, -212.08670878867795, -248.81399328765866, -168.12838645575951, 47.470402001594316, 101.48980170198327, -288.99721712491237, -153.79362152132555, 92.507505591518694, -91.573291081071091, 150.60231485989922, -37.396189168719985, -72.247019441621674, 254.68556702977233, 456.13670193993374, 91.844340425640041, 259.90146372779606, 80.110491973624676, 297.23849809913054, 365.94304201791505, 9.1671188497483183, 284.63476539672973, -134.67249183394506, -145.12660048121316, 40.879878263736451, 201.19719942218865, 8.7499868462702892, -174.79225119556116, 149.83425075654949, 6.4263544705135143, -58.938519454529768, -36.785567133153677, 312.74750236608958, 22.282792913820224, -176.1990123366005, -454.37174813475491, 128.85693158015914, 122.84226612065248, 187.99347163075805, -11.455927639549602, -71.041409070134463, 56.088306617338354, -26.904323807520704, -159.5408323496134, -169.90747905324892, 219.79134750717532, -311.3073632262554],
                             [-68.98241920852783, -223.69050183049276, 28.778664128542843, 43.987543810080872, 277.63994010652414, 507.68260034662632, 69.335029866700609, 57.353285178302229, 107.63367676529801, 276.99739225802688, -221.69709919934112, -130.25960507692918, -344.76543401227207, -132.90385791875283, 52.153441181715074, -281.15102095005699, -365.96241663498466, -430.37098428241978, -353.76497834061064, 160.58257034596804, -278.97004601738104, -462.41167694080031, -503.65355441120579, 181.64111118185204, -413.69089156772196, 0.61657086560602847, 289.55095921387272, 254.86027618567971, -268.85485025168367, 325.705679275401, 263.37245091707649, -103.63707635716166, -264.81505432626523, -87.564882690456741, -23.808793790816022, -384.52341976566584, 245.09194870859486, 253.50901781086259, 363.17259469854719, -25.731408753253099, 24.642964742055732, -517.71105734998366, 159.60565684190891, 264.3725438635953, -62.922495435819087, 119.59840915771582, 128.21985757017271, 157.1917770210884, -127.76620516054889, 293.95254840977276],
                             [-6.27211003436528, -60.27072431027009, 96.270059884551259, 40.216201876740293, 251.44141131019262, 29.116954979206263, -198.90466587806782, 137.10405585637599, -160.1507060153167, -98.930356409695193, 207.47436966030619, 203.73546098730162, 252.4426142635412, 171.11532635745567, 248.37239581556801, 16.238667695105715, -201.69074772598282, -186.21745898066874, 47.425736540757718, -355.4865848927459, 128.75574490064352, -68.891731774801471, -48.713633848709193, 42.130758102483647, -87.552309889614108, -38.671306522227489, -130.68316727601734, -195.60535420547424, -230.66588601672208, -65.417924847546871, 3.7265585645135615, -2.21709867937285, 58.908691698869575, 112.4854870445977, -53.879742134280022, -194.08918154175947, 137.3927221467014, 25.816730065009608, 276.01143509051286, -117.21370256294645, 68.179873390818017, -66.757556496044174, 214.02091561654089, -13.290507523004004, -112.84107293473005, -66.099902965546164, 42.359828027925978, 266.75449435035307, 85.091607024817137, 415.79578185781804],
                             [249.93208255013374, 26.148924445129502, -10.512938510968858, -28.901721237492694, -118.18830531092728, -113.98734473681874, 106.5811650361038, 75.846448741545046, 37.954032426627009, -27.806587468166349, -223.80718547172776, 114.33780390748554, -2.5957009764027559, 25.778782404457655, 16.982645248449138, -199.99536438541008, 123.10991518393594, 347.57689758544223, 44.788296487986614, 182.98863020816719, -6.1497977291799266, 111.60428238002524, 82.816280147924786, -273.77939128359458, 97.679758496879572, 121.12249657040987, 3.0592613780516658, 48.465132199508162, 121.13909424125001, -83.979223315364749, -219.89397760777447, 4.0689091126845316, -60.757752321697851, -82.913052652841699, 0.12649587069088453, 181.86866184246665, 206.03496952598238, -22.697301336692998, -303.30297559653445, -50.813110409466987, 350.61635700337354, -94.160658883748653, 258.39129369326986, -109.4107550305866, -97.487250428512112, 22.904043019351167, -333.92839380840519, -219.64317831876008, -17.857875210540215, -138.63812220598589],
                             [-204.65428892647367, 393.98388614555506, 12.617435285932004, 149.05742065526661, 193.97298480923476, -285.24480310993152, -327.47887035969569, 88.548494885841265, -118.40973701352415, 84.949617643120718, 386.39622548058361, 574.63668728480934, 177.94672797300097, 78.458199000367344, 164.82025373608369, 37.420526055894371, 105.00714668315119, 21.714979162374512, 603.0022459866691, -493.98761683183318, 153.62336819567957, -90.680541535531873, 575.85868068369837, -135.84767401531303, 500.33221879506453, -202.48495377802325, -182.02754885462562, -159.73197140119791, 73.377297025510032, -160.59686813946317, -278.4991573264092, 207.47468146801509, 113.04267060238328, 460.26202129910195, 7.7933654925580642, -280.4217033053161, -355.26473933468611, 588.89732667399858, 297.40221663627102, -153.5417804025692, -68.652007625904048, -170.95684392930792, 392.17010938800576, -365.91320357662511, -212.55927073172981, -214.4458427043069, 10.347475287034754, -16.088202586825169, 366.33714218466622, 436.7079606447557],
                             [52.615208132747277, 102.75402145971674, 220.13054312621944, 37.287113880204643, 19.590147131505137, -327.49968487297235, -288.37541689385716, 186.17717952786998, -66.836506343934232, 106.03382875969376, 163.3444448422851, 218.61574821821105, 57.831752834550329, 130.96627007737217, 34.239726687072555, 83.912837824054449, 100.31809779830567, 67.366445628014645, 372.67287202015683, -219.33587671120713, 62.121999284007089, -70.239714481521148, 381.42150379448123, -136.43613660763481, 354.36019420777194, -98.427889687901015, -201.39202926797222, 36.298167983667511, -19.498463682610673, -133.72264980342447, -137.06553098565038, -50.905971455458698, 30.348742950777492, 195.61657397323657, 16.891326132226745, -87.524696200581943, -51.935878941748093, 151.83559800139071, 135.80682151817379, -117.96420197434159, -58.131197470654385, 63.150408312930097, 240.46403452240699, -167.34222709156043, 71.993014915944386, -186.24488231052689, -100.58534820804927, -35.002170089487059, 141.88643540598446, 149.60097993508469],
                             [-53.510078799428804, -63.247670073086326, 129.2373021451304, -110.55327330735349, 26.317438864112635, 55.65787121169059, 181.89847217189043, -18.787835503605383, 94.927808221477434, 107.15238020408343, -171.79326812212369, -96.823359191735094, -194.04814287451543, -71.106391199343378, -15.674698035608483, 67.056301905971821, -72.866530978722864, -189.84140093115238, 128.29846762185673, 207.34223175317257, -17.720746093210572, -74.67210238067689, 28.272235441651375, -102.78704323873615, -53.586116322464051, 159.23027819207985, -85.812877981286647, 29.392412153293659, 110.63263817144592, 52.099951326891265, -35.60837989571683, -74.708326631415815, -211.79816472292433, -3.4945102161368342, 113.60204739662861, -46.33005926678436, -33.666299758953777, -15.844444712323929, 23.203523973385369, -184.82182506282189, 102.93915481270651, -23.823507873274721, 70.914261186171046, -54.971868933455752, -35.422486507270506, 138.93055980112106, -62.716174432963861, 15.837706569975795, 48.283268239168592, 151.93927107510078],
                             [-213.94067479867863, -90.747557316818515, -45.733334031230697, -58.468367041682761, -35.24130358030046, 324.45122210063016, 308.74158883282894, -81.734698233731606, 212.96292242555251, 90.491500884861054, -94.341111499575703, -115.70378644592346, -341.55238689905156, -72.622806862380145, -95.550338342783277, 38.916886055061319, -42.402092633459418, -338.69420699207859, -165.83261408144406, 257.96207953600475, -136.74163632456202, -155.24548060798892, -177.05646998164744, 53.450599650204033, -243.70712313868216, 42.93994662089424, 97.002141557617406, 141.97827278817007, 187.74752082436729, 182.03243488806262, 54.41341328790358, -22.825619947200593, -211.2437465215678, 17.57971428068775, 24.916056271638926, 57.83999642616542, -186.53233268922352, 118.12806764528828, 13.27594253483106, 6.5795980909103671, 21.578491076504175, -73.300925807373034, -230.55213661501458, 47.748721564596956, -9.406866256483724, 183.99207684039138, 137.076699503664, -5.436909434801497, -114.83180957671439, 24.402129919128264],
                             [-101.34991617718819, -103.37326798916649, -78.536040871814009, -176.14709586206064, 41.245684556807305, -151.82821182335454, -45.760219946980826, -78.866840708070072, 92.439921238021427, -62.407552396503789, -143.99742314962336, -7.4188001678900068, -221.0979374692343, -56.920404933345459, -157.43609428866631, 20.625981164607825, 135.52778942857981, 131.67884905962543, 65.253372866383685, 281.90107128952997, -137.54480331208808, 145.91060505420225, 245.88682667278923, -42.189783824092963, 72.810016522848017, -77.289005191543069, 63.937022056358515, -28.064549382548211, 192.59899613860077, 8.8608348268997279, 23.037422615075677, -256.00101285876133, -173.17893505198839, -194.15976429153724, 157.13097722819421, 160.93262150827962, -42.974124848326852, -124.55508640071928, -338.51286053985024, -45.169020433057483, -133.2086309994437, 83.066209429097455, 11.916156607182131, 9.2485234315316553, 31.69212387563536, 51.087974155241071, -18.203762554773771, -205.8113277227674, 177.9130536459931, -156.82984523136417],
                             [-346.02881526807391, -190.45527459058366, -71.287502613145776, 16.907461912872911, -3.8136076462587267, 196.82126033073172, 72.215615011352639, -190.62717419065652, 257.14243489233678, -8.4292600215746329, -232.34817705654993, -223.81267349246673, -477.0015917460521, -152.68768053300528, -299.58146873654897, -174.39797612091215, -166.07353599873889, 18.740875615692993, 13.892278470128607, 305.18110576524799, -267.32962655446579, 11.519160640111981, 105.49493926543367, 85.123168688992621, -19.266173663686562, -133.16418514487134, 203.65593232522627, 223.78415150076009, 184.45481129913861, 166.47378253877463, 10.794510473994297, 73.37023156435977, -135.51010596173694, 28.090078276254715, 311.34493325397528, 35.381550917443803, -143.12922723455705, 73.888739247871584, -103.03570849435364, -112.9409761758394, 3.9896501050692907, -43.128129157829257, -44.441450828102496, 47.904217336598727, 141.78928309426257, 43.206947459083345, 119.07915942399129, -133.62406673141606, 43.83122148517046, -87.368145338531662],
                             [355.98857922802938, 18.292288943383149, 11.654797125960425, 17.525860586488509, -79.682737097813288, -197.91719747226492, -158.27407530556255, 236.63393829992765, 34.950205675296765, -8.0617353204667932, -167.79288380062033, 119.74130381303004, 331.99681830125479, 58.664295283675465, 111.60474374871004, -208.10963154311199, -147.99061284682043, 133.28371065004134, 98.272807593943327, -9.2734770697043629, 2.5935284334325539, 200.03855544201539, 55.643123772287048, 6.4565475672685402, 0.1451005756916226, -125.82167545859136, -34.589631209048989, -29.474128053126059, -314.62383330122134, -213.52078443703476, -96.688805840256975, -236.84985904469471, 15.572139524516896, -61.525250877187467, 68.411545404052475, -191.14006662760602, 266.96317019476294, -170.75445293190492, -70.427098608766798, -103.74170271073891, 162.03753565876491, 48.956368245657202, 169.68353726638097, -30.68740947116488, -18.523426607233702, -144.16418276881458, -252.35651333392894, -30.154533999997945, 203.86837193069778, 143.10388408941253],
                             [-11.318107395279974, 374.87848165546541, 40.093995530712313, 373.53527275737321, 292.12311502687015, 26.642241003604955, -49.539731097271179, 5.9644930724785246, -207.49017578770975, 6.5565713662945981, 231.89892432338772, 338.64461259356926, 483.75804882366367, -121.02224928733796, 319.16592590888831, -187.848814875855, -136.46329724680783, -199.55991191856967, 259.71302271348753, -597.92698008787579, 299.4653193464157, -192.32472091439107, -27.655899833881001, 105.28363900920677, 41.174074634926676, -37.131868287704414, -22.281028821769759, -300.46806029828281, -367.3489031027093, -248.41070864723056, -201.27545689566304, 266.42209159573866, 132.98142532076153, 270.19341200548388, -64.799779801624467, -460.5202519378812, 79.11267152689193, 182.74730803575349, 379.17391069765102, -22.638145712293628, 191.11818989159909, -283.85977197324706, 277.84883138704396, -193.41944347378964, -267.45684847025461, -167.35301746955506, 178.0244269032282, 248.34911655645544, 145.54729365461532, 523.04926720090248],
                             [-103.32946964905781, -154.85247361118206, -24.203591213787263, -152.32875947891216, 38.165770264054899, 81.031030427966172, 165.58195272309976, -128.21884937491504, 94.293616351247223, 165.088034302165, -141.1912782143655, -190.31161924214715, -414.66982434677965, -105.20475242067013, -139.9666770594153, -76.870469676426083, 61.801443557779308, -102.21276263618083, -296.69640197775288, 282.97963321676139, -305.79408605647967, 54.432808196807592, -148.43359253107823, 60.15204202883654, -175.58332081670477, -112.80132191859975, 285.55265268374501, 225.09007946214339, -33.349692519516914, 229.702075535402, 266.48707752351777, -42.317498767092189, -123.2445919940581, -218.75147459803156, -105.83918596819284, -55.221403678451964, -41.169714488759155, -19.663514229673744, -71.76179699007028, 168.80106720130917, -64.315723450293149, -57.419996608206105, -200.82602742986333, 82.222399753174955, 85.483176082228439, 161.20859405256948, 60.509024915907155, -153.46736938049307, -178.86426385572815, -105.73895616241282],
                             [-12.205514163451053, -136.24440138217363, 36.688872744365185, -215.84040150614638, 59.698693265203531, -48.968666779660758, -153.30729016059931, 153.6530120389163, -0.6181492241629245, 24.147952359589929, -0.58621058091608802, -116.04049586486911, -74.928193792366983, -22.731732907445753, -48.987458330610487, -127.32460517176092, -20.196343808772685, 80.276260156783209, -115.43154878757703, 102.31537010151878, -184.18549929026113, 136.53310561505918, -19.24664169753294, 57.906124985085334, -51.795145208710778, -213.89035682521407, 92.120998410854625, 18.182430017103389, -113.38378726692895, -1.8734365616314235, 93.716835321372983, -76.498731591849591, -180.55618758842161, -129.16910699241234, 147.81971406741397, -181.73304371777112, 122.81633859719618, -49.277866579853097, -67.509891354451938, -58.690717612391197, -39.171245193973675, -99.955520836444663, -14.356268264507575, 63.285551890517773, 150.92729927220381, 67.277131822683586, 98.744841251250662, -26.842967348656195, -23.047027819192586, -137.01270661080372],
                             [194.10878571844339, 186.4257265446775, 139.75289023708399, 237.82293582233078, 255.25835566891047, 15.112462996608635, 62.097042988200407, 55.609666081570317, -203.17850346089162, 63.59029586353676, -21.483963187765752, -24.358995673172348, 125.44369820790186, -207.28449322602799, -51.005078039743687, -126.34221470618301, 9.3380076890880517, -76.459996811230354, 4.3722726434680892, -193.33218953804371, 164.29255653626623, -334.06156796446811, -203.78826577068222, -242.1883252637281, -151.37111735489577, 207.01465351962841, 64.288542695348013, -58.862055778433202, -103.53987835609779, -97.730749267972286, -167.7908200638085, 51.754788121631343, 146.0282096485538, 32.658316446618443, 66.262475814068168, -111.30630500753688, 70.699833097685584, 84.704798841307195, 199.79826077569504, -23.262826016925242, 257.88938542563767, 17.721708160296568, 220.52343322560213, -32.406075348210408, -18.966528094767185, -90.695332181645966, 8.7601877804589421, -14.289580773144086, -152.93541857332815, 141.34697169139901],
                             [-167.87723811124741, 313.62746011275374, 129.16092599608484, -69.769287205825762, 167.17367606100356, 108.03990559806377, -48.552327049830438, -130.72836496498206, -80.496674893171246, 199.00658657983774, 370.54971749567073, 209.34394730815382, 54.451056438651989, 19.131001074672337, 247.25171390466022, 109.43985172985509, 155.95318612928162, -414.97855420295525, -159.30189414315288, -329.072901255761, -114.30021404680147, -2.966897381954003, -58.913605678528668, 160.02699428889395, -66.30802549644261, -237.02887376313268, -62.631062688888747, -62.348753384391529, -211.92925073572414, 1.4453339993711039, 102.18331753838396, 126.27886900751457, -23.209785010024746, 116.82151013920853, -253.76012681254744, -452.34820897486622, -285.7201696608833, 37.999673807002679, 364.28008773919896, 56.68293847784804, -84.073425346313414, 48.33631297708159, -404.93928810398478, -86.131147951605129, -30.767669259805594, -122.13851917785966, 147.67672484593319, 38.091330281065034, -100.80174870666349, 153.96337506341249],
                             [-116.94741033975778, -132.79828279336644, -17.80004360284244, -117.03841235591189, 58.171996583658597, 42.181756046382311, 113.41796608820019, 114.13449178952335, 222.78463624743506, 172.63113437456988, -142.86233098813668, -147.27310951978288, -217.75471178726985, -83.086202468037186, -97.79944238729297, -24.96811397462448, -169.08957217828359, -279.90910258691133, 34.63345051447363, 204.30474821637941, -178.71188281381961, -72.611591833324653, -64.236872411891255, -73.844359862244957, -64.501660460977845, 72.951984460628694, 139.17588537214735, 69.051753833123826, 58.67542582694125, 53.491232356934347, -32.514813383315747, -61.340977032717888, -130.97735390525165, -43.29994815043522, 210.38251920741126, -68.291071284425826, -79.191377299687304, 193.93505172117864, -24.389298813998568, -93.381721114731619, -67.974074240179078, -241.47305801164549, 36.623231030064261, 9.4703596039701541, 37.577049713635162, 119.54279151141733, 88.844018073314359, 40.783144473484022, 40.192481208655764, 86.065657984527405],
                             [200.57026031846434, -61.93783162789363, -126.56362724616596, -62.26267374999108, -136.28119938248068, -219.66678752953129, -199.49097785723265, 244.00794336530205, 27.809912580573211, -209.16257881851595, -80.951593770745092, 36.787347901206935, 115.54905958199264, 105.86285605084329, 76.413281255064078, -208.68376968505581, 49.070721081918684, 511.50180660118099, -142.61125517025923, 158.30865677849729, -24.395145897022399, 246.96046798630439, 43.142140205444029, -14.544810604863589, 56.453355685155266, -147.74968581982088, -29.145970749666365, 53.92133951811055, -65.626590472909697, 8.122911576387688, -114.47373456741732, -5.4998033943810327, 64.286639756983845, -92.240035480306545, -76.179677672472536, 71.774137378821123, 257.53434175506675, -134.08709769876691, -261.0876771645394, 108.70115300617847, 282.84574459764923, 1.9761859993235511, 177.28611853387807, 48.738789606705502, 8.2262359956477482, -91.27165085218752, -228.5525312720774, -135.76661013301435, 126.57544640527766, -112.76453399355871],
                             [279.33020157372459, -183.6008256080535, 139.31131339755467, -166.08500083081864, 176.85218227659431, 39.1541064954096, 356.03826082702375, 368.24158937581728, 226.17538642812144, 167.00265085062043, -405.5436835261915, -79.599034768187508, -0.094212388683402731, 26.605222294242633, -4.4297543982042917, -146.85573998345049, -429.41634354505271, -444.78414541190909, 84.13017774934292, 126.45839064621833, -35.066982256207204, -171.12438989516056, -182.6657235899637, -464.2950071603866, -297.861361333773, 352.26160082595464, -45.696288839167615, -30.767313043637991, -17.008413312713191, -101.89502987815348, -216.18575142636382, -340.78632930095944, -248.16599960755568, -81.437101418937871, 168.38971290149368, -202.42510249846424, 155.82390378835089, 60.609049674113017, 97.025716342329062, -376.74861289745036, 313.90701365897775, -361.72570535882136, 457.09090124994373, -136.33143268524671, -177.42377059451954, 271.55651727351704, -205.2364228320794, 110.386154628043, 14.758313397241301, 485.22053668910172],
                             [-277.04036114664274, -45.590676286792998, -97.788031188051832, -149.6896277645543, -98.442060900514804, 211.4881316679745, 286.03737369700042, -137.39915029149532, 137.89283721250095, -33.358112950460445, 153.93972513983871, -202.82155914568943, -157.99659101977937, -127.60922537977167, -0.17883998129608791, 18.358821688585039, -158.55550888317643, -294.02374034848395, 3.0488877950987336, 21.848677975258305, -119.43499528693584, 113.43944279187045, -66.026702395614663, 151.95640848638661, -66.710423136441705, 24.80175338798264, 205.38767742184402, -94.408681106914088, 215.17431511661081, 45.706521013843563, 40.053107509440544, 142.14941324676354, -149.36015140269106, 48.370518670852029, 78.065738586718311, 51.05330871739568, -313.38595614642293, 112.85020885702639, -29.699052264056089, -40.829176278494515, -131.69693663233198, -130.4688756625539, -315.82981334229697, 3.7127226765550989, -101.24291630680007, 159.86361412783828, 196.42683280827561, 107.095654848593, -143.59680494753133, -141.95566072731705]]])
