
import numpy as np

from optproblems.base import Individual, TestProblem, BoundConstraintsChecker
from optproblems.continuous import RastriginFunction, WeierstrassFunction, griewank
from optproblems.cec2005.expanded_multimodal import f8f2
from optproblems.cec2005.helper import HybridCompositionFunction
from optproblems.cec2005.helper import generalized_schaffer6


class F21(TestProblem):
    """Rotated hybrid composition function F21."""

    bias = 360.0

    offsets = [[1.2141, -0.01, 1.8864, -4.1124, 2.0627, 1.1535, 4.0653, -1.0213,1.1986, -4.1795, -2.2924, -2.5667, 1.8881, 1.542, 3.3243, -0.4356, -3.7297, 3.9595, -2.5571, 1.3112, -1.7149, -1.9905, -0.3615, -2.574, -3.3399, -0.1235, -2.3588, -1.7846, -1.4377, 1.2775, -1.9487, 1.8815, 2.9909, -4.1988, -2.3918, -1.6522, -3.3576, 2.0885, -0.5426, -4.484, 0.8963, 3.4959, 1.8402, 4.2325, 4.125, 0.7111, -4.3325, -1.8009, -0.0755, 3.4323, 3.0661, 3.5557, -4.4331, 1.6923, -3.4752, 2.7334, -1.6906, -0.8983, -1.4713, 2.7338, 1.8929, -2.4775, 3.5147, 0.6024, -2.6482, -0.5764, 2.9721, 4.234, -1.9843, -2.9114, 1.2712, 0.1673, 2.8046, 2.1774, -2.908, -3.8631, -0.5863, 1.1673, 1.0729, 0.5266, -0.4647, 3.0696, -0.2551, -2.1256, 3.9083, -4.4297, -2.1308, 2.1075, 1.5273, -3.4005, -0.7549, -1.3951, 3.0333, 3.1159, -0.9863, 4.3813, 2.1197, -3.5107, -0.7488, -3.7914],
               [4.0818, 1.5216, 0.4885, -2.1115, -0.9636, -1.7972, 1.3874, -3.6363, -0.1115, 1.921, -1.0548, 1.3335, -1.289, 2.3981, -2.4746, 1.9873, -1.7596, 1.7989, -0.172, 3.5137, 0.4695, -1.8635, 0.5892, 2.9851, -3.0491, -3.7284, -2.818, -3.76, -4.1049, -1.0152, 2.1168, 3.2518, -2.7934, -2.1856, -4.2964, -0.749, -2.3565, 3.069, 3.0151, -3.2044, -2.077, 4.1177, -3.9313, 3.5502, 3.4293, -2.7408, 1.173, 2.6497, 2.5586, 3.0506, -2.4302, 0.863, -0.5463, 3.0528, 2.043, -0.2444, -3.1867, 3.4962, -3.1975, -2.1524, 3.7764, -3.7112, 0.3666, 2.8226, -3.9937, 1.483, 2.6722, -2.6998, 2.5438, 1.071, 1.2498, 1.4637, 3.0981, 0.1128, 3.9275, 1.7361, -2.6762, -2.5319, 1.3871, -3.2844, -2.9947, 3.0384, -3.8491, -4.3642, -4.3807, 0.5199, -3.4637, 1.4696, 4.1841, -3.6893, -2.6927, -1.6249, 0.2205, 2.6036, -2.6017, 3.8607, 1.4933, 3.1767, 2.223, -1.1787],
               [0.6052, -3.9738, -0.5416, 4.3278, -0.2229, 3.1317, 2.7925, -2.2801, 3.4103, 1.0519, 3.1188, 1.4232, -1.4742, -0.4891, 0.1036, 4.4031, -2.3062, 1.757, 1.4048, -4.1159, -0.4356, 1.9904, 4.0838, -2.2741, -1.0181, 0.508, -2.6469, 4.4811, 2.8957, 3.2126, 4.4553, 4.4182, -4.3608, 3.098, 2.2222, 1.4126, 1.2397, -1.5306, 3.4222, -0.5516, 2.934, -2.8562, -2.7874, 4.1609, -1.6743, 2.5435, 0.3002, 4.4039, -3.7675, -3.9423, 0.4691, -3.8578, -2.7478, -1.9551, -3.132, 2.8418, 0.2608, -3.9395, 3.8014, 3.3374, 2.5973, 2.9045, 2.5564, -3.7581, -0.3058, -2.436, 1.4041, 2.1208, -1.7291, 2.7149, -3.7795, -3.8423, -4.2916, -3.7453, 0.9591, -0.391, 3.7799, -2.2175, 3.0425, -0.6226, -3.4341, 4.2612, 1.4325, 1.7646, -2.3513, -2.3909, -1.0829, -0.2113, -2.8032, -3.2581, -1.6598, -3.5483, -3.573, -0.5369, 0.0841, -2.2954, 0.8465, -3.3745, 3.8504, -3.7213],
               [-2.6639, -2.1802, -3.1792, 2.0201, 2.4322, 1.5009, -0.7393, -0.2911, -1.4312, 2.7447, 3.0716, 1.4979, 3.7553, -0.9232, -3.3333, -0.5298, 2.271, -1.6731, 0.4121, 1.1205, 4.2765, 3.0098, 1.4542, -1.8593, -0.1257, 1.0527, 3.8102, -2.08, 0.3446, -2.0903, -0.3923, -2.4076, 0.2102, -2.9712, -3.107, -3.9975, 3.009, -2.8137, -4.1856, 2.1249, -2.8836, -2.296, -4.0687, 3.3845, -1.5775, -2.9558, -4.2981, -3.7987, -1.3006, 0.607, 3.8318, -0.1204, -1.9084, 3.6948, -4.3925, 3.3801, 2.6539, -2.4504, 3.4088, -0.1365, -0.8401, -4.1031, 4.3217, -3.6697, 1.8138, 1.5603, -4.1043, -1.4415, 1.8065, -3.1056, -4.1038, -3.0627, 0.0804, -3.9456, -0.8238, -0.0637, -0.7405, 1.7621, -3.1319, 2.6065, -4.0776, 0.0283, 0.5891, 4.2987, -2.3073, -1.613, 0.2113, -2.4071, -1.0238, -1.0516, -1.6608, 3.7724, -0.4601, 4.3205, -3.0311, -1.6817, 3.1017, -3.0356, 4.2903, -2.8272],
               [3.0023, 0.5371, 1.6552, -1.1752, 3.0904, 1.8121, -2.0336, -1.235, 2.03, 0.2474, -1.0874, -1.538, -1.1655, -2.1264, -2.9285, 1.9664, 2.6378, 0.5348, -4.1523, 0.3942, -3.202, -4.1409, -0.6619, 0.9257, 1.5248, 3.6219, 2.8349, -1.1661, -2.5568, -0.3029, -0.8662, -3.7156, -2.4034, 3.988, 0.9711, -2.2363, 4.0862, 2.4312, 0.5269, -3.6794, 2.3321, -0.6885, -0.7644, -3.6642, 4.4145, 3.7814, 4.4081, 3.2251, -1.8183, 1.2872, -0.7508, 4.4364, 3.5463, -3.7879, 1.7813, 1.2746, -1.0384, -3.5612, 1.7283, -3.1779, 2.6354, 0.4451, -0.2228, -0.517, -0.3103, 1.067, -2.6302, -0.1615, 1.4042, -3.6862, 2.6073, 1.4835, 2.1265, 3.1533, -1.2669, -1.8853, -3.0782, 4.4847, -1.2478, 4.0862, 0.4487, 0.761, -3.777, 3.0916, 1.6184, -1.3714, -0.6851, -3.9914, 1.0627, 3.5394, 1.0837, 4.3217, 1.3782, 1.176, -4.1548, 3.5888, -1.243, 1.2685, 2.191, -2.3416],
               [-3.7921, 1.9074, 1.75, 2.9305, -1.261, -0.9489, 3.3458, -3.3173, 2.9567, 3.3402, -1.5885, -4.4168, -3.0708, -2.692, -0.8952, 2.918, -2.4298, -1.6993, -0.3591, -0.8665, -0.1379, 4.4097, -1.0322, -2.3371, 3.8093, 1.1585, 2.6794, -4.4315, 0.6164, 2.1773, 2.7155, 0.1029, 1.2932, 3.2872, 0.2004, 0.5895, -4.3604, -0.6427, -0.6126, 1.6142, 0.2314, -1.8536, -2.1248, 2.7414, -3.5155, -2.2723, -1.6429, 1.8282, 3.9595, 1.2135, 3.1549, 0.0257, -2.2117, 2.391, -2.0968, 3.6053, 0.6441, -2.4491, 0.0651, 0.0787, 3.9561, -0.9362, -3.8929, -2.1303, 1.9851, 1.3302, 3.859, -3.5488, 0.5555, 1.5043, 0.9456, -3.6234, 1.7853, 2.564, -3.9839, 2.7871, 3.285, 4.2264, -1.0093, -4.202, 3.2959, -2.6248, 3.7068, 1.2721, -3.5429, 1.3026, 3.0692, 2.7808, -2.6856, -3.1195, -1.7994, 4.1763, -2.5371, -3.4838, 1.2812, -3.7818, -2.7524, 2.7243, 2.7209, -3.6661],
               [-0.7006, 0.3496, 3.1184, -3.7607, -2.3634, 3.8209, 4.359, -2.8435, 0.2021, 1.912, 2.4104, 4.2766, 2.8345, 2.9436, 0.6763, 2.8773, 3.2247, -3.4132, -3.7572, 1.2847, 2.3482, 1.8697, 1.769, -0.0089, 1.4496, -0.9332, 3.206, -3.9613, 0.9626, -2.8688, 2.2872, -2.8684, 0.8147, 1.2184, 3.1735, 4.2469, -4.3622, 3.8974, -2.1858, 4.1608, -3.8424, 1.9488, 1.5772, -3.8632, -1.1415, 3.6086, -3.6212, -2.9851, 0.9564, -3.0614, -2.0516, 4.224, 3.9425, 3.1629, -4.4976, 0.3236, 2.7067, -3.3867, 1.6681, -2.1078, -1.7738, 1.2179, -3.2065, 1.4856, 0.4369, -0.6737, 1.1383, 4.172, 2.7825, -4.1406, 1.1979, -1.6737, -0.7903, -0.8512, 1.3215, 0.0058, -4.3703, -3.4705, -1.9669, -4.36, 3.7227, 0.4186, 2.5605, -4.2418, 1.3228, -0.6666, 2.9135, 1.3758, -1.9081, -2.9498, -3.9588, -2.117, 2.0498, -0.8175, 3.2631, 3.9759, 0.9009, 2.0831, 2.6967, -1.1398],
               [1.261, 4.0312, 4.4114, 1.2777, -0.7015, -2.2098, 3.6801, -0.4721, 1.6525, -1.3993, -3.9219, -0.4842, 3.4042, 1.0264, -0.1209, 2.6877, -4.3192, 3.6067, -0.6477, 3.9492, -2.2852, 0.4957, -0.345, 2.3632, 1.4499, -0.7602, -0.4282, -0.8383, 0.2422, -0.6266, -1.537, -4.1967, -3.3763, 2.9097, -4.4733, 3.2807, 4.0733, 1.2792, -2.5417, 1.095, -3.4254, 0.6093, 2.2033, 0.3591, -0.3644, -2.2448, -2.5048, 4.2743, 2.8943, -1.4368, -3.0589, 2.2149, -3.1386, -2.2145, 0.0927, -1.2289, 3.8429, 1.3785, 3.5359, 4.0576, -1.3497, 4.4537, 1.0024, 3.6786, 0.5924, -3.044, -1.4781, -2.5868, -1.0708, 0.3193, -3.8062, 3.4699, -1.9117, -2.4862, 3.0535, -3.5644, 1.6924, -0.6269, -1.8252, 2.5988, -2.3832, 0.4977, 1.142, 2.2277, -0.5225, 0.2534, 2.1552, 1.7512, -0.7499, 1.0819, -1.833, -1.3466, 3.7047, 3.6751, -2.7652, -3.203, 3.986, -2.8394, -3.6461, 3.5073],
               [-2.9174, -1.2577, -4.1799, 2.3956, -2.603, 2.0617, -1.2921, -2.1059, 0.0469, 2.9356, 2.4707, -3.0415, -0.3434, -3.1867, 0.0125, 3.7911, 3.5561, 0.4857, 1.5588, -2.2439, -0.2552, 3.3499, 2.4469, -4.4351, 0.1538, 2.7341, -3.5437, 3.7685, 3.3531, 2.61, -3.8938, 0.3977, -1.9882, -4.0687, -0.5396, 2.3359, 2.7613, 1.455, 1.9315, 0.579, -2.5408, 0.3305, -3.3722, 3.0308, -4.2748, 3.7886, 0.2639, 0.1227, 2.2963, -3.4617, 3.894, 0.5806, -0.6406, -2.0121, -2.1044, -0.0335, -2.4601, 0.1835, 2.6159, 0.1059, -2.7909, -2.3116, -1.2738, -2.7932, 0.6243, 4.3048, -0.27, -1.5167, 2.6519, -0.432, -3.8487, 2.1356, -2.0404, 1.085, -0.5865, -4.4267, -2.937, -2.914, 2.723, -2.6291, -3.1733, -2.2084, 2.5717, 4.1306, 1.1309, 1.7713, -0.8133, 1.2258, 2.365, 1.193, -2.6973, 3.8517, -3.5605, -0.0951, 2.9175, -0.3771, 2.2965, 3.7049, 4.1693, -3.7207],
               [-1.272, -1.2908, 2.5871, 2.2427, -3.4242, 1.5541, 0.63, -3.9853, 3.9983, -2.1909, -1.0446, -2.0525, -1.586, -2.4737, 4.3507, 3.6069, -2.8087, -0.1313, 2.6503, 1.8742, 3.0376, -3.2768, -3.1247, -1.5345, 1.5006, 4.0204, -4.1686, -1.4531, -2.691, -2.6058, 0.0835, 2.5155, -3.0574, -2.2216, 3.8221, -0.6587, -3.8506, -4.425, -3.8871, 2.9889, -2.3006, 0.639, -1.1839, -2.1073, 2.7505, 4.2722, -2.4578, 0.8597, 1.0509, -3.7488, -2.3752, -3.8961, 2.3035, -3.8787, -0.9762, -0.4623, -3.1064, 3.7675, 0.2665, 3.2961, 1.9115, 3.1177, 1.7913, 1.538, -1.2999, 3.6531, 2.3036, -2.9227, -1.5483, -1.9276, -3.5894, -1.5293, 3.8709, -1.5846, -2.8026, 2.9904, -2.2787, -1.7402, 3.8472, -3.9476, -4.1313, 3.6784, 0.8315, 1.8571, 3.5454, 2.1008, -0.5954, 0.0573, -0.6569, -3.865, -0.7559, -3.5478, -3.5278, -1.7024, 0.9585, 3.4271, 3.9797, 2.4748, -0.9195, 1.4064]]

    matrices2D = np.array([[[0.9079958322029904, -0.41897919841204423],
                            [0.4189791984120443, 0.9079958322029903]],
                           [[-0.2279971790311659, -0.9736617925921869],
                            [0.9736617925921867, -0.2279971790311656]],
                           [[-0.9105415103824038, -0.4134176554896159],
                            [0.4134176554896158, -0.9105415103824039]],
                           [[-0.45644809956423943, 0.8897500392830533],
                            [-0.889750039283053, -0.4564480995642386]],
                           [[0.7352227537044771, -0.6778255693282792],
                            [-0.6778255693282791, -0.7352227537044771]],
                           [[-0.251430447996006, 0.9678753689502217],
                            [-0.9678753689502219, -0.25143044799600595]],
                           [[0.594440095381418, 0.8041398964128893],
                            [-0.8041398964128884, 0.5944400953814165]],
                           [[0.8427455714958442, 0.5383120858053841],
                            [0.538312085805384, -0.8427455714958442]],
                           [[-0.22448936352740992, 0.9744765393086993],
                            [-0.9744765393086988, -0.22448936352740892]],
                           [[0.9998551502802618, 0.01701994295041017],
                            [0.01701994295041006, -0.9998551502802618]]])


    matrices10D = np.array([[[-0.47031588774694832, -0.092072354237257445, -0.023597448319418235, 0.042628875898679384, 0.052401317447353712, -0.33180806063083962, 0.013222326944469799, 0.54147969165458343, 0.30894928800615451, 0.51602747073863808],
                             [-0.47704279096273, 0.14802789841440706, -0.25015375823092889, -0.44872482591012863, 0.57223927822778509, 0.088596286177392791, 0.22970787523790584, -0.15337148383547133, 0.062937220850603937, -0.26651517310780926],
                             [0.080375865413248593, 0.63849531046958652, 0.17990606402909881, -0.34831921021450218, -0.30670541515186711, 0.20931857476904248, 0.16920323616557989, 0.50082998948969393, -0.04429847715503879, -0.1134272836767866],
                             [-0.21721699212621107, 0.0034866093757975137, -0.043140236444892024, 0.62909610558586382, -0.079111047435440326, 0.20004510289388133, 0.68203016854022513, 0.074656110896313063, -0.028745912440021788, -0.19323565310144977],
                             [0.14929884709652122, 0.19428914977250364, -0.18734779983355715, -0.12674490538251376, -0.044546593721792649, 0.31342698138760189, 0.30782276870142394, -0.38260003352622801, 0.05789455049507599, 0.73762308678427446],
                             [-0.35478482349671714, 0.20541701684035504, 0.00022935461814912244, -0.1072414134740292, -0.48447386065674075, -0.58102994942802033, 0.12539325437958418, -0.40450870048026127, -0.26107429484172767, -0.024688795315858856],
                             [-0.26791560558613747, -0.42319434842881765, -0.44039479871570558, -0.2118363004077744, -0.39187415829863947, 0.39491258171627547, -0.11330347466847229, 0.19319318182140918, -0.38808195255385108, 0.0039226168182481865],
                             [-0.33044184042499392, -0.27734840043394449, 0.66074333526613582, -0.18657282707466782, -0.23341893814520898, 0.33944325963409244, 0.013485695256245447, -0.22668878925723387, 0.34659356236846695, -0.033045183453140684],
                             [-0.049687711514477095, -0.099697533611397118, 0.48681981257070905, -0.034665351520693138, 0.3477958254899417, -0.015299383091775556, 0.11892791084842019, 0.105466715577248, -0.7370112889353746, 0.2444332079853746],
                             [-0.40741597034292237, 0.4647820891978971, 0.0041074747632799278, 0.41387185324725212, 0.061306829522642825, 0.30162523172790939, -0.56180322328531584, -0.13049139057811535, -0.11121445641749632, 0.083229962303697169]],
                            [[0.15462011786650723, 0.20245680589006831, -0.4901663725879899, -0.13177124448494312, -0.31643019301442221, 0.40068998828031233, 0.52237726835921949, 0.1068423804510704, 0.163395905598921, 0.32527690776622309],
                             [-0.10324562551196616, 0.32130704877346278, 0.46244290069585581, -0.068531683587019485, 0.42194847436356908, 0.59565725821430704, -0.075436641920299211, -0.09957804266058741, 0.0074469521479487398, 0.34502475021382711],
                             [0.002448029330385073, 0.38346663652414803, 0.041310157991473237, 0.17405995698786636, 0.15612312152804506, -0.20217282635893977, 0.10572588262897836, -0.11864134951662053, 0.81793335522256183, -0.2478446319638466],
                             [-0.0063271111033532416, -0.012183225036428364, 0.60268139299159162, 0.081412145255018095, -0.12608276045464187, -0.17809198426038134, 0.69000275889493956, 0.28399639091666462, -0.13566343076968992, -0.084751381778141746],
                             [-0.35591231247614286, -0.26516105205915158, 0.24353264234199734, 0.061507488685539194, -0.58730642932169275, 0.3769911154340127, -0.27592336942870616, 0.22178678246402708, 0.33977570326379786, -0.11001349466528519],
                             [-0.70865168559760061, -0.0079260683987868539, -0.088232408656923472, 0.036145178187605619, -0.091476033702053289, -0.089046690834928013, 0.26914579882899881, -0.61968623888485619, -0.10582274375650462, 0.068646976762102435],
                             [0.0066118109170794645, 0.24554099180283667, 0.18144805573612455, -0.091128661548384948, -0.31968096797210677, -0.48816935441142678, -0.23939459420731338, 0.034883769537705278, 0.084067854347616239, 0.70166857012221107],
                             [-0.39299020688433095, 0.61967536058562933, -0.13606632936710564, -0.30677518365271134, -0.041901391970969495, -0.063810267727150136, -0.11860318351741023, 0.41387344603701598, -0.24445333476136155, -0.313038705619615],
                             [0.30394371569789608, 0.03746115443874961, 0.2351960687702393, -0.73192706486615211, -0.25398772879391085, 0.022123065278206771, -0.0042577677383275458, -0.42709919256482115, 0.040021564304703536, -0.25719193157463777],
                             [-0.29943170848425804, -0.43876355193217115, -0.084287369528648834, -0.5457037857986925, 0.39975243013214506, -0.13830128096572153, 0.11908715602696927, 0.30954314844683234, 0.30125443840523519, 0.18234038801055816]],
                            [[0.067409437608566103, 0.3496087420913811, 0.25288411635665459, -0.074903973276018845, 0.49747274500924771, 0.12661077430131604, -0.30160666364807537, 0.23460450107196928, -0.61771335229587243, 0.11217689769105252],
                             [-0.34702749815606709, -0.6604865466344999, -0.086691618131903944, 0.11063964410879004, 0.22155394557687166, -0.28027658989744875, -0.31511023783587289, -0.31909171258941732, -0.28641248933799462, 0.11307367071643608],
                             [0.23752728450732893, -0.093003425950267865, -0.20973946543333769, 0.45012400063512881, 0.45185134934610244, 0.5592840379479167, 0.00192759515480773, -0.27037757514765492, 0.15864433278748719, -0.27034208415901051],
                             [0.14155644242816853, -0.027789022266991883, 0.56846375413825934, -0.2433820368990692, 0.14595623654122888, 0.10337824080943625, -0.29299965761915553, -0.33837351079559447, 0.48139665018337863, 0.36431475066957142],
                             [0.054487845973773125, 0.0074797551960709818, 0.45858030005548622, 0.66994277790601964, 0.056156700372070927, -0.29323559605351723, 0.43757268413360134, 0.031177316763076113, -0.058248126516156094, 0.22995759962071058],
                             [-0.42169149857834942, 0.31075474859042723, -0.16392155852109844, -0.00028044567360223642, 0.54847992885068109, -0.39798338618143647, 0.0011652912985351126, 0.13794265693802094, 0.45103508355484362, -0.1305918110937225],
                             [0.5219531808803608, 0.23119713923923499, -0.50921556868904505, 0.094357297256815728, 0.030309789499779569, -0.3595592810249863, -0.1479402696961957, -0.22181526285158637, -0.011275056013415654, 0.45220785464763352],
                             [-0.49137008868562276, 0.10615861953982444, -0.23262648998846353, 0.18067253024263613, -0.11321254141224653, 0.44975803980888662, -0.00051679224942530297, 0.14155006140730078, 0.062243684431521597, 0.64924402138013659],
                             [-0.20394088847634609, 0.24602540472152262, -0.023792754393864107, -0.31473160607344935, 0.11540282196724422, 0.052347787962381209, 0.54213774528819769, -0.64929869110945182, -0.25589360634156888, 0.03486789474861262],
                             [-0.24961215426299288, 0.45851352455340194, 0.10121591062025674, 0.36176868465410589, -0.38330727979238932, -0.0569710180030433, -0.46541949499800245, -0.38041177479702332, -0.056381818586011177, -0.26769455851236212]],
                            [[0.24551340548173831, 0.40718396121725575, 0.1570125648744474, 0.116236903201947, -0.22443142152107298, 0.66659585466812687, -0.3017827980138521, -0.027504162542360461, -0.0040722383952735801, -0.3862576996970789],
                             [0.23673422035090816, 0.5010966445011622, 0.31135778250066976, 0.19257154072973917, 0.41222317341512726, -0.4979750253466948, 0.057105170599419705, 0.22289555839960887, 0.01348388574284789, -0.29630943041708213],
                             [-0.10130676069440882, 0.29333298134730496, -0.051640290180975483, -0.044513039214758909, 0.25279784251086207, 0.13832287978380164, 0.27930946690793534, -0.55510329683788073, 0.64514699181717583, 0.11677548670903591],
                             [0.052693136465976814, -0.18376007738519728, 0.27715661457561203, 0.00015355755002483722, 0.086792496060807398, -0.062253434688706179, -0.68039802915537728, 0.21872728189395985, 0.52089587404832449, 0.30514883863291076],
                             [-0.71411151199433431, 0.28473122748799062, -0.27417034741100121, -0.24065558815459523, 0.24339849813003672, -0.021155124998184657, -0.39172581842438448, 0.039571159971751708, -0.12916052003912537, -0.21095161378064273],
                             [-0.17318466258832407, 0.11429838932567619, 0.33236120799275826, 0.25690077583315618, -0.40103079805637409, -0.35373242663972138, -0.25681390349326738, -0.60640817509133182, -0.22902066186469128, 0.091618336524382518],
                             [-0.22176759262366247, -0.10205227215587957, -0.27071105698109288, 0.90708613742680644, 0.11900521455417148, 0.1105568243991811, 0.005736512723109953, 0.11101468989668571, 0.071050056955818605, 0.022899770068781678],
                             [-0.059178106970445656, 0.58930035176471451, -0.13022421295192196, 0.0028231665866021278, -0.35411367751067685, -0.006221922336659671, 0.11478339170003705, 0.34403468375487772, -0.01191183112577081, 0.61249044064532598],
                             [-0.49422963363130529, -0.10362464708725523, 0.48441475943000611, -0.00035004550004523406, -0.35431900404722683, 0.021065466657226896, 0.34625949148781421, 0.30470832282213089, 0.30549476626964311, -0.27979574674412172],
                             [-0.18370200622173494, -0.026976630163429566, 0.53701680051237677, 0.026405975610020362, 0.47232793859886324, 0.3825999018212195, 0.11047451312106139, -0.027418215992373474, -0.38026897193743064, 0.38652849916159765]],
                            [[-0.42345253859228815, -0.029683760615846676, -0.037210742291070222, 0.82914885033318475, -0.29864507984786398, -0.03854144621554937, 0.030711760887334325, -0.054546823383066677, -0.17705788507189332, -0.070653923506863253],
                             [-0.57619790505585589, -0.64941939035299245, 0.070965806400742987, -0.32337281252296979, -0.015553376635611047, 0.31322337629723446, -0.15813814422071421, 0.025593936651076007, -0.096826041553348272, -0.057057098840523846],
                             [-0.36845496526970661, 0.10712696140257542, 0.23418441559549791, 0.06890548276035395, 0.61843566205989919, -0.066304937423434435, 0.58555325893886512, 0.082004640903643719, 0.2203619574670253, -0.090325308357940892],
                             [-0.08535525166343412, 0.25618263597869817, -0.51294752426796486, -0.10367233543425224, 0.0077797710008756854, 0.36772305873060274, 0.27664787232315829, 0.46531565359742399, -0.45641114767283014, 0.1287525185255671],
                             [0.22059489615208616, -0.53419074419608603, -0.42734465889913031, 0.19763719802124691, 0.065753553397987441, -0.27208317507007407, 0.075948425657649171, 0.45474784911312827, 0.39117969960172916, 0.018870880252730274],
                             [0.23001612095199525, -0.22299657007572193, 0.41516881837697245, 0.11704590142444353, 0.30355242089638074, -0.28904579798081592, -0.14661135472959808, 0.32214962932100888, -0.63961227194186954, 0.035064883508962211],
                             [-0.09340011672983721, -0.13693189825095151, -0.26955326307114325, -0.28825772742101685, -0.20999519127120717, -0.59378619424587287, 0.41101530931749386, -0.35185493320719169, -0.32446370730052304, -0.1486014592162298],
                             [-0.30767769381999566, 0.14175208301733436, -0.36719023404878698, 0.015362639348878042, 0.43808740262651003, -0.28911748561296685, -0.4608053965729757, -0.19472230320376585, -0.023542804806863743, 0.47313207422045583],
                             [-0.36244019080064621, 0.29232880378149384, 0.25603885183482628, -0.23433535248135928, -0.39497197693338415, -0.39831033871123378, -0.10887191094774536, 0.53438906946515585, 0.18475314693595349, 0.12845054750254004],
                             [0.096528649929753713, -0.20218865493375085, 0.21815036858885861, 0.038006562763641678, -0.19888941283373557, 0.091598375753396744, 0.36640292995239809, -0.12353072070239088, 0.01773676624973659, 0.838448021966955]],
                            [[0.30134730981827973, 0.13256712987931557, -0.020170864251898648, -0.10573264992713535, -0.83081306697918855, 0.14198201799301316, 0.33996965211534086, -0.084302722189616833, -0.17927985675039884, -0.12162512838382156],
                             [-0.15425283912296231, 0.27955106732843588, 0.24709001077660575, 0.22263887357088227, -0.17524810112083231, 0.27095498012446262, 0.12781479353263342, 0.26047575973580994, 0.65307647547918368, 0.41546852714349819],
                             [0.048497518978954608, -0.2013429903461082, -0.24553689024535794, -0.16460551256203404, 0.15779315653543646, -0.10880867830679397, 0.50683423845142217, -0.63487193951480758, 0.31621859988494905, 0.27027784808746536],
                             [0.21740354703513678, 0.19055923175333539, -0.15530330495632283, 0.15071726914689917, 0.13633317387240595, -0.61075503527896591, 0.4649727284878219, 0.46228090833768976, 0.11176621086758823, -0.18863895520624052],
                             [0.27546865707252216, 0.3233908671279172, 0.26271784594455827, 0.22059983274155326, -0.13368407246523342, -0.53278950536734937, -0.39011691404420501, -0.37691321086546464, -0.041412590010581396, 0.32271434307358909],
                             [0.25544474578884396, 0.16512058517042424, 0.59283494621612076, -0.64042565131191542, 0.27082227466426045, 0.058057207957298615, 0.18668566533085976, 0.10003845236877253, -0.11270744510999263, 0.10773738563182098],
                             [0.62710082228290176, 0.1364491905128378, -0.4590525826389048, 0.06734629576262155, 0.22331288852276371, 0.35231380182671501, -0.10946543522005149, 0.16759219819699667, -0.13071746592077632, 0.37644499794918873],
                             [0.11578532193620134, 0.46751254834066525, -0.23238345080819089, -0.30244315644364089, 0.053065488990405252, 0.074378128009605984, -0.28295867110919848, -0.18830822756525215, 0.46834675903316508, -0.52851632747674626],
                             [0.52293420344049668, -0.62986452509821977, 0.27552813212110083, 0.13226817568557972, -0.054292042718284965, 0.00089264652134974406, -0.15959264075368132, 0.051637981495787036, 0.38818319329008694, -0.23372841208675338],
                             [0.12051010947237638, 0.24832074268894933, 0.30497729152856162, 0.56314324193223064, 0.2978321378775759, 0.32352781888409582, 0.30073673600145701, -0.29999089444377991, -0.16529989834610689, -0.3354657262902917]],
                            [[0.16738740727824683, -0.017737165465256846, 0.3346213264758624, -0.043905233920894668, 0.11000350182209916, -0.22579535023193481, 0.2710802887258108, 0.7651043565991702, -0.30048952524955491, -0.21335482732041056],
                             [0.54000640404271072, -0.21258356670655992, 0.092105837731584969, -0.082976649361959198, 0.054005595831386657, 0.35507734888069026, -0.43813154916884067, 0.17199453805987747, 0.44619331848472282, -0.31337887619691041],
                             [0.043821713483735751, -0.47355014849927163, 0.10601217324974892, -0.21017644788368883, 7.4220107265980865e-05, 0.56731890298725984, 0.25110646773798501, -0.23115224634533243, -0.52094103385888946, -0.093279531934529744],
                             [-0.56772066327472681, 0.20409886183991124, -0.19228046014166406, -0.018699648573379107, -0.21947143823288337, 0.38332830974874288, 0.13418646872093262, 0.24105677910908979, 0.20587924299840085, -0.53395365321610433],
                             [0.34157920189033658, 0.10566413330823057, 0.25206607909430578, 0.13069036995123395, -0.37922133906762889, 0.00024692860242887934, 0.67528142401888669, -0.22995688099151293, 0.36868173889152389, -0.054047945657892622],
                             [-0.20789137617384496, -0.048323999906957266, 0.33483388445561396, 0.23121361235544283, 0.76559994149711685, -0.033950567254295697, 0.15388901714855591, -0.25861729548945039, 0.20095056351140769, -0.26576441915613397],
                             [0.087071953639212843, 0.67720473558940553, 0.30726118798119395, 0.073552515037015875, 0.12645081878900255, 0.52375595429982347, -0.082032191033620735, 0.072013867046892305, -0.13672535698421409, 0.33626418332113822],
                             [0.24849417891703665, 0.039350717220499126, -0.32436354887154434, 0.81725806025858583, -0.032103412374286287, 0.061269540507683726, -0.041760700254317371, -0.017718049257782472, -0.31266628347126124, -0.24285188767919741],
                             [-0.22440028507387544, -0.43941242156454152, -0.020415432208215584, 0.36230389739034879, 0.03024750528511724, 0.25441638962628993, 0.13683336102744018, 0.36780580351323472, 0.31055740102828649, 0.5556863718763343],
                             [-0.27670543893615174, -0.14781544056376622, 0.67501536911084836, 0.2674674916072321, -0.43465786871750944, -0.10094824329507536, -0.38289988220696025, -0.11379526611160029, -0.087432621692697998, -0.08986618724297514]],
                            [[-0.28512253413751137, -0.42833697398683229, 0.019214225603995154, -0.093024949909427557, -0.092554733656165775, -0.5635506807045173, -0.31788941867306614, -0.026879612183032271, -0.54044235947747921, 0.078739196426628452],
                             [0.52633116689475146, -0.22763744203024611, -0.30822688265313641, -0.29291059427425858, 0.25195958168378008, 0.017623304710972836, -0.3042343875526094, -0.56216751377949747, 0.10050876386417319, 0.088708347463628753],
                             [0.48661851325975536, -0.4721627791166183, 0.3064301999371678, 0.27300161119360661, 0.12768033686713257, -0.35736281662824682, 0.33635428618084218, 0.24748545980459688, 0.22777550518296008, 0.039496770534456514],
                             [-0.0031377050165521361, -0.031689043101475488, -0.13650078580536495, -0.14879232069974105, -0.44265341095288752, -0.031812006821521271, -0.14198506768912014, 0.22032927858080709, 0.33974879054507806, 0.75968829331518639],
                             [0.3544968669825409, 0.23329752800406281, 0.054057993009673656, -0.3528431062636489, -0.22498278332019983, -0.0022166089807701232, 0.54065922751854101, -0.071050703323748174, -0.55515126269090387, 0.19054662716462314],
                             [0.14806731391529415, 0.42260585268459089, 0.49940432500247417, -0.36995311037527634, 0.38595805165242442, -0.20332406952660037, -0.37254023878510739, 0.27440094346416372, 0.032610193799520355, 0.088094002106827912],
                             [-0.0025655349776224435, 0.52237752692474204, -0.32361408691550492, 0.29950715740336525, 0.048298478227756993, -0.66186784353269679, 0.12817639471801373, -0.2271561943414433, 0.14878104216222374, 0.046019715438670596],
                             [0.44788373895825112, 0.10942897072030695, -0.27299318182644994, 0.03165522209303126, -0.45655136068510294, -0.057722701903742582, -0.35148862723650914, 0.40634391572699968, -0.079256078756699655, -0.45297451598412297],
                             [-0.23553044534575954, -0.14948375248302959, -0.27585152054728385, -0.6643377942396671, 0.060875454673608102, -0.23059183275907619, 0.31713533676255296, 0.19709883837394473, 0.33591439194113576, -0.30919505797052838],
                             [-0.034644569763000427, 0.023343745297503583, 0.53331295501216669, -0.12436177568601176, -0.5492240894887499, -0.13213904178909766, -0.038038069999130911, -0.48738463486656736, 0.28283735712210878, -0.24550109899764608]],
                            [[-0.38058223686619563, 0.27679773350908216, 0.027116745268914617, 0.52230766157830244, 0.39512569554916382, -0.23897177985595772, -0.16543096641560323, 0.35683119205673097, 0.29636016469363219, 0.22190648063313639],
                             [-0.56432004926607438, -0.032008978561524272, -0.40476111834735767, 0.14486406854965869, -0.39790817119377775, -0.15158384173112052, 0.25757666446364602, -0.36135758353585756, 0.24979839976064519, -0.23466633855414396],
                             [0.057338965874305668, -0.32524558319757174, -0.28047868624468691, -0.21059400402906836, -0.03823525080340133, 0.37974912276854678, 0.24957611849243821, 0.4383500253752074, 0.54728616647682093, 0.2612986094486997],
                             [-0.32349249986235734, -0.099709044982022571, 0.699178085965524, -0.26442326350741574, -0.15470200787734917, -0.1995290319597228, 0.30010910912584143, -0.088688726351434238, 0.10580444727362845, 0.39213614503403998],
                             [-0.16782510448624982, 0.21200269402568067, 0.28514363707868373, -0.18771023575789333, 0.0734441965016632, 0.10141330239809242, 0.24188949683510072, 0.42218303931855033, 0.059280669167662212, -0.74458418775036717],
                             [-0.23205162727393835, -0.70745331939991196, -0.040657013867667298, -0.078175332905241229, 0.59516636388842337, -0.14308442378967326, -0.00012480282460361242, -0.12075376633768647, -0.12156867838374816, -0.18395891780024981],
                             [-0.27536920377226964, -0.35653898385191785, 0.24322682552464736, 0.41880390188106659, -0.3678765046918232, 0.48642915129607528, -0.29044876256671898, 0.1882749650464392, -0.26421120900977796, -0.03055825062053133],
                             [0.35262885360071677, -0.35871341056525785, 0.089702695657598266, 0.1604747995384363, -0.37251572422456569, -0.62679747342059566, -0.16073161718358434, 0.27334398143085215, 0.21167007812031491, -0.19021041347510112],
                             [-0.19267252112625557, 0.014250788626542084, -0.32638563286749261, -0.13282297634383605, -0.12502987627240111, -0.26442852362126618, 0.27735724442028215, 0.47978107285546678, -0.63057324807892112, 0.21956829479334217],
                             [-0.33083781209551283, 0.072097660633557464, -0.10593158037059515, -0.57602281520549703, -0.10392073039230812, -0.075663401087650198, -0.71295190528270558, 0.094347755549232609, 0.092342491564854537, 0.0084239907822972748]],
                            [[-0.2190635423081097, -0.10000062264387033, -0.37979027330808585, 0.07948842576952253, -0.51447544845756688, 0.015306315119133329, -0.32567465109513782, -0.30555927115039083, -0.34186266664812026, -0.45851082716083474],
                             [-0.27253911575183953, -0.31267721734435422, -0.37890066256004057, 0.19755759728905697, 0.11785004204959182, -0.15448403224775631, -0.30066667160463872, -0.1773182224980186, 0.64740046570356136, 0.25814174543545043],
                             [0.046891574764025633, -0.88309841114656984, -0.062715817573839872, -0.17011308906153022, -0.018116124716922928, 0.076505449053435592, 0.37232371206756443, 0.11546437220609972, -0.16406044989391375, -0.0035444120531551823],
                             [-0.53445531207998498, 0.060156660422328957, 0.056228166986158158, -0.69301939857543116, 0.23238844062824582, -0.38047534781690895, -0.02737886456952315, -0.11174738797189451, -0.12307672225966729, -0.012262295542702873],
                             [-0.12134658190518345, -0.28339646980228828, 0.81144522756496629, 0.2307367521570319, -0.094930127230377609, -0.13028287719461956, -0.32032098822908556, -0.25390902178439539, -0.01453010894630447, -0.0026141488005894517],
                             [-0.72506107843545364, 0.065890439044149346, 0.061798320611850158, 0.39029505123094743, 0.17004390686880194, 0.36368601075562312, 0.27167744103843666, 0.23672153683211331, -0.053201602305372041, -0.14119861895577579],
                             [-0.037342960126972219, 0.093939071344502786, 0.1168284310512924, 0.043917266113579906, -0.42943409082660383, -0.43874469358767776, 0.52085665455873986, 0.032777277892312058, 0.44900226571498864, -0.35117483104904756],
                             [-0.02055245568956586, -0.082891735306264827, -0.0373102809330354, 0.12753231125281747, -0.05373067817760107, -0.42105665124812669, -0.36383327272950194, 0.80201427722756247, -0.12816919732879176, -0.053342530899171209],
                             [-0.14977209488972676, 0.03139108831536782, 0.14001505023498592, -0.40867878031910565, -0.57477076273063799, 0.46708794479723992, -0.15658937270485068, 0.26732820728816065, 0.26662010307225448, 0.27268461655944748],
                             [-0.15876130985424722, 0.086111017153795225, -0.090505316140179384, 0.23378836172769105, -0.33392377282887564, -0.29679610184551519, 0.24404983378570319, -0.1144542757534544, -0.36025081776487544, 0.70887076568923924]]])

    matrices30D = np.array([[[0.12196656460050932, 0.22240008853568435, -0.047139163827991985, 0.2075256149386962, -0.12211608980308397, 0.016629239102338485, -0.088280714106657124, -0.10347516791542632, -0.042781731964817049, -0.18215201347918922, 0.32432519316820224, 0.33725113860461309, -0.25948416912549832, -0.037163714827876865, 0.087835482942231313, -0.016448901000300279, 0.054153688910130914, 0.073696854845712534, 0.01010418756410268, 0.11640202955250227, 0.21388946474056578, -0.092679219852710146, 0.46152566393900241, -0.051750197797856973, -0.14475728104361038, 0.1299653924866416, -0.044110453268434956, -0.39129318149328562, -0.0019878979780958857, -0.20274874318401279],
                             [0.20312247729069255, -0.2374922363145448, -0.069756457735382776, -0.19710581312611947, -0.11433112820408835, 0.16478869428756138, 0.088545473327435523, -0.040556674330971078, 0.20803875234524644, 0.12636990375041621, -0.13490187885880292, -0.13142793585304763, -0.2685085778531841, 0.099626214703399427, 0.24648914973781613, 0.021153144262310537, -0.11873510184804642, 0.13119996195999256, -0.014615025473730272, -0.1183197136655461, 0.10799462938410774, -0.14807978146931591, 0.14455688936228675, 0.3440507626433103, -0.024711052856176113, 0.46816668085144458, -0.032804745721040411, -0.012078117681343925, 0.21021524550841889, 0.29559470006119393],
                             [0.045851406899915917, -0.24384189799900111, 0.14631804896836817, 0.086347769674960911, -0.21429972512980811, 0.35747031249161054, -0.22614732766686513, 0.24831049057918619, 0.10094885853563197, -0.42846543132043746, -0.050496677235314515, 0.069415315051842272, 0.25651872402866682, 0.093719828398579633, 0.074379031611986571, 0.069330764202830866, 0.14807895450754049, -0.08947779019808122, 0.18780516009152873, 0.18078971393210991, -0.020154306394491499, -0.11897483291157161, -0.218752813769447, -0.19681970314715949, -0.27546724346592216, 0.20238007861367441, 0.1204084545426161, 0.0062281067764988372, 0.079303520578547143, 0.017044775391173612],
                             [0.44219358622385752, 0.001902360666772808, -0.31873440914978801, -0.031983382884790648, -0.067470408820968941, 0.15157375169257953, -0.074531110686363353, 0.20544087508948222, -0.18442360378208603, 0.2136028941097684, -0.13068257571636613, 0.066961308082172599, -0.012652997550165114, 0.32516894825236003, -0.18980599473352525, -0.2410128945458157, 0.038989876193545853, 0.086512972533076826, -0.069118553579740477, 0.084874328236580365, 0.077713466511481075, -0.19957805370315784, -0.12216312302123873, 0.073231434927288133, 0.14626567396935958, -0.19051229602553751, 0.36240200046155618, -0.11262382725904881, -0.0018856143585279954, -0.19103875842295195],
                             [-0.12354097938243909, -0.0055459027557872975, -0.13887501678389841, 0.014217347105627701, 0.18844222909247726, 0.075141142474463643, 0.0071789023966166128, 0.50857683949555132, -0.23242534307385704, -0.056742206563174018, -0.14778338810625716, 0.15117834042097456, 0.056842972685338278, -0.079413270597544883, 0.15660665490040859, -0.12965349829525563, -0.037111729559125207, 0.47045011411917131, 0.029185145398279176, -0.033691924362025651, -0.24515132807009818, 0.046137362861819624, 0.13211996511368326, 0.16451074669718851, -0.11369530925284815, 0.034770046574130971, -0.35131769090787296, 0.10956661519945103, -0.00023018156602361783, -0.17762644498881947],
                             [-0.21055613755129543, 0.013850095894921425, 0.10331702364184064, -0.03070110039154017, -0.093319825407063253, 0.32957422364963479, 0.2821164733334342, -0.028168279759042968, 0.20458332758052086, 0.13715291140920979, 0.15052372032756514, -0.14148383230226674, 0.099649650963152231, -0.070614937503387848, -0.25463557998871722, 0.26251354618923256, 0.072745922752734213, 0.20549005543799204, 0.011562685859479718, 0.16511710992465467, -0.021768584146260428, 0.036517647977685558, -0.1736813395746038, 0.36955808467402246, 0.039350671774079901, 0.076772442644708366, 0.019606770238735843, -0.29378512296141468, -0.17758375618251715, -0.3535576890177326],
                             [-0.18197164613966177, -0.020979208417848345, 0.07036126626492227, -0.26139773309009234, -0.018029638143262368, 0.14649237093293396, -0.11489321330674522, 0.041126583729248128, 0.069933288253342274, -0.063323730690709706, 0.38082141081471738, 0.17259828913683778, -0.13706283098040606, 0.35846131970066514, -0.17478909367772058, -0.2159550847694692, 0.18920863861872933, -0.16590358247508363, -0.26023631917704354, -0.11875545354752559, 0.10818086683841448, 0.13214039711446621, -0.062716197277727218, 0.26304868668580217, -0.18749695467901203, -0.17017675480441669, -0.20621307561989094, 0.23697405766170418, 0.19478416327588718, -0.011272735850117213],
                             [0.011749347238227676, -0.01102685543626717, 0.22278442504415724, 0.19494765795516805, -0.19153673431426133, 0.30662896414211893, -0.11081003184004511, -0.062988744449815975, 0.12367989276920857, 0.23550554072680235, -0.26716148362384828, 0.33424405697888165, 0.3047271694245019, -0.23556743600699101, 0.06426224898014353, -0.085987982874422969, 0.001852597718893223, -0.11082504884932544, -0.2463104879140128, -0.14258725713603612, 0.18004401156842223, 0.080473175190631852, 0.27733635713894572, 0.10005499707837677, 0.20951871069172104, -0.012423767071040065, 0.036328428544511494, 0.26689062469290464, -0.055419393742617069, -0.11243965284904896],
                             [-0.085167759987843761, -0.12285351258653497, 0.13979155188501688, 0.064628995614785259, 0.13230088671943727, -0.36617532225429011, -0.17017528024315082, 0.19501213186979344, 0.0070284777902595236, -0.20570274690739621, -0.080060523076396703, -0.024982906530898352, 0.089265533324884849, -0.056954083459511341, -0.074366637408554273, 0.041327542130312096, -0.057982821146091261, -0.16379247827152232, 0.25703712850206262, 0.055309311376543602, 0.39540452488033856, -0.3303911517355182, 0.051332190357166151, 0.50953945849047122, 0.13899623696329846, -0.13542045619799151, -0.017378560588825441, -0.013485103504963182, -0.016706732387725017, -0.044754777949573422],
                             [0.28194517381171391, 0.14480485901980364, 0.0026604153898058514, -0.027393869135284157, 0.064624642535338728, -0.041898543392076951, -0.0593863555475206, -0.16563965948011608, -0.093914470824437823, -0.18748690907743448, 0.080408983945647952, -0.18442243643712575, 0.27413699438171701, 0.028582037235385604, 0.02665356973118151, -0.15048539690289472, 0.10286900780908895, 0.32525133120382033, 0.082131617378694052, -0.26579824646920275, 0.44973984003624162, 0.36315238529420441, -0.16694889390605802, 0.052748413802696598, -0.087763941045129398, 0.17440609222944159, -0.027735739247530644, 0.061559037056067085, -0.27636730544590898, 0.022152970091056542],
                             [0.14261419566096631, -0.17054530629867667, 0.10097094433258359, -0.0018005004785768912, -0.29957109815674465, -0.24133782028386477, 0.33293571077322431, -0.15083228207315202, -0.11233930188327614, 0.017647065675499309, 0.152080653417344, 0.34405077400524664, -0.060759198236583198, -0.033594300084349646, -0.047785933413232687, -0.083455143169272036, -0.33094783030471053, 0.027919192503106299, 0.17275126615185263, -0.078141802671644223, -0.068045350844036318, -0.16877611881493651, -0.25786360546267162, 0.0062129555334304457, -0.15421848902830762, 0.13869791364205886, -0.011107291380276666, 0.33573032208352749, -0.08910932319351636, -0.28388770780656408],
                             [-0.28728664534727688, 0.099165796505582424, -0.4958270198852795, 0.16901864612555531, -0.22832032422464835, -0.24045507050474882, -0.14486563616641998, -0.052756193637132187, 0.071998013487132001, -0.12262568206800185, -0.14251906169240539, -0.078676189640324176, 0.029315385058959625, 0.055989952851898186, -0.030532033506176229, -0.13617955830346651, 0.063300346863276707, -0.22949332996183933, -0.076162335178774299, 0.021005810412706927, -0.19029651733618969, 0.21693493974304204, 0.033547166919238203, 0.24034723598248237, -0.068406143083537083, 0.35976401900069349, 0.21129047574429013, 0.091719516616350708, -0.094822374102829537, -0.16754162653544005],
                             [-0.27518666218271964, -0.12814996512124935, 0.15466604613319238, 0.037599811138179416, 0.03535190910229586, 0.045396098426377866, -0.177375192234488, -0.17377216914990098, 0.016078525192235519, 0.0073667799192256691, 0.010031390528623474, 0.24796087786635596, -0.19232753072464281, 0.14445310170737438, -0.0013301072924088275, -0.21348184551370791, 0.10910013583829199, 0.2949328509364757, 0.11607347210740578, 0.051068949004067082, -0.17533450805819112, -0.12385814837636561, -0.0070025020244956103, 0.079997074244871735, 0.090305721090365554, -0.02992930064529176, 0.2286766254302646, 0.0038309006057968796, -0.53463205447386986, 0.37084161112484071],
                             [0.025704135172445373, 0.15433593592869796, 0.086504393223026374, 0.43947762175991933, -0.16333856255431792, 0.038155340907980145, 0.24116859637270102, 0.016330114026871703, -0.11187482501952775, -0.086707278625129294, 0.12748853194424625, -0.078350467509366792, 0.27238926592747964, 0.33431921645396739, -0.031870508096332816, -0.051320647372548232, 0.018535186230780033, -0.076286415046210476, 0.053135034172137753, -0.43212837747464661, -0.26804979225678871, -0.17880057564809798, 0.042930279409609862, 0.12905155350485875, 0.16291823421845664, -0.0085326070008053655, -0.14607095015119978, -0.18544619719119959, 0.084611408356620899, 0.22079506166616636],
                             [0.079507087664547629, 0.12309451265817935, -0.16372661486844764, 0.16184560020822286, -0.34556415425375925, -0.081857271349048008, -0.23105081965689955, -0.025668381931373895, 0.45797946435467896, 0.04264452941426039, -0.12018801078116689, -0.12461276098783788, -0.073197964232888824, -0.067617884663873418, 0.066705632954359162, -0.06676136898952964, -0.12086728919718009, 0.16518894609707271, -0.14105010753230235, 0.0046937758042929455, 0.02654114329514216, -0.19314183650275948, -0.23335356284993619, -0.03074029456330175, -0.18484244662036375, -0.33766101695498718, -0.39423028532078858, -0.058286101049987708, -0.14574203048166673, 0.039186797678792615],
                             [0.17711654161148918, 0.23310305810417969, -0.20926091917603495, 0.12053583437745755, 0.31629597957903349, 0.04520670728235137, 0.19483200947712598, -0.35544914598185939, 0.062999493889726713, -0.10471342097984428, -0.12636133729944338, 0.30113001302986975, 0.19521174385428824, 0.092772837478746109, 0.042928905908040764, 0.1514178225750013, 0.16401545765174733, 0.022121716526865249, -0.024370919444360577, 0.42557354389692587, -0.049553587508593136, -0.10299472850880151, -0.12325385022999566, 0.20943804319514972, -0.049478157478847949, -0.0067508336723117015, -0.14911219528424699, 0.20576578343940291, 0.11997519614839465, 0.18395672951934083],
                             [0.19485423581506794, -0.2947431092710604, 0.058902888439411265, -0.18531397368841326, 0.17186115996745319, -0.21053776416580469, 0.15209743266499984, 0.0064238272568086325, 0.17263174536749296, -0.077902309215628365, 0.17523785107597067, -0.083858973354600214, 0.3303045758999667, -0.10738699180945377, 0.11493808915956776, -0.36191894066488989, 0.12671735770507725, -0.11688468160761954, -0.4034117182543559, 0.12501097504785, -0.19254413065004278, -0.18924344730616563, 0.12312698130127776, -0.02129617046264988, -0.012891401713539957, 0.10468510901477693, -0.061798944443755201, -0.19261168208975124, -0.21871163691579823, -0.073508022340936605],
                             [-0.11662754744570289, 0.21480035428025199, -0.049591791080667309, -0.53996350474517307, -0.2590759869406592, -0.042248209941740708, 0.058618855765092147, -0.064284828437353628, 0.077115262372809135, 0.032838033305967192, -0.10886710855845692, 0.22663159992007978, 0.2626072900205198, 0.06577680452215369, 0.30241600054727952, -0.17788746895084281, 0.016665454486824809, -0.080662009111846608, 0.39803446920884378, 0.015285743685341236, -0.044114009827855155, 0.10638967850183623, 0.0026413969289684038, 0.016261463028258271, 0.14756144283955622, -0.13130015953132626, -0.060727950211963685, -0.27392985682875004, 0.080075306950552316, 0.00052902660942694601],
                             [0.23780463301113144, 0.087137355163180913, -0.091736509819848072, -0.072513720697401932, -0.012227010716291658, 0.10302655930937135, 0.065580964919097082, 0.075896525424713326, 0.14510318376008141, -0.37859606109309352, 0.050682885934495464, 0.12140231356316217, -0.27550680335793226, -0.54127426432399073, -0.14756754636828301, -0.097732107280407016, 0.23978267248055615, -0.028989720531720768, 0.049914565785192842, -0.25350713549919601, -0.20531396146395287, 0.032204817741985706, -0.16992790689461665, 0.13610693068399835, 0.27225999174910087, -0.073130390050370045, 0.10097564830617151, 0.01887528118600915, 0.08595437883513779, 0.079694625566804053],
                             [0.062966178140447665, -0.26531992383536479, -0.066393559349741629, -0.037813724442575136, -0.20701496466487992, -0.17228494212142323, 0.14278347153660043, 0.068788142935701804, -0.19139663293652923, 0.13079801029028054, -0.27001127198033842, 0.23250110818869221, 0.04812279205062503, -0.12006055280370483, -0.44657171235966864, 0.10959474247856496, 0.22644791464878494, -0.06603038771659106, -0.02526517311253286, -0.021291634015751265, 0.078118668030215749, 0.19187051909973174, 0.067440340455750258, 0.019615441569441786, -0.30929743782347147, -0.013430723368363441, -0.17961166461933126, -0.27413868473134578, -0.056561119734014891, 0.31974703761681789],
                             [-0.25218204679562517, -0.0329917566014062, -0.31492874315539354, -0.00068644580884740587, 0.35631169316587002, 0.16542807166761425, -0.076305875484643279, -0.10910111390564094, 0.0024140913357511636, 0.22376561266863254, 0.059670731764070506, 0.1794093857222285, 0.12254134801658784, -0.19964001594677197, 0.061605116977837354, -0.022764570072252802, 0.0043050777284180707, -0.11804495591753814, 0.052143683483382511, -0.43143258933415152, 0.14611724791787131, -0.33947213644294011, -0.23176681313506811, -0.081349880779744907, -0.27234947990746677, 0.081153541011912841, 0.069621825928279646, -0.17858940015547858, 0.024148713593261754, -0.035465934825899575],
                             [-0.097955647494705325, -0.092303271216133478, -0.09628448779249775, -0.071734561972557037, -0.16718067153007132, 0.13844116923535588, -0.24136152548135328, -0.30060199074120231, -0.33181479225577454, 0.056554535219748833, 0.05645478602071944, -0.22499416858249996, 0.045076164202787594, -0.15000760543476116, -0.25937996548450198, -0.21161413521673406, 0.16699303345049382, 0.05397222158031513, 0.1318221814211098, 0.16216585986896953, 0.010506550994345089, -0.27396009784509623, 0.018216678412580383, -0.11667036360020372, 0.28742292696708749, 0.20413657904545601, -0.39020712871252616, 0.10499687615551194, 0.11880544882371503, -0.052603168311432781],
                             [0.0063557100539725665, 0.46880460406826041, 0.15097779183265311, -0.12045737586987301, -0.044758730665483172, -0.007980856950684543, -0.16738285230077796, 0.21782545870319758, -0.065351432797289, 0.11340696789435921, 0.18613524426548747, 0.027938798557037552, 0.18421640764770061, -0.21793245060261929, -0.25422914739599228, -0.13004997293408535, -0.39838244134464579, 0.012765568824092232, -0.13946874837321993, 0.18290365964872293, -0.053373241740404961, -0.0800456360516133, -0.07887345846078303, 0.089424746321557266, -0.12602700488613963, 0.23779067113394289, 0.135889929869873, -0.025413005009965482, 0.069343880864805779, 0.34382079298343787],
                             [-0.03431018707977658, 0.14665376165216173, 0.1319890589713035, -0.073864322742552752, -0.11729497751414909, -0.31612366501159189, -0.019913861052548599, -0.0010424216830991883, 0.18352123084749677, 0.17175031483964168, 0.030627617390710325, -0.072315774255740151, 0.13949705930254511, -0.024144667600908828, -0.0791262167862819, 0.093626165072384443, 0.47361360624721127, 0.3791190206266935, 0.053608550175148456, -0.118929921469465, -0.075337487873074718, -0.24378731059312361, 0.18505392684822669, -0.066344925962066023, -0.18926695748337391, -0.0061265768504607529, 0.28096429287581109, 0.21316582680562277, 0.28686340259000909, -0.067741036243520833],
                             [0.22865897988581541, 0.22124677743520235, 0.23607732227967906, 0.061561815766692826, 0.18552791902455626, 0.14128102428048767, 0.012639910853143858, 0.016204892217435644, 0.088645439139764637, 0.23400108636096931, -0.15870602045462559, -0.19526870452787956, -0.18257266714195164, -0.0061435739136589257, -0.07415968883519361, -0.27587442150165975, 0.15129795191632137, -0.3362238945072018, 0.40240594087902265, 0.015868781181713983, -0.17040209541630805, 0.0072313599280367739, 0.12875829100835701, 0.086000008313329115, -0.33929054699237043, 0.047884651023787139, -0.11410982422662147, 0.081554189112118466, -0.1955941724045715, -0.13040846842784423],
                             [-0.042341358094621896, 0.047980763500579601, -0.22067704631061485, -0.2783228697702323, 0.017503402678955983, 0.21247745600116094, 0.16146995081553245, -0.09707259139861274, 0.12005628265231776, -0.35673010194504223, -0.1157560477036382, -0.11407993158881677, 0.11752377400029172, 0.078075318430960272, -0.34486158201757638, 0.087401848282892852, -0.28492404179929759, 0.032031929254196082, 0.045766481599655941, -0.13868804034469787, 0.0071861058335837393, -0.19145693395174798, 0.45363573984395211, -0.11332517883669613, -0.1205686578389577, -0.16038281119223874, 0.055832769371706482, 0.18604237596863102, -0.19317640700306235, 0.0075457202291270616],
                             [-0.25378848934588827, 0.18023357119000002, -0.10743585162428033, 0.077436101397578214, -0.13791076622504195, 0.060362861568364526, 0.5250343009409002, 0.31909056165405825, 0.00059804103949513698, 0.01144100366241305, 0.0026931683470915275, -0.084902991350948184, -0.12330106982045058, -0.049067161307775907, 0.12015410649151233, -0.21694262345790061, 0.2206879196389904, -0.085462273954546239, -0.042107790678717505, 0.15887467032645494, 0.41035499928064528, -0.15670474200723597, -0.046321723074828056, -0.19858301106288861, 0.067429371156400769, 0.051421332800379416, 0.0057581131241587454, 0.16606207465874445, -0.13787274750370709, 0.16615498220194336],
                             [0.035851262625071996, -0.18293582464843988, -0.18168621937482185, 0.089584096803919308, -0.19852638564439029, 0.15569394565435188, 0.03668355229736258, -0.096908119522432279, -0.28043212358377884, 0.082989670395917786, 0.31872525385211964, -0.22746723114428552, 0.12279248049092141, -0.28285173840305272, 0.2895471366603975, -0.018176354677597376, -0.010969660001331358, -0.025449617028991494, 0.1045486700698805, 0.13034583107467398, -0.053525498764225701, 0.064878506393278634, 0.14014854431650844, 0.26809590707275927, -0.26745757589282965, -0.38965756032925664, 0.19512538914739777, 0.11168650416777767, 0.018742652155553874, 0.17369747494116144],
                             [0.067341095602340237, 0.2603797692371187, 0.11780529099502314, -0.27928694317262209, -0.16081844946396959, 0.010028704863031401, -0.093684281774691278, -0.0023680292796075713, -0.40056089750936624, -0.084331577491641788, -0.14176143656955123, -0.045203399970259107, -0.096113261774299102, 0.010305145292250276, 0.24125537425150129, 0.39129241314798718, 0.1937506432050585, -0.16489846825237603, -0.30583140493813021, -0.12793766248746261, -0.081474238849671074, -0.26189084628873205, -0.086469576531397807, 0.11628650090842733, -0.074732905346695605, 0.036307245094495184, -0.045901339556901039, 0.038582852978675398, -0.32325572307619127, -0.069535854058934268],
                             [0.19717945058818589, -0.047783804632636796, -0.27838372902105124, -0.048701733229468767, -0.0041573371970119611, -0.043228939375319318, -0.14661588442426024, 0.29143464449666073, 0.19648131621136655, 0.2600152869464018, 0.41516714053597414, 0.11886762230555836, 0.11870497664083526, 0.049166487660665836, -0.020347297057902912, 0.3629854087310399, 0.096678584119931327, -0.12859987161009906, 0.21915949472190172, -0.017338998421663664, -0.044731804117493661, 0.033350509722932346, 0.10224805910459304, -0.081230645665059137, 0.22201564980391569, 0.12501456767224189, -0.15981545246318521, 0.20887176866994839, -0.29780836907719443, 0.11001898005995676]],
                            [[0.14432190255113245, 0.018049386687233996, 0.29213446674436977, -0.099138811501330984, -0.15404385094510589, 0.11552943078471666, -0.010292821639330619, 0.0099551591278423963, 0.17801097954498438, 0.057098472470848469, -0.089510580032752418, 0.3565067033062394, -0.063720703317059479, 0.44700538839499049, 0.32890584319706212, -0.12226569541501993, 0.13753697428219086, 0.146445228885244, -0.074099445223713534, -0.14102638252006636, 0.043070980324860383, -0.31344892214220227, 0.12988580282999682, 0.22979439026306084, 0.20544238423402689, -0.055734134818331171, 0.023115848533137865, 0.098489144676206772, 0.16257439351011804, -0.17841711994489243],
                             [0.19284687440654727, 0.045114436263481897, -0.15200342998280214, -0.076034632981764869, 0.40593503972577177, -0.22218907701639626, 0.027906664066474147, 0.0309322762663428, 0.00026841515779258508, 0.15890517149905409, -0.12974176816712024, 0.023471463694627444, -0.30966503193268702, -0.1095345196018625, 0.37591576629478179, 0.16502739530351976, -0.39410502172334694, -0.017025642581538804, 0.078918551497834666, 0.11297544716813583, -0.30673318977503888, -0.11932764202863064, 0.090714298022808601, -0.12100569858374945, 0.15694623344494069, 0.12600856381716569, 0.14444534799631606, 0.12989163384266195, 0.011528164887380029, -0.11293547906773424],
                             [0.21159075037411351, 0.11701894421965368, -0.1344058821526509, -0.13754426270191458, -0.085738694586078912, -0.020550613775317642, 0.10657336897940922, -0.13472817000488996, -0.021560552365516853, 0.095283187739497524, -0.4105480452614097, 0.19895058797434262, 0.20062370834049242, -0.044948534562948554, -0.1045890198052123, 0.0058876770570667368, -0.24752672830333355, 0.012408699955275097, -0.049989976162434613, -0.15103278983827242, 0.35638442449544611, -0.098266018600025748, 0.26786033001214443, -0.37752980563100219, 0.062968051340410711, 0.021077724761928304, -0.22259715107559613, -0.30317002715234892, -0.001439793633888224, 0.11314053194333754],
                             [0.13773038704408413, -0.037242248815824171, 0.073780254234529552, -0.2397785365827666, 0.014144839339971635, 0.2713687471029318, 0.055176721369266248, 0.10913942907122959, -0.23030537199433296, -0.27397162410080805, -0.41985150420703321, -0.38237731325755631, -0.093983917952104312, -0.076805848916835714, 0.10341734717237686, 0.12844364493894822, -0.013071297515163742, 0.14375289765070703, 0.11381009620966467, 0.17117659048279193, 0.0016504908152499451, 0.025345385311857475, 0.067583407574178231, 0.31043805967635807, -0.13465493198465384, -0.23165176338492988, -0.08386995144289866, -0.12780501132701627, 0.27434550485328796, 0.017111651082690981],
                             [0.28567153574676662, -0.21403859160430494, -0.013977836751262631, -0.013886458834911219, -0.047083257167657752, 0.0082536837763001695, -0.4817662064355917, 0.043585910587622449, 0.28770998977061346, 0.074691348936540281, 0.12743490208115862, -0.29581745096844758, -0.14053153843300828, 0.070098945811159413, -0.11404853814612367, 0.0099663258518206416, -0.13216154663099744, 0.21155812978347274, -0.036158437280400031, 0.033419471832590558, 0.21555458247544595, 0.21821868323039428, 0.1352332256703348, 0.11924250728635566, 0.3509376572029822, 0.068009709874153154, 0.13490987568803706, -0.20853592974447149, -0.14182697544835535, 0.072192151104053678],
                             [0.18762330887027842, -0.097610195249047446, 0.36327457418953579, -0.13099313982170208, 0.16107932218941859, 0.067861940056845343, -0.10321010437076747, 0.53237893329919395, -0.19656294065815755, -0.034520920049359263, 0.2779278814655366, 0.12048853163401312, 0.1064174857579795, -0.19679073545323147, 0.13577292871643842, -0.22231674829145681, 0.028973110042684786, -0.0256038296029398, -0.18539713731634477, 0.01886245198471323, -0.067916082654254903, 0.093238318642005699, 0.13540364014859518, -0.3194350213359215, 0.00062545447689638448, -0.10332842979662933, -0.11105914671841788, -0.035617341870743495, 0.093680312376950237, 0.17044844527905742],
                             [0.25326183194299445, -0.049144696172145813, -0.068928550125836791, -0.24481999702009377, -0.067566205021383247, 0.1926473239257277, 0.15908805572547569, -0.0013232727135793572, 0.1883840346059984, -0.25094615592569319, 0.15571166114585094, -0.029389741536559745, -0.13711796817123859, 0.073688409362487162, 0.13637972916659327, 0.040421403177798167, -0.22764683054545018, -0.24425553174171044, -0.14089707644521557, -0.12446949298819394, 0.15088724213009941, 0.11108696706497641, -0.022401416758550636, 0.052313934379258638, -0.2708734757351654, -0.074120220066978021, -0.22640245873670931, 0.27734184546550755, -0.48023877942464155, -0.10432091375168775],
                             [-0.23195852465183761, -0.18645601394956582, 0.15886642881817106, -0.049569153050069779, -0.31833703156950161, 0.1416309846044003, -0.34616469044397008, 0.1538224037119087, 0.0029607280351529384, 0.270853425862915, -0.12842509942301614, 0.0022127268430831501, 0.030707700941717122, 0.029908259563379953, 0.16398921948839867, 0.52129683765871138, -0.11719710853990009, -0.35475313233496775, -0.043988015225655132, -0.060513042225026563, -0.023463299164496038, -0.054594970116636034, -0.073171764745140699, -0.08658706305344635, -0.17902823136276869, 0.15957020126185881, 0.0089053443702047236, -0.021987194351309747, 0.075723822578821362, 0.055867496410156516],
                             [0.049793823334707478, 0.14684921507678944, -0.32080162728187078, -0.16333770560970395, 0.16031990395508333, 0.051640106556123666, 0.025356621224788191, 0.21755124147712218, 0.26403256870316166, 0.027816337310594033, 0.032220122730325207, -0.0064595007323543247, -0.059825120799968004, 0.19555640947735387, -0.17955098688828411, 0.19490445892003638, 0.26056102799331649, 0.042602596378238516, -0.080337245330782348, -0.41287373260925059, -0.4097822427619055, 0.17063390918725457, 0.13785999791643289, 0.022382200940315535, -0.093302374769366966, 0.088660094451373836, -0.20878474665788771, -0.16540477971842435, 0.18114483630544628, 0.05393572441047479],
                             [-0.086871944000037657, 0.301632340680134, 0.18174564277312394, 0.012598996715422967, -0.37771057939419517, -0.055868716297450993, -0.059190587395149125, -0.01954620372675862, 0.24239626002880701, -0.16646484500773628, 0.020958539976121356, -0.063837125910019235, 0.090585470623807188, -0.30943793914187734, -0.16444098891775449, -0.040374304504170913, -0.26318074040179118, 0.16267759539901569, -0.11139932592049921, 0.1024467162517711, -0.30641803144821828, -0.1108128679630784, 0.38634563961469537, 0.1025231534069693, -0.021288417517043787, 0.17270470981969593, -0.089660219353525666, 0.25829449869109783, 0.057619296239949103, 0.045448819059678791],
                             [0.12439461412601485, 0.17146815584471672, 0.28531700561297657, -0.076812938369405573, 0.29044557591236497, 0.028601651694751838, 0.025717302309034018, -0.068305232540037439, -0.16362472952956283, -0.13636495701561221, 0.30151656231300861, 0.092974700102161828, 0.11334763411916676, -0.12325883606992383, -0.24791209003043033, 0.53327131553026441, 0.0075374924342065707, 0.027527336899535515, 0.19113538644637437, -0.14479815837827703, 0.20206828945543298, -0.20301222599475038, -0.028137313906382262, 0.17645151613894966, 0.22227329227594952, 0.13433219207211722, -0.1138809615646684, 0.03594475501276502, -0.0083060242633372586, -0.066664747127259269],
                             [-0.15539145881674499, 0.20939415700175998, -0.014664450998218437, 0.037086447015393424, -0.14031335265232489, -0.24444132658463391, 0.14802559969009838, 0.16894912334945122, 0.020851205224928896, -0.00090479132011303184, -0.065458079586471554, 0.022822157364771122, 0.039397778919191079, -0.27667195678559664, 0.36804487457693152, -0.025363661319983782, 0.093051304079285371, -0.29727956695020036, 0.1281175168958614, -0.2325266479307479, 0.14057812645988463, 0.33852656700180572, 0.098727106343418414, 0.3420834334814819, 0.34796306528855342, -0.054930619001877137, -0.037777949589393581, -0.11036664877911483, -0.083213213124962673, 0.088352569774482803],
                             [0.023046303717241326, -0.16946997943917827, -0.27529209036994745, 0.19444111548157472, -0.10959291193379364, 0.10170636478759654, 0.2794265017640491, 0.24433082238521034, -0.029394143647718057, -0.087289596032520955, -0.011686937189273291, -0.10503422175810907, -0.18327531045062434, -0.038803062594151595, -0.092163329383490977, 0.069803110202538848, -0.030389344075732419, -0.033106726718155594, -0.36090943391935609, -0.048735325852679277, 0.19748188752030743, -0.22541801089874192, -0.16255052940188872, 0.0036791746000255972, 0.3321472524917331, 0.1348054346452221, -0.017915592872323461, 0.30378577940811291, 0.2590890430506711, 0.29963771339868495],
                             [-0.10129091407772758, -0.090879450632679215, 0.122524196067874, -0.045312939321747514, 0.0019228709480289727, -0.13442655744825041, -0.070362456476985871, -0.16979419816008692, -0.043699796237343602, -0.19712533411696398, 0.036688078832653688, -0.54457602629530077, 0.032937822300892206, -0.047535726530245841, 0.22308938088817579, -0.18262919399602462, 0.0839706076933667, -0.02760844036715664, -0.021147927789382716, -0.47516840696493245, -0.064645494723610045, -0.36957785870648641, -0.050140270734316331, -0.23131140858959262, 0.063148628541558366, 0.13823577493938785, -0.067771816505004329, -0.11211272891994804, -0.041855853855145238, -0.12072306805187515],
                             [0.078937150542975468, -0.19790470429582815, 0.25626027983230976, 0.24388940551280233, -0.13874315756072508, -0.07873157006551959, 0.44711097626141083, 0.18166081173898779, 0.048184798414742658, 0.087456967684811537, 0.00046005336827553364, -0.12116915782283966, 0.11378927353084467, 0.15502893921072788, 0.002080870909766044, 0.059848194876275213, -0.24415176965087354, 0.22824147714650464, 0.099221740909022887, -0.028541141185955552, -0.028346324946236432, 0.32275500164139964, -0.13656237899018969, -0.063380983300631327, -0.020120067941510906, 0.29569820050266582, -0.14120095822413839, -0.11338861026004869, 0.10078386507990744, -0.35365864516776574],
                             [0.055507668890422787, 0.050339941351006785, -0.062660807904651339, -0.29274552510380147, -0.052135522416655616, -0.37717882894836752, -0.054949998319825069, 0.0799841129858571, 0.056570085916649679, -0.40744232711735534, 0.014214786603376545, 0.058456163194100526, 0.36309197996293008, 0.26209390627685936, -0.056098018699047826, 0.022135612196752925, -0.23450579539908731, -0.19153961736158023, -0.19160762469032186, 0.14608047961822632, -0.10969790330488874, -0.013422109035492753, -0.32090876302181642, 0.068248232144314108, 0.089192139898616019, -0.018179506865997636, 0.21255339414901717, -0.17511736281405799, 0.13999672477265801, 0.0069046192768697414],
                             [0.39164927765252711, 0.10665931254548418, 0.041765103621222814, 0.030787506625978484, -0.18363172477461276, -0.052024310525577398, -0.1380028411668861, 0.014931823860476978, -0.081164393206115307, -0.13734301989784026, -0.20878341977840231, 0.11432087416468927, -0.13718733303764855, -0.037812658040109526, 0.043486047288317738, -0.090978991323552472, 0.32879331903040437, -0.044506333533736127, 0.20650955943688437, 0.18053418346241595, -0.14273491474435876, -0.018744730948500939, -0.30126663989367319, -0.032240320152016368, 0.010083934513639294, 0.50198855000757681, -0.20658939561356329, -0.018700369664452838, -0.18186344834103693, 0.19562964151807763],
                             [0.11278484009577121, -0.29611502837621173, 0.016040489163444874, -0.35064111353160538, 0.049139787990440068, 0.1572516414546439, 0.12019555714450612, -0.32479557050826791, 0.16933204983124242, 0.35618630520100397, 0.096537983711253578, 0.012730438880442273, 0.15553071880355876, -0.32896576042925119, -0.061422787752559486, -0.21211100328286117, 0.00096793232643983915, -0.2177395780176504, -0.082270339447172977, 0.08715106343657382, -0.14617736862380551, -0.017605358988328153, -0.1719350019586143, 0.22533805501703091, 0.12910466674381285, 0.087107071852886936, -0.19689041400989205, -0.057764798203053878, 0.22337768962175511, -0.055349567445490078],
                             [0.092869711287125456, 0.06975013746662112, -0.093704635439415873, 0.30599911054245182, 0.16710540352220907, 0.51535236136541229, -0.082078150084062731, -0.15459106706351314, 0.095136459724598138, -0.21083496609605942, -0.13215150560601124, 0.014693622067175028, 0.46528569829946687, -0.08050433863191965, 0.24804063442491645, 0.10029023916766359, 0.072995860255736927, -0.01748296091238901, -0.15921613807045856, 0.0081168112013724463, -0.14618107956680532, 0.18039521707847253, -0.0068198176837829111, -0.12327573721549634, 0.20055349715163107, 0.074906156300475715, 0.17260133764858621, 0.062821602275221919, -0.05142284817229946, -0.1085871316441874],
                             [-0.1886098671225756, 0.44692112363427233, 0.23545193967245603, -0.26164195167805754, 0.20387597878364708, 0.15651533708175155, -0.074673254114177787, 0.1053393595492803, 0.064900824620971284, 0.15068934233530668, -0.25746703885800198, -0.17037213810768242, -0.13767785493395923, 0.085886248166313933, -0.21901644836767425, -0.21389465465107388, -0.026692626210119787, -0.12001676901826021, -0.10112595745527264, -0.036989024402125377, 0.20298819246171199, 0.21296738035164969, -0.21067326797941363, -0.12448509107401688, 0.098800336764524904, 0.18227557542665204, 0.12062214256114831, 0.23636566740120743, 0.062045863179958596, -0.15927460931325038],
                             [-0.094746727807178077, -0.32551804559340858, -0.012658326878385253, -0.28893942205339362, 0.087376219892492682, -0.16140450658994709, 0.062279487167864613, -0.13420686630639134, -0.039511002675013646, -0.20097775316432651, -0.054535486332547456, 0.1393465927879883, 0.010995162036025836, -0.10332063580281879, 0.080158109319713511, 0.049670670941145537, 0.23402136662783832, 0.13121438866037788, -0.090723352693288239, -0.060159568812846231, 0.22373184750143482, 0.223547441004462, 0.30309469923124677, 0.0029870223528818333, -0.2093084643521462, 0.43327662874606238, 0.33382573195788912, 0.17438775261720862, 0.1114494203918337, 0.016034402739114117],
                             [-0.029920343376820022, -0.20544936462480001, -0.058351388741291969, 0.018656545907567126, -0.061083844785270257, 0.095319546746258657, -0.11153921854763275, 0.039172817074468798, 0.2733319243667775, -0.32930033709333578, -0.0040928585212961204, 0.15439506914322632, -0.11850643814207111, -0.065197631620929911, -0.1297303652861474, -0.1029425441093032, -0.076712797216002021, -0.21579765824171418, 0.59922428005073369, -0.090703918717578214, 0.033016679437840993, 0.054951134128037676, 0.0021183568758426819, -0.26514382702121447, 0.12483439473466973, -0.13003368343418323, -0.015180216701241731, 0.16849114841962182, 0.32638888788300791, -0.10870535609604767],
                             [0.17367886349226944, 0.075184739667698605, 0.20960244024846642, 0.092700128360586248, -0.013229619094965426, -0.19454451091882433, -0.063222945224281707, -0.47622956475096112, -0.1107927299956767, 0.031730432165047465, 0.062210503416780201, -0.10436486515033162, -0.046350647988257783, 0.22351525635461406, 0.11973728914777322, 0.11106322589561271, -0.037065972285715815, -0.018715754165857447, -0.077147715081491514, -0.092136550444257004, -0.050888718365177249, 0.37305778643016818, -0.028612082110871462, -0.12701806883101988, 0.0076283899782529788, -0.18501940362338454, -0.18393421556571707, 0.27989824385788586, 0.29445253265612431, 0.3577316966329942],
                             [-0.12477301980155063, 0.15038340126959251, 0.078382481681194632, 0.10669814474658039, -0.052445606493533706, 0.13580406711255455, 0.010573691467727221, -0.22622705417133959, 0.025538562002566222, -0.27060992011124624, 0.19081859973251394, 0.18524381425793951, -0.51049551686493211, -0.12912233748456106, 0.080757420289548104, 0.043389604511538081, -0.034771852526475827, -0.086746740701729538, -0.31198350579061451, 0.11278952128952782, 0.047058793904357729, 0.085620578210681225, -0.035293796336520002, -0.091922286964988373, -0.010198034550456659, 0.074439588942040655, -0.033369440650555922, -0.47872472384154297, 0.19388669469519976, -0.17307398852087083],
                             [-0.31615533605708718, 0.017729236610353114, -0.15608942741146298, -0.15106494889172667, 0.086353779403674821, -0.070556962158022277, -0.022026706873118567, 0.024131525192454775, 0.1216250736438472, -0.036688938856863633, 0.12492282543963619, -0.1545659750332897, 0.11542967568660707, 0.20851046845588758, 0.21347489926524796, 0.10387849590510917, 0.19507101886564399, 0.036277183029609153, 0.024954646698662451, 0.50571999698728254, 0.15269633388430393, -0.014828068870172033, 0.16419998120511434, -0.17173650357218273, 0.19025342480054547, 0.078392337197209713, -0.48837593696147841, 0.06586549825899278, 0.0069498615247834015, -0.09628894152725323],
                             [0.10751303111982091, -0.24106925933936182, 0.18425872031957527, 0.25602787544891897, 0.14743684819349945, -0.22036278575328622, -0.036351879515282293, -0.0011822882436130703, -0.073690716836724568, -0.076795409084244731, -0.303308303426224, -0.030551600277947292, -0.066819079698552525, 0.077001695789588528, -0.32987416391102609, 0.014236950907973275, 0.17824746803379277, -0.44402619731883397, -0.2391372167139536, 0.085099195087237206, -0.12107301854717964, -0.0029725857472556673, 0.31569735454145703, 0.072781040028824448, 0.10850310920104081, -0.080879599590258644, -0.11469354602556535, 0.053274921526963503, -0.10305703396125651, -0.27859747590515005],
                             [-0.060854549767845087, -0.11142063406562679, 0.24270952884839195, -0.079065755520644307, 0.036205112334228906, -0.18958843145953908, 0.11131391967046649, 0.011686861527904787, 0.45768929036010242, -0.038408811047600279, -0.25570202484937304, 0.064501997396843133, -0.064045614903229339, -0.28860922082181822, 0.0013134040706462098, 0.2678631782718856, 0.23961321698485025, 0.28386378186211114, -0.13898940571951332, 0.01999851568635035, -0.026313379152581445, -0.011263632172411567, -0.29377515834774798, -0.20200831179077161, 0.05036554346614712, -0.32688807900439942, 0.01345091140407801, 0.020933163339129719, -0.17530920697186828, 0.053907955105773488],
                             [0.041226132732601603, -0.0088203561967534674, -0.27390457284019659, 0.017675395809969102, -0.094005963220581787, -0.17075917880949312, -0.41159446421465024, 0.053477782298205323, -0.25278911018043337, -0.0018641786490021231, -0.058203452179251519, 0.16613379327932967, 0.035675520424978999, -0.22905856351304149, 0.029704225200854816, -0.011899469674894929, -0.023051889510465749, 0.26185202574128097, -0.18179824591135968, -0.17263470981221987, 0.088603189137436061, 0.10694411637683994, -0.2111075840779707, 0.076983937631202051, -0.026822694490832449, -0.089298319201371851, -0.2795017739832148, 0.21432023358076846, 0.12722784369813686, -0.46075555537983531],
                             [-0.25724676459330087, -0.18333565794583978, 0.0069899861897487993, -0.31165394037499622, -0.21184739742037517, 0.17141527567717665, 0.077372376420953626, -0.096101933402543499, -0.39150772057354954, -0.072591861361171114, -0.045662192230761602, 0.1322276802841455, -0.12614573890321745, 0.11147268225747736, -0.1394121057423838, 0.036566014083992876, -0.074739577645545327, 0.14959421036812304, 0.017337834648163176, -0.075904908432366039, -0.34267894222968664, 0.16353814292622243, 0.016146992929068748, -0.12304822219440566, 0.44396180416153191, -0.04876445299489824, 0.0023748479262864497, 0.01763221034652563, -0.30430009123479207, 0.018023263902038938],
                             [-0.35317021075322202, -0.20230512687642649, 0.12559160172591918, 0.16496105232384745, 0.39916723149270555, 0.034207257937744991, -0.16828084223090317, 0.00042015527098479999, 0.096523490359700106, -0.1645524354685752, -0.19837842291534838, 0.19920389534320104, 0.007220203790405914, 0.073612564778396714, 0.018745615765919411, -0.17566162933320451, -0.31823502028622025, 0.11273577348824526, -0.015347360262299308, -0.12108428325374142, -0.0044240341733000925, -0.0049462375809028389, -0.10141354512343621, 0.26782372298915202, -0.074398097146391506, 0.1553366155688444, -0.31892609129600374, -0.058456136028676879, -0.090849967095541828, 0.3105440888007493]],
                            [[-0.32211367473036862, 0.034088487751914302, 0.056438002680360873, 0.19976257046334792, -0.075376299428615956, 0.26335232091892985, -0.04725312884895079, 0.044149783323512957, -0.27602264939296539, -0.1755339000865985, 0.20128517894783862, -0.031870877990059811, 0.23049249516050158, -0.12945315123891801, 0.24868976796747427, -0.048882565198935413, -0.12966002769507268, -0.11993839452537021, 0.11908218722310726, -0.0059231269151341593, 0.02633172148899085, 0.09756378003663331, 0.24849918111159189, -0.43825216587792587, -0.042378269483050075, 0.27025664986234232, 0.080225228600238549, -0.15270438551230203, 0.15514758496631351, -0.22807383705522793],
                             [-0.020328809688987058, 0.075262209819525638, 0.14016521511122834, -0.13558814230200836, 0.035909928750397224, 0.17509522154486334, -0.12803627536354859, 0.19064851773578476, 0.13303217547770879, 0.29375684244005879, 0.10678559597213483, -0.34667372329263429, -0.13052075712918029, -0.061729609075739614, -0.16561118451018161, -0.15654337525411513, 0.11093891519948727, -0.12117562340831807, -0.015901601102484373, 0.15612044946312023, -0.10839478992008912, -0.29834698948099797, -0.30972576092589382, 0.003628558564814578, -0.049641879624981407, 0.35039472010765904, 0.1646004958016655, -0.069205965711714626, 0.39606599767408601, 0.023140469010706422],
                             [-0.067961232937295085, -0.18063184303172344, 0.010280218890719783, -0.19057246118859056, 0.15406712061129738, 0.17528223319651051, 0.057930923657838446, 0.043185515815799186, -0.027619461990082729, -0.30546816810621602, 0.22682729725040096, 0.34475136106248172, -0.019420493479478752, 0.19410566293497469, -0.0092727082081191254, 0.33322428680356692, -0.048609548190435968, -0.24570881223878815, -0.1586574253230027, -0.24099896095860449, 0.0057559560615667547, -0.11648023376929521, -0.099739862662608522, 0.23109131288573512, 0.28212450175343762, 0.11273226123392764, -0.13462131365820232, -0.084483312628270385, 0.33091774823344, 0.055515144034125018],
                             [0.084154822941162818, -0.020720206655277868, -0.0047703981456016873, -0.37216013519755248, -0.071660093724142643, -0.038210540038860832, 0.32079854093320498, -0.0070641441539062997, 0.13617939937138271, -0.041705759239744851, 0.19648320013159185, 0.03933558796435558, -0.22841238001046518, 0.055583864546234235, 0.25487766750621477, -0.12349343137338981, -0.21849620142785753, 0.054134946664552416, -0.05960205346717784, 0.075366044064568788, -0.13389945122564023, 0.31243576663225719, 0.017407637621998068, -0.27236477015676674, -0.26085221996403379, 0.0083767750071765228, -0.047093932593980065, 0.30702934380416697, 0.24874231449368495, 0.26849150088720902],
                             [0.06743456423628949, 0.47663694531193224, 0.17177669537987447, 0.028037306469303587, -0.017422606173723747, -0.082460954085734617, -0.22951840217353486, 0.0039607407240543615, -0.089041998216639148, -0.25969276429494698, 0.036387093190214194, -0.14833338967791665, 0.12808542415518878, 0.1857669147200337, 0.185626910715218, 0.064879533322083738, -0.2617796393911988, 0.2486120840177426, -0.043366339892113248, 0.24181909457118661, 0.0088516219539348621, 0.13295359423504927, -0.2000943430347179, 0.27161953860195598, -0.056549364452478192, -0.22520432707901672, -0.062732735461586836, -0.14565028072342831, 0.27611801511817452, -0.11105051887142076],
                             [-0.071576827066528514, -0.3079348649170075, -0.092899719502496383, -0.10547091419204895, -0.11286494867703115, 0.0032187034689410239, 0.36627404204654473, 0.1024118460982468, 0.1195737702143695, -0.087087535511775824, 0.28212023578689638, -0.27597436587276014, 0.14977345575208978, 0.10632920675178487, -0.18695123393225291, -0.0028339125295243524, 0.080681396902304123, 0.36525874624743931, -0.051247044575961152, -0.11941378838202633, 0.054186010912803055, 0.013899599073005831, -0.17454594773514825, -0.0737287310029031, 0.017640330919091639, -0.2544770957182228, 0.11251361473772691, -0.14427232047790473, 0.02688083296013942, -0.42598714168922952],
                             [-0.048493731657756271, -0.32968689707146404, -0.074343807012530669, -0.25078382244584901, -0.026095484246404357, -0.11705676291710219, -0.33116683549790527, -0.30815837466568702, 0.2961731677539689, -0.12321943005207929, 0.11521640111499681, -0.19615466842421697, 0.061342160940934455, 0.040210708632535577, 0.20488845444499426, 0.033517647705919904, -0.22109428286405752, 0.21742731264022164, 0.15600884041518773, 0.11269895448080419, -0.086659613017515486, -0.091145283039955644, 0.088105112458265467, 0.084821357168259962, 0.098691304740917987, 0.3346144210320206, -0.038309513177199279, -0.21235988746060516, -0.23442226162598948, 0.10576845968560511],
                             [0.29048785098923818, 0.085955722404793142, -0.18931462414123851, -0.038024329674668629, -0.067090089336409114, -0.076493743004448264, 0.13136585794351513, 0.17563537646803085, -0.29650185961794578, -0.086857582026525604, 0.096931827000872106, -0.1392194253496625, 0.2094396327158474, -0.16089867675228731, 0.033856043266966715, -0.16444780365837078, -0.28464670994951047, 0.064558299581836107, 0.1819396129833592, -0.38688763299649093, -0.17006890888270648, -0.25038630677701362, 0.11892003118605501, 0.28746246160181749, 0.026708004324025467, 0.092015231990505764, 0.27673619737639582, 0.16599222406515449, 0.0015464027754407911, 0.14359493778716359],
                             [0.23073364746766004, -0.13176981828698803, -0.020053100686242317, 0.20998025202095308, -0.26634973788038058, 0.43437704997836402, -0.17894504013992688, 0.12257952075330425, 0.25446104972884503, 0.22462145029820152, -0.13848418341281957, -0.14758148342201724, 0.012891283438399764, 0.21714843841943779, 0.1998065186899956, 0.18565315730974691, -0.13397448127909695, -0.0038263583758333872, -0.13183363132667761, -0.21818467045169029, 0.1818337877742755, 0.28917635640699613, 0.0387885928499863, 0.13257328139169605, 0.040344329686798859, 0.080230111699960638, 0.14211507200881529, 0.21583599989769542, 0.013499613944064263, -0.081336413495262952],
                             [-0.12951498928177491, 0.018786222932044429, -0.028843326343095162, 0.25983871046134749, 0.12275048198851291, -0.080894367274786494, 0.18803911809245585, 0.16929299698923131, 0.20526600086617564, -0.15118341943691241, 0.098940974894338909, 0.19979387710488847, 0.063091984797758086, -0.31413288999687233, 0.16234133967000375, -0.0017054515346947229, -0.083440333849690615, 0.0079879691913805964, -0.12887107149759733, 0.24016237635654897, -0.075454210085299678, 0.12846762357823319, -0.42163901980356205, 0.17752534728414979, 0.095759524456103487, 0.2913759293328062, 0.15910717777118938, 0.25172770624164098, -0.2658217202308058, -0.13770458155739196],
                             [0.16033492153410506, 0.28464142136570963, -0.47681756932460978, -0.11658517994532529, -0.067181329022084429, 0.051221512811496346, -0.29719617277179045, 0.12958132445122703, 0.099956655304751924, -0.12423031921991075, 0.17050057046957898, 0.074257944240695165, 0.15600712201440894, -0.15980564659863247, -0.17494406468233123, 0.06709190304848342, 0.091678856725629462, 0.12146650562976323, -0.18100369322808832, -0.16828576295740483, 0.25003938592439251, -0.019963122166922389, -0.19919092376899464, -0.29676224712051269, -0.15574335345659007, 0.11879415070365708, -0.24798275274647505, 0.00051926339727346711, -0.091521661097053841, 0.10924468147401159],
                             [-0.24928722857484209, 0.12387167058754166, -0.016471039218260861, -0.18848037028119888, -0.51518825498210497, 0.052808772786381249, -0.036462048498896518, -0.01171838072805788, -0.16843213812814753, 0.22075428631731406, 0.24179265213591994, 0.19207357679967313, -0.11361400211196415, 0.058419053443822311, 0.21881803176676459, -0.22008232562864224, 0.24947465970287019, -0.048883007825418538, 0.11878659976472085, -0.13116623286133722, -0.072575672695463195, 0.067127357703084964, -0.14300057883108883, 0.32986320612099512, -0.067578004793872951, 0.037816448009411988, -0.20012020491975363, -0.06557051049688524, -0.18177819040562179, -0.11654523005344264],
                             [-0.13488020062804462, 0.039255140452089561, -0.10645634853597487, -0.051688206653228291, -0.027559394982820725, 0.11079718972476442, 0.010591897022334512, -0.40870204291143036, 0.040428199319611703, -0.031037285745577962, -0.20076398416604704, -0.25899415895311795, 0.21686167774476803, -0.27883573272473317, 0.012027280808284094, -0.14295394968573008, 0.062774270542689303, -0.1454955459594417, 0.099001276374231686, -0.18784315241748528, -0.1310583195458698, 0.24367074225841753, -0.29583257604012281, -0.056534114077038754, 0.42046491864037439, -0.17907129305459413, -0.13467325097817454, 0.13533861643555301, 0.1898126537650022, 0.10925093626437754],
                             [0.32338678184353298, -0.029565026882076455, 0.15379164832416942, 0.090837115345735686, -0.21739975440970027, -0.012144114083618533, 0.14905327859386105, 0.047350735286845594, 0.044736852148524728, 0.05392907860864745, 0.19135214343563406, -0.13315421019593229, -0.077164188084770449, -0.26540545058220733, 0.24201580132648465, 0.12047911314256705, -0.078680215474712142, -0.10690014410036956, 0.057825880455341164, 0.21072108234590689, 0.20646583360653664, -0.38818113030884804, 0.065771339487066163, -0.095463276866070576, 0.26734604222855457, -0.134371797891048, -0.43970253059600301, 0.11962742483174735, -0.0041720306005305309, -0.11280294371774907],
                             [-0.11266193035166169, -0.011004170406008769, -0.0026869601190915322, 0.33216707630406911, -0.099675465005598915, -0.27177302288722627, -0.14461283735214553, -0.29220626673439209, -0.036442422987057285, 0.20657292066702027, 0.56580153320025328, -0.015709357111255498, 0.11312131845142653, 0.21659103989289033, -0.23098344517858185, -0.031752894522064166, -0.087228528169787989, -0.11318332365531732, -0.1687185281055236, 0.062588378631391758, 0.097853659437040094, 0.0067181867695361858, 0.039891593117327782, -0.015065243707556669, 0.10302265501905614, -0.073249936451137407, 0.15050229234631707, 0.25136701974674286, 0.057794880656501561, 0.19724472916533059],
                             [-0.13879189031498226, -0.010918968516234787, 0.17795324176496707, -0.37304884841252173, 0.010092221360273506, 0.054694014368423971, -0.41028530272263664, 0.064251797410482495, 0.042084859353708252, -0.15775800019061828, 0.080003282599109354, -0.018318154717609364, -0.042768583246646563, -0.16994487753683363, 0.041401747540207777, 0.1230223601191358, -0.0015420649051948883, -0.21058231547858594, -0.071201884992481132, -0.040578255883902806, -0.097181332584671945, -0.15440275752416724, 0.025897720662639487, -0.087568315972923666, -0.072825969430653961, -0.38381167692549351, 0.30390654162579245, 0.36178636382643542, -0.18605576497571549, -0.22384839953018393],
                             [-0.15792443905537346, -0.19483074915153681, -0.25117575807019066, 0.10141107864411561, 0.24907086840375861, -0.19161130668463291, -0.088945972582108915, 0.16838958622916533, 0.209626099248926, -0.093149798409710716, 0.018374309315975373, -0.14731975879613948, -0.0020594327838714334, -0.05778148840010331, 0.26625026114745043, -0.36995353521003921, 0.06163424110683937, -0.29380821431688614, 0.0089775178312849566, -0.065813057426073851, 0.366331861845479, 0.010311402853158505, 0.11217064489479762, 0.26043157603920136, -0.22832860712645608, -0.17604341331487072, -0.095391084271809437, -0.037837545744396781, 0.19896012887184081, -0.021530274048600476],
                             [-0.16882311148164839, 0.19228174944175899, 0.17685409801364405, 0.15887425644468522, 0.26390978549950511, 0.19982468460709399, -0.02345398978439947, 0.0049251699251189537, 0.20903673509954529, -0.18381207740936675, 0.084909076235194628, -0.042343103594961344, -0.097616433296849048, 0.2524556229046292, -0.084788037451254905, -0.19626424752804469, 0.13756502606942708, 0.30744545233314163, 0.27771273883539277, -0.21195388326200346, -0.055984553515750497, -0.15416296617676217, 0.12539436907033574, 0.0049654885175255559, 0.035445932679120343, 0.10408160601031009, -0.28727820625081335, 0.4282928161283725, -0.048291180166858946, -0.06219942522361202],
                             [0.13138886492219531, 0.059976860872579488, -0.11081868550335038, -0.28074742742297432, 0.3178939033086019, 0.17704636829919626, 0.058336531324676109, 0.0048347455859996955, 0.0026193437216270703, 0.3280865202433968, 0.19787170635029541, 0.093614882710438635, 0.39796317424768507, -0.022995182499499753, -0.12155480895158603, 0.14954990127184506, 0.026158943920572744, -0.09875154320182257, 0.38754356368991866, 0.29578989479196061, 0.07220298473222328, 0.23628008901717712, 0.14457463706213503, 0.17988062969432395, -0.03761506666639864, -0.0036208718011882181, -0.065405740780814972, 0.10301986889610466, -0.0090132167999050529, -0.14759429005085206],
                             [0.093656778879022407, -0.079304242958000329, -0.36292122712429498, 0.13495837626529275, 0.027291654162377995, 0.23933064468312787, -0.13397443620244709, 0.032939679468617644, -0.18899472283710203, -0.18945601706272658, 0.19652633818393345, -0.060007339565544979, -0.42775113441437812, -0.14454628888756238, 0.048093976828816248, 0.055978525041983654, 0.33344812077249608, 0.21245654181661158, 0.10682047525473737, 0.29284438338642554, -0.096889743562518893, 0.13066291024964913, 0.14622692128186057, 0.10412510367630116, 0.20555828533920331, -0.12890905952381349, 0.19214477034742705, 0.0047364029355456919, 0.10342708905057152, 0.12695878120735954],
                             [0.30302776785958374, -0.034159936686860598, 0.38544923863933139, -0.08982684731394365, -0.010982982644616991, -0.1124306901392764, -0.1557081604863419, -0.013157754888909808, 0.048865823304666038, -0.11632225536236793, 0.13665658724739971, 0.10192287719092076, -0.13306466708599052, -0.32821978037634136, -0.30357501691387173, -0.30640504434350696, 0.014158624746009048, 0.043826062377519646, -0.11850802408033266, -0.14812945019909138, 0.11976418603986147, 0.38395907244709354, 0.20910818090871253, 0.10237431104099137, 0.14389159718704539, 0.16643107692627832, -0.029490610388934628, -0.10272261058195181, 0.065008514124892114, -0.19645680407901148],
                             [-0.064588047665660675, 0.093660606323299783, -0.037790950737082232, 0.02243013808158854, 0.16212685712948863, 0.25999044827531859, -0.055196638379946254, 0.096300454616445763, 0.24687326341543461, 0.31732695146271633, 0.10034883657729418, 0.36333229106518522, 0.021194894506781223, -0.090529709255217403, 0.12268649297291877, -0.32066402712386533, -0.28093797698983697, 0.21311213089760273, -0.12446787049375665, -0.042450148195021256, -0.11579364985479437, -0.14317670632028587, 0.060234812925755214, -0.094096539764539078, 0.250820716230376, -0.32256762684752777, 0.084313342932242963, -0.27773442663370951, -0.012115234979543832, 0.096430080906139512],
                             [0.053595541859151059, -0.043578600475618706, 0.092975160963688713, 0.14247005812381644, -0.33606703019741341, 0.057247167793674607, 0.017690044738330482, -0.18620846469401775, 0.32797966229879205, -0.19027083283074628, -0.048750179713016456, 0.35736018250016099, 0.070934664627769289, -0.15647463054320901, -0.12777956923193518, 0.052272293901807168, 0.038439885957612753, 0.034698297271196797, 0.47043040715328471, 0.022017665382989542, 0.1671646908112509, -0.14422275439948473, -0.10102946564058279, 0.018187173761092981, -0.24572115329410071, -0.095815257374977536, 0.2459625061455438, -0.035890961477747028, 0.25785866876501568, 0.1051644877925198],
                             [-0.16144501130102815, 0.042164238497017163, 0.16511980024403133, -0.21054992818357798, -0.19371759907780034, 0.15204172176704486, 0.11574805966505448, 0.30972192374691082, -0.020818516305755638, -0.23318099322511815, -0.074551533647995133, -0.10063601995292502, 0.16951741321940544, 0.17014369407657653, -0.14251961204828564, -0.20884372218112235, 0.018091171875364829, -0.057113489747415772, 0.016062354924879906, 0.25226296524858521, 0.38483682761425536, 0.042887051124379821, 0.042943029963780084, 0.0072998825327890036, 0.28910972387534412, -0.015495872234800777, 0.11460095695318336, 0.0015878517240290753, -0.22764672696992164, 0.41277728284140047],
                             [0.26382861606718172, 0.14430315557735157, 0.23616685408417476, 0.0065223703387224091, 0.31785994626623226, 0.13278329386952517, 0.13128506417877636, -0.26626992809647965, -0.053081359700583995, -0.01852252664605987, 0.25167948105524485, -0.11372364644934599, -0.095492634099041851, 0.058073665836371559, 0.30025353982821279, 0.016779756301616607, 0.20443938079027996, -0.09685708032970787, 0.083922745381569991, -0.23181735483455265, 0.25073444706302073, 0.01785067313798025, -0.25418315798627733, -0.091036417041633039, -0.088357439738275034, -0.028243117635597448, 0.24176444100106145, -0.22575420132215671, -0.28046944476422264, 0.14094484879713462],
                             [0.38877428151062826, -0.13991779958873579, -0.038694474487640081, 0.086042912155619197, -0.069066955350611942, 0.23913911850627684, -0.017463388990130359, -0.1407155479901436, 0.028979280428374742, -0.26145965746192695, 0.0048216393202457153, 0.081769022146041592, 0.29774196191394486, 0.24492503115792569, -0.0010004805833361259, -0.38108762998954571, 0.18334436780706245, -0.23337849242036326, -0.218955942310324, 0.23495802232262764, -0.35637835690341541, -0.10877609950963939, -0.0090292670264392489, -0.014909354564791024, -0.14119391142861823, -0.030191711431479803, -0.067688627501045304, -0.0018727470840826277, -0.076883793562779384, -0.082599897320480273],
                             [-0.060015248938485685, -0.3182113853668172, 0.097666361548231898, 0.15953287285740458, 0.067572940975757348, 0.30221944772424481, -0.097981327958468839, 0.060500962252439831, -0.24565652112252678, -0.02893617749602095, 0.093704805720657813, -0.096373101571835942, -0.15843954704303612, -0.12607961446497248, -0.2846246062207512, -0.026275830003687231, -0.40920853948920916, -0.050834141704699055, 0.13502037033821956, 0.0071189686303198387, -0.043086521495842502, 0.094620253419954156, -0.28182099721091819, 0.074895286536088776, -0.30241171761216612, -0.16231294336933649, -0.28743400112540096, -0.05042569593107641, -0.18339477729431786, 0.16817106985023189],
                             [-0.19251516382053854, 0.2995308676470666, 0.0013464055390475817, 0.03605701976766628, -0.076921005372340659, 0.23156370598795287, 0.2770339245337915, -0.16681669326668849, 0.29415774749322138, -0.088533460676054485, 0.10936225374752408, -0.23801222979177458, -0.0010636515376915281, -0.25529832250316919, -0.14379163537039413, 0.20465023163131857, 0.0022596510193578084, -0.11467980422260787, -0.27964885332831652, -0.016074106330064581, -0.1381375031184976, -0.02552029163257568, 0.3623308133106401, 0.27042639366097754, -0.21999488038792478, -0.02878590722415179, -0.03757631314974428, -0.1550230044548013, -0.10829648424595818, 0.12217084144582709],
                             [-0.023022655592402387, 0.14289869168785704, -0.27577764980916109, -0.15156559159267879, 0.0067536799081355211, 0.18562313066733316, 0.13304791916332837, -0.4133621094187423, -0.12784833209085808, -0.040606200341586567, -0.14376477425827713, 0.059162326625181741, -0.29790348773476794, 0.09181538895373545, -0.14149514106975156, -0.20899691664052109, -0.32892322221949338, -0.057424313284374313, -0.078781872375102785, 0.13330628564417443, 0.35327215907552706, -0.16698266968815392, -0.016786828280712724, 0.056564176012103763, 0.032029634865836952, 0.12200814219266844, 0.12529939523616937, 0.10453786584137284, -0.026810090692242314, -0.34499791131006535],
                             [0.093684401082751972, 0.23464850383145244, -0.18676811707606181, 0.08102409968297658, -0.072377493335084142, -0.15934906956625203, 0.01801726633140522, 0.20365715518137104, 0.27456424200467278, -0.10655503948230209, 0.087784640746130016, -0.08793443260443698, -0.25961180126322575, 0.2363517403840362, -0.15400949648446804, 0.015085411440362085, -0.18961061462285306, -0.4284512147827379, 0.34615468342450118, -0.05706861102635654, -0.23116505208355073, 0.15957286422564076, -0.021650595366608957, -0.15461065173681046, 0.19255963909131643, -0.049240740950260084, 0.027327782524449579, -0.20470107782877256, -0.15316060523150418, -0.14632730678397649]],
                            [[-0.19934377391211788, -0.1087229603837755, 0.092779151387052783, 0.25128697462058097, -0.12830103030737697, 0.59131529598349852, 0.065820992662641756, 0.10777359191959314, 0.023031823645025772, -0.054568894628157449, 0.094014757928868958, -0.093681062634201992, 0.28244267476322449, 0.016960283114986655, 0.041892849210659396, 0.040744026667905511, 0.21462858995560444, -0.13677001091519028, 0.045971140708758504, -0.047696089206908418, 0.077266991527917411, 0.10415095516128081, -0.21956829231373279, 0.022063131964287722, 0.23802897326990599, -0.15876155269974496, 0.19052548458621263, 0.24697185166458191, 0.12375971755887312, -0.24673291032433098],
                             [-0.18719355239350821, 0.20330210421383396, -0.3144634589810274, -0.0080284359072880281, 0.24408254747520797, 0.14524611505902857, -0.17278380633501303, -0.26040301190146553, 0.027453867721929051, 0.12346012770412379, -0.083343175958939933, 0.22701198266313799, -0.29653976104033219, 0.13494696910277973, -0.27990284904939466, -0.088210447566036979, 0.13204530605430406, 0.20827616935632687, 0.089907321653059022, -0.19532954831873306, -0.10498080348843326, 0.025198904499860276, -0.42166726285591782, 0.020362046215748553, -0.012081174836616826, -0.048865112373261757, -0.21056448203078088, 0.088387826129621413, 0.046455702567040139, -0.16068956610669843],
                             [-0.2805407718900339, -0.28694505574062079, -0.11739127181328099, 0.26371914697970406, 0.031199243215481582, -0.15655223205367658, -0.013624613191427128, 0.20128303050671703, -0.25289444525824717, -0.1300913351445338, 0.20359210748229364, 0.072230086678331848, -0.006031659644075359, -0.067945546385024438, 0.078453610979533281, -0.017636008414657806, -0.13718133123009255, 0.36085494812241892, 0.29852665575659226, 0.15937403581844334, 0.036084785667775322, 0.017457251495734863, 0.17003753369484387, 0.0026303496389704578, -0.15782595079431522, -0.29804256915740024, -0.28067267893252656, 0.046157932088497805, 0.21521636046636075, -0.12545582570039815],
                             [-0.33301846803075891, 0.19314325914232408, 0.014431347861800149, 0.010174311645150251, 0.11240867168913517, -0.044301939267987339, 0.32667903056533393, 0.14236666520322877, 0.10166824025292946, 0.24600031284160467, -0.17225503787406377, -0.11181776727444137, 0.26486026468764157, -0.063685642145698079, 0.0090341969561155422, -0.27497914782259492, -0.18847520530882822, 0.32127329711277636, -0.02141114577582769, -0.36860692725047739, 0.18845827464622017, 0.12215624986020787, 0.1054443950802398, -0.054902731665747592, -0.080605715104627926, 0.19964552498750793, 0.14668971816803195, -0.13687593985821828, -0.035603128296346737, -0.13946566734308216],
                             [0.093219990513797465, -0.14248144116404049, -0.16319668786351851, 0.27799507200728796, -0.19754788831859876, -0.10232645842361665, 0.055705499343072944, 0.13637089394490615, 0.21260208233777372, 0.05144706138060267, -0.16479192534657419, -0.051347776321125957, -0.018244520611813735, -0.024539057625113915, -0.049630755660355373, -0.24736852376816706, 0.072202083848640297, -0.0089278079756894436, -0.13799499810301624, 0.3075427776992562, 0.35389494210191103, 0.052265885809369375, -0.27062683146923894, -0.072944757295964988, -0.042109332801610673, -0.052827144327175932, -0.24455914925904215, 0.0023556295201314602, -0.50959193973181982, -0.064467353799859281],
                             [0.096595797988123774, 0.1105832326858565, 0.27824223546672761, 0.069828054997189137, -0.030631395197229447, -0.3168605604463246, -0.27694924948400346, -0.028656123240307113, 0.18289551463625492, 0.21935757831220376, -0.15204474259973888, -0.097247144074815911, 0.25943525833012632, -0.25935062088387806, 0.0018408580503042429, 0.34381549287702279, -0.025184442527813426, 0.002522508419453636, 0.095712610080814761, -0.0013373587244962283, -0.065063301007260405, 0.28535718427018147, -0.32262852989662749, -0.16759447016753906, -0.10884035325548266, -0.19437743783944786, -0.061690074783227751, -0.092096088480892208, 0.19355828480675399, -0.15276328125348609],
                             [0.26894211326396894, 0.15516406666232488, 0.19583942839670837, 0.29836052255547324, -0.043597747367509182, 0.055443253539505744, 0.13866501771128353, -0.065305537931025032, -0.02934533330620772, -0.073791484198609883, 0.14956387984746466, -0.14785885582837141, 0.13522315679240965, 0.070936007327629322, -0.023215362803313645, -0.33088803254347393, 0.0089208157677115821, 0.14422450108216964, 0.20220502467558005, -0.086855617844863786, -0.26585408428903035, 0.0093910518385592941, -0.20096647933283512, -0.16294968168646798, -0.24163331400608448, 0.08589591592569519, -0.090815147627153189, 0.25112037052428282, 0.045503809720869572, 0.46659586095558336],
                             [0.097523221360896445, 0.21901799341029715, -0.19622054071814737, 0.20794234542931461, -0.20729496279701407, -0.19912753207836087, -0.010977604090360617, -0.29730136710433258, 0.4097419585642964, -0.033393549671237421, 0.2080170842997868, 0.19749954811739628, 0.20402116926551159, 0.035272576437633443, 0.2006613254121915, -0.24598091604858305, -0.014828164027870174, 0.03320473630118053, 0.042336978006617558, -0.018669090730469264, -0.15284826125264594, -0.10706811725387107, 0.16483740518336293, 0.19850379705979629, 0.31713692319690256, -0.21774125972877978, 0.041827028466229481, -0.13799446359712908, 0.076497194259045165, -0.12340794700099904],
                             [-0.20306899057050404, -0.09005113589313786, -0.18695083852797653, 0.055932413691252306, 0.14274148705844594, -0.30297591520396333, -0.10358990674967056, 0.24577267227302593, 0.043852021951827733, -0.22493278956305277, 0.063632181102053958, 0.040039358017623441, 0.060668159849141687, -0.12809002830910943, 0.27184622212075649, -0.14086915912593656, 0.16170493866777969, -0.46532088035927949, 0.1100001564691135, -0.23692502648841621, -0.19142514117084547, -0.024686365749995335, -0.16314560253510921, -0.036648463890979019, -0.05210409386746389, 0.38027960554291756, -0.096736477540544166, 0.090323709242354777, -0.0021753210949449508, -0.1276769551393816],
                             [-0.1118723349271573, 0.10056313102741657, 0.32795090161593676, -0.098763507157089314, -0.09049037011758318, 0.10201714432496105, -0.20361825147923937, -0.077045588124245348, 0.11344629227168139, -0.28200417326932498, 0.055675246977226277, -0.16357715578353738, -0.28465328494867459, 0.090379053182244456, 0.26412316568430289, -0.1059262686343002, -0.097077590171824921, 0.079957722177930637, 0.092334108973441922, -0.16142187456072432, 0.14571854869765774, -0.29746195841216805, -0.039073420716590201, -0.50310320330046632, 0.065811800693367173, -0.1024041485524516, -0.068880043103571209, -0.1642168804565714, -0.10162333683598199, -0.1732874498682872],
                             [0.015705267602933615, -0.087147244808109828, -0.11782035932640852, -0.039225339532038668, -0.13050922253626776, 0.055278073174770265, 0.10907715238346857, 0.13635809540777682, 0.12005276826529364, -0.012161930517450827, -0.54786376974766959, 0.14052263737865062, 0.0033162624085963633, 0.28494547943499088, 0.31314854427919342, 0.060303507201270354, -0.10635129036469308, 0.18869682140895608, 0.13938012213395687, 0.32616719710773989, -0.24525250347878694, -0.16808094585721678, -0.17007337458719829, -0.081188417631737661, 0.0019064087323201688, 0.17656717864338253, 0.16595316508798758, 0.015742869055661118, 0.22957373465594783, -0.021816607398902125],
                             [-0.006059196089626997, 0.081588899970152007, -0.234135175690661, -0.32406672033208911, -0.14114693113704185, -0.12060417856725529, -0.049999417820883178, 0.18524824496284403, 0.15468330873627117, 0.061519718790924445, 0.25647497645168194, 0.19976104588474208, 0.074135358836794438, -0.12918100322457302, 0.05394293943913242, 0.18598810280719444, -0.054087306703473184, 0.23581314791752536, -0.016199594710050433, -0.038001545223066015, 0.18926769592290388, -0.0078790953656793488, -0.053211153936951514, -0.29667163925955831, 0.2163249866628276, 0.033669913142222202, 0.088279961076450364, 0.5300855482114315, -0.043632753098679346, 0.20860244414305154],
                             [-0.095456779284141327, -0.14190509732629017, -0.027410186579948426, 0.25178074128057487, 0.15707577419374191, 0.016539244449608661, 0.18215257483821926, -0.16615763143149756, 0.36694623939012527, 0.18474675857429451, -0.058256238207694974, -0.14453828867448024, -0.22761222889667018, 0.19964449689413227, 0.085800151180466994, 0.21355883416902435, 0.11689696228383885, -0.1283616827557944, -0.077033700711218886, -0.034181557948178037, 0.068718628311468841, 0.22631986080493816, 0.3391447535625885, -0.25362550421900337, 0.11286652343504452, 0.11100532659607466, -0.30943181185328106, 0.12855856348542138, 0.22700446015369527, 0.14755312344902111],
                             [0.43279886114344229, -0.090749521808485181, -0.30851440006836256, -0.01188916764399681, 0.32047874777020663, 0.066588067054158095, -0.038931192129116533, -0.028594145513378209, -0.060685102049481111, 0.03738691458664016, 0.077352468612432265, -0.25405238552867415, 0.017650492059782669, 0.24740512733611317, 0.42623511537715308, 0.12281715442330325, -0.21151833618602631, 0.038645135333829371, 0.073677367243166869, -0.23211160118274293, 0.11293834972079403, 0.15735818842399138, -0.073507268236617296, 0.095825437252839707, -0.12354867726033975, -0.17036703864100719, 0.11282091332931325, 0.063784889524233779, -0.16646696792797114, -0.13902497578732168],
                             [-0.036566610283533231, 0.28491719612527899, -0.15012923052448102, 0.06255193052004826, -0.12797378127276685, 0.31268603642032811, -0.27631663192894879, 0.21296730898299884, 0.037217669909124867, 0.12345235948430813, 0.065235299119554224, 0.17800702594156417, 0.097748833137981911, 0.00019324675935493432, 0.2786885258118233, 0.058618338179014122, 0.054614963638306757, -0.062744171871846055, -0.22315820988748317, -0.037770008364111797, 0.26044192373633634, -0.11253198338302234, 0.012191523756264035, 0.097901629907838003, -0.35504594723170269, 0.021318614837435895, -0.22034470695563491, -0.24509455300891336, 0.23178429446562734, 0.27334939839266542],
                             [0.017340562904999756, 0.19986855471767728, -0.15611252484346641, -0.29368307757828205, -0.28007940472050302, 0.077491191473852902, 0.099405217139398955, 0.069429549348415581, 0.19036104198054837, -0.13345301066916307, 0.015562247726865057, -0.30449243425116451, -0.10359020674439887, -0.029427444471734933, -0.12486131549567586, -0.137159276186611, -0.11578484736447436, -0.11277828291617081, -0.17169723998876743, 0.10284168758912531, -0.2178786947567658, 0.13283444731253011, 0.15139794207522186, 0.019457729936367341, -0.39399599996772994, -0.12718391058117606, -0.12021578588593089, 0.2687126187694634, 0.15670903363526945, -0.34605330946102808],
                             [0.10774779439800349, 0.0010878127489209032, -0.056226089537750414, -0.10083253066689125, 0.35586557199564445, 0.073694134918209961, -0.056705001778958021, 0.46121321153199174, 0.32091519602456436, 0.18906827952058514, 0.10887660810808975, -0.027026295013300762, -0.11052537344752844, -0.0049395012827423822, -0.20015965719683157, -0.2183154330239975, 0.18947281480387596, -0.10475464949833092, 0.26255886684286805, 0.16088930550173933, -0.081395029598013854, -0.054295484462455239, 0.093392466319958387, -0.15991846963623768, -0.011920161745215329, -0.26845462428661915, 0.25583785447388802, -0.20408583366767516, 0.056936025439070399, 0.087474578520783039],
                             [0.15411948147764387, -0.1521036821133912, -0.04181056600674881, 0.003187160660205786, -0.035927305728790729, 0.10029955037385717, -0.22665560130491619, -0.007390027825947389, -0.10478598364907744, -0.15672846313601715, -0.22779987701279591, 0.4443937758103379, 0.29914256778037307, 0.19167011375504958, -0.16237743691872961, -0.13710437990627866, -0.0020100374031300997, -0.069833256180855618, -0.094667846887807439, -0.1921680716728246, -0.10156750137704068, 0.27931428717208601, 0.31071791096799678, -0.39486411559743861, -0.10054833363076973, -0.10161364740836995, -0.011738490901089443, -0.0027301574861691791, -0.12137014848876287, -0.073394011749480695],
                             [-0.033643381352142974, -0.48879764912500867, 0.04472715771915315, -0.10022272089103693, 0.044687849358272878, 0.04323695692984527, -0.32100750875391465, -0.16097005914096094, 0.25758542644752835, 0.088309835575113682, -0.14179224166186441, -0.10521103882126855, 0.12552908629723705, -0.073209493105412374, -0.16437643588231321, -0.25435695836502181, -0.35937897395447821, -0.09411115873053072, -0.013812016570092059, -0.14343960502669015, 0.16053090968332495, -0.27585783091397642, -0.042682293403088399, 0.1820715454082758, -0.038776234204497807, -0.01507564278910908, -0.014064792061913769, 0.18441628065928406, 0.2103759448651345, 0.14528327023070564],
                             [0.13947914174205556, -0.10424761812452153, -0.17854237227371952, -0.073374151786446615, -0.37299194691953758, -0.046244481817711514, 0.21189464499017982, -0.16265243558700893, -0.26022699837379076, 0.47238378612104431, 0.068802192252978595, 0.012017404103343295, 0.015203291080748698, 0.037191012994190108, -0.061355423153415932, -0.014552977397636705, 0.11082998764309029, -0.26001217660639703, 0.36140692365488303, -0.1299141012850567, 0.13783909402070163, -0.25332463355790469, 0.0092421877367447284, -0.2337017780839919, -0.11038709243969214, 0.016225768889543548, -0.016288941172776929, -0.076353529275263246, 0.10805692323101562, -0.15162328748782922],
                             [0.26903765932920021, 0.046042982987263364, 0.017513738323638811, -0.046558386865668197, -0.048131672025298389, 0.037522671578594693, -0.13274446842174698, 0.31710151943588394, 0.018136539517106157, -0.039628260474415193, 0.14699120592987547, -0.17657945337735981, 0.20913012600387898, 0.31388998997918449, -0.30420731818921176, 0.09485182084530866, -0.094746320447263624, 0.14273280366461161, 0.083330613207092494, -0.030267204953082653, -0.0035129901226609739, -0.070511214215152745, 0.0090919616695930901, 0.076094245214030951, 0.32060001604904154, 0.35899590465874176, -0.39306449955610628, -0.1442328998613315, 0.088930577079864681, -0.19924169451665585],
                             [0.0085250622971501707, -0.2305909895497503, -0.41503668692325268, 0.15511219342285568, -0.092040598999574091, 0.20866710433543653, 0.055480255726719364, -0.074234125278430318, 0.086682391847423573, -0.12298805047823742, 0.13195961632176134, -0.16588974826286726, 0.0024838653917610126, -0.36327404035491051, -0.14493952360467663, 0.2146637651428456, -0.16721208170032736, 0.13063330430440695, -0.16334295964731399, -0.075493056294610658, -0.29685154383797069, -0.053790203848348914, -0.093582367646223422, -0.27477438332517012, -0.0036740707652520464, 0.11673949712771721, 0.10904436616348188, -0.36751109066729787, -0.03873942072936043, 0.091801406237703553],
                             [0.20073411312916212, -0.20684938505254741, 0.27637547182915972, 0.073220085645954711, -0.099038705704628888, 0.059534272045053654, 0.13652469392226632, 0.31096012375998677, 0.038034353923443946, 0.31689240024062798, 0.030227582742541465, 0.26006882521706165, -0.28534265055062452, -0.14709690930633776, 0.15173393581258318, -0.01488547465123875, -0.03772916271519948, 0.10561666368110395, -0.28247209768150999, -0.32389746944543418, -0.33136960862629461, -0.11803389548313201, -0.030344016683621463, 0.1165693432524277, 0.058076946335035039, -0.11428531143250667, -0.16039036507848697, 0.081398885828956727, -0.074542360717108111, -0.14106696887023881],
                             [-0.035853988154708999, 0.24161287480088237, 0.01667808423069848, 0.022034821960705088, 0.21585287183899352, 0.12753251902088508, 0.35126271666927267, 0.04653712930416809, 0.0072449121232975545, -0.073457951504859897, -0.046000790471477364, 0.23979522771296194, 0.089242365419337527, -0.074174538840708806, -0.075134539421072316, 0.13150669645851101, -0.57620810533580524, -0.39434177952941596, 0.11950220177808316, 0.074078407914265981, 0.01006895072936846, -0.10537380672593917, -0.10982283142433141, -0.072044265550741962, 0.10139872105257577, -0.18631114533007478, -0.24779555359324462, 0.0109873623975406, -0.069757141345934762, 0.05064717085759296],
                             [0.23699938566791046, 0.19266480756433532, 0.0070403171180809165, 0.39818747717442987, 0.13837829662890488, 0.019505661659186282, -0.058651184328852198, 0.0078090514646407504, 0.11514183430716815, -0.13538751689727052, -0.15997155337724941, 0.089050281060057412, -0.054755885735039235, -0.22614350976036668, -0.17887750073502359, 0.24407263534118331, 0.075315383976679098, 0.076193787013439568, 0.10524804042862239, -0.05467046966523334, 0.1644538516550258, -0.39350015448702202, 0.25610911519226387, 0.032007198258731322, -0.21743940721121818, 0.16794952531637514, 0.17343302501825, 0.26204008580681531, -0.036712807424664852, -0.25423671032532158],
                             [-0.0049129277192610206, 0.085666188532201037, 0.061581741419979616, 0.13846329627580001, 0.15937882956165478, 0.14159870975597388, -0.28615806785327647, -0.12700351274603425, -0.16459622268979437, 0.3765211750138297, 0.23722053692423142, 0.045036139743754457, -0.044341067383539545, -0.1101618029985342, 0.14013720945618707, -0.23080775966927419, -0.27386543087748139, -0.03881230464378526, -0.10853049410599941, 0.42445077021787714, -0.1051518175267836, 0.10161367131419756, 0.079170286213195953, -0.17385153013340787, 0.053415460505659089, 0.33111724016757171, 0.094972382932650215, 0.10564541543039048, -0.01826922790097623, -0.22957229188280501],
                             [0.17809237741499787, 0.01783491154028161, -0.04648083464501454, -0.27241979127071753, 0.10034556971806931, 0.28057662177107384, 0.0025681420363761536, -0.10900531594222629, -0.037089598128869534, -0.021116296231375391, -0.28034933971579479, -0.070722592055868852, 0.090588633470550808, -0.5239243843548641, 0.21906640622208096, -0.14236367327608168, 0.21184661457986875, 0.11435777218129282, 0.28324580978401626, 0.047908384927000822, -0.023409136437568256, 0.071309347890371827, 0.18133137952713441, 0.05622866789596552, 0.19336159926300273, 0.034113854570869399, -0.35925009472414887, 0.009600569787142443, -0.063614390094626633, 0.024967039533710277],
                             [0.22654719105857801, -0.18117494601652664, 0.10489348914527195, -0.18857125911113254, 0.30874605145974615, -0.042769842928458514, 0.34449755745883498, -0.16893540596249004, 0.066706996446878594, -0.16551748875384911, 0.21493199948609396, 0.21196520954205017, 0.17686720324105459, -0.046414365679558443, 0.033453039846691242, -0.099746093982520309, 0.19702204761149622, 0.10231704229440905, -0.29600816058462243, 0.1522548238416733, 0.20064070541776419, -0.10485907374095062, -0.20832498833967042, -0.14287757136106805, -0.14399219444975922, 0.070905667309135653, -0.064744444125661577, -0.08716924811180439, 0.31781634789313967, -0.20911813038820834],
                             [-0.25720417655869554, -0.12823985236030427, 0.13107423906037316, -0.17682741598972482, 0.087601735493214289, 0.1174965550064891, 0.0082996058940498756, -0.14845363489177191, 0.25508746080706318, 0.15357507132253889, 0.19810496473198302, 0.045373506098928269, 0.31785329106097004, 0.17274656059800841, 0.054516818373876258, 0.25537238700872983, 0.11537504035401594, 0.079543989884104604, 0.13736729659882013, 0.10808937583824205, -0.25467063278178881, -0.20485336673925753, 0.07529604120348779, 0.073469559625233827, -0.31404983618515653, 0.045585104129927605, -0.13867804472736137, 0.016142948794910565, -0.45480980547003008, -0.034875826131212991],
                             [0.091020264356800856, -0.13126585930406282, 0.14617125601364428, -0.056036431382706198, -0.2096191323737242, 0.14780858766980445, 0.053870929847817467, -0.033950181664079954, 0.28162897636152451, -0.13815857688744465, 0.18353318180048411, 0.30974848584819076, -0.27501512214906176, -0.058223846789527411, -0.017722467916383162, 0.027763377853794298, -0.16127128754349015, 0.011777502853758424, 0.39039862398849456, -0.034209925347172973, 0.18036719290624187, 0.42015727383431262, -0.053566967348959375, 0.18608700945974452, -0.16968187657896394, 0.28929653718802945, 0.11569169443645565, -0.13641522855518062, -0.0088490800627077613, -0.03390508656113142]],
                            [[0.13463349157249307, 0.12364867088338814, -0.21596055375203513, -0.14121644238307374, 0.29108466553935902, -0.13351756901144132, -0.0062649494051246783, 0.24310997777360405, -0.053093519363822526, -0.076238291228242577, -0.22481673577490249, 0.048775635205701863, -0.078224294470131739, -0.09827563611191284, -0.040519089490266488, -0.028265206493278013, -0.13571737609631593, 0.10797949744279253, -0.13995524269039536, -0.13059252002146457, 0.050112070256567817, 0.16472056425425752, 0.21176217794267818, -0.069195000613869004, -0.10446629242643778, 0.017416376424635276, -0.016195618400013743, -0.46339480463826416, -0.28512211615298944, -0.45280244893308758],
                             [-0.23367159631817286, 0.069000242579635981, -0.045771158098750091, -0.037520550487500193, 0.044393699701730932, -0.16381572440682196, 0.23392554426561021, -0.16375811641412277, -0.29385975230908995, -0.27168773524705608, 0.29974843436360238, -0.084723032918256308, -0.11899941230039246, -0.00028480317890890823, 0.12772942254153524, -0.24480752975023171, 0.37834857478900191, 0.18937723786657376, 0.28436874455354666, -0.064816626867630359, 0.057042201164655713, -0.16053962822791326, 0.066156455748806214, 0.1995800016523841, 0.07401385282366886, -0.15455612857873435, 0.0967875772702987, -0.18895893953204468, -0.25418318548014285, 0.053162627847636784],
                             [-0.090106411244992177, -0.05134797736652548, 0.051152697817286638, 0.075400317832139963, 0.15884083483028835, 0.1297931771551574, -0.30583883434795733, -0.075149474325719792, -0.14242554930047527, -0.021202466506313522, -0.014260890958119776, -0.008697795210531099, -0.31054944330326412, 0.1595730144994571, -0.5675784557317447, 0.33394500391499349, 0.21707939520414204, 0.034045000891570448, 0.059580686872976435, -0.036488272677337882, 0.23425914745153228, 0.16773020001181072, 0.0047617935896657514, 0.062311609643553742, 0.3241071581172375, 0.09636171240170982, -0.049863898433822364, -0.016584095562641586, -0.07343001413667602, 0.023104626796656549],
                             [0.22916519104875921, 0.31181915010289629, 0.19560297664162238, -0.14864048472541402, 0.30220139423783132, -0.10728638150142679, 0.19607176782842076, -0.012826626812808876, 0.10372246726208753, 0.072252631491553754, 0.14665235457262674, -0.1733441910625588, 0.27770580733769518, -0.41693491203920174, -0.14693114645166708, 0.095205989776873973, 0.06296845393337698, 0.18895563299430745, -0.076146069802952479, -0.015837316320056739, -0.024761099214010106, -0.077932268522322198, 0.20544898523084931, 0.03794834579932084, 0.33720311569872702, 0.1218064449234508, -0.11846829456627449, 0.023360945942869075, 0.18534880171022641, 0.16055900930731146],
                             [0.094247503109392908, 0.078518528282252295, -0.020208751200423269, -0.19034227966646636, -0.26313105282554267, 0.034119561732323972, 0.13626751567028636, -0.001519063502883407, 0.045811486271933648, 0.02700731543645701, -0.10920844038827413, 0.47683506309797413, 0.0098622214779608888, -0.31730971934659796, 0.055646690647471769, 0.18306994148379729, 0.42525974299292679, -0.42605649137133245, -0.11210368650963919, -0.025082726869760756, 0.13733693121057816, 0.068340242906577212, -0.0038238198925248179, 0.049612926884793261, 0.059442211319357556, 0.028099874532886111, 0.22167623884970536, -0.092689080974909771, -0.10732358265161629, 0.068360120891515372],
                             [0.056576261426484462, -0.052291726644451544, -0.16870447531445482, 0.21718396146469304, -0.19674904022935025, 0.061699113491753686, 0.041166139569745352, -0.40465698209320394, 0.045154901529928564, -0.068817066434626206, 0.30500965762292065, 0.22231171067550418, -0.18138903448284663, -0.20134732955584081, 0.08732563834768331, 0.14899979315616119, -0.34109794847901587, 0.15935829887243064, -0.19745144526015129, 0.21342600834596082, -0.0134652624011352, 0.19653527338973256, 0.072907444108984518, 0.25851057865560073, 0.088286165801982522, -0.069533134730058566, -0.17087989563159564, -0.26863944530759321, 0.082161497118524676, 5.8819881516598046e-05],
                             [0.0084454684364529079, 0.099497807447554348, -0.012744592202022649, -0.021421772657925945, -0.039482931023079954, 0.2577693400143381, -0.14042588651156407, -0.22523994995672875, 0.23167720377118742, 0.34746178436589592, -0.024131073092454873, 0.1242763864818805, 0.19345540438917855, 0.063461138866402811, -0.0056208858499873435, -0.10629558586377856, 0.013747400231503311, 0.012583574885899661, 0.32412565542919131, -0.13487892973978369, 0.012913934346159468, -0.36828611467750183, -0.14641512309609067, 0.28932612210356617, 0.11304553944430613, 0.18905283840414724, -0.10931040006441738, -0.17957286593405963, -0.051795765165799847, -0.38443954525466689],
                             [0.13019317727781521, -0.019456267464735912, 0.029344684915656186, -0.11414246322920096, -0.14803589985970045, -0.086044106743195084, -0.041853632676404698, 0.26501833907037603, -0.36459147370903433, 0.19299857599555481, 0.13922329901375916, 0.028846567831122008, -0.29425783240865122, -0.0895935669558824, -0.049245564519606697, -0.25549749373392067, -0.19271256879272478, -0.29002030522841632, -0.015880516892433343, -0.0061520983958200642, 0.227913030851498, -0.29857137523332522, 0.040403981802710098, -0.037389893758193703, 0.24071451861543311, -0.24064238393989554, -0.23564374847477668, -0.021780377065066685, 0.25997245524049606, -0.098323798340410468],
                             [0.19492718341869492, -0.29414077765258173, 0.019240402163485586, -0.14209483632007588, 0.0040893178907605863, 0.048082738020822455, -0.16324342261272773, 0.063573957845591778, -0.069227745848499847, -0.01578672258526264, 0.31608352076492302, -0.27709917941833301, 0.28347627283310628, -0.12235625524450672, -0.24954199758847301, -0.23698109246832227, 0.10103477855427688, -0.25496993281941799, -0.020805351366858536, 0.18353316370741049, -0.18808245007822041, 0.2806434317346248, -0.32044596742248749, 0.12973044021532018, -0.071783337651155646, 0.0037213466126421444, 0.04945075073155214, -0.26917454846393207, -0.051250380822620512, -0.027004453102090955],
                             [0.12834880631864948, 0.0063091760698941448, -0.11052298956084844, 0.17227714214755604, 0.14673459220813559, 0.019313967593151245, 0.16989975655748218, -0.029879899998672403, -0.083929728985736252, -0.018051638997992461, -0.0059698908817694928, 0.15561643818918897, -0.097616113479926298, -0.0026969177527322572, 0.081723394976412178, 0.052788064326163245, -0.036061674474404136, -0.046148874191948491, 0.10175767860031194, -0.20995573843300558, -0.28984815719481111, -0.062933200056061886, -0.48162236651263202, -0.451165025566232, 0.23966088124963186, 0.11234624188833654, -0.24859024773486146, -0.21772106085015178, -0.14654922298541923, 0.23921034764591315],
                             [0.072906317245370306, -0.47075268768583439, 0.40328129173898863, 0.1572394783385149, 0.051364963187696296, 0.082442841924502769, -0.16302053238119915, -0.062818319858879368, -0.27011092013883142, -0.03787710502713508, -0.2484513261059115, 0.0092510289921029585, 0.049309344533294233, -0.13755359208234003, 0.21521642958930395, 0.11545530853295739, 0.11513499634392745, -0.031552660599537055, -0.0035613577141463456, 0.03774779935058472, -0.28526367457377216, -0.1981944267232045, 0.37198059287867308, 0.032388968881230516, 0.020940031859546002, 0.075914114391637089, -0.13250568119017486, -0.15526599906530794, -0.069922927607815447, 0.0055387242254019281],
                             [0.10205259296624004, 0.082977916439965327, 0.19133859143856083, 0.00025538263657641508, -0.071225154796190224, -0.18850100088259583, -0.015419646220402207, 0.053669880035193455, 0.29847151381004799, 0.24093359937433986, -0.11968986997062105, -0.024141139410126935, -0.19621395953308252, 0.16020884673000177, 0.07009892520936907, -0.29920290899934637, -0.080474025702588367, -0.08869620867142694, 0.23453328538244178, 0.32322660578163481, 0.1111120460798604, 0.21128375753850978, 0.20285728977288908, 0.02365433464575421, 0.11270485461450409, 0.15893612263063067, -0.1117261813740992, -0.158000989041191, -0.32277728883883844, 0.36000387670195999],
                             [0.18264161485201841, 0.20834178767620301, -0.19495477965994773, 0.27436853266211703, 0.38148313397727546, 0.18049719866289524, -0.25581959380898683, 0.11780702423274156, -0.028077317961360187, -0.15567239305955063, 0.12982387693399719, 0.093394854401765454, -0.15744113157366105, 0.047169586467885015, 0.29967418971622006, -0.20132194672583203, 0.061596334147725161, -0.2600556246286353, 0.050479791739957314, -0.026204914953958259, -0.16386126196474773, 0.11890561844411303, 0.12794260480697484, 0.20467432733093635, 0.13815320993753163, 0.19824449292668064, 0.22355498135794466, 0.15280525505683665, 0.19721497377389915, 0.0075832712726661448],
                             [0.092641165522187985, 0.14229762513992417, -0.098032377596647693, 0.21196020661129011, 0.063471316664943017, 0.15361803115321671, -0.1547944288865, 0.059379993728319272, -0.2087209075414812, -0.18997583631780574, 0.049225064957789257, 0.32973808761803836, 0.34962878917035883, -0.15776793321406385, -0.2759093056562032, -0.079200009581055317, -0.15534304584598951, 0.012021474684626731, 0.26811525680155907, 0.16201142307381733, 0.23093428650088962, -0.15618901274215952, 0.12235022059552779, -0.11256548172124037, -0.34513728572239255, -0.025345265127258144, -0.11603331319430669, 0.048229138938385374, -0.14745172663385395, 0.23688048672767054],
                             [-0.1468653059379692, -0.15686838716818316, -0.020556327785520124, 0.1762439953864223, 0.09513484986939838, 0.06753311203555569, 0.31741123092229329, 0.22789723896767788, -0.12752379573444989, 0.096854605971050958, -0.13097596630876235, 0.0052429865743997307, -0.067520316664622923, -0.072952541610600274, 0.0097172684158758314, -0.14724627490668274, 0.12561292118215373, 0.11147301692346899, -0.21013056705216213, -0.042987600099246709, 0.28016584723171023, 0.038960214644203559, -0.20146860342815393, 0.33130396088518227, -0.23568582629183643, 0.46639797289590468, -0.24324180268950213, -0.050212530721587052, 0.16465587301197798, 0.12293514106624133],
                             [-0.1890944949247273, 0.057912975801247553, -0.077825185793686219, -0.093488817487967904, -0.34050175477600608, 0.23130198786940021, -0.077821319927842927, 0.10446067035035457, -0.05215932948269688, -0.060808736290358302, 0.19365452757332213, -0.18929169928097767, -0.19095931340210587, -0.26074886045580697, -0.042139903178604096, -0.048248643039412155, -0.098434801192149327, 0.10075047282887178, -0.019990136580963602, 0.12000184383726631, -0.086596019190056661, -0.16089632935721523, 0.12317717127216918, -0.3206973923091484, 0.042777146757111389, 0.5564405760008001, 0.23733096762826356, 0.00061439315529276354, -0.1113078534398282, -0.071787836121024018],
                             [0.0088842057381054041, -0.061738129304044376, -0.15295684558292277, -0.096181052859707697, -0.020056359578050721, -0.382490140086991, 0.013082363003610131, -0.066925273673550001, -0.073173974454881399, -0.15165560710422218, 0.19811981080181731, 0.010918029082501127, 0.19986991811721658, 0.20738188665893378, 0.18974775854507811, 0.2632997395027093, 0.11561249875476803, -0.21071039301865538, 0.18258523279106145, 0.2142142849227511, 0.12899444377682712, 0.088696426996572209, 0.08471360933145855, -0.13885820359855694, 0.02256972191457193, 0.35046769937397454, -0.37287331685285519, 0.13135313878417443, 0.084489434676798855, -0.28527631650599267],
                             [-0.46420460808790137, -0.21472142472229974, -0.20303896521366993, 0.046042986229880553, 0.11306424922223396, -0.10916976060986729, 0.047818803925591798, 0.18165738278067209, -0.11343323711869248, 0.3028632705552054, -0.053514990790521973, 0.33079460529511451, 0.26137591326525939, -0.086448628522384038, -0.056616587674040403, -0.13938226405047952, -0.04460259731760409, 0.15028478262290382, 0.074927602253994377, 0.21167042649162321, -0.17356965872018668, 0.18979794159888394, 0.059737045575026911, -0.047700077033731601, 0.36796803840833564, -0.06024053815595825, 0.14400616214799236, 0.081424549380848213, 0.05317213577064038, -0.059659956756957067],
                             [-0.13235606881868306, -0.16457583102829973, -0.020644592732393895, -0.29706700216463011, -0.07378188297961695, 0.11043308047427554, -0.085102880320913676, 0.16279396779422983, 0.30486819572180912, -0.53366507933433338, -0.19957021794193527, 0.068552145043931617, -0.095226576032811358, -0.26666271541753878, -0.0076929783260089382, -0.13302238171819797, -0.096229660545087609, 0.033230107241053547, 0.23949311620489055, -0.11443984698829314, -0.066405426898337935, 0.092206871793433079, -0.072640878619085192, 0.16828847135492703, 0.16791193639096474, -0.04918063770801466, -0.32458363343225832, 0.17574791957229025, 0.030500310646178055, 0.0048488235523354234],
                             [0.12905732602562572, -0.24970751789095152, -0.052818733799037079, 0.062662588730039659, -0.012655595657950115, 0.20978573052945582, 0.35717240221403385, 0.44526577478788504, 0.12128894074122773, -0.044285090419486299, 0.24553687690825646, -0.064678762775796372, 0.10685003143596143, 0.20444442207445823, 0.037392130194393393, 0.37668595265374771, -0.23363008529830961, -0.075480922002460968, 0.16613207861395546, -0.077117257910256337, 0.087070025801605153, -0.11163947824224273, 0.11696291120028897, 0.19390407814720678, 0.16062900490847584, -0.043387952302658836, 0.17252788824862123, -0.050573148691483452, -0.19431770009941421, 0.06085316615840252],
                             [0.38487389895727725, -0.061234021213850985, 0.080441601750035466, -0.032067614704511062, -0.17656915525478056, 0.063517297693462649, 0.01936313815662526, 0.18479456578024514, 0.096222287707409204, -0.21192034842204255, 0.035856182786186713, 0.30719948819483095, 0.021406565810045807, 0.35230751582142661, -0.080816868630352715, -0.19270932163428223, 0.28402212762140316, 0.44253392264907232, -0.16022156515648686, 0.23513477715704051, -0.040974469504361476, -0.10672899483594121, -0.021852961313732253, -0.10825104545804723, 0.12865267649040116, 0.020965780943611432, 0.042101351621242941, -0.072280017260534374, 0.19150169810905787, -0.09707783315535766],
                             [-0.20603325080336887, -0.04781629716360955, 0.32030948140096094, 0.21213234873742523, 0.0616244617043612, -0.27835045588800761, -0.27886046016183152, 0.24364874909495041, 0.32376597830729281, 0.035200282630107022, 0.47392554450353047, 0.24010184770687096, -0.046718546356213711, -0.099472319478441137, 0.016127415498176444, -0.0096694036354679422, 0.067680310169256283, 0.025642108791101206, -0.21171187754205276, -0.25600607248760182, 0.0091047088607264307, -0.078276822803658705, -0.038870185218237499, -0.04431617766821596, -0.11694768641256073, -0.0085723325793386172, -0.091837735962601946, 0.041871610967313379, -0.18478926560603168, -0.071718745070590562],
                             [0.25870260209639784, -0.091889480612707769, -0.14382833121483951, -0.15241548087361775, 0.011560783973655358, 0.13059240667427149, -0.2761397829137005, 0.12706139666486141, -0.13592175390511654, 0.30303999858239566, 0.07759358005881907, -0.069481797796500488, -0.072423631165895799, -0.23016669749613838, 0.39675099654552676, 0.16450457139088168, 0.15528564391267649, 0.39231413591725856, 0.12037619266943771, 0.046592414579090455, 0.1977651287711282, 0.15608399904384845, -0.17034892008247762, -0.0089949627372566104, -0.036944943556175981, -0.11931782271543415, -0.074912017124518657, 0.23646387170502539, -0.20420579200749597, 0.034468803310373268],
                             [-0.22459238975636017, 0.1903396990410576, -0.26755424545258388, -0.10262179463240161, 0.061577343402775431, 0.25230374750745094, -0.0094371640225440149, 0.21318292840216133, 0.14193499066396298, 0.14184146400049763, 0.084563522129235097, -0.077074867272261274, -0.1222334490311783, 0.075791033061241839, -0.043085025405348157, 0.16388871337213243, 0.30230740898722269, -0.082976970989161958, -0.10328810997505064, 0.2743611783832281, -0.35028252831312057, -0.15957714307251109, 0.16476301150506073, 0.021117768820378899, -0.20281410291073959, -0.20269082030697796, -0.38055240219114794, -0.12308958010869375, 0.029355382042548762, 0.11156783265636037],
                             [0.12361085228739646, 0.26442913253769756, 0.16599269316948617, 0.12863511055486912, -0.10126604974149855, -0.12470443414877405, 0.15935006512766384, 0.093360381768898285, -0.22746005169913491, -0.023782314322670094, -0.092192746761601718, 0.045160146904591678, -0.097053085050610055, -0.040339874335137617, -0.15273988454565179, 0.056247589908179262, -0.084283780803379033, -0.015684248192293974, -0.082959726456572278, 0.24472857222054042, -0.34275230079563418, -0.036138371276340148, -0.20587356481675789, 0.3104909675336267, 0.029405387871094205, 0.026341565665090123, -0.067406553044498538, 0.39290222873803665, -0.39574143825361019, -0.24822661505682628],
                             [0.14506927110147272, -0.17119509254093412, -0.52528258770745462, 0.031284196712870992, -0.15978039335128438, -0.28797833639012194, -0.21418016679644225, -0.069515750728193743, 0.045059117131395494, 0.0015890942350675536, -0.10596380334837217, -0.1090716491415873, 0.14530571212227114, 0.060388029262088944, -0.10523947634888289, -0.09596386566623849, 0.032575746509283993, 0.0028436060633258843, -0.32076603547188326, -0.20992214013838995, -0.045749317628987846, -0.28047047623169624, 0.12192701739317698, 0.17500709241982179, 0.16106113786009399, 0.085921389336546805, -0.03765923691836346, 0.12022453675567668, -0.22885850451634801, 0.25986103425478801],
                             [0.18274946172365672, 0.018282233750394228, -0.073859239138598043, 0.09405236942164083, -0.32856456437842768, -0.15804671125986791, 0.074699846767440473, 0.096474524229226491, -0.081741674810023424, 0.19530676086790738, 0.065036867722940525, 0.056273488305327135, -0.097816311665696043, -0.031120323386139011, -0.21658995295150579, 0.018495143424122194, 0.087547736584569838, 0.1194965328334873, 0.37688738506435338, -0.41845708705342582, -0.33210860608515314, 0.28617336415732531, 0.23506451954592461, 0.058556877638419505, -0.22061934453159074, 0.062417060668345146, -0.043961885186075127, 0.017169048119103497, 0.22159095868883685, 0.016279629383121396],
                             [0.041080323807063453, -0.031401006164970033, -0.12284460922681813, 0.38170371096906697, -0.033542847138093239, -0.35509948265148861, -0.094940053324982496, 0.16108749323569202, 0.21460321191430162, -0.068013627507091709, -0.20744368167860758, -0.18644632826064206, -0.12840871388650335, -0.28950229850858478, -0.036487280430790636, 0.19589083199036353, 0.10632173266209113, 0.033643180632125326, 0.25703644794988295, 0.28744049294426183, 0.048561383307945828, -0.23800542014648562, -0.21011509526228075, 0.0289144938292446, -0.027127638256306971, -0.086640365749977188, 0.2117397836120862, -0.18416796202048935, 0.22207134476549512, -0.066701007163959949],
                             [0.085827312995544344, -0.23618562997682827, -0.031243622859352883, -0.46637260008716236, 0.35455120808541607, -0.20449037650756904, 0.015768986582428472, -0.13216678249845656, 0.013164112225201365, 0.082757803828077944, 0.10144363906456261, 0.27592028780506456, -0.29711467606431979, 0.016974694296507636, -0.12007385715512345, 0.096109255100980354, -0.1708463259714931, 0.040454633054118276, 0.10360206885194213, 0.11704891666207716, -0.16128332904073434, -0.24789701413260046, -0.065929917064708646, 0.10877107361275017, -0.26408330093680166, 0.16073374004952407, 0.2072036757847211, 0.061897800825570434, 0.073894774079796111, 0.14409516930626978],
                             [-0.17777158881624872, 0.32838456910675179, 0.14280034185645055, -0.21557707071207957, -0.18235027532964623, -0.14452372246275982, -0.33929916014341288, 0.2188982421713678, -0.25801011626138221, -0.08957639541175387, -0.066834344887579306, 0.05529935191719515, 0.18393144641676459, 0.17692774669541178, 0.18263740370131809, 0.23230140984007863, -0.17865039235968652, 0.098460523972065561, -0.01902564769700938, -0.050069966539805194, -0.087995175239472034, 0.0079639882382913744, -0.17327480119454641, 0.2483669531018918, 0.053898648208281712, 0.098750159131210227, 0.060188434476604227, -0.30966257072357961, 0.13264655482037657, 0.26111712745283205]],
                            [[-0.14792456960467484, 0.017996669712666499, 0.29410186123900584, -0.052571756708709214, -0.40148061360123027, -0.00032643372725213899, 0.22247155016439385, 0.29996776749731147, -0.072805224602370891, 0.2657016451238291, -0.16150862280697867, -0.0083836989673604853, 0.40990213114381496, 0.14344711176621633, -0.13700975759838513, -0.009309602863857739, 0.11046934393251839, 0.16238971288355936, -0.13562369312227046, 0.1461788385430251, -0.050520985905106931, -0.080791920552951688, -0.31927508522235987, -0.031279684144055797, 0.26094052297057169, -0.001372678630459138, 0.054278663943135387, -0.061663963650748749, -0.097294029689235742, 0.061057528102935313],
                             [-0.085830678537106908, -0.11668192924878229, 0.013613299566341388, 0.019218030396149617, 0.28119216229159555, 0.086466844027520626, 0.25695144356522104, 0.22400201934231814, 0.19972426515547609, 0.044728178958509772, -0.2280640376138495, 0.12779788219528801, 0.14163049207252063, -0.031265979434328267, 0.12366264339411591, -0.049940393784722648, -0.32759617676024572, -0.092594208654017199, 0.080105556786632975, -0.10667067424404296, -0.19372272376462096, -0.15740571324083491, 0.19950745631667482, -0.11898415625716995, 0.31035217187465269, 0.034287321557595458, -0.027985911570594671, 0.25095167622065712, 0.4638075672738054, 0.018238344641609294],
                             [-0.12624652776212181, -0.024612586876756642, 0.38998249193181123, 0.13286583940211702, 0.00034132340228349009, -0.0054585543433619118, -0.00042695842113154995, -0.29849908875117204, 0.10584051678944495, -0.18539447013425042, -0.3090171724749583, -0.055347284186170735, 0.20432239517873843, 0.041700085977990145, -0.16778220977042782, -0.38190862474790693, 0.13737647924532004, -0.25599859580527401, 0.13485324612525654, -0.092022719601838457, -0.14907574053094924, 0.17404672542217839, 0.1158818122043012, -0.0019611504194620949, -0.14573875837638187, 0.24442159476882286, 0.047876748226980431, 0.13087584314687972, -0.15239699007930438, -0.24965585013875261],
                             [0.19841016853623944, -0.21872758290443736, 0.077859543327598063, -0.17959969716144458, -0.25784168846824729, -0.23913247898156029, -0.23606339107334812, 0.001743097801064987, -0.0031230269852345937, -0.1569566465414973, -0.1188080212148336, 0.058525451681062671, -0.1136980057756963, 0.11599743312191871, -0.14030397141059686, 0.013996885142587305, 0.045454028686647989, -0.30841777719195401, 0.044385269298210447, 0.22429291297962234, 0.003978026811008761, -0.21236673307343137, -0.08435210349990932, -0.26682003970748652, -0.020968555932124665, 0.065847469335752709, -0.43859823578873053, -0.17038944414650189, 0.32795590475554015, -0.0028515148046798756],
                             [-0.12130255646580067, 0.114944024927689, -0.010418145986694707, 0.40340465110470419, 0.097179995604779426, -0.1614926546995179, -0.18187668266948592, 0.0066926874919249254, -0.13036628171826342, -0.044536192126194356, 0.45189253352474418, 0.35986328203463547, 0.078148170135706879, 0.1315364577555011, -0.20464566051601443, -0.19006780607979348, -0.044850674320073045, 0.12639562766366136, -0.075474201633058985, -0.18574785426224705, -0.10189614647303386, -0.19514371252796742, -0.28561957632677049, 0.022976364054349857, 0.015118642475618473, 0.19151802456819322, -0.10911465940751458, 0.13283090757200233, 0.14636890554977777, -0.099207032662370784],
                             [-0.049694088911178047, 0.037951375362798502, -0.20635805500844348, -0.0049949070531301641, 0.039104276629152432, -0.21378512522727944, -0.01605987163175298, 0.21819435804799428, 0.079142232309147728, -0.085863338998041785, -0.12452508647636681, -0.16598480701601151, -0.24214971325691012, 0.4066423036539441, 0.081006991241279039, -0.35229341460675789, 0.13976225493990929, 0.38063440571040807, 0.23781126547110501, 0.11597066803836011, -0.15970150272393346, 0.19388499280562863, 0.06725551193307247, 0.21451615499341947, 0.19513399727681691, -0.050570263800585241, -0.16054607254668146, -0.09542273263551547, 0.033299327096476081, -0.14946937455186576],
                             [0.15708296735981242, -0.14256014575373638, 0.082556573072891895, 0.35605436398594109, -0.063067340996184912, -0.18192139184941938, 0.12205294831446718, -0.012701361488509706, 0.18071495429543891, 0.052901446916372732, 0.29767064828358236, -0.22870053177319097, -0.0048321615050732009, -0.25508041872659815, 0.089356180912071509, -0.25172617534753716, 0.021273858871658235, 0.093505808339665208, -0.013836640206517254, 0.17581690714747669, 0.23369435790835727, 0.24073914645218131, 0.099198627428451619, -0.42406071666331141, 0.21430537811086262, 0.13933512480797525, 0.11417718106319451, -0.13568236917778964, 0.073217868327506375, 0.10857572225707908],
                             [0.057361655665777639, -0.32481291252352512, -0.24762134094000413, -0.3417751243941724, 0.1852337356235495, -0.20320733445517172, 0.19755264181937846, -0.33499401317364674, -0.20274923874535558, 0.084977147158766919, 0.041603388473810343, -0.1639697084251952, 0.093971778418880172, 0.052760566991512457, 0.029998838890137138, -0.28301995401994379, 0.10741881853778225, -0.070396219083075431, -0.2331947898263107, -0.10569806506842631, 0.058821406703809274, -0.23274106249527998, -0.12612757166146515, 0.18574396315828498, 0.16861821015262246, 0.23136388117725026, 0.18481482187806667, -0.067898664819237037, 0.050357041633405569, 0.057614157381348008],
                             [0.10895238806923911, 0.21096898156364494, 0.13529449821189574, 0.026632643640715884, 0.10257980506142463, -0.19510983604387466, 0.17487143311523937, 0.25713635793491957, -0.51051052140159248, 0.13069183565446474, 0.036760657344247903, -0.21899417102168747, -0.21213826137504163, -0.19725470479040458, -0.21902060035848805, 0.0023312631815073852, 0.021124370975613156, -0.30416817610479902, 0.27099482108058792, -0.29045994996256502, -0.14229243552703189, 0.043659133067775364, 0.01150073877859125, -0.019632210365175845, 0.13477077356894027, -0.074695407614175688, 0.019961248897577766, -0.1422775024996086, -0.0014218210190406341, -0.050919053599448809],
                             [-0.13240457787993357, -0.31918785247731402, -0.097488711225923147, 0.030454413976666834, -0.12317743804035369, 0.17836308021088088, -0.1594385070881868, -0.039013030144711094, -0.092144385854741162, 0.088611808390190311, 0.0226584054334916, -0.0029567085405227869, -0.11269664264214048, -0.3248773016295986, 0.12030533229886786, -0.13849689441676408, -0.17006501899662921, 0.033971388916893615, -0.12364329196237833, 0.12187414871533515, -0.55034687930696569, 0.034140886359237288, -0.17171798333279575, -0.088873954578406578, -0.025593699809686017, -0.19239037365877643, 0.11373613206632599, -0.20839107467278631, -0.011927889986656942, -0.36282002299027888],
                             [-0.15035324770054584, 0.20742336316692067, 0.2767526678971105, -0.23281772949342844, -0.1727223658843085, -0.21905404366372594, 0.24818728443192353, 0.020625796169979387, 0.21987648843208413, -0.10969230145490104, 0.32095602823221664, 0.059443676562049894, -0.28934324660788446, 0.15308792142591293, 0.10827538892126211, -0.083814663114470278, -0.065492590513693785, -0.20578497618047381, -0.38929555631779778, -0.0066539850112002658, -0.27971039009799059, 0.10144772063177845, 0.12265891627468112, 0.075375032761291233, -0.1004388817772979, -0.092848912714336596, 0.11476449549438206, 0.0072172319989018243, 0.075411235208733635, 0.16061782302273442],
                             [0.019567538920237819, -0.01512900573986993, 0.13300405893969247, -0.14816450438014347, 0.1419065044927913, -0.082649910364897564, -0.45277938727405115, 0.2551894253879971, 0.15213352679001399, 0.29279188618658047, -0.016467648449887198, -0.21781180538817585, -0.052349658714100057, -0.058043732769591364, 0.21902593492656364, 0.14976112456092788, 0.10710843918410207, 0.022099740743128263, -0.22558601004238904, -0.2494023273337152, -0.15252906200522795, 0.077244236600139279, 0.0015063160492500938, -0.060804842959418723, 0.06152684489113136, 0.45503236639541872, -0.14614133139602811, 0.12336547394647533, -0.15540351302972497, -0.0013805331180960069],
                             [-0.072128567723831721, -0.28231014832327816, -0.0053363249541122423, -0.0078606955681627348, 0.043838679516640347, -0.13666234254842763, 0.15782830026043387, 0.37015353431310799, 0.15211640783207708, -0.47047017023364585, -0.033770825524869701, -0.28399223979300181, -0.069357477892713432, -0.22964680594281478, -0.288821857412417, 0.063053025583110045, 0.048864296230209832, 0.21830389655439836, -0.13575230298429761, -0.1442849037869709, 0.056837251991112663, -0.21517929214108275, -0.10983626101051124, -0.01641538857013769, -0.25159912781339461, -0.044191724165683163, 0.041943359217261396, 0.18091736858594301, -0.079307679274656373, -0.063863592903884783],
                             [-0.14557160905625274, -0.034894357893278841, 0.29571205167257919, -0.22032595551353426, 0.097821673997394998, -0.021820455359420336, -0.064212982865442317, -0.094103631824819789, -0.28682021357794124, 0.11926030733687842, -0.012084830643858641, -0.036121145016420268, -0.087879475995223957, -0.28410403073571894, -0.099696142145713429, -0.20331869108751596, -0.28618567525803795, 0.30840427465691733, 0.06374441807241174, 0.28580270941984032, 0.075759174756906286, 0.17515726178688099, -0.035406640029988778, 0.17045034343787382, -0.17774370034622028, 0.059358105622971197, -0.23794650518227162, 0.24694308975444965, 0.13859523006941796, 0.28197528943636696],
                             [0.18494889031092457, 0.23292863795980981, 0.22398730753526563, -0.084344694205418638, -0.031933178927517944, -0.071550434257117351, 0.0064664019545776115, -0.22143746741579803, -0.1360837430986038, 0.086955166902524209, 0.007696396503459671, -0.1118067504607442, 0.10029499129671061, -0.025716837087164553, 0.11746369394415385, -0.035812449768700426, 0.13643769122011704, 0.40741564939093927, -0.15572841909643495, -0.12357220009092529, -0.022443791490094279, -0.37539959745955848, 0.37068867910406234, -0.21907271010754237, -0.061216757340469559, -0.24147019858298277, -0.1045842690341558, 0.051043927545537375, 0.10397765793665263, -0.31182018382967364],
                             [-0.088378632752305661, 0.13678037165610255, 0.0023598051334737993, 0.030717287349823839, 0.13510321184299889, 0.098528419935686951, 0.17108748847535341, -0.2700494415674054, 0.27658407934280005, 0.042960933421902374, 0.12454316028682234, -0.12726925666180355, -0.095030665094966008, -0.29213794227771739, -0.17924358871538351, 0.21971876469162768, 0.40227051924623847, -0.06013341787307197, -0.0035240945950109014, 0.1974791705841914, -0.13427825283100045, -0.015336527644095099, -0.16751760919163391, 0.19771803340620908, 0.34182278366549435, -0.06563204883223045, -0.33159444500276003, 0.1448371906992367, 0.067438671539639797, -0.10507376362993952],
                             [-0.083936791608543351, 0.10328124328287651, 0.26859279301190203, 0.0050861401832838216, 0.33512451669954535, -0.023925928618517261, -0.11387903968322223, 0.15568614432729705, 0.10406342173915017, 0.11941699625694351, -0.15105727931303892, 0.048092984832644993, -0.14700839344372554, -0.016087585095141507, 0.14708443637899388, -0.12354250006413801, 0.081447743223566113, -0.12948653271882302, -0.16194427999013714, 0.10621604985806112, 0.44490033847278337, -0.011437705081806641, -0.31148368062796455, 0.10513396097618885, -0.086150670918968816, -0.1872511693865965, 0.19457296583889605, -0.16547724586023771, 0.25191707518093714, -0.33586494078595536],
                             [-0.094448576172547358, 0.025348276787968502, 0.066249234113258934, -0.1104043564284042, -0.44704391698778856, 0.20143891335190756, 0.046091339880939622, -0.18563166651854662, 0.017658116236954322, -0.12684179167170087, -0.035106330760715392, -0.033826505895720095, -0.2456797385936153, -0.060726343415025481, 0.064714384657835994, 0.12416940750574756, -0.059529739340629682, 0.21284715004910679, 0.14684263398563976, -0.43907528359516812, 0.17858227152434267, 0.14037366817890171, -0.16910611196943717, 0.057250757817018404, 0.13411840920376844, 0.25644526660393108, 0.099689325532881207, -0.046593216176852831, 0.36455418513036109, -0.13780718366776509],
                             [0.09098964092807002, -0.1522545443108588, -0.033640453236288559, 0.075256060470390226, -0.009813173015419752, -0.11770460337846765, -0.26576401503458402, -0.043409732429323319, 0.12354854147135977, 0.21001644746022746, -0.016584754424307947, -0.10213494346643864, 0.21140228402037198, 0.057622047167478138, -0.4833809954183757, 0.14097856808707243, 0.049764620010950673, 0.058413815950872881, -0.15895179452692143, -0.13172266512782851, -0.082839476755524485, 0.28755102690389073, 0.22684402213607752, 0.22926021707057653, -0.057171248517558379, -0.21995087146082812, 0.19085087322856845, -0.11014419113277811, 0.39295809850980701, 0.083469261272928752],
                             [-0.48332940692680199, -0.10030560664332105, 0.021117915551719477, 0.22589688298142452, -0.00038493406109432141, -0.16745666790326957, 0.10741426871898475, -0.064260622065333589, -0.086099031469170792, 0.17316615154146153, -0.056555271432693614, -0.049731843537772914, -0.20788319283872356, 0.08957948194532088, -0.097789776789612495, 0.3361563298776904, -0.090780392935675594, 0.031202286657975371, 0.0056045731537270526, 0.25419094259947439, 0.066231827616947861, -0.23879111762272484, 0.33574204769953736, 0.067798629830758406, -0.06333402029067195, 0.33250670648070452, 0.078790492297505343, -0.21930279877841799, -0.017310934290273101, -0.15004083634402549],
                             [-0.31039273531527567, -0.12597935057529938, -0.10028447960595217, -0.065342981960359495, 0.039784967625058655, 0.3399816262867465, -0.039632998269573325, -0.02646806041840722, -0.078075858951172458, 0.18909924014204943, -0.019005861728043284, -0.011087897391997566, -0.32755021843326165, 0.23950225942537032, -0.31971371949437621, -0.19594467967457185, 0.10310692384045779, -0.054883794016347534, -0.19965683927311126, -0.15143925068281905, 0.17955994470597481, 0.057866056627203552, 0.078297393368291793, -0.42208614182859716, 0.11791861010249119, -0.19179180434244461, -0.095573989179983374, 0.18681590723611774, -0.10669570727824765, 0.063183452224500239],
                             [0.0027970704033845727, 0.16511439708630554, 0.068499393202630127, -0.068907347760665358, 0.15425054063514115, 0.27388749386679406, 0.021838115345235869, 0.0051821077283962349, 0.20013477357592907, -0.11108623705131646, 0.046263808939707843, -0.098480077277934452, 0.11440508758994528, -0.046262874941639567, -0.21011400013750792, -0.16527689934698517, -0.35034805991035706, 0.053159525241300645, -0.14251970779921794, -0.15263045524399699, 0.05974550386854232, -0.093530058398567248, 0.062303473558217637, 0.10012236809197057, 0.088396137064212107, 0.079147937196949278, -0.32120902709267529, -0.61244149902106715, -0.15180824170828558, 0.047610225050054342],
                             [-0.08762718532232025, 0.26456859818203854, -0.19193754518266132, -0.19991906397900561, -0.10967286615653349, -0.19109537081743402, -0.24052963452186116, 0.097000688894268897, -0.042540070367188279, -0.22268907747106045, -0.19251122385455596, 0.37651379360308629, -0.01999394116189988, -0.38396639353329354, -0.1747833434786048, -0.12319093709756113, 0.047131607811922806, 0.020786193380932284, -0.16726962073784563, 0.10680398970814241, 0.10429154336493289, 0.022386225848685302, 0.24045742935119205, -0.0054310152274137883, 0.36609826347774582, 0.082046632438102798, 0.20051517011100861, 0.017498499558549676, -0.10124799855544604, -0.05603132387812336],
                             [-0.0089989142625596201, 0.34817745900691899, -0.037326030499176988, 0.16162860347931163, 0.023458939366914407, -0.019788522210110276, -0.2685254653583643, -0.21386213392346357, -0.02208990731069968, -0.1873342075066817, -0.19055620142596386, -0.47788904696728929, -0.065445472193964349, 0.15595850091805474, -0.04794733148681414, 0.056205449587869299, -0.3006771705260135, -0.030167828456549747, -0.088107589088867455, 0.1599296465256228, -0.12108845038564288, -0.18067776629593613, -0.23853454219976902, -0.12039261820928919, 0.17939347265452155, -0.04130969301275448, 0.25949504615239583, 0.13170849506570667, 0.050365451076454515, 0.18326615484630449],
                             [-0.2253025930026665, -0.097087660049649735, 0.0071150683056818249, 0.14053559421214895, -0.21032663740173271, -0.33909852379927785, -0.14243184396962885, -0.13112929208002688, 0.28241931161824385, 0.24677139452761693, -0.11966344041638491, 0.01737503880361219, -0.070906310184338683, -0.18877078586540047, 0.13087866351377028, -0.16225338603359732, -0.084629726597659577, -0.066508849630292743, 0.21635974105944974, -0.30494454549747096, 0.10402212398590135, -0.28110684104037392, -0.038096347098090337, 0.15141881677146787, 0.037853942793929125, -0.33855408541596532, -0.09713856071058885, 0.0022987557618664089, -0.18583676794859133, 0.24139645466182305],
                             [0.04574725341747006, -0.13163509266731585, 0.33834564284610252, -0.11340671987078772, 0.21244209245701462, 0.20007281357960749, -0.16521747255452246, -0.0058940475928823989, 0.085892923695070622, -0.087251593342831557, 0.07826361664404928, 0.18152134908863518, -0.17699868698812407, 0.023029586582948344, -0.070933150206035508, -0.0027785868193522605, 0.30535027309920543, 0.1906419256560041, 0.32066973060141979, 0.03639110628273054, -0.19897409365384885, -0.27071822966530568, 0.014408649255679286, -0.067691842191476448, 0.083524715792111473, 0.032863781940398802, 0.3567640802501269, -0.21148937086132957, 0.004796312806579362, 0.34393503496458827],
                             [-0.19927036460086889, 0.20772539781854801, -0.20839063092404411, 0.18900636165592294, 0.098016109876046406, -0.049109683196376798, 0.14195952947033508, -0.04636091366617838, -0.10268047377666022, -0.038319480126472835, -0.3621265951072743, 0.074073310724154948, 0.027365704924309696, -0.14964666676573551, 0.15118793397277683, -0.029199322584200035, 0.32998658857345087, 0.098853275811338334, -0.19460662377755295, -0.12240652770391736, -0.16603696422724681, 0.097762744362647203, -0.11360686792243191, -0.20128666656048486, -0.29681452289097693, 0.068014410603103356, -0.12545564894664524, -0.2513161486529078, 0.22208784571693219, 0.35379291857243489],
                             [-0.31578615366356727, -0.17516958817340342, 0.17353321723865969, -0.14412668646177434, 0.25803248561334124, -0.2902237831168627, -0.067116911693642742, -0.17636029637174963, -0.13996816118206626, -0.30114476954113228, 0.072241898993994219, 0.051336737353499674, 0.2268448695387385, 0.10838341718875465, 0.1449717255057705, 0.32459028410655211, -0.06673589001942723, 0.086072516947873365, 0.041749121459061969, -0.1312076032274565, 0.024751903040605205, 0.29773207460155715, -0.08530857411994415, -0.2175963132664275, 0.24719116848814934, -0.23406950565222895, -0.091938813828015206, -0.12201080550859437, -0.098030795036362445, -0.032103174384353658],
                             [0.34888372791121991, 0.019051866425770649, 0.013473690287557155, -0.039452256446656099, 0.14376907069687872, -0.26283638999093023, 0.24266245668482206, -0.19532834997862863, 0.21365068938702667, 0.22842671461954728, -0.25946987610160921, 0.28232183766372632, -0.26270638061644763, 0.052673582102423941, -0.25580459203802247, 0.14307442612668761, -0.23492423554268851, 0.22172263746541374, -0.022575563725747268, -0.04051943551629026, -0.10001256425302495, 0.11159030644967576, -0.23790322179077331, -0.19572011687165811, -0.048661723363336358, 0.074681079189509281, 0.055377936314129676, 0.00017763249158975249, -0.20429531102318454, -0.10113252178568242],
                             [0.27116323237325179, -0.2715702361444875, 0.25546821705574191, 0.41409521836740387, -0.033709588477137703, 0.09571368136757967, 0.012143755570647504, -0.021528248402450992, -0.24569102781533239, -0.17687778656062236, -0.22959859328182633, 0.1177515156229911, -0.23525923445905317, 0.048956364430419404, 0.14008794605114722, 0.059455485052485588, 0.017679235170260568, 0.014638863386409698, -0.3761950699820264, -0.052948394132593564, 0.023686348916173695, 0.016959949319254718, 0.097147797087243831, 0.30141336630213689, 0.26920758585612303, -0.065272918305088676, -0.1238774718710825, 0.029281874500711593, -0.099221183926121656, 0.13102745248355457]],
                            [[0.17265967132890997, -0.17059619346211835, 0.044528140008843503, -0.0063836316948696981, 0.10597376534697826, 0.042937120718047464, 0.17165275495927429, -0.027287334249191449, 0.12585884328647226, 0.12178950599530648, -0.088531644170336196, 0.36165153602943739, -0.0068703221809429662, 0.23849460459485877, 0.28682753918053383, -0.16551316245456216, 0.081398007956857241, -0.31652128995974438, -0.23225572950924236, 0.21450170363122739, 0.38030862771919483, -0.14678613851114669, -0.022882451371946892, 0.27273579717664098, -0.13388666424524207, 0.25730854731104269, 0.10807996966455509, -0.094628417757169542, -0.0616623804736759, -0.058810909936391695],
                             [-0.10224709939825027, 0.23762086176549163, 0.082724032471002781, 0.25965686936452687, 0.17388188436897933, 0.48351154845532207, 0.056118605123124915, 0.17347335591563109, 0.27554769025344739, -0.1141052706841221, -0.31124178101280392, -0.20879265091361812, -0.25055452865070349, 0.05732842654558673, -0.025359776911905128, 0.016561385352564281, -0.16230801394048586, -0.037989733529223635, 0.17871807403704623, 0.020370567823283579, -0.014150600701672964, -0.21524473699488791, -0.01774204451191377, -0.036381297334535656, 0.16291085230430702, 0.21969193278718807, 0.0034928287374209224, -0.27718395668534251, 0.065389551708817273, 0.030460244378529469],
                             [-0.018149948693069146, -0.13902214123115583, 0.11850864450504955, 0.12069143572946896, 0.38789696954282393, -0.062096197859479792, -0.027139751143364654, -0.020789354110218837, 0.057175133636014445, -0.082269175212458717, 0.038737693414051519, -0.24035928277689314, -0.13287419295835709, 0.33680262271260047, 0.078850069307585452, -0.044403279963586943, -0.0091584182546436237, -0.093054893543691536, -0.33874887321361635, -0.14827246229485974, -0.23659134521254857, 0.13209887416509333, 0.11538206819932723, -0.1445477642778133, -0.077168555949092055, 0.22681745377933521, -0.3284350776499062, 0.39966090188402953, 0.037288428552551205, -0.090286868817235189],
                             [0.18973115999154644, 0.049585276395050011, -0.11059181574873889, -0.28335041125765886, 0.019158404062465776, -0.16130714869374144, -0.096843094507971614, 0.19644607966269903, 0.087875591579370846, 0.069276969297557403, -0.057910160003395765, 0.053714186323424895, -0.018689641327830329, 0.27134145370491225, -0.040384440913729856, -0.088001375081179389, 0.14337406893452342, 0.081784009280700828, 0.3373235832649521, 0.39547511094891508, -0.15067803476007793, -0.26029845075773578, -0.24189348983667147, -0.26174489501401188, 0.17698760124072352, 0.064650928708787997, -0.14439831301374578, 0.16429628874361549, -0.14030989465175722, -0.27314458597527552],
                             [-0.12362458368065755, -0.042305813333157596, 0.023148484942872905, 0.25476233577488377, -0.18524683499367117, -0.024335101040514714, -0.27325000619621947, -0.051048817370073815, -0.062519958060523989, 0.33667136262776165, 0.099018499133799162, 0.072602618343623679, -0.16075731109026814, -0.1306502386345211, 0.2304310802071895, -0.086389796260400803, -0.2613065953145946, 0.38432280151921672, -0.11916551454295136, 0.13862356580658788, 0.021234010318286176, 0.12163608604532862, -0.067913244466438302, 0.083530312981575178, 0.056082439765550773, 0.19177358036000616, -0.30450796330333307, -0.20112587755488073, -0.04406318155733125, -0.34383524660322534],
                             [0.18691076650655772, -0.12663150540525089, 0.14628149085041567, 0.16988595675220677, -0.12857280640869334, -0.18171136513122702, -0.17432681951698598, 0.20366437581921867, 0.067409207976240004, 0.12330478967595941, -0.23117905096220456, -0.044000739922470417, 0.17887933596419034, -0.15593624041694584, 0.37030174669430793, 0.1642208326736205, -0.02166561617665878, -0.13445667638591741, 0.0264219648356523, 0.034103781289058811, 0.012313593767531104, 0.0026216299372713758, 0.08284142339063387, -0.088368761988068242, 0.35853765364506496, 0.022123597972820624, -0.17156145823775393, 0.11012763438338199, -0.15372809918700078, 0.50233926992325861],
                             [0.19197827045828766, 0.038913306651523691, 0.043654239962446058, -0.041076147417489932, 0.31265485336680554, 0.020118442963580497, -0.13461073048417774, -0.079320706371385441, 0.12120811404969925, -0.035219958427276793, -0.11314393767217593, 0.30036338093585496, 0.014301496627637834, -0.20818697696391456, 0.083634305369018294, -0.12517366806999047, 0.22222779907223197, 0.029214388085648368, -0.19836982779022591, -0.025853240976097907, -0.092132102003297536, 0.06285752304162584, 0.10669113410026321, -0.50796034026109649, -0.088525242945607485, -0.25130468745445145, -0.12545456858488613, -0.42482186660648624, 0.099930466663235726, -0.03183369128788284],
                             [0.40268511626503095, -0.15344804926880376, -0.17976013354544365, 0.035091859611959438, -0.068219819529808698, 0.31945409194191571, -0.10289316630372319, 0.024149956291496574, -0.1103743521992092, 0.066442980858100145, 0.14841774988189715, -0.12225021735062669, -0.1977644800424227, -0.16320836402043709, -0.18245646637586732, 0.035232905659188983, 0.14726043982464651, -0.19731185568121359, -0.27059771954366629, 0.15892398461829041, -0.26984955937552163, 0.24027453791748654, -0.39563090027984915, 0.069303009925261574, 0.14230329109301126, 0.10392513903211521, 0.13114111283963842, -0.044556356185235263, -0.013939260680143834, 0.087323708469376662],
                             [-0.1559506490006862, -0.14245814102080653, -0.032135971624251698, 0.0056158862068592871, 0.28801031798164162, -0.078657747689015414, 0.1119263127251902, -0.35054429759695144, 0.083866749033240789, 0.12016216297486172, -0.031413192837896189, -0.26749498516536829, 0.20979623540151157, -0.17137246355640337, 0.11801079577335266, -0.34823910801442071, -0.085493689412094689, -0.24247393777133858, 0.2564906760907027, 0.0062719732680763954, 0.052243492564305501, 0.27817406905122222, -0.12989094270787505, -0.051716374569227168, 0.3337374439740794, -0.029777515564867827, 0.17411906112420575, -0.035538616963850106, -0.10885432778077024, -0.19974728539932574],
                             [0.14608167029870317, -0.13951916616054644, -0.13455897615104018, 0.20745866688566555, -0.0096894458947832419, 0.094017107976953812, -0.18205638607273619, -0.30435139040537956, 0.096055712040655342, 0.22848034239090922, -0.18231182152422634, 0.089063574319760017, -0.0045838240800369781, 0.063266956346069964, -0.046264642666677298, 0.32038190724486026, 0.18057553029175985, 0.10781798077156211, 0.14489642688263463, -0.49652082948021786, 0.21588146121011709, -0.14574721164669383, -0.22134897411351379, -0.18393380372663481, -0.0545344579158498, 0.099191265308829463, 0.13438250492892181, 0.18469944638873365, -0.06715553430117123, -0.14143480618754259],
                             [-0.17022596563477999, -0.072877851503180685, -0.17441043069206144, 0.18513142012139128, 0.099159327314969944, -0.13255308863027335, 0.37437833233139112, 0.22616165134482019, -0.3225706048989217, 0.18379882579596263, -0.05969062776215027, -0.13080576673291475, -0.15462648307317436, 0.27818592533073583, -0.059999937715440661, 0.14905480011914291, 0.36041788454374674, 0.12954609201469308, -0.10293242163818772, -0.012794173405256409, 0.1873654586122542, 0.12824679204064732, 0.027482011435946099, -0.067439038251833144, 0.24944546395575443, -0.15958402281678957, -0.044581727447637991, -0.26325354084891339, -0.15293348137407378, 0.0044840887094554872],
                             [-0.20277580842584378, -0.27785282332619698, -0.11707133325708609, 0.11795468292097404, -0.26395354998946002, -0.025011237268011667, -0.10358542702958887, 0.21975109874677229, 0.20800997931920534, 0.2895828676640535, -0.17779453436331896, -0.014783631559665765, 0.006844578678037264, 0.16588671340992001, -0.21024384526391662, -0.31849019965363168, -0.21085567622951942, -0.20713604478607381, -0.2288573168474112, -0.11530593224795856, -0.1701977428383214, -0.20854291611220646, -0.019206538832676808, -0.09083750909033049, -0.053901919396259622, -0.37359676648002249, 0.12195966286794868, 0.0018311795859976456, 0.021549802533197313, -0.025445248056099733],
                             [-0.0040616578685088878, -0.32083155836538013, -0.15262863140425981, -0.08925571618872763, 0.015565020027894873, -0.21336088726945859, 0.15891099799201377, 0.30100290077400121, -0.033837095844465884, -0.17914990565797817, -0.23715429505107388, -0.15189834054467397, 0.067175600700647181, -0.47282847497461705, -0.068883792510102695, -0.078522169908122233, 0.12707186748294225, -0.01817415018128303, 0.020762430576991637, -0.21399200392048484, -0.046255307162660866, -0.17979466690248569, -0.077379365805520017, 0.11941405051591887, -0.21052956327585468, 0.31638925400411561, -0.203937798768388, -0.12675056873445198, -0.033518854964717369, -0.17889697324973197],
                             [0.17679670753631072, 0.084805662865544085, -0.063683795581203753, 0.10936169061343094, -0.27082406685481891, 0.14409696208822789, 0.3919887036553088, 0.067475062369007674, 0.2841060399189469, 0.12347004955535379, 0.074283142688997009, 0.15258486411392611, 0.11687677389383212, 0.062558659988844231, 0.043059580698556719, -0.18011697538988866, 0.17320369287871273, -0.0028853149130633831, 0.22942953946666156, -0.19182689937443123, -0.062968969673750888, 0.28349937186549284, -0.035898358923368109, 0.091796505109161611, 0.045173848722502026, -0.054092284745161957, -0.37914925938972011, 0.092545585048269971, 0.38129572700432923, -0.020467516191373339],
                             [0.28616732394618077, 0.051249134987575398, -0.034547899045852155, -0.052532126156085067, 0.18827038832906146, -0.052834077569846385, -0.060831452279830729, 0.042024135478454745, 0.060103757702183964, -0.01380857135417494, -0.049356403022571098, -0.24170466598939389, -0.1961078753696929, -0.011465266151271148, 0.28866068739739381, -0.36120296801149654, 0.12317947559851497, 0.46900963888826319, -0.060636680446816651, -0.1542141883786935, 0.021216995771075844, -0.1782395178729001, -0.053335808252372177, 0.32681559101969293, 0.047949902272870513, -0.27006037467208932, 0.19819875435964548, 0.10937613826499101, 0.089977631458634688, 0.10832329641995475],
                             [-0.14013944373933926, 0.28071806131459998, 0.2480081991246757, 0.0057083070332942807, 0.066891855465065875, -0.2128217341194798, -0.1077618371870918, 0.2597043334482419, 0.069486589400947915, 0.051094049954128432, 0.13474189608511952, -0.17915888925975859, -0.028319286123665355, -0.10778617695581293, 0.11955573141272949, 0.16975829317108904, 0.043729900803210042, -0.24551517954410337, -0.12041204560767912, -0.01912942917378847, 0.30475872752674737, 0.0027448512902452649, -0.52176204453907704, -0.052379289194425145, -0.099757411590666076, -0.17382300919058924, -0.020987832949480544, 0.031842225876537462, 0.3100821078579572, -0.1235984302657875],
                             [0.1993483235014685, 0.04888466855265975, 0.13084301834192177, -0.13939816411144193, -0.0037384304215691468, -0.040434926467518596, 0.36810987312758192, -0.12495438379075258, 0.066758584842693799, 0.20431107611877194, -0.11584472097795109, -0.10387913198655827, 0.14497467019257043, -0.072168878847118242, 0.14119934442562534, 0.44788846080561701, -0.17482785246276072, 0.010233098498009352, -0.23334325112398852, 0.031503953131148704, -0.33114951379780139, -0.20959089124791966, 0.1141036424170621, 0.10117946254088804, 0.15687284753906558, -0.13022648468274825, 0.10614381359899712, -0.050860808934059476, 0.11157358166263452, -0.34719889317672115],
                             [-0.097897068928198133, 0.008047819962905477, -0.059132906030284149, -0.14645030223722511, -0.21977482975686069, -0.077702700726361359, 0.313689968483854, 0.045411718906309101, 0.26543956566666066, 0.099662591762540401, 0.33261351284522023, -0.085283626318942984, -0.22392436626577009, -0.12789266602529881, 0.18848959052429243, -0.075961554163345227, -0.021432647457607548, 0.14477028713746848, -0.12846469177167574, -0.049407374366430584, 0.039408289621780085, -0.048140445994854994, 0.039075637416721667, -0.47380418168576072, -0.0097547985339428503, 0.32687271573112425, 0.31383562490631228, 0.04399915254834743, -0.02889598566190444, 0.16142243744822668],
                             [0.026620839796899536, -0.27920946226581161, 0.27130341205749559, 0.46434722958415892, -0.089478251154750568, -0.1973679223262087, 0.064506275526126602, -0.23815805648245311, 0.19892036109124178, -0.17047672676484701, 0.22685062770914019, -0.068171565917780924, -0.25238295856397708, -0.13632883897959411, -0.1291216715947052, 0.049377403436847205, 0.27715990739522856, -0.050819930468893257, 0.16115308770948264, 0.29851113920671651, -0.040523561343931536, -0.24061940690551276, 0.10242705826112353, 0.042315785443037837, -0.033220213233799041, -0.16152389559519253, -0.0074863262403207951, 0.013767854956108825, 0.042561133998360194, -0.050827356898363311],
                             [0.29067454180744662, 0.097617147391137762, -0.287222384104102, -0.052626982046184483, -0.062599239528674494, -0.0200626321291314, -0.14530419028807476, -0.014879616508242354, -0.10703974845909829, -0.060778880106030352, 0.3399506184468713, -0.16031207849185503, -0.11361232970495534, -0.020218947208529903, -0.051628641862552699, -0.05853715236911531, -0.14637809314500591, -0.30632361973609534, -0.022489912286713858, -0.20124303563904905, 0.31341333823366713, -0.27491106477442534, 0.33907682455677518, -0.043986293249181213, 0.29379439757540343, -0.036270263314533341, -0.20672327555412326, -0.091397985686312369, 0.082477464456924596, -0.1634989123467063],
                             [-0.06537918309008306, -0.50623795484482459, 0.32843498635307283, -0.26171381473850963, -0.051197210511234756, 0.14233306926021561, -0.22142661693968438, 0.1756603939243786, -0.064130656461787783, -0.083005421017656497, 0.086563775175090188, -0.010269458463744455, 0.066321929565301294, 0.19022893137839808, 0.032892475479182698, 0.068493365637786061, 0.093458780163231669, 0.11295661218618605, 0.11384468093002123, -0.086214068198583432, 0.051453878145906247, 0.082562336909877701, 0.10658616040799851, -0.020756897384564838, 0.24567979008458543, 0.11407204906739321, 0.18729862123792734, -0.15990603505192619, 0.43362220795707274, -0.10082621392080202],
                             [0.11430624988160347, -0.29582721849558286, -0.087153287622432088, 0.12293264467039289, 0.066136823175395168, 0.14344790601689672, 0.20297282217690824, 0.19811156630346988, 0.052257414913998587, -0.46222482027900641, 0.13859446839649434, 0.19947978456236523, -0.0025967011207278911, 0.014996484178350821, 0.16910844856845317, 0.12575107755637352, -0.41428274832480866, 0.12847131293803082, 0.019244957673732032, -0.036129670269323823, 0.13484284746170955, 0.095374730803423402, -0.2288790709639526, -0.12162570253652868, 0.046657717829661285, -0.29849128438018341, -0.018820220148734676, 0.092001912031823188, -0.22290057642959146, -0.1313141958783445],
                             [0.2550784023788546, 0.072142898764036137, 0.22883560941534473, 0.23529300228315667, -0.19239156188900502, -0.15603080086678137, 0.19089790805441145, -0.17235181068062916, -0.51177948272915808, -0.14221501017317989, -0.1871728039115009, -0.021732451746341627, 0.096316778784801452, 0.14318505945840546, -0.047113792926536883, -0.28479082144496992, -0.21281986688181989, 0.028079743144496017, -0.017800365937389227, -0.033111610526708052, -0.014424073363594421, -0.14263685192810258, -0.20814235092085415, -0.2608066778161876, -0.0098181739728701554, 0.14927048070817081, 0.064658614978372081, -0.060718291629787195, 0.22552729246364936, 0.056939607237655128],
                             [-0.18197436026788277, -0.10088538385942075, -0.27181875360672952, 0.14289288741192469, 0.30031727483476445, 0.031241278451884593, 0.016616986364484162, -0.076349200983893112, 0.005777843133980754, 0.074767828627239671, 0.37936888963312593, 0.061779500921376414, 0.4212646578571993, 0.071938220056288638, 0.017076178170970867, 0.051057833162133068, -0.03625071316216745, 0.1270825493679415, -0.03321118667317071, 0.040781862017774957, -0.15382837174226802, -0.38548179702344704, -0.23159398110727566, 0.05470298972353331, 0.051617988835274908, 0.092151209051527502, -0.1147041510939879, -0.14738711408499389, 0.20145636609489181, 0.30082307636025107],
                             [-0.2565121709347456, 0.044997692595430079, 0.19266778486569949, 0.0093242996118609641, 0.02173736604509393, 0.39319387591168542, 0.07692717028157213, 0.097944807810612058, -0.38950163623224632, 0.099308961277387642, 0.11046005435903757, 0.24556653469062259, -0.07613621939355443, -0.26186447944258628, 0.22957776960079282, -0.15347057427390395, 0.2245774414177619, -0.14280674937456769, 0.0279063117187409, -0.11660943400221233, -0.14600292428300121, -0.27950155788673869, 0.018146933688521091, -0.049787110466166663, 0.13282348154582849, -0.093970941233523259, -0.025408993509030472, 0.31621266117377606, -0.10365689537053759, -0.11988391627343244],
                             [-0.021776092622275613, 0.24450098728408451, 0.17678944967908422, 0.13230530348904418, -0.016378211290615164, -0.30349743522454692, -0.080772671725407419, 0.11414732764707855, 0.17227888772782515, -0.21219149446970711, 0.14711295064477162, 0.32966503164175837, 0.039014155061165283, 0.088011935119654952, -0.1427706446314469, -0.083470331286615726, 0.0900141859982036, -0.023663268236976037, -0.12027497567628158, -0.35147388984413969, -0.24059620686782937, 0.025470200579092585, -0.089741606715022737, 0.1916569443781701, 0.37407866617422153, 0.17374099365391851, 0.17922423998201459, -0.14061946518338786, -0.22897031365290815, -0.11393248011623514],
                             [0.11875526233148871, -0.062971836647265245, 0.47987312339675114, -0.22306585660833195, 0.047410502651128589, 0.17668616425068864, 0.14035689782051386, -0.056183870691101499, 0.11696607551009867, 0.18762617067768594, 0.11281400020993256, -0.1118801956381795, 0.14118983091623821, -0.058035705429938252, -0.42763627378063518, -0.10953400798841971, -0.051277861099738066, 0.18813805038503637, -0.14582949974824372, -0.064784150314935493, 0.26472485713604244, -0.10335062719799935, -0.1013357356238605, -0.00025526044793088134, 0.068201226779721985, -0.034841770234155273, -0.27927055480965374, -0.016265394927288224, -0.3159951446417863, 0.12156324729221113],
                             [0.27547440068734297, 0.07432454065716787, 0.13510623267708641, 0.27978550880888542, 0.06970791220627473, 0.10170607624956352, -0.06319951861742526, 0.35671107565449239, -0.059754285878841046, 0.18922934445792763, 0.27801854738454673, -0.21243265810149242, 0.34821140867344996, 0.080204061908831059, 0.080493600476404983, -0.037397706603058654, 0.03921020840330839, -0.025462538153387504, 0.20663583238143626, -0.035744202701763865, -0.080766227176144803, 0.076907279135896886, 0.19392658060012469, -0.056420250636553676, -0.36675412759374787, 0.030240365541620375, 0.22996556333986515, -0.11073902537725418, -0.2261319460866611, -0.16479490118084988],
                             [-0.13068630638012288, 0.030528013733224165, -0.00222411335792473, -0.11899312022767068, -0.41204896781476419, 0.17796451428540994, -0.083412539052173953, -0.24195808972208363, 0.06700277742212897, -0.31505770439904074, 0.0056420092100171529, -0.31251850458788882, 0.1967850310930328, 0.23275146118807677, 0.33914666655530562, -0.021410815098845411, 0.27386490355479604, -0.052771620508095543, -0.14261351344130752, -0.060348324704908772, -0.069747518293987287, -0.082802310899568701, -0.14010064226572211, -0.013271650966204404, -0.076068983962355771, -0.074725050737022472, -0.15908601113807425, -0.23355105722571506, -0.25036948151968497, -0.061956378522407263],
                             [0.047253970930989243, -0.12079984397238869, 0.14171040868426193, -0.22040649886631014, 0.079503853421717854, -0.13305693634925186, 0.0592114683546177, -0.089659014989872873, -0.10081417935043727, 0.18973792031432998, 0.14133854047898906, 0.044764843878707723, -0.41285569851187232, 0.14477245339268355, 0.161828046470336, 0.07057240985260646, -0.18738491553840858, -0.20808074894097717, 0.35409261591597635, -0.26707164836898695, -0.2555019489470689, -0.024525891369259506, -0.14833388076886786, 0.092033915747744471, -0.20108064367214451, -0.076918726420794531, -0.14110574024169584, -0.30135653457878747, -0.12734992488963659, 0.20845075057262799]],
                            [[0.16975577901550706, -0.11786083906018149, -0.18940575105972024, 0.19370106443664872, 0.084474117937114457, -0.01972369005398409, 0.077488105906758975, -0.1427204820655649, 0.065401208882973808, 0.43336476750559561, -0.012214576720589791, -0.077344930023622152, -0.022761668496927019, 0.0039565370856732241, 0.27378230961370692, -0.043198384404221982, 0.11924554101254471, 0.21461366560508713, 0.0242890563243932, -0.33792699448895525, 0.088321244891788664, 0.36333666279797389, -0.31586871476838335, -0.2905059762861299, 0.08866398795304252, 0.027379367880753961, -0.096925761318563661, 0.099830478710792439, 0.038952661744258016, -0.21423186606878047],
                             [0.0081020437538911437, -0.30691354334280924, -0.12998565574643139, 0.19429315006814898, 0.069001710466222568, 0.014483072813031513, 0.26477652477742086, 0.17085433734162031, -0.2493397536717834, -0.096816130600129752, -0.063400692302241907, 0.062595840195108443, -0.029922073936163005, -0.19849346485662533, -0.16361182363137927, 0.016636730024067844, 0.16826838354301876, 0.17084051235609327, -0.18034557314590738, -0.1160479863438329, -0.09153478096821209, 0.055131699938094393, 0.015649519939354147, 0.43789430073761276, 0.20363999904157357, 0.42838896158659107, -0.17164636153573412, 0.1221780926043485, -0.12737157943186253, 0.086571938860097869],
                             [-0.0065502561859922225, 0.22515602789184538, -0.088070298784168541, 0.21841939709544353, 0.29543013238895388, 0.014142259594359798, 0.14019130583909797, 0.20862049371899866, -0.39510786175804175, -0.01352722686343274, -0.38350463980027466, -0.21232971495438685, 0.054188844492264757, -0.028492469878050874, -0.012499507381018479, -0.068191747678728293, -0.27825751628405315, 0.0044002157620399206, -0.16468150822480607, 0.3060450250081459, 0.045164208158753869, 0.16526067214275167, 0.030880274721432885, -0.16012123018332258, -0.054131549783792261, -0.26082079447632883, -0.094055986556967799, 0.22664882904489297, 0.0061614859896737366, 0.027394963587834206],
                             [0.20349704654548592, -0.0023556095877003808, 0.11756309400148449, 0.068685698736449294, 0.028544022137172834, 0.018290817720432562, -0.12783692732264273, 0.02814629022836607, -0.10626905837513491, 0.06447945060011688, -0.15362797888056812, -0.14068613180403439, -0.20173061721288574, -0.17097090408147619, -0.42976827388063377, -0.22721576154008027, 0.15689560631117669, 0.044625889363086813, 0.10921497791970092, -0.31315318094353672, 0.0074047334020808601, -0.35229549915779756, -0.11679556841911626, 0.14105087916232342, -0.064851722783439758, -0.29535200283619018, 0.20011504640897806, 0.18729011470952861, 0.1272602675145118, -0.2821355897638167],
                             [-0.17559061404490106, -0.079712866755496256, 0.13294543862572869, 0.077217987868448704, -0.2336230620604528, 0.30931477447183114, -0.18894934345900402, -0.16971458800433925, -0.11755567948722546, -0.0070946138864597282, -0.12323021534963993, -0.20261558962642537, -0.11284565027887604, -0.023325965486662058, 0.34007271709175152, 0.074078991809033962, 0.015190318463833088, -0.16045376178040605, -0.042402031194588179, -0.012254404256268383, 0.2771840104388722, -0.28372501605602635, -0.014541911104265077, -0.04298593471206956, -0.15801431913295524, 0.25035653172388594, -0.070303550709993737, 0.43222187829535291, -0.22928286486821264, -0.024542486509799587],
                             [-0.00014808022367338375, -0.12101561523051081, -0.28139160706889588, -0.2270610402500258, -0.015905156777884517, -0.0042602777361275025, -0.27445955921274923, 0.16621102120444164, -0.26435116004273107, 0.11809574654944228, -0.13665521110613457, -0.19074192064369444, 0.33352663889284584, -0.1328823241101981, 0.049220478597068025, -0.21573468481383573, 0.27845323981971903, -0.21871577285985291, -0.13003310365627949, -0.10223344681716988, -0.021391352589570964, -0.079169551613954517, -0.020914883945538389, -0.16295013540014699, 0.025281077504649627, 0.0033855262608169885, 0.12605618032254923, -0.35982362441625881, -0.29590410754775653, 0.12092623760851154],
                             [0.025436238029076581, 0.31475817083960539, -0.085045038250398872, 0.10761615347239505, -0.049778603785044208, -0.12884614801986105, -0.15682819149659033, 0.38117158055557859, -0.10587128811065624, 0.034990089890842652, 0.14370356611820331, 0.20368394330963988, 0.085704374787978807, 0.082688028256102455, 0.227878127633272, 0.027194316308288717, -0.26353108169571537, 0.018738537294281585, -0.18250382798097248, -0.37382051467770366, 0.067165740595502857, -0.27781660092593541, 0.018667563194502825, -0.041818687902922723, 0.27387498471273963, 0.14509690322339169, 0.17595134240361446, 0.12176343964158907, 0.26147420917509312, 0.11926659396575798],
                             [-0.204642544584695, 0.020449883753942855, 0.22748482161960246, 0.21839979913597521, -0.26862987520734083, -0.25156128639738473, 0.37315270527581473, -0.041006880744674547, -0.089327430655716022, 0.25182726239448594, 0.09023333713998706, -0.32082995207139442, 0.024251561120514253, -0.003420494257472565, 0.087138589350945886, 0.018452622777351119, 0.20752668176229272, -0.38830045195342611, -0.07245081277999485, -0.062370647198211032, -0.028065563125857378, 0.084054262774228131, 0.28761765812760459, 0.099474958938980784, 0.13681386807071866, -0.12027612684728968, 0.13052116352553203, -0.045388390387978428, 0.18679046344306358, -0.015980409857691141],
                             [-0.11044244232214173, 0.18742788523147041, -0.29076930150040869, 0.024528978008009097, -0.053139680672365776, -0.42809561607202729, -0.11123562445460088, -0.15712048452591634, 0.079713196910993225, 0.014238777602607283, 0.064520639471832369, -0.24071996224714431, 0.051430356333586086, 0.081215915726072382, -0.13336600985873592, 0.037293884109298125, -0.050369348950270017, 0.29125498695938107, -0.2697787841346001, -0.03955149928161697, 0.24846686868799642, 0.040745434594774969, 0.13506069570732226, 0.20341652526994472, -0.4557478197039519, 0.160035263996674, 0.10616168209622948, -0.020075964547196453, -0.059727229687685429, -0.11834428607117094],
                             [0.21672126912600925, 0.078202732719680992, 0.050674897764400637, -0.098110238269878372, 0.10294771004878102, -0.32944413899878849, -0.020350223729996619, -0.1576064744013761, 0.24495772855389428, -0.22677158715022908, -0.41624411145624873, -0.01429244823673459, 0.12613392447024147, 0.010784853521912, 0.13901912860882962, 0.070498012028667442, 0.26325829917654076, -0.090226586578741122, -0.15139068383053911, 0.15595378926096715, 0.26583960988223415, -0.1929205099606788, -0.10170574699262538, 0.062012045949902998, 0.35419082075266056, 0.037085772023175784, -0.21585101325874029, -0.018792420083856436, 0.16700498509630671, -0.12920748220331246],
                             [0.20800483263698127, 0.15303455008546163, 0.02158313276972236, -0.13605602340876505, -0.16929550213143729, -0.076939106901152535, 0.087025358152925239, 0.2020396378664128, 0.27042188955216068, -0.017232405874066992, -0.1163281740616363, 0.038453510259557469, -0.20268965824340576, -0.027424768597488009, 0.12101848358688125, -0.68732824102931067, 0.068392041677285603, -0.073430454875530737, 0.023647935067433234, 0.022072343528894114, -0.069143595163022459, 0.16963594730282508, 0.1695136228413793, -0.015293123033442874, -0.17051974432837941, 0.19486512176797388, -0.083533203242041373, 0.19055764476616546, -0.0024163595352980727, 0.17331920198313105],
                             [-0.082058877072425124, 0.029464024608362664, -0.14754437835085454, -0.21223517348354662, -0.027650294296247244, -0.1501017407001459, -0.033710360093686408, -0.28462355595921024, -0.17230782124710484, 0.10985365588576343, 0.19223168376914895, -0.13833259679294613, 0.018202903839769427, -0.28754967665080416, -0.25841179957217858, -0.18380166037857876, -0.27816552735279831, -0.015773890363909228, 0.36984344513181128, 0.11401949224268959, 0.29266275928494523, 0.015035222698806128, 0.042652456806229852, -0.09327347499514585, 0.37055492517601046, 0.18344315166838371, -0.076310658549308769, 0.11814965246953182, 0.086542223552757341, 0.12914987186625865],
                             [0.14881766932091733, -0.070834830254477038, -0.055250285558104996, 0.31470319326147883, 0.0036544218837033468, -0.024232025894931484, -0.62459867230682375, -0.099512034182170181, -0.009849699002405057, 0.23749975584757438, -0.0086683486552673033, 0.15177663929837332, -0.22994671362166552, -0.14371212756744536, 0.099994870748556008, 0.0048009958581926911, -0.0056748005534153143, -0.098119088214892111, -0.079661646557745769, 0.29126837522785198, -0.098934417004175684, 0.20823244354025466, 0.23104573125804054, 0.25760065678448346, 0.14421173063723011, -0.049032975198927471, 0.061120151310941048, -0.040450749216811584, 0.064223656695997042, -0.022881029217842828],
                             [-0.02736788321628867, -0.10893332163722584, -0.53656830625192364, -0.13627228281283352, -0.18694915821864372, 0.30377093022269147, 0.14332070479937686, 0.01843399491747141, 0.24683704764567307, -0.1958217492206237, 0.016929760039693553, -0.067142339891701333, 0.054636279034515109, -0.25422848075858612, 0.18674127775611929, 0.034624062928611407, -0.068800325808369311, 0.054841633988408682, -0.065437943312106839, -0.054009370094521558, 0.033641826770767262, 0.0044561745190586444, 0.27924500954695664, 0.13189387991651808, 0.12518034584097729, -0.37380876244153549, 0.051969044278647084, 0.13235649606391389, 0.10845564162416907, -0.16184340838075587],
                             [0.41508728728406347, 0.11734536375622107, -0.0053749019167084675, -0.096865257835893767, 0.060872867014511604, 0.049307591779844492, -0.044935560487635473, -0.061045183669554783, -0.22961293609588976, 0.029881563551531137, 0.25648387980580462, 0.0020167939899376941, 0.31131665486962923, 0.2054346155573627, 0.092802274552927499, 0.092447904294836028, 0.20638778108168096, -0.069402575405981215, 0.20076834037161426, -0.095706783160603701, 0.15271735600002156, 0.094229074399129503, 0.06564384507579285, 0.33882488009451039, -0.16589283855572753, -0.2361481948726005, -0.24088850565611727, 0.22587415100342181, 0.020032648263456312, 0.27573069692548069],
                             [0.17698183714386045, 0.18137781703255532, -0.12502757543164414, -0.15279099999782916, -0.19250438278194132, 0.066216729854070719, 0.072445591785715233, -0.41423815713489509, -0.21262788922171383, -0.15050789659414973, 0.062632561234846451, 0.029590996402328911, -0.32477149086956103, -0.018956455208722002, -0.082712430048011903, 0.0089035680761486019, -0.11160461297492628, -0.24966757453258567, -0.47406641552366663, -0.12887785607775354, -0.16884815202287717, 0.098564568967203905, -0.31149247144798053, -0.0024361319817681171, 0.01439979160970075, -0.058253517021714697, -0.044010484076042515, -0.069526466456692235, 0.052485695840822959, 0.16904903617782877],
                             [0.37850984985867986, -0.15120030979992335, -0.22236695748544638, -0.17574748346250751, -0.051533678817718573, 0.0081829028371515726, 0.23106676090700171, 0.056179075556020704, -0.27859630802173779, 0.13331626096688018, -0.15694662737873652, 0.046967518470267366, -0.35848978366501105, 0.22614932664347603, 0.10290707568758056, 0.20222854770753709, 0.02356683099749849, 0.016825795389994236, 0.18440483969203522, 0.17797964074889214, 0.13218964927977431, -0.15800043017316256, 0.21100668119206381, -0.095081581312992408, -0.11101807813540773, 0.20141798998779584, 0.25645008326338009, -0.17307438005230824, 0.16269330613111546, -0.057307960763312342],
                             [-0.17500929675894838, 0.28008998302752913, -0.1201835459286533, 0.27381737072233608, 0.24502059047119065, 0.20505372112978265, 0.12974017996838211, -0.3304550029843053, -0.19492758318471412, -0.14684523630188628, 0.14652128568391742, 0.10646234379089831, 0.035808676385938286, 0.036413501624198617, 0.26999878901723978, -0.39766982422678682, 0.21732775305647575, 0.13129665142186436, 0.12018094446286734, 0.10904700289196628, -0.027254679654547403, -0.21469825119841951, -0.017023764437392355, 0.10996602105037735, -0.0066495117420677062, 0.064761943400012914, 0.094267732097853357, -0.24314633559708601, 0.11364910316778988, -0.11039915397027214],
                             [0.23200793569818493, 0.23570014713852999, 0.17696920003392072, -0.18111354906744803, 0.30509113292722306, 0.11746719260292265, 0.13940034400923468, -0.13527338935137279, 0.085066751454768635, 0.22408358871006442, -0.031078128835473527, 0.075994044255087892, 0.23336587660219685, -0.49414884477918775, 0.074544428825664866, 0.16335453486438309, -0.1536332398089881, -0.17261404242070799, -0.0816490707047028, -0.077043131995405897, -0.1631738333915515, -0.025644230135623166, 0.17997303768405351, 0.046382629968382882, -0.19156908501203007, 0.25975414231385818, 0.094534528023711914, 0.0024968676683255237, -0.029112105949395398, -0.21219000149716999],
                             [0.11124829112389438, 0.023508635008779991, 0.1398268337013826, -0.090934962794119126, -0.49105368797586996, 0.18739817785786553, -0.052909234099537163, -0.070595232522672927, -0.17698651970535345, 0.035289553656518612, -0.11161995896255889, 0.034671553102249605, 0.45694821443844036, 0.19056328543069229, -0.11834055349910938, -0.11652605489440637, -0.051844044918366507, 0.23000398385255297, -0.088002364418061307, 0.2125868825132903, -0.17183645880176499, 0.14599153763092418, -0.06626110740732731, 0.0328345449017131, 0.091974621819837676, 0.1589351354586957, 0.12710147893827556, 0.089248461623338007, 0.19063072104731144, -0.31187976643747528],
                             [0.084685217895199436, -0.18808588153978595, 0.2381169323902915, 0.033864631610459134, 0.064529575644102999, 0.23286210716262004, 0.020715017392676519, 0.16439887943848494, -0.017154749185225332, -0.079823137822774365, 0.2946014288775361, 0.10968026502354178, 0.011365066097774778, -0.16977237247383423, -0.11681071596197048, -0.12527283108051701, 0.093236368054954957, -0.011195717005738648, -0.36366575936531148, 0.099982473218827056, 0.60724266319466536, 0.14664015271272285, 0.017416349069010493, -0.14597810756981364, -0.096220540863705309, -0.011088309938039487, 0.044791125835879686, -0.15204208235589725, 0.22624342396774405, -0.036973376939208671],
                             [-0.072419528530750149, -0.16170657004213862, 0.0031753774447161077, -0.14566723002506188, 0.1718694640728384, -0.21295081227634721, -0.032977301942336681, -0.18953833509707299, -0.10942797546909977, -0.060069948068753647, 0.16021386273356752, 0.18938740419009023, 0.029805143240002122, -0.035408522019897755, -0.015687292768144248, 0.025409788189977123, 0.35545071210224671, 0.17422122023046313, -0.21239439864186663, 0.10085559256526956, -0.24184067610191809, -0.073815339668235586, 0.24010752774353372, -0.39108897911500651, 0.0094265664710063857, -0.062420279050655003, 0.18596973160224117, 0.46090528937469072, 0.065204045753736617, 0.11640733555874723],
                             [-0.065632468748095391, -0.050141471700583425, 0.21437202617148537, 0.037990915029360375, -0.098257994103712984, -0.020063495879428021, -0.096821293006196213, -0.2363378214427701, -0.20042524336525519, -0.25661078208091104, -0.38764606950125391, 0.17690787282010143, 0.015341489731618217, -0.082570257542556424, 0.048225783519303074, 0.0099817245210716971, -0.081731874389703474, 0.18735066435523412, 0.12332982483834641, -0.45968675724623309, 0.096660924327748657, 0.22193360318746558, 0.3978903629107271, -0.1140754830690299, -0.058069943239764742, -0.062964949665856029, -0.074710077068573258, -0.20564017699950179, 0.067731851591121994, 0.12411481486841865],
                             [0.19006683632914739, -0.088539799789201817, 0.25810006297310872, -0.099692160730473448, -0.15348507445440709, -0.30670787134756056, -0.0080215875984648456, 0.13161609170015987, -0.23031713597588019, -0.20710567360360407, 0.2654407446861628, -0.20796849497124603, -0.12181578625091311, -0.32300387343708814, 0.40849634331159301, -0.021202886463064934, -0.11575892303230374, 0.31334154394786828, 0.028751876159917342, 0.1086814848629462, -0.12741168574696718, -0.070693702957841817, -0.1083742671837177, 0.020369227502620102, -0.005308818676008133, -0.15139805683891744, -0.095754430060255136, -0.12252144613785093, -0.13743155187344719, -0.15715836154273116],
                             [0.13397322370174758, 0.34205405190307342, -0.033520587694083566, 0.19623729481294855, -0.10296517453799092, 0.15792948927356815, -0.10056668198395403, 0.11486430561667291, 0.10609275879707988, -0.29551930889199113, 0.010638076596899108, -0.34202439376086996, -0.044200196519328022, -0.23596995329262579, -0.086197863333093705, 0.28735314438496812, 0.32131350353458077, 0.10359800608532768, 0.19456716919242426, 0.041840662348585696, -0.056605028411122478, 0.2101503862058024, -0.09000100521438191, -0.17224727867004577, 0.027000713736284279, 0.19760416283925672, 0.23749552779437286, -0.0028000479343807893, 0.11711711010524942, 0.23371890130186226],
                             [-0.40148706724907257, 0.007965329799620743, 0.094032520163490937, -0.47096722369063154, 0.15784860919379606, 0.0145096244988978, -0.082387454264983201, 0.10422732650859766, -0.10308379358003353, 0.10305441527099683, -0.17543986250513299, 0.003163374923447411, -0.13062557135482086, -0.068973971098769488, 0.2149170034436988, 0.033241018367929809, 0.10907422353163096, 0.071479130793534545, 0.045099608971720738, 0.0018513387738930472, 0.044175721854374295, 0.25151264057946277, -0.27240204032426529, 0.3393435814870242, -0.060809374325967093, -0.021639310527074938, 0.22099377343095472, 0.077003490697121743, 0.32333161045196468, 0.084120690423641939],
                             [0.036356712849135053, -0.13081895468420415, -0.028382461065496165, -0.06677165453638273, 0.28307906268249733, -0.057937791668142266, -0.14803952771646625, 0.045532961794975541, -0.091269571348258666, -0.44090087090045893, 0.16939669500949089, -0.186962054226332, -0.027914401188742673, 0.26778987875236016, 0.023577749176753749, -0.068741918731476323, -0.090872626042598117, -0.35991462500723664, 0.088352709278965089, -0.16716833940518455, -0.067912515724382339, 0.29380807929601427, 0.079181859955187742, -0.0072721643900662131, 0.070362713284600337, 0.18274183506420513, 0.1187408875060606, 0.11327210326006273, -0.0019783306878474387, -0.43426970116236602],
                             [-0.17220843430216412, 0.10506720913473855, -0.23117891670354923, 0.084830867149596353, -0.2476297350409559, -0.20292413822926503, -0.018469569182956804, 0.16513759734324446, -0.18589584909762077, -0.075773415506330918, 0.012365350363045896, 0.41256163838123272, 0.014643013484208675, -0.25252128559665971, -0.053433002461396956, 0.11380160475671676, 0.18215773155485848, -0.28087063759463515, 0.20100119721190576, 0.051596459666940139, 0.0037710991072057399, 0.040746466182613267, -0.1439480511979486, -0.12797779243054891, -0.29582395778543935, 0.017961835557510172, -0.30090831570732457, 0.04792435040581184, 0.15602492987100536, -0.2813906052774019],
                             [-0.13246845435025806, 0.34891392268234128, 0.046566056190168625, -0.27504780881258828, 0.038923298900852117, 0.21322336364870323, -0.11148578530573919, 0.14224038594023647, -0.08663756862690479, 0.17290666558542581, 0.10878840511724701, -0.14372038071230331, -0.25753651720474763, 0.13165265975064094, -0.116027315029041, 0.083405188347090306, 0.22648096622125985, 0.17629622669923806, -0.12690493957507704, -0.052250834035371271, -0.057390462465879116, -0.0051927763623114487, 0.30142483576049162, -0.077832025273088162, 0.18577398310102305, 0.034949487827085034, -0.47006681250226373, -0.095480021459374231, -0.023866205196156173, -0.24790058070041068],
                             [0.0027427877314537496, 0.30883949058267524, 0.058482634573934628, -0.055502523643808296, -0.09825628277338172, -0.055964472224278111, 0.13637154821910552, 0.020013558942699981, -0.056494462086193555, -0.0071268105257196032, -0.015396705434824257, 0.33227907938031515, -0.096628383156001654, 0.0071380273596078651, -0.018297012100072504, 0.039506685581130081, 0.11982696640669054, 0.017510184709128435, 0.037317496522373587, 0.019962193375371872, 0.27072881406013199, 0.20733121078027184, -0.0082401637604911492, 0.078696537491550325, 0.24245381583535758, -0.13964636610872283, 0.35273607529151607, 0.096804737884819775, -0.6049606718248991, -0.15524042606006666]],
                            [[-0.043775631608463886, 0.23624729631747987, -0.032761818314724141, 0.0082834899475336312, 0.266865314492989, -0.052875382500070373, 0.14786719210851343, 0.20772274233850951, 0.042628600904967881, 0.10743926012300786, 0.065988526589576019, 0.058544143246211142, -0.038300611609348098, 0.22894311767012318, -0.12436081395683193, 0.27085045635201305, -0.40833244889510739, -0.22889180846768822, 0.066053673101982402, -0.16408865128567918, -0.29974581100823972, -0.13493810876156034, -0.072681655859212185, -0.20321683280314709, 0.24086305321774185, -0.39971037192008191, -0.082447727614553615, 0.039210703504688443, -0.083564629345048005, -0.010036365789539221],
                             [0.21434613554769369, 0.16355128911492073, 0.11970651729889197, -0.28206348116826252, -0.07249616886217683, 0.08444347685654964, -0.1083027579689585, -0.0045382771841035495, 0.1162403657747354, -0.015553471847574411, 0.063149137731360813, -0.035129526266157701, 0.11879692523719901, -0.59987338777885713, -0.4293470391587032, -0.054076352116534242, -0.22281322238523002, 0.092555167980164804, -0.0087388436479093039, -0.10001544463565105, -0.065177923267338317, 0.044608033640597108, -7.2895717368647435e-05, -0.13910634610491737, -0.039150820472581942, 0.019607530786016882, -0.21075338708829866, 0.18784323508125514, 0.23144339403576375, 0.0039491685274820427],
                             [0.037756390598806075, -0.10023474464397537, 0.021222635559647426, -0.20553131979032593, 0.11927061265407396, -0.17374496155708222, 0.0022505275910743236, 0.14270069280906283, -0.15826284255304413, 0.1735007443921644, -0.058826127697708036, -0.18099180007068436, 0.13658882459043245, 0.11330645174504421, -0.028852940526742244, -0.090783524970780308, 0.40044082978657536, 0.054034312132283262, 0.040082167344325105, -0.029111029342207422, 0.35042795908516738, -0.19081598955440157, -0.0040545009311106035, -0.53737982920942273, 0.0005156601108088194, -0.22229565755257716, -0.15950556225333876, 0.092073823008045994, 0.068101855914577736, 0.21774225356427687],
                             [0.033262757676645709, -0.069117656957579002, -0.16281393946843298, 0.14047145586132287, -0.31887359258310299, -0.078655631753300967, 0.0036995687520223718, 0.018729928620832243, -0.27395013780192923, -0.051005171477956246, 0.41020201219433877, 0.14893493590931883, -0.06555202324274724, -0.11313321261484718, -0.20145616730476643, -0.13920739320168427, 0.20508771012401505, 0.12955148769873934, -0.15457173649953562, -0.33003007837205672, -0.12911561844420968, -0.054389348185131997, -0.16103524438000713, 0.1302555745455955, -0.031708575751139098, -0.31411082329626328, 0.028275948908968038, 0.022041051069580278, -0.34058789065770573, 0.15279376950003259],
                             [-0.1342824746843099, 0.18091939361700005, 0.087905400546504545, -0.15502859165873129, 0.23905583142028686, 0.088392468948648314, -0.30530397747081472, -0.26929602994342677, -0.1155864819551522, 0.24487784206064414, 0.16961198899213026, 0.26175255870737274, -0.28060947418612175, 0.12252690864046335, -0.026165425491729871, 0.087452484617716181, 0.11605611770224333, 0.10970593997718027, 0.045149291155209548, 0.12856711982069638, -0.23254814789196582, -0.2140724830261759, -0.0052457724451450737, 0.049956753431903249, -0.15026957915387107, 0.17624669487884437, 0.066132375403374216, 0.249944142474336, 0.099666053783328934, 0.37035698219707169],
                             [0.2446468397359563, -0.082007949456143661, -0.16284509411352685, 0.29401964116698237, 0.28038187235588691, 0.26665939812368034, 0.099509980285827623, 0.22192386725545107, 0.13178120130430959, -0.073277127786059937, 0.019098628182463915, 0.039737715971225399, -0.099513471174047116, 0.052118402380724051, 0.016831917049711199, 0.11807226396291967, 0.32908619634042091, 0.076161532295614356, -0.17244545491996977, -0.047384242397269571, -0.24986747888754549, 0.26659028561143788, -0.15976301226698472, -0.13894205599553278, -0.094987440490614625, 0.2114459602716954, -0.38244994083189093, 0.18157453596916229, 0.015359157450760535, -0.049397790034753919],
                             [-0.14495811969733935, -0.38039575309728596, 0.25757956462491555, 0.064015719646741673, -0.055155793316966975, -0.067997433666368901, -0.0062291326814872521, 0.17236873028016908, -0.19521377947669996, -0.33926760549621227, -0.077442503609580882, -0.045793813994497674, 0.22287747850622311, 0.11011762173277634, -0.22740668078090578, 0.048486846251987341, 0.038684450186282769, -0.22829511219187346, 0.14451539615590167, 0.18951085149387786, -0.17770753494929492, -0.20810530689839915, -0.026794562463663116, 0.28777985943557055, 0.0019331685889307291, -0.014041760184587936, -0.17736905747035228, 0.35343910233061476, 0.13658606591134698, 0.07198726582341651],
                             [0.23143340929268524, -0.20148695252204257, -0.038065714512745118, -0.0938178981996316, -0.11846853955398183, -0.086870601965268801, 0.30120338227814109, 0.1816307796388783, 0.060818179150816352, 0.1912706139632715, 0.31016095517221021, 0.063546220162701325, 0.058853466269985201, 0.081991622632428013, -0.082685529991666284, 0.026627550666718933, -0.12892440345810036, -0.20577948489480638, -0.097694013149529177, 0.27305121944867478, -0.061389267621266279, 0.0063422493567524508, -0.29063443993842863, -0.11001340903942407, -0.36683501898401988, 0.11571832338790515, 0.31657768189380325, -0.16043040454605803, 0.24735816345990946, 0.11614950967095676],
                             [0.2863052405051319, -0.087077259542991767, 0.18525847769093523, 0.17436135293796848, 0.039912027943040697, 0.16560827547421345, -0.089516144501380943, -0.055322230834129099, 0.077136679947390666, -0.032710563525635186, 0.16756358472729938, 0.018288282995387803, -0.049874187292297242, -0.06408738841960733, 0.19674249048925241, 0.082137182315600105, 0.12425622386055946, -0.23031737694260171, 0.096451694423502501, -0.21839415482076424, 0.14143213046551448, 0.20324574033931272, 0.15986577879836686, -0.0037862493388436404, 0.18113701954011222, -0.2550503921141411, 0.45027397535413427, 0.36459363885134383, 0.26722735205029602, 0.028910600664182599],
                             [-0.072742603284630669, -0.17863596269347798, -0.31516283555462749, -0.14052115650084218, -0.10399553376052292, -0.43187914996474186, -0.43160720121866947, 0.19853013034735709, -0.089052153471268977, -0.071577076115192345, -0.093912922277379421, 0.038870274043190454, -0.1947041802910929, -0.05967825135047377, 0.16884566664736689, 0.08996375147900354, -0.14419404051049678, -0.094227749673582092, -0.39705695693348453, 0.062611767404093785, -0.11877134630251676, 0.20535786410265625, 0.1098464374652974, -0.12321649419151065, 0.064207467198114029, 0.0055974825507149224, 0.016952119045349039, 0.14801817848682269, 0.13312546687003785, -0.019678309812398622],
                             [-0.082512447411979786, -0.25117502453068874, 0.10902711971647687, -0.53717819469305395, -0.25297563876122819, 0.10122352414917363, 0.31923348782983274, -0.19659489558721072, 0.12807799954668897, 0.084985748925902452, 0.11236236123469991, 0.10266078137423341, -0.25003937552581529, 0.095557597342074502, 0.075039084035487799, 0.10616157736206781, 0.065135888327592498, -0.14595792413266717, 0.016026439698721778, 0.015931903366836704, 0.02377955638558114, 0.2770509556496874, 0.012654148103927274, 0.012146212924081403, 0.24782410225412427, 0.016527865346588795, -0.2569847640905854, 0.13331447727494619, -0.17405819436045861, 0.0047216424671868967],
                             [-0.3528368887107789, -0.1272040821542276, -0.12865079765686777, -0.060617444340279422, 0.038159176957644328, 0.2977542910121494, -0.075392177983923808, 0.26965873687034753, 0.10796977929492627, -0.206544641369688, 0.0025257983587048047, 0.1219622543063759, -0.28887360179298549, -0.18575353387299284, -0.25016775518836493, -0.024610373748545054, 0.25351003558885948, -0.12398082095626795, 0.16379356757207506, 0.040029545731575029, -0.069384518095570114, -0.033925154964562068, 0.098304593734996989, -0.13511573817862133, 0.17218527146311988, -0.049673487633860182, 0.17694770730572412, -0.41940720219430205, 0.18603478800760495, 0.065980530972891596],
                             [0.23405408040975667, -0.14554814416327938, -0.35844973196080016, -0.14490973813556154, 0.13065069310808389, -0.027562518267002331, 0.085853004732578578, -0.15126668431110429, -0.14475825272843826, 0.14212617771708902, -0.1510794853712992, -0.3453937494475447, 0.15979838173604302, 0.06530768092476559, -0.098093720401228143, -0.16411059939785361, 0.021913839521838549, 0.036520298929694162, 0.14212095691419108, -0.15457004812421449, -0.34236223267081634, 0.098774174276930263, 0.036502625913133184, 0.17843351133328117, 0.34848006122544517, 0.15866217251457604, 0.13813231916333171, -0.10305854922072311, 0.10794458620099988, 0.28779631025187191],
                             [0.0030341259669270358, -0.13726809503985596, -0.11899293349624721, -0.054547887652147735, -0.077942043711948628, 0.15878792571136413, -0.0040991736984176937, -0.32200710521672771, 0.14036787582252735, -0.44633827587464719, -0.19582077649651755, 0.16669736299873827, 0.03790515528536742, 0.2854288144811622, -0.0396906323203957, -0.26750007565743567, -0.22164160060571161, -0.039481498669225026, -0.030405629298489285, -0.28111090009114859, -0.074115562225304771, -0.079422087775401287, -0.015805459132015059, -0.39223303233897455, -0.24103034886686048, 0.053468593010327796, 0.10445402981198405, 0.094632659885434914, -0.029079895946226182, 0.098647734919561705],
                             [0.063486154572710771, 0.14799736451018325, -0.10899486283305723, -0.13217619657498719, 0.21799993292365116, -0.17909381665261376, 0.49397340860124367, -0.06762788059066567, -0.028518909896006275, -0.27682988487649224, -0.24132636254091952, 0.035324693154718756, -0.23114104183828937, -0.27310238944735216, 0.14164791921152539, 0.13551958683346563, 0.11735807079464558, -0.052769041618632377, -0.22634615642510261, -0.087197339836196472, 0.060093382357187738, -0.22031424694956353, 0.10552645219225901, 0.24156496774614417, -0.19486657770807811, -0.15138584037366379, 0.017795935836740787, 0.020463737164481716, 0.13620629794548975, 0.18959990016877559],
                             [0.058811490059538549, 0.10591472881703057, 0.1096634174872296, -0.21803187465142826, 0.22007810268244851, -0.15404678657048701, 0.10786982793568012, 0.21868936297878158, -0.18970840216505494, -0.31418047358541712, 0.036385569388771279, -0.098479255477241373, -0.24343443052342842, 0.027629529450274855, -0.11280121809236529, -0.080300083439273404, -0.018873055217291445, 0.30959087564923382, 0.17572014336301342, 0.10001358610308635, 0.037689265864552624, 0.11815764830288411, -0.23646809084637668, -0.088444805530893691, 0.11289109246117021, 0.18862641779538619, 0.37866636347799476, 0.22591831982277533, -0.24308957789060229, -0.22620440301674924],
                             [0.41863776446680423, 0.082247202254900134, 0.19790690931394522, -0.12173705099029762, 0.074614719788275954, 0.19666516136159518, -0.19712973397623976, 0.062871192433923986, -0.12961414664488877, 0.043673847981081752, -0.16711294857395986, -0.081597150820827746, -0.27337891099062417, 0.20067109420294937, -0.24525272207504939, -0.29725063096222681, 0.029511897804337769, -0.34679513987411531, -0.33384210629702282, 0.11318016727762706, 0.061748546669794416, -0.08285181058222621, 0.10283731931333548, 0.1512017967684868, -0.013803811800422726, -0.081668405472855407, -0.032494395550961674, -0.14568080212343254, -0.17603972588233383, -0.10240859618853619],
                             [-0.19366282796205753, -0.070904114973293755, 0.31394290675358705, 0.17559286853827405, -0.076248242929653251, -0.043159168704216259, 0.064530449774415591, 0.092977989824705273, 0.39882939406273371, 0.16881250210196805, -0.23513069100893633, -0.29229616963231647, -0.10673977428724669, -0.18337945854952278, 0.067007152781620283, -0.21419474271499553, 0.002421983767868595, 0.062921046431280228, -0.16855244476638531, 0.12578858885694558, -0.28073226717999805, 0.037402733295185717, -0.053742176029322401, -0.097795974118545917, -0.018766293888757109, -0.1149264266136661, 0.17301106986540316, 0.13146935796073356, -0.27847915948944274, 0.32361171283250673],
                             [-0.082832789809216989, 0.14353338728974027, -0.086899295995837955, 0.10989584150526961, 0.28085762290876132, -0.3318292856876448, -0.038216645345864102, -0.32655899983962577, 0.11893271660664401, -0.12837439510002283, 0.055831607302248822, 0.11442699927423285, 0.1175255093163898, -0.017026586698680519, -0.28363236024836536, -0.13007178259793986, 0.1296879152409971, -0.25973982364615195, 0.1203884356096923, 0.27604307257063754, 0.09417508234260856, 0.48841803262015676, -0.067988245169702713, 0.021587169142932818, -0.068954014679415171, -0.19490819737083154, -0.053440578466987729, -0.04796755853299451, -0.09722342904186955, 0.11257029625515544],
                             [0.12947338499282404, 0.31113917421459969, -0.26276031375533337, 0.061380949379868897, -0.47778856088889732, -0.0059258905190819272, -0.052265409781106546, -0.053948939392567431, 0.0075676767533085091, -0.011083791476618711, -0.18551370190161656, -0.28512883363362312, -0.29194117562692723, 0.052019326546917856, -0.00058744340366342635, 0.12461797485624124, 0.15463661771570095, -0.15304842030822824, 0.41258007139817132, 0.14912069623247878, -0.1239084160499926, -0.041332921930438471, -0.11445452974628458, -0.061665364493620499, -0.19748824916461008, -0.11410695202098281, -0.048051165962227832, 0.14389672330137601, 0.056752005424106911, -0.091005370403203417],
                             [-0.32807936269143556, -0.15070091848110714, 0.028642583421190627, 0.21166725587970592, 0.098527755389303834, -0.067813142761987286, 0.056326699812402459, -0.18444338227359774, -0.088669253005456639, 0.22253078933114853, -0.023748685862293097, -0.29443158900775696, -0.34447838821405025, 0.0089124838547681804, -0.25817392591405436, -0.031451675699016635, -0.11479030317281209, -0.14068815251741293, -0.1021103236738303, -0.35999846352184722, 0.24880460638013238, 0.030146301951684919, -0.30575298789738364, 0.049017857011671488, -0.053011570204526667, 0.14992191247973591, -0.035816847433021895, 0.07689665955079171, 0.23259715612957427, -0.15240628446461743],
                             [-0.28339135633965012, -0.0042845132698642405, -0.20231034233657694, -0.31276334314990839, 0.15434676864486493, 0.2982170617687272, -0.049215512810700121, 0.021873649639942781, 0.05131356860804262, 0.034911886274581326, 0.12860338601101828, -0.35586959013388814, 0.22334082919254447, 0.11374674453466879, -0.054406913749685488, 0.08039715021653504, 0.075464649116875629, 0.086630662191633442, -0.16251231395162791, -0.00045422229897984159, -0.079397965009276469, 0.125056104773309, 0.15843687350031485, 0.15537952784651532, -0.38571672486970876, -0.28473346231416552, 0.15433797475265262, 0.14254212071681827, -0.042066552348505669, -0.24378167768880052],
                             [-0.03569874954835487, -0.049944485117128817, 0.15159173505102935, 0.14798262124052519, -0.11897138627485415, 0.14893891592438493, 0.16547828736986972, -0.11082093127605473, -0.52381101409850905, 0.13836184536978047, -0.34516840984743635, 0.11464421345020685, 0.045293231887815873, -0.06862697667049944, -0.21940856369467565, 0.35543690210067252, -0.037685334280850573, 0.075941619482420245, -0.088184195147926137, 0.070464210304069741, -0.084508154676231545, 0.29779892564925869, 0.21732947055261972, -0.24012887142202693, -0.10684485551800769, -0.012805894376626546, 0.15855640150675951, -0.05249632890386121, -0.082790355346359798, 0.03645439294581497],
                             [-0.0076237777566328518, 0.10009872159908668, 0.13408163816225396, 0.058983703315166822, -0.091973577160753162, -0.3264695585024785, 0.13733013907538988, -0.22097108283178535, 0.18417655954429887, 0.0018263990698569738, 0.15685768243538001, -0.039297908807320002, 0.065571243492616907, 0.10065397543775573, -0.22509289782834335, 0.060791539282147554, 0.34448163964674344, -0.031879535738124118, -0.19834901979816563, -0.045283836934013832, -0.29780304769189903, -0.21699381756769401, 0.32221382693791722, -0.17158830190032678, 0.12997912457866123, 0.19266864380719406, 0.12452696825846145, -0.012559617539183089, 0.079948287473291121, -0.38817944249593178],
                             [0.099634063009446883, -0.22150916246853034, -0.30876334454762561, 0.1439170572518923, -0.017579061128453824, -0.032810597821708108, 0.12844602056213703, 0.084358534579738312, 0.2618402606814158, 0.24286623294192874, -0.14861261512778207, 0.26023071407306364, -0.15319053661756024, 0.12688638603908634, -0.35032337874224911, -0.088412607154314787, -0.12332322128200203, 0.32584441774510903, 0.083398649669160357, 0.17139823959235079, 0.22625619291616744, -0.10063345459814255, 0.2863402798777066, 0.14073233089365417, 0.033229748282928559, -0.12666870783066347, 0.043501769206850928, 0.26153604938890973, 0.0101714335939507, -0.064197850222173114],
                             [0.2119077602795551, -0.37841419657269021, 0.095801944401526645, 0.0083712113213276398, 0.19665728440358815, -0.19781954256383311, -0.15567286517055104, -0.032731655676292146, 0.085272888845813452, -0.033160128462345846, 0.15789246526055056, -0.19673573414622941, -0.20734311207453024, -0.1118710943735467, -0.0065463240608421352, 0.26053269273162988, -0.10505164440181208, -0.020080293065894098, 0.33353074173910435, -0.1679459466296446, -0.027531203733536808, -0.048562329513791899, 0.30949433073414034, -0.031929474239764576, -0.32699624093458357, 0.062790990607765246, -0.084619864439688094, -0.20494545826227234, -0.30324598105242928, 0.036117324199994902],
                             [0.11603046211364478, -0.010596610534683608, 0.050339369049292211, -0.14818099839715079, -0.077627672780109985, -0.055470581914696213, -0.24547506067044594, 0.0013859627168953683, 0.32275700320038558, -0.040522001352924775, -0.2825948067547101, 0.072974149334576729, 0.16249913169067945, 0.12858780843116518, -0.23116812938976972, 0.51594326476109964, 0.18395997051097371, 0.077134698570020546, -0.11651086767488597, -0.18904858454128545, 0.14678972686938491, -0.030633488472223195, -0.36335869938408177, 0.1692099796679804, 0.057207130197593298, 0.021192319571789242, 0.17335363024355241, -0.10101795977100457, -0.10569251833961074, 0.10766955974085422],
                             [-0.026238585645068643, -0.050308966009294687, 0.133567025579437, -0.17688303298189917, 0.063647843684504324, -0.17665451343449062, -0.013758688190216927, 0.18079004178098573, -0.017243924593828477, 0.29106485414964484, -0.31844727880109375, 0.37780500143142359, 0.061925508511151549, -0.052591337337837329, 0.11134822655449096, -0.26924300006212842, 0.17167014847593817, -0.079736612909766594, 0.26247562015605486, -0.3258804063133563, -0.24786081762078002, 0.11920425916350481, -0.086961852929920203, 0.11421901192162422, -0.24791396013495862, -0.072553499277623335, 0.033636125543165411, -0.013853273181680104, 0.057710604418443827, -0.28340104068868388],
                             [0.021778632043920419, 0.15028170049584355, 0.31296969880234476, -0.0091745765392199155, -0.14374846690801887, -0.14005106129017025, 0.016948838644984955, 0.13833401088877237, 0.042017939018510954, -0.15129371673663436, 0.075054213587612148, -0.099017043099445923, -0.15400814365211962, 0.39012689370462111, -0.058737346476869137, -0.049255475086163389, -0.051789455027315988, 0.38789468863500914, -0.0015877349800624038, -0.13653080925776975, -0.049904019334204408, 0.31063957183994306, 0.15114633437885339, 0.12056619601240356, -0.090816427180037115, -0.15540825065634115, -0.14650633531894711, -0.21423934779822129, 0.38977462536992702, 0.193588018317606],
                             [-0.14553606451691667, 0.32250843025771275, -0.08421260143970033, -0.0061926363126308826, -0.11578904071638194, -0.029848284552682701, 0.084059216925784108, 0.3755914425762808, 0.041362764786062517, 0.037717628208680298, 0.053178242492652017, 0.0089919248980513747, 0.11477734063972769, 0.09092881058288009, -0.11949357346246631, -0.021196286077260006, 0.006176393978794526, -0.2972737255317548, 0.037160506858470194, -0.26118801811192205, 0.1975914403053535, 0.12353979948747226, 0.31765778561219288, 0.06357863484053157, -0.099059435979254942, 0.43183134837679371, 0.050356790665431181, 0.17666421253145909, -0.18921785338035141, 0.28271679483127637]],
                            [[-0.050106910101140663, -0.040087344652902167, 0.18839117925836413, -0.36905338061910992, 0.10826662578792592, 0.033198522320698698, -0.073294147675928692, 0.19106206104550216, -0.16506525529338451, 0.15188229312860735, -0.0740862905377144, -0.33947980708655306, -0.02754001399667495, 0.065597533315809919, 0.21024649167855522, -0.074337258621863467, 0.10484720127708338, -0.24274456295387192, -0.029295514822916594, -0.082098263820352887, 0.020306025297086906, 0.34479872711998222, 0.013124511348373653, 0.33449626146418543, 0.15922751280721334, -0.2529730479445762, -0.053646615722010238, -0.14325830099552858, -0.081281984104079399, 0.33973194623467756],
                             [-0.046151066340246912, 0.15844245577468924, -0.27543770517557387, 0.069085941920865479, 0.051744123530977251, -0.46061731193136662, -0.04075073796262741, -0.34581043900127767, -0.24147367762951844, -0.010784410854651347, 0.24149440438606926, -0.31037401976128437, -0.23104127574649044, 0.16901795253505836, -0.077655401712070887, -0.1155404792400362, 0.22819586222720795, -0.0084522519436966443, 0.17394549221141842, 0.18032747022008702, 0.072016590250482099, -0.041074360658701348, 0.18433752485815719, -0.070647265783724988, 0.059773022161879352, -0.048744779151158692, -0.16429330530334257, 0.13577376342855188, 0.11121411529067667, 0.13085326135609043],
                             [0.31516683155625724, 0.40375971333883798, -0.12177657008085095, -0.23681878301384873, -0.050102840856570935, 0.016533788600130345, 0.12623186959331523, -0.0001541632006001962, 0.077709299501683704, 0.03270272411596703, 0.26622113569803135, -0.11235243176908269, 0.060240019058511396, -0.44586724867046251, 0.071254017650319398, 0.13851952463522338, -0.13481711332841184, 0.21462798859878796, 0.14477828691813588, -0.01947301100239868, -0.13610076181682215, -0.10178048259295293, 0.016971611607345491, 0.062965497631073203, 0.28490271927903488, 0.068285921928408808, -0.062172310108146653, 0.011922050024953782, -0.3414823081393773, 0.074528684781994911],
                             [0.1298665365948701, -0.035145533552421018, -0.064212847900408099, -0.16294736504563637, 0.25051511937872389, -0.10497166239976458, 0.12762291179326643, 0.067057931111631455, -0.1605340992336205, -0.12723517687132763, -0.18703231914519147, -0.09959062029094061, 0.013839954112596396, -0.11107182740751445, 0.046511933029472131, -0.088481001642210108, 0.080482099928701312, -0.17166350888935542, 0.064352708815780882, -0.17530025496784504, -0.22363460378129835, -0.17182711125713213, 0.23709546243154653, 0.15430891377378644, -0.42428893266070922, 0.16679406027420349, 0.37683692693324655, 0.38717016909208574, -0.12617234136369423, -0.035152315140713424],
                             [-0.077197189068003116, 0.12909236864295584, 0.0018967406192286333, 0.31794551481787886, -0.026260012036002266, -0.048749595084848635, -0.080416032659570397, 0.10818581165543882, 0.14344217902408646, 0.41195380528351155, -0.034962092951957638, -0.06071762308173493, 0.076193368007573925, -0.15710019000712025, -0.45505044993286026, 0.1094242867903128, 0.21061423139457403, -0.1934616619045022, -0.17767392671773841, 0.0037816278645989398, 0.19169874252653588, 0.049290723630441062, 0.11052862693078612, -0.024810852641103935, -0.15681121068834705, 0.11998655025820053, 0.059938404937311368, -0.024479205653685256, -0.36815466634398986, 0.25735241178000373],
                             [-0.06984808334099335, -0.051609223658783211, 0.01773386294769707, -0.20412300472586131, -0.33977346945713743, 0.31934632909221167, 0.06663824689321253, -0.031130462764169555, 0.010703945419091733, 0.10061730644654444, 0.080077899128059266, 0.054409018048354407, 0.12343533915515702, -0.0328194152287173, -0.16323551173808198, -0.2553014862228295, -0.10712371197410828, 0.063071577576406565, 0.10605025683002577, 0.18185377643737638, 0.34820716202432495, -0.18988847841746304, 0.053818609402985246, 0.2535685764024912, -0.10127216643269442, -0.11600368412358897, -0.1175679548163871, 0.4756411541920158, 0.13708921100127094, 0.18181447202023357],
                             [-0.079694326226284931, -0.077552477927440008, 0.038103117438444203, 0.02174397723088093, -0.078475990876350918, 0.20524015236559437, -0.38720347034987118, -0.11175811179038403, -0.099524495841206387, -0.044270727974338821, -0.06353484107534163, -0.16006861895146388, -0.023814359674255308, -0.4302653362751313, 0.12067493182361946, 0.11470111170030486, 0.03754017130417403, -0.26768046240550142, 0.23084513554829555, 0.14019576406954304, -0.15905509619033775, -0.098956055498767334, -0.26508287945858627, -0.41157566836838161, -0.10752831826921121, -0.07871952043188396, 0.054846139968080049, 0.068315262410508421, 0.13860497738683519, 0.2338104329432299],
                             [-0.32558040741481931, -0.080925908375253749, -0.1373999451747408, 0.11430587148693369, 0.1564233031316617, 0.23937626796377168, 0.03563479379193496, 0.28646684372714792, 0.19267825910752931, -0.043801729336541119, 0.015893705094027901, -0.17845449490306309, -0.23158948324932629, 0.0013224949000763821, -0.0066771202340495904, -0.29905606723548556, -0.071316149495543449, 0.12398271765983522, 0.29909154337144073, 0.17737307186845397, -0.053981998570855658, -0.14667689446764412, 0.27402584953785614, -0.11922012627269189, 0.035533338207657687, -0.28207394646770556, 0.11177295676911554, -0.17107490951984355, -0.28252379666531036, -0.13649368489758806],
                             [0.0047934811297830806, 0.14693050383041087, -0.174429629427239, 0.027505250213463374, -0.24327639111899421, 0.12407346780269551, 0.14533335119806082, 0.066604576687763303, 0.00815441820612791, 0.024880736840480065, 0.021835669936866212, 0.13313155533147622, 0.22971221470007963, 0.29404974001954293, 0.18981775559036596, -0.061846434765354445, 0.072137735504725853, -0.19392800758975842, -0.0040975474590182331, 0.046661493747782341, -0.082922902354920947, 0.25753622618609157, 0.19584647956412335, -0.37498697260609049, 0.35063649963401089, 0.055166077766088631, 0.38823402957001324, 0.22841098898584966, -0.018919008167583348, 0.15057539122207017],
                             [0.083869198431853628, -0.12083906207332966, 0.10560139961057469, -0.15948012360752187, 0.20355922787274877, -0.12300012834121264, 0.091199147233786679, 0.01737769575310117, -0.17859682012288283, 0.080850382279083949, 0.40111489167071046, 0.090279121397879206, 0.27765624069388645, 0.045096132827598202, -0.13899003024393236, 0.25211174363830263, -0.11304551050357163, -0.029101231074706115, 0.25950324874102487, 0.27846687588852087, 0.2479515350158901, 0.12819628368787256, -0.092891147418803041, -0.061000118994073024, -0.19228997917788521, -0.2207118876231153, 0.36366415085776205, -0.15240208483606119, -0.018011736295782951, -0.1297837320446335],
                             [-0.33469748837033442, 0.010196264912898283, 0.075875714794400875, 0.037974039728613775, 0.33322086685835717, 0.15265544510957996, 0.28773256845311684, -0.24902316585348214, -0.1499816979555437, -0.023813542921024604, 0.085354205478258532, 0.033457205396131375, 0.16014576509710329, 0.084628646151270775, 0.037040053195948733, -0.17882434971589786, -0.12451884540279844, 0.28140772745031056, 0.039151728700797611, -0.15714055570519495, -0.053579960794501197, 0.11222176166066249, -0.23791444651883284, -0.17367958363408384, -0.14537850043685999, 0.2233866458067984, -0.10792190765114923, 0.0011410540200126704, -0.18626869300151647, 0.40419341890314792],
                             [0.16865062554656121, 0.023838407241839884, -0.26121699013265159, 0.27622870412498546, -0.2581418759774663, 0.02846268081303558, -0.031660385821318256, -0.040034243162930021, -0.40659056601013266, 0.035238736995985752, -0.2378673995796862, -0.12599645038597546, 0.19787448507019725, 0.1269696123488612, 0.23067806263821314, -0.053547709475652135, -0.38004153281386416, -0.053367262744445809, -0.047196896500985096, 0.25539773064869614, 0.0098194298218721686, -0.078724466320102326, -0.011012344302636871, 0.15281854473821668, -0.18905509891395603, 0.031552653118614979, -0.056899162650587629, -0.25109150200328312, -0.24110019556072507, 0.019378996022343945],
                             [-0.055240743361556273, 0.3263665299216959, -0.19593519400502821, 0.040721828691773848, 0.27087394627571626, 0.052639047697314097, 0.074670352130565651, 0.39923014351022268, -0.13770204375716869, 0.088409292848888377, -0.18263936924109359, 0.0051449536152260384, -0.085999350925164822, 0.012294487623721314, 0.002070048865135253, 0.26738881838909934, -0.20856666608121671, 0.057055364245337768, 0.085899380154239882, -0.10487225638334068, 0.26100816131698368, -0.18615962874058598, 0.08666384564075208, -0.051673600910660186, 0.039396297525910097, 0.079050483013350145, 0.023648151165169874, -0.064734616192001507, 0.47642083024665283, 0.22901834101104943],
                             [0.21502650057161696, 0.15298574157397951, 0.33835261620452789, 0.17458152050635437, 0.030986844501704067, 0.25746941321940281, -0.15184216799287556, 0.046487576709874447, 0.19991045784638123, -0.17825565723896003, 0.31003711762111091, -0.43441628695513662, -0.029237661539832042, 0.28363345378014393, 0.043658123762290342, 0.15745735400635144, -0.14887476422325066, 0.10590906974257301, -0.19028783341662764, 0.10993842190274591, -0.10192603396989179, 0.064379822637254239, 0.19186716265856679, -0.037627645254099951, -0.23958626985921899, 0.096323419678326153, -0.0055744288693119837, 0.10651455121908693, 0.10243621341128442, 0.073213868159769602],
                             [0.080055188960021006, -0.082759418680817015, -0.081980256620963365, -0.020302799634217137, 0.028880236963488473, -0.29456870031324717, 0.016589465199748112, 0.0082650599859069342, 0.37918548591256285, 0.36295508156991141, 0.069729120166875797, -0.14058665352103916, 0.019245774450380154, -0.0032524663797319376, 0.43345499030944723, -0.15420964392130704, -0.26613726665961562, -0.081660962793694017, -0.053285732217167731, -0.24979043847194285, 0.26993030282368052, -0.030756693902214704, -0.10545499859099323, -0.26048840602998491, -0.19631013584670773, -0.11436236961386589, -0.076131244424141709, 0.14123281577183958, -0.026715776317964211, -0.076699676818876822],
                             [0.23520144034465143, 0.13711514543019365, 0.019327332295153925, 0.082772818367102458, 0.11535890639260449, 0.21838114689090934, 0.25596694612813409, -0.17432550207992881, -0.070458545619446172, 0.13911521449634767, 0.093696994445712722, 0.18670535617282188, -0.18520951647931261, -0.049550361413860898, -0.24429876771391848, -0.16248648054940662, -0.27693975594562092, -0.46253844630020752, 0.08125169912236492, -0.14093512305536077, -0.22361350714417091, 0.18362095439213569, 0.15111600340892545, -0.076407358713033127, -0.085639673362220073, -0.20861880876267463, -0.2523698434420163, -0.061595024541270658, 0.12944014956083746, -0.079752018577344555],
                             [0.0084057348082170573, 0.32569304546262545, 0.19966931563466792, -0.062837792677405344, 0.013889163632485471, -0.072933688469243738, -0.43479078593030679, 0.041614714829833345, -0.19880819074116945, 0.080640992682629892, 0.21050501674211194, 0.46183762184945698, -0.23659735145543631, -0.0075040575914358818, 0.15409414094012697, -0.34626281065366643, -0.036701363169983243, 0.10701099041933301, -0.19567500567856663, -0.0014987364666048551, 0.01424390350065402, -0.10496815168171952, 0.078598543815821098, -0.012235183126777511, -0.11572168552581076, -0.051234450609318985, 0.20213094628443257, -0.092674948896036238, -0.063134171942514528, 0.11114156506583013],
                             [0.15193827686745043, 0.038129821961968048, -0.35448657370568942, -0.0074370861834758238, 0.015057694542182823, 0.11883925216329776, -0.056454728029494888, -0.050116725984749366, 0.15449185074736141, -0.24457551277872591, 0.072305447584402868, -0.024229180110340979, 0.35563335729756335, -0.25082415609292508, 0.025412461519296835, -0.27036180920460023, 0.28811658953176211, 0.12325186137501544, -0.10289234815536945, -0.12386487770881986, 0.1257293656524969, 0.21833469204505834, 0.18571166923962018, 0.0029773217582153744, -0.25396877627662334, -0.10336534589088631, -0.0014946779478461293, -0.32779613958761888, 0.25690120479418244, 0.079529137901822256],
                             [0.075823870718186068, -0.013718349606819008, -0.074095653440370945, -0.14258884763025939, 0.087673971410507895, 0.22999677787298634, 0.30265150824723835, -0.12256427559264303, -0.17732676515981763, 0.31477917799260147, -0.027327458787718667, -0.21120923179125722, -0.15894287458466075, -0.080372784649871659, 0.0017345691833940832, -0.05139657543455349, 0.19150351537628324, 0.14089390951398881, -0.55439335805735745, 0.21306154764971388, -0.046456771312139093, -0.18953949304585191, -0.14695393024037889, -0.16712909564206133, 0.03038614719775452, -0.14466280316754193, 0.1876019257034571, -0.044783667561782016, 0.11490529152710295, -0.14712124028969059],
                             [0.19773384190792168, -0.17438818393456462, -0.14181640402855547, -0.093414820628706721, 0.1410785264387624, -0.052003007411268745, -0.048551798899278666, 0.56218917477122343, -0.17967127078643727, -0.075434764900268403, 0.13696061367226284, 0.077527014548506787, -0.00089269140053090286, -0.024712051262804853, -0.069720125723696666, -0.1746437967266399, 0.079185288493621817, -0.012944962880178143, -0.11535731313366543, 0.26285730645526667, -0.031879798104962914, 0.18047858205297196, -0.13922799937807886, -0.24147771825338407, -0.039463561943671718, 0.21366827914464998, -0.40428538457330904, 0.19980424794615506, -0.088136546671937474, -0.058693455691440043],
                             [0.12396445899608625, -0.33441154147974789, -0.16596491573990682, 0.19513868673308024, 0.24037971882395681, 0.12452222877910836, -0.013674395103778587, -0.037248001636748865, 0.16795328969632708, 0.2745886078305349, 0.26907824119648477, 0.25361316059801742, 0.041652601141381349, 0.073563621930960194, 0.2963696257136938, 0.12289308767735801, 0.18626176136855302, -0.091213838018160895, 0.060266358903388849, 0.1654641553183282, -0.23143994777621288, -0.26314518633944817, 0.089623153717506981, 0.28888271524698883, 0.075560120492203592, 0.091854119186784891, -0.065411490937583902, -0.037871341854834852, 0.08439250604896624, 0.25807132810344463],
                             [0.22088081023239839, -0.089605232405063046, 0.28494233979235178, 0.055490973817915942, -0.13634427426067269, -0.24649170882338942, 0.36057592656154691, 0.048203842538364836, 0.085509599348061377, -0.15866056457012742, -0.26843301536988717, 0.19764666935047484, -0.15481921666594231, -0.097176625834495683, 0.11421614317047848, 0.122444139019071, 0.093362537691711447, 0.18436576458183221, 0.0078441427332934695, 0.22908064754103419, 0.0015509177154807291, 0.0076829498547245053, 0.1967133377088422, -0.18000058693128368, -0.15501635806354427, -0.30344453951748407, -0.090628578372384319, -0.031449144957174241, -0.045386774289899241, 0.3852183199956315],
                             [-0.070851505624966518, -0.28875924353693178, 0.11843886583377851, 0.36619427584823711, -0.11597732352016303, -0.25994488402531329, 0.08669835689344034, 0.19689878426848773, -0.19221353301606836, -0.049657758089697961, 0.25984750787939248, -0.14344255041051746, 0.11639664323406035, -0.30203461052006225, -0.12212462161053458, -0.18655831362420916, -0.25561266130514781, 0.074893252637179011, -0.17814493945675544, -0.20051673254049934, -0.16718763202014547, -0.027082446583220669, 0.028068641421300913, 0.09014162813760522, 0.25011159072282613, -0.11815717900584632, 0.18679225411243341, 0.071693583735290375, 0.20527270468788947, 0.12243908565299529],
                             [-0.33765169035150766, 0.22622168205813026, -0.090850553139780271, -0.25496176714951185, 0.040984137068644746, -0.28805673223102707, -0.01271036373877934, 0.037159006243582822, 0.30595382537113386, -0.021852736519684671, -0.058072666160629546, 0.034033698044994586, 0.28445616963789916, 0.041078052323419448, -0.13165869652019518, -0.020169132810546147, -0.22809840411612989, -0.13547741550797465, -0.22349112569787596, 0.34598944573236645, -0.41826016931580634, -0.084728678579414629, -0.047049713869316445, 0.064959145549058836, -0.096294525236270356, -0.10081073497647912, -0.061796612527412642, -0.029189209811086029, 0.13153889487123621, 0.079967927077630396],
                             [0.082136963595591542, -0.13541121994576097, 0.27755815088927005, -0.14349172411445288, 0.026310323046982345, -0.078733926696783238, -0.049044443037249884, -0.12070142952071816, 0.034162749976473325, 0.33474923573401505, -0.2112631205136993, -0.092608970164663185, 0.068639495065000458, -0.14966485459299581, -0.03446318793915322, -0.24889349260092269, -0.11474060686367554, 0.13528498510835876, 0.19684951991061639, 0.23993066909490315, -0.02535361806556824, 0.1286833058226452, 0.3216474146622601, -0.08993817117628132, 0.10678320809699875, 0.48788741204666658, 0.042309532999414562, -0.1831473642368508, 0.22237267845587178, -0.07741246952585408],
                             [0.069667437331744839, 0.19897155368734842, 0.014495264332288654, 0.2452195223781658, 0.079035538258263899, -0.038535180000176805, 0.2118695454388298, 0.0097510159169589081, 0.24280451167598549, -0.18085811662264586, -0.014387087806316949, -0.023200670204567862, -0.26406656271511936, -0.13648756488662381, 0.10203884319055574, -0.25113913935023513, 0.0087047178376366031, -0.19244023099132548, 0.063910812857344984, 0.31562632356504444, 0.1752502522725633, 0.20467263515985956, -0.42619347357750637, 0.28075873826220477, 0.032966851797459007, 0.19500859040348476, 0.25846680184668913, 0.013660079813449107, 0.085595936689896013, 0.030495114901382618],
                             [0.077365627762738559, -0.2085522076131883, 0.002793547078526761, -0.29023227785035527, -0.11949382565717845, -0.026368273193653074, 0.11035212294669525, -0.012420543887198378, 0.080493299054539294, -0.30172356070401718, 0.16309996525203785, -0.056343587036317588, -0.1130472738408564, 0.11504706726164964, -0.14032132206577305, -0.092649203689109338, -0.10221231253392436, -0.35274796179091339, -0.13009933373379359, -0.083812903910460021, 0.20646228834012917, -0.40451471066324945, 0.023938631725653234, -0.15577158218385076, 0.083637614395354998, 0.27013790066289567, 0.056311390142979145, -0.35146546003638157, -0.089304883854592648, 0.22982703141042671],
                             [-0.092728881560640769, -0.11274691245697267, -0.040069123571505813, 0.031518162239936538, 0.39483437618561384, 0.051476683750876821, -0.14986606251033877, -0.25945182804483241, -0.00083286890001828772, -0.24842122906723013, -0.10019270716297282, 0.094865379291294363, 0.031262455854944568, -0.23937012372915031, 0.099858919755912087, 0.13519429558436702, -0.24296258213369923, -0.11909809720829417, -0.33063309845741007, 0.18640597505217399, 0.32088390740508976, 0.11346209529513454, 0.30842818129630317, 0.0027218191365685467, 0.25216831994035838, -0.045938639079236808, -0.053497088637845053, 0.20435713210965797, -0.14280893091818117, -0.039005715738587445],
                             [-0.35757674908306486, 0.22228386799391631, 0.30511913748976766, 0.10761129845861428, -0.11301271744131944, 0.0010716372515159258, 0.28029447711416844, 0.10234850552896037, -0.16573388501765268, -0.038052717358385758, 0.19800363260633908, -0.00076910014111533827, 0.1862026693470708, -0.18942486635530648, 0.34966910648206023, 0.042199900665265092, 0.2530474057902547, -0.26440810443661722, -0.015920892421560941, 0.043314691117990779, 0.10271076839980715, -0.1489609324592916, 0.17829582989893444, 0.00095462363757594531, -0.078527337719211041, 0.12333448788821101, -0.23012802448890013, -0.073556184800103952, 0.030079774528758294, -0.26880801400624388],
                             [0.30364425523936733, 0.16916953432126561, 0.28177432304294359, 0.16095812287920128, 0.31210072471556338, -0.024644856556705213, -0.080137473577438847, -0.0062102387778722431, 0.014361467692084257, -0.051250377064818761, -0.21206713629767202, -0.067976361317878625, 0.42244259845359489, 0.15814486685610629, -0.094231599575631722, -0.28382901916876396, 0.15495930756528623, -0.068316579159076671, 0.099146889715876152, -0.0024276404054780374, 0.061722733835544337, -0.36494887287687683, -0.15138907816901509, -0.073510751495159704, 0.26345484198488339, -0.20459249491382636, -0.071510359961519346, 0.041208303073733681, -0.032540266898791623, -0.033134636977096607]]])

    matrices50D = np.array([[[0.11033085648536158, -0.02272719173737283, -0.09879426693401705, -0.13623606743659694, -0.013256918250976354, 0.22570841712587608, -0.027194205157719111, -0.045825586621581788, 0.068592248640417561, 0.18729476924159158, 0.1705341260438461, 0.28860000557670257, -0.054913364327775382, 0.045502336531140684, 0.077057940184003401, 0.058611878505767295, 0.13039619483770176, 0.17456796302647049, -0.10614103835374053, 0.10884600585789378, 0.075049418182523156, -0.06830975359017627, -0.20035678695852771, 0.062070435151910637, -0.018584568788605597, 0.064435615565311022, 0.12685003307903117, 0.019980936588667366, 0.20383676524849184, -0.15778883325180296, -0.39941946357838876, 0.17182147228546812, -0.18861332618646809, -0.042677722854712483, -0.065174291422538319, -0.023857350111116643, 0.12354873380700228, -0.081357499026681324, -0.14836237344892314, 0.095341053735513034, 0.083035637267027507, -0.12212955224881733, 0.15280070968610954, -0.13451881680236327, 0.13899762490680573, -0.076162255423115305, 0.048522525294926233, -0.27360347398998697, 0.25621742093576616, 0.10297655952475621],
                             [0.034384950427602846, -0.07852799573628573, -0.18588623669977658, -0.36754028660748089, 0.07267090651314749, -0.039367245576663122, -0.23238838789744326, -0.061587081730367102, 0.14359312140889283, -0.14409933951244625, 0.077763086233581691, -0.29003634493118474, 0.15751002447107376, -0.013193721173721539, -0.034831062021843412, 0.129744059022883, 0.047539419244779405, 0.061914701833450887, -0.1352434324567591, 0.1846996884939093, -0.028777112333193411, 0.11267509547710858, 0.20168952228758955, -0.0032250521194494329, 0.12508193965823947, -0.061052165477876938, 0.081126872062878372, -0.041213011622179829, -0.065477337622449269, 0.14444827514848643, -0.14405311921059233, -0.19337373001583619, 0.26789648944360145, -0.092961424786653118, 0.037074010407936432, -0.021472475477524133, -0.16111685035976278, 0.070401589795479336, -0.12051230485801834, 0.10868199506656441, 0.14442498251452998, 0.054681827586097416, -0.045113827243562755, -0.35993721576614074, 0.21009502527171173, -0.0076995297542913959, 0.11069493628937399, -0.011975415799931491, -0.073999351927309123, 0.055977621018564225],
                             [0.053048879047565708, 0.0030592612005458223, 0.045059243232942726, -0.068089779574949674, 0.17069995214754413, 0.26593031882591911, 0.22078774498483289, 0.039514478896490235, 0.0049675502715795005, 0.18459335815311889, 0.14226065743819546, 0.12589507081847756, -0.089667567196771394, 0.072799371694473494, -0.15456316698465822, -0.076376559853859924, -0.10815799252523761, 0.086920439526913584, -0.097995458849082409, 0.034670991691772089, -0.18547319488961664, 0.24201527881229448, -0.14076144542998906, -0.21894366849762298, -0.038323602697347553, -0.28251166083386953, 0.0045892793656175752, 0.21682164315335808, -0.0244408625146404, -0.059827514767662612, 0.02942906686988116, -0.11793451962754248, 0.18104986013891092, -0.3098269730488038, 0.33818143578037435, 0.049006645541411924, -0.11059155596714604, -0.2416263839477811, 0.090927546833924525, -0.12321185039227465, 0.055913402941000827, 0.053429976978874888, 0.061546299605837157, 0.038476110409728266, -0.0019683696239804261, 0.068320969020298009, 0.090366504679597559, 0.15422117347278047, 0.0046727367479556291, -0.039391812268573058],
                             [-0.13761051056447199, -0.004188860996138276, 0.13761840114375296, 0.058690326991521963, -0.24571213963063621, -0.011075358565829575, -0.14957729391079297, 0.063261437262776304, 0.044737518195302597, 0.21659342690087099, 0.090776000270280419, 0.15638037405808936, 0.17350978550649637, -0.13444100275290158, 0.21865329428788066, 0.18691165499029802, 0.11667336037715577, -0.075167270699374913, -0.034082211952977143, 0.024408716955020657, -0.13855959312957833, 0.030740529455105366, 0.038857076208845577, -0.03046384039593553, -0.1125531584562251, 0.0010068404287230761, 0.16015974371095473, 0.27589254724252826, -0.24007184760677763, 0.20451884517979194, 0.010867470173243602, 0.023767062855611389, -0.095411497863000849, 0.24280864143786787, 0.042604030898252133, 0.028932915886606365, 0.040577763438179364, -0.23228824434285297, 0.11719003615568235, 0.030442279509795188, -0.18665539937773021, 0.33232978816698183, -0.017770884938056106, -0.2617161880964563, -0.011993303511790229, 0.010752936451886774, 0.065228159568313154, 0.15271722294538126, 0.11544458984246375, 0.06954262524795024],
                             [-0.066827170550730688, -0.24249192658228166, 0.12762255980853612, 0.012539896824972075, 0.1996216399913146, 0.00044529255423579226, 0.073149497962653603, 0.14784000854031978, 0.1019477911160158, 0.10060773930719934, -0.17224843814976695, 0.04061628021051087, 0.29835435275853045, 0.072424834038493771, -0.17030844889389846, -0.25932886623439255, 0.071425712189428378, 0.15765001891885383, 0.084199867773869883, -0.07971869244992616, -0.097672166574579167, -0.072831349949338847, 0.031967570029482716, 0.030295952249531213, -0.018261779278047986, 0.28239199520034308, -0.16834134840327619, -0.1264752917784652, -0.008568612966559563, 0.0016802586255104119, -0.089565928684836052, -0.018830614724461823, 0.13238084571862713, 0.036826141057666982, 0.029763456677333044, -0.010116851511421322, 0.17337025256292538, -0.2353736338952708, -0.26698523680358494, -0.12407548676241323, 0.15523666422148855, 0.24377318076827317, -0.17152839737484063, -0.069172130341096649, 0.054725706767556129, -0.18964197026503909, -0.21095663040321697, 0.080428052028168023, 0.12543371765917039, -0.049307120815892294],
                             [-0.061390624229354838, 0.051096321741326174, 0.011649278161890483, -0.04133958235896025, -0.020216148481527217, -0.027440897375800015, 0.12714822916537108, 0.1168766064023373, -0.032252294530476483, -0.12364712292648247, -0.1686423521029686, 0.07545713708895635, -0.01093636676490356, 0.038819753180883487, -0.17589826537831063, 0.30455044648380136, -0.11596098215322512, -0.086262769761593069, -0.13962378981190715, 0.0057732121834612998, 0.20012592946135019, 0.012836879348639904, -0.095087339370824378, -0.22103325492182976, 0.21162061275204633, -0.032640489515210896, -0.25066321761358767, -0.057611995588937093, 0.094078206242105236, 0.07371132859356426, -0.17272954804551333, 0.056049252933150169, 0.042152880144033789, 0.2099259295771384, 0.13173105175395874, 0.18977128205672469, 0.1994367737732359, 0.018485842389474261, -0.046073325567025439, 0.12037003511596964, -0.10589065725311098, -0.14937819841551384, -0.16766459232873068, -0.1385952150170183, 0.034893040347390235, 0.24710315008593192, 0.080546487819297796, 0.24148801857506771, 0.29070427741532051, -0.19707609781488702],
                             [-0.055938050099885422, -0.097472918499936459, 0.024808748267160289, -0.16513916991886238, -0.035035124910775872, 0.041883538350939352, -0.14965896472298823, -0.11117611007801036, -0.041147900009794278, -0.19245634448433077, 0.18725741075702629, 0.20760661848005169, -0.072364988468529665, -0.12421311836445646, 0.23094983353806314, 0.047499123741630754, 0.065815433665933509, -0.18152173633728599, -0.1742745463306965, -0.21290172436637433, 0.061449920086031132, -0.28927368341516224, 0.033198069818826385, -0.19087443857146227, -0.075317123290684254, -0.11049117992424322, 0.02969029133436631, -0.079809910329006903, -0.12498831541494876, -0.27663106287292871, 0.045483458697602973, -0.19990011086512938, 0.19280864250304966, -0.040766708610729875, -0.11755712598691513, -0.06087598634488664, 0.04312123641342732, -0.18024699704772532, -0.23257841006795596, -0.19529559811262753, 0.034765033950726429, 0.016048930629860781, -0.10479327197132217, 0.064209072609939785, -0.057267574855206685, 0.26096934584835935, -0.18472914530786161, -0.055493198983946126, 0.013056270191798844, -0.15176595058084758],
                             [-0.054303112601868042, 0.15628161974806523, 0.034428258297698321, -0.12368858530612811, 0.092214897348300656, 0.12479650003295724, -0.0048736227372515317, 0.12399607922764695, 0.24130830237381193, -0.11340377187876474, 0.33551905077821204, 0.068180511277117981, 0.18615837007780736, 0.0054346369439947804, -0.11832498569625101, -0.0016176945398527071, 0.12586295502365485, 0.1726328458585068, 0.058416647740133283, -0.060554718703811669, 0.13140189518851825, 0.013918812637324255, 0.0039613946712258926, 0.0022726363127268164, 0.08513527806820094, 0.18561529770400104, 0.0043190769024278415, -0.051026033866709224, -0.18988081952038438, -0.055044064599547533, 0.27525040889278918, -0.036702430798399743, -0.16394343246949983, -0.092339769368161628, -0.1981994323231307, 0.20315033954236988, 0.084289026409618259, 0.1518865915489829, 0.29900752735524738, -0.13496958662382824, 0.076998118933358381, 0.076964027026094839, -0.09682739795116195, 0.13911005742806448, 0.2216218814540746, 0.093263709727765556, 0.22100069227455824, -0.025262003479153708, 0.16436673197780788, -0.14248463243221651],
                             [-0.065017307543570865, 0.10248929145812412, 0.028461493080926072, -0.24341341113545811, -0.10446260017463144, -0.029782223865604161, -0.17827474775429691, 0.027807474339287042, 0.12242432242416738, 0.31351074276082602, -0.097479694101340997, -0.0067036168314093389, 0.0073271303791634847, 0.086818190814569249, -0.063472520132850097, 0.032946252967330877, -0.021191562819020994, -0.060065619254129211, 0.11745605868114679, -0.13724176466581273, -0.12830438527226229, -0.07142784992059896, 0.033660640137923505, -0.23204745183198003, 0.17590335776581562, -0.1000695406007435, -0.13209584657732096, 0.087434700403159565, 0.066473947038955095, 0.15887565198380565, -0.052112056251933193, -0.087475611468580822, -0.20036164643001347, -0.19056327813377044, -0.1486268277684944, 0.042149207961989579, 0.27065009122169154, -0.0020332788052454128, -0.027467556852929651, -0.054827194294412185, -0.17479817062951911, -0.12942880177362839, 0.09181210489339113, 0.094922188750351744, 0.32102945791479548, 0.013583957332682783, -0.25864979594585197, 0.036842273845402694, -0.33342618953422876, 0.035404002535297921],
                             [-0.15445427519100233, 0.031999567809306934, 0.20357885876625853, -0.082304775117393994, -0.15979279336776847, 0.03287324577610528, 0.10865111188710498, 0.11296711000328681, 0.11387059435270011, -0.14931804731436216, 0.048491111630018839, 0.020591295654237524, -0.073009968570337133, 0.10150636850576011, -0.063021028124935971, 0.20698406540034062, -0.027164610531644807, -0.11930945223820007, 0.033277795439136892, -0.087528996957994903, -0.41542010716705702, 0.23677516058208961, 0.13731202426053724, 0.0056006675436310648, 0.099919314680195867, 0.058720237554117621, 0.071877311661326007, 0.0085765908649527659, 0.21053617813529063, -0.10189175097914775, -0.04678354706865246, 0.040428723671624957, 0.03804198028740513, 0.1664608593263035, -0.20564248182294415, 0.37648240145510764, -0.15657994331939407, -0.099506113172680904, 0.012641117354372164, -0.018994553480953934, 0.27911122907021524, -0.064207213650562492, 0.045513641103291189, -0.013864059119797139, -0.17050788277063203, -0.052323946473697057, -0.14731587383033171, -0.19782717454841955, -0.041179124221886326, -0.003399371174217194],
                             [0.072521478628860089, 0.064271618685978332, 0.20598515905132009, 0.10087406710847191, -0.20113534912324793, 0.072108676751086301, -0.10047503805205071, 0.0010236319419434034, -0.050149941696521413, -0.074436556508722745, 0.0080242443886645379, 0.20049316778788059, -0.053741002940084263, 0.18556174531040279, -0.17191590075259935, 0.31655020323110278, 0.0041223867969254948, 0.024994368252825281, -0.19730310608544485, 0.11094915673844728, 0.060365653412605837, -0.22100658785458357, 0.068435972315043794, 0.054522039628909794, 0.24643464469305712, -0.060553264560566943, -0.33616054304298748, -0.091084508878568379, -0.080245527375330666, 0.081612950618940111, 0.055929570801543226, 0.052165470282886907, -0.083329400250188743, -0.08069662867102384, 0.074270957239592775, -0.27478862496660439, -0.12513232547407477, -0.055059949446403605, -0.0020336982453329489, -0.11144940631888271, 0.27049893614132581, 0.23473382397837189, 0.026910857166544778, 0.096277418336105161, -0.010649299271616291, -0.16956058730857554, 0.10223265154953752, -0.035391357443363539, -0.12723737440517327, 0.17195401034154426],
                             [-0.20694210727541226, -0.27347306178906788, 0.088296049855470293, -0.031833476732863443, -0.039863285969766279, -0.098759508289028686, 0.13788886146071097, -0.048905982354795388, -0.058307694618879899, 0.024847120856702629, 0.18736898966980367, 0.035241080825733719, 0.2169772193848272, 0.12082231874343868, 0.20843681765701258, 0.040994042532004393, -0.30966719379562652, 0.0088845561150428919, 0.0095023486012195593, 0.22201817137597504, 0.01409777334714981, -0.032105167111171368, -0.23037503833088743, 0.041065140268803285, 0.029245495281377848, 0.0448883901621051, -0.073173557237127956, 0.13181402076070287, -0.18734099650282393, -0.080675524982937272, -0.044256914095965175, 0.058884901603556514, 0.027787516147998965, 0.0064168789746856889, -0.00069018430645859954, -0.040237881891397868, 0.063160718554129774, -0.080697819399419238, 0.12689632584437491, 0.17016570852210733, 0.085078981707660234, -0.27406631334324444, -0.3689017187070337, 0.0396327756024503, 0.064698250868528012, -0.1046647306209105, 0.055986974455448445, -0.13849656925617906, -0.31153774216687419, -0.084678590266572137],
                             [-0.018045176334766003, -0.0013429068017714733, 0.006141610778218811, -0.21747894417023797, -0.18588778970491893, -0.025713453341283769, 0.13590537609954664, 0.022998293891001421, -0.036046838616375108, -0.13124402247731229, -0.062047230511555133, 0.11748959375858573, 0.050912230530351037, -0.0018475459242954788, 0.054753775438693635, -0.0019130836345797259, 0.30270722769489805, -0.092205484479614491, 0.24170895780287732, 0.39268825386881911, -0.005057928084883468, 0.10211186954328622, 0.099108981743317934, -0.19646896323990365, -0.023216446156394347, -0.013231799745613752, 0.21351641802149879, -0.26482855671922906, 0.1382674182362458, -0.036914019460831025, -0.046989704278952618, -0.01152666310295584, -0.16208035325055664, -0.17091370666669076, -0.0014213816236205534, -0.13371579919911394, 0.018130119937259069, -0.128720641381326, -0.043049403019505932, 0.19468462574465448, -0.013605741648324432, 0.10158000110038404, -0.097314832817744154, 0.2533261975783806, -0.10260659344479454, -0.098313043301349892, 0.081597010894894489, 0.25908260133178385, -0.051299700122959264, -0.18622999102759494],
                             [0.20057766867830826, -0.14085017035721387, -0.15642095354090538, 0.15070056913225391, -0.2267027080466868, -0.016074181622774401, -0.057627568985645895, -0.13469387695599536, 0.087830906063376887, 0.053378501834495697, -0.058045201015245379, 0.095991603121491964, -0.058205576454752946, 0.23928616525186991, -0.080953741005535054, -0.19532987733918086, -0.10367595067094071, -0.098547990842492258, -0.093759135096456656, -0.27237696873593858, 0.023856000255923736, 0.17055702589009847, 0.15944461055992054, 0.10782391465570144, 0.1791290265640284, -0.067458889930804886, 0.16524889042298935, -0.0095144225277746988, -0.063128414618141726, -0.22039680256779123, -0.094107224912429344, -0.086941018367229825, -0.25919557665006715, -0.091835327924206858, -0.11602122971662839, 0.085069825079905431, -0.026135218636595865, -0.021758830038496622, -0.07965147875125457, -0.091328976405752396, -0.028769334884368104, -0.022951481968131533, -0.36676624308330819, -0.14902293679596751, -0.039693489457488886, -0.060089408278123882, 0.22667045254681115, 0.23658844035350854, -0.025047401126975195, 0.067635604111886155],
                             [0.19056302074361881, -0.04836154865253732, 0.072724963075920718, 0.053308952484429017, -0.061612649565646625, 0.096053920659114625, -0.13568975562003566, 0.061411815200324578, 0.27775333465881008, -0.15437566187190863, -0.049087140163014582, -0.059195864823175202, 0.087820232693843189, -0.0097307681453962062, -0.0004309540197269707, -0.19901315943857417, -0.14278234929855796, -0.429257278647524, -0.051970604416367791, -0.064260201748608164, -0.11259431447834711, -0.19058438087719182, -0.053480799315244291, 0.003830648923093251, -0.14104014772120754, 0.062351705831612404, -0.062916124947783883, -0.038703306547163564, 0.094649791417410312, -0.20337940708348951, -0.045366150377887673, 0.067063075090357027, 0.068441848161189409, -0.0063505501391673391, 0.16101132205478577, 0.041444586480821256, 0.14587788709022759, -0.05707977148440492, 0.22301461040839601, 0.3851453554266035, 0.14006799472896403, 0.13629019627011871, 0.19083463719818436, 0.059653028512141063, 0.20360494781305277, 0.082329756584657174, 0.13575461051876808, 0.07157938680150823, -0.053689144647151216, 0.080126700469193665],
                             [0.017951090553761689, -0.060702416412293403, -0.27260181920293874, -0.11822981645774053, -0.055473728664875051, -0.020367288108354552, -0.10502756988611717, 0.1638485981986649, -0.085628669341840088, 0.084889691956122018, 0.14874858003688735, 0.17026061039384718, 0.10114193530064197, 0.016660969204813674, -0.38432214172498974, -0.037398417492785073, -0.030050771935175302, 0.14624416286440736, 0.0065226209114565897, -0.015658581129425746, 0.16170166165421535, -0.044161383187710068, 0.32855122463953995, 0.028511258998996529, -0.28537803962417468, -0.17093039422648709, -0.12743118449052773, -0.10743989324176879, -0.0050289947720264785, -0.064198079127110286, 0.1963246017326658, 0.023882083107371985, -0.084384399143243999, 0.18346393989804513, 0.075312632068609053, 0.10061678189114669, 0.018315388536192172, -0.25887140964832883, 0.061957704497275487, 0.24205602457431583, -0.062415928111684407, -0.1288796091069038, 0.050543253184134579, -0.081520665705012901, -0.18017945434538429, 0.025063344171013264, -0.053727721271660062, -0.13920699755238761, -0.16877166223913181, 0.0057370315249569981],
                             [-0.13387432335357383, 0.1011201373341329, -0.32440295199426861, 0.0043106722814494468, 0.15807691009135744, 0.014405297053993162, 0.20672311325175094, -0.095247146542746908, -0.062736263696297603, 0.091186302730964078, -0.071228390629860402, 0.099558229207888344, 0.19018122759065684, -0.037838974941970346, 0.15337695572285748, -0.045539131618456213, -0.09737214678577466, -0.26722885185229822, 0.042627284976343119, 0.028247194855187438, 0.16733342795164091, -0.1173520698831528, 0.18332260909734138, -0.11625595119700681, 0.37615576174562576, 0.10509675750785903, -0.025625749117423487, 0.27721660443835278, 0.080655466692221275, -0.015630600866829863, 0.15355393764704134, -0.25326136402415828, -0.10096349911191947, -0.040540844266982588, 0.06716641582967782, 0.1231265827674474, -0.029268561249318276, -0.051002499332496301, -0.082090011354667772, 0.14095042588496073, 0.10143622130842789, 0.14637409778484414, 0.10841163140028766, 0.05034397656087914, -0.12384978679281274, -0.13988681036927347, 0.027516400003544651, -0.19362098821192458, 0.12259055097829742, 0.080539243637763269],
                             [-0.11481081610773915, 0.092377638235440929, -0.246633848581578, 0.19051321530753457, -0.091739253511210525, 0.05296581962221629, -0.08285783238948348, 0.097555119566407222, -0.011886401080872348, -0.058797876736794215, -0.0095292546914184147, 0.27523387311688735, -0.023652202839035342, -0.10183792641849748, 0.21499469744815361, -0.084398489777657251, -0.25785157911973117, 0.065407178492508683, 0.059149498236347971, 0.23307470654151952, -0.15277029334559472, -0.04570726791819555, 0.023199081067809903, 0.23413866760617436, 0.02847680937760199, -0.18717981790696664, -0.077361960628585469, -0.28153210028997883, 0.13986391192887873, 0.16603818560507871, 0.060940968241243794, 0.13813224936429622, 0.16536123440933001, -0.28273460952016399, -0.035951917454771318, 0.30262747653719152, 0.068693593931921718, 0.043826812473066946, -0.037077344153156562, -0.064839533005136937, -0.089207939819389584, 0.19367183417024569, -0.13605089576698465, -0.067213004133884757, 0.10676635547942243, 0.098922914004114265, -0.06718695046099489, -0.037048634923724039, 0.014507227861051368, 0.035944794536633892],
                             [-0.23619677428750188, -0.0020810833885609977, -0.27350537286849708, 0.085143888307926505, 0.054170420842539702, 0.053267841299050669, 0.14677848776051772, -0.026917065709473068, 0.19217415753063566, -0.11998014804846906, 0.055887565716114834, 0.090076743972347564, -0.015293069771018455, 0.0053940741016332847, -0.23101158676677613, -0.1026281347929278, -0.15368056972793723, -0.055921857416537948, -0.0039643592601971058, 0.10148144400305917, -0.34426596858359726, -0.068925296243529277, 0.065118627870003304, -0.23478424379322385, -0.013643572450772514, -0.039125590919165454, -0.040755736484554071, -0.019373142614153908, -0.39016057133627885, 0.031635199693215467, -0.18559955912195228, 0.13776722342321479, -0.030502777831742503, 0.043839186327485548, -0.27792119673370125, -0.30489171327318049, -0.022832632027560047, 0.14922960613530487, -0.050936043740997486, 0.054823119432573342, -0.077100206706543772, -0.046184658813207644, 0.11492844709269753, 0.03758695357498306, -0.10414520663752019, 0.053027740811400728, -0.0034079460330358642, 0.04035074316662228, 0.14894061964102337, 0.12515891489140307],
                             [0.083633844305095198, 0.097522684991570255, 0.13071629856242031, 0.10025480964348375, 0.15579037310050783, -0.011291091859636365, -0.27917929314621709, 0.21215597928260976, -0.17843673514950473, -0.16771810928854414, 0.075855608286766477, 0.062001383113580485, 0.22589426811735155, -0.25973104028491611, 0.090151714508661759, -0.015574344011910532, -0.028368406747621831, 0.2003373041817961, 0.13507976416210121, -0.054363367546340656, -0.19769182882017242, 0.069176335614412526, -0.0032722907945893342, 0.20826721834720435, 0.34748273915832895, -0.098632751692788831, -0.044818799866737931, 0.01871507907013702, -0.14686769373821673, -0.17984117081475359, -0.1478670232396842, -0.14678050027343922, -0.16937462335138545, -0.028284366345110026, 0.095352345213958828, -0.034368604839389361, -0.03137679859607418, -0.0835172559453118, -0.083772783528402228, 0.17895345782882985, 0.007195675123806795, -0.23575302042885238, 0.1388401264216079, 0.093627635117918301, -0.08856250837495426, 0.065672726217871499, -0.063833837850427566, 0.20551271384890935, 0.047182139623335201, 0.043630202808247115],
                             [-0.0056191549511735127, -0.006493743803614449, -0.013547429529551116, -0.2052809515197678, 0.11789700907240486, 0.086004864013239354, -0.048123061023776177, -0.24164008539850318, -0.15422240416543331, -0.16061777566128227, 0.11921400070231446, -0.0034597379832547585, 0.19917955245899141, 0.1208414395924013, -0.14690163466847181, 0.12064684414122882, -0.15164140661744313, -0.0616970998227808, 0.27517637873538503, -0.17234119905831094, -0.072741274865818967, -0.069952863374052404, -0.23230239604532585, -0.065250778053145123, 0.0086315447491275218, -0.091835682509640998, 0.24208063128811641, -0.089417368287420917, 0.027991468776561088, 0.00063411149850114816, 0.11525009045343872, 0.2714308655365204, -0.24343256714492206, 0.065211960369132682, 0.31224984584696858, 0.026030205744446266, -0.0082135204917667039, 0.19844741329470891, -0.11867882561041244, -0.034635930496988009, 0.026315786929147874, 0.21811162908524259, -0.10620148740520322, -0.09813410553402814, -0.046881157222255367, 0.072595854839627896, -0.1865716667300597, 0.0050499461046132421, -0.028645346462976545, 0.17082950888720372],
                             [-0.074620692019366566, 0.18725358899979874, 0.18077186206986531, 0.22447913817004894, 0.035083172507511029, -0.061677191347599136, 0.26187751695128175, -0.023176765408326517, 0.07105103221524707, -0.13020112956010116, 0.13453359481173002, -0.083920153477618442, 0.05971633467445301, 0.17850718462623127, 0.14282354811867784, 0.078422877743409156, 0.052701272096952176, 0.15485687988024222, -0.12168312178295768, -0.010146323913746822, -0.040012100876195923, -0.070680022464782749, 0.27308663407386552, -0.061500801899224009, -0.26454944653538687, -0.15563584572426845, 0.077518169812004281, -0.06851564384043432, -0.080502053725677203, -0.006773799995414896, -0.11467672796957075, -0.23203213562191946, -0.091968229300042573, 0.025507585629666832, 0.23738156901670326, 0.17780132531411919, 0.32001328435129184, 0.16198688534973227, -0.2771357894465204, 0.041340662717058475, -0.025057003397558834, -0.040391342038857588, 0.018472480179868897, 0.086077445130792546, 0.084040642469091625, -0.078896812934063809, 0.10403872658090116, -0.045536984752793233, -0.076222600654723346, 0.20428978717453977],
                             [0.10487005516646772, 0.01896089408719644, -0.089728309697514094, -0.26044337204723716, -0.080855176878042875, -0.16103960255852612, 0.1128709454905259, -0.093129857201340913, -0.19681665221327457, -0.070864765519253761, -0.044586103646161834, 0.0067880246699171375, -0.25922554183483726, 0.12454600734262328, 0.049148004199874376, -0.30061088044802664, 0.09728228877817284, 0.17676877204115049, -0.16253290963995728, 0.19960517506849304, -0.33431683826848874, -0.20316756512797712, -0.044469470447409551, 0.043056233043518695, 0.23554106648824763, 0.051004596998113695, -0.0021882955020788132, -0.019351571791003455, -0.089556027211334752, -0.095424509502380031, 0.18216074686467085, -0.036825357770854911, -0.043466169455389177, 0.38333706264023881, 0.13882874567791387, 0.10849980354347911, 0.040431267808944203, -0.085728231911020331, 0.073146550986916942, -0.056117112770958544, -0.081660738565082644, 0.028034368191069206, 0.031080992975064718, 0.02180130470453568, 0.22926044518017874, 0.031472434186267849, 0.033413357592228091, 0.014727467403963497, 0.028193441711525564, 0.04098493084561259],
                             [-0.11682079102086329, 0.30370576102568475, 0.017494956811870844, 0.071594608321349992, -0.10470490498159812, 0.10977391995148814, -0.087907285853866743, 0.059433366913271828, -0.27803104077291296, -0.061073692389085853, -0.17336087566014466, 0.044249311275477814, -0.10351627671982, 0.071218602614547807, -0.11193414227947589, 0.0012435739663630852, -0.19415792734693585, -0.050277017535160735, 0.21497475045433434, -0.010061389337147028, 0.0083148812993997442, 0.013246932339995882, 0.16660525147498895, -0.042810418241363217, -0.14169433841279394, 0.42414319481200397, 0.19002172335270159, 0.0053519338292548286, -0.15235350546034693, 0.016273064009381576, -0.10119925890181541, -0.055367662574437475, 0.0057751485515326467, -0.098986438560457718, 0.15799990539738418, -0.10420546022045432, -0.13541372881608471, -0.22365937463281987, -0.06530823333912962, -0.065051403895541315, 0.044809177393864544, -0.12895508862794353, -0.06218335895716931, -0.053573805185327471, 0.30407247584343933, 0.19675491304427176, 0.11441291326119568, -0.17467391463098447, 0.0023401749466256962, -0.033368165208187334],
                             [0.0056394487611649601, 0.090556258949128096, 0.04268579874098917, -0.260112656356558, -0.090358264103219704, -0.19056871282207954, 0.0038575905463792345, 0.24105832607327793, -0.063836426033513471, 0.13449006036768721, -0.049304800012084454, 0.094308846113741074, 0.0027088614037678615, -0.12773354440758683, 0.085454107287444819, -0.1147740959524647, -0.16070444993799651, -0.10424683719165455, -0.17897299333012978, -0.1269557211967072, -0.1410053600477322, 0.18109142758749674, -0.13037002526665503, -0.0030025836923979858, -0.056993223604080441, 0.04852480625687966, 0.049474367513828797, -0.18259648478744725, -0.0051948106292722855, 0.17396192608036493, 0.2665966772095133, -0.052619578192996889, -0.079247499826494192, -0.083989744594878679, 0.049429420265530266, -0.23592717403058608, 0.31507150820469038, 0.1334340023714293, -0.12261504711930366, -0.035756713218751748, 0.29100491333759854, -0.12370099059103236, 0.040782921619184911, -0.14581536813463211, -0.22019218139406707, 0.0059536105370484689, 0.23973338075219822, -0.094589215248848849, 0.077318640707599126, 0.026289542089538459],
                             [-0.24625242828850585, 0.077836115531402753, -0.19661843655074912, 0.02950163800237501, 0.21202206948896452, -0.064533863491593846, 0.094732841169177101, 0.24770394579943819, -0.06063191561397422, -0.17837630224500359, 0.091837395282877751, -0.061626679421853785, -0.13400773713928252, 0.21988188278278425, 0.039430400373580178, 0.020485780870529328, 0.28367961746879783, -0.18115583886324935, -0.1049692983515368, -0.23941808624551242, 0.057678252644375816, -0.072156653095174605, -0.088621297471653662, 0.22659441567187477, 0.14146236910802035, -0.043522197538281925, 0.14877897429769305, 0.010654908863058131, -0.1290158505627757, 0.10368418250168962, -0.037011237923834324, 0.3109843633052734, 0.032217731256425818, -0.13937684162080946, 0.036244857923413129, 0.0033806175261262106, 0.10976050037658443, -0.23721975031840731, -0.031420879731564939, 0.0098465556913374854, -0.026021721706330263, -0.013688268307901789, 0.15689200639198583, -0.12098616979691343, 0.019812193334085543, -0.13711374002165391, 0.067639468268259922, 0.096790932608075128, -0.22292451365898475, -0.15867802420448726],
                             [-0.029749603104541576, -0.029313908256666025, 0.0014000801846139933, 0.003631760118131233, -0.045997808862027922, 0.071071268302809035, -0.070755114893384138, -0.13204748230632593, -0.25520276044921442, -0.1714635638218453, -0.046467271738103999, 0.12781729158082283, 0.0042849882451350806, -0.0059277947589746818, -0.086682508475111594, -0.056795273716192606, -0.16635164395646282, 0.084073671825964799, 0.063471508249666533, -0.02743637144449004, -0.0051461227020222359, -0.28709962517898235, -0.10524924673888317, -0.064466989770036037, -0.20957833048915064, -0.082613640464052104, 0.087052111232823928, 0.089657173139767218, 0.027257154125322789, 0.18415735804059644, -0.084629690913875108, -0.2467754803813485, -0.04633423138242164, 0.003162675307599578, -0.2006211393876266, 0.18523087451586492, 0.021361631738459071, 0.09410173890561184, 0.12611818588959559, -0.046054452249942611, 0.24624954092240245, -0.065947278096813194, 0.22277074408293801, -0.18399629308478169, 0.017031642035344515, -0.37084489264279319, 0.057091454285976007, 0.27580230168415726, 0.013824465717845201, -0.26204064646525371],
                             [0.037584495357108554, -0.07883939514255893, 0.11973628366008401, 0.16375513493237254, 0.10319072176160043, 0.077430813093908743, 0.21919326668938174, -0.16281623384146166, -0.20567680657647719, 0.12088237264721514, 0.16049617839833344, 0.067481250762691194, 0.024654995679256435, -0.048096248304431544, -0.015880749311256739, -0.088525127176581245, 0.019361113719608608, 0.0439506026343843, -0.15606045969631951, -0.17274121830651962, 0.087754857873130879, 0.075830195398742764, 0.0010138076949231861, -0.071185019938752772, 0.15523905045285558, 0.013564532453553116, 0.20110492077262235, -0.30462267610647875, 0.058525321684304472, 0.35837810132528175, 0.0081606764885427587, -0.074222468446625861, 0.047370001705401718, 0.095464964839640773, -0.25753651898409863, -0.037044561113248047, -0.05499342429332154, -0.14389655469673845, 0.088525040692402537, 0.30918964731026466, 0.16323738856484388, 0.027650684420587626, 0.011420633691820196, 0.046616529000387562, 0.16893385833766222, 0.25604874996841304, -0.094885146917407348, 0.086642111841383082, -0.091273765057383299, 0.19217081171909556],
                             [0.24381518213829076, -0.015266530681303524, 0.040419366832514174, 0.073195585717258926, 0.22975528725660299, 0.14218226929535105, -0.20777958134172245, 0.055117799800156866, -0.11344900145337812, -0.073702785918003472, 0.22565876238035773, -0.052604935228202504, 0.059488606989857765, 0.25486881244246012, 0.23161219790820653, -0.22767823174160901, -0.041408144910806258, -0.24209338029629532, 0.016768444614061503, 0.1996466830412999, 0.027948165374359311, 0.20051735898042056, 0.070915964589249106, -0.23827283500195703, -0.013543938755489737, 0.036363691279638372, -0.23693316503011369, -0.1245166031071087, -0.012106871458853729, 0.22672063593398839, -0.14491902234674789, 0.045645259164446637, -0.19889435122701951, 0.19007175236789206, -0.034744024028422263, 0.068566452382830531, -0.015152793899326635, -0.059020263580763781, -0.02361975088272766, -0.25362131017482764, -0.05602095301349317, -0.0017206007436552351, 0.08738569836660301, -0.060898512248227156, -0.11590404960367164, 0.034072671739910965, 0.058906604259647541, -0.1092623950847232, -0.075498444515094465, -0.1293468746939746],
                             [0.12773764655144801, 0.06514002207752552, -0.12086959636703261, -0.047353993746880825, -0.41042812796598871, -0.12076276007384264, 0.26613106120965568, 0.082705118464188543, -0.013226960135097447, 0.085840917162006466, 0.23475900681372242, -0.31428093638839982, 0.23204387403526236, -0.023753783278137902, 0.15049011261406389, -0.062573752898985716, -0.063876163705823163, 0.12183741894054224, 0.015864924589374448, -0.20571394074639635, -0.026377243936422025, -0.27820665418314244, 0.047907733398496258, -0.11711280555367369, 0.051652255368520687, 0.082610340457881959, -0.095201566476571076, -0.15512675800501152, 0.02772988936534012, 0.067037093629809474, -0.20645305416195298, 0.11222286907588901, -0.016095620052760159, -0.18443692921317342, 0.14475481156691705, 0.02136283624118562, -0.2054515722235723, -0.091039016278082696, 0.14578572469079518, -0.1340440972884149, 0.0025094014966071912, -0.067309873100177414, 0.085064761261201979, -0.044254461419008094, -0.13061212304821482, 0.038242182569621211, -0.061495145422716752, 0.042829874839055052, 0.12582073826138795, -0.041012590413751215],
                             [-0.17769645775218018, 0.10770590147598712, 0.053271082529856559, -0.0075930002116625607, 0.1301279998411965, -0.074004856586356499, 0.026969553490667549, 0.18023903623768925, -0.023176601683998953, 0.26271530187919162, 0.30772569054757309, 0.070453666485812735, -0.11622544453260271, 0.22348604287273485, 0.097726514456710017, -0.018240294513452847, 0.036079076664595783, -0.13819939234171233, 0.16141831836486339, -0.027365299735274844, -0.10657919859315364, -0.1509788726159238, 0.057913569206040308, 0.11062889167265415, -0.11492757202161372, -0.016475275236163992, -0.18976268785896627, -0.0033518564067830858, 0.27176747836232307, -0.11882035608149931, 0.098647066075342738, -0.12315610839240831, -0.02450404944490997, 0.091587798090830272, -0.029509927892593567, -0.19914318959395941, -0.33028894416739069, 0.2241424222231467, -0.13299822566679795, 0.14891374260928905, 0.021566192318674883, -0.023834035557545041, -0.11042787895547697, -0.17414333042196195, 0.15794325885133154, 0.046411973763341718, 0.028021407999047728, 0.25426012795281572, 0.092417370726122189, -0.055536111360975637],
                             [0.066050096844790601, -0.19240975079882094, -0.2244593354008228, 0.12747048049894039, -0.031947945221004866, -0.1017879046155758, 0.051581441612062739, 0.23435607353097809, -0.16604693694405565, -0.091040363801160346, 0.2652608544054213, 0.065071758380640915, -0.17921715540981853, -0.1171898131340663, -0.020584015225800705, 0.17094045449205267, -0.11692434915152672, 0.026415063584717968, 0.071189404098409431, -0.080544149871313406, -0.00037132009936424585, 0.21297239452717268, 0.097949592375991934, -0.11881095197658918, 0.091518113033070142, 0.14693232498532396, 0.067066328041015408, -0.016974141731691428, 0.14319680402112875, -0.17126838752956561, -0.15547203838239321, -0.16176965354221337, 0.077150403998050635, 0.097612989630615848, 0.10461849986463648, -0.23256467970653114, 0.27493719441796016, 0.15822959203603812, 0.26063889624164982, -0.11217006445036853, -0.03263088426793527, 0.24413895035207639, 0.029278941371167537, -0.02849408775594733, 0.14815158691879257, -0.15636662641358998, -0.16726856685100464, -0.016727049201546246, -0.0912890510323488, -0.012699361500570567],
                             [0.38884152660801108, 0.35830225994862153, 0.11178306126735256, 0.069180810898387748, 0.12837011691619205, 0.17806013517965166, 0.23550788167706729, -0.023262648774395562, 0.038762833583689288, 0.10180997463576325, 0.014716350548732885, 0.054614230866952038, 0.16901449346048142, -0.16046105091453561, -0.13171886527419244, 0.078274019074807549, 0.025878893988826864, -0.18441224147389948, -0.022031245369057404, 0.14733202969808248, -0.13377465056878468, -0.20109747539467684, 0.10114398777459531, 0.086336490170990057, 0.10956354305090005, -0.033491914512866677, 0.17293209519873282, -0.050981569771359751, -0.0043166466705145149, -0.082523976166862648, 0.062245032265005766, 0.026793900156761613, 0.14581620383474775, 0.060975980432767196, -0.085828342586266204, -0.13232585646075201, 0.12250126310411927, 0.022308213503791179, 0.076482906258431432, -0.081180955433121482, -0.13532766796026952, -0.13892905535047759, -0.17961264900719581, -0.29276660207095928, -0.04836831876222894, -0.12812160145314713, -0.1055610516595072, -0.054254282299971153, -0.15040851916949419, -0.16522401736733744],
                             [-0.0013582986503168576, -0.21210992160327166, 0.15850199586265518, -0.02439731420865246, 0.0042872839959504985, 0.021859267487243945, 0.065834147679446384, 0.17982453502886475, 0.0088341538664444465, 0.081254194216314177, -0.12995540766082106, 0.18778271346908393, 0.053130738834972581, 0.021326967251399244, 0.099422348713876951, -0.087453187509873118, -0.086548016863758015, 0.098559423096167637, -0.21448801003738682, 0.16118998797616649, 0.16713065016829254, -0.051071478099089671, 0.30567993358618339, -0.087947330772037383, 0.073801857754295749, 0.1509401036905362, 0.21046233909589848, 0.1203906534578366, -0.076994051979560843, -0.13002293841854409, 0.053758292146109964, 0.29314539615568247, -0.047473781485938796, -0.06737615384619236, 0.071626802793265248, 0.084878384995543524, -0.11110585286191944, 0.34048245069452626, -0.056552199246032268, -0.057975558844094555, 0.10548727556326792, -0.023885972890889604, 0.25274846353709646, -0.11004680827368786, 0.0017893522467543328, 0.20823726465052875, -0.16209535854957677, 0.18575958882404478, -0.19415100075688377, -0.096975412268993935],
                             [-0.065182789272582337, -0.10810746777869727, 0.049490763044680738, 0.0049352790065016723, 0.12669885211064308, 0.26361806883388078, -0.17224687029771885, 0.04023477057468005, 0.062761403180690345, 0.017164991781626171, 0.087259148672481648, -0.045193127768887661, -0.30652055467541817, -0.24878046824458333, 0.076868221351186455, 0.03770608709181171, -0.0048850883542160941, 0.060924472748753448, -0.11521251941761408, -0.095253909321382724, -0.089348963119175576, -0.14594252591028978, 0.069062621631350504, -0.30246247866177745, 0.059505544045260088, 0.29649925029181196, -0.0040000385144338731, -0.16044482834121346, 0.0074083891852725382, 0.07832989516065908, 0.14666205420334219, 0.10254070321166148, -0.026421500797785193, -0.087278015999563266, 0.16125395039674714, 0.14839265220809775, -0.092420645047703753, 0.014300966190176899, -0.019538949949939478, 0.15579863886619491, -0.18060107918612042, -0.17512345722810368, -0.20845050142237126, -0.020358480771258462, -0.10653754271975395, -0.37102728284722314, 0.062338931515016981, 0.0817159985823466, -0.021240311870718308, 0.1540335303718573],
                             [-0.16669143751966833, -0.0013213510101491269, 0.080166709275729595, 0.082259306959546599, -0.11720415284008409, 0.044172671495777714, -0.11136388363658652, -0.35435647246145757, 0.13534782341801005, -0.11165898293941316, 0.10267604030000929, 0.16529023663671719, 0.025900920891953387, 0.19923175942983792, 0.053620519774253056, -0.13442763941337135, 0.14412475286872978, 0.14328361226125261, 0.27102971885690719, -0.023547497721543027, 0.014718118183843849, 0.027580542016163275, 0.13183207426576593, -0.028674770105282264, 0.17934637883797747, 0.12212400025198158, -0.061131605451777551, 0.057342461995169777, 0.19686802618397375, 0.035184245871213077, 0.10938280446459522, 0.034676627584061287, 0.31459623046016122, -0.014502297810643111, 0.12113703372599027, -0.15709552528128287, 0.26274626146581265, -0.019056825434968432, 0.14941676080931121, -0.048044269178907077, -0.018081163307898673, -0.22832446815727608, 0.14283312757183597, -0.21402196013827227, -0.20451817588475871, 0.11523342626509338, 0.094284310878560706, 0.090719216051080562, -0.012923459957025644, 0.10007712126066139],
                             [0.015251126573874216, 0.2928881757225032, -0.084565221689285236, -0.17027571296266658, -0.091897943282118283, 0.18595022789954005, 0.033732058782112113, 0.042474890908479938, -0.020167027090492604, -0.11101825621635728, -0.21880146829251093, 0.20144821107078045, 0.23228450182540925, 0.19958219590743206, 0.29999327679317039, -0.041128806520168995, -0.039152214732904221, 0.11617808955566943, -0.11150447185818561, -0.24307847403594743, 0.11347946466730464, 0.28403699506207597, -0.068514755660853771, -0.11137477744890109, -0.080768680348311583, -0.040592437500680208, -0.10271169804675891, -0.11827427238888859, -0.092511272948667109, -0.13351477180470586, 0.053088953094924993, 0.058618219645371096, 0.2115457784695797, 0.15524918615308728, -0.053759733212375482, -0.10124820568978864, -0.16721593853930214, 0.072748709042432344, 0.073934101701308305, 0.10265509792170575, -0.12710235583559917, -0.0072849844062494711, 0.042634582040998258, 0.028378295306656236, 0.12672533568179523, -0.29457854378221127, -0.13421238804259972, 0.060871327609742946, -0.016576874721629328, 0.088002078321883975],
                             [0.081299716524687274, 0.12084505650478679, -0.085988711259238904, -0.17712236680342996, 0.065038256044885973, 0.062561421720069274, 0.19819140207286889, -0.013412914333163847, -0.021975236005758375, -0.13317838745322541, -0.021418180026794405, 0.049583718533004237, -0.12849876287054759, -0.38002757714936153, 0.12814028042234951, -0.096793891401903462, 0.10073068273444656, 0.03228040461978457, 0.19077772171805743, -0.089272071868598452, 0.073570100839343622, 0.023021361480906822, 0.1588019229192921, -0.00011802570824926647, -0.12526035859374024, -0.065343966351903815, -0.27035672490718138, 0.27652045009846893, 0.035152303056859943, 0.056273885290479123, -0.15462932776496913, 0.24488291794671851, -0.062163507171631938, 0.1124674577902629, -0.064104326312999241, 0.005053295396858711, 0.047390398182333336, -0.032491584160538989, -0.0091469313147423525, -0.11620623862065556, 0.31881081002032746, 0.0057535587845546779, -0.22412705397215257, -0.026097663557983115, 0.070775935813397847, 0.074453806643079656, 0.11287453911222801, 0.16588942252492195, -0.20218120719480442, 0.24131342364780781],
                             [0.27918110593259204, -0.012431761688113141, -0.13016977944762445, 0.14331367150939084, -0.21194716833908961, -0.047266163665308739, -0.053418748920572239, -0.066061441908783949, -0.16499239471553931, -0.092977848487891895, 0.17304670971127517, 0.10659140626244186, 0.034891703123215823, 0.075104908885374966, -0.087000213615024344, -0.03485738742802514, 0.29206119772686745, -0.10900899483086586, -0.087508121615044981, -0.018816854186090397, -0.15405970356148668, 0.13833955291745123, -0.0037197340909954882, -0.016956739636202943, -0.080941771223551839, 0.13677571624795534, -0.13055148048233958, 0.30990149698578684, -0.11968488629120889, 0.21077461422538024, 0.13192100122752229, 0.09709826810176396, 0.092815370625095983, -0.18569353018210932, 0.08199847386306898, 0.070933615315733695, 0.046498160294323312, 0.19314461927987117, -0.16655894245206115, 0.23539823359967957, 0.11532154693969815, -0.1168340648619567, -0.13880936253688522, 0.098206018619742097, 0.09098765532871661, -0.032806354212228946, -0.28389422830317085, -0.028992508917074659, 0.14894220035741249, -0.13648729165651644],
                             [0.098782597356464857, -0.16413154437347399, -0.035702875022874336, 0.11142951650120468, 0.050713855216958384, -0.17138957604911936, -0.065645730294882285, 0.16617996448891859, -0.23259575465784302, 0.094474191754382944, -0.10573917545749149, 0.17902099154759063, 0.25945375189236447, -0.0075139954225681271, -0.073281495888216058, 0.057573374005274416, 0.24096177064528868, -0.0081382544333713554, 0.12235371241258275, -0.13604287397715162, -0.16851396666171836, -0.14225613384597499, -0.0648232947792724, -0.27582681561112726, 0.040493799356850366, -0.084213218433663015, 0.066290486317753403, 0.0051256417715295237, 0.086551902716045681, -0.048271872283281884, -0.059290514066185754, 0.098933353993959583, 0.27192458623499505, 0.030967299396013295, -0.078524851974233825, 0.12133060828126276, -0.11803260843408084, 0.16366453741582287, -0.042079525596367427, -0.086550618706827426, -0.088863899129594776, -0.030795565186603254, -0.0033383948863847908, 0.1047366505522162, 0.063710852602961707, 0.021974250136156965, 0.46904342835538287, -0.17471833010325849, -0.11804035241074635, 0.10967513473824951],
                             [-0.1549446178178015, 0.32285289514545651, -0.11244985124457929, 0.21944514844263727, -0.09907984756387149, -0.028342841608595751, -0.17068292007739086, -0.18049493257345858, -0.13181468485527945, 0.27153617593001683, 0.10726190988577287, -0.24485574582793904, 0.00069924306052740871, -0.10254084608782556, -0.072019876493740684, -0.037003669154104982, 0.048543046277272135, 0.095496820501785665, -0.073955096926595756, 0.11769251351711658, 0.024114874536364222, 0.11882685793793596, -0.18030909704922757, -0.22389877032995931, 0.043261840209263866, 0.076518433537719338, -0.087330076857633124, -0.096872090216592571, -0.070411358026228305, -0.36037109823901264, 0.017354321677674728, 0.13887697565134063, 0.068441494794874505, 0.058772828116374069, -0.085860860114600507, 0.13487604760596464, 0.11624818005070185, 0.0087452705511449364, -0.16644425419029471, 0.080883626325786329, 0.23327063734032977, 0.18535956591793842, 0.052289111224843483, -0.084091284988998538, -0.062368511477323849, 0.0032106648738908163, 0.043130068333561311, 0.11520320580240666, -0.19616481043614523, -0.1186069307991483],
                             [-0.2318372028620227, 0.094431334266169814, 0.16844270630026464, -0.18180444418727315, -0.067545608505832244, 0.16245185552816327, -0.083935505108041097, 0.00062952026330960931, -0.33581998801170254, -0.097782359336164679, 0.14602015944649119, -0.15134542063794271, 0.17954466341249919, -0.027622210347332945, -0.18257613937223477, -0.22065048655520272, -0.10034503272584856, -0.041321603409963104, -0.35369272367620841, 0.013295057093535383, -0.017350541224837774, 0.0019582511876195491, 0.15281388229453546, 0.13165784353221971, -0.0049690102708694469, 0.032411328744077268, 0.018890972404383324, 0.2267882448108165, 0.31584361023590796, -0.010867013999345025, -0.11962557269097328, 0.10989870009727462, 0.059969750576809033, -0.068533892988460007, -0.13811268546269528, -0.089862430529798615, 0.1087685898257274, 0.060558443959636367, -0.0021526359559385783, -0.023691449550439152, -0.26129714166774237, 0.1216052494446066, -0.10629979561271612, 0.17818018588461781, -0.074231372745662119, -0.029047631727712107, 0.088658793338057665, 0.027062590982739214, 0.053449451777379635, 0.061091850227280094],
                             [0.083307691198404019, 0.13434794249844065, -0.083135608952532622, -0.11660468314407996, 0.084102928248636119, 0.046557148083560075, 0.016269717759351536, -0.016113364614939316, 0.085799221920321828, -0.0080762227341551231, -0.079101705193827893, 0.16812445779520893, -0.077292715159192657, 0.10815097957863366, 0.03411646561984763, 0.021607758241705327, 0.037927414395618357, 0.21236183979376838, -0.072123854164842391, -0.13759313804070603, -0.13244568267277765, -0.093246886694863945, -0.13880157350930025, 0.095212235325861538, -0.050046523099446905, 0.29225013682715517, -0.081946060417751668, 0.060134149007053418, -0.0029995403674372319, 0.11365519116775082, -0.26093486925285769, -0.22929470493488102, -0.031954309861059349, -0.035236604162343088, 0.032028345614354289, 0.034210449206409997, -0.038973018625946793, 0.16231689242067113, 0.059655721086190494, 0.21615647307324476, -0.10665730744980083, 0.27292849977843975, -0.097178996703673443, 0.010830741173667105, -0.37016933592721563, 0.2429724303211058, 0.05779591223570673, -0.064747648253931783, -0.33660612513000415, -0.17742966378421363],
                             [-0.26628108147910695, -0.098300509058877106, -0.06236495558019748, 0.21250245813004295, 0.0078404065899564841, 0.093213807192458864, 0.059691302899885536, -0.11416177967355212, -0.014427885725434183, -0.16082178772637742, -0.20489128771627108, -0.0017953044062512366, 0.18513794339984421, -0.1782319756758825, 0.0098435363686372648, -0.058629761690885331, 0.27807310375357724, 0.02314456909310501, -0.24709547851575811, -0.04855366206154503, -0.18468506651885952, 0.073977064642580526, -0.03287604629633091, -0.091724372889608816, -0.062693309928012864, -0.080324773182425341, -0.15680359828226728, -0.067744677958372523, 0.20197588030754682, -0.072970542591687726, 0.063188114708207552, -0.07880573432042931, -0.3742159815612866, -0.081544542231072492, 0.13943494780237153, -0.14242735164801276, -0.11732418130302429, 0.028763427328836553, 0.18675956988398404, -0.062547830074090718, 0.012318309182124653, -0.07367294074547584, -0.054794878202218109, -0.27095314005289561, 0.15848125935399812, 0.092013779121262046, -0.042547635519248429, -0.18203650576926161, -0.085375484189735146, -0.15349261225927643],
                             [0.021217764305769458, -0.20467102626127573, -0.071103991392146237, -0.12706423723260626, 0.12852897897890919, 0.27962916669153981, 0.043895607145234862, -0.18022397981154975, -0.31546788548316318, 0.24755601205246194, -0.16117473572418889, -0.16351804149717405, -0.0032021752353398967, 0.12486352460209921, 0.1816445263483257, 0.30236165323887498, 0.05115555678545064, -0.040643298810752307, 0.065033945596985526, -0.083934344997257535, -0.22056754283630886, 0.012692995361077588, 0.28985590505829767, 0.18658224903787951, -0.079805916749590838, 0.0040525439227956477, -0.17162363561859753, -0.14625993233879578, -0.18276758238975621, -0.12697898536288585, 0.01015135720916709, 0.079569662077649109, 0.0055678992770446592, -0.11209530051389731, -0.061276813211878466, 0.027030400961834507, 0.21143511948371888, 0.065691275786313758, 0.18098709814239244, 0.057123999910146266, 0.060476121478939687, 0.010845151317729671, 0.052298183924867493, 0.049678461767654856, -0.030494403070227556, 0.06903812988887266, 0.089045077141783016, 0.049204467915532568, 0.15301665735595793, -0.082844895698822668],
                             [-0.11142009584009761, -0.14043156890002614, -0.2163531568893671, 0.021753757479275302, -0.2803396928348863, 0.50764895224225204, 0.06559884974496577, 0.1822496868648501, 0.015475016972986077, 0.071859005137556872, 0.02451101106712681, -0.079617521040535502, 0.10197578740327871, -0.04719679800015035, -0.071377830899310948, 0.0062264274904821953, 0.15506503525797, -0.16543053590308288, 0.026459262106193225, 0.099997076916385569, 0.05267332079816156, -0.015449589879570817, -0.21608237920447046, 0.21253806162788344, 0.022263521892590645, 0.087396963307118589, 0.027989900185565388, -0.061327809583707205, -0.039484456668282097, 0.069555085214679346, 0.022833770093208843, -0.24716262343022818, 0.065144301018972797, 0.23067177513665474, 0.10813107302277966, 0.050009167310470781, 0.011192609652081355, 0.14106260715746433, -0.15593168214469094, -0.19623131596068449, 0.031524185814728975, -0.16426486296474196, 0.060162400559983689, 0.11953868110411987, -0.031124316954260062, 0.081054889946947373, 0.0010409191265556171, 0.1396772616346808, -0.17315867132147586, 0.14689246887670429],
                             [-0.11551804438272514, 0.06354838366639598, 0.083968609112475889, 0.04377371547238311, -0.073462073759132065, 0.20088621028752396, -0.15952615410321269, 0.27258438442077798, -0.040033566885913106, 0.086025960104675323, -0.12796304812650416, -0.14255051567694496, -0.15508934612228545, 0.13949868018580044, 0.045598216351581067, -0.25547120968308551, 0.13917543610803315, 0.068542606800159112, 0.11472916817214615, -0.014162675482575854, 0.099186327118439527, -0.14675588899978392, 0.057229981118323676, -0.14002015835873377, 0.14668008783166078, -0.35221878115620053, 0.16370085624763409, 0.049399916193847454, -0.10530370880059867, 0.041604431676305398, -0.13772999581772469, -0.016906475700429021, 0.060564347523643369, 0.072410495798796548, 0.075982949960174878, -0.055465043150824622, 0.073433891918295635, 0.15897633657852606, 0.22808084668412235, 0.14242611100672092, 0.24114712866730414, 0.054386548794028572, -0.28457789635732877, -0.020293668824503491, -0.11712611993057098, 0.015034443733128349, -0.13515671347396196, -0.23566001430060465, 0.14126803826221279, -0.045543696556963942],
                             [0.14722949576001051, 0.02231110836737742, -0.27839368227948774, 0.1642680201912422, 0.085046083899460445, 0.1113699275640196, -0.12501718799341976, 0.15285512778914395, 0.1135635201100151, -0.088419206544051346, -0.095261938212528777, -0.1896884781861374, 0.10311371160195962, 0.20184024161976022, 0.16733665007979484, 0.21662691289346175, -0.13699531000343196, 0.27446598725153665, -0.10498274404250842, 0.032133921247878054, -0.1483312545597284, -0.12855988551104086, 0.0038015415784784404, -0.137457668725357, -0.064357372159039319, 0.023101330801486315, 0.19017532212167038, 0.20544271792593186, 0.2952518863448661, 0.059210917472547822, 0.24706967118439499, 0.07245584013278869, -0.05505220435155346, 0.10043500919204353, -0.1372710166434562, -0.18988228838329821, 0.084485204172675299, -0.1973573842772213, -0.063052382364157805, -0.029294181685883321, 0.14847883725721853, -0.052411583193822039, -0.11032783532024948, 0.15462411514895028, -0.016254967520786444, 0.12729125853973516, 0.01538617332354577, 0.1450732483232306, 0.0073260815941035015, -0.037510916702853607],
                             [-0.13053010824827757, 0.14425871891525621, -0.15858546625139644, -0.0049313910325133143, 0.15387860640965648, -0.17969821439303851, -0.21154856639153613, -0.21711577196706255, 0.14989566012942249, 0.22721932817637011, 0.022467154257389134, 0.18362149411442094, 0.096539231786078289, -0.068928269796000335, -0.022211327775208657, 0.021427920460724646, 0.0073031322647322799, -0.11061242383413891, -0.19227722500384412, -0.035016903022767637, -0.06187655581276312, 0.0043510865772082219, 0.14391974434414143, 0.10951631957063315, -0.031396538606174876, 0.0068652251347852775, 0.14330699957352924, -0.11749997238050978, 0.052932491603886099, 0.12771632251722778, -0.22917954704924412, 0.077818500694940437, 0.055676532020669627, 0.20016869413901475, 0.29749754533596201, 0.00049388446791786861, -0.068114474885922885, 0.052178243956902508, 0.18666187876941062, -0.18685407396557566, 0.20517931805150541, -0.15212750955915177, -0.097318889794135555, 0.37253410812216753, 0.014418303174619229, -0.084232567784823284, -0.044338703173803312, 0.1062582134991229, 0.030533681266538333, -0.14794469509154237],
                             [-0.010695379866666166, 0.10425873020560279, -0.06166141563691592, -0.02073990584921781, 0.1613262132930777, -0.20259498959830438, -0.069828096527230932, 0.11626303330372639, -0.1392019841629745, -0.017288531373230217, -0.072643798876338844, 0.022044625141012048, 0.055383216895620695, 0.17279706705443257, -0.027152212761551157, 0.061538103314928122, 0.16569916679592009, -0.1280060943044998, -0.13421364071771041, 0.21533180019560577, 0.038614318256070687, -0.061748713381326752, -0.13833594582384179, -0.061627549187038638, -0.15935518156298911, 0.15681261530246696, 0.01042000303964798, -0.02179961132280956, -0.023918816531550133, -0.12948204965945967, -0.054623456498911607, -0.13355872434055774, -0.014397325104361647, -0.20479887477091627, -0.093920019892656761, 0.13944539541428683, 0.027474434808331751, -0.032555622327627327, 0.31538564761598703, -0.11939286176643867, 0.065837838783554425, -0.11320772014178922, -0.11135826631761686, -0.11650794576313404, -0.16114513899705152, 0.074688074963539755, -0.23050872082578469, 0.16921115171625778, 0.056593515589746408, 0.51540926589862013]],
                            [[0.09755051154232787, -0.15314946667849313, 0.16554232376796088, -0.13572420615347092, 0.021473759425581072, -0.020392097746173281, 0.15339627248307333, -0.31128561828962498, 0.1375819538153821, 0.056552640615966016, 0.059203906231323808, -0.047235968766841163, 0.0031493614915745981, 0.16100213013944492, 0.069683097221515736, -0.13988319814812267, 0.13640388821882382, 0.087087594731914325, 0.048335629111297532, 0.008208956294216958, -0.17081517769983565, -0.096410952651442144, -0.21776047392049114, -0.13451213359888928, 0.21463388453829557, 0.010888964698258643, 0.15083386280518815, 0.13265470868456689, 0.069158687749681577, -0.031483030961823665, 0.08647951076959752, -0.14405185667255443, 0.048075215487036548, -0.075782852683259988, -0.44852896172512047, -0.20065355828579493, 0.024719886299276544, -0.010123596526839555, 0.12677189309131978, -0.086211285932280182, 0.028849871221131744, 0.16056804907325695, -0.20164370321499842, 0.1384316810201949, 0.2054589467923543, -0.030766639401277229, -0.1147085694791036, -0.22178791664082678, 0.051960787307059796, 0.014296610645804418],
                             [-0.012988530864170417, 0.092085309968430396, 0.17612541582162852, -0.25055242126600813, -0.066768589088798874, 0.0080046816297668216, -0.036753467117052296, -0.07921521726684988, -4.422230484668112e-05, -0.056298810844538673, -0.18924963090949184, 0.27561912083012141, -0.053997199615280989, -0.24215474292894609, 0.019594243236926111, 0.124777730361312, -0.20901218938300614, -0.11385910975302622, 0.13940356609528148, 0.0039305018373629753, -0.28031759206896667, 0.02328031726724436, 0.12725810094114914, -0.17944953148715409, 0.22046505261438179, -0.02294031493136104, -0.14734295297765024, -0.25489693859651424, 0.23329053422944149, 0.18746589052521462, 0.032336807551222056, -0.019305096956540726, -0.18555122362540566, 0.17922157982435488, 0.15874130985465928, -0.035302992504009749, 0.13312851473900009, 0.0955833943945434, 0.069943839512671746, -0.12812986160299075, 0.017752785353364935, 0.048046823169066749, -0.081434805123764095, 0.12031714112510311, 0.13369731252640535, 0.08567032508479186, -0.036481521144172656, -0.028319199920518026, -0.25314287821603626, 0.078798200165615659],
                             [-0.091767359836087373, 0.072829498453051714, -0.15008946852353794, 0.063079942616259113, -0.12704317345978963, 0.14220752610084439, 0.12555447506458631, 0.064179222258504795, 0.13485109245466337, 0.022555752204782002, -0.38775471291879138, -0.19394313447305422, -0.064893735451179713, -0.0014716531153469634, -0.16710879915948335, 0.039457781190393212, 0.10365121858340903, 0.086171709006777383, 0.030121294690075389, 0.030485314023850518, 0.083080879111771075, 0.02458182982945839, 0.2052556893005652, -0.060063817017732793, 0.16130599025060161, -0.030850559933858671, -0.080989075123993046, -0.13572971294821021, -0.25753218682989903, -0.031186457909589203, -0.1580294007384839, 0.058304708630111508, -0.14528708029046189, -0.21820718549913129, -0.057094923653915192, 0.078133510251238353, -0.045000935194391189, -0.16368217200507751, 0.091793997171321945, -0.055597642904103739, 0.16582381126989831, 0.15500306561998073, 0.086825488063399986, 0.080126493619653502, 0.15885829915032232, -0.12388597040287506, 0.28655891797955002, -0.3533668588879168, -0.096834503095587929, -0.038024742782807333],
                             [0.022096929590998595, -0.002289407422334517, -0.10597519790085061, -0.16373124241242917, 0.061357370384241341, 0.16457612704674573, -0.091317510090428086, -0.089966632919189729, 0.14847460075457869, -0.104736587077758, -0.19063752864474751, 0.0083198588896407667, 0.043145043981006423, 0.33878590730130992, -0.03382653479616967, -0.081560575220728945, 0.083244291808643692, -0.039705712104648891, 0.28148377184627987, -0.066217347585112038, 0.046251705508431273, -0.19934378979161205, -0.36007288835536821, 0.11433562695908987, -0.03828820660025669, 0.092632515768697923, -0.025805746276009515, -0.12663951694031456, -0.12714213573512842, 0.16096272147582918, -0.060279524225368052, 0.23178197284560423, -0.016162700548569477, 0.10187811177829519, 0.25388354676041952, -0.07671169294441578, -0.2339997527113086, 0.22195799924803336, -0.21768884401356139, 0.12732184894513612, 0.14621197865408403, -0.010209318657287423, 0.027745239414735098, 0.089554208508510216, 0.085887777986513106, 0.00016911712446086209, -0.1536216525075588, -0.03397595391053828, -0.0073531667263001827, 0.07973998781341847],
                             [-0.032232702611489077, -0.05807430032644155, 0.18869405666248032, -0.25824355599281018, 0.023695495210224238, -0.11630634909453025, 0.030720570824036973, 0.057630306254178407, 0.020825781488575289, 0.096231323075580619, -0.016004921985750577, 0.079809474250401385, -0.094863265385241841, 0.06124410660640052, -0.24214151385920368, 0.054932341943420782, 0.1321461435581944, -0.069826165038901364, -0.085311724923263416, -0.11130038849550104, -0.009450503231261443, -0.064762067496461448, 0.1951393980731039, 0.18005684875265959, -0.22918677315046893, -0.067161178280368133, -0.11812853583216462, 0.035897456975925689, -0.11607642695212284, -0.11768353556007709, -0.23669593539652339, 0.070742534565125373, -0.11021890678244643, 0.19757881243120898, -0.10729655205365746, -0.53703088819531697, -0.13884525535896108, -0.10249455485101365, -0.045871140325789476, 0.058679397697533636, -0.21084217864523969, -0.018892627125814528, -0.13761109674297239, -0.069529678027413416, -0.098002109848862859, -0.024351005043883572, 0.086626090836579947, -0.033294664452814635, -0.17568963641336169, -0.045926151591772421],
                             [-0.061017850329168503, 0.13582977080237688, 0.18435890691224177, 0.24715679762175927, 0.12149375986432562, 0.072301326012064987, 0.17282697781510123, -0.28810726691266531, 0.059370881909999451, -0.18522856752562697, -0.16800250171049136, -0.068121527520601258, -0.072259224998200464, 0.087968538705918517, -0.015760658141528362, 0.016896398712962599, 0.034559316341861455, -0.14709946305696123, -0.12761213033655611, -0.014283425614168385, -0.088333507747689083, 0.045878106511198079, 0.089701689627830164, 0.34591830689307757, -0.22459037110333752, 0.06402917372493061, -0.12412768115689125, -0.33179535330079646, 0.18756256454354475, 0.26059561358541983, -0.09580823273310074, -0.10649429286122591, 0.049535984475115348, -0.026451975161559473, -0.2775175932132764, 0.072796611822011373, 0.095802050691159935, -0.01507043206769783, 0.033405879477004741, 0.12601296713856011, 0.064965306488052835, -0.024796656941646567, 0.03435502712861551, -0.058790845274814388, -0.089522959263355156, -0.10462848923491061, -0.062242267321564786, 0.063002980847840617, 0.11674508509343913, 0.15276962410140579],
                             [-0.078781060976460648, -0.019760286665112713, 0.11937138944436271, -0.10434608472291901, -0.10978922986010942, 0.094903546232346161, 0.1513133226413115, 0.1322481232576467, -0.080213763761998735, 0.2622321330216022, 0.020625921726379701, 0.19301002965666994, -0.068541251311608611, 0.16336112140932879, 0.0041880654087739768, 0.17986608761055869, -0.10827810140227304, 0.13742014600521416, -0.21437829709229148, 0.062741933107584705, -0.00096197057013696881, -0.16399010257232821, -0.035640538653398814, -0.0059450141732873673, 0.18210685927808326, -0.045729126982951042, -0.14009294857432952, -0.084468080319137315, -0.00013672727269040889, 0.36632810005789418, 0.16640535102352358, -0.1383228036271146, 0.06145159553321939, -0.24948505782167746, 0.13439419317200821, -0.0595265144403994, -0.09427999812222522, -0.099270773279035912, -0.24925319954960695, 0.026456186219560321, -0.14669836351547794, -0.1070649959279215, -0.048164960384313144, -0.0015999924183113235, -0.14945239507418367, -0.12489600400227593, -0.011472931193493905, -0.17967843271618986, 0.30379885968090609, -0.10632338266735783],
                             [-0.054680591297701329, -0.15220056191183948, -0.21225769597184158, 0.25985490591403571, -0.18393489447767486, -0.1101939980577145, 0.0019227596838266973, 0.053123427981830701, -0.087106482428949597, 0.003760334923562138, -0.02847921107079833, 0.19985816630105077, -0.087945944576791307, -0.023924763903399853, 0.12627743760688828, 0.097747642178553779, 0.075169809534330473, 0.31381123028942276, 0.044195496273985627, 0.093880615024766245, -0.015474846697841702, 0.0026461070816941787, -0.06234452959880963, 0.10164674219982349, -0.22487132729336481, 0.22041072413490218, -0.1206546429864684, -0.03250123707786922, -0.0021050949496731015, 0.053029714140964274, 0.19784668037074946, 0.31388704040819282, -0.13294779566798995, -0.087742989130739232, -0.14377440075041931, -0.013923977517947069, 0.086515204330218518, -0.047538655566264056, -0.053632302200815836, -0.079160028153607079, -0.047826788451444134, 0.047595768211736084, -0.35250137393549341, 0.22826779618431614, -0.041338082484616255, -0.14521176370265512, -0.076374388506775831, 0.067444014105337236, -0.23985725838295618, 0.094577452905390783],
                             [0.073733930127110936, -0.24053967207484336, 0.04826560609716278, 0.078611788030299834, -0.036706210116157226, 0.060574136963205197, 0.18480299308179277, -0.15787328442044762, -0.010023613745834204, -0.090440218995866434, -0.13243884637335693, 0.13734694696682101, 0.19237069607882221, -0.019753623269113747, 0.074428274643538683, -0.077333666487101854, -0.041372537669762129, 0.18001128068219471, -0.035395372097350518, -0.10009968114115096, 0.059007902834200689, 0.21214867872556356, -0.18748245248099868, -0.05758533691862195, 0.12652233579520056, -0.036896697859201515, -0.24243359501775066, -0.10184876132470559, -0.091703969732984808, -0.17167270622614411, -0.3238408228870821, -0.081345950938570541, 0.30563182839614922, -0.091581880400669752, 0.11512297755640781, -0.070141780699782302, 0.0739527140058618, 0.17960626095987811, 0.048690096247852414, -0.059180542937491462, -0.089663069137959142, -0.1989390841300063, -0.10188743439143422, 0.13951526564272465, -0.26258123443853681, 0.16233514665264848, 0.24226838880176499, 0.0305633179668977, -0.048011941505712044, 0.06325944759682571],
                             [0.074003839240866301, 0.22169856848207589, -0.052062766018571627, 0.095008160236341385, -0.10676633573388576, -0.034539467599118905, -0.17772517790859679, -0.17019127841253395, -0.12761170266639085, 0.024783212500598579, 0.26078555337964204, 0.078353485992410099, -0.067052696183011032, 0.079597982854577184, -0.089937922995591654, -0.095689990141928111, -0.15200755920621256, -0.14650068496804081, 0.10693990319415246, -0.15996069297559101, 0.080496815901200711, -0.24185938566697157, 0.10109099776654271, -0.31344050588376726, 0.056460847322063738, 0.29339491936391005, -0.20886745349831834, -0.13646568411148235, 0.0057329142644228122, -0.057454565712910084, -0.27161419189768726, 0.13796126002014394, 0.10984969551673919, -0.20862001577320963, -0.089170313242399352, -0.063704244186242223, -0.021618130470351066, -0.048720745555182222, 0.0085170122516251747, 0.0087807714318519255, -0.17082259001879435, 0.07574056487069783, 0.0035357493684268983, 0.048206783944855357, 0.1776844146721959, -0.16692280377806254, 0.10195657538151288, 0.18801927257623069, 0.15764136038116361, 0.028325047231454216],
                             [0.10936822061483885, 0.0093124854344615576, -0.15594681655898429, -0.022886198079441016, -0.11865592231260341, 0.14344684589246864, 0.0040733820671175246, -0.038325884804757133, -0.094852880893768712, 0.10026186409682775, 0.20965613083471221, 0.092426968560475262, -0.037891413863196187, -0.084425496801579528, -0.35430013999250098, -0.048015697096758132, 0.18593663693196175, -0.10919680294564324, 0.16410647633703573, 0.23413959921157176, 0.13547482033436339, 0.22313840117145808, -0.052745787353218533, 0.13217086762322, 0.085876245699381307, -0.23099421692716809, 0.13902313283268677, -0.25468618550743916, -0.094343904879422, 0.093952517080136133, -0.0046442709286989943, -0.029373961551002487, -0.071118069008276774, 0.049298404103974749, 0.011810925045806954, 0.063859341003413089, -0.16224334894850448, 0.049537737221750457, 0.2948735920926302, -0.1140602257962354, -0.24460798246426696, 0.087074475317225092, -0.14396123773053743, 0.11035503646913612, -0.092768762309293262, -0.0014680837716307034, -0.1069916065367669, 0.043150986053574869, 0.19277791807840919, 0.19747940909787226],
                             [-0.056231012709718947, -0.10800524653170293, 0.074332623624546526, 0.39579751193413071, 0.055034548533583152, -0.079797378641751057, -0.11995730239932288, -0.03229951342833693, -0.19466992911986605, -0.28033117370623156, 0.074924777935522907, 0.12205176311313887, -0.12037935508643682, 0.23181045899497812, -0.29166158069100712, 0.0032977858076351273, 0.26035729674063041, 0.078263634842527435, -0.13936409722338791, 0.12426731716155968, -0.0054901387558888692, 0.077033172999833477, 0.035363670077108098, -0.15597264278100917, 0.0725351015426864, -0.084388019030251352, -0.069324226417579501, 0.089545252775528245, 0.11242255806839258, 0.12438847509590102, 0.040595188164469075, -0.13730507119631075, -0.012174645874034537, 0.21620800664025916, 0.16958653882038549, -0.12067694945369835, 0.025229024971164575, 0.1314572119253353, -0.10320227992037354, 0.04864771624578839, 0.080461876340114799, 0.16053964422211003, 0.031622285693740065, 0.12348499995025583, 0.20509383011124058, 0.074383594697941965, 0.17712915723327938, -0.03097029644604438, 0.031522098161494948, -0.2077439795436655],
                             [-0.016846136501082562, 0.18209707172141987, -0.12538457207086939, -0.016777835914046257, 0.17377996059931172, 0.32064362215588449, 0.024816501164346309, -0.14246059004084363, -0.21622529562833448, -0.094931995222603233, -0.021250133572348791, -0.14100773554929452, 0.0022447705637830286, -0.081559023650145682, 0.14220513401629725, 0.011022404165735959, -0.0025340989928449536, 0.16514078230659932, -0.11716510370258995, -0.054081261229073314, 0.25636177940467847, -0.099007824870123176, -0.097241451004095605, 0.088367708452758265, 0.21873201180570367, -0.077573788612593855, -0.16075322102989245, 0.17488093003464292, 0.12880854757426, 0.014213953837381381, 0.1800072861396978, 0.022186888579119376, -0.16542353039009342, 0.10796690465529529, 0.023557770180061582, -0.28684723517713434, 0.0059885927697763365, -0.26996943890645836, 0.035389143869209029, 0.019813037747002955, -0.09293233376228939, 0.031284647191772555, 0.11073497113358109, 0.061547351511118321, 0.03431305706703798, 0.10246590575569699, 0.13540722823832771, 0.13132712904970384, -0.021257357061960608, 0.35642426819195061],
                             [0.022091447607579126, 0.10922360941142722, 0.11100534195616411, 0.056898361919851821, -0.17688180261178554, -0.21559030516327263, -0.12987700340538122, -0.16860257497208783, 0.25945067130903882, -0.12526612990684471, 0.02253223225775813, -0.2643276919390446, 0.11584399435256978, -0.10438670844442087, 0.067568795029427781, -0.025731452286975424, 0.11450276633856479, 0.0087511328689084088, -0.33661188349322868, -0.0063729213970045856, 0.065609721916794969, -0.19311802731221556, -0.17180803052149524, 0.071264531752327318, -0.030203161631709038, -0.015685317709648119, -0.14793928556423958, -0.12443548455118497, -0.08676089177946554, -0.027417123723639501, 0.10216539773027852, 0.10600717240676402, -0.1044532199166914, 0.069915162348524337, 0.30850822200487571, 0.014466821550792618, 0.12547250859243081, 0.049191302510185692, 0.16400713738007144, -0.25085876301290316, -0.25243121383724643, -0.011668091498897255, -0.16218739002871718, -0.1725033797961403, 0.10682806930504107, -0.021719077122711837, -0.027096901167597682, -0.15618646772806749, 0.11279935042069905, -0.077376029220798517],
                             [-0.18366998721421687, 0.051373956470790627, -0.13406306299601756, -0.14029189235589565, 0.060191519592594285, -0.013248176336659702, -0.038879060250352759, -0.15359520843500851, -0.0076589930476961927, 0.045637924038863652, -0.11275275905391816, 0.18787540464225078, 0.0088809268069769669, 0.146086527394343, 0.12737729897974831, 0.093459311148221827, 0.0053928648051102448, -0.025178919897987928, -0.060849857898818326, -0.14501708484380227, 0.029032879147671671, 0.14744937555582399, 0.10412571209174099, 0.32480665650909357, 0.032230575841165961, -0.025789767339169729, 0.037190612277350758, 0.026388851252307107, -0.12759175004595946, -0.12781513935635797, 0.18377536392541954, -0.1132938393028254, 0.099781469478906051, -0.15049179733755721, 0.013486961270715496, -0.013668718917441381, 0.079671455196125951, 0.25094410015800733, 0.083986566685101183, -0.080899898479893137, -0.33924514896589636, 0.11694481705734958, 0.30030957221818855, 0.21718112824532379, 0.25868897668587387, -0.15124254574119966, -0.029302358864644874, 0.15357921422586432, -0.08020234202185042, -0.22478289522728212],
                             [-0.11265163015667801, 0.22793482451484345, 0.3617231311606795, 0.017946586214606059, 0.013200680767932014, 0.12536984174921587, -0.13015033575210969, 0.099437934615142068, -0.21615905595509263, -0.27127666260949884, -0.093096025183279585, -0.025212599312140784, -0.096952585518219267, -0.10523272082377234, 0.16638200514297075, 0.073749504072104663, 0.020481057113217287, -0.082395602565039958, 0.07286640189327355, -0.067235758023398831, -0.079235248456104385, 0.22186962995374335, 0.014486594398295279, 0.028104812307938865, 0.038876001590270597, 0.071890682078266613, 0.25598663538543076, 0.051917814591432042, -0.09949845178465519, -0.24494806354843407, 0.084969142033514744, 0.15203370688197182, 0.047160525702052813, -0.074765180165191708, 0.029203084938249455, -0.057299103875943079, -0.11748382902360961, 0.15534185327571948, -0.18438205473652575, -0.030996902626709715, -0.056396743932988082, 0.067526822860249178, -0.24668944016087441, 0.062890377538975403, -0.072120485223711409, -0.16656280577400775, 0.12259243413256801, -0.18749477020801836, 0.26249542454769426, 0.1419587680370839],
                             [-0.23594653637777341, -0.26189669247995889, 0.13111000799398731, -0.0019109357311884326, 0.26541293347799078, 0.064301995544006313, -0.012516605500390165, 0.053014191156334933, 0.18716315803095743, 0.016935902461676103, 0.23126664174562239, 0.10518075477470154, 0.19315121234670948, -0.1516067862205196, 0.030524549295470407, -0.015773467020857645, 0.16471798091352222, -0.11490609112221782, 0.078653563967956114, -0.06557534588335083, 0.23433191548741014, 0.079491317547411885, 0.14679864293790759, -0.022360350942580168, -0.071825792959428106, 0.07685572930353908, -0.13215516133076105, 0.17471065220289267, 0.17039350426004052, 0.23550106451104422, -0.020987922527472992, 0.11769935671948767, -0.11686420024444075, -0.18033912385745457, -0.012786329952292263, 0.023891935822076341, -0.15110974039017472, 0.18359711009827812, 0.068652736178624205, -0.22867257043449749, 0.049243360733030643, -0.23066216393676825, 0.048968926637607976, -0.016614972043235501, 0.18005018677988205, -0.12697853778356286, 0.11885592672269329, -0.14026689331643777, 0.018505125401568567, 0.16207589742349945],
                             [0.04380756645271907, -0.071767294352826971, -0.15208196992886375, 0.14576175122436028, 0.039251425000045324, 0.18471954186270709, -0.12673406028764897, 0.19889460341483534, 0.14756594071156531, 0.22002013800499617, 0.08942660795393087, -0.049314967503443712, 0.054972588597979544, -0.03262344130114464, 0.12828108250908388, 0.024509631262636073, 0.18366867599721459, 0.096153304886963623, 0.17264842435588434, -0.033814644038647521, -0.29380837308154661, -0.024277939508939441, 0.0025271351113666735, 0.23488725149006348, 0.20338526098194071, 0.13786178335431437, -0.13335455267710267, -0.19314854263548012, 0.19365267740244491, -0.19101576240056056, -0.077124694641394292, -0.1289030849664978, -0.0021181680666499132, 0.31001003254510029, -0.12191587540151404, 0.07307829288448757, -0.020248904465184958, 0.0078218421853876105, -0.26954337237832132, -0.11678340763104604, -0.18438009856542398, 0.014668004138719777, 0.0063834737067614512, -0.15030714473946061, 0.10381876916472536, -0.0083452292294918743, 0.19754656897972217, -0.039967335680400701, 0.12429815976385052, -0.025260468685602638],
                             [0.32337998472309942, -0.19858505831161166, -0.082286587533227692, -0.16196626798054312, 0.20143425800981576, 0.098096667375030144, -0.12057322918498739, -0.13899489758947622, 0.018449451126071981, -0.13513404740788151, -0.15150061289771799, 0.092222099976900493, 0.025491778805466544, 0.040429195164211208, -0.11854347057610723, -0.0096234887503961284, -0.11174415116323973, -0.16927416841566989, -0.11399320065038038, 0.22681570318568606, 0.01598303173387779, -0.046208145345716142, 0.18698100965656325, 0.018026269666702611, -0.075055712724861792, 0.040696207051705693, 0.0016172182102953182, 0.13895963464816938, -0.058317552151227636, 0.051824524217299085, 0.059246376511358396, 0.2643638398494248, 0.25716408696918125, 0.16414148586806146, -0.075385053409199237, 0.17763535833086366, 0.17523908699083854, -0.23278758622476203, -0.21103002086380987, -0.28252503072555435, -0.13642077289068238, 0.0066194672790370187, 0.045144558935254417, 0.14335176746696754, -0.048449352450880293, 0.0017961057486536197, 0.065331271537431651, -0.14974806486473144, 0.11500865082571042, 0.0041722171078587738],
                             [0.064895934083108439, -0.13186124620836795, 0.066379920434017733, 0.023041171887348354, 0.20723368353678889, -0.25263269780636805, -0.011419906779404255, 0.0005087939242286732, 0.12642720881649455, -0.096890380763814551, -0.15670683108478883, -0.088905634541304498, -0.015576630913663941, -0.044013671769020497, -0.10548854825908408, -0.17817860647756642, 0.16599426788813504, -0.090606043981813739, 0.010489050042938477, 0.036550951559375044, -0.20849073431766565, -0.022275441587488759, 0.010386115049710078, -0.020169049853693215, 0.38279649507123015, 0.018335817229979057, 0.0026891952584726735, -0.018230052472717233, 0.0063499384594458957, -0.029831975901666641, 0.1228433002478328, 0.19094999406526822, -0.34516165865881215, -0.2371207212355198, -0.021758306065018333, 0.026799302890748344, -0.073420662831285316, -0.053792296140957895, -0.066883023071564046, 0.11251952586762597, -0.13574420111135266, -0.13542064448621147, 0.091895599201764308, 0.11880951982492186, -0.27385505413488659, -0.055672910409671851, 0.05875969946940364, 0.34978860198625006, 0.074596050027704114, -0.10738692120180668],
                             [-0.02818477913818649, 0.12633563967377232, 0.14719572401909328, 0.069116664540509271, 0.069303686481383756, 0.15015840697228047, -0.13490350916125965, -0.076077251903089518, -0.26644617168908102, 0.35818943283412175, -0.040625991711359208, -0.083373752794030184, 0.20478598314622612, -0.13270335441166334, 0.029868428811535942, -0.28592779030081494, 0.053739840797597575, -0.14453468013501691, -0.28006310797902434, 0.24859524751375653, 0.044429597080008473, -0.015838649720312011, -0.13153200003900906, 0.10151261356003087, 0.052979114610295398, 0.022051941628287997, 0.12492386208650257, -0.1064372613254803, 0.14412045883396776, 0.0095721620706109914, -0.13654888255891373, 0.08392924740753227, 0.077132237158084593, -0.042535394858661174, 0.029022161199185541, 0.00080405009964405305, -0.13467312029510017, -0.011090026150164729, -0.11087733432226393, -0.043532141738522649, 0.10244605075243912, -0.028017800692161813, -0.081446106490921405, 0.15318469409207386, 0.04124237137960348, -0.13116599552713948, -0.0017834581156705213, 0.0098473075560163506, -0.35648939861685758, -0.23713190656011776],
                             [0.035166177523015055, 0.22064128255444693, -0.10158306293533823, 0.24896033065950288, 0.16825226904479212, 0.061389796539392263, 0.15722361198469784, 0.025629094898811496, 0.41791164054949204, 0.10407241002465939, 0.14018306084184848, -0.027677525498501547, -0.076654402155002743, -0.013299890245096754, -0.079529340682007857, 0.098727895631418025, 0.021619924991049033, -0.15429384698468102, 0.074007910530649895, -0.023896969438478882, -0.03302129875329133, 0.12942880832698406, 0.036256571813144303, -0.0079394571199323007, 0.080786267040985182, 0.19156840972439623, 0.12908448661367325, 0.091294034685993647, 0.10052646234240893, 0.011951501139827828, 0.023315467363334189, -0.019413244121505125, 0.2020080247294265, -0.10525225207314348, 0.32598651522530159, -0.327021421939164, 0.14581319369394311, -0.10034538486439844, -0.038378323977163203, -0.13620389113929326, 0.031451834183887195, 0.1830321044859865, -0.0220719505596472, 0.12180216371869503, -0.24241884975349434, -0.039977780590977403, -0.12891871190694601, -0.0458915623502252, -0.13421089948360343, -0.0016885555026678451],
                             [-0.28866453028577527, -0.059416546848246862, 0.071977804592094963, 0.095735866581251869, 0.060838753148828972, -0.13510954751914528, 0.051955796835254808, 0.033383593372663535, -0.16075934958701499, 0.073804805298905984, 0.034844689305149397, 0.10692588325648374, -0.0074840673681502348, 0.28931161621368062, 0.14782126571054488, 0.11763093187972296, 0.090115474130124773, -0.20719434197852771, -0.038473891490366105, -0.1854552701050198, 0.025202216193676172, -0.15833595478421611, 0.0048928209293030399, 0.096831840392941487, 0.15811622604111966, 0.22019142366776912, 0.2652983925737219, -0.083838520822753698, -0.10441844407513834, 0.024655341614237554, -0.13884759900425925, 0.048557731786459536, -0.068070458615710663, 0.11318009816298256, 0.056583926127621517, 0.19104310974379768, -0.0033282890656605672, -0.2785564927169184, 0.18866185800884566, -0.15608263733799493, -0.028717307773449254, -0.059192817405421261, -0.050613496756723927, 0.13978381279607394, -0.051058117774226912, 0.41178605699337528, 0.03230830396916054, -0.073969846992579594, -0.020644247563036951, 0.057619564215634925],
                             [0.08290000393508333, -0.0048095493870739889, 0.029060159680049706, 0.1659889568384163, -0.12400971611783387, 0.18234953707279228, -0.061474482919267034, 0.0067744282513753354, 0.27663680450636335, -0.0090199075342779142, -0.1848185351465694, 0.22729177777689175, -0.15175559104239134, -0.04980059730527233, 0.11689166968362831, 0.089130638470285642, 0.060159698395955495, 0.049226645313951545, -0.3325273007980471, -0.13329202329877851, 0.11841726185132183, -0.059522916177748297, -0.053644116182341627, -0.33262376017458789, -0.068796688300950579, -0.018790641329641162, 0.20336563838946667, 0.020557219186523746, 0.076514093547364992, -0.052723491988167184, -0.1318546778982598, -0.06361479285168252, -0.12167324934056924, 0.20428011974961338, -0.13820849117022582, 0.095162412683382297, -0.34198001781958753, 0.057478553218580586, -0.010189190472205231, -0.092125038456317934, -0.15076407219697516, 0.0093045242449571949, 0.21344929360323356, 0.095877198395618479, -0.13866869813125468, -0.12062725578337889, -0.15583871897099269, 0.069454334996576328, -0.036566923338282903, 0.070531047255409055],
                             [-0.014571808946669353, 0.13903290673274438, 0.094840531313541795, -0.12446004167901466, -0.10513999847037428, -0.18743803310418103, 0.36701772168862923, -0.085909108455121466, -0.038087876566502699, 0.10588119351590712, 0.070522005415684944, -0.24041509236154721, -0.13634981665849097, 0.12334178348794331, -0.079712354338485128, -0.049595303117613079, -0.18284557926009157, 0.19406513975030343, 0.065620361457610563, 0.24122881915687311, 0.087967819881264606, 0.17716515660367324, -0.04652527451505787, -0.01058772228908934, -0.041752320708202888, 0.34332145860235191, 0.097752206486412196, 0.098642957394002667, 0.1172503013079096, 0.023446187053855563, -0.094974940125892277, 0.044822947735518835, -0.1792031986084853, 0.27473768761431483, 0.04930875701469345, 0.072449248265997329, 0.015931595159300121, 0.16849739058506649, -0.061989900898382251, -0.079410203134138602, -0.14178306798405793, -0.16865822233410088, 0.21199150624981544, 0.15370519456521697, 0.0016665569936426296, -0.10422990848427967, 0.15546193552730159, -0.043400446991239613, 0.034349608643914328, 0.033910871289307296],
                             [0.13652714296772039, 0.18544883326891839, 0.15625048754459664, 0.20806919775731686, 0.037767154490016011, 0.090174702319540889, 0.20732345409124284, 0.013329367857836992, -0.076085083016465452, -0.045075958689820957, -0.077361785637467151, 0.09178925004928537, 0.03959197153064381, -0.074250270989297179, -0.061832411923011421, -0.34912657640491079, -0.026834545509226836, 0.061010421622596699, 0.27054528630305991, -0.18721006228470069, 0.1406911821686567, -0.20463074757168701, 0.237229385426804, 0.067854964956640743, 0.041368871521429498, 0.097854842532386965, -0.19282215443303369, 0.124189745186289, -0.13097635478300079, 0.0074235219547155408, 0.29093868488231633, -0.11215689617480641, 0.041597475737404382, 0.16726508718660868, -0.036042624235642418, 0.13201773160477701, -0.19926498096007364, 0.06313201373735082, 0.090767959809502863, -0.058428479145462085, -0.10892469094064058, -0.063159240029702149, -0.082974486290714869, -0.0070930430520182407, -0.12876498965915023, 0.067531022112892802, -0.15010866890996821, -0.13630794929791326, -0.10186018077435301, -0.24240840665653221],
                             [-0.02888294934950739, -0.025066417480391463, -0.23547348103627089, -0.014792828006900204, 0.094124810659666616, -0.22644882263008442, 0.20423205175465656, 0.085610282956630382, -0.0077376256338911095, -0.21176170835051955, 0.22663478629733932, -0.065426825826129464, 0.084953105661875722, -0.24697004687827351, -0.027299941069275961, -0.13205529862184925, -0.077439461997420106, -0.14328792151053427, -0.10200542660753445, -0.25833002557922968, 0.015663410880094871, -0.019757700269546319, -0.10491639218813142, -0.067844211384749123, -0.078468937997935098, -0.12030449806896697, 0.1066702968044856, -0.29234780005256272, -0.065881160300685304, 0.029677097541853836, 0.10215891650888667, -0.15298374935403131, 0.0089654793709103599, 0.05440049473617372, -0.054195088024096442, 0.0088893033344614788, -0.050335933378632222, -0.096091128805780995, -0.3288332960898841, 0.16152547399320621, -0.12826190095555295, -0.05912227592072479, 0.021554471570435409, 0.31757008306229362, 0.11277936351130886, -0.053914210829438633, 0.048853486434833171, -0.24568374950699831, -0.11113997162618974, 0.079162715601273248],
                             [-0.07654476934455455, 0.27344823297743387, -0.052901061501113698, 0.2083233259536936, 0.099386711840710865, 0.024696229189273427, -0.1559121390270409, -0.1937554864910522, 0.17276372994400249, 0.086340714086221695, 0.040242804304953063, -0.07350407223462041, 0.0027464078718311105, 0.1105121192297031, 0.07089112865594413, 0.22324156508947324, -0.060773441916943248, 0.0071080615633995151, 0.15260362556590623, 0.19968035490669886, -0.19327005119711846, -0.043315682383635125, 0.061039601460031449, -0.11559214317126074, -0.031556766227743754, -0.31750137560216235, 0.025456126986673776, 0.17425580197132298, -0.12197160122683251, 0.078974360670308372, -0.027900875409481232, 0.037863217785915004, 0.057273193927114809, 0.012219475501080674, -0.073404330688558672, 0.06774501734753817, -0.061211172368552905, 0.016818371594138015, 0.021755366651103097, 0.2196985779659221, -0.24829173853037395, -0.44032901657883228, -0.15350096024031085, 0.11365232226383674, 0.070902493910439249, 0.076607709344072933, 0.1058695676576205, -0.085328845819693258, -0.14898683898664328, 0.016863575570990757],
                             [-0.031740528632624644, -0.097344910807458607, -0.021640323377716937, 0.13338494737840401, -0.085030139658046414, 0.24005446352362891, 0.13323544363180045, -0.1365322872195201, -0.081505112265466612, -0.046619041337093305, 0.077459315469189702, 0.027759066520539315, 0.36601556308772626, 0.0058852974890419062, -0.098629277986487907, -0.101490369522822, -0.095033707480971466, 0.11686536826104886, -0.079614297763963449, 0.098932421195655637, -0.36094739894710764, -0.22479967232837045, 0.25097059448160314, -0.03865635621915714, -0.150608264974262, 0.081494584260619715, 0.28885225926663549, -0.012446280745876394, -0.25137553556202913, 0.006215485375025585, 0.0046109325423168493, -0.081749648106830414, -0.21688869040874473, -0.1266097112938967, 0.11810174651313107, -0.14914402622189532, 0.036633907618651353, 0.14328612144903721, -0.11997520860086024, -0.12134834787150668, -0.05066196459744747, 0.03661998823441677, 0.10993556601405023, -0.11435760831343651, 0.014425910205236418, 0.081614139138983799, 0.0049451242202639308, 0.07888045944276989, -0.016287599921092525, 0.20179886964098834],
                             [0.052029831510378023, 0.11842541565424136, -0.0086360363371883568, 0.051430879399203336, 0.33404442174993126, -0.21554608489507751, 0.18350485291651894, 0.051735093727759328, -0.042911322012804384, 0.096704380622415695, -0.089585053774565354, -0.022144003021089924, -0.072231769220585315, 0.16257439416259595, -0.065211398084243852, -0.0017147805644729514, -0.11152771402335464, 0.071022897009083194, -0.12478454595965456, 0.014290701963769732, -0.0043126076072193351, 0.17846813190353322, -0.033361568135367822, -0.10764331892168448, 0.043964324842337796, -0.10269892919754299, -0.0932327506066538, -0.046848120337693137, -0.019816555825291481, -0.0086387420256890755, 0.00022477677988087618, 0.10250403938504145, 0.057154883803930384, -0.15116002253270833, -0.039857644843204573, 0.14654564441470197, -0.25545508788992122, 0.11259129893682146, -0.20779645155242724, -0.19799355004325825, -0.16844683839273975, 0.25395495275560037, -0.12950296026989852, -0.35269830912836947, 0.18052358487742484, 0.21681999061679155, -0.086109418801180088, 0.067690194133720683, -0.17887828739649114, 0.22637838379040306],
                             [-0.032030440223101045, -0.036484940978308948, -0.22813831468389711, -0.073473973766603223, 0.097646827257119234, 0.29943356722990794, 0.21537156724618306, 0.029271418805939014, 0.047625572331010495, -0.15280506281653222, 0.15455324584846983, 0.10747572988395401, -0.24050359705625438, 0.033635963749203052, -0.035604588078354121, -0.033412908388625914, -0.056400212559204708, -0.073968272608670754, -0.33209947793314948, 0.058033597850043368, -0.025898509677382251, 0.084106503716416592, 0.078834946250073076, -0.029509452778295461, 0.21989764378223242, 0.19986860195151299, 0.039485030573024438, -0.13753415299375193, -0.088193717503178143, -0.16435753137191253, 0.091828245404175585, 0.20559726302423456, 0.0053800531949748185, 0.083481876551792525, -0.040948022482545955, -0.060172629992965902, 0.031859087532633903, 0.13421793284504324, 0.13299618086712817, 0.15418242417970626, 0.1115932949555761, -0.3322062771062706, -0.18994665481261491, -0.2127699025143038, 0.16694059680210166, 0.0002318379958894698, -0.094740912777065145, -0.0036901754883414658, -0.021029807942656166, -0.16026368317477521],
                             [-0.29852808664459513, -0.14414675772001803, 0.032192108735742672, 0.072453748140812652, 0.12221077605377696, -0.10769126772928461, -0.057350623768586469, -0.22467662795528104, 0.077063108063417943, 0.1433847390563934, 0.10937431679583384, 0.1039517735115166, -0.1949041381969851, -0.017361684496260792, -0.016156150357913894, -0.06476482406016322, -0.20922954689619058, 0.062900028523296569, 0.056350732024983703, 0.17977068009159367, 0.076137436630208333, -0.28428175323141364, 0.037384595097051901, 0.010347661644059706, -0.0065676100373633839, -0.18132147175071825, 0.003156069115152245, -0.24563483450404214, 0.088106904725775523, -0.32978206638581914, 0.23641420566911026, 0.15893539996383113, 0.10172165908205411, 0.062375614079540828, 0.0084440126773506364, -0.026073099428245594, -0.077301082044980512, 0.13706677111039675, 0.061651941446521981, 0.032669769128587559, 0.13923377447338822, 0.14478969375202269, 0.18062510157078132, -0.043773856437868547, -0.25090401470489204, -0.015383383695620451, 0.17084656834825282, -0.16734611633336513, 0.0064767977046099653, 0.096360309617699702],
                             [-0.082372383607881169, -0.21806690654135882, -0.11176088247475841, -0.019912847164978528, -0.10667319442496843, -0.13600314909526456, -0.016865263462039783, -0.038706977665038625, 0.089824735799460015, -0.057490254362324703, -0.07265659026512658, -0.21789656189559209, 0.051326909006757959, -0.052715141200100339, 0.31450292090548465, -0.057349095442376222, -0.11800593868254641, -0.067024213699741195, -0.054241756405470354, 0.23004217247557809, -0.051114044708739967, 0.091736084770633872, 0.31512742459811033, 0.005757995066274323, 0.051520640306583203, 0.158853618764556, -0.075743745551206776, 0.0012206566160989395, -0.051921427939938675, 0.14233957464311822, 0.029127745581103159, -0.10284732656621817, 0.2299094772684053, 0.13567355296282543, 0.12172827686184232, -0.13883150394558577, -0.48142729739349444, -0.069525248938921771, 0.1171305520385663, 0.1464620777031867, 0.0087386251689701728, 0.15974628239734159, -0.13715901821010135, 0.11288310510242577, 0.079959271228758802, 0.033307017468276377, -0.0046959231098804306, 0.14217379594867871, 0.11483705661025061, 0.038778656853375074],
                             [-0.078496490373208203, 0.012066550567435603, 0.068085279445929153, 0.0036791613893264745, 0.14687169734408345, 0.14112060456254971, 0.27683914472373983, 0.079448553385378498, 0.062951888480069218, -0.10196338009047048, 0.18575826754229438, -0.049862310134025097, -0.23910299780850042, -0.11722285037725018, 0.16219596482171098, 0.024113508904712533, -0.12477105098168369, -0.0017097079254510623, 0.033134490019840292, 0.091045577763465405, -0.079646548369311232, -0.22133273620534394, -0.068451020815740601, 0.10973087249803862, -0.091944372626694165, -0.30685477155208812, -0.12837950362790279, 0.088423236498543875, -0.15110702666119333, -0.034085711962390138, -0.283311892317614, 0.013992842191471594, -0.12370717123306486, 0.016648475674744027, 0.036501977841976355, 0.094274726913467416, -0.019105839242678172, 0.0086290596326574869, -0.064282262442448654, -0.28061387240589042, 0.14723899699827869, 0.13280507640772338, -0.1256300950623454, 0.25382071937667172, 0.087026975035339904, -0.014031711796615854, -0.016818068688462168, 0.27605208980718454, 0.14865243530137734, -0.22818845044521721],
                             [-0.18291939812321079, 0.2322476501155768, -0.055595760020983868, -0.012098467923496208, -0.12667212113415985, -0.18517797305779177, 0.11209126629791354, 0.17202174955983371, 0.10734351917356139, 0.019937488821074632, -0.29733242785463093, 0.26406306746632885, -0.025235388564055279, -0.13732034491366918, -0.13256346301980743, -0.21461889721504723, 0.19234017856343205, -0.058815648973476187, -0.0080254894842302672, 0.24543720066202832, 0.017909515598816206, -0.1732963924315119, -0.049166247046789568, 0.021878270640137962, -0.068459602640459249, 0.018965830343405109, 0.017242588912027883, 0.072183668190791792, 0.080879208058253618, -0.18428474981294735, 0.051840536982756091, -0.12048637702338792, 0.21802827244867767, -0.050050999126549436, -0.0084269934211251354, -0.10743354344544284, 0.03394165806553992, -0.065863260446408348, -0.079916834649415416, -0.11149343188405053, 0.090531359969270642, -0.26324789306484492, 0.0076056775195075298, 0.055997865114216637, 0.25078568747797964, 0.13728789568527303, -0.018585599946258673, 0.15162867261176699, 0.20610509107387462, 0.21728346784421271],
                             [0.47750100809970064, 0.059940718291333572, 0.19916815892370845, 0.055218112053740963, 0.00991727979506867, -0.072705959620995672, -0.0039742544650657359, 0.2317171189981794, 0.021763715248703318, 0.099012197488239403, 0.13580676108513268, 0.074038153340056201, -0.189643542700105, 0.13308388117193204, 0.27498868594321596, -0.20028120322251258, 0.09898062104046805, 0.13971834350971721, -0.053402526286196642, -0.067151163195643834, -0.12617463211351268, 0.025560844156016314, 0.10994528898433159, 0.084023714983037262, -0.066527855825896612, -0.14551781852675469, 0.092096383499993592, -0.19394631967481446, -0.099388517044747451, 0.12797526500786036, 0.084512750897921193, 0.17519880364362581, 0.10554444376577056, -0.043650797660594917, 0.099750098083074792, -0.1184157814492848, 0.0057060885723684823, -0.0076806777270685845, 0.19970779011592185, -0.02000303477697897, 0.11812903375165587, -0.11126795415202549, 0.22831821967574176, 0.093280315701238584, 0.15621193493896018, -0.0027120325283282809, 0.19534527340970043, -0.0016442793461124141, -0.044827311326232057, 0.16015339743830717],
                             [0.022967220930801807, 0.034500018945369901, 0.15922855146992523, -0.04288548636639293, -0.12975635856042358, 0.041511678944574505, 0.011407830382662364, -0.26666947579240696, 0.24303257436059758, -0.095338115861439712, 0.17534726817577534, 0.37176955309535975, 0.020936559303977996, 0.045711858764617593, -0.015565463883670526, -0.12949460409098759, -0.10130424069346698, 0.031811955204263123, 0.038946461656029524, 0.039929267739094318, -0.0074503821141817085, 0.22952323348499987, -0.1369566096463023, 0.16440035944322667, -0.042213434562450823, 0.045647771581677883, 0.020866561556809063, 0.08074552137558004, -0.047875652535401277, -0.11275240624499823, 0.057627660690955575, -0.10165740279255862, -0.14734453932542441, -0.0492531747983493, 0.16736780564113213, 0.19891604518359984, -0.17790975034231918, -0.4474311136943403, -0.10277825247958462, 0.11476672905581015, 0.063330567340154478, 0.05585567113041244, -0.054736108154792455, -0.1583346143992666, 0.12451966766506668, -0.073013175085195364, 0.23392283141956113, 0.0584351746587305, -0.0985575436845081, -0.032684691098587425],
                             [0.24480616229909541, -0.14167098735238731, 0.13196883417678595, -0.10074491525705455, 0.038942578791263484, 0.0071292656147898441, 0.0069057604124497986, -0.061455727896529345, -0.018930883247843262, -0.077123749216586726, 0.051019812237125185, -0.10200247017434766, -0.21003764912790221, -0.19203292598420199, -0.18404207536304293, 0.30285156609362746, 0.14930777601487075, 0.15905907787126899, -0.026370307116875026, 0.017541118060122676, 0.077112262360571546, -0.34458480937108094, 0.11012914755096676, 0.21713172428345709, 0.075375267461357087, 0.16606705067907798, 0.12874262790119997, 0.055694431768800415, 0.14023363769521976, -0.12870299209773786, -0.085083587036756156, -0.174347939717416, 0.14239620449330626, -0.20936982903462339, 0.18615073100050894, 0.23584931044757099, -0.092578567564649855, 0.10134039667522189, -0.014527562300761167, 0.18626453906731782, -0.047405750804366119, -0.01496989955713891, -0.091902450779759143, 0.083482704850221925, 0.11140920387849741, 0.033240734318785499, -0.0068629729694042393, 0.016323360988266904, -0.20124816698130224, 0.14640182897182175],
                             [-0.013736434468626187, 0.0035927583618244013, -0.1360869511856167, -0.055183661433774775, 0.13479058710014483, 0.016162744254232839, 0.047270109041303791, -0.079405922401450349, -0.20348675900131916, 0.20020096905141865, -0.021653452400321481, -0.011342949071047919, -0.13693218614915381, -0.037365328636162265, -0.093735723376766084, -0.006419671536927722, 0.15597103129075954, -0.17978036393234609, -0.15527266683235624, -0.13237364427396453, -0.46674852512411802, 0.018512759043152926, -0.19106411760024047, -0.10153257219012629, -0.1948212156916666, 0.1227333219038215, -0.30537837068373258, 0.22059152476292723, -0.11816279059447256, -0.087376178153417805, 0.1041349741079601, -0.10825014908148406, 0.012145639976435581, 0.05382596883625921, 0.17746108137835739, 0.16944457847859551, -0.12694009937653764, 0.00071372095748029355, 0.22290434857700733, -0.005267477682371062, 0.087041630706788511, -0.00023320960438534988, 0.04448608841670277, 0.075753540595766236, -0.087846951630113898, -0.1932657524686674, 0.060792552491962838, -0.099863943908665889, 0.030744782998538958, 0.18375350425431067],
                             [-0.15439509828262923, -0.089786171673917045, 0.21484032168474515, -0.018427518354795894, 0.055107765883735955, 0.07675708636282963, 0.17559250078626815, 0.071265500615487573, -0.10541395519501204, -0.13631236204443065, 0.074449833428810536, -0.049937655200268764, 0.14292737300547345, 0.10606530954583811, 0.077777303868571734, 0.039042668484805185, 0.22772103882501155, 0.13441510307042703, 0.1377710106887293, 0.16868859387094015, -0.072376571439394147, 0.046331191527409915, 0.073627147444561752, -0.1943526347509297, -0.0043545100779586177, -0.09124916148760176, -0.14157517409810172, -0.15030799900039893, 0.051705773282497244, -0.23641315557546169, -0.078868467786921304, 0.1404080712701419, 0.13395068670459354, 0.036023925424467203, 0.16320212325070019, 0.062837514005561576, 0.040705844584378328, -0.31434541226348656, 0.03604542376843492, 0.088141356315259503, -0.17976965928645142, -0.031684996153943955, 0.21862193898297128, -0.004772209219627347, 0.089855351985255377, -0.21222836577252599, -0.44059172590000545, -0.04924854252093027, -0.071313604563044572, 0.033378219455125632],
                             [-0.065489625207505842, -0.063532752603615988, 0.070973749289703472, 0.0073440097386723883, -0.03324901631239751, 0.038417036386298502, -0.2923534386545325, -0.14000043170988893, 0.089909375003576056, 0.22908694889194603, 0.046422920513671806, -0.13776239372707305, -0.17352402232667213, 0.066133177965866097, -0.11298984734037892, -0.22633262896553782, -0.10307232178572637, 0.18484695742448723, -0.12475219835561323, -0.20444840973162773, 0.026172541950659857, 0.23317895563050769, 0.26064381318412588, 0.060625194409043875, 0.013964446151462851, -0.041558016256825869, -0.13431841223806093, 0.00078028310342716353, -0.042212874401341624, -0.14883195351769365, -0.037883464789487516, -0.066282258356181262, -0.15324351580018489, -0.038120635579993248, 0.08290153914344367, 0.054413291996417132, 0.091395917653462111, -0.025106052680237752, -0.21301898962578472, -0.0086776837281535343, 0.15029732702029358, -0.13391365496722377, -0.075215058349609815, 0.26449519496640195, 0.056644406194769042, 0.18646745218304933, -0.35971793394413776, -0.055524224466473232, 0.1403045690551501, 0.15722792076009978],
                             [0.11218120854259941, -0.15399734372626472, 0.037841451133456203, 0.12010423528915036, 0.19056744275542847, 0.033737702461751125, 0.13765681830920587, -0.24117508269582077, -0.069536715027218768, 0.31186250294103596, -0.18281065668635668, 0.083693919498491406, -0.16913056201390878, -0.31528110890701, 0.20911112444534052, 0.031222113889982396, 0.16422638353756305, -0.087385013803891978, 0.14559758195896155, 0.047962166789464099, 0.15488881617760766, 0.063485748583445661, -0.036783180612577376, -0.16949685997548178, -0.20422386477793339, 0.098663451060451199, 0.074036899109593463, -0.078042113035161453, -0.14435313472900288, 0.0230543728927129, -0.010191021490189987, 0.027665236508948376, -0.15150862435101156, -0.0062292901905419929, 0.13291948530362216, -0.086158811443754715, 0.1569268917665711, -0.016766476783306644, -0.092506086253629272, 0.25639736089313836, -0.13730924573102812, 0.071314776103799896, 0.012224007122387403, -0.097704741584284729, 0.16986787152756427, 0.18819124306308049, -0.0016436738473005134, -0.043487599807655722, 0.2186795400717492, -0.14722715882043261],
                             [-0.014976576542799326, 0.099090541370648891, 0.020847165405823685, -0.17323925828454331, -0.0034518243196700027, 0.027759309551921019, -0.15786235853318292, -0.16590422497021554, -0.053541526699468732, -0.13318586104132782, 0.15869131567606831, -0.12669688136359539, -0.17357307935707667, -0.053409375612554155, 0.080107069389870791, 0.15885266583233984, 0.26570204766965477, 0.037241804399275359, 0.086330260071920281, 0.15110867092923588, 0.030698631614508164, 0.084895933346853941, -0.030899036773681988, -0.14825496121512527, -0.096884864886260247, 0.17468895558809469, -0.10317028782884367, -0.23942410072193665, -0.23717565013170577, 0.02582471504922754, 0.17510433302868789, -0.22397621903534215, 0.047492896904255927, -0.11185998885557162, -0.1418807794861994, -0.091560115601294428, -0.13919856384666318, -0.052491575524201667, -0.17045362425840235, -0.34053383479760896, 0.13589085324315409, -0.17764317920979089, 0.16830867898493435, -0.047927018333464057, -0.15110378971711091, 0.19286683337325344, 0.011384925438389013, 0.080306988817507863, -0.16170113462662641, -0.13039882391044344],
                             [0.12660773858646326, -0.036621492409804057, 0.1751665803150724, 0.020069147070648587, -0.27245257557662267, 0.12340377841988356, 0.16376017109230631, 0.11820526785070283, 0.10269704759333989, 0.10654093586727963, 0.094907957697777323, -0.064892421649309875, 0.11920430212175563, 0.23421315864995446, 0.1060654260895515, 0.10824972179267112, 0.095584094092028421, -0.46877459340733607, -0.070839959531203145, 0.15229304695268334, 0.17282882997371657, -0.018073214106345575, 0.056442785530346921, -0.069761538743924809, 0.0068258968622514904, -0.032980802623338856, -0.25778803913222548, 0.029578132044387275, -0.063949671575669456, -0.20365317951551459, 0.22426258333204233, -0.03551967129720366, -0.12644533962644638, -0.0021507267398153786, -0.078258664115889762, 0.097249572342938254, 0.13162092205142586, 0.17656351520281363, -0.16381140145856915, 0.15188348647653102, 0.022030647096343427, 0.11797880123586145, -0.033142241569130683, 0.13658032831876721, -0.014959530274697529, 0.107661139232991, 0.073146950694181312, 0.086500781201959337, -0.12143193587085141, 0.17230357783927833],
                             [-0.20257747601603537, -0.10522969911078939, 0.11595338969860172, 0.0072497856585642785, -0.35032966797996784, 0.23538319680455061, 0.076330090956438598, 0.0067523440074611215, 0.062361567286837151, -0.0089039853450807241, 0.053481712358428551, -0.17420245318135921, -0.18125486715582523, -0.17512191849544559, -0.17505184619630729, -0.099298809584095898, 0.016288441835758598, -0.037293563501782978, 0.001284416249554179, -0.17099032321468494, -0.20737474782433871, 0.066066544535739347, -0.12717333374938275, 0.022308673490501339, -0.080571730746447107, -0.033262414996393201, -0.0062271367969662537, 0.10454906572628814, 0.13983917555694744, 0.15527617387602136, 0.10308062810667608, 0.3537001065666337, 0.24113455832906372, -0.10072505543284871, -0.069676302833841769, 0.030137410182073863, -0.074182154317408849, -0.029700346451744443, -0.033217810806953303, 0.044959646684176888, -0.19704331829593513, 0.079585068652137256, 0.18785575513970623, 0.0088401385580428211, 0.064356620221034611, 0.35952274928620648, 0.065330607118285311, 0.04182801191363273, -0.055316422089248939, -0.098579709789939129],
                             [-0.1257058775678907, 0.17987454384970386, -0.15248992287506569, -0.17635070379580903, -0.12274102346012776, -0.10713021584989525, 0.031292169327587313, -0.14746487515285236, 0.00012612851950814457, -0.053443190513806728, 0.16278579764935566, 0.16508689847419106, -0.12076239387656545, -0.091235814863130191, 0.2463509030198251, -0.24477305631958249, 0.36285908431909336, 0.047587209351372353, -0.077090870961999791, 0.062441641894199797, -0.017911357409400062, -0.042071255356831261, 0.18796120636173189, 0.039257460565948352, 0.2022176829730809, -0.062628879033534271, -0.022211114996807224, 0.19279110975745728, -0.10877394064926039, 0.20689299484281878, -0.2470052488488729, 0.081475226439343643, 0.059193587004546487, 0.053301674633845032, -0.0092094208156542848, 0.1468005458112128, 0.16139484977297508, 0.14938117061889297, -0.1816727278851796, 0.13705635885614115, -0.0057901783148972073, 0.17580247709041688, 0.037581645353134775, -0.12972275020054239, -0.21512724803696187, -0.018301223138446919, -0.034235210495243064, -0.11451276244093032, -0.086870840858963891, 0.12184996406225591],
                             [-0.079006968752370857, -0.12639080572596223, 0.15496033437366216, 0.13235568045370968, 0.10389891787937985, 0.041215047775103653, -0.24652086724113076, 0.28617608325371535, 0.060549264034008614, -0.11147220192575588, 0.016512488756238872, 0.040547665012759533, -0.2015712293913631, -0.094130473959585279, -0.00060308663918195494, -0.17049640013935038, -0.26356419406579951, -0.071517435954471978, -0.0090355731115193093, 0.28832551729217748, -0.0049485624170176384, -0.020886626515036921, -0.26119744594592798, 0.11300021292955816, 0.091448455116182908, 0.20405005106291899, -0.12020062013607495, 0.076293057409564616, -0.30212241978275828, 0.089451832581823293, -0.13167756029304273, -0.20069974789826656, -0.049311105158648817, -0.059856691799188573, -0.11026741487906529, -0.070610868656576856, 0.12787317286869149, 0.012623870359712221, 0.098731133137470076, 0.098829279945407925, -0.21050996181858703, 0.063882374504809158, 0.17251413443575039, -0.029382722012629585, 0.026735146691140202, 0.025664446673677607, -0.12192401874865035, -0.15250955219120518, -0.14499961262810024, 0.13920006097533202],
                             [-0.11428011950057453, -0.28789051559883122, -0.012749152527037655, 0.06576935297322567, -0.13307198353078747, 0.059213435101473588, 0.014205962161649812, -0.06009927518398224, -0.078829236150968082, 0.03189071622705085, -0.14140126909772069, -0.1903586025194933, -0.33458425327587449, 0.13573192988820337, 0.047752360802204734, -0.20330313658815516, -0.012372717954936309, -0.18233280597308196, 0.16188999884373045, -0.13417790794616422, 0.087600787276525219, -0.048224056280763296, 0.029064440652086954, -0.086050056565979249, 0.045496003819909626, -0.16014667005369645, 0.17299533058368802, 0.0097682322833856829, -0.015125594186376993, 0.095659593692852596, 0.063547892678413778, -0.18398506215669005, 0.092079475485789736, 0.057312517969642762, 0.14812614978884328, 0.0010655330749154133, 0.15894945815188163, -0.06601298740591062, -0.10418531059621414, -0.19461792978007994, -0.099797066898044906, -0.16944173900159354, -0.1547928367869717, -0.22549628343967507, 0.032069089337442451, -0.33618218853067078, 0.082123990895533114, 0.18437568400705284, -0.19800351096155711, 0.12923616005290456],
                             [0.12594919563532056, -0.086079790394852196, 0.04460753072537868, 0.28251542072317948, -0.21326725243398809, -0.21894122970126045, 0.09369484225801597, -0.19557854377525999, -0.13577587474100569, 0.07500589833287083, 0.032729902621980014, 0.049790994256084124, 0.039143967165263346, -0.20579719184598033, -0.053454207232315296, 0.29549852770423435, -0.086816586830567907, -0.14909563526827602, 0.036367389350028735, -0.069289677058308047, -0.016498562622500244, 0.039229534451401885, -0.068511895973576237, 0.21313787498545331, 0.32080474318758512, -0.076849152381997493, -0.049417650952366325, 0.13280901911657983, -0.22177508157615294, -0.0022313339783644349, -0.045568866143694847, 0.16275446181365499, 0.057839204394491708, 0.12496595358287187, -0.078781977939832035, -0.12792779658317274, -0.11995950776737545, -0.0053874056016892449, -0.14051958092046296, -0.10523270651687477, 0.22252643350594989, -0.13800210379251868, 0.2299795962534584, -0.10772522433527937, 0.11926642831690736, -0.12578095771132627, -0.20479817009676726, -0.03183464158610743, 0.0092849467220412433, 0.073510631148916261],
                             [0.17936630042871982, -0.047631318986151201, -0.2541787911374962, 0.065263197639472595, -0.15661590976949646, -0.027256143491465587, 0.025903053834562553, -0.053046659079381324, -0.1710005255091204, -0.17771404614652098, -0.029456050712071202, 0.030357422347888262, -0.15734831083571518, 0.12699019176633694, 0.20779291970062919, -0.095271520349855934, -0.059556897997665705, -0.22151477183391194, 0.069587486374850085, 0.11643733611910619, -0.062623904086645657, 0.00063128677025755294, 0.029333700361266739, 0.12552511280552767, -0.094342879660830381, -0.097932293586714028, -0.050889621538674934, 0.086166609036123665, 0.38331565251014355, -0.16625796757578437, -0.14303097876870688, -0.053071397583442453, -0.23276442982750131, -0.30005595404154317, 0.093986956118573758, -0.12578613039387115, -0.16475231832484835, 0.0083620789057297865, -0.0022992204278109722, -0.11474684075126487, -0.094306636261198229, -0.10792134427841434, 0.088616994536586488, -0.05901770040882235, -0.049614884894296017, 0.13936124848290182, -0.10767521519771735, -0.3310359064925773, -0.0020495022147699123, -0.10039681624612136]],
                            [[0.23721064106049145, 0.081911556015671946, 0.11892948793518222, 0.10206208301632863, 0.03876899794081809, 0.19323775168420565, -0.13966393023564314, -0.021844977745562742, -0.070691233632628636, 0.033235432789151705, 0.054048213759261214, -0.20166203565828628, 0.00042481424216432465, -0.0039411663632717819, 0.00023948378356729739, 0.032706646284081244, -0.055520284549326983, 0.24439032670443986, -0.029864903137925374, -0.055418734436026879, 0.087095752545501545, -0.35652606692650896, 0.13865528001535976, -0.2710564466697315, 0.22677340075232463, -0.022128277707375608, -0.1284363602113025, -0.013448972173621737, 0.023797570198966327, 0.026397196160327253, -0.17866253654056746, 0.33821812799619816, 0.051061657970035208, -0.035386990650046163, -0.036049007832071475, 0.13426119107316639, -0.18338704175192364, -0.10828338047738509, -0.010343300358546699, -0.32723262948353221, -0.24671387569129444, 0.0029032452196369254, 0.18206839949969109, 0.082979364718601484, 0.062541864305579911, 0.011254183965536579, 0.032761613027445791, -0.081908541378554425, 0.061008704382761646, 0.018485240797102901],
                             [0.04596549995143541, 0.22122370923083801, 0.36009238047704406, -0.056526627203954544, 0.17771233741862069, -0.005735116732108342, -0.068971833958317907, -0.086108329753128932, -0.092331698031700091, -0.033741201721504535, -0.000659807356060853, 0.23794982556332786, -0.0022658790260782899, 0.084319695034817538, -0.10958347364499889, -0.074221421143741542, 0.052056797735577795, -0.20598315861604627, -0.13450214512867512, -0.023846372254883751, -0.14024755227402044, -0.070768927370843698, 0.14559340727054013, 0.27757181810576215, 0.055811646590317565, 0.1734255071394307, 0.007772837762967391, -0.044226832327641845, -0.077256894647889235, 0.08446554535203471, 0.19873596188295811, -0.0083536411982745324, 0.063686426908919708, 0.11706791239537698, -0.20835943033098314, 0.043269604645059891, -0.14028303474438863, 0.060093769034613498, 0.027529058585147131, -0.037503898342668443, -0.28181055978552688, -0.090551560131626421, 0.068760769454513912, -0.16961367965466942, -0.008015054843150949, -0.08635978929689947, -0.39189214628239366, 0.060913262511246409, -0.13833229618244383, -0.11499183125287429],
                             [0.051030573843983497, -0.00054986539686432587, -0.0058810183076177655, -0.10117762298336323, -0.05502766314042512, -0.1651414717752876, 0.35031497729761407, 0.1377357090815218, -0.07921401596156738, -0.14091416685245367, 0.12349948467075916, 0.0015594650698376477, 0.20503368656113322, -0.20950493594722724, 0.010158535433964085, -0.043005209192098721, -0.14337533401542757, -0.11356341302965815, -0.060201446880709601, 0.048673469175410655, 0.031548695957534387, -0.12335175469961035, 0.056066418869476414, 0.050539300818844057, -0.079122945403895709, -0.2022088951279814, 0.073769892986468646, -0.18189088958466507, -0.27894049034667795, 0.018622468722969715, -0.011749564696240904, -0.086013417171653228, -0.1167926647417593, 0.012930310428337373, -0.072144547196390296, 0.080056328934271365, 0.098018581491694651, -0.33979695444123303, 0.36689911923616336, -0.30699370244178437, 0.10814534890878687, -0.024603040949841334, 0.034694320318953718, -0.055160270931343069, 0.015394454145986282, -0.12464693983616183, -0.078368840193742753, -0.11275123233986487, 0.14463548918544519, -0.041173569700628888],
                             [-0.14289743167168495, 0.10320871163863327, -0.23226296671711422, -0.097149464659493909, -0.1832250033051927, -0.019937219451915268, -0.11457801937022338, 0.027370478347410559, -0.020436629261904041, -0.022097438656092754, -0.010237987188601383, -0.080124818729368455, -0.008693136335228259, 0.018505416838199847, 0.044392168956617684, 0.0021488436218789898, 0.10478418991342205, 0.039666904809900365, -0.066657265152395812, 0.029246610749518766, -0.30344225158303756, -0.089617990990587815, -0.15678212259885341, 0.099323851270686228, -0.055440241826981672, 0.12133594428018316, -0.030988558541905836, -0.10050015330270565, 0.21824120177751849, 0.029892337409594412, -0.32286029662347959, 0.0012557494646807017, -0.31811214926308806, 0.088926485555046828, 0.066585676584083195, 0.055109616734454185, -0.087615611099099405, -0.0030694181050085474, 0.054119993898137972, -0.0986312320277586, 0.0074384366013179083, -0.39857769072793159, 0.1543535392116317, 0.013716096209453316, -0.14801686189151106, -0.11560889021637097, -0.16793284477399245, 0.32307706342219156, 0.12418482903072675, 0.10354658126318872],
                             [0.24404366501004668, -0.010897365730045032, -0.045783809993134555, -0.13661240066076999, 0.13706812862973178, 0.14573096487590198, -0.079577105590893052, 0.24004951939042593, 0.28923130118748791, -0.04574664328550393, -0.033433338954847361, -0.044649423098053372, -0.15870082384375217, 0.063064489863928569, -0.010461483670800211, 0.2037443575671857, -0.16256269948023058, -0.059975584663722777, 0.20125546654751722, -0.017221109204449192, -0.11450138377923945, -0.14109856985114597, -0.081962455774632736, 0.36315484984507068, -0.049693937334882962, -0.03122738318197165, 0.0073763693400607658, 0.071422408542181154, 0.019782429078371262, 0.066236990460621675, 0.12879669046918782, 0.21587125336822122, 0.074095615530686804, -0.072028946906929361, 0.070667161364931189, 0.17454638284217253, 0.07504846492998811, -0.3436517945057575, -0.21471833040842414, 0.027358721547475526, 0.10317593199881768, 0.029842646108448157, -0.11633159919641031, -0.1826310702951747, -0.084280684396082328, -0.17382480445952039, 0.056077710316275099, 0.10384147300450833, 0.028356428624598692, 0.098674131428579018],
                             [0.074660630487599036, -0.18145831960701581, 0.070107236853699489, 0.19398855736297732, 0.095990894417020953, -0.14544572849650839, -0.060634575556419053, 0.066439824246418255, 0.15717682154665991, 0.23342700438444569, 0.069311639178681439, 0.030976730415259213, 0.065845356197444915, -0.27870127770416575, -0.032856528517955744, -0.28637601961710674, 0.21514480824003535, 0.094427455031300636, -0.13034261119449875, 0.2427507864862237, -0.039617520745653306, -0.076316511892586744, -0.16562254869800022, -0.12648287062458485, 0.023610610216356149, -0.040444487230277146, -0.32691917987262797, -0.12109813563424333, 0.05771166386478168, 0.0034017646868008703, 0.019396020754584794, -0.027876032713418545, 0.021556457594026159, 0.040592567375608381, -0.059976553270336457, -0.039524805430385675, -0.03361942429977114, -0.16192467371014241, -0.013852961264675515, 0.09593619307240274, -0.14901565842746939, -0.00015474312021439277, -0.37475358334991399, -0.1756059122509103, -0.25196591214545183, -0.089493048691112562, -0.036981113304950408, 0.018947922217745078, 0.0031816317809031627, 0.097616603414271072],
                             [0.084629386265902648, -0.20381643357717213, 0.19835687406575098, 0.1202121427990382, 0.0063979421508749195, 0.21082294107808908, 0.075532981657063875, 0.055241200586135915, -0.23557681099464359, 0.086547975823265774, 0.079913634902366679, -0.098551690620988647, -0.14794126169117514, -0.020164073078594896, 0.11870863450964741, 0.056826756599831989, -0.090894835748788969, -0.29773508508475238, -0.18920712574059845, 0.29099367761516376, 0.033707126089259784, -0.0095690320396732021, -0.15780996169254533, -0.033804872476159285, -0.042181216673802542, 0.030793251077474198, 0.14891812886686592, 0.015329479173736784, 0.035733804747356768, 0.11744552655175942, 0.16275139917923281, -0.18869500406846493, -0.18635847578224224, 0.052936783839419577, 0.2634615590525709, 0.16766199716226757, -0.38402085972242861, -0.092462564505412653, -0.081866666890468051, 0.022259110333885147, 0.015424673556453272, -0.082124637834427236, 0.087093065548412008, 0.027026906924325075, -0.05166999936389944, 0.11675649505396334, 0.19595153746244384, 0.015575850212926928, -0.035692745921493199, -0.093846584688019277],
                             [0.056034085304636022, -0.016418356479162254, 0.046760614594202596, 0.084091712474959321, 0.068430634102397303, -0.16799135197223497, -0.19698584155604387, -0.20228886458008055, 0.20311632141785174, -0.04609565000378324, -0.079122778385594755, 0.12003733294497705, 0.029619990693600065, -0.13213019339071161, 0.031031897400228898, -0.058835382319413009, 0.0019611880980299071, 0.19602508971249089, 0.057992816739497847, -0.24051330634221668, -0.034802291717625014, 0.013373215054713941, -0.2284163989230184, -0.078033850587491571, -0.16655177689301057, 0.20417824186582806, 0.13969888571769593, -0.17186586614709995, 0.16757667831645867, 0.10993581079212655, 0.29571970178618384, -0.26176008915559912, 0.1380195990042796, 0.056234215757160123, 0.025979293216979664, 0.22341716740028772, -0.14683399776488235, -0.046695099984821208, -0.00099627146366450215, -0.24580808975506868, 0.16661091479492382, 0.0081820499713997005, 0.13515483140826995, 0.17216221351890654, 0.077026697423476634, -0.14410642139487298, 0.020910318933710779, -0.1600247311561814, 0.077753848276880408, 0.1499808757231266],
                             [0.070816441601581334, -0.068339492005213553, -0.046441170715409263, -0.080774145085165353, -0.090666476278921354, 0.15695120724790165, -0.035552219680990808, -0.021096492972395443, 0.12894125101005069, -0.16597396081971974, -0.33040113919249359, 0.075598541806423752, -0.23268857747261792, -0.20758153420112802, 0.1024073258494204, -0.14695208013668087, -0.11041274096494982, 0.21105048168429907, 0.068680904145530436, 0.21030894770413577, 0.0092182369733073439, 0.036259444648247499, -0.026479169043734121, 0.013023695240569079, -0.075533682466374125, -0.10531315383300831, 0.038490455164923255, 0.12225438459470264, -0.18168594384464098, 0.0079360201455361285, -0.05130143274822678, -0.11347022759003593, -0.034072287003372038, 0.14020122057911116, 0.18144864462861432, 0.024349698357753247, -0.053997549250211337, 0.083041185964671527, -0.025101379681252239, 0.016041242363865713, -0.22286076971331514, 0.11460905330818343, -0.037647414634204283, -0.095644151104478145, 0.2282799613667332, 0.17140621543069198, -0.35274041523001065, -0.0035942161010382523, 0.35110104029722583, -0.036656376149296253],
                             [0.13288007970014865, -0.071952231933506972, -0.095751898827241388, -0.2232782783991322, -0.0081905318444411134, -0.055237159909736759, -0.10921166084228133, -0.10542952337791259, -0.2445438145016216, -0.17860337457260259, 0.21006572239470878, -0.12701581346475774, -0.092196532052778266, 0.079454102025346057, -0.3160138557443129, 0.085627549427298444, -0.060078779328663248, 0.074277783233025557, -0.16110618283905095, 0.074118886151658528, -0.168727662174326, 0.036730635814619536, 0.085877316365244899, -0.17577564222089551, -0.13648930551815305, 0.14215344316178025, -0.011321191610182073, 0.20006210027437832, 0.022011569337449213, 0.3153044257793457, 0.15109033156763038, -0.011723133726292738, -0.11942648866643239, -0.024668399174615024, 0.1336659397029179, -0.13665331735789743, 0.15086906046358112, 0.10567300842544348, 0.016997393000342934, -0.035206194948225022, -0.10182524260152248, 0.16173243599956716, -0.14660985835804416, -0.0081646620239264715, -0.17803221928065635, -0.24568112134846323, -0.016654316651764277, -0.18318320337027236, 0.17801172847114161, 0.070409231208879042],
                             [0.089709655226300519, 0.12406253194754194, 0.33638193900346014, -0.1426403087554369, -0.20931945322987583, -0.064599266636990255, 0.17908832260803692, 0.011989159485273607, -0.061340317086009843, 0.051651303482862655, 0.25085073628101462, -0.22718153274224689, -0.036268021502057109, 0.050913408091862032, 0.12195295534759362, -0.072398158257531889, 0.099946709941132389, 0.031535567319536453, 0.33153313555344777, -0.0046362889951494018, 0.10648330501418814, -0.12053652594609927, 0.07851518425898292, -0.068956940477929898, -0.22356495066084922, 0.1286256548273873, -0.19686580573883034, 0.010370795968197618, -0.0041390716110596406, 0.16333302434607114, -0.090946656924309449, -0.1439156456424896, 0.23790705156490755, 0.25323576098618261, 0.170336038173132, -0.088499492835651353, 0.034923954925694167, 0.033449978728431667, -0.082232949761219157, 0.059417258951324173, 0.13718708988285219, -0.11698379228229393, -0.033461876993644606, -0.12657565511652885, 0.20321902120328872, -0.019586586024298209, -0.036941278233461286, 0.11522655783026213, -0.032039787601221573, 0.14795648176011009],
                             [-0.032921514795050656, -0.12498625578635963, -0.11224221379573827, 0.074824672564061556, 0.17206342282365783, -0.070368243519088353, 0.10079852524703874, 0.084328047422852923, 0.17743269083177737, -0.18172705085406121, 0.0436028914072168, 0.089774795945210914, 0.14803387988211134, 0.089170208252742245, 0.12128991122301377, 0.029597091636918801, 0.10495861505791616, -0.1443897667135611, 0.033348691805803382, -0.038024216113933092, -0.064268947707935592, -0.082126331463810487, 0.30795767024953752, 0.016238200176800426, 0.040545865260285578, 0.047389916491153719, 0.11493403688747607, 0.10075892165879093, 0.28964885681705527, 0.12590521156539772, -0.26488602905174463, -0.28852915530472895, -0.063466644293854901, 0.073200898555995375, 0.070483066382616963, 0.22110350924654998, 0.042563062844186247, 0.078722255936169813, -0.036495117781405559, -0.19599548078796425, -0.31373503478339454, 0.095261672870527253, -0.24949459176971261, -0.11423824865587354, 0.181552285468814, 0.019454734645803461, 0.19967855160422709, -0.00074321767105257007, -0.072922125057832896, 0.014372849470713983],
                             [0.078365210530608617, -0.22470364711038837, -0.089413882814893389, 0.02988545593426355, 0.066141713293412396, 0.02929801708372071, -0.094076391179662502, 0.028757692426529223, -0.011880576559785413, 0.0099679377725488891, 0.0036621755249633329, -0.068425842396031361, 0.10168570679378917, 0.31041993264915074, 0.16817250569684059, -0.051276269608919171, 0.2751319199736692, 0.036782160033355271, -0.14558716807844049, 0.026602489973055921, -0.024334559267996912, 0.21133473534164493, 0.087200440273615745, 0.047297572601518192, 0.082923716948574866, -0.2627651109114757, 0.027567703872321173, 0.035998331362326233, -0.2558206427937893, 0.018283779104314366, -0.012189588415244923, -0.021849685668010672, 0.20144344399911907, -0.1977149300558215, 0.26051115624464743, -0.047696577363127171, -0.17928360649742378, 0.093151689045769856, -0.018551106065118575, -0.27454366068125519, 0.18132070435575515, -0.051303764979419429, -0.0041101402943429692, -0.07421618293137934, 0.014944363164699678, -0.17380702423139111, -0.2607435148999222, 0.029668077288155115, -0.14096140796187759, 0.22811309400736407],
                             [0.0053135084608794854, -0.063141969066687162, 0.14359601869686028, -0.35374379186194443, 0.37295361881293754, 0.061770876780050117, -0.20912694096398204, -0.082353660104596327, -0.051791010311478321, -0.049818561156030942, -0.19181739141615406, -0.22503735790076826, 0.14037402323093012, -0.093106222022274435, 0.033828027048469773, -0.037637076379515723, -0.037715418487188776, -0.14007272958386971, 0.0046646064809585013, 0.0044714825967316612, 0.25564499737404023, 0.041987631932331876, -0.12409782889765517, -0.031030073385570917, 0.0056720105289330951, -0.032538405811701067, -0.22265645092778352, -0.01883453199747797, 0.20403475177370409, -0.092320849701636884, 0.0099382435553963949, 0.015984590996566659, -0.15415602057130381, 0.00077880107367720418, 0.16285894507212273, 0.10011884233290233, 0.13797898110160189, 0.077170501141510764, 0.34505458682449647, 0.011693135128108838, 0.059160015724152568, 0.1689629049351766, 0.014020636598266514, 0.031780360989495125, 0.10130287470434983, -0.071188682448662832, -0.054648580699397854, 0.22626118941683693, -0.1409430927834322, 0.006365579365189826],
                             [-0.15327614498843134, 0.02627588429845178, -0.039236802028694139, -0.031488402903289081, 0.10737122770345095, -0.14721306267444245, -0.116873656374977, 0.28925172664436083, -0.12630844920290862, 0.19157469340605804, 0.038236776213565173, -0.14351844863111946, 0.12692534467083202, 0.050711351008012696, 0.16053543044147114, 0.2045345686639464, 0.32651518413593378, 0.091503681298496994, 0.15813234714800967, -0.0095747852292581564, -0.081417030505860619, -0.020238378909027303, -0.034169655468875605, 0.16660830878411212, 0.06996984259931506, 0.13102110520765622, -0.10877574499665932, 0.27963300916603223, -0.13359335514259685, -0.060357355659814593, 0.14855863758691223, -0.085449172448025856, 0.044984118824220834, 0.0051095544473254862, -0.027564734241362382, 0.068100049458500955, -0.17527481436334921, -0.078734950439753745, 0.21517609028532986, 0.12890833830710957, -0.12929453274464303, 0.050579664308530017, 0.0013496317309168082, 0.19122706752242333, 0.10225477587790255, -0.062868472716372775, 0.040419203241484604, -0.10941203792028997, 0.34386314275498014, -0.18268453440217639],
                             [-0.026698665482291065, -0.0053965583944924778, -0.17326259146240652, -0.047597712309822668, -0.11512434638624182, 0.43367690667066428, 0.023433141356650866, 0.063271616451922086, -0.018307671388449617, 0.28361703637822844, 0.16250900916216032, -0.11887666364388939, -0.040748818489839488, -0.14304915370266005, -0.22010645468068704, -0.10981864827844191, 0.14606463992725979, 0.05203074867212, 0.093776525336530969, 0.057298481186062504, -0.1515563685566948, -0.0048124614897318094, 0.1660619671673659, 0.047649679917115675, 0.072406631881875419, 0.084163466157513328, 0.17236586104523571, -0.10205169657123944, 0.054214349627458629, -0.19840759113633225, 0.20608339164251685, -0.065939440091538501, -0.19056689057891332, 0.13632356848084695, -0.11888251407501735, 0.017263192368646509, 0.010436516259215272, -0.026080926042238498, 0.030964514318768586, -0.095833223838655376, 0.090978912475182389, 0.17600531246877912, -0.15026429887713585, 0.12021713965036926, 0.299379947646293, -0.075146060196571315, -0.12418422345661594, 0.0026362348540465552, -0.19360380578491368, 0.14790966156522678],
                             [0.10740073631990607, -0.1660152403845554, 0.022792629172884077, -0.082293495305901937, -0.21702362048225135, -0.12493596543569738, -0.16510151604505241, 0.097176333959638955, 0.17275313931665573, 0.12839837322684311, 0.20406630930908776, 0.10924667654819779, -0.057364571119054415, 0.23002461962388979, -0.037116044117969836, 0.25463097311021032, -0.081930416931959543, -0.063685271110339128, -0.056102937063050917, 0.079412459852860592, 0.31939236181217567, 0.1197092718822015, 0.12086596067732069, -0.13876333500759988, 0.13163277839358162, 0.052100618528940379, 0.13586544859480765, -0.20804664783062915, 0.036151636198645934, -0.058028012462230126, 0.15527979269096806, 0.039764537114120757, 0.039283506715460326, 0.09243077270631235, -0.11197992447019724, 0.20096996715757171, 0.06900752094585319, 0.088606084326312479, 0.20764720362972083, 0.036118252440220294, -0.084093854734451801, -0.10097996810918151, -0.10465979297384316, 0.0019784412683843994, -0.050535109788674634, 0.17749810408244618, -0.11029003440214255, 0.21909113714989253, 0.26662904843577084, 0.18896251759766836],
                             [0.13664266906096476, 0.19162325252254153, -0.04317417413336861, -0.047837155294631929, 0.17378361580774448, 0.043966828702720374, 0.076424898721641085, 0.099955581088343112, -0.078772451523358752, 0.14766317383954375, -0.015081133769909754, 0.14682826814122901, -0.11333806646000076, -0.25076353290990722, 0.069942905135795153, -0.10791598076509151, -0.042496073832913997, -0.23427705064599325, 0.011466776711460624, -0.075945713498561718, 0.13987673094003364, 0.39603097275956212, 0.19429827552624429, -0.057439735919855947, 0.27533239816661886, 0.092319219044976447, -0.015134828240446324, 0.15834190750821706, 0.21882106558522052, -0.041510520761169949, -0.15133114107093357, 0.044780397360194596, 0.0686728587249434, 0.17911532967592253, 0.034371129609040776, -0.099362701360652339, -0.069090568929664239, -0.041671593763209613, -0.11009096415956743, -0.11540948390703476, 0.19926076951482818, -0.08435869445331963, 0.025893973041361523, 0.0020845108704316195, -0.11553902069091858, -0.18769886681507186, -0.027643731704352692, -0.11500010125881299, 0.30231222536861757, 0.07055248486967812],
                             [0.11615415296482101, 0.070403592393336864, 0.32478213108091358, 0.20933124240823567, 0.019504966643024008, 0.083563074090904688, -0.19710214359532449, -0.077400502845904287, -0.13691388555774767, -0.17813081850425055, 0.20162967285526584, -0.17037860460937096, -0.1679047674693562, -0.12444339594093318, 0.31809582601591507, 0.14494935290528027, -0.051229146946017746, 0.11299957853560209, -0.00788395741972759, 0.02236076647492239, -0.31793146158501445, 0.15722096372335143, -0.04393145291931766, 0.15874504915531462, 0.17106827500977809, -0.16415214846466936, 0.12243496871576343, -0.17946649087755687, 0.10766062170280051, -0.079561661362687622, -0.10201903585197637, -0.13183437413153587, 0.06595493210769042, -0.086889147771055109, -0.10130971001786704, -0.070481745477636248, 0.26074756785562869, 0.069729287481102423, 0.11974656992550015, -0.010895759483832038, 0.058825720980095531, 0.022086046202240316, -0.19924404664053813, 0.075299484351342497, -0.013120058235284044, 0.015708163667663703, 0.012078001700143276, 0.01041124074484168, 0.091061322928542451, -0.057340140436850887],
                             [-0.17540817449141574, -0.35903707477658914, 0.12769772983908437, 0.057466491436971502, 0.15319071837006759, -0.070334269193567125, -0.0032808451661695257, -0.014242091120482173, 0.0084398519466005444, -0.13028899514074985, 0.0580176732601086, -0.21069585451551498, 0.03959047113086709, -0.01091830288625132, -0.071089879216226032, -0.16446593580414073, 0.011472754342477813, 0.12102202970464408, -0.24394353685157513, 0.095365072211008289, -0.14512259035997521, 0.098959505588642291, 0.10127649887208591, 0.0011073746509619974, -0.1092938153431264, 0.17270876875782434, 0.19781979799383392, 0.19782579977746984, 0.053794221431141924, -0.21099178209479391, -0.032845310796313823, 0.24401822869222631, 0.1704140008890255, 0.21935184921000411, -0.15950330268271465, 0.087707723686840433, 0.10790152537759896, -0.12377266746860276, -0.010753275017242428, 0.067108762477212078, 0.13424829359915294, -0.058055183427445201, 0.2505307202065063, -0.25689013896065166, 0.15160782977261728, 0.041235108491816143, 0.081040206438854553, 0.052707112114339184, 0.11521179297333072, 0.039953676841199708],
                             [0.23490341038690504, 0.21031210394831504, -0.22892830655630036, -0.097797768790217829, 0.025619910041241221, -0.17696662190410536, -0.13690304845130855, -0.018790770231976433, 0.064816428756751948, -0.10193587496114032, 0.0059748271833035081, -0.35446939740241767, -0.098832500756945385, 0.14663351084378315, 0.24349622508926183, -0.2279583770438631, -0.030912299745032068, -0.092398282436623208, -0.011387359397656517, -0.022408121531985056, -0.013652968310203307, 0.15842668335324303, 0.12983718564054986, -0.19922766145315368, -0.0017827381289970648, -0.077197689675840106, -0.047693600359358344, -0.057604635054512764, -0.061753215267951737, -0.072649462383814492, 0.15854729097469494, -0.20892856277403091, -0.21980942284914909, -0.078143979950608941, -0.3033336302792583, 0.052980679141409581, -0.069871975968983757, -0.17179043359727142, -0.144541305262155, 0.21165302657176407, -0.11055375709181907, -0.065340833493472611, 0.13095254008327725, -0.14157582293018145, 0.084941340712848826, 0.0088367149404918032, 0.019419939328424469, -0.081105550095018755, -0.072381161265299643, 0.029259417845465714],
                             [-0.32469272708931018, -0.035149554324816396, 0.016047267512816991, 0.066991529074033912, 0.02453525671510649, -0.11918227511488447, -0.089429500165139314, 0.020260134284685191, -0.28875778043289224, -0.10829521865645282, 0.082707228493791682, 0.3114481265947196, -0.14631486349220441, 0.050211204995501441, 0.09106098211193342, -0.073410282658448026, -0.11276594870542758, -0.023896029067477963, 0.30983988749621422, 0.2776353022007651, 0.024610303975016897, -0.11066342402225902, -0.099671662207765799, -0.18471591595795678, 0.18689300178179935, -0.064390675687152538, 0.012542769338885302, 0.13127402441545191, 0.10802572358200782, 0.12674987466535981, 0.028070655152342625, 0.041233119851997756, -0.048471159327173129, -0.24701239414732676, -0.18793310787761375, 0.056783214911015595, -0.023818288452835654, -0.124406003859928, -0.020991260639025133, 0.024158194026200421, 0.082387074660192336, 0.099725805233292303, 0.049052263709532591, -0.079708100712521282, 0.20853782212194846, -0.17109047308272965, -0.087466329409193147, 0.099167653416958171, -0.023642188068094216, 0.25215702007347252],
                             [0.078045445374154435, -0.10524575576316608, -0.1360382183259905, -0.032362095839302989, 0.26827360502272873, 0.082719908813523799, 0.031854870799237212, 0.061277074590574354, -0.016505783047541436, -0.073279263202134182, 0.067228048802914706, 0.089267457256440058, -0.22618041331474023, 0.15750418744277497, 0.030372236805501836, -0.16728678350231058, -0.052107580119539733, -0.17089538744115276, 0.064998419137615379, -0.089453540270025542, -0.13176438477605754, -0.14092952280959256, -0.13485478931358288, 0.011784053924304733, 0.046074227018537299, 0.39918552766858195, -0.055515214951360636, -0.29596846217067924, -0.22646426143859824, -0.15241342093634042, -0.13496785387566299, -0.028959986708925661, 0.082150383051025455, -0.084784908828432259, 0.071541407349657485, -0.30791000278895014, -0.075454310925898688, 0.039947084824218076, 0.22529863057504496, 0.0043465049764781155, -0.060187585960929622, 0.065187488737387583, 0.023522336204533301, -0.038795394216641445, 0.050906899103533486, 0.15417464809823148, 0.16581179441534621, -0.057314990146367838, 0.12400624420460669, 0.23852974280215317],
                             [-0.33508901819465325, 0.012689151988125688, -0.054872408100800601, 0.31408521797325256, -0.21461053264300078, 0.10473687381011385, -0.18385800142083991, -0.13957861583597939, 0.20985224134126457, -0.029607734952625399, 0.089273652149453056, -0.22197559417645027, 0.13435519911368407, -0.1375711942949801, 0.091543214559319269, -0.081911706427492764, -0.19206797029939782, -0.31354821526305349, 0.0024420791934415655, -0.096155180897769588, 0.029298758505032947, 0.076920882065031476, 0.14755561328827907, 0.079670506570943364, 0.063881809711814758, 0.22597279556572247, -0.21836782740110924, 0.034740528833845485, -0.061630143493231752, 0.18779291443240417, 0.18326980977854426, 0.12785095857922385, -0.017258946962417455, -0.19300929670585312, 0.20269205138179791, -0.055883370903337615, 0.086303837918737969, -0.085222388935180041, 0.050389052569268573, -0.083604666565517807, -0.031365407580474396, -0.041736210462835419, -0.037878021632118522, -0.078048100554527336, 0.084276511919288824, 0.065610146043592013, -0.10554823127210605, -0.035637792619659311, 0.091302805573749674, -0.023850899677633569],
                             [-0.18704456089245164, 0.16366917243258847, -0.026386171187766826, -0.020680405434586675, 0.13167780970271958, 0.16548150104345485, -0.13472374921039357, -0.069531532746548788, -0.019432927646295627, 0.18753173161298059, 0.11087034486520514, 0.020682262068768296, 0.18637952898286136, 0.32070774039097893, 0.048923876305343846, -0.13142392953255083, -0.093355703096344569, 0.053686646993164125, -0.043985552669583386, 0.094829378473452353, 0.14856202214232092, -0.095586276225813102, -0.027474163889946151, 0.17332237674433001, -0.23403864094529567, -0.29023414522587643, 0.11369287934955633, -0.2440337307273853, 0.29490487115791902, 0.052747199603526473, -0.019105331781775214, 0.060307634916253329, -0.021483684079073983, 0.086609891641299508, 0.030079542083095698, -0.17988150905524861, -0.078301637181348305, -0.010067761917431079, -0.007514677553826365, 0.060082631932226467, 0.0072265499525995328, 0.037121973180743395, -0.029513045887572725, -0.19347332637661596, 0.068746726753786611, -0.016632888417467639, 0.015020398074136996, -0.30487073470342857, 0.28973141565755917, -0.033568529194945081],
                             [0.038716741617047003, -0.18382074446528229, 0.24497766145954972, -0.203740377367575, 0.14841240725877886, -0.069743856947936542, -0.066228275473895537, -0.15025225542154236, 0.29200952831366978, 0.28903063806051554, 0.021621706302832451, 0.022960233320572006, 0.022272499880861718, 0.048408037215184628, -0.063431528086490607, -0.13939051942323827, -0.10176941739503674, 0.0060669152497672876, 0.2093118779278956, -0.03049113368457744, -0.19956988976979242, 0.020564289605203689, 0.0018560714743464702, -0.079646414995688183, 0.14807268703100754, -0.079541921807422186, 0.16014090511357468, 0.16131183835896554, -0.18625283809856513, 0.25690739698557952, -0.11048162672842768, 0.077702886026339318, -0.30065228396261839, -0.069518392682201752, -0.079996025691760411, -0.076464248567130105, -0.025749903073867687, 0.082391881346454643, 0.079569766232710518, -0.015355937442226221, 0.13001908928839592, -0.32113695471926018, -0.11235263098635163, 0.07005310099043803, 0.11440581540933606, 0.085229619285856137, 0.085978683456253494, -0.11630190963011645, 0.013230999087963671, -0.11023191807433391],
                             [-0.30249668817295122, 0.24184106411750758, 0.052037235764047798, -0.2322725263389171, -0.02493278131502711, -0.071678974988692593, -0.072145195134581439, 0.0037267423420328225, -0.1009460279187465, 0.036521757732044621, -0.0079369177066554598, -0.044316557405329068, -0.16884551729479214, 0.020844270371151611, -0.10054337160513555, -0.16506131546897485, -0.1420951696525096, -0.0672223957450232, -0.11178461117040685, 0.024390973990651852, -0.086220565002645022, 0.17897969497473307, -0.068941842846622164, -0.023657412374974214, -0.11988963965679178, -0.089445787471329294, -0.0057794983086774587, -0.032375114408388188, -0.16778182559429275, -0.18334860665285685, -0.080123125965843423, 0.1144823049603669, 0.24253236393848207, -0.0115868491595857, 0.12583008628708098, 0.35628696839555563, -0.02812838429287166, -0.047342174642864665, -0.047942124959576143, -0.097052226923911356, -0.21305066636166295, -0.18097792734478546, -0.33115836431229884, 0.1914542527643763, 0.075042340011953368, -0.020895455797303501, 0.19286335402924604, -0.10208993840163995, -0.064231583576958892, 0.12820758480173283],
                             [0.050965609330614531, -0.07424375896887532, 0.068313850588885242, -0.13168462976946291, -0.064465662170951732, -0.092660710676358102, 0.23107283527929573, -0.15929227067639232, -0.0075493568458949245, 0.024389469234434361, 0.015375777536006423, 0.062157319617809924, 0.13437699172810416, 0.19601067560351873, 0.027412308819046757, -0.10206839110244172, -0.26313569491327676, 0.017820039514956969, -0.15340957185691748, -0.10303682997141926, -0.22274333682760483, -0.23167090235302867, 0.064333137692284034, -0.02623259543687417, 0.16115067674451192, -0.052902704188112257, -0.22056399430370563, 0.14399318338606062, 0.20829348921705021, -0.38578646655171345, 0.22612094035866567, -0.14609661612316635, 0.017658427219053332, -0.13855404057958814, 0.095485371161764754, -0.072394049638469349, -0.08070053446006363, -0.033594599457418238, -0.17628172991815227, -0.04824885659051719, 0.11122310121288118, 0.003173349355264666, -0.14721886108437876, 0.13023348544913424, 0.070574825159326268, 0.049363480721538532, -0.072316022793274898, 0.18706320379901495, 0.2305855603423197, -0.06762140546018286],
                             [0.14644212116061328, -0.0086544039729720794, 0.070582565568399772, 0.068967575141326676, -0.030158626549449518, -0.090336139595578721, -0.1929390084044979, 0.020742863441464872, -0.18516289403538835, 0.2565993383795474, 0.18673996101202792, 0.12788306193490537, -0.11884376137519312, -0.047961233368340767, -0.21663726873401026, -0.14755505514852607, 0.0040231847622324516, 0.1171803193392653, 0.020184856536227636, -0.20272456990789778, 0.11822147782202143, 0.13720409264662461, 0.078263342822670709, 0.22190456892737886, -0.27176081189216822, 0.01245972006268955, -0.048788300409394407, 0.17000635022373928, 0.034917768930241386, -0.097745551854460933, -0.20159190319270515, -0.18690047126256198, -0.13441177360339587, -0.36969499122469895, 0.0601910785021589, 0.10624682639699998, 0.053106324867617176, -0.16086275653431711, 0.014848558056646692, -0.13189385739143894, -0.0171304688383337, 0.10474429238998373, 0.11598922210108172, -0.15025501316701828, -0.0028207196327156557, 0.27397462275959916, -0.0098076399635808383, 0.1054366819160211, 0.023802123432581201, -0.019131912871986186],
                             [0.013284322344807083, 0.29316877856120171, 0.035200969891431191, 0.023286532430294181, 0.051556631987651362, 0.17621238488725366, -0.059467436614965792, 0.20123249487490946, 0.00019054302451892166, -0.051594175634003925, 0.0041386795244371171, 0.1441082906436551, 0.25672127745277989, 0.14458699692377097, 0.10112706559423963, -0.22586781114114632, 0.020066737555659433, 0.06541108020300096, -0.070971772427203511, 0.016115003602820518, -0.1719661220286556, 0.15651398402011166, -0.062833520618463173, -0.1669795006690396, -0.070630209446968545, 0.0052800499896935998, -0.027032560312416524, 0.059334208630580705, -0.16753613906104545, 0.25986345468804128, 0.12849767321432137, 0.078543759725577297, -0.044455744208728665, 0.15099659946416902, -0.091537033817217089, 0.023583191538361886, 0.055939494387851091, -0.0039802901858177128, -0.028495635024022196, -0.17402682642741318, 0.13346246637806999, 0.25479754239644808, -0.040333899567998252, 0.049106673670651094, -0.082414946054610638, 0.25105881410364816, 0.20796882005517348, 0.39738625323596793, 0.11704464907806213, -0.0039472281668505131],
                             [0.077824329114478508, 0.28897860289721772, 0.28075768479019264, 0.19608586455591015, -0.042428529904120701, 0.024566679597187124, 0.13105278378750126, 0.09901002458193274, 0.14792664232721686, -0.18683223840886704, -0.019641706473026922, 0.052832402249543768, 0.077744407266792159, 0.073682056394431109, -0.021697870602541178, 0.025443285474935712, 0.19444287323084333, -0.0092767496473406177, 0.0059457957975873332, 0.029248686975714817, 0.014253344232834461, -0.025788411753660975, -0.073448791423952692, -0.10361396978731592, -0.08048524397135759, 0.10224297425163434, 0.043326519510476183, 0.14682269326396064, -0.016606816044309684, -0.3168834358912499, 0.049838666524144828, 0.16461195218757249, -0.38331688619842241, -0.1543771419396997, 0.14722263539802127, 0.17854932198205095, -7.8316027668502906e-05, 0.21853715297622275, 0.078184127609733381, 0.071570910348920241, 0.12179949656905847, -0.012425374510736395, -0.074312707882086673, -0.16563205408725906, -0.028682760938774646, -0.034657421672987139, -0.023207510447341623, -0.25210436032008376, 0.075299735457683065, 0.24850224404964036],
                             [-0.14145371863218523, 0.0066383622153342089, 0.15417604020650263, 0.06524247490358584, 0.23809933549651804, -0.1277184051871075, -0.036077668855230713, 0.25218757538826747, 0.021167167782063862, -0.044048733199518429, -0.038903724001636858, -0.1078340157606105, -0.0014472494598433416, 0.062352760655496213, -0.21330196480359787, -0.0027675827963246952, 0.061847843518595409, 0.036490703408219388, -0.10176306863651675, 0.10231334163985484, 0.13445227224096939, -0.051907189112018103, 0.092548848610363915, -0.016904695623938214, 0.10515998105200068, 0.12935348454074017, 0.0056132909877038275, -0.34924837398741637, -0.15013370744888063, 0.062339038316153381, -0.1167409530287376, -0.12756882283740256, -0.16069607478894252, -0.094960650378340047, 0.11587526346882049, 0.035563554594653671, 0.22823207584880309, -0.030010808286258638, -0.47506668229570725, 0.036626128695339405, 0.1254403498102806, 0.021403065103615386, 0.048294160958744878, 0.2545064219276077, 0.11879881840763319, -0.039995377381827422, -0.15632688712733922, 0.019530082942107774, 0.14860670103843718, -0.10905951315439065],
                             [-0.018741949847085004, -0.046833375497037061, -0.0052401188733346392, -0.037617145146177061, -0.14229575920359774, -0.15586344417603509, -0.13032239530623571, 0.10176481783579756, -0.089939849191818008, 0.012723753767813621, -0.13425538590729208, -0.07279458834104155, -0.12358166073318134, -0.12134500209290916, -0.15797288125771133, -0.04135798783825733, 0.10833284893016661, -0.26829367571660484, -0.11381010694268251, -0.22147495962963604, -0.22641036226366221, -0.23484683429283471, 0.10795494680648154, 0.055875219344849444, 0.12279892013015141, -0.2734358427007279, -0.13148556989617613, -0.097008612826293125, 0.039276563874016769, 0.18847386738422092, -0.061616329729540481, 0.035411489499792753, 0.063458573447613853, 0.088159526795031071, -0.052525076858702155, 0.22839670969850326, -0.13419209571251223, 0.21470217281914725, 0.03003024539215304, 0.16380457424251954, 0.30114416791720849, 0.22946082464973663, 0.031877238964973235, -0.087006586750545373, 0.032929287689672494, 0.21761607878613226, 0.0096261227572278663, -0.13374292868456295, 0.10968718457447911, 0.14621904399491062],
                             [-0.05891096721957545, 0.094426821092259222, -0.073932451229852772, -0.059306928488945886, 0.19961165994243119, -0.17116888431594743, 0.015681560449656989, 0.036226337791330915, 0.076525828499140414, -0.07413329604364291, 0.0044689973272358536, -0.081273073432816062, -0.093767298321533424, -0.078199600512469325, -0.013717648666870856, 0.28511641192990328, -0.016933630939053063, 0.035300915734443376, -0.0083537095397305753, 0.36020036779159115, -0.011100566077426885, 0.038319102617096007, 0.069935739108774195, 0.11085963710302577, -0.15780353848803369, 0.029513227858413683, -0.24115038338026537, 0.060302689531463553, 0.13256620338544683, -0.007767739569865633, 0.098138142344065121, 0.039597510758139158, -0.019170297045365284, 0.015358067812990397, -0.1860339666817423, -0.1767458515571825, -0.12207508423593208, 0.054525430008356572, -0.049687125918037811, -0.3624339522626368, 0.16043209737700673, -0.094987089387092188, -0.057517464239092271, 0.074878626738443213, 0.019457581588618596, 0.44948113779077387, -0.08216485685463068, -0.15566199152328303, -0.12932244442125646, 0.12288404273391668],
                             [0.084165934012086926, 0.095363961670562866, -0.10331339523289171, -0.26247512027033632, -0.093636470748402756, -0.10755252320677955, 0.031863567329106821, -0.087906654868923143, -0.14152098330272092, -0.0065516183630032667, 0.067399716688170741, -0.063249448368863204, 0.2166839325850779, -0.24504461613957979, 0.065511209025600606, -0.10328587943744422, 0.10905507825820929, 0.13128381796236108, -0.10968031427158421, 0.08453393353138966, 0.18481183309052129, -0.087825073166525852, -0.2145918717904183, 0.30941842168506994, 0.37380628877284222, 0.11802353635233645, 0.19358441044843661, -0.013016755661775384, -0.033567995846031082, 0.088298184219555598, 0.14395668184621635, 0.039537325574543078, 0.017568417984489111, -0.14836209790409036, 0.041632024516081015, -0.0022118661345137112, 0.085805435973651298, 0.1953402400557209, -0.20109102989803093, -0.065428067106067439, -0.074618228914123855, -0.085565452280129808, -0.00077110897874730613, -0.22661809744028713, 0.10049476894961661, 0.13311255876595005, 0.21495188960858608, 0.0061816533354626243, 0.040806047640938731, 0.12592896018993402],
                             [0.10702252118138698, 0.064739430270012721, 0.10142235924352414, 0.00091321154877662932, -0.26522337889625153, -0.25891952140825325, -0.32803661672868967, 0.13948949957941953, 0.035904117572354871, -0.1491706469564302, -0.050493652047902481, 0.039370951371121794, 0.051079270241516844, 0.079272241219825193, -0.096078453918341564, -0.0034489678343065568, 0.031290760569784415, -0.12804599485134416, -0.1277297409252923, -0.049226820387836136, 0.065116487370188991, -0.023062285955734643, -0.19601713445835076, -0.0075642363229873628, 0.12769968427423245, 0.027482114937021171, 0.20199897253633875, 0.12745414273043648, 0.064593822716198429, -0.09415875718610868, -0.12421255225134499, 0.066558611520872182, -0.064717985659050944, 0.23107822698537081, 0.1339938546264437, -0.37273441647462813, -0.10616358658578115, -0.33755037020144707, 0.010110959135393149, -0.056304166382070059, 0.013528769040621733, 0.1313153048829338, -0.15971241258697552, 0.065679026452730091, 0.21626477835629498, 0.044355434144774358, -0.032224952154422087, -0.050297083210812679, -0.17917481639699692, -0.053456616668992735],
                             [-0.1770363548693655, -0.084324791548216177, 0.19976912780376402, -0.017605726589881233, -0.062299838928280435, -0.017902117415433752, 0.23786168812533862, -0.058985942172893283, 0.20394777166169895, 0.11451927575456639, 0.086972228929960343, -0.084073397482591253, -0.21881822765277029, 0.10037479427080273, 0.066029643927792772, 0.053377485166202533, 0.032691954745171475, -0.043130992983505423, -0.17459862627080472, -0.16858099091744896, 0.068834869984572361, 0.12722226338402179, -0.24834843154976091, 0.18684639313636861, 0.06721202824732006, -0.17173184770812394, -0.16877640627361631, 0.10475974693371964, -0.034571928105834343, 0.071299926648958387, -0.014864697044113109, -0.029057986380870131, -0.21140987194592545, 0.14384366134549872, -0.15975746885838504, -0.1042903356595891, 0.080132901149113658, 4.2263952880347413e-05, -0.10320548517841807, -0.15602685126055907, -0.26534436098247943, 0.25885270106429603, 0.22336657019105344, 0.11549739443250999, 0.023445022650486952, -0.11741665766265669, 0.063459355915381807, -0.00098362928722666517, 0.060024656286511553, 0.31079071180192253],
                             [0.25868776712634184, -0.0096203787562085565, -0.0082193504692068212, 0.017940849730550483, -0.057902982512536803, 0.11746052666808632, -0.058071207576138713, 0.039951759785015778, -0.051957444868637334, 0.17615930596895155, -0.094118533531532725, 0.19836583781513439, 0.32842425478255149, -0.078253315113765029, 0.099003394904667197, 0.22383172177721214, -0.1800959343021982, -0.072188192556542394, -0.30330449457366854, 0.10931804835353934, -0.13216262575135879, 0.065402667017879224, -0.035679624967796565, 0.0042451086946983969, -0.17723498255572814, 0.099188396340777127, -0.17929935270730174, 0.037683938956351908, -0.045598393294135391, 0.10429122742306959, -0.18657782261221684, -0.029688617948848008, 0.062207310824650891, -0.09954182146552111, -0.12393468253059843, 0.015099563759433127, 0.11259148941329143, -0.0076136527103354357, -0.03567432571060157, 0.23594277400523231, -0.02268966306671695, -0.087274605612316203, 0.061096279843196502, 0.12887831859065882, 0.38713564869878819, -0.088799328596276622, -0.0011241614491855386, -0.1026361474613104, -0.017358900440770059, 0.26541978269092659],
                             [0.079426563146382648, 0.12897355416536593, -0.12656426526973047, 0.091960059981257572, 0.014183921765512099, 0.0231214669341906, 0.1393285337749392, 0.046780933654973392, 0.1784355026905548, 0.0049250701045476545, 0.23168857976332247, -0.20289299541822214, 0.076221148952696244, 0.14037549950529229, -0.28466188044732471, -0.022503727559283732, -0.18928587526675769, -0.061105255486830642, 0.0253546555978066, 0.13509426821502535, -0.029346265940099828, 0.13737638975727065, -0.44686070296322067, -0.040865225983540955, 0.17299671396035332, 0.071276292311541992, -0.035284680468531858, 0.095054122286474654, 0.05287222991876641, 0.036129975211588922, -0.23153403667294731, -0.13615437713847908, 0.21893365475823379, -0.054222004891493418, -0.11690267878494377, 0.19759653438338134, -0.11063061981687994, 0.16118829183069033, 0.068057709675825459, -0.026560496246129446, 0.075047917656750673, 0.14432461669611119, 0.026899782176162894, -0.10875438075671798, 0.081744397696582372, -0.018765129702445215, -0.21076190871155262, -0.042188206532927597, -0.013326296309138674, -0.23629961981272526],
                             [-0.12815241693304014, -0.035568968597838299, -0.081316041440401263, -0.0031519449627554017, 0.077493975695739403, 0.0052148132673369881, 0.0063925284515472412, -0.1347633517741241, -0.10033911657170469, -0.053314054078277225, 0.13327206232914132, 0.078205762911763635, -0.081267679765131565, 0.0069732033364584001, 0.18090783907936583, 0.18480076940998691, -0.17160209437200469, 0.3088364284326155, -0.19000239571390007, -0.25134070944733466, 0.17280471203025075, 0.04552935679429513, 0.022809549564952823, 0.070531524954869196, 0.049322875883113015, 0.18280057123496027, -0.16205541946201982, -0.052954896217454833, -0.21444644058661677, 0.040605003239899205, -0.126337518495305, 0.043677550556674029, -0.24325245693488157, 0.1855346169638985, -0.076813007380689968, 0.13094271526794982, -0.27529035908519406, -0.019015265678333521, -0.043933763626399967, 0.08331377369793426, 0.24355485811542479, 0.08697812281575773, -0.32920109525371644, -0.20576354341631661, 0.077918616502009805, -0.076639065307259321, -0.024411582240257544, 0.015394957942959239, -0.088569787953866372, -0.096478887274035613],
                             [0.095099110064573306, -0.19897589954667361, -0.062192678224284148, 0.038840699334738313, -0.041564065770758531, -0.16287105590425435, -0.085611175485818619, 0.12957956727994915, -0.17658105081905565, 0.07270308300329037, 0.11623625970450763, 0.064962131467950116, 0.20114849008055669, 0.095470814651979694, 0.20271616776063059, -0.17599850403968223, -0.28689305990531694, 0.041733597869332575, 0.2593174931639653, 0.036715187438794879, -0.1214102196963479, 0.05915681902836515, -0.032291351446066867, 0.14305317104746951, 0.063693447780687792, 0.066172955309887871, -0.092987181599322066, -0.031849612065235067, -0.024600562986662761, -0.11295363502497062, 0.01118501124275482, 0.13403436294642115, -0.13167407250228694, 0.31124511647939895, 0.15319814212546026, 0.18367490614629992, 0.16542341349268466, 0.12848237368533441, -0.11787560446195175, -0.021482646261183114, -0.080735457307666639, 0.10623792157353945, 0.13251066972819195, 0.12101225495553028, -0.21822322408724076, 0.099336675563301641, -0.16002714526929815, -0.26770485694678436, -0.19963700683731181, 0.039468768726575156],
                             [0.031126720850427066, 0.00089223503511741853, -0.1148633505873048, 0.038836561482685342, -0.0013616315977809975, 0.10738286292770327, -0.15232782367079781, 0.2148867173752973, 0.088354418807002122, -0.13100172368656643, 0.22720284668966745, 0.27556557554944633, -0.24361155824414904, 0.031505181917902497, -0.050364501647841529, -0.091822534678593276, 0.066229158663023785, 0.071395964729306871, -0.16135398541579796, -0.006717235632471721, 0.047712423873883657, -0.07232368574033847, -0.056402623297164042, -0.0051871524012215417, 0.094664229539329722, -0.16951584624993749, -0.326980754715477, 0.069248468135799005, 0.0082571170398561718, -0.029152139899239048, 0.19742633914366031, -0.081836005399749612, -0.019151620328101242, 0.15251747491003673, 0.12256230290876445, 0.015943238992161865, 0.24677895188956778, 0.1266036551411292, 0.097308975465214165, -0.06268381966697037, 0.073475562022056587, -0.31205357767093855, 0.17263040481731295, -0.063194388982273947, 0.23892514859889358, -0.081949042805686143, 0.1836816389881735, -0.088923004390846924, -0.082175963149590969, -0.24351792131596856],
                             [0.15503849245530776, -0.16005449431207339, 0.0093116615387981629, 0.19075949176252271, 0.015560048595768353, -0.090358133468101842, 0.12622001600862753, 0.22200650459339086, -0.11778895464299244, -0.2656337946585956, 0.026642646505884129, -0.08164968989609285, 0.083721160973919281, -0.071805645059759143, -0.2105655785956887, -0.14887939018980526, -0.10201696993070658, 0.062011855170722156, 0.16559400839257196, -0.15261552284042845, 0.058453709127943225, 0.24524775538983123, 0.00068647840316501832, 0.18337301999710445, -0.12055569219382974, -0.13686765839628121, -0.068709728729288572, -0.1383976519593311, 0.13741361545525341, 0.084989948563075263, 0.11779803240734861, 0.24341857284029425, -0.087625721235145518, -0.062338860012266406, -0.081242722782078544, -0.10915807156904545, -0.3141099194768513, 0.19419037641610379, 0.0083951595853348215, 0.065814199007683663, -0.14768234885487588, -0.15217350012262756, -0.10642090788214457, 0.16195375069482199, 0.22189658369855864, -0.092773147036914347, 0.069535339639146154, 0.17219508539455597, 0.069014413446805992, 0.027573016627961012],
                             [0.16294275137636957, 0.0012143723253367847, -0.18770003943157068, 0.14414880442838096, 0.091884293251982455, -0.15299449592064643, 0.15149325064344413, -0.050505028639387328, -0.10517090679093792, 0.17775677281086516, 0.0093181357877925447, -0.044389906220073792, -0.25290614709534814, 0.054457240483734855, 0.28450798639841784, -0.15070873164120402, 0.14084493807812498, -0.1850499118267275, -0.15421828319551326, -0.092602006634173437, 0.1059912829912599, -0.19704442801974212, -0.16668113078072935, -0.020161165154276961, -0.23120741874856332, 0.074208035824589499, 0.16823976215150088, 0.10356052054720066, 0.079321497140790356, 0.10618572012273829, 0.046352490101888161, 0.31672555210617448, -0.0029999664142538749, -0.039927385355430972, -0.075070141907694871, 0.0752873157053459, 0.23351841097811687, 0.10413849819606054, -0.0065505147127910687, -0.089919734673959487, 0.050840432652411748, 8.0788312978740797e-05, -0.19948800620964249, 0.17328311368537055, 0.15700293804000945, 0.010640758880911557, -0.21934620791066101, 0.051842599023471499, 0.030349974175490943, -0.16361650531878519],
                             [-0.022016396759523112, -0.26419613342664339, 0.056353946205110583, -0.1274069013974935, -0.082853232918188149, 0.35926139116387401, -0.019035999078848672, -0.0091971412545440948, -0.20897429843659171, -0.24144701969917776, -0.083059847260900599, 0.01464010787179214, 0.13613070581437234, 0.11369542720049776, -0.042457591193219714, -0.0025789625424759901, 0.23550547993164242, -0.1434833122018071, 0.1211771143947047, -0.23771517896480393, 0.10274270335554422, 0.061833542920509181, -0.24804080246595492, -0.081022313983815777, 3.5440246074703352e-05, 0.02744421268997032, -0.12895388834855318, 0.028593125566388638, 0.041421134401896653, 0.0043874442720886848, -0.02213358702497948, -0.07665548734907647, 0.0017689938065050671, 0.0009952636120577191, -0.28238665502435095, 0.077889529164438226, 0.12200615451562669, -0.1776238992377748, -0.17167415733277555, -0.098203014575166697, -0.0002042487439176555, -0.22144768113554322, -0.17867100580034453, -0.015735833971887457, -0.072193809917612387, 0.20343612489324886, -0.13223496419243017, -0.21602193790295124, 0.11007537627332528, -0.011243313126656324],
                             [0.016637097013879238, 0.12047998902480535, -0.11928327597569853, 0.014400778941026468, 0.26156138882737151, 0.023627811173441614, 0.16289465677109999, -0.23253769434727711, 0.053601691711449621, -0.16066293291317033, 0.34303094296547187, 0.092503073383193815, 0.046725313387618081, -0.059313940623323819, -0.069080822115111851, 0.02103553691500357, 0.16141400994852564, 0.073318343582361806, -0.030942328889339982, -0.090724619827819736, -0.042198283921392188, 0.051284567069299708, -0.016690177147275179, -0.0024272427039446478, 0.12981528412463922, -0.15381554461162458, 0.043894619135604926, 0.046782750783309915, 0.050523064641375973, 0.132741046835996, 0.015407718568550114, 0.083145425422615146, 0.014113112049395889, 0.067914549174935585, 0.26866107688634866, 0.087696280042311364, -0.0063317757723359066, -0.31068471220942462, 0.065289300320375651, 0.35370235613529705, -0.054658910172236952, -0.059718358129445266, 0.065745155100560254, 0.22417742792318815, 0.031086650057266522, 0.30282219930843862, -0.19967437651303041, 0.007376876786949471, -0.032517682428513814, 0.18083999941844758],
                             [0.05877620054573364, 0.038881989560368563, -0.030248594961487855, 0.14175282385480506, 0.025636919442967962, -0.15452994248716584, 0.18655529727783812, -0.14372225857580845, -0.20506942509178044, 0.22281936997367349, -0.29497186267804021, -0.0091617818036261213, -0.044130427277186808, 0.15595132346239063, -0.13292949138235624, 0.24239055130308074, 0.085415699632762868, 0.039455257546995588, 0.12135227518908222, -0.028000028743541069, -0.23275989694252039, 0.25979035251805888, -0.092270870534702953, -0.13047609569113594, 0.13158192523753451, -0.010807014448213156, -0.11063130230135643, -0.23976739061524324, 0.057752363848345478, 0.042408172808993436, 0.12845102896147609, 0.11375244786634622, -0.074944822986979784, 0.091283638866825945, 0.20315137912018016, 0.039029418525521685, 0.15662290246909802, -0.16349616683392829, 0.026735458270257036, -0.12036037496342621, -0.090359390242295029, -0.017462011877210071, 0.002278904726024641, -0.33848566393264579, 0.23991920552717366, 0.070165392462728793, 0.055767990708591175, 0.0096064689683203596, 0.029615689905992504, -0.080155378855161774],
                             [0.0046501585168225879, 0.11463238040333515, -0.071603633513253356, 0.37522608536638596, 0.17047120065677671, 0.014024342909612925, -0.024934428866404897, 0.018331248541153894, -0.16997885948898356, 0.073670465485000558, -0.25884788886234977, -0.19857552361780678, 0.0056469327724997789, 0.12779226033308411, -0.18976915693256965, -0.042758791597784306, -0.23602259386200816, 0.084873595136368454, -0.012350561623654244, -0.074404753458046702, 0.16144706146098742, -0.19547996442185972, -0.014491938109587758, 0.11491891264078599, 0.11425474215098429, -0.064403981735393662, 0.084483938419835716, 0.25563467628491848, -0.10759135987365473, 0.048942496727686031, 0.056602179181386082, -0.28739424167297145, 0.0083102719491526759, 0.21901302064668149, -0.045781069534895948, -0.0341955161259693, 0.1504853113869932, 0.0062952153738321959, 0.13431510347687023, 0.022200392887531922, 0.036012876665705532, -0.24929198025554095, -0.12896951703068765, 0.016003580640216668, -0.090140323621020771, 0.025338485433543809, 0.002419133350241747, 0.067688669101831717, -0.0086297332243770869, 0.30611986181946105],
                             [0.057918977991680679, 0.0048687061536592507, -0.12455313589559337, 0.12543787087625721, 0.16054705958383186, -0.05813911477470831, -0.22837311104890803, -0.30762821391801753, -0.03948068144509511, -0.010668441733577201, 0.23292478406389935, 0.037663927708103999, 0.14304620561207165, -0.1811654341095062, -0.10466281486503858, 0.21325648120542531, 0.058177507694215987, -0.30832267951900705, 0.19321587737520229, 0.002267885308247342, -0.011758728688360707, -0.095503548214350906, -0.098802129578197284, -0.080487323839982625, -0.15443519845730674, -0.20825620088330682, 0.013844261329617783, 0.039905407465728376, -0.29318251125258565, -0.27009713659567663, -0.030295813056049441, 0.0063903946970764527, -0.052909859710518023, 0.20340396395734586, -0.020973832597454663, -0.031882993648493105, -0.027452827417273312, 0.14777166598507602, -0.26349396105890238, -0.10333923735085705, -0.043722185413452602, 0.0061304178051264889, 0.019205617392978255, -0.062238340674313906, 0.06657970212329016, -0.085478234585602261, 0.068999270023219053, 0.18432823760678202, 0.16497007180120321, -0.00043913694495972171],
                             [0.19420663826853285, -0.0090175503982522914, -0.027534085554764918, 0.099749968946890546, -0.16481361389765886, -0.013045546001135286, -0.010647364913844453, -0.43204275832398525, 0.013605736673039963, -0.12702800565553635, -0.1161369125519168, 0.053490110132386352, -0.045076135485475184, 0.23262452026563082, -0.097890487706686444, -0.17856614506357341, 0.19024580897677174, -0.043687489563408601, 0.076344801689780931, 0.36235068032717871, 0.11169893519243809, 0.042749751114940789, 0.1354634477391648, 0.32896907823253674, 0.072669527672922202, 0.096538563349884324, -0.19002065028230325, -0.021559374152633915, -0.05178270369558996, 0.018124820471263046, -0.11978934753530468, 0.045327827050002885, -0.035309446823398233, 0.074765916307966002, -0.081493371127047964, 0.1626205957577056, 0.0037082961263747855, -0.11612321494153542, 0.090561002216844474, 0.005065816457898018, 0.15641586717984624, 0.080787020180827104, -0.02250855640419715, 0.23420732816886769, 0.0051636219266999626, -0.099298982811036926, 0.21990631415704537, -0.011783993890358465, 0.10403728499573232, -0.056580705715614903]],
                            [[0.049041857665862477, -0.14022963693056023, 0.086020524155644498, -0.055964884290743588, 0.11237802963790477, -0.00051900449415535313, -0.017278186351499365, -0.17920578485313626, -0.14844181025479761, -0.068270030730338244, 0.18604767340884767, -0.15781579300874463, 0.091757063339834355, -0.098721360368020233, -0.20553148886151659, 0.038211545307705, -0.069194782024343968, -0.25633505235308385, -0.14618329047979919, 0.1070923388416905, -0.20569068247072228, -0.19582236255337931, -0.090913128265562623, 0.051248232343341429, -0.021410271546580786, -0.17473849244881107, 0.23658843709605604, 0.066869058460723704, -0.041919635366885394, -0.12325102580791666, -0.021308235728872707, -0.23983593964324329, 0.31842105976248686, -0.14438035793968637, 0.045668111925154291, 0.12405053975014634, 0.34800475773873107, 0.053680423586858622, 0.0081290676114629187, 0.11025830478298185, -0.078759589487364057, -0.049667872259742729, -0.014768147874584392, -0.13917787702914799, -0.0082356756844133606, 0.1657639428673737, -0.17325002887996754, 0.039643282633526226, -0.13333445685836368, -0.17871296883896226],
                             [0.12660229368806081, -0.10045287984984259, 0.054553706419707776, 0.17220541766042591, -0.37872393070329269, -0.040655196872141447, 0.008853246083710303, -0.11295819556289963, 0.24125316386071502, 0.16456764584504438, 0.044513287783055897, -0.056618555628237206, -0.022604649199234335, -0.0097542362936341408, -0.034667218616207342, 0.18248631844416194, -0.029674626581729376, -0.01311287038106918, 0.043583786393162904, 0.26667479047735182, 0.1421943884538896, -0.29170745144944493, -0.058697723983924012, 0.10468193464847152, -0.12914123068203692, -0.050848932534932487, -0.0636583564422607, -0.22100795452354077, -0.007098006539923085, -0.058659486717638661, -0.077932337975228652, -0.17988303954173149, 0.062612367357154752, 0.12783038123439544, -0.17716375441865048, -0.052836166112059456, 0.053670586453227399, 0.065214016120651683, 0.059929688729485085, -0.098236558364394891, -0.038013532220748165, 0.36150517018220357, -0.045754702049729909, -0.025259770397794257, 0.069033341510644705, 0.037001910810775807, -0.029877917746207631, -0.20734544630100446, 0.19579083860792343, 0.22770213851821378],
                             [-0.047707711221126839, 0.13559162019968249, 0.10999611945888563, -0.055591985721532511, -0.052212845799541552, -0.37289961841386327, 0.052840723106936952, -0.1129081515219172, 0.00027831612894289561, 0.084050495872405942, 0.0050463498095850512, -0.081612821339190858, -0.062241477136577503, -0.038369739742853091, 0.068604489119058323, -0.14494495747166883, 0.29305625276542779, -0.0019166837139526275, 0.11764537830382417, -0.42849818855518534, 0.17373488829393904, -0.059789647213878215, -0.11825127903956238, 0.2121054671183869, -0.011104993871878719, -0.18762734040736151, -0.060970932036271422, -0.17569184696493642, 0.18078314413437374, -0.11689620311582899, 0.11277005096459408, -0.10219451735829246, -0.10240557792654632, -0.014513848091601786, 0.23742651188429328, -0.053980617940361068, 0.062637816982270278, 0.22957450672680466, -0.062250769164778938, 0.031106894458040883, 0.020122396911803824, 0.036075244986730461, -0.050127030649838027, -0.20958934587496686, 0.094938092298901572, -0.12480802827453678, -0.10025859960904202, -0.054044593209224723, -0.16942614772445461, -0.025683647071097822],
                             [-0.012717302628914854, 0.10352441773500246, -0.035080996848096763, 0.26391848760873154, 0.088821671240971303, 0.11160356594767346, -0.074420234775312205, -0.085842975795084583, -0.13982909827507137, 0.04058316728764113, 0.0184812500669123, -0.35857854088527513, 0.095779944407792347, -0.033567194818867815, -0.019707854527934238, 0.13406019642226533, -0.19959412509485625, -0.014936929017470922, 0.00059979507146230122, 0.018624867337848957, 0.13077658631527048, -0.016298488965893254, -0.23348124134825657, 0.0030647577753201522, 0.29041429950214986, 0.34304938125444123, -0.049917809917767127, -0.20652820110591835, 0.085747431634000087, 0.018166200630749786, 0.048715249308766417, 0.024748941327981864, 0.0077876482610995798, -0.083299251888352591, -0.065629833597755205, -0.2099061002999987, -0.078808282756675369, 0.04056029077284376, -0.10806590033722212, 0.17959538316764226, 0.27008873487638979, 0.12486327122578381, 0.21541627656649867, -0.088759718636623477, 0.043734919194224134, -0.12612966936908368, -0.029839106621218168, 0.010697196306733133, -0.023084133118900212, -0.25832561442596091],
                             [0.22693457788060564, -0.0066873068257695609, -0.036998750016249263, -0.098815195353773685, -0.060817498299968367, -0.24494131189111609, -0.26817952811417817, -0.06384445863874437, 0.082910143828234015, 0.057842420605033786, 0.031704674228964287, 0.13861828683354752, 0.28173166092635232, 0.11626551629201451, -0.068857538352036993, -0.12010688357811278, 0.11314484410142762, -0.051208174387832095, 0.18251148842566053, -0.040685571248217527, 0.27612637400271667, 0.10329702435602428, -0.08034929408079533, -0.17898586052596832, -0.0096325624146914764, 0.11272977318443661, 0.037171573969216727, 0.00074696718048181978, -0.2251702422779347, -0.14492452092699062, -0.12385731352952258, 0.13409976285631425, 0.073007108110960742, -0.053037838467695282, -0.036199330016988648, 0.16853634733365569, 0.17698838072590364, -0.10059285723468181, -0.061499493964883453, -0.16857348485211199, 0.11172962576564523, 0.12894342004442244, 0.39883062194264252, 0.023512486794482128, -0.11611784112087044, 0.11456494509226317, 0.011274303894354562, 0.14832624581459489, -0.10542641034719, -0.0066480563396023578],
                             [-0.09472572551439376, -0.04498032607422172, -0.14599727106595742, 0.2934623225258195, -0.14196510988504923, 0.14256474403849281, -0.16035542472092917, -0.11656854433299671, -0.21844965251319109, -0.032501576065076164, 0.063090415999669872, 0.039895834661861404, -0.013349365905319852, -0.087732669981860592, 0.24895353308222204, 0.13637431463545441, 0.0097630582541267975, -0.2147813138609358, 0.12339037540709863, -0.23785443886308558, 0.015988105819830938, -0.11861388177023459, 0.14229359115267426, 0.031993651425900889, 0.13460880761811211, -0.26849940068720712, -0.24321334380635737, 0.18553343101561356, 0.047943438393640715, 0.19752937371332313, -0.095274810512237282, 0.21648145780408498, -0.032738398669304974, -0.031294135943472891, -0.13018791799049781, 0.14671138925491375, 0.017994816329981934, 0.076347905656658277, 0.15248142083628327, 0.0088640676412472599, -0.24329842576288863, 0.10915898443648595, 0.21157921835382368, -0.031909211822068961, 0.11194001618937724, 0.10907965775106943, -0.049670800478512939, 0.083401252416765506, -0.046534711741507181, -0.037463667349651945],
                             [0.035547930126487243, -0.27664645854189135, -0.22385898250928157, 0.26733885797821427, -0.0065685839746206049, -0.0040199962127490515, 0.0088301501657616858, -0.01208935462686728, -0.20730919061582159, 0.017145671184533858, 0.31798382803640701, 0.02462229442649326, 0.075682026392771828, 0.036475358619646465, -0.021235946789109051, -0.19685258153117802, -0.031683823447368538, -0.032947821162182388, 0.056527712692265898, -0.0014891523658976001, -0.010346197782575499, -0.023069804129916445, 0.011538078682815653, 0.22392262726350876, -0.33745097716995104, 0.11581207205573828, -0.029598006276453242, 0.20722989986717175, 0.21343404016759043, -0.16136677110740852, 0.083088382584140141, 0.014419994212463875, -0.14545557478032201, 0.1080474119877852, 0.15293191665014488, 0.029410992426676136, -0.071221654933562958, -0.16519903659425098, 0.049268895017011406, -0.17495633150524539, 0.33143230211530483, -0.041965774548490722, -0.02267349728669929, 0.12524540309843679, -0.0039884450171644098, 0.025483138552219117, -0.14542180398494745, -0.16189239383446569, 0.012804735622905945, -0.067778825563961323],
                             [-0.13515214002195408, 0.081563221111273371, -0.21612974947878799, -0.070694729993720729, 0.043629257798682784, -0.042585440203395608, -0.007837944719176395, -0.010660763786520375, -0.16559571497245476, 0.02900138667751281, 0.15725956327178889, 0.35494701731314898, 0.11344797588870603, -0.31391410790010577, -0.066463205229434247, -0.065144327636704039, 0.11240242629505728, 0.20236368993442036, -0.059145859968803366, 0.05131226909260124, 0.10543533345711131, 0.118533953287209, -0.17846095119087318, 0.24886467721983557, 0.1601510222179521, 0.21904117432181891, -0.030777783328380801, 0.053759246848440322, -0.15217052255012883, 0.22128651356045662, 0.011641105529213656, 0.005825624121441368, 0.24896115928546317, 0.18561870850639603, 0.018348228167525866, -0.1089092363313917, 0.19287006736763837, 0.082202789289255257, 0.072843236866074607, 0.0080316921934761674, -0.11194426619113741, 0.14440882393441204, -0.13264057954389077, 0.029561643892758772, 0.12621962958617713, 0.072655546646842636, 0.12954143757297787, -0.20018934807007555, -0.022581855569601628, -0.060093381457529418],
                             [0.021966847914908518, 0.12451452417478417, 0.10309020732417329, 0.14190519429259393, 0.015709785646864073, 0.078907539040496188, 0.042360811061672651, -0.39672165746481464, 0.080766883322962363, -0.10943670033344993, -0.19593334610119767, 0.1183473717654359, 0.22336648689514577, -0.036132108561468382, 0.21219999820650101, 0.044387649204236643, -0.039045715379017701, 0.2251778974252687, 0.056963948537156091, 0.10951843113403674, 0.24072733429062643, -0.20664606103189778, 0.047965585337512093, 0.10137044643066671, 0.0083703652707605748, -0.032886715176844356, 0.39610521366450274, 0.12440643052234472, 0.10578314881641049, 0.027648010053316959, 0.017802857256277962, -0.036143978159472318, -0.05523622921140485, -0.032894745651820816, -0.015218592366981436, -0.13942912257345128, -0.053132004596821679, -0.024377181237928654, 0.0057734859640333888, -0.0023420311107530487, -0.015221388222187703, -0.27510851203969749, 0.056701059710912043, 0.20270555808178645, 0.074957124383060014, 0.10134940021867173, -0.016054512815710169, -0.053354826176339881, -0.27609412069944911, 0.08939771343775306],
                             [-0.34203140118982572, 0.053497546248207253, -0.24252629667118991, -0.061825189344736943, -0.084277206481274264, -0.18472699791414995, -0.091712240772407097, 0.076359992748693956, -0.005026705671497057, 0.045683737764857173, -0.18598970000951784, -0.16356090948662677, 0.19303767540730213, 0.077331399502855308, 0.27430820204871958, 0.18756824825901688, 0.033138265673541584, -0.057441112861486565, 0.20315068581624829, 0.035584394693572302, -0.21980478193098257, 0.098952629265693259, 0.0493631162005767, -0.14789044807048823, -0.060350989440629957, 0.10889291427650635, 0.11684943029049509, 0.20303313390158778, -0.013072791069662271, -0.16321780638400496, 0.10983542392886153, -0.07218605250259906, 0.024871562029480744, -0.015465373358348819, -0.047074390438592684, -0.30539987674377267, 0.27025431705088138, 0.14298512470216815, 0.04270968710168823, -0.14519823359700906, 0.076874102086376392, 0.033322457558507837, -0.12214936743990643, 0.013764665427499299, 0.1223424203428211, 0.05907908668100316, -0.11836387032452067, 0.097135156625674457, 0.15035522653299463, 0.041640314363050067],
                             [-0.14197091644498935, -0.099860487514923379, -0.062211555259867928, -0.21985562755344185, 0.0154773379794978, 0.15039392213223804, -0.11597433947253902, -0.27094055318550964, 0.080155610487254073, 0.14929026758832462, -0.00089785959882157911, -0.19426471612682245, -0.14200020834980287, -0.10937559618695353, 0.14968034824451926, 0.043682956862537273, 0.20601899618207353, -0.28214923430207184, 0.010769690105975879, -0.12547198268369081, 0.098097491895292363, 0.076078960132510379, -0.099193199983693955, 0.059373492286482692, 0.065126112958713372, 0.1373832922978519, 0.20706770127052698, -0.20383354944449178, -0.094936170684739654, -0.045393297319526203, -0.066593093373337006, 0.21078000105268763, -0.13887764275511444, -0.045395811071809261, 0.017570098856383703, 0.20058389532929188, -0.0046084421601443716, -0.17929234611231434, -0.03696959565199235, 0.082465244723152878, 0.00047296163558957911, -0.069389822532251302, -0.21697734210496258, 0.23449509651039765, -0.024617394285734808, 0.21119468507131853, -0.01260931889999543, -0.22062181397003686, 0.21520803817471509, -0.037810118458371803],
                             [-0.012823553625526778, -0.18960639664395187, 0.165849517179465, -0.23550337343399033, 0.032768242618493794, 0.18442815203529994, -0.25746745173561769, -0.060205006184391459, 0.06472350062905767, 0.19210400111166528, 0.13374367579887667, 0.19075008062085169, 0.24639989676520788, 0.020444851535785753, -0.019974917185986856, -0.015022604866543228, -0.13232130162458369, -0.10378141526722301, -0.11977109046867655, -0.03006144026110158, -0.0086831436406226876, -0.058889199048868128, 0.24254546938345414, 0.0062165382358210335, 0.019386801071668798, 0.27452355296198094, -0.10175810933362746, -0.09190977505315287, 0.36018675905679892, -0.010317188206102584, 0.24959051385858574, 0.13106096113759327, -0.1484724093887517, -0.027807928332516659, -0.10624051631587129, -0.039153364390237033, 0.19635508213572067, 0.16620140078464962, -0.090678037036976161, 0.013595602296576676, -0.13410328794641929, -0.03924675138587487, -0.062306664622777973, -0.145683371849541, -0.027878356372040562, -0.102917397393023, 0.02131511398790947, 0.0021754015443823708, -0.098363016555915866, 0.18067782288328024],
                             [-0.20511311592105411, 0.16074023279050312, -0.18509410310138344, 0.063072558145673391, 0.16872764328576301, -0.099906668639468177, -0.19117085800583736, 0.032210027750155475, 0.090964168068645365, -0.11385107252131278, -0.047243004169692106, 0.061628258312762224, -0.084081838096379355, 0.23885908545374718, -0.19239731624591042, 0.22723149988619543, -0.13798542528949487, 0.0065971590874925653, 0.22961773573005087, 0.048262985749471889, 0.013575903273518626, -0.033807419259477646, -0.12551652887675657, 0.15070028286197049, 0.10478089786077686, -0.0041446354351564975, -0.098703448255036172, -0.16168683291880614, 0.32807269932076627, -0.11003830615600603, -0.026709296960925177, -0.042411968280195937, 0.11766867059654638, 0.11594301179878057, 0.0038990886971503988, 0.30248000181389822, 0.01572269097237421, -0.16519466569529853, 0.11217959043756333, 0.013241065940628596, 0.046837434856171208, -0.035169712513832121, -0.2197252023742397, 0.0083487443074040987, -0.015986625966566824, 0.17686087084577604, 0.17261929979861554, 0.15182561105317008, -0.20175126181341971, 0.13694686779571968],
                             [-0.010704670989368602, -0.0097588256777638958, 0.039201162380717414, -0.085699410033937135, -0.018768645998463444, -0.12131102840182884, 0.1762757667899843, 0.064447551035682477, -0.25182928037363062, 0.20922742607935299, -0.18747259957013887, 0.3365233620979714, -0.13053321792816372, -0.034404907996756898, 0.11434897798262277, 0.24436228128164134, 0.021414155561745279, 0.006669438906373659, -0.12782314006917597, -0.048929191458384175, -0.042680199296905162, -0.29736136302310351, -0.28673686405145182, -0.11674959917969381, -0.031825989560061115, 0.12256532833832107, 0.078855734492228685, 0.060402682470394889, 0.14260182255586354, -0.10999833742305816, 0.13097494342200608, -0.071643389710623145, -0.21727852935259037, 0.12695595141090724, -0.043940991834116379, 0.037680219278891078, 0.049121623845951277, -0.30865357699808127, -0.028500699379810639, 0.061246546995033957, -0.1417455607543299, 0.12413470224977494, 0.1360897286026472, -0.01568604812239096, -0.16505768954912034, 0.022870951775760678, -0.064398921401563114, 0.12120264404279413, 0.058803060090239653, -0.18657192168905398],
                             [0.10834041830858203, -0.055224977705423901, 0.010939378138108628, 0.15497426060202346, -0.056953479936363703, 0.067979439554422802, -0.19851538670291885, -0.11680206538107719, -0.057292556120488662, 0.025430001602035335, -0.10034508891564414, 0.059370357689312023, -0.14208318695297112, -0.24262204952619057, -0.019684833997653462, -0.20467613097555606, -0.086544564133000365, 0.074842058939118244, 0.070133263586409145, 0.087877043628733137, -0.030476607865304997, 0.035277910769496587, -0.28292898928181714, -0.2271397659057787, 0.036698951454357039, -0.15631448995345831, -0.11011831851090614, -0.17097747372580976, -0.056086336682582373, -0.081338814865200837, 0.20962595692669836, 0.13469861288542032, -0.067611271993375008, -0.25860979080090246, 0.030824370270765712, -0.21766005504959296, 0.12000136239652463, -0.10895577041077679, 0.3926430095039104, -0.22380924200230767, -0.0034549359128293136, -0.11375802058859982, -0.23962576909138744, -0.086562307698717617, -0.16215175682584812, -0.022281967764962638, 0.027086525958114654, 0.054896493331949424, -0.061881325719014377, 0.01510921756834719],
                             [0.30164746677475562, -0.051021481331355152, -0.10410336978980475, 0.016998626953099887, 0.15250941149955285, 0.14707951185727466, 0.25606136123800843, 0.011024054175964786, 0.021942114245180302, 0.14000059461087141, -0.11790912946422245, 0.075598852178554166, 0.031542022628454236, 0.16305047269677575, 0.25961061760852311, -0.21485036291967932, 0.077679761444278142, 0.061093662429545989, -0.031224808991213226, -0.089677727174724595, -0.19885441726002456, -0.016848680124687931, -0.10788259225959676, 0.26334100423896817, 0.1793816498495952, 0.081654777633121761, -0.1861820144193651, -0.026409621147561898, -0.024073574899949986, -0.21255346569042097, -0.027656702477755157, -0.049041962953043874, 0.13222492401535194, -0.30720355678479044, -0.26155961464144084, 0.044112677587737806, 0.020311242917761718, -0.0022375755496597386, -0.10057529586519835, -0.03497512108536991, 0.020926212778038855, 0.12367101589219873, -0.13238995654409155, 0.13981588821631602, 0.1730031200229897, 0.11000217471030954, -0.083866504429076144, 0.16160052030240318, -0.065664817708114859, 0.12188549203248454],
                             [-0.28545469222360131, -0.24084333134604785, 0.1278216985350428, 0.12763177678502868, 0.082088410568682033, -0.06697585779043673, -0.13755279748180804, 0.10477210237965437, 0.10789577324121156, -0.18985210803311511, -0.070628051388759314, -0.095366771390148763, -0.23582794313128019, -0.21271355371853279, -0.053390673361962182, -0.18810549130776952, -0.019590008877841975, 0.055271816175222421, -0.19307304923985708, -0.28250368330380743, 0.026656946948645663, -0.14548414904294832, 0.02780213701125955, 0.15304136409653557, 0.082830628955388105, 0.10417903621078392, 0.10829563094233423, 0.065609373871988785, -0.0099625181424182578, 0.055810111817837217, -0.11434204472318371, -0.18330211033015015, -0.046574077536393761, -0.044471447203334347, -0.17988414921343726, -0.11113482032404699, 0.19463969233589626, -0.17118058793400398, -0.092739287172409771, -0.17730392144152904, 0.12076762469128237, 0.03382508233053514, 0.18386229970957385, 0.010398357928503696, -0.031025222219613718, 0.048910900869057992, 0.19727540429199925, 0.14304303330047885, 0.074014025175800635, 0.24845603012052372],
                             [-0.10680113242943078, 0.054939343206821659, -0.015124579348934556, 0.071569261165360346, -0.027202424191254921, 0.021343818268039171, 0.14283456514500123, -0.065524119556303148, -0.10723102650376129, 0.17338986418828203, 0.08850617117424496, 0.015134316006009825, -0.025836569446509628, -0.061575722712610151, -0.093806960815228699, 0.067534965868599389, 0.020930529091156738, 0.072516582469602922, -0.042061827608126663, 0.049483473602596389, -0.12124952056240536, 0.25676969928007498, 0.13887642581845186, 0.039968084506928236, -0.11780932616202303, -0.24161246137141043, 0.3322285362239627, -0.21116354855116981, -0.063025062047021241, -0.020441746116680516, 0.13161290310314777, 0.1126033655597853, -0.20071312689882148, 0.025963217904137536, -0.36153639226740675, 0.1830799109383226, 0.1392050205358645, -0.025296760120395015, -0.00054620344753274414, -0.089870576410104805, 0.18165613291835084, 0.18884633901448517, 0.012463581687798271, 0.017246194972084714, 0.21704381699427003, -0.21563348967061677, 0.21424200881509847, 0.11447137466861229, -0.21412911154189979, -0.11396661169557261],
                             [-0.036310782118523004, -0.10331949562486464, 0.17252827606742285, 0.03974577250757682, -0.16556171231869141, -0.22003619363801319, -0.10890374658329945, 0.058646349121299672, 0.074834714830222138, -0.12420139612017432, -0.20144972988584742, 0.10552144065025938, -0.020504506975119716, -0.17927202820293733, 0.021327610813939576, 0.00032242502768309317, 0.029795663268480328, 0.02240044963438596, -0.042322592944988878, 0.043847035098336554, -0.23373534263209175, 0.03505344451513287, -0.19210366363686604, -0.058382912117240948, -0.26583148342043744, 0.16867956086704872, -0.075483170767529625, -0.11729978516705418, 0.13168062371104433, 0.32207386008563282, 0.077703743884706564, 0.066075041910355556, 0.071672184384444504, -0.12554371883496165, -0.16678676853218147, 0.24690905440162061, -0.15503968030135176, 0.2928597756318394, -0.072472757468334745, 0.011737788525512062, 0.19420609013696583, -0.088893039548740366, 0.022733909996833373, 0.12189163818668289, 0.10720268984252376, 0.24807390250019917, -0.14873660445495052, -0.009005715636329634, -0.08374806107318962, -0.14259359129705448],
                             [0.23924862149533252, -0.14767513855787126, -0.057563128667715062, -0.089045446141869336, -0.22603273836729207, -0.10001091072205143, 0.20653087855536378, -0.16561002641253875, 0.050765843922959207, -0.082751520442415488, 0.14162204755234387, -0.25206807296727646, 0.013613147173871486, 0.033516119055263534, -0.14598058959305998, 0.14058615011663686, 0.12695644654691471, 0.010486808138727599, 0.069907126737000613, -0.13037814284475513, -0.095671553919322458, 0.13858622401010828, 0.032805186874864667, 0.059885200514040407, 0.04179977449704176, 0.25991177564740442, 0.0065949238522918013, -0.028357600204027725, -0.020659640221362151, 0.32485925701103324, 0.22276410400727811, -0.086541373277937692, -0.052092740773252537, 0.1170158982824009, 0.039409567671305899, -0.10355438404092776, -0.0137517703285698, -0.23758113270842909, 0.23940522702583455, 0.021409271221281893, -0.15989510501282245, -0.060862579045890909, 0.01570430296392613, 0.033420068194387878, 0.081271231753088258, 0.070926312162381974, -0.062985788585838767, 0.34458594600695702, -0.1207795011727375, 0.12696243526629319],
                             [0.14037610374955969, -0.18785608235251089, -0.19667917793836151, 0.013520708946452525, 0.07558344615859118, -0.084411902847369311, 0.029509690523783938, -0.16999996026341821, -0.0049186969778978323, -0.30336951618121433, 0.04050599303612528, 0.1325044659407035, -0.19070837898509976, 0.077829140564104754, 0.038876814630716933, 0.1539944754068453, -0.03828715203720532, -0.013557212800033519, 0.12803765729260419, -0.10552032865851738, 0.19720449308544841, -0.091491674668578146, -0.06993270591599661, -0.15031664141595122, -0.16673885888687057, 0.04151492509779011, 0.12342109297330024, 0.18767859474955667, -0.076924579779509838, 0.093874045573702117, 0.23402786194116695, 0.14684457993301403, 0.16423028874767231, -0.22750521510716351, -0.08424151692055544, 0.038589270361956113, -0.0012947559462585629, 0.010605741088031879, -0.25558953873887552, 0.19124394834668643, 0.081992526071017535, 0.12299180719520107, -0.22665878257151428, -0.2036905044014205, 0.053115250846366445, -0.23719094849245875, 0.13239764823656561, -0.010969084680446436, 0.1159698886419516, 0.12422207325802974],
                             [-0.10478973668023596, -0.22987962605618151, -0.048418074815685448, -0.077609203658174197, -0.057246250238918141, -0.17464634030295359, 0.22623218645206636, 0.2060565081528429, 0.14161030548952944, -0.018799371498022251, 0.14067442614486578, -0.064149470233829553, 0.08215580265136066, 0.12113483908705809, 0.087370193460235127, 0.14146056659000755, -0.018902024388925395, -0.065292678536240045, 0.026618352247115579, 0.19810908020680235, 0.10717365586470072, -0.034475461572836333, -0.19710863558323649, 0.13233487165647639, 0.29731747175055562, -0.19307302538883411, -0.16810248236156722, 0.055054626668295199, -0.11183995516159823, 0.089308499041219153, 0.2435251221582049, 0.036500383705842777, -0.14990945515382353, -0.11453689892163084, -0.154055096708242, 0.057338027536208834, 0.12806873388506596, -0.022238782563430082, -0.092562097453817896, -0.12253731651210836, 0.026796027273597568, -0.37343384988659306, 0.13882444169321481, -0.021106897914303199, -0.06274296157794769, -0.0074478183923548285, 0.10480080939582111, -0.26408976130874201, -0.07080606077180121, -0.050952436965261791],
                             [0.10650871973418519, -0.077576385248424168, -0.26726475754103685, -0.28472613472177116, 0.021583558912323941, 0.062801183023698054, -0.075199805237939121, 0.038420314375627505, -0.26560392178381886, 0.10863329432983831, -0.019202917386841854, -0.16672127707135972, -0.1656883311706186, 0.055587195302569344, 0.02617817453212018, -0.11154587621912843, 0.18097880783430051, 0.19371806823156656, 0.060249613869763609, 0.07275649996656991, 0.15881013527930835, -0.13802325038318689, 0.16940216208038067, -0.23575995210841821, -0.062784175456016847, 0.009843480035474559, -0.013677096060231007, -0.049541170452657178, 0.21745933595270314, 0.066197441818217004, -0.0034661384820208639, -0.3369440056508034, 0.012117429096955736, -0.15809675542414542, -0.13387281362555317, 0.018919202352114639, -0.040989275367885651, 0.09564996827282185, 0.17420233246622704, 0.036938509531799883, 0.0400786400566105, -0.068479553681353944, 0.15120968145125299, -0.028189404996829689, 0.11294278576478581, 0.18386495655943341, 0.30293269793727934, -0.1520920977807865, -0.014886545024779164, -0.084657753631312366],
                             [0.045587568546784855, 0.14321716303056395, 0.098648945828447202, 0.051423916939133368, -0.092887018258919804, -0.0082084107910393809, 0.036339915960522856, 0.096623622925328834, -0.33388566264536962, -0.29288316478932147, 0.16424252913977486, 0.17275164502964269, -0.06813107894097567, -0.11209457519073815, 0.16211643366704123, -0.076123287940035603, 0.088526793386137698, -0.44115357933128418, 0.097280501291076682, 0.14385209984829825, 0.089886106033997604, 0.038327429654968423, 0.018632945160988061, -0.092500450892222127, 0.00043767875639803957, 0.097722622591234695, -0.041374618489482248, -0.26352184079631752, -0.10053958586339456, -0.18825548241444809, 0.022362355899477326, -0.18982389064216632, -0.025118541899105083, 0.1842715634551661, -0.15962062121771475, -0.11582436615295769, -0.050364630366865205, 0.046294634747667061, -0.12110311397296984, 0.066313474946277914, 0.028937757095323105, -0.22284303957781623, -0.022901463488508935, 0.087596220016869786, 0.077582909617749968, 0.0098505487722707896, 0.055975491653535929, 0.10937334013948473, -0.054164138455041456, 0.22001523561360628],
                             [0.057473781350709865, 0.303212067821928, 0.15045105222428634, 0.053758746196098668, 0.043605824160657128, 0.13559094888220111, -0.19307119167858761, -0.012196329763754982, 0.076908518050806368, 0.11578583222476686, 0.080807493583666026, 0.075236525813541524, 0.047681577257805904, 0.05308969698740388, 0.093393486184884647, 0.12025931241369692, 0.14825176863879208, -0.035422766077025734, -0.0099016529704619247, -0.033315542356617107, 0.064237116834063052, 0.15891474231868108, -0.096479188766865703, 0.27446600770234664, -0.19306265111474771, 0.079457936137030727, -0.015870693533372605, 0.21980615867859904, -0.11586106905338858, 0.1022951395910157, 0.0024095652632603283, -0.28889527642437796, -0.096580459385645703, -0.12101117751535899, -0.25713817906620839, 0.11430146135753096, -0.016224197603789563, -0.058994754607538086, 0.23283547763663295, 0.07864955261049221, 0.13875778202817116, -0.205761291234167, -0.026971976806782878, -0.35752012264690586, -0.11410049166030568, -0.046624983081277924, -0.02123372254454069, 0.046867554141852237, 0.21941562920078855, -0.018531509446558483],
                             [0.1215040711135482, 0.15725820345431077, -0.00072624527615802303, -0.11787973572308455, 0.21668354036662874, -0.15835878401130879, 0.10419852804716656, -0.14937578993940254, -0.09185903118494497, 0.06455189282267268, -0.20107895288957822, -0.17074958374530153, 0.11555444998132358, -0.32852101178785503, 0.083015114910708773, 0.046761288152656066, 0.021423874912339221, -0.075071417695839263, -0.0053861149947792165, 0.11309416016868172, -0.028960569929308132, 0.053820107596790401, 0.20413532391191377, 0.011751250862010299, -0.11426202033112019, -0.18191515453881454, -0.32237820764109448, 0.02887483517850568, 0.13523592118077268, 0.17892659550904816, 0.03052701898481144, 0.081146674780418843, 0.1289375128713508, 0.099377408535172809, -0.092795822467814398, -0.048079531846703237, 0.14641414113385115, -0.31283056548782262, -0.13818131675004791, 0.077930184247369291, 0.25612635682158469, 0.064366151809424441, 0.0098682301157384401, -0.013519102289587108, -0.22102864296686803, 0.031358010474931891, -0.028940619451687549, -0.11758731339219355, -0.033566932156497198, 0.19526571031688919],
                             [-0.12415657770226661, -0.0092114754889991053, 0.02044275782231823, 0.14693861574974035, 0.092939720838802434, 0.002325714549581298, 0.092217458406149005, -0.035222982278844045, 0.11869170208521788, -0.019299969296257758, 0.099771816839293842, 0.20939184835289096, 0.11300576509019537, 0.39014134811848972, 0.012017887274726337, 0.059414816831194643, 0.068800029399074175, -0.14363569941933627, -0.20267550612925397, -0.32613701673699652, -0.065421182900486624, -0.020649922079716051, 0.042393470350941584, -0.24891823148126083, -0.12406860597145812, -0.039131086514842914, -0.063687107705320406, -0.21472729891356682, -0.08785143329497927, 0.1720421451268872, -0.075894286585575357, -0.078711277029190438, 0.092864880996352664, -0.03494349886841245, -0.10210805008034232, -0.30438001364284195, 0.070517938995827603, -0.12912490956406175, 0.17333393457083227, 0.10815454428190412, 0.13468025532646871, 0.055197193785704229, -0.060879343468127109, 0.081766998012638578, -0.092419358108248084, 0.11885267771785378, 0.026056991700274049, -0.2752602481783239, -0.18818903140428342, -0.084523480955991909],
                             [0.09031728306727009, 0.26857933477391671, 0.037643563703996533, 0.058536121039574368, -0.0022968987099941259, 0.15968233759496822, -0.039043172101682309, 0.11585470291113607, -0.09051740209296566, 0.12158515075426336, 0.1308309631748617, -0.045486951278064576, -0.18377947724904897, 0.13754317991352322, -0.23728367314220178, 0.0035072060630877357, 0.057028637945113765, 0.050609526288919994, 0.083753051724903535, -0.14753788969569945, 0.086262807754943077, 0.056412730499352699, -0.08067994576929606, 0.001673402391548077, -0.042975406089101886, -0.15305470406329766, 0.15510408293417716, -0.00072531157681544021, 0.19845827680072023, 0.11745769655223806, 0.2492042919728662, 0.14136385813868824, 0.24030128924025637, 0.042327994505533477, -0.19792373276176012, -0.19969431593538048, 0.057434699759269202, 0.015031537135742101, -0.30406919492739048, -0.26778690951875495, -0.12845689660697462, -0.11512941465116111, 0.067810438337354673, 0.1239215548398399, -0.075113132293956011, 0.22432318383556965, -0.18735461899915104, -0.018910973682387786, 0.19777191127897323, 0.019631483323620195],
                             [0.21115272364576582, 0.0015521483953296587, 0.16371529455441339, -0.0032618662117082932, 0.21112724926594043, -0.18997546557124873, -0.13696481120178086, -0.1022513786987108, -0.08788037179996494, -0.014821274215328546, -0.10393285319355036, 0.051616131114859985, 0.12273366713868267, 0.053196078973793054, -0.094115165277549429, 0.13636395709040208, -0.027074321027797825, -0.11129182479750413, 0.068946420142480855, -0.035678095079733907, -0.11201088452248474, -0.1948908739020061, 0.1201462126209842, 0.102415835452054, -0.021629915282740893, 0.013027753117595126, -0.1116522076803519, -0.097453338024381109, -0.079584229405670837, 0.094242009480784664, -0.10644895406727929, 0.02547977748867284, -0.055805654993895407, -0.0060948541975875464, 0.062422153950234642, -0.11998400778394057, -0.038596959793200332, -0.1442486256252003, -0.08877164841781654, -0.36395426536406067, -0.067867268493087149, -0.14507224874747376, -0.12312362040328219, -0.0062415535447764049, 0.4019587311776126, -0.055556445434020274, 0.25603956323327193, -0.002199820262363845, 0.24571279808811758, -0.30338145789004217],
                             [0.10451117029703831, 0.19624052174317214, -0.013065911676600841, -0.10069127170805542, -0.062204693961573999, 0.07422111058072739, -0.011329496198583075, 0.040791159542454762, -0.32081833112201175, -0.27976478174895142, -0.14609167061408024, -0.23430154050620466, 0.11114829726896602, 0.19666804036293439, 0.052489819180136538, 0.01012543018811155, -0.030944682151330338, -0.035022053976842105, -0.18294335579728135, -0.075071191310343621, -0.035820096186873922, -0.096287023344194825, -0.13122871505450501, 0.043778001586861237, -0.008161513970889293, 0.14392893425893544, 0.086206714335327533, 0.017071509364380177, -0.068746908367624662, 0.16308767718696809, -0.043798092088860652, 0.011232829103632488, -0.15159768797768247, 0.02005037037128081, -0.0081575559854897024, 0.21597661518236974, 0.062132064889809602, 0.11713717468782346, 0.035395417037606944, -0.40603879197608739, -0.061993520259492105, 0.18542006921276372, -0.14253838737116004, -0.023289242712560814, -0.21863050011385554, -0.12575908936698796, -0.0084091167364502509, -0.23451688560605058, -0.16933687761460134, 0.15707073279524836],
                             [0.26071266487525246, 0.079500541788906476, -0.1584864946848023, 0.12131907856779342, 0.20452722292608119, -0.11656795654047052, -0.079508063871648327, -0.039034969647671468, 0.084795246575529906, 0.035029998613352813, 0.257083541793797, -0.017823443604757908, -0.14969872829399403, -0.14087351780868648, 0.022757995562151551, 0.3810575206120379, 0.040884904615627202, 0.18863286971794682, -0.30892557437828633, -0.059175123921787552, 0.037750558401060008, -0.024241041953097786, 0.056166600815979122, -0.13376963907644121, 0.02857781397911334, -0.0053969277802548583, -0.11612770560939396, 0.032227931431206142, -0.09885496230002494, -0.097357985081150678, -0.091202974101890474, -0.018489002890847768, -0.28237285780382948, 0.044594078945882062, 0.065064706452479193, -8.0580627226277458e-05, 0.15050280406775099, 0.33380127495057638, -0.07423203399799376, -0.0442024595490252, 0.10783697010327373, -0.10090150244508411, -0.11269743952070564, 0.19479643139286326, -0.094740836458755334, 0.1545131626032055, -0.019599341993151366, 0.14282159769909122, -0.025301953322516627, 0.055187877188840634],
                             [0.019188606833928118, 0.039583206848615937, 0.19144269391844257, 0.14103934199952919, 0.21983408626284193, -0.13454868947834203, 0.054432530825132476, 0.1462630467664145, -0.047702525365331823, -0.18096412990863781, 0.12363559521692884, 0.0057415872326693988, 0.007119468322647096, -0.019795275973452774, 0.041365284611482485, 0.13054766513555507, 0.13650026979950891, 0.017064077071705496, -0.045265966414659284, 0.2023772599755117, -0.0087891621368804667, 0.27412940429611499, 0.024002455412688747, -0.0029445976701051803, -0.008934879807795372, 0.052649908204488463, 0.11617129068707113, -0.024146783447483, 0.17237059263353907, -0.078529790943469818, 0.017461302005057869, 0.10979526822777004, -0.18460046727902055, -0.34852127600538663, 0.15725553716246288, -0.058937921463361388, -0.034908585341142148, -0.13073605797940804, 0.06371321363297297, 0.014089934623017377, -0.21115608008585307, 0.26809221565841995, 0.14101700484786509, -0.17859316239452805, 0.1750131631493316, 0.30771258653288575, -0.0097945577278746431, -0.20575030399123304, 0.041317502692109924, 0.18514937796156394],
                             [0.081947151674107044, -0.24188949588600805, -0.065146246142355438, 0.012786371954292755, -0.1250713554160042, 0.090009745835851404, -0.10270516292811563, 0.11711160220682579, -0.049155299813915213, 0.072178415405467808, -0.30878456766859813, 0.11418992185470921, 0.083104579647237067, -0.039254211329358961, -0.1975408977902838, 0.15193113206641493, 0.059411977641091275, -0.27084166994593994, -0.14934058861173607, 0.01939087184992843, 0.31653641340906447, 0.31851998991022262, 0.010814230459564681, 0.052117472517228404, 0.15126581141375517, -0.18636334048285075, 0.037983987982449376, 0.15097102765095627, 0.11656054977048844, 0.08540282022185984, -0.048539633836156282, -0.2777879076856169, -0.078939101910226059, -0.094466031848398885, 0.063456322603323942, -0.13075823010401846, -0.14556635242272203, -0.00099998573942193959, -0.14882199898281911, -0.081112690345343741, 0.084208938323741253, 0.13934199442049416, -0.23234341918490595, 0.050890074301502358, -0.0029652345653659951, 0.044308255673689428, -0.063461706667545137, 0.087635232302099478, -0.13809504249112659, -0.08641748488244598],
                             [0.1485440448075194, 0.054819268012619438, -0.12827641238007223, -0.034304854790561799, 0.17879674268591578, -0.22209798098919528, -0.18471177421223051, 0.19306069520613522, 0.071820511151601249, 0.14647226765967927, -0.033617759283263361, 0.10698815303081252, -0.20047321512377747, -0.05062220923842474, 0.035167577320218461, -0.00095469289095357821, -0.051053002868770986, -0.1909338947339628, -0.052775906528231359, 0.013323336412888281, -0.052708233683371526, -0.19793737422299343, 0.26450865879107333, 0.07277924801088724, 0.28346949711412583, 0.035753720989351132, 0.28413468077537357, -0.024507357776878177, -0.13484987017097702, 0.067782260296145494, 0.23136734296774236, 0.042045067079109939, 0.1153859064831067, 0.04513140143954994, -0.024062128998953942, 0.019837159724565703, -0.24349530864872229, 0.00020944186682058568, 0.26641444385717, -0.062031418507755343, 0.1687955830217148, 0.040874666361286775, 0.06737324132921825, -0.046157602806574639, 0.061685298949951138, -0.075271380221853937, -0.29697324873434922, -0.13537900353501264, -0.086585740057381969, 0.10191083061396169],
                             [-0.092135338308516765, 0.030008374709537555, -0.058534110887321127, 0.10231961246557772, 0.29990792862741661, 0.011390156564497635, 0.015961023638772505, 0.094167330767808755, 0.16502506499878405, 0.13127420252407246, 0.06261329958064249, -0.10560548446495502, 0.084176295928335185, -0.1549855201323882, -0.12349313143319988, 0.049086165028406202, 0.35367132663856421, -0.24161622400779573, 0.082142957622926574, 0.10368029398841334, -0.00132004703197854, -0.14046372281345765, -0.18493318610433476, -0.05776027696037786, -0.20197028875026868, 0.078147930736866225, -0.019955342134503593, 0.11040556712721454, 0.099054811949774862, 0.049073032424896079, -0.016868973213926348, -0.024777159689865762, 0.073563984614219355, -0.15717538296980416, -0.055894522766028409, -0.030669826313417085, -0.12981655475304227, 0.078925750060679589, 0.085653424479611787, -0.07557987972496559, -0.24550063129935237, 0.03993589209351564, 0.073992254497603049, 0.32942865441839803, -0.076729229884000175, -0.38574009463304576, 0.10495667668354473, 0.054424445876177494, -0.14089974162765379, 0.060766551395469236],
                             [-0.1918792550554857, 0.057027766710663501, -0.10921272784912632, -0.14413496798543907, 0.092360283705377785, 0.059121932281010023, -0.17828016895494028, -0.15728579343414964, 0.014273411821102359, -0.16224673120985977, 0.061987799107798294, 0.065552514313516719, -0.015018298473989063, -0.030934115636232426, -0.047253081885854017, 0.036281777247020003, -0.14354588916958866, 0.19181663360716497, -0.011492984365405729, -0.024275200230723628, 0.052995858910327688, 0.088565051821505217, 0.015224996343092633, -0.089859723445643067, -0.059584855159966317, -0.066447926570871382, -0.23339805208643657, -0.14245979456339075, -0.13742700922431897, -0.012961714480915633, 0.14278657268304323, -0.35185271761497466, -0.10576420830199632, -0.1404195265901344, -0.036043015958014055, 0.12411711909557584, -0.012494436561398252, -0.21398982933453578, -0.11927743437057303, -0.071546307060725151, -0.15289079875547384, 0.044289735004088081, 0.11687620664326223, 0.1923407951406155, 0.21742932684153635, -0.20520063025234603, -0.45566718063047551, -0.09956329488665297, 0.013467723101779936, 0.014831221885233439],
                             [0.02955276501960577, 0.075668465346375072, -0.28047574491843402, 0.089384107188195991, 0.055881002286645817, 0.19825684625263709, 0.2006497694154897, 0.15013070742672124, 0.18337594377502922, -0.043527059054653344, -0.18090912491447866, 0.085454315076722076, -0.074235373256822029, -0.082678528617188857, 0.14440363884458782, 0.018732044845490937, -0.15466513454649577, -0.16657205537335082, 0.03027407484515059, 0.018708530682128889, 0.15373228885569373, -0.0023604826486144509, 0.18373102810604713, 0.20421079783183987, -0.28274831039118992, 0.10231388978706055, 0.036528327907784063, -0.32766036808692744, -0.064876984832817439, 0.128456700762209, 0.13157749420205442, -0.061294348017017948, 0.022197311892580208, -0.1300555270810583, 0.30500885984304305, 0.047151630948899965, 0.2531413564150557, 0.073725698099414705, -0.018404786167242459, -0.11809076332561273, -0.075951071711358328, -0.021984682153020463, 0.17383918279233518, -0.071593018020696383, -0.12161002003203031, 0.064660161940186214, 0.042789571986567722, 0.11496493855267813, 0.022110893149445459, -0.16409475346727406],
                             [0.056120017887077961, 0.018528668656181625, 0.17127461662346175, -0.20887649731608227, -0.13826795151722907, 0.42366532329985301, -0.075127950401704141, 0.036908760214758286, 0.086317741791278907, -0.21329112373226483, 0.015934327575423287, 0.13188128585849862, -0.12844035641513588, -0.053310181066673464, -0.018447688057093084, 0.29454921460782063, 0.32523597378422947, 0.04549125219095547, 0.14951631441491339, -0.010168604057399661, -0.21799562884777057, -0.098852137580355007, -0.01755842109060422, 0.061791563081333788, 0.0979183915911747, -0.038526504246597697, -0.082213704208818059, 0.065294266776537851, 0.011942618839064856, -0.10551089708272986, 0.097675859142285382, 0.034273259855877508, 0.079253445224543903, -0.0084884849237526934, 0.24079856584509676, -0.070883351133308847, 0.096422133814613606, -0.031247890598346536, 0.016219177355281587, -0.087406981035015638, 0.37061063777600112, 0.11201947539504371, 0.18026057275182902, 0.066331792006080512, 0.071815665705537282, -0.066861813504196468, 0.058630673710644711, -0.071434953923733141, -0.10980275396014449, -0.022966576421119243],
                             [-0.081778293974426722, -0.029937995711018146, 0.12781456092791507, 0.21031260038116881, -0.0061953981259021988, 0.062944570233963659, 0.2638007549977755, -0.065945593353151741, 0.048296712408871574, 0.17070913897048615, 0.11161736249297224, 0.034766437236796427, 0.055187272471973595, -0.13912741071992266, 0.17459075371035485, 0.080421238070421092, 0.055846643410391771, 0.028350736242452192, -0.029857226778528156, -0.10296884393540043, 0.074881719914960024, 0.11010075678388935, 0.063414414370864577, -0.39291376763847008, 0.2012260873790454, 0.14526964569014211, 0.024751686700182924, -0.0017121026264144807, 0.15227821133330152, 0.018077313683267308, -0.027323253325264474, -0.17118165378894012, 0.30710907608733085, 0.028300170531761759, 0.14346045704390964, 0.33737032766785746, -0.02494840732228425, -0.065016772127244687, -0.022592213561109575, -0.36207779347355651, 0.080455079242174807, -0.11685881726339625, -0.082593620512359717, -0.17193642946263377, 0.073259543653961229, -0.080359981111522122, -0.012233104983389812, -0.026990169053097039, 0.057563285355005461, 0.059869888141300225],
                             [-0.073156422060807663, 0.16310001537685559, -0.072002216273783837, -0.0531274364369567, -0.22124019226548283, -0.071437710297025156, 0.21703812461515223, 0.14673803902260832, -0.064112445904838403, -0.12881653555419126, 0.076101994261399089, 0.11073257025914598, 0.11510024861011101, -0.094866956589780546, -0.27641539591137149, 0.0030923869223079673, 0.11316416012769716, 0.048915498236428927, 0.066553174230835135, 0.011297472750206379, 0.12296983108403646, -0.23115526531028477, 0.22276778783401052, -0.0043724572459909114, 0.1358717835729859, 0.08148398794774124, 0.035600340887472083, -0.077746324514064033, 0.15390287577260456, 0.04958792723419822, -0.30738932250040085, 0.16012502697101383, -0.10162785278057035, -0.37390879186236647, -0.10758836973229773, 0.014086641222078098, 0.15398774648094854, -0.071555298673268444, 0.10535437190090834, 0.053432336278737579, 0.14244190758841033, -0.088980254246453575, -0.17210769407241056, 0.052274762688465211, -0.047342814853440669, -0.11351543830202322, -0.25443477554531035, 0.083958723416164033, 0.16678744537820123, -0.057461791339221774],
                             [0.023587226750757029, -0.10513824514643795, -0.069708909963355367, 0.033447611937709711, -0.016054692966098929, 0.071485406337702978, 0.028085948873363003, 0.17958901921429901, -0.02618514494138658, -0.17165608609595551, -0.23928495866207461, -0.13381600671357333, 0.24243697393386668, -0.14986026526217047, -0.13901096002398847, 0.19614847306604707, 0.12705672945958016, 0.11578664363368923, -0.27441743501672766, -0.23221364838227437, 0.18739726402517276, -0.0023042634722965812, 0.047590785897943612, 0.039766819659520253, -0.16032185170779267, 0.0052191003609457342, -0.074581812598547875, -0.086518850931465829, -0.065924853935910119, -0.42432098350344088, 0.16417617606500789, 0.19298334721769814, 0.20739960895464241, 0.12515743982283303, -0.17670292440327798, 0.055321898261353641, -0.10773687433444312, -0.031799755052438892, 0.19381253216918251, 0.039874616058205706, -0.098501068369535247, -0.17101198404960463, 0.035803920982049028, -0.085388409972625104, 0.1194957042650123, 0.019203503073785513, -0.021318353681157105, -0.077582861382192683, 0.033671142498737393, -0.0052367774432212745],
                             [0.076494685858864833, 0.22869869747740335, -0.18578699370880578, 0.12427620006455191, -0.015090057426815654, 0.17589023989857325, -0.039458210220312727, 0.17020396261696305, 0.2934603199109852, -0.050428018340069047, -0.030326726389829313, -0.081045541986579567, 0.15407995309870029, -0.086347687959295302, -0.095146181772965729, -0.29150746994673088, 0.14176312680864603, -0.10117515419807681, -0.070888706329352472, 0.031914925432720821, -0.030513021843427648, -0.23427154651877916, -0.11636274703104044, -0.26007410903680317, 0.03455816791650821, -0.032014364961153563, 0.0030921745512368115, 0.13417295100986304, -0.013189294125142349, 0.095105069319285307, 0.13632535818768413, -0.0093784033403478406, -0.27526687413393758, 0.18769780724975393, 0.014153098508536415, 0.095013093282182409, 0.11173128695834869, -0.15560603150953878, -0.16631630351132701, 0.11054025863237696, 0.021442037188919478, 0.04420355940939899, -0.13041282561200207, -0.18747021611989206, 0.32298957047808757, 0.15808293786602154, -0.0093308828096833225, -0.015791865903689702, -0.074014470800134291, -0.028691222488005392],
                             [0.096437492682639486, 0.0205042334142236, 0.12262084903314933, 0.39298406547967596, -0.14117435682336771, -0.079633754953964311, -0.13361023183059728, 0.061439646979548006, -0.18518941161457578, 0.15469178047693022, -0.24364483744827703, -0.0087431200266403757, -0.0081944377114420899, 0.13154576746650948, -0.15588670369666038, -0.019963302486358612, 0.11003742864214648, 0.05636698723450017, 0.044799171066349307, -0.026492755142076392, -0.099807804330626179, 0.048236384586418456, 0.16842660004785689, 0.0059148173193614003, 0.10933640856117599, 0.099795358189457159, -0.020031787989748348, 0.037533962791138055, -0.11312142647589933, 0.0019095807827390629, 0.22832693140602842, -0.11410879784202659, 0.0073211113466144524, -0.08941849493649022, 0.18044172500585762, 0.20561222780462854, 0.30410809059968436, -0.017302374825704063, -0.045095253164837562, 0.30031879867889311, -0.057707121314050758, -0.10136272239066306, 0.00038306626612134349, 0.28451730602442704, -0.017829856109528194, -0.11734309386531371, 0.12106734036198706, -0.19289503849597328, 0.10371143513991508, 0.11686091361775974],
                             [-0.33730706025689161, 0.031815325033644808, -0.092620581888436887, 0.084785041973323663, -0.064314614440798057, 0.018508673736204285, 0.02797492496336175, -0.24581335473511332, -0.15582368793306736, 0.19926889510552517, -0.071828861800897967, 0.019201448977645783, -0.10124434943217089, 0.13995756203630827, -0.21538774231429789, 0.009194933899034325, 0.26243471347760267, 0.019553153554183033, -0.15703395476355486, 0.21965793626121483, -0.034097691371373529, -0.16787670792025058, 0.13868562714074573, 0.046795807988189483, -0.059967390325193999, 0.1208297065546769, -0.16793695342744788, -0.0062116576735212464, -0.30163631036467953, -0.027023334351221603, 0.064502807632867351, 0.11094629072189695, 0.0067176696835466411, -0.14108300359715639, 0.099121198774930752, -0.048149213399687842, -0.22225846106241468, 0.0040000886521761253, -0.21877331847532744, -0.12206704605579416, 0.023738597526087913, -0.075406455659838015, 0.014930432144354567, -0.26401626610257833, -0.048035085850967094, 0.15836633618773599, -0.023566856697581368, 0.12422166295708979, -0.17018703786923156, 0.1326210143568852],
                             [0.016025814362604709, -0.050789956291048197, 0.047696147092014203, -0.098314637716280615, -0.035043745425164884, 0.097844031508950186, -0.049245477937676647, 0.32713236724260575, -0.18359854148761576, 0.33849621124045004, 0.05206070666692586, -0.064550938860312795, 0.039280811639135937, -0.067183138775232673, 0.037556626865116662, 0.17820604417520838, -0.23958614193054151, 0.062726414484088736, 0.10319668697556893, -0.1440706433229369, 0.056904830946991364, -0.075912679485422449, -0.20925365607996335, -0.0097957498780482134, -0.22907639300150764, -0.039330831146032384, 0.063209711138058691, -0.04583200178459463, -0.1648832367011365, 0.14367428419381029, -0.24655862107864657, 0.083434483615091856, 0.028392659781829182, -0.11173936618002957, 0.17497810055353441, -0.043254896202997023, 0.035438010339714568, -0.11078611405916994, -0.053824007400140102, 0.095777140909850886, 0.07042094862456752, -0.16389039422481086, -0.02011876427970825, -0.031488909064375785, 0.27870909821229001, -0.012160297381985194, -0.042528230944872444, -0.0036548210721727673, -0.21319796155434573, 0.34578522207095852],
                             [0.055331167162828251, -0.0029286627524711716, -0.098973036895797756, -0.0098115492701953758, 0.12680964292542407, 0.067208162374416416, 0.28345285480155707, -0.21636089997909083, 0.040219750604516012, 0.041270682181132098, -0.22844841363808802, 0.13173837503004554, -0.12303504521398824, -0.10683310411948768, -0.40134851560310125, 0.032937020389932889, -0.17579914682775494, -0.17251355074138244, 0.27998990890983616, -0.17311589333507948, -0.1347774357605753, 0.12793168775588426, -0.066504024727738906, -0.071448107709496958, 0.025766268040761937, 0.13451829402903365, -0.027891793088256431, 0.13287944725112918, -0.02371951467276413, -0.1114972213760496, -0.14313837198189094, -0.047134636937274918, -0.20841076733965036, 0.060929458920312207, -0.12309905377216072, -0.024111327712439141, 0.039833963437868519, 0.22372755998180857, 0.072277981232515484, -0.047238590088269375, 0.0017573296977057673, -0.10298998750156201, 0.18920522086135816, -0.12060442404751788, 0.058144804669281631, 0.06145035021605718, -0.04343167381904843, -0.27770847272427346, -0.0054062413178161779, 0.15029098652745101],
                             [-0.097271291025420009, 0.27868621020793155, 0.26692386405650254, -0.13159289310825636, -0.13458734300805203, -0.05896624631879066, 0.14272621392755044, 0.015276491884046433, 0.057049108448058487, 0.067977656584497448, 0.10401247758814956, -0.09385993956405457, -0.13194237748852655, -0.072422961936813038, -0.048546912010771465, -0.026933913863782147, -0.32460403146544148, -0.14969426861656651, -0.025801882899330338, -0.087609587141590353, 0.23837327402586442, -0.060976914323243557, 0.11973579415764117, -0.017783410402640643, -0.078231448810764048, 0.13949443747921911, -0.18059783297317011, 0.32664776261677148, -0.11373412079605798, -0.15020492521704332, 0.23070956572435491, 0.0043635996596586707, 0.045190014297111489, -0.17756627063596706, -0.0083810586951202845, 0.034050917737465186, -0.036450182545494654, -0.014137501912504829, 0.1233893932196274, -0.041967513404128645, 0.032841345659832051, 0.17356184998752122, -0.11597413337240758, 0.2304584089374779, 0.09995030272845784, 0.1769405682507405, 0.17253344683664457, -0.0021521304615934591, -0.14761518870088319, -0.1413706545455338],
                             [-0.11468072016716396, -0.21787871228975694, 0.25643648829293481, 0.023850670540905339, 0.34890672122314076, 0.13633722043664021, 0.11526658423281107, 0.11939264722195547, -0.13233702807889217, -0.0093215308379455217, 0.0013449142595271036, -0.028607024056084521, 0.24219464735688528, -0.027922892847301383, -0.065039550222871903, 0.0034465250290582126, 0.060425192282860418, 0.13963117378770992, 0.38908365897923924, -0.052695230381347623, 0.1394980405872687, -0.16905109184349812, 0.065043752981534961, -0.042284580484399321, 0.033736361369013791, -0.075586294085528888, 0.0033440704590260747, -0.0961312622397405, -0.24003835648858865, 0.10684627006060178, 0.19828807264107512, -0.087303336592360253, -0.14207543622065003, 0.10703595009890834, -0.026126563320192579, 0.087993573324632063, -0.068746974680362852, 0.16093611355643148, 0.071055998794038719, 0.021370713790439606, 0.090046379223322329, 0.19265535057010119, -0.1571127102993016, 0.030774595038561756, -0.15592118219548026, 0.21711166475556784, -0.095925366607118409, 0.13603590921493722, 0.11569601566271413, 0.0063392466855419893],
                             [-0.055275459782244137, 0.15026872448174913, -0.17288476084298324, -0.099265881456733956, -0.088416191857911247, -0.02074761584387989, 0.053998135712652107, -0.12666387930115205, -0.047271770961325843, 0.014453771985913447, 0.07409051518953573, 0.10925290116647877, 0.34853911816487165, -0.05462959720198949, -0.095230632771896112, -0.019449120667995267, -0.13711539611142384, -0.10508880141655071, -0.20238453158010303, -0.13755425141293512, -0.14760818477135443, -0.062383147509543026, -0.16248074075398661, 0.0036059389376563761, 0.068563045447384105, -0.23070871478779345, 0.069148297640939424, -0.080711290830962651, 0.049238984112878095, 0.036094571362578987, 0.19898804805934658, -0.079313455184209569, -0.01968546039068703, -0.17033593905414399, 0.18529294538681579, 0.048164028765563638, -0.24554131355456982, 0.089329855519296703, 0.055544995094875267, 0.021562671891795403, 0.15798193136341757, 0.040351228770959729, 0.16898553702932295, 0.12224302628344089, -0.010701147448923172, 0.064570727050229579, 0.24478394597690262, 0.10907594630197402, 0.36241280132799558, 0.27851931739098401],
                             [-0.082215453710720116, -0.047176058140035906, 0.12894589712576049, -0.066189905713292377, 0.19113974491845501, 0.035539509007163142, 0.1102244676421001, -0.11511572313400144, -0.078669642651719787, -0.0060338237631223273, -0.1442777685571805, 0.004719072043371522, -0.15042436959440728, 0.28627887381078404, -0.021157316481934422, -0.10225396031222302, 0.054980660509916054, -0.11122945803565534, -0.25351700441668978, 0.2101977034884811, 0.29123010573722291, 0.030655189831756316, -0.15405795773944481, -0.034350122934316898, -0.030200924613919794, -0.051687911587469333, -0.095313480139276138, 0.059282711439648972, 0.083082051380779454, 0.13152584199525272, 0.0046309577348242004, 0.17141713835392886, 0.020706062346052687, 0.15310851018750113, 0.087874376061932616, 0.038666661078285966, 0.26150939405794782, 0.1349477207072447, 0.28072943934210048, 0.0094655994112904634, 0.17577239102534714, -0.020434653142042975, 0.10870029828374106, 0.090921015859642629, 0.31403915117515147, -0.085662002432656176, -0.15548229789939494, 0.17513217779434218, 0.18765009323174864, 0.11812421354340362]],
                            [[-0.214521992927967, -0.01498518650685975, 0.056259537336730329, 0.044781477257285471, -0.14574691644907553, 0.11957307434187074, 0.2022958452718, 0.077156575052460333, 0.072407522884253991, -0.031950244955209289, 0.15655314550856722, -0.046966664395882464, -0.034041970176209774, 0.0085974085065280755, 0.037905934765366869, -0.12325183278815119, 0.045197948479447317, -0.056639361033279233, -0.22159314068954331, 0.1645633008712756, 0.14254117708347655, -0.067896812981673382, 0.19599320658104821, 0.073441075239335754, 0.078365463937377061, 0.020287926643238474, 0.043838934532343603, -0.079616756577478645, 0.14422082551302351, 0.23992780456224114, -0.1494014870120742, -0.09364968410062198, -0.030151558121313361, 0.18319233774544796, 0.21782213183812449, -0.007974391189790762, 0.082411654147275609, 0.019796592710474237, -0.24567317792952942, 0.21178574338048928, 0.091472575915606286, -0.012439484736507704, 0.041990629206443635, -0.0070486220875443078, 0.38731016272250629, -0.019794299935777113, -0.39476216371854789, -0.094291765969118146, 0.029190020038490916, 0.14213713268551589],
                             [-0.1497337995769025, -0.0034964564710701844, 0.041779830111752611, 0.10207757755300195, -0.13304754425845627, -0.1623709372922201, -0.085373345425449942, 0.19411079600625522, -0.094410348353857837, -0.12530730220094308, -0.088637305867933031, -0.082174990600298009, 0.15405119032501724, 0.023850699239244249, -0.035880182714847761, 0.075561915465465368, -0.23344379110428357, -0.11661108594046593, -0.020995850958876516, 0.24152394509061656, -0.10569837597072324, 0.087421124139176215, 0.23920848352038043, 0.19940337408625239, -0.090569906386333818, -0.10411294384452362, 0.14576608927679247, 0.14817198906503964, 0.28026744691621114, -0.18507524913036999, 0.12173647419022843, 0.12953258089433273, -0.097824451882554453, -0.16612127650544078, -0.014416010612476673, -0.20684193343580926, -0.20108781370017842, 0.11178053084384405, -0.090169679280233103, -0.062554192166692432, -0.0010262916929432877, -0.19235684878668002, 0.087468736590572069, -0.070826880265825856, -0.088775158961336129, -0.23474524511851746, 0.071818719877011453, -0.016578165058646323, 0.083062302914561029, 0.29396324875973828],
                             [0.12922197854968984, 0.20064689888750328, -0.082119289995496572, -0.10027012627802583, -0.057679538847983013, 0.1802270366003334, -0.018371057119157846, 0.19136991778845661, -0.12074442555623614, 0.084826418728849731, -0.15742583098721818, 0.22700613159799213, -0.083516715904834629, -0.11443192198580324, -0.06896893944914563, 0.11459667655864091, -0.011074280068959816, -0.082820694192153224, -0.012597266007234651, 0.11243405065101558, 0.0012248674761864934, -0.14510955105518661, -0.2337498025417464, -0.037100810889563393, -0.15175991710740933, 0.059357744638340357, 0.069465408477623752, -0.0015553582220069505, 0.082075829321307234, -0.24789284616999258, 0.026076590729635911, -0.18086681287909984, -0.2438916763898758, -0.16395712765308063, 0.31032962408563108, 0.04497438247690947, -0.083849554895472272, -0.021575061279105238, 0.043595650122510661, 0.19792536472040759, -0.032754034145488276, -0.022046695642052798, 0.07071672396505467, -0.29622897001759257, 0.043294257238431992, 0.0072770351425921493, -0.14016910704866034, 0.046426789553697397, -0.35899775181333232, -0.086170791117824996],
                             [0.10860259364270668, 0.046413041514757183, -0.055705454436912528, -0.058654390641737171, -0.18145016729218794, -0.071970572021129192, -0.10026450247427568, -0.064628136015418489, -0.24003319376599475, -0.29639279214776598, 0.044732276680677981, 0.12764931054112358, 0.044017930292902303, 0.14904161808811509, 0.090831678915333336, 0.058669531861748329, -0.14663171500043684, -0.20394986707743876, 0.14054020563223349, -0.27509062796851985, 0.076295893818158919, 0.053592018767621076, -0.046536912047989105, 0.19854437343021686, -0.12091404175348942, 0.031820343762801261, 0.032519317079818949, -0.24888291312531069, 0.22862925879847701, -0.17310016020831501, 0.047977837689296816, -0.060336079034766434, 0.15646219602746861, -0.12025384330646864, -0.10855376134730399, 0.14595733701899694, 0.24609915315418862, 0.13581242544791225, -0.05348577552657998, 0.025916012180350192, -0.097978265394430553, 0.0614599725190101, 0.015316239190526043, -0.037774390364923, 0.20021015370607362, 0.1661401878340516, -0.11844853728908292, -0.1642146451632259, 0.23228258968807527, -0.14039573788302342],
                             [0.26412033680783253, -0.12926221832113799, -0.068910197434374154, -0.11787507562941305, 0.13834926077464069, -0.24980584254473229, -0.014798137468648789, -0.058074489458521582, -0.041549410249115563, 0.086583159855881817, -0.066368862712278057, 0.16716218187883219, -0.084463150785458574, -0.11736887249276412, -0.046055165920399155, 0.18644274965288909, 0.12317961949460081, -0.092013617745257806, 0.067861178562044475, 0.11560350607768961, 0.095100958687030807, 0.10282351443904345, 0.20121371523214962, 0.15336197875572732, -0.087681073410484103, -0.083258743163017387, -0.25178540439151498, -0.046235843600250216, 0.14609814230306861, -0.013945199151335831, 0.2297580246545505, 0.056209974140138987, -0.02679067498345581, 0.19514303727848259, -0.2305979289961505, -0.026680747919162473, -0.10947805484466497, -0.07773566229809882, -0.057368888698005126, 0.16060941290958181, 0.41188606755315371, 0.079885945771640932, -0.091973699270247664, 0.13403700321323853, 0.11990484977035272, -0.0084123927245846487, -0.079997860707693089, -0.085626836467763132, -0.23875220697340277, -0.0087949702249565109],
                             [-0.050957392762963141, 0.0052349007568679717, 0.15331405080553281, 0.025731017426352771, -0.050260828714650221, -0.14265590216870552, 0.039527264856030551, -0.15576218701877378, -0.13656164265384979, 0.012505630961625032, -0.044691830621232727, 0.04266519031823849, 0.17570100451336898, -0.1701568875106278, 0.10166121947455295, 0.018524928564055299, -0.13516287529990778, -0.077925744111299891, -0.097454682553843069, 0.016677369032834493, -0.18199449354191191, -0.1569512863307746, -0.10221035516276844, -0.056055836274995892, 0.0072038722944230641, 0.19194501451358509, 0.019530248536024444, -0.22173191268279688, -0.11190752851936231, -0.12208288459720036, -0.040574995304623059, -0.093717046828787176, 0.15573341614129668, -0.072589036153470773, 0.1574555813857022, 0.0064539669017593983, 0.015780624619211817, 0.21854368249966219, 0.032717799022406888, 0.047556615919292555, 0.1532177140340982, -0.11882461875822777, -0.047343123064419845, 0.54269094959575259, -0.1771326192785396, 0.099930831380382737, -0.16552978164394189, 0.11195312576197529, -0.18632487120515384, 0.21345064359136853],
                             [-0.10306616482338342, -0.13284974014865464, 0.14861999133282638, -0.034384279861101381, -0.040470200956194906, 0.15020432509143419, -0.070085746250568057, 0.12459853913996423, 0.016891872569607308, 0.055741364900454921, 0.10537417883083637, 0.014975740745731108, -0.060601897626408177, -0.21801282628630836, -0.35736501613057803, 0.035931080319716327, 0.12732756575300111, -0.087727534872838991, 0.11896714297507352, -0.26950742911148323, -0.076383563775303781, 0.15674781110379157, 0.067351658252582519, -0.036161365362733851, -0.33975475544010669, -0.04139678392037896, -0.1686537068916604, -0.29483483140394856, -0.13015470797342454, 0.083846299616448572, -0.085221496077242651, 0.29861000666094212, -0.25029825225753888, -0.13375228467304232, 0.010657555534317501, 0.1047731054382991, 0.063523091844733454, 0.023775966541171277, -0.028807179164977294, -0.096718375712717825, 0.022083787690545954, -0.015866532370803425, 0.14219126007464603, 0.0006823674706873112, -0.067860639638915116, -0.061642214430556945, -0.17742153072164413, 0.084108373535945635, 0.072037543188974221, 0.17179978390380998],
                             [0.014098655287962078, -0.096641181023656597, 0.28173062371688862, -0.12779493841644854, 0.07127803070038162, -0.24924258803490851, 0.023011815218515613, 0.020089387130111814, -0.016108822113730506, 0.0058629151010252357, -0.32122981700364556, -0.11987014023527368, -0.13373826820711435, -0.18470479395407574, 0.066640472885562088, 0.18563412989366324, 0.15105460467664542, -0.072703674331942233, -0.15598901768003973, -0.12195387153411549, 0.097200865733088657, -0.025457168044777569, -0.0084601093843667142, 0.12370488463768173, -0.17792528999231635, 0.023210497862696213, 0.26582495715205556, 0.25916574265523479, 0.055359661603368124, 0.018031418727750586, -0.13302507250945508, -0.063756394936093044, -0.090737724701686881, -0.0036376591783610457, 0.18201039405484401, 0.03307417896109241, 0.36392442796587782, -0.26866650315922058, -0.099111885578611461, -0.067023921903735434, 0.054685588785375931, -0.082506015839708499, -0.085330260190318988, 0.074699450469404641, -0.069892219801666572, -0.014187803413598554, 0.041478719346291743, 0.0041205841494118154, 0.16762645013072533, -0.10452403585731558],
                             [-0.020232260800412898, -0.25460267446516793, -0.090490982038106363, 0.025382443403933082, 0.10585850896619402, -0.29626719175401378, -0.065213510099842817, 0.19677316814169393, -0.096891841981992258, 0.16327989219197581, -0.048137998729271173, -0.0085356236085133257, -0.19967196385806787, 0.032462554023427979, -0.099719742709483583, -0.17116131232322546, -0.28712668755073678, 0.16926549498616794, -0.16009556436838965, -0.065381325068972471, 0.12124266774851186, -0.31502218241392838, -0.019645049161941968, 0.030114433576024797, -0.0035359909342346191, -0.031484141875160201, -0.1598492194267177, -0.24237449547728018, -0.060065795195233522, 0.076208058762417555, 0.17144657043500497, -0.27554032595724332, -0.17440007492188295, -0.02289177800902541, -0.081058912119174445, 0.11316728295977771, -0.094078996214672306, -0.082730506285890654, -0.1175049870103884, 0.11612850615189883, -0.20950913078625802, -0.17087113903331283, 0.07822768777300497, 0.042255533147843617, -0.050792091471008272, -0.0054446383918015321, 0.048126245640480077, -0.0109607407437338, 0.17246149706134423, -0.0053559715599966274],
                             [-0.14547398335159303, 0.01594855456145463, 0.004728592293804566, -0.1757549147134583, -0.13819882378608445, 0.076082678303601672, -0.33319990588587589, -0.20232782302952626, -0.074899353699270615, -0.13433469290644012, -0.28092027586651763, 0.052187233484337271, -0.05672775049387177, 0.097746847871237719, 0.080453242572560216, 0.021975358811716361, 0.15230603135726872, 0.20213936283273851, -0.1671579698904084, 0.11052879372245956, 0.11935905664944989, -0.075034198335607163, 0.14020086809058963, -0.14141942997062756, -0.031567981858450105, -0.1274633281053488, -0.071777725082220731, -0.10576688861042391, -0.15627688655618766, 0.048329433099573216, -0.027742894902167747, 0.084886646241039004, 0.047907652689509063, -0.18412120191159348, -0.083085364732391073, -0.04706327954657135, 0.13852325448288882, -0.028303402960246377, 0.0063360877988549776, 0.028885724589422849, -0.18229727106129548, 0.027781533652406109, 0.067875186206385177, 0.088509036583377443, 0.010403740427792872, -0.24583392086679962, -0.0023454413132644289, -0.41374528877053723, -0.25312109305399821, 0.072871893243488584],
                             [-0.035826872873367707, -0.023634358195878787, -0.065484892015695947, 0.16859775118906534, 0.073947174511248548, 0.16193372172592307, -0.049060319705801991, -0.12570789848027275, 0.1488773262032492, 0.065107787584978052, -0.22930331529685499, -0.061210172082600607, -0.045237169436031059, -0.098795942203417184, -0.05896104012629249, 0.027305958350361807, 0.24920937468276422, -0.084817924612433968, -0.1876930215525586, -0.11513957338005082, 0.059836953929760517, 0.067255236343065378, -0.00632387666890568, 0.11169278702284803, 0.097262098443894815, -0.13168130887835588, 0.011907374307213356, 0.056700250735922032, 0.046746116078885069, -0.1898192814122118, -0.0028646849509482118, -0.042931171070850947, -0.098355007839649899, -0.12083568877251102, 0.019075451275131002, 0.11496551987594046, -0.32122697470149908, 0.062932658650964174, 0.1111693252319102, 0.11219693362792885, -0.0728093683493862, -0.012783942858162336, -0.046734944423339898, 0.098954121909477485, 0.087570579842323165, 0.48592606975548763, 0.063996403064724414, -0.249820994709468, 0.20212169401062688, 0.26384415041029996],
                             [0.077175815915212415, 0.16188203887726149, -0.14827124209290155, -0.12070374614793755, 0.17480546963794646, -0.095776056027952416, -0.11224204540567342, 0.027729604671765818, 0.007009588902501228, -0.11576504985331028, -0.1471279645813478, -0.11977390038278474, -0.078178152856486646, 0.15079839163188088, -0.1932657896652166, -0.18490976272794238, 0.19672505121418532, -0.2556725089796083, 0.033123297163898099, 0.11459437639207248, -0.087158288996049368, -0.090891095311270209, -0.12456494633610588, -0.16364980350879083, -0.013336227333892829, 0.29190116879712213, 0.10443816111481979, 0.080966139473862053, -0.14783855897336406, 0.11641302344656464, 0.27284105595803515, -0.10988520232010554, -0.0047537277688972706, -0.14454142931759575, -0.092306346724923286, -0.010678390151026859, 0.019114416788417452, 0.04214443235021937, 0.026119061556792524, -0.049123001455080022, 0.096170472997328171, 0.17210353226058131, -0.15690875371719912, -0.016933604474994656, 0.10621027042969201, -0.17656705859081528, -0.22202726242728385, 0.044818667888488817, 0.25322083182935662, 0.2658554978934809],
                             [-0.032727925312121847, 0.19279370749527308, 0.13411244844211309, 0.054118236255377927, 0.094774156686556935, -0.092062449179298775, -0.013407620315951109, -0.12418587486797421, 0.32643622192592109, -0.078078194525769917, 0.14306388785365468, 0.14781034839448742, 0.0031255332339455194, -0.05854143409577213, 0.13719216347731958, -0.049883471460288806, -0.077242300527284868, -0.12666949851741063, 0.00088843772670357389, -0.28609030094517118, 0.090402637615192225, -0.3109321639434498, 0.36188350280078679, -0.12995067165672303, 0.037878572961642085, -0.14203437848818548, -0.019266850343513268, 0.061964878785992751, 0.096939866820930837, -0.071547195035537817, 0.070559962548299882, -0.072369921800269854, -0.12422769222447877, -0.26880132243690102, 0.042974410259581035, -0.013003405421874652, 0.028712056578249955, -0.042760480854643346, 0.12195523619659358, 0.15236268833021294, 0.06622662058149377, 0.31069901525526317, 0.14614129592280808, 0.045476262433130063, 0.029216020452151874, -0.12500257875607856, 0.10946262380737373, 0.19269088135102433, -0.0022871829568933016, 0.023907871051230958],
                             [-0.066156325838890473, -0.049131887847992793, 0.1552603563071164, 0.010957783089703048, 0.006097647552243418, 0.026808798714300797, 0.060977681432432276, 0.077302181129897021, -0.058446091369853286, -0.19720491499501691, -0.095801040868396872, 0.010849531921968065, -0.14979929346905477, 0.19575821167678167, -0.041335459858009127, 0.14725472182601665, -0.11749726376835921, -0.21974030192325575, 0.070693065586196396, 0.17763983982646728, -0.36022863292938317, 0.017668341055653396, -0.095053172389870211, -0.082225681361631275, -0.056359875922821497, -0.56859818037628362, 0.025616732937456387, -0.086039327347950265, -0.073803319716590571, 0.22965956544290117, 0.014234082501877821, -0.15643601527366602, 0.016038580254920339, 0.15724310316683038, 0.068068852446451944, 0.038404261560563938, 0.026926902903793844, -0.068794846839540472, 0.22758846708860092, 0.17097915578551712, -0.016058867442384064, 0.15840116780663771, -0.027781018876740077, 0.056074004044191585, -0.068460773852237977, 0.082211681394808306, 0.010294161070300583, 0.0085268426150180484, 0.047301704921474133, 0.012273871731770501],
                             [-0.0060137075134666304, 0.0093770302914702834, -0.23701425914096619, -0.25009044222767118, -0.030004131632178726, -0.0041674705706679395, 0.23144435371296659, -0.061400860369174907, -0.023299394626649643, 0.19711518560604108, 0.11766424034067538, 0.023276975596471874, -0.01447366399156854, 0.1005025063447422, -0.1317877373778874, 0.18172118177810917, -0.082704091802448407, -0.24570181950045974, -0.2598606411855357, -0.049077805685131322, 0.19170766760249752, 0.16713682784389117, -0.017140905203404937, -0.18855866951243017, 0.0075496949359619113, -0.045538166113708207, 0.15827864399516961, -0.16807181979317742, 0.074696474118391726, 0.027337071452991694, -0.088695379498601665, -0.075834325193073274, 0.039180015158427992, 0.018763473547007137, 0.045376773270389567, 0.21827186310807062, 0.071128822003288877, 0.13545475615319313, -0.087058639223342255, -0.051387368402239113, 0.036755965230504228, 0.056925181321529246, -0.087002168121208284, -0.014239394647535432, -0.03692570658348563, -0.17021624192869833, 0.44569268472679402, -0.024294095690960207, -0.065451977411508794, 0.25283852711364457],
                             [-0.17520749235611319, -0.11134678760684789, 0.070799695043621977, -0.046275734318223995, 0.12045584032547492, -0.035203267333395932, 0.064970088205130852, -0.033353201037551988, 0.016375966187722482, 0.27511184982159104, 0.13482744613248218, -0.24356745483669279, 0.23870189464189662, 0.040912388246597257, -0.040503689202377707, 0.10220058491684435, -0.012459134937902764, 0.045799385056727718, 0.18225080093621157, 0.18599443223627737, -0.02337925740297642, -0.0082131807067629282, 0.028581792048052827, 0.258445136326799, -0.12774467387515456, 0.017989719532321563, -0.12938898907090612, 0.022262039397032057, -0.23368965390549368, -0.20099490350055282, 0.029319592791408906, -0.043729396396317607, 0.11155209524847345, -0.20758158693326861, 0.22878594264380367, 0.22515028101778198, 0.0079868815408940756, 0.031745655724327575, 0.16215825965736463, 0.20601440001321014, 0.0023621401747076403, 0.14422168439193042, -0.13953278859398752, -0.0028703758573200558, 0.18482028473479656, -0.22966020074471002, 0.054323940747079774, -0.18705078354302013, 0.12351975244103579, -0.16050970171388323],
                             [-0.13122987792792404, 0.26785542082538988, -0.13953787045858268, -0.059076982018088649, -0.11414246735938974, -0.13616259128898037, 0.10822431527489841, -0.056049544051829721, 0.084695306628775224, -0.12462445919378121, -0.031447196663481017, 0.33606829837496643, 0.031154565375672436, 0.13487517249900211, 0.033366556542581867, -0.093163373803185803, -0.038668602892480773, -0.048652337815914271, -0.057469611802582338, -0.11130963809888672, -0.062836601833610714, 0.28042357960738468, 0.098391358794930772, 0.12258744637774652, -0.11149562427904787, 0.16083587649665024, -0.0034389372067884704, 0.11319199617779373, -0.2406771444813309, 0.15510966088682873, 0.21241709802580924, 0.10381792464533829, -0.26178722650907216, 0.15926775523197495, 0.2475772754238236, 0.10728462108569999, -0.16102558781603926, -0.062790950761151446, 0.053769012588324443, 0.075697874979684471, -0.1074134467285659, -0.17647410790327453, -0.0069571371266325226, 0.23698246644486543, -0.005811974887846294, -0.04804583067100493, 0.066948881808555447, -0.090139942681384658, 0.063022974591262812, -0.19285748821200516],
                             [0.15819207458264486, -0.016734899553356667, 0.10412012152024777, 0.047389175650948155, -0.01057036823447813, 0.090737764960287071, 0.097285274004632674, 0.17070298807324474, -0.25158078862356087, -0.027184837757222885, 0.031409962809310639, -0.082777648450135813, -0.51347568771741359, 0.22122301873840269, 0.18458902722572793, -0.001875877305793303, 0.15627500786006993, -0.0043720138387583407, 0.14291964579534841, -0.20538770215386137, 0.083893943376312424, -0.014538281911107188, 0.11875986486046507, 0.032792431954481373, -0.024138379731122771, 0.038539054777414906, -0.17918057578891514, 0.21777705029741878, -0.13270702566155498, -0.14129426798334155, -0.090481433822204735, 0.022360947343195645, 0.11062316723444693, 0.066952057781717797, 0.15998618097848818, -0.064047935263218156, -0.09072068583452976, 0.33440677745312875, -0.04316138666604382, 0.14768734416951049, -0.026375069063793243, -0.047866470507245802, 0.0099702019785943945, 0.10113271742435045, -0.055493088720442493, -0.16198038293536823, 0.079909694890961017, 0.032580224004593122, 0.0074777863174675238, 0.13597161208254882],
                             [-0.17194733298976639, -0.12492094534067374, -0.082608180109073587, -0.033027610379059824, -0.16260787962405718, -0.2169027186586017, 0.1288440416648361, -0.19129607164048065, -0.057634194126107145, 0.1981409197046291, -0.12758990319584043, 0.20335473685964695, -0.11013972079747326, -0.015160684446402645, 0.1053334846375821, -0.21812473623557929, -0.0011522222955383144, -0.054574107836057394, 0.18178358914158677, -0.025299136473303726, -0.1413466310859271, 0.11246974383877299, -0.090569207553932052, -0.035374093475214925, 0.041782572235543179, -0.07405468273591187, 0.01506050545150832, 0.13133241409878874, 0.084861890621053454, 0.018494280478590273, -0.4416613215787798, -0.1358522809365092, -0.15661527639525069, -0.19939348479462579, -0.17684235305761786, 0.060823142520632777, -0.24126630469708815, 0.074128964033324071, -0.14179681348446604, -0.066921664448926374, 0.050012205404786764, 0.20644013665546679, -0.097275056176574226, -0.029553269182995213, -0.089849909231013478, -0.13949130300372931, -0.19193365643162272, -0.066618498763883968, 0.042491643480690768, -0.10416687000532077],
                             [-0.022019060559942717, 0.077395849453818555, 0.083520491085795054, -0.19816691730891231, 0.22656029542580089, -0.017210336240553441, 0.16430470697508587, -0.10094193331907314, -0.046723126759795112, 0.022354623405490066, -0.077807161392888111, 0.15468869631193283, 0.12048126240871018, 0.31855311347224169, -0.085866763843123056, -0.11466329533145363, 0.001424171581119914, 0.015262188123706165, -0.20661112002183657, 0.067874423187606253, -0.095970681608837288, 0.034913894765759547, 0.033378069623764411, 0.18493386575740564, 0.046236568224053594, 0.058419906719829238, -0.21312449602152198, 0.12984708836481323, -0.067788017441895276, -0.041502363802709184, -0.17425132353625106, 0.083906016889923635, 0.077840743384485572, -0.11911308917571292, -0.16385089390159721, 0.08906076192620016, 0.21352363859353984, -0.023136497917286211, 0.0093748606759924864, 0.25556864661881568, 0.15045480248153625, -0.15148977750095852, 0.32895491064707461, -0.23924715756342413, -0.22258599245839827, 0.16657539255825535, -0.04985605132248714, 0.093150150013218427, 0.043340586865810132, 0.12859111258812639],
                             [-0.11322574773811031, -0.12909560772589715, -0.17722384303256361, 0.29402598784114664, -0.12927138086575735, -0.0065561307879518638, 0.10213603418349829, -0.044363024551312899, 0.10262819368484616, -0.24928992441901204, -0.077006308711353527, -0.32866118392266125, 0.035110035583189834, 0.12163710253610319, -0.31097503165528362, -0.15061307822650097, 0.041434513708284791, -0.14745147233704778, -0.046535199372930797, -0.22853785187115186, 0.07641189852048412, 0.12859629243780668, 0.06797614278432397, 0.05441482980244735, -0.11184126278326123, 0.088979428686783851, -0.036397290350511202, 0.0059103826799369406, -0.0036487055580776465, -0.14820162260823405, -0.040675946511126791, -0.28081591641305237, 0.075860945747795713, 0.042458451564225348, -0.061609060540950313, -0.066015207805156614, 0.037066912146926985, -0.17695566194983983, 0.05892372030954654, 0.15017218557107664, 0.052046621912695282, -0.007070312943032204, -0.039430998815608791, -0.0066286944516317234, -0.21709186768717062, -0.093475136672955345, -0.041042515272783908, -0.009360605216552742, -0.34363461431570691, -0.12193187599900655],
                             [0.13670905416187906, -0.02860753061242069, -0.18489004959156877, 0.088621217139519606, 0.045399924059742108, -0.20242257969930152, -0.3196260155145122, 0.13616054292308744, 0.058801190048452634, -0.1225498393793802, -0.036099884195288659, 0.019080898442351935, 0.17340773863340361, -0.179220524679014, 0.01833461456740727, -0.030483097263012758, 0.13621907296816535, -0.010336318879360172, -0.14112131533386746, 0.033076659864726361, 0.14818706837432044, 0.081535965497815652, 0.065227901665425247, -0.065530808040185337, 0.071435277465374883, -0.14942614336075269, -0.076311267857234799, 0.029015598954247629, 0.017494664951122819, 0.15520523286960389, -0.19150736985591105, -0.10157275563856341, 0.076146964579608845, 0.090506612309258841, 0.1948869462843591, 0.22666394901700179, 0.0072391953585598662, 0.41073538455032571, 0.27793609411580511, -0.014981340313783066, 0.15021113134343789, -0.13222550619520893, 0.084750436624789621, -0.14359831774721363, -0.14343078709002477, -0.13559905745372747, -0.10896706640417045, 0.040223663466833176, 0.1207801519570228, -0.1560186288882002],
                             [-0.31418136793161378, 0.039392753125505137, 0.041507336225177771, 0.064043642976219617, -0.097221604396245165, -0.15474682845324361, 0.0041505351283433502, 0.22662727601104424, 0.22310346286296678, -0.025924293563329523, -0.10323170757910279, 0.26623887615614694, 0.0036340613867412506, 0.016917240284479679, -0.0048081580841867842, 0.064316782031550696, -0.020934519345788351, -0.051153470797470804, 0.2921902004758653, -0.0070062763057654907, 0.3444297096381097, 0.036620812074768958, -0.29238289555068625, -0.068831511382458521, 0.10555677541796896, -0.043973421623890688, -0.2542064158345077, 0.055556446909208565, -0.022020963287941876, -0.040704460566734366, -0.073367852008290324, -0.0024027505909327662, 0.13769505873985516, -0.038958751141460954, -0.049920364714651097, -0.084824905839837608, 0.15391458197641084, -0.11280000212672722, 0.15761458736760786, 0.028824550853611852, 0.034973350745527335, -0.24328910955876862, -0.19090467272371031, 0.00028637554269300139, 0.15809059186799207, 0.00065641560075973236, 0.053584592094422519, 0.070464151804824876, -0.013773864558922405, 0.25213488136546203],
                             [0.16108036581101121, 0.18405017604649498, -0.044737077486792461, 0.086395707093928062, 0.13918733037334546, -0.019901925426882124, 0.097049309297543032, 0.058233500740596911, 0.0071705811219362611, 0.21226412020524765, -0.1078045876210242, -0.16129912108791067, 0.04976456805061958, 0.11436438514714896, -0.037652701446365427, 0.10087641978442656, -0.2578792713971283, -0.062882989312865484, -0.11566459696506169, -0.083515751386411874, -0.0065042883927807502, 0.12462651779318472, 0.18460953601383245, -0.056372794569608017, 0.097664091213406246, -0.16617290628594392, -0.070709559045521023, 0.075025225704850401, -0.15803431604095775, -0.018351891105618131, -0.082608118867305597, 0.025276651511462574, -0.29189884513961195, -0.12044836668520395, -0.16845565908242702, -0.16518239442418359, 0.27175926630022229, 0.2432882911511523, 0.0775739147794101, -0.11454195292030302, -0.15668526455664114, -0.133023566581775, -0.27287937950306596, 0.063339816381119546, 0.2036415771648219, 0.075025709095411647, -0.23620149927168482, 0.020463205352154477, -0.14654192459148171, -0.10479579557791616],
                             [-0.17928473275181464, -0.10392192652779679, -0.13056953971445032, 0.1982727144855444, 0.25899641019056158, 0.16164789263480742, 0.098636761358223787, 0.16655226062829198, -0.29676722092781138, -0.21973024745884348, 0.070329063647994905, 0.22737002896855826, 0.014774314674524341, -0.17763528031538142, 0.18859632489527109, -0.055704533534060685, -0.08469856967150638, -0.03479728357221612, -0.1299743447722144, 0.10538895767364113, 0.007556505533247446, -0.016599926105805539, 0.21697158077476325, -0.1519277475289984, -0.028816662939914063, 0.05086440587315938, -0.07130489714464304, 0.093156555631903656, -0.12243554584661447, -0.27495796311601206, -0.020567221220724331, 0.041783275093796604, -0.054894229039370565, 0.11778856307086778, -0.076790071322382067, 0.27710096578459575, 0.11585600634828962, -0.19426047118516745, 0.040903001465743355, -0.15940855865635029, 0.007941856730447748, 0.13738226968222272, -0.23847836000486769, -0.063191372544591035, -0.10400368221341751, -0.00238195413024159, -0.069143651741518944, -0.07601886413667823, 0.041518820268043086, 0.095081349394510975],
                             [0.17027732951235769, -0.093856058040382481, 0.048626606300834457, -0.01643711629431955, -0.096353034919458708, 0.1687524410952925, 0.024794933981629172, -0.047291453933996294, 0.15299546579218576, 0.0011999615329752579, 0.20752604157152443, 0.33067978471913301, -0.040818643677804099, -0.046301368389819103, -0.36550240959311464, 0.12030608324362307, -0.054285576568305099, 0.05831580944942142, 0.11627259056027098, -0.045731347131232204, -0.033418792808664041, -0.26956921812621815, 0.153619755290204, 0.13236479588736277, 0.064888630228164768, -0.056391565784967693, 0.28470143456443175, 0.24343470184131566, -0.10635204948810402, 0.081921139530449272, 0.029427557104416271, -0.11063971201717634, 0.17261150336653613, -0.046820872428884719, -0.1131908877437986, 0.096343735724574706, 0.026257763789023534, 0.078462007903093406, -0.032847314359767545, 0.021831341022984355, -0.022484520879837478, -0.23452686532953901, -0.22540885439298985, -0.00048466883180996287, -0.18685222417174369, -0.054763113563711455, -0.13061330052651784, -0.22424352334099462, 0.012640387508936347, 0.036520220268857588],
                             [-0.030696918164420443, -0.00075544933297362388, 0.12264161829216867, 0.11863091023449893, -0.15385846784974908, -0.2075751552319281, -0.14381867237594437, -0.15091180292009171, 0.15554168031079416, 0.051018188836313719, 0.055969745209508585, 0.077244915422715985, -0.15584222081414842, 0.017892321626808583, 0.014835709655433783, -0.10282042183687884, 0.097604742836889885, -0.0085225899204674719, -0.21991395346689993, 0.10960010960219814, -0.1385243948063091, 0.12501232526907038, 0.092325283546196721, -0.17862953842812185, -0.20574839542141887, -0.14426464641464112, -0.0055900658605803092, -0.042496267966909994, -0.18600978559540154, -0.20569173321392714, 0.14660592389962537, 0.054315620108335461, 0.28170996700551754, -0.064668627967403122, 0.040680695300917863, 0.094580494859601696, -0.02332883022342646, 0.0548271734357434, -0.32468613995817386, 0.044899291993756918, -0.051279755332561572, -0.11759399414205568, -0.25198105790116038, -0.26834333322452192, 0.11465759006691364, 0.13288286914008604, 0.011373893014036159, 0.28349500709447356, -0.026730609973701462, -0.088117444340501269],
                             [0.24617779943342108, -0.11736387993215906, -0.086702013070739381, -0.081381774553210509, -0.11432795924771502, 0.024048127385214252, 0.030447935760127304, -0.11798796368724142, 0.24240993339768976, 0.12920060566834932, -0.082536310800426796, -0.087613598348287997, 0.011239142975154588, -0.0071808753967945709, 0.10207897348967114, -0.032861498062917154, -0.35810555037677927, -0.11241583559673748, 0.012052727060798518, 0.045892832012408229, 0.16412054232152207, 0.058998723277027348, -0.056037092798333389, -0.098413377025254975, -0.23886137909353486, -0.03447493562322887, -0.2109032347678009, 0.28516388727367303, 0.040570138953864548, 0.00092842600098897647, 0.089498671567241783, 0.092161899731216537, 0.20352618044432816, 0.1073794782643719, 0.17215216508128661, 0.12172084942122958, -0.012743920476396144, -0.10714674074963779, 0.0027953209842519039, -0.13229881708848318, -0.23367505553769416, 0.15704299109012143, 0.17269565686705873, 0.03166456026715251, -0.13749985147068627, 0.03721994995310407, -0.30132083700651768, -0.067218061540489635, 0.0051101674256794636, 0.20129075953856274],
                             [0.0099870352147562892, 0.047615747018680127, 0.043278836376396825, 0.082169246257506615, 0.2365355982307836, -0.030441122512451839, -0.23066575880946558, -0.38696113691070816, -0.20101544665382542, -0.079804834391597537, 0.3399283913737593, -0.030595491752418803, -0.006936842928722607, 0.0090543105271699321, 0.0010101257228838738, 0.20564963253554708, -0.059134602473457955, -0.037767378559260434, 0.023478222040910261, -0.02215873893174691, 0.081496164614055719, 0.16507243986386458, -0.094215983569579748, -0.086162730439916138, 0.071287943844407314, 0.036375188957768867, -0.20946370681636312, 0.03150662084453993, 0.12501261237818356, 0.16960705822668104, -0.045476650024375981, -0.11430636108059375, -0.14330685920558761, -0.11096240996781559, 0.24876652087650214, -0.21356422773434566, -0.051662559592181356, -0.1641481282058794, -0.1190344997382002, 0.14596910759231824, -0.078924568019312594, -0.11677616203085517, -0.22454460104689347, -0.12835577748689869, -0.19470653193617055, -0.014146149279854216, -0.07861332972998511, -0.056809002340141801, 0.076405714590104257, 0.10483900807167068],
                             [-0.012189616841470434, 0.14719089097273508, 0.086651609977461047, -0.028870108663485237, -0.086705581606824178, -0.21247938579691086, 0.15176915481314698, 0.01114788969356055, -0.072548283185182499, -0.21923278991575199, 0.23616276087130367, -0.19489068586989841, -0.21848633490711494, -0.14341264958102193, -0.063607145034193596, -0.088266876828800092, 0.09636288949163975, 0.033450140830155843, 0.025861867203430755, 0.22774338639544489, 0.16807673528905337, 0.059181773542596072, -0.10856921813820168, 0.22308531262637155, 0.22365637138831609, -0.10352353926476676, -0.027944503749559067, 0.091254367203383507, 0.036276953620372303, 0.12210377029748166, 0.15421338244288726, 0.10497127609479227, -0.096696664518471864, -0.28403723208878101, -0.038834032059297578, 0.37024657419068241, 0.055227742947909331, 0.04080780554580142, 0.010520649382916447, -0.13162140267206787, -0.13746663450757723, 0.075900699544170405, 0.016877413511652145, 0.069238789829857941, -0.10656923777634145, 0.13517125746171418, -0.02671433535638177, 0.057760326962831739, -0.27415261585027095, 0.018305868137663266],
                             [0.26179592178437694, -0.21454166655221693, 0.15203815992712111, -0.11838350564393638, -0.062803590177061441, 0.060377739275766992, 0.065143195233584361, -0.11059153575879779, -0.078646345183790781, -0.15753789489952216, -0.076589036128123011, 0.00062241281613125354, -0.044120361717100147, -0.16582681091347948, -0.033174202404380813, -0.24035609890532159, -0.12428491983029058, -0.24251891983147963, 0.051284350184673776, 0.22739303380157708, 0.060119575999247728, 0.006978108591923631, 0.23275550350379279, -0.068931323686139911, -0.061751243575323994, 0.23864748963785193, -0.029112973253760752, -0.061521474925557186, -0.0087812690057614638, 0.1612112948228874, -0.25044244137320631, 0.058870536120903046, 0.025080732691186665, -0.1418994697353626, -0.039736262902370145, -0.037221500913596398, -0.13307199285004087, -0.099562956491334606, 0.31130257191935556, 0.11055671386685627, -0.16400968053152742, -0.18487085120525951, -0.10941545947716454, -0.045528365992211481, 0.21510368452540027, 0.061324087706405017, 0.23089959584563019, 0.095389388854580051, -0.0047307812505008873, -0.046300261499626995],
                             [0.17954102145783185, -0.11852224675991672, 0.092968972396046137, 0.078690647456610183, 0.048493605336543351, -0.056462751544231346, 0.058645331674565183, 0.09857794473842503, 0.27580146949672574, -0.11420132463786706, -0.033334370015248034, 0.044716668276919364, 0.15094421058855009, 0.026814449591922144, 0.16784632795866114, -0.16455134497640206, 0.09662789051145676, -0.16203566883939285, -0.0044959891898077569, -0.053989072171481571, -0.29970791345617731, -0.1894338732663555, -0.12037518100083719, 0.17756839061602728, -0.0021912350939798926, 0.073649784109467042, -0.28072061887385796, -0.083298380340649084, 0.044660532349182179, 0.10463330452104302, -0.010028869969840207, 0.012496729409033255, -0.15671253812470745, 0.032810362487432514, 0.14504037890536667, -0.013005371589505361, 0.14227399823889653, 0.14976095817357093, -0.21236519247735419, -0.15552581160876988, -0.046318243514012487, 0.032884170386331173, -0.19103257769527576, -0.18570751615615691, -0.052339847878268064, -0.013785806171373994, 0.23771839637816417, -0.30944563257705598, -0.18143386421474236, 0.11603270502028239],
                             [-0.16957094891007626, -0.062388051847425484, -0.15263541843288664, 0.10370789372296521, 0.08778106077423721, -0.045723275808467072, 0.16586261442684855, -0.16326941422118574, 0.084169000035347039, -0.03113871863156157, -0.19407568545274495, 0.1261732046047925, -0.1299405682172127, -0.22748067130489935, -0.13708177483311762, 0.23385957834180413, 0.056649130755471247, -0.15498800666969897, -0.0181932181670303, 0.15960157152146556, 0.046218798605104479, -0.10642669849455459, -0.0060126738400251905, 0.15862766701323971, 0.14149673099836549, 0.13472223405497347, -0.045512863298446261, -0.12466493924373066, -0.0011623056031249909, -0.023570061535567316, 0.032632909502524995, 0.21013142199936649, 0.064116497815767032, 0.14813049372580997, -0.017330226666675327, -0.22143637104985628, 0.11620690279292402, 0.24809369350929736, -0.041316010319450661, 0.16720805529501548, -0.39324960711058615, 0.21573725993642159, 0.02375553721280152, -0.069182756446419205, -0.16236361789611389, -0.083435670431865366, -0.031067028013706564, 0.14429327750537288, 0.11014162964890682, -0.13579589390502617],
                             [-0.026533471355503383, 0.21686917954236334, -0.19089834821484497, 0.13613677895641901, -0.050599959789604874, -0.027862663313315106, -0.11172692549804858, -0.13394150696740378, -0.20378291386520292, -0.11881159311141842, -0.22305775892903462, -0.10038060670768993, 0.11518628362729302, -0.055782022228206496, -0.18781935108539391, 0.084078797257925345, -0.21172047938814059, 0.062709865378029972, 0.19995638235335114, -0.032764386591996639, 0.092287057000642728, -0.27935942752854298, 0.07181369252485538, 0.11663229119496178, -0.10916953088852661, -0.051599792404982206, -0.05684317707761552, 0.13839446105302364, -0.25658940394880198, 0.21064814762124401, -0.21829447953415076, 0.08840266548152384, 0.0039076657411506672, 0.085302430649087282, 0.089900865075331682, 0.11123255302041897, -0.066028483408179434, 0.020140380163245753, -0.2986733454227179, -0.021181131100100042, 0.16973909328062906, 0.13349388145512753, -0.0083014004165452987, -0.070236863467088281, 0.14341956359835065, 0.17548040185921465, 0.19721829652977735, 0.12258256945288136, -0.050123199992988664, 0.09977918302424918],
                             [0.088606190074475025, -0.14315830966224991, 0.1663752757749925, -0.031882404151969967, 0.27256255171801247, 0.037004757060319943, 0.028794285159741813, 0.19489841540755942, 0.016761224830603584, -0.103743802450074, -0.087265768084341569, 0.18751017647651799, 0.096982120363319754, 0.073789317250872261, -0.11156353319473802, -0.12751835281358354, -0.075272979873133805, -0.10465737594633437, 0.05170235193728967, 0.060635986147611051, 0.3067713554468115, 0.24247243477117389, 0.040956683671244401, 0.025158176138289086, 0.16744972601035962, -0.10016356888713619, 0.13454739290568773, -0.12895896725206826, -0.26656754305131763, -0.023438943899407028, 0.010431542548220742, -0.080581979352247993, 0.13797834617973959, -0.21262296407072509, 0.23276379530020341, -0.24301645530209059, -0.12678170333851074, 0.012629591563961472, -0.281912331904414, -0.17107319572431451, 0.059513312838487875, 0.18819208053489542, 0.12085015668146647, 0.065624274922125136, -0.060003656732099203, 0.10101701692851027, -0.012313830292290218, -0.074263276061468361, -0.033591803074468581, -0.14485971524836866],
                             [0.10973206230425886, 0.16754767518167415, -0.23081128962658232, -0.077291370144004126, 0.035528593408098129, 0.19631102009363227, -0.077330568300116309, 0.082034684435123864, 0.087270172210198671, -0.032857739576818701, -0.0084636496362735878, 0.049446782299709495, -0.11654399914313814, 0.0031042325404087709, 0.049880895046397082, 0.036267895083359786, 0.012130313586630938, -0.011006237012640318, -0.26360978693034176, -0.035771623188626492, -0.11354752001022263, -0.036091853750986343, -0.032546136895838261, 0.45241821009277561, 0.02702587856647241, -0.13049951193107998, -0.17701303360528228, -0.1463438984872851, 0.035657882298588899, 0.016141384100259181, -0.20499659552526328, -0.021425879331700752, 0.23384366462935216, -0.16746559743774042, 0.042732068764339576, -0.038244410572565432, -0.13279964210855075, -0.28139304966372308, 0.011922573159670222, -0.20882147297289455, -0.024110524751710705, -0.017881728823385592, -0.17036227097367737, 0.16466730294844897, 0.032119021580517146, -0.23108661099188707, -0.062629751797903643, 0.26036829180079768, 0.065125705202858555, -0.0031513862767995593],
                             [0.022369635284723917, 0.19147074986087204, -0.015880525895344128, 0.29504832563543176, 0.32281113606451978, -0.089145654109618194, 0.16866971756932703, -0.11104853755714439, 0.071216974795321311, 0.10075308266532354, -0.23478186203371962, 0.0069334028935957564, -0.19552013143350441, -0.0058884542064158978, 0.072195459684320187, 0.055073206322926206, -0.033067782471576018, 0.13572858755356251, 0.28530385326771074, -0.031720134905550847, -0.13337687468375378, 0.13810036747576326, 0.19874936427577153, -0.023095396415502976, 0.0072469811705448877, 0.086685820818571513, 0.16425097630634161, -0.28139631706054818, 0.14005370516586352, 0.13373439929013564, 0.012529872996946228, -0.052123253127265928, 0.22690265083803207, -0.061360281897447938, 0.11259059953448332, 0.21509780328497002, 0.0049695588059851734, -0.083853793610183455, 0.046695204281394322, -0.12182970390110565, -0.040437087656214045, -0.19302234239764876, 0.13842392506094786, -0.1448372327090631, 0.047147581967400959, -0.094999184623934918, -0.061306844550475151, -0.11751787291982588, -0.10663555095234978, 0.12363106250872044],
                             [0.12471016150304134, 0.0047807783737665926, 0.24743486624562985, 0.26121022198883725, -0.19509834514749089, 0.18597377734834808, -0.013025746160770938, -0.23580128631964162, 0.07550994135719509, -0.026193029420515733, -0.14484215148492174, -0.0053552410287888595, -0.22578228839014033, -0.022979684059992407, -0.011774966898211376, -0.023417039818557434, -0.32637500652807522, 0.015874602030117035, -0.16420612063398279, 0.046480459875622174, 0.10519737831836697, 0.074874740213937543, -0.22437806982285477, 0.086905456733721409, 0.22054980729853874, 0.057270457329148053, -0.015508302667647985, -0.11686318790996761, -0.13030347830635985, -0.095805331770131535, 0.10994719958531171, 0.11610020694713327, -0.1685956643593062, 0.028851300682994435, -0.025294752755837289, 0.093847809466593685, 0.042195630264368379, 0.017870130263075368, 0.076899255836260061, -0.014654675618314617, 0.39846845349376014, 0.027394840636090337, -0.0011055211132712096, -0.12513361797494246, -0.0076065330603997568, -0.24776703740354317, 0.0278467153145797, -0.070468167991431893, 0.16600671652237761, -0.045629427712275322],
                             [0.012630306434338946, -0.086053581643363852, -0.28812886442798502, -0.23581730597120409, -0.19274744154927281, -0.14088167741640845, -0.086951555503287981, 0.0054405801254667624, 0.0084548024020793776, 0.083911436024380656, 0.062067947670844954, -0.060889126109076833, -0.13895860052829612, -0.14389982823167269, 0.14171082986524733, -0.16725762421586177, -0.079459969175134412, 0.11925812892691857, 0.13894864594190906, -0.081194882547904704, -0.090090606614720736, 0.10762182780418141, 0.18276171929639781, 0.19779049500916551, 0.18742347916065066, -0.041698012219266174, 0.19268994938597434, -0.14682188442302188, -0.23112750939598103, -0.081696784723096938, 0.034215936435611737, 0.020866497820921943, -0.047624353851583666, 0.037054709157472873, 0.20064509727490845, -0.23057055954477992, 0.20762568895403655, -0.094085685852241502, 0.1901947541534505, 0.087516319531349002, 0.10930982707581575, 0.099829705656561046, -0.092625890324208454, -0.22530668758147823, -0.12602086511335175, 0.17820269773527014, -0.030021893638324363, -0.010271712577163935, -0.010201670611259924, 0.26019157057102849],
                             [-0.079972797273192883, -0.13241733901885072, -0.27871802846417471, -0.10116717572071585, 0.23465638080430473, -0.009046784880086001, -0.080156209664233966, -0.057493895398099605, 0.37663266615377811, -0.29381476388364108, 0.18856938894585321, -0.06892909159126355, -0.32028796980588176, 0.049366323937335456, 0.033810510970546666, 0.13390957387295363, -0.16511805483552619, 0.077129998983620371, 0.061660416777765188, 0.23176703684132605, -0.083374929579143719, -0.016964080646869648, -0.096884842027768592, -0.058255722905270792, -0.19869120953839964, 0.083243918005168796, 0.076821878632742202, 0.019259892638858307, -0.034266473861932593, -0.1799171945933247, -0.22303598091317969, 0.012316632520231399, -0.14556889381050234, -0.076207178871692496, -0.010259653631658107, -0.037551890709497437, 0.06615720128076201, 0.11943171820859907, -0.069769003099769702, -0.042933325253358981, 0.16320032745697849, -0.13245597917348889, 0.15214174600286273, 0.15819873936645862, 0.10257968636758677, 0.1090359337186869, 0.04288911463410737, -0.071971893816570084, 0.0012582026997582567, -0.090376732549503458],
                             [-0.11168185793584835, -0.038010349268011077, -0.18294538605519445, 0.086411816000146274, -0.044049928622135914, 0.3492024785850989, 0.029735871455041588, -0.078161321632842451, -0.045617207676147471, 0.1776848496508342, -0.13080632559201558, 0.056754571203497986, -0.046056199559047724, 0.040067604807850501, 0.064367942312477833, -0.25500901565492706, 0.045738342648187998, 0.043577960392736544, 0.13508413300442212, 0.19635986027585506, 0.11853315086399135, -0.0050044837901162187, 0.096098881255670385, 0.019315414928518165, -0.22857626042079415, -0.085301651702784045, -0.086345928298651592, 0.012008689527550171, 0.26114585234111048, 0.18786860937500152, 0.24411375920477132, -0.068426812094363507, -0.031688933707804401, -0.21746247654274159, 0.10423410823276673, -0.061969707144725321, 0.28489814296508731, 0.14725753169824632, -0.033212379509362559, -0.021001515738709141, 0.18239100597231633, -0.066545495076990091, -0.13940083322020286, 0.15139013632001286, -0.2119171005207505, 0.12809596646908653, 0.12864535124013854, 0.11728433753835424, 0.1030463781292707, -0.13541042091615216],
                             [0.17015699029970074, -0.055521902992105847, 0.04189614943284839, -0.040186958046234636, -0.16714781186475614, -0.0087850125227071398, 0.31665242403410249, -0.053434367185942029, 0.037220405490953935, -0.26455353963381012, -0.089057012985693865, 0.087834045600051813, 0.11493898728378953, -0.094538366367709889, -0.070017307458597133, 0.21079217484736046, 0.068688598487679428, 0.50296448175361141, -0.03898320373519383, 0.051683082784134464, -0.051818272012765704, 0.19163651845748744, 0.066046692592072256, -0.045418564480495367, -0.10225743795905028, 0.05029521433887639, -0.18869546293226983, 0.0093288195981463123, -0.035349210453911192, -0.013411233759927839, 0.052334407224702048, -0.40691749537702965, -0.0878178881954014, -0.08911745484850131, 0.0027129754540694009, -0.079535287189295631, 0.028940375311230806, 0.099824045449100035, 0.01431446323729235, -0.086693226738634901, -0.047275088939909872, 0.14436509160192382, 0.0044161983131053703, -0.0372298753011025, 0.095902534406829137, -0.023161044311869376, 0.033094237533476296, 0.13598694142360279, 0.15700868677257457, 0.17273855042409569],
                             [0.12540173116450148, -0.27590425329058055, -0.028753030788879218, 0.25177138952944644, -0.063856889024960464, 0.0091810444750247931, -0.1158923439493942, -0.16250296782140242, 0.019144094684137705, 0.081685326728782759, 0.058756723474560207, 0.11740465403101397, 0.13415178352325835, 0.36841685349197384, 0.22854527440876971, 0.15761554149015469, 0.23243085611994921, -0.11124646823734921, 0.10184570761603301, 0.15324538435864246, 0.18836089742037893, -0.063842837902430713, 0.014387149144539603, 0.19997988942962835, -0.06269762181428723, 0.017626427878982057, 0.21462875375782267, -0.09331646808375442, -0.18622363904205091, 0.0061642503632978038, -0.030908641442038427, -0.081456366751949671, -0.2745688350054632, 0.050400736753584863, -0.055912983424120107, 0.1128766087680631, 0.028338996156000253, -0.057570707136881387, 0.05189127298135799, -0.12149145621203161, -0.11501167440241621, -0.023766670745787932, 0.10248149718466637, 0.012041465654173496, 0.0066348661411414021, -0.027947980397244176, -0.060737183580652693, 0.29269987009404047, -0.086184767251353309, 0.16156007692782118],
                             [-0.13845740536795986, -0.27000952446309617, -0.054199937553199462, -0.070908361960010949, 0.03377123365492074, -0.14461616795167409, 0.19699753675716844, -0.22367427792079322, -0.16012047645667662, -0.072173010544996488, -0.021569586085780211, 0.069763847119998557, -0.045727399263578168, 0.2479182497806936, -0.21386768165695802, -8.3172879189763753e-05, 0.051816309688123188, 0.076086299831050586, -0.11578841379525284, -0.14212791000996519, -0.0018299569595187721, -0.26923960507870914, -0.010120096241387025, -0.053194967462157183, 0.042150831071104046, -0.083450016949668485, -0.051262616846909734, 0.040570283430894021, 0.14494019647196665, -0.057211045854256279, 0.10584383761874618, 0.22548397646495913, 0.02300581014613538, -0.023409961137341957, 0.32177058288831029, -0.10425390320066208, -0.096535236844995057, 0.037213039132425386, 0.26839635765898595, -0.38030597651598619, 0.11924315217168485, -0.053186964900563821, -0.040816959663867211, -0.11261567393153898, 0.17313976699075032, 0.049523441701629964, -0.0996001695664884, 0.024578390220434076, -0.064254477500659712, -0.073553920442253007],
                             [0.26511128608927365, 0.0036007344408022801, -0.20952087901643168, 0.33368389490853967, 0.068293779925716294, -0.14716687273684192, 0.22679784750747958, -0.039031999052511895, -0.14214029601461525, -0.0029047351735258286, 0.15646525458993316, 0.10798954317589626, 0.080090042938292583, -0.1555349268358838, 0.0016761430914747444, -0.21702897641144014, 0.098680969460361853, 0.082807507347469875, -0.11146178025391223, -0.01594400953943019, 0.015579821551912303, -0.0076044402670177331, -0.3002382490998009, -0.021229274897756226, -0.22614187503748479, -0.25432457146827747, 0.17199317519112114, 0.063703840295210354, -0.083846154148871699, 0.024376326668190659, -0.036040600982466378, 0.22143304861613869, 0.059922284150045836, -0.14362372534083553, -0.013431408670820376, -0.20629503179052897, 0.13003508645580028, -0.071675974689860256, 0.033360488704989123, 0.21226883372327543, -0.01919475727719943, -0.015854582124750993, 0.1241095181396735, 0.090425769673696685, 0.14694789911887698, -0.14946468547769323, 0.055927551250653802, -0.12556031967681111, 0.045521924739704664, 0.096197980289953591],
                             [0.24737148331470984, 0.27581407641880146, -0.0005407963023856885, 0.080054537788726884, -0.19720436910203434, -0.15683888738639584, 0.038740163990860936, 0.028609267096983894, 0.025562585978217769, 0.072245626858924827, 0.039575779264926003, -0.01182991849719869, 0.0031822391150771318, 0.16900757530561886, -0.2601326403794833, -0.06491140478891079, 0.16785594150301311, 0.0089827223612183767, 0.13582719471302482, 0.28553108782028586, 0.026330323439043533, -0.13114860736019551, 0.16149883045515853, -0.1832254992299889, 0.11234527207301653, -0.038316591353010236, -0.12643244117651081, -0.18664359088689131, 0.094187363147318501, -0.32200212057879324, -0.22707918326017801, 0.068635482530799985, -0.10605971004418188, 0.12320778361392833, 0.16084321610203783, -0.0025113535054939649, 0.098632718099506439, -0.20270361732104655, -0.046317366248770669, -0.080946829020022204, -0.024221367439542698, 0.0038110844426583754, -0.0049861338115762648, 0.16532590273603509, -0.16726346124123989, 0.045596267170028223, 0.020734580804122594, -0.12175025740285192, 0.23367522501111773, -0.057156437707716175],
                             [0.068642431447371546, -0.24409862076866015, -0.021205756198609035, 0.12276659961885049, 0.046204437694046474, 0.014182391723124492, -0.32064698201829145, 0.075296382548284704, -0.017436032522792407, 0.047978722296168147, -0.065529268653063175, 0.16368566131045895, -0.021526715324596445, 0.10865227298482162, -0.2611079420738231, -0.086882605306343244, -0.093088409240297487, 0.16925465166869069, -0.0036607646688509412, -0.03974361370547605, -0.23805129861405061, 0.22069864046066279, -0.011175101637976715, -0.011406266791932421, 0.26736582970658918, 0.12307541759820459, 0.033105467672801987, 0.18816539714660313, 0.24706353892123406, -0.02568668950342911, -0.044007441962621734, 0.097089556421925641, -0.011684184277945611, -0.0085627378667563689, 0.17456720305022908, 0.17555118421422056, 0.22076434221663657, -0.027929108003980681, -0.053751055548388341, 0.166019516262777, -0.11306812242937926, 0.20596316760991765, -0.0041972920065832704, 0.22322323866734667, 0.20995825931811776, -0.046726200279882522, 0.097164310056227429, 0.15680833127040533, -0.11754368856335025, 0.079415464805301275],
                             [0.0027267631966394249, 0.04869530672791389, 0.062387084758353417, 0.20915256937488541, -0.095831618879501743, -0.15661959407216258, -0.033214260463393402, 0.28434271338414069, 0.062249667332227351, 0.075542038263462327, 0.05885415215371919, 0.064266274760011483, -0.089023743322089607, 0.23912867301627797, 0.026093532317567295, 0.20599485402097631, -0.080412263686050464, 0.16926210502122038, -0.21500765143114853, 0.03909852725290721, 0.081715092691251712, -0.012840183041053822, 0.028361775984699446, 0.0008280682473605145, -0.23972596629854451, 0.29441416729725073, 0.083137348605024572, -0.077963059002573901, 0.066572545592324062, 0.24833094049833013, -0.13081942885956224, 0.18605995154514962, 0.081585950614093475, -0.17618253386256069, -0.031650370130375631, -0.066462936997346581, -0.10341503790518462, 0.0093819707826573624, 0.19113583783879909, 0.079073458316081938, 0.089771156300470709, 0.32213374887855167, -0.20307942552429284, -0.049278142464376021, -0.17721964605165474, 0.2117688572403143, -0.027316936843359622, -0.11513480573162845, -0.024523440002451463, -0.019734419975273001],
                             [-0.11174631558515483, 0.23028686983235086, 0.25400075525459442, -0.0056389888846890557, 0.17881098959297642, -0.045703161940480561, -0.18064506464510699, -0.14432985677803523, -0.037892892877022688, 0.10782683175776886, 0.12384298909158223, 0.12799492987049277, -0.11742814607509088, -0.041952310585422224, -0.19145875557983189, -0.30177560915926183, -0.059714119961842088, 0.061912929403810067, -0.060217547682853603, 0.082538460979366887, 0.10925600764850753, 0.056253287064316697, -0.049582649755479664, 0.26098689488314752, -0.29968580285739121, -0.01123328924783999, 0.057075668326273823, 0.011128630013714483, 0.068344001414295086, -0.1016661268630749, -0.098695911580927484, -0.23301841205168225, -0.0048459151716324575, 0.3345854564947936, -0.053661786677602241, -0.13301874752333262, 0.050130198643790494, 0.16575477907804056, 0.2031478621304682, -0.21068515288254161, -0.10506073370904463, 0.15622081121309647, -0.0044335541541763923, -0.0067771671300949797, 0.060688427113893682, 0.0087308408860786221, 0.080354934597030428, -0.039625651430866611, -0.090314478809091214, 0.12179036226486073],
                             [0.075931872494187577, 0.006823108291441878, 0.081278215252874611, -0.21954237403004342, 0.20502789193377674, 0.053305652208125512, 0.085091062370725903, -0.031855878038191281, 0.13204381870854434, -0.2175636161244934, -0.15564874743431498, -0.096645453409199542, 0.1536498577817163, 0.12541177191033634, 0.042871294022668364, -0.17978603492746659, -0.048961837563334068, 0.28357136063606614, 0.1048613989346983, -0.075986904970762228, 0.1938731900235808, -0.0247528450536471, -0.08953388631627808, 0.0038201639307615153, -0.089740703557525461, -0.14756957426481823, 0.20104547788956006, -0.17615778549576216, 0.1595384796048521, -0.10311481883708247, -0.055412571032868577, 0.2514726819481698, -0.11992893653521666, 0.13665401446874134, 0.011598547702369422, 0.1424519338746881, -0.14563992149068758, 0.081292556635362043, -0.060464738064894448, 0.25518203532772882, -0.062684942708811336, -0.004185584247879931, -0.3732794476387295, 0.0071290108479635413, -0.13466832452940669, -0.10405118571584528, -0.11989226704639867, 0.15081104233857834, -0.0099208985618333047, 0.073065196105229588]],
                            [[0.19290704076097262, 0.16428801717876179, 0.24639181474955088, -0.25228751466626143, -0.20363429945937825, 0.060180282920312841, 0.23863817103777524, -0.093469556418304067, 0.062768035522208596, -0.021283611946440562, 0.11677233356694816, -0.085452708176916414, -0.13650533651769958, 0.1023591766210597, -0.090986136104042312, -0.090298688392166301, -0.19744625643855429, -0.1986081339522891, -0.16676086464218084, -0.024032055070993968, -0.018524743317146743, -0.084748058251869596, 0.057467193478945321, 0.19086557219246145, 0.15511251653156988, 0.10235495562284024, -0.072021334591978389, -0.15877546246608193, 0.051885010785036184, 0.24436809370761423, 0.19491653730388403, 0.12403272749847218, -0.098647518128039097, 0.020325394358801312, 0.033377978709407438, 0.19371958491413341, 0.028850359789105003, -0.096787413307420106, -0.24945909304623989, -0.19249036083386598, 0.18321040924730825, -0.20365567387251737, -0.018392007251394032, -0.011012576375396042, 0.087986152298644538, 0.019527880519142542, 0.069918622350032836, 0.16902469702222031, 0.031267715802069947, 0.13664090750370361],
                             [-0.12879955543838689, -0.043439201037819557, 0.075255835082545894, 0.071871026721200645, -0.044195418706313362, 0.098760150046071318, -0.074975564240247677, 0.01458368610736741, -0.28357394864221985, -0.19714583016727108, 0.056222355103536167, 0.15405726017078752, 0.12389702081143995, -0.089523328724018233, 0.19025979072261467, -0.21296682718150362, -0.15485554482121092, 0.16139467735550803, -0.05793886845955238, -0.16076161581030093, -0.15528579295881514, 0.18232186008249701, -0.20968929913755496, 0.04718569288127876, -0.072877038779265338, -0.18685358912326996, -0.1458284969473353, -0.19299302832399365, 0.12817038549144683, 0.060862096403986793, 0.069053976609229267, -0.13446218084524722, 0.024956193250587452, -0.26183771877569423, 0.045264446383047933, 0.16024541168256895, -0.10207411527956652, -0.21589267440062287, 0.081427185401705779, -0.12760301904845045, -0.099031998375698371, -0.24053408409813573, 0.033477044129848109, 0.13706581938184453, -0.15835707857277326, -0.01266073282757527, -0.10785915635605819, 0.053507615606529751, 0.24478337020089527, -0.11612926775326335],
                             [-0.300118011585078, 0.10279664648955975, 0.037215304899525396, -0.067717349177596087, -0.013274276570879505, -0.0015200893811726161, -0.071460762988177079, -0.26952957038768077, 0.20880075918924992, 0.11600694789032304, 0.054108806219535122, -0.17960758687862452, -0.049358808360878491, -0.11737864677184581, 0.12346819781078822, -0.021394375556164639, -0.20634309576238352, -0.030898085242803394, -0.11370742275808958, 0.075747592199694694, 0.045922655692860151, 0.02291680572274463, 0.026456115177994143, 0.089161349617393304, 0.086175238457614697, 0.022501199556564187, 0.11266604478942151, 0.019668457604473787, 0.12655036469705772, -0.085402105750497531, -0.10007405275036903, 0.20960696108237362, -0.11155350010162253, 0.065138202947426782, -0.027631206450046211, -0.11593158064701539, -0.15013712529312928, 0.0013052676489003798, 0.30667512611330239, -0.14755367623048005, -0.066251134516314147, -0.085284490303041166, -0.10978991117123252, -0.291651991436013, 0.15071178515631667, 0.054221425121772866, -0.38171164128049667, -0.11300837011084935, 0.22163864870069488, -0.090897988002899499],
                             [-0.11050450509047005, 0.058876284980009894, 0.093388795561122229, -0.031295039135973854, 0.030136446975721168, 0.038712467481970644, -0.10117993935220471, -0.20997530663272504, 0.074669977246184141, 0.25280442233454248, 0.048281969257415062, -0.071451002615376416, 0.096029531179587332, -0.0047931880196262558, -0.19477611357244973, 0.16954020672130185, -0.29021703184118824, 0.17304445135990512, 0.24253528052170631, -0.092321166259589735, 0.036294437829521617, -0.11675381431890151, -0.14017907271392058, 0.028847398477787237, -0.33914571881811856, -0.18168555666533157, 0.11116830382029597, 0.12516995239022397, -0.13344287543469022, 0.11955545186499264, 0.042910244079015274, 0.025237815911509469, -0.042102255853501608, -0.11739657649973709, 0.0036935198098678947, -0.013697373046181306, 0.24957917510773422, 0.14664508406347163, 0.030577832567400858, -0.087260108229559194, 0.032957420892574182, -0.094506223619384919, 0.38551708871517115, 0.083811147608906011, 0.049406915512291358, -0.1475005829762206, 0.044154902429914794, 0.17778514957689384, 0.046775696818522595, 0.061233399123268008],
                             [0.05636841070546901, -0.25198324940133998, 0.0045965911986641413, 0.15012881337949077, -0.050427979532620737, 0.018192842466771698, -0.14011542966979537, 0.042626333613649849, 0.17091394427125614, -0.21045648069528355, 0.11332564381156317, -0.005210163679205234, 0.0028307861782875588, 0.28036059668453883, 0.059536200710809672, -0.1764970639222101, 0.05543021309354397, -0.094391006369069622, -0.03135950166312651, -0.078515829523074773, 0.081610885011290032, -0.18951558492183124, -0.10137467493142499, -0.090410896769350102, -0.018366403819408361, -0.032514796508469078, -0.031396750393811471, -0.30883159494096268, -0.032788826183228419, 0.042910337918591591, -0.13656877861778088, 0.080870124084702719, -0.38231605235762783, 0.015484640863123301, -0.089186164167595366, -0.084709647412542152, 0.22290042892279066, 0.10336853468866111, 0.20072153047545091, 0.011100506273123114, 0.076442317605112095, -0.023141827924889429, 0.17939219704071352, -0.067498417228039093, -0.045330641591733625, 0.18012344473869304, 0.17591682918048929, -0.21655636773967091, 0.19512673158452917, 0.15776993637902592],
                             [-0.46221112909753503, 0.19716610165712567, -0.068560184736088797, -0.13910171529249343, 0.17794096841031529, -0.013393792507940538, -0.080962960069228415, 0.1229147310549538, 0.010707461210057358, 0.047776045549197718, 0.17972254505104132, 0.075663718866792379, -0.0044319001064111237, -0.028823565827921602, -0.14632217983922247, -0.106295968501257, 0.14252907591796191, -0.00031459947073163768, 0.11302340521572043, 0.18987868700315585, -0.070590513674685482, -0.07939050046630873, 0.18389994859330555, 0.0077216971296589082, 0.13199485290675117, -0.066025230567466661, 0.2580523079000816, -0.17481707269608335, -0.018051621899600311, 0.030050238522881252, 0.29100764301713899, 0.069523927380078329, 0.07374997396160371, 0.038413168328207167, 0.0029873448689484092, 0.11989690660310445, -0.094592782502740336, 0.1323907140892108, 0.031244634391698559, 0.088899559091308575, -0.02719387581591412, -0.11771926445714802, 0.038642075149286435, 0.20301013549917982, -0.15519365457427703, 0.30118746246529932, 0.15352836276288942, -0.029304685192549855, 0.074961511024157199, 0.1146957057432999],
                             [-0.097999166925060291, 0.058001485489230828, -0.14039338332824472, -0.088292911767535315, 0.21336207133950769, -0.007145516144244279, 0.063165181815484181, 0.10921534025055028, 0.25257429026981221, -0.0044982132817796205, 0.14504796088999569, 0.09507457755726452, -0.064330183310821965, 0.096590424356922208, -0.085895173182781129, 0.11557888178275348, -0.0029168654492364439, 0.090213104642372657, 0.17338631680412078, -0.22158298153134767, 0.050313217022320084, 0.22995195265221138, -0.2351070753439958, -0.057991435111357542, 0.017206016142202477, 0.089498390275275536, -0.21308912622061174, -0.23361328893115965, 0.11221692087767679, 0.33088417928560826, 0.062554547691657497, -0.10197151044291676, 0.075836102484837964, 0.038255732705398671, -0.023464060719710213, 0.12103570076351901, 0.13613172691743161, -0.034357840850320259, 0.075327591415084202, -0.042962824056480421, -0.068824051617256493, 0.27233478448002502, -0.065983761152027087, -0.073986579277319289, 0.26260271035106353, 0.21771727094973709, -0.18749508029106535, 0.057963858676737118, -0.15753673373480723, -0.076375990206890926],
                             [0.033769077647471481, 0.14886670049222325, 0.052420713194737796, -0.066273883654732246, 0.19105222032970623, -0.00016550248837794121, -0.045821572047508308, -0.034757271809213425, 0.02142848958200478, -0.035084153517840139, 0.10026569880251973, 0.027892193466366115, -0.068092911152409882, -0.22722196319886565, -0.052219452792449758, 0.024327015275348061, 0.014525606213682636, -0.24804997348496924, 0.19785445937668569, 0.055540860007657102, 0.42472735122877403, 0.039480019857972927, -0.075791447935862954, 0.18092210512091905, 0.091698984143167739, 0.00058422981679243395, -0.090753404919333661, 0.031925925287870888, -0.092512531862420977, -0.038099585073101197, -0.29968510083191108, 0.081934480977926757, 0.083971477565152094, -0.084362689728041021, -0.26477274727459321, 0.079093450578510124, 0.056107724399697669, -0.40675493790150641, 0.12432103344863255, 0.033745521919268419, -0.027236052580967507, -0.057382296300614165, 0.00168015076045834, 0.15950830675118244, 0.0025489619814335293, -0.048782532639943837, 0.27931365737169955, -0.06972093040781098, 0.095377269666339165, -0.097379383411770742],
                             [0.011847450580810541, -0.12402637095223486, 0.35468280666947455, 0.044260875732584408, -0.06069657510721288, 0.011002254615423819, -0.058307817049399045, 0.070486676508133894, -0.030202785492723386, -0.020621125232624618, -0.14358054927291811, -0.00072892086097701178, -0.054303905311454542, 0.12065125967882163, -0.035357350301078533, 0.10381076882932087, 0.051746976246158559, 0.029228114681567875, 0.1736706294619744, 0.032887897901726741, -0.02017274740790918, -0.045129540131173117, 0.024130584236022965, 0.26749332669640868, 0.061190672314635819, 0.12901457037502181, -0.12680960331131552, 0.22391727125291946, -0.022618151119742802, -0.076857272268853, 0.23509674236081582, -0.32469538196259951, 0.046656537713192232, 0.33023147437174366, -0.02749878149540342, 0.035538775266286925, -0.073660473368474366, -0.13867081243457063, 0.27451972018959125, -0.089147096685463986, 0.035701996685850543, 0.18203033107220512, 0.12858484227492878, 0.13872813010243951, 0.029017717294578943, 0.12821123578096991, -0.12053104281328747, -0.017241261278295606, 0.26797320687763598, 0.18618243099340259],
                             [0.28235289840051675, 0.10792827895394763, 0.012990276191608309, -0.022160586223295545, 0.016821733288041093, -0.31287486360743583, 0.14525996579395181, 0.05917342747625224, -0.00044533033710193298, 0.067493715707050442, -0.051227612565060247, 0.12911683478352975, 0.24153186064674489, -0.14897566193468581, -0.11421100738943003, -0.015017727379517508, 0.14828365059540366, 0.11814399839427732, 0.12280314966103793, 0.019055767872884224, -0.11082448216663289, 0.37005512827952691, 0.004778971286455545, -0.020450327481939964, -0.0099892615676358595, 0.26327239582698203, 0.21772364831980018, -0.22938111695969801, -0.11522998601966446, -0.044178451163156482, -0.068652749656966494, 0.2037930957660555, -0.090192744695704916, 0.033046577815817268, 0.18354179817454103, 0.0093117113198200197, 0.018126468638557939, -0.049965551223751223, 0.089386735042852064, 0.0542808330334556, 0.0087467323319845251, -0.073948265110466288, 0.13131222788625085, 0.032290687969998427, 0.1234710395812971, -0.11933950787631918, -0.10068829923307819, -0.04278817411952552, 0.28109499141019767, 0.1857894237031851],
                             [-7.6772412743195198e-06, -0.0078271888082621678, -0.07234308803444163, -0.20823145891400927, 0.088484607905050056, -0.015153853919774859, 0.046407627319402442, -0.15122615750304969, -0.14841270390301201, -0.047308809158866032, -0.15754557191427332, -0.061694297241003927, -0.11421775311439081, 0.23180555196231195, -0.41013822352349011, -0.2784367365708541, 0.11856931809262398, 0.01856467625469858, -0.058474970152666249, -0.046387652009768549, -0.47045269934720524, 0.027511256129572968, -0.025403783620056353, 0.13174655039978925, -0.021684937551954744, -0.0195811713801778, -0.052949022242905291, 0.15446015548338748, -0.1552227685708317, 0.020261934877232195, -0.23408017729414962, 0.16920453772400959, 0.085620578721419871, -0.12369133949895193, -0.18776915512225251, 0.033047428600233207, 0.01057297269680291, -0.024138623651295481, 0.14195733011720221, -0.15277031045155096, -0.053257478692137594, 0.14596340907157712, 0.033572089453859692, -0.021242832162575519, -0.0064790415512797376, 0.084829973750084137, 0.033689003325267468, -0.080253935153431946, 0.0024901328473784772, -0.11680546325094948],
                             [-0.11676092005678129, 0.067942423710396369, -0.057704304911205845, 0.052267963509550951, -0.037124485694809722, -0.28503751436978281, -0.21543542312012945, 0.084329716754431266, -0.05638278690297821, -0.099174301691635575, 0.20998999841643887, -0.044263952965920568, -0.079492101169963331, -0.019453042698799241, 0.043253319888325786, -0.008084544231884901, -0.12664331755707425, -0.0047602355385404768, -0.28470680824662908, -0.062407012130116006, -0.042310787106197671, -0.13064757371462088, -0.28426353896667439, -0.082192822299577833, 0.23673442002288991, 0.12004808829610915, 0.070647703088659281, 0.065450827019736091, -0.41896351208352228, -0.059747285668736383, -0.15516027455788614, -0.078685990362066138, 0.10280225908884201, 0.054062532539153683, 0.038132430786440401, -0.0095742218192721423, -0.075622869794711584, -0.075618048465063675, -0.16595584867822324, 0.11333111441218069, 0.051360389598121295, 0.12705097930381901, 0.18019129283036703, -0.037255751533277516, 0.074991824906278703, 0.10424774927381927, -0.073983960333892845, 0.34446374995691703, 0.12243459995939622, 0.014168118188716002],
                             [0.0056338706247099557, 0.26566393449001607, -0.1504294958670315, -0.049851068574024368, -0.1782917207881449, -0.21027364574510191, -0.074092162794365313, -0.10855423928681489, -0.1893878152535389, -0.10752805432074125, -0.10033311437835245, 0.17152873346142408, 0.2099278410482619, 0.38700284359524856, 0.0039571479801369805, -0.085961129739009795, -0.011523887024770736, 0.040220238877815194, 0.066278439513416484, -0.095678254151191508, 0.33788417663029852, 0.018529184945982595, -0.030507266248774336, 0.16802897142689235, 0.080247891134665073, 0.016861449279118628, 0.097859044996920025, 0.073664455173148499, 0.32891864636504381, -0.15205650356410977, -0.0042618003825839502, 0.028460797498723326, 0.14305949442878307, -0.10620705907548388, -0.016218439064628207, -0.11770942502555512, 0.074952383505175801, 0.1465000328068902, 0.088718593580759939, -0.074824239922389763, 0.0041789370586272426, 0.081116615176035411, -0.091434975684452968, -0.099978165825607493, -0.0097202689062851327, 0.080434115866051412, 0.1002766744488032, 0.2656074997396301, 0.036071053725746198, 0.10082139418598575],
                             [-0.28009069389368324, 0.031879136058376473, 0.062819293404113047, 0.13821788884612518, -0.16939886490831135, 0.0022344129455131928, 0.28891687432582436, -0.0071723436348613704, -0.073566501312303134, -0.012163091393830584, 0.036354761924261368, 0.022377538961463078, -0.015220277733203834, 0.20751174306686049, 0.061759784437873819, 0.21524504179973533, 0.18517269952566115, -0.10032813299348396, -0.08625165720797924, -0.048953120740170671, 0.059688655520501198, -0.11868767792003138, -0.3013261336965174, 0.12186374313068506, -0.2861348062307022, 0.10930818073590969, 0.042391379590544322, -0.19874141469859433, -0.16015344136485138, -0.2322265683079161, 0.065565535097707114, 0.13209710434204208, 0.18810302779545499, -0.070956712422425877, -0.088978582214075633, 0.19310464571470132, -0.20260520395491366, 0.026281456481711325, -0.0039546195854592769, -0.052458482950907971, -0.045200259968532455, -0.01518670167248963, 0.021238730229588023, -0.0036626414581267886, 0.1824912524386138, -0.15730606606498374, 0.010096769470412508, -0.23869759871252846, -0.11522041373124979, 0.096092303285008715],
                             [0.18304124010642253, 0.031506149750064577, 0.060982018551890171, -0.15376816011660488, -0.10058836371888251, -0.085870022484343805, -0.17059238471876803, 0.014614998426854112, 0.28377828696204199, 0.18320296783064602, 0.078967173236406896, 0.160058757992735, -0.12161923310036361, 0.0068028879897412756, 0.04610182461957147, -0.19261911950504063, -0.10046989982293728, -0.015699501945560791, -0.17210781290481311, -0.15043464115081542, -0.022962328921256374, -0.044248641962709757, -0.11452661899989702, 0.024247740068601156, -0.089672057716864484, -0.019097156126334981, 0.084531289039269125, -0.0014645772508010873, 0.10585818685407485, -0.057305170195031022, 0.26845534228901397, 0.17638154473382928, 0.19107219210765936, -0.15150613985134304, -0.10341325824647332, -0.18646297180627008, -0.023047157311406146, -0.20991118065785067, 0.069193539314879551, 0.24116494178542178, 0.016069016854005694, 0.23911579448034606, 0.059668702155090098, 0.18204914552476842, -0.25927348142617007, -0.1000977672317889, -0.16598283079109374, -0.18935428247673849, -0.12383230088624303, 0.12934183555571874],
                             [-0.10593606357676175, 0.18781598671481775, 0.045500966532039042, -0.042477875158186684, 0.19355655194300814, -0.098282502789447987, 0.046126949712668404, 0.036117309717091796, -0.012818973718838417, 0.016027025056796949, -0.25524611739812425, 0.0039253553993934057, -0.24983931970743919, 0.10285589557406301, 0.24097240966331004, 0.045234256119916959, -0.011945304402454244, 0.13037466235111106, 0.035740632097517613, 0.0060981405966605163, -0.034939015273269813, -0.027084421941322517, -0.19357870654332959, -0.022164807999997073, 0.15772752524991687, -0.028988951308461117, 0.11340384569232029, 0.0066923572631928593, 0.010311462340142736, -0.057685008279075987, 0.063909635063948214, 0.038550003719801787, -0.051085028629214976, 0.045944886115937368, 0.35353769578056393, -0.23359955765431206, 0.22731583779572873, -0.20632717603713036, -0.21752228806614127, -0.35196016574082112, -0.061142492269682533, 0.05271696797218467, 0.093894611808215636, 0.012513429261698662, -0.051375404356113874, -0.002479154444898607, 0.18786208803933233, -0.28357602762081124, 0.011330258586395196, -0.10337213085264393],
                             [-0.040810504298782267, 0.15554442288990805, -0.077539671198562268, 0.072891031748494539, -0.066791007492929072, 0.16224947621887831, -0.023629861978711243, -0.085373827510608777, 0.21598751531307858, 0.032679060669779346, 0.058365335509746923, 0.2108498130483232, 0.024874889131821863, 0.069726689467402889, 0.30427374164196702, 0.13102385770992964, -0.14702070575824838, -0.071910771138780361, 0.0080829365483122782, 0.026339134521963813, -0.267060147893599, 0.14180432448312855, 0.12158307843194809, 0.051576402041268885, 0.030427345670518888, 0.32580905424777407, 0.040542466326811015, 0.062310182821456339, -0.03412228720410769, -0.058465963524299266, -0.19011007694668211, -0.066034735114342394, -0.23579131419668597, -0.078326327119421751, -0.22711109997482101, 0.040372516003130673, -0.023550349979488034, 0.1215814731918613, -0.060710836895750964, -0.20017328670202283, -0.2708141877521722, 0.13827199996999814, -0.0026803429366673661, 0.32319895655573566, -0.097062080478078044, -0.013607220019538048, 0.10320985007076004, 0.11189051539028913, -0.05028825805341914, 0.11400844945370246],
                             [-0.015242205376816595, 0.17877749033448509, 0.12019798334404723, -0.044073476636718505, -0.24983420828992164, 0.04393669052529612, -0.15347659298751717, 0.047827506272596104, -0.06385331183024856, -0.30485123359134209, -0.035276121498762254, 0.047245627767939259, -0.079022421127617759, -0.20311829440830534, -0.10774638381183242, 0.22063897107710007, 0.2374465179655896, 0.066197655683997825, 0.10310055246989791, -0.24222989064280184, -0.011370378455903682, -0.07936901771783586, -0.034229056402993847, -0.00041220076182042726, 0.21940834020612646, -0.12990461115451099, 0.0056197022267985772, 0.11144775401273532, -0.052347760052837145, 0.32622598274433512, 0.034598981966274943, 0.12892863924204404, -0.092348781092504093, -0.042206807727404261, -0.10403425239079032, -0.16655704669182139, -0.09153606900161057, 0.093555923535787525, -0.035343017137050153, 0.024944868508245684, -0.37381046875062057, -0.043672669681363907, 0.0029374722923102511, -0.13693528811698844, -0.0089116624827501843, -0.14967358864330971, -0.04711538210710553, -0.1069879880771915, -0.018728165275876989, 0.21459079601229075],
                             [0.10360408821464619, 0.21724506332605031, 0.29351702195080803, -0.03401063748905056, 0.095480019973521013, -0.1219430553576825, -0.042184922872488817, -0.020019446967537949, -0.22708422231512365, -0.035697521635130937, 0.15359511708347034, -0.07601913852717683, -0.25386208995900078, 0.096703650219106721, -0.098110226421371668, 0.15874474905155761, -0.29748134020962802, 0.07012507520012938, 0.062706811248306515, -0.061630308163914016, -0.17941416292521917, -0.06799458549254124, -0.054232120880296109, -0.24827989474015152, 0.014059103806041789, 0.086795768639619589, 0.077279985813379831, -0.10578336224748218, 0.10214963247473006, -0.14482793551138964, -0.090251236452989284, -0.19613288839963283, -0.011338807187836007, -0.032052437288571579, -0.013778952663897233, 0.042476964729826434, 0.10710658580379796, 0.14650944813435482, 0.20916599633130728, 0.25066749419418916, -0.0063625769728564447, -0.069791594404340199, -0.3712571190475803, 0.062035908550615103, 0.044563190196552999, -0.083234925348554284, 0.10474086665396386, -0.14996115683721858, 0.013390358815703728, 0.022093386958572873],
                             [0.033351350764792634, 0.043271350905784357, 0.14605426602643931, -0.16581034711470266, 0.064144889627286372, 0.25440199544943765, 0.12630407430567367, 0.11426962200948393, 0.025914474865466657, -0.24051269656915619, 0.24791021307185127, -0.12134948911811726, 0.34258996087008037, 0.051820704849525327, -0.080174664250210637, 0.10372486397447771, 0.01017326879642441, 0.14113855497253833, -0.186485881743675, -0.05367835716594619, 0.031196973242799009, 0.036105427652357282, 0.05261086331966118, -0.22292981287646782, -0.027966668321490775, 0.16585526652664956, 0.16420787175671395, 0.086918922013285438, -0.049230072364022839, -0.046713625543364147, 0.045208592641074581, -0.043526480814342711, 0.058743439767473024, -0.023726414111831625, 0.0054173228544450672, -0.34742570069439044, -0.10644113128460089, -0.21330519249274102, 0.25733581525111965, -0.20154013711026841, 0.080955631609412396, -0.077139883256147429, 0.096442667807369972, 0.01440504507846211, 0.012899046608819378, 0.089132224377400926, 0.12115848219479002, 0.033679517034795929, -0.2380111670358821, -0.060170868315652951],
                             [-0.012190680068631228, -0.0093473618872720009, -0.044933551331041537, -0.1215604041842587, 0.069865138368903845, 0.0822512810179932, -0.073285389465815004, 0.038001111955309856, -0.14441814568384362, -0.064678469249495413, -0.1786355605090465, 0.30214938166022648, 0.0090957872729912348, -0.0040455422204673189, -0.074179927110324242, 0.20999864874255511, -0.1280506000601119, 0.11426337082078009, -0.19174682757266873, 0.016198802674704242, 0.032061531494774871, 0.066516642150884653, -0.23791706688593242, 0.047484705948677181, -0.060460855387951019, -0.093260944759707157, 0.12999189137593009, -0.056181494160629925, 0.093177035720299173, 0.10350496075707669, -0.094285917402541761, 0.21322249550867861, -0.16526203567613215, 0.53415729029159154, -0.24809715481816619, -0.0054953180181388072, -0.1202258992436899, 0.063014337368541382, -0.039947954833487898, 0.020715320686805865, 0.27782581089266256, -0.034571857039486668, -0.042216473158478748, 0.145979388060238, -0.11506393236814662, -0.038833500076290439, -0.02041074343082204, 0.0034829056831841292, -0.036496393185174315, -0.13022832623843303],
                             [0.21095875793845054, -0.010175653548993937, -0.15146738350099589, -0.018269103124730634, 0.13648825524281996, 0.072689473755988498, -0.094604694889603894, -0.13143104872679259, 0.20179255718157327, -0.37817326265636886, -0.16259718736395842, -0.18555161261393557, 0.019454525776246519, -0.21028428038077471, -0.0328886062313671, 0.032904329360106947, -0.064904855924561342, 0.048943983516486621, 0.089535823612481538, 0.19812146313083318, -0.13245388269455333, -0.0067695175550571696, -0.36063783025699481, 0.15316860765084614, -0.10623293369053231, 0.14539206520739184, 0.025279148142151632, 0.014874835390189965, 0.060277634244393773, -0.25314163907491155, 0.32487838073236847, 0.017272544594275789, 0.011638497267331221, -0.065377871014521347, -0.14872572789083072, -0.026540460018114442, 0.025477005016548645, 0.078636691896752542, -0.13665720763709271, 0.10440902640568935, -0.083472717993656603, -0.13611055260546173, -0.06062575354205791, -0.08416389603577229, 0.069291469707086967, 0.20229251730841746, 0.092418963936464996, 0.058491894731837496, 0.032477749919395338, 0.012184204879553656],
                             [-0.15985013314903246, 0.1236292566413565, 0.0017304869468040913, 0.074285402233085385, -0.1390074039906628, 0.098359021901532839, 0.15955681181486789, -0.026458103251762947, -0.067465599561457909, -0.16028398438502597, 0.045029035136513233, -0.31615120682859493, 0.020092309989075522, -0.16570340854182264, 0.081182965039865954, -0.060377936942103708, 0.054276696052353017, -0.15520583037593955, -0.02169519465618467, -0.012723352318839316, -0.073282893891939482, 0.28408592963426632, -0.12857581717913638, 0.23952093654218504, 0.18482710457692711, 0.013512339697084772, 0.16556353213569838, -0.019427645987539516, 0.076452760846256768, 0.048244617690106767, -0.047762419822906077, -0.13889809608368625, 0.034579818520380647, 0.051487663661198807, 0.011309566211021787, 0.047427742310056822, 0.33892130568718265, 0.18172351073713361, 0.13355103099484902, 0.15444501182755002, 0.24725916759277505, 0.16366744855023679, 0.19764857985173362, 0.003149194416526131, -0.24963297845382101, -0.15613168010111861, -0.06353896751213288, -0.065159835296948146, -0.17242026221017648, -0.033689938740824536],
                             [-0.10126998498400408, -0.35134446698819072, -0.09636771331593931, -0.022452993224971921, -0.16850615627556562, 0.0084631420915845627, -0.073080289607735424, 0.049102214142746174, -0.085963040011954442, 0.071216994163876238, -0.017633803625519223, 0.040450292674126684, -0.27878028457130904, -0.10177127572004591, 0.043346840863023664, 0.10302667376482204, -0.18908487863638349, 0.15217773775148044, 0.13067814443020939, 0.041739747759642891, -0.020627640294208962, 0.28705925059546472, -0.044909863435784105, -0.072273741363987676, 0.19936389673714575, 0.029196001516093494, -0.022019073285257477, 0.086066748924889233, 0.0030963088070007816, -0.063537512947768979, 0.070196810755966593, 0.23562395891268448, -0.017392583332756142, -0.17553314062419784, 0.050898792538806248, 0.11138178773569919, -0.15345905396076967, -0.047700275219283945, 0.21734435159033214, -0.078042711876416343, 0.22240516065460583, 0.03712632316286877, 0.021957601466678887, -0.1661886734536957, 0.037757833552547498, 0.025281209381482921, 0.32080715037571778, 0.068237817970273035, -0.18168329842862951, 0.27870531531863851],
                             [0.16138246767478814, 0.17460782604540503, -0.072505336072935966, 0.30238223802230191, -0.15234040784642366, 0.095759977290796411, 0.054814946895862061, -0.17562228302727395, -0.22752044109284608, 0.070946848372558519, 0.13826474218696985, 0.081312377097280383, -0.069185497727652062, -0.22607065381405694, -0.096343501820100402, 0.0710932841869477, 0.027718922342115471, 0.13677890006412197, 0.043918313947936792, 0.23216178850426392, -0.077950564393397676, -0.26706390998023999, 0.025098810723815337, -0.1918924917478497, -0.045634823717768593, 0.060316289192327309, 0.038988462456106432, -0.16212444065999534, 0.21974149083869657, -0.0087061999079863402, -0.066320866391709518, 0.057596836609565237, 0.11246240434889318, 0.088047081183252135, -0.12031261596829859, 0.10817309644046313, 0.11941358866997755, -0.23307849973450873, -0.0033459042086408592, -0.1777483426299927, -0.017861659135420493, 0.21200109139871268, 0.1766822580701955, -0.18459554333802769, -0.14811752013796073, 0.22495730707856029, -0.092071628477009393, 0.0020736433367331505, -0.042188773360059037, 0.088896954721421062],
                             [-0.0043632010331753207, -0.26831648096205035, 0.03314695852461557, 0.048366792849500316, -0.028938243640910286, 0.1808413410592809, 0.17845488185346875, 0.064479477451990591, 0.031396698194167516, -0.16625654458269734, -0.052203744883756814, 0.24471356969767774, -0.33085650034580599, -0.014553346030886618, -0.28203897602258121, -0.11575043759924626, -0.2030510007567663, -0.060247440506470032, -0.014680379768308363, 0.20557586152610649, 0.23912401325640339, 0.034109931663274563, -0.0022063998678283933, 0.068713870272665026, -0.029623775250717233, 0.11849956285550096, 0.25412535172505613, -0.1695949599932256, -0.11301168096637987, 0.04033402460372873, -0.0770215767737287, -0.09068763630602239, 0.18142578367258122, -0.034153866215484156, 0.15589075706512961, -0.19904029599785544, 0.0564301210200795, 0.14603103273787846, 0.047296582011780407, -0.084703423477016607, -0.27476841542719382, -0.0018251239316260256, -0.029060601284561009, 0.023611562277625415, -0.11499804166831595, -0.094122086967713736, -0.1399194144442836, 0.14218447425125516, 0.03880382467495664, -0.041399637736046928],
                             [-0.022753568800943067, -0.047119690392993324, 0.15485620433999134, -0.098541834101495737, -0.14087885348344203, -0.22223926545642508, -0.02027357886646294, 0.36682361619506298, 0.19998940385033717, 0.036495723055809254, -0.25208680961324331, -0.39957056589901996, -0.040694672918374683, 0.0058185915021118145, 0.0021734469230643943, 0.036602058865933304, 0.022700247276647996, 0.17783902487226952, -0.055932166275027881, 0.062629501523852354, 0.10629667634223741, -0.019727464889096675, -0.070378852319795598, -0.10034373781819811, -0.15142341334440843, 0.10663284696343092, 0.10682975972103707, 0.0020763495615286737, 0.25521288710478052, 0.13593428853682279, -0.30358719988160249, 0.004669920776449764, 0.10751270595872112, -0.077836765890538534, -0.10703206615051029, 0.21702543119070417, -0.09873841069564003, 0.031749407430599952, -0.045728799560437593, -0.10113433907154154, -0.10831760744696388, -0.090072535797747391, 0.043432265159127917, 0.093990055545763701, -0.22585132673997807, 0.14259658370468603, -0.0029436848561852978, 0.054384546080650055, 0.0060235630363765546, 0.014732122831655741],
                             [-0.082111464024665945, -0.019909345862777282, -0.01611840916512107, -0.17338067426412063, 0.053317190822626592, -0.0556848320963578, 0.1598517484711475, -0.11587644222638369, 0.12623040859782769, -0.10538438995891605, -0.26678593525783317, 0.04471513755702608, 0.042623451441444513, -0.024850690264647722, -0.014356636399734059, 0.096278131756734706, 0.04830048976630251, -0.099909944541085996, 0.078042169430179179, 0.17965210495339401, -0.11076077690649805, -0.28364101002909231, -0.06136288250853425, -0.25098340795761553, 0.30307771741348544, -0.080362428241755643, -0.17615283861345113, -0.23642386995730003, 0.21825794678634486, -0.064066098839292235, -0.038603973254907581, -0.062845825974804453, -0.011980014688757874, -0.16401495589732293, -0.013992845554843814, -0.086028232779146993, -0.17671862602317248, 0.02386666740632688, 0.15074728977723845, 0.058036519424394292, 0.11793006960907099, 0.095416318062862965, 0.25197340176293914, 0.1933473623320856, 0.10633155704234182, -0.28677128429605248, -0.05427393557517745, 0.19500377381078238, 0.020746113637229651, -0.039343529003307481],
                             [-0.13444893600733832, 0.13488274397476296, 0.33250389536510216, -0.082280687693655874, 0.061811706087411628, 0.038112040701668189, -0.11718253536291021, -0.17577497843298789, 0.089212909106843069, 0.11706164160976668, -0.18917966963133098, 0.13868824793879653, -0.02975210132268017, -0.074948445966608671, -0.065533943478283466, 0.011537496643674511, 0.21483696384676498, 0.20917120873010028, -0.30666142865011481, 0.048835361866302489, 0.14827103714806289, 0.16318404983843543, 0.05533966211856111, -0.070045904502781461, -0.035465779453644007, 0.16036447267865508, -0.34080417108025468, -0.18010026167609486, -0.17477888907649017, -0.14502357601213409, 0.084765459305495741, -0.054226074590780889, -0.058536253425832539, -0.047906559065745077, -0.057952899647402772, 0.047253909177264651, 0.14456066590941366, 0.11372596580541201, 0.036817798579817047, 0.05109809299018464, -0.027698687838507201, 0.0084291139236847799, 0.025661983711880602, -0.26919463665662419, -0.25240313188623914, -0.025368585597347258, 0.13018960556455617, 0.14256659075802944, -0.031214652790794547, -0.055052887748009913],
                             [-0.043953854587573116, -0.035733603449455614, 0.047324366258504079, -0.046944240902297825, -0.064278834245505248, -0.015456916352732504, -0.11010786100477826, 0.039189194204932838, -0.090442609814228581, -0.14283316709290003, -0.1555590640685735, 0.041645434333153965, 0.079289885241833877, 0.062575241520713296, -0.082196118437284901, 0.44037384398241813, -0.11226169790799058, -0.42667645708285651, 0.055120527443543683, -0.04081678706920043, -0.014451588743341208, 0.12748054058924607, 0.13704962035698873, -0.1860513296551051, -0.046960795735129991, 0.016410021229143264, -0.085279182093414313, 0.012645225495940096, -0.11265490005218337, -0.070916974573684621, 0.058040243355736605, 0.20930322073494226, 0.070600460426309256, -0.24531100358245606, 0.072994444665282487, -0.006491186936409309, 0.16357107458132045, -0.0024336867351872939, -0.088473224551254934, -0.046852714569802688, 0.16007391128887255, 0.024972754657651357, -0.014069977571101209, 0.048975918204955775, -0.20427307591776417, 0.29199794755171077, -0.27116368492056891, -0.075578526431783741, 0.11932499962132873, -0.090902291142659311],
                             [-0.13408462337009999, -0.044680606556763737, 0.28404027441070406, 0.013546630969805445, 0.080339504706840939, 0.10133033079984127, 0.25273985706180235, 0.20735970353249325, 0.19321979726003971, 0.097555368601976472, -0.036942257842227502, 0.23691344545642939, 0.2090862380785207, -0.17545466063547427, 0.017413882008337451, -0.094536741053192416, -0.039520343721054105, -0.14765709652637302, 0.062384724749771234, -0.1059342588716848, -0.22772323413062204, -0.047806777427784108, -0.16885053752001217, -0.023545167625059506, 0.034950196231958074, -0.25141350340125251, 0.01845948517084817, 0.09410947445217363, 0.078002606672265967, -0.16353504317265702, -0.22502137710612088, 0.014106192678713648, 0.17166392293687732, 0.050774643410948582, -0.065583926069789591, -0.10914790810382145, 0.14768195776087178, 0.020335699653285508, -0.12248136860964214, -0.0085226508885063307, 0.059584224559340947, 0.0092507131708029072, -0.1916206355415889, -0.22978284949831432, -0.0044358367202914284, 0.11205356773464288, 0.074904336503333474, 0.1198755101825867, 0.084616215378307505, 0.30012263347711599],
                             [-0.012672399872727337, 0.049385237390964176, -0.053530442617098738, 0.060030365254158911, -0.042857107786863705, 0.14700606037314759, 0.010861483531879945, 0.18695364045560356, 0.16413358898940028, -0.10043214813927541, 0.17973584555502084, -0.087281039732423793, 0.23163996746991561, 0.12204452373500199, -0.1534574447152986, 0.048362332399746528, -0.10038247633448996, 0.23339792471662915, 0.026293301824639348, 0.23773785340208464, 0.043495563892244946, -0.08277351672736491, -0.075011762774575164, -0.0047221088865326017, 0.12222974744328682, -0.045587414333602562, -0.098588810396777277, 0.098560327071857648, -0.090485565014215327, 0.00017156492263547738, 0.0893129989196733, 0.20123968160503958, -0.041779141101223743, -0.061715977510766573, 0.10395887951358226, 0.20763409121466886, 0.025139824434721215, 0.0029592693704713932, -0.041852729377102799, -0.079388823218423971, 0.045555309174292555, 0.35577996398081924, -0.28695606184668482, -0.031276762803509439, -0.18556808257648455, -0.32875339551225741, 0.043618500172462354, -0.0635843619605196, 0.30762331933800169, -0.092298658848441573],
                             [-0.066106734720763824, 0.00056020090541212923, -0.090636905260786119, 0.18814791166986447, -0.02313387870994723, 0.18131250751620559, -0.15415148470805157, 0.18560584805156258, -0.11475198418655393, 0.14928211141726552, -0.312656070179676, -0.11631966105696671, 0.0875021244119491, -0.083537070853820228, -0.055486079309562814, -0.031592987454655129, -0.050796395206181212, -0.04349641883210726, -0.37919038171302633, -0.014022787687804128, 0.018869877773753423, 6.4759708209200082e-06, 0.069647384024245959, -0.090720191606406028, 0.11607309627759266, 0.020311548662858586, 0.080274965029603323, -0.061723857323510364, 0.020317011317798811, 0.065375894020646197, 0.17319117886032454, 0.086297679535211988, 0.11715608684338591, -0.034500521434351054, -0.17353419171378695, 0.020242395512042311, 0.36694572739450015, -0.072187353639965118, 0.12387723046762987, -0.03349182111222599, -0.1114834613742552, 0.013316292877291734, -0.098592168200902761, 0.20349987849376128, 0.41577775931548422, -0.07542071589579076, 0.062469584210062885, 0.027786977965439504, 0.086495749746214018, 0.1027770226382381],
                             [0.29604382075130214, 0.18762654114275845, -0.23627464120737746, -0.021571395368208922, 0.22063480681033684, 0.12175459524650055, 0.12341373359631193, 0.14861421850290585, 0.010261886628778825, 0.11038349651065617, -0.047881953891305083, -0.097602903146724776, -0.16443283126085326, 0.0015944383215239595, 0.074851770294899242, 0.06006321609893004, -0.043549415046141321, -0.14998712467209097, -0.077816415556908394, -0.25827952354638584, 0.074059848857275706, 0.083731394491723274, 0.031749604591379765, -0.14280162507028557, 0.034107681676626908, -0.19106181124235869, 0.09024749486442521, -0.050168233065035046, -0.11047192443953223, -0.088064192069963729, 0.14953894372494433, -0.15758317297004185, 0.11587337153178329, 0.018687835312287154, -0.19690007979100158, 0.098824795434233045, -0.22479628596363252, 0.2175772622633505, 0.13016304106152052, -0.2295065635313967, 0.0041530567254960413, 0.028326706501822452, 0.15997576820563061, -0.21194498492712607, -0.16995723124515835, -0.076437053450650966, 0.062317206072547586, -0.001010211798684139, 0.26725198890864582, 0.044465721935100309],
                             [0.020096178434502409, 0.02976621469292853, 0.12939839758775012, 0.13780461636160393, 0.10735498857464865, 0.11382539724451646, -0.11679760798062588, -0.21935436980082737, 0.1084762286012108, -0.010294300406994554, -0.032354672914988607, 0.10895180452399914, 0.040860460595512939, 0.31246532646845609, -0.038444711929902654, -0.0058502159336195599, 0.082052046563680536, -0.24460767884956328, -0.11340454444744255, 0.26007322044342568, -0.015155587027999342, 0.24646712167065146, -0.19605509654699182, -0.28573845193422165, 0.036404216852983992, -0.043662497984817208, 0.22021684912619047, 0.27386831260825628, 0.15221053873991391, 0.2377006269982975, 0.012951028099350434, -0.080549513104850923, 0.051929985908727688, 0.01080215159310768, 0.097992789874648725, 0.24106381008243216, -0.094437685737401245, -0.14022707995474457, -0.023255615777960727, 0.16941771421933888, -0.11534400104719618, -0.089391164777850959, 0.13383482641118244, -0.16072425716770591, 0.021279657400446305, -0.070877113033989844, 0.063057582336942364, -0.042797890266369175, 0.029285640588193548, 0.066448303334711897],
                             [0.15176654109262802, -0.27801325402787663, 0.2037639413370366, -0.03396065944501029, 0.139371387370192, 0.093066170301812898, 0.018254850442521061, -0.088810254234151911, -0.19834840762683573, 0.30844824660104786, 0.18437591051128621, 0.0025507610482522732, 0.030254737318464103, -0.06082500870951689, 0.092347787132839906, 0.003127710522728372, 0.30902389838993127, -0.015414921541109324, 0.042587956675069205, -0.085881938983222592, 0.083520797069741207, -0.11346043908676161, -0.31632925231192927, -0.034146824000880094, 0.27486643228523144, 0.20991091592726041, 0.13656518995917818, 0.12045072503892705, 0.09330886020410481, 0.031254746888939498, 0.085510783426838377, 0.15479047672440527, -0.035078857829247009, -0.16549965134137981, -0.064674644516129906, 0.015943755297317137, 0.039717882020724106, 0.2735131481707328, -0.01780825750593306, -0.12570478172043104, -0.013622567510193631, -0.0062191498980533194, -0.074482901756859982, 0.13808494819891742, -0.045687041643052109, 0.090155982464846143, -0.088435957555324712, 0.068119174759241244, 0.072153829767850758, -0.2025936434651312],
                             [-0.053744492496303704, -0.16889418890643992, -0.044776395162661645, -0.20744042119541656, -0.042049712473208718, -0.21499827875876759, 0.1284492167225505, -0.21135204844130565, 0.034743471648744244, -0.1875636175962283, -0.012164308310111782, 0.1698295598565685, 0.040377891503921071, -0.18687060186893845, 0.30903656052752282, 0.065907730385326671, -0.0073241876031482104, 0.020920029106821229, -0.098672296672667345, -0.025241128863034042, -0.064204398541394939, -0.16477572513025263, 0.14152177997811669, -0.050086178014408789, -0.19200190965464159, 0.16168274118389628, 0.11072001729651598, 0.099986453440802037, -0.031512923166817329, 0.3646264977664469, 0.060506466809781112, -0.044414104487495061, 0.29840148250153914, 0.01509673624723558, -0.038712891819034118, 0.066110723225338897, 0.12778282428659107, 0.077210390074879315, 0.12318512730992409, 0.013117022513288187, 0.07907398222092403, 0.11976300340919672, -0.067715386938563951, -0.095088132621259425, 0.020051241734174885, -0.020175292573053245, 0.26422272019473458, -0.089783819437778134, 0.25302020185410107, -0.11572880976132942],
                             [-0.013869892347055308, 0.032780916988235508, -0.2116950392618008, 0.19697595167751783, -0.20143075496580251, 0.073532419124002421, 0.062153896310483125, -0.13628749353405581, 0.17380640550654741, 0.23334889567141301, -0.22345232336824519, -0.06658965188938186, 0.059221259245229918, 0.075437660560721168, -0.077790700262347731, 0.10815351873208393, 0.068411087410605545, -0.047895262874155069, 0.12832898487661235, -0.21320013739228832, -0.12374241698403476, -0.15120296601468661, -0.15311645000554214, 0.026179366638129545, 0.098596888153889922, 0.10942188085320645, 0.089108609458885019, -0.11548077764512718, -0.18010754429510842, 0.15014784201692608, 0.030664868217419924, -0.071815926094822777, 0.0068575799295064448, 0.075851890352247098, 0.13566828620165228, -0.072857397931777743, -0.042854668654109758, -0.2487620442450828, 0.23213806364658468, 0.1093818753720489, 0.030101479152754219, -0.22266049644335875, -0.29782757715410807, -0.010925679401066559, -0.29277436416147951, 0.052463382550171168, 0.11684493548137007, 0.17849177536193067, 0.0058446187755439053, -0.11431992382440842],
                             [-0.068097681425649773, -0.02265356182846312, 0.044331295767373505, -0.23096039423027634, 0.068795102176050629, 0.37744039820520636, -0.16473211033035987, 0.11000684492841573, -0.22063867859265274, 0.087464351994983439, -0.038733185582425923, -0.16430225202995966, -0.058155989093627083, 0.070457644300799524, 0.12282279961464346, 0.05986086901246003, 0.06290737063754924, -0.088739838591850639, 0.10912109516201222, -0.078926779575841433, -0.082767179338987695, -0.01776369455941039, 0.059447621632916559, 0.12565927244527839, -0.22429309046650056, 0.16621871165993921, 0.13592249901187928, -0.21777420506454157, 0.14388685157854234, 0.026706126756787234, -0.08856820827745826, 0.079098385942285784, -0.067520395926277191, -0.030709689742165047, 0.10822433486190929, -0.12382801225981949, -0.11768930764657207, -0.15872284720277244, -0.14142558233233174, 0.28009266247801085, -0.047102276593868397, 0.28769179774079312, 0.05959917535427646, -0.2038253808909084, 0.052532183367905383, -0.061020271122601638, 0.11434247235469087, 0.20266074327603908, 0.21095720138275526, -0.013983616478653637],
                             [-0.079095644648553426, -0.16065375722941611, 0.090919549510749403, 0.055159238508072195, 0.30264165123484177, -0.14143045361754514, 0.044988286786089578, -0.32026283650512127, -0.094328382211201572, -0.15103615485602903, -0.069755578795748494, -0.25925243323564584, 0.021022954242001041, 0.071678651984990321, 0.11048606879636455, -0.063618106011620629, 0.060226492715070898, 0.045434639739982734, 0.07925139396176846, -0.034905361774641493, 0.10907609818787428, 0.076826361057443865, 0.075801676636860452, -0.12582712269040405, -0.054038067336159845, -0.12179737263604433, 0.16828656479736448, -0.14696789244823036, -0.15979258782189676, 0.086263091188079594, 0.068212982752277648, 0.03104044590594594, -0.054770972600568242, 0.023207975981466438, -0.20158784403785907, -0.028025856057935918, -0.0082358958987405039, -0.16957703189775064, -0.11600243159738406, -0.13423348210831051, 0.032762229060082679, 0.16845951303189283, -0.27838074757931602, 0.097571504301460124, -0.14721944369228349, -0.10608781126497066, -0.16330591214266543, 0.18135222509591201, -0.080568510796141135, 0.36779873270340679],
                             [-0.1184660145513866, -0.091088355671490207, 0.0098623921345371013, -0.13899336355795386, -0.15643801734338678, -0.015795622487543827, 0.16590839462358256, -0.048339490482964195, 0.057168279534760065, -0.13071546926762681, -0.07785595497683552, 0.060667437567709495, -0.021221161252001502, -0.12102205011556279, -0.1274251467972892, -0.14203735320810396, -0.020608629351185129, -0.028160902634549099, 0.055750878119190425, -0.36383630728823479, 0.1099518637383638, -0.05306919965940296, 0.073287561980180604, -0.24355100347607028, -0.0059929251987701502, -0.0026243238453797766, 0.24561987297895863, 0.14372588909521078, 0.056008140331386944, -0.32830493392998489, 0.13003762447219741, 0.0015881303873847604, -0.31904637917006912, 0.12140748593618983, 0.017133838988513759, 0.3653255522500905, 0.10098699371980137, -0.16159082012667683, -0.027342070176853878, 0.061824829960454193, -0.18192020078793353, 0.14279367376840471, 0.050798695520056267, -0.00014385862023107653, 0.030038869313839294, 0.013923723367288466, 0.0097826602495403696, 0.073281081819516286, -0.023744820565659151, -0.20626523242269609],
                             [0.1452255437069436, 0.071516390996009579, -0.11606215056456101, -0.32871807665008645, 0.028447559120917152, 0.096223365297014432, 0.14345548448417297, -0.042830583446896317, -0.16149013735554102, 0.055996089459670557, -0.065698335023864129, -0.037167258212177846, 0.10161805259399717, -0.090415245567640398, 0.15557681044636273, 0.040980138992215739, -0.036724116197161802, -0.059088052052142195, -0.18531493444241473, 0.16660197303114982, 0.11174171781251371, -0.11160761933368026, -0.19318419269966977, 0.034419273016597259, -0.087781196287521179, -0.18572435235299725, -0.11823536596626727, 0.06421637536775969, -0.15586903185895415, 0.033761501658295646, -0.091173789360300905, 0.030288616555743671, -0.14607327029417053, 0.026900175759700665, 0.35347465543050122, 0.1585398880862007, 0.033494953108723947, 0.05986694477645696, 0.28399699673051315, 0.094645303345142748, -0.25507045754114849, 0.12167029815735864, -0.065984476258207289, 0.12512629639526884, -0.060050475431056918, 0.22848067017947352, -0.047951765098014312, 0.010462992504834399, -0.11518186963414437, 0.27806226524543076],
                             [0.11593380993753769, 0.20640704611322575, 0.17683688544180062, 0.22826918947491029, -0.089844348110408465, 0.089635599760971643, 0.2097653584338941, 0.0038591197614589955, 0.1451510270345516, -0.11284163798126624, -0.02894176674917014, 0.036848242697992986, -0.2995826117297829, 0.051932128415443507, 0.1696091623557362, 0.049795896536687305, 0.20532787761421326, 0.20815872397595145, -0.036242076107513982, 0.065828333654014873, 0.00935872076391428, 0.1012625269149674, 0.083815159953401011, 0.027290020616729738, -0.10323103817593161, -0.32551334512423219, 0.13887596091603274, 0.080829635012767076, -0.089285692618828169, 0.030595932411367186, -0.0087787371890211685, 0.16084239952255799, -0.074823177550185624, -0.1882204892550344, -0.0057858718348394924, -0.052916972329434694, -0.035559276005875752, 0.014439957399746657, 0.10755966917376032, 0.1650956770807511, 0.17772922061786672, 0.10381867471188279, -0.046337248007322689, 0.16978586300436027, 0.18464996108250173, 0.23858180353600295, -0.0061951549191642608, 0.23652604848836867, 0.11417322831334158, -0.19154908815642657],
                             [-0.088531397718907556, 0.13220020296354587, -0.21271240775515263, -0.20044011973077253, -0.10872719954721494, 0.13810602791369783, -0.13137242682492176, 0.099256686435250444, 0.026656192478667105, -0.076549658315933744, 0.11426479338316622, 0.043695212477488456, -0.28752467588091263, -0.021068569419861159, 0.056672868577134196, -0.14237586694988491, 0.33233857060805799, -0.062587931900072752, 0.094368777064955958, 0.061789912763507641, -0.013833884596195613, -0.010381646688467928, -0.10927672833287988, -0.25411038782395079, -0.25640010099764637, 0.14446832268108803, -0.1101306504021996, 0.1970253705838596, 0.029313713630652032, -0.077925495721872198, -0.029592829517210536, -0.022394270400950645, 0.0045631935140854653, 0.086845187668012414, 0.048103472171408687, -0.018955738723500103, 0.20529110570181233, -0.031219044217726064, 0.067646635696849325, -0.16773884033251463, 0.23317454659839981, -0.22032433523599318, -0.1316402394069579, 0.083834338889326579, 0.0046860508783892517, -0.20480408824194862, -0.18540692201125386, 0.14828739605571159, 0.11031553827413684, 0.17179514752220787],
                             [0.062998724647688395, 0.094803255772043807, 0.18369906010114373, 0.010173285229715378, -0.051318666113294643, -0.12499523024798338, -0.030388874674245489, 0.25972028081990645, -0.11803604974063359, -0.0042439848597508947, -0.061460222761862679, 0.00030181459113952369, 0.068233923588198367, 0.097822880861465678, 0.28544868958441894, -0.22582888186628172, -0.12803201847913209, -0.18297391455468776, 0.3016660996592736, 0.2188450928867981, -0.092302721165424595, -0.029515339195834194, -0.031163862491113626, -0.11463535572756998, -0.052113896443052345, 0.0011273210325302061, -0.045457052855421544, -0.041811661403395206, -0.2078525410912766, 0.075704318883988694, 0.19486575349739985, 0.2576694416263608, 0.016627288247612153, 0.17376043368123753, -0.1713641474504696, 0.0038272320186881199, 0.065536755992687407, 0.027098682562935232, 0.20348468164749609, -0.029371767121469754, -0.17524717194283818, -0.025761948607198357, 0.039853887555986379, -0.17333595077611655, -0.015192064152407212, -0.094181296862558925, -0.026182025266874215, 0.18967145068802213, -0.22934044030247525, -0.24800954776946338],
                             [-0.11897509939492136, 0.12252634328251216, -0.01630939128342844, 0.34346757225102997, 0.41714312862833153, -0.046481106361353067, 0.20184902444336716, 0.13414412505305001, -0.073429181952207365, -0.12166157872702169, -0.093892761409911776, 0.045513180999102634, -0.073219423736479036, -0.06039743995448562, -0.049304642316223689, -0.088724341637055212, -0.12437816093910695, -0.03713881063992186, -0.090394200296684254, -0.18418655826270661, 0.04026347569439058, -0.18997272441287275, 0.052422098477502864, 0.063832815152495601, -0.10000301585777993, 0.33083656538359602, -0.16491328674888733, 0.26848292176525285, 0.15012722550589225, 0.14168229539913146, 0.051097739160910649, 0.24692341806744067, -0.14828197976761201, -0.091841602715038134, 0.11926651853799285, 0.013506255186367916, -0.083490828429571048, 0.02596588159434917, 0.11218355815246989, 0.13191596379312015, 0.067459904576021551, -0.0420338273714677, 0.091070713697038355, -0.023073474980683226, -0.12600378494953501, -0.041792525901544961, -0.049173771149588763, 0.073652291293539285, -0.027380345728409909, 0.12276121348702132],
                             [-0.12816833041821721, -0.069758344242230402, -0.074576070238049783, 0.049718908467054304, -0.15278039332295343, -0.17324217940298511, 0.29972734562024334, -0.078583502072466213, -0.093619792025913112, 0.11083386725866468, 0.19741169934231287, -0.20448884159810499, -0.070445984416499893, 0.0081537606781752429, -0.1081259122095309, 0.041289280158754944, -0.021393158067927749, -0.11276850362717461, -0.081629371745639598, 0.04687390163596665, -0.0060274982305797099, 0.25737214319563795, -0.10434823866560035, -0.18075574513662582, -0.099125162714311627, -0.057750150246971867, -0.29663640293758986, 0.071756561745980343, 0.16320117822179767, 0.0023471580088764701, 0.13868858494337558, 0.11068983087665503, -0.032605490977441871, 0.21041773699070224, -0.084560734731463805, -0.34695648510708282, -0.0052772737253453748, 0.00070827280868818437, -0.065865138244355859, 0.091245048772801526, -0.26223605754860774, 0.044089246668235084, 0.036841589034239494, 0.15175916937680614, -0.086996309638002603, 0.041940497093004063, 0.21210334254235647, 0.085429234440298471, 0.2485151026423873, -0.026637925060540944],
                             [0.089346948752809671, -0.093350327129870153, 0.018216886552101821, 0.02296752658117987, 0.098840608980580891, 0.18801216556240755, -0.055953307791705556, -0.16380619551566683, 0.11719792250922266, -0.14256227914446215, 0.07725728710258542, -0.10130335967353502, -0.038244723768832166, 0.15128764640902098, 0.14791072733072577, 0.066426085369931429, 0.0012917473539366927, 0.16728747981058906, 0.045401005628126684, -0.21054511673336473, -0.045045487767073643, 0.0028889073722898413, 0.16449690500687444, -0.0179903010880244, 0.16561098519860587, -0.023890034918400759, -0.13823928672209987, -0.055755994314074117, 0.03875973378819586, -0.1721095455639525, -0.13853876516669122, 0.35583626143648678, 0.44211994506626817, 0.30642192980585664, 0.16980939911913884, 0.15854678205876818, 0.11424852131992688, 0.061192314445439218, 0.010170175998424057, 0.10670894613687334, -0.16303208553956533, -0.17711303275890028, 0.13779549444473768, 0.12928777603157787, -0.041617586480151417, -0.035184076286419147, -0.019471268103519249, 0.076540463156396371, 0.0063768546286342154, 0.030931354493948633],
                             [0.034191120348313751, 0.12624184919307097, 0.1758129386684037, 0.18523197739755115, -0.070368395083675497, 0.011665388046670456, -0.29276504144184134, -0.14026668034892104, 0.075944953991230676, -0.069507515844814377, -0.055751918815815385, -0.068598384842542479, 0.052058912492569352, -0.25166818153993215, -0.12749629768591766, -0.22291898714216887, 0.0089415800493652178, -0.2432898707401937, 0.038749252013706076, -0.13754289551029411, 0.019283865741924641, 0.048419982023978889, -0.077366975601479579, -0.10874080406283845, -0.16559855954540148, 0.00090689337655010282, -0.046332162671257268, -0.10438335927933184, 0.031790431297932256, 0.031629853300620202, -0.036490554840687937, 0.069399486710862837, 0.10030360891912959, 0.13319095852225357, 0.31478107114147186, -0.0048355766812335421, -0.27862505340979737, 0.22356633860176656, 0.030639703107101325, -0.26048775741774483, 0.096497741228188397, 0.2571852869946134, -0.099585252048766545, 0.18885355268749066, 0.095095294577200506, 0.033444961712362394, 0.21399644027716636, -0.00085572260768934703, -0.067579754083434973, -0.055399447132490641],
                             [-0.066669607435876452, 0.14200116525441833, -0.0073923426704850456, -0.05790005866280553, -0.15810415787258472, 0.28798730891427332, 0.16345770029030321, -0.10767046975924013, -0.084420404648712061, 0.045975175022712103, -0.22298245445779735, -0.032590822801002853, 0.072588152810371939, 0.033242354051373178, 0.077112523862657781, -0.31011372627584205, -0.20062619655449965, 0.18545339618224085, 0.22566969258305491, -0.024144002873872486, 0.20459363519224169, 0.039132844989222294, -0.065216445156634384, -0.27724315356948614, 0.10491587714419379, 0.19899753105070142, -0.097896746875367327, 0.066702015261795561, -0.21061688030794626, 0.095079621915617266, -0.056770444912020893, -0.023290155209628554, 0.094706230940198061, -0.013232821147101892, -0.13421917131319275, -0.073969856412861912, -0.12209278886515408, 0.097397971209225817, -0.19206047582081529, 0.19730428680161377, 0.1337427460422666, 0.0075360942532041652, 0.04581620663999892, 0.071728989520853534, 0.056360854297501532, 0.17186970819231481, -0.08099091445667686, -0.2692934504771462, 0.099835323085599809, 0.070490977187243439]],
                            [[-0.28466702231273522, -0.057136563784668797, -0.11170626565857926, -0.21645325951443914, -0.099758276067137663, 0.11555952608079466, 0.012400256748989938, -0.15013543930710094, 0.15380735938702583, 0.11219629002487604, -0.16045185600456841, 0.35729192216065492, -0.019421351397851477, 0.17184362591509397, 0.0023763810475799104, 0.17187767040908739, 0.025066772447234632, -0.3004980911034883, 0.015134589003460194, -0.12080756480260682, 0.014859352562863009, -0.1428024267563161, -0.14578775255320392, 0.13332809673297027, -0.05754035472768982, -0.14032152972816378, -0.079596329986298966, 0.087039870160374441, -0.13832824538281355, -0.044738161584239211, 0.07498331959261946, -0.11218137991226312, -0.023269706396027441, -0.0014561158569179999, 0.13529417294540017, -0.21678030779692084, -0.1751163248549629, 0.13189788375468095, 0.10505043085196628, -0.14441765112458826, 0.15305358516449993, 0.026633016843783355, 0.037868714763546106, -0.044736532988881889, 0.007401378059747719, 0.23673668577435467, -0.20494097242017439, 0.038118528659072587, -0.12575034772068519, -0.17573901873996048],
                             [0.12490848799003712, -0.33177608924066593, 0.15669541361452169, -0.097516827698514955, 0.073859311673543204, 0.24626552555960854, -0.047908962068620262, 0.099219059482888269, -0.13229104916415013, -0.069723465734183296, 0.05160118394343953, -0.046062521274021696, -0.071630603124100148, 0.023345713318316214, -0.011003011611542183, 0.088088641841887944, -0.13474795259826697, -0.15930840263538229, -0.21439126855677984, 0.22414187127870375, -0.33157359979505169, 0.12596290750830455, -0.11991015112951685, -0.18226404025121434, -0.13131806423328585, -0.085233641581456299, -0.35457293530675049, 0.034690413323941433, 0.034039187510266362, 0.13282427602042879, -0.0042777106503647097, 0.02267993077521871, 0.049088769514618623, -0.11058691397118528, -0.010347737129462499, 0.17555218752302079, 0.046189039727953844, 0.25612284870887042, -0.024628372627939918, 0.077855656238565649, 0.11932623026852897, 0.096222995952986848, 0.060247696211164985, 0.12309188155281811, 0.10783285549723272, -0.023894185531828312, -0.155585509671989, 0.12156150020323356, -0.1185963865294503, 0.099540837445167923],
                             [-0.074655555860949407, -0.06457429398462898, -0.096043875856036812, -0.17175304960070459, 0.04504383546889671, 0.036215629344634584, -0.19547373254120851, -0.11780698830392637, 0.016466453603781541, -0.11016539658488, 0.010931327346853955, -0.19757115755206608, -0.3048775491928305, -0.11064269639437373, -0.11718393893272951, 0.27190763697198039, 0.023199654224633198, -0.16439667710033221, 0.020262158218063851, -0.40333507161124843, -0.081506563563467901, 0.15624832458108218, 0.10920304882971867, -0.10302442001357016, -0.088377592603576416, 0.016424196617499793, 0.035660509844081256, -0.11597425626718169, 0.064315829748745251, 0.0055609614864899001, 0.036589819963680152, -0.043222966250429366, -0.12537937593171561, 0.3235619729855424, -0.35136611157275732, -0.13607131582975188, 0.047767547660123817, -0.025168346298683263, -0.158145360001129, -0.039765674612080061, -0.015504579407985624, 0.020580946041775686, 0.13988454828835079, 0.068814506707444392, -0.059513615792177121, -0.20703231564136465, 0.045159864903550131, 0.022794846445793122, -0.040222501432809199, -0.099082285303035186],
                             [0.16870190560888709, -0.093664722864330724, -0.0042957746419733985, -0.04028767164077058, -0.1516578144774279, -0.21053614962549863, -0.099540692401950875, -0.20407023527988769, 0.0097217800393769125, -0.066473634889479924, 0.14170494123701649, 0.10822886950037554, -0.13413547087075339, 0.10425381752773209, 0.1707708453234881, -0.0046708892245938601, -0.094352212812764735, -0.072930378945677235, 0.23548774330858152, 0.24531107153105888, 0.090067861330027074, 0.060019090105226693, -0.23027122716608922, -0.12410492025700973, -0.15725104085553276, -0.10446935639885795, 0.0091049045884473885, -0.10036110292042053, 0.050250664783950946, -0.07442726837593662, 0.20472862760579344, -0.078432442312466114, -0.11634672053420395, -0.20885255913690401, -0.08743160558226086, -0.093733981444119624, -0.19774003633088566, 0.1427743661750128, -0.081160252171295036, -0.040994430060668482, 0.09575128079355566, -0.11943760958055252, 0.047075004536181873, -0.17985243527272132, -0.15715863986337616, -0.22329212503154036, 0.26307149419130399, -0.27358111213667075, -0.02421327059390032, 0.1320545017597293],
                             [-0.014752574141980964, 0.31347713093130136, -0.11810301990167991, 0.10643596566403571, 0.04287902710666653, 0.035570758234831482, 0.074986457137664317, -0.21440831293690554, 0.013798481042466122, 0.19949011925383017, 0.058684759432368318, -3.8927885457548449e-06, 0.027452795970910111, 0.087246162416652159, -0.011859386927864878, -0.049046026810245225, -0.13339698582432094, -0.14859450390835982, -0.34734490336711193, 0.15271178631612728, 0.055310358081443287, 0.17383011626945918, 0.10128381710455807, 0.013443658856274399, -0.20141153612663368, 0.12255818090939909, -0.0059856312419947618, -0.036002549568048818, 0.13890978545178936, 0.19137001415778443, 0.091349885171359238, -0.076752600115300065, 0.041597605762365313, -0.11612531309810412, -0.30944212841359514, -0.066921306732465172, -0.095443182928987291, -0.10016223806894312, 0.13158364517588356, 0.085333243518871005, 0.0077594017216460779, -0.064161298186385357, 0.060395651281547148, 0.15547875998737767, 0.34906234544634529, 0.13690972807844148, 0.13100882150743395, -0.18170849104833417, -0.062813550623131931, -0.16329223604833548],
                             [-0.10535956433110157, -0.091652226017439331, -0.09114154323871082, 0.14035181062743954, -0.10986536359536893, 0.023551654776093042, 0.089053185105442897, -0.072589903679806222, -0.19888144610518385, -0.094382379429404112, -0.057373826190391955, 0.13018000489423043, -0.062693424534870978, -0.060809670948437665, -0.18766982818631117, 0.24060502666559214, -0.034480076708080502, 0.2103983179463785, -0.082565397621675293, 0.052606567293212871, 0.094078643880745341, -0.24867530822988893, 0.1165906860830816, -0.060552307936844053, 0.20169719070616193, -0.010750754346693685, -0.30322071935415895, 0.059790932795173786, 0.18801029963148475, 0.24095812764782307, 0.22616481853719533, 0.1811558229402431, -0.22737444589254341, 0.096818698223849878, -0.022683901658638025, 0.18865167817514839, -0.016217409048695369, 0.024900328843476226, 0.13095352431173882, -0.10073617495401116, 0.079703607807412605, -0.15897673961211323, 0.018145527025234177, -0.21357001623186536, 0.021354838792783791, -0.053648647182909265, 0.05578796790711945, -0.10365821226840476, 0.20731520521141034, -0.19352340873377025],
                             [0.0043120772479563882, -0.10555541458125735, -0.0067731629838774388, 0.2365908483728765, 0.34030141947666787, -0.2486202717736547, -0.092736682774777646, -0.16244742892433217, -0.055934503828937415, -0.10143353438662137, 0.16162410885638248, -0.028184348298786119, -0.17076076751551772, 0.287990535684502, 0.082620568715876183, 0.036277403194315036, -0.077086985681034975, 0.046545186490328509, 0.21541476161966353, 0.19864691833565157, 0.02179751264584506, -0.071713390559434029, 0.11418675704076969, 0.090258788319761654, -0.040543259710437873, -0.12504548845443544, 0.051863120347705204, 0.037483948668559544, 0.1159365606021847, 0.040320050839859248, -0.052068386782003866, 0.057632674525316202, 0.085022205001360082, 0.089810926174727995, -0.094750428879804852, -0.15190028410734319, -0.064687741361098297, 0.10894939070160721, 0.011175589794184679, -0.12036648364228276, -0.085784711304871128, 0.039317061750801234, 0.07902335389448184, 0.21176222890242849, 0.010765755807409983, 0.17780238149813082, -0.28468020764007446, 0.18429019739851085, 0.32745004394923966, -0.066497470599411634],
                             [-0.093494881465163715, -0.27066681727016578, -0.019322715247823627, -0.11007941105772072, 0.035763690409853575, -0.067516110730417411, -0.24395901469375181, -0.15398154315962204, 0.028311444924518338, -0.060756498144044019, 0.11420549336254157, -0.17084974315976212, 0.17760352359085785, 0.22987158157402482, -0.20260197917425823, 0.0670510516664969, 0.11861600866001226, -0.035168367197685763, 0.14268934256349308, -0.13649043285612014, -0.2434903195784868, -0.055987512408247335, 0.17089185665275944, 0.21571902495062431, 0.098237482409272173, 0.17143233164420771, -0.061474559673270888, -0.068619465247155231, -0.011286933135202336, -0.0022339097812972132, 0.18661393755271088, -0.019663219055789737, 0.14073579584124471, -0.15333651546564864, 0.12373193172911058, 0.030756235577850427, -0.13156250010769552, -0.077291450199103773, 0.019183493121599376, 0.24981372664223853, 0.078848362378596562, 0.10153624690558648, -0.22841898509665007, -0.018398672930604435, 0.20780205616218433, 0.087942745292092228, 0.27304967761157978, -0.085998894706386192, 0.1136768102170515, 0.063246502466555693],
                             [-0.051725934149821143, -0.031099720278848567, 0.036044102713400965, 0.20931442602865097, 0.29569012936258449, -0.13403768056441615, 0.034465791201706036, 0.12452424525135031, 0.15278913014074716, 0.13376239145294036, -0.11856004516380705, -0.36205671461222066, 0.060367403894286228, -0.096899165612170962, -0.18965660045602736, 0.077064187685297728, 0.082831669747607042, -0.25536597989660265, 0.013971626651544611, 0.13926351180879237, 0.053463380204084789, 0.19981931587385912, -0.19833504141359609, -0.034335144050068302, 0.13861820771608432, -0.155158048849592, 0.15200342463894403, -0.17487120944368328, 0.0093537187113320597, -0.066316905260714862, 0.057742854460069874, 0.16912879430028718, -0.22858994222231926, 0.06468912143234988, 0.065278953315860172, 0.088054580851626554, -0.25915850579346905, 0.08006448339065976, 0.18410833416470079, 0.038566884691925013, 0.099438588704381811, -0.016209825618315698, -0.057855675880897114, -0.231605233662108, 0.048846612412432697, 0.027925899346700953, -0.045009951959725465, 0.057549746127597043, -0.11570294136954844, -0.11414854646505784],
                             [-0.2740604855324823, 0.010227403056477638, -0.038117730853370869, 0.1185928925797762, -0.16434735875698225, -0.10456122456732045, -0.096469081942616136, 0.026014101919231897, 0.13430045833294632, 0.028202987327938005, -0.042618338151485316, -0.0096746651645220304, -0.076896913675559342, 0.11653778469460582, -0.016373928695290526, -0.15983998455405429, 0.080851501233730888, 0.14782212536918979, -0.016985897453948982, -0.018285178429506405, -0.0089285524890937093, 0.49005759907281032, -0.1337671858378712, 0.11889161216621182, 0.28790133946491964, 0.087128650356780218, -0.10422577023812032, 0.10039207073073685, 0.14115434345299116, 0.29937095812361969, -0.027426125739179512, 0.044480206381704163, 0.037515929900813295, -0.082299484435589515, 0.037032762040675481, -0.049611178280793124, 0.055877360721114343, 0.027729967664105168, -0.24701682247072063, 0.071315866007898771, 0.2657210948012364, 0.018267521579211, 0.18704974823707643, 0.055561399099050536, -0.25629518619443464, 0.099467597329597229, -0.049948319693945226, -0.034091899654770219, -0.0023470233011948505, -0.0069041268103791093],
                             [0.35095824293699363, 0.082759183277471837, -0.08675367177017175, -0.044729486697046628, -0.017228316514560079, 0.2112338179825882, -0.077664822674845604, 0.17730648409203051, 0.12974313832772721, -0.096171035550964554, -0.1029387294042127, 0.019491584051653285, -0.011826185281101739, 0.036165596614057612, 0.022229316789230659, 0.016583589799064012, -0.22363851033893595, 0.14096107649755063, 0.13745266453078661, -0.10556760087738151, -0.026135153944748381, 0.015998938059044784, -0.11606025763325659, -0.12160677494757109, 0.12412738028827153, -0.14901788663566853, -0.096724167733994365, -0.28286065760222601, 0.083247192125986497, 0.016824194887887712, 0.21251814557714538, 0.080103407427152939, 0.26066886306311982, 0.050811387762325869, -0.046900231418815899, -0.15949037529243434, -0.071013076377063028, -0.28336146044761218, 0.21792747772248999, 0.10659916236752488, 0.056113980900310959, 0.11462470660652799, 0.24603664093481417, -0.1092368151959352, -0.061019215516648059, 0.28890117452712372, 0.014936099264518795, 0.033150344886376075, 0.065384669057122174, 0.00070895608129738295],
                             [-0.16954597780187061, -0.042942940986602889, 0.05496293291593464, -0.25456200719989397, 0.0050060679662757976, -0.18317220555070055, -0.018474993384947867, -0.023055850971349118, -0.12690135394794488, -0.07926483694614489, -0.036815228065494199, -0.12459953128226359, 0.022724744792525311, -0.07075695341623725, 0.046219437595639484, 0.014419654530934658, -0.02129340637997337, -0.034832412352924495, -0.032356408320039429, -0.045841123566986559, 0.28214539720864845, -0.043633105791267814, -0.4455929239664364, 0.16561592437046088, 0.042436925233034113, 0.17626674424669328, -0.1299092462379369, -0.11197926746380282, 0.17706887060569129, 0.063237026519285908, 0.076166614590969989, 0.13139922048295422, 0.079678399374067663, -0.041169871842387414, -0.0089233145191728435, -0.20364430604103356, 0.28202900826029309, 0.13404758456354271, 0.19526262025707486, 0.15256447050362063, -0.34266778552278837, -0.092219398557118928, 0.044999963864263054, -0.0042032261759341509, 0.1678886458308739, -0.024996630827316981, -0.06821721579190558, 0.057851598065309026, -0.0033668357212040261, 0.11701302471282871],
                             [0.075754993058532755, 0.086107396037144457, -0.15960448746332453, -0.055487112043335056, 0.16794146323295955, -0.11173463147824045, -0.1238157159350864, -0.030393057358238652, -0.34807684824584573, 0.16705064071566794, 0.027925761880282052, 0.1001041447940874, -0.09843374105951426, -0.042687342719850634, 0.19015491644279894, -0.033618183892052803, 0.041422532447342918, 0.12791315323099789, -0.17468520655303749, 0.015608967307973721, -0.30631486823001969, -0.024961783698840345, 0.02124710316896887, -0.056302157405768744, 0.19252494406420526, 0.25240538457332889, 0.00019043759515341646, -0.25966687645358111, 0.04402968121190922, -0.006528463439967133, 0.02393523662925013, -0.10544733742567002, -0.27565650564604705, 0.11348387115188456, 0.16084248967599962, -0.17953393479695393, -0.099785572662783276, 0.089358602862642023, -0.027942792106424218, -0.10150079644141594, -0.030572149271997365, -0.094045056992048542, -0.066914899477737946, -0.049176226914106523, -0.085477805273938293, 0.28376944805213838, 0.073472798167455999, 0.12107952025000875, -0.19290916457075949, 0.16164935748912207],
                             [-0.078618976051860689, 0.021075129132972551, -0.062066637336870262, -0.011447395016271495, -0.32760818158695465, 0.021376018937309664, -0.13471181369534485, -0.12085662158398724, -0.19341589185857469, 0.28811926080061379, 0.16442617300707837, -0.16355186054169427, 0.039663224508302682, -0.11428637706969798, -0.051181079121769675, 0.065425298818273581, 0.15020505436145568, -0.058679562362606665, 0.10947547581958483, 0.19325956201258856, 0.22886851336941122, -0.051638404146220576, -0.048769231429639355, -0.11451495119617686, 0.072615040909388501, -0.13037297019552563, -0.093812171360671562, -0.037438012897133159, 0.032718946418056644, -0.026507312554351362, -0.060576217186149438, -0.29440422449079423, 0.045049732744597885, 0.23290646630994952, -0.20576760099080998, 0.16347468685424105, 0.0091055849712982084, -0.069767562119574356, 0.069467271205847475, 0.10729794848736091, 0.074214802128087204, 0.25332238697864307, -0.14753890044570603, 0.00016276751027936428, -0.076351559750677214, 0.21688003100496539, -0.1699903864152775, -0.0046213864643013308, 0.065902439061424262, 0.24174535845765802],
                             [0.31192944502819925, 0.099384761500012006, 0.20297835440874268, 0.032945512018325407, -0.22111290476359591, -0.20016644106008613, 0.076439446879018713, -0.10887552176501811, -0.00777031905254859, -0.20209234291823885, 0.020562148410250908, 0.028526454045004992, 0.20355456797844296, -0.076744560702080702, 0.051274648115480582, 0.062239846854302887, 0.21068408566569777, -0.14787808865957963, -0.080974163800754603, -0.10761157042472023, -0.25135161724296684, 0.012688029238311941, -0.20144496037745033, -0.0029425054213390116, 0.10726406248834046, 0.19899828955381321, 0.18992380559814032, 0.085361394761828815, 0.21423014917111449, 0.156306205316145, 0.10919414303996111, -0.2340173302732019, 0.03295771753962666, 0.042356848208366681, 0.040500875046130098, 0.049817078471475824, -0.1359969937850101, -0.018690295442105511, 0.066718486452326656, -0.19707184965226662, 0.00089662247571777021, 0.1968914489502876, 0.07007252625550843, -0.036436513884235869, 0.08616420842051789, -0.11279022438472726, -0.22652774731961628, 0.041626212293173301, 0.13950117772611251, -0.1460329331333495],
                             [-0.042614783181684511, 0.19095763922328227, 0.042147149261948944, -0.080089810480918136, -0.17929795449926, -0.041424316065435576, 0.060693235114585964, -0.12993030797360358, -0.071975593061654325, -0.054315841479490388, -0.092108862885374024, -0.13550254655193678, -0.021975944702273757, -0.19948487595940481, -0.018978549844583609, -0.26659904354191066, -0.030009119759845392, -0.057653594742835303, 0.078696709555767214, -0.072391148137503483, -0.17070434501492548, 0.0079117329000215463, 0.20788100044960986, -0.10507309448650096, -0.27638111710206836, -0.11651652467338421, 0.047862884349029869, -0.13683260381944407, 0.10242629646187805, -0.06339733683951132, 0.15700027244847936, 0.052635788011522376, 0.019103025231499357, 0.011444013687179663, 0.18746661122403058, -0.041176619475860828, 0.098598629974159718, 0.2731587979499952, -0.10468462454198252, 0.33003669297000093, 0.11910675853545086, -0.24577752318561985, -0.055466048058771526, -0.12956230936694263, -0.027500735115578479, 0.16327923582015122, -0.25518331918786918, -0.030673340840532838, 0.2295968357988184, -0.13485859015073934],
                             [0.057893837722934299, 0.10497726288467861, 0.055204689112163419, 0.027584351465417521, 0.047474858204595995, -0.24581525030446924, 0.16392683528948779, -0.094318278279105217, -0.11475686543423423, 0.0087145747698720386, -0.026719865796123673, 0.10794691000809777, 0.10389925021286864, 0.019487120104010304, -0.42667221594648286, -0.045587511509709092, -0.18557118147830981, -0.076740343173684764, -0.13341174655616803, -0.072124100696224588, -0.048263269297866528, 0.01109718729825653, 0.030865851061314502, -0.0012751468219349869, 0.15048275147466036, -0.14708974835695376, -0.012517071311872161, 0.025550388364968018, -0.1650357380367635, 0.040791582964930601, 0.082379501351475065, -0.16415998866374309, 0.29629106059561711, -0.0019842168042825325, -0.18503511405785347, -0.11032257942085644, 0.055506279073591361, 0.18198386213981985, 0.14842613544321576, -0.0028727871342269402, 0.096266418960283817, -0.14185715096452894, -0.10169617863611517, 0.019119133192253095, -0.29076281861466818, -0.11975023658706224, 0.17769940502152812, 0.32660106555761814, -0.025967952343202896, 0.1328909711863242],
                             [0.010699962050936004, 0.081850521903351833, 0.25947237476515861, -0.075691541082935521, 0.18485932894195306, 0.010946038204168522, -0.25008956971929797, 0.099339384147195633, 0.35757207659479273, 0.13200905924369263, -0.075473224496822283, 0.13840951528164927, 0.16681101456569947, -0.12575515923895053, 0.14638106111043037, -0.11672023347470245, -0.035089144268120313, -0.08616352906803261, 0.081255321717169246, -0.13313239118464079, 0.017301046753653106, -0.21129977865275787, 0.17721657118817058, -0.0084589225732743991, 0.070369820816303927, 0.053802672030880162, -0.1107683628307973, 0.020926052722583247, 0.3970095359180929, 0.095187485817450276, -0.064348277046368405, 0.05976367551080352, -0.091959248495901924, -0.065329964031833429, -0.29452319939917326, 0.030408280083716845, 0.013337572350612094, 0.2287448325274406, 0.10493813354782434, -0.073257403172965807, 0.11058690243818382, 0.010309312281239819, -0.18770225156064038, 0.015467639837536325, -0.13256733689358824, 0.030845424759504574, 0.0032306165755542201, -0.060409601120508999, -0.015154654077334311, 0.14404905989669672],
                             [0.078404368283463088, -0.23357084452822272, -0.1348291289984288, -0.12440575605708075, -0.023478607286909731, -0.093347334905105731, 0.14273447577142653, 0.059924728874438032, 0.093124379311580546, -0.0066288154445362278, -0.12385725384409693, -0.0093806720567818531, 0.053517743596120611, 0.10833734283274611, -0.12888898259470069, 0.0097701511829956129, 0.14208364029853526, -0.013590183676955112, -0.13344938469551068, -0.038461407165329128, 0.17593395399870779, 0.023150831628516909, -0.0058025819560548241, -0.052646826480726598, -0.10744053940622134, 0.16983713671688913, 0.029128002769812193, -0.31168584061076321, 0.14600703576354934, -0.24853454725019566, 0.10316125151688507, -0.041201279869818183, -0.029628610067471181, -0.12284097789465116, -0.00027227885938956443, 0.26245078537486105, 0.038332950336461877, -0.12999484346610926, 0.0066714615839419279, -0.22809091594321138, 0.19798835105872614, -0.29672844220258632, 0.034783019050680437, 0.39418549007739007, -0.11674782707824863, 0.099765252505502069, -0.13309306932394971, 0.0023533585820248665, 0.12432550934321479, 0.1153592046190149],
                             [0.15182704537167355, -0.18508343890788104, -0.27928182298225557, 0.080149181608275957, 0.20939585245990522, -0.069524712627257984, 0.0098638115216910984, -0.021632676771004396, 0.080857798584025836, 0.048658901407222392, 0.01211477301005112, 0.19133034994285292, 0.13557633627692361, -0.20017405188726869, 0.059518474499362733, 0.015975942328097396, 0.01902841265272048, 0.1002687013279754, -0.13940651260482384, -0.080366708374184054, -0.044162265464555553, 0.021183792489372195, -0.24608103575066712, 0.28125977861983531, -0.17525676314958244, -0.057116687579009326, -0.056665402265362978, -0.017279498493473905, 0.026034073139514127, -0.10273584509298861, -0.1742939842896947, -0.21880672420769812, -0.048125098892341518, 0.1196071200195319, -0.070727483654946799, 0.20110772690180714, 0.094913259927945928, 0.18061926420073873, -0.01974172062260348, 0.27694052984750772, -0.016795006850491043, 0.12102585215905956, 0.088123556267200226, -0.054517261608836132, -0.15950280989510321, 0.096045166992788658, 0.20464638520157141, -0.061008588117659496, 0.21745467783987277, -0.24852360487521827],
                             [0.084075294628375111, -0.15835218122343531, 0.095749746617178499, -0.086237685777801026, -0.064719276400373227, 0.099430399643631082, 0.23610055669287436, 0.042599515053895969, -0.11247454723148792, 0.3192777157643758, -0.17248790178725568, -0.15971650708422655, 0.015785183074691476, 0.093853476414144849, 0.24623472545903591, 0.075994888972717459, 0.22628693973561373, -0.14282199977545068, -0.13306348168683274, -0.031845278432076823, 0.046773207251385319, -0.066666662811623881, 0.11804945880209373, -0.07727565563897458, 0.047868709412949406, -0.064766464301204626, 0.083419201476646984, 0.18097398925133504, 0.029326487167042024, 0.086996991421169956, 0.13269674257460515, 0.14332149073503134, -0.095102530485797365, -0.095049561039332764, -0.0031069496963913655, -0.20825413210269716, -0.15391662917519419, 0.023047723756359221, 0.020793261553939478, 0.22102073695568475, -0.13507635308396371, 0.08515787214016822, 0.14655674245387809, 0.16937384683270895, -0.27193073076858171, -0.02746161794842783, 0.22284803797361577, 0.10496047851569019, 0.28020030431489312, 0.012187539302852558],
                             [0.099915475393977229, 0.008425589341657486, 0.17177212711799775, 0.13710521157388339, -0.066225487861562113, 0.22981065429880221, -0.023358354082624773, -0.0019027486223022431, -0.12781248063789352, 0.048171690984758465, 0.1456578974327348, -0.10837130039799403, -0.15231472762247633, 0.046821759959215288, -0.097973133510458804, -0.20717514592626371, 0.096596012058216912, -0.040530005822069427, 0.063492379462054049, -0.083057657102445073, 0.009549169160047527, -0.12931723335469245, -0.28748095044616456, -0.065730811595218236, 0.10940733587921558, 0.24416049195617837, -0.030922561172369731, 0.20065510788682403, -0.019408983397995492, -0.35398001818586283, -0.14675967264061621, 0.11322706281644759, 0.018435202691521331, 0.057085854012321961, -0.14770456443802268, -0.16131888279468953, 0.063027339623417403, 0.12906788309836434, 0.029676856028659888, -0.093719076046751046, 0.33811731479414886, -0.13381520503964925, 0.034589914937222029, 0.014901296539181501, 0.14852783234109448, 0.14376417511232681, 0.21345602627875557, 0.034209454379041618, 0.13184412544062502, -0.1833404582705869],
                             [0.09807629966600187, 0.13884904229995962, -0.13819908681759374, 0.041117180110606194, 0.088393429906210033, 0.12010544154820964, -0.093805571169374949, 0.0080315631925024691, -0.13989062140493502, 0.0074316166715089806, -0.092491071983556314, -0.15559330972245852, -0.031824668247426732, -0.08784856664027002, 0.10374812069547217, -0.02800472529222987, -0.015579023598950026, -0.098078297559018271, 0.28877157815253718, 0.085687092500824499, 0.026427477012344831, 0.07222773969320101, 0.087370063527521372, 0.15606844294753197, 0.063786815795308288, 0.0094592273027175253, -0.18494765088749701, 0.0088886884092479277, 0.015686747253587333, 0.043411005359293084, 0.063175866220139335, -0.25020035416534675, -0.085198356262392499, -0.042197867423343707, 0.2811638286292848, -0.091382517218568368, 0.20352086758023868, -0.0029768469085712816, 0.37778989051949824, -0.033734032663536168, 0.18113389438000271, 0.02085105478600947, -0.06475445688020541, 0.34574644882889138, -0.11740193395600755, -0.29787396445414949, 0.024974892503696368, -0.072882164986605408, -0.063612176287879657, -0.22286862930652609],
                             [0.108468666674416, 0.081016577410957344, -0.18792845674477066, 0.0097956484648274635, 0.078498253099510834, -0.10106166798195651, 0.022463521973884758, 0.17527565589415814, -0.18791407087308526, 0.23772910188080978, 0.02241722510833161, 0.047361417689543397, -0.029889368634461809, -0.038860304032144292, 0.073884512512352632, 0.11002020661711089, 0.22291393566405102, -0.044638576080159663, 0.21137342864789604, -0.26954448519206653, -0.087609754879084775, 0.047623724107333149, -0.18257131263554635, -0.025043540468731643, -0.18310339205552145, -0.2440401470358132, 0.090288517441093119, 0.029392854559893218, -0.06916736185563456, 0.38556936843519229, 0.0049009348774022325, 0.19955214121058878, 0.18572058907201477, -0.056053946204950952, -0.0005394353013335472, 0.098858730008685572, 0.14929105001937357, 0.047857277129244064, -0.043143309236530793, -0.23557718245947248, 0.13999772032551239, -0.11125428900832435, -0.16395413465469466, 0.02932243012124057, 0.20105610234985163, 0.074757773156208074, 0.10354604297637469, -0.093026548920406585, 0.08198238428008843, 0.12097948767502344],
                             [0.016768611102912306, -0.0068379108678961907, 0.026268581930414498, -0.14983076654046551, 0.11315756754067376, 0.11169888168820917, 0.037113538988078273, -0.013124981549613772, 0.063075367785199857, 0.0083697758148280049, 0.15697875950081616, 0.21843108706443895, 0.022563965007799145, -0.0092077039502202977, 0.12152615571798875, -0.11039753719766619, 0.093043736972549307, -0.043688080666786026, -0.074237790147498262, 0.13590774823045013, 0.030279485735153544, 0.32863235964974574, 0.078833252473604731, 0.1924444646131554, 0.01748838751125965, -0.12753558515089319, 0.036456182294997315, 0.23470188312331727, 0.16017704019236784, -0.21194727931366872, 0.42161704721053112, 0.084299855912327123, -0.0026730807107182876, 0.42288803133920821, 0.079366491149025567, 0.034729166947881654, 0.13603799361231336, -0.087609709122942622, 0.035436676698688267, -0.054915878851532013, 0.073934918984582973, -0.052016450420154785, -0.065917533669946196, -0.079208789028104631, 0.14258090514822877, -0.072934993843305221, 0.078156626892456366, 0.1360986040994708, 0.07743303268121153, 0.19681719512419762],
                             [0.14343794682145558, -0.012532715896805781, 0.11403697697180393, -0.3540110011247169, -0.050935964983458516, -0.011995513774802064, 0.26857526515390884, -0.071600344709858252, 0.086723007373220654, -0.072414850901876923, 0.063673127705173721, -0.083559667492760323, -0.26787746115843619, -0.14686061623376037, -0.22779297054493372, -0.028437435874342915, -0.026414670348626056, 0.19081656517893328, 0.21342321755330071, 0.11650679991660352, 0.070716557451340117, -0.019225688320281712, 0.023301677263650313, 0.20782191739136033, -0.11907115843743489, -0.038889777095666503, 0.14741132567844326, 0.097288569862825094, 0.16776424421145747, 0.20867710845832441, -0.054132054421157705, -0.040989908840606694, -0.23055513545438605, -0.10376862650207543, 0.019482505289943171, 0.07466589174384651, -0.036071011244796093, -0.0057257642881341315, 0.0041910329313888765, -0.031273681604543642, 0.054756901549215226, 0.13415796182652184, -0.024448861406549099, 0.070972757647933912, 0.032233498476124348, 0.28100486577340589, 0.19917343620168981, 0.24834162095464468, -0.19347649051261273, -0.070537821910388335],
                             [-0.035418227232533225, 0.046485906729668944, 0.039542010731016188, 0.018850470879906711, -0.04281592763088634, 0.01085379030334995, -0.30934217348526055, -0.067536205003033492, 0.043315866616057651, 0.043970661775414234, 0.12458589791992936, 0.035761166360401012, 0.35100144326120597, -0.014321841275383274, -0.13194900540692917, -0.020319593710193609, -0.046377832123547902, -0.09178027115721718, 0.055269133130746939, 0.1329728575969728, 0.028304538317261044, 0.028556828338471851, -0.11721901388094616, -0.25926960831295731, -0.21866114916296298, 0.096892342018046265, -0.028714210364795673, 0.0054626318410650248, -0.10292099395143996, 0.086546039833597682, 0.21562542306952737, 0.20157774792203137, -0.12907921051003293, 0.012740323914079581, 0.091235768884102258, 0.010925854262493491, 0.21989085772970471, -0.10597194670084607, -0.145995438548535, -0.18052675920439215, -0.19701279585928586, 0.087461902979621947, -0.068060977115800392, 0.10750216124419978, -0.2369614740066609, 0.16307857758605682, 0.16006723319961963, 0.21931740672219385, 0.0041005106256507473, -0.30915266876096764],
                             [-0.20881594644158602, 0.067257991832163355, 0.41339915872741678, -0.028395630727861096, 0.058086449776101667, 0.14577740604265355, -0.11853747602682312, -0.0030220330312265434, -0.37918574026661744, -0.060113185944057193, -0.13280453301001957, -0.014386713116663927, 0.21667091297336452, -0.040672002779122154, 0.039245224178995272, 0.092334478471660972, -0.19743748591188337, 0.13231895744749361, 0.0028506335161398461, -0.12406326433100154, 0.060646969691092303, 0.22254547323439972, -0.061185530718036125, 0.24426130595447826, -0.28375575477838849, -0.055070345211536829, 0.0056630600687426714, -0.088188608978526636, -0.010335576335918552, -0.0059541298592834212, -0.13441229305873995, -0.059587770466428033, -0.094916824011539225, -0.011558834914291031, -0.0031214069600539987, 0.021980090028416808, -0.26722443641039084, -0.14485189740426435, 0.070868380547321586, -0.15016673427122906, 0.11935380996025645, -0.043067457198027764, 0.051788402047066938, -0.040561262288899447, -0.077414064548802439, 0.023952178368573007, 0.063021737623992907, 0.012772962228004454, 0.21370615891657654, 0.09776083011725957],
                             [-0.19993188145566154, -0.0096408707060071184, 0.055436996626754644, 0.03754333581380425, -0.081654205278582276, 0.022270747189271384, 0.0060815100100736668, -0.30533302896916859, 0.03994772288166739, 0.094321320575413647, -0.12855807478458195, 0.23633848512552133, -0.12599382302583551, -0.010061172986888555, 0.015258440977469779, -0.052065408997786757, -0.0035109091692293931, 0.13168142136884889, 0.035963070447757671, 0.087959779054489526, -0.33654722409829491, -0.038643598356826105, -0.14961068043305339, -0.035923499954984374, 0.023931524899710947, -0.0096742405743727132, 0.30550105119146326, -0.21694328093632781, -0.094006120242686425, -0.037178461336563134, -0.03576982399002937, 0.31052946618415028, -0.12355646023036551, -0.029236967511165387, -0.13625669738377422, 0.1155846452281061, 0.19923574267755201, -0.10000461799155105, 0.31437045250728707, 0.125400521243267, 0.11717551598295796, 0.21896358218081605, 0.0028727066852076658, 0.15016521737458902, -0.00081272173011201162, -0.1731553344735153, -0.022151880112598804, 0.029428042493755014, 0.067290780898503141, 0.083830968839212233],
                             [-0.19237637648084954, 0.13962414050565564, -0.010877752162371985, 0.00040020298243617522, 0.19411666519841539, -0.11841119725980673, 0.14397676502511014, -0.040671048224070298, 0.035806817477162217, 0.078089913482633805, 0.030574791534001992, -0.12578378576412624, -0.044131491798000883, -0.18516070841036159, -0.026990691450467563, 0.045193610060626818, -0.016664879137495255, 0.10105260815491912, -0.12946645499327408, -0.039005572657468103, 0.0745101948372872, -0.078689142221406383, 0.079814176050423777, -0.11352383182094723, -0.07092288994108939, 0.017296991839411097, -0.12056456572000041, -0.086557724526117791, 0.030329078622786217, -0.19584375793612196, 0.18224532064628587, -0.03005880037821846, 0.11533722411376557, -0.20211252563931417, 0.17019041844268099, -0.086784944936075706, 0.12988625495701348, 0.14097885776162317, -0.11917450943759078, -0.27734234812198422, 0.1873769168600212, 0.5380790496588459, 0.21770556818052567, -0.08726235588580715, 0.077144828932949522, -0.032182046624345879, 0.10047875628523199, -0.049295531718636772, 0.12467668145989375, 0.11138790355916525],
                             [0.028117630353937294, -0.082251928892836709, -0.21445818322762364, -0.32177324380821481, -0.14949347592019394, -0.019109691846915258, 0.15051518089181029, -0.13330086827874885, 0.036281910813906013, 0.017981282609893748, -0.063998174949961864, -0.077459661936620822, 0.1317631995824517, -0.035406185840926349, 0.12966741634439916, -0.022311028910297216, -0.19905191135454681, -0.036623303431226523, 0.024609692318316338, 0.15158522679169434, -0.0087486161813382039, 0.22809963730505375, 0.1053503172284018, -0.071823032365840631, 0.12192248955680333, 0.10784474830784073, -0.07046407838262303, -0.12362651416141063, 0.045768598468851777, -0.01210528101792716, -0.37618276811576357, 0.26579197898335366, 0.24469915429709407, 0.195135221903871, 0.042175471355325816, -0.028702986941945896, -0.16298703738687231, 0.15050403737087181, 0.046434998131186199, -0.25480718941428671, -0.012563117467837769, 0.080278167748495416, -0.21157962488658139, -0.045076969922671913, 0.0060231012871478093, -0.069846873629016704, 0.11267133411661411, -0.023234295338555744, 0.15715764156227385, -0.15796954957353199],
                             [-0.071872500220077656, -0.0052585633009577795, 0.33095903215858763, -0.21456106928242102, 0.16351953109389158, -0.18387019604847082, 0.0062057424134953337, 0.21901105786494798, 0.057012427362163332, 0.1090582774683317, -0.12846933668235605, 0.15892400447657645, -0.13308845155507903, 0.18732167224074631, -0.016753352768466401, 0.10824318956761607, -0.0069130687624380767, 0.21665789204339198, 0.043446346043513419, 0.073466326849299074, 0.11654913886923404, 0.080732007983044432, -0.029704694565213817, -0.3738100329579826, -0.012030739010323558, 0.17315215130994172, 0.093699444752183392, -0.017002837991999996, -0.14967472985750127, 0.10267011274667361, 0.055077722823171325, -0.26017210305692134, 0.083229195160193087, 0.27274814191904995, 0.09180641738930069, 0.03964420041672323, 0.026756264476026814, 0.095991354661228559, 0.057207726186283531, 0.17592037301804747, 0.070092621555703866, 0.021090631782022709, -0.094802278632680398, 0.068016137390109824, 0.10656397705159859, 0.0065643927021065912, 0.064522351557566721, -0.17977826734782548, 0.093995292354744145, -0.1999229128926861],
                             [-0.12226891738583824, 0.15240410710246183, -0.21095456047658226, -0.10317241466308223, 0.11675474224556884, 0.027508119772294039, -0.066978686868541693, 0.12747687088730417, -0.075862787360520656, -0.19347383180639957, -0.12409362839909872, 0.15218916381401323, -0.12908673557237604, 0.055222729334531311, 0.0021826520976024732, -0.21204959573844889, -0.13562993816224161, -0.37025610519016311, 0.0021054226804156414, 0.03297053094380728, 0.10586087968263801, -0.10847870172164183, -0.11613726127188051, -0.16108499653807887, 0.12296989203347336, -0.0029661295247090489, 0.039712262460501566, -0.024979233902185375, 0.10383912749314821, 0.11133613988977192, -0.13127358070341383, -0.1370004713044522, -0.15775762132496207, -0.099623399649751143, 0.067508519687709503, 0.1161042320992184, -0.051416042044354703, -0.21533941504351969, -0.20097715930291057, 0.13289307217936516, 0.097254273684520345, 0.083657560212614168, -0.083851322489496116, -0.042572255913357462, 0.14444657657250917, -0.11496284899436643, 0.12213222806425195, 0.28456120669015139, 0.3305119635085304, 0.07207339988008156],
                             [-0.083767369538260791, 0.15885228816788152, -0.11946319177075111, -0.14826123367592459, 0.20069169218415051, 0.13131497166729711, 0.19287741979982725, -0.28395727831437112, -0.032862363834326301, -0.015485385440391242, 0.057625151133479026, -0.21596663970275928, 0.27828216976671888, 0.29955856378095308, 0.071806891151542249, -0.099153268320603213, -0.18383357254983046, 0.10973813074405314, 0.16711544275639431, -0.24251860009098855, -0.059887335907885746, -0.043312846342468805, -0.1599187703701927, -0.22189262861368425, 0.14705800210681672, -0.088775707906486437, 0.036397507806813674, 0.19547151903556456, 0.056484797531937622, -0.015910828709707312, 0.041380586627690799, -0.065923713405654727, -0.12621220192233581, 0.092085740553418033, 0.022523208112288206, 0.32017927518795769, -0.022346356436923533, 0.13233194919305022, -0.0040921897348407919, 0.011176890210245457, -0.069801969787676985, -0.049417080510494198, 0.19939081305697681, 0.078448105247840932, -0.024921511523133669, 0.026526935125729154, -0.0058362297793806937, -0.097990273194454414, -0.11215429486769575, 0.094611061977606006],
                             [-0.19992775686509059, -0.026381827253427748, -0.089929375723500987, 0.23680193870655836, 0.065006841756992867, 0.45234956560429018, 0.19342868350484385, 0.023291040756615186, 0.062464216783623121, 0.065940550817641344, -0.099864258042565671, 0.072935942719904986, -0.074398122794629332, -0.063234792988614133, -0.17334723616138334, -0.0050186805738378871, 0.10090130020873263, 0.11465964672917127, 0.23358050995427193, 0.081412216192677508, -0.11932905404764788, 0.058634632115529245, -0.16118687610646476, -0.051472081196178028, -0.10078243638962606, 0.17797784299329894, 0.068309019140111824, -0.11156693317510756, 0.25317513043155515, 0.028401376641996171, 0.14487412536361025, -0.2027428382753996, 0.19641062173496376, -0.010940925929996029, -0.020136348224554974, -0.078055994337782278, -0.16623186326508135, 0.14657198789805534, -0.10075483943140669, -0.079000332683658234, -0.30150066964129113, -0.020126446326611525, -0.20593136613263915, 0.010626216646466286, -0.062267242965286101, -0.094939502041245627, 0.027001219192819666, 0.049751955087037357, 0.060898725078774175, 0.064131680403801156],
                             [-0.11964874146880919, 0.33748366306832384, -0.14108526146184663, -0.058608324927895902, -0.090380227280431116, -0.12397680296966516, 0.095946120199932108, 0.34232825245924781, 0.032555062082377038, -0.11476574551393866, 0.03514319422753634, -0.0843609579470712, 0.024303302159649598, -0.042393703584950836, 0.04909595563691465, 0.4294419451026244, -0.22005564180382997, -0.046355440930639064, 0.077882817590423495, 0.19064552968011941, -0.24722109757164148, -0.085023605541533029, -0.11349672222834009, 0.14738906294174234, -0.03352904868748096, 0.19440251065611933, 0.028455838154116831, 0.21484299996082426, -0.021301764938859075, -0.181803276682133, 0.11879160175996675, 0.13590786639408364, -0.019891868207179135, 0.032058569048877029, -0.13234659267983445, 0.030860427631984197, -0.066447808061708316, 0.033053205645831744, -0.079125093697780174, 0.12310835925944645, 0.091035521857180113, -0.0073298205761785744, -0.091307676443879743, 0.17633309004225681, -0.13828250192183242, 0.083599590916930006, -0.014384709823623455, -0.071948296798612213, 0.067062233885819569, 0.090696094780335523],
                             [-0.01303995611361548, -0.25088599154125268, -0.045873229439906182, -0.015364233038847583, 0.11557619969661423, 0.15209173406278001, 0.0099579016760361315, -0.077902663049400814, -0.045266264936264566, -0.096576191688547253, 0.15053166501145798, -0.063081217616970497, -0.0802436431279301, -0.24095990688775712, 0.19214288933047938, 0.029072316203311559, -0.29702506236709592, 0.036510563895916837, -0.15969442882534704, -0.14618400848132124, 0.15075750514015004, 0.11404512902708318, -0.046376352712030201, -0.068785517252209799, 0.21347714586333844, 0.029422801321200509, 0.31669786649181014, 0.13909420073569412, -0.15354750962457497, 0.050446362643349014, 0.21836882403742786, -0.075057845915020779, -0.00037047560120172614, -0.2672283211534468, -0.09470637928003503, -0.037172026204821226, 0.063446586968012142, -0.023994669664355723, 0.028242757782725586, -0.038308317972841691, 0.067307711217479096, 0.018935004067912469, -0.37548331935637763, -0.016794367981028239, -0.094987727981547032, 0.14772256371186418, -0.18049007438007572, -0.11126176469807465, 0.086849648146653885, -0.094388178233234338],
                             [-0.057116894452209181, -0.057760604489823231, -0.043777107872137927, 0.04230501063078014, -0.1816028702035713, -0.19275534244295944, -0.004692351093691198, 0.16581009782733211, -0.041488252864958095, 0.32804489986306551, 0.12083210205592793, -0.040466461614633534, -0.086506662661688341, 0.24816391337210944, 0.060083123558655298, 0.030754787740144774, -0.21863693829645495, 0.18717003339935473, -0.053633932672432029, -0.23695088006502055, -0.099057376854529533, 0.058974522183526279, -0.051614730613689264, -0.07042827876358515, -0.12870876071743065, -0.13109547397256241, -0.060429886290615971, 0.080810240130333763, 0.37916141732756375, -0.24097438912894362, -0.020973956002665009, -0.053006916609056189, -0.029401826802429611, -0.14777705583568168, 0.044247726806923536, 0.013967121035053235, 0.010735848269064581, -0.15444906189990948, 0.078873333885652167, 0.025533046364286594, -0.030827491528313676, 0.050315573271390079, -0.21970932968886095, -0.11392493781864851, 0.035469087954125005, -0.17986743751531242, -0.069499911824178168, 0.24753302831607826, -0.092422979715102549, -0.22885578763687114],
                             [-0.0056334807742389574, 0.19173380894847053, 0.089624462103594996, 0.023323449960546923, 0.045140714478587453, 0.038797016543380747, -0.032015268116964264, -0.15579125073350442, 0.15629197841667167, -0.10096487256996586, -0.051000146896437518, -0.27109556249284467, -0.35009208362534672, 0.20252322316033999, 0.23138040343626612, -0.094618126776020231, 0.10225374683311152, 0.0017770399641486594, -0.27446119735261054, -0.028985289524715338, 0.014652352749015865, -0.19228302011691462, -0.1564697061451156, 0.15202379884552483, -0.17204329549466787, 0.055265938850293864, -0.15998960769422674, -0.059364572121667618, -0.114100305244693, 0.12269894797954804, 0.096368587606903214, 0.04034931966789574, 0.19781092638890979, 0.14476054430497681, 0.064188033337999897, 0.26333541830469964, -0.06428362479787704, -0.072849668532371001, 0.044938361809767596, -0.079268125846537502, 0.019446872531517344, 0.014309515385407357, -0.25311557723831768, -0.11082501227030531, -0.28140177077647444, -0.0076704497397855117, 0.062314507669620628, 0.065320046530229242, -0.019617780336283325, -0.028779630704365001],
                             [0.10323851415476251, 0.01877626983506334, -0.057161286811952053, 0.030046462703070771, -0.085903812172672886, -0.12834154090906616, -0.05077711067397709, -0.036574276789094355, 0.022968665771356166, -0.082368357781632637, -0.44133993795377574, -0.063243865962582677, 0.071970280030659597, -0.05420936978914314, 0.065020627639588491, -0.19571175943705563, 0.053288818552783598, 0.27432333888871102, 0.020670508579199456, -0.034192039229610248, 0.0027104518688146964, 0.053120934865842177, -0.098291502954939311, 0.018850751190965701, 0.045211319165919917, -0.16697203029508031, -0.26312590984109352, 0.062215574649050892, -0.2229448305280001, -0.11290721156154278, 0.20993060946742567, -0.005009421299859965, -0.18159840069291269, 0.0090116061008359144, -0.26277142021851213, -0.078912352386894161, -0.17858653072475733, 0.074646694412093595, -0.1868343449851344, -0.042574287927759039, -0.05493344702591052, 0.12043302450751739, -0.23778397888500599, 0.23665203866759313, 0.27293270369886891, -0.018996885645629621, -0.032864358891713158, 0.09400531214828535, -0.00076555455792894761, -0.028960919094649977],
                             [-0.066316385350471505, -0.24994730831046338, -0.21885217006363963, 0.12060781778366209, -0.19366014340753215, -0.048636588119698822, -0.16395546834796623, 0.17305891552149258, 0.076567511736621185, 0.10874536099319811, -0.057237539788635286, -0.14140304351785268, 0.04147273927716106, -0.066504988593364109, 0.054705956955034531, -0.23119475394457786, -0.27823879147323399, 0.059631472459377603, 0.010530358806231986, -0.030756405587371249, 0.063741603130613195, -0.1599536810331435, 0.050870215007071402, 0.044678638739021261, -0.2321719012216571, 0.26908373146383824, 0.21832322431380211, 0.11897145133078771, -0.11942615702460137, 0.21417127208462863, 0.14806192138433746, -0.043729739059224955, 0.016291248856891771, 0.21114458835191963, 0.034372621262398831, 0.041795610871150739, -0.14658010528795082, 0.16662473351353912, 0.1648165033562253, -0.061248492073384009, 0.13451017816170843, 0.0061693892500430773, 0.23934833480745829, -0.026722092476216059, 0.10303130467419132, -0.097431519277550852, 0.013642791634498854, 0.1832075460788993, -0.03370122566278623, 0.15170075680372561],
                             [-0.1077824084199904, 0.00406087526572227, -0.0014470945631902463, -0.28470157371312654, 0.19975049852454468, -0.0087028976037416723, -0.082181453103402358, 0.02201191791761075, -0.21516939155161452, 0.18487268328875339, 0.064065395302047801, 0.037450352246673313, 0.053731081500992553, -0.19023481050649241, 0.096831789438785648, -0.11876587797728012, 0.12676077594890289, 0.07794435112660146, 0.11017093864154436, 0.16663257974535439, -0.01497747901137278, -0.17256614855945329, -0.010336160204038628, 0.10878236624177864, 0.1241098632958859, 0.028383593301802446, 0.047108577184841821, -0.054733707547940887, -0.010583265446715277, -0.025200296824833723, 0.16287788574112508, 0.059456938274397825, 0.3158250371762627, -0.10384368960482372, -0.21604171891965179, 0.17176846447345465, -0.2053576088590196, -0.12036279125746339, -0.19790091962492215, 0.045203343443073189, 0.11231906192304639, -0.094909132383739839, 0.19676515140990272, -0.025415074472727048, -0.035910487059389498, -0.19935475358388621, -0.13682951943752417, 0.11741214380640963, -0.15958985305961321, -0.33280414534276676],
                             [0.22861494522551953, 0.22051090259850878, -0.045738841439319854, -0.092550161849309004, -0.013381750944296781, 0.16937892838592775, 0.03634034820052115, 0.095874517909252319, -0.0021260145329003023, 0.13513257907569581, 0.30079393510834707, 0.12934503949962167, -0.015215485719830691, 0.22510644913579114, -0.12083051766917231, 0.0047602748718601883, 0.036993373147973602, 0.046260822840233251, 0.059535028237853692, -0.15140882173844697, 0.20398717187654614, 0.15629302024293101, 0.064435212068934031, 0.16051581825423203, 0.0007770348888582508, 0.22695980025636123, -0.08281578244446916, -0.21521286908034873, -0.25775769134339133, 0.049615364294368136, 0.074020100317525997, 0.14197315609072639, -0.22506052480426195, -0.10933203352811317, -0.07161602556371377, 0.082369500605082746, -0.093345287996343423, 0.27122842269824621, 0.0083889812200011269, 0.089883051852320026, -0.019774971684621178, 0.15837261375291045, -0.033476969700049923, -0.089208727962847706, -0.016531296739078966, -0.17950214735046766, -0.25254489386844298, 0.11748955730889371, 0.15269289634272934, 0.0050749264175924316],
                             [0.053922122280548587, 0.012317594671799654, 0.017971101369570846, 0.1994877067272243, -0.089679787651885598, -0.0070479127746022312, -0.076169922387823011, 0.030446681866845828, -0.33905648764519342, -0.19712006416449829, -0.16101789981651823, 0.19627169707483985, -0.063986231064456708, 0.095680561679856682, 0.017955424826932308, 0.016489801144682764, -0.030315234498122231, -0.15323878855445514, -0.0015913375269554074, -0.13717439600912512, 0.2695410681156673, 0.031606075338357853, 0.097311860498969505, 0.030796239334307869, 0.021876510941736121, 0.0048196317450464538, 0.20015147023762098, -0.051554765836859452, 0.2162644982280415, -0.12527407380951142, 0.080438513096764475, 0.21596097608618284, 0.17104495469403236, 0.071355164347009392, 0.072423689117526349, 0.21237329342847452, -0.079420177657743479, 0.24715099530899176, -0.065061312887486789, 0.12295252658220435, -0.0081779889702545388, 0.2804394134692908, -0.056074593630103024, 0.17003564425670586, -0.036907974407542586, 0.098320379499311342, 0.11341401387880232, -0.060907817500599364, -0.32938170099798947, -0.074222553540179564],
                             [0.11758021940761187, 0.049383799575546887, 0.072176681195914971, -0.023166487808245793, 0.031953919572466766, -0.12634320441774727, -0.17911070088583339, -0.1343723125565873, 0.042390700508265378, 0.28426017073195597, -0.022914006587498009, 0.11693860328165175, -0.31781626979724059, -0.28389524784082248, -0.23394220971640822, -0.084089067436334777, -0.18571603866916853, -0.11538815922686316, 0.037527087769955787, -0.13373414825649271, -0.043110388947781839, 0.08883993684497514, -0.058801017982202407, -0.0061235711457621935, 0.072700037430257519, 0.07701150692646834, -0.15351299317269612, 0.24129245425924509, -0.044987057805944128, -0.10805542563785785, 0.012750981557583889, 0.1072251460952531, 0.070848979771545043, -0.037794977014886981, 0.23188966397465002, 0.21154008606948863, -0.25822554530679898, -0.093149077192084623, 0.047155186106319219, -0.023576961047867499, -0.29437855075005998, -0.041368850190253909, 0.097185151538759243, 0.17188730780796713, -0.022384062794053746, 0.035001433746887502, -0.056645849202601198, -0.16438262509750373, 0.14120380217376319, 0.097956425254287383],
                             [-0.09428357471297194, 0.089663117146255716, -0.10499187565687809, 0.044356545511190913, 0.0070220648536842897, -0.046653235732785125, -0.097129987371045043, -0.10049247120920268, 0.05845480060859206, -0.19135815803897691, -0.051791669174357714, 0.061890256121621724, -0.047082982769609032, -0.12587809536371841, 0.23536863263333191, 0.20489915969944608, 0.26726822018955343, 0.07550869498817854, 0.12598304817744571, -0.044781589352555246, 0.06322745493524555, 0.25653966232315201, 0.14684749189692095, -0.25932795842764017, -0.070961691360979004, 0.15412480050440572, -0.088482952667175582, 0.17765735669785496, -0.089447722791801132, -0.12273838019846421, -0.058461241021806748, -0.039917162519628784, 0.10007031438530609, -0.26009968797601973, -0.075054261688239005, 0.19071178136116315, -0.061609148121247265, 0.082792890987327422, 0.31419747470796044, 0.068221329926141466, -0.037839023572409702, -0.12116363734870486, 0.097955891095559702, -0.14019358271910928, 0.045579687229332075, 0.11915801666744336, 0.088844789994650647, 0.36364359233082205, -0.010783128415202004, 0.029258147317700482],
                             [-0.21552830551254787, -0.039751404523557403, -0.12898445503908001, -0.10061301160487966, 0.066598881395703552, -0.10126780373140087, 0.10348720315717284, 0.24009458697972116, -0.094118505493609589, -0.28529242532308419, 0.32485424885313008, 0.074235867033572892, 0.017599146735912716, -0.066610079595966293, -0.10778795376683024, -0.35701748725740895, 0.2327560341950457, 0.034654762386422379, -0.081363184831080293, -0.092972029061450856, -0.059637687082698398, 0.0019646638234006655, -0.038611139009730094, -0.17736052482088485, -0.16827484903276196, -0.082856938949575715, -0.11078050796833577, 0.074935906916769102, 0.012883184728401531, 0.029847549262761442, -0.012386228697493814, 0.10208105938104772, -0.056133470489614104, 0.048548406575798939, -0.065169306659961054, -0.14306594298753947, -0.28732957750686861, -0.076637379688668725, 0.30917998956102954, 0.022421958603020174, -0.029359923537503999, 0.14341460580662271, -0.065177564846261749, 0.13038538279009379, -0.16301230224572677, 0.0043581972552358059, -0.03550131546709244, -0.1952232896213292, -0.039076040614018592, -0.016634571301493168],
                             [0.19875983198011149, -0.079132789226058112, -0.14189621014397991, -0.060335409797895069, 0.23740115739323325, -0.048958453838952358, 0.054934335046657588, -0.12617914594630197, -0.18191437773090757, 0.045314857443744597, -0.35632173514647397, 0.006129919006602075, 0.033735729325715669, 0.12807095694048293, -0.17891194301688806, -0.048909529905888822, 0.037555692236594176, -0.027404304119951532, 0.100123975174282, 0.066202794679979513, 0.026251617229601756, 0.054690713858952335, 0.014286723612587302, -0.042043323799846904, -0.24458252488419382, 0.31215407739992995, -0.040929289017114394, 0.30429900272604354, 0.059130426506693735, -0.0077317543160965478, -0.03997957678621139, 0.1018245856003652, -0.0084997390530341214, -0.0096962325771637985, -0.11137660839487457, -0.11619530467938551, 0.12177799625125402, -0.21666891129398391, -0.0037466219289506628, 0.058019618934714454, 0.11753669899892241, 0.14547371996685729, -0.085316730234253901, -0.31832214266371955, -0.16622104808900023, -0.0069370109862336117, -0.23186846817594584, -0.12378393700977716, -0.090267547120002331, 0.098332099097809392],
                             [-0.017628110620746363, -0.1230133684270147, 0.14282567902499324, 0.25198401700311385, 0.062755472614710026, -0.11945644751085753, 0.39335917967898182, -0.17897764296765162, 0.071502802549880159, 0.040521963106443369, 0.1738183623944613, 0.11888114097736932, 0.086988667521545299, -0.19634801000603069, 0.21379112808882514, 0.066081898614354442, -0.12304273715359139, -0.1111730870490677, 0.21216921867671093, -0.18095247145203999, 0.087359856166637939, -0.029414212896875694, -0.039347070189198051, -0.072452758823907198, -0.061421153519216454, 0.19391087954233094, -0.28682990686028598, -0.12676559584214239, -0.055567980342761329, 0.091550269864539, 0.0049138600509985326, 0.087474272953890708, -0.0044632129462631375, 0.16488681682896825, 0.073428720183429677, -0.068260677463698766, -0.096333817403269836, -0.22274552832987424, -0.14583841376049111, 0.21142474605102768, 0.1958932923913734, -0.012650017822947005, -0.083804206069493334, 0.12075096397993147, 0.03666053327559924, -0.019392704182694502, -0.017625175629659783, 0.14408689392799351, -0.14519055160979411, 0.05337422105736276],
                             [0.13495670651096764, 0.12932547860969118, -0.12300793854840626, -0.048395873260415556, 0.079576957677928134, 0.11735012942715606, -0.25086587743280619, -0.21054523443666479, 0.10975056255740048, -0.028738579824305936, 0.069529197505407994, -0.0016705866352223211, 0.10567898628377645, -0.094589267359298748, -0.12919809060600335, 0.23312945535302818, 0.098358490496718923, 0.29523206526234141, -0.23343080887118745, 0.026493670345328284, 0.18275928979522252, -0.10647796737503734, -0.14321129293751231, -0.13101605658487805, -0.07652494376919626, -0.088880134780838171, 0.13005950808592145, 0.11307014049719094, 0.14941123711827831, 0.049299795820049334, -0.13237144639874374, 0.12568010393610532, 0.064526392909730945, 0.028515124885953619, 0.26579675621045362, -0.21646386708989862, -0.20524111263067615, 0.038493186685253158, -0.074772051872085799, 0.19110494248586979, 0.23483251386863227, -0.075137975561067438, -0.093031832613217805, 0.17584586376431025, 0.028461500466421995, -0.19717836160392935, -0.07573178664296952, 0.094288946174039934, -0.026217803265406219, 0.10870917802609453]],
                            [[-0.089760150688586907, -0.1166441213630155, 0.19127754959499105, 0.33312086006906277, -0.084022296639507887, 0.15707161880969506, 0.0081420938498796055, 0.27309051428657832, -0.024235533121367281, 0.2255845758657001, 0.069759714414505555, -0.098966462746495232, 0.12342317064060002, -0.055112675365642447, 0.1112106398245981, 0.061427261831202153, -0.11664488473386013, 0.072079988909365844, -0.090373761868963481, -0.039202125639442378, 0.010215815588838778, 0.037844374870384785, 0.053748336698730997, -0.31080946542690041, -0.14995294060889894, -0.05636598906275548, -0.086867161691384351, -0.16061494427994555, -0.19102991910519077, -0.036410770784245809, 0.061177042072150911, -0.057298830389187337, 0.0010332116377082398, 0.18547915449398655, -0.1465757206418592, 0.076444241086688097, 0.22365954071986158, -0.25764098749745601, -0.22352867238040891, 0.003163534575053464, -0.026619507764811461, -0.063555798252089749, 0.021811285511839987, 0.15595883816776851, 0.062334639905403839, 0.26937345547580077, -0.13565966758158129, -0.0034651882357648713, -0.16115046160182278, -0.10947037254526555],
                             [0.1818731461805575, -0.24003858591787733, -0.12087609963998697, 0.14238145669183977, 0.42938993743984905, 0.052732414669521332, -0.084284242513904636, -0.20589819960699701, 0.16762719966181333, -0.22774757607638577, -0.12005931629362952, 0.12491690575159248, -0.034525287469525559, 0.094095673351635337, -0.063211053008817561, -0.19407569683007697, -0.071556203998871207, 0.10962179290323637, -0.071324412133582635, -0.038587789876696713, -0.083512970488402088, -0.098147843591093478, 0.0051785082063848355, -0.024454960715869136, -0.0080616693911560056, -0.0033444150776030615, 0.016841038375959429, -0.078186600225026617, 0.20098214821868313, -0.12782422684442374, 0.013222032289681895, 0.015316170560310219, 0.086921114022465509, -0.16840352032369163, 0.10008374746043648, -0.010327321155220524, 0.060947860777714837, 0.022530097795115334, -0.15791443441153538, -0.044340003121763859, 0.046091981151700087, -0.18681669024530453, 0.087186280548371825, -0.057159500828768098, 0.34433828023779239, 0.28072457338870438, -0.15233509685911367, 0.053696253704620625, -0.12251087551148093, -0.089336291113453981],
                             [0.2221207075844458, 0.26642778198082756, -0.08526812910214103, -0.00053428498282130903, 0.099966535579884608, 0.075959767626251395, 0.24886025995222988, 0.20791454186164943, 0.017218494662398314, 0.31880884091509332, -0.042749512721310112, -0.13319568602105633, 0.061209389950733724, -0.014124635179321748, -0.054054554811060973, -0.051920988243114072, -0.063096153850910788, 0.008347717016761496, 0.14836181269380827, -0.055128770302431566, -0.070869189169309968, 0.16925687251614951, -0.21654699465945421, 0.11069649144015838, -0.19818377980939633, 0.20840006505600664, 0.13074159598443888, 0.0067263815551861818, 0.15097868583237423, 0.16673011271776764, -0.024216971760561309, 0.020629517406930704, -0.021423704216058045, 0.0050907945306053089, 0.03525047363956612, 0.029157943710445576, -0.080743156641045519, -0.10617756165233569, 0.07409026806175964, 0.0091135584040854395, -0.11133306012340628, -0.25383244055627679, 0.33963312973817983, 0.080524924016209518, 0.27679166805571859, -0.12081329654504147, -0.080773233702525565, 0.086907305432321072, 0.11917105585653949, 0.054357454333922722],
                             [-0.050058168788903991, 0.080308176589742819, -0.13031429746621312, -0.13239981262852016, -0.24152989775873274, -0.077441624385513913, 0.084058847577937065, -0.24847105737306135, 0.10299650729465486, 0.012444579524580708, 0.19121527086140952, 0.066065479771274152, 0.05725656627166182, -0.2568745425159929, -0.02026972008761866, 0.0096754879524094482, -0.11956526847050675, 0.039873840187372368, 0.21276310099849977, 0.11519893809252209, 0.0064781853930012982, -0.16567801907259674, -0.0027908084562533863, -0.32814212124229847, 0.085146673127804023, -0.13404825726312319, 0.031300137678890214, -0.21286119703202308, -0.020113998811802074, -0.11646295992863694, 0.030524175284134342, 0.0047471728758649422, -0.0065367822500329784, 0.32233106500103897, 0.093599462692747618, 0.022420336668935469, -0.30303744118196635, 0.11701289002119715, -0.042351452725521148, 0.081799157560812283, -0.0061751874640371711, -0.21267427666302577, -0.087610526376348169, -0.044339474734350376, 0.2332486053646747, 0.015082112538354921, -0.12681365430306188, 0.20956851480628372, 0.060866321834224316, 0.073793510824822162],
                             [-0.042922385070859673, -0.064672744909795035, -0.056133005498643002, 0.081374975675632538, 0.016686710538663767, 0.087859026901188297, -0.018862825939511947, 0.22280906712698251, -0.26418813821340731, -0.21772466362156348, 0.072312369180532687, -0.079573691079815032, 0.019485009958384897, 0.088980381969537531, -0.15578311574550976, -0.1511777270929329, -0.14211066791548516, 0.068757037870437646, 0.21598854103092402, 0.26367309862491789, 0.056430856642228605, 0.15292161950363856, 0.19886410238926025, 0.040061788177101251, 0.055694813598428282, -0.16398831542922135, -0.14361956235935824, 0.11004258153623753, 0.20184379724203533, -0.073724741892905385, 0.15585234179880064, -0.089830963250857168, -0.19605335502434856, -0.053674425432668357, 0.042659898107821774, -0.15293883398287786, -0.039605867885763577, -0.095895357345211082, 0.12661796413578774, 0.045084441539998424, -0.22443350656370648, -0.27460316868280976, -0.19494206886117793, 0.12129907597355692, -0.091678470584173222, 0.0014647441380593331, -0.067803694315897708, 0.047615736756785723, 0.23548901266731145, -0.21762888948279635],
                             [-0.059291436021808079, 0.10801120791600453, 0.086392366519481817, -0.17794035458449406, 0.16999984503570845, 0.2574166923893384, -0.064757904880047415, 0.090307200041367955, 0.031885080329060629, 0.20700061437476172, -0.084113936814026027, 0.022956237655847821, -0.1072408364078257, 0.17376562275532484, -0.35863979032938098, 0.17598127763015955, 0.071805029683083971, 0.15934005111630212, -0.002492557076492419, -0.2373901222542969, 0.056603865180958821, -0.076344090347421845, -0.15731057063754689, 0.10099976224711411, 0.018810151020474421, -0.27733135005606935, 0.028734382720875317, -0.20425064307319676, 0.060319310165119606, -0.14183962907939401, 0.22461637572754767, -0.0048446644051540156, -0.17367381897513387, 0.045933503454808705, -0.055454870832417062, -0.16624031727420505, -0.087660856320944835, -0.12229159134726396, -0.090516280860234583, 0.20963353188919912, 0.05687046213427982, 0.042894670722612584, -0.094360741917318386, -0.25294612779102937, -0.11354144171383189, -0.0056650367003995847, -0.080099570631749259, 0.10939081660722498, -0.064733523403305321, 0.096314558522812815],
                             [-0.01609676259431736, -0.14484684429813846, -0.27964617468036329, -0.04364973323950902, 0.13665590579371581, -0.15240420537364699, -0.21796325130342861, 0.06788175132448232, 0.084038264388068606, 0.19655988229846599, -0.10157097252208795, -0.25154325910060671, -0.083997168398804417, 0.049693615672368227, -0.068672689924170804, -0.11790956312109113, 0.052037624542115794, -0.15643930589893507, 0.10976441315473999, 0.10068640314811575, -0.061697357410309871, -0.10427534982103259, 0.045455612484289469, -0.11721530076204467, -0.18518580294905895, -0.10544236277294922, -0.071405176155282524, 0.22334712574557417, -0.13647068320535488, 0.04755212791655912, -0.050523589909413358, 0.21647996195541094, -0.11072342514493998, 0.061113585965976769, 0.186268930922105, 0.34703426011821364, -0.081991211982939488, -0.13630776357918739, 0.025841992895008103, 0.4021412205622002, -0.025217840570217948, 0.022712371233416996, -0.050286226061369732, -0.098545094084497104, -0.0073942260544853731, 0.051197299327968258, 0.11103046827920569, -0.1123022057795153, -0.068292732608022433, -0.046602327892643701],
                             [-0.17506864622677448, 0.15375362839686771, 0.37654137015403355, -0.071490672651610104, 0.16804746111947169, -0.1765333794836049, -0.12559118743424888, -0.15427814044568169, -0.17601622818019569, 0.13076578110971571, -0.0031859718229239344, -0.04234039438819593, -0.059809176934697859, -0.048541013108400609, 0.041789663146286959, 0.16609452338082958, -0.1899962202579063, -0.0080269129343305129, -0.15802070204529159, 0.035162387088781104, -0.034409541210305532, 0.15133831947628373, 0.087292864827351907, 0.17443062752620381, 0.032881689127204336, -0.11538076962270924, -0.028420692547128371, -0.20297899658244137, -0.029057511695658435, 0.23772586504293278, 0.055128870001494135, 0.11976259115824305, 0.0162710932628823, -0.24489463585988511, 0.10827333209540149, 0.27348555658691504, -0.12020427333278333, 0.1716339475679563, -0.064667105304931874, 0.1267859729289636, -0.042603796607366531, -0.035017087769378341, -0.14480986543833574, 0.16420616008153388, 0.18450971747180331, 0.036796955482686751, -0.20249077210954883, -0.03420653862400494, 0.10723686074538356, -0.089867223776350522],
                             [-0.053139507543090624, 0.18533195300068431, -0.030391988029539733, 0.025334921696090397, 0.068785679930109464, -0.26619381579515639, -0.050608131408870022, -0.082486348499077197, -0.11216193579957903, 0.06592334886194598, -0.24728295513136267, -0.2330178838133693, -0.23747041940861427, -0.10700392562341739, 0.14217091936033885, -0.062395376607650196, 0.21347160217122826, -0.098416134672914588, -0.0012377083747442997, 0.14855111113746219, -0.01781242511861033, -0.02929875816772632, 0.034149535926778413, -0.09517690864835017, 0.17363619059876695, -0.014964240396970889, -0.047919671487830884, -0.14937240340860891, -0.055035985268545383, -0.19409328855976285, 0.049740157048592741, -0.17885132507925575, -0.39266949703640297, -0.11842076585958392, -0.23374640486125997, -0.06189196226181496, -0.065785607327815687, -0.17930705096674701, 0.024179286312065236, -0.25804036834803612, 0.031194416808314068, -0.059671867109853512, 0.14921307138586012, -0.10673686951543712, 0.11458301644838341, 0.080458771534762816, -0.062529994513765091, -0.17414427329701415, 0.013018770867970562, 0.10289666021035344],
                             [-0.039916859026344398, -0.025236686769861738, -0.1229136381419392, -0.016844821875919094, 0.03816101209802427, 0.02387439975706843, 0.12159959880720307, -0.13430496614131968, 0.12703379604135642, 0.011854676433214925, 0.024844826824784252, -0.14739261153849267, 0.021685299355327273, 0.27934468938846607, 0.13874998544818212, -0.10325742595135395, -0.090886800751409702, -0.37034521352270461, 0.093518229798621608, -0.024984429472771255, 0.01357591423024283, 0.13997805470519728, 0.059005826269512916, 0.12737775183802733, 0.12156972615837465, 0.077430052311297473, 0.11992735356955618, -0.24051420927471373, 0.15763047308587422, -0.0026551044970562756, 0.059428859288790395, -0.086720200751008031, 0.1668317571084173, 0.051345995272561749, -0.36366442905233148, 0.052288453634087621, -0.24176328989339657, -0.10265594360588633, 0.14560274335734877, 0.16700360698082148, -0.032666843778800379, 0.12682405577744338, -0.090033534660424686, 0.1994457370767985, -0.14520739954501924, 0.21976267307234282, -0.024631680575778928, 0.14882120114842964, -0.18934409340983099, -0.02743875253161077],
                             [-0.0077885412720070015, -0.12110649973789903, 0.21529305531310433, -0.20391856736121178, -0.13224329563685094, 0.11618144790093742, 0.071410969751322856, 0.079460213487326792, -0.13691763512434896, -0.00074639462803858245, -0.10097537681487845, -0.015227193660152597, -0.29268132711927747, -0.08331272357315421, 0.01585361437596083, -0.14898266967961632, -0.074719154575360117, -0.20618168659176186, 0.0073929450276912743, -0.025097039913689164, 0.34302056421559962, -0.25992710177087336, -0.060191632279786619, 0.14087569593891883, 0.19621651502180029, -0.061175531371684737, 0.18408413466204401, 0.10503748500774031, 0.016034250944539294, -0.19221464437615263, -0.17555488988667631, -0.044698738339960471, 0.14024490126702974, -0.0060051270593213454, 0.14180429743732759, 0.055900422565027794, 0.11995791112638896, -0.12606825594959423, -0.086574507860173788, 0.10265134069984518, -0.17399847372680749, -0.19233310709225301, 0.042577146927745758, 0.19693191649904124, 0.086696142694914241, -0.10148619697455954, -0.08736463599045137, -0.083308994963922731, -0.2258127106870752, 0.11644946936805059],
                             [-0.25392823072648713, -0.24741383769578326, 0.065130752655822716, -0.061152805228967343, -0.081229742435560359, 0.078996436961682487, 0.1578578380976666, -0.0095999709052653689, -0.13394523645605172, 0.09192440993369462, -0.0012455770169056185, -0.035671552970603496, 0.12066108038131089, 0.065210850846780563, 0.043702922417663721, 0.11252641338331075, 0.11654171036230108, 0.026187105909024379, 0.25534408424968352, -0.0014381314216242837, -0.15978310239189919, -0.038637388946630033, 0.07285788994007876, -0.014593304148547594, -0.053462202901767668, -0.22799982836284624, 0.37400669069779546, -0.043217192774018309, 0.15562829359017438, -0.11495809250072929, 0.13534680962126994, 0.24001336738610438, 0.058879353920562795, -0.076780233325271757, 0.088863493607588287, -0.058805669334767149, -0.047985188073316296, -0.058448170970016901, 0.14092154566682408, -0.18711776729636984, 0.06121751134941554, 0.20150505495549859, 0.10823663076845262, 0.030941303639523656, 0.27669964102285632, 0.031000511840964116, 0.18416731838347428, -0.25670422522679176, 0.0046093923141941658, -0.17253357095234703],
                             [-0.046831029890822669, 0.16459742608902908, 0.013492855048691788, -0.12483682392002926, -0.010729884525144348, -0.0075097839975063431, -0.35963905186072403, 0.06172562968713606, -0.12719770267858929, 0.04546373318928143, 0.10131813562359979, -0.10130745708754384, 0.29540936765357445, 0.0094952569141594449, 0.19054368886668213, -0.24001743291055982, 0.010416133697521996, -0.11187415885597563, -0.04704602150283721, 0.027024033242863107, -0.065507769013231645, -0.024283704863884568, 0.025828948339825415, -0.022327913527985362, -0.032484304867214535, 0.036654369248248664, 0.27959986188090058, -0.14602168562456549, 0.090968827826644713, -0.049933760615211834, -0.12006867457171078, -0.23466009600230206, -0.15426352733078413, -0.10253208169537395, 0.16274841079090482, -0.22413235612509222, 0.19903050307001485, 0.041982485385564136, -0.17355289058207152, 0.22230103638619028, 0.17786057171608927, 0.054180353523149753, -0.0064709981093724099, 0.0063296709847346514, 0.095841787768504869, -0.09059910648211135, 0.20464857244601373, 0.24841503180799576, -0.032503858739352083, -0.095799309805239694],
                             [-0.17436402418262659, -0.16696039963164461, 0.17395452252718213, 0.024769571146935482, 0.088411361587708695, -0.0024981026449910947, 0.063724964088512151, -0.10652486104756835, 0.045218652519461916, -0.059543226299018058, -0.23086927582588548, -0.13622311649226318, 0.12883315026360309, 0.072187643422191861, -0.21939177648650324, -0.25057410457549761, 0.20482553009964471, -0.05748337306480885, 0.23896492085775975, 0.047858373969120134, -0.028838184122769572, 0.21228792779283615, -0.083977009174924358, 0.00026938806003254449, 0.07245590272442351, 0.17234243603768731, 0.21036291929907266, -0.043605984538598007, -0.28618741952444382, 0.076634954733611621, 0.090592097492670873, -0.078377239463094286, 0.14420636713590565, 0.16312346949113296, 0.061426200086448987, -0.0031511117380053359, 0.055970954054664991, 0.071512958488404721, -0.30156755407713298, -0.0059554012289737071, 0.11715747536400638, -0.13059786385916075, -0.087399154869459664, -0.00038852641033038039, -0.12582179049448691, -0.0072045695858542558, -0.088052037398030858, -0.10235082681672947, 0.29733815710438638, 0.15890239230384257],
                             [0.38223009733603946, 0.079581391995893896, 0.094976973934280992, 0.039789711898978751, -0.20036194511953836, 0.0060966358658279965, -0.080126223801203031, -0.069497226185541869, 0.10872571492459628, 0.07361836724792381, -0.22060137272980013, 0.17840651278065353, -0.17322981648346106, 0.12157169790620209, 0.3102304489389523, -0.0092112360014446788, 0.12794203078522426, 0.10326178524693107, 0.18180994419444627, 0.10566667661358624, -0.088173539656136127, 0.14714591005725491, 0.1715928876007515, -0.069070934931875008, -0.10428472362402234, -0.094092753628250772, 0.16568607106783834, -0.027253556285962519, 0.031180965118808652, -0.095536041349621181, 0.21189396593282345, 0.1679408107760037, -0.039139804234535065, -0.053664143262113877, 0.16774946830688239, 0.05552145527150236, 0.022051660669433846, -0.015337547317782864, -0.054718960478240548, 0.011250448259439409, 0.14701539919591194, -0.059169284820050835, 0.005356704050312782, 0.12409365984762746, -0.29099989291927481, -0.16384223984065038, -0.24695774085713734, 0.093371088817632189, -0.11940200228566374, -0.071784344746019565],
                             [-0.19597407770808473, 0.00026608243636410897, 0.11578575039540046, 0.12201891984514367, 0.071876824949937718, 0.038061426100227086, -0.083004159209916981, 0.0050019993650294546, 0.0021882814921238085, -0.13362568330639105, -0.20023844696556131, 0.089331630834509179, -0.14528441061533962, 0.1974485304924315, 0.20443300408285328, -0.042937782423103865, -0.11372465399575821, 0.042751515212437106, -0.05306641358058968, -0.14879762767552562, 0.07044421162366267, 0.016909424509905426, -0.044780059043750098, -0.14648614615049754, -0.15485108701272565, 0.13757555431877486, -0.018215559541468942, -0.0017637377461643339, -0.085851644035721042, -0.026112262565148054, 0.17747499126765187, -0.044891008398802341, 0.026906425315788133, 0.043613244153988102, 0.16390580945165326, 0.10838651798710969, -0.14060095771037681, -0.27718072689464807, 0.20839745067722082, -0.15365747249909237, -0.045039698977407089, -0.011821943651796969, -0.24619502133785209, 0.012371107868294661, 0.21258446663037883, -0.2038034892141582, 0.3030393952452991, 0.29440102564822851, 0.077707930168965614, 0.24038835445313789],
                             [-0.11426146006889641, 0.13101144720980681, 0.27312590392370506, 0.33470039628401538, 0.022165200031851337, 0.078907022852134592, -0.14287162658856314, -0.19736654053242467, 0.083505357722866394, 0.14770569126465197, -0.22306138686503743, 0.063977423094746147, 0.032566010028298585, -0.39285452491518802, -0.21815895539777935, -0.17950095534922986, -0.062473502810534015, 0.054951375602197455, 0.096974131404740344, 0.093753651175619318, -0.057831573305884953, -0.15361007787926134, -0.036840612037949853, 0.049183553097122107, -0.087391812527682869, 0.01621536156717638, 0.043459809450071933, 0.052107311466126599, 0.17434199401607539, -0.18559177439899363, 0.020716453856804627, -0.086698434556522277, 0.08565788207068889, 0.0029290246500397513, -0.05880225972222905, 0.1064021738711694, 0.011573745762703858, 0.083099288490704415, 0.28030798224581932, 0.093697638534652183, -0.098170773969544961, 0.11666121164030879, 0.16106070948552764, 0.043565536996874633, -0.21835727874626812, 0.081482119768955502, 0.14176474515766971, 0.10658752163844278, 0.035540633386504206, -0.058828911093092594],
                             [-0.023435676031605759, -0.03346986542195108, -0.16277090626584942, -0.10287965981694276, 0.12009799206555229, 0.29628255811861925, -0.17155784385605838, -0.17498037853066556, 0.12337468055320813, 0.18602655591601355, 0.048173333981642398, 0.12804413196272674, 0.041231194165982213, 0.015019769794074865, -0.042254754444800632, -0.012930118267479031, -0.00059413013164053973, 0.14535265697100233, -0.058123166627630604, -0.12682597964948766, 0.014259119188544937, 0.19125847545490346, 0.20731504599363337, -0.11354218829151715, 0.028721720357565716, -0.044453078102217006, 0.046260318993901088, 0.060476720461746146, -0.20887400515022331, 0.0065760630722403283, -0.035080265071096725, -0.2785030224592398, -0.17240174067034347, -0.016504780212051946, 0.066230170080970277, -0.077375908546561345, -0.12134754125536305, 0.1503652230987492, 0.18732991222754736, 0.0063606994456557753, -0.069085850521149877, -0.087731142108148016, 0.062887295337920507, 0.42377656963241117, 0.01447171153636426, -0.02525636822196628, 0.070936138011932173, -0.32101253664313056, -0.10682408012542358, 0.18186983890072111],
                             [-0.22700440831946575, -0.02841362601702823, -0.0011782940213855722, 0.282936298436616, 0.027720826257381107, -0.068391404647321116, -0.072621509361337544, 0.10993683225503635, 0.10783979551559385, -0.11226039992514356, 0.025289682543463879, 0.004637915969997396, 0.044910552926180972, 0.084792821255389991, 0.12263573582443237, 0.25257085184403461, 0.061005944310767599, 0.11688314918626867, 0.1831687654341152, -0.04779792701291205, 0.031943901856326791, -0.19191547439651796, -0.022211575676091812, -0.040826707375166256, 0.28446953769236333, 0.4239167119339155, 0.10362368718103518, 0.017902205401034831, 0.014012008623066426, 0.0846766887766357, 0.12504069573889962, -0.043012478021170288, -0.14355736441309447, -0.042505279927809454, 0.14978232160481475, -0.10316834736829929, -0.063887263554916349, 0.066568839922637416, 0.060224654197523791, 0.29010413644017918, -0.20493527851919147, 0.0906001019955716, 0.10595974623205875, -0.061897991602491036, 0.03232776065232424, -0.12641214752432775, -0.27398677385398396, -0.092601935809702524, -0.14682324592602289, -0.053055756332885347],
                             [-0.059838107807029021, 0.022397515227918698, -0.2381401718643103, 0.086160008664300819, -0.19272441642131294, 0.0092090572122060302, -0.23558594072232877, 0.060651272749820899, -0.024937541090972598, -0.067712637312612969, 0.19524926463752298, -0.21596278574196084, -0.16007038123398962, 0.061024458388063377, -0.028409167629150217, -0.070966004287170092, -0.14609825889311046, 0.29293365357894713, -0.10607328203198513, -0.17855264374511179, -0.076705084091344453, 0.14505767836302519, -0.12230785432924082, 0.085349675214976314, 0.17633361472377634, 0.096277625550789309, 0.18815868821332704, -0.13759755606283261, 0.12419720176819958, -0.32576075567157931, -0.092389362194128577, 0.21939206860805177, -0.025550023749030377, 0.030732740880867932, 0.011789377304187615, 0.30379409292194065, 0.11516099042205179, 0.021156208386976235, -0.013595152350638427, -0.060361450630620948, 0.009615826047255813, 0.067716252561494314, 0.039109821769234068, 0.098680497778416268, -0.091168973328825023, 0.062269628389515351, -0.058915442282615124, -0.044055647163505941, 0.24405557629991198, 0.18213450165671533],
                             [-0.18328067229284709, -0.2364973158143574, 0.15101417793428254, -0.37131021958931593, -0.026975349665177461, -0.22697167460982498, -0.19437103443914441, 0.10408015534244364, -0.004610876483031298, 0.094799619060889281, -0.065192026537309961, 0.086980978692538, 0.055752476435589893, -0.038075110064441753, 0.18324778109748027, -0.20528479506100547, 0.09141813836515926, 0.29992850631829238, 0.0178537148839252, -0.031911979931710403, 0.045521607614878404, 0.093101719976859135, -0.16778452452623371, -0.040413980689649673, -0.13717002270807926, 0.14724678640573019, -0.29545933990273959, 0.025951502109781605, 0.34072865926199242, 0.010218377785556503, -0.030310989035235367, 0.010758762799773145, 0.09464459158972667, 0.11852213562997607, -0.053309821817285573, -0.13001101776517471, -0.23429539891013904, -0.067622688810287143, -0.055755169011383034, 0.014739224295166789, 0.0016134534283622141, 0.025484843224885801, 0.11355766492179842, 0.099680780101494226, -0.086363956226108735, 0.086755174942947877, -0.094534587441450352, -0.080417317156157755, -0.040811512714985357, 0.029679861118234285],
                             [0.016427382358949257, -0.13415462846837309, 0.043751031470787669, -0.008251580133612187, 0.055397969489274536, -0.078183321469752209, -0.20828217421444481, 0.10067084619581328, -0.0036423310485369995, 0.021133742350637495, 0.27831495751467594, -0.026650932167329167, -0.19796080671263011, -0.1825895297385291, 0.050529086378162287, 0.0005376631559638695, 0.060372894768605634, -0.24657264181195149, -0.18552206126041654, -0.13921816504860138, -0.33171158762169434, 0.15639202779633124, -0.053107441572970072, -0.10934505889572353, 0.058504687750717738, -0.13584315924023307, 0.14034901115171255, 0.061737699181804856, -0.042062240258412695, 0.022816300062474534, 0.21215046683424038, -0.18536060228230708, 0.34900792586525087, 0.0022001041518572438, 0.10967054827499965, -0.14651754731263797, -0.03015421189229886, -0.10488298257200732, 0.24212565080463588, 0.002826257717976201, -0.087019522985572348, -0.16205019123179831, 0.11032198053514222, -0.23475301467352355, -0.0955182026864735, -0.033439937086787587, -0.16556959893213977, -0.020745447053479488, 0.059537227597099451, 0.014073977253125243],
                             [-0.23629606377537493, 0.03315815425752297, -0.20585980145753224, 0.09705795591299074, -0.020993813635478774, 0.075465911124787427, -0.056982627721234379, -0.0441100452317491, 0.034775548801512367, 0.1864931976129339, -0.044096711202111123, 0.019323261340748001, -0.0080986196352603925, 0.14844768970754715, 0.18300870491157739, -0.14609567180653352, -0.056701792791053654, -0.047072921805151012, 0.039645822342445382, 0.11457704945385083, 0.041818659634523518, -0.070512670041495779, 0.037767020221009549, 0.1998261181100201, 0.22139472181156594, -0.29989340852649282, -0.26314382872634623, 0.0066543713394872283, -0.088092246194187956, 0.1859823944405129, 0.17568087032738455, 0.11429509819760571, 0.10403510829592236, 0.062155183082198057, 0.19051187074345688, -0.13625986980326893, 0.13256361326183214, 0.086990270868116018, -0.12226691079900645, -0.12989012522974699, -0.13695262649661322, 0.11964639267038402, 0.3820539592294756, 0.025831551609285748, -0.019067206740364117, 0.054123592073741338, -0.0054325267017736002, 0.23107821733268924, 0.070792078465038807, 0.18445173769684456],
                             [-0.067031926827442842, 0.090731170465996505, -0.084237915120300169, 0.04060736166339575, 0.10392121775226708, 0.10388939276755578, 0.058903042251555557, -0.10564427878881649, -0.37580714083713113, -0.018716943950632, 0.058117585277658396, 0.055333524573426988, 0.0014731668157138994, 0.0055022721810689366, 0.087689844316468576, -0.017230398937636858, 0.19711130408607777, 0.12801801293560014, -0.34502880868163394, 0.23854880916872026, 0.12541801777901496, 0.011401745835327864, 0.27097627089964055, 0.063648048325619544, -0.23656675306362493, 0.16222833606025733, 0.23285620477686655, 0.13434894454701837, -0.06490688669743612, -0.1360952355066147, 0.11476951580134159, 0.2065803389294433, 0.1158743882228296, 0.15761339034179853, -0.15823071778103853, -0.090819500694021976, -0.15086901102395203, 0.052122516863688184, -0.070553951518733726, 0.19919955373547321, -0.12595801834413464, -0.047105405272559429, 0.10407819321020245, -0.13138464120817245, 0.012288676951735628, 0.081762411366816654, -0.037257815050877836, 0.044673639670121133, -0.01653407583656491, 0.17389088605836203],
                             [0.014975135679583324, -0.18955524231041029, 0.018044879657780125, -0.054312351905346473, -0.064213533010928178, -0.074625092943265053, -0.15453142402300529, -0.13465702032299731, -0.039147154431091992, -0.1204827364922505, -0.17763100027896184, -0.1532013647847745, 0.22814977414368059, -0.039016849958598054, -0.01818387209686317, 0.16895783868621519, 0.12151576738941934, -0.15511699914357543, 0.023473596480583697, -0.23218287262430568, 0.09964270203559572, 0.24875380655357623, -0.0087251112996682371, 0.16291425270602919, -0.11804840705032613, -0.0064424326472942084, -0.1921000514963157, -0.15617751738838317, -0.16366076468235921, -0.26308551150560699, -0.024374040235781828, 0.21223395426636679, -0.088288436368511719, 0.16011604597932841, -0.04764352285835903, -0.059604125911999484, 0.18718493469724906, 0.18157299684514244, 0.23663119518844974, 0.015839155548648749, -0.18434025247751001, -0.19252367395705183, 0.13341791793411012, -0.027472595759032759, 0.10300527326163264, -0.15129495015175964, -0.040432500758003968, 0.16360104396931796, -0.13356241472434149, -0.11778806250451154],
                             [0.1283155936005774, -0.090029169358881611, 0.039547005106228751, 0.12821756553520619, 0.11054602457454507, -0.040179757327993351, 0.076645504438004011, 0.038248391828930452, -0.0014229459172664018, 0.056476393468363251, 0.15588291561825532, 0.062637222585106941, -0.049218921822586657, -0.13269836632725046, 0.0031259587891427358, -0.13536028912128945, 0.15438050909161891, 0.21680010933050364, 0.14532899504710037, 0.072934299874994585, -0.11616649048144047, 0.29911154965038045, 0.048760844462789943, 0.11812006952966272, 0.16895254836006732, -0.094678359351505467, -0.058326321049796778, -0.14940273818643604, -0.12215991823737406, -0.12142407171513506, -0.18838011830095402, -0.080158659998272111, 0.089796839794204844, -0.070059895742472955, -0.026747822207808289, 0.097467427084273292, -0.18254795146295322, -0.091280915277013333, -0.26659808114241379, 0.024030009946814448, -0.36531452170574868, 0.21236034781060495, -0.049334737444705318, -0.13503460667848158, 0.085084755324661934, -0.27414829121782081, 0.20793471152923723, 0.071651137449214572, -0.21736885450410809, -0.036943046106815106],
                             [0.0075140946780345016, -0.18656876017799262, -0.012904451950428927, 0.19917201719371638, 0.01608510786569619, -0.006188853585115406, 0.064819361717079374, -0.097483321976244458, -0.070999076750570572, 0.12512064115105406, -0.07420493603867348, -0.2200934768951559, -0.010742043109830355, 0.20399150167528055, 0.12266805125415342, 0.22918928698711161, 0.057314671908492994, -0.01305532867819442, -0.049231937169049465, -0.024158587520158245, -0.022218487557918824, -0.1757471203784019, -0.022644601391312049, -0.25593177146191853, -0.11601589343935498, -0.14642184842830924, -0.047771818922727187, -0.14976729891961532, 0.31292126071357024, 0.014620326020251546, -0.17387027715384282, -0.11464402922629384, 0.12599599783024312, -0.15781959237061643, -0.081482363150956749, -0.0057086205878996944, -0.029991363821063852, 0.25952690639066239, -0.15871718172719251, 0.06391123593975806, -0.15371355204720927, -0.26714287301626966, 0.020772699356637423, -0.011069149433606325, -0.20830265677903045, -0.23422941879808129, 0.17768444086311252, -0.05717013529073299, 0.13976386275802599, 0.17092906351299486],
                             [-0.16184149409489412, 0.20403474726679607, -0.035136203920532051, 0.055745301813777438, 0.064028052209936626, 0.069151457372913366, -0.1451525239014452, 0.11614971871300922, -0.0037776545442501377, -0.16050229759012469, -0.028837657184419326, 0.21851815715816678, -0.40465191450739724, 0.072062552236161759, 0.0098453765351685513, -0.099900454598299993, 0.0485515552142688, -0.12854722257444592, 0.16479191165729568, -0.20091589458548942, 0.14062258697885593, 0.11439753225794004, 0.12713355323555814, -0.15208785251815293, -0.13198695705011337, -0.093365028273883766, 0.024988923996665576, -0.047903576981979792, 0.10023500927386417, 0.12192840797300503, -0.12587256128883351, -0.03797613965599056, 0.046165788534093297, 0.28175679617391342, -0.23178270185448857, 0.054149522597824337, 0.058277327446192392, 0.21920481250580814, -0.1015143191656023, 0.060096938659761137, 0.026143452651895584, 0.091767529974727563, 0.16625103900369573, -0.051390251745317431, 0.15457043859805975, -0.13766173849158367, -0.00083605726842640921, -0.11833905345465139, 0.14023808454017969, -0.28595386120424088],
                             [0.089232887044970788, -0.076716002736426453, 0.035496239609889568, -0.026272910772542533, -0.25379296745705759, 0.10708384465805969, -0.030260568660794792, -0.27462542849148175, 0.06383220303832686, -0.12012796613075796, -0.060980236617534926, -0.047776536534793711, -0.083768317083330851, 0.16911886402466705, 0.11220694220038596, -0.041614791866866709, 0.065533936263597492, 0.18214243126696231, -0.18560587557610086, 0.22313260236449495, -0.0019780338913407158, 0.021169465532986861, -0.41517614405842007, 0.085519951599387953, -0.12302074805827835, -0.15332994092559135, 0.17215884666132181, -0.057160510819998511, -0.051191115095626939, 0.27410008399575786, -0.040299839587225175, -0.20066708601846928, -0.15864093299356252, 0.15277637179401427, -0.0017838696500232761, 0.017034838011770938, 0.093080539864738868, -0.068052353050841438, 0.11414844945104832, 0.089525272357433072, -0.31638576175210459, 0.065093890043297548, -0.019582315903128474, -0.097584917635095789, 0.073821092976985678, 0.12232343408614699, -0.015291579479281212, -0.088883238499255793, 0.068757395214465736, -0.18397227865601765],
                             [0.0401168599476572, -0.25876417649363742, 0.10135738922979774, 0.04454681004759975, 0.11844344957027315, 0.33078152190930282, -0.11244452192654654, 0.027739614635033168, -0.026894836257142587, 0.062955581905425842, 0.11398645652871774, -0.13388529242874489, -0.094759030243180387, -0.019167823115697643, 0.16982753828164007, 0.21110811715639333, 0.12912799718746867, -0.053513540734327188, 0.027435277541829627, 0.14272572233342118, 0.083278944697724566, -0.0027379599565130401, -0.18225639400911417, 0.092834057122187383, 0.082966223946386419, 0.017516606883805498, -0.038437222393335434, 0.2584967519023943, -0.10726685508637773, -0.13948549444059502, -0.13812562841609755, -0.12294098810501045, -0.095339520684935092, 0.015341711495295077, -0.041808579228963812, 0.12594556570863474, -0.32368535903267037, 0.11615981061443187, -0.031899837947133469, -0.084930859856279975, 0.30406020402167527, 0.054172541225714022, 0.12170827040687426, 0.052176473881117014, 0.047833535608589675, -0.0013363214701531821, -0.082120311094074402, 0.29755438076327345, 0.18615119522037671, -0.1878673995080925],
                             [-0.11636315719427713, 0.056234095056024079, -0.19639529524761798, 0.07711839173281905, 0.12435579180632009, -0.067444535553169579, 0.14012733175903344, -0.15046787642035761, -0.20153254471577364, 0.087577670788577644, -0.068451722257473632, -0.1673394307389052, -0.023085613319118063, -0.06671630622956895, -0.08338913725839639, -0.18356876925300103, -0.0033569978993060927, 0.033540469673032119, -0.12549372925035923, -0.26600536773967409, 0.16696779838622164, 0.0033882224799474917, -0.13868658756638419, -0.25546308252032107, -0.065357841871014705, -0.039765361368072773, 0.13999987733877578, 0.049751186332301529, -0.074550735879259644, 0.072590158235952412, -0.15961805539523702, 0.10822012317099562, -0.015874756988260685, -0.080351943740531701, 0.19911192729693325, -0.17237793216508465, -0.15424677242816989, -0.0024505171709998121, -0.0090932676025024649, -0.24533091879158955, -0.10483189775571691, 0.16795389805716682, -0.1014488351642281, 0.099316723270211793, -0.23534286960812928, -0.067896570436513565, -0.25034661746977205, 0.16515824167979234, -0.10568403058628352, -0.30545268102090506],
                             [0.037117453106380552, -0.15002259986982747, -0.10220987153824439, 0.085063080768450053, 0.1399068682049181, -0.027847284474069985, 0.10941388584968047, 0.10844425116293296, -0.17718406334624662, -0.054246565922338029, 0.017043280079549701, 0.01180224866016644, -0.23700692714543278, -0.16775193413223602, 0.016944788493386539, 0.066350862528169172, 0.086672423150171526, -0.11299689751380396, 0.065691601001048913, 0.035910986298633256, -0.31264365946842981, -0.16432357551813651, -0.018060438384090587, 0.26566807143643895, -0.30224217787799629, 0.047175960219829567, -0.066885049652468637, -0.24528592765160029, 0.057841941418516785, 0.0032858676646027795, -0.051049531537424309, -0.12165935865273582, -0.14758412406989704, 0.28528189193390491, 0.2072020461354307, -0.11107942000660291, 0.069505561060080642, 0.12951997739063101, 0.0068895411425985587, -0.02275052355473987, 0.010752522201897556, 0.21593593068749881, -0.18652601385366407, 0.2630144225757548, -0.011886692605822372, 0.026789100270273109, -0.1237662828788461, 0.016326228538764788, -0.027005828466963599, 0.20388743897938316],
                             [0.16522302922242527, 0.088089615552358821, 0.12762689988841389, -0.030403547102549087, 0.20727872211951714, 0.052793811036253753, 0.14514816418304219, 0.14025527869983262, -0.013813641336573337, -0.3013995392465022, -0.075685101565615281, 0.045884139292816442, 0.25213319103235293, 0.032367007174329644, 0.17645388097870565, -0.11325634579362502, -0.26289905261940072, -0.13498371251538788, -0.13510992561964, 0.018027998057632375, -0.028067651835111888, -0.062107790220163231, -0.17364623144113661, -0.13222353572545825, -0.0036854614652356323, -0.16773595542407618, -0.071248584955883015, -0.15604389318113318, -0.15927873834978526, -0.24266966238463092, 0.024455844928956444, 0.079719638806512144, -0.053558786483044026, 0.057383099247428522, 0.096107057249361541, 0.0011221324325614542, -0.21995958664765511, -0.0094790738538034248, 0.010787086161316626, 0.16316137240574607, -0.028106473669205496, 0.21141195583843034, 0.25577001387109605, 0.035856832935268347, -0.12878823822845087, -0.12246483788208209, -0.03321669112927246, -0.27140696458073649, 0.19215876572800439, 0.027076236548515577],
                             [-0.071625382207026925, -0.20019143525356958, 0.013356315962719264, -0.19355434063047602, -0.08508987933773246, -0.15563031171029759, 0.068486212744686414, -0.020957687058783567, 0.29005525335397381, -0.010884060956111462, 0.039255433141790357, 0.056587489666869099, 0.014137292478496715, 0.022125995158347608, -0.25168861398650111, 0.063706448827027043, -0.015498566985130227, -0.14617515173459156, -0.2680643927002051, 0.011343584571436279, -0.043222912256374417, -0.079190949037433345, 0.25301326346704217, -0.021215945220194318, -0.14689743937166819, 0.078112834774370921, 0.11461081367247024, 0.063370181149033894, 0.090015455585530854, -0.077807743008289465, 0.19759092862696612, -0.14320891352174467, -0.21931447894427131, -0.038417370166140122, -0.045109488824278204, 0.15395852389634007, 0.01142223483070709, -0.10791375066068118, -0.24959248914311599, -0.10058628526810522, -0.23534106333636373, 0.16521357425106808, 0.21675473908165108, 0.14980429510435964, -0.013508533583746608, -0.19825341437391528, -0.073789884856929749, 0.19498989618172152, 0.18935372177935994, -0.091199190101307531],
                             [0.11522988142838507, 0.16588704016487837, 0.010482798333403825, 0.028242099522192247, 0.14482402589185336, -0.042101782866635649, 0.010641485146499628, 0.13516061952669739, 0.19923928069957034, 0.20628212272221952, -0.11361149452657886, -0.11179392852045889, 0.19088025431197914, 0.02196290578289431, 0.17218204656147448, -0.085123145380261431, 0.20116305619432001, 0.018619777401547726, -0.22298264350812735, -0.060315584944165106, -0.03122642054820382, -0.12888767569317283, 0.011154946680944784, 0.07432132430762993, 0.2403544362219546, -0.096919720439754081, 0.0077690532624024528, 0.22344669253255547, 0.16941642108018817, -0.14871573468128388, 0.15171093826532037, -0.0044175473838462351, 0.095264399483189821, 0.3337715496059932, -0.045786246405366576, 0.036758550217746752, 0.056611141637943008, 0.18513512826181711, 0.010651114913101781, -0.10654515965059189, -0.13717092252741492, 0.025958657429572759, -0.3844340394627993, 0.08184433565014218, 0.17143887579552694, -0.098227031949645743, -0.050711434650656834, -0.10366877900812803, 0.097563087745382082, -0.13624565873839839],
                             [0.16275787136098155, 0.059460579321083354, -0.066944240335884669, 0.096229363975390517, -0.11829994871062141, -0.1697568831365566, -0.21394790024393243, 0.16453565444182147, 0.1232770698068652, -0.1427352679226381, 0.067484831187014954, -0.15274334060024056, -0.0055310864247646446, -0.063062147260021989, -0.023628348592878622, -0.032709880278339418, 0.15800425005674262, 0.15418452381841266, 0.085442199608665295, -0.16115159269586798, 0.19075451280592576, -0.3347546893836561, 0.02296727939673527, 0.24581971858272608, -0.20515777289376774, -0.09623230758993627, 0.069523352780690384, -0.14498872406946947, -0.28505161192838802, 0.068840840834468647, 0.17299635380678652, -0.019948795397134352, 0.2125793935288211, -0.17672322144234387, -0.11741345436300479, -0.12738546222218583, -0.26524801671779769, -0.0020275111304588964, -0.060696638640056783, -0.03118246663562349, -0.031796618089459987, -0.086749977278505946, 0.023536462428404323, 0.22723722687455522, 0.031712671511185668, 0.072699890114276411, 0.11743448255021978, -0.03294772827721338, 0.11326017183242115, -0.10185318301965965],
                             [0.094935257466381803, 0.10539542013317325, -0.13152003840570511, -0.0044107104394946733, -0.040733626216405472, -0.062045937211087199, -0.17986406954820691, -0.095013350169078914, -0.049516344214373724, 0.18849374577653977, -0.0007655980796832919, 0.15994578110457128, -0.0078818470795193538, 0.072116423267150565, -0.016816290868683557, 0.23125057550614933, -0.097537049542413337, -0.21813299288104251, 0.2107183872254984, 0.10778350276011997, 0.17338917963648962, 0.14737529257052159, -0.22947206060379316, -0.093081607860632229, -0.19097084262449499, 0.10564198558949711, -0.062894973986975827, 0.1320338730947149, -0.03056705873564965, -0.32882047569057227, 0.069494252350796287, -0.093489749931210411, 0.1958896821320103, -0.19436898975349881, 0.038507286347567123, -0.1603328708058305, 0.085320087023296867, 0.019727553325382403, -0.16337451772722303, -0.012788020065764153, -0.23049201746805961, 0.25186459289587659, -0.16062794696522759, 0.01578268845966602, 0.12802815600086054, 0.16284040399704311, -0.08559315096065942, -0.10324875067835329, 0.17526401244563766, 0.055958902889278427],
                             [0.14109628186793458, -0.16966543364908773, 0.10315856104886431, 0.2535225711077983, -0.015383814537453515, -0.39467969162125166, -0.022931037087543637, 0.0075631708327000471, -0.14592780145381201, 0.046239638379341017, 0.0011567377201024663, 0.24859203537432306, 0.10726088107687963, 0.045964233660052742, 0.030752755203237409, 0.0082295121727379867, -0.15843072032324776, -0.043391840804363341, 0.076990346773930934, -0.2851549368747241, 0.037766772518145718, 0.07761323271241706, -0.056528473088327411, 0.094771827483935936, 0.068263150393169658, -0.25080131862797617, 0.26261692932991088, 0.31580704005101218, 0.020705311216437348, 0.082281480149291125, -0.069817695796648357, -0.010149818034991051, -0.29417123940272077, 0.13330480108429105, -0.14059647636543937, -0.052547978310385893, -0.11558700032439576, 0.047379302841931308, -0.072347353989739516, 0.050734606604926555, -0.0076689127428795772, -0.025296242525261428, 0.02589633732965383, 0.0010560698909763489, 0.0061474831476240758, 0.16435712688308352, 0.038575900806213571, 0.084142673839992729, 0.019655485126676701, 0.2236502954232415],
                             [0.062106538851526824, -0.089465916630187214, 0.096344937215004839, -0.0078437416789538996, 0.16968633973865752, -0.18225602952500994, -0.038371836768142265, 0.29002898684260608, 0.27960647274794237, 0.00017985620672572735, -0.0055947492289396966, -0.1538355641136217, -0.022476494318097898, 0.024845168671224771, -0.099007210907595067, 0.070919630836555822, -0.045207734281131527, 0.10732619075470441, -0.027695530645601204, 0.33851418697239033, 0.38555382971013136, 0.14964246660394265, 0.132135258991261, -0.124753069710003, -0.053789449229958416, -0.14023104444003828, 0.2224153101058487, -0.14470531093361499, 0.029356715991390992, 0.056542062712810412, -0.18919253339007105, -0.0083052574528774403, 0.073421376418225451, 0.035950681027835642, 0.067277700825180947, -0.092650261453817606, 0.073160817196910588, 0.1473366056093284, 0.27844147682931375, -0.10188214069969431, 0.039120726487158156, 0.18205219191494013, 0.010675424161341892, -0.07793261894879959, 0.035034338041315657, 0.03189784785148099, -0.10540478671665728, 0.10203376289793167, -0.031622672822035194, 0.21701662837007588],
                             [0.064433308708482934, -0.13222777972911073, -0.026343483715912157, 0.25120276384029455, -0.15708896037334877, 0.092350076976160447, -0.27805125749779136, -0.14843201112157431, -0.0054683507508467228, 0.14842073603436237, 0.023076121777602633, -0.061009291277759344, 0.091173832938544697, 0.027040006875774635, -0.12659961112212659, -0.11625765008604382, -0.31315413531730024, -0.13005046184522062, -0.083888302831862674, 0.11913891073103507, 0.092482947438773569, -0.03494788916559511, 0.067712190700938993, 0.21096220076261193, -0.090828963059386605, 0.065445564779036985, -0.035238702955613009, -0.068898506208000601, 0.10424744200194422, 0.089884822048162283, 0.00014759174049018911, 0.051000302705136585, -0.0009995493230419599, 0.13964657488188806, -0.056237277244333195, -0.12678280400071387, -0.19552465719990364, -0.13587857841322906, -0.069743551010114826, -0.17735164782370219, 0.18350151358055372, 0.037322574202528942, -0.070410200408802734, -0.18633746523203668, 0.09173619851840685, -0.38905490128949405, -0.16849838498583022, -0.27815604530307392, -0.097801647557060181, 0.01927718452979691],
                             [0.017581714893403051, -0.041158276408574786, -0.014005105133093712, 0.067593529888454143, -0.14522393873190431, -0.073901251244863631, 0.26918434896314142, -0.016890578674036535, -0.060071436031094654, 0.1500017780527784, 0.069807199542602075, -0.0095591159519022133, 0.037595485619955897, 0.091264021884172652, 0.09974857018431095, -0.13470899694073418, 0.031994897647531981, 0.044596301634894163, -0.019761726278432108, -0.229983872041266, 0.27918158594855808, 0.05134408089666509, 0.21153737128843661, 0.18072485583209569, -0.12248804416183759, 0.042729195867150148, -0.11354953247412243, -0.095623670781318906, 0.035845886910553841, -0.1536123123410249, 0.091093908329620832, -0.40043287215625284, -0.0076296669269069741, -0.0088048622586519559, 0.34883701385191745, 0.22861124799180066, -0.047741601901429537, 0.11864141001479772, 0.086974650467013762, 0.035821755979562796, 0.11596380077406045, 0.021689962758921683, 0.049217704183504338, -0.32753175540227769, -0.025901729427491946, 0.16694301205663239, -0.023734582701536423, -0.11107839734361313, 0.066957120989132465, -0.097538922941577316],
                             [0.10761053298063006, -0.17089632115351286, -0.087411964447941928, -0.086666286956173233, -0.095609141502476305, 0.19112562979680728, 0.096695417362452768, 0.0050049060185528528, 0.10893785929813646, -0.041142263932113399, -0.31880145457028541, -0.27554910157511148, -0.1600891438848922, -0.42935535094519545, 0.20284830674706522, 0.059599541434498707, -0.27732659127809317, 0.069987038371438784, -0.027226328934035961, -0.17286832982623668, 0.033921297559837735, 0.16911411992247297, 0.17510520875028587, -0.0038134202358674134, 0.061397788703193575, 0.053528813803137586, 0.032924316301009206, 0.065762879631948781, 0.05553579745563382, 0.1281498959802628, 0.13116497982496286, 0.043845945330760347, -0.037568809925121363, -0.069825570759894956, -0.044510400159370661, -0.24132061011835604, -0.011877030055487899, 0.063636019507065225, -0.1422080262649148, 0.19140260602357101, -0.023062460704296312, 0.15359889825828738, -0.086268818649813436, -0.1205041888412295, 0.065073438522594562, 0.081728784549242567, 0.11431554981764033, 0.0090967109613473325, 0.14695214090451453, 0.019603035290702276],
                             [-0.011802246344967376, -0.12534326824323003, -0.013413629863369679, -0.20747369007334826, 0.12228238144516432, 0.12360939268384925, -0.077997149309551553, 0.18753002972946525, -0.050121181220059888, 0.10732317055516186, 0.075455441175598534, 0.082867635955691479, 0.0088128600083159855, -0.036677005460371226, 0.15263799374028425, -0.18799270603199589, -0.23719196323099326, -0.033218492715217193, 0.1548921725157591, 0.041805988917376802, -0.016395034819496442, -0.15366138935303295, -0.11116484021941679, -0.0072357635120378827, -0.10791312431509513, 0.13472477307568623, 0.15070100839505712, -0.073963929084333385, -0.14158540373919959, 0.039964602779986411, 0.22823964277843947, 0.044653258565046323, -0.1692117236660064, -0.10144631828850795, -0.19889969841336053, 0.20052936200876789, 0.029197926626936044, 0.39078226457234833, -0.0003644120965322254, -0.29093497872905522, -0.22278089591241149, -0.093783185256814339, -0.090267462712447719, -0.24186138807341723, -0.15481317234050893, 0.021742805886741851, 0.019939128952897324, 0.0021173018436132806, -0.15118062707196678, -0.0036163943691561863],
                             [0.22079310249582629, -0.10036434146500721, 0.13900901612593322, -0.032646437153751498, 0.046036447318948077, -0.08850649385996813, 0.096949788458252584, -0.21125687656398842, -0.21218072158769283, 0.020395934279054912, 0.2453038946360459, -0.25039789724258976, -0.098058409154030801, 0.10318657636259537, -0.087126964496054018, -0.21786099285950902, -0.022219936419101863, 0.16474261611146021, 0.11632043105071696, -0.060295085787856473, 0.044887608410328309, -0.087314945061689228, -0.050571608986458204, -0.19411797037765505, 0.0075559273419071732, -0.0043114518743390517, -0.15113901782590855, 0.12034845062780024, -0.042488396407370288, 0.029650753436553483, 0.31909454110074603, -0.057261188933942359, 0.032296341033605777, -0.044696182534041791, -0.20938034855792645, 0.0052540040812274688, 0.23602081597685259, 0.11315649705486029, 0.13708524011666595, 0.17075096763092398, 0.13475622390385908, 0.25877561445229708, 0.063510807587972562, 0.11935451024162609, 0.18515700837471519, -0.2237654201405968, -0.07770288521369606, 0.060377037544563951, -0.037598838319072604, 0.10532546026925141],
                             [0.028605631444368503, 0.17350954503387495, -0.040118653345739101, -0.20012289229064503, 0.081726625680600004, -0.026803758357004034, -0.13727491515098941, -0.05345666109171876, -0.1842279871305712, -0.18994057911252185, -0.21113982675036266, -0.23983690413201539, 0.14489786992857681, 0.086014185754341443, -0.0012179794775608946, 0.25860088251213842, -0.23748711519766777, 0.21288295316810796, 0.20445015414563808, -0.038316773273904627, -0.18319506277118613, -0.088409496068581533, 0.1839420402611186, 0.051775382614025471, -0.048859453743084147, -0.085261466449218226, 0.070159757108551199, 0.19478685374235999, -0.030469377354846464, 0.010312312121290888, -0.086320763591697353, -0.32758004589866535, 0.23360609669671051, 0.2005126343793826, -0.013295503648317926, 0.16843871735596036, -0.0018081238488653448, -0.089285357642785265, -0.074382519718353829, -0.1669870257448462, -0.058527217968558809, 0.075358577797425469, 0.11698309680736292, -0.077696258630782652, -0.055350432825115765, 0.0030022154137957597, -0.12446785146803567, 0.038557846778661829, -0.16057612281386763, 0.018795879617352178],
                             [0.18905842958249028, -0.090892986460297157, -0.13569447753311767, -0.037728693015684704, 0.16650589020569892, 0.16060333776466026, -0.17266234330764069, -0.079532074176178483, -0.1936268337914028, -0.05587413566637716, 0.036186785849723298, 0.14087648381929324, 0.25489763904262663, -0.28192042043498805, 0.077731107135071101, 0.082328116276517746, 0.27139969247982981, -0.086925418522959194, 0.10735868720707677, -0.098465296268188771, 0.30481298830211118, -0.051074033027681771, 0.03405209384129608, -0.07085770847739864, 0.10956740524388424, -0.03354560746600474, 0.033314948244133016, -0.18137320839407231, 0.20127603500269051, 0.27034510327710426, 0.081213486699402343, 0.011288483255578267, -0.013230221888817477, 0.011766969405519925, -0.0099485855034301841, 0.28914911305313523, 0.10829530336140397, -0.27991160664049841, 0.038573503292097903, -0.057134767019027428, -0.074950076303681237, 0.10364698140188268, -0.016842324777901343, -0.0026441989630410809, -0.068631242283074323, -0.019891500255183131, -0.08144686827981179, -0.0089102020801347138, 0.18076789278625424, 0.12598631511747047],
                             [0.097661332390626535, 0.059679497282743937, 0.081252287776555784, -0.0058260845071345249, 0.27391353845260408, -0.15179900840483232, -0.017207540701353479, -0.18499961776147716, 0.031620299476588482, 0.00032442417046852213, 0.23703560072658417, -0.13746275018241119, -0.15797814120745857, -0.044595257077313967, 0.0098756464708587254, 0.20420065322297726, -0.1305980887112472, -0.0015568169753985631, 0.025623266377061759, 0.080737926324507908, 0.21431722112422577, 0.090232989859581184, -0.1009816635150481, 0.027529243922974417, 0.061863893736706539, 0.12712870936733206, 0.050556610670577089, -0.028104431580900192, 0.10164921131528737, -0.0047941489088447961, 0.2526518421670631, 0.058326496070162132, -0.056142117751097294, 0.32053541707496641, 0.21059406746507606, -0.072933489481509739, 0.05519850094836648, -0.059058495674501589, -0.16498694755185961, -0.1077359240278732, 0.028092731799738653, -0.1213558745142521, 0.119910556011883, 0.090801978581066173, -0.1960767187252504, 0.050427331546586011, 0.41469386354356286, -0.11022088932075018, -0.11953777826289365, -0.18492440400015189],
                             [-0.0076973457640502705, -0.083714266629129203, 0.072286092440298294, -0.10819801108420329, 0.2432642941256189, -0.067482199995682571, 0.060493895769095592, -0.2007304193497203, 0.11726995636130742, 0.23659361039614432, 0.14468303860591586, 0.088760413578588077, -0.060892827295963181, 0.067427718458677108, 0.22694031072616686, -0.0086052358441465991, -0.15234041532372558, 0.14735201832705933, 0.15111225814033633, -0.068068933491130301, -0.030210063697825459, -0.21480933914356828, 0.20985203763242585, 0.1305378779902307, -0.020819783471366676, 0.079445863892952648, 0.031664405018923626, -0.061732122989223148, -0.19582112166225579, -0.083440510013313707, -0.30258850277542437, 0.086583160907074949, -0.003879940186230875, 0.053572573916243878, -0.12362440950235268, -0.1858762143881694, 0.20380383069448141, -0.26258186426410562, 0.14372362072870157, 0.050133305506071028, -0.059693017466373434, -0.066037964149166642, -0.055945853022768485, -0.087932647868330868, -0.10207066144196039, -0.057876207115616043, -0.078067153420942226, 0.0069234071532308181, 0.3647937769544764, -0.12392052080895732],
                             [-0.36557805950558192, 0.027141702498683699, -0.26052453398435099, 0.060317528870499078, 0.14867212333099081, -0.095074689054279862, 0.17257449794662019, -0.047088988778190267, 0.18226786214662616, -0.11312656398852787, 0.065953594680180985, 0.042984880331965562, 0.069409631300393598, -0.23798479687461627, 0.21129857567706192, 0.049832351822259806, -0.052529982252450945, 0.10136993541894349, 0.021951914375170998, 0.076471995226463516, 0.1233941223641877, 0.12582805792348123, -0.22753416181121028, 0.18496992693319136, -0.20832270044614579, -0.24641657065406167, 0.079107501025318688, 0.12322378952113107, 0.021528339688244788, -0.097269436605259829, 0.12934591998224326, -0.13142431352108883, 0.013758121185049755, -0.13001798702104977, -0.1522726067669756, 0.098299148523191618, 0.16849762435344307, -0.078775426760846298, -0.052899680712571222, 0.1144735132249068, 0.20471698541879285, -0.12351477074762139, -0.067499855040165618, 0.047984940292334695, -0.045108573428955911, -0.2605423590903313, -0.12105426094634575, -0.048753201187458864, -0.10928109740782227, 0.03008585376268345],
                             [0.068198440375889069, -0.21502254925854275, -0.30426740579293843, -0.030758314779843185, -0.0049754094599334378, -0.20340739008687295, 0.015535113635956527, 0.14592201100136165, -0.26868706008424775, 0.20892340809325941, -0.32958937390771909, 0.27593437470881188, -0.036943131952957932, 0.006387402843826836, -0.11886528668458392, 0.10121089730002379, -0.14637622475595569, 0.12591264250359951, -0.16099946047722052, 0.15427563305999456, 0.00016196814241551693, -0.022513391943691567, -0.097559075056843247, -0.019326766193372178, 0.24432751549474205, 0.081646483234953493, 0.07019999061197868, -0.20544262723719667, -0.14028285874563698, -0.010289972049339765, 0.098291360308379372, -0.14500153799559698, 0.17475653604733504, 0.064983018458821165, -0.080416795930929749, 0.043724093245156782, 0.044463995218590568, 0.027034946474580851, 0.10690084289936409, 0.11260240606497292, 0.16746359820379594, -0.025377999347597668, 0.052938006171370247, 0.095120142296935647, 0.011918618871698842, -0.12312931581619432, 0.11802459189404134, 0.055780435218672049, 0.061183519629161111, -0.24148699795338688]],
                            [[0.15799130632463387, 0.086971581713158164, 0.096049145521224899, -0.17147464471573817, 0.057765762777040479, -0.10824562645404372, 0.062927770322683166, -0.36932860907074266, -0.0076727414147091206, 0.19052971465098917, 0.092267840252062305, 0.087801884251521731, 0.14509437460374794, -0.085509614861777411, -0.13897827947357505, 0.029613043129370121, -0.0035766032913417192, -0.0063171470047649406, -0.13316727843157605, -0.090980950581672784, -0.17914537059776495, -0.085902177029702709, -0.26359533900056314, 0.043013684024662817, -0.23760788686616727, -0.054893472156693338, -0.057910815770193018, 0.025303610645800608, -0.23386569395178919, -0.024595975834489466, 0.0401136430913097, -0.085959968181737803, -0.073342411658299161, 0.2020407446924973, 0.25458774311252008, 0.10679171294276615, -0.032136974359442072, 0.0026863732292492664, 0.083081561083776234, -0.093056920808212956, -0.070906449847089784, 0.08055028397625856, -0.12831162989787726, 0.090933957864232751, 0.27814908966816232, -0.062297569304958306, -0.16874292690748041, 0.043665298002564405, -0.34166738866007001, 0.063434236081331918],
                             [-0.19685705686812, -0.24390520239077573, -0.040194032548711879, -0.16461638090762165, 0.27130142793899026, -0.31863645588918227, -0.065340552666518656, -0.032196899195431991, -0.059957077648017561, -0.078454775482649036, 0.19231792049427338, -0.0070151072278737941, -0.16056594410885094, -0.1516859846503068, -0.017734555102837255, 0.31011676625607854, 0.12295062915588752, 0.11074515268533737, -0.25261146521641142, 0.087328668534289708, -0.14823813629804164, -0.10108059675434831, 0.0030000249024422013, 0.14326012461231891, -0.14984323161044968, -0.12965218934647801, 0.018829202497536029, -0.086229905029174464, 0.16667822483646844, -0.11004247030748113, -0.070916892674854071, 0.019963053939869309, -0.021636135216142643, -0.081064141258325131, -0.18534442369923845, 0.094471337550818518, -0.052626543392033327, 0.091981511267145863, -0.011191782535507514, 0.020414912377863432, 0.05675842734224644, 0.035119775485420529, -0.016445338322736706, 0.11735072521050922, -0.056986690109061246, -0.04783361687226538, 0.056691526048509557, -0.15100978645624971, 0.1457027349574487, 0.35107977303240001],
                             [0.049086113863234353, -0.047885351700897638, -0.0036255155345069454, -0.3632730867593017, -0.090046006938764814, -0.010723316599366865, -0.18163429132680456, -0.038009380038795441, -0.045479837256904444, -0.2871867656575135, 0.045387956639253574, 0.10406513851148896, -0.052217992030163918, 0.14642487910127902, -0.15586974705843934, 0.08410122740597617, -0.046435079344179425, -0.016202012867511825, -0.062154866071952405, 0.0229538830623939, 0.32433684032793669, 0.14724940900744998, 0.12364244567488265, 0.019422408335613255, 0.27226233653497833, -0.036433156651493555, 0.026806374215988762, -0.038167969387185877, 0.16763195500388051, 0.037763584143328678, -0.13778796148874978, 0.25747118741123493, -0.029367049813745674, 0.039165089874313559, -0.048963684886068261, -0.037264101329086051, 0.11033869288711143, -0.042154345222812202, 0.16441525924921388, -0.16540489499559685, 0.1549129562211797, -0.14124841192159523, -0.1559100980639441, -0.0083977773380871212, 0.33397045152526439, -0.13161477646840475, -0.081240735083030466, -0.024606185513546593, -0.21568294513827013, -0.021655874553991233],
                             [-0.14915443258503605, -0.058536872256798017, 0.0085193937489295105, 0.12685042549368433, 0.07387724385173082, 0.19078008989601777, 0.053486545543880049, 0.011424563168815535, -0.078165345051145793, -0.17558173853153261, -0.18266849227259555, 0.12674371454129946, -0.089917742822148997, 0.073833043753713898, 0.085810171139132044, 0.19547940334721955, 0.051739997639825237, 0.087476603012919318, -0.0010638247599038891, -0.05067005060045373, 0.17588394770550883, 0.019103259954308994, -0.19169184652015378, -0.013100291523242427, 0.061015701779934005, -0.035724532828932738, 0.0051269398202208232, 0.051308234529472488, -0.045145586637005651, -0.17291509092905361, 0.15279157085951997, -0.2443519876639185, -0.23126962218055117, -0.25768735282621841, 0.33439967190624492, -0.26430105619848654, -0.22076453590545164, -0.0561434658935887, 0.089095386136530605, -0.2509549036356854, 0.058995075315230017, -0.046806024547477412, -0.11176947952443646, 0.2328700772803301, -0.068007099043252139, -0.16740379376420597, -0.11801358598824277, 0.072948701416345518, 0.081779316217674994, 0.093381477799091672],
                             [0.028333819411359006, -0.10436761618767776, -0.17521602621154539, -0.11720708717582284, -0.17898793764192056, 0.12078104395458288, 0.070116577917389039, -0.093183189686245546, 0.076726633026106952, 0.043542739608626278, 0.30534698203485144, 0.06371400515630074, -0.068350589578224735, 0.11067581453077269, -0.044325809717354218, -0.059708196475511281, 0.16173007396447842, -0.27401843750556676, 0.036251661405088981, 0.045741403050312893, -0.057738729808912662, 0.20486940367181397, -0.15322374656012797, 0.07122833401064306, 0.10677851018387619, -0.10373099141913923, -0.28543074274401298, 0.24149449072356352, 0.042934425336132835, 0.11130087100882274, -0.18453315678326832, -0.14959806758386809, -0.014711631263566277, -0.28932855447809774, 0.033364260375054265, 0.13489579197969262, 0.18063833466952142, -0.14074975254176036, -0.20634841321612266, -0.068148708691975993, -0.17587284154887303, -0.11025126070791388, 0.12515637836455512, 0.21525074598169269, -0.037704218722787272, 0.13184741558134755, -0.064785057153237402, -0.019299611431165192, 0.053245956964033898, 0.10390242111589147],
                             [-0.28902774998803793, -0.075762831370048439, 0.10956569720639388, 0.06620036122184822, -0.22697450029566191, 0.10578489350481929, 0.048497777533038654, -0.015256626369662253, -0.11272368834238475, 0.2584896485977653, 0.15071968358203006, 0.031089945328448981, -0.23345121961656723, 0.02869468185519165, 0.056481274663173438, -0.086206133868165058, 0.16022425271801308, -0.15123090714049225, 0.20283658592993797, -0.088189705141316146, -0.017674319616207922, -0.09491959691508671, -0.046530190644620988, 0.14631800949565468, -0.157053466383377, 0.018554415507019795, 0.10606397335615736, 0.01999904405089557, 0.24742011463893424, -0.292873583422466, 0.074860446301272698, -0.0055291990338752883, -0.06489757948667467, 0.028697082734929422, -0.11967638900455042, 0.028189511990978515, 0.18653251127434231, 0.027248883147177504, -0.07935205184646818, 0.075487133777265181, 0.22351829881023141, 0.146796508751183, -0.087434829899324287, 0.0089950110026603535, 0.23742269617421097, -0.27910564328673199, -0.062949200993176163, 0.13833494717130737, 0.016091585891318348, -0.18894487473153943],
                             [0.12014542928633874, 0.19906693046801754, -0.063186585182783639, -0.27074243751565763, 0.031319059751730535, 0.24386685562901628, -0.33827048649468094, 0.009043084750378818, 0.086260446566051974, 0.17387383652799662, 0.09088620071801512, 0.2115374568749282, -0.12549894326711972, -0.097201228662474867, -0.0021867823333386435, -0.048018741683059363, 0.093987015312524125, -0.13824341414259983, -0.234424729501641, -0.012709853761719694, -0.057638276739624704, -0.0072784996131762206, 0.11260787913955859, -0.042089527461814165, -0.092168993877702179, 0.19337533735835882, 0.074287588154681061, -0.057356381747320641, -0.25438086672131616, -0.12836434797496291, 0.1366098662043943, -0.056283061046224096, -0.16240866065835996, -0.093735223647855359, -0.22208474746224394, -0.11933814118111517, -0.15592359194678573, -0.1530743080575718, 0.022588887219894573, -0.046556458130272767, 0.14844739543893312, -0.12990154617524613, 0.29140296079315309, -0.10612028350225536, 0.023221930552250341, -0.025918121462770647, 0.062850628265311154, 0.11051170452946402, 0.11309220503716963, 0.049897493338458367],
                             [0.29417532741283425, 0.11121995190808066, 0.016643867325720371, 0.22799048955710499, -0.050742780053442217, -0.097644208576521063, -0.09477125765812873, 0.00011278177204254777, -0.049570629266163874, -0.019154156303680663, 0.017692258056392823, -0.17910513543041837, -0.21684911958236847, 0.17155714344106887, 0.057495009137253264, -0.058434378595826113, 0.094918796529456756, 0.17540455373070282, -0.045126759094423388, -0.12227306491133975, 0.086036194259448626, -0.069778798286672591, 0.071699580233341317, 0.14864183265914688, -0.051927947132405144, -0.10818064208159153, -0.10215605154162177, -0.00097801712668253563, 0.24952893419896308, -0.040629231350843946, 0.1085564474893989, -0.064935834961828517, -0.03468911498076889, 0.24454030750757116, -0.056047695858858264, -0.12058309127874095, 0.029382954240113092, -0.1557045113747639, 0.11239082616884125, -0.2003021514428876, -0.38785478454525613, 0.03207305063229169, 0.30594302401818746, 0.034237927644506602, 0.24205694622180232, -0.044853185339350857, 0.0072691072745073616, 0.037684018594108866, 0.12848475805038179, 0.16421403445111979],
                             [0.16084822739021937, 0.15392648056792718, -0.025520572108251267, 0.014469173182879949, 0.28082792624061997, 0.14545611066914449, -0.086927474742819782, -0.14886070558213801, -0.047039722414530444, 0.12929331955419499, -0.091390083018130008, 0.018040701724208359, -0.19312701040553817, 0.1023065682777103, 0.084904037240762689, 0.24650989393100237, -0.1064613748559235, -0.14654088764261841, -0.086021483837453075, 0.25073964912284441, -0.19642743852172836, -0.17647525203134337, 0.25363460979843944, 0.12906858042348454, 0.07880229724900259, 0.13528651478676346, 0.0078165583659749235, 0.030726825932376464, 0.22599940802688534, 0.20415545333002638, 0.054957718198604968, 0.10066098616887725, -0.054518543043527934, -0.043146930331443421, 0.25835180734768876, -0.11637865151635737, 0.18108936645805573, -0.087577371512191471, -0.13002178845312928, 0.12442560303934121, 0.010781301149723954, 0.12741145217326399, -0.13209456574488512, 0.23504404666128575, 0.014110613323283807, 0.058919621176472287, 0.10748417036235393, 0.030254400282976057, -0.027704321699763147, -0.16535726829484151],
                             [0.092626097722145834, 0.12183934274110043, -0.19121601264619509, 0.065142427414738469, 0.12888236463134567, -0.077437100873137973, 0.011804306723097029, 0.095732345438727467, 0.030183547735476393, 0.036559337556538167, 0.38999196756546722, 0.02982106589701463, 0.29644417210551005, -0.010305607434941237, -0.012115473953831528, 0.2018355095903836, 0.074670355052649351, 0.23636599791772481, 0.22144186101497629, 0.20587837679394436, 0.028559024816972044, 0.020974583567146942, -0.01937905391638154, 0.25704866373160146, 0.13583829602750822, -0.023551145966706058, 0.17009811570075029, 0.088701210951385431, 0.067289562302976405, -0.082748108977393819, -0.20200170507384504, -0.099435923080616148, 0.00012758275158507003, 0.042023566753910585, 0.12278354370717495, -0.070685867589937473, -0.2248071805034107, -0.22716258515376397, -0.11639806085395357, 0.030283989858214837, 0.13156149945229681, 0.076289277857620588, 0.16463399660456926, -0.2030751889216553, 0.0074676021898769469, -0.11511227064617084, -0.057709992041983842, 0.086369520782945797, -0.064748718598357166, -0.1519967988283446],
                             [0.044943199869144648, -0.22210774605452968, -0.03942566197915829, -0.14781430605579088, 0.21009697140223524, 0.01112131597003839, -0.086376700399385817, 0.01492658001302738, -0.048125331475802238, 0.15415571436392675, -0.27258274562236484, -0.085770039136600681, 0.13890478818203422, 0.13279157545902659, 0.11870189492185754, 0.0031737661933344831, -0.018555059871237525, -0.22039344091558732, -0.059836980121665655, 0.0054688366394556936, 0.022571055091813293, 0.23486428521942906, -0.29568879776559914, 0.28352324511326438, 0.039133743179422122, -0.034732542320818294, 0.077645448099075698, -0.1021401900604918, -0.04877775319976594, -0.090391217436948765, -0.27211904732967945, -0.056517424684384032, -0.031084607222671395, 0.35549122661501403, -0.093091271711396709, -0.20946947656543974, 0.048044721886708747, 0.14589537627114557, 0.0081969434529414863, 0.056170591196609811, -0.033694469998768108, -0.1152911374265516, 0.090514025323226735, 0.14249131534346843, -0.055457946547368783, 0.0083026752158534382, -0.045529985734418389, 0.071546312544167129, 0.19549323150817766, -0.18260539237125728],
                             [0.12109934154881408, 0.25233212677917111, -0.0050143312347099385, -0.053769497958240341, 0.0030852097152352181, 0.097703096697360464, -0.04968122116376416, -0.24020080758779228, 0.20629421798125624, -0.14142287822514521, -0.089315028203800773, -0.10247181645179936, 0.023363037387083674, -0.068103370789976261, -0.18033598216977684, -0.050238031460480663, 0.20145280618570158, -0.13670343179127994, -0.0011271772715070426, 0.10257712864626652, 0.36418555868158964, -0.16055848882381216, -0.094651648042356512, 0.015258210232051298, -0.38250015544031096, -0.1444688799743207, 0.21058039929226632, 0.04964378799748629, 0.26420819648211041, -0.042666355972552611, -0.06507730272722255, -0.13460030294648526, 0.24376423404363548, -0.073325498752940851, -0.022655654986981758, -0.028883353995947009, -0.11525327051715525, 0.048693455016304579, -0.045077900684219713, 0.033027617249447354, 0.046835160409944399, -0.085367650646834339, -0.12216992429515038, 0.027246127273440425, -0.07342350524161681, 0.16157286659393649, -0.026495409463442334, -0.12385354571321316, 0.11184124910113426, -0.11083005056894314],
                             [0.012342198946486825, 0.19741365170689415, 0.075902353077044751, 0.12295624591593053, -0.018221365557763849, -0.00065586819141927398, -0.011340645901563858, 0.094334019554386014, 0.072687205439421615, -0.12630904514748759, -0.00074998407314137868, 0.089534319819897637, 0.10343235094089094, 0.26542898389618363, -0.065680000024816124, 0.0095035365208665287, 0.049594342621557458, 0.12965240261474903, -0.021678375405184542, 0.13463623094001134, -0.01286886597594018, -0.1189998409093232, -0.031084259017899084, 0.070145387398556122, 0.090767794204225302, 0.10262202784562084, -0.16134948046397929, -0.10633258504587802, -0.088853943018663756, -0.33251845033032235, -0.083009238426205431, -0.12987537429039755, -0.11637149739498759, -0.092204242776096998, -0.11425104078829543, 0.014357295070551329, -0.017651209323189813, 0.40679500342426128, -0.24187316781377724, 0.16589112104663797, -0.045494511324025259, -0.15801877884108331, -0.027647129251347997, 0.14590547773818338, 0.28734596453496425, 0.1742868910213162, 0.28390034580316437, 0.041322853221610181, -0.16164106407363868, 0.04271855565023],
                             [0.091331177041300185, -0.097318548696544452, -0.10728913195611341, -0.11267911672529081, 0.042565818207236601, 0.054017754338165025, 0.28729581338380095, -0.073269367637802091, 0.014747391580290963, 0.067294731197943158, -0.010593633093838786, 0.13788746378137484, 0.11392828538346964, -0.095596121029640949, -0.0028437002565875153, -0.031854138205549026, 0.16492791579414573, 0.11430045667728149, -0.14719542872231095, -0.18792550842458158, -0.0055215230044903633, 0.098640372972514156, 0.16710983818810846, 0.20298212074154148, -0.037979180770489958, -0.10389568394743205, -0.10960741804367581, -0.0077385674168186291, 0.12513422703799981, 0.083731483342872878, 0.13924059729684313, 0.10701478877277518, 0.18979022623834368, -0.25780320220874919, -0.1661484911041054, -0.38581583578438611, -0.041649405378743565, 0.23153761891298627, 0.0089116480928223309, 0.048594413345316299, -0.17629635900594942, 0.041956794198186112, -0.059783734746963524, -0.099241576249502333, -0.076568489436894691, -0.060362654579255888, 0.025462395113120678, 0.36403638537776389, -0.18600597109596292, -0.064095738037887345],
                             [-0.002740546352422127, 0.069019873522439587, -0.1679662906391185, -0.30704188823968304, 0.18341830265925693, 0.017498180792339019, 0.10449849084805175, -0.15354972054508439, -0.22312281804530951, 0.049629953014434167, 0.083478204512088747, 0.054106741849044168, -0.17584049252391423, 0.12552726209455681, 0.21528127236918251, -0.082468773924294442, 0.046970516645891469, 0.06711412308088037, 0.32138784778831775, -0.24856517503818568, 0.11403705895435427, -0.11318679755424858, -0.11276621433840171, -0.17790268158691624, 0.13378937970937962, 0.14372716011072706, 0.16904807495127872, -0.0371087247173792, 0.0073605616860494731, -0.045029492724975119, -0.053705239551442213, -0.050833819899756126, 0.18625711145641954, -0.015843801498073112, 0.16924370664106467, -0.090340171853258586, 0.027283773064518936, 0.055766665565443602, 0.11954035808199477, 0.3393400315008307, -0.059696307605127709, -0.017378310814943468, 0.099349865222636294, -0.054434663235831938, 0.056800969232993555, 0.12022507123901538, 0.074878438460931257, -0.064812253531954703, 0.0012726154812706552, 0.2739855114496898],
                             [0.085966634289651706, -0.048812333365046374, 0.26463164612689694, 0.11721953878749641, -0.023360714713347493, -0.079349787213074174, -0.24532499367975127, -0.052057204844090724, -0.22065890874988991, 0.084182267778190115, 0.13703782046886442, 0.19071739011382649, 0.089981792296017882, -0.023307025244937822, -0.21109234363041199, 0.1596256619370191, -0.047283750073103328, -0.22807627378287523, 0.28752970668732625, -0.23283036483377437, 0.080837456701813276, -0.011729706071953562, 0.17419630726465302, 0.1471304038698345, 0.061912479383944681, -0.22280302842671534, 0.023188490271747016, -0.075261669767916331, -0.10228961470387124, 0.026767342647543699, 0.1325133192586268, -0.11342145318298258, 0.021837494487899258, 0.0056299453234010879, -0.06900937028898918, -0.036608021916854659, -0.082045893778736459, -0.065894770838849814, 0.024198085601664678, 0.15240512541572651, -0.17344114603685881, -0.21429947366402188, -0.089638431003182265, 0.1242507751905642, -0.22518913321895415, -0.13775013492695809, 0.22166570431206076, -0.16821409494208606, -0.083698328096635827, -0.030483751047066833],
                             [0.33980984193433872, -0.0074309112255087871, -0.12173755218929225, -0.011970709664605547, -0.17615611987379703, -0.34566643264051178, -0.12933517998415631, -0.17920958342377225, -0.048221102925614476, -0.079767968735639155, -0.073673777567339685, -0.040322110298252584, 0.068052843933916543, -0.053337483110517815, -0.0065263934332023222, -0.26567153834666912, -0.20775372032186648, -0.0463490495269911, 0.036524379735119586, 0.086343346565832715, -0.02505082363946556, 0.040704885344554222, 0.017876950887931866, 0.039269070579427801, 0.15651452555488926, 0.081934060867607669, -0.016109493439113109, 0.039874597231370996, 0.1307385148987977, -0.180886508599304, 0.13665668852748744, -0.17410381574215641, -0.20947374583026646, -0.072034146800235052, -0.096772135178314136, -0.063009303305765346, 0.013762230513443689, -0.029496913437153577, -0.07206184192904648, 0.22458243597222943, 0.16898853454986543, 0.11292187540182001, -0.23595500584800497, 0.019486712011276774, -0.16830892441345999, -0.024409241951583286, -0.21649066451510737, 0.18380204283901103, 0.10636490754494726, 0.22104336842371319],
                             [-0.2301449200308586, -0.11421738208053946, -0.077451695610324139, -0.059673550737020783, -0.13653732222704126, -0.064940483317445286, -0.13347888980469758, -0.0029521032332893602, 0.074960103983674128, 0.13780097746716646, 0.10383992198954761, -0.24202066787561147, -0.041889706779586519, -0.072242253638091058, 0.15142052207675602, 0.10812396558049914, 0.039690770902010099, -0.0047908569390063835, -0.073386248003237078, 0.22602723607266864, 0.29439672431595804, 0.050962160891944899, -0.03699423994126369, 0.14829561235316774, -0.018679056718881329, 0.002677947094426497, -0.023482050931718904, 0.18750461563043966, -0.20325803942990564, 0.051040152232281602, 0.30260535807512434, 0.013622483971684517, -0.057462685878347637, 0.13906205993799792, 0.15057676712601983, -0.097665729515859168, 0.036287789993326387, -0.069693577285084699, -0.058178545846589075, 0.1268400607932742, -0.17895412992756851, -0.16290543775617258, -0.29700964142393182, -0.2585116944368801, 0.10579126290691743, 0.16543339926706321, 0.21257252629171761, 0.12715496470437299, 0.035251105829693631, 0.10238838103444135],
                             [-0.043039616832320569, -0.018505695022365886, -0.17033585094554582, 0.018741067824801779, -0.15229778700380892, -0.10274557358181892, 0.083621686024116931, -0.098259468795980576, 0.33758632319351223, -0.12062776614920594, 0.024009984702705434, 0.074398236416906252, -0.32706410308388351, 0.21187036177503801, -0.13657932018958846, -0.0081284482001889244, -0.041107583059927337, -0.019463199540018423, -0.019264342100053691, -0.086814135344988538, -0.25378442349857477, 0.14941632507123531, 0.074743140529541507, 0.065211969547516624, 0.11438191076128851, 0.082462924167099577, 0.19808475332945483, 0.16436069395331443, -0.19007350705952739, -0.038778035668389672, -0.017890205196275908, -0.14168811064798226, 0.30289051008410595, 0.22723212444095386, -0.048828642571123196, -0.15290773008422945, -0.20720216203992806, -0.011747989578104242, -0.0071980442702259751, -0.089968516178866337, 0.027600241069594852, 0.17053791360377168, -0.18369201060728543, 0.090242773427776618, -0.015622626521141646, -0.10171551209463987, 0.21875207828702167, -0.10082460159014749, 0.024247826764529527, -0.028932728617701426],
                             [0.14851216351745664, -0.044346523606783851, -0.19509754606833965, 0.18856778727885579, 0.0028923832614597268, -0.14656268829124899, -0.035489085227170203, -0.0043959283754025306, 0.03695784493765801, -0.20138956902472913, 0.11911324214513261, 0.16670649753710787, -0.28112040574881142, -0.27827659543126354, -0.12408455991622733, 0.13639109813228206, 0.075458233223887922, -0.17408198196525126, 0.11889928489837047, -0.0014869177769800722, 0.05868828103474695, 0.073693907754046967, -0.088782214408023738, 0.055718953510390752, -0.026516343607318624, 0.0029919057911749211, -0.15967004620654313, -0.080558155233307518, -0.081529392729299432, -0.030531610041823164, 0.036972440124526995, -0.021454169932588595, -0.14437950854465093, 0.041024697340100162, 0.19584987155570255, -0.04822763789061757, 0.19646837306690101, 0.32089603145897272, 0.30119921079642181, 0.0073772850557758387, 0.12213399872492124, 0.13475284606782262, 0.17129645394510251, -0.17897523414449987, -0.017037372344947108, 0.21326827321150896, 0.063258095640085749, 0.013044237431607464, 0.027985871744548071, -0.22886352740967145],
                             [0.16032199783711312, -0.13350389166649118, 0.075644119572864349, -0.02963473193295673, 0.19675639479779886, 0.19117742509850857, 0.35512365041465815, 0.11069618591852391, 0.29081584826706847, -0.0058457308870072241, 0.19423282386166557, 0.021344584398372682, 0.052058899178523209, -0.20336599116299151, -0.19717385369405391, 0.026719789592948066, -0.039052466353354007, -0.097775886700440115, -0.013459722358613233, -0.0044563913671993314, 0.086664329836114468, -0.094198161918123149, 0.19428773623519344, -0.25754577130632444, 0.11585926537543095, 0.023836689871024035, 0.072687737254061593, 0.11030584532387978, 0.017360812920912461, -0.21032134220858781, -0.044041456140383198, 0.036257079636318967, -0.21278715969415765, 0.21501053813696808, 0.029522885467382933, -0.0068512834201553035, 0.074411963050317775, 0.03378689702950171, 0.029595069830589092, 0.14756193744960433, -0.22755864203014395, -0.10039119828523646, -0.12038132694431924, 0.064168190565560376, 0.072912898537438764, -0.16553173814650149, -0.062484449502760421, 0.036461450441190264, 0.27622498724046546, 0.048348642096318319],
                             [-0.035091624776458781, -0.19405169090723579, -0.012198350076586435, -0.10297407627970791, 0.18531204841898791, 0.066202238422607237, 0.014998808816405987, 0.01086385839172793, 0.049966602607593856, -0.13747260877332007, -0.13465719286025585, 0.11403901599296735, -0.14011452720288761, -0.11005855647812013, 0.084196954546346597, -0.064394072157109336, 0.07701602187857047, 0.15019998908207102, 0.10641176520053415, 0.065329948369932792, 0.22464067279024236, -0.12485291778907744, 0.13828475226041323, 0.14387306703732342, 0.10492479533202748, -0.031322170384667905, 0.047411913744641689, 0.14853103170678764, -0.12969170888791887, -0.0092016736584820073, 0.18923501441143523, -0.20240406318332882, 0.034565510893901419, 0.17427156960370041, -0.22258975112086302, 0.3768895999476416, -0.0065276088290054631, -0.10987960041337634, -0.0035206588460449323, 0.034683394495065321, -0.012353094684820558, 0.10973555150093986, 0.12883272930576167, 0.28495608431924629, -0.077968905398869096, 0.18968138931508799, -0.11287101829238644, 0.22356976798214009, -0.25814114207564132, -0.13394944359924271],
                             [-0.15418322387891617, 0.097076794032077141, 0.028324768088662768, 0.019425154751711058, 0.058941922687735064, -0.11076333789459281, -0.049318159832679558, 0.066107295773168082, -0.012088849533168265, 0.098242850628831133, 0.10223004650827099, 0.13106355728976979, 0.035252413067621009, 0.040761009024724008, 0.082124366481207564, 0.075727189071071524, -0.033452693073355855, -0.26760103836623661, 0.087273361646101152, 0.36359394191024591, -0.077788790224415955, 0.039653190544059476, -0.084562203688948151, -0.16369601252598204, 0.080155134018889976, 0.28477269353777251, -0.072712224214786764, 0.019728566737077069, 0.24228668148633739, -0.11955728866994937, 0.1687898575558294, -0.049424621886624269, 0.20811373867655114, 0.038610886789791826, -0.16904792315332143, -0.027080000810701711, -0.20300583107662928, 0.12401119210459581, 0.29465667421197106, -0.13438326743946505, -0.31884398041530854, -0.060980622953471043, -0.034360998861427523, -0.012220986445519078, -0.057622847127287519, 0.024982337982048831, -0.2649272217912006, -0.017911510438029157, -0.14679876784692558, -0.027014759068758432],
                             [-0.06882306173095, -0.023376981792476176, 0.44409092064421629, -0.14512387211173322, 0.13896599512960292, -0.21603321510247636, 0.025016698569549852, 0.16139242085489783, 0.070876806209760418, -0.017344061195948349, -0.019012959417144915, -0.032355541926203893, -0.21511820561025091, 0.11354444325256129, -0.35020317501410264, -0.091870792291401798, -0.010874367816600294, 0.0069940935086823868, -0.124347925451604, -0.043348659909530386, 0.029575607501548414, -0.17646000909622692, -0.25967823982284061, 0.027574952393244537, 0.11806467586667026, 0.18279013916091499, -0.085639241683768255, 0.16326601202946209, 0.13010893637223298, 0.22622691517344518, -0.020015868774399325, -0.19257580090994869, 0.0082057628521291989, -0.030940280319975328, 0.098500158107984778, -0.076064521373796393, 0.011238197943316715, -0.036307035871852862, -0.073207349454900858, 0.090564332285336793, 0.059612173028872603, -0.074052601587533295, 0.14850987171891405, -0.22461912189758745, -0.12500327620531432, -0.087585973125933858, 0.036517997837835062, 0.19986600939536436, -0.028647748717450943, -0.060736311634573326],
                             [-0.14506614729305886, -0.054330534037355015, -0.093194901951982281, -0.049812649254981627, 0.28501494822751633, -0.19333402213867448, -0.19779456429288864, -0.15853168514888571, 0.044190253183066248, -0.092130011005992246, -0.14474319262583801, -0.079302884364837303, -0.011365464182092024, -0.081662419859649324, 0.12540081415570389, -0.019809203217628212, -0.028389184363355958, -0.063287034565333328, 0.11424187366511172, -0.19039618127881175, 0.004494366508821881, -0.076970938273985823, 0.2036302517597976, -0.20581371195972062, -0.075988340370163568, 0.023218936849238508, -0.3705702136809757, 0.10645201609097253, -0.059841483847458486, -0.23160050919189534, -0.25045815869655014, -0.1527876625151631, 0.010400072654595117, -0.09888068464731968, -0.046454829438178663, -0.097210998164735732, 0.017794594715773392, -0.17351816884212645, -0.18763755635815391, -0.10389512042842297, -0.15442874373699073, 0.041551992660560935, -0.10405425358729559, -0.22074152385460991, 0.11178558537092208, -0.086798110200664289, 0.00070910734314096004, -0.032476137729732332, -0.030710607669028101, -0.27231174171077072],
                             [0.16952249667579825, 0.023609577780277797, 0.23229969412527646, -0.14191665592136599, 0.050884774815200019, 0.034892767545705, 0.005084835276460256, -0.0010585340285930126, 0.14659331306129111, 0.28734638409802904, -0.028218046194949525, 0.17186489201716945, -0.10138945198303917, 0.016172502275082715, 0.18518917147584238, 0.11454227259121648, -0.15846508737894685, 0.25419356632164575, 0.040410334291423849, 0.081870356080721088, 0.064002485134039777, 0.34150119350498204, -0.11558808799067409, -0.23224566481652267, 0.026208534025133737, -0.33820940475246208, -0.16162188501864805, 0.15051529116662943, 0.18262705082580327, 0.011938478581429903, 0.12828721513086835, -0.14638946749158432, -0.059678539255298389, -0.011053343262427609, -0.12736088731260414, 0.0043420470425864699, -0.081376303833657543, 0.072931789429460103, 0.00848068435711412, 0.088026613286214583, 0.13640110106063952, 0.16337447408250574, -0.019715100208232559, -0.066635773241442472, 0.092583694182577531, 0.061947100924761689, 0.12313715169398208, -0.21537505794920617, 0.056331211410360425, -0.11030266094802792],
                             [-0.020225900935791706, -0.053942845570248685, 0.15942434314117698, 0.0049015094787585702, 0.11512557402270356, 0.14324804518737769, -0.2208808688227156, -0.054279017022566788, 0.30280290614570948, 0.056508480161334002, 0.22273157343122305, -0.25628313064976554, -0.076910508588413626, -0.057002539462313741, 0.1276584691087031, -0.089870564993941193, -0.11890200403304572, 0.031608385743683305, 0.23432447402556703, -0.021695150045005853, -0.086994589052736701, 0.027212285295512745, 0.073880778589790641, -0.013129171090712601, 0.051774502117417458, -0.085350350374957987, 0.20673978896376224, -0.31808296086501059, 0.026424004511608101, 0.19865025907839368, -0.16677709117735134, -0.25765602474121224, -0.084084960246926757, -0.10885215379082312, -0.011970168976271883, -0.014575127961176217, 0.072489362161959905, 0.22096035585475424, 0.059341496553461874, -0.27796802889870342, -0.027330082046893044, 0.013520592779903258, -0.13676844930369281, -0.025397700070758606, -0.015165709577400724, 0.050911144785518003, -0.0076426870029758431, 0.24824057973677016, -0.10168104547316439, 0.14162648963321889],
                             [-0.11587695139708022, 0.043334658072121571, -0.25165271825509317, 0.060585331634666437, 0.028372015973981805, -0.097046070849051688, -0.004607240065935601, -0.21126208054619319, 0.24434497214239698, 0.18850410763454142, -0.15942045760780926, -0.12518801181783432, 0.16968078144758619, -0.17653589672263209, -0.030655035422524034, -0.12246807913564142, 0.18960413867686404, 0.022980318178871507, -0.042271138394086881, 0.014733074500139455, 0.083305826595556423, -0.06416312074600021, -0.16097187877840324, -0.065346969076198774, 0.29608642408745817, 0.083825157363977165, 0.011105727514989639, -0.052618551986324001, 0.17165266162139189, 0.07017918550623041, 0.10142243058435838, -0.035396516249296413, -0.16417099633775831, -0.052829138813362438, -0.049777919174426796, 0.068127546862265964, 0.10273772435679977, -0.020763747579606244, 0.16659949527509635, -0.02403202513079309, 0.016358055344200484, -0.042726307328989827, 0.1402457727445498, 0.13253686862554323, -0.050057256298129606, -0.33164729991374553, 0.37813333280659261, -0.16494673702195284, -0.16681058982849858, -0.036613605025394624],
                             [-0.040843827648211137, 0.18681135938371982, 0.097516881095379843, -0.03092041268971938, 0.016818260127501872, -0.33477562622482382, 0.20957352036403651, -0.16935786018744592, -0.17427856589537974, 0.10664526780314129, 0.048628263753334705, 0.073427763792325421, 0.043628730145374849, 0.09730877342803014, 0.096113064229163228, -0.0057850310808831105, 0.0024275189770429817, -0.15383415715763935, -0.095338763935675516, 0.17025655436326989, 0.11819066929935082, -0.090252220392633975, 0.12991478543789117, -0.21069497646690719, 0.18253197788066217, -0.30282292903866309, 0.17068406210914017, 0.01333794857055606, -0.17497720995251775, -0.11360442772661117, 0.028744000650612452, 0.0098696406060221464, 0.14033960041260712, -0.0079949701025626985, 0.043346176547412837, 0.027238457619424512, 0.17110338131145172, 0.080330045128884225, -0.07832133835598433, -0.34612207195548822, 0.095244447170246022, -0.027827929486537634, 0.13703766874718265, 0.023145295855335115, -0.063364764058366607, 0.012474391448811704, 0.14339844661565276, 0.27202957866382077, 0.19705775378755905, -0.056397145088742259],
                             [-0.29198100852332926, 0.15823094496273912, 0.056476004219233877, 0.1002462270010047, 0.056066983779368633, -0.040879445007980686, -0.091363335136630086, -0.22900792792010372, 0.21857547402810629, 0.052375690130380195, -0.06969202051560415, 0.27110920345360962, 0.095814941412287719, 0.13359966755740132, -0.23987956943185634, 0.067476107439846306, 0.1770019921669142, 0.25337360090711902, 0.17310886821467764, 0.0058373765428851076, -0.050863145586252899, 0.078433001701882429, -0.049459923679605645, -0.029508895437851183, 0.033736623653860529, -0.0096224051770923257, -0.1398642737988296, -0.21936219760461909, -0.042029416186423023, 0.061483917662601605, -0.0075490689264185555, 0.15069588496416844, -0.011332156594197994, 0.075477198390605182, -0.10402510243346551, -0.074104362313073768, 0.19787754139696367, -0.26008158488378724, 0.13799029674505489, 0.11962868020086834, -0.017873575859649268, 0.031129917581109032, -0.10564969625357935, 0.053618560968553268, -0.024991939144884453, 0.19089613099687477, -0.13764449756587838, 0.19745996246508402, 0.28688244348650516, 0.056008746748957852],
                             [0.079359616502737124, 0.06179174134007278, 0.02250590361985479, 0.024366273769176435, 0.19781149639279094, -0.095781147766843072, 0.064724749019044833, 0.11916032371743622, 0.14154887904169591, -0.0017312052250731799, 0.051743216400311091, 0.22671203901934278, -0.018101979703621988, 0.35325912559240263, 0.21034053726790944, -0.20546414575995153, 0.2976138964312402, -0.061104368472971099, -0.088667586738657669, 0.037160737625387241, 0.13044601302162345, -0.039837921678508185, 0.061055602625370194, 0.15289158144005699, -0.04770362966377914, -0.024817767071719728, 0.091026847720293777, -0.074816170556250478, -0.16211462155764317, 0.074478981203897093, 0.063696255579103245, -0.01112894694015802, -0.21391562742823717, -0.01674589363044908, -0.014784560259258011, 0.031109428865105586, 0.21367902808936537, 0.053466218754085346, -0.043106440336176034, -0.041626499579769445, -0.078953057835314269, 0.12533454923843884, -0.18071853843254068, -0.24304265446389822, -0.19658238676891091, -0.13662172192672889, -0.18794992845380451, -0.34996712426492188, -0.08612167040007454, 0.028659403380719716],
                             [0.031778796347690645, 0.015417369182398388, -0.076265245032247547, 0.027988290214822444, -0.042650798774856884, 0.22984597507072696, -0.21877500201534283, -0.032352218573680834, 0.028658148732151958, -0.14648939142360512, 0.10030225480310719, -0.014547961144132726, 0.074262845132142347, 0.12021838526245889, 0.046247073187636364, 0.1689368140355548, -0.13214866983523019, -0.088514083450584341, 0.021402436965970894, -0.0014920472663558734, 0.055225536521324212, -0.40285422422859052, -0.34520825440553748, -0.12353700468995392, 0.082573282169937631, -0.19963095511384249, -0.089628258005392702, 0.21799937591059454, -0.1270953523553488, 0.06123939610060665, -0.034131665923141957, 0.2225990171007442, -0.0035743371560231166, 0.057457580739060272, -0.27096060541308759, -0.10934064434288288, 0.035529515431054606, 0.10886404605219854, -0.0086758747738305188, 0.028066393041541932, -0.06482760177147899, 0.36471151756427689, 0.0010219149537715484, -0.042907421880227024, -0.14058239396929931, -0.15148873392424628, 0.033649485063711591, 0.11639916668836119, -0.015438338841554865, 0.08754200427030924],
                             [-0.0072319108079470012, -0.06825586954043858, 0.10497513670133467, 0.22071625390889221, 0.27485197601766359, 0.040605631583180903, -0.15087050266513843, 0.088415695538114458, 0.16687787799877254, -0.029475616337881913, 0.068153215319096558, 0.14151090939852531, 0.083889909113328109, -0.1005018668642141, 0.036173337125616947, -0.20678170806083274, -0.14810730767306141, -0.16530509570278543, -0.18730915034075618, -0.21511598138008792, 0.0054519669570870693, 0.11596512290930037, -0.20489243726939346, 0.11267890765112956, 0.15964223254363621, -0.067781942647263116, 0.14865225327953188, 0.0093976100251341402, 0.15575383305989363, -0.33383088313902209, 0.13109502189765157, 0.23475491286625152, 0.22568998888428021, -0.10920759548846599, 0.15021333269445006, 0.061412295934630635, 0.074288336690613035, -0.20255768771748006, -0.07511324542045468, -0.055191551291246782, 0.0060859080699645829, 0.10517227205671763, -0.018046977336060303, -0.054665074328794597, 0.069456887179620647, 0.23385379830254116, 0.11080410246521726, 0.0090091517992047978, -0.10101932274536599, 0.11500888559632297],
                             [0.13055762220174599, -0.32762245660958739, 0.1396823597221373, 0.33212704969897111, 0.047124440816480803, -0.14025666001122702, -0.039632378431359638, -0.10574770825967837, -0.028399240057945033, 0.10380489081038144, 0.10668266928869759, -0.13378443842213056, -0.048619417068734835, 0.13062175689855796, 0.027454915417318922, -0.054108808210169175, 0.21384874252274128, 0.010778890340621851, -0.097472174827995126, 0.10871449113097471, 0.030229519592719301, 0.0061875616575652994, 0.020537593672846608, -0.27101794594434853, -0.065532390804079257, 0.030573679680540849, 0.19789396508174559, 0.18758111361416541, -0.1629903579077725, 0.035836779392945703, -0.18958419108979771, 0.10728011945005923, -0.065795578891703912, -0.19293577000559869, -0.14360510656466585, -0.25227587290226244, -0.053137061880989427, -0.12936365011831347, 0.22022248427407637, 0.17677644352497918, 0.11329800862465909, -0.051279628340388475, 0.033930288276618495, 0.15453255336991645, 0.11895259657135328, 0.15670633164371345, -0.04482913276195357, 0.0021910440961923003, -0.19471034310384266, -0.077826160035591868],
                             [-0.046840468534883752, 0.087379428701652717, 0.096017243924276907, 0.21825858493379427, -0.01258939796797727, 0.083632718811461171, -0.036685026815060764, -0.12078026979738719, -0.054930937254808826, 0.11694292330965618, 0.0076502491277584865, 0.079807126095187877, -0.23898956180559008, -0.36595211586682447, 0.026288831932104625, -0.1019607312287603, 0.13099947894249298, 0.040770500035708215, -0.04961810357271549, 0.1143478140391344, 0.16609175891867994, 0.026583552872151292, 0.0081045322130778412, -0.036116327961898162, 0.23870801944601958, -0.0042686226762275849, -0.17110079747739859, -0.095039768254657833, -0.066330832014115756, 0.066386628915490839, -0.15287580820334137, 0.082569280871725631, 0.15461814664970072, 0.26514834171223106, 0.014773157243075225, -0.24225275459319798, -0.078022400204257505, 0.10835257176864092, -0.38858315464462551, -0.0058650878985329934, 0.11036335195927707, -0.048570383139072366, 0.03720975729344661, 0.04432294209004025, -0.053739560924273219, -0.070078183844567973, -0.23371820540227964, -0.14021712589909704, -0.14323544589057358, 0.21022241760095087],
                             [0.0046712359061642809, -0.0022093804817177151, -0.2623633831660836, 0.05328086218150372, 0.084807308484826746, 0.016536010319551171, -0.209436722308802, -0.018692009354376198, -0.12701580346677974, 0.19841715212997915, 0.097328219307084685, 0.0033315189244526775, -0.19310390784215989, 0.010029602924759818, -0.18337154213294327, -0.17982302622249527, -0.11352836808743784, 0.34313524574467114, -0.097409669906476287, -0.073923552948546453, -0.10327795714770652, -0.1545471593229662, -0.11978330019741615, 0.01536223807662249, 0.18015478699837781, -0.13205066295304582, 0.13882687595347473, 0.11529392689136142, -0.042000375108528838, -0.010647624030052255, 0.07726790450188202, 0.096198750456070653, 0.01393975691952217, -0.13155193599711834, 0.0053263747432393659, 0.11654407582149326, -0.018881879219247364, 0.21817559626884384, -0.021366323200581478, -0.058556647750892671, -0.14633516131767832, -0.29483943903692095, -0.14965497170336517, -0.002407039197944182, -0.0057752703806076416, 0.015099396236102623, -0.23155086620904794, -0.085661987635602455, 0.16639707314311339, -0.33376719196212778],
                             [0.019868081331433349, 0.0074046165283812426, -0.016794212767784596, 0.011213867837109653, -0.10710642542802593, -0.041034186492782405, 0.13295904245003248, -0.19251335526776811, -0.002141200828021658, -0.11684894099572861, 0.014574627992258346, 0.041885380434267948, -0.18872365129636465, -0.017476483964618438, -0.008828870477590128, 0.25330214604269735, -0.23284410038861988, 0.12794253103052664, -0.027083504569880845, 0.0087557487153951657, 0.066739698354938273, 0.19671504613054067, -0.20945673691747504, -0.14111808490644415, -0.15617691763036706, 0.15355417627640711, 0.31037058080594698, -0.18398776670900477, 0.031787350107279962, -0.11461063301810213, 0.016438696592486396, 0.067542174375199299, -0.18370160394775442, -0.029917094381586407, -0.15271536950371412, -0.037602060301364537, 0.21143819163316271, -0.13728190034149632, -0.3172672590252289, -0.0071008474150667539, -0.28539427124363376, -0.083958194953943466, 0.11875440016194229, -0.070031111580061284, -0.20380917183437636, -0.014761753761098992, 0.008799787412690151, 0.014354780300578674, -0.22782134370045232, -0.12211041317517744],
                             [0.19942921778505904, 0.11325818282195117, 0.14946111040267987, 0.033168891007488988, -0.068682335335869357, -0.10524237606813415, -0.019328747146205125, 0.038951116412051207, 0.15603118457195272, -0.031297374527305591, 0.19792063442116445, -0.096986235174377391, 0.10023747004976036, -0.085755592660955227, 0.33962520696229537, 0.29669812500004006, 0.040458317553774652, 0.12184261265313719, -0.10166414363750027, -0.28980721865512898, 0.091768183269828191, -0.037658313078841876, -0.096868567382361243, 0.056571633445574351, 0.053065801966172131, 0.3341042322356404, -0.11213139511959599, 0.04124175125977747, -0.095710476581512244, 0.015569588232310756, 0.074086199849277459, -0.054935631323441987, 0.29254782238698418, -0.045559538040429504, -0.087983501143613141, 0.040568006569364434, 0.25772746060726359, 0.018340078610702665, 0.042854969421784891, -0.026491004852312584, 0.16941338421960894, -0.16497984889763653, -0.10603893903564766, 0.19831847181756571, -0.037587147078279877, -0.084063174298198234, -0.11522286015942897, -0.027877599829004656, 0.14108355267071848, -0.12831849254992753],
                             [-0.014378486580757377, 0.17904256463903401, 0.0094012780203217607, 0.078181815839580671, 0.074609456383042838, -0.10961145852445225, -0.19694855207177661, 0.039939674013695629, -0.10063250119677233, -0.07552898556434931, 0.13401541433360237, 0.15226804761101484, -0.055439762490087911, -0.025518893321175663, 0.13857035085303182, -0.15159962865649679, 0.13003320977009181, 0.023307309684663591, -0.085260249322915066, -0.089285539408649903, 0.15414119331279694, 0.30359504664586223, -0.02955433255912741, -0.13504731693512809, -0.17194522889728617, 0.14189558469616154, 0.022220403168855145, 0.10596581381892907, 0.071736880949825693, 0.16327906754766974, -0.19924466347227654, 0.1827848428650351, -0.11015779736657623, 0.070214207015459787, 0.12703726880633912, 0.26600986373975355, -0.23903452419693666, 0.13158461383147418, -0.041004259837733446, 0.091175316747128046, -0.15366874801357747, 0.11408210982639687, -0.13536231264612308, 0.18932608633946155, -0.081867127122198569, -0.20135201259531155, 0.1856462160604925, 0.30673717688366681, 0.092543403130420435, -0.055189212209595682],
                             [0.13412878818749371, -0.16062194083753917, 0.074594782679455227, -0.053919697139094905, -0.05459290414431401, 0.056230280592515988, 0.15796836924114066, -0.19206276187401275, -0.06190371088976937, -0.068523036400075385, 0.15094860830855467, -0.14100030611944708, -0.054429636906981861, 0.10491775689264569, 0.087823532388640865, 0.031152941279481289, 0.23485022278927403, -0.10744239738196425, -0.081295899013605427, -0.099640323097065997, -0.031435871562663864, -0.12404655074391009, -0.12613415755048818, -0.063978318537242465, 0.26036129516129364, 0.033478275330870763, -0.14045717908391259, -0.41050630429869533, 0.074211272219467828, 0.010174021151181043, 0.11793380321069018, 0.092951405850811561, -0.11699851581897509, 0.068080793756075106, -0.044437177093031736, 0.14149467648090658, -0.42208212655509042, -0.13022841775976587, -0.10728129226751636, -0.044787134144415396, 0.023907986585868905, 0.065422166806981402, -0.14809094000322062, -0.10650568623310877, -0.031229165862462924, 0.19305719545701799, 0.063171233423857137, 0.0047244797628380065, 0.10693860172353853, -0.24538107701644329],
                             [0.075902905143398952, -0.27638582067746026, 0.026841904352675649, 0.046777715902081338, -0.062793353564674609, 0.15666546117153582, -0.1039810622143518, -0.14996679372427915, -0.026295422726868987, 0.12702772398797665, 0.037171855431890062, -0.0095807522161013813, -0.0062765303304508193, 0.14362077949618035, -0.14480152024290519, -0.019640100222652408, -0.1330677981861984, 0.11788002387437736, -0.19077872473405535, 0.24490053628298969, 0.25820563889993947, 0.045845913286150834, 0.0818222166317501, 0.012477796921054373, -0.023531534504365105, 0.11858186479247321, -0.12265905368920373, -0.29159933909969127, -0.14346023954327874, -0.15103936081405622, -0.064725796897090848, -0.1324169626058499, 0.33695300387840388, -0.16673745625232317, 0.18280060196258396, 0.17244948832775581, 0.056965348306420055, 0.019915758391767048, 0.091406476783786092, 0.13725733163733075, -0.11130262363138221, 0.25542584803347729, 0.10217539030643154, -0.060399131670109768, -0.031219003680081674, -0.26500324364413802, 0.0077596838477851093, 0.0012386886214900042, 0.10359314326474384, -0.019539389523068589],
                             [-0.13602577437720031, 0.10087485339676595, 0.080511704452685504, 0.061062808915194458, 0.062619230664805139, 0.1852582969381964, 0.11090035410134919, -0.10842181516161198, -0.33259914766221799, -0.3122414489657383, 0.22617018216863335, 0.11665938543011729, 0.085570578820040141, -0.19373251053883825, 0.096035099998641252, -0.27448360396806215, -0.11415420135687447, 0.072470178180448958, -0.22936734997702227, 0.14395421718790161, -0.088182908899070489, 0.015755742976403034, -0.095900080767307577, 0.066796533107228717, 0.034171396565157233, 0.0037856054783867374, 0.025475630572579382, -0.015286560175228035, -0.00081345070500290085, 0.14147566265716432, -0.05697181562034382, -0.33250897576711563, -0.00043732158500206145, 0.071131922046106008, -0.18970925009867737, -0.15225579723542801, 0.16173044796930325, -0.1530242930317775, 0.16731462193022861, 0.045356871762060068, -0.050241332266391783, 0.027605759853754703, -0.14216493205903102, -0.023011935510445121, 0.1106891808406336, 0.007678618687197874, 0.1730752782052131, -0.10495934530770264, 0.099190194904086357, -0.12777150187677055],
                             [0.033726319850844351, 0.0030044990786301713, -0.20029752541107518, 0.23286850197876133, 0.11388177146759218, 0.12176268464609007, 0.15175997761428936, -0.044615914038145202, -0.18261694599648237, 0.32544499421550033, -0.0010776132292972607, 0.066303104010645778, -0.009912608628931726, 0.1362805619561881, -0.17899784028827806, 0.14410296514678261, -0.14778076194607534, -0.013984057700215598, -0.1104509614446726, -0.18915496647766389, 0.24287956613999029, -0.013256564514283945, 0.051873428971729252, 0.023825581834241223, -0.039791921395656016, 0.21679785666413473, -0.087336744571835767, 0.11503291175894821, 0.11240873410492001, 0.018140196147635842, -0.19659376811518145, -0.14935863209568334, -0.0747074375036164, 0.11725596519241019, -0.20679951104437136, 0.14377017272426731, 0.0055060617696315586, -0.0071104690598552938, 0.078732289477740108, -0.24022405538360633, 0.18377448215259037, -0.016490967080548688, -0.20730650102131609, -0.16756707896346981, -0.12481253731161025, 0.19122749528476365, 0.11317607822572594, 0.052914624394563917, -0.062378524887328313, 0.19299800906197911],
                             [0.019948133811811378, -0.10176414043213983, -0.025017646724511251, -0.23033251717418068, -0.15715649490898048, -0.038602781810184207, -0.040570751542824295, 0.20230058286267616, 0.039059563301782847, 0.10627484121527898, 0.2083582608685387, 0.077025231645338255, -0.0015488577454123766, 0.020275441366982026, 0.033264689377876751, -0.24243821260887519, -0.063587374116666734, 0.21377217290100731, 0.019032661368534001, 0.074088331502653704, 0.03499146754417131, -0.20946865230398268, 0.011442201704188861, -0.072847015702675155, -0.19453076157673588, 0.011217880009121533, -0.19894033176927639, -0.093305655657724765, 0.10059175217882385, -0.21332681645524076, -0.095977714847836168, 0.10515401899603581, -0.025540271291740156, 0.18061150952548791, 0.17896318296691308, -0.24494419429395481, 0.072135804421852703, -0.11422077493514249, 0.085479441932479486, -0.16705093954326902, 0.051924715106049728, -0.025216687416289834, -0.076361971501953591, 0.25444653651069982, -0.36999383008815878, 0.14085022080516094, 0.19093496754888239, -0.038003551109703326, -0.1367860585463864, -0.10026415830375345],
                             [0.20891054260908665, 0.11006319032520039, 0.22684367897549021, -0.024587177772809117, 0.0018763297825565709, 0.081956487198220254, 0.15366457706740175, -0.10785467478345544, -0.010164837661578413, 0.0081057885904899981, -0.19297450656036871, -0.03284714952238646, -0.24730616981814477, -0.15200755823867548, 0.11255554808772372, -0.041096182668063919, 0.040767547082033902, 0.079072268127582848, 0.21120886179298701, 0.22013513469748194, -0.11456717598042121, -0.016710837714552881, -0.10953784826465082, 0.299746150624844, 0.050555856029710064, 0.011407005033745256, -0.072354449010163552, 0.12029813457833395, -0.14090887605050859, -0.21233714977213958, -0.26458194422795595, 0.26148770184305631, 0.014382715798303058, -0.16743645054626025, -0.081201692631789071, 0.15727693392128533, -0.039064042004141084, -0.11373337021832398, 0.2446166381177165, -0.082726948271758888, -0.068440582790858934, -0.15596990111208128, -0.14293143159598667, -0.15137783818304149, -0.11841779971195195, -0.10650683889746308, 0.15768907073212579, 0.03944146905934668, 0.017317657386796973, 0.077438075675041143],
                             [0.065038151206754533, -0.14618443901006756, 0.1143720407130602, -0.094336964514365282, 0.19833490490878669, -0.023012843716618409, 0.019090032438186695, -0.12374224637523036, -0.11512599426655863, -0.0094948875989796788, 0.081176728033247783, -0.066079859413036832, 0.13289426307068483, -0.033932890063294467, -0.19619376286373819, -0.1510376219594145, -0.021953310415743645, 0.076589113290037134, 0.3317171687114594, 0.085532741736398757, 0.11397569517119964, 0.096048947088747713, -0.042377885123000975, 0.099211139810049101, -0.092978793337987128, 0.3514063973008052, 0.0051049296177979762, 0.12219335382293044, -0.10676403090864914, 0.088845009806563416, 0.23370093722688098, 0.19856078423582585, -0.040097643897743653, -0.093689502653735018, -0.10562713461735077, -0.12764524696856841, -0.0096442508580002525, 0.13211693408156241, -0.20244437143056879, -0.33319618270167267, 0.011532020767391059, 0.21066131549206601, 0.053086389754323636, 0.1220032078050608, 0.1221159361693275, 0.046299385399202031, 0.1063605488085214, -0.18258273315696999, 0.20758700331234362, 0.0091225322691629376],
                             [-0.13210274642835898, 0.25574328991811479, 0.012481105042755472, -0.10012935982296613, -0.12325620708709607, -0.20641049371728482, 0.13465262164906661, 0.22398475326511544, 0.051284575573735079, 0.21983237975909742, -0.013920533128013441, -0.062562454490825523, -0.097286690855242969, -0.1704767333591358, -0.044786017396810325, 0.018799361373820447, -0.20113297131687663, -0.096691854221302331, -0.079711806287653633, -0.10940125511644638, 0.26273176298476641, -0.08814002792498668, -0.0074051998481377574, 0.1848232347263751, 0.11907723523344009, 0.0016633745680483137, 0.063686997628163544, -0.13289539095370095, -0.14511580667099921, 0.046954599912389608, -0.20420656437000123, 0.015282681252836624, -0.1280916507252903, -0.24711684133003076, -0.091257306576357347, -0.095398015775175468, -0.13456367152064977, -0.092139503464888139, 0.085459622914428768, 0.060100906678408228, -0.196995503262414, 0.34378970296203337, -0.035891317998543282, 0.20751435703690832, 0.13557555921710324, 0.15070058367739345, -0.094902751508775224, -0.10829400232815048, 0.040102504387896122, -0.086498657413382085],
                             [0.19118453290260071, -0.26403049179066684, 0.018287747933896627, -0.0360535885748181, -0.26587725218505887, -0.056400770024998645, -0.15327524458978903, 0.161538969282989, -0.049048413710213665, 0.090828910300046445, -0.25336761731531005, 0.394370414793561, 0.10814880344842219, -0.2035055989418296, 0.047108845104810754, 0.10875462098866392, 0.24439642836636363, 0.065528850872105665, 0.028328093771953597, 0.038141409184708291, -0.079603880884679623, -0.20889581246523362, -0.077166255415716645, -0.10356195317517029, 0.082116046389206498, 0.11913760803849591, 0.24024311440801105, 0.0028258820677250318, 0.094195144365607456, 0.10769624465171215, -0.16671768692147754, -0.14677099944400721, 0.068630360768293416, -0.021488315197735405, 0.047297123689823806, 0.012331624798308764, 0.080081396629478788, -0.0233129594541625, -0.12352276547549949, -0.1572881134009213, -0.18979138878906829, 0.099461056442065918, -0.13953515647869266, -0.10243166921395527, 0.16406427609118707, 0.090347585610013353, 0.1026862717212683, 0.015235362292940884, 0.11021219045086557, 0.036168592886046159],
                             [-0.2012468820522916, 0.010034755852396753, 0.27494981364166832, -0.078095276093802221, -0.22142665816378115, 0.10792871127018264, -0.11802254919755988, -0.34080139043207081, 0.0076510482135281064, -0.023141842553473423, 0.021456727051420616, -0.038263239040308455, 0.15799794995347557, 0.0029004941568981303, 0.061649941660155048, 0.056193196486906113, 0.063887425576490228, 0.10437314127485096, -0.16276817965185608, -0.14979721689323239, -0.043936218926007319, 0.020585180729685723, 0.2465716422088414, 0.12540965372790855, 0.17940051148305305, 0.11788150597646704, 0.1113209869486831, 0.29591927407236385, 0.10946354115944716, -0.1722559561946482, -0.1241965302518839, 0.012841013212874479, -0.18706724774442418, 0.055576904375872857, 0.13837254584949901, 0.0067521053375767665, -0.019757303699608066, 0.22054784661085511, 0.096644924003649199, -0.0046055646105220699, -0.10797675222394384, 0.15021654257227146, 0.18276039950079973, -0.096245663590001557, -0.2145485957938229, 0.20071131411632284, -0.079702745733759933, -0.13812216482945835, 0.026872829472032685, -0.03744860206193943],
                             [0.088300064661505639, 0.20570168921801887, 0.01245749893337272, -0.12614126446527671, 0.076276153132983276, 0.1132834065215876, -0.10353316138334641, 0.24698490735654868, -0.25998609602985512, 0.023212395881260017, -0.035618662147694775, -0.36917205721984131, -0.022226926092793076, -0.058216402744793012, -0.27752146002600275, 0.10929689777433481, 0.39442358088850016, 0.053730030767844029, -0.033321843714887001, -0.0085985381264252377, -0.11388867952133429, 0.25853235176272504, -0.027638452928358689, -0.17295700169950798, 0.13800968993826762, -0.037026856435631909, 0.04544484568690875, 0.0095384384389655651, -0.072989212596776487, -0.21589703060025395, 0.058818683878005165, -0.10027659981806694, 0.067667575528567586, 0.013947815408174037, -0.023697484813552095, -0.0096094416998981618, 0.20931016040321454, -0.033548142014129936, 0.0054880286284201586, -0.023281841587519697, -0.056282622209496251, 0.25176152123630408, -0.18305230965521446, 0.029336918341914174, -0.13956737731851906, 0.041454369793616642, 0.0053435370946278999, 0.011608076247982886, -0.11636717182198508, -0.00095305540990445864]],
                            [[0.18060257568810309, 0.036384695463598973, 0.18755631999757688, -0.16055478042838722, 0.055795628535824586, -0.00082354685661369998, 0.30381631428038564, 0.074707823120729502, -0.024231818199513977, -0.23812886389638746, 0.00047830460967060266, 0.0094988478357969901, 0.070394959473054547, -0.16510313638951216, 0.087651611781962763, 0.085870669437838526, -0.029367446166728251, -0.27801053714918417, -0.27053074118389081, -0.21576019070828345, -0.016204764481441199, 0.033201412899406826, 0.069386998044853695, 0.056439788326538974, 0.11310650237631324, -0.16870639129360393, -0.0060411634656345305, 0.23623917140180872, 0.26857640658462889, -0.074789421392568306, -0.059294635880478772, -0.18216745428650591, -0.02162295226634272, -0.023945238849677364, 0.11439751314329077, -0.13531135665887017, -0.10496309724289141, -0.12278942580062652, 0.11771312815583496, -0.094228767542989894, 0.18228350729274118, 0.13359742807357716, -0.004053861830688411, 0.043612741852941381, 0.13887371955717265, -0.10190676258348241, -0.17949357135992131, 0.054871764875490718, -0.28444141206721957, -0.024455586314872824],
                             [-0.0010218792518886925, 0.044745615894354801, 0.16570675884982902, -0.0075539386535467398, 0.15518797554699978, 0.11839075695683914, -0.059901525590882548, 0.053401573830359858, -0.077846649899733708, 0.27478004149574159, 0.11366266645956091, 0.012144741753561906, 0.073587105866313701, -0.077725520198389547, 0.23458181876291292, -0.032562550603201151, -0.36241419117444196, -0.11726591531848628, 0.033154629286463171, -0.022803658725366022, 0.01924674303999235, 0.18250675528802568, 0.31253346459185893, -0.010057917957668852, 0.060124498437316203, -0.043656055256119701, 0.049059800249773758, -0.22658033391159371, -0.17128490110377922, 0.082751605449784035, 0.09945841905604165, -0.21420432746973764, -0.13874826662407544, -0.034058337109273973, -0.027335074560669775, 0.020415863903827981, 0.16684914739334405, -0.1346645055521252, -0.12922771016023879, -0.08970297191400238, 0.18435779354443052, -0.062984144433594874, 0.26812530359517522, -0.012201006782095819, -0.075559166615786641, -0.08702200227351739, -0.24047511638674773, -0.098595011549054937, 0.1926832993312923, 0.11881682321848321],
                             [0.094992005252818423, 0.31293069289419589, -0.10063484975743268, -0.092011261671863548, 0.030200549272707818, -0.058416959100511839, 0.15581070125211902, 0.0062089701650158277, 0.1943075421472483, 0.12253477770124499, -0.066777233086011634, 0.060866737231441238, 0.1954073488608023, -0.18809159045139298, 0.038483359495997599, -0.03410244120679478, -0.098477489042843522, 0.15774353281332273, -0.2032216191712912, -0.029038513318290233, 0.23859417941584779, -0.21301332099092107, -0.14208763268698704, 0.054844496974150954, -0.064519285068427357, -0.1297557729748556, 0.019132378445656986, -0.094768635913378252, -0.12482080425047498, -0.070077503720852419, -0.0037214767268567966, -0.11948297007381035, 0.061456239613580731, 0.16045000551718402, -0.097260580421693277, 0.12566763539334858, -0.22893699092173325, 0.16277404628055656, -0.14401822105528039, 0.16142581155488819, -0.18240935231134053, -0.139378297927439, -0.10630012670402619, -0.0094315665639146343, 0.028560470260284916, 0.13276109049024951, -0.27424190387914138, 0.028127141866859422, -0.019744902609655387, 0.31926212276449351],
                             [-0.13894869977802368, 0.069422656129702706, 0.28382909518892002, -0.15599093724825686, 0.082364484210794398, 0.016008082820078959, -0.083953853379870838, -0.013492767553394349, -0.081962144469641354, 0.04599962618788609, -0.20607056021659154, 0.087605344002351968, 0.10028052974500068, -0.10762120906560774, -0.033214041555766911, -0.22050484988910402, -0.095514583165924372, 0.084140301580248308, 0.17147259994366276, -0.12306789770848728, -0.0058925868082224057, -0.16718606565576144, 0.14741066689514556, -0.07056655763123669, 0.20113740578036318, 0.042840335610033066, -0.17613423334765238, 0.111864616382552, 0.063549385801289396, 0.06907132946502105, 0.17145042065155594, -0.0062909814842433852, 0.31077591503591728, 0.086440695132230974, 0.30018209639932614, -0.075071358378191788, 0.095219851297879202, 0.079500648751313963, 0.1019989088716145, 0.032019681799329049, -0.17154887114527589, 0.066658234468104607, -0.25662971430189335, 0.036309238463721819, 0.029222419558852228, -0.23559474816894715, 0.023167629621946583, 0.18392572007633609, 0.25512957545119719, 0.058090344066126162],
                             [-0.15390120372547511, -0.055604517878021835, -0.11798874541313002, -0.16577784020819664, -0.234448690168754, -0.19220561082736431, 0.086750135629157607, -0.3150520278230331, 0.17778773342374343, 0.015756701439241464, -0.050850083865990763, 0.095310590233660827, -0.046180105149726973, 0.071414789151295163, 0.13841383193187459, 0.01875640800730587, 0.072832758820290555, 0.082076152672522926, -0.044537746139113384, -0.1222182139861524, -0.16850420775819802, 0.10077027497712712, 0.23307512213832851, -0.12886164344046797, -0.16613053801772226, 0.031180655766468262, -0.18987556261198393, -0.081702967235836935, -0.36617644250167164, -0.16659741884685275, 0.15441820309588278, -0.23537627493393387, 0.15139161477760876, 0.021442712432749471, 0.028227266913523095, -0.040859296179017304, -0.2480688393376938, -0.068554894100780736, 0.00033816238966145927, -0.16834669799349938, 0.0075500440162019379, -0.039771822494449473, 0.057595829516341519, -0.016908579669750803, 0.18188689052097948, -0.14376521016639743, 0.073296582051694523, -0.010548803971934546, -0.10605771155236508, -0.12602149961676234],
                             [0.20255212468626921, 0.10416299109840226, 0.075346109560644886, 0.11844694937572797, -0.17100891962150302, 0.23560358581885665, -0.31225502936753285, -0.031018338300525888, -0.17498586920550532, 0.053782432382820558, -0.059591398989239083, 0.16122912971216019, -0.093908607141044431, -0.2544865263834411, -0.14700308515891927, -0.076558350398347408, -0.047660227758455978, 0.24344150653014138, -0.13306877548386009, -0.027712048596547356, -0.098905139899947647, 0.11473900359525702, -0.12556285230090622, -0.1337845542944204, -0.072655225562381548, 0.081086898947745539, 0.076252167073867796, 0.10590613581346868, -0.065385955098907225, -0.14608205147982356, -0.16739621042825129, -0.011664237391795285, -0.16239351745856492, -0.15157491139154416, -0.037796924326895874, -0.051254906232473085, -0.16273300626700912, 0.11024510267565896, 0.11712826456805295, -0.018736124787801886, 0.010722430820575045, 0.030822394143593966, 0.1750336687586789, -0.028626202075554049, 0.1188028276896374, -0.38447731086536241, 0.065208812818133233, 0.07004477963910799, -0.050243031715448749, 0.22261402703807812],
                             [-0.17292570979216595, 0.19941556689055298, -0.040480187737814421, 0.12756660512672291, 0.1008833196396411, 0.31080053832824939, 0.21559174267938327, -0.095857731835457136, 0.019834978124268161, -0.0093197946950425194, -0.20849295115208541, -0.014654901514925822, 0.22220810008742042, -0.12538030621066942, 0.11387970607629883, 0.012790089285195963, 0.089925339072767382, 0.11802700240818752, 0.24231011547432907, 0.154719933077619, -0.21950930160461363, 0.030678332966545558, 0.062901571178617832, 0.18208423985727684, -0.13486733280080043, -0.013887257895078614, 0.16329611822821427, -0.15635422950716443, 0.11907382626766404, -0.19934675366149027, -0.11681045103550496, 0.18760505135189645, -0.098593381191297, 0.010819612000039497, 0.05349818715577901, 0.052932925187109035, -0.1809641269870709, -0.12884295139958113, 0.024664324266768692, -0.23045431164743352, -0.009307164433124052, -0.006177612164820971, -0.07835921329530629, 0.27318514803580635, -0.040857131336642122, -0.071931613050102441, -0.12851351451210449, 0.075636829412149109, 0.061350835868965489, -0.17921153957656522],
                             [0.07746666944885558, -0.04900279369018698, 0.19859542264253385, 0.31122259157009385, -0.24933880662493063, 0.074663595191881066, 0.16433122969722613, 0.070873362940712017, -0.0045050838275619868, 0.03774772138083321, 0.03120457359229881, -0.013920644297287357, 0.038226343386243228, -0.11757803705929802, -0.01450784035934569, 0.12372563976611145, 0.008310925160208902, -0.02110095858414885, -0.16310093286586638, 0.088658623708010142, -0.28050102242295083, 0.090334209709591412, -0.10899795731094304, 0.14282420688097616, -0.16596220405707268, -0.075067222975266759, 0.014210859738958569, 0.019657714020017345, -0.24376654545811985, 0.32716443932519895, 0.36131380683869524, 0.010906601916155797, -0.088335306920117762, 0.23491649069436363, 0.23437350419939468, 0.14449058643977059, 0.036382871242480186, -0.08233251971538677, 0.11407697963548431, 0.093616754472322858, -0.068982695716929804, 0.090569225348424487, -0.16146002086215513, -0.026729780995187045, -0.11915613433035153, -0.02254438041085996, 0.038921041895223364, -0.015885441275355665, -0.082591024651720399, 0.073497970794558776],
                             [-0.091317755389167671, -0.17453824979970256, -0.078809844348650751, 0.010069788043267795, 0.13502878764000636, 0.049473425353703741, -0.21159313095512319, 0.099551622964583031, 0.092239363759332907, 0.13962844162164029, -0.10013118965859637, -0.076398783839635609, 0.079405614807682462, -0.045179403473452555, 0.092825827129264155, 0.088354023548878821, 0.078671845563053844, 0.0070606073383042952, -0.10742232539550232, -0.21996817509574751, 0.063492002101078901, -0.098871752121535761, -0.19140949255937761, -0.081401695911002131, -0.20968126820910865, -0.22475108108285297, -0.031372924412630669, -0.3281292944618569, 0.16737686477518199, 0.21353637349749557, 0.0083333644934992009, -0.20019490394432293, 0.00024375273429104476, -0.055739405390644189, -0.058921665315445758, 0.14367419662103872, -0.098497306517219552, 0.038119326827534876, 0.01547616663799605, 0.039885162397397728, 0.23044756759423354, 0.126099595121139, -0.056392859595067714, -0.057323638500278842, -0.071030507454493907, -0.16530656303151572, 0.1155072569647478, 0.40758903445047134, 0.017378949755456046, -0.2072051429736067],
                             [0.044798892148119364, 0.016690633930879478, 0.073589531613347053, -0.093549189100545174, -0.052689848072773618, -0.30447544686142675, 0.041084412519400162, 0.32364965801681467, -0.080285807350811728, 0.06872669013758928, -0.029874075344572055, -0.18805664638600278, 0.070553456963490413, 0.038069880326590984, -0.076481559243523622, -0.019044795687124982, -0.05266434955468801, 0.2306545218206783, 0.22577717170694037, -0.035651654058734474, -0.11579064087429493, -0.065572022750762654, 0.060396980566261749, 0.11320656793615595, -0.261989856743923, -0.15202977885789037, 0.069801840787237265, 0.26106338197528367, -0.072722703268276956, 0.2402988614214577, -0.016172713634825971, -0.070314653215597947, 0.045964119427140973, -0.13222468622105796, -0.12484082658355913, -0.057555717510488401, -0.035601760856979206, 0.089327750422587726, -0.14391144643091217, -0.075525999138641386, 0.093328947841167964, 0.037745791127837443, 0.13792288820943441, 0.45301246640131165, 0.15635021877890978, 0.010762482589280475, 0.086763448547864053, 0.0039122124316945837, -0.011257507128626497, 0.073416921479918351],
                             [-0.24260517006872873, 0.02501741105090368, 0.23762631858114541, -0.018024833151317858, 0.010840670178086707, -0.089506202766119161, 0.11430469561706354, 0.081672627351029828, 0.12958578472910007, 0.25195642673344953, 0.0016566786775710687, -0.15497802662189145, -0.068751893198725697, -0.13083193731845214, 0.08372589050384624, 0.03193242048831265, 0.16104365610254512, 0.24540962390761037, 0.16768262119701963, -0.19490344898778827, 0.091081346200845403, 0.20975738067202176, -0.20864108504197157, -0.11411599248134013, -0.017440061666218986, -0.043922779565306248, -0.0015001901518349203, 0.041615937821843536, 0.094854607598382337, -0.12502803059769421, 0.007226024124152187, -0.14864390865699331, -0.11825959270119644, -0.052478522123423799, -0.12612259193691841, -0.088581226935390681, 0.23611558174737446, -0.17729041861879888, 0.33891052298767993, 0.043778234536933545, -0.31242765317845184, -0.090466403466231166, 0.08515028726488362, -0.07380082491377131, -0.068348258850586541, 0.054421977314156079, -0.069621906665519942, -0.054045881438401652, -0.17610780327197154, -0.021783684087027584],
                             [0.019471618083563041, 0.0062454297246981889, -0.070212154122330728, 0.30382184377796478, -0.1391817127706611, -0.18469972163883983, -0.024933981481516189, 0.068846298200654119, -0.1043630688813051, -0.16932169524883212, 0.0058704695284677666, 0.22859547745278186, -0.083558394985239967, -0.21166606038090344, 0.034439304167725573, -0.012576011334284393, -0.07647449126309798, 0.06780981771665065, -0.069476995067319816, 0.0034076603962742646, 0.092783620492842153, 0.047331640199152661, 0.16640849168998481, 0.11664747772727721, 0.14243949978247133, -0.13668302799145193, 0.080619222045867897, -0.12218015703270939, 0.05885307288162818, -0.32970001168919949, 0.025684155675588467, -0.29018380620119705, 0.063541360751157253, -0.025247275921533679, -0.1021151632323595, 0.045254747038463515, 0.17906713163241145, -0.14488698131308686, -0.17973407822649265, 0.15184913133928898, -0.17206636905734124, 0.16518580791710677, -0.076084455983961755, 0.2607930804264465, -0.14484334519712888, 0.057100420898057939, 0.26831804233448148, 0.10434430810392385, 0.036338215083737545, -0.094578871114220253],
                             [0.07859504082642102, 0.14574550758994761, -0.20039388327877825, 0.099916356278340224, -0.25655421152521979, -0.052478672645970559, -0.16053523393338548, 0.017572382823318067, 0.21878508765306118, -0.11296568883864652, -0.2608517371772891, 0.0015596627438175593, 0.17364529211702859, -0.11582980695066337, 0.18193086832266389, -0.056892647482872698, -0.1178569039664758, -0.26982368807192098, 0.025953038140087377, -0.084001165897727589, 0.19855029215905659, 0.20235986044621251, 0.015208961986772367, -0.15521302160907041, -0.079499052727846103, 0.034408394162728943, 0.095305984312353237, -0.0011867654141188989, 0.18459053014545077, 0.17603972946766164, 0.19326361573860282, 0.10416449303804497, 0.10415050547083235, -0.052213890487595893, -0.082670385973877492, -0.12214263563182173, 0.014085289456794903, 0.19437156514303544, 0.22295486323560623, -0.10583379073678231, -0.012493090735690649, -0.14290960468356717, 0.0051543812183867475, 0.17274980626261738, -0.16570605582210074, -0.05705167011455816, 0.08157837589108094, -0.26018795863014105, 0.0043524714738018919, -0.022036488376766864],
                             [0.096695175198443423, 0.14358376483493024, -0.00027148842682561263, -0.12298127154146236, -0.12532448210263336, 0.09201773883132551, -0.0080232477160060642, 0.27397079939896107, -0.069602248262377112, -0.10580488455996838, 0.093303209250918145, -0.050776005541714957, -0.1740326696917171, -0.13428783365160923, -0.11182693874773296, 0.071692216059759978, 0.071136424232864648, -0.227304145064576, 0.077563206728864034, 0.14407413020677656, 0.022824281075075586, -0.0048151907710227374, -0.017933405612732878, -0.18666150354692637, -0.33479773439932797, -0.21125115901564115, -0.066441364584878787, 0.060292640586604739, -0.074227776872276802, -0.33450159068818602, 0.15208701139403422, 0.02431535174467676, 0.10280501581235724, 0.10731928190689322, -0.015474165764198017, 0.055500921506326302, 0.16988731129139573, -0.0082938554953245446, 0.10775793578976535, -0.144992168160679, 0.078804861827593969, -0.23894035045721509, 0.0039319708013770297, -0.097393501673166377, 0.089789684044341234, 0.11388827842929344, -0.054374314110882907, 0.24298143738488151, 0.30180876940422746, -0.057724928220280199],
                             [0.095887722760663777, -0.1587793856610091, 0.28291404027883033, -0.058580987270026134, -0.34424793884238247, 0.10082244070366865, 0.19309775418605413, -0.074675472038987639, 0.10168472162170368, 0.097179581104162985, -0.080350685501927296, 0.060531146544901104, 0.053911911710342722, 0.081752637027667704, -0.17307592283016471, -0.19824317581521445, 0.11838130128573099, 0.016017240115061775, -0.062882523069523799, -0.056783155473980364, 0.20186704954484871, -0.028756368586627903, 0.18526463162407517, -0.081269565589128082, 0.10716302216026374, -0.34793472697725014, 0.26919778299215474, -0.16784009919327575, -0.1396379668826771, 0.043202456224314401, -0.030199183176922776, 0.27442216714007767, -0.049573593931218282, -0.23851198774047916, -0.031369819920179738, -0.14144543733347717, -0.049256121452745626, 0.051593813124242001, -0.014167618867332579, 0.072571883351197408, -0.026307663640893555, 0.092640034441256194, 0.066515041670475991, -0.050553797879382911, 0.016919317104342527, 0.12658686434446637, -0.042583512509367594, 0.090981831792807291, 0.10660590453215588, -0.14901835564490526],
                             [-0.14619778742334735, 0.062400261082014859, -0.15073154317707982, 0.13302336120282313, 0.051026914713903804, -0.084472552138142962, 0.31187379917885799, 0.17784893453662709, -0.037241763889496647, 0.14550545889021951, 0.20076518385638178, 0.099607087073724787, 0.044646108879203214, 0.24278712074459927, -0.08914542855368203, 0.041889406696588208, -0.044598930822505399, -0.045483701389587627, -0.07375571340256129, 0.0012075486887061909, -0.039748532271362803, -0.0019343008504884053, 0.24743432221514255, -0.13626217682196456, -0.28493961079315977, 0.05715122683661833, 0.016670378535524267, -0.10078576021941843, 0.17492909019321445, -0.1429329319786653, -0.086331988028613568, 0.075085797852045416, 0.05114161493057879, 0.061808259554391454, 0.17124733797538311, -0.15303469668979097, 0.0088238851583604203, 0.26793653352771457, 0.16068462908133224, 0.33477472997415914, -0.037252463507470836, 0.11880487484567362, 0.17043014328751085, -0.0062653925742661961, -0.13319841539165891, -0.25438611926107801, -0.012396829165381066, 0.010796686515427195, -0.0067517375870748738, 0.077889065214347977],
                             [-0.0054520176709977773, -0.0038797691231139994, -0.14416876001817064, -0.13388777850010924, -0.20244743116967209, 0.35601543480528847, -0.00035167403275277885, 0.21653499472723403, -0.069534512007289398, 0.014521313126887789, 0.06625232908074076, -0.15165620839459226, -0.10741465149114418, -0.024216213161442228, 0.33402545599609051, 0.0071683981188005843, 0.014308672818548482, 0.15388671864615697, 0.039535973168213293, 0.086369328381507821, 0.12672280438130151, -0.14484359286574569, -0.014836708027898098, -0.10550115224137567, 0.15952970362022567, -0.14874310887136238, -0.0096894278864180835, 0.012861253910945376, -0.04905373663209639, 0.060123209879688055, -0.12597339442318534, 0.069468269611535294, 0.27973558822477756, 0.14874496705213569, 0.23705486733559633, -0.031414923325455285, -0.073422117923756539, -0.24280597166500628, -0.082586292762756724, 0.19686436883886324, 0.035088885673022846, -0.15610388806665629, 0.1957906934986941, 0.076976722972660727, -0.067866747513161643, -0.0872546023551624, 0.17537996350650029, -0.097393258024319529, -0.20917627970210567, -0.032202939791317088],
                             [-0.022149028625690043, -0.0057565451277185927, 0.070003816433247351, 0.072048039330218014, -0.10419672547231075, 0.054346106137697164, 0.04965669737402325, 0.26568925000900273, -0.077748856821053744, -0.012398009653881775, 0.036452911364403588, 0.25030249157689805, 0.060970076592082187, -0.0077155563773473098, 0.23429961929713983, -0.13837313289929598, 0.0092205946497376356, -0.052093917609520174, 0.063804642514632554, 0.21106990225349606, 0.19374175556300285, -0.36611608557567654, 0.1039872252778697, -0.063379729293027806, -0.15779024714307871, 0.24619320470919956, -0.024703207178116998, 0.084332607046627692, -0.058667619064685102, 0.17081841832824893, -0.097627609105335147, -0.22594895488891739, -0.28007111198792484, 0.0014544812483695039, -0.16175003000545904, -0.097132930931362216, -0.098461877470989986, -0.044202323133562926, 0.10042452509122768, -0.055228931558067441, -0.13740746987407024, 0.05438395486441553, -0.15692767208736247, -0.16729328806633631, 0.16283977167849664, -0.028177590272255155, 0.001621789164783724, -0.091966848973922308, 0.010062059320767225, -0.28479323884855129],
                             [0.061343984089711687, -0.23433522282915936, -0.0073873365798797618, -0.33963301232881432, 0.17243010695709807, 0.025144998369964779, -0.058014261377057688, 0.3349917381841116, 0.17335079217661176, 0.034362550228646038, -0.17244595945447155, 0.26864489767079558, 0.0082640148663046444, 0.0546968832510831, 0.0054383636124655001, -0.017135447924029313, 0.20958690757770276, 0.06446195473830979, -0.29159407896503392, 0.14769287375485651, -0.067780177809763295, 0.16171475572488114, 0.11369572851479254, 0.086400156124040214, 0.0049626807411608737, 0.04926999679618816, -0.034985640743944751, -0.0065572045680792621, -0.15084519535193266, -0.059987470331715531, -0.095344471008671688, 0.10664400172284012, 0.065753971264000843, -0.03738239914983859, -0.16237416657701567, 0.19496487651230446, 0.078551822922054551, -0.12977773685573496, 0.21964901347569663, 0.056601983262152981, 0.040371106357097918, 0.0058409904971796793, -0.16595995556536161, 0.18883799222322814, -0.15260018730167382, -0.11695592288332901, -0.029092914095908574, -0.16214505755861724, 0.074910850391794293, 0.087811930550175235],
                             [-0.28991441456426559, 0.015793404740096648, 0.1627182376112894, -0.20668327794010607, -0.14301696530753372, -0.054546793285507697, -0.039719039729726797, -0.10846926062567701, -0.14739391990751999, 0.065455945761095743, 0.038796084639333879, 0.20929682406058439, -0.11536555403943537, -0.019435273099548567, 0.254382792825258, 0.1733066902951674, 0.070367057011124279, -0.19297234929069892, -0.0097635080613858154, -0.040590773003500162, 0.017084481883411769, 0.1651301069892237, -0.17333361215113227, -0.11248879302734441, -0.09573705954488923, 0.17683260832938938, 0.35708270119023827, 0.13882871028056656, -0.11036809311853257, 0.053967903599161718, -0.22087414057354632, -0.00057405813519770873, 0.0028366693206571809, 0.11157826359992463, 0.040618176589615133, -0.14940908791602309, -0.012314150724590208, 0.10894613806503067, -0.19527349535395203, 0.059485660870730504, 0.094928370116193109, 0.01575672112109093, -0.19398724563111552, 0.15029960402164425, -0.18742300453033078, 0.11450580666505605, -0.034197154300135667, 0.20576740281357819, 0.03742824741954591, 0.10927482417272437],
                             [0.049563275167705083, 0.14602025116455392, -0.12477781335405118, 0.1252140359552284, 0.12705895981890425, -0.19467652851351866, 0.18407629573424186, 0.12890223242218532, 0.14412989991202274, -0.056165202735714521, 0.02941483822142122, 0.16841560571836672, -0.049246065802818872, -0.33455538653275452, 0.17343916567963341, 0.10865854547975527, 0.19407292289821881, 0.080157446069518884, 0.075441721232039877, -0.11632699600466007, 0.023717527323336964, 0.15995799087494891, -0.13059483295558091, -0.15445514491871234, 0.054671869968796444, -0.010363311794803707, -0.13849788325132287, 0.057014058195279105, -0.13199623683895925, 0.14186291815401469, -0.11322380074376995, 0.26916352074965844, 0.034184038337604868, -0.15190089629699693, 0.15116460752869512, 0.044501845861820856, 0.093387787414132187, -0.0010853488325413493, -0.26056126392696177, 0.021148292420880344, 0.058654928352225813, 0.23482237244660167, 0.077000407969556942, -0.17171859820576915, 0.14489539750287614, -0.10896444704661494, -0.049421206122771427, -0.12637549839216997, 0.251633053485183, -0.13259141773346894],
                             [-0.071915504343219916, 0.0017259000534262316, 0.0012085559946555869, -0.10727241134713782, 0.097810264980936465, -0.0077139426838304433, -0.073504892726658611, -0.0060030606114599289, -0.034592804837709622, -0.045873519983358112, 0.032227380730091383, -0.044584741005185557, -0.50903793607528502, -0.021369343221278404, -0.039866046579409571, -0.12144316341248859, -0.093434100183241234, 0.23964567848081533, -0.12879857205834061, -0.079879506782047985, 0.19429482658706099, 0.079253805518375617, 0.16058305219600438, -0.11482077983613007, -0.19418959362910315, -0.095739872175579721, 0.11173040525821649, -0.087711783747185371, 0.23808937572047029, 0.046601409867507271, 0.20822430876462328, 0.16071794701868594, -0.22626105265692781, 0.22541889883002009, 0.10613193313738582, 0.051754628355753778, -0.074379062738597776, 0.0087402217183505417, -0.16075015402218665, -0.11409732775139873, -0.02568283033553366, 0.081023165157327895, -0.23690396162787974, 0.10509364788351747, 0.091334033240449641, -0.054763193502424007, -0.11257050330961797, -0.22119940989705544, -0.072502974340389145, -0.075957943946117171],
                             [0.011937831260713894, 0.025102082685955235, 0.16881492282361543, -0.054665011380832247, 0.054300057767002495, 0.049727691609610158, 0.079568812477927409, -0.15689633902765951, 0.12898942493232624, 0.24954133582580496, 0.13485866362756879, 0.065413152575834702, 0.021297963461379965, 0.0079126777012080898, -0.068866800086140531, -0.03376605627856849, -0.045256484090638448, -0.1818312490969301, -0.14343699498114434, 0.055140437957841924, 0.11463404948076553, -0.017982168183783512, -0.076071533018716345, 0.12230776391873621, -0.12094869298113183, -0.048953950266988053, 0.10322281086111598, 0.22496657110700707, 0.12453393759601135, 0.029183617204650073, -0.091293003258418298, 0.056227023118639363, 0.22948299037117895, 0.22883369797892295, -0.17311761718564767, 0.25194929164789043, 0.042295312981275084, -0.01711378822358537, -0.17113558492609413, -0.29671612716003826, -0.27367364632156638, 0.09580774146694572, 0.24617053122896707, -0.044800442237692778, -0.048207465037419739, -0.24371596433028694, 0.26947705821321066, -0.054828632656207327, 0.039545698988891285, -0.14504437276027218],
                             [-0.068374279078364644, 0.016880653241645567, -0.018372762974350441, -0.15140732781885316, 0.10049913785859188, -0.17702671673971612, -0.17181296563423989, 0.14567547275435949, 0.23566243480227911, 0.02611309025112616, 0.23550381911237112, 0.088716333122225793, 0.17636837212267503, -0.1044602474051331, -0.084013318869313416, -0.078232701981868408, -0.12197495666697264, -0.081106308454740761, 0.062874401360508023, 0.11657838417203431, 0.050023269364171834, 0.096651156151250292, -0.0040194810974633934, -0.015551605867335691, 0.15332245594980001, -0.024239127195770403, -0.114030025799696, 0.14710136603640572, -0.071056887519363565, -0.089478274392267645, 0.19272838512885598, 0.22263901512172041, -0.4018620396962318, 0.039871213344288919, 0.15521390060813336, -0.082696332007290235, -0.28999999131465715, -0.084899794633873121, -0.073886929645158778, 0.053519819927639309, -0.080536481721450615, -0.10493824420091741, 0.10241564903539511, 0.075190233976917764, -0.18837368761672665, -0.028736221314815492, 0.14206348787112985, 0.27985848895406523, -0.1278315705892451, -0.12963543593644478],
                             [-0.089154595956424734, 0.40859222337260725, -0.07969261374015657, -0.077807112408478818, 0.0096416491836058601, 0.21908259873732491, 0.21105920701398109, -0.0022008504290802386, 0.0998235021950485, -0.046541628433933099, -0.052910858636510801, 0.11362182321736816, -0.24208916444544151, 0.20902890377910907, 0.016626280945868804, -0.10048473017413571, -0.058976091368327738, 0.08554166982905434, -0.20215917608191866, -0.201092701803505, -0.15374852586036558, -0.087625700323550729, -0.053227548740712248, 0.18863415316202753, 0.0013434887403478185, 0.021241521350175013, -0.06661779950087289, 0.1421988368020351, -0.0011542235426578694, 0.12864306264950595, 0.17045526659351498, -0.017439730985561761, -0.12026837485551214, -0.2922976894831773, -0.15438316276973174, -0.13575200724963862, 0.15747764160208094, -0.046073455144332087, -0.11816010109027314, 0.049816811087470603, 0.076323003052812075, -0.2278684708304998, -0.036319078625156771, -0.059468713380289744, -0.19079706787358766, -0.066158464033085423, 0.18339066817136063, 0.10902323128931303, 0.086936033030694901, -0.068525483000473744],
                             [0.079236015507809648, -0.14751478914867883, -0.10796435555375296, 0.12333343545436577, 0.10241795366702093, 0.044606212937230501, 0.09889104656546284, 0.043201733030033246, 0.13061085778154777, 0.074952807666704799, 0.05119839276142308, -0.29976793061374202, 0.063950945879084356, 0.077393672780314254, 0.021312499828764264, -0.028691469695518237, 0.025567105531791066, 0.16371207201217516, -0.27529019093054236, 0.16976250469018131, 0.12150617746940162, -0.094343962341965543, -0.13692380743999508, -0.23360347062550024, 0.042935638462130735, 0.12517253407149062, 0.14234314949341725, 0.15726114195532467, -0.10582104080071066, -0.15986935877986796, 0.10483264017723945, -0.20242804884447321, 0.023909907426845775, -0.1871965879525842, 0.24891698832682238, -0.22658794752025238, 0.015707053382866182, 0.007212776585910967, -0.064909067917871682, -0.35821547841012064, -0.0038243678119496238, 0.15153529565446405, -0.093846888365342399, 0.080903940895774226, -0.24100437079229847, -0.0064906827330424152, -0.015828120894605179, 0.0017885955531453438, 0.18415331223823495, 0.042596075852832017],
                             [0.13102763002963475, 0.13766287400948554, 0.073433835117423296, 0.17899440307125364, 0.061363312404387964, 0.075900684574431498, 0.034965640595700308, -0.077396366318955911, 0.090965792431795645, 0.30224677375366599, -0.14757154618342935, 0.18276644967930789, -0.16338040551672048, 0.043219762354656806, -0.23464299910095146, 0.26301322097080621, 0.19363039735405846, 0.04347692159401239, 0.10541756871179471, 0.24206669220378083, 0.27861281064346821, 0.21984489482629793, 0.16940971073883007, 0.014612985429551134, 0.044873079418065981, -0.027464824466868841, -0.23538285855422006, 0.1079173520962893, 0.14392568921458035, 0.17329587049994288, -0.047853012637333742, -0.21308071553996646, 0.075648838155352394, 0.061358046011441639, 0.06302010960385715, -0.16997080379668691, -0.21192057291108893, -0.078829097512683757, -0.0028054815068820791, 0.0060008415605743923, 0.19547285597410152, -0.092214313605980355, -0.041305980729931052, 0.055336024971086688, -0.030999699004092302, 0.1284114058785347, 0.063689892769470929, 0.039554366750760774, 0.036690600926193181, 0.021672095316997503],
                             [0.058897501309009732, 0.13624933632137129, -0.099084643659589411, 0.055030328672315748, 0.031556340450394953, 0.010275349017135192, 0.066573386049798067, -0.19140998130212905, 0.22610890385214588, 0.18021916904263646, 0.11152615045757801, -0.14625923223946191, 0.018274717685869694, -0.12248752737135174, -0.17382209965463932, -0.011831315233946796, -0.074680619555247588, -0.076103192554043297, -0.040616756610197681, -0.068803216843431284, -0.10646748137585357, -0.194465164499597, 0.064044434668146827, -0.34899200002630193, 0.15586818477182027, 0.066091866350993053, 0.11085187848044011, 0.062283279582754203, -0.12645086174975986, 0.034927638391151455, -0.15216762170141018, 0.02756400501912078, -0.13539172610138345, 0.2432125344812798, -0.1639073220050733, 0.033501748026595377, 0.21899816981953693, -0.15430685783231088, 0.15988444894889794, 0.182533587474006, 0.24300542392927182, 0.0064527761125542362, -0.18743854101959201, 0.28975116921770427, 0.19294855820071627, -0.051309176419992622, 0.12394833865085055, -0.002425245164129728, 0.037243780916180941, -0.10071917073845106],
                             [-0.27940014152871351, 0.046084868421941268, -0.017163166735711232, -0.097528823132309025, 0.081384773465394036, 0.221504246570775, 0.054481850292660026, 0.013349973767393816, -0.19184606170057489, -0.17904120377001431, 0.070561611108469952, -0.14872481655070394, 0.030127263822875474, -0.1628032050583838, -0.18522415994865762, 0.14411292045639532, -0.057130546908913935, -0.068514920374713503, -0.027952021427494447, -0.093901516037864993, 0.12259243972618911, 0.01534055002301906, -0.030732085877661085, -0.019592243195571672, -0.014752563486022349, -0.02734860580557593, -0.19997205662958345, -0.055205558332260249, -0.1867500513596031, 0.049224878958937915, 0.1005191616472824, 0.067839407446139255, 0.050394029045015901, 0.071396843370763838, -0.36087661918849473, -0.24469006354573089, -0.2682370695208865, -0.096863111049793379, 0.098486744028116066, 0.024099609320833635, -0.042311812263296722, 0.38794784101891761, 0.048140955899059389, 0.042875837824478111, -0.13101221376317784, 0.068875124354574185, 0.11489014875348992, -0.1540436673925504, 0.16432839418416847, 0.10449844925081067],
                             [0.19226664334970278, -0.042782594472137524, -0.071778481491973314, -0.29038837623864894, -0.032340009207581157, -0.028370482442951633, 0.018477036852053253, 0.012545955203348863, 0.16010516158255475, 0.20147337847032237, 0.11676118279777924, 0.16461310522026851, -0.17855896470303972, -0.33994470797773879, -0.10115319651354321, 0.11703840769667705, -0.094717869151205711, -0.010298107874113281, 0.22644269867675074, 0.0014655755012032601, -0.26111692304031048, -0.27749643615520764, -0.016989812021838403, 0.15922291062215821, -0.017653695311913065, -0.0030496117804260665, 0.11120742759184418, -0.24614938775110906, 0.083779861663225763, -0.021132468246507823, -0.02599158144723468, -0.057669141416748185, 0.036361766990491179, -0.05811523151211103, 0.11574668340386463, -0.22519031333397163, 0.026043497258935417, 0.11728408879929496, 0.082231552957650583, -0.15779970521975129, 0.04718063715235666, 0.10834486807120434, -0.053746743324101787, -0.12685180312017239, -0.2033549737508516, 0.11910264641463929, 0.16527227107527093, -0.19106794814765923, -0.082677145377280242, 0.032745393206294264],
                             [-0.17514968266048506, 0.16111309446574784, -0.057478033351115052, 0.0884079390880156, -0.0077694855193060786, -0.1599628312869881, 0.13983260234415701, 0.1258608753993741, -0.27228433005957942, 0.12962296899171113, -0.2247234958381735, 0.0069400683519964135, -0.043471798599256865, -0.0639776299670715, -0.060957921860838357, -0.12348008835525839, 0.058399979871473606, -0.066029692773482598, -0.023848002144946444, -0.06550717257722069, 0.03190223175502431, -0.12856564313039381, 0.19495530373224099, -0.23786540013185406, 0.12619198419869537, -0.010421633406218603, -0.050402188333669037, 0.016164236433263843, -0.091518800661466546, 0.013975352282581023, -0.0797217346298425, 0.12031756634695294, -0.062759638449985569, -0.047589855717747785, 0.019764136812757477, 0.36165624434420529, -0.023961794995991714, 0.016013792046245069, 0.068260602007366625, -0.33256652136352016, 0.14609300742466044, 0.037123882416875517, 0.012953411283134987, -0.14241836157639706, -0.24977882922411537, 0.15479959776480787, 0.16280478180423882, 0.061587874113016076, -0.28787251892522048, 0.18865606904173196],
                             [0.17483041263986018, 0.042097692933952748, 0.11462617003767341, -0.044424408360932775, -0.106716126490238, -0.032397002138158472, 0.064165157821003863, -0.21478649236953187, 0.0054918178404383825, -0.096751261625313931, 0.42226258006380074, 0.091496834938158259, 0.11291778429011454, 0.015838274263283894, 0.205191342456993, -0.14460999720012707, -0.11540454954313169, 0.34612194797218149, 0.12833751495250906, 0.078505661030184345, 0.077024328356993715, 0.074262832676978932, 0.016613083730087397, -0.070328866509300383, -0.11935122699867179, 0.053803141253049525, -0.08806735511815772, 0.11868191795410764, 0.16772509598589519, 0.0014235435827245826, 0.072897353514417215, 0.091708609666178706, 0.17901055262434645, -0.09445514540925487, -0.17091988694692811, 0.21708735651173847, -0.060103596798404761, -0.059231728891643784, 0.18814411926932981, 0.026250988577733534, 0.30640626925359526, 0.14214888347269949, -0.12099673154355249, -0.055517363670524629, -0.23307342217761173, 0.091377082931225831, -0.040941085625835469, 0.08630931225532705, 0.012719486531284756, 0.015029678511307416],
                             [-0.012230286978679781, 0.13352695236084539, 0.063784148804384683, -0.063222000635872674, 0.23971344766451849, 0.076468861314432438, -0.14213447449741623, -0.16154496505461141, 0.13815848086911681, -0.22745879430510357, 0.10190911488890948, -0.20655716867199755, -0.0062832839763427911, -0.20686840859905972, 0.18372572777610338, -0.095227253894282493, 0.40589734933531035, 0.0084237430099610624, -0.095416017651282214, 0.16715160403751128, -0.1002447560390505, 0.0052239922677396119, 0.40247764430309174, -0.015008778145358365, -0.085472877057678934, -0.061304459981733415, 0.14973104136040893, 0.054995413631487744, 0.014151279081288845, 0.16895007491028852, -0.011712520303591416, -0.13144074929840593, -0.070791337280125488, -0.025642271364029381, 0.024172736609512815, 0.0076361893023266922, 0.043967165291981053, 0.19800252733910778, 0.048732463853948103, 0.11396590809861214, -0.13317192915897846, 0.024571331523202355, 0.14007485694206465, -0.079820257221863714, 0.0085730007044956553, 0.14159507435366631, 0.20003297504746229, 0.078013419516150526, 0.0088140092695587133, 0.15667195583086455],
                             [0.0058478597645718073, 0.16106066469387689, 0.11955666290815498, 0.0029007279947816092, 0.18976176405045059, -0.3174366413924965, -0.04610315080499968, -0.15283247389164589, -0.11649820720913408, -0.23987349088086349, -0.044303115014699648, 0.030164889001015462, 0.0030691359484277857, 0.064247465812476909, -0.018671324055211699, 0.10445372520699946, -0.28018113268536637, 0.12198541765092445, -0.17205643356816699, 0.24375973816435689, 0.0036979635636201504, -0.011802868737446771, -0.079221830637357452, -0.075168987916246349, -0.10903775763123032, -0.28490366727634125, 0.017400478195573145, -0.17515408379484132, -0.1390281113103749, 0.19273651608658637, -0.33156979246464036, 0.071962339702111078, 0.059117508929930708, -0.011534049174722323, 0.096783315487658117, -0.19436137567610187, 0.048314045943470732, -0.17416556324175514, 0.21493491215438179, -0.099351319976705474, -0.09674878281882475, -0.18597723037417085, -0.033138427784034662, -0.064471344535349459, -0.093578456760476686, -0.075147458297022698, 0.070548494018385158, -0.0064509560178645257, 0.016852848436496221, -0.097723667262409206],
                             [-0.20040730714834712, 0.13327173318843566, 0.41112085663724351, 0.016534971764498561, 0.052954943734915508, 0.11112921668414158, -0.056445949267704965, 0.076998956111796052, 0.077650638014764364, -0.10977932086529379, 0.094887519043503094, -0.073476608935675772, 0.1485785893294361, -0.049188577472701854, -0.18007264916196347, 0.065573240263296959, -0.0031280204753669836, -0.021201917385201864, -0.0097086293852163656, 0.070867059445053074, 0.057390673122724729, 0.017879760205036094, -0.073143969297420924, -0.06774013179238926, -0.035207840595082252, 0.009728610879730086, -0.073495390009866407, -0.090116225433752375, -0.1140145822626092, -0.18499285300233587, -0.018089572278638451, -0.12783586703233515, 0.074956326465622405, -0.19631475869125439, 0.092905663772690952, 0.15489946349010483, 0.011859961555597948, 0.30856288049321967, -0.189436697734819, 0.10866008320503281, 0.21679180182448979, -0.13340284490018461, -0.15976632673039248, 0.032664399241016613, -0.036076902166167366, -0.058529707677699015, 0.11939945044959144, -0.36153896440089783, -0.20376063550787663, -0.23346280242150771],
                             [0.31353842141328098, 0.088928746460186295, 0.1896144777799002, -0.025997551441580571, 0.11939964428115522, -0.0017231734976209197, 0.023568197156695624, 0.091100445836514582, -0.14337467207400589, 0.19631160753336252, -0.085099421949526285, -0.10949639924502279, 0.070054023839099686, 0.09826116170382819, 0.20937998983254408, -0.1014700189048459, -0.093953295787273641, -0.01899790074828981, -0.17027728766353256, -0.23621070543725972, -0.13182779626734742, 0.1682947834152265, -0.037317653279342604, -0.062485014271606035, -0.11956972938302632, 0.19208924107405689, -0.099198623924829546, -0.13294643880977611, 0.057081126573870045, -0.14780112511113525, -0.079535897774950265, 0.090225666867250545, -0.020749427138717299, 0.044255417276935313, 0.11394530125040279, -0.02021337209239793, -0.21233224697700892, -0.034644491785173849, 0.014463375972299582, 0.078197910500783063, -0.09148467801268978, -0.0063434760228886162, -0.03901894933601751, 0.024607579316359263, 0.12136433289283029, 0.38249492556480058, 0.37444993909437041, -0.065583311541760267, 0.16929603680848448, -0.10307722921615046],
                             [-0.12755557599328604, -0.10412217875000652, -0.10629748117434541, 0.17462703252595291, 0.082851501466263508, 0.029513997384622685, -0.2045846708361414, -0.17040545454130337, -0.17073338982208738, 0.32982552138339899, 0.19734176433017891, 0.07373826018970224, 0.071181268606639425, -0.085835392913667111, 0.21322024423979949, 0.14521214417771494, 0.057792138170637393, -0.09609089451271649, -0.15553768713159127, -0.094420796306705468, 0.072667422113770391, -0.18748081785686041, 0.10617995775415032, 0.17453024096393482, -0.11831066977121088, -0.29922307263915032, -0.15324487722733485, 0.22464221786998553, -0.042935739505502543, -0.12115879368783461, 0.047942089751120291, 0.24942034157412371, 0.0079955597596532424, -0.26942760719685954, 0.035633237170710444, -0.095332080488125429, 0.057996975516656536, 0.016710045047107554, 0.095574219058939633, -0.019575757760280772, -0.026256523177169311, -0.10346128028230799, -0.2199006424828506, 0.094937288437933726, 0.13042282469143887, 0.051794554037348506, 0.0072497910001109202, -0.1237900769950905, -0.044484977611979483, 0.053143668263117637],
                             [-0.033936736455358892, 0.12289841501833279, -0.0033069678297775532, 0.058945832448254291, -0.19092901608723806, -0.093340858799904433, -0.15874047052257567, 0.11452566048493792, 0.031477570430513184, 0.14143117787701162, 0.13595147242803945, -0.19661086458849553, 0.060366359133396233, -0.072367152738153653, -0.11899369625864356, -0.31988019481498642, 0.14141677877028092, -0.16560039722889702, -0.1003260930327988, 0.091629381088808401, -0.26932278156655376, 0.11284542014239074, 0.073235317884421017, -0.073328510196154398, -0.082506191443239438, 0.0095115106259749532, -0.14877943163371815, -0.10590382805843079, 0.17902271341396517, 0.072225351179151409, -0.17165332430688102, 0.021235855301238935, 0.18058794345673818, -0.076847993050970537, -0.13943156094659409, -0.19984077530936306, -0.055615348776354837, -0.28451832180434306, -0.30193723793187921, 5.5100840287690187e-06, -0.084659151254428702, 0.0013935024476322464, -0.25856370532810208, -0.12117338174663775, -0.089739703120300565, -0.07030068051061697, -0.19073052420044104, -0.013847025163976692, -0.092441177078708012, 0.063526723571551869],
                             [-0.091659833548446146, -0.39765162927933717, -0.19325577754016757, 0.01172470881038744, 0.1699406807348417, 0.1177298900821252, 0.21145697344803813, -0.10901027896628013, -0.11819140855137127, 0.0053213696273506335, -0.1738575826291095, 0.11225912602176132, 0.088310297929955539, -0.25829835838929843, -0.098015073884567469, -0.33334917778643508, -0.17403511656413495, 0.05484917091751413, 0.021539748410019082, 0.043757900859902138, -0.14390392798002735, 0.16851305332237468, -0.050060167511676849, -0.13021444778678626, -0.13861223500263584, -0.18550321230126654, -0.013694643042076982, 0.28284194541993724, 0.030454378343953318, 0.036894933833639287, -0.058454811714612663, -0.13525950109008478, 0.00055913448983328524, 0.095679036431253736, -0.043061382387677177, -0.072559944244298194, -0.0027850088996465364, 0.09667704118065662, -0.10632193138915805, 0.15318322127969794, 0.074043789811102309, -0.20693798582353529, 0.00044227259259288075, -0.14114884372664221, -0.093408290053166407, 0.14418475614429052, 0.039188051335221297, -0.093993416022796289, 0.017793636619580326, -0.11702333762736437],
                             [0.11597303821368031, -0.16465646990536348, 0.17250350926705724, 0.11034858617323856, 0.01861263359583059, -0.1188357523410305, 0.069671553104893397, -0.11774097470785572, 0.13651752230611769, -0.094229606668806934, -0.19874612719516907, -0.21678768285185485, -0.11281761835464499, -0.10914876162177106, 0.07036732496633856, -0.17204922117939639, 0.049960979445529949, -0.10225339594421316, 0.12694360222525444, -0.11203588810253955, 0.29148694887475679, -0.14717953979451048, 0.033837217806911762, 0.28665758450588469, -0.29334213354183775, 0.16034053263509643, -0.14778197313002822, -0.006264674056114374, -0.15105620329371883, -0.17010870217395413, -0.14289756171648094, 0.12979932198108229, -0.11250647518095082, 0.10531747323293288, 0.035026479865536253, -0.11956397057617607, 0.080606268934540759, -0.13365629016953112, -0.070655686616079322, 0.10279223526980578, 0.22115247685448092, -0.056976543147708371, 0.0029002600364184412, -0.04491539807385183, -0.1913190631675058, -0.20517064544650354, 0.093539679390142169, 0.024272646044434236, -0.0053801008929331229, 0.18828516571197951],
                             [0.18407776959725186, -0.027405340684884937, -0.053507845192660518, -0.013760933466358238, -0.00028254202298434635, 0.051370094714868336, 0.19069370603072339, -0.013209869104806655, -0.053786705142700106, 0.077508538526382245, 0.095937913268300562, -0.22081846378863954, -0.28302733781640144, 0.032898854189400917, 0.20509136311291551, -0.10928094163668485, -0.063433204790932216, -0.15215925566328817, 0.14227165832048899, 0.12954299042172365, -0.017525511779004462, 0.20896748619752023, -0.052988530893893458, 0.060734695976316581, 0.21560822832140572, -0.16562969190962443, -0.26344845124704863, -0.067163289157750758, -0.17099235799827689, 0.028052410061708603, -0.17963574238277949, -0.05167859829832492, -0.084184054188399957, -0.026943429785874939, -0.13739202855076749, 0.049221529789231187, -0.053469330650290081, 0.42973518438580854, 0.08563280345070895, -0.051377588395268223, -0.17598494037135629, 0.041689457825885907, -0.22858818199969555, 0.14097806258028492, -0.071045455841626456, -0.18545805658597689, -0.017101037527538141, 0.1281766602793378, -0.037430197545282318, -0.067743463593280387],
                             [0.14511157734647961, 0.074973539081638355, 0.0088055869425566514, -0.22645522526810724, -0.10041668925891457, -0.092486232816352681, -0.04898892021469034, -0.26703581541539434, -0.1914805075549639, 0.087035343201040102, -0.22385456738118506, -0.091317133023523706, -0.070796910818286887, -0.040904893788471203, -0.011647013395723629, 0.10662482892057239, 0.057629309315995726, -0.12984987341387727, -0.02076491448746956, 0.13697997783557034, -0.071340643405640197, -0.20778962092547812, -0.045725275811586377, -0.16375603278473605, -0.12011005346301501, 0.0019333843451918497, -0.17781036889584653, 0.103209905765236, 0.091813450253403997, -0.0082611827668796368, 0.059442114737158019, -0.076000720748167855, -0.16472629767791511, -0.20258988552919671, 0.092523834143379724, 0.21541093686612831, -0.018231462988150364, -0.094530315807022439, -0.051559731839842825, 0.28317877951334186, -0.14225645760185435, 0.13510528770713895, 0.1883786729153159, 0.17162897433707205, -0.28652914174359967, -0.017045876008623329, -0.22582562038130469, -0.13036068577916959, 0.10010281534283873, -0.19644261083174119],
                             [0.11412327096014789, 0.11647925383345709, -0.036463014749939855, -0.0085653263532739464, 0.13212258353339554, -0.10081194022784211, -0.085710056272888344, 0.074654645396164301, -0.028799461029655457, 0.13745523495538417, -0.25870406271854063, -0.21450459897358476, -0.027499444711005346, 0.0582620579587503, 0.095753038291568046, 0.20755738007146965, -0.14865356937470364, 0.025217326746576185, 0.11297544089080092, 0.12009515924759138, -0.042816381290693574, 0.071051294019984529, 0.15025580899845778, 0.047677247839374978, 0.050938501198238964, -0.048046439833244352, 0.36050473595004301, 0.22397467737005153, -0.11067348504204826, -0.17471221941030368, 0.17549935125177582, 0.074874941193503505, 0.1278562713902959, -0.017149330415383066, -0.19928771227310124, -0.039760183575336908, -0.11840353404411884, -0.027494370447819209, -0.024743850598119076, 0.21455812836144084, 0.049650107692092195, 0.15106495766816316, -0.18792095466557945, -0.39681116780363057, -0.013619539398389979, -0.1451093898928148, 0.015165654637049971, 0.018707935244819267, -0.11093216407278485, -0.15809374367490817],
                             [0.003758265387310296, -0.065987908041225424, -0.14549310266254653, -0.029247212802670491, -0.037873295840276558, 0.111634272837199, 0.033322352023726971, 0.027982315113131533, 0.10253092048614888, -0.1091501000637124, 0.15495616889589525, -0.088858219983237369, -0.025581919074288674, 0.017814499005531555, -0.19822992574993853, 0.12190766997054324, -0.15206989751694777, -0.11116611245739683, 0.19821795211305684, -0.28116892009545918, 0.10935901906399308, 0.107552183061182, 0.16216846193107223, 0.013308812180111896, -0.11321494845801665, 0.019450748266545238, 0.16954541330121342, 0.11402062814898931, -0.054183199879835581, 0.10941906313386071, -0.2395201799516827, -0.15534581542585238, -0.025351264451385424, -0.28366183353569735, 0.21517759112316348, 0.31750012239440861, -0.20067077583595527, -0.21442578140900403, 0.062275042372425225, 0.04528881261495319, -0.23547625456245391, -0.10809857153075622, -0.23195554491994008, -0.073058112128944017, -0.040199609731800798, -0.042617429506157316, 0.06010636115995658, -0.035899019921733367, 0.16070824565706351, 0.11110330352780311],
                             [0.27828079492548763, 0.13138456628961845, -0.040165705166124784, 0.033298357819221684, 0.20944123315353566, 0.21746636368644615, -0.17565586718208284, -0.021770881807933552, 0.039421783982078254, -0.088363819648126105, -0.014266026100507671, 0.23678467842692946, 0.13471736592587066, 0.30937915289139267, -0.020372184163623401, -0.081145708875587919, 0.1113102129327468, -0.042262795601758767, 0.26331872827107577, -0.23170558404131375, -0.0092963188862337839, 0.012355510529804995, -0.032134780645123692, -0.1870515998673474, -0.18059099488276609, -0.22445822752261083, -0.041585922039508671, 0.060900149311159085, -0.22392530228024932, -0.039920550190131347, -0.021048378379362079, -0.059486506864966052, -0.027205485745879884, 0.13817843094171972, 0.040666918515905696, -0.1095566895822818, 0.18321144878885692, -0.045087371895943786, -0.116649819165103, -0.065847494049592614, -0.12257383431221733, 0.23864816514380188, -0.060826246148288715, 0.046428635901650188, -0.15925502918535681, 0.058831667477157297, -0.068279615971233359, -0.039184878959875588, -0.27545493471723909, 0.014853640081592246],
                             [-0.12410359267628325, 0.16479944547609218, -0.087662806891871392, 0.11130678697544678, 0.019674094000574467, 0.0098965977269638, -0.2193815714921297, 0.063111161041377581, 0.098655361133468802, 0.067924992212720053, 0.020684968422556189, -0.035557373860532301, -0.20592515286352434, -0.076404372082775743, -0.098655439505512796, -0.28220617378607715, -0.091442039066932809, -0.030567718085822104, -0.12466773725720803, -0.091031764741846086, 0.04465657747480134, 0.03897484837620329, 0.0007167876863400965, 0.30090716901052633, -0.039713290058823923, 0.10625527001875955, 0.047919351848408245, 0.122364235495805, -0.22232563784105819, 0.025430826751254351, -0.15279774223494505, -0.049542269228822211, 0.21968347080240025, 0.030987599930623749, 0.18386644893901005, 0.028594135694623074, -0.040292388864142249, 0.060675095537388347, 0.26030455907669992, 0.036091607419928146, 0.085947930093256644, 0.18822173828601452, 0.17231079663838356, 0.052540908379319531, -0.050658181004394197, 0.24628524553133416, -0.27543395247279018, 0.062035056217942142, -0.046231461017616368, -0.34549544067756371],
                             [-0.14627564148858749, 0.046435666169224739, -0.10434613309245051, -0.20210379414560997, -0.11533727201005861, 0.15202999180317861, 0.036245214549203729, -0.049714012533294452, 0.15982580135151545, 0.05107706544188962, -0.17087181351081837, -0.03439619325031143, 0.066913309388672376, 0.0018931962673904344, 0.0075289630773054186, -0.012233140542401941, -0.31541800272435022, -0.036209624568254578, -0.029032838701147725, 0.31659370392576913, 0.13003893451890117, 0.17110651562977328, -0.038590666563205832, 0.028734655379357269, -0.18191912974005309, 0.03589498169358199, -0.15353440613045491, -0.023633558340558646, 0.046322781778716196, -0.0021905231112969818, -0.049824404428713227, 0.03446653269554624, -0.067761935673777182, -0.19775144751372245, 0.13462779944440956, 0.032828219483756832, 0.30893730253580176, -0.053172354501163061, -0.049192474559371403, 0.041660288648787076, -0.018499721818884908, 0.34613481128717816, -0.04948053077002549, -0.033253679097361134, 0.29906427321675749, 0.13963263444820628, 0.14785522166824086, 0.14578343202925279, -0.19761972085763926, 0.16261842540440136],
                             [-0.21381134167399657, 0.055903186004409897, 0.11106684663121467, 0.13519265145208714, -0.02834407882111812, -0.083915287040690525, -0.081465420478981282, 0.029472295984976454, 0.25294918303572661, -0.013169744507984849, -0.062595379073157986, 0.083058869162995055, -0.17411040762587746, 0.22908669832884951, 0.16622697290170504, -0.214518190811191, -0.031345668347728811, -0.1568262245835092, 0.11178598862086753, 0.11943803492720317, -0.17425477839996464, -0.098207109588870772, -0.21713234568966278, -0.031816644247897582, 0.087246543448778233, -0.35588860547826229, 0.037356350484471508, 0.094972075917877111, 0.10472933647323429, -0.14203528580613767, -0.036864524888145608, -0.12358966499202746, -0.096361370313386277, 0.020165543223115895, 0.054522680265791858, 0.07993929543211617, -0.23626004728898456, -0.072329303485247146, 0.10345920493102759, 0.062161584957711034, 0.15280700806346995, 0.17542373078978665, 0.040265118343766386, -0.041897828647848509, 0.06473985842286005, 0.018449205091675996, 0.083898058500560119, -0.22459733881191579, 0.24174407341996781, 0.26111977297562389],
                             [0.039798534355957885, 0.20005196062006811, -0.22491602745793168, -0.22658635081351722, 0.016183290143689025, -0.12837597413023336, 0.075778858946843344, -0.094086245108377861, -0.35435046046351837, 0.11592836100821935, 0.11979291958659812, -0.0094738200438833475, 0.17606579851024823, 0.02149845965345951, -0.10242518277055113, -0.29382674377273954, 0.29451942373379181, -0.073070852169522749, 0.056139104836089311, 0.066679214447569982, 0.2174144806299686, 0.17299376239899789, -0.20105500975165835, 0.21072168850904721, 0.023289922807361963, -0.060844386824258301, 0.1954879013619884, -0.1177539275423429, -0.061806249496510472, 0.014097987761873147, 0.14455284845537991, -0.16021812458868911, -0.081118674870624088, 0.010725328939348248, 0.16008108973059054, -0.0082831628711709133, 0.043358208306335674, -0.097855983114223263, 0.11028894061611522, 0.04221914786369034, 0.14707023737300812, 0.02407311755210606, -0.078233105219543353, -0.028581915541933279, 0.10354009016193549, -0.17738996064590534, 0.15422295055697721, -0.13749199386918975, 0.051152925296925299, -0.018888188699757925],
                             [-0.058259930139433168, 0.07383295399723, -0.089607695582515925, -0.13098640869882469, -0.34567925865653815, -0.0088020162074167515, -0.14710340803981853, 0.037898436991233977, 0.0076195748063344589, 0.00081428117135067522, -0.037973240919249085, -0.13695414845703285, 0.25146487803384066, 0.07938742665249196, -0.0026053207823227629, 0.16859797503020374, 0.011841542594782971, 0.23842316541223124, -0.09827080719511215, -0.13026044053723898, -0.027370190920724985, 0.070777764816000302, 0.16230769989393537, 0.17174187502485436, 0.079317261360191113, -0.15623569575530796, -0.16271521272524536, 0.15577529519254185, 0.083437741978510921, -0.065918020908388927, -0.27117420734011582, -0.066927995143646973, -0.28186376637632732, 0.31347159430411925, 0.06628478853022525, -0.013513796830974853, 0.15058752177004875, 0.15874252250393314, -0.032789466298901351, -0.10303176558623932, 0.08624013969672932, 0.076975279957230663, -0.065842608933631766, -0.19721673839151541, -0.14321673589621939, 0.011022948848522748, 0.0074115467445568682, -0.10819992110867502, 0.2221104406299905, -0.09458510367719962]]])

    sigmas = [1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0]

    lambdas = [5.0 * 5.0 / 100.0, 5.0 / 100.0, 5.0 * 1.0, 1.0, 5.0 * 1.0, 1.0,
               5.0 * 10.0, 10.0, 5.0 * 5.0 / 200.0, 5.0 / 200.0]

    biases = [0.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0]

    def __init__(self, num_variables,
                 matrices=None,
                 offsets=None,
                 phenome_preprocessor=None,
                 **kwargs):
        rastrigin = RastriginFunction()
        weierstrass = WeierstrassFunction()
        basic_functions = [generalized_schaffer6, generalized_schaffer6,
                           rastrigin, rastrigin, f8f2, f8f2, weierstrass,
                           weierstrass, griewank, griewank]
        if matrices is None:
            self.matrices = {2: self.matrices2D, 10: self.matrices10D, 30: self.matrices30D, 50: self.matrices50D}
            matrices = self.matrices[num_variables]
        if offsets is None:
            offsets = self.offsets
        self.hybrid_composition_function = HybridCompositionFunction(num_variables,
                                                                     basic_functions,
                                                                     matrices,
                                                                     self.sigmas,
                                                                     self.lambdas,
                                                                     self.biases,
                                                                     offsets,
                                                                     2000.0,
                                                                     name="Hybrid Composition Function 3")
        self.num_variables = num_variables
        self.is_deterministic = True
        self.do_maximize = False
        self.min_bounds = [-5.0] * num_variables
        self.max_bounds = [5.0] * num_variables
        bounds = (self.min_bounds, self.max_bounds)
        preprocessor = BoundConstraintsChecker(bounds, phenome_preprocessor)
        TestProblem.__init__(self, self.objective_function,
                             phenome_preprocessor=preprocessor,
                             **kwargs)


    def get_optimal_solutions(self, max_number=None):
        return [Individual(self.offsets[0][:self.num_variables])]


    def objective_function(self, phenome):
        obj_value = self.hybrid_composition_function(phenome) + self.bias
        return obj_value
