
import numpy as np

from optproblems.base import Individual, BoundConstraintsChecker, TestProblem
from optproblems.continuous import RastriginFunction, WeierstrassFunction
from optproblems.continuous import ackley, sphere, griewank
from optproblems.cec2005.helper import HybridCompositionFunction


class F18(TestProblem):
    """Rotated hybrid composition function F18."""

    bias = 10.0

    offsets = [[1.5953, 2.644, 1.8047, 0.9389, -3.0486, -1.1571, 3.5582, 2.4246, -0.3767, 4.4637, 4.4793, -4.3924, -1.5149, -1.8416, 3.008, 0.8213, 2.7314, 0.8481, -3.9423, -3.5341, -0.1481, 1.9924, 2.8357, -3.899, -2.6808, 0.6437, -2.6297, 2.5844, -1.3002, 3.0962, 1.9387, 4.268, 0.6687, -1.181, -1.5665, 2.6673, -3.8233, 2.8977, -3.5785, -4.385, -2.6055, 3.6374, 3.3571, -0.032, -1.1528, -1.7354, -4.0471, 1.8481, 0.9251, -2.961, 1.4861, 2.0947, 3.0545, 3.9822, -3.6943, -3.826, 0.6094, -0.9008, 0.5744, 4.2162, 0.4908, 3.8078, 1.8709, -1.9301, -0.26, 2.5956, -0.1701, 2.5416, -1.5888, 0.5767, 1.3802, -3.676, 0.5727, -0.2843, 2.2799, -4.3213, 3.9601, 3.7423, 2.5688, -2.0729, -1.2435, 0.5262, -2.4123, -2.9689, 0.574, 2.2447, 0.0113, -0.1147, -1.3399, -4.2553, 2.5203, -4.4099, -4.498, -1.4799, -0.1648, -3.2263, -2.4704, 4.489, -2.7025, 1.0214],
               [-0.4694, -0.9504, 4.423, -4.3429, 4.1355, -2.1496, 1.359, 1.6644, -0.4942, -0.3133, 2.8969, 3.5529, 4.3648, 1.6676, 4.3873, 1.2013, -3.3488, 1.9179, -3.0347, -3.1162, 0.6953, 1.1995, 4.078, 2.9136, -3.977, 1.4906, 4.1008, -4.4356, 4.1101, 0.2507, 1.8725, -0.1733, -3.125, -0.8586, -3.3198, 3.9131, -0.857, 3.7669, 3.4829, 3.6658, -0.7697, -3.5814, -4.1172, 2.9127, -4.4485, 3.4213, 2.3902, 2.0265, -2.7435, 2.1096, -1.2642, -2.6251, -1.6156, 0.2497, -0.952, 1.8805, 0.5874, 0.074, -3.2857, -2.069, 3.9455, -3.488, -1.9532, 0.7981, -2.3774, 1.5821, 1.0687, 2.8757, 2.4418, 3.8749, -1.8744, -0.2689, -2.4202, -1.0933, 2.4775, 3.4062, 3.8519, 0.2697, 4.057, -3.4813, 1.364, 0.9791, 0.3786, 1.0357, -2.8149, 3.7426, 1.5305, 2.2033, -0.2552, -0.4773, 2.8402, -3.9985, 2.9175, 2.657, 1.9482, -2.5473, -2.778, 3.083, -1.0791, 4.1557],
               [1.5059, 1.4645, -3.019, 2.4182, -0.3464, 4.1054, -1.3402, -3.0782, -2.609, 3.1952, 2.6404, 3.4108, 1.5007, 3.3836, -2.93, -4.4413, -4.0264, -0.3244, -2.068, -3.9792, 0.3351, -4.4986, -3.3008, -3.1732, 1.5274, 2.7197, -3.8414, -0.089, 2.0098, -1.3819, -0.3714, 1.1506, 4.4092, -2.5041, 1.8166, 1.9411, -1.5877, -0.7389, -3.2214, 0.988, 3.0597, 2.035, 1.1269, 2.2449, 1.6163, 2.9061, -2.927, -1.8663, -2.3012, -3.054, -2.8475, -0.3154, 2.0189, 3.5799, 2.5004, 2.1726, -2.3015, 0.0365, -1.9528, -4.0525, 3.8383, -4.2818, -2.9702, -2.818, 0.3275, -4.1971, 3.5293, -2.3649, 3.6285, -3.3654, -3.6385, -1.7819, -3.4012, -0.8381, -2.1338, -1.0608, -0.6099, -1.3864, -3.0536, -3.8265, -3.6656, -3.4714, 0.3118, 1.9456, 3.2694, -1.5046, 0.5896, 0.1711, -1.8727, -2.304, -4.1229, 1.0773, 2.6329, -3.4434, -2.9708, 3.8591, -1.9641, 2.1665, 2.4181, -1.6451],
               [2.8727, -0.8312, -4.1507, -4.3428, -4.2097, -3.95, -3.7506, -3.1893, 3.4647, 0.4615, 1.581, -0.4376, 1.5074, 0.8747, 0.3915, -0.5341, -0.953, 1.1543, -4.0131, -2.871, -3.3812, 1.8587, 2.6131, -3.4436, -1.8011, 1.7809, 3.7035, 1.065, 2.2193, -1.4669, -0.1322, -0.4288, 3.1035, 1.2798, 0.8398, -2.8744, -4.4, 1.2042, -0.3312, 1.0092, -1.2502, -3.5151, 1.8168, -0.3298, 3.4255, 2.6113, -0.4725, 0.0535, -2.5668, 2.7233, -0.1867, -3.8712, -2.1966, 2.8308, -2.6592, -1.8225, 3.2404, -0.3647, -2.6874, -3.7407, 4.0805, 3.245, -4.169, -2.7157, 0.4695, -2.9804, 2.2225, -1.5141, 0.0602, -3.7222, 0.7063, -3.5451, 1.3085, -0.7206, -0.2193, 0.9755, -0.0105, -2.8736, 3.4371, -4.3517, -3.3811, -0.9701, 1.3177, 0.5757, 2.9334, 2.5125, -0.3391, 0.3051, -0.7175, -1.314, 2.9475, -3.483, -0.9436, -1.4855, -0.2893, -0.8183, 1.7258, -3.0167, -0.1103, 3.1678],
               [4.4658, -3.9845, -0.3494, 0.2917, -4.2515, 2.354, -3.4443, -4.4291, -2.4516, 0.8209, 1.4629, -1.6978, -4.2535, 1.9427, 0.7308, 4.084, -2.7881, 3.941, -3.1722, 0.39, 2.8115, 0.9652, -2.7972, 0.7904, 3.4347, -3.3543, 1.2593, -0.8484, 3.7855, -1.2499, -4.4726, -4.1715, -1.9464, -4.2946, 0.0137, 1.8651, 1.3919, 1.3469, 0.077, -4.2427, 2.0416, -2.2337, 3.1337, 0.7874, 3.4143, -2.8692, 1.208, -2.1867, -3.3004, -3.3325, -1.7701, -2.1764, 1.959, -1.5053, -3.2669, -0.6987, 0.2366, -3.654, -0.3136, -0.5393, -2.839, 0.0449, 3.7872, -1.492, 3.4913, -2.5888, 4.0587, -1.4555, -0.856, -1.9638, 4.2491, -3.7508, 3.3998, 3.9581, -0.3211, -3.1923, -2.3639, 3.2155, -1.1436, 0.0863, -1.8019, 4.0851, 4.0134, 3.292, -4.1672, -2.8533, -1.5603, -1.7606, -1.7146, -3.1181, 3.9641, 0.2457, -0.8076, 4.3399, -2.8689, 3.5696, 2.2266, -0.6762, -2.1257, -3.0045],
               [-3.6435, -2.0476, -1.2299, -3.4435, 4.4239, -2.2258, 0.6129, -2.9539, 0.0023, -2.2894, 1.9921, -3.7181, 3.2795, 0.8902, -1.5611, -0.6445, 0.6171, -3.1832, -0.9539, 1.5753, 2.8997, -2.9514, 1.5675, 4.2907, 4.1501, 0.2397, -3.4251, 2.3066, 3.1111, -4.4475, 2.9233, 4.2417, 2.5346, -0.8434, 2.6903, 1.2803, 3.7653, -2.0836, -2.6593, -2.3126, 4.0565, 0.2353, 1.7158, -1.7222, 3.1438, -1.2706, -1.7882, 0.6263, -0.8204, 2.415, 4.1012, 2.4257, -0.0525, 0.2929, 3.4564, -4.1724, 3.9334, -4.1287, 3.856, 3.2555, 0.3465, -1.9134, -1.978, -2.415, -3.1939, -4.4729, -1.8994, -0.1777, -1.7676, 3.8711, 2.4538, -2.4724, -0.9937, 3.0893, -0.1302, -1.9, 2.0793, -0.741, -2.9585, -4.473, -0.7422, 1.2235, -4.2093, 3.1633, -0.9721, 1.4358, -3.8565, 1.4121, 2.457, -2.6026, 3.6255, -3.3658, 4.0111, 0.0963, 3.6452, 2.2841, 0.7774, -3.0156, -2.8912, 3.1835],
               [-1.1745, 3.0297, 2.8241, -0.1778, 3.3345, -2.8002, 2.9149, 1.281, -2.2089, -1.3471, -1.9499, 0.6569, -1.9806, -2.319, 3.287, 3.702, -3.8655, -2.7791, 2.4153, -2.8463, -0.3631, -0.5981, -0.924, 2.8715, 3.502, -4.2941, -1.1615, 0.9879, 0.4369, 0.0763, 0.6576, 0.6311, -4.3961, 4.3963, 1.3707, -0.0266, 1.9707, -1.2409, -1.9082, -2.1188, 1.3977, 2.0461, -0.6695, 1.1433, 3.6783, -1.1106, 3.2087, -1.1471, -1.4124, 0.5772, 2.8861, 0.9213, 1.4773, 1.0597, -2.0235, 0.7462, -3.5674, 1.611, -4.2773, -4.2037, -2.9796, 0.8997, -4.4701, 2.652, 4.4957, 1.3634, -0.5745, -0.9522, -2.4138, 0.6266, 1.967, -2.7401, -2.7359, -1.8662, -0.7621, -2.0829, -1.2188, -4.4287, -1.7063, 2.8928, -1.1988, 1.4114, -1.0523, -2.8782, 1.7692, -0.3978, -4.174, 1.0188, 3.2339, 3.2872, -1.0091, -0.3623, 3.9882, -2.0295, 3.2559, -0.0226, 1.9173, 0.6989, 3.0538, -1.4615],
               [0.1917, 1.5042, 3.9221, 4.3594, -1.8238, -3.6437, -0.324, -3.7165, -1.2099, 0.7948, 1.1181, 4.0311, 0.9166, 4.1516, -1.8571, -3.0236, -0.0184, -1.4155, -0.0369, 1.8959, 3.8687, 0.0725, 1.012, 1.6473, 3.1023, 2.1231, -1.3169, -1.5877, -0.5051, -1.597, 2.5903, 4.1357, 2.9418, -3.534, 4.1269, -0.1585, -2.9321, 4.4927, -2.0294, -1.3496, -3.6786, 1.7717, -1.761, 2.5642, 3.7443, -2.6462, -4.194, 1.7037, 0.1554, 3.0101, -2.6164, 1.6023, 2.2117, 1.3432, -4.1605, -1.7008, 3.0109, 1.6287, -0.7228, -2.8939, 1.6288, 1.6823, 1.6935, -2.056, -2.2421, 1.8703, 4.4554, -1.9358, -4.2634, 2.1077, -1.7835, -3.9426, -2.268, -1.9449, 4.4574, 0.5201, 2.1527, 4.4191, 2.263, 0.5296, -3.9116, 0.1973, -1.0577, -3.1378, 3.9344, -3.0929, -1.3338, -1.9536, -4.0336, -1.0727, 2.0414, 3.8963, 2.0828, 2.9286, 1.0216, -3.119, -0.6571, 3.4339, 0.1909, 3.0014],
               [3.3343, -0.873, 1.3635, 4.2597, 2.5769, 0.8656, -0.3686, -3.9734, 4.2913, 2.7508, -4.0107, -3.5053, -0.4895, -1.3107, -0.9999, -2.6812, -0.7117, -0.405, 0.7137, -4.238, -4.2863, -2.9899, 1.7945, -1.698, -2.4834, 0.8753, 2.6363, 1.8389, 4.4227, 3.1564, -2.4925, 0.1185, 3.7033, 3.7941, 1.5931, -0.3381, -0.7565, -4.2494, 0.2984, -1.6731, 3.1468, 3.7846, -0.3273, -1.2854, -0.9828, -1.9557, -0.4683, 0.1099, 3.8553, 4.285, 3.4984, 3.9925, -2.9157, 0.7524, 0.1578, 0.5946, -0.1152, 1.7587, -4.2671, -2.5506, 2.2974, 1.191, 1.2025, 1.462, 2.9187, 3.247, 0.7028, 4.2204, -0.4681, 0.9897, -3.3918, 1.3758, 4.1709, 0.9767, -3.7773, 3.8934, 0.9309, 1.9174, -1.8683, -1.6969, -3.1156, -2.2597, -4.2807, 2.3251, -0.3963, -3.9255, -4.0755, -1.8718, -0.9349, -0.4783, -0.1861, 1.331, 3.6992, -0.0393, 3.2312, -3.9977, -1.389, 0.1224, 2.2305, 4.0094],
               [0.0] * 100]

    matrices2D = np.array([[[0.5391650130196375, 1.9078063596431412],
                            [1.0327299372660115, -0.05518024569772678]],
                           [[-0.7655372444166345, -1.4755467536858644],
                            [2.520661117853597, 0.9396712372096672]],
                           [[-0.8957549657187046, -1.0134242026964273],
                            [-0.45094747537782065, 1.72256808319142]],
                           [[-0.856525047154274, -1.163030440618662],
                            [0.5472937974245211, -2.7593829993482917]],
                           [[0.3261613985297425, 1.969144249511735],
                            [-0.9706098427948098, 0.2720408053837194]],
                           [[0.1534409109869302, 1.134211930353607],
                            [2.7783152920672385, 0.9853848597093321]],
                           [[-11.724371711229278, 7.080386534260347],
                            [13.197307500005383, -6.264048950374923]],
                           [[22.913942382049473, 0.7736067004936894],
                            [-19.274626753587842, -1.959984871100716]],
                           [[0.41312602830495704, -42.07085217000492],
                            [6.672798245146899, -195.4132710133933]],
                           [[23.72837375448979, -2.5754410074859257],
                            [-295.6856272431284, 44.736352381725844]]])

    matrices10D = np.array([[[0.097190131924568962, 0.17277925229775867, -0.041656814677776766, -0.038729650747657149, 0.024263756298486816, -0.39454580107453874, 0.57897911620975973, 0.29334300760908155, 0.59020311679920745, -0.7660914920400097],
                             [-0.42793579224593259, 0.26140383465534839, -0.37715046253368689, 1.1578208028882377, -0.43893515980374215, 0.22603384048671255, 0.51796389643080809, -0.26927013182957987, -0.01068224816630501, 0.20415784394865821],
                             [-0.81198227901818731, 0.18150591779793587, 0.28772116580337864, -0.51400730192772437, -0.57661766373000578, 0.12196086773426185, 0.48544311536853035, -0.38714103186341187, 0.11750267191553054, -0.053121798822449204],
                             [0.22303940434149544, 0.4271352856624242, -0.02290694526073872, -0.1700769388045717, 0.60491671401734814, 0.65021394546347744, -0.19296766628953799, -0.84888975710171677, 0.57949508621588675, -0.058508274129566828],
                             [-0.43832699111176371, 0.10867138334753455, 0.14466465281613028, 0.16088807402797636, 0.12812584189122292, -0.73538630284397133, -0.74516684843057335, -0.061726099176779695, 0.83734290281753498, 0.28492599712083277],
                             [0.67600877648073709, 0.59422929934369284, 0.21613177856650992, -0.14866936174111431, -0.50617945148953758, -0.46706348671968478, -0.90056164335127697, -0.32982171006159389, -0.32229717205974051, -0.21912154442986431],
                             [-0.20062019988204452, 0.9339282344541322, 0.18639778043136124, 0.073812541701763837, 0.22719864701336706, 0.74429488141722389, 0.19273642369356683, 0.6175730304679532, 0.023955193621675808, 0.73878434004659987],
                             [-0.53025608169886396, 0.37761766267985253, -0.6506929718446971, 0.12676723415137578, 0.17014350849835932, 0.16051882591152766, -0.55665933769660081, 0.37580810661663067, -0.5305012372560286, -0.66830155389065349],
                             [0.19884060595278968, 0.044093658166061631, -0.83053780370201735, -0.37156407004788811, -0.47017786290766478, -0.066485390664988681, 0.035346808225231389, 0.068874234669497214, 0.62629048586455394, 0.41097162142038834],
                             [0.18206808214347092, -0.38037248913712957, 0.48567703934783413, 0.42124489827272243, -0.49664026510278786, 0.90436104977806664, -0.17852940836537071, 0.33122948607630431, 0.38835208700267904, -0.37385584115377224]],
                            [[0.63171295931334237, -0.24137762078006406, 0.2831588718940341, -1.0159599421890235, 0.34013203940377174, 0.69895195029722612, 0.082607840698012053, 0.075391934591714671, -0.12283868587417027, 0.68253402676450892],
                             [-1.0460356870848109, 0.62054358844805479, -0.31165829133571843, -0.58414633341797706, 1.0799563056274588, -0.21460357174838607, -0.090560585429421928, -0.21145909774703806, -0.48831575720280046, 0.2031031990566306],
                             [-0.93080613868199624, -1.1463094374793013, -0.41577737418266508, 0.73342489409286893, 0.51587493661153494, 0.65370175607369307, 0.90631750525675447, 0.67213893494545152, -0.54480961856844301, 0.62000464819423318],
                             [0.91394162648185351, -0.3134800491682545, -0.90401218868423028, 0.1732492828259915, 0.82555908193703254, 0.35838672706586649, -0.40353093650876409, -0.10339469152127306, -0.21250296512128081, 0.029426008180425067],
                             [-0.072496791822049336, -0.023425728528548986, -0.19441971339646047, 1.4396536316183288, -0.10595440115008177, 0.3645656878819577, -0.14983102647465191, -1.205763806904367, 0.053629125116003998, 0.52906553573065618],
                             [0.065498665205107165, 0.19978589638646888, 0.46974280559371751, 0.11161593257962343, 0.81772175837588656, -0.60655625906211819, 1.3248631837241887, -0.21512182443039349, 0.56821158448774844, 0.086137574806719297],
                             [0.5822905148702352, -1.0490635059155848, -0.28589351577654049, -0.63214583735707375, 0.21038487664363265, -0.57066767262047602, 0.41993756457151299, -1.0966768296043572, 0.30845631503272714, -0.14802001326565195],
                             [0.2179356132034051, -0.3483682394649173, 0.5605205151033904, -0.13850889350484144, 0.022238047933645824, 0.48158988770192068, -0.057728820589511898, -0.12662546288575877, -1.5077051278688769, -0.5169204081327673],
                             [0.28580256097129525, 0.98470668084760682, -0.90495402371056421, 0.088802808213773718, -0.51056640318189195, 0.26128276613297197, 0.33755675017127285, -0.67459455787336664, -0.36790544719113505, -0.37907832095864913],
                             [0.41731746400087566, 1.1413804484165608, 0.12971503770370332, -0.47566816927028915, -0.84090762071051373, -1.3541369607923071, -0.060192745727768143, -0.053447376577980044, -0.43885497808174251, 1.0364910374083554]],
                            [[0.50212576167945067, -0.26143048733663882, -0.59684209697690804, -0.1011268617136553, 0.17328961992622588, 0.006417600566217492, 0.02924028342022188, -0.016075456084492984, 1.0676333751892855, -0.68644058222717097],
                             [-0.11207569575233506, -0.054800830899528835, -0.27428214829065151, -0.021273448768306571, -0.40358239686372432, -0.54260605687522467, 0.66486801262914763, 0.50086156534435777, 0.56481107945372167, 0.61773583245876096],
                             [0.60663675736047173, -0.41086672201305541, 0.46191155013530638, 0.11886435001828002, -0.39767745843035285, 0.45582253838302578, 0.64604217104993067, 0.11973247748734572, 0.012124306728873352, -0.13040741644859213],
                             [-0.73041745312076378, -0.096589876116547291, 0.42198857439925774, 0.29326356479044774, 0.85069327158904084, 0.57965670443842099, -0.45548407780400685, 0.63838416562059774, 0.18912147446174105, -0.2454782246112161],
                             [-0.45779506376111345, 0.90870373785459768, -0.37480799918419289, -0.32365248620940906, -0.71447135949338758, 0.65152522998012885, 0.46066816699588936, -0.32913650281957779, -0.20312182549614397, -0.12864676336150116],
                             [-0.1863729967314135, 0.28018016391931333, 0.34841897199847777, 0.0020857552571680038, 0.81239887565191704, -0.21012971855144028, 0.52104708291224677, -0.34461617861079108, 0.12527340628963707, 0.21478235849866198],
                             [-0.2438892786621992, -0.37520913112944931, -0.37779309600607791, 0.76899645631733837, 0.15306633031038658, 0.61262753755670762, 0.027365463046457629, -0.4952869050894585, -0.44662443370235544, 0.17598844761000601],
                             [-0.22450626335987439, -0.23011663708040075, 0.27680770164137602, -0.34729246925100382, -0.25998760478873478, 0.35952810009221969, -0.54610650739206068, -0.50139933239064283, 0.38252855613820436, 0.54198520576663578],
                             [0.22373878962814764, 0.38617916078868519, -0.40006108722825606, -0.27439065567926491, 0.42480970217165648, 0.7222037219649583, -0.10968297477901104, 0.28963626069923476, -0.53240983202700554, 0.60922311771773008],
                             [-0.48959175991318127, -0.82956164684746558, 0.07080724626009241, -0.60967768303700909, 0.37565631415004103, -0.099809854937952566, 0.25900965767637729, 0.14293355941050176, -0.10358842035522536, -0.47206693382000764]],
                            [[-0.30610673540897271, -0.64715192815237232, 0.2796474093918806, 0.50790831961073279, 1.0177950371095377, -0.64893233313860654, -0.46027527817272063, 0.96962111766299874, -0.17744886271633883, 0.32195411972765786],
                             [-0.15284278649902946, 1.1680693215259601, -0.53559084800940016, -0.23362344376132632, -0.45442714576925269, 0.21998551711310499, -0.78979994740754855, 0.56960523175213862, -1.1487731810318005, 0.55638144395486644],
                             [-0.36261010421623047, 0.059075051616492388, -0.7969573586228047, -0.85941164439211137, -0.56075363357280406, -0.83162460544220396, 0.20952983571625045, 0.77121653919445821, -0.26660135872770019, -0.17406003881387513],
                             [0.55925917849087459, -0.57148082982635973, 0.18396475648300747, -0.53909950666509687, 0.15712103617099679, 0.72523302837782055, 0.47691092390097434, -0.49862643251989291, -1.0281163104365019, -0.34318098524265928],
                             [0.48973155597668289, 0.78216244922727962, -0.086750725737035433, -0.3375220216583989, 0.95324256009161545, 0.2360530485004223, -0.0997913187886659, -0.671376397678352, 0.024784726762645731, 1.2545355966382687],
                             [0.76069569235486145, -0.56996454266745378, 0.64191646496205212, -0.42877307860678537, -1.0215303247306085, 0.022877976699597319, -1.1695355388444828, -0.34051867181536266, 0.15273018979002037, 0.95847373097493949],
                             [-1.3876320149759345, 0.27378273455316549, 0.74018256752641642, -0.21537573630942528, -0.12410123632038278, -0.22781695261725451, 0.35951720705173262, -0.81082916410722083, -0.55723766472574043, 0.58212311253122206],
                             [0.60196736803924544, 0.744824669356277, 1.3419845707835647, -0.45729194142272966, 0.38311134263050889, -0.022168022894384243, 0.13921367495938974, 0.77082051601536938, 0.23678472457009764, -1.0179526750124286],
                             [0.023537552157489053, 0.4100112065896957, 0.22661210966629017, -0.20922292926122593, -0.25806071538021436, 0.53375202443299341, 0.97506094545843824, 0.052400789350337179, 0.59553946324944418, 1.1655592528052485],
                             [0.67670042405652908, 0.40311508223699244, 0.10144068609133178, 0.68457560505478077, -0.47459097487680718, -1.2438927387353149, 0.90079815329292645, 0.52537749971696324, 0.21175328686421097, -0.47550932056438622]],
                            [[-0.11917697712472619, 0.040381233216317571, 0.88900735345548743, -1.1712976816454752, -0.054823667048116642, 0.14683296448071326, -0.079097467946471545, -0.43398446556164577, -0.11342422822152673, 0.82672050588134094],
                             [0.40584283410744237, -0.22677596012411544, 0.063393069590034934, 0.3265505108050098, 0.74886161811344854, -0.1118832998837178, 0.68392881471647204, -0.28190938512955444, -0.42587125026222716, -0.027190932517903423],
                             [0.44692430460120669, 0.2521322189173541, -0.012229219118574858, -0.3499683589176481, -0.41079380155111755, 0.31479893380968127, 0.79381086871373474, 0.60193889141165491, 0.039393986610163245, 0.11809550763687258],
                             [0.11542499036518489, 0.18177738539069369, -0.28002715004718237, -0.34995050962966634, -0.37371044278382004, -0.77748163228843004, 0.42398916990014401, -0.24419823768831647, -0.78594780868979464, 0.059019141061991715],
                             [-0.47455932582594335, 0.10557633765843616, 0.36756680713954187, 0.29079607240641042, 0.30745598596370288, -0.33684330400091073, -0.36968125065546176, 0.69718971890143955, -0.043920068054511971, 0.43793701616498448],
                             [0.23984808438826541, 0.19302973332615447, -0.53163643823511308, -0.49634075179237452, 0.83353840137484514, -0.11226584229284124, -0.52631236086881839, 0.26397011629412037, -0.055744768358049923, 0.022604843413218112],
                             [0.67837488543329205, -0.25019502425513696, -0.078385177651148955, 0.63804789297229747, -0.27715219680699127, 0.60083970542863008, -0.3836525799953453, 0.035075219550040636, -0.68049772143550491, 0.34647915893478565],
                             [-0.36619316012008907, 1.1427052712566526, 0.082943890296068898, 0.11234143062108118, 0.13288509154409575, 0.28630847772129958, -0.052644406360171939, -0.26123918081351016, -0.48059110830568097, -0.37852689013901025],
                             [0.04875452910592705, 0.71924082486878171, -0.17703768691963095, 0.331748445612427, 0.37628600858624528, -0.076989843592669319, -0.15159182809708083, -0.36617078843393291, 0.96872748254590013, 0.9320926499792086],
                             [0.41571131598260558, 0.63412159042059146, 0.58269226002359398, 0.072666469569088482, 0.075251399591059032, -0.58920623715402265, -0.31835625292429492, -0.05178394455021619, 0.27446540745396802, -0.3497461963535512]],
                            [[1.1712250665928443, -0.19060403363167205, 0.63757977029052892, 0.32326955755795805, -0.30655428505997945, 0.10546083331410513, 0.55365346846692676, -0.35506900652425877, -0.37990362594579924, 0.36300072229658992],
                             [0.074701994660354237, 0.061240866133216075, -0.27435584423020143, -0.36874254219910341, 1.0193192502896646, 0.27227571712502396, 0.11037468474104124, 0.69024402811943419, -0.35630665537605749, 0.52147781964988249],
                             [-0.44843804951369781, -1.0765272291752501, 0.41374183111741847, 0.35095922006625424, 0.62301265786423843, -0.2659709019167058, 0.1481906224941035, 0.27976536139387775, -0.48543008243411878, -0.23991360287122568],
                             [-0.93829883393032854, -0.18572921513101737, -0.47381561221617263, -0.29419523328051655, 0.22434936757761298, 0.47303555435345823, 0.4524562249822553, -1.1052264371710034, -0.52673415343054153, -0.21139155347610672],
                             [-0.65240889951455683, -0.71921505154941334, 1.21771604617039, -0.90093681443292817, 0.062886680621411506, 0.30243233622549415, -0.82985385922159605, 0.67807104576732979, -0.36714141205990397, 1.5185673264267441],
                             [0.0073293939278987093, -0.98536325456344864, -0.33879762605953695, -0.20342445035906856, 0.29946034147777767, 0.81526241598193772, -0.0066522012065208715, -0.1894256545177285, 0.45083613047393545, -0.4393765919913476],
                             [0.3814409333913869, -0.66572999017747714, 0.76714936291741531, -1.0306482013178597, 0.4010957694675843, -0.54119713036068573, 0.41577119253502792, -0.70154290757388083, 0.19364775033001125, -0.56197021464511909],
                             [0.26595215205532197, 1.0247789667993785, 0.92874542047136399, 0.50541330449663968, -0.43235071342127762, 0.47422637194325762, -0.24353140770336063, 0.019937944908079958, -0.24208460596235615, -0.45206727448346334],
                             [0.40131954167779954, 0.32214246053387602, 1.2821573031715865, 0.034575519911096225, -0.93091945919751595, -0.18091279372018129, 1.4795983421107726, 0.40997592257808618, 0.40050436194214661, -0.084976111253079523],
                             [-0.15488981228227444, -0.29727556274649436, 0.46522274744281672, 0.31547344153398577, 0.61410466268333064, -0.14488100171609236, 0.052339101804506433, -0.46869312441307037, 0.56862948728258811, 0.53358678736372367]],
                            [[-0.23893445117014511, -3.919719212109567, -4.0955857127716175, -2.0630917374977513, 4.0815841947345346, -4.1994960904859306, -0.70707193155198422, -1.6468475559576068, -3.082170441333258, 2.847362580213654],
                             [-2.1598106923227758, -4.9456360914421884, -0.95040798089072176, -1.7285876311074078, 1.6297555462721531, 1.7351832387388131, -0.92730858626057711, 3.9158511753010687, -0.1935525034765371, -1.8999117842436934],
                             [-6.3678040021887963, -4.674947795503436, -2.304120166837698, -4.5887190493293692, -2.015674994322211, -0.14071199646189941, 1.0051100336295109, 1.1044471813261012, 5.1555965645232931, -3.27332449200475],
                             [4.3863990780729081, 4.305402846252016, -3.5865931661938699, 0.53322871435593655, -2.6738257453160355, -1.340991304226651, 1.9855576747613477, -4.1633974640081721, -2.5417190610840352, 1.6493019674867448],
                             [-2.148357291639218, 0.25262355647526891, 8.4187236066319038, 3.6367574484967395, 4.8870333983650873, 5.4574065711803961, -1.2928015486460303, 4.9517846057947743, 5.2103161904562176, -4.5907449775966427],
                             [2.1480820349270657, -2.5693324757337219, 3.433262718036687, 0.8739785040335234, 0.31885114317058411, 5.7220565151345077, 1.030273998361839, -1.0146737146696545, -6.2141851659610223, 0.50835146262274655],
                             [-2.4098447933426805, -1.0927398587184725, -3.510130946037235, -1.5238044224729732, -4.5717663288506039, 1.4217150001417878, 5.6599199218921603, -4.1242419297524195, 0.14990133802205982, -1.5431221702352893],
                             [-0.1058256305628705, 1.6789385777101571, 3.5855804212732036, 2.3196027189890662, 2.0805705915963717, 4.5737915408371226, -0.52465553295468881, 3.6182262027460306, -1.3338950579907469, -2.1260147414554411],
                             [-3.1029634652540348, -0.23148094708518044, -1.3187782179399306, -1.1981631478997339, -0.28363159614297717, -1.5051510159038941, 2.0962126856594954, 0.14234431593304331, 3.0683807692987028, -3.7376388605927477],
                             [-2.4998881078430233, 0.94178676566778741, 2.3421553028154625, -0.29962427064050862, 0.40690303163453434, -0.81562225372407249, 1.357168838812191, 0.96460111196379317, 7.0411846187439622, -2.46615759023405]],
                            [[4.1268198035125305, -0.64093354192884866, 4.3452271427030018, 3.9466007968212802, 4.3501177123856145, 2.630596010277253, -1.813373730540369, 0.24346220381757039, -9.5364763574014173, -6.8139067801624211],
                             [-5.7435326018930963, 7.8008947800008244, 6.73051386806653, -0.3257330495009062, 3.6817919041075404, 1.5128031220000202, 2.003438649971526, -3.731726130636229, 1.0225623014970404, 6.5789139354828281],
                             [-10.198906541323474, 6.8516874531501903, 8.1925189963383183, 8.0438771783559844, 7.5517109332281311, -1.2622922006044206, 0.34627183759495983, -5.203213887498209, -6.1189950450466295, 8.9318639206093611],
                             [-4.6402175229344937, 3.2354832400704048, -0.23056339079883459, -6.7250807845653817, -2.6651666704533121, 1.1212429123352761, 2.0748137517827634, -0.043354909231963501, 9.7118425038362801, 7.6854215251673716],
                             [-0.84776123427346972, -2.0952280482717951, -3.5256547204496473, -2.9337702895361026, 0.049078956194720746, -1.2453344276612914, 2.5099273382981298, 2.2797834606426113, 2.8191937996707579, -3.7038800046321194],
                             [-3.9652041905186302, 1.8786371893952689, -1.221808784796075, -8.6068038443419628, -1.2684956443289277, -0.93293010926231601, -0.026069468774179021, 0.3332965133968695, 5.1313512701644042, 0.22027094895379118],
                             [6.3037407679803232, -5.8421245282795224, -0.46761151263221246, 2.6132359121256497, -2.1899467233545589, -1.0392419179043308, -1.1827990955738601, 2.4878400926939386, -2.523915744941323, -4.4072369458677407],
                             [0.19603012334072786, 0.92921151429933957, 1.1254559779159112, 1.5935266391410985, 0.67379735159548748, 1.4295519395931449, -0.29767027036984045, -0.36804241220696399, -2.1340203662458448, -3.151097084434006],
                             [2.6061497962200222, 1.5089732199969861, 4.6927359025247304, -0.13370691588989747, 1.6977325374802237, 1.3476668365697357, -2.5414311481121419, 1.4424070390528101, -3.2449408999507749, 1.2449894016429397],
                             [2.9631045481702079, 2.8108405215049519, 5.6822515445044806, 11.599269859758445, 6.3956468956980075, 2.2985261044109038, -0.74076698928810969, -4.2705572920451429, -6.1562141096641518, -2.1720228831209791]],
                            [[-4.1965115542251903, 2.3272386690925373, 10.412727561499633, 4.5371285144922204, -6.8198916419681312, 12.701805649386657, 13.952343345529531, 9.8453367980610231, -23.911203407125001, 20.810200691477334],
                             [9.3399690351547413, 54.310765062001032, 14.20892520349728, -10.562386917420126, 87.068679883530706, -6.4923206499269801, -19.763558620820213, -24.777368060535018, 7.3094640052541093, 21.476695856200521],
                             [-15.923081404034432, 17.907775083770044, -4.21250381988692, 5.4017505307359261, 35.057951388915576, 7.0415669696550998, -12.258691509346413, 14.573607883729849, 16.312142281087137, 6.5026037375143151],
                             [-9.6538356932874194, -35.637915102750171, -31.595134161499313, 9.2319772074533226, -75.017551233723509, 12.553892542648789, 13.274667794534514, 12.819782398167268, -3.3297147736711454, -6.2236267774636325],
                             [1.8353012968506177, -29.78749565225899, -18.447607197081922, -0.38641651903423402, -61.098269872704641, 15.02382027465711, 23.80503570873805, -2.5172673429101144, -18.595446551828719, -1.0477349270923098],
                             [-8.8878981304271107, -3.0021349663202805, 14.162947540443227, 2.8852237589541296, 15.025975950367901, 5.4586394841648991, 3.7641600154713251, 11.522449607629419, 0.55697757236379575, -2.5173944493155864],
                             [18.938579020097166, 14.397394202871844, 9.3894041786750133, -11.76327359755825, 25.608632142074633, -20.231408420254322, -13.988474213417959, -22.345803535127402, 4.1725235501350912, -7.0895437085753148],
                             [-3.9594581870685275, 5.9498455571153048, -5.3835091627532705, 1.1961224801188646, 1.2329541748874475, -5.319380405660902, -8.2224899786329324, 4.7239816153646617, 4.5104663378348775, -0.13795889604611711],
                             [-1.7616780689765417, -20.083458610432043, -15.388088510755868, 11.044747926073256, -96.427455571556351, 0.93302178312036244, 18.945461731593536, 18.766262390169068, -40.554176679205462, 11.484548031363577],
                             [-6.4171539853090076, 18.743398587614177, -30.276482758949449, 6.4486536150097642, -11.8883540168233, -10.194996931977409, -17.431990889305009, 0.47651710323654317, 8.8758189020471683, 5.3077064222029211]],
                            [[63.55511024993983, -6.2290894401347661, 17.90985157236349, -20.016765762514641, 37.786968723853583, -7.3557249956783615, 45.893242660920478, 4.692090747160913, 55.139741173447241, 10.082259525065094],
                             [44.553673805884287, -14.551019829025311, 50.597038921814374, -23.939345341155153, 45.485235810775855, 44.480861027563876, -25.161373584987388, -57.191176544100799, 39.644987628825653, -70.534023440821073],
                             [-3.7589269110239751, -1.6835741176034928, 35.512033666616183, -0.62349984005051962, 8.7111534978910754, 10.292191227592944, -26.332371102687443, -35.642638057918219, -3.5299403007189247, -57.58754695037365],
                             [-41.571976953688633, 62.660043668966679, -39.471176423921023, -31.22834636987163, 46.687107060680887, -46.168639368171362, -5.1359292345482306, -26.875372010573955, -36.038214584751486, -1.1512432786580185],
                             [-101.70617538625612, 37.895249502514055, -46.169239781759565, -26.864480579594826, 2.6731607064790524, -47.384694446841152, -71.920250708031958, -43.805736587268676, -70.312606806348114, -23.566001798806081],
                             [72.651702566798576, -17.424086353538794, 20.103350239713457, 8.3360411954943832, 59.903443693109423, -24.41395814391857, 41.017037179401768, 37.229610781751099, 20.099236852702788, -39.675040838416209],
                             [-9.9843464105167907, 0.42172281820593849, 15.071825852000133, -7.1186526843925311, 31.158689300793554, 13.469296349573499, -20.327076488874997, -28.957952556263404, -1.928154475266203, -25.498408555319362],
                             [-109.09639204617613, 17.539576791062377, 8.9350434625717909, 10.038367194649656, -85.715612522519493, 23.434564910073554, -106.49588700159767, -61.81294243050732, -69.354954636288426, -26.167642307558435],
                             [-22.445032318464669, 33.725388882821889, -42.193627922729775, -49.223757223883744, -25.279656887406645, 52.810619838052915, -27.679144374822343, -63.612630101324456, 14.077411505659601, 30.329290795227859],
                             [25.843992670615052, -12.630987225021427, 64.086182691640573, -18.017066329392254, 15.984460509410761, 49.342518346390648, -43.498116523221697, -70.300321097189027, 25.283017096502199, -97.566066234218013]]])

    matrices30D = np.array([[[0.35116203210049141, -0.06045753395784325, 0.16026956318019106, 0.28221027312228308, -0.32385008163707418, -0.11838947239859268, -0.040039816799057382, 0.083517277935222567, -0.2352155234662657, -0.018334985150991707, 0.19508867764523063, 0.071210406948663318, -0.10437983425344313, 0.068147958051960111, -0.3412355159431224, -0.3169248777596444, -0.19561607342302298, 0.054409810626265376, 0.050099741210312951, -0.14802337315185271, -0.08613925999700893, -0.65451113020940332, 0.3158830324718781, 0.024035278102958031, -0.4829322207828799, -0.17946121548704658, 0.074127792885032046, -0.15819606903543149, -0.49638577066737327, -0.23075257469034377],
                             [-0.095972684292925242, 0.15418946616434132, -0.31622133171357653, 0.157335963514069, 0.47749631002220455, -0.044238952748168255, 0.38887323179704608, -0.40462952877336011, 0.031233297401457975, -0.063947170031733558, -0.047564097395452948, -0.11948393117120593, -0.07824798406351427, 0.24646206544365498, -0.56067437144939003, -0.092276247628096969, 0.24445768161676182, -0.17158759329178502, 0.083474289300220217, 0.23272403137415762, -0.6102684761612438, 0.34205909025991837, 0.095101371877853599, 0.15623103835630681, -0.14510341211788225, -0.21855169639533631, 0.18164954958317903, -0.40861520538188406, -0.037161216774747693, -0.36396394398026582],
                             [0.036206859062019203, -0.1633411666982798, 0.26657266650344613, -0.17831457697975789, 0.41467197180703658, 0.34343302712276941, 0.15406466688361148, 0.30402224160923935, 0.47493510919528148, 0.17677263003512259, 0.0098969015635324911, -0.1719142649552014, -0.59090813472474157, 0.47996056162338324, 0.20659469380258821, 0.31958748797946795, 0.21358297593311376, 0.57091855328327956, -0.0088864509108538998, -0.14710929578411105, -0.052838922938856545, -0.15111527900214433, -0.23564458577902714, -0.49174664007649871, -0.67574301992890973, 0.063971075665107874, 0.087965923197133061, 0.22848523333342194, 0.17458942345037623, -0.23122969882917982],
                             [0.23728065381733288, 0.25349302463110468, 0.1752951323205002, 0.0052708720558104364, 0.20307134056177487, 0.15308330320102287, 0.45287017977467925, 0.14115935003515742, -0.19859632466898972, 0.21203551618698557, 0.41736493429216981, -0.025607473759144732, -0.17445114193980243, -0.23468881191552476, -0.52388741728852961, 0.051940200591623097, 0.096452280983626973, 0.14631344251610012, -0.052646598706082903, -0.12333465484859688, -0.19339258068358847, 0.20768947173073507, -0.2767660903609962, -0.059074382310757942, 0.29058275098563585, 0.15700146649608243, -0.32983870438176738, -0.055417676122039489, -0.25611281316880102, 0.27741330016480348],
                             [0.09733327597189731, -0.48667714591403211, 0.54385143271664704, 0.051872471983413153, 0.1341727510577477, -0.13352216253883453, -0.24613793803442718, 0.17589120112818005, -0.4159209179729555, 0.12992158517003688, -0.14750497710601129, 0.66644053285775195, -0.016908143776490567, 0.44565941861694314, 0.17438792983764179, -0.33119005140038354, -0.2028988181972218, 0.02695862218144977, -0.11463563834455238, -0.13626447629916622, -0.070470940017422865, 0.38574539875256852, -0.04640648564152846, -0.1826929327110127, -0.0095089443171670444, 0.0047328413675426922, 0.18813889410750975, -0.22011110061690406, -0.03719401758005926, -0.44571928622555096],
                             [0.18701443858692585, -0.33817870581292769, 0.093094386306148164, -0.51274186244247455, -0.073395581293902917, -0.15478362422180431, -0.44944022951654661, -0.15276061707991692, -0.077366515349969592, 0.34179521339692426, 0.087465949124595876, 0.10742891356646124, 0.54796417480543669, -0.14098873479796592, -0.0084864268893217673, 0.4875202987459083, 0.47620607730821118, -0.11419387184771598, -0.46261959964626687, 0.28317895487206834, -0.56009487463278984, -0.23252841808944136, -0.10579330573838513, 0.040337615504682081, -0.16512590420235701, 0.0048043092114959801, -0.13691987421253873, 0.0086693664672044812, 0.10029875360605611, 0.023825048451457512],
                             [0.32251448413638761, 0.3507595834135247, 0.17455039557646795, -0.14944477045246324, -0.11694773442481432, 0.13608027921932009, -0.12230080027733448, 0.014164174806704396, -0.0024512952903508467, -0.31110144927099964, 0.43577916575477915, -0.49287900080032254, -0.12359512037662612, -0.22747186298806699, 0.28197628410292974, -0.28623106840701368, 0.38199487046955033, -0.50358309780010657, -0.12834864858925848, -0.15650393602491341, 0.04237393853286249, 0.10122219339948366, -0.24067512736328239, 0.12827665826956269, -0.005653429717122592, -0.32079059884060046, 0.18696322395037221, -0.12059496407317113, 0.038628414250244159, -0.22394277750884883],
                             [0.084721266556815847, -0.10908613867717108, 0.1716735291389061, 0.06737554518577174, -0.018585802327585048, 0.18531310989220218, 0.22730443446751519, 0.4217875910462065, 0.19949104838388074, -0.080238445529772245, 0.14114035220640359, -0.076568782035004834, 0.32378418715958612, 0.054135928058692322, -0.24944672377138094, 0.26064393763449611, -0.04359044242528172, 0.46067179312520379, 0.35065173797955262, 0.46805725323853731, 0.37664097757851961, -0.18362559333387668, -0.122571742141504, -0.47472514871031135, 0.31112335592948465, -0.61362511745866166, 0.40657359794458287, -0.14581501371126343, -0.02877950353191136, -0.2025125624510109],
                             [0.32316934588245133, -0.22158518478355596, 0.16069523694909374, 0.69506822259720547, -0.07201310099352401, 0.0058453664151714001, 0.28154107008880158, 0.067122227611401547, 0.24814365416648287, -0.095910165662036029, 0.20564234106634116, 0.088057479421825777, 0.26134113146578813, -0.47570032471464463, 0.17688373428330101, 0.083680374950868303, -0.019996020268072005, -0.084295357463269799, -0.48300395729544537, -0.21793411198268497, -0.12163997735637956, -0.27305812818177966, 0.28199579429423616, 0.086172804783215498, 0.14898800371229484, -0.21212305647810545, -0.0088800973377707957, -0.26592082012430729, 0.62087809689820939, 0.34021774305061458],
                             [-0.049020992955436958, 0.023632272031570541, -0.20677743271065616, -0.066865778039092827, 0.15404099986538236, 0.47395686649043806, 0.099065663193510359, 0.51439760794376255, 0.21316436645978931, 0.055702227597420877, -0.42333132293444947, 0.21170121884252346, -0.037476737234077614, -0.005892656952953497, 0.055023639719058444, -0.024239249013000799, 0.49263289092791318, -0.076954509427057866, -0.73809169171239331, 0.48989073083118045, 0.023024597972323087, 0.14018726897705003, -0.030929461260945885, 0.23247698135708461, -0.15654234457514538, 0.049259678811001462, 0.25890624513552468, 0.18195719724606008, -0.4075534791016302, 0.47590789829198388],
                             [0.49745023289177637, -0.015805869385496621, 0.18980804155616321, -0.036946143547576187, -0.23404420201645487, -0.53033152671583916, 0.13602932713892552, 0.23378623401428802, 0.048020983646281032, -0.54141957387895434, -0.12965743234529903, 0.044080601295983263, -0.46504150038367165, 0.0059421848217252465, 0.46912706755729583, 0.17500335547136647, 0.087558811997629077, 0.099151332106596546, -0.0058359106302581613, 0.39140478787538602, -0.41473159384192237, 0.041669777503821469, 0.055196044909805897, 0.054359539701967163, 0.032883785967385948, 0.12295846274466588, -0.25430330924784461, -0.028906775652144667, 0.032038455656777189, 0.041981509868593447],
                             [-0.51092875858027753, 0.12227014724096513, 0.43305156279307505, -0.36550411360805846, 0.36013973502300867, -0.15508049188031736, -0.29542459221962108, 0.095662643296856614, -0.28164425440863006, 0.22908595411543525, 0.25730559244164747, 0.097841753035794093, -0.13111830274815808, 0.18776744832984171, 0.096124926593566182, 0.21435563984292388, 0.15347398707686025, -0.087750789555754632, 0.08461799831138371, 0.062957137644809688, 0.24168922534607598, -0.094479598901364203, 0.31429562976087838, 0.36327089568843207, -0.084568144820621111, -0.1250567950781272, -0.29140282651852839, -0.385887105643127, 0.016973010016360097, 0.29355586449831256],
                             [0.053869987245630052, -0.2364291921557781, 0.10509721348451612, -0.085178384110178557, -0.23956066318375568, 0.010390287999880114, 0.67122007254080085, -0.34219018107693955, -0.73086689327534338, -0.074113697680981763, -0.15585857098513017, -0.35423546056249755, 0.23620323310750696, 0.22813100879522619, 0.20000835210375867, -0.097223606948581967, 0.08479818146628508, 0.41620043943610951, -0.19684328188943193, -0.11431039790171114, -0.0034271482239574521, 0.15994783445736688, 0.18414863599609405, 0.289739296027264, 0.033215241517002086, -0.068667483428786272, 0.24253603086520886, 0.17435105297024808, -0.21526256725453136, 0.14468117702464275],
                             [0.14993846340794631, -0.12008545421489147, 0.53164631006136098, 0.42730546674784869, 0.5450014251790285, 0.19786723770675507, -0.0018477261560278036, -0.20921599524137205, 0.1320275958908731, -0.33182407681904608, -0.19908938615560423, -0.051373548753948145, 0.36094664885953309, 0.19633546518735734, -0.29065785132034799, -0.18214609881780378, 0.018223950979227004, -0.29719121471378884, -0.14751362238214019, 0.24617083534805329, 0.08390018276094105, -0.3936971968475354, -0.058841624496673392, -0.1494166208965779, 0.26573969174410206, 0.11573176867239066, -0.45742949176232156, 0.32134777739336812, 0.15414329435172153, 0.12633143264146651],
                             [0.28932882132650717, 0.23560942350869243, 0.63754791128529698, 0.46671725712552242, -0.18959090743425464, -0.14065228986227069, -0.26685558706980356, -0.47785213044642971, 0.46726970510277882, 0.26624326755212302, 0.063386707927033867, -0.15827996408907224, -0.26279595134741868, 0.25278811630333764, -0.06739857689454079, -0.13215196998466169, -0.061976766165559923, 0.32047760739431286, 0.11331209165262113, 0.039908300003858241, -0.23316493018572926, 0.31299974862760593, -0.05034309806369857, -0.0039969559009458422, 0.054290624336678861, -0.34039381953588277, 0.27101565637066172, 0.30854160511027523, -0.32331574832011833, 0.18324478572696878],
                             [-0.20506328332210788, 0.14522588734518704, -0.007735146538217743, -0.039174895651921227, -0.080368885627274816, -0.016073641883276035, 0.038917446412657472, 0.29580591079589963, 0.14493917310292542, 0.37364591820112991, 0.34796308881804761, -0.2593633874099126, 0.042284667972748616, -0.086451183237776591, 0.39471774074904958, -0.34849257947520179, -0.13812764012224352, 0.18236456800207276, 0.19008151247986294, 0.42627810456020387, -0.45193233498877028, -0.12278876359436419, -0.25163312538291538, 0.70931123815827957, -0.10946545902516369, 0.19793562838001272, -0.12093701361655708, 0.13786765596646366, 0.35255872973372321, -0.36207542886023097],
                             [-0.2289030345924504, 0.41045641545435269, 0.1391888951110411, -0.21946682345969029, 0.33431159219535711, -0.4355873108886561, 0.12346378684019417, -0.087638361842480958, 0.17173527634263611, -0.35904520179043026, 0.079142695748638955, 0.24012924635525887, 0.19418725459522501, -0.32508513085593521, 0.0012460775304953819, 0.29669840973412404, -0.21568101415936153, -0.014504926807815344, -0.13733470803368467, -0.27349363185374992, 0.18746946983852977, 0.094454006189641296, -0.17224254061463301, 0.42111710414425924, -0.27505071563662381, 0.17513381137659778, 0.57873814840271898, 0.23427670690052413, -0.14869595106957156, -0.41790415470655229],
                             [0.38570338851766339, -0.018922195439423375, -0.26192744028796955, 0.29797229361886851, 0.017245099161149555, -0.34290799044738229, -0.34750112622102097, 0.45750084553063813, -0.048202340500562185, 0.022659275117184595, -0.2467777414159785, -0.41298678459321925, 0.038716062351942575, 0.10423757628978089, -0.49841991567964439, -0.13332875286115015, 0.20143292885527223, 0.10056980394721599, 0.16516102377123104, -0.43919524603011872, 0.39410528064210232, -0.052608777301515829, -0.25336768325426323, 0.24823328709180664, -0.068114508695448883, 0.18951744799970408, 0.13502055510802574, -0.13806787420390407, 0.24951581573666706, 0.24525012403066271],
                             [0.22597750216449336, 0.15399633160951379, 0.03778621264135823, -0.29072765100303682, -0.45407145220902173, -0.089992514483136415, 0.18695392394484031, 0.19173596009898924, 0.51864538614090316, 0.11921492860326469, 0.10670645773872039, 0.14460711529265635, 0.0091568967899075537, 0.11710639748856315, -0.049083268843372385, -0.24711621698424976, 0.16460397179478212, 0.032721220586860042, 0.060566195756710253, -0.1547209652659064, 0.2901984278714847, 0.36114715452518237, 0.43364090152955798, 0.065490759969439621, -0.11603886379749528, -0.45986663416780565, -0.56265238053945799, 0.34405025113133814, 0.36574197029397448, -0.28398146426979448],
                             [-0.23651323883141923, -0.095314014729261112, -0.067069863865587498, 0.34333233174285688, -0.034166464895134259, 0.15141426678659767, -0.068123639627327814, 0.010578800994724299, 0.048150541125327712, 0.030003426476217579, -0.047536222884567686, -0.1370739769444608, -0.088811281992967839, 0.39044730155023755, -0.053123001611014381, 0.47890676361625678, -0.061805026167648179, 0.041698699427676109, -0.42517081735995288, -0.21576921245256048, 0.24088248418384381, -0.013508006608091325, -0.22149936788238789, 0.22563040466834172, 0.29228730962370397, -0.11577222431084565, -0.39424286615631476, -0.16705254352775845, -0.40916825756206709, -0.38343452183563914],
                             [-0.089114617142192903, -0.43205823885680755, -0.38884375459508991, -0.13159682971940428, 0.25008175011966827, -0.15223314973680099, -0.086058613892898886, 0.24290334139147934, -0.1643521458166628, -0.25223492962547334, 0.26703505319707849, 0.21156799891440362, -0.17439030190244734, -0.065101524834478702, 0.013129392639135803, -0.13462547579085621, -0.0035131092737977626, 0.16980597412264989, 0.053540233431446552, -0.30560631853749232, -0.24508937164732633, 0.024283025830348408, -0.30889503054586626, 0.13114224932429219, 0.28852028055977674, -0.79402751977605768, 0.021205299592522334, 0.53548172416746664, -0.21638294912309036, 0.13046482945061863],
                             [-0.32878262656331114, 0.027863248700326013, -0.0889066562490618, -0.22393299391308297, -0.38945897597404588, -0.043782111001484277, 0.057614702873622109, -0.10458400799195003, -0.0010634647640340375, 0.0087687328876253495, 0.038171404422887675, 0.28050738673591286, -0.18331971978944828, 0.1952581536062874, -0.32028514877874131, -0.14065964756163724, 0.19673646494391733, 0.21974858421238436, -0.22240099119448145, -0.10590742465473617, 0.19342118865011412, -0.51529499709792104, 0.0051020906947702588, -0.029681234969742017, 0.69395189165895854, 0.09615066707612667, 0.4729732662180785, -0.14067731150895268, 0.31463390391186913, 0.031214509639850133],
                             [-0.26709686502709029, -0.26279111814832612, 0.33737516003141249, -0.27553999005308449, -0.13207848329981181, -0.12633625793501407, 0.16232465286096062, 0.23790750994911514, 0.0098829653367092027, 0.015092238947703569, -0.88594688077423656, 0.042011546545703063, -0.10495801757825746, -0.61560913065625089, -0.08773172307004215, -0.11204861412350654, -0.15438080513593222, 0.086270624286297962, -0.069864006452617505, -0.18829986439854032, -0.12262390529696204, -0.16592963859474302, -0.30548752255310024, -0.0035355975908537493, 0.04239281254355886, -0.38123724356236666, -0.0094370532411030064, -0.54083636143044467, 0.0077503870649796511, -0.062561984042734359],
                             [-0.27027571734329725, 0.088803914447569909, -0.052366901239405683, -0.012120333002592354, -0.38076269135048724, -0.36904272078147865, 0.095096423786638948, 0.060765818292579168, -0.045497373618399686, -0.19395491289142675, 0.12644597956489009, -0.11994587637054815, 0.0059252069528150375, 0.30574934230511547, -0.13599342407972931, -0.33203103415256185, -0.45301204427180808, 0.18036074149905304, -0.63924995935421225, 0.33731054344385364, -0.078671539757767264, 0.14777215688742185, -0.34199018788667823, -0.38801629915268671, -0.43711277766980444, -0.073048349095520465, 0.055926494827166107, -0.14447832664446739, 0.19326052688355466, 0.28031431412353469],
                             [0.056868767310548657, 0.50548551132993702, -0.12720814550343537, 0.48812380669436994, -0.06489969887800956, -0.30437484283188065, -0.13033249299318564, -0.072505736208653804, -0.47088337611964076, 0.086406585875494324, -0.24556769976250292, 0.26743479062693382, -0.060386287988914267, -0.18061133445326893, 0.4907407564501487, -0.056072700779855725, 0.55216048695079434, 0.065245035562068038, -0.23291852789905385, 0.15700108819102471, -0.056170834780977057, -0.22801961291686113, -0.13931022251685099, -0.44304877745152188, -0.029624279650990175, -0.4404338494393778, -0.079245917624867657, 0.3691098999153386, 0.15205790518525505, -0.22726109285678703],
                             [-0.29425870273905663, -0.32759329787700042, 0.067136707783997565, 0.039360245942387004, 0.15576613242280918, -0.35297829307389034, 0.33715624960931634, 0.021192360799913261, 0.5243094563290176, 0.16605696617089644, 0.36283549966420658, -0.042680721568209207, 0.241268007794051, 0.14056711922501652, 0.30463384969930252, -0.17652060312958992, 0.43705092125630718, 0.14465944608214709, 0.24797780976410924, -0.11111063067719006, 0.19567889987890133, -0.13513021969543051, -0.40732251831938815, -0.13548955310874455, -0.07846675512166687, 0.52813331954507248, -0.12737581720773863, -0.30853780295250682, -0.39905617692113465, 0.2307599099929282],
                             [-0.24234093356700831, -0.45848642999809358, 0.34508595873525055, 0.62976508557775879, -0.19336638924611399, 0.13080368333965653, -0.068857444376229676, -0.29847306740024582, -0.077182531785685501, -0.38442320911039368, 0.046571961351630775, 0.05830604534010559, -0.29596421818106355, -0.47447957762441928, -0.33918667615080411, 0.12432368584765398, 0.24603850703081789, 0.0044615402520085112, 0.30787966195085914, 0.40009176407973834, 0.12922912684872945, 0.049204070586048865, -0.2248521187029196, 0.1906256169211108, -0.31080911327930366, 0.28181841845796396, 0.063254949908223723, -0.04980095150278778, 0.19682206228075994, -0.13148377888987631],
                             [0.23410000402143818, 0.29571050821934419, -0.087116832291713936, -0.033722835215919303, -0.028285558672989833, 0.49692199449070107, 0.12271509575623628, -0.17139410765491261, -0.25069657294739917, -0.092332473270026139, -0.13236408705754418, 0.63993992558935098, 0.12657812097914797, 0.3613771230067615, 0.25666091411294378, 0.22044572461220555, 0.17985537771071194, -0.10407781858433843, 0.38508360735785963, 0.098496302848036094, -0.060049281950092598, -0.19445882969523243, -0.54160697745409692, 0.2696294750010641, -0.26131955776852783, -0.12429559687042484, -0.095572578595773075, -0.19604160460201847, 0.08444569577866079, 0.29627256006307306],
                             [0.29063124486942116, 0.12750084284152513, -0.3554759688468313, -0.19911266353810991, 0.29953108859746191, 0.20634128788103787, -0.44399093052304683, -0.11980378066965737, 0.14045171960896577, -0.29192887106268439, 0.17511969100348826, -0.08632513061980171, 0.11024308412337279, -0.13663337528803135, -0.056797047583284105, -0.22495528948925608, 0.0052738836772039839, 0.7818480707279184, -0.26568615799795547, 0.066158513466829494, 0.18843119094788213, 0.0061065361353695603, -0.017771298337981318, 0.073807368241774154, 0.11098120698420071, -0.11889864494645007, -0.24485135945636968, -0.30243045647905059, -0.19635142069285694, 0.053049065719685262],
                             [0.65444158693264076, -0.1308721890382015, -0.11962851916947231, -0.30318273003213952, 0.17856624027919477, -0.32696358960633753, 0.42046490737759867, -0.4196330000160427, 0.11676234050608827, 0.77726333585023422, -0.053997836685640677, -0.20102931371229199, -0.28147161931600589, 0.0013494017027574634, 0.13090439685723335, -0.20359732226204047, -0.20844094553656387, -0.26401144978360408, -0.32986764606506702, 0.3227976338007757, 0.50521972836194617, -0.19829633224356641, -0.22322632379638641, 0.15536139101833646, 0.073919405959581866, -0.081390404208631459, 0.008830647795729285, -0.003563147427096236, -0.045821519440220074, 0.099244583061602248]],
                            [[-0.28634846057383873, 0.17062510537497627, 0.051389531127592161, 0.28791506732013811, -0.12958201901489352, 0.44441424261146717, -0.094125955587701177, 0.63461042637838105, -0.30357784262779475, 0.08727483233031133, 0.067025925574941608, -0.35540536154538294, 0.29163881095083272, 0.41651136947838935, 0.15081449517777223, 0.64753685383363802, 0.10735370862024379, -0.66745197198587669, 0.1879715054826594, -0.49718860572652013, 0.24871858829813012, 0.29742685773128552, 0.78907499982506157, -0.47347660554596571, 0.50484448457051867, 0.091131256132178609, 0.22110855421485445, -0.44900124357275795, 0.092648239323442252, 0.002271301822346812],
                             [-0.30939247925490454, 0.45678102580697222, 0.26942360856891689, 0.099842168034040002, -0.11761453704728644, 0.83891567840548065, 0.0069847659940748073, 0.23752776258755762, 0.23611599922202509, -0.67737054358044357, -0.87916036067105763, 0.099335856363176142, 0.3056585669160089, -0.49306197088867743, -0.10286047408359371, -0.04050356633005614, -0.83859021779499088, 0.73781595098450314, -0.63029853787237367, 0.46980921186384839, -0.12209953362422311, -0.040588500346028171, 0.26984897671430036, -0.25869376488341678, 0.40555381469133145, 0.095718223994129686, 0.64196039928516158, 0.082095274806893603, -0.081652762248087596, -0.14267020187409285],
                             [0.24291069329922815, 0.47625942581476599, -0.25412452644534633, -0.51636172615079201, 0.28057339830924538, -0.056289497233361969, -0.057103977927310701, -0.025046589142914889, 0.62747568226348016, 0.033646018803861935, -0.19317568219653281, -0.49138319519670143, 0.34086788317098726, 0.15975478150542785, 0.3431867520689198, -0.48132874186032509, 0.24858613176808253, -0.24841218936522652, 0.18017751022082754, 0.46843603107275922, 0.52827843728570822, 0.51504560302860702, -0.37246055104305614, 0.69922618726930275, -0.28322032573527028, 0.49420387255785803, 0.10251038975583374, 0.22668659058986562, 0.72659228310092283, 0.48293092253729653],
                             [0.23756155481493488, 0.0096289220863958833, -0.58529111948129509, 0.29862003144918625, -0.017267273675516764, -0.0020052732451290743, -0.33017733495537743, -0.35447431185667577, -0.19200089498999595, -0.13561029492906182, -0.38252920754212344, 0.77881970586589655, -0.22150284455816807, -0.24425173655651705, -0.57772799558162213, 0.4410228194913991, -0.2453147915975151, -0.24896909064181419, -0.025695830096661199, 0.18866703425955966, -0.14665062000790985, 0.25321889311470736, -0.16876808528512541, 0.00039137718765289977, 0.14132305921228822, -0.051357969471283037, -0.14188041865392581, -0.077978988052369871, 1.2149786586043345, 0.34465262871896929],
                             [-0.01945302403229774, -0.31247689102224119, -0.44258795019134523, -0.066921260587429976, 0.2939863865504434, 0.0031754904521049498, 0.04482567118358196, 0.13768189377303694, 0.25714855197221187, -0.35759813174839844, 0.79870193987070759, 0.50236411855696539, 0.076231452865473684, 0.58538052073864499, 0.50105005616237919, -0.45262848334599587, -0.31876259164626386, -0.61761322879821756, 0.17473712142515815, 0.13857562790723119, -0.12997599125691695, 0.058844966150047848, -0.9186158574498241, -0.58806439282492806, 0.30937306044603191, 0.12976882882506177, 0.11994309120032184, 0.53832698625030417, 0.14626401955015839, -0.51040973117713495],
                             [-0.23153913991499572, -0.01172346730892819, -0.42130058649068025, 0.27033178835000293, 0.010416647071576995, 0.1549053092299022, 0.26650137462145679, 0.36752410392496981, -0.300973989991911, 0.46246545816443613, -0.49663385727304438, -0.10437521179357609, -0.024677554546439842, -0.30976472651081605, 0.33001834616250436, -0.7835357854894075, 0.46489649228443125, -0.1586318764113242, -0.29880286645351045, -0.63618351376732474, -0.36614256558356262, -0.70193374137184306, -0.16892214193773056, -0.031655265868178212, 0.10107593431660562, 0.038974315535924592, 0.037538438868348921, 0.27446466913244005, 0.3359889322604333, 0.43139755711398964],
                             [0.026083908473793823, -0.31178612977410214, -0.46970790642450033, 0.51228909132938238, -0.13019751168657867, 0.39022521790065134, 0.14774941209781878, -0.33411767746798088, 0.40859716767642551, 0.24112582277729933, 0.03893719796777248, 0.66640246331342545, 0.68508614531749701, -0.097687710078369155, 0.46842437682831384, -0.52998338506693476, 0.79389640053357402, 0.13429562294466812, -0.36169415646146913, 0.40403492467098867, 0.48226959041526701, 0.17202673669656549, 0.19588359293187446, -0.1260210796968321, -0.38848416582110429, -0.037689079275357452, 0.22282897971166563, -0.20822337372714295, -0.72503790606686724, -0.10968013408515068],
                             [0.16572583569581134, 0.5814635789909639, 0.30243867825547233, 0.076041381255520984, -0.27848670268042969, 0.1946013244179183, 0.51855109543106503, -0.15298446674565089, -0.43975743099529563, -0.0098692024987097476, -0.42530199866131407, 0.53486257799581416, 0.26863757337252775, 0.50964902200285722, 0.43817571826296864, 0.11631617546317763, 0.40657773114406287, -0.42426807533123045, 0.31712780357952619, 0.17770888035978266, -0.070510389838192217, -0.5213501157844378, 0.016704875038110543, 0.79283577644336312, 0.50425622210719068, 0.16297625918196157, -0.51073568751698917, -0.19240594960749613, 0.049793748353219078, -0.69489185469674275],
                             [0.37738142816862674, 0.30763036489752527, -0.0088500119140903014, -0.1326685357444356, -0.49818988864230385, -0.44409993232120015, 0.11512158445423698, 0.16820794819225601, 0.58186955273373853, 0.32469619078578227, 0.24022938475514574, 0.55881112202123651, 0.45321945459499746, 0.91522442131786419, 0.37332719019085997, 0.095277035126700993, -0.086430375766066311, -0.31761315299020881, -0.036756521396123433, -0.55945363799130421, -0.30949419949351792, -0.14061030680364683, 0.63374902807748623, -0.11010708648801988, -0.31417805554229866, 0.25025842484873867, 0.42715087090581294, 0.083392565486265738, -0.45238012392470534, 0.045852058990881753],
                             [0.15015477216694012, 0.39889813323458245, 0.61139412169828422, 0.30850737791997124, 0.47395232144696703, 0.60344311741695689, 0.068614488208942476, -0.083930173058705163, 0.94798730918659291, -0.52073572256208078, 0.4274614382891182, 0.03296934837210936, -0.032760091033832095, 0.051578959389969335, 0.082416933297689371, -0.53079421119834558, 0.20050922129779564, 0.46130548341260991, -0.032568619920676223, -0.26644406415236749, -0.43153690187454624, -0.17217266456331515, -0.091355686410373046, -0.36255120487618181, -0.69186093826111117, -0.024410665379007712, 0.22768526108190099, -0.50157496548551883, 0.76086338576286994, 0.22362610899841517],
                             [-0.41099792818715808, 0.72952883057281104, -0.24790684080351805, 0.20047357959374729, 0.36721605039648308, -0.040527951982765625, -0.65443095357555303, 0.3397118408308723, 0.66553220174460215, 0.31606521408331145, -0.0090595025030611558, 0.1030384585394416, -0.45572056846093023, -0.31939375169495304, 0.27329443060233055, 0.20570202651341549, 0.40523081124301308, 0.15906589065142768, 0.63548052667725974, 0.044273615186793777, 0.090422928327973537, 0.12837393223533722, 0.29299300420712249, -0.38184024045702308, -0.14052087386194734, -0.23058278628479589, -0.1833315421376133, 0.71717212253010354, -0.19481820111057738, -0.1282673026055387],
                             [0.77439853743182219, 0.24452882003269996, -0.43496143753721506, -0.23542650591157444, 0.28007933146663844, -0.044717999328256978, -0.02744605559784687, -0.44836570735590142, -0.13490087752625118, -0.53089894384591441, -0.052731661396958798, -0.21164808468284707, 0.030063593465813332, -0.10239643013369766, -0.02179963909357055, -0.36965183833849002, -0.19089412539547779, -0.49798346670372928, -0.396339875494153, -0.25699870839073946, -0.36394309905764555, -0.0015990964516537087, 0.1926133406745878, -0.20550760452193573, 0.2525297214274364, -0.16983049033718095, -0.081502423176062114, -0.29109230066448494, -0.74859186301082237, 0.48708306981543104],
                             [-0.17628011985023534, 0.14725715784363691, -0.47573110724998402, 0.054463124210982782, -0.35119584044644708, 0.31539022672905898, 0.57666712285650545, 0.21224566292397348, 0.22837108994253763, 0.1602035141438071, 0.46534565304364978, 0.19891603819047901, 0.30836090455956139, -0.026846996047513488, -0.95433933592378684, -0.066025343905198375, -0.4107202651698032, 0.11661045382537538, 0.5319768398443302, 0.17631905809909817, -0.44668109458561889, 0.13184816386464152, -0.049923479568521847, 0.4643733871975626, 0.240675149436337, -0.70020491009093, -0.092866037481393229, 0.37133614463267672, 0.44210155592226935, 0.52397211474533933],
                             [0.90393954729519288, -0.089602917006355504, -0.4721770520481392, -0.47185604021470606, -0.041966074628539629, 0.50718369830043442, -0.56536509472732532, -0.13926357792895194, -0.48635869381090913, 0.42918797398341102, 0.89373248811500527, -0.13597771025363103, 0.032035661427632964, -0.26135722031517694, -0.097342515648416644, -0.053624967857416883, -0.47269830574837784, 0.14534651403475474, -0.064053107385199565, 0.088617061823801163, 0.34031492293767801, -0.54069961527727961, -0.10089504230661056, -0.34429261843875542, 0.18320297817086517, 0.1516664284313029, -0.17142151419676391, 0.067373239093580339, 0.55942400081365407, -0.051524227560582808],
                             [-0.47046718783165398, 0.15082044760335933, -0.33605590651103201, -0.029458764811024336, -0.35206628107385707, -0.054920257314963077, 0.048488634810677757, 0.0041899818049344045, -0.027563798517656654, 0.42713243851840532, 0.23485320354227768, 0.057790476260268571, -0.14951306779640672, 0.22045993894908353, 0.90821284021823978, -0.23503532864306192, -0.44073241854096645, -0.10846376270755793, 0.038644127688030494, -0.19568519024585568, 0.308396754671517, 0.16634157055591364, -0.075495102750340201, -0.05277403303502963, -0.73461185532307549, -0.65216363073748951, -0.61372950328812093, -0.48129994390890735, 0.18556082589940562, 0.18682686395130776],
                             [-0.11919303075293186, -0.67425486409596658, -0.10529350056452766, -0.39600846210718138, 0.12757417043583927, 0.86793711955316244, -0.096487719476582079, -0.11717872200937497, 0.35029192942117671, 0.31904445276144605, -0.022486100998405749, -0.016834483259195593, -0.66319609833719562, 0.5586229342184178, -0.26412234836022519, -0.18712063716676869, -0.035740809522516223, -0.20221984586976338, -0.44059702545799123, -0.16251532272865868, 0.043526088729972372, 0.10245434911568992, 0.6904192797156723, 0.15940944804176843, -0.2073529064014952, -0.031912174589220292, -0.30980371132215434, 0.66877464577743684, 0.064501434753175643, 0.090995735513192427],
                             [-0.46633607526396942, 0.076578443559934761, -0.39235430857862735, 0.30385540973942382, 0.78752222619582102, 0.1925128837498768, -0.035520763158394149, 0.26817031517547446, 0.15936221091511588, 0.48139137537624882, -0.037368269508250063, -0.21686957840805363, 0.29175523141435533, 0.31770549257883079, -0.18937444283947247, 0.93577159993714898, -0.18175540843304186, 0.16837525432828301, -0.088413657391115508, 0.16883817889200245, -0.072288960077511413, -0.22118830846559126, -0.30243801565500561, -0.07622982192679735, -0.29936305527324453, 0.20972489588621243, -0.66476447021865448, -0.29140618325270012, -0.4290748481204818, 0.33634906938652465],
                             [0.86744906452906834, -0.65044697547856345, 0.25265437370189542, 0.67793059971508596, -0.17390392797950099, -0.21457263680040814, -0.25024134081997917, 0.35879822453225735, 0.27062417330459215, 0.10460412808903385, -0.12501213455230265, -0.15404371752728768, -0.070388029053207624, 0.032509979001631092, 0.54648864297448241, 0.46153933160227162, 0.084130560312309505, -0.33253921098868727, 0.28736314790941148, 0.017473372454209473, -0.33485031782013791, 0.12330751368833413, 0.048978795214035781, 0.20834233397798282, 0.79096393812044796, -0.51553406682203751, -0.16067014718909586, -0.37025461498172668, 0.3133592762640085, 0.3268754398342496],
                             [-0.12450474407131307, 0.33930709196630138, 0.052691790139786962, 0.35928484347250889, 0.39081706194644472, -0.020590354036522301, 0.53094744915882242, -0.13860024742825264, 0.057852601815106222, 0.53176197231032807, 0.5961438597035974, 0.063166501588299589, -0.51001125253214841, 0.045950962351292909, -0.37953691897302505, 0.27444745906255263, -0.19988097906485389, 0.14864748421162879, -1.0911668130461212, -0.29174750937116817, 0.30637992836477551, -0.17117290014589012, 0.17908877052202796, 0.17086092019251789, 0.70330862164431573, -0.11631284337952175, 0.068310311363989087, 0.41232054839414056, -0.19787963444708573, 0.38335787195225357],
                             [-0.20329264950429207, 0.11265438040295905, -0.63310848337792913, -0.68999166904559106, 0.28002204283008103, -0.18335097048685645, 0.62317577687453096, -0.056264313965212628, 0.13400563843246877, 0.33428553328527466, -0.39120038003091046, -0.11794853337559666, -0.72467190133736503, 0.3040534990839141, 0.012089800932208863, -0.30220392498987614, 0.59007792721441887, 0.24817895138336282, 0.15644668937204481, 0.4502278644229103, 0.08450097996593213, -0.041434155394108017, 0.087230327274353245, -0.50218946209024939, 0.12596790497207599, -0.25041905209970627, 0.2652157561855758, -0.76671640618564052, 0.042159020009349263, -0.0052858118898230222],
                             [-0.73332468909569115, -0.19322374359380584, -0.31262948117423672, 0.091895396712856819, 0.64438336321552714, -0.28909036227456364, 0.12529274568159007, -1.0568494595052738, 0.23469565880993384, 0.33541661466525208, 0.0061008505055257442, 0.10661235445213982, 0.29027950134625469, 0.31132382831695882, 0.17899756522244326, 0.35480588363138338, 0.034142765676189742, 0.5664282048053656, 0.09076652515008099, -0.21314477835720305, 0.42253471377387269, -0.40613416389692125, 0.37365061488937523, 0.062267577159026977, 0.39478612766658089, 0.13763652278812594, 0.094218016570183361, 0.21875118314273295, 0.34254026137697136, -0.14098341326368535],
                             [-0.47286345251020179, 0.22094772032851787, -0.22380684275549839, 0.1918168676021389, -0.72042220042069804, 0.056548946321811178, -0.29376780861659912, -0.56529889664084654, 0.14992733551723286, -0.078721276257053691, -0.31565547136041333, -0.59130006676018998, -0.029533743664255069, 0.099547952697112127, -0.14041088425721951, -0.23046446117014885, 0.036579925923292816, -0.15691482635296758, -0.10939709176657519, 0.31778529391467969, -0.2236385579676643, -0.15786057636452816, -0.56877601100507402, 0.50161971151843099, 0.42839332199816232, 0.4659296849661993, -0.11039133265355687, -0.14699712037275195, -0.022822107272894007, 0.069019825747962157],
                             [0.085196824303538254, 0.011701392034603811, -0.16998063379376999, 0.40866324229742834, -0.75472060552706777, -0.25651309014083734, 0.55107908614846957, -0.37031474296686656, 0.15906059894579888, -0.055818845939647269, 0.19015465572645568, -0.24555796618890988, -0.43319399528652319, -0.10900612818153188, 0.37389579482271423, -0.10996467070601329, -0.48386503421146881, 0.14089636945859668, 0.14335763290533748, 0.020381704824938816, -0.28221505302631406, 0.43406389332967277, 0.15993379037182801, -0.17111849114896491, 0.3081215414019729, 0.84404372591221133, -0.64565611516838917, 0.28465757344916648, 0.34057004151727643, -0.036202515695030121],
                             [-0.55879422343125507, 0.19684600479077843, 0.57639255410701085, 0.41787298822589486, 0.4893149144287437, -0.052700303073321512, -0.12282520324176839, -0.053590155718756513, -0.083469523449112237, 1.167514966478872, -0.083520167420771174, 0.56662215008887418, -0.066942790515440678, -0.11947264749061083, -0.3938335842658286, -0.86606617144165066, -0.73743987111137477, -0.22550271581941167, 0.65252850184246514, 0.10682218962903287, 0.02757766716117984, 0.13650126126247586, 0.062344095774026498, 0.24316488501773262, 0.38656318986596028, 0.2156754302767534, 0.24164419158585099, -0.71448408006364628, -0.29472602105522372, 0.089986263072453124],
                             [-0.62435101455648934, -0.24708196445692235, -0.20159473758353749, -0.019929600172618661, 0.34598394442371289, -0.13664465886640323, 0.20367835639331464, 0.18498819255032903, 0.063024219595204767, -0.34688557105878642, 0.53461698261005086, -0.23670337186154788, -0.18729624613919435, -0.61666818121040512, 0.18492656528787615, 0.042394291827952103, 0.11829822379806897, -0.42592599914254581, -0.24870286047125911, 0.6509932670256664, -0.024256220897809311, -0.23238417316543597, 0.41793013359263925, 0.40735471841007104, -0.14708662903368164, -0.074042090347682013, 0.21579063800638087, -0.16877123454001888, 0.23866388113796089, 0.075407646277605461],
                             [0.011713491221045197, 0.28144039450242181, 0.070923691846904738, -0.6198788428687545, -0.13112226999298932, 0.43387941684022491, -0.05304799191344059, -0.12999360383801833, 0.31615716952797396, -0.1894866734892692, 0.46593932272185767, 0.63654186131977331, 0.029476804530179299, -0.98333236970131921, 0.25407214114519117, 0.55359925608146898, 0.051709664109634151, 0.061608023314248722, -0.29754546675116722, -0.5466802545726267, 0.0089167537923559061, 0.043910553319361265, -0.30548090638810438, 0.24352561976249168, 0.25880226158372849, 0.065488217092286014, 0.61219638193227854, -0.19148876091642078, -0.39782623613508111, 0.062748622764501355],
                             [-0.3680677798559282, -0.34108108968826634, -0.20839993600318782, -0.27312496228226274, -0.24332726111536065, -0.57391980909505558, -0.3119340831827333, 0.2041268523577113, 0.10670072805951662, -0.73625632790182782, 0.095341735401346259, 0.434269468845776, 0.28634822538980553, 0.18665728885357186, -0.18939369747924725, -0.23444666569761707, 0.5930247669605303, -0.25691215585906835, -0.15647694288303868, -0.47691263563200892, 0.68751440155776555, -0.35265134442208834, 0.19735670806433062, -0.21647770702740204, 0.22169318845514507, 0.33137840046694345, -0.50518552526758354, -0.22115666359647149, 0.16035404923919994, 0.20292165823692787],
                             [-0.054465709864589526, 0.29624620789551703, 0.83832871264355602, -0.22760714172926969, 0.046584958212750577, -0.13477260774543498, 0.23188500017674457, -0.40244332503291125, -0.055021694086720759, 0.58538258484365957, 0.31524843189392143, 0.36791974268440403, 0.71660690889894174, -0.050671532615090921, 0.10353369072495083, -0.11130041615453462, -0.10088154724428354, -0.49857127619474562, -0.61090218351249681, 0.25494644661824267, -0.22613225984124921, -0.019564027898987858, 0.10207725413352245, -1.1849967274152999, 0.1926860029042152, -0.22310535552741279, -0.16805263775649748, 0.72695693746634538, 0.093375495638722966, 0.50886793914481598],
                             [-0.40680627897998339, 0.03777966955265441, 0.077087060394996576, -0.0011411105993664114, 0.54072417685288199, 0.058960738873138324, -0.29887127159927745, 0.036819733155449827, -0.64928838078772877, -0.28242392152048368, -0.033442336111247903, 0.43804151770839306, -0.56920578455256887, 0.45584340932831724, 0.47402039291566156, 0.55504717363148115, -0.13877039421638424, 0.32776812828704993, 0.23241143859651861, 0.21198387512934477, 0.063251040676693848, 0.0029396742361563633, 0.22841637920294219, 0.37429880382649028, -0.14528011447136746, -0.14463147796693462, 0.37808818446498116, 0.092590566452142031, -0.021101784448275915, 0.92081749946862923],
                             [-0.095099556043790126, 0.33208056655748563, 0.10780510009709751, -0.16708568863895573, 0.21029315021825409, -0.01997481084046128, -0.49073563390893543, 0.44755953109355695, -0.25047478581888383, -0.1023407884274508, 0.28138337229768445, 0.35827965689323249, 0.30030278085197509, -0.045840685837087808, 0.087845366679035253, -0.43243426848734468, 0.46839487932905294, 0.73297834189876043, -0.59555535658689496, 0.009517998703970668, -0.59957337242589315, 0.96172931952164942, -0.067351137479390533, 0.31510847459217833, 0.18142107891230133, 0.21303541302313897, -0.094503848208618943, -0.45651286152173232, 0.16446934366581828, -0.40653250767748633]],
                            [[0.090811516570486861, 0.075168089841967073, 0.22880781628741492, -0.12960309012148785, -0.1576671013291982, 0.37207335851143031, -0.17187786492100213, 0.18761376550988601, 0.19678854900260401, -0.074730115230066438, 0.27406652228967515, -0.27261592106583354, -0.060024062047999184, 0.53996280566108668, -0.18099341324261956, 0.032569916540552205, 0.1179736344749272, -0.17952952650598744, 0.077810060744700454, 0.15221991215467567, -0.021463003380298436, -0.14717210718029339, 0.022217109396756824, -0.31686240731789089, -0.53974190025533919, -0.014023522648558898, 0.66485069109238271, 0.043958114295262744, -0.24257293923801723, -0.096237085980435275],
                             [0.053968566114896185, 0.056515908221100399, -0.7277484756911422, -0.10291113413761209, -0.13427176024392684, 0.0016104635406368369, -0.021747051888138295, -0.0063129491402921798, 0.50682234573589624, -0.35388932604660983, -0.41487150866754152, 0.17369349516306073, -0.42648578984538782, 0.13739026265274559, 0.025677154139661831, -0.4442647671353378, 0.2121049226656945, 0.027757590489734252, -0.21335267832430574, -0.20747758324220789, 0.10289152299430127, 0.04060893663389846, 0.23625604791534977, -0.16106030019379289, -0.28268700971645794, 0.25355246402926096, -0.16134294040685593, 0.18127457181259554, 0.15600040468519144, -0.0027306716597502792],
                             [0.1262301239971306, 0.041705361210221295, -0.28021728376242311, -0.56726501838269205, 0.3909458165200278, 0.003127009226514002, 0.14261757613458187, 0.27155173875467925, -0.060526699964031261, 0.016801439320462748, 0.14858585402438804, -0.12483411492373099, 0.0092146973817967513, -0.33048420902471781, 0.053998962831149577, 0.24411518266678497, -0.21621226563083207, 0.0087391221162225717, 0.011079650097783063, 0.29570654249827549, 0.1920588047273086, -0.3773290152285439, -0.043225238437233693, -0.25313489150911755, -0.2274432054881893, -0.053849630545110938, -0.19007391003270763, -0.23276270551813666, 0.14266052896744982, 0.047421933007301992],
                             [-0.39901768023092754, 0.18878051182262234, -0.17688263469793439, -0.021902399752465412, 0.40719793738892041, 0.15319348584860676, 0.34181309818845862, 0.009028552474459722, -0.025025161407385074, -0.11202744378438192, -0.27514956972232474, -0.0025098940873035519, 0.52419491319828182, 0.14166431997857856, -0.36423707952294626, 0.10047794788454431, 0.40095882346007045, 0.18104630498648308, -0.22324498530406428, 0.063198412307512303, -0.15656299730367379, -0.17243580738764736, -0.26264942251394757, -0.24042861957306863, 0.12576332613665875, -0.098755235677150138, 0.30381788980766949, 0.25208744132539335, 0.1996991017371941, -0.13767819073543086],
                             [0.18871877213819643, 0.02599352748977888, 0.08463091705545199, -0.23277124543416172, -0.12786401198287201, 0.46244252438565697, -0.26466050203066099, -0.22693482824794342, 0.018789726349069176, -0.28153313889689729, 0.15532050401199482, -0.27230595776113981, 0.2306657808406857, -0.34137482177605549, 0.2154019914118418, 0.15792894216858999, -0.10386486017532036, 0.52809365512213013, -0.13488301412633893, 0.066618096097519855, 0.14113434748368614, 0.29132988994023939, -0.16011048954982615, -0.077644135365498579, 0.15178135985828042, -0.25793452021265229, 0.24255345521629434, 0.49101102801422875, -0.018739753294841191, -0.32544694254370982],
                             [0.19813166285175757, 0.045461629978944311, 0.016958903744354163, 0.28401613786437274, 0.067021315807052451, 0.24774788876691711, 0.024330161966767759, 0.58556572326838552, -0.17433736692352855, 0.0585384759214089, -0.014330581025622666, -0.20778065184328046, 0.094498003804692712, 0.12493649838755834, 0.059605495537321668, -0.064150655797912473, -0.24160528239442186, -0.27479889792034679, -0.44066530867916537, -0.14795054141888658, -0.035647413434404654, 0.23870649365329408, 0.21932846683966273, -0.34067998742245476, 0.00066407766016515985, -0.3858577876055907, -0.093546407167370407, 0.34800192122140322, 0.3853116748685198, 0.25315356580998838],
                             [0.072783544740700604, 0.55864619734184517, -0.11348397397131856, 0.075730873072944349, 0.2355559148952909, -0.045183913256706232, -0.14851974926667222, -0.31746080833996054, -0.11400333642408952, -0.50970095566372986, 0.18971654902376436, -0.5177763695906662, -0.018038643813979318, 0.50036634330452634, -0.0062448223603565282, 0.016126571881460324, 0.1066609695395008, -0.096096073562742371, 0.077451473313762051, 0.09017656076075263, 0.13991759082944008, 0.24261281704171, -0.077539214731379355, 0.29575847427736995, -0.035164063435025358, 0.020593046819745563, -0.093629632556269285, -0.01069434189246579, 0.098994006295971743, 0.097527238600186111],
                             [-0.15940986136114235, -0.20018090193263019, -0.57060326638831838, 0.5378652446466633, -0.14737930976402547, -0.082123951991510707, -0.075022057108782528, 0.16820124007804588, 0.11551842332697451, 0.031974181035886395, 0.22229199532254398, 0.068763995686486015, -0.05273375641770213, 0.15116840287680453, 0.065770287462758648, 0.44727946900552024, 0.11017916494206881, 0.1499908778149727, 0.019445697032787063, 0.59349468853505383, 0.074946504769172792, -0.020432461037676125, 0.22998388970556133, -0.092361694131586652, 0.35680258419884553, -0.26752524373085096, -0.02576247436817479, 0.019295323325865366, -0.095193177864530104, -0.24362902851786583],
                             [0.0061192094350161, -0.22913695848077337, 0.16770446360753166, 0.29108193813437422, 0.070985597411831747, 0.64754490960800115, 0.11673727624835031, -0.32806687500670811, -0.08292873586079022, -0.039797357380010251, -0.36528899750427479, -0.1133168416110589, 0.25611206249604596, 0.1136136958818937, 0.31076380104778412, -0.24454810719796563, 0.03990983202638556, 0.3136108707143731, 0.29858233996116845, 0.075532986170254876, 0.097456972919342938, -0.26140094171842965, 0.38633964636854612, -0.23560892935506375, -0.15676397835870404, 0.10203736026764909, -0.2538735373196479, -0.24024035848748099, 0.21245388198302639, 0.27898036346750577],
                             [0.035202302374917421, -0.39451293825187728, -0.011931424725429234, -0.17697532388140511, 0.10158601015563171, 0.12248501693124504, -0.10405049964058391, 0.39999623625862679, -0.18773781174547644, 0.006451587512415341, -0.022171330306487977, -0.25054960016758038, -0.067822552253378812, 0.11473070708815304, -0.04457540859882364, 0.068548383768680679, 0.49962830361262922, 0.13538632498858216, -0.22980679910586826, -0.15355119522233565, -0.16944029484581663, 0.25310826119983088, -0.029559075217091127, 0.30122804537093262, -0.18681139261278365, 0.18667471046329664, -0.25953374097975707, -0.30011195379524547, -0.30532432622567957, -0.12370763110104618],
                             [-0.2235721245071568, -0.52447785772012145, 0.13060467895831626, 0.091646192099771026, 0.23805401331520343, -0.28771811358711102, -0.16912498540894164, 0.25027269021590082, 0.26834923063970217, -0.41845400975449021, 0.37861151393044001, 0.046804732969580612, 0.29617404901261246, -0.091924550039495276, 0.07014257596780557, -0.65645775467992606, -0.10032279304919681, -0.1675201559746417, -0.15116961602905166, 0.063717345803864345, 0.063065974472500966, -0.14155861295063257, -0.096695994577595062, 0.19392921564790855, -0.0026229740199587379, 0.19895393936342251, 0.42223899950811561, -0.29191149855428339, 0.53060146099026606, -0.13978941465105948],
                             [0.18665050752508919, -0.08081704878591725, 0.47664409528334362, 0.28506154568069686, -0.16578108997355306, -0.16138810868142514, -0.33241646599445279, -0.22282145792164745, 0.057645553039759108, 0.36489412883505123, 0.29012699837517808, -0.15872508151838025, -0.39265327884243023, -0.27824935603677664, 0.0081045912759066668, 0.42718472244216826, 0.34316546281208138, -0.0099823328048562684, -0.061118086137088593, -0.063144160890046278, -0.10626573859253324, -0.21702851287980265, -0.15123574295765968, -0.098549132236967152, -0.12116691360557701, 0.39353678379647006, -0.30175752925202443, 0.08602284491153836, 0.58289826493772057, 0.038373165777316157],
                             [0.18934137640341298, 0.48341779776729132, 0.26045960663762213, 0.013070054503443699, -0.05513912316362763, -0.10378031950476471, 0.31199771086776246, 0.28796519370091522, 0.42103327623684483, 0.14976269880330376, 0.085805775631710199, 0.177022384601529, 0.16566836125969789, -0.046092420480154564, -0.040141122070449849, -0.31458790476613929, 0.29737838418110923, 0.75464170279800435, 0.083932062294063192, 0.354754240870918, -0.072434415665248442, 0.35874320798586662, -0.16335290882253684, 0.02861712578133736, 0.014436783360357103, -0.025245555041413868, -0.073956367089481639, -0.25206275442091147, -0.032872141719557914, 0.19267165675655282],
                             [0.0015313063342287242, 0.17062510132941291, 0.083268150507900957, -0.10215272481651745, 0.10612373854126497, 0.29960047450500837, -0.48079777636106785, 0.34100521433295322, 0.26192850219366981, 0.033992815083231126, -0.073915897460701346, 0.27768546504214442, 0.24617875467623648, -0.02665710317377552, 0.4840694051477144, -0.12910788085895625, 0.34062396286914132, -0.25949717401141265, 0.045317518039722712, 0.13218606705087477, 0.17955526336525376, -0.27298307288546758, -0.37591363245633896, 0.13729317504757041, 0.35774892431589039, 0.077367942391508779, 0.11480980934714333, 0.097889236677132285, -0.015919622192311737, 0.38407199097635608],
                             [-0.11801884795460776, -0.21043773711297853, -0.18879607801452997, 0.048625474254373226, -0.32507591767016308, 0.17058873823574336, 0.28008800611214457, -0.022215001321156797, 0.071240620337058885, 0.0082996367100946072, 0.30051937075307983, -0.36504888263217622, -0.2801293659968862, -0.36659333629219387, -0.22171635032742476, -0.32364501873232104, 0.19940152245735104, -0.25178412012261286, 0.19134128847230611, -0.051813954490691788, -0.033094099686522674, -0.32439623918278049, -0.18746464877593866, 0.52948444551097773, 0.078707637504635233, -0.40150948191483854, 0.081251880617482328, 0.14411212847597418, 0.021323545407498978, 0.2415027947210911],
                             [0.32235468877477103, -0.20349549804541645, 0.12849008114201421, -0.13215025165663566, 0.13144753321602215, 0.36386302746241161, 0.42456483045509263, -0.11317006730955198, 0.03710224298823582, -0.19821562180808172, 0.12136460248342651, 0.037713330014692584, -0.31113336726507179, 0.34519808646395772, 0.1943942691692252, 0.050607175160572851, -0.042069611250351954, -0.15305476803231494, -0.25160406686660935, -0.0081356664183144627, -0.18166293381589568, -0.095003035211495362, -0.021291029067717078, -0.092568293637140364, 0.70016267635058238, 0.29584533303140786, 0.35036659233871653, -0.23292909086530542, 0.19190511920431608, 0.087134449364838162],
                             [-0.40954127443968036, 0.36961104387698351, 0.31681580410532961, -0.24005382333502479, -0.31284839644595869, 0.58064664974664382, -0.0242835940218043, 0.088093324413022631, -0.65066384913608577, -0.27509575840798078, 0.34170593589417558, 0.41983700104313482, 0.011504896074669724, -0.22897090427023997, -0.19967571869525572, -0.0077641340725691094, 0.046009686101447136, -0.17340607404101641, -0.18091759733087889, 0.18608881939547633, -0.013866704841071881, -0.023091827618940471, 0.10947911943629812, 0.10362915047148041, 0.014226245009110277, 0.068110206669669326, -0.052885744096632256, -0.15590547726400586, 0.2624841627654883, -0.1316444816487885],
                             [0.39542992198371846, 0.043236528833122984, -0.11049442514722589, -0.017054974923630194, -0.74146058310712049, -0.016918752936887636, -0.028791990156063065, -0.11949070904995444, 0.041470055766899001, -0.08210698293232821, -0.045486236846222786, -0.11841064735409053, 0.63638872580882877, 0.21305314629586847, -0.23068994413929958, 0.023662032839929584, -0.072467971623620328, -0.053497784052907046, -0.37924660306936719, -0.034003873976803906, 0.2298983648743739, 0.006575003358438308, -0.20620888540989227, 0.01844150114634778, -0.088924119261761067, 0.0026112857760362497, 0.030497077590531621, -0.28954401958576031, 0.068718500098314414, 0.24346272924583556],
                             [-0.065739182359350445, -0.27152710723016993, 0.01088903883167929, 0.29576011112715744, 0.070970068771354949, 0.014412765200814911, 0.3140908897409489, -0.10921591626748038, 0.30828333005100489, -0.69352066310127447, 0.11714636502883681, 0.36310448212145474, 0.043823709655865344, 0.0078564835934792632, -0.3703593059249351, 0.34283589029872641, -0.013749820552687576, -0.15854378067433575, 0.49009499534275763, -0.13741977759976082, 0.2825673938405206, 0.47252318171173358, -0.028643827884807863, -0.28450426346704383, 0.16681743000366597, 0.091788781140656486, -0.49698360485367676, 0.014008987661017436, -0.24350997302716557, 0.26987046934196429],
                             [0.067650330552892241, -0.43428184965670069, -0.020214022758623437, -0.091122007288481993, -0.064302354136584416, -0.11074809578571335, -0.044750174878262931, -0.10976340762504018, -0.32055517852547849, -0.15534575210520141, -0.33581690821738402, 0.23869460121307853, -0.32037370613575999, 0.25623661360425587, 0.10767832126783355, -0.073332149096924398, 0.055179704497242452, 0.01074983616028486, 0.1492896441247103, 0.37041483577071432, -0.26037851518886129, 0.27642121841506939, -0.56450447429469264, -0.052346352426241957, -0.18541391600448606, -0.30635495120951789, 0.062288553327314686, 0.020647382870682102, 0.37468709207306783, 0.20015464016114221],
                             [0.30007475735494149, 0.085194531484318617, 0.046461713521167153, -0.056421098912911423, -0.21700010250577981, -0.45055849671616405, -0.15251496638706283, 0.23894324346090592, -0.15118083860940404, -0.3283846799763987, -0.10013878345948768, 0.086284066115683372, -0.1017671029640614, 0.18404191194314798, -0.30276674763837208, 0.3693974976603005, -0.15297823960167115, 0.57754329387139691, 0.25544323062726781, -0.31682474458753274, -0.22513080850086287, -0.18064629736385571, 0.22500272549972497, 0.17893995604581506, 0.071954820950259069, 0.050798604796346222, -0.051258010149854941, 0.13934462878573234, 0.062456860363447712, 0.29018894530174189],
                             [0.03368878820984695, -0.015405078978353109, -0.23675167294093169, 0.29552694696207343, -0.10580943185828545, 0.32676321385050022, -0.15993333797550527, 0.16879388559185507, -0.31838248519968249, 0.095674793070950073, -0.13986292183047971, -0.37881841908299907, -0.27407016350127855, -0.36222713373300153, -0.50721686899598795, -0.31953646293625082, -0.14213806743011848, 0.10000357794509473, 0.17594133251811855, 0.16391279235339698, 0.36910928483932942, 0.13628104244417649, -0.15876829969661455, -0.074966961994223091, 0.20087401820694001, 0.64039578934176888, 0.21985929204776078, -0.11844526358122938, -0.051471372594786235, 0.058283600320191684],
                             [-0.19032448860953488, -0.28473688136318115, 0.2843457069367078, -0.37240874506401128, -0.0058124981679184822, 0.016239901914405854, -0.028586346617805781, -0.060093527835203331, -0.039757686741592392, 0.41056011171191892, -0.33840004487071518, -0.049254945181487188, -0.25573993751901564, -0.046905081256944176, -0.14554841044115835, -0.028053116806436462, 0.20159800980331569, 0.12865311948780606, -0.33336235614562071, 0.14622247830381155, 0.63328952860465293, 0.09086463277504174, 0.46619648233339606, 0.16157598899883821, -0.040660986675702296, -0.10357396833490851, 0.22501688811243778, 0.044726326556658279, 0.21181146122988995, 0.56269502308654895],
                             [0.12189650464466076, 0.054029608230877595, -0.043218566882732276, -0.18892728501060849, 0.0091742234668726799, 0.13052258049091492, -0.53999716264545305, -0.075824867567068591, -0.10032383609051181, 0.32466059328741781, 0.21680833059970814, -0.0001639395698447301, 0.016272647722416708, 0.18244331186416057, -0.54201492025311027, -0.15159827115392993, 0.095619309794952256, 0.1018230684508893, 0.16453896481148139, -0.2113569044212959, 0.045398769320834392, 0.047456144051268696, -0.029257955109987362, -0.37913435509236748, 0.53767948965674139, -0.4780223744361512, -0.25712265380747784, -0.25381200085398392, 0.18326853496568676, -0.044924202970539714],
                             [0.064659663475183551, 0.22316639301283336, -0.32350724491371502, 0.44077132930899549, 0.21051291844370423, 0.47036106495718721, -0.45971425035318514, -0.16455257651244418, 0.28901865398760745, 0.3012889320809532, 0.28092902837428574, 0.29408580201379253, 0.10278399399211871, -0.41056939029455203, -0.0061981382064844465, 0.22667696355397654, -0.22140133608431917, 0.001109885451772737, 0.008145708831139617, -0.19166635649130864, -0.10010410337586705, 0.23660059705851041, -0.053019149670505562, 0.45962318022863363, -0.35022711610527751, -0.040930048125642229, 0.44013939387613821, -0.2861885430679238, 0.048761418303572536, 0.2816854353388879],
                             [0.7249486540414446, -0.076378704279510337, -0.2910508167231754, 0.054193520127914001, 0.085325121315796754, -0.088692641036389089, 0.01376615836753994, -0.025477975822085917, 0.048721804749076912, 0.064943167106337726, -0.13577797567666236, 0.064946228217741472, 0.15632413741074996, -0.077887218237339087, -0.2036068376164808, 0.070588292954322285, 0.34286448616854659, -0.56309380823781974, 0.34275913098984012, 0.17676220525003269, -0.13312904097475217, 0.16980092583037043, 0.48498651200223269, 0.21714348264689068, -0.10071403131948455, 0.11812335797996106, 0.072169977269591831, 0.22023147218955394, 0.058197087407185044, -0.28522372374963739],
                             [0.15382013613555617, -0.068000629477570296, 0.10793191385020925, 0.018115089032577317, 0.15207668737831992, 0.017244778202102996, -0.28515275993009176, -0.28561219020994189, 0.12976909458718508, -0.0094887275392750298, 0.19243058434478064, 0.060365250223672132, 0.1494040434506044, -0.12365106443241147, -0.20566045912503075, -0.2931255773408421, -0.15644035139914603, -0.049843169570745201, -0.39067778788757335, 0.3777885095062935, -0.50566349721432358, -0.15763138839384999, 0.25256820185618967, -0.16490613751465624, 0.11083301672879903, 0.078158433865026522, -0.16497361647834946, 0.11809203218852479, -0.32423676108904048, 0.47490850307375942],
                             [-0.28894345663950871, 0.14763706760052375, 0.11068041819337553, -0.30125180427315801, -0.31712718153912817, -0.26262703452418956, -0.1696256497218209, -0.035006536612230153, 0.20151576637910693, -0.2246731649686636, -0.16158112277342557, -0.32930865074524202, 0.10227442380985043, -0.20505366847297818, 0.20394351480403114, 0.39705361142457901, -0.1150899424671304, -0.26889297557845232, 0.23420568992340035, -0.11241024862868476, -0.66416137341631831, 0.27501091023891538, 0.24670791410136764, -0.15167082631268602, 0.237810800208208, 0.043017242091455646, 0.080621881026326975, -0.28894369790500063, 0.12158613175726361, 0.030421436460898395],
                             [0.37220486309503292, 0.13683130437752133, 0.074911868760201172, 0.46656171776087102, 0.18146920269470257, -0.47619936117398609, -0.19349995723849742, 0.11108899278660023, 0.10872648828554471, -0.4335213196446337, -0.31470011131752607, -0.022305355471507419, -0.26058196188939198, -0.33787907618591612, -0.13204701699166707, -0.015989196645417904, 0.22929671259280882, 0.069025077362837334, -0.23667555976380666, -0.083040288087558645, 0.080884061262264481, -0.28393085142128904, -0.02113993371465004, -0.11164465333104341, 0.10872824130948772, -0.52292701595173918, 0.098081527486179182, -0.46921466457291944, -0.26341303843414465, -0.23333214250459539],
                             [-0.022039408469007753, -0.043382518409445528, 0.31484747215180875, 0.021164678301815482, 0.11582946934598613, 0.12926777166743292, -0.059891233604044594, 0.27441282329313615, 0.54375522686889, -0.06278489368725218, -0.46672438101081759, -0.032614803554508111, -0.089929308498681373, 0.063826930261793258, -0.28420332268030746, 0.028586255707608314, -0.4176494578139926, 0.088622803676157852, -0.11185761959444748, 0.22030415993544772, -0.03912840036056147, -0.22448331425836549, -0.23026502997293805, 0.42183990788903775, -0.012990263458532162, -0.024506931830151762, -0.22450727620352937, -0.080195077153198277, 0.043947651778367958, -0.49183449735730284]],
                            [[-0.15510283753986967, -0.57235977528571147, 0.21184873402916485, 0.028391951704928892, 0.55497198714592921, -0.55083907620028283, -0.27781144206929725, -0.096043753025636752, 0.29234033383041136, -0.43273434123001148, 0.26955644602825368, -0.47075782385540604, 0.13285072186754321, -0.26190807847497299, -0.15865259030118173, -0.21464821446751495, -1.2166780343956285, -0.33904092146058101, 0.062238961927131631, -0.035368148818933971, 0.56566373172749418, 0.28793100896534901, -0.20648129071460308, 0.65915303404258974, -0.10131129489421514, -0.31500833435690129, 0.24152152070790811, -0.034086213189668313, -0.10195590942128882, 0.0030680881166595397],
                             [-0.49569325310688972, -0.393370662381544, -0.028695198434295806, -0.31405096102442243, -0.1023493320118489, 0.073479336966021741, 0.090719571569046614, 0.54090212201806087, -0.13689099305247054, -0.031489191295740834, -0.14262501370313319, 0.32769078673963226, 0.36595130424252648, -0.096536132954707532, 0.41852147889570385, -0.11017461457219273, 0.16067809516529705, -0.070770297728510484, 0.5184917477611094, -0.023687736255478424, -0.043636578112781391, 0.19100667992659964, 0.39901604026110471, 0.11612426642366153, 0.05550537283716863, -0.32940679924691002, 0.03872987047066994, 0.18789994727682505, -0.52491207890250324, -0.22766985628784142],
                             [-0.21100608283958114, -0.13149435397262083, 0.73601483083485975, -0.6507975347984144, 0.051179630160049214, 0.016774275126200482, 0.56115186067001988, 0.30923644479701334, -0.012961404206432596, -0.2731557993653756, 0.017189951200815831, -0.54900974514172185, 0.3337724207114649, 0.054933084181994926, 0.16079763789526089, -0.27569125572947428, 0.21385706511567734, -0.38856681417324362, 0.14229319791919243, 0.18220584530603809, 0.36252261773861588, -0.11863770696955955, -0.12526204398431962, -0.22541994123960843, 0.081407743752046208, -0.10846699115039969, 0.45697217546534874, 0.30132945818925738, -0.1984290138249161, -0.344250244837355],
                             [0.0097022409499843195, -0.52895518033614364, -0.06842013607303421, 0.40617156341676824, 0.10306049525686674, 0.44870254135495169, -0.2541583221505091, 0.028179089030017923, -0.38551490599682203, -0.22493567716844851, 0.17363557265933799, -0.016831516349186657, 0.22557385751544315, 0.016674403129058064, -0.16268655142605282, -0.0081161773928323539, -0.54938083743228683, -0.66526760017919573, -0.26420089264270191, -0.18421686770637097, -0.32152485702624628, -0.27874330551480342, 0.16598823535887491, -0.32204847739465403, 0.24435573228105842, -0.0084018405314492291, 0.19007898288598862, -0.38398611594658549, -0.40905295795036434, -0.23171180758501314],
                             [-0.45986061093283742, -0.19769085528293401, 0.0031164683419553376, 0.2235938270981021, -0.23161916371617036, 0.26658956688949847, -0.049442861004817783, 0.24718626403985378, 0.21343563364882431, -0.28233523606230043, 0.66262816624874266, 0.0081950228548105485, -0.46737229420537396, 0.25148819978655246, -0.29868027565159722, 0.45016243107423548, -0.011990716829048152, -0.43141438180266406, -0.043891808201817768, -0.27627142198399296, -0.078346120834643235, 0.13472498136563052, 0.43356067232178686, 0.096928215942929594, -0.021630854674205016, -0.24627917493729917, 0.26474158023649397, -0.46537290690316591, 0.23262339619120412, -0.038833526504779392],
                             [-0.24380781197009857, 0.072221349753816777, -0.062836401236472744, 0.27346499241886552, -0.35607932669182979, 0.10667296953506325, -0.078169242054725196, 0.013102358020516375, -0.27351221492603395, -0.90326103233471988, 0.021968595261308871, -0.10291051561564102, -0.16424566045675493, -0.18325097532155044, 0.049985344491616651, -0.30543202757846244, -0.16407077575128304, -0.24081056330640943, -0.062255848128231213, -0.10591924766588212, 0.35369519462728738, 0.31277015424750054, -0.41635705660424704, -0.14462812655486573, -0.14110187058169915, -0.0093832266211778884, -0.13816739028984082, -0.28859932811259636, -0.18940703063870162, 0.078061873853418451],
                             [0.14631258871682667, 0.070676793562905738, 0.250305820699813, -0.42238135246252717, -0.15681418596407884, 0.20002987225756802, 0.58194497747746021, 0.23906971003034336, 0.082179810342915049, -0.57206067961573126, 0.15836605753113095, -0.1926869172002503, 0.41539913117386579, -0.42374763157045026, -0.18988517811490863, 0.089035421506336004, -0.30413016699983236, 0.13807450337440247, -0.40642261864317575, -0.10690270552538975, -0.10160245403530879, 0.14775327114891665, -0.20225257279664019, 0.1832814355032783, 0.14307146520753494, 0.0023904314114077006, 0.1820480751957454, 0.42022944501022813, -0.67034064713923658, 0.48589672760212466],
                             [-0.14596145472489042, -0.14650693679047891, 0.31348717308587504, 0.092212288971566539, 0.066177766262294227, 0.029618048829258493, -0.37873381397346667, 0.51878379557603538, -0.11455333632074023, -0.64545063525406454, -0.23155600892775219, -0.67293433510589884, -0.11998030735249531, -0.24858366906271601, 0.35548323612664284, 0.02694196603522837, -0.30028604607016857, -0.25801336512554257, 0.21941923697671389, -0.64914516216408957, -0.37387640246857012, 0.13737632138965561, 0.49022060076404578, -0.24505906334607452, -0.33975843659811727, 0.39697714805501094, 0.37986160885953296, -0.31191356169624734, 0.35160638878946637, 0.054579873004554746],
                             [0.040464430416426861, 0.06480563572526099, -0.10910788603568471, -0.0097826852454947974, -0.11048376991998156, -0.16206098909892158, -0.16442818264246517, 0.61168765235244593, -0.073417867949704452, -0.042914373178982779, -0.66599946341497018, -0.30413977368130773, -0.046381782983805533, -0.14277741058905299, -0.21633085511061306, 0.32197448693722741, -0.39001585068550504, -0.40587672801169516, -0.053366279878614573, 0.077685697841963622, 0.09228657581857902, 0.40107016180348015, 0.086647054918073715, -0.24914959661439356, -0.022970562117592255, -0.34823177793265092, 0.10120275403116527, -0.37224797951965832, 0.086291701802661464, 0.014959596453392024],
                             [-0.099449356281476747, -0.40925029796532419, 0.07562698493873013, 0.11609781606460849, 0.29495551320968155, -0.25810717372878583, -0.51923230860910685, -0.23333778757312953, -0.14010719682534256, 0.22251064332356349, 0.014844324292621435, 0.65613658444947132, -0.66648543133176041, 0.2987097229957919, -0.29939456009719423, 0.16580642017034214, -0.087872713740523772, -0.56489439483090231, -0.45461204626722751, -0.092420737373648393, 0.13952140939514104, 0.45810844463502115, -0.055705826920975469, 0.15790694612826961, -0.45256186089974459, 0.29142887292985048, -0.05992702219628325, 0.71243876443521059, 0.30388980829842482, -0.10741147169154204],
                             [-0.43636266064114781, -0.054587203824454512, -0.037156940376032545, 0.46718353972460097, -0.017881651308742558, 0.2344685607934108, 0.18528552318439326, -0.012939933566503137, 0.50033611923145171, -0.081411395501502851, 0.10961218197450329, -0.028826671442882673, -0.071838568721480742, -0.064057059985728665, -0.48972021678058431, -0.60828279785802175, 0.74479376417097221, 0.36881742233413484, -0.59659009938116303, 0.33025814934511832, -0.36536967184039504, 0.61388786534555417, -0.06449553521745402, -0.15679339338004891, 0.14050109736868566, 0.25838024466867676, 0.1325272908097033, 0.019548761061828738, -0.45528691979557845, -0.095916804973348951],
                             [-0.32716078333342213, -0.13292330145536421, -0.20350414588512214, -0.11861772680447283, -0.33036930811662096, 0.29435170631194185, -0.36124454156590702, -0.010145592795987313, 0.036935223803758424, 0.24204230542718683, -0.030790480591384874, 0.15470288151306644, -0.20553726501968725, 0.20490333889912649, 0.019825984518270896, -0.065599982377039623, -0.62227939766391804, -0.16694439681372814, 0.45865980977113846, 0.26209134149984065, 0.2065167852569198, -0.25411366588951823, -0.26724448236510689, -0.08096927534673555, 0.18966057012013177, 0.50208671933740145, 0.14822081268303838, -0.06720481727781967, 0.17785105256642553, 0.55344486777730462],
                             [-0.35366045004453733, -0.45280235751260528, -1.0985224137332317, -0.012994972624112509, -0.096004924624510657, -0.10927753200246777, -0.054835454914560919, 0.23273792578220531, -0.12300621458931631, 0.34670580290938391, 0.84891172840217377, -0.14510895844262278, -0.088349103042923871, -0.27059529434058599, -0.15249551513646709, -0.085315472205224174, -0.023852961679268234, 0.039809271353326736, -0.52304225545323646, 0.12522669773512718, 0.072132551113914409, 0.20795611631564012, -0.34773789926551141, -0.015648031294871634, -0.15350976760624349, 0.11388810806789565, 0.4233016738240179, 0.17362358148299445, 0.07838569109485867, -0.41259566094338457],
                             [-0.1142833748186851, 0.25408272319508873, -0.10757474324156219, -0.30088694643607505, 0.5890463352324522, 0.27914905740495527, -0.073699040485536077, -0.56243226688166359, -0.25426144308212711, -0.44742585810804225, -0.1919513912226046, 0.23537955384499756, -0.29990175097133664, -0.5434387067448726, -0.2994895717600442, 0.24227228224503281, -0.23365676451989359, 0.22369904580015484, -0.25400634451219239, 0.29160676503351751, 0.096363295181140868, 0.12545097533157903, 0.44203225488596831, -0.47397398171027172, 0.44381060119547361, 0.13822127854428687, 0.21035877508606254, -0.10845445320684369, 0.19238701472562691, -0.011646066050123397],
                             [0.24431163419473167, 0.1685500862663061, -0.12120665324445702, 0.62134640599966018, -0.021819379323032788, -0.20238160592085142, -0.14787949590076785, -0.36260304372492586, -0.23929758822511599, -0.83563423558712202, -0.29417095025548562, 0.12151608929390911, -0.054064677362102007, 0.10719250116932079, -0.041859348214647901, 0.4312488310781703, 0.3587974226343863, -0.081450327267286279, 0.053011108543582715, 0.47175900495881901, -0.43427754843457228, 2.3759100600033445e-05, 0.025213386160364344, 0.074284195334406111, 0.54728336721969695, 0.14163007048024812, 0.30374598457706048, 0.49067427199450381, 0.23187293145708149, 0.20157272467187476],
                             [0.031565873566708647, -0.011993919268866992, -0.2822876294308187, 0.012679814790855226, 0.19142051068026691, 0.11299469244232524, 0.95581306457334625, 0.066804218680080907, -0.081491286138086899, 0.077569829818328828, -0.28947960923474492, 0.16897521705963667, -0.054360790613005097, 0.41364508760763863, -0.06451992074162359, -0.12365974517950983, 0.075190321158554105, 0.32731840958819319, 0.092743962554183157, -0.18542512962880306, 0.09830343808272074, 0.0014410788874558223, 0.085705750307506878, 0.10612346453424168, 0.05282291329066751, 0.36824455940247264, 0.12439723305295659, -0.33830550105788221, -0.14226844758892851, -0.19006005227684414],
                             [0.12128492319454251, 0.4850142085510451, 0.044164522735873922, 0.40275121734468883, 0.40085974994212065, 0.51249621959603342, 0.43691450005858257, 0.37045998181936834, 0.10387481956237793, -0.40356316750833954, 0.20510634445376366, 0.052976943037637329, 0.40624919312934316, -0.53190203966315741, -0.30583882431415788, -0.050583367578705365, 0.076200449176035509, -0.24041067742482577, 0.30225270210315613, -0.049860201905628537, -0.2208587457894666, 0.36156668273744541, -0.18585386223464193, -0.24216655728321529, 0.16902304105963695, -0.21803677954934694, 0.16372021310365251, 0.37864444726615765, 0.32900005694446499, -0.054139986528147693],
                             [-0.54373663638684977, 0.18832198827536584, -0.37021491159853637, -0.30253857467492201, -0.29405068252461608, -0.16082855117097841, -0.19298588376589329, -0.23899382586074916, -0.014895631056005408, 0.25538112998290213, -0.10857630707627275, -0.11382546638552805, 0.43410847561587035, 0.1297883529725137, -0.35843528736432406, -0.25592205963789183, -0.022226195532979002, -0.20845948446036452, -0.089644174133271498, -0.53349288315281407, 0.14865653821043281, 0.38133273958030101, -0.093220419159204898, 0.21660763148956172, 0.23771176722178128, 0.14450747992837046, 0.21590722458145017, -0.068641189596745367, 0.19657302774924867, -0.044866718528123933],
                             [0.27407592194720148, -0.23255342821447644, -0.20692818401411911, -0.056605894276490133, -0.11117255325249012, -0.3462996819097568, 0.44940453712256778, -0.61645651084933295, 0.24064274651779846, 0.15779500066401933, 0.09416889410878633, 0.35746312091622817, 0.28246500456469603, 0.19622475748426121, -0.08089809286329952, 0.17120156943500733, -0.073396748999709868, -0.12767139617379056, 0.081337670773631909, 0.355040893592586, -0.036488492828199631, 0.37770298472695557, 0.41392434141751916, -0.50288405310602313, -0.25580439753797257, 0.26284108419357149, -0.48476913374679403, -0.064101761423452752, 0.2779517784649192, 0.15346834295141429],
                             [0.039462694516977585, 0.21905854641535952, -0.23756679810626816, -0.073486765791095615, 0.062426962746929764, 0.43795739465315414, -0.011989926003570184, -0.26798212597609494, 0.59414635936583515, -0.39036443423965567, 0.13617714277094442, -0.074654934275126025, -0.35773360345193994, 0.16410457607111481, 0.20178676213935931, -0.31328524479458397, -0.24564581731546734, -0.18338572727319011, -0.27699306794944933, 0.13189376424077526, -0.28939339500924632, 0.20839025716626333, -0.12100386502591012, 0.21502143843802468, -0.272401966810499, -0.26116426782598984, 0.46943091371925399, 0.63167101372022882, -0.24063448626521722, -0.42709439966029328],
                             [0.38989969463348073, -0.60460763406217055, -0.77747609934755679, 0.17524908080383836, -0.046854767044224407, 0.26649432385640592, -0.27591837529572144, 0.18486574445210685, -0.068874145844966636, 0.074852194942985908, 0.52852946660136069, -0.33333193452574017, -0.53543299609332262, 0.066494642741079857, -0.46571250348790749, -0.4899260907278784, 0.17030570057320385, -0.11700833256619243, -0.078684251623580281, -0.34403213054780774, 0.2688863932554813, 0.42403908517119338, 0.16710211656414711, 0.0078784034733400694, 0.14416266670535582, -0.14291193670755245, 0.048654551821163003, 0.17347436670646574, 0.0084021915904460807, 0.10853815092554997],
                             [0.12900633865056202, -0.15460444499562317, -0.155559449631889, 0.065423212394249169, 0.17153035455495469, -0.45605047926091835, 0.047626585801649302, -0.34378104007422772, -0.23549700907971943, 0.38099696326884019, 0.24059810767878193, 0.34334475619485566, 0.059919693893625024, -0.14503393950736246, -0.25654398265879585, -0.01814038417621517, -0.3870550914373237, 0.088538434322551068, 0.038608821636978569, -0.17589579417553036, 0.17005011863549982, 0.2583023888545436, 0.072942422409465815, -0.43848143462019323, -0.43361732476978815, -0.41211542442521315, 0.77824068499089172, -0.47685633337394001, -0.10497832851996618, 0.3873327015082409],
                             [-0.27965871519751551, -0.11202026025896579, 0.46117669259433719, 0.22490125153788473, 0.040687070202988, -0.17661099100667044, 0.1276024509858121, -0.5092400970782146, -0.5756406950830899, 0.24440765377933071, 0.11104633454881217, -0.44158607252130988, -0.43087652803706267, -0.069607066145140103, 0.20330411599147891, 0.19544180709756595, -0.86718642045997996, -0.33190406544314399, 0.038372826141456318, -0.017237469453270954, -0.060498023598583681, 0.56879091125878367, 0.19330761406622854, 0.0071588762808130748, 0.11429946976313443, -0.29042332126705889, -0.069704967228335496, 0.11201367166604462, -0.25370904437021613, -0.035381334920151192],
                             [0.25253055744212649, -0.17398550874024699, 0.012431296432528693, 0.27786219371001886, -0.11141961488017015, -0.050337654881312539, 0.20310734698514171, -0.30746705151506887, 0.19686323803222719, 0.26034705468892005, 0.089078920254519009, 0.32023399206657371, -0.31323114415492642, -0.30022007406219137, 0.76240476700625393, -0.25384304018152687, -0.037547588596937909, -0.30197279073012578, -0.57814419698517561, 0.087842959642618845, 0.14700456726654729, 0.080175058393878396, -0.089638662216866144, 0.3829419229825286, 0.3499779304641551, 0.045461011333003322, -0.058429794203560259, -0.18686876724103227, 0.24059942098413631, 0.26667380337728447],
                             [0.098308114707220173, 0.48301072274613777, 0.22745939088055864, -0.34651156184502024, 0.40813958979293125, -0.29574147517624977, 0.056644742736695765, -0.12461268151423539, 0.00095647047508645028, 0.25574118231073412, -0.013166869125986136, -0.16530415147986272, -0.15160975161236259, -0.12098368692554221, 0.045127525171435479, 0.14543598186439821, 0.29849692268536787, -0.88225649342430534, 0.5693871629006062, 0.23536947366488065, 0.12712928754475572, 0.097003764139512907, 0.22441121249283119, 0.30759314296136803, -0.40361321658343075, 0.23718669908241727, -0.027110820350773612, 0.032600818983842969, -0.61885998439050172, -0.15185479524141596],
                             [0.38421136684971297, -0.85855360863128849, 0.068639957926502349, -0.32128042266285267, -0.4939823168421113, -0.0088139241751688455, -0.07975980756736438, -0.20100072488231396, 0.51991176179471876, 0.25008983874207275, -0.05230462871341434, -0.22225085165646072, 0.0035206745879168694, -0.44968748312450241, 0.26371015148647003, -0.035849780483810462, 0.30270632129601466, 0.47728387510497872, 0.36413519920051757, -0.26906667288114194, 0.048258182155025892, -0.25185755086006711, -0.96419773868107395, 0.44701921050186499, -0.010941500814596843, 0.14902483363116972, -0.060165478779844295, -0.36264877396476264, -0.034942241027633117, -0.26716869072939392],
                             [0.18789686753659254, -0.24334241918425886, -0.061852783080355293, -0.064551504562284451, 0.0089046927589178058, 0.48276083497782157, -0.35682044479769309, -0.60815698300142851, -0.30177414616528009, 0.26428803422018521, 0.01816920341546982, 0.043454143080590854, 0.15594742394700437, 0.085375779150193565, -0.067461696867466614, 0.097499310980337026, -0.081852181779157013, 0.18035025220146109, -0.23761579948384354, 0.59178276996746826, 0.47914858460470022, 0.29570040448003088, 0.014440097311909605, 0.70011226525752024, -0.42711828643707178, 0.23210848507633089, 0.17384269132667984, -0.032876234256079613, 0.34184038802732331, 0.2169707056507722],
                             [-0.23451474559677782, -0.27793441697135529, -0.36709987535863925, -0.27702103776569914, 1.0046669061771742, 0.36237249164897711, 0.41300354866694616, -0.21021369067810999, 0.37401387396084079, -0.51083870141613408, 0.16082399250890408, -0.43996283343700004, 0.11693438301674279, 0.00060408441430059596, -0.03080070531107245, 0.08594808104523384, 0.64400694554003213, 0.026767722873684383, -0.29563140458633602, 0.024372235551354846, -0.4870212847112928, 0.24830599582234159, -0.60915249696685747, 0.02178288079779651, -0.22395669280824815, -0.43587422514897173, -0.03937831798400443, 0.17789972593327374, -0.093464830242500116, 0.37900853714051691],
                             [0.34200424878414332, 0.12074926016226246, 0.1162843886110391, -0.61043262533791998, 0.31464594999357398, -0.067743386267351935, -0.025009060406509725, 0.4020498248292193, 0.049192018392736153, -0.23726337699465047, 0.49989258481082455, -0.082499332540656597, 0.074031749206182551, 0.20190525976567317, -0.037123742661022557, -0.24162441325930673, 0.038728329847475033, -0.019317744837311385, 0.029780077241597324, 0.099933462032691864, -0.41395538614263294, 0.58656013418396513, -0.2676789562855455, 0.11631606621432297, 0.18325956704821855, -0.066549294569531819, 0.0016617421678696356, -0.26462543658253912, 0.0029068539408194016, -0.2222942767835922],
                             [0.062493234134063401, -0.14705471736646722, 0.16268031679678993, -0.50570694413710837, -0.315885542373191, -0.21584928745831813, 0.21989014647141941, -0.11568125236820878, -0.10590868343880272, 0.23727523928752273, 0.090769578004598547, -0.043390182224384288, -0.43261836741901905, -0.42974811628896337, -0.15201593923088197, -0.70992244542523952, 0.0012281015959422919, -0.2462880346545549, 0.12587183533164115, 0.089941966062344558, -0.46024926376561864, -0.46961805640120191, -0.10568122714747565, 0.81614538948896209, -0.2053651612323765, -0.079861454440999194, -0.21122907381390194, 0.040561872188878981, 0.27328081208818716, 0.024952759047150653]],
                            [[0.042641323080940555, 0.33896665793394903, 0.20788299468979768, -0.28670824219123564, 0.048976087702736065, -0.12217466912418755, 0.17418385747606938, 0.43001632993421141, -0.26556222306334359, 0.33559679533581177, 0.067805573513426781, -0.1705648697974643, 0.33249051200242385, 0.015251583932798005, -0.17506360629559134, 0.63861864260043411, 0.1879070918600553, 0.35519963094321316, 0.14221207923317369, -0.35507769147654089, -0.40199032666454432, 0.42461560808825349, -0.37225716019276966, -0.19021111462075027, 0.051916147229133819, -0.040404456920748386, -0.25121946218903135, -0.071810851440136228, -0.40948369142080732, -0.39838096357950109],
                             [0.4131266010483664, -0.13155420208554375, -0.45976203103236968, 0.00056906259353099514, -0.26083767543643793, -0.25718615685494334, 0.22995778791922825, 0.030352457971698405, -0.26591490939430107, 0.033832808165892854, 0.020827337093476284, 0.5267191022938873, 0.22141274000091873, 0.0090152421583073669, -0.4223537228315693, -0.39211553909216068, 0.49658443786887885, -0.18978199120764336, -0.038266828757347778, -0.071958460820447101, 0.18285157197270499, -0.51347793051100976, -0.50127518449335617, -0.29901583173755808, 0.27884604698471371, 0.4870435996736841, 0.031560394524736718, -0.078185085158265361, -0.10618568057800992, -0.16390246981208298],
                             [-0.45712833149441995, -0.38131230812643141, 0.1257910384330243, 0.17957031083588978, -0.21174621322203577, 0.23819721185597789, 0.21671378846016712, 0.040591494449644883, 0.58157818212252976, -0.25885234836460991, -0.40536100347975951, 0.19882056721559013, -0.034373915260443387, -0.07936309107849393, 0.050706944436386264, 0.16468787556806219, 0.19955706181754118, -0.16745055366746373, 0.10866659027371704, -0.35254439829260648, 0.27260347981961386, 0.056866860734544403, -0.079429542780854206, -0.26970947474569473, 0.093208639216583705, 0.026045378436852784, 0.14286575903923701, -0.18132442538338145, 0.25050965522612201, -0.70085637101537823],
                             [-0.11437277406868177, -0.47989235443138162, -0.3301924743090075, -0.070611726965934679, 0.17642191994916573, -0.18236419188187353, -0.14042602653311675, -0.20952811729164872, 0.16419101854666623, 0.47278890429813858, 0.14453928765857266, 0.088243599878297135, 0.11099946143938913, 0.24241180597069759, 0.06472781469280911, -0.24963672254785688, 0.5494726247303382, 0.0084611613547194986, -0.37976728708016821, -0.10510107465063508, 0.31610142139127217, 0.76319404504447441, 0.33186733827426884, 0.26369516270177962, 0.22570294172294403, -0.080720651604617444, -0.065824815227672806, -0.28578544848850929, -0.28180958367038955, 0.27019737546751493],
                             [-0.1417463093256659, -0.059893977844892053, 0.080597162862116656, 0.32737709013198757, -0.30424332100629958, -0.052050631472803685, 0.025601219757074752, 0.45608083218357165, -0.16315141916508721, 0.34076336275604069, -0.47813046029303113, 0.21336277568772374, 0.2807397880643005, -0.49405976972115417, 0.1234008164620065, -0.10695399157226072, -0.32487655010632832, -0.056486719788171456, -0.35266268110047139, 0.05245248611123321, 0.21941980426308388, -0.081169010305363068, 0.20406445351782271, 0.20179763496465133, -0.12817367546109604, 0.21148882698485758, -0.23958022463138418, 0.38725554748919522, 0.13673930233006015, -0.014712871754242282],
                             [0.038456013733129422, 0.20591629699939137, 0.28415985850623099, -0.10688087794322697, 0.058578826580883619, 0.40457215485764847, 0.10979728607912007, 0.2645044208708181, -0.044266144107636476, 0.20493380293164945, 0.082367945638192289, -0.17939383514180743, 0.13307859108777911, -0.014124447617892994, 0.82273925808348847, 0.043256781417500022, 0.015344160401078541, 0.10988668308803104, -0.1506641552807019, 0.10998338112845248, -0.054113803679997907, -0.20579828731770289, -0.21386825891758554, 0.028398466781611925, 0.46013405356725162, 0.063735782087633183, 0.27547267413152532, -0.37661867261422882, 0.1927207604014663, 0.22275269450510321],
                             [-0.28476731695155144, -0.090701427998056833, -0.18566025316212914, -0.085468584189400468, 0.39285469359221908, 0.52216779368874799, -0.15253438927964164, 0.41406189555862594, -0.0035377827022589261, 0.14591291963591399, 0.48493877648668532, 0.023775166889408172, 0.16528483245650599, -0.50747868188693623, -0.34629483292343982, 0.078313875205266045, 0.13393214771645648, -0.62041392114397509, -0.27122808113577745, 0.20463110711469443, 0.029509121174574104, 0.24567670007824824, -0.14789114196785208, 0.0027074201385904628, -0.24283292060722883, -0.013522278280406646, 0.15559799651466735, -0.27766900823426766, -0.10048514310079479, -0.012988667230233113],
                             [-0.46725253102508585, -0.20050642260238463, -0.11537392737771282, -0.42308217014340127, -0.24623026467618608, -0.35173414029819283, 0.1586786785916561, 0.32425744429120823, -0.059424704680807613, 0.038695165477984871, -0.031188766311595496, -0.36371852317361014, -0.29856712712468797, -0.17960632879936114, -0.23658137622935274, 0.20742435880432963, -0.21387929081969481, -0.19630236207137408, -0.40534625925940604, -0.12225740999861318, -0.40147565646230621, -0.16662299053132898, 0.49326785330949102, 0.1617949104135635, 0.3182366761953041, 0.30828972645390396, 0.45196831863829368, -0.17853456760946701, -0.00096058161385956936, -0.081946138793291712],
                             [0.12289835978731231, -0.057107157801173217, -0.20154360669764279, 0.0056040027191171533, 0.41498377741132181, 0.54323242017894335, -0.06469683167856824, 0.0052783046282470075, -0.72397951625056922, 0.1448400709147023, -0.25993155210641122, -0.3404859681058115, 0.10522375703628116, 0.10034868213516637, -0.071177398674625886, 0.019220343736021696, -0.061844523243251591, -0.13696436876743057, 0.60049581073071945, 0.090553691974812917, 0.32637460671790247, 0.042136717960938416, 0.34491273410690643, 0.01927228326335613, 0.19729933858859239, 0.76067676575740695, -0.26446100851396737, 0.092945592432295804, 0.15373618841095682, -0.060186112984704332],
                             [-0.30264244700085946, 0.52242231290326646, -0.37765315818475886, 0.14022385160353049, 0.0028373125308319468, -0.11987640672082193, -0.11451636149161341, -0.20103068173573999, 0.19980720834330992, -0.33615157771107285, -0.29474597987222861, -0.24761448549944923, 0.082668664094832381, -0.31035728629600201, -0.18402779255930493, 0.32513682091355411, 0.52883345946962534, 0.19256772726285878, 0.061759108302694932, 0.85564422376372473, -0.068665834832886297, 0.037985850069404602, 0.040910660063291124, -0.15498726271297858, 0.23359621423367385, 0.13384566657614241, 0.0080964274685842857, -0.2414788249218956, 0.10431002156985596, -0.054434258239630329],
                             [0.16468669782526141, -0.39820992518321963, 0.096153762448765223, 0.24069776179491936, 0.050384847366795889, 0.41178407266134903, -0.25854465477152877, -0.33049383107886166, -0.39851904058475285, -0.12230633929966589, -0.49379715932155738, 0.31232226023392889, -0.30457511542456234, 0.13061482855506934, -0.17523008324829648, 0.11666020968707963, 0.10777861446199549, 0.16044998051872736, -0.12670463079564317, 0.088287640304046733, -0.3142538813916273, -0.16461084747842089, -0.11753647711043944, 0.20962647680319377, -0.065255218532736831, -0.18087036219479316, 0.027165186170737453, -0.2497659617075754, -0.75767006670669046, -0.013715073723012476],
                             [0.10042775918198285, 0.098186666249201623, -0.74757036368984364, 0.0011088534719316846, 0.10980206650298863, 0.26598676326726028, 0.054357424136972615, 0.616960390436599, 0.25205599030578996, 0.2919672275787073, -0.48354300393338262, 0.13717671558959549, -0.43319610849749657, 0.66178990771405521, -0.21621859229387208, 0.14248358319366516, -0.021688634614824343, 0.15629154122463776, -0.10388174826119234, 0.126875124029768, 0.01471979991118294, -0.02871059225223957, 0.058905808409367495, -0.094100096894342636, -0.16843326685320748, -0.15004192442755776, 0.16391103498651441, 0.3431563473720754, 0.076776090632126842, -0.019741612351107395],
                             [0.51068757505675311, -0.060817405322901016, 0.081647548217310906, 0.0078484583619517455, -0.25049904463885381, 0.17103680734995705, -0.12646976286825529, 0.087105854601588151, 0.29876482321601139, 0.74134059663553675, 0.072622185221345448, 0.16388348717992413, -0.39311822372489569, -0.52447140774149403, -0.16763911021092817, -0.20712757417080163, 0.012162796242892484, 0.30282691517046234, 0.21031078460516356, 0.21480480759169332, -0.063199954355019961, 0.085750930521307361, 0.45288647455878833, 0.27832679285176265, 0.15485911788791987, 0.13123150041741571, 0.28362933406890029, -0.12126626754001671, -0.36438283498472662, -0.35044633887360177],
                             [-0.40831585929183789, -0.21083733935991772, 0.35669878462560511, 0.54129147273832312, -0.2125625539878529, 0.15877271984451063, 0.010921025239314958, -0.11774526334551164, -0.1794282048427753, 0.49315596887246826, 0.096556901981735582, -0.41349591777730582, -0.1476582801390656, 0.36064474314755496, -0.56163128307293408, 0.23824009519662326, 0.052204401130156404, 0.026393850846032525, -0.11809071545296079, -0.02419483981678305, 0.47671637387332921, -0.42905312050108113, -0.1511275194910057, -0.15955190822412593, 0.28295600375637392, -0.49276428117741844, 0.044410144821569353, -0.089748728888514401, 0.11377958082452896, -0.22851185473482277],
                             [-0.18906439101773004, -0.12551125141578429, 0.29493747367590895, -0.22278322038970055, 0.35935136145168256, -0.43786639636213492, -0.054216125896532845, 0.29786978620537774, -0.27297675120608589, -0.095335874390369391, -0.12252365660614833, 0.26801785344075102, 0.22661266511274167, 0.2006091745224477, -0.072279274790632342, -0.32782861295034432, 0.074174185031436551, -0.10433034942028346, 0.33100121539393312, 0.32555715655982292, 0.11960642027269711, 0.33403485170931002, -0.17081894357838179, 0.20109749626991225, 0.28749956049617714, -0.087487113735970706, 0.61409822005421577, 0.25136932857295763, -0.064458514811954623, 0.037304540921572406],
                             [0.55167110412357456, 0.0558062356549371, 0.1590614526564928, 0.11910221762176716, -0.65414431928302486, -0.12239461812077584, -0.046565350004238427, -0.0025988012721247372, 0.31556794238120023, -0.35491613153759405, -0.18480716327256899, -0.17166762894710508, -0.074726944044076107, 0.29460549423335503, 0.042199561067616936, 0.23886642386369869, -0.106752060584344, -0.63045865965997228, 0.27329858117671674, 0.13055639987352258, 0.033922723875496753, 0.6146003017938042, -0.044032108592638911, 0.34653116180161114, 0.2201729576965786, -0.31585389988378682, 0.10133082843098176, -0.19444136223698935, -0.10765650801110932, 0.1395893937431224],
                             [0.36552769875834962, -0.36488031176284741, 0.063665125932357278, 0.26056493607122327, 0.32447274437168971, -0.047186966593093599, 0.82083446285705275, 0.03874575309519615, -0.056900755910227994, -0.33618667879735176, 0.20432060535959973, 0.2955589370190202, -0.019500735752438901, -0.31182240102947428, -0.20762047188949334, 0.30556190840032282, 0.28581210361768628, 0.12019166181969784, 0.030149387103824705, 0.19420282451079318, -0.19955652590085593, -0.065697277186518063, 0.1171540144830665, 0.029404904941521939, 0.46714646252745823, -0.19048299398051827, -0.10648610414226287, 0.099412743299240144, 0.22634480268210677, 0.25303460903884656],
                             [-0.0008244699323972926, 0.14858057403230568, -0.16316741121628409, -0.25805297451313408, 0.039341515449700756, 0.10572610601728002, 0.18781952496640597, 0.33100937623460919, -0.41798328992602468, -0.40394955407741179, -0.32145548638522375, -0.20314033257373543, 0.051925486577165648, -0.021131362176106026, -0.29436913266557213, -0.44228690296358214, 0.045170517877908101, 0.52398028682351261, 0.041635618703079129, -0.23799564045337743, 0.41902745817378451, 0.31597470672947842, 0.080530817714855707, -0.14794038263829637, -0.053055531373542485, -0.63968274045632001, -0.40030099984958256, -0.44784738543368185, 0.32181248108377691, 0.14373285242073292],
                             [-0.19959415047838458, -0.41977855839725392, -0.22737748854533132, -0.2579676000783665, -0.066205736989763175, -0.14585286819946913, 0.192212053822097, 0.27608506515036596, -0.34361601038677048, 0.0040023189463681795, 0.11518212665149623, 0.20956881225782606, 0.43824964190747556, 0.12421632488101604, 0.39280911395280671, 0.071523823226515057, 0.03971104817289909, -0.13230420229517151, 0.4599985453674858, 0.58734004479442659, 0.0033327002926386365, -0.14272428299392784, 0.3419160879649441, -0.32155440541327479, -0.25278671943453584, -0.24956976932139641, -0.14576375432333274, -0.29151308255744918, -0.14731059322746395, -0.11167206255770136],
                             [0.073438478891106884, -0.013934696112437374, -0.21557692278962898, 0.54526069195697979, 0.19010166587130006, 0.026681388132421324, 0.76883428814112909, -0.057101527122821669, -0.015551430159683594, 0.0286078672345128, 0.17860710262973378, -0.29800714149069751, 0.40447627826639609, -0.12105463446418605, 0.39432525252060646, -0.48666072536488458, -0.516057151241756, 0.29850900015480125, 0.040431113920236655, 0.043763986076225128, 0.012803165655060393, 0.01667381999393544, 0.023394295360950407, 0.18549826350597973, -0.012198149669131488, -0.090802859717389287, 0.52726882925054641, -0.14822776596263454, -0.33955272519523655, -0.31087296906497947],
                             [-0.27233919149968389, 0.23425446135754674, -0.24868780916471422, 0.23148407367179444, 0.38718736058744868, -0.089354384259018996, -0.27195013318600891, 0.094422201874370143, 0.35876070853667247, -0.020549483702767567, -0.35853753905569108, 0.1600859202858726, -0.23154220491373292, -0.19545767565803987, -0.11731662586127098, -0.14177609247932665, -0.42088925390822352, -0.39510316843938614, 0.47467100580918026, -0.10607131229301367, -0.18636751342280239, -0.12603922367548281, 0.024059933055043278, -0.41123208942859718, 0.69365463660895477, 0.095038851199437058, -0.38681701707663779, -0.22663162347467811, -0.1076217738282917, 0.30394405490060872],
                             [0.39758529293303185, -0.059362660115214877, -0.046919023360892875, 0.2989479323569984, -0.080820112103268449, -0.00070174495334021821, -0.50279744726305187, 0.10788073852202551, -0.073848918759142179, -0.27444145810647103, 0.27178841028076606, 0.23418422669808711, 0.51706640771081402, 0.15151655677865211, -0.2929298916620921, 0.18034039944988772, -0.24814250590073503, 0.30911704303837351, -0.15758718492661647, -0.01762649293644767, -0.19811254870868586, 0.060137810444539981, 0.29115859471448796, -0.21269930011788751, 0.1834362365142185, -0.13676438601647681, 0.40994988996696557, -0.058831158866715666, 0.34013944646547373, -0.25493086661217401],
                             [0.15230533037333044, -0.3088979496953172, -0.26375729212315518, -0.26291952867016039, 0.12754574355637521, -0.14737108043351477, -0.48860093957999212, -0.21976478842692226, -0.23154703332161936, 0.12387878349292311, -0.035870309190789117, -0.047749358364884614, -0.067312513610936375, -0.3634788172003916, 0.22959631893981883, -0.058759650442637923, -0.023403545102619879, -0.18708698589009032, -0.23028765215867578, -0.11008226592150581, 0.021997103116866396, -0.053519999645248173, -0.48166555083071672, 0.33287133538673658, 0.27739022676814812, -0.29051713580002381, -0.3777124948827395, 0.00084620763323773815, 0.44876381025572443, -0.69209079704545573],
                             [0.035599744517052778, 0.32443275827064372, -0.24915693483389018, -0.39655478513307102, -0.072861785802003004, 0.070885011746651974, 0.16144746505143923, -0.50737976509684968, -0.082870572660636063, 0.29147759268290169, -0.16348695185777132, 0.59012314877829652, 0.36746168106160071, 0.17290821308947352, -0.31237181718204998, 0.19693944782335762, -0.45751495292522709, 0.077593985131285667, 0.10768744330810434, -0.023081477076508799, -0.0017596415916868308, -0.12506648931997422, -0.13450294166205579, 0.68802466370009041, -0.089943433571490178, -0.052466116630040374, 0.051390409731024822, -0.18158280542258631, 0.27993287355381435, -0.022348450131765233],
                             [0.27830169292762486, -0.29658376869331204, 0.28481301885080934, -0.40335491079120001, 0.35313153439569778, -0.17737832041093118, -0.21721943083436263, -0.029070354494494369, 0.57463221063052139, -0.13290470358226125, -0.06907067891196593, -0.45721625471346289, 0.46698076158287416, 0.19532204053553276, -0.26910700867198051, -0.022621563580557714, -0.099692384010964197, 0.29641827530534653, -0.055350465292716061, -0.068778089783580992, 0.12795044945274769, -0.23239386990358096, -0.060510187396186799, 0.40795676410344484, 0.089072560368774784, 0.25432418474406271, -0.16126240414334261, -0.17776366692805126, -0.20574365376873849, -0.042848273629132724],
                             [-0.16664710421375592, -0.5711561405834864, -0.078958249808369532, 0.22637326507412445, -0.29568167093439024, 0.17236343087050029, -0.050867166300783556, 0.06333095923675558, 0.086159154126684914, 0.25085961779672494, 0.22820788474869907, -0.10754952971263891, -0.23205085805439421, 0.051632837249758368, -0.20729198650661351, -0.20649271220696208, -0.28772200854045604, 0.42329432589288352, 0.20672416471732555, 0.33245624949980923, -0.25940161992727095, 0.38233036002338494, -0.67596510886907701, 0.029278318502800334, 0.016660104193406855, 0.42984030069342122, -0.23311164958215957, -0.30975780046987311, 0.2005055954915716, 0.24832166333543337],
                             [0.2155437748509379, -0.023811384227909543, -0.20435782638591254, -0.24730627933959706, 0.1445322348811223, -0.23219934353756169, -0.13312718544671623, -0.27772478460806505, -0.070956239073874022, 0.22960653683956925, 0.023062766983891706, 0.13205420374341556, -0.14061761486519356, -0.19108453952027304, 0.053321298559996781, 0.55530199568073468, -0.40713017180700772, 0.18117716452482191, -0.19022743663747357, 0.16044390798520575, 0.63611903648756507, -0.012927784512837742, -0.2387382458761157, -0.66286177553927672, -0.13448788500883047, 0.056989111290480121, 0.30758639792141323, 0.07015030777400659, -0.19384990223261278, 0.11617294098034264],
                             [0.15837641125310536, -0.033753416372681519, 0.53079894482193257, -0.33579092512354708, -0.0021283865841592448, 0.020160698123997272, 0.22248250424193983, -0.21296706448666292, 0.21168393796156434, 0.41083549413470988, -0.063214354845322021, 0.0055311344291267758, 0.1340642065333193, 0.14529735997093784, -0.054509415317975568, -0.32376962763297651, -0.0052179050488601365, -0.48165221334615643, -0.60152623593569365, 0.55579947613523184, -0.19901254112921662, 0.28172111132744088, 0.081912730275173914, -0.56615464055907738, -0.07776926127272607, 0.11053318913768156, -0.20234991464469543, -0.026212023713808645, 0.30946298620074292, -0.11104752764337708],
                             [0.34590336816972439, -0.29510872939916222, -0.052477273837028292, 0.056501076212762347, 0.043041971446825811, -0.021814819106816302, -0.15719756140479083, -0.35358048522276903, -0.026348973526677196, 0.40870804893537688, -0.40600502590352822, -0.32698907663192645, 0.4144582098824674, -0.42636438915368313, -0.019624263829653904, -0.00064026464687379474, 0.23192449131676493, -0.044802120175092629, 0.29155454129646113, -0.16538473117635016, -0.3224306594747649, -0.063263132214948975, -0.216451373372885, -0.44763511356716745, -0.34568121208943475, -0.28005962583754812, 0.41245760496336203, 0.19147376322522736, 0.31783306232403319, 0.54774351678533983],
                             [0.11921038600211141, 0.15388163159917317, 0.13377396856719517, 0.65168692885265611, 0.23546561602061561, -0.45771852285058318, 0.13396970110356821, 0.1756744860811954, -0.0024348780857090559, 0.19658177166070187, -0.17229946532945062, 0.21189113968579304, -0.32578959462341578, 0.1558096682248345, 0.061861043793784286, -0.11535968713131348, 0.016007061821535926, -0.18579273486569356, -0.13959219020031058, -0.097045899770126218, -0.077926081767918154, -0.20121013627104306, 0.0263873375135808, 0.058874115951964685, -0.56475689374270055, -0.0074479662559769639, 0.21829818782088339, -0.53714897803611761, 0.23891073864841772, -0.013237024736422503]],
                            [[-0.19627164314691026, -0.33831944797654601, 1.0342135018418661, -0.43208645418794128, -0.41697571069722028, 0.45393849283505017, 0.26599432986049049, -0.47184729304527118, 0.61818849155154476, 0.6317160277703826, -0.10899194229958499, 0.17869356813120282, -0.087525089949905405, 0.16643870326188864, -0.34247118408498628, -0.10451216921747505, -0.039455791630080075, 0.080180700652381171, -0.42474230176209826, -0.05652041275983731, -0.024930915249134825, 0.17003170688574326, -0.12623983989360971, 0.18261014914133875, -0.58957224404495545, 0.1081875677649466, 0.45195342748011469, 0.31188324120901517, -0.46980821926504124, 0.3150352209482668],
                             [-0.2959585303308514, 0.42199391711725592, 0.033678658747409509, -0.46222176426741846, 0.1399288994799581, 0.28153439278831827, -0.67347522870093346, -0.081733176735685087, -0.33491537202456023, -0.30048499179881427, -0.18565951225494987, 0.13509400247480408, 0.36727424521225377, -0.52687334873282621, 0.23767869513957407, 0.51664982279938521, 0.507791747247887, 0.28474577221601294, 0.032179870277504782, -0.5129448744581534, 0.11776308494512498, 0.26498114979112358, 0.30662785256815567, 0.18534353938740011, -0.19625669445315722, 0.32204121544477188, -0.088065610000208433, -0.6265799671668062, -0.48210775032524544, 0.10268634014056821],
                             [-0.51248635814750698, 0.010448626392486686, 0.25612823338781593, -0.38314969632051271, 0.10029500986067774, -0.72489383938817853, -0.24420288496364762, -0.17347630887344032, -0.20640307019952392, 0.32376018536146306, 0.53680957993339096, 0.14547765255594297, -0.35997001241068671, -0.30597149525191297, 0.23446133471574684, -0.37291323356062167, -0.61994941714910667, 0.19452618711466152, 0.22940241083969859, -0.30893845310484253, -0.26063993133970115, -0.69446682516901037, 0.25248200833411938, 0.50212076223028879, -0.19266366126562429, -0.010366638439943232, -0.45128298364035996, 0.16565084259293611, 0.7186355921727271, -0.037718051283106804],
                             [-1.2327412259895636, 0.24136684869746375, 0.3348766743098216, 0.37970008327464716, -0.16212695086924656, 0.11261982412792515, -0.019301551595748798, 0.86236840468247133, 0.17529018668876073, -0.35246163374501482, -0.26048087296135303, 1.1233976034515845, -0.44017111317861685, -0.382491650816707, 0.26306642070088332, 0.042217749845567573, -0.43316281549088015, -0.19949664567972125, -0.30454963288457676, -0.13375086968060734, 0.0035108377531260365, -0.45549536588168821, 0.0080014750876248458, -0.0027160193400705968, -0.052485794836140076, -0.16307328668161294, -0.3817684583461865, 0.43991121364432778, -0.7065944799197853, -0.25263348498375066],
                             [0.22321196832742557, -0.11842966064369168, 0.30886550063197532, 0.094715659196346336, 0.14879994291046361, -0.36977779480174511, -0.42555722759740877, -0.054860256408528756, -0.41748468109583459, -0.57287876926864101, 0.22515194603929234, 0.047997420157037972, 0.21734666493057198, 0.67244020370851831, 0.30722080704918431, -0.064282947587209247, -0.3188867250765105, -0.35440069477880459, 0.011649716901907803, -0.2077854633445651, -0.25270882990188398, 0.064548958782149682, -0.78160111695117618, -0.063115894419003532, 0.70298968184245192, 0.097199306696830579, -0.036615450923445439, 0.38241307288320808, -0.54102998489942555, 0.84962423576827462],
                             [0.42500228169689247, -0.072394792686732753, -0.1321794154818707, 0.08077294507024789, -0.65909376578153811, -0.35256333670854578, 0.12941354390495799, -0.16959194816545811, 0.030529558144917691, -0.1601914875715795, 0.12937195451847841, -0.25790804751086388, 0.20405949680421395, 0.4577259456561194, 0.13946040044906705, -0.68543269478303437, 0.9129825759074176, 0.68185899231647151, 0.037281498130814675, -0.22355133330273411, 0.44072428956518622, -0.10103082714717476, 0.086905912114068312, 0.0017128134342910481, -0.26068560305198502, 0.27180390362339379, 0.36136536009144371, -0.30475814534403056, -0.070602295647201538, 0.16356385662944267],
                             [0.31705644402391098, 0.014716723306309312, 0.50682432614781747, 0.54820649028978707, 0.013163925105959234, -0.46616184038309999, -0.023232788011788963, -0.4367379628131306, -0.20857907928321806, -0.17252311549033594, -0.10499103211460087, -0.11402434113691903, -0.73561910233742345, -0.23306639583606628, -0.36323256343085691, 0.25909283394954119, -0.031916855904620109, -0.57097562079541964, -0.64151538680993347, -0.54195800391074589, -0.20946824642337528, -0.73411877663798786, 0.1393869890407104, -0.63223078184108661, -0.58285888028969368, 0.52056923544264611, -0.41985051692562003, 0.098587822710376555, -0.070181876776288205, -0.053561397572079256],
                             [0.087842651470107072, 0.75697460417124041, 0.64743229605407926, -0.35889299074546926, -0.49144655303409412, 0.51224601766113864, -0.2455462193822682, 0.32472725860432872, -0.2388405210964302, -0.26564016824331088, 0.37915429203055789, 0.0094658027599339029, 0.047720807324189533, -0.22086950992908658, -0.44136908393764379, -0.22728850210747303, 0.0063807200293694022, -0.074449385438143653, -0.25438576411721897, -0.50565452346529993, -0.13832100873001968, 0.41016987452231984, -0.21628923132291322, -0.047482438728799009, 0.075120839297666497, -0.1218208996164514, 0.3466262501749996, -0.16555368304424989, 0.62178757363570858, -0.17448872944375479],
                             [-0.51928699950348234, 0.016814644510590841, -0.42657881659872454, 0.026164492537863165, -0.25618617166917101, 0.064710666059637573, 0.31457074259701834, 0.14047913351860869, 0.025294576407220187, -0.27391655199844395, -0.76528185961633599, 0.043458404482720092, 0.11548196304986877, 0.060256045483837409, 0.26484553781539893, -0.041616898230888419, 0.49808392911930433, 0.60647456078787132, -0.21627069222443679, -0.35226604278768309, -0.92367729700551016, -0.077735166101141173, -0.39835396512833832, 0.28897855567548036, 0.13320453114599268, 0.73986967627712741, -0.24153876349614106, 0.90246390833495516, 0.37478431703815085, -0.17626822559439523],
                             [-0.01914167934021356, 0.58483838734198657, 0.15414948803691722, -0.013776975875068546, 0.021778681898360588, 0.87313229570368245, 0.67756625521800007, -0.66004775540771399, -0.3052310268597952, -0.29320873818814897, -0.53273683122899962, -0.3804056996040226, -0.11511637143935752, 0.084345715029225082, 0.38625934056245437, -0.11311012472060225, -0.55516043665652703, 0.10828554325501255, 0.67219492883697907, -0.045271463753837768, 0.050803035815768477, -0.011036535627398418, 0.04771334193875057, 0.1243889813651648, 0.015763528509956687, -0.22302943294414046, 0.056245828433641044, 0.17306333738272278, -0.39609587392120521, 0.12890228941384341],
                             [0.34281143881386827, 0.0017065830413624358, 0.10477970996163678, 0.12180080664719342, 0.75445047162319856, 0.11101024851052471, -0.42242853476114939, -0.27422198972171735, 0.77944181642907151, -0.095639688939817183, -0.10163896926595781, 0.065552589192531457, 0.12880148811157363, 0.15353397385520395, -0.094226080831071868, -0.3413404205728971, 0.54578330760267491, -0.27678457506224829, 0.12532655654826824, -0.37127607342789426, -0.15201890992502209, -0.02049151540109985, 0.76463319046465239, -0.1313967297662143, 0.036838319615888793, -0.44368868362971597, 0.79300920314177759, 0.29974110603059151, -0.43978217307707035, -0.37644841742565655],
                             [0.31404090338544705, 0.36858793044567301, -0.69420688775052453, -0.092234803170720123, -0.34975853881723695, 0.034629147009454742, -0.56776684004528144, -0.20208778960275647, -0.3966840899835089, 0.14426599517355906, 0.16873540019617733, 0.17242923627409815, -0.18728507475759992, 0.12744236850970675, 0.036887573075197966, 0.22572937475333552, -0.055951103738856353, 0.26297609864637828, 0.053233574392681844, -0.066280001355348325, -0.29425064035733922, 0.34000048729780563, 0.19455897816827056, -0.15167891603738642, -0.71355502443606755, -0.084937759912075098, 0.098398005507694411, 0.74471700295443211, -0.16262293367081293, -0.51539340018727386],
                             [-0.22208382748805189, 0.04985895733821176, 0.11178974146575242, -0.2639697328817297, -0.19934498787465404, -0.4359801883799469, 0.15693690436463878, 0.52808022582364, -0.75318703046687097, 0.26408623699421319, -0.59447910277455196, -0.34623480244809118, -0.33177233283480984, 0.33422710312040355, -0.48263271169397892, 0.23044049999513566, -0.10418469243102345, -0.04560331871161788, -0.19158839571710545, 0.0083084213913213727, -0.63901981357204729, 0.20713977835711495, 0.76429162086948776, -0.16240387368874076, 0.1969062231452009, -0.75539146171037286, 0.19313480558142759, -0.033075335067449141, -0.696563363734507, 0.51634330500651382],
                             [0.089250910786615512, 0.61628444221831979, -0.45380231934787679, 0.021165728184441443, 0.20735185508255299, -0.011663161348371386, -0.037541937746935053, -0.69585181307457089, -0.34065948884867348, 0.14466660300400216, -0.26581084304640934, 0.22324601838526223, -0.15723217151379457, -0.4563336930018852, -0.16504071758596395, -0.59661187281004102, 0.080469458285637049, 0.41566410412696331, -0.47818731310449464, -0.36312869641781664, -0.30620851223043816, 0.16909175352859104, -0.40317805639772747, -0.18874253189181131, 0.14398528742071134, -0.26042941474691345, -0.14426501879500531, -0.025943685232342625, 0.049621958082479982, 0.19675668343910319],
                             [0.35606467555205823, -0.21705066199630729, -0.022928900559074594, -0.71036406181892042, 0.29300907533522735, -0.50440391198279555, 0.61885362486216799, 0.23502905773547159, 0.024446953560476103, -0.086119932497085286, -0.32753541528153723, 0.26876187286506703, 0.040990869429344032, -0.15857767285484478, -0.17337802149562581, -0.071099468087633039, -0.52443293192357221, 0.40731582422754414, -0.22857545713709226, 0.082302604438729804, 0.28455807113554182, 0.22222423735296223, 0.39380283417094242, 0.063771730009110045, -0.13678431981177971, 0.50001023811025946, -0.27593111201342024, 0.19999827647244064, -0.67697839349032818, -0.43548426545463931],
                             [-0.59218140586091739, -0.24594877620849204, -0.50350513094155458, -0.2874549291464753, -0.373640591402432, 0.25284122057092889, 0.48446485170042897, 0.14420932742603956, 0.01343998817341021, 0.51805403931671712, 0.7613634091158562, -0.3342230131756565, -0.095856344612712724, 0.32570249840929455, 0.24446937208172517, 0.27822654414706749, 0.34913449783204831, -0.36781210653686869, -0.19684654108936395, -0.91299843287104676, 0.14198087537422299, 0.58016370809677054, 0.14550009353486096, -0.44927004849530561, 0.25557896143788361, -0.083651496959981919, -0.81933220630602632, 0.31348870448974681, -0.058039272059941832, 0.14132296295180125],
                             [-0.53566223861884865, 0.69406506735274576, 0.079545348975186753, 0.11064051018538504, 0.011512733892854621, -0.039149340501734652, 0.2197327156563196, 0.40141762628601091, 0.045240035586472271, -0.19067263820153876, 0.1705281517641806, -0.43634382355424173, -0.1918474470081718, 0.091055922970653, -0.59034440679447653, -0.10165442978908147, 0.21738146192271574, 0.14040441873815163, 0.46377835365746412, 0.46394573852266097, -0.049460863896396437, 0.2890533942076367, 0.098691641713090555, -0.043585895162797261, -0.18511448311510773, 0.25498048040002991, -0.56013836293039787, -0.14872896240408534, -0.84803140493707518, -0.10689267470379192],
                             [-0.64716714249677032, -0.18947372411920577, 0.011519621054438572, 0.40508118933576381, -0.15949003272208359, -0.56371581720060981, 0.18408737788634844, -0.35336353779165713, -0.66425197138568204, 0.16344532990954141, -0.23036973007697836, 0.19867143014351135, 0.91267992855216473, -0.44236636313027961, 0.013683358343309349, 0.56201486135860479, -0.00011594244349606014, -0.02546674571197274, -0.09147155608919208, -0.035147459451379627, 0.27207831013636541, 0.30498680739447803, -0.20577020010423014, -0.34221735689693455, 0.56239885239819787, 0.27702795846905154, 0.2314549172420024, 0.14136679795637308, -0.02215399123389486, -0.57002107201312968],
                             [0.32781953919380558, 0.099622863370008072, 0.22175323263661514, 0.31710520693712801, -0.10102082268578579, 0.028055338200626466, 0.40776550044205295, 0.35000568664967346, -0.13661914096951236, 0.030664645014523109, 0.37844577839631366, -0.42019828672031778, -0.050331052924819382, -0.85615242202564912, 0.42384843906790171, -0.29319062161226195, 0.53537905588932599, -0.084437690893812548, 0.60383111788021571, -0.018422734417130274, -0.61126442082620369, -0.67452615054928167, -0.27623214853177103, -0.19167192351327667, 0.091892927500696692, 0.43426310599108831, 0.48389587486886171, 0.54841433385370886, -0.47703451379224393, 0.22947357359140702],
                             [0.29897516701975224, 0.16855178281842684, 0.18237011598279229, 0.16792537175486066, -0.20659149334876434, -0.23083383413916853, 0.48578241911424369, -0.32439003953083284, 0.24312625664436083, -0.10579605108141427, 0.2934220859993662, 0.057122730264879615, 0.40623190857904845, 0.12613527500545638, 0.8795810788277062, 0.15369335937643827, -0.57550149587539889, 0.4262820415268071, -0.35735683495559939, 0.096928482311482003, -0.59573212150257593, -0.15876545829786642, -0.1764497268342855, 0.065515062193237439, 0.22693005327272631, -0.13382253327769122, -0.029543551350957376, -0.54284878170252959, -0.16215736297961864, -0.58375725014651847],
                             [-0.4478077695032342, -0.17403845069362558, -0.20283392429356512, 0.17723518336970362, 0.70607521380124194, 0.13135302128213738, 0.44074031210651637, -0.11075186271231496, -0.2179523330944588, -0.9513345868457499, 1.1073910807013414, 0.031437729391065122, -0.01336101197738282, -0.30463102604784703, -0.27789170411187131, 0.46588528435435667, -0.066876836274721629, 0.48173938987459042, -0.04997895889745993, -0.10569472225530939, 0.25679924110245839, -0.076088546322145151, -0.26693651451580519, 0.21995346745858685, -0.22254048975321539, -0.17228316689595052, 0.40414255703149626, 0.32752959458245129, 0.39995236505529536, -0.48677610067627497],
                             [-0.14381023514595576, 0.041593174281905523, 0.48347177815749109, -0.34264574094437739, 0.030807240298997531, -0.31243609805682621, -0.10812689173192429, -0.14830565132047946, -0.10704982141534385, -0.2533895735565096, -0.1997163540229214, -0.46092011165003183, 0.22682074859072388, -0.39339402236223009, 0.25850346738404001, -0.2727597739484296, 0.10241418645065307, 0.50709165753053387, -0.21905406711781644, 0.28896905749184887, 0.2258870481051575, 0.0052073717375536732, -0.23948887077557685, -0.41947685104247939, -0.25739256953774664, -0.63475095225079681, -0.22586451026387153, 0.21113889762037474, 0.17718772312719785, 0.15383972907501908],
                             [-0.078188572544602208, -0.24194239150834487, 0.18960568834750935, -0.20064766362927905, -0.64776483288718123, 0.0022781869266776528, -0.091144723333396613, 0.030979611295668612, 0.39066238440494166, -0.37748340040280826, -0.26004792262570114, -0.28866598251310294, -0.73597586493537448, -0.29041242534894496, 0.032029220688865698, -0.032136530804930549, 0.11755133002128254, 0.19318609055836136, 0.19853593700005956, 0.11448392092032081, 0.33116101339450965, -0.42360042097253509, -0.28690726732994343, 0.51691959319596092, 0.52296466041551526, -0.3826300872768621, -0.0021567964554225147, 0.30553738172538147, -0.21893303357398475, -0.69190544324595715],
                             [0.26185531538639467, 1.2281077551571895, 0.36938641781686277, -0.38496192374936111, 0.52849419604934467, -0.35242213946119488, -0.089600631580900938, -0.29446800156912067, 0.47001033155855421, 0.25762891440900926, 0.29752087820478412, 0.011256269988390539, -0.23626287744194946, 0.22981308850436957, 0.10257792192499567, 0.63503082959960955, -0.30783332648357969, 0.14748883649757116, -0.032027325847631301, -0.014769627882688006, 0.10269619875764031, -0.46157435762639992, -0.049874769198752861, 0.13123629920370375, 0.2793363999068631, -0.26820123778249794, 0.67720264951339404, 0.65086038407446534, 0.47460686959933546, 0.18725013590318668],
                             [-0.17416531257779094, 0.33476800200616874, -0.2415581790318313, 0.14534644435282401, -0.26956387376375257, -0.54068582911906871, 0.092094922189610129, -0.20468351114723676, 0.16858787675553383, -0.11675027801301224, -0.006203585983523302, -0.051030681597255739, 0.06192712831030605, -0.024904047046276263, 0.13335765624061233, 0.27331778283655328, -0.020896737810022381, -0.81765983058685465, -0.24080425572346253, 0.305029832767093, -0.038976158845388305, 0.065414787308119129, 0.20587411308779147, 0.73508780166146992, -0.012252944822857506, 0.15041450865210626, -0.057051485223701966, -0.0019661901324051333, 0.28436028214067777, 0.16733325637982011],
                             [0.27536286836432644, -0.0706014551169592, 0.35578266761310184, 0.26534440550597393, 0.1514997101976695, -0.16349717120444676, 0.28337581498273023, 0.053206355658525384, 0.099593283608442967, 0.1951536882226329, -0.21965796037066149, 0.41258813160741664, -0.55840246351298939, -0.12442606920498636, 0.30072749915107477, 0.29133879935476986, 0.97208634669902028, -0.31093603177553558, 0.2414907985013951, -0.21804630318146997, -0.016494674745510168, 0.26612936688941269, -0.27164184506318939, 0.26748802883787337, -0.2559043179740384, -0.30738454394744436, -0.51811418450172941, -0.12835256781428528, 0.30013789888518999, -0.16945438230123994],
                             [0.2595038055616431, -0.1365477346820598, -0.37310830327257294, -0.63807799403237897, -0.42352083349744063, -0.063642649276330371, 0.67746643845937171, -0.17387600721357988, 0.14701769166271256, -0.17804755768696112, -0.091962614595735348, 0.4433347083611312, -0.091598871644411231, 0.4128600300824401, -0.39721492036944533, -0.088901028473144655, 0.21351278518018035, -0.42501251657856265, 0.55054485057782121, -0.20926043057276195, -0.21094781587508138, -0.27329255298020871, -0.40142763528205505, -0.53301783869977637, -0.33451638564806729, -0.20528945926245248, -0.26435875337159115, -0.15243413127251668, -0.1704290880714559, 0.14938206677801619],
                             [-0.015879820256728884, 0.039054895490472856, 0.38812838900282692, 0.0996663717726817, -0.168858174432689, -0.61575558518747731, -0.029345792494989593, -0.20145462844799428, 0.3333855724408169, -0.13338754133069314, -0.038014247946423836, 0.38832970619810142, -0.94831713536810103, -0.25028003788294623, 0.3127024041661246, 0.076174585801898287, -0.26918839460692018, -0.13272403222083071, 0.43560661556651747, 0.41864374837752982, -0.31491952402350321, 0.68682223446709623, 0.24619600081781692, -0.87922608871353247, 0.26865217684166648, 0.081168983946658377, 0.066314155837883651, -0.13527055153117068, 0.079776437604328093, 0.52006222135259728],
                             [-0.055221235518790331, 0.38067271829272403, 0.23509625426855144, -0.27762830178937414, 0.4395268135692959, 0.55265209662813941, -0.18052889295231073, -0.34028741006835794, -0.34818175609337942, 0.10177525022103014, 0.06895386850973681, 0.52364251417419727, -0.33939754336840816, 0.60376632269594555, 0.010258548710937662, -0.52090241866258102, 0.27409044012703943, -0.3871760957358617, -0.61098360885369596, 0.88809130540319181, -0.16582655813622083, 0.088989046291710533, -0.23573479698212804, -0.43576794717514789, -0.16489773910942071, 0.27261572318838717, 0.053966580669820366, -0.059971351623644968, -0.14559846846135036, -0.37968527935360546],
                             [-0.18221154565871925, 0.2601950944228037, -0.797988415411929, -0.04346846060180435, 0.11027260607889439, -0.44783953944045024, 0.082941004751408351, 0.5784567109591473, -0.015202560160114838, 0.20882406561739239, -0.20833113157083555, -0.43179405468495996, -0.37007875137061436, 0.36731308868070206, 0.21521046682753442, -0.10627687819521138, -0.12409714115384805, -0.33475065578081942, 0.06724627775946776, -0.098999863091977183, -0.099221352162842835, 0.398559012101314, -0.68490035624398571, 0.45481875419501716, -0.21610121846545971, 0.07234753383324069, 0.68350535346047492, -0.37828737066219564, -0.097616356446584229, -0.52947692979193861]],
                            [[-1.1567799584397516, -0.10176918528297725, 2.1867180640197836, 2.4257313841626811, 2.4561815371437943, -0.16227967898893758, -1.5710331676121023, 0.5747432927071866, -0.50044454071699951, -0.017474226113634368, 1.5083551527385839, -0.38050878998040616, -0.85736943768063967, -2.104711009128629, -1.4240341753597408, -0.10584566895391087, 0.29265367897276745, -1.7986524317201826, -2.0779284933222719, -1.6270569535153476, -4.7049722297388268, 1.099873274582909, 0.046388367707766567, -1.3652771876439118, 0.55215871956934637, 0.43722878929725589, -1.8580005015253542, -1.7459396828742733, 1.1360236337794165, 2.9321063402031995],
                             [1.4693534433876922, -0.74883999202884532, -0.21583743383206538, 0.96822845048322059, -1.1631426690109448, 0.26144904849164718, 0.21911220312023541, -0.50826142284855858, -1.0563219549089498, 1.3457760505684233, 0.79944358921915715, -0.020587268471361761, -1.0564456525232959, 0.44402205643154274, -0.15594176675577207, 0.40838563335549238, 0.023421579395102643, 1.7061547321173982, -0.57479870717497761, -2.088953044622639, 0.57039904963058718, 1.0059364675668834, 1.7164402632493028, -0.07040744341194978, -0.40193059049405999, -1.5585466276229258, -0.13378713986492657, -2.1177014778203569, 0.79120287964058789, 3.5898550348967233],
                             [2.7751698449040041, -0.33003036536227348, 1.0435291106739939, -1.0728139015373026, -1.3228648077498433, -2.474029016779705, 0.9062521223767499, -0.84434020563800505, -1.5971805214118344, 0.34492743607816057, 0.74251644392109151, 1.058069643193676, 0.018801569526162937, 1.0591069532314998, 0.073655428463466413, -1.3853735675602039, 1.4802937203212065, 2.8483302202376453, 0.12800404860593451, -1.1830107126288003, 3.2280342665289941, -0.39664323327671713, 0.065134662231079624, 1.7164726136791306, -1.0290520489324095, -1.5387226644558254, 0.05012684429910895, 0.5573130606687785, -0.3162923028071612, -0.0073366244634982276],
                             [1.2946821199315264, -1.5686356770015735, -2.7992296956917011, -0.99101105918806698, -3.5194318687524508, 0.44506747921186174, -2.2994711641289127, -1.2885836007632074, -3.5523240826905003, 1.0257707677566266, -0.17746182988491513, -3.3072139783716543, 0.79252290647695711, -1.4742858373279664, 1.8004507507736669, 1.8640504415776897, -2.4638215210437941, 1.0839909511747416, 4.019584573645564, -1.5245543836258892, 2.5696967329503582, -2.828800223273769, 0.76449617425386118, -1.8207416021258789, 0.69931688090940347, 1.221460915310967, 1.6011755845843421, 0.039642205090415439, 1.1690392812877017, 0.16597316481934557],
                             [-1.973653090006801, -0.74871651267162875, -2.2972115895783953, -1.8128981795861365, 1.3334568887814233, 0.25649632510914161, 0.65541942663772457, 0.31735146122142116, 1.3024641968488275, 4.0827525357684289, 0.5946775748154407, -2.6853474051446167, -0.48816242228904133, -1.3890132159155535, -1.4459162316119689, 0.045438170186424223, -2.2407998562744251, 1.3078735692563292, 2.8050810052983901, -0.85080846508662589, 2.604165294195651, -2.4958299061311413, 1.0903043890749822, 0.48232867954200581, -2.2419978765643807, -1.8305796876296645, -1.212163171407288, -2.1203743652040221, -1.5166145430385416, 0.96529395724731171],
                             [-1.6416618503871729, -0.44107586567673912, 2.7512381219321562, 1.8946698041241044, -0.48761743944561836, -0.62839093379607047, 1.1667545375214017, 1.796431516133054, 0.55743315802873061, 3.2807159689017955, 2.2238618508563905, 2.0536572613347643, 0.28373772928231489, -0.24891101801003701, -1.396127582934074, -0.7029401764644474, -1.320451664819827, 1.5467915900980771, -0.5097333545667575, -0.33886402368068802, -0.27181264570815478, 2.3063099432793406, -0.62625560408836922, -0.19441105592415289, 0.63019256354399356, -0.62597718793217427, -0.4339634634810029, 0.87970730054573021, 0.21941324505236692, 0.5141323619117486],
                             [0.87013153683869116, -0.22577842076648444, 3.3203826911591934, -0.71617968908706597, -0.27301976920394033, 0.14668608575483857, -0.061277577743194887, 1.5389937427380895, 0.81144171376302632, -0.87599533532501928, -0.21681390664819206, 2.2135126912770531, 0.80170724547090599, -3.0506863494718686, 3.5155598774584744, 2.3916148367845325, -1.9169690258495291, 0.98489690220662007, 1.712206806029646, 0.5188303527543261, 0.50461012744741807, 0.19191240037948987, -1.7576809529231046, 1.3933231376965227, 2.8843756709816688, 3.617004888396635, -0.019222622657836828, 2.9533776974028858, 0.13855234957522333, -2.9808497864832342],
                             [2.0675802087772022, 0.40987025476441785, -1.3587428205039953, 0.2673572169319024, -0.42801054142902462, 1.0650241176366519, -1.624651623140547, -2.1152948187169858, -2.1774577829867861, -3.967693809440779, -2.5097115539802393, -0.35590816330187047, -0.62577841491157937, 1.5406915859059904, 1.2522441504730253, 3.4771474622063527, 0.39769011111276775, -0.50460367402516237, -1.7798981240409049, 0.99466622754499934, 0.9118618774067917, -1.8806254908165883, 0.20584342687440105, 1.0199362877962785, -1.6649586412943409, 1.0988785721921688, 1.5690050011694627, -1.1596279042719206, 0.34440981616784283, -1.3558564529697135],
                             [-0.36937187685580297, -1.1598150554284774, 0.94351683802542918, -1.9454848992197444, -1.0498712652157682, 0.094307259665802279, -1.9503291848224984, -0.095619854909469282, -0.67475234639021375, 0.74370944687456408, 1.1107078607658101, -1.4649078596669352, -0.27886271039822391, -0.090445187661125664, 1.9292649388419225, -0.10419512676587211, -1.3452179099594022, -0.44726392805770571, 2.2631621248094098, -2.0441754977865099, -1.573211704164758, 0.67269572258530042, 0.97603247909711088, -1.0444838841097885, 3.6316223882294989, 0.93654900419509057, -0.65060164603677129, 0.38241734682994249, 0.064732933948189852, 1.0627213478950475],
                             [3.5357090133819375, 1.4185223756265664, 1.1505472344075871, -1.8851790962255162, -1.4918070002167148, 0.35018407013355501, -0.25821741545181853, 0.80981509022133624, -1.6728151062878076, -0.90679172030905575, -1.1466350841642867, 0.90932779156484611, -0.49367730957848666, -0.90140471020811386, 2.4074086706476221, 1.2404342615980291, -0.023258462651565077, 1.7359489309922038, 0.71764979809684315, 1.4284765282126861, 2.1821069513253568, 0.26007958386351748, -0.64741397789099309, 0.66844958358315387, -1.2986652362381825, 1.7612634238630993, 2.325831510244917, 1.4452556831519436, -2.1240012348752573, -3.1449114537713605],
                             [0.35359802958887515, 1.606161932896762, 1.6526082674796814, 0.21328345376684035, -2.8137667314614654, -1.4566271051488364, 1.3806432484120064, -1.3798398393188858, 0.50992315139935185, 1.8732870687110732, 1.0021376457906186, 2.2689078528124429, 0.79921298414520081, -0.30763593171331893, 0.99441373274255518, 0.76408282214901568, -1.5278312184947969, 2.8249445073231851, 2.1128972014766991, -3.3294733591940782, 0.75330900891695574, -1.0576617861561146, -0.64404347805871776, 2.0186924409271727, 2.6503907943961154, 0.50078281779766276, 1.5186847729642665, 2.8885055230145285, -0.29139467212500936, 0.091105692777439087],
                             [-0.53844394460960654, 0.74774223434873954, -0.12355450329560901, -2.7780784489956725, 1.3740065864576121, 1.1398592807029369, 1.4069582371442035, 1.3800271866095517, 0.88848063976775793, 2.1337312891092397, -0.80144301265300399, -3.3853254526417662, 0.27930037199480512, -2.6325060038316455, -0.57926446095009354, 1.8054389960679786, 0.52874978173439535, 1.1190424197271376, 2.8766602309082367, 1.1770083578117665, 3.7711014290944291, -2.4360804661403486, -0.43940671007153054, -1.1435840862257791, -2.0750656731993549, -1.6509985048314002, -1.0789050531079312, 0.70476308842142577, -0.99269326786297296, -0.65455726377083778],
                             [-0.16385087819915164, 0.38324330076636559, 0.63740397039883323, 1.0314435468165246, -1.2463203649511889, 0.29497244773264991, -0.35394586240565828, -0.21393573927836995, -1.8988194976682922, 1.4853608884954208, 0.44482889556420202, -2.3952950757835825, 1.8947640952874347, -1.0819017847867076, -0.62840800737168523, -0.33354150600738003, -0.4354025179479547, 2.5440303413626149, 2.3438248868483602, -2.4113949468234859, -0.93388401576378821, -2.1092691540430963, -1.0622600940413369, 2.0742330417666079, 1.1033789837249899, 0.44059642486270473, -0.55131900846550352, 2.2671682957255306, -1.9978504771744579, 3.0003243106999857],
                             [0.90289817148134133, 0.68048016538415124, -0.84503003584605874, 0.81544924816933817, -1.0346341087167941, 0.6633156006255998, -0.39491838394878254, 0.58839533444267356, -0.5813103418648583, -2.0005160459073346, 2.2294678993609987, 0.063588913739657513, -0.58767309939648171, 0.73435969943188251, 1.7516084807517773, -0.63547288114378875, -1.028385297591943, -0.0046175871937003711, 0.12818299909849498, 0.46606728544354903, 0.19008387364263171, 0.098817375693206533, -1.425143236854616, -0.72102097359226125, 2.1586597285361959, -0.13720245820107629, 1.3019526447539622, -0.4301262924590421, -0.76483920604311961, -0.55673786779143675],
                             [0.94729196611318867, 0.52385981364991141, 2.0306709999973851, 0.27832824957176261, -0.28386625471857946, -0.28825497167199693, 0.935644580533181, -0.19439764786761884, 1.2391387876365023, 0.71123605238011767, -1.3231137296377229, 0.86415698925507889, 1.808588760645212, 0.93437191469691927, -0.25392751120555118, 1.5372623709779278, 1.0802556236281615, -0.28400379492266814, 1.1837843942255997, 0.5492965030799245, -1.2324026193582645, 0.89205711528507659, 0.326288743693044, -0.47310729262180828, 2.0545503820613669, 0.8447282633753922, 0.59766669146572005, 0.86498319243739819, 0.69769272700790363, 0.085561083065614413],
                             [0.71426663114048383, -0.85070720989720294, 2.0478000535608545, -0.80933025479574172, -1.7805709326236892, -0.82943836495019385, -0.091758892695005062, 0.75890293374068885, 1.2305047095073069, -0.35101830016997992, 1.0574229133451374, 0.8852294584270699, 1.9783170111607078, -0.37087234252365381, 2.8290529961996351, -1.3175921317647041, -0.98493581491111937, 1.5962965748269418, 2.3093271371765201, -0.22626940282888153, -1.2859723546380308, -0.036607828753097905, 0.20280775084357514, 0.060600389600574123, 2.5222242575781211, 1.0434645127269127, -0.64974027812756785, 1.6383393563493014, -0.29190965119824902, 0.022787780244022643],
                             [2.8158871518275976, 0.98377145010928835, 1.192660858331432, 0.73808791432006216, -4.0581047109190598, -0.53842043102208725, 0.053723933522166388, -0.036823746963650893, -1.643488367385991, -1.4068469256715044, -0.70565013864053916, 0.018435352546567099, 1.155552437073009, -0.6837950834340506, 2.4958294519742616, -0.38778958996471341, 0.35808988598522495, 4.4340191492065815, 1.5944725441634238, -1.9877530233722756, -0.17735838641558319, -1.8262872374257029, -0.94587133028252923, 2.7282460047145984, 2.6018824627124677, -0.21991400936103414, 0.24216784264370672, 2.6900800623136365, -0.10478242924713344, 1.2747364590070287],
                             [-0.56866204292981493, 1.116680094326725, 1.5923487645748804, 0.69444382491383405, 1.3219369131112355, -2.2209012525152376, -0.005315094073668967, -0.28940500281908371, 0.47849065112712658, -0.085300301876812437, 1.9866214398608373, 0.53183158294176192, 0.32455791566510889, -0.47158362709103357, -0.70103555188236977, -2.4922182052239679, -1.2084281440990909, -0.80545026097994787, -0.38614565188838001, -0.92010744905602859, -3.2799608967862932, 0.093257585761848685, -1.7031387710296388, 1.7646347418129171, 0.51875957810711915, 1.484438978753909, -0.31119718149194908, 1.3675491644798503, 1.6834560497774691, 1.6753964310666176],
                             [-0.93901711983367153, -0.53027022260357748, 0.43661340175690183, -1.5597123604451124, 1.3587169944198105, 0.69495353347485567, 3.0679579569602384, 1.4723593807893465, 2.3171396756076565, 0.041178140219588363, 1.0532135228229071, 2.3997158026541245, -0.89418280367201575, -0.17940077259320278, -1.7319138813445638, -0.087199586286899208, 0.53771766203313087, -0.13338187308573718, -2.3227991751112622, 3.4264289513828778, 1.7590310120712203, 2.4839896942206439, -1.5365132800544976, -1.1558826891490883, -1.5533416586590076, -0.94224061298086648, 0.25394924474142055, -0.48005444953870918, -2.8700305491957745, -2.8540099650121751],
                             [0.33384659864530553, 0.36348633714364242, 0.60530629536483527, -0.50105836746198618, 0.5884811240467458, 0.56224861236379053, -1.0825251738923096, -0.26224018210126976, -2.5874725208766485, 0.85054670833999457, 0.60711006387491362, -0.9258858310059771, -1.1798581131068204, 0.96801104925626014, -0.0051262976085864297, -1.1969033334887922, -0.16128928800426617, -0.89114658582859074, 0.041894465175734329, -3.6253869639561915, -0.35098388678689785, 0.49951672406576658, 1.1855291110853392, -1.1098285951423592, -0.24890271929296942, -1.5739735557967371, -0.22668248860719742, -0.92528342052435497, 1.2645508087219202, -0.40509213077538586],
                             [-2.2001342502307319, -1.6536179439976786, -1.6622674420192023, 0.81264747922845904, 1.4715192923491502, -0.68536690252746446, -0.62692251154870759, -1.2959483099988904, 0.87972615580984959, 0.24077421865351237, 1.5932866291867811, -2.7776958600128356, 0.43006484971605707, -2.4986796667535005, 0.2928311816079166, -0.85619142723787145, -0.15543693036581624, -1.5228994357168553, 0.062110257070127392, -0.6205221597439492, -2.3670102676459184, -1.8808790274661011, -1.313835108620738, -1.1538205647815727, -2.0789164720628546, -0.72811788510664233, -2.5943328121420457, 0.71679555471826184, 0.258241333895391, -0.022311483346260656],
                             [-0.78718440601527395, 1.6720655983982931, 0.59217739298442729, 0.33531250071135321, 0.66787311238529756, -1.5568828284415346, 1.0640809204429644, 1.4030191066076014, 2.3323614750114277, -1.284748593619732, 0.2473199125492539, 0.039992843407838777, -0.62237431875658678, -0.18418801445833191, -0.48754647549472252, -2.0170311282311255, -0.43897435602179191, -1.723846753238568, -1.1539297233878416, 1.6525261873678216, -2.98937265488079, 0.93218655690772179, -0.42061743383052314, -0.077267933439158235, -0.64016681864484337, 1.0885679948124716, -1.3934913383007135, -0.59540985364920584, 1.0325723135216118, 0.47819781247551318],
                             [0.74414414460283018, 0.52256794786269856, -2.0547638859321138, 0.87171564022453618, -2.01018890841463, 0.15954105525976425, -1.4864524308368656, -1.1203643730947763, -2.2601002666483763, 1.3630287551614377, 2.4345666431906796, -4.0163158738341105, 1.1523980247762144, -0.31166261286205549, -1.7737176963056469, -1.3711311448604413, 1.3345074346907975, 1.6038607037420842, -0.027114379297026196, -2.510904440184615, -0.10868551552848323, -2.9009775326412148, 0.52402404238059941, 0.3086111028677066, -1.0084063267689267, -2.7574960404057274, -0.90912824098330425, -0.81027666715256863, -0.017415071226882774, 3.7011705785748088],
                             [-0.37097833677925907, -0.44997206125769146, 0.25137652346213685, 0.83074211435704348, -1.2388752194099986, 0.7805875850006031, 0.30497056903120723, -0.71714816671915382, -1.7273003631370119, 0.57646952413049157, -1.4675749273825334, 1.227173097658451, 0.50922910298983082, 4.1654553137885397, 0.30740222913487913, -2.1587799683484787, 2.0847282153282598, 2.152668061804397, -1.3725949821821812, -0.74473914122807294, 0.32089647446955533, 1.9186706189133043, 0.47248399255450396, 1.8224856767990751, 0.23965297610097597, -1.4900318122285356, -0.09439953014536831, -3.0044743182793021, -0.84203204681745236, 0.89763487831907696],
                             [1.6008327204822808, -1.7394489129360049, 3.3738079747224838, 0.48128774746496156, -1.549423347842958, 2.0068098009913511, 0.50894587328723273, 1.6567384307451516, 0.47052195556857851, 0.83562264168873779, 0.2308389228343492, 1.5388448728399582, -0.042447983882579178, 0.93893838409093433, 0.1319198046079485, -1.0647560100410098, 0.95378270140431365, 0.082586362012429318, -0.51157487020985537, -1.1296372914949806, 0.3880944451353559, 2.1425714959748712, 0.28324950801476889, 0.22693907856493825, 2.2624832551933385, 0.31887203775346951, 3.1431950367562509, -0.4357228718417529, -2.1127440058587061, -0.1062440791335213],
                             [0.5549147812469597, -1.8999505339588187, -0.58763745414937418, 0.081284574386420949, -2.1510082603587088, 1.1205703016460289, -2.676035486761577, -1.9006089073464667, -1.5944482875059818, -0.71739057009679241, 0.71634037874057188, -1.524568886928745, -2.2606685860904667, -2.8530753549270136, 1.2707099115917138, 1.111686898661109, -1.414161303313008, -1.7701307325707056, 3.0042326598532396, -4.242921196113941, -1.4465956305916283, -0.28007603245134571, 2.2316763853965127, -0.82006632404601654, -0.87156604558448703, -0.3288491741333513, 1.7603916813292511, 0.40057017153228797, 1.3178913720163723, 1.5629696216977649],
                             [-1.0784511537848673, 1.1342400536797121, -0.23199249293670468, 1.0211158409319732, -1.9277412712850344, -1.5211176360201581, 2.3858698393380053, -0.58647353620535991, -1.1556802892597655, 0.42429926385948097, -0.22312767690428278, -0.163673698301565, 0.74817330690834338, 0.054590148870239621, 1.8674661109367365, -1.9780242902890888, -0.52657532749335589, 3.613367189331993, 0.95449024121439263, 0.92902655506788456, -0.17520930860019221, -1.3236297567859923, -1.0780338493285073, 2.19301243991693, -0.22023179208118296, 0.033055157462646728, -1.0451720316892439, 1.40450321429475, -0.16701051702531086, -0.52523400018532618],
                             [0.62464904182170011, -0.14314449050350103, 1.9855476043430256, 1.9716658236535249, -2.246252095256343, 0.14645625304433355, 0.7022502486387453, -0.77019558899063567, -1.9375399353897511, -1.3491041717057111, -1.1081420736773371, 2.1267117530602078, -1.2936633965502737, 0.83006853856560781, 1.2479933670837857, -1.1730352769373265, 0.29690536692152825, 2.3616631927415028, -1.7191597641852221, -1.3177137704598576, 0.54177490171329512, 4.3489165644981354, 0.97361043211592579, 0.65919675409713807, -0.019145914057265848, -0.68877610131902656, 1.839167247857971, -1.1629679715707057, -0.60588521969466447, -0.98841211316059641],
                             [-2.3194467132385754, 2.4235744320736208, -0.42404778552172168, -0.57974940968976563, 2.6932227967635374, 0.47800481868375116, 1.5416357523526911, -0.34011202880837499, 3.8133017235246616, -0.043301810282465068, 0.3445136390378899, -1.5490015833328685, -1.1401559043605218, 0.073273167291959013, -1.5541300770766779, 0.1376089025679994, -1.2710607465961457, -1.277228543034828, 0.83567927929589747, 0.20112172749953297, -1.3344661149060755, -1.2394421647461855, -0.92795605706189421, -2.1703098581768416, 1.711018437640218, -0.2043997353391494, -2.686005475261291, 1.8514019943910613, 1.0106689637781523, -1.2980031077673782],
                             [0.48718314760887166, -0.73218665179772313, -2.1007027258729729, 0.30393195187078442, 0.26710467794001447, -0.4399225645349753, -1.9240506499912629, -2.6798443527262634, -1.4363232286302512, -0.10229518523317901, -0.18289159448660347, -3.5104582146665888, 0.96915551058060589, -1.669068828636354, -1.0472503006171083, -0.41818946426439385, -0.015882704884834099, -3.0216749265232599, 1.0322847163558007, 0.3362372267344832, -0.12824747294766115, -2.8187553694622043, -0.17856489148106749, -0.96366560125387024, -2.5801710394855077, -0.55279911141296989, -0.19738015010654508, -1.1875189117718394, 0.81414741691384107, 2.494412536794206]],
                            [[-1.9022729192408736, -3.1193962854784503, 1.4419011024994322, 1.2563300268863478, 4.7502099230646042, -0.53722430307588298, 1.4905710810030621, 3.3884267351940967, -1.3856271277954069, -1.0641390947871112, -1.9073458336416158, 1.7337710036721921, -4.0965217713875317, 3.9997376112420469, -0.83517700098396785, 4.9684956567906982, 1.0049001051612845, -1.2440303027765667, -0.073594438317965638, -4.3776900483932257, -0.0072023492485509145, 5.4876011631948369, 1.1114065772229262, 3.7386726664576622, -2.0022383997531215, 0.54802548408407203, 1.2831580933192108, -1.0634304247735158, -0.4988804459893722, 1.9886800295684843],
                             [0.204379790131202, 0.27480972105637874, 0.73993581880239867, -2.878972522020586, 3.0710820018423837, 1.0569449402052913, 2.7098023094313866, -1.7328002468455965, -2.4529775702312979, -6.5230749555283323, -3.9614359545403453, -1.8785567522411326, 0.63611732949268784, 1.2201933173418578, -1.2344980349195143, -0.37925613365009408, 0.51610022858821936, 1.9274376979401107, -0.068148211922084798, 2.7198062004305261, -0.33899674671222341, 4.5670619604785019, -0.81422636081196775, 1.1797332684947595, -1.211416046768383, -5.4234971539064079, 1.8177144544542825, 2.6566780133432437, 0.79484959990124737, 0.7213144968314088],
                             [-2.1511817774449842, -4.2822895463235628, -1.0405781708153798, 0.34937863730950175, -2.4462579582279718, -2.0984216240178686, 1.3338522089375451, -0.74102206711003926, -1.1576320127452673, 0.60974039670083058, -2.0981419884587948, -0.24751808131749739, 1.5347447244564745, -2.3172578672545896, -4.2906360068990104, 0.42857025085521461, 3.080172540401624, 0.665879391003809, -1.469691174270263, -1.2124207686291515, 0.55614582994014505, -1.034661741083472, -2.5130218272640121, -0.12360433962052053, 1.1567453530492819, 0.81965999708308213, 2.7983508503553565, 0.92833362259683683, -0.018198827646265878, 1.7369504885164149],
                             [-4.3944773402456079, 2.6192083407929587, 0.77766460261891135, -0.59758267663018039, 3.1745371913093399, 1.8193435877796929, -1.1159902514561573, 2.1431930612957304, -0.12938609450612529, -1.8807916031475056, 0.10927042296354406, 2.5503635779439557, -1.1381984739680733, 2.5739792528960499, 4.936066616898656, -0.94088930203973598, -1.8281157620263808, 0.54013544477342135, -0.96836209630086623, 1.0117237831085446, -2.9994507123815963, 1.139608931509495, 3.3727459970252482, 2.1865179389660918, -0.80809068352425117, -2.1934180593939492, -2.3798380072356022, -1.7701942984333443, 0.45701260896000234, 2.1136358546891891],
                             [2.8915712422099871, 1.9681512750637229, -1.7965687831540356, -2.6403771316258022, 1.8248734674984453, 3.0627142211964138, 1.3503755060310842, 0.46553454220591517, 0.36556269229399246, 1.1083746750517407, 1.5948273130955588, 0.059603416974957649, 0.70094949201138013, 0.011421027529920691, -0.93575698879744418, 4.0314873220390597, -4.2837517483466838, -0.58657472652455311, 1.9472775576492263, -1.4102316742948429, 0.3000700823380279, -1.5390254530641447, 0.73077991541145204, -1.7785733574212979, -0.57740048452958348, -3.0416639272514301, 0.501963705062767, -3.655851504193548, 2.5739705519356288, -1.483383186566392],
                             [-2.4388926805507238, 4.1312889123861964, 1.3380314174230878, -0.82067913427571038, 6.1372976286132968, 1.9613934914021287, 0.72430026952114779, 3.3362977032856227, 2.5938745701881882, 3.0235532417803292, 1.031725793986638, 6.3626916675179181, -2.8184711827474458, 5.4608429187277334, 1.687699582742356, 1.8778317691923905, -4.8884152132746639, -0.71108178627908247, 2.4502310323455245, -1.4820994391320972, -2.6943699972326449, 2.5511474887937213, 6.3646998168246443, 1.901082209822113, -3.9045109585716182, -1.9804323623928166, -4.1921935232901886, -4.6363905946130322, 1.6632878701824805, 1.2933092902453438],
                             [-1.7849987481007201, -1.1678372229419822, 1.3882597751032399, -0.78436504458744727, -3.9494056092456029, -2.1729452251261909, 1.6997593355533174, -1.3943694981165478, 4.9871822512728006, -3.3956619730876376, -1.0824751808696429, 2.4443972024938772, 1.6663683022038558, -0.013981274218828388, -0.065935907309774167, -4.0683102185079481, 4.2999323144314658, 3.3294658726327042, -1.5040935559703696, 3.1845528394891169, 1.186061353054886, -0.039039516813087594, 3.0345864496963055, -1.7216186359359493, -1.2800071238423925, -1.6965833183434706, -1.0617706936775755, 0.9865211982399581, -3.2392767678071577, 2.0849275894855852],
                             [4.4302890498715755, 1.2798158481660371, 0.061255464429639868, 3.6709080724477436, 1.3422730434237971, 2.0803808675885986, 2.8424637982193111, -0.11927876587136495, -3.1752632146463995, -1.2927114703896929, -3.5913999664401568, -3.1396814701813005, -0.79942503170431445, -0.45946775659016131, -0.49042810077852717, -2.3180572408139337, -3.5932379897036482, 0.43724746875642528, -0.27136847620810617, 1.0272083225686877, 2.4890356329493826, 1.8442288336427628, -1.8142358250969099, 1.3327078419248597, 1.3485254036487055, -3.8033685577943159, 3.6615910382951138, -2.5290101320770741, 1.732372392890225, -0.65886737772457726],
                             [1.2535667830389383, 2.551025514465421, 1.6103090576690944, -0.040131081922785292, -1.7272458835057809, -0.77719013682567595, 1.2007387572959527, 0.41958716311159799, 0.7874454691915086, 0.3378151403445625, 0.51861592103571352, 0.011549371425475465, 1.8561905814672377, 0.83660188038727634, 1.786215171778315, -3.2489869840737411, -0.97025604711043667, 2.9498622950472013, -0.3067414179177903, 4.8823588758814838, 1.5962075178284154, -0.32640115489646904, 1.8757022645945676, -2.5943293336457058, -1.1511476687164806, -3.3180231855843645, -2.2303272333429902, -2.4353461886569137, -2.7496236099146532, -2.1695234361552465],
                             [-3.7965825016756964, -2.077363389094244, 0.6023479329350977, -3.1603341123605322, -0.26754207431043286, 0.40661084999058195, 2.5373616150239937, 3.4884210708721186, -1.2504015183901136, -0.12210951632788947, -0.30298171728017531, 2.1772813031243095, 0.45506504292380423, -0.97742910802827065, -1.8210433217473532, 1.8797109773177081, 1.0307880186186662, 2.2806952349869545, 0.80291472533409025, -3.9175260042378035, 1.2284112399381035, 1.3199929739012553, 0.92992098092980124, -1.1220796769292702, -1.5558413720524189, -2.429557158618274, 2.4949951703489703, -4.4579892461189239, 0.14983059174173344, -0.096206334462629162],
                             [-1.1865118916036623, -0.58211752569134323, 1.5306521151895742, 1.3477246928502908, -1.5315233886500068, 2.1769825009918784, -1.7081350724456226, 0.56244843859030413, -5.5193831779757021, -0.1747697678449425, 0.89432156965240628, -1.7457469227182008, 1.0976219925550403, -2.4810122768046363, 0.72705302714170694, -1.5420899144857747, -2.5705152110392362, 0.74783298736229065, 0.68615730190960411, 2.325439009739064, 0.0067359561240687912, -0.17839139420848044, 1.405541704874339, -1.1896503204565403, 1.0553043299916578, -0.48229214850546642, 2.4706881633750553, -1.5315656161802993, 3.0285271765849506, 2.2334699707187253],
                             [0.50314294647385005, 0.23298063387905471, 2.2428299133535727, 1.244291150972975, 1.27567406793834, 0.42212468033417611, -2.7398735066927862, 2.1027399527326116, -3.3947976433627685, -1.4804191285640793, 4.2552396577882172, -3.0881706350798099, -1.389159907797626, -0.6313755706636458, 3.5982894200433688, 0.8119777635090859, -0.29160337656747809, 3.3498522966591473, 2.4839031647451284, 4.1870008191068955, -1.2290081429257067, 1.9251327713325082, 1.5624381541860068, 1.5665661789772638, 2.9319333762050235, -2.2738946632103185, -1.1411495099052311, 2.3161484412948399, -0.47942306326558926, 0.13673561857442842],
                             [-4.5932585966453301, -4.7511042856447805, -3.9446751011978778, 0.91822775879734764, 1.8643882808005918, 1.1767417419846073, -0.41832396342500744, 4.1274580774008012, 1.9464763586302847, -1.3006790339626426, 0.97430866233010527, 0.28451882903551279, -0.14541214208310135, 3.278257759530256, -0.77487167494330078, 4.3761236379771384, 4.5513035242418551, 0.10990676731297941, 0.89499593789412002, -1.8239834500563183, 2.153333351561411, 1.6718665539656035, 0.87379297442228643, -0.0010523932985703442, -3.1149540555407125, -0.57933254316135963, -0.4837156136757198, 4.2655198754844692, -3.0517991062747845, 4.7325197055030666],
                             [-1.1063524463976817, 0.86598536728787157, 0.7090029366432602, -2.4982036570109987, -0.85871148762959848, 5.2122055801239222, 1.5550741333804394, -0.30428385461539215, -0.62406808790651425, -1.1155452619900603, -0.99172311918268641, -0.65798141616697925, 2.8062717199238723, -1.0622009867867117, -1.628097913185665, 0.62293294256286347, -4.9592565139677456, -2.9244854568801495, 0.70196269175255388, 0.86448601646963086, 0.02815243398924927, -0.26826073577033399, -1.7198077944979049, -0.4243584358563493, 0.99516380915916658, -0.16923194198505478, 0.36818684608752095, -4.564907991965268, 2.9449553905421721, 0.65533368538804138],
                             [-2.8032964793545854, -0.16659732477324801, -1.03290722107547, -1.5500309165252704, 1.4906965514587829, 0.22097315976102502, 0.93266169046168834, 2.8128455051524974, 0.074736000070082256, 2.050801310861579, 0.0069547187483395972, 3.2514312848838949, 2.9671328809763553, -1.2523283003840555, -1.5800095955672226, 2.9946618112532382, -1.0302972873192802, -2.1686680834922325, 1.3051433381034605, -5.0727489273169919, -1.0033294892055988, -1.1581002704555936, 1.6658327818412222, -0.51558679152955955, -0.071273598562500193, -0.21329449791506541, -0.71040243587455598, -2.7480994519350772, 2.0861222571082374, -1.8463647363288647],
                             [0.94945081803728737, 4.7214013601927363, -0.43484103213289627, -4.9592341513781406, -0.54930061576288869, 1.0846078180014869, -1.3578217768382708, -1.7632808306943206, 4.6816363916228232, -0.62342061699240037, 1.576069693432391, -0.66488330654190875, 1.3229878965407875, 1.6432304321926521, 2.301079748483871, -0.10986692017973952, -3.8537279020376136, -1.1064080062757016, 1.9610860579782439, -0.85262539767045498, -0.28450112932153548, -1.2053387769689801, 1.3580262802954919, 0.89340313361523305, 1.037870465129489, -1.771435746538393, -4.0736296538540069, 2.4708264133410167, -0.10144884458176859, -0.99309850323114257],
                             [1.9913780616496988, 1.6172950250326221, 0.70531026469813063, 0.15403937140519552, 0.14395489453858792, -0.53486752632327694, 2.9284593387828375, 0.75081110779717719, -1.4865869176138078, 0.14455690687842521, -0.66455171790208467, -0.928998175716654, 3.0069618973919803, -0.6745917136164481, -1.1223711389485422, -1.7034927092939713, -1.0835097590146512, 1.4637963619096512, -1.2193893923571681, 2.0812717765768061, 1.6967206623400126, 0.7694140985076191, -3.0962697348307286, -1.2838712476861127, -0.48941677535757716, -1.6614710340398209, 4.0088026990232084, 1.0563941528606824, -0.0062939801002780509, -1.2869720069805606],
                             [2.551634043252117, 1.2360302591155348, 0.22081458028329731, 2.6191397125321996, 1.0530739269158049, 0.72674887477290651, 0.85915393586068967, -0.45112144798686366, -0.19370840677092716, 0.44414399194442211, -2.9873260866291425, 1.5892495999379639, -0.59550181539507419, -0.31629794373962339, 0.56823592981386217, -3.0708888163131691, -0.11602701277051303, -0.40727926096840683, -0.3564453587185597, 3.0950246401382975, -0.045589053028874192, 0.19372104152159891, -1.018145668353974, 1.4461369682821013, -0.94060835588746639, -3.4049098800110098, -0.032926574345186588, -0.86109007808729587, 0.28169531100563938, 0.045218189481911142],
                             [-0.55933333018651521, 6.0942130657806102, -0.66921070544747541, -2.2807288317499066, 0.69609970843218971, 1.1458066725117106, -0.075469613607372393, -0.1195345706872587, 2.9530203993298025, 2.314025685763347, -1.6768922786587013, 0.33928707863765756, -0.07586010567059237, 0.79814980049627471, 0.22003016304678624, -3.1544493858211911, -3.0678748443855541, -4.1217869192131342, -2.0013108944160853, -1.1802975750496807, -2.7866490115011295, -1.2866308341276864, 1.7230239131473322, 1.1426895340600858, -2.0109089488743463, -2.0318375244994398, -3.8648089369686063, -2.9020035539289162, -0.77608397351265546, -0.27713169546298777],
                             [0.47484835647516238, 0.18760521589505919, -0.52625668187512142, -0.47650230290593798, -0.9516923439913485, -1.1925442948983478, -0.5874197912348551, -1.3868835973799147, 6.3705997834891077, 1.8292780918511165, -0.30973980273362978, 3.2392509665552081, -2.2109638009733255, 0.0090276766572564282, -1.2993171647017998, 2.1676472441081147, 0.45553164917834399, -0.69198266718697343, -0.97914529194583355, 0.77689967103742918, 2.9701211331293247, -1.1732949517130857, 0.92585942935852628, -0.12378166631790005, -1.9814002265123278, 1.7377495385955215, -3.2780942754430868, 1.0857251984722007, -0.98542536875323195, 0.61726625228739929],
                             [-0.018488187565959185, 1.0445851464326414, 3.5459548553725053, -0.50221813179570007, -2.665249825497531, -2.127070989969277, 1.9127700357118069, -0.68750632107405485, 2.7632487845756977, -0.13017949022421887, -2.3671793749777632, 1.944183495742615, 0.27841069750173747, -0.49195194137549181, -1.742452924655276, -0.97737564958248679, 3.5099962451330158, 1.5603598820386229, -4.0976774497351087, 0.43013066095273633, 1.6824386906132307, 0.64237876966877017, 0.35177632018611554, -0.83447073948486283, -0.19100857698416293, 1.1806187365502827, -1.4303552294823703, 1.1035613212666655, -0.7275823263506801, 1.402320747326933],
                             [1.2193761520123065, 1.2580924192931986, -3.8075932178751621, 4.2264578179071304, 4.1802475429203891, -0.65392089323188185, -3.015242764983642, 0.91325982225100322, -0.78353517707720188, 2.5229713026838572, 1.6778305176402006, -2.1199009713672887, -0.68183863346748175, 2.3786782338438766, 1.7104319345812469, -0.1595109266704467, 2.0800242239257085, -2.9535715880689963, -2.1895413334007419, -0.91587690276632883, -1.6108264127312564, 1.4829548857575743, 0.72817505824343498, -1.4169530840014926, 0.55292790049869422, -0.31527611851342829, -0.26546279322600624, 1.4689915906262705, -3.9603523174438822, -2.3423104863624622],
                             [-0.0028786945087803245, 1.421122559064564, -0.69652297416639286, 0.60596877592758802, -2.6290542125417335, -1.2679157579471916, -2.3515835866841925, 1.2323930937565122, 4.0109630894073387, 0.89382517493819802, 1.5075538247119786, -0.73993789132227483, 1.2202523423969807, 1.6691827124950422, 2.188435449481581, -0.7604999572712503, 2.4797796399874623, 0.92064107679034335, -3.653299085345826, -0.83618929277052145, 2.7602976933036971, 0.27726372856192461, 0.16292992453539612, 0.49573667162674528, 0.21657410132050417, 3.572122755417678, -0.96557671540087942, 2.1929587731093685, -8.3103230331067355, -1.4461116676957584],
                             [0.65992868344154343, 0.5612964007453195, -0.44053565769405201, -0.29727962070663572, -0.65834300394800194, 0.8261181287523065, 1.9803589623443865, 0.22107603007779955, 1.5216954961750635, 0.6279608659274758, -0.22244712704650529, 1.6132991445434193, -0.0015732148589200634, 0.57512175835840795, 0.017378848090685295, 0.85874156849289707, -0.9016864674657965, 0.24643533030462728, -1.2166818160546751, -0.8523608872921139, 2.0737807899001548, 0.15719923649055423, 1.1690583771708254, -2.0476592246420275, 0.74037913917656895, 2.0399658181654048, 0.066353548507048415, -1.8589138706443267, -2.3079016605141778, 0.030712198385546063],
                             [-0.061926775990679951, -0.26707765113050941, 0.3802137500896689, -0.9588780594850399, -2.7656364946418277, 0.8165153860281199, 0.27130929306011825, -1.322372775956866, -1.1568952695341266, -2.8404767474560311, -2.0371959879507346, -1.1411053286654147, 1.5992874657678526, -0.03561450572676237, 0.69716496911244097, -3.255174606124724, 0.79720524648124502, 0.061970011531890398, -0.90177210837263722, 1.7306157600915064, 0.23497529091557789, -0.1103467798563479, 0.098316010844372359, 0.59029087314964479, 0.68943978769668657, -1.1067433351005196, 1.2255948672634016, -1.2219310459788584, -0.39602551658610791, -0.88820917976276326],
                             [1.538129287670027, 4.2732494336715421, -0.45340230103252249, -2.6032963454234559, -2.0861611358950616, -1.7662299589084112, 3.4925021438546695, -4.7294335593568695, 1.3633156908139494, -1.3702501985688864, -2.265897702104994, 0.11540318542546041, 0.95915316349593427, -0.25285825807505213, -0.80241101829631711, -0.6392323086873517, 0.12985560274536609, -0.30397336052607327, -0.44351470544605653, -0.14300638467006077, -0.73775960757276071, -0.52841423556808975, -1.4080179587594124, -1.4339912434226163, -2.0099646894059053, -2.5799701410282836, -1.6286332653216848, -0.67167024015324472, 2.0092779439753938, -0.37107982028541664],
                             [0.70577526343056751, 4.9056149044165291, 2.9851555061690238, -0.50282411822905204, -1.1354899657632296, -0.23788295197477832, -1.9872099213550636, -3.4127808941698348, 5.1463450330212792, 5.1123488168349089, -1.6218572359038055, 3.8653504311053912, -0.31760496220672879, -1.5537854647019895, 3.1836169080845429, -3.5952795155453501, -1.8035329255825379, -0.55708742989728577, -0.41813249724992663, 5.3041085164062034, -1.6025301259489109, -5.0546384728632932, 2.0331040190460929, -4.0299114985180351, 0.59915822329822432, 2.3565897938632077, -5.9927387657116533, -4.3832750764001993, 3.3954337397103234, 1.0506312225286156],
                             [4.2373892641786437, -2.7194566949145638, -0.38190995826950336, 2.2968416371040421, -3.9028479411431496, -2.7269361792188289, -1.2438855642829214, -2.1765223531386502, 2.2383976489300723, 1.3886610678801841, 1.2308951053209674, -1.597818477090363, -0.43488568661649607, -3.6136619856308707, 2.0608700931731661, -0.33358207867931328, 2.5948884553297886, 3.1285579620465507, -2.0154606360958405, 1.5303767522140841, 2.2460916715455745, -1.5514396468078815, -1.9011539225738381, -2.6552852359054131, 2.5319731783725805, 4.6576671709743662, 0.35894144109045661, 3.718943614074286, -1.030249254491781, 0.141923621451016],
                             [-0.8738143041819012, 0.15987107523870231, -1.406620337469028, 3.9073781156143799, -1.3877450586513849, -0.18949973709765633, 0.94545165752923466, -0.20884209644262575, -5.6429354777959535, -4.0339666402076464, -5.6779365499317347, -3.2971634364908526, 0.89035989179710606, 1.1202463164088305, -0.19319666076666098, -4.3785860537335628, 2.3730350838596368, -0.54401953074213805, -2.102092692568271, 5.05066580102707, 0.82146916056710773, -0.30111123921148192, -4.1134291590943874, -2.8608455007462892, 0.49243183058469842, -2.6581555781988819, 4.5577998171035565, -0.92273319579649271, -1.2074202200797828, 0.9419615946345008],
                             [-2.3799072405639614, 0.82842313654778688, -0.9707342146966188, -2.2642954690296215, -2.6448170784592433, 0.21242737068693485, -0.94564650294823371, -3.6076766919704131, 4.3939404978001404, 2.5452506099998042, -1.3060562313673616, 1.4496941271271904, 0.052358185745686708, -0.58750759565017074, -0.31506240773463168, -0.0038554728539409999, 1.6312777725521679, -1.8047789664332585, -2.8208168692465612, -1.2940698990048156, -1.7792602394268695, -2.8087054513551672, 0.32000502581026846, -0.89987871226003946, -2.5581258323927281, 1.954780535820996, -2.2873771809474888, 0.97605092128055926, -1.1500917332737364, -0.81296470714265401]],
                            [[9.5974254698985355, -18.914975057465778, -9.1496576603962438, -6.4954167020636078, 6.5308276384164348, 10.577834755803131, 7.3133451353572045, 4.0724006838643003, 5.4009903363577401, -11.452733721444456, 4.8359264354121407, -1.3911721744010899, -0.55714965367293579, -50.3172904810841, -5.9187906018798246, -0.41149660059491266, -6.6918695142442211, 9.2255161901040026, -2.257337505457758, 5.8951135342196039, 6.9905145290497801, 2.2465938489885402, 6.8035829241411268, -10.129655849030335, 11.502539207577676, -8.2628029617484522, 8.6926390799521478, -11.7938106732554, -5.1453172855846381, 12.598177897876248],
                             [-18.867475895671962, 0.78618495700325697, 3.0473214085232914, -15.029562390852069, 8.4261714079064625, -7.8518121668993448, 1.356760375694734, 5.4925427620123441, 0.90333829238856223, -22.542626525053628, -4.9770853627534857, -24.893070640713642, -10.44643479260793, 11.602633592501975, -7.0306949965291148, 20.896036123173893, -24.467535219429276, 15.872055729731136, 9.8121642032591101, 1.0793155252753754, -13.143553091408581, 7.9042530854208062, 1.0350468353093016, -11.025709261820456, 5.1153144738041885, 6.0435063306544468, -8.9299657886769701, 0.92536540426328295, 10.118076073542678, 7.753467496847553],
                             [26.590478062199498, -31.102827543007642, 0.3273994657439197, 4.7414071667762956, 3.9141079082480745, 3.7807394825398921, 4.771312751188356, -6.6969022146082962, 4.5619701997444233, 3.1402075451789959, -2.7669655738938808, 13.260352011007386, -9.3053558862185941, -38.164636358887492, -9.5837687373139993, 6.5655071167553105, -9.9115316950247827, 12.868663149287537, -36.167119662979864, 2.6347093164289088, 9.5573815866704006, -6.4255731847176207, -4.2295527503561248, -2.387373634089113, 9.4497727947310928, 0.14038009446968019, 3.6568592747831961, 15.144248228763892, -8.4996603680078486, 23.969050568546692],
                             [20.011853232538165, -0.23037525600916928, 14.744321115400037, -3.2014490041867836, 7.9534629765915819, -19.31979596480387, -4.4002690623072631, -13.935738708150327, 2.8559009140348905, 18.883655783150484, -4.0883486855755713, 12.628660217449331, -11.121259734454473, 5.487944019611267, -9.9641816164065276, -0.57780937842948854, -3.3384969181974036, -2.8087901272539142, -13.727094016405045, -9.5562376027787703, 17.19521531568973, 4.3259762863218025, -12.349132601227645, 18.39606657041892, 2.2980216815515924, 1.2024184395187723, -2.5236366149929506, 38.921867000670993, -9.955278974518377, 15.862033831834147],
                             [17.897076918598309, -15.205208711389879, -0.67463072139080926, -2.8564536185720781, 4.8393096084597351, 10.676279080360363, 13.175263786991597, -5.7273823966188386, 0.068949098491737748, -2.7427242694985901, -2.475234656347066, 5.1110608064434579, -13.249539744398527, -22.186881588930948, -9.5530849642907363, 3.3991237791668296, -11.746794599159873, 14.247793173684256, -9.478770901808895, 14.694169377665173, -3.5478166560763782, -8.176063654786855, -5.6520217857395636, -4.9477043036279422, 15.310364325472861, 6.0767342952292207, -7.6273475028671731, 12.129041102924361, 0.35817667159641942, 34.285284334219369],
                             [6.979958100207007, -1.9996854431244884, -13.05419794099018, -10.720740304050549, 21.494516597466575, -9.8435520168664663, 12.72961970174997, -16.670097329269662, 4.8633001141164369, -12.470665042664812, -0.99977083449130422, -0.7411554337216516, -27.29511493775745, -6.8755052738312399, -19.215910079056876, 17.632817488007682, -22.097110515694673, 28.530185890295449, -21.84143585728458, 19.214678256181635, -15.174044821139228, -1.1351058246363823, -16.026211062109351, -0.18780299729527333, 10.298707849393061, 10.546799914794434, -21.421041735057109, 31.59249631614723, 0.22267161052913034, 48.460181231860211],
                             [21.673088619266942, -3.8155021362943131, -7.0206487658296393, -8.8656739111346141, 4.3587211609902941, -5.4902121225425873, -4.3790782397092176, -12.329808722624955, 2.6441969106773757, -0.12579590354405634, 10.166686875342684, 3.5441095128882951, 3.3115280017396862, 11.18482033827531, -18.52252764882444, 2.2255120503435291, 4.2269522430189079, -10.460000991759241, 4.8523680073526352, 2.5103878939013158, 0.68933731179824465, 9.6744621188299593, 3.5710488575475705, 6.5630728814814248, -12.832482211114815, -3.1915706656788441, -14.546824133226691, 34.312708959449374, 1.0988143004293836, 12.291512571584605],
                             [-12.071618120056124, 4.4386472888328949, -8.6403509844518336, 15.960128802446706, -14.004541064262009, 9.8016148920361097, 6.5395683501973449, 0.80058983700259934, -12.079131877668834, 15.104749266253878, -2.410919256985494, 8.9452530354680242, 3.9516955926554149, 32.391284793956245, 15.467140210818954, -13.677287499844301, 11.371125441310731, -11.999687220709635, 2.4504246011048991, -10.63111725257194, 3.834623033425951, -11.996887056943265, -10.305498430161416, -5.5861388309031836, -7.3635679039589279, 1.3965171145006625, -8.1012572589132503, -11.39719881892481, 9.1038395005060835, -17.867047257696232],
                             [19.578134219848412, 11.401168741958552, 11.994011101072473, 20.103029737138954, 0.095997375692172135, 3.9582570940107371, -2.2718604058744338, -12.693582114797458, 8.4859459345902817, 14.477034693315026, -10.415092879155784, 17.121385382820158, 3.625809663362805, -13.995800476923311, 1.51259845410712, -2.1273681106285705, 17.452546198439226, -1.0292888200957699, -9.639571778205573, 10.948173315109576, -15.928904492447964, -10.738348257019219, -1.7330201513055745, 11.062943006792809, 3.073221367840552, 4.5132523254741166, 11.862626499403857, -7.2164563372667327, -13.199201456405762, -7.848984429124771],
                             [11.906074884370586, -8.2840312720968292, -6.3366611333540135, -1.8868465816653393, 11.201238839455135, 7.0955471866100135, 9.127284350992813, -7.762317468727562, 0.20572594356691362, 7.1401558828180862, -5.7542978731902821, 14.480212483246261, -19.778081029734874, -26.111636186730458, -0.29357045935214265, -7.0130119413740948, -2.2295627332363139, 14.30252271042173, -27.380023399222782, 15.895106192230708, -1.6104678430324948, -23.005539676370141, -13.528747903947787, -6.89184956301124, 18.530944337863737, 12.709105381723051, -9.2396625091889657, 2.6434207392780982, -7.4600895290770168, 20.317967280887707],
                             [11.875683508962085, 11.131690220162579, -13.844472314859251, 0.73346877827300727, 3.3282760001629499, -3.6815114606202006, 6.6207479777567686, -9.4800174270417443, 6.2793777179408297, 3.9551151058130176, -15.710276982613562, 4.2020608401343917, 11.154423531351348, -0.096113931659829052, -6.2357104336043019, 7.3611575009962094, 0.2088337040996763, 9.3765377532754695, 9.849596392686383, 13.721125457030038, -15.046135786073142, 4.9703937867521075, -0.48233808501703906, -7.5370599111340466, 5.6031970618076583, -3.6816570904444825, -9.9435561934717427, 8.0586713169817781, 6.146380329105269, 4.7733622572729892],
                             [-22.522296996044162, 15.350243439545133, 9.6105097174181093, 7.3904286742704146, -6.6025191087051329, 3.1578186997826712, 6.0584635500778026, 8.2309779991194212, -15.691551538653844, 20.366825941113227, -1.4423187529969128, 4.8508163393604455, -2.709624902749507, 42.835879942244183, 17.929814637266595, -24.256762393069046, 11.683734864867795, -22.55276961618944, 10.100415138817201, -10.648210723489905, 14.586713720559713, -8.8500346996787957, -10.928253913939054, 10.527861831010384, -3.3851317679883137, 4.4454956245167496, -4.7013899884461621, -16.291220364798217, 3.7573606830877591, -11.519872594990593],
                             [18.016522904220434, 1.7068916122001951, 2.6280122446091672, 28.587727171937246, -15.094017540995292, 3.645022575638484, 1.8843215933594215, -6.4764455755041892, -8.1966808872978447, 31.088660132103069, -8.0833415256847267, 30.855514971048922, 15.967166696443963, 7.3218230131509321, 7.1882782666392204, -21.830354634897631, 27.612153430699756, -15.445880686227357, -12.927078504088252, -13.528182651625698, 11.824260730060132, -12.071737385107621, -14.224892576298407, 12.937658423106948, -5.5751783113902453, 1.4391745052749805, 12.560274010239612, 6.3411524516728068, -7.0725247249693899, -17.451213359725376],
                             [-22.881471299187435, 17.175842343034546, 1.6115858668932821, 4.7135305309821787, 3.6794364142732414, 22.788218284322188, 9.1950042280022419, -4.8560760835445365, -4.5141023946827419, -12.722445491901098, -6.8906903370104207, -29.695456925679579, 0.60633525758119389, -9.1663298055310154, 6.9456604532728425, -1.9714432695729931, -2.4560911826424334, 3.2534940734050304, 10.153336137468427, -12.989581077362331, 0.97921952300730353, 11.638293628770226, -8.2133127031006481, -9.9580292993348092, -4.3744525728302079, 10.791848499645033, 0.39193348921508964, -29.852257570493535, 15.974959781969504, -16.657964647822261],
                             [23.486587770754959, -6.0294682860060647, -10.982712801839737, 6.248610543613891, 5.318590300249717, 4.9966751236638824, -1.9843997011637948, -10.8588642021426, 9.3965980129071216, 3.8011175861470123, -1.4172177207331633, 16.264205438333232, 4.9012945757015904, -35.534960308297521, -5.0964656764943266, 2.6836276842685316, 4.3944282061155509, 2.2448220464999666, -17.215298429493629, 14.138679910477277, -9.6758416346554235, -15.006207583307763, 2.4670424480727089, -11.168291422335866, 1.6972439065467035, -9.8367530416554896, 7.7368042375968589, -9.5661793024276758, -20.77955115557182, -8.1516807848482298],
                             [-25.374840530645809, 14.301900061978348, 5.5816669707434539, -7.1217110060044693, 4.6679992945021, -2.8384405714522285, -7.8200642620377643, 14.302824834200761, 4.1511746234213822, -6.7586219587266037, 3.853569805231932, -15.653279118347406, -0.44820955483441766, -12.801578537113517, 13.820598385104905, -4.4134197379740705, -1.206334870581028, -2.5990924712537145, 11.924756237409937, -4.6211241202025404, 7.1568772419324436, 9.0500777617069463, 10.074423694791147, -1.3137948764918377, 5.6900334344929773, -4.8197464625105573, 12.388492856303136, -35.892995627389567, -2.3812837421903059, -17.903522131190382],
                             [9.3673563940753084, -3.6192399246010951, -4.5736742364908238, 13.006235111234234, -9.9612223807851166, 8.8529602544200738, 5.0675194274378548, 2.4370078070710783, -12.236865628315101, 14.167084035982626, 0.38521304851224503, 16.483319294682609, 0.051909950285681586, 12.861871149838912, -2.3696063386112818, -5.0354802740166864, -4.0825052726978832, -11.711875465629767, 3.5771500382527099, -5.0892665024422952, 4.1202070237272856, -7.8684502602241393, -5.1512515287349556, 4.2700835905895769, -8.1736152046627666, 0.098616411531715881, 2.7515391358791703, -9.6992264452930979, 1.3563591325416484, -0.13695849486388292],
                             [18.195150048611165, -0.32208877128950386, -9.3693270297439781, -4.7884752073606496, 11.358950330094062, 4.0540654168525272, 3.3452337761384388, -6.2597145096138611, 7.0212106044265461, -19.403020102461436, 1.5939457607195648, 0.59016154990409497, 3.1767835146215173, -45.238320555122328, -19.237001479223885, 13.674566344190515, -2.8883617439951115, 15.719283582872063, -24.540280933364663, 15.57719118725408, -11.9434539600053, -0.42515762173641808, -2.9333463835602815, -2.2169417899618535, -0.67660357343978672, 5.54939311296617, 9.3004728047118856, 0.51675454802712029, -7.1467204344210185, 11.672154677602848],
                             [-1.5114938135099107, 6.7575064004401932, -2.7980566838734506, -8.048087887385309, 0.84342615860797487, 5.5010522448569219, -5.8218126650649058, 4.9424439037338601, -1.9209102405613578, 9.8670339283584454, 0.092810925779320388, -1.0515841130679167, 2.3784868961991994, 5.2436425548847474, 6.0289269131867416, -12.687686409595903, 13.471020614457879, -11.300297414567803, 5.5566680684086203, 11.217613621692456, 2.9062230912389437, -8.6360225389358387, 5.3875975251949786, -4.8247278812782177, 0.32348783446991619, 3.2340974568398599, -7.5271392919816238, -11.276124785694295, 0.76548834183755488, -9.2049452440700978],
                             [-4.5112170546701131, -3.1840345733737228, -3.4605885049449419, 0.0098497049763237587, -7.4132622223045663, 2.0491859059243915, 1.0867031566604135, 6.4421065122454912, -1.6502692984346821, 16.156169365659728, 5.7233961865637513, 19.10862865145354, 0.93550450900733617, 4.9635536248422394, 11.146808815623618, -18.829098113948913, 14.771559612271279, -20.684309063397983, -8.7316330040612726, -7.8561957642989313, 20.958338904435358, -5.5306322078230385, -1.7806264303207513, -0.68826999564198932, 3.1618049362322833, -13.264802380295169, -4.5214548241594947, -5.8731500372641756, -6.2362143005505022, -1.5004233309084694],
                             [-0.50108199659017238, -9.3601064131761333, -0.80559913206749945, -13.791584395742223, -4.1612853733783606, 10.491686931071973, 9.9455734596135521, 0.61397740734496342, -3.2714790439756238, -11.027497763680444, 1.953307647455224, -11.371075142864981, -2.1795623028543032, 8.8953352119476889, -8.3501172689976908, 11.950798200560438, -11.486208905801274, 0.10490263643999691, 2.795770205394267, 16.230134091330832, -9.8871893266605451, -3.614089865955123, -0.63068741501623826, -18.463734683001928, -1.6284646648985808, -2.7659658785526862, -18.171816782891995, -2.1368949463163238, 1.1900858074653282, 14.402864814079026],
                             [-4.4721195131954588, -7.7103401869219335, -10.185386703000733, -8.6413896990768144, 4.5896961646537493, 4.4850495868447036, -5.1433021978748306, 13.617151972409657, -1.7040345517816362, 1.0026714279736622, -4.819695843599181, -4.6394046980278389, -16.475521884532363, -17.350625538013283, 4.2198387569634699, 10.660206835601494, -18.504054161269949, 15.879432716441091, 7.7397503506716703, 7.7203255952493821, -0.74197469042861641, -8.7354118412019677, 12.82250526747996, -19.898355672875812, 10.924534580860389, 2.954356239778146, 0.79932206853847365, -25.055830674271572, 5.4528386438765786, 3.1944066774583688],
                             [14.146067450997718, 6.7107996493612196, 4.6736025992970003, -1.3788948046504741, 1.2788189448873657, -3.6751297381209991, 6.76658022298703, -12.200127626864166, -1.2534262528524287, 3.9559654903287336, -13.628015234841135, -9.7257888096635501, 10.875075631475346, 7.1102409540079687, -11.235672822406253, 12.976249188611941, -13.331819611462747, 9.9697656774103205, 11.920791428701852, 9.0475774156553985, -12.043259402541297, 1.4851942151006843, -6.0609681572726295, -1.3843087985945055, 3.0353135190432048, 2.8710978228553006, -0.53790285588439479, 15.829687147893084, -0.33329612013672316, 3.5189246367038285],
                             [-11.766776729534339, 15.241841260021747, 0.63308642033106388, -22.109036817538698, 10.314564817980013, -15.866665513471977, -1.5402240382935888, 3.6300143302166794, -0.40817783889154935, 5.9173333254449245, -1.1736964937119987, -8.5488074195648931, -15.87942699342123, 18.593680348457326, -1.2133992908556062, 3.8218156551963212, -10.598380060357961, 2.4281147305781694, -7.1750413694710655, 7.8357940146880773, 8.7143694697225254, 3.7405083769427709, -3.7036376640089808, 4.3285739337010334, 3.9847815132204034, 9.6472996495756487, -13.542267240676217, 10.850574084723906, 3.3945750853911436, 24.350156661431921],
                             [0.79889418580280169, -2.8675911130150609, -5.3914900405818011, -3.5899831666971385, 13.723032034982346, 0.92750458501294397, -4.5475418010457522, -2.1345562351716096, 19.360421287035273, -19.954954151442479, 6.0285470128573344, -4.9482150571491035, -5.4753989664586626, -30.404633445025535, -2.0616599600948207, 9.427178136585427, -1.2111439875559977, 10.540626004148871, 10.589188515696707, 14.914699457089334, -20.184761838207898, 3.7857874114934238, 19.183129676143462, -5.8813448683121008, 7.4290992779467846, -12.768162652169638, -0.73324646096877621, -11.931684423956701, -8.1493015133238931, 3.2284690442613426],
                             [-1.0542266413640315, 9.3041832482333309, -12.873794531458543, 5.2217532719869872, -1.5660605878949023, 7.4489685045231928, -0.87660219695367847, -0.4660198566944368, 8.0535369965765948, -0.64523406258434157, 1.5823812356666633, 11.543626751508391, 5.5562885038780099, -25.274471550507894, 4.6883104686386909, -4.5298183647791284, 15.131902987075419, -3.355969730308709, -0.56694842813598956, 4.897000371034923, -6.1307539002063756, -1.2626497407830777, 6.5366422439304088, -10.495767206788711, 0.034570632528861889, -9.9196806789342933, 2.9849808758833642, -24.116189900581851, -4.7978956332466725, -12.428602070510028],
                             [15.658687775421322, -7.0477793320636337, -1.4728243758854742, 10.498924512980267, 13.380686881539997, 15.789906665876357, -4.3535119632280308, -14.177434477425068, 15.023593347642093, -2.0244512605524254, 5.1543618368230746, 16.078832912666435, -14.915411010240939, -37.821218684425304, 4.0951268900958935, -6.376278139641153, 16.245049365734612, -4.3335203000951505, -19.448139476034864, 17.359987444123728, -16.905430305110048, -15.458905976686884, 5.2729314220249464, -3.0486782266067327, 3.6458001383715843, -3.9974476360992028, -3.2590383463365331, -18.642046562474953, -20.485249480404793, 0.54308313214446802],
                             [-4.5713607248166186, 7.4324570215649981, 19.352456663237593, -23.226390430578984, 3.9507112929063717, -3.9393971612052678, -6.3614128014017686, -6.6923304729260122, 8.4553143021178769, 5.6223017180836532, -10.022592724145174, -16.857386506606073, -32.064046214794956, 8.3637462090843133, 3.4063297721216821, 12.988952591499803, -8.2360301550037516, -0.51325135313288672, 0.92510498386007023, 6.3937843373846253, 7.5171171500042586, 19.949036935124823, 8.2213056101844408, -4.8019236647706984, 10.408492816211535, 3.8325558271592435, -28.686207139662947, 12.938858371377469, 5.7786752761093076, 40.24437713951734],
                             [15.296730101230965, -15.632281303438942, -20.760484032149684, 33.337187793103837, -5.6879509996382849, 16.52540148919535, 8.1848952284540424, 3.9577891580530129, -3.8964961430211962, 9.8614824554914406, -3.9571716112475337, 34.066947409192032, 8.1794030620813984, -37.19174920879194, 11.030609818153696, -16.708117646936962, 19.586941033817062, 10.269271447499593, -22.812200309941282, 0.96936410711362309, -3.7811900784061496, -28.901681882993341, -11.033380949187311, -5.8529903733557607, 10.203181254139668, 3.5847050648097816, 19.031619603300491, -18.831066020246102, -4.7664526099558957, -23.905268923899268],
                             [-0.77140705668428033, -6.4045635140749528, 7.9266425457236904, 5.9332054973635922, -7.5876401812309462, 10.033489569253387, 0.71072534957250111, -3.5724711484154392, -2.1358209995465458, -8.0967040071368288, 5.6787692124882501, -7.0593584121005861, 18.001042258035355, -17.677241458322438, 5.4618484700872809, -9.3192350038547715, 9.4660120441063924, -5.7183122080322795, -1.9584083587986323, -13.249229471103417, 13.751185971804972, 3.477765740779112, -5.6606543720102049, 2.5245283827162965, -4.3387549157876091, -5.036953415103933, 15.505616320632816, -1.4288557761150791, -5.2719053335661235, -21.515180856003834]],
                            [[4.248589222037241, 13.915889411870031, 3.9262373612688903, 10.775102309242913, 13.382029986230753, 13.617454869287355, -13.724195087460631, 16.548659284701831, -3.7886755969185679, 17.08148693236825, 13.160805601103979, -25.271460951686471, -8.7940146920109097, 1.5946749327683316, 4.1639694555879849, 13.613573152371838, 2.3828135010984575, -13.642554854376819, 14.56033755331131, 4.704043644113459, -18.015767254877233, 13.213421936669612, 2.2211891510342876, -7.0393058072074117, 20.435860080378859, 5.7665926649694841, -22.79518506242848, 1.193194440708234, -3.0027456699698689, 1.6129139042331588],
                             [-5.0908617324918657, -9.8253722078070993, -26.264811238075019, 21.196219336433145, 35.210584447698302, 33.220301356968506, 5.7442155594050979, 6.0707659781546806, -5.2113765381607768, 29.977161907991338, 33.388634795984551, -31.47079105266889, 0.11374183108037667, -1.5129838611466999, -33.399907254028221, -0.48049064584503637, 9.9470363621317581, 7.1621275847719064, -13.489255686302076, 13.195599751627718, -23.93965456292932, 0.98482531440586774, -28.881661148434027, -13.932177478792706, 39.427663315593684, 23.899281809726038, -10.980064985759007, 28.891417321274432, 5.9109477847812482, 5.3956222869650592],
                             [-0.096132906707083465, 3.8728439421652419, -22.273951333321399, -12.212866323457133, 27.857979784935054, 44.457908851932956, 4.6543718702693111, -28.737282606571242, -22.369020044284341, -4.241224613169587, 31.461647737684853, 4.8753945372203953, -2.5507370496034123, 22.99267635983988, -26.564297009893671, -2.554022166325407, -7.4750964647136797, -18.491621752771806, -15.966403040745892, -12.588849692134225, 8.6763281916423018, -12.852891251004472, -35.173670582295983, -23.880350869053512, 12.392024853959436, 21.960352587464342, -0.5533430802571162, 27.141115342575912, 9.8274384974137963, 6.2797565354988842],
                             [-0.11609154047684211, -20.913909385587463, 3.0983041124814066, -4.6850740322742617, -2.1980624360298759, -3.0297328443580289, 14.320454578390203, -9.5141233502614444, -10.054795806842197, -3.3361500112467266, -11.134610939522329, 5.7925794279952738, -2.2817267822471461, -6.2033154240775845, -17.170252834375408, -5.3958974190236813, -7.8204181880307919, 3.9784077242193643, -18.441724595123745, 5.552404326090417, 6.7602244281394661, -12.291202764641028, -7.5875357309420286, 3.3388162764005567, 11.780099953295421, 8.8015120604467949, 3.7791229224689662, 8.2308150720914295, 5.8133921294645319, 0.35799544454124099],
                             [-3.4700727143886461, 19.174594344733407, -3.3790275910576701, 9.3610290948198713, 7.3577757485214885, 26.565591832065333, -10.388855870621494, 3.088990183534698, -33.40539603369519, 8.9726394842466473, 39.279925638747116, -9.8015382583294173, 0.33490937371893115, 8.1841285558313803, 3.0550000396011923, 9.3332677164485993, -22.96662613556143, -20.092717596599837, -0.54600569717611303, -23.221711806075117, -17.443165769100702, -2.3048634487130983, 7.4985406256894001, -34.837372742261842, 4.5345308459378071, 7.322166964549119, -27.526821315768068, 24.703973252093153, -1.6589414913798546, -4.2595228271811534],
                             [8.6257257260656743, 22.870280246151619, 9.0539229147271936, 0.76678945391565145, -7.2879178717908148, 1.3354791401487847, -20.06324911930405, 0.95095761790717714, -1.7978223508406987, -5.6092026570168807, 9.7513169232865753, 8.7438990076890732, 4.9941949036351154, -0.63422954043886792, 20.742890298436421, 5.6029247012012284, -21.05423433732166, -17.990687843841634, -3.4163989394929684, -23.316979206105632, -10.203001336053383, -24.291856254940324, 21.051140024615293, 13.478958758614436, -20.619731361415948, -13.363697626710485, -21.614112629808428, -5.5644839431691056, -0.69608789240410363, -16.822108637300179],
                             [9.1366868183426799, 38.151440529011104, 17.339979940314691, -6.1388409329676898, -14.298588247947041, 2.9853768075318494, -29.378150326488107, 11.79703971690202, -22.448085655289102, -21.471502226332426, 17.828263804732863, 14.801604164892213, -22.063955952685468, 12.560697962975755, 29.494435077167186, 29.777340072112299, -19.986096982321857, 14.559754590964758, 50.661640040261105, -6.791473548862661, 13.096092345893032, 46.619910065197686, 25.851850802559674, -70.312120231383119, -22.038376659371838, -2.1334984527915313, 7.8661778429387832, 3.8697078506021612, -6.8720621562947048, -0.97109763657818138],
                             [17.338744032930567, 27.805347903188707, 13.581290914855995, -8.4908840358167108, -1.9150635940837921, 19.3750780405122, -46.325924079407258, 6.4399054065617012, -16.948840814431371, -16.885668969622863, 30.187852018603319, 30.509995260040249, -3.0756357355281883, 13.900483208252112, 33.378062021230512, 10.281065135501123, -15.694320186493082, -8.1032796312766884, 34.051972992035715, -22.052193112796981, -7.2497642240983629, 15.755460390357236, 32.320248549173591, -10.389997937986493, -25.695524852060487, -17.82778023708174, -9.5655886017699832, 6.605721141896888, -15.968514947662275, -4.7130401888916573],
                             [-6.2538569717228887, 13.002769404864585, 2.115880462998291, 18.144529137964643, -0.16695026758249804, -3.4677759359438545, -3.7927701177451505, 17.737797603748433, -10.641635115875113, 20.842088609427144, 12.923576078834532, -22.011811457531817, 5.7872027944313169, 0.26527161527423637, 13.182529595199059, 11.777280567674374, -1.5980007272171215, -15.985355195800793, 16.563019461248608, -6.3839945810742149, -14.314491811764315, 8.3568100276250021, 19.83983156244031, -20.67640882585825, 6.1405675739926711, -2.7816652860886655, -20.850169851947879, -5.9906651517467466, -14.583763772796564, -0.4722197588092541],
                             [-5.9628122554716017, 19.505068398141855, 15.273415452022697, -1.2387026829846126, -0.16456245441862952, -1.384745855373207, -18.836595410687352, 6.0554122783909614, -6.1840519632259721, -3.4077623483194901, 20.190346151715147, 2.3681895537626101, -1.3824550116559384, 1.3536988710474336, 33.431621890439494, 9.0036868587624213, -18.151827258549829, -0.051822262489416064, 5.2755956779559527, -17.715812844956726, -13.972547097013416, 7.0976470443156545, 25.116353779076373, 12.498106315290894, -6.1336898397967108, -5.1409533916518235, -19.014513693483526, 2.8334194711517049, 8.2554384757816273, -6.1341749498744127],
                             [16.190907773201026, 28.733723217229329, 6.853045943800228, -18.062759588323335, -14.356473560063094, 12.599662317506624, -20.541022486644781, -6.8874102081881521, -24.703401281247338, -17.310952977754223, 15.955760315574416, 24.818488726196311, -13.995845110953889, 14.532754285426069, 7.4064203147187948, 17.031452350434016, -20.150168128879603, -9.4665901219007722, 17.264168994369058, -6.3372389760663799, 17.809719102804955, 6.4086152863579295, 5.8199816523631993, -42.704522275172579, -20.138157623873017, 0.92448464255319873, -2.8945173519930107, 1.6631282862602108, 5.4092379677048577, -5.8776088048041535],
                             [5.0715259228717251, 24.630202385891764, 10.409324461350462, -2.1110062862634709, -2.629998483221534, 4.3610402359390674, -29.442722475605258, 11.218081103014153, 0.12995684322169693, -23.576773148850418, 7.2526196493449513, 13.774562158397227, -2.5393603732356107, 8.5227843674444692, 33.652836729607998, 10.535892311184398, 2.7616783694986298, 5.9919422222248357, 39.914160685345458, -9.9287723904863157, 0.8732308025688289, 21.162465026401296, 20.45263684159082, -18.069032639276386, -27.226835954853971, -17.337746329651232, 20.823843917532827, -1.7464855699436588, -18.756678192350883, -0.089987773859315195],
                             [-8.258942655975174, -17.90249160835198, -5.2444086015390177, -11.603679247504372, 9.8867536503518298, 0.43168533188751829, 15.815458260691571, -23.273419445290035, 18.576613372058137, -14.164630410615713, -7.3823226937795017, 9.5179956362146623, 7.4298396565058908, 5.1450634116772003, -9.5222925418647293, -3.4214175287863551, 5.0735398354078658, 21.862688580353847, -18.637521253241466, 15.143784991754618, 7.1317829793059246, -3.0034961709988912, -20.969578901377506, 26.805014951460961, -1.6115931508730494, 14.131511505840487, 24.8290761975246, 3.9900819725665553, 12.492388454729724, 5.4844711448343881],
                             [-22.419088494377196, -9.6597791890617053, 5.4216567838905076, 2.6267124027822328, -19.511799529678996, -26.132538902764956, 21.013217820342607, -3.7772817305823896, 1.2026760514597976, -10.932982054203407, -8.0595771328466448, 8.4484428295990632, 14.562367159524122, -7.9147748363686201, 13.197360409580588, -3.2180876216055601, -17.211151495825366, 24.156787783600731, -7.2411738528270062, -4.6509736062243139, 2.6421598849793977, -1.0260877638755805, 17.881976096212004, 4.6628268808363273, -10.81933588869116, 5.1068487076317215, 18.58079358838209, 6.4619362236023781, 2.5774706520106441, -0.56354208462795585],
                             [-16.906963218579776, -8.1368713201526912, -2.2277450406241552, -12.406412801971639, -36.525102005947176, -55.263399053883916, 42.90880373876228, -16.565316280814596, 3.1759358483328297, -11.776344552948776, -35.309044060346238, -1.2901909759645083, 4.259925438360046, -6.3197932583513916, -1.216488767472522, 3.7261809313920038, -14.201296647134461, 8.3586378790479436, -13.606153520849579, 6.3383238730344154, 29.729800897221434, -12.139877619221542, 2.4799728436038748, 0.094552564194932839, -11.984977450196228, 16.412779918153134, 5.0325088413597285, -24.747143562987635, 18.117625910602737, -4.4000063145340675],
                             [2.9877743783506059, -13.103485192556363, 9.2977566992556397, 0.71588348279292513, -40.35583126223937, -36.679162016073008, 12.353449063619978, 5.9842047110604488, 15.599260008726418, -31.360509189278531, -41.243646751969969, 31.27369152558996, 7.2668736590458494, -22.363647348255931, 4.2075653246028883, -7.2525741768954912, -0.50746390024195853, 21.116221181848342, 7.768236820873569, 8.0100481539078956, 19.38938372853503, -30.932079056048227, 21.457147351042249, -7.1393787171275251, -44.295692835223015, -28.844470311401256, 40.16938282009405, -19.730012407221906, -22.891079796333734, -9.0073779199255544],
                             [-8.7034002745305212, -9.5424881240673862, 12.157180146786736, 9.7763320339563471, -6.7279617219260031, -7.7296572879624774, -0.013210949501257592, 1.443355189800777, -11.278220048203536, -0.97982845526189177, 3.8779515538632396, 12.478649038352463, 6.0037748250905834, -1.5988048750886132, 7.2175944349772951, 2.5837988782983121, -13.363705250588589, 12.419155107511848, 9.2150624331928519, 5.8280931839144268, 1.7406400030580278, 20.614485036539758, 11.856452394075749, -12.653386009664514, 5.4912539695230738, 2.1801345851940934, 16.818804717707831, 19.504824762147852, -7.8187029172815201, 8.3921654295578687],
                             [-17.403875250654099, -25.850462381891159, -11.070729275895841, -7.2005153845565362, 15.589920412490935, -3.7332515638514718, 32.247070026578321, -20.218059494095712, 11.138879916236114, 23.413761964619937, -11.382525205042805, -24.363586262400776, 3.9884774269853134, 4.7615297117903559, -28.701624289463972, -14.579889798905088, 14.060112390177158, -0.80604159710192358, -34.401066611892936, 17.388803615092773, 3.122155851815243, 4.8855121341867278, -33.904684152042556, 29.654761878916364, 35.896877274362183, 21.01132255077772, -1.8211277406676309, -3.3421451430263818, 20.047675029511762, 11.12420456608173],
                             [16.707289624864394, -1.6267895585610923, 0.37296388669455427, 2.1189157509930467, 3.5850333177491538, 21.481940958509259, -11.889005431176072, 6.0793369260156958, -17.993690943994324, -6.3825665373541787, 5.0581503862949146, 19.113614206902781, -9.1316966374643993, 3.4970181700475811, -3.8158959250301452, 0.4992243237797121, 2.7251118891464379, -17.839730898365946, 18.858699965371862, 4.7690155921189419, 10.531944040080791, 4.581144691312093, 3.1537840254342275, -37.701850336024449, -9.4099341218134676, -12.018825181436782, 10.235093901939459, 7.6349916222924756, -19.541542172068521, 6.7759857419661307],
                             [-13.227278388452808, -4.6957508545482929, -23.112956075902872, 3.0152776201230451, 14.342627438701946, 24.141583919970586, 4.508676861280712, -20.453513722545562, -3.4263819404082008, 6.5557220457758643, 21.812352527637479, 5.6142682481694139, 28.660458309708652, 12.025426193378925, -0.52924651919033017, -22.039374431096572, -3.9256938729890956, -23.160225565841706, -19.974958076883922, -22.411186535638532, -14.728130839377016, -27.798074756973641, -2.8850233241163621, 34.223388750257499, 1.199497926152064, -2.5811097475375755, -6.1961809870085025, 21.862303323206735, -3.7775070141442728, 2.7083885939621029],
                             [-10.60105664155269, 1.0780905743428117, -8.8673314807893124, -5.3106311187111332, -2.1012801783665975, -5.2844841522531638, 18.206067093594541, -7.2665628709681229, -13.603720306302712, -2.1914293754585166, -1.3281628279847246, -10.12283663552931, -6.3099675580372789, 8.9905196142381119, -10.567541334407009, 4.6397862583805773, 1.707244963963702, -2.140990828990474, 3.8066834821720157, 1.732676587814481, 12.099636705856474, 9.0012143100431636, -14.996285438622493, -27.656580390032396, 5.9793823383095059, 16.975293408160546, -0.56068414464813709, -3.4876925599374755, 6.1720813987650773, -1.5614671463617738],
                             [-0.8394166495650448, 9.9584335048980908, 4.6254455323473733, -2.7276313287473481, 7.7260689140431715, -8.7621903071362333, 5.3160272396736641, -0.44486093360583273, 14.365056159859433, 16.958443510467561, -4.9388764051247707, -23.911969589276431, -8.9977507724713082, 6.1076419250387977, -0.27607617214659602, 9.4150915407360785, 1.330850261114128, 0.79868494680973678, -7.73687812906664, 4.1434484658850907, 3.744395895694788, 20.62974557951792, -13.159197634626747, 14.519380635117043, 20.124385397075812, 14.034621103410434, -16.842358826162798, -9.8072784635590846, 20.853979960714767, 1.3940714338126874],
                             [12.775678296926081, 13.549090838485244, 9.6422840521912239, 7.6211210584879909, -1.2034788818992022, 19.156137946505105, -24.253051820103089, 19.156185562806222, -5.0604298970429662, -4.7194247529156801, 14.579503103548808, 5.615701436534037, -3.4460500807492558, -10.283684690452734, 12.622841060712149, 8.0687686568981327, -7.5973558557370913, -0.34431731969684692, 9.730808203199194, -9.7970665129057775, -14.24876900713485, -10.522780826440025, 21.534696520413238, -12.365379271304281, -17.934907215660587, -16.153342723875859, -5.4274920157695075, 2.7896730416391313, -9.983954490210694, -5.1296122250963538],
                             [14.709589266738565, 8.7008263286298337, 28.963215598875419, 16.304897377511136, -22.758609992898705, -5.8298185806589133, -31.310986401433357, 30.833808317798045, -13.742957650815338, -7.8561288745112083, -6.0977735583454686, 29.559030781344823, 0.25151950849377458, -8.7083223106370067, 27.915076330982959, 9.7416596181898854, -12.400814418060856, 4.5094703345173563, 36.329528604180183, -4.7595987333388994, -6.6106850590627717, 11.997791709359619, 46.424917596451841, -33.416908962393265, -21.466124724847454, -35.396305089478332, 11.187994983630309, -2.4823213459979971, -37.226654298120245, -1.062914035783123],
                             [4.2790494228518154, 6.8366636300100501, -3.4525139257757962, 11.45042446880348, 17.77802747051588, 14.616392872752987, -13.251535694265936, 14.812090646053722, 6.6651737289299025, 17.300628802664711, 8.6132866834880026, -18.097861626787832, -2.8641314762660972, -4.04594523831096, -1.3825394578612999, 0.70442941725519614, 19.980249509141171, 0.87856387906425948, 7.2883524183279018, 3.0141114528104747, -15.792761280062066, 3.0474857327892164, 0.79655123366604208, -3.7740589179613666, 0.34080683377964816, -12.689615157156815, -3.792810796897764, -2.0165343246122283, -9.2446215488776673, -0.75455133717091583],
                             [-0.50691338442111011, 6.6535063912260091, 10.994306569017994, -1.7890405832232628, -23.421038082487986, -23.243601261968418, -1.7320610839512247, 3.5962613216310126, 20.495262342241073, -20.994304242683672, -14.046077884814732, 14.41273290046246, 9.0496490699911618, -8.9338447694321204, 30.277981843232222, 1.3358236704689643, -11.520646661225875, 24.661345759283304, 5.9174008082649765, -12.465521344241347, -7.9569344743617254, 9.9739754575249311, 23.782323762928744, 25.321909227507671, -24.913500226300027, -12.263412889671628, 14.844935944724288, -5.9454188876488594, -3.1286826841754403, 1.4568326764277564],
                             [-17.786169807809021, -13.132729393912625, -4.6610421948860141, -4.7564645702637565, -12.869192279565086, -24.143686482843432, 28.063853615314319, -8.6577794688209657, 10.990917066373937, -2.9318516997528534, -16.154991487319926, -13.764698881020278, -4.5278625998255988, -4.1339218353215053, -11.727294051631738, 6.3876473243396514, 0.91056703759304569, 37.521240279212307, -9.596260967028341, 20.126075312857061, 13.893492529364831, 19.645129766215714, -16.98874444384786, -12.600355168958767, 7.613960033098512, 22.432176681285053, 20.435407308793227, -5.3963905140039463, 14.997202434434929, 7.6153883317714426],
                             [9.962982748563352, -10.420398461825975, -7.1837513912884701, -25.86302196889903, -9.3565701083441759, 0.059648226157062077, 6.3810218871405553, -25.626745503569747, 1.0178350473419666, -37.053447231828066, -13.436732845737096, 36.061666594370436, -5.8709113860634607, 5.6773924784928109, -10.992364287752794, -2.1298940038813621, -8.5920164210442138, 8.9279376304126732, -6.9372053741727004, 2.9063824324300795, 27.812788936730726, -12.16317845063994, -19.468850348408424, -2.0400957112566283, -17.727321718925076, 7.4556159338114769, 28.978940300509691, 6.4841942337286316, 13.651037785481032, 0.8570193356820025],
                             [-17.371717978562494, -6.9159385820964081, 7.5152453381714581, 32.470176914381106, -14.346645502495273, -13.468857347055859, -3.3562630011306767, 29.41898119842147, -12.178044430919835, -2.7118791302525351, 14.486293679397464, 4.1098706998886563, 20.816575964396204, -22.000530933379839, 20.964939655939499, 5.1127117181951878, -14.118376237531457, 26.385336385815581, 20.892025802518006, -5.7049631373324541, -20.313300392967708, 5.9105806347353207, 47.37342715223857, -32.203658770636146, -14.712840022099964, -16.856505196579967, 13.430946431125376, 18.06702760028865, -33.790126566586117, 1.4729111422480432],
                             [-1.0318290509363406, -17.153029579704437, -7.0872465925670936, -3.6806628941148727, -18.590722818328203, -5.3036396265087724, 22.162273350289308, -16.747695748880734, -11.688480175577359, -10.034437338627201, -19.899219404961993, 15.595833331887356, 4.1158912959818341, -12.679964078104902, -26.568025086021898, -15.388172688591043, -7.2638725191676077, -18.261790042956363, -33.406425003849684, -4.0894799837360942, 12.713124020366509, -55.356451107232701, -10.414805284697655, 13.038056506383921, -9.3121866861107367, -0.81045334005091907, 0.011094788289547838, 1.4370452611707294, 7.0105722482359942, -2.8662736755946896]]])

    matrices50D = np.array([[[-0.093818406493838699, 0.046232404587709455, 0.064822134949415106, 0.34358195250615498, 0.021814532766333796, -0.05720272079775706, 0.085777478750329525, -0.15040402070976377, -0.062424065453928979, -0.05945694261372559, 0.050029522975409239, -0.29205767075522449, -0.075104519938445094, -0.39328114563674904, -0.17565733440778683, 0.068924090592573858, 0.20384517688218395, -0.17481520901231273, 0.22917135147423687, 0.25990928434277283, 0.051716615677841506, -0.053462170338856689, 0.27545349149326481, -0.055188992753505181, -0.028361439193964454, -0.33213537756892925, 0.18380927263927666, 0.22475123767029473, 0.22242935251470802, 0.31491457740067064, -0.11098013112784834, 0.018758705062701359, -0.10861648205547009, 0.23240127129010937, -0.0097281264381499158, 0.26618493740481852, -0.22050619691257117, 0.025417493362523066, 0.1396223894090998, -0.1569915943986166, -0.2987499359729115, -0.122502568494327, -0.018793954930530314, -0.13996347250885083, -0.43582892681292046, 0.32558666676116216, 0.015257998902124564, 0.26915857697043327, -0.066042777515433609, 0.15475136143123747],
                             [0.094674107102242763, -0.23892882168645665, -0.094959383742315856, 0.32559860455559475, -0.16868233310603975, 0.10919634697859686, -0.11542450017017584, 0.075872550369799521, -0.077978930701732826, -0.1774411342114097, 0.21238917048642361, -0.15944028955200482, -0.11355365919967297, -0.47418416003779801, 0.20091528536096592, -0.08240988885755135, 0.046692648711241173, -0.34984827848710504, 0.10224429339405297, -0.13401048671601298, -0.10538459989846773, -0.16967153017152936, -0.030950107278368829, 0.19680172672744528, -0.036484997549768666, -0.28647823802172467, -0.24654074750294222, 0.014872240292568714, -0.092854838179542251, -0.37398041672280907, -0.32418795411738682, -0.094155218684410041, 0.069007253059697113, -0.19352112209879432, -0.043080623584575171, -0.10404710120012782, -0.3852398625102128, 0.036087411210468288, -0.29647831598091712, -0.074779360002190196, 0.087856129118547038, 0.21513313416311286, -0.19874198043407665, -0.31761531171028712, 0.14453883768809817, 0.10261190147445029, 0.068870663761672613, 0.47389204676203706, 0.19516483135206697, -0.35557687920661246],
                             [-0.1533046414116685, -0.072372488615415176, 0.032127430687375245, 0.013381515431728584, 0.31905968751461644, -0.044513890400145167, -0.17139945415448665, 0.21308668052412444, 0.28604951240362064, -0.0032473679964973648, -0.035656559305832697, 0.080657000472637588, 0.064310668160973056, -0.18830566184326375, 0.11899706148219377, -0.22811552923162826, 0.095306531320436455, 0.10504666280126379, 0.10224879853933169, 0.31891458648082621, -0.0035048609697098457, -0.14623167498883158, -0.27432064242105964, 0.083214082072755047, 0.068286494172440121, -0.11587632406640974, 0.03831508039958316, -0.25799638962273058, 0.14085167031203905, -0.27850705827392225, -0.15794575756888116, 0.23455399458393239, -0.24449449407796989, 0.4062823340079495, 0.48506352546762005, -0.1429915619383714, -0.069335817342635275, 0.26830151584028766, 0.1402178345564449, -0.38871662406820112, 0.10833280241958729, -0.13928501067988902, -0.13605291402975245, 0.17292689473303746, -0.048987615945714755, -0.24982072505042383, 0.027582241459622403, -0.069492178464162169, -0.21250055545386462, -0.23000242705450238],
                             [-0.25567804000978739, -0.18231092943920296, -0.17454227377055392, -0.20885755349315274, 0.02230695372661181, 0.15846326034607514, -0.37073076655596998, 0.29147877359255325, 0.22287133391876307, 0.28988750879243408, 0.0022741897530291905, -0.063498493074342813, -0.21340708004839881, 0.0041978572709236162, 0.19699951540817773, -0.088700087356546414, -0.011395949935727012, -0.047595592253978962, 0.25842913515634014, 0.19318785280886641, -0.0096324119631989863, 0.11664359310885088, 0.15250700661121463, 0.045153492348272616, -0.34691066204621418, 0.41725583052907278, 0.3144074601498531, 0.087821466555471087, 0.065069071308796328, -0.14160451072925273, 0.16622412614180129, -0.56923997338829957, -0.041317020141346361, -0.24220190958313256, -0.043257707701076384, -0.43728231734486911, 0.16250027662332556, 0.46289676375457056, 0.11164167038703403, 0.27142719183171315, -0.15078309377178423, -0.052914466546749334, -0.071421030735335483, -0.14043946379691474, -0.14588168088015396, 0.051132658488439044, -0.20165179065360397, 0.13600823661219186, -0.15805495526329225, -0.0019205146392685252],
                             [-0.27064269653043821, -0.25700181437128766, 0.01524128668231705, -0.15131240570688734, -0.064902412870313425, 0.33826727303624532, 0.0030957971310737343, 0.048327422035593953, 0.055521847262188791, 0.030701750798225111, -0.053926788962484491, -0.51787637579979529, 0.14200193887245352, 0.26466216610647236, 0.024495510194070612, -0.059145990056333406, -0.035156931294710106, 0.12813836874368698, 0.0055438061701709087, -0.27617032959687571, 0.013692876234355361, -0.74200638474217528, 0.075337354342460944, -0.0027126408820965188, 0.2413626314924098, 0.15116248979797353, 0.13307472313402741, -0.21131431327906267, 0.32783334284259513, 0.22343629912726903, -0.096083538909833829, 0.041269936740195967, -0.12357588430664093, 0.39974965888402841, -0.045601114413814647, 0.186214162704259, -0.12457496093434969, -0.06994099078098627, -0.020516215461307004, 0.16571611103217179, 0.094851797745162891, -0.050564134382107412, 0.03431806765190927, -0.15321326642954694, 0.0084064294301607057, -0.043686339819124835, 0.020900438672434775, -0.033616179327514324, 0.49844623406380978, 0.050324033585164948],
                             [0.14797063527236051, -0.12436318087101626, 0.020029028793804339, 0.39016724354357823, -0.21801589350040343, 0.31358085632281318, -0.13681776358937656, -0.027053099001142809, 0.066921160671086818, -0.21181207321705595, 0.25324521317606657, 0.041968976926776584, 0.19728415179131045, -0.23741421193342585, -0.11237444022221271, -0.12709668269094077, -0.13443310898570615, -0.17584089029294167, -0.12745343244734289, -0.057604557478034925, -0.080817551232634011, 0.10107249644134926, -0.13620053641291699, -0.20330644007916859, 0.57711420421392001, -0.049845921364270018, 0.53435179662249821, -0.27981007987398643, -0.091967639238636462, -0.1538344089952646, -0.1417658738774859, -0.18627686379708111, -0.25318766050194796, -0.045084315564699953, 0.12760256471486336, 0.057749820337273654, -0.026864252670300334, 0.10840377964457643, 0.3957016607799636, 0.13806306984421929, 0.026199641397016381, 0.0017480863928724913, -0.22223351199907035, -0.025570285649652014, -0.051815589362785658, -0.16697062191576945, 0.17156586506073315, -0.15220979677051313, -0.10130055225584385, 0.073315799665708142],
                             [-0.27330539699656248, 0.076523574729922772, -0.39810879295212642, -0.037635659740085994, 0.034819338095175054, -0.10982436001108811, 0.4463483647895467, -0.30032984136535379, -0.20088044004845912, 0.27758643855569004, 0.21409942886432018, -0.33275698697047623, -0.044151132244145297, -0.06817822091103691, -0.040101711686091376, 0.024046153878495038, -0.13943730682855651, 0.11044880588777371, -0.30637972075925707, 0.23140357928764221, 0.090294899731742206, -0.13964463304041994, 0.035813108616007061, -0.089925915505507381, 0.15838694650193277, -0.067234289114522519, -0.12810793070579074, -0.10047220292912794, -0.23680343089021844, 0.033748796749504692, -0.070348044460712814, -0.31981934660836919, 0.096616759217661691, 0.063838667718936815, 0.1111808248085947, 0.014082110011025814, -0.14522403779660817, 0.15371563918503731, -0.058025021798020826, 0.033961083571242681, 0.013867252036818052, 0.18421341513609663, 0.31653864472534382, -0.12939811057789793, -0.16627536938081691, -0.22457508645604385, 0.10166945419343724, 0.17028863334769814, -0.42531496394164481, -0.22429291952941877],
                             [-0.0021343171699946123, -0.057237909526930905, -0.041794101380308438, -0.13694830080625475, -0.082192663694579032, -0.10492175688372408, 0.14686063502816951, -0.26045672985465385, 0.17805772023567262, 0.10660582653471468, -0.34448699995325377, -0.24540251825411122, -0.16547403602501254, -0.12176756312950475, 0.22383024122188078, 0.29542810034374173, 0.51525333722117239, -0.086247154177805763, 0.016433311611036436, 0.36577946473675915, -0.14508369052253678, 0.25052906623414428, -0.12801852711152589, 0.2185583218466281, 0.19134753514749483, -0.12810191621290806, 0.21041847878938574, -0.267121200575128, -0.1290969577223427, -0.28291632715904191, 0.21141879696090646, -0.058757797417721622, -0.012394588223481148, 0.45004798096331378, -0.096593159822739416, -0.068042663062442749, 0.16357618664384338, -0.11886835833707947, -0.17025638807447405, 0.47780383293942041, 0.067903382975960588, -0.36879402333316402, -0.17729548387750177, -0.05651852691156372, 0.19549988667534102, -0.19463600800396441, -0.018190318224197061, 0.2028337022013032, -0.17798453488647989, -0.028288861734090606],
                             [-0.34385595335529556, -0.15465515897601204, -0.028243377810923009, -0.3415834967634484, -0.2366871174773357, -0.28544017297852403, 0.012419518521437899, -0.11425194269447024, 0.1856038812054302, -0.010691478082930649, 0.53126534094519584, 0.030619873536472879, 0.2159923848667844, 0.10193005775160471, 0.0078397219866266979, -0.10684514187084219, 0.33013875036353812, -0.22879743320343573, 0.063603306581794569, 0.20555853495680879, -0.021718748623358073, -0.011061074536452276, -0.048980355168085327, -0.030232825082224239, 0.075826830469102491, -0.17289536359582214, 0.1771252356185698, 0.19139448697046563, -0.02979102102290581, 0.16285491623112838, 0.025868488507900803, 0.022487793187848406, 0.07198207577553474, 0.13751005729481158, -0.39711175583593417, 0.077495509398578924, -0.079144654538630066, 0.32866446633359864, 0.002239584420261842, -0.025345121170636094, 0.20440996045527995, 0.23142289271273453, 0.24303867657601583, -0.12110963881667737, 0.47857850126319773, -0.15854863058834667, 0.18216864467344068, -0.12265517476031074, -0.0042059191598879326, 0.014089032101963491],
                             [0.025150459204580526, 0.22353208414769501, 0.16011962787643655, -0.15813947879205062, 0.080158661279674928, -0.26626953865062053, -0.002933545543145755, 0.28960081517080627, -0.095884768438318724, -0.15671625931058564, -0.084672354721877868, 0.2194548299837461, 0.14023404460202996, 0.14530766363323003, 0.1072773759212287, -0.45258192557488891, -0.010886844369455858, -0.071026709519858316, -0.23854553799501219, 0.36712063813516188, 0.099658069119165305, -0.22583393256556183, -0.19294513940718053, -0.1178215012717793, -0.016270967659514864, 0.057874759256891964, 0.27512419381687564, 0.11406013679492383, 0.11427297542474725, -0.27807792738754594, -0.33357847925959183, -0.48562148552937928, 0.082019820904855018, 0.088803615867898839, -0.22295302830439034, 0.092375992620431599, -0.10095628302957546, -0.41546383297074246, -0.23422088784508391, 0.019105749598337919, -0.24055836201408268, -0.1017480147602917, -0.23897595015545992, -0.15324974375125397, 0.10195214900827319, -0.028628627860663402, -0.082490518221628242, -0.016552454076146559, -0.25531160172543282, 0.2082734479340419],
                             [-0.32741594409949254, -0.15686445431587778, 0.566462172592054, -0.098428432438088062, -0.13489184535463358, 0.37103067379034588, 0.38530622967616251, -0.042159476465381762, -0.083383545426912786, -0.15176554638762274, -0.064919313658149624, -0.067845885383336135, 0.090991802942051669, -0.055931696781324529, -0.15566925346756491, -0.26032694479391583, 0.13064924090309438, -0.30278822156149565, -0.28403633912734605, -0.085935425214088978, 0.183667143236661, -0.042395682923139923, 0.090324742332935498, 0.11506457909067862, -0.24762705340339994, 0.26378430892275651, 0.097402660277061695, 0.21041657970567895, -0.24806026318079066, -0.04348008445116619, 0.067840626750996114, 0.32665000971905561, -0.26310591123054733, -0.11322423293163304, 0.1865326400677973, 0.046528844915505352, -0.16789228945751766, -0.22147501850882545, 0.18777579486770204, 0.26317428282493527, -0.054091571412358187, 0.01879054006467866, -0.29651831865703077, 0.061888081803879141, 0.16443108303863482, 0.14833230543387244, -0.086630634591195924, 0.17232762311592326, -0.39081462589838706, -0.20917208772330689],
                             [-0.018516370753055695, 0.20359609180072283, 0.025922548311577663, -0.03675625732626233, 0.067116303271073541, -0.10129450890170892, -0.10972664096857825, 0.068701890946276531, 0.029423776994404578, -0.31703644862540925, -0.29633593004189573, 0.19229787381499133, -0.43661604153698186, -0.17507358789757535, -0.24054042889344429, -0.26168550726229373, 0.27008606252368705, -0.087877025041257384, -0.24040890800183379, -0.017339139980776963, -0.25108436026813419, 0.22078109586982933, 0.05512266920454266, 0.003476980705041403, 0.22096681105786253, 0.17277673845589955, 0.0094602666806615707, -0.11325417285057657, -0.11090853613593712, 0.317540852982583, -0.01930198911410657, -0.33528205091388702, 0.33414528532652144, -0.0010021935591164044, 0.17920482409443156, -0.10819747527372992, -0.45191165910154829, 0.2501180944000978, 0.30811016740805153, 0.061013259177025853, 0.085793518656084811, 0.24116822081328088, 0.058021524055662688, -0.090933376385429282, 0.36229635576639541, 0.21901170661146416, -0.26490509376016591, -0.030601574641648394, 0.30839780664939992, -0.067805929762316017],
                             [0.22530709400918239, -0.43797074437498906, 0.20790672218521716, 0.41512182099480244, 0.41897832710410976, 0.038940485325811833, 0.12327556001517893, -0.28563008412052399, -0.036018131959032154, 0.2448368266237764, -0.28638970955676907, 0.25560784747777854, 0.065917218735493985, -0.075349450567414045, 0.15445167324268333, -0.17892474885191995, 0.084760639523258227, 0.047732325831195521, 0.00799583575767044, 0.22802581867854246, -0.14292065157896341, 0.16973178870930819, -0.31064665609236053, 0.11653607424103712, 0.029577277460378967, 0.30977727037341141, 0.15162858916968713, -0.020715368744355006, 0.041464857686388468, 0.12986013326032786, -0.076649797019101212, 0.061791660392533185, 0.0075099282672813766, -0.049311941228157567, -0.24049092392764213, 0.38973157175541751, -0.070393508867986815, 0.25094869024258676, 0.075925855162771921, 0.19074254365284898, -0.14895713882579215, 0.2841413128527962, 0.13338621933410472, -0.12495093508701258, 0.020639606366521183, -0.02419373028942249, 0.26123775273622463, 0.047132245784411386, -0.0090569683713732276, -0.079751208239801988],
                             [0.075327203082634478, 0.12575385300437281, -0.18891230526823111, -0.0047778490673615736, 0.10261968639915101, 0.056227348092276322, -0.21190329169998595, 0.29866256217217446, -0.18932471957035707, -0.14494773221400048, 0.018471589048591357, -0.012961909480813591, 0.077008533935895518, 0.059963617682332146, -0.28054410045722589, -0.26201921857032773, -0.24269900447219855, 0.10281519015230883, 0.019318870243155047, -0.13346174348612311, -0.18207048843879575, -0.036276007466106937, -0.30658909540913287, 0.20739389727382537, -0.46989530019153591, -0.61911472215321783, 0.011855417403762475, -0.14778940063000531, 0.072379816419109205, 0.10337750453920136, 0.21063385248742442, 0.051953708993424157, -0.088324692436897431, 0.02115626147381857, -0.22764933298839291, 0.24306576470666974, -0.038762729216580409, 0.042915961240643868, -0.14879116985593013, 0.30110059158803781, 0.076573409342666432, -0.12737182007584458, 0.15341538859112175, -0.12656770751098609, 0.33813026984309852, -0.11081905792919443, -0.26403868034176176, -0.11614718941544697, -0.38840651712579805, -0.30222368235902519],
                             [0.068769569442215989, -0.26829848583131044, 0.16577381388834078, -0.084339280521227286, 0.27929539665092334, 0.094720196733370204, -0.19356351756307055, 0.17111600975291727, 0.34394803501366156, 0.21912041717110547, -0.17219802674832921, -0.074404789482828929, -0.16861461342697109, -0.028239102470686412, -0.19050233107800224, 0.34546519934111458, -0.36712526880753171, -0.063810670008266152, 0.1575411329526227, -0.026330346304585885, -0.0628733934024929, 0.07050413458408708, -0.13596728954497461, 0.10661511063498134, 0.21044581851089755, -0.22826579567245259, 0.11290562321000955, 0.54962608417408121, -0.52500635663686268, 0.1221162582393673, -0.089472613201604378, 0.048509569956842566, 0.04350154081588363, 0.37340047221599948, 0.01486410884400861, 0.015898978712775482, -0.3037427452924838, -0.28789426475961838, -0.027415868071032627, 0.051730079487607043, 0.19176507037359558, 0.023665344823761997, -0.022687934472285256, -0.12676955889689781, -0.034033512511963168, -0.14620336355180541, 0.15091517357161108, -0.31448246709426764, -0.21922084326442096, -0.029264972456968377],
                             [-0.090473549156205563, -0.06845796886286544, 0.068131909962207901, 0.099099949745155819, -0.040748018939107469, 0.028965977562796359, 0.2301368620709745, 0.022567793284426166, 0.057606802366803607, -0.11892932345206125, -0.016303251860829454, 0.28061983106283184, -0.095067529865317704, -0.49258819936634485, -0.15409470895447699, -0.096617036235059378, -0.31156365868476921, -0.24017084139743772, -0.031824321678442791, 0.14720062780407228, -0.050136669187779218, 0.051184811212568432, 0.36839987409259106, 0.41576394750711781, 0.27060162055041992, 0.095458994094991145, 0.1162937201533903, 0.07437441163422652, 0.38989660622243222, 0.16902670520525342, 0.20792092925536879, 0.039519174229448673, -0.21656901470334991, -0.072170456439059616, -0.28413044893085532, 0.019859499399350389, 0.067647392551650226, -0.32912757207413884, -0.29075229787828583, 0.043937506218993415, 0.011281123159379562, 0.3492062608059463, 0.36848802882552928, 0.3878481805415489, -0.08320472046632002, -0.23469520025853702, -0.14230818769963033, 0.029388508047430692, 0.19999912917369786, 0.019439581710547556],
                             [-0.19085323512552488, -0.21538993697222372, 0.0039394093941639424, -0.016310455068948293, -0.14772977003473425, -0.085813005445039364, -0.099315798687026446, 0.10842532350490203, -0.17638971211146817, -0.40717465803584552, -0.12417151445816792, 0.020281704940514306, -0.082850196424866282, -0.17112775031492697, 0.27375203164690431, 0.16780535741208022, -0.35495533127367179, -0.18808850826101162, -0.064384106146526565, 0.29199391206992414, -0.16112091833094441, -0.020623708977808283, -0.14823495537245612, -0.10036699561296475, -0.40279443620728667, 0.13903517478306845, 0.17640866691406484, -0.015654706420789782, -0.15576396741356247, -0.012103798520076821, 0.28800467394731488, 0.37576272158066493, 0.59782593642506821, 0.017526921221235534, -0.042252704351822046, -0.051888112045534673, -0.00014544669391305942, 0.037736917300021544, 0.20964700260716285, 0.014889506264085306, -0.11319005789353491, -0.056518178751737869, 0.078719327918389786, -0.032109949064260297, 0.020600189186967405, -0.20062869765702113, 0.086150527214526526, 0.011616082848586277, -0.13301924036834925, 0.27681972752311951],
                             [0.21798552311633795, 0.14924016048590863, -0.052253729581930537, -0.32288020018630864, 0.061281229094559228, 0.090331326837771425, -0.033442761267753758, -0.12544309703888895, -0.20346392089800605, -0.10966332006708393, -0.091574033679788558, -0.018060314477997167, -0.064283704366781727, 0.22269246230879874, 0.31701868959811946, 0.042194596066909854, -0.2754447647126142, 0.010656441228203084, 0.038032672165466574, -0.20819296112829355, -0.039839035656919611, 0.21210399442541869, 0.27459048139697523, -0.29950764127940199, -0.14996815186636209, 0.010541194735631809, -0.063839280680835608, -0.38588487385270676, 0.27624225444938932, 0.20280554809279025, -0.21381849211477799, -0.085523840457663536, -0.085550588431782204, 0.1422750631336212, -0.54203085985467503, 0.037404571753131624, -0.58281057641629208, 0.055555528381165023, 0.14166445131338062, -0.0057655763678708906, 0.15344149271703708, -0.022397733553211015, -0.27108559765813511, 0.18317447291529193, -0.16174641936187545, -0.14066047963513581, 0.28611010630252631, 0.082946258440023291, -0.30586313942285864, 0.0024081817806243661],
                             [0.059367994164583562, -0.11104097455269982, 0.088966642487466191, -0.38639124635305588, -0.13528056642950681, -0.066739804761216742, -0.027848046949991795, 0.14825731320214583, -0.20121523848203957, -0.046300347383483376, 0.0029833492331383868, -0.0823590038221899, -0.33734234731071761, 0.041896835430155752, 0.30837045472938435, 0.021035050184557019, 0.15774010538490024, 0.26809327701609909, -0.30195037632074639, -0.067041185868241912, -0.20197686575409809, -0.14040051104335519, -0.2125756713711616, 0.44844318040938724, -0.014195527867791116, -0.23341871196533276, -0.18322218166440107, 0.071116959333693303, -0.0034127888533611456, 0.14711576814299751, -0.059622360276557998, -0.098083877355510662, -0.45799526756601172, -0.24986676348780024, -0.080283914717078395, -0.16985590228641759, 0.027626093546043881, -0.11554045193356458, 0.37072733733438179, -0.15771689524984903, -0.11400767558952288, 0.085587843869373584, 0.34364167459037781, -0.12729595029919466, -0.037535517892650617, -0.072284134054277582, -0.071154628326168104, 0.041272288590525522, -0.093953281725478885, 0.4420127222285658],
                             [0.18910376033331175, -0.17258562518888662, 0.1080782715594681, -0.013175058921450851, -0.16056387693492757, -0.41327994494024378, 0.13172355211666356, -0.1499908303732827, 0.34751335485081564, 0.033089696605998038, -0.087913166924712211, 0.035669326628661811, -0.13728100784330463, -0.0057763483979208999, 0.41355173350265606, -0.43381715224765849, -0.043182741571439899, -0.34435779547872375, 0.17663557949342915, -0.21259801342534285, 0.18227458095021229, 0.042574659592429585, 0.19927001907727027, 0.070001414285250391, 0.10414758687246661, -0.027034877143577524, 0.2836642472427584, -0.14359828863638785, -0.11664235839178871, 0.14939849943355871, -0.18748888992378968, 0.22696782813695004, 0.018798620161730548, -0.16195281435474149, 0.34185511968446397, -0.078997575848727491, -0.20814042545415598, -0.065227246089173435, -0.242340384931921, 0.28621660979497104, -0.055783724557205837, -0.15060489825654208, 0.3773173624300184, -0.290596105644291, -0.011645944265529506, 0.21460967075441389, -0.18173354801155955, -0.080293251080553033, -0.23300924661434846, 0.050261483214545273],
                             [0.25550679147799088, -0.18875231014322918, 0.25716627805848502, 0.19620365158734132, -0.50829798521875125, -0.31024311269343569, 0.12610590928894436, 0.45247799530179106, -0.1237478117165407, 0.071430754125459378, -0.25190277064500077, 0.31036841699045981, -0.24184233701316346, 0.17003385109622421, -0.20994019187408147, 0.037180586332577439, 0.17008299885089262, -0.099978469728319738, 0.14688104703944757, -0.38875327528179737, 0.0088123959283348645, -0.11246755302323122, 0.014176971131209503, 0.027535391196030289, -0.10926996733867941, -0.062765395007812225, 0.078565331528880927, 0.027982648491778277, -0.048248144721246632, 0.094869328442496598, -0.087468148408119312, -0.17029237287326629, -0.066265029583643803, 0.258946079650623, 0.21327244325250233, 0.13030650629582533, 0.061522747918983017, 0.29807189554734759, -0.0034079533931149937, -0.10366185469519439, -0.18247428390019971, 0.060780642472836217, 0.047148889412104121, 0.053447131201294872, -0.037369557283272029, -0.58252649911189192, 0.1205346515191843, 0.27823736787679249, -0.11512830844617801, -0.14434303493794831],
                             [-0.51486294039816349, 0.2083505104520115, 0.37901279932721638, -0.25771207095595738, -0.17257825348096525, -0.10758519154508123, 0.027513970494450542, 0.19974115745151533, 0.1684909969702218, 0.12400431413807983, -0.24649729576711438, 0.37708958696207145, 0.4534391653531894, -0.20848896113684109, -0.023763675281154362, -0.077674793277193066, 0.09205029350427435, -0.076248544387910469, 0.16342299975106037, -0.11980263255836707, -0.016059063186561803, 0.013950053990917845, 0.097632169562259702, -0.019280138552246907, 0.1527520574809004, -0.35994782221137678, -0.12280735178782523, -0.26344213050746101, -0.27555232461587958, -0.088038226287427718, -0.024634733007433497, -0.14560423800452046, 0.35829526737457629, -0.25005594384946828, -0.31523659376676455, 0.13645626330557661, -0.1603577691223072, -0.0083199614033683533, 0.2284614853857414, 0.23759321009463916, -0.22943976673127531, 0.0098058544905652613, 0.014596381135113235, 0.12165136215793686, -0.34107095596144044, -0.017531611137149829, 0.14444015037355323, 0.023662490195261315, 0.038734651602096451, -0.11084582839701493],
                             [0.1101684306334907, -0.35380243847720627, 0.13161852065145088, 0.015428396028777741, 0.2137371549453736, -0.14091663624281484, 0.19955516439498833, 0.33981305560788228, 0.46660532202582017, -0.18000234779519805, 0.29798774371558862, -0.2343200741811472, -0.2142124556852113, 0.088831226047272199, 0.0086979861056040476, 0.29709517237879352, -0.08861433478731337, -0.11793439312801235, -0.067634389821856447, 0.093645655443330228, 0.27446536893746937, -0.12656255650719439, -0.022891215249956666, -0.33736892652967515, -0.19420847176093212, -0.040314607015806976, -0.1936420966548231, -0.33236194471800629, -0.23384984567949163, 0.14697379452622167, -0.11959728780916146, -0.059604920891800341, -0.24428995577307724, -0.12623387260316471, -0.07106830270095299, 0.32772126324489359, 0.083882082481614093, -0.084758287067028912, 0.22913833973240241, 0.054790013278328359, -0.30170978826330813, -0.16508276592021331, 0.072487781233305584, 0.10901160020201921, 0.23291514563798099, 0.064290116031172295, -0.16025359353362956, 0.24217753609597173, 0.095808300022052692, -0.38999455393539922],
                             [0.023526091292039038, 0.027136834544196953, 0.12498185698136677, -0.060999854966437422, 0.13350711734384205, 0.19320628404112891, 0.26904917557327779, 0.38828596744469235, 0.0069259512685612909, 0.066365568012293694, -0.19154699203897702, -0.073717507121411993, 0.35041513213684211, -0.14821506972572529, 0.076275543805659526, 0.028180985392700815, -0.20789273467711572, -0.013601050879651758, -0.14843602249885721, 0.024684673575519966, -0.18031876796240187, 0.12924361775891, 0.25129180973450449, 0.17701449044746623, 0.10187184922056018, -0.14588508225628544, -0.060119844829753202, -0.36045198364823833, -0.15045294817236421, 0.13286534346328735, -0.0029881108508443876, -0.07754481753839236, 0.11652594830281786, -0.031299139691965051, -0.0085986297250299354, -0.046174321370193491, 0.34423986663480699, 0.45447533457961176, -0.35131334579233375, -0.42803508551830677, 0.19025140723036565, 0.26878496982679867, -0.15463112040377303, 0.0073219935803118426, 0.23653959481887593, 0.26165737983462195, -0.19697182822831621, 0.24942064590291327, -0.23216116171245763, 0.52130409723386506],
                             [-0.011199975484484344, -0.11085251645443657, 0.17908757544301926, -0.17984313334029281, 0.12952988776224572, 0.1065655390564367, -0.54474977179382744, -0.11717422059563622, -0.37418651025832556, -0.19157071939903325, 0.20122831035428501, 0.29250809527038735, -0.3409400229928185, -0.21286024956957478, 0.050328181111505173, -0.0045645892795102942, 0.063887861220045472, -0.1699309257111272, 0.14710251344241912, -0.14517785216406182, 0.025092659837976483, -0.026383500153607114, 0.16030210731754702, 0.089546269236535275, -0.12659993060236094, 0.16876553518548804, 0.12892881446130722, -0.40802087929112857, -0.41151554751191544, 0.02386636953218052, -0.37621947252402282, 0.0076211115404779192, -0.15982833798379384, 0.17198327405895361, 0.12635854171010744, 0.49230891691274759, 0.15296325988524681, 0.11230157951897704, -0.31619373270320994, 0.12422514136837173, 0.20684165722659364, 0.00058421296714878182, -0.19203423871266065, 0.185101114927196, -0.33988270184042713, 0.38016241821210611, -0.063399750090443102, -0.25401764448457781, -0.00084563247141730864, 0.06600970121657615],
                             [0.10343849683217228, -0.0074788662245928129, -0.21327700471903296, -0.15841480137089886, 0.29771000985580276, 0.041148396877991357, -0.1054952453718567, 0.076762779547385487, -0.072357375691376125, -0.43659018362325425, -0.01405294883177639, 0.14161822052705242, 0.3422453927946229, 0.42279523843477701, -0.026766312983061803, 0.068218247325189676, 0.13961853879062988, -0.52266328996277378, -0.081467206184970622, 0.25549448635523964, 0.18165557317269201, -0.037193634503521207, -0.35553219100248928, 0.28026677325751481, 0.19350832909630197, -0.031354717235936948, -0.19963606747828652, 0.014306286934231542, -0.23182716973954254, 0.47612954122295609, -0.0057010195661307593, 0.039065462616746913, -0.034608763342692007, 0.05577931009789526, 0.19900755333225842, -0.21744351483997651, -0.089511323882007193, 0.16456280166825896, 0.010895975541817459, 0.1863041605194912, -0.082984047752958132, -0.20135867665309493, 0.20819942283694765, 0.18677365721650535, -0.3918847739188096, 0.016693445434432647, 0.067576165946531833, 0.27146435600770902, -0.055842626438550431, -0.11482776124749228],
                             [-0.27190075514517392, 0.15587205770710533, 0.07684587038511595, -0.023693092757620063, 0.22120242705000201, -0.14012934228620938, -0.22719957850860939, 0.18237659717183263, -0.37312128100972131, -0.17238543645073334, 0.1742138935061304, -0.28388761574731308, -0.12398699545737918, -0.34749222533572938, 0.063953572513796964, -0.092829486363561448, 0.19529701679223507, 0.12579085147110805, -0.017373923900203703, -0.5750442562847734, 0.43392704178885888, 0.32976763082532823, -0.24710800488912968, -0.18071494957887571, 0.31539637216239774, 0.12362369496708037, 0.28495046688892478, -0.0036125748931035984, 0.091172126342682569, 0.1367196483379616, 0.30713309507596231, 0.037235497784746545, 0.25502800853218111, -0.042617447254872085, -0.17258371406087625, -0.091236368491477815, -0.065546946391670052, -0.17524053996806244, -0.25887296596848147, -0.27102702924078292, -0.3841315472351936, -0.079537751719710836, 0.11163312718357271, -0.21215528403044784, -0.042689760047159825, -0.079257892606308916, -0.12442578487406833, 0.06051929064803005, -0.089017227615212371, -0.19767596085642264],
                             [0.0098441180266176168, -0.29412851035300608, 0.39177528412771362, 0.10719445504483308, -0.18962193248445752, -0.021256007515540475, -0.15179945183533727, 0.22540451854914897, -0.2779569812049616, 0.13954366883112354, 0.14794501644597713, 0.0044578390895296076, 0.12520401678744386, 0.077799508327484099, 0.32173854902739019, 0.21554613093365657, 0.029574315393842192, 0.15641694114932636, -0.40383184951641776, 0.30980899100102777, -0.22812241887724133, 0.30315996484137797, -0.026103212427830334, -0.14375090309735922, 0.068519222378456091, -0.2681238603374495, 0.061633722284759343, -0.046862350246804976, 0.063805404547390768, 0.25272903556643123, 0.071309086788260354, -0.053856145752190568, 0.094269384587614191, -0.19385908536441696, 0.086331466211943542, -0.083044570401661327, -0.18795143376320012, -0.16866601591766994, -0.081450657081768046, 0.0081037340622482704, 0.18672431248674778, -0.14678789246727425, 0.010695198235005719, -0.0049894567146345232, -0.14384435352660091, 0.036635027673510803, -0.33905143166095142, -0.13874152148170907, 0.1967166681963072, -0.36188261227198004],
                             [0.089553212953197722, -0.22251347519297859, 0.01663015795267065, -0.035637450347205848, 0.34458119659775144, 0.051952450608109567, 0.032528604495357973, 0.14653853050753937, 0.087957767040673138, 0.15438154858071043, 0.44217478821855821, 0.54874790832012754, 0.11615732300435463, 0.0022918717724705363, 0.0070527034117235515, 0.018878223870672898, 0.20964934099061588, 0.37892893426122787, -0.17978837094934644, -0.065107172241591654, -0.037003160078480646, -0.026542089912212106, 0.13858904188149132, -0.1009984418698789, 0.070977706411395683, -0.27453308721875985, 0.098026388184890706, 0.03635109024336125, 0.081394789020137415, -0.15580900440911635, 0.56115798677313855, 0.022341531616804827, 0.037766055516362973, -0.008411519548232398, 0.15495356036937419, -0.033976936349342728, -0.13998759280956827, -0.30321642529324139, -0.20833101409776988, 0.24962037001604442, 0.14318449200047595, 0.22013742477946746, -0.12079503600394779, -0.11373022257687508, -0.14662051765738843, -0.019680674221835451, -0.12211811661559532, 0.39968627516498167, -0.054997965662307795, 0.20557069524927968],
                             [0.23356037718674594, 0.15432554073198643, 0.18519293983246918, -0.39645270578614988, 0.010929063213160489, 0.13257302305413357, -0.16306498942915718, 0.0034616055086699182, -0.27358523997116663, 0.41396859885716869, 0.14634821847226584, 0.34645023008424425, -0.020936691766952745, -0.28540621001104838, -0.097539429448669432, -0.017448117822151925, -0.50708858841904303, 0.065583031674257344, 0.22095439846488546, 0.28787042717651562, 0.32817134879954341, -0.22287860272112592, -0.035912628790351592, -0.26641681552823876, 0.30094096602065201, 0.044162756454442717, -0.1522642707564717, 0.10137757396865166, -0.0020531246191217885, 0.099355389984702919, 0.15219768218508842, 0.086407883964096766, -0.12442787454637474, 0.16544946114551717, 0.025584077291242416, -0.08988530857011226, -0.048241568562460889, 0.26856939874365732, 0.14339217020002509, 0.15267136249192653, -0.019615529651792217, -0.31267503096699462, -0.091901759884100126, -0.21292660690009618, 0.52767580157161509, 0.012210296455271609, 0.054023047549631102, 0.19702674719231217, 0.11545298924563047, -0.1364846266940076],
                             [0.076475780348181269, -0.12196011676494065, 0.17047600174604871, 0.1256477556200303, 0.173913803132414, 0.19962335781404356, 0.0050995372374115274, -0.05617145756227572, -0.22094265982675504, -0.024143260121412928, -0.041630420775464708, -0.11929025433759149, 0.008085340743724384, -0.15364749593296503, 0.12575445602961235, -0.081642106384564289, 0.22179425136140726, 0.23832023666820634, 0.41199930065577101, 0.069124402090415593, 0.26789400590223877, -0.32951211117220314, -0.026752093370577813, -0.31697372155720699, -0.10958968875914321, -0.089275516546826583, -0.04079942946756239, 0.097507927721584495, -0.23361458565634077, 0.33445597843376923, -0.14534473573663045, -0.2945966992028633, 0.15169883943410731, -0.16505886871619033, 0.014981428601832984, -0.48061857233007993, 0.21126904336074218, -0.22471430532698636, -0.25323416774056406, 0.25300037730557212, 0.062361257139599106, 0.22396728628720447, 0.076092061657964921, 0.39036005473922947, 0.290633286409823, 0.022284875942153407, 0.28580315686620961, -0.24190932734785914, -0.14860004549569511, 0.12167188628446057],
                             [0.16814262484091383, -0.13156973080113796, -0.15635168003504865, -0.12984311107001256, -0.13191263372136608, -0.22785391134336874, 0.33854110742912119, 0.31540323258339847, 0.11690873106635982, -0.21871067037853104, -0.11657399115992001, 0.037855991284347509, -0.38697923368860199, 0.095046921548932725, 0.047151711348967756, -0.096076590338176129, -0.029696279650417677, 0.34717432667247788, -0.0017017742142110773, 0.17727078563198934, 0.25057798084405997, -0.1102783293435957, -0.023134052876119755, 0.17621587227040963, 0.1418568757764602, -0.10094967660161994, 0.25269219402515536, 0.0056570456440727945, 0.15592007583450196, -0.099904705374614322, 0.09078250105280708, 0.15893497527155018, 0.14660609774363004, -0.055605121846023772, -0.15019782585554459, 0.049558679421886673, 0.14076700179038876, 0.36670888778659066, -0.22454978503661094, -0.11992273025470732, -0.07762437260036649, -0.0027983583255188583, -0.18915282385750282, 0.005163934933268487, -0.2590596836347458, 0.40921284906185046, 0.60167178778107888, -0.13948192727922826, 0.047881328649330895, -0.21427433375189323],
                             [-0.03812592953712763, -0.087320956547254455, 0.037339742013360919, 0.092162864967934743, 0.075360987946463953, -0.046910663980769429, -0.45657802185978114, 0.16355396608291875, 0.066147747892093781, 0.39546929488346766, -0.05829026130250041, -0.1158886336511399, -0.044161691106142938, -0.017219718970645642, -0.052104528929928312, -0.27642330878060267, -0.066336778686986869, -0.06632578497742643, -0.29881503535298454, -0.0019430556446444862, 0.25707164815349276, 0.25145679015585393, -0.071769989558948435, -0.19111905047418848, -0.32186281596162325, -0.050362516229817203, 0.25261847853389324, -0.19603098403385857, -0.020501358812675449, 0.078713111090183363, -0.096549081258315961, -0.046632630049395891, -0.14775951458830208, -0.13519190188845764, 0.057754692558899645, -0.078945078056087331, 0.18518301375986856, -0.3381427170815185, 0.17568416577444185, -0.064551676455333676, 0.29114243230999942, 0.12092738072978439, 0.098103323742062334, -0.051484958421765058, -0.0062255229091657382, 0.20440784309029678, 0.63599777666174839, 0.4151411427996517, 0.16659506145102848, 0.1349502987778777],
                             [0.078728511316939129, -0.20404440475141147, -0.72037929338963669, -0.070746125763824178, -0.21858908064346352, 0.30980652542955867, 0.00058083189165186559, 0.17096424133976931, -0.056922922229334857, 0.30615316328551379, 0.17538268554863989, -0.037616772200770435, -0.033758671145208259, 0.0059903124810838102, 0.29698674530399222, -0.068143288673674404, 0.11430480042384432, -0.3373550143652444, 0.038466738156625283, 0.098315883715053329, 0.26782897006368733, 0.13267385765302822, 0.21293874378542024, 0.13863092388420348, 0.046065765084811257, -0.11958334957171143, -0.30685239926868002, -0.070598343387710691, 0.21415339451600371, -0.045692439048586671, 0.19177732246301424, 0.033380609598794471, 0.15817339772400585, 0.16005447898895847, 0.0488900358438994, 0.32835787726036586, -0.051371881615771865, -0.12002843158552343, 0.15114072137281565, 0.04604436605803288, -0.2999773600125934, 0.038348236620967251, -0.066543702145829803, 0.10454800919156688, 0.16843403018058803, 0.02510173868078238, 0.11286781112167552, -0.28026349505582981, -0.10162279401823084, -0.076111094219639699],
                             [-0.06518716410001904, 0.062254649445861177, -0.027021546421299392, 0.052492730231692292, -0.26360423732932448, 0.11125302406990673, 0.28578179661209413, 0.3331145617893434, 0.10167577315379933, -0.043597056306866236, 0.10712379250063185, 0.25675917287400718, 0.26358207611591361, -0.36985642715630884, -0.1444863392605526, 0.27539857758734626, 0.060915670923393311, 0.032271926412407226, 0.014591404776920815, -0.14067091852835195, 0.21885866787481623, 0.33414073029429625, -0.4667959164700764, -0.07682041297833915, -0.2726428155733352, 0.10095381804346387, -0.37747130084739317, -0.146530076148013, 0.48501951399412141, -0.11652814893006176, -0.20312375744211894, -0.17984548245153298, -0.15831142649715757, 0.049088735001341255, 0.076489791379373423, 0.036738533565026432, -0.066391151815248489, -0.12088372017596306, -0.25878423370007053, 0.31414153352533203, 0.20154584489462143, -0.087509104885392347, 0.25876056343141485, -0.38319331921673155, -0.10666087807527175, -0.0083058405579850836, 0.16343407523968831, -0.25069648455234322, -0.16449452780236526, 0.33610998766565325],
                             [-0.22742018536879888, -0.13387459237870444, 0.043254673074421032, 0.091364184328887127, 0.017517832114583659, -0.1535593901904424, -0.016174186812146815, 0.10840922985940053, -0.30994562316846402, -0.18904421788403339, -0.043458513704160859, -0.10282704177276937, -0.20619009135490005, 0.33842148331128519, 0.019806917480172138, 0.059772558304654576, -0.074070116508083067, -0.1774007155330426, 0.48002248394410635, -0.018814554514857751, 0.17691477019302418, -0.028190326246400346, 0.092121394628418674, 0.070896881275056223, 0.4091881949067433, -0.04507231147403612, -0.13669046589988681, -0.099679636362826049, 0.35762399458511401, 0.035808997640420157, -0.12299176020719571, -0.16770750779556606, -0.012241454844685362, -0.28382239876767346, 0.14588233806781004, 0.22409190240343524, 0.15310065571205903, -0.22290122792626937, 0.21108659686329204, 0.018186503182633613, 0.45167538190490042, 0.12836012637655506, -0.11044906529722839, -0.314267949437046, -0.01099315647974923, -0.043843040910650014, -0.00053073244238627248, -0.013776568163082627, -0.20587191077890049, 0.079725824044035831],
                             [-0.19622874396609161, 0.3928318331757859, -0.23637294995886074, 0.45893757325253765, 0.02098743733916935, -0.16811825259576585, -0.072438333015329967, 0.55130930426508473, 0.15889592278608933, 0.14821218710092024, -0.022294173589847921, -0.011831162185539462, 0.070546152518230168, -0.27730993974429313, 0.082802288469961835, 0.32472127868659023, 0.23117888530470074, 0.1233205746687951, -0.12382283659488746, 0.031755508184281106, -0.26350363617340533, -0.038046267646054496, 0.25739132737731074, 0.19259008427114899, 0.047112791212021915, 0.2868605205838069, 0.16848922710885345, 0.12402832466104877, -0.14004108455189784, 0.18136179604058675, -0.34889687627994609, 0.40677648279056017, -0.1000576319691228, -0.25317827131210996, -0.073813077573327404, 0.16579913657164747, -0.15055326770920013, 0.11914185673203986, -0.066159888414109899, 0.16655750737351446, 0.13058871056726459, -0.30356777286189823, 0.16151564659363218, 0.21792587324298482, 0.36603777168097712, -0.11352154978205987, 0.15144728987497283, 0.16433889793567408, -0.17005582364872393, 0.11165156522648974],
                             [0.097500151392160631, 0.14032056120162961, 0.23252840660071319, 0.2618317368762883, 0.12662588266527625, -0.26526096753933698, -0.084296817487991144, 0.11808540265894926, 0.14224896066935816, 0.00069091239894827645, -0.054830210356390956, -0.047997698312524172, 0.060383841288946673, 0.11865674835356896, 0.15060698783764462, 0.12595907775078868, 0.11143431126760195, -0.21875913124584684, -0.25955281884238901, -0.018963037020240787, 0.27112682131874938, -0.18882420595905777, 0.28587687366594683, 0.12784259445130339, -0.079826386044572567, 0.013051032145779549, -0.11484152103330385, -0.14238735493696547, -0.068889842668234919, -0.12842251657638251, 0.71503291784112022, -0.26034765876228322, -0.16290289264163804, -0.12730884658178163, -0.071293637255191264, 0.12835089092673468, -0.23495167408536899, 0.13007989499603789, -0.014173807856610959, -0.13297713880811471, 0.20516264300614429, -0.19193051240127976, 0.062478467526726089, -0.086858801848921113, 0.021879618278564425, -0.050845787799903695, 0.22314229309886754, -0.41451790530512023, 0.23050497154551908, 0.13915308101992885],
                             [-0.37827611434477054, 0.1546822506356616, 0.093494650505586821, 0.11314426018192811, -0.041402626999804702, 0.31312302787215118, 0.25796848479189988, -0.13404061089614644, 0.067513560725194433, 0.12298521853060522, 0.066050666775969963, 0.42885669421952127, -0.35035555892536113, 0.12758368993872291, -0.10085663478817772, -0.009016978714669277, -0.060499234348462952, -0.17462896614366569, -0.0059295254289555548, 0.099176262800930559, -0.1183262894647395, -0.015224149168946464, -0.13364938222574319, 0.075526732673366417, -0.13326165944611965, -0.061017630198722105, 0.11987608452644788, -0.40545907626546146, -0.069617848729601209, 0.44040071966157768, -0.17025566393490343, 0.086305830135957315, -0.10196138814611011, -0.1336892542712893, -0.0027141329343268114, -0.1717017153473604, -0.074248791444820716, -0.11511979594574685, -0.21765116118773048, -0.18573440727824828, -0.30429229892154303, -0.15011048241936004, -0.34214137210927242, -0.48956774418916077, -0.073354168868325242, -0.071958777645986766, 0.057822545989335693, -0.11228928771931999, -0.0018302171365925241, 0.047990952618128947],
                             [0.24458670755342052, -0.040539450577034626, 0.099873029512634742, -0.21927141320073351, 0.0020854072382903571, 0.1767784701130449, -0.023779758158805814, 0.122875213569291, 0.23403970568692523, -0.011282759627537095, 0.14693540888559192, -0.37434092987757928, -0.19741337245265395, -0.088377650615716702, -0.10262870975337812, -0.39142213873949733, 0.034828314726050885, 0.1107159242942832, 0.051544874176268157, 0.082655962769431615, -0.30531358149770188, 0.18697853594717237, -0.3729056950792039, -0.093926181754079005, 0.091092155525105453, -0.083452323507942322, -0.26755393283092843, 0.05347944434525613, -0.052264523470218371, 0.34662209688003326, 0.11859469913144485, 0.08964303022642503, 0.019250773414164757, -0.35160243055177687, 0.16623329205490073, 0.47734732305431804, -0.049877286521655122, 0.082836907293884127, -0.26167472421963062, -0.044923998590607271, 0.21528957766956755, -0.46125959277675577, -0.015516889484622423, 0.24944788835224033, -0.14302387680000564, -0.42741257623658152, 0.1125751070016069, 0.10191399259855356, -0.074441062415844028, 0.1194669102350135],
                             [-0.073524476955837539, -0.044117356962737206, 0.29183035594039364, 0.1587368338379444, 0.19670085634851234, -0.0051528423940173859, 0.080265124966705487, 0.23575047293864126, -0.081304471130848655, 0.09259555055458836, 0.14000440391615876, -0.067401509762828105, -0.19257519032011938, 0.09924005023853287, -0.21619686530341509, -0.10550224892244539, -0.071598158921080568, -0.29024121638785855, -0.27386042422556717, -0.079383749789631891, 0.37279128350196239, 0.13800661567660477, 0.22919795022117623, 0.23886816056423232, 0.042853382632458137, -0.37381263822128874, -0.0027336254089328146, 0.023554370295053098, 0.023296030655030227, -0.13818196118149959, -0.40946765233312005, 0.3354392684843932, 0.23219207441010181, 0.022826405817601876, -0.29780970482520275, -0.29572003229752913, 0.11008069545024712, 0.24123542743577769, 0.18376392425126217, 0.29372464378773283, 0.14095935802563772, -0.11999053109256702, -0.087434856577326928, 0.092428912233006394, -0.045329155789898448, -0.29013354985905088, -0.25128956857701085, 0.0079059982633802872, 0.027440091411203543, 0.47888415558119679],
                             [-0.19955902403600342, -0.21682305782756084, -0.074478592855749287, -0.023561666015696384, -0.013027334287924512, 0.029022728503510127, -0.15096489880603328, -0.1998968449100581, 0.12634349700092939, -0.37993495857745085, -0.52567232798913266, 0.17689273037461586, 0.016106631412176331, -0.097121768741510878, 0.1959805995222724, -0.0015077115502223253, -0.041064499775519223, 0.31279674573103411, -0.27426894205644392, 0.014603553652238664, 0.39991494571612751, 0.18740966304587209, 0.058920081389449486, -0.31118898153736985, -0.072937187060573769, -0.29669399006901354, -0.016417452391135783, 0.25967066487929868, -0.014568971855556667, 0.15854054986008934, -0.096812198575943809, 0.01172099739645498, -0.41869777365953509, -0.13625667120731855, 0.042815916784628372, 0.19172637272610585, 0.021280676199270578, 0.11608733099276783, -0.27400741267555112, 0.20311522686439537, 0.0036950943586483709, 0.043495193497928804, -0.12327586934530296, -0.20978505890188298, 0.091340858929186766, -0.29544879320311035, -0.30540249250644175, 0.059617739083642554, 0.2015695377397056, 0.11236074130490611],
                             [0.32850085935563855, -0.22148180119963787, 0.0084804358493649739, -0.14387289215024673, 0.23695701158880336, -0.061552343037943644, -0.23308786633124948, 0.23968974074322083, -0.17096400713079857, -0.32063027020381563, -0.19074775872547955, 4.5792046821246761e-05, 0.23749367759383946, 0.032881717024486945, -0.49975794706630078, -0.078539174856423491, 0.43288051811623152, 0.098527145086305834, -0.052246326858025958, 0.3640347642698295, -0.25080449857461012, 0.099557618448366136, 0.50990099401401634, -0.14663768971877847, 0.058465791820752955, 0.060310346099696481, -0.028102171350065198, -0.20629824839231381, -0.11606288309888288, -0.20831026426410876, -0.1536267212903627, 0.17089046213342021, -0.069486960041444112, -0.14787172788152636, -0.030835051054932089, -0.084957773187987598, -0.15707377013071921, -0.23977663400703275, -0.25496712140354344, -0.072980068684450117, -0.30804330452314965, -0.17997547879927034, 0.12568510793843629, -0.40865760841305915, 0.14808425149828905, -0.14495676293067219, 0.05976566129227668, -0.16405991286530802, -0.023104197062639061, -0.085327598190848244],
                             [-0.045185019181157846, -0.26584877939566959, -0.15603741342430932, 0.25234788586258206, 0.19245185919631194, -0.011571272163313724, 0.082385273176778989, -0.042060291969502561, -0.0077708940596079579, 0.031795340562304972, -0.15549673163413902, 0.25862172226377717, -0.03280296152453642, -0.20901098779119762, 0.099965340846992989, -0.29476554162993523, 0.21559671326347341, -0.075623594169644134, -0.35177540666354951, -0.20815028934795207, -0.23252493119069281, -0.09293254204005591, 0.11196290310073839, -0.3905082732320414, -0.051487109374926031, 0.14014024474898318, -0.23906259170551514, 0.39932367118022294, -0.15098378608605351, 0.050725948301709227, -0.025491057449833612, -0.14902051996542648, -0.055380238039529406, 0.12648188584787715, -0.20931693996541489, -0.15479866323412314, 0.44681976878174456, -0.082407768157729142, 0.17388811936385246, -0.072776532950010075, 0.13333118839691108, -0.44276833556212208, 0.1329458379466267, -0.25167420893547776, 0.021690305937980603, 0.15772265847389089, 0.13183719514893658, 0.075040975557546283, -0.27034306617789622, -0.20893326201020135],
                             [0.19656462189156693, -0.20869570763635636, -0.069261631195957032, -0.11453327555496812, -0.18504461033991904, -0.33268351766219706, -0.31027722220666559, -0.35860111288572216, 0.22156342609621341, 0.12010105120798027, -0.046249404162997235, -0.098537417068750938, 0.18213415837115016, -0.21265706084709368, -0.33354404535431159, 0.041913771318831373, 0.06791390281654848, -0.093729845761376787, -0.29542655900133241, -0.071984699008372413, 0.16239017492426794, -0.45537091155604525, -0.072273017918943722, 0.48671092581732239, -0.059506757869415512, 0.17264707178986319, -0.0090794289810668845, 0.015195928190968114, 0.15577547182504334, 0.45255898744256245, -0.088115329067434855, 0.10501060503385021, 0.20962478405551477, -0.15725876806922129, -0.043415854074247376, -0.11559758973516571, 0.029005009817702376, -0.088277377626779396, 0.099459203638028792, -0.016060987075566587, 0.056214058049809654, -0.07653696204699989, -0.49966736250563221, -0.047128837767042062, 0.0050858198239513153, 0.0059151578253636358, 0.07973178639389801, -0.057358957188848522, -0.23792205003814493, -0.059663880950709791],
                             [0.095780708001521039, 0.17013967220098933, 0.20345975356954171, -0.40499967182889135, 0.15323972227472979, 0.28651774512997213, -0.012454779911642469, -0.069215774291630713, 0.058881280951339696, 0.10422269892214732, -0.1713904178096734, 0.10755148041564748, -0.11219413988862702, 0.032432827899185439, 0.097186170332024369, 0.27826738215864139, 0.24618587679260884, -0.49052157141502467, -0.34632463125193247, -0.17042328345258376, -0.080563968579944426, -0.36368223512947806, 0.12651876405545595, -0.42435176977931832, 0.10807758110127497, -0.20840012803721908, 0.27261146890009852, 0.034434548084959042, 0.38873075907597998, -0.21489848768856901, -0.039139195647195681, -0.026831002794478746, 0.15076578150353226, -0.45398797424020992, 0.22196795387854118, 0.068461324471560878, 0.16694443824488633, 0.199796078576572, -0.14005027108507517, 0.042526853661375125, -0.0066173944477729693, 0.21481001037245359, 0.088852428708598427, 0.11095764138174623, -0.10453939532517185, -0.052821468735486543, 0.096041481283857616, -0.10348795165140946, -0.14868867551370724, -0.22987193024818453],
                             [0.11092868323758633, 0.46767829755826401, 0.053250135853385797, -0.1568914036477064, 0.28954051623939137, -0.043581057985129297, 0.21972330285466124, 0.089172714199743625, 0.043815625463357696, -0.36376370679370068, 0.14935663665752852, -0.21053499159046118, 0.1649729463888904, -0.32437307945764088, 0.34289986335476264, -0.018795576299241123, -0.0066722799563905047, 0.02642391224613061, -0.040623175215213907, 0.013808174703698536, -0.16513477902305368, 0.31328913911360473, 0.26686054846790253, 0.29252361443749969, -0.18339676001531319, 0.049012368315572333, -0.060720204840515907, 0.091270703086430816, 0.0045908223992087022, 0.18304810436013369, -0.17488882501818628, -0.21744499538183404, 0.19141217001289559, 0.13521030567332953, 0.31339528429203312, -0.041310642795897412, 0.35110711379776516, 0.066687364503874275, 0.096877846460271644, 0.20044315885169181, -0.074628080120550347, 0.15113025972657299, -0.13340020749255047, -0.30517018130863172, 0.014102850729103437, -0.28821487920457312, 0.14628262944100562, 0.026438538323322651, 0.22719515026077269, -0.19115280578820049],
                             [-0.27883993734957618, -0.35718238427206284, 0.027599333528787164, -0.18315464289932554, 0.16716827466469339, 0.072607706813259801, 0.023698572292909902, -0.34033061419634003, -0.17275499432197994, -0.035483189166513697, -0.07224271807409384, 0.12649106906051544, 0.016644158204080793, -0.019447930569773241, -0.12627932261711389, 0.24238207331003223, -0.12468980026186718, 0.26003006410948354, -0.015267734952314798, -0.25094456861965758, -0.23081931069636724, 0.17503753308752731, 0.049358190835759354, 0.25330769488170429, -0.0050780728918664256, -0.24067097004911991, 0.094591991856668778, 0.15896572348607871, 0.21279346103839869, -0.18626137803404624, -0.054553277301306255, -0.35222902524470689, 0.1697526177077085, -0.077624736588671681, 0.30448690308494492, -0.028739933631987267, -0.21899809330537798, 0.0028915408802964067, -0.052686383996159394, -0.16819684480609026, -0.25141947530799635, -0.55149353022792835, -0.025912211841591887, 0.44534227312777425, 0.40173297126360874, 0.039792502877149125, 0.20610180924230445, 0.10882271611567121, 0.09685403677060743, 0.025150203933914841],
                             [0.17612234575375071, 0.16620153996851153, 0.33329571795174312, 0.15810740282074706, -0.28036673936870127, 0.43424642655504919, -0.39722494110564122, -0.19270195067488985, 0.34718927538497729, -0.13951218666505349, -0.0016501364948773392, 0.096299070221646285, -0.093887234530718539, 0.31931532930316758, 0.048583761488284777, -0.17473539410195732, 0.13196634229159845, 0.24000811092605714, -0.10789646183302107, 0.073293734652029707, 0.16302844105685615, -0.015053422893156716, 0.22168306903210933, 0.34518252896208812, 0.17708576296049344, 0.13014578154739601, -0.17240879663413539, -0.017420594068002601, 0.21596162555882867, -0.055708155181815704, 0.053826217748686601, -0.0043900592564626705, 0.29044795315694283, 0.35144329532043328, -0.093673662154232895, 0.17903387331197482, 0.12679886300628104, 0.0022593329749230149, -0.029242288933467957, 0.0057963219712579023, 0.00088219629186293738, -0.027644262527103416, 0.43521510160636323, 0.032316691543414378, 0.016149080268512993, -0.13302998374188085, 0.058603127881954598, 0.35297728642407022, -0.49174234661925431, -0.072008325998248301],
                             [-0.28452976365117061, 0.043944632110820975, 0.26396956173835268, 0.096881897076623938, -0.012595282337388339, -0.29706703531783168, -0.34512731438873601, -0.0059960194317196097, -0.0012412104816761985, -0.059857288381799489, 0.040305822149944839, -0.28957824077866468, -0.14269305494697007, 0.15204417093761297, 0.093962880636525081, 0.027143537174934621, -0.22903449596079961, -0.13176705819871687, -0.22615021313813283, -0.08671307347486526, -0.41065166982453294, -0.050795243992905449, 0.090013324111804696, -0.17670039031448373, 0.16057702557382314, 0.06377097568485092, -0.36966724769601456, 0.11859055148157888, 0.26893427800566821, -0.068362581664765235, 0.10897895639399308, 0.098464612620261488, -0.12858355460969126, 0.11701538446897378, 0.16554026971582295, -0.22833024599385737, 0.0068253440422830942, 0.066708609936906735, -0.18601308256335944, 0.23956915614751126, -0.48404497663088025, 0.54349089863654554, -0.2176073357065009, -0.017173026337366885, -0.069547426982714877, 0.19004449290861139, 0.35845965128851126, -0.17463760106081247, -0.065400033341564578, 0.089263254334310996]],
                            [[-0.026786756485604107, 0.17206588437624265, -0.058136708277315617, 0.13802737933316778, -0.25365818594808431, 0.24998951240848874, -0.084902901377893802, -0.0075342467265347712, 0.40855972523649464, 0.36970977817082656, 0.024744563998922671, -0.16564188985634273, 0.29917131482161774, -0.27414059401359953, -0.070927646138712719, -0.090210112251654109, -0.16496166589667696, -0.2465371286728, 0.19270871624585723, 0.015004222879629974, -0.028622197174336429, -0.41523383791851137, -0.054400419383129978, -0.11795275429911552, -0.27550673354377497, 0.25720167113183434, -0.23039462742666489, 0.026500050894185979, -0.16599527079000062, -0.27499732895770795, 0.018095408362416826, 0.2572167690239936, -0.18960688222993455, -0.77661369626426568, 0.19057504889039117, -0.15673004731369058, 0.67695242538326506, 0.057795276368965837, 0.29688702517014603, 0.22277635717096692, -0.21652339416413197, -0.38652547613447535, 0.19062247000236715, 0.16840466797817927, 0.0059661889442939563, -0.21195053701985192, -0.39988530733838845, 0.39397256055083663, -0.33507730393629553, -0.3522116576671816],
                             [-0.38105316094988667, 0.2188741502995693, 0.063264116909009072, -0.2473320372287682, 0.25080749697911303, 0.33870553566483536, -0.059798279090163865, -0.048097955887370092, 0.54685660068519537, 0.17713369961667935, -0.16184829861261149, 0.31825863294053447, 0.50940050873161158, -0.26082513109348154, 0.32180535159888746, 0.0947889269396954, 0.062773844121626884, 0.52369539834229051, -0.31439750780450215, 0.17944319168585288, 0.19919548806281123, -0.29303273135389235, 0.0083205868440962873, -0.044316086903175317, 0.22130393049499367, -0.20328010912493169, -0.090883333781047709, -0.045007651014101681, -0.084039173477485102, -0.050779860163746283, 0.11637124243073854, -0.38679935469003068, 0.10135246239118452, 0.10561170578700201, 0.016008815947513674, 0.20493009456191374, 0.064449017521959584, 0.13561694310222888, 0.10905790659094637, -0.090674298863594086, -0.14880176017726301, 0.30374078635352758, 0.37324927687209503, -0.38498503471419415, 0.44173125336293517, 0.30851967753310944, 0.39665309144518457, 0.012937544986733281, -0.33123898956676012, 0.48726262094330708],
                             [0.075975486537133818, -0.10118815365018605, -0.18716976738090887, -0.38089134221405702, -0.48125235265732674, -0.0028318936194701265, -0.21912451606670746, -0.13580383555872039, -0.16941115095563772, -0.18347865817614475, -0.23986345880846394, 0.18803454479017465, 0.12403502149725691, 0.43599682305007142, -0.35907841833693599, -0.12593108120943738, 0.56740008334583469, 0.045376046720081012, 0.45471270426951704, 0.35008315881602142, 0.15123715461909656, 0.34652189242532339, 0.007936209472606686, 0.084209419127579691, -0.16496514313637073, -0.28242494284291547, 0.49771079105152627, 0.7940588674345711, -0.72986969740303176, 0.33275177119240723, -0.099056675369432662, -0.33859680998016917, 0.55305510089822341, -0.35151505737801675, -0.39872376094846423, -0.17386651384023313, 0.23117723818434352, -0.18932941834270703, 0.052265408954067408, 0.40125595526794799, -0.14848838114888108, -0.013822349024179404, -0.68247649384809017, 0.0069746382178942972, -0.1590942228586131, -0.10622386540843529, 0.013491257598630133, -0.31805201692063589, -0.5108813954481537, 0.044951039397987648],
                             [0.50040183456578735, 0.012758974773087489, 0.11987378555114987, 0.18482223726735489, -0.09847215692756843, -0.079194015418547717, -0.06366441033005478, 0.045715599907844365, 0.24138484300905194, -0.14644705489952203, 0.35807245009711663, -0.56553344636972747, -0.12523563824050124, -0.017620320425801389, -0.32763222614536214, 0.14540870564427805, -0.03613926641647492, -0.021810109889980604, -0.32587363909436923, 0.13489480697793782, 0.13809476817511782, 0.19635776034643304, -0.32000374442681834, -0.12744814507635563, -0.093488073016707543, -0.068573489299869769, -0.2052610068847727, -0.4423906415567237, 0.2922954972437683, -0.11198821588794698, 0.38868975608738948, 0.26734607670482569, 0.2923890116319503, -0.25534505076183917, -0.0014841903418660735, 0.08635874292057158, 0.24999061278080298, -0.28899023443504313, -0.059811007779475858, 0.38132429318005867, -0.078065375748890969, 0.12424157887045321, -0.35605075626569899, -0.27652831339892769, -0.039543325881078957, 0.38497558498088669, 0.17295719428143647, 0.44731774434099403, 0.25858399853894759, 0.011365096769353603],
                             [0.097644947645863733, 0.29263242243125398, 0.46578775055909893, -0.10529497540290228, -0.015680740757007178, -0.43101202960422236, -0.10095189435183369, -0.028694996602755575, 0.053051486654971863, -0.031773048887838634, -0.27724900892388982, -0.42868979702034093, -0.42973134885120301, 0.10907133286511336, 0.052727348206345788, -0.75983889885385247, 0.042917400938441944, 0.12501417542157717, 0.02417355017952983, 0.343886871607676, -0.18503114196775117, -0.0096045638123092199, 0.040568236252390213, -0.5334357948522811, -0.21097063031348562, -0.17218195448779505, 0.19650483176748626, -0.23366189695898512, -0.13904680551506615, -0.47328696372738405, -0.25933593789844905, 0.52906533056492833, 0.043360641102428155, 0.27297358423474583, 0.48959669363202829, -0.038628135650180431, 0.017460681942724713, 0.21478965483971962, 0.56224438855588488, -0.040898546345373446, -0.12105471834439099, -0.26637018888859826, -0.22835397198157489, 0.50900196670238129, -0.33420767137247187, 0.18639177449521813, -0.46957573755625509, 0.35985671736996483, -0.40250732681261531, 0.25791029655188702],
                             [-0.24282230581685232, 0.095341675353637523, -0.15610613740431636, 0.025135724624696168, -0.22497342539360107, -0.12425862916969047, 0.29877137598313919, 0.10846752947626659, -0.35154788157411176, 0.18053603782342892, 0.31382736142437717, -0.42715033469221947, 0.019250887652978846, -0.40742924431425503, 0.18189081500781312, -0.40137991718496713, -0.19336839371397435, -0.0067556736856497091, 0.13509912013811382, -0.58878874023938732, -0.089188326283588831, -0.13987774106841289, 0.2404005390964653, 0.40427010138793618, -0.026866586898451936, -0.4304514524866338, 0.30431613190052059, -0.38212131959141649, -0.11405959731629582, 0.31556483191677803, -0.026433683861356212, -0.018217998713036941, -0.40090679247015693, 0.21890557607135172, 0.10281307229736791, -0.60454865451885942, 0.02046153927082757, 0.077393027031624553, -0.22490380234534885, 0.010635986358748878, 0.13525474394942197, -0.46090911509424987, -0.21209738120700436, 0.089248967385041039, 0.25652061256170422, -0.22315042003775906, 0.29623238501417137, 0.28555949562862537, -0.3607385907369498, 0.50910218315496791],
                             [-0.15646164848152716, -0.41174575580576867, -0.18232154852963561, -0.14238034852964276, 0.46062117616894288, -0.24974805989486445, -0.2662701916414798, 0.10716563241376588, 0.20967462170940737, -0.3327071346853559, 0.080649299072856617, 0.14020618429983536, 0.26410429948891107, 0.093239871448902362, -0.37828561041562625, 0.12084561899143421, -0.10254734704135837, 0.24131082350610875, 0.30229519690526185, -0.48357343036176442, -0.40709405453440395, 0.14953680542812281, -0.50051448943493715, -0.10710741382329855, -0.30649256621625193, -0.40030668304008843, 0.15267620644005156, -0.094524916199674888, -0.13903380560220785, 0.016083647927658609, 0.079823016840628591, 0.039903483554827743, 0.40076233916857917, -0.33332868909674157, -0.12534952698467183, 0.029038775208191835, -0.60143766685993016, 0.14159202570132545, 0.14173878921042643, -0.13445807667187032, 0.0039474670640330528, 0.14098664931825702, -0.081551341790058185, 0.41179410775881192, 0.66370274887669511, -0.057752170151459579, 0.033902798383498522, 0.0066117267351286715, 0.17413239072591596, -0.30585799257564472],
                             [-0.085787310987234536, -0.46383967892600697, -0.060248929610014462, 0.68831271243679903, -0.6267889564366329, 0.20880933695709875, -0.12408400435989453, -0.16363061447223848, -0.67367852657658911, 0.29105813604330877, -0.3397063617868073, 0.3365760601117499, -0.1987913688086011, -0.075785835621491174, -0.12451311448565977, 0.21663202314996177, -0.32666278427933321, 0.33150658966040314, -0.0136611311882666, -0.37853443652148389, -0.19697707521008562, 0.19128622798253953, -0.28923053410768546, -0.074807298650925419, -0.18903992732612104, -0.64588926162239524, -0.15188006802995593, 0.099342454569104011, -0.24383511056489121, -0.098699324799860128, 0.32359314861353944, 0.12918835379524293, 0.37093767738043981, 0.42050902408373281, -0.24390215909865706, 0.25710041924375088, 0.12556608488224708, 0.19337683812467535, 0.23369101936733708, 0.04246867367533725, 0.30711280211358133, 0.20392853050782017, -0.075815239271637191, -0.15460891768478138, -0.24885793296942568, -0.49397010574542388, 0.4501553518831331, 0.015720327118729716, -0.38117515416956982, 0.29337558437782119],
                             [-0.38553830324532046, 0.53805858959735076, -0.36533869835782112, 0.23740276735009425, 0.42998216941298112, -0.24772502885216388, -0.16758831251089709, 0.12598777592464946, 0.20222567694727245, -0.11367860509504828, 0.043531592708865648, 0.10421119932451606, 0.18366645425687564, -0.23846935990799037, 0.25693893402761381, -0.18087507590719354, -0.67890962590298753, -0.43514784920916316, -0.20375043896686196, -0.067336896627853721, 0.21836305338948017, 0.10061036218003096, -0.22671973481922419, 0.24310105207775859, 0.079110812262591479, -0.19980110972204709, 0.077214454493782642, -0.16082517429179533, -0.14291247889065734, 0.19674870849499132, -0.11392889338104085, -0.24343787477239601, -0.11796055446718172, -0.26592156944009332, 0.10372218209172802, -0.11801245885163643, -0.19430950788576656, -0.17816407300114151, 0.229321090006749, 0.21764101548684847, 0.78576056503366598, 0.11570525835854385, -0.4874730242207958, -0.41839139885053694, -0.65936087866784965, 0.26803162703797667, -0.017851323052571297, -0.34849407259634324, -0.14865259493398991, 0.28857012864355552],
                             [0.096316691439527785, -0.053334856054568135, -0.019574642738881511, -0.5258690430915014, -0.099875523274452455, 0.28593153132506338, -0.15102343913247593, 0.34740700641022365, 0.14027077976606461, 0.22623840489583991, 0.054416217869961842, 0.2046938285078973, -0.03723708399893802, 0.33671028311276352, -0.053570199919985594, 0.27242194177661655, -0.25813184464013722, -0.39742153383113288, 0.060918235111090881, -0.2778774231800088, 0.19670205678905084, 0.23810464076193716, 0.042095322701324656, -0.31326680073696334, -0.068342260916032668, 0.021993452560455359, -0.035895574024591044, -0.20958057626218107, -0.3083490496693877, -0.37505662740149376, -0.05329407114853367, 0.18584750262291358, 0.47998277973446779, 0.065020048803560992, -0.0053753917749441993, -0.72268687787579378, 0.075249057954246704, 0.045459356850579141, 0.2543331093995288, 0.055217919881597743, -0.50958881168234338, -0.13498756058739897, 0.012273519276581553, -0.16225483124066045, 0.2222373437494598, -0.19681498115812998, -0.33643178424814291, -0.2659304130101483, 0.45230143578186294, 0.22210729616355648],
                             [-0.15100977526071227, 0.51173483036716849, 0.14930124236391917, 0.21449191901028286, -0.074496833480686975, -0.29421872818677963, -0.16826850732930484, 0.54559605538457967, -0.031834722799288236, 0.16844707087281516, -0.13958167954183606, 0.097236870596032809, 0.28167384059106881, -0.066869689649577568, 0.16991735850531972, -0.35571843841416073, -0.029536534731627581, -0.2670194128339739, 0.34880091460205359, -0.1710489868771749, -0.48033035364371235, 0.43240398380891393, 0.18643877233178713, -0.047283044385085196, 0.067057618796496854, 0.32634010499269567, -0.40375429687670944, 0.31349198711681064, -0.097590502821762543, 0.45952105637329504, 0.063070908953506977, 0.36443319974876431, -0.1728465980828589, -0.02197197513837397, -0.034909275005758786, 0.17248947178773494, 0.29353227402115128, -0.30312283512758803, -0.50778127636117876, -0.01903457135444387, -0.24280088873561656, 0.73215848064075617, 0.24458168008077552, -0.10727414595988988, 0.12233301419296022, -0.11958574503610775, -0.020894613760803076, 0.043561490169361311, 0.04673301668992335, 0.054228633368660066],
                             [-0.0032470335171511412, -0.18272399694292368, -0.22113725293562844, -0.15491766521464664, -0.14798792192614407, 0.50116846265214443, -0.26639640482573979, -0.37471954920051126, 0.14797737389666676, -0.20972584935480504, 0.53442228581029239, 0.093107903778552853, -0.17806646974887611, 0.091538757620182612, 0.5311508589562991, 0.043673663086399188, 0.15045003930158962, -0.049093856553894581, 0.19404438896871523, -0.15443296554376473, 0.41141325061652728, 0.91780492769032662, -0.14842516868420677, 0.20839594556902477, 0.022475741765492704, -0.21469325547528145, -0.25763036511025317, 0.18002335327286409, 0.16297607312943754, 0.072380441680984287, -0.027862711381347008, 0.20499465561283262, 0.025605223720706075, 0.32892009756129525, 0.30590446191950565, -0.21027273374088287, -0.18289779191815003, 0.35236732155329803, 0.13892376810101864, -0.2419138107817384, -0.19142477506826108, -0.037871663421721151, 0.39505923181000596, 0.24166697177287658, 0.44514631026332635, -0.18289631521930011, 0.027534441282759146, 0.46697712037039474, -0.4285922921151834, -0.49030966513253227],
                             [0.2001333535480761, -0.081376278490684628, -0.23975423645667795, -0.15052477675843925, 0.44123539510845672, -0.010146689358166327, 0.039126745015083841, -0.17263627562650377, -0.070084278206927808, -0.2157051855533435, -0.32270032830120626, -0.21209260201188343, 0.17280791228047271, -0.22474362410308413, 0.47466192774955174, -0.14904756142842118, -0.12624152842018865, 0.52112303304077756, -0.16307002778797988, 0.071057428941023792, -0.33673666718227407, 0.27766760492743808, 0.11293610512622365, -0.2728307937824932, -0.17428051470798486, 0.48615014096157289, 0.32198500351524417, 0.16916611663596079, -0.088851850988797068, 0.09403410258840561, 0.96427734201089221, 0.070738243911567092, -0.17234764155297336, -0.29268583584618901, 0.49422174454250012, 0.17882111198384254, 0.0087371867593222102, 0.30993311325754608, -0.27649339016247254, 0.16432405712713957, -0.29156960443838753, -0.10685970092653353, -0.077822810100136905, 0.18779497569963557, -0.36634671524437967, -0.085180847515553035, 0.22978043241349355, -0.43571681885480901, -0.061814412546561795, 0.33397066133875225],
                             [-0.12446654271505238, -0.41281800321370044, -0.39612541713171945, 0.54055032303501782, 0.10609877325656945, 0.14401904106899782, 0.086277427180881244, 0.083370197689456263, 0.044341087437681295, -0.10129335563753304, -0.10398948980265819, -0.43469113783632868, 0.37846999476713433, -0.17701447975691273, -0.040501844959477937, 0.11240381484299518, 0.23000528245196111, 0.031124446505521985, 0.11955410287122073, 0.4099796045143087, -0.16840741092180625, 0.055473887188681618, -0.26187533155112247, 0.20034856018686659, -0.4193249767191794, -0.21967712306031209, -0.50649644594497545, 0.37752404422570957, 0.36309854721593376, -0.1397733066274135, -0.18125430817239682, -0.072795245845145559, -0.2584649645614232, 0.35508005292746386, 0.096957875877201991, -0.37000237345474857, 0.19000652398471279, -0.42544525683768442, 0.29900723452156164, -0.46701113331266952, -0.036003729324319549, 0.14682029035415814, -0.31074880254528875, 0.24136365963780096, 0.28497913239821854, 0.01185236865609765, -0.3504681946800009, -0.15904637867555702, 0.39016372660103782, 0.14411866916119581],
                             [0.48335899823733386, 0.088995733598066132, 0.054484197057506442, 0.33486880922259432, -0.1266168694486747, 0.17019386617751467, -0.075739645609219294, 0.49272418993541284, 0.15496685825385548, 0.01962801966041568, 0.15965919559869285, 0.22222463691895897, 0.11145916214582363, -0.38073819374638401, -0.0075197651288134472, 0.045661005291541497, 0.099857252081472211, 0.20324348333440578, -0.025553456960917612, -0.42034732610274367, -0.27717326238172724, 0.6513880743002296, 0.16324732028974437, -0.17194274110232302, 0.12241421003938267, 0.17917075208682945, 0.022108962759520959, 0.26505647170250712, 0.29791990948181468, -0.083149860706472498, 0.13156656934683578, -0.40610442645457157, 0.052069938554186582, -0.34535528136091853, -0.56053551019897441, 0.20967297912084046, -0.61822009782204057, 0.57926681065992047, 0.37127548645480341, -0.13721749475308043, -0.27553552092480887, 0.16334902726596046, -0.25135254660306583, -0.16756637083961248, -0.15767299382640601, 0.22982761159233278, -0.34186355950170366, 0.21373483756505879, -0.39486602771187018, 0.46013224527973134],
                             [-0.32109230643823972, 0.4524546799651149, 0.12761934778498202, 0.27855254488569647, -0.15385506382451658, 0.040795096922718363, 0.34941070138184716, -0.082881266297544678, 0.0063755995185310541, -0.19130957834545331, 0.27681721049388691, -0.24302488304389072, -0.036011401301876952, -0.091060210808058567, -0.45693865120339289, 0.28108369870925609, 0.051718229056865329, -0.32824497609753528, 0.27852369631895035, -0.13534138427506001, 0.062646311882933084, -0.027025556192643907, 0.073649231737529339, -0.05227113079404646, -0.37432798336824563, -0.38575996049424471, 0.40207921641047417, 0.3994559135700268, 0.19696804261331197, 0.2242171335558707, -0.053045892065910288, 0.13556622140423841, 0.27396129859639573, -0.065256297687430423, 0.28153461403799435, 0.11412916625851939, 0.34378737200156473, 0.25074275719005251, -0.12502069681204098, -0.1639491163067516, 0.1681372760452528, -0.046711590163402525, 0.68051081005268854, 0.1576933835207136, -0.25641148918890011, 0.25436670967171948, 0.57419426952422381, 0.2469253547067537, 0.49765721381985262, -0.22427113225819195],
                             [-0.14290587774679814, -0.061349415682151243, -0.073913912191553813, -0.20801395809879644, 0.16728127654420108, -0.15884657167925093, 0.21662086820785273, -0.32463293280526723, 0.29897597324697339, -0.21874244619927707, 0.25315450094438013, -0.055076589767920001, 0.19389339983472637, 0.0012733043634518583, -0.16154699265765882, 0.29770631809836035, 0.45674371194389368, -0.16805271747321759, -0.67139181019751215, -0.20400087605280642, 0.045482354552235718, 0.13853339836998843, -0.19600033701183578, 0.21856873858364964, -0.2212286568795751, -0.022809845593844025, 0.2358825081833025, -0.21899120741024466, -0.61086377129165736, -0.045641127695408193, -0.27482211028753439, 0.17884657777742313, -0.14251048598054472, 0.12581800572777166, -0.35596393774419882, 0.47692091168222395, 0.51843815284024963, 0.11646499257049278, 0.22578640309075165, 0.12611144583038308, 0.080179445586309711, -0.0082049171963025306, -0.31626039187354615, 0.16585995223865821, -0.062356323048214812, -0.082363312135546027, -0.084099823365096388, -0.38531517281708311, 0.037220663120842143, 0.38998486252674891],
                             [-0.48517855655897396, 0.4418763522682318, -0.23230942188887538, -0.10423050859173767, 0.28394207724491682, -0.032870752293776666, 0.044486044847362835, 0.071848444909580159, -0.15845607413729557, 0.19217089491116346, 0.11127312864634538, -0.33920657349905281, 0.082350761693250341, 0.29567519705985512, -0.16558842920996872, 0.51302214736327689, 0.1304068711689122, -0.14007942938825943, 0.31608386268838767, -0.20211064236935622, -0.10163632077752166, -0.069203693717333134, -0.45636056468045716, -0.059672300249326772, 0.43797801947130072, -0.076244466482319181, -0.051806303715597739, 0.2045849966423629, -0.011350924993322695, -0.053851617567661283, 0.11975196609841775, 0.15471264492165931, 0.090427302250827596, 0.34182535576281575, -0.018007839558251713, 0.15672676331785465, -0.39770632556568103, -0.16130607668377364, 0.084165638255818548, 0.13405009410862406, -0.22059104016646208, -0.6501217260908051, 0.043213600099047733, 0.0062621158306918698, -0.35525246354179579, 0.40733198265204551, -0.12326090027046185, 0.0095725844043232471, -0.73385369841006265, -0.16064056033948806],
                             [0.12934876608424334, 0.31167870028051181, -0.18269101754317291, 0.092524360430595268, -0.0038372331128695043, 0.19179652952876283, -0.11660480395407352, -0.50791907521883761, 0.078238281486499917, 0.16582352582475265, -0.0012638134523790187, -0.21909838742259111, 0.041911743294854434, 0.203961504300635, -0.17233850660601174, -0.12383805453467239, 0.17090425187868974, 0.17269134712139361, 0.36636939066192514, -0.18008528766358639, 0.46479429563717561, 0.017061808845512248, 0.32005580331935835, -0.36003835768896358, -0.72683623539029607, 0.54628342206659197, 0.044817853061229512, -0.12442348540458065, -0.18076704628704338, 0.16807831958846325, 0.40098791615654117, -0.37774440839918233, -0.19205703223780529, -0.06076062773657237, -0.16858765526585878, 0.074483302334808321, -0.77044387474586651, -0.39511878304814674, 0.38784127159247872, 0.30840899455888715, -0.014734297130180554, 0.17199357872442378, 0.1260455602733716, -0.46947329428217521, 0.17710757529956186, -0.047011876997825164, -0.12218316482314631, 0.12024453343373337, -0.30853614162925069, -0.00077239918657175805],
                             [0.16175061378492711, 0.42632538539888182, -0.10349654941630297, -0.1329211337438391, 0.24336697385571629, 0.39999615119966164, -0.12612495569707641, -0.29160416447833304, 0.38822052203295127, 0.29758431981674927, 0.13272857461154061, 0.17717364119829077, -0.22109224647522413, -0.039153845526085432, -0.61485653426539644, -0.36470141703658454, 0.097023177447528919, -0.16088167633344908, -0.29955007233655978, -0.15425052413763363, -0.39718817463201189, 0.27539933148450402, -0.089710367229052082, -0.15459450992462095, -0.037630210027914057, -0.26267397159235489, -0.58094238806471377, 0.071746357517138801, 0.26046903566405993, 0.38652285830047672, -0.37856934292437472, -0.17381766261788034, -0.13532038710283897, -0.11965313083148224, 0.39677801410084501, 0.09518237982143242, 0.22234979011299316, -0.077543487789087331, -0.60772716111126324, 0.53903270615429943, -0.086568555748248316, -0.075423975252234432, -0.37536682763463547, 0.093720922825068775, 0.35027158139812087, -0.18006840909342631, -0.46336829982148536, 0.14744096165689338, 0.64030712110543997, 0.17046045414025068],
                             [-0.042038503609996607, -0.30600027808968805, 0.2755933426127295, 0.084647549413223028, 0.10826324114138136, 0.3263230372235158, -0.41640304070564116, -0.062438792957803718, 0.081328288353229999, 0.29372823169412932, -0.040489237884782536, -0.30181311451537718, 0.10666532373100228, -0.27151253655570146, 0.22052741014548757, 0.085732961584772352, 0.05596286575940726, -0.54165186940855159, 0.13521598913515892, 0.024010202303423933, -0.12852138090753595, -0.008739983882365028, 0.21562546708249836, -0.20984749380808784, 0.037260376137416999, -0.40542261230377724, 0.17449892544304307, 0.084383795775272274, -0.0090307511801879028, 0.62998678023534416, 0.51407779169750567, 0.054680016126793324, -0.056044885329036648, 0.26754100300534711, -0.71548620904210825, 0.47534484252075015, 0.36293107034561828, 0.058032130813915228, 0.051705943574800968, 0.32643527584960419, -0.12433338410010414, 0.1410726070062828, -0.14815390197609909, -0.0026841003083642595, -0.19018095416402281, 0.27563157469241312, -0.13408631997991047, 0.22582297607348895, -0.054934343642274112, -0.48729787837664407],
                             [0.23491519191232418, 0.043040173644706817, -0.059090972996264722, -0.13592552360505081, 0.33652929817514154, -0.61700034620675637, -0.24700367568981513, 0.22230726663396957, 0.32686679961062365, 0.54889660359509929, -0.086316339071085019, 0.068945537372721716, -0.38986105517086778, -0.39866467360008534, -0.052947750938341288, 0.2368399667842265, 0.10865964066210146, -0.0019735768836754673, 0.19194484622462424, 0.53835582877184751, -0.30836718315603212, 0.0035737667198928666, -0.38477633839950448, -0.2047482964532312, -0.1500909800511219, -0.42341979256530954, 0.39760309129032928, -0.4646627987937631, 0.1337480572871069, 0.22246983549669286, 0.012213768742366076, -0.34126803042626591, -0.30765328753857718, 0.28797340472894195, 0.1055931962028559, 0.12592417831510208, 0.56136620241279689, -0.10233857340876995, -0.045778635086717034, -0.05507692450998989, -0.033319112829909216, 0.0060787972610258706, 0.021454027960438146, -0.34518396754044922, 0.019181061662698486, -0.47709500394154486, -0.30302443412140079, -0.21935637032738869, -0.24624965857759001, -0.30838753191497553],
                             [-0.19226779076074665, -0.086759333297405206, -0.0026590953119129484, 0.3748448937863148, -0.2689081629874463, -0.54859487243701022, 0.4112262412931425, -0.28333276304461069, -0.04171364776899502, -0.20310685133384851, -0.22210641686314433, 0.3865153358566063, -0.0078018742109454732, -0.29239010889107758, 0.11472691363721457, 0.091873946468533266, -0.16201438041094673, -0.20377776955498467, -0.15142173022554664, 0.042418340194722771, 0.1055879498729539, -0.2122741758933227, 0.24703850253393436, -0.16001156292720956, -0.21383180798720242, 0.29300760626168554, -0.43977902025240767, -0.44129281263424758, -0.3060556518395714, 0.13479180888379483, 0.30093943370279685, -0.32117567470595348, 0.039887459256567018, 0.22034471988784832, 0.33297877737308418, -0.17127052759828063, -0.10303597126105593, 0.19985384720880864, 0.2833767948028183, 0.49333452471457029, -0.27226011143722662, -0.028294466660324574, -0.30492120538240919, -0.15245651412374892, 0.12514693239802283, 0.53422933417516905, -0.29028693721831983, -0.19382437898622984, -0.21438260603980069, -0.075743781229056728],
                             [-0.47459824967631847, -0.32776220815747253, 0.048729976489233572, 0.0018101129350210805, -0.2387746547336296, 0.13648768129266561, -0.45049456374291325, -0.10233406836920901, -0.17992400488878929, -0.34611721982018517, 0.65828277581601458, 0.5059803366257879, -0.41098191632438863, 0.031352255618360782, -0.063777066961118359, -0.058272273152847151, -0.4363231046673543, 0.039930814362987697, 0.40992705719426636, 0.31191414340647977, -0.31048393135648544, -0.25475173898811543, -0.23604981870604039, -0.016367291025276325, -0.027597109737809041, -0.067531497298263993, -0.16368994374854576, 0.40540434528250258, 0.03084590647538854, -0.022956436894120212, 0.071160792906502096, -0.44929993556133535, -0.15626904097168415, 0.42785142744436544, -0.087527758859700072, 0.10099909604724368, 0.34030382921182822, -0.2567909440197742, -0.10521826244595142, -0.19078884446152569, -0.32189395269015159, -0.52630367886979046, -0.2449204052223502, 0.17400657842930783, -0.0015301676486421077, -0.28596753021890015, 0.15268421771964133, 0.037584460931991706, 0.017449699438787991, 0.29359879911168763],
                             [0.46566703544531096, -0.13768647069165854, 0.15877002784094746, -0.30367379141146095, -0.13193601295881813, -0.11493599915330815, 0.18454242815080954, -0.2557295861766794, 0.26074448994653882, 0.0038440257617056335, -0.24316669057557028, -0.51006708741307827, -0.18293707978952889, -0.66874117621137308, -0.040988890659792082, -0.055958793983521618, -0.052113979164256571, -0.41244230163710099, 0.304258981679561, 0.25193574397933999, -0.045700285040856881, 0.065306197745754399, 0.10249796430831709, 0.36988946932276978, 0.17793904969627536, 0.078339562060729701, 0.20575372379164666, 0.68537733248879162, -0.35854264136491676, 0.015255003622331091, -0.13796311010530179, 0.12878318415032394, -0.1775158622102308, -0.012746044783112191, -0.31196865369950233, -0.095634590789158452, 0.074756074317126539, -0.10665833491940571, -0.15442748953194896, 0.37287880230371162, 0.52846725351431501, -0.13903706609591071, 0.66439282650768494, -0.019819190370080373, 0.10661436271158453, 0.29254492084613165, 0.034366003420166436, 0.13509742649729828, -0.11483477670439468, 0.67167417853058975],
                             [0.15933369973441416, 0.25134969963739384, 0.45861060783071578, 0.032190405352752784, -0.058754965769169089, 0.099413897396997727, 0.26589722586555187, -0.20579877412539963, -0.34014481654270995, 0.11038641141443958, -0.20381559063006061, 0.24512907849793808, -0.22240175599814849, -0.12309016753429894, 0.24793141378681427, 0.55622379123107202, -0.091172047567226869, 0.027083840804263959, -0.40403279849210455, -0.12776592821721708, -0.44936595109166017, -0.14599752057540263, -0.27361610163555938, -0.19658712486309124, -0.73472388464224525, -0.33771083290113729, 0.2023637006369513, 0.32222183371516677, 0.17767041145578244, -0.071049599351413528, -0.16678758738333144, 0.075157215458398624, 0.34114500760602601, 0.070603121348730744, -0.05780646496068937, -0.077154247292505237, 0.12898606556591777, -0.58773039772879121, 0.0067434109889994553, 0.33246506554485894, -0.10545471644572446, 0.12594694348679891, -0.23455493670226926, -0.05545709549827426, -0.04230342133311215, 0.083569666778454163, -0.18722119278585655, 0.30735267869139588, -0.18423889656972636, -0.23756774322447391],
                             [-0.11114647873499986, 0.68161890674541259, -0.46584398913037212, 0.072417946732515781, -0.19272326634484288, -0.12398048851108766, 0.38045866996474831, -0.027136258784373951, 0.20708860456621597, -0.48499667078580694, -0.48323814931590392, -0.54043746352192124, -0.13205853541494436, 0.10067051795506429, 0.30029058599132313, 0.078678547229852153, -0.1883563148683805, -0.13534282213312804, -0.37338327080456074, 0.28826541018354246, 0.24460038043385401, 0.001993516218568539, -0.32227811161320197, -0.29063473550931129, 0.19028884035607893, 0.085856880604474328, -0.016904536524121133, 0.15388358656037376, -0.15602616374015876, 0.098232748176170254, 0.40351903378371168, -0.21730058166635366, 0.0069273400101167691, -0.25698486423028805, -0.41699634647818828, 0.050525837317438579, -0.16755616452007455, -0.10740676591926623, 0.011312452544155444, -0.33205986300667728, -0.16366325686665181, -0.12099964041241655, 0.12321091215338108, 0.051157370388868348, 0.17817342849191742, -0.29930109121097226, -0.42992046049484606, -0.10177457467096276, 0.28500621785876507, -0.028924344814038397],
                             [-0.30211469743695729, 0.22318897973245522, 0.14987233577868997, 0.13971206135120148, 0.13994517001834902, -0.084027348015047992, -0.35387091360287148, 0.046780018224461858, -0.30828103967874249, 0.045428463296712684, 0.41083983893782522, -0.52690127943361154, -0.53535849569189564, -0.095545402095654833, 0.23063337999266842, -0.024792519218723899, -0.19582228420449943, 0.41361211893046151, 0.14968545943500133, 0.099644710307043596, 0.34498588185846241, -0.28317646137281349, 0.041326691936584045, 0.13999613244629258, -0.08634072156359103, 0.12908328083069909, -0.11636807451249592, -0.14250301004877342, -0.38922701863435483, 0.058244338610237353, -0.818059966113176, -0.046442835750856337, -0.10673226887779046, -0.07009506439019858, -0.25980154692468133, -0.034069473224611194, 0.39598171398432419, 0.30428819009810648, -0.090120626451386285, 0.074438957605668724, -0.11903568080198167, -0.10689874512531168, 0.096384288256735035, -0.37331517018439869, 0.30119628885170413, 0.26141822008288518, -0.085211238548622337, -0.4053213184747278, 0.21707515121875409, -0.28582445625292269],
                             [0.18748484650164104, 0.47024298517779078, 0.061915651685934998, 0.14519432155703321, -0.38986136587642922, 0.17711349870247578, -0.25460528606412919, 0.18978333113939189, 0.44687841483254942, -0.052448865811630524, -0.20271333392340005, 0.24383437643533509, 0.10760313655431841, 0.033104339096460544, -0.17417968210288448, 0.42165486124174517, 0.026354201391774794, 0.47145586668074108, 0.19122185227528046, -0.1009881020370295, 0.57148000159723911, -0.043333585969104131, 0.025447526936749461, 0.5641346639203153, -0.29735660246579626, -0.24419348853046016, 0.22112521974762903, 0.23244432353780492, 0.70438449003590919, -0.21320316162030503, -0.016155172946581364, 0.3174818178547652, -0.13942319208623319, 0.48986731441992171, 0.03061368676639363, 0.11261161757689608, 0.19268757270985049, -0.36714485152614357, -0.0034832320861747992, 0.061664189245988529, -0.057759389006969017, 0.17818723828503102, -0.29451798796718476, 0.26605723565061107, 0.21015250711471239, -0.057764486501805878, -0.1295851722868705, -0.30677905881093576, 0.12547095711500439, 0.10410405984065287],
                             [0.27163636212505621, 0.5551303589015667, -0.11542701072301469, 0.1085965962649509, 0.30299665448121571, 0.034064733697495075, -0.23706388719582214, 0.18121897659460684, 0.068353581763197155, 0.49610866308030543, 0.09685799307383279, -0.12394426943473295, -0.075479641802043987, -0.055720084579365288, 0.30833131144178338, -0.25031203664286278, 0.10006159835322934, 0.15295088312176378, -0.093655248237526467, -0.04339868003040627, 0.58999138052994493, 0.25357542544744277, -0.028229624584422255, -0.01322073306750759, -0.74064275783107125, 0.11284600324093461, -0.80500365525134809, -0.032068627976561605, -0.36169181009164669, 0.37273134692675819, 0.26564919730370629, -0.063129737475196887, 0.083539409231580028, 0.045244782917283427, -0.27506651954762473, -0.029190305206615731, -0.14190963393671513, 0.068682836497258259, 0.3044922195488603, -0.13569356927862614, 0.05819874196262808, -0.60723449856944312, -0.34053749873708594, 0.83767194004556089, -0.23423212306965416, 0.35263410910337056, 0.32183363357800598, -0.27108749166748985, 0.022231165163607455, -0.19518178565368824],
                             [0.033166560412357105, 0.059937674083361828, -0.90221325451218914, 0.18553830758349343, 0.10510220720823923, 0.52276523086591431, -0.16215374978080524, 0.13132956249917854, 0.1869080964658188, -0.24324269744581062, 0.083700481517826886, 0.16620084416625064, -0.011359235708714173, 0.23162910415451135, 0.012011324191097348, -0.10740512894584772, 0.12730060228164411, 0.030443741611794653, -0.1297171866181433, 0.30895768521005884, -0.33704637100269397, -0.137439015510539, 0.11686513177017509, 0.22451462759761609, -0.63084963588580489, -0.32353575616322561, -0.41025923557846955, -0.52949323332381171, -0.36628489668756836, -0.55869502781222735, 0.043617568755202778, 0.068723099340679314, -0.057002214915542783, 0.042223319319197095, -0.10721326910235228, 0.38100377546092967, -0.018622630658049671, 0.12023300609516109, -0.30972607836652155, -0.27555468694023616, 0.10322004678494746, -0.45308202966931066, 0.29015405724250692, 0.17356302686232275, -0.075148560017842328, 0.061859698522929309, -0.37130691229082474, 0.10790612448030676, -0.29988197933525795, -0.099275886955168244],
                             [-0.2799255894749878, -0.11316310473879365, 0.070438626840007262, 0.1712568616940067, -0.2133700548691837, 0.30439987474617702, 0.28003251658867356, 0.65286271634541926, 0.26624480781432847, -0.16151295643934555, -0.15390935485051899, -0.35567520423791177, -0.53337473789800216, -0.222509087182819, 0.26051113137282345, 0.41666246227329046, 0.22273166032341679, -0.1222710889390005, 0.27721386005463028, -0.03587404158747582, -0.4322437854822897, 0.17331848697641772, 0.29941554679051929, -0.24193461285484594, 0.22139124577962566, 0.063722989705790475, -0.0058633954516451505, 0.088856064159761564, 0.11357907405578148, -0.022818178658654886, 0.29616128149548404, -0.15312973897394744, 0.020673788510022658, 0.15222423535519275, 0.13863958700735926, 0.39320355502067145, -0.15340863698566787, -0.18503570489031923, 0.35509097778930288, 0.4636653645381138, 0.60015248375698638, 0.078275299393971084, -0.15074394176389053, -0.39074589961305906, 0.32433524356750704, -0.34689644576837708, 0.15771356341814932, 0.44910582312297159, -0.096911645379160388, -0.12045643940415927],
                             [0.49952713416061462, 0.28973767440271997, -0.050945389214618365, 0.12409649883401025, 0.11585594102781349, 0.47800887581196494, 0.37512690238650936, 0.071703104126732253, 0.059292536569745438, 0.18827579158220437, 0.51562144211672378, -0.03463924055898298, 0.12219150306314278, -0.24728563037250822, -0.12069022087746306, 0.01408051761791318, -0.35508225187964088, 0.10173026228037378, 0.024711729073310797, 0.22203234743384714, -0.044852199915341714, -0.17256608982102437, -0.035804954955594957, -0.062077374445272809, 0.43527264979754354, -0.23251162342442272, 0.017921330502070971, -0.029852308350087599, -0.6193261632905015, 0.29657194105920964, 0.14321695036666182, 0.10454810997410798, 0.089708857805868625, 0.30683762424217187, 0.20247186854296792, -0.21094566496413678, -0.046507917575792007, -0.067859333969047933, 0.11315123069046421, 0.27790808964541441, 0.080153160005096355, 0.68948470889530344, -0.51171192196345083, 0.20495577285506242, 0.21953430929035331, -0.25266932735155717, -0.025485542721131252, 0.074638267885728249, -0.11473263076832466, 0.11568151441840736],
                             [-0.47204656363048442, 0.020678627928376526, -0.64251190756984766, 0.48622079504286186, 0.18359735454887005, -0.0057924215236053352, -0.32525458236834914, 0.14740816537159829, 0.27654393568757396, -0.089884407479204523, 0.29902824140872081, -0.088928275597639203, -0.047081577856017624, -0.1589953767029143, -0.10493950617018803, 0.081943610466440248, -0.082177001476634273, -0.038408955510113196, -0.52397427488630577, 0.052270776917770913, 0.078479746583703824, -0.0094972685367506852, 0.030765248697197226, -0.16815165028153867, -0.075711060230768609, 0.54155513474098171, 0.52078683897002698, -0.061845418922526152, 0.06985246333638824, -0.33968860916775456, 0.10138861682388156, 0.034288411286306525, 0.28866126761835503, 0.24066708141911805, -0.42725060898062195, -0.41183001434588451, -0.12436232534448625, 0.32788491499149419, -0.36043715269843013, 0.079668848464528749, 0.11855771292998291, -0.033987124808621233, 0.0035199957085261264, 0.42906350298345031, 0.83946492033102016, 0.12379582213870215, 0.43518169660502187, -0.324441463027486, -0.4287028605918588, -0.17888734303567727],
                             [-0.105275514063808, 0.043661146173348854, -0.33097766678196772, 0.0410831043601185, 0.37815120340276848, 0.33455425413394285, 0.20571867845053904, -0.059549252281063836, 0.10759929755885153, 0.301207665568613, -0.096498311762411373, 0.29433354063148542, -0.75100031386948285, -0.19038066228674738, -0.43068761135136774, -0.10263327780925546, -0.42096199619336938, 0.21650827737454684, -0.10866302336938298, 0.2726039140184866, 0.043895075129967716, 0.085139120164270665, 0.066518968640830942, 0.46970730460106314, 0.11163971980066184, 0.20451333016549331, 0.34254054258726857, 0.074183791480229536, 0.11879432332172414, 0.11227615086786019, -0.075560241236228259, 0.20729173403031032, 0.082458357208621449, -0.22253291012062643, 0.018438391095828382, 0.15926109601215929, -0.082785733578114612, -0.11350532828227641, 0.28759848369050711, -0.68773800522016526, -0.3315500625263022, -0.11893041898492018, -0.12618197413295817, -0.0097144890232423245, 0.1622520126123824, 0.13514372018269838, 0.17409003956444044, 0.2625663345693186, 0.1298115374424029, 0.049854665079372792],
                             [-0.2508358504647058, -0.23998349408578362, 0.0060990929354862167, -0.084842314591088264, 0.33270722278988335, -0.21729544659411965, 0.21919589009467247, -0.061989430396329426, 0.48541464865584294, 0.0021280019023166338, -0.20765138908211991, 0.20153214856041921, -0.27771463810936231, 0.1771881354366977, -0.0087060772881364414, -0.028670632065242896, 0.12651800076289943, 0.41370252148264314, 0.40554523612958843, 0.52291530669273123, 0.13879114157463829, -0.2692829450558325, 0.017982600050466278, -0.0013873978183265804, 0.1218231391348847, -0.34314084365760794, 0.11462516425843997, 0.49846414883826562, -0.058348900508794342, -0.089941925331222375, 0.15912897434774634, 0.34405306507396022, -0.68323311135921028, -0.011843481331988606, -0.78161713944418765, -0.56655385787271617, -0.15876588027215205, 0.42540714122032469, 0.11011845501210303, 0.45831678240911367, -0.11965220142003322, -0.22827130867303155, 0.080737516891873071, 0.010934324416273636, 0.028617809899273296, -0.19547021787487309, 0.40374582518323554, 0.32140034600758405, -0.0012890446673045515, 0.088335284121010826],
                             [0.29323519095383654, 0.29685911148108229, -0.26254583111576479, 0.1281961214856385, -0.15878660634109004, 0.25614551408820196, -0.38625166510515913, 0.3537919229839443, -0.61013665633261072, -0.027105715452320628, -0.37033109896271665, 0.01010734164738852, 0.26109553048949075, 0.32805872870414832, -0.022518978580008373, -0.05404356322330469, -0.30444873916645171, -0.41846511901258221, -0.18625129851643946, 0.47567443201542053, -0.098924838685146038, 0.220615056332193, -0.25298815786003165, 0.051914638934649281, 0.020974676092014494, -0.11693749784964981, 0.48941017788826341, -0.020502885424607015, -0.34529955006933627, 0.065563905200654929, -0.012058178143179473, -0.30628001667546217, -0.35733948895492551, 0.17016766405440184, 0.25907569980109546, 0.1274848284672235, -0.12745586301418485, -0.049724653694365593, 0.31641994636473131, 0.31093541703085709, -0.12316546359358303, -0.20396778160431289, -0.045841754392806959, -0.28342759569333337, 0.44406413123389804, -0.19065589298101751, 0.011473007613724544, 0.087574787795719922, 0.10817481748424204, -0.083333762964202182],
                             [-0.17455519419980564, 0.021971256008557344, 0.2088173456883986, 0.16715608996661308, -0.52745910828714659, -0.17553017617433689, -0.093058359008355088, 0.29895288370224271, 0.36557579708270455, 0.27797071989369959, 0.68380725174069967, -0.030925185424424906, 0.13501431438037748, -0.11188506579226204, 0.6092529941090814, -0.12991325134505299, 0.34262605930871937, -0.13130844591374224, -0.48214342852965386, -0.13756686186122946, 0.38652963115919053, -0.22889077166633856, 0.097611764048609939, -0.032500436140562465, -0.049839177490260435, -0.21302651028162073, 0.27411590548218734, 0.10064549324293803, -0.19693947467922374, 0.11116210204825125, 0.36315410709977652, 0.46588766440313822, -0.048224367006867004, -0.13692500360512483, 0.54564206027725992, 0.021045978330317541, -0.42648779319071611, -0.2364552296768403, -0.14032194197741382, 0.050790550613353337, -0.11872876332325885, -0.11106878085954655, 0.27495255732057333, -0.29583999495970958, -0.0045625881676972756, 0.18964832614271948, -0.28792362464960675, -0.25299245540699011, 0.34198407630107874, 0.13293340171358836],
                             [0.11561560081104751, 0.29693540196055984, 0.47069914222167492, 0.13489059934020239, -0.19386694463607362, -0.18093046307450264, -0.67356884800187933, 0.043187923723619445, 0.44612305917392792, -0.32482343092627297, -0.19310438804490881, -0.45231441218311497, -0.34642588607571229, -0.0462022143886507, -0.071442981368484038, 0.44077629654817158, 0.63175402703220029, 0.0830329461321518, -0.3488813269986602, -0.24351326855038569, 0.035578539448864965, -0.30018363980584639, -0.14770521767193545, 0.48505560596953379, 0.21732389411890018, 0.21404041841559601, 0.12251059812817366, -0.067492516899012478, -0.16933184682803296, -0.17522201813467597, 0.22440957927028532, 0.25837748464421023, -0.01224307965174414, 0.38534018762594002, 0.30588970009654559, -0.31673762262249189, -0.11971402903713602, 0.30487817789372279, 0.021698925903946373, -0.36362205200578324, -0.068566298509782853, 0.038291114897335533, -0.11575079201304145, -0.0068241610981317063, -0.50583209298292808, -0.096082826258509973, 0.18982395937451757, 0.47590215867384456, 0.16237622572338301, 0.06953537792672565],
                             [-0.031728115181965694, 0.3068690364141401, -0.85533964213850877, -0.36683070619400582, -0.30375301770784119, 0.065929323536873502, -0.16252312893342583, -0.010874348224724972, -0.12146393463670382, -0.032580792286381659, -0.14876264415558182, 0.22979814108860586, -0.19715517751967035, -0.26559971208376881, 0.077582019897606866, -0.052758202795041939, 0.3318454604594635, -0.12005711726022478, -0.078938889384312774, -0.51710330873893706, -0.39988535537078462, -0.57973667403843343, -0.2690800270005072, -0.36541789901043564, 0.27250269742507871, -0.30429825731868965, -0.19708313323753793, 0.4125179333279283, -0.068310798305396228, 0.020884309212696704, -0.058433394693088607, 0.43296784953051209, -0.43107459365347428, -0.044194624797617411, 0.073462524231746068, -0.20139794384418358, 0.16072015176792021, -0.10607497469300312, 0.22881937459690654, -0.14767236968230515, -0.079119073197097087, 0.21146268587329223, 0.34073280396689043, 0.42877998130012401, -0.16764563938495863, 0.27882231363440135, 0.34027613011998675, -0.28644263328001174, 0.0095632862767113594, 0.041665277886694392],
                             [0.33207171249336231, 0.35987444769368704, -0.036566318295519311, 0.20273244176763358, -0.24424112071100879, -0.098252725024454007, -0.036734575683555412, -0.48120448433634633, -0.18903623613372322, -0.0089039340264862807, 0.14844825711134618, 0.20804822325249722, 0.20168974935556763, -0.4263968651653165, 0.18964952120490366, -0.74103698925184935, 0.36103809554827226, -0.40620872518656581, 0.1326702524222772, -0.30412253300509207, -0.05177550569948975, -0.16385410731649266, -0.21041708052590868, 0.4023533889160445, -0.3462079681602051, -0.041882720237599674, -0.038598868710888204, 0.035651233446517647, 0.24280576731100492, -0.5616798301893392, 0.078540362009433456, 0.099621241839858821, 0.3485179391949994, 0.2078390021258896, -0.089080591080481455, 0.15258947146213969, 0.038560554809287266, 0.13982383366428372, 0.080236308156074992, 0.19168563933668764, -0.013855859597318398, 0.0098953788954897585, -0.057504622360650119, -0.48711002424223854, 0.29239058133615858, -0.3046443768969887, -0.1434597368506543, 0.10954729824574425, 0.29066360133077412, -0.032424341995636118],
                             [-0.31782419787665661, 0.4429066750032507, -0.23987124639362939, 0.30678908568668795, 0.034135077683243677, -0.1840214816857218, -0.30109223757188647, -0.32088100091836091, -0.098808941462851227, 0.55436402289672737, 0.24186411045521103, -0.22447322012446938, 0.12744170484710099, 0.11623802634805877, 0.63830784625268866, 0.29263874050090838, 0.11495077162669187, 0.02063007096984509, 0.42216362113574357, 0.013403592361220977, -0.19935271050852013, 0.20503340481857957, 0.19176865566497803, 0.3336149448748113, 0.30981908626959098, -0.0028723766299862622, -0.040731925031778873, -0.12230416202089406, -0.059981769316300768, -0.099994180725080914, -0.046503983879382406, -0.18785967730913083, 0.45643670134984776, 0.0584654733356261, -0.079909026261168151, 0.16019262853976388, -0.09298015345360619, -0.31366901917496515, 0.35142359222276448, 0.30411736328529254, -0.02593663803895889, 0.19986183735400884, 0.23747145818797352, 0.41223983551897941, -0.30958677603104584, 0.13909500927812718, -0.075138004097909106, 0.48132593703266119, 0.47661382754297582, -0.21815150757977905],
                             [0.15853974684941918, 0.065332136535258517, -0.15978016459549285, -0.51164636783533479, -0.41316961553026793, 0.11353191121467465, -0.023356418381693396, 0.024110226292775198, -0.080284407124793886, 0.31053166408827187, 0.023904903945832362, -0.17640492419093665, 0.30277670166804715, 0.013383312020163959, 0.088825792319745675, 0.38175927678127858, -0.315878568281862, -0.19839965537229745, 0.28504427796172183, 0.19311010057147165, -0.49230151574928005, -0.22909432946473918, -0.00047125886415781823, -0.07531855358683498, -0.40797618040387229, 0.27752513502331377, -0.19491944987576129, -0.14702929751038521, 0.28969549777402548, 0.48864154625820505, -0.211035511111165, 0.41672425262592483, 0.086431278877897352, 0.0074777681140182125, -0.13053412837297687, 0.085509380073277033, -0.56471761822492472, 0.53133729447684841, -0.16197505817122598, -0.1024261629667368, -0.18678883295305279, 0.40700445138318397, 0.033549529633984922, -0.28854751786948973, 0.29306928916241332, -0.15538493996350428, 0.1094189492965892, 0.066746384156057256, 0.21605835404496115, -0.028231094536636674],
                             [-0.60250357517614805, -0.086539455453199188, -0.031614898200761105, -0.61764999782676289, 0.040122157463039397, -0.22710004313540333, -0.1938558933692541, 0.21076134238183708, -0.36921056769592742, 0.075128494665866685, 0.31445354736520514, 0.093108747018751825, 0.056281994576906906, -0.31395911398140247, -0.20384324868365608, 0.12133910212718872, -0.17321155643781933, 0.26397820643166936, -0.17977666054878433, 0.0072777991634979753, 0.61572115744792166, 0.15268841003739497, -0.39281332514402378, 0.12655444548549963, 0.024472229051359529, 0.10673275625621667, 0.031804714147240308, -0.006925223394833693, 0.32598053106188096, 0.046190585339439462, 0.52561227732630866, -0.18614143785920717, 0.15284862011603312, 0.14695408896812415, -0.10213848287719694, -0.18542278823595959, 0.18097049286363576, 0.12399186715030448, 0.058507950594969854, -0.012216282332231446, 0.31292559301703543, 0.089585436615448474, -0.30984629842144501, 0.1546728305456915, 0.029377968878338899, 0.28553353543886917, -0.47843142996982302, 0.62814199799339776, 0.17714695553906865, -0.09867978436656151],
                             [-0.34117566796535892, 0.030909440749068248, 0.020718358936418851, -0.11607224970235407, -0.02913692186745151, 0.23362460361754647, 0.13867147839967592, 0.33985997936815404, -0.1158587859985977, -0.012355527037909703, -0.14172108861079888, 0.197069668486169, -0.36901592913511361, -0.41797398770040606, 0.072774652339720497, -0.070267666222780259, -0.040920474248553038, -0.12514211988017421, -0.053718979214075459, 0.26142299659243795, 0.15034212186622292, -0.38284557561954463, -0.19261580868976899, 0.54667600342767575, -0.26166510083634892, 0.039934340083844007, -0.044741037590924827, -0.23939848767258345, 0.30471751807246705, 0.2319377270477942, -0.22060585350621736, -0.29296499509745627, -0.053989265994848774, -0.13709743849955966, 0.043335151828546963, 0.11745348699997536, -0.18035332703078416, -0.22384763197786195, 0.041565393219738261, 0.37808464385397833, -0.37101137818807367, 0.04580153657273317, 0.84633561549970937, 0.32228183662887622, -0.71350206034041352, -0.61752507156231984, 0.11781009209903494, -0.30850424802461884, -0.30840749228810199, -0.22065980735578672],
                             [-0.09317706021637677, 0.039082843742602277, 0.57664775697850823, -0.26733622765939968, -0.012892860547845312, -0.011960961671691424, -0.30353485223712884, -0.033289420062152512, -0.161280034512499, -0.095695152619186055, 0.23537275080269252, 0.13293727505686354, 0.097751971806781621, -0.25227906079070889, -0.38065794004492487, -0.11978479679865478, 0.29280620795394113, 0.44295528749740831, -0.092496470153277832, 0.12406463432873208, -0.5266009327149529, 0.43840563956303458, 0.24872444312600092, 0.018664984106915399, 0.099288362517516993, 0.063795617253406184, 0.074007740999825475, -0.49107550446681542, 0.30240393720212128, 0.4898006922609901, 0.35963295884140362, 0.005974823398590989, 0.18749515632086999, -0.25988656914116498, -0.37275012745275993, -0.37659184278921942, 0.43065501780577792, 0.071924200904083274, 0.16779651489447786, -0.032251903767750979, 0.40625659190677366, -0.13442208027918209, 0.29302663372684462, -0.1125137225542473, -0.02086937058163333, -0.11641677168541603, -0.2130329643104219, -0.26410473989077038, 0.14654745765121829, -0.48341356803720464],
                             [0.12401687642137282, -0.19135555710373051, 0.069327997078502568, 0.26594424633710745, -0.026397669893682252, 0.12654832126723164, 0.036230558449922554, 0.14214835755724053, 0.25974189206874448, -0.14217431603198313, -0.18245630090338671, 0.53316701854147408, -0.041737285760626207, -0.27927772089935587, 0.15788163392778351, -0.05801234024761668, 0.035534807997242304, 0.6100718677857716, -0.064634471557748249, -0.20362475969022889, 0.51691419932478777, 0.24609667697289037, -0.57919827072621966, -0.4260829257213356, 0.058636137535501717, 0.35027442222741045, 0.26019918658521546, -0.12073021974959847, -0.17394898470511402, 0.49869125794679231, -0.38243034861298031, 0.11795297996500609, 0.22308993626754939, 0.46354352024714213, -0.064659836674002172, -0.071545725712627684, 0.20146548889761545, -0.30259963146001451, -0.53360296470316326, 0.020286725668477053, -0.14307288406865282, -0.28216538320234974, 0.20324744570140024, 0.021959271123084545, -0.57951187917713354, -0.23277190962922378, 0.24656995907557649, 0.024820534089660711, 0.36856456047619968, -0.070375137458784598],
                             [0.14758440622983204, -0.049848980153107153, 0.08877302377756538, -0.1356752280632165, 0.045589526886140305, -0.31049951480620108, -0.067603729171974991, -0.1681458357671469, -0.26489580649504268, -0.38035651412177129, -0.10058387084831724, -0.11333967672714892, 0.33350295204630481, -0.62859829548925039, -0.20229220901553077, 0.31964899747811365, 0.25079325089805948, -0.35533696743338167, -0.43622535011496949, 0.16366333470330655, 0.13441789312644883, -0.15251385678813728, 0.86821152970937587, -0.45320076245868657, 0.20250883388910426, -0.27562993071965286, -0.02944872793366423, 0.073796754139601531, -0.17255697730974087, -0.37788117246902286, -0.3775422285252007, -0.025682006961749361, -0.01191566762762007, -0.11076024543864667, 0.30796185772050066, 0.18309843543245077, -0.12255974157311086, -0.090756833970551315, 0.081335814624823449, -0.20540635712128424, -0.28861800268504756, -0.26547319409007319, -0.21587564977610738, -0.19381325929129239, -0.14814223805739904, -0.56533853828582814, 0.30842058435269842, 0.30886860893925105, 0.055375221825224821, -0.18684139176363931],
                             [0.30982997867968121, -0.049751804236297784, -0.28545176341299949, -0.063099089634081479, 0.34490739385461522, -0.52915535002186653, -0.34537690010503308, 0.30193137692052058, 0.3614249981299309, -0.20452279229842696, -0.025458837969400162, -0.069961015849976702, 0.13116441629753492, 0.4171665123377884, -0.1324797223322445, -0.2983984035034859, -0.11238180474586121, 0.13248276536351725, -0.40550855152619525, 0.07456115341911955, 0.07034139706799869, -0.44197998946288036, 0.59529292809831702, -0.0072259374173729764, 0.016101568926986064, 0.30600490951147891, 0.022117312643652971, 0.72689913448718724, 0.27086213831663414, 0.37928280073952664, -0.038681831656582462, -0.10292810845418222, 0.43658285917562206, -0.029140183674499179, -0.038257503768828541, 0.095603823888346678, 0.37526377337286526, -0.072018888139974035, 0.27256291272030753, 0.019364224254836818, -0.252084027520312, -0.20083543743192747, 0.56204507530349324, -0.44141997549251649, 0.17177313698084093, -0.19211839950842793, -0.15586062490437835, -0.059845164024179859, 0.024014550750422328, 0.090662946501839592],
                             [0.26962626991629401, 0.2197814487971757, -0.16269794345355149, 0.37724472874417264, 0.39257708304460492, 0.11044970574529869, -0.3086991954559275, -0.09766557917416134, -0.43853108148289316, -0.26216600273814755, -0.28513507568346402, 0.39482800001101465, -0.027826704531972238, -0.27401707165753869, 0.085164712411505694, 0.21878667081837203, 0.59731133654535928, -0.27667925562635959, 0.26140909401339468, 0.18534381669280559, 0.31864893035687292, -0.21688306214813957, -0.20332273200316148, -0.29947081361302891, 0.18692336107485774, 0.052672512443559215, 0.16429302117144437, 0.13638632993550814, 0.084979833180081926, 0.40548863209626684, 0.079942144708210275, 0.17415717751145143, 0.28416120363815783, -0.74041429044108997, -0.11284761665253368, 0.073365831615957236, 0.53386854601252076, 0.013346306897853294, -0.16863076912821762, 0.25212754345868887, 0.19399980257050262, -0.2024876321427769, -0.05971077613652491, 0.45830441781111031, -0.039928109653367808, 0.11603284036106318, 0.03946650608331595, 0.092543375320402604, -0.24950068898122579, 0.50312117787865496]],
                            [[-0.1517088910777061, 0.2335240776643793, -0.056473390179364036, 0.11136272985189928, -0.062821268414614551, 0.36668737606009832, 0.25770139213634746, -0.14818567744297748, 0.1700965495446547, 0.053518130681205388, -0.16524110277300386, -0.086342033274546662, -0.016864819704894032, -0.16412620163423294, 0.15798674644703975, 0.18077397586984989, 0.0052281007852749643, 0.24509029849791619, 0.048467012339236476, -0.08172492960410116, -0.17943967574092565, -0.1352758004507926, 0.24251927103876159, -0.076758303576447751, -0.41884085165497997, 0.15365531508156702, 0.11011756592324454, -0.16748285392911191, 0.12684856224742633, -0.31160518963387063, 0.33556037818422008, -0.0082526374297673399, 0.12056626944426894, -0.53709898073464757, -0.085207479482903817, -0.2067966150608779, 0.34968151917285223, 0.019920136721206308, 0.22266792643036584, -0.40471309100243991, -0.0048095560055664991, 0.028544602624661478, -0.031126208180118971, -0.041423309206549234, -0.026796008039269549, 0.11436420394539866, 0.12385976068206037, -0.092802666756506835, -0.16864893478274506, 0.42238341972448495],
                             [-0.39188953705826529, 0.056617786702859454, 0.18352474469770352, -0.034524843732623267, -0.22484312909917739, 0.26755852872594887, 0.17785994950297618, 0.2285624832056502, 0.0008311895848267495, 0.033210528153292167, 0.045676749772649211, -0.1201650073775737, -0.15912158964838818, 0.12419907134760307, 0.15209758199459916, 0.1939684158179594, -0.12620205679625959, 0.17825424069600226, 0.015830606188191702, 0.26011427185106006, 0.052911602320559747, -0.1436946920626922, 0.11677360161259136, -0.17705044572607814, 0.24631000873376779, -0.38107741746054319, -0.2996303412131488, 0.23727495671235554, 0.03259097752743409, -0.029704435495161687, 0.1664699329219485, -0.31085473918812395, -0.35941153172314649, 0.24591230579266765, 0.11336105911519007, -0.08138804317231832, 0.37332694092151747, -0.35104990345798165, 0.049314303642560398, -0.30717458907618622, 0.13976015189240962, -0.28975815623439505, 0.093696521923685855, 0.17271051671976917, 0.058647179895856168, 0.29580486073638002, -0.27049521121423564, 0.056390282731739655, -0.061979276494205947, -0.2868752896545177],
                             [-0.068398413418508344, -0.17291460384157517, -0.1693493702030478, -0.084738029957905095, -0.29531193535385636, 0.55599584594515739, 0.00781657913658379, 0.3079299730562719, -0.15146518879144139, 0.061899732858071183, -0.23617485791779402, 0.039540150961297066, -0.096286309758428029, -0.17715456460716528, 0.18947999648026476, -0.39202753715754829, -0.040569719072694146, 0.29296399171964793, -0.042001628954935762, -0.29389351548467763, 0.13351426649190554, -0.023371861586827702, 0.041133514377337241, 0.059807272123743448, 0.23642849867265003, 0.022010256056720866, 0.31240360231707615, 0.060815376658651318, 0.0024096330796251385, 0.30503054736001267, -0.2063517912023034, -0.046468597643931214, 0.457865079804121, 0.2378324122620866, 0.19485036572365483, -0.18986373874387621, 0.21019853560128454, -0.0074674377487179578, -0.64633626734601701, -0.01084087254864485, 0.26891496083838545, -0.15673673523122011, 0.14293810723437153, -0.2998565652980873, 0.022752090830851085, -0.090777378776548207, -0.064310475541114201, -0.15820093325520987, 0.047668155612579623, 0.20022367231036498],
                             [0.15743648053726431, 0.040207254318952994, 0.13047232350663204, 0.10609074622803749, 0.14828414185851899, 0.35724881217500104, 0.029238848833762501, -0.38807751592465556, 0.083446507555457378, 0.3206036350719822, 0.15069490678029454, 0.065042257883032473, -0.37323411649705496, 0.30248082484783945, -0.2861272162590866, -0.14619950778191632, 0.0042236929075920721, -0.083234447121587493, 0.39916628749441646, -0.05525335614574476, -0.0079441971606651878, 0.27719976763595772, -0.27573237615714735, 0.10071748205344679, -0.089257755902194799, -0.21201964555251193, 0.04117927874808635, 0.05935122737388477, -0.1220753484671568, 0.22605114768018181, -0.22030257971494974, -0.20317561046653224, 0.015898510586729864, -0.090049084901568641, -0.27973392844215306, 0.11978087089186409, 0.30733650244262328, 0.02541947230465573, 0.0061792692350216769, 0.10072055932766769, 0.1980550735567905, 0.083828062740125914, -0.087494198097174902, -0.096478518297171328, 0.27959211076036827, 0.035852380238533238, 0.033771899981014437, -0.13734367867685721, 0.28460287728414896, -0.064854678415649888],
                             [0.062103804410023361, -0.24027534803744061, -0.10552198227115775, 0.041094850956360104, 0.021957706273594012, 0.025071002207103506, 0.18788744125690088, -0.28139740089485787, -0.10101310502621703, -0.13293397430517445, 0.26032586392476703, -0.14474468314404795, 0.036226576390060286, 0.045975797860685425, -0.10246595613923422, 0.52341850063693973, -0.0015081081773849602, -0.11821460876711952, -0.042431011393440007, 0.24770072584911987, 0.082271896274905429, -0.31578422441009985, -0.013977047917315001, 0.17502893047876489, 0.23440631097646203, 0.52528212312668698, -0.27574612366620588, 0.11417962166194383, 0.32052024683957919, 0.10369314622570426, -0.25556683685178205, 0.051049069691383953, 0.025330873734667983, -0.15413197391183309, -0.322168330575205, -0.13442530322078444, 0.080556144228897328, 0.21298171453279763, -0.1613604666679021, 0.097255815715160926, 0.22748351993511626, -0.26858199698281976, -0.099633818379529226, -0.0057074543641016957, -0.46193324992179846, -0.31516246761945621, -0.27508198211124035, -0.11943304822450738, 0.066933280755278268, -0.092533911913772832],
                             [0.1673317400842432, -0.051386124968600927, -0.18610744983381877, 0.11977239856967467, 0.23971830291631016, 0.13303448791899783, 0.021412270551779803, -0.20154486659561488, 0.059681150686208571, -0.27215551899276902, 0.33026963628313849, 0.15380143877006244, 0.35770379389889334, -0.28032251785010132, 0.30527448101960108, 0.042401488655694361, -0.13852790154675618, -0.0086775000865658217, -0.13334600959200432, 0.060687988851450131, 0.10732658288000764, -0.022916742921205623, -0.14548689916860855, 0.29311054179678042, 0.35774623702293029, -0.14181104545632339, 0.062716814119542927, -0.049531283958547001, -0.18547382146727348, 0.0035457789084555923, -0.18136781893415974, 0.1129684212067691, 0.021141492275711191, -0.35391087099716678, 0.41918598203205681, -0.41382289444942982, 0.061711619972115814, -0.13385927680840187, 0.046777162508968288, 0.075290346938830174, 0.20088209973609406, 0.51435231876433218, 0.002180427739428694, -0.060566643759096747, -0.10347808085629097, 0.31795942739930194, -0.33874898764618289, 0.1750126028300627, 0.043580210803780398, 0.33352598773221048],
                             [-0.0035061387052985589, -0.16246282774126417, -0.075769767148388026, -0.023127512120488553, -0.26752984495330828, 0.18217039939271915, 0.015126528386125453, -0.22319427830393471, -0.063882278880961998, -0.30377171092683508, 0.056753275045675011, 0.23836058809609381, 0.11426122773948426, -0.074105266799428776, 0.03137704958584063, -0.067236600319962841, 0.11481081633589379, 0.17791185458041153, 0.041119159775094678, 0.00062962652854028217, 0.33750477814445118, 0.098434802728489035, 0.13372422882688167, -0.37810799846741039, -0.37588988761030473, 0.22014116090203581, 0.01475567411465396, 0.1014874457502285, 0.036162466700641653, 0.46367773995917427, 0.11384671268794477, -0.137825326165951, 0.058588809516631452, -0.21519107994908923, -0.0029946993541419484, -0.012137818074784004, 0.066895672844434359, -0.24567760772069722, 0.014819097264495741, -0.15566366786119373, -0.35715848813986067, 0.34292949449309917, -0.17983356111841309, 0.30820341641457993, 0.14710400247355457, 0.18217081362174364, -0.076907814537786917, 0.039720315849630698, -0.22132088121865345, -0.32285850645174674],
                             [0.12412495355873975, 0.16057528263687856, 0.28823066436010453, -0.46995316031200779, 0.04414870466024777, -0.08048888292013813, 0.150307656461869, 0.041315894186298538, 0.067920317665167249, -0.065081449323737092, -0.046222917589931828, -0.3781780371228109, -0.065509891963998826, -0.35280340218816636, 0.18106366355881331, -0.060599653146584088, -0.15597116693258428, 0.085204253163510282, 0.038462329987424, 0.37914237389880784, 0.20767722801065236, 0.18626245515920797, -0.18801270883310695, 0.042644985568691902, -0.045197332415226367, 0.36058343068628357, 0.1384039631830743, 0.30208757874265091, -0.12142421807963574, -0.15608492182308581, -0.063527500526284378, 0.0005493979508344707, 0.0048131804574801582, -0.026960147224600162, 0.24681729507039243, 0.37261890209379195, 0.29779106650773313, -0.0015608654195585305, -0.29984514955934638, -0.0061338936294796391, -0.029703056519024593, 0.24289353513153381, 0.056143125691414088, -0.23165091646568842, -0.26319949986127189, 0.38036205069212758, 0.46022594535464623, -0.068443192607205286, -0.021905988339525815, -0.39664620900978725],
                             [-0.17688171120635809, -0.35061691822319319, -0.053139998547095349, -0.62000693396994644, -0.25099251541884138, 0.032759687571748637, -0.054573230823622726, -0.12081436706145771, 0.15178892742979444, -0.11586475466000526, -0.31159302695673174, 0.30953065689404274, -0.017771452505793664, 0.24166203260460017, 0.13055589594832878, -0.051693871929513892, 0.26668388161874551, 0.014496727952257399, 0.10117424778151579, 0.052835294339049585, 0.01097229746640245, 0.094415834987977953, -0.10244867508270913, 0.17233205248889052, 0.010635571319097179, -0.15708830714430466, 0.036657489885926896, -0.081521860310505123, -0.14915552691909054, -0.28868238321261075, -0.17678942087432259, 0.064790712862862296, 0.25385557537424591, -0.040873727020468612, -0.014004503738455173, 0.087476979961981685, 0.13587026373268596, -0.044403656408930112, 0.35118837775235812, -0.034779716166190792, 0.24679221658661354, -0.07184567585240477, -0.1852989495243626, 0.18743804534373298, -0.40374871245776528, 0.039401614382741063, -0.30535593676867628, 0.35235018925732309, -0.21084898066381216, -0.086540203592776616],
                             [-0.077314605675554454, -0.1940511906049667, -0.1115058155866966, 0.093585708894807038, -0.014804456693822339, -0.11579356821947588, 0.028749061560259512, -0.13084637307094391, 0.14178622414225597, 0.0046978797670977866, 0.076945807957820966, 0.035515169989938825, -0.009826543966530165, 0.049107026187771172, 0.38492429177492754, 0.5248775493809722, 0.029612247646596528, -0.12987482803588923, -0.35719776266138847, -0.1715955186028558, -0.25201432343008745, 0.32168275152490755, 0.10713381051187001, -0.12744451020951686, 0.11829334836889417, -0.040569727531008577, -0.05559275431201998, 0.040635888771472894, -0.037546233274125949, 0.25982539527787052, -0.050646551333747986, 0.077674415474288827, 0.58015588647596539, -0.25672973529754317, 0.0012408765984215937, 0.38851426952364293, 0.115988518247156, 0.076234639400966434, 0.20528307733552661, 0.27884641871712396, 0.1585764354674753, -0.036619129904033564, 0.064550057774880487, 0.38021790012161766, 0.23035907979311557, 0.14954267793850581, 0.22716763711253457, -0.19409090195876005, 0.16426245915862916, -0.049529270913087627],
                             [0.09164224097123877, -0.13973801304120081, 0.011356316244503718, 0.034059658706017293, 0.07105754547616118, 0.12847452883754162, 0.14320320159427435, -0.12099716370205965, 0.26195636550196244, -0.06182019410232463, -0.08111672585568841, 0.32859253118296422, -0.13704617954348969, 0.020063244334499741, 0.23438087315807554, 0.39135568580567059, 0.20662779368703435, 0.07288310088242507, -0.033093886821239066, -0.16366001386712706, 0.22092601395912767, -0.39911421345618858, -0.18695485384012106, -0.037920135965010385, 0.19654283502428724, 0.33419227636270166, -0.365044988652933, 0.06912202460896219, -0.3537988752993938, -0.25653053857320457, -0.15683557932413378, -0.20076810900147751, 0.10825019095399888, 0.12725011485259632, 0.15555677547634894, -0.27500283032109196, 0.13029107668424422, -0.012060535092939121, 0.055944552395529923, -0.11028895815199481, 0.0098677637054514385, 0.027546136387114971, 0.19230603235003652, -0.44846513253313958, 0.32413674688740535, -0.24239530647222318, 0.30738037633006843, 0.2153212751680115, -0.42680036251789505, -0.22119350299048818],
                             [0.23558624501938522, 0.10327032186647861, -0.30475701866449251, -0.10100132445356019, 0.22164997060206082, 0.082349379615402826, -0.073127445372324004, -0.12242652912683163, 0.062251062551134988, 0.10612597884657882, -0.12410304210159884, 0.13089456707445582, -0.046092469088308427, -0.072103960395816707, -0.20521180842958775, -0.20051971453675949, -0.3048691565109668, -0.25845452312391742, -0.28045518115719559, 0.0009406355935567684, -0.10233682784737957, 0.058360495350607285, 0.081653859754489355, -0.056007834253811992, 0.1763784537422719, 0.089028831007656323, -0.39544626354276147, 0.24005421630342927, -0.15448904889969217, -0.03832953264574137, 0.37517328102377734, -0.048439902493220888, 0.2179550570517432, 0.35846470162547261, -0.27276632400475564, -0.13822114723895856, -0.063264569674714527, -0.14261326679324141, 0.048141337640975342, -0.084592031147741942, 0.2766863896013807, 0.10652235005447812, -0.20555188319841899, 0.10883133454109895, -0.23948257498134681, 0.057803164795070076, 0.22771962953818894, -0.071849403428200342, -0.38588555969005689, 0.032234175177299103],
                             [-0.14013027293905564, 0.29509800989739504, 0.043098695555890618, -0.032661251404163899, -0.22865298745306648, 0.11427393716926362, -0.0064947376496655249, 0.012037511857041905, -0.44049156011335605, 0.16106960316176391, 0.011386132612632008, 0.1645907446640188, 0.22607264935258586, -0.01309938440126332, -0.060064629046281778, -0.30335897345905211, 0.26509087698380268, 0.32440495757090837, 0.081364488624198872, 0.069548378474736661, -0.06559517003477891, -0.50702719351555259, 0.17451253515328374, 0.07553854856875411, 0.1749159733069888, -0.26201960428251114, -0.42803943916824327, 0.024049088531670211, 0.17882535692253715, -0.05176923819429629, -0.44319341083559277, 0.054173263338123737, -0.096703192238027036, -0.18075671819419509, -0.27876808557819116, 0.26434940786831018, -0.012782180909113079, -0.14875937245760379, -0.059198625409804272, 0.10488568336163145, 0.03962588046750988, 0.20090107681810676, -0.36950694976551368, 0.16076286852896909, 0.066240574680855105, 0.10820377474363239, 0.36193899804913388, -0.21178810933105716, -0.25612396670189647, 0.078990523129427753],
                             [0.13769396705226622, 0.40520528479619039, 0.02119992925513238, 0.45407493901329293, -0.076204856175681818, 0.33267166078484656, -0.087488318357085149, 0.010447614482107457, -0.21764101949660825, -0.28612105126789578, -0.359021144354634, -0.053512012311342408, -0.07867091990916697, -0.14983878051902486, 0.22645040070759145, -0.034968720780648332, 0.2024217209474389, 0.17060627850154128, -0.13181291111333338, 0.17122345675031217, -0.21139149516916486, 0.44909288880415515, -0.10961507155722203, 0.32280061386500769, -0.39625688595343528, 0.0159586107752972, -0.23416846465774399, -0.099906080021302149, -0.099872363992058621, 0.043963853089544973, -0.35284862131149675, -0.023542335988970237, -0.26604476216502349, 0.019160484951287127, -0.16306773499143035, -0.053166307921225772, -0.015373581546611857, 0.12117495307106388, 0.14955550749946775, -0.08908343308047445, -0.13397928031899445, -0.065532984659993188, 0.37300197251136741, 0.25840749820290865, -0.15736068144679258, 0.029070191351043828, -0.098963703443861545, -0.06544564915129894, 0.033748304804608525, -0.23755258383661526],
                             [-0.068413652141619277, -0.40989989471758437, -0.010729928370982012, 0.16484851035355172, 0.13523168781238212, -0.3710373624281661, -0.31120346823659317, -0.18196977125233441, -0.22763562970625462, -0.071906855206988862, 0.031603896069466585, -0.040081672965174342, 0.029436781807048087, -0.33004204934846892, -0.28095267139025426, 0.060493480767674856, -0.17453671433323351, 0.05427394752376944, 0.099437488666636223, -0.28287321488329331, -0.19863202068101049, 0.17156326746000641, 0.067964202877635882, 0.36135098293220075, 0.024440994843303143, 0.24530937300051822, 0.086026527015755389, 0.056647188744138641, 0.27449354634392448, -0.08669872557896334, -0.086301067011492275, -0.18471149875663623, -0.12473725492562043, -0.049235547294911725, 0.17159040063936506, 0.40130034643402718, 0.34953175237503697, -0.40953109113278124, 0.15060366012058471, -0.43315359055169889, -0.14422457440294512, -0.1619385584944702, 0.21046711923134531, 0.11940407831079748, 0.17270591463539148, -0.21792869899235695, 0.23763325630575149, 0.15641089381243689, -0.33136111966774062, 0.21043680879508569],
                             [-0.11712847726909037, 0.023487523577074582, -0.058294748892009161, 0.11232590760612331, -0.13420000124557357, 0.11438900056177927, 0.18519306015413761, 0.29652589807529056, 0.11894320527582423, -0.15262108831506327, 0.17240225778688059, 0.016221631359429535, 0.45425097222951449, -0.084417683324376297, 0.0070153856721265062, 0.079420606850628517, 0.013923857441395984, -0.23689335164396169, 0.17926744626864155, -0.13580092344107056, 0.40274733584415595, -0.038478653813334859, -0.46997375084394188, -0.067272314487212048, -0.134238412391261, -0.10019929842840175, 0.18036203552989302, -0.13944296119230176, -0.1716496468614398, 0.022420860231576311, 0.049296015970936628, -0.19327606966225414, 0.069507011419010334, 0.20460617367711534, -0.16322064190134711, 0.44695663162707588, 0.083245437116378482, 0.1810495658201772, -0.025027623683707916, -0.2427839506353508, 0.010497386604123929, -0.29933614363239802, 0.028408113238907157, 0.2867471902751938, -0.13952493265412605, 0.019628514140982697, -0.055311892984894258, -0.29942275347941144, -0.24225369095774824, 0.35130044415209755],
                             [0.14647158790794729, 0.046484292879263298, -0.27732081713476775, 0.034632509535551401, -0.49535599014898157, -0.40360187100639655, -0.21959567266272739, -0.089728403759638309, -0.13247831670493479, 0.24467692025645765, -0.10946322967263078, -0.13999434055635621, 0.056782376387615213, -0.1540107669617331, 0.14802590909789037, 0.17085616954932539, 0.22207585971211546, -0.34672751586716238, 0.30278594927371061, 0.42281844860038836, 0.057169835696858622, 0.192059762022047, -0.16006482546472844, 0.20430470379101484, 0.1401824205232062, -0.014918121854570938, 0.069170181791665633, 0.27010965281941235, 0.054521856319337716, -0.0062261296656226026, 0.053071172950451564, -0.062268709080710374, 0.20848127277185149, -0.27393730569481317, -0.076236068914887364, -0.35238558814339727, 0.33801418214479445, -0.30759355410595746, -0.16852040825443937, 0.26808584155184967, -0.1971553388135982, -0.24825209183791042, 0.18549851677941859, -0.2148059392143235, 0.14125615920104045, 0.11887739710026242, -0.04357749229649803, 0.16357153002876484, -0.27244319768546804, 0.13216185304543995],
                             [-0.078892571262086611, -0.18370285202577599, 0.062720702443127579, 0.43253522143860562, -0.010324650947831034, -0.084112937864950027, -0.21396352764260707, 0.085842247032454938, 0.036252202468875019, 0.28542543089058448, 0.37725348312874929, -0.13887931860236241, 0.04936198514570507, 0.11421855029869596, 0.12028388738013829, -0.26233933230072637, -0.020678271219077511, 0.15642945360637245, -0.12040679755751615, 0.12864238161216768, -0.31353481409875694, -0.41772872295025182, -0.06605287565067032, -0.058028584159952233, -0.18543257530011792, 0.26452824420135512, 0.41167101520883009, -0.4061288600121834, -0.36746419220612986, 0.35007775043069145, 0.11847746752270649, 0.11200183480447506, 0.20466731816383793, 0.15175147586990748, -0.1423913069823205, 0.10730434353016451, 0.26718114259308112, 0.15853193278988545, 0.018914213557134584, -0.14286166146863824, -0.082535475517747967, -0.18685442919920223, 0.093384906937251627, -0.060867389156916661, -0.20429837853764218, 0.2474874961057234, -0.0093310845274306269, 0.36800666352380407, -0.18030617709299074, -0.21931082359306003],
                             [-0.10996322839077194, 0.1840343653480421, -0.28744132144311108, -0.057247439332674462, -0.11800429537867749, -0.059301218502218672, 0.095255750008717457, -0.031737277436815925, -0.067375061878146209, -0.076469642755065764, -0.011373975793593456, -0.024460244185243424, -0.044893075911203568, 0.064503242377854625, -0.42803366410477472, 0.052897545488298219, 0.31440035564829666, -0.16011250675713573, 0.057687757739646683, 0.18809467707341224, -0.43542713243002606, 0.15825597978028508, -0.1619663521546266, -0.0075984317119928849, 0.24117397218558539, 0.023236983259169439, 0.27398431136355189, -0.55419129860072458, 0.10627412336468813, 0.072945211972707952, 0.25700302655825591, -0.16210590046024603, 0.20774991142845198, 0.19083360193060889, -0.048778932709890428, 0.070999758480241495, -0.19866392711495801, -0.26201122898522239, 0.11492532382792305, -0.1760081914885411, 0.29427327915431867, 0.29213510612338695, 0.21499698217054944, -0.1941453845640117, 0.10984033870583475, -0.050397298639269755, 0.13774518419004753, -0.066332984477330409, -0.024042426322793766, -0.1475162841089292],
                             [0.0028463940731600218, -0.25694964065535658, 0.23649741586232981, 0.0062690517809238094, -0.33719920834965061, 0.18949342315025602, -0.24401653497286366, 0.24815160532721006, 0.24118111642304249, 0.14246032666360758, 0.41879154598225088, 0.14226460866927057, 0.133633215415499, -0.17770253249313517, -0.19851353429191837, 0.17141790672190249, -0.03070942940842477, -0.22281228917972479, 0.27327372633096536, -0.056363173753849166, -0.47164194674162951, 0.072138597289814158, 0.11976561131136387, -0.31751904115312851, -0.15187368743815954, 0.16201990260200089, 0.096817439901581065, -0.095511894603137512, 0.037437463436216706, -0.32252056356040393, -0.2095225600170727, 0.140197450757166, -0.02801218964640886, 0.16103836293855761, -0.024925888927858068, -0.22812804255395808, 0.11802714561403946, -0.16004745451339475, -0.13541560053172502, 0.068630291183557485, 0.19562614091546277, 0.0065739528977104486, -0.025616184123606056, -0.00034542493120940515, 0.012664203659819257, 0.050789043730989872, 0.094077977412699187, -0.05953540850843702, 0.093120497323284701, -0.028898458345562025],
                             [-0.2350980899240496, 0.21232103877713929, -0.53213003069337372, -0.3515840265303683, 0.48956603784078651, -0.096450881528177032, -0.05411676183193237, 0.22892654119421718, -0.049833311806207634, -0.010503279833641958, 0.25261269280561105, 0.07359669978744357, 0.066640131388391838, -0.056655718511184318, 0.23355178222749112, -0.1424702422031888, -0.00050490806607405084, -0.045948439529524675, -0.11042317860830596, -0.16491285246032819, 0.059443847373779855, -0.088463839009780165, 0.38560193111992042, -0.037237791836851171, -0.71117715640222123, -0.33653280217673404, -0.010544744534271257, 0.012669350337348458, 0.17058643431797077, -0.06063347662188124, -0.18362558639474058, 0.18492918877487902, 0.0092746705183894794, -0.096188226147938413, -0.18738355727922645, -0.043403033965864007, 0.31057898239642179, 0.004155290505395314, 0.21509594692915518, 0.12562764274009011, 0.22390787418117925, 0.12799840804554422, 0.30324850368532719, -0.28388713718757685, 0.042230066877681362, -0.034014226127673006, -0.072076327331685605, -0.23402819182520274, -0.0012377339597938082, -0.23325487750584259],
                             [0.017359493207951337, -0.33616071645337237, 0.011974881574057773, 0.085833232696354983, -0.36653271227571466, 0.13720822220513876, 0.31846795479133794, -0.081776629880517343, 0.11022763153523263, 0.27632858645406633, -0.044769225464010909, 0.022639095904241516, -0.13501013250664018, -0.07884544078494729, 0.29731563013051382, -0.036824187638258482, -0.092616682511383025, -0.28323491208595775, -0.079178681162486969, -0.28778356867777533, 0.021202997708496128, 0.032592320672544042, 0.14434401961123172, 0.067821092447494485, -0.17995986065480019, -0.11663870026294329, -0.11328515673376283, -0.1955581695914542, 0.21019621892043999, 0.22464949264728706, 0.03180147074117215, -0.33998567130987734, -0.30796871153069905, -0.23530799613878034, -0.1749514205785524, 0.07663190141692118, -0.045887441654319752, 0.015782152797630448, -0.10660946717078811, 0.058762432364329598, 0.29803263407991237, 0.36349694290127121, 0.31523032820344371, 0.04848320576381205, -0.21871606855114412, -0.25617369581132204, 0.17599390421155767, 0.32693991369480802, -0.2334283153596412, -0.10369289635620557],
                             [-0.31780828412666612, -0.019403028153312532, -0.055084384251465723, -0.21124330352801554, 0.1581808984647001, 0.10798083126594878, -0.12990296196784046, 0.28829706820815254, 0.14233928669503182, -0.14571036398587153, 0.31359190606469445, -0.0046624771865146448, 0.22750581784167442, 0.17347679425268608, 0.25079683725908997, -0.083095919797781886, -0.082297307677364387, 0.16903664077946501, 0.080588395795004958, -0.32420134038266546, -0.17707581501323486, 0.22274643810427663, -0.065101581681880932, 0.10139189014536254, 0.27702315743974626, 0.33832383170618091, -0.2822807847220889, -0.081120426452030492, 0.1137993831945758, 0.11325305986146329, 0.11532136340057818, -0.089823003069418345, -0.19289691302932643, -0.44181689887968906, -0.62605305925153398, -0.02795644883645133, -0.34062316435971574, 0.0079180202710381949, -0.28215270681285143, 0.10781120425181413, 0.10261399260793741, -0.45360718590501858, 0.096268493965730506, 0.16961489214757097, 0.28128103775896962, 0.12680822208016646, 0.0019296972598849471, 0.091026754322941758, 0.10802975422985504, -0.012261775368049106],
                             [0.22876005930320356, -0.022316942606842347, 0.22562420975612346, -0.23608841410238804, 0.28177893780632507, -0.065575380600529809, 0.043258715368759769, 0.085443541341485046, 0.13382695325708602, 0.11633314525831417, -0.058855364471712197, 0.061972420552417987, 0.0080089233177934108, -0.65331704052826534, 0.1729499581479354, 0.35929670996623253, 0.23511976577536225, 0.25870657674831177, -0.21549044500880837, 0.035725319797757983, 0.18049639931060912, -0.11280889792427712, -0.080892970181148563, -0.035530450483257772, -0.13639550890437749, -0.31645743301162021, 0.05121210045343795, -0.3130856535782125, -0.16669414702725191, 0.31436217008116307, 0.026630124207898315, 0.0917214694027573, -0.11917345257192531, 0.058380582962312869, -0.31248271141173456, -0.21587782092215096, -0.16554333473631008, -0.15834954147999342, -0.25706707485913932, -0.065968400508361114, 0.02620381251913401, -0.33232651151566089, -0.16985258011615309, -0.19872693487943766, 0.036748756940636007, 0.052504958583633132, 0.095097380509681723, -0.04667773178098461, 0.27825495877906198, -0.065510377648234516],
                             [0.067456149102020177, -0.048250730384461947, 0.26923543334496447, 0.22707152713886455, 0.087419394440546597, -0.28889659837697329, 0.22551927302247937, 0.21447760527052734, -0.26736930560962485, -0.065033791734776539, 0.44680544754612433, 0.26354653710515713, -0.13963909285525825, -0.10844853374468377, -0.050262023307988547, 0.35754812591507729, -0.032997232264768646, 0.42271550063563301, 0.24888817952650305, 0.028318974715049787, 0.062874031688576748, 0.15009902627806149, 0.26599487138498651, 0.17397353179666333, -0.12818208406437184, -0.043659356225198384, -0.1373272682543068, 0.041300563892960065, -0.02824632028584273, -0.26008475779019335, 0.27870797608015241, -0.14513722483096206, 0.37352967140394544, -0.0037625905546505925, -0.082083288434803711, 0.1052507379270326, -0.0048034613629521512, 0.11495693350476781, -0.13578748062997706, 0.2282581943252803, 0.38674880176516435, 0.079689904571287995, -0.18761303281329642, -0.01765692183074152, 0.013581294199665268, -0.23759473678448881, -0.25409374445750449, 0.26572105072941865, -0.17137421149548193, -0.16489747857493034],
                             [-0.071728981526463106, 0.014278978716230935, -0.18994882392071749, 0.050098851676307676, -0.24553764216402404, 0.14590647691901421, -0.67634624430769796, -0.11517009283097226, 0.034297840918508224, 0.1808437052870295, -0.040175144867452578, 0.20889214300066525, -0.038877652643066134, -0.15108764080105994, -0.14379633503411132, 0.22170498725114632, -0.037286031905226835, 0.19910478155140462, -0.39130345300213076, -0.090727792272897026, 0.055349305542734498, 0.013178383217143935, -0.14995568734628884, 0.038875040952670983, 0.099961283447970645, -0.1629549530626685, 0.21059901706474535, -0.047611991983929243, 0.065355806491579488, -0.31732041338422667, 0.35534902299085025, -0.1837765322105121, -0.33762699751458058, 0.022847210383098462, 0.065576004914217514, 0.16017731017949596, -0.078199367151922522, 0.51214805206762692, -0.24532848264063215, 0.13542095769186652, 0.088024927937722444, -0.11936245607814733, 0.069198022032060463, 0.0097471267253959621, -0.0056766160655513558, 0.27936801093456065, -0.10547282538369496, -0.22888371363415361, 0.1562691435531392, -0.35151043426960099],
                             [-0.24789612551285928, -0.14417711081955212, 0.26402296459329061, 0.17058579438488103, 0.16310158211171982, 0.052057296510300721, -0.30146111436447542, -0.084496337900139384, -0.096181369239413769, -0.24344545258528888, 0.11125523393325945, 0.26302333378522796, 0.025540758231921586, 0.23507591789916699, 0.17503769860434895, -0.026647271072232102, 0.14030000993321767, -0.35986675757789666, 0.011291703070337918, 0.36719165913343499, 0.092815880935956621, 0.14010208827072779, 0.4095423974072126, 0.26744778243296602, 0.015610302284140176, -0.11411966241514346, 0.37476206948292068, 0.34654997283643063, -0.013365970402669874, 0.12538733937681204, -0.042319376592391544, 0.10423869613188563, 0.090570762736668115, 0.0052133987798554816, -0.16757639680483791, 0.069385909255016157, -0.13153148668187647, 0.27914654733674726, -0.17070843757825424, -0.57452765538582284, -0.031977292934981076, -0.0048922619171953667, 0.0018778514106995506, -0.065869330297183906, -0.06020352796638364, -0.0789394128846993, 0.44618385797907517, 0.16096601352646966, -0.2222132543856486, -0.062591541655820523],
                             [-0.16873874478033107, -0.23590394198963602, 0.10898967217871554, -0.13541499775744112, 0.083029042363337399, 0.10608995092468226, 0.099801278963837003, -0.08984922002108027, -0.51612881595195115, 0.01341260223467465, 0.20620771146381683, -0.082428911536865226, 0.018591930642447112, 0.13238352070742437, -0.23516074548269583, -0.024472818968510522, 0.11130181711941824, -0.29977042367828988, -0.26397186778894161, 0.11277197694577175, 0.088764312240118992, -0.030367671574657151, 0.091575072036014032, 0.13624189972592954, -0.31877058777862327, 0.0082710657696333217, 0.065310567996913135, -0.15044570744579114, -0.14269781458953459, -0.34769714821450798, -0.04010156318053465, -0.28814267986361319, 0.21920041771595528, 0.063322470027749961, 0.10339605113797484, -0.32279429562334877, -0.071824270978793764, 0.057195256997118013, -0.29714112866624742, 0.0085747544488853529, 0.16461148837823403, -0.28045484323331871, 0.1319310295898633, 0.36434779491304031, 0.22859333611609514, 0.15170128979974326, 0.23297082576091765, 0.066159485807392573, 0.26835302405615946, 0.16751862210272628],
                             [0.0081925236021589236, -0.18724036942232078, -0.27106825887849917, 0.091081135102477909, -0.068063304835773011, 0.18983129468743951, -0.20480641445690198, -0.33920340667371213, 0.022917469232544306, -0.0024383448205863752, -0.091971612562100236, -0.14408339545475971, -0.023405705528538295, -0.015401711702485244, 0.16786397198696534, 0.14213453296345616, 0.099213864111066044, 0.081214022863244612, 0.1624588675573361, 0.026776793923243315, 0.016942447103482278, 0.081901575240428473, 0.33062195818565349, -0.20209022748273375, -0.16861865383128535, 0.0077268491287335907, -0.44101786011600652, -0.43122419838782827, -0.23240194797053887, -0.1808772106056751, 0.16974423594776958, 0.081801805748041745, -0.12096468083147388, 0.13914067988997059, 0.0362683965699351, 0.59023807539329842, -0.084760948636681252, -0.13688781845693174, -0.55779396017445126, 0.11457470572814966, -0.17629763497101278, 0.040407611064848407, 0.087317638676805046, -0.13706117279211821, -0.13648396717337063, -0.018322057813950465, -0.11284228904684077, 0.076530026639794135, 0.034347541779684729, 0.27391513033228215],
                             [0.2064779374042211, -0.26511840145567189, -0.38778836811458062, 0.21208821659970281, -0.069273162891445056, -0.020442279347476486, 0.15502490922680193, 0.42937547880031224, 0.024428184848892739, 0.1692369032036638, -0.05922703787704868, -0.32239728355303754, -0.1334522085100365, -0.012469973175958009, -0.20888077904933197, -0.11028153437745877, 0.50046377757842497, 0.10971171680040169, -0.049801149632481605, 0.031469872243701069, -0.071096324431308339, -0.23900972266034773, -0.026298279499864928, -0.012345558155548979, -0.065965087210167292, -0.038618728185647523, -0.094716438714819884, 0.59893845726992556, -0.11036445286077495, 0.13230573849858085, -0.12970889919380432, 0.01814555738079356, -0.036787735888470202, -0.20533681311488752, 0.21086114755191768, 0.072906344167522133, -0.3946563458839854, -0.16853136549581976, -0.19853691739331583, -0.3161586809430294, 0.28506515943431288, -0.15718861538307347, 0.085640296890067358, 0.047807723351361457, -0.071364942931580924, 0.21781843234693693, 0.13209672393549973, -0.12731808487646901, 0.014936490352781757, -0.037870534794372794],
                             [0.056458359414803067, -0.0050772721133981518, 0.22384730630086419, -0.1386734578691971, -0.16710415670371206, 0.26035584142406559, 0.18323784939804294, 0.01820514099987721, 0.016567292085116737, -0.043939347331341812, 0.13978758999139496, 0.079875559856493389, -0.15475879184043603, -0.30467018991758366, -0.034687637025476677, -0.33728631907426793, 0.31463414884914309, -0.338133793936788, -0.17748613710904843, -0.02358067774382068, 0.013879367279391024, 0.0017575318307234021, 0.37276345385362847, 0.24049649422624045, 0.11355741352308536, 0.15387247502048843, -0.45817217654013087, -0.13565539024589154, -0.12187113191307311, 0.12401348075464301, 0.22693926139120929, 0.16433665113579085, -0.00091798817063013178, -0.06227997722483386, 0.1323764668992711, 0.19658764609719831, 0.11462932642037933, 0.19415849866210472, 0.22744949764540748, -0.13414639529583211, 0.028949241524257388, -0.079812161228104098, -0.085346426632365191, -0.10445896526245244, 0.35749316703977851, 0.12133304449978197, -0.24188231293479689, -0.11944124055780879, -0.081194967196623252, 0.043065757275704074],
                             [-0.013885839137394098, 0.013739532403618443, 0.11121101837232196, 0.038306294208098668, 0.086339477702505316, 0.25539788352021403, -0.085624302666925348, 0.25506464376851773, -0.066405987126099061, 0.17383331873971564, -0.131958692118333, -0.21676381271523121, 0.17017467877411668, 0.32226285481980582, -0.0024728991208495896, 0.027410383453572957, 0.19451070929492412, 0.073640925420132522, -0.37373353104270257, -0.064102562828794576, 0.23521636869380905, -0.050836456434714482, 0.064864219844980253, 0.22744188868195098, -0.11059708019146175, 0.036799226594740775, 0.20312817537018654, 0.18751896211106001, -0.34240856345702231, -0.062208436796856226, 0.29349999786959657, 0.2751364043134209, -0.21542623288154275, -0.055544297240404238, 0.023224594474732432, 0.22918698158240911, 0.31359435921882067, -0.49911737433411851, 0.069756191953968136, 0.24848956939275804, 0.24877744708024657, 0.24001867056116191, -0.32612837293290797, 0.16782454758397525, 0.092011247956871309, -0.44929955574385361, -0.049577904062581307, -0.024179206731768151, -0.10199240879696223, -0.15665690937897159],
                             [0.27659701698832756, 0.078468777357648331, 0.10398874771062031, 0.082893038661390722, 0.029360207096695637, -0.20233705273630534, -0.19743100135652253, -0.089009480360848187, -0.12142479606462678, -0.21745922629675621, 0.20160047222563623, -0.055594131515017971, -0.12248393891701316, 0.0067424396845771756, 0.68698144921117776, -0.103660715395682, 0.13903426770303012, -0.0094766601181481142, 0.23725100255030535, -0.32397904322614363, -0.027911324250788981, -0.17008240789761214, -0.42502561254108123, 0.055524356657647586, -0.10942594944529511, -0.070849375704811507, 0.10507445187431082, 0.046228929594644544, 0.38649918372633035, -0.21938822770903191, 0.065994000819399115, 0.09964895555972389, -0.0035250341804478579, 0.24939527908814305, 0.086330063872060991, 0.077653146875341666, -0.095798561205210658, -0.31946276342912228, -0.13825834525219657, -0.027010404353513776, 0.20900338747377328, -0.097389532460485553, -0.17614970386451942, 0.026073985742316341, 0.033987177084784402, 0.058063033938183906, -0.13220445855029406, -0.078846882624388728, 0.10133720006861997, 0.069081091250287149],
                             [-0.07991460774682338, 0.16018325493895136, -0.090865575414817906, 0.41097931533745213, 0.26633959438830801, 0.027180520251864154, 0.41920919273243723, -0.0040005236401053287, -0.17135525274024163, 0.1297608653558168, -0.21747363003005796, 0.51456126510648326, 0.16746451047970995, -0.065914956947180914, 0.16604552900408165, -0.2020523859744402, 0.075722182057714485, -0.21980432651059212, 0.47133408842837843, -0.15138809267141673, 0.19785148490333948, 0.215262986435036, 0.24067979106594095, 0.033665559389093387, 0.15040534165765776, 0.26287433934617943, 0.18306730656376219, 0.025363546224743586, 0.081742348559633027, -0.18384432936151762, 0.027441170531893325, -0.031053397835529475, -0.058749504622932734, -0.12007084076174239, 0.13313097196989659, 0.24118028365633973, 0.13140716866390473, -0.13975931971212788, 0.13829647300124326, -0.089379708831624036, 0.14670856340886582, -0.35550580980533275, -0.15755702255108994, 0.11932093252792932, -0.02828232691683099, 0.02048515539367499, 0.077015156392428868, 0.2634057152946695, 0.49687046996044215, -0.364243241615411],
                             [0.24321194609378763, -0.46491962680925913, -0.056656309795646495, 0.059291436205128806, -0.020504329562414637, -0.085185256077497357, 0.13588596084529292, -0.066305948566559914, 0.20252816949671543, 0.10498767346500387, 0.043004429702937233, -0.07472006203971282, 0.44371889889239352, -0.11901243425572532, 0.2698998478654468, -0.36502176763288896, 0.015676311893988069, 0.19142927584134867, 0.19951194180246806, -0.097605657818400318, -0.033992962174035954, -0.073882558570628476, 0.35408489905323881, 0.04050921167276833, 0.035111667092062433, -0.068321427779133997, -0.1786653900190637, -0.23370047352792278, -0.16490545503322396, -0.23554851436233396, 0.26142878453340651, -0.18138282477220971, 0.24450634410741798, -0.14618513461385851, -0.10450600532478402, -0.029486670022198569, 0.088767411270269256, -0.021304679950030464, -0.016845577895385613, -0.066669260219088741, -0.17626789226043565, 0.057439693303122277, 0.28503754564686168, -0.014123028596127242, -0.13820316887336745, -0.15871212813554825, 0.012892744935906818, -0.7097446312589093, 0.17728384986711423, -0.25389126640125698],
                             [0.8629876795433763, 0.13205811300416398, 0.16789704597573921, -0.25448437490842257, 0.056139098401132403, -0.043819837588820888, -0.20023242728509263, 0.25338525264392592, 0.059728839746487891, 0.30489801669347816, -0.028542829466455331, 0.010482369474940188, 0.24945059218771468, 0.38427121646296308, 0.098476823526632243, 0.023429680095184036, -0.076354255838137902, 0.06204693826074667, -0.22865305773109959, 0.16565742724665125, 0.1646724651418249, 0.11863396132701169, 0.11226896598655191, -0.15074811049785053, -0.01995538570888946, -0.0089328878195839949, 0.20033745448032839, -0.160863175705968, 0.2108775278226859, -0.058035755034496483, -0.24545649309507198, -0.27363785631696075, 0.04948488941151525, 0.0049249517966620622, -0.07306581263515359, 0.1523713590386985, 0.043053068399063636, 0.028175965907791135, -0.14851140576702104, -0.37260595351691239, -0.066697615016427417, -0.0008030797713732326, 0.1915546457611623, -0.071440909066234279, 0.14861215132355743, 0.19306328843172177, -0.30486739581401312, 0.13869393063935703, -0.039442811383521882, 0.047368456217781137],
                             [0.27567572062086826, 0.28562396968602843, 0.059819152317193404, -0.017021008443058691, 0.060827170706054853, -0.20146544489965226, 0.31398955291275188, -0.20445217355125708, 0.35978878672473341, -0.28656811229757528, 0.12409491092089568, 0.16555509605043683, -0.15486673900757694, 0.20477113572000435, -0.26335717143041959, -0.17276635700078979, -0.044012839076134604, 0.12920930178453266, -0.18700322586782064, 0.011185796029451162, 0.25266926548609081, -0.085889569610089159, 0.28558407974435723, 0.20140618462728174, 0.18109852293361645, -0.053528447711618396, 0.29568021287303503, -0.2297761087584074, -0.07955820963109593, -0.060918968852164787, 0.039305875071361483, 0.51732790477603585, -0.10572975734822168, 0.1053072703625289, -0.20794419961299468, -0.16418410195216396, 0.1029295021739083, -0.16619964442454152, -0.2020207388434247, 0.24475936604142384, 0.23767858735245906, -0.2631220804590006, 0.32553139911220086, 0.14818273840857152, 0.023791385527115658, 0.16244676990362794, 0.048670198156182273, -0.043600330136961761, -0.17038794714224165, 0.014548022358740502],
                             [0.159249456917712, 0.29274362225178191, -0.055482494419278813, -0.010975589191217591, -0.54327332732811839, -0.22956566698706993, -0.022138853804600782, -0.20099205292346917, -0.033929648521322547, -0.017961967792940584, -0.023157241479388996, -0.0082654434954568569, 0.56030628277208183, 0.17630777814575946, -0.19950139331255826, -0.16300275974312606, 0.16256273918786646, 0.40502441919705734, -0.084814611177416149, -0.06147403265955298, 0.0010695903166619593, 0.016286327332897286, -0.14295724285646783, 0.072405264331350347, -0.11330996244138176, -0.0026196737677915347, -0.0868133567438059, 0.25827416594153302, -0.042013336431300112, 0.22878809226597019, 0.22416620025940118, 0.080932401180621782, 0.036317796888059972, 0.22932431787521498, -0.12376509962282195, -0.068787704088436347, 0.21121618346636209, 0.025789988551913293, 0.23042192986335769, -0.083108589356013784, 0.34419699810256227, 0.0050827605695903128, 0.22492980012548341, -0.17988122705784329, -0.14258131918867115, -0.18026547237688889, 0.15534639485422602, 0.1945181125567278, 0.58157640171471214, 0.36848193557069209],
                             [-0.058868651170054187, -0.070262405236081571, 0.24491466792529121, 0.11609149439208599, 0.21429425391411827, -0.36170215640190956, 0.080295263921127069, 0.067634438586311629, 0.065679088254553236, -0.18407448952938149, -0.27928762518401912, 0.045824859621626642, -0.020421962993339666, 0.22513855270624455, 0.084218708834926437, -0.042388629608277384, 0.38429087355003838, -0.012029524771328147, -0.028541026648974076, -0.039487886757165393, 0.023847343769118359, 0.18449111650115979, 0.29593078590412403, -0.050318124716439011, -0.16077026057424443, 0.27949182560388058, 0.097630378554853403, -0.15379225859999757, -0.17926334210571904, 0.2516568914132839, -0.10422509079160387, -0.54180424381735581, -0.31125982064603031, 0.10319944394400463, -0.11997461528518402, -0.01133055662953739, 0.096433397696625345, -0.074702998905316953, 0.094101008239643458, 0.25535740643252625, 0.2712624920536244, -0.012425939884647384, -0.16308167202253895, -0.22342199008677452, -0.17364824550896538, 0.30975993156378823, -0.15450806673983278, -0.31961536459668055, 0.013268613791546098, 0.38621439825362947],
                             [0.16057511528188784, -0.40841871071582098, 0.037652348091721841, 0.25960282813274926, -0.12178431892179227, 0.20106568496605998, 0.03419917285707598, 0.14608286385481833, -0.16763561114353104, -0.43629561606374845, -0.14120866879885341, -0.48944312276829072, 0.12905502522764029, -0.022732090621460727, -0.11056663560579429, 0.04727862231503796, 0.20267881925312925, 0.0061568552642957616, 0.063023817665547224, -0.37347647597293943, 0.24566367987961424, -0.043968109984692819, 0.00087196610074383868, -0.22604278823191712, 0.15198636301365154, -0.34021827053438536, -0.23668494571212803, -0.20173326274667616, 0.063400799824650259, -0.075049601789686185, 0.03055027468020529, 0.056934963849966623, 0.25317114984790523, -0.060689357791699081, -0.12622436586099048, -0.0072947095043069919, 0.2978276224882857, 0.14318085971943059, -0.0072424194673014995, 0.076454887307954633, 0.012148636847371923, 0.09692961070187045, -0.35626171991812505, -0.39247612372238083, 0.040438855856825703, 0.31297727936125219, 0.13924778982539993, 0.23804267259108891, -0.069459694107865219, -0.21028961566547433],
                             [-0.17501015304519577, -0.17712750997853183, 0.016015162520897221, 0.15883180926464113, -0.13870512687818956, -0.052882715250391135, 0.010141140179073659, 0.36387026750725615, -0.13253712434938605, 0.22410228563633305, 0.10621485447435133, 0.34544321262079231, -0.31657572894401864, 0.35941145627825855, -0.096077040963817292, 0.022078922502708691, -0.19897898577162271, 0.070416053836135278, -0.1505814998087972, -0.018842360305924195, 0.58763060011031476, 0.22943233652928213, -0.11250509689231002, 0.12204531189979662, -0.029752757492702515, 0.01743019295505404, -0.090595670424660685, -0.089045751172324231, 0.20152440249668352, 0.0015349564875331567, 0.15452819986683297, 0.1492305918925052, 0.12727267351191326, 0.0053929259328841621, -0.22928793741008874, 0.0076796970540232226, 0.028499268318459513, -0.29601299888146609, 0.13351517030929211, -0.054871096170545947, -0.3084579266363387, 0.18692508708104005, 0.12017492856675518, -0.1812325003817094, -0.24709372611731409, 0.30782783154244203, 0.14629955920575624, -0.08121390747625154, 0.14198654466544328, 0.14254529743759589],
                             [0.017624839851325631, 0.25870785036364807, 0.3839633566937744, 0.03394631789200768, 0.21762809005444253, 0.18311366401843845, -0.078333413271341093, -0.13368893273774227, -0.11653300743366793, -0.19958270497355773, 0.025462401905339049, 0.083001445063943705, 0.00057160060396443512, -0.19159256002311442, -0.13713944832060124, 0.16170568980985475, 0.12936679359511741, -0.175796451065895, -0.20538101561246808, -0.26083984578294434, 0.011271184270164927, -0.33400905292978172, -0.097677181075261812, -0.39056979109373441, -0.015846959786048279, 0.0069239490552800128, 0.20313004382401703, 0.30600084039187397, -0.17049370310386916, -0.18911777427062942, -0.028933102382132262, -0.30111497260551062, 0.31057798775466799, -0.17947686175525984, -0.33215275215947948, 0.29710688943109187, -0.047801548429766923, -0.1067737261280841, 0.14164981339268001, 0.26615818759298521, -0.20128004728408216, 0.14538762156905702, 0.36586972424528347, 0.018544320930104021, -0.24839176539804078, -0.064334178359125319, -0.43338013481968357, 0.11743645546137531, 0.14414402493810163, 0.088735894931180503],
                             [-0.19944133287152566, 0.081765478862079036, 0.20054414041238838, 0.16778305607063201, 0.23203747453787277, -0.35996498451997233, -0.11820670562204408, 0.19637018778201903, 0.15509462250115053, -0.054012214241354883, -0.42562027539795066, 0.025123596778245067, -0.062400582398071759, 0.043743622278467939, -0.26051122953168249, -0.16926071074668786, -0.0045872236013185484, -0.22295321113937999, -0.22417270562376687, 0.11395712195320998, 0.029186537177712295, -0.21172207699025281, -0.26981655831696283, -0.062213413373282012, -0.14481424199857357, 0.10752469058846431, -0.39578702265475751, 0.01293411748463548, -0.058466381708882423, 0.026740940847124636, -0.021959169555532027, 0.15149393328911645, 0.053211922356917248, -0.19203757042653452, -0.15210357810251582, -0.13580463266466014, 0.43502489963606411, 0.1217217506445359, -0.38214978578743314, -0.28651877412513904, 0.21693104197445259, 0.25375206388689214, 0.098902826721995157, 0.20761765098230159, 0.15847005457721475, -0.1174820018484401, -0.10140645342497154, -0.15157244253070856, 0.10466714260962842, 0.012024193189825047],
                             [0.27143864948923391, 0.05131238952613329, 0.12259870555598043, -0.0014084838065136496, -0.24454368929207576, -0.024055527593537702, -0.11258710312895967, 0.12390708365407692, -0.11682993350164106, -0.35068913344406272, -0.405933686023144, 0.10293639271072572, -0.014630442625567237, -0.035011359200194325, -0.056918292772655081, 0.1850454115302102, -0.61593446533390928, -0.10681555550948274, 0.3203208808063997, 0.035334938336993429, -0.080296814573392911, -0.47923147208215799, 0.30967699310137276, 0.28260756686122357, -0.2132941015344704, 0.14573710270580148, 0.18909682950430298, -0.021022847207475867, -0.33553651940673362, 0.15177866919974101, -0.15150574973164507, -0.1022304987826258, 0.087320931987872136, -0.10396019156434165, -0.04409357486211677, 0.16428763959213319, -0.35114492243268974, -0.14562527598621663, 0.19334264638514478, 0.067300698521240709, 0.077240878134330102, 0.030464536999895885, -0.13931237863899312, -0.21866411766332303, 0.28598612735758994, 0.42139899234656036, -0.063571148596076071, 0.018731884684244155, 0.47638558714054935, -0.2006489054688067],
                             [0.036875447646448296, 0.072757436575842049, 0.16498849464115878, -0.10902009680955876, -0.10043836655799236, -0.1586535303030287, -0.16669176960901558, -0.04227373126383499, -0.63406809323550584, 0.14316351449746023, 0.0041407286617821011, -0.010064667503002807, -0.14666745693015826, 0.25648812732137838, 0.056636114986615402, 0.1528233694256283, -0.094077872213548075, -0.18855889279115112, 0.17531556645063415, -0.29389484155666934, 0.034295425872947406, 0.17095954242634201, -0.055809459331445849, -0.44162161433091779, 0.10997353473934501, -0.022931654473874109, 0.060383010527883953, -0.1062070551007093, -0.56553235129729174, 0.18565352722497433, -0.048792332667607421, 0.2816582225909201, -0.099359957428818674, -0.38621270369820321, -0.031618475921977814, -0.032259508762543576, 0.020553601875600999, -0.023391920549602548, 0.049278012112355753, -0.27248565226535726, 0.18454135663731197, -0.1614323909542886, 0.039110941784930006, -0.0084245596251987884, -0.27951786966022485, 0.050571713342359957, -0.079196101422712648, -0.38172382577693986, -0.23549426877092083, -0.10318772147613613],
                             [-0.54192827401675359, 0.12838360610387339, 0.32447754112188221, 0.096571400092301848, -0.046230931622047972, 0.17594865231398563, 0.032984889876381658, -0.5046990671722601, 0.12634586642199983, 0.43196439475790471, -0.14071624940758756, -0.50466552956875221, 0.21817636777293523, -0.14376254961031781, -0.17638864483722316, 0.00097205911400399629, -0.079825118972737641, 0.041034523029238504, 0.10692888879025271, -0.15726367391378993, 0.44635600421811161, 0.024369768999610519, 0.1576030906372313, 0.19300216916553753, -0.064298792414151373, 0.13810604972073826, 0.1150594858024742, -0.024389379663121803, 0.00043439360959486063, -0.029079531824719777, -0.28507651835402675, 0.29723573670218645, 0.20779125156667144, 0.30934431866802931, -0.10076423522223905, -0.056296781444767498, -0.30734621304916532, 0.011171647782691481, 0.11292056783366222, -0.12153138132826655, 0.22200520639025267, 0.34466104199032327, 0.21899916190108218, 0.21338610600712157, 0.13778286078738658, 0.31400674029524389, -0.15006348324594682, -0.021085408245391409, -0.29388149788220747, -0.15814086067464056],
                             [-0.15996426270580247, 0.301807713553849, -0.31352741101789511, 0.006171036920184985, -0.24208266426598368, -0.27725377166793236, -0.15222871568454696, 0.081462154907073175, 0.22472018477524308, 0.040184756006147203, 0.20876921323220932, -0.26203843819881589, -0.35839063188888071, -0.050277129882726278, 0.018481578788830728, -0.14771021053810951, -0.049365632149869568, 0.02402092286924213, -0.27013336930909648, -0.37630365304172803, 0.011811555145307826, -0.014623375756658695, 0.43417396401296776, 0.079891050842296529, 0.039827805808071541, 0.13353299620313241, 0.061372902582623887, -0.18009059077207518, -0.28685478359591282, -0.15738057254851748, -0.16586036663042128, -0.31644881186544654, 0.026762295960512047, 0.030726197286587435, -0.093107446410038416, -0.1314930729346378, 0.12060301579652191, -0.0018727731239078955, -0.11561743893447687, -0.29530394870537741, -0.2248188129550579, 0.045802725731663621, -0.40932414816016366, 0.032341885129252526, -0.075413369457057594, -0.25673174386621506, -0.14289463166146835, -0.0060415691132374646, 0.33251592542201902, 0.034621089941149139],
                             [0.082079087239248019, -0.00024794768565875817, -0.084240961836589204, 0.056756758907027499, 0.047958103506756868, 0.090386215799443337, -0.63250006130224945, 0.28438464233656524, 0.068847785417516488, -0.056053954814385236, -0.1620773732416543, -0.19189851706711972, -0.38850746906895656, -0.079953724395864428, -0.060005348690970885, 0.056212199387476423, 0.15597364521410986, 0.0051890293414744333, 0.45192249080176955, 0.10659998741729725, 0.43222000358283008, -0.18001208040127056, 0.078652248963601401, -0.10623740229730165, 0.13987533140143904, 0.2147265727441813, -0.043793019746940498, -0.3380551506697827, 0.0076303983790763814, 0.072692782101368522, 0.17457187049824083, -0.097173314321656587, 0.079108763804472321, 0.045710502970980713, 0.13807085997603233, -0.095066527648467944, -0.052151593389468322, 0.1977839012892689, 0.24506745422428131, -0.018103426608042567, 0.044633062820382201, -0.028847534066595602, 0.32825762218890414, 0.37478215203731796, -0.13109995310065223, -0.012161350861452666, 0.42411211488720435, 0.058978778186419362, 0.070688340326930971, 0.15099935816112103],
                             [0.051788788916339173, -0.36212845216364653, -0.26731899590126595, 0.057043139906044649, 0.049873608674291081, -0.055222632018630181, 0.33906813049939555, 0.16664104037671282, -0.18746026815726655, -0.047849221290028936, -0.18372216625535259, -0.13980911627520029, -0.072232320154271196, -0.14053171174608547, 0.26869667373860939, -0.050106201144748327, 0.23089750961024683, 0.15458703796293344, 0.28296708815428384, 0.1320300646730376, -0.10891978800670915, -0.0095008816205022495, 0.039060418055633428, -0.14419920847959289, 0.23942719180840452, 0.20813545707826142, 0.13980837265897322, 0.1127795757495586, -0.018688257002122965, -0.11787948850805012, -0.043719707876260797, 0.24051001681718795, -0.35747839415159155, 0.30258689808738476, -0.56590694081681936, 0.14186686464655457, 0.10363857290314114, 0.48146858389400299, 0.13512136899146621, -0.075594324618421971, -0.072777933182589391, 0.57410376160694343, 0.056545969705370125, 0.20253855966533443, 0.25675801287399047, 0.14183305153517622, -0.026637429340279319, -0.047344890061611494, 0.1177218419557582, 0.20575296008591362],
                             [0.16592111097975618, 0.29634740667615028, 0.079609291224210496, -0.15865748386115336, 0.095032720378103813, 0.014328181329763094, 0.090888949220143858, 0.14301340739933438, 0.044429333574099068, 0.041434844743754154, -0.23397242984880012, 0.034668575050378944, 0.026881597229196211, 0.20161224346700066, 0.0089551674447957696, 0.46468055478430875, 0.26474391565572414, -0.087596116080633293, 0.48750520717834844, -0.59261890381233484, -0.078615217219223543, -0.25761328792403443, 0.15370836431050119, 0.4142990171433481, -0.0090059410889151859, -0.035249462650072977, -0.036930249399183178, -0.034591373360375162, 0.034204099374288081, 0.23719789013213213, 0.17926348580100157, 0.031451442594052234, -0.09099800250492146, 0.2711583672226302, 0.062361466593001513, -0.074274158953325842, 0.083924448647939215, 0.022381114187253491, -0.10348775852476008, 0.12395869608790366, -0.29046551793772907, 0.29020381927705813, 0.092649397422291849, 0.11770197230303822, -0.29717498506316925, 0.32587451368361986, -0.041554856461894815, 0.054508520956627678, -0.0090794326158315092, -0.18992119423492354]],
                            [[0.41994722334130036, 0.25019127961513932, -0.63224070013454059, -0.18013320431308583, -0.1723821509070749, -0.043450664260811109, 0.075027122761942455, 0.25724313776163621, 0.064050115899025026, -0.1646195014073889, -0.019124702876367042, 0.0080503868051220173, -0.043112701623787622, -0.12402348198752193, -0.078626772642062553, 0.0031013708687060992, -0.19034045710003675, -0.16712947930541838, -0.002120519058383878, 0.26877497179876741, -0.095386906386584064, 0.0081274758191807843, -0.20953305878016823, 0.29785463011502855, -0.38116833601654526, -0.32595282760324673, 0.025277596826235114, 0.12606610453201289, -0.30444895311776238, -0.32787141258099989, -0.038925526097554737, -0.0058860847889152038, 0.69067965227526629, -0.30214709639787751, -0.0087160883513953038, -0.34829303239858544, -0.31152053547856451, -0.34572221672903097, 0.063772287821659224, 0.067267317158278786, -0.15092011132584557, 0.27087072991297445, -0.0001679532620968982, -0.21153134392454473, -0.10041035852990741, -0.45710468669653948, -0.30858078451769572, -0.078582699265733913, 0.4317321545390439, 0.19241302330733076],
                             [0.41320753922841763, 0.023699242645474617, 0.39393909373726183, -0.07519477594917405, -0.0085215866554675303, 0.33562700130189366, -0.19135237881284295, -0.44894573489474371, 0.28886278455190917, 0.050248011146696456, -0.23870926751843058, 0.16884150561938674, -0.19929238756956552, 0.29236549378214627, -0.074985658219437173, -0.32200362807064292, -0.14145841577652324, -0.1319512725843994, 0.20239392935160611, -0.095591885319468314, 0.29683731948482001, -0.34419911692691973, -0.44265846960349697, -0.11488562033588515, -0.25725477990322831, -0.28962038307284704, 0.35373031928864224, -0.17170802909466146, 0.054233525016298814, -0.18473038780003956, 0.15767162060748866, 0.091345538291931858, -0.21937035526476817, -0.16577990081718133, 0.38993688385839226, -0.57171423421241441, -0.1928428665459416, 0.41487454209943264, -0.33652726065701466, 0.095221853072674861, 0.11811366604367467, 0.037160726727456364, -0.070731665832918011, 0.0072613229597971798, 0.32898092792257294, 0.29540860414170284, -0.059603795336365187, 0.068129530739790931, 0.19000096332111635, -0.081926530527192343],
                             [0.37440041248269434, 0.0070337920578573809, -0.071031472237009771, -0.078892700672131333, 0.0036850585438594824, 0.070779922731531261, 0.08804811183596814, 0.18625854382698825, -0.31523635646879555, 0.44690171903827092, 0.27526686219771201, 0.37208744991631582, 0.11075641538715178, -0.20615913887091211, 0.43550787075681097, 0.26949867431481356, 0.03129365092853769, 0.078686808200680483, 0.032515147721961429, 0.23030557127246223, -0.30353228184149217, 0.34214145940303531, -0.39145163347904849, -0.0089828201103204653, -0.37312955385781205, -0.27379439713940962, -0.049176066163009839, 0.30967274956663327, -0.067783661361317082, -0.39944005372982394, -0.010286813665589561, -0.24571562789202989, 0.21017483337106999, -0.055399095831190716, -0.16693916460974942, 0.20989451061417566, -0.16964304747251113, 0.13053920624740509, 0.24882328750309335, 0.35522977396613814, 0.14465936314003547, 0.35604307907958704, -0.18144058053790454, 0.067075282480387452, 0.17981931693632711, 0.23566606611336649, 0.05297273797684502, 0.00073905554571337159, 0.34481996848067531, -0.46993921360453156],
                             [-0.36335909432874747, -0.099729326314102459, 0.21365897754676319, 0.093771695126585342, 0.07425630571043644, -0.0197439507269506, -0.22168411977179195, -0.02421732866471981, -0.0078750711681231413, -0.031735438020671497, 0.16710151698111717, 0.281023629284326, 0.24570483480654084, -0.10880465632039886, -0.033438129818910388, 0.41527330527558048, 0.26609524063880557, 0.074980984703584094, 0.24834332257856812, 0.18257086926666505, -0.46425688552238492, 0.076020157195561683, 0.40000372930486106, 0.11692472173109804, -0.038338148748143515, -0.22188254001164306, -0.11329614051845151, -0.26047361000249364, -0.29605556198511718, -0.35152504817071828, 0.22267246983495095, 0.045141044639103879, -0.24722930362282577, 0.2691231842759062, 0.30222179062771509, -0.37135693630724859, 0.068932486602593532, -0.077336413471390461, 0.084342030093364398, 0.053706327062279, -0.27647688105913026, 0.066764411516202424, 0.10056832653069557, 0.13148745458937547, -0.38628878158734764, 0.2426763685849547, 0.21085311459775596, 0.078162297527765226, 0.011980036913081688, 0.01683708073767547],
                             [0.10953074341783282, 0.214044731931229, 0.20563229235021152, 0.15256195162785322, 0.096073191732432131, -0.49742594345824331, -0.089392258611541042, -0.024057622140956691, 0.34074212539221799, 0.13902592670396086, 0.18776226097822191, 0.39175323355374436, 0.17176049093212609, 0.30388568760811663, 0.060155055353156447, -0.54427543521805777, 0.010789959200103358, 0.27544746733282949, 0.21306651287349995, -0.19247074764600836, 0.30481268262825312, -0.15191133034025547, -0.35479066498160128, -0.1445614275593391, 0.33566812368911197, -0.31660130378163698, 0.24907208028441868, -0.086577219154096136, -0.047137596284347168, 0.14848679037927176, -0.16321447823962429, 0.20061270966791434, 0.31073821923014133, -0.2558212109220202, -0.24149463663412746, 0.047937837484309749, -0.051431959065536013, -0.24763999664529807, 0.10131719388890996, 0.0079602708572264619, 0.22454108506183493, -0.22498628476890553, 0.23118550331264764, 0.084961485006673124, -0.14416889026184232, -0.18837743969451984, 0.55942465767970684, 0.14426365773529959, -0.25258192822531556, -0.11561840693705558],
                             [0.25233529392655024, 0.22556405996825271, -0.13991862428723345, -0.42120919180650368, -0.31779202933507111, -0.19299998771290564, -0.19962379947418443, -0.24958613918503919, 0.13418751839097134, 0.3811904247777933, -0.12351069200203298, -0.14785085192206637, -0.14928899884284028, -0.50919514150380041, 0.1347643332676339, -0.28626907580826033, 0.22020356557296988, -0.19855510129865611, -0.06513894416990236, -0.29409891017307221, 0.17134823642113001, 0.10021671886599393, -0.076653469093025006, -0.13221937359251612, -0.0040791763258858152, 0.039772921864177468, -0.59273557176201297, 0.093069180211290917, -0.21546458090971526, 0.22781019532315105, -0.16243930737080581, -0.15619572434902421, -0.41460716370948586, 0.28780250451635786, 0.25669625341479918, -0.17854516922921659, -0.024448441953692238, 0.028909436847388878, -0.10234450844585287, 0.036364922494882171, 0.29604855729824459, 0.21973785129929041, 0.03413235754899914, 0.2954416956538547, 0.13084334881972984, -0.018205645093068948, 0.19027822376289658, -0.17139345846310572, -0.29715693548530381, -0.13837875524738355],
                             [-0.45249590538318157, -0.45549137306085985, -0.3954587003708529, -0.050757297745772603, 0.20997606652505113, 0.12236031870024919, -0.063288503316421774, -0.62059690177825177, 0.15834756961722976, 0.45435574357756248, -0.3039530680575776, -0.11954579009959693, 0.090457466222794269, 0.36884617621840826, -0.031304701642351836, -0.08630690433059493, 0.14953042344457607, -0.062129035616866252, 0.014052148769040967, -0.15350872233458993, 0.26076275324029241, 0.11751745819144405, -0.36110875234647355, 0.039130888898516403, 0.095389719672873435, -0.38613507756594595, 0.2234128782070568, 0.4546112429104634, 0.19929625994911151, 0.33131001100600727, -0.055676110716584251, -0.018462245961168577, 0.30680412764581372, 0.22628819933674488, -0.047897256174306638, 0.21369654534541191, 0.20056408586836255, -0.15441800139452355, -0.0050969996837749929, -0.27070649730592344, -0.10991518586193702, 0.11586102402401312, 0.14712740359692289, -0.14542938692232477, -0.50131795435731141, 0.56385273820703274, 0.16594794148114564, -0.0065844273218437239, 0.28063252406732353, 0.27992616423281608],
                             [0.21067483654612001, -0.52624168437626595, -0.2124217353494767, -0.11932625661242789, -0.00046252211377714042, 0.30993150800662322, -0.14484300418006715, 0.18300606971630276, 0.41764809725580859, -0.041316058352762107, 0.097830205936422304, -0.014385623908017443, 0.70894956617451976, -0.5603610532863541, 0.30163862885454568, 0.23930067981919764, 0.19447614683404274, -0.022386857260382378, -0.14383880909270672, -0.11419461562047568, -0.028319279955196626, -0.23077524587549675, -0.1094135095787836, -0.28605119912351312, -0.0029648595065725272, -0.22901188413049717, 0.32263307489174897, -0.026667614980393054, 0.14884812997949531, 0.032862364313882841, 0.053439759553574419, 0.30980609226349631, -0.093838446075408921, 0.082408839249860949, -0.56124794873884065, -0.0797699638499762, 0.10879628309759584, -0.17366801543641133, -0.32466760361449887, 0.26355036960225714, 0.23674117379866988, -0.61549206899576003, -0.10212783947898756, 0.18334338504249162, 0.056949884974404889, 0.020561568106349907, -0.10927661914302074, -0.11475312624614011, 0.14888847072961753, 0.16063044813592672],
                             [0.40330243012405692, 0.060322579539801018, -0.064957747088871948, 0.37775995912432886, 0.051133024165674987, -0.028753590145508795, -0.09619491977740352, 0.34555015889402568, 0.095258419840217323, 0.11369717497479785, 0.01008070849122493, 0.25520953890223846, -0.3469092715377291, 0.12569728203626612, 0.056275533699973859, -0.032635604040002465, -0.055385360084695315, -0.32069135402889687, -0.23114410989684106, 0.25571754705730149, 0.32661857650521869, -0.32464258146736052, -0.015906318118878243, -0.4823150751295347, 0.13080096403741082, -0.032072184013794552, 0.008120555702217697, 0.11420593978870333, -0.024185069969515426, -0.27874300476394437, -0.10933209230985515, 0.25786579894977896, 0.093169633575996946, 0.47740932028536376, -0.22488241352254953, 0.087280720177839874, 0.2534364103877384, -0.10566086435353936, -0.061854941157415952, 0.028648002474522281, -0.63931923244328548, 0.2548848631474977, -0.50268410072192726, 0.066741304964791082, -0.21022336792587298, -0.22251157731134527, 0.13482923416822148, 0.31025438426337865, -0.18038705102258359, -0.042297408278397501],
                             [-0.16298185042295621, 0.09118461500463243, 0.19335206549257206, -0.33666103977634571, 0.26122559150760527, -0.19916554296506297, 0.14241586501463746, 0.087572503348134101, 0.3610268048820533, 0.024981980504611343, -0.19666443264774144, -0.085913010489542738, -0.28303475009149681, -0.28455151614376367, 0.23302214833756332, 0.23539958169354297, -0.64618543015297736, 0.55854969199336513, -0.32897012615321691, -0.28229731201381714, 0.0084816826103402115, 0.24413607460270448, 0.11344417216056753, -0.32615314777828236, -0.18943803320715477, -0.51667645376190263, 0.20844363604345767, 0.25308085468576108, -0.1178481162564762, 0.12335908958692435, 0.10453155607965049, 0.078339584250260802, 0.05304393323027088, -0.18626289769076418, 0.082696222685376422, -0.035914836546920348, -0.6111560678347866, 0.011173134898078052, 0.11318497863857239, 0.07577956641796571, 0.22376714226609731, 0.15207796451985589, -0.15071902218889169, 0.12438168021330948, 0.18181671184793025, 0.37317758845668686, -0.17794996684430647, -0.036558711716828611, -0.36027493222963913, 0.42765803820192594],
                             [-0.20741098310998912, 0.15226947322174797, 0.12539456995651921, 0.082585013935699919, -0.43412093359463544, 0.23628448393964516, -0.1588523749883762, 0.016678815080862448, 0.29313501123943686, 0.024790098760086424, -0.02499647664910197, 0.37527428505351978, -0.24712966029297673, -0.52198741853329422, -0.058878293270511514, -0.0036256334600301976, -0.42862949078129314, -0.034846423821522185, -0.12814635491608362, -0.04522051657592506, 0.025368655401776595, 0.84090227394529793, -0.084160750749271082, 0.11160649198251255, 0.18244468956398444, 0.083178186310032765, -0.30358719411352925, -0.23086120911242131, -0.35590599532166323, -0.066072751311578415, 0.0434596842130981, 0.093633611669144245, 0.39558596141775049, -0.208151872649738, -0.24413113977612355, -0.018086597814023678, 0.18924667916120078, 0.38424252991669222, -0.20741901780923394, 0.15874976469571683, -0.29658487323967803, -0.19045767516455014, -0.061577834610399743, -0.1260604206729074, -0.019884919883412906, -0.0038067152009140307, -0.028858902678193288, -0.42852146752399739, -0.043929420799328281, 0.30654284075949961],
                             [0.03551336501809578, 0.00022814977166704664, -0.079545254335243662, -0.37577021337690464, -0.23609341436406503, 0.22453426721335229, 0.11638505871715567, 0.21196412183247745, 0.036250605598608307, 0.010664526324207427, -0.22442497119119512, 0.071222985600989497, -0.095034865597801763, 0.37900285966141189, 0.20291339845990575, 0.50753407380024063, 0.29639531146340464, -0.0085764433151259076, 0.09338294406054197, -0.25891309146027214, -0.36081496980643035, -0.042618392403451826, -0.059141683782691155, 0.36342844185744444, 0.24322095957697257, -0.26786618772105736, 0.22762640869957404, 0.087166396021785414, 0.24816150644469789, -0.02123467624978945, -0.41608050450844625, -0.2264141790117728, 0.13469831280573732, 0.41488174388111049, -0.1071000833047225, -0.086620017340120509, 0.013431396021382006, 0.43580946655659158, -0.42089154707542309, -0.072127854172689701, -0.039172688537723585, -0.11606816803565208, 0.38909413131301673, 0.072085982947480975, 0.072062987687080179, -0.39031535373727033, 0.21591310243636874, 0.013533239535988759, -0.31351969892313042, -0.09214617036493776],
                             [0.15743333163395395, 0.20317347621963303, -0.16581015706647684, 0.26133464761630154, 0.2005992729028736, 0.051555699964980592, -0.15130208260932468, -0.12922822461205694, 0.39693885002496831, -0.17785670506851939, 0.28536915230268239, 0.059078300227714625, -0.05500201883485404, 0.19938283860669723, 0.50375084641723933, -0.15714797722745835, 0.11570765017563527, 0.11780904017257199, -0.15709019031936056, 0.0017493169616589425, 0.18764976322151877, 0.13054595140725417, 0.10712217740940706, 0.51706732639307451, -0.4694589805958842, 0.15722659975107031, -0.03516351485274876, 0.10835345836115692, 0.23980751518237106, -0.0030042545391094164, 0.3370105992868479, 0.23847236080841624, -0.13223344457445366, -0.10914708933840517, 0.13420178951245629, -0.047325562940601133, 0.16560978727894554, -0.17753303521845321, 0.21724436449675893, -0.19377118781716376, -0.11841138831105846, -0.097561814320207427, 0.16990860974234645, -0.17402737401891785, -0.083337411387490387, 0.12501301769364898, -0.57834739552221293, 0.14170743812334721, -0.37074377674221165, -0.25912249237296109],
                             [0.1709031268531219, -0.21480792269815729, -0.037020073636434447, 0.55619404470177447, -0.41605400706574464, -0.053612651585761596, -0.10231495717472998, 0.56384824179775739, -0.36786272979128676, -0.26375941867571578, -0.17378747249070747, 0.23660412359038827, 0.39671404795347665, -0.17663311563790288, -0.077346565268135714, 0.42998284077828464, 0.28261943590624755, -0.093951819283678226, 0.15302957741085546, 0.21647723370130484, -0.44736021561025485, 0.12678892089958332, -0.11843685042910536, -0.28339567151764772, 0.44380416391618899, -0.072617400546940367, 0.12581145813388339, 0.45671438086343508, -0.1347931945551033, 0.37238505467054822, -0.12211107639472121, -0.050488348971901437, -0.00055583592372715333, -0.10617639562995927, -0.052647880993132896, -0.53736105620401453, 0.035552990860889755, -0.0048524885438758145, -0.21308423340071092, 0.11242673057605983, 0.28634047027755793, -0.12583997255221896, -0.27944674102500516, -0.16073889296907423, -0.36502446582657661, 0.53554111487413469, -0.29577530063892205, -0.020414088532184155, -0.68668838291108603, -0.12532107798109293],
                             [0.25726859038410854, 0.035983246940299342, 0.64383272246144008, -0.077013208699108077, -0.054657925843762126, 0.21040615392803783, 0.16642264223473927, -0.10685750055703681, 0.043615469052067861, -0.31707072762628868, -0.012376425173671948, 0.033222895126107009, -0.027540085646244088, -0.075542834784883023, 0.54352660496985961, 0.12249711555171985, -0.07479604339652246, 0.057477690433110892, 0.012552794375486788, 0.039160940499253893, 0.13320374679213984, -0.1606614041493015, 0.30068360623233104, 0.29443516234996242, 0.3248931709149942, 0.052041945576683117, 0.24771420610909403, -0.051041963785187362, -0.36189452154123569, -0.13453814680224011, -0.05027247233803353, -0.5088242325523501, 0.12634591027682157, 0.25244163393013586, 0.07758391387865067, -0.49847558908491629, -0.12018927408414602, -0.35430436352522138, -0.10330155325633879, -0.49109802956692367, -0.096585174483159203, 0.39137355176134025, -0.13894877226600658, -0.35206724086997165, 0.37890432931436935, 0.29315508437395166, 0.42456738819093798, -0.43603301899919922, 0.13030913450563411, 0.086277067200619673],
                             [-0.12009195290383309, 0.07825663671278224, -0.18885271956787428, 0.026832115332680852, -0.054962945346890377, -0.063330061832922779, -0.53199805539683287, 0.20511270582748778, -0.40124861226309538, -0.049881013207868634, 0.073226456765164219, -0.064142335078488003, 0.17742554093817378, 0.17081785717093514, 0.16995357482396284, 0.417536761817346, 0.25634260184158636, -0.12008408143832069, -0.35895675988101822, -0.52005359317651578, 0.1173029776981363, 0.10475695683099202, -0.34332208409612414, 0.088779162190155178, -0.17423325668996847, 0.10904991355915447, -0.0087396954402338498, 0.14493116792150132, -0.28120683990279638, -0.39848017326022495, 0.2707621928561717, -0.084654206369797896, -0.3235047250405732, 0.055271556005672538, -0.1444319155423317, 0.20476123114462996, -0.11558056958226225, 0.15004688641058461, -0.28937440238345552, 0.09704785644216625, 0.11512114100988108, 0.3049654534057733, -0.2257329874716503, -0.31010562122680013, -0.10102268085367574, -0.20819835328145922, 0.27323156201193749, 0.0080780979062031258, -0.11964981259491918, 0.24934079494202285],
                             [-0.13303568512926425, -0.34854159960752279, -0.20975664966387539, 0.25571812158794105, 0.40697226152260435, -0.06666288571629328, -0.055301156669424423, 0.21882716787901041, 0.21178419510167884, -0.25946839214354839, 0.29483938587478903, -0.05577191461736461, 0.12929402590533756, -0.1071138852975356, 0.10238571934977578, -0.012620297518970976, 0.42193159700519167, -0.4789745464247448, -0.45002929599529573, 0.25850162198517174, 0.086133345008733472, 0.017485623549093107, -0.1646189376792252, -0.25261816191414477, 0.37151524810326686, -0.096720804439197061, 0.10671604031157257, -0.050164426778085691, 0.21228142524103391, -0.27229926680929412, 0.1626581471912544, -0.32555302228350708, 0.43090682329070207, 0.10116638359500814, 0.28759500403490906, -0.45632419635251115, -0.026031730040954291, 0.23814480622279016, 0.1119442865779673, 0.30543788145350009, 0.29624889700253976, 0.24853968751580349, 0.1339632660847522, 0.095397080099523635, 0.059808283654884907, -0.094591359040301817, -0.41127188718756502, 0.086437530046159006, 0.047338386014164659, 0.09328773965301447],
                             [0.10092542677067003, 0.069696285664956059, 0.47607212764044965, 0.082710886100874112, 0.2351999344444341, -0.010025725554628159, 0.16530634864651994, 0.15027617884097644, 0.27810467829329621, -0.41266641039339608, -0.19424268999961367, -0.10127508862087033, 0.44342135174340735, -0.37978250127978264, 0.017721767010684387, -0.035657910972500199, -0.40076261569156341, 0.15977294971937384, -0.13201415425740051, 0.14257326770209258, -0.21073940277302716, 0.13670733676194827, -0.27707104592681636, 0.12185788933748617, -0.17875147286134127, -0.16044443577030412, 0.047947282721238507, 0.070287633361652599, 0.40387376472931374, -0.038256129429292671, -0.11895297603685084, 0.10181730783519702, -0.0015245254851232581, 0.42652033880351797, 0.19009772783394566, 0.15157549734696105, 0.072098970257646444, -0.20468662545890703, 0.019062735285717378, -0.33434802659145968, 0.098620760742482827, 0.39218569087279354, 0.3450213299494137, 0.054598836067660521, -0.32272966036311396, -0.13474205348255858, 0.072490539693202197, -0.80828249099735194, 0.36050824161118589, 0.085734892568419277],
                             [0.18297617981225275, -0.10602015662070907, -0.090788180199779495, 0.20751374227013158, 0.21818127448608535, -0.17242080043347946, -0.019198594675926311, -0.17215985712722759, -0.11964135217962363, -0.19306631911322999, -0.25649004176016721, 0.13252661080418779, 0.11744066459897169, -0.081344406957704229, 0.20078571585329905, 0.11650867736780925, 0.36803313242748664, -0.67199368532438186, -0.038328276526722792, 0.35219894403290247, -0.38525109773693422, -0.15436716604079276, 0.11522653523589109, -0.40996322804889468, -0.66620864417485759, -0.13684425596792849, -0.35818096339705252, 0.15657582141990167, 0.035026628927184993, 0.25617201534345485, 0.18617174466801892, -0.51098079168104893, 0.1427802708186332, -0.14587885991778479, -0.0011131176151630083, -0.047243551310152718, -0.27637378006207403, 0.19461495719350999, -0.33464793056451581, 0.12841728799604604, 0.14468600986011171, -0.53895317833786416, -0.16717397806926204, 0.26913257017099612, -0.20167223328243847, 0.37001287195707577, 0.49746168326204754, 0.026363690122154379, 0.17960171150457097, -0.090094671971686704],
                             [0.070168524618760969, 0.27745023544935637, -0.24606489001316612, 0.11028701852854275, 0.19612954606440583, 0.20839063158787952, 0.086595018553841246, 0.13745060411551538, 0.091378591861475553, 0.23398980027937227, 0.27916268937786159, 0.060420821984947012, -0.18034035539986037, -0.21247700925994992, -0.43875701525350358, -0.11936798094842199, 0.37955169571753916, 0.07081219462487677, -0.23904625538219032, -0.64180021427189227, -0.014089214768722984, -0.12367528228107362, 0.38092906879157107, -0.4824608772856056, -0.22176027888207708, -0.2047049696135792, 0.2283290134907649, -0.055349325327388142, -0.050312957744816554, -0.48432179491562666, 0.19972143434443718, -0.11432646602282773, 0.46259263681797846, 0.27889992604360486, -0.22850143517426347, 0.39817965897293406, -0.02473543208929186, -0.45291607111032406, -0.4440900458564449, 0.050034087348084601, -0.033984924176999956, -0.048039595327557708, 0.13346562674598744, -0.20497305564463086, -0.094833800217904787, -0.0098712842287404234, -0.014290117942784751, -0.031340632161996937, -0.045537187166872585, -0.095264551334294109],
                             [0.50308478044936267, 0.20909700456630873, -0.08794198887556022, 0.47131072650196554, -0.10153851530257706, -0.29942600347275594, 0.11609655779263919, -0.038526095679543647, -0.071936429939820523, 0.021016210584782619, 0.175245080649476, -0.19056843355134276, -0.40576887555360791, -0.083528185053262594, 0.17596408425594628, 0.3333414086961381, 0.11184943509142115, 0.18959445420063992, 0.085386649495486577, 0.1287349984354052, 0.50176089850994099, 0.22491178250264499, 0.11410761347167243, -0.048191898484458776, 0.38760955224590138, -0.1809048086506492, 0.011453580139702071, -0.54819499714394471, 0.31378502581381496, -0.047487256496773107, -0.12106584047892781, 0.098288236315642374, 0.022238481622359418, 0.018809738734400745, -0.16919924393947552, 0.098647588011675072, -0.4900247025149172, -0.24816717615455619, -0.10896801401909616, 0.23674105713688903, -0.031151107881462432, 0.15430010982577461, 0.39470143490484777, 0.27608757727121946, -0.73058804708438962, 0.27963739036979729, 0.1193786868205321, 0.1086311776827551, 0.30230046283662826, 0.059484296116009014],
                             [-0.19271166418899602, 0.058847212508749656, -0.17773063721057106, -0.076904968691493394, -0.20364752745752335, 0.0099929393895733416, -0.085125147486639394, 0.33541782517299568, -0.18750075128190094, -0.51050809641617456, -0.16803700738278604, 0.16351746955077648, -0.24773757262940721, -0.23945759324764801, 0.092061613834131903, 0.036215639306888099, 0.098815531975138704, -0.21831402872563194, 0.0068403788710795464, -0.12872941320039999, -0.15466738371678543, -0.30702743044232034, 0.340750757100031, 0.050305715565595287, 0.19070164904948569, -0.74171986528752565, 0.16619187932879434, 0.22424735605366586, 0.40730999927385386, 0.20933258703583263, 0.18196418575318093, 0.33303435431941364, -0.19642334519265761, 0.26207527574493228, 0.28263867109564711, 0.21466353846901357, 0.20153710398900301, -0.16515744622503048, 0.21768892700167017, 0.18818594036908592, 0.28387656856363991, -0.17210320727031581, 0.017625690270490865, 0.087064042265599662, 0.14688414965186766, 0.37348316135652027, -0.2566326180185754, 0.19556144912065221, 0.22857198401224807, -0.34917093741335592],
                             [-0.067865446712140287, 0.54428937011471545, -0.032553674718005438, -0.26828781584914951, -0.09357048855809208, -0.17520459104273495, 0.13453231219068135, -0.39532208391914475, 0.12828546014890038, -0.1803045564001135, -0.13397777928373347, -0.032344200337260882, -0.040857568913180042, -0.3437083848829855, 0.21610792677556809, -0.26090073953408222, 0.16997088783807204, -0.41984542395361701, 0.51958062791793402, -0.0045891783400314173, -0.047931487379952793, 0.079612032454889861, -0.087370355112911607, -0.036198960299451466, -0.27483361780277177, 0.08000512879563168, 0.13858380279479474, -0.0065961736553235839, 0.13755626505001589, -0.23680971818386673, -0.013779132406589956, -0.026829682030533451, -0.040788514496177604, -0.27155880860233533, -0.034982481454689886, 0.23296682144069539, 0.30498773591866923, -0.17498456007995106, 0.19955892863365488, -0.4423082343823051, 0.14593066850404612, 0.33383330856127952, 0.26880562263731989, 0.0082112205796283227, 0.045021677884486973, 0.097547162743008287, -0.30647755190263476, 0.35276277730467714, -0.2499488696791772, 0.34684119874697433],
                             [-0.40864245408511651, 0.24481649912922643, 0.3216117407919874, 0.12138536927100013, -0.35052755720627143, 0.14969903953324085, 0.24260925032621478, -0.077585153374244306, 0.085323235091903857, -0.16593820721790406, 0.38521107860860754, -0.60666284914468416, 0.16705627177136284, 0.30284859201995229, 0.0100797931206059, 0.0067193254261881108, -0.26779734766794333, -0.18438917755384429, 0.29391691014505922, -0.17524262047415287, 0.38883677703375924, 0.28436537804100948, -0.51586686381308489, 0.10252444379592457, -0.018027555514220882, -0.46803108517118752, -0.0053866954353208648, -0.14667015761005148, -0.20218660483934767, 0.099376498858543272, 0.3625049566328824, -0.056769861435946437, -0.053371338970121751, 0.1758752236725751, -0.47496143327552237, 0.027402893323152232, -0.55682876898473976, -0.15214055155775763, -0.22265339386759292, -0.38088288556780142, -0.25537242594801013, 0.21831115391779424, 0.11919175661712263, 0.03192913674440058, 0.31029410865845475, 0.044705039729998682, -0.22091024877467863, 0.010809455195040481, -0.085388899918625014, 0.093929504161915103],
                             [-0.14595078272616588, -0.030477862692964666, -0.29027369116421903, 0.20136302226574512, -0.11063932465261021, 0.31152299278203904, -0.027775078979518496, -0.10516237570471604, -0.041958629537641075, -0.099229806999501208, -0.06747272677043821, -0.085068696151059248, -0.20733805481232945, -0.35459292446715329, -0.20002713682806361, -0.25524908978810112, -0.41732883702356066, 0.16287111786199743, -0.01249178048552722, 0.27468904853581527, 0.022151935868616933, 0.32768208295467283, -0.13569905854801495, 0.1823746152769169, 0.24533168084708376, -0.29016278652087002, 0.38967422125013357, 0.17678019629859307, 0.048125409963085147, -0.50682026062363938, 0.061620619453406654, -0.35009855037760101, -0.016888064747347834, -0.12217908457678581, 0.075567585955569727, 0.46875551941023219, 0.1147662753200851, -0.37425808796237853, 0.015482076528234709, -0.15080019386342361, -0.18381103216546321, -0.24968836333838751, -0.29900904354751789, 0.41924404461424569, -0.039754586545350384, -0.25323045358566421, -0.052460086929441881, 0.20557400817006186, -0.32348251374676806, 0.1049934091569127],
                             [-0.072197502041135037, -0.2763612822963179, -0.29300237435880366, 0.17326562798264239, -0.037032864623791531, 0.35702331558542788, -0.18519170320996484, -0.0041467209399364408, 0.13697635954894044, -0.11529738551657068, 0.23959007651402775, -0.29159218767410272, -0.37708945253164516, 0.10146733837807484, 0.39924664301499257, -0.0048391849982835494, -0.076876176618472125, 0.025613214143719393, 0.28132179471005697, -0.053899965452054006, 0.0051741250262403692, 0.19274062036052955, -0.055301601885387693, -0.62221085068769355, -0.1380449050878694, 0.17836166697203978, 0.11644376187227998, 0.18265832069718194, 0.029813880604398661, -0.29133037601247341, 0.0012026506657102642, 0.13379669156799304, -0.4309596346503789, -0.0075081750809220041, 0.30313526138102964, -0.037999356085839667, -0.013611336582454329, -0.076316859409660667, 0.10393087339786096, -0.06957417580612113, -0.13419508879975459, -0.27698033430428226, 0.3890174208496282, -0.25128883040053174, 0.26052132873075906, -0.065960514218855237, 0.22663050553355191, 0.20664466614588339, 0.16119304893589026, -0.22473134643309395],
                             [0.017080554354490504, 0.090225239804127638, 0.26715972213579414, 0.22713773520082017, -0.19312171780140058, -0.17162612216383519, -0.7817172714667, -0.11066485471992392, 0.13219334447697748, 0.09856122107103038, -0.37646651421035648, -0.24278475092911297, 0.011174071159205032, 0.10017815141113971, -0.32737257108084655, 0.21223318106342967, 0.23639562357744054, -0.14137604922877647, -0.25574779749584547, 0.15798849131115805, 0.19597061858903633, -0.16262416988702966, -0.071229801787745101, -0.09963841757341646, -0.35996938802942419, -0.33714526023415115, 0.20753544251742731, 0.021563897824511156, 0.065990454912627436, -0.16118042491013226, -0.40666177493909822, -0.17691517503291429, -0.025265267030058741, -0.32062512207848509, -0.53221595759021789, -0.12374600578345082, 0.098941881378793367, -0.10039653289624416, 0.27521726570531291, -0.1274260049878555, -0.014009009959914732, -0.12319246905882961, 0.31001104554303577, -0.055450397072907026, -0.31369560201455104, 0.16369979828724138, -0.21888673426341709, 0.10621069717927609, 0.12602871657062478, -0.44860236764227551],
                             [0.37772771563851948, 0.28416409438110868, 0.0039669997319883472, -0.56042787496221325, 0.10553317556023215, -0.10347116778466749, -0.29031355572778683, 0.21104375698556926, -0.032392484885377382, 0.14205965957780359, 0.12503718803085045, -0.16220646963172597, -0.058730366200206732, 0.48959570111952339, -0.32386593675433978, -0.013131609941918716, -0.41061601246706747, -0.20737784689871613, -0.41249983580019078, 0.56901347656802748, -0.32745342935634097, 0.62087467413574493, -0.20909173117856897, -0.12502784195663003, 0.30724337064758367, -0.013191611248205896, 0.056653535003190647, -0.066826168218126675, 0.16712573941313866, -0.23853087692859484, -0.014598797863793186, 0.02276426520135183, -0.1441937603784447, 0.35045428748698221, -0.014754729152292893, 0.24617447120396577, -0.30526497981048922, -0.39835924297957465, -0.09784233565760321, -0.2490861709184472, 0.19140354654138725, -0.050159506598632358, 0.39763510514529971, -0.047061504912363959, 0.015522772000826307, 0.45773183673418022, 0.062576404217214374, -0.19713556082716774, 0.18225305513326742, 0.39677410183373463],
                             [-0.22479033806801874, -0.015213453433677797, 0.10078211051491902, 0.13898931525876268, 0.2341468822380903, 0.097642511696235543, -0.070039269805290127, -0.38257906863863661, -0.13794438398730943, 0.14956041421846544, 0.1025170239868656, -0.062420419505849464, -0.12760069090016626, -0.062338976963387027, -0.038769515021560778, 0.534540623440382, -0.24199475310801449, -0.25992402111475871, 0.27997788523074552, -0.19179282671741546, -0.070342831454630328, -0.33982897974346937, -0.067901497907256081, 0.024522290387933028, 0.14747718115123853, 0.086911652208664356, -0.3797601669408886, 0.13467801640700797, 0.19745520299445565, -0.43787710894902898, -0.039791688064343106, 0.34147594978088452, 0.25997336346393257, 0.1075638136369326, -0.073831751047980676, -0.23648846921437772, 0.116888348483748, -0.18614034655525596, 0.017293049564182893, 0.18209806820469746, 0.040367379377521294, -0.45432280066505992, -0.31307654682152486, -0.26262378947148113, -0.16305371249519032, -0.13018556674998516, 0.039537445269738403, -0.15163618447005506, -0.27964788064245288, -0.15291582757187713],
                             [0.090678262170838242, 0.031174792261631418, 0.26669109468578067, 0.42336301401515314, 0.20131738927549703, -0.19745137350072869, -0.42166429263225258, 0.3373785567105046, 0.20061667096584893, 0.081809708971509271, 0.131734345699554, -0.46916203537136847, 0.12224668890167371, 0.073089638548463731, 0.18017828951319934, -0.1953350578880691, -0.12728903856579565, -0.36740107763135993, 0.36274517261446471, -0.043450015582814382, -0.24975110195001568, 0.33315899719835396, 0.41248564722469844, -0.08890548898965786, -0.26593488157761525, 0.20135955114977083, 0.11463862713242753, -0.37086996228368835, 0.13972930050780094, 0.095954754703694828, -0.0934911404190054, -0.12877453013970813, 0.42275896974643895, 0.081952385290369259, 0.24778156139987587, -0.13767725063500369, -0.11781104885238033, 0.091216110058998573, -0.23741898177180559, -0.014021472567354599, 0.087343499357021653, -0.054983958479930324, -0.67546259354051463, -0.21570485065406036, -0.21549609873090922, -0.19307194758856733, -0.076769686721190944, -0.054717410423822943, 0.2548315548136999, 0.018392251017471307],
                             [-0.42028912444254812, -0.082824109097681731, -0.20920534514614605, 0.47568477176720009, -0.24572210126328756, -0.25063251341365117, -0.028391075313421249, -0.19037011488225117, -0.064854455410218892, 0.012153023432906437, 0.34375148750240392, -0.060801407844797803, -0.27289482475260868, -0.44542719710748852, 0.089693942680364958, -0.22378777737590808, -0.13849030040081889, 0.44100213221393381, -0.13576598877053681, -0.15365820123591611, -0.26100187484863574, -0.22039831582622726, -0.1288186902213688, 0.24886820831665998, -0.33247911861762369, -0.065081649754900731, -0.049690894719408671, -0.52248333375376776, 0.43255656633498046, 0.31870061591312626, -0.084447456025175685, 0.14583883730991079, 0.10757852165111546, 0.073082083688166183, -0.12484214384631259, -0.38471957017026498, -0.0031394627918612328, 0.5573811297637512, 0.15839552528100431, 0.1892480343416667, -0.38019393557568038, -0.033457000711702933, -0.10042409205534705, -0.13184614818309212, 0.12575368981922078, 0.33363832404640203, 0.17026673752701854, -0.14882236061714377, -0.0011798616366664972, 0.33404919541191236],
                             [0.14130039684174708, 0.084669643600074243, 0.017184096675138285, 0.21115644348103405, 0.0073625400832006901, -0.17327978241976422, 0.0082177218427417868, -0.19897723039075266, 0.201036597302645, 0.42901079706336837, -0.58803269678614378, 0.10897820723036691, 0.15547506290943489, -0.54503531449306686, 0.011435330920648898, 0.33773669652141458, -0.27967760799769242, -0.088699660512278775, -0.20574155262433999, -0.31689253034702236, -0.056137703180303145, -0.071356425274043622, -0.25689741394556453, -0.027917479588094284, 0.099465678955910422, 0.10997262288329422, 0.15390182117417767, -0.14317565158170473, -0.030096622485868883, 0.39976166238344535, 0.16456590359825449, -0.27775688696707673, -0.17597056355567314, -0.30096636931282167, -0.025964771230623636, -0.36311020240693875, -0.089299520155755999, -0.52164897608794425, -0.13829182980376772, -0.34766304058439301, -0.17014286616505678, -0.12402961316753569, 0.15642781452671983, -0.1298264111322239, 0.44379485638639177, -0.016644125917525232, 0.025220947095944267, 0.35223490156711018, 0.26861137535764507, -0.080251657488600539],
                             [-0.13528203679805945, 0.12326785320019304, 0.2823029690131359, 0.38069939974859729, -0.31860655145290495, 0.061856075942735386, 0.35251784039663508, 0.18202011136283039, 0.19173467816092782, -0.18119075219529598, -0.50916548459188293, 0.096037603292961154, -0.044947544863823213, 0.11465183468493936, 0.12549044268145113, -0.35229302341023477, 0.20073111440121788, -0.015828569918094816, -0.23701730854097239, -0.4355590186552028, -0.31364256875438201, 0.15338293408757545, -0.093196085587667968, 0.10629176291670048, 0.0050654057445352861, 0.51192331228129884, -0.3385206263760433, 0.12190717135411505, 0.27438125008275099, -0.33478986433416236, -0.34549078868810451, 0.35461563398598245, -0.19771099059493835, 0.28559295887796632, 0.068572397407312635, -0.034581907474990112, -0.18471375754989577, 0.036737697154261596, 0.29326866816028091, 0.16949839800691888, -0.08742730490958911, -0.31130093113249113, -0.21025961299011448, 0.19735676964923921, 0.29749812560350469, 0.19061609345029942, -0.1378525158464298, 0.025762243397434992, 0.074182668840606147, 0.25059513208484768],
                             [0.10706539664880384, -0.3449711938699298, 0.016506164978083299, -0.085136696060253619, -0.42835262417113207, -0.0093370506488998119, -0.18812081199801922, -0.43199284906928342, 0.066813867520691364, 0.16847251546086339, -0.0226771385920389, -0.062746627182670003, 0.21932790512549641, 0.28441836591965425, -0.062402149039849981, 0.035004663856325384, -0.31455878876833671, -0.08983839317615569, -0.26242736773777908, -0.03473079551104586, 0.018865125013057607, -0.16939190758357223, 0.33936680548907855, -0.051254283830144479, -0.089979259848717325, 0.15695053103631892, 0.16668232251326834, -0.24651236670744456, 0.14823968783651495, 0.068035455562769132, 0.10944097574811154, 0.068252193955641499, -0.023715539110823813, -0.44173375143561655, -0.11625493865907831, 0.18996718489080078, 0.14191839111357582, -0.57032973294934008, -0.087213418789608491, 0.2894498245106375, 0.023286228040977686, 0.39112857777884691, 0.31447498785618483, 0.29233740287052318, 0.12471463511884584, -0.12108252759372194, 0.37041565796781595, -0.15425487920980363, -0.26681896607535638, -0.30043361499169691],
                             [-0.35530735846955935, 0.45590938199372139, 0.0048273880011246682, -0.20738925431401184, -0.011477904011243103, 0.12071985887086019, 0.13550049021618704, 0.22580539969955513, -0.13374420327082101, -0.12245431401427334, 0.29525182719755155, 0.048386206962579087, -0.18625934464209257, 0.17145048233005661, 0.023545936966432694, 0.39599219518530987, -0.12139392258853526, 0.15744146770539602, -0.39362828959706109, 0.31934819111062834, -0.1204273807314441, -0.098434732453697993, -0.30370734858916443, 0.079080896382373686, -0.17523393119232822, 0.14623035645017454, -0.22277307030963914, 0.28034589293987272, -0.29787961920739786, -0.21089344897572398, -0.61854722359175685, 0.10210706417022697, 0.18211950511687952, -0.2488855026545479, 0.46821669505904995, 0.092089389423416532, 0.46873175384945409, -0.049861162534533779, -0.22873112425408534, -0.030343997317349304, -0.31551437080697892, 0.29231512539688292, -0.50422059191577628, 0.20013260426387591, -0.12967657484255049, -0.0058872805692387585, 0.12932950305919569, 0.14591736262277166, 0.39256862628330591, -0.1640040647951003],
                             [-0.16237866203550308, 0.21370410513983562, -0.068865265307889445, 0.026387169586238629, -0.40146262270834271, -0.28664057057843001, 0.11172158126227485, -0.093634335152399398, 0.1206662453079333, 0.35703978694712629, -0.013892065597493229, 0.36683392570408468, 0.19045452899882992, 0.38427801232212189, 0.47427182740108559, -0.041635753556339118, -0.019748198231828096, 0.0908323450993853, 0.0048009694959273022, 0.34402134243362503, 0.19379837982155387, -0.17114107120824709, -0.18589133469740104, -0.39989712178732545, 0.29676098790292488, 0.09439424124244071, 0.10530890830185985, -0.02939275757021419, -0.16411518546215012, -0.20657856656387513, 0.36912920871462884, -0.3185637745763894, 0.015905143641861456, 0.20720476583078004, 0.12410488967078373, 0.072448930703831557, 0.14182018945524663, -0.19944191819808635, -0.19512020247306885, 0.12444991363838963, 0.020458837428330871, -0.1678698090896987, -0.14459173896009445, -0.21301396020168165, -0.090008950090538956, -0.029902117271572375, -0.39631848592820712, -0.46817490199249845, 0.24226860514650506, 0.17965535612526906],
                             [-0.32817581441539961, -0.2610642537515569, -0.13921362889393163, -0.14431353639271444, 0.070360959094483713, 0.076371816690505495, 0.27716523266208631, 0.23983392533931519, -0.19312620490216981, 0.20132728331991559, -0.030572247274398542, 0.23883593965213476, -0.33367687793036793, -0.37254411667709797, 0.14475439432148238, -0.2360343899899203, 0.40653379492539954, -0.22727463028997541, -0.12745947447501166, 0.12244643341574142, 0.077560377934893301, 0.098219142572905108, -0.15065438471462789, -0.042245128085808117, 0.026088529001825702, 0.096904804970692357, 0.084267089978687537, -0.18357420446834372, 0.16501876798985937, -0.22225295001493978, 0.044072411613372567, 0.39784571662788504, -0.04028641019051734, -0.40437133856220181, -0.079088266347083963, -0.13468123473774618, -0.59054420612048164, 0.12431813678303817, -0.31196180291606873, -0.45173241483906357, -0.25656435132748728, -0.0082688474237057642, -0.35409389873563363, -0.1392510014443793, -0.06945743639582129, 0.0018973400566778473, -0.068469167350541926, -0.21039858393929467, 0.05043766182716914, -0.42680663346710584],
                             [0.00068389265816656223, -0.013402296490328383, 0.13916260411464756, 0.11695755078277557, -0.0065238807664195989, 0.15327829010240934, -0.1304295796592676, -0.17568121225832331, 0.064763058227420373, 0.27766529868691731, -0.36138558892027256, -0.12279589508909003, 0.20480644753301575, -0.048536186873511508, 0.37695657091818602, -0.38978689891270896, -0.056592388513359453, 0.37719300673220074, -0.16345359498447998, 0.070101215757561466, -0.14047276508474837, -0.27187554951943282, 0.16838627905115075, -0.044171399643308504, 0.12019651590065572, -0.28697803549201339, -0.26539439390055442, -0.085263861572657709, -0.11265665058581957, -0.39981079391839808, 0.36793156768443769, 0.10978738087920913, 0.16685365173207531, -0.15434302149167609, -0.3271823805162683, -0.24974907995781567, 0.22698259113299271, 0.063397057069492821, -0.37238557210178569, -0.096115195778588097, 0.33241704520684978, 0.10879561912543284, 0.52515093606013652, -0.21603760053563262, -0.15090152581076216, 0.1488483037078534, -0.001554686729372805, 0.31759748539597282, 0.09485347253897565, -0.25059551400760355],
                             [0.28099762452641452, -0.21005196152702646, 0.2447204694367914, -0.22465961413880206, 0.058771981113692848, -0.25523385628121248, -0.03069333553818929, 0.24876014626550569, 0.20200691922682629, 0.0045941056516560445, -0.064706176149433303, -0.45301685593941748, -0.14962643909402371, -0.16707141160174996, -0.070286504515026951, -0.21124990818861733, 0.33690375280470752, -0.098285765871928193, -0.032469427416400638, -0.027996773169203105, -0.12753396752421856, -0.33710257709323682, -0.34660070002019189, 0.17118944512477058, 0.082827478356319179, -0.13307224505509821, 0.0069826857149504233, 0.29613658624141581, -0.023914356391876411, 0.17739637252808421, 0.23730346992808782, -0.061945255066510239, 0.011005441797217064, -0.22327001618954939, 0.054342390056784526, -0.097914073084638939, 0.34096552580295553, -0.032808906031290413, 0.020170918501372793, 0.80257174912724083, -0.57380743163364367, 0.15094417200828841, -0.032669447460745696, -0.24026850881411296, 0.051093620961715741, 0.21574787829719999, -0.12413102865251242, -0.11124339784329978, -0.083714426825168831, 0.046929971678583461],
                             [-0.10475512345583697, 0.13997432048837763, -0.47250407334816252, -0.22032960271133104, 0.25786506135697329, 0.32087814959003141, -0.13578001697771011, 0.53053478332721737, 0.033284939566108424, -0.10256333480492315, -0.5698624081230963, -0.23390504886466323, 0.41430325581075739, -0.10096891304299832, -0.059562213732888586, 0.18857689170979644, -0.10672211634224547, 0.069905689390886275, 0.1350057110092264, -0.022388881373522997, 0.49969249644697372, 0.19609016134468221, -0.12634476527410157, -0.061210216164169655, -0.22730096060703348, 0.54259790352948689, 0.10621659032794951, -0.25007111183021502, 0.11789472340062954, -0.071978788121860385, 0.098092044842563217, -0.14569629268511447, 0.17672557488916218, 0.12355099903193541, 0.032027402612836681, -0.16942242400640939, 0.20258989937691715, 0.097409838997213088, 0.24999249067269999, 0.084460347634552693, -0.049686771237342463, -0.23950937349391632, -0.018543985817757236, 0.1481766026785841, -0.20496718757518118, 0.24084409040828786, 0.37843064689684014, 0.092909807900884059, -0.29551823233126251, -0.43744510291591648],
                             [0.03669023563801288, -0.33968590142754901, -0.3059218589424304, -0.62039277792174008, 0.12750046926062042, -0.56041262935179825, -0.26510543399629116, 0.092796868562082982, -0.23979044647862391, -0.29846546235146321, -0.092707747943528873, 0.12142493269872723, -0.29362988265276851, 0.056233114028246663, -0.17350397515239457, 0.18300996332902406, -0.26262181906306725, -0.080391183620604212, 0.10867836493854502, 0.21631724164964405, 0.039396070944925116, 0.66900619660552763, -0.027507756331102837, -0.080019311735395657, -0.082783913920840155, 0.55220935238503521, 0.002438923880134598, 0.47679427871461993, 0.19772047240684718, -0.23296961510397174, 0.010401958340339509, -0.17344093140168046, -0.025634693054648251, 0.077795896708083484, -0.28862104112401182, -0.29595718541512223, 0.45777427286653471, -0.38718695324327923, -0.42946002358407503, -0.34214420797408246, -0.021318699514105702, -0.02036320464915805, 0.17678744644148206, 0.43005331684972775, -0.056417457576569324, -0.17426683005430152, -0.093459374738308704, 0.040321937398363955, 0.35486474239885429, -0.1586006659438941],
                             [-0.30723741744079081, 0.1553950257159803, 0.017382050435328072, 0.038877531703486241, -0.04039236350018572, 0.15626856207849579, -0.36102912237862222, -0.13050908547397186, 0.071827542140901618, -0.38868561813959546, -0.010585976265787469, 0.49531218708343483, -0.42383632847386765, -0.036036411149179236, 0.42569629066170644, -0.2754661563180823, -0.031682218583562433, 0.13696616663879307, 0.067191042551350499, 0.11570652444143645, -0.020870309252178657, -0.1348321731906498, -0.19753627056690051, -0.043187447143667394, -0.0086088822136528194, -0.014125352248726207, 0.02613724142185448, -0.29235447466066189, -0.026352906254252687, 0.40438094181145862, -0.25402938906048789, -0.20470496824365761, -0.002803886974722441, 0.41183315073931248, -0.20501519536348337, 0.05123743487845546, -0.16553674382768949, -0.69429934736573928, -0.30183848651375128, 0.58798484901182246, -0.019464144305631828, 0.1820007824408241, 0.14764922566075858, -0.095724694988687339, 0.16860525424707809, -0.21189637158667629, -0.47621949575734535, 0.19234062162407431, 0.090117424863841861, 0.13730262320148709],
                             [-0.043864760379799701, 0.37839948662066525, 0.30615200840239937, -0.32699551748305078, -0.042544169358495608, 0.19586347468018203, -0.3389392056189387, -0.17348602826040088, 0.067552973231202879, -0.27296932512878258, 0.45784558505265682, 0.16330814372816502, 0.2826143303321389, -0.3080076996456636, 0.34447215561004035, -0.30865268170023241, -0.19394808604649758, 0.049968920035434149, 0.071808308022854428, -0.21394844211429562, -0.17724573808507002, -0.093563328798994497, 0.038385313459589204, -0.44069424656844153, 0.45834881524900328, 0.089726826963268405, 0.064327846915988293, 0.50695199648670342, 0.30950573313935975, -0.069988478712810318, 0.063324548659609584, -0.16024074508826336, 0.23481728323490864, 0.32280985365634873, 0.33406237197691274, -0.39000565365834799, -0.23738657224090143, 0.38075022722331492, 0.16379222387794279, 0.12787450601900921, -0.32730158733366083, 0.088888167615672115, 0.030140031857478992, -0.10754510949127863, -0.60046715193933387, 0.019335746006266478, -0.081552639129592847, 0.11225814662844062, 0.28993504306052037, -0.030677208289013956],
                             [-0.14571146134331092, -0.23872391139414134, 0.20747111037675151, -0.3664699946626721, -0.082306915107351983, -0.41844200546022031, 0.33999419680063325, 0.31772666440610209, 0.45543814352800271, -0.097467953503912297, 0.20724257854433448, 0.23410274847821791, 0.18420338838011283, -0.14151079741570033, -0.21853685937293965, -0.043052642179267478, -0.3825837826256171, -0.15918916810092679, -0.023515908308457734, -0.0045629589716328902, 0.14370717175184092, 0.16091274818510015, -0.22450113685034823, 0.061532293643534582, -0.22329279516118122, 0.26477106021203578, -0.34014134363701293, 0.040272118583392594, -0.011093829215101427, 0.0070654421374020757, -0.36705307298303003, -0.21915916254868337, -0.19041156100580053, 0.17712469952676893, 0.16769831631934065, -0.12019642343846308, -0.09802891574384727, 0.13712247635454852, -0.056922541521892883, -0.097340596771313417, 0.22096326137769784, -0.197221199548646, -0.25905056046280228, -0.60614461192978264, -0.4548344731151055, 0.016165674759312191, 0.18553670820051138, 0.42844956105739473, 0.044066740916745069, -0.050575976586491142],
                             [-0.33657972780273382, 0.16593797227777365, 0.19442384449088368, -0.061983374015140889, -0.14536568166096739, 0.048261986319010582, 0.10008685182945075, 0.10069623923065865, -0.16459392178584975, 0.42853115916103912, 0.41718075993270254, -0.068856652823313672, -0.30499142922796474, -0.44392272588583165, 0.017812836828779006, -0.25855840648849809, -0.38418753019874974, -0.29831008691462302, -0.02502409357735343, 0.033149312759944594, 0.059562371055015551, -0.28660266913699206, 0.13882585314276491, 0.20236301282234306, -0.13002126440474202, 0.16574248102065314, 0.52626337095910292, 0.2749968902646544, -0.43026478751836744, 0.074443260842538175, 0.07185787233630539, 0.37237920257904389, -0.35567854737135957, 0.086723781319486326, -0.13041910245403063, -0.112577886860531, -0.069659991124131654, -0.079726572403274409, -0.093181151870391776, 0.081049299420691334, 0.091060843886950196, -0.06213244961764066, 0.4742532758468907, 0.17221307989362639, -0.30802401774928662, -0.11594477058848532, 0.16228101838164755, 0.12700197437019836, 0.27000245007684187, -0.19770969331124916],
                             [0.130339797720467, 0.054858450776148787, -0.010762130159875229, -0.06320234249731646, 0.09138795686650307, -0.52194394784503551, 0.20790093530994042, -0.93748847400997981, -0.22774526613810828, -0.010601934279006384, -0.11848608862222677, -0.30636190417070658, 0.46018170124863572, -0.0062784425615041595, -0.10362918479245628, 0.088804892509009914, -0.27351948972393547, 0.036939758509572145, 0.05765078112513377, -0.03239833348322757, 0.35065305676077307, 0.045266852488672356, 0.10750163296252799, 0.36129092990883865, 0.098353933243741642, 0.17076173696764105, -0.056077174116079355, 0.07345522169826374, -0.1988554354523005, -0.13031953318162179, -0.30011316370302055, 0.50934111283835326, 0.053088940969560967, 0.35267652906797808, 0.31017249815702747, 0.41680302225461352, -0.20187951733285242, 0.086856668981316471, -0.21108105424244308, 0.12774388934693268, -0.41093502139794141, -0.11975481768589882, 0.14088033650848455, -0.2943289466113907, 0.63940418632887031, -0.23749679275629101, -0.11513305459014085, -0.09188945028038778, -0.17697337734245705, -0.072999074501668121],
                             [-0.2113243130491578, -0.33591670640281701, -0.21733967915255886, 0.10994145660456174, -0.17832854476943777, -0.011367177254099211, -0.375445666931503, 0.14971864110081845, -0.060306218224897581, 0.10355172220026476, -0.048966588863058651, 0.30963578798238423, -0.24465606261478387, -0.061989493284852551, 0.13712012166197235, 0.38026350070040543, 0.01418437467969977, 0.054086742466511024, 0.40508062911997472, 0.03629823102145302, 0.34179116356587919, -0.34043414027299335, -0.14232679030603801, 0.36002292523089729, 0.010330916099295366, 0.50581525218135481, -0.40091120396367974, 0.11581347486644916, -0.040238283614046119, -0.25266751770207191, -0.022610925945526782, -0.20196171681067651, 0.28459727794023848, -0.097104108084816551, 0.35108055534754579, 0.27602972026647038, -0.25942919324629271, 0.084825130615117539, -0.18813631391740232, -0.40642282891415343, -0.20905000580040076, 0.08369781480166176, 0.12327623327141006, 0.29189667116516943, 0.27396749791078817, 0.2482318110903047, -0.14768414401877827, 0.25067400813813601, -0.17514505076762854, 0.092314938030151741],
                             [0.11122283811736679, -0.40991458867860558, -0.0094025156285931725, -0.0019397511613993613, -0.026001886159378689, -0.071828593637580596, 0.033016011659426234, -0.24530719245702015, -0.10309887728750328, -0.16328474378518085, 0.02164378589314523, -0.28639095693634298, -0.20372054303820525, 0.068844439772490856, 0.23040004388794008, -0.15951008437787187, 0.072701157234120781, 0.12756672869255475, -0.13918153145092493, -0.24542003048012814, -0.33827443227286752, -0.091479290721365236, -0.49509319805660101, -0.11593544460206136, -0.20025036678334959, 0.1841399543539157, 0.1992890697355022, -0.31296717340458335, -0.44584181905382136, 0.3299121319065334, 0.28197784911021856, 0.21832983168358194, 0.26543570349092793, 0.19381714591697033, -0.013407642016548468, 0.33212144459737447, 0.14866103061940431, 0.060789476759823227, 0.34587271904375022, -0.15861770151281768, -0.076694673149056897, -0.16337862872031647, -0.29349870480754808, -0.007013232976317358, -0.27805431794187241, 0.10774183026292829, -0.16141549557198318, 0.031472640009035234, 0.0037829393273208643, -0.30558675975795557],
                             [-0.065247951762612721, -0.34484471297534325, -0.40614891271686798, -0.085214206050598484, 0.3872385096103621, 0.11303252652978703, -0.11933476164211691, 0.2507232623985523, -0.52198665434008595, -0.045056874220357236, -0.099047725614943058, 0.17800533794609605, -0.2815934010294151, 0.489113804542185, 0.34148134924286394, -0.22441063544343312, -0.5187802707729946, -0.032759391305770921, 0.038363875328369615, -0.81631495869896997, 0.15669350105535371, -0.41560500723915222, 0.13944008062239527, 0.20777432094250509, 0.095170737402233863, -0.15664217428704635, -0.042237353675215333, -0.50597491868997446, -0.24598495904937981, -0.045325565501262384, -0.58582244563175967, 0.10237452350851156, -0.18273769169002327, -0.34410784057547478, -0.0044602504896451046, 0.045781110717893675, 0.36863907180604377, 0.044365181006157627, 0.00039767507878905065, -0.062804459229989187, -0.36239445220612215, -0.083295260249606734, -0.030655352444264157, 0.034054602370744425, 0.026331585667895244, 0.28517247946781576, -0.64687030444503479, -0.24034051082907931, -0.34016028602324883, -0.29601475918993242],
                             [0.095658531223182949, 0.53796968879864471, -0.31722563324701575, 0.054871892229558086, 0.10087859526838892, -0.049351993483550162, 0.14973956600876251, -0.034004861764183318, 0.79028557961438972, -0.48122648771306581, 0.054230743702270524, 0.11192945310440275, -0.29335453679161566, -0.21464334704689536, -0.024767932853218273, -0.38710351619071509, -0.32854379431907577, -0.21731726969765466, 0.38703097676453657, 0.026719995533349725, -0.43290472925355827, -0.1957078715168582, -0.13068381703253881, 0.10189445969886382, 0.24643058318266292, 0.027838699607828536, -0.022579868366250151, 0.13202008361658632, -0.26028891887386668, 0.067244543474906937, -0.012242673436007595, -0.055720511263911782, -0.18630159034282145, 0.20101280559583953, -0.28381847809037686, -0.035058154130418774, -0.40717636814288088, 0.535073160824311, -0.077180155828188005, 0.32480388588174958, 0.041536277692536205, 0.17228654373247648, -0.50011710109258045, 0.043293312616032496, -0.14134281397336682, 0.4061291689551535, 0.063019228782413714, -0.37112514151881493, 0.2624040883076984, -0.28425399063725393]],
                            [[-0.027374382164807899, 0.17557730194074961, 0.15594514372074453, 0.3741824066235942, -0.14007083902503914, 0.053191676101147008, -0.03020520857742072, -0.19976528831015822, 0.40738928889829473, -0.13581126071278593, 0.092726106465437261, 0.22007380567010548, -0.17483237593109427, 0.25658101504856495, -0.22808939433052547, 0.17952495806284052, -0.085880538858824851, -0.1364460638011146, -0.15948130924227483, 0.32331022006922849, 0.065621794665982502, -0.30747847691418129, -0.069148493596906099, -0.032737005887966991, -0.37531835757789112, 0.23630756255726057, -0.30768658886659045, -0.12093917430120066, -0.02682821231353108, 0.24323944859434501, -0.052742530988415075, -0.17046345594339904, -0.33618825796310398, -0.019410911135349124, 0.50018219915892015, -0.0055591795872675098, -0.12515484565335011, 0.28985184283311516, 0.020724311764241297, 0.18206777134646665, 0.064762114967249401, 0.068635548966108628, -0.2665770649020302, -0.049057347664312072, -0.057254329734716745, -0.088698296005205721, -0.44102292396496645, -0.083198948683507135, 0.020888486902523623, 0.016338682323688562],
                             [-0.01080576199147612, 0.40872876999965396, -0.057279149953052159, 0.12721172354758223, -0.12905551645862554, -0.060302426353632026, 0.19096939344319819, 0.2179552121744934, -0.067953701854574514, 0.38486846214750342, -0.29606738766557922, -0.1055050287321055, 0.16173123227665553, 0.24518509716946538, 0.01278559052762621, -0.18852497227478468, -0.42018532840437811, 0.084555276418533096, 0.018014666431419801, 0.14619706724071407, 0.11009274678652321, 0.35992249036848478, -0.17055413233999964, 0.015866772094590382, 0.079794585334770241, 0.30848470537690015, 0.10135310988569166, -0.13828034902042596, -0.015751023169349669, 0.11905773449511008, -0.025137969069318228, 0.10130973309052844, -0.28276468650767317, 0.047975694481583495, 0.10488299406729057, -0.050079354290689146, -0.23721803671530092, -0.18195551366706816, 0.11506510037138794, 0.13703239334769232, 0.23967358083694482, -0.023494827349932995, 0.13759409124336627, 0.24609870586947361, 0.37029202944802225, -0.39290335685682659, -0.039532270337864557, -0.11780363597924093, -0.46570436738198445, -0.19349210504620862],
                             [0.26561294397085433, 0.016232048628575427, 0.35008293023570614, -0.18531623384172921, -0.002885534937521075, 0.090684497905021755, -0.19168522207348801, -0.013627667169766298, -0.14713918800828366, -0.045887812121138793, 0.047282675659899243, 0.1698987180241483, 0.23536953312560538, 0.16783598671525513, -0.13665104594806154, 0.20260369110651175, -0.39201917428504762, 0.46205482165196521, -0.35428585363307075, 0.17786497756205755, -0.10553563161970457, 0.03759750160832824, -0.047163631292751529, 0.026797127321864869, -0.12604149848543683, 0.28027493218864025, -0.066236922949452798, 0.13924444476293765, 0.17786300823257448, -0.34846416315190071, -0.51190248166698127, -0.12863346495140263, -0.081608372033046148, 0.070207236786441335, -0.24999200899453214, 0.42955243773867519, 0.057324872733574589, -0.11008103831922891, -0.27156670797800792, -0.074654402983509505, -0.018038984353939733, 0.26062856534175888, 0.0022118104413212433, -0.1680412054480063, -0.211422009714991, 0.14374758164854071, 0.29396615638903195, -0.10279635415451993, 0.22924261655951184, 0.036551866077982331],
                             [0.33190767916869801, 0.23430658614577435, -0.10826652684601876, -0.067449080497156783, 0.010821838637019455, 0.31102332696248913, -0.18989550873332656, -0.046286308772471529, 0.17938449538691004, -0.4217176140695863, 0.12839985703278189, -0.073100164173703686, -0.21279135233810617, -0.090211421499450037, 0.092133575320097708, -0.15103001388238796, 0.044496420569944906, -0.075025887253005769, -0.17923707019225119, 0.033829579333335559, 0.32978895210727505, 0.24239341829152589, 0.098874516212591163, 0.21537164537146833, -0.21463890600261354, 0.21551973239514816, -0.25777926559546516, 0.069035981028929258, -0.23031701023947121, 0.1534026136344184, -0.18865461581024404, 0.4120979809329357, 0.42616840399387679, -0.057254409306596421, -0.085065850495573803, 0.020323358507173785, -0.016066414104219114, 0.058183500274852709, 0.13734065040298671, 0.00060978624103837434, 0.087089760219824078, -0.10060986616176648, 0.06203515890640024, -0.22073080149281374, 0.33848576530312019, -0.12395489324214491, 0.18763879789059212, 0.16040717910407412, -0.007715752004592475, -0.10231356261856916],
                             [0.28566632638814698, 0.087686412843252279, -0.10861610675839101, 0.064878887388288176, 0.13898368487726565, 0.07810166865481151, 0.079678762200059622, -0.13107354612568572, -0.091564523661958122, 0.018258842636754598, -0.31592127240093415, 0.21281120716938201, 0.18852155097620965, -0.13115644409139282, 0.27923441910861907, 0.0096367275352435382, -0.30684496640529058, 0.02321861534291611, 0.35029776324762596, -0.30931887163906763, -0.097172851548730746, -0.058911447622205772, 0.24170374323946622, 0.21959163418415609, 0.1129014400759028, -0.14642119977733728, -0.28570738519102767, 0.00091145700747246455, -0.025848257730736374, 0.380662445443189, -0.09157727399879198, -0.086404018519460779, -0.13071567767442727, 0.37617787800975722, 0.044464515713143755, -0.18825667928382364, -0.34406224804892649, -0.18689717047341436, -0.34240122074182605, 0.18168892428187805, -0.15929989475408565, 0.15068780660087347, 0.084261663403588385, -0.37034955181724993, 0.075109675375228918, -0.018581145704758786, -0.17281192700820219, 0.3055056403548273, 0.46079540783095208, 0.12475107289049042],
                             [0.069124099868278305, 0.20356070271891663, -0.065103553144597315, -0.21892202787760895, -0.075163096586658887, -0.29297859037455337, 0.036624879628806173, 0.13954102902283788, 0.19726594618134713, 0.18820062509909291, -0.3878767574940053, 0.09821632250054757, -0.14306915334388196, -0.036035763169875834, 0.14307753502210213, 0.49155456286460625, 0.0180079334177407, -0.14520012055432671, 0.20055581580665757, 0.010379413866787042, -0.04303181434109514, -0.060748469420721804, -0.11865435331959415, 0.18288461673646114, 0.16426958975490352, 0.1326099398519501, 0.11861584546474035, 0.24783074123832635, 0.075228289425942979, 0.036267482262945606, -0.20395329236233875, -0.57034523286914551, 0.39469833665188109, -0.58329226300224979, 0.16152426565637551, 0.23702107852469942, -0.19460811665814504, 0.13828698442762449, 0.16392816877386834, -0.19126745179468443, 0.16266250707030222, 0.081617420608837532, 0.11185311226092096, -0.19772574284639191, 0.10995633367524638, 0.33476100849583057, -0.19299905411102888, -0.02382460087961711, -0.17164734079850494, -0.17415028756259995],
                             [-0.0068367805803695968, -0.15743629054335853, -0.2386540190723479, 0.27852390922781556, 0.15256071796938855, -0.046060679695315174, 0.21241410215782755, 0.30409437892491475, 0.15139915319064989, 0.12594358192677707, 0.45027326786819621, 0.12070793263134896, -0.40176176625741034, 0.076065297709156265, -0.025680111258452598, 0.069194757637202051, -0.46775970804903605, -0.11488891281409931, 0.19750286882471912, -0.030961004862930151, 0.44095626675238786, -0.010105629502151256, 0.058295709662877129, -0.023509642741157046, 0.51496915042937585, -0.011086774406680475, 0.086071574695806716, 0.10518271580011522, -0.096769586410428904, -0.21221733767749659, 0.060312518042589455, -0.10138187635955309, -0.049724716731704879, 0.094868517734044255, 0.0018272136533299928, -0.063018082446465673, 0.4261868734967294, -0.20074281183307147, -0.12662430961663659, 0.21147428404385835, 0.20433646252700244, 0.030109826780442137, -0.14112461726661082, -0.095695252125327895, 0.020771143147789432, 0.2364933140476356, 0.40982673598354502, 0.023736030611349993, 0.036607436018183698, -0.016138787386034456],
                             [0.22087803648646887, 0.42178601918850828, 0.23616142526240116, -0.061047505986570022, -0.191778540367225, -0.21928121253367655, 0.25037077427228877, 0.12967864053419517, -0.028227231068196714, -0.0058898267373684136, 0.023825319881731533, -0.037033874786092026, 0.33909896421048341, -0.20418577991749828, -0.063160129181770733, 0.025097236870257431, -0.34353472326275375, -0.072378742811551169, -0.19444839971535924, -0.042521915398104876, 0.082249213079537517, 0.20334477593973813, 0.056021879540420705, -0.016263973414165429, -0.00029177438367007646, -0.19646696867222804, -0.13780488229020957, 0.010800067212396573, -0.19560699577869961, 0.11707577838955782, 0.50773476204013845, 0.045197662320269082, 0.4013979704799282, 0.16435012045842676, 0.22104443059009934, 0.29989383943231951, 0.25976156314116861, -0.21463086074145385, -0.10346146196956085, -0.17703601815329548, -0.098587281426351661, 0.05171869722695803, -0.58105955087652172, 0.0046452518079815996, -0.36339957464169609, 0.1503027074601273, -0.21414237932333147, -0.22307429624385158, 0.13721138782430303, -0.11039908893719322],
                             [0.25919520193997375, 0.01344064962579147, 0.037762673230160956, 0.12446138308808798, -0.003625216084940546, -0.020009376766902211, -0.051753094972004553, 0.0024780486639605246, 0.12494995303578312, 0.52456634354617848, 0.19306452582208883, 0.067257580588965638, 0.14900154079794078, 0.23640236049875674, -0.32955448939751647, 0.079735208288123485, -0.015460451664698512, -0.064443733949181403, 0.091964744079818014, -0.16287084124686918, -0.14871229160449786, -0.37704498237096484, 0.42598362995057937, 0.22462469655038575, -0.14205867723295867, -0.0766380768290192, -0.17009665713213593, 0.14478003915142365, -0.044035186936296655, 0.041378036429545378, 0.1293336847472564, 0.18975851433208768, 0.27779956043770548, 0.39800257547720197, 0.070821396438792122, 0.0034241989094199992, 0.022502875010960259, -0.071725821362006947, 0.67872269378989436, 0.14645101852465925, 0.00059812499734353481, -0.12459888304614296, 0.25966828124218333, 0.13481966408450702, -0.29590071450399641, 0.041696301840707176, 0.13178034166844721, 0.03023961220641725, -0.016980133068424538, 0.017279918422451405],
                             [0.087424209922978391, -0.11387740656646966, 0.053362898329102508, 0.070143317568050673, -0.18331619624154327, 0.054355143939872036, -0.20666514953026813, 0.52158701937876195, 0.31627927247035437, 0.33263009395707216, 0.1439132605222895, 0.043566745810724214, 0.13989588380450577, 0.26573990105213652, 0.4270940529455724, -0.029874316280184929, 0.35311701977941262, -0.17174298050683465, 0.037307691904880876, 0.15101480723703187, -0.011747516795786809, 0.22778021687959532, 0.071287606974774181, -0.43823006456413127, -0.16792915195361413, -0.10182886602044972, -0.2505096458392736, 0.14864430735232301, 0.030118453389672863, -0.082150426027973802, -0.087129434001048306, 0.15606302830097321, -0.030967156072402031, -0.090254622702683932, 0.15955502577079983, -0.11879265352392926, -0.32211156753021991, -0.13302307039795389, -0.22114002723998022, -0.0011421843460823616, 0.028852431018430488, 0.49178356444833837, -0.28526023689622643, 0.20082598273445285, 0.018974075731183995, -0.12920693971093059, 0.18223022906613573, -0.051917467913092909, -0.00020830360495341371, 0.2734197610003698],
                             [-0.27841987610941915, 0.32608121927045636, 0.12080278235883163, -0.013348577716963983, -0.044269235117178417, -0.15677007046273703, 0.28720387722502588, 0.20243053823915072, -0.12082398272383923, -0.10642469394481908, 0.10950561161978266, 0.5244420403095339, -0.13345993722083985, 0.22264760414146384, 0.3529857311456428, -0.27676065463644267, -0.0095085600948202828, -0.15766842434152284, 0.24686085353261786, -0.073009032988753525, 0.037781332353470441, -0.20538422577792279, 0.10858517970450941, -0.11265929146792879, -0.26775587837306669, 0.16960892369030725, 0.43295308361254792, -0.011111552914810403, -0.076225748260796075, -0.29401792992450226, -0.2787694233187033, 0.21687985526211209, 0.086409864181752963, 0.19606792485510463, 0.063372792476096368, 0.36546616614255334, 0.062071118318360131, -0.038008309663243742, -0.084976711122370943, -0.14663430190242388, 0.058850753030942879, 0.033371802840016729, 0.19621134226499209, 0.08056328926846254, -0.16891930524476573, -0.22825870537477341, -0.43550707182296439, 0.24843221114321737, -0.021668823427188233, -0.046537298445396967],
                             [0.055979980415842283, -0.12359496368210046, -0.19252048108792419, 0.32088031746627765, -0.60896813621311807, 0.11254308302711795, 0.05472622048533006, 0.30323845002945132, -0.1151686067600827, 0.10483088884946207, -0.40228978680053368, -0.17045312184902658, -0.17947089831433832, 0.42095112367300863, -0.32470419661745287, 0.049343983337430362, 0.085617493527529134, -0.33255567988937085, -0.027212512267992692, 0.017541215906611347, 0.080426455217014164, -0.050704865922511971, -0.25017217266592562, -0.08059436275537693, 0.12806388901434146, -0.31259246654761619, 0.093170349001448452, 0.086979382581880316, 0.29817133139927265, -0.0015252457020405201, 0.001788892096696183, 0.023508080319363533, 0.42979912827070482, 0.2264424933768818, -0.12335524490354632, 0.074944139766555687, 0.31601826503565661, 0.10772135916140044, -0.20823181842052255, -0.0022274188726993487, -0.05131042049575002, -0.17053091546520616, 0.082469318257155852, 0.011089601543947437, 0.11746958451557658, -0.13058437507222379, -0.31383384292925587, 0.04502030537340751, 0.33028070631770168, 0.089975413855489558],
                             [-0.075269557950994909, 0.24320078226462008, 0.060310168916098091, 0.012007392333222421, 0.13786284278925023, -0.10999399182483401, -0.18366977906311774, -0.25317946192391982, 0.11311387931758561, 0.065941027857267021, 0.086972261850711358, -0.25309086180306956, 0.23711041542498598, -0.24491002829235459, 0.2939333753686692, 0.014788729608442961, 0.11591022169586966, 0.18121298491460383, 0.38582669707385397, 0.43408092953854577, -0.049414284610756101, 0.083740883217139184, -0.11046151091467221, 0.38375018428069257, 0.26118697288335746, -0.23430745591645577, 0.14441608461080591, -0.027459038080862898, -0.21319200732128354, -0.20548584563774877, -0.10348099323626837, -0.17657016232984055, 0.29895752329726272, 0.12739831110882624, 0.15030200234634142, 0.25190800234028943, 0.23528138528708412, 0.26181534046843757, -0.17112128879590546, 0.46113111395911194, -0.18697899670430673, 0.26182337626289626, 0.039011297568760601, 0.2384017873697892, 0.17992999945748661, -0.24077252924034653, -0.036766161284405956, 0.065395243297415973, -0.10781673891109776, 0.046631264812639447],
                             [0.021870441245101381, -0.28773438887109015, -0.10785911116594996, 0.11060172875884172, -0.26818191690919918, -0.34287904396487867, -0.2487627570105353, -0.34417736755463357, -0.00089630578116975954, -0.0028185988909161684, 0.20483818623761482, -0.33735711759936382, -0.016144514575300001, 0.31765921939166158, -0.11209683967394324, 0.21563841746495552, -0.09870951571928073, 0.22549296950262274, -0.028098740562413141, -0.36778578404789081, 0.017608293924480743, 0.31418292516877794, 0.34334341982225464, -0.093340018321823703, -0.17074407389212115, 0.21133804905613485, 0.19162151754173115, -0.14971827147172781, -0.39729111585637517, -0.0025616304207453297, -0.033906783988334424, -0.18454180910943588, 0.16783907267774104, 0.0099081325038138102, 0.1179118332297369, -0.10232553156622951, 0.069770741496061717, -0.16469909837803626, -0.22555434976540395, -0.06599828161371199, 0.26928861765153445, 0.44358313876879885, -0.26451714264374165, 0.08668143819340357, 0.09082539564326822, -0.23077692760837037, -0.036765661091374413, 0.20668223910051567, -0.026802385851263148, -0.018921889235956411],
                             [-0.04199744831008511, 0.021204054572153241, 0.14244173614961492, 0.066609362430070027, -0.13903870851039232, -0.044934654375541304, 0.13476326488035631, -0.11325666001863494, 0.079468030000296577, 0.17038978926609158, -0.30107481379270284, 0.073868855353086266, -0.24429117376363149, 0.010073129120577746, 0.34073887808878578, 0.033527847961054423, -0.12301837047092951, 0.052217662459453001, -0.29685211442894721, 0.32511664303924454, -0.22724399288252536, 0.12570739578708293, 0.18683152748591203, 0.32961450261700964, -0.052184159938754714, -0.44585670200042338, -0.29587913168359381, -0.14166227521550756, 0.14660729166369182, -0.084931358310236751, 0.13083513618628728, 0.032300315900978822, -0.12543072007094982, 0.095479870574880304, 0.36751602093663105, -0.25260031163556035, 0.18731181176095485, -0.19263302104256685, -0.035390504660761671, -0.27310530458968035, 0.45212498931612322, -0.057265399657254412, 0.24445200866014466, 0.12416045413943157, -0.050273619590438808, 0.18890697581142446, 0.03639695071063067, 0.32437198736705486, -0.11884013557436028, -0.015005073701491053],
                             [-0.52074982285547511, 0.17481515123454708, -0.12775669528528019, 0.062443654401490023, -0.18627860893411832, 0.088714517371537016, -0.43134475739607681, 0.29486418902218897, -0.14328933565356164, 0.17478878344446755, -0.27934397730213989, -0.029405121585762396, -0.091942903757803243, 0.25372096779552683, 0.089149197476824052, -0.2791856476314582, -0.02774851199930926, -0.03490220460697397, -0.46573003007171437, -0.11087149544854735, 0.097127707049080275, -0.41709735033604389, 0.29226258376036673, 0.17760186887209159, 0.1129245887327367, 0.1652103346686678, -0.14265144478888889, -0.33296460576447218, -0.15506536545037819, -0.053827814700659095, -0.14799575409736582, 0.048072826563960482, -0.035479372226761709, 0.14932954553767219, 0.13983593723061433, -0.091734962724335678, 0.040868405746655422, -0.21907982480843533, -0.057760669330630177, -0.084626784216259979, -0.21284926077018734, -0.066906615572612363, -0.30751160935791122, -0.23354463462610123, 0.2634228357056308, 0.32100810025914872, 0.029788663583490624, -0.16435965653614629, 0.019780429134453027, -0.053025859496224459],
                             [0.03327181322881656, 0.26530939354036326, 0.27042498094630096, -0.10139265716643667, -0.074682237341287122, 0.073123974570816958, -0.33434260988715703, -0.094946900599434308, -0.13960759461884339, 0.03033076326529786, 0.2996214678542658, -0.065441597981642424, -0.15676796023428483, -0.08501418221191917, -0.20941266190784136, -0.29675169012582092, -0.18528360479384093, 0.28620772260819799, 0.52674453655824838, 0.051697532233306066, 0.034387277386768174, -0.049478852824083583, -0.11385671004021466, -0.46627906815845516, 0.098110235380654012, -0.13066741572280924, -0.29185647600628611, -0.2082204966104268, -0.072264462411970293, -0.050979167936493736, -0.074468514440425404, -0.096388475655244429, 0.099732815326943475, -0.038820771401996412, 0.29120915431710132, 0.020656769550791518, -0.0078083296686451472, -0.073851742727703173, -0.12721421167019553, -0.39673706960480215, -0.37104418643409648, -0.29382222827767035, 0.43447547198890069, -0.0077035853214450657, -0.034619454364902796, 0.15666994063808751, 0.037048909557153897, 0.19993732517810592, 0.045966158353103949, -0.22513453556188071],
                             [0.42724287695103697, -0.31723890413939898, 0.1705040706153281, 0.15645984824089321, 0.22391898105372349, -0.20894378392066881, 0.14563154444167997, 0.035294624922562447, -0.24197293369070633, -0.20472746476638312, -0.4010767945894998, 0.24367751895302886, -0.29081680538456145, 0.39751063266339332, 0.26025314820883216, -0.25542529137013736, -0.016267325164936126, 0.27970454247200799, -0.0031056143865763886, 0.070093977789805084, 0.1150523053822526, -0.13486301762086048, 0.1084141633202149, 0.19301545017588423, 0.092463801373798782, 0.31379921396398436, -0.29700219935642835, -0.08439664255148642, 0.15779847000102515, 0.32469683897974327, 0.0013147958621686981, -0.056163361352497415, 0.28459127518008631, 0.10538239976223561, -0.080981947899074772, -0.041604523773413921, -0.019320167267023843, 0.019532194996001263, 0.040418744380280265, -0.01885599363410459, -0.35269661822731191, 0.02215284311743387, -0.14349071069122193, 0.41029746629702429, -0.20042477951480672, 0.13733065104939043, 0.16985458504558817, -0.18331192375724381, -0.11629747625073858, -0.038596662488039384],
                             [-0.15002713562784067, -0.15250845178502451, 0.47077857449602534, -0.30500379993836857, -0.091217248375218912, 0.17082144579105801, 0.030496628747835187, 0.23146194261161163, 0.18171377286547011, -0.068184565976688219, -0.13999757226245346, -0.16881388089738569, -0.057829523901598422, -0.020750839391840251, 0.051406687455292782, 0.13918396058355514, 0.094447219207661207, 0.22188796362999891, 0.24657563289560802, -0.47429648430955651, 0.024432723215635721, -0.22824827610201284, 0.16224148340796218, 0.12252074510434742, 0.090125223919755693, -0.097161852202840987, -0.32144016593833069, 0.15262803844721928, -0.14281396186625389, -0.081548244148043375, -0.15668159578050256, -0.070698509793128209, -0.1997102692458772, -0.19881744096204729, -0.05702019869215056, 0.34669380337184763, 0.094472029376106464, -0.080345528449678641, -0.29796460255049928, 0.016064483227544397, 0.32991499507136818, -0.36354309380972022, -0.2252154460928347, 0.38626224945057769, 0.29092025663766152, -0.27537871701680983, -0.17108467957744369, -0.072341263287430513, 0.018463667189796258, -0.25239701728797048],
                             [0.29938559205164145, -0.14142065877497217, -0.3647660181011626, 0.11555867661270815, -0.0025314956539713458, -0.030513853517172691, -0.047018685188428562, 0.16931798203032783, 0.049925890053323985, -0.39871187421902027, 0.20565032372154732, -0.10439454275877734, -0.033628865172319999, -0.08014676142334097, -0.024441192183597551, -0.057678474576716515, 0.02976331871987184, 0.075823351235114203, 0.00033078165671531282, 0.14168876619761336, -0.24352798030976133, 0.2376556478305418, 0.20288218346414366, -0.054953566694179765, 0.22832354312169001, -0.2633877153189455, -0.15815289932467219, -0.34053935386020062, -0.070168147798234187, 0.23531163189866888, -0.34022439964818701, -0.16210739759444093, -0.38741782431250099, 0.36325050697719963, 0.081369635547411973, 0.35416914950692618, -0.18776656508386053, -0.11382571400491093, 0.35542598560116301, -0.025547531634760118, 0.21506466982336708, -0.15670008168217231, -0.045617566380993915, 0.13972826403023048, -0.069893395201174102, 0.40256036704911058, -0.16431779846339839, 0.043961219759600642, 0.05927743908185365, -0.29006394447048789],
                             [0.066578734045213889, -0.0046768189746961043, -0.25658243437986883, 0.16673724974752363, 0.11252216789341678, 0.138600015809097, 0.17448501253549953, -0.11904191232133295, -0.037079514078331523, -0.009041129831261761, -0.020572790126535706, 0.17960475586566377, -0.12465339629999053, 0.16835935775374794, 0.045953534485841156, -0.12326856843326385, 0.22309740854881752, 0.044306922562180454, 0.20028616325774484, -0.086876942444398933, -0.23755478578557293, -0.007626888003929062, -0.2751176634642758, 0.24437732761047104, -0.24812549320699565, -0.1580002719904057, -0.22719551568938801, -0.22449736796503636, -0.091545431622566426, -0.39367619380504493, 0.43558082751703514, -0.40988155406653876, 0.14508875157319195, 0.22854804828725428, -0.24599842038800493, 0.21820187252520876, 0.039146395484567484, -0.48622236018992981, -0.015869282879548533, -0.0274347166994879, 0.071614620283993735, 0.10426684196552666, -0.13952709868787685, -0.40101007789889659, -0.018607329992861108, -0.4127209627834354, 0.10713056287478885, 0.033407141765430054, -0.19459328571853007, -0.27258985957402937],
                             [0.057553509895111543, -0.068670057983347479, -0.19266046389627392, 0.28921663998701214, -0.2805378027523045, 0.35788921555442749, 0.065496304401215122, 0.3659479062484513, 0.15864914371035985, -0.045291960553437552, -0.18404757411411482, 0.17951689661001366, 0.093563563751058579, -0.26038610174659166, 0.031703080275031444, -0.10018354816645395, 0.11081612092122579, 0.23898474631822714, -0.12887872625275384, -0.20181941439841738, -0.16386104737593121, 0.2034650293825977, 0.11424479630245793, -0.022890832906128981, -0.012799278193656852, -0.070255639503291417, 0.14070432289680271, 0.17915935811988565, -0.27330571497070832, 0.012989979283877674, 0.050219156758931502, -0.30782574489319875, -0.14376511098418404, 0.076655164512013707, 0.37484119385584996, -0.0056544320169696679, 0.090455118095068912, 0.39945558566782757, -0.44204584904206828, -0.074737685444287744, -0.034222135493509574, 0.17082330603718868, 0.43225534264586801, -0.20455943005586674, -0.45906382816618713, 0.030485829651775626, -0.091120863395555307, -0.29705075840340051, -0.35996454137440503, 0.050416278875789602],
                             [-0.061021328193749676, -0.26010898937911453, -0.186008980236396, -0.088522095107603685, -0.092858260719294233, -0.63374380126862118, -0.10940185667328461, 0.28765455553161634, 0.46996237136743585, -0.22997959417250188, -0.30625709195499101, 0.022653429406610037, -0.042208422430756697, -0.41777797173148723, -0.21667534276720357, 0.00048369375424324717, -0.12102712873755522, 0.14871384919505612, 0.16669036329836343, 0.062200287643971272, 0.079217149235950399, -0.19857348580878428, 0.024708938311493948, -0.0094467918649275753, -0.28144505478913423, -0.17399797830987249, -0.16073913931323233, -0.11539971010478628, 0.025270516099212565, -0.19841757283737299, 0.059565278558245865, -0.092308090613058336, -0.019709201741561579, 0.32875012548103733, -0.26736577607243855, -0.26610066013413097, -0.067687763384256028, 0.30975645586157302, 0.11903010574231694, -0.30318005816369842, 0.051298002099874861, -0.14357661843754091, -0.028594113748411792, -0.075932996226243998, 0.083372084144451963, -0.14155206546671006, -0.11495047971372636, 0.09524207443523694, -0.16429392173148807, 0.080407757648810141],
                             [-0.22151206453563918, -0.19910021092586669, -0.14172350549700508, -0.036573707839692403, -0.37231176196890553, -0.26683952807904926, 0.12761306893329921, -0.35436838239353513, 0.27639825405119522, -0.079646796599963876, -0.089164754330285048, 0.13627709701505672, -0.0059470759717704814, 0.22381917523826594, 0.24119594980686579, -0.13265930329140338, -0.076724111622965427, 0.071918706999609838, -0.14160098237694702, 0.063421816919021157, 0.29671682638783575, 0.069043479293326923, 0.22248068906934948, -0.1658685358091273, 0.116398941496049, -0.19660420744330057, -0.071256140493739045, 0.18401078692154677, -0.19231168846046576, -0.002799802947733904, 0.46459607946804721, -0.090407416663516413, -0.26650540229050718, 0.061386844254046946, -0.20754725206192898, 0.30823300918998936, -0.15860701820522638, 0.13510775270530842, 0.26593294106718285, -0.24751283430784735, -0.092657202727471286, -0.11247982740394188, 0.44710749953956636, -0.035297293907916562, 0.22680768167965951, 0.086888401059322717, 0.10713447694154377, -0.26190024614156632, 0.44930165277699324, 0.27216024809161304],
                             [-0.24226138819795381, -0.1022531122042931, 0.3172226683738264, -0.52766549052017908, -0.25866054975271191, 0.19849770243504145, 0.26953940402613291, 0.25600294876567853, -0.044053647068373843, -0.12822790806040835, -0.10744022555550344, -0.35755254237854417, -0.21001765917068255, -0.036607587829689925, -0.22145875905586498, -0.19772694657737366, -0.046585010068998928, -0.17997188063782232, 0.24640359761207872, 0.21487270916968504, 0.026672000443685295, -0.13203916783498218, 0.24514994659049244, 0.099625565239982228, -0.17335858637007409, 0.072532040168415857, 0.095681729220850234, -0.28413996329868829, 0.20233088027838306, 0.29908293969221322, -0.13341762905629295, -0.29974756487798349, 0.25210331825626014, 0.21286349436563398, 0.10528811252587746, 0.052704386449197879, -0.18794642809974726, -0.1677767400063738, 0.20661508114591273, -0.007816499954217529, -0.016436483278671438, 0.29683705975254859, 0.030221076654490836, -0.12255201043129668, -0.15702890893770588, -0.25921290025883947, 0.30899273035475666, -0.08725710597443255, 0.054768019790494567, 0.15425187620750166],
                             [0.017951722556141303, -0.10205050021737432, 0.010683601230301126, -0.032271702616256684, -0.41106330192206636, -0.23466107729565977, 0.15941113778280658, -0.26864572958297978, 0.11700492673560631, -0.11079181223559753, 0.029531111480731412, -0.076359386509444988, -0.46889656136610292, -0.26530434954736892, -0.082856440036897183, 0.090942467157466025, -0.086353009730122096, -0.072693849899935381, -0.32844345609572045, -0.10664906349483178, -0.052464400726006707, -0.18588112120450237, -0.3136134124874419, -0.017250197419492942, 0.37544776488575404, 0.039054096561908835, -0.065702330597499387, -0.15664993665181848, 0.051925908783203953, -0.20225350087593169, -0.11323299769079673, 0.40258339828233936, -0.0085765425390447562, 0.021404966777347545, 0.021172468355533436, 0.10104090583713536, -0.45047247752448594, -0.14332107729730492, 0.091559186518886254, 0.35412007091486641, -0.39649063987769639, 0.1252535462603675, 0.076391221179208768, 0.066987050479116031, -0.25142596638051173, -0.035331603120393365, -0.011515925245947647, -0.0093482913288010713, -0.25435083748699716, -0.11565759957757762],
                             [0.10343596562624628, -0.0032316743271789614, -0.024991576252832829, 0.28834051160747493, -0.14453485506412506, 0.055560151407822257, 0.11219200565298314, 0.052672829018844465, -0.37476812496176476, -0.13784017614661531, -0.38685440580573588, 0.11136470416740714, 0.0029103750704697548, -0.17440055391437867, -0.34832780706036781, 0.045121820100255193, 0.20365622145548401, -0.17322334797667902, 0.088586747934335922, 0.15448800756411121, 0.011120710590418146, -0.16458890808393017, 0.28731627406202559, -0.14626481257085111, 0.01113854504234638, 0.20675728924992329, -0.082484572969227343, -0.20858997838049811, -0.37557271544060095, -0.38468913461070009, -0.10008162377818286, 0.14217241884394588, -0.14170899575766208, -0.4572267790522016, 0.05960995690523245, 0.13598417661700193, -0.14165397792435533, -0.028373592337541026, 0.072530340136316429, 0.025891408265976478, 0.14447858243032596, -0.05428997981585082, -0.064512079589624183, -0.020120015366336987, 0.0022226364390728198, -0.16429408328411171, 0.36356745996310064, 0.05389998112553028, 0.15439608161416382, 0.65450432123106228],
                             [0.080912480852257121, 0.39702572094621447, -0.069476472604250716, -0.17028042072003263, -0.044160815475810675, -0.40918284407814975, 0.019994054193566646, 0.24753411332693795, -0.066369735711698324, 0.22345677112716739, -0.062391220096095712, -0.40682817522764941, -0.03368900695348849, 0.079974420418526704, -0.098700948917238393, -0.16595412960631931, 0.38658122276236107, -0.061908971791991244, -0.35732328169383343, -0.036293088883581716, 0.35122003456583462, -0.0020841093260302972, -0.15507271665515532, 0.011955549682863588, -0.27912959651474456, 0.18321185972396906, -0.34779734001914381, 0.099354848435038667, -0.055528640323858403, 0.091811529555154842, 0.14604010711339041, -0.064226504184021899, -0.31748280427832798, 0.033723098367613391, 0.22206427586367075, 0.038393279972377042, 0.10056877327478307, 0.090649859225859705, 0.023406536473261602, 0.32164719643305756, -0.044251869746434538, -0.028461210447993872, 0.11716965720408297, 0.065300793174006166, -0.30644617804961194, 0.099701946977540687, -0.042353612713554797, 0.45313701745871876, 0.19116211813725317, -0.12414699983125112],
                             [0.30706518612839562, -0.035720200274964142, 0.17639768620892762, -0.24032896765228209, 0.39474424791440937, 0.088903559890107148, -0.076145460201666043, 0.055917416198478218, 0.11927476629814157, -0.24034551311575389, -0.080874419308184758, -0.04731104155057117, -0.083191705529259308, 0.18563245052003943, -0.36286320990064247, -0.050830840288213539, 0.027807236662996098, 0.036675215643395737, -0.18530914193964793, -0.23534153156366883, 0.18601394910788621, 0.071769326403692935, -0.089019963721732182, 0.1803175580822429, 0.24934312639415326, 0.0033242862644397679, 0.026087465351643857, -0.28727725210741084, 0.10181527671149795, -0.2264363664545769, 0.33663902084241154, 0.18041175842200352, -0.077410622583141311, 0.073617346301031228, 0.36816887098044376, 0.086607092919399414, -0.043445477421026037, 0.18150917084407184, -0.12715666811682122, -0.061853762516925287, -0.12375286965557544, 0.22610043715412143, 0.061561978755785153, 0.013403060818229855, 0.29105734770793285, 0.14307704329545248, -0.39401659085762225, 0.18884846068916578, -0.2480145871285267, 0.48518971501138203],
                             [-0.14513852261612234, -0.36143059080211892, -0.099106962580811378, 0.075519609492768966, 0.33529468020372044, 0.31751885034470873, 0.012722006831112732, 0.21602802503551669, 0.13328292149503845, 0.14423926266798431, -0.050995412557049015, -0.24349377155010282, 0.12925500987817606, 0.073998964004488132, 0.19573734920885844, 0.18336182252049454, -0.39553622454399795, -0.16742010319992209, -0.068394879466088992, -0.021565418149743314, -0.069088448254354812, -0.17678117043071667, -0.30681954259190769, 0.071367865901276709, -0.017513983820858364, 0.19241322546194736, -0.09285524342767941, -0.31908228993649612, -0.44115423740269066, -0.14672846200356046, 0.21283629932821094, 0.1970846511685577, -0.013128560273951841, -0.1374662834712557, 0.004266324709236255, 0.13084566077306559, 0.14249636913725791, 0.31004282080790913, 0.056303802833701205, -0.21681409951455743, -0.057574468993813063, 0.14895368874612286, 0.047375131219136203, 0.18878692309668288, -0.067437314044094102, -0.032482425684683416, -0.034703682314068722, 0.3058671359141123, 0.33614431308525311, -0.26407223065969626],
                             [0.61611392377574836, -0.043469853982055724, 0.19309105910534552, -0.37473228671718578, -0.18028243128884389, 0.077302081600151867, 0.0086190231217959865, -0.15516679460370464, -0.080814972649970521, 0.1696370371549063, 0.040534489560536992, 0.032721309143362874, 0.13962676931574908, -0.18115427729069575, 0.21077685302515065, -0.41511447888462727, -0.0033037627812110178, -0.12841813840515523, -0.19062403276492806, -0.056576285275498295, -0.017904349631619743, -0.39913222206115112, 0.017397019995775295, -0.4477737741428004, -0.05369806236904795, 0.077018415115723576, 0.10943066740277761, -0.38892257669978864, -0.13525519617522216, -0.10703400499222349, -0.1740500279953599, -0.25306402306587922, 0.17495526072816509, -0.10127590210922272, -0.32678344045109542, -0.08716093738945653, -0.039855912530410445, 0.23567011132648549, -0.12046146611976169, 0.23775933205900152, 0.49578486915234876, 0.18506694259783074, 0.011895316266949053, -0.16190710289428883, -0.2226531825880354, 0.13766793058388244, 0.082978556691590044, -0.15491726152164162, 0.063696966848057146, -0.086327828196569367],
                             [-0.063811275330629191, 0.026505322040980626, -0.0051943175438619871, -0.29783410241594205, -0.3436309756573166, -0.076599044840757635, 0.084303824921547352, 0.091588922452171026, -0.35005264782468243, -0.14623041099439599, 0.27219192013198912, 0.28366220329474401, 0.039608325109979352, 0.13294001499360678, -0.30772918716185077, -0.018511153480015655, -0.045819150926761941, -0.10697030045113796, 0.23542021856960668, 0.099811229385400699, -0.097738635088082518, 0.15742032367877734, 0.077736456985276592, 0.27681551472437504, 0.053923477198944955, 0.088508714338106073, -0.32201663897823096, 0.17153995572628644, -0.060158903701369511, -0.27247202706201856, 0.18192716041991597, 0.26106380887464559, -0.02103285891493966, -0.07464512803136919, -0.17384244971029053, -0.30007645378873615, -0.10781799758525765, 0.48145459257435796, 0.034935839497044777, 0.04903364239323578, 0.19438789552192443, 0.54445389680168965, -0.033836758147819709, 0.11989640763088523, 0.15692631444289601, 0.4181843890342804, 0.12631817589641828, -0.078390250717762705, 0.076250414777481623, -0.40057656673788028],
                             [0.086129713673325697, -0.053871544110783987, -0.23146439065117896, -0.15565673802168073, 0.16430454617033119, -0.21094829109798463, 0.21802015534215008, 0.13679778626091829, 0.038877434482762971, 0.11982190490052202, -0.12390711001354707, -0.053575155986445577, 0.022474849090554434, -0.14360255445758044, 0.090478154640565731, -0.021866575742763138, -0.097980054175232853, -0.074273064656605256, -0.13094063309794951, -0.27765451849062583, -0.24698394233188486, -0.073274521518032126, 0.14939597814967295, -0.29796907516116927, -0.34993683323497071, 0.073016465115043117, -0.5219273425069374, -0.056244370348229863, 0.21187269012558363, 0.068566621924209842, -0.15189405367545766, 0.053068996857321943, -0.006566009241354271, -0.0047630594321203534, 0.14341268952086697, 0.15553606696496916, 0.63522136266029916, -0.14579972935395949, 0.098733609598548794, 0.13238390342017056, -0.2243834978769958, 0.46210369514589117, 0.21732613570275791, -0.020119987146975955, 0.27383246762122343, 0.071369576721642985, -0.15812802736624004, -0.19553316664607634, -0.090902126175292253, -0.12867823468043116],
                             [-0.25440816203041056, -0.093396172900710311, -0.28354044730397576, -0.16219559669065858, 0.015965866066823167, -0.076198153436159641, 0.14382998548184356, -0.061070287994020984, 0.32094076287985718, 0.16590233529047638, 0.028893416635572239, 0.050930063256176189, 0.16896816403297385, 0.09346084117484145, -0.2288590918195906, -0.78507852911718878, -0.15760002292700298, 0.2501481069898922, 0.16155193438547102, -0.090814492969304814, -0.36451107835768448, 0.053857312400779962, -0.14914945704144156, 0.085890973641163132, -0.18206966242880313, -0.086734735337653024, 0.0018937800453377313, -0.044715572457333701, 0.20394445520954768, 0.14687369870646097, -0.01970560928777923, 0.27884999875765681, 0.23635607580104404, -0.23990221698232933, 0.028106292425397795, 0.33386906420233137, -0.049035986155184993, 0.00079607271883976993, -0.31037383638536808, 0.1329248784938919, 0.13244343197734917, -0.31371932853825563, -0.21168453808572402, -0.036059420430680597, -0.093890060757090082, 0.23218333122107337, 0.12888456473749446, 0.090025960224837775, -0.14242200562591772, 0.32416260242567774],
                             [0.099806757371374524, 0.1535936464872249, -0.19400250309558448, -0.36070065486241754, 0.22302607301469166, -0.31086717907327749, 0.04907692442842912, -0.082229727219640766, -0.20694125457294568, -0.04494206366202759, 0.046897080514603659, 0.052497990661852123, -0.041307419776978986, 0.36379059068472563, -0.00012747662131855873, -0.0057203922578201033, -0.13502581993344259, -0.036058842562321586, -0.13408860657566801, -0.093693656160435596, -0.071580689828455446, 0.14390907045020404, -0.027050674599884722, 0.1525273414312435, 0.26461941519461452, -0.32197579697876283, 0.085605324530035845, -0.12647297647331934, 0.047454980728565258, -0.10131071599587582, -0.26862252264590925, 0.077912739351597218, 0.018315963743383991, -0.28433067149008995, 0.34531432803375389, -0.21358003674627174, -0.04613351687125905, 0.35612398301703824, -0.11742905713027535, -0.045302384564477473, -0.068668443802811091, -0.27167356675402843, 0.068953756699495383, -0.12620913666564404, -0.15642341400186266, -0.66041567784742117, 0.25442210981819013, -0.30402297966026798, 0.2157304238197966, -0.002222727430079896],
                             [0.10499722925395455, 0.10436874456768996, 0.37781729338474002, 0.18413267738000147, -0.034284629452172255, -0.2376668174141372, 0.012664906707048895, 0.12854991222876186, 0.035325742821770055, -0.12376496577431276, 0.22950390374818938, -0.090495970470907877, -0.14612550620878717, 0.036933739163566223, 0.0069097821500247961, -0.48907223166401903, -0.10796072195197538, -0.31559762773954925, 0.022804017072161016, -0.30287419305874796, -0.53533591070901798, -0.1325739365371538, -0.059728054036118111, 0.14728031089480983, 0.042579695321791053, -0.23654322465591454, 0.044243565553381048, 0.38340704063109782, -0.32415387676223933, 0.23942338090211024, -0.2022544315383091, -0.25879640970458612, -0.1594654083934274, -0.065916507588031484, -0.25795340909857373, -0.16575553912364988, 0.14571218056736274, -0.036813127472807322, 0.071786180399581873, -0.10391739422120794, -0.36210730044912914, 0.21753876123430632, -0.097923218228367775, 0.21345226551691493, 0.3076420266577235, 0.016428487725012722, 0.075959545013324817, 0.29060830638412666, -0.0049942131965795694, 0.080972205680046636],
                             [0.11216803974064828, 0.051596488290004655, -0.0072175760731793583, -0.088500810720462009, -0.012509156811378005, 0.029857050380708784, 0.4002796655867551, 0.1938503045428816, 0.16571362507420295, -0.4489856527151499, 0.18237575636183362, -0.53809798642165207, 0.044336221642607226, 0.40196449092516273, 0.27380221226932255, 0.21705757279324167, -0.073528942943297204, 0.65597092344208896, 0.0068466001446414251, 0.18721446332663125, -0.15816724167777987, -0.29369467886379996, 0.0259856290120071, -0.012382097391226634, 0.18085063091282796, 0.00092073629813223257, 0.00090309387243385584, -0.060090647226084218, 0.061913814726827901, -0.10365702106713173, 0.18891334383581976, 0.16739872361664093, 0.087040649834015854, -0.18195753750091914, -0.082364943608708149, -0.3822120996501745, 0.045807667813959424, -0.24612630384870948, 0.16855997181626639, 0.10780446245978273, 0.0192328525293777, 0.042007756758780199, 0.073450599480125403, -0.12996368276984085, 0.029073239348558801, 0.063941519110465334, -0.098494898709727774, -0.19572853013280517, 0.10570762033652362, 0.014936876352220487],
                             [0.10388674592219134, -0.18594144578813368, 0.47266682495094547, 0.3559554714960208, 0.16078797857878807, -0.46388887705485632, -0.34636425130055754, 0.018141466122801916, 0.14448615860856523, -0.17905543397164797, 0.004392004086738132, -0.032173493203931841, 0.16380465688485979, 0.02289066305697763, 0.045676710126254044, -0.14629859589141034, 0.051957805374931901, -0.2135952721306158, 0.28357733218490022, -0.043791880685528556, 0.039605285193597482, 0.13673870707241867, -0.0085741661656360997, 0.30760468448078715, 0.08582108932795797, 0.17875178243266951, 0.15117134766211843, -0.14843805055980602, 0.087217545666930837, 0.10883164551303144, 0.01977372859287602, 0.40363018367369191, -0.25723748243090955, -0.34789045300756721, 0.1362632958657061, 0.06985522745506853, 0.24061414629960173, -0.18555175002503907, 0.054881155769876698, 0.026051483806989753, 0.30969561942473911, 0.12850877872139535, 0.16695269984369479, -0.28059651077559417, 0.093712603841622583, -0.015934584737186008, 0.1882331389462984, -0.23782996524928493, 0.067456758690838045, -0.35324743010205772],
                             [-0.073909050067037629, -0.11787282599450644, 0.37524767811169912, 0.19844345022222837, 0.11992308775074344, -0.025760145428234821, -0.07088250069964358, -0.10984309539075986, -0.42922062892206642, -0.011024578337976028, -0.026300385818919809, -0.26160609910515614, -0.2956356202961456, 0.11478579784112722, 0.35491514743004388, -0.079423012207320218, -0.3983066250421089, -0.13934040187065855, 0.2456258894758406, -0.019711978906425193, -0.08475792176599567, 0.11468693701100821, 0.096679328495837449, -0.16308366672105384, -0.43806362437248486, -0.22139806778179602, -0.16330825970846738, 0.21027064828981926, 0.0948114440109456, -0.32922481056337793, 0.053050199848595242, -0.046301109532982221, -0.042956049585255549, 0.076875698335350226, 0.0048712095940104142, 0.1555453054012895, -0.19266143019863974, 0.32049966395016977, 0.28628245414474701, 0.29766681544721851, 0.032626738116746275, -0.1277860958109916, -0.11418504451078242, -0.25835298324157085, -0.16715770547601413, 0.23232582626434978, 0.0063125902423007219, -0.056275752049406561, -0.36587552727494072, 0.1353452392828782],
                             [0.2683090616311552, -0.3818788187716915, 0.051525456155186361, -0.3715857097705727, -0.39784978367388557, 0.17317025233815347, -0.15528146123921899, 0.18720467054735571, -0.077086912380948253, -0.25313852298338779, 0.19815967063717263, 0.35932985411268348, 0.22658035101371832, 0.062978909924960996, 0.34473203640705308, 0.023709533171548763, -0.077657297092821598, 0.042508587050932627, 0.089431871830677134, 0.066684693172610499, 0.049916317278286354, 0.21206054677357936, 0.2077597803604164, 0.04397903655113574, -0.16656501964469089, -0.00026859065765459135, 0.050610892003220893, -0.17426590940074038, -0.074701891307015822, 0.046419573653157346, 0.08816585777743273, -0.09340305102733952, -0.19081735748680562, -0.16904027515658532, 0.19138698943444246, -0.15636147607994338, 0.27154793304895886, -0.08758989529163709, 0.21667411006696263, 0.29170541654487542, -0.29378346067918204, -0.27832270942333465, -0.10325110572985265, -0.068844351064188777, 0.19474731189843128, -0.062917996548919997, 0.12686850742472597, 0.40136637125483843, -0.19580900560330627, -0.16331694047194645],
                             [0.078509592294695424, 0.055485908254930529, -0.12850775811202597, -0.14954007695504676, -0.15366903841231652, 0.18158918262856355, -0.070699737954795561, -0.32290552522567928, 0.13599318914224029, 0.1212213999367821, -0.29644897366808032, -0.1677686624190346, 0.089882438892879099, 0.14471722519499255, 0.034120976480124791, -0.067941652559555213, 0.1644662678556239, 0.13354796482806708, 0.20196798982955483, -0.19644481141076667, -0.042536912232439272, -0.040201352596756751, -0.14431808493974799, -0.11083820813543342, 0.43929409563882388, 0.48126271355667366, 0.074188374675419791, 0.37042959198136199, -0.086894883808566914, -0.10659039281614517, -0.096615772601199537, 0.27399225537590238, -0.27669926356085794, 0.30509575096718689, 0.30126015359755981, -0.1572527903704603, 0.42805741903534661, 0.18415506628272402, 0.52133525821165205, -0.32369986319246657, 0.075854480503065994, 0.12658047368821118, -0.27559257474503651, -0.20042564171185384, -0.023894974701974121, -0.045013242335485835, 0.090968796157420456, 0.18036731448029139, 0.21564548227824107, 0.089700093920764723],
                             [0.051732086482420982, -0.2785762883959455, 0.10560123981150406, 0.18427424895266825, -0.051477768705544512, 0.16576562409399692, 0.61431428469621041, -0.18132814227809818, -0.16843434993918466, 0.29220814182093635, 0.19322747920133501, -0.18663875513149497, 0.48237848937168959, -0.0044741376207214321, -0.13592979432846314, -0.32185457735617284, 0.1632427412058145, -0.070726478956069677, -0.15759322591105338, 0.080830328888439718, 0.46202690787324718, -0.13707121782516626, -0.014529896884918169, 0.076453787918133648, -0.29745344889254771, -0.26996169395143127, 0.0040672019151229023, 0.046826378845262522, 0.048987406995760471, -0.28780415788016839, -0.39931717568369923, 0.026203855343150839, -0.073361807719636685, 0.0058625464603077361, 0.22323343653966424, -0.11225938271380911, -0.20739455593411077, 0.036363958418912906, -0.072742993309555859, -0.17310585976350973, -0.26967476403042123, 0.21535549701148937, -0.17706678181058025, -0.069302623398692198, 0.23503166729416483, 0.10713414536940709, 0.11871953124305069, 0.088767728879266095, -0.089170856150139921, -0.2322793565589209],
                             [0.046093307184255715, 0.1019446286563674, 0.039279989106133159, 0.27624049172635856, -0.11574701543501061, -0.10490750443195253, 0.072862557598856389, 0.12478721735234262, 0.053264771485885543, 0.22306134241883832, 0.26937985387121061, -0.11847885878893388, -0.23994309879410594, -0.2729626118044855, 0.26992152041226919, -0.16177855001238101, -0.075005740893299047, 0.037274121873203878, 0.048471726867360135, -0.33762319979685124, -0.17883843599750657, 0.29938858362059223, -0.1354620476027418, 0.28827387139620719, -0.28166289953842233, 0.18510097195904371, 0.14648512805730404, -0.17464065751600838, 0.36208000166162824, -0.30026039327083398, 0.10835351785716696, -0.11808655112047335, 0.15631775267428705, 0.005210339653440331, 0.23235514109778699, -0.1545114583855095, -0.11255853763886189, 0.061576034669995602, 0.095010854811864151, 0.11454416522397362, -0.13367864894862116, -0.23478856543426163, -0.056546657774328227, 0.37233304437678072, 0.29724562642850955, 0.16191991610159359, -0.060156421964794517, -0.25892012072411708, 0.48769553234946539, 0.066391848566330611],
                             [-0.094388831904170495, -0.026848203843458915, 0.36284975984232631, 0.15039391935648161, 0.16684156564293792, -0.22617272598153704, 0.30343206383368554, -0.0099270785396629625, -0.22911720352957687, -0.058895049993591214, 0.098749861081971813, 0.1671266567323535, 0.02006779797226315, -0.1632540440892872, -0.2550679435384674, 0.28464082544187536, 0.12145866246046935, 0.34300481009447209, -0.27574484418039247, -0.011016044861632572, -0.25186821404321907, -0.09885095799762296, -0.057864933373167886, -0.29799793481211617, 0.15724498997058262, -0.011143655439784687, 0.025915970523852711, -0.00072762177828675917, 0.037292925567314748, 0.3821528566240997, 0.18067603799036847, 0.10939642005049707, 0.15144162760691443, 0.3700767354166325, 0.088525174295631184, 0.29366850206041045, -0.14778112332798482, 0.32941103342332861, -0.078523270255204766, 0.089761306839513388, 0.039998326697023141, -0.050518537775389158, 0.054325760006741983, -0.30976859749598307, 0.55233032089718592, -0.011619369017392626, 0.45209215454737134, 0.3182647210833176, -0.0081146890443171381, -0.18514061927400094],
                             [0.078703550949093662, 0.11525204358504954, -0.29424755842452965, 0.029804349616285288, 0.03117610463763832, 0.16884422451483372, -0.28124527652160652, -0.045323667973762978, -0.0086531747592145745, -0.41544373186858713, -0.33858491377532762, 0.066796521306880838, -0.13387989887994758, -0.062908945915824688, -0.046120783505217811, 0.071915606840513735, -0.1525516904395815, 0.22919336978510707, 0.055588776229831882, -0.23629716617271754, 0.095020542883164597, -0.40544071709233598, -0.32912478530886258, -0.25712262746267361, -0.40843971247168492, -0.38888486620266544, 0.23909096231234986, 0.27239295229968213, 0.2149291114800477, -0.031794128544953205, 0.1064729924198804, -0.063648867115304986, -0.15241230768378131, 0.02022250859864122, 0.28266559606454056, 0.10004958331588353, -0.14402209082417033, -0.15562423680684256, 0.16680059257596597, 0.27140702068075973, 0.032062446215740954, 0.32331592603755077, 0.032211993920688471, 0.44967905589438828, -0.023047838543190417, 0.037782461250646535, 0.40553158919661281, 0.0391827674079928, 0.066002248906396069, -0.29865756557850737],
                             [-0.2718901009979568, 0.20335220594098671, -0.031846079473634673, 0.24486885693007648, -0.14988029817893608, 0.0052282464160897414, 0.010465895607261799, 0.022595615786514044, 0.15046110809000143, -0.37737001830754513, 0.12977516326095312, -0.085916448547469507, 0.61686347068105607, 0.13278454827080258, 0.089913002739654468, 0.14851462168686352, -0.033504038885560798, -0.29274489487226102, 0.00077591032501500568, -0.54327047685783725, 0.016988837046390058, 0.0030006771466089127, -0.16019374072799852, -0.10168548864518467, 0.08674066315929202, 0.20038014557575726, -0.38235973137506274, -0.14404000670696443, 0.42898995505451365, -0.012982154457817259, -0.16262674892784076, -0.36691320011880557, 0.28142719434554669, -0.10350036823878782, -0.076280074614916066, -0.0050177641899442566, 0.012467674520480112, 0.022255156343486591, 0.11399387786524739, 0.16423194068376654, 0.28703691484382921, -0.017102844146681888, 0.033180276624806361, 0.18927935366963414, -0.25575920810318731, -0.0048421045887825157, 0.23924850548349727, 0.21334414916058472, -0.21256892412723091, 0.022351454081254683],
                             [0.030610266523750283, 0.42750567614034068, 0.16732050513536029, 0.20476194822166566, 0.012352123544562492, 0.27785587754964891, 0.11575836310369748, 0.036387419946094707, 0.35375995957829615, 0.1787455721993681, -0.1863750568547809, 0.067471128050432233, -0.22149559025248403, -0.049983369072278155, -0.00015016639316198493, 0.10676539871500515, -0.020104098003800128, 0.19349344424553902, 0.17363069461474079, -0.0071728809107327743, 0.1431483996500878, 0.25068602549709051, 0.28430170543054661, -0.050874483895194632, -0.065011027947516176, -0.3363044720690388, 0.25853532626016407, -0.24656440579637653, 0.13007634915166336, -0.057291850855370828, -0.10556598975484248, 0.11558073900616013, -0.19876065677622975, -0.28718154094080633, -0.48464742519143006, 0.072266348045503317, 0.10963084861038544, 0.25342360789067098, 0.23304620176383123, 0.030500462188620004, -0.17995746963726889, 0.15352737628586052, -0.2389995981494937, 0.06950675060261044, -0.11737245981553673, -0.086857834364979888, 0.12043691225239277, 0.19761939705524731, -0.015771990625156, -0.15076996107699719],
                             [0.25056301108353168, 0.24570909222313231, -0.22478066592641116, 0.039426392350207597, -0.13335436813615911, 0.10507517749003145, 0.029091722466123463, 0.0099832325622619192, 0.14522306025968232, -0.049752026186167232, 0.076423835049460626, -0.33704835882843409, 0.037792164265165851, 0.093246913827739253, 0.24423128573786387, 0.066663902424669463, -0.098284014045633292, -0.50840257925616006, 0.12835792608740207, 0.12432584312018159, -0.24003569614452938, -0.19165678930339441, 0.5915629556621087, 0.084118815160421051, 0.20644516148136605, 0.29562550867951043, 0.041570254683182095, 0.16979301185349605, 0.4304553999573727, -0.11551079642288739, 0.29456473285624024, -0.098377426788178846, -0.048959273956382839, -0.095267913929922454, -0.041901250993365967, 0.29950841204389367, -0.043301706473726331, 0.20093234904865925, -0.42820712362227059, -0.17524589884659361, -0.16866017812129308, -0.21477222220414671, -0.071273227463080777, 0.13865631034824319, 0.094860541673565169, -0.00060356905144748341, 0.30217949753215806, 0.19618269886987738, -0.21609880459459554, -0.32512628358301282],
                             [0.1796598404490172, 0.23294511350854746, -0.10327128754026532, -0.21046930637706049, -0.078184610395834658, -0.14165591906185418, 0.19721541267035553, -0.061856688096149345, 0.0027795001002573396, -0.039536669225946175, 0.07866629949591103, -0.071768387277757834, -0.042942718175836336, 0.22168299204736583, 0.13942428189950237, 0.492351842670599, 0.052360790127107176, -0.12499631898180438, 0.27823907347426391, -0.041968553627450729, 0.016766064983227736, -0.15144221382950726, -0.40826398899329019, 0.11509114388160463, -0.34448665720109439, -0.15797945418705883, 0.073329660841370881, -0.48826911629448377, -0.17336703649846122, 0.17352953197822024, 0.035633857808981498, 0.15151074989779573, -0.1816033365104523, 0.38505779884240571, -0.12431673639839935, 0.062835808749452146, 0.1944037948329802, 0.0052440923649841424, -0.1401181451588781, -0.12536385116875109, -0.081172980100085917, -0.043621532142890225, 0.093187856507577285, 0.1239471958818039, 0.12169522245966882, 0.27821358006117164, 0.3964640399062947, -0.33134030333550213, -0.20701046194926545, 0.27101597544174871],
                             [0.13055811693648881, 0.037268716901868344, -0.18367706269631945, 0.19688623980396697, -0.22120275364642158, 0.0081842964988475264, -0.11624100792010274, 0.0446703632254783, -0.41208063479751583, 0.18314710449516264, 0.39693726581765126, -0.015413843942563954, -0.080868373771809027, -0.1984086841981432, 0.31411234326468024, -0.052592133549755074, -0.16376749053979336, 0.23880515086256354, -0.020229373089636495, -0.057958608778718015, 0.15931835988224119, -0.28536044043289205, 0.041143433782755048, 0.48232444437646266, 0.18731119761635917, -0.12251808621406361, -0.049039826553376117, 0.038062790817583465, 0.48031439930710695, 0.28845284637205104, 0.12773737867346655, 0.069845247871762661, -0.2089764273480291, -0.18263733408517818, -0.093731813046263684, 0.2116815459149626, -0.10812198634767556, 0.15683660599448321, 0.23100435412334477, -0.29327635997281021, 0.18661307366486904, 0.31454767929662725, -0.15318999332023803, 0.015017381491181977, -0.11192133261396081, -0.15713203376680185, -0.12993977897071415, 0.13824934184407667, -0.0038364629205027284, 0.18602591057556067]],
                            [[-0.0058613177862906572, 0.090449187748324195, -0.17177161544513281, -0.064193933495671401, 0.12634048867413825, 0.31618190927124157, 0.22944119022266526, -0.30390150117358122, -0.084037449058515512, -0.35468167151541174, 0.10469533000425665, -0.018479005845906477, 0.36584621860267524, -0.25618672253737296, 0.078539099923511976, -0.2019350141594114, -0.15932969319942331, 0.12719234122812895, -0.19272511393861513, 0.0025519312139968189, -0.32012766961184513, 0.26873228453116166, 0.10319273100711855, 0.063111927380910843, 0.29344068287965858, 0.27781311933829328, -0.016391486289640052, -0.066529703445629265, -0.57981585623675724, 0.74024306655123284, -0.28333177325968595, 0.31529775792323878, 0.028975625461320553, -0.32175878575348243, -0.17531029123483913, 0.12336793630119268, -0.10662267155646325, 0.44912151728971789, -0.05257682308926577, -0.45828492892270317, 0.14196320211444516, -0.38836427125386391, 0.31798620063882288, 0.58352272711760966, -0.41381159494927372, -0.16526070235166351, 0.47199617579041758, -0.13790693546706798, -0.015329262502279133, -0.051169523107441592],
                             [0.24570262261231385, -0.019240376321476817, -0.11903326193507664, 0.40771602003106561, 0.18428454514157619, -0.071073246426445372, -0.33230635739605963, -0.088202454375602563, 0.34468231013563499, 0.74536713354317852, -0.10663839097863993, 0.35112410684222223, -0.32683068174686292, 0.35678846503906159, 0.062108589138298836, -0.092570464787000081, -0.1882692786345273, 0.32907075087193444, 0.12732789783338716, -0.073114445456744809, 0.17149345095573859, -0.2436957147364579, -0.33569180088000189, -0.58172854201438917, 0.17857768082468314, 0.4455637246711675, 0.23540913616039413, 0.46786637510374024, -0.027706995917730928, -0.098419415123562878, -0.3910955147193993, -0.060751927668627331, -0.48972210667644889, 0.012517317046067176, -0.32822974057922516, -0.06550637749055542, -0.23301905190804903, 0.25732678714806917, 0.27542897112149661, -0.24105876299076714, 0.071819520394008685, 0.23791788927053364, 0.045980146391730883, -0.016036118516477994, 0.16765559029630211, -0.59483004169384934, 0.30463040040257222, 0.064942784612953372, -0.078813953840327966, 0.32440932164351616],
                             [-0.098624947314179479, -0.10603738969775088, 0.075167083874386337, -0.30205996058842066, 0.35322389549138267, 0.13377196460528218, -0.25559422412896454, 0.17445031507382702, 0.13604350009321722, 0.37721293879452655, 0.44143730171789231, -0.07744097666086612, -0.32323208411865612, -0.26267035631611352, -0.098028553295875662, -0.074464401991102783, 0.02137177142827492, 0.39831046536455778, -0.1309528106955663, 0.19203438018219463, -0.1277862304266858, 0.30862085359445052, 0.11948595931951606, 0.31047448530866223, 0.15507760188228636, -0.23618241840639559, -0.16946623328598207, 0.49641790462865171, 0.011137965370981552, 0.44293112910558435, 0.25388989094903042, 0.65698637067983645, -0.37991923442037762, -0.40888863703617356, 0.17168932555593749, -0.31075707481668752, 0.15565217357717856, -0.41519611696237863, 0.35737681474857735, -0.35330420455138178, 0.13071181564735479, -0.16093831266097242, 0.19849324799918777, 0.17631948511735229, 0.11347476176677324, 0.34589789372426766, -0.10249299980140146, -0.16775531289074533, 0.076410549141354062, -0.25280042123713287],
                             [0.6789403703808583, 0.3703100637947388, 0.16068861958202979, 0.34648079979298002, -0.1489092681168194, 0.012782197825492711, -0.0734275531302232, 0.025949820794846971, -0.095361185115372143, -0.08282562655882747, 0.53165402423378549, -0.055248237885980156, 0.17524410078874392, -0.173137588802173, 0.14147515762065829, -0.069077032799394811, 0.15509412071386663, 0.24447080860945053, 0.42791340418133289, 0.074396124932187752, 0.15508728153132861, -0.19809598120052593, 0.62133133434672416, 0.056957795166246168, -0.28466918574745964, 0.21503485413170775, 0.018985094361691671, 0.20428223083100103, 0.11764199167498968, -0.19984608168630197, 0.04066474261641833, 0.23384286841691604, -0.37966712763364135, 0.1569473026830088, -0.12343531961834195, 0.17707153141490597, 0.027068469857045439, -0.12249764213406289, 0.22307130986578017, 0.10025555355171822, -0.14093504524907169, -0.40023378450051322, 0.1786708654216429, 0.28298971845883375, 0.34196468328011614, -0.099967067272870358, 0.26979259481236972, -0.64276188327874451, 0.23394233314167251, 0.22123424757422186],
                             [-0.46597100988003837, 0.080402493375064901, 0.72344838601971229, 0.27176801588042843, 0.46298909924364123, 0.32298376939529683, 0.044898701342120803, -0.21386631259464353, 0.40969217663226776, -0.045340565403247143, 0.58307372869522445, 0.027419374643487641, 0.040473729284208282, -0.11073410959583285, -0.4141045149660002, -0.052027783636491243, -0.006113521144439648, -0.013752981228046669, -0.43789384252036173, -0.33416303845468776, 0.18187055258374096, -0.035401389057975789, 0.047332779911830623, 0.044804609774927118, -0.098699116299634501, 0.41871405436906117, -0.32291634417620996, 0.0063304599132281442, 0.20025528966352829, -0.40905101942295546, -0.11799251081489992, 0.28238578541624304, -0.16789019751576961, 0.52108868876318182, 0.060381071135996882, 0.10071551380531488, 0.24571358437721411, -0.20413293194207005, -0.082943344732135188, -0.52599744109228053, 0.017155932908022947, 0.28252168740580941, -0.003525796043159269, 0.11847546883851384, -0.14150102316013174, 0.07764525145732977, -0.013850836785403442, 0.33014565535207774, 0.060841550808296375, -0.13949656674878674],
                             [-0.066831321072227876, 0.17474032169119177, 0.32277043798778132, -0.55392375024265761, 0.36565236859348677, -0.45755600021422616, 0.2518395933993377, 0.15258562035351644, 0.060316201124942986, -0.13832520856495115, 0.25953138168194428, -0.46555950997590095, -0.27687210127904638, 0.051531471616032783, 0.12101212150077424, -0.31601890059704157, 0.095331418550087421, -0.1353984317349522, 0.45317548847221639, -0.12932346436131145, -0.0056829316652732857, -0.035537758512000146, -0.054723527665159068, -0.41388134296254264, -0.10650923855904026, 0.29101452241221365, -0.24274795492614698, -0.62265524284420604, 0.18110440526122246, 0.038611688649211273, -0.27872881490728529, -0.28733901891548497, -0.54980060352770432, 0.14115698395706172, 0.0069279659327160332, 0.029182184150370695, 0.044963151182221217, -0.50419477323239337, -0.26582438298020089, -0.1236657069186974, -0.10603223816973727, -0.050832379023589773, 0.028345212641268571, -0.21523326756983066, -0.091376706064043106, -0.10377232916594462, 0.22622016498690153, 0.0085270200247594893, -0.32088129815912586, -0.63854104131839307],
                             [-0.033812605565638004, 0.13885378046259822, 0.30476760646493944, 0.22693320217326249, -0.27737761847629661, -0.12493269209365743, 0.025555993377000163, -0.23933932115222048, 0.13462355644679966, -0.048747886508146258, 0.19038155558651051, -0.23449952029636534, -0.66495282650526666, 0.14446123841850977, -0.20845870621963841, 0.05986533875584503, -0.22085471845164034, 0.1057831280583264, -0.014405231171647773, 0.45032452871892931, -0.40826971943900625, 0.20207954863208347, -0.20991720244122816, 0.21139176958218947, -0.049299148650045643, -0.082955018145526055, 0.124046434593215, -0.20687185430088845, 0.14305797389741526, -0.064748266248565278, -0.59147216216252307, 0.0082714882075329635, 0.061986273438004912, 0.21831077355943085, 0.11607547422484742, 0.043250022376532596, -0.29533489023922788, -0.2557728619714475, -0.15151742781090416, -0.079689640321160618, -0.063723223680030056, 0.042390522832773128, 0.076314656234813164, -0.34639094958218669, -0.046299858642005226, 0.034096552643326103, 0.43443647970872568, 0.10352495827105242, -0.11140295392924625, 0.015145280223700958],
                             [0.13275950083057314, -0.14532057887356384, 0.023622860801056831, 0.28073822685282485, -0.14442402052218273, 0.097950926105094843, 0.64423293634922429, 0.24239702107500835, -0.14537055141130906, -0.34223493795009102, 0.20730960111423807, -0.13486151532989227, 0.10420873808041603, 0.16850277126861538, -0.27586768592081634, 0.044852200027171392, -0.089421057689601041, -0.074014059512095332, 0.053847937801902834, -0.26844906410307229, -0.29895949396712335, -0.40218642500431478, -0.1776944651923012, 0.094894053416087754, 0.48841593275154277, -0.25762237615766315, -0.27775331406294518, 0.10063056228991274, -0.06191003420054695, 0.038094269157724167, -0.0086206929055757039, 0.65941996661559144, -0.0086059610491650597, -0.33161742586925863, -0.40781122376869355, -0.12689412372934933, 0.10169793914367034, -0.44850091436869916, 0.1296192359846462, -0.23369059677129794, 0.40283974971961112, 0.13753267174097164, 0.18597333164332969, 0.51647560229658751, 0.028446722816212036, -0.30050399580796988, -0.39232892616453413, 0.38719158037805657, -0.16572731962799753, 0.2151523642996869],
                             [0.10392684404571378, 0.13620808205377555, -0.29735075850112885, 0.040572725525326064, 0.26950796557269002, -0.11648102898088714, -0.13331209095326349, -0.025358000179927523, 0.54193512032087365, 0.19158459503380237, 0.36313293817439618, -0.17747183984292911, -0.38425299193715012, -0.33650597822945783, 0.27550199821152582, 0.49526608875834244, -0.19072225995209952, 0.010201017907472208, 0.16057240893138336, -0.2705796544478985, 0.42480328641537973, 0.32419534945979062, -0.22704804070132797, 0.034763003250059259, -0.098509586179743161, -0.4853874566666686, -0.64974362900261873, -0.22904208927818309, -0.093666986091311633, -0.35793140418556896, -0.34236793451914327, -0.074205395289152085, 0.38156311666657855, -0.051355960744102216, 0.2004417129933696, 0.38533976236102241, -0.40384498860043283, 0.2499811954209899, 0.0073816971738007164, -0.1148511107496378, -0.10115340776227015, -0.38403012336416886, 0.10576163185003944, 0.72151679415465286, -0.10688216010151884, 0.039052668423036563, -0.22135213648146101, 0.10229138045752098, -0.0030894050305958973, 0.31226761271802828],
                             [0.18089815196497183, 0.062442330752432884, 0.46923238683048857, -0.16766028297657792, -0.13930493332891969, -0.1828401526736689, -0.13363755821384668, -0.29960085712654533, -0.02652624982534748, 0.2722453587696817, 0.40493480362837136, -0.077448835630182761, -0.19882290342583248, 0.61863154305783452, -0.062561458488438887, 0.10863651780644819, 0.22406148214241167, 0.065061624239667382, 0.25912589396698327, -0.31542138710163498, -0.087169919117299252, 0.072589954842038854, -0.012400212579730412, 0.55021895190354309, -0.42261369840820978, -0.10123661518736976, 0.14129878508741284, -0.34219845089263834, -0.039587460738056919, -0.061020931128669437, 0.58939674369899797, 0.26619268723559369, 0.075043706897874887, -0.33916300419101336, -0.25680403593250273, -0.12687260868052519, -0.20117682878742188, 0.3784549987610123, 0.58792119939723464, -0.47863875030778391, 0.11710935487808175, 0.67320437799200183, -0.017452689799242079, 0.061959844214047384, -0.72790887653158631, -0.091766083888004862, -0.056289728641426034, -0.30309738729531621, -0.027192667617121878, -0.034843311236204912],
                             [0.31723355119703395, -0.40361233961169901, -0.19435398230546577, -0.32871272587388484, -0.57256506177406818, 0.052697829907930115, 0.14972186158261752, -0.43629914289989463, -0.032252506948751626, 0.25278102116603529, 0.01818157752683934, 0.62685905243991957, -0.12487350327228501, -0.3209896695076207, -0.16629578769256265, -0.069085366273245463, 0.32088213818344996, 0.21090404657625211, 0.16863890592735786, 0.041454013310851009, 0.32460886683926821, -0.10433999900480095, -0.46403249329524704, -0.040865323113343129, -0.44637168359076673, 0.03854317430859984, -0.071745180369556683, -0.13940653685316701, -0.10575279303795436, 0.020762761029152144, -0.32143470968148768, 0.068179716153298001, -0.022215626025879856, -0.31035195792721099, 0.48994592653778463, 0.26899290682192051, 0.45836741043588741, 0.10940340567998602, -0.15268430975839192, -0.079740426266443315, -0.24389678497711456, 0.24503352922340044, 0.2278108287457582, 0.22320337091778863, 0.16882202040135627, -0.35022666463817037, -0.64967754355894503, -0.099318997742093573, 0.35212474899687346, -0.54254104042246953],
                             [0.46906777426183627, -0.2605025784325502, -0.15587097382163656, -0.1568378097715766, 0.15403318313250475, 0.07284852003909878, -0.082762303048949729, 0.31461279392888136, -0.40943321612938366, -0.1907675336105556, 0.24390096889513199, 0.24134006404624339, -0.10626755278840418, 0.083398163367620515, -0.1852773688799027, 0.07881838070297445, -0.027703578917698587, -0.63252100269914446, 0.066707575688780288, -0.13112815142885478, 0.19479399963852423, 0.0071738224573561493, 0.17866094688215128, 0.50582952067143416, 0.32825702212248642, -0.10353059306620926, 0.071510341217936826, 0.29805761968463063, -0.38861034090376467, 0.40918393339813192, -0.034104042894692065, -0.0095773685637791182, -0.33714715234506276, 0.51494348504695919, 0.1476311919209255, -0.1396773311097721, -0.26410841974553434, 0.20350052217085163, -0.61186337078339514, -0.44543608561088244, -0.43107197494483585, -0.33255162394188376, 0.13546080356204857, -0.098082387618675979, 0.16509577012103746, -0.44201083716387335, 0.14420785343868778, -0.33826981274123036, -0.38333512504940598, 0.14979456748592287],
                             [-0.14314238515285799, -0.2409832224777384, -0.18787116187835079, 0.19810881828735283, -0.073062298957765365, 0.047855610454833643, -0.14189183107317765, -0.21740064073655399, -0.37273779666075213, -0.71338287069941897, 0.44895825847917487, 0.10393089054655082, -0.14737399558375164, -0.11725701159020743, -0.30542016741282746, -0.15946695392729929, -0.18225466878602581, -0.19516140909958729, 0.13183330834277429, -0.066820305026576168, 0.19493572093282172, 0.064027792812871243, -0.096610336223959425, 0.11704826018939926, -0.1283741083733386, 0.29158454830371972, -0.37352052772632177, -0.36780579425821036, 0.21401753674939408, 0.12815642298851324, -0.2309114504046606, 0.28920445745694473, -0.62922928452962268, -0.30224489857207792, -0.45125111138662843, -0.18399788409613027, -0.36494146130692739, -0.040075588179124232, -0.14159409657061831, 0.75747245855181145, -0.31987739527141573, 0.012832073049225248, -0.30576198019457629, 0.080696708339612011, -0.013616084655592608, 0.039073900095907041, 0.042685613503168664, -0.17853300676653436, 0.061545250395818887, -0.16393473978463707],
                             [0.47025080574612255, 0.20995171272568336, 0.1794630609492763, 0.27212355088495987, 0.23056535172198725, -0.072730982248012804, -0.33867395287845492, 0.12174619047772389, -0.01930885258674702, -0.21485986441614582, -0.18665098270319164, 0.14603418421053951, 0.17178509850842438, -0.032053083401161073, -0.14385797304227554, -0.24627870641858121, -0.044533526285475175, 0.025270257141214593, -0.39384351423301606, 0.065036040286253649, -0.10395918983457283, -0.46743606522204018, 0.14232176619143727, 0.094820048180489752, -0.036017401222142788, -0.22765686352529962, -0.12365404792720563, -0.23050037510465746, -0.2043008093067368, 0.32023254493207137, -0.18526409364538368, 0.45090774103502129, -0.19678716174287553, 0.39266415931240534, 0.35528255226584748, -0.39924387779699877, 0.11991603013155104, -0.079414252648619663, 0.26935240348965572, -0.11643740627625568, -0.8570974521169149, 0.31230183239333809, 0.096002416313425029, 0.34775659000580883, 0.28313762787830948, 0.20542365583744579, -0.53631352807199972, 0.27719483262432149, 0.25401081049297591, -0.16489785081615427],
                             [0.4298778061144215, -0.04764696062355183, -0.58415471778730932, -0.27102874718552894, 0.15343433837421391, 0.033172307647983082, -0.083708856421282909, -0.28863766278140668, 0.095131991669273858, -0.083309605881653176, 0.40088720826560897, -0.42446200994646277, 0.4697203634490828, 0.039986695083807207, -0.20627257597872611, -0.27775542371327883, -0.068010428315682603, -0.053050714500063073, 0.30974663342487091, 0.2265308176018927, 0.14550923727397516, 0.20783570651077671, 0.44143726244865, -0.4218014039320841, 0.1331406529568584, 0.21056758556631372, -0.050995554026479401, 0.27399326828678994, 0.54828412422186623, -0.22154801656132458, 0.20672582100419568, -0.1280296364786265, 0.074586403320181807, 0.41760279752969132, 0.4188832702680616, 0.026748436573822146, -0.55656491118864071, -0.25828291353620603, -0.31010792786408942, -0.051192484237380743, 0.049270183604710284, 0.31172034985208685, -0.30172153542576707, 0.46999619458807279, -0.16777712630514457, 0.34013406137562036, 0.414263684590151, 0.43111429106694993, 0.19773815169829051, 0.19446028231706222],
                             [-0.17639517256318243, -0.26357848438192261, -0.069959352372819791, -0.32326152838583083, -0.40460172988132825, 0.52756821605856352, -0.20942807365830471, 0.47419810333806872, 0.17540875890968596, -0.40101170329418762, -0.05457087927918771, -0.59360577413694349, -0.25090033944441431, -0.060070885023143075, -0.35078975531055606, 0.23148424651506311, 0.012416768938754933, -0.16249730832367512, -0.30087208200817445, -0.33550087606882489, -0.16577139491831458, -0.17771688532914837, -0.084729160871056003, -0.24741533118024611, -0.040812437068664408, -0.072936414382074669, 0.27664147978853193, -0.37785488684020507, 0.24865211026725989, -0.28800975733382617, -0.34717184524918054, 0.12200348798161172, -0.44394812366269215, -0.041500485271649949, 0.3317538920937701, -0.060814180419700388, 0.16078331487174102, 0.27562143621075413, 0.23970656018167247, 0.19685134378845806, 0.29221332202715083, 0.32049268713934476, -0.32833285858089589, 0.2648896763679765, -0.30482470640908127, 0.014630025061013716, 0.29825408924624036, -0.38735552195682127, 0.19535546361211539, 0.34545103054021931],
                             [0.14644775427818466, -0.0076577027135059112, -0.49457322882351723, 0.49416662920653293, -0.24282217387915692, 0.4922068074236004, 0.38495105493321408, 0.32159770229929807, 0.8314134041875213, 0.086764052427152752, -0.16917630245852922, 0.33658154548578295, 0.43634004010743194, -0.065394716511946657, -0.29573560102981916, -0.10749270636381959, -0.47768193801713565, -0.19648247352639872, 0.35322423113990226, -0.2115516923400059, -0.073233224637870506, 0.043398740773103392, 0.28283157214102367, 0.1005823148849468, -0.18814415750510838, 0.007344938614487026, -0.116358313914673, -0.1014717678381169, -0.1700357506644006, 0.092938032185280225, 0.16954796247421336, 0.51177867638283647, -0.17571630216725798, 0.12976840045944177, 0.2280852377513703, -0.17443663649297109, -0.10166792204363406, 0.0096953309141774476, 0.091360166720384259, 0.17575834960265507, 0.08435990057972631, -0.3145442627269438, -0.45810235430877988, -0.28461530605888918, 0.13340723272786228, -0.089112979636600045, 0.22203868361514822, -0.0096160463551046779, 0.24945938129508577, -0.24742120928732789],
                             [-0.36727221553719686, 0.33256969918155838, 0.23945560461493384, 0.42788568493788764, -0.37187098046453154, -0.30851390277149382, 0.4371257027117571, 0.19041407957887269, 0.10304636995466664, -0.01306924137385275, -0.026677643657860805, -0.20924004885790046, 0.39757683763191959, -0.39782157248240285, 0.017370550449604852, 0.16779458768421784, 0.13260138912870387, -0.22125796194990427, 0.06499625124542692, 0.28034434974298794, 0.38381553638057253, 0.19898619888727287, -0.00042066161831836452, 0.14829668929002249, -0.48798897837249788, -0.59048814673122441, 0.2749811313247989, -0.042086327230061636, -0.53679801026974461, -0.047859849835803436, -0.26640995859330263, 0.34922975465707207, -0.21613736745663409, 0.16552795431021175, -0.34288738641611211, -0.58073190970391364, -0.1287128102448401, 0.15943903659612882, -0.31308176381035341, -0.029003255410815915, 0.4404767733913133, 0.25223579243510641, 0.30265318503092337, -0.0072408621261637668, 0.060911897429858565, 0.31108790930941077, 0.16049076968536952, 0.30061059300601678, -0.079878009669405226, 0.0093522414600991539],
                             [-0.27007095477498549, 0.5536085715656035, -0.12799340840876272, -0.1580432318630072, 0.069958724398195699, -0.03650356098187809, 0.19906458517585696, -0.10741778231754515, -0.2059326548709064, 0.028036868871925448, -0.10174176283937733, 0.15700835474956573, -0.18390027389484809, -0.074699844011293287, 0.15071212475816015, -0.5116349711955579, -0.25619804362549337, -0.17699318650682358, -0.31819971906641625, -0.23116076553446868, 0.28070675715906418, 0.43287468048621547, -0.33164876307368119, 0.10015488687596136, 0.51809987659801926, -0.231044541530222, -0.24222287303454884, 0.21886169220013077, -0.067782624159304347, -0.30123454576657221, 0.1670521220163812, 0.13730470450894683, -0.3037806462586562, -0.14653529353973502, 0.36524610489225029, 0.19204159831205203, 0.14409159724671156, -0.24164626226579441, -0.038818722065240223, 0.11443171024794896, -0.38522563814194688, 0.36066103086703516, 0.42587984456284494, 0.12759461682872761, 0.021691396137110842, -0.37150713365736193, 0.061170757573921423, -0.25965395788265788, 0.056768945038498969, 0.042358576463778636],
                             [-0.0029254469434510846, 0.068594412434590829, -0.066031550304624334, 0.033825260750696542, -0.45253401088736855, 0.17784845133577837, -0.036919905662527314, 0.37859026604277279, -0.075096587793342828, 0.21149166257176083, 0.13927088861807782, 0.2396681467273146, -0.26954452983807864, 0.027472131520693256, 0.5140847162988571, -0.36205574902445192, 0.25801511920164388, 0.058483513154016474, 0.13725544647847915, 0.13800763106211461, -0.021110037179032926, -0.090944524808188071, -0.88180754014930185, 0.13527273194154488, -0.03255832281483953, 0.17107803756094878, -0.071149042137812271, -0.17059649575765523, 0.013260788152009541, 0.13048638498400653, 0.088838622915975357, 0.27261701886771827, 0.069627829538354155, 0.49371363228504273, -0.18674148097798624, -0.062617126133277856, 0.40332683779964867, 0.2992011575301175, -0.2845036778085599, 0.18492935693580911, -0.26614412217533018, 0.2124711174422661, 0.092882424832789967, 0.05443204070770305, 0.027532890357205436, 0.20271283431505063, 0.085142978363356381, -0.39369947855291781, 0.29923094935822503, 0.07486508095729219],
                             [-0.13530112420602589, -0.069048510476355837, 0.61639947638312387, -0.24028691976422645, 0.32219839787046528, 0.10639960726170812, 0.28994373141047369, -0.065406029331129725, 0.684563953063834, -0.23444306723199057, -0.1832665048888191, -0.61352147140121382, 0.18753473865427189, 0.13593290367256478, 0.022323050391124772, 0.15291605399712843, 0.25752261901069218, 0.25270641010086442, 0.036221014768517364, 0.36767459605372421, 0.029189400846838676, 0.18419451392448366, -0.4787393149409101, 0.15715087053666574, 0.31454038861164046, -0.065987025104485064, 0.36415702158837343, 0.19680957599297519, 0.1403266258201101, 0.31348150315182716, 0.062051570942721151, -0.1429426361888593, -0.38468016089526752, -0.22705782523475021, 0.25466906408346468, 0.06138353943667741, -0.20279708535215588, 0.20296901521278457, -0.0061720399920395207, 0.14805302400496584, -0.21813906353268964, 0.11906942225134449, -0.21198082642653712, 0.047673507560955411, 0.39923809883329459, -0.42090352444578066, -0.11095885836783748, -0.020530914079177023, 0.11664955411936466, 0.32340140120254735],
                             [0.26557898986044531, 0.088176705704817934, 0.47549984709596765, -0.44688459442261541, -0.13709491816745745, -0.30317940147801264, -0.21576707647187837, -0.39928745663377507, 0.20675528699949366, 0.10983589881536462, 0.28394290643747444, -0.022979334524891482, 0.40101386988669308, -0.093009593465699147, -0.25865160900687995, -0.0062461602443643479, -0.12032568242440354, 0.38745118541405021, -0.017291337222939854, -0.19789718716673907, 0.23078650441678819, -0.2368409431935751, -0.37708074239921519, -0.13649702559254676, 0.39763059985074461, 0.18306288732039513, 0.028542209750182769, -0.028948804363588754, 0.11861897904308068, -0.085649126307722367, -0.12398595329103529, -0.040927577955039263, 0.14279257738756182, 0.12830612143864201, 0.59302448379324935, -0.26893663021722347, 0.33078989588447733, 0.086679950551017293, 0.33130124618884293, 0.53635754833048044, 0.27688921751453971, 0.077283321574085864, 0.20054580069714609, -0.46347663931907512, -0.25896631975661782, -0.16092440667832375, 0.098935152716493516, 0.20698320718393887, -0.20950615770026276, 0.39594887049121097],
                             [-0.2471339136255441, -0.55662639541564185, -0.042338674931452359, -0.14555637633586418, -0.24723461650827649, -0.20622016232653612, 0.017122690425935144, 0.16633350495047991, 0.0070509708304354844, 0.17877595339757163, 0.10896464563642219, -0.59838656647543642, 0.42314482634571704, -0.052971944683802549, 0.38044278409957094, -0.041235563561435276, -0.3734415332952476, 0.00042776544906792183, -0.48619889422705498, -0.40866132631645691, -0.27580552390388746, -0.10480603858265368, 0.21150242038524872, 0.20901515864506362, -0.29799776358589047, 0.51084049010180099, 0.31086663888856442, 0.046966899302939694, 0.16066227130071475, 0.02992592279234435, -0.38116940870319466, 0.62777095641804936, 0.34215422135882539, -0.10292812344883875, -0.060277418211601208, 0.086385110864832165, -0.17183001271305709, -0.029514979361738556, 0.012634809879986771, -0.0054422016968215196, -0.14609924404300667, -0.10850362814513191, -0.17489164007126665, -0.071358532836708274, 0.11057954352610692, -0.51349800168266024, -0.19319378313448751, 0.35376799091854894, 0.22744354464819502, 0.074305979511265469],
                             [0.25300005144105814, -0.11992039106458829, -0.099194995574052425, 0.29775485724718481, 0.075119351241765248, 0.42075269120161124, 0.33744362887178248, -0.18464245303669424, -0.052729259911804126, 0.13629759437891864, 0.28590455160447392, -0.23479116598453592, 0.31428677869725941, -0.0223262639765919, 0.22291682987143832, -0.045221957179517901, 0.49496794421469842, 0.22483811458312147, -0.050234547371038829, -0.046005439778696922, 0.17506212662422194, 0.49293958404845012, 0.16154266525198324, -0.48667514869283646, -0.087365208655127161, 0.027968835235242101, -0.17249833671847961, -0.27732657395527954, -0.25044193810694793, 0.11929274949091126, -0.14441315981257968, 0.016734850032369665, -0.2337627864702255, 0.33946761077920112, 0.2896032451611818, 0.44171549249684416, 0.20953805827671734, -0.16508957451654882, 0.56555538147633289, 0.21438367523283997, -0.10543267936443608, 0.34744301967084928, -0.11462631195982374, -0.39143399171631105, 0.3714226495794547, 0.16964810944073422, -0.038631480608236894, -0.12736683919246319, -0.46943548345450231, 0.1203749942277223],
                             [-0.084412225099059587, 0.025300848572597283, -0.15787623709432458, 0.24624683573407208, 0.84235679712414391, -0.21711212039673386, 0.088847161753448381, -0.20941894175432318, -0.30470269421318313, 0.2870895157614069, -0.25058182611339397, 0.042288797796792503, -0.22240515695891344, -0.51996235476009423, -0.27562881319100957, 0.19025550389916718, 0.17136151033144523, -0.16824005486834251, 0.13696147584127399, -0.072331181692164723, -0.14651980599616235, -0.19640027151113865, -0.47690455709706797, -0.056835164363742384, -0.63687522935685226, 0.22052569866734126, -0.035094525277332964, 0.022596128323475927, -0.21617560330870769, 0.33427807737474879, 0.095348923896553681, 0.27740579579644248, 0.35164889771364416, 0.24536268272778208, 0.49368679448800434, -0.0019096524872444915, -0.10870761000774314, -0.27983821886745591, 0.17424821752260991, 0.46076481577256451, 0.27606682798718452, 0.19399218512563174, -0.19794216565888134, -0.010285072266569491, -0.35268062572522363, -0.63541810993068437, -0.19648704052829358, -0.30298853662626818, 0.056820454080220364, 0.12519516239351747],
                             [0.17162757057562031, -0.044639069765723322, -0.40060987364953671, -0.067562436045859181, 0.33812287477059139, 0.066243527313461892, -0.34509172404176419, -0.12381070841493691, -0.10266909322685969, 0.46453418554970943, 0.14630963987950615, -0.11626845409078182, 0.095723354682177686, -0.28442339028370772, 0.23914720957971555, -0.11820118656027259, -0.018028495252827945, 0.32958788236323699, -0.24401809427075041, 0.42690890869081638, 0.29412342939770525, -0.19944678312227182, -0.13655207375922893, 0.21594403067175436, 0.031709552391715232, -0.60792042377379074, 0.22848931422844501, -0.4626599543351857, 0.16515215896060906, -0.09692816603500512, 0.08564973965017704, 0.055970625054080819, 0.11452410493619006, -0.4655407720255943, -0.27532866282158619, 0.20389465564197315, 0.29250938088861084, 0.11631167747876438, -0.1502218101683413, -0.13284083909726696, 0.26096018727754777, 0.4212802196178409, -0.57098208308274767, -0.12681370655076177, 0.33174035874008218, 0.12666400004535597, 0.49273658505462764, 0.068060478438093666, 0.058237542426715645, 0.54418947144784413],
                             [0.013390182824043412, -0.3896718902179821, 0.11306869852441816, -0.28603799891501885, 0.24161810334666861, -0.023703990932051423, 0.81935034340645274, -0.21103150286164435, -0.15089995367360182, 0.41632325282719068, -0.1095083041909814, 0.32645942688446367, -0.048951291198064843, 0.5407649570705898, 0.48263496382112869, -0.26275179954228267, -0.11416709104907143, -0.04329599963237972, -0.11886731901172341, 0.22197662037404259, -0.25307082694500166, 0.039126247597077647, -0.38264630972890862, 0.025805529960933757, 0.14997281350463249, 0.22066085150586542, -0.033445303740621928, -0.24823350546644485, -0.32565446405656284, -0.42238323009120932, 0.16152046226845487, -0.041026919006449114, -0.014506202720640723, 0.079956830200059809, 0.15117294148476187, -0.47139079274121876, 0.14944257404226166, -0.03494210146579909, -0.23164267704262434, 0.31611681705277367, -0.10853782021264487, -0.76521100907440975, -0.0057695438689161658, 0.40280617944292052, 0.046322713572380041, 0.34817462427731999, -0.02537264870075763, -0.14010445414952469, 0.22128636861805262, 0.37221480781497768],
                             [0.35184735694357211, -0.1570005135558476, -0.3093654844963884, 0.20837948714212426, 0.53193809032130079, -0.51851104791716918, 0.11429213225380845, 0.14667657199735659, 0.2168906063121602, 0.15319952578591958, 0.30589237485379861, -0.40942930644809405, -0.21919716976610901, -0.1143179299591363, -0.1547978860084189, 0.078268354821729613, 0.43736212922723167, -0.2503351586336619, -0.076582919369004201, 0.16793690183496773, -0.1477286848824487, -0.25249077123021235, -0.12155436148471174, 0.057707795645444121, 0.1272793200221663, 0.29309050661697533, 0.041231369381701272, -0.20265687040816172, -0.45160443106385123, -0.38993023117512704, 0.26049904837470089, 0.47885642550063373, 0.39731558452963373, -0.24148756509296945, 0.060060103316313312, 0.0090171880961773098, -0.17562029372126153, 0.78074479000150088, -0.37602913528372206, 0.27912461647020198, 0.26089885847767902, 0.22695626977639055, 0.11345769980917816, -0.1638575131103259, -0.23963248077366731, 0.27930229692615127, -0.02610382774226043, -0.18210420256213752, 0.42518978063533924, -0.34610599061898817],
                             [-0.0012968707362890769, -0.12442764616809968, -0.21237999358229212, 0.012605341590859374, -0.13285862891586331, -0.0060680137264288638, -0.29532988807332655, 0.31439428133681785, -0.17333427718888311, 0.13658039767169761, 0.031235198981546811, 0.22097031958851415, 0.34119284008487238, 0.53827066996317885, -0.026343169633897441, 0.2227414696996981, -0.4175487206321668, 0.073733259182329342, 0.018376342203174825, 0.0071972173280978758, 0.41098471328748598, 0.25830208107536407, -0.12899632710150521, 0.3480681101818488, 0.053312848407921332, -0.1935663472349029, 0.39927725030748934, -0.23421865737807973, -0.3234227369371625, 0.30311626921150858, 0.3337473909665104, 0.21416486879173532, -0.10647800427985929, -0.14181857960521665, 0.37348452347011857, 0.84525334039637867, 0.059961862883694157, -0.17364871362096621, -0.31334681521982899, 0.18569787303867868, 0.53241597844582411, 0.086259237916486667, 0.65395750653172491, 0.33448794158408768, 0.47086854894555663, 0.37877031738463818, 0.070872196398238274, -0.067013673957240921, 0.077485438753711069, 0.14077961817630449],
                             [0.065135711578298935, -0.19070473182644238, 0.37917648244258378, -0.33346798575758863, -0.11791897567011761, 0.18330483616629376, -0.009369731289112726, 0.0033316569194746931, 0.13706589795347163, 0.07685164642479908, -0.32902896726046754, 0.15381601348304255, -0.010308973648184554, -0.44047257801000173, -0.13494101563704344, -0.29453921480267209, 0.20472320450481357, -0.020242386684953012, 0.016731533936182902, -0.3434639983310514, -0.21711174551477294, 0.13370749394380124, -0.29461904790736815, -0.05295561329842205, -0.054990703634790909, -0.018913292655351591, 0.51138466002334471, -0.47720303908064471, 0.052312867606993795, -0.37500412295872521, 0.09820152116237596, -0.0050692671918388527, 0.14497680046712536, -0.11506225758915403, 0.015207818897371049, 0.18597809609434302, -0.69264042560615402, -0.26097265226747202, -0.2132886517519913, 0.058098230876398357, -0.38240434864340789, -0.035987832418213343, 0.31281060039625752, -0.25290996302257629, -0.22255528580753126, 0.16272534712410736, -0.31435302591607461, 0.022140260185203722, -0.40478423286566867, 0.15004055268758459],
                             [0.1303103963857373, 0.027830243399247796, 0.17063237177703214, 0.10604708232152352, 0.15830263558419502, -0.43359745532170801, 0.32807982883737796, -0.010738617996481854, -0.16986071377301767, 0.065197101463531734, -0.40663127435584517, 0.17558845123889574, -0.45093178453174365, -0.41310781335437063, 0.38051298002042067, -0.35722610935122734, -0.16622324180251449, -0.37303735022974749, 0.30773672034846927, -0.42083449016754565, -0.20979636468981122, 0.14235491102441611, 0.30254487623409843, 0.68462481701089695, 0.38288169200587985, -0.086144061694869614, -0.071426122716600371, 0.27906842526113895, 0.23919775622729414, 0.13883479016428993, -0.04648855381897915, -0.26218636411698881, -0.0063067966894037302, -0.30310163791094857, 0.041179157077112977, 0.37726928962670447, 0.028531678620406266, 0.30310628921240318, -0.15508567364534978, 0.285059144212919, -0.041467620146614877, 0.10073689471400328, 0.1272230081224402, -0.11778263179785757, 0.077858015262931748, 0.65829321657051687, 0.37518607972280388, 0.44266287886312977, 0.21999670295187701, 0.63010844181638836],
                             [0.54924946991921275, 0.31371922189826773, 0.18017095037285935, 0.23062845492822165, 0.14988251540622219, -0.0096391207323869871, -0.0063873818286610332, -0.34160989107963646, -0.38431974082336112, 0.10047158966407541, -0.25448303292606256, -0.29421390045943041, -0.25023034804814587, 0.37709955542924095, 0.47235820234907683, 0.02914449585578039, 0.31156146953399033, -0.1765032047056635, 0.010638200634701497, -0.30641895296186739, 0.054044238675808466, 0.48873376189166073, -0.0040852683448488261, 0.19005378489294317, 0.3142759386356524, 0.0077060361287219492, 0.28153160901391927, -0.091948851467438614, 0.29591238974021444, 0.14970774048612778, -0.14476332927802343, 0.06958385439155941, -0.10092655540938518, 0.099305717994684711, -0.073139487529557179, -0.080963892311667285, 0.17313978310565231, 0.15304282330953028, -0.34134794642905308, 0.1631483604657919, 0.29772353808727892, -0.40586966188469153, -0.28825701459735259, -0.47923728713857944, -0.0091259825087873434, 0.11940282101719403, 0.11776014165343535, 0.091623951755302913, 0.33320630321610356, -0.48267172130593433],
                             [-0.11239489842617384, 0.033566824553548466, 0.0087023310524140945, 0.13417254720156391, 0.23929117857358162, 0.16872692028485789, -0.071810103940945003, 0.47896108020225314, 0.051839288900987497, -0.01102064385091351, 0.22245763701732502, 0.21086263622248599, 0.24538114510196679, 0.35214715747557213, 0.28588714106340929, 0.32761639020174455, 0.078785755547025424, 0.24932149410614926, 0.35578749275426508, 0.032064197355554568, -0.42985692214366422, 0.16622142111175278, 0.0390926782103478, 0.14079657909470228, -0.30153679685220958, -0.082570436221878318, -0.017369064708532354, 0.31035034990694199, -0.22857237213755718, -0.28585768240511245, -0.10466953006846695, 0.3414702512521488, 0.40015274473212931, -0.67466350461728486, 0.52075532117578693, -0.6337169882737439, 0.3573797571142181, -0.14708258704703436, -0.35097694700375498, -0.19410644456157847, -0.20811036174692532, 0.26281207790672828, 0.15709802734847841, -0.46335549416078259, -0.057566981299533825, -0.0349754788814024, 0.26337289461645275, -0.071113331686037451, -0.3311786795519287, 0.075888485810321857],
                             [-0.052994767114008287, -0.10274211613510099, 0.33381475590344722, 0.14155961352523647, -0.26620193892143196, 0.21305391318827852, 0.14228131750793127, -0.051716293490193729, 0.0092076813088672205, 0.30887724811235445, 0.30546881640251883, 0.26816718695542263, 0.095512890265155706, 0.19367154344210466, 0.13696264256524515, -0.36814063166985267, -0.085970006797067178, 0.095793198625473377, -0.022930223678259216, 0.12571284795127813, 0.019550236529520287, -0.49678903054687917, 0.52249029005222647, -0.19615978048711158, -0.017457974800891785, -0.62414730306434751, -0.27949034718198634, 0.16291748870800901, 0.07006847243065828, 0.13088259492618218, -0.25879565379674774, -0.28241690867784869, 0.085061836417055933, 0.36686997245652136, 0.10993585607275794, 0.27033660001113863, -0.67864291134890231, 0.64837915773553934, -0.33429275133648795, 0.15474184694528076, 0.73581188029277222, 0.050097008993605432, 0.16365208484035723, 0.12168848602016798, -0.14387499542894822, -0.1159100547243309, -0.26387796794385465, -0.16161575160270605, -0.21802135282366628, -0.26991091990499333],
                             [0.47123386103815434, -0.32684461590347069, 0.014375366631903284, -0.020388665498503586, 0.11330194234257288, -0.16441116559505725, -0.19995179426356741, 0.090870665586456872, 0.52627743760329093, 0.27827731510482767, 0.072689897825830921, -0.017031424552455546, 0.11245554824928382, -0.1396395871655004, 0.13827987554983684, 0.40531757290157622, -0.027889300648458147, 0.03744469346953827, -0.032396074180081794, -0.23811553618701936, 0.30693802519379881, 0.024708919492741458, 0.095850558794723817, 0.18337473858334888, 0.15744728801298494, -0.11618037008555054, -0.49764208373719365, 0.26359270892845765, -0.027622760878136563, 0.011819802179177302, -0.11815103769462301, -0.08935674866488745, -0.23044559571235235, 0.46034055388798861, -0.45746946449803033, 0.15042972258050952, 0.46999009388274499, -0.80577158615659661, -0.093430060542398941, 0.012885010034742137, -0.20321145594461529, 0.24739110161644015, 0.571358235346618, 0.064792428010291434, -0.60617022679971855, -0.14693059285307572, -0.13927894458570683, -0.30487375751687595, 0.32220117185106062, 0.33608458862393414],
                             [-0.19390177497133243, -0.16765170764954898, 0.39054260594064522, 0.03764870741346954, -0.33608684613420381, -0.23805268578593766, -0.019572421348644706, 0.20015013197923509, -0.17447537552568274, 0.14037034349337257, -0.31421645905693663, 0.22177748974876793, 0.42095293018726093, 0.057313108223024135, -0.024078769216310764, 0.84221548804545909, -0.042116710155393235, 0.044595955153819991, -0.025179417852866013, -0.026749558363212189, -0.26027074980301268, 0.19007512376273411, -0.035103776852123889, -0.31662921903769597, 0.31970385027513393, -0.0082762891835414867, -0.53155752919072452, -0.30618706596615997, 0.13103409547941358, 0.046137581660346219, 0.19744261451676406, 0.2888094729970061, 0.080813943516707315, -0.23700060589630975, 0.10127407556814325, -0.1283469612664527, -0.22278796144174104, 0.11109256323709893, 0.061016273259340927, -0.38824352303224652, 0.38417412025830777, 0.1716922295298467, 0.036040284750678331, -0.17446784162564946, 0.17854162320077951, -0.02854738620959564, 0.27582474504064691, -0.44691598443221892, 0.40475517541247347, 0.29518288433496714],
                             [0.32779616674687317, 0.12296246292110664, -0.10750851506423022, -0.48612103393654088, 0.1331740279656847, 0.38782851929774503, 0.35122759147204102, 0.071903825815742464, 0.10379902879911886, -0.10351787274480515, -0.033238365489520243, -0.31109985653367189, 0.10546402237303258, 0.054843134616436522, -0.001558146133631616, -0.17601985611739412, -0.74860124160014452, -0.19942017505001358, 0.18830061348670624, -0.22732540730850334, -0.17099783536277666, 0.30235640584567808, -0.24865717627935974, -0.16691737444852547, -0.44134273100084059, -0.11499967944921841, 0.13541949372961973, 0.051766530794822671, -0.045334915545927765, -0.37312663395779833, 0.098272257399869223, 0.13585675994131541, 0.064938580227247841, 0.032532102103712573, -0.13072526648924232, -0.10452567637552165, 0.19828893818409341, 0.087409129631327798, -0.03570204098452899, -0.11386912193492886, 0.33162903884832762, 0.30270448376147269, 0.59008572951516014, -0.58615958067313079, 0.35281685991962619, 0.53089354967742353, -0.36762325073252561, -0.24699306416523292, 0.31188649365586518, 0.13129185911089147],
                             [0.0082244563369013382, 0.34382683282826154, 0.0178087885331858, 0.24003187622558592, -0.067914623293907461, -0.3856892758117067, -0.26937157738651762, 0.15490311028319259, 0.39956364406199535, -0.1399015962764017, 0.34822014729042172, 0.2974465312301694, 0.046178964726815742, 0.10681203376610461, 0.3319912201907142, -0.50059791613609494, -0.1990320672402954, -0.79602275080894447, 0.30391269136630439, 0.46129033917740742, -0.10077403953092226, -0.1548866390299275, -0.096361158343031217, -0.30914459533134803, 0.00010970332625484698, 0.1531634685530191, 0.31973487303740905, -0.07624992153892568, -0.079154149390162756, 0.2920068954134602, -0.12672846908610033, 0.1478085120448577, -0.14783231952694167, -0.3944929676663167, -0.1385854704329626, 0.011823244726667334, 0.038919127094940976, -0.2482389687543794, 0.10185439501485513, 0.11255689795681775, 0.1250439397330991, -0.19010096531826431, -0.33647687122778441, 0.091387021648283343, 0.046296010436731358, -0.062460353164995583, -0.33101456266218776, -0.23948333613992029, 0.33186182684432131, 0.59765807062514176],
                             [-0.14802578574476991, -0.43907686840224225, 0.26540330421042896, 0.39217134695185402, -0.31408267792239947, -0.21813221907589439, -0.11433988075049308, -0.24607597011834126, -0.41047755932554725, -0.24874688484931975, -0.43842578651955072, -0.32370020815197598, -0.16532217044693598, 0.068754996728763521, 0.085595222317570455, -0.45417439814004623, -0.16971214617645503, 0.2771487681719505, 0.26777711131355708, 0.2351715129617773, 0.1103333882063029, 0.05310934920810411, -0.197916765051282, -0.21641867182010124, -0.25328873266475732, 0.028629444473928067, 0.058944121447889471, 0.20829962914448183, -0.16072642177828272, -0.16967937084395063, 0.2150163284719511, 0.1072324970207382, -0.20490213322502096, 0.035990658907349454, 0.020488369588203856, 0.28480255931924559, 0.20461930313473708, 0.31713791752293469, -0.36577359661211584, -0.49406629256802098, 0.16627554398870467, 0.081889254349945914, -0.2303371600674633, -0.11803905919933479, -0.55833829459794349, 0.019584882564964254, 0.0041138892104190042, -0.0001775789364244218, -0.30061690408585784, -0.003859823668857695],
                             [-0.2662833753372747, -0.06639392293642106, -0.11659558692725872, 0.19866875194956446, 0.25506585472787346, -0.31500302829906379, 0.31935740635348842, 0.330181108594364, -0.010488988872362957, -0.068505073739622974, 0.33171568258253037, -0.026875508329158772, 0.31785951904237153, 0.0064769947096087795, -0.023319766777344608, -0.099459005811528764, -0.26576046480103693, 0.31852812643572487, 0.19768160323983514, -0.010359775886612604, -0.13069453143399229, 0.6627144179381671, 0.08419144095724794, 0.040412046182266709, 0.44375863381744884, -0.34373633147913601, 0.53221804143272755, -0.017910639279383321, 0.63220897023722855, 0.10101172668886355, -0.23609762545719221, 0.24089089025285498, 0.24133929535089788, 0.22239289189822184, -0.19804783130099241, 0.17125175973628451, -0.040212402176808611, 0.42004918304021038, 0.39432054969525515, 0.05736623268577723, -0.49752517036854083, 0.00086158121162280971, -0.18311671454339035, 0.15502993452360428, -0.16923127233972016, 0.10104492003942248, 0.34059806488054373, -0.30115948393234304, 0.082104505995530069, -0.023296459770718678],
                             [-0.37707507612068264, 0.10708141589726407, -0.32925620199692768, 0.0070773249321420227, -0.11292507910989741, 0.0061871528112464342, 0.43524640052783431, -0.0095236594466195004, 0.0029046763179516781, 0.50619672729957932, 0.068771912335037141, -0.36974053111107497, 0.17615139881399727, 0.071746004352362988, -0.16510357320100036, -0.036021793790957241, -0.02392320666306447, 0.10295356451551246, 0.15523307226014824, -0.41216930476834956, -0.0011493742477631361, -0.53428900848886474, 0.26586326092448159, 0.48969365112398711, 0.0080831435765900683, 0.088647397654330856, 0.005169592654146361, -0.2630990801119355, 0.28921749760424548, 0.19787351068339376, 0.052821891802435177, 0.13616863631441986, -0.0047130425616374212, -0.25812401790172268, 0.23419490038806229, -0.2916020896650221, -0.12932310715383302, -0.11548764893157228, 0.10691263291707669, -0.38355898226170465, -0.0020792903138063144, -0.44711244621991569, 0.81286969864900183, 0.0020964313615511295, -0.15008562290937996, 0.16439979907403057, -0.47368635963475741, -0.043348600979396926, 0.035163692992137105, 0.23140330251881627],
                             [0.019036132773121949, -0.048946404112122789, -0.24126689809301025, -0.21076897645053708, 0.16233496563687425, -0.32012003999947958, -0.15702500471278755, 0.26441907399554659, -0.18728949232024469, -0.39661751632788195, 0.32384055637277553, -0.34709323632382783, 0.092489078629650084, -0.18012213463607912, -0.37850914630137455, -0.29372078512105704, 0.18698855587483346, 0.3744639169498028, 0.39281888282834543, -0.50802046906162401, 0.21382374373320029, 0.065554562417170781, -0.34099675379049887, 0.55295865690896451, 0.099024201880173704, -0.18598421870466045, -0.032766328569165337, 0.10970567010913043, -0.57835197424228058, -0.39834811645152107, -0.22485832174882378, -0.43055111072551111, -0.066905605480129887, -0.087654198038021575, 0.024124356851079741, -0.09143598173378388, -0.29145090058074485, -0.20413806974403942, 0.25794261269719898, -0.34762972416691051, 0.16505266490289211, 0.015613572743039442, -0.28884024985376194, -0.16603922730800227, -0.28073986803309431, 0.25609744403770585, -0.13119405371850074, -0.0093091334159413376, 0.53131398379196404, 0.012889441726665962],
                             [-0.15810782753354749, 0.27283107346283275, 0.053795841406117692, -0.21413331811637154, 0.30426198962644213, -0.018555952323314417, 0.61623635626889817, -0.0064146124515779418, 0.2129964426206335, -0.20763723120071637, 0.27331618026815557, -0.13329925706064952, -0.42107029845436483, 0.25976021103443114, 0.23319989074754574, 0.061620138804254015, -0.1481560447412236, 0.2289263097039832, 0.20375160680403451, -0.32132271996243633, 0.25808531369713522, -0.28389903435067082, 0.30927981388821119, -0.52877758613076176, -0.10101521323800329, -0.19782745495909942, 0.51004910891914879, 0.17393520761022854, -0.068884535289177831, 0.52538027739294146, 0.3649817492232072, 0.49049024223114757, 0.17074803157383944, 0.10286734630110875, 0.2272422274948207, -0.17178237174217745, -0.2430237851388965, -0.39372715094736593, -0.17579217660214078, 0.030613450595072977, -0.28350602073839359, 0.13135621800238173, 0.15055237316730041, -0.63650727576335531, -0.31327425954089738, 0.44940352349968438, 0.029970870198433579, 0.22607556556033243, 0.29480608673936398, 0.063920661478811577],
                             [0.41141196093579124, 0.079802790448862987, -0.11775019363944388, 0.19773933427142748, -0.1263877090776265, -0.43330380502704413, -0.12077858503135241, 0.03838728926145888, 0.22264550054698884, -0.021588121864960581, 0.35290907153133361, 0.049507414273589283, 0.16474235051412633, 0.11097314353258549, -0.45533139779512805, -0.23419195163448542, 0.27310809166852562, 0.0042502010333094128, -0.55456483199585604, -0.46704206585275965, -0.39329676461227442, 0.036682901558721594, -0.26106631664173113, -0.15255156945807333, -0.47367838921988042, 0.077725691408701419, 0.12706127375646209, 0.26301890259715632, 0.32697511109429256, 0.34717237385515026, 0.25207931621479213, -0.33109830225455267, -0.069036421559756339, -0.2752414019873724, 0.34011334959582074, -0.061923378716475672, 0.1364988760394176, -0.024969411491081662, 0.079395978495031938, 0.033017000143275105, -0.054793579081957422, -0.29619876922733329, -0.24852079004102187, -0.023992564424679286, 0.16545862156778232, 0.18900348349183618, 0.238779636876323, -0.31543493574953158, 0.035131824622958399, 0.045449242950424108],
                             [0.19231870465683659, -0.05119865924143497, -0.0011222047182577917, -0.56987040580195603, 0.049302009185439588, 0.3036548081804315, 0.037187803147433772, 0.19972044657372465, -0.031017982505848793, -0.087468167763846361, -0.15381316088571959, 0.16315006230211251, -0.12238510823716205, 0.37408584611116907, -0.24179651211855233, 0.14577672903996086, 0.62688771059077375, 0.080453783984479693, 0.17132959301951825, 0.38667074299508919, -0.21449596797256354, 0.22170554732314549, -0.20575306336742819, -0.4946332971243555, -0.22682007938709989, -0.29265175787587699, -0.13836787090558714, -0.5609810607081519, 0.21862210465925463, -0.089725370698580442, 0.13015111958179565, 0.42336465737565759, -0.37000634307900698, 0.13852235058433635, -0.15163808642585735, 0.19537248069260857, -0.1327954994198996, 0.047892715574292491, 0.34059776805684927, 0.26809196412922426, -0.091460916821083399, -0.25745856898911784, 0.10932566819700844, -0.3834960649414208, -0.069918015175776602, -0.370899657871959, 0.16609154235220391, 0.255477771156636, 0.75993206563194649, 0.29984768298483905],
                             [0.0054924730417223603, 0.056458703478797868, 0.30568160759659208, -0.21915720043811732, 0.094268979316712534, 0.16218971582323993, -0.33560154631651268, -0.1700283533893108, -0.10304817769064867, -0.080459937852937216, -0.19305375337662969, -0.20671055141397876, 0.31744958835808507, -0.013413153308967217, 0.038768054343249758, 0.050504958126074612, 0.15451465829884201, -0.69377433216862205, -0.15318205590035733, 0.069017661665511945, 0.42226526619388649, -0.54773334591936584, -0.18230931487692539, -0.1349795598749968, -0.043077319448765999, -0.11420396309865155, -0.14417182889753871, 0.42686789381856916, -0.092184711471753791, -0.18878477730498389, -0.66480003207832106, 0.13416722041286328, 0.27166144449420032, -0.0057657108903320844, -0.14003457852902451, 0.11726645105142128, -0.29874986991602465, -0.13228240232432106, 0.47365417896373446, -0.2180191734441343, -0.15177494447878198, -0.13858117119229349, 0.10008248525422433, -0.45303256187429386, -0.32856755390415499, 0.39055856968575337, 0.625760228661281, -0.13909731088816002, -0.18701114376850406, -0.31631745945003553],
                             [-0.00287524389303076, 0.17531831795598732, 0.14358597923350325, -0.13516941998269316, 0.061346562938303976, 0.21740190384142857, 0.039872880607017283, 0.48988310210407804, -0.1763006405591041, 0.077970766160560451, -0.26190595180439613, -0.19509907936033147, -0.26081870213757608, 0.19511688347087086, -0.95734833523531737, -0.31912033007910129, 0.03153960229668358, -0.18807384426291537, 0.38309440245217169, -0.088164652379744524, 0.5418899964060786, 0.26996163479645813, 0.15182349401179443, -0.087413852077956739, 0.22330721043750282, -0.078076236136218113, -0.34440294854200615, -0.040224632531542286, -0.21893179514534383, 0.29305410570720569, -0.15470632630787973, 0.11971538819083069, 0.36056977581383121, -0.14053857129983161, -0.21575565444041853, -0.31428145949253189, 0.21638729730950665, -0.19839437190985276, -0.060375399823849263, 0.2605403242059649, -0.24770224398838031, 0.19752649652102264, -0.19541589584241259, 0.14537308522200254, -0.014224197933485516, 0.11026998279352047, 0.079628934303642249, -0.45437697017143747, -0.15848170194204536, 0.2577186604138646],
                             [0.59593638273275529, -0.13253452375108946, 0.053498764494097545, 0.25962836338942669, -0.11005548435346191, 0.10689052568447605, 0.0027219763501589028, 1.0148351948156862, -0.14278243486181921, -0.081048875081646155, 0.23017532722609862, -0.088697954399178894, 0.016718252580244914, -0.14524107403056413, 0.41381833094570514, 0.085534943409439373, -0.21412268534202783, -0.0073565149563133356, -0.19814474938364171, 0.47282985291944241, 0.46174508369582462, 0.10584499048935969, -0.1679521679488018, 0.34123702845414444, -0.063505042006751292, 0.22167671276535503, 0.14209609570941581, -0.039937141553793423, 0.26059600494598445, -0.23063043675082648, 0.015271617259441098, -0.38813041711838747, -0.0054500818783712436, -0.21972996055998859, 0.36252386710009515, -0.25577705295567676, 0.25812762766395758, -0.36810560261634007, -0.025602199040236941, -0.022348888348223721, 0.10144075389467455, -0.28875715184529432, 0.20283143504243062, -0.28171057792525489, 0.018676154390053105, -0.30679197075437981, 0.1305570590194286, 0.34803145649161726, 0.24206919861464768, -0.020687131191876772],
                             [-0.43858810286057637, -0.37417243232759373, 0.14457972013492043, 0.29313771943912326, -0.0054056934110785076, 0.29903496974590571, -0.17873723572672989, 0.14255736188506915, -0.38811681205580345, 0.23497281180258259, 0.67443597529655319, -0.37162386570573946, 0.17650006331164614, -0.14369112910901033, -0.17902129211768769, 0.053009798566701176, -0.1630025227010643, -0.35752933343329452, 0.43077391658295211, -0.19356714266298508, -0.28072549270620201, -0.25734124423887544, -0.11198328330765765, -0.072088884307732776, 0.039997142208771902, -0.20471635919076972, 0.10036592917644795, -0.32874035090433879, -0.11813598544702568, 0.16046617331044152, 0.099252342651775696, -0.33547592632483569, 0.40043879348559136, -0.090465064457010774, 0.046200649277056187, -0.15385467393245908, 0.086218201946160755, -0.10638428782446951, -0.24794079242818029, 0.39866462385113871, -0.41294011199322878, -0.12854651950849039, 0.20291246178303673, 0.05404606993863019, 0.17831277203532092, -0.18480870999434154, 0.45392920423478816, 0.30834322164276856, 0.37832825883444571, -0.37121893770062464],
                             [0.086760272100783992, -0.67385969053515604, -0.35043861612860766, -0.040548936691476488, -0.01517734056055069, -0.11432300251768707, -0.27601197268573008, -0.0089448372347961901, 0.34399427518117548, -0.88166430501227111, -0.12229035371586459, -0.020122534309284863, -0.13256316724798892, 0.5438043386024336, 0.20718361427234694, -0.73709875659040403, 0.20561007705098369, -0.073072410455008896, -0.10927591445962652, -0.18946168810318448, 0.32464074202992821, 0.17149334814889461, 0.37279012170843701, 0.26218774913750231, -0.21255222678927929, -0.10900192315888527, 0.27742100088448762, -0.37208938056882096, 0.18011109901857783, -0.050555466562526866, 0.12420256427332196, -0.012922111808239449, 0.47398935976159379, 0.10068509097180608, 0.077884995871692536, -0.45919202406710014, 0.046429305039720072, -0.26410721328662301, 0.41239814568689481, -0.084130799318430441, 0.067190362264830578, 0.13517284146194516, 0.30613676301021153, 0.049665288617625952, 0.61269573071617467, -0.31757577668446774, 0.064952553573696933, -0.0054632755219780893, 0.18302546873054817, -0.20655461182177171]],
                            [[-0.60610376368169705, 0.47406499611439856, 1.0853480391448516, 1.7197417185508999, -1.738146836029846, -0.90777807701135838, -0.50369576122949733, -0.57709524430028747, 0.12914419269373659, -1.3239172824089085, 1.1500205642210952, -0.05581572818370472, -1.2235094857346818, 0.53696315494947122, -0.49493839221292857, 1.2835551846638973, -0.98840014102686991, 0.62001895829112308, 0.45679398215042588, 0.090846736566981931, 0.32426174447834716, 1.2007407085221775, -1.2230475096062716, 0.26759928020018653, -0.59039330681922753, -1.2783127562058723, -0.29528901171839311, -0.3615842183421199, -0.8421901632496086, -0.23442680219073714, -0.13890097027906173, -1.4009438437638788, -0.79103063723648481, -0.26589147010949665, -1.0719177737443601, 0.70591509997360902, -1.3497322136196459, 0.9133488220700906, 0.017352614501616723, 0.33358314664428873, -0.83535437826377679, 0.31679577733245073, -1.5028000826514019, -1.0845400192575492, 0.50663820069449128, -1.4659608837565392, -0.52632778737569097, -0.193693450561254, -0.5600346897036721, -0.61911940690669831],
                             [-0.15069261640326498, 0.43688499839441286, -0.042020086496545928, -2.7574562561214466, -1.2067413554193864, 0.84881433043342747, -0.80356427387123497, -1.0647983127352569, 0.48799004447976574, 0.14851742128641765, 1.0345039370889695, 0.63457836481541241, -0.53287285784304816, 0.5177632328826336, 0.26533835571229486, -0.24657363914106448, -0.45757379877202203, 1.1256996209250714, -0.86888119558804655, -2.0081407978896824, 1.0566305238419569, 2.1118747142043675, 2.1269887679379051, -0.21900647629364178, -1.9988248580568055, -0.5933241642721695, 1.1745303903789539, -0.25268402274394253, 0.96609838831476069, 0.36047707780470095, 0.73540916912858989, -0.2487053469631359, -1.5588011526068339, -1.0855482453465937, 1.0860491748202157, 0.69092955700892122, -1.0614617613644979, 0.26644065604446787, -1.4959319658211367, 1.0255223732883869, -0.36524961582521642, 0.77029109968859522, -0.90148355091525945, 2.8597396596361131, -0.28022621768845746, 2.267135162462754, 0.7191412342143062, -0.90844720625632691, -1.4313576876570215, 1.7299020606538482],
                             [-2.2010985227676061, -0.26739906960621129, -0.49462139377284381, -1.1694219719357777, -0.38503200846231855, 0.1667257925135871, -1.8228034381341236, -0.0093659935641268732, -0.14829245080670592, -1.232332292480093, -1.0958671671352838, -1.206140296051702, 1.0844296223879684, 1.4541844141701445, -2.2617289368010427, 0.2250264866348454, -0.10882820635775016, 0.361221265850099, 1.1710905123165036, -0.09784587553222035, -0.63445920745349627, 0.74813934546132854, 2.304308988169474, -0.97422087342066921, 1.2615492981971836, 1.2595040817052185, -0.67812912426884542, -0.35968494429312503, -1.063906357925033, -0.42371061052654435, -0.033676115468829426, 0.46727484218673287, -0.71849705174702794, -0.57791059520583032, -1.3636502526600149, -0.34737845851659521, 0.44297349861090696, -1.2837276380743348, -0.049375930482932262, 1.3679560303873468, -2.589700658671235, -1.7861543744514146, -0.64420735797356943, 0.16609458881575606, 0.0041568682763020587, 1.2168050759266631, 0.76816885347469221, 0.68273392726652526, 0.060932270703309102, -0.62205327164991098],
                             [-1.0618631207671858, -1.121916812667352, -0.072031589174278293, -0.48454036749997181, -0.69614205942894936, -1.818682175831654, 1.0799422024785339, -1.2666680344528902, 0.21590968692119128, 1.4639561994739858, -1.2378867338411432, 2.2855970133435868, 0.9541299384209817, 0.15222398391629263, -0.23920338487202353, -2.8876569768531035, -0.60531798878594434, 0.28568344537929818, -0.66714632749091418, 0.53309567478187725, -0.22361790957614483, 0.42529709038395824, -0.39395975318274767, 1.9008916685536346, -1.2909581345921053, -0.54678363467862479, 0.62406617245076446, 0.22304082689418328, -0.26327425540447952, 1.4539802391070715, 0.73575705912822198, -0.76579104394842512, -0.058032026432600983, 0.78963356442496957, -1.1250999072335703, 0.22137774311459185, -0.25429581874374757, 1.5934065131494617, 0.041132909994234135, 0.23880600190515058, -1.5802413285871588, -0.49351170442463088, -0.77942120856375274, 1.0610955115868104, 0.54143921396344796, -0.6442320591020213, 0.40176883640108624, -3.0896282002911226, -0.41518502011390684, 1.0340351735135147],
                             [-1.022718609462923, -1.0973040100253371, 0.30476956838874036, 0.26701835451634776, -0.36311196839447796, -0.92879290818480398, -0.55205111206846391, 1.5598775665048126, 1.7098397741826799, 0.81424839354043232, 0.12197593649689016, 0.1397116893978417, -1.4585844801691306, 0.76233102655716256, -0.23890733907342718, -0.28829118858303898, -1.678911821633903, -0.020546837541002737, 0.74270520133416451, 0.7962052055065324, 0.18606104443792576, -0.79942492075440974, 0.45059352875900249, -0.92028748716654762, 1.1892388573833008, 0.54884438370470823, 0.86169128698446296, 0.2485375443817836, -0.15230029992027388, -1.5281049542286218, 0.59940426738804964, -0.2180018575635311, -0.0905363161851402, -0.15955039996406756, 0.66308584107774715, 0.030972414097621408, 0.20859863713287535, -0.34400605056094524, -0.58800298957985209, 0.37696618040505608, -1.0749071404160648, -2.5458094512429019, -2.8087470521764377, 0.28154852798226326, 1.1079405811703353, -1.5501064048829958, 1.9645994205325392, -0.50417737354541214, -0.28648511918865549, -1.4002049179826392],
                             [1.1500292658696456, 2.1651213941978216, 0.23995882150741624, 1.7191694297566915, -0.72941355490655624, 0.23173049013468117, 1.0526101656109321, -0.42447560172904758, -0.064121517537304426, 1.4636832154706891, 0.065940015054956364, 0.93313122397420611, -0.20509431780509041, -1.1808575095008116, -0.2665932146555588, 0.22778412492063022, -1.103869856088403, 0.4534347917949974, -0.93771820488003088, -2.0661360001208315, -1.6206741540822955, -0.279598350771186, -1.2093896681381027, 0.15976184027029311, -0.67009324031124262, -0.46182904926630008, 0.029029151886098978, 0.55756883745152996, 1.8124905089831624, 0.77122268663960092, -1.8453224864636586, 1.4289221772552696, -0.31237675648720381, -0.17817166395115205, 1.21393038161615, 0.68547633546788311, 1.107318850228894, -1.5160969783288134, -0.52843550419364405, -0.14784456826183484, 0.75300537353880181, 0.25542386654906379, 0.92185514766556809, -0.67709211762999266, -0.48853602824160441, -0.33058384210836461, 0.12206817064950586, 0.52583308005385376, 0.012050847277942263, 0.44782079414470222],
                             [-0.61502965446407765, -0.44597585765683018, 0.65632063817287722, -0.8267810210746821, 0.56863638404524042, 0.23881051458119534, 1.7023463337795424, 0.95540762813648827, 1.1766053389458042, 1.5292375881192415, 0.44643885175049514, -0.48297063614819391, 1.504588949353564, -0.7339331175240702, -1.8469683761325266, -0.39064357633665464, -0.71843801673253027, -0.67773520196624071, -1.0280817860859763, -1.0047232976326173, -1.5998018305811343, -0.29475981630173503, -0.81584671419227761, 1.3498660117242287, -0.44653126464530118, 0.57325744248022337, 0.77300612591797824, -0.75068344011166332, 2.1498727798255057, 1.2541441555327009, -0.84369356767973225, -0.27418630414690354, -0.68795421373285115, -0.24475320258400374, 0.18580591260265178, 0.48194272886701328, 0.042369931467122479, -1.2071669445525142, -0.59147155656986927, -0.24027237082578151, -0.24025883168371159, -0.93622840236848281, -0.86018927733720996, -0.18257399521020243, -0.5135741839808099, -0.20354352955275401, 1.1852081210341603, 2.7279726389562757, -0.74633867955586863, 0.69328119641666075],
                             [-0.69842086975209816, -0.20815433682940887, -0.40025267200062098, -0.61313147678440083, 0.16265413335571041, 0.64150076971486925, 0.24364051289747218, 0.050791456479718111, 0.35299793674734192, 1.1319737109662678, 0.27070783774084672, 0.38130914563846158, -0.14997861205579835, -1.0765153033139354, 0.40449746496826744, 0.065552051871918177, 0.16930921425126846, -0.82808796552191866, 0.59812815638444328, 0.22896692983620756, 2.4196847126429644, -1.1146820419930232, -1.0929190841477618, -1.2539484125513165, 0.77908506349254569, 0.61923621227117098, -0.99102931575136355, -0.4123778935090941, 0.18088237099263299, 0.25406190800766815, -1.1263832181904099, 0.14758773717139914, 0.32836044694382249, 1.1238714129394485, 0.82660650235516564, -0.31195438258845926, 0.40950730759619708, 2.5447297973529848, -0.41491659025772853, -1.3548829320101081, -0.49479189846353411, 0.44687041607441041, 0.53122233878462188, 0.56972173730053732, 1.0590431880432567, -0.18357329234694761, 0.14685202499426381, 0.024845462461305978, 0.34248911189194337, 0.10898247502176289],
                             [-0.4998257738766409, -0.70792361786986779, 0.73097346555503062, -0.244165200901822, -1.6440181600972308, -0.70269885515684316, 0.62103955147126677, 2.1831665110119141, 1.3261124289310655, -2.2876040936010069, -0.28514267142194893, 0.15975572081508022, 0.23963721511554437, -0.75391606692326429, -0.77247352145090642, -0.55786488667154388, -0.31469214344617752, 0.23306573621578947, -0.87818777737464637, 0.5025437951423638, -0.89458851444549536, -1.1643910149979977, -1.2925475532649204, -1.3569823834979593, 0.67226226177661852, 0.087251009731646512, 0.23806281499572596, 0.98880729059527983, 0.018544607041616756, 0.6017096629927835, -1.3521260201962639, -0.76190132222199436, 0.58729687194513536, 0.95523734854074371, 0.4774565589851506, 0.65527945881869942, -0.020930226532896667, -0.43627669152110493, 0.36207738908887516, 0.041319040076888247, 0.07753314947101847, -2.9629435555309103, -1.3894107537610709, -1.3013001011684393, 0.15354135480846753, -0.12996183774925463, 1.9198901126757375, 0.11183434648237234, -0.56724587823255457, 0.8405614713350531],
                             [0.86176511203142647, 0.22039451988414999, -1.0704021220432018, -0.024042202642547021, 0.45286685461212445, 2.7312525963792189, -0.54139380590416053, -0.73092663499034738, -0.57152919266626989, 0.4792545816157272, 0.064555369621881076, 0.37912043470725398, -1.5863074173393712, 0.66254894461424962, 1.211307793088507, 0.83835082691423612, 0.75917387106379786, 1.9687454992888209, -1.7387539944168076, 0.84788796774627673, 2.1576877036162205, 0.85171904628786954, 0.28945163441719007, -3.2960480195486115, 1.0812883829828355, -0.2167705759057561, 0.08291699486065493, 2.115189171020579, -1.779351543003032, 0.17364166796505007, -2.4479529690783517, 0.97560976651242659, -0.21774185955994055, 0.30012778794696549, -0.016233652023624923, 2.0936988622898172, 1.8428962305511039, 0.32199881616120068, 0.30232516933877129, 1.2410753258724734, 0.87972139821573125, 0.73950880770077276, 0.085106775677112945, 0.30375154048015174, 0.8286727041788815, -0.94151162424999946, 0.61068175136150615, -0.82236136452364461, -0.68490712540590715, -1.0563859364863237],
                             [0.41358831399975016, 0.10708593136385886, -0.020124293656119674, 0.46334809088265838, 0.082073110222201429, -0.41537851348630972, 0.66707170406477845, 0.078359643410468138, -0.53421331970865049, 0.35860702222128388, 0.75753900168690858, -0.24335582386224167, 1.9481422884041562, 2.3949301739121687, -2.455009344080695, 0.90867596333543921, 1.0010944813646472, -1.4785163219136281, -0.4674338432384833, -0.12637205125208162, -2.5356463012622714, 1.5533913622981619, 1.0021814282613704, 1.6723502535611334, -0.33556420629869682, -1.5302879434535863, 1.6095505904191141, -0.33580534945899532, -0.90235697286067695, -0.22863491231240884, 0.020965945895895177, 1.3461598552765954, 1.5694222326709502, -1.9239552386430931, -1.9412624827657274, 0.69427924865621404, -1.0259415521843267, -0.54497810838127902, 0.25932860418770443, 0.57775611445356723, 2.8271157031842398, 0.65379923635877379, -1.4948716796508639, 1.6537154029510255, 0.51665695204419149, -1.3267421278000626, 0.76624897196264175, 1.2157903150254978, -1.2340760366783614, -0.66410773059722705],
                             [0.084551534927970823, -1.4270114637906055, -1.2714321909400008, -0.14755907859402753, 1.6351053389516943, 1.0834995597585577, -0.86583022959807743, -0.67701963273713794, -0.2892324327770901, 1.559941209555719, -1.0325757217367419, -0.72542526127345131, 0.13811327043917651, -0.46099973587970511, 0.88308142202882256, -0.81593817829389659, 1.6149267311056532, 1.8565013260548535, 0.59214754758130439, 0.24918625871524752, 0.6288100005760523, -1.0915519687460871, -0.9596339240073446, 0.068582382405687592, 2.4574652551959235, 1.5747933004376629, -0.46166270902092177, 0.33606275400818553, -0.45789635765431469, 0.032359705587828629, 0.29610772803375551, 0.32595876775799648, 0.75209583913737976, -0.22817386495992389, -0.18285195475993427, -0.62221573180701439, 0.36338569188208231, -0.69704673047038246, -0.18878202472255934, 0.77977582983321536, -0.94384092595719771, 1.5143750442250603, 0.94397162036734938, -1.2038605337252166, 0.21293457813737557, 0.17549915923106102, 0.6619827251206668, -1.9248193626201882, 0.67949022552343374, -1.3052672220894717],
                             [-0.74543011547305782, 1.5667350842204637, -0.79912391521142978, 0.09654315055914596, -0.40978875176286428, -0.22247413088670889, 0.10921014894537304, -1.2362950597385958, -0.40963357451908811, 1.2903981470742092, -0.19850069730563899, -0.39571209849643141, -0.80385143151405491, -0.45365811723844929, 1.6844598581958981, 0.260939625185241, -0.76809050488752184, 2.4344429370693308, 0.89837551047657216, 2.0343937880079053, 0.16414682277645992, 1.0189460637620249, 0.54566823937343378, -1.0421741023268536, 0.88831692854858335, 1.2191155866519015, -2.2466802937561816, 1.3799384117827496, 0.56457300266104404, -0.57984626451642796, 0.79036114270609736, -0.83654724329007879, -2.5275605434634825, 0.59055564723341247, 1.9368672658385799, 0.03788554724086908, -1.3331306992030645, -0.24807472649931217, 0.87875878025252585, 0.51621852634395271, 0.85892484736024266, 0.70018210586469876, -0.021035978306106821, -1.4686358094049898, 1.1943405660710285, -0.35899340341900721, -1.6558622620192005, -0.80764240327845771, 2.4374264542338131, 0.307838556568519],
                             [0.83637187465329899, -1.6812344350023922, 0.080558562944662293, -1.5903871668793947, 1.9702305221161631, 1.0594745420523428, 0.35595754629997667, 0.25588261952911578, -0.67119476292165781, -0.91868626771911466, -0.92511788574574161, -1.3309864200323973, -1.6567407107526546, -0.013485754110125536, -1.9973870731673058, -1.9643244897247563, 1.9547607653714951, -2.3777446642403257, -1.6495149903145294, -0.61734067708337237, -0.914613579423047, -0.12888721416812349, -1.0216240854223033, 0.33007185489219615, -0.52985806033022964, -0.44523624266560702, 1.9743601317390775, 0.036251716323744076, -1.4730295031843745, -0.69594299110813029, -2.7732373528460181, 1.5354147449352735, 2.1996150264640284, 2.0953282017154136, -0.36084247698103844, -0.49381612741100062, 1.4110344068526239, 1.2943391901765777, 0.15145630964692403, -0.28104540132776129, -0.72258114649583616, -0.96368826914101513, -0.00099403394040688264, -0.18056777591740414, -2.0692488437724963, -0.24538865234608467, -0.31299841707953352, -0.85930356787358009, -2.0970861659301869, -0.47067050068283606],
                             [-0.21744167060894601, -0.33091899528112134, -0.85548076650316085, -1.2742267766429907, 1.9686000609561864, 0.90936000809269668, 0.2523263608588483, -0.73209125478098636, -0.65075500026906252, 1.8445929797499037, -1.5470773235725945, 1.0776566872192612, 0.046708600514581568, 1.3322459288341664, -1.1212602123887547, -1.3416677522204392, 1.0447788608073836, 1.4508803713856688, -2.2892074850579909, 1.9361959553532437, -0.048608474730176515, -0.0035684638625967657, 0.63490899166155657, -1.0903146803732846, 0.052261302678297317, -1.3608527092091198, -1.1884949980455142, -0.12004972162969332, -1.936024721200643, -1.2675663481528852, -1.2199752801821866, 1.1448988012508261, 0.48258951370879821, -0.77055198775754463, -0.46379086255460222, 0.2078680864795816, 1.9971374281510992, 1.3805284849752537, 0.69216621222833929, 0.45075871299855452, -1.7115202463721779, 0.88865464255228832, 0.022168899645453627, -0.088862187328891951, -0.24711323459257667, 0.053814817475089205, 0.24002742455337081, 0.46936014928307268, 0.67844753689015891, -1.2021631697504764],
                             [-0.34152567864698896, -1.1111260500313418, -0.081914284003378954, 1.793326765366495, 0.033259027912294958, 0.47376562362191382, -2.6570665002560938, -0.96477383309264608, -0.80415960843233525, -1.652134635545208, -0.46681072146840213, -1.2399326573058664, -0.30533008131795469, 0.84058929227880452, -0.78582960543404801, -1.1850282071763381, 1.5001929130713534, 1.2663219377852559, -1.7710772754568569, -1.3554381297715719, -0.76543414745098126, -0.55759438617572854, 1.5007672932060163, -2.343323460209783, 1.5443963453545446, 0.21077091635823941, 1.8251660509033034, 0.58867386532400001, -1.3320740163005129, -0.64928827865755845, -1.0092681806416897, 2.8663000457536714, 0.55455848898831728, -0.13289348325370456, -1.7488251818808036, 0.27830990669397487, 2.560006310340432, -0.48953335164995881, -1.6796588075717311, 0.5865632386778018, 0.63251008903292394, -0.90563103622092911, -0.3732102789099952, -0.11841799228886507, -2.0104365238586448, -0.52102262689220602, 0.10587805341329318, -0.39513299200721275, 0.3344390039859183, -1.4853977036952797],
                             [1.0447907710364701, -0.14303847342796192, -0.57999655531035865, 0.988038485217138, 0.066788455454151768, -0.76632164661126456, -0.14647166282756668, 0.0027907167925258908, -0.96515638957523142, -1.0952839039767739, -1.17058938252528, -1.6464749068872102, 1.1487400696335335, 1.0340753601609336, 0.41397400273836893, 1.0684507724814774, 0.58158806074718317, -0.88054915851935811, 0.9131306629901671, 0.74910928721846437, -1.040507363092507, 0.020759952962029406, 0.40725991557385521, -0.75839351706763525, 1.0200351914742289, -0.15979146292385221, 0.06441363961971816, 0.26587821528488481, -0.4003053126656968, -1.293152050718509, 0.69507169748102648, 0.60822591511750113, 0.61693281678360878, -0.18621334609254503, -1.7008904355021042, 0.012197238512870582, 0.28825623902089703, 0.5213572085194087, 0.79705675463573233, 1.658163530829557, 1.0127601074665926, 0.0946164673171042, 0.37013181611715851, 0.6768869162664588, -0.69540847494922109, -1.8306797336416951, -0.66032837709395065, 0.42249862687850964, 0.45680547347273848, -0.8816082914970429],
                             [0.26577994377273667, -0.97447097168726526, -0.15193336275842834, 1.2068232253704931, 0.15306783113773048, -0.97913321834227918, -1.982644628189784, 1.1232288401806307, -0.87126239598954691, 0.28001032113483881, -0.86070029990330088, 1.2953254193163506, -0.97007507478519694, 0.76524551025815113, -2.4084133234291261, -0.31511454020651763, -0.68242219505443114, 0.82743670558607951, -0.86176887310993722, -1.1064516730131655, 0.54373459660962631, -0.034303040732641704, 0.048524513245952083, 0.27661200053753054, -0.04964182949249879, 0.80668230060361079, 1.203703970099723, 0.32477689531205933, -0.7297380030861389, 0.63660010042731707, -1.3872166465320412, 0.33037010607244216, 1.1640814329582789, -0.088589767126124958, -2.1389461631032765, 1.1539585657250155, 0.78289211890203947, -0.40459086933869337, -0.93769039725083358, -0.18531213821703779, -2.0145188691833797, -0.42204748970321371, -0.71368548405589793, 0.82966695885472219, -0.9951720946917133, -0.80811866808758048, 0.95471742496008383, 1.1785385578278518, -0.12748380282913263, 0.65255626800593558],
                             [0.75226776876369383, -0.58318711295705183, -0.9675092312062934, -0.55956097041375952, 1.4021194620172923, -0.44771079208306142, 1.9830684169435897, 0.12753547426299058, 0.44275217514245574, 0.7448852633646792, -2.2630154894842454, -0.095222509579687697, 1.3271591679715073, 0.14410179895359931, 1.714791787917074, -1.2949919611105429, -1.9580819067692319, 0.61187466920230682, 0.059757971456440538, 1.138866486373209, 0.91750764908802562, 0.064810202498138236, -1.6933489332186642, 0.56135859306662295, -1.0129088027539306, 1.091994754537374, -1.3233577339754921, -0.14801192299402233, 0.32939871015536376, 0.093894410511962206, 1.2634395108920682, -2.433554447722992, -0.81499847815119664, -0.54680661884732196, 0.9587047318659615, 0.90839895951216953, -0.85800921290542043, -1.2769419993441438, -0.740485866331409, -0.91936821493213705, -1.3347458896555557, 0.53473837354853848, 0.28964444044904647, -1.4635480391231703, 0.81649739403428567, 0.029278806863574813, 0.48842084541271769, 1.069911530450907, 1.5679646256934996, 1.5905335451928331],
                             [-0.22243388688596868, 0.19550033605024647, -1.2390357920725825, 0.14358090615305269, 0.12552664592778695, -0.18574325008568193, -0.47432286234294524, -0.96444431936070196, -0.26109026913858957, 0.88412730540895001, 0.9044710482321241, 1.51301607092304, -0.45836605609364534, 1.0421321107400572, -1.12262307234378, -0.17828821653644322, -0.22601547296361341, 1.5555650535652299, -0.92552355786281426, -0.3014512684822, 0.48572041337065869, -0.22659007174801726, 1.2223414215259714, 1.6240650583840401, 1.5540456427139995, 1.2282901258726655, 1.9044262030836894, 1.8866239802480229, 0.33531869413641646, 0.35385120211252369, 0.13508800665901544, 0.84397541334197779, -0.13800571941534712, -0.59051219956732526, -0.97104866628764364, -0.24824392543590013, 0.31785623795936879, -1.0002542217120101, -0.006843897473486682, 0.18104146282616365, -0.088620564164997084, 0.88411197159549215, 0.6238068471532312, -0.57895693831971462, -0.89625914135624463, 1.1806113154595919, 0.71024064371138562, 0.66381153396710402, 0.35796834606796385, 1.0576930178594934],
                             [-0.20764499458071289, 0.3238122467369951, -0.87290816990627673, -0.0043998860302733034, -1.2206129028129968, 1.3215684536199488, -0.96131553176467988, -0.79413406801178765, -0.4671265378845022, 2.6159041167619841, -0.74395843770510584, -0.61879084091127368, -0.58238767651091106, 0.40140991668514875, 0.49109722887740109, -1.153974793481769, -1.6825139496931871, 1.7087157404697633, 0.93327523661336775, -0.20323245726928002, 0.28249178921493723, 1.7922041563045215, 1.2723657849510519, -0.83291507582439717, 0.058579946938338318, -0.72663694274182733, -1.0970691879701673, 0.5724873182407173, 1.4806208052979031, 1.8939711355548372, 0.70721865971136499, -0.29491842688820946, -1.7077120487988759, -1.7064237867974983, -1.0375368154611098, 0.33455137632877935, 0.054884429185797723, -0.5047662016993586, -2.8773318296486323, 0.70419290364758202, -0.26936039644730231, -0.47210581087573511, -0.45072200900614362, -0.088070807385643768, 0.93310631166784508, -0.82005517346405743, 1.6142285010812472, -1.7158593018512518, 0.48940111400499214, 0.66197523798828084],
                             [1.1751524013454175, -0.33382323140473674, -0.9881159122578077, 0.47297687587624543, 1.2627656766634228, 0.40468773249445866, -2.2208940810580478, -2.0529161369873408, -1.7766980296937476, -1.3754796198429533, -3.3946590682156716, -1.6419073813597169, 0.66409633539505974, -0.48569760044327415, 0.14757979127836024, -1.2946639155981712, 0.19713122750130727, 0.7473577670689675, -0.32800034558488705, -1.9757234678225988, -0.023350598788756907, 1.2567287668887794, 0.30967499616247796, -1.4913149925323717, -0.49572730829896894, -0.89062920032566784, 0.085490473772353609, -0.84856067133377622, 0.6167092783238084, -0.57006660241111529, 0.87569034358036513, 0.14153419797755412, -0.56211658377963891, -0.68872807967179339, -1.508325079881951, 0.330362930181896, 0.45464871434346488, 0.33070967663520395, -2.0079877836931024, -0.16996443660884991, 0.010925971083784236, 1.0403389284531366, 1.1110895234481581, 0.33384748220782523, -1.5776833429508563, -0.80201806608946646, -0.85574633642388431, 0.97910919169665389, 1.5856469449778867, 0.00038272710748638028],
                             [0.37093840200000244, 0.34584485999514414, -1.6882795931108285, 0.79922601826594764, 1.1315023748905257, 2.1756254883797079, -0.81701834279076846, -1.6170299280543383, -2.0146514880447373, 2.5036942420091481, -0.44833268630487366, -2.2778526434637341, -1.4308659967244566, 0.063518476063350149, 0.63571828543838194, 0.53410151605118017, 0.47139784783621469, -0.10882043276997819, 1.89435257292711, -0.51226237388323859, 1.2434259757094159, 0.25541467817644625, -1.6053638540980719, -1.887031988807107, 0.1553239258673067, -0.52991351946202525, -2.5516059021997299, -0.487599388264505, 0.50003383506306898, -0.16972597970597125, -1.1751769048689786, -1.3893676121173411, -0.71265611929419215, 0.35968872824739045, -0.055071969291562467, 0.32036222678327203, -0.73102740470619254, 1.6966178542482147, 0.21269780321810391, 0.69333851905541788, 1.3106381086174081, 1.2342555839183962, 0.95223240116918006, 0.20194021910275944, 0.176973593248892, -2.3226425067695233, -0.94085188232670736, -0.23517822339995381, 0.24304561946324577, -0.76552738553014787],
                             [1.3949188539513058, -1.2721249876116842, 1.1200189689882498, -0.38829494329266634, 0.42157544751952819, -0.90565140501213548, 0.050116946167808873, 0.91559450067337211, -0.11165451568775819, -0.3798093285530908, -0.7969916066178393, -1.0714772083888775, 0.20763233247860133, -0.15364183293522701, -1.7543868939356668, 0.066435442272517173, -0.97149455332629397, -2.0241553413024307, -0.64567386195386722, -0.54593042200106823, -1.1579114079893584, 0.4721680596180699, -0.46672184156402641, -0.35585911853410812, -1.4243018038206341, -0.90073130428380233, 1.1003926542315376, -1.1766454153474331, 0.78592138255649313, -0.2049053749228533, -0.33889061133354015, -0.91229808607189145, 0.73293655115899647, 0.47873403814783988, 0.88555471170896949, 1.6154495858749471, -2.0081107841064845, -0.022065847438343972, -1.6178820611237505, -0.64139918398967988, -0.21051390385004448, -3.2718307652792498, -1.5328033729941999, 1.0027228916254107, 0.36781468890299307, 0.61462318610790234, 0.49464884002227266, -0.51175957314493903, -1.9165783078256351, -0.28376669434291607],
                             [0.036257607036064975, -0.8077004855271237, 0.40318392054777552, 0.75082569372697483, 0.27911985521838467, -0.85827731274878927, 1.0813867604409912, 2.3986371063632701, 1.0227479244323558, -1.5257622378335745, 0.85322720413381614, 0.32601571949490987, -0.083647905620198887, 0.99171871740392459, 1.3096136372498131, 0.010088701493234029, -0.12885867474760626, -0.44411288307292451, 0.66993342069209505, 0.040826439107385259, 0.5283480873351627, -0.05444816006149894, -0.24417157156650493, -0.41436559669057227, 0.41275041384294875, -0.74368626130058524, 0.88885014402610918, 2.1628349299264285, 0.12914557819950379, 0.25373214958839474, 1.49036107908069, -1.1514313606812918, 0.80141117838973108, 0.61079612046639142, 1.7236441836247123, 0.14153926270158018, 0.85373918818478456, 0.56003449714788989, 0.42425248487075085, -1.087443690913086, 0.076672973818338902, -1.142987126594827, -2.0790942520789737, 1.0328838651130807, -0.26295810609118359, -0.59592514347901049, -1.1558533200898224, -0.35989550624133854, 0.67837175916260006, -1.1889393604101133],
                             [1.6262088839953199, 0.11968210123523035, 0.078586769391301159, -0.11950090349862386, -1.938385084842037, -2.4173590493147405, 0.38596205990384569, -0.59372115575179041, 0.60626406917912723, 2.2802957721943469, -0.12345633085038701, 0.76290456342010304, 0.26217157115969358, 1.0171787913153043, 0.53365687952547747, 0.052570704341323715, -1.9034795780896667, -0.71114080239667066, -0.64835197634212505, 0.37046840433033035, -1.846466620101761, 0.080827796335076085, 0.46777136448941659, 1.6198769210250239, -0.16300427603365458, -0.94986248791482997, 0.74096386972963146, 0.39708340745039949, 1.9343733152810489, -0.0083151980734436151, 0.087414970569424266, -0.30174058011970883, -1.235422925269126, -0.50982993138830035, 1.065875587187292, -0.7285555729592883, -1.1174617612727926, -0.42733887228949857, -1.407270740479263, -0.084639177978689889, 1.7390753930234644, -1.6640176308734911, -0.53319993852148651, 1.8570628690349991, 1.3845235272256096, -1.3612123862679539, -0.013999890336398646, -0.27056499176519416, -1.3375742782321136, 0.93894001362154311],
                             [-0.74727040847866066, -0.81233483394251227, -0.87766400950100643, -0.56704020230327401, 1.8718695014055327, 0.76816493281488829, -1.1995773422954568, -0.52602625402174186, -1.8157279211091646, -1.2687624066923822, -0.4231657147588575, -1.0824833315610352, 0.74449961157059541, -0.51284911188479965, -0.91667178357419987, -1.4952209600940913, 2.6881586062857212, 0.24880199531829367, -1.4934646751341514, -1.1537773593635641, -0.11945030508773187, -0.7206678668423403, 0.991438850539621, -0.069667121682655431, 2.2154485646534234, 0.35933873368654046, -0.14850491475088257, 0.11388495068065267, -0.73275835613028484, -1.1415587809570555, -0.14050062225652643, 2.3670160309293728, 1.4361395858346784, 0.36474300710107754, -0.90365353446559971, -1.5936639900139693, 0.94886062239741609, -0.46848438262697872, -0.22354750157618936, 0.89782849846384183, 0.90998410693676723, 1.6705849891744624, 0.83071944704418232, 0.028490689154679338, -1.9676479743778219, 0.29584690963387034, 0.43709774141740354, 1.0817041876149036, 0.66287406341488686, -0.94967352232435354],
                             [-0.21084055176212613, -0.36749271430847685, -1.0370005679408854, -0.38221503753589381, -0.34521611076221925, 0.042121850328691521, 0.48143066690016612, 0.26925940660824188, -0.47584612046679997, -0.069719308490063137, 0.66818633427435992, 0.26705522859463648, -2.1363691679577466, -1.0103428610947138, 1.2966643543384948, 0.7343167576879478, -0.25152713116640785, -0.44602437094392539, 0.49713420876089459, -0.11030466179606435, 2.584922552551026, 0.05507001816115692, -0.88015784521972318, 0.33991246592001545, 0.20281202823560529, -0.63358888851170714, -0.092658152389165804, -1.5550648512674674, -0.38883809628186083, 0.23760419059238044, 0.048318897864441435, -0.040333196183883313, -0.95182976591780022, 0.32426917239850811, 1.1844482008184103, 0.3172711637725687, 1.4158401039340216, 2.3547957128550516, 1.3001996585817519, -0.91013307220171991, -1.5933222011136245, -0.59337227397812253, 0.69448252765480722, 0.23664889295038283, 0.69769263772542844, -0.94774775038732884, -1.0678292359992252, -1.2553295030490104, -0.097854304208648837, -0.43406844432345126],
                             [-0.81650297569711339, -0.96576758691991049, -0.62926616383817557, 0.24123661212054934, -0.076832740483222528, -0.22913863076925101, 0.52081739248887993, 1.2847923217479642, -0.515016014711286, -0.22092398027828161, 1.1164117887844962, 0.18101821257228773, -0.083798259975373185, 0.019750390047272748, 1.1194914809448855, -0.22143001296648671, -0.59685506867574534, -0.30801738270588808, 0.3691395958682212, -0.17606366717824254, 2.4678561288692547, -0.095692707081000056, -0.54269114494622595, -0.66139810229138485, 0.97623310230475446, -0.93382562963674198, -0.093032512101165948, 1.6485557731873333, 0.28788442257906965, 1.55972301253315, -0.4182827826523049, 0.17599205686335562, -1.2479233137132888, 0.8438480823434531, 1.2264788494113024, 0.38139734281178572, -1.2228902198423555, 0.85359978751100907, 0.4641908855234258, -0.25460624314906311, -0.087359758943151622, 0.60873495664301869, 1.0363264582785288, -1.1000226438852994, 0.78072331119270721, -1.675148942258847, -0.0011062617208605213, 1.4271171911852993, 1.5813898404771636, 1.3475527830700438],
                             [0.77204987869653707, -0.58026244528894555, -0.7117816224916218, -0.86211613557796041, -0.86510305099740892, 1.0946182677529697, 0.36796172836732088, -0.4029435319860738, -0.90332634143407731, 0.8356278175366384, -0.92011911869295426, -0.56102253119421197, 0.37396146140493769, -0.32701840710351149, 0.81111295011448159, 0.48228500274503133, -0.51044551834264651, 0.18665674987953718, -0.49225584245912113, 0.67322662452993032, -2.1741677731453088, -0.31867394728350129, 0.36316424391700347, -2.0109740854331521, 0.49999349222821876, -0.12675637084493918, -0.71923215903007442, 0.12607159149373653, 0.76599840285499488, -0.59826052576452304, -0.0089159246206665932, 1.7589597506441959, -0.12093123006525949, 0.71089435265061396, 0.84745075602586795, -0.87053560820130815, -0.33984184252800415, -2.0623377289560936, -1.1000382024701663, 1.6033144641405594, 1.3268631359590937, -0.14827928577822136, 1.254095634766264, -1.1851664341510524, 0.87634127279790563, 1.5952682622274066, 1.0174763528538826, -0.20459691285202342, 0.55320938015972165, 0.63973121097269892],
                             [-1.0512857554779862, -0.86419776333448628, 0.39637849614914999, -0.6277679406724026, -1.4411448453944549, -1.9121448702428729, -1.0923764012555552, 1.0516319061649835, 0.53434340948773651, -2.0164360546580546, 0.86261426616608139, 0.086734031914826898, 0.8852669920522569, 0.59265941342968687, -1.2699372801039444, -1.3515733313351526, -0.46640933598962453, -0.22071383724869462, -0.13091893990385692, 0.57045134392953933, -0.35446236935419578, 1.2266504858896714, 0.93181585001846501, 0.5622158099006237, -1.0322852538133143, -0.83091305778606905, 0.48380535460779173, 0.95374139358848753, 0.25218867020952435, 0.037692322134144626, 1.119614964378234, -0.72540258430943894, 0.4486779183324443, 0.25341409837793011, 0.50432125032237629, -0.63839167605547575, -0.32333960926723121, 0.26325039192069621, -1.7620817036502496, 0.53415147847062616, 0.48052183042417818, -2.8389201566264255, -1.6099702530251645, 1.7982591350971338, 0.59930370620634055, -1.3311671897537309, 1.5291772399864283, 0.19600300107798307, 0.74994868943892767, -0.50813807134652222],
                             [-1.0427421793291074, 0.32083628392404023, 0.1194769448883601, 0.51918448242137383, -0.87548100953321695, -1.4298278802771702, -0.73533645563482075, 0.61848031449051255, -0.94570931127772306, -0.38559173964696503, 0.94216394637089296, 1.3360969058473378, 0.96365783577527309, 0.59127317541317304, -1.0474162753545857, -1.0097873046956101, 0.37715662403563815, 0.43660810259072391, 1.0622328007548465, -0.19632178739706715, -1.6790740221196248, -0.281749727960805, -0.69198218487055085, 2.477582918122772, -0.022880844537050291, 1.2858679487536795, -0.03384969590296337, -0.28956877859299995, -1.2564003325204913, -1.1078200938051632, 0.19860172964645206, -1.2279104759878325, 0.79655781495957234, 0.14359722678298553, -1.0230208716530236, -0.50537011628579964, -0.65212111092232217, 0.3110170432569776, 1.4582575706674812, 1.6694965536967816, -1.4247862119767678, 0.2285884059412619, 0.2151895551210623, -1.5513826750201232, -0.75266776267786895, 0.53638889818907154, -1.4478542756870554, -1.0027632422102111, -1.3147255136993186, -0.60403539771185266],
                             [0.36430016870212656, -0.99732722501798099, 0.88864986612796804, 0.067719928802948137, 0.51900141520763987, -1.1153569449756942, 1.2776196260721808, 0.80014864031515676, -0.23759412724973777, -1.5001474114916316, -1.2716735471512541, -0.22666420009235988, 1.197721747823459, 0.46388485195090512, -0.79863515638989668, 0.16412340983361928, -0.51946423975939482, 0.60936091315196395, -2.8280072837496881, 1.7440901398132651, -2.7945727552420068, 0.51873073546310899, -0.031565328731905873, -0.051390139365620688, -3.2305206484162614, -0.62403681413169731, 1.6653107999198686, 1.4398949396345779, -0.71747246492879113, -0.93441705809325759, 0.46198863305692156, 0.80739740465457288, 0.73001259217100389, 1.2741234968254265, 0.053985615916773699, -0.55070148023654852, -0.18452478400825445, -0.46705822762163857, 0.14003287256203964, 1.0528180354183387, 1.7422585272234163, -0.98676708449930084, -0.24765580736881768, 0.5251684978544342, -1.5039253874607807, 0.8597096824159407, -1.0094234776738644, -1.4235766909928393, -1.1027755826954158, -1.0365371633799711],
                             [-1.3916996508530655, -0.30872454801578514, -1.4493110570424037, -0.098539031143608236, 0.21654336743978292, 0.12612020286809789, -0.45554949642754783, -1.7086150752658729, -0.7834081842266708, 0.68473029567557564, 0.41411230023200041, 0.025605957694999661, -1.2986857228367406, -0.87174198978968176, -0.4243931699759726, -0.12958503815943509, 2.2223734790935179, 1.9743063391997207, 0.67233365883051988, 0.38042820917610287, 2.6830164030314219, 0.33479003400828306, 0.46950223254811602, -0.77894368768672106, 2.3748607065423109, 0.72235377554791314, -1.9902058224330319, -0.081119781547176847, -1.7578660523886751, 0.66803024164352354, 0.26618053591497232, -0.4171181856643103, -0.76229216135471156, -0.33356829098187118, -1.3105490838689182, -0.48823948374494225, 0.56434618790019031, 0.1135438752544691, -0.18920652920985565, -1.2703059635318588, -2.4632410417328967, 2.6869640672840709, 3.3606036316393539, -0.92067961940513476, 0.30571017728533384, -0.075337351523759158, -1.179420222338299, -1.8431177004157997, 0.15141630602871792, -0.81634824072222623],
                             [0.21719295236851244, 0.46549210669481855, 1.2660096177561542, 1.2790299060887707, -1.5694137942832675, -0.95896383011223696, 1.3185659010497517, -0.11404753590030203, 1.4547359550243033, -1.0522046601448269, 0.54857909637484559, 1.8719709638013875, 0.46536053195092053, -1.4354845239250849, 2.8292357741198906, -0.11400778367773821, -1.2868378738469666, 1.3680629530064254, 0.43107226849381142, -0.11985451656317703, 0.23461387658221833, -0.10136059197031744, -1.6649321120197014, 0.58922588770151851, -1.5996065275460154, -0.29823905032433257, -0.81069927929934238, -0.58060468702088253, -0.84008610140814977, 1.2057039808223435, -0.24202979941167341, -1.7839081928985221, 0.93792188969991275, 0.36756865241226278, 0.2269435087726909, 1.0943456280687154, -1.4431365960508287, 1.4816658540900125, 0.40474932174147848, -0.41442025457872977, -0.25637251661069327, 0.55058210147822051, -0.17709493180730934, -0.078574121765925264, 0.64419466048576957, -0.57626122215317688, 0.43685238708072893, -1.4063671212216799, -0.18972316734788311, -0.12754828684029834],
                             [-0.58703215549902266, -1.741493080324473, -0.99012379379999316, -1.6026979050284478, -1.5107291879710649, -0.20393878509344213, 0.10085394933752057, -0.663875110574907, -1.8260321524298184, -0.69392678961160903, -0.21002885652575631, -1.0062438551876436, -0.48323725640362852, 0.83171657333118809, -0.87832375347160574, -0.82176330875003345, 1.4293737019859067, -0.57842485659142717, 0.053538448373054832, 0.85113326388090493, -0.71324184641106558, -0.055730299750943013, 1.310546360473781, 0.50618171103653908, 0.92250332255685574, 0.31210893578784682, 0.71460036093833501, 2.1892460239267479, -0.25585805520491944, -0.11766507766398107, 0.97670813326886252, 0.0013378931596612631, 0.4705727475340632, 1.175074404057693, -0.020225764597587292, -1.7730503632387911, -2.7837616987490841, -0.87543047872127833, -0.40477512143495215, 1.6602651077193289, 1.9994965521440768, 1.1706728709467293, 0.11127320036865067, 0.92562190341197459, 0.12227183850518911, 1.0203491930946835, -1.3221077361607356, -2.1795913710350368, 0.35882925981741165, -0.51369988609221795],
                             [0.39849752950611084, -0.58949548161864085, 0.041360386255841944, 2.6299927809459995, -0.16204029849373075, -0.4912711965377764, -0.29964888306798093, 0.44055932432799183, -0.064279839349250273, -0.1404471015699526, 0.39138718799597072, -1.2334272605194809, -1.6204818581377454, 0.36845991425306157, -2.3265109575448712, -1.1330876460083033, -0.74266057588112766, -1.4076157938563623, -0.017540456620478317, -1.2688151496360343, -0.96768222655393377, -0.27385464026610939, -1.5062273646450837, 0.50514995243215377, 1.6816069775087386, -0.66868987035510141, 1.1516986140038503, 0.80788303151107099, 0.88891941074240144, 0.021113383249523755, -0.014066382849864778, -0.2742766873728264, -0.82637376895690773, -0.31279508487998986, -1.1049611210250108, -0.6572760364222705, 0.34473859214412372, -0.27464433235160901, -1.7374450916947637, -0.50131584393186301, 1.511648439397911, -1.8605645345261161, 0.17804334452806855, 0.4440741594719666, -0.82040361962379815, -2.4586605129705217, -0.096999494272481918, 1.987726322202678, 0.79896823076462087, 0.2264807138526454],
                             [1.4639421071483263, 0.9596684979237643, -1.1130982298414995, 0.64659601375440245, 0.81616739262287774, 1.0551854748041372, -1.763907551568427, -1.335562992728264, -1.2818782063090293, 2.8392825365975618, -0.19842618539152693, -2.5644374189517132, -0.057889539490851252, -0.20459893660051764, 1.2277385886098497, 0.52820043489983903, 1.1849437073177642, -0.42129863053182759, 1.3217456058656876, -1.0744507079907546, 0.23983563664030866, 0.53358660872776353, -0.85087416031009944, 0.55485414602469219, 1.7531167705926451, 1.9707485461947811, -0.65572434735502572, -1.7426769924194299, 0.66431699982314196, -0.50163297400877649, 0.57363497311353373, -1.2705586505706683, 0.93193398915944292, -0.85352195966706956, -1.5899418778806238, -0.14112112906189558, -1.9974054820023699, -1.5684964712303868, -0.19009305172667337, 0.6032956630890175, 1.4613448715000408, 2.483744301212699, 1.4562555154493295, -0.57097319660860923, 0.75504427421581721, -0.12163307293313796, -0.58691401533730037, -0.93765432508036695, 0.14472568147152703, -0.2667321981587058],
                             [0.81621084409689493, 0.90739285216347554, 1.3111066394743034, -0.53745133126530131, -0.055480974050000298, -0.96324260749003077, 1.5477212996243126, 0.50125388482770949, 1.6319802472946572, 0.26464463854225401, 0.16344994805597426, 1.0328117323384438, 0.017925866593355239, -0.027544898556953967, -0.2561505740746351, 1.5677797439295158, -0.87039104430173286, 0.05183511404309276, -0.59452225317767637, 0.70401964200268319, -0.93238692265060708, 1.0071510502371006, -0.52302714019432905, -0.33240035899277565, -3.0063647735391306, -0.58331005938937386, -0.39335899375939209, -0.96509545237540983, 0.10408199176207789, -1.0101666343981983, 1.170562098613638, -0.080026708249651538, -1.0281717611458032, -0.21083725194961411, 1.544368604279212, 0.63997673585987691, -0.31438607297550553, 0.48257840084925885, 0.7781330923914227, 0.47092407197705477, -0.5311400902128911, -1.7123586895304941, -1.7527905284311114, -0.58853361949108185, 0.24024484917425867, 0.5900589641043561, -0.13225940112493095, -0.76361687868599315, -1.5939210943383406, -1.7773503214902886],
                             [-1.2349357707423725, 0.87768265422765412, -0.79347742917982889, 1.7025084653283611, -0.90598992605044848, 0.86519063531836093, -1.8680306420105923, -0.12613385513202791, 0.048573817222459292, 0.30591907706041943, 1.9745948967876499, 2.6087315187542952, -0.64780589237226427, 1.1209623331137286, -0.28643308991526623, -0.68147522960350237, 0.055880732533001666, 0.093884858344984917, -0.68393844852073049, -0.49693316883904637, 1.4055204613120853, 0.8135693099794139, 1.5309920300022788, -0.21203048873994168, 1.5006651582246433, 0.92080055700773378, 0.47300076193553087, 2.1054285713765406, 1.6038409550761603, 0.37216873621378899, -1.1624395989526286, 0.6857699752897557, -1.0008353206718834, -0.23086971747510876, 1.0775061591105299, -1.020394660804619, 0.4421367206153316, -0.49547571122558765, -0.94660877896745466, -0.88812426156979207, -0.77792440668454321, 1.3729623937374873, 0.50117254723116689, 0.22390704366106673, -0.4017377658042392, 0.4523591561027141, 0.96825444492088586, 1.4593967332265116, 2.0378596588276334, 1.0621553466172871],
                             [-0.97298897176434851, 0.048915873389262843, -0.73469143658967462, -0.61303002792740813, 0.15440100924678155, -0.098114614086104099, 0.049070532348689633, 0.047414685033180165, -1.0725799770504425, 1.1924985553026617, -1.4322121497930069, -1.7007979782485401, 0.57091278209332375, -1.7322885225593867, -0.5970698793170206, -0.65181021595652666, 0.68608593898551762, -0.73641634898554509, 0.5948047321157377, 0.4079226226432125, 0.69077539005396227, 1.4945666128434738, -1.4028694685102225, -0.65144855552457437, 0.49697060530039844, -0.1033959014928519, -1.4959799021525086, -1.0202065503902029, -0.064605237353994205, -0.12317825026967694, -1.4693225469259421, -0.64144885941355478, -1.2720233556027472, 0.86172332782420158, 0.57688165487374787, 0.43081808866349236, -0.34693711605999383, 0.25230051643402818, -0.12303502584426573, -0.08813979946040347, 0.10220633765559017, -0.58632289065300658, 0.2509383660018325, -1.5806111137701473, 0.60208562229855211, -0.82153761248813084, 1.6191314607716558, 1.0227763648277493, 1.4378735243775926, 0.21241825364582845],
                             [0.15578202211574435, 0.63112319215849466, -0.16568349014296369, 0.31090790094613363, -0.96303651817212765, 0.58777003960861562, -0.38918071107132324, 1.1298964190975198, 0.78213461857949762, 0.34198605962469908, 0.847735815934473, -0.22703887412685886, 0.022694593789544422, 0.46903356228113519, 0.62262499674383875, 0.25692519367571331, -1.6208440717310368, 0.25002409674302495, 1.2581924312132722, -1.1322094950580324, 1.1911347427740095, 0.69778609540954883, 1.3412975825467819, 0.61290175425468352, -1.42163527077883, 0.2706498224276539, -0.71859196444505868, 0.8692708545859773, 1.8248492198009232, -0.38118969865358854, 2.0263396733373757, -2.2806751088431403, -1.572392516469987, -0.38738085351740481, 0.91534948423342, 0.71957459511770483, -1.1574591923252091, -0.48716398064806005, -0.3376090419037816, -1.5409858633875466, -0.43244704475251577, -0.85178010919535141, -1.3012949472961604, 1.4585807232793311, 0.65183447444316678, 0.49778242125025141, -2.0693618298899503, 0.60643798634387558, 0.78446006528437906, 1.5304661678863776],
                             [-0.025351266676902552, 0.18698338848769691, -0.1447186455981504, 1.4439879089047749, 0.92479109814290172, -0.25103642921479252, -0.8861648437556735, 0.19441493609879651, -0.2133974655843901, -0.19901048612403943, -0.49504674629310597, -0.43701914597573732, 0.20191136476198551, -1.9277947033774914, -0.73467423993805558, -1.7897667659428849, -0.66285376056863643, -0.6963673595350548, -0.98646978413229436, 1.5419294850443048, -1.3437898261460302, -0.71574951724267, -0.41835927003780204, -1.2773154428960367, -1.451612906613108, -0.56826503672536033, -0.15971997194854592, -1.2816092384623428, 0.51602519809609859, -0.87219758057796992, -1.3158544522935536, 0.13047413890926471, -1.323161693043988, 2.639188753683368, 1.9422528845761842, -1.7396998275910136, 2.2566718266291423, 2.1272948676158259, 0.95768480354126395, -0.49870674289721989, -0.94924529775911937, -0.862042241005746, -0.48301413593891201, -0.21253976554889009, -2.5934563514786713, -0.31018821740168279, -2.3293547899975344, -0.93159411328975772, 0.071702782293861206, -2.2397227727627547],
                             [-0.57736838981954652, 1.6908120584586408, -1.179132522693858, 0.43186596198903232, -0.2721058459961111, 0.12308932297097108, -0.48728794264566655, -0.45995841030393048, -0.27867650826199281, 0.203670139186928, 0.53860943705710795, -0.24822043511908845, -0.84099280685105249, 1.7836593330515287, 0.33180993936418113, 0.78530698586938241, 0.30790385946185694, 0.075083486214171186, 0.58367903894531392, -0.678808671507519, -1.0072569109108649, 0.407355087016252, 0.8400400524377204, 1.783707208264488, -0.1208000763725961, 1.2929978500029187, 1.3461616086393784, 1.6908529665891181, 0.025781861297624276, 0.44531458903278481, 0.82032439482772301, 0.10371425447839464, -1.0249642621800235, 0.025173273176217092, -0.99263295635576698, 0.36464991547527925, -0.49354712426016656, -0.3565438378576915, 0.93403894149181466, 0.47393805690127944, 0.10570978149451632, 1.9887686033974044, -0.017861938390217005, 1.1665599649635183, -0.50348465481773941, 0.52816888383072924, -1.5658486431963721, 0.91673361624126359, -0.66736126022630571, 0.82038964417795834],
                             [1.7034492906118492, 0.68353593955198255, -0.63709855226307854, 0.77207493262563687, 0.5232207063286225, -1.1864631206675125, -0.55271244435430789, -0.52751566745035672, 1.5033188741987449, 2.8519301863810878, -0.54516856315954632, -1.1458839245647015, -1.6285285730313102, -0.1120803869933571, 0.84553202445338682, 2.977980431066328, -1.3033695873061881, -1.1588544712640343, 0.56029533028509237, 2.0388641611232301, 1.2710973529803884, 0.57673935854338654, 1.6066240861628929, -0.58862187922622522, 0.55617830477275643, 0.75307719517525418, -0.25688852166374931, -1.5656090338276052, 1.789526515330347, -2.7416125984656694, 2.9797178394459047, -1.3062534642003503, -1.5557992575300941, -1.6677929301487207, 2.5587817889536386, -1.6454009005989507, -1.2857555329224388, -0.54052977537677083, 0.73248607674836175, 0.11058550910483791, -0.22112834844212659, 0.96006608396651383, -1.1718856101125901, -0.69417655609344431, 2.4216086741489691, 0.84232460726082559, 0.58818578328161331, 1.4123743448531623, 0.3375449426396655, -0.51952957659133225],
                             [0.42127342140978397, 0.3013750963064461, -1.6015775455016292, -0.47715511707214464, 1.0283973761372505, -0.21391712460410986, -3.1471617890937913, -1.3254488712806001, -2.2178599585634795, 1.6933500999182898, -0.98432973563714221, -2.023214853607187, 0.13144689610254104, -0.15784505960971351, -2.3166194638861404, 0.76279137848298129, 0.31731506182084013, -0.76031884883744894, 0.53878975538604845, -0.71773325375913211, -1.6639989805118327, -0.34157834786607311, 0.84972819877491512, -0.71295492934808657, -1.0087363844579853, 1.5379230746381096, -1.4103494111671513, 0.014618444839472333, 1.5362058455594143, -0.82243220521155913, -2.2181331891355471, 1.0076720118087372, -0.78545890061935564, 1.3463984311177843, -1.3405703198326573, 0.047877363881370566, 0.44008199135568227, 0.81191041477965986, 0.57453476525445768, 0.97692635542386397, 1.2841372640602391, 1.60303386191719, 2.3838296134051196, 1.8139577168988796, -1.5840986998477917, 1.2479661595905016, -1.0164309897241894, 0.3395485916005288, -0.98825577402936782, -0.89329418076450828],
                             [1.1055624225035348, -1.2111395903537194, 0.18690543046576225, -0.50792248787381344, 1.7346570872918416, 0.53061223229913101, 1.4084007661768796, -1.6639817347808576, -0.1221458204115724, -0.76941371480702769, -1.8136950629412814, -2.4911850226971257, -1.3435539279002826, -1.6508844593093537, 0.92176129560659303, -1.0843560123144274, 0.11081477986360473, 0.46585927227458324, -0.4058932219540109, 0.89233824784130944, 0.8923484906819924, 0.044945260514146601, -1.8577270794531948, -1.7757234396979136, 0.94458744349821311, -0.089520954866816077, -0.093770459246815929, -1.0776732025397928, 0.0023334674205578443, 0.30385043378916304, -0.78986572712514236, 1.4689362606492407, -0.77091994723051949, -0.78161867394480933, -1.052549946685654, -0.66973582069593884, 1.8287432816325149, -1.8335723614214041, -0.91214119442729935, -1.2907001711060464, -1.0100993092819448, -0.86426924113937287, 2.5355867143458166, -1.3664977241462077, -0.92686305601236363, -0.75137798748299933, -0.93201233065548406, 1.4229754636622323, -0.44719296281453202, -0.59528067884215474],
                             [0.17554952750608402, 1.7928650125775323, -0.3518074033971893, 1.3580635924622717, 0.20699188287707446, 0.7894387982531974, -0.37204805646681899, 1.1234953640576109, -1.1236733958315193, 1.6383987922292931, 0.91641092253774747, 0.38428187648979667, -0.13410237977282566, -1.1428493913875073, -0.43223880778894586, 0.25076998639524628, -0.41603467385574627, -0.15603515053000366, 0.1341891445745923, -0.9660841166789691, -1.958983734698837, -0.90878884473450405, -1.6545786066858845, -0.66408959794522959, -0.62843873078192292, 0.56891358308358764, -1.654662547642181, 1.247196203385474, 0.061246733273261023, 0.009836856531159073, -2.8263033388518122, -0.37206104805825113, -0.68507258209114363, 1.1132977950034717, 0.71762965416168101, 0.23304325039023993, 0.2401655787793566, -0.2352082581685026, 1.1972390265179196, 0.66864265398510392, 0.65892849610089299, 0.11620514053160802, -0.24430088053147181, -1.9928319961423282, -0.062623155709800177, -1.8369003791551062, 0.9420172061280655, 1.2858820321671092, 0.62354579524379838, 0.98076844854374401],
                             [-0.65535452519370452, -2.7900984835406639, 0.34791724527632401, -2.2461506149088728, 2.1852029896745635, 0.28834451533223737, -1.3784627178267019, 0.50624863831082856, 0.30630108372624043, 2.903345801398149, -1.6194933711279929, -0.86018779146463031, 0.56167348826306107, -0.59255896625088467, -1.6172398291144703, -0.85164559539229789, 0.18115646354111581, -2.8957017617741516, -2.6637880784738175, 1.83892812350651, -0.18863020098827171, -0.58396956199210692, 0.40018374981912685, 0.98295185563287613, 0.84902428322174339, 0.88591542810615498, 2.529540640205858, 0.072540075323029946, 0.61467917264980698, 0.29637216755024615, 0.59622707692873056, 2.7770192259181732, 2.160308078258292, 1.0325277295241828, 0.91494249813852913, -1.1143300712909967, 0.3305691928949186, 0.26560597322926505, -0.31116364595491264, -0.87898294254146125, 0.65094370916519251, 0.042527927164605669, -1.389694668802596, 0.86100078232193122, -1.3163903655912634, -0.23329951837605217, 2.117889731748857, 1.6198830903954762, 0.34948756159175093, 0.0023832050104692082],
                             [-1.4322752857605334, -1.072986513027111, -0.33379010842374229, -1.2133171875057736, 1.1313290902559876, 0.34240934223181979, 1.9258225992213143, -0.072084261641577607, 0.21576258097353312, -0.49099766432184844, -0.21900428295375016, -1.3056396996625108, 0.54786131315482578, -1.1089314796551855, -0.47569152021830807, 0.58309785562669603, 0.065135569008912306, 0.0022169716232431635, 0.36982654194004755, 2.1686576350639126, -0.64198866455252035, 0.0099714619392661241, -2.2921232725286913, -0.59206809082943457, -0.63240519014465124, 0.25420563665329016, -1.4189643504564815, -0.36748528383918966, -1.4061935567407073, -1.0747126147725496, -1.5999604859537357, 0.17961397373053506, 0.35581604892702468, 0.59683192017030473, -0.58667707045833717, 0.39804627821891436, -0.74628909530460896, -1.0552033317351026, 0.60114303528710333, 1.6750446050166306, 0.61175201345642349, -1.1333507858056693, -0.25198748964467188, -3.161915653927172, 0.27992843823841923, 0.21329971313436824, -0.82353472811361583, -0.8345546433839568, -0.7982134956571646, -1.347973194486511]],
                            [[0.019102543139715308, -2.4889695885767851, -0.16195178760864501, -2.4646366741242653, -1.52021476098986, -1.5558599735159993, 0.72782961693389991, 1.3941389365072834, -3.1672658036916759, -3.3760348447536939, 0.71222744380205949, -0.39463081869122968, 0.032266346746461311, -0.58280633480293087, -0.047522483458925395, 0.54682280579079445, -0.13402358889291438, 1.1861336828507867, 3.4075654968788749, 4.1455356823033354, -3.4937696403507674, -1.5090765059400373, 2.8845181570382463, 0.066920219892572255, -1.9737080440476387, -1.3568306305152238, -2.1220642194029335, -0.95343200320354848, -0.39745200009416765, 0.66196042328712323, 0.22470228498088973, 0.13452953270088563, 1.2538820023073693, -0.71793964695687429, 1.4385102428372787, -0.13358649650803864, -1.9160389528431028, 0.78332980889243287, 4.1826677780391455, -0.83935678735355734, -2.2488528070241016, 0.35065742831416274, 2.8194197614622141, 0.18000325686862645, -4.0357410015594732, -1.1093761607243009, -0.62085695625151915, -1.240972815148883, -2.2259393303973307, 1.1903518039682111],
                             [0.51540021542447456, -1.0816116527968067, 0.64863267605451957, 0.36082177312485059, 0.9691115731640112, -0.93593822780412284, -3.9250992908189173, 2.1769070337757732, 0.66451300635047916, 1.2451061791540559, 1.767575310793295, -0.044658667978323505, -0.079949307275409234, -1.5245030360791527, 1.7839896019460304, -0.93163799536120728, -0.44278485365988052, -0.12500825051986991, 0.73552755230121047, 3.6907596190302017, -1.1552397014682807, -1.0536985584275749, 0.040807569559680706, -0.23448667552686461, 2.8914342196312792, -1.1687171181846305, -0.29644018842737641, -1.6902123049381792, 0.75603531325293671, 0.078864603210369491, 0.45352199638884677, 0.79692707878968383, -0.61652436344624018, -1.3988795846620794, 0.02121077173100765, 0.44724417324613475, -0.77074704226069179, -1.3486301309362589, 0.051207723714630976, -0.92900945069071572, -1.5053471134789396, 0.4072633452723472, -0.7777084312253858, 1.8765661372219806, -2.4716500536114245, 1.2150575568329256, -0.20748164697195953, 0.47210346925076002, 0.98556224250570956, -1.7362031016218451],
                             [2.2618374616620405, 0.19189962541767505, 0.6686189560550343, 2.2401470691804581, 2.6708238382535958, 1.1308913432685102, 1.1882907346840283, 0.32785282236208391, -1.315197127776639, 0.1579572536100638, 0.72150792464480207, 0.90875581628949476, 2.4776497452218078, -0.066005702858427731, 0.26581241922379539, -0.33461663018388554, 0.47402466564123236, -4.2812057910878973, -0.98150298663573965, 2.2570072358234139, -4.2606140814952891, 0.048307833573859912, 0.33316296943910872, 2.598823581337677, 0.26946525935096999, 1.5600916187507363, 0.73004115039752238, 0.53785862882523661, 0.67532216054465177, -2.064205949936158, 0.16320312022669137, -0.78183061551129718, 1.9289342249320736, -1.8550631338058488, -0.15301948835372434, -0.92966681508553861, -0.84813126282906681, 0.62931566169254261, -0.036750504943842022, 1.4040862809484087, 0.029055805812255486, -2.1885425835179939, -0.58150600811756348, 0.72234713143653118, -2.6874268103114849, -0.38674076696222215, -2.2854332763580834, -0.49343677532946678, -0.55100096043427738, 0.14828378929621777],
                             [-1.5332589377336538, 0.22101397427704447, -0.13158881361731109, 0.95405615866223703, -1.9245551982225835, 1.5506243018585462, 1.9442396947153355, -1.2400550120879579, 0.2485032270238629, -0.4081570078303588, -2.7128108251609895, -0.55678779279823287, 1.7799470337217689, -0.41987239776023466, -1.0818908490216945, 0.49907179059159723, -1.091270567946764, -1.3606091580697606, -1.0627974155422992, -3.0391831880679536, -1.5608705424470828, -0.22458153064746517, 0.96779222325481462, -0.45996240633215557, 2.2304566317633809, 0.67323262742662282, 1.0257141194697641, 0.20348987399968893, 0.64069535138349043, -1.0808550511848483, -1.2198464718073911, 0.35562517048631809, -0.76112163274856248, 1.0951010574040976, -0.32466566047385642, -0.077538959206308197, -0.64408666964250827, 1.202384236627642, -2.1885829962878027, -0.51083183050170533, 0.96637693307294625, 2.2201416272060142, -0.20929287185676684, 1.0741921074283172, 1.1748377988374794, 2.1656266758399134, -0.49707626284606643, 1.6970851691076168, 2.5890548319815534, -2.0430457937501401],
                             [-0.19459037939241564, -0.47032548868433927, 1.0340032846702425, 2.4351410492849248, 1.3965302732890086, 0.17816628172680521, 1.4878120205826069, -0.49950278543967136, -0.41896860614293457, 0.041341919762308679, -1.5746808806069401, 0.010001369322527077, -0.82251312702280766, -1.8014101152393873, -0.12594526871298559, -0.79057049961553993, 0.36887928516009444, -0.90244992662504375, -0.12734023043264753, -0.11467043340203381, -0.93696567488325899, 1.3442897613927347, -2.1276204059693158, -1.5840785812394775, 0.56914072668725013, 0.18256902292848826, -0.28762316619673517, 0.32531543180565492, 0.83654531024310763, -1.1249049943818008, 0.22777993416298736, -2.344248925688059, 2.0270220509983217, 1.1987780931297549, 2.4465619809489425, -1.3576497288675893, 0.78937533401534365, 0.9378276902833077, 0.88152704181414632, 1.0600707339224515, 0.93777319042666041, -0.57582500011558391, -1.269140771891089, 0.54302296512654658, -1.2831613180020274, -0.76570759762171126, -1.5231476422325942, -0.18468750025064501, -0.21137507344617554, -1.1227647778049734],
                             [-2.0972314539389152, -1.5471317621310159, -0.20397029927321794, -2.9456322854524868, -0.34828666588755358, -0.75054411116556674, 1.1170853541771979, 1.5997570047207317, -1.4279764453436365, 0.76614967307636372, 0.27943363291370843, -1.5192517955428808, -1.1256915799000611, 1.3891212592044002, -3.1195492230933235, 1.4770440710818213, -2.5317203230904752, -0.32194281043866246, 1.3556025389710984, -0.82856358123804408, -0.40284767972199537, -1.3306540767024158, 1.5789116545074753, -0.62013729864558165, 0.61816374367037363, -0.38700571010511753, 0.31864618246139015, -2.2900550011539957, -0.66645002603261017, 0.53935194338127934, 0.24107333943553033, -2.2229177832805056, -2.2223160879579691, 3.0547838894224557, 1.5116403601230002, 0.3029663983833335, 3.549220723962657, -2.6985438219687068, 2.3845194616278875, -2.4556673461984637, -0.25640272056675284, -0.27035560726703817, 1.7419277580531323, 0.70249737464757045, 0.81131972651845441, -0.89615519456329573, 2.7022004878688448, -2.1287909502913718, -1.8751367707951223, 0.8985554540447912],
                             [0.52934387892763168, 0.80450249473780466, -1.1098755574600208, -1.3270620238577682, -0.17375367680419551, 0.18769899029726622, -0.44575495382704822, 0.31854620860575245, -0.62817889338604316, 1.3773036062331607, 1.2663045290962411, 0.87032624965069594, -1.3878193197229989, 0.040736528718532256, -0.11825995335282517, 0.33599092779383055, -0.67392774226951424, -1.6031831462306561, -1.2086934077636988, -0.0056524819798084401, -0.62727824425223511, 1.1522123006603762, -1.680684343274647, -1.1242026118374966, 0.80574240819699838, -1.1258192823526898, -0.59508309126993342, 0.85533411113745728, 2.9878396525722715, -0.080797769785377366, -0.68368745728186875, 0.34035443429237483, -0.89903808485540193, -1.0859668994495675, 0.066270610271335573, -0.88236249619591123, -0.98140076037589818, 0.37569708632107535, -0.9827176843446519, -0.31256566761398025, -0.80358633340693775, -0.2921638832837305, 0.41171065544928215, -1.3427631634584978, -0.37848830931420746, 1.0836250834712855, -2.826700115910592, 1.3565278530042668, -1.151600149084397, -0.56873114811179049],
                             [1.849893479339596, 0.31479083744364106, -0.16858506509377752, 3.4425331405295676, -1.9997201561751894, 0.16910139388528417, 2.1912176765136424, -0.92386173687252648, 1.4202210927097723, -3.7380700944362988, -0.88600332400186677, -0.75281084891401451, 0.26823835437388543, 1.5250217623698161, -0.70775889890500288, 0.63683860388586555, 0.63229566340484855, 2.0359874349781748, 0.48544807784309951, -1.9794536675299115, -0.67093986740609202, -0.11105447861347681, 0.34344493599004028, -0.00111362760197109, -1.9396590299658942, -0.18384070653620799, 2.6211894812500685, 0.50137552157753251, -1.2886010627449254, -0.55873772017979284, 1.7754572170371887, -1.1428160639245326, 3.1199035790260643, 0.038505436549951318, -2.896789034995022, -0.72948109618587853, 0.51941104323571341, 0.71871226888942918, -1.1829928329680357, 1.2788062662740713, 1.0253802529878993, -0.95263105349324306, -0.85491628194699976, 0.091623475825999598, -0.25743082161798742, -1.9346113189225098, 1.9282187783799933, 0.40988545442010416, -1.441726567420976, 1.7601776753604073],
                             [0.0036811473912559088, 0.41115094229524962, 0.45019915165247287, -2.2447467130612857, -0.14061428325743944, 0.014902692025586608, -1.611651245060453, -0.26011539123822491, -1.4662396422383024, 2.3332717651406329, 1.677676364493444, 0.4464498962655945, -0.92692284485555776, 0.78631232950364238, -2.2458059979908778, 0.20279052224892463, 0.14387952222932579, -1.0102261001021282, -0.87803100934307132, 1.9132668559230213, -0.79632667163347781, -0.75909765536761575, 1.9380970905087309, 3.354327454901608, 0.34959159398198175, -2.9315521037242558, -1.9610031343991132, -1.7729511061042393, 0.37356325667364976, 0.62975613304805522, -0.28104311084228734, 2.4250581292220592, -0.57072707707491277, 0.079039387487632048, 0.26651470915747749, -0.48648577581561248, -4.1948491516362418, 0.25976388237335507, 0.79579809459146911, -0.87709718991973751, 0.10709162106986383, 0.022435661719316428, -0.35084162841427013, 0.47099414713637633, -0.54937237857245813, 0.31954447675357717, -0.035659287962132476, 1.0616912167727923, -0.77133372068132056, -1.2408869307336454],
                             [0.58910645057895317, 0.79497561834371089, -0.57131121897728687, -1.4387123179113404, 0.48593673574616664, 1.0448956394517344, 0.42005933323312122, 0.83886744643127231, -0.22294111034877179, 0.46151434469690494, 1.1806797282571742, 1.6220700324209327, 0.96254089349535432, -0.48205266169621719, -0.35696183280710492, -0.50384220502892274, -0.58402361864281971, -1.3805121952677315, -0.40268183812364433, 0.65232149603490264, -0.35804300606745543, -0.44962314511398949, -0.20049546320932934, -0.4319979745341061, 1.1736964434132182, -0.044092099329118631, 0.35814598025878736, 1.5027917516209146, -0.75181628833018799, -0.94386971353386406, 1.0390536554053413, 1.3954197921867191, -0.59719047507461354, -1.0216760957387867, 0.68472891586000262, 0.034487237876562632, -2.5468970684661203, 1.6937840507431203, -1.2337257576804377, -1.6924786276255412, -0.26490248255719751, 1.3651788727254544, -0.83267832490065363, -1.0356733607514761, 2.1230379947423028, 1.0857943787045068, -1.7461902293564326, 0.25984211819109465, 0.27054800165959275, -1.8082271099313825],
                             [1.5268513931172714, -2.5682885904871684, 0.44622525493301668, 1.5559814254677009, -1.811242046362886, -2.127111349523247, -2.3011511630463142, 0.56862626884236722, -0.28345321812301422, -0.7912417500790947, 2.0646081634954139, -2.4648948130018162, -1.0815263461371891, -0.4356616750956131, -0.22080439640882182, -3.2961712487692756, 1.7603397145300617, -1.5089544751051307, -0.9722683843775547, -0.63216764787500157, 1.0430316251381742, 1.950196295608063, 2.7543611749163306, -0.025927010125863126, -0.45950547838434519, -1.048048648954208, 1.6596763003631545, -0.42158991015536795, -3.8449510192665537, -0.49931053843669349, -1.8194236949592104, 1.1671682252578464, -2.8573399860663224, -1.92106520874498, -0.47193209395732139, 0.098503505630261265, -2.9069706021728745, 1.5749305466414079, 2.4975042507235345, -1.1504056709679371, 0.46288196339761328, -2.2018867112034188, -3.261432718294381, 0.85236353886321137, -0.7057830512256148, -2.2486412467315389, -0.13809330254636865, -3.2414863110589569, -0.52374750031754902, 1.1765901985046356],
                             [-0.67370092376606883, 2.3270158360201632, 1.3781081410667504, 2.5814696647301192, 3.1927059028728806, -0.17095891064456065, 1.0801132621135583, -3.1367761375624279, -1.9047699432975287, 2.3518551219792725, -1.4893584059504177, 0.054659979247509621, 1.2168858713079174, 1.3667399289793702, 1.2727862065654787, 3.8702537027333541, -0.51027628435861183, -3.4349917231077174, -1.6725673955708125, 0.9214032191064393, 2.2108174550290167, -2.6942336803173568, 0.015736222853221019, 0.23122737546892305, 1.1847216879402152, 0.81884365370276502, -0.95891144360025449, -2.2781424598867517, 2.1258872281647383, 2.2872191614921187, 2.3179619478369426, 0.91149467802787421, -0.031281825112014779, 0.037310112097351224, 2.1169011958649779, 1.4326301725634267, 2.9360580006233041, 0.7825879571540616, -1.3807406328890446, 2.9269602122217342, -0.38844589091962461, 3.4425389026167665, -1.6638255774478641, -0.20496452622035288, 3.1932045649907037, 1.93163308164756, -1.0738752685270487, 5.5698203509302244, 0.30069022142217072, -2.9727788641093023],
                             [-1.0405395159781901, 2.7579643170287587, -3.1006579325257655, -0.71231147678032802, 1.1840049291495029, 1.6424496781945184, -2.1563671168097689, 1.1341587036464538, -0.65043543562824702, -0.72801934849253813, 0.26198495852109527, 3.9827284786927346, 2.1477235299956408, -0.017019497460709646, 0.71428138482031533, 2.0145140223900984, -0.26809839598182339, 0.67266520555165188, -1.1591951051399287, 0.80965241864871129, 1.9725880537757545, 0.34521450375669299, -2.7857087480700926, 0.55634994746216004, 0.73483936970090658, 2.7393047823583183, 0.55320766231081731, 1.402238034852789, 3.3400931380403547, -0.17922397643796237, 1.1235727244309881, -1.6550100180036196, 1.1926693005584745, -0.20028414092132063, -2.6267426900597202, 0.38952166346968775, 1.7711101592254617, -1.1196686113020038, -1.0850677513741751, -0.33408976252188882, -0.82555377807688712, 1.2799470836210078, 1.4955712851867429, -1.1577556742984074, 2.400247033205809, 1.7409715375383756, -0.3300218085981142, 1.6717535255499552, 3.0750060911178747, -1.5384483583081792],
                             [-0.75276722806152352, -0.076918263180351859, -1.6242930506265345, 0.61499131517381678, -0.8735873823680016, 1.5764449490697767, -2.3775841621328815, -0.48903114650553992, 0.64229328330727964, 1.1899688378408024, 0.50274606365886187, 2.0722976285105168, -1.5243266540441081, -0.56779900830998498, 2.369959151178211, -1.3132438557713084, -0.63221467962933464, 1.4401804421519375, 1.2633295385867036, 0.21437669739181803, 2.4595649202069727, 2.8029226747624603, -2.2846306626279445, -1.1056133579093446, -0.29104696853494666, 1.6102554879470841, -1.6259954519177913, -1.3678304605930462, 0.83580816880527353, -0.79156477670818348, 1.9519998132489644, 0.029939339693726516, -0.32976374552444476, -0.11671528731509026, -2.0178752130147268, -0.63404557764267477, -0.91744772318439183, -0.33196045743645375, -1.0738105238993529, 0.071975768876122864, 0.12286412586907972, -0.35355284956570693, -0.60082809492547706, -2.2373475163317509, -0.67146411719907384, 1.3835275556332509, -3.4355793844782019, 0.64986409697608183, 3.2949708118901846, 0.49410011728194148],
                             [0.46931589425872067, -4.0058998914833923, -2.8940376466974276, -0.24683349719076228, 1.3862335975329292, 0.35996124158572573, 0.5219387298495759, 1.4230464667210285, 0.10188415747680714, -2.0401366915875068, 0.28392710531079984, 2.6623208298793988, 0.04326680998413826, 0.75132592664142395, -0.06418080547134998, 1.5405278022556139, 1.5071159485475722, 0.3947141103795393, 0.32910085289502261, 1.5552795970426372, 0.39281250115565336, -1.2225639276771254, 0.1334120915896162, -1.2028843367634039, 1.3784822757183739, -0.8630196395010552, -0.99049660292911346, -1.2434981873332507, 0.77241986899337389, -0.11013716908380455, -1.4927747572904926, -0.93268126026992604, 0.47370854777616511, -0.68505523812522939, -0.039858276982416924, 1.0041540082380147, 0.2815188524453589, -0.51428004796991422, -0.49630237537383626, -0.69916674461270445, -0.8909224503243135, -1.2824443157707091, 0.7080753857894595, -0.56360631475617518, -1.6103628474142493, -2.3588140328400096, -1.1580169924430752, -0.58274524674940564, 0.45731396446574496, 0.2023375072117447],
                             [-0.8872096679202317, 1.1353441659824481, -0.17568045337046898, -1.8684536516429537, -0.92532736663261739, -0.73188474642009904, 2.8321434653520723, -0.023892853187637848, -1.4165981728496508, 1.2648155481323939, 0.75554123783945348, -1.367685435725515, 0.52615034355626966, 0.62120386099827662, 0.029444215618922437, 3.8971748144921623, 0.27224341227714732, 1.1873814971286443, 2.9955758504764218, 0.93460385944098623, 0.41625090159727157, 0.35990388347175045, -0.53793743158124829, -1.5411434956004326, -1.2010377800379104, -2.3987791039945092, -0.12748420231777588, -0.53437302061104897, 0.54161440210981848, 2.9634020533315382, 0.0624343091141756, 2.7079572879009683, 0.12293530294453969, 2.0966083506550874, 1.6466474396117554, 1.2482746306555155, 3.4939878383645762, -1.6037482615198975, 2.9981303256653606, 0.68889814566814689, -4.1767260177937375, -0.66435333312596201, 2.2924089080415784, -2.4280268935412304, -2.0611632275117473, 0.91278789191600751, 1.0511883768902281, 0.0893499105538378, 0.13701846961148281, 1.801481079188159],
                             [1.6487834428570325, 1.3756909140582476, 0.0094584182489010644, 1.4091872886873533, 1.2139555240149791, 0.48027551673189639, 1.6890630677931535, -1.0852972475788529, 1.9771773077458641, 1.5799165451572186, 1.562303836379052, 0.81371152937186075, -1.541654061747088, -1.5562758325288784, -2.2199852451038886, 0.92573847060253578, -1.0517168787786004, 0.40293766607603054, 0.48728647930910685, 1.0838884799758599, 0.24849057964840937, 0.88102875830604732, -1.6640485144556521, -1.2449369009925957, 1.0431422850229655, -1.5463399312663806, 0.19541964797204139, 2.9868355034298015, 0.71348021062211986, -0.53818079273688657, 0.45166901909688478, 1.1893101580810406, -0.22564606987181207, 0.38260305663235716, 0.64778799491145789, -0.4215220408445764, 0.74862538671411805, 1.6394143596873358, -0.60600889236370659, 2.0034709167349742, 0.46624276585448571, 0.53252639430904292, -1.4082958321763426, 0.27166033807874257, 2.7977011083366263, -1.0854863983765581, 1.624049499481796, 0.93684779262899054, -0.94182155814304536, -0.27361900919725834],
                             [-2.0008095603163687, 0.13545850387244338, 1.8354053458372988, -2.1800720658679897, 0.16278022308616849, -0.8575133541844665, -1.5905909069612354, -0.43560119053938723, 1.0554778958755602, -1.6174312715266201, 0.95760929753666046, -1.159808857790646, 1.964103070322605, -1.2466464860892617, -1.2008038902350915, 0.58525803953007127, 2.938161656497114, -0.66032763140614104, 1.8531597080976969, 0.18740941414616316, -1.2312180817759582, 0.30256208932274398, -0.24584081618123851, 2.8204844658181876, -2.5123402096365668, 1.39780847444903, -1.7661983681151647, 2.6017264531012492, 0.46339885739757136, 0.70209353299145139, -1.8640437662191383, 1.3284784571415347, -1.0268183194137859, -2.38523478957684, -0.70032765881378378, 0.32441321411052776, -1.6443917195246742, 0.2352030692660991, 2.2154442600834874, -1.2765567112381004, 0.29420119090898988, 1.6981734111094375, 0.21672713259057969, -0.85333438105379655, 0.056691728822314429, -3.1199927573404906, -3.0938134491415235, -0.99475979651650881, 1.59142050810438, -2.5389531964999446],
                             [-1.4941509599613783, 1.016531806445895, 2.6921589443322107, 1.9822866199815574, -1.5382528095126717, -1.2297229438581736, 1.3819438395062458, -1.9950766141999794, -1.3313333289604912, -0.70678089605341565, -0.16701103230072945, -0.73931806241674602, -1.810196003616011, 1.1154956500740609, 0.05382251161210698, 0.99940268824296985, -2.1272185882261194, -2.1474963507223332, 1.3286013237538989, -0.81487487089752819, -0.81866561445496366, -0.54898697566350607, 3.9106135605000767, -0.06717596292007591, -1.285510404319183, 2.0366600959209431, 1.1321789895605177, -1.8179387912482501, -1.5290844816692379, -1.602454970232766, 0.41515700504070818, -1.7134886930505591, 0.66827037315910753, 2.2739465267823982, 0.0037869474627314427, 0.65427173429454744, 0.30956353988414681, -0.70282422493948449, 0.6574891447686575, 3.1054194969730506, 0.49169072845146672, 2.6397808827152622, 0.012881907412534126, 0.24019869062415436, 2.3505947333251518, 0.066304542146741113, 1.4043953120739512, 0.53341699399811215, -0.61103321423945933, 0.13244167309265525],
                             [-0.76180902880432455, 0.4910394304508004, 0.65464736215878061, -1.7335331191605634, 0.82793191698345847, -0.39389198502311495, -0.16422195692175168, -2.8881513930745486, -0.34948958312886913, 0.84668333612608582, -0.15462414235947808, -1.7991187823014045, -0.23160409067971943, 2.1789382949231886, -2.7088526569996874, 2.2193801204497028, 1.8813931496066258, -2.7747837103476787, -1.7803608609230017, -1.15734685765761, 2.5864287242017654, -0.58607764126336126, -0.13061069260881358, 0.49743143228516634, 4.1913567892529624, 0.35783714484162887, -2.0416903431294893, -0.032777385657204054, 1.4128978881011078, 2.2326026033289872, -3.3363839570494913, 1.3229027112416605, -1.7620546287070022, -1.4787977502864229, 1.5172318677311132, 3.3556387442068161, 2.7670543845881719, 2.6935695883868331, -0.91422494364189166, 0.052551495048024872, 0.37038520917368212, 0.51066282540366636, -0.3897457194155507, -0.93689756555530856, 0.371802410452439, -0.47256458686808717, -1.3825914332788825, 4.5139056988969397, 0.97183912159773966, -2.4343153800809438],
                             [2.2440729464543674, -0.4548830837224227, 2.1113295481526819, 2.2406435071315562, 0.54716253113324476, -2.6117265552723721, -2.4002317710643379, 0.36443377903260837, 1.0135443678404203, 0.32850322432529144, 2.1180759639482098, 0.078267245559403828, -0.23664259123184417, -1.4796485847410314, 1.9897998345894601, -1.9069798280933423, -0.91096143889324122, 2.6248783493903844, -0.76073227938414201, 0.70951415828307252, 0.95512642429817052, 1.4628968627177621, 2.7496198600200548, 2.7060910116321999, 1.9188374354250999, -1.4474694571429372, -0.97555545388174181, -1.3935085530097382, -2.036076493355846, 0.66973353722788787, 1.0178649900369467, 2.7601743009561339, -1.4034382068586921, -2.1119233505239441, -1.2262883662044133, 1.4158082523506716, 1.0351765665170536, 1.750260369828474, -1.0652190833512452, 1.5243847761033185, 0.19737283513585246, -0.50274344684984418, 1.7891783979859353, 0.74674132041816588, -0.6417243748576883, -0.47343111749480649, 2.5289644900123642, -0.49610911327553037, 0.61801076345728923, 0.52751480192911304],
                             [-0.31598801120992492, 0.5857165019681928, 0.83748050436802735, 2.7565668037921776, 1.147663928745277, 1.361139718211231, -1.7335399472370829, -1.5036548834437318, 0.86465208663944959, -1.1985511288738964, -1.9810891984802539, -0.41291991319192828, -0.40913092878463042, 2.3030708140312441, 0.75238205652261236, -0.88139016779184509, 0.23117365035176418, 0.1767081396611625, 1.6071866334136744, -0.68325703909541136, 0.15180673058758076, -1.1542857529281456, 0.19089886960592925, 0.43388021532537258, -2.4263884679959511, -1.5467701413141788, -0.06663961318531228, -0.42834788759241377, 1.0477010155783002, -0.62089813137856797, -1.402864450038755, -0.72735831612251911, 0.056418094655486861, -0.76010197772944732, -0.98589646938976372, -0.64902024809262782, -0.34072385841808583, -0.63468154919557007, -2.3493269884531189, -0.30979443061294942, 2.0279947576216673, 0.44260516505986519, 0.9086494755791158, -0.021384369562802936, -1.673741842514356, -0.99597378737995301, -0.54921412177149731, 0.70002927473255938, -1.8641800801754107, -0.92264191239316029],
                             [1.495140982533105, 0.70585709031066346, -0.054791655418339823, 0.1696720940920044, -1.7356002742776488, 0.079696901598485456, 1.0506213235707815, 1.6136818608923398, 1.3253527982423248, -0.74209401703305899, -0.21113790818465086, -0.11445363989777244, 3.4228164108489656, 0.35260546275810561, 0.46602533163159326, -0.9929133264879465, 2.0194143386320751, 4.297471244035294, -0.93503959364217581, 1.3078485762520538, -0.40731404674270366, -0.21181313535526941, -0.59177978893688699, 1.1133470616045749, 1.2035573024285606, 0.8737055580134383, -0.071158723348450914, 0.27311746908227408, -1.0303838223084338, 1.3904584489060403, -1.4293720616311347, 1.1786925327774045, 2.2473424526117989, 0.65330398852011795, -1.8491343485829272, -0.16611133141232362, 1.8601722684068609, 1.0347518067823183, 0.93637981004973658, 1.8259477406137703, 2.6735868963554594, 0.33894669579733683, 0.57652711542818647, 0.31150639456063789, -1.9004025118864578, -2.1502836986876295, 1.9723892916343742, 1.8350634565599315, 0.55624650424868771, -0.91851205899346],
                             [0.83240555804137029, -0.3126375817836361, -1.6856093852782283, -0.35368534776972621, 0.27711486092125553, -1.1672424607679122, 0.46553459750808845, 0.14755938000562657, 0.50710288494892497, -2.6374183606547081, -0.11957191276158115, 0.88140369511510674, 1.7005923609522731, -0.72744561969727006, 0.33304806786203051, -1.9515625509108829, 1.2115522804223509, 1.8408416616205827, 3.0295508493423089, 0.029930798838299449, -0.67082530977158727, 1.8774893754167483, -1.6803189016236646, -0.34812331230863236, -3.1254791026052868, 1.8109025638380805, 0.82687655631618306, 4.0459465431827644, -0.88349847017929439, -0.6944011263424501, 1.3895780097875283, -0.38824848185541194, 1.763767210122652, -0.28996804306906049, -0.49701581096344039, -0.050319632720030094, -0.73163247432158351, -0.21139857644179846, 0.81941527186543028, 0.063958499568476102, -0.99311750878151106, 0.96900984192450346, -0.97981605915460535, 0.14318093497491846, -0.18691964329315389, -1.9572961441011398, -0.29246323241820593, -0.40654166710183093, 0.45736315976327979, 0.21213242454381837],
                             [-0.83939727352646076, 0.17900780883759304, -0.97783156336672372, -1.0399838168411255, 0.98883254934953113, 1.1955641895159139, 0.017562742849106909, 0.32778474548157749, -0.14710424907753636, -1.1743761935358843, -1.1367824983984396, -1.618755466803399, 1.7552116216953924, 0.51055803614860706, -1.2468037902637827, 0.65435647636117, -1.3421752396000968, 1.6124953704793754, 1.5022232822610768, 0.59902817566383815, -0.88112156182117929, -0.55375703228572248, 0.99438870092140008, -0.071111650974512275, -2.3346732026092774, 0.28871379172625494, -2.213838349345747, 1.3773146235989657, -0.61242068230921309, 0.47441606493717725, -0.47516304035137752, -0.093788122199815513, 2.1071143506104635, 1.4305395564267349, -0.65059463058932365, -1.2997277416444732, -0.25478365936153768, -1.0244782666966961, 1.2314808233237511, -0.63313080498658436, 1.3550389026174512, 1.2640965516410709, 1.4047122510949535, -0.46438443166019133, -0.77036240312956916, 0.063354076087233868, -1.8126204405838799, 0.23694064153672656, -2.500438407750933, -0.15037589280331967],
                             [-0.4481738523187826, -1.020791038650662, -1.4305079046972959, 2.2393010821682644, 1.7137202167540333, -0.11180244297606085, 2.3262507135632773, 2.3920231167730308, -1.1158823587349669, -0.88905221854572258, -0.45325827115405837, -0.4478226810680932, 2.894099705193355, 0.074981894951414357, 2.0605304127523554, 1.2342145875209745, 0.51131407592542, -0.47896525784960736, -1.6354681582586865, 0.3242331867610842, -0.4245050335555281, -3.0479412691199492, 0.19464432956850999, 0.3788969495206736, 1.5672840080494723, -0.43382189089032858, 1.7307184169854812, -3.1014985460918099, 0.90229472777607844, 1.5204479592442672, 1.1002082423482906, -1.5062964507621135, 2.4591029901672905, -1.1938783182574839, 0.15064501311464332, -0.52912783886723835, 0.95321578927652928, 0.9341696432271257, -2.849928972398617, 0.47606759499423773, -1.6128114972043963, -0.35038221363906846, -0.063745795534214139, 0.9922495933114599, 0.25707327289698773, -0.087401358049742917, 0.41892872311922652, 0.38127904648808952, 1.9714339785192279, 1.1541349492604478],
                             [0.41859766547599686, -2.6564864272954005, 0.45658865740134008, -3.1808441172089528, -0.84059627604505516, -0.76619288450439504, -3.6019692636915184, 1.276678202971564, -0.29367995898848054, 1.2003414997528035, 1.0902319588327043, 3.0797835270050431, -0.36818099653098119, 1.7841716087106738, -0.47089040785599334, 1.4089761102697886, 1.0689841776338564, -1.6345429390286559, 0.8595262587604291, 2.9548540864545716, 0.22566536652351171, -2.3151761389156165, -1.0879336464759728, 0.67630717312655775, 1.0486742386355392, -0.81953459196321021, -1.8248061271052094, 0.52094400845320044, 1.25714432823511, -1.0079500757567303, -0.17055990167800028, -0.6530068476045332, -0.95873161117999595, -1.3707292454772859, 2.3062249078728287, 1.5150086924209707, 0.1057084740463622, -1.6012349934338548, -0.57269418707319775, 0.20768923045749316, -0.82759123600797457, -0.22499326294439889, -0.57499086555600321, -0.5364746968645453, 0.75660420048751509, 1.28590515435446, -0.62875500012212915, -0.037238873845806042, -0.97862328560794654, -0.67116373886211222],
                             [-1.624105820307699, 0.3439411572515495, -2.6094551856189692, 0.59300466497356596, 0.58474535989611454, 2.8654968908954825, 0.73882949960438205, -0.95280113510708198, -0.88476570929668996, -0.65389164921588017, -1.2088982591285695, -3.7401959853927833, 1.0271522328896903, 1.6247437013708148, -2.1576381436372829, 0.53324429394949691, 1.0455606399188901, -0.13835696560087762, -0.68548126193387993, -2.3336515981808987, -1.6198975425015438, 3.2878913757566961, -0.33566388687110726, 1.5000499434411145, 0.63526962850790403, 0.3575327262903617, 3.3090868141911125, -1.4819042751784013, 1.6806243920388619, 1.3713207956544426, 0.51217316808905611, 0.81928271769722616, 2.1618911334212902, 1.4866015055312074, 0.020122442129670806, -0.52489689410580342, -2.5187289881826014, 1.4315049414645864, -1.6660997200336585, 0.74073083021974095, -0.73265330792647287, 1.4559349206950671, 1.2433337305193792, -0.7853659908348396, 0.78296529692613581, 3.018933943187303, -2.2125995371566507, 2.5694662018000547, 2.0783517802958653, 1.3731154960812026],
                             [3.0015165929332857, -0.1538803844767285, 1.2618558836958993, -0.56669422286992444, -1.6078120203151707, -2.0423656749280505, -1.7727484173233004, -0.76448576579897176, -0.96283866532384765, 2.7836916553236954, 1.5036851819333743, 3.1839485497481452, 0.091564494777088237, 0.70668598277393291, 4.2986856691130564, -0.56503271073173611, 2.9117833646170364, -1.7104287735378998, -0.5168059387252949, 1.6060856066922957, 1.0208757380997926, 1.2189671568319098, -2.6278396913657125, 0.5363507683336074, 1.6868999004199665, 2.9242782605381876, 0.67341593448489845, 1.9746983236346474, -0.90077944914995134, -0.0068189304619106416, 1.4257927479852677, 0.022138891217066622, -0.77114831107114268, -1.9390634905043742, 0.2364524297545739, 0.96786152268992065, -2.4652002216074731, 1.2173937790291505, 0.50103812586712571, 2.353030253186736, 0.56534720405775574, -1.4243989072360255, -1.779229734734592, -1.2152045202490958, 0.086821228657079516, -0.81744184272414644, 1.7444974191792895, -1.6755541763560038, -0.55234074714121895, -1.867409496195741],
                             [-1.0359268804679009, 3.8608263734071238, 1.4991249165178944, 1.7378315267357669, 1.564038398618242, -0.42219169124195799, 3.5536737516099102, -1.626307535321464, -0.6227106734835145, 1.147614463417717, -0.81557393798671796, -3.0481895535224082, 1.0237957205496424, -1.8991078680371452, 1.0143491099007795, -1.9439601223184211, -1.5038562844801708, -0.24770336589184308, -1.6857510430343439, -1.3581932236341563, -0.6059709991351675, 1.3244732167864504, 0.95527808302466344, 1.7140933969888161, -1.1992612918735894, 1.2416167214362883, 0.6417168320858766, 2.6679582498137671, -2.3012684805993411, -0.43491461696807521, 0.25976143621493336, 0.20286954594774592, 1.6788416893222537, 1.5739427289192531, -0.81150917742241624, 0.79512234387821912, -0.67399213568817928, -0.8134955567445683, 0.506160904656205, 1.0699489389025629, 2.7859405781000479, 2.040245687283007, 1.0298580103897721, 0.69934298014170804, 0.98714065008758245, 0.7968377249526869, 0.79904032784063028, 1.1914142064726247, 1.1226790913348084, 0.34975618842239869],
                             [-0.59629040215517726, 0.50633767868041391, 2.9424846016786939, 0.45994709840836484, 1.4167238924682335, -0.19365262811949718, 1.9624810121912446, 1.0998458877998867, 0.51009331750132236, 1.2088376987096316, -2.8169994883186646, 0.25232531452398543, -1.3792916078589856, -0.33839365636736984, 1.2735497351180534, -1.2271587301304465, -0.59770358721920525, -1.1769653654929588, 0.028184355883639524, 0.27572289256039972, -1.0930953333082718, -0.95207546754653272, -0.89265189784166543, -0.4132079804240037, 1.7904393091281903, 3.4157821919785825, -1.0786977213226563, 1.11957796147486, -0.73952297524935218, -0.66162347104641916, 0.48120309920703314, 0.19730190047859486, -0.62346054835240505, 2.7059086977395288, 0.70511565600540604, -0.7401761944550741, 0.37245788451633371, -1.5516669410009787, 0.7894662223646195, -0.25892978066706396, 0.14334504477935106, 1.8606730790763697, -0.64129300132423528, 1.6164304770706825, -2.0631386558282743, -0.4762331214832719, 1.0568419534914844, 0.47067270616333096, 0.37485444727388445, -1.8861629864119267],
                             [-1.9186621832662094, 2.5235260574353022, 0.99733682116678302, 0.58282441552050868, 2.0933857895603474, -0.11808841725192815, 2.302852048887591, -2.3320531354870067, -1.0427037170488607, -0.84646826096262162, 0.55151021546284529, -0.56483580482698637, 1.2232781376318633, -0.29757510019793276, -3.1281727412287581, 1.8566382098148118, -3.4275444668083983, 1.5473408773738366, 1.2053412605580436, 1.2287188105512348, 0.34680311124395174, -1.1488379613206834, 2.4945149080515172, 0.52270329265769044, -0.69434669298060092, -3.0603513227386303, -1.308772867595867, -1.5667059326264787, 0.16587389245453765, 1.0755572846091526, 0.53164644997332122, 0.44092710762566589, -1.5034745488531938, 0.91546772020951006, 0.77678170651957168, 0.37738655850301922, 0.67164830354703908, 1.2385466328497239, -0.99934574496356865, -1.2898911921891874, -1.0989099823282884, 1.0766832819252015, 2.4818059544037547, -0.32972464431709109, 0.84612955404912804, 0.54827980505879093, 0.46822317875680042, -0.59926860015438532, -0.72564615264685572, 1.8675014296428596],
                             [0.25036474741170595, -0.58119902608914875, 2.9838195484995209, 1.8175178821222624, -2.3640158423124409, -0.33415313702967431, -0.082196532710274189, -0.37904634172989032, -2.1326007821037019, -4.0832739956323847, 1.3412325181499456, -3.3706771687483132, -0.19793780651868398, 2.4154009700039518, -3.8600229439197409, -0.90388301174429442, 1.4223599726339455, -0.32964506730944348, 0.90364555928335599, -1.5243096021886795, -2.7607645812745298, 1.5979474510796472, 2.0874214653913774, -0.3692343276207754, -2.3255607995743826, 1.0506488616793865, 1.1737013116517436, 1.6500952069100654, -2.0805831073259484, -1.3029585051633579, 0.50336330331198753, -0.72167228763190572, 1.7721438347832537, 1.2806793778250778, -0.35109628935939996, -0.48647231457568352, -0.40433761503986054, 0.53660454044583727, 2.5433336670870106, -1.8519621303672369, -0.79151997816457587, -2.5643799908788005, 3.8567447972975342, 0.37072508610727278, -2.2872101518078831, 0.17218348138917033, -1.3154650787771085, -3.2947095482813133, -1.932248508234528, 3.3910393976809186],
                             [2.551570548248582, -0.63455515071058788, 0.031703582682144446, -0.94555255514999925, -0.59598587243662304, 1.6695327374372047, -0.28823241954404288, 0.96327787830534928, 1.5711489574282518, -2.4509225664486585, 1.6822995648276362, -0.71781875117859617, 0.58061543481915434, -1.2686857874672866, -0.80226873748568373, -4.1366207895433496, -0.99318183914993718, 2.3312905574848641, 0.1152942243985171, -0.68947041460259118, -2.0894065769220185, 1.1778424253037503, 1.5290250401831498, 2.709341684518364, -2.5307105549559523, -1.6019376351916335, -0.52189380404772645, 2.2319977693354134, -2.2866045415491323, -0.084668148748786365, 0.64699636670156169, 0.68433250054265338, 0.67289229124485972, -1.3499295496202415, -3.1176986159707174, -1.5305008972281531, -2.179890170847794, -0.74008704622855603, 0.2418486423243173, -0.94101376550842541, 2.9414105664484045, -2.323086874775754, 1.2596357220742482, 1.825772237519897, -3.227450899061056, -0.69249268426690913, -0.43032690483282859, -2.6836300281390555, -2.9968641775739853, 2.3448636708844788],
                             [0.44484543049330438, 0.016819430881517806, -0.62020522278792201, -1.880584798832301, 1.3328676630886318, 1.6023538196761415, -0.048996060783090455, 0.8233819306515886, -0.48386786375520174, 2.1741024518798047, 1.2290993561330887, 1.7653571844322791, -1.135902558778737, -0.56583880326183511, 1.3716677229124974, 0.57306013526430566, 1.425340300311863, -0.62813208405522469, 0.52092219654774596, -0.45369562767992561, 0.083544395769186069, -2.1749219938334474, 0.054873564794467027, 3.3241221482847152, 0.072375868719644063, -1.7145825960051257, -0.25001097033448733, -1.9673393968889388, 0.66562660398273532, 0.54294292038852077, 0.37534775727773956, 0.52919960030700086, 0.79427565249756138, 1.0233635804147023, -0.47203177397300206, 2.1663487520165248, 1.4723462049814133, -0.69116019781901383, -1.7764404423605553, 1.8210618111031724, -1.1831063848909125, -1.2302340963482195, 1.437942937150686, -0.12915404864496949, -0.62915708764821721, 2.1909002596623854, 2.0045105593981534, 2.7916937299130651, 0.69716645157427892, -1.5920324055155779],
                             [1.1036058471613206, 0.39002719601860925, 1.7637690020912353, 2.0151104611093316, -0.44733443377546755, 0.66017581940834713, 1.1236345722726933, -0.58516124675409331, 1.5177317418602188, -0.085480391571578829, 1.1007148267348059, 2.1111512792638116, -0.35246475366901864, -1.5363273782984104, -1.1390676939051165, 1.8689099864956256, -0.92777677447502838, 0.34538496140595881, -0.52855072086420296, -0.016814847123802421, -1.0478280851486579, 1.5889301480176532, 0.88690839221723305, 0.20644336603250343, 1.5918702971975114, 1.0149158016742097, 0.78533780774764561, 1.7347292264387113, -0.24419574843092476, 0.73798789116159502, -0.70400875612128244, 0.22470201097747453, -0.029522667600896273, -0.50378853873916718, -1.2621301474905255, 0.66859416455504361, 2.5566700647636664, -0.56847453997765718, -0.64627472724737967, 1.5510260414638599, 1.8602338903845623, 0.17358617806600951, -0.96626963410871514, -0.38706898407732776, 1.1682785380239658, -2.2584817213083124, 1.9885781066427872, 0.45147417248675248, -1.7849329638547509, -0.92616512180450961],
                             [1.3501274766296141, 0.20543190648866122, 0.47699764611030648, -0.19014396121468355, -1.5910570428609985, 0.42302292434705491, 2.2003599763659603, -0.091150922702870452, 1.1979991455199555, 1.4988827632737038, 0.49345681464713936, -1.3626330851616049, -0.21763032385119371, -0.4925950468317179, 0.220298679102435, 0.097134183949921293, 1.6233465949484931, 0.20813287806390038, -2.070250710548478, -0.43773975383355007, -1.2388744101485691, -2.4546310093693466, 2.0312006454238589, 2.1529171021380002, 2.2079194163435822, -2.1248586088654466, 0.47933044441677425, -1.0658072683047528, -0.82990566680271172, 0.53943215137452094, -2.128021968879982, -0.40979982694216327, 0.32502666374601519, 1.1634981879683617, 1.1425273887625096, -0.018209776386093023, 0.68177211311906172, 1.422105338020778, 0.43579389967202459, 0.50262713126432412, 0.37747740987069761, -1.9244027942178585, 0.78799936075608079, 0.9870631179862952, -2.7827674423116564, -0.85121172114939903, 1.8622989773573848, -0.54642100300863961, -0.21745216804646961, 0.45286389284791845],
                             [1.5998043430908444, -0.13582406747942841, -0.78785535652934213, -1.1072204858097001, -1.02264209159405, 0.2088651664880021, -1.4899544441686225, -0.62984175550757826, -0.26159673690616397, 0.13238973858692649, 0.28363638404596508, 1.262683447246739, -1.0536266647177308, 0.50944009629745546, 1.7926139402038281, -0.70953364415280473, 1.158352723114173, 1.0475431260996098, 1.2307825976760634, 0.20587765158039562, 2.2505025956076317, 3.1982141214308859, 1.2627825796963614, -3.0640528267726093, -0.39874362955793746, 0.65179122264190414, 1.2160507550549591, 0.25874814839450244, -1.9117466885141625, -0.7573405898411204, -1.6521665683574371, -0.76706010380721545, -1.5120112290761467, 0.25600843663802242, 0.27815374096309098, -0.30293640316247183, -0.3621400229402495, 0.50706937766499727, 0.43165104492185136, -0.023790340710605158, -1.2666071041745322, -0.68188883928273702, -0.60937275539569336, -1.2473139490643403, 2.0439214210562597, 3.1387887041474376, 2.8118512619789331, -0.98654041243536672, 0.53784989855754095, -0.074492117020993981],
                             [-3.0760114132788847, 1.1748078751052096, -0.37243509207212733, -3.14567387542643, -2.0761151265376183, -2.953462011412245, -1.805875304947232, -0.9981279167527517, 0.58698239705429234, 0.34636616144847671, 1.1813097323838917, -2.8587263314946538, -0.14773632097802392, 1.1154672321425407, -0.78516493673952115, 0.63711126016876252, 0.97971183677145024, 1.2694176458174202, 1.0530768260585341, 0.42152580418903496, -0.14299425849878256, 1.3156654869067634, 1.7137468165802392, 1.3957307408308353, -0.38188095109990372, 0.29982656192132612, -1.9403503559106214, -0.49746564488628858, 0.038954762368763433, 0.46827404511191928, -1.8564667349362627, 1.7382843549239402, 1.0135576742343289, 1.1651537182008127, -0.40334939046686608, 0.498732771371655, -0.27176908141046019, -0.96372993031683019, 4.1961051300215502, -0.35997983430517594, 0.52168646678615338, 0.59203203698854245, 2.7994919890065986, -0.17505522139730423, -1.5722711209867237, 0.33436882952017238, 0.12386227241653307, 0.95901822772578682, 0.21648140819882661, 0.016593523896596067],
                             [0.50922583062568816, -0.79286915724717266, -1.7575138274669673, 0.99237586128621369, -1.2266491309590037, 0.40503391845875786, 0.77306581907559135, 1.0179686918742565, -0.60078457293387655, -0.056287398727295726, -1.0915915997833263, -3.3456518737904082, 1.372512972280131, 0.46254475274284773, 0.22984330894982594, -0.52745657608154051, 1.0301652148967493, -1.0971286249291901, 0.76295765157636131, 1.0435843218934961, -1.6778263508610698, 1.4865027541113309, 0.69059853049499675, -2.3287170851474635, 1.7579154714353584, 0.82598300585474105, 1.5984654721468532, -0.59945132082054287, -1.531728091931599, 0.41728489437830124, 0.091642044791366284, -0.37570510323025252, -0.12149467728629826, 1.0033339526017737, -0.024173838503303763, -0.96010501177773377, -1.252664716062462, 0.12207407306465676, 2.6438500996980934, -0.36554139996316165, -0.66279398639357312, 0.20723837439638593, 0.19860063780638043, 0.30279682444655592, -0.11427955350180174, 0.15185102814131068, -0.29632775540622475, -0.50752860188692228, 0.12683465927143561, 0.12420853677471412],
                             [-0.98264778498932082, 0.71995992012381449, -1.5174418760924813, -0.16142295271481161, 1.1103579149306351, -1.7892894553804943, 0.64711386500832246, 1.5523543100064263, -0.47219031743216117, 1.3483148732665666, 1.0003641117020865, -0.044025307168278252, 1.4195513727669611, -0.80803448548184276, 1.1765163450663434, 1.6478854516850463, -0.76963179051632491, 0.084270259753151763, 1.1806741230383713, 1.2069197888082424, -1.3442968901884806, 1.5479318475933161, 0.82627577256002394, 0.67803530307207716, 1.8142438717171872, -1.4710919345224049, 1.3293980614284657, -1.5048693424278712, 1.1995321002463628, 0.63786002906944728, 1.9401520070522431, 1.001562122365127, 1.9876811962370606, 0.76140177032908207, 0.15050449651271394, 1.1850201862159697, -1.9115268423266336, 1.3073696502768513, -0.84267981399080416, -0.22501994503591227, -1.5135707194338937, 1.8913761179937605, 0.71547119960490035, -0.096788606268032124, 0.55843039625867341, 0.74099893381905102, 0.65411781669272906, 0.65619721952651422, 1.7650066396913433, 0.82231671482665492],
                             [-0.86390455629517371, -0.80183872023159219, -1.6044630131128195, 0.18660687954003735, -2.9622431545712846, 0.75180629973483881, -2.6194590085861265, 1.568146918582122, 0.11727299402227205, -0.94690111653404374, -1.058899261437152, 0.12378479916525738, 0.41871479248945254, 0.83474709613745679, 0.25967737687126952, -0.76656409168521733, 3.2561921468161135, 2.3768822524346747, -0.22994022106020812, 0.24934543853099764, -1.5191869684677468, 0.79404841363546752, -0.60152289370057888, -1.460382851624044, 0.83223361637079396, -1.3084690051737191, 1.8785825654950352, -1.6502760004675698, -0.5790394856483001, -1.1342660502965651, -1.4427496364101411, -0.44052701018725754, 0.50549093293889924, 0.07435426749745952, -0.97575465959227892, -1.1085045461768184, 0.25384313651144536, 0.14283543159784112, 1.0702888789523262, 0.26565185671811631, -0.24582792867872075, -0.28798174047823499, 0.26259923767590654, -0.15004694671539354, -1.2674894250972069, -0.59850887460441982, 0.30169350969462394, -0.069375307030999769, 1.0960579174410876, -0.48191646456412435],
                             [-0.51566339559944963, -2.9012118710095827, -0.17932967930986254, -2.111522812345596, -0.014461811961932691, 0.29027800020914812, 0.72692721881548461, 1.2782348737370668, 4.5049058141380236, -3.4033389514851025, -0.5522809008807138, -1.3883727977637963, -0.59711920284053088, 1.7372455470214936, -2.7742796211370457, -1.2889563901996344, 0.86547132425706053, 2.2563958434689444, 1.6848765177130693, 0.65792333497477251, -2.7243651835900518, -0.066457482016022529, 1.5399972724043733, -0.50457697239317778, -2.2758088648058616, -0.65946659666726903, -2.6673041837959581, 2.2164828668071346, 0.77760888566495323, -1.0215943820669096, -3.5165073709622336, -1.9933910008390061, 1.945305446980474, 1.7548536534617554, -2.2893137564097104, -2.3983995866063452, 1.5032062972534368, -0.7716788138527495, 0.21525879387051639, -0.13617937323868212, 2.2413173152831818, -1.9103845583184189, 1.5218538357724019, -0.15106603583988945, -3.3216569948963746, -3.7913162787524444, 2.1985103805152706, -2.0219782878181638, -3.6237239825553917, 0.67154757341330096],
                             [2.1256574895453229, -0.12973780240812446, -0.31926083550249978, -0.6593509830943477, -1.8530865644252492, -0.64174000038098533, 2.5313872828862123, -1.8841747923597227, -0.54268356469980528, -2.3603831741051473, 3.4184804301511935, 1.1976133081197267, 0.36043039660346088, 0.85044371525951334, -1.2434163792840167, 1.3987525470512927, 0.53628362888399328, -0.250198401380682, 0.97539736322844273, -0.56047374523932714, -1.3621776372306009, 3.1403937796335053, 0.31520165917525172, -0.98150238458601957, 0.96747858605898451, -1.6331762774586061, 3.0781166209736717, 2.3593446454226537, 0.26050881117268238, 0.88628089302063129, -0.51313344030886798, 0.71856215655404598, -0.52112107379510642, 0.63909802814501282, -0.65104071629307825, 1.2851040295353873, 0.57207064192524182, 0.9220600034605303, 1.3781625101417265, 0.42391251960330956, -3.5769812469640518, -4.146757209312212, -1.7863033997211539, 0.44292001692073807, -0.34427457563238606, -0.56943195350231479, 1.2480073299687056, -0.28389785349772667, -1.0770430880097941, 0.74217209768098003],
                             [-0.58663188825993717, 1.4442936237643238, 0.89715034343297184, -0.14671594133164242, 1.3033673945362683, 0.017782219304406276, 0.4011509655380649, -1.2679906149320153, -2.5291409471389392, 1.502876339197698, -1.0642388184982192, 0.18932697785131131, -1.7919778411689358, -0.95461253421316483, -0.15518655881484195, 0.013247558900074386, 0.65789558368941747, -1.5815627077042289, 0.94297339446926043, 0.59134396736761363, 0.13688041541906745, 0.58252445469174963, -0.52335581678323617, 1.3690022085706832, -1.1442607094351644, 0.91380396895774219, 0.17773392025968909, 1.6237396137692608, -0.29154456700885856, 0.39912670615739743, 0.095318360592791751, -0.40995185382900434, 2.13576282823459, 2.5318716981939695, 1.6446943590330918, 1.1575093346939964, 1.088779790669465, -0.51918129223457665, 0.24349891279122424, 1.4913611529204571, -0.092586763120457938, 0.19081215161867093, 1.0419248354789374, -2.5729267296934184, -1.1506317514903168, 0.83583031911315875, -2.615888317327058, 0.80693773919006528, 0.92104727474163628, 0.60207953736675202],
                             [-0.32886293664517741, -0.58727300234572166, 0.79985696797479189, -2.5333636514532949, -3.3562987001067635, 0.25567551818553985, -0.71197686581446273, 0.13485332491665603, -0.042484432562044407, -1.2982002284057406, 1.8804309310076304, -0.85428062772663282, -0.55290881876049258, -0.1964780324089849, -3.9906820314992593, 0.28618490390112178, -1.078489850576746, 2.8730163039789915, 1.9883928626718936, 0.9423031351016401, -0.83468396461246741, 1.2340908550523875, 3.900589705632727, -1.4725042850489058, -3.5310800232430593, -1.7126195511631552, -1.0902914681114739, -0.10577451181411343, -0.72849349522356988, -0.29753831148597326, -2.6166907155247241, 0.48225713256855396, -2.9828606037505128, 0.24463335334386704, 0.21852621478445747, -0.96021091268069347, -0.16861688533802535, 0.44179093905663902, 2.8047214506510114, 1.4802851353667532, 0.61560016046984334, -1.8893270148133716, 0.12061763681428228, -1.1618093799537381, -1.4876876708306603, -1.2784939646572142, 1.4708960766817836, -2.3086741241725841, -2.5328570548046461, 0.9961187831813394],
                             [1.8582088059211284, 0.68982173514054734, -0.828310246352991, -0.70794046819352541, -1.0155742114808273, 1.51721083598391, 0.92747305576697225, -0.31070191120532553, 0.59970395931443254, 0.2737458167884792, -0.39194193440764019, 1.2857635110635588, 0.030384307175304326, -0.59544027971202584, 1.3356619316264167, -0.54872295220726075, 1.9195477979614803, -1.1364059811424896, -0.061556011606281179, 1.2473234759486038, 0.41921024464666118, -1.9334408151949865, -3.2624812860338732, 3.3515455314794513, -1.2602244800668212, -0.29171589423859468, 0.30052644711282039, -0.003443816777126925, 0.20370324703893572, 0.62999592411577621, -1.2748036846476425, 0.33103691231838517, -0.30735023708335329, -0.37300905277118679, 1.2148927162062211, 0.97890132841947786, 0.15966309956306299, -0.66381792777072646, -1.9155852128485635, 1.0108408890581755, 2.0246365151182673, -1.3246667658851976, -2.1445054758164712, 0.89834766212435901, -0.93189152229066363, -1.3617774568318672, 0.15316833537360963, -0.43714310884193786, 0.51898440854624284, -0.29373210853266812],
                             [0.25388058636002597, 1.1586252111047122, -0.8481261328230596, -3.345890661570345, -1.1578868436679524, 3.0261318655161444, -0.090238303095605238, -1.2391745916038701, -1.2878406117462464, 1.9238419601454269, 1.0574590227404006, 1.0299046733682944, 0.014717814157488086, -1.5826473708159901, -0.69934737442650252, 0.18876555695919758, 0.69722251317732131, -0.74255310028348498, 1.7173973057913203, 2.1183558211342133, -0.71670781437700914, 0.45537639632277094, -2.7165274906532151, 3.0793864587240161, 0.046038496471738501, -0.3663780726158794, 0.38312967157150624, 0.92255927509312352, -0.12654305856070991, -1.4004045941328482, 1.9152230100720169, 1.3517963621799336, 1.8760369269056887, 2.3588804765088685, -0.6562818401491699, -0.44582936606783941, -1.0347599933754386, -1.933470148671214, 1.6556771679091551, 0.52291468512053774, 0.20793253031653089, -0.90345680663240002, -0.072170583843186448, 0.34336120591210917, 1.0442908781032587, 1.7459575883766811, -0.090508211599898747, 0.7417368566826259, -0.68262902800242609, -0.62244152376017414],
                             [-0.69599130800016251, 1.4130582985792104, 1.1692096947054396, -0.68357198277798681, -2.6255474949552191, 1.2214614163798136, 1.6742759953215975, -2.2207508354057026, -1.8941817367343414, 2.0739573635691495, -0.276841337739334, -2.2639581183584605, -1.2386633068525696, 1.3400409052590607, -0.94782036522325452, 1.1948574981735132, 3.117466999760846, -0.24987409797358828, -0.36832012021460292, -1.7249363983746087, 0.51667566030976941, 0.61893013626597615, 0.021148211265134616, 2.3312068361561731, 1.7235478615498234, -0.56799910778938056, 0.78025806324457925, -1.5409267766320163, 0.32296678131037598, 0.96864968676153584, -1.1209628158012661, 0.11118546674676007, 1.6652863700280063, 2.3405409627900955, -0.40210721624344775, 2.3149711641984987, 4.230408244613761, -1.2699499214264287, 1.8239140738334869, 1.1010685215086624, 0.57278629407027271, -2.3260407185178034, -0.16534239699868503, -0.45193504401674878, -1.7913763958190656, 1.5514858882007634, 0.30353557927096547, 1.7855972094185413, 0.64931529317554804, -0.50889747606201741],
                             [0.43741842053937274, -1.5294399076563814, 0.073463059366747602, 0.53773142105219374, 0.39544063202238122, -0.95775975190721718, -0.7155045891732229, 1.5469749263123411, 2.7190808540211964, -0.32829934242877201, 0.0091741688940643901, 1.0414227602063022, -0.23343285512805645, 0.77171035218229411, -0.83968394020298764, 1.6952120574893923, -0.71796623201265375, -1.4993089040394583, -0.9608961678499004, 0.1370747064404261, -1.549679275787021, 2.2081316170688057, -0.70418174538419465, -2.3969108168849673, -1.6895967169647712, 1.9299027084680362, 0.38434273283690912, 2.7092229407093904, 0.61682642994938452, -0.48230941012268375, -1.1458084571502505, 1.2282818766364152, -0.53964011099665299, -2.5356551105432099, -0.76409696982386033, -0.51393081776658533, -0.40756272354525824, 0.38840666937332274, -0.25117292098951521, 1.2618188461755668, -1.5958293641977717, -1.3332214040863843, 1.8817522369761417, 0.46341628533860435, -0.53307551356121918, -1.6704825877524505, -1.063008334661776, -1.6697593779026438, -1.7182622280257058, 0.40876325578132167]],
                            [[-7.4691277534539697, 7.770483975338152, 3.4142028249778571, -3.6346608916846717, -18.581920945343779, -7.1554649763209968, 8.8821281953227302, -4.948806305119926, -0.21856447275877613, -2.3235042902525489, -3.1385757168109296, 2.2298262061312588, -13.466411289777502, -2.3273229001087916, -12.855292830976515, 7.040576811840122, 8.2436309419306077, -8.8013879684892071, -13.380039948934144, 6.6038894129386216, -2.1938918108769312, -0.43082367076503769, 3.6617147518014264, 10.547979067334664, 8.1445835208553756, 2.0517945826248516, 3.6516916594476116, 1.7234775482093161, -1.2815715547517981, 12.657449845865402, -4.7548397135323697, -15.338109586522792, 0.81049471194823308, -13.358845818066158, 3.2056197737979981, -5.953960270236891, -0.93567258547891408, -17.685862799045676, -0.86406084634628533, 2.9746574995820194, -3.0958824307148096, 0.59950098535307417, 3.2320781549898214, -4.7435231949160439, 10.147087284645281, 3.693305049764128, -3.1874622273007613, -18.205485207327243, -3.6779698231835227, 8.841421566307627],
                             [-1.2487798007934932, -6.144667511104152, 2.4095121804237554, -19.314589679469801, -5.7631437110296071, 11.153378500545012, -7.0609041809437496, -14.788110135614465, 1.588649253658005, 8.6310972763574973, 12.764310149598389, 1.2377344267495807, 1.1864760424139602, -1.1943382212263947, 4.2098316794905211, 3.708361798682092, 16.263062266823091, 12.713346485448179, 19.136865329278546, -4.4485180550846151, -10.415631807271321, -2.5825782448643366, -10.236082594170874, -7.1539922976639927, -12.540978434470469, 8.0482013121229787, 1.6671637861147375, 3.9684800365114263, 8.2007826780166901, -0.58024430051475484, 8.1140570940372836, 11.215067718363915, -20.771962772841214, 28.520293937715145, -0.61373168840799086, 5.935728141158565, 2.4591139414107572, -12.931398630492184, -4.2690495299298368, -2.36093691330217, 0.52081839510214778, -3.2449245319262654, 11.535946180159732, 10.7384644059418, -14.515466888693593, -7.3564562262200415, -2.1515384257633334, 15.236099721049088, 13.487886332582578, -26.668561993849828],
                             [0.88621867517684338, -0.70513805546612685, -2.7767944250565662, -4.9397931711047622, 1.2056034078517788, -7.6829939480517808, -17.187259440122869, -1.5181560530879545, -5.9894248688677223, -9.9833417989393354, 7.4386439799506023, -5.5135129308493287, -2.5561019888244414, -14.615517855834284, -7.3622912163770833, 1.4962102655538088, 16.620150023670956, 3.945802480844689, -5.182390337767381, 6.0338179731769337, 0.49682743861406486, -0.34569967256583906, 1.6999878399080777, 12.037408261003389, 7.9116939119202492, -6.3461054202055251, -8.340230794206084, -8.1134635756267404, 6.1075148427407733, 16.100678439457536, 13.156939118289893, -4.4998048053685338, -13.578306455952715, 13.294298100642063, 13.497084605255489, 12.573255039980523, 11.739385841760622, 1.3614651902449304, 4.3486074604464156, -7.4193440564704662, 0.72834438325379747, -1.1490642987307864, -3.6493292795800016, 7.9242049144848377, 3.7850809716253395, -10.086778379564869, -6.9594185226876686, -0.92367110199915881, 19.953600297861442, 9.3483391742372461],
                             [-10.515851202999668, 0.61773568102351017, -4.1524724701763489, 5.5197533014490938, 6.1379542112626915, -2.0325337876245055, 8.4096664307167686, -9.2427686887950937, 7.6484958038017128, -3.1236966171006113, 5.7025597929036156, -4.2983063928685707, 2.1336180642085134, 6.0017003208923114, 9.4093012465109496, 12.328861669415518, 0.44001381270877704, 8.2918264942577071, 8.7653903956255448, 7.3837323425782877, -4.012863739549422, -1.0748712146591526, 0.43001660916908768, 1.1927099398752723, -7.3638497438916737, -1.6851392925042874, -7.2814353442422437, -4.7317110210787279, 7.4422213286604899, 3.3566667419543084, 3.6344801139733969, 10.607710148325644, -3.2839515750236559, -5.8289415826992297, 5.3226727920955454, -0.91965573887640539, 3.6474705386164192, -4.7511401692728308, -3.4893202761037285, 4.1450098789908054, 11.265972944670908, -9.6764605189528616, 4.030108035461744, 14.449408351211117, -0.25894122430418826, 4.5649822859000118, 0.52470399494515207, 9.8081419718163954, 0.55308348150365194, 10.754840594582019],
                             [-0.89567330856000682, 7.7367535990971241, 16.170189388903175, -2.0916109195933035, 2.5601931030653979, -2.7580096986330158, 3.7354889953679971, 16.15267213336001, 3.2594185324873721, 9.2213789694903472, -24.427815613622119, -4.403963129148659, -16.799914745068953, -6.3782458452857513, -3.6129762512553794, 16.52318025755498, -5.1532708565149363, -6.2948316469496817, -3.2900829394652069, 13.66541866847901, 2.7114002904886272, 19.206095744455773, -0.49524961220718211, -19.344584891166427, 7.5574964025208597, -1.1172812314401421, -11.461940229813957, 6.9764770420155431, 0.75457676004625029, -10.342501916984283, -9.7730520224076578, -12.370444964400082, -1.0015034945546502, -3.4669974677060873, 3.18373114318441, -2.6855422561564195, -5.1373702996001693, 0.23640154169726424, -4.0464097044272558, 4.5929009868362396, 5.9758141024481688, 2.7461632070567457, 4.2309696624743154, -2.0226772950983367, 6.5558507430644841, 8.2032959500526328, -3.8434375396649201, -17.863739430921932, -8.4232166338450103, 7.1286231305102294],
                             [-10.806748125926013, -3.7318434608526627, 4.253568243641241, 8.6736401461488324, 5.5585642882023816, -12.51456607275891, -8.4844016739593577, -9.3635540427370021, -6.5213229348007333, 0.023978175123910539, 8.4313580001969939, -1.6659697618050648, 7.0784494434361687, 0.78199397188639264, 0.17097588864775526, -4.8382741281837234, 3.2137512456073729, 9.3032448400298904, 18.48888237012466, 7.7771315593072838, -7.9356192004629937, -7.4478821769402375, 5.7549916521094184, 6.9724058799582176, -1.2593086932222768, -4.9660486324030577, -3.5034074189091924, 5.8244666445110589, 11.962630001286474, -3.892161910261779, -4.4712594921820195, 18.366866514575438, -17.656330606290943, 14.858668885705875, 4.9653492676261131, 8.8979164339707637, 23.391613432361879, 19.400231555136692, -4.102392863178963, 1.6111360809490056, 2.41275310233583, 6.9416983421901985, -1.3149097469660491, 12.152227969563091, -3.869479429337749, -14.705136772523371, 20.175059667716514, -0.59424869098763278, 17.196412649580786, -12.732090462502253],
                             [-2.3777775014592111, 10.499814476163984, 2.1361550876364603, 4.2688887136413785, -9.8234424600986152, 0.46977411235015265, 4.7554311467474699, -3.6832225563917613, -3.8242550474956425, 5.3195874719185108, -17.712260179965003, 16.776262545739854, -7.467170004534152, 4.9796550266035799, 5.7499089990741323, -10.257591364037332, -6.9601987265702707, -10.790272881010349, -7.9052976581101237, -9.8997736177950522, 4.1005997295872341, 2.1253095785248153, -9.2832390900195154, -7.5509356940207093, -14.735291686138323, -4.6998851820569012, 1.0703650823114026, 16.482795964610961, -6.6176924034447442, -5.4693263347616341, -14.427705473634308, 0.30181344262784682, 8.8073301385908742, -13.765368526123375, 1.6829977159099085, -3.3304496628710512, -3.8018266128625671, -8.6630363753494155, 1.9642835970492836, -3.5555731313175727, -14.811857363370953, 4.0432242384776833, 15.321027761359954, -10.648827348629892, -21.063324262017687, 1.7991966779578568, 0.5796549693215538, 9.6139171533650511, -2.0142196075425947, -6.6589108144274025],
                             [-5.7267275666057893, -2.3759420008774002, -5.2850700207327668, 10.380972382359474, 5.0253369357775304, -3.920413663138806, -13.13578953538094, -6.1990516508383608, -3.5491470056715118, -2.7379442775441611, 8.861535294529082, -3.6336670596700222, 11.525288172366773, 9.7898553487923898, 9.5299737696415079, -5.5474526725287676, 3.261738762393172, -6.1478795971781723, -17.976956926832646, -4.6313638249591058, 8.3791460985705157, -3.6835327465533925, 11.460088527515785, 18.376029392726203, 10.495526420894333, -5.1983988557883123, -1.6214184142746604, -12.139792355667257, -4.423194813731973, 21.448971134897857, 7.4809433563819585, -0.57187577232842357, 7.0122703302453431, -4.2190712722090629, 2.6447617965194699, 2.260404719026738, 13.186481873212877, 6.0374258819494795, -6.0555263986788725, -11.718809638397417, 3.8263300302565999, -14.391369130891228, -2.3136168231935161, 2.1949598781427362, 12.986316893750971, -6.3499993529749119, -3.9576523095096841, -9.1379083299019577, -4.5470470776656429, 24.685073009214801],
                             [-2.6623761430622537, 4.341804780789972, -3.75934856194643, 8.1204274983948519, 0.53440021504923974, -7.136079003168688, 6.5412799133655826, 11.699469806587107, 0.22881633240463956, 0.37968142810180738, -2.2183963089112826, -6.4705855782199722, -9.8260571754935526, -9.6050980010275495, -6.3471511925878739, -5.0093856390769291, 2.2951618362646649, -0.30946382060277788, 5.9758121075606176, -7.7020333537630554, 10.064890336765872, 8.2749074830946565, 0.41306567960965834, -8.7463529216544362, -0.69057892831826528, -5.4476012424423317, -6.2393890999768846, -2.6928425436413215, -5.2101765367876682, -7.5819763692021098, 4.2101640329049239, 1.2318672851335948, -1.1104850819916126, 1.1535674733374488, -2.346824559712017, 0.12359470008784879, -3.5051086777043281, 3.6522190264793775, 8.7757688341934283, 2.0891643761346943, -1.1316443041313919, 11.365650371487378, -3.056830660773378, 0.8948770818419759, 1.826699099582183, -5.0894416981793809, 4.11169064801358, -2.9144394599583019, 11.732620830795216, 1.9288144944217143],
                             [9.9923534286894711, 11.18467626865041, -1.1909875165634396, 3.0339743933412135, 1.9957189943635893, 18.072682223400317, 2.1631577090336926, 8.1302957094060933, -1.0460733925603125, 6.2093363488856212, -11.934790772257266, 3.4875747803102461, 5.6141471712642401, 2.0358391201033958, 6.6171067071147238, 7.6422869641143922, -18.078447666693588, 7.1735302827337817, 0.13950525412817461, -1.1577461013521479, -2.7977897491157857, 15.399885840032017, -1.9649245000761115, -23.642400999209212, -7.110995914594529, 5.6258373735737361, -0.94663967450371767, 7.613852205363326, 4.689316229296848, -9.5654236334687788, -10.744987897586226, 4.1123085212900294, 4.0937807398539281, -13.905463694552555, 6.1580897376347625, -17.714260866693103, -15.659499321314858, -4.2192190444731423, 4.4145344043907997, 1.8494941364377757, 13.199638402074168, 8.427160242679415, -12.603278319034251, 11.217343578198337, 3.569760736090926, 9.839527717465927, 12.628075763054165, 8.9831909854285072, -5.5477584322550504, -6.1219201772492315],
                             [-3.6139442881216111, -0.2869709442535589, 8.2629735208974449, -0.19017252187486647, -1.2893718251752948, -1.5019666019969966, 3.5270803777120654, -1.5112387767038618, 4.6843466405942058, -2.3914937527928979, -10.925277057984227, 7.39123959599549, -3.1991729591085645, 4.775211409829109, -7.858771573590575, 3.3430712499676454, 12.125738358747283, -3.4819554172584684, -1.514266753490439, 10.759840098962021, -14.14530910038847, -5.3576813907554293, -9.8869519303295856, 4.8979266080416481, 8.6343655390369385, 7.1548381938761549, -11.035455242398493, -1.373389446214704, 0.34670945243665813, -6.4683272008036683, -4.6666431029772424, -6.1513223327090927, -3.3908528497514707, -4.1753610236790317, 5.8601356997207894, 7.9541481297076713, -4.576178743093898, -9.3902969213878773, -6.7419001662093869, 1.0141289328189467, -5.3562093631163323, 0.59570077115638398, 5.0234838137386362, 6.5872738352347397, -5.3316821551094637, -6.4214252387698156, -11.878881936472075, 0.59790784326340951, 0.39418960631080785, 25.701068498714289],
                             [-0.1928355906641821, 6.5159791503054079, -8.2827084140595453, 10.528506876031612, 7.6126250685500301, -17.098595386480167, 5.6964297433112145, -4.9786013440381707, -5.4861727959302007, -16.383849039587542, 1.1002470331237109, 9.3595395617705002, -8.1803490239402024, -3.1977755686626201, -0.42906100659287283, -8.4458273914458708, -14.040236061177509, -10.812248769117726, -8.4302008815842111, -6.0749840836771423, 5.4267179798305989, -7.409239049120643, 13.652195892619249, 19.453606612952193, 9.2589642730954296, -10.075149343431118, -5.6326212773773081, -10.008914493219372, -7.7360959243716643, 10.985852148325939, -3.8742786988740017, -6.9589327212421388, 19.701183899567145, -20.534684541227101, 3.6189778201600857, 7.1634025898618976, 4.6478014412351349, 14.087547406931533, -2.153073130519874, -0.75089672799312446, -18.672060750980066, -9.4639677511480436, -2.6269890203109179, -18.661471277754444, -1.8077453156168173, 7.1041159566472825, 8.7728778376169476, -3.7551655040439655, -9.3629145582340971, 27.341024723229033],
                             [-4.0641971966768926, 15.391694186254979, 9.1499622079921927, -3.1471987000411215, -14.613166015071263, -1.0359612477882534, 4.0938656798712483, -17.819665012536856, 9.8028970453318731, -2.1483033295014389, -13.673312116607418, 10.598631250183443, -5.6688506042662343, -1.9523889082153454, 5.4054962816577463, 8.3172976541001908, 17.817875704527012, 0.88116113098402904, -10.700352792812501, 0.045023963445069093, 5.8154584980641886, 1.7916950347904619, -7.9587774165064555, 12.123417745159273, 4.5965543096242296, 4.9288057556004183, -2.8122899212730865, -1.2682203781278032, -6.52261216810947, 10.798159648568374, 3.5813731143734913, -17.039416502063556, 2.301933631463009, -14.618149395318632, -0.27256369503901734, -5.2988001866137431, -1.7182351825795301, -17.46736540379932, -21.553153334036139, -9.4427322938493568, -0.80082519302751853, -16.204502546487749, 18.604511184742016, 0.58941467894707689, -9.8231743914109391, 19.726583735043789, -5.9136901160580218, -7.9014928563759925, 1.6974433587216762, 21.772907677688114],
                             [2.3763356768946342, -1.3034095634154359, 3.6438422606836274, 16.925797901335457, -11.157356963563171, -9.489205250565103, 6.6241610519029521, 4.8277433164566688, 1.8997006542949399, -3.9683963448700621, 0.18280629345928201, -2.6148987092980853, 1.3047008475381632, 0.15453234920710512, -7.6062752618789702, -16.287776403972451, 2.058194192432766, -8.0636191013620717, -6.1701287378520391, 12.814513688388063, 2.9387977883312031, 0.30476196343129569, 4.7903016735157946, 4.5738939334265112, 8.2224576678405494, -2.487630709674602, 13.410551398671588, 6.9850948886400772, 0.41141872248185307, -8.9850656822390977, -8.270222857883395, 4.0855622391084179, 5.9394740573615863, 0.66547961593566152, -4.8872402963896935, -6.5784637920357678, 3.9322077727377964, 1.2314386333482341, 15.166282734668661, 10.823471071399581, 7.7815958101627318, 14.224216624745097, -4.6133272002733401, 1.0806092314381535, 2.0800972186132074, -5.4413864133776713, 5.3765504149273626, -0.37153867354802944, 1.2694604678589865, -1.8832160836865726],
                             [-12.625308689512254, 15.398745556505187, -2.2707243460439526, 4.8428460272767202, 11.311963140010151, 1.5734604340808074, 2.5525226597538744, 0.88486670127897971, -1.4589341034709431, 0.37323064175606724, -8.1478194419812233, 3.5524360058751401, -9.2125177931547029, 6.8726261361094361, 23.514302421339039, 10.440254648497048, -7.0502919709058096, -4.2798301870698312, -12.742264196129605, 0.79915458475541667, 15.306066367234031, 11.202147205067476, 4.8070583887270875, -4.9235266635600912, -10.580083707884214, -9.7317507233396352, -14.024802280319998, 3.5004301493550649, -5.0478497570376879, 2.1479056380951591, -1.795652572995919, 2.5873769098599602, 3.2758539078290991, -8.3024763215026987, 12.28622125514482, 0.6331866676489516, 5.9829016114430909, -2.8626739504967635, -0.45489901210146955, -1.1744523857198106, -3.4738633162736998, -5.2144252325307896, 13.056961843140275, -0.23087668086547786, -1.9322490987276644, -0.1501120755110279, -3.1498117166093671, 2.1690916651564383, -1.6040097316418673, 13.861059447779867],
                             [9.0078720424657988, 4.786335378450377, 8.7324716028693672, 17.017424228950997, -11.352492637881582, -15.958989120696815, -7.7370033384576118, 16.39294149794269, -0.69150714993987195, 1.0184470736955724, -24.213661189764629, -4.8805443915981339, -2.2630575234139276, -27.2700842701433, 0.16844094795909115, -8.150243354479997, 18.497331216995956, 1.0320138758277724, -29.294545188364225, 14.259316717559017, 23.623597992547293, 34.44072496198303, 7.6828718363192223, 1.7598581191694043, 11.398322888558155, -10.596966127897627, -6.6750509434267515, -4.179159792214997, 6.115879387416908, -0.89795360501507804, -2.7609962197836015, -13.091144394214883, -8.701431250050355, -0.6860624231758321, 1.2847170263738452, -1.0680307458566347, 25.497645744305537, -0.19693635153544406, 14.900012008109464, -5.6913744221032774, 22.097210257292002, -8.5604611026410709, 0.91379064493036255, 9.0857983560803675, -6.9536917866669716, -7.353878487338454, 7.2326720236189521, -4.7586903308595385, 17.155603506166699, 30.743333252686256],
                             [4.1282372709541262, -1.4218713404151098, 15.936880972673116, 12.404578115115571, -11.423498021688191, 1.9608323868601016, -6.4121999769496476, 5.9194213674433271, -0.20697029362447394, 8.2150864168042244, -19.802107207883815, 1.9217437887170581, 2.1842351842688661, 0.84474571277991761, -14.610842791228265, -15.020788720493311, -4.7021788379863665, -8.4708763890769756, -11.195499874951031, 7.0781577154954416, 11.983043736293389, 17.713912810819298, 1.6079584853476621, -5.8073004762613616, 6.7225370668609239, -2.7387307550440552, 12.886403857964947, 14.464795345788115, -5.0178779455980891, -7.2188987271237499, -20.029623231439384, -5.4749365944234514, 8.6479246520570356, -1.1032099522822718, -4.9625584601661776, -20.359076564286433, 7.5603833284124438, 1.1918342980626397, 12.17688862670227, -0.091363749003950057, 15.131046833329338, 3.1574030831688331, -8.445650549363183, -5.3506501553939767, 9.3374206779537197, 6.6103123492848468, 9.8700140196574839, -8.4962444559737218, -9.0448298572848049, 3.3655584198402608],
                             [-0.08146996496442041, 6.5323212018929588, 1.0954592976112862, -0.092515290111471138, 2.4557770956064688, 16.984923543591645, -7.2678960560977295, 2.6538997443936756, 1.4297319573509049, -7.7629653086346107, 0.82378037934454362, -12.084951155860571, 6.4072118674792264, 3.4032163443398016, 4.722863163957407, 11.540893817729266, 3.6481699276780102, -9.4554232631965807, -20.767652430194456, 7.5545791504025832, -19.530689782325123, 4.7014017515044202, -6.0715782886579079, -6.8212263497450349, 20.908649338156142, 7.1254084419927572, -5.2698313798760239, -3.2467471711659814, -0.97040922848658073, 1.4806663167186851, -4.969823087991097, -1.0346091292066646, -3.7192832096528625, -11.054784261043283, 5.0915335848327805, -0.57236670418207203, -14.194994051078243, -8.3488327839460741, -2.5072338071049045, 1.4343017788297492, 14.827762485356399, 2.2740506145713142, -4.3766516270174431, 4.8001238997722755, 8.7468549933323168, -6.0827006348268045, -3.475024156467803, 2.9755931517147256, -12.497837508329336, 22.824183886979995],
                             [-6.0046157783646956, -10.110720166583654, 2.469513091333114, -0.060631888548753815, 22.074281220458516, 9.5036425602539101, -9.9721021193584516, -4.4009656975480933, -0.87258542527497784, -3.9321843718828475, 13.897326753473376, -4.3084467389345447, 6.215028143721681, 0.81541573411107415, 7.8679483897257061, 1.1844967263110497, -6.8670079108409965, 9.2081782014477724, 14.739814293980304, 1.1658651005290568, -0.10512766370879734, 1.2737804066517076, 3.0576942919843693, -1.4405735482699018, 1.5516126957465968, -4.7854992075086811, -17.566185706068818, -0.34258128771809826, 2.3224756400226489, 6.046988461676019, 8.236940585332869, 8.1115602925224088, -9.3365999271152074, 20.678829060214699, 0.33189462422777827, 8.696282079535349, 8.6414210816282093, 8.5343751670296673, -4.0824893587373587, -2.1462268256636294, 5.9332742310989595, -12.223305535674172, -6.9144735296117332, -1.6238036982424457, 5.9099937484640153, 3.5788318752232575, -8.1676083188476696, 12.334865775711746, -2.4157482816299769, 9.8945499095611247],
                             [-5.1372029408676623, 3.0451724330907397, 1.9525622179450957, 4.191028766500601, -5.4741723977987018, -9.8998384236790233, 12.380590238572061, -5.3820871176556135, 9.3927630181187638, 1.7556655275317214, 6.0337360510349605, -10.142469495582114, -2.6243014142388184, -2.2253496022200867, -3.738274706463248, 18.440374198000484, 6.163374102604906, -7.9261717104187648, 0.96811028213115469, 7.4720704610172781, -11.876368252316569, -11.901325225628641, 15.485012291414375, 8.8900776505981085, 5.4236254494894496, 5.5912953137852313, 0.0093030919036059465, -13.224391364038899, 11.578649288861184, 1.8520158005925333, -0.60548266285308228, -2.0852306725294425, -5.2426803437866161, -14.229423283130073, 1.0659494985057922, 7.1978658979720063, -0.52023078330947703, -0.63328395823391226, -16.994661977442433, 8.9664216211523957, 6.7044271295204831, 0.89343706571063886, 6.4529034473910105, 7.8177769791171912, 2.6714658208239945, 1.0312402776946779, -0.61778177524578703, -19.4423980311817, 5.5700395588411418, -4.5183884692606373],
                             [-0.92659114739193116, 11.592443843093369, -6.6913032856536967, 13.747912514469647, -18.678413375890958, -13.021222936239402, 8.8004332969320185, -18.17898827171199, 4.8517505443253661, 7.0479540483721648, 6.5214669453227758, 7.5981430598187334, 17.714118155968627, 6.8523470211770965, 4.1456068285447794, 6.4720923762752989, 4.551450483542995, 8.9125813883992606, 6.0376392608228571, 11.314793378262884, -17.819587243116469, -20.106496624821993, 8.9057399382311502, 2.0543923168843596, -3.9922330448483803, 8.1536948211017304, 0.26304677678037469, -6.278933515534681, 17.691216626113043, -2.0980217211200687, -2.3072647576308571, 8.0496119429642139, -2.1037203966384186, -14.626293806261334, 5.2530770715389838, -3.2179773905631204, 2.6798520340760268, -2.9844790370403782, -13.466313226118904, -1.2630403805117725, 13.035630178911257, 20.298309186090279, 6.1320809417308597, 23.838185573051799, -11.39905825434424, -4.0029280881616174, 16.266435279596827, -5.8451786925794522, 20.576085537692933, -17.691117792840572],
                             [5.7964029871613603, -3.5053653108669338, -0.33440393203651597, 21.012320828101231, -5.3406722070078976, -5.7280870907106323, -3.061663598364214, 0.50928226836880008, 2.1680498616057817, 2.1423479511116335, -1.0574029094034383, -13.090496672100688, 9.1514736684640461, -8.2108652062594381, -13.315153555044924, 5.6558473918482983, 1.6578377560253423, -7.7573213225148416, 2.5664851293485675, 0.64147943181141054, -7.3841626805011877, -0.5361458603422693, 8.1666534930995578, 0.3396868634042931, 18.688171247335543, -6.8495382292944074, -4.9035953435892967, -11.241772659520727, 0.20904868637944718, 8.508745198943334, 10.018698153025827, 2.9617770990053458, -0.69683363939158083, -2.2809354330794878, 3.0253554490976802, 3.3883117195842054, 3.9807164768377623, 19.544024402404993, -11.544163340884468, -6.3214734670256201, 12.83735542326496, 4.4910067144379111, -14.442026251930191, 13.434525570574266, 13.903323070659019, -4.580145145165857, 4.7940539129051913, -19.258512597842383, 6.1967964000547466, 6.2577762479682857],
                             [8.0923240143544177, -7.3146060297759972, 1.5765797118988232, 13.468470034602909, 7.0666470645024599, 5.7994914829747151, -8.934701207852326, 9.2516451812466158, -8.2451480627136373, -2.5801939802200997, -1.4940935968927067, -7.1220531139613827, 15.640470767109688, -4.7548199396844, 0.95800304924438429, -6.7908334339262133, -5.3204993227404982, -0.64095986268306704, 2.6163819783945081, -7.7337425559850432, 8.0859368742540862, 10.020846977386238, -1.7528286587523416, -2.7049029279103873, -6.510072835940738, -10.074622235013479, 9.8726081659891136, 5.6147493245243902, -0.54797170606537704, 0.12635066547989443, 1.1793599576457545, 13.240447373182308, -1.0281725761332527, 4.1316986236267867, -4.0477052157642985, -5.1788177385835619, 7.517598243562829, 12.970724531290736, 12.068106169328415, -7.0327679181051037, 14.585382944243349, -8.3183598506199985, -7.9543155020332161, 5.7614045825101678, 2.5501298010850606, 2.774833402653448, 14.815010813039482, 6.8315399547006184, -4.2758819915717607, -8.0753053453885002],
                             [17.507780886298811, 2.7229147377193232, 6.2308429340367937, 4.6738115690855722, -16.839139624590974, -1.1722251310898477, 4.6281995063697012, 5.8672360684598974, -5.5592010833837859, 3.3046056448973027, -11.459601566508496, 8.9149043916438018, -2.2679083216568783, -6.2761602639713328, -9.3642878651817085, -15.974153125789046, 3.9380172212171636, -11.059349917220709, -10.008735190189265, -3.5318452403673666, 1.6800495057102665, 1.0851606774364588, 0.98152141655950031, 2.1672481527334306, 6.7219181400648287, 6.5042357628576495, 14.239598118399236, -0.56078374178127399, -4.6164985967867675, -0.13737542424996529, -0.94120063520347319, -7.9199502024566764, 13.587477625318584, -4.1208803062114097, -6.8999103246315112, -3.0778801036410672, -12.521437625533789, -3.7235436664897579, 4.0636670949313727, -1.1204450976197531, -4.6617955588073006, 18.567913144945727, -2.7223100483023153, -7.3584659973250108, 5.3862243284210001, 4.1013595482856502, -0.93838121481401704, -10.376101379960573, -6.0356730154092668, -12.328292648246897],
                             [2.8516915951521327, -9.6768938709711527, 3.2024217722271739, 15.840450256338213, 5.5144203955383695, 0.37130314821103838, -3.7153702687247865, 16.050178767921967, 1.1569419359499706, -5.4599135100143918, -7.4735051525265925, -11.188919556626526, -3.3166881109591606, 0.76102891885989665, -14.570155984608956, -3.9666690876680089, -18.226281617685334, -25.813472790495531, -11.069447701237657, 6.8052867310852259, -1.2485657366234901, 1.8416572496260357, 11.657283538304656, 6.1058472287461294, 26.840022853707378, -5.9429565496490397, 2.0352479269679877, 1.6142026114829682, -10.158447926833251, 0.035110783393811518, -4.6046636705115356, -8.0754685490792575, 14.797232726913348, -4.2389164377089044, -6.2013079477671287, -6.7188505092122055, -2.4826462647585203, 21.695989166373639, 8.4450813667708147, 9.7872004506683083, 1.9732590136670258, 5.9134085005426495, -26.431778040438292, -13.632728464918182, 21.966991770774825, 1.8058266980970259, -3.2414303179336592, -23.750840168274401, -18.242066367859849, 15.90826387581013],
                             [-22.86083381277248, 1.6606380188440162, 9.663490521739849, 4.4712204125434409, 0.15702705015136065, -6.1469606780599317, -6.4549690271414129, -3.671371935289748, -7.2035830036974922, -4.8383316113905463, 3.2098532685213002, 4.9778765568042047, -17.256480222530723, 8.9569987655013534, 2.6605542929516757, -2.8357563599868421, 1.0992649854862711, -18.521348492077752, -11.726066304792859, 3.966226658909429, -9.211175062338377, -18.53302204601674, 7.2075468243443837, 18.959248128144264, -3.2052749573756842, -6.4946778089372934, -6.2826314927273392, 19.511209943032725, 1.5340462079734341, 5.4157131963485039, -15.041156041818812, 2.2957717827582078, -12.657353332206505, -13.63803707307758, 0.86708188571477773, 19.624648941844576, 11.238248770373614, 7.0261108569976596, -6.0626079435646858, 4.01289811665771, -24.882938728725367, 3.7619652446966336, 10.329604290349563, -22.132424300532929, -0.83683690714481251, -6.3716198487631539, -9.6114240844128016, -9.1338607789839728, 3.8067699768079373, -8.5801508876201034],
                             [-9.6523533443800638, -0.49416261775770831, 14.62526648391702, 2.9802294890146941, 13.161673540217107, 2.8187981623135681, -8.3410268078730674, 17.243029343138542, 1.874020949249025, 1.8606444588341593, -18.100966439877237, -10.432113150490677, -14.463135815774418, 2.9546963890308775, 3.5455974847877387, -3.8047913645182927, -13.761313046040703, -16.557303341157709, -17.910596415616325, 9.7558903414009563, 27.868511897002421, 23.715127383194009, 8.3753659109459342, -7.2805193535404991, 8.7042161715382989, -11.522081885051279, -3.1238577024245351, 10.183976267254685, -10.145066070007982, -6.1419759131908283, -9.1018999217619623, -7.4704631181138854, 8.2551896347991782, 12.458304087352126, 0.48269897828637109, 0.40504698455459831, 11.115886664946927, 10.945991458720041, 14.518260015412924, 8.4636039795302587, 3.6105299891085236, -4.2918497942068097, -0.85011248544337192, -20.161199603557836, 4.2461550532570804, -1.2214938631441825, -8.1374584216758574, -9.896595304938268, -14.348987348141179, 18.192436638706091],
                             [16.596083870030906, 13.628625316155057, 4.1363241430677586, -2.5528386372590277, -9.8491194930954258, -1.9461702479648826, 2.2003963590300151, 2.7301961529691638, 0.016753312264022047, 14.978168935459374, -13.806973411143485, 6.4907125383944368, 2.1340724036908476, -10.873342168417562, 3.8556110448350998, 7.0112990125726666, 4.0157524322381812, 12.365613946999552, 0.58806073151819382, 5.0650708622749896, 1.6477567773133557, 13.415685851601827, 1.8275795023272077, -18.369149920399682, -4.3482872006647204, 4.20464427493547, -5.8244334058407459, -8.9757811703166315, 6.8800510729584179, -7.5663102766740193, -1.791084816825663, -1.7727825585007371, -0.64153968165987574, 6.5439995202725196, 4.4282379024222136, -0.69589696473284646, -3.0839682113350317, -8.0184517792850762, -0.49231674167947859, -3.9830066889708498, 8.6705161509751161, 4.1143768024258858, 7.0879993231303624, 18.696025662127674, -8.9952838290986676, 2.8777497681527322, 7.4278375641212886, 0.87371712405892432, 9.4088030490376422, -4.8190050149713537],
                             [6.2629086370751992, 9.4458090949508673, -8.0769108567403016, 9.7494898712487625, 7.8896524972293172, -2.5159277244481362, -2.1824245397742503, 4.4829387499357951, -0.64730461170131015, -6.5651300158514534, -6.966499545247439, -1.8174543469490427, -4.6804711273598958, -3.0743903810503919, 8.97997243928911, -2.1695306352032926, -4.1739816087521913, -11.39840023449185, -25.629581734949209, -14.847970407618764, 15.68632936438495, 7.8272812672078098, 14.439003609391957, 8.782538096286574, -5.1702012023478945, -12.850394284997313, 3.0402548593417325, -10.028683820564341, -4.1154490303193487, 8.8771875325616634, 1.0646051285085685, 4.3319732411376997, 17.055220461332134, -26.994259697925123, 7.7373187788541795, 6.0996181924327608, 4.2655662370085556, 7.1523310384189935, 2.229597095819484, -7.4990123340877872, -1.434759433722502, -8.0885658338589224, 1.7546693432912726, -1.9200627620741226, 3.435743733719772, 2.2673036870681549, -1.5458216193266119, 4.0692758501041011, -3.6745168816225178, 17.174494541806812],
                             [2.9129650615402207, 7.1589922201903029, 3.9647596839759944, 1.2265476412850835, -4.607936113679286, 10.896054513083444, -7.8592174058448734, 0.046538189141865471, -1.920436894009609, 1.5859004577333728, 3.764407071685413, -3.2354097473293426, -3.942539128397947, -6.3711613618041181, -10.04600190701191, 1.9677810018753303, -7.1108369484159155, 0.84021335709975142, -14.58003504055981, 1.3840898027436541, -9.7375188733107159, 1.9654007993371336, 12.758510241696717, 2.3892891907860636, 7.6752690540192958, 1.862960572676845, -0.12500050485383313, 1.5726134229124589, 10.319315744208922, 17.001511036260208, -7.8665449554155993, -2.3376385664232697, -3.001622948844286, -14.594029657873755, 1.6988217276196376, -1.8356855827077032, -3.6616827319513345, -6.1247049421306041, -5.2399583588174394, 2.1541577251195552, 13.502557992104485, 4.7360037521530476, -14.628612517213393, -3.2781037465220293, 15.365355827953598, 10.199968189901465, -2.3037708023975823, -7.7133878147550829, 0.31087920520676082, -2.5502855085098628],
                             [3.7914310751668134, 6.9897151670129523, 18.924828496718739, -12.792150092917666, 10.217904426130039, -5.6884751825640478, -16.388380544975799, 25.874766449672443, -4.0663748322566518, 3.0308080462650877, -38.222498770767196, -1.7861632569331762, -33.548666081730786, -14.331048963462994, -2.9795628968914873, 9.4846748099864158, -0.69787193842184125, -17.23524548731125, -13.117252033742549, 6.490042583582925, 5.8790185191749398, 22.635664554120627, -4.6145212793473132, -10.165158452413406, 7.0354269350113219, -12.005581355251634, -21.000687982292213, 7.57751296791999, -3.073308524871619, -0.0062477355482846164, 0.63844627636838602, -11.552433096035061, -1.8915079856650392, -3.5876274932185614, 8.0759622969231835, 17.891015610278817, -0.36270203167361981, 10.451159401158719, -5.2218499486272121, -7.2333174638655908, -13.818771095831735, -0.084166795740936884, 14.026246068900601, -13.561954822419473, -3.7608432372310778, 5.1611026505793571, -21.21241811933487, -8.6018550437122343, -6.7851102613401402, 11.14844475021008],
                             [-0.80174702148687249, -7.9685256156915072, -6.2383726784701388, 12.548770264860922, -15.842882062679195, 12.710183391409933, 14.919571925047535, -3.2724922210887724, 12.028053371331239, 7.9260210242267544, 10.924388985468394, -10.474870455467093, 14.429859624928316, -9.4520766061339643, -6.2985551843596621, 1.7936051559364312, 2.7504541552263637, 6.9066521125918223, 2.301910162094341, -4.246214790631953, 2.3620049497542408, 6.7700094278005931, 0.094796510557707214, -5.0959618979076202, 1.3477434262349743, 7.7103010979614917, 1.2612657968274141, 0.59141513763743703, -0.62999569523460375, 1.9250007793161068, 5.5899481075044646, -5.9648139158241422, -8.6709375300406766, -2.6669387811638883, -19.288643432275855, -18.949931518120096, -10.104444550550904, -15.099070796306453, 1.1026548879976343, 5.0679605429982297, 24.012865192396951, 2.3936603848568652, -18.473760247078381, 8.8563214728531232, 12.429410096299577, 10.682480397660983, -1.5636431397843267, -0.89223819764800849, 2.0431870064036151, -3.3311508389831506],
                             [4.6541068095616795, -20.374107957586286, 3.2847932691854642, 22.484075115739394, -2.338044497252008, -2.1704089995754905, -3.1059731723522432, -0.87410872195892741, -2.2730259001444768, 8.2227748518872676, 6.1374422029718554, -3.3549239442664338, 16.564840519501388, 10.048302579604506, 3.4293416200425355, -7.5943502312596554, -6.2476569438023271, -6.0087397221680217, 7.5505683212720722, 4.8969121424073663, -7.2490606006669704, -4.0861500689033221, 7.5086413768316751, 0.16642742992343729, 4.837564738544498, -5.5728425733753157, 12.843983535533557, 3.2582768735298182, 6.5643099820683055, 0.9074765029353169, -4.6641856801050334, 23.159118152512018, -0.79377722663055206, 12.61440551943619, 0.47089130036276428, -3.3628819395422958, 11.748102083141804, 13.901505803112975, 3.461366424110095, -0.45483720593788535, 15.558418910420322, 8.3300631412917063, -5.1205241856530481, 9.2895717790659518, 13.669184227347019, -10.801552018956638, 13.518715606492355, -6.5568271309716071, -9.6001164512122994, -18.174537968665177],
                             [-8.067220372008439, 6.0140429555725516, 5.2409122631468001, -12.023366015009362, 6.3101176254965843, 19.840121632221287, -18.436861759798326, 4.6071118106269839, 2.2061553190769416, -14.139443502938098, -0.056379232652949973, -2.5459003947975525, 3.8812719302630789, 22.154907029821327, 0.73381291541208027, -13.430201309832182, -1.4765799754124811, -6.5379130664529637, -24.378776010288188, 9.9586177647744734, 1.8418046966738029, 0.62264214822388109, -11.155047375897094, 1.442790996664455, 11.488088801810841, 8.7406078637293394, 10.081948233762958, 17.064447486793682, -8.5412816923768364, -7.664311286045649, -12.81829148882214, -3.5170857151240233, 7.0049416244476301, -5.0595534787104928, 0.97419312449305429, -12.969031136060625, -9.3303753175704021, -6.0430302881525009, 12.947198808296088, 7.4697927484661344, 1.6889609989921313, 11.661954489752976, -13.423807046025031, -11.889449136283357, 4.9783470454736731, -3.4679772035771474, -9.5475888933693849, 10.862394485313816, -3.1998519135596308, 14.221218854374268],
                             [-12.830658411645832, -1.4387145484679567, 9.3271117206487428, -9.5096486855220448, -1.6414166143453821, 7.2897210784971405, -11.795383701288589, -9.9612545692344305, -1.6171917763991654, 4.3686220889778973, 12.085191918881355, -5.420101104964588, 6.116891267552405, 10.449211357130768, 13.141694765329067, 11.027305385870434, 11.16021935245845, -2.6068908025116411, -10.9444977000222, 15.266669383905356, -9.3648477988838579, -2.5174190278168624, 5.6185851754588327, 8.4602360074351015, 2.5773495017261592, 7.3827575283427054, 10.124911952444627, 8.2422275764053587, 14.293155962758586, 0.60227767012187083, -6.30010157079706, 7.5180041279620902, -16.089729903522525, 14.438826861974217, 3.5735522879403088, 4.8635696637095087, 11.639524398859489, -6.243126129525769, -2.2522523407525181, 6.4802100398796743, 7.4274931238837336, -3.8229110929100143, 15.819107283462042, 2.8827106748405642, 2.2729320020488704, -12.765196844828655, -2.235921533493137, -2.7860995073790287, -0.76498367197963724, -14.016088307285123],
                             [-9.0432490742782861, -2.169187966260627, 6.3484028544566726, 5.7149319497912119, -14.527430581011471, 6.6363886548833841, -17.095579448433952, 5.8200007538098752, -2.9872637272763951, 8.560207340247155, -9.2159312838920329, -1.4771371802005515, 0.81884821883148495, 5.0703239558108679, -5.8622074681611576, -11.899587073863779, -2.7264047902995352, -11.337472809977097, -19.459871230830977, 6.158072974617145, -0.53922355806234323, 8.7289214459379014, -1.6678831367008855, -3.1978047788583557, 6.2114666855664744, -3.8076755365544508, -1.9443507830869888, 16.886643909665885, -2.8427949189931256, 13.607874664887673, -7.0750271041472965, -5.2016211012988967, -5.6681515725451721, -2.1472022007328517, -0.59671037452607889, -10.780971926689185, 0.75864494288642614, -5.9730681658127454, 9.045477064049317, -1.360590824578801, 5.7198685015596817, 12.246562418773269, -13.729031877978482, -6.3899701546314338, 7.871038194088336, -7.0496054033309319, -9.5051455460737486, -7.7965051051438454, 1.4271625020642114, -0.1117811500689383],
                             [9.4218635247067883, 1.7527632199345642, 6.6144577813408896, -7.2322105004304644, -3.7813628325996373, -2.5964089530485492, 2.6367760224030174, -5.0520774461561899, -7.2560811391734434, 2.4172970203662025, -3.8702500468002214, 14.960710789351669, -4.2944632537160601, -5.809636093287657, -5.931195858156288, 3.3365433650605372, -1.5808029059810322, 11.907576325875297, 25.289521738294813, 5.3320487632042859, -20.576948115954711, -10.597585417931715, -9.0444510681790113, -3.7739501279328649, -4.5689545640115989, 6.6978071446519065, -4.745882127546742, 1.7517046666728393, 8.0271186711537439, 0.76007336626796196, -1.4151403211872808, 0.3231473725786006, -8.9988193903071885, 7.5583863031025045, 3.058078558628968, 7.7519769738800237, -10.156818573005934, -2.0793168265742716, -10.369242867465923, -1.5172038653481223, -14.465136714889905, 2.8481661005068393, -0.41974907791739002, 2.388618272247415, -10.860586317425728, 9.9152619365675481, 4.777661024503729, 3.6677874467964751, 2.0938352961583107, -14.222825685022379],
                             [8.5833477882564679, -8.2578802163892835, 1.6432499528920912, 1.4530792058797202, 0.054232647769701409, -11.82785481550712, 17.295694725192739, 5.5487436744583709, -3.9487031711844143, -0.25210798861810413, -2.9678477552340152, 5.4635288938057966, -10.017576933701564, -21.183734097519711, -6.253593259521316, 4.594145194468032, -2.0734804306807177, 6.0926346415079893, 23.139923612199613, 5.1379823717026119, 3.7430358646013766, 4.1116767983487694, -1.0100957782064213, -2.0702613341338227, -7.840431273983933, -5.8518137746883685, -7.8992576616942927, -3.3901216076857175, -0.10645256115197077, -7.5858223939859419, 6.4780834174345117, -6.6934641970960191, -4.6844981953846112, 15.981022619051739, -5.3540453273669248, 6.3727837728941505, 3.4872066392359384, 4.9086451591003861, 3.687791421818166, 4.0104080328717888, -8.3090306097224076, -4.8351329537189205, 10.009395143098491, -3.0912074603493753, -7.2734788095685277, 5.1102916965918075, 3.3869556758590971, -2.1365388590995633, 1.2110205085901706, -7.0152779743212914],
                             [10.606041654546608, -0.75978208995009955, 0.94964624452283042, -17.720855314864092, 0.52687560921156873, -5.738557388935936, -8.8874029583238752, 25.694443387071651, -4.3753532547568268, 4.501528040663942, -12.628661290105201, -4.7132360933759472, -15.119933117553991, -14.532854757766774, -5.4326114347221841, -12.284903006263036, -2.9919040760303388, 3.5987310347217272, -3.5909111329433308, 2.7456514286346123, 19.931141694478463, 15.473000543401316, 1.4750963642975274, -9.0402473801540744, -2.314642098804351, -0.17822578792147281, 6.9634668379248073, 3.7751128750617795, -3.890827222022033, -14.00152533074402, -1.1770735315382268, -11.045202944019834, 2.3262780718716405, 10.62338064209538, -11.481194301229765, -1.24163946510477, -5.5353536671699608, 6.5923609309907079, 20.046835187040251, 9.4586103633475016, -5.5498497046141431, 12.609957621657964, -7.2591194782664861, -18.417559788411786, -9.2920958563849485, 2.5792058173933223, -4.2344075117290227, -0.63183142927241298, 9.9553121310328709, -9.4730421772922675],
                             [-8.3548574283613455, 14.872827679392396, -2.1610036100909458, -4.5737492626605123, -16.304925298678256, -4.3858979418324378, 12.434549803174036, -10.053811792406835, 3.3485437675315985, 10.729246954361157, -5.0115138931832632, 3.3823749672985208, -8.7030013977055614, 1.4763238629226698, -5.450104804583102, 16.915505360556971, -7.5091512471623281, -4.901087480998334, 0.44689967455543278, -4.8760625099001693, -9.4017718223688327, -3.4726672398399683, 4.6908547519184829, -6.0976362061897857, -11.712072312831616, 2.1571922450235945, -1.3034086896150496, -1.5838585045566116, 3.9001184868597947, 11.246825924116049, -9.5889485407168493, -8.0857142560350379, 8.1721020895999033, -27.396281676653121, 1.5161676942644675, -8.260140828999571, -8.0447958558660382, -12.994661746613859, -15.319787173442831, -2.1271336098632476, -6.5657505256472382, -9.8962124718644162, 10.67841795157543, -0.26346974401368883, -1.5781304108862857, 10.013770090981485, 3.8368187406327534, -17.623093754084863, -4.7148704880135881, -6.7309198684260849],
                             [19.989778061017617, 12.801142024812865, -18.399520162063297, -26.716884220834068, 0.24071245576065259, 3.3162463049905693, -6.360550271755149, 5.4864814242994813, -1.0352568955685857, -4.8346376723120601, 3.5718211115990699, -2.1207538832808797, 5.9096473112886132, -1.5460402280381267, -3.8483495416678917, 1.0808355447311184, 6.9107290106150385, 9.9060537037474425, 0.82111363231157064, -16.784738200392557, 5.1038114834824411, -3.5995424058905034, -11.083805787028965, -10.109984122069804, -17.721020823007567, 3.2348416588396369, 5.557025805270289, -10.412309938032497, -3.0478389520875249, -0.72232048023646733, 14.573924978538026, -1.0898329392077599, 8.1102572331855054, -2.5819567639264447, 7.4857959131220166, -0.050668720714132753, -10.003051693319719, -9.9541873283345321, 3.4780992309136241, -13.514065489994746, 0.63341403295171328, -2.0295862391185948, 4.9006252033939122, 11.257177095739245, -15.436358931693881, -5.0740146080386683, -1.6342710663485041, 19.507968431420089, 12.585984529110574, -6.3182756670968239],
                             [3.6863844689744161, 5.2663379005517754, -2.7003141874119394, 9.4230250842272874, 0.22795526240229633, -11.446283784865088, 5.4746862104237879, -1.3853882259623602, -16.564994927501186, -1.6490418957239612, -8.9142838456769322, 15.128273361723075, -5.4018989546214211, 0.074900940824123019, -3.0285338057104445, -8.2576455958248953, -9.1132822903880637, -3.9146688328654493, 15.937869179445888, -3.9993082180682951, 1.8268237373465011, -7.3690987354603692, -2.5618913611700602, -1.6795167157663593, -6.9874543165422613, -11.894681093322438, -3.8343989671429162, -0.0044151400740145008, -8.8619483068628551, -4.7993933448452797, -3.5149022489234705, 2.0474235412233703, 9.282388218986334, 5.7504907535081751, 5.2427903659004329, 1.7450207472231125, 4.7617303143543266, 17.648678198196464, 1.5747049138757949, -7.6130591255782996, -25.366682582323044, 4.5744908971879301, 2.0135003752346501, -6.8426784763107937, -17.390446145819077, -1.3716237648244876, 15.957431552585129, -0.97088543810509242, -1.3198368768130795, -8.0689159379146798],
                             [-4.9391715677651939, 2.462466521328718, -4.3874828167106026, 2.4517883168752679, -14.188811439721063, -1.4177736935054552, 10.327276282663338, -10.156395831499292, 12.192648994237178, 0.23825250404232712, 7.7473993105553847, -11.546110769745546, 2.572917928253279, -2.5907513028546507, -16.048663935054542, 7.0985732795911396, 14.20205728814706, 9.1505917149362475, 6.8068904605398366, 8.1958083054985131, -2.6760283314947619, 0.2480934384670932, 0.22126381304982046, -4.3379206730936115, 5.3710337389270535, 3.0265843898787086, -1.1818374278307677, -8.4228948954844487, 0.68537578114396158, 0.94890553530255617, 7.6825770854058861, -4.3376943725082118, -3.0945531812908373, 10.299150021098939, 4.8198034847770632, -10.615968959597815, 4.3401506884509651, -18.51170492096632, 2.9924327216626052, 6.1605723316748948, 18.465945449040255, 2.7063914679016321, -6.5765510255227415, 23.527411002727902, 5.9040943989436929, -7.3197968632248447, 0.37161349789767684, -4.6133131778341641, 13.900411885599045, 14.991107963460351],
                             [0.68243999097014107, 10.448965464252334, 5.1840623239720172, 0.57636966630918485, -21.366115176979886, -15.41259220905626, 18.458054937691212, -5.9006931709326311, 5.8962126137239421, 5.7940634015994679, -4.837952842796323, 6.5015186003906003, -8.3668266204290074, -6.2674467332883017, -10.363177203312478, 3.3587742654611228, 12.617461904437674, 2.9695061280471409, 4.4970237871415968, 12.772804980794167, -7.5883258881858247, -1.1258303052121756, 1.9693926115191314, -5.7163320804729594, -3.5421319201879569, 4.4097539392382252, 2.9285617790965972, 2.7272407259699292, 6.8415378491103134, -11.184100593679354, -10.171751852091438, -7.6053185854039791, -0.60221307869649099, 0.46759781159220903, -0.57827935139389308, -0.32203099874067775, 3.2613241616454367, -17.111509159064031, 0.25263240865342457, 7.5351251593178104, 6.0437252598065481, 12.429724567797074, 20.459428610628898, 8.7606000940387716, -5.2288899468593861, -1.6684913562952266, 5.8258423832480943, -6.9069898207215026, 6.339339136238606, -12.407420606837729],
                             [3.9733987923480045, -1.2516467673393803, 6.4334864188796654, -9.425029758767689, 6.3833228997680393, -7.7916871710216338, 7.6220922402027957, -3.0076149682196318, -3.2670872133538489, -12.006169478120885, 5.6211290698944909, 5.8662648834922111, -12.556529747456942, -2.3176813117101283, -8.7518811794065652, -2.801892285876761, 13.857802670283197, -2.0364296767423138, 13.176065607859332, 1.6261493902876785, -3.7083895995723264, -12.004073480342353, -11.019116293885652, 5.3014506056517243, 0.71316561661697209, 3.28116552083603, -0.22780084060769634, -1.6473209630360559, -3.3791134207074984, -8.9151734793820037, 2.1107351723724799, 0.32153016895011977, -1.5218074753509006, 12.550490990082418, 4.9593141072382618, 10.675263758985469, 2.2597983081300974, -6.8941000984510472, -0.34962547720234627, 1.6911976617834581, -19.915275328451212, -0.64287396721008383, 10.791510176438068, -1.8127151364425329, -6.4401436504750889, -10.098658326607927, -3.8542057175413946, 5.9282145490587599, 0.08194354499061085, 6.5761652363790821],
                             [12.556856242117554, -6.1358074463819694, 8.5396917491640281, 11.758916811620889, 1.0436676902133306, -0.64609881475269582, 13.000062206961791, -4.870178022354219, 1.4551789489031108, 21.35150304446028, -5.4882033856873971, 6.7045001069771955, 15.534883083806703, 7.4744257352119403, 22.67570478472404, 19.990758509038251, -6.4234122753207279, 6.862476807004974, 10.730029594464549, 15.805751534625346, -10.163064231488159, 2.1710908702361387, 3.2068268879235897, -15.449895436751863, -6.5168031439939531, 0.72748620411403264, -2.239905257683052, -12.351597821162692, 9.8755474287469127, -8.1184773093804345, 3.211366430998468, 12.188267830050592, 6.4211978552536602, 19.213337859913338, 7.7841902570459656, 1.6629730098702435, 6.7657544979733082, 1.4920733912064514, -10.034027264917212, -1.2712969907509479, 15.056581007302624, -3.8547908609074382, 19.741628362341384, 25.319944433955211, -0.47973232915724762, -10.756405269358208, 4.0832040039042683, -6.1677581797886525, -17.100535300704312, -15.952625275952455],
                             [13.141552061006358, -6.7664301323712994, -8.7156323363094526, 1.3276508873021389, -0.43913995771012981, -6.6786637503456925, -1.0744800750367078, 5.9262326415582525, -6.778103164315886, -13.610997505853842, -6.5886711022827642, 8.0846629400203405, -5.388713567982804, -13.584979900525195, -16.126191168319671, -25.148672213542049, 1.3922656525381476, -0.76975496868810644, -1.0910637569885333, -8.8634454825452043, 16.997277730124228, 2.0544474155473234, -5.0710408589509273, 11.264325381887064, 13.544334385527243, -8.1533223575836171, 0.83506160919805805, -4.4805777478296269, -15.244166262752866, -2.70885526263717, 3.711640167223738, -10.921146049028348, 8.4113196828076546, 4.4450948329529432, -4.2601455301089333, -5.9076732437052328, -4.1020216354025649, 7.1251126733640717, 13.018158869277853, -1.6962554133730352, -16.015528845530159, 2.8712705822536604, -22.108700039427248, -14.026413794521799, -9.4032395316549575, 5.2339012668061278, 0.01968731538197499, 9.37520665339731, 6.4470383751259543, 19.304997765840703],
                             [16.526560428080998, -1.4142195599128644, 0.92997484255782137, 0.26375093323487048, 12.292677934408186, 7.6472213744645599, 5.565631129358291, 6.7748490377128201, -0.14401078618259144, 3.6297506357104954, -8.1615856578620409, -2.9835898278190709, 5.7015416193139155, -8.7845812033300898, 6.8170083927703482, 10.997468857160881, -7.8146599931504266, 1.9977422781374927, 13.112169889701018, -9.680339915743275, 0.56502886808435093, 7.4948605762301668, -7.0916580984996997, -16.678312052140924, 0.20570980631147956, 2.8240266075355684, -2.7999263871189002, -16.914928221862176, -8.7068262397517255, -7.2921700308159645, 11.652519837563769, 2.7390494981782125, 9.7103116904571642, 6.8658220048978906, -6.5118316228612354, 0.092639728589183346, -11.620689430389604, 13.518229925820567, -7.986153686853255, -4.7930301228522811, 0.93367847523737613, -10.646008841092328, 0.05809817057456268, 1.6659235892653923, -4.609105079416306, 8.0154727265471699, 4.8431323678341691, -0.25783790427327791, -11.393915882882313, 1.3858360966411118],
                             [-6.1408285804618075, 12.404418601446904, 0.50056131273441817, -16.735743491634029, -1.0373546409227044, 17.402698035564953, -8.2947913874559678, -1.2155014291778974, 5.637011276605274, 2.406793097790068, 3.5900960003045346, -3.69425824593187, 0.048851317413289852, 14.671207605694644, 3.2100536826918566, 8.2630316391264156, 2.6703685995540321, -3.1765848232973255, -14.433092104861656, -1.3167456851791233, -4.8674605445183738, -6.2476750291837355, -2.2097632292780527, -7.8546349658128403, -6.4176594784798935, 5.3703161924918472, 2.401984574644751, 8.228901202687295, 5.7858438300309256, -6.6573956080731538, -5.5028229581982551, 2.8497630796788895, -1.0544789497890692, -6.0025548340840365, 10.058405494856174, 4.2033231997795601, -5.3108109256501068, -10.047928763970747, -5.454962355358056, -0.26730140851163275, 1.3370947871597019, 9.7454468519503319, 8.0859365610048943, 3.3680599675406993, 3.0532870422430962, -9.0090625599573428, -13.570815029290687, 4.4629032361510985, 4.2569804990479341, -13.092343327972355],
                             [6.3889731079206911, 1.100421625330555, 7.6498278268594389, 19.534652325899419, 11.007313829655089, -16.403231087829965, 9.6166145085684889, 6.1602420422352315, -2.5042525052214395, 2.2276320840480133, -4.1932405195925275, -1.3219307098895794, 1.262993567845005, -4.3567297796924596, 11.868165872097444, 5.921289263129399, -2.5948924475203548, 4.748591738662868, 6.3033827514218013, 11.048280957256187, 9.4296156588849556, 9.2691541593854279, 8.7585395570286781, -4.1718823151099365, 3.7205590171455105, -5.3458368155804523, -4.8800641031204783, -14.285648584199366, 2.6681568518084724, -7.4649258197338355, 7.2989119897956289, 4.8221991368345929, 7.0448616093280751, 10.531429259887959, 6.7487088947239116, 3.6347742970684354, 13.662917064789418, 14.225616173372527, -1.0855776754762636, 0.016230856474561572, 11.856914748829174, 0.41643889613051532, 9.9190077650505906, 11.966513037005447, 7.7254712235126934, -6.4708584749019336, 10.337991053600676, -10.573214769276191, -8.0014059764865291, 4.0245553007307109]],
                            [[-6.3895574643529081, -9.2194365396250149, 6.247096647722822, -2.7812311113031658, 6.5758146541070417, -7.2246881831153704, 11.364076564799625, -3.4516891779467564, 12.489358208456984, 2.9696471981360331, 5.1127534690744723, 13.216030281286512, 22.05810656676319, -19.39936899079936, -6.3700500492101346, -4.6053446413071502, -8.6116534262392435, -6.9131399521520347, 7.8148814663559341, 32.299286735797637, 22.45609452259248, 1.3265158107659225, 3.4168932054760526, 1.2828917964017637, -8.0061143000359518, -10.666025030400403, 17.475968383419691, -15.819468773174558, 3.3608423312915869, -8.5953270566759219, -28.830360304305213, -17.783187604727136, -34.814731937078029, 12.209239238315549, 29.728635729899576, -26.709516715277516, -17.459531065261711, -19.540102758753402, 19.095090565851073, 22.655384042514171, -29.136664405642247, 26.959151270483162, 9.6282469759595273, -26.873689244927892, -21.817228549767336, 8.7316757440471289, -24.427417964235154, -13.538359681539202, -21.062737160961198, -1.7648417085850958],
                             [1.5035047678063584, 7.4342776564405453, 0.8057242444724162, -24.483976684064206, -1.0948750993028655, -16.540626491665492, 9.5127498755707247, 0.62485009246302536, -14.787865870678893, 3.5551011716642957, -3.3893766646736605, 4.9179193367751761, 0.0063663541886100905, -9.1697555776009665, 2.1081158306606453, 18.025405019113666, 5.0330326356595956, 7.3391309873629993, 4.3122281429896026, 6.6700960935759204, 1.8113649478621328, 3.9343178888312695, 8.2294851639996072, -0.0075825021208751203, 29.144495994915626, -4.9268277983797066, -18.115212969989443, -19.122047915434344, -13.905672451793619, 8.3156071436022376, -6.8418130456875632, -3.7628748756828165, -20.729433894358998, 10.011011870750538, 13.145478138509576, -10.202086309148131, 13.725564635674415, 12.841441998570062, -14.501156013412658, 8.2808225607872004, 2.8110691213917596, 9.393192622580969, 9.2900962245983099, -13.720205221403191, -3.0420788269886918, -11.831334770611294, 9.3126883644777934, 4.5051420974304941, 19.673078525525778, 18.855919351613352],
                             [-7.4467595057845202, -7.0692342431503077, -5.4092738737548416, -14.501800338105742, 3.4822698739697207, -2.4125543496514252, -15.387542340010198, 16.792271592846109, 1.1319449430777997, -8.7751745112469983, -6.23064433712194, 11.94607146490322, 13.108914844782831, 12.868952010252245, 0.92695965973373962, 0.90779401712760777, 9.4743380238790529, -19.07780361749499, 3.9805189082915353, 20.396838925298468, -3.8513724212675835, 31.709924334583285, -3.7647144415320644, 6.9036226430392533, 3.6305443484673985, 14.366460710966107, 33.280872946098768, -10.007485020244465, 6.0923575690054728, 11.211345817794777, 4.5307068890176865, -2.2726570388427576, -8.8966016333558144, -3.839622876751263, -0.22352843741867523, -32.910842280605436, -0.14373491089676049, 8.946092454814103, -3.484108248452328, 4.6920447708276374, -17.598150251673637, 17.552872268993035, 2.2485707628063234, -4.1111827341398195, 1.286253636380569, -7.3576350284008631, -24.014440412842859, -8.0046262034667066, -15.194189512048558, -0.2929845976141629],
                             [21.378366681257212, -9.1966701312664867, 4.9319002154996578, 0.75585669787805965, 10.70623793471907, 19.626707771094893, 6.4552010064256198, 11.825884036777454, -7.9196173536782259, 5.8580461820657694, -2.6563155935868732, 11.657912185671114, 3.3148018606093461, 10.163699891802223, 17.978442715202124, -24.071416346362255, 20.324011137587235, 26.60438956767414, 9.631574502056484, -6.7021478034198871, 1.3478848909406196, 9.3002779418223209, 7.4408942804874822, -7.0408740860980021, -14.738428763494609, -15.628876804482108, 2.0234748539995673, -13.648849278891671, -1.1607324333175786, -5.5165132781358368, -7.2342652774994916, 3.1881510853671018, 18.239560958982977, 0.34383224728210171, -36.647623979865308, 13.730004608511839, 11.475293229477247, 12.008738942934253, -3.744226922324978, 9.6757126746949069, -23.380236561879769, 7.9905216620753849, -7.2513369925598363, 2.5074580706434539, 17.796394935064431, -7.2459362516664854, 8.2614531580235404, 7.4414830528233962, 1.1636043634351214, -10.745148032884847],
                             [-10.702429824217965, -0.52246557210328648, 13.104263619411821, 24.433469379651253, 10.9887591259102, 0.72647462828746145, 7.8686920420357129, -31.59500871774414, 11.097892210904336, -20.903806003972086, 19.875042768166516, -5.9676590272749275, 6.3316028003248084, -6.8521677417637612, -17.078729018548739, -19.714236139547413, -18.3883056842195, 7.0628675329885473, 29.577080697527112, -39.339357410834886, -2.6992471134706117, -2.20867493324935, -25.836670632866689, -3.8419066259966419, -7.0326751858931598, -13.101388924295902, 9.7473522553450653, 13.297997473777583, 11.387784419890624, 4.7807958731867846, 7.7835481906482782, -32.132008834319748, 10.304167106043682, -18.641695815856849, 12.400842079452401, 7.0463866402450011, -33.994584560971411, 1.3233014629502409, -8.6686227933989475, -35.511079981702864, 10.524057786488406, -21.564159352053615, -11.505934020708075, 18.233022471395969, -15.307958885220616, 18.229169322425609, 36.53616299584575, 21.876291838677307, 2.7379292903573549, 24.928943935413862],
                             [28.282721876943796, 1.0192928987268344, 2.3425881031659084, -17.87829526558739, 9.0456428066769146, 14.772213335763734, -17.585475795351517, 34.902829501213461, 3.1681973036670024, 11.580123632201206, -13.421985906195223, 53.559302755334187, -17.64056689502484, 27.278437767397882, 9.7016978608715299, -12.819279042246697, 15.532347405420985, 10.681756571986309, 0.99601452405153468, 33.660802243612245, 33.775198755339176, -14.993071666863823, -0.15852278903909553, 19.342994437938199, 26.903835138652941, 9.8920059825027096, 10.737221137702923, 22.069078530621034, -7.1515630612128778, -0.44620201002813575, -0.83745599402444659, 6.9926059302315595, 2.607420742735703, 7.9252182892973382, -13.63177683541557, 7.1844546355476391, 37.00408896496134, -12.653316420980037, 19.685201964244634, 2.4842819798850777, -32.414341284211439, 32.259605790191664, -2.8230634544584485, 1.3925225236443308, -2.5815932129345174, 0.62675927624364236, -5.5268465789131831, -11.054462072922817, -21.007127408021912, -22.11909099137997],
                             [11.227143480743498, 14.714783452109875, -1.2447445611213495, -19.899498698120428, 3.8971396631226938, -12.514520073092807, 13.5134993249305, 0.0088513056334597606, -27.925084881515197, 33.453162451118452, 11.668627005035102, 20.101776768436086, 0.43308528638642424, -34.970562567045398, -19.7082294252398, 31.454654691488539, 19.593192082716637, 23.2494375141031, -11.292086591958038, 17.269675351720355, 12.349591461848965, -8.7654555933146288, -8.1408517845011108, -11.654742687540814, -16.890196503837064, -29.912470063873016, -0.37834193729089394, -11.73749383453713, -48.52911138621743, -14.281200720605796, -6.0329818389753003, -7.506021009217605, -38.121250576622195, 15.326123201622144, -21.778309283348033, -2.7768762532756801, 0.91946028952438419, 29.571797426261483, 7.0066562237635077, 15.129821420936432, -41.959334257686365, 42.129590967395238, 6.561708127732504, -3.920480419149448, -21.706765111855709, -22.939951209667175, 13.838828466466042, 25.686534066407255, 21.392026105170906, 16.288876652069849],
                             [2.9144115055620872, 24.289629814316847, -9.1374820509222179, 23.353115619982351, -10.093910365383412, 0.36046145924825462, -10.052024046194949, -24.607278746065845, -19.397227132869464, 23.866278376658446, -0.044731817091774706, -37.058953894858497, -4.5110992568713311, -9.0954789027465495, 23.543585708178576, 8.4410024751094852, -27.074154979351778, -14.071267205070374, -28.030465080384808, 23.509239838073459, -18.063953015467149, -2.0820651135020491, 17.254029596100469, -2.1818227873289122, -25.45537752469458, -32.904348822433306, 11.129551428515242, -19.105973099954245, 27.793813547132473, -16.265132938250563, 12.437799849863236, 13.123266167768808, 3.8777746278315002, -5.2158545040211246, 13.978581015601462, 21.331392068098609, -12.007773580927088, -14.059970454217506, 9.1193527436246367, 53.409081265919149, -13.503665426329555, -3.51870649158188, 19.817712352193524, -13.268720777450445, 10.753386212564855, 15.656842620514658, -31.434879382060874, 22.905478284638576, -27.574696227436068, 1.7011251223497856],
                             [27.424994889320516, 17.015710287846058, 0.48015992787538764, -19.30013858175413, 11.283120663253882, 3.6215884111280912, 4.158624955506907, 22.217827819171909, -8.1174784010773315, 25.574149037895381, 20.2256206767231, 33.493095779634295, 6.1620635989158821, 1.8602632808233821, -12.692146171232286, -13.593232667590852, 32.991379717045966, 21.657695638421906, 14.032842503336525, -3.1881834130145053, 12.704890402372159, -8.473336633076169, -5.877737947376164, 21.578320541305775, 21.574519561855574, 0.85560278422710023, -2.0207437742877103, 29.369034962658425, -25.349824244261267, -12.769141747922578, 6.5816986792322068, -14.174825257497915, 11.393989510048018, -0.77121314159580323, -20.547343938576422, 35.681847958695968, 25.347026789410538, 12.252660056232301, 27.91029322945333, -1.1574615899969887, -21.489148790163537, 19.035213873023338, 2.4499769496439048, 13.616020440375742, -22.926770137940267, 10.134589591346561, 7.1065697853928809, -6.1567212923112011, 21.835959807509273, -6.1488437617450886],
                             [-6.468439347888677, 6.1815066279664928, 13.112690788770886, 13.761395906625458, 12.277543670812793, -15.630435002496803, 1.930608964832448, -6.4772354931195437, 3.7365311634442606, 1.6441964344563023, -10.514634225384514, -21.109607219672231, -10.058370497942168, -4.7651744058450545, -9.1903239006976669, -3.0772136973339865, -2.3434075363667044, -12.982397981543931, -10.420298585150938, -13.925155589741333, -17.769636348837423, -1.9653533899146831, -13.223395047631099, 3.4819129720087023, 13.783541482640976, 8.2273307389387043, 16.599358481445215, -2.083856502186912, 15.96268469792515, 15.841180980901655, 5.8271595083768855, 9.2813091098419509, 12.67698921034428, 4.1937059782174186, 17.64411853172631, -12.019065243447294, -12.969056458397196, -15.501933945191666, -12.799794404878732, -6.3188842297014922, 27.490720595232787, -14.182574492150275, -3.3693135885185801, 13.105219293174178, -10.3874773955507, 11.452519011620733, 2.4682418640159938, 11.574797558171344, 16.382322940051019, 6.8166630199826139],
                             [3.5708026190409128, -3.9650381347524957, 4.6252091344550132, 2.6764264686410835, -11.898355981495371, 6.7752046243360056, -13.891566336024106, -21.073030321999234, -3.1086203386460984, -2.3458723829239019, -8.0119558178123498, -1.7773047074937403, -23.659092808524054, -4.0053165756658782, 2.5841212446099497, -7.2846858372086825, -17.110481233228832, -4.2829232366492462, 6.9267113249360515, -15.397502819914646, 1.0388022593200275, 2.5806834187224883, -12.683008112540122, 15.170464316725946, 20.688625709663761, -3.0386949516735595, 39.494609090582074, 17.551727270921688, 7.3886723670812389, 8.5486044579645704, 21.246277924756935, 1.2824904487488096, 24.29549908877345, -22.754858909924426, -5.7362320018131676, 0.293270517213371, -15.700594966846802, -11.259274776325801, -5.6624038435072421, -18.749143325151895, 6.9813203679711533, -31.728890539397582, 6.6686393170432261, 19.456374480934247, -1.4422657737614288, 18.006898609744816, 4.9219268342461406, 4.6581440903910591, 4.2439247532385176, 7.4523799198504772],
                             [-10.555801432772844, -10.69750480692764, 8.7563600120120988, 11.761541845599806, -6.9902297077965327, 4.5965105821575127, 1.5766233412599386, 2.7585900448512888, 30.496165717745694, -21.750126896118729, -1.4638219795068244, -19.453107285563405, 3.3726647521674695, 12.906286726494413, -3.1469670966081069, -11.953692204561658, 0.2254910041366916, -7.4603853489642624, 0.61559920242020993, -15.175413432394036, 1.0944462961465118, -10.803837608639144, -0.25974318314725853, 0.29698741075952723, -4.8583876588444816, 17.498450667111889, -22.615974080414798, 23.989688515925149, 20.897103270638294, 3.5127572489093204, 9.5986545845679085, 0.67880450854394125, 12.379141705209621, 4.6771004792114148, 29.12975475567259, 20.624983262543502, 5.8751167802717692, -17.239890376053406, 7.0245489249710893, -23.855865446899308, 40.291568719619811, -13.289883853736407, -11.308736136649612, 12.117535843817112, 4.5696499954910985, 28.636778800240421, -2.5533487478151371, -35.471568781401437, -0.53395166640478842, -13.362325444793651],
                             [0.32818582273055374, -12.459831801459616, -13.746224231577429, 10.663045691730687, 6.5889707624518898, 17.679483880977127, -7.8819054454454074, -3.9427105487492322, 27.049038201166564, -28.35147284599028, -5.8939211905368412, -4.322018737861991, 18.158335596156071, 6.0071575383733258, 0.59271754720592762, -7.4635279258276155, 0.80699488568425881, 17.58303938336401, 12.998325148240626, -11.081949365967461, 0.95711208970302264, 6.2998724805229491, 0.98991152077733846, -12.088597766542188, -16.154470101750288, 13.640328977866217, -25.379829007991244, 2.2012993869680675, 14.883024542391242, -8.1286280488255898, -7.2527824667629446, -21.051881249031712, 3.6582593785042827, -9.8777631392850083, 1.2095590440156805, -6.1079237013104795, 1.5594839052805232, 9.6529941628842835, 9.9180295545296833, -10.619302874505804, 16.091404397226174, -10.203424200876881, -24.376256601859883, 5.5342818885102014, 12.473133164414152, -17.768099710808251, -0.18967745872996045, -11.737625055682122, -10.574855027718161, -8.5768438980033128],
                             [-10.349458832622901, -14.123369849987945, 20.194761673185255, 7.3486801054021313, 0.55015096073634928, -13.677138925296713, 12.301776501092863, 9.7672780816536005, -3.0868851377849853, -24.043397348491016, -6.4334773256790427, 0.4405324924118601, 14.796424623044784, -4.8508025043021883, -13.31605746603619, 0.12762803688965701, 2.590264504938018, -13.044413952698211, 5.4647121747532488, -3.1682476748857633, -5.8769922377153856, 31.997590923785094, 3.8959371621237109, -10.661167850834572, 12.503617175552577, 28.485579472852759, -9.1821196378236412, -4.4390673985925719, -38.760396928347213, 1.972424660125323, -0.72305585871213296, -2.0796412396226485, -2.0467185653228381, -9.9233706170795344, -16.332459693847543, -34.542799008500289, -13.279232896435465, 9.0521042357861088, 1.2636543010736414, -13.579343980968167, 39.960108529059582, -34.91080179173256, -5.7476170880773108, 11.411646260581572, -3.2679074698498991, -16.373922183904533, -3.4891071201628923, -34.240118283575598, 30.620142543516334, -0.55742587177176628],
                             [-0.028154607335223819, 0.11942277748498509, 12.784570218608156, 10.138756971627455, 4.4643253779757028, -0.096742769156404687, -18.895670163789401, 29.69722859363268, -19.851478483457115, 7.6055921271459743, -14.036759108599725, 8.3591341525738976, -3.7513851572006076, 23.645116993533264, 1.1607334815983166, -14.651075585499514, 27.830503473954749, -4.9956893143954408, 10.831904649866697, -2.3235318182187061, -1.7500795530044828, 7.4166415524665545, -0.67801631242078653, 20.489463849777394, 42.422086089653277, 12.808185367470397, 9.4160398972236212, 16.238791325916072, -6.7300126436390322, 0.90355574987165199, 29.387669576820798, 10.935595987584646, 36.14373595340053, 20.715939398057934, -25.585705392683995, 1.4486754027694912, 20.571544989197754, -7.2048588381104395, 17.799913469682444, -2.2528191089719618, 3.3357754185487112, -20.812231655798428, 9.6188235098693404, 33.283840357219155, -10.850288513411941, 27.351835018686284, -10.510401151021844, -29.102191209956104, 13.827656836379155, -3.6629360613540318],
                             [9.6464574131925822, 7.792374206049014, 22.641069146299721, -10.780243288982522, -14.361361140613235, -18.528545183630573, 23.174062582096642, 4.8389524594128401, -32.751487535078148, 17.44230741837962, -4.7114420335705223, -6.7285226086508647, -1.6739475760338516, -22.799468006631528, -0.80480345617894833, 14.580153222743279, -21.39836481432647, -16.314591427291081, -14.904417028743778, 20.49377525072255, -6.3628995225882541, 5.7762362037467021, 12.800010153541011, -1.0576550905702706, 19.48633972282547, -2.2248586181676573, 1.6990106422339926, -15.265920873763408, -38.523699532901432, -4.42966290976364, -1.5654382652809651, 20.50795284167328, -13.775101711523114, 7.5356086915634481, -8.0954392246216091, -3.9819695393889081, -1.5546581477961516, 1.2384469508397111, -4.6093804232096085, 17.14786438682869, -0.68503176420113565, -12.795521893828235, 16.104956491904673, -16.993887156580826, 7.7297130088233175, 2.4812142782755378, -6.8253337360280533, -8.724238037320573, 21.287379871134956, 20.343613489909746],
                             [0.23469901723106723, -12.423608962923339, -15.687279344636012, 6.9484465307455956, -1.5451307077039229, 17.406968876050769, -2.0465134090620469, -24.040523763491471, -5.5610346221064075, -10.739064091718841, 1.4996257831123825, -0.27373709653460826, -0.43324042499487991, 2.2875008885073429, 5.5408274271850626, 12.775279902209007, -14.759467821846426, 19.130491429029284, 4.4353764163723346, -19.850979130732355, 0.86254737525698311, 6.770165355344357, 15.203386574392209, -26.386882764452878, -33.591596097160483, -18.010369860964403, -30.454794987707629, -16.617486589737037, 14.045124082145618, -19.900152196677922, 3.9373259220567887, 0.64607557904125146, -4.3348768981379093, -3.1434585347754243, -24.60873708803588, 15.735658038936213, -17.536162476650951, 10.155269560568366, -2.9468694528204078, 1.1813501371414004, -15.916768107319021, -10.461318867417763, -22.620477164909659, 2.8650799965874274, 14.970410653114579, -22.031433978437633, 26.665824719229629, 22.899449434584355, -9.503633547400165, -7.3373822220213922],
                             [-3.9102519725371523, 26.57380641825366, -13.318149367119032, 29.689909996300123, 13.779768713427565, 6.8676750123694426, 16.80308169966186, -9.5568402818194151, 14.418262808102984, 1.7783589977257606, 11.800104828035961, -24.041212789822115, -10.764518182676092, 7.4262012765348944, 4.4735415562470511, -22.949443818678752, 7.0490865116931891, 36.124260919955809, 7.9356250924134013, -27.96908391857729, -8.0516523419060668, -24.228134347298035, -3.030650431268449, 7.1210174019073387, -15.177322113133398, -37.396729824560417, -24.995876859851045, 18.781941145801618, 31.396285973441952, -8.9762142677039751, -16.863792629300342, -24.867758277084445, 25.425033232400441, 20.953254197580041, -8.3234464552805516, 35.400764379682414, -1.5720896487301448, -6.9665019043330751, -3.4178143964183847, 1.0494043056859348, 23.940452266436719, -4.3401880753602065, 13.028621870885527, 8.5443711938297717, 3.4555425815955463, 9.114377740379787, 15.963428462382742, 13.859930302214238, -8.7433394139034952, -2.8012814783424229],
                             [0.73676574620176338, -22.851757665516804, -9.1627269748734896, -0.75229623503711307, -0.063898637646846682, 6.8165172536801606, 7.4814378565387916, -11.278544765832679, -19.472643551523774, -0.96621638956795475, -3.6178931064084168, 37.052084083654506, -9.882863586119548, -2.2288294170902434, -1.7719156181319122, 2.317124335041989, -15.71608544102784, 17.121137795384119, 32.028693257309008, -20.606572394292684, 12.449682805188022, -7.9283000545354554, -0.88582986470364333, -8.5846855937044193, 4.3410189038377442, -30.131904822709132, 0.38049549748876549, -12.584346870862634, -2.2346305097546599, -5.1611796587773604, -17.57445941620151, -12.484800737854464, -4.1029864024714602, -4.35846716667103, -31.926759159497472, -6.5243739764810815, 7.2295221158563336, 16.023131585977225, 13.425366933994807, -8.2527983282604964, -28.51860902975967, 8.1278283885942137, 3.932215516319856, -15.164417039701817, 7.835214483997925, -28.870423964265211, 18.082322179184871, 17.471114872899104, -17.818383208965599, -0.97355072848560498],
                             [10.754516499383364, -21.88559239910083, 10.320026075257559, -18.747898723584704, 9.6400139624256109, -2.557893742810438, 0.6455589408432757, 11.693739405649007, 6.4836792626494759, 2.9587072051963625, -14.81711071133857, 36.816571407391017, -29.588213668122744, 3.4337645637357133, -7.0545997680612063, -3.3974087546578535, -0.41049780715543205, 10.462561406806103, -1.3352546637331122, -10.218048234055445, 11.297334953233737, 1.915671038185822, -16.058942555824451, 13.089990233786921, 17.321045043148931, 12.593811711602216, 38.26867858730396, 3.2812376878051541, 15.065164425400777, 16.596980867168352, -16.335649400375857, 17.61054700497532, -7.8796722437277706, -2.9992233470915757, -6.3233063231887163, -10.064964362033063, 14.117254716791169, -18.099718097675815, -4.5198839215407673, -26.473859251894311, -7.0316689288011647, 24.874869628402987, -6.7710394917776462, -15.282582196159192, 8.4667854151177409, -6.5107925702216871, 13.411858617681851, 8.7705015794238239, -3.8910729473876033, -6.4523239325121038],
                             [3.373519920281848, -0.60541596289931898, 11.494554989256132, 3.1883407973798854, 9.6321411871700668, 2.1470084997865131, 24.964141453901874, 9.1009326898543534, -4.983519147222454, -12.701197504713573, 1.6373864540750447, 6.2417452797540989, 12.410436421528624, -3.7778099102407432, -14.872534323375989, -20.823280592015038, 4.2905043837377139, 16.761206128277735, 10.900173716924934, -21.476825343987048, -6.8087573508961459, 31.852720615068044, -1.3213825601674964, -13.064656295754272, 23.675739543300363, -12.751840404147281, -11.830069391202576, -7.1428379382805804, -4.8124736298617821, 7.989133591400746, 0.63876334389866818, -16.231414398220409, -7.1482314813128109, 0.84439146295742218, 0.69308220102361906, 1.6593856756273244, 6.124458058405077, 17.911588738297638, -17.663150039383414, -27.221221551595406, 23.497830985921418, -3.3373289386320861, -1.1149445410815471, 10.121890727933364, -0.43317590833789005, -10.077993017988826, 26.716915103803046, -9.7531431116076863, 16.888123601861437, 11.520362751175522],
                             [19.487886368740103, 6.7158407894841368, 5.0478989988167395, 7.4455480391260744, 9.6158991258440665, 18.184225718579537, 5.626901562171728, 23.073378787675981, 20.359930110837883, -10.642533938543638, 10.225800364608697, 0.46536942868019077, 46.398126317139244, 6.6958504829353886, -9.5794784345947743, -29.671928854381804, 12.743227307799113, -8.2380920368737804, 5.0152671057693547, 9.031509866383729, -0.048297018000804097, 2.1805938793493027, 2.872448348185447, -12.48315017585635, -18.77002202235996, 9.321674361311528, -40.458503557796853, 16.410075034499933, -21.833462061673021, -10.007793734475801, 7.3131923262901513, -26.159965626254646, -5.7154512382346496, 2.813895752989962, 13.153993911074068, 15.846798892160423, -3.5461920550722614, 24.92927149876164, 10.340325241855332, -2.7220963141891747, -18.736211909465709, 6.4958595553934186, -27.491872200199079, 19.937180052993082, -0.3818750011315184, -4.2012454790401108, -2.2582451785003359, -25.727060977670586, -0.23179511032233052, 3.0355626628021235],
                             [-3.6527319580870659, 7.2935053804182024, 10.306655044466334, 1.8866746806841035, 7.5499806056601919, -6.6016920355337998, -3.8117445019871372, 28.79360218005619, 13.585900464617115, -1.6148680747170909, 6.7262474675063695, -16.908627262486913, 19.763116635396848, 7.3028009165478673, -5.5339965851514679, -4.8682047939664113, 37.884106464972881, 17.173212477491642, -3.4823330265605597, -3.1632985522592532, -19.331876216668824, -3.5248413746785454, -22.81962800092354, 8.7939624582363649, -24.728338654184547, 34.323502375239883, 3.8596150430550931, 18.451179751827979, -13.953199523235723, -1.7219582953023851, 3.1647695945103758, -0.69088273344819839, 22.734155856280598, 2.0715670559537598, -4.4536414517121692, 5.9220941314236608, 29.200736201765086, 4.4637093321741768, 1.3555529284558907, -4.0183894526574804, 12.521905665960047, 11.620941789323009, -1.0207796601167685, 5.6418465587731381, -20.731584277881066, 25.52981617831221, 2.0981749316616591, -7.1392662741530231, 27.878657941978165, 1.7414620248251902],
                             [-8.5640146168033819, -14.234120318853236, 15.777133822231884, 26.481014303202585, 14.612064759841349, -0.094691757033242036, -2.4121586270122184, 35.52397451447289, 8.8544808180038359, -21.292385067273614, -8.5390413924612005, 7.9125170395210054, -5.8066259826335171, 29.769947149554721, -6.181445987439413, -22.839372974223, 13.479698944779605, -6.3453054827241608, -7.4905249367133919, -15.190877011216921, -18.898597857219777, 13.71780723386791, -13.351130849130811, -0.54791171929936444, 0.28538193958378905, 36.373292176851514, 0.56045865886424329, 7.4466188967705698, -7.6558801915998451, 0.88548648607782987, -8.227907168140975, 17.15270452719961, 28.445276606425782, -19.284970459878448, -19.400243627381787, -1.0607756289344386, 35.928649966590768, -0.1968571927689263, 16.815230972438215, -23.588487391917564, 47.746275706405804, -3.8484901848551112, -7.8068788939183573, 1.8288457754398897, 23.057992104573565, -24.151319487428196, -2.6331767466134983, -22.458345931782539, 1.3484988709071133, -26.782837863585783],
                             [-14.524672007439882, -7.3842392690913368, -3.2502174275487752, 4.5754292350476993, 19.923118949134938, 9.9212611872592174, 5.145872536754486, -37.899511014243018, 12.945008010826724, -0.67362012261540793, 29.008269648889538, 14.679397182115379, -3.9488948088606519, 14.861910018482366, 10.028749011138702, -25.938381474857142, 11.882669608917213, 20.877113453498783, 30.09032891439195, -23.757299054961049, 23.563776995395195, -16.214225042959058, -2.179206963623626, 3.2683745461237885, -16.914113119500488, -46.800844371027971, -4.4725003885047245, -9.3581367976949519, 28.234552168042438, -4.6275799010867926, -4.2450093018182562, -24.56165155269656, 11.083012551307739, 8.7091594118127649, 11.693912701313465, 22.735536528927305, -27.844038472969302, -15.612983319768139, -5.3024273417456618, 2.6708102359541046, -31.456435831021686, 12.020955903037978, -1.1810355509002055, 0.74742314094786588, -16.086720698404914, 26.400205585309894, 32.229476949781244, 23.899613182830649, -15.328946415821809, -4.3049074096639659],
                             [11.65686343165846, 12.941872884549952, -2.9147931655728208, -4.8368774133759809, 17.608350392919927, 0.7722311392579001, 35.191371573874477, -25.345625884577853, 1.327598639736326, -0.53285550934363912, 20.199794871436652, 19.190067410457917, -1.6434008517461205, -8.6188007103189612, -6.3832781295464311, -9.5857900939417124, -14.299233522453225, 44.169171577813643, 31.329157054498101, -25.631696268064001, 21.782581485202734, -23.553362969246752, 5.7430233041249217, 5.1219824062010844, 6.6182517169784623, -36.03796731245621, -46.944031270687837, 5.0882060645038552, -10.140802076159506, -14.381450306942217, -29.177329930160461, -31.200467563922249, 2.5820005944564923, 15.063462691940718, -19.479457223874231, 20.124834040458154, -9.5291386523979522, 3.6115083416303633, 4.8377956479492639, -4.0107478984202327, -1.9440331428847535, -7.6834180147435767, -5.1196416341239646, -3.6090746902589634, -7.665471195608867, -4.1072154073779776, 35.765492583133764, 13.485207689690515, 11.047089397672623, 7.4204807377803279],
                             [-8.4634678938602157, -0.82979403091725723, 13.75516460467178, 26.473649852199113, -15.334818414789918, 2.8101234745724653, 3.1541043464261138, -8.9084830854867239, -7.0840238412156777, 2.4437246029963093, 6.4965610505667399, -22.564977851388683, -4.7614493581315624, -2.7192404393517187, 19.334933762750719, -17.894322253582015, -14.171382279437969, -34.651530525109528, -4.78871413464688, 9.6974147940934703, -7.5196671628913521, -7.2314770024304842, 6.5687653893253168, -4.3054012121865606, -9.3308609602262305, -8.8017463671153173, 24.866539942265838, -3.1682239137517056, 1.0368148133750335, 3.8892040696622749, 13.053519193278873, 13.533862206613843, 13.609671672432757, -27.607779787456323, 12.14549595664128, 8.995802438311097, -6.591583108069532, -8.320004803861222, 3.5373596321294261, 14.067936502545081, 9.5416952135364834, -20.10709399238474, 19.456510183967243, -11.642705597663168, 6.8379583774723161, 20.913156020646163, -28.248172827568066, -9.5888698394436158, -8.9450595801297492, -0.35039329163773986],
                             [-16.099718270792163, 16.442496219740871, -7.4183851563806229, 9.2405154889668975, -1.414310600186041, -18.301101875750838, -17.67338290154947, -38.789722540863636, -19.686777961901171, 8.7463676774656083, 4.7092512906961703, -32.571063592852433, -14.675515506838869, -13.864649927788063, -10.326143649709724, 28.424473452505183, -18.243650698342105, -23.411275463180463, 1.6235150323430734, -32.481372861066966, -17.728201785995012, -1.5296245726497482, -9.5725357736509444, 13.068421706519068, 0.53972079048226762, -12.36487161336459, -14.654626009798427, -14.098716683383882, 4.6784671986392636, -1.6891763450311299, 22.434979595756985, -5.024054132076003, 8.5832214815846495, 12.12416063766972, 11.517683307572515, 5.3594472505045045, -23.027382190095356, -1.8873987711028877, 6.3678798760630357, 5.8345702975905587, 13.790880979732068, -14.339430900687347, 1.8326700015644453, 34.108134729180819, -2.6988128541646823, -10.965363760017897, 2.5677967322209811, 28.218404877070633, 1.6275497108366646, 17.068593837590239],
                             [-19.070107591648714, -18.361183703376454, 11.903342325657507, 3.8242888615329731, -3.3482365579147788, -12.242588758990484, 0.47637324458371383, -11.803618910323042, -13.780292138539485, 7.9731107579983922, -8.627719293019231, 6.5043002645129029, -17.985227510344092, -1.5791001075379587, -10.266530110604162, 8.4680547679312088, -9.1713666407059371, -15.702759278953899, -3.7430807723888515, 1.7249544635879221, -1.9587859894451682, -5.1907016169006797, -11.721829425513905, 0.81615798909062887, 9.5484856333031836, -7.3712356937837544, 29.643232288770715, -7.3803557637346175, 7.6741285471703122, 2.818448420823144, 3.3885782936563862, 10.269589869909922, -2.7579589721735047, 12.841740841956518, 2.7637258154587037, -17.795977438571047, -22.870980256077356, -20.911664121343268, -2.9870791586472083, -0.26693973350058753, -16.026461399760422, 0.41918521487702043, 11.528543854658464, -4.4963837897710199, -11.558743984099507, 20.315302972555866, 6.2687617467299352, 12.279901460647928, -1.9614673157848515, 5.9568713303477319],
                             [-0.13761774386689687, -34.708993112038087, -14.733911454936401, -26.191127656346932, 1.7497119746391259, 23.855652373671298, -6.1404447525444823, -1.10311119806483, -8.6055637550933817, -2.3885265677034115, -8.2621517176866117, 49.928528579913582, -37.12354488295378, 20.891966935018477, 5.4485714831586769, -6.7496762537295627, -11.028226329344603, 4.4225864108459056, 3.4382531596877426, -20.014376293658056, 22.638039297755899, 1.54133142217065, 11.342601168731978, -0.36784938320119309, 11.995441745652256, -25.86873371892214, -3.1061499825862549, -16.965979304910817, 12.204720059003984, -4.5234623293747056, 3.4277288274497266, 21.377450695559155, 2.9809471754324677, 3.4364913694353123, -27.105836188956506, 12.255551714207911, 21.549074895208818, 8.8682168291836643, 11.007929176510729, -17.114819153366945, -33.761133999854984, 31.31005179194721, -3.7861567098939437, -11.156286775786393, 17.781938035748968, -27.460297537713988, 14.006227982516634, 6.1521536575060027, -23.999742775919149, -30.187540557463397],
                             [3.3081007012189376, -10.488501885730191, 2.4986019441233962, 15.998585424882224, -2.6164016208428209, 4.7832097203085624, -5.9380620988131891, 3.5516929515862499, 9.9440890414697378, -8.9612968345805761, -4.0809084251843784, 8.5934059882739984, 2.2974534514935985, 27.657143985480076, 7.854354170979124, -3.1096784965251882, 11.037314769222599, -9.1689176602169056, 6.140577452361395, -3.9431460345705411, -0.90981674079042618, -20.590668823738522, 3.4373624300435197, -8.7322783267179407, 2.5120419181413109, 15.341777766694728, -44.874412315549343, 12.445384573761807, 8.3989583876641145, 11.32107358897764, 11.261266969599117, 9.6839351622493748, 11.35090035749835, 19.860985635605346, 1.0757585008095281, 9.8981237734119834, -2.6767330811113426, -11.408246303016915, -8.6517943431746254, -5.6499923825511491, -5.218985503253295, -9.1642971203790768, -24.657670703832228, 11.653987766819327, 6.3349457684662447, 11.813263612063103, 19.667390295081059, -10.990757828839914, -7.177366721424395, -9.0423144272753042],
                             [12.51440098920704, -9.9724897542168982, 23.932031682571992, -12.766065616342905, -16.967830129113548, -23.165697585010847, 19.372639086615347, -13.492544440422241, -14.071214264305269, 10.358731425649191, -4.9994396854944467, 8.3766458308862273, -11.884000194610996, -19.155649390384401, -13.161364722537416, 27.265291947559039, -12.872598489781613, -31.566491385563943, 2.3053746062415899, 4.650330549660894, 9.8892908572489304, -10.127039495073669, 3.2077072593746987, -4.7578489588117119, 3.2360849463873951, -5.1466653125410655, -14.941418107663313, -9.5966169022741248, -30.432806585625968, 8.6562457910613073, 10.431017528991806, 9.9877073456308683, -32.848794959525264, 2.5946273991314284, 18.305356462100267, -2.0964023518741071, -17.886122963355344, -5.2144447188510359, -2.879730454312786, -6.4202591260327946, -2.5154077901317931, 4.8659762147319254, -6.3686204813464951, 6.202480742405621, 9.1458357220952298, -7.5427944367700528, 4.4304974183246877, -6.040269844029635, 7.4085924174412687, 17.673832629792887],
                             [-0.13206622604003479, 12.709067052261963, -18.771974938178019, 10.76959818923428, -16.472671648075952, -3.7736520688530737, -21.590916351576862, -22.079653823325707, -24.244686128237053, -2.3155213235115997, -26.730154655108045, -25.1000697167058, -10.674272459171425, 1.8273545006877696, 20.156958353905122, 26.114908479433058, -22.375524489273765, -15.509512155760641, -15.009705861254437, 8.8481145748309551, -28.958730885141904, -5.1209487145605799, 16.69611603486192, -6.0310822896597323, 19.750812259055856, -2.0619431617067838, -37.443643587402512, -19.402618844845648, 0.024449619457046622, 1.4976952870921922, -3.1719066239901217, 12.987809826090153, 13.545158142771056, -4.1664359846035195, -1.2028747166440155, -13.135535357222139, -14.450432665042644, 3.0721394062264142, -19.371369768304518, 42.675449135511492, 16.88596313892263, -40.050282746929874, 7.1287757481116056, -3.1970763512404732, 30.364982849945925, -30.687239351616959, -9.9780083642460156, 19.063863481344569, -2.1638492337661988, 10.382980028692984],
                             [-9.4440217525611612, -3.1123323776594245, -5.7970738817501912, 41.923583068726252, 4.8952841970065544, 7.2519249413487135, -8.0727300194551894, -12.497185296778897, 11.780259262192201, -19.79444543771406, -10.279911846055768, -23.959146966922862, 8.2885123988799574, 2.1323570076599925, 12.785282566489656, -11.626137973462345, -8.19094606201433, 6.8741179081037682, 5.4424480263608075, 1.1878979963436285, -2.0772321289574265, -0.49305745750767216, 10.43805945836349, -10.770387121671826, -17.181588541814332, -7.9101849760801501, -10.298546511505727, -11.318494167725463, 17.924444467248637, -4.8615991848515829, -13.719929055016015, -9.4831129256231126, 15.395156575253715, -5.6582206156282613, -2.1477921425978974, -19.934812252285109, -8.6212451847897071, -14.025357704684023, 10.912955947631149, 15.789737401572749, 23.892184805647915, -29.451543943282125, 0.041153209889500081, 2.908194579013736, 2.3951336752772878, 0.25872866061351341, -19.469698063417624, -6.5437543881838236, -19.701954104894732, -11.495397504317259],
                             [-23.077423402132947, 3.329698223250988, -3.7708012624183653, 9.7886005739820501, 16.245861961387661, -9.6441541521827752, 8.1290388636313793, -13.968806260994196, 19.276915265703913, -12.900241615773941, 19.781034122402311, 4.0787512695673804, -5.9590569123221107, 10.100285059807833, -7.652063628430442, -9.0069408844803593, 4.4725607251277824, 19.865244638143047, 29.85775056385696, -31.650257400406971, 5.3112129630900231, -9.9036598504767426, -27.339288653341853, 13.311247761612343, -6.3120265526527355, -4.6119991045476993, 1.3726482063163592, 14.022515754292899, 35.761547008843145, 7.4020488440277177, -15.024150212852636, -28.340729659001383, 5.1464056759224466, 14.655949805724344, 9.76345654612423, 0.2344262561848966, -17.700341892629307, -26.041896729405156, -10.639675440622691, -20.283612448638824, 5.4006343870540219, 2.354918799132852, -2.8304307290033628, -2.4615106160988716, -24.262575103531084, 27.628667757288927, 29.2736523291744, 16.002032451027755, -11.074869112239931, 11.335998660747919],
                             [0.57592469171404193, 6.7322712390458372, -13.978864801155321, 18.667621029576932, -10.312148579233016, 1.5079636002762908, -28.361213943400678, -8.6040234957394457, -5.2829648933499742, 6.9073338985214026, -9.4279275610801072, -13.531824463541192, -18.944569840712798, 0.97088692568006463, 26.404104012354114, 5.6250078418906808, -2.126452559828357, -10.522666093469642, -5.7172504145801541, 12.552544294205365, -2.2530745304581137, -26.785501670144548, 2.6773848283129831, 6.4644502877909877, 3.7988309256309933, 0.53402383231331885, 16.555494158392204, 2.6265977541668439, 10.404151233616808, 12.409575372796494, 0.66244737020270494, 8.9350860293054932, 17.074017740007733, -19.320243075996061, 5.7368339630422014, -9.1586106536877558, 7.4391424295445292, -8.3849995317063239, -0.80613461142980125, 21.860363745005014, 4.4471162278019314, -13.048348748726408, 15.484739282803931, 2.0523724580286382, 2.7964999425946178, -0.36213810964491494, -23.204789983507784, 15.253539082770169, -13.969510106519882, -6.5304646185817461],
                             [-6.5550485000822087, 8.3330690501265732, -13.470553453303591, 17.279452266911857, 30.13674877366558, 8.2130951776852772, -7.7103814579862462, -10.488103857549113, 3.3324906297846142, -14.822802612435545, -5.545018264159042, -13.507401029430403, -2.5852634102646248, 30.094559374289211, 16.343275053216352, -21.232599556621636, 17.420967917098562, 28.543714237111846, 27.499924880101251, -32.828647765709789, -4.1018593513347144, 7.2825560825850664, -1.9399872802957154, 13.276359619289854, -1.713053735470937, -18.784743018532374, -40.72323008460512, -23.67089765064415, 39.323480609566253, 2.8894859908918171, -7.2829190557949532, -24.676289048482097, 28.868902619953552, 38.206710799079495, -0.67430110481219963, 5.543941636718472, 5.4793487424676464, -9.3375282010141927, -8.7727619522138802, 7.3066314098844742, 2.0862517255062833, -1.22015294200687, -11.435338574434899, 22.512265420928774, 2.8975729474615992, 0.41065613294432379, 17.9381569407659, 16.0008355732901, -19.39855108186563, 2.8520471506476883],
                             [-9.9867991935562976, -16.87871532538502, -1.8028416905226514, -15.405374613458726, 9.4419889208594547, -2.8154153764444398, 14.160882028599742, 11.304821688720432, 6.8809167792857151, -16.607869713881467, 9.0075485087824312, 12.948316047958663, 15.588445945558947, 8.1237840864774871, -12.227940704048606, 2.3852585983700205, -18.04787819595991, -2.1150415125312896, 20.722461573229271, -21.970076215486969, 7.7338920398711366, -6.3354666706549096, 9.2190850011682244, -0.033275809894582453, -5.7469004497408189, 14.911920653621131, -44.186863830822666, -8.9735816812671647, -7.0978213976762694, -15.282577214421847, -7.9401292054960377, -0.42920723979382192, -3.1142228865306025, 24.688454746256674, -3.1257302537980114, 16.139541072331617, 20.058384611985279, 1.8842096142554678, 25.128817167973644, -15.242381871524158, -2.7007451136268337, 12.495520139873708, -15.17119201417073, -17.94187308301083, -6.4199696296377464, -11.203567675086125, 5.6091144528796537, -18.610628860112516, -3.2915094052040921, -11.941111499779346],
                             [-0.39229166245731412, 6.6502988504019767, -9.5786718666052799, 5.7173388380124353, 8.3923885916815042, 10.010715917098565, -15.590246575033666, -16.346073244660229, -8.0753018613731555, 9.5341171847550807, 1.9148594824782985, 0.67214601465200297, -11.824225382810598, 3.5429258318753361, 17.383330807161236, -6.7475230948117693, 6.3309401271986285, 7.4594109532942303, -4.8313069458203026, 6.5294286514229052, 3.400971586702989, -20.803120317886052, 2.3175948145589818, 1.5575543548910646, -21.044961051534479, -26.998523357558625, 6.3966832497716011, -12.140250676569188, -2.5407324089006815, -7.7536731058336255, 0.81003535518056702, 0.3009891874876332, 17.414357641829799, 1.7348390653126073, -14.347559744561687, 3.5045483912158972, -4.1714824747511789, 8.0999749835768018, 4.5696948069398937, 23.857443949618258, -29.943602883941846, 16.388918113080898, 2.77141312038821, -4.5785077552236775, -0.29178036494355697, -3.2933994273234939, -3.9210726489819621, 24.915862006013946, -8.8023612312866941, -4.6115211815380288],
                             [9.3823284046816724, 0.30030596944492821, -9.5540437642043194, -0.12036106474313191, 7.5486970968316225, 16.234298036880226, -11.530705032988342, -7.3157844589983032, 9.5611281593456638, -15.510837759930778, -2.7339087839292127, 12.397639242567964, 13.970396094507754, 12.484943674496812, 7.407127148902795, -1.9708137450746448, -11.644374446916915, 9.2156822394422022, -1.9498370907034823, 11.900660501850311, 3.4984512429162167, 12.297931104644581, 13.025467149601393, -2.5198312874112778, -17.650243848499517, -9.244493069160912, -35.686921767019733, -4.958744290709487, 13.42096041352783, -14.834877769236506, -4.2506451157285916, -13.146510846587168, -6.9047341742854185, 15.493577941608237, 5.1288907558640506, 3.2175111958606171, -17.603067732722177, 4.2088197797463787, 4.6793510351098888, 22.354872779524189, -26.904778972345404, 6.2128505647837811, -22.727501882364944, -2.8534171576473586, 18.235898351090807, -12.14966236457205, 3.7099256054634799, 2.8584156603882338, -25.960377523245075, -2.5866701713763098],
                             [18.83862013555575, 17.782729197195149, -11.559620502170823, 5.0276829361972695, -2.4861434280822832, -2.5926173976830231, 6.1303149921998754, -5.9859824655461562, -8.0760203064146445, 11.796834921344182, 13.471022642465178, 8.6337557121869946, -6.7517987746950148, -13.931457324845804, -0.63931693521090227, 4.8949822456835248, -1.5980909360497375, 13.661142516038415, 20.839573385743471, -16.174943679552449, 5.7165719937914705, -28.050272684893091, -5.1404474568884586, 8.0618087607599307, 12.361113580678493, 1.9445595734840071, -16.200156070679117, 22.339920004244306, -15.822297703926017, -5.8409689462418699, -10.273025979862828, -10.003085947725678, 7.6740788995239697, -29.886291731887468, -9.5547523827793253, 26.580063711053043, 20.203669904456628, 3.3496939286752112, 19.542519423715376, 3.6004352766721208, 8.8701817852301179, -7.7174659196134447, 6.8898933019162349, -4.5446118692283139, -5.7318101791101697, -14.965487811456468, 7.1879628593364702, 14.174877177142088, 4.3430206357520946, 1.521967232227271],
                             [-10.319503135143577, 6.988485149807425, 13.742962209860991, 1.9518326848156911, 10.286626540497641, -20.80398688703162, 12.733963999190809, 11.412184707883487, 21.615981129917799, -6.0243100319711838, 3.1676341892274853, -14.487772189745346, 13.545443335977499, -3.805065467269285, 0.46477462675307474, -2.0501682049952819, 14.348210650929031, -2.7787887123368806, 6.813109080632616, 20.566076968894933, 7.2397260750255672, -0.31952882149930023, -10.19283454866096, 15.496134453454731, -6.2489002315492108, 17.761725777635629, 1.2369296717984986, 3.3491432100882577, -3.92616518389775, 8.3955614992641721, -24.590665428107879, -12.752729575453104, -10.570839037894945, 16.823903835789654, 23.590778963342196, -19.038610173914925, 3.888773573325961, -20.990194563809936, 4.5727916995372597, 4.97567818195553, 22.507530497220174, 16.725820774371606, 6.5430640926695371, -12.368691462633985, -7.2186735555247932, 13.985170732884056, -21.966436210733157, -24.041017161939919, -1.3746649639272843, 2.6178465267751023],
                             [-4.4242657306482416, 12.148258457156123, 14.366750664654605, 14.103070183226494, 0.87265280216587393, -13.1194900457137, 8.3230801501628662, -13.120747953316044, 7.4939623400523798, -12.994007105817222, 1.0213324454327957, -9.5408888260726652, -3.9978596778734357, -17.843916663942366, -9.6064678249979991, -1.0239687456096289, -21.226516821990522, -22.150278036996959, -9.2992379735360711, 19.703207511885463, 9.5043012718602693, 14.32196826897013, 1.091274399393988, 2.2721705570221555, 6.495601353068901, -0.42291205436107354, 16.705457093649049, 7.129987397620142, -23.485255219626019, 14.832089283384466, -6.850946074854865, -2.2204584486949419, -8.7831091583210519, -9.9747488048153592, 4.7539625597193709, -23.417308360558351, -33.256180273691712, -2.2971993426516142, 1.4859866050217343, -5.553877769644691, 43.39146642139211, -16.37334065392389, 2.8590313783572823, 10.61517005608945, 4.6910531967600084, -10.034464243540679, -17.780838203341538, -16.664935008550792, 1.5881555639112719, 1.7420494767568031],
                             [5.2041039212797751, -7.2855824310417656, -15.457042383973828, -12.962557853669677, -8.8624109991414723, 7.4093662186201934, -19.129799493623235, -15.577605010967471, -6.1833547320446138, 14.537473730348271, 3.660431820602168, 26.762843760219916, -22.401469654682071, -5.1024603745220194, -9.4317817772215093, 19.930668366482521, -8.7210370738645917, -6.1277788474375141, 3.8828748645174525, -1.7048853691513126, 24.484653432552488, -8.4173511188328813, -4.6585992023931375, 10.073499038698587, -4.6491526807368766, -18.614515688051945, 10.010630840201259, 9.2016896448006946, 7.3367799159180684, -10.278288733587333, 12.528385749950292, -7.9926715907417272, -15.643500171410141, -0.5956214187635116, -7.7698902177308478, 2.0758174899161324, -13.623972689491627, 1.7842085177012967, 22.041544150603393, -2.8030012211173418, -38.051258579427575, 17.531443851747255, -2.2776017996826146, 16.007050517348354, -1.1097391762265996, -11.234346639301569, -2.4547854025093039, 15.167159913617345, -26.979793809873261, -3.3539153195114904],
                             [-2.2461805824976508, 5.8501000365678619, -8.8841115358257223, 15.265526754549381, 5.6034098209127849, 9.9763061986494765, -24.313376154064265, -7.0856371378837295, -15.341031901030242, 9.20353004299721, 11.311191646067364, 2.0880285796842517, -9.1305858583497361, 12.300112047144886, 5.4622183848767518, 6.4185153966289725, 13.92156627077693, 5.5540113531457456, 9.4934724320132542, -21.64878824327279, -4.5767917339813105, -11.229244967191315, -5.4277647358406487, 8.391394225008483, -2.2069017691124357, -8.7891576708264676, -9.8772898941188991, 4.4167863870557547, 2.3442995172695169, -14.809970087656534, 20.726227843405212, -4.0194339882825645, 20.045204028095839, -7.1174327903015753, -16.328422311629321, 25.974167146737599, 5.8967698309027536, 8.6635476970513814, 18.505768673411136, 7.9866209877158756, -18.856667219790591, -1.0309641675781149, -1.1468549190124901, 17.469825126812253, -3.9012183668446956, -0.59864078017641664, 14.243840359795545, 22.583790886900186, -5.7628696675595323, 2.0741185742662553],
                             [-0.65550511859936522, -1.0829778000715575, 15.075201533036804, 0.53846355128499179, 0.36844917709446134, -11.328814065601051, 8.3696470941176031, -1.7137146247058315, -18.472092954168936, 14.787709994367216, 7.4362655714045056, 5.3679587290272419, -7.428371756392834, 10.778613940890066, 10.099222238309094, 1.906099639076043, 14.308238559266199, 1.1732466453072705, 5.4324713393450734, -9.1657774149312061, -6.4069296788085515, -16.109509518632652, 0.76138231290232861, 12.157258224830635, -5.2722760202395316, -11.513684564175684, -24.478011545071489, -8.0118415437230155, -8.321313989009365, -2.207364942593657, -9.2847906433359455, 11.799772113145865, 14.254867974224998, 16.11239830741831, -7.5644494241421842, 22.29509622389557, 2.9963646755177318, -10.666784787125774, -3.7532544320046379, 18.300388111069694, -16.156224215192896, 5.0062893615694248, 4.6523893394229399, -3.8692829746761808, 11.858044519126683, 9.4844445956895971, 18.055428389080816, 9.2415974998273818, 6.3532739345530489, 5.2068147763863086],
                             [-9.0073267481888877, -9.1966521572216582, -18.521685835462236, -7.6870082224546756, -6.9484404373574744, 14.764242993420627, -29.674056070637054, -11.959693596274708, 13.706494077157524, -9.7196461700660812, -2.0617702933344937, -9.4048652839935443, -12.845274844267619, -1.5489761753362319, 0.42957555925879409, 0.7380265575124082, -6.083091941192599, -15.126150606507771, -12.274524449806684, -10.641354908921473, 4.2821745450301281, 21.128326580308229, -0.48877957928484334, -1.5030582916169126, -3.2494693467666154, -2.1974016486295671, 30.998410663674466, -7.5864305900445022, 25.555129720898236, 13.603710812017679, 27.187016380297088, 4.2694997597936331, -7.8275989075335772, -26.155905851213596, 25.664054632660104, -7.9505475366850762, -2.195146069176976, 7.8848939189972356, -12.090679566453124, -19.785736337287624, 5.1808518526703065, 4.1569420011590097, -2.5974391311588949, 21.667602784196959, -0.15210519164157343, -12.168927927936195, -8.0937327778786585, 13.197658586782206, -15.055894827166762, -8.6764872538685012],
                             [-9.2849159764099092, -21.704497579491623, -1.7385203094980952, -9.963013334604609, -4.1964203258818022, -4.23748287716443, -1.3788254452645601, -12.293270635869312, 18.71086567314935, -1.9809989381125366, -13.052339043078739, -4.0738394763456656, -1.3810392305551902, -13.04391797896735, -4.6304511962894725, 15.886447052999657, 13.403642628779604, 12.068524640057596, -2.3960072903182748, 14.871408230142395, 16.859626479091595, -9.0051290146625256, -3.280863670372046, -1.3361245007407077, 2.0828900129634507, 3.2333820839546443, 15.814878976309872, -0.74623026128531322, 24.453749259139027, 6.3181810383003265, -4.6569638315819173, 0.32595434861985084, -19.581403544145971, 23.327894108824832, 20.258066632270417, -27.479371822690666, -10.522019861446076, -28.188390134647982, -2.0448653467037903, 0.29375410508663896, -4.6711039889194534, 9.9912100858639494, 4.5098828899050192, -11.991444604472672, -22.362660486217084, 34.163164718543392, -3.6226636258579412, -10.682883013857635, 3.8461516756834913, -1.8340718728371297],
                             [9.1319054309135037, 7.6438252361652816, 11.997567724946132, -4.8159013997083591, 6.7064255743233154, -6.1792715248110381, 1.156781191366429, 18.680625909611486, -4.8718517785845803, 0.85384818566387277, 2.6840346146445673, 19.518721994242085, 9.9650725479935982, 23.611464150427036, 12.856729181395696, -14.897154039394385, 14.4989105400621, -3.7100367053518046, 8.203456915600734, 13.657470103504169, 5.9699905516938658, 14.164454052097092, 7.8246293341611244, 14.33748352792343, 19.545475901784208, 5.9431549881573078, -8.0227943214800153, 0.74593232203780269, -3.9210033043740604, 6.2918760715442508, -1.2288905700469568, -0.16241275006595696, 5.1610561028356292, 8.876758676729418, 2.5776875878750181, 0.67002570364017899, 0.93108617454864717, -6.2783595969961175, -11.515715787108988, 13.597711417814478, -12.416767931870922, -3.2974787303429891, -1.6316269796526277, 4.9353556222629278, 4.7756130855959213, 13.031006535996731, 1.4964330489564652, -9.2742422836811329, 0.60978532659916485, 5.1865427156058139],
                             [-13.565983519539639, -26.84073945963685, -8.4828909262030212, -9.8143759479809916, -12.908330419499723, 4.2898236677710315, -11.081207691870752, -14.148311002191491, -5.4816458174865232, -9.6416470029292256, -0.91519814347435458, -2.6614220673009412, -6.0613006635302522, -7.6980861432950594, 0.32625853588014531, 20.740974473445082, -9.1717329196847377, -7.5728715887495319, 0.22255185358431742, -21.015689338117337, -2.4045703789404271, -9.8987638543829171, -2.2556969332057197, -16.267643726738566, -11.542661929014736, 4.5194573962350582, -12.50510841016156, -16.790402836448038, -2.4532116338292531, 2.8669847806978384, 7.2128604627818422, 15.110072848492527, -8.8839192832511582, -7.0864794986959883, 4.1005943634368842, -7.4894887178960632, 5.4645712379827085, 14.726175318217804, -4.7349699554556084, -9.1326908868643155, -13.99049965656538, 2.0920411096362086, -8.2620529382220838, -9.9992899667104727, -0.4353689073572018, -13.930222851718247, 11.349757216543713, 13.013781733444841, -0.5643862053329789, 6.6976640945365293]]])

    sigmas = [1.0, 2.0, 1.5, 1.5, 1.0, 1.0, 1.5, 1.5, 2.0, 2.0]

    lambdas = [2.0 * 5.0 / 32.0, 5.0 / 32.0, 2.0 * 1, 1.0, 2.0 * 5.0 / 100.0,
               5.0 / 100.0, 2.0 * 10.0, 10.0, 2.0 * 5.0 / 60.0, 5.0 / 60.0]

    biases = [0.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0]

    def __init__(self, num_variables,
                 matrices=None,
                 offsets=None,
                 phenome_preprocessor=None,
                 **kwargs):
        rastrigin = RastriginFunction()
        weierstrass = WeierstrassFunction()
        basic_functions = [ackley, ackley, rastrigin, rastrigin, sphere, sphere,
                           weierstrass, weierstrass, griewank, griewank]
        if matrices is None:
            self.matrices = {2: self.matrices2D, 10: self.matrices10D, 30: self.matrices30D, 50: self.matrices50D}
            matrices = self.matrices[num_variables]
        if offsets is None:
            offsets = self.offsets
        self.hybrid_composition_function = HybridCompositionFunction(num_variables,
                                                                     basic_functions,
                                                                     matrices,
                                                                     self.sigmas,
                                                                     self.lambdas,
                                                                     self.biases,
                                                                     offsets,
                                                                     2000.0,
                                                                     name="Hybrid Composition Function 2")
        self.num_variables = num_variables
        self.is_deterministic = True
        self.do_maximize = False
        self.min_bounds = [-5.0] * num_variables
        self.max_bounds = [5.0] * num_variables
        bounds = (self.min_bounds, self.max_bounds)
        preprocessor = BoundConstraintsChecker(bounds, phenome_preprocessor)
        TestProblem.__init__(self, self.objective_function,
                             phenome_preprocessor=preprocessor,
                             **kwargs)


    def get_optimal_solutions(self, max_number=None):
        return [Individual(self.offsets[0][:self.num_variables])]


    def objective_function(self, phenome):
        obj_value = self.hybrid_composition_function(phenome) + self.bias
        return obj_value
