
import numpy as np

from optproblems.cec2005.f15 import F15



class F16(F15):
    """Rotated hybrid composition function F15."""

    matrices2D = np.array([[[-0.9806679026163108, 0.8744899827980259],
                            [-0.28305343212539197, -1.7870194429065596]],
                           [[-0.9046107000082309, -0.9862823010418286],
                            [0.4336833027073122, -1.7380579671101688]],
                           [[-0.33019690746609454, 1.8816102483979849],
                            [-0.9439727248711584, -0.6778114561755524]],
                           [[-0.8712410582715097, -0.8861378373125983],
                            [1.7998721771129138, -0.46492891684612514]],
                           [[-1.8641378080645454, 0.7213269123874739],
                            [0.3058569983553298, 0.9545308871728218]],
                           [[0.4293493348185146, 1.610324407517368],
                            [-0.9316845781555064, 1.16382056094225]],
                           [[0.38827401443387904, -1.8686445648127552],
                            [1.1295901001178172, -0.2853716626208165]],
                           [[0.050092258513237314, -1.998804473124856],
                            [-0.9989361188012238, -0.06631797951882186]],
                           [[0.993863570468612, -0.28982010876467956],
                            [0.9659142572931896, 1.730678813474285]],
                           [[0.937224298267407, 1.3421150262007286],
                            [-1.5225598663899629, -0.04636080717547275]]])

    matrices10D = np.array([[[-0.46605036586178061, -0.93273298363879986, -0.28750049522576415, 0.54868620340860819, -0.11596255051222526, 0.17617814270680499, 0.78574714200678186, -0.26158548081069677, -0.078134807549336577, 0.67068614539234306],
                             [0.043184827118503466, 0.51839667485869623, -0.37485789525484403, -0.53507023460824998, -0.45251656267436224, 0.040636183788202496, 0.23426663004784296, 0.47235664647722952, -0.73803779694282101, 0.72705649839778796],
                             [0.091281394518130568, -0.24104315581220925, -0.057590095364686893, 0.68959162093120507, -0.88144466837618907, -0.1198254316253496, 0.052493155808604607, 0.42220889927410654, -0.050830415354339936, -0.20083581090441407],
                             [-0.50065102423192509, 0.25503715805592425, 0.34196452998226368, 0.96392884720444605, 0.32167928285153335, 0.50508998077764233, -0.41060318890693481, 0.49162486582649506, 0.0067301746431515097, 0.50954331975619171],
                             [-0.81901713459380698, 0.72226628427331008, 0.02515159431193463, -0.13830315886838454, 0.096529270402689882, -0.40160579833930321, 0.99761392557718387, -0.24949883115280705, -0.06821065260133452, -0.52801835756250948],
                             [0.010756226451531736, -0.055937235962734359, 0.14604461219495313, 0.66993039841913871, 0.17179882448243106, -1.0008389762872434, -0.16776824331148588, -0.39288179056755285, -0.49774801511913302, 0.40765803848007248],
                             [0.74491591163947646, -0.20565946813467342, 0.082430232060983516, 0.33317454798369961, 0.53399053400823582, -0.46871645951386559, 0.65125551859136421, 0.80306874992897193, 0.31321226754828241, 0.20154028051140696],
                             [-0.23092524037239281, -0.10850263211931353, -1.0988741274048319, 0.026126509773343791, 0.21586427714660583, -0.47341723626764654, -0.34358611485029611, 0.1402483830209913, 0.37835892604740867, 0.35042532531545945],
                             [0.43296481126531572, 0.77409767963782872, -0.025416160685651355, 0.12369736637628995, -0.48670365209184657, -0.11477176526871864, -0.054846548540451012, -0.66591978287611131, 0.50745912962583684, 0.36312494109074295],
                             [-0.55924303909349127, -0.2551632752226396, 0.51045561460740085, -0.27159294108562981, -0.66270909909572329, -0.65598248134507042, -0.19614707346338289, 0.4084972760119871, 0.84294059439400892, 0.39618779693190159]],
                            [[0.36494256103449829, 0.30019871125063602, -0.24201888625936779, -0.43711192327044146, -0.32305487225473539, 0.3211358563084985, -0.55795069085534399, 0.25724007545879746, -0.91274825764538059, 0.92445674485507645],
                             [-0.041140238808236779, 0.26059776689639297, 0.40788630500221751, -0.36507022350204776, -0.72131650629291855, -1.3020351765213976, -0.072517141595473358, -0.14688555313722002, 0.041851857495807054, -0.50551185790055841],
                             [0.5766541433141138, -0.0059175932787681584, 0.53451236332867946, -0.83731721239501544, 0.29952229123420182, 0.035051107518188247, 0.63922534190842673, 0.92091493718304152, -0.31481505996721521, -0.38232300838975575],
                             [-0.46397518837700774, -0.37578755758045523, -0.13806474727984341, -0.51302465870576552, -0.66624684834054393, 0.27411540274311669, 0.54867988315646909, 0.21909502971009434, 0.036434932737861414, 0.61781482751059735],
                             [-0.39688238322387848, -1.1388591639518042, -0.059640391298446706, -0.53084175289065394, 0.25553644215717808, 0.0505597797028801, -0.74751567275492181, -0.40190831698744889, 0.094707758849067319, -0.19421032330849808],
                             [-0.52050033358149972, 0.11433140097211882, 0.79518030235951132, 0.42217700882200337, 0.057109680519354222, 0.040656481661338326, -0.62856647917985076, 0.76725463873939437, 0.20210335097404858, -0.27408629709647403],
                             [-0.24397480573821659, -0.20113701764330025, -0.080891163103902861, 0.43693587705295289, 0.57452538386479191, -0.83484082128410719, 0.076658172394313689, 0.53688504356059585, -0.42085198746314711, 0.73009993809464346],
                             [-0.062926773829173388, 0.31825659206456813, -1.1130080224171057, -0.6191922296959923, 0.38254339407649607, 0.025487027184336028, -0.40404496409468227, 0.45040305145810511, 0.70279674959484106, -0.17329186271802588],
                             [-0.55245342472175674, 0.17115891892532237, -0.60410187974668039, 0.028720670739119714, -0.10516148203094819, 0.014062146416686155, 0.10830413855215568, 0.24035024408493516, -1.1875418770121924, -0.6265511636303227],
                             [0.58599629483549986, -0.48305384675508423, -0.33900952802296991, 0.62168088162447088, -0.26577173296353285, -0.30401843536788181, 0.26030979637007695, 0.54331268859866322, 0.098616224942653707, -0.17646620322359646]],
                            [[-0.55667525239571902, 0.5401489390907892, 0.41070546222568532, -0.30243149160792504, 0.51169839839900322, -0.7636385179936318, 0.62998238567671094, 0.019399684594230519, 0.34055997745767669, -0.18176742494304424],
                             [0.063235712210558917, 0.048164161732423522, 0.35263973879291499, -0.26595682653799901, -1.0823337688778916, -0.158379082209754, 0.74597500212949508, -0.13806948172433836, 0.60904156381326935, -0.17015515559419409],
                             [-0.35258543073656867, -0.59825568057004208, 0.13306425544016653, -0.23594610421559103, -0.3377157693499403, 0.20137335501365294, -0.52572603362497528, -1.2446866288288703, 0.513063948140005, 0.22045344281059076],
                             [-0.6145813156187101, -0.57931170696103529, -0.098902483403974117, 0.13960757157147397, -0.21445438388151433, -0.59621745707434948, 0.32430006245954451, -0.24074236026487283, -0.80284673704927123, 0.67771785948105157],
                             [-0.21371274926551415, 0.51701860819711198, 0.89971434612032486, 0.46449072420612603, -0.20683890228607021, 0.10006185820015916, -0.70153842799040556, 0.27340260561511831, -0.15244767543987336, 0.40194533840331448],
                             [0.24365420444404895, 0.075692047603160825, 0.86421859241461252, -0.85522022915812501, 0.073251489690338095, 1.0449612810935305, 0.56730223326946094, -0.10654654325344751, -0.39831696327093102, 0.22633895367119256],
                             [1.3002620198665942, -0.037856355495594386, 0.56406506993156114, 0.41724266806247945, 0.64576080433256355, -0.60304212387047251, 0.16468365402443202, -0.55578042537411998, 0.052601944563021391, -0.013038528811209526],
                             [0.1710169444952061, 1.0039548943409995, -0.63168356033707029, 0.1966567385089498, 0.149613040164291, 0.29946814090376528, 0.1947186012167462, -0.90517444165260397, 0.43968792569880832, 0.29287482329131515],
                             [-0.72628677814479947, -0.35477435685676595, -0.083265164951644044, 0.98047175054514402, 0.56000113337603197, 0.53078543125878141, 0.61616744679507396, -0.23994599138104211, 0.088580558733374004, -0.11498957125942397],
                             [-0.47516578952903193, 0.55582596904244364, 0.2062633816798988, 0.11828907082380805, -0.13437197574872717, -0.10609961816764693, -0.15852377141308766, -0.79297478262807752, -0.4752558730611296, -0.75882927945698375]],
                            [[0.11620208325924819, 0.043364081016249917, -0.04947455073922577, -0.77150998198874365, 0.60416544743958167, 0.43926329352678112, 0.1283261526265313, 0.21845202770193564, -0.51101080441179614, 0.039729228031692237],
                             [0.53650059712867615, 0.51365658266510117, 0.88147502047432624, -0.23437291156690634, -0.51192316844821673, 0.053675594566323405, -0.34408498508150331, 0.18259512295971048, 0.74756093875747487, 0.59571860730018111],
                             [-0.18767306257313313, -0.26090962154577568, 0.28168450492612684, -0.2418592994408876, -0.091274255193067769, -0.12002002702125311, 0.85518037075379716, -0.15012627975056189, 0.170161587099592, 0.20774271910102468],
                             [-0.11548261387375003, 0.28664038663089275, -0.33110452250013034, -0.55948826681386443, -0.95807172948593877, 0.39193243585133963, 0.083587637272619572, -0.60618457452688301, -0.018274442541769964, -0.2235534702394667],
                             [0.77273151768953063, 0.058080652995036598, -0.068377192166069981, -0.21169569560633936, 0.086934545413009448, -0.51287253007140732, 0.24670164056919486, 0.29818171234173424, 0.32972643987291184, -0.96889226549002849],
                             [-0.35345196220264813, -1.0349970432421829, 0.26280390382669611, -0.12252468874311874, -0.44275860272842155, 0.2344271800381458, -0.19761961002101863, 0.68965470590153066, 0.035082546272540788, -0.16174281576813215],
                             [0.69357825715153032, -0.64332476477280065, -0.24060216004851109, -0.60082362228527531, -0.12123835078872691, -0.41076031285401415, -0.34448181081102636, -0.41274472353375624, 0.33286416203073216, 0.65722004626288666],
                             [-0.46159218244496802, -0.057149941586003374, 0.65313068683593345, -0.10494406899217548, 0.93369203240884624, -0.10271289957677311, -0.54995611373545272, -0.52447450787677918, 0.7112391943701506, -0.15765282420735188],
                             [-0.63034255054735233, 0.58312108317973033, -0.21499779173263173, -0.54770414735271322, -0.21486931731351019, -0.74794882480035418, -0.11824090389009689, 0.88045388710123318, -0.22475525582565126, 0.047711471825192808],
                             [-0.28945579500689333, 0.225415358423077, -1.0658380713982405, -0.15178051229011311, 0.073427863019191492, 0.3859476194330026, 0.11382640756472698, 0.43015951679067821, 0.53880684621282593, 0.5267833395099375]],
                            [[0.13236182472210031, -0.61508336164493604, 0.32930471405054546, -0.68931279655293753, -0.78797482505603633, -0.43059984585757183, 0.59842593591456794, 0.028626620118702251, 0.36169343154465838, 0.22062053660128092],
                             [-0.51953088497618816, -0.095388564169948425, 0.019763296616852874, -0.74007548366612252, 0.4732648771234863, 0.27539856854622496, -0.33865426306474045, -0.72797498576478648, -0.30397160083290198, -0.14932315248753236],
                             [0.36859712353423091, -0.24673189157334555, -0.15904112578669211, 0.11655309686744986, 0.4073732410857136, -0.3193245552588943, 0.59584965161950409, -0.34588108304143811, 0.75525013293470233, -0.35181453957699121],
                             [1.1322714132973994, 0.30849131296190674, -0.23178265133776305, -0.55073068106919965, 0.1186138281358747, 0.53155681237443542, -0.14303414825071725, 0.41432668436734987, 0.39757147823300953, 0.18459256032838053],
                             [0.070002063157763583, 0.68064774228116354, 0.093181431349393051, -0.44852006182588944, 0.035500200428409609, -0.75002413033023174, -0.15461879571532547, 0.16200085476754386, -0.2925515688702871, -0.32088796120969165],
                             [0.20500838408292499, -0.32709549285313022, -0.28189645703138416, -0.29760552310040833, 0.83904851778171952, -0.030821998752321979, 0.98813138051628469, 0.75036286593469292, -0.41486718880777396, -0.27840684339083183],
                             [0.53762325667974475, -0.58431161982653801, -0.4664449390002936, 0.83801113011295114, 0.25259789035380165, -0.66382346955588389, -0.43266626831169475, -0.22185831312957163, -0.18507135688337698, 0.7631239157001104],
                             [0.081648653204914351, 0.3328728782718815, -0.12723044291875116, 0.10341536712667648, -0.42683430214540752, 0.0018402543003205041, 0.71213188418159612, -0.47127899711461319, -0.86272626594951396, -0.18858474743274334],
                             [0.051317304423016324, -0.89066988269567815, 0.16219622415402629, 0.030316835219003621, -0.18559123109262984, 0.23179228424734377, -0.19471755677584535, 0.065994648707656769, -0.25784479132737925, -1.1012490235098968],
                             [0.28686009123250605, 0.15037938197612344, 1.1733893086911771, 0.2657599608028518, 0.1010493789833781, 0.05831729265993045, 0.17629677529045046, -0.048790543039833267, -0.7507143610771061, -0.037691298858456651]],
                            [[-0.61083416210982155, 0.83744467637668218, -0.27999461357171013, 0.31070382338862046, -0.16971894166539073, -0.26901708510590144, -0.016718342836127796, 0.03857013993128032, 0.4056965500325061, 0.13506473670622032],
                             [0.045655569500789001, -0.11185218780504862, 0.36332808542379696, -0.28451889642019479, 1.1910740787114618, -0.52999945492209388, -0.5832264111314005, 0.025065972384580831, 0.38065418921869826, 0.072363673665698736],
                             [-0.25268927449524153, 0.057166150146662154, 0.11816535522386443, 0.37026900580860961, -0.42529682132995122, -0.48701585610961062, 0.2309465155927414, -0.70626380682645462, -0.35064114576196115, -0.81717349792567595],
                             [-0.52636649565708316, -0.50675821487565231, 0.34989315895036671, 0.72260296889509179, 0.32332737600877987, 0.0478682719030607, -0.6929834875870442, 0.4794206802931027, -0.28987982612511032, -0.56669239322823672],
                             [0.32070356797971172, 0.4426657679437645, -0.88978694778612355, -0.1642382838964315, 0.30825829444669417, -0.22333988453978806, -0.056929697572502221, -0.024069619926022683, -0.78863110927815561, 0.70333658334763338],
                             [0.14033530255730703, 0.48235457475232485, 0.71545409400805027, 0.34306813399429231, -0.26421881436826405, -0.22141361037636309, -0.11639831484704097, -0.078293889312115117, -0.44371662706030363, 0.53740707463157378],
                             [0.90314419113355238, 0.46276469579029816, -0.091930289724216269, 0.057491366394444958, -0.24778228189986912, -0.37003725956923289, 0.036949811618863071, 0.9148251920141941, 0.85156463364874946, -0.65723082820958711],
                             [-0.19902960760942062, 0.34623527945052535, -0.080154974875789209, -0.80609574399938544, -0.26797594878826314, 0.058757305887701859, -0.75604192828183203, 0.084837178212067654, 0.031141514094605798, -0.52049002148661194],
                             [0.83397701417260584, 0.48265350208883767, -0.016459707279187587, 0.87547095316373835, 0.52581938766748659, 0.96111294838297812, -0.082409406910490063, -0.24450937537577927, 0.14619991095085383, -0.23259015978081529],
                             [-0.044771761943366711, 0.31265218345629797, 0.19027659960378801, -0.40665728196885581, 0.56963056912144738, 0.17576472457047054, 0.64958821085494156, 0.40357365787313348, -0.33149282249881928, -0.048201952270594817]],
                            [[-0.97909554389504694, 0.48056496130199444, 0.29298572197522454, -0.033867592042210112, -0.13115876174113372, 0.72279697353438377, -0.27266511151267009, 0.29886604980283504, 0.05329316386306146, -0.24920151201694429],
                             [-0.28774188310884324, -0.08442867485446208, -0.2213170794168573, 0.015176978952324005, -0.43485608508532414, 0.21239437019614871, 0.76503106138048305, -0.49225561188162142, 0.73389002500271383, 0.11693963912019614],
                             [-0.30343058018947233, -0.9720309835766181, -0.16116698897561535, -0.057652293498180004, -0.24063391663761924, 0.37076002518839118, 0.027176521103881537, -0.077484909866930046, -0.39408298376377043, -0.13317683500259958],
                             [-0.28254126138495483, -0.31153899732812756, -0.716074017827522, -0.55933039331264522, 0.2922000129962522, 0.62737850709026544, -0.2766621009256891, 0.28329430777351677, 0.67891463622945636, -0.1486271683284176],
                             [-0.30778722113445883, -0.23397718141574811, -0.25208183922087662, 0.93865150253026786, 0.66254752450732468, -0.27812183964271148, -0.21878748776155993, -0.61433700031593708, 0.59066108046640253, -0.049981868378399928],
                             [-0.27665230264861707, -0.11846542291452339, -0.37891892943255184, 0.35963915561803206, -0.63920265456293501, -0.627124217350017, -0.29169374351906041, 0.41271475076787134, 0.23122621405342725, 0.16436761853170881],
                             [0.23561469510151375, -0.062076011541034953, -0.43092757281742805, 0.33129601505969203, -0.11547995647981099, 0.20663714032875657, 0.46267020436034678, 0.41107282244189491, 0.22497924282506343, -1.0003039079207869],
                             [-0.55310294494363343, -0.34147956667908419, 0.58922391188451184, -0.58020536850300919, -0.011371642044469596, -0.2445855735599623, -0.092311760074279658, -0.057556610740093696, 0.54837845521972739, -0.86307897742313089],
                             [-0.68362013662037668, -0.17995461478210889, -0.2141367863668189, 0.060271353185497159, 0.75722508499197905, -0.29849486612096321, 0.7224602011205743, 0.42251599365611786, 0.10292722507646859, 0.25673650513570695],
                             [0.27729735198696326, -0.60985223838485958, 0.52350211760350385, 0.43972402646819164, -0.16355628377814893, 0.45831596012617948, 0.1044609259561923, 0.44192624084345616, 0.68053336422203059, 0.08817972699639702]],
                            [[-0.15854447291690374, -0.47187899084493296, 0.32033732305481494, -0.0095511017919231427, -0.44935057743593787, 0.028632768362711333, 0.47004740825836877, 0.24915020704131952, -0.49669253229951854, -0.91114239625657201],
                             [-0.58505933628748463, -0.449434004268217, 0.2117345080532371, -0.29623764288515603, -0.77353195455107138, 0.1449563101747959, 0.41297715765130893, -0.14749841821185156, -0.094556120813798078, 0.76305895679078406],
                             [-0.32369950034269057, 0.14029206786847001, -0.15805980501438716, -1.0287608135590212, 0.29217776698078046, 0.08350719370424764, -0.87273400738186435, -0.0030652668860372614, 0.0041076603523461652, -0.20783261742442533],
                             [0.29621825791875811, 0.027735600759277675, -0.56287042164402123, -0.18579570015584185, -0.75586154942399253, 0.46256582100507532, 0.71977633831560306, -0.35627265970686556, 0.38584627680383771, -0.25782235281179133],
                             [-0.59288052025521332, 0.76592758761856905, -0.40071714671539405, 0.47775723111523655, -0.63629615413453344, -0.68771879732996377, -0.31103297663160501, 0.088350964256069753, -0.32843758184967015, -0.39637215217789412],
                             [0.98156986133078283, -0.25384775912483909, -0.29287312452857683, -0.12936982547710699, -0.15309454704193171, -0.90982968610720771, -0.03428135921190395, 0.042081235738840213, -0.46505993820221736, 0.2850143364941749],
                             [-0.26515807153302423, -0.38799463114234101, -0.025372534580278161, 0.20207341453412694, -0.23769043773695192, -0.81567724864201396, -0.15242512989324658, -0.22419127176906797, 0.69398738651937819, -0.53669046313728341],
                             [-0.18240903415892681, 0.68119922040121372, 0.92150746285071305, -0.22074958021977584, 0.15969109427448874, 0.24280845378329791, 0.0055217363961419519, -0.7653501518751965, 0.016064981025384673, 0.049551587639176109],
                             [0.57479341627618463, -0.25800062572124199, 0.21007064695096475, 0.32764630025205432, -0.36850267502354911, 0.70186282285066237, -0.74161751855058755, -0.13219959211037019, 0.19591940577961031, 0.37007289682642797],
                             [0.73570737358094507, 0.12587015377949054, 0.3772036459566685, -0.2457192409348404, -0.21415798692063109, -0.21273779864692666, -0.0014629550634654327, 0.79497709843657149, 0.5423139175953765, 0.35102310916821045]],
                            [[-0.61287329658789758, 0.72144791123249996, 0.31783571530936416, 0.077653254833417243, 0.94192909194089491, -0.58894672228783107, 0.029011985367395247, 0.14025323786174662, 0.26714527276526889, -0.23960776214952156],
                             [-0.15375612531862004, -0.59854041707620909, 0.93556879255917591, -0.50365507469670023, 0.15430245910385529, -0.13181297058691405, -0.12317743406420781, 0.56340171846960829, 0.12676071824973484, 0.07818106690629345],
                             [0.54352198101453719, 0.49256103537308549, 0.31488672562475728, -0.78226293921636625, 0.36883953686239568, 0.6125518077557659, 0.6511371348407976, -0.1086733144968442, -0.10941787477728998, 0.067392504287512173],
                             [-0.10180235826155103, -0.15259742009653371, -0.7653882120797294, -0.072342475822016306, 0.22494150309320549, -0.15428684099149237, -0.48225799751787918, 0.61316641750537704, -0.29330390548939916, -1.0991561900598525],
                             [0.52734810449461667, -0.069662242443771005, 0.48301344927390322, 0.70384721356430491, 0.37913865278611908, 0.52937653897122794, -0.29956669797855129, 0.29063246242556801, -0.23889027468694779, -0.54325553901043222],
                             [0.2095534600845522, -0.3325038887102586, -0.1333563371779605, -0.26896102665883859, -0.15172889103579362, 0.062937071426688751, -0.98132210296090006, -0.86575001151821374, 0.014526958081509118, -0.25350234875495004],
                             [0.32395570679590324, -0.14789148671148294, 0.9256749681306875, -0.098376459579068182, -0.21651857630816071, -0.90237406879762427, 0.14433545893804164, 0.0025798482819529289, -0.52884282616733891, -0.31284028333706732],
                             [-0.51301468065899647, 0.53582402035566312, 0.19120451274613864, -0.17819532339235261, -0.63477246998764825, 0.60854009015130128, 0.37626743428845072, -0.12432398986931777, 0.46974785667110674, -0.54853815846034726],
                             [0.40422004690826763, -0.2732795849528119, -0.16556265378438215, 0.18854657020140497, -0.14167513833567763, -0.34259906746431845, 0.43083359879938776, -0.24401778329833418, 1.1413183952016581, -0.10676051698032551],
                             [-0.28094613200068763, -0.37887016680744812, 0.23534749150331458, -0.040516027932070264, 0.56281737287137745, 0.58609115866118899, 0.70725115842431874, -0.42926727115638874, -0.33618590661237541, -0.34706463312460756]],
                            [[0.64578674277371917, -0.0040733042351920046, 0.98020678105984627, -0.65574870094617999, -0.16010647990701182, 0.00030194594700041349, -0.25920271562182146, 0.076666779279726593, 0.38198509484651821, 0.13836920943547845],
                             [0.025085102386818617, -0.23353479501553046, 0.36285952380452652, -0.2645176046249742, -0.45280221049163222, -0.13830288960440371, -0.95717618555333428, -0.81667288493170231, -0.54774207535363084, -0.039305576182209812],
                             [0.26661969217042791, -0.34573138179497287, -0.23496820721844694, -0.22110170349329991, 0.79172012847743289, -0.051732098391953835, -0.14926678829598494, -0.44936717221690697, 0.63380983373287814, -0.43311869609139719],
                             [0.54090384994152085, 0.38678413945612217, 0.3883139395722276, 0.60911102929993211, 0.2154963708394067, 0.75137347465984627, 0.061031351498728612, -0.23578195693811305, 0.41648119443795978, 0.53573176148508495],
                             [-0.21634474342479876, -0.44602704590187608, -0.17910815629657578, -0.61986879483293766, 0.010782657169115917, 0.4487361260748049, -0.18895176318708737, -0.2273792177501342, 0.077032356059848386, 0.79409701363860041],
                             [-0.11159995565871436, 0.3726369770256267, 0.55329813889411339, -0.074224199235030791, 0.58041561859613255, 0.26534188092198274, 0.49999667678601994, -0.048960175686517643, -1.0927936063860177, 0.36434173073057269],
                             [0.47172817472842687, -0.41934632222427382, 0.015953333354412291, 0.16936725798139879, -0.09636221078104551, 0.81121240336751521, 0.22029855217583427, 0.5836015820810494, -0.8012862398777818, -0.4667324314319114],
                             [0.82303906834190643, 0.030915027648820932, -0.67769885782215777, -0.12168994107606643, 0.39290897039445161, -0.31996189774810474, -0.072377723046742781, -0.083659536000359538, -0.4459722639683677, 0.74306460774480421],
                             [-0.58960884754380538, 0.27631011003335532, 0.25181518614438519, 0.18992232466835265, 0.34309995790496034, 0.027236413121583418, -1.0143723378486555, 0.62727858034072137, -0.52821219206933234, -0.11862286100167596],
                             [0.36484228724212414, 0.9667577718419984, -0.22309675383105765, -0.47781414523839216, -0.2981872320000532, 0.6623452018361381, 0.37064134159044265, -0.12393599696803428, 0.17680413014652394, -0.21511726427640299]]])

    matrices30D = np.array([[[0.29043056074503337, 0.00084111500409129038, -0.0071745364642432754, 0.076704950547859654, -0.00043880468748041818, -0.24461215640351375, -0.15971843612988013, 0.38015016147257352, -0.30999084920259534, -0.088395285130031892, 0.0074538234220594664, -0.23940032484568449, -0.57470790517693704, 0.2513976295769173, 0.15877204148401414, -0.5329028964343292, -0.064395822360718113, 0.1129573953580276, 0.2517779348837702, -0.1194036194804567, -0.2451632999078126, -0.47675936374182443, -0.46621749057901624, 0.19082876424323231, 0.52282031629508718, 0.1443947013388347, 0.042613279229702754, 0.35844545412140338, -0.082779218418038758, 0.45671929191593347],
                             [-0.11920778999908149, 0.59688241657502028, 0.34150137911134149, -0.0068236687751385763, 0.013444224917397621, 0.41651967472410839, 0.29746188966618659, -0.11582788117111871, -0.35396827279058019, -0.11382698339293701, 0.085061587742323141, 0.41106235524209828, -0.43625592510597738, -0.56961629945558512, -0.26808036933723711, 0.075605176324411938, -0.13688030954513153, -0.2783193166616032, -0.25189788115380868, 0.2518078655067652, -0.060643128267428667, 0.07484032555531947, -0.27695009889718247, -0.23725727676597991, 0.24734553438978493, 0.37962677868865063, 0.40082130778945158, -0.11801550224681542, 0.3079717392194064, 0.33644555011214455],
                             [0.68096157569450966, -0.54735594413702537, -0.19150561994564799, -0.071843458368567148, -0.19175340596160709, -0.33463964414567665, 0.01129937149032465, 0.17815291785100695, -0.073088402829288371, -0.17253362256795204, -0.012912308496588282, -0.1236656650091701, 0.23865371966269847, 0.16724630846491317, -0.3603783975758596, 0.29301120288283161, 0.18973563211690947, -0.35139323323349009, -0.003587885569166796, 0.48328732778992017, -0.060913460490223156, 0.1364990001402166, -0.14003569319783327, -0.19704134096251166, -0.06187885071548696, -0.063245782561409308, 0.074464158103911424, -0.45012050646210461, 0.27616177149258597, 0.087146122071828508],
                             [0.19024931629750685, 0.049943929097590718, 0.3960031732653515, -0.21848685555128303, -0.18948170381314988, -0.18920596809884205, -0.099721988955924795, 0.16837974063818614, -0.050242962335803595, 0.1667171576488318, 0.30428006131191032, -0.22306929950973292, -0.10267060108127408, -0.011565560395648274, 0.24594305649602421, 0.1512970504488152, 0.42072961900633205, -0.37267132827820598, 0.21167113397741688, -0.092936467855355753, -0.16823572072414789, 0.37220775838624048, 0.065565686389850386, -0.58455759579722233, -0.31939563614422384, -0.14369213356113145, -0.050473036512450324, 0.30176313884000144, 0.38654587875891727, -0.29768387565329363],
                             [-0.39373310802253297, -0.31388472611516005, 0.16440693113487764, 0.4230542278513737, 0.12943107845491225, 0.38181513031504266, -0.25862665945296831, 0.25537007259561284, -0.091120208877138092, 0.16496808397398738, 0.3940168219759751, 0.201869506292987, 0.013794266500206487, -0.065024951866929637, 0.1613601975376025, -0.28823968632226027, 0.15403831052896741, 0.03348338810706622, 0.30028628510195499, 0.12128061394042984, 0.34279494426654794, 0.13725173648655342, -0.078895186703199935, 0.35420908662096634, -0.24756728254835475, -0.28005715113243773, -0.059326315395841947, -0.14808661368521764, 0.47596183026884809, 0.51198415979282852],
                             [-0.0025416228628836295, 0.16699535798436044, -0.22152249535550464, 0.18883098314698399, -0.35743846693441678, 0.26277543193615271, -0.006269681729448388, 0.11100056870666203, 0.497804666327266, 0.30278306961001622, -0.29227393812630054, 0.0065886781182994594, 0.011124904479588152, -0.62457991834193149, 0.08318462106724922, 0.1307947588882295, 0.5384687799872343, -0.3883907478883909, 0.4906923140080901, 0.41017517646886376, -0.069679904501875334, -0.21470977088252713, -0.23431557825451918, -0.38794380808878692, 0.21250418699065776, -0.25853951210266068, 0.12432796595477792, -0.1100057259926002, -0.26790859862425337, 0.28678805163123972],
                             [-0.15193101433721129, -0.11043727376919182, -0.10724200744324656, 0.58988329481695645, -0.53982234647579652, -0.070999033623743754, 0.0041653149260345908, -0.59301183837232452, -0.10764734839501609, 0.41271478945698603, 0.22912646804064601, -0.43197704744058191, -0.21540311669725087, 0.32761787976723739, 0.13255370511513354, 0.16811455206138634, -0.39242422769571139, -0.072476116945221991, 0.085646434071929997, 0.29310059492485846, -0.48557454322009808, -0.11990548266093426, 0.3915754310040146, -0.30496491897640488, 0.038129649339409731, 0.28596017875018165, -0.18094405878176759, -0.014838169762511321, -0.16826748999172195, 0.16959538723841119],
                             [0.032694039839852043, 0.49606719098687785, -0.53862282914576221, 0.044122730582549979, 0.20334443495170379, 0.31741192446234023, 0.089570475132547192, 0.46134494364926149, -0.28908982820081469, -0.38625924310341342, 0.02337683117995773, -0.16108612016518017, -0.10149881891477774, 0.35551597989270423, 0.25113543511826691, 0.29595764851716799, 0.013661858138552706, 0.31326905924034421, 0.14660104764593435, 0.4180345762069102, 0.22115014666823432, 0.22538279173311845, 0.14487787877956571, -0.30437147973783923, 0.19401745447758936, 0.40042599080325514, 0.14648975886445897, 0.087003747514800556, 0.044584270568919372, -0.20457248992321675],
                             [-0.17779602939034547, -0.0023405810234950293, -0.27283987165970125, -0.020802217544909948, 0.32317458780510816, -0.48934606831683236, -0.20447706577204353, 0.2038057556869991, -0.13314987218546789, -0.04147044259522821, -0.044909580029621088, 0.4073900616522485, -0.34381307976474185, -0.59116391232603571, 0.12835098560277575, -0.47755345218843559, 0.08066342174122397, 0.045138728814353768, 0.014282166595867438, 0.44158560451316298, -0.37961825996437815, -0.24814502948576139, 0.11302518477336644, 0.054049571142636726, -0.34242599381276451, 0.077207728931976624, -0.13589370677198753, -0.15634088699382681, 0.029149125081966515, -0.26936572028959171],
                             [0.079044550651581336, -0.06492553331295714, -0.57003394113095451, -0.032240270872231226, 0.46993541261891664, 0.16658892350650839, -0.23041919925745627, -0.25292379473315352, 0.16334097076889015, -0.17169660198647765, 0.49535187745769044, -0.2624191078978087, -0.059411476394977153, -0.23421531173694773, -0.46773666643442446, -0.073369434433102509, -0.037829134185441517, -0.22210130955063981, 0.059834316956259084, -0.012307215039386664, -0.13386508199276062, -0.046934920416973495, -0.21469747570897174, -0.29803782754353886, 0.39606016141113454, -0.23423776874944885, -0.70198375366437815, 0.22309529289879415, 0.099743274198129922, 0.12642094617397104],
                             [0.076283509215162568, 0.40719389679649093, 0.1139140134818961, -0.051414033995612091, 0.10590158298640574, -0.16079635483200524, -0.13978379000237037, -0.18145151355332728, -0.41898755359086981, -0.32823171869069206, -0.37370081726355164, -0.27367232020435223, 0.22755154733288632, -0.20737779905413628, 0.27948418475262737, -0.32023007245673912, -0.1471299805886099, 0.35760417062739597, -0.2678772531384972, 0.062888901472979528, 0.22519058812607895, 0.018067336851001856, -0.41164836387427639, -0.6463384445646907, -0.030619965641957854, -0.57939878061945127, -0.037748404445735954, -0.3357829279498879, -0.019420222594302271, 0.2991059812694386],
                             [0.089611456408876369, -0.14331546578638588, -0.095501937511429241, -0.059196708539670573, 0.12392431250958243, -0.075372135278501673, -0.11481885263653636, -0.22339188947944313, 0.034139483684612094, -0.2562318172100303, -0.66655025258953993, -0.18393677775244266, 0.16793983267946661, -0.30493389334336768, -0.055564243423012111, -0.43875636346035074, -0.53563583697521577, -0.63230065046623951, 0.47974071888828168, 0.18622782279626185, 0.48114411020194042, -0.1015585511648319, 0.13261786253821423, 0.037752628847190772, 0.014794877434460962, 0.12849726208945494, 0.46305371835896258, 0.20674651288550386, 0.18085458008962418, -0.27569745265371837],
                             [0.3538195110012104, 0.038624135699831912, -0.044934049026049333, 0.31629204758616664, -0.052264684078416779, -0.031425489201078696, -0.25917105225358505, 0.10072268261719575, 0.45003004663990093, 0.2494018471075875, -0.097972256586407305, -0.34499944484945855, -0.55626926653325048, 0.18597145056262443, -0.17971741146557346, -0.25261130939520837, 0.071043860988872443, 0.035220809854374202, -0.44823989931217439, 0.15391936565627379, 0.713112281393248, -0.09316552990770699, -0.084053067200787146, -0.051434387671936643, -0.39250483898458993, 0.091112756743323683, -0.44341936769235279, -0.25554822894997747, 0.11708078526199704, -0.1878622618324885],
                             [0.28475315877320911, 0.14627132685155109, -0.03629402641101101, -0.13452140853594327, 0.47228614238874883, 0.2745028489837224, 0.0083747586195324318, -0.13633913697978323, 0.081891247257340385, 0.39554296117240639, 0.36075258375222591, -0.014912331914340413, 0.42168783988840197, 0.091654625972610287, 0.23844602743034118, -0.0054708449517813507, -0.066053755387404642, -0.40253081498951027, -0.17264331017583273, -0.01149959597134516, 0.18404133248359186, -0.68089096140478877, 0.37238325973176278, -0.047191671666271862, -0.091821678462188541, -0.031316708447734903, 0.36071775924354538, -0.017919391763544675, -0.14145726151212012, 0.042469547401443097],
                             [0.17270243703118787, -0.102457005388772, 0.17439199100039804, 0.0063001759713995596, 0.4348827920647016, 0.28888068236954956, 0.27143954427961264, -0.13814284456401796, 0.53632867389180561, -0.056682622858851076, -0.12309800334921603, -0.66395446830423455, 0.097494744038940206, -0.39802278362400806, -0.077973642008044852, -0.218817415006895, -0.046531136764744178, 0.49002641880644243, -0.094594516029022108, 0.046061410652315365, -0.52335793255591689, 0.37303284056671682, 0.13955122234958917, 0.13407086037985921, 0.12269134557158007, -0.015601966129219533, 0.20594836206975695, -0.10867493074121923, 0.069063253968772831, -0.10969489835672404],
                             [0.25362283619694043, 0.031405960092827256, -0.2076846176405614, 0.056563779069934865, 0.14665755238368333, 0.5880112991762505, -0.32662057461433502, -0.56083876755897488, -0.023451432077737682, 0.063171036608031111, -0.36034210743014355, -0.022164367904010624, -0.080175469816878411, -0.16210221143554085, 0.26654147966133296, 0.36622143419140729, 0.16582792690801679, 0.52867977336583794, 0.23830390594353365, -0.36688541376606559, -0.10954804197466574, -0.42168842450140431, -0.49729010972059629, 0.14570330540348544, -0.072005521616449644, 0.30136039689368638, -0.19240307491589326, -0.28541892106074385, 0.45549769778195442, -0.30898643134066989],
                             [0.33431045349347821, -0.044366766066123851, -0.43776889528256352, 0.60494487094551797, 0.026809989985753943, -0.3695935782191736, -0.093075946524632483, 0.1109221246392717, 0.2645700066009849, 0.24056923847799286, -0.13822439123000138, 0.24648838071926091, -0.092474476485945714, -0.35415770222116799, 0.27489247284998991, 0.17804418285013182, -0.071673495437769158, -0.024262502836185067, -0.076737322341108957, -0.66572603514726592, 0.061406804928936895, 0.32821200717019483, 0.029815621265860931, 0.20778745699969814, -0.063237002934858608, 0.086468815307709446, 0.23959384111475432, -0.040218569774486776, 0.15112205222115754, -0.097020317828577715],
                             [0.0089400332672485011, -0.21105816803298375, -0.28535021801144811, 0.16859468946131534, -0.071200122601308188, 0.024123709711309879, 0.58699745198946318, -0.23046264958909191, 0.11171041745246355, -0.24580440159081163, 0.22174003593828079, 0.11929647349097017, -0.080853286307897121, -0.029809573113614735, 0.4150087810370599, 0.033642106803032923, -0.32549209988619299, 0.13976042437575859, -0.21402662591509616, 0.44624068495258484, -0.11106543451308823, -0.2518678813114017, -0.52526141434147611, 0.15684532788833866, -0.048665190264273961, -0.57938047568580731, 0.10694162214063446, 0.65183473310407203, 0.053082837190453383, 0.014523392778627367],
                             [0.21200955214290082, -0.10116392783103088, 0.081548337282215902, 0.16155641424734679, 0.13323136170387787, 0.3389093712893122, -0.17938173652685724, 0.40318421938892401, -0.19697562830843199, 0.72098329031773822, -0.39684480808751271, 0.055362268916020134, 0.47620761356400926, 0.24668750490403532, -0.044977234862945845, -0.23336648612398597, -0.71252617972055143, -0.053550829429715036, -0.01761734878848209, 0.071559625139403671, -0.17610845242106149, 0.49013158985825034, -0.4797655570503615, -0.3332060196408505, -0.066705792074429129, 0.26614680263486434, -0.09372514066230718, 0.11149554000209896, -0.29308669386071867, -0.22589059135513312],
                             [-0.1229298544764649, -0.35603073993548967, 0.071274828004096055, -0.02035900749856125, -0.31989523755935451, 0.29321407154108159, -0.072567193546749301, -0.18874931798791428, 0.037726462892980539, 0.32571562284931654, -0.082051690094039731, 0.059812715208469529, 0.21087038752710857, -0.28564700713431868, -0.046018901436546633, 0.027905797063186258, 0.32403347585930015, 0.3185049879647126, -0.58415012974481373, 0.16237675869230375, 0.22908838116795241, 0.006346139484520022, 0.34524226136273711, -0.44470474663363724, 0.2401648972612295, 0.15646928247497571, 0.14004733613319295, 0.56603054723394108, 0.12310249398771744, 0.19710179087488489],
                             [-0.083266804230902325, -0.083148268467663794, 0.43519508518910338, 0.12856296534153308, 0.14551458275563689, -0.047709095742320379, -0.36262122395800245, 0.20197999127645153, 0.28045971259950381, -0.34738045184121907, 0.055386711628289273, 0.25753783264941948, 0.095455883011732093, -0.091748939451857359, -0.25737205531189766, 0.61105266362636546, -0.51554772569971441, 0.44149572333346621, 0.33808863671519029, -0.15708616477165749, 0.072712189876611918, -0.27236747213634049, -0.12261224560100618, -0.24694806117765863, -0.35493719635155563, 0.29912307931358961, 0.18822346535733211, 0.19193972268240436, -0.058823945871811993, 0.39423457028853637],
                             [0.27537910904184548, 0.034139891809961326, -0.45985849217139724, -0.86401777787209932, 0.21923986763765474, -0.018490467025560314, 0.098762827919194801, -0.075252895496523975, -0.028633554892651215, 0.34791627555200461, -0.070367597326041129, 0.19931006596677059, -0.45323681457952375, -0.05239819949745339, 0.078588538094609042, 0.18762001996543839, -0.31991186173589209, 0.048014638473698495, 0.033639778947222712, 0.08680910372077405, 0.13732261736671836, 0.31770258270865637, 0.40606206580768056, 0.063161745348266449, -0.16358135935220397, -0.036631396360035151, 0.20823913174870412, -0.14306221613611136, -0.080813379725102746, 0.54074269173729539],
                             [0.15814566148995129, -0.093643476276319318, 0.48118940217077133, 0.148961494907875, 0.32286510310369748, -0.14820273132630749, 0.16527550871201982, 0.087725324564649224, -0.36062194340446047, 0.21645124555018941, -0.039902514150312887, 0.00017639353328396685, 0.076464636747236567, -0.39334401431168148, -0.10395149006678706, 0.57260711301490863, -0.11971432319240118, 0.038726969954427468, 0.030147910892900771, 0.29555792354375776, 0.71451172020332565, -0.20307488936329948, 0.23762337517663221, 0.37210391785334684, 0.38480304949951843, -0.080043658428836748, -0.34229521946329894, -0.12696537701174473, 0.012010693453571869, -0.3350784200057107],
                             [-0.22028332900064904, -0.1045415041026346, 0.30246500425295902, 0.092836821691312715, 0.45389994360279523, -0.10710848640934406, 0.069005237525621252, -0.087502411091909177, 0.20222300390951681, -0.064207913504489872, -0.48063777942234009, 0.31734670080825361, -0.20069293246902531, 0.43140380033561199, 0.35371499377743831, 0.1186078151201881, 0.24719055750638272, -0.23798670887070961, 0.0067727955664634021, -0.087868987452786956, -0.15977007275761648, 0.075966116563603456, 0.083064124004748732, -0.27093415519075492, 0.34997444416488149, -0.10457356745541083, -0.21334657181857677, -0.11077953303340782, 0.24175123455247011, 0.045055134987097845],
                             [0.21920819643645953, 0.33572674759837318, 0.1590412324852411, 0.53594768292165873, 0.17087978295199824, -0.21763776056425371, 0.22635854236264827, -0.31928550994841987, -0.31422955236049455, -0.1331449111025611, -0.21804149572090839, -0.0074138772909708404, 0.14387687172121644, -0.26047665763144667, 0.050318128264838974, 0.11505743016721626, 0.37983432646697568, -0.19672275329577066, 0.092716561772278938, 0.35817700717914952, 0.043590153018345408, 0.19433583174296282, -0.017536395840604013, 0.4194198503632629, -0.36161432596477378, 0.46321933157882017, -0.27471038336338904, 0.57751983217605218, -0.18433152907452471, 0.3057873052324665],
                             [0.41422537709896551, 0.13430129628901258, 0.28633633021937138, 0.23565634864015075, -0.0016945915200825053, 0.51770585742731723, 0.35955056128565133, 0.26568944486815371, -0.021966280724333407, -0.25175447468200934, -0.15994609570924098, 0.21181031393854555, 0.015116699118393608, -0.02937554812880791, -0.19293025081937959, -0.34781382725894971, 0.017918321917943372, -0.08191971969158568, 0.25278823350022489, -0.26433427941631732, -0.29138275037503958, -0.34323858504770038, 0.61600048766665672, 0.025894504798707568, -0.060057164085139843, -0.35457429685016745, -0.37665527925378428, 0.057683235875118415, 0.088307435511908811, 0.0061951812731677143],
                             [0.2126344202523677, 0.38297783598704138, 0.012939965303908054, -0.21464249986904868, -0.31794606453241014, -0.017664442360641193, 0.19030870247747531, 0.37476304886083711, 0.41580981532385664, -0.20322664982077121, 0.11955832412629694, 0.17630644016261579, 0.61096313641949951, -0.09760450724264047, 0.24573972856086085, 0.09047325276732289, -0.12852280950651201, 0.063904182269971965, -0.043707159832173298, 0.19221445469761905, 0.12879971690213327, 0.11746823647275076, -0.03735438102618352, -0.046056477067612414, 0.21526139283311643, 0.39398377006370439, -0.63921370825812285, -0.042954686029952699, 0.57132775945116832, 0.20899514510015291],
                             [0.39389656341816193, 0.0096186958771534714, 0.27706693935852417, 0.010854362397448613, -0.047689250950834705, 0.27279426842334886, -0.65149553433631735, -0.39483978963440547, 0.066036858005701943, -0.27025223166222773, 0.043477445035982366, 0.31859606798674711, -0.034587687565140711, -0.15263161276498061, 0.43477121242013206, -0.021925500145004866, -0.035765395961604989, -0.21162935498646721, -0.17866452315030951, 0.29170968684962739, -0.2588296157578327, 0.38364678553071951, 0.18678665281658097, 0.25481125161767088, 0.18706181047106082, -0.075091067138011877, 0.13863479307227347, 0.2156023333925281, -0.28972457707670313, -0.21459513714518472],
                             [-0.15237395582457564, 0.71813771862614273, -0.10408032135399012, -0.017698153806792793, -0.047738513043364003, -0.2387203122246086, -0.42474205151167765, -0.18482927520998382, 0.04272210909768652, 0.41083268425974429, -0.24360329287218968, 0.012297124858779283, -0.070084857972199169, 0.35987818488120393, -0.36132854899245975, 0.22611011393408839, 0.025415112733155026, 0.23802268085607964, -0.19802089639548975, 0.060209815568744662, -0.13295674861853485, -0.23845846484820676, 0.11898174297365025, 0.3243161862546669, 0.057833232603398968, -0.56972269248905183, 0.19291711572497117, 0.17622953710259831, 0.59655505085773619, -0.10894090328087655],
                             [-0.3061398884416025, 0.039139058865318668, -0.39975455735918625, -0.10736175687633009, -0.058485385223924352, 0.43034958768245546, -0.24858458562350075, 0.56962541898520946, 0.023080959653535529, -0.076947562996024316, -0.32404972728830095, -0.34214087304416446, -0.077073967657180373, -0.26233813063524936, 0.18806664368576606, 0.46048146695694003, -0.23208777153158267, -0.53891814763781187, -0.62033080766387583, 0.11320423252730163, -0.25316326909860365, -0.085960114638867824, -0.017538392050433532, 0.35751034874749987, -0.20966857982217413, -0.079691552120772127, -0.12548519198263125, 0.25745445939812495, 0.15630514001116519, 0.14915075753546025]],
                            [[-0.67545884129547162, 0.36474963337463562, -0.049235344238720065, 0.22033296693873233, -0.11198048594729466, -0.23598301309013286, 0.15241238310569594, -0.11996730509596396, -0.30787331104779014, -0.040110685369499965, -0.17357245718759462, -0.23994305117231965, -0.19587497588825611, 0.22283647036776164, -0.39696248094564246, -0.17036430035391847, 0.19560408340012, -0.2941004201367734, -0.24841339902448914, -0.5566771174477857, 0.006639503192435647, -0.15036100459007107, -0.10354691440435473, -0.020049653242979353, -0.52723497931429497, -0.20197663948502487, -0.25480904719858061, 0.1182476660430446, -0.16770686471010965, -0.34427963164677949],
                             [-0.072831808882258139, 0.23562115149451943, -0.07695290344337119, 0.59496149450401115, 0.19709108974862871, -0.049124988655203664, -0.1910110988692473, -0.23024694286274072, 0.2349049589256558, -0.074078093850257362, 0.36014102390699498, -0.28171139299851433, -0.051335895116475252, -0.037163174301454854, 0.3351008580775599, -0.41352181916718356, -0.081059657295030355, -0.2258828677958708, 0.51893071380983458, 0.12786017002234107, 0.22143967851471863, 0.44280849051843491, -0.065267164695786015, 0.29374800405651763, -0.038810835006019208, 0.20466017298286268, -0.37477456041184992, -0.26908791091439266, 0.061259867506318309, -0.026826955525196417],
                             [-0.0048366753682071578, -0.075153851318852771, 0.03664906244967648, -0.15040789639611873, 0.11669157884113017, 0.59456998287048135, -0.35697745444816442, -0.045144621918036566, 0.1060238877022491, -0.11879089818250918, -0.3056795659219006, 0.062722441150235841, -0.035678938180463186, -0.19147915332613558, 0.13782413478509592, -0.12786995534896395, -0.19352854958040838, 0.021472090230794577, 0.049315115629622638, -0.040910636926957025, -0.51131001344488369, -0.30871773938862002, 0.17636279458718551, 0.0018682014289987947, -0.37190107639689646, 0.20175705375929917, -0.17577307943519754, -0.1552001894666527, -0.91921969931959735, 0.13455058837566777],
                             [-0.20294282470413577, -0.14468122204861486, -0.21460696248475658, -0.073401402494143883, 0.30682289733175083, -0.41638646544799379, 0.024449175966429114, -0.086463061816275041, -0.76109807727407497, -0.27972105733434732, -0.14497279267751928, -0.34137885374848836, 0.13206167666446772, -0.0036819773350281592, -0.073677936786846129, 0.0045835159056397384, -0.013626875502682437, 0.49437846598203378, 0.069868380698544244, -0.047656553088650959, -0.07561248258455984, 0.18676047361405948, -0.27586893537141638, 0.33463452760011864, -0.28000588591841796, 0.31300144752445241, 0.21850475509244882, -0.29806717344748096, 0.33541786252429079, -0.027251896995142334],
                             [-0.13786631676905298, 0.27497290580869538, 0.66446714491537229, 0.056816480368413996, 0.19157842567620176, -0.38239828320141228, -0.050042462872285205, 0.01680834736311965, -0.1657191299718051, -0.21954134132897074, -0.14469661068509643, -0.10319300569204304, 0.09202810902554201, 0.084741133701401322, 0.11439351592451431, -0.36025458583059738, 0.19837706824941392, 0.31015270543554091, 0.30343978382677056, -0.13348657839641692, -0.033844351467175286, -0.40530615306018686, 0.014338196932927864, -0.060148040746077949, 0.32231849135243817, 0.10433067648053457, 0.37621450758692654, 0.43524557390579438, -0.17579690798462377, 0.20159950459815554],
                             [-0.21505061139544199, -0.28563459015645687, 0.62884306729094153, -0.2628073305445402, -0.26690723809067357, 0.38345265921227589, 0.39465096135583527, -0.1657828463001261, -0.38331361313658696, -0.25665426999456664, 0.13835538809418155, -0.053961106693810358, 0.21414223338642427, 0.35333227361170894, 0.17358420008743394, 0.025560537083708101, -0.12326040908435802, 0.030060110543702556, 0.025379859537199428, 0.030170368129280214, -0.12409625552245004, 0.42579264374147002, -0.0087554729963138789, 0.043426526269811576, -0.21343466095492158, 0.046921588212695375, -0.22580862447671685, 0.48950237727241136, 0.305830091723861, -0.071818811744747552],
                             [0.13516855257466534, 0.28499704663861203, 0.54834888606987031, -0.090159489811377225, 0.2392698614060286, 0.1234364563723946, 0.20073882416839028, 0.26462616998224603, -0.19099447566231331, 0.17076998716205416, -0.26689565621806149, -0.51937820479765884, 0.30773799059533796, -0.34240584148672065, -0.058369172534106305, 0.1307272119762542, 0.042966500209170803, -0.26746656861205154, -0.30256684326179739, 0.032273403509172717, -0.2173519184189403, 0.0039137007052583482, -0.045873964940945686, -0.10100537845766966, 0.28692378473699781, -0.35052046569802919, -0.47121467201863076, -0.38180218687676731, 0.30383476450262603, -0.014358705104735399],
                             [0.32618354656582732, 0.25954713632633075, 0.11395496150385301, -0.11848375776569646, 0.24778764378515777, -0.29562453681269307, -0.22974965270341235, 0.38703171629500044, -0.38401689707819897, -0.095747731954094126, 0.7988548733828148, 0.18443071368238581, 0.015509511768741418, -0.021259272103379891, -0.11536660951423895, 0.0058196769128052482, -0.13989682609664378, 0.10598296943101282, -0.27975175537139241, 0.033259217687829787, -0.16262130988364609, 0.33393787680528902, -0.042843908022280108, -0.54908161038453007, -0.40632684161658233, -0.12965703263674344, -0.0012912642890326939, 0.14510457666799381, -0.062592827787758945, 0.24320202389208359],
                             [-0.28132551480854451, 0.1074322595337128, 0.030076323805970487, -0.089652966353024027, -0.1225153362545197, 0.18630519520885003, 0.22421688357179217, 0.37464169357158961, -0.082087620415856141, 0.14901898392524365, 0.16333672493673293, -0.28837724970371897, -0.0010278920416150195, 0.065200209264853801, 0.22402298976928717, 0.39564846974183365, -0.72642017801434067, 0.56406652840328853, 0.37595738303043702, -0.16750172295261737, -0.011625684369231556, -0.036244124435394751, -0.34294306773118022, 0.0070919750487558261, 0.016196167446783066, -0.26800976386690945, -0.16880693713556102, -0.13105904873384763, -0.13023334720054955, -0.08809824454479262],
                             [0.3265683825644255, -0.25716323443428141, 0.070124856525573487, 0.51324691317687754, -0.32802088516113898, 0.11605853325042506, -0.082271666202507254, -0.2867219228259919, -0.38513296199035502, -0.017225166837248611, -0.22288993232640203, -0.24246550546068638, -0.1392360399899176, -0.26389343046162322, 0.21849598542052745, 0.28380403252389413, -0.14890652425136011, 0.16452714202479324, -0.15747363042727303, 0.10955820132723174, 0.45725126208619299, -0.033580654026541118, 0.34171754255149323, -0.088456438702817636, -0.24183929444537069, -0.66396888029842838, 0.14281530213909352, -0.27646101565443326, -0.14861375821983103, 0.33476608459677926],
                             [0.37335440438779272, 0.5481405869128253, -0.015335794999709142, 0.12852064611429051, -0.3171927130060973, -0.14307017343188144, -0.13397551164038662, 0.16753535389454963, 0.015644843483751031, -0.014677506228044389, -0.20522858503021021, 0.1722300238093197, -0.096005023677726536, -0.12241998471328211, 0.49668178669629104, -0.1321207622030274, -0.21052033252647803, 0.031703232701043568, 0.050914265667544631, 0.07367238098799278, 0.061874727167031088, -0.2333154715566329, -0.4820490574802509, 0.11483831817498238, -0.51827479918185748, 0.32605180226400449, 0.019664666485940546, 0.35692832051202505, 0.48365134046529801, 0.084871045553613356],
                             [-0.17547349032560899, 0.11686283658998184, -0.09641211281478719, 0.26592786326670692, -0.25674762259302053, -0.21018918120847888, -0.070354149102743041, -0.61812006671920516, 0.1151124951854397, -0.51155218056143548, -0.19940946215929767, 0.1062093507631868, 0.27280567974500236, -0.36013173251450808, 0.070079978931598813, 0.22021052035173211, -0.079894651733771194, -0.03772116107130527, 0.21310396423760519, -0.12539210012569174, -0.38372099389178821, 0.043252812921344613, 0.11340368321414085, -0.51921834524907051, 0.22084597321116428, 0.20264775416194164, 0.021294039720267006, 0.27677547614720455, -0.019183178214959143, -0.18188079730544715],
                             [0.12420285047791219, 0.14496484287558908, -0.088241261499818258, -0.14297604236887515, 0.16389795692044387, 0.39224940687040499, 0.12473841751480383, 0.28508704971049642, -0.14497096169035426, 0.19469027314922846, -0.092820385765236657, -0.37396530224976049, -0.61208863467926666, -0.2482485116674335, 0.23793813356641677, 0.2107516162388815, 0.56477857849004953, -0.10545073949204212, 0.28306126651233621, -0.28864423267301798, -0.0059065923358121034, 0.31393118939006631, 0.17905310737504326, -0.13550220813410147, 0.083196197020942386, 0.12973040519173953, 0.34969427551501725, 0.086228743318972997, 0.27677692662987663, 0.33996340539312786],
                             [0.29968381269200833, 0.31065545187891064, 0.009553916692559776, -0.39442313311967436, 0.37497462090260025, 0.097892805118938581, -0.06366368833009281, -0.61953991455382162, -0.30737273137951726, -0.17192450568063278, -0.36148298597910461, 0.018052434746212008, -0.17342437201037511, 0.30086901810819583, 0.18376775719123661, 0.11439055501042011, 0.072530780563374322, -0.17267275641389068, 0.2316819360060271, 0.28990636172194467, 0.48967893267314905, 0.13612379539346883, -0.21966514833818065, -0.49527209170369813, 0.12344485301935566, 0.22370925293537877, -0.099654075684878551, -0.082188389733103856, -0.27872520482679297, -0.12168028981657386],
                             [-0.15702448830323407, 0.23236598267110534, -0.37037595058163986, 0.40409657174161445, 0.052683881547310199, 0.6100760392601714, 0.03872871714631667, -0.15201489476356178, -0.2463137211208585, -0.22928167041488784, 0.11285060513656667, 0.093045376103207678, 0.168783843697762, 0.32948606815751375, 0.030701070473629546, -0.12393329205505378, 0.20673793513635594, 0.23497185886034111, -0.4322613432544708, 0.29781697487384978, 0.0036337692430647552, 0.076691171177903097, -0.2251416996193317, 0.19781261284013987, 0.58637476936552058, 0.031104483300201151, 0.20501754415401321, 0.0082421248468221974, 0.15749918148873165, 0.37378883819122721],
                             [-0.068316771745113178, -0.4300400439840138, -0.19794352910987967, -0.038626782454515722, 0.10583274365626164, -0.21484169918673737, 0.36709248934298094, 0.15588955111440334, 0.078822838592902664, -0.31885234525924611, -0.56086496516075257, -0.12004485259890676, -0.00081840324866643693, 0.043676273453680747, 0.21514373421406355, -0.21707914471187217, 0.17514973749056023, 0.36224261832066068, -0.3696313397390249, -0.0824465709740798, 0.15965677329125727, 0.28588856198565282, -0.16242155465263369, -0.4469390272038124, 0.057112766763317245, -0.0035811584080236158, -0.56166502638770632, 0.20017888871419745, -0.30433630659631572, 0.079217644755955538],
                             [-0.0027750234698593296, -0.044551068123432368, 0.34669241921668614, 0.12856187206619082, -0.10641878083843129, -0.052156422882883621, -0.08895498024515143, 0.342180967752234, -0.024900108207826153, -0.38386873662513071, -0.25020236014871433, 0.35478773478886849, -0.13370073260019918, -0.16078816528127446, -0.87750162400322484, 0.23892131964389987, -0.21696372936119782, -0.0092315224300484472, 0.32722086522488741, 0.051718058623295912, 0.26275348343726707, 0.021218899497950014, -0.39485138043521423, -0.024077435772123106, 0.1408935405202329, 0.15469324223048805, -0.44386322301810738, -0.17655733126735476, -0.15611189911434653, 0.18129715766705057],
                             [-0.16846408242497707, -0.053473529332085157, -0.15153880373205825, 0.16083221484933288, 0.44741202815954101, 0.1879675972115942, 0.04943277679003312, 0.18070749272916867, -0.40041461818717289, 0.59854624480316232, -0.20076237841549072, 0.07245912406293499, 0.0074356732844220799, -0.45662461231078855, 0.13736765885991389, 0.076633305440253513, -0.29757365166255906, -0.13191021542407583, -0.065681857541220384, -0.21917273381254399, 0.026895915558489407, 0.1240547732227875, 0.18670929497485755, 0.37810829580809513, 0.37371867999972097, 0.24709828606521933, -0.079967177630257583, 0.56762475080525687, 0.009797088812326861, 0.16800331277022812],
                             [-0.048570230792756394, 0.26369521525686324, -0.27569013120232522, -0.58078867360467634, -0.43453544372315661, -0.14145135800382075, 0.10140275803257442, -0.092306548478693864, -0.44709402490676919, -0.051670305672712052, 0.27777451850844442, -0.24271729022572205, -0.24423246908577942, -0.044959198024191113, -0.0069514987634685648, 0.14237140849226851, 0.24816285317256298, 0.18928862053402526, 0.2672388034360289, 0.42791748520963557, 0.06030764195464336, 0.032272332609587638, 0.41132707523218004, 0.1186620923329911, -0.084714014264374402, -0.21880228507101529, -0.56845149663069294, 0.25719590786670327, 0.04753050500783769, 0.11181422982145936],
                             [-0.19320807130644288, 0.17855145593682195, 0.2059230203357395, 0.19060200210040942, -0.37688850755681552, -0.28615639056214276, 0.28735380738706867, 0.21102237985509925, -0.054286656873148598, 0.5100378642347112, -0.13277945691639401, 0.48125010524070982, -0.10904907676296233, 0.10757106479467166, 0.096482961006989207, 0.0017582686096831181, 0.070331024178088813, 0.055523579437363642, -0.038565268288813619, 0.2846551049093593, -0.28348310551994677, 0.26469400179412372, -0.01726734920039838, 0.10705590757908306, -0.065949599252806662, 0.35509080787337388, 0.080490371881373424, -0.353693227459211, -0.17945022691574974, -0.030695355362868399],
                             [-0.28095271361569812, 0.15569887301839383, -0.025601077484172285, 0.18184314300239318, 0.29666971722102975, 0.25182636955848808, -0.35909074114536754, 0.21161340853313237, 0.047452591491989812, 0.098380889288195494, -0.1855812592349248, -0.22016438607372027, 0.17471535471543884, 0.26113947923113984, 0.1993629567379914, 0.39086355698109326, 0.19680196318447879, 0.306789744152417, 0.083272987021994246, -0.25109487602810171, 0.22064296977533565, -0.25912292594536851, 0.72064804195378684, -0.24732541797191204, -0.20143263775554698, 0.54176893562946782, -0.13885909996769902, -0.27523034499694177, 0.25974815647209309, -0.25727009991982941],
                             [-0.24638334961431699, 0.10035258672878514, -0.021036396406335166, -0.028711983027814275, 0.00091538406649160214, 0.031064447262517669, 0.15141303307972911, 0.4132571058648466, -0.040030980219916877, -0.67356308192435443, 0.0053574211570787244, 0.48217741720921226, -0.12418467585500556, -0.30376930424202658, 0.46316360851059823, -0.2617314132989223, -0.0029257813218189904, -0.12582082635279213, -0.19554019125494729, -0.00057925115118496236, 0.23325075308196333, -0.098711485976134314, 0.2042918226909626, -0.16662381445881969, 0.0025585866835668158, 0.047384932644144173, 0.26975842614799384, -0.22290972693191186, 0.11422843163952978, -0.53995863586956327],
                             [0.30809844486139154, -0.15999671501411325, -0.07838915837212701, 0.18189105101427888, 0.18474434219456859, 0.15196140112568354, 0.60466342607033485, -0.058530458090118358, -0.14812506973063194, 0.049645205183729578, -0.035683764928827633, 0.38517463703300281, 0.14486043415593647, 0.061993411301215093, 0.11443694273357731, -0.22538950989891005, 0.22685847610097581, -0.0015432528084273339, 0.45596516388077307, 0.0085798807422968887, -0.091219155563969992, -0.51727831297450533, -0.31385854838811267, -0.20219206597212003, -0.42248201657656703, -0.071881758435231397, -0.23069822103179718, 0.0052685831648044083, -0.11939096128962738, -0.090886563185787056],
                             [-0.30217451216519842, 0.2729252058537599, 0.1417085689939093, 0.011673129176560982, 0.63601813424759812, -0.0049687790128293205, -0.011827240421993207, -0.14417021590763093, 0.24235202725976523, 0.13232926601872494, -0.35226304343829151, 0.11828487175102312, -0.30380976266048598, -0.17376949327308949, -0.38072641816359398, -0.133587849031087, -0.24137813950058773, 0.19234165681171303, 0.089126565594832008, 0.2374106415779248, -0.15682229183172247, 0.0033473650675657218, 0.20115531419151891, -0.29994409368642005, -0.68062708848042242, -0.32060817346839982, 0.29479710605283582, 0.24284069759594337, 0.43946663427828531, -0.13832697053948645],
                             [-0.50902694950201999, 0.027347860428971082, -0.23118914240921515, -0.081869639326740504, -0.10616408317849102, 0.015299365475260042, 0.076132767879665969, 0.18962814677846682, 0.016288449473107685, 0.26436304820212336, -0.002757899562143366, -0.26632815805438848, 0.59848001283555818, -0.45059873606529466, -0.16843908441137825, -0.2207979596648029, 0.11628460829922638, -0.002179486145630509, 0.15678411275668455, 0.0057055993113096512, 0.47969019462931745, 0.1328290615178051, -0.18530130301978778, -0.0032972649394863718, -0.220022405848114, 0.1133677888243721, 0.26628976787707404, 0.046267647883258073, -0.27695887510060163, 0.24716615964687294],
                             [-0.21127259431295398, -0.3571769394293326, -0.25832378608188317, -0.10598777395970529, -0.08333320118749464, 0.036243439496814078, -0.13770596030508991, 0.55139312899346782, -0.05320267264878608, 0.20715245028478779, -0.21510623209858651, -0.115217988758886, 0.01545498475552895, 0.29791556512579243, 0.044351964239534802, -0.49078471477596947, -0.50638349587259668, -0.40553089268279319, 0.41907234523108994, 0.12276636509128182, -0.18929899684175114, -0.016101343738919908, 0.053423369625230005, -0.45045228574317475, 0.19360966040102062, -0.051280175060956168, 0.061760604652392199, 0.0057922900164816705, 0.22918910825379288, 0.043832531619356331],
                             [-0.041210667504950754, -0.23706755720340636, 0.087346418868063533, -0.17314146202261688, 0.025762552108779448, 0.22266420510815693, 0.15396769064337268, -0.42964798177275054, -0.079292583114102297, 0.015291805291537355, 0.48319422475233559, -0.0050885946127471778, -0.32787867588240638, -0.32913527132604425, -0.10973398458006248, -0.50075313051435733, -0.27180642161106466, 0.24579215886198269, -0.24399387293546249, -0.17172396905808954, 0.21471320030718707, -0.23995105153712426, -0.21431631736596513, -0.22001983384982846, 0.095317081689149694, 0.58611964388127191, -0.26796636091939069, -0.37274617183601244, 0.2881693368914946, 0.20670781088382947],
                             [-0.68411156695277808, -0.32954489052164221, -0.05482100877513553, -0.17752747858795781, -0.00044182058141526565, 0.019840249373919781, -0.57729737272765225, 0.12943049856038444, -0.16443521107884357, 0.29591338075116752, 0.050636216241395637, 0.16351854632402932, -0.016677451213544661, -0.1031068448491767, 0.35251518821366279, 0.18116413993753019, 0.46832504604321568, 0.062342473205336382, -0.018620751905200694, 0.031015636869889153, -0.16006393560031115, -0.21902337967653412, -0.39235101330365452, -0.01921153374028604, 0.079408555022935215, -0.28403047247872315, -0.092311330443377151, 0.24296602145630064, 0.090777675222308479, -0.12592824843802319],
                             [-0.080292781781520522, 0.075100168351119212, 0.086943793428402791, -0.024267944461149899, 0.35948522687057616, -0.41767919801357972, 0.29021761904342264, 0.03539982553550082, 0.28330717793986215, -0.28779818904179683, 0.27929454433190415, -0.09588995764072164, -0.036496826316618214, 0.19171693383670441, 0.26641075360909255, 0.44034121828097106, -0.044788524261660287, -0.41653718407395873, 0.045420759905450553, 0.15394592177750702, 0.1142162554897312, -0.44676890431427846, -0.029501997043014781, -0.014618655460410265, -0.20806417376987604, 0.10851283840444759, 0.021910306235933742, -0.16446306418041173, 0.12677939170442132, 0.75058174882106243],
                             [0.18941150509441443, -0.16284839466765647, 0.020297040035666455, 0.37559235753470077, 0.05558421402870016, 0.055572146637365379, 0.13459070612611049, 0.094225435001775701, -0.097715579123257387, 0.10237264593501061, -0.12841535125831263, -0.48819232180837258, -0.1801107332991177, -0.19128314180282871, -0.21791255808070648, 0.39879005750875157, -0.16334220870166247, 0.13035938925943741, -0.028932103926764735, 0.67150893000987222, 0.0038051965266302041, -0.23498458100303543, -0.37051079649179658, -0.0098496073964207346, -0.077476619990663076, 0.55993997782571714, 0.0011320192209284333, 0.22561689521099043, -0.3416819664982883, -0.37673994189017262]],
                            [[-0.29122366433319002, 0.054631914735195464, 0.49687102018000384, -0.069738005460808758, 0.12559906560703077, -0.40804515835748245, -0.014801547951440574, -0.13000302239508096, -0.081901940981383092, 0.20995062649126531, -0.36156277322620173, -0.10149357108042745, 0.65113943485901016, 0.47739804248308138, 0.23975114777230816, -0.092984521488679944, -0.29166065151394316, 0.38899732630037487, -0.32654806079474308, 0.026752106264443333, -0.32544850318076896, -0.2607972257874383, 0.23555493957708312, -0.058664558331006374, -0.123886855013936, 0.43825796992731658, -0.32331871211499419, 0.026642282301739914, 0.16565623164790344, -0.13691992779541795],
                             [0.35615501563675506, 0.012392051935095572, -0.09202780874963723, 0.16736124225981264, 0.33971849905068702, -0.30857903845218415, -0.26457717102771344, 0.14961515539701306, -0.13401124284163948, 0.47459479359196416, 0.11210236175606589, -0.24397329762456213, 0.16191369406703995, -0.2346213584951575, -0.38809998443332105, 0.20291179092796915, 0.10309206851059054, -0.083090520179751964, -0.40781638657294095, -0.019015762462902278, 0.10371102576208088, 0.18035668919987854, 0.48377543885687535, 0.48340372072811033, -0.11285504691178638, 0.10482516002276496, -0.042554234780696643, 0.098508617181773145, 0.13638101528652977, 0.44093640395490352],
                             [0.019808554762965301, -0.10855471166844954, 0.079354686229499136, -0.23221436112380567, -0.39278443718959544, -0.10931426107384504, 0.18060625234893216, 0.36109383076153245, -0.40690985632062132, 0.40163930082358623, -0.10345850159145198, 0.064165699808701127, -0.21515866099652656, -0.17707140402751417, -0.14470334841044413, 0.16776852043234175, -0.14773255285754183, 0.37265691139397067, 0.3166595783674489, 0.21655818759347611, 0.21926329431224126, -0.17743256581394412, -0.19373960861497619, -0.26616837552755523, 0.097375880464657907, -0.55027698315348406, -0.48772306846476177, -0.26365417452376022, -0.09566059998835244, 0.10537037813134137],
                             [-0.069289445885445514, -0.35941793634148411, 0.55294380358908857, -0.29778630212147505, -0.058754473121172705, 0.19938879122683656, 0.13659173601259778, 0.13637593884359428, -0.15601880014102437, -0.43894717352541757, 0.14422728513145722, -0.11864114319642752, -0.011261810644654561, 0.060244881014256776, 0.23924849711310059, 0.18316313433449208, 0.27468113668640176, 0.074409999864832641, -0.27470630339710023, 0.43879018270880682, 0.26477541044022207, 0.45354256043770064, -0.031279251006179454, 0.080692252658848718, -0.17919625315183657, 0.066632191407501387, -0.28266639731644283, 0.4182362014939236, -0.040362011170679016, 0.18044067038724773],
                             [0.18717126830917341, -0.072969782081978088, 0.22242114107250369, 0.2614075377279037, 0.22887301445913072, 0.41127449977814828, -0.088061429043953157, -0.0097929335084335767, -0.3639489992864281, -0.33475871546494435, 0.17889292661487236, 0.24783711445925835, -0.24149883148745907, -0.41104460066636228, 0.050548933601297114, 0.1224955624535199, 0.10222819436566133, 0.33950072650260632, -0.25299839680038172, -0.14255226962141493, 0.01971875991784125, -0.036752617789244754, 0.132926465815082, -0.32293016079684128, 0.51298713470758961, 0.15830121297311175, -0.082878843955563095, -0.18694539922624562, 0.38686083961321205, 0.32662282715600904],
                             [-0.16333134357625714, -0.016786738574211604, 0.02003026049499668, 0.084196505267705946, 0.25726603275104465, -0.11625380857907441, -0.062236772560754827, -0.027213347946021104, -0.11873001783514059, -0.4018142212475373, 0.2087657210217248, 0.41259062374487804, 0.31600921166346363, 0.081157923948540531, -0.23418125076205748, 0.14188498695462773, -0.23201011700112265, -0.062400571180048922, 0.040113963437654443, 0.15996919537258913, 0.11480641365514445, -0.1475893998887424, 0.34579725673686812, 0.081526962531035113, -0.19972623851485505, -0.53854661264045178, -0.056842060155626983, -0.22945806734434926, -0.26094420046228595, -0.22896759442340414],
                             [-0.10645151906213818, -0.23783556955066656, -0.38084159681267576, 0.1837123825022868, 0.21058604515581025, -0.13592203597623381, -0.0044148040229693482, 0.014668884055019593, -0.034325185938826941, 0.20951613560091262, 0.071687620052753573, 0.081072457579475343, -0.053892378068457765, -0.23624915130595533, -0.00086546940359285424, -0.49975045495708348, 0.17154850204123409, -0.15759774169587082, 0.19298310213012004, 0.18854454771508844, 0.21162642561335637, -0.17266147568986098, 0.22847306941619822, -0.5472566075168096, -0.098916249861930858, 0.13555847521966727, -0.11408412747810114, 0.76819546545791562, 0.074539878745159063, 0.071765990694577605],
                             [-0.13175510163772997, -0.019709489522274377, 0.10698921466441426, 0.62216123481817054, -0.10073284278930457, -0.19443208029295955, 0.049674963029526863, 0.1312922550340471, -0.28645645299367245, -0.18728934472970105, -0.37613841382560459, 0.12388826626137286, 0.16757312241470032, -0.15550219845387747, 0.28263217592574036, 0.012185062487642159, -0.21472885347316717, 0.29861350491666827, -0.09597809319822366, -0.10189051237363587, 0.55865613269671732, 0.066209282988278328, -0.1997608277659442, 0.17829584147370284, -0.37078923913465778, 0.23359806305154771, 0.45562435602097462, 0.09874500974112875, -0.4533871789488238, 0.22996960234869651],
                             [0.25712964997633436, -0.33258298378543766, 0.046423859589509939, -0.10294039525028061, -0.34276788486691084, -0.15138772200792755, -0.14169540020745247, -0.25517869178439773, 0.13430112750488069, -0.35622553702304838, 0.18822148732524036, 0.17909959307286533, -0.055408717783055138, -0.013119556012054515, -0.25634891234239604, -0.022230451444966159, -0.089209079205215133, 0.24545859889458146, 0.1779598393100697, -0.69511386587368107, -0.030872202455690487, -0.052825729294333129, -0.13667989205210709, 0.24824216966632567, -0.30701075965219043, -0.30942274716316032, -0.33230971170447399, 0.48252493980488526, -0.15330929219217246, 0.023961310139552709],
                             [-0.082909320061543279, 0.63989419530197889, -0.1077829487839565, -0.12309614914359242, -0.17039472633338798, -0.11400428698088411, 0.10679124941613263, 0.064844259167215049, 0.60978275511695168, -0.24650332995313723, -0.27316968060397534, -0.087646657566712055, -0.023548842646571748, -0.13947167951964232, -0.25647335296134099, 0.11658700714931167, -0.15335231972136015, 0.31875285140452514, -0.32240366340363064, 0.30493472287279966, 0.24034769246866833, -0.34068978911078723, 0.035363764209057021, 0.035947211189381531, 0.29109505543817976, -0.37866998129369384, 0.064779246844780175, 0.45248842968619229, 0.1959005603301133, -0.27548657514941854],
                             [0.19566851829626195, -0.26788626353419381, -0.15096602406821538, -0.13389857938680799, -0.048571400437804335, -0.15861663507024545, 0.62976243738734894, -0.10474828787881953, -0.070268827637456843, -0.16783288394421655, -0.35091971293217489, 0.34234781359431166, -0.20532443865158348, -0.3208991201642864, -0.074362793366326313, -0.33924756896209579, 0.19774426129711969, -0.085605160653797766, 0.10295578385077017, -0.15193226401345358, 0.015605481210370187, -0.056413076584597065, 0.069539526447009323, 0.051042347629234958, -0.40829045066687625, -0.12042311774319903, 0.043294634194580579, -0.42191244785439658, 0.50139514620699721, 0.0075626309145530955],
                             [0.15483030936354272, -0.38484307235480181, -0.42718662257838591, -0.18173298467862675, 0.24488797292634121, 0.017869930862479091, 0.097362010052959233, -0.25555606905630895, 0.1521842167082339, -0.32531271286500302, 0.23158204743088015, -0.71230943707766359, -0.0050747072495543845, 0.11751801642857199, 0.073180875197432535, 0.0087253270970887951, -0.21487851995764451, 0.21084151089400496, 0.36284140189253228, 0.39415732586525848, -0.06211123211243709, -0.27130789430835162, -0.20414833159841025, -0.19051539918852045, -0.19101433953695407, 0.0020765269805877247, 0.11397809289919479, -0.14991954351970108, 0.044877654158820918, 0.16013266465682588],
                             [0.11567254997827055, 0.05362227000904507, -0.17567441632618824, -0.047188435887756251, 0.2641042553071965, 0.2661913859941108, 0.096139991006752745, -0.047735551593120172, -0.54170619519273921, -0.091767891985939598, -0.34797818763642147, -0.13736318999443697, -0.37165968358061369, 0.41444451810309041, -0.27169962701053635, -0.068702990166838118, 0.18392392245286995, -0.12721493960688365, -0.38327595519547891, -0.085237561430944811, -0.20853616005232889, -0.16604290525782528, -0.25118371410813939, -0.070624486977974119, -0.00041279214960860539, -0.24318129978079911, 0.34804040404241532, 0.21521164372009566, -0.16157134398469966, 0.022724564321780178],
                             [-0.34713409813857071, 0.35729866837071428, 0.17650242663275795, 0.13066402831316998, -0.0020399963975310312, 0.26261790061399126, 0.33755079282808781, 0.17249898571534134, -0.0747900343426431, -0.26346687119549017, -0.20145229197694112, -0.27403906476477863, 0.18214255257826101, 0.30176061504974883, -0.29293384618296037, -0.28764969734688145, 0.1120353046462485, -0.22270152733879572, 0.43112749211013257, -0.20047368391280901, 0.27864599446272958, -0.10262580947084401, 0.23626901206412004, 0.22833946811136244, 0.020424437083505345, 0.093517573332959902, -0.31757575373047109, 0.060202582577771439, 0.036543024224137327, 0.42160675776478945],
                             [0.091346035709286511, -0.17587010790824786, -0.046643677490254734, -0.17147603066963621, -0.035307335502415021, -0.25910637895381167, 0.3424846149629972, 0.16457469508503084, -0.040293179164471365, -0.064363972464657054, 0.45058709556890009, -0.053168682141062532, 0.051198620238711447, -0.10498083969776635, -0.024601729081508494, -0.48663515232704635, -0.35097326117780048, -0.32356974143378053, -0.43333204187292396, -0.31494006764374222, 0.53142879094651141, -0.10996494560996452, -0.076489419611412618, -0.18529461593607577, 0.38791140072055763, -0.20239650090126474, 0.1056677826297731, -0.064899136173836691, 0.066113095771078781, 0.052823758864541812],
                             [-0.4267590265147268, 0.2612805541761633, -0.4521095450417793, 0.022810250095585183, 0.093007805848231664, 0.03931421086521969, -0.24274596504226584, -0.57848610742632589, -0.1462780323144118, 0.26967766498873036, 0.0065293646715000615, 0.054692553128124238, -0.030793178604295965, -0.051796146231874091, 0.012781599718795361, -0.20805669338396518, 0.088249872717539715, 0.18138827544228256, -0.26958929637600393, 0.19771507534492444, -0.010552160096706627, 0.22082955581034655, -0.33521087726269061, 0.1660074375498117, -0.08684395044003039, -0.30297224590185062, -0.045072032322232468, -0.055147737015382101, 0.47962195291271803, 0.41066709636391735],
                             [-0.13591813255691931, 0.32828608826656402, -0.5722689824904843, -0.48178821187196763, 0.24890970887912323, 0.11993324691759961, -0.094281795413155609, 0.21769600220158086, -0.18921900812433842, -0.42531674905998679, -0.2283475677058277, 0.17003090832336976, 0.22593229087246575, -0.23441647653965025, 0.22376569965748266, 0.038509658321629545, 0.28477308030589005, -0.029839641087187868, -0.29161291195079869, -0.2757436571444648, -0.26638768329640533, 0.013816918007128184, -0.14632263277114244, -0.20854474022397995, -0.14232734582637976, 0.30490180055129434, -0.24267500777371209, -0.076666861977034428, -0.42438673028278329, 0.26915430748543823],
                             [0.38122205299589113, 0.1335864954993336, -0.0016861303519700712, 0.10042830992356867, 0.001405463377288034, -0.22797855735835837, 0.30339756563618336, -0.057553970632589303, -0.31579934981896496, -0.10582118566850084, 0.15444654757940121, 0.18555988995748957, 0.53296717311442232, 0.10852813849711129, -0.35368794649725299, -0.069385373679455437, -0.19530314020176157, 0.24553481385180154, 0.37654050108177245, 0.038510633044451001, -0.37720198231194829, 0.63706942082272711, -0.022052169308983023, -0.41879565170747884, 0.018203802441311073, 0.10708623649152368, 0.26917619651820884, -0.03921428111628087, 0.18092748626789321, 0.16209306749156296],
                             [-0.30737075645856116, -0.34594846758505032, 0.063846800492968328, 0.079718336622823668, 0.091414913847493812, -0.18914985674075166, -0.27989761058240953, 0.17116157123822717, 0.28482410476982267, -0.014321539802326954, -0.35508279396173831, -0.031920406236633364, -0.071129189616142841, -0.062110008286525568, -0.48131193424315899, -0.65524070570640436, 0.51590550340844255, 0.2201970181812509, -0.12631241207621074, 0.0091776569169394698, -0.41303981144598328, 0.15824760255736511, -0.072093446975758826, 0.088707846006096103, 0.25344075490225654, 0.0067568823619082634, 0.28642785776770135, -0.22606360362132294, -0.32558443808137921, 0.15087369440604359],
                             [0.20576112656150825, 0.22744128037288147, -0.11605187869297662, -0.009554072757831128, 0.1425001852480591, 0.10957306441550545, -0.47246993084022992, 0.49664570432314403, 0.20690724250551942, -0.13207007103275886, 0.14420662385724309, 0.0083177607352975507, -0.61298730793836365, 0.23007175448170974, 0.19276593655094507, -0.40767432077479338, -0.29033393286212567, 0.25414236341233531, -0.22449623736018837, 0.022009913729040185, -0.15038036702461646, 0.28288106586610978, -0.098011401620531458, 0.050672387305212493, -0.28020974844931734, 0.20155568690959935, -0.20118608001180124, -0.087234673075215818, 0.1575131538053775, -0.2082710235689042],
                             [0.33854350154679963, 0.15935180271119165, 0.072134519695328636, -0.23904540400569874, -0.085126278042546244, -0.026848566250605849, 0.039874839212003084, 0.086864020403955772, -0.23011349355727426, -0.048088671816287357, 0.23600082437703196, 0.25389083220695419, -0.045211516187586002, -0.016352367766242142, 0.2253428244788952, -0.40377825726127337, -0.06239068747231287, -0.096411569133377548, 0.22137978600732344, 0.46600309144781998, -0.24711099809982068, -0.43759009999319343, -0.14095713023967049, 0.69121718914645325, 0.15379925629440194, 0.37070034058541829, -0.21636160118095896, 0.2667875979851142, -0.16961154435810755, 0.1244304240819125],
                             [0.30135675342322138, -0.3960338709332728, -0.28709187259321306, 0.07710208317067857, -0.010521045752290311, 0.33240004377294691, -0.36475396541402932, 0.47755517187782459, 0.37397748110342699, 0.14259626086346427, -0.29389512768468656, 0.25429045698973385, 0.23275498265223965, 0.42393067455278305, 0.2953952526777579, 0.0040033989973108971, 0.074405435118193974, -0.23186958413628883, -0.1862041135800197, -0.07577665507038496, -0.0053850604349223981, -0.1265582771470313, -0.12736222689736509, 0.081223496656367286, -0.061440475172034048, -0.31879201936473317, 0.013706411240754906, 0.11645596085475257, -0.031395808924519042, 0.35736255200324024],
                             [-0.20484216514059236, 0.12561239268192154, 0.57973110484779544, -0.1520359852724586, 0.69000822497451697, 0.13645848556250822, 0.07858570267066213, 0.36774286087831631, -0.12407961134036827, 0.12396312697717438, 0.099600594736632214, 0.13658803487524374, 0.10464417317287143, -0.26587493754568575, 0.35477227541403616, 0.14492172119371463, -0.097831655364122819, 0.0082777358631836162, 0.28369933679188863, -0.29089267822839693, -0.063058438631860364, -0.10420868659269576, -0.27279467538611468, 0.15563903485879738, -0.03732570883318926, -0.16987902800708571, 0.34075693504907478, 0.14770782822283546, 0.25624084916177492, -0.017874870177712499],
                             [0.22891582826497117, 0.24071201190030372, 0.36434624632427182, 0.19391283290991321, 0.017660762763307275, -0.28390220982454117, -0.19716902325804389, -0.29296630610967067, -0.16234920328509961, -0.27961658394816491, -0.24710201539857468, -0.43130502500233026, 0.11671470559690084, -0.41441721896449268, 0.38751972142627733, -0.20292905990533613, -0.035906614282100222, -0.2865084515350817, 0.38084425976801634, 0.1565958504186114, -0.34700141898179487, 0.343932818374861, 0.31535990863375613, -0.13423839123852049, 0.079720538133094168, -0.35180702182325546, -0.053001755281814868, -0.17162570707263824, 0.037270132652647225, 0.027068817254279565],
                             [0.17130994213634931, -0.14925405288142812, 0.11301348467590974, -0.34111632974847117, -0.097402260379899658, 0.47815422543047881, -0.46641907628921236, -0.025974049418425751, -0.2273759168825118, -0.18199496298585849, -0.28375719304329972, -0.0009417970872070741, 0.15082300668033979, -0.23382587012899131, -0.43544664596827976, -0.080369203016498553, -0.46195064358324633, -0.24601557100552901, 0.17291932644821134, 0.04016341507014895, 0.28470273547463681, 0.034825347514372107, -0.24803073504892431, 0.032083855889900002, 0.018012465853780343, 0.11744407431259762, 0.2604241868970153, 0.13521011715427705, 0.12180298639804314, -0.30301764125908304],
                             [-0.26933878198465722, -0.18777418314744568, -0.4717695374426969, 0.20770737611898626, -0.39673926508741025, -0.12161597483323006, 0.0076236116529253151, 0.45868055354264381, -0.43954718658845715, -0.19685590907267445, 0.11145292460142474, -0.22013856368915044, 0.21731539454823784, -0.14432951709901048, 0.16435914937428187, 0.24701972703744243, -0.064894283778925449, 0.27243093658878714, 0.14783247342425185, 0.062676315964765056, -0.2910747845441275, 0.06920219907950978, 0.15161895812628429, 0.27813075294532008, 0.16483881863157607, -0.13469906699317982, 0.16706665316330299, 0.043911937422181163, 0.43486731181006877, -0.46453151977842588],
                             [-0.30023637361485789, -0.31089149993582338, -0.082075773438747474, 0.19598774376677713, 0.021957971898732401, -0.43847284824335886, 0.015720473238017479, 0.13265563809490052, 0.12017664207074386, -0.24071936402114807, 0.041980811055146935, 0.0031407710289571597, -0.46354733095484502, -0.060616661153291208, -0.26394935792197505, 0.38863103422831469, -0.36566666658513247, -0.55694481827791198, -0.091829693076837068, 0.03581031834480114, -0.35512722368786293, -0.019258195324843158, -0.2825361528572225, -0.020507527549652731, 0.13040348143711711, 0.27571099989165698, -0.27324336059454096, 0.051931675543336872, 0.25617210931090217, 0.50449875397610922],
                             [0.37183959502274061, 0.15562068870941193, 0.1775806351270125, 0.52461068620368434, -0.14754087585682901, -0.050546322532017213, -0.029912628271438049, 0.21274361482705365, -0.14971708247118648, 0.05308980642659103, 0.39822265139393581, -0.24131135335647591, 0.35478680824983944, -0.038427170216924225, -0.34849777629159773, -0.016564860855133104, 0.13806284052610973, -0.15641066023194619, -0.027270620661647409, 0.1750695332097289, -0.058934369450496168, -0.159670950956701, -0.6271704084401668, -0.072419782463998425, -0.249769049541883, 0.062670514182573953, -0.36990156388842144, -0.19515186118917238, 0.175243071461815, -0.29406863997105487],
                             [-0.1290073792079309, -0.12422858979004756, 0.27752573879144954, 0.11478283296198595, -0.27024684650097608, 0.55375238302495355, 0.04774792163369488, 0.11742425071392276, -0.11238459126161693, 0.18982201030314291, 0.083894761780475974, 0.01396360843516628, 0.10200252132085325, -0.47424813352472095, 0.023850064034642661, -0.10366769392439995, -0.42154586598212612, -0.14843816779581648, -0.41551847994060082, -0.016579318397026737, -0.63151078215169454, -0.031929587950358398, 0.34094317277400471, -0.049642587009923612, -0.46735819658301431, 0.14253799438969467, 0.25978853050814582, -0.014217893007725245, -0.3625114676208907, 0.42401299117843422],
                             [-0.16102490225506433, -0.35807635991666342, -0.2503709335417123, 0.34322521601127448, 0.38297300245672822, 0.23614669981299422, 0.59661631797490333, 0.13441681679108833, 0.073525849054813228, -0.027556447344111744, -0.34530656284109063, 0.063514502286739591, 0.17880825115266627, -0.062550844836060021, 0.061520674722297428, 0.17254869721228355, -0.33687533644651468, 0.22142824717816501, -0.022189528028376648, -0.13679674705221129, 0.06875704040496132, 0.34264468333604764, -0.15792995845998478, 0.27692525876987278, 0.30796194487734863, -0.057242499216767433, -0.55140081533148033, 0.19328153804705189, -0.41469608632397514, -0.33360219172455396]],
                            [[0.040871668927404757, -0.026783563232212287, -0.36328806901851052, -0.081056686004835635, 0.39117438258342879, -0.36977009395252358, 0.36828693231156651, 0.075542189197178075, 0.34354870860726427, 0.039347149581908034, 0.014419921565704805, 0.10250719274388428, -0.22769436523151154, -0.10439908959143375, 0.17625612917666136, -0.2071730033710602, 0.57036849672406298, -0.20990480070720791, -0.084204719758412247, 0.3642630403725764, -0.0075899379306440251, -0.038723093550881299, -0.44003105911995588, -0.14300453624901818, 0.25271020617122675, -0.084747785325902186, -0.3979241786431657, -0.51250063809342794, -0.51498955735379182, -0.11825497887040955],
                             [-0.20488009212021641, -0.4511478945286394, -0.37410828764338128, -0.058589817721731552, 0.048757077995706867, 0.31049370213707372, 0.029034052352670203, 0.0046701130038578949, 0.42092007721482588, 0.17656630033692267, 0.011378368180298873, -0.22291503428155957, 0.24705952624475891, 0.62688659165875438, -0.14125019567016608, -0.25370065944883968, -0.044416309420102912, -0.19480981528759028, -0.23964261456771041, -0.44245372317033166, 0.12250743161257641, 0.26001143604801297, 0.097499383999210099, -0.18401265352158971, 0.078743679482984205, 0.54017187527016308, -0.32149649248580991, -0.01564946275527063, 0.056434181760077876, 0.30765417993805899],
                             [0.05531566400512869, -0.18119493629195477, -0.0075234223348815002, 0.1110755058081585, -0.078641289346825793, -0.43961891644214857, 0.47161038777013348, -0.078525444229023841, -0.28468094482550366, 0.21862429819246915, -0.58873101539948935, 0.21576955926914723, -0.20295877810489235, -0.22424984923879959, 0.19117305308881802, 0.46144290109105479, -0.030047304025413016, -0.054784154904759387, -0.52330713029589593, -0.21705720323718625, -0.11643906787248369, 0.46213085194648895, 0.098706263366263064, -0.48568945198781699, 0.10808041760319914, 0.039874656107054228, 0.052796017396565025, 0.16317187752689327, 0.10379264990368607, -0.13759927086985047],
                             [0.15172271824256897, -0.26464249224689662, -0.0092642913262211881, -0.075694793120254941, 0.28223750891257277, 0.25980482213508727, -0.18549545367084025, -0.22920903863160227, 0.039669478466413416, -0.17035138431142138, -0.61608317761681808, 0.23142186648404192, -0.010401685097125168, 0.0038890433169156509, 0.063768415287280208, -0.25572069166890765, -0.02307677819332794, -0.026951495175092946, -0.30292988848691099, -0.23713585750849481, -0.30374307054130628, -0.3703115051562747, 0.066578917006594782, 0.23014855630800723, -0.64433022276764285, -0.43753074058886665, -0.016997154307167941, -0.17074492044781941, 0.32743756660471757, -0.11858887143268038],
                             [-0.66953174269287419, 0.29843878632910825, -0.39787235065029686, 0.15740616196508264, -0.10023924323115287, -0.060120959037322036, 0.2135185898958018, 0.30632255096030203, 0.3261868079214198, -0.087759573930998813, -0.017575153516945163, 0.1857641063632649, 0.17934080653529183, 0.23596588911615529, 0.18059227356757965, 0.063862792963294265, -0.10519532624408767, 0.30607208063394575, 0.0084416294346972166, -0.056774234320819343, -0.46534208382617909, -0.24990594245297221, -0.49561355095218118, 0.031809323388829545, -0.43274511758670875, 0.37023558491992503, 0.2707711965817523, 0.16428990863031756, 0.2191130942964975, -0.17517745354413539],
                             [-0.05656772486911707, 0.090933563051261629, 0.26967710467079137, -0.21384189878789223, 0.43606858838322021, -0.42525458563631113, 0.076151734995092396, 0.10317322759768589, 0.44239934896302846, 0.11503967244305903, 0.0094022742235472662, 0.15282593598065633, -0.51448306167050206, 0.12076069067889747, -0.14207088010267194, -0.082944693354930321, 0.31403264459999203, 0.21524567958510932, 0.0069791520467467477, -0.34197078604465109, 0.15628908145651235, -0.013936401641658061, 0.65126340067379662, 0.32551126471207892, 0.030623782149412068, -0.19707722780837039, 0.34259962628809459, 0.039658590222172663, 0.034047931987057259, 0.086065955946986197],
                             [-0.2186469242854778, -0.1300937519990136, 0.27619876649664954, 0.33298227699963656, 0.16365752430725866, -0.25578662104343841, -0.29137678792941546, 0.057495287187022084, 0.18601810235134458, 0.28696571137098209, -0.031839442336953711, 0.24172938857618603, 0.66971694263564074, -0.083217097525242312, 0.39256036577698467, 0.27402342657566586, 0.25058409013729416, -0.17206392670158158, 0.27212021642984513, 0.21736076929972842, 0.39396163651720451, 0.32523830181890784, -0.15521530606897777, 0.12484453811501775, -0.48847400178893241, 0.0074969946522505937, -0.028714600189588897, -0.47029508450908308, 0.1135924565796631, 0.18617888709053756],
                             [-0.047023836967520709, 0.14709600742965162, 0.05394390759457994, -0.44249127654012255, 0.28750332055873445, -0.29937185024804142, 0.40152126698531143, -0.095802986630466366, -0.017476060759886648, 0.025230157700796927, 0.23486874972659924, -0.14739025336631068, 0.63077290490844606, -0.35776413466274315, -0.15685007675278509, -0.057049115700281615, 0.022908497117971799, -0.19975713909777618, -0.066535007051839207, -0.018280384194889861, -0.13815758950182863, -0.18368605255654846, 0.08387271669649056, 0.17235865056242472, 0.34033848024479729, 0.34618895759699736, 0.55997696438796896, -0.25327859439730371, 0.55502061923229518, -0.19855770526665942],
                             [-0.05375860673792035, 0.16121945451497624, -0.043941685556803459, -0.38137746525452304, 0.021922616209589289, -0.30081245135826912, 0.39994791778689398, 0.068396476721050578, 0.089457876410447223, -0.024077239222644674, -0.2751693552624252, -0.11881442310876839, -0.098826412949733058, 0.046170263170869738, -0.25184687636250153, 0.20857728506472076, -0.42943508508939215, -0.0042282263548866217, 0.082058709584979905, 0.13369231999769446, 0.84112405952942459, -0.12931255829322255, -0.16222296695062216, 0.13260098587423849, -0.48644186512425025, -0.03300568247467639, -0.27278394470639483, 0.088384991048916339, 0.16451050977920448, -0.31440475265356194],
                             [-0.32047812792805702, -0.17991281721216185, 0.10790561251888083, 0.51885005881753288, 0.21936709156575823, 0.40450630290080214, 0.26948981659050752, 0.3551839166139934, 0.21077784461162166, -0.15597207755772508, 0.026899124872107279, -0.18638010259798909, 0.17920280649753828, -0.048331423610889837, -0.014476957652429347, -0.058438517939774295, -0.10372425766885643, -0.16171502088094142, 0.10268337985449297, 0.31554444411347005, -0.059091406628670073, -0.21889214925220679, 0.58610688377859377, -0.036997317476742994, -0.11091873085156476, -0.25861349535508465, -0.37695888472971911, 0.30202270201628773, 0.13379653042696105, -0.45496116808883452],
                             [-0.31678512002588738, 0.34386589263172501, 0.23937980309736798, -0.10596799723322668, -0.049199067149740212, 0.48467341699279815, 0.36273276285773393, -0.15577355223294206, 0.018720511805136935, -0.31926563732642282, 0.13423567716256538, 0.43610674303504665, -0.014652201856760616, -0.41912268825597998, -0.14211959944908628, 0.40001332151238234, 0.028260396729802441, -0.34937536737487052, -0.32585694159987028, -0.071429432708187149, 0.12853263083928809, -0.24962362271448665, -0.047493327574743234, 0.10540282637302191, 0.33485485000756571, 0.0074989899085357598, 0.320838457780521, -0.189080649571156, -0.41698501241031793, 0.5691903053562376],
                             [0.16018726636581052, -0.23071189779161005, 0.14847946180880425, 0.31683063479888568, 0.0049541852426097923, -0.14357588957037512, 0.0072637106883632202, -0.45668956548551015, 0.035100581246262898, -0.2020628498033229, -0.19941116170672052, -0.25686154065563954, 0.17450981873456778, -0.32932185113737383, -0.033450929999183858, 0.078152753255712554, 0.36535723481639359, 0.36829961472581113, -0.038960177926442484, -0.2197960148087795, 0.087474841222589389, -0.25061364757386517, -0.10703681318078632, 0.41138943353283342, -0.053816728510188948, 0.71707574337803703, 0.059438453294853949, 0.25607068170359343, -0.56467341125398374, -0.26666428844883155],
                             [0.3518601907272646, -0.28026836690465096, 0.22092735713519543, 0.3883369263981481, -0.28456415311963407, -0.064087286862107809, 0.17385335898638707, 0.41969331396656084, 0.1087533810289406, -0.03001305516635578, -0.093741047280130191, 0.23513579876063423, -0.26263625975474103, 0.28762307931272063, -0.19145229809038442, 0.029200840581450224, 0.013382401396434788, 0.020979102772525904, -0.10115633606023809, 0.55868040747650827, -0.1916099365684219, 0.1142100334468605, -0.010051482150190619, 0.57120589937818578, 0.19362002290617653, 0.25654025252871526, -0.082879968131477008, -0.066022723709834391, 0.38673844346226272, 0.41615832233660882],
                             [0.0090343041449307375, 0.12523806890945929, -0.40702261953159269, -0.094054313084705785, -0.31257618176361351, 0.29351951919229446, -0.050796548642914899, -0.21445694758328032, 0.10699112987043871, -0.29912901045359569, 0.0089134367646073534, -0.48870196289322709, -0.33672588392386044, 0.086064953416567294, 0.32220277339320613, 0.24375884724338048, 0.49078007808040397, 0.05816862025902135, -0.205316056705729, 0.33622230195825314, 0.18461546212205934, 0.19014675336595296, 0.29302005205999609, -0.09812994521380615, -0.1778840261958245, 0.030169163948755774, 0.45415816856085262, -0.41231223198267303, 0.36024006662518532, 0.0030949619603089593],
                             [-0.51797644115403652, 0.25435173813037371, -0.031092421766353632, 0.3355509440065062, -0.29589071166892505, -0.29003574011740524, -0.21942491393463409, -0.45674847546868941, -0.12114293026700791, -0.020907490664721612, 0.050120195146320295, 0.28869690909780199, -0.28334954939575674, 0.33123061750527344, -0.11960566699988937, -0.33236907155049289, -0.081064229039060576, 0.11723176782121214, -0.4397029542682579, 0.10970746642817825, 0.33959296074488082, 0.15589117091333382, 0.064306295527265064, 0.17366317088110991, 0.29644982315922541, -0.072122318197802932, 0.048278076399588706, -0.24010972846226031, 0.10291446885551131, -0.30777111641737748],
                             [-0.18157473297934529, -0.4126680801144661, -0.50314172474256258, -0.39370738127561722, -0.41800227121104383, 0.06863636746751145, -0.2076017669686239, 0.055046713520990526, -0.16745501678191052, 0.46566989150647942, 0.64084093630932593, 0.24573149570181091, -0.12548681829526767, -0.23062573948780962, 0.084256886955805299, 0.081465356327667326, 0.21230078926278934, 0.028942276608748513, -0.3979888214669563, -0.0219007302201626, -0.003202669367605368, 0.17262986839515407, 0.22178278839214238, 0.43971734526077066, -0.28468833660181958, 0.06231094608033029, -0.25798544686579361, 0.20606936764855069, -0.25217820882594555, -0.29890754610124681],
                             [-0.47379147282743367, -0.059632100584093961, -0.058138773845430779, -0.14743304009384206, -0.042738958332797741, 0.36566831917214138, 0.3810185452906133, 0.086362229911653432, -0.36615765941136413, 0.29565809372704016, -0.6354483903393493, -0.032774258015690463, -0.05941862370911781, -0.16236306912257459, 0.091791813421786744, -0.42105910705907879, 0.20253866249450614, 0.12511909643900954, 0.69229998859088293, -0.063692185309751084, 0.031146776103138291, 0.11895290399940402, 0.064702633671340035, 0.21230095969927842, 0.017026966530806487, 0.019446859460066468, 0.022178594334687246, -0.062767496409964804, -0.19125508587580145, 0.092123523980161715],
                             [-0.012892421137381219, 0.097238041543856513, 0.15930261365443574, -0.28423480483151337, -0.45474667115466644, -0.24567955404750194, 0.052739793413445875, 0.068915556752412871, 0.081048603841174377, -0.21256207663753859, 0.044517625650892428, 0.16291392849049502, 0.18786049868710025, -0.043521740408259652, -0.00093432105743873964, -0.4971200335422864, 0.1597076080224003, 0.26459927654169968, -0.12197875341092024, 0.3492346917479302, 0.0014182140771672458, -0.14874787485393243, 0.5249264505241098, -0.54009791840098831, -0.28029128323597374, 0.28063199768198588, -0.12743568357471824, 0.3835324535236676, 0.12260620813831466, 0.39668153288845964],
                             [-0.088637106537762675, 0.51565590196628441, 0.32273021769212373, -0.057208592466502187, -0.18345030870128021, 0.021165207343242322, 0.28687327075673208, 0.030110920114519914, -0.2497428624732696, -0.067429458773623441, 0.0070954511486263361, -0.21307944179580682, 0.087752395012449969, 0.12544854523753804, -0.34356660013694651, 0.14172702188802941, 0.26294174141505339, 0.021390372927499304, -0.13118042814674358, -0.35430148305176873, -0.38528387023896216, 0.033159997832661048, 0.14365095358982763, 0.043788728315816539, -0.2915947501917901, 0.0040724524021626199, -0.77251886942650116, -0.54980602761548014, 0.12800142122833136, -0.29127123041410558],
                             [-0.091178183306925786, -0.40459945297264177, 0.14274740349654208, 0.24027199563419757, -0.0056953493740175953, 0.070490649866870272, 0.33546556663405935, 0.27148406987193269, -0.37653203069502134, -0.12346345257075433, 0.37889110456142516, -0.054283222018977229, -0.14721922781802194, -0.31975160679029546, -0.37613359407609592, 0.023988358677519792, -0.38421596143977571, 0.45593432511316334, -0.18016263956035469, -0.25363509161069497, 0.084149610200840608, -0.1790348917556891, 0.16081344851848697, -0.42614099602095695, -0.27031695668388434, 0.082726909669915125, 0.26066569971586168, -0.66453058595477055, -0.33180401143300742, 0.09506717625593078],
                             [-0.22898948770616478, -0.044470895364278049, -0.21803191908111857, 0.0017723390682204687, 0.031556593595424252, -0.40137466053913168, -0.15188558434761279, -0.1997687588938945, -0.27270546290117109, -0.02688844928477899, -0.098276893471729132, -0.19454560199524018, -0.17011314951767809, 0.3769663919998989, -0.19309929781139695, 0.23393778627835277, -0.31872195588494057, -0.46504124229444982, 0.26796662062590848, 0.32083033249687432, -0.56027722460255158, -0.02772575825286689, 0.41472918582922863, 0.040760910836299125, -0.29063588683632258, 0.20491383430466531, 0.059919858025419923, -0.24264910001115128, -0.48287903084852868, 0.10956252193145537],
                             [-0.087034329039982455, -0.30909001912266582, -0.089768659440153775, 0.1007495232866546, -0.0017163195486853034, -0.18271343515836885, -0.10358045919308348, 0.078806941425618365, -0.40139470299941432, 0.019917062694259982, 0.024185892288446274, 0.36999637488024412, -0.07009465717615565, 0.41117523177276555, -0.46472899371624526, 0.35597107012648871, 0.69211182528631732, -0.20885540859663493, 0.10561279726030982, -0.1836964403011084, 0.28528709343994035, -0.42746196299540135, 0.060585309795346765, -0.32313825884773034, 0.089370695041619444, -0.047097987988254313, 0.17343481829275093, 0.21713425515343776, 0.24263044797081165, -0.23747248853397279],
                             [-0.11460617897398127, -0.28557988927237504, -0.24728741893753159, 0.15310077402761704, -0.2657704464789184, -0.18292662587344657, 0.3578788452060544, -0.5641216564138527, 0.2473157678255499, -0.3813914112321547, 0.34860148619747233, 0.028200243896026267, 0.016628011071676746, -0.31065597261038014, -0.52550023530675383, -0.037277879338461994, 0.11016247144748033, 0.10438730676115664, 0.33361327112537281, -0.15665321359437875, -0.040200120101003545, 0.33164441862866667, -0.20401107161308615, -0.064012806894360591, -0.18326820409486014, -0.18251631949645705, -0.1695803846968239, 0.15871811033644045, 0.15397911049263241, 0.20665694465053519],
                             [0.047287651612241237, -0.27531111226928245, 0.28234839689342078, -0.33782552126844656, -0.30704385388159627, 0.20990612642234796, 0.010275283532127004, 0.0111438718233487, 0.46012850760396246, 0.038564259897743598, -0.12700180775697562, 0.1222575544888964, 0.33331338322307485, 0.40811241691933792, -0.26405190916157029, 0.13908563930204881, 0.10407953942116015, 0.16377149771818519, 0.062214739884070856, 0.21214684343760062, -0.28655224281611413, 0.45550857775969389, -0.011352044390801834, -0.079488650435577138, 0.011867588205143925, -0.15748051412811492, 0.26316500200616, 0.066810846277120861, -0.143065747917305, -0.54180777398244262],
                             [0.20821346477465527, -0.23891911384187636, -0.022774517532419332, -0.086069538255339861, -0.18398696582051957, -0.09696005505217313, 0.13653133284383201, 0.39442263210177092, 0.029595995987276955, -0.64310640878984471, 0.056156470197651367, 0.30229258195532044, -0.13386511205901291, 0.03263237122655991, 0.41798386185060232, -0.29890306639408709, -0.15977468803380351, -0.49157361063200861, 0.22554392945207302, -0.5656771726657791, 0.15986475452654841, 0.25121960198974097, 0.10133028305137429, 0.1401170548730104, -0.0063007702975911364, 0.18963359917065462, 0.09654776854471836, -0.14589820146290244, -0.058415249665263319, -0.51901360984950951],
                             [-0.047384107479278736, -0.20332422683731338, 0.64508950342073423, -0.086063558515561911, 0.32327443826092689, 0.077341923055486247, 0.36790041280095315, -0.28303722329666114, -0.38850895384551004, 0.16990541243447085, 0.33629425443382643, -0.26854594009466121, -0.269838647581854, 0.48666569581744784, 0.4106783842700224, -0.14209660742927963, -0.06649464657152325, -0.11635094985204529, -0.18365825814551609, 0.14448715265871229, 0.032260876450832691, 0.11013050205194189, -0.24273509751245917, 0.07584179410111333, -0.20416701523464076, -0.054415756223774286, -0.040357886498546471, 0.46427120673010502, -0.0058834137719093512, 0.095240960672799191],
                             [-0.37113665372233084, -0.40572479872182116, 0.04615208176267848, -0.23520285810017968, -0.34003065136567523, -0.4989886449617188, -0.077019745401348844, 0.32764936510560466, -0.072376221719702732, -0.38273011456318684, -0.21314033066290616, -0.48298747648769608, 0.20445279139116312, 0.096970803450843787, 0.2247504169843195, 0.23384120830329058, 0.0015068004566598289, 0.10157159178568861, -0.11726981479159598, -0.16974593687367759, 0.0019040640568296074, -0.19109417390266395, -0.12886593251004866, 0.29574585033851791, 0.39766796558291562, -0.54238772381901723, -0.22013094047868392, 0.024761832758693696, 0.020367898762844609, 0.20836454218956937],
                             [0.27304589904090248, -0.130799987756788, -0.059367230173150855, 0.20137165403472246, -0.68743846611083337, -0.078656037058442554, 0.32311282205053204, -0.19813469798545724, 0.4799711069319525, 0.77741245460009833, 0.09340021010363278, -0.18731806124603478, -0.075143055850052751, 0.13282716782071821, 0.25781543147680158, -0.20699129880166917, -0.05733569552851156, -0.39613357796054049, 0.08033450719478695, -0.29605203369479433, 0.010774126865767841, -0.49991509274926371, -0.024108028455865287, 0.038381490237654838, -0.18788355542723689, -0.30260851933074429, 0.00014837449816444437, -0.028757086949611581, -0.17804638048996527, 0.036383940930201045],
                             [0.31455112321351625, 0.093161014144822307, -0.33869610755936047, 0.10902740110419683, 0.14075348528659043, 0.20219965959280278, 0.42933676358216344, -0.45323044772443843, -0.25187234301802813, -0.098075668763127427, 0.22459238935533987, 0.35312450989428429, 0.36167896475232669, 0.35587974787848931, 0.30988301506869104, 0.24376090677620643, -0.11010559724209328, 0.52535831983725934, 0.28650769425945694, 0.029191304795011114, 0.09519408442243564, -0.21117055856579725, 0.39796389432843704, 0.2253232846813292, 0.18681857628015147, -0.10421830034982847, -0.094526352651216852, -0.047560498584594116, 0.055386538834102092, 0.24887274636905762],
                             [-0.16662208070765364, -0.29700831073591333, 0.37776449266267831, -0.15274430420916676, -0.012658261123637965, 0.11235214323778492, -0.18549788777386594, -0.26010858565817913, 0.17630473061816299, 0.05286843488099998, 0.05454567006366752, 0.38156293736169378, -0.56533425416046446, -0.23812145174020413, 0.29109777800622394, 0.32749616707423468, -0.20461535204387199, 0.14254626274114685, 0.38124361123591199, 0.074466425111120796, -0.22032827494819193, -0.36307042308602233, 0.14897447284478416, -0.088813737316525088, 0.36643373120315403, 0.33455155570286288, -0.45096040382968977, -0.12976513657912264, 0.29926460910908603, -0.037541859766112247]],
                            [[-0.096994618143903241, -0.16034917785361791, 0.15473043026313546, 0.10075636752141713, 0.1144459181832454, 0.34629474712861674, 0.092915047602217665, -0.30910795144920455, 0.20553609498595857, 0.42219322330830067, 0.31661899607122057, 0.14840646766478355, -0.14840778252912865, -0.14395810347300894, 0.026106250640090554, -0.083773043834761807, 0.17246207658182899, -0.43939671732393898, -0.3145686541882855, 0.047185087310109591, 0.12045884713187527, -0.43374651616781928, -0.13100318287087329, 0.34584429041866782, 0.045044172462312279, 0.36566697610624638, -0.21898120626455528, -0.44319678414830355, 0.50473322899566675, 0.27785587708519116],
                             [-0.13761347819311137, 0.023339917776763787, -0.077251119019303205, 0.23321826119114339, -0.38683134123397261, 0.54095319303593192, -0.14334360962153975, 0.42430427653944558, -0.41441273376554322, -0.43270423710519046, -0.30614942035700904, -0.13322044816373757, 0.032478302030030909, -0.3755972323535004, 0.27017232441680455, -0.11432979880383987, 0.013760700198368348, -0.37637491028545006, -0.40967584364016546, -0.030841740611968732, 0.092395613737336901, 0.15506943869583747, 0.097419068887585572, 0.25526037704976001, 0.14408412813091021, 0.42970074382240347, -0.20814987909186525, 0.040681303431019389, 0.11411266390634089, -0.028160190636061427],
                             [-0.33912261536443528, 0.21286703537300131, 0.41489803078561793, -0.096855880448537948, -0.42438926915338632, 0.032449653458113042, 0.14487604357757319, 0.34897171731591747, 0.14721134891385548, -0.19171354274286576, 0.025019836184785545, 0.096627776488860118, 0.019718141920893349, 0.43293895654031, 0.19965439266880336, -0.416681459030113, -0.011216993080282869, -0.067871011491983352, -0.11537091324661794, 0.55837796356637082, 0.17869706447381389, 0.089133000252986427, 0.29384648194170077, 0.10507447579649212, -0.10115816272170688, -0.06977233259352783, 0.43373995704504242, -0.28696794192294234, 0.0835515376363445, 0.44164117965964805],
                             [0.23364364400878568, -0.19476866292626685, 0.50343350966003253, -0.10784073431690247, -0.061529409249834022, -0.048361344088843849, 0.10373254207284366, -0.4662296066884945, -0.19390937106731171, 0.38615515072983625, -0.089261599309551715, -0.16021572258111766, 0.50723839911802493, -0.15536214813606786, 0.17400506059684764, -0.41640545611950713, -0.41447800332361984, 0.40867037506559528, -0.25453812574803597, -0.27736495801683703, -0.10413496036556769, 0.030730521470566839, 0.21185484187503378, -0.024100399475447114, -0.16988403945009928, 0.3601381064965582, -0.16614665671515144, -0.098171524221541587, -0.18003035557075306, 0.37284633146955098],
                             [-0.068688827234776484, 0.090360460120779765, 0.22274601699873789, 0.72296935852553024, -0.32123276148144819, -0.067502908385645849, -0.052403750549165559, -0.37189105142846435, -0.026772772425703875, 0.027984759740136381, -0.44452661245776137, -0.30832784400753049, 0.067161350236302708, 0.079397996254206002, -0.34883206794147342, -0.22601930121997904, -0.10214121692367939, 0.050939333878026814, 0.16733289232062581, 0.31701559666790646, -0.18181024629072245, -0.18370341515226313, -0.34082455920086857, 0.45217831473712483, 0.20454760340729675, -0.14586419582113669, -0.2549469580311749, 0.26943272347512665, 0.07120538870819168, -0.069464278556171127],
                             [0.50483472685251485, 0.27664198101319842, -0.067793847949391334, -0.15700432825644439, 0.036303851783363067, -0.26694032296128711, 0.20834193757882424, -0.18794731946164495, -0.18524037950770317, 0.056084528311193399, -0.44026801190512033, -0.088776982684389744, -0.11377815004084937, 0.10594335838387928, 0.49257325447284522, 0.18682973737770492, -0.07749063274581168, -0.038564887434658822, 0.66244869319891519, 0.12091999247064564, -0.33549267319811871, -0.1264958966221072, 0.23779675553340279, -0.18409214564057855, 0.1511907398892415, 0.42435772914759035, 0.35591039017540599, -0.14641440899213076, 0.36823084653761817, -0.090617484116989999],
                             [0.23485027673900399, -0.16473449008232116, -0.24963508485163716, 0.0059700627163168929, -0.42952669510718727, 0.39521838198597808, 0.79300404970595895, -0.10409345468271311, -0.34746691222202619, 0.20688054450725687, 0.063464252049401954, 0.22933486289296684, -0.46450019929136205, -0.088689455609918408, 0.14978523441222941, 0.18691921284143853, -0.30613443887992187, 0.023305885455731201, -0.16967094718622583, 0.48444479554798903, -0.18301723417159665, -0.17837749863757152, -0.18067135139893084, 0.055176965085692094, -0.29338223556455539, 0.073064100445515159, -0.086930938641360714, 0.22743702789290349, -0.2965584187089641, 0.067277789717639591],
                             [0.42730110868831711, -0.026917206611378905, -0.0093481026553466282, -0.077803303481417424, -0.25761206545859244, -0.22560166773759577, -0.54447149600202771, 0.019143073333422828, -0.2904461449151125, 0.13891530958581066, 0.14269225946821276, 0.8530757368073747, 0.20752798762440924, -0.28814326910978894, -0.2395502651791821, -0.075779290742525054, 0.37226040735929034, -0.15400012323407569, 0.22990416356014445, 0.18376522819515795, -0.0033652198107444187, 0.21157856051034357, -0.11756451821102784, -0.26285554314610154, -0.3337027820559631, 0.024211092325192259, 0.012476778622246609, 0.18231776395449895, 0.22970214487685073, -0.060446458297546954],
                             [0.13700481307561996, -0.48844525811371803, 0.38255003987385583, 0.26188713030101551, 0.24954703717816712, 0.16053641899015578, 0.40735152435179106, 0.1609093222101502, 0.14125874011214368, -0.092044084567229248, 0.027192719526582809, 0.10250117360177266, 0.71574102873408807, -0.040016656545509219, 0.33182059909415162, 0.13242455522503488, 0.027400871538403242, -0.12387142968964794, -0.13682609450478114, 0.15664749521884358, -0.0073707301680151077, -0.21396828981153182, -0.30300111246438632, -0.20929304288554784, -0.035861507938528485, -0.31790893274030407, 0.022641934645440735, 0.2686184677850233, 0.30368200521045813, -0.36356817498894262],
                             [-0.12220885212154033, 0.19192424770278246, -0.31885009292407396, 0.16571930881792221, -0.24805506836104566, -0.2939197324596014, 0.48245265800261122, 0.069170003835252972, 0.15117197963027879, 0.24516738010870154, -0.17530044876534201, 0.15657131401821606, 0.06913130741738191, -0.42464824101669496, -0.052641811139458365, 0.28491762471515808, 0.11923542738095268, 0.16572591187858024, 0.052406495745102186, 0.10835274255119605, 0.58218989883808447, 0.4271489742734178, -0.20682661216561155, -0.21901548367510557, 0.22174158521698337, 0.17183747163815147, 0.048119380891507836, 0.21968583693922061, 0.28760906979817275, 0.32053534158637881],
                             [0.33041904877945139, 0.20249818849467449, -0.108672902805924, 0.2088698211531694, 0.2206006549417871, 0.37767273792848371, 0.0060819170310077164, -0.021949720220395763, -0.23825858367471672, 0.23525002227353742, 0.029148538623166222, 0.37560930960305272, 0.22075885752259258, 0.16428027259833933, -0.045296540369866717, -0.085659935128004003, -0.028715530815091123, -0.049988825606556396, 0.45021766251855871, -0.08315968472196969, 0.62988657371691414, 0.23744608898352282, 0.37842597464385636, 0.39014202031652756, 0.06430278728455617, 0.10666474087378798, 0.21081781519111523, 0.29894363980614547, -0.21038686674804671, -0.080370032503594577],
                             [0.30817606866481179, -0.24912684185357317, 0.019146331268152607, -0.10975105944047088, 0.29245303336915529, -0.045604310272587212, -0.37842511880657248, 0.33993224377649323, 0.02708394063105532, 0.22697515855267417, -0.2369181715238107, 0.16454834566897045, 0.034567116021033635, -0.11914132976680648, -0.043238135910906368, 0.36034809396614015, -0.62193763984868722, -0.0051683674807082875, -0.12520088774752319, 0.21391790733238936, -0.40219652670133316, 0.27084582303202243, -0.30278017672770535, 0.49010542087545222, -0.015459369759871774, 0.024509788845067434, 0.35686377519548379, 0.1902426446960083, 0.26814364755466508, 0.48762313649201033],
                             [0.075682668458376123, -0.16063809185726619, 0.60917160641909907, -0.086371529658909138, 0.36309237325689381, -0.044250375653844799, 0.090960848551935605, 0.23636243206019725, 0.20196473123314598, 0.098152151103047078, -0.15268822626798489, 0.085533094584647196, -0.33870032768519015, -0.24067060630405518, 0.14875267671892278, -0.31570525825670293, 0.46002869445440181, -0.0088526768271817297, -0.16730823163203282, 0.36530517476302143, -0.18650091688775464, 0.24874259148068059, 0.29061633340165283, 0.16292110036978022, 0.56615988570310194, 0.047466140215021282, -0.45158814690556176, 0.33051972781381722, -0.22382111458568507, -0.14721083230781226],
                             [-0.19171888216816457, -0.66545923820042652, -0.47127616059845684, -0.035501706242507057, -0.20153976979617799, -0.29969562000599531, -0.12971592382050923, 0.27484161945717561, -0.12364049069216093, 0.5067772986807042, -0.21845422146852983, 0.04919777407569715, 0.085743326379512388, 0.068269477939771187, -0.20710508307341041, -0.18392973830263384, 0.47445763026019067, -0.065513021334474786, -0.2139687513894562, 0.10546628138240559, 0.034734358888213288, -0.49310655445053642, 0.032218412627479473, 0.053053724883953386, 0.22368057210717071, 0.29755101166514875, 0.42392498454018684, 0.0024126378617924764, -0.30420123541149974, 0.058865666448955259],
                             [0.32462794526497096, 0.0082447066371569011, 0.17532906736728979, -0.2251986446450028, -0.14919486343503319, -0.13931533741343927, 0.28540459541534269, 0.1563901160340897, -0.27977914286888034, -0.10494379571895025, 0.12784880345420466, -0.11524241937384722, -0.080014030155445434, -0.075186288819589442, -0.28001733794655675, 0.15004241737017215, 0.091493641394893063, 0.52914927287965052, -0.24899395761474821, 0.23739181339019783, 0.3382000774197943, -0.075343789621540119, -0.22666125141296622, 0.64313510246851213, 0.14051546765042461, 0.18944460991561191, -0.15761470874767874, -0.41390170119429548, 0.27450839630095214, -0.37989251404955143],
                             [0.20660886912438672, 0.30308269940659477, -0.15507374397007803, 0.15133757511325449, -0.26308556514344322, 0.25016149626433037, 0.11214183093734567, 0.36983733714787848, 0.62940270818331756, 0.59254261750117765, -0.35158727046980676, -0.052933516048775803, 0.13409095835928175, -0.026472674799641566, -0.32807822973203593, 0.14223709346160024, -0.07524594814487684, 0.17789362860869501, -0.20424562207429856, 0.037126011018007971, -0.45662313691423273, 0.27574350075987242, 0.35076455518435701, -0.078118911940574909, -0.26020372920478962, 0.062880075521500337, 0.041325600536288719, -0.20968168239902263, 0.1388147780399307, -0.34508874475471879],
                             [0.088078474177968949, 0.12550446972330065, -0.097221121151215839, -0.35156866365222128, -0.34995454326672648, -0.23298956391318953, -0.072082352017691767, -0.18589398821679487, -0.057286412380699786, 0.16910239714522196, -0.64298537034982517, 0.44321433866514914, 0.16715692834604226, 0.13319838315187285, 0.23172796116761829, 0.14110222686335938, -0.083008197656945712, -0.44467177249797341, -0.23280653498199777, 0.073014583755249968, 0.13587162804371186, -0.27895820813353012, 0.098870991199644931, 0.20345118175791357, 0.33636137643291536, -0.51305809893598719, -0.47918649370521699, -0.054682507956161003, -0.14839691635904498, -0.013470582454263592],
                             [0.26462062080649018, 0.14296491030193448, -0.024360302136418117, -0.081429021185806541, -0.066388748062988015, -0.19642029966991456, 0.42503197456577962, 0.13551358686940113, -0.014408934821008808, -0.037130067722435794, 0.21895304412320146, 0.034746867210668456, 0.068365292851685605, 0.50313527799587676, -0.40443979624339677, -0.34549872526391351, -0.13085883596426456, -0.46895997743907303, -0.22669913659595847, -0.36226638039900572, -0.10822444752288796, 0.3168345743694983, -0.030372999492565909, -0.03040442985488355, 0.46101204641714505, 0.1750681958535785, 0.0079422119092320154, 0.42104046351112384, 0.25107996036030727, 0.27178268947516859],
                             [0.065157352142837438, -0.13023627409039051, 0.14521297904804834, -0.32620055188936781, 0.088191301203483341, -0.17752086162550215, -0.30584854684673024, -0.37590037753699879, 0.45097105585053848, -0.090696015310668066, -0.015235223257448749, -0.024489441034463003, -0.13947289932600046, 0.2020842528087296, -0.028417432665347381, -0.15052808213144717, -0.56534047599473536, -0.017583595458486451, -0.075231415736048246, 0.40994893306635738, 0.41701607427390874, 0.18816331343083195, -0.16833567909180541, -0.23307090171273798, -0.094697388041887209, 0.52620808710208722, 0.10452652248733135, 0.17628169936873639, -0.042458231636465303, -0.64355325501724359],
                             [-0.11316343859282828, 0.41481360714887455, 0.041547506060602653, -0.40412577696310414, 0.38791002012318715, 0.17214657049466575, 0.10921120224371259, -0.23775762497930639, -0.11341609368064383, -0.011225598640409168, -0.31122671241645422, 0.025236369840837505, 0.096651247067395543, -0.054689427638494742, -0.040858547601159673, -0.18051736394473011, 0.39018985153691033, -0.068956048232431427, -0.2894509589513059, -0.029006828745028135, -0.16293355007346522, -0.12061157766701711, -0.24200510260508595, 0.24641689271759337, -0.46980812722742959, -0.059980394897536773, 0.13523258855451564, 0.28323984084797899, -0.0258522142036967, 0.072619989144915867],
                             [0.39428755120993336, 0.16242479903957865, -0.12284215410435946, 0.09779108487814972, 0.20543845572865818, -0.24391916608047171, 0.1570222258765343, 0.11019155422718906, -0.18801966336557396, 0.35663989270766017, 0.41647676714858589, -0.66678230502656499, 0.054495517267149365, -0.25659535404124673, 0.17347895534697499, -0.0027555723716070624, 0.13038873827700134, -0.61650155841628884, -0.26402527213964683, 0.27012155345696687, 0.086698037329151281, 0.15533726622753688, 0.02597002226573273, 0.041178671634191699, -0.32872846799065275, -0.15320917142254148, 0.080270404466322484, -0.26999401481635377, -0.40374137212715916, -0.27318775946677049],
                             [0.3740864645074044, 0.38481091517501748, 0.00017236765060519763, -0.28318896057006521, -0.41861082601343236, -0.13228830410848802, 0.084001924386854956, 0.22331624787391929, 0.6839147627230433, -0.2003487033665628, 0.22283512731254218, -0.21376950584629664, 0.38962740634946225, -0.10414067476832924, 0.17434621335235245, 0.099627263154344961, 0.075325161727062995, 0.048632145699424714, 0.26868992503629502, 0.1747140461293771, -0.037997646042150432, -0.15161033699964199, -0.30725674091631405, 0.21278034315211841, 0.04379435479179259, 0.27404412779731391, -0.20685322270833043, -0.011880369313976048, -0.48985042877531554, 0.15430476538675533],
                             [0.011634502178340785, -0.32187993305175711, 0.073090666578399077, 0.42280053344719509, -0.032104977331564727, -0.53183103676402999, 0.49950512405586317, 0.090026733654736249, 0.2299332952934679, -0.41341155478049629, -0.1832362829183265, 0.46088732070133132, -0.040228800585430151, 0.029807450681381225, 0.30244459383212424, 0.15841279397670099, -0.0093052363688053575, -0.069519130468143717, 0.13070121370138826, -0.25178275535357414, -0.11651784075527041, 0.042674370284298192, 0.37490537132842328, 0.42084178452858506, -0.57443107261106918, 0.09778946958938381, 0.14602543554587438, -0.25764415229030069, -0.30257143709402756, -0.089539665552718847],
                             [-0.093701816858485693, -0.53557886175589031, 0.22781072509000708, -0.56648122642610832, -0.54630841494251592, 0.26290512206751604, -0.020627139595280494, -0.3547216699755868, -0.022639095405013569, 0.044507304357374849, -0.19442912499513243, -0.24269706006681768, -0.12748267689599124, 0.083744778278174836, -0.034965133058085976, 0.14811441688560123, 0.13936211373179763, -0.12937584173855415, 0.57851347743291204, -0.27182703869122171, -0.073591748696747381, 0.42498227742100408, -0.39415034334637633, 0.24307050928796775, -0.071988763141884141, -0.29824836326521331, 0.55980547300831474, -0.14882460023965832, -0.072425274279969906, -0.092316052893188616],
                             [-0.13842063906279464, -0.36058324446531437, -0.011737306981363304, -0.25926272555963559, 0.21341192100700526, 0.058555876490975454, -0.040111958513029837, 0.15244347987461265, -0.044186438516567825, -0.061657240015647444, -0.085227724353570136, -0.39914951994759457, 0.067461936611735857, 0.31053152143878993, -0.16545120031641053, 0.39266358191394718, 0.0063303068385877357, -0.15948687223409352, 0.44274046718684773, 0.42123978060428724, 0.15483745132389143, 0.060258764969996201, 0.34994464248940976, -0.089634548135115955, -0.28702106714373549, 0.18233300807241884, -0.6548569121622716, -0.084306435096873467, 0.24489005345521264, 0.27119274622610301],
                             [0.52983852585328484, -0.024505645195363562, 0.21298656322860487, 0.24646740770914277, 0.28797858752526534, 0.16483719783976961, 0.30310097545566889, 0.21233139594062161, 0.20719208606798006, -0.18110621948166966, -0.51422077807540889, 0.13756053727830569, -0.29169769541907964, -0.0014946993786955915, -0.51925578586934207, -0.24527518020212549, -0.02263603542455413, -0.31805221535702305, 0.049045400230132201, -0.11950577256111355, 0.37577770910799979, -0.17652051202815169, -0.14148710490253186, -0.33646553460224632, 0.19537425925804217, 0.0029380778487493524, -0.12032899951232703, -0.48341119366077107, -0.24544386632861653, 0.33110404069156851],
                             [-0.46892114214917457, 0.28494474875207909, -0.13120555948384571, -0.15579932413788317, 0.20352625127331811, 0.13376788992835803, 0.16414137828329436, 0.30413172733595562, -0.32534651121217228, 0.29416690311365495, -0.033288119605936257, 0.30491994838123981, 0.15322546853598396, -0.034337833301343254, -0.089274885679957908, -0.2674368781072215, -0.080069019157334304, -0.17237227834724153, 0.30047286348610353, 0.07766578288019059, -0.3521780234860426, 0.35017874319145526, -0.44764217781882903, -0.019168169618099345, -0.016759619506422005, 0.14719695262325122, -0.35815035176117316, -0.47988873344764027, -0.3754223090551978, -0.25289341025275236],
                             [-0.15522742418551688, 0.14028950158834955, 0.5960363570731303, 0.11767444577682461, -0.12468749483419873, -0.040970374585742153, 0.064810632236571949, -0.058595636674697749, -0.15863134473584806, -0.0057481794176705639, -0.0037659854305977375, 0.025202990635674452, 0.082596869333575657, -0.35699966680742823, -0.49292583607507223, 0.73340056179496438, -0.16713671891487342, -0.19191929531641572, 0.053149538733532287, -0.0075718559568516419, -0.0065557167116692822, -0.55494791369774443, 0.2639268062389295, -0.0012235816824143764, 0.067414583796220812, 0.23349221448202534, 0.1791290652483109, 0.15564643996140998, -0.23432941726542719, 0.10678750324107202],
                             [0.17001850385730211, 0.24777387605711776, 0.34919641006633373, 0.33172149351032754, -0.1968677503353376, 0.18215058617897864, -0.23495719792965902, 0.082644007822887042, -0.076260189798225159, 0.33977212434315168, -0.22039964125781086, 0.22640048472062085, -0.20479470046301632, 0.57324403049844552, 0.27203502709602967, 0.45785600537936222, 0.39112075478457931, 0.22615323155659134, -0.26452980833575579, -0.10099827781398688, 0.062142306728768019, 0.18845714062443211, -0.38925913099476755, -0.20986536819227955, -0.14664941743387697, 0.48880728153537989, -0.11000086823642452, -0.070774709445781972, -0.24883440663790554, -0.10539824938030731],
                             [0.035928833116115722, -0.13182760747875696, -0.31377929728088805, 0.1752531696164536, 0.34668367309434345, 0.10032643390704696, 0.073797920951149468, -0.58221472261860463, -0.011118317859409858, -0.47171040770894407, 0.039617993150255285, 0.14910098378207232, 0.43764428214144901, 0.041392186147772993, -0.17867585246901699, 0.1582994887425761, 0.22958707996159788, 0.070096440473147267, -0.23452596788473071, 0.5038583262844889, -0.31714741153523623, 0.31471001758505768, 0.22405987980427466, -0.034163974789449505, 0.34308135756717373, 0.18073055890723894, 0.16851215375473186, -0.23381495567727598, -0.094250850892890398, 0.27735318449367463]],
                            [[0.17644374456162507, 0.39416526458934475, -0.21370416581424298, -0.25241081285513994, -0.15946628305046481, 0.25647277375891803, -0.26947654490172129, -0.18392612363904079, -0.27771692904847578, 0.1306852590682, 0.07058724648737548, 0.063515992395048196, -0.049209198693974131, 0.07048523395840027, -0.31759929284866228, -0.45282319303023083, 0.37252955508174906, 0.27165685957195651, 0.028833290398219191, -0.14336110975748653, -0.20539095926579409, -0.13088037385570095, -0.45503984907257589, 0.51064039527470961, -0.1136868332753047, 0.20734020893202657, 0.10827278940405693, 0.25742581075084092, -0.28673387304222936, -0.33355573882277062],
                             [0.08641813877514172, -0.18056750401573191, 0.36397886386738787, -0.083764083119383229, 0.73870618153642664, -0.2777993335633584, -0.49489959716147502, -0.07474770106637775, 0.19559834798595924, 0.3096549806863359, 0.11750631803559833, 0.52614038784495998, 0.20076753233112593, -0.20087368495744243, 0.010308567904485682, -0.14362992807583047, -0.18438743757350501, 0.085639467159923072, -0.076763841761759724, -0.42410287218511949, -0.21689652512497151, -0.11652200919948597, -0.19779851377264945, -0.074340823580376206, -0.10807086755340792, -0.11856715938573771, 0.39441759622317424, 0.01482541395404656, 0.0055054824629673892, -0.11513929621627407],
                             [-0.39159848883906939, -0.047480939834201333, -0.28920611350164993, 0.18265246784953476, 0.46722937168742656, -0.064522756406634546, -0.051475975847723579, 0.10887684535222857, 0.77720666329686583, -0.043204105766819559, -0.33045466626510872, 0.11414597552158028, -0.12906521373351917, 0.13008129840276605, -0.45490779862083425, 0.52460814839609882, 0.087061231751732443, 0.22062574312806163, -0.052861457273160377, 0.1664845715334847, 0.12183304561252127, 0.004007419728629732, -0.43797644370444333, 0.47184163223227105, 0.070102430953184497, -0.26607019036880453, 0.43393999787966675, 0.29810635678279312, -0.036876579323028381, 0.085739415689135956],
                             [-0.47049128094596798, 0.20863345444439907, -0.23633037293171669, -0.071880217450239745, 0.011657014213775484, -0.14888154011681215, -0.030221038818496165, 0.37701824304763182, -0.080072093653220947, -0.18856055221734286, -0.20060461412881531, 0.22725184200154411, 0.24834814835976948, -0.12420158335931436, 0.4306900725515263, -0.2088728510398099, 0.073578044855552499, -0.087381003313356659, -0.65667512537072592, -0.160366054443284, -0.19562727191361826, 0.46090927342697957, 0.055634762825646618, 0.1883959686902667, -0.42499877625919963, 0.13246174412225525, 0.1817272169690333, 0.0053874591210241185, -0.16002411529031019, 0.048940674585589691],
                             [0.12936931456373049, 0.47053538192922251, 0.16022553906269552, -0.067896499982821337, 0.50332166958497049, -0.029654684883595166, 0.33684411166957295, 0.53232315053568513, -0.11043441090062277, -0.357196002049323, -0.14224804134755301, -0.20472664005764876, 0.17170382696103839, 0.16441946260487456, -0.058137291444621028, -0.065329885726115908, 0.12497799721045685, 0.39511614241334336, -0.11960908955893652, -0.016800891986349386, 0.17210738629584379, -0.13299171254491077, -0.008451919579429569, -0.12952182199665935, 0.080501560891524909, -0.28777294758050903, -0.16287239844701806, 0.043281187636356681, 0.40608221683213058, -0.38237555965386355],
                             [0.52300275512391248, 0.47870305996162732, 0.25957883994476888, 0.046134609170734746, -0.016459475771321827, 0.20458322848209542, -0.10148017259324257, 0.23712046608616122, 0.35398851625719818, 0.25499854023588925, 0.25231961140528564, -0.067272346966143676, -0.35008755795063545, 0.22198714703966754, -0.087352758990021886, 0.025819937579195353, -0.25129772191789257, -0.081362786117681926, 0.014147655898883629, 0.1357826015033673, -0.55858168766316496, 0.34317912555994567, 0.64622884269760905, -0.083971748389891618, 0.13624126377829043, 0.24132679218241329, 0.064643543493058148, -0.0024568055182133952, -0.40217012333857466, 0.14381155175675836],
                             [-0.12573657327240512, -0.21351349225173422, 0.040242011810906801, -0.50623870569604112, -0.19782405441574755, 0.023198746902098253, -0.13637207610530144, 0.34300759480102222, 0.30905074989060016, 0.23943751959237344, -0.20466826611180991, 0.47335740190299141, -0.015798470539347822, 0.33920991261770611, -0.025425858833460983, 0.034091749459442634, 0.19906913380093855, -0.43989589431428722, 0.15051818703674055, 0.40288196200275583, 0.2924404939215865, -0.32288941642249658, 0.17816528527220388, -0.48668209737953311, 0.14845326678979243, -0.1923414458797523, 0.21025627690102083, 0.044406163440874148, -0.14016232217072405, -0.216600096621131],
                             [-0.31150110221903288, -0.1636780497584453, 0.23541577759720181, 0.19002781292607746, 0.13438489899570893, -0.31818063243939587, 0.014231888725392008, -0.22945497549164703, -0.13106465171221682, 0.26078618006219351, -0.13772315025857371, -0.3863953718582685, -0.17454497195312951, 0.63808220240613911, 0.0092571069352459009, 0.016687997643618217, 0.018761910748810558, -0.17691035233824565, 0.12579316676237301, -0.10595452666288749, 0.084856589167328064, 0.0048916157700845337, 0.092577697598705974, -0.024368585686196258, -0.67188053175875295, 0.0085263202395543126, 0.026710214713346257, 0.35546195836458927, -0.027758113111641246, -0.29398131810088685],
                             [0.16281777102917608, 0.001171524858054579, -0.34647120169024559, -0.02920095610504593, 0.1902853228687692, -0.067629828359371605, -0.0083442367861310748, 0.0078101796646527846, -0.35903385077318312, 0.13786551089138238, 0.19992284631684423, 0.12474593676359401, 0.055214171500260603, 0.01192631334387826, 0.075425657515557659, 0.29028197220191404, 0.35232798184124847, 0.06365995768204169, 0.22695444370740972, -0.33414818287304437, 0.0020307542841980081, -0.22745176495054176, 0.75825232488836081, 0.40527338592394102, 0.084401352441745764, 0.36158104829903998, 0.30305299818371928, -0.11718868269819567, 0.34028823013971843, 0.13531346619337076],
                             [-0.092691282232387609, 0.046238430808030091, 0.21147707010285022, 0.18753929172941278, -0.13060903942133156, 0.29791589343327196, 0.19276220049302303, 0.13169290989821805, 0.10160671990462727, -0.249030417217878, 0.30508063241265138, 0.14913901754014849, 0.2482478707333608, 0.5083162222952976, -0.19944567484037254, -0.25602539041173533, 0.14040645643211719, 0.08585816515960798, 0.0066509237659145987, -0.10879909640113858, -0.24447165808966431, -0.26725717500623031, -0.062416296694998499, -0.14040113697733889, -0.13512077852544668, -0.17280376869442876, 0.1749954104929787, -0.29927269461343831, 0.15666705092144767, 0.70527086851981857],
                             [-0.37740840071654208, 0.016143276860535162, -0.211123550565677, -0.07376390896012186, 0.23151937165474704, 0.63446234854085048, 0.061643805865352855, -0.083061401696891302, 0.11458951961791583, 0.58174854119496944, 0.43720928816944621, 0.19501744951385633, 0.13167486452737204, 0.018443411219909209, 0.060047008544905113, 0.17076128171861588, 0.060314450248316512, -0.15552471610413082, -0.18325677532698631, -0.19062990835875832, 0.28122703413236461, -0.11507308320625087, 0.016351975735106151, 0.026881127207651758, 0.33411365017233313, -0.24736445532563206, -0.72998546898429051, 0.24196288479102784, 0.004122721848004697, 0.13606617145306638],
                             [-0.066722350009425946, -0.011342608747307428, -0.20905287479354454, 0.35555674893128414, -0.19699608091524839, -0.33118694473073779, -0.52922209198723091, 0.46624441286106483, -0.11605098197886798, 0.096270150495592732, -0.14922093495424421, -0.11819828823251204, -0.097000613001184746, 0.25613288284059532, 0.011082823503315461, -0.17675909726855335, 0.072459519889757032, -0.3454815101414172, 0.2272604658827044, -0.12645534219966986, -0.075249922534535205, -0.27617288332360956, -0.12705643900421312, 0.31032580160412632, 0.39489356531216346, -0.088356029588305823, -0.33294543375735525, -0.14341628590681685, -0.016285558965265179, 0.18462888159649044],
                             [0.3217961079983977, -0.21332480398046641, 0.095132350402742469, 0.32862195933999416, 0.062708205824159521, -0.10943836463137688, 0.10370022097550756, 0.24785655404521542, -0.12334100925406738, 0.28418490391472995, 0.22914739265569709, 0.031435833740871742, -0.13193586493659717, -0.1926487300655304, -0.0068164838433049735, -0.40050271915045033, 0.31738046835876599, -0.12125768068311024, -0.16393790730542851, 0.20830890481646322, 0.45874004225719378, 0.095409441466283038, -0.14988550542927082, 0.0042349168454889957, 0.11663984688687047, -0.026133942623437583, 0.26101192907894905, 0.57772709201582528, -0.11772435711257009, 0.46524611831081925],
                             [0.28029909463019209, 0.078606689551403763, -0.2081640444164489, -0.011599070232985188, 0.065446236361991261, 0.1671355799125975, 0.21734983906739708, 0.19729240510603438, 0.051624351273994278, -0.10854652345218217, -0.16589929798054112, -0.012753288031622088, -0.31215854937727294, -0.093119405888105605, 0.4651411516999106, 0.4687528561652482, 0.14623204255085323, -0.08496465404735036, 0.56827746839846904, -0.25215087193133301, -0.23883274626118489, -0.05955528229392363, -0.40750215493203962, -0.16508615560481696, -0.45322751770319714, -0.0069362491736986061, -0.1691429372993512, 0.41592725791908092, -0.089708696586220146, 0.15447006105560554],
                             [0.38681093118418369, 0.44751699721408233, 0.10977305444020059, 0.13665151993423974, -0.18668563892112167, -0.004103738727075602, 0.010368163792487952, -0.31845618772806539, -0.14447964853635742, 0.057992842050511723, -0.19353667448279516, 0.38256837542746269, 0.14232974323535208, 0.26673470402020372, -0.40682758734664221, 0.20228158890382561, -0.2942976961165476, -0.39020669664831698, -0.059846997032913379, -0.071181305159101732, 0.28033029112862817, 0.17020463039140249, -0.073865545653279949, -0.1590901149575977, -0.11703092056169821, 0.25390150962487795, -0.015469738766246639, 0.21446789635650237, 0.66725710919642112, -0.012474898007556086],
                             [-0.24269959480899103, -0.052088408850396631, 0.11045206074693956, -0.036838870328401864, 0.069133658576902346, -0.074033161429363142, 0.83181784702891326, 0.21598444721563867, 0.080756085893939497, 0.26716556375033634, 0.19142030516454756, 0.28931877291270319, -0.192178845395233, 0.12539212370348568, -0.0024103440262921326, -0.18644515335998602, -0.38149797974923505, -0.40631922164358725, -0.028295473075212962, 0.085393268623604815, 0.035805381696240091, -0.15735154287815983, -0.25062535578354528, 0.32064873497012136, 0.16177498272002977, 0.071037819825948201, -0.040091509339247211, -0.3861127793481206, 0.071496835470885992, -0.1255668944865663],
                             [0.015754868172141678, 0.26668826228969844, 0.11834498754407058, -0.3428531073896629, 0.19000991830282715, 0.24928716244118979, -0.074920533706270276, -0.049847652019823108, -0.055482882514279609, 0.37069289867967886, 0.099224049781912377, -0.73073250686062186, 0.51589373881545586, -0.12179015146793395, -0.042824866988771491, 0.29519156892532733, -0.15803141120621061, -0.26098965956693881, -0.28812227127350309, 0.15532600925614504, 0.026782629282420947, -0.49303399639684592, -0.24874933336148913, -0.11529270275152979, -0.020715373341525428, 0.11061015581263801, 0.34342176071088698, -0.074757581819364594, -0.16575059719157303, 0.32629848796064848],
                             [-0.2427470754865472, 0.1420675541073507, 0.045400774922236257, -0.076181581703439083, 0.12359005532494394, 0.036664853285292523, 0.03408972010029044, 0.065289138425005624, 0.077388283724595622, 0.42136597174542956, -0.5293807152884461, -0.0070514534412318836, -0.24435818947073315, -0.22384329142289258, -0.2853971496395134, -0.24082331162155921, -0.096123127516024975, 0.4461041642574074, 0.11502503610372394, -0.30602952533274974, 0.021357540585772581, -0.26636869857994477, -0.017243477146133515, -0.22531746687082005, -0.015963410807399644, 0.59163909657631331, -0.14070441188943222, -0.096153439717851757, 0.022036993887892788, 0.24003628650710288],
                             [-0.13930897596865005, -0.39553321561120014, 0.23119702656281746, -0.71785819692517894, -0.027526833590838747, 0.26607303641637753, -0.12446099516096175, 0.61180535184435347, 0.23776348560132249, -0.35157837241579715, 0.043973053276304755, -0.21380538391370324, -0.13244313553884648, -0.18983370570067445, -0.55630655449538347, 0.024719018502776656, -0.18731135143882285, -0.30219023765983888, -0.24733899516571528, -0.36285015703618828, 0.218968989900448, -0.049459458074856751, -0.00062827966750084868, 0.27358617288823467, -0.094590792388490635, -0.077437279283413846, 0.093619299787171553, -0.00055661983617581734, 0.065262343162529962, 0.16012261609076148],
                             [-0.39617274554478316, 0.042404376239426049, 0.40885013691741823, 0.11924512317254936, -0.034476636610796571, -0.061741092917660612, 0.26930831275289263, -0.0087657861396296874, -0.057530608344329992, -0.36629126589968597, -0.0083355496499067684, 0.061351270079003754, 0.45481347947244405, 0.089129437055235475, -0.15511461696674905, 0.27972225015224428, 0.054891455813646288, 0.0014169276029335834, 0.32565644745920846, -0.47739797111599364, 0.048907566858721302, 0.10517109696637304, 0.010325046766902352, 0.0030907832482216951, 0.39886342544108744, 0.32750966810427501, 0.24883704231175477, 0.33412801558254035, -0.48360692097246943, -0.11251022678757304],
                             [0.2364681259406464, -0.13639836993550344, -0.24682358571529539, 0.041905693383292669, 0.25307923968952639, -0.04802707983882866, 0.25582079863857538, 0.040779140798621459, -0.23394773715955069, 0.26124514622744927, 0.024490147138680557, -0.050718383291112529, 0.011462709452495709, -0.15463305659094648, -0.73813196508307066, 0.29452420864160422, 0.42248575825305629, -0.44458975678096979, -0.23180492382289286, -0.14924920525330582, -0.28973089258625939, 0.1311350332607433, -0.020898736717391682, -0.52918883296839991, -0.00044017105841045664, -0.29621291531609789, -0.24286633104560196, -0.27257690671853363, -0.31599397227495574, -0.11236611460435797],
                             [0.036861082176123786, 0.053695462542269673, 0.52141622829949086, 0.45768868718013817, -0.51087737399553568, 0.39506692165373258, -0.28188390129780538, 0.29067723239417975, -0.096681218236685476, -0.027462589971230408, 0.3270237633643136, 0.21215639886765347, -0.41251917476596339, -0.19892227745877558, 0.076904773362002313, 0.60119221469301964, -0.041422282823646121, 0.21620788076370609, -0.26961056272692774, -0.020085278937137373, 0.16084169488399147, -0.048877283550064904, -0.10147628110223857, -0.022360436184683224, -0.27856038927729515, 0.23138711919766863, 0.34433163662162097, -0.32601373744010431, -0.15680686092585822, -0.12504526631774279],
                             [0.02947059711418441, 0.17555533752498875, 0.47723162940419661, -0.34885552465560371, -0.13874245887846456, -0.16989247287031539, 0.074210789126586518, -0.17194619039345638, -0.029211248853193237, 0.5244881253715209, -0.15276776955163704, -0.17464491175448638, -0.31739454629055808, 0.37722233990179482, 0.17722008977209083, 0.31759576543140056, 0.45055551915611231, 0.024145207867792812, 0.050697386214416898, -0.24657243689743411, -0.15765385753319666, 0.48197210718648642, -0.12905559718300508, 0.15464080971369704, 0.55935047492763823, -0.11251643679979995, -0.066555413606230074, -0.27142848203048225, 0.20467368032981198, 0.19550166943035646],
                             [-0.4414103979711958, 0.073025572214139287, -0.12752785143013948, -0.17395052032086067, 0.037176706217017262, -0.2764745503606803, 0.15327202585472752, -0.063292343997962949, 0.1558009193968371, -0.15113293327707333, 0.61135999024914955, -0.085475210315181654, -0.30730388296477079, 0.1544180959684561, 0.072089223071676048, 0.080030720373608172, 0.27094129402317435, -0.25478482405307579, -0.021416669297141932, 0.084615432891395476, -0.37806834761954394, -0.11630806114956109, -0.24331754068354822, -0.36696559345318341, 0.34326210752338493, 0.34642237611131782, 0.002525979489132274, 0.58118908551983395, 0.39100476702127895, -0.039063366508543008],
                             [0.092072455593109531, -0.060307417491980098, -0.0910803703230149, -0.10297336563925635, -0.299892183882843, -0.49453510134454126, 0.12416967113798998, 0.11286909930193056, -0.14478984075517912, 0.028312109267194588, -0.092940490944898674, 0.21135505220840078, -0.26625440732173294, 0.12436125828067066, -0.10411238636105853, 0.33978908410178293, -0.33703579755128754, 0.18250678757625313, -0.56652748835596578, -0.051824347237529149, -0.23864685419982876, -0.46845655020112903, 0.13893995376751614, 0.022458838987147917, 0.060399769829389188, -0.51373190085817966, 0.022360272032710946, 0.27704827850826214, -0.15433135512704751, 0.21164548174944728],
                             [-0.012351581212596031, 0.036194622030347012, -0.50658752059887135, -0.073916808653748126, 0.28908514411976177, 0.21315144434696109, -0.23478037734071827, 0.16531905712814651, -0.39038513672980746, 0.006243253526130671, 0.21255884677654266, -0.014375808002434935, -0.22557592326375597, 0.41262283818080009, 0.15110130449289083, -0.054590542352572428, -0.54546286936460153, 0.16705703622137069, 0.12644828165921609, -0.1776961445332117, 0.062128659373112613, 0.42544923139094504, -0.11489447474137626, -0.27860839032600437, 0.24427009927555343, -0.050645790978651246, 0.41773946240462156, 0.0078110106565830451, -0.13288555006931954, 0.12584462364518781],
                             [0.31124212149184821, -0.75756851242485868, 0.033284785993728645, -0.24437141312173621, 0.057590057921902048, 0.083524032184435645, -0.048562052362560088, 0.22031199137147883, -0.020765965263323475, 0.25286367521868464, 0.028809859355843334, -0.064835764909751029, 0.45015157719566962, 0.31656494467143437, -0.034349265564874359, 0.039787767298429873, -0.015985969232363104, 0.2596615185855326, -0.22029672647405615, 0.42562773804767845, -0.38785915349232197, 0.081481701727120451, -0.24552170731526762, 0.26004110984231782, -0.1179108572632766, 0.51709796547873232, -0.3303475343192071, -0.061274716884384843, -0.017236535953230075, -0.080571067109531283],
                             [-0.27014138418233491, 0.051950185078033909, 0.44170685367529239, -0.066446904060876708, 0.3302996976108144, 0.11882554997068827, -0.15591268990755935, -0.13194925314860334, -0.74315876693225957, -0.26953711704395505, -0.29129514738466988, 0.27619876516620512, -0.17899748773808288, 0.023632167113426875, -0.013787645481733073, 0.021336404410245827, -0.096967169897103009, -0.11599580758009899, 0.07745545435896467, 0.54508058293304151, -0.30020984664920813, 0.027891095640052321, 0.19501181612678309, 0.3306203032865867, -0.050254083974377056, -0.0053294021813229467, 0.14794383964688754, 0.26720804525946784, 0.010132824573456337, 0.17082755680246892],
                             [0.34472353308216014, -0.33884457954299202, 0.15009218466608354, 0.13964303613962137, 0.11070415567631341, 0.54436887368402087, 0.069526673826361976, -0.30059991290159038, 0.13954263553632962, -0.15868952452938795, -0.20669699528286767, -0.13239571831421476, -0.3755345680878851, 0.063163874544722248, 0.30081239620552114, 0.0028314414608571147, 0.049290555281722909, -0.24942700588676808, -0.57135585128768818, -0.16783440564414259, -0.20784669866010821, -0.26448304988690186, -0.041718061642814441, -0.080504560341128073, 0.3590223860939466, 0.25666549039859926, 0.14528666669340493, -0.14279406161362493, -0.075831255156983232, -0.09834592941419143],
                             [-0.24151488204402705, -0.34095490703117393, 0.026991729977461507, 0.27801171572845901, -0.34944481095460778, 0.29164312960753674, 0.027626473634301048, 0.2192242141557883, -0.047946646043675892, 0.33912783416672543, -0.26131503989359273, -0.20150472511039447, 0.1756359873158482, -0.35619035776204255, -0.05254345540764465, -0.066630942032948004, -0.065679939450178609, 0.16544824893778681, 0.17539280671411869, -0.085924341197044479, -0.37547522662285565, 0.039683509154704956, -0.0092022959790619696, 0.15449222919404609, 0.049723822145480177, -0.32114713899993952, 0.45704084696076586, 0.31417984825791967, 0.35319986182375929, -0.41154945647804853]],
                            [[0.036878886644377495, -0.1074987803970899, 0.078504617804631749, -0.087061325410878715, -0.38540285124603918, 0.04671414150950489, 0.4055323236595243, -0.30658807591224518, -0.36953918927825463, -0.068422813143201089, -0.13140905862010943, -0.23677536998875823, -0.50493887602175547, -0.47709155063613784, 0.086567117187598797, 0.21142775172766523, -0.38271129913324531, -0.17876604660725884, 0.34521418941658499, 0.19358323854449092, -0.44029081165723222, -0.17201590358702043, 0.10910187188715047, -0.36668356109142458, -0.10709291661844918, -0.17274499072742105, -0.31164223846014732, -0.41290432103876734, -0.20895814274658311, 0.57959859025709526],
                             [-0.33732784409923705, 0.057577363804991316, -0.4763899716481057, -0.060146491125425798, -0.11223979861107342, -0.035412745647091917, 0.14915523325817581, 0.078322437506542331, -0.20088448045119886, 0.3725927258885432, -0.18381056898315901, -0.19351128271502302, -0.027588460461949519, -0.21309916714327071, 0.41153493444847034, 0.29381100724929043, -0.086513950567500261, -0.071560085703825896, -0.54634175872761137, -0.31634755548207028, 0.12851394641968519, 0.6976288996656268, -0.06861967531195888, 0.26821992593566418, -0.027854518154083324, 0.36709848509878706, -0.093449945769316797, -0.35811716417582135, -0.073720705721022267, -0.056154260898341149],
                             [0.16819029360483445, 0.21141576763713857, -0.02805994563065518, -0.35669598915283035, -0.43038499477264125, 0.13684649336280474, 0.017192321496465809, -0.10727963971369368, -0.30793682047556947, -0.40005718528611378, -0.0083086914203310634, 0.19566058031754119, -0.21395415454431993, 0.17122655474361623, -0.077737882483512516, 0.172419639031657, -0.46494274305947447, 0.071842883452956571, 0.15181963125029904, -0.075471825741024068, 0.50217010996256972, 0.19221675948769998, 0.40108145745462143, -0.13130732703917811, 0.37916602726423509, -0.056229311740710851, -0.4971307110617636, -0.27302776018139385, 0.17310665588117494, -0.60478851984727733],
                             [0.49207353786914226, -0.099652395261655036, -0.20741675293155878, -0.014072908001212423, -0.1603042193734677, -0.011654728369554196, 0.21612730162349589, 0.45447960599931914, 0.19324794268936871, -0.58511048797285814, -0.31228022471271766, -0.14649614299975991, 0.025903523781746464, -0.033454986533772671, -0.072011819178801867, 0.15648671972930592, 0.1627542155260889, -0.56594488248465979, -0.11538602740581964, -0.40708101197734536, 0.33875418486283493, 0.0084449582518207177, -0.25361667671562405, -0.57698074850362846, -0.24225853525453689, -0.10801595271966559, 0.017030778241077366, -0.21014866161212195, 0.3596906279623705, -0.20912045277921892],
                             [0.49496440649437029, 0.36308152021984175, 0.0746607499831035, 0.18868166658429134, -0.39253910807249198, 0.13984220448029586, -0.1495748323364969, -0.05963206143091003, 0.21039372025651626, 0.22265218491058214, 0.22152690995435703, -0.16606840244816426, 0.079106536820984424, 0.16891817878483686, 0.36446490256994246, 0.93337594261880918, 0.11225811835871177, -0.043918252803769257, 0.02758634967604575, 0.17920131725322208, 0.28715868936671751, -0.02716703693579213, 0.38020521381627809, -0.098843793631094454, -0.10336723796324652, -0.21377914302489942, 0.37901413483193175, -0.086666845642383625, -0.13209956298256542, 0.30582513326103739],
                             [0.059419967610122575, -0.0099545989359352618, -0.076486466784931192, -0.53196669361950544, 0.021835259261717109, -0.13794831972566465, -0.15653314086176795, -0.22812735138028434, 0.054188492742713736, 0.29787723803617866, -0.38921741390246856, 0.39950464038617384, 0.037386379564720892, 0.21947214234430007, 0.083069078339362487, -0.15841108355880207, -0.23993389785331193, -0.38912076793375416, -0.11853941809002318, -0.099695794605887178, 0.20649855115360893, -0.3389205851757357, 0.15311659725343008, -0.24484489680075067, -0.0051468095470103021, -0.4802113350961611, 0.019234377544713882, 0.61042715300948702, -0.23058802939940432, -0.14524552588636902],
                             [-0.072122237703556399, -0.02001912343924693, 0.48425734323543301, 0.38656887709615956, -0.18884585296182771, -0.07430569200137345, -0.18050465423535531, -0.0058670635329091721, 0.010148509739481558, -0.13254637408405495, 0.39916389979757555, -0.0021496160167359031, 0.14219155100559436, -0.35604001684319725, -0.07329566761747322, -0.011468250572352033, -0.005014132105730788, 0.074456939058000382, -0.3604555607744459, -0.37031652680884969, -0.20336888723372198, 0.091146666189247591, 0.40753031024026715, -0.034754763425816071, -0.5133984346130086, -0.13676874448910473, -0.36738857857517293, 0.086069240170393135, -0.40054124239373595, -0.61504541226492726],
                             [-0.09887895687604259, -0.11787104096855328, -0.18303031670489489, 0.28482952884449325, 0.64928401765054089, 0.012236903532627675, -0.076244471183503026, -0.20581007099953269, 0.55415906390399006, -0.23653734458057601, -0.041460293101785353, -0.15527006202330199, -0.3057027531229613, 0.24556533366622582, 0.11951123705115947, -0.018869645026172225, -0.41141504360320375, -0.52299814140065792, 0.13878141104495831, -0.33119571650665891, -0.14391056095177884, -0.25251517507172128, 0.55463965857862929, 0.11959210718368105, -0.19924906680265847, 0.3146767347702516, -0.3146339235064145, 0.07640480143153669, 0.25545581915937837, 0.075951977910495988],
                             [-0.11327412145230753, -0.41826657683456558, 0.082347662118640183, 0.0092486408480062753, 0.11968189969745693, 0.13455227857580632, 0.38719702760151475, 0.26039221452441652, -0.065057309722334047, -0.099896658627397772, -0.069722029710415565, 0.15979295283112835, -0.38992410681745199, -0.015287679695500433, 0.27433236257110849, 0.024201464219488066, -0.016176243665582492, 0.31801555842167284, -0.065107610911405517, -0.29950864518525466, 0.38073021758461012, 0.21374900429622562, 0.34657028128878614, -0.088841907476874343, -0.051492121674489695, 0.18098939679853784, 0.56768910839612341, 0.45789793915407606, 0.22536063143122492, 0.33859362182365643],
                             [-0.078103260272845837, 0.11805891660469101, 0.48336866377509718, 0.16832030898063538, 0.30339428108312633, -0.22990168573439437, 0.35734157503225955, 0.11940071719694513, -0.31734448130927589, -0.021389016667857245, -0.2926700488395822, -0.097472614901388782, 0.36503725592193825, 0.20258437762714276, 0.378115985822917, 0.10941840826982796, 0.23799153647446264, 0.056057810914767872, 0.17273151568481071, 0.13084579135094687, 0.1676459398283649, -0.29433953296401438, -0.16829886182763956, -0.51012843308142886, -0.029894830057333083, 0.56670791750569049, -0.54671541773227883, -0.07249891851065815, 0.10332179361574959, -0.28362876048487023],
                             [-0.089314929759194917, -0.17663352711138494, -0.39156704143919258, 0.17688256795600923, -0.20867091474333008, 0.3225484421023182, 0.30128267394096903, 0.45242972609251825, 0.0053797907716776399, -0.52035180186332231, -0.23276716715632034, 0.39408007607323198, -0.29978648057869672, 0.48216336786280178, 0.19446051205041567, 0.18660123042309446, -0.041065963044784701, 0.16859481165880078, 0.17550877091088415, 0.086383404599629302, 0.023195180524008395, -0.057669236798516023, 0.01623101047044136, 0.53828543580913346, -0.22318342953588133, -0.44771459032551053, -0.43667558026970171, 0.24900442002920692, -0.242333907917713, 0.11961497289062629],
                             [0.34341736125627181, -0.16401097236702719, 0.20948623054000615, 0.142876136338247, 0.10239153597747259, -0.52788029101421896, 0.033089117925083469, 0.1980489924094529, -0.079038932636914944, 0.34758355103498162, -0.1621571234195377, 0.58213564620567515, -0.10984899350247709, -0.43444900752469268, -0.33030113337130612, 0.34507023799363817, -0.4453967403611348, -0.13094129940764745, 0.46556337643143214, 0.28117172160073572, 0.29905302522964383, -0.086935613098089101, -0.043136870341215973, 0.34410454743681673, 0.0035951336161471874, -0.022669927217886594, -0.14122483926488516, -0.24552141971903615, -0.18178490730610197, -0.11590540671442938],
                             [0.5289847244201108, 0.58599470515526508, 0.092257223077897355, -0.25395062444460514, 0.091865595749750673, -0.29430407999788982, 0.1798902161657025, -0.17542693325175862, -0.15580839199618157, -0.029486277411944165, 0.56908282638251206, 0.39260156366936355, -0.050434560105278241, -0.024106159886684742, 0.23887563627936842, -0.033364277510149878, -0.15724401327227913, 0.075720689060482044, -0.21466792558054756, -0.11636786846787092, 0.094659030846892436, -0.096629375064403222, -0.42242315852083528, 0.2122443303414919, -0.12969809590465187, 0.0034357017277512544, -0.16358901008687698, 0.20310460047953943, 0.16239251529788273, 0.17058228024726543],
                             [-0.13208741059260157, 0.058502267368926213, -0.16364213942189149, 0.24705074310145625, 0.32929470165571151, 0.059772840925984838, 0.25832349503845847, -0.27714028792826867, -0.42201023632716028, -0.52739368328274838, 0.19292656889305729, 0.045923128022631141, 0.11848774637192885, -0.015955520397137157, -0.046640189929155404, 0.2314851640512928, -0.19156148859707711, -0.52335084731833614, -0.074134453681217696, 0.7315611944350876, -0.079077615182557334, 0.2821581916836578, -0.094111240070123975, 0.06232978231999723, 0.4183283220087386, 0.23849747485428016, 0.27822933906149921, 0.30328645717215441, -0.10745251013577015, -0.2969760386371727],
                             [0.1185530540208047, -0.31729868483594265, -0.27272819811642862, -0.30223988459162038, 0.13746536837123877, -0.030679476282663674, -0.3075115555043435, -0.47181952993643667, -0.15157471430598163, -0.16000335232110335, 0.18612296674221884, -0.31295988081783188, 0.33411702680058897, -0.1506247755963227, -0.05475386400600523, 0.50610809964453496, -0.41419023724564119, 0.13477597773145078, 0.48866714005706707, -0.53122734420044448, -0.077367333551390666, -0.21299955944232324, -0.36443043604156639, -0.0038088323094011278, -0.20611565322127623, 0.11275778384047266, 0.21851729127812927, 0.20113926403576343, 0.017314287499411357, -0.31063195546779776],
                             [-0.2237457245650846, -0.077729934464930137, -0.34666843210877873, -0.44851871900619739, 0.43007237883556748, -0.2032416291535491, 0.14917193924424799, 0.24312423199600283, -0.24935243257644382, 0.23669970788150083, 0.5147698940731017, 0.21859673994303719, 0.36158351379326553, 0.22609683601928643, -0.11608106411886261, 0.1766894981747914, 0.07721192949090798, -0.042311214080809303, -0.036685671181313176, 0.18735641532934577, -0.11772827484796017, -0.053182738115576202, 0.26522112055967867, -0.12918564425183091, -0.3819199728547058, -0.23329315270975121, 0.18726877657575428, -0.37735167803120012, 0.21485225948701417, -0.10084246398231406],
                             [-0.4046334374093758, 0.67479051673315971, 0.11323373856957142, 0.18773571819610088, -0.3011837433528512, 0.061183743318397141, 0.12099725611021471, 0.42024299011628713, -0.24244858289212742, 0.49286752580010645, 7.6382638231694763e-05, 0.24517004790632405, -0.34975235412135003, -0.16773801242984085, -0.02949108787820752, 0.058615739738704389, 0.018904068549999591, -0.31457278683387174, 0.41017356394780313, -0.11220680694473571, -0.60569302778833611, 0.043180726889646338, -0.072851371595205466, 0.1074458824821521, -0.16531132546560351, -0.27709059195731722, 0.060467137333029698, 0.11468014613314198, 0.45418714718888492, -0.24948891365929016],
                             [0.45108409706304003, 0.13286109495594142, -0.077764443661823474, 0.40803440426455617, 0.007717545197957771, -0.29746117753262613, 0.20587851744105878, -0.46623896543436366, 0.070007056714000107, 0.059123321094832176, -0.41502277524625347, -0.12768262287265617, -0.26945032306255462, 0.21364115065532965, 0.10611571776390354, -0.29470445378653598, 0.32368230889120125, 0.25222573087739153, 0.10676720878360636, -0.059019083860109761, -0.014231258153970522, 0.42443129474867014, 0.19814590031445795, 0.18528690247823693, -0.11418910961361581, -0.46732202085308749, 0.35729408676005592, -0.003721316004821118, -0.17614220433370148, -0.55572344637088333],
                             [-0.57428642628167259, 0.51376932403296316, 0.10813933143536295, -0.3512673933605619, 0.085082657791016522, -0.61151353337614578, -0.054708014613625476, -0.011872775518172497, 0.17844304388315715, -0.54926319566143444, -0.34430720360784289, -0.14039982599431536, -0.19590238334213445, 0.090372604319927413, -0.23375222391942024, 0.27082183111358737, -0.011961180908640477, 0.28394702766216368, 0.060495289971531523, -0.12932447053311136, 0.19502816837228074, -0.1949638195557456, -0.014115985086452355, -0.034916584686376824, -0.19553206983795007, 0.11978876240335169, 0.15017647865494901, 0.036169964244419837, 0.0063873432284996465, 0.30758993890223929],
                             [0.17508378244527756, -0.091782531171208548, 0.3333738456595125, 0.032557667445240822, 0.12604737808124064, 0.16928034735702444, -0.18434301367948863, -0.085991377987287357, 0.0026713222251304111, -0.1508533369843762, -0.37260881338939533, 0.58167103765815775, 0.49408209354604127, 0.16735526482926472, -0.064343615175384422, 0.37720036038608346, -0.11831294730666211, -0.063397766207481138, -0.44904468814901255, -0.20792162016206281, -0.50341950554472825, 0.13119580253807953, -0.044030102370652052, 0.21427910235603168, 0.15828209924436437, -0.031130615559746572, 0.097567351230805108, -0.33058253167427637, 0.19235986344388864, 0.31843591910045377],
                             [0.04124392451735457, 0.090127213163129799, -0.046255936343813003, -0.35067083660692627, 0.1221051237665834, 0.35612812278980022, -0.077995735398866672, -0.21274612824381434, -0.53468711795735258, -0.0063278579708249683, -0.32739426918782821, -0.36811499527752894, 0.0082521174781474589, -0.32934638195416677, -0.33156964021081781, 0.12727822797136451, 0.28374543416497838, -0.2308669928070069, -0.056490774528495748, -0.08493955904388821, 0.31557295407679581, -0.027232687354017765, 0.27899629283761601, 0.54704031871804537, -0.37451988756016702, 0.22805821726870129, -0.015866603130501169, 0.26452071120796061, 0.11748532134093705, 0.076041343418079596],
                             [0.37581500494191483, 0.26136583700068272, -0.037385240799969952, -0.31538151481896021, 0.31164602386524343, -0.14235627547218674, 0.16369991519044105, 0.16154439150322819, 0.29290514008089685, -0.070128471865656919, -0.17083693354289525, -0.39699400107765626, 0.062083971976674146, -0.54815213066647361, 0.23634260993714207, 0.25599113731704981, -0.03725864848898261, 0.34231099536086745, -0.23455917478138499, 0.15617624646693079, -0.35506071862105171, -0.18858124541413868, 0.44649306987666759, 0.2521205446341061, 0.5172929202986476, -0.16911985388072748, -0.29855922402498608, 0.26825582947036253, -0.042237553155054161, -0.12691626717342197],
                             [0.13313668546587668, -0.078010222829167142, -0.28704704196304115, -0.2427668185653821, -0.63947039394254024, -0.31855971168727182, -0.31385613188941552, 0.043107819135129434, -0.27657118165803846, -0.30998261141516281, 0.0026798483383837527, 0.10941935353527807, 0.026512768564708699, -0.044923646615346993, 0.14169557305622785, -0.18553561882207734, 0.083794109466450023, 0.12267746214565158, 0.16802692746031014, 0.16350302741429362, -0.3148372564406538, 0.0044682238525730585, 0.18113836116856785, -0.22761405364316878, -0.24337883354329309, 0.6178592985760365, 0.12811699339582208, 0.1164973392082355, 0.11159780719077436, 0.050834493097627172],
                             [-0.21428983040098437, -0.33596352863274936, 0.25228465895105612, -0.25214811083759603, -0.30146863527718243, 0.012819711029590394, 0.1790817822979715, -0.289059109295419, 0.24525896723214077, 0.038603854183751285, 0.016142962355380666, 0.027713409703259667, -0.2763156817790311, 0.038740223016519498, 0.26262201824614151, 0.43971863153515522, 0.22176143015820443, -0.21746444902656206, -0.38415102926292732, 0.18192400452245203, 0.24893135559879842, -0.37414452016439059, -0.13272539804962313, 0.24345240847421162, -0.06587444902042576, 0.016200889816368167, 0.050699845720424207, 0.076330702891175717, 0.60101601731787835, -0.37671793360683115],
                             [0.14218511952954777, -0.33229911367454729, 0.26526198274309953, -0.013644083577653603, 0.12763462306635268, 0.230382711329575, -0.74807758111905831, 0.34731977268701258, -0.52988381147597707, 0.053817315057272941, -0.11891281376095031, -0.29448373591517651, -0.40726001624580083, -0.1408805907199803, 0.38585298416943903, -0.29416792800000968, -0.36972215008412151, 0.1622057155599779, -0.19369254181193135, 0.51682856389217302, 0.1075965739936206, -0.10255900487295205, -0.26332950129013449, -0.35857569310930998, -0.20455748915836286, -0.13607797317745707, 0.021958588595822174, -0.027621145116619762, 0.21457800472656494, 0.2047623148574183],
                             [-0.040636837850672083, -0.51565552533937797, 0.36888173979744376, -0.33163426465411011, -0.13755444506291351, -0.38762798206451266, -0.34464021528182753, -0.034868721840492771, -0.021441638393505987, -0.10123350872257735, 0.26262239509142554, 0.051288291022329284, -0.072457144559408493, 0.29771829443511416, -0.22676576223157202, 0.40308860373907146, 0.26054299964390237, -0.12723819859115851, 0.34278020785837632, -0.27268652702941781, -0.046058673718819471, 0.71114726497381342, -0.24857886209117855, 0.1680725479249171, 0.089058129481936282, -0.14122170213162197, -0.5796458547940293, 0.27049163390739772, 0.10507928210085454, 0.24490446243722561],
                             [0.11705152275445671, -0.032778241339489277, -0.0039792895594221583, -0.27105335673193587, -0.035414668717744485, -0.1514099612559052, 0.20497444364984194, 0.31792354556953695, -0.17004225879417012, 0.41381980671127561, 0.18361146417782778, -0.35862119357245237, -0.2531434715992481, 0.65204047355585648, -0.57000321405585819, 0.14317756081200797, -0.20948405230810094, 0.28209017046986662, -0.484947575767044, -0.054504559185331619, -0.29304329674542051, -0.15204116485815622, -0.14051404144563567, -0.030624021856862887, 0.014692197925746019, 0.36147755449735414, -0.14686752109249848, 0.25589365955338206, -0.045251745924905634, -0.086807794805867852],
                             [0.19048568590451517, 0.18022813128775539, -0.19407609855468191, 0.16776709785808244, 0.37774203387048316, 0.50299662103482157, -0.20014473191025556, -0.15851388204945177, 0.18260853804705701, 0.049267358259944563, -0.29329056896511785, 0.55007334753168835, -0.4672504114667051, -0.47613534608001007, -0.023266175361259939, 0.24727801952763748, 0.15577034503182391, 0.29544790162295509, -0.19614242775113616, 0.10497946339445649, 0.027972721252747086, 0.30824075253835775, -0.039420453756053978, -0.51479516167947204, -0.34086796180931278, 0.17859481769010019, -0.2735486934860773, 0.21262639860234273, 0.038693121681401446, -0.075910743583966017],
                             [-0.17972988684052474, -0.041178899021960959, -0.25334376421631805, 0.64396222667556857, 0.10822555115306466, -0.41855373042892541, -0.23523790248185752, -0.038595395544507173, -0.43830103964561828, 0.038122762222064142, 0.16390878870075293, 0.19144764191731006, -0.017953430095619505, -0.080659025192552858, -0.029941297886962918, 0.28597700167355761, 0.49306346164143411, 0.10817624786306702, -0.14340248205614858, -0.37593655716176905, 0.18746552502499958, -0.50176758329795645, 0.15978174559773936, -0.11820147009166804, 0.37724164919409886, -0.13938667876129024, -0.022863317337665147, -0.1176144106097186, -0.011185725939054855, 0.21452965536730587],
                             [0.21525804464277754, 0.20028146732581484, 0.081010044275277499, -0.49967221012959545, 0.16668956600075024, 0.26028145018960902, -0.078336520198848958, 0.2287946544433728, 0.036138180849140916, -0.30746683287757121, 0.043851276361361456, 0.082237197376586163, -0.36243837928125089, 0.31750294353799452, 0.31626313806381912, -0.13495284014335091, 0.33553011704257585, -0.35442302250196428, 0.0072896043919544731, -0.35204178854350837, -0.36457930885311179, -0.052335849487287901, -0.16537727000291885, 0.061532142991680291, 0.25712438531642207, 0.21286083463539579, 0.3236313756400368, -0.36731743132705724, -0.57587127104636393, -0.13413817438654638]],
                            [[0.020424687082314274, 0.33046683807002347, -0.10490868217854235, 0.28083291816365402, 0.1810972986206518, -0.099805485962488144, -0.33973909573128075, -0.17089398285083413, -0.24644934228258136, 0.082866393803698257, -0.2552279094988219, 0.054080863665390111, 0.31285296627110765, 0.22268811071394165, -0.10252951857188067, 0.2399158198053174, 0.20783718463148471, 0.090693528602373868, -0.22897115817104965, -0.33079788629261697, -0.37757659075150413, -0.44607712227914653, 0.38824699886736352, -0.032296574319680721, 0.097982048794100551, -0.24098912974251405, -0.43603155197433074, 0.2174971862800773, -0.10484574434518378, 0.38913261754849215],
                             [0.18398807618289967, -0.19343481988828534, -0.10644066833512372, 0.14014323288276692, -0.093489320885444482, 0.045687151685808843, 0.12772155998163451, -0.48320803689187442, 0.09366313754433854, -0.16159705414065209, 0.3746749030552573, -0.17214083891661547, 0.083245988568875509, -0.30125162958115653, 0.065128786472754718, -0.20666905209049025, -0.005703660263694529, 0.49961354328911523, 0.37845909742796285, -0.26949500780197466, -0.37788411629615837, 0.16461007652653104, 0.032181886913898082, -0.17632985441953089, 0.04038389295826731, -0.28429512864309886, -0.31098479772062365, -0.13523516335279376, 0.013086146128788514, 0.24301091562538316],
                             [-0.084870745097849698, 0.23767133506111005, 0.45442007249455985, -0.23788995905819688, -0.46754318855995702, 0.092777391769498271, -0.18444331846278889, 0.3677476198846425, 0.026819312828445036, -0.021330022287460247, 0.39536290187136025, 0.015130806981849432, 0.18998277300252564, 0.21036159953594724, -0.42369468257535459, 0.11275946802340324, -0.0087883071081692188, 0.29653211939695551, 0.20484068753639167, 0.058937829158182423, 0.13421884598832823, -0.02532237230465921, -0.0059706750023506032, 0.016268717011312606, -0.31939313050985801, 0.20466012571366662, -0.63606026052945397, 0.036554658679492091, 0.27040864190131442, -0.15711446658543121],
                             [0.47579822726674476, -0.043600488304141941, -0.038307929533948168, 0.46530693424077879, 0.19686703246133608, -0.016350207209122069, 0.15985270934076751, -0.075695587781080931, 0.23826619071616015, 0.42946689288989565, 0.19511772646335096, -0.13077087035586649, 0.40942771603079103, 0.5302624585511877, -0.11558185748588251, -0.054386055062878406, -0.4714225995625605, 0.17578149095630979, -0.14887231703223383, -0.16577236063366396, -0.11413681989096572, -0.28093877549717755, -0.07239262408762788, -0.064612159866243107, -0.14150716900916266, 0.1152306836070706, 0.087418977388764682, 0.094892132821491768, 0.21495785497051367, -0.47271862199490133],
                             [0.21712246067196089, -0.18453690283056223, -0.23407844507602857, -0.18008706103168051, -0.50116320959300986, 0.04087321552069717, -0.48055342253125199, -0.36425385343968703, 0.16830068062951684, 0.58201229648997721, -0.059108660487882547, 0.19845064775305293, -0.14908983043641361, 0.18905335217783525, 0.068428100290057706, 0.23811480426265216, -0.15301177588160503, 0.021211708395626142, -0.36328760473981131, -0.0044105307588267889, -0.18304920262237306, -0.164195990742075, 0.095816290001394494, 0.097664755208104914, 0.20219957431175817, 0.48410486834301236, 0.15418152683104946, -0.17694925289896862, 0.21958085840941111, 0.35037275081181218],
                             [-0.044484709383230736, 0.16912964064520167, 0.092558591898897008, 0.054763177674725508, 0.18172227079900347, -0.12330689164922805, -0.45451076886717262, -0.16054102229660588, 0.079768169933027266, -0.037751436454646611, -0.2029342051253944, 0.43688771453670983, -0.099515154478035578, -0.26397421696176776, -0.12291755755543479, -0.10865677270365873, -0.8425104692174854, -0.18109550094264459, 0.41594722291408776, 0.12656537858361197, 0.12724898726560119, -0.063124816966998273, -0.0536090763585194, 0.37299565823359548, 0.26735808604960409, -0.31845697716372262, -0.30653027705369823, 0.13020136923575054, 0.14573411183071078, -0.08924799461970534],
                             [-0.52684278382065053, -0.022314955819403647, 0.11038758166802717, 0.17332626066077764, -0.22776012602607471, -0.10040009941686748, -0.078188879340327505, 0.15351049370407993, -0.36923161658463577, 0.11135189374703924, 0.091082597936597398, -0.67832416310944532, 0.47829692378235955, -0.20915865386890795, -0.072475786305914669, -0.30526306967308703, -0.36072777025615577, -0.02955060760437216, -0.1767539019250341, 0.19414441417353556, 0.14480991342874286, 0.12328560385513126, -0.13863746514428396, 0.25124207147846983, -0.10370101364086737, -0.36087167046400814, -0.083908910888294844, -0.5333837516903045, -0.3539722363799418, 0.14484430755237473],
                             [0.15996753658849189, -0.055959708522179311, -0.18697941577171973, 0.090775109640538421, -0.032090097662936197, -0.41193160590462313, -0.61430405466682003, 0.05475832715630282, 0.10415364753074108, -0.23257454147885742, 0.43592603942757396, -0.26857905450402947, -0.0092223028621815188, -0.33997391563976748, -0.29667529913936319, 0.43690492691197486, 0.20180677187505858, -0.4690959049010085, 0.12545962462208293, -0.44976484332215694, 0.018606956195242903, -0.027747772702369965, -0.32050316454352878, 0.13526082428855757, 0.39417575283377371, -0.1537038122510046, 0.14935115087069367, -0.34018786805357387, -0.092382721719810268, -0.099464152216970664],
                             [-0.046548154716951701, -0.79217803410802179, 0.62609575774185688, 0.065456777246737749, 0.3308538130531461, 0.015377206570228024, -0.27864728387348903, 0.21086482138030166, -0.36038034801980107, -0.05253882378515206, 0.14097540085871793, 0.072268187164867076, -0.027721550173962554, -0.012054359219239801, 0.20510622529832001, 0.2749658330914051, 0.09782168852241363, 0.072559383314661982, 0.16595743012431985, -0.24166082325152952, 0.061077525090214031, 0.3111047623733153, 0.50406284810409085, 0.31813561895881737, 0.019842819823710067, 0.4065644664090185, -0.066327915493828077, 0.16227245644876814, -0.1998594586035444, -0.11800165297886045],
                             [0.46107252922927722, 0.20254590856109728, -0.056306299112164046, -0.29831667795407479, -0.056846322098714597, -0.15461471901574581, 0.046854527790843058, 0.017411200267505443, -0.41524065789847781, 0.48843799022457285, 0.20358439943435083, 0.33076340711031066, 0.12792432354401012, 0.31544190599784028, -0.09682329777285964, -0.44768136431602906, -0.15293711275639615, -0.33643466845424413, -0.03866661544245871, -0.32063449950571415, 0.17542723354553239, 0.6217322805517268, -0.16334729743792897, -0.016691984459795736, 0.15594124786134855, -0.041041650602173393, -0.11497939845009535, 0.29786728137970425, -0.14319655147343108, -0.0074890072936020929],
                             [0.40946360207236498, 0.15554863480667178, 0.16525355413612425, 0.10651545275547245, -0.42053052252053652, -0.17258649751917707, 0.19098852992797061, 0.16843053696745003, 0.017509453945093845, 0.082243613363744889, -0.14511479106858216, 0.035162464883278927, -0.3414356154541297, -0.019072223353864402, 0.66880645561609209, 0.10805892731734466, 0.084740880186303658, 0.15696262949330872, 0.059709523864143507, -0.4213178394564383, 0.15448587933619359, -0.14961253801993113, 0.054189239429979753, 0.078546657195556646, 0.29988328993275909, -0.25811354259744806, -0.21020426419766788, -0.019894989398309037, 0.051092013298199991, -0.49336039501431028],
                             [0.21430722873286445, -0.31578058837960998, 0.12200180970667737, 0.40181046180752761, -0.38803259843813209, -0.010348958728890568, -0.13820801644616426, 0.18809091765845162, -0.19531532018292966, 0.065001973206205751, -0.031783335487424298, -0.13682586315319772, -0.80770963237937388, 0.21371176274552722, -0.27927800071489922, -0.01861426020189379, 0.23101735187773831, -0.042901411529136353, 0.21578226285258117, 0.2000753898955836, -0.6355842166500546, 0.16523641586032869, -0.17904187202422892, 0.010356589415653865, -0.080906648309760687, -0.10786768604515992, 0.1564280781407994, -0.0205382901198175, 0.011465388440423011, 0.032907502376177913],
                             [0.1686602838373483, -0.10308230774115651, -0.092549063072271037, 0.023159040213168874, 0.21932894356163873, 0.10715907443202212, 0.09219210128178755, -0.29128900288954823, -0.38376372539846915, 0.12209336085289854, -0.25997633770180345, -0.52070776608348857, -0.15580803785408986, -0.098840165558623905, 0.2923213972015114, 0.04027517494624569, 0.19233830630825194, -0.16580596001170375, 0.38166465244961173, -0.090023469321038663, 0.36161452501595809, -0.15140218511120765, -0.23707328025252192, 0.19566113035447991, -0.46742783909819069, 0.17333111344555313, -0.08342959753418018, 0.038487756259846705, 0.27931040419947156, 0.16788012165782581],
                             [-0.49101138930822685, 0.11762164435395042, 0.22858524370346509, 0.38077221161725106, -0.09834940505784448, -0.080439198192854444, 0.19090880282207631, -0.27671583005113609, 0.023679996771624884, 0.27226934673709169, -0.030410653286633046, 0.37908087990072858, -0.29818726359033193, 0.15726746666746, -0.24678713394573384, 0.00933701316252716, 0.023819358033272377, 0.17757864823874328, 0.25663907831015537, -0.57863898263610025, 0.41663906423465841, 0.28053672408584696, -0.10442400282370216, -0.18528580510356035, 0.00037656488500516574, -0.048063394443903562, 0.12459162400774609, -0.41410432608559888, 0.083491258712330887, 0.19555399199670462],
                             [0.089145706727796245, -0.14614459576200289, -0.30367763993691266, 0.35477182039736788, -0.10034296557214778, -0.53628425161590265, 0.21782734381636243, -0.15744918122327561, -0.18224819474362583, 0.019052829878754174, -0.10893088460710161, 0.45815450629262194, 0.29899895273944682, -0.15837417449661323, 0.22873125547014889, 0.21316171025515618, 0.17096012000086719, -0.23927728308854443, 0.010088896427342621, 0.59670548630720588, 0.24985799429043437, 0.25237290166802367, 0.0059116407324766827, -0.1893765511805571, -0.18143438654796304, -0.3007961766916134, -0.18678203676799954, -0.040103523423571943, 0.32758702350681523, 0.096952636741613529],
                             [-0.37695436372867075, -0.015162310128112425, -0.029102607369745785, 0.16238648349824553, -0.080382771718426588, 0.17091248399029915, -0.2376775940936815, 0.066745567486011223, 0.016365772169013169, 0.20284251328338615, -0.26057049065601973, -0.21483537573256259, 0.26442701223583126, -0.17682029838694396, -0.026440185104175021, -0.023582474345927962, 0.50920992833426759, 0.071631336569187812, 0.014555120841782909, -0.19715182075049481, -0.19765812023889484, 0.43556365332628971, 0.28053909069658473, 0.043900177071228119, 0.473650980686042, 0.270314357797307, -0.10764990387714707, 0.17040470496309401, 0.44570517612211136, -0.2040701424072697],
                             [-0.20190359173871025, 0.20872535947909254, -0.38361858466401, 0.083666891521143039, 0.0056000171376356413, -0.49353987695599322, 0.058714766430943019, -0.22034829875426107, 0.10107665588295797, -0.31700932816584648, 0.2232128287430854, -0.21462572688503512, -0.5122026184743399, -0.068739098266202406, 0.24574457344087108, -0.21749247996050769, -0.45573055373606725, -0.26496480711381504, -0.21805575680679129, -0.2549564372833244, 0.21350068740746694, 0.0079806778730565769, 0.22098500315931827, -0.11774964640661562, -0.17257005959053268, 0.28884036907991723, -0.40521832474239983, 0.45811541340685086, -0.04751810576922319, -0.093057084215084851],
                             [-0.21360881212486935, 0.08429455915152588, 0.059568202627464387, -0.11497707497873724, 0.23990888376544464, 0.029022292001382104, 0.61688488547843012, 0.0031768177197887826, -0.16074315850888232, -0.099549121740602681, 0.32906955303477675, -0.18329586309073348, -0.13485950375981404, 0.14334639373265406, 0.18182077961363297, 0.23668545319149878, -0.076280332662393632, -0.27383924107620627, 0.19455321473509715, 0.24714164150102461, -0.36726207690252349, 0.12650172332554427, 0.019226916668521908, 0.56828956312523526, 0.53729723631499093, 0.2134460875426078, -0.42192824515286892, -0.28843544491529521, 0.14134123267848278, 0.1227479671023762],
                             [0.30808348730475604, 0.19378831766319762, 0.52312973830764997, 0.068634740628099447, 0.29077562979147525, -0.45402340883745712, 0.071867796461863337, -0.42980626291325824, -0.035729227102837283, 0.088275136029176984, -0.39137090817780329, -0.25953516939739374, -0.22794107180055359, -0.11849079171068155, -0.10121870171339055, -0.10330934309969643, 0.16806458192664489, 0.027275259038124638, -0.18590256793806684, 0.38223138532936735, 0.064388260228463362, 0.2626793715608059, -0.23557876370474534, -0.069762997815138825, 0.11870800942443009, 0.093482431978749073, -0.31598679350417397, -0.24039801054404367, -0.3084604625002294, -0.12393660828868822],
                             [0.099537291447511889, 0.26243859756909538, 0.40268908688953164, 0.14872140144753526, 0.22358848023818839, 0.038415450129275039, -0.3313094816400321, 0.19426965522142503, 0.10423712212991655, -0.51756393047082405, 0.22519312639293662, -0.29368740611273958, -0.1703596446358559, 0.10329509287893612, 0.54457704011739161, -0.22598319471949074, 0.07748780744234865, -0.13735936073357721, -0.36278364793435641, -0.11221353229656321, -0.073924458173456636, 0.27993337385457295, -0.13779235387205113, 0.0073723806549636714, -0.0023312267665862993, -0.20393988839889318, 0.40937640860553154, -0.13755814746383058, 0.35878164344376751, 0.40074807088347864],
                             [0.13021201315263864, 0.059790145224709018, 0.10293986964622294, 0.23212934335526456, -0.11078998041142797, -0.20527754960861075, 0.16527559045310969, 0.61199409488097289, 0.6628976848528646, 0.34136921778624119, 0.18502895671623154, -0.1184706298972104, 0.29590604473077936, -0.082587656077385468, 0.020152208733463503, -0.18487730222560042, 0.13875189844547597, 0.20041732805638635, 0.16806227034304422, -0.10597347914819905, 0.13618229093297324, -0.077421733463525252, -0.1814217341171932, 0.12842443997760267, 0.22364836558210163, 0.21278279692758809, 0.074473001099147978, 0.39701309989862443, -0.2359820937052296, 0.56627444225853263],
                             [0.46837000823925978, 0.029495392489666775, -0.26226770271966549, 0.1916407935805316, 0.1045516917250207, 0.18449568194698596, -0.1532436862167561, 0.37109806258375505, -0.21584128253347479, -0.024953935715198806, 0.14716415688597748, -0.10883404469885535, -0.29724673404431401, 0.10752765050122269, -0.30196182983013514, -0.32042670407435031, 0.0015768586205566065, 0.38591415342613566, -0.10438532196319894, 0.10375521479255959, 0.31478420916642269, -0.40210868662185223, 0.21331328421946966, -0.02107572131803187, 0.4664723204902122, 0.1405121354132578, -0.10117131614485937, -0.22213035193932459, 0.21106051311410504, 0.15922892827419782],
                             [-0.486349449450587, -0.31667665918984567, 0.32152137083665577, -0.25059227491109581, 0.050352198938786799, 0.01824822838179041, -0.14235129595607188, -0.29286271006081616, -0.085046299217044666, 0.10146062813075207, 0.1981177130052667, -0.11791790958342416, -0.11822827258234068, 0.030100308959465423, 0.06764884740045668, -0.24696995111167752, 0.29793765128019145, -0.16412501193269691, -0.36892591905377237, 0.047490276817605634, 0.080728349621753154, -0.40317860953767026, -0.30800662094089104, -0.085259241247694018, 0.36856502136454794, -0.40306747137449667, -0.0051302091498744429, 0.36154234384058354, 0.29865112525303661, -0.13529531781900525],
                             [0.044425722396863362, -0.038613059470031297, 0.40799040058386093, -0.16956952064765685, -0.0559977060683182, -0.64766730596418032, 0.025699354747445544, 0.24935029408974546, -0.22637553600800625, -0.095140965709740705, -0.17769034995165375, 0.10891080643470402, 0.11686247320822424, -0.27691796702883853, -0.0054409711489832278, -0.34302254748186228, -0.12647005924254109, -0.29337712032660102, 0.34454574512897079, -0.27412877136824731, -0.2208682406371143, -0.25928426302941099, 0.16349057650569457, -0.45505741260527155, 0.1390751975642911, 0.2479647385177427, 0.498467207669958, -0.15442702846363632, 0.37704302813621249, 0.12640633312617178],
                             [0.11002235483217253, -0.048426646885108449, 0.34337839389208125, 0.41254413365549969, -0.45287947452749722, 0.57810806161760964, -0.011695511254952214, -0.25419144985446107, -0.14551815393235179, -0.36520292407264132, 0.074395485544693774, -0.30112324718981331, 0.090766962429717116, -0.043527920542337444, 0.051228699197333749, -0.0079759460470464182, -0.00077694875109876257, -0.43397648481154638, 0.16667761855248436, -0.077874924802465995, 0.42152824846686326, -0.14097017271490533, 0.058928527113017035, -0.38650708203240203, 0.46620276198041388, 0.070329725451358044, 0.11120244524759608, 0.2933954511794245, 0.0052139297584664476, 0.091490974452409918],
                             [-0.12435608219231267, 0.29345354773961768, 0.040346753155535084, 0.082227052748772692, -0.12451662914176639, -0.22402362052497815, 0.029356862490365107, -0.49619198238988782, -0.18823619517313869, -0.12404767477768143, 0.15378060607139987, 0.13270967277657786, 0.22096073659062179, 0.16509450912221466, -0.081371000548104866, -0.30219806350885287, 0.38779835754288844, 0.15975395093363534, 0.21487051604628737, 0.27139070172626395, 0.22605055245020378, -0.036838157312910388, 0.37785090784234526, 0.63535195075478645, -0.20440584668264383, 0.084370506008161567, 0.41124873132139439, 0.1471363664350463, -0.11564045035318639, -0.08457042272452206],
                             [-0.11022354011306783, -0.37522847618174726, -0.088962486874697128, -0.26120425057180058, -0.18574455533985182, -0.15821197030012438, -0.21208363171766573, -0.11536338263206622, 0.15950002644058381, -0.61308728776960109, -0.56053672273147748, 0.19085421734564614, 0.23480819513578102, 0.68135887358024083, -0.055597568988143324, -0.21359616009303903, -0.032738268422112679, 0.004437470154360623, 0.12366290216563479, 0.070684259291017376, 0.12042150777004589, 0.2865227997266801, -0.27395546595288933, 0.1463711448344624, 0.13442021275427504, 0.068770634937290354, -0.15000713940471797, -0.17716831066095959, -0.1281074205846105, 0.12621196664974776],
                             [-0.32501983948268781, 0.16766232799093236, -0.14475515349456997, 0.24437218283468953, 0.017285427021344127, 0.13350174892452119, -0.36490103544975261, -0.059942579050319106, -0.16427639526778434, -0.032448374367077495, 0.077184566123693371, 0.37135860300625534, 0.16040422257662529, -0.22691018153083303, 0.41142653718852978, -0.30637208216031148, 0.30323678434346452, -0.38766949449822768, 0.050653654119796443, 0.14697336312347728, -0.21955919708260233, -0.34096400527186005, -0.37116025604991593, -0.048849994665300621, -0.12444030759773508, 0.54737773747156393, -0.42938966003118328, -0.23687223598719728, -0.16175289832082357, -0.090238658550562983],
                             [0.092106102731559808, 0.095597978543526543, 0.11747976836154744, -0.035081095557855393, -0.050119065272679647, -0.20173248066401536, 0.26767611056910223, 0.070374060995389398, -0.17112073740598258, -0.34125096447367897, -0.26336389788730369, 0.18532990286959575, 0.11159274320793762, -0.40928796625801361, -0.179271631495552, -0.14248719277286795, -0.16517805764873511, 0.21547714780271704, -0.72413104421518126, -0.37343221172348862, -0.15077957220758767, -0.14675521444512288, -0.45907891604301604, 0.3906811427067936, -0.20414522542850716, 0.41535297722441722, -0.16818458833179564, 0.17984379934495656, 0.17307599626011358, 0.10063133213488493],
                             [0.35011894791960874, -0.20412627659404739, 0.039720697961358006, 0.021312745780484497, -0.03359784550588106, 0.2144392857405521, 0.10799519710388431, 0.019443693153409318, 0.45018810336413856, -0.10971630231538497, -0.0048646700663848227, -0.079521318443904976, -0.11642143623759163, -0.10461328925140959, -0.22034156058567736, -0.35696684415584007, 0.43198326831585643, -0.61222917186037851, -0.17315838783110515, -0.19497449716280602, -0.040274428304460645, 0.037113860930560377, 0.43923523504570139, 0.20592398792859123, -0.23273485866206914, -0.34082582978146642, -0.25413233081566972, -0.40376190359257963, 0.10090872469602823, 0.026086500803548365]],
                            [[-0.2235566704922089, -0.4092049271211719, -0.57473834596090168, 0.081841956649422926, 0.25694602099909675, -0.098641534401614217, 0.1277380380088371, 0.052598496133888513, 0.15018810293696294, -0.3265395260908478, 0.18442822137738282, -0.15592139363571186, 0.052614772914797825, 0.16078786348482885, -0.034451493634691237, 0.19470946495522504, 0.53424178855534421, -0.30983838194106411, -0.29633414419694259, -0.067454106231594091, 0.089364685686051853, -0.23942742770325739, 0.37131680649646659, 0.046030787783927586, 0.051708003629146057, -0.1895149288557556, -0.53150139774098215, -0.17037542316925469, -0.3702865571663953, 0.44085423289166503],
                             [-0.2437938175759477, -0.21612757990045275, -0.050079130554600393, -0.098332132775535777, -0.061278960089880541, 0.43013874483942183, 0.075615138527340309, -0.01604736368722065, -0.059149141940744512, -0.20326735002386218, -0.19798075278929789, -0.099205712453449085, 0.24673648702871648, 0.088702667612475167, -0.10307896208008513, 0.42911785521297641, -0.26559046121381258, -0.02656264904343987, 0.32882066577239832, -0.63845243425398079, 0.060620675359184188, 0.27876638582541041, -0.45174278654401773, 0.24057282882526737, 0.30916271551648428, 0.16797098179309958, 0.35519386345808779, -0.38265818678051611, -0.070363529955352125, 0.21998879438154795],
                             [-0.068159290597242822, -0.30914512340425304, 0.14612033657027257, 0.40947265886773609, 0.047649883796250812, -0.28368872827856817, -0.36580405385177639, 0.24079553964120112, 0.52190962046717282, -0.06619132576773154, 0.075987379093359994, -0.33655601400013208, 0.42187373274805917, -0.44799985473063714, -0.20760426062886889, 0.13172880204224049, -0.32241216335418627, -0.039622772217499408, -0.14522988871528889, -0.11084794826737279, -0.23808319881328238, 0.14793895137172278, -0.073472325300329017, -0.27360688953443124, -0.091674757551481717, 0.032867692522565176, -0.12819313674803012, 0.21457590501015675, 0.21788779508637318, 0.2554838465996937],
                             [-0.11593828298519646, 0.057003572367936871, -0.19413129489534875, -0.071487690589521605, 0.15195505102535328, 0.22021315364047866, -0.75410320205897075, -0.062000604250699018, -0.094457661973988902, 0.0047516350856757587, 0.034760690728286782, -0.26574049912472686, -0.33832366282974824, 0.053502463814370252, 0.38520807431469628, 0.46573164258462951, -0.053552147422961605, -0.18821383880852513, -0.19804897162617324, -0.31396755139059929, -0.60801337046379211, -0.20042387453148097, 0.24868276970420425, 0.16026463750009418, -0.0094502515819996618, 0.1818753480883222, 0.063179585938690455, 0.0045058403042785708, 0.44598854694031359, -0.1933212525660275],
                             [0.10466966699316274, 0.067577611618532887, -0.13869438898725972, -0.23623480275537181, -0.45694988919332735, -0.67483481486152819, -0.32824872075439376, 0.034931739556955166, -0.34246126199120724, 0.27476390484569191, 0.07152067294935234, 0.27312661250557557, 0.2344228471738094, 0.14857551440130229, -0.2362496637181733, 0.44468998030452661, 0.2271416103639706, -0.37777782292050638, -0.047823495768786244, 0.10823584700954106, -0.019366993210165821, -0.20313644357168825, -0.31413530876915541, -0.39831615373036422, 0.096252075317942387, 0.0024330162337572805, 0.29248839226409423, 0.1993141705531683, -0.30459525531912368, -0.28945366442971121],
                             [-0.3161763845817232, 0.032131880690175085, -0.3926521018352731, 0.16809490882942918, -0.10448206240829419, 0.16056747125597154, 0.016038479612401676, -0.011468444335601791, -0.34174832590711679, -0.37161817603869218, 0.15051274120777916, 0.43837862595626076, -0.035076217614750119, -0.22661449079484275, -0.62855764402685921, -0.25747197538197397, -0.12949936427498571, 0.20051511266479979, -0.15531638322045838, -0.086166854295626996, 0.0038577260164835911, -0.13949980998593353, -0.24511748516287074, 0.066170520594971721, -0.45370717486849549, 0.45764145564488978, -0.32118392301054721, 0.17950511563387525, -0.016380514193775703, -0.22516398057512388],
                             [-0.20431662981500173, -0.27367806089980523, -0.23148326649355705, 0.016202350870410318, 0.36637412435835542, 0.34663632190088911, -0.13930897373219969, 0.4797279489461444, 0.0095185134837461327, 0.73388327395333131, -0.27549485363038601, 0.21933054089182114, -0.25051688108861947, -0.076417476836905446, -0.41589309955610776, 0.15434934840140971, 0.23898739111532011, 0.047565050596108875, 0.11434252444097047, 0.32747138246811491, -0.054254528050629545, 0.044837117614086319, 0.029989393857573564, -0.022678595939811509, -0.18993188269061143, 0.044001775938045565, 0.54737263393417024, 0.0094823339138501786, -0.013770554025583789, 0.22173773569102773],
                             [-0.12542919133133451, -0.32631285333501137, 0.35857253007311213, -0.12580295015336118, -0.12361601229788027, 0.18430718308419944, -0.21129835840991856, 0.19888805749332478, -0.38573375477954741, 0.3541008674473114, 0.11959518492178287, -0.21912553015359404, -0.27007160572004474, -0.51665334598682366, -0.18701656374922906, -0.48641685890993902, 0.18361993594783954, -0.52983165921873665, 0.46854420216430692, -0.19234466111171755, 0.16925813696510325, -0.39856908153537551, 0.27442354485470116, 0.042262090155539354, 0.27779985985898981, -0.037670422650471047, -0.13549860191650387, 0.11039553545371789, -0.13001309298274988, 0.42542820194669217],
                             [0.20764824533284193, -0.43924820824654559, 0.32875788170676357, 0.058378178307662537, 0.11999588179501704, 0.13070878892568538, -0.09659484873139812, -0.033755491606603599, 0.3877491327531658, -0.35470826762740443, -0.28204209146887849, 0.46854087169902059, -0.21116141178967482, 0.48699788152871237, 0.17288736358452636, -0.64635950477242354, 0.1120440489100093, 0.090013947342237943, -0.19826927354255147, -0.13632573566066758, -0.37613730858446454, -0.20867420121177946, -0.17303608596251949, -0.34456781041817225, 0.081185027535809723, 0.080187575021881771, 0.39301497984501998, -0.16871051137348919, -0.44207674641421624, 0.029291470254077065],
                             [0.12435312779059936, -0.61736804315428639, -0.35171085041839711, -0.01927728639242654, 0.03804577600874097, -0.1838370387402522, 0.21848866234454159, -0.17183845450217081, -0.22715612320680473, 0.030242967238524609, -0.15374267567545477, -0.17304470770125346, 0.039649283399773458, 0.20794139739885459, -0.024845962687720075, -0.22547893122645032, -0.038312229228554741, 0.25046341068968175, -0.010038276770528411, 0.031335131077919381, -0.16963433067227782, 0.16607747022639191, 0.12242534227871833, 0.16835170888107348, 0.60890691205649872, 0.48012827772373301, -0.44063258944784039, -0.0506963409290919, 0.65103057248717422, -0.17996427194907444],
                             [-0.16164481167737452, 0.17218026652442947, -0.28180170692595935, 0.44971999256765949, -0.30482458136157542, -0.065160532596371404, -0.17536775895531198, -0.034639161795179778, -0.12918029778920456, -0.10140024688091342, -0.61652698868598466, -0.31673563226293933, 0.17734404659685066, -0.065985789914731668, 0.40828291022500146, -0.37943113493587044, -0.27363046124428425, 0.031140956621695741, 0.050552315641011258, -0.019250728108852765, -0.26901859150538432, 0.3234858704288181, 0.055792571943764704, -0.16152328011353759, -0.1840491196359611, -0.052451352591195342, 0.091064723015947674, -0.30909579672638227, -0.27119720930702651, 0.29496174381787227],
                             [-0.12557352187160925, -0.23147910168837035, 0.10586016235550946, -0.13232130148973528, 0.15664843866708925, 0.33736238744658309, 0.18256408237103944, -0.39332536225009657, -0.50759362575284384, -0.24966365643611221, 0.10084206044069025, 0.25885921036882936, 0.30099668905972221, -0.031136944135792384, 0.06811597389741654, 0.15633847261315637, 0.0043325080899863956, -0.28684430930872584, 0.071778799937457644, 0.091775059057901953, 0.2230193251868921, 0.29783666801415848, 0.090078275498283372, -0.73638422980244378, -0.48892403835542253, -0.11195495855237939, 0.052074133917127299, 0.0035473693876518879, 0.58423946614983058, 0.49332393567549776],
                             [0.42495280214645359, -0.16147030038722812, -0.34311651037521962, 0.39732962012589645, -0.01474072926619599, -0.034286769219437935, 0.0068590650472411981, -0.31050024367212148, 0.10845875331002042, 0.11733432941658306, 0.34831431835798093, 0.54713123373756301, -0.17525333162267098, -0.51280234772241928, 0.22479795809097591, 0.19730201522878715, -0.49658845105005506, -0.12379290485918208, 0.11608735166109369, 0.17904978585593245, 0.020382886899768644, -0.04729725092157494, 0.34868810572455183, -0.021084847407399507, 0.023364100786738284, 0.081562632290031578, 0.10939459726597364, -0.32927385069715687, -0.21434102723436027, -0.046213140804878407],
                             [-0.17751631435670806, -0.042103295655615713, 0.22878151916405631, -0.35411819887479568, 0.1163761637042669, 0.025480329078474903, -0.2088129841057505, 0.36944864310596104, -0.33230132050287803, -0.37426822817111627, -0.45217075877116492, 0.008885156196131283, 0.30513747924130991, -0.43557203973437114, 0.13899574926031305, 0.089204050729687651, -0.0086825435968606243, 0.13356835726888439, -0.44200450859037416, -0.048581498551464868, 0.027549062276660194, -0.15302370630863471, 0.56054779457085169, 0.22231747659563536, 0.23332801982200685, 0.14820553360428401, 0.44765706691250623, -0.28886886584760929, 0.055295635582622724, -0.043194826650702942],
                             [0.26612151495639286, 0.45871176360534849, -0.087976995271876635, 0.040320520523753588, 0.15646549712196967, -0.6412419010563758, -0.03466827961038621, 0.18595734437542721, -0.3758689471759874, 0.24711857615739366, 0.38499953641034085, 0.23087386010363281, -0.025815784937172917, -0.12141459049697415, -0.11828371676463899, -0.1932484093314587, 0.16703762699854216, 0.42316875151216843, 0.023583720064072656, -0.42202379228294234, -0.15311739354400572, -0.026300837595130543, -0.16840327943187125, 0.012414967444776609, -0.026453209537084275, -0.32553337725432585, 0.022789733603772271, -0.69722582366414287, 0.35522536600107124, 0.52675325145301966],
                             [-0.18704566183461424, -0.10492339125598649, 0.37404685778042329, 0.1767693005296764, 0.27871634190779626, -0.049610981281440703, -0.49264698690510111, 0.079920074904908073, -0.02655130774945294, 0.23312447677857573, -0.034837465774300948, 0.64154000767565833, 0.038830186689396765, 0.64965630521905937, 0.22884501942969404, 0.2066020603439517, -0.11503978085742737, 0.33744253767681753, 0.37090827472132698, -0.049604229186119224, 0.3795928848924105, 0.094889488411783074, 0.22673377018214327, -0.074621529308061235, -0.062314755774826557, 0.02637693564246392, -0.34441521975564238, -0.00070903026690258275, -0.11045406987179088, 0.15862792458144304],
                             [-0.22798791043270872, -0.098393693664958676, -0.20611424438140868, 0.18158195122170737, 0.14838225316883677, -0.019483903688017501, 0.33476421551679542, 0.46738899001251666, -0.5743249224172019, -0.35901905376289733, 0.32798396416350395, -0.004775452153461715, -0.22258058455579238, -0.043833675210757303, 0.1141933349871353, -0.12953230935618629, -0.36297879527046401, 0.58451530970101562, -0.034423824732643868, -0.24344720096246211, -0.10514405377063865, 0.21452341328895286, -0.13524060759271378, -0.2706762998240656, 0.34551071704389724, -0.62719273502864592, 0.23669665703153309, 0.26792945198911233, -0.1915974424026706, -0.1131787872254654],
                             [-0.3913993014269585, 0.2484923142343827, -0.29683575346215346, -0.41607893437254639, 0.068808998448388309, -0.049959829262716526, 0.28765824944241991, 0.49869146823025623, 0.3786957415906067, -0.11321059333923426, 0.069078805071952215, 0.41968744570271954, -0.08007200944666934, -0.088034782445351151, 0.44146198787217594, -0.053573849517533412, 0.15593254403493159, -0.010117168328161903, 0.22793578472107437, -0.02812701988028677, -0.18993704100209319, -0.16457594379398524, -0.14666130976147218, -0.57434827009370759, 0.10745823228882248, 0.49265559785716406, -0.013327630946479659, 0.11094235947550417, 0.27505812012780179, 0.026617361560054717],
                             [0.013816111325706648, -0.36278849567273053, 0.062918967216341576, 0.43784377480718545, -0.34758496792030724, 0.045527784859319562, -0.19229536900531188, 0.42105942721920042, 0.05465748691901641, -0.38948808767805487, 0.42796687994965371, 0.16032734611135957, -0.070024134762065468, 0.076163949652668872, 0.47268249396606404, -0.30291537148342362, 0.41865900448800758, -0.35272259121150701, 0.32889259465829052, 0.38144981106535181, 0.082926326778559989, 0.16045158596761841, -0.13144605357802944, 0.17035678384665978, -0.030803891175621677, -0.11329363931664352, 0.025879169675524016, -0.46014570920474829, 0.19657101450810655, -0.41050336193486164],
                             [-0.50685957831828043, -0.25230819064568394, -0.24658508635221571, -0.075438481751451764, -0.23202302119137608, 0.23230561838066122, -0.29586538012541524, -0.27207223575294842, 0.076524304375582483, 0.17100947062303232, -0.18278895037663831, -0.089831214016179231, -0.11497453725725218, -0.28376315152103893, 0.11350977239826185, -0.089992849928695856, -0.04993975221683384, 0.19938758961470149, -0.36224227270581338, 0.049704027739865736, 0.48953993510587118, -0.57227058562274158, -0.22952159601306299, -0.05688695661288487, 0.26650834775864402, -0.38852442065332665, -0.17693282286737874, -0.25729512746693761, 0.21693447864934329, -0.093657857203869585],
                             [0.16246780655513904, 0.034614863932929812, -0.27121814878618006, 0.33017406460779958, -0.15703192003355071, -0.15371352669861918, -0.057675729558753414, -0.34191310881268938, 0.21579202993190183, -0.049192896777092182, -0.14140236626751684, 0.22944355630369165, 0.010402259128646219, 0.077818291334614931, -0.019695509813360185, -0.18950097130410076, 0.33188455884153251, 0.024514832015922087, -0.048330315013851502, -0.33838688513721027, 0.3081739384718597, 0.12539316882682619, 0.15047423650262676, 0.2813600596979659, 0.17595720389049585, 0.12466721472958592, 0.56494421350783663, 0.6793146979803022, 0.23216864562494904, 0.24187976671074463],
                             [0.56026756159468882, -0.041748640877873999, -0.082770729944477456, 0.52733573521481614, -0.21144732815775114, 0.053773433345182448, 0.10183313602917844, 0.52738164660468567, -0.13318751622362851, -0.03801195701412631, -0.14894342875714683, -0.27362031157190436, -0.37295529169722691, -0.0022487275472022894, 0.087080066304789594, 0.27218242364026368, 0.27212232856773844, 0.27161665003656532, -0.24480160679232421, -0.26079669361034641, 0.57989778721496532, -0.031312797019735425, -0.25412384637536534, -0.3171122635394214, -0.18192277518950406, 0.33013210714403068, -0.10222330805548741, -0.26897973349133758, -0.15543818288955299, -0.019525016231884219],
                             [0.10122175670638209, -0.17497059890671957, 0.093631605077972135, 0.31039796615109616, -0.43878371523625775, 0.15755851353780453, 0.61592947618798921, 0.228847665752898, 0.038351977527611186, 0.3982329226485351, -0.29252211620272928, 0.34925390774136494, 0.21369611405876729, 0.2985504499195048, 0.027376276976790737, 0.2373670897972425, 0.043518026125067104, -0.36367299439880524, -0.068162115201063009, -0.51074643614060444, -0.10157975045057699, -0.12742810821346925, 0.044631220085312201, -0.028155163324243927, -0.41039622784611346, -0.083566388187822721, -0.02299108353819098, -0.1126825475661188, 0.25460420903663805, -0.22884429639741502],
                             [-0.56059128554784965, -0.065218179706973217, 0.37860113293857772, 0.072290635178859836, 0.11300409937325345, 0.067015178024478858, 0.10661984262849712, -0.2990111087310855, -0.084843296973105248, 0.40273338528880076, 0.42060369217737265, -0.40465664831555875, 0.22169436914440063, -0.25340002309017734, 0.25583953220732319, -0.24805170195804702, 0.11239683479258447, 0.27288776343440113, -0.29154822846640233, -0.22402499904888473, 0.098005907151627408, 0.27691777912153459, 0.09410284871619537, -0.19708663091723411, -0.26738937807049484, 0.35446429413289288, 0.14398034362417741, -0.17321551494560034, -0.18915486136423429, -0.27228951806815349],
                             [0.072987170685690633, 0.077782932249390341, -0.061692362310300126, -0.26699701549201449, -0.68051728717069748, 0.011689472292430891, -0.14975448237303424, -0.026177156667411647, 0.35912806109822937, 0.074980258821446807, 0.089152114515897926, 0.10134832927432121, -0.30880409517771817, -0.051720610136970838, -0.62675857476472896, -0.18862098912195929, 0.075173264789063596, 0.25789425114760539, -0.0039002912710587104, -0.14966756688343, -0.076778151007151962, 0.67444094327213178, 0.50737350303285711, -0.27223377675941129, -0.02121771008051803, -0.27913361057181707, -0.092590754209252224, -0.26651489593233002, -0.01643750962568017, -0.043574085304438286],
                             [-0.54798173401486461, 0.30570705351202243, 0.38069867857469863, 0.48083885698070566, -0.3712793714063452, 0.016328917930628475, 0.091065769068922234, -0.047264818814318835, 0.034078249386817645, -0.003202339881414943, 0.023256951294755527, 0.31407518576970639, -0.54746073193849909, 0.23230367718750616, -0.22308026709363127, 0.29334695937752309, -0.3402495755799535, -0.42522624249592206, -0.62708629312949071, 0.14546855180109267, -0.013573165665698939, 0.2341064803156071, -0.14605473212719899, -0.11291203481545929, 0.57400765651280827, 0.072636104128545029, 0.082467112136323698, -0.18987782194089584, 0.23137003521118871, 0.24047347968200022],
                             [0.32971550074883027, 0.4565418495136066, -0.21410085959255604, 0.53129791374844215, 0.053377386836011065, 0.79545204387781576, -0.041937449234970628, -0.19854649882047062, -0.20275514926754837, -0.15589938821087734, 0.099268017914649107, 0.039724689699201302, 0.53677549597310115, -0.030152001052676552, -0.14115653044956095, -0.13482177220633809, 0.095428578655027366, 0.29379431850697707, 0.08523599653236541, 0.041809266913295368, -0.061801829714118121, -0.31116438118779155, 0.26219121608372781, -0.32297436747987007, 0.57219189140948767, -0.22413546996699918, -0.046502382478641351, 0.01345506863472184, -0.11370198962967203, -0.16961302213193527],
                             [0.14607241258891834, -0.32594419755537829, 0.20946254177984919, -0.18697013883488914, -0.45102693169820601, 0.24768267891109499, -0.015069278662798471, 0.12476710907576535, 0.056695923249843246, -0.082831575475144525, 0.45875113714111443, 0.08628566179378877, 0.056376528594074549, 0.078750209979529764, 0.25111482286592751, 0.23087390814071043, -0.015241786828790321, 0.48828060217847036, 0.072043198502013669, 0.32284393147518547, -0.43460541110754769, 0.088631053363323276, -0.029480662476811862, 0.30669591798177087, -0.1984549662096344, 0.11864318817954132, -0.23220636618910415, 0.22933910171441554, 0.011006499050572827, 0.6199019115728327],
                             [-0.018097678262128686, -0.22409481447116963, -0.14789537862540555, 0.22022123655096992, -0.018468861754566121, -0.32057166427450412, 0.13106722177400434, -0.17748450839463442, 0.18102769290617604, -0.17196869475461063, 0.14320305811645462, -0.40055503007924198, -0.050548584316980567, 0.37255214716835816, -0.092550225196863775, -0.10020382644222808, -0.43326265774168571, 0.31052754721530507, 0.19182540278705712, 0.082381625998003402, 0.21153424188423031, -0.58507014677616132, 0.56337787105841775, -0.27580023200495979, -0.32964042073449767, 0.33345164271653871, 0.53652714722470884, -0.21912985177656685, 0.29968750003770978, 0.10572029519502628],
                             [-0.42173108543125859, 0.040685914313548059, 0.39280955685801416, 0.48291544999800834, 0.046897217692839471, -0.28909816754173417, 0.32295948971573657, -0.35409840797726316, -0.08679560066780187, -0.12852193038225374, -0.43229181323915639, -0.12595547111104116, -0.39232759582097004, -0.44280244603921554, -0.2254302381637798, 0.50410343735553764, 0.47297619440949418, 0.15071692667424533, 0.45112606235518399, -0.11092899310380532, -0.2235369490278534, -0.17764896950859341, -0.21301918237727399, -0.047189671409502976, 0.17874022412860627, -0.032211402820978161, 0.020120705235220308, 0.087533519709419638, -0.019115846484427348, -0.097925144548662177]],
                            [[0.1425406738349731, -0.16655162371549181, -0.14150766007457483, -0.026305228896693088, -0.26303059826636838, 0.24261139067447776, -0.49864686386672807, -0.14985839357058908, -0.014448076056810644, 0.10372957242455814, -0.39373539797894858, 0.18326970514126278, 0.012454091923955839, 0.018568969834283001, -0.29963383845424285, -0.3817172072884486, 0.096048205909021939, 0.27934049018161211, -0.34919209902509135, 0.0078320834426593416, -0.069262349211526769, -0.17545132974975391, -0.32262631733748365, 0.55527701541554275, 0.090537586547818474, -0.12228108920907328, -0.24827451582831028, -0.47958919640395059, 0.45453057075816533, 0.11139641163901115],
                             [-0.39644568623045173, 0.1318551633951229, -0.32289151374079184, -0.02231472889315244, 0.042478441706377081, 0.35745860546588221, 0.56713566738489418, 0.11481919760574748, -0.048332274483141445, 0.32639399804230546, 0.39666186488835542, -0.17046904799697138, 0.25137027541852092, 0.19400313754457002, 0.22816763223020967, -0.19614192786138368, -0.15731566275597147, 0.1129197201749723, -0.020181694002200594, -0.24006346640830994, -0.1870992175651171, -0.016548159190289902, -0.39407154843279535, -0.051456633606530036, -0.015933159047266669, -0.26068388953474314, -0.52025687631491202, 0.053713740434442429, 0.14503883035366869, -0.47536557418175079],
                             [-0.0066114746543793207, -0.25487040187894905, 0.15865028791377467, 0.31568600176199346, 0.084530064682300426, 0.073528777295513104, -0.033266953223608564, -0.17249887346269116, 0.32601121180030657, 0.20861260927990849, 0.35603596466290771, 0.25984377894958355, 0.1682314896144953, -0.33415500513296081, 0.020548051933406183, -0.021450261468472349, 0.5814833986328749, 0.68165330558004444, -0.090588907072448224, -0.0038100311156452904, 0.22142340086966397, -0.38110499582666002, 0.2171653936863672, -0.12847244322449131, 0.28553903317755119, 0.099627155589849137, -0.1276793321501187, 0.51366492629354521, 0.26693479858086888, -0.060902444435920244],
                             [-0.14241028611421105, 0.019531486941962953, -0.28773030331276273, 0.76925876870610943, 0.031146736733039273, -0.28003649010000276, -0.16963426920816393, -0.12925537946221902, -0.024292005830130442, -0.21383621726728244, 0.25104397258662831, -0.015900616381260342, -0.25590958388527318, 0.33804164136881504, -0.17078378020874652, 0.0029080498449287912, -0.72546476648588376, -0.06681698834620145, -0.25814552684268655, -0.39424047466389478, -0.023674283352154046, -0.2925830309574603, 0.039616459031229824, -0.11267980049862864, -0.0035569923291149733, 0.33366085657591366, -0.57357200649389706, 0.25589282055395363, -0.074755876866400339, 0.37987962166123435],
                             [-0.035997561060363163, 0.15832437636972896, 0.15276571982160742, 0.1802377615456702, 0.16913612131019018, 0.11253827643669599, 0.20013556532482812, 0.12338337047153314, -0.17447492392357222, 0.23915331819868882, -0.22911650926833554, 0.41958496555973507, -0.019256578898506873, -0.6204518850709535, 0.045774223890926613, -0.14801764511279236, -0.15880173890115917, 0.22285363870192451, -0.36275778043301826, 0.12386189609711307, -0.21402259059205705, 0.23906793491028006, -0.09365190649262356, 0.064782316451368643, -0.65412819823291013, 0.46891535193580763, -0.093558810870116527, 0.10754351964222009, -0.33287095424806673, 0.22949283792805511],
                             [-0.12071782656171827, 0.075364246955814118, -0.36075955772495194, -0.081357540862620176, 0.040710194730343124, 0.25121192041105117, -0.137264503188297, 0.16405363657796085, -0.2235725181081735, -0.30035275348471918, -0.32829823200163083, -0.29173834113425334, 0.19277949093362498, -0.18839011470722863, -0.25516693521460149, 0.12934345089059487, -0.15520257889417841, 0.17463941020729307, 0.072628117290916144, 0.48897269223887541, -0.29532986188012122, -0.020853854135820186, -0.06486543606554096, -0.3827399565175667, 0.21392544721086287, -0.3767659007883995, -0.067182000592665617, 0.5382336909747395, 0.33953644081515499, 0.3410773520951777],
                             [-0.34918592233619489, 0.0034894869836064862, 0.063679932289967975, 0.39900240291290884, 0.043888393197366177, -0.11414223955802637, -0.2061328215580028, -0.2105624541231679, -0.31781828510223525, 0.28925574907158147, 0.092086024698839392, 0.38646074958890747, 0.24882748566314414, -0.014452550208720744, 0.49113973017460966, -0.24319453094299023, 0.28061995597536366, -0.16657322733647545, 0.35818276563610085, 0.27313639542201618, 0.12961349294908497, 0.24398532082681673, 0.3172516642302835, 0.39606663906749762, 0.050480027478195209, -0.16140082907160067, -0.1153440339612456, -0.20141471645301226, 0.418255072999969, 0.4030783926262293],
                             [0.013540210418737849, 0.54321857107488203, -0.14618048689560501, 0.47807304047914739, 0.25930987674023342, 0.32831534538826734, -0.20768058783900173, -0.23586757833455385, 0.13295194486102635, -0.18596580044935918, 0.13064393969767649, -0.072187702209237106, -0.22229522899952489, 0.15552853320108626, 0.047329485407528182, 0.31720988484095347, -0.10799606988404498, 0.28056870467007916, -0.29783685723753706, 0.28304076529640843, -0.13123498940933279, 0.22102618712738717, 0.093586552178760371, 0.15594595785229642, -0.18329308191796304, 0.5020461690600535, 0.14698711883745522, -0.20810556554266452, 0.38763896523640168, -0.51018746305120755],
                             [-0.37241403132407852, 0.29875819191454073, 0.039397494759676341, 0.091007672152625382, -0.37670094133251281, -0.087953741681958741, -0.24502116309033686, -0.38902604784559358, -0.052808672263690036, -0.15776385313211766, 0.13485050723010639, 0.10061537603852107, -0.51989752420829927, -0.46334120434196335, 0.22243427664172882, -0.27419181191408271, 0.24286420612265053, -0.1143341104587296, -0.34625591065172423, 0.045556203897546048, -0.028333682191542003, -0.17859152315659038, -0.4124896962599876, -0.17741505945125841, 0.0020913279946873434, -0.27385357742815553, 0.4144333500839687, 0.011095434486495984, 0.13585981312964979, -0.26260183954970562],
                             [0.23083616785726721, 0.39406685457556617, 0.35095243002950999, -0.058480627714039432, -0.13347822553642966, -0.027798548289275245, 0.24637053908973996, 0.2245283553110804, -0.28348485384758337, -0.20760302463118785, -0.12280283036109642, 0.6927345858343058, 0.25080437534420924, 0.17234836433483863, -0.2032419593280701, 0.18634306032235159, -0.33799227474120602, -0.04631436654222152, -0.47355070409195965, 0.28344009867629494, 0.39937309934252729, -0.19290389918308157, -0.21436256406799334, -0.10119532515651246, 0.31784139401279166, 0.042250488510838846, -0.075406973552120671, 0.31346773250050919, 0.43820963111674538, -0.06227855428347167],
                             [0.079165574865137339, -0.36838817770301535, 0.6422495388217706, 0.32501484830078403, 0.33562395307350751, 0.46834013601284569, -0.32852654008719656, 0.066132299572706443, -0.1857024239825332, -0.10886450845817723, 0.29405663408980309, 0.084980299234119663, -0.13224627833403479, 0.20603994703457024, 0.04251402155112427, 0.067287049405393359, 0.035175500161309214, -0.18884308016749546, 0.22124649660562626, 0.047110711596649271, 0.01679044214315472, 0.065365188750313719, -0.66270552521100723, 0.23021485528875754, -0.1302296229546977, 0.14017783406742029, 0.21023238256889581, 0.33448867537230892, 0.15053429465806273, 0.096789725941667737],
                             [-0.11486053101300323, -0.12624087507256426, 0.26239652768990823, 0.069922449783640567, 0.29700162141839453, -0.10693726425434366, 0.0071887544041200901, -0.24295218782379518, -0.28137247130591847, 0.1547683082821964, -0.062766035069595161, -0.36006459080808739, -0.24444348841222543, -0.11829472922645667, -0.52424152493829113, -0.35948091516782316, 0.078251684273016431, 0.2426938184279781, 0.23729160623553056, 0.46134763930060801, 0.70061337964335046, -0.0051359357252217519, 0.048237604968819632, -0.33650579087000843, -0.10385240109947384, 0.051115221952836229, -0.55956588188030798, -0.088813572881335651, -0.034540517416138332, -0.45946825550637105],
                             [-0.29260407609649752, 0.18945455310905127, 0.037946023037324278, -0.28117451359454954, -0.11891873294387359, -0.44966893368959537, 0.11705215749900325, 0.43218791069742346, 0.44828217569865997, 0.30683453171082425, -0.12710722807888811, 0.016126920229644941, -0.44169567710807517, 0.57280475117777629, -0.11430534773885662, 0.1711094481411099, 0.12364385955992507, -0.0031984882368302769, -0.21295927342060644, 0.21070731005657267, -0.19006673112461664, 0.21007329907282507, 0.025370527925813183, -0.18406385213399723, -0.57518315622393423, -0.097088649707152821, -0.14174354364369476, 0.065883722132083072, 0.42217418024092823, 0.11389963876279924],
                             [0.27649856075820134, -0.23079999894389655, -0.50132650715044857, 0.21810398998105479, 0.079783129898856359, -0.029943697821779226, 0.30083370523292846, -0.39939105545563081, 0.3187826208313933, -0.10663788307441745, 0.048559698756588131, 0.18611271416111294, -0.26036710836889332, -0.3305162593222753, 0.040688919104190528, 0.29732114546961558, 0.085125362962197679, -0.61764090933591387, -0.23885064357620334, 0.20356156793064223, -0.066459583727869836, 0.3084871213532121, -0.23131480564304099, 0.32739584645527076, 0.10278653355230093, 0.052079376202805498, -0.41500832735563575, 0.18255362351009968, 0.11345016089553239, 0.061964869776090642],
                             [-0.3597435140465966, -0.14860243512266416, -0.052612045008958087, 0.026202798612778772, -0.058773605262483583, 0.20861054497826395, -0.1416793941904384, 0.28347691631821609, -0.10622878069855977, -0.24334826485613703, -0.13603819002236178, 0.76832311109896423, -0.46074709492353089, 0.097439831721516559, -0.14626404570315538, 0.27723678774571087, -0.0061377509351758352, 0.32801724441212676, 0.11644247418057636, 0.005415176333568964, -0.088641107550431933, 0.10922449962577857, 0.0054067942758579159, 0.025401152441296426, 0.28849734949107364, -0.031445972892345846, -0.22760846449813196, 0.054418521484068047, -0.6216475706330632, -0.20390693712310229],
                             [-0.40578069561776342, -0.13060946567874193, 0.56425606976889542, -0.096061098967390776, 0.15541555448618882, -0.13310301315753684, -0.073857735368242139, -0.052250429683619648, 0.34074172243074308, 0.14089441765660823, 0.16253411375827892, 0.037253755119924799, 0.45205341759919149, -0.1093958737407585, -0.31151819951576798, 0.31261654911481312, -0.53544377293180823, -0.048709987096164815, -0.35087079623829232, -0.091795546051887431, -0.207932349972314, 0.34842399309895838, 0.0040531504583010136, -0.0981643488428037, 0.40177497402146267, -0.24835380114985836, -0.13484959617601458, -0.17181093558813376, -0.089218126754054938, 0.069849841028839912],
                             [0.32063103167727014, -0.29057697907231717, 0.14492633352884085, -0.014553766847249079, -0.28571019547421256, 0.33069795216489717, -0.25661385545299498, -0.12265890641618307, 0.063578181907591833, 0.48008097468465422, 0.086423210382136031, -0.16395721120971976, -0.076778150758746472, 0.24907563847115946, 0.71131512857117907, 0.12998397943724005, -0.42978602067486699, 0.14267219641348416, -0.24020894308044077, 0.31986878419765141, -0.066113794481766713, 0.11031700511181988, 0.3671308605270085, -0.50229596603069404, 0.3034032869856908, 0.026443558645213923, -0.24521719669395686, -0.022924515538990199, 0.037015036974667445, 0.26673429318564063],
                             [0.39036614463298303, 0.22454542225461568, -0.062679871861329353, -0.1979983997875262, 0.61909196543704681, 0.059047991048546196, 0.1381599045212959, -0.070647851988267202, 0.26293564290683857, -0.41740776275608177, 0.34378449339139916, 0.27018622749548149, -0.082689145442942757, 0.20844404359612159, -0.21633523660417267, -0.95000081901689615, -0.1310150740272357, -0.019433155185515395, 0.11687693500771812, -0.016601460790066039, -0.29287667937557149, 0.19969535128172913, 0.1694972689273713, -0.18576529455530566, 0.12669680647543502, -0.20211727265813917, 0.21614040801095036, -0.058306368107013812, 0.26165321693105026, 0.22115108047261592],
                             [-0.4022220901568288, -0.15176946931505753, -0.14205784650215769, -0.58514233215990263, 0.24171568401388782, 0.35530988287695631, -0.16327646470388293, 0.050958484400649491, 0.042859743461382202, -0.099784299018666353, 0.22498399454846316, -0.024722618088592024, -0.13476341702629818, 0.0041188499662639273, 0.018590228689410754, -0.11051221411174128, 0.15999207593017126, -0.32692529732505071, -0.49431139817922753, -0.02765448390707298, 0.080380935405278617, -0.40952305439911946, 0.55342405129184147, 0.055503587205475852, -0.054919021245433824, 0.42893829273295303, -0.027464081983196675, 0.16253872629519003, 0.23412154800184479, -0.38453611959580708],
                             [-0.074445424803826279, -0.27869012606285537, -0.11897005272568414, 0.2142122155746263, -0.13494034397833102, 0.057046604100381551, -0.036787817138806064, -0.19484165779159196, 0.085138288288410802, 0.12456740849676128, -0.27387257332149756, 0.43057766987696666, 0.26942399412330381, 0.23416997570457126, -0.14606737452976548, -0.26176890011979881, -0.087565329700652672, -0.43503014436409898, 0.23584717489972079, -0.33286807173272692, -0.28597964993386432, 0.15970981681406873, 0.086826900349763522, -0.63162578840120176, -0.19123502581334473, 0.21230881490499082, 0.33759817777719636, -0.010897600609174277, 0.24679074328814718, -0.4069138715041461],
                             [-0.0044919126229398254, 0.26620964343708498, -0.21897629000692062, -0.23669859155191258, 0.22020627162222273, -0.31699243337349331, -0.53978610866713117, 0.26683866139938606, 0.11808240494807608, 0.48112564307020494, -0.028783587264293496, -0.089599114523325057, 0.038729473272402365, -0.18483387763442272, -0.082748476934060039, -0.15259406576245077, 0.18676969237282537, -0.11479031161469665, 0.014002520789595345, 0.10397403317858479, -0.11409271718334806, 0.38945326934754593, -0.32803455412488003, -0.37898694952768758, 0.43340472612234993, 0.66303818612996279, 0.20819937965648561, -0.021614350089072774, 0.032452415145211917, 0.0604655424463241],
                             [0.164016982344795, -0.043215366309941064, -0.12189393445207926, -0.0099833302525964909, 0.57754248253352936, -0.12236182236254514, 0.010441618377116834, 0.38927926836524446, 0.10405716218485678, 0.26890269775340148, -0.23630187520071891, 0.20038439622929646, -0.24790378550682815, -0.32394465683032225, 0.11574548209711781, 0.13556991816743799, -0.60161445021421822, -0.23095074104360191, 0.091234037898619627, -0.17980747653660833, -0.072211208099129814, -0.36168659718606744, -0.027748221387228714, 0.14913735976618156, 0.082561978713058204, -0.20043527566269603, 0.31655298353773287, -0.053731527602658383, 0.29507055250884867, -0.14573252806023035],
                             [0.057277313268012268, 0.070106943345554756, 0.24918278540175248, 0.2240435577736184, -0.33752029327168687, -0.081048396947284246, 0.044954967469194328, -0.024725369331353317, 0.31976439104466831, 0.032697517261590078, -0.21503202385568096, -0.40471543144315675, 0.072351716716522185, -0.038867033521079508, -0.073342463528810187, -0.53088262959029675, -0.25596542311602033, -0.068676422837055606, 0.26976106975718206, 0.53221494359968669, -0.33287959298315217, 0.065427349060585754, 0.14440895810887897, 0.38600043918422372, 0.41249351355581299, 0.24531200907556314, -0.089050614604784251, 0.38914665266192866, -0.28627782316361872, -0.35007754731065949],
                             [-0.18395987459663174, -0.024914704765002436, -0.29458504494885579, 0.464147576869953, 0.14257514317276793, 0.59094056180866528, 0.23963519306711242, 0.24373335408703301, 0.39526479195449721, 0.23086678188141441, 0.026654162135424951, -0.094807091711634484, 0.11543563221182229, 0.21348610198884391, -0.36294790624354101, -0.096420099092836345, 0.079902365017472929, -0.2107161648041399, -0.22057408887845528, 0.1879540488441831, 0.48664608579641483, -0.029057260284413914, -0.14194987617896238, 0.22694467996999423, -0.041048721530712776, -0.095772883636806749, 0.70414675844386632, -0.15528748619394664, -0.27793219159125587, 0.24845600336320176],
                             [-0.062889807523232588, -0.049548487103115449, 0.25374365466906135, 0.40838732516875925, 0.32920832331458538, -0.044999593684852318, 0.28935875540361561, -0.080729438062761311, -0.34473023156306704, -0.15256911410522531, -0.59302084630947915, -0.36498635623201736, -0.042059282817185434, 0.1826880130413901, 0.27851245155045629, -0.034595810686171208, 0.62889897200662648, -0.022966704456621356, -0.53430861845862798, -0.37122538952429296, 0.010038143975834662, -0.15972748969686898, 0.10103708542050127, 0.028107290919578615, 0.47135894256023175, -0.24741671786572095, -0.014285840463645533, 0.11214046024719773, 0.14450176306219828, 0.01566411087509095],
                             [-0.23079592157727036, 0.10164741250441434, 0.17961780310445127, -0.019509049465206974, -0.038927266122232053, 0.067626184425195593, 0.18561236436976594, 0.13090837134638053, 0.64442646602546039, -0.58875675760061863, -0.15805426672450093, -0.10609816499326837, 0.24045961319944803, -0.16284833615286182, 0.45217134398273934, -0.18403516363349967, -0.052693559425846401, 0.092398792850819561, 0.18706277804124424, -0.081509804453886642, 0.30626157265971393, -0.082419408900664709, -0.16903694782318338, -0.3162820087094414, 0.039305128426394047, 0.30242360823641534, -0.29736998198150971, -0.18668599308238204, 0.028530405059848701, -0.10603038186605851],
                             [0.2766846453992618, -0.70299612193057714, -0.10111626672640844, 0.37922513690976173, 0.038259973288727739, -0.47573112870081519, -0.05563599241363542, 0.64657773032849142, -0.078566724940596799, -0.30979716993578277, 0.15721371453605362, 0.075160003323488017, 0.19145523960001776, -0.11053828946256232, 0.11632050850554085, -0.14244377847469639, -0.22958239077332537, 0.080166029417496204, -0.36806743732310621, 0.29072523685560209, 0.13264137360831085, -0.016255260815929151, -0.055090275711072362, -0.15172051601414877, -0.14726241567466991, 0.040980142106045073, 0.22120874306534902, -0.25706134039510897, -0.28487729236850556, -0.29775416353918738],
                             [0.35983662436834346, 0.11438640062187469, 0.1904706442749716, 0.35396789442766496, -0.4607056503499431, 0.36203603649906785, -0.049815546561609858, 0.68896647460062299, 0.061846947766526605, 0.029565890564519165, 0.2429263103895761, -0.37376441974905061, -0.29131730163476011, -0.42135565912755091, -0.18729524437479766, -0.02222621887437385, 0.019758760756463184, -0.3761934346657419, 0.099818391324594968, -0.35834982082958688, -0.16777885529567907, 0.17548262489428984, 0.38270922448701777, -0.0085001540527695901, 0.21081272802121265, 0.16831951602863293, -0.17239456415010987, -0.064864898395460002, 0.32460200850563725, -0.014342029091869294],
                             [0.18100872470257481, 0.20803079052168977, 0.21678633331754027, 0.22850264567000034, 0.31770103754249929, 0.079298189257552873, -0.3110081299277761, 0.030565252879446433, 0.14639398018597505, 0.02912736310047552, 0.10061263524538779, 0.28368360527832798, 0.22952469118413707, 0.081468840980631438, 0.17270588906626724, 0.40280794907428136, 0.48905597899336728, -0.3779750908159859, -0.016552012701994571, 0.23661355900489361, -0.35392256158651975, -0.76959281434504723, -0.10911467141727009, -0.37736709012722858, 0.059447456569762303, 0.017513626370901376, -0.27786866514070896, -0.35921259186270654, -0.35585911020857436, 0.025339615498085347],
                             [0.291350869870316, 0.34806452177400476, -0.10649273137034855, -0.00095098955899621668, 0.07533968604965853, -0.081903741826692716, -0.54593893741835753, -0.020256558753403594, 0.28233029453552283, 0.016177868749123015, -0.0080067684273735402, 0.057407281166900609, 0.11922283373253438, 0.29956970621713286, 0.19112997919215255, -0.42089696983922531, 0.086726212938125991, -0.10618451682986217, -0.16089423499971561, -0.29249962702338117, 0.38554544488939207, 0.26899609020931686, 0.090427903686558092, 0.1804220161530416, -0.4407862458355073, -0.59432226664637733, -0.18362837603961937, 0.55230317804157059, -0.32116601638355446, -0.13504904291614903]]])

    matrices50D = np.array([[[-0.47552534673541785, 0.27031855406317751, 0.032692721036663513, -0.0039932554855136946, 0.23784017418573694, 0.358425020101934, 0.0012995216144631293, -0.11326635204054501, -0.15910398905256057, 0.2982019383808267, 0.020634496186201879, 0.066926804742498236, -0.055432037477975725, -0.010792137011634787, -0.17409301307407482, 0.01231551504454014, 0.4213164047478089, 0.24960744865829079, -0.077745219172000141, 0.29703478894178198, -0.1841794024167642, 0.066244184001912718, -0.30655437585176798, 0.13180656421304585, 0.20342026399264634, 0.083188394622960585, 0.23263116477837589, 0.22392359309170332, -0.19151412043218377, -0.10715067291988468, -0.076491857923491322, -0.026813887824644285, 0.16234520991184667, -0.088608934220071656, -0.050334781162683515, -0.076256716794606258, 0.17819500139133637, 0.20862344117295037, 0.2860535301141216, 0.090887374154250702, -0.14453142303682864, -0.12110369998704722, -0.0074444094061986224, -0.098056147701936061, 0.19609965754066033, 0.38243023214139948, -0.2212358142971875, -0.14674076146630219, -0.037159561339259246, -0.2849468750978762],
                             [-0.087607688271541057, -0.12395226282071527, 0.43180373071539746, -0.20289483281708542, -0.2944364564591761, 0.030370690795578081, -0.19273156052657608, -0.17165364406372646, -0.26732339027328217, 0.086645996394095287, 0.029090721090400035, -0.27974418383173227, 0.33121992928789401, 0.060281892530625374, 0.047705530416372197, -0.3042279501856946, 0.23419434149051724, -0.016063737966832553, -0.054881350416778815, 0.4169782800963886, -0.13080303598959792, -0.17399393320220027, -0.11090675111264897, -0.067397556970780065, 0.11990615310146961, -0.085548320080475179, -0.1580774889864166, -0.37994979829895675, 0.16280965927968905, -0.12022385520975173, -0.16816369920908497, 0.18432724810970413, -0.20070467690554697, 0.16475351776998037, 0.21167017531755641, 0.072966727456897446, -0.19670075525421116, 0.039997202720850687, -0.062220864730410205, -0.30644468869842217, -0.046310247073219915, -0.29560608059175703, 0.04375104559052833, 0.27638551897860397, 0.27048875032427272, -0.085561792092749306, -0.020610304165849389, -0.036071921329555973, 0.095883897632513093, 0.16799914771560803],
                             [-0.094959850846080343, 0.15165369894251302, 0.12281397475789978, 0.15899716878617529, 0.083711056249505769, 0.12170580912912793, 0.20718852976572424, 0.23039523133561016, 0.078557938989354828, -0.27288556549290161, 0.31159390365474599, -0.13303924171342174, -0.074890358259368725, -0.23051336493465036, -0.10857249937895921, 0.018739594035257896, 0.16494879246430652, -0.19164281596191376, 0.045795172109282557, -0.072440673673841577, 0.33705115252253626, -0.086424177671130878, 0.12369896755802243, -0.18416823017333708, 0.27390067602126972, 0.47916801390983771, 0.072990689273790099, 0.12118053362507877, -0.0042046878513357549, -0.17225045040248591, -0.012820683148506991, 0.033699296828865972, -0.11597759989396048, 0.1393407209885372, 0.20510643769417555, 0.12531346488817549, 0.17619657884439299, -0.23097497782576107, 0.058206245872026101, 0.15475145582004338, -0.35375056546201389, -0.50121623221447464, 0.064245360150645109, -0.043125818599314594, 0.21274496859910511, -0.1340951674766572, -0.3878546019095569, 0.35390398013655283, -0.2144556246378618, -0.11577026703758654],
                             [-0.1391318626871246, -0.29803952382215487, 0.22198970874908322, -0.0048301838515200706, -0.091545114995946725, 0.2348923208541121, 0.038200643087499313, -0.28965651787302726, 0.00058384771352607088, 0.13747748212252772, 0.24378777296594981, -0.072857889552884275, -0.55276780789634106, -0.21833676292023363, -0.10030371079378791, 0.018816279293366656, 0.040828713533655213, 0.062599804966005992, -0.12048818625009608, -0.037846113358720852, -0.28253496249387422, -0.2198075565433098, -0.03521465551347476, -0.29536210571226795, 0.067014540542771422, -0.21500433059379312, -0.10952611840151823, -0.076019819927793095, 0.08555479845338447, -0.0855973210320157, 0.063822198408876152, 0.35036669235724832, -0.34684655620596294, 0.24709442035412704, 0.19692685683453062, -0.038892775854970828, -0.064853890872210287, -0.48828728727111248, -0.25082621433507579, -0.044362100620283021, -0.26017783830175251, 0.40112446093508519, -0.14382809473400518, -0.24432230051456616, -0.19928598516791146, 0.10933080608792581, 0.40650715682705341, -0.14163674576509583, 0.070784517922417342, -0.28226952055528926],
                             [-0.014988764783633798, 0.075105577119327485, 0.19745220454150386, -0.53097228202594449, -0.11050004457203549, -0.16489763083491832, 0.0041260456547809535, 0.11450549639048389, -0.21383781423792139, -0.010933646583036107, -0.17773878639470325, -0.1364863666907252, -0.29554339202082702, -0.17484751361145137, -0.17574449846496387, -0.57068614357450609, -0.030888778963735632, 0.14960422388532793, 0.17807076801293362, -0.5696334797214716, 0.083151126918385096, -0.033477419336012705, 0.33963410278474987, 0.087507088987940976, 0.019262756283381859, -0.16428699582468484, -0.14487590312080151, 0.091820473349351589, -0.11204627533994221, -0.30172030032030794, -0.25895227707850543, -0.1101839933166064, -0.098274184155289185, -0.24828522757712965, -0.055594016993929359, -0.1671029334359912, -0.37308328498225601, 0.023785211032179468, 0.20709168623223725, 0.18235756155572833, -0.051549686804794194, 0.050653145666204713, 0.21481285593323957, 0.024459080363842339, 0.2065764112460273, 0.01590311690670114, 0.031539821919152021, -0.056673453717208472, -0.31370835912548672, -0.13688845455539525],
                             [-0.0036905371285701413, -0.031275697292314775, 0.31327155113220279, -0.10038130407370607, 0.25337027856418182, -0.29977888666038671, -0.15494071944027307, 0.14924824723841124, -0.024891099910813189, -0.13115172582557702, 0.025656106986548466, -0.041966166399826935, -0.053228972540008218, -0.22812470699774579, 0.34585377774289833, -0.034932175360329332, -0.095467376730317188, 0.070580268041161812, -0.56381457885688846, 0.16099556352826247, 0.15562923770984993, -0.038137178164876141, -0.078673554304780305, 0.26843275352506268, -0.41264170227138713, -0.14502555719726981, -0.16658761261929902, 0.50139959584625582, 0.29391461256898438, 0.05591797027909793, 0.23023946381042723, -0.25679196664597559, -0.046074292044477418, -0.11969994371156724, -0.20843991201927353, -0.071292863414883223, -0.22056163423607711, -0.4351702681373848, 0.082979989717423236, -0.061309028120823839, 0.14713742449969192, -0.00052234753615895343, -0.036212614713973183, 0.11900947001070333, 0.21911662281483713, -0.046760017209307711, -0.043119404348631978, 0.21817768623327008, -0.023663677254811465, 0.026118824852581796],
                             [0.14149253048192736, 0.044112260831699779, -0.30692147178386897, -0.38080859227298525, -0.31799358087707202, -0.30228267465231157, -0.13434468713597722, -0.44309228586985078, -0.65497168076562118, -0.08908988737679957, -0.069619884352589964, 0.18398823935202493, -0.070206535540824927, -0.025211762252558761, 0.08667373302052668, -0.11549684093552375, -0.1619435758415409, 0.26330667906278887, -0.10657638251392769, 0.023470342119850204, 0.20899185501118109, -0.026776868267651025, 0.22354757462280897, 0.056567149629362927, 0.023425387639548531, 0.097382536349708698, -0.17968542124645545, -0.2749769825505905, -0.26989169393860102, -0.12971376279912725, 0.18902313379406363, -0.21151705675021609, -0.11052104301716958, 0.050772950165088815, 0.11380252348622427, 0.095472204384057111, 0.32725791657508246, 0.083131271646439978, 0.1971042722327101, -0.12897957650822789, -0.25491400653438256, 0.12077716081838041, -0.22860782552685457, -0.17837720099600621, -0.15504145178712428, 0.10956541249918908, -0.043566912321972143, 0.083050465434398216, 0.058697739979776217, 0.0183166951616184],
                             [0.38409642183640175, 0.39517487290513509, -0.15402129716809906, 0.011602408086630033, -0.10475865491835984, -0.10001243502106877, 0.25130643941271902, -0.082936442055061704, 0.16618989395515868, -0.055967750122467033, 0.27338784353810586, 0.11162504294747383, -0.087071471743180126, 0.23214041985575903, -0.11128303752963492, -0.071496705448451783, 0.25718433563778997, 0.07883795319223752, 0.27779388176129494, 0.15310401190623207, 0.35248141944822259, -0.079222654249279795, -0.33012534031225965, 0.097991088773895632, -0.46808153380596318, -0.02797655604808948, -0.29993588590561238, -0.080577213382799912, 0.096137651665112858, -0.14685096089796326, -0.48831252950998144, -0.018844445549730825, 0.27469639533617379, 0.093102906824536591, 0.059858532050557647, 0.17483476066269585, -0.1043260521734984, -0.20158449882556809, -0.006140456014872525, -0.31758683090363959, 0.17748551692349418, 0.0085944940284754141, -0.10971642615592428, -0.083051708612647851, 0.045105078055271447, 0.31479647572571479, 0.0012145243260212133, 0.050266143207959739, 0.095119227287399258, -0.40245902242529047],
                             [0.264443449209045, -0.054572664505571071, 0.066929980478596926, 0.14155419388971383, 0.083136772064194966, -0.023868568141012521, 0.056791259880876965, 0.21480718921274494, -0.30451585602341469, 0.18194901694854704, 0.15244690984147341, 0.14067392123790906, -0.21685792194162981, -0.0098031167253427726, 0.41275329724646193, 0.0053616889893589002, 0.10464143551679075, -0.41531163404050442, 0.06243502726701812, -0.13898496213737468, 0.046627076415582454, -0.030776552739080566, -0.16280397086136922, 0.32707674214407156, 0.35971831547151911, -0.060602834234853735, 0.30087807754833845, 0.10479240199445447, 0.35133940750376302, -0.17302198789084541, -0.55689801192413746, -0.1244117440248461, -0.05652964862439739, 0.11912395614328743, -0.31324018589091884, -0.11923022506644672, 0.34326885036255245, 0.17087909018363959, 0.30973844299038789, -0.16607001913113642, -0.11619746909675216, 0.29076351909752357, -0.15273788155360551, 0.15965170596820485, 0.025820461191634218, -0.39049716894913511, 0.01248926626572814, 0.12471229654544658, 0.087431786078465162, 0.28649906555227872],
                             [0.35841037043669577, -0.01042993551792233, -0.1218621022742867, 0.11934534017087985, -0.11127011220584604, 0.067844140316319093, -0.028325464621686822, 0.22620730716596335, 0.069198922313019273, 0.061706667220777375, -0.080066881585097005, -0.031999415118944143, 0.11746457811123856, -0.065614740753229317, -0.045754293408667782, 0.020680419456047056, 0.31401994943326628, 0.28015337347193958, -0.31007732608552058, 0.22525877110640111, 0.017280797503815372, 0.18125863355613936, 0.036092705730285737, 0.001667893274188828, -0.096397183649855028, 0.073293326955593943, -0.24930287618394401, 0.35891234272041506, 0.020193556071077763, -0.18390966875454384, -0.19974276398813615, 0.33767568552576993, 0.025791825162425196, 0.095536047534186055, 0.18910742679661513, 0.083464648021614019, 0.52088560389778105, 0.20709080715703951, -0.052535612587551433, 0.083261080763487247, -0.016207931162782237, 0.054136908388051311, 0.20942812897557164, -0.085158715191748099, -0.017496691545863152, 0.08527242334403852, 0.52442408855246603, -0.2487216623597549, -0.3603956576742342, 0.35386255491449947],
                             [0.19628033035707182, -0.065829522262716392, 0.30669311543186484, -0.18326068426287606, -0.16074575865290194, -0.32343664016772022, 0.057317649313719972, 0.1811118017612289, 0.019870179362252237, 0.37137543652446009, 0.19026423417244065, 0.10667742604024144, -0.083175722295463383, 0.069371195981493564, 0.14362100936588529, 0.35532212924489187, 0.18719283413473831, -0.057581722401844573, 0.17890834063360461, 0.27543630334295954, -0.0098321141116628312, -0.11351174162614983, 0.3299802576961276, 0.33263185310452031, -0.24142342425913388, -0.11796733591097369, 0.2633891506878564, -0.1544814373843888, -0.15112370166754374, 0.03420959085605222, 0.098597064434247234, 0.13436109193607715, -0.083913587668897796, 0.24028080443698202, 0.011097019838321759, 0.19739270517554974, 0.14176378512215082, 0.017531046568627126, -0.025113230377824571, 0.46831166205423796, 0.045260596427012106, 0.052170998084445128, 0.2690932820419184, -0.093749824207219598, 0.2134239454354358, -0.012708080838622182, 0.074917944453016916, 0.36016473505533081, 0.16250605864768886, -0.020865932517488268],
                             [0.15171456659182181, 0.48491783957413526, 0.092658146374757264, 0.11643838746640056, -0.1189019692757837, -0.10556255952993078, -0.0067268175969341787, 0.047011899442808321, 0.31374086362870379, 0.077159541400113801, 0.045745686829935878, 0.29463837608111432, -0.063627444176417608, 0.14934690212699617, 0.38502620557612499, -0.088094697377812239, -0.075598713446525134, 0.0045719259440209978, -0.1097114706858226, 0.049477389792690625, -0.4152992610033982, -0.2949302049156971, 0.58320470551366344, 0.10936927499879652, 0.28048229781137496, 0.061670176815565768, 0.11657019078032643, 0.076806117457649897, 0.18828498629166335, -0.19464845055102981, 0.12738377898355216, -0.38834893559658962, 0.022265526641903753, 0.15036721694217914, 0.12520372248120679, -0.30021226834158454, -0.070573969475328763, -0.0773251369674164, 0.015626716235946254, -0.26429057745330053, 0.1373239587260297, -0.12443506143266164, 0.15200477412556704, -0.17830919746715201, -0.080143845964170249, 0.29242647128234472, -0.29152097734993676, -0.067908204514531084, -0.13101047805781918, 0.065105001744406685],
                             [0.28808876281664025, 0.072602860496815441, 0.028502010069414468, -0.0013716923400371173, -0.025355053906908703, 0.078653564138308873, 0.21413152829029766, 0.077859920685753745, -0.065440069024551545, 0.36210297688356308, -0.15915331107799013, -0.23596412540371295, -0.07594416208666907, 0.16523380682499988, 0.0079859368956260689, 0.11717939240476205, -0.50490299335573741, 0.47120998547774406, 0.10845603215574522, -0.12869390525000257, -0.16455781065378039, -0.19992148676637622, -0.32168161722311084, 0.070556639778828881, -0.26003085466026599, 0.11293655822358722, 0.23914164778836472, -0.038083339409263589, 0.22540880061715113, -0.12070721817059239, 0.14372579015844419, -0.061552217732940964, -0.46861924002590422, -0.26927900510208597, 0.25204771554816185, 0.24540012481144097, -0.017006085621690554, 0.17142505045761977, 0.29058166812977054, -0.14543936848013567, -0.020461572297326473, 0.28378316934156178, -0.041009714667249737, 0.024127009995153249, -0.17773890036317649, -0.1923971523011927, -0.26749366467517288, -0.18952082372463724, -0.47190208139341294, -0.08187186729593407],
                             [-0.26010167733251138, -0.16343441312400697, -0.36195299196787817, -0.19299960882289771, 0.15385126905880572, 0.16520947206838632, 0.011186140647041633, -0.058810945991879221, 0.3906244698107455, -0.11012200593154248, 0.013587237571592895, -0.30232039015865342, 0.16137230302783245, -0.23707615110747107, 0.19571492250148145, 0.28843516908060052, 0.090927927079372306, -0.054586065734602396, 0.026986193579590124, -0.057729806400398584, 0.39385296869375019, -0.32242744859010969, -0.023338405818870357, -0.11045325051553027, 0.034016987013762025, -0.22075528301180941, -0.062882414736738265, -0.047818752745344043, 0.19211258739443662, -0.30608661130231035, 0.16093434681911237, 0.10587942503627658, 0.091304769695691262, 0.58924457062865376, 0.11745434545329349, 0.004518115494383774, -0.013728801857614218, 0.13454652353734387, 0.26744179302486226, 0.15023050395490115, 0.080233820043037557, 0.16682809206887286, 0.16278299430223447, 0.025762124384935511, -0.09897584929726283, 0.10547698461459948, -0.16971328936715549, -0.17865866569705213, 0.10126112521482628, 0.14357147085013652],
                             [-0.045927310449102157, 0.42586506567687499, -0.35606964891583104, 0.10967839751944404, -0.54105617665046313, 0.039588031855717305, -0.11463535073461248, 0.024694003878913878, 0.089898665204982658, -0.19465272664205813, 0.062273646697521681, -0.15079810042369413, -0.00078090772064236605, -0.056810576482815428, -0.11940120565264557, 0.11920680483395563, 0.003819167487013414, 0.16942439309176888, 0.19814209497521579, 0.065338484186216822, -0.15622787906728985, 0.22835126581865126, -0.36445107685786821, 0.061487873285109178, 0.25097835209810271, -0.42908652421289584, 0.057789295822496464, -0.14151662427987799, 0.02805045214864673, -0.39434311829810487, 0.027919996511236615, -0.2627820839524258, -0.15653463704990772, -0.017573141309866376, -0.15436691937447247, 0.18189094929633182, -0.0018828095816267008, -0.38740345509366098, -0.099221482730754193, 0.11530090236647161, 0.21568471423707763, 0.10746628676749082, 0.071099244320828051, 0.0051826516693277945, 0.040085964812584404, -0.010422973860907594, -0.15620617673198889, 0.20121773426698075, 0.087390749230723638, 0.16954442232370806],
                             [-0.33888022764522835, 0.28906811543816241, 0.30933395363287969, 0.019356002113570456, 0.10709157307786682, -0.071899164321754527, -0.36212735191974954, 0.02072662409484545, 0.38356693747068787, 0.29504647262250588, -0.16414234086234133, -0.28800584552080793, 0.15453961260613225, -0.17124202669560884, -0.27153285433447244, -0.23778168126155308, -0.12073665963948585, 0.0030122556742300738, 0.087362487639625272, -0.037003889080041145, 0.2447686453231743, 0.26636737026160545, -0.0022181830245180589, 0.31772080035258771, 0.0095796649233403069, -0.0455005189230301, -0.033697140995677624, -0.045456730655942995, -0.48846860871478992, 0.0048749278432609292, -0.23694052742229249, 0.060482222832703568, -0.42028906399659982, 0.17841084488903475, 0.1488204750748211, -0.24436415225539215, 0.14476664405370701, -0.10144639793900251, 0.23859141160403394, 0.013943101898801286, -0.26430908034066519, -0.12343667796373535, -0.44959664045483316, -0.45489058723806414, -0.21609673213481254, 0.0061508670575001374, 0.10927410382418143, -0.10876550152578006, 0.1453380270362698, 0.12226979887230878],
                             [-0.28817653963874829, -0.17993107153045967, -0.12196905640872298, -0.063036291431401131, -0.19265269626241546, -0.012897700545395923, -0.18378781272769576, 0.056274587228589718, 0.21911380184974877, -0.044679471089040801, 0.18453621372317225, -0.035604798233833015, 0.018300238822761248, -0.06155802607706188, -0.096518188177697181, -0.069017374419859598, -0.23508661181335433, 0.15678841721274456, -0.10322595435858142, 0.20827388313547468, -0.32130198754838102, -0.30197165080326055, -0.042779887903347767, 0.17663471025759075, 0.058037634271847896, -0.00027462137828114866, 0.036503959037465894, 0.26114387980113407, -0.092297589522011267, -0.1873939037878076, -0.18244072492180327, -0.25389568862971651, -0.0072126683084754208, -0.052831590470613587, -0.0011326159766882615, 0.28805059565934354, 0.11024001182998518, 0.20625799737904746, -0.056022216044150794, -0.02154909420638678, 0.063827125078202068, -0.28703577603818886, 0.22016259207031305, -0.13599838297012537, -0.065857317706626464, -0.34239586335363903, 0.11919569745739457, -0.29971655301745709, 0.64774106641422957, -0.41648973507482823],
                             [0.19820377713422002, -0.10014807870903873, -0.26021751509507451, -0.090953239152127011, -0.11494839032727736, -0.20313231136311119, -0.45243206162983435, -0.037087407088601095, 0.2216924519710024, -0.20164179952869732, 0.24165554945181209, -0.0020989062958333866, 0.051633052598065783, 0.27990513899825847, -0.075545624316456533, -0.23511886468011683, 0.15140001376889975, -0.18634421207659743, 0.33861482235452389, 0.17526631771791978, -0.065451010320252231, -0.11375420780644258, -0.074423444988485105, 0.13378798343137455, 0.29672555425055758, 0.041603558138060666, -0.028757771952051571, 0.3501064386809386, 0.020739395932012055, 0.2628767176927656, 0.18424406817870745, 0.26474334035912234, -0.55421871328122796, -0.058374331496065052, -0.30625306566642041, 0.3698668018025873, -0.023591348859387469, 0.10447416856658549, 0.058219182379391672, -0.20401493668538268, -0.10414921666944194, 0.20567559646545933, 0.010494271402360105, -0.07739942436689029, 0.11351525317495345, 0.099983023693608591, -0.26462301960629248, -0.002023564632229146, -0.20521659587501087, -0.090285430672458353],
                             [0.27715536088364034, 0.05210477385848513, 0.06078167540922548, -0.41361873129704835, 0.3075332226890839, 0.096047571367236795, -0.21539321417198756, -0.25564340773861932, 0.063505947080157624, 0.33985902210348101, 0.040995227898136838, -0.034562593547991682, 0.16732356631227863, -0.080320168635136885, -0.12186097243766661, -0.08905163587263959, -0.0097173494521105019, -0.56635722960697188, 0.010602639384582436, 0.42614296836040838, 0.18090712321135122, 0.082153483679318504, -0.00030771581711026017, -0.13306920801029667, 0.051269505711225412, -0.40821285935744889, -0.046017421905551144, -0.20615229006795321, 0.19034354240284362, -0.32553980213040096, -0.054414330787327499, -0.18869380780296655, -0.042573479210476002, -0.5514957265243714, 0.1355679297600412, -0.24686312985256381, 0.20481061270225809, -0.10607505628394133, -0.25183819144253666, 0.062349997033710837, 0.034439381431648625, -0.054564490211957715, 0.13716881813948026, -0.22979390016180193, -0.083114592450009697, -0.20354863267606441, -0.044520507726091292, 0.18862298853778353, 0.017258355254763331, -0.041087532008254581],
                             [0.19232154466171383, -0.26808959949809602, 0.1570077567551795, -0.10199234399917304, 0.10480032818950342, 0.16263969610000131, -0.20634073131918051, 0.33575645330826426, 0.24098701315077301, -0.090637914115402576, 0.088457563563964295, 0.28545968267401373, 0.45161347952126091, -0.12956808985409085, 0.22713237944153225, -0.21318825349324311, -0.088438157052114302, 0.42305153562326842, 0.1141197261111265, 0.19907627096696476, 0.041975172298537387, -0.082389336444207317, -0.29225240732327462, 0.1251516841026081, 0.37764947556041945, 0.031750316674659912, 0.11889113382098565, -0.068809038788896035, -0.24309686165246666, 0.12147376649300241, 0.13840359364663682, -0.3936307989943339, -0.023733600829812213, 0.18547133560945445, 0.1795669816208452, -0.071054531709333277, 0.087627691360193188, -0.092581769039906697, -0.18203109370352402, 0.081610800542337117, -0.082595344063677245, 0.38974402359480215, -0.0045338001036604259, 0.13215738801235585, 0.1485390578706586, 0.083669751994342678, 0.19755608025162208, -0.051326700841118594, -0.12262561013986822, -0.33375299798352576],
                             [-0.13736178973422586, -0.061493418180891102, -0.059735192047230559, -0.24781651340077096, -0.14960579265775784, 0.0017812251370202051, 0.23906987126726645, -0.17514954585409079, 0.18512325832625587, -0.29406116665017479, -0.020660226069692592, 0.48277130475271668, -0.1739377169671423, 0.23480971076427357, 0.14515564404131751, 0.087144009452966895, -0.3226414538366334, -0.11909862713446728, 0.30845330193091053, 0.05580109935478865, -0.12986780241734744, 0.37969871802557403, -0.24397392278682214, 0.10035595059771145, -0.079334753481760376, 0.16925242969454285, -0.21859979219544717, -0.034951734960017619, 0.45698502830589738, -0.16130563546386362, 0.35190771179057528, 0.32887391259850596, -0.17321740228320592, 0.066868328036786093, -0.1625320586932141, -0.32613304995853931, 0.079595730430139733, -0.0073130522954493807, 0.22248936243781051, -0.031392915232406428, 0.059451825290010418, -0.16017857867025043, 0.14730260613818652, -0.13529704302317858, 0.33734117238142319, -0.03104016829605747, 0.23369883538411934, -0.17186155919328375, -0.1268604371143694, 0.07035367990232097],
                             [0.11114708628509076, 0.26834155607515281, 0.31703775571144421, -0.22304065738837728, 0.12198245789657412, 0.49404280488546204, -0.10970437549062594, 0.12842229809432196, -0.11685576201418947, -0.17561694431795177, 0.10316413174153209, 0.031554847585908326, 0.23819857702890598, 0.25747887912771589, -0.038762726565591411, -0.20137586973145108, -0.28368870412578256, 0.026420416587969335, -0.17493686061558342, -0.16557131789166368, 0.13364350543767581, -0.41655852409671823, -0.019558543163184557, 0.07715157306093072, 0.019314419660151648, 0.19134595911665847, 0.19199023702303661, 0.086232525043843183, -0.057930728601671096, -0.085000062437525545, 0.29159091970282486, 0.27944149865572515, 0.226792345660877, 0.036005190256552848, -0.37252750939049173, 0.30362132167527295, -0.089718325743785701, 0.15656138975114356, -0.2450128514142455, -0.2213921249845377, 0.099279111350050575, 0.21463409347025261, -0.024184199653734806, -0.30591504571096034, 0.12484446942759354, -0.27280595967411136, 0.054253357049513153, 0.19997308073095016, 0.091951366616680519, 0.27605018757529087],
                             [-0.17719800316790096, -0.10167338007680846, -0.25759757240881731, -0.023040841116799396, 0.021208095281441977, 0.39094280212724347, -0.34425035216600447, 0.57377028940246466, -0.22803892613700683, 0.070013704754304532, -0.26290778369574092, 0.082816367808382182, -0.36835319174719405, 0.071767064886471457, 0.3768298598167929, 0.10851091268321265, 0.27762223056896462, -0.10994650040750217, -0.046425040567213881, 0.20058512586483371, 0.19018273517664977, -0.13436542418123967, 0.067043671095333698, 0.036100868545158392, -0.011145027582499342, 0.20658842856197626, -0.02319132313143964, -0.14522848463554217, -0.16645135058397553, 0.022989819229568983, 0.10042418223169138, -0.027058427033356657, -0.13031736967130186, 0.018937106263821502, 0.45210133371285999, -0.24852782997738213, -0.3839572783219794, 0.016984094532651459, -0.1050283891269385, -0.092328364840073784, 0.35087220576391609, 0.027916301369314681, -0.11546500054775274, -0.22342652130221535, -0.2044736053589494, -0.18310555428992517, 0.17005823362435551, 0.18405115943653699, 0.14186254075415436, -0.093294974066811018],
                             [0.0079123203359355698, 0.24807221902021812, -0.27468782212039161, 0.14943278788107359, 0.25041747339992465, -0.015668538131369106, -0.042139889967096347, -0.07178396592496826, 0.070848315955725716, 0.1465341817264561, -0.10116039261527654, 0.3923037836897853, 0.0075320447760993288, -0.25503836595271423, 0.10878206935652658, -0.30057599365531551, -0.092058855187181071, 0.14709848629717331, -0.16494501256488681, 0.13371080555393555, 0.28635905400455225, 0.24336908613866542, -0.080036737375364417, -0.2791393903922228, -0.070534384539155157, -0.23072259271508119, 0.067602680007831678, 0.0093720043900343934, -0.31940851755181854, -0.36556043606571326, 0.0066366245645517593, 0.33535342190014761, -0.42022161903753741, 0.1449202692479811, -0.35374362840917029, -0.25205015129836322, -0.16975307540733328, 0.40930941830245565, -0.14772625120932301, -0.034983805126962218, 0.26598392679296851, -0.031829634021562782, 0.043671707408634103, 0.22397128052600432, -0.17508442578966529, -0.013641317279543468, -0.084730283063005979, 0.12013364616576698, 0.25879349340787744, -0.044339685909273098],
                             [-0.56470240867420896, -0.049014101938663832, 0.063084455437011175, -0.1254911836339444, -0.25841680732255484, -0.0061698564648846564, 0.19013470052298526, 0.056150447381669334, 0.2478279749297698, 0.12165105031564651, -0.25128059763593863, 0.40812258442687221, -0.15478430324923154, -0.092619186219316002, -0.22547784173745522, 0.13439319143936096, 0.068126891651060936, -0.11721311789211407, 0.020674704375526778, 0.17094573788911549, 0.33423135776627849, -0.27528954431250124, 0.17078682313211607, -0.18572788665923082, -0.14619919887674535, -0.066063692729783949, -0.17688479649837499, -0.05253057300860596, -0.023731059781297942, 0.10726520415831631, -0.1216062129374557, -0.26659405460225882, -0.0022245451128050471, -0.040383223750259149, -0.22012371585303853, 0.17998467751272948, 0.19838857499813439, 0.2684181267817089, -0.27386845217814759, -0.14784666754467973, 0.12127773268313549, 0.080789448810645981, -0.34431391248617865, 0.1273235020673307, -0.019645274885684363, -0.069653352535758925, -0.083828715140532459, 0.24906329867347121, -0.457319314667615, -0.026616145658863031],
                             [0.2316490329063694, 0.15929725009138812, -0.043034994498365085, -0.27385179416707311, 0.38765681724431256, -0.018894412066095538, 0.031057150682071866, 0.04405554460621712, -0.020709413443238484, -0.099834705336214441, -0.072079259704418946, 0.13130544407749867, -0.34206798762835672, 0.049769764285542348, 0.050094981094163993, 0.2588061233702722, 0.14369760131258177, -0.31336110201368778, -0.19949630022492024, -0.25996391260004525, -0.069997450222601273, -0.11484869392320265, -0.39147755978072163, -0.013545367651384964, 0.3750668683476176, -0.096195525507250065, 0.025513113848436755, -0.33497621032666464, -0.39159095516385178, -0.11263647690200795, 0.026805718930343461, -0.24435270544424975, -0.42755937945076122, 0.099397312010667857, -0.21287359408102591, 0.41356228607654483, 0.024945089159965093, -0.098951479732949432, 0.044770464031427301, -0.1473451533738257, 0.16669616115703975, -0.38741787777683101, 0.074947184575632209, 0.10201061485678237, 0.12190661079874332, -0.01149620195487757, 0.26844716400042085, -0.18749579936327354, -0.018858817630818477, 0.10251021316545612],
                             [-0.073394274155371864, -0.27942160364592838, 0.25636059365708347, 0.07615836869892037, -0.21222014597552635, -0.42406971445196756, 0.16251932022143617, -0.074692322808263642, -0.27776474387574357, 0.37141636706123443, 0.24147927031737948, -0.13873685887275641, -0.077631044293203444, -0.1532208472953325, -0.10500108967279498, 0.15942446458267284, 0.060958288042034903, -0.19597989455332931, 0.011308392933018684, -0.35985507054258731, 0.13619180193283068, -0.01165852704079683, -0.24898075190767902, 0.01994080037899551, 0.23551609039577112, -0.042863497190586158, 0.054381416041047625, 0.2010072719638413, -0.37530784443675547, -0.18620308169594876, 0.2782261554133087, -0.019264440009004284, 0.19042623316238466, -0.045974808771366664, 0.34879321666446922, -0.15397494111508475, 0.12013032428289047, 0.054956618631904673, -0.24933514619906907, -0.45472456670486083, 0.31494559688603313, 0.16728992061885392, 0.09013018036151102, -0.17887663667825046, 0.29492676606283469, 0.036149023607414787, -0.18581337806859247, -0.13142753540280264, 0.042929640174077147, -0.049556887468273039],
                             [0.17128901643725331, -0.076066491554487872, -0.23097863771059982, -0.16496453360934166, -0.031078875697585114, 0.50492361788321194, 0.05536152285620876, 0.21761860838027572, -0.27790252595636522, 0.32951563156699676, 0.34596762950123933, -0.21681474282961141, 0.096835447481397982, -0.20705677277480461, -0.016433105396311425, 0.13011464642064041, -0.40416953319034871, 0.041858401470878756, 0.16446763909818429, 0.17311954288400697, -0.13371713905402804, 0.036345480572564245, 0.29948447421635083, -0.082636390942378402, 0.030983938545603218, -0.20684285752270695, -0.25697327612852211, -0.089912291104737058, -0.43467556586242251, 0.15074967002246822, -0.21074273192103332, 0.15902383770331344, 0.066058218241283481, 0.12217661153081634, -0.18031298576103519, -0.2576184932906071, 0.24773391024575522, -0.33745275834795491, 0.38386994542919461, -0.22653868622910625, 0.14724120283773298, -0.10350438752220147, 0.12350561443161474, -0.025204994117065119, 0.30006957973027626, -0.045069197701452006, -0.1872770764401584, -0.23584057840992864, -0.11155660339253227, 0.043655729919478879],
                             [0.36916557743654044, 0.0057177176329275114, -0.20186290576357518, -0.12333815546400645, 0.017248001014920189, -0.016091787832696346, -0.13737823470936206, 0.16313943522018468, 0.37336192710174471, 0.12269645114674115, -0.056064199713305798, -0.1918369541454828, -0.18989105636281325, -0.065977780578606454, -0.35418269686164716, -0.046866282755068878, 0.12539788442960101, -0.071176330603520688, -0.25166852592470701, -0.070673659149266599, -0.43940957914745127, 0.072016264597364946, -0.049003244792774604, -0.090860267447344017, -0.039729459404285399, -0.01417847016756818, 0.087263597554846209, -0.15011883128517117, 0.24028588395673825, -0.097753538281207739, 0.26387174927956564, 0.058256851521195793, 0.34944630369171975, 0.27263980135014559, 0.19380225593474251, -0.23199576247593642, 0.076486202950164631, 0.13569676148816084, 0.28490729850648222, -0.0823960600728844, 0.056764509008761767, 0.0059042178647673721, -0.36423177406793378, 0.22708188014610564, 0.32428737312537381, -0.21497769361346519, 0.039071053407726465, 0.32545819034450352, -0.067973580106164583, -0.19085697492951129],
                             [-0.074048719356829371, -0.27859415853717345, -0.17418630011448122, -0.022632029261997033, 0.28456651888725881, -0.13310298902472467, 0.37983630398562934, 0.47228913637761716, -0.062655849228949387, 0.019352884922285853, 0.033570143183691357, -0.075190050260329003, 0.049377467724692661, -0.21208154343656416, -0.25671417129672802, 0.32705584957954065, 0.26848060525507933, 0.15294818254203374, 0.052928267648659127, -0.077757497179897744, -0.05740633282874455, -0.072850846148100765, 0.15508296570902938, 0.37675611821545435, 0.037882672398745015, -0.0016995103724719157, -0.021918593273110871, -0.18040947573900301, 0.11649007216531275, -0.13846256919073902, 0.088137560296167317, -0.017271548790013178, -0.15631652131245813, -0.18430759209725123, -0.12713572927108413, -0.070141038784446857, -0.19542387078705167, 0.034833428529540522, -0.23685499822575129, -0.47357786742908375, -0.62526232499756129, -0.077794017031303689, -0.092681298224202624, -0.21048409792303588, -0.046435218474406167, 0.24111140222433181, -0.055338526065722163, 0.13563013903695118, 0.13538132658743274, 0.14008298043645745],
                             [-0.095444902190781708, -0.090815994426050733, -0.15556035148159308, 0.45611336363520766, 0.24299087267086789, -0.14082200193255145, 0.096301789823073358, 0.051826944912482457, -0.075796685804283781, -0.053476360841005682, 0.049112403608942506, 0.18473514251880288, 0.26750354954508854, -0.16549912077540097, -0.16086945707472075, -0.0089310924636216808, -0.14917634356869536, -0.45444066696248264, 0.14714889353088315, 0.20292730141321477, -0.26355013329027233, -0.3947884510587677, -0.16842280692834288, -0.12757772253786492, -0.3590801876035839, 0.14401461138804961, -0.22622044976043956, 0.20265768176885718, -0.16482552830717645, -0.45515591154443802, -0.030223855395995571, -0.025790786100753763, -0.0067617153463488591, -0.033130737189372324, 0.070474726074980565, 0.059105392717132811, -0.17306197207773244, -0.099273635047480463, 0.13074633220505624, 0.30833850058787932, -0.15951200390212256, 0.18174515102144984, -0.40540691716097332, -0.12071980079851691, 0.37522734702741639, 0.04056089803482537, 0.38774859059444244, -0.013921223008167154, -0.10690009909352412, 0.12684657234670807],
                             [0.088230315449243715, -0.070859766026751841, -0.10628904674308183, -0.16813680287320454, -0.20987943955114757, 0.023344896157579634, -0.10752638039612651, 0.024266325053036365, 0.044230283269566809, -0.39914447358831284, 0.36109933061478883, 0.058285738000671806, 0.13458278439878196, -0.40861009468243548, 0.28286801848885118, 0.065476613111248, 0.012347311193020905, -0.20599396260351194, -0.39982194062456478, -0.19045665884160351, -0.22173917455576447, 0.1342235372761173, 0.072795003613982209, 0.28113984800967151, -0.4210026319338605, -0.094300562955450751, 0.38512340404223744, -0.27896428740940349, 0.033509839126022595, 0.080184071144767874, -0.37222738272717892, 0.10056607201045802, -0.14339343810286775, -0.090834182633170293, 0.12284218612012149, -0.093664046456138406, 0.057412059631349474, -0.0099599632776304833, -0.32432138090775053, 0.11383716460087923, 0.25821482800583329, 0.14762454378300718, -0.052248644682425495, -0.17408496745701624, 0.17192544813018656, 0.094532834449919778, -0.33442797956102926, -0.17307987359907981, -0.32409911972510436, -0.2072532177555057],
                             [0.013397809859688602, -0.076185849032068445, 0.074781907690305863, -0.11220653920568442, 0.10036620083368292, -0.063703772321646118, 0.11430342481220848, 0.0062918367360512793, 0.077304641111583361, 0.19375893875405478, -0.27252547008641093, -0.42599081685659945, -0.062834255962183241, 0.021881115551025197, 0.22741230044581665, 0.043093850134997357, -0.22793476594383866, -0.0051998662811942788, 0.27380139309155654, 0.15435348050120701, 0.068961078168722684, 0.25049764405147162, 0.39070326933569549, -0.043294602298897512, 0.2574769748189964, 0.19321793126809442, 0.20045696799350268, 0.18602964847165479, 0.080526551443047156, -0.42504624372223943, 0.028823017863820834, 0.087619492892793693, 0.12693275435953552, -0.18710438274799759, -0.084128136331164505, 0.44138488709820917, 0.0071447980444416335, -0.019100400122288232, -0.16168044786801369, -0.29881158455600471, 0.10069741480785641, 0.055301669358658601, -0.53256010290475586, 0.084297930360150847, 0.19084935161368341, 0.27576276254401716, 0.15013582649945539, 0.034512543482525179, 0.20851231303001286, -0.10696495130033123],
                             [-0.22580754087967153, 0.075873741300367642, -0.17927888141191892, 0.10332142085094115, 0.15795463273856211, -0.1639206513636785, -0.42574084704388171, 0.084259088795991838, -0.093510910727338303, 0.12912898240622467, -0.22996380037628406, -0.20243879578916799, -0.26300494189892321, 0.019403299615137166, -0.099846526036073815, -0.27356246627279956, -0.25490848568745278, -0.054727818265167427, 0.10750624092848872, -0.18333919084508599, 0.04553365525779695, -0.23705129912265077, -0.1805893299060379, 0.0036910054086327681, -0.26320861291236131, 0.24155173143398809, -0.23878264362831908, -0.28828755605750939, 0.24618894659819646, 0.17642797611617328, -0.013195249583917622, -0.044063462403040252, -0.057446943203819961, 0.23587886183290777, -0.15383638487531015, -0.039219821165819069, 0.22387309316541559, -0.28021449106041646, -0.53854892460814252, 0.069737079963805751, -0.22597587231625391, 0.056507335464796964, 0.38166179947579382, 0.27696259790439881, 0.33374233023971328, 0.24133614949804444, -0.1391862508741144, -0.27604446526193055, 0.10080964786715438, -0.032717395124748291],
                             [-0.069789861828564767, 0.077898915421402509, 0.21341179536090532, 0.090832718719518465, -0.029498224945067975, -0.4706485701060264, 0.24913323058949358, 0.46529578376111741, -0.051238611496192459, -0.25547683922196046, 0.23800960252394052, -0.32608132785482802, 0.021291821977217892, 0.064023456165021878, 0.21798584330945198, 0.055300423950418148, 0.056955086970053893, 0.093440370884493418, -0.014682070731295108, 0.273821324314937, -0.23151180317379869, -0.27621180251983718, -0.12177628290983177, -0.4275739271044629, 0.21776551342984934, -0.046108543006968511, -0.1121385823107032, -0.27788515548502124, 0.052380776732687657, 0.069753947905433197, -0.016805603629516649, 0.17711318353693148, 0.0098740417150355708, -0.079685213301492391, -0.24920664400942028, -0.25423993666859396, 0.38480014500935122, -0.030403827234382327, 0.051174956638311592, 0.10439771561234584, 0.24944717408468559, 0.29629210675694073, -0.10454600188951506, -0.25335688321202648, 0.030691208309039715, -0.14613970425126124, -0.17445766046915581, -0.23016922639641019, 0.10007429254480482, -0.21247206601425023],
                             [-0.25037903019386321, -0.15688313379265245, -0.13693284364361438, -0.042925097495087106, -0.12116886320242956, 0.033862050464975105, 0.027301779186250433, 0.1451094712056043, -0.11973755315311017, 0.41253865733507483, 0.23869860799219306, -0.0045216166580448955, 0.52368631511302655, 0.034148486944813233, 0.20851701030894007, -0.18799943892427767, 0.22217899978387937, -0.026497232412357116, 0.10737045590595493, -0.29744387893224661, 0.0039786965049924709, -0.060306626811048425, 0.075520593075050768, -0.12330997133524614, -0.19525023127996982, 0.092206159828584169, 0.089545499773091022, 0.0022131324913592463, 0.25073061943989006, 0.13104102034160642, 0.50941840177680109, -0.039428704556667103, -0.33600221635909006, 0.051329848789347814, -0.25576490665957546, -0.10851833127736282, 0.21815701616080657, -0.18856283712379973, -0.055427257550801107, 0.025019570607076588, 0.23987636965210926, -0.35856964324289092, -0.12760717968022775, -0.092570848073889406, -0.25697279296009451, 0.20542832311635473, 0.36856248929805258, 0.12645466687141763, 0.015906397697692094, -0.21861279218581808],
                             [0.13834966899742177, -0.17978242296335728, 0.038359543450871836, 0.079788691794296068, 0.14843701230135761, 0.066682084081815918, -0.042591873187218458, -0.22382000579811223, -0.077682134234783096, 0.13208158465297462, -0.25122283538889129, 0.51174014006826807, 0.19944013665505206, -0.27365040417446573, -0.047945337448052433, 0.11672148431437349, 0.1813723128909972, 0.22522743251177182, 0.15371926712477479, -0.30889975373144846, -0.082013047673353934, -0.050759714240950625, 0.078593515215759482, 0.21429678405717406, 0.085165325648513202, 0.18490713161628491, -0.45092583554781557, -0.26289359859827444, 0.2457110466203058, -0.11794632806602806, 0.033213775134139527, 0.29131813667814493, 0.12830905099377302, -0.15535603736385403, -0.074602723703160692, 0.32835228129126182, 0.0023154124043207628, -0.3677348979260725, 0.18254154233338196, 0.16389464096477593, 0.31223183462392395, 0.14749169668692744, -0.042623116152009553, 0.09803627848857982, -0.076796223320220278, -0.28739093500498958, -0.39328916313498657, -0.1958575324086915, 0.13784220271418743, 0.034620155803104936],
                             [-0.16412668973477368, 0.18325409777598628, -0.22297238482335632, -0.43992047806744333, 0.027350763595803469, -0.13637680007086644, 0.22389345496747107, 0.060590657093350916, 0.16254085875572735, 0.30426859178765669, 0.52092499013303684, -0.10568359855187376, -0.06431347935147709, -0.13059973797253024, 0.039477391268779978, 0.041002131581370754, 0.029033643097889993, 0.063750234040580334, -0.1577949392024334, 0.060257734484591909, 0.036646051374621513, 0.015352688724500815, -0.079456131374316549, 0.12403119081531915, 0.23610746806303728, 0.53761112189157734, -0.13407134081878136, 0.16142030371004626, -0.12960687917999378, 0.16553365232107764, -0.071847838264057967, 0.045791418210773253, 0.18302369665425061, 0.010679939198782627, -0.097709198265093444, -0.11898660797140238, -0.37277695086386992, 0.0091468505497272375, -0.11989064256558971, 0.35078323746183721, -0.051487927032519157, 0.11925044443261047, -0.099987327475789575, 0.36669115563027121, -0.34666307084632308, -0.090996437584835638, -0.01482690186304772, -0.27834817432909736, -0.11146313135585116, 0.38574581122125357],
                             [0.20295833719215928, -0.01679135322162234, 0.10304499959001823, -0.17371548918491347, -0.29777383006822811, 0.2390657723564889, 0.40395637271348406, 0.37401277982451725, -0.19768711281382359, -0.19139060724131257, -0.408811651140432, 0.12014965393331065, -0.076740078774966441, 0.086192082524886221, -0.39757744414225898, -0.18344603331980866, 0.058375744138381383, -0.31760818272192659, 0.0093260051552277699, 0.056562024614797833, -0.22718949799769048, 0.044390259627466712, -0.12070086898465253, -0.086480113373556211, -0.28259389208787328, 0.063293130131275757, 0.0091987121631862366, 0.24574758169900732, -0.033933076889193441, 0.043958035505191922, 0.06967200468564716, -0.030564365388356274, -0.096746201692728587, 0.19906848426035229, -0.040754504736090512, -0.014946112491979788, 0.21970498177651993, -0.23872579924490755, -0.0025930826574488072, 0.11349165744264426, -0.053591523905374083, 0.16895676421045366, 0.014972234648693915, 0.021292654041378967, -0.31214660106360231, 0.21960077928257551, -0.50817334997687968, -0.12297441296073972, 0.22984651675133688, -0.097670055304982975],
                             [-0.18616294402980058, 0.47137383222383028, 0.1662764296300506, 0.18051671261913241, 0.30608285771534799, -0.11509627543546461, -0.010241071826043942, 0.17875704998549991, -0.2758459265145034, -0.32889409891553184, 0.4185619310781083, 0.037553434931809578, 0.10988923590895876, 0.060924445653150736, -0.29110963055717387, -0.042809710727180789, -0.07684844268812413, -0.1864397331357257, 0.11700084057600185, 0.19473713344950799, 0.24105871621611458, 0.028006164567521079, 0.18085967989608345, 0.20147883449142281, 0.10376634501502384, -0.29711196209222079, 0.012827516699336078, 0.0063144550876357841, 0.31066509211974624, 0.0088659279982774633, 0.35116157249382485, 0.014586184622508741, -0.048602001853203146, -0.053596285431251584, 0.29812508515154573, 0.18790676779742974, 0.14818566789160623, 0.070010557071690682, -0.038254074713792288, -0.019433831214298251, 0.17052448503032078, 0.17851141300122197, -0.12582675478951166, 0.60277933534453876, -0.1220850097984211, -0.003815898981225762, 0.1665697035281628, -0.31458876392449009, 0.056075691700418574, 0.058007143313919776],
                             [0.075198510782440081, -0.074146146023391091, 0.18990540414227697, 0.015263716764533794, 0.13203033536909714, 0.071209735392133044, -0.1815490867228865, 0.10000307372818844, -0.07294800450813442, -0.049844998487614298, 0.1650847751176362, 0.072258842707683041, -0.45421681649985346, -0.6003089277321928, 0.030580358220496727, -0.33806476335759078, 0.088177330021821029, 0.11669760498927689, 0.43483977326762968, 0.097703665053289479, 0.075736441724011297, 0.15797807861934499, -0.053310364932939135, -0.3119649846277377, -0.40817042285234373, -0.081697707182701904, 0.15703217230338035, 0.046876896280596325, 0.16877612348346066, 0.24278651180244015, 0.16742043312311172, -0.19767273445326339, 0.22762249302916152, 0.075464898717256118, -0.04282791047902855, -0.0058777713912934928, -0.11022912561388647, 0.21693211432156853, 0.023009183864887248, 0.18982257250694387, 0.12572227494748522, -0.19337879974001645, -0.18014142526574539, -0.32073303304249046, -0.034782318533366524, 0.021670963201709911, -0.23621944476294848, -0.1916283740996422, 0.04602136321541108, 0.50017134245885697],
                             [-0.0025432728558015816, -0.073454419875294219, 0.056730590273773182, 0.36967745261171292, -0.27071507320618593, 0.3077982872104798, 0.29492712345745242, -0.15313397959707536, 0.11687871852811427, 0.16505524491254994, -0.09229133087009242, -0.20533016404333446, -0.1145279946750361, -0.40506638706842923, 0.20464165244401689, -0.39986780944498324, 0.27836073777084119, -0.39931629779355854, -0.12487705445051769, 0.25208559791481727, 0.2184687775202771, -0.010374024981276448, 0.082381990224128468, 0.23085753676110482, 0.045273542770416425, 0.15032774904277288, -0.23102912306567691, -0.39198453532030558, -0.097855594156015302, 0.080786158545960274, 0.28498308461977062, -0.012726085075484176, 0.2405944934120309, -0.086960017701496334, -0.2175409019371875, 0.12478936578143672, -0.084042543973183961, 0.19853327216547997, 0.064452765830125561, -0.11625614481072322, 0.075629549548744818, 0.23376738809577641, 0.31834946572115519, -0.1902437636546622, 0.073472970521998873, 0.0094560786014598747, 0.085006938605866444, 0.0028579406518385447, 0.17645208846422228, -0.16115828796914974],
                             [0.11906579277878233, 0.26198109108438927, 0.3134552572199692, -0.062548638309978796, -0.45932664778807147, -0.04518053453109841, -0.51306651057544272, 0.11845784724401902, -0.11972033057155738, 0.20855303845882556, 0.037728565874123959, 0.21734569671052911, 0.07907987968525737, -0.2806456687912447, -0.068354500321745296, 0.38416061456866119, -0.18900613741278877, -0.14233337436031612, -0.017684421262149551, -0.1605268729197539, 0.02491719842409746, 0.20903993801337784, 0.031856849649763506, -0.4450037468083291, -0.091984108588678615, 0.19949020460057684, -0.12236977908855093, -0.033568889312827276, 0.12878332201904802, -0.017560695258445096, -0.16826097874456053, 0.032721998020540127, 0.084883802976701339, -0.14450131484614376, 0.0036599003091607185, 0.071564095798057101, -0.11046609051941028, 0.27638307217398761, 0.39961068495753954, -0.13291779043218485, -0.26546647958604419, 0.29855858512679978, 0.17588515948769293, -0.094408353429908873, -0.012172978802074191, 0.17414004599092045, 0.13811426230905208, -0.1383719104139948, 0.14739354755239698, -0.079661483704497854],
                             [-0.041253760263388513, 0.058069942582112954, 0.21925780175587095, -0.19723160683549881, 0.21447551833149431, 0.017503297744161039, -0.10382775004561179, -0.28266033045844108, -0.10692633815205502, -0.16544988686816964, -0.032106935563007082, -0.031267047518760527, 0.24115025729436609, -0.27208746505989184, 0.2140635613119663, 0.05298486849903359, 0.34469367038465737, -0.043744639806668623, 0.39624903658204103, 0.137908192119195, -0.39692981621873258, 0.20069566984212692, 0.11552057679089434, -0.086497807080324368, -0.27793996816629168, 0.30428129753918298, 0.1002724959084805, -0.02751256647821148, -0.19948271073531179, -0.14534695134107306, 0.1166208169924967, -0.026852717857464334, -0.0064119388894090888, 0.19879720820696611, -0.13426989952288693, -0.046899461226704575, 0.13764680770343124, -0.12781496784550742, -0.014356189505704282, -0.43073983121591108, 0.13983710541938538, 0.45418931815726116, 0.40326455660410032, 0.12279578272561603, -0.42039617646126959, -0.33831119977100915, 0.11874714161302591, 0.16078351693204943, -0.10942620938443283, -0.033823147844100232],
                             [0.070600217600043355, -0.019767887496127786, 0.20199104457175104, -0.054745055321953243, 0.059503237238743505, 0.33100609795846725, 0.26821463375701832, 0.0070846741496948173, 0.038646240657874573, -0.072533064584786311, 0.14221238808070263, -0.10441668972489078, 0.022320821265988923, 0.12844890625645294, 0.18715330563362292, -0.024420265815295526, 0.30036953631501162, 0.030688852471048047, -0.10161082521973641, -0.48573720231741058, -0.071829398829771809, -0.0095931464981054999, 0.10270810931943458, -0.12367764762384297, -0.32566902076333465, 0.039412741951416981, -0.22820482276422757, 0.15045675590447929, -0.25477167203473849, 0.13021482016995001, -0.03435207386242977, -0.31950532112529856, -0.40054578251152145, -0.31171964137793839, 0.13717198854894133, -0.075913907661998001, 0.2225340960565648, 0.23497689106389649, -0.1315445544776862, -0.036530057491130356, -0.030233945196587394, 0.22785029808873475, -0.089516773233144817, 0.03332960886998651, 0.45717534678055838, 0.0064400297264455703, -0.30242778708062462, 0.11587194396164478, 0.47074614573613838, 0.21538849903969523],
                             [0.28779355712971449, -0.073038585293170172, 0.20971994959952533, 0.085952325908492958, 0.18010207626571009, -0.04559605469381274, -0.042746494212577632, -0.2237118049153316, -0.37991996304653913, 0.033418785063796426, -0.037578482098182896, -0.25624673720358371, 0.19842365085544861, -0.10448370653263174, -0.2980087343597207, 0.20887582255806342, -0.038890161258368743, -0.075386029356022469, 0.045730443474243113, 0.0070182740881709026, 0.066035333571822313, 0.27128064620875081, 0.22742922600561263, 0.33369264516555558, 0.22097019881091651, 0.22941165392904495, -0.44551282110495438, 0.12691402959435721, 0.29414724265389508, 0.046061191391614582, -0.23323255418873354, -0.33979146514736042, -0.26096652332274872, 0.37370099572192067, -0.1776295959808821, -0.071198831231975554, -0.12619246872739559, 0.36731414322520473, -0.18881781829298841, 0.27082641309654287, 0.21726154447327037, -0.0088445573522073877, -0.084078925508089195, -0.23648082148030411, 0.061327341596709842, 0.11125913047858456, 0.067913261624083621, 0.24386488449320098, -0.093819988153797065, -0.17908864663360716],
                             [0.074783206097685309, 0.43378964066660441, -0.090755086408105853, -0.11823584084629786, 0.0094270072660797982, -0.089135514015828379, 0.13988425852027636, 0.061426468208001586, -0.065163081386973257, 0.12196069159175817, -0.37920144454598737, -0.0015872568692130579, 0.24331012980542216, -0.20688794371318284, 0.16199468154608329, -0.040987825676034512, 0.14987884300879617, -0.081373869538386767, -0.077794427749147715, 0.086517824079044209, -0.051465173549150887, 0.12246796509137882, 0.16025918430336739, -0.22805796346158633, 0.032121066582303452, -0.21090692265617494, 0.15349522032580831, 0.16056301483614188, 0.25960145252112443, 0.29573231606446643, 0.026803975604568597, -0.080326334426754784, 0.003624671595188843, 0.36769075135002344, 0.2289586201520101, 0.17335742720550118, -0.26237485736352745, -0.03917011243644837, -0.12424280401658916, 0.010045628222324882, -0.370751307334105, 0.17977559949230881, -0.031813141218833607, -0.20675483114628584, 0.28104970953692143, -0.57296327850027662, 0.020376435270161225, -0.23664139828147943, -0.013096129958576896, -0.18027847092348165],
                             [-0.068798876815492349, 0.27142442311587434, -0.15265973065769894, -0.24476220298758516, 0.0027583721037981127, -0.083051853285842955, 0.13357485833790234, -0.027550980103930423, 0.03781258895196439, -0.22410885164904115, -0.19356815192305649, 0.023380338679519205, -0.031684297278892909, -0.51506135258845587, -0.045916120322576852, -0.11129673482685105, -0.24697058189897622, -0.035241469458888453, -0.063399429746763505, 0.011416289376380982, -0.14903708630879853, -0.42852066677115108, -0.042427706089603119, -0.0037984885437823447, 0.083809633878555334, 0.051380977410613093, 0.22096555962081305, 0.19726157057755583, 0.057076704377025403, 0.52336932561268734, -0.25690197648250529, 0.16102868720243763, -0.13217664155031306, -0.24091193053356236, 0.25333897229336116, -0.16472485189109756, 0.038457115634064461, -0.12262581316568423, -0.059755003824536641, -0.017566795964142196, 0.27859928278756418, -0.081173029213709294, 0.25806986508980323, -0.057663152281324556, 0.099664654686402801, 0.27583359349172853, 0.14732697866835406, 0.40886685780746712, 0.36019962471496964, 0.21891706882869674],
                             [-0.27090273776367213, -0.27006028354318928, -0.25295251197722352, 0.00049406646131165688, 0.28614963056820553, -0.055827326626203516, 0.21118640771249383, 0.23285080627297572, 0.070135295031710954, 0.10516383115593377, 0.18390353103831272, 0.018056450083075409, -0.0091709616096493501, 0.26649322257282027, -0.3937399286590253, -0.19192396424384445, 0.0078383038595867573, 0.13650283920243997, -0.2963379944606207, -0.0209449028867532, 0.017228173772621379, 0.33022830794713592, 0.12897275629147015, -0.34764141524307957, 0.10237004758402876, 0.23612234026989037, 0.38898620879215318, -0.19667824256573546, 0.22315854958792183, 0.029088326953105335, -0.2945784581860913, -0.26325681531821249, -0.10039082238895278, 0.14076559865733643, 0.13437675669753835, 0.24305254428435133, -0.04963327047671906, -0.17777520874520691, 0.26901987837145713, -0.067663013122532117, 0.23950325735015801, 0.34788034351531794, 0.12309488365885257, -0.21275219299661863, 0.17348465989975292, -0.099195110380077278, -0.19178137845660981, 0.029533309998987338, -0.0069360904711345539, 0.22668762263298434],
                             [-0.14705900581733089, 0.084392067939467255, 0.035262543537687915, -0.11953305010919972, 0.28544980526408503, 0.022371313633700499, -0.072200812018367547, 0.24912145462906973, -0.039585592332430343, 0.21556534375588243, 0.29745826222661903, 0.064600584362337732, 0.27706989356619427, -0.0074222283515116214, 0.35025401389347727, -0.2349538510633645, -0.25588524953787023, -0.10181232592486628, 0.035370193161775289, -0.1191806559359307, -0.43924518352851982, 0.36626022813638415, -0.21559515066830198, 0.12108597627068789, 0.07469438280580501, -0.23662564007353815, -0.40671198448156864, 0.11632832725286291, -0.0010881733234022958, -0.025358029758972795, 0.023277726878570278, 0.037134599212017172, 0.12533100006222861, 0.16569262592298287, 0.48338597621596208, 0.44272586835251543, 0.13800492315869384, 0.23166325869846724, -0.0022952655247504179, 0.064740945836824257, -0.090562681662740591, -0.15317150019027989, 0.065700920302107738, -0.21232468004312488, -0.1993483947594846, 0.044522391448017326, -0.1403845061214328, 0.45190497573745436, -0.12000580661616475, -0.099223658964406602]],
                            [[0.043644895555350512, -0.049013022527219653, -0.0212684646656198, 0.11737938286518031, -0.016872885848456996, -0.0044059844966315258, -0.1562403875589301, -0.16369171818916209, -0.18542859065094086, 0.2981372656530778, 0.15150583293577261, 0.48769909278834817, -0.094015028265598544, 0.28641227740318659, 0.17219188214713632, -0.17155523000053285, -0.28335566941714652, -0.18770065735168262, -0.027869696874838971, -0.12540878669708272, 0.096791813517600273, -0.0057065059240649771, 0.13532397854561465, 0.12497226897288528, 0.28606259363032133, 0.23093734745548936, -0.14203517202729993, -0.35091279377284967, 0.29410425861456324, -0.064681757733062728, 0.11652198220026092, 0.16853939823111744, -0.22482638129413049, -0.092798614017081713, -0.14879450209006773, 0.35211161572566779, -0.23961865524284576, -0.21099128688955521, 0.016362498370875563, -0.027149545692568951, -0.20048385549430026, 0.051430985623002148, -0.33605934378758157, -0.16321223755371725, 0.33663404112513823, 0.12071049036341738, 0.061727493367477994, -0.28773368363273283, 0.1786859804466826, -0.52841271195473427],
                             [-0.094719999951083045, 0.32251383793755883, -0.40717542582505512, 0.27585358674615346, -0.066867498745402265, 0.16446157650800108, 0.0020029412519248502, -0.24953735914951311, -0.015270509382053057, 0.012740921737124433, 0.26136194971364213, -0.26938586345091725, 0.15365265240659565, -0.025446250740375698, -0.097594201676246412, 0.15492369950597565, 0.36825218365732487, 0.036219208783069175, -0.28551004445256634, 0.18265893695632285, 0.031949383023020278, -0.0034554050854572211, 0.40417503322319837, -0.024232611333458786, 0.23386800641397276, 0.15775345984780564, 0.33253144430413578, -0.24964216534102404, -0.02438397914491788, -0.030458763508461315, -0.13951669039883655, -0.0076729724718368666, 0.2589467312651792, 0.041725755051773797, 0.26251411366487487, 0.11143509788256337, 0.34804549689144226, -0.14842070641496821, 0.03604850042005027, -0.26712504243353813, -0.48200625653435358, -0.025865160141468183, -0.065963794710678259, 0.38464608519788474, -0.057961319084890515, -0.21832443217699077, 0.078533508204376434, -0.30604449061352118, 0.037625438765901104, -0.2220075853463358],
                             [-0.077863772553027788, -0.075786678926611797, 0.12476410731039209, -0.19944944552865737, 0.41437598212303145, -0.019792946972400416, -0.24616792630906348, 0.1178874764824043, -0.077107151392501544, -0.046303468811704163, 0.10031855774301772, 0.068297121840393091, 0.25456654194944084, 0.20214006074171301, 0.097722248388644462, 0.53330691489033633, -0.064239085277668112, -0.048472218921360069, 0.040873441989534035, 0.287695748269234, 0.12665687243782331, -0.0045766455308655684, 0.11351004970697617, -0.14845531359103117, -0.014096886729312107, -0.04942902485010546, -0.27102414087875898, 0.25351350920378235, 0.02800960561575936, -0.15805650434308055, -0.23862232999217906, -0.304767157898436, 0.048295721173963566, -0.052319272822692678, 0.010662657583031615, 0.027189313519303995, 0.24748108667337815, -0.44330737227315481, -0.27646507789838987, 0.19774852964792533, -0.16653620908644648, -0.039338585537246173, -0.15634480285124927, -0.068587630146444561, -0.023846564547516283, -0.13066606777982356, -0.04404158335580742, 0.18827269302504571, 0.28121906560124982, -0.532205923959296],
                             [0.039371501425480154, 0.33391972338996467, 0.057189437139272901, 0.37883320518830682, 0.012491633369220032, -0.023192897338896484, -0.18571203166094102, -0.20963824983221357, -0.14133317111685395, -0.21170495406378467, 0.28288310226155855, 0.079750942371513256, 0.24247935046666486, -0.43283629651844951, 0.34067888280700148, 0.28784269888850034, 0.33920024857670972, 0.06198655673730212, 0.17223568645562265, -0.22603194003916002, -0.048881153113663561, 0.21599492678689508, -0.151242418690401, 0.013148262429703629, -0.023984697872050542, 0.026353384736362867, 0.060374649571364777, -0.32201618037047641, 0.12643795402366614, 0.052276523456946035, -0.22525445344485057, -0.20167353584739864, -0.3075592010653041, -0.053069582093793623, -0.35239182274320402, -0.18933393688005765, -0.1431679240461414, -0.10156687696372897, 0.013738885259804434, -0.034348692556945129, -0.0876568496829426, 0.18589569376064805, 0.058309680862338974, 0.095774981997624214, 0.13222838969525741, 0.34367600132260429, -0.15164223081830958, 0.041678816468169635, 0.04304382236732493, -0.060464918159306602],
                             [-0.3535974227825307, 0.29155333814365053, 0.055225307689152556, 0.11815009761487247, -0.55284105482967638, -0.182531573562081, 0.32721901491818611, -0.14190856108333066, -0.30428846520717773, 0.024710086406491839, -0.24969511584546064, -0.019095804452880359, -0.083634783547607283, -0.017632232606380898, -0.18521814401172576, 0.18375554804018152, -0.0045750380151659085, -0.106057033297391, 0.56995792926260835, 0.17988172826197138, -0.42742619752239119, -0.13348085682690181, 0.22354555244612473, -0.11127520431614485, -0.27115033947375589, -0.10616875220869385, -0.34537958242536937, 0.15664697408063089, -0.14631441476303234, -0.19022866824124288, -0.010883834582637628, 0.077208499508092318, -0.1810523873264071, -0.10047894489292325, -0.27821887243060855, 0.19461022399562539, -0.021297047843111844, 0.093775156666398463, 0.016594898586762122, 0.013470444519649731, -0.12978455806888783, 0.22829504182211124, -0.10480924577937589, -0.14945374890801044, 0.026233830645680058, -0.18115507672085507, 0.16464688371898845, -0.0079777107564351964, 0.094351023182763658, -0.11170129011396465],
                             [-0.056633960772715458, -0.015863857309939819, -0.6274378878584066, -0.060523789941040143, -0.18385494878406752, 0.24680850894052012, 0.078425876158668112, 0.45525428981841243, 0.33929555543649037, 0.01684273582359604, -0.024059454726188485, 0.21271639118921232, 0.15508756325181375, -0.02825150693618125, -0.074393377756758541, 0.37558769057520597, 0.02784151997823266, 0.045233020062911779, 0.15431449115768794, -0.14677064747737095, 0.16568602071127159, -0.014987782219744844, -0.09604862880858045, 0.35828566051875199, -0.2801228712673598, 0.15601020320417636, -0.22674127273792929, -0.15857456810191892, 0.10476426144968358, -0.14532856037511346, 0.1802023170073829, 0.55261370405021892, 0.0014712802582197431, 0.23526909531525034, -0.082521932681136029, 0.12859894734246549, -0.17477652978351441, 0.10886887065739163, -0.0091101901635424372, 0.2081188780464904, -0.34365578682498599, -0.14149217855610219, -0.20933810786736576, 0.020740419568556892, -0.047897808339433197, -0.065304759311010291, 0.0060021643787027262, 0.18284468170468623, 0.0043809344197757952, -0.10477487754038732],
                             [0.025568681700479195, -0.16555277223924389, -0.15149307289205838, 0.050397737223435816, -0.10274279849264456, -0.15131954277302054, -0.14968259234980658, 0.042938966708066323, 0.23700327200895677, -0.25756207199740488, -0.045258064757550953, -0.091022431447493182, 0.061197952161655828, -0.10718277276716093, 0.10920201247309508, -0.22415936569426495, 0.089602577736054581, -0.0076013873952037736, 0.16741384795561559, -0.14213667066450092, -0.13695951936342915, -0.35817113945511114, 0.20653442047987006, -0.03854073730203484, -0.067688325810375705, -0.13887160330576123, 0.032376359008855674, -0.10941433351065183, 0.47506559585328695, 0.30206186409419228, -0.037001072204849036, -0.22231752067425242, 0.073539400438189212, 0.27952846856878638, -0.11820433979981071, 0.16050686379178952, 0.07567637126064812, -0.014172628346056232, 0.11207633035932903, -0.42656196576930949, 0.29407243386174831, -0.37489708329383059, 0.32068550687821301, -0.25764981933629288, -0.32621721786098123, -0.031989971286109017, 0.15479481387012867, -0.0091267604465726099, -0.15071525310563694, -0.50947682168501374],
                             [-0.065189580442759826, 0.020566004407934046, 0.084004379868643717, -0.23163660744450099, 0.15770816604322446, -0.1847201679026092, -0.0097378812395641362, 0.033730817867726554, -0.089821203029962632, 0.18027151453737625, -0.14169774085187883, 0.06168471309117652, -0.19488171671464896, 0.0042070532956818771, 0.31778501610594495, 0.090143265453119792, 0.12607663312382128, 0.20963603516065582, -0.003011761340899026, -0.15547244476681024, -0.11094926830972553, 0.42750025893364207, -0.21725768739253087, 0.03511440352785495, -0.36470398526251235, 0.041052745763116814, 0.27169628857794148, -0.18482746834011868, -0.23136682803922273, 0.076134788669707465, 0.09810860306842617, 0.30384953462145931, 0.50955667163667751, -0.17928593801135498, 0.021721882176056723, 0.28015984155082352, 0.29847373754401235, -0.034084149450939807, 0.048588799701696495, 0.012100546981264095, -0.044127734913902816, 0.28762098486030929, 0.23229257411084292, -0.020981227288953776, 0.02950940273193969, -0.055950740867280378, 0.41727276720629841, 0.34613299951196158, 0.19749322097319935, -0.18097137708451025],
                             [0.40949958591716107, -0.16163403103934129, -0.28489155210663086, 0.044120111190196702, -0.061411722558143464, -0.17097179988140074, 0.008483107602131567, -0.21340688605829936, -0.07735622998961042, -0.02206765765029434, -0.22146106223421896, -0.1171772794681481, 0.15300992133765165, 0.34453662482049036, -0.14654357937641863, -0.064248774202386075, -0.0056498113046369973, 0.35310434675227137, -0.24511356652079677, 0.30075014888227852, -0.11054877065192828, 0.11083848872486553, 0.42096509562875573, 0.24707332569099619, -0.4727677827321532, -0.29413784772780277, 0.074080905373142145, 0.23355177884814998, -0.21865414466152819, 0.3817051312493337, 0.14961256059256489, -0.46737238850096424, -0.014799277292017741, -0.21901578570618163, -0.091779784258328223, 0.086007922078606372, -0.057655478194271491, -0.012836449373210379, 0.12729059337548729, 0.24291078891175708, -0.18132277064198163, -0.11054199517619528, -0.0036732794204382292, -0.27705724690682776, 0.07825345692261744, 0.29126863190532359, 0.091622013513305373, 0.07896349964199606, 0.33495684874538517, -0.14131476840121129],
                             [0.050835024222595289, -0.3732824380157278, 0.034243803606026482, 0.085869095838320392, -0.16759202294438563, 0.39386803979232954, 0.063735084618025101, 0.029994891600973086, -0.20759605686241434, 0.3332803204941529, 0.13715530106625667, 0.049028533311168576, -0.066115848265164312, -0.15699093260459551, -0.018850030139646767, 0.082420575709039656, 0.34827489621079533, 0.26697078083213954, -0.038781850426106858, 0.21044112558245398, 0.026439167134754908, -0.24290333205410081, -0.040576263794970813, 0.25226642757028378, -0.050226611570099763, 0.033322619799248131, -0.19539221273066554, -0.35086322549022364, -0.10141992689062736, -0.082506866526147929, -0.35861446679267805, -0.28979657751353849, 0.33668844009746918, -0.60071637386345589, -0.13959529231585771, 0.17781434364137289, -0.020814652591284705, -0.076278049067003112, -0.036267502457110204, 0.058436720926617232, 0.24904881107243942, -0.2493291051798773, -0.076566742774686725, 0.020045800061011223, 0.23977531807804769, -0.20406598853341815, 0.041836935377214043, 0.036562288754181091, -0.1530714228731867, 0.10218550641843446],
                             [0.27765169129349826, 0.13454302977361668, 0.062085195924607615, -0.12343983131079053, 0.021917198855358935, 0.15581650452559495, -0.52703898370568414, 0.036115111276872489, -0.10011322079183828, -0.021755979682691662, -0.0031853097367930093, -0.36601357479818231, -0.2140505948414787, -0.10619979516136037, -0.092629539791881876, 0.15603775886922394, -0.41203821317074019, -0.28304467899725433, 0.25620609576859665, -0.081958629621220025, -0.13372161640507138, -0.047231918244052679, 0.064182962515962533, 0.25318734357364581, 0.011160212077688518, -0.3492132855342851, 0.23431479339449302, -0.15874599274020951, -0.15202099831255719, 0.3765134038670811, -0.076402167699325452, 0.21336388471235077, 0.15166740859771463, -0.084186583449711597, -0.16366802635404831, -0.058501674611582587, -0.03667907698470034, 0.16132108945462725, -0.25008545577223174, 0.12830318310021918, -0.11823913001663505, -0.20478536004007786, 0.10317626282574305, 0.1620365643734788, -0.050642852933587966, 0.061999025799278143, 0.094162865090533537, -0.1862310191588058, 0.56061858630577222, -0.0073428406513164225],
                             [-0.3647272773856759, 0.48263081506478794, 0.20227394910378907, 0.19020616481060215, -0.094896423354866366, -0.054697315381404515, -0.027948307547027651, 0.019553921134063151, -0.006422876206626682, -0.03682796852602873, -0.25310202826907902, -0.22285395094023799, -0.4943961635118454, 0.16848712100643004, 0.018297384256632583, 0.21185530332854544, 0.039882153361537734, 0.19751072112747847, -0.012257849261569087, -0.27955121561741719, 0.0099632961890211702, -0.16605956068861633, 0.042516647695347062, 0.4026224974352634, -0.069582421007923195, 0.16573413393593303, -0.045858325223779695, -0.29012279076169278, 0.32828630558133481, 0.15714882183895185, 0.13484206853884742, -0.10361398274875523, -0.17487787810593031, -0.13655257389981607, 0.14254874876666146, -0.18100040684632915, 0.11341783686653166, -0.11829706590884959, -0.4774375095381625, -0.28983760828489452, -0.1380375433711622, 0.10765743504493047, 0.15596036944610192, -0.23914467704885212, 0.13078498606640013, 0.2849930694017333, 0.16315525798951391, 0.081459822937290913, 0.02510363194840716, 0.27263799450006254],
                             [0.0066674212170935721, -0.32708035503387661, 0.040633032881106326, 0.36381889207725049, -0.27548007273359004, 0.25953572002772934, -0.21883944137516098, -0.19257069887253506, -0.2173524949184831, -0.334834162281268, 0.2805814279975552, -0.2025089607316222, 0.21390746226252161, -0.16592862021376098, -0.063078609044511735, 0.065999587695606529, -0.097683329914112618, 0.035486443325842928, -0.05121049440366611, -0.15833383019834557, 0.51845645526809447, 0.20884498668054971, 0.32291568001631543, 0.029236799679723754, -0.33043369483653273, -0.095859425713243046, 0.2268956366273418, 0.25841902037289533, 0.072221246368522202, -0.18023397897524518, 0.13086536925860159, 0.33993615290367157, 0.20329460788415185, 0.024381443620541052, -0.11772233642988646, -0.22274472212708993, -0.18122175041552971, 0.072213834504333455, -0.26160641789850858, -0.46640445740651937, 0.14087239985344371, 0.050117088195639162, -0.13317393350733453, -0.23381164998267806, 0.12418709602586578, -0.26491438321555427, -0.016100033426023133, 0.25707305677367354, 0.20861509801777375, -0.11913434494091243],
                             [-0.27055136826359805, -0.29957141779220819, -0.028810643908146319, 0.079549881132481487, 0.30058520543582196, 0.2192630534975506, 0.024168516499778928, -0.28032942636972852, 0.055015712997308605, -0.082844249440559292, 0.28155359966715937, 0.31346938465445862, -0.2108911370528167, 0.063419442133694354, -0.095779261966709286, -0.26533364134581883, -0.016223222927490948, -0.092086075197356398, 0.40783190634293526, -0.10230494340316958, -0.24052633022926917, -0.060045728182499737, 0.36065234475746588, 0.059702224794151361, -0.093825342503501247, 0.0043768982162216939, 0.05512950737814673, 0.083609525244990143, 0.023275291546672922, -0.22921603026464019, -0.054879335834504071, -0.17453923805811244, 0.077134697679471745, -0.047002602870681837, -0.21252231842890298, -0.057067571392503361, 0.33502381365284101, -0.30124418721867952, 0.11749694990791437, -0.0010201518355078491, -0.29677103743646138, 0.22114008985115885, 0.19579998938556362, -0.18291331394021865, -0.20530813596610054, 0.069479983174941182, -0.32961523832466222, 0.023960122784381681, 0.25052217937464588, 0.4177593301978092],
                             [0.22210485901021129, -0.33207166814253858, 0.058424064656966507, 0.18142252812849466, -0.03932166703782794, -0.2091484286593292, 0.039469974536177038, -0.21836762547092961, 0.022902063101023218, -0.29903669126875465, 0.11450590956766171, -0.078347980113008489, 0.065826264534641937, 0.34801800631038915, -0.028199012994993923, -0.096657743425070303, 0.11486917392134302, 0.45255828828957284, 0.074279417808621628, -0.09865390542646113, 0.072905383031375171, -0.19249885043142315, -0.38195086112983201, -0.025527304370714578, 0.1765789503540181, -0.03604887443686558, -0.40628630254808207, 0.028956523263523069, 0.12397236565918174, -0.0044774837085165197, 0.3204494564677971, 0.22755594005520624, -0.2189691110966725, 0.16810849843250986, -0.22976857343105378, 0.26818101091581742, 0.56530804211821362, 0.22414449494781144, -0.13374089343986045, 0.037072063769165782, -0.0032263675656036654, -0.030881372885836349, 0.15884662696027435, 0.14695671250737627, 0.13499741402910273, -0.19682980283739915, -0.21887849834369744, -0.28355577071951965, 0.25789662691548371, 0.13421305829351968],
                             [0.11313903181577939, -0.059509959992004029, -0.052270869275201311, 0.21154508191240542, 0.080022692849391563, -0.2924655734455972, -0.12697543509458217, -0.04130190447657929, 0.075977370905582861, -0.049810637867519866, 0.010637189390416029, 0.19892114026661803, -0.15488861358201331, 0.24058888135786097, 0.045555070500455229, 0.29535025657533298, 0.066384347191583509, -0.50745075502545323, -0.32717405828129337, -0.026635171258903363, 0.10150816449504976, -0.025592402463212371, -0.013866260436294587, -0.16634441673146108, 0.12773802329417519, -0.30574117291258002, -0.24465879552283609, 0.037167495420672346, -0.0017021934942719088, 0.22029263095853635, -0.19899691272252915, -0.074835450428089825, 0.11313259359633379, 0.13740730973535492, -0.2175834312550543, 0.33255750698199216, -0.053481130307476997, -0.038046047304428302, 0.030183855770217979, -0.094299462696326428, -0.20903122922016018, -0.06680038618086187, -0.11593531936424796, 0.032254807001870126, -0.13509260674681201, -0.28883142093244529, 0.025408838942728707, 0.27452130077794384, -0.32556514657134511, 0.48210630235111807],
                             [0.27966939810013508, -0.19044370974422081, -0.33434446754500591, 0.034668373039394663, 0.10345326462767529, -0.014165722300467865, -0.37330738796424145, 0.081954589438048661, -0.22264657057128928, 0.030042991430764245, 0.09571573616439133, -0.34158368242601916, -0.0016272487656791342, -0.095074758203823675, 0.089396586557613983, 0.020804951223236282, -0.16006569275083632, 0.1523727033283683, -0.096080494280840034, -0.29641470780992596, -0.44793513313719957, 0.26188095809186074, 0.27527836723890448, 0.10647598398996623, 0.30466797224457093, 0.17698162504399992, -0.37218832905122323, 0.028838336504556784, 0.057489932557986852, -0.24273214762705994, 0.45570009185398502, -0.18347154528783144, -0.12383670058781979, 0.038072439728385102, 0.16788732467770695, 0.1362963279176643, -0.19785019845286514, -0.30896773315793624, 0.0027379932139749638, -0.025621470913558861, 0.065071154216098062, 0.52919022990275144, 0.14436561202640211, -0.021568125021277161, 0.065045729422337856, -0.17127940168291064, 0.098310789846777186, 0.19683956876779815, -0.1054551507751597, 0.11413972884082044],
                             [-0.44911212494004904, -0.096209116503656517, -0.11118970137441594, 0.019253149648858253, 0.23819070749647378, 0.44080936866916748, -0.20755350530949465, -0.20863499143956754, -0.22327522920544426, -0.26620477496403477, -0.43019770525039736, 0.43174036527014442, 0.16661325081184683, -0.15996394407432513, -0.22177924052000497, 0.057729723499948142, 0.10205870319463956, 0.090253769223225644, 0.042174047109418522, 0.014872409451143532, -0.050829696898942539, -0.078661635470778632, -0.20587933720745707, 0.16277571356912962, 0.043664520539452641, -0.28536908897265245, -0.0099631244143955841, 0.21324531257123436, 0.086128223458836251, 0.34592455652444848, 0.33320691047164225, -0.14395059573292607, -0.078193538272740809, -0.039230374704709157, -0.1752761567890665, 0.037000693419050178, -0.094362492989853095, 0.057488992663791122, -0.069600344225208347, -0.21526702384769192, -0.11075765233483806, 0.06352697133481891, -0.050838210171733941, -0.12398522390648435, 0.21072005525543239, -0.23708148544711732, 0.0076064906402354554, -0.16084210858253759, -0.24770908971479827, -0.048223507808691557],
                             [-0.16494227652819035, 0.20608459500234971, -0.077806094115983132, 0.36000746881798301, -0.016582242208264576, 0.1946647175840934, 0.056063924745977441, 0.37340423056400479, 0.0098031798394755589, 0.4084052081617241, 0.36774814976407444, 0.26530195045626026, -0.070886460978802482, 0.24321805807055269, -0.11751262073974038, 0.27324623674961224, 0.16721194457761984, -0.22670360190040684, -0.12769171653185646, -0.17353910928675068, -0.11300983373091626, -0.12640117614645952, -0.03461504536145827, -0.15447302353977066, -0.19076731836859145, -0.52715739010409568, -0.10759998972497306, 0.088529403510407723, 0.00091863512227152613, -0.16388944947743569, 0.31462134319660445, -0.0012925035653219127, -0.066552947003642157, 0.072538168943005327, -0.0098199998089839539, -0.20554929743854891, -0.064700619115379068, 0.097361050153352988, 0.044031084129273167, 0.15352932687311199, 0.49892480968430053, -0.028485786469306468, 0.21763935577283167, 0.11800589682479508, -0.067161709004948458, 0.099048064617565101, 0.080413192992112234, -0.21663318735778239, 0.096609622647908927, 0.0049112998797521609],
                             [0.099553386835404739, -0.14548680426823299, 0.079510745840374653, -0.19376610825597804, -0.12122747563067501, -0.33455626969659424, -0.37374101618063993, -0.21969813469609059, -0.083688742241088132, 0.29161300715045951, -0.12875438505495629, -0.008618056968387567, 0.4405557843534269, 0.043302399551363245, -0.061163284336098758, 0.18865089032426552, 0.22313387869067941, 0.07883184792783865, 0.050043619807558608, -0.30223080851810846, -0.0029621625444070029, -0.24383729085322489, 0.19556442189736117, 0.29655369344044336, 0.20920936580098631, -0.12809384577317268, -0.088046629497574261, -0.030874668520382901, -0.092027059162351904, -0.097552189304838333, -0.04698184392988973, 0.28120025104786306, 0.13393660226340751, -0.12830671204961802, 0.19400163631022252, -0.33068730781175087, 0.18532286302261389, -0.20049675394937755, 0.15693606967973939, -0.19553843583777858, 0.061428985649640638, -0.18962438863128067, -0.37145566459793983, -0.34590086850499419, -0.11265567470984912, 0.44800641589055312, 0.23137251575764883, 0.08979231360278038, -0.2543528715278881, 0.056880460712309948],
                             [-0.13172865129239805, 0.26746395332085598, -0.05576967355631908, 0.037351914592209601, -0.065386134459763295, 0.56861900451644876, -0.019170618440632975, -0.36981910539653634, 0.055731926273712054, -0.13785573651010294, -0.20381934563731841, -0.098477233538883394, 0.13946106087865148, -0.010252376543941469, 0.49347619985907348, 0.13292656527039656, -0.34889720106341471, -0.1759243879207685, -0.19958148974841236, -0.035248721707147337, -0.21310370749907623, -0.023584727597755671, -0.28086396712188055, -0.0095179077368055635, -0.20940252910471399, 0.27209518047059256, -0.0091609781279609059, 0.22406837806981733, 0.045702386518690949, 0.019710873378900495, 0.1229622670346346, 0.022800196309319697, -0.020242842892713449, -0.075311160764589602, 0.0052969290773477208, 0.22160509238122122, 0.335627129776565, -0.11171133199712199, 0.096112738884575527, 0.0052250544173678536, 0.056914057222936021, -0.33923643177232066, -0.12429788850549595, 0.15458815825490096, -0.30395277662986447, 0.38934224422567976, -0.0035717501622610989, 0.18722839853957088, -0.19161730800129367, 0.15301421103127291],
                             [0.23416713301162578, 0.14232241378041402, 0.40034010626566396, 0.0661194208774388, 0.28945353923584094, 0.051463531148042162, -0.28588612970409572, 0.15362465547127147, 0.013225478927445862, -0.14152999982429845, 0.037647085922805114, -0.11356169131462177, 0.01597402215291303, 0.23591438971169912, 0.1727562940330743, -0.39742827427316557, 0.3379124897976013, -0.14946263329336015, -0.052958110354746145, 0.29961572755609522, -0.10592491625956575, -0.27674249161514941, -0.056389524896626284, 0.50733773091748136, -0.12689955010136156, 0.079536509287539289, -0.0050937012913703514, 0.20566588073851971, 0.12021577061344954, -0.32944991365780429, 0.038646725736048174, 0.1050898857284641, 0.0018496818830005342, -0.065108348877632963, -0.23223180415097294, -0.22464524021841881, 0.048333671202351026, 0.2338368040057737, 0.19683906453040984, 0.099185253029289128, -0.049505262742120165, 0.15585049496107065, 0.22200721672796764, 0.11172235962813877, 0.076372301590854189, -0.14547623877649146, -0.090200271634677434, 0.10516719581154781, -0.15328400285587351, -0.33616778385182794],
                             [0.12621568626355356, -0.05497782896299154, -0.25003781118649926, -0.50551210563426552, -0.044633211353040436, 0.082402038163224181, 0.082352355630152529, -0.19037035763633828, -0.19882128293810145, -0.079481384591107276, 0.042847439134849084, 0.1001006183827111, -0.013865377011661548, 0.20149159364647545, -0.080541305633485522, 0.015675237309103973, 0.30177733354298886, -0.47033546244692653, 0.00040732159852331293, 0.31499889414742044, 0.15503320341898291, -0.030704103125382212, 0.018846759460223912, 0.081731354222053604, 0.04998308341622909, 0.071475378406108847, -0.18579936585077739, -0.23152214088572526, -0.17136478855309809, -0.13505906030366821, 0.29003450637431349, -0.033301026352553241, 0.016624859303745607, 0.034318837729945963, 0.033360734415959811, -0.16583892059804881, -0.10317803923777724, 0.022605673818717514, -0.060676855259240388, -0.51682606053457592, 0.18984761339474107, -0.29796698869579341, 0.28244313649499325, 0.081902971408459757, 0.098546603206763561, 0.19511342509782945, -0.064424811448121219, 0.17630675858444703, 0.42403530002868062, 0.1619834539583988],
                             [-0.032573767172091983, 0.16114502914463852, -0.25762328842565518, -0.31725990237914042, -0.16008838637529652, -0.10021098008606801, -0.45263908736934322, -0.0096905490518644777, 0.13568264363432672, 0.10093305300907093, 0.2808631589524247, 0.090972888395155618, -0.1688592981767037, -0.083210939677935206, -0.12668983355386615, -0.19642452862315157, -0.054326454045917717, 0.20108142884293306, -0.30532687726529095, 0.091431585513531366, -0.34585153638857091, -0.24160350448597215, -0.28551699079817461, -0.29936613810151219, -0.4086841722613867, -0.060667108971181286, -0.10852590057958481, -0.26088692531333557, -0.19567115889784073, -0.15203455320773246, 0.048211819441655743, 0.001773492162537851, 0.15993902855684375, -0.0049337307253325691, -0.15182684027594889, -0.10094542315818439, 0.12445313132478661, 0.18165633291026695, -0.47330537911879622, -0.096075674777824915, -0.11573750621613046, 0.11433119560047617, -0.39096488720602651, -0.051562352241213256, 0.16883460888093504, 0.060360748868979318, -0.54675735256999092, 0.16725576890845928, -0.15223688987727074, -0.070288230832346962],
                             [-0.038720046565079248, -0.026654691638457077, -0.1886489090558191, 0.23839967102776827, 0.271671660894234, 0.15753053888816534, -0.18751422319296768, -0.29305610499583279, 0.24439394781964163, -0.017852444228213263, -0.30950801126358524, -0.13790742066358877, 0.036249508731968881, 0.23574358534340051, 0.41949074475047948, 0.047197790087554224, 0.010290472966278757, 0.22911032701542106, 0.098840818125330729, 0.20107210227197794, 0.28370277570472646, -0.42810675294999062, -0.00086556292350043612, -0.37115261322664683, -0.047532152010067628, -0.042991058773380053, 0.29978413408434296, -0.2713635883395582, -0.39919218806323714, -0.39290904470076415, 0.10197250416339181, 0.084164298951356256, -0.24300807743718342, 0.15046903160455355, -0.087037556570285127, 0.12361679810094202, -0.40653757897254855, -0.10506524816617978, -0.13953868144199949, -0.083065736582851421, -0.082273814629108308, -0.13749680150516011, 0.21499110290470072, 0.13470853228564178, 0.090572491043071454, 0.035731515266429315, 0.19828800924166545, 0.040732106508767928, 0.098027199631581102, 0.21334492393988436],
                             [-0.32309940047243263, -0.050090057305068929, -0.50367397010587345, 0.29558212440118997, 0.25764954784223848, -0.13160359217750742, -0.19862066109247445, 0.061248035252343833, -0.048466004672223298, -0.17048247983558515, -0.20044217086146937, -0.11251985111360555, 0.1242482291651318, 0.051872227646114245, 0.012814865426861041, -0.43027284985760011, 0.39130249048978144, -0.2894001417998821, 0.060574535412402035, -0.063834011319039194, -0.14242071085000543, 0.29635476060820176, 0.078877099347835961, -0.29453130666825333, -0.085190969389431895, -0.11362120082688323, -0.15720633539048082, -0.12536127261569721, 0.30096912634612027, -0.16549636612502519, -0.16504496385671985, 0.062519254722488302, 0.071337437508956353, -0.28136276614384015, -0.018013249540255422, -0.11922838394983085, 0.097727224752163222, 0.20995745193972865, -0.48474033636474467, 0.45834090249971166, 0.16868781236745048, -0.50883520174331542, 0.013063661146531874, -0.058793869567731534, 0.16378781314719593, 0.011031726512608753, 0.054165805796190222, -0.012933228600856835, 0.094520024805603967, 0.056152675454676518],
                             [0.061830576427494011, -0.36233544734648054, 0.025852041031685626, -0.068056143512765205, -0.23921501477902002, -0.23676899798070825, 0.059999216594800016, 0.12109982576123393, -0.22946543153178409, 0.019991237024467652, -0.36690914203797581, -0.044256688673796403, -0.0035607044772200725, -0.36798975305692277, 0.2029287914079341, 0.25226554035305648, -0.026602500983019011, -0.28000054907274768, -0.052976579875183019, 0.24966394850627804, 0.37694077565091044, -0.24564403167351664, -0.078438303751260555, -0.19358548650475216, -0.17727135183825213, -0.076559121546857609, 0.24335999385292345, -0.17702751971045849, 0.35419899844297814, -0.16304036315088755, 0.10194050246795219, 0.13677443502918002, -0.11463320940849163, -0.33650054946570163, 0.039122957933340939, 0.18216052351465953, 0.28494046606741835, 0.091335999116634176, 0.17650442271546249, -0.017394550838643136, -0.26293964009518156, 0.33947469377133099, 0.14117584745685266, -0.24619909718415769, 0.19157639587004893, 0.063843417823739285, -0.28089606732749889, -0.47787192915432503, 0.0038232024425849899, 0.15966865392778443],
                             [-0.011252598136740373, 0.042814649219814399, -0.10104307440523795, 0.0090498449332010351, 0.025522164006195343, 0.088180989041885025, 0.020655168165823575, 0.079005151191155379, 0.37568355641482187, -0.0011678196090000588, 0.13261997409503046, -0.041411456666999726, 0.16669614772027611, 0.26796274369002898, -0.11032049489814816, 0.17833274164175181, -0.18020434062031446, 0.05231806343383337, 0.32979101126569393, -0.14415562330389189, 0.07992761147707575, 0.4601087470425298, -0.1258631527612723, 0.30438874042720099, -0.082463114024359102, 0.062789871017506438, 0.19850095409176488, -0.36090838017885973, -0.12019645020664457, -0.26577745641749584, 0.14926809384200329, -0.59839177983377823, -0.044139282228546795, -0.13733557083678538, 0.060836864410421729, -0.052806454721693423, 0.43083269791483131, 0.36867188241658105, 0.066470496601950632, -0.35455441307387736, 0.010931850776509554, 0.019573004566022439, -0.34524245346325472, -0.14589571490072595, -0.11183386293550523, -0.39260773497205792, 0.15477504840280495, -0.057425987899602342, -0.13214219277535366, 0.15590134454954294],
                             [0.63131528828575578, 0.22322422834399167, -0.21726292421620308, 0.2833526997106417, 0.02225234004974308, -0.02551934165557199, -0.14995739204072009, -0.1932378329828317, -0.14149210693219261, 0.20145602489249295, -0.10763755068658688, 0.37274161326850935, -0.38147450017248968, -0.25765470992390394, -0.23840532317669477, 0.1396992949325688, 0.27702098320950902, -0.022868339950700423, 0.25509523342911877, 0.29430896469079709, -0.011802755929179048, -0.10110442917088966, -0.031203460898982467, -0.25319665731354613, -0.077133518938657705, -0.037768506833959894, 0.24167018092611997, 0.030315985974101373, 0.071770401923786101, 0.1033599096130462, 0.097336676062621391, 0.13650844531192663, -0.2840229031261296, -0.053263867473361752, 0.42384242995491406, -0.26345827266787364, 0.16547977297905031, -0.082948802547907041, 0.079511004278928987, 0.0025777889746405845, 0.15447903422033257, 0.0056840763416400649, -0.20821478575322774, 0.02666954347561834, -0.18665708014839921, -0.29011636652549894, 0.078201947716995374, 0.29359006563491463, -0.067155417753523128, -0.070805521535705129],
                             [-0.051216809018758754, 0.092802811025379378, 0.014827352123064092, -0.12559282651186435, 0.45139502259580766, -0.26502176926938492, 0.31829261224870248, -0.084766998056264906, -0.50030882998836146, 0.051603097381703392, 0.23921635120680659, -0.043143450224324774, -0.047480707230862743, -0.31653344365677794, 0.092022077879267541, -0.0019400607468698038, -0.16504382897809733, 0.32330792100968014, 0.05425874723706247, -0.036397960948171056, 0.067393953271632417, 0.063212684133322469, 0.24613666646347476, 0.053850675722629929, -0.0421123395130618, -0.26915406013018056, -0.12236370938839201, -0.058005425967735322, 0.29694194459232387, -0.17697109897889038, 0.39843330717373404, -0.037593701836212516, 0.036822657219826312, -0.13964196683234681, 0.079924442489280934, 0.18030753278412362, -0.25195207141761566, 0.24903343242635018, -0.019509189964904781, -0.11146775788934321, -0.13165309792498012, -0.23961708078835905, -0.2265037190690718, 0.44448911580888478, -0.36539510105369721, 0.15379916929901233, -0.0037693732634467968, -0.058483282590060678, 0.2217234446920632, 0.076244962226957078],
                             [-0.01508707025200616, -0.060612440642980367, 0.13783138782784549, -0.075018637782556158, -0.17172351587129281, -0.093543032395147788, 0.19637017630642972, -0.092633568843747183, 0.50999901786857837, -0.38560067363114725, -0.038216177145759388, 0.0096347692695313049, -0.25150037307649575, -0.087199941519373075, -0.057951116354035603, -0.020531189306559259, 0.29641491794679453, -0.48002817787992003, -0.11155744918435834, -0.48360922487116831, -0.13479965373079469, -0.13593754805735891, -0.075033729996784759, 0.1958994277503244, -0.1668377324263095, -0.1929814961309923, 0.13001451822326759, 0.018604683778479056, -0.31695152719899083, -0.22866168786743168, 0.10140089743784012, -0.027184261566668453, -0.14451508902073973, -0.28524102619480463, 0.29597750806297946, 0.10632538091081302, -0.27288846664431288, -0.50865217225693005, -0.077530064790215333, 0.23903545709010687, -0.18469925054434333, -0.10127502386344174, -0.23596273207235988, 0.2019551999853785, -0.016712974004349568, -0.1527271895452125, 0.12539957919034506, -0.28460937124550828, 0.13256229263959668, 0.013702695752200303],
                             [-0.30698049586649478, -0.026167863903053722, -0.21957710890578236, 0.28907246755718841, 0.17160419966626808, -0.31533813238695524, -0.17231549634077889, -0.2550102024379664, -0.47504933444509084, -0.14353402488975586, -0.19283016385512089, -0.1397893348805308, -0.14991191584261243, 0.26740228695620116, 0.12016692146147018, -0.074188387048013379, -0.057591203979351344, -0.087482258252942882, 0.048201222720146805, -0.11585678880452031, 0.0091093135291207827, -0.26606429505172779, -0.37847544285397972, 0.18546548767389309, -0.1095439097927846, 0.047806566340925151, -0.20817064109484429, -0.20110156068008217, -0.10546200918160929, -0.017504694047780007, -0.22842637599593804, -0.19804193136238932, 0.37077133779438293, 0.24302779776410549, 0.3060698940391281, -0.069464791125158798, -0.090156552490096298, -0.098748749748743245, 0.21122468782474174, 0.070700919282778663, 0.26345850192930048, 0.13481901616097569, -0.26142615283132015, 0.041062742540698763, -0.23199973672489096, 0.11298953104770758, -0.20367412608832544, -0.015155964297179851, 0.14287161390138176, 0.034286564527531822],
                             [0.02715359978473611, -0.19506369462621687, -0.22119091218086132, -0.013308111117308067, -0.086263357905543431, -0.048547745123239373, 0.050105120968003444, -0.13548331095125457, 0.21162393688123879, 0.22314716036642532, 0.043302272930950875, -0.25507791178711542, -0.37687649510964161, 0.10422864669306765, -0.052438857704197636, 0.24862806872683976, 0.050193999189494312, 0.051830790412553743, 0.23709419456639966, 0.20372564325373091, -0.050166355399169867, 0.14452362932747989, -0.20417746225887926, -0.092324151977736038, 0.086803536020125749, 0.099136727129031113, 0.021945425312999346, 0.48276011421027643, 0.3282372905653993, -0.31976596861144074, -0.15358669870560396, -0.25412669724105191, 0.24418098684457065, 0.11978522967366327, -0.15642706657772951, 9.2068958480574477e-05, -0.018908655570735674, 0.16017510519001374, -0.091980541755557782, -0.042283570164008993, -0.27822973320477962, 0.054350892695371147, -0.0026022205558644215, 0.21405867678460094, 0.31486846614393504, 0.56761365048297352, 0.24980581593859089, -0.20944926899383925, -0.19380326055053734, -0.15852071849131275],
                             [-0.12956136400901608, -0.043398906895736465, -0.056312004432436773, -0.15291332896335938, 0.36942404992018724, 0.0049617262356086624, 0.31488703184164879, 0.062669982521718473, -0.17201817939020236, -0.26364962097314254, 0.18632584018970999, -0.062043049787862813, -0.32787971382733155, -0.17223768057718064, 0.10523443824030174, 0.080613336163343527, -0.14387621844532394, -0.087138558142692044, 0.017876902804107461, 0.27325714517413341, 0.037043711808592644, 0.091572254427198255, 0.1847905538641057, 0.036254043125959583, -0.10887707231231629, -0.067062757140853191, 0.09978212608926243, -0.35890081483573533, -0.34824742680604504, 0.070510117183396032, 0.085246021988753654, 0.13573241412020318, -0.062299714105948117, 0.41120435132865757, -0.30320914792703663, -0.015564661892903304, 0.22567451370060418, -0.27426214761038564, 0.10945031256155791, 0.11411355223907121, 0.068470130107119123, -0.27982954439742519, -0.28229746980086268, -0.48988512119889011, 0.14454025070844856, 0.13310541866856643, 0.23212715866867528, -0.094339983781272618, -0.29119722438654927, -0.0072687657685593177],
                             [0.0016059722067039012, -0.12758617293646971, 0.021067553909539013, -0.065458227587125023, -0.20162041315971965, -0.058935614548220577, -0.42055129955091308, 0.28727724968250495, -0.18296413555468496, 0.30533113757521535, -0.09140673212549523, 0.12805797200018842, -0.16660603442379748, 0.018876295154240611, 0.3644575123630196, -0.11377727530813404, 0.27772578963848155, 0.10439511995245807, 0.11466976500664629, -0.068980809434940366, 0.086320046170422826, 0.071191408286732774, 0.34011067930396494, 0.063705164986080795, -0.091180877117903486, 0.20137835566286144, 0.042401162141486662, 0.1593805460637569, -0.26939929149374009, 0.17232088285654504, -0.081861161178935618, -0.090077646191742036, -0.34006859449684856, 0.097423361621776672, -0.24079011244545584, -0.055630887462799095, 0.036256182318959822, 0.0082724135778687972, -0.047404551487237705, -0.19850206328530254, 0.31400688523214482, 0.14411033765282016, -0.4070532122754294, 0.42258639090042666, 0.10162268385970974, 0.059722639886190282, -0.2077712403681429, -0.13674091207962097, 0.012920319146108483, 0.10270322735569648],
                             [0.32403677510998363, 0.27123844158104121, 0.082282176323959927, -0.26139925943573927, 0.34202418475940949, 0.11763663611740091, 0.1022339814074795, -0.25165474613435007, 0.04898873535704789, -0.13208554409521167, -0.17250544511449262, 0.18395273002219045, 0.13536140779793562, -0.088918065814747316, -0.28123411594220277, -0.16022305328020048, -0.12239634969343215, 0.0056476861554490866, -0.15370677167692487, -0.46317325271587551, 0.22288231392433278, -0.18882257121912538, 0.20458580547824812, -0.078903122855109351, -0.41175985948257998, -0.08803562965897245, -0.22863861726530194, 0.030803284764307146, -0.10766599581237125, -0.18874850714725527, -0.55331077466411538, -0.084856978031331007, -0.039582474033063114, 0.35307294178837423, 0.08132634210045471, 0.24517783830176854, 0.22759196199847753, 0.11816323051941105, -0.23740333566526339, 0.13976921398860254, 0.1842826884827902, 0.42299122836628661, 0.033050677737998753, 0.17768006238356224, 0.24582611882701502, 0.05451973063616225, 0.13230009169484561, -0.010068024439034144, -0.18075528955176917, -0.029294682833997311],
                             [-0.04611736991833236, 0.38443850818312364, -0.11456516328537029, -0.10182130990952853, -0.2846021385440764, -0.31757122442126517, -0.16850046796143014, -0.070694341746606937, -0.17808611216106893, -0.45316316061470319, 0.10391146366994498, 0.26633492783309026, -0.10867926142454604, -0.064316764763183293, 0.077415918443109355, 0.20509941586854377, -0.29115095205147895, -0.073448753874355593, 0.10357151556118926, -0.28162409729065813, 0.15406197461669732, -0.32018997993273957, 0.24180137349722675, 0.059774210377423739, 0.17298398790339556, 0.039335707167625661, 0.35403500575704389, 0.25862556548471172, -0.25698969297837676, -0.12100669018365107, 0.039629546931333783, -0.17276237134976019, 0.26302748435900669, -0.2625451859409183, -0.092718014647879016, -0.0061977943883123505, 0.089658001758892075, -0.0038591300259406378, 0.15689446291168244, 0.21020464303996433, 0.12930031487573737, -0.21654058850141267, 0.027939482445666783, 0.2846329243922302, 0.3785358382306549, -0.081405964092075997, -0.097313013487619004, 0.16498042768909887, -0.023468128854474177, 0.17003828274230995],
                             [0.11075757740732226, 0.11503682604930629, 0.11991115550291088, 0.1239021556376875, 0.015687538363666528, -0.19921144284042042, 0.10608268865996229, 0.0010786419754602872, 0.22666601400267342, 0.25784828967126955, -0.075727983053497913, 0.023956848495202951, 0.29369473612646407, -0.17318759130789838, 0.043543671613488599, 0.041937536433130911, 0.10387017127293699, -0.12963388358124878, 0.070954017576365574, 0.02390141167552793, -0.27394185271829752, -0.11256738781817713, 0.11307201347567723, 0.13531632337072222, 0.16628105657226799, 0.33843255526234728, 0.23420599645527909, 0.228466923282862, 0.093033988590818573, -0.082051754938573598, 0.083124336638243645, -0.017181125468546946, 0.38892679994470969, 0.34989608225400737, -0.15015998946295198, 0.38755484473581686, -0.15220871269251515, 0.0094419810349500553, -0.23835715243176483, -0.037942330284257773, 0.23688054173322243, -0.054025669214702136, -0.24757072831995294, -0.37000947239693421, 0.21809831591978812, 0.054112589545337479, -0.15195870033649322, -0.15027592015142521, 0.33382506973370368, 0.16588322073444714],
                             [-0.099507157742827618, 0.001067933751346983, -0.16607394537243217, 0.15652386708843857, 0.07688913695733246, -0.41537641970660877, -0.34741190063594052, 0.12134787586992098, -0.11986131615210055, 0.17539900141699374, 0.26928969253394297, -0.041480517042284823, 0.12154844545927826, -0.22046927689645046, -0.12767053070164247, -0.19567045080478201, -0.1236034567244387, 0.14872418519132843, -0.040005608184906206, 0.23708187364598399, 0.42105951375364087, -0.022595454345095706, -0.37054096545548515, 0.24666073031371291, -0.38915370086326995, 0.14688238575745627, -0.066853869742023189, 0.23583670219188183, -0.34994322110777665, 0.02562525171815332, -0.022629039004492226, 0.15794900811263451, -0.20215656324038786, -0.20384091683182479, -0.0092208594112123, 0.26331652791599086, 0.044271182775610984, -0.13276903255402764, -0.08765475252917157, -0.19316047463313982, -0.084688546378520413, -0.13928042191069695, 0.25783159261247823, -0.23932131741307139, -0.2222757531852704, 0.051694290484624657, 0.36958815258161037, -0.21941214504370904, -0.1998617694431101, 0.23406400378395492],
                             [-0.19947618446491283, -0.086763548510054703, -0.13365340080980911, -0.1944676313055671, 0.18204890960934611, -0.22305067266344628, -0.15012284109154278, -0.44416893342058544, 0.16521338457896986, 0.34183268070094586, 0.13002550119849329, -0.30940686650245364, -0.24763247536067443, -0.040847516474271491, 0.024091404089994845, 0.1939165150780095, 0.17875677902478573, -0.13991323331308009, -0.099659880998071576, -0.24379481809159889, -0.033280671992347001, -0.1245298138483016, 0.024792367161377216, -0.077366806003128244, -0.21741982063633128, 0.20468057496325123, -0.037685761956545952, 0.077880852984046428, 0.026785096138551588, 0.27089613476656327, 0.13606396125804351, -0.057320700078907508, -0.39255410711976318, 0.16733960124585784, 0.21135316435691154, -0.1406620014178307, -0.098507580835447611, 0.33168949374328605, 0.38838038333348845, 0.17462428814818751, 0.0020145629662084857, -0.023869315555549019, -0.092649741916190506, -0.24868033427044575, 0.3023162411566353, -0.33315825036406221, 0.22636911874306376, 0.11544050641025944, 0.20637107336824134, 0.15278893664528848],
                             [0.055186075820620434, -0.14479675576920062, 0.086376485464933817, 0.40303323996889306, 0.24090869912904855, -0.14325191920747668, 0.18816446222649091, 0.39427800101131483, -0.01448373966522622, -0.11763289362413659, 0.0023673405995238888, 0.13463395485554233, 0.25086424898372073, 0.028096322803979459, -0.13668889255435834, 0.097469858780894619, -0.12210903722983445, -0.26756434127026124, 0.099503516782372597, 0.047568411042739546, -0.060356983253775753, -0.40551702368670212, 0.0056463635051554259, -0.29669152137734967, -0.16874580354245239, 0.28365839975906604, -0.24671497338402038, -0.0043595071699792428, -0.073194468562290504, 0.28214738378868204, 0.089475304734087588, 0.05327591263734361, 0.17665308700591328, -0.37186014237228654, 0.054708707756635763, -0.21626234738116287, 0.23630830142398906, 0.24130745882821994, -0.11555713860582842, -0.13282234548450406, -0.2239946276214782, 0.29195712712663718, -0.082993261150777597, 0.25135535007759674, 0.11433939317667938, 0.22917598989940183, 0.47664954256253406, 0.030688399655495423, 0.1336942708714921, -0.10038700951762361],
                             [-0.2108307269700781, -0.055935510107580771, -0.042171330493032906, -0.11305716792239118, -0.38571534872424329, 0.034533071540292441, 0.060175852249609231, 0.12223137826010626, -0.17043338410395034, -0.086823183975234502, 0.46762204763846926, 0.024631039776389342, 0.04615309054397633, -0.1461765212738001, 0.12346846414864215, -0.39782296746256446, -0.041483466972457805, 0.037400741431991708, -0.12732271403572851, 0.3521359779812368, 0.082106189136456703, -0.34416914560661654, -0.10509883331688923, 0.13477371873414956, 0.37458167953214849, -0.32959251599476858, 0.23040596393933868, -0.043732423813559726, 0.088458507159975719, 0.071949064928222423, -0.0074925391166572285, -0.24708327094006244, -0.17671382403918198, 0.27071211936173434, 0.11641957385134388, 0.24328163516635148, 0.10873226257515176, 0.19945869456552873, -0.23969644907558613, 0.31328269624267324, 0.026506943312014426, 0.41306111626830583, -0.1756723848652455, 0.15358259602271204, -0.13135404387802721, 0.1115697725869326, 0.50494470198070451, 0.25778840913230583, 0.10976123875402516, 0.24053841449143254],
                             [-0.00036640875504917719, -0.11234188700496009, -0.0022231100167256317, -0.022676001374425766, -0.10574061960855501, -0.22553384370113772, 0.13568602898942225, -0.13171442268776112, 0.14616644444367052, 0.52381229178353228, -0.18229908870411921, -0.053783115211515145, 0.08464417466065649, -0.35177705160991557, 0.075601058359615711, -0.32734892491009054, -0.22778319483484358, -0.20283557882520256, -0.063010153824024279, -0.070071423346273948, 0.29264187205983294, -0.034172300833373366, 0.057188454899660561, 0.08051233654483049, -0.10148973284032382, -0.14822404090292776, -0.13588787989065856, -0.16042046510123203, 0.037609188289416506, 0.022825572708959303, 0.27324153832178949, -0.16155775967040961, 0.22970034763708277, 0.2746142856511915, -0.29820676387639822, -0.32859965818458253, 0.19947306675684623, -0.37654398475214634, -0.16817111243141109, 0.20814216227026056, -0.1369641304480024, -0.051851080863012523, 0.027768785616699879, 0.15778018781453945, 0.12370651195816001, -0.23478074172821992, -0.089284470341323557, -0.031231260845471665, 0.011446619645656738, 0.021654589529649392],
                             [-0.15331306097454728, 0.36532823536573572, 0.033105290954825818, -0.060324595203562627, -0.052306460225401787, -0.16852916167797949, -0.30451178472101192, -0.074787766221765431, 0.42550610321936727, -0.35248697305914645, 0.10030711153267176, 0.011337558814331138, 0.18690956683303608, -0.066802319794399934, 0.12895288701684121, 0.14640588796078319, -0.08336422576285514, 0.15281172742346441, 0.22677458428155817, 0.34915084518803402, 0.18798171566619448, 0.23484012887518094, 0.22235132099539903, 0.085594637531495071, -0.13810213329832732, -0.24043691670393591, -0.36823451052570039, 0.04983881307213741, 0.27979125566505336, 0.18050566210791041, 0.015508832449464018, 0.16211957569277238, 0.29742129729248307, -0.095414968209624543, 0.216228344144371, 0.096561872273164276, -0.083651829321936252, -0.019816327492574934, 0.33330085211215088, -0.082932835283969469, 0.11728517836539071, 0.078283192181854547, -0.29489989276569878, 0.22842403452247054, 0.21535004670984204, 0.063129949194038831, 0.1020401789889899, -0.14851824616303252, 0.10519361313886787, 0.27189869363947727],
                             [0.34732671412903676, 0.25412153068519061, 0.16271623227777085, -0.35303647349459072, -0.12254162971115719, 0.32817149769913667, -0.019552083661625419, 0.12857197630439932, -0.30049123869893701, 0.024836603494116819, -0.13824619835505761, 0.019103537261425892, 0.058070757851931283, 0.31095514858018303, 0.0024653482260458405, -0.24786657839398119, 0.25678220180995337, 0.18926131187508394, -0.11043378906053687, -0.27045773617667973, 0.37559656441898503, -0.24633661808845003, -0.11165024517318707, -0.4596298665323037, 0.12917417984992358, 0.27144622688098441, -0.26973116890554644, 0.049984338383851558, 0.11869156920647186, -0.139025510628389, 0.40293613232081088, -0.32810525579573485, 0.4586003154842056, -0.072809900218518214, -0.15295449110002124, 0.035234906767186623, -0.14565684776634341, 0.081683659864289229, 0.077354257577639002, 0.11157357803865074, -0.10041250669335118, 0.07144776295477516, -0.20763496754055671, -0.18651037738498075, -0.21713264065394752, 0.047684335805722851, 0.13850017410278337, -0.23683498919262269, 0.10794127662883725, 0.27821012477779572],
                             [0.10858066108783294, 0.091549599995930458, -0.11431835894780808, 0.13929690488967725, 0.0043739903473005021, 0.20812647583270932, 0.035655380460132946, 0.35054895051922097, 0.17295200007471684, 0.045562615036513737, -0.19239912912052837, -0.089239485804384594, -0.1276534800892874, -0.21767388952747885, 0.1491327807679971, -0.25747992750695731, 0.035912348490165197, 0.078448098327325175, -0.31879121511985237, -0.13787358094093191, -0.10144911011597432, -0.14678195091270513, -0.17643990211724309, 0.054511748881731721, 0.31308448741531081, -0.29729339650980768, -0.17747162470036121, 0.44613536450994201, -0.15960146444031742, -0.27381406651666695, -0.35939723626666109, -0.31817809420225512, -0.062528291416937873, 0.0099538738361980988, -0.15411316005769662, -0.24627725270698755, 0.03621655345199222, -0.0079664336781744595, 0.29716417326683708, -0.48353487010192858, -0.18336448400806735, -0.084688430810276494, -0.14013175328226199, -0.32906334352501243, 0.31238865427352325, 0.15776241515053188, 0.20324889158530193, 0.053268367868698874, 0.39690020022677991, 0.11904383464073283],
                             [-0.10217064575200009, 0.1482538665114668, 0.17582038418630833, -0.0032537365403186376, 0.14075132424905004, 0.055195930885316935, -0.0030109162343801635, 0.24478131765953365, -0.059827038686400345, 0.17309150768630432, 0.18258455746757976, -0.37812238942667209, 0.021503310237322989, 0.17702503961365837, -0.20194715493694679, -0.15847996465682693, 0.12875226775204091, -0.22277066680074484, 0.48860745639263065, -0.019942732435720107, 0.28173917356566558, 0.030863655410308569, -0.18065998358380303, -0.042627403368211435, 0.1112502515765755, -0.24964596051208726, 0.059326071106459002, -0.078335263162715746, 0.0050384998802326846, 0.27850182677145119, 0.08977964258341356, -0.074758949943636938, -0.17828292956927058, -0.0002326811273131689, 0.022300524380620662, 0.54628380900808926, 0.17524450874074207, -0.25564126280398097, 0.28528028808159989, -0.074695206007980339, 0.024727539427164755, -0.11534399849165385, -0.18146881421261205, 0.092986078599757618, 0.38795877106219712, 0.16284624031288264, -0.37541200614787223, 0.38378426014918982, -0.12519974407226711, -0.10928623305011016],
                             [-0.19818927206704129, 0.10427330074000574, -0.19711189663551767, -0.15357354735207601, 0.13658168306138169, 0.049789546705829225, 0.026568637803062175, -0.072484520237081199, 0.048995467843997824, -0.13562029041527388, -0.24972642202763248, -0.060371088987830682, -0.12493318576815962, -0.16376745773527082, -0.52082319454319237, 0.12202349596979056, -0.13035489984045462, 0.042400940014479936, -0.32689805505745384, 0.044260647232867427, 0.12305048307413534, -0.042395412316298335, 0.011885867262783838, 0.045641980346372568, 0.024159052604361509, -0.044696215215986226, 0.24909955893882296, -0.12251836153387692, 0.2267089825494735, -0.051667454611652661, -0.10364541854652723, 0.20199397495998792, -0.16594365719113044, -0.21821246975294134, -0.59769265468689314, -0.061722015588383985, 0.016797480782563878, -0.32884000531216179, 0.064428825633848857, -0.027839531135202933, 0.32048822051339237, 0.33468169543676463, -0.10935528875151962, 0.043193451549596404, -0.35876709271015267, 0.14213616633243922, 0.084941548334457981, 0.095186383875609473, 0.1229914086062445, -0.083835085918403732],
                             [0.1686278924320527, -0.051796551675662508, -0.23268071805317003, -0.2525186597626608, 0.13134791190622347, -0.1254870768737672, 0.45626740240862673, 0.093882585912842736, -0.25164785497859665, 0.095243955048685491, 0.29368030777800813, -0.12967097751631015, 0.39169031285864486, 0.32468647377756482, 0.26450518356767655, -0.10284881600848465, -0.025127938263814837, 0.054463185809261822, 0.19919482011556289, -0.15604574520741171, -0.28464581998549421, -0.046128328623404984, -0.23644109521787238, 0.039269167098370861, -0.27874871063783863, -0.11448103494872562, 0.18397137271027031, 0.2163432282285683, 0.2822709985940518, -0.016506475707917412, -0.36608771097587789, 0.16345571783383006, -0.078053263569042061, -0.21077540249454665, 0.023324087495395111, -0.26472286226134079, -0.19577889873611395, -0.49264641248747792, -0.18214010469914751, -0.26622332351120281, 0.19980732888158528, 0.086303126559328189, -0.029862556081443076, 0.039192170957862739, 0.046725144590522065, -0.22710168292769747, 0.040975242913322267, -0.24102477406846137, -0.098882754287756031, 0.27912379384920188],
                             [0.064348319953348179, -0.13378451816764259, 0.33772494997776431, 0.067136468465095647, -0.20049563759155395, -0.027117813515777203, -0.23682560295602106, 0.21057036448382638, -0.21053511731388666, -0.13334912885638825, -0.024355359150360786, 0.19767596193545869, 0.21487022165380126, 0.11760828737562859, -0.47753566074858933, -0.19939428789675481, -0.035116958190235664, 0.12388806125195234, -0.17228312947717933, -0.11337661692989179, -0.36275870256250375, -0.11754802858529684, 0.047626993191066849, -0.026243802604052416, -0.39618777929453614, 0.18767532888565294, 0.17184805325021899, -0.33823894561082107, 0.29728262849497339, -0.26906471949520178, -0.074592484193229239, -0.072475723772299758, -0.13426934513180749, 0.39665557803207874, 0.093206981706641823, 0.076991053117014693, -0.036762041529943862, -0.29825359180060501, 0.18713598550845942, -0.015836564583135208, -0.25483637275469284, -0.30430613853793231, 0.011097189457841342, 0.2247032690396614, 0.09119398843911522, -0.049121287966318594, 0.36980048462779264, -0.022920471330936082, 0.11024254215497004, 0.14919673912955872]],
                            [[-0.014774895480962225, -0.085439843996023127, -0.49758416001778871, 0.28183508016838404, 0.41825208634442973, 0.0010268929355514121, -0.13685340750408337, 0.18455969982307641, 0.15370170657697738, 0.35593201245145828, 0.27112241461349806, -0.087582649313936903, 0.0026179420086987829, -0.16136589093368875, -0.0038028727880423524, 0.058679486647255863, 0.27979302425295732, -0.11179077564441681, -0.038697232200419353, -0.22446016469465097, -0.020513567790973269, -0.26309322502721, -0.17723208601506818, 0.088813693330967849, 0.086713246214800366, -0.14337324706848661, 0.15845647986148986, -0.18475999811632871, 0.23816237935389889, 0.056904210695671031, 0.17399162886635489, -0.21577692362323858, 0.10399056658968026, -0.016395441153016603, 0.0067653674627449704, -0.49419806682230438, 0.075969406102587234, 0.15527847398549444, 0.025033244900989716, -0.18262568746885077, 0.30269926223420324, -0.089251238922439594, -0.0010305654279281311, 0.18278658630734088, -0.055061734335864705, 0.03666333036013944, -0.16287122152655992, 0.20647928589457543, 0.29622515639890712, 0.057509275219223936],
                             [-0.29591878443767738, -0.085867447538730948, -0.21257266711306788, -0.23148841438711365, -0.31189509433269957, -0.18301630007467204, -0.032092121025048555, -0.017557885606448099, 0.0022943351383680121, 0.2085800357487963, -0.1920406158278827, -0.16250038495680155, 0.33153205093526039, 0.028769269998344272, -0.089637919383276893, -0.25955293016419118, -0.010202416640758888, 0.27842001605531336, -0.01824048991573889, -0.079792753131199698, 0.20146806221142619, 0.28986417595989489, 0.18998394786109718, 0.12193050961697485, 0.1283916565806465, 0.026855224319782649, -0.21343167977549654, 0.21717940424298957, 0.11911262244541176, 0.12450311110764298, -0.44222183699091233, -0.34819244117466569, 0.13435238225195736, -0.21337752786059844, 0.1711104185529588, 0.2115093694933981, 0.19279214694060975, 0.085498092133661829, -0.11393705864625532, -0.37507168726005191, 0.1468467740705372, -0.2725362684953101, 0.0039340487692980097, 0.030626154895287826, -0.28180837529057284, 0.33620520871968573, -0.3290196354092419, -0.057617573798638987, -0.40439793685261355, 0.036606648544879584],
                             [0.099011405338806563, 0.0543436413205396, 0.22596389099426678, 0.085096272824794206, -0.17488347186238487, -0.28262050605045669, 0.22756250299360181, -0.075019761991743109, 0.33651011811666348, 0.15839179989187538, 0.26603159262580606, -0.033490409020106818, 0.015736769936180089, -0.15174406170666774, -0.57875759665678095, -0.2792981678143181, -0.0088689042533869073, 0.090297213134401283, -0.12688889683516974, 0.45864300797078361, 0.29486527977531407, -0.25991688519704204, 0.14468724083996118, 0.032382464808648134, 0.21887640325107255, 0.11542566650335037, -0.25038015839835087, -0.081998698296858991, -0.096738863831499183, -0.35981072602908437, -0.16909489853635584, 0.36420946961613965, -0.11607395274989894, 0.1235523392462318, -0.13790925250271618, 0.18604794911828063, -0.21595548261590761, -0.015071201750799609, 0.13113197992168654, 0.0044324251432920903, 0.22122924247069256, -0.014710944706723395, -0.04308922420126831, 0.079548718430264065, -0.16552787045977824, 0.32518262062417136, 0.08242272738256555, -0.047896130483014797, 0.16051434027597444, 0.27583752356432678],
                             [-0.049335293069906701, -0.055721284733411716, 0.16625959229679077, 0.048329346590967479, -0.28093737431315691, -0.14059543464604859, 0.16700702789776492, -0.25490553430518159, 0.15549432762264961, 0.11987784362236124, 0.056586576753717782, 0.15757605829371121, 0.03960890711778059, 0.14088217323911414, 0.24899510056123611, 0.24348044352420217, 0.10047936081271218, 0.20359798406669971, -0.028928693451433778, -0.28346207947341306, -0.024248321813035306, 0.052403122981691183, -0.11372665511200358, 0.094832536138861251, 0.074897899519670019, 0.05028338830273444, 0.16788252600866937, 0.10454379568958048, -0.24071189068955073, -0.1470199547409653, 0.13215547080266163, -0.10108410215876534, 0.054983863111953357, -0.16547749116731392, -0.057273591434750901, -0.21421928212774863, -0.39586269623990378, 0.48571671797177146, 0.24714345672289584, 0.0075599509108617994, -0.15838042127207272, 0.31571413042213964, -0.47526275907971527, -0.18341102632553763, 0.013670337874312051, 0.16826081332171275, -0.14837549111707599, -0.06221325575920722, 0.20294648047087144, 0.25146499517699727],
                             [-0.17522878380604542, -0.13262402919795427, -0.20662655068915606, -0.043888265093600012, 0.30389822950990319, -0.25595617113995622, 0.27751014373785476, -0.018744066229451146, -0.075679006395147075, -0.1273920360314641, -0.3804188957631558, -0.1624587801767774, -0.28427888677698665, 0.20434377937544052, 0.026478766406396268, 0.30012718492238211, 0.12704297325916683, 0.11883269586794022, 0.21334638292648297, 0.11673282845169655, 0.094726182722111529, 0.057184282824078669, 0.088699920270691388, 0.039852216470942059, -0.18561729942025948, 0.045654584124950451, -0.15760894888903293, 0.1908871568823389, 0.17869964744971559, 0.0016258059888769657, 0.16274649697312352, 0.24874764786424788, -0.25746882734412618, -0.19131277798418747, 0.27212302955742657, 0.00437557335128054, 0.042419462325487239, -0.20739709939005696, -0.43382279116732186, -0.24525583961478897, -0.28908537518233429, 0.040758136342090398, -0.13195041676682751, 0.29665247926443339, 0.017123565420582743, 0.30844764613639836, -0.057823508833104692, -0.085900449932251918, 0.29812467301783296, -0.14022543665981629],
                             [-0.27614074511325443, -0.083745320779498894, 0.03837537025221209, -0.096468760122887603, -0.073893346877764721, 0.070050898458507357, 0.28989196644542981, 0.17714767916751875, 0.29015840679914834, 0.13909916416066254, -0.091211023644319683, -0.40042892489226251, 0.15522691192661678, 0.21707615240873931, -0.27581562399943704, -0.24296147999311696, -0.24003842996140182, -0.23353722710300723, 0.23940726365773271, -0.10498487141691314, 0.29336640115025764, -0.088541044972513416, -0.26394285453705657, -0.017055814099805441, -0.065245482181229747, -0.05601891005922327, -0.11176245891322671, -0.077476524127615881, -0.22599817943844366, 0.22367929649910559, 0.21602173007600012, -0.0033080022589350106, 0.23124497078899292, 0.073325904762638838, -0.22699259013832013, -0.22975744417579508, -0.25233592727711351, 0.06602544691720183, -0.23317161478372256, 0.14712303666218995, -0.21786874792840699, 0.014728758416113555, 0.068956570066647668, -0.27716885404422575, 0.21245022390684104, 0.0076359028813598722, 0.009052838149552175, -0.21128383049029978, -0.075068320286702864, -0.23790580968431618],
                             [-0.047213755289356341, -0.23535085610447443, -0.092730447105950506, -0.16979980022929181, -0.035119133896417812, 0.31568579079378911, 0.10023221853333436, -0.10021504324090127, 0.38873922900186242, 0.0042355334805487116, -0.3155539604078838, 0.17902890299269433, -0.34393566478467252, -0.2612941649041961, 0.34699211488188142, 0.0087428332061067794, 0.23942078337463746, -0.12781648011613173, 0.058550622316070389, -0.27746139008511816, 0.13130593447062436, 0.0040900685254120911, 0.59967127123616637, 0.20075658916109448, -0.098062463496408722, -0.032109299248835294, 0.21678329346266934, -0.29560705931711923, -0.30811149773859692, 0.053404651200345106, 0.17949745342545476, -0.027365729720146739, -0.2575872449044021, 0.031589050310887976, -0.20125653264888066, 0.056056368602533539, 0.040860400391628873, -0.058798075243729514, -0.20388330436864394, 0.23760471982222631, 0.16140977280673272, -0.2339513674781436, -0.21655480530151625, -0.17306057621912013, -0.088880424080585885, -0.05494818942901393, 0.13526412240137051, 0.29078614259671098, -0.098923347857457156, -0.19329524108728963],
                             [0.092379773721504188, -0.21143273894633091, -0.12677500278320197, -0.32247216672961365, 0.11897978436160447, 0.3171068134225859, 0.024765653139792541, 0.1467490517129296, -0.32449670713566464, 0.51228315684343517, 0.0016094478798181315, -0.145112461261139, 0.0094618328008839164, -0.37748648804514612, 0.043077734106989216, 0.04223851229264184, -0.23752625824880841, -0.1224249411548949, -0.0090722312567624256, 0.17444296097089537, 0.087945031605232885, 0.032951479521627795, -0.22216010541328793, 0.11753292453893564, 0.36073219712710136, 0.2418802221627617, 0.29207071145698227, 0.19844157896473855, 0.0020134939625775072, 0.024710493946523894, -0.2757325912825766, 0.088026252727073262, 0.26514673295150121, -0.35050889121874146, -0.054724180010165505, 0.44380683241338104, -0.16483644044478785, 0.01460112840182428, -0.0044456845166960099, -0.13808883074568962, -0.10533484410550573, 0.012958344257559901, -0.2657410346482954, -0.15450561196434059, -0.03598154687334746, -0.15690806873615901, 0.25429331826302753, 0.031451901731912153, 0.19685485221100812, -0.15922037733471828],
                             [-0.27070602341761518, 0.12129772862655264, -0.12475312640035001, 0.43432859241959459, -0.10521501033905939, 0.14351039839340535, -0.12457720102373439, -0.058826429159054033, -0.19132788256598507, 0.29842739292952492, -0.21824757649667029, -0.096561281882382222, 0.10428254193946779, 0.19525737400084384, -0.08702259915245894, 0.026367443970521456, -0.26195298153110752, 0.089533892402402587, 0.28355112508288965, 0.2009366812644626, -0.074978085854997961, -0.16212514896542907, 0.27317373478061585, -0.31753111861318623, 0.13426148804534835, -0.029097871354540887, -0.18291476626911216, -0.45788389205512836, 0.23955679593106857, -0.28082687628232433, 0.18105740465930578, -0.026348358443291878, -0.0079988692531727888, -0.11529502195729253, 0.17354639922965215, 0.30106993147379868, 0.043168384286093313, 0.32796230010469551, -0.090945011370198697, -0.078399816245829493, 0.14609900767299464, 0.086770742517691957, -0.23770918146776121, -0.10457547556367561, 0.051628765558390056, -0.19725902203422394, -0.014112999760842909, 0.027089219035160678, -0.057371097286407303, 0.057768410327132078],
                             [-0.13474106866657398, -0.13016395715533535, 0.17418161662308571, 0.52726693002166958, -0.27669418642110888, 0.17835885581434072, 0.27772167962601935, 0.037844042294250389, -0.21561768044193191, -0.13750986568480669, -0.15023406992313218, -0.030646842575336973, 0.25571092497559345, -0.06850250113987455, -0.17398913846269837, 0.17408553340078875, 0.26358594180307715, -0.092216981765837092, 0.48833559396446979, 0.26767679573293612, -0.17159953660876054, -0.11774353898190196, -0.028037510519549374, 0.40972718903269462, -0.010392136334390553, 0.13626982953961075, 0.17482377414365494, -0.031961663542171607, -0.098515142713723428, -0.0027940875117985764, -0.054592266392648567, -0.2270440440848272, 0.11668181894825394, 0.027252301604565973, -0.33013067665244494, 0.039329342736180245, 0.47023894564627511, -0.10385770783746463, 0.079646585438865505, -0.20302535787689674, -0.21634863275780486, 0.15055454702982393, -0.11138158825295746, -0.17390199862409847, -0.3114931088832934, 0.11086240690093423, 0.16456182683400808, -0.24227024598058625, -0.19578635213331338, 0.33373839527727556],
                             [0.1532252114643346, -0.46267073822882798, 0.20116430567052559, -0.23498782322390646, -0.077465757342830024, -0.47236267401028742, -0.068123224188971418, -0.01346397163963501, -0.072953093441042088, -0.45364424546143545, -0.14513976359914343, -0.11135223130352535, 0.19432691088481568, -0.065777832541221201, -0.07839036817460894, 0.1664757025176416, 0.063355480870567513, -0.47395048457181715, -0.048171690145250953, -0.0078325903995616827, -0.086328362131218708, -0.22584567627690011, -0.10671842389083322, 0.0020495083528390004, 0.061299574626227843, 0.15527478214991841, 0.047708102890810594, 0.021179582455873546, 0.18791292976662846, -0.1748623522507427, -0.21712563225028789, -0.18601941866813804, -0.06543271350284964, -0.37469060595695852, -0.064620803709598579, -0.065352775762288859, -0.25251702129881204, 0.1542369921544646, -0.24119377600404301, 0.31563077611568574, 0.39623817378727233, -0.045497697941248437, 0.045627275860224061, 0.29711543921105721, 0.051517817885784981, -0.0485206465199697, 0.11850045948021071, -0.038895741791958288, -0.012023252537500185, 0.10616965687579275],
                             [0.26510174843433809, -0.25842428053765748, -0.15966081992673142, -0.096204601485187252, 0.015746093233853772, -0.074976222831295208, 0.017677797030008519, 0.0054293622471583702, -0.10702769910959617, -0.23251157185239152, -0.074338052231633645, -0.11177457192810343, -0.37216229655858241, -0.24288992065865514, 0.069101642418894021, 0.10095089644065595, -0.40561990805144321, 0.037123998044589442, -0.22143471710610818, 0.24358727156620233, 0.083559370887379192, -0.16845919839268769, -0.22566602258443111, 0.35924228785905787, -0.15666729764562798, -0.44870523018023162, 0.0018429125964374085, -0.13084571471431203, 0.28339344225326341, 0.43602595388768245, 0.154688736196195, -0.24938579895149821, -0.18838030358620622, -0.040019869104470501, 0.05535047179157121, -0.015646008223775605, -0.22788637556104172, -0.087896425511682058, 0.069234486275443874, -0.059553176293344084, 0.081224211866488316, 0.50477278392868907, -0.37451476070025097, 0.0026145479676700726, -0.039640692259752974, -0.025248479387390551, 0.057990682396670934, 0.1033951396688722, -0.33384528014403086, 0.23952223943670448],
                             [-0.30144168235446328, 0.53899924471974736, 0.0035524953975775934, -0.19707815027979389, -0.089661142756268131, 0.010293951316264347, 0.26007391164558508, 0.095897380011145936, 0.25882584674885717, 0.30061850422479525, 0.22297177216914119, -0.31522007681047942, 0.11693843778285476, -0.070202083020302633, 0.18588813490979753, 0.4405908347801345, -0.034276383707128585, 0.058542615984785336, 0.0081472075916451739, 0.035028294185488966, -0.22446063539614963, 0.043628270527514029, 0.040445770471675135, -0.261332573024875, -0.3525263080345048, -0.34163327026305818, -0.098892136369195777, -0.10756976444056673, -0.079732221133743023, -0.11635016082358143, -0.33937599572733163, 0.16330645748233794, -0.031886168502601946, -0.10980681896108846, -0.30611473939929773, -0.18554089292162526, -0.095707326510483026, -0.3158363369685227, -0.19430909336775065, 0.068606251084065817, 0.3956129653296146, 0.076154309730629616, -0.22902793719727735, -0.20663753578265803, 0.10904547283322544, -0.036275847612256253, 0.14440995327609563, 0.077301074974814116, 0.0054223274086009354, 0.1637207851531659],
                             [0.082226514419904473, 0.078663222764407348, 0.10388654503566619, 0.047020929061585892, -0.18217644900375629, -0.12821299512765599, -0.018944788635633505, 0.36716405319384393, -0.025843881264059374, -0.20894843219259673, -0.055419883093094834, -0.16528418812268539, 0.09551519034131925, -0.0083295551100133515, 0.08396658268824149, -0.355872264236896, 0.3210329690039434, 0.18867605326824116, -0.054392744542495736, -0.11924318414515951, -0.36427973830124272, -0.42143825493647752, 0.30980443835712629, -0.34104946746928755, -0.14488280481373322, -0.033030615710000912, 0.06688581937148691, 0.058930694272019635, -0.083903767010706731, 0.1054983375992179, -0.095690076572832586, 0.30987502192069249, 0.31131176276529704, 0.088005536018214564, 0.19755837028480455, 0.14049674450686286, 0.19404830234307643, 0.091769832742673543, -0.12263502752621452, -0.14092695535895988, -0.10517560405820556, 0.091389241072028948, -0.45054267991090402, -0.049020378780371729, 0.15921565149142677, 0.092874592367949663, -0.012274071709234512, 0.47119456246419134, 0.12032150122917903, -0.23512404040593932],
                             [0.26344632981129534, 0.25458866468367103, 0.090693203051719101, 0.11484898918007307, -0.030000381435950196, -0.13270645645905396, -0.015171259138417433, 0.21645875020162425, -0.092956945829906462, 0.33204182314303649, -0.42042420357026428, 0.11969746916026766, 0.2107319123924076, 0.1622364416813637, 0.28060158288480436, -0.063439803074151646, 0.13204411222319912, -0.14061508971700268, -0.030194596873530242, -0.047668476292171608, 0.35056112210748952, -0.023540988780867838, 0.072288945342684999, 0.22082313810741236, -0.12496817293611358, -0.064358286975188708, -0.013274025969702714, -0.050869578842610889, 0.31484013221214319, 0.20874858791385725, -0.036210272775375939, 0.29286942250917875, -0.055371837001574144, 0.087050469357444663, -0.02065619447948399, -0.096645533345867535, -0.39347841741099632, -0.18797010038760911, 0.24319374228475116, -0.044869907450060004, 0.41756713507135262, -0.23188008703851531, 0.16387457028773994, -0.39984373951224284, -0.21945253721038072, -0.11762680997176321, 0.25521039165797443, -0.060133829197581756, 0.16135064378335956, 0.015673141701464617],
                             [-0.11406574128366352, 0.074689226727597313, 0.22356562703795307, 0.32807668482538271, 0.24873838760264264, -0.11431080394984926, 0.048646053387596609, -0.058284010090712927, -0.23025189296816906, 0.20136851716296408, 0.14575307047526689, 0.15823905194603249, 0.15405978308384499, -0.36528600906871916, 0.17525439879149457, -0.076261065516086732, 0.2443887069185689, -0.3026437435413703, -0.062637322961056591, 0.17156094173422429, 0.032343136821036123, -0.097373100304992896, -0.041852193619091857, 0.026482694173164442, -0.052586326429036975, 0.10616491932565611, -0.20728482477060844, 0.16076661599194292, 0.082106403553753121, 0.029935880476774201, -0.16215480797674406, -0.23014006462212969, -0.13954339743747771, -0.054499461332111032, 0.0024063229829058702, 0.12810625914304, -0.40764409184130745, -0.17602477541396061, -0.18658491348989487, 0.30615992376281292, -0.33193357036579552, 0.21901179202143284, 0.13386453668884357, -0.025272803091833551, -0.0081286426074356783, 0.36492381991545375, -0.30897224860494249, 0.23463860720976956, -0.24738570902505549, -0.23401909749206223],
                             [-0.080924348841649965, -0.314938961516598, 0.28996369096898345, -0.073152775812946547, 0.071212379987927815, -0.031890997187764655, 0.11577787157676506, 0.24000682445175944, -0.080938595415366799, 0.21446670311829855, 0.00021139497762268089, 0.25031366148084155, -0.016340935326544154, -0.036012768926462664, 0.064600504169674847, 0.1484125936032043, -0.060619123405685107, -0.16198426779363395, 0.24251443730841221, 0.34099301847251723, 0.18687292082323709, 0.28194750055917484, 0.15285347140346575, 0.12590624580590318, -0.41691207191160273, -0.45017749305637611, -0.1616320188730333, -0.095063267821789504, 0.23039467772054514, -0.061431163555928238, -0.29260225091871434, -0.050345755719379437, 0.11353475867537235, 0.27787038782180246, -0.076639299158767341, 0.18590139371938683, 0.078480660267590499, 0.22934519142816318, 0.34179238510704912, -0.019119106887633314, 0.013666103323350158, -0.074536305180581922, 0.16120593959429694, -0.080638600999613258, 0.27952399955931506, -0.17727256967586624, -0.45541632966417561, 0.076461155352601784, 0.38114115779430019, 0.11016813267012483],
                             [-0.22190636014526161, -0.21251107284910947, -0.16792909778884027, 0.022450578604629838, 0.080640462871958613, 0.021835929925214315, 0.16253091308125639, -0.097097543414308096, -0.099109595593036795, -0.068653526242763441, 0.11227806243965908, 0.1237753413771681, 0.4518666607764068, -0.12214041562158054, -0.058149871992455152, -0.17408362868961022, 0.073367042207511571, -0.27223638891035162, -0.48891802435401271, 0.027412264128676068, 0.13256129431872696, 0.18125576732239171, 0.39462981300093836, -0.50560763161698541, -0.025497468588367468, -0.25778141370419017, 0.10003705814063221, 0.16942360277522367, 0.0059949142220003145, 0.14880833489011272, 0.3278565601454369, 0.022303571372792128, -0.04205686108859439, -0.15327549363401974, 0.012783050908590939, -0.074360144861725111, 0.0079796077816500048, -0.11036087027512714, 0.073254253873365774, 0.097782886917282999, -0.20043407034891686, 0.2107599978420534, 0.040931214018978007, 0.11938402605219739, -0.071097383605778192, -0.070718104058929421, 0.20785200756495212, -0.11437993387731429, 0.28429391131946308, 0.33862842686045458],
                             [0.041985351499435677, 0.2719951723906881, 0.35236398940019803, 0.12337223273749846, -0.15057747163870785, -0.0052234674896362455, 0.11062124724839696, -0.15855566562243426, 0.15925620267449361, 0.060855816434863784, -0.020989031777452156, -0.22922007326369567, -0.055676076785151851, 0.079677264800739292, 0.036046965041093074, -0.33977309236624809, -0.35019193812982585, -0.32041965051643739, 0.0038754953390043503, -0.27726409176735062, 0.073297263406339588, -0.25801533832550033, -0.11922323507248835, 0.20430040154233892, -0.093042125989323321, -0.2016862321227271, -0.073442474499513452, 0.21288977924302932, -0.12914657865514698, -0.067527000200068382, -0.046874021875900194, -0.13867391049186389, -0.037299959485114345, -0.38655919321760385, 0.17190502747284889, 0.05105072978010293, 0.36812954338779319, -0.1141953891777463, 0.11995118506679424, 0.30703812450666124, -0.022778940953139995, -0.19213498734112824, -0.10132847268131218, 0.085335830688335945, -0.36571882290258162, -0.14962047337502873, 0.037215787246964144, 0.24962470333297457, 0.3633137833605356, 0.0080766101106273733],
                             [-0.024297644348592079, 0.12535123846914459, -0.36268200863270317, 0.33016396343862064, 0.1919776214502259, -0.26875953549689918, -0.080214272479589552, 0.091226845024246286, 0.19027763380830864, -0.33662938605747283, -0.043427993069990359, 0.1220977202349298, -0.19503772175863898, 0.23783484826931003, 0.18162562421078826, 0.04510515787068807, -0.17964434823497671, -0.41083811171994739, 0.020917664998555928, 0.0034244211099122212, -0.08433294123361515, 0.35781614993895294, 0.016416293531244405, -0.12470766248592781, 0.27211441131342223, 0.20361976230580256, -0.20175370718657859, 0.48098503242282153, 0.19473674938158092, -0.032368968340801788, 0.057237442050868975, -0.10423192940598616, -0.042439905357818816, 0.25464737480529531, -0.36015782348037145, 0.35069188403305329, 0.21136253512737876, 0.024560108839859027, 0.017630372927105637, 0.098404509672336812, 0.25975405454648964, 0.093454450693076715, -0.46706196589670995, -0.15757779135281688, 0.053317998098705702, 0.26517794434724279, 0.20909556984145888, 0.28145387733899446, 0.02329179325606287, -0.077018302431507993],
                             [-0.46447084723703808, 0.085382396203976432, 0.25712079724945747, -0.0025700577185029253, 0.090167438540127348, -0.10037910828585433, -0.10929955875817837, 0.14830194412639219, -0.068293371808387515, -0.0084250425118013068, -0.24226400360477346, 0.28326819557661526, -0.024161532899338756, 0.031228804852355331, -0.19460568609485188, -0.026510289270055568, 0.020713797940461055, -0.19407957902445186, -0.22946006030573071, -0.038485095705288727, 0.061467082193746927, -0.36057681027935184, -0.21088411546010047, 0.08538608220302113, 0.33003449752140424, -0.23653701334532959, 0.33665996331976711, 0.061198448000735518, -0.12482269254487444, -0.027886247771805876, -0.029835785561724247, 0.18319836453834204, -0.14854939138595322, -0.01617417160388877, -0.33056726031665273, 0.21481382746765654, 0.067817627647665607, -0.040096095987032468, -0.18157322057320213, -0.45033446655932835, -0.0017324696821795537, 0.1471333078903124, 0.12008566048438687, -0.052333469248016212, -0.18177595072264205, -0.24125516885916226, -0.40428494332250714, 0.1648149812019625, -0.022557867421966981, -0.017772167669693216],
                             [-0.00082660908546628407, 0.033319019041348208, -0.23200352492616605, 0.23224176835695234, 0.058003285250243349, 0.022986778593148009, 0.044394671389219799, 0.070293977074670402, 0.00031368252510539582, -0.066591248427624927, 0.031652307421954046, 0.11597779487999474, 0.084675739650333204, -0.058594013241755782, 0.072463278372477014, 0.0015685887335263049, -0.11486588669085138, -0.02683035791131709, -0.20403259700673351, -0.29357977623952752, 0.11963228918117497, -0.13066814254303918, -0.092250488387540824, 0.26222834940349155, -0.094951118478471028, -0.12319887506116049, -0.02508072151331666, -0.28409349484964658, 0.22637272299089542, -0.32935817039572163, -0.39107264752698606, -0.027803648983212685, 0.023697706045615025, 0.058707607559438033, 0.20680722221977768, 0.10954623805137406, -0.03444152447994292, 0.22599748336584963, -0.41248633481541308, -0.22988755598499944, -0.44393525857071631, 0.0062258840979667373, -0.10126471343340801, -0.22584927209516653, 0.40334975759492914, -0.097566634657605206, 0.45334716974480244, 0.031687549870594328, 0.10001156018143495, 0.35251117798490089],
                             [0.028531757210827027, -0.12092620438740309, 0.3460051658761113, -0.13412886949968286, -0.2387812656257661, 0.41933053782368968, -0.026723531089561662, -0.03759920801886095, 0.21339506306791553, 0.28156669857409661, -0.11782471035186828, -0.049740090709674938, 0.026402764730215925, -0.27544220576461365, 0.094525822802398171, -0.30671272139933464, 0.070404934983300457, 0.071062799191907194, 0.020471801633059263, 0.27219479708574817, 0.058628147839210054, -0.11212232202760596, -0.27661241607636844, -0.32555973430875695, -0.18008133428845619, 0.030191041833795458, 0.10375597976993889, 0.47331251604394031, 0.20953867364462089, 0.033570322540915597, 0.11217611702573599, -0.0039668016444541444, -0.47589489002568314, -0.10601851762940299, 0.088800119773319294, -0.090514961074113873, 0.046595398408267201, 0.20333431040176642, -0.055406324444787027, -0.19579576375436458, 0.0917578161579677, -0.13797373207795335, 0.20198328130337256, -0.0023803723264742413, 0.28181666328545052, 0.22127749596164217, 0.049381681201056037, 0.20847302989231262, -0.22113413790488146, 0.18490873410729847],
                             [0.13144697369852903, -0.070339042673792873, 0.02669504277660778, 0.2221195281219181, 0.19713762335594975, -0.18926511581556962, 0.066063918877797487, 0.0075636083696523637, 0.049763559575701208, 0.054243973511341297, 0.11263897486043431, -0.087137628935277406, -0.18725638388601459, 0.16749208148636621, -0.22962917851093573, -0.39603996323312157, -0.010604435113423308, 0.069167595509511806, 0.14330356813546238, 0.24874521073683864, -0.41192617377852903, 0.45318490736797468, 0.22506807153567643, 0.38437534151762331, -0.18858574553550486, -0.022513355314625116, 0.11598564770861715, 0.32659253460839355, -0.13712542339460504, -0.18703596653060775, 0.25830328980384759, 0.088396937237893825, 0.072295976214316937, -0.031794028702848941, -0.076411867315394191, -0.16653125437722222, -0.24627854992523679, 0.14225071553582821, -0.40663625532915026, -0.022625128974905796, -0.013089861369912675, 0.026572702408322508, 0.15183306440991889, -0.010545265480755621, -0.0033010592446014852, -0.42705704219720347, 0.24337905349099409, 0.33435843226284218, -0.19093508200497306, -0.060323388576078087],
                             [0.1345262744357455, 0.18985321276068215, 0.06707511831209885, -0.43433500669916125, 0.12540263119862741, 0.13083507565579858, 0.069732966893008258, 0.11338433586355391, -0.07914557132789253, -0.00026065751789942047, 0.29615125704315354, -0.17835428741674364, 0.20218334836638754, 0.11576232436434734, -0.11566917776750883, 0.16625359815592383, 0.28329851959751368, 0.10859061734868709, 0.10250087995146059, 0.058477661894861269, 0.38278898674419709, 0.15486306609332207, -0.053068914475095277, 0.157219422345868, 0.20485903042365813, 0.0063518549093630056, -0.17097911295211321, -0.0037575113379340261, -0.079453159880535362, -0.15307202633701, 0.3268803535213774, -0.17682004264386339, -0.028871112537138609, -0.045627069745904393, 0.39189079563519025, 0.22675565150311761, 0.31265550361652256, 0.17000192865901168, -0.20891755236344839, 0.14145084377203823, 0.025841431396970344, 0.32013545355496986, 0.16680799002589661, -0.45726712941004444, -0.0039894962032273554, -0.073561196057311595, 0.12361279021290872, 0.41353622189628042, -0.10378392102453887, -0.03789683581497847],
                             [0.45208892700895226, 0.17918076218027418, 0.2365458473546595, -0.30035322510216622, 0.17981340687437378, 0.23372156526520813, 0.075247559355159088, -0.018663876335751936, -0.01767219965094223, 0.10997560794034036, 0.16528816260379711, -0.11925863394990846, 0.24907143898462697, 0.15487310900459664, -0.29794847232332361, 0.04020709155392576, -0.49693689948076913, -0.3807279261684362, 0.23682478937077417, -0.34156125552370131, -0.31973470323849729, 0.12750010542897128, 0.32457089058263255, 0.25152419195092446, 0.097213299866817704, -0.15170820122855111, 0.11561921484579019, 0.017715081698389881, 0.24201328164261374, 0.0013020215857289102, 0.090126355493631904, 0.019838448065721992, -0.11231737518813004, 0.065572797887007206, 0.16202571326442966, -0.16230674780216967, -0.19995086462348757, -0.046707314389814764, -0.20376977097230381, -0.19737224040827761, -0.071420327718837065, 0.045626221387776542, -0.039595447627447267, 0.15983152621349997, 0.11313750063061928, 0.46408541973678885, -0.20324079768390924, 0.16111131495032197, -0.01547270541983603, -0.074273556601022542],
                             [0.07451634378858614, 0.072802441387068567, -0.075891511202458184, 0.19113609903016168, 0.21664336769349998, 0.14177911961895356, 0.098523815498495509, -0.20936199231985822, -0.32074393296855164, -0.15020350393003684, 0.10245649121592955, -0.54947211903628079, -0.27518202202250924, 0.096840781456186367, -0.15433841912371998, 0.022523586607522367, 0.28641356928377643, 0.026329989065740772, -0.28502132319628165, 0.045601751550247004, -0.053329919988766739, 0.16549311036101394, 0.1270749441977703, 0.15244207214884231, 0.084438420070239772, 0.008849615466420345, -0.17864226281508019, -0.10112636619722803, -0.27348385681966414, 0.54402054436529224, -0.304696174428358, 0.10944312585223903, -0.49119920269027728, 0.27197626734863362, -0.11249287223475887, -0.14825559779523903, -0.1556961199439493, 0.32818329448124972, 0.043159085092552563, 0.12372355391337131, 0.21426602915418569, -0.14093311248267387, -0.16418492067345636, -0.045128259348606821, 0.31610983675953991, -0.1070235086699398, -0.26777584416044303, 0.025216191538788364, 0.14081072496755048, 0.18342203646102956],
                             [-0.27958057930658353, 0.10976325883225257, -0.058697511798115734, 0.10769823425866576, -0.20194170885036461, 0.088557763389252836, -0.41841731987987874, 0.12261467852886357, -0.11253828803660415, -0.26455629471311437, 0.37676098585373263, -0.007236323524599555, 0.15320518153003931, -0.43694880903672323, -0.028735762355725482, 0.057005096415271864, -0.19630767416654363, -0.1696004940478279, 0.31967594491141316, -0.12274687333855744, 0.15607189823953624, 0.18728370847373182, 0.01176977831480017, 0.32533992211663676, 0.031513121768349153, 0.1338592765834774, -0.1333406684915236, 0.22184075653782093, 0.13374330292907269, -0.0083547821611514722, -0.1185945083783172, 0.59247118302548651, 0.010552864665579725, -0.20069680700846959, 0.0031221372070683769, -0.19518023615103872, 0.11190003937007861, 0.22750066519329065, -0.042413733614755915, 0.047755338178073599, 0.015242183937012094, 0.036458972481751645, -0.0038762539020161593, -0.067359550976551691, -0.19067190406130863, 0.057708872220364867, -0.18351445601639488, -0.024252782005625632, -0.075794369837107842, -0.0021339585035188013],
                             [0.070054818556523721, -0.1349366949587737, 0.14441960788677122, 0.39834051911379514, -0.36316716923832315, -0.055959113299364927, 0.1778323955430462, 0.094294175916630418, 0.14501586536494271, -0.074651976237940371, -0.066942325518617396, 0.13991285128909084, -0.047704157746407176, -0.19116012042515532, 0.051385299736179023, 0.26579463975151441, -0.14411036613925154, 0.10288324853457223, 0.13988136949334185, -0.0081715684305200802, 0.0044408332017781479, 0.21219908921245423, -0.007665490453916954, 0.060142044346274043, 0.54980132531968395, -0.16229546833867176, 0.021700313425356652, 0.03424209974270552, -0.20880610118335846, 0.14693402509715731, 0.079269893030422464, -0.10319041019741884, 0.027142840368365836, -0.09326330891943288, 0.26798360325112247, -0.2987748783485985, 0.0032920202970602927, -0.36487619795482129, -0.069872238208428, -0.11037498977726112, 0.075463213983623947, -0.086242474846480136, -0.053784954149624184, 0.05860846050712535, 0.45868304238499907, -0.038330900155816229, 0.013803831838056474, -0.022601305722575286, -0.065236160840446755, -0.16579355222067393],
                             [0.23043496113828968, -0.24285131519417638, 0.23231165744039406, 0.19728028196098354, 0.051163648295385299, 0.10206606437164908, 0.23243487728770762, -0.10990596999567767, 0.23397907275210411, 0.14286394310361383, 0.27345651688594053, -0.23526432667190531, -0.25731363673688112, 0.034195386005088008, 0.26541369515453483, 0.20562668230444303, 0.15168302409409418, 0.045429559484277002, -0.30361910608520187, -0.14444200283145975, -0.1110191129571907, -0.080956803482446077, 0.09604913092972274, -0.19002664941925834, 0.18021284618242622, -0.10426322207838608, -0.23520030348268087, -0.015618397416370076, 0.36239204972623251, 0.21472075361794224, 0.1759682746031648, 0.37260545068270212, 0.37021722499958859, -0.11895630853030512, -0.06759542599476516, 0.35036990915679789, 0.057955303392660681, 0.084887273867813196, -0.27011385269679383, -0.023959794171405327, -0.1162561334277931, -0.15825192560206894, 0.16132635327423708, -0.18447242785191151, -0.081143836514644865, 0.037975996211823508, -0.24643864834234858, -0.18966888494097522, -0.32706105441728484, 0.27486430935375805],
                             [0.05786821057135845, 0.087933365445935802, 0.15316913646730884, 0.037785228078832951, 0.2456365848426745, -0.028248404999541558, -0.032029796361373854, -0.56072265934556165, 0.18196286385498994, -0.097501999552009597, -0.38219177710004959, -0.12718448685760336, -0.18641286585793027, -0.27848346057577511, -0.068139797396353743, 0.11462075021904261, -0.24319803298650472, 0.018123323508087111, 0.4562582121793527, -0.068210472384240356, 0.11739626099518641, -0.013837092347002658, -0.10808350522877679, 0.076819003843623751, 0.0083913947837176081, 0.03497689964026577, 0.18726602389777519, 0.10619002040317888, -0.24872865649714687, 0.36062613184209164, -0.20458375129384712, 0.080041302732518707, 0.54132952459208927, 0.060989508956926661, 0.02544002079957387, 0.055223261341597329, -0.1295758920409909, -0.04467657263125898, -0.23344140887630205, -0.014868622863306521, 0.27869872431722259, 0.33952575944192237, 0.25504666825224892, 0.064484815888319821, 0.20132932073361329, 0.1034879269584382, 0.068519638012600512, 0.045333541460135518, 0.0040147474075833203, 0.36005471067086708],
                             [0.32023605487948997, 0.08715529808471062, 0.11650540789956357, 0.1069755652507456, 0.0043945779436703608, -0.072912721140354242, -0.2113817357023661, 0.40287640578113998, -0.0069144984504763973, 0.10503602919663277, -0.099677072009913131, 0.17525649477999192, -0.091707055292167827, 0.25411968097404553, -0.18842129052134882, 0.093365193026821933, -0.35331972072193429, 0.045797896126416104, -0.25897357556472977, 0.17316033005696921, 0.1626103088816723, -0.01120777124134938, 0.23971873635464266, 0.085646812599238759, -0.22884610745531686, 0.12700400825217367, 0.24266350855104432, -0.0071322904714868456, -0.0022684496062010881, 0.28027918123723539, -0.15227255747640026, -0.13551741775508458, 0.11176894613834726, -0.34889622958232946, -0.08150617785109035, -0.16505094813634355, 0.41869618458254765, 0.2198854488243866, -0.36476284181176444, 0.2712532655029059, -0.025610661685474878, 0.37172525213384938, 0.22665390504724131, 0.0054277584193040736, 0.11290331380196966, 0.16141402856910153, 0.087067328172698022, -0.18350155063802323, 0.00093469248017920975, -0.15195540434701299],
                             [-0.3354241899247179, -0.1880437968908375, 0.1696573640060369, 0.0028464907709827431, -0.012729407464302067, 0.30643042264802284, -0.041642385276834358, -0.1123756842928508, -0.12859004191693141, -0.21184901523207078, -0.029990278463181419, 0.049290881709121229, -0.18187903676129183, 0.072581146345474065, -0.15608160510633221, -0.013755802202557649, -0.013746887794841484, 0.45640283198254816, -0.003185744742756888, -0.10242876778297796, 0.12945208764956379, -0.1000314533794855, 0.2474059701630785, -0.074211390925738724, 0.16540407723760775, 0.18954198905006742, -0.014157434139825759, 0.2637416446853913, 0.55679535509722433, 0.12881953790717496, -0.14724955958378641, -0.16141069544744316, 0.13641814590129314, 0.13055361915150943, -0.15766962722173142, -0.25010622830471085, -0.10791488538056568, -0.33606057236570858, -0.16488657404745294, 0.2553472124854112, 0.041143953254110868, -0.04784367332280888, -0.14369571113190532, -0.048586872615318577, -0.14822289315445189, -0.25585050669468323, 0.035422632418536465, 0.22671595939670874, 0.20000403345039974, 0.11691883356389293],
                             [-0.30544704163926206, 0.16778937294924728, 0.27376957961136866, -0.31870007719353893, 0.40734054994415148, -0.204223986181675, -0.23906218533535403, -0.08773306872560141, 0.26523545191486286, -0.25006544233806549, 0.17626342011207441, 0.066509708512928103, -0.10547356973435464, 6.0285786032975019e-05, 0.11479965603470707, -0.15724234166669712, 0.10883354767493428, 0.081284267120995068, 0.076993927150323688, 0.23289528084980121, -0.18481841485595166, -0.2635490627379955, 0.21201441953101144, 0.0928803791758121, 0.13550579216184477, 0.037315617988707556, -0.04265570588262263, -0.053805430775291423, 0.20529532519992943, 0.39420282325905343, 0.054276507889134351, -0.26838378476100161, -0.0089135800845852528, -0.34623258218700159, 0.32157564553607138, -0.093125896644729089, 0.023339830704475876, -0.017549839239852302, 0.030587751242797445, -0.04290196327812814, 0.15183478542984141, -0.29497784868328797, -0.19323827619231743, -0.25509352600142443, 0.27722803909697169, 0.0190686349123129, 0.18944147864209598, -0.44362337924123241, -0.0036362890526734012, 0.048774547199402205],
                             [0.24548794538651719, -0.26928169744631381, -0.16053750059748043, 0.0034884272025145716, 0.30028768552225515, 0.069023319124703816, 0.010852853582135155, -0.27534584726305367, 0.17381612060137924, -0.12591390184789497, -0.020817686406522443, -0.14250037293465717, -0.12592893001529892, -0.15564269986012155, 0.14601128016027892, -0.14289320492119351, -0.04830246422150121, -0.085888013472299213, 0.13300517788724847, 0.031313242402782333, -0.083566151062290733, -0.15080596821976663, 0.20285906208040799, -0.070145526783249423, 0.28759808518071028, -0.12213668659625226, -0.18916154079520126, 0.22703928171968626, 0.049253322965372437, -0.16757942296785167, -0.49880869749471346, -0.0028966179878042835, -0.2414799360086792, -0.016174119749259891, -0.18006608821314427, -0.50345178543743496, 0.12560692752796893, 0.065857423260471587, 0.078386210408998985, -0.16655675012811849, 0.12497978471441848, 0.54541683673011787, 0.16935135066629597, -0.31391948933381048, -0.12299329102929379, -0.090189670900420293, -0.088015413835931366, -0.087229072883758835, 0.03381464478275268, -0.25407088130917177],
                             [-0.062524961863110365, 0.10311254140677942, -0.033431860602402413, 0.11928989936499301, 0.054337869193719468, -0.27549298451094101, 0.022784809753605511, -0.047444164426299812, -0.053218617478706404, -0.035373511038569325, 0.17702343450891905, -0.38003995714856742, -0.067044744428025646, -0.10475445742870593, 0.17452446660061968, 0.20705710978938799, -0.20838650930882119, 0.25615999717242754, -0.0043297175564111119, 0.072278763672000076, 0.27742361196939708, -0.14978522286090967, 0.24503216039828987, 0.0058957716788176507, -0.17742788158740641, -0.24814616290249725, 0.68411913739315244, 0.23343785091768843, 0.12838110240113282, -0.24247689130541117, 0.0055988609427806771, -0.20391192674280573, -0.054192904850126233, 0.28828115731186132, 0.084684013351633794, 0.20069576139160081, -0.059768702057781287, 0.048762693759087955, 0.14868451605829225, 0.011428465964386547, 0.10559718798547121, -0.27645670517886051, 0.21722852030701753, -0.32193558018840968, -0.034841962902938277, 0.12037110028653578, 0.06902403555420196, -0.088351964605316191, -0.095958234680195736, -0.15434805409265356],
                             [-0.32666303302960942, 0.1143025337963338, 0.012267442219217077, 0.020625186199935436, -0.35130034211633798, 0.053437629715390587, 0.3050650492902649, 0.02769303977472401, 0.051581623153297299, 0.053043711896814456, 0.41323369358861595, 0.014601937543434699, -0.27884239225994784, 0.10316654390063158, 0.14389047771075417, -0.18357175971624212, 0.17757732491089723, -0.2900633238391867, -0.15775473831880801, 0.0015971619316302106, 0.02933918246673534, -0.038227617875387976, 0.049541725320967116, 0.13734075423843589, -0.056982450063021016, 0.25153081140431599, 0.16457961612428948, -0.18818650809371915, 0.30663883108063317, 0.19161006100621603, -0.063631446648038006, 0.030798722222914791, 0.0061922716333518753, 0.32212345426897387, 0.4423673054662362, 0.22601536126155203, -0.070234031627016691, 0.012364453513156673, -0.063499194009184953, -0.071294030644507289, 0.36457255868670541, 0.43789450352562853, 0.20091754348276378, 0.22370003022937826, 0.1148817734095632, -0.26033990217567032, 0.17204566521471246, -0.22996981915831022, 0.14110073906472262, -0.23125786852352945],
                             [-0.062425557683869662, 0.14384633207580291, -0.035184215599842306, -0.20823850546138678, -0.053758914871066814, 0.16397940002492942, -0.11493078889974541, -0.26615378855937666, -0.024548257226784012, -0.078778341619494888, -0.34162318865966701, -0.13360496783442574, 0.12971659363265481, -0.23792300308809419, 0.049242104119820343, 0.049251240582451533, -0.014749946195914167, -0.19216769296880692, -0.62976112971971332, 0.38078103340211206, -0.18272989396693839, 0.13891016918080035, -0.057141699899757321, 0.37898900472159497, -0.062949152153971788, -0.054224459433048711, 0.049741630592588855, -0.02862680426513833, 0.10751517548700808, -0.27216298229238428, 0.25516840190711831, -0.0080034427450222101, 0.40246098148627291, 0.28794122205675399, -0.0085751173874999923, -0.17939374586600088, 0.013012490088423298, -0.0043303594664891344, -0.18056984890542865, 0.021341456792379671, 0.13353534955728211, -0.01597954938376811, -0.160193800877518, -0.15343079975507481, 0.2119848506585976, 0.12681428500325309, -0.10502902357683029, -0.12102994382549824, 0.25863581013897602, -0.21011281121577502],
                             [-0.227689486420667, -0.35800541696577765, 0.088854267869746664, 0.14195672865511511, 0.1276776614823637, 0.32558508204649905, -0.43004330995857043, -0.040336260566549008, 0.27904867673402084, 0.14512772560302534, 0.10308167299686932, -0.26627101905604905, 0.14929912935449541, 0.53141844506714842, 0.0094848394469355495, 0.22348268650203612, 0.19277573068642273, -0.030828076695025922, -0.24923794761100723, 0.031453749953107381, -0.043197598906847691, 0.070910740759001098, -0.19358129008781993, 0.22383535157487136, 0.10239613046886592, -0.22795480785906508, 0.13178697070736314, -0.13817503764825353, -0.082401392314049443, -0.078676581744294344, -0.16024846837003637, 0.22029894650319368, 0.049440385036265425, -0.055925948733636981, 0.24900785369929848, 0.16489635474450262, -0.097706969481827569, 0.0037018159340675531, 0.24684217438393966, 0.085258646641853786, -0.19869312894750235, 0.26052131099441361, -0.12782947886496757, 0.016334254339420755, 0.11154740995588307, 0.16256469166852866, 0.4176262453745187, 0.2675082238550211, -0.28657225976205725, -0.077554055019344481],
                             [0.043873957610011671, -0.025434866704678653, 0.11140625064641407, -0.056016513563198686, 0.042423311739418511, -0.010488789250760067, -0.12611159884371648, 0.17051698353149816, 0.010025369553999394, -0.21856119369058208, -0.099168828582792801, -0.2210911486774646, -0.34859670054762182, 0.11137622162742641, -0.12985259918769335, -0.049030613458004246, -0.0062513412849731949, -0.34386785322947611, -0.02373774669750247, -0.024011619499179293, 0.16424004760329719, 0.30933465100229041, -0.038202339854864348, -0.1677631268440759, -0.085201366494233738, 0.37023988925466655, 0.35202937894484032, -0.36671435060551183, -0.073680567660765167, -0.16001453346050981, -0.039018500631403302, -0.070424043520763577, 0.15696952733123298, -0.3689210916180396, 0.24194875658252374, -0.17378275513982649, -0.023155498543909039, -0.30645270551096548, 0.20593993355361087, -0.14751191360797347, -0.16670818227563364, 0.050789895312349301, -0.038528389966847383, -0.25113459297473806, 0.01116735656880014, 0.1235495790344084, -0.11982143523269881, 0.16975216863421086, -0.070457386626234741, 0.23015572778507035],
                             [0.051003985015230638, 0.08011013614210101, 0.32927854662968586, 0.051250190794868339, 0.11313611518304309, 0.028529485264709737, -0.18983677125783019, 0.25700377015030529, 0.14422482870923983, -0.048337021324445097, -0.12305090553060087, -0.013321084947652533, 0.065440046885848813, -0.28545332981057053, -0.10502723167586087, 0.26987086610327565, -0.20487452567425568, -0.13693088441674076, -0.11254196678319071, -0.14679196226935634, 0.046306732985229117, 0.16589799366738367, -0.033612577086203466, -0.19323019392739413, -0.071536047439412567, -0.0081598495883369836, -0.23541492933105601, -0.092110759618265162, -0.12998775320017117, 0.034014372039616603, -0.1576570136492535, -0.31860010673917782, 0.0080522897623887327, 0.35451928039054137, 0.29812409911959148, -0.16864689999815952, -0.15360995211458109, 0.34490517149619704, -0.25804790814901318, -0.21977484435756761, -0.04538694205766685, -0.11480396302039558, -0.14376722939690462, 0.060443865993438317, -0.65114530745377486, 0.0068041552625682372, 0.20818880357867903, -0.15052158589888684, 0.11174239513801021, -0.042135668580047123],
                             [0.09883647062813064, 0.037247044057083914, -0.50225926279283395, -0.12001869986800691, -0.11877173763158402, 0.063207136649146164, 0.045161919137717971, 0.095698018934401413, 0.24268156484162126, 0.055768139304767463, -0.092460600872990073, 0.21135965625451417, 0.066026400431658194, 0.15285832736922511, -0.19412190075882205, 0.19845353267199278, 0.1842460589141855, -0.26739085650036326, -0.0021178831642036742, 0.37442687350393605, -0.047577981869952282, -0.19613681287661783, -0.087947060758058498, -0.10666754358895277, 0.026218416320853526, -0.072166969495660593, 0.27233787251637742, 0.22038099304025446, 0.11476326917217414, 0.080982354694491818, -0.14936649631157367, 0.047167757825260753, 0.076394221061323375, 0.11641326754242536, 0.53467402876401504, 0.050653659957172234, -0.064023696662890123, -0.099070631174290519, -0.22185809591369543, 0.29377877499858995, -0.24129523633091951, -0.082747642973648991, -0.2116767458311721, -0.017334665908453013, -0.12126089074378303, -0.17271280312754311, -0.41230765172339917, 0.02336334862039173, -0.037348887130266961, 0.090355520276735671],
                             [0.27012268601288608, 0.063864824351847232, 0.074685680159820425, 0.20856681686871462, 0.16623589736671326, 0.19744715600908927, -0.11391992698761487, -0.1216955804904552, 0.073127184976523957, -0.10502739016627034, 0.23044491842406295, -0.084911106838026315, 0.34142804933252185, 0.19186608202920138, -0.062689130495040032, 0.0871232830673042, 0.068054461027558508, -0.065613155859130051, -0.027763933904748225, -0.13817766782846128, 0.47709754854753145, 0.056700175577318858, -0.00050941216128528297, -0.027471491215161979, -0.35713468822675754, 0.14524233909282752, 0.063284642904292102, 0.23733207046824689, -0.046232486339171652, -0.23332573241455737, 0.011114214719590863, -0.061570977868116994, 0.019238152150987571, -0.19220016241139534, -0.059405895599178277, 0.1823156673591339, 0.068620040371882074, -0.059774560438767083, -0.12254544764504746, -0.40032089520068237, 0.17709981465923205, 0.078406356378559625, -0.53279766157691077, 0.08394975963646259, 0.1613333748067971, -0.26523831152658933, -0.20964463957192139, -0.194071004708287, -0.15126461155290385, -0.23283656992499588],
                             [0.089952204124928214, 0.14141157196163751, -0.15323224971747992, 0.0058696634736299753, -0.3082436227428747, -0.11344198826595821, -0.15980345105396568, -0.254196243207436, -0.31479920701959146, -0.066958286411130358, 0.071031718321545104, 0.020730008781814514, -0.48215979209236526, 0.020103729069943017, -0.19164748248511335, 0.18805415511262608, 0.29574696271926532, -0.40178870775264475, 0.06294315290013415, 0.088288251266557358, 0.23915919078891196, -0.22313752399416559, 0.29054252921125656, -0.051545415255719484, 0.10258751501094257, -0.33839413600194151, -0.28994825767765847, 0.29064352444962388, -0.055166176597984694, 0.091165089713259567, 0.031201997893266435, -0.13021450775805571, 0.23555666410998644, 0.071681285320907603, -0.19657022555410397, -0.15438043722819067, -0.058500830825024421, 0.057233755163035652, 0.16674330959566042, -0.26672755025515876, -0.25668901062565386, -0.019923387372143504, 0.062805364475701897, 0.1421762906957961, 0.066415019754887714, -0.024630619706459501, 0.17574982645253426, 0.088343839002201274, -0.12513197235203372, -0.019863404697352909],
                             [0.024779967013090539, 0.12665719868593064, 0.19180066136038443, -0.082400701054423625, -0.050207855410899921, -0.21399250953775834, -0.17100033653846919, 0.17463326268729312, -0.045970214055737056, 0.37059041906899465, -0.1953896070521785, -0.15123738280354865, -0.073590524320488404, -0.15939743973886999, -0.20133971589648159, -0.065028239254724854, 0.2950062490664076, 0.02298950387061266, 0.10948712042293279, -0.38661518442939713, 0.061177184764958349, 0.32882574572622553, -0.047608805762746023, -0.012838599592127849, 0.071528555702396232, -0.22083287280916208, 0.1761482021992101, 0.03568632010839367, 0.28780569315859933, -0.21865122481976579, 0.04300395951736756, 0.13760930338557542, 0.00085487458443064997, 0.18723779556959083, 0.044533198519866583, -0.0090292736358918504, 0.23193510122664884, -0.07628372362329959, 0.024679331941119088, 0.31664928121290009, -0.15700105877826204, 0.19257627883452716, -0.32869733377678567, 0.055750906103098921, 0.17506978405865245, -0.21080475709077448, 0.2060676517204276, -0.26928091932632175, -0.30471738850716251, 0.020755629575630798],
                             [-0.13508334434797661, 0.10338444274056072, 0.1171269273797141, -0.075682238544204486, 0.14444487428384051, -0.073633343455395781, 0.33369865327015918, 0.017394071259095589, 0.12018622812422042, -0.030297801876405364, -0.06680244274903796, -0.025040384696083981, 0.17307279855663651, -0.14099508868115823, -0.018228290820384421, 0.21701732047279243, -0.20026939751552883, -0.025085342969316637, -0.17015226223333085, 0.15385523019658603, 0.17655433956161312, -0.24054062546903093, 0.19320603910568784, 0.13533024076596234, 0.18890011065122386, 0.47556762262412844, -0.008160726020060953, -0.053143495386782882, 0.13323549621762185, 0.17117154553132879, 0.071934915807697758, 0.14197734472863957, 0.035735770521368379, 0.074259507050511459, 0.13724426396451422, -0.29585707869873207, 0.24287724691652146, 0.21502948000311978, 0.34217079715524068, -0.11324454954536851, -0.19102134146126809, -0.045325757776322875, 0.025084830812870152, 0.17631428988601588, 0.093426132548058163, -0.33833146387633861, 0.083047561412675261, 0.44518448410169215, -0.47541784815697014, -0.006792063447913433],
                             [-0.13584598905366213, -0.42121991258724956, -0.061259842040230897, 0.0753317325354044, 0.11369130117554101, -0.17989746486971142, -0.093281646499021598, -0.0084500829227744621, -0.47906490522343037, 0.18535232077983629, 0.13041817660604749, 0.16594449251241469, -0.13889389630207583, 0.18290189081975108, -0.0064537488075540952, 0.030962645492636269, -0.28684138110308571, -0.2451166430153649, -0.072665641627182781, -0.11653350401049124, 0.053249919109409689, -0.17236780621388176, -0.015808344536737767, 0.0098399828125067083, -0.14473652178949969, 0.28193447236550889, -0.19275952904813065, 0.20634144878617869, -0.40214436527054453, -0.14783358191768997, 0.055305836624494009, 0.072019582886593464, 0.00027201696071674046, 0.29980481225512018, 0.20041007840295999, -0.18989753882630578, 0.2409439824531118, -0.30398198737723964, -0.23393811920035942, -0.069415930134298837, 0.16062557094660937, -0.037572183795607089, -0.25640287201464557, -0.18093816484597167, 0.062368428339090745, 0.1129753445345113, 0.10085040922445949, -0.098247199306039798, -0.22017098068496097, 0.23395498259714065],
                             [-0.09935310456533987, -0.1282332340225685, -0.061711361221102733, 0.078136371850202557, -0.042088583376205281, -0.094976135230152567, 0.082099644283848416, -0.42179530686216032, 0.058933251387710002, 0.077079957328239204, 0.09324024041674768, 0.15127746626706204, 0.13904557029859171, -0.24168038300783187, -0.59239037580069587, 0.31328864850120586, 0.026565962661079568, 0.074624544495569892, -0.13987874853455229, -0.20003828072263211, -0.34159593706875413, 0.13836275381948226, -0.24877602719305628, -0.12680752881320331, -0.38169044183850637, 0.16105445221247175, -0.07408804797390775, -0.05520961383106316, 0.060588497488786711, 0.22900858683078049, 0.11136294256766427, 0.0076831865925667212, -0.20215006406003713, -0.023676367598805481, 0.029420883205767016, 0.23005451051561188, -0.029194591230678045, -0.072434160006046064, 0.29981832106242184, 0.032932644538354108, 0.1902569816919332, -0.16124404589644348, 0.1868877035160191, -0.51942140102894785, 0.0031924920046391813, 0.042655693750604816, 0.046668610118639764, 0.086872257440085018, 0.044780239135033359, -0.25451913371397922],
                             [0.095414947871917233, -0.15615702563200651, 0.067228987408080407, 0.0081669315568263789, -0.0092197371995525936, -0.033211595104557443, 0.17072787197076075, -0.50101208590829827, -0.14279573112768479, -0.063911261852449414, 0.36667873320624483, 0.16530826231356457, 0.0054970266198482607, 0.22141694152264907, 0.097419825805441868, 0.031031432067906043, 0.09703610926411757, 0.0034428382831900167, -0.051804669861587133, 0.15743115443169689, 0.1248856824666148, 0.15789046171288254, -0.32711222636036597, -0.23672764858166359, 0.1521499619841489, -0.23432790956489222, 0.35740584652932283, -0.36934233574806274, 0.10510821629115365, 0.18077534026186456, -0.11237166483313894, 0.13010260345961011, -0.037276777644462106, 0.02036515614868414, -0.027575843687724776, -0.41407580572261932, 0.15276143383767793, 0.1439898644486774, -0.25787115963777502, -0.042071985247267601, -0.082111032116572391, -0.1391433025473153, -0.36239195813437231, -0.012892331600843434, -0.16963758567885398, 0.20618629695284652, -0.011388386686325132, 0.2550675052097936, -0.17488215364677775, -0.22991437750772736],
                             [0.10152420541438441, -0.08880810643486213, 0.14951154486528037, -0.23339347423288914, -0.28005408422484573, -0.44668229669183801, -0.52978801969564693, -0.1993047322435092, 0.18767414579545519, 0.33474416905410842, 0.044121886629684345, -0.20575178786956472, 0.18866361964168735, -0.13599492861776907, 0.32593102367717991, 0.036560453397601077, -0.12972329401131993, -0.059293973109589102, 0.10935942907520511, 0.17108845973368436, -0.12828940221392332, -0.059523588583690834, 0.11727236683335233, -0.034591032835919799, 0.085434622078905925, 0.25790717743498193, 0.071232630080311471, -0.14165128570857816, -0.037572581441516609, 0.17910374215908437, 0.12544347129933553, -0.1587785195517453, -0.22861899738796243, 0.09249401365142812, -0.29790421635249942, 0.15956297038406178, 0.00010187716303382971, -0.34753359698497704, -0.20272619624938057, -0.18969100423394569, -0.3062086147954709, 0.076861760375600399, -0.030028261332694022, -0.0087698818134607712, -0.047666484355235135, -0.12269651399330153, -0.069249782271726429, 0.0040784267946572111, 0.35879234353255501, 0.14313270603518644]],
                            [[-0.21123820330861848, -0.39592484172058995, 0.15103359499282881, -0.14279039210244962, -0.094698139809873544, 0.47713837923952485, 0.209748380188231, 0.25115611573154673, 0.22197985670495765, -0.20528905591249993, 0.016483998893925871, 0.047587932621615654, -0.20079079649880296, -0.43920041414503302, -0.20358897023934969, 0.057838928357137179, -0.027850811396178281, -0.27588760059349204, 0.23780740803642536, 0.12981365908382803, -0.093649274024371135, 0.32184731281447093, -0.040783213750721165, -0.13901983478098612, -0.018452898082501196, 0.37298235803370139, 0.035916534277241619, -0.25025704393196352, 0.24402364656908831, -0.1652087170508669, -0.095883049546422794, 0.00070155884370219981, -0.12518431369699862, 0.0058345958085648016, -0.15466335344308521, -0.27498605075847099, -0.33003986113757888, 0.15456742720031172, 0.0097498771741732215, -0.1264783576304753, 0.066294870718628759, -0.18738321424852358, -0.35439081026146757, 0.41673598076396834, -0.33223388852198349, 0.010401067221752484, -0.16506844519802599, 0.0033137815254794907, 0.26395254156281373, -0.17353190006261876],
                             [0.092196225009442592, 0.087591669066253347, -0.17897460019906486, 0.05505220063445878, -0.13836663552299766, -0.11652410262864996, -0.093361230897094943, 0.025575959338669074, 0.020061125941061186, -0.15275909491926706, 0.11194999112936378, 0.1428965330955464, -0.20035052050024815, -0.058432689326301232, 0.11061467972526148, -0.17869092715137114, 0.26975842822262475, -0.39814527126866073, 0.014758465106301685, 0.011156975196917274, -0.19716460047668954, 0.19876095241102595, -0.49227727344740191, -0.053970229228718171, -0.055260464566267445, -0.11194023205561211, 0.16063602402818089, 0.28347457032021506, 0.22775022560250557, -0.016704301626509419, -0.014341665010350235, 0.005091626711865839, 0.011881479382039095, -0.49051488938324944, 0.30527201034409324, -0.37118331957185347, 0.019488802249230497, 0.087052491077251271, 0.22801704799226269, 0.27632089912346919, -0.12405298083517868, -0.0089626222489961743, -0.20025218293465832, -0.37048969000299237, 0.29096342712651141, -0.15342918194109981, 0.35511497087159605, 0.28424143676078728, -0.0062400180204756281, 0.016901039994262308],
                             [-0.073317242490032672, -0.21746190804005447, 0.075892142591843556, -0.034588481248153821, -0.10671872791367515, -0.074490814517766527, -0.31011656351256511, 0.062964393261169843, 0.0017283238847461517, 0.30537925898639617, -0.034059740385740764, -0.090760176899783662, 0.048003159007793589, -0.0030632424619432622, -0.020214095274352074, -0.30998346307973351, 0.30080568257114171, 0.15652223093134862, 0.066136491036065032, -0.24436204930223115, -0.12729412544022128, 0.071751564628302386, -0.51683232812697266, -0.028965506122628486, -0.088962465258175166, 0.27008209923958693, 0.15700459769520675, -0.35890528290356544, 0.23886779984694073, 0.042195824298133039, -0.35742744356232165, 0.068254324137318953, 0.19781752707140915, 0.084407694218277152, 0.095125031863378368, 0.32649601888865692, -0.36847872798609438, -0.22428018980613021, 0.071381411469602363, -0.27678701740312434, 0.05224867394076696, -0.096722783371764168, -0.12997853988904995, -0.17264960703732019, -0.12813012576482177, 0.15103727446071624, 0.055199430058313084, 0.1876579723184498, -0.079295555374386539, 0.25455075212072986],
                             [-0.24388673972099159, 0.26714082386166726, 0.10620500133972387, 0.18294852743267076, 0.25179895315977702, -0.052312135625445892, 0.44696184944171097, -0.17743382318032275, 0.14127123916492759, 0.35676296825055964, 0.22035720962368174, -0.12540951463188207, 0.1867393296019953, -0.1153550053064178, 0.28427027509723662, 0.27408556346407004, 0.056405481142210022, -0.079680706703860155, 0.038402201109236984, 0.17370950440349384, -0.41412441035051795, 0.10944551186660094, 0.22528408988043644, -0.084306539265539854, 0.14612686555745988, 0.038206269371447776, 0.32132298466786025, 0.17460912994291114, -0.27666133546870025, 0.035225555860656094, -0.24090181141237776, -0.34802199801056616, 0.31728802833597414, 0.14236199424687077, -0.22406460926577168, -0.023866263252627317, -0.13130472945127994, -0.043278709036992422, -0.31593579985355114, -0.046581331668714053, -0.046291544574807088, 0.011159506370526418, 0.0041484536743483418, 0.070734123778585761, 0.08896649878222615, 0.46662428948167567, 0.43608879674828266, -0.063285776496438226, -0.11791491263011099, -0.0078797241771830992],
                             [-0.028904153194870653, 0.14510319275409342, 0.013365060983893909, 0.013384899052481055, -0.13278350831414243, 0.24141213897328098, -0.07414648406517782, -0.15759163469571047, 0.11945665388537877, 0.19123505597835919, -0.0098316065820846545, 0.27907632291295281, -0.19305496493508706, -0.2368930821081825, 0.21583303756866515, 0.21393022077556301, 0.12277982732353505, -0.058494772760156979, -0.21282557123292048, 0.0023397465433174021, -0.077157362001226443, -0.15223842756395803, 0.23642320400857139, -0.36709174708885733, -0.27571476190876332, -0.32701182689422276, -0.028618151759851232, -0.38395987075463905, 0.18138219672870001, -0.060282110633859909, -0.069811919175101045, 0.27346144781849868, -0.074519189402182315, 0.14619515696874866, 0.12699458425140472, 0.28063115163556857, 0.3257104260872597, -0.069207677150697075, -0.33330009038339647, 0.15853206157935951, -0.32630858465515955, -0.18185886930553019, -0.12730741755754058, -0.21023392732603549, 0.1830441014267124, 0.18834627706612492, 0.018762039588307258, 0.20784047746420725, 0.41377600870317016, 0.12899958907476589],
                             [0.075023285957681096, 0.069834112511249324, -0.042242956998297373, -0.090224640095089265, -0.074998734597129177, -0.098788482076094072, -0.30008145421512572, 0.26632658673137422, -0.27590830001954519, -0.25758182975979443, 0.033615931660492662, -0.53643142125450605, 0.33822096359403486, -0.36984175949447956, 0.37801264133642515, -0.073148924158625089, -0.35982230468958332, -0.092367422326175758, 0.069401570156041884, -0.15950991343187843, 0.06048809095839619, 0.25948866937364862, 0.06490868737478464, 0.029850317964574991, -0.043551382986496079, -0.30407141929355475, 0.044432791058979446, -0.13345285117702241, 0.0076855598485559042, -0.006941145395266946, 0.039827546867723516, -0.00074170931597640748, 0.22292736437571442, -0.0050887628585837077, 0.04022265336590395, -0.043336726578521369, -0.0064345147757741711, -0.1539142601816805, -0.1120733904428919, -0.42354387135434496, -0.31780722009479251, 0.21880300283965617, -0.028591878025602195, 0.25850207793953706, 0.25050712118219803, 0.041293619261284019, -0.11119382061306061, 0.272266785593829, 0.42464421846165024, 0.12295859114701423],
                             [-0.11841050812148687, 0.3504106703396454, 0.24831271770280575, -0.26185736761235406, 0.021594982540783892, -0.28627545016202649, -0.0036353577704488944, 0.19807110475157544, -0.13420569773992219, -0.39209746082811203, 0.54275588198384073, 0.027374369159121791, -0.026153608995961947, 0.45088960623723584, -0.12285011730151495, -0.078363466789328373, -0.058944327783991585, 0.15233587952523439, -0.094378376908919093, 0.15170357478087201, -0.18271188859055609, -0.16105291773759367, 0.022742699779099013, 0.080426169529121752, -0.3128891706944682, -0.17558472272012784, -0.1359145512308752, -0.14441902736468254, 0.28753779269989482, -0.24784295182789079, 0.32824513899568536, -0.32681548628531565, -0.035907192353071472, -0.097682915852087493, -0.10706170464046769, -0.081456670909861362, -0.13642823083565264, 0.14861155012678429, -0.03317602004746352, -0.055013943219470555, -0.0067584446492993163, -0.34103310658966618, -0.13364517531329637, -0.095026787802327747, 0.23424781433052988, 0.17478534180928793, -0.20153460940222861, -0.15388595376707509, 0.028139366275289363, 0.14276234636588117],
                             [-0.13227728325665633, 0.048356144889700775, 0.0807287523692512, 0.21073253326429359, -0.37594029925892514, -0.20114283219129553, 0.62605662940647988, -0.066126777397553155, 0.0047532403227889194, 0.17397920168886977, -0.054022431351142569, 0.23821405521631941, -0.084803937112404318, 0.38089870069689941, 0.23444150201489561, -0.1789450280359442, 0.066262378090310825, -0.39748268342325849, -0.015693107920469566, -0.023106910066913414, -0.17175491075581228, 0.054867012012302575, -0.0026504551399887666, -0.0092897407943807984, 0.11875112997933288, -0.25666690168115464, -0.045703914773313974, -0.41517411690510475, 0.028318511495991322, 0.13600453354230685, 0.22345720224113108, 0.15147681016800524, 0.14279527900907307, -0.034206121361050654, -0.028750428509959073, -0.17150300108638838, 0.020303001908353491, 0.11081940863097878, 0.20323741473779927, -0.40119205626171484, -0.15765830383974022, 0.35554597927294246, 0.16515639725958503, -0.18726315892856857, 0.11329264064260139, -0.15208078872320738, 0.0013151516170905597, 0.075649567592040112, -0.115964400283199, -0.17284446753523502],
                             [0.30252040730195168, -0.22899397794979104, -0.3528087273879898, 0.27478150332309648, 0.24555516192461915, 0.10393749534552568, -0.33707173515374123, -0.051612380312104418, 0.13789340198305766, 0.033498102160772716, -0.052474048440006874, 0.2781619576494998, -0.11491356729752573, -0.017135918738923013, 0.14421023143384842, 0.18570232832907291, -0.18897541222849418, -0.29487203711646204, 0.36512635815124034, 0.25375217325069482, -0.34498662679970671, 0.14126718370199048, 0.019923911619180404, 0.26635427720412758, 0.073004550516164959, -0.18759024134780558, 0.027721228273679458, -0.13086590004624624, 0.32353890360136761, -0.33848100657497998, 0.12495279527989729, 0.1418943630940375, -0.048418208259166956, 0.37552435667856421, -0.10192136535563441, -0.10978256247223794, -0.1903396898369682, -0.024569679748162904, -0.25629006563537426, -0.054371002401977703, 0.22777581556443677, 0.17831039023609704, 0.0050077400595519607, -0.16966482086421025, 0.03818197324989895, -0.087398832595690826, 0.046345126515786178, -0.38531106694469963, -0.39869608297309256, -0.010105825913875172],
                             [-0.11227290028225753, 0.24561933186388443, 0.10513119142545849, 0.03181041368464449, 0.16835337894776503, 0.065046075277853263, -0.014371868201143806, 0.051651267010291921, -0.31315394006252517, 0.00061960858390758267, -0.084035749705137525, 0.41627183906280246, 0.14285671112493248, -0.1025279373803005, -0.041019106771498753, -0.13959535691618438, -0.054370386722534733, -0.23256919937024356, 0.24882110848953837, 0.064607857880433689, 0.14332299318243197, -0.01724145841644175, -0.17308247807369159, -0.16790370768126145, -0.15024405704908517, 0.056131090315362286, 0.14590663165557205, -0.20184989221036745, 0.13850169410847032, 0.34333632937669006, -0.023766651056344987, -0.02026976304675851, 0.2415784793230259, 0.36308896538347735, 0.21798204349410139, -0.44564567825146173, 0.44919421881389937, -0.37094434678889432, 0.43108358113432599, -0.081557177272724643, 0.15203629985623621, -0.17212682952987421, -0.010353467238333164, -0.25069820952091576, 0.32383812877920048, 0.31099103352751267, -0.066960338206471223, 0.011832548362055051, -0.13405813802332001, -0.18685866682300575],
                             [0.16899344043583872, -0.082381361644628226, -0.36132710551697989, -0.014265716590916459, 0.077414940873719959, 0.10823818695276799, 0.28375061287514941, -0.14646512572055448, -0.040955938086811861, -0.22089322591118035, 0.43591292362786771, 0.078374450691542336, 0.017218482907619705, -0.062759330086702189, 0.054411639052819372, -0.16589792770389997, 0.096587583477643055, -0.25806302620456356, -0.15486344666658763, 0.21085496490524425, 0.058729171704468869, 0.13236145498660659, 0.23422864242063179, -0.093228703115445663, -0.012239280793682479, 0.10434027162410868, 0.16400779802281826, 0.12119629488652241, -0.2179487859516292, 0.43613817090555723, -0.086641577890933366, 0.24513455098391596, -0.028033645207746455, -0.18865987532686029, 0.0021886845520804818, 0.33462129473533075, 0.23901854629475153, 0.076454138673695701, 0.41052015756681393, -0.36007217706342282, -0.16499259749042564, -0.43711386412081177, -0.14676679604262746, -0.31102990136006547, 0.13556192625915819, -0.066630449011044687, -0.011882024634207053, -0.27818621122622045, 0.1480318808897185, 0.28040955329490647],
                             [-0.44893179106120207, -0.26616004731770293, -0.015630554351064679, 0.17618080273291933, -0.05976333364670925, 0.019654860866983499, 0.022037653623337046, 0.078606499729319962, 0.10236667745434495, -0.25061709544076799, 0.32710201723167648, 0.094490628841400706, 0.082073699125780358, 0.077676935500325617, -0.011099013263149049, 0.061253329599148677, -0.087646944821051884, 0.083548725920076616, 0.098803375410822417, 0.024460289078933373, -0.075296912500133692, -0.07806994616178374, 0.15601600109941413, -0.12615415580466444, 0.35939462707821379, -0.066387515022915941, 0.19064414226164669, 0.35490891734054891, 0.42804952590961048, 0.1031288763103097, -0.028937271718821551, 0.054686327268629688, -0.37686251606026133, 0.2631284207549987, 0.12309476833694434, 0.036602061636776102, 0.10657482472337673, 0.06021948223610607, -0.082452047884466612, -0.08014827833563469, -0.48751404037247348, 0.43997492354656487, 0.13146200816396825, -0.13488134562798418, -0.16820525082983825, 0.17348675283064335, -0.26710376855273288, 0.19822234423034654, -0.16590124457039523, -0.04527983924180163],
                             [-0.46004189143738666, -0.20218482060054679, -0.26712644468894448, 0.064712250001230071, -0.60563325329558204, -0.1662027503709696, -0.18471753262572579, -0.011493249770924661, -0.040146426568537917, 0.26126092591561811, 0.14238260760747989, -0.11817008478710278, -0.014268168664795303, -0.10460605302559041, 0.094544442594186193, 0.62647650552916367, 0.32237479787292733, -0.10521191301379328, -0.23433342329800616, 0.30169064418828717, 0.29227190702204503, -0.25766239511509736, 0.0084984931173495495, 0.057189227604215076, 0.2110900244798547, 0.067616193955255699, 0.018275630089744532, 0.08552825632463941, 0.1608214451039286, -0.12999409738494921, 0.097704721315731352, -0.038745763550771459, 0.37965090147204439, -0.1261711688457495, 0.068999112115650185, 0.20608906331729684, -0.14963502535568524, -0.020605068613818407, 0.23138826376001864, 0.28581951709280201, 0.24992972693130941, -0.028602561161976826, 0.045835736350513218, 0.084810300162581259, 0.038146432343033845, 0.17477460270150261, -0.2111658587250127, -0.22032943547450895, 0.067880894836091971, 0.13827541257554898],
                             [-0.013809794903854811, -0.27580042650038722, 0.086230636204669406, -0.064151027468737201, -0.12648719853971027, -0.2556200365370776, -0.12103870287403699, -0.26728715268831293, 0.25810658906344552, -0.033780129916198796, 0.00036921246895231172, -0.083079924421186099, -0.40312706150489958, -0.01935911673311802, -0.12224554350179322, -0.076481761236159379, -0.33951549716887253, -0.059027896526815102, -0.32920360082744904, 0.40173772337713287, -0.12586303686303302, 0.35184812860223524, 0.14368787233522298, -0.4245328779174517, 0.032332502439288757, 0.13184104411075956, -0.1098723482816284, 0.1463453514616202, -0.10431691605316258, -0.081995520845425274, 0.34641811015112073, -0.10174825852877481, 0.2072650289364906, 0.22078018526073803, 0.14872216304051528, 0.21932027997259898, 0.11078390494696649, -0.44780654501335587, 0.17393207256982418, -0.12009524937141637, 0.057394846607348254, 0.06222421832987781, 0.030505725869919648, 0.12616324759401568, -0.093011444834643464, 0.092418487231205881, 0.14703470184333353, 0.30320433362111854, -0.25283135963130188, -0.19945672614506568],
                             [0.44613184901387537, -0.15404090533677639, 0.018253627477820139, 0.15775788913511923, -0.09757706545663955, 0.22849165668857563, 0.41217174307226068, 0.17896840030227507, -0.30220587414635763, -0.081599604830620343, -0.12647834917411654, -0.09824260055870089, 0.023251816378349929, 0.11385657738291348, -0.33554521447926922, 0.20522230668183847, -0.48421078727580663, 0.064608696628013301, 0.04404264742534162, 0.037431982645219949, -0.14754298602950153, 0.015449481199484571, -0.13098367785525672, -0.23693433650395501, 0.18991102778792895, 0.0597808164484563, 0.017234978181904517, 0.032283196113791206, 0.36939859580612455, -0.098959965657578391, -0.19705351826833162, 0.0083008732054214752, 0.65469059991522127, -0.17564917503144908, -0.085262782691704453, 0.18817973552831291, 0.011893491790609625, 0.15667490730305264, -0.046793020812273461, 0.094303092283940987, 0.10668181044732704, 0.13965323994810314, 0.22807065190488601, -0.40031020676156537, 0.24256325731673034, 0.033255327352786163, 0.054696085387326537, 0.17456801713893111, -0.03223123672453046, 0.035749928319415002],
                             [0.18468533977682444, 0.39533372278523859, 0.2235587242101931, -0.21266784220915619, -0.23853012772213736, 0.25974980942695036, -0.22780739872815708, -0.26914321259105178, 0.40190509980113409, -0.37082015832434245, 0.070768949659518979, -0.048262670112700162, -0.13078571678309941, 0.057260149848504395, 0.22872686465372769, -0.0097529600466941882, -0.2162211164081308, -0.17091714162708602, -0.281637279060301, -0.080194966717065122, -0.29357463919943488, -0.44394410482162378, -0.13231163283145195, 0.25761582670418215, 0.14845517519195961, 0.16508402337405656, 0.15903897703517986, 0.10532312055239489, 0.084461418181381337, 0.043937755398089529, 0.037542907810789228, 0.21677143250993974, -0.036059733915731668, 0.064834867225051135, 0.20320411942681577, -0.044629183145306457, -0.13152932982437132, 0.21319507838601923, 0.28645935386017285, -0.034005812060313702, -0.021467665165251951, -0.006703626464343115, 0.10871601280068782, 0.28486982848172371, 0.048720505924579355, 0.070181062758756185, 0.12351257707614008, -0.087134389708443255, -0.026007284945609228, 0.18888621608735201],
                             [0.51531561368540624, -0.093633486607442362, -0.024239633828313522, 0.044585779806789606, 0.010981321227980895, -0.11960369633708164, 0.18213009075695119, -0.090176419663919163, -0.034832903195960011, -0.037492654558612004, -0.34959529223517455, -0.034451667639664993, 0.14899600489775064, -0.13128245082383913, 0.26875761786764535, -0.10124975010124171, 0.28539439771642561, 0.0039337180763831595, -0.23551100974382053, 0.089207919630015439, -0.2070732531776025, 0.28997849773228312, 0.31326431251496151, 0.098045770555247408, -0.050284850409493743, -0.1978810829826573, -0.26502636121658163, 0.044945192107458044, 0.281194818432419, -0.048385544684173949, -0.28392869609750021, -0.086428422276457736, -0.10144383959712436, 0.086535195457543901, 0.14566780523240352, -0.048503404474347957, 0.22381037364338155, -0.018523369332987018, 0.3131445095327926, 0.16759986603407151, -0.125493486497044, -0.001277548915196991, 0.091978382595188826, -0.018475730089758266, -0.24739176185329551, 0.56179780405283331, -0.06368154673726617, -0.1296660049476264, -0.010117539730507434, -0.091035673831059483],
                             [0.29309751599713618, 0.0024749292638137667, 0.54475585222087475, -0.046633703240675381, 0.078810552882213419, -0.22242052739800205, -0.18904893015753282, 0.03349405149731427, -0.035011792554939455, 0.408158764117379, 0.28473800490821216, 0.0056514791013721373, -0.027137352193627118, -0.31619059485062662, -0.10717885183810394, 0.27894216272458394, 0.18250544918364056, -0.12709388015608053, 0.28498809062992703, -0.15209098932374099, -0.059917281128134728, -0.0048146178523123286, -0.066821489521551425, -0.15353411704455408, 0.24750458764478606, -0.16240046676218287, -0.16737931832087066, -0.012064373033263685, 0.21497096770173449, 0.20546187413779946, 0.10391248619248084, 0.19444473965726736, -0.3723123433851358, -0.14841346769596467, -0.44683885180041355, 0.12993793930531633, -0.042132544757323087, -0.09473129026412283, 0.20490860559546281, 0.031342734464089736, 0.23395243079753117, 0.084759721326574777, 0.24422861726215919, 0.14864009270708062, -0.18102294785108217, 0.057298648766228692, 0.049121393682845668, 0.089785487783322376, -0.039873602784919249, 0.12631571040212428],
                             [-0.15893582613587134, 0.16376930182102303, -0.068944874793016891, -0.13173733300539597, -0.23876278590077585, -0.031509579268264996, -0.22995428233484655, -0.13867298393783917, -0.043899867006191723, -0.2180527961088361, 0.097225611601933104, -0.1498820401226913, -0.17643253647271445, 0.22576002298053205, 0.32575490235124932, 0.31940914806838455, -0.21874840186862232, 0.23203886928608108, -0.0035681707599580642, 0.16889914539086079, -0.043344327742976446, 0.16189404228122628, 0.089316206331978745, -0.20106519537038176, -0.34623228799737593, -0.1071432226403989, -0.14849411175970198, -0.1881318448350203, -0.50277768374092813, 0.19201884912382924, -0.36553796137436251, -0.03350889716182974, -0.12655541248289617, 0.15197748582263032, -0.2950987347803376, 0.2112903605657647, -0.11542976584486289, 0.30191404174231412, 0.47913461822230435, 0.22490358679245681, 0.19702564160113104, 0.22474394937598458, -0.35696219902987469, -0.23354057803151518, -0.067395964671786032, -0.0099665443027954354, -0.021136054542511794, 0.12893935222146072, -0.1239261419020127, -0.11208355333288242],
                             [0.29863990543689933, 0.099288237819911945, -0.15352603632752648, -0.0066057304899070938, -0.10025634653478649, -0.14454209583335928, 0.04439633157659869, 0.23815311666250807, 0.28648084410587921, -0.25527833839190989, 0.14377351717929629, -0.26473356672709075, -0.024894789042946397, 0.017461764145600803, -0.00329332201950692, 0.40976930248973714, 0.40844971525530238, 0.25007875336824087, 0.14958235168607414, 0.20057403972592017, 0.029585829690920079, -0.086020226695911944, -0.17558220811223318, 0.039344107530994141, 0.18659859954479519, 0.17431516406553521, -0.057278144209903244, -0.29733672741786477, -0.0037245715274590828, -0.026869578555742971, 0.16111751057188506, 0.11094250056907096, 0.15535015738045022, 0.22242269352795779, -0.21227091377459439, -0.12231788187864424, 0.69796157210231091, -0.093386927314653492, -0.084953785142037164, -0.26895494850130847, -0.060986264741041699, 0.013892125697544416, -0.21902296579849953, -0.17401958342002333, -0.31869976475856632, -0.019999592041121214, 0.013823980417927035, 0.16588856228453386, -0.1857019487977293, 0.071285538997057904],
                             [0.25339684683066771, -0.14954234769293775, -0.10790762281877829, -0.48693167414521643, 0.042503977064476423, -0.0085993787138288862, 0.11086857045164991, 0.19089963753823957, -0.10373701592118342, 0.079427759125129976, -0.10974031089015722, 0.028447124625761204, -0.16001796075191779, -0.14496469931485512, -0.37978995234299395, -0.27056739891219339, -0.10186022978261343, -0.09491550526943382, 0.054526892250684578, 0.57296353599152583, 0.073260634186331275, -0.11285382462174541, 0.088333932634612825, 0.024035058516542234, 0.25246602032847859, -0.29831979651391399, 0.20936958663841074, -0.17227090358918859, -0.17891501641867541, 0.22641465121639892, 0.028970883917660471, -0.049820747882160642, 0.10717306934586925, 0.17998087975314839, 0.14755139227972006, -0.16024699147323557, -0.19548796369395088, 0.11099806934242558, -0.046267385686234799, -0.042076441604932638, -0.11258075226258404, 0.1843273264749157, -0.10194098524825231, -0.18801070030079475, -0.14424717133492607, 0.2375236424033591, 0.17429532168602169, 0.02716211734536347, 0.25791465664671248, 0.29795642391070931],
                             [-0.26362762127386941, 0.1469705937028023, -0.12567951574740316, 0.31207966500777423, 0.14806934598250893, -0.029658967627648511, -0.029253002331681106, 0.21273912066609307, 0.31322064460254695, -0.0027894796196569066, 0.11610416594142681, 0.41811045271235264, 0.069888568000384399, -0.41087929849545174, -0.2679919482942999, 0.093826678056429011, -0.1802064677129066, 0.13898475124130408, -0.077244674141759687, -0.032845289923885648, -0.27614926178874011, 0.016757049121956198, -0.15408423940815794, 0.14031411147696854, -0.074571444093869163, -0.12072737215265171, -0.29519224263337357, -0.14478454923387868, -0.085297470376839823, 0.43531212823991799, -0.12335674644030789, -0.21814903679128458, 0.13892395266747568, -0.36154344257125304, 0.11295384606017145, 0.08644381328840102, -0.087155548909132824, -0.097026719316359908, 0.018895854514127567, -0.055443899194743851, -0.068398057619006872, 0.30393507847180773, 0.024317267096974612, 0.036696680142722392, -0.12706640611710707, 0.0023879978433565645, -0.39435905182009173, -0.11830325080038299, -0.1858872263529377, 0.33255850045174973],
                             [-0.31122618906860994, 0.10310467012950006, -0.075019868403025394, 0.37574110230635616, -0.014970305004813163, -0.009624645154873681, -0.033287339920795127, -0.4174517350604216, -0.31980164953540496, 0.11277418167251976, 0.27787240250646283, -0.05889845316692665, -0.36390865249759052, -0.25564745531455002, -0.10235479526484398, -0.25953134512441856, -0.31844888165008745, 0.0087485596256943604, -0.19069949696430963, 0.095300989257047483, -0.017406566010984535, 0.09200124578368829, -0.1371666773621957, 0.42768912192439229, 0.1506101541718067, -0.12577227020037784, 0.14067553407357641, -0.084411466618966938, 0.14609360696397516, -0.18068664799357656, -0.30284947878161006, 0.21406597503286193, 0.21486628450425466, -0.29929679324450315, -0.28271178792381779, -0.11500436863420156, 0.32375019106459074, 0.21505470703660612, 0.0070973610509914818, -0.040892253483398311, 0.1418135113790284, -0.25680913861347915, -0.067069411558155267, 0.040567705110911373, -0.38930302803357425, 0.13772873610386496, -0.077307485164595083, 0.095603180656523137, -0.085545506842547761, 0.023151914300365371],
                             [0.30185189582467409, -0.095579900425971975, -0.20804722236573889, 0.47661508266522845, -0.35843772118959488, 0.16156267546891123, 0.1206908550139356, 0.27630782740276355, 0.28779576643011118, 0.41950036886093167, 0.09700264137933709, -0.073124258754692403, 0.48854202047687878, -0.20711097769500067, -0.25347749813185694, -0.27510615292666057, -0.13556265807798695, 0.26979806378475951, -0.02451600591664739, 0.001563793775961957, 0.0083400852409817247, -0.2622571239067214, 0.057421843120326749, -0.26122116173635634, -0.25867868614413336, -0.12648595500696652, 0.10837626230595812, 0.073479479712584159, -0.13830414474254624, -0.081072685845682946, 0.056792226960331524, 0.18251334705749084, 0.00036408412172983171, -0.014619603569231445, -0.10284467409495517, -0.15249725340474882, -0.16458850057621904, 0.15207019595214855, 0.096171229532472896, -0.019338787849807113, 0.16691459956718702, -0.12385663251289612, -0.053183206919444295, -0.16964399701312077, -0.13208485532633418, 0.057216427481908895, -0.074715098346244499, 0.15324979441766412, -0.33444735162006184, -0.12432781991955151],
                             [0.29517551144330567, -0.090484318984751677, 0.060853459520692196, -0.0087774231896075843, -0.13164950733106509, 0.33589517734423546, -0.24141544172330076, 0.078857615421681418, -0.12452800449113512, 0.11438189774435391, 0.15113733044381661, 0.14867768551603164, -0.13845612628062409, 0.16321965127984581, -0.27067887194494239, -0.061825934136596039, 0.11371482175862495, 0.33236008104475523, 0.063847694863042301, 0.14179475534073441, -0.044598419971081077, -0.18904277443897047, 0.40301452162420087, -0.12931631704882687, 0.092130772025937724, 0.05783186694774161, 0.35196437957855775, -0.22715090598521936, 0.038206121478441518, 0.07133822434224682, -0.17590208589108336, -0.41181204072760164, -0.086817577844996774, -0.32704165067986785, 0.19985726436240525, -0.08651003154038972, 0.27629301985926807, -0.036915182844070957, 0.07002169559171012, -0.050048868116084839, -0.1504289722645602, 0.2984454326289116, -0.012159357174184315, 0.44210352615714599, 0.19867470534659165, -0.23669502672166151, 0.2858996839553557, -0.25761502980197321, -0.30302092899169691, -0.30118564085454363],
                             [-0.14684020603229403, 0.1478920816057207, -0.15553297410531775, -0.0088620102287429812, -0.24096509651694317, 0.35583650035049497, -0.11428953191050213, -0.29457950124980059, 0.23085445673312377, -0.0060577072686541561, 0.059048105692788774, 0.13146530537324877, -0.14856382236987209, 0.25561530329492738, -0.37288370456582282, 0.097315004593598986, 0.11254003001205758, 0.25743811070127748, -0.3437305569815674, -0.095698059780789047, 0.27179953353006497, 0.41747963542322031, -0.1041981382443114, 0.098816464018818925, 0.28242787498904548, -0.26059460615573826, 0.21704484655350459, 0.05507906694598385, 0.043522349540643726, 0.0033228459081323632, 0.11100052946009886, -0.31260769743170258, 0.0066852740961262508, 0.18268146149600395, -0.39152486464510411, -0.12601022191161199, -0.092583115988372239, -0.18464118697641285, 0.27409186728492779, -0.056840469444936231, -0.22570437527442092, 0.062925322973018255, 0.054981677716945863, -0.089696634130021463, 0.28083582132294127, 0.098207263724153476, -0.13489676490121874, -0.26498789671211259, 0.27677951506964982, 0.024961534781979121],
                             [-0.040551646561607146, 0.027008542056091156, 0.67097184909052709, 0.44311165174210976, -0.12311065158311343, 0.13107089451529788, -0.17830576588574629, 0.50199843523767917, -0.20091240940907393, -0.041335381269939228, 0.1636096733069638, 0.25241013978748278, -0.025048491490339986, -0.024285753010526597, -0.15566159631743032, -0.14959638693255722, 0.096884330601581414, 0.15864424566125945, -0.27709945643001538, 0.21209284854193228, -0.074924338329758894, 0.26167251864829483, -0.082703138376156921, 0.054661979112869435, 0.19035169040281272, 0.19848940632322623, -0.060950988719497314, 0.048714333398315823, -0.37887003769745148, -0.29645522656460221, -0.075857358619360007, 0.27308991726979898, -0.0017499683711330732, 0.24031190567970506, 0.15450803042442929, -0.17679937882451069, 0.035776521608408864, 0.14269540637954062, 0.045973316533107531, -0.020724538586678956, 0.21955988438593316, 0.019975626921608786, -0.02469371520342796, 0.061533204867122007, 0.035132290306389806, -0.24787994163653093, -0.14779966818108828, -0.070134142670290014, -0.060322489989430919, 0.23325267535700306],
                             [0.072858836612835473, 0.13644583600722629, -0.1779887491778239, -0.18120985814064822, 0.29671658949308183, 0.0051667342624422312, 0.19099599663962136, -0.12895342200340648, 0.19591372112544594, 0.21031907951226508, 0.40938461649496816, -0.35419764783819141, 0.12072903542837155, -0.04265500360122209, 0.16445637577362271, -0.050109325361311872, -0.15914524884268336, -0.073568390499228697, -0.20705657007790088, 0.046223203801596391, 0.33402150361322869, 0.33368929331487324, 0.025178561088362746, -0.036827083694634867, 0.29570623447419941, 0.075025284613631782, -0.063910051256441086, -0.28792695579644739, 0.30831210438949069, 0.0037872017144936661, 0.049390447110600019, -0.049054934511138099, 0.024332232608950902, 0.21797636481524399, 0.30750249176869338, -0.030779008559433749, -0.015628580260390042, 0.47658661373447098, 0.19679742941678677, 0.39492139541756766, 0.11409350367310954, 0.10843573699653791, -0.15264822945610468, 0.11444657590125958, 0.17823636925057684, -0.3247343533058461, 0.074553027779919567, -0.083877044894161354, -0.15678476589030921, 0.24841694303518],
                             [-0.055503498913192124, 0.0072163700435812946, 0.21550921163818687, 0.48879929333940186, 0.2743421447687539, -0.101070471137801, -0.13517463001529872, -0.2649772799817724, -0.088251282303037415, -0.39717221427628652, 0.067069346505758506, 0.1230309906538159, 0.41804501397071914, 0.42906089012352366, -0.091065236495741095, 0.13405825745115826, 0.055067849267305388, -0.20525281633868359, -0.066005423163411278, 0.042398350075624709, 0.21537942786448003, -0.13846120407326556, 0.049296585832804857, -0.30289463633446168, 0.20843609062484614, -0.39156484442833861, -0.098859642382968085, -0.073306347993014734, 0.013015945892028681, 0.12621805706293435, -0.04689595382304429, 0.051988449229419385, 0.24941109896569907, -0.015184859121628107, 0.039440110728604719, -0.1224240517333839, -0.27028529784370131, -0.064985710903246521, 0.20510179688114466, 0.0026903787205959477, -0.034118395301515919, -0.3382419548288938, -0.42670379570563977, 0.13062738222402742, -0.38455317441373238, -0.053769728851516957, 0.48158619511321099, 0.1178511813619738, 0.078250328928028925, 0.034112960074910367],
                             [0.029706351363078715, -0.04543931779626656, 0.16501520207671566, -0.076320209329220443, -0.00063819416723178216, -0.24303785691285087, 0.11833101822880354, -0.21460737159481003, -0.03238367129057082, 0.062443449023429284, -0.030422773052969462, -0.031925039269317411, -0.12357872816019511, -0.33592082596071982, -0.15041907383609301, 0.052360244906339219, -0.067242572657598823, 0.10959931174739407, -0.085707397048230008, -0.050805529193305221, 0.22701107082026423, -0.17553326339186059, 0.23849479336924859, 0.14353124923134952, -0.037629633305204725, 0.3942110045092172, -0.13697456942982181, -0.096888235463620173, 0.027505227859814976, -0.17424927128643319, 0.094074909475616447, 0.3221913638909587, 0.059091357915366363, -0.16315277373617895, -0.24405717315051262, -0.20681660507182448, -0.31333436108162915, -0.0087379768672379964, 0.14926590468812781, -0.024900587176536797, -0.55964608604512955, 0.42032965493533564, -0.36159518079809372, -0.32203375502328868, 0.24701773776037411, 0.16029378844549055, -0.02371551159654316, -0.21986871294925692, -0.20946295989631594, 0.13571853667363806],
                             [0.019809538679030878, 0.11956452606261005, -0.29955836483655029, 0.014677621402735055, 0.056272031341274793, 0.055017500528904612, -0.016098477246395397, 0.087817654840100581, 0.0085076446555077765, 0.33471577858775159, 0.06587704243522742, -0.088808592391545843, -0.36795344759439141, 0.2198718923296625, -0.39653497395280352, -0.22793416616633949, 0.31229147773550298, -0.1051384499704843, 0.18371369390958264, -0.22626662606029679, -0.099690659214664634, -0.21678822931319164, 0.11854832469821411, -0.082852827965500128, -0.22167459425491828, -0.10480738276007817, -0.47469847507627111, 0.39858480210208996, 0.019647582981347507, 0.15463009762713772, -0.35965111089926971, -0.056174889115482636, 0.22371936526663999, 0.29297828161975459, -0.041704385330119192, -0.088016763437127221, 0.014205602187566484, 0.011777892223027985, 0.1996164841457361, -0.20106082694870012, 0.14559931243242091, 0.0054443881427331219, -0.37133616754040294, 0.32497842397794974, 0.12718375279343372, -0.12114065031055911, 0.025853776408856683, 0.082311771129226372, 0.13511422141355234, 0.23256012991090672],
                             [-0.20705368396683316, -0.078081534843317951, 0.22937324932771203, -0.029681574150630261, 0.11755729376676001, 0.039573097537670909, -0.27182163923351466, -0.18409315940772888, -0.1017140572297954, 0.21704065499074865, -0.2551307487585624, -0.19396898058262238, 0.045845576651492637, 0.17013314733096457, -0.13896056445681745, -0.064062607741501562, 0.014459050533159131, -0.19605669806133613, 0.056187992505332546, -0.32998253698936481, -0.40204075124592198, -0.025902809523072803, -0.068169325479924589, -0.16912108150682992, 0.63694893068121028, -0.032416431108712916, 0.11136423388099767, 0.091546386838391433, -0.060959709155500322, 0.018971523696222629, 0.29623883676121049, -0.1537778712560926, 0.04358023039382683, -0.35315770059273177, 0.06490037189147764, -0.054053414745220921, 0.20684328501814575, 0.11142264237791789, -0.15261299177430399, 0.036406671085706825, 0.11998899775187646, -0.18662119547259179, -0.50064994974960908, -0.19478957558499538, 0.18094287319331692, 0.14865861327333837, -0.47867324623087659, -0.13765554211989831, -0.083082837113462898, 0.03991522960593321],
                             [-0.14052992614494172, 0.22412715746686565, -0.031292187194860585, 0.044467887507448609, 0.20039344009283241, -0.11979479692397417, -0.023399393463962005, 0.2038285678995404, -0.1045670777379679, 0.14500398808577911, -0.18749272782245385, -0.46639120713547144, -0.22399317775015309, -0.35681280685892014, -0.21350324196011217, 0.31577632719255277, -0.15088799344950721, 0.25924315443582513, 0.063687459490174528, -0.079344357612916458, -0.10651107830810218, -0.070858279114589348, -0.050320825631426355, 0.26607078586287797, 0.1479277330632188, -0.15559332625785033, 0.13505652539790558, 0.11494069082698335, 0.22302698059140758, -0.26049386326891733, -0.039605984174176774, -0.070958049059954578, -0.380646966827001, 0.058507885844073793, 0.38196038165471402, 0.16000631830609374, -0.058889154625453709, -0.075696063751958781, 0.4423617094402692, -0.26347979594028714, -0.11101786620299442, -0.4304192401398288, -0.12655467487993999, -0.12211807600387785, 0.091836160024487079, -0.23628535661502362, 0.10904999569690917, -0.16758515528519671, 0.023889475114817895, -0.16474375509523961],
                             [-0.2378536097525106, 0.30015250425312157, 0.055618975080341367, -0.10335319821651635, -0.12086866560443776, 0.067239701344213643, 0.18989905930628001, 0.3210786058522806, 0.090562887827211641, 0.06990903367629081, -0.0084723864276620708, 0.35839498003565629, 0.21430001519413247, -0.015446379883085261, 0.15738639197408749, -0.11148592903755629, -0.13287455576240681, -0.30364140079123347, 0.1102780623730529, -0.22336685744512341, 0.19572084506783716, -0.044227555019927395, 0.48616623653404795, 0.082650826814575487, 0.092688303276693168, -0.056846631168955476, 0.095279205450411852, 0.069511940234537967, -0.045732246200170579, -0.49233605003252412, -0.2397159332838493, -0.22078703107273839, 0.036107456496034369, -0.085704002394411297, -0.18146026312060018, 0.39919624159103057, 0.085141307436433097, -0.19431186179134352, 0.13503721512240824, 0.012040000087453394, 0.16254700559619112, 0.1019810218340465, -0.1865660431404397, -0.25315457608328545, -0.37732903212286595, -0.15667276422565848, 0.077366032395723011, 0.16228294247124356, -0.18681476627938795, 0.13145472198876693],
                             [-0.15881974025615542, 0.2421770853642716, 0.14454690828531272, 0.020957618133770423, -0.15082201753951352, -0.10072664023451848, -0.11936197163201567, -0.44512934706967977, 0.31285165989785146, -0.1016631060224554, -0.046179149040063837, 0.087227722898031268, 0.10228861668118212, -0.027367019476887244, 0.088064224466696026, -0.2984746778796486, 0.098660367077485558, 0.22303227247374885, 0.49924474200994656, 0.435967179944793, -0.11189622071264599, 0.0064434251368919813, 0.36603916445719992, -0.34418467623531956, 0.22092402349362966, 0.15709870980519744, 0.023904634888497693, -0.032362300681450927, 0.13516676921002771, -0.1699793425707293, -0.057365519288726109, -0.099370407117950851, 0.1741030936647483, -0.057378033922211073, -0.00032846873498608518, -0.24571819980191256, -0.086282124059649218, 0.059027766590338308, 0.04219312470016362, -0.089683950543564123, -0.018758562336949582, -0.080459764899443537, 0.31326263432439672, -0.15004711939535031, 0.039367293593144004, -0.42604449540038997, -0.23809083332627445, -0.15026476073088293, 0.34785192952263505, 0.13650529633185307],
                             [-0.099987237228197065, -0.32347050996021659, -0.02637157867897762, -0.31754384977584849, 0.22319120443455986, 0.086348663229000561, 0.22548304455690327, 0.027970463389602965, 0.32177634286972689, -0.23723810478577714, 0.052056113534659422, -0.24022429910739812, -0.094228700641932048, -0.18136431156439045, -0.06140056639681888, 0.011953650175233116, 0.35550300179197802, 0.054519749591854801, 0.068381646153663128, -0.14991483541641895, 0.36544626919193135, 0.087841002662761361, 0.075255647505994783, -0.078439920970406252, 0.0054140738343664459, -0.64871942945344641, 0.16119163307076192, -0.07018992740361539, -0.015043015573083851, -0.29835294176673993, -0.32906517738639873, 0.57228947705283084, 0.2411865127262999, -0.29538182387721196, 0.00046831546759070961, -0.076894867878350301, -0.12209529511918063, -0.30282805785947675, 0.13412985132245886, 0.11372918991952304, 0.0044025877136027189, -0.063352437624311933, 0.097115541198298544, -0.0022007156252494553, 0.26501519409078766, 0.017476311371888466, -0.17607004737047111, -0.015377578513651843, -0.26808036024812054, 0.085082542749986584],
                             [-0.0061185903902730016, -0.24401783340037464, -0.28697256527490683, -0.14657646830789101, 0.12331806912667917, 0.11831065365025852, -0.080968624385962334, -0.17113982898099189, -0.5152436010901339, 0.059435119074713542, -0.21362710161048923, 0.29048973455205485, -0.14980527345954897, -0.21939285340781178, 0.2420015315028575, 0.12781888759643356, 0.0050994358067508114, 0.027912837301254545, -0.039405002910253978, -0.13929069043633174, -0.27871721937707061, -0.20531026676535843, -0.13201147342200908, -0.27323070839093727, 0.17258440890605867, 0.0060448378824370791, -0.16910554689492821, 0.10386632457173874, -0.024380092436968731, -0.17438847576917191, 0.071171041849767774, -0.44737415601134384, -0.071879092355995516, 0.055286514960418157, -0.1980368568122374, -0.35759885584172391, -0.044256022221733048, 0.16931757065089903, 0.14825802283203302, -0.19594498715889072, -0.25626110757955944, -0.30571199637074276, 0.25552183758242208, -0.027767477679786823, -0.0012392080771568975, -0.14694115202841929, 0.020345295781367827, 0.1219672882185284, -0.36814427842780506, 0.22607669091342567],
                             [-0.017728189738495957, 0.012511337952492388, 0.078210501531634377, 0.13804698318175368, -0.099260665702212869, 0.15245856371322056, 0.12463342808239763, 0.22419800953393365, -0.15556490459180219, -0.013326689066405512, -0.060544802847453963, -0.065091099798613133, 0.074630816713441933, -0.18678090732446734, 0.13788629181933154, -0.3032727623482333, -0.07589975732076025, 0.19261892003007292, 0.31215535361086705, 0.39285131267169243, -0.26935155187020238, -0.0073288981468426018, -0.096195876982921341, 0.36354551298797416, 0.062503095318398677, -0.16775465093153658, -0.078858335208544794, -0.048160749492256405, -0.052593897579456747, 0.078486971105275513, 0.28385544781038768, 0.059016427823889515, 0.16733081331276059, 0.32102231567024497, -0.31755427611125653, 0.38705095371422715, 0.12840578086082849, -0.25775777519597559, 0.047595100045830493, 0.54896075933304778, -0.43662216378908608, -0.32541613043196743, -0.20263872604714503, 0.12987992349910724, -0.058276651622735667, -0.35697779809439451, -0.041472762172013795, 0.036795463107929707, -0.17634153971512243, -0.074077190097350018],
                             [-0.19269036618953847, 0.31364345955604578, -0.23495814457923764, 0.017014156656333244, 0.18399917096058396, 0.29236929280425228, -0.18529641859603202, 0.34096925496147945, -0.034489463830409454, 0.035595231107419925, -0.099116720930323629, 0.0025000518248406468, -0.075167568930007145, -0.02399959525712507, 0.043202386520576126, -0.094981835826618344, 0.23215905956395336, -0.10969496594435496, -0.41616610028451151, 0.63267211042987481, -0.074139438449450173, -0.000390237751486447, 0.1888094852978944, -0.022350126473490849, 0.20766426982483496, 0.13791600353447514, -0.35399713739137756, -0.14190448929838567, 0.20935804277328715, 0.27020791398709954, -0.033295678049203824, 0.1149958301091893, -0.079577463636663126, -0.21359148827219548, -0.46350714033336654, -0.13127758514523349, -0.32610174557146138, -0.0083416594736223371, -0.015280963487419565, -0.11539383724229689, 0.16392944307357679, -0.01148483619678255, 0.20674461075544215, -0.073776894937348916, 0.29006369953174826, 0.057892166324686009, -0.063655554275745277, 0.37743514021645941, -0.047888383486200344, -0.26944714200361719],
                             [-0.21613440924712451, 0.45186875130463511, -0.27888179058005985, -0.19999326509211685, -0.034402012198847177, -0.013525791325046232, -0.08129438776887056, 0.068217560810296465, -0.30161012331036291, -0.15030587855324523, 0.12092923984679461, -0.024205798005127559, 0.30942538285688814, 0.1767845557208387, -0.33636677606519383, 0.0097438998020441328, 0.27764026872432224, -0.036417687328189563, -0.013980084499168887, -0.070293106408697084, -0.39880440729025246, 0.13468212537338128, 0.30436482649037644, -0.24130049078265889, -0.21653839278094003, 0.1347332576526678, 0.34823464857352376, -0.27038627284573696, -0.15067992539697667, -0.070186665279424937, 0.074007612806252149, 0.43899045391332636, -0.098569256771889602, 0.063579711636680164, 0.065300975235400099, -0.1263608627614636, -0.15496167169463995, -0.23281528951812896, -0.0034588169969347118, 0.33405827543021072, -0.14102503598281901, 0.1964589990944966, 0.15767314394396933, 0.24838242700419524, -0.32061108963697882, -0.12254060490996703, 0.020051988701120731, -0.21264359838434435, -0.087743273607048033, 0.11807591806542615],
                             [-0.041710039597865067, 0.014479885045168284, -0.045773811705767539, -0.19241659302480149, 0.098210096268003783, -0.33171010801829137, -0.047957580955197289, 0.19907882058123175, 0.062819934887413831, -0.1692999671306627, -0.27933621355062993, 0.609214529619444, -0.015998208801801292, -0.19083113476554064, -0.045990255429686662, -0.1509281889422214, 0.10665425689908913, 0.42113130001287158, -0.13853845421719149, -0.15146850072047371, -0.011920306673191508, 0.24120972498597987, 0.32770559490742601, -0.0012753400544314297, -0.05776626769431021, 0.022504314512784555, 0.3466924198999275, 0.16565187720213861, 0.047826096026068313, 0.21522392761190476, 0.21516887206100602, 0.23789565132771795, 0.26240571810328939, -0.00024944686584941339, -0.073202284379652885, 0.11898899756382492, 0.045117706087846057, 0.3872241252145518, 0.02070050329210121, -0.16079456069105627, 0.26513192648791739, 0.00670694144327659, -0.26319503533030647, 0.29202446515500907, 0.15287883939869129, -0.018421341416737427, -0.0030168415647424986, 0.16316461205059504, -0.062961687353604245, -0.045676385544736506],
                             [-0.051003453079736694, 0.084541499863238473, -0.12127404047549706, 0.26485532865040595, 0.32016685012435819, 0.25330079724976884, 0.15186594565690267, -0.26067100379740099, -0.20722235126100547, -0.18092605234732947, -0.055656419103107854, 0.019297057147644282, -0.095790748466939177, -0.14505824658667998, 0.19073320396975837, -0.2797950123361852, 0.27086859934469365, 0.054316749628349467, 0.092298156874299764, -0.13138989943423127, -0.084754259714540064, -0.12877288123236896, -0.15267821272198001, -0.2641778434069163, 0.046826236275506132, -0.156109691893389, 0.011896497627482596, 0.037361521400316226, -0.16150047108995466, -0.52000833178234951, 0.46243601126424733, -0.029970808031656172, -0.070884105107946224, 0.0065793004071156118, 0.12364504600341014, 0.34204069980241036, -0.028446831103525767, 0.052412587981921652, 0.23136574603274668, -0.14227982402326425, 0.31069312797323573, 0.36144109857405743, -0.12917440597847166, 0.20752137716175451, -0.045175444124630849, 0.2978982319546537, 0.11737263424606924, 0.16060670396890958, 0.25892231561007867, -0.048496275100276542],
                             [-0.077723568456644021, 0.10707258383935393, -0.21634866660518293, -0.335883629869492, 0.23304001641247926, -0.071822550551111364, -0.060829800279508288, -0.015373613720668415, 0.17870533604984495, 0.47993733546220191, 0.12967126924592479, 0.25334020598821766, 0.37152003936733319, 0.41224367901869607, 0.022416836957058397, 0.32186246611966057, -0.16644895036022067, 0.093330387109328436, 0.053026261397894833, 0.4249008891687609, 0.0027782284267856231, -0.18256294724799071, -0.42290199390712457, -0.056656045343959086, 0.054501245723486857, 0.089164827879662872, -0.055041172397819971, 0.1311773133523462, 0.0017471815732707716, -0.20254165013452324, -0.2256096142485218, 0.34310880321395781, 0.049881847049172257, -0.26357381255552409, -0.094686515999431481, 0.097027990910094009, 0.15554694940884853, 0.083432774073705834, 0.24125748319904602, -0.1635739410792206, -0.34319615992227187, -0.12285299124727131, -0.043894714578455521, 0.24013532495278403, 0.067908979978328121, 0.20913775417444039, -0.047993180301934418, -0.12869627822555343, 0.15454294425317575, -0.24599348893656106],
                             [-0.10909375116394571, -0.34237922521748132, 0.21681483121425707, 0.15105452886087095, 0.30756691001085379, 0.38765615863519498, -0.16332876267749749, 0.049797071503068099, 0.20283876265381812, 0.23636178828531348, -0.1916584938268171, -0.21719344290506748, 0.069222543704141035, 0.25320912754556063, 0.0073753073825902835, 0.075299991038274436, 0.047601465856622151, -0.19280279480170559, 0.093871062723950641, 0.13586263044833399, 0.07610172638767311, 0.056128237658087082, 0.25959761524388458, 0.25272580910968462, -0.44974810420767813, -0.0028471971655636297, 0.2321694381935159, 0.019422465279004236, 0.062547998291568457, 0.056196491356368908, 0.43258531004254536, -0.010803276189110355, 0.24343487482294524, -0.10294102592649521, -0.028057181207571915, -0.031532749177890056, 0.098966679842782734, 0.40816816604836431, 0.33170359064423283, -0.086101639271014274, -0.17418254040014719, 0.12682010286582437, 0.13663296975218367, -0.030669313612985548, -0.19773336037728415, -0.03702203481943582, 0.19112244887873903, 0.18351905604888302, 0.11556415632248271, 0.35020434128978861],
                             [-0.36626897864711483, -0.076217549808812596, -0.10343034456106444, 0.12885489390380667, -0.20257356206776844, -0.028662485264930607, 0.30463783656262006, -0.030047996347842752, -0.019791272995638279, 0.047466445348731512, -0.25111451549439534, -0.11586258807187687, 0.37760878249630869, -0.014368467771430063, -0.1236738350529932, -0.071377388519637458, -0.23811271599194367, 0.19223219855113938, 0.22590822803647362, 0.24146377162152569, 0.074056949712894365, 0.041901157121324133, 0.033845623853712599, -0.00087807559064142062, -0.0094807793721792665, 0.062215198062388365, -0.14230646114648174, -0.0036537651167668286, 0.17454184428583933, 0.010884353761754485, 0.05091376467543654, 0.11741168707674894, -0.35085664168702924, -0.241621264515958, -0.073629588947737606, -0.038925323758278049, 0.38772906973362409, -0.075875655465852135, -0.059899879785831445, -0.097373770064546436, 0.093916812885007833, -0.012088797494539564, -0.21751181157259492, 0.26920901220907539, 0.12906617048882757, 0.39572505817428127, 0.40480008659254985, -0.0022062069398208661, -0.22998123639867513, 0.65076820978411176],
                             [0.041303880934781823, 0.0034621267823544445, -0.3869227246036282, 0.21777152047076126, 0.084195033684708126, -0.12360999796581999, 0.014237479224527876, 0.29741238740329201, -0.023002693903182783, 0.026558843072803311, 0.12866949609513517, 0.05562190332268073, -0.30863020147137643, 0.1777303814615343, 0.0041475039678191463, -0.035108444488521212, -0.13007924303702284, -0.001949437394862065, 0.43132895938516014, -0.32409225436397426, 0.014658709536034677, 0.089074417543997558, 0.36426876915186152, 0.2007323390187348, 0.30968522445893548, 0.32284647657539495, -0.031618074662048627, -0.29255255523617879, -0.398335657540207, 0.077955886042663042, 0.057266419315784578, 0.24389619167909121, -0.16830283298883705, -0.10980479349475136, 0.14672347654705414, -0.088731358660462778, -0.35825609335509301, 0.19844339696768074, 0.25954819406475976, 0.34265224738564831, -0.14687791575262907, -0.24727631566658273, 0.24591720219089508, 0.15366123498399786, 0.20209608866465972, 0.31847442011545013, 0.0098739759015882052, 0.35395015679630559, 0.062423481763618144, 0.11705500799532552],
                             [0.016366466411066621, 0.34092780677080514, 0.02023662209285438, -0.1234482302735858, -0.01872732520724214, 0.36685855072919588, -0.11011906413138715, 0.45214182820328619, -0.13912620579485654, 0.029821906556098746, -0.13978815361610478, -0.084350178925972866, -0.35615397361655204, 0.044087783391092941, 0.35084992763079309, -0.11252171608240508, 0.0061167365166373156, 0.064724947996539606, 0.22748679496892685, -0.052678056280628889, 0.34204649719806568, 0.20061825583407411, -0.043833319095594604, -0.31402903282965078, -0.025101953790653952, -0.116164971011507, -0.17576923536631936, 0.11539580401785147, 0.24691380221228568, 0.27387019193249651, 0.25296409582691093, 0.2139286164399917, 0.25043253763848183, -0.18472271188801245, 0.11858534249230977, -0.13506430173203615, -0.19107047199836277, 0.026515510138252124, -0.1806685633170112, -0.088739043537563789, -0.154702445912169, -0.17699448909727947, 0.10084312251100998, 0.050808198883303624, -0.38999577968923937, 0.07317371836571411, 0.17612248085055382, -0.50676345635693332, -0.055759351008741159, -0.039181295887556165],
                             [-0.057704960149913317, 0.20091316750980234, -0.052911564983730577, 0.29752458425594824, -0.0026777706900731717, -0.2491888236373081, -0.23296198517367506, -0.026211983737779034, 0.11358791268094817, -0.18507074839082399, -0.39308153632439174, -0.12730189849047038, -0.099311213223671604, -0.18881336962653561, -0.20508996788311487, -0.18390020686406844, 0.10679835634034215, -0.43731913427796609, 0.11220284302180772, -0.050146943807038095, 0.21859296128259201, 0.093177827357221743, -0.10587682157743099, -0.28264135704536447, -0.051470379488243595, -0.098139996903193902, 0.19837952095406697, -0.037539562596394516, -0.14379558150771748, -0.063661816971761348, -0.15918454814124713, -0.18819105737826666, -0.091928010704638824, 0.24353848095894071, -0.2097775470605116, 0.49000594452222818, 0.22055900628868955, 0.50347931213961239, -0.16419855206940528, -0.08629893884094586, -0.28567300838262877, -0.068938894655096089, -0.043774443579152368, 0.31703349781350409, 0.11648403319171122, 0.25390232700005499, -0.10488915410765859, -0.047906977620213155, -0.24936148099089772, 0.045390429172932539],
                             [0.20005604055864748, 0.11535009245812582, -0.1260357975125305, 0.34686789766599557, 0.1891181826909237, -0.28287161447877718, 0.2420905724963574, 0.12005396292275559, -0.094430373334984524, 0.041533432887149224, -0.2852902935276499, -0.095376465784035441, -0.29571100667974948, 0.37691874575812012, 0.24206668677635915, 0.051704108394767023, -0.16171451953265004, 0.12870015498376314, -0.23623099678172532, 0.25761820454032891, -0.051974310333553, -0.21057013796413843, -0.098468815865332182, -0.35982671155746537, -0.078426117593817596, 0.098716442769703594, 0.56663759878301401, 0.13734992700066517, 0.046593134478390419, -0.083833001959758568, 0.072284305608841831, -0.22998951979583876, -0.090261686194074334, 0.0098091921684079694, -0.2195122398480773, -0.014739813354559941, 0.044808837098710197, -0.33007976089840824, 0.048830897739486581, 0.096995474028930634, 0.052401307317517222, 0.07117056666412204, -0.26618340272907637, 0.23203850182751157, -0.048362399169804858, -0.060205725485904416, -0.32052428494177693, 0.034870422536314276, 0.18786410149633234, 0.22652920055322068],
                             [-0.29276627114444387, -0.31958576620180618, 0.0558183362264323, 0.075987913509801025, 0.092885518596694513, -0.47751993623686467, -0.26675656664560021, 0.3377293408216675, 0.29702969272494523, -0.041274301226189414, 0.13491860989072041, 0.025067730088271716, -0.10045477019900095, -0.09328254934786287, -0.0066379342726949403, -0.25753667997739038, -0.079190418379067193, -0.019286400741377246, -0.25822031599092449, -0.30540518327343408, -0.29330653920801236, -0.21094319594450386, -0.082837127140039907, -0.22666357696012798, 0.14239256387965613, 0.11603400913399203, -0.16998405560754321, -0.16364618035112954, 0.055026474835176933, 0.17754981250496205, -0.10323391947363313, 0.097944501635879005, -0.045488733164812091, 0.083526651254534387, -0.32521974671318304, -0.099855113438623744, 0.42742715217404936, 0.21084755987719234, 0.31393488821275872, 0.035808991452312797, 0.095497953217729983, 0.088387125039598641, 0.20212497834124787, -0.18176366922374193, -0.067893283775520286, -0.020936397500099353, 0.48724947655163603, -0.40836182180558511, 0.2974111815859023, 0.038189062125983553]],
                            [[0.020669443556070505, -0.18378946880984348, 0.11671345718376951, 0.11202044463416766, 0.29010205200948491, 0.12752270597473581, -0.18890448572868776, 0.12227142929630834, 0.24528318022617757, 0.057153001743557218, -0.081401889650627779, 0.12466585254832534, -0.082472329078949178, 0.18984554702895048, 0.36264546695432459, 0.098136724716174073, -0.12019346573492494, 0.11781192208916881, -0.30254786931198219, -0.058719356931585413, 0.16434076149366544, 0.015022229931482556, 0.013130310655957777, 0.37615148481089461, 0.029239014169224115, -0.029691976828890194, 0.066092645358914764, -0.26955963951615469, -0.20248326133361544, 0.054522910796087835, -0.080742076353991415, 0.023579935416870562, -0.15504621284630332, 0.15695549887386384, 0.32564223764243727, -0.082797511576264138, -0.35319972074767098, -0.32750077830773439, -0.50007995733894484, -0.089738319348625237, 0.23138345657478759, 0.00033310245089792148, -0.11911917665311442, 0.067728590030620692, 0.12299314005967113, -0.18519258658470816, -0.33495026686230611, 0.26360780575753145, 0.023536630157309835, -0.29252291774212941],
                             [0.21813721523905755, -0.28768953325859165, -0.060331268625377854, 0.28923647504394268, -0.032299823441536334, 0.21874637401799243, -0.37483336627943359, -0.33428992182179085, 0.12323044978024703, 0.41867042196738824, -0.28027138953411146, -0.41608602724403965, -0.13680329248517578, -0.11395048381890835, -0.26609209473367007, -0.15556628425824065, 0.33114719330196624, 0.12911144174852562, 0.094677033474655337, 0.43253958762583039, -0.0096960150318731089, -0.041891727984099299, 0.028277370219043578, -0.073668236372113824, 0.16887843739750821, -0.033408820338028465, -0.29330087332556654, 0.24968265742210391, 0.14697221931502372, 0.048500388817065164, 0.0012546073486765345, 0.019309038750880438, -0.060412968758182028, 0.10436072289771603, 0.10921509396600103, -0.13732171457408407, -0.06729083643555174, -0.13300369694371569, 0.31724980033994588, -0.14465213217362688, -0.09181236602365557, -0.16306963861515664, -0.078317114986988789, -0.04392056993509471, 0.034214886546699422, 0.39635662817037476, -0.13914671272528967, 0.13281423376044896, 0.018588659369711408, -0.29424419078066016],
                             [0.22722680240542009, 0.093981446206348448, -0.12344812938723471, 0.13303662408896014, 0.14669707195304155, 0.35988352862681849, 0.15523377611263306, 0.099945435838898797, 0.051456950182388231, -0.13831874732213589, 0.084603073708011373, -0.073625868493812197, -0.25850904215599169, 0.10544843853594484, 0.0095992024768403912, -0.092738014800114579, -0.37182551314908352, 0.029007598604415985, 0.026533025436933519, -0.10246599993208924, -0.23199962079860112, 0.38817197031434264, 0.08854521954683113, 0.23892972578496305, 0.029193960880846376, 0.33451573202400209, -0.1182713222352039, 0.099024800126334495, -0.050134268770581282, -0.16901266086752992, 0.017710363415194115, -0.095419743092288928, 0.17728358752089901, 0.057688743578555586, -0.27273830378275588, -0.088454831880900323, 0.22742883507627726, 0.082733818386696023, 0.19815489105060974, -0.1450618239282786, -0.11298555771695147, -0.054787465682434359, -0.25301601000937313, 0.34651683637617858, -0.50597568836881412, 0.16729332468772556, -0.099556983097423474, 0.10376796126711624, 0.16050571663472465, 0.042937582477744124],
                             [-0.13673450617735072, -0.10365002794972811, 0.03251728429022073, -0.24978407031802591, -0.016849942632797231, 0.10537610810489147, 0.13116729802031149, -0.33195964006217704, -0.14469786551925329, -0.11948930818431315, 0.2549869158687183, 0.11320076819066668, 0.16816063792273234, -0.19056898649486748, 0.00090847022841731347, -0.075830676750052631, -0.18690238232654185, -0.10652917171884549, -0.34923495251238512, 0.040722021119257545, -0.079126068292244417, -0.1357710619991549, 0.11842617302995127, -0.44934178321419588, -0.18018698719517531, 0.27099534201578573, -0.068673918661756705, -0.15777405338169731, -0.097837720055995336, -0.12067130158708747, -0.11256138080340768, 0.11026794025393026, 0.055128508484584789, -0.17050544695325814, 0.11129312118255742, -0.24902337219803325, 0.1256887333189636, -0.16283685447772817, 0.063169211207799988, 0.33142296291691903, 0.14198405249518065, 0.041385158745944867, -0.4295478187796718, 0.12006310322404745, -0.031305512464550315, -0.0052160617298388588, -0.28478097697733024, 0.15953587082403378, 0.42607243898237968, -0.26669857490093574],
                             [-0.077777600691753393, -0.12990683369699055, 0.037749555955001693, 0.23998118158904383, -0.23279474027169386, -0.13042351033514638, 0.12985947554746863, -0.1039634628909011, -0.032330349946912244, 0.07941062487217132, -0.18125444871767227, -0.020865119481770437, -0.10505374193666056, 0.19137429641605208, 0.022436019151271937, -0.10039197495377115, 0.069866985665500828, 0.31563741627103459, 0.21213570623597741, 0.19262735406562861, -0.33299644160022335, -0.1589893815044697, 0.01514553315792651, 0.021979207419218959, -0.2291673185349537, 0.33401885682373561, -0.040671518987364562, 0.018676139436627458, -0.31644454796528604, -0.085716747483969929, -0.092962245960813289, -0.52867278296503739, -0.12868370913566871, 0.19631702610802976, -0.29028738229729528, 0.15283385183599657, -0.14832919592837257, -0.015358916702865977, -0.055058997213999317, -0.075374813019584791, 0.25031294035668233, 0.34842565085767985, -0.35996763859741393, -0.40278280362068281, 0.30448327280491999, -0.18358484134563177, -0.022575329163550359, -0.13816831368542909, 0.041013880758646933, -0.19938427594941643],
                             [-0.15865495016476036, 0.10060692040531738, -0.043310026512409665, -0.11380916535928891, 0.565339352807396, 0.0077616162418711523, 0.1037880137594084, -0.18542612911747058, 0.070127215235174387, 0.17723327640718775, 0.16087365564888453, 0.091596672083540165, -0.38300865431356002, -0.039144342270599486, -0.099123312931172922, 0.25661968306899802, -0.17472536631117452, -0.46746950307095342, 0.17259603349960634, 0.075354514077123666, -0.0059847609317047537, 0.13917417776673441, -0.27848822056787176, 0.09851883967309269, 0.10509306224326706, -0.21926066373798539, 0.015159626804869051, 0.030538716548465385, -0.10202690299890228, -0.065698451210313993, 0.35572850524215649, -0.23759859884512069, -0.28653503062417524, -0.015129532152084102, -0.085551756726956668, 0.23681191303182153, 0.011357766402354141, 0.0017898104712282276, 0.20601401891775278, 0.2212299995140084, -0.14135956197084082, 0.16190643849625636, 0.033264845674689583, 0.040837391988356196, 0.3437039668960653, 0.22272417059509672, -0.15046611520696079, 0.14102579707042256, 0.13758471942944309, -0.13624260046172945],
                             [-0.16505381161982161, 0.10520766156791618, -0.29224465448031173, -0.2151434927921467, 0.34604412990313349, -0.40606426094097803, -0.15904763775113007, -0.15893042020805703, 0.23149590462914069, -0.21055923907487939, -0.085844975190435074, -0.10453785845512187, -0.078013226759102855, -0.14894950016101571, 0.016007593939300124, 0.22437473852884268, -0.0052603560226235522, 0.4072691507472001, 0.17481128119627184, 0.099604893109857151, 0.11105068275395809, -0.23233688143854517, 0.16269661320698475, 0.15351295380404778, -0.11599674862189105, -0.024711149057034806, -0.051339155283880333, 0.066788025536906964, -0.17777960289557981, -0.29810823655608981, -0.09272194848118194, -0.067604433774614184, 0.21867422907574155, 0.10618956436097897, 0.15920916485429759, -0.21585057497485621, 0.1602313493903201, 0.28312690448764188, -0.19635372137744367, 0.10229833322361995, -0.274758151629309, 0.36488891031942261, -0.25894631543557262, 0.19612802415202701, -0.20326741576838234, 0.031822073013370443, 0.16721654550719287, 0.12742683531836171, -0.2744223169518395, -0.087318826501819977],
                             [-0.043526993482918011, -0.26689514508911993, 0.071548253610063506, 0.00097435998396930333, -0.21945674422709274, -0.16065457617194895, 0.14800121577095546, -0.033319003272758115, 0.062742136877263377, 0.22238861871728627, 0.26105923609415627, -0.004687937057634514, -0.14164237531087795, 0.14040838404541664, -0.073911196840220836, 0.070086354221337785, -0.047889135186364451, 0.27764838053133839, -0.18391080817330216, -0.12597855487358672, 0.19363268660125499, -0.41312238084390651, -0.14621648074099453, -0.063507621939242018, 0.066195529936534575, -0.045663688254276892, 0.10866199836115722, 0.43404883116556542, -0.052616154792098614, 0.1393109809789613, -0.020484649124300917, 0.019820419635975622, 0.023093678252374478, -0.19649559233577074, -0.10997256218298065, -0.061772114267126803, 0.5966409004978338, -0.35682540546949609, -0.058479380576200023, -0.15131844976439018, 0.19147745629029428, 0.23945501100432809, -0.0036146772318000242, -0.29821669019699032, -0.22029703647234883, 0.046846452661059988, 0.017475722561070411, 0.44963075942491509, 0.025988916135749517, 0.096906226104035306],
                             [-0.27078236533622385, -0.16794722197231002, 0.17446024691259598, 0.05111153114372094, 0.2105133727903406, 0.15264521444963061, -0.078156393522768042, -0.1559348377405228, -0.11634950779913064, 0.1528982034461378, -0.26229090710199721, -0.16307738237746089, 0.18031036241561202, -0.049037191513330927, 0.012132518503380979, -0.35246079240025774, -0.41939560402812226, 0.15487249354375759, -0.034852293679362496, -0.21749789928668689, -0.23693344310039907, -0.029928318465400311, -0.33784302421122464, 0.10940081886479096, 0.1844490223123707, 0.016391831292443218, -0.058610889935434687, -0.33129666919661604, 0.22510590939636613, 0.028561264898971955, 0.40541534355474979, 0.13407112103691604, 0.32781768888221313, -0.13118296561829057, 0.0011888669604037108, -0.146628197415759, 0.26891653735247834, 0.062243845121423232, 0.046821950720644247, 0.15758445566267645, 0.30831403605206215, 0.1420032638639572, 0.11421165365886964, -0.021412113389534505, -0.026271822753752103, 0.14530225174264813, 0.34288937569723837, 0.094240452241211067, 0.023400484793517827, 0.054502036380351247],
                             [0.34767216575618093, -0.11344550029339276, 0.14867027585914896, -0.012549679764350664, 0.19645165162974168, -0.4142061469563405, 0.14742522395388324, 0.28472700598278344, 0.040735984010445619, -0.0076659399068036149, -0.32993489902756035, 0.0035478838737895979, 0.26007606810696571, 0.012699985969187449, 0.086362870662995667, 0.24599902151300385, -0.0028111634640594681, -0.21608344569165841, 0.03914842895745356, 0.058939447670753348, -0.036788661473010152, -0.23708210383691855, -0.063211227956111449, -0.027442040655186239, -0.066923462512017154, 0.19188180324683402, -0.09763369204960716, -0.078277421827612437, 0.28386495421776181, -0.16237316020545253, 0.066607343579066919, 0.10876416560301734, -0.29753187834913564, 0.24061044561381828, -0.34119309874485293, -0.068561001474463118, -0.3652939301320976, 0.02403368997301332, 0.27167402707521815, -0.080077519162448929, 0.13457636251402613, -0.042111703335654227, -0.11598120962288354, -0.11289548319361382, -0.38649306997282251, 0.10811972511458458, -0.033878911355713602, 0.23792728633510923, 0.059124312472531408, -0.40483200684713661],
                             [-0.2000805287244127, -0.30005318942932119, -0.48586855995832562, 0.27397251882076401, 0.13802044565060961, 0.16142925361949875, -0.18671987171996374, -0.0073264645507495627, -0.23696398205973568, 0.0068847821059600019, 0.15992376985865081, 0.31468791271025115, -0.182393026891458, -0.24358994400694484, -0.20493713958686824, -0.34185082444736947, 0.33929803336821751, -0.11939468539132725, 0.1773540000839311, -0.23056459721582673, -0.054349736537662278, -0.26155247393678299, 0.035460161103483809, -0.029872493975525775, -0.39214564962659143, -0.046214472080416444, 0.31952611235799477, -0.1403577775106761, 0.18037973164002122, -0.1941197184469472, -0.038975722199080326, -0.25241228880731997, -0.040347493392424272, -0.34890931847382856, -0.074383375767999096, 0.18619155836812307, -0.085169122306795977, -0.12085568382908178, -0.12029170855891931, -0.19361611348968039, 0.021164055703143895, 0.023291714337826876, 0.15514055908786731, -0.036003148594872171, -0.34012415769362231, -0.025403668227855038, -0.010700635224199388, -0.0057899444131708066, 0.17416763911546268, -0.16350910124350151],
                             [-0.18767436678160437, -0.12465416865257242, 0.23055228041383172, 0.13039111636529246, -0.00013921287443196661, -0.04410235780943824, 0.25513835210229868, -0.31623415559676882, -0.26147836849223827, 0.078512170213756088, -0.017994839029283897, 0.2034195678635172, -0.31482014395476754, -0.01065284161537889, -0.13093734318685318, 0.38549865702754521, -0.11048399543215193, 0.16228861086415211, -0.21278812237357175, -0.030501139030936878, -0.037352503437621094, -0.062717088639010404, 0.58522697993115536, 0.20846473061259652, 0.1647214567481359, 0.12052883497520096, -0.084472242972523814, 0.07807448214088733, 0.45288093586702083, 0.31216844366528995, -0.005685174795229694, 0.098491695793935158, 0.050512911928044357, -0.014707487049366377, -0.1688800806107531, 0.10994408964678019, -0.24433156328347413, -0.11220482753126176, -0.078913332032000724, 0.07049589908348293, -0.19991629651335466, 0.11396239417997124, 0.12052101984423881, -0.031905983047606508, 0.049979107430177513, 0.24529806290721989, 0.11218713732301779, -0.035259564486261837, -0.022448496932660215, -0.022751512420675409],
                             [-0.090662162072369587, -0.00048876939053625959, 0.10635424561561627, 0.063068579494828886, -0.30402147422640091, 0.42160355211036277, -0.16452558428779837, 0.078301372484297388, -0.34302883763134051, -0.3646295038466304, 0.050228888604475823, -0.10393427160497473, 0.10698339481152662, -0.26385062431631817, -0.0510849850797385, 0.44891904797693927, 0.14471964959080622, 0.26216320110708646, 0.060382449371164999, 0.095136219785216386, -0.018186453117752993, 0.031621878318362169, -0.40087392624083162, 0.09176742229911139, 0.024277423426831479, -0.32058255683874504, 0.040386363994761282, -0.012591561122195664, 0.0017943833519561379, 0.20532788601229324, -0.081272261380120045, -0.13482900587572766, -0.10329004159558641, 0.14856890651156424, -0.10555957492996196, -0.086049383560450804, -0.23457287224189394, 0.26959759988005966, -0.1648235605543566, 0.14687964643941789, -0.086011840050428862, 0.012349346032672889, -0.23500522734318738, 0.038791665876762124, -0.22071979277407183, 0.17520449826000398, -0.0092492820155342728, 0.36964277991760319, -0.067399421674776611, 0.078911913491146818],
                             [-0.1679345166793543, 0.34693309196413746, 0.23773071694070186, -0.12798278584186434, 0.058583148265571747, -0.29896340012129097, -0.19383847546739877, -0.20655790522279091, -0.0086776843470547978, -0.057553269059587062, -0.096686518099737107, -0.012430973969353375, -0.12172035194358229, -0.05505031983869365, -0.038927894587000363, -0.42346517891399105, 0.062627813483286429, 0.32309906377954012, -0.26050885237294591, -0.047822848457994879, -0.030634889750527729, -0.13044198659312678, -0.24735282816632412, -0.079198573502015535, 0.0037846124529423812, -0.15530730086105946, -0.0053615276849555225, 0.11432462941788124, -0.18913670202070496, 0.038617300747649852, -0.23438301023559965, -0.12780560012698897, 0.15360211916098454, -0.27252592148199278, -0.47986950521751476, 0.44982397921974326, -0.27443095354799529, -0.15579728347339838, 0.11290723761525313, -0.11886819490775133, 0.0084924983851280278, -0.1761942161431852, 0.26563743384966443, 0.28039001215788062, -0.18496727994934103, 0.017423601103666711, -0.095346943960034514, -0.092272087524301036, -0.21497794963329392, -0.27555169588844847],
                             [-0.11350768690549984, -0.00075767966253092404, -0.075106796860396688, -0.15764526569032902, -0.068107104543666253, 0.18394122700206372, -0.31169759666738706, -0.14800677211671798, 0.22957918032361974, -0.20464306577973282, 0.31166034209137056, 0.14769641061674293, 0.0086696879910286954, 0.45631007169456256, 0.21427441178609782, -0.024111651184922672, -0.36113087670749189, -0.10372259844626622, 0.0063213895121995486, 0.13987233925440187, 0.0080415856217361907, 0.13416809744238198, -0.1956415075719905, -0.17451160103853763, -0.098068144237522289, -0.042291415199749792, -0.41799257173280663, -0.27289183505576392, 0.12495290258507605, 0.047528581718704818, -0.087828002924563955, -0.018802797307525831, -0.012921307419898335, -0.15155078143453285, -0.087894913204168992, -0.0099446485016921396, -0.20633313904556849, 0.18046053223907191, -0.11579453490140859, -0.27864387174431221, -0.5510265095065775, -0.31553006073720041, 0.12027557140846268, -0.35489780152810946, -0.070787785449877405, 0.075478070033104749, 0.094589478821909795, 0.064996700429873946, 0.13855722135603188, -0.090867885983732105],
                             [-0.0837404864586139, 0.042836904919603611, -0.38764947252245352, -0.25291544153166956, 0.15993306460167966, 0.25766375280467158, 0.38840909785187383, 0.014569920589789686, -0.1029079016287117, 0.18113848415364672, -0.25965950390417314, 0.3396675459777394, 0.11108815132792368, 0.27964659951898324, 0.26643692480217379, -0.053836946858349659, 0.240081169638902, 0.013098504647488875, -0.080781489423470951, 0.30373511469818881, -0.13474012340055858, -0.15892706096069759, -0.24266242176836189, -0.25873673416014936, 0.37264906660905756, 0.29646771028068664, 0.053331198758170315, 0.21854686245074403, -0.29276303558836281, 0.12347164732452491, -0.092420239477161575, 0.080430306944069219, -0.043371285448922207, 0.048338044525781346, 0.21274897312417596, -0.02689788832519608, -0.049148833096332938, -0.073618556891321227, -0.022393554304129554, -0.11576942258264, 0.24931951221502879, 0.11250431022060553, 0.12627620936682171, 0.046391452260963598, -0.098234489207184222, 0.087648048743870471, 0.45080294938302162, 0.18324085706106857, 0.091087290723994394, 0.038112139826256747],
                             [-0.33424668025826115, -0.26670673746696483, -0.080549042342632701, 0.29542448161370843, 0.095960058579754995, 0.098779834016811272, -0.13594427496797992, 0.27746228723372407, -0.21615269027172118, 0.056828027553333361, -0.44028210136536094, -0.12321167888185464, 0.21811933548612186, -0.015991136815446051, 0.035123991723332998, 0.054372698257902419, 0.18850719108818201, -0.17342521473577172, -0.1630283241948135, -0.24662237631997863, -0.0585356741293723, 0.016344551606491307, -0.22898583235589473, -0.23264187461443747, 0.10933842531749645, 0.25640605305069253, -0.036700081903680702, 0.010472926127607314, -0.13214280801917275, 0.35963499963502982, -0.084801208705741662, 0.063285222482727527, 0.23159447745441614, -0.111091899448336, -0.085154937968479144, 0.21264829649549236, 0.1789810001405201, -0.019042587269417603, 0.0096137153923054469, -0.028492427598168349, -0.52052308865950037, 0.14649437240407845, -0.16245558090535051, 0.058357698667096849, 0.1063165852016828, -0.29294786034592651, -0.12624980231393415, 0.1030125848331601, 0.012369368102474219, -0.049880842064649815],
                             [0.093375687272294047, 0.12356252491062351, -0.15676170902965469, -0.065787983782317344, 0.35023494584432902, -0.081479096399081949, -0.21917854599790568, 0.12373255449030172, -0.047359384233171715, 0.016202502692970688, 0.05450944540786816, -0.20643382349886299, 0.058932519262705145, -0.01189055371654206, -0.037302973409695114, 0.10198142511772149, -0.060141426309755185, 0.24490265575191961, -0.063328835885954199, 0.029702673649550718, -0.43349074130123022, 0.22057943728253471, 0.10411609573599244, -0.39474108336873515, 0.022271600767880748, -0.11555892130872422, -0.19515142611925854, 0.37030622778912514, 0.40835714666383655, 0.28993063805520064, 0.17843863802470769, -0.32468692532452154, -0.054014375858304181, -0.067465179334208147, 0.00091016310907087589, -0.22065008907055472, 0.032739337408657129, 0.20209468833014999, -0.26450204475565825, 0.06146260529744358, 0.33808741535577486, 0.14428024066363504, 0.054356945763569628, -0.0045299926429456794, -0.0057426067219990273, -0.30213536720289608, -0.1316510016387486, -0.022303574307856216, -0.046231314129430406, 0.0011091758655858777],
                             [-0.022052001254553973, -0.18874363460925594, 0.11445823095740709, 0.072877583208685703, -0.16976492363164747, -0.13072945643586248, 0.2843435937263577, 0.11721185775757, 0.31687797353448655, 0.34104265656254823, 0.02293810658049001, -0.15805410523154234, -0.11752593469479063, 0.062320063911445442, -0.17085461865016716, -0.18205700147423934, 0.049207899889964483, -0.033214004243009417, 0.34045935607135175, -0.017216907378383172, -0.44958061504169744, 0.06011118512375839, -0.47329738649360031, -0.12584184151510394, 0.23824297707792841, 0.066274493442393209, 0.082918890046824262, 0.05606756316386266, 0.20886966788336139, -0.056729259803027517, -0.35610384217065344, 0.287007760996214, 0.16606147653888106, -0.27521414115117426, 0.0078287636150484244, -0.12723955815112287, 0.00073510262039103245, 0.17083579275276442, -0.36189803721799274, -0.13060685670715105, -0.031129178034742463, 0.19059702738441014, 0.31457555211054417, 0.23442541965531172, 0.38205213108184832, -0.12274579337384108, 0.12943711074340383, 0.30156659401271335, 0.30741618428770517, -0.35646817860496105],
                             [-0.29343199036256895, 0.24471177226177571, -0.21333466150112437, -0.3611679608216557, -0.1090057234962389, 0.0043447950395822882, -0.057398228707158508, 0.23466079532551096, 0.46872710477318236, -0.34468013422442961, -0.10230114173897874, -0.2480302318948292, -0.18486555667636351, -0.24610543924461131, -0.046106076122440685, -0.085113135979625595, 0.22327224403569473, -0.09451500112488212, 0.0019753834146383855, -0.034045626525832526, -0.23675158737067495, -0.13841671031160099, -0.18105952825885999, 0.099789401972191785, 0.28428379382783248, 0.30189058043324041, -0.13117846292550497, -0.097208824040102088, 0.25438272876744245, 0.18144848169856756, -0.26723053226798205, -0.14503028890599851, -0.3701622317023982, 0.26725132611188229, -0.01061399812854949, -0.015144375163792079, 0.12111729820485699, -0.37904884183021142, -0.040830924680693936, 0.09003774425236509, 0.032756707692642786, 0.01116759768135237, -0.033022254418533112, -0.093668529193212127, -0.081466612341654102, -0.00011858465271603826, 0.17572833547165836, -0.089294235950326581, 0.058507989414585376, 0.19706259036367593],
                             [-0.10092160981954885, 0.62054229504403535, 0.10651781735180028, 0.035581801064842371, 0.161922267515721, -0.069926263040798672, 0.15416369027833485, -0.099525481541159089, -0.11027283489064081, 0.20060606005812018, 0.15763245760785913, 0.033539220468875024, 0.044693263612451697, -0.40036211824028856, 0.040221158887094932, -0.2012481116418644, -0.25533736420864239, -0.13302239895982246, 0.14213794361181092, 0.18344032806405874, 0.49789092100584903, -0.11404129264762644, 0.02439763819920155, 0.18602200392924184, 0.22182350845742699, 0.20720936367366402, -0.032240347298727046, 0.18271381381720772, 0.14076696838527422, 0.30060194092076092, 0.10563041285225504, -0.10434383379834515, 0.0099941883719520223, 0.26592967200864137, 0.14365565643180578, -0.16071221439547273, 0.06152416263855897, 0.24091115117404724, -0.025124746401509804, -0.30031115872854625, 0.055404137071277733, -0.064247356833545655, -0.17341367960765006, -0.21381870534084801, -0.095099596723887445, -0.24185930289684768, -0.018947442172643585, 0.15106056322207956, 0.43365857565625804, 0.17448818858096318],
                             [-0.26200599101136934, -0.32660146317719002, -0.073698634580399297, 0.13404055402387152, 0.27459614924130604, -0.11014390526285556, 0.18213867096023886, 0.17435469202014578, 0.19970321139269825, -0.17521472294332402, 0.17533209607279235, -0.073378201791691383, 0.10711511001130251, 0.16281101350503724, -0.10390049842968117, -0.2408918028437006, 0.010216434045537843, 0.38768445793129364, 0.27102660985512578, -0.19987137462756024, 0.14886825216125182, -0.071665174291978842, 0.058758534819774652, -0.09284111227937869, -0.1256742312476877, 0.069397307662378296, 0.0046224960565289085, 0.24969845204389332, 0.017617091666979098, 0.15666561191142564, -0.024172122528274987, 0.31393366456311622, -0.14836532714519363, 0.15952670663431398, 0.063818943851840504, 0.27598657064916654, -0.17986698522520547, 0.40246589404027294, 0.14681640799282655, 0.07588271812783158, 0.1264268557585993, -0.2067694821562443, -0.2603601523750369, 0.10838635800701057, 0.22710443472426703, 0.34571003029275249, -0.25704778337462031, 0.10266729100373481, -0.01970485582170169, 0.14644727391337117],
                             [-0.04474303997231676, -0.029513700028882133, -0.16173306906184845, 0.10599334259541127, 0.047150216913554262, 0.22393663463961427, 0.1016676300864439, -0.050030798127317741, 0.070013426602723833, 0.37282591190677195, 0.16138576066298016, -0.18044196389895589, 0.34838836085987229, -0.0091647973131536095, -0.10325086887137855, 0.1401613966889256, -0.00015640741827286183, 0.0013365149472977442, -0.46424195195988427, -0.11656446299456524, -0.069203593185057005, -0.13281754401420037, -0.031376146074703806, 0.33057255439585914, -0.21220251009788735, -0.11371029871144755, -0.096989871115530091, 0.35685722042842488, -0.036341160347780101, -0.21368729736426201, -0.58138873257688284, -0.11321677500300302, 0.023222912410218653, 0.30101062568306952, 0.12143365316735684, 0.17559364813037326, -0.032140531081617782, 0.2476316930832243, 0.10538654751884285, 0.35860962404735991, 0.057780637380713845, 0.16892742196032562, 0.26036610627597562, -0.16828174095099574, -0.074981508934762867, 0.13981330500897624, 0.0068755698162417805, -0.18519129497926509, 0.031310224056466066, -0.023747516449082445],
                             [-0.16198224173562961, -0.040664323144177277, 0.29051079790487794, 0.13411593757831219, 0.051236823514814026, -0.0072503262842606806, 0.074720607281744594, -0.13337304387694363, 0.051142838998782796, -0.39120244338015059, -0.22245996957929298, 0.0079310327880183253, 0.22392461746090891, 0.19129357790779383, -0.40816669089849722, -0.016896393197424406, 0.19113578213367383, -0.036756261092741181, -0.19119781619081577, 0.25366707694258717, -0.021007549606378892, 0.072822092982943065, -0.024725817159111329, 0.25521621004952133, -0.086315662189305434, -0.065211380380141695, 0.025336818325611691, 0.30422291685233765, -0.067799146510996416, -0.073270233422363995, 0.09224566357899748, 0.10421664006280737, -0.0059529671919136291, -0.16332915322566197, -0.0013652131914504047, 0.4243921014458244, 0.35782508038680971, -0.040083699994418229, -0.37182682573935927, -0.0081199515078813934, -0.0032864722999262968, -0.37741481242584807, -0.1471354353773659, -0.24743235478910797, -0.093301439582424608, -0.054655882521742069, 0.24935507532545623, -0.23099579334079814, 0.0050313291840508589, -0.37848474078745997],
                             [0.1697770448516194, 0.14605140596506172, -0.44098116956016409, -0.21234848790860972, -0.17592770968302837, -0.064740738872111833, -0.2283426573779942, -0.17656265258781081, -0.47130125209576024, -0.02527270074053492, 0.21626169010059401, -0.17208524959246299, 0.17749007531163957, 0.26844290361809053, -0.13168766701813914, 0.0010283901834659652, 0.028902724034442859, 0.25585144931890791, 0.10808465279889395, -0.064977636858485011, -0.11989694258677194, -0.10265962188770358, -0.022900614414094342, 0.38486114753072004, -0.30313083311862721, 0.46769243493112911, 0.1226152771615811, 0.12314300022158928, 0.0076133758369479332, 0.12551433705906392, 0.33822269005093569, 0.38312664008180763, -0.26008669314674743, -0.0472601866476672, 0.042685251815395953, 0.20509120104379416, 0.049690501498481282, -0.070440657612262397, -0.1139383377345823, 0.22251447629845486, -0.22743348675736819, 0.15087614228210233, 0.11083693215242184, 0.22862903862290943, 0.090650904220466733, 0.077774671980767221, -0.24679027963678601, 0.22725080304304526, 0.026209691086379338, 0.045046435958941589],
                             [0.16509905626060384, -0.018353990030084016, 0.18179998208703516, -0.23556577409097035, -0.32796148063236519, 0.18222507489657119, -0.43625039893235262, 0.16127785936439579, 0.35872461379662901, 0.062730371373024563, -0.062800586585141246, 0.2112413706833457, -0.13765053269690708, -0.22034369973710116, 0.2329060062561773, 0.12381042272768371, -0.060893356001137371, 0.17960543958061825, -0.15308132309933464, -0.3029107633273953, 0.24428932393958025, 0.037744817151936755, 0.021127038979635592, -0.12337702850579246, -0.20493930176124581, 0.25356423350803159, 0.016907063934398437, 0.32620621140811229, 0.25396825347117308, -0.10319551613926746, 0.29742633202104357, -0.08802062666685985, 0.060754686125546901, 0.0045478785131828764, 0.2159735971954822, 0.42826892361935603, -0.088567566218446039, 0.1990334335140321, 0.28825917600949186, 0.056461094809991362, 0.034464327848714546, 0.10367626201232127, 0.12105100025346935, 0.12029484004161972, 0.011808870226289882, -0.056904355027353193, 0.2890553341001838, 0.041354388119842191, 0.30540039038211075, -0.22664528040929893],
                             [-0.065217731629743786, 0.18244322333388377, -0.13253347494666523, 0.53911784649068173, -0.20248770526910134, 0.066082470096951798, -0.064915000548596738, -0.018635254137561494, 0.099983428808533656, -0.34461136267151415, 0.10501861938933268, 0.014548066269780018, 0.08016769488155305, -0.1006949750129203, -0.11504224668673213, 0.057850418445619847, 0.097804908606197685, -0.082786134373775744, -0.12882672785316007, -0.14627898192443523, 0.084281125294662307, -0.00086104384334455622, 0.17439337592481463, -0.084678491473840004, 0.25813734992591486, 0.16055198014012573, -0.17257006732024194, 0.17319707343743507, -0.22779276126156447, -0.34804111794322434, 0.29501363969634548, 0.16727936266879861, 0.094892228462587061, -0.0002247044288137684, -0.049377106243002275, -0.053915603751871835, -0.14698335521498515, -0.0089804941409769787, -0.12599171777856305, 0.1578712122045339, 0.046827885855694418, 0.2225035117096727, 0.44175811607187665, -0.26963619188749377, 0.013015615885249548, 0.27355730036443332, -0.25407685070373404, 0.23450314413261658, -0.2918345992817506, -0.192606701209871],
                             [-0.052726237886715557, 0.062241596969159547, -0.082050011942045059, 0.16702725780213018, 0.068194881850196121, -0.27322128118416644, -0.22054527426861786, 0.072761777825223362, -0.058563423460561613, -0.1635710114780497, 0.037248708179998861, -0.02547069389226209, 0.38881401019205913, 0.059317594658966938, -0.090149814066091197, 0.26126819874237889, -0.18073780146490895, -0.11326867781726817, 0.27098525641106586, -0.062411624931933259, 0.2669953711561116, 0.14324763143105063, 0.0026297294164098475, 0.085615383506081194, 0.0055892198629249896, -0.055412705498573397, -0.0069642208903552194, 0.14619512506296811, -0.090110023316948146, 0.35088465955811687, -0.27925674232329517, -0.28358555402720748, 0.32064440335246802, -0.13157705847412299, 0.10964168837863672, -0.1106185325453295, -0.10457371030141156, -0.40186191596067539, 0.13325294995812692, -0.023694273600398299, 0.16670196995020034, 0.13487371446934449, -0.032849274514351899, 0.16463523073658992, 0.17985269534099552, 0.27974263230761098, 0.26101003940367545, -0.054556377623616752, 0.42883825143787918, 0.055983537646999315],
                             [0.22452889418301072, 0.37193375507171017, 0.02176259086529532, 0.26736546246601195, 0.14261355425806727, -0.083786655614299557, 0.34260104740806235, -0.024778258057817894, 0.09399988868515019, -0.15281160325889717, -0.18386462899631684, -0.080644331029355046, 0.025792518248957598, 0.027410163847353983, -0.12141125384878181, -0.1866962018893627, 0.009018774342581375, 0.035981506207692249, -0.28934940491127131, -0.037888566695862672, -0.053023225821144118, 0.20139519121750743, -0.05715823442520112, -0.19721834678661598, -0.40697392324432413, -0.081003806830118361, 0.30255862632766323, -0.17588055811572964, 0.23264575393874692, -0.078653839781131732, 0.1131323381050446, -0.099944320245908672, 0.18068837476901961, -0.092144283642421609, 0.38402632716122992, 0.13846956440537725, -0.25732323921392458, -0.26583903891097815, 0.098818317709681816, -0.11700896347768348, -0.23965521015026539, 0.15794765603734628, -0.19027034456429401, -0.18407179812549787, 0.10019672291278542, -0.027768519188910011, 0.13614137551401656, 0.45960476331621347, -0.11424331910373323, 0.219215985415804],
                             [0.32181870434839882, 0.019980244846520705, -0.25199771566866525, 0.36497880047312742, 0.24118750792726631, -0.19793622773643743, -0.30275588237686896, -0.14016705156827047, 0.012932906677931684, -0.11322842841539335, 0.25711205319029345, 0.051177267800656255, -0.22525776270317713, 0.051759041814844219, 0.1416026555473639, 0.14843828522958655, 0.26207011998621371, 0.13915410123574101, -0.085946368345268795, 0.1828479885917586, 0.042371921014973238, 0.19751341011045856, -0.17910199553306438, 0.066717281059683664, 0.19472527475023871, 0.35237503009264554, -0.010540325877364363, -0.13769481314103121, 0.23256799211964199, -0.0648812692823659, -0.33032792404597033, 0.21014912168713304, 0.1055289920406676, -0.20647969815572714, -0.31311110904159251, 0.12760391898558054, 0.16568739077256731, 0.17405112830749059, 0.050843305772966703, 0.34369847572783951, 0.10216575375068968, -0.11802429610753107, -0.092690698144248573, -0.14012169570544988, 0.090621141949958114, -0.23337474585199383, 0.076853922579126821, 0.10145426454718856, 0.047462402911995299, 0.19300784735191512],
                             [-0.022811717021904793, 0.069924875443826126, 0.14333953185606235, 0.18835918935252641, 0.16126576634619472, 0.21674358987359077, 0.097573791903536072, -0.57953817314975564, 0.38822945396850073, 0.18037854861703245, 0.23124168306684159, -0.091244751284080994, 0.14272429303857964, 0.032373466082517004, 0.062648083031686161, 0.056935502509194769, 0.26734185787755793, 0.014846030762577523, 0.11184254991582561, -0.39205699307314923, 0.11317035815980221, 0.28513119599219411, -0.15473534103633435, -0.14559357597394873, 0.028612409118381643, -0.092621676259916907, 0.12477411401234974, -0.10830699874925503, -0.15785013329943898, 0.11784037740097927, -0.0054591112674569793, 0.056163479077363854, -0.48795200263652738, 0.19288107277699684, 0.11260073187164621, 0.037237933505878132, -0.29130074315938564, -0.015559570963381085, 0.045704203694949048, -0.17791221150382891, -0.029829568541139211, 0.30755958077423917, -0.038371337048922212, -0.074343951496446709, -0.42074563519394065, -0.31767837241879876, 0.010936785333056207, -0.37231231057194952, 0.013501046429597683, -0.23301545899341508],
                             [0.045165944089179774, 0.029819592498283275, -0.11635870085559222, 0.087963550565673815, 0.081801464580862779, 0.20481658188256402, -0.079986503793563923, 0.47985369091869989, 0.0060021922049838181, 0.036358477213255413, 0.031736048030833172, 0.041904653730225554, 0.01664882007864063, 0.083827879837441027, -0.33862517941020304, -0.16315489348025872, -0.030374277450987523, 0.32180767520717496, -0.43185726134001728, 0.4233480886865198, 0.018291944748432001, 0.035772748771778086, -0.14062512238726657, 0.085192538553984412, -0.035887831577010774, -0.26641978416608397, -0.0074602572600966973, 0.021439634561202178, -0.035110520071426864, -0.017657560871280332, 0.057546771934653358, 0.34657189176948355, -0.19506721878859856, -0.15591050385355998, -0.26019897041394491, -0.28064763316038005, -0.10267415722251222, 0.059979184182091694, 0.33351424612184039, -0.09598960148645605, -0.053494613195069263, 0.56169542674766793, 0.06243647496547515, 0.13746494193507194, 0.10364594853644357, -0.13550913093945358, -0.044188385587944003, -0.34147108995024233, 0.21548313692991813, -0.26375797525522243],
                             [0.083075911043089784, 0.42074137494183234, 0.0017151495425228504, 0.14179495739414638, 0.036630168428094204, 0.27145199772537643, -0.18118582420444096, 0.068640581181642318, 0.097748258385872311, 0.1730321334636114, 0.022869787977507029, 0.21073172147017766, 0.12183678923269833, 0.44808244567023875, -0.1233894193468984, 0.048184400896784961, -0.11743977067148829, 0.053543888210674247, 0.3427037549792209, -0.048599556054984852, -0.16271993773966442, -0.45879518872488001, 0.14285223451941167, -0.19684608860723699, 0.31785888630693226, -0.22829105637671621, -0.17388533300649278, -0.021622931920372644, 0.31498025678207558, -0.28384596748244889, -0.013241748497117692, 0.092674042590508876, 0.14060866092412622, 0.13620677102456888, -0.16453986788246799, 0.2370067205628674, -0.11356284909492971, -0.089166153900597581, -0.024549053288345894, 0.28027525398126352, -0.041405011159230884, 0.19305932041851398, -0.28287025327827903, 0.11550890771060085, -0.0071973904761447665, -0.081176346822189438, -0.11206025440581172, 0.0085397794319518622, 0.028747112491066196, 0.11938177504628056],
                             [-0.16358634933450167, 0.35301991095436625, 0.21066976184729838, 0.19194725168882609, 0.1264454564669473, 0.070358539142281684, -0.023456792225014355, 0.043938865723101725, -0.042173926144802545, -0.00088229116127472307, -0.4309071933704709, 0.086147410440180067, -0.38062603127638361, 0.16983451584485343, 0.15638663859945756, 0.17960121233934145, -0.079013607198825872, 0.047914325866911092, 0.27652816124368135, 0.033917691044503526, 0.14356145771796361, 0.022284909167952859, -0.17605783803207675, -0.11099159419504998, -0.37475579236667295, 0.027896310738884399, -0.20457038981164352, 0.0717408653505303, -0.090564507053693677, 0.10236294018413239, -0.23676856007976749, 0.18715341084974002, -0.10398987864032896, -0.12265843036165817, 0.36405016226737347, -0.20790498808237357, 0.15439942418673877, 0.048123450946548553, 0.22742001501137885, 0.21405692303513987, 0.15011758422310628, -0.084390654495012818, 0.3256047638279263, -0.11911897995391106, -0.19765990142631912, 0.083114433634910084, -0.17099571441512196, 0.011106681890298162, 0.24514401946713657, -0.10030299125967757],
                             [-0.4392251383247654, 0.02832759765515349, 0.2406246293602804, -0.076512164425409437, 0.021176279162327397, -0.035811188161471302, 0.065620700070693427, 0.098978536841180326, 0.23814955613881275, 0.30906251247147842, -0.016593284366550175, -0.25724515353441174, 0.10854621879238677, 0.21475743315656323, -0.11293946308297038, -0.043616770988558672, 0.17280305902249329, 0.025403213057116569, 0.034274431191684947, 0.19438376136197075, -0.012975819305786594, 0.21594506794099033, 0.28473022095178496, 0.093486283228246578, 0.12456515810873701, 0.08804271594043131, 0.20649234083377119, 0.10879975981116138, -0.12774277418076024, -0.18568745231417891, 0.12571580091884893, -0.062624268092339425, -0.094451208884622731, -0.36547850308608532, -0.076339239962113656, -0.23631901778844264, -0.24296956694018046, -0.021820087501034376, 0.15018179266240178, 0.36326913291122243, -0.099030801001015911, -0.23429660281515446, 0.074586475275749978, 0.12373357197215387, -0.096246988432911712, -0.36931015356991265, 0.17794598307865997, 0.38225209498036811, 0.083190010863985767, 0.34139405451677451],
                             [0.049171561639234196, 0.33785741072496073, -0.224604122531982, -0.25751651950535659, -0.025342731726051105, -0.033089240712837711, 0.10772733640567414, 0.18527023106295973, -0.15128587413928429, 0.1640025988199445, 0.044106565590580432, -0.24752251070598855, -0.21299139633794301, 0.26576025816625082, -0.22549644292180984, 0.10980580138369056, 0.20259532225462609, 0.23586710495911684, -0.17672700905658012, -0.43465616960906017, 0.28325763514151964, -0.1084793385366504, -8.3002372773684739e-05, -0.027801680538663744, 0.19648299216330475, -0.04002070266047026, -0.14488464769212206, -0.35100784447188665, -0.28625351608307564, 0.1235094853456328, 0.16202808790319964, -0.13654404923448632, 0.044946290751711512, -0.018013786816840356, -0.01655695167905695, -0.16930745573712591, -0.077177259424258224, 0.086078210461353097, -0.054746040722471315, 0.0082311856219640187, 0.10829049625640423, -0.36045049520358879, -0.2062912348016385, -0.10937418360945914, 0.074659198106695301, -0.062314870711929003, 0.21977700404793468, 0.02715332409188952, 0.20056626736994593, -0.51183114425695975],
                             [0.14158928261874817, -0.11995556124195671, 0.23231756332413228, 0.16479634190795714, 0.35130484845942872, 0.11107025877046875, 0.092547162821823695, 0.021238169971994084, -0.20579592923432244, 0.034089514663167564, -0.082993599643518476, -0.28879153843260824, -0.069488811528960123, -0.0014142428278442693, -0.19523111284204708, -0.073251479454920984, -0.041248704611749877, 0.085807467467772985, 0.051794631876074401, -0.11386959246271759, 0.24482812648394076, -0.1753299257315146, -0.1279092079738349, -0.33496925555127732, -0.092335340052864923, 0.28552042242971187, 0.079045687342237922, 0.23231266159118122, -0.20704968523541581, -0.22889072839674948, -0.068949127681070643, 0.038113394216170118, 0.045786181320473289, 0.41490704701747, -0.35716183267932161, -0.29923567575589777, -0.059753753762226407, -0.29455227869840217, -0.33611652128240194, 0.23856890952673979, -0.2413718579622772, -0.073557629095304916, 0.30641371630877562, 0.016140260441978402, 0.19317841222818291, -0.12509976384953764, 0.38352031652873636, -0.19624912082579854, 0.3678448221830864, 0.16188202749419739],
                             [0.014726561643350925, -0.17846157029076906, 0.17504780941861126, 0.16746964756088037, 0.01308124815003683, 0.049123840045226054, 0.059571838382545948, 0.27230977381630916, -0.12853542366339926, 0.061234946895243662, 0.31890074756195685, -0.22638076395710627, -0.16901925638409812, 0.067800659364208024, -0.40062780115271962, 0.073712225506303464, -0.22898528399288767, -0.1249119768766048, -0.085324100383286333, 0.30814576028855789, 0.11779111071525744, -0.20651280809360498, -0.17596740528435664, -0.17524424216778978, 0.14402168681403257, 0.34198983155541596, 0.029078935676331609, -0.28028485478545406, -0.22337613130620138, 0.23858660973152987, -0.005944480894661059, -0.15550556585870343, -0.014586293012588101, 0.038456142361404114, 0.32944639460032943, 0.39083779209463976, -0.25229926072460679, 0.073732203807814006, -0.043854115034600988, 0.13287542117975207, -0.001526817943187625, 0.040650329846299987, 0.043727323168393513, 0.15288768730835681, -0.56908131431864872, -0.058045796284529536, 0.034465128688043106, -0.018682011017874253, -0.13991936877535108, -0.069359515895160026],
                             [0.14088185112638185, -0.28015553715068076, -0.19235187846584492, -0.060047200036742736, -0.15995585081373803, -0.13459277466633146, 0.24813642442814213, -0.14081308076350402, -0.042474422297364499, -0.38907212109955619, -0.004802814438129222, -0.17436811622313206, 0.010593024677801408, -0.19997595221291117, 0.025437028569115859, 0.1983413721259665, 0.077456967716855618, 0.21857069866751425, 0.062827504876728349, 0.03918438671749714, -0.1888101176840439, -0.12493541779721584, -0.19093069354711381, 0.15020094974291257, 0.13111799534280721, -0.36622883676623963, -0.26009863307714648, 0.030845835389378705, -0.24997949751663093, -0.057066975953044607, 0.33152721249613981, 0.071145280536125843, 0.35913760934512723, -0.1795077034557265, 0.21570275792801344, 0.2608810466506713, -0.25948199981099285, -0.10766595894105392, 0.18705601640368208, 0.027392737373294243, -0.18470756597430577, -0.18694202842660596, 0.11923014435950449, -0.28886564325800973, -0.063838545638872798, -0.30189021174614056, -0.26393970504705316, -0.17082466723655096, 0.40953249189154395, 0.3112582779818206],
                             [-0.10474135918863856, -0.057750858458405517, 0.014350852151782563, 0.029266426885243245, 0.056993855935880924, 0.10314737445427945, 0.079303437382124156, 0.09694606981313772, -0.14847824049264588, -0.065864627242221918, 0.36822751822434835, 0.038745966809712158, 0.14676879123306558, -0.37404123777748349, 0.1645392376364585, 0.10168853087783522, -0.1088238991378353, 0.41121067697839409, 0.37446459867683773, 0.10034583940742485, -0.02915832762202282, 0.088884114257940294, 0.042982403244999148, -0.04205041295874265, -0.062197385183543279, 0.066954866602417312, -0.25590648111390107, 0.031945628210781701, 0.063303611007901939, -0.13309921474717473, -0.08524522853469009, -0.049263030153500045, -0.0742826410856601, 0.1615577083869742, 0.030374106388034439, 0.241630799366921, 0.24111771766331053, -0.40514842661448119, 0.23978276962491069, -0.10715951242666154, -0.05078509362164764, -0.0069911347475541397, 0.2543856676377616, -0.097961892691784624, 0.21980467309393112, -0.42364595530500088, 0.22219876143532477, 0.18616113250566371, -0.21904241513866013, -0.42047804377008841],
                             [0.2274850489998923, -0.17037441237976181, 0.15211193501138132, -0.036002894388490796, 0.095307086306028049, 0.17065945485149092, -0.00047110319200744169, -0.11551312463943836, 0.16018779879090311, -0.15835912313733869, 0.03824874333131776, 0.20455509576909212, -0.10425566397553869, 0.073758139369789588, -0.25531037805509882, -0.25788419489514824, 0.069721088509621318, -0.35230408736427049, 0.14892719947677874, -0.030473106014125156, 0.052014220649597001, -0.21187565584744736, 0.33948755269754116, 0.25913465277155473, -0.36039272826481061, -0.058884262377915789, -0.40640960730822706, -0.042512819656772061, -0.0027591749133686339, 0.28825308421196055, 0.016065306932374866, 0.13682459757496562, 0.1574223592128631, 0.24770304896313886, -0.21777621398543465, 0.0023246270602685221, -0.036428569485920458, 0.16792833220795109, 0.20049949848151033, 0.0036246378043383785, 0.36664479888657958, 0.19361886892431968, 0.13786734082383856, 0.11169375190250483, 0.10455133768511515, -0.38099849607153885, 0.1399509458855708, 0.25639872337096076, -0.079923595227707811, 0.083935233390761477],
                             [-0.16713917522928076, 0.099484898153947884, -0.25491344262071447, -0.0054361537883614083, -0.05913546830893078, -0.042435929855716842, 0.10551046293959983, 0.13499643369645503, 0.070788245871988745, 0.1504115104724304, 0.022394334558287141, -0.20468404377618005, 0.066046036111146122, -0.064476722874923079, 0.38209953783265593, 0.18342315445755519, 0.16098815288664814, 0.16827738083943422, 0.023945633849290347, 0.45086952085282156, 0.34279689557725207, 0.21823350710954681, -0.11631987651281517, 0.017433672395141996, -0.35892320923382892, -0.14525077778533296, -0.65914359698644043, -0.24369323748632593, 0.26471576235432498, 0.11710810434833875, 0.25665283287628454, -0.094018632279540215, -0.037478981047405005, 0.10581529159344101, -0.11391454112000156, 0.28837050210701626, 0.086455069288999695, 0.015361408194643884, -0.46731465050941978, 0.025785959790102252, 0.15876854715614264, 0.059468573930494484, -0.06653569646393917, 0.46062064231112243, -0.11387866612788464, 0.15172274766609298, -0.018434498114287844, 0.040572354205059252, 0.061667701080318757, 0.22315294407289643],
                             [-0.055308196337451071, -0.070313745532354033, -0.14619776336167548, -0.58429532240956861, 0.019857286384527374, 0.33327178079957703, 0.28135806332787694, -0.13253876895853131, -0.075269794390937964, 0.11821585062638662, -0.32036207713059972, -0.10735858000279701, -0.042451999331725249, 0.03170326567855751, -0.19555788824850595, 0.23606809358900438, -0.15222534943582441, -0.092053846819031171, 0.12857316375336308, -0.15120483544949953, 0.44817934263516918, 0.04909075409125787, -0.24607644446498697, -0.043079956449047732, 0.11492376651414987, 0.32595929153988773, 0.025629474029346545, 0.10091370828015871, 0.20014851855072877, -0.18390200057351658, -0.2625336042813976, -0.074324522420098446, 0.19169504442890162, -0.36958610704549594, -0.017852954239633855, 0.003786670517523372, -0.21460064892884168, -0.064951677433123023, -0.0069328386942747395, -0.06719678211096447, 0.28376546379053003, 0.044389035741332045, -0.089792579551397494, -0.19815937601696335, 0.016768466456037974, -0.10047132058125829, -0.25075226034157838, -0.089203416292502252, -0.33987943477418786, 0.14107128359329874],
                             [-0.23471190963536262, 0.036340385994174856, 0.13556407476165508, 0.095532548481600338, -0.11448873157914904, -0.082303698315383894, 0.20250987703818008, -0.14842477054004222, 0.19288491803128976, -0.094971225712268459, 0.19643717006315869, 0.61934582634494917, 0.071769659063183916, 0.042809783380481289, -0.19303876619925631, 0.03586148170521402, 0.23008856694698415, 0.19721511509723716, -0.097106205905205814, 0.015597648832925269, 0.0115382039220919, -0.100017270962031, -0.34808947707331267, 0.13866780318196403, -0.13434525849035223, 0.11185417500170798, 0.073389710953179699, 0.0025713422185855844, 0.19937804543818285, 0.088628375831664816, 0.23803426417328177, -0.36187383918004523, 0.4501678583300831, 0.18092329235689891, 0.037482697528704166, -0.3277787150028047, -0.042498252428059019, -0.1276974456471677, 0.20185680866038777, 0.14771813037664724, -0.1843809547803788, -0.22764968356324375, 0.0051211009977303081, 0.15810518038667906, 0.0021319653347683723, -0.059907225290010115, -0.35699437127859424, -0.18868507681146052, -0.37418890717736869, -0.11345559517563109],
                             [-0.050991326262653507, -0.10975918911548971, -0.56333368290425312, 0.14625584788461674, -0.43177908072877863, -0.07541661606470286, 0.020716886255402498, -0.19059906540270249, 0.2599037643853489, 0.076376867308144386, -0.32161308734595184, 0.16720841333202011, 0.032186291446198896, -0.37298928526314756, -0.32175176910961267, 0.062727127859702581, -0.63348527739555993, 0.037296311214228509, 0.023368037848110441, -0.084021308048852467, -0.088711290752466365, 0.028527025079147686, 0.0077780889037724326, -0.12502505158669469, -0.13003222306777068, -0.16587437926075213, 0.049321337340674405, 0.03824363732400303, -0.14566616996765477, 0.15201442665395412, 0.00044396562074057238, 0.047486767396593757, -0.20387496123542823, 0.21618050374049166, -0.15814285409924508, 0.075477148503324085, 0.012154488020059046, -0.19939571320181801, -0.024408783494809405, 0.18533451993688682, -0.081987194276582312, -0.28086308050481279, -0.11774411195023067, 0.086178123526094663, 0.031528175628532759, -0.19001655229728667, 0.24019713148688213, 0.055348784684485161, -0.079720354941726537, -0.02881245332943394],
                             [-0.081420526682742675, 0.074459549976439957, -0.17969156486860843, 0.037841169127277731, -0.045830339864786102, 0.13500161081833525, 0.079732374183991248, -0.20974491430878361, 0.11309113803764309, -0.078298167305587543, -0.069309339973889481, -0.46301735132314664, -0.011857387684946789, 0.34520927342587793, 0.3475829447021534, -0.15023208067260593, -0.14088123592693963, -0.18530119467776943, 0.00043668264485952632, 0.27395111680022655, 0.2998772678816658, -0.090549651498563352, 0.24170722938104036, -0.13273075394381417, 0.02986291784435258, -0.21216367754741114, 0.64028635997121042, -0.016763996209020426, 0.30468748122079409, 0.11184885601356757, -0.10015705201756411, 0.0032797236465132626, 0.33501908705343686, 0.14312018832447765, -0.20353611453938172, 0.10903901589905315, -0.016889630241298401, 0.14755195860562448, 0.15458028221570855, 0.16267515096365945, 0.083961069027043977, 0.12265853093204565, 0.23035677771897062, -0.077737161627242091, -0.043694733648014634, -0.069468956540046672, -0.23636072187432122, 0.083584324773738033, 0.09217320419891907, -0.24503331579827214],
                             [0.074213073357383169, -0.17390786507750677, -0.022306028645646778, -0.097854774034575639, -0.096723321690023192, -0.17461944864428414, -0.1339056363549341, 0.071241391493754372, -0.30241855382078225, -0.045216631531018667, -0.1855397445058678, 0.33647140057383168, 0.03739268968075244, 0.13244810619270359, -0.28361674232502232, -0.48996602634571351, 0.18286247513601528, 0.10168735914879981, 0.12113704103280362, -0.031073076112870451, 0.24261022046087777, 0.46443904469830555, 0.037933129678326086, -0.069995971987604641, 0.36503545229472789, -0.25409585956989261, -0.15028954626140645, -0.055753078050882206, 0.12182057557848264, -0.19032862759464997, -0.11700261043103805, -0.063044954824868965, -0.10143777603315246, 0.39533718303218085, 0.049248097179695013, 0.088194794982184924, 0.049147318740595552, -0.034751647446310978, -0.010536714287854593, 0.1510163789381592, -0.11147636626193626, 0.30338280765750458, 0.17887496529619176, -0.10194985984966609, -0.19486392809069325, 0.035394343818353421, -0.12591286349136285, 0.1445719540153319, 0.19017339190856991, -0.064716775611649999],
                             [0.36512799425992276, -0.0086464715978158396, -0.06333145081016045, -0.036145855483293146, 0.10608576660406757, 0.26906513664166204, 0.1918534850615416, 0.25993321855386059, 0.030500186541935915, 0.2223898639578675, 0.091176665284138564, -0.034301482976611231, -0.0068708980840318078, -0.20334037109842959, 0.17516831315046011, -0.27076766112705164, 0.0779072489656851, -0.064351879526979378, 0.17141964778419669, -0.046900732499475031, 0.10090608888864472, 0.070421924273396108, -0.098572981125121292, 0.17636089368172728, 0.050393099694329729, -0.12660372658551025, -0.027630923122696268, 0.15335937243215048, -0.053678866739098295, 0.40981234629734431, 0.066443703931235054, 0.022044288781835099, 0.061098194374547055, -0.50614330939959373, -0.11723765333031957, 0.026159426404071914, -0.047912969348852953, -0.056712532761341389, -0.31988555212253744, 0.57087686649988845, -0.29013880121718261, 0.099424321184180708, -0.20319514598940416, -0.34805700931240535, -0.13750605625901699, 0.17159143045519096, 0.040045665003396159, -0.094502186012037553, -0.19767637155472936, -0.19263804909429377],
                             [0.41951024913084378, -0.047870840515681627, 0.088342930519756502, 0.093422758656567115, 0.1476614427748329, 0.026332109089605635, 0.27420159912417919, -0.0088671292616193526, 0.088353063446031138, -0.11065830268871882, -0.2158802616913523, 0.030627886809857476, 0.37343319418806104, -0.017227902495968221, 0.030139718608133789, 0.079103383721331175, -0.05124192195560013, 0.1720079679814128, 0.06288367232272353, -0.12684866487872942, 0.099279833475979198, -0.31245647489151585, 0.071597497199466897, 0.041243510034378816, 0.22884681568403567, 0.20893651475751265, -0.16524671648991474, -0.1513654111782736, 0.068886010873090764, 0.12780873245220786, -0.072200193947788455, -0.62291677661324796, -0.59733951211115022, -0.26683101947276944, 0.11789840116790243, -0.2624668250758001, 0.247714410729932, 0.13422820022836443, -0.022298257033196833, 0.0051540955108970565, -0.11218027438937246, -0.070801790216493105, 0.16155379237562228, 0.3244219615724443, 0.27963289574699668, 0.0026446687364386004, -0.033266251752176589, -0.059187808975213842, 0.067109725193758296, -0.024940044346782715],
                             [0.12900910566901283, 0.031258208248989221, 0.10958810275061133, -0.26175987870799333, 0.16405162398825743, 0.16704651760571368, -0.13440430518827384, 0.058127625199645282, 0.36404507694786142, 0.17663811260151285, -0.12819837097355316, 0.099947296635112981, 0.36034439309051863, -0.15063414109288509, -0.22670870526992978, 0.14869920583344731, 0.077448253008252241, 0.26395112498628442, 0.25623293533638442, 0.13267968901116373, -0.089383541956915794, 0.045599501457777247, 0.22325284253762018, -0.19259311115465705, 0.008234360251428997, 0.088223889836809927, 0.25578502951810755, -0.4505793661880178, -0.25505856823134682, 0.11501835034881995, 0.0035224691119868519, -0.084245258389504363, 0.27540485287562683, 0.011832758589316988, -0.1415791929279602, 0.14364534513364971, 0.22513038773468544, 0.11998444447222464, -0.16949970340476989, -0.12318810774956832, -0.023731015369432645, -0.035817188300312941, 0.29615632154468985, -0.30608922992368065, -0.12481614167866316, 0.24217905622170613, -0.29201023777070656, 0.15850684401094448, 0.21743213693149008, 0.19002761829467263]],
                            [[0.20405497247945698, -0.64788721847248953, -0.013087289459636706, -0.10824925335520694, 0.065328192716220965, -0.19696492980579233, 0.19097337115687513, 0.059522341188266915, -0.29619138206375306, -0.084282066995396199, -0.080070315379849044, -0.043353580164981712, -0.17349046043194796, -0.22077083310379164, 0.35921317033154404, -0.13148387840705975, 0.089447660304724452, -0.0078018409992020327, 0.27005836560422519, 0.069011721281556845, 0.0032982780333623077, 0.28809084176942462, -0.2017698702431491, -0.021555529294774292, -0.27801737848630226, 0.01662826241064419, -0.022448271831970276, -0.15753800811889612, -0.060947110013646756, 0.37503063517248686, -0.23411752061170338, -0.053718770136694058, 0.31405606939781211, 0.20264212499089562, 0.11609038618712419, -0.19688876507050379, 0.28456404942642233, 0.040133712853394676, -0.044963169039851689, -0.075786864340081736, -0.084218235672113562, 0.078703908185339774, 0.20784572886566105, 0.10798481108085228, 0.28510223849109451, 0.087914146286118294, 0.29241797097237648, 0.48981624878507013, 0.020819245721823504, 0.0024170154535961934],
                             [-0.17166267515952735, -0.14347841390942179, 0.18987163852925598, -0.013434125605293898, 0.053720370256384396, 0.14098476173945884, -0.17964113556978378, -0.19095941467786645, -0.0071744149323671111, 0.027158257187937834, 0.046841711224136766, -0.34509571950176632, -0.011752724206784953, 0.12744920031244969, 0.51160745139049468, -0.14179181207599631, -0.039542997769057009, -0.065662787155133365, -0.32896397207051647, -0.20183448141729979, 0.23778245249857669, -0.15216724385011007, -0.20130787915630141, -0.10502406066659681, 0.21370685306594786, -0.2074407345851208, -0.31903179546987998, 0.0029600696496804666, 0.27769086397069331, -0.0064023284190383098, -0.12056580766797302, -0.029787756905741737, -0.039909484781477739, 0.070983545467405942, 0.11071647900563078, -0.10158029490500009, -0.12610315764541832, 0.67692737578136786, 0.25524903309763503, 0.1551425211319053, 0.14277789013540168, -0.18689521584550792, 0.39324967510968162, 0.021501266376103553, -0.40833239049384795, 0.055342704112158254, -0.14633325282121634, 0.22027414465717243, 0.17895571919672701, 0.073236834513171797],
                             [0.13309615254478124, 0.30023213158632162, -0.099117311464181859, -0.12395003440628652, -0.26245073844400768, -0.094519220758758543, 0.15679010581468944, 0.03448411479104127, -0.012018857980076708, 0.44690374435318564, -0.1861818187893092, -0.13329071308740187, -0.12597030117293681, 0.31320479287408232, 0.30436897485655545, 0.021772347281880655, 0.082255688870771296, -0.25588326170011677, 0.18408364263617372, 0.074758904096606058, 0.14971611018205999, -0.031256491968573143, -0.14422250048385754, 0.51353556645707044, 0.33962457345428465, 0.11432887927892779, 0.024522605753652577, -0.15378124555698805, -0.16133849397115799, -0.11438816200798314, 0.049379420735902596, -0.54389815799074259, 0.14973936292325615, 0.1004372511941535, 0.14442622644352388, -0.02070817717456851, -0.095302374237557219, -0.23465547435228104, -0.21006058318177687, -0.013964229329649747, -0.13572758898899742, -0.1563315599508206, 0.2829722104269467, -0.25263347478012754, 0.036567175898907539, 0.23860567213039935, 0.28635301734949214, -0.11874043805758842, 0.031188296971220775, 0.29948651907742696],
                             [0.25203100991784494, -0.42775646067053402, -0.12173385470345141, -0.16136733887918234, -0.17511277829033631, 0.04545328931673194, -0.38572752567676488, 0.13311843957240149, -0.032001958962633935, 0.16490664699122623, 0.13376938812243958, -0.31026363721769612, 0.1461894711277168, 0.07369789197292595, 0.080367808311617051, 0.0095480026566288068, -0.097970351326578997, 0.38007006551027311, 0.054508966631470916, -0.45174309693300985, 0.23762341368020615, 0.18119501221069148, -0.030711814832095452, -0.099339164116293441, -0.071573892227983521, -0.14708146888208823, 0.25643519616109861, 0.1385161912045797, 0.17312965744662845, -0.16616019389967776, 0.44705967241169503, -0.17695545659800316, -0.29549110458064637, 0.18202025653403819, -0.12682273247269513, 0.013575136512780781, -0.1058694140485895, -0.062705479507416131, -0.11958186743514207, 0.089536149899601319, 0.028070207684691973, 0.20462025411838025, -0.23109700969498362, 0.11989009798943004, -0.26916114603733926, 0.3342599070817785, 0.049231032393694571, -0.095721824292878094, -0.19726430093572089, 0.20596760507608822],
                             [0.13087632129062227, 0.026984310700673149, -0.30366270936997392, 0.093084868737215901, 0.23067474164626836, -0.13778412324748732, -0.31911149612684714, 0.028436706465473732, -0.41790199689068364, 0.17031961403596727, -0.05100861249441737, 0.18595360761859092, 0.4655261050734788, 0.14913738627965614, -0.055396541494820768, 0.19996606988629881, 0.0039570843924149387, -0.024422078573132097, 0.16476163299285748, 0.16891556605654062, -0.21887355508704551, 0.032104498354671399, -0.023510392341713142, -0.063748555365320786, 0.12632562671107173, 0.17995884940838577, 0.0014934987854423884, -0.097403375329322681, -0.37966548810371581, 0.16697340928407298, -0.10255404444645069, -0.24347048810014188, 0.022683092027021318, -0.27068420304343155, 0.325506864078634, -0.18813676811154925, -0.38325758211400518, 0.043716475396554946, 0.05209991615570983, 0.10093845991262498, 0.22655691951697979, -0.24532061342449996, -0.15213236513719172, 0.63928463919440093, -0.096887978268429056, -0.026853355943536408, -0.34587149505649439, 0.12713013595484524, 0.068470193159007389, -0.13296520676993079],
                             [-0.12874351208206408, -0.013066508606153958, -0.073653442780834702, -0.18519978018372496, 0.17229647270080964, -0.34035835898046868, -0.14598792692928902, 0.018324056379863004, 0.11268172235396078, 0.3327853692065762, 0.30716476507358509, -0.10444752228636577, -0.28675693676635039, -0.063002852257358813, -0.15459055351114173, -0.2595750771206084, -0.077716988042882212, 0.021836850414378481, -0.19220696380468455, 0.19497430464697088, -0.11518721526327537, -0.10011676665841582, 0.095495912653880077, 0.073734942102799586, -0.37975130820507641, 0.028447645426168407, 0.33244284167615723, 0.15173430866364856, 0.051607510406181729, -0.21814882129619551, -0.18004376555763379, -0.075320797137968618, 0.020289464675006346, -0.33275168568657343, -0.20672190102828639, -0.017406952909606005, -0.24244008101781864, 0.16838789823633826, -0.45358021632703144, -0.088747388236617847, 0.14354473147243557, 0.5896171295497199, 0.23241061035685992, 0.1538359015932293, 0.32339548890704278, 0.051600248363626561, -0.017409165464134551, 0.39953611454579624, 0.17389118066317219, -0.12995475793456029],
                             [-0.28176339530691391, -0.086152209021850404, -0.22828033124021932, 0.11415709491414386, -0.25028737680162044, 0.082943644887983337, -0.27145741854285288, 0.079748374656299068, -0.094879945331244719, -0.25214030435831358, 0.47298237778561725, 0.022052886045765399, 0.0067474107606880149, 0.14809788367580254, 0.55381391496549071, 0.17507863588136305, 0.030285019756226134, 0.055699457450333542, -0.097180347899071401, 0.054859548839392397, -0.20324848032406595, -0.27201969588750025, -0.12721884498044858, -0.12834711944114666, 0.40640059631311687, -0.062354487713891876, 0.016910890192029362, -0.043633284642235662, -0.073101056406767742, -0.055161845896933924, 0.10976593684002617, 0.43068010092263675, -0.020250362955691444, -0.013984086912874359, 0.078072259515162071, -0.21410837952597622, -0.28141766887645775, -0.21228417246181341, -0.27409425633708268, 0.046980777048384235, -0.43231304900765133, -0.23890978275607772, 0.1006817635945112, -0.074451606402259257, -0.091172826723817046, -0.2389869969444256, -0.0022862472210550544, 0.15526743117974162, -0.22116852004893026, -0.23831742322271998],
                             [0.40810146696629002, 0.024385032315160558, -0.021919037064995966, 0.25453349622862775, 0.12071333729136322, -0.11784319074953438, -0.22554115060475352, 0.12362022457671147, 0.20409024735604891, 0.084597783056977391, 0.10627063018336286, 0.35101954044196848, -0.13132845168004406, 0.028914365977621998, -0.10436281572996592, 0.46296286293183048, 0.12843595122272117, 0.31610774599975588, -0.20155761212242446, -0.029331417855644987, -0.15619453183007839, 0.070259527263028379, -0.24348163420714733, -0.12618348534760418, -0.19731148134676979, 0.07835638211476316, -0.1120871743074269, 0.039972865287151674, -0.11197455761692351, 0.29293238961319001, 0.20388054403277314, 0.088451752205417344, -0.06644101003631786, -0.12972259970545741, -0.24139951089935308, 0.13869670879105689, -0.24366748857460918, -0.043074408853242374, 0.082636793353762686, -0.068903873985031491, 0.16541228227124341, -0.014041265538133353, 0.39292791716712638, -0.34625791972968023, -0.3892724716973554, 0.085907494390236372, 0.35977948199458148, 0.12837458383799311, 0.25326733893631753, 0.35361535423692031],
                             [-0.058209065047152446, -0.15939936075033986, -0.094795872543312926, 0.057484979270329112, -0.35884643063043647, -0.050097279120730871, -0.050671286735520647, 0.074149415042475547, -0.35675091531200359, 0.21865837729990978, 0.10857148837235218, 0.16253835900554264, 0.46096218364854219, -0.17340625565150555, -0.20238510716798785, -0.089949249079408045, -0.23776616046763391, 0.022194994615013102, 0.12381907269782445, -0.3745230192440801, 0.38454313780164323, -0.063036767004767041, -0.016372048187366726, 0.22240471386069119, -0.085234823570573798, 0.36433653382408643, -0.33697861165971887, 0.11330008620246182, -0.28851302685941577, 0.069357799641016113, -0.3724272651095249, 0.19617030884400236, -0.15934359684221047, 0.084031748159659414, 0.10710366011555139, -0.0056965444300692246, 0.15804607800505607, 0.28666522096276598, -0.17822071833603376, -0.021673516124709382, -0.29264240959476001, 0.24479211965272729, 0.53856831978044373, -0.17517494881668333, 0.058853473616239806, -0.18197496207540487, 0.083091487017489168, -0.22170310605517568, -0.055955310174347975, -0.1304848239009819],
                             [0.13711670636853265, -0.18998528485035268, -0.14565363217258723, 0.032185321316880358, -0.080066774795915271, 0.075263500603581487, 0.26780785209633623, -0.22704129366043657, -0.024229069423366639, -0.21147647426004978, -0.22466903319506704, 0.24514666969160787, -0.11559541269881062, 0.084118726916822067, -0.18563100374307118, 0.18652766821824013, -0.025517324444671828, -0.15940462396616398, 0.01103141300929401, 0.13889223299693049, 0.36247379975183969, -0.050046676216051973, -0.0063408460997425239, 0.41866274793837954, -0.1479182362347306, -0.094265138701672066, 0.033583832185113176, -0.27178271897093825, 0.12684456019582679, -0.31865510670417152, -0.38788980970565023, 0.20283503965208499, -0.45455711950083483, -0.077391090532938203, -0.24791000125922139, 0.083079645178834718, -0.16270837751474515, -0.43491348307821187, -0.072607474588458357, 0.034742664187248841, -0.064889704153097388, -0.058378347579866326, 0.14809419290583542, 0.20687053960593543, -0.54327675373107731, -0.041749031011188931, -0.41291138622336093, 0.16107306388658504, -0.23679869555550964, 0.10093809307221502],
                             [0.25893568634994185, -0.29816097285491694, 0.19372866809455788, -0.30000056425353877, 0.040689312093870868, 0.19739368617936406, 0.095319127318530664, 0.085853317495214035, 0.13506026363095747, 0.016441108835983938, 0.31871433259606613, 0.098635882246940421, 0.18739800203139509, -0.12807050236930526, -0.086554047688345806, -0.099238974493824295, 0.34424392797447606, -0.30442349923143036, 0.096674460517533589, 0.32004619979503873, -0.20026005146743783, -0.25732106306568869, -0.08742880259208545, 0.29663840147707837, 0.42716169440214491, -0.091133930622289597, -0.018747326216411033, 0.35842781127444401, -0.25053056676797691, -0.28402218271988766, -0.045182179416464005, 0.17129724077995501, 0.1885175684608402, -0.058533116997506782, 0.14556147010291354, 0.19086941502801158, 0.23897602684731195, -0.085733969500044138, -0.0306981934404362, -0.23554590396509981, -0.098479947750527097, 0.25061279076587267, 0.0078374106705006476, -0.13972254517334287, -0.30255466999453795, 0.070080704422392975, -0.20423655526872758, 0.048899434866866286, 0.42910920746725084, 0.03015047028587026],
                             [-0.17015075337216887, 0.056229104027187254, 0.45961355843979002, -0.011632306598506059, 0.18724416140672737, -0.21174671970135855, 0.28551729975772339, 0.049967083231286832, -0.45195664551867049, -0.40598613937460176, -0.070406787370786289, -0.021205753013251866, 0.075005229524692879, 0.028582191861045422, 0.16538836985462901, 0.24996234234567222, -0.16111820557850554, 0.31679342950162043, -0.17276801185948021, -0.22803426763720691, -0.074914310160750119, 0.17414581949530974, -0.39352066586962714, 0.015885383474240344, 0.36766110640035166, -0.19022984080880095, 0.022782503284052225, -0.039874384648378391, -0.2771850289720198, -0.30164424678358959, -0.14011114335299582, -0.085264759484019154, -0.055755319044376445, -0.18858580184344736, -0.29957228029474176, 0.046454895704975796, 0.0069984936900901046, -0.14133773895053869, -0.28306559884961124, -0.20308209356002332, 0.28736566002484609, 0.258951374416997, -0.01819448390930152, 0.20146118464759574, -0.039228794925714607, 0.032972881195940801, 0.098532892483740975, -0.20098587232672929, 0.0097845041419449413, 0.064177362414458844],
                             [-0.16566321130982586, 0.16403581147147794, -0.16932151084669739, -0.024144265891913413, 0.10727746329122409, -0.17732582010859008, 0.19957847124821171, -0.044738555400843684, 0.34500329331303259, -0.41567730857959279, 0.21679624421607449, -0.04493499949017167, 0.066997096199414616, 0.40409202143919992, 0.24262567959464093, 0.14779957210637484, -0.095348057058247615, 0.070198306750469175, 0.11281101540231878, -0.16159318504651088, 0.097518194557151383, 0.11174637787876354, 0.5494002448903359, 0.073752901980161392, -0.11625167566184637, -0.039251063574287287, -0.2897103800719098, 0.059070095962865617, -0.45743139791237653, 0.0032759101369394892, 0.018826644092805087, -0.13316631469405679, 0.27688100723128445, 0.020080482686876927, -0.23784356424695824, -0.12286660749873869, 0.015525829860745667, 0.0078976631590474671, 0.14285926645467653, -0.13866633543913373, -0.15798528861260863, -0.1361889653786226, 0.060249938540203017, 0.20955586755675534, -0.13050690983828003, 0.36912741045487624, -0.16495302148678576, -0.19076634782533602, 0.22626069576129271, 0.018715558673678551],
                             [-0.14070017458629538, -0.032886331919260561, 0.093115313902681893, 0.18923545695010432, 0.27350621360185279, 0.15801617774666013, -0.38667765029165363, 0.089959694852016339, 0.0098378830780439762, -0.14668867039609776, 0.2324248211579738, -0.12858536954388383, -0.071253315502933068, 0.20376228153991111, -0.50525395719326571, -0.36860131087761694, 0.46206330931642431, -0.16603576040680534, -0.21012658577733062, -0.37457446365866048, -0.19865036313442958, 0.070018319008789104, 0.005969328070746723, 0.298834273792634, 0.11643201783349701, 0.13798896926163454, -0.14386563838531394, -0.10131242570524841, -0.0065590682629301537, -0.0099002367291620205, -0.22679877899890907, -0.30816269738395385, -0.090776828709366056, -0.372065522903053, -0.043052520215370149, -0.070182157484721203, 0.18477373388492518, -0.046349132588060893, 0.14968707634225883, -0.010935837898508462, -0.34774057035810507, -0.097516000810349765, -0.16930623807612327, -0.099483997409110958, -0.15901374882581137, 0.10300636774797431, 0.31640132737558441, 0.31019493828513117, -0.17782993288796134, -0.15631181261562427],
                             [-0.14177747293464207, 0.035839587157397268, -0.24553448916957335, -0.1246183388203779, -0.32811048557596845, -0.26612525084706229, 0.35079682025873798, 0.24790377268093311, -0.16708486339953421, 0.023408831870034456, -0.15287237434189704, 0.14212852803488343, 0.27907837710139444, 0.085332278733960182, 0.080532764237306709, -0.077504621156160025, 0.25940030512114742, -0.12143272602384113, -0.47977754496066283, 0.21850990030915776, 0.010058094840275707, 0.43765919875791404, 0.010879916989606202, 0.13032080396307683, -0.10985029696081312, -0.06696707543397365, 0.035906117651156137, -0.13202305008364673, -0.34174287598570502, -0.15828267865392442, 0.50233995159867073, 0.063710420743365775, -0.13226122479181451, -0.33194490993362957, 0.32858510206154506, -0.31875009334246862, 0.091071199025432939, 0.17836821483370036, 0.22518467532945435, -0.14547978638321254, 0.047176722836436834, 0.23013623753408796, 0.021452338152727374, -0.44470297639382872, -0.0044368582407650096, 0.1062330867748449, -0.18172282101074738, -0.1434062942039227, -0.33865540695381735, -0.054569790568088972],
                             [-0.22883746360667551, -0.11672631275855017, -0.33678682531680143, -0.3318545125005849, -0.10664069595181185, 0.13464539891868854, -0.13746975028278757, -0.064904819426322674, -0.37919609478783189, -0.36074823514778254, 0.036884763399851153, -0.023810462466207612, -0.37305379513289716, 0.12438480540901133, -0.19612019172279913, -0.20348810000960654, 0.10350240141488895, -0.065247762413551805, -0.10367937028109016, 0.05665992690601903, 0.16431779350070191, 0.004896789106466749, 0.3373533905727869, -0.48601921250527191, 0.19167592755536272, 0.21949268240001091, 0.09086223906607073, 0.25278164176946138, -0.14523419329978582, 0.15954683202988357, -0.27967224329279033, 0.055966630185697412, 0.077996767360349106, 0.065866448604955191, -0.11992121694523047, -0.034602247635278097, -0.068953953660489009, -0.16115641380888832, 0.20219421512318331, -0.10589446132759854, 0.15745785211560667, 0.037874703154083034, 0.21549828075962082, -0.26316517560394653, 0.14068267223994443, 0.0077829206601740877, -0.12159447924588546, -0.16847293391014403, 0.04794526006815987, 0.66092364641552803],
                             [-0.11640717574626712, -0.39536279924369933, 0.0088267746315278204, -0.30059349654664097, -0.015885193499936952, 0.084461365956032777, 0.18052767260912192, -0.33263641444028297, 0.058646248822626368, -0.034003953858181557, 0.19165048924313546, 0.01923126256989242, 0.063486048892990851, 0.35473261109641974, -0.055285825437045175, 0.049852158612280977, 0.084197886604867572, 0.015371063449707968, -0.028077240869522124, -0.14113078041629176, 0.39301079667117172, 0.24933743776631107, -0.26503268030999233, -0.10386259327308016, -0.24545288487719447, 0.3160309243352814, -0.017423646400877679, -0.20877042211761643, 0.29415165876112365, -0.057201787136718613, 0.30991809146052113, 0.090283374007354172, 0.68356009387365857, -0.45053196291348624, 0.1299230195503904, 0.21541437574806113, -0.17890991317844726, -0.047338849286939905, 0.10952453396432252, -0.011234073584889136, -0.24700165810356253, 0.031308639817941006, -0.015134324808236196, 0.2012218446728927, 0.1832929982894019, -0.34191823017941636, 0.010736961678194691, -0.30643284098712609, 0.18982902363298479, -0.027346175668088137],
                             [-0.089575898442408708, 0.23873424355871564, -0.18491424339304563, 0.012172038058635336, -0.21277424776601639, 0.0033255502484040265, -0.14475371871336451, -0.044700151575604315, 0.15214641759424385, 0.020314762484672455, -0.28447306521898058, -0.30177327285194711, -0.0069372491944352417, -0.3865176402497672, -0.046154843631683568, -0.3927597218792569, -0.1525143642682831, 0.37506341290350736, -0.041431970595945708, 0.31064618358245616, 0.028230476253164077, -0.039473605859719693, -0.0072134019705847319, -0.038236759839203827, 0.43075713339695193, 0.1599014652472113, -0.22873931666270481, -0.099950899799616161, 0.0028842129909369915, -0.075730075952277126, -0.073420411311602124, 0.31133944466264557, 0.12274780705375131, -0.18369813396926499, -0.21695953918849681, 0.119962957773922, -0.27682753262522075, 0.022249632876720552, 0.14729977157706953, -0.20761055130707715, -0.23933594237713526, 0.045375585596620902, -0.1431122754635436, 0.2946021875824823, -0.3507364758562051, 0.44587446712689499, 0.33794129558556174, -0.13289259500776793, -0.16300793949673781, 0.0083084237793391927],
                             [-0.4048296909806603, 0.02408980556384558, -0.22230460962844031, 0.074915954966599405, 0.28381008623267368, 0.20814864947611855, 0.043446875457575217, -0.07424223221086787, -0.40317643229728917, 0.22761625257513934, 0.059264675609338568, 0.13468682574640961, 0.078491228216725412, 0.1852195440866955, 0.14773766400229935, -0.2511487834271246, -0.16956633104651714, 0.33363434455288005, -0.13528528820050384, 0.19630402248871495, 0.19771745077568659, -0.16003144100916952, -0.10736382019446283, -0.20069316500791573, -0.13064006899807015, -0.25050806441252876, -0.32430689526692058, 0.12931675156106193, 0.10102540815238799, -0.24757612439233251, -0.23761111837373405, -0.19513623809715333, -0.020078759347607826, 0.22593564242860761, 0.31517818031982558, 0.12224611237426901, 0.035490472822124468, -0.21418206108034907, 0.22524279722470278, -0.016799883481169661, -0.20996948490783957, 0.19405286376308031, -0.28534257363254495, -0.22674775641265565, -0.10663556393706686, 0.2585611118081107, 0.38440307350685426, 0.10722346001916841, -0.027310418916209132, -0.050867715644038428],
                             [-0.56839830263223312, -0.19271289311159387, -0.11393043699298576, 0.33290809647118857, -0.10306909085105534, 0.22729266144470794, 0.17802774391822848, 0.057454243088011267, 0.027227870929520538, 0.15859893234861019, -0.19928822787395137, 0.16896141833556014, -0.22763974404155998, 0.29900832503162472, -0.25166208697352593, 0.14584432028126765, -0.087500330624810704, 0.024135790467457938, 0.60197849908977497, -0.25767320381732839, -0.47679682617983499, 0.11587043818059761, -0.036380770364241366, 0.24727915781668472, 0.11509473932693357, 0.1061266394208517, -0.034177117915910708, 0.041603789627103122, -0.087893342852790476, -0.0919609991860008, 0.20274379108512919, 0.11158572213728625, -0.12397365299160197, 0.12332871161247633, -0.04528917902431958, -0.25910197318921374, -0.098495331814579729, 0.24774698743559118, 0.15881319521628245, 0.1819858141752097, -0.15856554183822644, 0.32192188557392049, 0.061883285981742003, 0.06598527639487127, -0.26965418175136113, -0.13700498721998886, -0.12176918313081406, 0.26752047266574852, 0.21102922553193484, 0.22685441800053302],
                             [0.0015498091651048318, 0.017230539169852392, -0.09720614240527195, -0.16662366555463598, 0.16843677324500214, 0.22109857199532906, -0.10612900647804981, 0.053777907916605125, 0.015125864797867893, -0.048279400206089937, -0.071644982248477568, -0.26162254802471224, -0.51636178097712304, -0.012659253471161213, 0.25935781857834428, 0.21468339720297183, -0.010758592622383521, 0.30113249978167689, -0.33112581031446614, 0.085406706694097376, -0.19918085751525225, 0.30108890840593328, 0.12253484353794251, 0.38047301495528535, -0.25738501335201192, -0.16702217726584542, -0.03250938385196428, 0.2161722408620198, -0.30224122212878474, 0.029850242309589443, -0.11842682204951363, 0.32446911311378174, -0.067214997163611304, 0.20915345677257671, 0.40019797131397533, 0.12199105835664921, -0.03018521873345522, 0.082937931169179718, 0.035466645831488397, 0.16629014357577254, 0.028878329433907231, 0.19426453906299274, -0.041587361049284788, 0.25924616410485518, -0.19194887503775629, -0.131194742105774, 0.065509860472243164, -0.24228237251253462, -0.0043570532073805672, 0.22822490141472826],
                             [-0.084293828476635163, 0.16929832861035304, 0.16809517646986119, -0.56179012748931689, -0.25368897408152086, 0.087754382604676773, -0.050675262370101448, 0.28613170208344602, -0.072726777287319647, 0.24278923606127537, 0.19453585691738717, 0.14190187396624773, -0.22594798886527598, -0.23854927901777953, 0.086815429036191494, 0.037512149596016675, -0.38778502319659164, -0.37099408840798587, -0.2193715642826459, -0.35189919632026595, -0.31345555907757494, 0.2006194050974735, 0.23355379170606949, -0.041968106154491598, -0.18518193910521105, -0.36478590649022763, -0.11582927783802099, -0.17913521161010143, 0.044187389671413453, 0.26932430532834045, 0.094967241322279877, -0.20896711124236145, -0.14886384156825916, -0.051139395641991131, 0.11029841016412198, 0.0012965876376973273, -0.093321015315366865, 0.030000827795386726, 0.19220086945672962, -0.42997310033589403, -0.30133454192690345, -0.21585919976045709, -0.11117092323392581, 0.068618027834447246, -0.28563120625765448, -0.096551292746603734, 0.19449467768383644, 0.14134021955983594, -0.026970399694141795, 0.020082375286302429],
                             [-0.096327513419659172, -0.065922106758149066, -0.084399847952413135, -0.046590983673099065, 0.33110800142686925, -0.15116951611763649, 0.061412767451372058, 0.1567535722552148, 0.24388266211912288, -0.084217237749049878, -0.27794732767060415, -0.45201205180989773, 0.15686700457564284, 0.10066762842068031, -0.082602383433603405, 0.32724278843347943, -0.38969477965130184, -0.21405313307738411, 0.24235991578940827, 0.31310755993458, 0.20501868513481983, -0.096868781049172931, -0.047451240917468218, -0.29741304742209346, 0.10929221396891307, 0.020262382697912987, 0.022809797407547548, -0.064789903403169147, -0.11280892820294586, 0.40016033764469738, 0.21887126109480737, 0.058825401322083408, -0.31609808177611431, -0.23818897444092321, 0.21552540952622895, 0.2054988846229342, 0.13481369210644917, 0.0053494482608608465, -0.18110346634600441, 0.38138961214438594, -0.40842603849525505, 0.40336533364362259, -0.059747444786607019, -0.017164237331877732, -0.0145083103193442, 0.15233385536595689, -0.031072544287967102, 0.096043924996255747, -0.022741121510304812, 0.12714111483471388],
                             [0.34734335323021015, -0.10165044179852399, -0.095025862857092636, 0.18046668798489596, -0.13456710118523377, 0.24948211769394193, -0.16796394959342262, -0.19846156656298553, -0.31402162104778381, -0.4163129204120215, -0.092069750318911597, 0.11285574708877968, -0.21851377911515668, -0.19277763010264995, -0.039822603170984919, -0.031803780482796598, -0.063197482276046296, -0.028268955384691513, 0.14640958046688365, 0.036535049817257984, 0.10236530360144597, -0.51497224282283871, 0.33857791542558691, 0.45825941795125802, 0.04841545170207659, -0.30716905700855318, -0.089401008311304209, -0.19755401026440936, 0.21670477154771706, -0.013212428141908854, 0.33054474610627921, -0.32997948098519414, 0.052906710116803653, -0.33376203347811279, 0.13223447727560705, 0.11318477562616139, -0.085825101077193128, 0.18880462461048453, 0.061728668880061885, 0.058318581332360939, 0.11480284577933896, 0.23822188429487237, 0.11302924320353158, 0.058664320730926978, 0.37624664589136975, -0.12748909571925399, 0.12717430143507374, -0.19242039427710816, 0.12805381346723399, -0.14792891893485183],
                             [0.22282822739942632, 0.030531615846603116, -0.31659626020911957, 0.025882445772832892, 0.21260467360621085, 0.18967339210916545, 0.14893571573996731, 0.027496289223739638, 0.086617632166337125, 0.2020819353783507, -0.21587096658039667, -0.060862563088641707, 0.45540619193073884, 0.26401863029947009, 0.02842150558852842, 0.19509977260242992, 0.16945327636741409, -0.28113169541818078, 0.053899856747163424, -0.36232192767436766, -0.16721958813168888, 0.084670997557410949, 0.38815557569879255, -0.058236011521806672, 0.2742839322577294, -0.26154988787177674, 0.13898136805038253, 0.29278898259622077, 0.38054623020931028, -0.082582339821348313, -0.13259409370012168, 0.24818795582124231, -0.17245548564474295, -0.027945687189218353, 0.063737430352097002, -0.054539266297332606, 0.095843198523552511, -0.11643606309703036, -0.0097429547321169398, 0.041681846910739624, 0.32343632092948904, 0.10043900697354566, 0.28200439209094003, 0.5832171478411512, 0.090997187528816748, -0.16038155662168913, 0.55927532847313477, 0.17903527919271056, -0.059700804148970908, 0.0047037165112389402],
                             [0.2292356577713458, 0.10977279913632947, -0.29788690089095715, 0.25190576213244209, -0.047560337786596539, -0.18912193947445952, 0.031751004259037909, 0.25010315089323576, 0.024196793762284338, -0.14384560068255947, -0.19170698484562454, -0.093737754717495306, 0.2631465269666875, -0.20117209668308991, 0.23374926728021389, -0.51076546013075996, -0.15183340052491756, -0.2713168698305865, -0.17714438229587393, -0.32380784734282358, -0.17556597912847216, -0.1103204238383883, -0.15231678284243874, -0.055879570417028263, -0.1347478722068107, 0.045840804173800584, 0.17615743893948585, -0.018897037856212058, 0.054118068688746385, -0.12029214909815761, -0.10190832025315198, -0.033993014591962648, 0.060658806247903402, -0.093710454188829923, -0.094187243942479626, 0.072755224257602669, 0.097283685098402725, -0.18399626122637691, -0.00082447621945438108, 0.37638376065794182, -0.13882026764495481, 0.10746763070566549, -0.23007971437296518, -0.22806575627129372, -0.23748877944165608, -0.41236885638981757, -0.044057116967160727, -0.068310798860104424, 0.46489642177053236, 0.19583115479224289],
                             [0.19922281783595081, 0.0417945960979152, -0.34673203530866492, 0.11007516680246418, 0.21521346566093599, -0.1495368172105816, -0.049524737769843487, 0.1979751345445363, -0.056378179807024219, 0.057743216533165741, 0.43498162899951004, -0.11568312509794686, -0.073074152211802343, -0.24593805214134512, -0.053625214164560175, 0.45849990338362451, -0.042786169076496204, 0.085939749531097079, -0.15035967432314926, -0.031194886319601836, 0.41576457920965465, 0.12077224341858468, -0.15408557062332168, 0.0021539741543160108, 0.23933451714608051, 0.20782167396883874, -0.04982073268524348, -0.033168287254035929, 0.18001726091137416, -0.22923564742229571, 0.22412804440924025, 0.068447880733901192, -0.21450291474721106, 0.14610270042008236, -0.0093209874142742288, -0.18289827817226836, 0.17372751622319713, 0.17323290429410576, 0.32633089655523317, -0.30467699187311009, -0.037734312054363554, -0.093516454757781503, -0.35002797528674434, 0.053814473137107452, 0.50172086873516331, -0.14787182441924693, 0.022620734065943122, 0.12742251439995766, 0.070334474921156201, 0.39942453315531251],
                             [-0.055365922372111853, 0.05346129327441082, -0.35979237801857733, -0.090014539425706752, 0.156482496717812, 0.080751591234742071, -0.17996401242272275, 0.1832538541109654, -0.10221597061867277, -0.27848453622507452, -0.22350858070476981, -0.039237850982681954, -0.089625693836783316, -0.16011476099950883, -0.24344695816100276, 0.089628798205086735, -0.052150421998521483, -0.11302060947762618, -0.071344631498844832, -0.29576123276234934, -0.046265012338003036, 0.14014891738689894, -0.40605330197004186, -0.014731093915793567, 0.0016991404423335743, -0.0071570738029935743, -0.21685918124393913, 0.234934756236516, 0.14203979622055429, -0.017614330448728996, 0.16628225115701775, -0.34720780461836992, 0.30822044020249595, 0.49417087276573007, -0.081395923798261341, 0.32214935940966205, -0.12056280586592742, -0.28288679109653359, 0.20268394080037874, 0.0036893648116459003, -0.18278405436761164, 0.2016453077489837, 0.36044054548673349, -0.018312929358306182, 0.081275520645094079, 0.12122551743185554, -0.36367495889307955, 0.25097832333539438, -0.098292161199379696, -0.39988858548282241],
                             [-0.2585995659427387, -0.17108346762548712, 0.090806664714664614, 0.26172870305340873, -0.060132693520902079, -0.10371095550657269, -0.19280054681643016, -0.013135731582706221, -0.36278947823588775, 0.15862820416006895, -0.33710152901380835, -0.16572996492088707, -0.0039791266636971905, -0.17226985182881729, -0.18241717097123561, 0.33526291934778713, -0.22781927413445377, -0.24168400032031348, -0.1033741710899462, 0.23003499909413347, 0.1273361411874594, 0.41615394725832422, 0.27203735600853918, 0.043799440709680018, 0.010791288741222727, 0.085625197194287156, 0.090172096927361389, -0.039066398446714598, -0.033946295503239125, -0.25713214185200806, 0.17487027767135377, 0.080227526358755061, 0.064724595515386896, 0.067356429146974095, -0.027496482241682902, -0.21523979363904103, 0.32619321484011932, -0.18861447233834661, -0.17417634751037267, -0.0003769848647552209, 0.17304658098426173, -0.23436053202185606, 0.034871866535102672, -0.2524918172816859, -0.38612302530613485, -0.20478744785441225, 0.17476753271924589, 0.019888819877506, 0.40802697552156719, -0.43943992883410327],
                             [-0.25026253682598831, -0.21479130091975399, -0.074239278836484013, 0.1352178541320862, 0.1412891980387127, 0.47837495216142317, -0.062311837024059215, 0.25222107461390986, -0.066120884374884795, -0.07374420484490081, -0.22867692891459962, 0.020259374581997086, 0.61969436614525442, -0.015571900582872521, -0.17284299430650674, 0.048050267132713424, -0.11873643953140861, -0.022702252176894956, -0.39016772814965173, 0.30361742227950478, 0.076359944520444742, -0.039957508676501947, 0.05462142380478946, 0.3965716549456122, -0.090647417956160131, -0.23080438377393236, 0.23086304814645314, 0.08951234706803779, -0.060740129695799949, 0.14203010638016525, 0.027986949870784095, -0.1361321686972671, 0.41866738569670214, 0.13246736512010582, -0.3562533196720854, 0.26258248551977159, 0.0017858457637143603, 0.31916176287569709, -0.12058865518361428, -0.24988864727459725, -0.20350790034824395, -0.28082773005742412, 0.093320929059664715, -0.13188821740721396, 0.1985996462982213, -0.036346550452022966, -0.16374813493288032, 0.10407544687390788, -0.051476719199333013, 0.44483976349246257],
                             [-0.19372172950893496, -0.2779719078400098, 0.034027376746434281, -0.11108233180242874, -0.17821820224393933, -0.080046096911700282, -0.16960346272391055, -0.078977268156408514, 0.19268840666659104, 0.16316653345703763, 0.036326926759687357, 0.10962596195929929, 0.17657362228374832, 0.039807997851713413, -0.1323161758875048, -0.2653753340639638, 0.008263162551774568, 0.21571157588653758, -0.35597123851107426, 0.10376817430656698, -0.11316139895257316, -0.17658864442105629, -0.10286663614340798, 0.30129438645779572, 0.08362139417399389, -0.28400823955043014, -0.18644593102714155, -0.17676140483769026, -0.25969434864707813, 0.21517812394399308, 0.11933258096054414, 0.042643985336052043, -0.45834123439361329, 0.18649221245280637, -0.017859940852662418, 0.095192110262215163, -0.052968316496966837, -0.31520064931393582, 0.14952497070904305, 0.46029231761691014, 0.013680741809583206, -0.11052953417118253, 0.061660189005652538, 0.23929279274958593, 0.46196152669866047, -0.045381166476135305, -0.011687612033334795, 0.053241974117425567, 0.48029360441243751, 0.04617424619780322],
                             [-0.14131102224135422, -0.39641967293517122, -0.2442242401058532, 0.51548318824778849, -0.25987049174876325, -0.1774140229986092, 0.13788174717953663, -0.42191344281663679, 0.22352626565045747, 0.084587376768046327, 0.051892744024611623, 0.046536568822657803, -0.15115170300528785, -0.1050140374370668, -0.10188621712848746, 0.29399062025153455, -0.2091857751267463, -0.057611555016798294, -0.20298324945576726, -0.085752504556372192, -0.36429970659553867, 0.053091206225831036, -0.072034655811152773, -0.28242370577386045, 0.077325502916239214, -0.35122239288569168, 0.045995763929005881, 0.49458337365055305, 0.14805386362600287, -0.051686985398561119, -0.32451262320200958, -0.26325407661365258, 0.014587877719343605, -0.26715338438376063, 0.23581834362829829, 0.1366757946387496, -0.073057914192259724, 0.074725263030235384, 0.015851991263234243, -0.055761578077980802, -0.19801417716440822, -0.22815411680156042, -0.016990139644522093, -0.096790703682342799, 0.12665134381665397, 0.2252364867227008, 0.039194136433265997, -0.18451596827627972, -0.081044218077744118, -0.064786713315393651],
                             [-0.13903453082867895, 0.15299323215971664, 0.37980106072082431, 0.27168418824163898, 0.069551585219007034, -0.079399888397371193, -0.13708992379441409, -0.52246856146102583, 0.019126436810325283, -0.15437326773423979, -0.077482835600338557, -0.31035926885109211, 0.30671696259756764, -0.17118593772186907, -0.10683159651826696, 0.045516210913623338, 0.19460454445471248, 0.12223225007641189, 0.077032897951328005, -0.19239440388237908, -0.19422250177333952, 0.21383831825416133, 0.22839716961609768, 0.0046007752573201735, 0.043453607874357432, -0.053621261838111833, 0.29716999209549227, -0.30345147634876635, -0.042299903801620714, 0.015345704534590738, 0.047153825816505714, 0.12499243818045049, 0.0004562735289699478, 0.19825121612481372, 0.27258411521240827, 0.21111942129333644, -0.65886154058832314, -0.019341676423622417, 0.009369071427625511, -0.19807812336714423, -0.20469561974408862, 0.15834631012188008, 0.078640602210478777, -0.32707146416669841, 0.037379365872451192, 0.013527814024300847, 0.13562866909417254, 0.2394307883452946, 0.17580421016739592, 0.16306459151439495],
                             [-0.27769552906293576, 0.23397822892618472, -0.096146537297249049, 0.025293250535298337, -0.027671978576123607, -0.20051523299908572, 0.084491713513456232, 0.34282070585130869, -0.16159517523386827, -0.11642345099172959, -0.076685556668472765, -0.23311749997984232, -0.038664571455900902, -0.36574891525005421, 0.0088443742924823494, -0.033213254407361253, 0.56616197265563917, 0.071318517779309587, 0.33938533245928126, -0.023946720882630466, 0.16804809815403526, -0.013576072641611012, -0.11831954344482937, 0.030439650859224031, -0.50392787118031424, -0.1146136433723568, -0.3670564504445431, 0.2980639895475331, 0.22625019334073035, -0.0067054980738879381, 0.1383326401140717, 0.10318842958356908, 0.00018854325466123589, -0.27299099839168439, 0.33618676661228303, 0.21661865661898932, 0.12201420898679578, -0.086729084449913035, -0.38834177408586923, -0.33090787107320363, -0.11551720201846113, -0.41117209454186382, 0.087939684657715705, 0.17891407570847434, 0.088348771971858142, 0.13992253684459247, -0.068675438910912948, 0.087685471520683914, 0.16213860959233867, 0.26999931070523642],
                             [0.03769489964572182, -0.13798927393307042, 0.088203709546315859, 0.066872812510139851, 0.032326509970996092, 0.22730943736521542, 0.19672075503021005, 0.20722170060168596, 0.18792706043570565, 0.11446670212445392, -0.35584085861610826, -0.12424936812939838, -0.16515486927807022, 0.016024647300925277, 0.058798494321183344, -0.010955863672611083, 0.12156452301105754, 0.34240403713083273, 0.10093066223178396, -0.29956424324124054, 0.24918627122364698, -0.1960231397594393, 0.028115676691249841, -0.205535990127069, -0.028797155016310777, 0.050945546432654268, 0.51608084172987401, 0.0039408094133596694, -0.52431530163319229, -0.34606680186926353, 0.10938784794815531, -0.13734839265716928, -0.13570436612770001, -0.20205588384487561, 0.30021988520570941, 0.280425371820196, 0.062780858064323111, 0.0022879573228420779, 0.24814342687209401, -0.23811253589548256, -0.28753197038024658, -0.32652094230884876, 0.12383677632875442, 0.18152013256673, 0.058928111837412811, -0.23642270025966483, 0.12572053875312728, 0.17024529351655021, 0.2312795759940881, -0.11033191354980698],
                             [0.20056102245053284, -0.20997271587627939, -0.078909885791844894, 0.12218101519726171, 0.062308368567242263, 0.082404639229667842, 0.093782600887145698, 0.078745433629270806, 0.10230458931564097, 0.098374268978487917, 0.017090265997278788, 0.38965019071439894, -0.18173889695415529, -0.08671913442474713, -0.18441324177627008, -0.053348629640218276, 0.01480813103857718, 0.042716858050566131, -0.047168011365944854, -0.0019144494699028843, -0.14510728140396179, 0.37980483325904851, 0.26766117760692398, -0.49315896165797313, 0.33551659602148765, -0.040440792823428606, -0.29099707078172082, -0.55659464187385732, 0.038338107626868428, -0.43850406923974861, 0.13617172798268457, -0.21394610356541885, 0.10433906617055064, 0.2887951345339847, 0.35143158787356837, 0.079488906036241397, 0.039422076008989025, 0.0085340786302787065, -0.53506962025846361, 0.19782117197087531, -0.077194333406803928, 0.045243601371686988, 0.21470678968435425, 0.19005663999373096, 0.0032568664074074855, 0.13549873352010722, -0.14337189578806428, -0.24068576340355727, -0.028541666154818235, 0.23403610174916462],
                             [-0.22107352294690394, -0.46541279531690921, 0.087142638920996496, 0.10560946504099805, -0.086395059719983749, -0.0093142342178652617, 0.26005810967097887, 0.47496113133748008, 0.2765042443747226, -0.0068193993349292825, 0.1337490531096335, -0.3804130297242771, 0.14095759350164064, -0.34096881112473543, 0.12279183889235247, 0.23473743316693699, -0.0096749368515765006, 0.078958028672595298, 0.020294912711049051, 0.219053439989707, -0.052824690956448414, -0.028328454680861523, 0.31561343638734762, 0.0060883178526754678, -0.053480410079034438, 0.1957985757128867, -0.35029088923476304, -0.10044369552824566, -0.13417190379335148, -0.060251365969434235, -0.19404851004854864, -0.42658868094057334, 0.0035463559606056794, -0.081617499192227716, -0.0021486687899979328, -0.12746403597869319, -0.38991339132488961, -0.44223613877239765, 0.23953965437032387, 0.19234497826652341, 0.34543284691919462, 0.12247504782082003, -0.045981512114441139, -0.11815770613097472, 0.10830984749359208, -0.23918996598969697, 0.028925255703887261, 0.014813926719011966, -0.22073161398683006, 0.035982225576097968],
                             [0.15325509150414954, 0.20862545852427122, 0.11618633169727777, 0.067207760089418783, -0.11863012752749658, 0.076146372862274325, -0.29023650058173189, 0.19022820260078846, 0.15561385059568414, 0.051345259849661026, -0.050117809494376303, -0.20467383738107753, 0.066390255900453193, 0.37354292049221999, -0.23152271763512075, -0.25550529104704284, -0.43163639151975469, 0.33040091785942044, 0.074360202725222216, 0.014213982488728551, 0.1682821278218859, 0.18772241737789813, -0.1898480950679613, -0.016790618937861504, -0.16077933907229081, -0.5538085710228714, -0.19823946868563419, 0.036083735652334893, -0.089163272144424197, -0.16268052375434006, -0.043491501971097302, 0.12302166948691769, 0.45483047788380648, -0.27098272379746274, 0.2767716165592875, -0.43879321716604885, 0.20039618718233015, -0.37113225265540162, 0.11459205993253835, -0.14365109107086682, 0.17476558916591811, 0.0045703028954058589, 0.046578919664811091, -0.16774560285330742, -0.067739624240384821, -0.12296252283418495, -0.30990145302729599, 0.28103835037047714, 0.00037067674242159676, 0.14236496704540424],
                             [0.16983479559563974, -0.092240999234298571, -0.27008374911719069, 0.053751405653647985, -0.13172810010050032, 0.48975190574663197, 0.011658894343927535, 0.052285316837771198, -0.079379732316779777, 0.18773431407159458, 0.1047273809282997, -0.4651349294253988, -0.050083099339462395, 0.10766643144321261, -0.20920537395378225, 0.11669574859943878, 0.17843138203498193, -0.30170590366031858, 0.041705020052491798, 0.037616723102372462, 0.017303607072658017, -0.052873280893833453, -0.42632521595975315, -0.27390011960155625, -0.39224149236457867, -0.32141596671115147, -0.096083302050140679, -0.30223516634305386, -0.23743148712820605, 0.23860676397840255, -0.1776704599463865, 0.011281613848263343, -0.15309024290137446, 0.13729032159121241, -0.21836537003832579, -0.44595714022773347, -0.16020957744754005, 0.17478776541074018, -0.05386701753787234, -0.23857445049942216, -0.045395792878643842, 0.20576199504015774, -0.014712464455157699, 0.14982149488952981, -0.074413059216201047, -0.15958826353236666, 0.16405520552092445, -0.37839551254346587, 0.25799988875130581, -0.16779589542350071],
                             [0.1414167020523748, -0.21200206272863892, 0.10131385917551912, 0.030371271731095526, -0.00076685506676434545, -0.00061763118117650652, 0.11097293485682269, 0.26130678499734505, -0.29749028419840673, 0.48795820658879935, -0.18768156619990056, -0.31590674407938657, -0.016427960908830915, 0.42436953012981732, 0.02443461697592789, 0.17132121721338828, 0.0029626864974762867, 0.10113152659178351, -0.23720093572254652, -0.21909177306211086, -0.46223411571675582, -0.52533696600507296, 0.029815364384854395, 0.070709859937559044, -0.11226178237514362, 0.20315362940237289, -0.32933930182130755, -0.20668248297214628, 0.22089285766669639, -0.14908352131188587, -0.077110947081096476, 0.29825174661707882, -0.050177436131212408, 0.021662326398277372, -0.11402373628220992, 0.26504732754056309, 0.24807251021035812, -0.069414292626274632, 0.079049564958878493, -0.097810484274655218, -0.190897402628744, -0.076910679418177308, -0.040804037016913951, -0.13724743154078356, 0.26113160488570702, 0.22965882640712604, -0.32074195832945829, -0.10134326635318108, 0.12406989629029723, -0.10770370420272682],
                             [0.020556010914483655, -0.010280638794445768, 0.048930288093523733, -0.015562756264479602, -0.29001822831213941, -0.31540145905864625, 0.11493819972489319, 0.61334356092938624, -0.39346486611079018, -0.10535353076557244, 0.2698640626060379, -0.10412230000423735, -0.04373101421835638, 0.24487530387299111, -0.28212749207741306, -0.03208286353374569, 0.11078071327726405, -0.11773433009365337, 0.062224693653127883, -0.11603602463566508, 0.10676996969703567, 0.13692676565867454, -0.032838160596107967, 0.098317673661035956, 0.029886079105340965, -0.42526735239001823, 0.10985458509188804, -0.10259259491527127, -0.15696515357655033, -0.17837223185265694, -0.12454084302423526, 0.1726038496308743, 0.27524184686384551, -0.033386255677379434, -0.055714363120676694, 0.32815497802101679, -0.25368778977378892, 0.18198348582662735, 0.087623640166119066, 0.4888641234688148, 0.12507257670420485, -0.11658553471202356, -0.23936344416716782, 0.02824730944192216, 0.038664401851089998, 0.12027334112751782, 0.22141527205573011, 0.014922339674085537, 0.069236193431356799, -0.085615759639085701],
                             [0.35442057246339975, 0.10668502149386645, 0.37193477998869434, 0.2372273353795154, -0.45715461201460322, 0.34690368122656351, -0.12843866582346017, 0.27309871647219713, 0.019726698912407394, -0.28098341395882104, -0.15601394136546298, 0.18638220770579966, -0.020980899183773175, 0.44054180690495331, 0.13524545048541622, -0.007492195160268022, 0.029700925679180826, -0.010165189536840348, -0.15304904192145624, 0.25498957946622275, 0.12679174230613344, 0.43576813349874954, 0.099623156966514706, -0.064250931723404486, -0.086730753876345726, 0.20400206381456243, -0.076460890511716242, 0.41132001759685149, 0.16967342770773425, -0.018644546046975845, 0.0090298366882802707, 0.024539418980978271, -0.29892525528376568, 0.09811147902111364, 0.071060848987476222, -0.059063743688243464, -0.26303120587816059, 0.14774669648780817, -0.23901470263987368, 0.039838370299186243, -0.32673072947092768, 0.18403944472589676, 0.021777283749959877, 0.10006420815722679, 0.25518042226246923, 0.13222991059392325, -0.02874614830827359, 0.17602122231176862, 0.23245146561769672, -0.16304603715768309],
                             [0.16553393840503211, 0.2095047020552907, 0.13251404182963086, -0.0024757215066811868, -0.13508678454245368, 0.38483536472933083, 0.085930631917674916, -0.37072259334890789, -0.27516819420899374, 0.38685574404224471, -0.012847240901731571, -0.031104649149580971, -0.097574407561011739, -0.23796386596795654, 0.056736431825508124, 0.12427168845561957, 0.2410593133508584, 0.0016433633864887695, 0.12887864593900059, -0.093133338297719026, 0.12369653829028837, 0.12021127430200684, 0.16309339578163187, -0.15024937902150926, 0.20514660023589659, -0.26357246530285722, -0.27757469273022689, 0.26505570455531213, -0.30946610329489299, -0.13809337024339613, 0.24294462081117474, 0.12111185032307832, 0.17162983811347116, -0.30143807858791172, -0.49194573397701169, -0.11810093538765717, -0.0086442798666901896, -0.24223004528042116, -0.0098631342748487262, 0.4610930649372128, -0.12588443083688552, -0.14508637525769788, -0.11354681834666769, -0.21389788508921981, 0.2698298450350754, 0.033684428899490026, -0.072529336797161392, 0.40287519864508287, -0.056094875953746348, 0.11936389496067847],
                             [-0.12766278585978408, 0.066265712725997822, -0.077811924991849399, 0.11013413413353565, -0.2815989433735463, -0.043926058779704624, -0.41875296861494449, -0.0038929266851577236, 0.21660973143981466, 0.24306667541196408, -0.10417077656979983, 0.26993308946926736, -0.090879788746788814, -0.1302119930932141, 0.15137382272321673, 0.088485044829430481, 0.60285445121915948, 0.20677586106122678, -0.046981044332880091, -0.019410629921927831, 0.34853125920378281, -0.074690247897348391, 0.034822499537117149, 0.060519427873950885, 0.25845627739970883, -0.20011134461042746, 0.15019399764696681, -0.25909810830760432, 0.27578278725035021, 0.22065463280183575, -0.4799473539596959, -0.1425873737885946, 0.17090369158507915, -0.25813937289666844, 0.11667718218983233, 0.24445281963658455, 0.17669427663528561, -0.080959795420646741, 0.13801442557370255, -0.10958361400633788, -0.01529062494999562, 0.35834982600390308, -0.059750684393858063, 0.019613310290417248, 0.12665598354650048, -0.05375397955691099, -0.33506392497615378, -0.0065843390870776366, 0.14125795636830368, -0.10191603065554426],
                             [0.099713387559419844, -0.26754258314358592, -0.21863761068374987, -0.21333910568197359, 0.33586393036988088, 0.074357951239100481, -0.063557006996361798, -0.0054128611033269656, 0.25260761836983048, -0.18361201884514772, -0.32158246571104854, 0.16033633442864645, -0.03814288478463837, 0.011095015040342056, -0.0016461820105470584, -0.15014379137246131, -0.049859730142554091, -0.039934329447735874, 0.206431315574653, -0.15329515700383786, 0.064571839618857804, 0.33553363448083134, -0.03342623635743807, 0.051231191162366269, 0.19481778933863628, -0.19536621001932233, -0.50050978576870919, -0.07298855622844351, -0.07817766330456484, 0.12491096197065146, -0.14859380879643014, 0.17327813754371335, -0.37334648036928164, -0.11787627624062996, -0.026550410246413272, 0.21078940434056695, -0.33120413864920872, 0.45641454302511986, -0.37900017197884017, -0.11897852416054322, 0.17649535512277115, -0.16851452222520119, -0.3766024926133697, -0.49944176329292367, 0.25235339037741844, -0.069139887673727571, -0.13203144120808225, -0.00043212094197181807, 0.14130111481036928, -0.23249202343399789],
                             [-0.037349738263340412, 0.11787613730631191, -0.25642393696206905, 0.48447423463181671, -0.1497763008274422, 0.29455338648583945, 0.233819669704764, -0.1476203433384039, 0.064711932656770055, 0.017778350150376085, 0.51004961844091512, -0.10686045275726326, -0.22781073617092309, -0.026283387006387885, 0.27734585291045832, -0.12992034633751112, -0.16978088949980014, -0.21875376399201379, -0.286140242275221, -0.1928260399091411, 0.31105825695907108, 0.18883154948995953, 0.060014249980792196, 0.052007568012336185, 0.078254867832685537, 0.2131935453708238, 0.03019598800023271, 0.0091464159639208648, -0.16855345967396024, 0.40113246162707444, 0.27994436960834135, 0.25322099434564571, -0.014897441283345442, 0.026524257548882386, 0.16071734203088217, 0.50123569758738429, 0.02709713314747178, -0.27072425697164659, -0.30244219150097285, -0.21003905554466348, 0.50899907639806563, 0.17079977906122729, -0.10458550959628153, 0.14255799596683894, -0.024630754377771142, 0.10367732078896369, -0.084459771775284673, 0.11799841741796432, 0.15018059253694049, -0.12544276095994905],
                             [-0.14600389898230429, -0.012349894629518614, -0.030046190309814067, 0.099876448530622941, 0.30086208323490099, 0.27905248981159858, -0.12366644175801693, 0.31711085950586038, -0.10409910008816313, 0.24821929376123103, 0.13599257408875692, 0.12684429768511726, -0.071710923023391521, -0.21198104222923467, 0.24575311820531004, -0.20367874231193417, -0.2556767438780847, -0.025224097788072396, 0.27325416367254335, 0.083180242109432104, -0.10219084322978336, 0.43725852243939695, -0.14320268916033699, 0.15673796044159433, -0.2214092464273846, -0.07389585203059619, 0.43471075617029292, 0.096204208017331247, 0.14792214880715723, 0.034556071998168021, 0.038617647279296279, 0.055535457184171702, -0.23092952317234389, -0.33345781428478299, -0.13588380579056156, -0.094208004268519302, -0.010807893663623048, -0.088469562764143264, 0.39934884159938627, 0.26429073598421288, -0.12466589236540075, -0.29574114223214126, 0.30489735279595281, -0.16857639885592479, 0.060265683753174981, 0.44598801290781309, -0.13215239651190672, -0.42127833665334907, 0.17507035833679996, -0.22876762219368366],
                             [0.0074426910327035425, -0.0025051958621763321, -0.15384194499986253, -0.18619426492819094, 0.011274621417570348, 0.23634496006980701, 0.26608315894966583, 0.15205820976312656, 0.22388272027085038, -0.14896523355210695, -0.20531572205860346, 0.14317105332657937, 0.076673477788950312, -0.21251507580920131, -0.022985050183942458, 0.37301363262125575, -0.029300329925749932, 0.17672049876874737, -0.06613725085265719, -0.42814962492850162, 0.15670661786312837, -0.29352696899985314, -0.14954017006627668, 0.19347074073598397, -0.049428015915945603, 0.17724218718295501, 0.2891753724653362, 0.053610135743061178, 0.22905908242296885, 0.12729962067974948, -0.27303761892093026, 0.15481118274866318, 0.1752486261201045, 0.014773027485131596, 0.2999044547572729, -0.4828856240471156, -0.25132701316878969, 0.037135259067995655, -0.11456802479846698, 0.27620388342402424, 0.22003438165749567, -0.049957470256624614, -0.17980129844109166, -0.072559638112689714, 0.034897335142805339, 0.53742784071215599, 0.10545555098384554, 0.054782971058178177, 0.26970096457269871, -0.24262032208642062],
                             [0.16489643725482794, 0.10459806166757843, -0.08653049843545442, 0.11288263513989286, 0.037573022305145587, -0.11878018726849784, 0.62139573949235494, 0.17324523990973156, -0.19727733694055893, 0.17101661705245796, 0.12498173056908352, -0.32400815738471211, -0.08059984237572837, 0.038355408529349204, -0.10639788466420499, -0.25511128371905967, 0.1162969086150086, 0.73163434785006087, -0.066568636833234607, -0.14870115807538486, 0.086310452628788739, 0.14454874519133451, 0.42769351375923814, -0.048717210201295082, 0.24767039245400219, -0.12087183751176844, 0.11701075796609996, 0.18890978460819188, 0.2873010494983364, 0.47614660765431305, -0.086213054939835415, -0.19185473953146492, -0.13475942235266916, 0.024410797134486566, -0.035292837572589324, -0.17666714667592637, -0.054847594504321001, 0.05136288096620191, -0.12514288974549531, -0.023744464098381081, -0.18332548418922445, -0.04943485736479096, 0.014063397309621422, -0.18232554780347818, -0.15071052320629896, -0.30695623769463409, -0.31274532073174366, -0.025380246850287547, 0.086514065467694981, -0.22926717022664156],
                             [0.042330773641789055, 0.23890456095290513, -0.47437558221450543, -0.46782625639913811, -0.26369503966609814, 0.31885472353274169, 0.0929142476350273, -0.090888864217451432, 0.012021265292297724, -0.38971114621913416, 0.37489146430035142, -0.2881116196946919, 0.097149329233165035, -0.087709204036776012, 0.025749821012353825, 0.22196738445325098, 0.07854409202287653, 0.43157310679402994, 0.19791247392181543, 0.28626229959944738, -0.49793305182628811, 0.23238047579396531, -0.14359819298131157, -0.090605168767458513, -0.044740057877621857, 0.066914043799522718, -0.00061179598532597364, -0.059561116997270187, 0.12125604320379957, -0.1424116307004499, -0.11210064870543018, -0.15067839696500532, -0.16462666964298522, -0.011306521325344434, 0.060393870536127214, 0.2069835472982712, 0.44935591981641898, 0.23886398348857127, -0.056793005767433229, 0.14943171528691604, 0.088743376469962457, 0.00051628277061149287, 0.15181899116236611, -0.27592379938404699, 0.0033440602279684369, -0.13347989912260716, 0.093440466893029706, 0.14112178074121051, 0.24711962092348641, -0.016146330698880239]],
                            [[0.0043568468598773457, 0.32474818475682227, -0.24982050866078326, -0.34358742186879032, 0.0033099340323339693, -0.25469442268795695, 0.10284052458621844, 0.29830257907069052, -0.43693591025491985, -0.21291218379145621, -0.033052835034628802, -0.12794483584122152, -0.36240559059041438, 0.056565743390712492, -0.093554668715201933, -0.051340922554911218, -0.25871286457723874, -0.15643966547401375, -0.24118323230606803, 0.069874684036371981, -0.16377684212385543, 0.037366263640034203, 0.061692849989219152, 0.16006947599550722, 0.062452145644640494, 0.095826830790316037, 0.52327646625249069, 0.22666322759103974, 0.13950138690582994, -0.33949693120741464, 0.16604079147171288, -0.31592685616185628, -0.11359595086147709, 0.12593140421494026, -0.026793328830042346, -0.24511600929403884, -0.061190567980257619, 0.038871361144317912, 0.1046397653951204, -0.22693284096225355, -0.00021170868456581648, 0.21000522692266752, 0.029292210197259042, 0.32589250214628229, -0.15776312537292897, -0.0092929145671532751, -0.091141825598867562, -0.043855974313134288, -0.24372586139116742, 0.21149158271856189],
                             [-0.11071678049431123, 0.33046632920007923, 0.10081394773304175, -0.3166616656336092, 0.23554834643652239, 0.14508899521383506, -0.10688939693912432, 0.20201127721651413, 0.05515412349553625, 0.052532414612480614, 0.18659842929410508, -0.029962404545734178, 0.094243803283381111, 0.089540566004728289, 0.19894349115988499, -0.3535188411033372, -0.18674758352461865, 0.016317996402577042, 0.076784471871186949, -0.068093426517812111, -0.34864733459706571, 0.14037912034769068, 0.04254216521629918, -0.17552604108101227, -0.023790084918268065, 0.083904798081977539, 0.11470938489427601, 0.25870645040060053, 0.17224633599237743, 0.053574458365351033, 0.16478205666022802, 0.27391960713545555, 0.46597251732852224, -0.14081142208721087, -0.02491623094479474, -0.10230992007059186, 0.27315772214853035, -0.17997854203340824, -0.31709972512008755, -0.11535698945620124, 0.025941282537927143, 0.28937515674626063, 0.36335830004824121, 0.020818130362315418, 0.37439491624174759, 0.39948839323136776, -0.024904837449218849, 0.089543038765549962, 0.38618172998393674, 0.078373162200095825],
                             [0.52472909902841436, -0.51667416383479592, -0.12542726678734173, -0.35544320518555678, 0.21938596916677783, -0.00089436670980347181, -0.10436727893731138, -0.29131902493084294, -0.070430763232930266, 0.13580460124925905, -0.31994058882733961, 0.15958742456672484, -0.20121358205180001, 0.10123809603760654, 0.085863596875882825, -0.070000385811127011, 0.097274102107782728, -0.11623149634971269, -0.22435881412982361, -0.19291640142878144, -0.13275284995950126, 0.1619371219455944, -0.1516865676687072, 0.19085068364721433, 0.022554533655168924, -0.17936769043416789, -0.040432772834524705, -0.087971008732292161, 0.29297782016381724, -0.008462812261533826, 0.27934949483686228, -0.14659154841659552, -0.09268167108386266, -0.23349525669619392, 0.37380627815435308, 0.26243324463165668, -0.11913798178412742, -0.33864249471413793, -0.32623175050266906, 0.12088937067888605, 0.062231140598188385, -0.22425216063272951, -0.29288444336895958, 0.081259600182015057, -0.098885104370590296, 0.24158573322241086, -0.048550930751502235, 0.056279312304900179, -0.14537967885671033, 0.01144501389241373],
                             [0.053519512556847677, 0.19044719268007426, -0.10433777699432764, 0.2436771782213791, 0.081191173692262655, -0.5268611494911728, -0.30937116387298058, -0.26310920607837729, -0.20278194226445345, -0.049075846154372244, -0.22532547504209871, -0.38959545691374947, -0.038238478776019991, 0.055011679295569695, -0.012117583885457594, -0.21549249083055014, 0.068594153890588511, -0.066120643831375447, 0.34007721573410593, 0.09280463811656682, -0.24613639978046736, -0.0026898720680547435, 0.12106122061739012, 0.12567006647833193, -0.12661388727553391, 0.02294674083331329, 0.028875708202083718, -0.19375965997320993, -0.0079561477098299589, 0.16246207006633165, -0.068352770294043408, 0.21511116520538937, -0.0019413364856645868, 0.061352573977008287, -0.28584977237766074, -0.15607339586854754, -0.39370748104825476, 0.23716928517098643, -0.12369978055958294, 0.31357849534804816, -0.10894494051656539, 0.30749551721449447, -0.51941009199948662, 0.23742636914357729, 0.1820085572840342, 0.38811333328185266, -0.10912016552947888, -0.22961216683925773, -0.11821752942022772, 0.050637655930205139],
                             [-0.047784866075610076, -0.028075044614853099, 0.04595624466586079, 0.080308568968422339, -0.0085666605153745246, -0.074409128379365835, -0.12368885467011011, 0.15180547240674683, -0.18171353523399575, 0.53209116830576186, 0.25036609496899837, 0.24774621384012283, 0.34017896205981546, 0.2626613585158713, -0.12649270174411209, 0.22589717133552045, -0.030531935268424279, -0.0065161409952281951, 0.23928378894113606, -0.48843300841682852, 0.025350658696431255, 0.29481908382731803, 0.27442060687667674, -0.0059630922780831846, 0.18033048312762412, -0.22262838058873535, 0.25368167234896655, 0.17724715647242398, -0.00077830652268130393, -0.093797557052593641, 0.10327124759434046, 0.37678533639270118, -0.32909440746654728, 0.045029775639334871, -0.18479295481363742, 0.3166202778123956, 0.031183857944091731, 0.065867659959396085, -0.11435699952252103, -0.0050650903527333369, -0.079286483409428343, 0.24366219358761981, 0.12707395518453662, 0.3199880776456398, 0.011897028459249573, -0.24075841975920512, -0.35588419845070496, -0.1008278728371222, -0.40420538467637829, -0.083581583431143136],
                             [-0.2815126737441816, -0.145686318533786, 0.030372988610328024, 0.31036100497650732, -0.28334809766134095, -0.015742067553895147, 0.0053254102481225009, 0.012044886515907433, 0.36640159866237132, -0.20900343559363047, -0.095080904158541785, 0.062739086537135502, -0.31703537405803317, 0.35059810332632613, 0.15423998307792616, -0.25082433090084999, -0.16020101397351996, 0.12114810603950607, 0.1957456620858874, 0.0010242285675206159, 0.2098675237001425, -0.049959503307279204, 0.24361653620064735, -0.18436943483375723, 0.19569308587910922, 0.24894634020012585, -0.15484493605435357, -0.10030061023574539, 0.19275908785450563, -0.21188738478866673, 0.21247718210641098, -0.15867495775215007, -0.38600328418510721, 0.15731549480073029, -0.051942762238826434, -0.01508511178937106, -0.31576012035184398, -0.49335655205359275, -0.059040123595255282, -0.076275287561762453, 0.1068787271494638, 0.20300032204351298, 0.29775691992059328, -0.039876307395411703, 0.36806205719568391, -0.030712099604147922, 0.01207944116352775, -0.0097298564455979078, -0.026837887094737944, 0.075376961604896944],
                             [0.17834984476100052, -0.29858264298662807, -0.013735487621508807, 0.43264335273357918, 0.24455650162084278, 0.033429399538542147, 0.4476954410291758, 0.35255032235253247, -0.042674783076876568, 0.12713032754934087, -0.37099543189395889, -0.24975308052975137, 0.12565289264857252, 0.031203417931863112, -0.1953432971316631, 0.04865964048179304, 0.014843433106281154, 0.24705902311289779, -0.30030967566979611, 0.14276552500695319, -0.40118192442648953, 0.081689569185827787, 0.0078680117719803315, -0.095232050553704539, 0.044765664697844133, 0.54975996479336153, -0.098717629839624399, -0.0042463298155013714, -0.091460554098860197, -0.27715443622194413, 0.064519484036769881, 0.24686371542784852, 0.059606242810129287, -0.30467841808708024, 0.10878157411769684, -0.010584863586171167, -0.048726647940320313, -0.018587940364840398, -0.1239620075077625, -0.037569443718997342, -0.25109993608844733, 0.27045800194132247, -0.056913976653669651, -0.32586516778605257, -0.17464953380800505, -0.20259347659973867, 0.12703165489625329, -0.12956489757428835, 0.028510741463868988, 0.065164212314933884],
                             [-0.15641247104030698, -0.096234849530483543, 0.46037859819307075, 0.15166766707587728, 0.15816260220451311, -0.37613712700988988, -0.66014886069344714, 0.26768071197741833, -0.11322620518723382, 0.23747648209863373, -0.28058870831058724, 0.32004089018391491, -0.0045705740792520155, -0.078092273529548492, -0.028583939178155743, -0.062201253519270285, -0.075846298398086792, -0.070065500447780149, -0.056543700658223305, 0.26963621302527141, 0.54089025905106569, -0.051151255385490008, 0.058604678677043991, -0.32510785557729383, 0.26706156135551878, 0.3442003695970508, -0.024394368921677609, 0.19393231710983669, -0.34641953161074668, -0.05734880576798871, -0.03763319114603763, -0.47546387229183407, 0.051379197581755763, -0.031073439598610135, 0.075899200619562429, 0.16253564312391125, -0.20423533979527167, 0.23481788207586105, -0.092364997962131559, 0.073130241146611416, 0.0059408019488623462, -0.038727584985144885, -0.089858113952098251, 0.05498156009122581, 0.077700842278447799, -0.15627093198456563, 0.33781551456858011, -0.020693911655737109, 0.14850769353327725, 0.21819627509193101],
                             [0.12864851315495981, -0.30387133651991632, 0.25812807746943328, 0.037059964695324812, 0.036931029725295189, 0.11109762847307351, 0.23815987551624229, -0.10924681936039025, -0.24153019202877216, -0.14081754309255798, -0.38439632996089013, 0.19460113492309181, -0.23874791510478841, 0.20130078837398097, -0.14719808333818871, 0.10353260850574043, -0.13877114215471162, -0.024741694347058436, -0.050225909059023008, -0.17265282505631016, 0.11715212723764455, -0.069827429139544428, -0.063159375141096874, -0.13455936360226378, -0.023651916325558513, -0.036111785255648024, -0.25304055507652395, 0.32222327782223903, -0.026697049469871663, -0.026831222151079644, -0.26685081738165273, -0.082461638437689999, 0.43864462789168995, 0.19976970392792059, -0.34131101925105917, -0.13733312266221182, 0.08361700778339437, 0.13218858492354904, 0.082822061274819336, -0.18020619563548165, -0.34404525411178621, 0.12945057834044621, 0.010230577808234671, 0.20481365271799926, 0.33817139974142768, 0.31791185688119494, -0.42946713103008149, 0.37847066962161729, -0.060439181879107171, -0.23488937424090781],
                             [0.33284982899278215, 0.46059204011054655, -0.18001908737042563, -0.081311020423737917, -0.077539835315660444, 0.057161774673222268, 0.069304517963382412, 0.1792546029374355, 0.12237249282955406, -0.1930011470421312, -0.31291699852831689, 0.19358948178259194, -0.10614361245845494, -0.050353845721787333, -0.20333715707960129, 0.064290844775203443, 0.004663381638825792, -0.15358092918179708, 0.13789025684968495, 0.17112174527504731, 0.33350974723075599, 0.0095053755831300112, 0.37683035005745535, -0.061230067647924824, -0.075474986055595619, -0.14293442380609636, -0.27378220952141463, 0.0085407179460921107, 0.045866480303920397, 0.15986271098289598, -0.4314998151426187, 0.023723166157009569, -0.21290937216329506, -0.26348428057361067, -0.068648303775206587, 0.35436782227469377, 0.26491263452600877, -0.13131542323533876, -0.1075911707144987, -0.35088352502866266, 0.34297795962388178, 0.39843276157794216, -0.17023703176121571, 0.12102282626119962, 0.12786787244408007, -0.093465536415797065, -0.042107814030819889, -0.365848334556102, -0.14298182582166896, 0.38055762872865118],
                             [-0.09580689803265699, 0.047430250366551567, 0.24159272401867746, -0.37264172341073459, 0.43375794228475062, -0.2082064273233783, -0.12369339678603394, -0.11912323293360222, -0.08601159874437396, -0.082161593116468701, -0.029670234657444464, 0.17342352987525758, -0.095567324840868412, -0.12707905768750311, 0.27176902619105336, 0.53185020379146719, -0.17283423397512621, -0.07926577899945203, 0.010428624871628022, -0.029607631605864118, -0.13052217318353657, -0.32081654550469585, 0.18558942162330172, -0.24212364615730209, -0.30425016681674955, -0.093789223410871814, -0.11624490440801771, -0.090670978754813475, 0.18331480506702238, -0.16401517289955014, 0.21199154553993832, 0.045822791353280462, -0.27069272186512461, -0.067024246337506088, -0.025356694162670119, 0.15753201495494676, -0.2343286975443305, 0.070274808691448379, 0.22555432846776616, 0.1550554935530267, -0.51858518439222945, -0.057218421912119614, 0.27687548345268514, -0.26555315131456764, 0.040888850161195867, 0.03079365513537155, -0.017923216524900115, -0.12260884628003704, 0.17721966580181892, 0.251454930775726],
                             [0.075834633972205884, 0.28035492847999871, 0.21610049851376736, 0.27362611686815064, 0.24686149657525575, 0.074806680677002135, -0.17030330544007002, -0.21423375355898511, -0.16645520720642731, -0.35551041081134277, -0.0006374349953430225, 0.10243481822817796, -0.11013715740462535, 0.39590766780191095, -0.13769617424625508, 0.042002166410720326, 0.048796817102397111, 0.065145706124846298, 0.19124074119974027, -0.40408896906489722, 0.1389638848572487, -0.30656578342005836, -0.11979968342975182, 0.2280651443574413, 0.13981723505431257, 0.038084382058799701, 0.051916698449188448, 0.31529042453544237, -0.19873291429449852, 0.21940154082350519, 0.27035241288162015, 0.11662251386138826, -0.024580994467475473, 0.17918193598700261, 0.10754299025551564, -0.074907493303945472, 0.079813306352413724, -0.087074994852771939, 0.099932139963876621, -0.37752952889241848, -0.1524708907133947, -0.0029529645189824427, -0.061601224306376566, -0.30618587746343728, -0.43921207086325698, 0.11638051897190932, 0.10099262211979836, -0.4077561357508202, 0.16823376848683028, -0.070601492812843988],
                             [0.18010539443024642, 0.087677548248340689, 0.28783427377541715, -0.14378842400158034, -0.096682734582982252, 0.11407240831845922, 0.01646229648826705, 0.14769967222751745, 0.14472604196328628, 0.054278188658123339, -0.16730472381354647, -0.26536699661830321, 0.073194224162402483, 0.063608655015747806, -0.36821226737920193, -0.093296698072600784, 0.44191669107811327, 0.13453573845984371, -0.023178309244975492, -0.011641807682701779, -0.29129328490697781, 0.17334764017434143, 0.47420292383677537, -0.20479132678085943, 0.4182088728667665, 0.14256077666577008, -0.34199383436268566, -0.047331896246647999, -0.20097348922070368, -0.014970821053121426, -0.081184980386725281, -0.1683647573887449, -0.16645311759233367, 0.15767522020785341, -0.18470164048506571, -0.11742218626821344, -0.039972182828328769, -0.139774038556716, 0.23667750015362563, -0.011849029752624796, -0.035336266196822036, -0.41078123775775893, 0.16205943139401424, 0.33872027313988246, 0.14421978604213245, 0.10060129665900977, -0.33185008732956728, -0.14651786907350148, 0.34104038638803547, -0.065181233895418578],
                             [-0.15359490522566382, -0.24257502033396222, -0.25747593650235145, -0.26493080765223775, -0.37637886123253456, 0.14061707839279258, -0.17467444953063907, 0.13659010533229807, -0.15358558534861447, -0.24098802286739299, -0.26553123519977084, -0.0021686492482862335, 0.14497156919148696, -0.22698571390709985, -0.20300081162133676, 0.20192298393423697, 0.078245920769336494, -0.28321809326499153, -0.24860304876256087, -0.175294270925902, 0.15879798187634411, 0.098561555825430885, -0.17406710358896504, 0.014641441171068935, -0.058791358525953498, 0.39703446024732048, 0.060554500308511935, 0.28269983196352011, 0.17173556252049879, 0.081970611082219064, -0.033138125289529786, 0.098561795183337117, -0.16849283464721188, 0.0035413320907985435, 0.14450394384643028, -0.032553458941730645, 0.038001244992854677, -0.14904982536378861, 0.32636312227818182, 0.056695367378341341, -0.039431721801833394, 0.29944666532084585, -0.041902718201247184, -0.02699650278075021, 0.12245190874244755, 0.12489294285843786, 0.06017334929848131, -0.49693793612970782, 0.25026743759576742, -0.040091236814048525],
                             [0.039619683091719246, -0.1508482835979757, -0.21283803063141457, 0.24692649758439689, -0.039383765195739849, -0.11181593709459878, -0.057265890512051242, -0.053990408002736828, -0.18375612498481955, -0.0051727138722417118, -0.021644899704603621, 0.099921088694013949, 0.32130537213330918, 0.33679228453915244, -0.046070774344833879, -0.3089674240467592, 0.094776242140338557, -0.23368487560548129, -0.28014976937020081, 0.061884038277890532, -0.21276770805155543, -0.33846574592320855, -0.070379830107806435, -0.19893540246655717, 0.18155009364852281, -0.10235313773319937, 0.19370490300105833, -0.1174110879405364, 0.22596132884234285, 0.030472604831380413, 0.092784610039107929, -0.20736317006875157, 0.16795541759940719, -0.054956957855952504, -0.45093484410768719, 0.23705533964392581, -0.090581983732955701, 0.034996878581318537, 0.37752889451887212, -0.209108027353442, -0.055467177201666149, -0.11989430964606441, 0.42011742657951939, -0.0085454442610186782, 0.30498953659954964, -0.2046863531333761, 0.16887147685565393, -0.200907666052519, -0.17488379406110846, 0.410752260487522],
                             [-0.014629308185888734, 0.10116483589172065, 0.23512235569246046, 0.075441706803272376, -0.023603652827484944, -0.10913441816181325, 0.26724662884672679, 0.010827237186365007, -0.20054102424753162, 0.21395465438294498, -0.035961828571948504, -0.24927797146481301, 0.12861174139176615, -0.28316881900972057, -0.26723537059834002, -0.00097479748287870698, 0.27297820667068895, 0.33366917297851095, -0.23009395572174748, -0.42771646543585551, 0.45354282158484011, 0.016610408377147012, -0.1013158337295129, 0.13075559233818185, -0.35119321342636067, 0.041146746076864513, -0.32353936074232559, 0.20329919044907477, 0.20236900321310075, -0.0098641221202127073, 0.42308633793155492, -0.2635356344290542, 0.033129235023606304, 0.18762811485761591, -0.1349172894401407, 0.025129382221935049, -0.0094491012984236067, 0.25604676406878385, -0.43116764351816822, 0.059832115920090467, -0.047012090226843731, -0.15165426715001368, 0.14963445288560151, -0.24097285576375926, -0.015486895262739567, -0.065439299027870351, -0.034354565230204123, -0.34210404747899692, 0.068151783140599984, 0.12929032512045194],
                             [-0.22149414428055059, 0.078064697320521667, 0.26753905122401794, -0.1474144195904758, -0.32297610638760677, -0.013823105956581304, -0.058328499748053909, 0.27102425706829003, -0.27800598924604786, -0.029140554155831305, -0.11675175135557742, -0.20172980904644303, -0.21656931436445764, -0.034611970227120412, 0.029971767853173528, -0.090700208102820229, 0.087012219814961211, -0.32428811665077351, 0.021638134246615995, -0.24935958081760731, -0.19613621702079251, 0.14692415791092028, 0.090595524616525064, -0.14448033294367804, 0.041606375500633785, 0.040106264944525634, -0.29647231182196393, -0.26979151646107491, 0.017978464904111938, 0.13497390316764687, -0.24907044079270241, 0.049889661747787958, 0.23388998043604836, -0.1389031174113903, -0.04791055382494943, -0.019121046250148238, -0.39153762023424199, 0.34457801450907244, -0.25774475177160611, -0.31075965784890058, 0.011264564840109657, -0.17542514399498077, 0.24435488424850238, -0.46183336201256187, -0.13110628021494616, -0.15785136474207598, 0.15887814406185435, -0.062601032062433989, -0.25823403719560861, -0.099359026031085956],
                             [0.34350088341491075, 0.097309416356046369, -0.016572651314448197, 0.14211916823897322, -0.28650186059557414, -0.18604911912821673, -0.56808422285810389, 0.04485732448737445, 0.2960316298543435, 0.022181190421945041, 0.046274373163115681, 0.14309724784113767, 0.052524676229695366, -0.29368909644062596, -0.24056031741165076, 0.14690774470432882, 0.069675802420578553, 0.24234732584161903, -0.27461477587323951, 0.18238445657269628, -0.1172935452937667, -0.24519423094898057, -0.22221701715507172, -0.18240692248362148, 0.015730359339581151, -0.16629821442399853, 0.032654322988006766, 0.062706519865854959, 0.31963119476800544, -0.10925711067431251, 0.01074369008117994, 0.10746926651504621, -0.020507766121519874, -0.16950501539260093, 0.083938364104279545, -0.43225170564473603, -0.050018933661498656, -0.04890152677279537, -0.089954942153998727, 0.14948288943496124, 0.034243509598877682, 0.10148683655477655, 0.1305188954014202, -0.31573788691354032, -0.03415210745911515, 0.30346368618220881, -0.30700341183330365, 0.077419983998671324, -0.34215714241879297, 0.19952613738631733],
                             [-0.29054563936198236, -0.028236310133642327, -0.24937634153553048, 0.20559721433509068, 0.022053140515081941, -0.0159504674197221, -0.28199546945833276, 0.14781096185044024, -0.036283820061037607, 0.064663077194807267, 0.14833316269412467, -0.39595844294247651, 0.039877558381833336, -0.048678613712385035, 0.42883143715409261, 0.22620331975469571, 0.5130528748422426, -0.10400792374612752, -0.0018026262400101904, 0.4392918566275455, 0.0072021581203544349, -0.12270231218612573, -0.025371975209349827, 0.091309239082203703, 0.12769935682216405, -0.12926156571044939, -0.13453429832596983, 0.3272917975570856, -0.073585142282083155, 0.052437561691825008, -0.12952833313961754, -0.12509919549178561, -0.15539362453877414, -0.027107052308410953, 0.23093122206623773, 0.11955922448780995, 0.010861935858767328, -0.092306988294344389, 0.069223995015340795, -0.40558354644287831, -0.505441392732909, 0.098850333839182236, -0.035409077626358518, -0.020294341584512897, -0.045836172624574088, 0.29881249093810597, -0.26453043775215435, 0.1914848962355756, -0.10603416318254233, 0.29394730648540673],
                             [0.17797535160257305, -0.33770099742463699, 0.015996850235237284, 0.11307011518443502, 0.075487487381000237, 0.17012358133013392, -0.028975589440188684, 0.32158024588237638, 0.087201557257688522, -0.29344489659748951, -0.22664255852582385, -0.26042285251445851, -0.024245220750983423, -0.26110586580568107, -0.13449370744997816, -0.12531164429380454, 0.040477087074206643, -0.096808379434608197, 0.095831816236674555, 0.055866910160736125, -0.1129189649894323, -0.51897874824830093, -0.024642667430212956, -0.28396226273028435, 0.10206244763213408, 0.13304283999483302, 0.12810502090257092, -0.09780231366568419, -0.18895801233192122, -0.15069466232076384, 0.10124290997258699, 0.1762641757221165, 0.0033295122057080454, 0.49817248990023894, 0.34023823823463861, 0.46065609560028448, 0.061762488749807609, 0.44670048407570551, -0.15135068685149131, 0.21032750187336374, 0.32054301920244715, 0.033479051114583588, 0.17736198249117113, 0.27526365071563885, 0.038795981201547348, 0.27220450141097713, 0.11528859273604226, -0.19943073425899846, -0.17511886915754218, 0.026406007778751801],
                             [-0.16922779775058397, -0.14051856036140403, -0.34583743528155847, -0.20406563348638351, 0.2239640266350299, -0.16199555664625714, -0.30057919105694342, -0.14935291938548276, -0.10828242860072154, -0.14588948864425871, -0.24416707950383823, -0.048057569441928294, 0.26135301177489006, -0.027951924267571621, -0.30732091981050036, 0.16325650088468208, 0.0051894318718970905, 0.4006548001773218, 0.50532989774458936, 0.014261739762049079, 0.059157648740207847, 0.016721360260937831, -0.19906936725329116, -0.093264160532278234, 0.03044136316052546, -0.29027874289454175, -0.25243347905336888, -0.11652996588728688, 0.021326338753452061, -0.57072739637216052, -0.039642616823039468, 0.31079728022613956, 0.39053506576252911, 0.19570940312138801, -0.18153730787743366, -0.10075346106984143, -0.20065233539159533, -0.1018050846993948, 0.12205025170126284, -0.051964800764839406, 0.099986135830975015, 0.076076748519085732, 0.20486756506915932, 0.088391734560773344, -0.27254306670146167, 0.021235825662777208, 0.4236981590953186, 0.12167774703241487, 0.036916154559646988, 0.38352381028323895],
                             [-0.40850279666223566, -0.061099610223107746, -0.017656281715800526, 0.18711084345718199, 0.095967674265895614, 0.30979252537108148, 0.30673495122209232, -0.020812842545768265, -0.022410945486019702, -0.16548794012470402, 0.1682893907695194, 0.17826942986294148, -0.23669213317714674, 0.10084076927902592, -0.16014183120753397, -0.045415027715241425, 0.34935476353969652, -0.12213490621633381, 0.35113807715922796, -0.075140464424345105, 0.1683305050035967, -0.21774187901234501, 0.22715326814958664, -0.14705265817380178, -0.21252235224724392, -0.039810695920056378, 0.090735948072146633, -0.056937609302250988, 0.18272397049829769, -0.18537489000219645, 0.11349380613312894, 0.21842035947974581, 0.10270131796054172, -0.53485175538232776, -0.14672609810877496, -0.07569374461301473, -0.095234671696479395, 0.1593605755366958, 0.14325336106231898, 0.14657014714142014, 0.35672222314822599, -0.14396413099707864, -0.37890413552434016, -0.30866354075279834, -0.15203338332575925, 0.13311013436092445, -0.31867774043157987, 0.034617342211347588, 0.10742110979542532, 0.33304107119033766],
                             [-0.24039516700016167, 0.25650371749775053, 0.26324611733140868, -0.020286560513967333, -0.35759164310016978, 0.1527453627012812, -0.0079682849826600774, -0.10937001616944619, -0.13590670564411408, -0.045681458708037276, -0.076106765489394282, 0.07609590436203989, 0.049074394310725925, -0.048037499333021108, -0.33606532222720559, -0.30250827417841564, -0.23413463751382912, -0.29882445571956151, -0.12765106982758498, 0.053840491491388705, -0.29147516738348, -0.16295430730784707, 0.057338128792785853, 0.13990259187175566, -0.34637856181271398, 0.024489766968306341, -0.4355902106689733, 0.10210026183325188, -0.53286893427123894, 0.034993712381706885, 0.36606382148098215, 0.024113875001177155, -0.026416934368875634, -0.3095390935385755, 0.067794649071231644, 0.1227371216493594, -0.050745493166162413, -0.20347237675947968, 0.29419129115079301, 0.13061991301284553, -0.29624360075208822, 0.056965648374497052, 0.079437187828562281, 0.11570324875674044, -0.12360016236283759, 0.31276263349747963, 0.16814264615993427, 0.16572896931381687, -0.41260586261135335, 0.15586732665607905],
                             [-0.025171536946690824, -0.051556696447047724, 0.2744388932124886, -0.056358040224440326, 0.36404628380445192, 0.20143340859690767, -0.17749941307884554, 0.17233601065143328, -0.082967911626732754, 0.39638955498309292, 0.053351667541043153, -0.050210942329713404, 0.010743385027520466, -0.12855846390474726, -0.28344528188645707, -0.20371461826031428, -0.26074817473748541, 0.12633049001046706, 0.19303669160914147, 0.34218598328353023, 0.10228802315443053, 0.120495210220113, -0.088078706808206689, 0.29133838188364242, -0.028687830783005634, 0.25444611719842852, -0.047100297435761426, -0.25502632964303246, 0.43743839637245757, 0.11044203748528048, -0.089628164031603605, -0.14362751676924557, 0.071150529912872351, 0.32697140206397091, 0.10559686649702828, 0.30843253300811702, -0.11977709350125261, -0.16303598689920382, 0.54202246118284303, -0.25371606457964796, 0.19773573902407224, 0.16989686790217073, 0.039282910161772509, -0.10724460925820403, 0.012894742588990236, 0.15105575019210285, -0.46894854001465991, 0.14599933555372238, -0.00085411622402867607, -0.10034320956222453],
                             [-0.067048247655922794, 0.21729056906735103, -0.24093993750380777, 0.15486008626844869, 0.24759895420877875, 0.17563251013316777, 0.26907462662719284, -0.069408321871693324, 0.12463583683809376, -0.083659873593189965, 0.12230542194000973, 0.33659295483003088, -0.13680951779809683, -0.34242635242642205, -0.22664737926814787, 0.056991117369588049, 0.050695490034882308, 0.19871048062953042, 0.14210868367866863, 0.036784447297814292, -0.07414044056930276, -0.038179653217983146, -0.12968648235946456, -0.041248203764209353, 0.082267460369802398, 0.13359947483393597, 0.23248906234137981, 0.28873651166363246, 0.091371865589097698, 0.29955027378803678, -0.11217311065602911, -0.17469602112941574, -0.12325481081320913, -0.22625504983747544, 0.12220822555674797, -0.14557092478029654, -0.50703122199497319, -0.031805548159205485, -0.16424977433913221, -0.30404887755485255, -0.037975145629169177, -0.29478511025346599, 0.0952788867060953, 0.19747444282566493, 0.43426867523469426, 0.060198680890360859, 0.18461526045655757, -0.21096487217473414, -0.35543083959105132, 0.12613391527197718],
                             [0.017588186554737865, 0.13331374973969806, 0.072095789615160097, 0.018879014484984656, -0.38222582574953123, -0.12119135502756082, 0.10791320589039884, -0.014458180831324489, -0.233937368106855, 0.085412953664262395, -0.21709524338646208, 0.11154105992015716, 0.077320020523419991, -0.04501581238057166, 0.32160564657350532, 0.24735669159657006, 0.099006790323465488, -0.0023384548169305495, 0.19348997098175985, 0.12397722025669422, 0.21522545408816146, -0.012932978234130688, -0.052974547478507411, 0.13373576717757379, -0.1549903348374482, 0.24485298323730345, 0.25067328279667211, -0.28159595471596383, -0.25280245270410912, -0.052158937773916371, 0.24332195324236353, 0.17912416542016651, 0.59392016548827253, -0.21116273215008816, 0.29722576754336971, -0.06000907048262822, -0.0094951326008113589, -0.27348288192240322, 0.099576904823097154, -0.060790201314989245, -0.12289018486488834, -0.1078755377972488, 0.16122309623697054, 0.17274070201586417, 0.12879203388086619, -0.052520935923179177, -0.38488698063007282, -0.34836560490757906, -0.071629279358269973, -0.14015226995529947],
                             [0.24102356902161834, -0.030530057466242412, -0.23362645382131519, 0.18759606637806553, -0.21717955616662279, 0.15127215971448207, -0.19497156875711763, 0.21565599712345501, -0.25314116179809254, 0.13217965083485819, 0.051088180512884246, 0.16100831333592652, -0.53514024320791476, -0.18448210912107285, -0.12285976684185278, 0.0018226272702061633, -0.17405647648582506, 0.078677468794913663, 0.23403139820597699, 0.1532823591012808, 0.0024624978432282382, 0.039688386046556057, 0.19399869840413697, -0.057298681193759859, -0.11144496019012742, 0.23476353615932949, -0.055082712285032781, -0.16164768122353013, 0.19017269642462306, 0.55075776213181471, 0.23491473024038878, 0.13694472550757023, -0.024428436711696668, 0.20781248739751898, 0.1292818571413259, -0.10072779143459928, 0.21195697390853657, 0.13641582453730652, 0.11601931442068877, 0.035767371367075307, -0.3061616763229883, -0.18886900765884598, 0.07921607983537142, 0.34414757886830016, -0.19948244567016737, -0.14519127642084351, 0.050474346193179226, 0.26235559932962049, 0.29215006939129756, 0.22429111145047007],
                             [0.011222166178094888, 0.12809433404419465, 0.09000710028170171, -0.38018561132168294, -0.020914859828355323, 0.1687278780810049, -0.089836962803770765, 0.16584034118146282, -0.28971326933080421, -0.0910461414269845, -0.18465343788124527, -0.41274299987779722, -0.034970157151487796, 0.16915226918177423, -0.089355419287870566, -0.22040566988898302, 0.1912074254276436, 0.36472855040642765, 0.18665796718132036, 0.17998915263238319, 0.20350435000784262, -0.18518941271843156, 0.010480795771488732, 0.10327442435634915, -0.091548406820438064, -0.16800326683000075, 0.059136388955181314, 0.22731226817900857, -0.11708339873655076, 0.34834417861811934, -0.0085534022246540851, 0.1087274843891478, -0.41469704217166636, -0.29520993035141424, 0.022973935274736484, -0.1141453073011455, -0.0034933073441584736, -0.068912735252028845, 0.04132587239233379, 0.026158141413004883, 0.32755392088276414, -0.046107787571883899, 0.26654043373998199, -0.10002880663525428, 0.15876921039952241, -0.33403196066108198, 0.037324628447682612, 0.23398647805675496, 0.065498430786723086, -0.19656399699234844],
                             [0.27318655207471382, -0.19807736391471847, -0.28382564083022133, 0.012857393678798498, -0.083827053769908955, -0.11552263708439832, 0.062481832206080778, -0.15312604646130296, -0.085977084196023887, 0.15363969710844294, 0.10309019807896158, -0.27407120065570101, 0.27730228559241071, -0.33504040771378429, 0.030619476515752479, -0.088696885739826009, -0.30583027976103461, -0.24720596708185968, -0.031556361769827179, -0.19072172035386548, 0.17540479053717709, -0.29756611092216045, 0.33375348638610336, -0.086586122156227616, -0.028799058318531551, 0.029852013485970851, 0.28646187680112023, 0.026262064766603442, -0.29340025965877831, 0.032547215074199581, 0.19540281012476177, -0.037226124583117658, -0.11150276814666728, 0.15498119419298872, -0.26359106858403553, -0.069615919204730439, -0.19650959656735886, -0.54028486952590693, -0.25192311259774175, -0.23666261794266452, 0.16091515547954732, 0.032950033565619444, -0.26357782613373304, -0.2705040299546988, 0.0055888668834224572, 0.12020120156534357, 0.056009316156575444, 0.3658781759894198, 0.007178722073972783, 0.067087617845632316],
                             [0.16498567195908989, 0.23366463581187455, -0.051612992040380209, 0.15820464784647539, 0.1741339805757498, 0.24424091627592079, -0.30353260749933603, 0.3151637674866446, -0.11063403804502947, -0.39421324950426662, 0.22872327047185434, -0.23763937227775495, -0.2337092763869372, -0.23181327277234903, 0.052068870591169603, 0.14656755847411451, -0.22597900562961992, 0.1107222018261714, -0.35295495606484217, -0.15694776522463086, 0.34996899485419647, 0.017832064559709374, -0.39813658381694583, 0.23399389653851776, 0.18546461777178089, -0.10034751147136599, -0.30605052706992031, -0.1275279815735384, -0.32167871615661997, -0.065027254614118082, 0.12371047978058558, 0.25031895388633602, 0.13196302496479934, -0.23865134282245049, -0.19566617141046988, 0.28274413990488989, -0.40115212327478833, -0.14255500691533843, 0.051045941528706923, 0.31743628928004619, -0.05417741803688253, -0.11457165559161073, -0.13149457492626335, 0.13797956595653815, 0.32996159470273689, -0.11957204958053413, -0.20408256493181326, -0.18400073548687099, 0.045949177607959142, 0.1490420192611597],
                             [-0.057249611787767607, -0.22590970154162351, -0.090258603844745475, -0.090522803281120251, -0.047361883611919453, -0.22668813243410343, -0.14676117984422685, -0.21372525506427917, 0.4770967110826827, 0.22429723729831336, 0.037714568637051193, -0.1715878006077467, -0.28847089459243541, 0.20225383117116388, -0.43819517123282353, 0.06754370025996502, 0.020269687872316901, -0.16181381184700383, -0.060185754296008739, 0.098718914355422432, 0.15745276609932285, -0.15921809962067332, -0.056943898907967853, 0.42523760035436048, -0.18624665236342958, 0.12460699253844837, 0.14027314816261774, -0.020291872723715434, -0.080329677151411025, -0.2987754575083722, -0.10630209318667655, 0.5043062953595856, -0.047838718776223831, -0.14816382370504588, -0.072551013718133495, 0.2318416321741707, -0.24571700344202396, 0.28579309256079705, -0.20486361605905257, -0.23166312624560631, -0.217812523854504, -0.26106010178696221, 0.26570524345851315, -0.027809879232464578, 0.058327166579485751, -0.092344947761935789, -0.17701386280245873, 0.14975146402956288, 0.24362834211884463, -0.048283496496216563],
                             [-0.058204791844023433, -0.24991735314596744, 0.24884880191016881, 0.50142576774089853, 0.13161918352143531, 0.031154556754824217, -0.029577172751088565, -0.29869020764733517, 0.028911748763269608, -0.23380857261459767, -0.18438625409982312, 0.17035776185057044, 0.21089616812778852, -0.36676597901937463, 0.10601900927799182, -0.1868509077098531, 0.17518218806023625, -0.32719950953712273, -0.31884246641345221, -0.19084187144463582, -0.04176186913494314, -0.054342524560868494, 0.24970089285123465, 0.21449246442223824, 0.014990384370442547, -0.29486203376669523, -0.211239302219287, 0.099994766081013958, 0.27840502450279159, -0.044087040409072499, 0.0071173040430859286, 0.13791147691296904, 0.042305765014445468, -0.10550660717428614, 0.15178163751516663, -0.11001083953781671, -0.31973784587089493, 0.012015091530545041, -0.023801396512019173, -0.054339762253997989, 0.44159775610288438, 0.1025061335747877, 0.18169342264496546, 0.48893771581442314, -0.19871012605102234, -0.25252362660497224, -0.049291847945698228, 0.067338549674382464, 0.25546406421287637, -0.2363955845476004],
                             [-0.32088839561101695, -0.04312434318742317, 0.13048461359611363, 0.34274131983956302, 0.047194891792437958, 0.098066869084763739, 0.071580971315778341, -0.19359751863863808, -0.11772872665284778, 0.15534928239902962, -0.39634647961571601, -0.017704032136755941, -0.27960751051267152, -0.25518249940285953, 0.029946155052255882, 0.030462687572666756, 0.22005520483076985, 0.038733318402710826, -0.080421178738217677, 0.1727204534075906, -0.13500033473695808, 0.08188536014408862, -0.12292609465018996, 0.029068047470773031, 0.21124731074959147, -0.0024613455395823269, 0.49247694007820841, -0.33890346569068208, 0.01438993956536604, -0.034282099368740299, -0.27785686274098209, -0.02319580186839364, -0.14153682481588634, -0.31206983322277976, -0.53952763970621875, 0.40153620469291157, 0.26233475104114673, -0.26440656582887684, -0.058724991446764858, -0.087232945325059943, -0.12652984797362452, -0.043060150187187222, 0.32189573747350619, -0.12610036644555622, -0.30061095776461993, 0.37843786288488052, 0.13847612433319406, -0.01973291362409739, -0.12798603310444201, 0.033069569770515686],
                             [-0.37816757004662926, -0.25071019601189226, 0.0044688951956579487, -0.14460116378910015, 0.34940588128418204, 0.12731447976774524, -0.069990956465066895, 0.1691616737319625, 0.125638993338898, -0.37751793726061672, -0.26994231386837958, 0.11466837855928937, 0.29172371183746187, 0.18829768669544625, -0.27072646655554267, -0.068860147264915239, 0.020124645245994582, 0.18037950800976263, -0.37668793624023189, -0.17421338979219728, 0.07212282230299244, 0.046485606545318671, 0.73472530364317801, 0.3988498686246944, 0.18464367632458534, -0.22865449757589729, 0.25250115615821106, -0.20488924859616614, 0.029548557187140032, 0.16564351960151688, 0.14650860421147918, -0.045572464879502783, 0.14180714801655547, 0.073125899795166399, 0.2543124403541972, -0.19675922633801918, 0.15918681868255546, -0.015658493237881023, -0.12469691770326408, -0.090516802418986866, -0.21228364054263166, -0.12967160224841823, -0.12186351947466398, -0.1001604957749869, 0.086099171029169211, 0.099386053598268465, 0.13382014168942696, 0.040981195240987096, -0.21840205013708613, 0.066198880816173422],
                             [-0.058134750395304011, -0.29943717448396689, 0.15529929188291841, 0.0068176641627379977, 0.18670766384823839, 0.21947851919275657, -0.15905840382476932, 0.29924333750951154, 0.29419212045882087, 0.26604417458056051, -0.088017577660095644, -0.17239390551285069, -0.13289524495275229, -0.091262358430191634, 0.20074018812702124, 0.13720148742428101, -0.17964317044745171, -0.083703671032858751, 0.30471004859223561, -0.025021385749562853, -0.0030706621744934527, 0.0069494445952729775, 0.035096557175995538, 0.2528768148441764, -0.14255194694160792, 0.0062275933736016462, -0.059308081206892613, 0.12241296661032497, 0.012182674368555796, -0.034979044041820735, 0.31558007945674565, -0.034865635223258647, -0.11012084785098047, -0.065371816739355298, -0.40453252653535748, -0.4432778512539558, 0.19147591036342687, 0.15468687885263316, 0.26510171159202256, -0.15320488926034478, 0.20119765438809437, -0.11420874369761468, -0.13408187689434806, 0.17885057285103584, -0.071458046750216248, 0.2228744735104958, 0.19482641187462246, -0.33873516156175582, -0.21155485809823066, -0.22355639771836205],
                             [0.044811871040447482, 0.22422386452602755, 0.21712581193094235, 0.05632725121850065, 0.025179020982405653, 0.17781767780710919, 0.001866356391372101, 0.32389563128879395, 0.11467699522288963, 0.21913889779404935, -0.1224942827179718, 0.091476576513927932, 0.044914906775721943, 0.32786121279986863, 0.12518604342186573, 0.30514882092685991, 0.44769587581791831, -0.20702978623115267, 0.24202025393279852, -0.29258680521994879, 0.057662541191459069, -0.23771194019368952, -0.13404189972469116, 0.22778548097191714, -0.35910069769883152, 0.17883896276705577, 0.20096215507815793, -0.31082905519876475, 0.070606166938452203, 0.061766021747897387, -0.3887578780491352, -0.26735374747924912, 0.016862307849179983, 0.16640032020123458, -0.19906775462951226, -0.33931027685157633, -0.30356055007315014, -0.41322223864352386, -0.16660090981400844, 0.14919258432570659, -0.0097375633175316636, -0.14764737492344315, 0.011162443585917156, 0.24477951881328872, 0.064987820396491758, 0.036427310248829115, 0.10357103613790877, 0.20913890223237805, 0.14995681210408437, 0.053769913049584672],
                             [0.1143333222161451, 0.32002379491610378, -0.34286333074363767, -0.15410887277823315, 0.01412608567490397, 0.0059008210639145287, -0.10135389908426889, -0.34748235404308564, 0.097925989966062443, -0.036757753921077829, -0.16618583875893317, 0.062098460730330166, -0.060997265454239266, -0.020451806458643147, 0.014552008523972881, 0.29705698810165709, 0.54316010027815775, 0.018931660018691707, -0.19149040025581002, -0.22396992017322223, 0.0036524331942874924, 0.008527913677642978, 0.17305136886418346, 0.21868598446612753, 0.21212684088645259, 0.62530281759523876, -0.12897294007665736, 0.13158920876675484, -0.13514918956814273, 0.200781308386658, 0.2294138212052387, -0.039192660607841531, 0.1912034124506648, 0.25331660309844128, -0.21024395468558249, 0.11551632858881222, 0.19962005962819554, 0.079412502462628307, 0.16943580326018187, 0.11576961096652186, 0.33259864565352898, 0.15855818898459612, 0.13434708005459348, -0.038815773568113179, 0.10211069669341752, -0.26341447009391672, 0.074889129230712032, 0.36219546291583721, -0.37903058430480779, -0.092683461679249096],
                             [-0.036864720512936953, 0.30928072500279047, 0.012157645703288304, -0.086682242111532457, -0.19318485404137456, 0.015600398586517288, 0.13835222409493853, -0.034349502871909771, -0.1457973466042837, -0.09744487292769001, -0.4454756153649217, 0.17568286012127984, 0.29291572060885046, -0.038496197339582552, 0.32275311684142027, -0.051314421002900304, -0.15670117206618098, -0.17161931576593495, -0.16951120336413308, 0.016549075741000646, 0.21902804540211679, 0.022947513012712188, -0.21333001912934058, -0.055172793169560516, 0.22018817891043124, 0.17819762225447164, -0.12118511882052002, -0.034923068080824654, 0.48364714985178631, -0.13244431074157659, 0.10011687186333816, 0.48391062022741699, -0.30876475179126872, 0.077262066270127217, 0.027884474897850384, -0.073406573400226022, 0.17020618990549005, 0.25587491646987065, 0.069659899815358778, -0.42833972804609927, 0.034013871014841567, -0.34165777912438905, -0.33401913091417457, -0.057294002478402981, 0.13446435706700335, -0.0035192346639791637, 0.0094596568604409167, 0.28173696453164182, 0.031660146825414931, 0.12593023249806412],
                             [0.015922929178622647, 0.23553994469692457, -0.3523434337379191, 0.073678120427317639, 0.1864004687218512, 0.11486182574129011, 0.11780629109483898, 0.041387690719400412, -0.0087416513008780339, 0.029198780043654268, 0.0038022452018351277, 0.046140928639274471, 0.29407835638916885, 0.049940703628748452, 0.07756263457433446, 0.078724369454394399, -0.12215944332072427, -0.45595383667281186, 0.010501112846408058, 0.41663622273995821, 0.12004121731676876, 0.024438569811303747, 0.10984695303802559, -0.01081332690923148, 0.34751404689122495, 0.12923724287935967, -0.23899540541241085, 0.12653711604705312, 0.33518741883859376, 0.14812699312676852, 0.14792913552476461, -0.083432767736184785, -0.028522468990376627, -0.18658101643801261, -0.12324835065803956, -0.1318716525360461, -0.087979015461941437, 0.095815601117568927, -0.3160943206468339, 0.55288035908634681, 0.036334967384054166, -0.032939680833003054, 0.3481991160315262, -0.096189039572276744, -0.41782624207228797, 0.37194429649404942, -0.10435236839689874, -0.11196577098107592, 0.058692559175794405, -0.24649930084378877],
                             [-0.24414019976831403, 0.04385569208615079, -0.11591368646280224, 0.32177701249526658, -0.088494848226962061, 0.36547079277361744, -0.11028937017888067, -0.39193513966682142, -0.43320221215091048, 0.15990442394221696, 0.13676167956345883, -0.15398129667851268, 0.13867011804618171, -0.052730606665551155, 0.075763918210457998, 0.41839506480001581, -0.39952007591224026, 0.13361680202603826, -0.1784543657263295, -0.072029624254440483, -0.097201136401393232, -0.16852425944296812, 0.04975195948901151, 0.3064628398457761, 0.018402717014039765, 0.28053499562951312, -0.23587472961482253, 0.015955530916552, -0.097709355488634395, -0.13266401831766875, -0.39448189348849899, -0.25419278683960139, -0.068838512524046117, -0.26194245626317197, 0.33693407593175545, -0.11813242302049688, 0.30008515397617919, 0.1142123185062026, -0.030778616915027767, -0.049628296648563261, 0.24677455031678175, -0.15342479770490242, 0.12290698616328263, 0.12108075975593999, 0.2219830006003404, -0.015118162827682117, 0.10354191040537196, -0.18344500249228482, 0.059029393385700075, 0.30964914680585676],
                             [0.07451816377872976, 0.25255992369935404, 0.29747061327750468, 0.053094689255390355, -0.16420336032746041, -0.053670821255386018, -0.082035067066345863, -0.26521782039502528, 0.39445765842540192, -0.13829621607015574, -0.21427143752707542, -0.39299223923078758, 0.19060799367899975, -0.041985414570782913, -0.025583861832015515, -0.13573952790643323, -0.21927356131611314, 0.030411045110605231, 0.59242190538709716, -0.35858527150861302, 0.11533517613618695, -0.0012555238850053448, 0.067024386317545051, 0.15156899591314615, 0.31884975709623131, -0.099038920878816591, 0.20995917284675408, 0.10240786677563737, 0.28814240730124513, -0.0053362398743474031, -0.14784462658402883, -0.14376273629124744, 0.31482132472773178, -0.23122222607197535, 0.09480609246736188, 0.32507019691255434, 0.058579609139259053, -0.0083917882742476704, 0.18628263811125384, 0.15952978342964352, -0.19651460375545995, 0.12898675536441168, -0.14714010514820808, -0.16370443720503861, -0.051589899994797746, -0.19116893965463419, 0.25812191737776607, 0.16201094812792002, -0.010454223950165232, 0.032533707083706648],
                             [0.13269286935335842, -0.13800817624501022, 0.0919756764518051, 0.046896724886157697, -0.0054015600005424391, -0.42772627549281395, 0.25497028660465876, 0.048421489684852048, 0.0619961171140734, 0.023828158216188722, -0.023260764884131816, 0.061501145065052491, -0.098672605772140626, 0.09086004206190465, 0.14844900616837672, -0.06428017305431849, -0.15832520571044456, -0.18953742216787478, 0.09069888004488319, -0.24181541788282407, 0.23130920230729873, 0.25261282638007243, 0.071158946329308997, 0.038313431191839782, 0.035964702054002706, -0.1068072985491911, 0.17938269334757095, 0.15466486300503746, -0.097207395798892995, 0.43122631229517816, -0.18455263630959276, 0.26252262566612228, -0.09314774469365901, 0.12142625465879553, 0.31272597245425565, -0.0080164251443478832, -0.037871836479399533, -0.033347577418929526, 0.22483024535735555, 0.025394762863136328, 0.27397130490400928, 0.021428308382061424, 0.43366766936094253, -0.088349977414557079, -0.16865032737982535, 0.36234741959205125, 0.19470967880325396, 0.045263195258199447, -0.15924005536407709, 0.61906808042363626],
                             [-0.1698257029933137, 0.00060773509554846138, -0.31406404367350615, 0.065120987533210994, -0.2532381688664555, -0.12693809236898226, -0.014990766671800465, 0.37527064432415019, 0.24517305986645796, -0.13562577639531154, -0.38318689860227811, 0.21998470188535785, 0.22058811133799494, 0.16422023326269303, 0.27347039652275579, 0.3636937598470224, -0.4092849653482607, 0.40726833433714194, -0.070689088759753382, -0.29858691832801798, -0.32606680952934392, -0.023584850027595243, -0.0012259231652502912, 0.10981549896818282, -0.074963596711382724, -0.083731102333962956, 0.077590134536465932, 0.12578779995276501, -0.037335380665363314, 0.18937776337674123, 0.16630002086088042, -0.13243593360249578, -0.048138193745157529, 0.059149894861800285, 0.031856437827656098, 0.18227581442996493, -0.2340369336591932, 0.21799920929589522, -0.044065685402085636, -0.17942478493437389, 0.40372319713949789, 0.047742986809811552, -0.19751962659504593, 0.064914147129868774, -0.011973492823491918, 0.154493430307938, -0.21807567783563969, 0.13023308142815315, 0.40284912434053594, 0.103715181799549],
                             [-0.099720283685167027, -0.096447307387322295, -0.25984411703670907, -0.136253543306326, 0.087295088226468989, -0.095090087342907414, 0.1789495223494206, 0.14447702428428533, 0.0004733398614950781, 0.081903272172485053, 0.12965837977809438, 0.3558222261549126, -0.093872242753245141, -0.084049636305197684, 0.37052259899095946, -0.64889067246017407, 0.0055463466592914658, 0.3562116668888255, -0.026550457333612866, -0.27108439996619182, -0.10903965141537508, -0.57656427847855929, 0.10550443515161781, 0.3187707977468251, 0.14722334134948545, 0.22784321910484046, -0.099128161826450789, 0.27633146065496189, 0.023607993119570611, -0.049907917909244807, -0.54559718526348711, -0.011168015381013854, -0.14532127039939058, -0.11987848123106315, -0.032305626321891823, 0.031302840536849202, 0.075712393378620971, 0.24189774451007953, 0.075043450913981152, 0.19390131963627305, -0.13614991057491641, -0.23801338407880968, 0.039050288515121226, 0.071003863788385649, -0.29657407073935155, 0.051844067387444889, -0.067771700897894541, -0.16259295033046503, 0.090333540128650178, -0.25613372451832583],
                             [0.059806637538184021, -0.0073756991807793302, -0.087821440530346198, 0.19459104741421909, 0.14710220113566644, -0.089630332747696356, -0.037923752621443159, -0.13701040322053484, 0.042941788927933475, -0.44894081997190216, 0.18376831309266192, -0.17774131112266373, 0.24787154031316844, 0.047107495236415692, -0.052386594086510654, -0.0020692706758238776, -0.047282449504664592, 0.17825944076290184, -0.19268129544141782, -0.37304434103368711, 0.098713700203561169, 0.10937435237052018, 0.059103773501585917, -0.45593190240034692, -0.41659190073729357, 0.47732803110615579, -0.049354518405249952, -0.21606758170804083, 0.17836722546221317, 0.14619535382841625, 0.06248754862127983, -0.17144565965263761, -0.15687610438237326, -0.30609750243793454, -0.10008759755302908, 0.13155734223518045, 0.090633413085869724, -0.0099419494698807665, 0.25259643632126066, -0.28774007847631006, -0.11416799897711975, -0.1621532132345882, 0.16253846936767, 0.30442667444622779, -0.38966326731628187, 0.0076358232299246391, -0.13198031526959908, 0.2728477879242025, -0.16691646145612302, -0.13552189366501441],
                             [0.2945073524709958, 0.052720552508993018, -0.098698468640864179, 0.34085549541771226, 0.02556104082214419, 0.011850327467888411, -0.14629088685467753, 0.22258271926203238, -0.20832933680307653, -0.21456524307697644, 0.20657844822733046, 0.10531072636591353, 0.015208262375877104, -0.077840802646428231, 0.076552776306304235, -0.0095638410205776334, 0.074872862780648156, -0.09128238162265484, 0.23750765097180121, -0.17653298694895567, -0.080060883154859763, 0.26623919764219794, 0.12977586776637384, 0.32478282144497939, -0.22741407338901809, -0.037791812312550799, 0.16249725335750195, -0.11295061026511116, -0.11262744390373756, -0.36118447302486933, 0.19157986528893942, -0.12287612535692991, -0.2111088889023689, -0.086096612135586129, -0.0065270528185137327, 0.026950606720776576, 0.15256467266031951, 0.16063464322538895, 0.22283635632651219, 0.0048093458352577913, 0.044433801709348283, -0.11423346500680397, 0.18984201872177739, -0.33285402103561551, 0.26610646222751355, 0.27360207231257416, 0.26926358789136934, 0.078832542640434697, 0.12147094540980614, -0.50776135873107808],
                             [-0.10982050191676691, -0.27213471908691106, 0.37636986958241586, 0.00050118162390241743, -0.14091961889349516, -0.48715851546124239, 0.13712751350848312, 0.13665459994955156, -0.18232948459380852, -0.32302433745123121, 0.40999530532876211, 0.07625346179960775, -0.081545787922089039, 0.016043283117245916, -0.21229507780562554, 0.30931601268982506, 0.060865789244300576, 0.029326797345490433, 0.056663929806284402, 0.18674538923137404, -0.041056151953097836, -0.046063106892099435, 0.10181623397178877, 0.19875993968628924, -0.13046724381075722, 0.10752748202915687, -0.20995174313138379, 0.2639763590832826, 0.40554254980060217, 0.12775648339854639, -0.036282535118796526, 0.17785466546823225, 0.38894391249231347, 0.10000059388024259, -0.22546868893863459, 0.21803890169358037, 0.13377374949972418, -0.34156931177446426, -0.050968122557596168, 0.24960406444320732, 0.30128227070586627, -0.42576166107218821, -0.21997589865449632, 0.067926164819610932, 0.10093377801693826, 0.0037069583301621621, 0.3462272987065575, -0.037688071890789106, -0.15335589718534481, -0.04181149042612041],
                             [-0.016459441003168682, -0.016745437684506089, 0.15512617035388804, -0.10592025008812472, -0.21229091401050243, -0.22233847374632873, 0.28668037556829629, 0.012719020531224663, 0.050473922380680464, 0.10018110707614758, 0.3642210911086311, -0.017063462335525498, -0.0093900894316781419, 0.19389874902357018, -0.26842434094686063, 0.24804528860429029, 0.10740082397722846, 0.039014740672917284, -0.15571370817341687, -0.11742382536955411, 0.30331023617158004, -0.49683144362718445, -0.14374201126716005, 0.052607353549149159, 0.49372091293371806, 0.039512872728609635, -0.0047363271872368148, -0.26118030817170412, 0.13299691135854197, 0.042929716228136364, 0.21319469469263377, 0.037218418637173539, -0.0052831570568592882, -0.35167387128809691, 0.086556080340948138, -0.08984069954709889, 0.19474694427687306, 0.19086201015208359, 0.17033890435868457, -0.28670470304975204, 0.026977205317826408, 0.47789022668930881, -0.039016810074835651, 0.17104335826253686, 0.17546392954636442, 0.38247999765501078, 0.38424759071032555, 0.026078960494948272, 0.15274728538141027, -0.21861534242040048],
                             [-0.20845795567642175, 0.27928928875069275, -0.34518972776537027, 0.19795026949756273, 0.14905996603807115, -0.010142171704700321, -0.19355513209066361, 0.044586703643394149, -0.076401803645174862, 0.56061320043769058, -0.24607678660907567, -0.16871557881223226, -0.32199553100992556, 0.17951327745380999, -0.035667943259189344, 0.17596305525568387, -0.056654053907725876, 0.054528548271089328, -0.27754817977728719, -0.12192201668334614, 0.071143980692295189, 0.10220354399371713, 0.12047313411879987, -0.41203321787136876, -0.14303542448715123, -0.34998251584835488, -0.13931364521998579, 0.18263373560961621, 0.27156238326767845, -0.079701035164876227, 0.038048257853288421, 0.12023577991297124, 0.22891387431852001, 0.14117890952703946, 0.27778229740095034, 0.031791314451835792, -0.099772449243877515, -0.14748996391708769, 0.33566446844427417, 0.064216466824760093, 0.19085157687789367, -0.31478344891610138, -0.18313811599750923, 0.023232450318283353, 0.32873532515969173, -0.064570196658072954, 0.15277170944041413, -0.087727837336153885, -0.023267874052852022, -0.30302344725403835],
                             [-0.28252260732497281, 0.052242316604713054, -0.22070559180596361, 0.11869040196259144, 0.40642747652894462, -0.55392677469231011, 0.05284407968319095, 0.1860057589746256, -0.028008012759167363, -0.023850545377313789, 0.0040106541155051773, 0.0031811630431866599, -0.092434615467260881, -0.12472994707917545, -0.22241022317272732, 0.041702881241047526, -0.0458288018069134, -0.31359101355890384, 0.368960208109404, -0.18100481238425375, -0.10973369096974291, -0.023187739523675789, -0.24193198740547311, 0.075899864976411227, 0.16454349063149087, 0.011920296686952842, -0.2112402762636382, -0.072054335985979406, -0.14508652898329505, 0.14009918802930227, 0.055811507938129765, -0.19653554454406436, -0.18278015705767359, -0.086767349021874135, 0.22714187079063677, -0.295759936815849, 0.53466823192321233, -0.15847127092037383, -0.015096251041808954, 0.024346096835092822, -0.088783166752240558, -0.12481375913149584, 0.028020022301474212, -0.18088311606772062, 0.16723932773809261, -0.18649993525973513, -0.4273353222996682, 0.056457255260958794, -0.049825882607758054, -0.2514318720761014]],
                            [[0.057348366538187409, -0.050008311648810894, 0.0031943866421410491, 0.20913479636189669, -0.28102264997178322, -0.22384987316703348, -0.45509268629778232, 0.22500785938841469, -0.047340757858822045, -0.053611949769224128, -0.51118255044477823, 0.37425480026239566, -0.25937055576976231, -0.24113515764491958, -0.16306052613441471, -0.031424979355397495, 0.073104895586543359, 0.15442215870384307, -0.18332755338841258, -0.10643794369306987, 0.28724633498483382, 0.072131724710021591, 0.088143906708644387, 0.13534713860596287, 0.085367380863852316, -0.23854939384020257, -0.29973919949090916, 0.29014848276724703, -0.066707479855495522, 0.075784269774077387, -0.12187358536580395, -0.078974419046429503, -0.10742866123870631, -0.026627682617146736, 0.029513470535877821, 0.14055890024613024, -0.38846415721023775, 0.0097841225438381908, -0.20217466834665068, 0.1485580307953252, -0.031422301734259105, 0.04071791944105041, -0.21594516880146369, -0.39265363470997849, 0.1634707440382302, -0.17613182554787957, 0.018610810827652785, 0.25761319454766968, -0.099282746316838574, -0.3430402366765698],
                             [0.17324850012317528, 0.39833891740671479, 0.083907956177254758, 0.085806308813414736, -0.2027962745237275, -0.0081497232548272923, 0.016144792966007588, -0.20146900267694845, -0.39008855848369484, -0.20660673362381637, 0.050674132049191287, 0.014891818301693178, -0.011319637732449131, -0.39351313861514553, 0.13623170974345808, 0.049266478436211548, -0.1652754824244925, -0.064720465944852465, -0.0024933902183887201, -0.26896366928500248, 0.1018290619373422, -0.21861101763404492, 0.012225894473627439, -0.18495089074142973, -0.45975253406446714, -0.068332648655043154, -0.23203100881622754, -0.28490474503058921, -0.025268982537380753, -0.035660516810043355, -0.06215780130729219, 0.14290312305407499, -0.19982248368163058, -0.18079610081299297, 0.16280255495953674, 0.0013863940857760521, 0.2345142408974947, -0.24761174289870136, -0.25028708115719611, -0.433923179364685, -0.35256795276590036, 0.032300352629840101, -0.0083713151996281897, -0.055890958675894178, -0.25237975028177023, -0.31837969857865084, 0.14045377768431641, -0.097759205067027385, 0.3467518941827995, 0.22125038702618727],
                             [0.15655953547484863, -0.040202777680428813, 0.27764152061129416, -0.26501941474577617, 0.039626631244712371, -0.37446270885506616, -0.12044508901748385, -0.1181978521727013, 0.11558469304564532, 0.16738917762331215, 0.077777279140875441, 0.15449641944222214, 0.11333616405486394, 0.17769884202379044, -0.21931621177832186, -0.22792883751119844, -0.17176155646680566, -0.44219591466446645, -0.092943976898327993, 0.14573522929151542, -0.1548279360170369, 0.099183551806796694, -0.59981751561704699, 0.30139427844103761, -0.064267406032406618, -0.16928352448813203, -0.088959497692836426, -0.013195237502733801, 0.023673729420487837, 0.0096066443341393751, 0.30230223125131828, 0.024972682310838192, 0.021468586554338205, -0.027735278831616285, -0.041598399803887874, 0.12386309780785806, 0.24547889712768919, -0.027445420758917986, 0.13960000350222004, -0.27277244427167685, -0.053124639685024025, 0.069416808768197336, -0.47957686938381522, 0.0052981859663385434, 0.17196228861899157, -0.13759781991421632, 0.23381694867128988, -0.43584225676829774, -0.067987601535273195, -0.12713818773221822],
                             [0.02649897831243378, -0.0042085418370529214, 0.067214581765843995, 0.05868356864042077, -0.34900938377439239, 0.022588633282350661, -0.022507039940762835, 0.093047642481521253, -0.25514664815616883, -0.18380442635454086, 0.2536075139175647, -0.21353097443580724, -0.24922712964461971, 0.42478576015198333, -0.23281485183851194, 0.20782473175026267, -0.21893352936338031, 0.047220268853414127, 0.34139872423781703, 0.48645925953767655, 0.17952186386368724, -0.091155565432573513, 0.15296969758388115, -0.094809723286829115, -0.097079021336767171, 0.20925841852278318, 0.080036759473573249, -0.12116850155852742, -0.25207434315151495, -0.022247672169980796, -0.016457826431786539, -0.019810029235049362, 0.023250877256044737, 0.32252439170513519, -0.42736248416508821, -0.47903699821708107, -0.024870938271969317, -0.10259115894588615, -0.17635435570587835, 0.096408621420011942, -0.35657200845655956, -0.26473243272474523, -0.21785745010367155, -0.022200957373466404, -0.14425220264270652, -0.21482359111637278, -0.096095280905122371, -0.081893175574730345, -0.15107190585658456, -0.086610462435865301],
                             [0.18942510239372692, 0.083913065771752116, -0.52307027468677114, -0.11717875968969793, -0.015844561224669158, 0.021029351825511522, -0.042529056552503809, 0.28159242726803035, -0.043623645856789281, -0.36692709630593362, -0.021637933631067842, 0.2595443553454061, -0.24977973994787089, 0.27102399097107538, -0.086014026156563297, -0.082984619511652646, -0.20082788333194068, 0.037361139504981628, 0.34916511796043886, 0.098181986174377428, -0.21305386627040102, 0.20553135638726763, -0.15577085094319959, 0.12956626751469819, 0.26169420900430068, -0.44847958494775642, 0.28820293686925852, 0.20772893074415694, -0.00059328587490705895, 0.023422064879555428, -0.1260178492989876, 0.055325252894594543, 0.31819484332746556, 0.3134666175116908, 0.1478918823171407, -0.087765511298029786, 0.10309884874372485, -0.1169408197690245, 0.076142433657543071, -0.46600674498917971, -0.26049667301372675, 0.37458942643394444, 0.048113584975395224, -0.086967813052161766, 0.079714996453360873, 0.1034590891822155, 0.054735830376791902, 0.16285573046063401, 0.3268153388111214, -0.19193072614257986],
                             [-0.11095354368437089, -0.042710871734775689, -0.34175159699032337, -0.17810060051466381, 0.037243793159014549, 0.00080901614554235168, 0.04484952302823568, 0.19003282411783937, -0.11449956427253868, -0.090006246282028551, 0.1339103541369531, -0.02540031658039478, -0.35365306130697155, -0.05041759834850186, 0.18594977401913204, -0.48286038493818095, -0.08496742678407429, -0.13135236981773046, -0.20144279716887384, -0.0066468610808091272, 0.37137130909525251, 0.18237733943404788, 0.40925021830410474, -0.02648926119053184, -0.10221554570988389, 0.18182379105805416, -0.1807898998504234, -0.016623860666596386, 0.25347825735936652, 0.19477986734502106, 0.46761080214778489, 0.062121053012926294, 0.25833397312405465, -0.15139764046316073, -0.082030079518642524, -0.20938603427503977, 0.055196276803820978, -0.21233948056204643, 0.18494504219517094, -0.21576565179795887, 0.2207715274543896, 0.03776510945040959, 0.1074095030456788, 0.27017551099604453, -0.21756313473676353, 0.082242568647862307, 0.33141006807973405, -0.21933169742943737, 0.0024890568633417071, -0.30634154062135766],
                             [-0.11939598409579555, -0.035008626795712317, 0.17649305725197323, 0.42235750947730533, -0.22039451257932838, 0.27147694533107408, -0.12938956779720703, 0.0093690613918635361, 0.061127686109450255, -0.064721686717227833, 0.080535317877003604, 0.16186308756800777, -0.2449973597215187, -0.17953078356093552, -0.32985786129347144, -0.075713813434214641, -0.13209183671340929, -0.11042684982933598, 0.039310983900193171, 0.080524284890099496, -0.10834603566470324, 0.030895022057706476, 0.26238759706931664, 0.11153930305937665, 0.19337605992483656, 0.166756430273893, -0.36683929631484652, -0.10401449844075393, -0.028625718572817298, -0.32513451892559136, -0.2457273888399914, 0.21438148089785986, -0.0086280935867266463, 0.21009441862975056, -0.29099435302172533, 0.069903132641660592, 0.38406986982756353, 0.15856556354305051, 0.2930603317901872, -0.3167165522808178, 0.21126558013380942, 0.38260066802452203, 0.074924718910518259, 0.019413896936466269, 0.3313112385410748, 0.17446124373888597, -0.089503373877221862, -0.37294999344833318, -0.11823136318755657, 0.11014208749549838],
                             [0.026414935930423517, 0.29682912827942198, 0.12354686364584798, -0.034613049476072758, -0.044618964006399323, 0.21964885725510033, 0.043676788118339124, 0.31317863958243586, 0.40331727201988143, -0.081732723492401183, 0.010497081079702483, -0.3553913955503184, 0.090437631070782593, 0.41281444950547869, -0.10430351276568783, -0.16386177576120275, -0.49916648728912538, -0.066422756875415517, 0.14030061334438365, -0.24192217356275914, 0.49891078969409386, 0.13240145146576873, -0.36031055909659099, 0.036640088215966024, 0.06858660912657788, -0.21683438815436534, -0.10246498545622099, -0.099776998561496827, -0.10687787315357403, -0.01904551875648923, 0.019178233119260424, 0.18170740895622747, -0.044114195879161322, -0.34317480648505772, -0.15211848290448443, -0.046650399328048625, -0.13535916553243812, 0.41174699766316403, 0.075338257843881373, -0.015355932336509809, 0.13295136756297318, 0.028091948061880992, -0.16752238052584995, 0.1635700243548518, -0.085047709505657862, -0.14780344925115413, -0.2179018455634637, 0.29832916519935382, 0.13046739955517378, 0.34120157940851764],
                             [-0.0882872484806492, 0.19781292585962451, 0.016331452627351896, 0.082990695738264952, 0.34638790444832429, 0.33131547410667944, -0.58155134251934437, -0.3236880410018439, -0.00069883541823775397, 0.32411681004659076, 0.1010812455740968, 0.28167239200239902, -0.03459555376919022, 0.015493945134062801, -0.22345629402319037, 0.080211318319387145, 0.0095861604592277806, 0.22613392589414297, 0.28184236736917523, -0.17096767301955695, 0.16973717841996677, 0.23574948453175781, 0.0096850573125714066, 0.17013198349852054, 0.18763958963658794, 0.13909755517897782, 0.075185280164955418, 0.091674950760085874, 0.093889568507862869, 0.018461809167016202, 0.072376690169920474, -0.073214180005912344, 0.16815725777031604, -0.087308251653766919, 0.18630355164801837, -0.051884161133876845, 0.43724866785500943, 0.090988170301804547, -0.20347125613562181, 0.021958734593914633, -0.53725115016748715, -0.24210776453397659, -0.061367809125591859, 0.18983259339360595, -0.25549056497616973, 0.020210347992042466, 0.26398446792884017, 0.25596488498905606, -0.27706135295040429, 0.35070273491882248],
                             [-0.020783536022512469, 0.15350125912804716, -0.074690713308343371, 0.19084091180444879, 0.10382728254046038, 0.041174799545862117, -0.014712353257280172, 0.22337054862919992, 0.26337484040242509, 0.012691349881847452, -0.094340007958401417, 0.1952594221380054, 0.12945531842220698, 0.13139190673567736, 0.0059465316933997488, -0.16289771647449525, 0.66896197034491933, 0.14562749752866633, -0.215241861324316, 0.12466363685058385, 0.38231102416059959, -0.42422869479497144, 0.010970468256207191, 0.05542037029442011, -0.16481493746303205, 0.026684602928671912, 0.049418398667170842, 0.014338518252870205, -0.080403255641435259, -0.19533516027743816, -0.12963040693075953, 0.11048186803387486, 0.28273021475272897, 0.14738606685622482, -0.13341591946387063, 0.13070381639661266, 0.28228250460520798, 0.065481692422935139, 0.27838736004068076, -0.031364853477253672, -0.0091522646593757521, 0.033452630390163725, -0.37993818451761457, 0.065263570362490281, -0.16112689796223617, -0.154267373495588, -0.22362343675864774, -0.1189454092627544, 0.48905445544750981, -0.075288165503091059],
                             [0.010333006218298524, 0.0019134847183278139, 0.10173842691926491, 0.10242556147394899, 0.21969545792166362, -0.046839487633348838, -0.0013247085621056164, 0.21296463168695179, -0.48817963005025622, 0.30279127517847959, 0.18690359124935485, -0.20348311402739805, -0.070950432945087905, -0.043016071229518754, -0.22275640826865684, -0.45393068318310603, 0.09586749342795077, -0.08363321036381749, -0.052760709653059429, -0.11693393529093393, -0.18014144192102624, -0.26713043328278097, -0.30806727046398213, -0.23990763137719096, -0.073744861128120176, 0.093063400133310284, -0.13010117604433225, 0.29045187812159867, -0.030172474216438844, 0.083860853507855257, -0.12105157896135768, 0.081727845724432702, 0.17805676683798097, -0.23487599891181632, -0.021592003763438949, -0.31202884003809273, -0.15210348130621396, 0.56942168190244813, 0.1514586346578122, -0.20206357325675089, -0.043906146290378548, -0.32294508905378305, 0.044471746312392105, -0.21119432148095149, -0.071577640122918174, 0.079304506471074274, -0.019049537871994981, -0.10280251715747388, 0.079790966832663832, -0.0010131094782711292],
                             [0.0088725682904630745, 0.10987293844902588, 0.27818523962857372, 0.39264479627082671, -0.070026991225470486, -0.29978278374202932, -0.15379523250174487, 0.56802070687850792, 0.19370799544823561, 0.15333390962351592, 0.019166054058197515, -0.23356458133566729, 0.014601936636873812, -0.14964565492343329, 0.27519998223190778, 0.12903167983748184, 0.13531908230211209, 0.14209425155521507, -0.031248693995684924, -0.015415548894810907, 0.19687891638586313, 0.025143496739452931, -0.089315706411809331, 0.11660891940222452, -0.12748588320714244, -0.066675101817043128, 0.45817756131202148, 0.13767048460338741, 0.12560462434264544, 0.044842846637467272, -0.35430768575670479, -0.050984532489929971, 0.21848074934997472, 0.19314121704532869, 0.20628033841183849, -0.24380981108745456, -0.12032202389553454, 0.02204048452536285, 0.27209071988427258, -0.0036342088962924941, -0.17608311859053649, 0.067397209526072227, 0.32768864061135278, 0.098446375836446096, -0.24792803041364489, -0.29167618121073396, 0.31756592452572635, -0.19747721787555228, -0.44204027636076354, 0.13694109534450877],
                             [0.12675625630242363, -0.028279044595956464, 0.15303872833699009, 0.099319984206907186, 0.33938836851614801, 0.068948387207075287, -0.16440006597585002, 0.33967059432069102, -0.099416093357737198, 0.057299069120881216, -0.28182941627146102, -0.31231155443190223, -0.21241203159937586, 0.28468281064973577, 0.11620685128310311, -0.0608530785812013, 0.12858972931776017, 0.047874140699754479, -0.43490450815991821, 0.18548284544755414, -0.16173526011166231, 0.025310363085693885, -0.004546140281994869, -0.10489275826632158, -0.07445913411669608, -0.17822987901108445, -0.058142404247910458, -0.062671997284803938, 0.25457451883174598, -0.20779408660742676, -0.035461408727104245, -0.38270620719063131, -0.59411042381781132, 0.15262160507989381, 0.067015339680565014, -0.33676912052951458, 0.10150213952412548, 0.10547750063917893, -0.31420591574333651, 0.18789271239661742, -0.42524224650324582, 0.45106382896311892, -0.003637492807969751, 0.075747494413426431, -0.029827294626290395, 0.15503311454089985, -0.25129168601840057, 0.021456269913715215, 0.23672115991944109, 0.41494926791844111],
                             [-0.051826648949498386, -0.016101391587463033, 0.19373281922494093, -0.11565186821015155, -0.21114769275868553, 0.032449986490483244, 0.10987177739076431, -0.016722631149076302, 0.45236080400786749, -0.063392127880218183, 0.2319906277154736, 0.14191654139127383, -0.14665748495801958, -0.13215066483511578, -0.27533224675738865, -0.19666798460915874, 0.24284030133739748, 0.1261177113820002, 0.037519599054215091, 0.028176828809243729, 0.021605843264963703, -0.1961931953560781, -0.22688452443442583, 0.15024785976485822, -0.43816417248578654, 0.071794575074286396, -0.31882897947360139, 0.27493862656004459, -0.001362463170133851, 0.23526787623645429, -0.18123046895410469, 0.057267665449138069, -0.13193788386429817, -0.092512209671684442, -0.18571419413097831, -0.092781410961675956, -0.13030327950431397, -0.027493349663719805, -0.52273724014290879, -0.25695606999110354, 0.030628075646483881, 0.49774383626988666, 0.12780341131491182, 0.22100907052198132, -0.22167317175076884, 0.36854463827765727, 0.18258467010555507, 0.097614293106626795, -0.1027078640283223, -0.054383285996575971],
                             [-0.076908273341634414, -0.031993214330377016, 0.0298409137746979, 0.073266622557565636, 0.35030505156603264, -0.22208284038532639, -0.17829071059334906, 0.062257899747919093, 0.13615914451811334, -0.42423033932278886, 0.33657777622171858, 0.18313316929889781, 0.16361616203727705, -0.0062385146894803865, -0.16102865661121921, 0.1499313982428977, -0.14736105986955697, 0.44979269817837852, -0.18219124346175855, 0.075137277815792186, -0.081743854928089887, 0.049352539882489617, -0.0077411406061834304, -0.26982498533762472, -0.2786702359835681, -0.29220391318594768, -0.26895009551280591, -0.042106306374632411, -0.094201922265268009, -0.34693406132569937, 0.24046084042581053, 0.012442431176816369, 0.20408617392168599, -0.203749931006384, 0.17515592301559546, -0.43001076115963321, -0.052729480582143315, -0.19064083983056493, 0.24080316929274742, 0.13885281250269632, 0.22793527891598128, 0.10275530015136036, 0.17336768429379082, -0.13408002233842939, -0.16377918399504754, 0.28980689632417533, 0.12270069997833125, 0.17942265744916785, -0.20987896992227006, 0.23702690894226508],
                             [0.034178457498827114, 0.15174591510682003, 0.47571825495761444, 0.31987770285903189, 0.055132525266928925, 0.18413187727376221, 0.1885757316085066, -0.043533045736287829, -0.10821228564853591, -0.16850266419693344, -0.48315952624513175, 0.23447667476765974, 0.021757328615140882, 0.097044660781844469, 0.075064024250183076, -0.1595170262650106, 0.0065576169769341539, 0.072064654413450377, 0.054144605937910442, -0.10407891719949383, -0.19014973223644455, -0.28477820403713172, -0.11420982551020908, 0.47113642629583785, -0.065628757468169568, 0.23789028476325494, 0.085187930815141588, -0.10214604801972973, 0.22356147093868403, 0.028748451727578433, 0.59313379875228345, -0.067974982608701218, 0.29746572228733126, -0.076145032196615253, 0.025639493851221093, 0.12674905510958678, -0.23279197854199291, -0.17147121007036933, 0.12654460491326314, -0.092794451382061757, 0.02106663983040797, 0.25366567471461077, 0.29867817474841041, -0.29855425569636002, -0.33457276311459999, -0.1967730263260222, -0.50556007158012428, 0.09042711501073103, -0.28304249549321536, -0.25957599778048895],
                             [0.0014371444646091164, -0.10595422006061886, -0.17566966478212265, 0.13124063496353519, 0.060760681315253404, 0.30050336176109083, 0.069169546454261932, 0.37040926217187153, -0.097790715820091745, -0.29475127091749403, -0.1944460950226739, 0.53642594080789563, -0.17292959044685993, 0.10278351514663778, 0.19445139990283961, 0.38619844146811894, 0.1499005054275121, 0.14476103444475705, 0.25857221435592087, -0.3018855558954171, 0.01330253721272916, -0.025767291748993608, -0.41813743921105229, -0.40970738267258872, 0.0058827702390273125, 0.13839514452798288, -0.18571758384756659, 0.40328982249781964, -0.08333022317390415, 0.26090699015529067, 0.27757407271449136, -0.053620997606719525, -0.2999059955412674, 0.076661156650791679, -0.11151590339221286, -0.072257417653256301, 0.11301934776311016, -0.029993143101091541, 0.19131656969675545, -0.021184336440622918, -0.05267359085922485, -0.21936801259703864, 0.0082618633756887435, 0.30137255349435466, 0.11065861794719935, 0.078728989543593739, -0.062295006779301741, -0.21129753224413642, -0.087710699470544398, 0.13216526573405576],
                             [-0.11763413265904521, -0.45711678176671411, 0.1075949982703313, -0.075879444137399013, 0.042324354368617596, -0.27565350635157515, -0.16935224189936521, -0.29459012942941565, 0.027845426970849605, 0.31744199400636547, -0.33938066477625872, 0.37523255216092954, -0.14671335440383412, 0.14188011766889574, 0.2753441423250908, -0.092422968688723767, -0.38194067969247919, 0.13550210919421404, -0.082020735049066804, 0.042281150699586795, 0.051686374381481381, -0.098898157338285692, -0.0039576461910581957, -0.4428117365353188, 0.21001904527018331, 0.14377662686763648, 0.078574642394272351, -0.28485174122561768, 0.1382428564940196, 0.10077260169751524, -0.1908268163457042, -0.085442778623476712, 0.33684707650126017, 0.17394586843845503, 0.14679939432655836, 0.11471164813277816, 0.090156282565141535, -0.036175693345078377, -0.12893939338801991, -0.35248544215152561, 0.10086587554332765, 0.024251866230665775, -0.11731749350609139, -0.14237922547805751, -0.092208027317187718, 0.047371531278649785, -0.44398222092684081, 0.21780024344611043, -0.18332960628847, 0.13445654992763673],
                             [-0.11827170626912974, -0.054300797919976829, 0.032319545694973473, -0.48109008761820454, -0.054820214476789843, 0.27120556618509123, 0.055733948666116723, -0.070641390589438885, -0.34740481299290432, -0.2353128903662749, -0.032811167544886922, -0.0091540006926049272, 0.0081236238460294426, 0.28567297293311666, 0.31625274200278058, -0.21217479954981178, -0.028425537915160448, 0.40054228545794723, -0.24772655381050679, -0.26713727637123191, 0.12927912430957916, -0.39300368810439906, 0.0032096133217737847, 0.27973171022521404, 0.36159096737719926, -0.038046599734820372, -0.02720327363910293, 0.20270440116960753, 0.036480505068417046, 0.10053509103906677, -0.11394641856668603, -0.46603324978209099, 0.23203600896020893, 0.0030599665617716647, 0.068585792606361592, 0.051097984866990277, -0.072892664977275895, 0.064352354651945859, 0.17230789273418959, -0.082379561198228257, -0.0356309453744071, 0.16263431495014463, -0.33291815169021433, -0.079020686063745682, 0.39437865053240773, -0.042886467830279079, 0.32075281081845908, -0.067574325305644251, -0.024824395923573318, 0.50289943441612361],
                             [0.065902654202852851, 0.019637686765593739, -0.26870327150613837, 0.014884216580371687, 0.13415876340310726, -0.19809058833914939, -0.072634483474820932, -0.11302766968356798, -0.43034527888333923, -0.36059419464967701, 0.13710274408347001, -0.048554956435882854, 0.061444444081201866, -0.1095914038312699, -0.26544377596155788, 0.21415035305959562, 0.22629972275721907, -0.23832147612888138, -0.38312575159934137, 0.30211013924544622, 0.31866041917099458, -0.092991461922255603, -0.22955312451299437, 0.21557086861355493, 0.35395842624343521, 0.23051397226794548, 0.095030010847461044, -0.094161483003317475, -0.011123165758043049, 0.16335259807299124, 0.059893374136329072, -0.042179275011135595, -0.11477482453580645, -0.11342649150960001, -0.063588263739710049, 0.046179388310083773, -0.15910998954517927, -0.12206013711813345, 0.21965994439246664, -0.35898241929555169, -0.23678355492297148, 0.12626573693411608, 0.35803721491936086, 0.23689694155300042, -0.046063623681568258, -0.10035964256262223, -0.29229484246145898, 0.19974491237387967, -0.20291179264756798, 0.1013259132487271],
                             [-0.09684582409904989, -0.15226478595349352, 0.18727901416912293, 0.27947221744029327, -0.059588630845754893, 0.018634608021806796, 0.17484902625697496, 0.2444199603304883, -0.45193727668588135, 0.050780220002353688, -0.13176589900814911, -0.13562058602242655, 0.013994252750616842, -0.022061943244336989, 0.17936154187064196, 0.18414335995702727, 0.04348715655038031, -0.40524603458744424, 0.050447346347927531, -0.10581658934662164, -0.19937625956912206, 0.031024002386783503, 0.15708769949256682, 0.022281009021309382, -0.022379913448059344, 0.22698729898398945, -0.20320278051375573, 0.19784990713140094, -0.12830277094890249, 0.11428986954916903, 0.15952117037385199, 0.12246590033556531, 0.23921253369133802, 0.044945688755678517, -0.23681726772421974, 0.18569174417626527, 0.10707441002144055, -0.3224381339868137, 0.18377107883496271, 0.056756253579378579, -0.11000575565727042, 0.055208127835807225, -0.36606013622180233, 0.21862600422522285, -0.045799031356577528, 0.13536403629848298, 0.19171008319949634, 0.70707637287683156, 0.035241703851274099, 0.28586941512411723],
                             [-0.23518761997415605, 0.38563012928286655, -0.17860862241273875, 0.21265154187149246, -0.28796300050215451, -0.024071395389561212, 0.20194190092500808, -0.028272168488004706, -0.17281860530308976, 0.040326405871978638, -0.13434126221376738, -0.045262809637461751, 0.086460273973843885, 0.20623932850267071, 0.34846033060729764, 0.30737910345232927, 0.12298630758497917, 0.32758960655491254, -0.44044492768861171, 0.099945616531948986, -0.14254789232887782, 0.21133226655940357, -0.16643883885175387, 0.021603828628234609, 0.054359738042501847, -0.094628012714581183, 0.14594095381088987, -0.29880086076649692, 0.067151526820376201, 0.22872803095029676, -0.028560139639863119, 0.50930940370771316, 0.0077515892328128555, -0.1277470982319181, 0.043528483798038045, -0.26416289893806638, 0.086838416241940428, 0.26748998837012516, -0.1492953445274546, -0.084828601513770946, 0.12200767051409635, 0.13942412551095579, -0.34241241198805189, -0.065407125242601574, 0.044359374129674924, 0.29762107047973951, 0.13339486295337383, 0.031986104622460598, -0.19587996311131448, -0.18331171963049087],
                             [-0.05110383935001489, -0.030847197880854323, 0.11853386413341492, 0.016299431507485029, 0.15208456246638438, 0.19425677438140182, 0.18700613964866825, -0.099219051423967961, -0.063654123428629569, -0.317606392744609, -0.16535501790891885, 0.18206667097406232, 0.11264759984883733, 0.40842345002483149, -0.041727861097843932, 0.30832038233267972, -0.13654260518215017, -0.46282429591425156, -0.32996610860657066, 0.013507533915846189, 0.116651769758659, 0.05440724555627198, 0.23511100665240181, -0.094561817074850119, -0.22804286011268979, 0.096683831945057419, 0.40365467994601467, 0.19529924567549348, -0.1534703368489331, 0.15125176162500809, -0.45569783036863898, 0.062505539948461475, 0.27583457429666547, -0.16040254991256747, 0.085809625190856109, -0.15491353999176982, 0.25361438262271124, 0.14699075094227962, -0.059115886752833857, 0.28240541976933098, -0.063933211901823467, 0.024178014906761417, 0.20170811522951976, 0.026654555288571177, -0.014259814426057497, 0.073488391683188256, 0.18260825193776586, -0.063986800062811919, -0.090790595160372189, -0.056593890295310693],
                             [0.17645335309011104, 0.12320334002233681, 0.071969475400987623, -0.063379809200885789, -0.26153920470772696, 0.26583229819756521, 0.23764072114520474, 0.36725916841170225, 0.0050565166925693981, -0.022484160103494352, 0.20014474185474732, -0.18654691078171259, -0.2721779625271547, -0.11277059099717679, -0.26753523050789346, 0.024029477111478889, 0.055788600457040816, -0.084083376886459005, -0.30646942029334939, -0.16181783263621005, -0.13354210160004687, -0.10632334932729393, -0.15923571866179337, 0.076985453011138918, -0.079253716333085131, -0.037537063934415783, 0.51885588829366847, 0.14047962776491274, 0.038771259098519931, -0.29720390220881754, 0.17536543146152431, -0.26787930068582999, 0.21140214678464575, -0.39905615498898028, 0.011702527017046105, -0.054288133531046529, 0.43399453671118537, -0.40672213884524488, -0.14638557005778352, -0.11161041140391123, 0.27018564226121722, -0.39266775873527698, -0.14706946066769638, 0.0071820459946510106, 0.1703552389055156, 0.2141145797680693, -0.13763427736897416, 0.23951483513806246, -0.36234415033785322, 0.054432435634810275],
                             [0.19645373637502722, -0.30494460514849481, 0.18337610453846176, 0.12522110715958393, -0.31821229795741213, -0.019308666041278955, 0.16232957339542808, -0.23485126159410941, 0.14063978136992475, -0.26209309731297986, 0.31607438251243264, -0.099319813389638412, 0.0016284809543660426, -0.19541215385641242, -0.11161040725550769, -0.05133899974839691, -0.2879247287446447, 0.13232348215699674, -0.45988072120535706, -0.048483463072904034, 0.1110859369131672, -0.11590014838322414, 0.13888447427739994, -0.12654063194799714, 0.24961646426079848, -0.25208859629045849, 0.20924376488733767, 0.33239801755328413, 0.075737946266842451, 0.23963478547410488, 0.32420426517889828, 0.063747716597755799, 0.11714606071388914, 0.29522151127246143, 0.024248052444135883, 0.058891419301379158, 0.12601890129312571, 0.14282511567636874, 0.38543577789068822, 0.32085294954828414, -0.49097681123313808, 0.059205730520791935, -0.03897054380923165, 0.079002240844582086, -0.14497002168888418, 0.040982589570747865, -0.30494914717066191, -0.0078627249120713193, 0.19638646806971283, -0.33121443852300836],
                             [-0.22514282600841357, 0.0012024319507032478, -0.38101484770263366, 0.29269196739156828, -0.16892262997621663, 0.21908654893840079, -0.40819743503568562, -0.12565914570105932, 0.21270049070593736, -0.13835874915839552, 0.15034781328349084, -0.076545939165642257, 0.1124333433951845, 0.19402488493317649, 0.35169473143885221, -0.19091431687556393, -0.23644586569697643, 0.0036580158745342295, -0.26795315263358949, 0.11005414838661474, -0.29129016614703901, -0.29679632861908628, -0.4008198569096596, 0.23079001030219098, -0.39900338464173885, 0.25662752244517978, -0.1849139826935316, 0.28889310174730426, 0.21312009995473238, 0.11084080814906269, -0.21502101837818768, 0.11177854971323056, -0.11996578137238167, -0.0044985007141570364, 0.12731483112012631, 0.24164400672095168, -0.031040239279863602, -0.10922077607182477, 0.061089270017105568, 0.28970311950135169, -0.008261576891491389, -0.21397727092351915, 0.17938005612603164, 0.27587566854897788, -0.083274210947421795, -0.1732517415551604, 0.040814926854975356, 0.13927279898583392, 0.10586349448077739, -0.18202533900060133],
                             [-0.18140085289865718, 0.02879273743991705, -0.14487141506616288, 0.36062601894937929, -0.12187340003872559, 0.010835063086172729, 0.004181054561537033, -0.11648114746266514, -0.231594123889281, 0.16763517212339088, 0.2782020490456335, 0.25378756708282546, 0.1561112569091945, 0.14059418902448775, -0.045896749034474105, -0.20465870355915167, 0.16555659677332474, -0.033126272841719324, -0.061650706071608212, 0.073244784360245077, -0.025656931245156805, 0.023364730400216738, 0.3820596347950993, -0.080455446122904881, -0.2843313571933479, -0.39974705628599377, 0.1734197707308722, 0.043043094108218043, -0.2521283263442759, 0.43401443577264059, 0.096091388410310161, -0.53415653255387818, -0.41083089059933631, -0.25651757045878681, -0.057305308035292303, -0.0248884280135304, 0.211338442019881, 0.069185735367744389, 0.25486201765323663, -0.041178025906383919, 0.22349776564733193, 0.28519986267175512, -0.070618842586154446, -0.13447382822454609, -0.088247589500267884, -0.079356770712639899, -0.16462723096925042, 0.1281370541701323, 0.041144407433045614, 0.11755897975477884],
                             [0.50960745700019883, 0.12516332119134099, -0.16056677211771553, 0.21407290256265984, -0.03807802883203084, -0.27576829710447587, 0.13795851737237386, 0.022790250373183489, 0.037916938366972255, 0.28241765078908915, -0.17196569238096751, 0.10949552454960865, -0.02597992011670618, -0.25708586417377433, 0.19582984891379074, -0.045798525493028173, -0.4294455004337645, 0.091828405767394594, 0.21590591212505345, 0.1759591828917299, 0.30020210356628302, -0.17924628155897454, -0.026596478698456508, 0.30459534967767066, 0.041600845204805337, 0.33301941508730665, -0.14305630598704214, -0.22671390974339836, -0.27407975343232244, -0.063357522714601988, 0.089627992380621746, -0.20784723327002455, 0.19343751053584024, -0.051373512078806548, -0.10584462953621543, 0.052172377371093946, 0.0038164234026960165, -0.050059129838803638, 0.038760306790193697, 0.18293844751927257, -0.21288240395941052, 0.08484898809976342, 0.058829736420830933, 0.19143886586039555, 0.39381034190682634, 0.53157746009295881, 0.13707800993013916, 0.086449699182230791, 0.075632240650816876, 0.13260396657295448],
                             [-0.06693965632291049, 0.38437596360093124, 0.054473153199204621, 0.24284755842649702, -0.16237918356827727, -0.19821454020655682, -0.21736251343143076, 0.022786068302463682, -0.10960806997940253, 0.05465386786661746, -0.069379318004614318, 0.0090932253838027135, -0.0076547527990966473, 0.15426929758512883, -0.38073707703539234, 0.020740007191810694, -0.10016203301688024, -0.053484121669791468, -0.027220674477778636, -0.19999544822365767, -0.029471737576111781, -0.38839588309393203, -0.14874312296420589, -0.16873594117742916, 0.35734694198833694, -0.052335328343031014, -0.1720912513527221, -0.061018755835425861, 0.1119330972783087, 0.071262095047342211, 0.091113668692437214, -0.20699236464388654, 0.2872171336180071, 0.14011221891332018, 0.27692152925817465, -0.013058778841637185, -0.027388847637047579, -0.0051689841549645626, -0.015718776405752543, 0.39560109071699784, 0.4079600927682791, 0.072030917725636454, 0.24611837735762399, 0.57876335831349701, -0.19825176579068826, -0.053474138127574115, 0.21678842986310723, -0.23233385061018685, 0.27082444420057655, -0.029277883822409353],
                             [0.1619801291630095, 0.0043274671010689603, -0.34657087174750101, 0.010498828171019367, -0.4236828208745344, 0.12706039511840522, 0.0097537553294340072, -0.079018547976170819, -0.035369688299900066, 0.13389535538632477, 0.010957158682588248, 0.06427424523687944, -0.18516146637338526, 0.23946352065691842, -0.030660028132000635, 0.27909369148559549, 0.21196429825681959, -0.4795948448637376, -0.030295235141961672, -0.15201543101610104, 0.067131793937829753, -0.19111231998232669, 0.14470829642223346, 0.13544600175954422, -0.34094591254993373, 0.092460595004228388, -0.32966305982563865, -0.38555349364682034, -0.051590911998004946, -0.12334574163455028, -0.12469104908263497, -0.13732710026932962, 0.061533127189508888, 0.0090816779352988243, 0.61912025302429374, 0.080876266957186874, -0.097837069236958757, 0.28477392286577169, 0.12898128074854498, -0.026327567391925408, -0.12671187427526923, 0.26292718933942522, -0.24931047429823849, 0.04631571234822307, -0.073306468306749265, 0.19169892745665304, -0.10987221977317918, 0.12497864280899092, -0.32775759872641475, 0.078660672859129574],
                             [0.063327459042775092, -0.19280718811683029, -0.018448312350631685, -0.058457741722678383, -0.37476301380161603, 0.090162355927524182, -0.2012868805916079, 0.1757691487572296, -0.14803673415232041, -0.20436318700212183, 0.13543742437467321, 0.222158610489992, 0.30604321656930261, -0.027646452092041651, 0.22477070907417468, -0.24601597096930911, 0.099955248881943529, -0.20013903715097056, 0.021038614061902453, 0.078898152567675628, -0.38489568643916028, 0.25898698103377432, 0.16314047916900901, -0.13484462742232281, 0.39070683507975795, -0.17121720137246813, -0.19586220720969943, -0.26250046461546206, 0.12521581389842576, -0.17707215447757529, -0.1843141359526472, -0.30347292852008456, 0.27781395645075091, -0.53105663191070218, -0.26760926679158004, 0.1425265400461857, -0.026213745429355624, -0.11648037339966796, -0.19373891453589034, 0.053574562624845376, -0.29917613867091364, -0.061041800313862159, 0.039619351553936324, 0.36249435025731191, -0.44530932729845796, 0.25348456136029757, -0.1765887369265724, -0.26442982510747809, -0.1177180529917092, 0.069443267743786091],
                             [0.22863202785321035, 0.046939980702941649, -0.24940955909517321, 0.33998051505958571, 0.13350278785893993, -0.48841036962392209, -0.039272010317267542, -0.25024087775772136, 0.056517268284675695, -0.31378904490141168, 0.27833135389864233, -0.070948676415466566, 0.031266157626072058, 0.26864713547659425, 0.028471512090412765, -0.34615448225347123, 0.14881124175090368, -0.13897439889887478, -0.09268363077271595, -0.46806693982331521, 0.098056794112807336, 0.1313133448919665, 0.0071702461072528836, 0.052706316143781851, 0.084163964732953886, 0.064125471371061588, 0.16836691414036783, 0.11770795337788584, 0.014927655595130537, -0.28552000586691273, 0.14294794021388429, -0.081613209261824596, -0.10779184625563507, 0.39522566301693218, 0.15008562052382679, 0.38799631030646414, 0.17024590471411583, 0.33440631645131408, -0.40644113734261855, -0.074557415862297985, 0.038505495288263573, -0.041277857529052844, 0.032120993156337929, -0.23480142477033289, -0.16447477300909127, 0.018527244332703703, 0.13925826500001143, 0.1022944600248039, -0.37257315508816025, 0.25153391062385716],
                             [0.58071596125530922, 0.25601801194651286, -0.090135495379294966, -0.088797739604828035, -0.10312019640540561, -0.077385980221557876, 0.0196102571238847, -0.24782974655750645, 0.12988937454613675, 0.10085232542686565, 0.1640787173317671, 0.082025299684610808, -0.09571565038955486, -0.01393863315055564, -0.059600896221616302, -0.0035622881509496246, 0.062427162716566204, -0.022897826687924037, 0.1855578874446796, -0.16302190851739323, -0.27857443692925998, 0.12292142074764129, 0.07662075922601301, -0.29794970949247107, 0.0049586913321720688, 0.38993071679784203, 0.082051896736123578, -0.10220695857740639, 0.41828590387921932, 0.24090120224797706, -0.25078691177652268, 0.15794146728844449, 0.11409224066867846, -0.13038541893183769, -0.20391414892415372, -0.047422724116871706, 0.020142552440842738, -0.30869771818141156, 0.34916023707861177, 0.44582878766007394, -0.07749975819768018, 0.13131634627365923, -0.14636344777023369, -0.22905656380132108, 0.18443813661304923, -0.27733780396764851, -0.074013194751710157, 0.27809795366596807, -0.22131237235345874, 0.0057903561212091],
                             [0.12969617532741601, 0.077380050778863577, 0.0025376777357804386, -0.013245847228493229, -0.14121894575222407, 0.018496824643017822, -0.14802840326609654, -0.39021792676691441, -0.27278608659099568, -0.040375302634310946, 0.20947326773521577, -0.018141295361997996, 0.18150674502667444, 0.12769417399935987, 0.10879132413853525, -0.26960327389711797, 0.045901671234633908, 0.044144489116562623, 0.31707696038574018, 0.067187795033279568, 0.19949034275640645, -0.048752741755526977, 0.12448979009739478, -0.069846123494033449, 0.098758543529667148, -0.17787089152701757, -0.0080059964782585539, 0.57411648318263397, -0.12200207959706447, 0.0036585202310158611, 0.16131211240762394, 0.66388247097396769, -0.047162538497701828, 0.038125167164997864, 0.29251358484869378, -0.34913802725870996, 0.04598329672141873, -0.12874827157996466, -0.22734049581995042, 0.09369149424516772, 0.25631022201775894, 0.20455327527231398, -0.049084393845531239, 0.25724234551692038, 0.32289490363013496, -0.12731672218858944, -0.49843043423175432, 0.025886057260198866, -0.20881794910301635, 0.015570361925666644],
                             [-0.12159154397943633, -0.029772676166243309, -0.30663222953270886, -0.03461116090828991, 0.12367159289953591, -0.20387406530274932, -0.19583090349970922, -0.28327381532028884, 0.26692702812263264, 0.14057991658425195, -0.41268232680910194, -0.31212428913105439, 0.14042330484300802, 0.077359088440811699, -0.013267408287006545, 0.039412628450548756, 0.074848371489383669, -0.16491437116736044, -0.03139704278574032, -0.52847996967008382, 0.014657560321907221, -0.23337449754314346, 0.047546343431829979, 0.069826265725447784, -0.28298726462709006, -0.5000086330743313, -0.030954626416609177, -0.4115024137284648, -0.28699662377319463, 0.16845999067992132, 0.01955262721748955, 0.077370360745895636, 0.31385289235126157, 0.05967364441437964, -0.48456716115232384, -0.11383254816815672, 0.18414474499339945, -0.13790325993650535, -0.098557294063261955, 0.072942757710525899, 0.033339053714908244, 0.065995582898186411, 0.3163769607606674, 0.2012992512218571, 0.22675509260284021, -0.028224093660017067, -0.089257865800905042, -0.099766006565992896, -0.0039645554605149038, -0.023673793669077917],
                             [0.017287210551503257, 0.14491327758728567, 0.15845791340905885, -0.17305379379320263, 0.021506347392832761, 0.041725905571574268, 0.08630506230518066, -0.21465431626146095, 0.2625106121331639, -0.30679613985081799, -0.21633268505068498, -0.13190602396806406, -0.36664271742145743, -0.11820846210765375, 0.33179174810834533, -0.29080435501394558, 0.34303016789254892, -0.055464117343921121, 0.14530688304859929, 0.60837599362596462, 0.029731219055242904, -0.15500195602713263, -0.03433246003570363, 0.061743989328829796, 0.25354287785219226, -0.30333288100632377, -0.15780628539020469, -0.2675002639138136, -0.047613302475487701, 0.2283637514306161, -0.22309972741087378, 0.065269899871028811, 0.0049156383157382072, 0.049341388538328299, 0.082969913214548746, -0.11025759413815915, 0.12528137866418365, -0.055868158555639778, 0.3217985320495883, 0.085718319281068864, 0.10502609387983992, -0.48259714596616932, 0.091435661546067221, -0.11961961318414069, -0.096920856153137808, -0.019638169185425033, 0.21063301674529067, 0.30526333759386226, -0.078049618720901326, 0.12868745782770155],
                             [0.35330145218224696, -0.13418066956885374, 0.10499624713988305, 0.0239247960860999, -0.12314485671904621, -0.25853523403035544, -0.44609621061459753, -0.37849212950674638, 0.22104442210985759, -0.18825544360413279, -0.23946104687214728, -0.37505000283186291, -0.26481781624153111, 0.069150798365149715, 0.17280820502886507, 0.55627796367251992, 0.050457060029289048, 0.066369134764159371, 0.091415377898016778, 0.12688170846081903, -0.11640880792039443, 0.065236411477446021, -0.030996148689738795, -0.019779700784995538, -0.086183292255796407, 0.34270201871732142, 0.16787984958346258, 0.41283604472269786, -0.033018559049091831, -0.27608655745911309, 0.23446123157270782, -0.15930259238861816, 0.17269692576213899, -0.382170723362529, -0.054665217615067867, -0.22678082656690698, 0.18146202665983238, 0.31766633253682763, 0.088570643670566981, -0.22770541726857046, 0.22203820386120193, 0.048303424349836935, -0.03128273127924705, -0.13190419299290751, -0.088210699075983279, -0.08181293833705261, 0.24271247397490373, -0.039248287635004778, 0.37679214736196653, -0.037238700646138177],
                             [0.070879259041762593, 0.1094018170994812, -0.37011369508648589, 0.36989327986373866, 0.25473090667530551, 0.1952655585667642, 0.071913168038588479, 0.053065211938219468, 0.1743432049067917, 0.20695864310144027, -0.13270183808963204, -0.27900070067937061, 0.22192261477680325, -0.18875574827700381, -0.024470361855248663, 0.16430168203864573, -0.088128144429157534, -0.20654513396309707, -0.12633541840447859, 0.42100407653853639, -0.074029934521793572, -0.12139882591690482, -0.030584623468554437, -0.35496098047768565, 0.15897455795138773, -0.20744181236434051, -0.042202033461996531, 0.17943324703520511, -0.03384552412967666, 0.22369712703885866, 0.28300761321555523, -0.15620958201028876, 0.43501170183051568, -0.028429049581435027, 0.050825130561591741, 0.27805247102122477, -0.17966947303946643, -0.19355952789272574, -0.14093835421799064, 0.042286724456916065, 0.086353874015867749, 0.21420488927074285, 0.12527291584152894, -0.37032376867104605, 0.045819424644329268, -0.074920971712703649, 0.16075484408817703, -0.27202036575697669, -0.27235630131737076, 0.084115617555771044],
                             [0.095463569639676865, -0.25660099689597754, -0.31004356981297815, -0.16092980734453349, -0.37626152299595744, 0.12338189197325247, 0.09005024154105834, 0.054476367068925086, -0.075696958478983806, 0.29928533542957858, -0.49148008053791259, 0.17097301800326897, 0.15613041314323367, -0.16989659016368444, -0.24760911157348667, -0.22806550215238594, -0.19254180697824794, 0.11216367372997155, -0.21350578180389376, 0.10535520827934655, -0.19733404768701257, -0.22067067717853955, -0.19469768649811303, -0.21773779108417746, 0.26426032191272664, 0.21235531913282335, 0.368018065134957, 0.16159746648822396, -0.2106846173040971, -0.38771786700364641, 0.12392294179867773, 0.18831916846799004, -0.35705514471608529, 0.088172396008515286, -0.015273586788690729, -0.06218216912241091, -0.056482257140940365, 0.071063522955964631, 0.11687954755683802, -0.067367175990654657, -0.041329461292293784, 0.16057652463356661, -0.065111221830156663, 0.075538329749488708, -0.32245732258146398, -0.039866783495936781, 0.38488568956540248, -0.0086619130561087151, -0.11937814820386823, 0.13475918689315339],
                             [0.030959278738457136, 0.025658789857556093, -0.11377876903448933, -0.28699495855679669, 0.20005569030449619, -0.25578904302937366, -0.12060363455178449, 0.29785686874214318, -0.18405555567650528, -0.347197443633181, -0.1996426612262939, -0.29530973109435121, -0.21543193513721029, -0.27387086651620329, -0.013077018828058243, 0.040246979121552895, -0.0831274292505461, 0.32952706108901891, 0.0092491977901749782, -0.014895959277087003, -0.02857188543721504, 0.09807974681897956, -0.01782784516796062, 0.097159880759550246, -0.16965457330769962, -0.062897396455637841, 0.067685999831742116, 0.14649354479717849, -0.44505858384982838, 0.23453148437323276, -0.065521262809867448, 0.014285527106067425, -0.0045175988879192254, 0.17285740860430443, 0.084720003305034139, 0.44924083498733314, 0.44014888187209272, 0.016041984693333153, 0.047508459970672046, 0.27600532258132782, 0.15473585359274233, 0.42236702957163336, -0.037581684014462054, 0.04870745197812907, -0.30917240211755437, 0.035536932570599658, -0.28681275227042613, -0.070860918468028319, -0.21313436629010024, -0.074356507969129848],
                             [-0.49416658224490972, 0.20484671987096131, -0.10798240275092683, 0.31988551105781704, 0.028616176513283634, -0.054238844413870356, 0.34091854294809221, -0.47560346587830477, -0.22071293895185345, -0.062302984534332417, -0.057292709426501977, -0.035797727821344549, -0.34319372227406719, -0.20874632448010833, 0.025937659443124927, -0.015554554107511512, 0.079709321811684983, -0.064687066026249226, 0.19714782816077919, 0.034950532244640925, 0.28887485398482654, 0.078432207320363795, -0.30743831886413353, -0.2798471112043322, -0.28610535583098945, -0.22701347917315001, 0.33527069650523167, 0.15475681081110976, 0.12735625026148678, -0.46147052859958537, -0.21288174276716604, -0.13383392402320998, 0.11357442004055643, -0.058635531305376618, -0.07060371254113959, 0.030323026143071169, -0.21418091602544809, 0.048447893923576575, 0.24821068899570656, 0.28322916400171971, -0.06494169829440001, 0.15642839241116757, -0.32394941807501954, 0.2046381383872321, -0.0058973634994084609, 0.16468984852905619, -0.019179144897792794, -0.0015151986833032045, -0.14365105062702901, -0.17746837117262876],
                             [-0.14797243355404832, -0.03176396270068272, 0.22333052770607095, -0.036522063183718791, -0.089927635624397331, 0.17026987337354552, -0.43478736894819908, -0.18745748728477371, 0.087653940719245552, -0.25822199458016282, -0.088038619696332615, -0.28939774094735704, 0.43717014326311254, -0.23591042421570638, 0.0055000811422020214, -0.35579088345810472, 0.11025534099896403, -0.16125259674597328, 0.17469618687162172, -0.10724719680828493, 0.056271003606939055, 0.43291901102886193, -0.31260325281210749, -0.18461447147686574, -0.073647249015415306, 0.41639232605099985, 0.2144664317341487, -0.32880124201839883, -0.18033098594238234, 0.23271970024315758, -0.031103221822471522, -0.2647912575956603, 0.12078342048153401, 0.38348698693614647, 0.14646408286411669, -0.308389081032514, -0.041668314005022217, -0.2344013012525466, 0.0052497012828182218, 0.19391390296762726, -0.013171162873601101, 0.14201837532491773, -0.15601797377463272, -0.069746106088239931, -0.01888209795177628, 0.32501405161027752, -0.077390209418194272, 0.048672377305236124, 0.081076492089592972, -0.023054915724492003],
                             [-0.54010682204918192, 0.11525879138805926, -0.09707799449246618, -0.087119248262529966, -0.17663052844973764, -0.26146807317566029, 0.079379479984723972, 0.22891453523179089, 0.17765407240706765, 0.067013674847035576, 0.16905988104047573, 0.12815265778811311, 0.14314959718227716, 0.1387775638845892, 0.36959044778232431, 0.026651366605693068, 0.079391527244146887, -0.24552427492426304, 0.1963221637974305, -0.030142269647521536, 0.10463547786300943, -0.43426523633397879, -0.17758204639257347, -0.076597498014322848, 0.24573858826859707, 0.15556869792924197, -0.17055386037997386, 0.0025062328524597024, 0.1463728779490697, -0.1836441568906276, 0.12398800391826864, -0.089453182465060094, 0.1801645139870206, -0.18789418446253089, 0.10264980097951756, -0.28491756510796695, 0.51590170790697165, 0.11031329418118084, -0.01622260077480276, 0.069031515976157268, -0.071768531517244119, 0.29182515697317363, 0.11276675847814452, -0.23132518641827418, 0.091805261847486483, -0.1001218951581178, 0.16388255577960092, 0.26312011279682224, -0.24938376555327066, -0.44372294690829006],
                             [-0.12330952008179388, 0.040388722755212568, 0.03912335932913219, 0.077767930767016838, 0.20472755593447081, -0.30724358264450408, -0.1664950318620822, -0.16083691846188197, 0.27481202557237083, -0.062279304940544886, 0.079282311623621232, -0.040430534597440074, -0.34065176795909097, 0.054860751912541313, 0.10718709766386784, -0.0017258892164130294, -0.06615140688661135, -0.29477667742877539, 0.015961432661685062, -0.29949814590979473, -0.10857065534272128, -0.10899451088312143, -0.14832991334311574, 0.1249047171201761, 0.46329494357819556, 0.15035007752903934, 0.20842918439435174, 0.035731118613404479, -0.52705029420648208, 0.13397877777825362, -0.059509327181101093, 0.31920204852377593, -0.071635786668279161, -0.28602977682731001, 0.047566688197900032, -0.11334727953736438, -0.12643745971387801, -0.44749086452853448, 0.085678166657168001, -0.13204517834796098, -0.13732212476683059, 0.0076884023152891832, -0.22353646713343828, -0.37297403426557901, -0.30511300512254741, 0.40170194202589016, -0.0051444359458789855, -0.26873583605389123, 0.28164623930648125, 0.25802798503315322],
                             [-0.15805571610761388, 0.2891629268290829, -0.15855885708910933, 0.038124319876816429, 0.082120857553148047, -0.0826910436844948, 0.3892851540325476, -0.21350693970266171, 0.30044134261605654, 0.086461560078239144, -0.2234332855851501, 0.010536720523426125, 0.24557981739830931, -0.15899867226125416, -0.15275972570365207, 0.12376393277072957, -0.21821755887115848, -0.065774227604263699, -0.24409453522561497, 0.042678798719950575, -0.41726435567409931, 0.29477834088413318, -0.0099457264105342336, 0.132615776765374, 0.23379391663656535, 0.25955693790357093, -0.25559988309885612, 0.23432749970754577, -0.20484624056079581, -0.26674007313835651, -0.1133143737840461, -0.24809151849737923, 0.11881537001311084, 0.21049671530869649, 0.13320772304966408, -0.58014719516149449, 0.0037630894576192713, -0.00044311362337126192, -0.098626029672892815, -0.17891339102380155, -0.11172489147727604, -0.16643881474928088, -0.11472212523822033, 0.36857537865523488, -0.098882891068315909, -0.42593731984891592, -0.31748008925726917, -0.021212968714377153, 0.016536251626570311, -0.077168352431689222],
                             [0.25574688446517602, -0.66329419429149594, -0.085013643224454954, 0.43487657472845725, 0.32867133765280132, 0.19152810978357646, 0.21955332081242021, 0.17928243472419747, -0.011650507291246941, -0.30161844702979529, -0.094307965623972048, -0.17167585891084364, 0.22415017582117808, 0.060677164597081605, -0.12003850560872045, 0.060678950282734991, -0.20306241584475343, 0.077260539744846507, 0.20827292139221962, -0.23078538982894936, 0.10364890012923865, -0.068203447304017811, 3.7234683201516766e-05, 0.23462481643194197, 0.33014744289682746, -0.070598145117964001, 0.037406271342482242, -0.29852176481800569, 0.15761876845057043, 0.25828445652926774, -0.21444941782772742, -0.089369082587559101, 0.055403954257712829, -0.3061930366503226, 0.18532365522700184, -0.38307030404449999, 0.01369700276902883, 0.0084072490668041754, -0.011768551391085664, -0.0018530561683579513, 0.070032761623092049, 0.15821735197175821, -0.46773186560240698, 0.15943024477579246, -0.0044115182470448374, -0.057519960005079057, 0.15096100133029278, -0.018977314058450209, 0.17287833343193787, -0.21864088177668095],
                             [-0.23908513152530028, -0.12880830079423436, -0.30824469206842137, -0.004453981619449739, -0.238415341153209, -0.3739559322475608, 0.20161177086628815, -0.065449875741798544, -0.090421240129520158, -0.030206535020615918, -0.3421278344066529, -0.1206410069001265, 0.20899252149282874, -0.095615657862853837, -0.37687019835794028, -0.14456840048115871, 0.031028736713935717, 0.063009655135316811, 0.18022609217867774, -0.035263701373548492, 0.085962910650506374, 0.121053388292288, -0.00036179039826590015, 0.13616202156340756, -0.14321716955618194, 0.047754104577206309, -0.17634834681924336, 0.32609729666496995, 0.57636069199385531, 0.2150272833187559, 0.049301482705407823, 0.042026098396651543, -0.16989924538264795, -0.064152047384517449, 0.17785625984911357, -0.13870477898624092, 0.042065471487265832, -0.17273814898516143, 0.1290099279626705, -0.006657455447114157, 0.0011761320379712146, -0.19702926304041837, -0.064526498159959395, -0.37746980370048394, -0.19591630478154937, 0.40272325719065777, -0.078859888318331114, -0.16405673600193424, 0.18090274476457299, 0.41039975856976046],
                             [0.46129880745456253, 0.086186260012192026, -0.11851546059041153, 0.016572032404217566, 0.25325455918845263, 0.44875923903960335, -0.0037865397727354705, -0.076027396155502455, -0.18229408982435244, 0.41604255047398686, -0.11861335038539547, -0.074630686004446306, 0.13145319105742778, 0.042131984132046309, 0.22395987676115403, 0.2603555923243388, -0.094714012272597042, -0.1132926737004416, 0.037075923314755274, -0.22957096026965032, 0.31420777388296806, -0.043710730678769266, -0.1629130871532885, 0.12569239446632025, 0.042972991603091412, -0.12058990319728746, -0.070336919037407297, 0.21267159425101756, -0.0011602762170515955, -0.10711516076188866, -0.37616722438514827, -0.022240852450668321, -0.17750508036823714, 0.27091737625340168, -0.37345837041708607, -0.048774737634039285, 0.085480984570251412, -0.17122881042360302, 0.075814573670441782, -0.14694669024772755, 0.31205997048028433, 0.032702918976743003, -0.070133412112109383, -0.21473361854996664, -0.39487032822880352, 0.3379579387933847, 0.11171246235691572, 0.030455119930167102, -0.21731670929493874, -0.38376696614217198],
                             [-0.0015835537528787642, 0.23955616395558743, 0.22268439785376348, 0.10830031351622631, 0.10240822059136673, -0.0065256401339350498, -0.099572506514718856, -0.097488939719190773, 0.18012475701890543, -0.012757087975166026, -0.16907028661958023, -0.1873881957320101, 0.025614981618726478, 0.52883914022092715, -0.42397088011893441, -0.26631326773149333, -0.107061896858301, 0.28918914919560168, 0.0726689924977693, 0.060798074005239421, 0.010268639463511092, -0.20391837996693146, 0.45981487119654246, -0.46618162708185079, 0.10352701872223344, -0.14969891837606511, -0.080009715524788014, 0.059402001855090189, 0.058631153511962124, -0.1315047577596124, -0.033971151001505835, -0.11439870620272446, -0.1463486007461143, -0.11574920258407928, 0.16330293913638508, 0.29399194214824076, 0.1083206102844031, -0.14822729845548677, 0.27285396566343167, -0.36636296488347414, -0.24991542289863719, -0.15344209564406758, -0.14974555771091258, 0.17636752993303362, 0.20255477584139955, 0.21715988847149562, 0.039859806161426758, 0.012011412594732838, -0.25972437252379821, -0.44189939505555664],
                             [-0.0068221298046353233, -0.26034965270385013, 0.13092719898385374, -0.12008194974843668, -0.1927051513532235, 0.084334081177636758, 0.2874785454915057, -0.23930878278672874, -0.25129357651308648, 0.31938188087633462, 0.082719704828673857, -0.15737454141498264, -0.14810312926562108, 0.37030750336188994, 0.099922817977927805, -0.19034464479665048, 0.29224319632454887, 0.33609577205240954, -0.13939274306055463, -0.063039664451359861, 0.17689705931683433, 0.42648947915249724, -0.38893886838534336, -0.074866989787494731, 0.13550840964245484, -0.070811800353691043, -0.23655544800148867, -0.024286471413949632, -0.39861677147841423, -0.041041478269298819, -0.18618704642970976, 0.058141006811122484, 0.12124803625568839, -0.067716640195620584, 0.26005064261425886, 0.19912939452583875, 0.27572554883705352, -0.3150155430287066, 0.17816578129208177, 0.17435806873822468, -0.13070843222743428, 0.067084778362868705, 0.50668991270304142, -0.054942891646757794, 0.10946155792420112, -0.32884480610089761, 0.14405284090545456, 0.021699046579988994, 0.12139900122281436, 0.11506454376151704]],
                            [[0.20798830466756749, 0.16443961444352895, 0.049005363219605656, 0.0263263062328155, -0.21366094004341085, -0.31606152830032969, 0.10683269319940701, 0.17022946816918061, 0.15718550682524568, -0.013662227356358107, -0.24308692374715624, 0.078151698688895294, -0.01569127274027227, 0.047559487740047909, -0.18035422177116928, 0.19298651809845663, -0.26366950609761081, -0.13733627770185344, 0.026221263336823054, -0.091019598730463794, -0.18687082326946897, -0.17536978018414529, -0.18013966430538531, 0.063819689121052056, -0.22562307585358315, 0.072402846309737687, -0.0074553325987443287, 0.20002621816187605, -0.1412546464116429, 0.034422667281914295, 0.11319464489985037, 0.22051354845616319, 0.058189511708896705, 0.083677715754752607, -0.15945187168501945, 0.013353183901956337, -0.22393734510123756, -0.38862655026105808, -0.41692418304123896, -0.052367412341729855, -0.15733358424843244, -0.014746785514251327, 0.2862036792292379, 0.22856102733773784, 0.48312111860378393, 0.41668031044969711, -0.23260541003097218, -0.15659183490332126, -0.11785185812214469, -0.004305430519365645],
                             [0.048783492268054014, 0.065242851507282457, 0.24875348548390216, -0.061631186196678032, 0.33239776636284463, 0.19386384905947643, -0.20777157819169673, -0.054326348606668136, 0.40942898009320039, 0.041535719073019249, 0.17199148391401717, -0.1423410277575303, 0.19664824079131582, 0.24630741349891402, 0.037840741982363653, -0.10650418981840105, 0.19613606959843691, -0.083224291065554762, 0.44463452784897123, 0.063455201404025455, -0.044100096099734386, -0.1847392536532797, -0.23977235933309732, 0.10585179310902106, 0.18306289875328968, 0.21970330751119946, -0.36284366363430576, 0.098121020522009744, -0.20449079980324006, -0.0073472700169654312, 0.1105496595865543, 0.1443838423626945, 0.1750592928803415, -0.2085162429839611, 0.15972791987920354, 0.043821685864550153, -0.008571988998296998, 0.27793882078588916, 0.026320560544011988, -0.18827815544562285, -0.15642439709030848, -0.086468413617633383, 0.45492019178222787, -0.22154778419426743, -0.17687049692928633, -0.03763464032814396, 0.13710058023424523, 0.012615265083321402, -0.33955562057469119, -0.040693765937118209],
                             [0.013872755461305369, 0.24210722505755039, 0.13197702604074815, 0.079155071391985299, -0.074054685986018276, 0.013366083789857885, 0.2079751990067836, 0.19151726327859864, -0.11735027126629854, -0.011982116434794653, -0.26457904730800141, -0.11571871775746284, 0.19450335723708997, -0.078521516494170523, -0.13292572239327502, -0.39120406771018285, -0.12131234424226495, 0.22117212401853587, 0.24078659132455651, -0.26469292552961732, 0.042277757722358818, 0.074741282854829394, 0.12677855578245401, 0.16157851309631527, 0.026699327336010631, 0.17345354427314347, 0.020496215112691226, 0.2778550319494722, -0.058494147560267371, -0.23906985380685075, -0.15423038036734393, -0.062075636367340266, -0.31721567363123204, 0.099092662157583125, 0.19479927453106838, 0.0046807382580928494, 0.044271258224276404, -0.015881838941607922, -0.0084659206573972513, 0.10594837887379191, -0.021352515132549998, 0.19868705816005217, -0.010343725588935454, -0.22962138076794358, -0.32331185021501146, 0.15942787118219964, -0.15700712862553007, -0.19567510482395911, -0.16014371201223432, 0.58704359377354298],
                             [-0.11444151719599588, -0.050884828753045674, -0.15929571693480171, 0.04874401008646443, -0.095262436642245735, -0.084624651192986095, -0.35831443517555123, 0.024985385024094042, 0.0090871139787011765, -0.24292809738733384, 0.079271197847633784, -0.048675257531959004, 0.068214373035722281, -0.0059597216864813313, 0.093272085858728801, -0.19182678979376477, 0.042079802386340612, -0.23616869362669773, -0.24481914247782258, -0.062914856892901161, -0.072982129786799438, 0.064891247517912823, -0.11832895653449861, 0.10467998609736703, 0.47073905030044183, -0.0044359780785983641, -0.054315174033754306, 0.23962357811445778, 0.28651191676116744, 0.044131825977579101, -0.42041599364047505, -0.1970231675257407, -0.25415021928626608, -0.021653331383152709, 0.023106089626134967, 0.25306214726722936, 0.044782341284556222, -0.31023767024844567, 0.060304339224453773, -0.21128602706174274, -0.15044378593982552, -0.25502751352915631, -0.064980515817856938, 0.046729610575069372, 0.27337995157899797, 5.8299944421816297e-05, -0.036650574698549494, 0.31894975673540571, -0.10739080611177493, 0.53279163798134288],
                             [0.19394339721024795, 0.21130637560626492, -0.10611418124657959, 0.22810069098968533, 0.36115783940516305, -0.070511930774671827, -0.095007086783205824, 0.0048646630098722436, 0.11361399213294107, -0.23412687110824854, -0.19295075089406818, -0.16083431136852971, 0.1190122875140623, -0.2753637660994403, 0.16210297875075114, 0.14026420379610313, -0.14818431172260094, 0.14717375121840015, 0.18429332104652749, 0.23778551987958949, -0.38305855146772788, -0.053866386150709759, -0.20642990351809801, -0.072872378215340095, -0.14761996872665747, -0.14169880189036782, -0.13238393914679897, 0.052940349996680049, -0.29718217732007568, 0.097467531358624751, -0.34935754000099922, -0.44278920980319042, -0.0032723795642133138, 0.25528291016661181, 0.086568917655149014, 0.09233897898731952, -0.22299315142407219, -0.11156818908296631, 0.22156869985099722, 0.14068770801258002, -0.36660063677406385, 0.23353254413995728, -0.26163404184668837, -0.068098494056230002, 0.13904546418956637, -0.16066077827751443, -0.0085660599011020966, -0.14112567002984994, 0.24849441831185265, -0.011386804512844975],
                             [-0.08919297116528889, -0.016034249135639514, 0.31721582883881083, -0.074672286747788488, -0.25404920232512368, -0.44152548648236156, 0.043171712555871961, -0.09516533039512759, 0.18701883599816826, -0.048013904742239433, 0.25282796392399071, -0.13000086684488371, 0.34987235873812483, 0.031821575469975466, 0.0061122028508676304, -0.15829538902488324, 0.052445734411788889, 0.088557592863043391, 0.065697942116768882, -0.1877286595755068, 0.38724295713382528, -0.21417365182469186, -0.16179745883860858, 0.36579202426467095, -0.22008408547468766, 0.25974131060836048, 0.19645211206866101, -0.11418779417009968, -0.04576830532905031, -0.46413554595055306, -0.064559327574639114, -0.25121324168365344, -0.11619268330593582, 0.052912905544300601, -0.025985917725140133, -0.076443821953739444, 0.11600826727324953, 0.21017702903980504, -0.05182413996294491, 0.237668760104845, -0.1996698024892915, 0.0025955792101846442, -0.25444456871643334, -0.21646785252314305, 0.38629229150329575, -0.34851232149804662, -0.033234173539307764, 0.31706284844342386, 0.28623825910318668, -0.038042929602508699],
                             [-0.22470889313466916, -0.27760304102491562, -0.22110847145981763, 0.070929271671292524, 0.077011605743995959, -0.13633281542129305, 0.13166552314547511, 0.099106915846039798, -0.16885445713282901, -0.30353162210375834, 0.22389993252126114, -0.32596593558212916, -0.14569418354349314, 0.26518998112476411, -0.28423785330731721, 0.11156078165303045, 0.02066701045858953, -0.025031829364924259, 0.25386808735646943, 0.067916041755137366, 0.28032743884204403, -0.094199960781451889, 0.05167757400013917, 0.037616962721556978, -0.16160203341134688, -0.53486102602830543, 0.20162735865182321, -0.18957362721467522, 0.081711168418992647, 0.067929648736942544, -0.11498923012815766, -0.14376556355884401, -0.099066366442195339, -0.33448597788865841, 0.23409590402103381, 0.35610340396463758, -0.28440648676692221, 0.16425676558054539, -0.09827576518000869, 0.056884723521403148, 0.022044835821944334, -0.13029380321420375, 0.21039158095456734, 0.07857322567787528, 0.14973030541650478, -0.12262483421035222, -0.20843582936492391, -0.13885991798395972, -0.32230095756647675, 0.24510859613251429],
                             [0.14664706947492931, -0.16513097627606921, -0.032792611791635902, -0.03278069400972812, 0.17849391857909114, -0.023102305108014816, 0.15692044647009487, -0.041154339729673473, -0.27018062284307737, 0.022286158612219366, 0.083881322827322483, -0.24638316784800962, -0.064451352303341231, 0.0081446599997386151, 0.2589407557765292, -0.10599692439120931, 0.013197436274499246, -0.22608829564751165, 0.069074622312836662, 0.25035355121846503, 0.028013016412633297, -0.223135845292393, 0.51463983096834687, -0.25433431940310591, 0.044350120166182019, 0.28213008258595779, 0.038920624973279791, -0.11937693293489147, -0.21861461755755657, -0.33920547107743204, -0.088186646930838275, 0.079500571838507672, -0.063091260503060104, 0.031810089345514422, -0.11427126303760293, 0.043265288266075438, -0.21245457048897334, 0.17413139131184549, -0.071254269065790493, -0.29757360986332632, 0.20112901675570133, -0.18193303506775335, -0.4821734799203875, 0.082266629219519688, 0.15593466260908384, 0.22271391295761953, 0.1100081972730941, -0.024538308382581503, -0.095504457742974669, 0.11987781814151834],
                             [0.15519288654064461, -0.1054450381687371, 0.088082322423889067, -0.08903292073910242, 0.095313719011417275, -0.38507521245419418, 0.175655173833933, -0.06349265416932369, -0.092644956782167234, 0.16477981596983984, 0.1730831257186306, -0.19308349732755403, -0.25887843605921723, 0.074166936961324981, -0.13078887594747554, -0.063530712726855273, 0.19464133012890439, -0.12987813879771792, 0.080391777648947185, 0.23617695243698639, -0.12462557473330572, -0.020139626819786403, 0.037382086792275532, -0.24237437839498668, 0.16489233010343501, 0.25287096452196556, -0.077605295366191387, 0.069238124254557595, 0.2168128397713821, 0.10825359148939506, -0.43941378229253647, 0.0020744165180369752, -0.044391861560276039, -0.4219740263269447, -0.093343091984603652, -0.56450931856714381, -0.068850272904199955, -0.14490159584009826, -0.020968740535643141, 0.52195082007273907, -0.30981399530099396, 0.15645518452549415, 0.1514583744452227, -0.049681759648776747, -0.12576745816808263, 0.30693454026077549, 0.25452432187800977, 0.081103986904384029, 0.072470754651244945, -0.099249247097878468],
                             [0.27805721958573432, 0.083145348296441227, 0.25732667754295879, -0.2164926761175946, -0.32881963992842317, -0.052698780318054035, 0.12013730386354288, 0.11177162250410971, -0.2610101144387813, 0.074949414268526138, -0.28440644488651945, -0.046388482524112137, -0.34451502620859809, -0.06272589435511694, -0.11299892932538189, -0.048417625307527794, -0.22217650860653573, 0.37453385825487318, 0.077719093461447758, 0.38761118692569246, -0.20689609364101436, -0.092279918331169275, 0.0060053140637326852, 0.34025266065135179, 0.31540351264558536, 0.019361741495948978, -0.27839705213168853, -0.36897915331760278, 0.16104679487911078, 0.001930045829125579, -0.022830540985786955, 0.21368936721738413, 0.059968997633768402, 0.014898655961702402, 0.18453066438787163, 0.30490411533284972, 0.16051015558912649, -0.092249336151545014, -0.016887746916203261, 0.076663105793487007, 0.39131338608349098, -0.32161181627558189, 0.22884865420729716, -0.059525259401158395, 0.28154074767974263, -0.15823129729402358, 0.16624868364531745, -0.16006174879692933, 0.20883968730165089, -0.015775772346280165],
                             [0.40189416372282316, -0.38000123308646389, 0.10063807369664389, 0.094439462056856521, 0.21096720015953252, -0.1987848991447192, 0.21060283920641584, 0.037537655181552797, 0.56648399990044562, 0.026732585448413469, -0.082227347872456114, 0.14723138313722137, 0.1371377805597811, 0.1155371000605076, 0.04977707100488913, -0.055466847462002505, 0.046414456324458793, 0.12317588105237956, -0.12245513636194898, 0.13465702997573109, 0.28070258797449732, 0.094526375589905204, -0.023798323223034469, -0.20481822435804065, -0.099832745046135943, 0.0058577532913701843, 0.088926929404208002, -0.13925518454456678, 0.27307876248132978, -0.26259747141705847, 0.25076424623147275, -0.20898750166450369, -0.10194927757884155, -0.24035677895114738, 0.31447659425066465, 0.079751594665793027, 0.33258887799706721, -0.13466817530121866, 0.37392052407729137, 0.095047553964962894, -0.20842880971500902, -0.042968706618298338, -0.029281597743957048, -0.054804247665441654, 0.20111364752265359, 0.33448688092525197, 0.12821334624014441, -0.28780427806804743, -0.20415101911049127, 0.063054409254310662],
                             [-0.064799065043096071, 0.19337458839821969, 0.50426822177317177, 0.36331132822297352, -0.19136926778669511, 0.066908625805482569, -0.16810072636214823, 0.19083169307306505, -0.087322556075056221, -0.36163523009372761, 0.14244045851250961, 0.22809233001633419, 0.13175368525634981, 0.03409152511134491, -0.13662873467028538, -0.12421718552014495, -0.018690357874134721, -0.32765561625453499, 0.23961566908772466, 0.13374067805885675, 0.25555450845832584, 0.066435467201479942, 0.1249718228810321, 0.0081012897299131779, -0.15997692053759616, -0.05101430562111603, 0.18129088280734226, -0.13581716355951443, -0.022369776523118383, 0.19318069224934878, -0.34317801594628911, 0.18591710450165377, 0.21138734449466723, 0.18545644224322566, -0.043725638314589747, 0.03767892745781394, -0.021744459755823928, -0.096433729794218173, 0.68560318156461453, 0.17258562091141205, 0.21320318646019512, 0.08152735163022426, -0.052096332609922719, 0.17437647096552822, -0.080544139707766041, 0.076208988319284743, 0.032969758203003338, -0.052631603304981123, -0.034248347512854868, -0.11690337252110425],
                             [0.20305620672876878, 0.12813055916579053, 0.15588609005789861, 0.014364754258897525, 0.11439557616962856, 0.44064795735287937, -0.043451900964656551, -0.090717141065112278, 0.025078117793949514, 0.052905247446928663, 0.21160869657682438, -0.14111719088502278, 0.095076956134059795, -0.035085431911903546, -0.20752248599416867, 0.21424623336141391, -0.52996578782846593, 0.20293673549988006, -0.28009855979883991, 0.0026109913482767998, 0.041597949362789988, 0.090844949903572433, -0.18101955538742767, -0.10751909402470511, 0.16706235386955434, 0.31442509452049183, 0.42824195675850368, 0.17297162917327516, 0.14072584660218235, 0.034469027168489569, -0.22094909003234239, -0.012163832104039683, 0.10843911404274137, -0.32635081146735651, 0.14576828227635222, 0.19683797634435207, -0.29242842190854729, 0.40205215132933958, 0.05017299682793408, 0.074236841174687165, -0.052363623024533859, 0.21501867828582896, -0.085262284445179304, 0.067452787580563917, 0.2138350441483152, -0.026820835806157621, 0.014573631497701883, 0.0018826627084885805, -0.23245811245410974, 0.073478938471179783],
                             [-0.52041346809722433, 0.35854141514688209, -0.022672463962554696, 0.15082896518238306, 0.097615623489894388, 0.23496688681677083, 0.55474362678555911, -0.22451852802447175, 0.077600862658897291, -0.32761768940458974, 0.017964287366898077, 0.26207057589844757, -0.1684408787575197, 0.26057590681475401, 0.16602456999677456, -0.16904322494374205, -0.0027149254943195401, -0.014877294688752278, 0.12734700731281984, -0.0049835526741260185, 0.10326399796771894, 0.16354424135000001, 0.039771331645405278, 0.16723561253675043, 0.079326024378269328, -0.16313655154484136, -0.26308088059210133, 0.20968282566297683, -0.3050541602931407, -0.15475664934165304, 0.095235816145336868, 0.092568961019879131, -0.076459280941581984, -0.48785678377978497, -0.21441726990850493, 0.1899678790179016, 0.011534754653842407, -0.091578989351089518, 0.23717377359287639, 0.18412619466650901, -0.10981851115198231, 0.023133755233668962, -0.1645961714257736, 0.0043999069837180318, 0.32709864026099295, 0.25304820746605322, 0.19163325850797858, 0.035741971978357087, 0.10084962188598028, -0.22604162771874936],
                             [0.33918792529446196, 0.18782946603365488, 0.23698143681043055, -0.079253133875052145, -0.093527409868853342, 0.39893193602679267, 0.0118388142247038, -0.20238659490836761, 0.08489127335471959, 0.055683565064892276, 0.34097819468075885, 0.28076232743093021, 0.077562409364050247, 0.093435586471508278, 0.15359603286057019, 0.3272654230914952, 0.34479472905363978, 0.034971204045262251, 0.074787519266499763, 0.060643913820794274, -0.086049897857926744, 0.18395537795789932, 0.17566425336656091, 0.073383485420898634, 0.16954145622803402, -0.28348472889547377, 0.19398510666957888, -0.092059579189954041, -0.1279498665751968, -0.1180921270523114, -0.20279400712635645, -0.050906373438962482, 0.049048616072559247, 0.086118487385607373, 0.089266029566278451, -0.39538659136162096, -0.12474124138363477, -0.11230633459600517, -0.32993059903454991, -0.033704243998211966, 0.031006130938691125, -0.30244809573148024, -0.0026415457914173274, -0.23362450293654322, -0.073832381649733894, 0.11497460455300769, -0.33178104499760602, -0.39112771338201707, 0.1748177546281679, 0.20659582714898334],
                             [0.04965632924067636, 0.040300081653307687, -0.001267015140086313, 0.25562509828210039, -0.53428984847704786, -0.41227608537071181, 0.14716503286118399, -0.14178070743905063, 0.15735350604250722, 0.23685657203054658, 0.070699973550677697, -0.26493558685520507, -0.075335800417489218, -0.2394344245644309, -0.1994944930736828, 0.032319521327274024, -0.076746580533496561, -0.10214996620671481, -0.036896419023504941, -0.094975296922296393, -0.50195441008623098, 0.3116579924935467, 0.23078449774488927, 0.0041059308307462711, 0.37962257004560468, -0.1835714097787135, 0.20957795730813045, 0.16345942281559647, -0.23837754827815846, -0.31460658507606404, 0.27785593267225139, 0.10158079507480577, 0.17732843852397814, 0.12470869322464759, 0.13204270082611033, 0.030991003200709313, -0.17150734060119693, 0.0089490607692768454, 0.26247355636682046, 0.15723154379810556, -0.17938350354942442, -0.044054615175206507, 0.11899989480051183, 0.047027496960143092, -0.087181290422851693, -0.45432989825659881, 0.055861977980743306, 0.029498108058526908, -0.13334939272769281, -0.094650311519448124],
                             [0.041698481696094636, -0.059002228628426495, -0.060613319777220398, 0.35192545549034765, -0.027593673113239535, 0.11084034953908024, -0.42546258990179475, -0.21785631257699364, -0.24887419334564903, 0.023083597110524653, 0.095541677173757319, -0.079582854812722453, 0.0045389456979191001, -0.044613137127515905, -0.53152373087792459, 0.31941987919250708, -0.098722610112786019, 0.18849384656096255, 0.21163095566271437, -0.40871122071039101, 0.094675300304818161, -0.23495422480199524, -0.0070875703133848715, 0.032906480809129814, 0.018177701506593098, 0.072986616035736251, -0.23790876051206192, 0.062410546768580925, -0.05705973400844884, -0.039627765925169797, 0.39604655068336037, -0.0057641232530061745, -0.024351575816863202, 0.060703409765066128, -0.17371424935169952, -0.060569445802157298, 0.043363957824196213, -0.17214127153695083, 0.26663511483462365, -0.062752903451817887, -0.28582415298651803, -0.33908077694439487, -0.17360891775417639, -0.12205426689547534, -0.11563440009335844, 0.12704697967325632, -0.12017125234231599, -0.12397461559817491, 0.18300837212470553, -0.13700028450136537],
                             [-0.11120403759447227, -0.18545407032443029, -0.36951187308551997, -0.060852401960029855, -0.14665808198798777, 0.12419887460772708, 0.18453964889635782, -0.21499509966228247, 0.20401804479548408, 0.18156908403219324, -0.17254030516036944, -0.074092187484488828, 0.23511445419081589, 0.14327164881422511, 0.05069369583463789, -0.45699913620643667, -0.16820589313527454, 0.16804178168372133, -0.064000926111824924, -0.11160554159290619, -0.12079921105950242, -0.24763257741444961, 0.028713563577355845, -0.029538877743580841, 0.0037431126566348158, -0.099793089501740082, 0.30822340600132564, -0.28109637766896534, -0.043996279798949663, 0.091454716742865441, -0.44714304500425139, 0.16518162711714193, 0.01569679375198095, 0.22814715793926515, -0.23046547693020672, -0.11673047987907072, 0.025633364662819583, -0.019437478753624216, 0.36187968416079463, -0.29812734302330041, -0.28010624998601114, -0.032936208218886584, 0.092846727136045221, -0.18478938427290972, 0.00095843692626417648, 0.19057442971944988, -0.20806077506035658, -0.17188346563775186, 0.1142009810696251, -0.18498004565605741],
                             [0.1037648984187072, -0.19000349520489782, 0.077492038349598905, -0.076054976944383151, -0.23201969510818227, -0.13394928897838906, -0.17131008877675313, -0.1886070611510012, -0.18473673115028547, -0.16943443728977614, 0.0094083172696508392, -0.22652047409961817, 0.0052363119158837027, 0.5216055496666222, 0.25400913457376839, -0.10051976856091482, 0.11897747445814617, 0.067566256879771913, 0.12543851920459761, -0.090259310320564765, -0.13526868075621865, 0.12809340535291225, 0.21590529398363298, 0.20154687859454015, -0.1498967312465391, 0.27851105451927838, -0.1290245142856942, -0.17992799171730872, 0.23551387117265726, 0.14520687153868705, 0.032505581269722743, -0.16899660432354019, 0.081580308435021551, 0.15795376384389187, -0.10282009682721027, 0.62082573980453903, 0.17482820568444854, -0.16385940810638572, -0.24268019197824264, 0.16517440362480812, -0.23943375411571291, 0.32539225559886725, -0.092602291925162769, 0.037977342895890276, -0.35246667476174348, 0.36050015674810487, -0.1166762803212564, 0.068380692550184669, -0.0067243054133091368, -0.22102613999728019],
                             [-0.013956962736436693, -0.232526156758877, 0.081056744648450502, 0.061283940866781725, -0.21168348839043533, 0.046233488523233321, 0.28723311936805485, -0.20381715910369763, -0.16085848964815197, 0.031214028544331425, -0.093071726584040171, -0.136599597469307, 0.256213919733215, -0.24757183258410967, -0.22321776160666851, -0.11295603019693098, 0.16126536360365365, -0.37493135812724848, -0.25699321780223322, 0.47122675726159546, 0.15294463169610334, 0.29862505827358249, -0.31170172625434212, -0.29295722901069654, 0.089650177732742115, 0.0018303517916679472, -0.30214344375058155, 0.063061889741352226, -0.16090875813797725, 0.22677544268316258, 0.14151131556764623, -0.13318761674814214, -0.017523737520480885, 0.19128315819606459, -0.37839969079611491, 0.061149997147191867, 0.23465885717250096, 0.23953963977495571, -0.17522206683519628, 0.15049529832417127, 0.096948239540784895, -0.02422263356861756, -0.070541378994717407, -0.078407451093325448, 0.034488614397780587, -0.02335919104321554, -0.13128480208096371, -0.32832768697444231, -0.013800932579367917, 0.03728259110642318],
                             [0.026333990111967149, 0.13305388934417944, 0.36474166397423602, -0.52201531662322687, 0.27272570499009963, -0.19866430884130715, -0.013457363991059131, -0.26917320009566154, 0.049287411642470108, -0.053265412937717388, 0.041922665651387345, -0.010688441702647898, -0.32604862939173729, 0.29435243437358122, -0.24170793453741216, -0.1534650321069386, 0.089801202996361004, 0.29885995339869298, 0.095550248727821974, 0.070443954246434154, -0.24086047328146432, 0.099777053766212487, -0.22829481181560926, -0.16202361512703356, -0.11415147146123525, -0.15939447520222932, 0.089385067176421987, -0.030890489078499762, -0.12287741586864621, 0.084643850061730141, 0.18726386612824805, 0.020152158848018707, 0.18994990457470193, 0.053387791510384572, -0.45317620784039458, -0.20921650074348205, -0.15162270435067565, -0.34838854680183384, 0.16587985947662376, -0.31996245794118855, -0.022170077680564445, 0.083869550123720424, -0.31287430594266213, 0.057218896366787037, -0.027576251917674256, -0.16659422751873867, 0.1140271360261963, -0.063077986603519071, -0.031793018091004835, 0.43906795174949464],
                             [-0.27115457722204184, 0.024911768942018946, 0.14056247063799601, 0.37868349204869156, 0.033009419780811532, -0.22937007087672201, -0.16053644202314402, -0.37252044478155805, -0.20539806763426394, 0.42056968443782089, -0.20071638017723004, 0.24667505446673166, 0.069589307439198528, 0.12705887751186681, -0.12681573927398612, 0.11972206996296919, 0.13992892801701015, 0.087639047321175001, -0.14171687818846007, 0.32604879288010169, -0.42341818368737982, -0.24104851680205044, -0.14694325376103365, 0.059802083306865386, 0.11627361218377941, 0.10249061413467737, 0.2580232111378114, -0.014324846131129377, -0.14978234678489866, -0.16956807351464021, -0.26059704112082943, -0.22505504433776882, -0.2629156939037271, -0.30197009804623187, 0.06665862887303442, -0.17725735946864615, 0.17845838165206079, -0.089387944091248228, -0.05144803550342307, -0.33329204096173359, 0.31746140225518793, 0.28296243955957334, 0.16920774560807275, 0.087922083989409677, 0.017509233861648689, -0.12473250831753477, -0.11264793275948395, -0.075544463052817187, 0.026402086177128095, -0.18873358917223287],
                             [0.11723287819317986, 0.23044080510054404, -0.094372486034863742, -0.23476747198333003, -0.069324055288384284, -0.12041083638723751, 0.062514419447993463, -0.47220417010142013, -0.073073083198193875, -0.53047835489186168, -0.049736140634918879, -0.14958709379413421, -0.13042502749504875, -0.20304866974945565, -0.0039571781944303559, 0.17820761880167696, 0.10086715992211204, 0.27048165398705687, 0.15100366740103885, 0.0056352382275997853, 0.1353249956070196, -0.15746491030520035, 0.2565091651364384, -0.14943005616605753, 0.0358627788599446, 0.13886697872516882, 0.13881471539048468, 0.1360613657090376, 0.037498194782034228, 0.24436554227755694, 0.16145173058025886, -0.10980882110695987, -0.12649431852426202, 0.32786974088110005, 0.11982155374411671, -0.28594952431579662, 0.14903495030927588, 0.026227247917450694, 0.050758299029734534, -0.31886674588760838, 0.055744918216825826, 0.042645007836712726, 0.25880028652142373, 0.21731926264079118, 0.27442557209386614, 0.06395117412445106, -0.13759073169545588, 0.16196621776502693, -0.29012847540098857, 0.062191531451700484],
                             [-0.20600797915479624, -0.088387496488994147, 0.24831605387924935, -0.32221277039656115, -0.076893977574801306, -0.10924678950708926, -0.20949104799407947, 0.049640832548649018, -0.25049339810552573, 0.1141787305053733, -0.29694297359524324, -0.17113742796513914, 0.12710906281181292, 0.084654473961158203, 0.26294934981593132, 0.1456873462357294, -0.04056228679406642, 0.11630175936716028, 0.10805571065344186, -0.23257530765574308, -0.095262522151413759, 0.017619490977789507, -0.24385561738739389, 0.00687219684791158, 0.32343032926079229, -0.16646896566570007, 0.080684424481050149, -0.049355483828569469, -0.18691370626059606, -0.1539037698162832, -0.043111974790446067, -0.048793690789161979, 0.31592733351788738, 0.063549255330302604, 0.33516901411972377, -0.25726654763886814, 0.098390360721823042, 0.24844684931790009, 0.064360556198093277, 0.23920749686943019, -0.078116831148827878, -0.34673925016513168, -0.12914202237126862, 0.71597954710510958, -0.020435175467950838, 0.39690815276146568, -0.11318730273391102, -0.16540287585014402, 0.16740935593948847, 0.18545487816769912],
                             [0.19929856819638503, 0.27941587487297892, -0.26627857896025853, -0.06443348764873634, 0.13495758333718288, 0.043070168520650147, -0.13198092081271884, 0.25364400954129002, 0.18079605949336941, 0.085786684761383014, -0.37106751595969034, -0.47029416349528119, 0.052587650361675814, 0.13836186381866628, -0.24787875645972615, 0.16571526404159601, 0.12998725997338403, -0.11061906008766076, -0.12491822713449785, -0.20391043841771703, 0.13919209865501855, 0.35653075830758008, 0.05223901267656491, 0.42719868334297129, 0.1094283640288501, 0.17455404963218318, -0.11425325555670628, -0.39475254657559522, -0.3547844791841831, 0.1546483741947996, -0.16140047574448538, -0.039878732641655958, 0.03789278327573628, -0.19477617234206004, -0.30539684426234454, -0.045763752475590676, 0.3760107853364732, 0.00016256267113609352, -0.01932038764022604, 0.026410206493823481, 0.15887771120193414, -0.1140872048121797, -0.062147814054773563, 0.073077505753435995, -0.041409008791816665, -0.09817621899157801, 0.1021487158506216, -0.022942510677684852, -0.12476764817335047, 0.10185452126485534],
                             [0.27560730760067043, 0.23722205338427044, -0.038899365945044562, -0.31635272141310283, 0.24298794999857171, 0.065107746471219932, 0.2523055164617225, -0.25523997900566348, -0.30613232726769307, 0.20135967298494384, 0.11830527672897398, 0.026655437473695837, 0.12580311227943952, -0.23251230333657213, -0.068983573473325621, -0.11764242888631321, -0.18391866760618214, -0.47912332053218321, 0.098762860178600878, -0.048886191112667954, -0.15575770442309994, -0.30082355555602958, -0.09198550444826975, 0.31369905293050238, -0.043862228768503896, -0.10063093390224311, 0.042453169903531533, -0.18551424764211305, 0.0032834289570913, 0.12060831846155484, 0.13993881866469515, 0.16818356799981224, 0.063628685774867397, -0.31241256095190811, 0.320838450788765, -0.064005051774743152, 0.44298992589303449, -0.16983822343571281, 0.044306433206595656, 0.028499532491765164, 0.0086797447853915223, 0.08135221917760202, -0.21299024279794407, 0.11297880970271584, -0.23363087407302602, 0.062395406564230219, -0.39905341553718365, 0.11103173613384716, -0.11319506229370144, -0.094188310734307237],
                             [-0.21563540180165708, 0.088035795043345064, -0.030649730813195761, 0.30320139615846925, 0.018585364279431402, 0.084873794515708978, -0.0086195026814878933, 0.11942150361287565, -0.089732898779948694, 0.018705185334752586, 0.14348446959095085, -0.06237017260055764, 0.13221490907324163, 0.049400946075772986, 0.29572860605688056, -0.072832535701127493, -0.046455228083455702, -0.051040901946157742, -0.1024457510001579, 0.18774851145055987, 0.10883594632919023, -0.17155856944194131, 0.21765775957794758, -0.12064250261271543, 0.02847882814806002, 0.18006375282354328, 0.0025271982313656532, -0.36488450360772728, 0.034291151107473758, 0.25788558445140963, 0.66552565986291967, -0.081786843830118292, 0.07024847370268808, -0.29282942449777716, 0.047586355705780264, -0.11459995435068913, 0.063908312270452711, -0.12300110652332494, -0.13953921942804315, 0.098379260450943598, -0.36899220750317363, 0.2830322149415565, 0.22438861349059219, -0.11200701621718374, 0.27295379255310587, 0.013113703657937778, -0.066741588562990686, -0.0063093741615778314, 0.29971730773786043, 0.48605995188491719],
                             [0.014235373772556443, 0.22267310581415076, 0.11737424187132588, -0.083613434795976022, -0.40649153122572246, 0.071268917525618453, 0.14669456322255811, 0.0052233519251751442, 0.25068986911626712, -0.14250017419928984, 0.034828500900951513, -0.22534575620648103, -0.11523656460120429, 0.11703203012370521, 0.068316962735691655, 0.03231318194458456, 0.0098801397104764446, 0.14681804485479674, -0.42785445471424682, -0.10717325206372946, 0.051875394525266891, -0.54890324762551979, -8.6738047615046721e-05, -0.24838278842899386, -0.098240134643982208, -0.12125399895026617, -0.19314771172832298, 0.22444916032788495, 0.005097208586913763, 0.2269748253804563, 0.05936845715674606, 0.078672193905779633, -0.14114808450019375, -0.21424727535257759, 0.1087838017542237, -0.11149210702574182, 0.29387062919171525, -0.24606150362041462, -0.12211623936913815, -0.15402950871082863, -0.18649149766220111, -0.092004662734573431, -0.16744459416088711, 0.41359563603098837, -0.33704207787067297, -0.31804324088165659, 0.17544528940030785, -0.38822999019853827, 0.057613666666746444, 0.096417492769956301],
                             [-0.12116334616016726, 0.098840665519788068, -0.081605362180048088, 0.12061009286160561, 0.076366169856949079, 0.016817676427335795, -0.096824999177913484, -0.080308984344081957, -0.023052572244015575, -0.00959592531916292, -0.19654041352781626, 0.088433410883654584, -0.24231360220874729, 0.18463672340536805, 0.041552893896676601, 0.070316212325356314, -0.028561960896553013, -0.19183845714977699, 0.19785871221499307, 0.11412447204277233, 0.049306738078546512, -0.29775059970440521, -0.20790124606967997, -0.032574002553634934, 0.31032553668291463, -0.21617360570770427, 0.52694460823217948, 0.039967117460764388, -0.25637157689925205, -0.048107952649746946, 0.056090598492659058, -0.049947688032751708, -0.020264841565374961, 0.3195039067661441, 0.10105080880505996, 0.1997509386722626, 0.24848645250810172, -0.01865493278185143, -0.33923276884292658, 0.28119317121621201, -0.11404520783608303, 0.060440661493181225, -0.1184630820071907, -0.1576154975076268, -0.15716669759081192, 0.096539148145808648, 0.50354616649718764, 0.14689322727926468, -0.14166688344391845, 0.042673730147788427],
                             [-0.035275533397159949, -0.22458831270046509, -0.061857542302034163, 0.20500388468304126, 0.083015642418238014, 0.081584436436235128, -0.084080096529072029, -0.21180218399445333, 0.074733261378618604, -0.45766321921915354, -0.28525901965113698, -0.22227381859074138, -0.17804686780799137, -0.10068460539963173, 0.07054165293075422, -0.14843377538052421, 0.13536796065390455, -0.17721216814625332, 0.09873061806652024, 0.23991442555594739, -0.051097294350592126, 0.31946721451616983, -0.18278972594944717, -0.068006220057465025, -0.27731636407290228, 0.23814667919358634, 0.30504192398928798, -0.18308182356326672, 0.18374915317209936, -0.1915109287379054, 0.14908151988680479, 0.4190859643447814, -0.22127307488864242, -0.29775861920291391, 0.014777496678955532, 0.0014387125134316392, -0.13713881824029464, 0.19007177765336994, -0.14578056919626334, -0.06658359455097175, -0.17747140133672229, -0.39024752453808143, 0.088723444802596724, 0.28343046511583875, -0.32895805044226589, -0.14730342341268504, -0.096060628208577317, -0.19319937021680184, 0.25544195260444286, -0.10071113221885485],
                             [-0.21847890408894691, 0.12570185015876487, 0.1746720015352754, -0.51335448378695947, 0.032019122116973081, -0.14898747262132991, -0.18312616745493684, 0.094756480500314266, 0.28544533442554054, -0.12571670905061522, -0.32280194426060704, -0.24288515819724169, -0.20890765629913449, -0.022125319600975094, -0.10893345025462077, 0.011034350602600509, -0.22002637513807585, -0.32844149850540755, -0.15702682932165443, 0.10411809516772487, 0.24248389637718151, -0.10864067866563526, 0.089278935585091715, 0.019330041415929367, 0.41321218534572501, -0.027063228574148657, 0.032096204065006212, -0.14805724506146911, 0.061784657100056622, -0.12976462888224666, 0.23321267991902431, -0.3534960694610067, -0.22718217100386479, -0.14648697404552671, 0.14860676542023948, 0.098614828777782049, -0.29776198211496829, -0.051118923174161932, -0.0094676523182655216, -0.094028472191640289, -0.09687754375244631, 0.12958070726947563, 0.2237743885910167, -0.33448491930823676, 0.071208962983122764, -0.030919906135564293, -0.45670046223673422, -0.24921288649608508, 0.25454621340655131, -0.37930580357539423],
                             [0.044802449165368269, -0.20861850000604951, -0.27665226627999817, -0.25149333643799227, 0.0095318913860694132, 0.022195347912642507, -0.34126351028322832, -0.16484303507598805, -0.021973139523329133, -0.3028819208009968, 0.0062102721791402887, -0.032975964095895059, 0.42754096461313557, -0.10136325480827106, -0.42067074557987949, -0.08875671588420378, 0.16641349144890827, 0.10596032164714358, -0.18760885054861054, -0.0057996438880420602, -0.0933127109970186, -0.13424450266360594, 0.23930751185417926, 0.23309890557171692, 0.051119932060495824, -0.30794298504438455, -0.14561386724702241, -0.020440689891687687, -0.11632872979371302, -0.2504162017095618, 0.18098711290707939, 0.39479569012441468, 0.06974467676970976, -0.15744824895786494, 0.12808627221407123, 0.014508108011554929, -0.075073602694705976, -0.093749342746365455, -0.11943021892634648, 0.24063328634973224, 0.096274952167982097, 0.55792970049034352, 0.0097259402583439042, 0.11293986401587162, 0.16009463347580202, 0.11586181788898642, 0.29515580001062058, -0.15021259489255773, 0.12333832838299894, 0.13442954375178123],
                             [0.14927060365796216, -0.16326441366423206, -0.07370294567314771, -0.19767924699818251, -0.077416639848316371, 0.56242971749890258, -0.088345827871209259, 0.11730802724285609, -0.25886567977844904, -0.055272402508356328, 0.043312375588913557, -0.11321716913694219, -0.1097975417490953, 0.3657722290912957, 0.090926279182096739, -0.23826766072182018, -0.15093239297138855, -0.22619319016273493, -0.012874066434458736, 0.052490357374707974, -0.2865125641567749, 0.15672361202875856, 0.071254144047463108, -0.048824181460928873, -0.18488866693576517, 0.029601526324853265, 0.1257545258979256, -0.049153558092465896, -0.20576054258513499, -0.1907599996453572, 0.2529678609398594, -0.40677400018357973, -0.31632529120391623, 0.082972859573855126, -0.0078462086947752481, -0.29941374032331747, 0.05296659981545003, -0.026342818997495042, 0.16000731448286809, 0.39348954042082485, 0.055595514391707665, -0.070474845454414153, 0.18511746816933883, 0.028523016315585358, 0.098844525322006979, -0.20340293624155675, 0.10576899915438803, 0.096656109621704539, -0.20205503463865615, 0.076385496392909508],
                             [-0.18331023925237347, -0.30571602537945874, -0.021720166431717359, 0.05965476018030999, 0.067453073086387802, -0.09833802778591888, 0.22482065071328874, 0.33763115372523844, 0.32340826150586932, -0.50713069352051843, -0.16377582710437966, -0.069217380752986113, 0.082533828651630753, 0.42031466989511435, -0.30981828876016659, -0.080429712170251341, -0.30998573151814063, 0.12429484136170856, -0.23643082878892036, 0.11540223621207474, -0.34388431310862333, -0.026742565834047344, 0.12533515297824779, 0.19350014314573138, 0.12318253631890916, 0.075065257360620322, -0.11651729631404735, 0.081511229951132927, 0.0071700683867532179, 0.18121819424835242, 0.19873134534724568, -0.11539458539343139, 0.40028577352791239, 0.02523346776422461, 0.31260787029724957, -0.3047838917379056, 0.2114031121764465, 0.13086683920841249, -0.034167232958472196, -0.17275223272919324, 0.17184619786547453, -0.11847826059904597, -0.25959592260993103, -0.24422331374666717, -0.15421445859377894, 0.081280088399595371, -0.10681024454089132, 0.015316913958438434, 0.16523053901276019, 0.055010533179334103],
                             [0.19890244273443053, -0.33804670304435924, 0.33393344133528108, 0.39870470551676135, 0.30406967818316172, 0.24578731903820217, 0.24353217543705236, -0.23232698420519307, 0.16641077824208289, 0.0034031754996488445, -0.12837718384428304, -0.25244485744230372, -0.27734608402008099, 0.089769364438754842, 0.03852037648680303, 0.027439773402995943, 0.079415234459462969, -0.24966089095090824, -0.091074221542238279, -0.38683713762781119, 0.097720416574964997, -0.079153217839958975, -0.046689611125718372, 0.22639158907344051, 0.20102748505872226, -0.40512024813225667, -0.10352293756717112, 0.12869685333114075, -0.14130429151334861, 0.090527069426882739, 0.02494733596447804, 0.017654649740768913, -0.18574288351275436, 0.29756780009218564, 0.22078250414282732, -0.09529592193185521, -0.0063951036428814261, 0.18383426421013424, 0.018679695753724281, -0.096114880102948858, 0.1955261468541874, 0.22331703415315107, 0.066899080506410816, 0.04192132216968724, 0.17929982206003411, 0.019531908798389314, -0.14329952464775664, 0.23321061492711914, 0.48501290505504507, 0.13608248474026294],
                             [0.2731883176301339, 0.084881853889498607, -0.34058111514952299, -0.017964504444520326, 0.15372709371324969, -0.32230961259212282, -0.13880365603040623, -0.15784965095826733, 0.0015008834516394218, 0.045322972951571019, -0.10288550006419933, -0.062823954306464744, -0.16444571167292601, 0.29949655324247637, 0.21460083155734183, -0.067433080606839446, -0.1420571405085615, 0.0019916205100136281, -0.20070895492903917, 0.30121692539232481, 0.14666621592037457, -0.092248596993773441, 0.10393217945375396, -0.17032634421753706, -0.073174595282279167, 0.083914303146359365, -0.080116767871656738, 0.44866623640070413, -0.039915449598161165, -0.23371815105582364, -0.061310508339583153, 0.17503685788404988, 0.4087899366107739, 0.064508561741878717, -0.18754515779855213, 0.092320133023212264, 0.27259299724627761, 0.13178567356734605, 0.25991229704529772, 0.29694635546275117, 0.21330675758077078, -0.023181550137861079, 0.24041771136254525, 0.016809009986897085, -0.18112401693446775, 0.0062185222850221558, -0.35840219577362376, 0.041606249264311265, 0.20536911465151211, 0.33753849625692672],
                             [-0.0034916244977218555, -0.071491215576742539, 0.14994790284092258, 0.027410479612476689, -0.086343949450203197, -0.011838086364956986, -0.016827757885665966, 0.062520098029067328, 0.12811915296469298, -0.18625834053581114, 0.035947646558678076, 0.13136099095205986, -0.088700386023593675, -0.30990359479709095, -0.10059045641936923, -0.039609897210681574, 0.51132025383333046, 0.03776757537672798, -0.36860263543393551, -0.14787908145900486, -0.17342047257183524, -0.16721022444759817, -0.054778365584956246, 0.044767997878205457, -0.12879860881993255, -0.087529071832473326, 0.0040880244907241263, -0.21966960593121432, -0.47153569749112195, 0.39951410717803237, 0.18201190233775261, -0.17468575692157062, -0.1279712621496856, -0.2163545432180724, -0.030106919020888991, 0.33064062691741269, -0.21467517847733839, 0.067473391121325693, 0.091834607784449962, 0.24461975209346754, 0.045602226282022068, -0.3113304701736942, 0.20359742506171272, -0.19998276854288333, -0.28648608430618211, 0.43639846203391852, -0.028017104696704299, 0.23896810333372182, -0.052987435608452232, 0.069324414715519381],
                             [0.11817583202277138, 0.081379612944472726, 0.10380347442008934, 0.02094522164590102, 0.057030170745016436, 0.25075468894461939, 0.017885325507463183, 0.042004588224589544, -0.020483528319710727, 0.10799579484682614, -0.17284209826104327, -0.21846410312589731, 0.41382844402174429, 0.12146547040052907, -0.29139115304989371, -0.16026728025444939, 0.36372216892884157, 0.22713160744370609, 0.059799116453805451, 0.10294289813898291, 0.1692282739246804, 0.019138220844951027, -0.029747872592902437, -0.21089872897357378, 0.11755681777517993, 0.097805912761872754, 0.031184873449119164, -0.046108570597917252, -0.12149546802694869, 0.024264177664400557, 0.013256552247056434, 0.051705977373600588, 0.29338064668100533, 0.13164081710640849, 0.33199567396339369, 0.11215597939745321, -0.27946458667198171, -0.48113990963838787, -0.12947409707889657, 0.0037902073284520185, 0.031559768005613921, -0.10994019679637188, -0.033191444448894221, 0.073793838552807925, -0.041581833745829938, -0.13151386689731606, -0.19361231849462543, 0.40974490857473722, 0.0097664730238740585, -0.13129952029545391],
                             [0.28788518624061871, 0.21218132668676426, 0.029757911022139847, 0.27594144857262165, 0.077915142715505967, -0.13319059181063078, 0.15293663269595559, 0.1524266522854722, -0.063447699181937794, -0.19051952629031127, 0.12412167817725116, 0.034256538570022782, -0.061660787005074158, -0.061191342437360192, -0.065906550669132244, -0.34076107799684063, -0.16545446282436826, 0.34864191903941422, -0.27075307622157596, 0.23833244092121264, 0.022612119536885723, -0.11584728827583247, -0.087347402158101592, 0.071967176957591403, 0.36932184543085378, -0.26104052628704361, -0.20021172270829815, -0.18823968793588064, 0.16849300644527085, -0.42658958076316061, 0.14741091088521038, 0.047343049295894814, 0.0018241951401231065, 0.22958916968730841, -0.25824004731500577, -0.13723803051669115, -0.0038662748495170364, 0.21396339502921283, -0.17097962473450187, -0.10757436630519236, -0.23773830550709701, 0.12852079392857491, 0.049690737207146986, 0.40731458791101094, -0.19291941235353111, 0.0084141161548067517, -0.27498060235359068, 0.035471852655285172, -0.12781091141060119, -0.073354985680167489],
                             [0.1916898426951219, -0.25700311789426272, -0.17405001698930422, 0.22489717509025609, -0.29466984113981165, -0.074116055762021071, -0.087413231972691796, -0.020226221600973558, -0.16963316014028604, -0.0249893863846322, -0.12822352615189062, 0.057640760836617899, 0.063723367830923722, -0.036235860207085725, 0.6327824133367651, -0.063654256107946436, -0.22895947350070889, 0.22557368256631166, -0.067150013735599881, -0.041122617216492283, 0.23809895277823231, -0.099962764443553287, -0.20738944755847799, 0.25808483319073655, 0.23355462895328757, 0.083406154077199604, 0.10848829988665046, 0.12279815257547413, -0.064359049131584911, 0.19201413343657447, 0.21497170792444883, 0.112129762986204, 0.026598285304924238, -0.17288105021498335, 0.11028470894062219, -0.18071462051393655, -0.24437877905832323, -0.25303742743767488, 0.098506048949547093, 0.13699371481263087, 0.26338105731676881, 0.096805408109591526, -0.13911363767301058, -0.15943755460374687, 0.038619567039390026, -0.17990046198698148, -0.24226900385341632, -0.20107000905701639, -0.38451476671849805, -0.062809566717006396],
                             [-0.30992935998033688, -0.11643674260524738, 0.12977945767834889, 0.020411680971117258, 0.085145297812282417, 0.34600677422709325, 0.065729402101912568, 0.085496213438682342, 0.094347437209737942, -0.241332970171378, -0.11354704449409828, -0.45142822259037396, 0.029910936415492934, -0.24182879573983482, 0.23940517636016734, 0.095602847796933399, 0.11810605909701768, 0.010520099251337733, -0.039062233153034712, -0.31882398099637266, -0.33664770919597542, -0.18030619382398583, -0.031426879550852695, -0.15933592557694601, 0.025186602840070113, 0.062386308485181001, -0.0059117435366869342, -0.22049131912551012, 0.40689319070319974, -0.48926843500848261, -0.22613128491092227, 0.081369045102779744, 0.35404649596323096, -0.14251729170207439, -0.17800288345834278, -0.030989023517083464, 0.22567541106772007, -0.30169045262377642, -0.028157802946652953, 0.23725969196162494, 0.21823840371125283, 0.078294609004075338, 0.097440361336446568, -0.28610658234109176, 0.096127195005093702, 0.086461495784622339, -0.14905105344655231, -0.05426888133933145, -0.17482287103337102, -0.068872638059415403],
                             [0.28290718437841716, -0.12231982481558766, -0.09804394801450439, -0.10470252290117903, -0.14339931944319712, -0.12887955647682314, -0.090975636633348303, 0.55802673349069087, -0.017991068536983457, -0.082227093870498161, 0.077658500141762565, 0.048286794898781106, -0.044186876399049446, 0.014109208416622929, 0.054331542699736446, -0.085038229930843978, 0.23263089078802557, 0.072857294667764055, 0.37228382758546102, -0.19495487623614652, -0.14016757269471686, 0.14394293364343103, -0.12040585295949077, -0.48776063200338249, 0.30551414014542366, -0.15105494858551746, 0.28712859512753824, 0.2115492014003782, -0.25173498624404411, 0.12063379774237347, -0.077544829648887148, 0.10647642627810393, -0.13983811688902753, -0.4478999533266772, -0.16042266709712369, 0.14418666392882956, 0.26057915571444673, 0.13547152896946349, 0.052561838930852908, -0.1746474342236346, 0.066769326345977306, 0.20857573635217128, 0.0099247507453487718, -0.10208524396242313, 0.12118772630619085, 0.010131144604683034, -0.20026547727468311, 0.18712743267784515, 0.24639437469650438, -0.17699437620210218],
                             [0.036315830907996949, -0.0072660871581894122, -0.1829073974276281, 0.037199429362554548, 0.11279173057659417, 0.12487490559587577, -0.12978862100300528, 0.14151388049537483, 0.40873699542275699, 0.2350092168987051, 0.43687163116918498, -0.1619670845373164, -0.20839302504549231, -0.20009435003526926, -0.073154346007773069, -0.46578374402817085, 0.11566381437124844, 0.18642820054256362, 0.31835881808212296, 0.04867746070796107, 0.069366341373553575, -0.072331425948506917, 0.13139116898557984, 0.19763380593588903, 0.075180937830017641, 0.18242260660552267, 0.11863561499394555, 0.14082997667203168, 0.076552870913966703, 0.13111351196049501, 0.029413237991872301, -0.19862177433434791, 0.0038235743289557929, 0.10626962988586303, -0.0080325833877183932, 0.065974743458713819, 0.1557321309934262, -0.13410070710205052, -0.20137394410392159, 0.16413202593196335, 0.45114777966482239, -0.10362117439637532, -0.17584080020218512, 0.4680463908138181, 0.088659021605480795, 0.17856734758777257, -0.2627540592626858, -0.23070000994081064, 0.19159498066074651, -0.075514973035275254],
                             [-0.32623838560161927, -0.23207913427330759, -0.0067251521462230943, -0.25643461850523203, -0.25005779576761872, 0.040811364938779654, 0.017230777646760551, 0.15569731529829767, 0.32259460571005355, 0.042348121907939164, 0.17529349806965586, -0.22194116182685444, -0.14937534210387082, -0.048719115038212135, -0.14118729030674065, 0.53874925424025144, -0.02309346370426749, 0.072898934264589432, -0.050594467521389942, 0.41602597086364695, 0.1426012365436917, 0.0073985340657935703, -0.22182238305330826, -0.033508055271195332, -0.01281689946856978, 0.035102302941201889, -0.17354293021641445, -0.13192244358380634, -0.23268447942284187, -0.1773053460079683, -0.066561783911422562, 0.41141332401005726, -0.31952761149737502, 0.09581978403376179, 0.16910841373783736, 0.10532523297465891, 0.094629685577594269, -0.086829401454402447, 0.15054045102365596, 0.00051708179693857499, -0.17160365120023804, 0.20647480133798413, -0.10718391703612301, 0.16908829568070449, -0.12351207739438975, 0.1452344038476194, -0.37916720466739073, 0.20381576340113849, -0.14335347501785195, 0.13384362507139597],
                             [-0.15696833646898226, -0.11705414076953648, 0.066736310306773322, 0.10041388403915996, 0.42424151051295533, 0.015086304944048973, -0.29029606537744812, 0.23711746832991135, -0.28438968947292237, 0.044873296825999845, -0.11774838219655144, -0.083403042139730363, -0.23261332760050435, -0.070156742340105729, -0.016981197916177138, -0.082686614726850141, 0.27918119377270473, 0.12916648634175798, -0.32232271789232664, 0.1380176648137651, -0.022229695985419982, -0.0042024508278246239, 0.29123472603693623, 0.23437494920723836, -0.090270572319129896, 0.15263868180443327, 0.13503585402516938, 0.36174291651336421, -0.050652486952140571, 0.21514480004339495, -0.057601945065692842, 0.35496412333796534, 0.11524551172817342, 0.15888115970286179, 0.032744153691242013, 0.016004229787847005, 0.25267781307332982, 0.071573583005030195, 0.037992486576297321, 0.19173686090078276, -0.40644659843426845, 0.022091459524968004, -0.087343838938083035, -0.12101346331172178, 0.2404656818766609, -0.24925434814633635, -0.174041914882134, -0.13909571922269809, -0.18267604814656579, -0.29793763495338088],
                             [0.059200273185459562, 0.22823795788536241, -0.11935364078388258, 0.003497804605749992, -0.18470846982715325, 0.064679093782214314, -0.05906754476203914, 0.011993126899504877, -0.16252493351296399, 0.20369939810136017, -0.046691870985319323, -0.53618139857077773, 0.017006880113645984, -0.19042678697078844, 0.047560804002646784, -0.022003742978763452, 0.032507147919890879, 0.056161077824899194, -0.037314422920512388, 0.30982351112263312, 0.070569622778661148, 0.10461760235038875, -0.0036248271540668536, 0.31086695941216469, -0.33455250828561023, -0.46563195396548995, -0.003719349223649286, 0.36876078714670724, 0.15524676419482841, -0.17256007520830557, 0.13635223020901921, -0.14239226040248318, 0.075440078935058053, -0.11565688452264584, -0.14173933926930371, -0.21248732662194364, 0.064332023833571589, 0.00030716406059902793, 0.030590587863243129, -0.27113137827640699, 0.044119307470036687, -0.0083871310473718555, 0.13617863178431008, -0.2724146919870874, -0.03800395657889042, 0.55414629291713891, 0.27921187712891071, 0.14158153867083254, 0.05256513091864369, -0.14068323637285549],
                             [0.094802384397414508, 0.072299285652682357, -0.27706291535116201, 0.12814246471930624, -0.22425101238812581, -0.016734754173811893, -0.087093627382646213, -0.024498949786023211, -0.16041686820312412, -0.021021377844577915, 0.1375943500741752, 0.023879409816892926, -0.5510251670854327, -0.11758555923651209, -0.023145073991483255, -0.17532715631534512, 0.16821654433524483, -0.15381780185349098, -0.18979160578063167, -0.070689309554385057, 0.16458853130273074, 0.031721736756173464, -0.44599682727845852, -0.11533602120796235, -0.10828485805316274, 0.2113272193856105, -0.21746873899803848, -0.14602463286370029, -0.21230201036751664, -0.30277311433490101, -0.14582978444894551, -0.031476255017430871, 0.52418118012989701, -0.029112919176386871, 0.49501367674470304, -0.13852530995216084, 0.0013345104185974272, 0.12375145433906669, 0.0067131055621319578, -0.27629703076749668, -0.020017241743356555, 0.10532552747082166, 0.017565594162646345, -0.15047799762284059, 0.1378071122588026, 0.16333773864059756, -0.09699247097889388, -0.20804092289536164, 0.055331643676327452, 0.12710819601589732],
                             [-0.089515227710605105, -0.58305326380720557, 0.091293096921281763, 0.0027381189877514331, 0.14603576343701755, -0.05841770626937054, -0.16093437076790337, 0.051630442183820985, -0.036050872060656824, -0.02087826077691542, 0.10777240754128256, 0.13488783580685554, -0.064716572188556781, -0.32978560545063207, -0.076262564665818697, -0.23407773220832004, -0.46244161210948964, 0.022460815871746889, 0.015125799613191687, 0.009069440444599659, 0.36969186579967478, 0.2383663085488936, 0.33049204408501787, 0.14065206148277154, -0.048994075370465073, -0.061031686216099779, -0.056443587519484278, -0.12227681647758226, -0.42184043241338159, -0.069560032185335435, -0.31482103726181648, -0.22230495835635042, 0.34095473662743181, -0.35543846745146068, -0.25031886085503091, 0.073648208498413165, 0.19891923287410118, -0.075104236133402502, -0.24772101059352611, -0.078826350018470132, -0.14175688511119375, -0.022320740828769899, 0.19749916833135459, 0.1388797493998794, -0.18464707392301841, -0.16871617655713339, 0.12828687009584416, 0.15811740894053722, 0.041308643375044606, -0.07049136196985481],
                             [-0.034444716428191691, -0.16307335284808447, -0.094359220104155733, -0.27771313926258856, 0.18769934965946819, 0.0579657638233841, 0.5245240214124256, 0.29666766653119697, -0.20409296603959731, -0.10786816350674222, 0.36341044707117365, -0.030726927535133251, 0.16173827368337834, -0.088152249453967962, -0.088563092261661536, 0.44774107623136195, 0.0846252531415084, -0.2093970077708715, -0.075137550204859252, -0.092587250854022196, 0.12791281698811166, -0.031818461582418175, -0.32954540540308191, 0.28701673842037539, 0.21831078735526582, 0.25786179651088426, 0.38494635426678575, 0.10289169890782739, 0.022724488028352169, -0.055112997173075232, -0.12093282829279213, -0.2594940052778929, 0.044857011177003046, 0.12059657588236478, -0.074193882241286785, 0.1107242053401956, -0.0030934054362425963, -0.19821527537415098, 0.33721375467267023, -0.23969015846548758, -0.14900434557777595, -0.040221409680090914, 0.51494858723558645, 0.14989813011801739, -0.25507609835176293, 0.0011491817385977515, 0.24751862335396507, -0.27508371229605455, 0.22667678568792682, 0.044778929507858348],
                             [0.057689744096564688, -0.32972949765303783, -0.15273715240950816, 0.19343909116453206, -0.32014251477973898, 0.25094883041233584, 0.15429253299933476, 0.086270028398590576, 0.23294203150729106, 0.064542945882926334, -0.42702100685464361, 0.25349301965857512, -0.23673124381586041, -0.11179907443707421, -0.11965701868330156, -0.031612462366137767, 0.44015050973101361, -0.061816310212038768, 0.29101874423371116, 0.25505657176529306, 0.035136709164016705, -0.28956962201133024, 0.15042857223778597, 0.29650250372956666, -0.051680450685422152, 0.04768613716553035, 0.13875525765645372, 0.16080082955984387, 0.32565546945810375, -0.1452609100667272, -0.086919425816763096, -0.38005811031080755, 0.34450426124423239, -0.29589792110146168, -0.26631665580079383, -0.17224440162607269, -0.14857139834343516, 0.28713865767591601, 0.17487953295263151, -0.091068255203506587, -0.23311314654439289, 0.15143285686374164, -0.14585677187206419, 0.15149941343042603, -0.0006732268050469864, -0.1776864569393867, 0.05490360579659806, 0.18114102828582312, -0.13768133666201648, 0.25683943454773539]],
                            [[-0.23076326494481822, -0.031293816058556093, 0.066088028745189098, -0.30096783394270227, 0.38339974543597444, -0.10963761110540497, -0.0084552359805868289, -0.062066610089945518, -0.40652531219860938, 0.071337060680501926, -0.25848042167057905, -0.099496352401315019, -0.22420108375343151, 0.066277625011497879, 0.35356382197525793, -0.24811855019400714, 0.21589828622717064, -0.20331554794036263, -0.24291427137854515, -0.15533673305441417, -0.023828614800659134, 0.14004474379259538, 0.027437083847412239, 0.10711866368225886, -0.16564648327707021, 0.4008914293668176, 0.0040756544037137618, 0.14167327728441914, -0.26190468594017396, -0.17305742892292894, 0.0070510359034234018, -0.20312867663431586, 0.075478011683879187, -0.30201709791935288, -0.036431406977989689, 0.13668469229152003, 0.061786724344914196, -0.16832952466023016, 0.042439294757217007, -0.092849958555272352, -0.034451052641650895, 0.16459123287072827, -0.31873741386114351, 0.31062770425134478, 0.10498135158060395, -0.16273427160885506, -0.44553527198679649, -0.27775865241198894, 0.16065755041183374, -0.20487184570570813],
                             [-0.036328812087089823, -0.18840553410143959, 0.065615297525439917, 0.20983990211781536, -0.62797111858290622, -0.019183558038880891, 0.23567445431990622, -0.43406782425260365, -0.18795133822832885, -0.29894639448696342, 0.21757362440138411, -0.27934482221836188, 0.3476161297102936, 0.2673127193231592, -0.044072302335626978, 0.0020963741907912307, -0.14739956422760861, -0.16718144187322376, 0.032054433778252359, -0.096540831959861934, -0.10718038286173055, -0.20137958053411228, 0.23936965216016634, -0.25575805809249369, -0.22146337669609883, -0.05176367799963362, 0.1974194553653405, 0.19634507111976032, 0.027419352374412106, -0.086798058685655266, -0.0292622466775386, -0.04047190306097271, 0.10814719306934099, -0.18916226946470807, 0.12597891844255218, 0.50450302371650879, 0.029990099139411395, -0.089607461071224984, -0.17227563088720965, -0.0097137206783707471, -0.085784278603033795, -0.10101137650430786, -0.33805815715764392, 0.22391146667305858, -0.13388524584066447, 0.10995271086516568, 0.044409564017832866, 0.037473000452594322, -0.16887073248889986, 0.13515981686478898],
                             [0.51812620941659282, 0.22301433948019586, 0.38113772431997872, 0.24754561231154368, -0.40612351864317209, -0.19687840187406613, -0.10984534421658169, 0.15262825802675067, 0.043750326508081389, -0.28013968511803261, 0.11092795505878267, -0.023898545686170967, -0.33306545590062997, 0.044862904572456799, 0.24897625235487114, 0.14953583241500557, 0.17456117083656847, 0.046577216550055214, 0.1343943425752579, 0.20600981547365255, 0.0092018176214293257, 0.1695909808397574, -0.0075460601389726722, 0.093024354104581541, 0.067437332357360949, -0.14768687967851138, 0.22509974619873949, -0.32399652169529786, -0.35289956503888725, -0.010584481534714404, 0.038978199531611211, 0.091567325655236176, -0.053306467679275049, 0.12890434450832655, 0.17224702628705224, -0.22230219395075648, 0.12571712860343498, 0.0060282059652897874, 0.18187367143449512, -0.57560904162629489, -0.062608358925440241, 0.10103450051022829, 0.15706156719847814, 0.24778894163947082, -0.097511869279381505, -0.22240227361521719, -0.067033247543586263, -0.1756838910866233, 0.085639871245259083, 0.014360300577969535],
                             [0.010368392449644784, -0.12775138686317736, 0.25141462797854852, 0.06123861865310766, -0.082444656864856886, -0.044448114162346439, 0.049020717047074044, 0.30662389209618091, -0.063380973220901859, 0.14429992915226841, 0.14380728775431217, 0.26819753626658538, 0.42660837089910097, 0.26566907820604913, 0.040470268337466052, -0.37639546938220453, -0.20308630966403532, -0.0065996233199992725, 0.15746435772508438, -0.14894048560809836, 0.10954039768207798, 0.11570827685298672, 0.39464968237292369, -0.14687328127271074, 0.26583723002146176, 0.32919018811148676, 0.14996996730479736, -0.32318832351749038, 0.098000116840205848, -0.024125957343792678, -0.11496965456000954, 0.13766086481685183, -0.097794190120414737, 0.14744142155062612, 0.082290608942414037, -0.082907200974061679, -0.35685862070870628, -0.08247895477609668, -0.26377987042013884, -0.11266247147141716, 0.37855738750314238, 0.13471540917799063, 0.24163240524979041, 0.19201930878696938, -0.013205943810886057, -0.054556395933877386, 0.22481215345456967, 0.13848062825084351, 0.19134802488171884, -0.28450776656294779],
                             [-0.074269389916193862, 0.3313343214690776, 0.20849463932247031, -0.056069905200238496, -0.28120223982755932, 0.10461395248001586, -0.13352364463312685, -0.24014433532242477, -0.33097574808467051, 0.28188197878525201, 0.1997575587984107, 0.14060972306066064, -0.023991275793402884, -0.013168874942238899, -0.14028053081731795, -0.088177815044171173, 0.097610211331136509, 0.11078884029595253, 0.17336671674390247, 0.14223974392533598, -0.20212410138415113, -0.016559621630335881, -0.3926415552493735, -0.3511642462162976, -0.076777123529248814, -0.10769274151929389, -0.19016523030311361, 0.15694213836106943, -0.0025546562182808957, 0.070178829817040073, -0.094686636129972454, -0.041693374857533473, 0.22361134101420982, 0.19763116497608174, 0.26904045405004223, 0.010576305258456691, -0.15880124443258181, 0.23925057091355201, 0.11156923878380695, 0.22759598562217068, 0.047210258318019088, 0.04291656155611475, 0.099700321313259399, 0.51306842645106721, 0.2598161945942824, -0.11386562102557407, -0.23023266048262261, 0.25242039326862842, 0.12291861295344171, -0.31749912514874096],
                             [-0.040593346609178182, 0.29952438944307619, 0.12052059843100181, 0.045598974639578335, 0.072795626960773172, -0.42306380952948219, -0.50068736039555362, 0.033337992074903303, -0.037431993766190372, -0.079609908224907239, -0.25898941507681628, -0.24602429464636716, -0.03282242027306255, -0.21214645606164517, 0.10442999937581214, 0.19492034826771257, -0.40472364772077613, -0.41835143790604118, 0.13334050333012953, 0.085265312782195735, -0.18590778218145435, 0.0059757345111528084, 0.21853235747988858, -0.058394854505231644, -0.029294439595272372, -0.0075812320188699961, 0.17797890127010915, 0.11883372218774274, 0.25533352468112602, 0.22296243239067429, -0.34985929514659092, 0.49572622919154241, -0.0086172188757068675, -0.00012042901630684999, -0.035563417411110451, 0.018893966336729601, -0.098983391152318134, -0.077870417496682831, -0.14602177692650084, -0.23052061782586877, -0.23616803874592812, -0.20013188923781686, 0.29424453489763547, 0.010439776965806417, 0.21113849267369361, 0.37247519411820851, -0.18570820811133112, -0.10286154596118641, -0.21960899386480962, 0.10106998258838808],
                             [-0.037546129597929828, 0.35472473561449702, 0.12336304337066933, 0.0084645920539183107, -0.3850357527282251, 0.011122745342073199, -0.18647211132552172, 0.033477856274446507, 0.2079830335396527, 0.19563869686136692, -0.068225809212377503, 0.031629160317402212, 0.17655208617261087, 0.048338686077943734, 0.19705504789560341, -0.045462988247850278, 0.2165369137512638, 0.37973773331143618, 0.11918508957904671, -0.23330685993422562, -0.19143929971622761, 0.38784799729571856, -0.088538006443098893, -0.12364185126391648, 0.2335386177451966, 0.13044043837927774, 0.069694814266985178, 0.2320762304297509, 0.44818991589397772, -0.18029897681913937, 0.1416569950187522, -0.13100034379009307, 0.043051948032661526, -0.26786114721210141, -0.11964015667000075, -0.048967117129198302, 0.069148821575755207, -0.12491395101033835, -0.088699383526105915, -0.14587275687718812, -0.18350380179925696, 0.069305449919271261, 0.058701331918864202, -0.22219830813894356, 0.049330777137948333, -0.18770828570295836, 0.21591987798571799, -0.35241541259288578, -0.53478223792634361, -0.23854545559709764],
                             [0.16229688478175744, 0.072831721144843001, 0.11081848227354181, -0.26261596189342656, 0.16304485858593964, -0.10899575167256667, -0.02643938401569406, 0.16136355155080828, -0.025897266689527864, 0.21882787679684174, 0.15114571712432001, -0.0032233434843771495, 0.10839408111871278, -0.2342992520663626, -0.27812144290107804, 0.055032435321763329, 0.19733865768605643, 0.22106977274526388, -0.36829182239480945, -0.15222000893905879, -0.45181217028229753, -0.075289534473437794, 0.3353294117273522, -0.38987997291427534, -0.010038706185443697, -0.13315849656934747, 0.044293083419494651, -0.24417869043887741, -0.34121753857306353, 0.17812722993628527, -0.36980243728439488, 0.13444457265429452, 0.024933874510877356, 0.076595774481350049, -0.26269196918625476, 0.24597791809522004, -0.065038888742604287, 0.10265812570713781, 0.34786894571319238, 0.095692900812880483, -0.17917656099216001, 0.18559263265972287, -0.25568846899812947, 0.21170622747451526, -0.14381178224231053, 0.17076530075236351, 0.25928624319907462, -0.23355606223716371, -0.097047399502197582, 0.19271700670472972],
                             [0.20014559240327917, 0.42923740588156373, -0.19721395752413498, 0.17918320286876613, -0.17718352777398827, -0.12090191159193309, 0.33947935909010918, -0.11295854230090295, -0.44983890739297311, 0.15305100765039126, 0.12221605718719998, 0.09155213952843716, -0.15626412986172961, -0.06390962910458084, 0.021168422537614764, 0.16463672674554394, -0.25833934157710398, 0.12723182109120668, 0.044178003050514128, 0.3454789773509937, 0.22080912537307221, -0.017863056026174825, -0.062472262055167496, -0.16173492614852336, 0.019232123197293054, 0.49105787526693434, -0.044017605331241445, 0.080242166102526949, -0.038722171938801897, 0.12560669827986698, -0.049242824419913268, -0.10908242500751883, -0.32458136675855698, 0.09202082632956643, -0.28850106030683342, -0.092745263211979442, 0.017505499004027106, 0.19531331556890982, -0.39507164635420428, -0.012421009834842118, -0.091113628236828351, 0.34052998595786937, 0.010143814852292744, -0.14964030496053141, -0.21415416993601219, -0.033946274303544431, -0.20905761610545445, 0.085697660326696429, -0.26140555296777079, 0.36785785061085668],
                             [0.13288631590695518, -0.26134956672745341, -0.17349605278038582, -0.12621300974099431, -0.1287552703942588, -0.31156838289967204, -0.21019644161411585, -0.14687297749155431, -0.091637627475318867, -0.080497445819283781, 0.23494131747113939, 0.17082126086319058, 0.22020172913807928, -0.12881399312782368, 0.08866648247621943, 0.13425739139694207, 0.13115637764965599, -0.31370486247709917, -0.21456992416730902, -0.38930615788289114, 0.0085219823896659705, -0.10717950907576994, -0.20446065291258561, -0.097633304272964863, 0.26294488505238306, 0.28212915502796487, -0.032649286681300016, -0.19210498688544178, 0.23702774527387094, -0.12066582957251035, -0.13405762628658688, -0.20023132533044358, -0.028158571981592315, 0.1291694639925802, 0.21634286120432872, 0.12710977361047684, -0.17976304274390681, 0.2992228176685709, 0.3303233943256515, -0.30819952155514202, -0.1101124943151095, -0.027940243031789536, -0.018024389882918601, -0.2377001282479288, 0.25375932229378106, -0.073775269331719934, -0.14448064792714505, 0.53899680601593203, -0.46772503335484505, -0.046646255880895091],
                             [-0.13050383862384285, -0.22632010943780978, -0.18087685355247407, -0.032459608427740053, 0.13750975122433001, 0.0080632191954821825, 0.14864819677968225, -0.20008607274067067, 0.1087803838076704, -0.17305534147381629, -0.15729100024902679, 0.18456223311504741, -0.0047329164434334048, -0.15323453728944386, -0.014008229237817353, -0.23427284998538472, -0.043818978363316677, -0.15986546785005518, 0.15281935535413993, 0.33797283429894592, -0.32109483729362148, 0.59929173580298878, 0.27961266931431455, -0.27434550382008555, -0.18641574551866794, -0.119559909448125, 0.069343766846437838, -0.32228085034906145, 0.0093682502923757779, -0.038064555096092967, -0.13595274055622592, -0.18813399875876832, 0.060495893713840385, 0.17053949853705141, -0.15954669636028135, -0.23473180339388769, 0.22095218792618054, -0.047517060877110322, -0.086381639168942523, -0.071150107787549224, -0.027961845041397655, -0.050009984348350522, -0.0081725959755651334, 0.24455184116845369, -0.092401933751424428, -0.19316635293466011, 0.024819201758468509, 0.39559171731162446, -0.30000601565589607, -0.11174678197124956],
                             [0.10296944199542309, -0.015295910363546668, -0.14969451888239629, -0.10568977499266816, 0.10529731342684237, 0.045897187674041405, -0.11239673599848093, -0.14721677115219869, -0.30015536070040122, 0.19147444656983714, 0.038438768809331822, -0.32656897811169622, -0.096997786530857014, 0.096585869798342883, -0.40521421194132179, -0.083034297873865695, 0.11808441649076512, -0.28674784668207981, -0.27846677148904397, 0.29517589156289648, 0.22645479026493065, 0.12723091531604347, 0.08107348695255065, -0.14494912249986902, 0.29679088007633425, -0.19033335022859749, -0.017789968092232634, -0.32890256414849084, 0.25306276258339061, -0.029532578135093232, 0.40369435412206212, -0.0080471662100458519, -0.070350694807933031, -0.24318411015384139, 0.085603847222791268, 0.21165911900357057, 0.063748452895691171, -0.20502462231843913, 0.16898090281451253, 0.093017631541484389, -0.40636943308622631, 0.15722340626976852, 0.26624874777878016, -0.12720191091727523, 0.41273531763867122, -0.33780105889356332, -0.074582005146368424, -0.042087326028141074, 0.1010109121165147, 0.20882108337131869],
                             [0.18323043857450749, 0.10901652200556339, 0.17144460542396245, -0.16669510918818936, 0.073317864803409002, -0.30457217527434899, 0.25006330915064801, -0.20652246110543426, 0.06952113304385367, -0.20629951567332583, 0.017329091803355734, 0.50288627225042282, -0.015449365498357424, -0.092558639053717501, -0.024702750056630141, -0.028179389539199812, -0.25141753149703894, 0.21473637665384387, 0.2560846127980525, 0.36176341681711399, -0.060884516434589572, 0.098012063506445896, 0.082147190110233609, -0.16373088659221155, -0.12772187303173399, 0.079587391891933645, -0.075167440766872193, 0.07229717224454002, 0.11034183000509082, 0.11102699700298474, 0.11249479785164268, -0.10320519130129471, 0.2397529485307423, 0.069210349872065577, -0.075797677488404047, 0.041220665757146474, -0.17520641971507986, -0.21594982095606613, 0.55866752419123533, -0.048032961251008192, 0.038021100899645596, -0.12553719407822275, -0.091772313479371731, -0.30039189849323444, 0.31441272331163828, 0.0014818812090839073, -0.25757275769362797, -0.23175421368138618, 0.25695330462284294, 0.24374693037296191],
                             [0.070957384235487975, 0.049644953976554787, 0.49959901087234782, 0.34515522478811944, 0.37151469372805201, 0.016964278060787132, 0.14292638084060186, -0.39622975815427719, 0.017160739762270637, -0.024033678838996167, 0.22196666251387193, -0.25726882718909744, 0.036315844051124646, 0.2257533631442119, -0.0094764495039246829, 0.013381594877284513, 0.2062375375675739, 0.096453069993746726, -0.11619073864145779, 0.067341291089863559, 0.34495993451011353, 0.04098913122403388, 0.27013382912088807, 0.38905186515087481, 0.090048274312968843, 0.0042108397105543732, 0.073457760288095142, 0.032275603902930487, 0.030344168000135639, -0.085382368866491698, -0.12363276891734322, 0.15685441001613723, -0.2904797944101688, -0.23417868779272399, -0.24002900410497877, -0.26118323862761172, -0.33115777725866907, 0.10318815756348095, 0.15385966786779026, 0.164134531818517, 0.064076795203904691, -0.24404869442455132, -0.039847540959875763, 0.14082231834299741, 0.20548512796541946, 0.06829999796162764, -0.22734745422974664, 0.075475595518092006, -0.33651030318250558, -0.20649833077713359],
                             [-0.11965816887665044, 0.13554625505413462, 0.11556866821986696, 0.2999986479622066, 0.16482033680619701, 0.0052341540063870883, -0.06354433712555603, 0.068629461827442256, 0.026223100236061975, -0.032456757180843156, 0.032431907840028557, 0.012822538713199546, 0.038736480919403064, 0.43004437004082952, -0.29438588656964471, 0.26528900412712375, -0.090253945333309257, 0.1548100064567651, -0.031322549600753487, -0.32403078367009064, 0.1763372502989948, 0.16565639617732439, -0.2278584511358252, -0.054916419292922548, -0.51205200681513141, 0.11573413216681704, 0.38068401388067008, -0.16530033650165527, 0.041475439769007819, -0.039344665445569853, -0.12962486303429854, -0.15384108169343913, 0.44889366627888916, -0.097065862292434107, -0.041622545806520833, -0.35620027627139289, -0.021279347859324362, 0.16821803839595142, 0.003068377359098227, -0.23068530238454274, -0.21884517477418836, -0.042972992034952473, 0.051743317855184191, -0.067016693100386882, 0.1649074264989453, -0.10400221954802581, 0.28895026901953907, 0.11235851852214936, 0.27898329770137109, 0.33757739481881066],
                             [-0.11643893555198391, 0.20751311231509792, 0.06263821858565323, 0.15197423268019075, -0.072646075130313556, -0.23324678699473769, 0.12997177531622242, -0.12138185820455243, -0.26633386533289677, -0.20295822105341868, -0.12890566296469669, -0.016076071454765115, -0.10131781854302409, 0.19007592217656669, 0.055264681694185261, -0.52328633590318263, -0.058326418043923585, -0.14230497779101867, -0.33048780944742956, -0.041094017753762577, -0.31877099624273514, -0.078694771138163047, 0.20441907753238966, -0.0044324749072435004, 0.26259354615816016, -0.11994169259351692, 0.088072309055722442, -0.070157005140994447, -0.10574326308535724, 0.07256151459400885, 0.32004573410550147, -0.27150313991694847, 0.20291689318590259, 0.034470131141825733, -0.109670315267035, -0.49100349558587658, 0.074084088065625192, -0.063096824024071352, -0.25966297868980648, 0.17938202119987048, -0.12667888606014893, -0.044212503444227544, -0.18137828715057999, -0.35982174736285927, 0.19591034037237393, 0.49044125691452772, -0.30648548665770159, 0.050067811762638401, 0.054952008424030925, -0.092899251885359246],
                             [0.32424715666574289, -0.005760814204787211, 0.35320343386956937, -0.11473228707753479, -0.0062090839337342919, -0.27119136080152223, 0.1371549209503182, -0.036941810135609723, 0.29639271014890606, -0.045339049173554316, -0.40785419746137264, -0.19657157994502453, -0.17933252614220047, 0.25765685217713069, -0.0067198838896400867, -0.13892053789409997, 0.17634849173396952, -0.033838925507943596, 0.16218169516790981, -0.070668744567493447, -0.098999548430656781, -0.13016972384650641, -0.091376711728223259, -0.11869281692712413, 0.21919343372378727, -0.041986185082088991, 0.020367736214371056, 0.090763595034604488, 0.16434782466820008, -0.081736413119475049, -0.16751902306286282, 0.092715812054632668, 0.14052322299170913, 0.20136922156597925, 0.21249289616780342, 0.11727432941996445, -0.25449687695489798, 0.175321141016793, -0.084742525217947215, 0.23301712955716847, -0.31715334435844988, 0.45765740159053808, -0.46173675564462263, -0.25165050517523324, -0.13577738382370411, -0.28313785537219882, -0.15521524166845996, 0.12189013440437202, 0.072803426529601312, 0.12479487871032963],
                             [0.092823309304746887, 0.13350141009233976, -0.21067949057327312, 0.33926069274809767, 0.039103757928416583, -0.040728672116811013, 0.12415664311872825, 0.25172529401035343, 0.1805811722161888, -0.084051601703114487, -0.030703696876624172, 0.22406148284792662, -0.31216641460882172, 0.0069209469363313474, 0.010349288043653343, -0.18554822607302171, -0.040287161337833034, -0.046857901065271552, -0.26294109269466226, -0.013126910355381147, -0.10168150004416109, -0.39432827743630067, 0.59736137664529088, -0.044802129648912059, -0.28667172535271157, -0.014314679636323022, -0.32202926482386246, 0.3030971254446595, 0.33145478581269111, -0.0020584780080753658, 0.0030111438319394565, 0.050323776566953637, 0.24479875481761751, -0.22335138808419833, 0.26152625464219931, -0.070468568254323433, -0.178460201959389, -0.020152482641782168, 0.49479195451760116, -0.14660026948031082, -0.090099533372684865, 0.17539969378051767, 0.19066446918257149, 0.18106999986581693, -0.12719221118547308, -0.086438438879724938, 0.20458937533563223, 0.10628819524500405, -0.3468040121714786, -0.060565086069111339],
                             [-0.11139485813042435, -0.19673548246704323, -0.039991482286085088, -0.26973130520010991, -0.097026644165012471, 0.11241612655050251, 0.087411881326463603, -0.044035463040746438, -0.2568884507337546, -0.040361745612918304, 0.33879834323801389, -0.25415586092688519, 0.026850858412183039, -0.098367826223162966, -0.13865133521903417, -0.020427133494706821, 0.40263952796721342, -0.013075176200539742, 0.26419369964286205, 0.048101303113626655, -0.2627784217429327, 0.096886457002400034, -0.24278457462627884, -0.0019852742877664586, -0.44095851553889631, 0.16727922323679167, -0.27312837914972909, 0.067711751260158728, 0.1852870449831335, 0.22069875740037392, -0.35863549848655402, 0.25325195044573046, -0.2466208002545405, -0.17073716771586839, 0.366427456423155, -0.46228465379488615, 0.026826660974910058, -0.44670132434559118, 0.14880055511194124, 0.042596158559003935, 0.12314029490772754, 0.19647477446043721, 0.034078103462068833, -0.27507680791680827, -0.17019037034172449, -0.19226791286192271, -0.02289340216541489, -0.034732788222082471, -0.076232135974988319, -0.05940960986976563],
                             [0.23748308814173566, -0.058258317277710296, -0.41346436630115818, 0.094894669798903875, 0.23178455176509077, 0.23604183174083548, -0.14195879861678212, -0.28979045218814559, -0.17586055342215653, -0.043143071485239423, 0.18418307165806652, 0.33527232061828555, -0.0080465699468891053, 0.010603510427687732, 0.42524183508521551, -0.2292428745907476, 0.22917855126020051, 0.015339198152896222, 0.19667545712559104, -0.11931067893826403, -0.058480420719963476, -0.41338588243612845, 0.032595871184324207, -0.10687689076096339, -0.24440808164084951, -0.15967172127012466, 0.40180016429399501, 0.12565281365632208, 0.12296570810849686, -0.31110542693018095, 0.1235089662408009, 0.42945463016930008, -0.056398774874522502, 0.21550888678063429, -0.44305985675144388, -0.17778375132378296, -0.11214745086559635, 0.18296468194739521, -0.057476511067301325, 0.017651754702536149, -0.11908971362539988, 0.097643269910581892, -0.11197885679647164, 0.068950591565914737, 0.24598534982362813, -0.028996326997940372, 0.0137029015022338, -0.20498831506437032, -0.03354521781232498, 0.081425526033400628],
                             [-0.24389140262223669, -0.26351117564381776, -0.034552607071866331, -0.10158139520986548, -0.15418211714961177, 0.41287544501914603, 0.043124433673187502, 0.26422576966120542, -0.18721071445660997, 0.12705374524951538, 0.09065743392855645, -0.20271186576999614, -0.088166767742610841, -0.085235747179951873, 0.015695620963814421, -0.022423013233295513, -0.11953305832903004, 0.026147657117504913, -0.07298480241976131, 0.28336600037527993, -0.47193168590777729, 0.1099656069096141, 0.25582632176224673, 0.51828928473844049, 0.051963574863927192, 0.18061561037540141, 0.32954021489974811, 0.1585006172205341, -0.16786418598503206, -0.097810552597671796, 0.054826939509960877, 0.081375891680542864, 0.21219734806395435, 0.21859850257578947, -0.064319646770188366, 0.10326520996706358, -0.36399050847838232, 0.2612450085719652, 0.25639587030281086, -0.05275429418763853, -0.084061222565814317, -0.035166265305630981, -0.00042288735310082315, -0.054866281993287525, 0.024884967435189274, -0.04392350415847493, 0.019041117185753471, 0.038100439060857132, -0.12525450603349836, 0.39812318766054527],
                             [-0.047663114938490125, -0.489203513049907, 0.1914926505613907, 0.29082761173912541, -0.074727173966226593, -0.051433654861827077, -0.20439045407355302, -0.127644799922673, 0.27439677803285328, 0.32522897048287897, 0.019031821903461768, 0.12013305505328886, 0.19167214267116009, -0.42029270053486439, -0.21902512022125642, -0.17325352349407186, 0.035257615069602122, -0.25408655938859259, -0.089061899538195613, 0.12425789979400251, -0.04275611180535039, -0.0087785440976337684, -0.11782232545905685, -0.2537177623008483, 0.18872088734397502, 0.10710754480589696, -0.10526906396708775, 0.36318689413063732, -0.26651518036285138, -0.19763778472798813, -0.14612958622264488, 0.0097952839760601026, 0.33938017186054337, -0.31917991905865806, -0.18996183706358019, -0.24112770225294508, 0.21512588622779383, 0.19370050279619139, -0.25287607558510666, -0.37343342349455311, -0.062365834636861864, 0.26500162824525431, 0.14023928443642586, -0.1205085778660108, -0.094373278134354172, 0.17125568224398421, 0.019830532764742656, -0.12374561920342443, 0.12891380001619226, -0.094942682534205652],
                             [-0.079453327661171164, -0.17317796737663449, 0.11805782513150639, 0.21041745457917679, -0.018667639819698403, 0.020969798177546944, -0.10331334927127396, 0.36966189237104452, -0.084632860872193946, -0.12306537360795008, 0.058254251641966813, 0.092322521367662308, -0.18560524578367205, 0.041751406134803722, 0.06218621322632735, -0.26736857996728719, 0.12656926832274787, 0.014728117708726613, -0.06889768229832928, 0.20067379679669356, -0.018067478457121491, -0.12685093512528248, -0.17329233175249556, -0.32896221375920792, 0.18805721660819025, 0.39008986037186655, 0.04312360810753707, -0.37271287154016147, -0.018876030983490673, -0.24569563190498819, -0.11857562772527398, 0.24625689482589577, 0.50849639176535077, -0.12629760400930501, -0.063837710343634321, 0.058618216274528477, 0.27861320810580659, -0.16696782283126296, 0.033520610979931517, 0.42961439973518473, 0.044707578140859808, -0.24332747726290174, 0.22598411489226169, -0.074024947558039442, -0.18470106971021277, -0.025904585931929749, -0.15827113880547547, -0.13288747904250822, -0.13971369658852673, 0.19937693137593487],
                             [-0.27071383716845215, -0.28296309602875591, 0.096329044613102155, 0.14913668638345734, 0.30208213477583684, -0.33667592757427167, 0.035406106585058425, 0.12671907607292732, -0.013417149486962385, -0.035747484360986702, 0.10276090457251387, -0.19877672990510606, -0.066801071040190646, 0.12234664133761526, 0.24290472819995051, -0.13913327998273292, -0.22867634345364662, 0.14887713505667405, 0.37720633362467348, -0.16680532566899753, 0.097852895375434346, -0.31599666283116751, -0.1636762712224924, -0.28556057576005917, 0.06038493673205228, -0.045159469286807821, 0.15076868733135923, 0.20599219672329849, -0.37445892054883595, 0.54664266656731297, 0.20690920231677845, -0.043506292259710422, -0.058373763685488606, 0.062479370363421827, -0.19409410583604936, -0.041299728301408808, 0.021694276372837863, -0.004468654051411048, 0.16414415674995247, -0.012047965953439621, 0.14425911211076897, 0.066002415164061398, 0.079314204731599655, 0.043071049360922167, 0.063382285110368752, -0.39436964737468649, 0.075256061354346482, 0.019684920597683165, -0.15156239295017027, -0.11437415303412067],
                             [-0.16868290697989621, -0.15647649849762599, 0.0081911370814279176, -0.01226063434100755, -0.0042357460515259626, -0.041804768277051957, 0.12464852959468321, -0.035295589636398068, -0.08692934052348357, -0.13381610430372451, -0.20780682569127029, 0.4486514491354594, 0.060529054333397753, 0.16938910981367156, -0.014753941628614403, -0.15899370586379968, -0.23862824138549529, 0.083513672530092162, -0.21300058959047757, 0.24812842279988437, 0.129227003544367, -0.18689261315354758, -0.40668153826187986, 0.29016245325277207, 0.16685254445520645, -0.38837111951941256, 0.078518362792842189, -0.22044496411836306, 0.02920903814543686, -0.082093448993164592, -0.34848348997746625, 0.16260225089499902, -0.028114824491493828, -0.11153864733424847, 0.028007689304505774, -0.036171345955682201, -0.18539994629254755, 0.072532806050799842, -0.17517471271503435, -0.15048906931739509, 0.31838603920230901, 0.40342197304015587, -0.10731078301791579, 0.16054604440099315, 0.39619040863439625, -0.086526046268118176, 0.32539171123306754, -0.16868932109090315, -0.40479538142742721, 0.016207078531359841],
                             [-0.08975924309822457, -0.31673955952963795, 0.072933605152396858, -0.20118794505145221, -0.39356392774103954, -0.1945072274412622, 0.15913700970940348, -0.055713154521034799, -0.26186236856846373, -0.23985126260908535, -0.32416879790523706, -0.053836370797304689, -0.39925183486049948, -0.24153409210854479, 0.13339698532825883, 0.13549108237839738, 0.21380476355530365, 0.22086638933526248, -0.20256856576036592, -0.24702844306792521, 0.32177276296188378, 0.2336660119975405, 0.14541079369315105, -0.1352565537940843, -0.23585024066180185, -0.038497623243133411, -0.077367717592029955, 0.030740106237811426, -0.00076831310834292454, -0.12787357851211589, 0.18065147241189008, 0.2502062816208056, 0.13944564478573568, -0.24596083123277518, -0.23723517568273814, -0.13851040487316585, -0.28861694991729697, 0.37315787492027391, -0.24141094106164473, -0.10220739954423744, 0.093198091385604087, 0.096726583679098449, 0.47530267559868605, -0.19010064983049052, 0.16431665025960013, 0.19407984496170178, 0.062951397735303727, 0.10285905559490585, 0.070670476715022551, 0.11845821627703847],
                             [-0.070849379313132205, 0.075510995312549123, -0.10184736909610535, 0.15793454150436234, -0.11628650719995366, 0.1149267168252698, -6.9718928657060836e-05, -0.14458753708681174, 0.18453432597888517, -0.34686018099243643, -0.37227042258848714, -0.085774616454998134, -0.086481377937667664, -0.082441992410392989, -0.24844369223153748, -0.40962003941938346, -0.015653035750670508, -0.017988686801029163, 0.25954247866572344, 0.16038387532594539, -0.16564261345595691, -0.19934504143094625, 0.039095121702577722, -0.18989845320291859, -0.016167653173405346, 0.52688699510320358, -0.064990674622770028, -0.38767361558300018, -0.099186116677168076, 0.18601580565552972, 0.037942641546426535, 0.08397581360732663, -0.44213197663068737, -0.19541656353298273, 0.06151575446604711, 0.15256880850616494, -0.053571936287086716, 0.48238589303388979, 0.11548479020057915, -0.081620993797027017, -0.13121007153653164, -0.13982816090646447, -0.0082973416957132576, -0.16970372794097704, 0.21828450388164317, 0.18760152128135421, 0.34295231265128961, -0.043757491651621142, 0.10891140536260011, -0.12038264491778407],
                             [0.13327313366290361, -0.19919671160837069, -0.20386369076975366, 0.21867042335100789, 0.027620261730841401, 0.25996749365229066, 0.24513110542772681, 0.16553853031805885, -0.022183280762058388, -0.14714553657854407, 0.14939335647926344, 0.055378792305014246, -0.29578816235856914, -0.10870955163180206, 0.25458179074270948, 0.29814984065575889, -0.18185683605261721, -0.017357281281012708, -0.013512605667587017, -0.0058039197786690644, -0.23660867460074872, 0.012069994935662031, -0.13520498155593041, -0.23444117118201865, 0.32262944467025195, -0.18972875719212362, 0.039593986284925019, 0.04521382752476974, 0.098401451559490941, 0.030877358359600024, -0.31383630041581473, 0.051669468237467278, -0.027794662818524551, -0.45980319955413979, 0.090141843943920219, -0.0021323726626188075, -0.40979409481820772, -0.012272624674072259, -0.035837729859583181, 0.17968391143498244, -0.21514738022108107, -0.25397145233866447, -0.22451329799579509, 0.013666521657195591, 0.089038747897632664, -0.2119067556477249, 0.10452732873921865, -0.1365002020676595, 0.38294755544377235, -0.33465623977309966],
                             [-0.3920213115662104, -0.018379397969683887, 0.19986170815563462, 0.077632955929404057, 0.13272646057517207, 0.21538156708954365, -0.41329370536465088, -0.22079165050633187, -0.21020413930435158, -0.41950146944458988, -0.020284471788049686, 0.18094677748255503, -0.068377384638204711, -0.12555213649326166, -0.13890639811728808, 0.2907451868776435, -0.16021190953674028, 0.12007891012217428, -0.10880067259142803, -0.01571501787253398, 0.073538616608830251, 0.055466891998270124, 0.043780186598005311, -0.051666520520777741, 0.082687662827567773, 0.22469904550189237, -0.048140021831027134, 0.033377008821777243, 0.32825729219546507, 0.047691260604400418, 0.12922411342014634, 0.23074815817388686, 0.014686297308445111, 0.28972176385943987, 0.10639652018293297, -0.16418791400295843, 0.24258370267275037, 0.042708877377737028, 0.19012442209606253, -0.027802261230430739, 0.16665551869026549, 0.2732172355358542, -0.36945559915236459, -0.069537293046784798, -0.15401849071563725, -0.18001855224710997, -0.037455896741026305, -0.09767682376453074, 0.14201380499636337, -0.28042450930295792],
                             [-0.13785917154416466, 0.19764182120706258, 0.13361456669747721, -0.31492981984289481, -0.0050962619105478267, 0.32835469171343945, 0.19361913376294099, -0.055496994794833894, 0.17187423562144089, -0.19924929414206549, 0.11001505981804191, 0.40824409599224881, -0.076866559779984522, -0.25870257237230487, -0.26443754395360575, -0.23995830863683434, -0.13163609848762067, -0.13294035935135046, 0.092529252955691935, -0.40179138055677427, 0.4188031899377575, 0.12262790201789246, -0.14666441845329867, 0.29213782753227535, 0.30320002478549402, 0.17895047119222707, -0.030273652711861401, 0.063457207728611645, -0.069700400833993231, 0.29021881760474239, 0.042243834973424654, 0.357644313313565, 0.033700132020357862, -0.1426907658460464, -0.21822400144207324, -0.02357641866631225, 0.11743989020211466, -0.1810187386805191, -0.072307466924983896, -0.097923253605877308, -0.56321824505318319, -0.016160071552033254, 0.099883621425302632, 0.25242383227296117, -0.087448178720735348, -0.099060402724431548, -0.083706489804327919, 0.13620933655084938, -0.054847358263906937, 0.084603442119279365],
                             [0.25698102535764161, -0.27426320925812153, -0.20245713655294251, 0.12036824563151094, -0.029669299742794846, -0.27315696067468753, 0.19871241318524099, 0.13324376031299257, 0.14527882516579219, 0.18437183013617658, -0.24120879774479709, -0.31275450416475709, 0.15599033888823888, 0.14406720424974295, 0.1336355326549252, 0.0028991831137293446, -0.09130719634199691, 0.084523773578908334, -0.27116289003081767, -0.012167505155860299, 0.079828595742617428, 0.38282256813495541, -0.23993877443397874, 0.14825934028493604, -0.059179067383158306, 0.2976168021082326, 0.034926405914658981, 0.034377100250961815, 0.21994754504892305, 0.25399365142794889, 0.11847523836078916, 0.2972162190988426, 0.1179933309894422, 0.33530173389615425, -0.18807925679117571, -0.18169630177325527, 0.22778850449582419, -0.037931540419138043, 0.31443010863949716, 0.21903144635429359, -0.17424891719351537, 0.11418512157288663, -0.11385599823606514, 0.21109226023677485, 0.26068959699709454, 0.29837590609494996, 0.18187036992311276, 0.0035672682020246559, 0.072575081792588564, -0.29822156282847795],
                             [-0.020911754950894094, 0.012252472631184702, -0.24580865683860442, 0.23055929325346422, -0.042824617134985296, -0.015026774813814939, -0.32026160119470315, -0.19055949288524959, 0.051038719918229405, -0.43551314232267457, 0.10051669103687233, -0.1330011102462399, 0.21888710186365418, -0.053101582743905057, 0.32494349873707407, -0.11905357840749174, 0.34793853392325164, 0.060906568285396548, -0.11665520806421578, 0.29726993329275969, 0.16475124298066765, 0.0038781908425684821, 0.21528655531914317, 0.14102151858817202, -0.14808188935857491, -0.0080839904815121627, -0.18667553430891531, -0.20674080682798948, -0.10701756065111839, 0.47634879163091948, -0.36592184087438639, -0.28951744621515635, 0.43974161378518656, 0.12237376662770043, -0.10371793949282104, 0.20422154451786731, -0.1331892605151212, -0.0071925029972178395, -0.2927357271835106, 0.12697340612084365, -0.16495959186623713, 0.13355245442314373, 0.098818700422014474, -0.20771344043014589, 0.13210968641178963, -0.066807256908157781, -0.061652642423434503, -0.072633942868149504, 0.19427646186868319, -0.03646264784835955],
                             [0.087275581590755477, 0.33947760501740087, -0.074400028246569563, 0.0070205305742945048, -0.058870723488788732, -0.28585641212661023, 0.065407318526298497, 0.2712498187741898, 0.14015504240994456, -0.30851079540486748, 0.060585390678440529, 0.0070024362314120292, 0.16666260055093385, 0.18083645234717671, -0.38701619634770051, 0.045048117023017649, -0.018122798281373927, -0.18351964226802703, 0.093928163928319749, 0.09177720594075077, -0.025426269871028726, 0.12075178149323425, 0.057640997187229585, -0.022918791439329875, 0.01615401387034715, 0.17736690084951534, -0.26233232880985152, 0.28966819781584846, -0.40607397831243719, -0.43085869344268873, 0.1630111745792549, 0.30272322630179799, 0.16075529172567499, 0.01371439498621442, -0.30576141942122731, -0.037824162397567071, -0.074521618057032668, 0.20420021903171606, -0.1989652935549639, 0.099012496133796979, 0.093631421953261379, -0.15341683382003499, -0.068144816482025528, -0.22787331643386552, 0.25626671847226318, -0.38173397629384864, 0.079708767749355466, -0.010139148985988628, -0.016616880982375105, -0.32192444904325873],
                             [-0.49074198222221505, 0.014361534508045285, 0.18315636975192265, 0.2289725681799627, 0.32506150141587464, -0.40360625003465656, 0.26556551899674219, 0.035637163714958835, -0.16697599828770776, 0.039365153120264756, 0.38623310336178185, -0.051251070325703051, -0.035180518529146255, -0.25031823482901605, 0.083075747565109756, -0.027651808100811213, 0.027209747293784326, -0.22500998790979504, 0.34204033863934341, -0.078972330940455499, -0.09693501573714261, 0.32805218962292421, -0.13256085519978647, 0.11735608538431658, -0.090104900965684034, -0.25710586866984603, -0.38871150912938945, -0.15183516778842143, 0.070030146429861911, -0.25633118272440314, 0.21405560948973115, 0.14559494956515451, 0.09236953584050972, 0.25482756773040544, 0.16231812768170389, -0.0036578209596937403, -0.094131710397860308, 0.33395192655140415, 0.07272032765759634, 0.01538714849138014, -0.22845091170247195, 0.12162594196801375, -0.23277131736149698, -0.025590246215156744, -0.047971178636106039, 0.13523561668199555, -0.053020825938639243, -0.46157489865594714, -0.1399669728513091, -0.043569328092252294],
                             [0.38457875849602491, -0.12783193901398382, 0.34985692811836394, -0.16857042771935724, -0.070271614580887154, 0.033944104963232878, -0.063196888247926408, 0.35588313756718132, -0.12999021709110986, -0.026397987112440277, -0.084745696011615107, 0.19636511890903546, -0.029763852135558176, -0.22184368135897278, -0.15159638183675012, -0.013390352550901824, 0.17746181336439854, -0.3105073468714824, -0.12244732415574895, 0.094957506992642382, 0.095794440696220839, -0.069021746150350505, -0.12042444888821902, 0.084017727504339834, -0.41943936739406612, -0.013501817115991247, 0.19216105848856352, 0.11638413828457764, 0.31589786907035355, 0.45107850247980497, 0.069015177831185021, -0.33551031683547394, -0.088652782207396891, 0.087380088962794714, 0.1371577563653168, -0.18082546497780438, -0.17082414537012888, 0.15419445676699547, -0.18846258519423939, 0.26504987539754854, -0.079410000099418718, -0.32319725354563222, -0.1674234858755515, 0.26190141895087438, 0.034981644941079956, -0.31752790828032257, -0.061678695403572743, -0.18870332788795194, -0.22586522314034041, -0.034119876028559024],
                             [-0.21189681504851596, -0.30101053685889206, 0.20860138812473261, 0.13915612562320087, -0.036974844011587682, -0.3287235485854334, -0.31049294665651284, -0.075061572845645547, -0.027383305578730845, 0.049271531135894095, 0.2217665815136054, 0.2444403547998979, -0.17910069347415214, 0.37458681087497858, -0.0055794041790513081, -0.0044053408531228612, -0.087142192015395692, 0.3001358991232343, -0.08070469353362815, 0.30604778557070839, -0.46425650334543045, -0.16972742526654083, -0.064124909567345553, 0.27005400950677427, -0.051665032177053996, -0.026995656951209285, -0.36212693219949682, -0.17609880949438866, 0.24525891786123091, -0.092049461082659143, 0.092818125444772262, -0.12640966827422134, -0.22686070839420697, -0.031468031083460565, -0.43197348994630552, 0.21444057478066014, 0.03426969219936811, -0.26555206743355086, -0.14050223059242586, -0.15410444093856213, -0.22211288745418378, -0.093224134992053384, 0.074405589806125272, 0.21279240200621202, -0.13360633166943786, 0.079817212520074329, 0.10061603134720645, 0.25769780513422036, 0.18111243866572715, 0.11532626933311883],
                             [0.20989760642590383, -0.099397000801362628, -0.13331496119244057, -0.22074716514332582, 0.16329531833681887, 0.065373640822902479, -0.046780449368653623, -0.12240632641327895, 0.2293586284732842, -0.066184958665543622, 0.29328652679387451, -0.25439298677926997, -0.13405833019211999, -0.16014664787393826, -0.21756354709695547, 0.17351825930538717, 0.069701121434740568, 0.34233252420804267, 0.093445540129511603, 0.012100748448478096, -0.098582934464728517, -0.24214880687398382, 0.10881414125917431, -0.040003850436249613, 0.027462879430662532, 0.27815723524365354, -0.23708443163894483, -0.14897248041028932, 0.11129728292662451, 0.058457615645933741, 0.1329319722803651, -0.046657300557351677, 0.41163264700372398, 0.012687850961513338, 0.25943275552091177, -0.13195884291608587, -0.16041229824044173, -0.040522494511069027, -0.51610208060318408, -0.32365213296341161, 0.15777593904524723, -0.27163405880166486, -0.00013062298829762467, 0.32647715665230131, 0.21705333654628964, 0.1710272637691056, -0.14547726365012065, -0.15758307578395347, -0.20448179110349241, 0.13911947473291431],
                             [0.47318664461053855, -0.01136935703150347, 0.13645379791398268, -0.135623579783304, 0.2754786265458638, 0.14086886539311141, -0.013221868357462913, -0.27633399253022933, -0.46785899162918576, -0.16837670458320922, -0.22983039617736789, 0.076588515074111685, 0.27548826338517396, 0.0049645735040214981, 0.21173137070209491, 0.07149047105385968, -0.26606536829974836, -0.13850951119412183, 0.23338456934391441, 0.0027656407580360881, -0.13557411304063574, 0.090866302335705348, -0.057562599182715307, 0.12652233351803288, 0.15178332185251472, 0.054144689891662635, -0.16205931093264714, 0.04481505852276188, -0.23351899203682483, -0.015655922196050078, 0.10620668048798744, -0.17921730021357307, 0.41230245177675245, -0.049408181149916991, 0.070944656210462406, -0.12065732404966539, 0.081155912806260361, 0.08301898330677604, -0.025478207728350834, -0.053993866644509059, -0.17006499031790467, -0.015199321532350306, 0.21201784941985358, -0.12031227452799449, -0.24797603492213155, 0.08492689280306237, 0.64392569463904725, -0.0088146628641269341, -0.20904508253508308, -0.12326044584702651],
                             [-0.08026054165069442, 0.12656565583380985, 0.25515397371162996, 0.083034447575086601, -0.12783770010055057, 0.56816936871897594, 0.087890180415677754, 0.092853526224341149, -0.13302514151587652, 0.28835607585284218, -0.14550701955796258, -0.10379192288222391, -0.12575990996054223, -0.001088290106816988, 0.15097028670159568, -0.024087732786043977, 0.040752514838330506, -0.2616097196457019, -0.016547012724323566, 0.14514096960874939, 0.13332365790335002, -0.025981903853692461, -0.11128628728988517, -0.3198843503931772, 0.052302404358952712, -0.04274180522219119, -0.21213787808559104, -0.045312636613293468, 0.018675517895646799, -0.081516661804307639, -0.12049514715382867, 0.0062365259225405575, 0.075474490714967729, 0.49064026348101519, -0.29829291589125984, -0.065965818304791701, -0.19178468626192791, -0.36696796611374594, -0.03787784551899348, -0.30929693677894454, -0.0017157631885455493, -0.31136062808590631, -0.35910610856225667, -0.23160798785618381, 0.11159376825827035, 0.039940192648449696, 0.2240561904604399, -0.021171187953520486, 0.046264066829029067, -0.081611665236765815],
                             [-0.22698759435742541, -0.15214347108836029, 0.079948217232767113, 0.075490631272203707, -0.14384121843041844, 0.088976484674005069, 0.01149969814443297, 0.056105141219949646, 0.20696319640161265, -0.22144647748549229, -0.050463577889648274, 0.0140782946508726, -0.13154524260373116, 0.18084124062737436, 0.0029446495683716537, 0.47724333908401384, 0.041327749092993638, -0.42313564003222937, 0.30911811389269123, -0.17598975212813303, -0.054433938426715324, -0.0095184627710911962, 0.11762483949357579, -0.066762730627814335, 0.19903097521777532, 0.17414982674825791, -0.26469454595640213, -0.073986150590252514, -0.1884708379858345, -0.18603242379330806, -0.11482372306611859, -0.30790673150835934, -0.14266798343219828, 0.39905555666070652, -0.26560985295885842, -0.088907885730899402, -0.0039422076648520888, -0.18669610736052333, 0.025792265246757606, 0.38458506471581838, -0.12539740971779112, 0.42357136545776913, 0.43309660220650714, 0.15084775334454548, 0.12991039278778732, 0.19034986952728739, 0.049035705839156722, -0.45328835320403421, -0.11318912299952091, 0.13192933721771355],
                             [-0.15570482980269509, 0.0041371468635645128, 0.15264702231948554, -0.15987630418619289, 0.19197007575703626, -0.018503494090625548, 0.53116964025720281, -0.16177242625367375, 0.26183787952184456, -0.15528600595342343, 0.01023426583387684, 0.00048864521520767222, 0.35324662900688553, 0.23680391327631581, 0.065920473066145832, 0.16719302147947684, 0.022548676543946308, -0.21582595031458515, -0.49983742192533764, 0.18267016104885622, -0.23596224549211936, -0.18665193318434714, -0.18032922719152003, -0.22978575393546247, -0.0024987227269229265, 0.14004895162348108, 0.22899511340897832, -0.24659295286756014, -0.041948538275118769, 0.06310472525649613, 0.15272715842448942, 0.12097478233976006, 0.12997223155119902, 0.34571336679425124, -0.013502749230300471, 0.094759065530841624, -0.047983237308638869, 0.080657938878693727, -0.049260527615487222, -0.18907638377776961, -0.16357639563024573, -0.11137224723338955, 0.52630965129637308, -0.070292814795970049, -0.33132593237727442, -0.060512585485734793, 0.006842624395841608, -0.048724495503483595, 0.0017438244490975106, -0.18802226854576223],
                             [-0.11381669535197557, 0.18440620352587092, -0.15396664499313298, -0.297886969848358, -0.077396832685664024, -0.16479653936130836, -0.35111035721835054, -0.19577794847426477, 0.17147495716672978, -0.044991057473983659, 0.0094981192699362393, -0.14263320457342207, 0.07058238423467815, -0.14784141952339525, -0.021857169262182053, -0.13229997872898783, -0.43184419550253839, -0.11001117077147007, -0.053722030541874563, 0.10956393350776936, 0.16679525691380592, 0.001120840233046233, -0.26319967556077339, -0.058955409856245533, 0.0019104034241116223, -0.16484735667666484, 0.14488585491067701, -0.17219155105497802, -0.025685009453889091, -0.15638211178470207, 0.019783696639276992, 0.015644593425562368, 0.098368869311352691, -0.07287922451209719, -0.053609312248624731, -0.32220226048687595, -0.69580273834975448, -0.11375606404458123, 0.13460153068769798, 0.11486266661480132, 0.052649815106270745, 0.036758923472356611, -0.23725909419158583, 0.043049488124497236, -0.63837368115606785, -0.075134825595901414, 0.15733013841950899, -0.11428007646600058, 0.15297919075003877, 0.19669594114783576],
                             [-0.12679235231751948, -0.019374100534978067, 0.40118669326430245, -0.40585639043807692, -0.090292354923281443, 0.15197236413290968, -0.03417046227677642, 0.075745349292637681, 0.35400117606502052, -0.16231953204795876, 0.16359178442505276, -0.051612689350498946, 0.33856934272733297, 0.028727645187445954, 0.52388188810944525, 0.21176647543081506, -0.151661326069949, 0.033058326686818379, 0.045987239742458899, 0.46299729253888006, 0.065486461773951468, -0.084021062777759156, 0.10280166716232635, -0.27223783975858951, -0.038506712801953107, -0.060134131968776178, -0.18267611927124375, 0.074823618092770661, -0.05289156939726463, -0.11481108660337502, 0.19492349810279797, -0.025861476717519347, -0.15696168856767956, -0.28964324661221408, 0.035169899763438615, -0.20729442218937508, 0.225702571264042, 0.33165870815136211, -0.077111324227688086, 0.0010893510306023626, -0.19806531475395242, 0.17037148877892661, -0.15667172314396352, 0.18158799795198013, 0.22430673429460873, 0.13556679589646517, 0.24772131227367611, 0.25094274963235019, 0.03670271235152138, 0.21055390565775839],
                             [-0.089021951067547817, 0.23295792867617515, 0.13974600351813965, -0.0022353072880071934, 0.30583832217420298, -0.14097409697846305, 0.13878145398900488, -0.21024165943496975, -0.073933351604439979, -0.46338886525800738, 0.19190348795285794, -0.25897392093818528, -0.020717258118339542, -0.1998633823946119, 0.097901267130739669, -0.45301400879312159, 0.027996875100930393, 0.045623976655644535, -0.30398280675609007, 0.0060482925257763429, -0.061772470751339958, 0.19293762447581156, 0.013846483836048622, 0.0032292805864231125, 0.29660279456952476, 0.22572075787957618, 0.07177122539948802, 0.38812794111023441, 0.15473962168672087, -0.28763748824358149, -0.48283734711615695, -0.13490263310508646, -0.048018216692308976, 0.27689840344928135, 0.059444031983885669, -0.02224572612481656, 0.12058639678343096, -0.021781477232258005, 0.035505973056622071, -0.11266082136361075, 0.12820941663491975, -0.091346746486237113, 0.19115614491957572, 0.18839684579400726, 0.010741105332295012, -0.18045842299671419, 0.43345355538296154, -0.073107389910298165, 0.23711686953273642, 0.31340449644150814],
                             [0.22196405909585162, 0.18457093433100699, 0.14286670776317184, 0.10916648804425451, -0.060822458431285815, 0.29093258707419506, -0.15170240013749287, -0.15996755541749935, 0.34560065633647136, -0.0089154276415466943, 0.14274699639031596, -0.031076203379718711, -0.074408258754029621, -0.10589561215300468, 0.26708729886458116, -0.079326268595123817, -0.21414555889279452, -0.31709648258243178, -0.20409700306239531, -0.3288259470858878, -0.3567064574376016, 0.069417144002124079, -0.11164121841280292, 0.14136159274627616, -0.2821394366559174, 0.21388591146077227, -0.27244992358170655, -0.20391407228507644, 0.10309875172174979, 0.23085406059018079, 0.25545496985410593, 0.15923051390696458, 0.21485683189314791, -0.18520814544789599, -0.091720256647595769, 0.10641617598591718, 0.1171964958229737, 0.004537952441176888, -0.12180411417888513, 0.2806345567896002, 0.55184863764945558, 0.15974374378758027, 0.029282914725031112, -0.10113957951734798, 0.12229824591957091, -0.30161563296137645, -0.099072451903306019, 0.064075807559241707, -0.013499699328343853, 0.25554404817128595],
                             [0.035830525786607788, -0.14400293782383769, -0.043976142153441311, -0.11249476853297224, -0.27520862607845603, -0.028135020069934243, -0.029318136750231837, -0.15846286530471096, 0.057609675472031885, 0.28065701846686375, 0.10654946917759112, 0.058747813223820618, -0.12289462814646739, 0.20273726733680966, -0.0047058420143948204, -0.26002104215980926, -0.69593061584540405, 0.066880828089980388, -0.06003399486064117, -0.099577933290891985, 0.1533886725264082, -0.12905159195090279, 0.20722826141093759, 0.21341649735910234, -0.12352896466220706, -0.1737795741357305, -0.22466292499327392, -0.14275019058073735, -0.14074421607177459, -0.10614002865029809, -0.36893016325532479, -0.024965773412857585, -0.055989327378833997, 0.1928808261751136, 0.16280565551405207, -0.12362028003462081, 0.41110778446643786, 0.39199237994284963, 0.11017736112280348, 0.090897106679260903, -0.15612046991018541, -0.23255311500065579, 0.077992501218994925, -0.30413721915104752, -0.025050213060108111, -0.3776461156479573, -0.13072159763536262, -0.33636368081581991, -0.074544232588222764, -0.14194097322191165],
                             [0.031830437225301024, -0.22509775159842621, -0.0049773084578695198, 0.052083044634223183, 0.11393148562213176, 0.22751906308318659, -0.25263981494420834, 0.084079477843370665, 0.29419509852248077, -0.12462595311131219, 0.23462155117735869, 0.3685300388809723, -0.29194728427567102, 0.19620896331803783, -0.017304739377706088, -0.22478884139478156, -0.18562859533760787, 0.087222875298251498, -0.2254838216843506, 0.030849234154932334, 0.15923764440935789, 0.57203903944867629, -0.096249853884909017, -0.26835616212116925, -0.11934729707648913, -0.0058661490096217801, -0.062749864229264499, 0.36222239919508425, -0.3202824452707741, 0.14564246401579176, 0.037763057687908309, 0.041831902379871971, -0.12056560576236666, 0.12361512637857083, 0.36838710112738776, 0.14783242520719084, -0.26071684549789409, -0.12097110366457177, -0.25401859060150578, 0.0051748255087878114, -0.24052578910247649, 0.052696253376434452, -0.051213944729203806, -0.22002701198202185, 0.073609340698396045, 0.24910630159405361, 0.040503267504672827, 0.051092908402980308, -0.22791401416804888, -0.15608860680532546],
                             [-0.10222856282152384, -0.10737573055073525, -0.088740533872137289, -0.40102648813114439, -0.17377126869775017, -0.067625635008404794, 0.13480533115513177, -0.045079526442728349, -0.0027278087267720921, 0.12457884776678221, 0.25789807922187502, 0.10209534421566213, -0.45189853374732353, 0.49706715566607923, 0.087655469364280231, 0.1176409396323146, 0.2496394922118095, -0.37054922256101119, 0.10451637168421941, 0.094717655175426602, 0.097435980899563013, 0.14084194807397679, 0.084389580388053873, -0.079139240771974304, 0.20690260689924589, 0.034569387715999267, 0.021756998712464864, 0.14833360792434033, 0.30324689632389867, 0.27706200449713353, 0.054763385888252115, 0.073569546499988203, 0.22779688226056558, -0.095612426221581767, -0.1402722909345448, -0.050841922934490816, -0.017126682534106014, 0.34548952198886901, 0.16271119389572736, 0.00273299896084803, 0.37114901212927204, -0.089941298659495669, -0.052342553664681477, -0.095055333019577637, -0.3315142709794005, 0.15176521544121252, 0.094225829227936375, -0.075987673136548514, 0.11289262293280053, -0.051291030974793511],
                             [0.10817141453665231, 0.028421849119527873, 0.12987805097684971, -0.17602183103567726, 0.07584811066669464, 0.2739398387500846, 0.10270907379987934, 0.18446170351559199, -0.013755774194871718, -0.39006834026226483, 0.38317102709243078, -0.4069999271774114, -0.063837850923506592, -0.046140506605424243, -0.17868363347335992, -0.24667838974640022, -0.22394214480263661, 0.084735537895614776, 0.016382899343184244, 0.051643518540553948, 0.0086817269345083083, -0.05061579875419165, -0.23618300323517888, -0.079033614876483874, -0.23913768167058133, -0.18042552664139225, 0.22639194080781341, -0.0006445654146574188, 0.37169471420352629, -0.21900511876970141, -0.12116285111347594, -0.21553289731396477, 0.04470663127105607, 0.012530920434608779, -0.37905998093748766, 0.15708290588595211, 0.11148273137894509, 0.16662452944598974, 0.05628076113525686, 0.033866161732234952, -0.058234106640544056, 0.43116134307308679, 0.19363059989633349, -0.14655193633276875, -0.20621377013675279, 0.29994438328115985, -0.25313147233443528, 0.11844632676600282, -0.045216692150982875, -0.3318893082437146],
                             [-0.12830217972659649, 0.1121591074323328, 0.25666158257028487, -0.17955707197637497, -0.16392139038361961, -0.19928399987310857, 0.10120735903649089, -0.18360345676885415, 0.089057396380839246, 0.21850259770553643, 0.26698704089402414, -0.025315605354182202, -0.43385026284127443, -0.41206631379328523, 0.037562778760870059, 0.072705145196897539, 0.032782515747091512, -0.12220391250734959, 0.0379263989600142, 0.14848867045968514, -0.086702966359679709, -0.2478111802219366, 0.11344796651909002, 0.031377388161166885, 0.016133511990721664, 0.23630879467897892, 0.40058539315001118, -0.17254723483947534, -0.12917284952568317, -0.093771089645011838, 0.064898714545255046, -0.0341750081847777, 0.19015122337044441, 0.03872082831442341, 0.13396331372606421, 0.21528714862357665, 0.25232323210770319, -0.32706506112788575, -0.13710057181746124, 0.26102277759676695, -0.10993984078666008, 0.078113632062220037, 0.013653151242288331, -0.1388736917576659, 0.050233191498168649, 0.096926236993737591, 0.39908360021874406, 0.11430278400488843, -0.030545779122672957, -0.3279668924867809]]])

    def __init__(self, num_variables, matrices=None, offsets=None, **kwargs):
        if matrices is None:
            self.matrices = {2: self.matrices2D, 10: self.matrices10D, 30: self.matrices30D, 50: self.matrices50D}
            matrices = self.matrices[num_variables]
        F15.__init__(self, num_variables, matrices, offsets, **kwargs)


