"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerCredential = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a credential used to authenticate to a docker registry.
 *
 * Uses the official Docker Login GitHub Action to authenticate.
 *
 * @see https://github.com/marketplace/actions/docker-login
 * @stability stable
 */
class DockerCredential {
    constructor(name, registry, usernameKey, passwordKey) {
        this.name = name;
        this.registry = registry;
        this.usernameKey = usernameKey;
        this.passwordKey = passwordKey;
    }
    /**
     * Reference credential secrets to authenticate to DockerHub.
     *
     * This method assumes
     * that your credentials will be stored as long-lived GitHub Secrets under the
     * usernameKey and personalAccessTokenKey.
     *
     * The default for usernameKey is `DOCKERHUB_USERNAME`. The default for personalAccessTokenKey
     * is `DOCKERHUB_TOKEN`. If you do not set these values, your credentials should be
     * found in your GitHub Secrets under these default keys.
     *
     * @stability stable
     */
    static dockerHub(creds = {}) {
        var _b, _c;
        return new DockerCredential('docker', undefined, (_b = creds.usernameKey) !== null && _b !== void 0 ? _b : 'DOCKERHUB_USERNAME', (_c = creds.personalAccessTokenKey) !== null && _c !== void 0 ? _c : 'DOCKERHUB_TOKEN');
    }
    /**
     * Create a credential for ECR.
     *
     * This method will reuse your AWS credentials to log in to AWS.
     * Your AWS credentials are already used to deploy your CDK stacks. It can be supplied via
     * GitHub Secrets or using an IAM role that trusts the GitHub OIDC identity provider.
     *
     * NOTE - All ECR repositories in the same account and region share a domain name
     * (e.g., 0123456789012.dkr.ecr.eu-west-1.amazonaws.com), and can only have one associated
     * set of credentials (and DockerCredential). Attempting to associate one set of credentials
     * with one ECR repo and another with another ECR repo in the same account and region will
     * result in failures when using these credentials in the pipeline.
     *
     * @stability stable
     */
    static ecr(registry) {
        return new DockerCredential('ecr', registry);
    }
    /**
     * Create a credential for a custom registry.
     *
     * This method assumes that you will have long-lived
     * GitHub Secrets stored under the usernameKey and passwordKey that will authenticate to the
     * registry you provide.
     *
     * @see https://github.com/marketplace/actions/docker-login
     * @stability stable
     */
    static customRegistry(registry, creds) {
        return new DockerCredential('custom', registry, creds.usernameKey, creds.passwordKey);
    }
}
exports.DockerCredential = DockerCredential;
_a = JSII_RTTI_SYMBOL_1;
DockerCredential[_a] = { fqn: "cdk-pipelines-github.DockerCredential", version: "0.1.2" };
//# sourceMappingURL=data:application/json;base64,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