# coding: utf-8

"""
    Sonarr

    Sonarr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from sonarr.models.language import Language
from sonarr.models.quality_model import QualityModel
from sonarr.models.series_title_info import SeriesTitleInfo

class ParsedEpisodeInfo(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    release_title: Optional[str]
    series_title: Optional[str]
    series_title_info: Optional[SeriesTitleInfo]
    quality: Optional[QualityModel]
    season_number: Optional[int]
    episode_numbers: Optional[List]
    absolute_episode_numbers: Optional[List]
    special_absolute_episode_numbers: Optional[List]
    air_date: Optional[str]
    languages: Optional[List]
    full_season: Optional[bool]
    is_partial_season: Optional[bool]
    is_multi_season: Optional[bool]
    is_season_extra: Optional[bool]
    special: Optional[bool]
    release_group: Optional[str]
    release_hash: Optional[str]
    season_part: Optional[int]
    release_tokens: Optional[str]
    daily_part: Optional[int]
    is_daily: Optional[bool]
    is_absolute_numbering: Optional[bool]
    is_possible_special_episode: Optional[bool]
    is_possible_scene_season_special: Optional[bool]
    __properties = ["releaseTitle", "seriesTitle", "seriesTitleInfo", "quality", "seasonNumber", "episodeNumbers", "absoluteEpisodeNumbers", "specialAbsoluteEpisodeNumbers", "airDate", "languages", "fullSeason", "isPartialSeason", "isMultiSeason", "isSeasonExtra", "special", "releaseGroup", "releaseHash", "seasonPart", "releaseTokens", "dailyPart", "isDaily", "isAbsoluteNumbering", "isPossibleSpecialEpisode", "isPossibleSceneSeasonSpecial"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParsedEpisodeInfo:
        """Create an instance of ParsedEpisodeInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "is_daily",
                            "is_absolute_numbering",
                            "is_possible_special_episode",
                            "is_possible_scene_season_special",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of series_title_info
        if self.series_title_info:
            _dict['seriesTitleInfo'] = self.series_title_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in languages (list)
        _items = []
        if self.languages:
            for _item in self.languages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['languages'] = _items
        # set to None if release_title (nullable) is None
        if self.release_title is None:
            _dict['releaseTitle'] = None

        # set to None if series_title (nullable) is None
        if self.series_title is None:
            _dict['seriesTitle'] = None

        # set to None if episode_numbers (nullable) is None
        if self.episode_numbers is None:
            _dict['episodeNumbers'] = None

        # set to None if absolute_episode_numbers (nullable) is None
        if self.absolute_episode_numbers is None:
            _dict['absoluteEpisodeNumbers'] = None

        # set to None if special_absolute_episode_numbers (nullable) is None
        if self.special_absolute_episode_numbers is None:
            _dict['specialAbsoluteEpisodeNumbers'] = None

        # set to None if air_date (nullable) is None
        if self.air_date is None:
            _dict['airDate'] = None

        # set to None if languages (nullable) is None
        if self.languages is None:
            _dict['languages'] = None

        # set to None if release_group (nullable) is None
        if self.release_group is None:
            _dict['releaseGroup'] = None

        # set to None if release_hash (nullable) is None
        if self.release_hash is None:
            _dict['releaseHash'] = None

        # set to None if release_tokens (nullable) is None
        if self.release_tokens is None:
            _dict['releaseTokens'] = None

        # set to None if daily_part (nullable) is None
        if self.daily_part is None:
            _dict['dailyPart'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParsedEpisodeInfo:
        """Create an instance of ParsedEpisodeInfo from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ParsedEpisodeInfo.parse_obj(obj)

        _obj = ParsedEpisodeInfo.parse_obj({
            "release_title": obj.get("releaseTitle"),
            "series_title": obj.get("seriesTitle"),
            "series_title_info": SeriesTitleInfo.from_dict(obj.get("seriesTitleInfo")) if obj.get("seriesTitleInfo") is not None else None,
            "quality": QualityModel.from_dict(obj.get("quality")) if obj.get("quality") is not None else None,
            "season_number": obj.get("seasonNumber"),
            "episode_numbers": obj.get("episodeNumbers"),
            "absolute_episode_numbers": obj.get("absoluteEpisodeNumbers"),
            "special_absolute_episode_numbers": obj.get("specialAbsoluteEpisodeNumbers"),
            "air_date": obj.get("airDate"),
            "languages": [Language.from_dict(_item) for _item in obj.get("languages")] if obj.get("languages") is not None else None,
            "full_season": obj.get("fullSeason"),
            "is_partial_season": obj.get("isPartialSeason"),
            "is_multi_season": obj.get("isMultiSeason"),
            "is_season_extra": obj.get("isSeasonExtra"),
            "special": obj.get("special"),
            "release_group": obj.get("releaseGroup"),
            "release_hash": obj.get("releaseHash"),
            "season_part": obj.get("seasonPart"),
            "release_tokens": obj.get("releaseTokens"),
            "daily_part": obj.get("dailyPart"),
            "is_daily": obj.get("isDaily"),
            "is_absolute_numbering": obj.get("isAbsoluteNumbering"),
            "is_possible_special_episode": obj.get("isPossibleSpecialEpisode"),
            "is_possible_scene_season_special": obj.get("isPossibleSceneSeasonSpecial")
        })
        return _obj

