# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_rich_display.ipynb.

# %% auto 0
__all__ = []

# %% ../nbs/03_rich_display.ipynb 4
import ee
from pprint import pprint
from fastcore.basics import patch
from IPython.display import HTML

# %% ../nbs/03_rich_display.ipynb 7
@patch
def __str__(self:ee.Element):
    return str(self.getInfo())

@patch
def __repr__(self:ee.Element):
    import pprint
    return pprint.pformat(self.getInfo())

# %% ../nbs/03_rich_display.ipynb 32
@patch
def _ipython_display_(self:ee.Image):
        
    viz_params = self.get('default_viz_params').getInfo()
    viz_params = viz_params or {}
    
    viz_params.setdefault('dimensions', 400)
    viz_params.setdefault('min', 0)
    viz_params.setdefault('max', 1)
    
    if 'region' not in viz_params:
        if self.geometry().isUnbounded().getInfo():
            global_region = ee.Geometry.Polygon([[[-180.0, -89.0],
                                                  [+180.0, -89.0],
                                                  [+180.0, +89.0],
                                                  [-180.0, +89.0]]], None, False)
            viz_params['region'] = global_region
        else:
            viz_params['region'] = ee.Geometry(self.geometry().getInfo())
    thumb_url = self.getThumbURL(viz_params)
    
    # TEST
    from ipytree import Tree, Node
    tree = Tree(stripes=True)
    node1 = Node('node1')
    tree.add_node(node1)

    return display(HTML(f'<img src="{thumb_url}" alt="image thumbnail">'), tree)

# %% ../nbs/03_rich_display.ipynb 41
@patch
def __add__(self:ee.Image, image2):
    return self.add(image2)

@patch
def __sub__(self:ee.Image, image2):
    return self.subtract(image2)

@patch
def __mul__(self:ee.Image, image2):
    return self.multipy(image2)

@patch
def __truediv__(self:ee.Image, image2):
    return self.divide(image2)

@patch
def __getitem__(self:ee.Image, key):
    return self.select(key)
