# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_layout.ipynb.

# %% auto 0
__all__ = ['MapWithInspector']

# %% ../nbs/02_layout.ipynb 4
from .ipyleaflet import Map
from .ipyleaflet import Inspector
import ipywidgets
from traitlets import Unicode

# %% ../nbs/02_layout.ipynb 7
class MapWithInspector(ipywidgets.VBox):
    """A panel that includes a map and Inspector widget."""
    
    def __init__(self,
                 map_obj=None,
                 **kwargs):
        if map_obj is None:
            kwargs['height'] = '300px'
            map_obj = Map(**kwargs)
        self.map = map_obj
        
        inspector_obj = Inspector(map_obj)
        self.inspector = inspector_obj
        
        output_obj = ipywidgets.Output()
        self.output = output_obj
        
        tab = ipywidgets.Tab(
            children = [self.inspector, self.output],
            titles = ['Inspector', 'Console'],
            selected_index = 1,
            #layout = {'width': '50%'}
        )
        self.tab = tab
    
        box = ipywidgets.HBox([
            self.map,
            self.tab,
        ])
        
        slider = ipywidgets.FloatSlider(min=0, max=100, readout=False, layout={'width':'100%'})
        
        def handle_slider_change(change):
            self.map.layout.width = f'{change.new}%'
            self.tab.layout.width = f'{100 - change.new}%'
        slider.observe(handle_slider_change, names='value')        
        
        if 'children' not in kwargs:
            kwargs['children'] = []
        kwargs['children'].insert(0, box)
        kwargs['children'].insert(1, slider)
        
        # Intialize the component widths
        slider.value = '50'
        
        super().__init__(**kwargs)
        
    def print(self, obj):
        with self.output:
            if isinstance(obj, str):
                print(obj)
            else:
                display(obj)
