# Supervisor

> Effortlessly run scripts when certain files change.

Supervisor is a package that watches directories for changes. When specific changes take place, it invokes commands or scripts you specify.

For example, you could watch your Downloads folder and then automatically remove image metadata.

## Installation

**Warning:** We're in the process of uploading Supervisor to PyPi. We're having issues getting it installed on the PATH properly. Until this is fixed, you can download the repo and install it in a virtualenv with `pip3 install --editable .`

## Features

- Watch directories for specific changes: `any`, `modified`, `created`, `moved`, or `deleted`
- Using the `.supervisor` configuration file, you can watch any number of directories at the same time.
- Invoke inline commands or provide a path to a script which will be invoked on each change in the directory.

## Usage

Once you've installed Supervisor, run `supervisor -c create` to create the `~/.supervisor` configuration file. It'll be populated with a comment (starting with `#`) telling you to read the README. This is the part it's referring to.

Supervisor uses lines in the configuration file to start the observer(s). Below is the syntax for a configuration line (without square brackets):

```
[event]:::[directory]:::[command/file]
```

In practice, you might watch your `Downloads/` folder for new files:

```
created:::/home/me/Downloads/:::echo "New file added"
```

### Watching multiple directories

To watch multiple directories, simply add a new line:

```
created:::/home/me/Downloads/:::echo "New file added"
delete:::/home/me/Pictures/:::echo "Picture deleted"
```

### Event Types

- `any`: Invoked on any of the following events.
- `modified`: When a file within a directory is modified.
- `created`: When a new file is added to the directory.
- `deleted`: When a file is removed from the directory.
- `moved`: When a file is moved to another place outside of the directory.

### Configuration options

There are some helper commands to make it easier to work with the `.supervisor` configuration file.

To access these arguments, pass the `-c` or `--conf` flag before. For instance, `supervisor -c create` to create a config file.

- `create`: Creates a new `~/.supervisor` file.
- `reset`: Deletes the config file and offers an option to create a new one.
- `edit`: Prompts for an editor name (e.g. `vim`) and opens it for editing.
- `delete`: Deletes the config file.
- `echo`: Prints the contents of the config file to the console.

#### Recursive walking

Invoked with: `-r, --recursive`

**BEWARE!!**

This enabled recursive checks of the filesystem. This means that watching your home directory, for instance, will watch all directories within it. If you don't use this option carefully, you could run into a nearly infinite series of observers.

**Do not use this option unless you know what you're doing.** Almost all uses of Supervisor do not need to use this option. It can be useful,  however, when you want to watch any change within a subdirectory.

For instance, we may want to know if any file within the `supervisor` project directory was changed. This includes, for instance, the `src/lib` directory.

We can add the configuration line:

```
any:::/path/to/Supervisor/:::script.sh
```

and invoke Supervisor with: `supervisor --recursive`. Then, any change within this directory is reported.

#### Logging

Invoked with: `-l, --log`

Although every change is printed to the console, you may want a log of all the events Supervisor executes. To do so, enable the `-l` flag.

Note: You cannot watch your home directory AND enable logging. This would create an infinite loop.

The log file is created at: `$HOME/supervisor.log`