# Generated by Django 3.1.6 on 2021-02-18 18:41

import multiselectfield.db.fields

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("structures", "0017_war_dec_notifications"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="notification",
            name="notification_type",
        ),
        migrations.AddField(
            model_name="notification",
            name="notif_type",
            field=models.CharField(
                db_index=True,
                default="",
                help_text="type of this notification as reported by ESI",
                max_length=100,
                verbose_name="type",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="created",
            field=models.DateTimeField(
                default=None,
                help_text="Date when this notification was first received from ESI",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_read",
            field=models.BooleanField(
                default=None,
                help_text="True when this notification has read in the eve client",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_sent",
            field=models.BooleanField(
                default=False,
                help_text="True when this notification has been forwarded to Discord",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_timer_added",
            field=models.BooleanField(
                default=False,
                help_text="True when a timer has been added for this notification",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="notification_id",
            field=models.PositiveBigIntegerField(verbose_name="id"),
        ),
        migrations.AlterField(
            model_name="webhook",
            name="notification_types",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    ("CharAppAcceptMsg", "Character joins corporation"),
                    ("CharLeftCorpMsg", "Character leaves corporation"),
                    ("MoonminingExtractionStarted", "Moonmining extraction started"),
                    ("MoonminingLaserFired", "Moonmining laser fired"),
                    (
                        "MoonminingExtractionCancelled",
                        "Moonmining extraction cancelled",
                    ),
                    ("MoonminingExtractionFinished", "Moonmining extraction finished"),
                    (
                        "MoonminingAutomaticFracture",
                        "Moonmining automatic fracture triggered",
                    ),
                    ("StructureAnchoring", "Upwell structure anchoring"),
                    ("StructureOnline", "Upwell structure went online"),
                    (
                        "StructureServicesOffline",
                        "Upwell structure services went offline",
                    ),
                    ("StructureWentHighPower", "Upwell structure went high power"),
                    ("StructureWentLowPower", "Upwell structure went low power"),
                    ("StructureUnanchoring", "Upwell structure unanchoring"),
                    ("StructureFuelAlert", "Upwell structure fuel alert"),
                    ("StructureUnderAttack", "Upwell structure is under attack"),
                    ("StructureLostShields", "Upwell structure lost shields"),
                    ("StructureLostArmor", "Upwell structure lost armor"),
                    ("StructureDestroyed", "Upwell structure destroyed"),
                    ("OwnershipTransferred", "Upwell structure ownership transferred"),
                    ("OrbitalAttacked", "Customs office attacked"),
                    ("OrbitalReinforced", "Customs office reinforced"),
                    ("TowerAlertMsg", "Starbase attacked"),
                    ("TowerResourceAlertMsg", "Starbase fuel alert"),
                    ("EntosisCaptureStarted", "Sovereignty entosis capture started"),
                    (
                        "SovCommandNodeEventStarted",
                        "Sovereignty command node event started",
                    ),
                    ("SovAllClaimAquiredMsg", "Sovereignty DED claim acknowledgment"),
                    ("SovStructureReinforced", "Sovereignty structure reinforced"),
                    ("SovStructureDestroyed", "Sovereignty structure destroyed"),
                    ("WarDeclared", "War declared"),
                    ("AllyJoinedWarAggressorMsg", "War ally joined"),
                    ("WarAdopted", "War adopted"),
                    ("WarInherited", "War inherited"),
                    ("CorpWarSurrenderMsg", "War party surrendered"),
                    ("WarRetractedByConcord", "War retracted by Concord"),
                ],
                default=[
                    "StructureAnchoring",
                    "StructureDestroyed",
                    "StructureFuelAlert",
                    "StructureLostArmor",
                    "StructureLostShields",
                    "StructureOnline",
                    "StructureServicesOffline",
                    "StructureUnderAttack",
                    "StructureWentHighPower",
                    "StructureWentLowPower",
                    "OrbitalAttacked",
                    "OrbitalReinforced",
                    "TowerAlertMsg",
                    "TowerResourceAlertMsg",
                    "SovStructureReinforced",
                    "SovStructureDestroyed",
                ],
                help_text="select which type of notifications should be forwarded to this webhook",
                max_length=704,
            ),
        ),
    ]
