# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudcheckr_cmx.api_client import ApiClient


class SAMLProvidersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_saml_provider(self, customer_id, **kwargs):  # noqa: E501
        """Creates a new SAML provider entry for this customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_saml_provider(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param CreateRequestSamlProviderRequestModel body:
        :return: SamlProviderResponseDetailModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_saml_provider_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_saml_provider_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def create_saml_provider_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Creates a new SAML provider entry for this customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_saml_provider_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param CreateRequestSamlProviderRequestModel body:
        :return: SamlProviderResponseDetailModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_saml_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `create_saml_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SamlProviderResponseDetailModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_saml_provider(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Deletes an existing SAML provider entry for this customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_saml_provider(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_saml_provider_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_saml_provider_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
            return data

    def delete_saml_provider_with_http_info(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Deletes an existing SAML provider entry for this customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_saml_provider_with_http_info(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_saml_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_saml_provider`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `delete_saml_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_saml_provider(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Get a single SAML provider by ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_saml_provider(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :return: SamlProviderResponseDetailModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_saml_provider_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_saml_provider_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
            return data

    def get_saml_provider_with_http_info(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Get a single SAML provider by ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_saml_provider_with_http_info(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :return: SamlProviderResponseDetailModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_saml_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_saml_provider`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `get_saml_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SamlProviderResponseDetailModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_saml_providers(self, customer_id, **kwargs):  # noqa: E501
        """Get all SAML providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_saml_providers(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :param str filter: filters the result by the conditions
        :return: PaginationWithCountResponseSamlProviderResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_saml_providers_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_saml_providers_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def list_saml_providers_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Get all SAML providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_saml_providers_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :param str filter: filters the result by the conditions
        :return: PaginationWithCountResponseSamlProviderResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'page_size', 'pagination_key', 'order_by', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_saml_providers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `list_saml_providers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('$orderBy', params['order_by']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationWithCountResponseSamlProviderResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_saml_provider(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Updates an existing SAML provider entry for this customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_saml_provider(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param UpdateRequestSamlProviderRequestModel body:
        :return: SamlProviderResponseDetailModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_saml_provider_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_saml_provider_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
            return data

    def update_saml_provider_with_http_info(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Updates an existing SAML provider entry for this customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_saml_provider_with_http_info(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param UpdateRequestSamlProviderRequestModel body:
        :return: SamlProviderResponseDetailModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_saml_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_saml_provider`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `update_saml_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SamlProviderResponseDetailModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
