# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudcheckr_cmx.api_client import ApiClient


class SAMLProviderRulesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_saml_provider_rule(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Creates a new SAML provider rule for the specified SAML provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_saml_provider_rule(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param CreateRequestSamlProviderRuleRequestModel body:
        :return: SamlProviderRuleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_saml_provider_rule_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_saml_provider_rule_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
            return data

    def create_saml_provider_rule_with_http_info(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Creates a new SAML provider rule for the specified SAML provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_saml_provider_rule_with_http_info(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param CreateRequestSamlProviderRuleRequestModel body:
        :return: SamlProviderRuleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_saml_provider_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `create_saml_provider_rule`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `create_saml_provider_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SamlProviderRuleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_saml_provider_rule(self, customer_id, saml_provider_id, rule_id, **kwargs):  # noqa: E501
        """Deletes a SAML provider rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_saml_provider_rule(customer_id, saml_provider_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param str rule_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_saml_provider_rule_with_http_info(customer_id, saml_provider_id, rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_saml_provider_rule_with_http_info(customer_id, saml_provider_id, rule_id, **kwargs)  # noqa: E501
            return data

    def delete_saml_provider_rule_with_http_info(self, customer_id, saml_provider_id, rule_id, **kwargs):  # noqa: E501
        """Deletes a SAML provider rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_saml_provider_rule_with_http_info(customer_id, saml_provider_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param str rule_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id', 'rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_saml_provider_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_saml_provider_rule`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `delete_saml_provider_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params or
                params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_saml_provider_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules/{ruleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_saml_provider_rules(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Get all SAML provider rules assigned to a SAML provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_saml_provider_rules(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :return: PaginationWithCountResponseSamlProviderRuleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_saml_provider_rules_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_saml_provider_rules_with_http_info(customer_id, saml_provider_id, **kwargs)  # noqa: E501
            return data

    def list_saml_provider_rules_with_http_info(self, customer_id, saml_provider_id, **kwargs):  # noqa: E501
        """Get all SAML provider rules assigned to a SAML provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_saml_provider_rules_with_http_info(customer_id, saml_provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :return: PaginationWithCountResponseSamlProviderRuleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id', 'page_size', 'pagination_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_saml_provider_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `list_saml_provider_rules`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `list_saml_provider_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationWithCountResponseSamlProviderRuleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_saml_provider_rule(self, customer_id, saml_provider_id, rule_id, **kwargs):  # noqa: E501
        """Updates a SAML provider rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_saml_provider_rule(customer_id, saml_provider_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param str rule_id: (required)
        :param UpdateRequestSamlProviderRuleRequestModel body:
        :return: SamlProviderRuleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_saml_provider_rule_with_http_info(customer_id, saml_provider_id, rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_saml_provider_rule_with_http_info(customer_id, saml_provider_id, rule_id, **kwargs)  # noqa: E501
            return data

    def update_saml_provider_rule_with_http_info(self, customer_id, saml_provider_id, rule_id, **kwargs):  # noqa: E501
        """Updates a SAML provider rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_saml_provider_rule_with_http_info(customer_id, saml_provider_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str saml_provider_id: (required)
        :param str rule_id: (required)
        :param UpdateRequestSamlProviderRuleRequestModel body:
        :return: SamlProviderRuleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'saml_provider_id', 'rule_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_saml_provider_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_saml_provider_rule`")  # noqa: E501
        # verify the required parameter 'saml_provider_id' is set
        if ('saml_provider_id' not in params or
                params['saml_provider_id'] is None):
            raise ValueError("Missing the required parameter `saml_provider_id` when calling `update_saml_provider_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params or
                params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `update_saml_provider_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'saml_provider_id' in params:
            path_params['samlProviderId'] = params['saml_provider_id']  # noqa: E501
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules/{ruleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SamlProviderRuleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
