# FigureGen input file configuration by line in file
FG_config = [
    {
        "index": 1,
        "name": "title_line",
        "desc": "Title line",
        "type": str,
        "default": "FigureGen Input File",
        "skip": True,
    },
    {
        "index": 2,
        "name": "seperator",
        "desc": "Keep comments out of first 50 columns",
        "type": str,
        "skip": True,
        "default": "12345678901234567890123456789012345678901234567890",
    },
    {
        "index": 3,
        "name": "verbosity",
        "desc": "Level of screen output.",
        "type": int,
        "default": 4,
    },
    {
        "index": 4,
        "name": "gmt_path",
        "desc": "GMT bin path.",
        "type": str,
        "default": "/gmt-4.5.18/bin/",
    },
    {
        "index": 5,
        "name": "gs_path",
        "desc": "GhostScript bin path.",
        "type": str,
        "default": "/bin/",
    },
    {
        "index": 6,
        "name": "temp_path",
        "desc": "Path where temporary files will be created.",
        "type": str,
        "default": "fg_temp",
    },
    {
        "index": 7,
        "name": "output_filename",
        "desc": "output file (base) name.",
        "type": str,
        "default": None,
    },
    {
        "index": 8,
        "name": "title",
        "desc": "Plot label flag: (1/0 to plot/not, label)",
        "type": (int, str),
        "default": (0, "Plot Title"),
    },
    {
        "index": 9,
        "name": "time_bar",
        "desc": "Time bar flag: 0 to ignore, 1 to plot time bar.",
        "type": (int, int, int, int, int, int, int),
        "default": (0, 2005, 8, 6, 19, 0, 0),
    },
    {
        "index": 10,
        "name": "west_bound",
        "desc": "Lat/lon box western longitude boundary",
        "type": float,
        "default": None,
    },
    {
        "index": 11,
        "name": "east_bound",
        "desc": "Lat/lon box eastern longitude boundary",
        "type": float,
        "default": None,
    },
    {
        "index": 12,
        "name": "south_bound",
        "desc": "Lat/lon box southern latitude boundary",
        "type": float,
        "default": None,
    },
    {
        "index": 13,
        "name": "north_bound",
        "desc": "Lat/lon box northern latitude boundary",
        "type": float,
        "default": None,
    },
    {
        "index": 14,
        "name": "f14_file",
        "desc": "Name of grid file (fort.14).",
        "type": str,
        "default": None,
    },
    {
        "index": 15,
        "name": "plot_grid",
        "desc": "Plot grid flag: 0 to ignore, 1 to plot triangular grid on figure.",
        "type": bool,
        "default": False,
    },
    {
        "index": 16,
        "name": "contour",
        "desc": "Parameters for contours",
        "type": dict,
        "default": "PARAMETERS FOR CONTOURS:",
        "skip": True,
    },
    {
        "index": 17,
        "name": "fill",
        "desc": "0 - ignore, 1 - filled contours, 2 - differences.",
        "type": int,
        "default": 0,
    },
    {
        "index": 18,
        "name": "lines",
        "desc": "0 - ignore, 1 - lines, 2 - differences.",
        "type": int,
        "default": 0,
    },
    {
        "index": 19,
        "name": "file",
        "desc": "Name(s) of file(s) to use data for contours.",
        "type": str,
        "default": "fort.14",
    },
    {
        "index": 20,
        "name": "contour_format",
        "desc": " ".join(
            [
                "One of: ADCIRC-OUTPUT, GRID-BATH/SIZE/DECOMP-#,",
                "13-MANNING/CANOPY/TAU0/EVIS/WIND-REDUCTION(-#)",
            ]
        ),
        "type": str,
        "default": "GRID-BATH",
    },
    {
        "index": 21,
        "name": "conversion_factor",
        "desc": "Unit conversion factor for contours.",
        "type": float,
        "default": 1.00,
    },
    {
        "index": 22,
        "name": "unit_label",
        "desc": "Alphanumeric label for units after conversion.",
        "type": str,
        "default": None,
    },
    {
        "index": 23,
        "name": "palette",
        "desc": "Color palette flag: RGB, SMS(+INTERVALS), CPT(+INTERVALS).",
        "type": str,
        "default": "RGB",
    },
    {
        "index": 24,
        "name": "palette_file",
        "desc": "Name of SMS color palette.",
        "type": str,
        "default": None,
    },
    {
        "index": 25,
        "name": "contour_lines",
        "desc": " ".join(
            [
                "One of: DEFAULT, CONTOUR-LINES,",
                "GRID-BATH/SIZE/DECOMP-#. (GMT>=4.3.0).",
            ]
        ),
        "type": str,
        "default": "DEFAULT",
    },
    {
        "index": 26,
        "name": "range",
        "desc": "Minimum,maximum in contour range. FIND for data search.",
        "type": [(int, int), str],
        "default": "FIND",
    },
    {
        "index": 27,
        "name": "interval",
        "desc": "Interval in contour range.",
        "type": float,
        "default": 0.25,
    },
    {
        "index": 28,
        "name": "interval_split",
        "desc": "Times to split contour interval (higher for smoother plots).",
        "type": int,
        "default": 100,
    },
    {
        "index": 29,
        "name": "label_interval",
        "desc": "Label every xth contour line on the plot (0 for no labels).",
        "type": int,
        "default": 1,
    },
    {
        "index": 30,
        "name": "label_spacing",
        "desc": "Require contour line labels to be more than x inches apart.",
        "type": float,
        "default": 0.5,
    },
    {
        "index": 31,
        "name": "label_angle",
        "desc": "Contour line label Rotation angles, n=normal, p=parallel",
        "type": [float, str, int],
        "default": 0,
    },
    {
        "index": 32,
        "name": "label_fonts_size",
        "desc": "Font size for contour line labels.",
        "type": int,
        "default": 8,
    },
    {
        "index": 33,
        "name": "scale_label_interval",
        "desc": "Label the scale at intervals of x.",
        "type": float,
        "default": 1.0,
    },
    {
        "index": 34,
        "name": "scale_width",
        "desc": "Width (inches) of scale.",
        "type": float,
        "default": 0.25,
    },
    {
        "index": 35,
        "name": "particles",
        "desc": "Parameters for particles",
        "type": dict,
        "default": "PARAMETERS FOR PARTICLES:",
        "skip": True,
    },
    {
        "index": 36,
        "name": "plot_flag",
        "desc": "0 to ignore, N to plot every Nth particle in the file.",
        "type": int,
        "default": 0,
    },
    {
        "index": 37,
        "name": "file",
        "desc": "Name of path file to use for particles (*.pth).",
        "type": str,
        "default": None,
    },
    {
        "index": 38,
        "name": "appearance",
        "desc": " Tuple of Particle (size (pixels), pattern, color).",
        "type": (int, int, str),
        "default": (1, 0, "Brown"),
    },
    {
        "index": 39,
        "name": "vectors",
        "desc": "Parameters for vectors",
        "type": dict,
        "default": "PARAMETERS FOR VECTORS:",
        "skip": True,
    },
    {
        "index": 40,
        "name": "plot_flag",
        "desc": "0 to ignore, 1 to plot vectors.",
        "type": bool,
        "default": False,
    },
    {
        "index": 41,
        "name": "file",
        "desc": "Name of file to use for vectors (fort.64, fort.74).",
        "type": str,
        "default": "fort.74",
    },
    {
        "index": 42,
        "name": "format",
        "desc": "Vector file format flag: ADCIRC-OUTPUT",
        "type": str,
        "default": "ADCIRC-OUTPUT",
    },
    {
        "index": 43,
        "name": "unit_conversion_factor",
        "desc": "Unit conversion factor for vectors.",
        "type": float,
        "default": 1.00,
    },
    {
        "index": 44,
        "name": "units",
        "desc": "Alphanumeric label for units after conversion.",
        "type": str,
        "default": None,
    },
    {
        "index": 45,
        "name": "mag",
        "desc": "Magnitude of vector corresponding to one inch on the page.",
        "type": float,
        "default": 100.00,
    },
    {
        "index": 46,
        "name": "spacing",
        "desc": "Spacing between vectors in degrees.",
        "type": float,
        "default": 0.15,
    },
    {
        "index": 47,
        "name": "head_dims",
        "desc": "Vector head length, head width, tail width.",
        "type": (float, float, float),
        "default": (0.06, 0.04, 0.01),
    },
    {
        "index": 48,
        "name": "scale_mag",
        "desc": "Magnitude of vector scale (FIND to determind from file)",
        "type": [float, str],
        "default": "FIND",
    },
    {
        "index": 49,
        "name": "general_options",
        "desc": "General Image Options",
        "type": None,
        "default": "PARAMETERS FOR OVERALL PLOT(S):",
        "skip": True,
    },
    {
        "index": 50,
        "name": "boundaries",
        "desc": "Boundaries flag: 0 to ignore, 1 to plot roads/levees from grid.",
        "type": (int, str),
        "default": (0, "Brown"),
    },
    {
        "index": 51,
        "name": "coastline",
        "desc": " ".join(
            [
                "Coastline flag tuple of : (0/1 to ignore or plot, 1 to"
                "plot coastline w or w/o color, resolution (1[Least]-4[Most]), water"
                "bodies (1[Least]-4[Most]))."
            ]
        ),
        "type": (int, str, int, int),
        "default": (0, "White", 4, 4),
    },
    {
        "index": 52,
        "name": "track",
        "desc": " ".join(
            [
                "Dots/lines flag tuple: (0/1/2 to ignore/plot unconnected",
                "dots/plot connected line segments, external file name)",
            ]
        ),
        "type": (int, str, str),
        "default": (0, "Black", "hurrican_track.txt"),
    },
    {
        "index": 53,
        "name": "labels",
        "desc": "Labels flag: 0 to ignore, 1 to plot labels from external file.",
        "type": (int, str),
        "default": (0, "labels.txt"),
    },
    {
        "index": 54,
        "name": "logo",
        "desc": " ".join(
            [
                "Logo tuple flag: (0/1 to",
                "ignore/plot, position (TL,TR,BL,BR), width (inches), logo file)",
            ]
        ),
        "type": (int, str, float, str),
        "default": (0, "TL", 2.0, "logo.eps"),
    },
    {
        "index": 55,
        "name": "background_image",
        "desc": " ".join(
            [
                "Background images flag tuple: (0/1 to turn off/on,",
                "file name with list of geo-referenced images to plot as background).",
            ]
        ),
        "type": (int, str),
        "default": (0, "backround_images.txt"),
    },
    {
        "index": 56,
        "name": "plot_width",
        "desc": "Width (inches) of plot.",
        "type": float,
        "default": 6.00,
    },
    {
        "index": 57,
        "name": "plot_spacing",
        "desc": "Distance (inches) between edge of plot and other elements.",
        "type": float,
        "default": 0.25,
    },
    {
        "index": 58,
        "name": "border_box_spacing",
        "desc": "Alternate black/white boxes on the border at every xth degree.",
        "type": float,
        "default": 0.25,
    },
    {
        "index": 59,
        "name": "border_annotation_spacing",
        "desc": "Annotate on the border at every xth degree.",
        "type": float,
        "default": 0.5,
    },
    {
        "index": 60,
        "name": "image_trim",
        "desc": "Image trim flag: 0 to ignore, 1 to trim image close to plot.",
        "type": bool,
        "default": True,
    },
    {
        "index": 61,
        "name": "dpi_res",
        "desc": "Resolution (dpi) of images.",
        "type": int,
        "default": 300,
    },
    {
        "index": 62,
        "name": "output_format",
        "desc": "Raster file format(s): PNG, JPG, BMP, TIFF, EPS, PDF.",
        "type": str,
        "default": "JPG",
    },
    {
        "index": 63,
        "name": "kmx_opts",
        "desc": " ".join(
            [
                "Google KMZ tuple flag : (1/0 to turn off/on,",
                "transparency (0-100) of images, number of layers, time stamp of"
                "first record in 63 file for animation.)",
            ]
        ),
        "type": (int, int, int, str),
        "default": (0, 75, 2, "20050828120000"),
    },
    {
        "index": 64,
        "name": "georef",
        "desc": " ".join(
            [
                "Flag tuple for georeferencing: (0/1/2 ",
                "ignore/images/zipped images, lowermost layer (or 0 to optimize).",
            ]
        ),
        "type": (int, int),
        "default": (0, 0),
    },
    {
        "index": 65,
        "name": "num_records",
        "desc": "Number of records for which to produce images (or 0 for all).",
        "type": int,
        "default": 0,
    },
    {
        "index": 66,
        "name": "records_list",
        "desc": "List of records (ignored if the number of records is 0).",
        "type": int,
        "default": 0,
    },
]
