#  -------------------------------------------------------------------------
#  pyCGNS.VAL - Python package for CFD General Notation System - VALidater
#  See license.txt file in the root directory of this Python module source  
#  -------------------------------------------------------------------------
#
from __future__ import unicode_literals
import CGNS.VAL.parse.messages as CGM

messagetable=(
('S0101',CGM.CHECK_FAIL,'Unknown ZoneType value'),
('S0102',CGM.CHECK_FAIL,'Unknown SimulationType value'),
('S0103',CGM.CHECK_FAIL,'Unknown GridLocation value'),
('S0104',CGM.CHECK_FAIL,'Unknown GridConnectivityType value'),
('S0105',CGM.CHECK_FAIL,'Unknown DataClass value'),
('S0106',CGM.CHECK_FAIL,'Unknown BCDataType value'),
('S0107',CGM.CHECK_FAIL,'Unknown RigidMotionType value'),
('S0108',CGM.CHECK_FAIL,'Unknown BCType value'),
('S0109',CGM.CHECK_FAIL,'Unknown ElementType value'),
('S0110',CGM.CHECK_FAIL,'Unknown MassUnit value'),
('S0111',CGM.CHECK_FAIL,'Unknown LengthUnit value'),
('S0112',CGM.CHECK_FAIL,'Unknown TimeUnit value'),
('S0113',CGM.CHECK_FAIL,'Unknown TemperatureUnit value'),
('S0114',CGM.CHECK_FAIL,'Unknown AngleUnit value'),
('S0115',CGM.CHECK_FAIL,'Unknown ElectricCurrentUnit value'),
('S0116',CGM.CHECK_FAIL,'Unknown SubstanceAmountUnit value'),
('S0117',CGM.CHECK_FAIL,'Unknown LuminousIntensityUnit value'),
('S0118',CGM.CHECK_FAIL,'Unknown ArbitraryMotionType value'),
('S0119',CGM.CHECK_FAIL,'Unknown PointSetType value'),
('S0120',CGM.CHECK_FAIL,'Name [%s] is reserved for a child of type [%s]'),
('S0121',CGM.CHECK_WARN,'Name [%s] is not known as a CGNS/SIDS identifier'),
('S0122',CGM.CHECK_FAIL,'Name [%s] is not authorized for a node of type [%s], should be in list [%s]'),
('S0123',CGM.CHECK_WARN,'Default [%s] is set to [%s]'),

('S0150',CGM.CHECK_WARN,'No default DataClass set'),
('S0151',CGM.CHECK_WARN,'Default GridLocation is set to Vertex'),
('S0152',CGM.CHECK_WARN,'Default GridConnectivityType is set to Overset'),
('S0153',CGM.CHECK_WARN,'DataClass defined without DimensionalUnits'),
('S0154',CGM.CHECK_WARN,'Local DataClass refers to a parent DimensionalUnits'),
('S0155',CGM.CHECK_WARN,'DataArray refers to a parent DataClass'),
('S0156',CGM.CHECK_FAIL,'DimensionalExponents without DataClass'),
('S0157',CGM.CHECK_FAIL,'DimensionalExponents without DimensionalUnits'),
('S0158',CGM.CHECK_WARN,'DataConversion without DataClass'),
('S0159',CGM.CHECK_WARN,'DataConversion without DimensionalUnits'),
('S0160',CGM.CHECK_WARN,'DataConversion without DimensionalExponents'),
('S0161',CGM.CHECK_FAIL,'DataClass requires DimensionalUnits'),
('S0162',CGM.CHECK_WARN,'DataClass does not require DimensionalUnits'),
('S0163',CGM.CHECK_WARN,'DataClass does not require DimensionalExponents'),
('S0164',CGM.CHECK_FAIL,'DimensionalUnits without DataClass'),

('S0170',CGM.CHECK_FAIL,'Unknown AverageInterfaceType value'),
('S0171',CGM.CHECK_FAIL,'Unknown GeometryFormat value'),
('S0172',CGM.CHECK_FAIL,'Unknown GoverningEquationsType value'),
('S0173',CGM.CHECK_FAIL,'Unknown ThermalConductivityModelType value'),
('S0174',CGM.CHECK_FAIL,'Unknown TurbulenceClosureType value'),
('S0175',CGM.CHECK_FAIL,'Unknown ThermalConductivityModelIdentifier value'),
('S0176',CGM.CHECK_FAIL,'Unknown TurbulenceClosureIdentifier value'),
('S0177',CGM.CHECK_FAIL,'Unknown TurbulenceModelType value'),
('S0178',CGM.CHECK_FAIL,'Unknown ViscosityModelType value'),
('S0179',CGM.CHECK_FAIL,'Unknown ViscosityModelIdentifier value'),
('S0180',CGM.CHECK_FAIL,'Unknown GasModelType value'),
('S0181',CGM.CHECK_FAIL,'Unknown GasModelIdentifier value'),
('S0182',CGM.CHECK_FAIL,'Unknown ThermalRelaxationModelType value'),
('S0183',CGM.CHECK_FAIL,'Unknown ChemicalKineticsModelType value'),
('S0184',CGM.CHECK_FAIL,'Unknown ChemicalKineticsModelIdentifier value'),
('S0185',CGM.CHECK_FAIL,'Unknown EMElectricFieldModelType value'),
('S0186',CGM.CHECK_FAIL,'Unknown EMMagneticFieldModelType value'),
('S0187',CGM.CHECK_FAIL,'Unknown EMConductivityModelType value'),
('S0188',CGM.CHECK_FAIL,'Unknown EMConductivityModelIdentifier value'),
('S0189',CGM.CHECK_FAIL,'Unknown BCTypeSimple value'),
('S0190',CGM.CHECK_FAIL,'Unknown BCTypeCompound value'),
('S0191',CGM.CHECK_FAIL,'Bad node value shape'),
('S0192',CGM.CHECK_FAIL,'Unexpected shape [%s] instead of [%s] for [%s]'),
('S0193',CGM.CHECK_FAIL,'Missing required node of type [%s] in [%s]'),
('S0194',CGM.CHECK_FAIL,'Missing required node of name [%s]'),
('S0195',CGM.CHECK_FAIL,'Bad child node value shape [%s]'),
('S0196',CGM.CHECK_FAIL,'Bad child node value datatype [%s]'),
('S0197',CGM.CHECK_FAIL,'Inconsistent child node value [%s]'),
('S0198',CGM.CHECK_FAIL,'Missing child [%s] in case child [%s] present'),
('S0199',CGM.CHECK_FAIL,'DataType [%s] not allowed for this node, expected type among [%s]'),

('S0201',CGM.CHECK_FAIL,'Inconsistent PhysicalDimension/CellDimension'),
('S0202',CGM.CHECK_FAIL,'Bad value for CellDimension'),
('S0203',CGM.CHECK_FAIL,'Bad value for PhysicalDimension'),
('S0204',CGM.CHECK_FAIL,'Bad Transform values'),
('S0205',CGM.CHECK_FAIL,'Bad ElementSizeBoundary value'),

('S0206',CGM.CHECK_FAIL,'Values out of range'),
('S0207',CGM.CHECK_WARN,'Values not ordered'),
('S0208',CGM.CHECK_WARN,'Values appear several times in list'),

('S0209',CGM.CHECK_FAIL,'Bad combination of ElementRange values'),
('S0210',CGM.CHECK_WARN,'[%s] suitable for face Elements only'),
('S0211',CGM.CHECK_FAIL,'Values out of range for GridLocation [%s], index [%s/%s], accepted range within [%s]'),
('S0212',CGM.CHECK_FAIL,'Unvalid element at position [%s] for [%s] face type'),
('S0213',CGM.CHECK_FAIL,'Bad [%s] face position [%s] for parent element [%s]'),
('S0214',CGM.CHECK_FAIL,'ParentElements child required together with ParentElementsPosition'),
('S0215',CGM.CHECK_FAIL,'GridLocation [%s] not valid for CellDimension [%s] and RegionCellDimension [%s]'),
('S0216',CGM.CHECK_FAIL,'GridLocation [%s] not valid'),
('S0217',CGM.CHECK_FAIL,'Values out of range, index [%s/%s], accepted range within [%s]'),
('S0218',CGM.CHECK_FAIL,'GridLocation [%s] not valid for [%s] node, required among [%s]'),
('S0219',CGM.CHECK_FAIL,'A face is expected'),
('S0220',CGM.CHECK_FAIL,'Prohibited (0,0) adjacent cell couples for face elements [%s]'),

('S0221',CGM.CHECK_WARN,'BCType is [%s]'),
('S0222',CGM.CHECK_FAIL,'Both PointRange and PointList children is not allowed'),
('S0223',CGM.CHECK_FAIL,'PointRange or PointList child is mandatory'),
('S0224',CGM.CHECK_FAIL,'One and only one of these children is mandatory: %s'),

('S0230',CGM.CHECK_FAIL,'Bad [%s] values, expected [%s]'),

('S0260',CGM.CHECK_FAIL,'GridCoordinates node has no coordinate array'),
('S0261',CGM.CHECK_FAIL,'Coordinates number different from PhysicalDimension'),
('S0262',CGM.CHECK_FAIL,'Size of coordinates different from zone DataSize (VertexSize if no Rind)'),
('S0263',CGM.CHECK_FAIL,'Unable to identify coordinate system from names'),
('S0264',CGM.CHECK_FAIL,'Coordinate name not allowed for 1D system'),
('S0265',CGM.CHECK_FAIL,'Coordinate name not allowed for 2D system'),
('S0266',CGM.CHECK_FAIL,'Coordinate name not allowed for 3D system'),

('S0270',CGM.CHECK_WARN,'Descriptor contains non-printable or non-ascii chars'),
('S0271',CGM.CHECK_WARN,'Descriptor is empty (no data)'),

('S0280',CGM.CHECK_FAIL,'DiffusionModel should have a value'),
('S0281',CGM.CHECK_FAIL,'DiffusionModel value should have dimension of %d'),
('S0282',CGM.CHECK_FAIL,'DiffusionModel value should contain only 0s or 1s'),

('S0300',CGM.CHECK_FAIL,'FamilyName is empty'),
('S0301',CGM.CHECK_FAIL,'Reference to unknown family [%s]'),
('S0302',CGM.CHECK_FAIL,'Reference to unknown additional family [%s]'),
('S0303',CGM.CHECK_WARN,'Family is never referenced'),
('S0304',CGM.CHECK_FAIL,'FamilyName_t child is mandatory for FamilySpecified BC'),
('S0305',CGM.CHECK_WARN,'FamilyBC_t node should have FamilyBC name'),

('S0400',CGM.CHECK_FAIL,'Cannot get connectivity donor zone'),
('S0401',CGM.CHECK_FAIL,'Connectivity donor zone [%s] not found'),

('S0501',CGM.CHECK_FAIL,'Reference to unknown node [%s] in [%s]'),
('S0502',CGM.CHECK_FAIL,'Bad iteration number [%s]'),
('S0503',CGM.CHECK_FAIL,'Name [%s] is reserved for time-dependant pointers'),
('S0504',CGM.CHECK_FAIL,'Name [%s] is reserved for ConvergenceHistory'),

('S0600',CGM.CHECK_WARN,'CGNSTree has no CGNSBase'),
('S0601',CGM.CHECK_WARN,'CGNSBase has no Zone'),
('S0602',CGM.CHECK_FAIL,'Zone has no GridCoordinates'),
('S0603',CGM.CHECK_FAIL,'No GridCoordinates_t of name GridCoordinates in zone'),
('S0604',CGM.CHECK_WARN,'ZoneBC has no BC'),
('S0605',CGM.CHECK_FAIL,'Unstructured zone has no Elements'),
('S0606',CGM.CHECK_FAIL,'ElementConnectivity child node absent'),
('S0607',CGM.CHECK_FAIL,'ElementRange child node absent'),
('S0608',CGM.CHECK_FAIL,'Structured zone should not have Elements'),
('S0609',CGM.CHECK_WARN,'ElementRange is reserved for Elements of unstructured zones'),
('S0610',CGM.CHECK_FAIL,'ElementStartOffset child node absent'),

('S0620',CGM.CHECK_FAIL,'GridConnectivity1to1 only applies to structured zones interfacing with structured donors'),
('S0621',CGM.CHECK_FAIL,'Opposite GridConnectivity1to1 not found in zone [%s]'),

('S0700',CGM.CHECK_WARN,'Faces [%s] defined as boundary regarding [%s] do not belong to any BC or GridConnectivity'),
('S0701',CGM.CHECK_WARN,'Faces [%s] defined as boundary regarding [%s] belong to more than one BC and/or GridConnectivity'),
('S0702',CGM.CHECK_WARN,'Boundary [%s] face indices [%s] do not belong to any BC or GridConnectivity'),
('S0703',CGM.CHECK_WARN,'Boundary [%s] face indices [%s] belong to more than one BC and/or GridConnectivity'),
('S0704',CGM.CHECK_FAIL,'Elements [%s] declared as boundary faces regarding ElementSizeBoundary should have one adjacent cell declared 0 in ParentElements'),

('S0710',CGM.CHECK_WARN,'Node inconsistent with [%s] zone type'),

)

