"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration test for aws-cloudfront-mediastore override properties';
const mediaStoreContainerProps = {
    containerName: 'MyOwnMediaStoreContainer',
    policy: JSON.stringify({
        Version: '2012-10-17',
        Statement: [{
                Sid: 'OverridePolicy',
                Effect: 'Allow',
                Principal: '*',
                Action: 'mediastore:*',
                Resource: `arn:aws:mediastore:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:container/MyOwnMediaStoreContainer/*`,
                Condition: {
                    Bool: { "aws:SecureTransport": "true" }
                }
            }]
    })
};
const cloudFrontDistributionProps = {
    defaultBehavior: {
        viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.HTTPS_ONLY,
        allowedMethods: cloudfront.AllowedMethods.ALLOW_ALL,
        cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD
    }
};
// Instantiate construct
new lib_1.CloudFrontToMediaStore(stack, 'test-cloudfront-mediastore', {
    mediaStoreContainerProps,
    cloudFrontDistributionProps
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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