/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroFileFormat$;
import org.apache.spark.sql.avro.AvroFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf!B\u0001\u0003\u0001\ta!AD!we>4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u0007\u0011\tA!\u0019<s_*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\r\u0001i1cG\u0011(!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#G\u0007\u0002+)\u0011acF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0019\t\u0005IQ\r_3dkRLwN\\\u0005\u00035U\u0011!BR5mK\u001a{'/\\1u!\tar$D\u0001\u001e\u0015\tqB!A\u0004t_V\u00148-Z:\n\u0005\u0001j\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0004\u0002\u0011%tG/\u001a:oC2L!AJ\u0012\u0003\u000f1{wmZ5oOB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0003S>T\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\ta1+\u001a:jC2L'0\u00192mK\")\u0001\u0007\u0001C\u0001e\u00051A(\u001b8jiz\u001a\u0001\u0001F\u00014!\t!\u0004!D\u0001\u0003\u0011\u00151\u0004\u0001\"\u00118\u0003\u0019)\u0017/^1mgR\u0011\u0001h\u000f\t\u0003\u001deJ!AO\b\u0003\u000f\t{w\u000e\\3b]\")A(\u000ea\u0001{\u0005)q\u000e\u001e5feB\u0011aBP\u0005\u0003\u007f=\u00111!\u00118z\u0011\u0015\t\u0005\u0001\"\u0011C\u0003!A\u0017m\u001d5D_\u0012,G#A\"\u0011\u00059!\u0015BA#\u0010\u0005\rIe\u000e\u001e\u0005\u0006\u000f\u0002!\t\u0005S\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003J%^\u001b\u0007c\u0001\bK\u0019&\u00111j\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\u0003V\"\u0001(\u000b\u0005=#\u0011!\u0002;za\u0016\u001c\u0018BA)O\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u000f\u0019\u0003\ra\u0015\t\u0003)Vk\u0011\u0001B\u0005\u0003-\u0012\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001\u0017$A\u0002e\u000bqa\u001c9uS>t7\u000f\u0005\u0003[;\u0002\u0004gB\u0001\b\\\u0013\tav\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u00131!T1q\u0015\tav\u0002\u0005\u0002[C&\u0011!m\u0018\u0002\u0007'R\u0014\u0018N\\4\t\u000b\u00114\u0005\u0019A3\u0002\u000b\u0019LG.Z:\u0011\u0007\u0019t\u0017O\u0004\u0002hY:\u0011\u0001n[\u0007\u0002S*\u0011!.M\u0001\u0007yI|w\u000e\u001e \n\u0003AI!!\\\b\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA7\u0010!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0002gg*\u0011a\u000fC\u0001\u0007Q\u0006$wn\u001c9\n\u0005a\u001c(A\u0003$jY\u0016\u001cF/\u0019;vg\")!\u0010\u0001C!w\u0006I1\u000f[8si:\u000bW.\u001a\u000b\u0002A\")Q\u0010\u0001C!}\u0006Y\u0011n]*qY&$\u0018M\u00197f)\u0019At0a\u0001\u0002\u0006!1\u0011\u0011\u0001?A\u0002M\u000bAb\u001d9be.\u001cVm]:j_:DQ\u0001\u0017?A\u0002eCq!a\u0002}\u0001\u0004\tI!\u0001\u0003qCRD\u0007c\u0001:\u0002\f%\u0019\u0011QB:\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003#\u0001A\u0011IA\n\u00031\u0001(/\u001a9be\u0016<&/\u001b;f))\t)\"a\u0007\u0002\u001e\u00055\u0012q\u0006\t\u0004)\u0005]\u0011bAA\r+\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\"1q!a\u0004A\u0002MC\u0001\"a\b\u0002\u0010\u0001\u0007\u0011\u0011E\u0001\u0004U>\u0014\u0007\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dR/A\u0005nCB\u0014X\rZ;dK&!\u00111FA\u0013\u0005\rQuN\u0019\u0005\u00071\u0006=\u0001\u0019A-\t\u000f\u0005E\u0012q\u0002a\u0001\u0019\u0006QA-\u0019;b'\u000eDW-\\1\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\u0005Y!-^5mIJ+\u0017\rZ3s)A\tI$a\u0016\u0002Z\u0005m\u0013qLA2\u0003_\n\t\bE\u0004\u000f\u0003w\ty$!\u0012\n\u0007\u0005urBA\u0005Gk:\u001cG/[8ocA\u0019A#!\u0011\n\u0007\u0005\rSCA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u00151\u0017qIA&\u0013\r\tI\u0005\u001d\u0002\t\u0013R,'/\u0019;peB!\u0011QJA*\u001b\t\tyEC\u0002\u0002R\u0011\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003+\nyEA\u0006J]R,'O\\1m%><\bBB\u0004\u00024\u0001\u00071\u000bC\u0004\u00022\u0005M\u0002\u0019\u0001'\t\u000f\u0005u\u00131\u0007a\u0001\u0019\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\rC\u0004\u0002b\u0005M\u0002\u0019\u0001'\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"A\u0011QMA\u001a\u0001\u0004\t9'A\u0004gS2$XM]:\u0011\t\u0019t\u0017\u0011\u000e\t\u00049\u0005-\u0014bAA7;\t1a)\u001b7uKJDa\u0001WA\u001a\u0001\u0004I\u0006\u0002CA:\u0003g\u0001\r!!\u001e\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY(^\u0001\u0005G>tg-\u0003\u0003\u0002\u0000\u0005e$!D\"p]\u001aLw-\u001e:bi&|gn\u0002\u0005\u0002\u0004\nA\tAAAC\u00039\teO]8GS2,gi\u001c:nCR\u00042\u0001NAD\r\u001d\t!\u0001#\u0001\u0003\u0003\u0013\u001bR!a\"\u000e\u0003\u0017\u00032ADAG\u0013\tqs\u0002C\u00041\u0003\u000f#\t!!%\u0015\u0005\u0005\u0015\u0005BCAK\u0003\u000f\u0013\r\u0011\"\u0001\u0002\u0018\u0006\u0019\u0013j\u001a8pe\u00164\u0015\u000e\\3t/&$\bn\\;u\u000bb$XM\\:j_:\u0004&o\u001c9feRLXCAAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAPW\u0005!A.\u00198h\u0013\r\u0011\u0017Q\u0014\u0005\n\u0003K\u000b9\t)A\u0005\u00033\u000bA%S4o_J,g)\u001b7fg^KG\u000f[8vi\u0016CH/\u001a8tS>t\u0007K]8qKJ$\u0018\u0010\t\u0005\u000b\u0003S\u000b9)!A\u0005\n\u0005-\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!,\u0011\t\u0005m\u0015qV\u0005\u0005\u0003c\u000biJ\u0001\u0004PE*,7\r\u001e")
public class AvroFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String IgnoreFilesWithoutExtensionProperty() {
        return AvroFileFormat$.MODULE$.IgnoreFilesWithoutExtensionProperty();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.class.vectorTypes((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.class.supportDataType((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public boolean equals(Object other) {
        Object object = other;
        boolean bl = object instanceof AvroFileFormat;
        return bl;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public Option<StructType> inferSchema(SparkSession spark, Map<String, String> options, Seq<FileStatus> files) {
        void var7_8;
        Configuration conf = spark.sessionState().newHadoopConf();
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        FileStatus sampleFile = parsedOptions.ignoreExtension() ? (FileStatus)files.headOption().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new FileNotFoundException("Files for schema inferring have been not found.");
            }
        }) : (FileStatus)files.find((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.getPath().getName().endsWith(".avro");
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
            }
        });
        Schema.Parser parser = new Schema.Parser();
        Schema avroSchema = (Schema)parsedOptions.schema().map((Function1)new scala.Serializable(this, parser){
            public static final long serialVersionUID = 0L;
            private final Schema.Parser eta$0$1$1;

            public final Schema apply(String x$1) {
                return this.eta$0$1$1.parse(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }).getOrElse((Function0)new scala.Serializable(this, conf, sampleFile){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            private final FileStatus sampleFile$1;

            /*
             * Loose catch block
             * WARNING - void declaration
             */
            public final Schema apply() {
                FsInput in = new FsInput(this.sampleFile$1.getPath(), this.conf$1);
                FileReader reader = DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader());
                Schema schema = reader.getSchema();
                reader.close();
                in.close();
                return schema;
                {
                    catch (Throwable throwable) {
                        try {
                            void var3_2;
                            var3_2.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            void var1_1;
                            var1_1.close();
                            throw throwable2;
                        }
                    }
                }
            }
            {
                this.conf$1 = conf$1;
                this.sampleFile$1 = sampleFile$1;
            }
        });
        DataType dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Some some = new Some((Object)structType);
            return some;
        }
        throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_8.toString(true)})))).stripMargin());
    }

    public String shortName() {
        return "avro";
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public OutputWriterFactory prepareWrite(SparkSession spark, Job job, Map<String, String> options, StructType dataSchema) {
        String string;
        block6: {
            Schema outputAvroSchema;
            block3: {
                String string2;
                block5: {
                    block4: {
                        AvroOptions parsedOptions;
                        block2: {
                            parsedOptions = new AvroOptions(options, spark.sessionState().newHadoopConf());
                            Schema.Parser parser = new Schema.Parser();
                            outputAvroSchema = (Schema)parsedOptions.schema().map((Function1)new scala.Serializable(this, parser){
                                public static final long serialVersionUID = 0L;
                                private final Schema.Parser eta$0$2$1;

                                public final Schema apply(String x$1) {
                                    return this.eta$0$2$1.parse(x$1);
                                }
                                {
                                    this.eta$0$2$1 = eta$0$2$1;
                                }
                            }).getOrElse((Function0)new scala.Serializable(this, dataSchema, parsedOptions){
                                public static final long serialVersionUID = 0L;
                                private final StructType dataSchema$1;
                                private final AvroOptions parsedOptions$1;

                                public final Schema apply() {
                                    return SchemaConverters$.MODULE$.toAvroType((DataType)this.dataSchema$1, false, this.parsedOptions$1.recordName(), this.parsedOptions$1.recordNamespace());
                                }
                                {
                                    this.dataSchema$1 = dataSchema$1;
                                    this.parsedOptions$1 = parsedOptions$1;
                                }
                            });
                            AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
                            String string3 = parsedOptions.compression();
                            String string4 = "uncompressed";
                            if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                            job.getConfiguration().setBoolean("mapred.output.compress", false);
                            break block3;
                        }
                        job.getConfiguration().setBoolean("mapred.output.compress", true);
                        this.logInfo((Function0<String>)new scala.Serializable(this, parsedOptions){
                            public static final long serialVersionUID = 0L;
                            private final AvroOptions parsedOptions$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compressing Avro output using the ", " codec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parsedOptions$1.compression()}));
                            }
                            {
                                this.parsedOptions$1 = parsedOptions$1;
                            }
                        });
                        string = parsedOptions.compression();
                        if (!"deflate".equals(string)) break block4;
                        int deflateLevel = spark.sessionState().conf().avroDeflateLevel();
                        this.logInfo((Function0<String>)new scala.Serializable(this, deflateLevel){
                            public static final long serialVersionUID = 0L;
                            private final int deflateLevel$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Avro compression level ", " will be used for ", " codec."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.deflateLevel$1), "deflate"}));
                            }
                            {
                                this.deflateLevel$1 = deflateLevel$1;
                            }
                        });
                        job.getConfiguration().setInt("avro.mapred.deflate.level", deflateLevel);
                        string2 = "deflate";
                        break block5;
                    }
                    boolean bl = "snappy".equals(string) ? true : ("bzip2".equals(string) ? true : "xz".equals(string));
                    if (!bl) break block6;
                    string2 = string;
                }
                String codec = string2;
                job.getConfiguration().set("avro.output.codec", codec);
            }
            return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString());
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid compression codec: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession spark, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        AvroOptions parsedOptions = new AvroOptions(options, hadoopConf);
        return new scala.Serializable(this, requiredSchema, broadcastedConf, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroFileFormat $outer;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedConf$1;
            private final AvroOptions parsedOptions$2;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Iterator<InternalRow> apply(PartitionedFile file) {
                FileReader reader;
                Iterator iterator;
                Configuration conf = ((SerializableConfiguration)this.broadcastedConf$1.value()).value();
                Schema.Parser parser = new Schema.Parser();
                Option userProvidedSchema = this.parsedOptions$2.schema().map((Function1)new scala.Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final Schema.Parser eta$0$3$1;

                    public final Schema apply(String x$1) {
                        return this.eta$0$3$1.parse(x$1);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                });
                if (!this.parsedOptions$2.ignoreExtension() && !file.filePath().endsWith(".avro")) {
                    iterator = package$.MODULE$.Iterator().empty();
                    return iterator;
                }
                FsInput in = new FsInput(new Path(new URI(file.filePath())), conf);
                try {
                    GenericDatumReader genericDatumReader;
                    Option option = userProvidedSchema;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Schema userSchema = (Schema)some.x();
                        genericDatumReader = new GenericDatumReader(userSchema);
                    } else {
                        genericDatumReader = new GenericDatumReader();
                    }
                    GenericDatumReader datumReader = genericDatumReader;
                    reader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.logError((Function0<String>)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Exception while opening DataFileReader";
                        }
                    }, e);
                    in.close();
                    throw e;
                }
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new scala.Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    public final FileReader reader$1;

                    public final TaskContext apply(TaskContext taskContext) {
                        return taskContext.addTaskCompletionListener((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$2) {
                                this.$outer.reader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                });
                reader.sync(file.start());
                long stop = file.start() + file.length();
                AvroDeserializer deserializer = new AvroDeserializer((Schema)userProvidedSchema.getOrElse((Function0)new scala.Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    private final FileReader reader$1;

                    public final Schema apply() {
                        return this.reader$1.getSchema();
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                }), (DataType)this.requiredSchema$1);
                iterator = new Iterator<InternalRow>(this, reader, stop, deserializer){
                    private boolean completed;
                    private final FileReader reader$1;
                    private final long stop$1;
                    private final AvroDeserializer deserializer$1;

                    public Iterator<InternalRow> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<InternalRow> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<InternalRow, U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<InternalRow, Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<InternalRow, Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<InternalRow> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.class.grouped((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<InternalRow> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<InternalRow> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<InternalRow> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<InternalRow> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<InternalRow, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<InternalRow> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<InternalRow> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<InternalRow> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<InternalRow> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<InternalRow> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<InternalRow, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public boolean hasNext() {
                        boolean bl;
                        if (this.completed) {
                            bl = false;
                        } else {
                            void var1_1;
                            boolean r;
                            boolean bl2 = r = this.reader$1.hasNext() && !this.reader$1.pastSync(this.stop$1);
                            if (!r) {
                                this.reader$1.close();
                                this.completed = true;
                            }
                            bl = var1_1;
                        }
                        return bl;
                    }

                    public InternalRow next() {
                        if (this.hasNext()) {
                            GenericRecord record = (GenericRecord)this.reader$1.next();
                            return (InternalRow)this.deserializer$1.deserialize(record);
                        }
                        throw new NoSuchElementException("next on empty iterator");
                    }
                    {
                        this.reader$1 = reader$1;
                        this.stop$1 = stop$1;
                        this.deserializer$1 = deserializer$1;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                        this.completed = false;
                    }
                };
                return iterator;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedConf$1 = broadcastedConf$1;
                this.parsedOptions$2 = parsedOptions$2;
            }
        };
    }

    public AvroFileFormat() {
        FileFormat.class.$init$((FileFormat)this);
        Logging.class.$init$((Logging)this);
    }
}

