# coding: utf-8

"""
    Sematext Cloud API

    API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.  # noqa: E501

    OpenAPI spec version: v3

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from stcloud.api_client import ApiClient


class AppsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_app_types_using_get(self, **kwargs):  # noqa: E501
        """Get all App types supported for the account identified with apiKey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_app_types_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_app_types_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_app_types_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_app_types_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all App types supported for the account identified with apiKey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_app_types_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_app_types_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_using_get(self, any_state_app_id, **kwargs):  # noqa: E501
        """Gets defails for one particular App  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_using_get(any_state_app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int any_state_app_id: anyStateAppId (required)
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_using_get_with_http_info(any_state_app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_using_get_with_http_info(any_state_app_id, **kwargs)  # noqa: E501
            return data

    def get_using_get_with_http_info(self, any_state_app_id, **kwargs):  # noqa: E501
        """Gets defails for one particular App  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_using_get_with_http_info(any_state_app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int any_state_app_id: anyStateAppId (required)
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['any_state_app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'any_state_app_id' is set
        if ('any_state_app_id' not in params
                or params['any_state_app_id'] is None):
            raise ValueError("Missing the required parameter `any_state_app_id` when calling `get_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'any_state_app_id' in params:
            path_params['anyStateAppId'] = params['any_state_app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{anyStateAppId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invite_app_guests_using_post(self, invitation, **kwargs):  # noqa: E501
        """Invite guests to an app  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invite_app_guests_using_post(invitation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Invitation invitation: For `app` and `apps` fields only `id` needs to be populated.Other fields can be left empty or with default values (required)
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invite_app_guests_using_post_with_http_info(invitation, **kwargs)  # noqa: E501
        else:
            (data) = self.invite_app_guests_using_post_with_http_info(invitation, **kwargs)  # noqa: E501
            return data

    def invite_app_guests_using_post_with_http_info(self, invitation, **kwargs):  # noqa: E501
        """Invite guests to an app  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invite_app_guests_using_post_with_http_info(invitation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Invitation invitation: For `app` and `apps` fields only `id` needs to be populated.Other fields can be left empty or with default values (required)
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invitation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invite_app_guests_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invitation' is set
        if ('invitation' not in params
                or params['invitation'] is None):
            raise ValueError("Missing the required parameter `invitation` when calling `invite_app_guests_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invitation' in params:
            body_params = params['invitation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/guests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_apps_users_using_get(self, **kwargs):  # noqa: E501
        """Get all users of apps accessible to this account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_apps_users_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_apps_users_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_apps_users_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_apps_users_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all users of apps accessible to this account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_apps_users_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_apps_users_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_using_get(self, **kwargs):  # noqa: E501
        """Get all apps accessible by account identified with apiKey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all apps accessible by account identified with apiKey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_description_using_put(self, any_state_app_id, **kwargs):  # noqa: E501
        """Update description of the app  # noqa: E501

        App can be in any state  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_description_using_put(any_state_app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int any_state_app_id: App Id (required)
        :param AppDescription update_details: Update Details
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_description_using_put_with_http_info(any_state_app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_description_using_put_with_http_info(any_state_app_id, **kwargs)  # noqa: E501
            return data

    def update_description_using_put_with_http_info(self, any_state_app_id, **kwargs):  # noqa: E501
        """Update description of the app  # noqa: E501

        App can be in any state  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_description_using_put_with_http_info(any_state_app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int any_state_app_id: App Id (required)
        :param AppDescription update_details: Update Details
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['any_state_app_id', 'update_details']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_description_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'any_state_app_id' is set
        if ('any_state_app_id' not in params
                or params['any_state_app_id'] is None):
            raise ValueError("Missing the required parameter `any_state_app_id` when calling `update_description_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'any_state_app_id' in params:
            path_params['anyStateAppId'] = params['any_state_app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_details' in params:
            body_params = params['update_details']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{anyStateAppId}/description', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_using_put1(self, dto, any_state_app_id, **kwargs):  # noqa: E501
        """Update app  # noqa: E501

        App can be in any state  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_using_put1(dto, any_state_app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAppInfo dto: dto (required)
        :param int any_state_app_id: App Id (required)
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_using_put1_with_http_info(dto, any_state_app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_using_put1_with_http_info(dto, any_state_app_id, **kwargs)  # noqa: E501
            return data

    def update_using_put1_with_http_info(self, dto, any_state_app_id, **kwargs):  # noqa: E501
        """Update app  # noqa: E501

        App can be in any state  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_using_put1_with_http_info(dto, any_state_app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAppInfo dto: dto (required)
        :param int any_state_app_id: App Id (required)
        :return: GenericApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dto', 'any_state_app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_using_put1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dto' is set
        if ('dto' not in params
                or params['dto'] is None):
            raise ValueError("Missing the required parameter `dto` when calling `update_using_put1`")  # noqa: E501
        # verify the required parameter 'any_state_app_id' is set
        if ('any_state_app_id' not in params
                or params['any_state_app_id'] is None):
            raise ValueError("Missing the required parameter `any_state_app_id` when calling `update_using_put1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'any_state_app_id' in params:
            path_params['anyStateAppId'] = params['any_state_app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dto' in params:
            body_params = params['dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{anyStateAppId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
