"""Constants used by yggdrasil."""


# ======================================================
# Do not edit this file past this point as the following
# is generated by yggdrasil.schema.update_constants
# ======================================================

LANG2EXT = {
    'R': '.R',
    'c': '.c',
    'c++': '.cpp',
    'cpp': '.cpp',
    'cxx': '.cpp',
    'executable': '.exe',
    'fortran': '.f90',
    'lpy': '.lpy',
    'matlab': '.m',
    'osr': '.xml',
    'python': '.py',
    'r': '.R',
    'sbml': '.xml',
    'yaml': '.yml',
}
EXT2LANG = {v: k for k, v in LANG2EXT.items()}
LANGUAGES = {
    'compiled': [
        'c', 'c++', 'fortran'],
    'interpreted': [
        'R', 'matlab', 'python'],
    'build': [
        'cmake', 'make'],
    'dsl': [
        'lpy', 'osr', 'sbml'],
    'other': [
        'executable', 'function', 'timesync'],
}
LANGUAGES['all'] = (
    LANGUAGES['compiled']
    + LANGUAGES['interpreted']
    + LANGUAGES['build']
    + LANGUAGES['dsl']
    + LANGUAGES['other'])
LANGUAGES_WITH_ALIASES = {
    'compiled': [
        'c', 'c++', 'cpp', 'cxx', 'fortran'],
    'interpreted': [
        'R', 'r', 'matlab', 'python'],
    'build': [
        'cmake', 'make'],
    'dsl': [
        'lpy', 'osr', 'sbml'],
    'other': [
        'executable', 'function', 'timesync'],
}
LANGUAGES_WITH_ALIASES['all'] = (
    LANGUAGES_WITH_ALIASES['compiled']
    + LANGUAGES_WITH_ALIASES['interpreted']
    + LANGUAGES_WITH_ALIASES['build']
    + LANGUAGES_WITH_ALIASES['dsl']
    + LANGUAGES_WITH_ALIASES['other'])
COMPILER_ENV_VARS = {
    'c': {
        'exec': 'CC',
        'flags': 'CFLAGS',
    },
    'c++': {
        'exec': 'CXX',
        'flags': 'CXXFLAGS',
    },
    'fortran': {
        'exec': 'FC',
        'flags': 'FFLAGS',
    },
}
COMPILATION_TOOL_VARS = {
    'LIB': {
        'exec': None,
        'flags': None,
    },
    'LINK': {
        'exec': 'LINK',
        'flags': 'LDFLAGS',
    },
    'ar': {
        'exec': 'AR',
        'flags': None,
    },
    'cl': {
        'exec': 'CC',
        'flags': 'CFLAGS',
    },
    'cl++': {
        'exec': 'CXX',
        'flags': 'CXXFLAGS',
    },
    'clang': {
        'exec': 'CC',
        'flags': 'CFLAGS',
    },
    'clang++': {
        'exec': 'CXX',
        'flags': 'CXXFLAGS',
    },
    'cmake': {
        'exec': None,
        'flags': None,
    },
    'g++': {
        'exec': 'CXX',
        'flags': 'CXXFLAGS',
    },
    'gcc': {
        'exec': 'CC',
        'flags': 'CFLAGS',
    },
    'gfortran': {
        'exec': 'FC',
        'flags': 'FFLAGS',
    },
    'ld': {
        'exec': 'LD',
        'flags': 'LDFLAGS',
    },
    'libtool': {
        'exec': 'LIBTOOL',
        'flags': None,
    },
    'make': {
        'exec': None,
        'flags': None,
    },
    'nmake': {
        'exec': None,
        'flags': None,
    },
}
