#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['apio', 'apio.commands', 'apio.managers']

package_data = \
{'': ['*'], 'apio': ['resources/*', 'resources/ecp5/*', 'resources/ice40/*']}

install_requires = \
['click',
 'semantic_version>=2.5.0,<3',
 'requests>=2.4.0,<3',
 'pyjwt>=1.5.3,<2',
 'colorama',
 'pyserial>=3,<4',
 'wheel>=0.35.0,<1']

extras_require = \
{'extra': ['blackiceprog>=2.0.0,<3.0.0',
           'litterbox>=0.2.1,<0.3.0',
           'tinyfpgab>=1.1.0,<1.2.0',
           'tinyprog>=1.0.21,<1.1.0',
           'icefunprog>=2.0.3,<3.0.0']}

entry_points = \
{'console_scripts': ['apio = apio.__main__:cli']}

setup(name='apio',
      version='0.6.6',
      description='Open source ecosystem for open FPGA boards',
      author='Jesus Arroyo',
      author_email='jesus.jkhlg@gmail.com ',
      url='https://github.com/FPGAwars/apio',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
