"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const alarm_state_1 = require("../../common/alarm-state");
const calendar_state_1 = require("./calendar-state");
const pipeline_state_1 = require("./pipeline-state");
exports.handler = async (event, context) => {
    const pipelineName = event.pipelineName;
    const stageName = event.stageName;
    const calendarState = await calendar_state_1.getCalendarState(event.calendar.calendarName);
    const stageState = await pipeline_state_1.getStageState(pipelineName, stageName);
    const alarmState = await alarm_state_1.getAggregateAlarmState(event.searchTerms);
    const input = {
        pipelineName: pipelineName,
        stageName: stageName,
        transitionType: 'Inbound',
    };
    if (calendarState.state === 'OPEN' && alarmState.state === 'OK') {
        console.log(`Enabling transition: ${JSON.stringify(input, null, 2)}`);
        await pipeline_state_1.enableStageTransition(input, context.functionName, stageState);
    }
    else {
        // If in ALARM, use that as the reason instead of the calendar.
        const reason = alarmState.state === 'ALARM' ? alarmState.summary : calendarState.summary;
        const disableInput = { ...input, reason };
        console.log(`Disabling transition: ${JSON.stringify(disableInput, null, 2)}`);
        await pipeline_state_1.disableStageTransition(disableInput, context.functionName, stageState);
    }
};
//# sourceMappingURL=data:application/json;base64,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